Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:55 2016
FILE NAME: cloud_mars_h2o.f90
PROGRAM NAME: cloud_mars_h2o
DIAGNOSTIC LIST

  LINE  LEVEL( NO.): DIAGNOSTIC MESSAGE

   143  opt  (1593): Loop nest collapsed into one loop.
   143  vec  (   4): Vectorized array expression.
   143  vec  (  29): ADB is used for array.: xyz_qh2osol
   143  vec  (  29): ADB is used for array.: xyz_dqh2osoldtlsc
   143  vec  (  29): ADB is used for array.: xyz_dqh2osoldtcum
   147  opt  (  11): Fused array assignments. :line 147 - 148
   147  opt  (1593): Loop nest collapsed into one loop.
   147  vec  (   4): Vectorized array expression.
   147  vec  (  29): ADB is used for array.: xy_snow
   147  vec  (  29): ADB is used for array.: xy_rain
   159  opt  (1593): Loop nest collapsed into one loop.
   159  vec  (   4): Vectorized array expression.
   159  vec  (  29): ADB is used for array.: xy_snow
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:55 2016
FILE NAME: cloud_mars_h2o.f90
PROGRAM NAME: cloud_mars_h2o
TRANSFORMATION LIST

  LINE                   FORTRAN STATEMENT

     1  != 火星 H2O 雲モデル
     2  !
     3  != Mars H2O cloud model
     4  !
     5  ! Authors::   Yoshiyuki O. Takahashi
     6  ! Version::   $Id: cloud_mars_h2o.f90,v 1.2 2015/01/29 12:06:42 yot Exp $
     7  ! Tag Name::  $Name:  $
     8  ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9  ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10  !
    11  
    12  module cloud_mars_h2o
    13    !
    14    != 火星 H2O 雲モデル
    15    !
    16    != Mars H2O cloud model
    17    !
    18    ! <b>Note that Japanese and English are described in parallel.</b>
    19    !
    20    !
    21    !
    22    ! In this module, H2O cloud on Mars is calculated by use of a simple
    23    ! cloud model.
    24    !
    25    !== Procedures List
    26    !
    27  !!$  ! RadiationFluxDennouAGCM :: 放射フラックスの計算
    28  !!$  ! ------------            :: ------------
    29  !!$  ! RadiationFluxDennouAGCM :: Calculate radiation flux
    30    !
    31    !== NAMELIST
    32    !
    33    ! NAMELIST#cloud_simple_nml
    34    !
    35  
    36    ! モジュール引用 ; USE statements
    37  
    38    !
    39    ! Kind type parameter
    40    !
    41    use dc_types, only: DP, &      ! Double precision.
    42      &                 STRING, &  ! Strings.
    43      &                 TOKEN      ! Keywords.
    44  
    45    ! メッセージ出力
    46    ! Message output
    47    !
    48    use dc_message, only: MessageNotify
    49  
    50    ! 格子点設定
    51    ! Grid points settings
    52    !
    53    use gridset, only: imax, & ! 経度格子点数.
    54                               ! Number of grid points in longitude
    55      &                jmax, & ! 緯度格子点数.
    56                               ! Number of grid points in latitude
    57      &                kmax    ! 鉛直層数.
    58                               ! Number of vertical level
    59  
    60    implicit none
    61  
    62    private
    63  
    64  
    65    ! 公開手続き
    66    ! Public procedure
    67    !
    68    public :: CloudMarsH2O
    69    public :: CloudMarsH2OInit
    70  
    71  
    72    ! 公開変数
    73    ! Public variables
    74    !
    75  
    76  
    77    ! 非公開変数
    78    ! Private variables
    79    !
    80  
    81    logical, save :: cloud_mars_h2o_inited = .false.
    82                                ! 初期設定フラグ.
    83                                ! Initialization flag
    84  
    85    character(*), parameter:: module_name = 'cloud_mars_h2o'
    86                                ! モジュールの名称.
    87                                ! Module name
    88    character(*), parameter:: version = &
    89      & '$Name:  $' // &
    90      & '$Id: cloud_mars_h2o.f90,v 1.2 2015/01/29 12:06:42 yot Exp $'
    91                                ! モジュールのバージョン
    92                                ! Module version
    93  
    94    !--------------------------------------------------------------------------------------
    95  
    96  contains
    97  
    98    !--------------------------------------------------------------------------------------
    99  
   100    subroutine CloudMarsH2O(                            &
   101      & xyr_Press, xyr_Height,                          & ! (in)
   102      & xyz_DQH2OSolDtCum, xyz_DQH2OSolDtLSC,           & ! (in)
   103      & xyz_QH2OSol,                                    & ! (inout)
   104      & xy_Rain, xy_Snow                                & ! (out)
   105      & )
   106  
   107      ! USE statements
   108      !
   109  
   110      ! 時刻管理
   111      ! Time control
   112      !
   113      use timeset, only: &
   114        & DelTime            ! $ \Delta t $ [s]
   115  
   116      ! 重力沈降過程
   117      ! Gravitational sedimentation process
   118      !
   119      use grav_sed, only : GravSed
   120  
   121  
   122      real(DP), intent(in   ) :: xyr_Press        ( 0:imax-1, 1:jmax, 0:kmax )
   123      real(DP), intent(in   ) :: xyr_Height       ( 0:imax-1, 1:jmax, 0:kmax )
   124      real(DP), intent(in   ) :: xyz_DQH2OSolDtCum( 0:imax-1, 1:jmax, 1:kmax )
   125      real(DP), intent(in   ) :: xyz_DQH2OSolDtLSC( 0:imax-1, 1:jmax, 1:kmax )
   126      real(DP), intent(inout) :: xyz_QH2OSol      ( 0:imax-1, 1:jmax, 1:kmax )
   127      real(DP), intent(out  ) :: xy_Rain          ( 0:imax-1, 1:jmax )
   128      real(DP), intent(out  ) :: xy_Snow          ( 0:imax-1, 1:jmax )
   129  
   130  
   131  
   132      ! 実行文 ; Executable statement
   133      !
   134  
   135      ! 初期化確認
   136      ! Initialization check
   137      !
   138      if ( .not. cloud_mars_h2o_inited ) then
   139        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   140      end if
   141  
   142  
   143      xyz_QH2OSol = xyz_QH2OSol &
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t112 = 1, kmax*jmax*imax                                       
     .           xyz_qh2osol(t112-1,1,1) = xyz_qh2osol(t112-1,1,1) + (          
     .       1      xyz_dqh2osoldtcum(t112-1,1,1)+xyz_dqh2osoldtlsc(t112-1,1,1))
     .       2      *2.00000000000000e+000*deltime                              
     .        enddo                                                             
   144        & + ( xyz_DQH2OSolDtCum + xyz_DQH2OSolDtLSC ) * 2.0_DP * DelTime
   145  
   146  
   147      xy_Rain = 0.0_DP
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t130 = 1, jmax*imax                                            
     .           xy_rain(t130-1,1) = 0.0000000000000000e+000                    
     .           xy_snow(t130-1,1) = 0.0000000000000000e+000                    
     .        enddo                                                             
   148      xy_Snow = 0.0_DP
   149  
   150      ! 重力沈降過程
   151      ! Gravitational sedimentation process
   152      !
   153      call GravSed(                          &
   154        & 'MarsH2OCloud',                    & ! (in )
   155        & xyr_Press, xyr_Height,             & ! (in )
   156        & xyz_QH2OSol,                       & ! (out)
   157        & xy_Snow                            & ! (out) optional
   158        & )
   159      xy_Snow = - xy_Snow
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t138 = 1, jmax*imax                                            
     .           xy_snow(t138-1,1) = -xy_snow(t138-1,1)                         
     .        enddo                                                             
   160  
   161  
   162    end subroutine CloudMarsH2O
   163  
   164    !--------------------------------------------------------------------------------------
   165  
   166    subroutine CloudMarsH2OInit
   167  
   168  !!$    ! ファイル入出力補助
   169  !!$    ! File I/O support
   170  !!$    !
   171  !!$    use dc_iounit, only: FileOpen
   172  !!$
   173  !!$    ! NAMELIST ファイル入力に関するユーティリティ
   174  !!$    ! Utilities for NAMELIST file input
   175  !!$    !
   176  !!$    use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid
   177  
   178      ! ヒストリデータ出力
   179      ! History data output
   180      !
   181      use gtool_historyauto, only: HistoryAutoAddVariable
   182  
   183      ! 重力沈降過程
   184      ! Gravitational sedimentation process
   185      !
   186      use grav_sed, only : GravSedInit
   187  
   188      ! 宣言文 ; Declaration statements
   189      !
   190  
   191  !!$    integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号.
   192  !!$                              ! Unit number for NAMELIST file open
   193  !!$    integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT.
   194  !!$                              ! IOSTAT of NAMELIST read
   195  
   196      ! NAMELIST 変数群
   197      ! NAMELIST group name
   198      !
   199  !!$    namelist /cloud_simple_nml/ &
   200  !!$      & CloudLifeTime,       &
   201  !!$      & CloudWatLifeTime,    &
   202  !!$      & CloudIceLifeTime,    &
   203  !!$      & CloudCoverMethod,    &
   204  !!$      & RHCrtl,              &
   205  !!$      & CloudCover
   206            !
   207            ! デフォルト値については初期化手続 "cloud_mars_h2o#CloudMarsH2OInit"
   208            ! のソースコードを参照のこと.
   209            !
   210            ! Refer to source codes in the initialization procedure
   211            ! "cloud_mars_h2o#CloudMarsH2OInit" for the default values.
   212            !
   213  
   214      ! 実行文 ; Executable statement
   215      !
   216  
   217      if ( cloud_mars_h2o_inited ) return
   218  
   219  
   220      ! デフォルト値の設定
   221      ! Default values settings
   222      !
   223  
   224  
   225      ! NAMELIST の読み込み
   226      ! NAMELIST is input
   227      !
   228  !!$    if ( trim(namelist_filename) /= '' ) then
   229  !!$      call FileOpen( unit_nml, &          ! (out)
   230  !!$        & namelist_filename, mode = 'r' ) ! (in)
   231  !!$
   232  !!$      rewind( unit_nml )
   233  !!$      read( unit_nml,                     & ! (in)
   234  !!$        & nml = cloud_mars_h2o_nml,       & ! (out)
   235  !!$        & iostat = iostat_nml )             ! (out)
   236  !!$      close( unit_nml )
   237  !!$
   238  !!$      call NmlutilMsg( iostat_nml, module_name ) ! (in)
   239  !!$    end if
   240  
   241  
   242  
   243      ! Initialization of modules used in this module
   244      !
   245  
   246      ! 重力沈降過程
   247      ! Gravitational sedimentation process
   248      !
   249      call GravSedInit
   250  
   251  
   252      ! ヒストリデータ出力のためのへの変数登録
   253      ! Register of variables for history data output
   254      !
   255  !!$    call HistoryAutoAddVariable( 'EffCloudCover', &
   256  !!$      & (/ 'lon ', 'lat ', 'time' /), &
   257  !!$      & 'effective cloud cover', '1' )
   258  
   259  
   260  
   261      ! 印字 ; Print
   262      !
   263      call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   264      call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   265  
   266  
   267      cloud_mars_h2o_inited = .true.
   268  
   269    end subroutine CloudMarsH2OInit
   270  
   271    !--------------------------------------------------------------------------------------
   272  
   273  end module cloud_mars_h2o
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:55 2016
FILE NAME: cloud_mars_h2o.f90
PROGRAM NAME: cloud_mars_h2o
FORMAT LIST

  LINE    LOOP      FORTRAN STATEMENT

     1:             != 火星 H2O 雲モデル
     2:             !
     3:             != Mars H2O cloud model
     4:             !
     5:             ! Authors::   Yoshiyuki O. Takahashi
     6:             ! Version::   $Id: cloud_mars_h2o.f90,v 1.2 2015/01/29 12:06:42 yot Exp $
     7:             ! Tag Name::  $Name:  $
     8:             ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9:             ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10:             !
    11:             
    12:             module cloud_mars_h2o
    13:               !
    14:               != 火星 H2O 雲モデル
    15:               !
    16:               != Mars H2O cloud model
    17:               !
    18:               ! <b>Note that Japanese and English are described in parallel.</b>
    19:               !
    20:               ! 
    21:               !
    22:               ! In this module, H2O cloud on Mars is calculated by use of a simple
    23:               ! cloud model.
    24:               !
    25:               !== Procedures List
    26:               !
    27:             !!$  ! RadiationFluxDennouAGCM :: 放射フラックスの計算
    28:             !!$  ! ------------            :: ------------
    29:             !!$  ! RadiationFluxDennouAGCM :: Calculate radiation flux
    30:               !
    31:               !== NAMELIST
    32:               !
    33:               ! NAMELIST#cloud_simple_nml
    34:               !
    35:             
    36:               ! モジュール引用 ; USE statements
    37:             
    38:               !
    39:               ! Kind type parameter
    40:               !
    41:               use dc_types, only: DP, &      ! Double precision.
    42:                 &                 STRING, &  ! Strings.
    43:                 &                 TOKEN      ! Keywords.
    44:             
    45:               ! メッセージ出力
    46:               ! Message output
    47:               !
    48:               use dc_message, only: MessageNotify
    49:             
    50:               ! 格子点設定
    51:               ! Grid points settings
    52:               !
    53:               use gridset, only: imax, & ! 経度格子点数.
    54:                                          ! Number of grid points in longitude
    55:                 &                jmax, & ! 緯度格子点数.
    56:                                          ! Number of grid points in latitude
    57:                 &                kmax    ! 鉛直層数.
    58:                                          ! Number of vertical level
    59:             
    60:               implicit none
    61:             
    62:               private
    63:             
    64:             
    65:               ! 公開手続き
    66:               ! Public procedure
    67:               !
    68:               public :: CloudMarsH2O
    69:               public :: CloudMarsH2OInit
    70:             
    71:             
    72:               ! 公開変数
    73:               ! Public variables
    74:               !
    75:             
    76:             
    77:               ! 非公開変数
    78:               ! Private variables
    79:               !
    80:             
    81:               logical, save :: cloud_mars_h2o_inited = .false.
    82:                                           ! 初期設定フラグ.
    83:                                           ! Initialization flag
    84:             
    85:               character(*), parameter:: module_name = 'cloud_mars_h2o'
    86:                                           ! モジュールの名称.
    87:                                           ! Module name
    88:               character(*), parameter:: version = &
    89:                 & '$Name:  $' // &
    90:                 & '$Id: cloud_mars_h2o.f90,v 1.2 2015/01/29 12:06:42 yot Exp $'
    91:                                           ! モジュールのバージョン
    92:                                           ! Module version
    93:             
    94:               !--------------------------------------------------------------------------------------
    95:             
    96:             contains
    97:             
    98:               !--------------------------------------------------------------------------------------
    99:             
   100:               subroutine CloudMarsH2O(                            &
   101:                 & xyr_Press, xyr_Height,                          & ! (in)
   102:                 & xyz_DQH2OSolDtCum, xyz_DQH2OSolDtLSC,           & ! (in)
   103:                 & xyz_QH2OSol,                                    & ! (inout)
   104:                 & xy_Rain, xy_Snow                                & ! (out)
   105:                 & )
   106:             
   107:                 ! USE statements
   108:                 !
   109:             
   110:                 ! 時刻管理
   111:                 ! Time control
   112:                 !
   113:                 use timeset, only: &
   114:                   & DelTime            ! $ \Delta t $ [s]
   115:             
   116:                 ! 重力沈降過程
   117:                 ! Gravitational sedimentation process
   118:                 !
   119:                 use grav_sed, only : GravSed
   120:             
   121:             
   122:                 real(DP), intent(in   ) :: xyr_Press        ( 0:imax-1, 1:jmax, 0:kmax )
   123:                 real(DP), intent(in   ) :: xyr_Height       ( 0:imax-1, 1:jmax, 0:kmax )
   124:                 real(DP), intent(in   ) :: xyz_DQH2OSolDtCum( 0:imax-1, 1:jmax, 1:kmax )
   125:                 real(DP), intent(in   ) :: xyz_DQH2OSolDtLSC( 0:imax-1, 1:jmax, 1:kmax )
   126:                 real(DP), intent(inout) :: xyz_QH2OSol      ( 0:imax-1, 1:jmax, 1:kmax )
   127:                 real(DP), intent(out  ) :: xy_Rain          ( 0:imax-1, 1:jmax )
   128:                 real(DP), intent(out  ) :: xy_Snow          ( 0:imax-1, 1:jmax )
   129:             
   130:             
   131:             
   132:                 ! 実行文 ; Executable statement
   133:                 !
   134:             
   135:                 ! 初期化確認
   136:                 ! Initialization check
   137:                 !
   138:                 if ( .not. cloud_mars_h2o_inited ) then
   139:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   140:                 end if
   141:             
   142:             
   143: W**==== A       xyz_QH2OSol = xyz_QH2OSol &
   144:                   & + ( xyz_DQH2OSolDtCum + xyz_DQH2OSolDtLSC ) * 2.0_DP * DelTime
   145:             
   146:             
   147: *W----->A       xy_Rain = 0.0_DP
   148: *W----- A       xy_Snow = 0.0_DP
   149:             
   150:                 ! 重力沈降過程
   151:                 ! Gravitational sedimentation process
   152:                 !
   153:                 call GravSed(                          &
   154:                   & 'MarsH2OCloud',                    & ! (in )
   155:                   & xyr_Press, xyr_Height,             & ! (in )
   156:                   & xyz_QH2OSol,                       & ! (out)
   157:                   & xy_Snow                            & ! (out) optional
   158:                   & )
   159: W*===== A       xy_Snow = - xy_Snow
   160:             
   161:             
   162:               end subroutine CloudMarsH2O
   163:             
   164:               !--------------------------------------------------------------------------------------
   165:             
   166:               subroutine CloudMarsH2OInit
   167:             
   168:             !!$    ! ファイル入出力補助
   169:             !!$    ! File I/O support
   170:             !!$    !
   171:             !!$    use dc_iounit, only: FileOpen
   172:             !!$
   173:             !!$    ! NAMELIST ファイル入力に関するユーティリティ
   174:             !!$    ! Utilities for NAMELIST file input
   175:             !!$    !
   176:             !!$    use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid
   177:             
   178:                 ! ヒストリデータ出力
   179:                 ! History data output
   180:                 !
   181:                 use gtool_historyauto, only: HistoryAutoAddVariable
   182:             
   183:                 ! 重力沈降過程
   184:                 ! Gravitational sedimentation process
   185:                 !
   186:                 use grav_sed, only : GravSedInit
   187:             
   188:                 ! 宣言文 ; Declaration statements
   189:                 !
   190:             
   191:             !!$    integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号.
   192:             !!$                              ! Unit number for NAMELIST file open
   193:             !!$    integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT.
   194:             !!$                              ! IOSTAT of NAMELIST read
   195:             
   196:                 ! NAMELIST 変数群
   197:                 ! NAMELIST group name
   198:                 !
   199:             !!$    namelist /cloud_simple_nml/ &
   200:             !!$      & CloudLifeTime,       &
   201:             !!$      & CloudWatLifeTime,    &
   202:             !!$      & CloudIceLifeTime,    &
   203:             !!$      & CloudCoverMethod,    &
   204:             !!$      & RHCrtl,              &
   205:             !!$      & CloudCover
   206:                       !
   207:                       ! デフォルト値については初期化手続 "cloud_mars_h2o#CloudMarsH2OInit"
   208:                       ! のソースコードを参照のこと.
   209:                       !
   210:                       ! Refer to source codes in the initialization procedure
   211:                       ! "cloud_mars_h2o#CloudMarsH2OInit" for the default values.
   212:                       !
   213:             
   214:                 ! 実行文 ; Executable statement
   215:                 !
   216:             
   217:                 if ( cloud_mars_h2o_inited ) return
   218:             
   219:             
   220:                 ! デフォルト値の設定
   221:                 ! Default values settings
   222:                 !
   223:             
   224:             
   225:                 ! NAMELIST の読み込み
   226:                 ! NAMELIST is input
   227:                 !
   228:             !!$    if ( trim(namelist_filename) /= '' ) then
   229:             !!$      call FileOpen( unit_nml, &          ! (out)
   230:             !!$        & namelist_filename, mode = 'r' ) ! (in)
   231:             !!$
   232:             !!$      rewind( unit_nml )
   233:             !!$      read( unit_nml,                     & ! (in)
   234:             !!$        & nml = cloud_mars_h2o_nml,       & ! (out)
   235:             !!$        & iostat = iostat_nml )             ! (out)
   236:             !!$      close( unit_nml )
   237:             !!$
   238:             !!$      call NmlutilMsg( iostat_nml, module_name ) ! (in)
   239:             !!$    end if
   240:             
   241:             
   242:             
   243:                 ! Initialization of modules used in this module
   244:                 !
   245:             
   246:                 ! 重力沈降過程
   247:                 ! Gravitational sedimentation process
   248:                 !
   249:                 call GravSedInit
   250:             
   251:             
   252:                 ! ヒストリデータ出力のためのへの変数登録
   253:                 ! Register of variables for history data output
   254:                 !
   255:             !!$    call HistoryAutoAddVariable( 'EffCloudCover', &
   256:             !!$      & (/ 'lon ', 'lat ', 'time' /), &
   257:             !!$      & 'effective cloud cover', '1' )
   258:             
   259:             
   260:             
   261:                 ! 印字 ; Print
   262:                 !
   263:                 call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   264:                 call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   265:             
   266:             
   267:                 cloud_mars_h2o_inited = .true.
   268:             
   269:               end subroutine CloudMarsH2OInit
   270:             
   271:               !--------------------------------------------------------------------------------------
   272:             
   273:             end module cloud_mars_h2o
