Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:54 2016
FILE NAME: cloud_none.f90
PROGRAM NAME: cloud_none
DIAGNOSTIC LIST

  LINE  LEVEL( NO.): DIAGNOSTIC MESSAGE

   182  opt  (  11): Fused array assignments. :line 182 - 185
   182  opt  (1593): Loop nest collapsed into one loop.
   182  vec  (   4): Vectorized array expression.
   182  vec  (  29): ADB is used for array.: xyz_qh2osolb
   182  vec  (  29): ADB is used for array.: xyz_dqsnowdt
   182  vec  (  29): ADB is used for array.: xyz_qh2oliqb
   182  vec  (  29): ADB is used for array.: xyz_dqraindt
   182  vec  (  29): ADB is used for array.: xyz_qh2ovapb
   182  vec  (  29): ADB is used for array.: xyz_qh2ovap
   182  vec  (  29): ADB is used for array.: xyz_tempb
   182  vec  (  29): ADB is used for array.: xyz_temp
   188  opt  (1593): Loop nest collapsed into one loop.
   188  vec  (   1): Vectorized loop.
   188  vec  (  29): ADB is used for array.: xyr_press
   193  opt  (  11): Fused array assignments. :line 193 - 194
   193  opt  (1593): Loop nest collapsed into one loop.
   193  vec  (   4): Vectorized array expression.
   193  vec  (  29): ADB is used for array.: xy_surfsnowflux
   193  vec  (  29): ADB is used for array.: xy_surfrainflux
   197  vec  (   3): Unvectorized loop.
   200  opt  (1017): Subroutine call prevents optimization.
   200  vec  (  10): Vectorization obstructive procedure reference.:cloudutilsprcpsteppc1grid
   208  vec  (  10): Vectorization obstructive procedure reference.:cloudutilsprcpevap1grid
   226  opt  (  11): Fused array assignments. :line 226 - 227
   226  opt  (1593): Loop nest collapsed into one loop.
   226  vec  (   4): Vectorized array expression.
   226  vec  (  29): ADB is used for array.: xyz_qh2osoltmp
   226  vec  (  29): ADB is used for array.: xyz_qh2oliqtmp
   276  opt  (1593): Loop nest collapsed into one loop.
   276  vec  (   4): Vectorized array expression.
   276  vec  (  29): ADB is used for array.: xyz_dqsnowdt
   351  opt  (1593): Loop nest collapsed into one loop.
   351  vec  (   1): Vectorized loop.
   351  vec  (  29): ADB is used for array.: xyr_press
   355  opt  (1593): Loop nest collapsed into one loop.
   355  vec  (   4): Vectorized array expression.
   356  vec  (   3): Unvectorized loop.
   356  vec  (  13): Overhead of loop division is too large.
   357  opt  (  11): Fused array assignments. :line 357 - 360
   357  opt  (1593): Loop nest collapsed into one loop.
   357  vec  (   4): Vectorized array expression.
   357  vec  (  29): ADB is used for array.: xy_sum
   357  vec  (  29): ADB is used for array.: xy_val
   357  vec  (  29): ADB is used for array.: xyz_qh2osolb
   357  vec  (  29): ADB is used for array.: xyz_qh2ovapb
   357  vec  (  29): ADB is used for array.: xyz_tempb
   363  opt  (  11): Fused array assignments. :line 363 - 365
   363  opt  (1593): Loop nest collapsed into one loop.
   363  vec  (   4): Vectorized array expression.
   363  vec  (  29): ADB is used for array.: xy_sum
   366  vec  (   3): Unvectorized loop.
   366  vec  (  13): Overhead of loop division is too large.
   367  opt  (  11): Fused array assignments. :line 367 - 370
   367  opt  (1593): Loop nest collapsed into one loop.
   367  vec  (   4): Vectorized array expression.
   367  vec  (  29): ADB is used for array.: xy_sum
   367  vec  (  29): ADB is used for array.: xy_val
   367  vec  (  29): ADB is used for array.: xyz_qh2osol
   367  vec  (  29): ADB is used for array.: xyz_qh2ovap
   367  vec  (  29): ADB is used for array.: xyz_temp
   373  opt  (  11): Fused array assignments. :line 373 - 376
   373  opt  (1593): Loop nest collapsed into one loop.
   373  vec  (   4): Vectorized array expression.
   373  vec  (  29): ADB is used for array.: xy_sum
   373  vec  (  29): ADB is used for array.: xy_snow
   378  vec  (   3): Unvectorized loop.
   380  opt  (1017): Subroutine call prevents optimization.
   380  vec  (  10): Vectorization obstructive procedure reference.:messagenotifyc
   387  opt  (1593): Loop nest collapsed into one loop.
   387  vec  (   4): Vectorized array expression.
   388  vec  (   3): Unvectorized loop.
   388  vec  (  13): Overhead of loop division is too large.
   389  opt  (  11): Fused array assignments. :line 389 - 390
   389  opt  (1593): Loop nest collapsed into one loop.
   389  vec  (   4): Vectorized array expression.
   389  vec  (  29): ADB is used for array.: xy_sum
   389  vec  (  29): ADB is used for array.: xy_val
   389  vec  (  29): ADB is used for array.: xyz_qh2osolb
   389  vec  (  29): ADB is used for array.: xyz_qh2oliqb
   389  vec  (  29): ADB is used for array.: xyz_qh2ovapb
   393  opt  (  11): Fused array assignments. :line 393 - 395
   393  opt  (1593): Loop nest collapsed into one loop.
   393  vec  (   4): Vectorized array expression.
   393  vec  (  29): ADB is used for array.: xy_sum
   396  vec  (   3): Unvectorized loop.
   396  vec  (  13): Overhead of loop division is too large.
   397  opt  (  11): Fused array assignments. :line 397 - 398
   397  opt  (1593): Loop nest collapsed into one loop.
   397  vec  (   4): Vectorized array expression.
   397  vec  (  29): ADB is used for array.: xy_sum
   397  vec  (  29): ADB is used for array.: xyz_qh2osol
   397  vec  (  29): ADB is used for array.: xyz_qh2oliq
   397  vec  (  29): ADB is used for array.: xyz_qh2ovap
   400  opt  (  11): Fused array assignments. :line 400 - 402
   400  opt  (1593): Loop nest collapsed into one loop.
   400  vec  (   4): Vectorized array expression.
   400  vec  (  29): ADB is used for array.: xy_sum
   400  vec  (  29): ADB is used for array.: xy_snow
   400  vec  (  29): ADB is used for array.: xy_rain
   404  vec  (   3): Unvectorized loop.
   406  opt  (1017): Subroutine call prevents optimization.
   406  vec  (  10): Vectorization obstructive procedure reference.:messagenotifyc
   542  warn (  82): Name "snowmethod" is not used.
   542  warn (  82): Name "cloudcovermethod" is not used.
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:54 2016
FILE NAME: cloud_none.f90
PROGRAM NAME: cloud_none
TRANSFORMATION LIST

  LINE                   FORTRAN STATEMENT

     1  != 雲なしモデル
     2  !
     3  != No cloud model
     4  !
     5  ! Authors::   Yoshiyuki O. Takahashi
     6  ! Version::   $Id: cloud_none.f90,v 1.1 2015/01/29 12:19:41 yot Exp $
     7  ! Tag Name::  $Name:  $
     8  ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9  ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10  !
    11  
    12  module cloud_none
    13    !
    14    != 雲なしモデル
    15    !
    16    != No cloud model
    17    !
    18    ! <b>Note that Japanese and English are described in parallel.</b>
    19    !
    20    !
    21    !
    22    ! This is a no cloud model, i.e., condensation rate is converted to
    23    ! precipitation rate.
    24    !
    25    !== Procedures List
    26    !
    27  !!$  ! RadiationFluxDennouAGCM :: 放射フラックスの計算
    28  !!$  ! ------------            :: ------------
    29  !!$  ! RadiationFluxDennouAGCM :: Calculate radiation flux
    30    !
    31    !== NAMELIST
    32    !
    33    ! NAMELIST#cloud_none_nml
    34    !
    35  
    36    ! モジュール引用 ; USE statements
    37  
    38    !
    39    ! Kind type parameter
    40    !
    41    use dc_types, only: DP, &      ! Double precision.
    42      &                 STRING, &  ! Strings.
    43      &                 TOKEN      ! Keywords.
    44  
    45    ! メッセージ出力
    46    ! Message output
    47    !
    48    use dc_message, only: MessageNotify
    49  
    50    ! 格子点設定
    51    ! Grid points settings
    52    !
    53    use gridset, only: imax, & ! 経度格子点数.
    54                               ! Number of grid points in longitude
    55      &                jmax, & ! 緯度格子点数.
    56                               ! Number of grid points in latitude
    57      &                kmax    ! 鉛直層数.
    58                               ! Number of vertical level
    59  
    60    implicit none
    61  
    62    private
    63  
    64  
    65    ! 公開手続き
    66    ! Public procedure
    67    !
    68    public :: CloudNoneWithIce
    69    public :: CloudNone
    70    public :: CloudNoneInit
    71  
    72  
    73    ! 公開変数
    74    ! Public variables
    75    !
    76  
    77  
    78    ! 非公開変数
    79    ! Private variables
    80    !
    81    logical , save        :: FlagSnow
    82                             ! A flag for snow
    83  
    84    logical , save :: FlagPRCPPC
    85    logical , save :: FlagPRCPEvap
    86  
    87    real(DP), save :: PRCPArea
    88      !                           a_p
    89    real(DP), save :: PRCPEvapArea
    90      !                           A = max( a_p - a, 0 )
    91  
    92  
    93    logical, save :: cloud_none_inited = .false.
    94                                ! 初期設定フラグ.
    95                                ! Initialization flag
    96  
    97    character(*), parameter:: module_name = 'cloud_none'
    98                                ! モジュールの名称.
    99                                ! Module name
   100    character(*), parameter:: version = &
   101      & '$Name:  $' // &
   102      & '$Id: cloud_none.f90,v 1.1 2015/01/29 12:19:41 yot Exp $'
   103                                ! モジュールのバージョン
   104                                ! Module version
   105  
   106    !--------------------------------------------------------------------------------------
   107  
   108  contains
   109  
   110    !--------------------------------------------------------------------------------------
   111  
   112    subroutine CloudNoneWithIce(               &
   113      & xyr_Press, xyz_Press,                  & ! (in   )
   114      & xyz_DQRainDt, xyz_DQSnowDt,            & ! (in   )
   115      & xyz_Temp, xyz_QH2OVap,                 & ! (inout)
   116      & xy_SurfRainFlux, xy_SurfSnowFlux       & ! (out  )
   117      & )
   118  
   119      ! 時刻管理
   120      ! Time control
   121      !
   122      use timeset, only: &
   123        & DelTime            ! $ \Delta t $ [s]
   124  
   125      ! 物理定数設定
   126      ! Physical constants settings
   127      !
   128      use constants, only:  &
   129        & CpDry,            &
   130                                ! $ C_p $ [J kg-1 K-1].
   131                                ! 乾燥大気の定圧比熱.
   132                                ! Specific heat of air at constant pressure
   133        & Grav
   134                                ! $ g $ [m s-2].
   135                                ! 重力加速度.
   136                                ! Gravitational acceleration
   137  
   138      ! 雲関系ルーチン
   139      ! Cloud-related routines
   140      !
   141      use cloud_utils, only: &
   142        & CloudUtilsPRCPStepPC1Grid, &
   143        & CloudUtilsPRCPEvap1Grid
   144  
   145      real(DP), intent(in   ) :: xyr_Press       ( 0:imax-1, 1:jmax, 0:kmax )
   146      real(DP), intent(in   ) :: xyz_Press       ( 0:imax-1, 1:jmax, 1:kmax )
   147      real(DP), intent(in   ) :: xyz_DQRainDt    ( 0:imax-1, 1:jmax, 1:kmax )
   148      real(DP), intent(in   ) :: xyz_DQSnowDt    ( 0:imax-1, 1:jmax, 1:kmax )
   149      real(DP), intent(inout) :: xyz_Temp        ( 0:imax-1, 1:jmax, 1:kmax )
   150      real(DP), intent(inout) :: xyz_QH2OVap     ( 0:imax-1, 1:jmax, 1:kmax )
   151      real(DP), intent(out  ) :: xy_SurfRainFlux ( 0:imax-1, 1:jmax )
   152      real(DP), intent(out  ) :: xy_SurfSnowFlux ( 0:imax-1, 1:jmax )
   153  
   154  
   155      ! 作業変数
   156      ! Work variables
   157      !
   158      real(DP) :: xyz_TempB   ( 0:imax-1, 1:jmax, 1:kmax )
   159      real(DP) :: xyz_QH2OVapB( 0:imax-1, 1:jmax, 1:kmax )
   160      real(DP) :: xyz_QH2OLiqB( 0:imax-1, 1:jmax, 1:kmax )
   161      real(DP) :: xyz_QH2OSolB( 0:imax-1, 1:jmax, 1:kmax )
   162      real(DP) :: xyz_DelMass ( 0:imax-1, 1:jmax, 1:kmax )
   163  
   164      real(DP) :: xyz_QH2OLiqTMP( 0:imax-1, 1:jmax, 1:kmax )
   165      real(DP) :: xyz_QH2OSolTMP( 0:imax-1, 1:jmax, 1:kmax )
   166  
   167      integer  :: i
   168      integer  :: j
   169      integer  :: k
   170  
   171  
   172      ! 初期化確認
   173      ! Initialization check
   174      !
   175      if ( .not. cloud_none_inited ) then
   176        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   177      end if
   178  
   179  
   180      ! Save variables
   181      !
   182      xyz_TempB    = xyz_Temp
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t365 = 1, xyz_tempb.DSC.U3*(xyz_tempb.DSC.U2*xyz_tempb.DSC.U1  
     .       1    + xyz_tempb.DSC.U2)                                           
     .           xyz_tempb(t365-1,1,1) = xyz_temp(t365-1,1,1)                   
     .           xyz_qh2ovapb(t365-1,1,1) = xyz_qh2ovap(t365-1,1,1)             
     .           xyz_qh2oliqb(t365-1,1,1) = xyz_dqraindt(t365-1,1,1)*(          
     .       1      2.00000000000000e+000*deltime)                              
     .           xyz_qh2osolb(t365-1,1,1) = xyz_dqsnowdt(t365-1,1,1)*(          
     .       1      2.00000000000000e+000*deltime)                              
     .        enddo                                                             
   183      xyz_QH2OVapB = xyz_QH2OVap
   184      xyz_QH2OLiqB = xyz_DQRainDt * ( 2.0_DP * DelTime )
   185      xyz_QH2OSolB = xyz_DQSnowDt * ( 2.0_DP * DelTime )
   186  
   187  
   188      do k = 1, kmax
   189        xyz_DelMass(:,:,k) = ( xyr_Press(:,:,k-1) - xyr_Press(:,:,k) ) / Grav
   190      end do
     .        d1 = 1.D0/grav                                                    
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do k = 1, kmax*jmax*imax                                          
     .           xyz_delmass(k-1,1,1) = (xyr_press(k-1,1,0)-xyr_press(k-1,1,1))*
     .       1      d1                                                          
     .        enddo                                                             
   191  
   192      ! Freezing and melting switching at temperature of TempCondWater
   193      xy_SurfRainFlux = 0.0_DP
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t405 = 1, jmax*imax                                            
     .           xy_surfrainflux(t405-1,1) = 0.0000000000000000e+000            
     .           xy_surfsnowflux(t405-1,1) = 0.0000000000000000e+000            
     .        enddo                                                             
   194      xy_SurfSnowFlux = 0.0_DP
   195      do j = 1, jmax
   196        do i = 0, imax-1
   197          do k = kmax, 1, -1
   198  
   199            if ( FlagPRCPPC ) then
   200              call CloudUtilsPRCPStepPC1Grid(  &
   201                & xyr_Press(i,j,k-1), xyr_Press(i,j,k),       & ! (in   )
   202                & xyz_Temp(i,j,k),                            & ! (inout)
   203                & xy_SurfRainFlux(i,j), xy_SurfSnowFlux(i,j)  & ! (out  )
   204                & )
   205            end if
   206  
   207            if ( FlagPRCPEvap ) then
   208              call CloudUtilsPRCPEvap1Grid(                               &
   209                & xyz_Press(i,j,k), xyr_Press(i,j,k-1), xyr_Press(i,j,k), & ! (in)
   210                & PRCPArea, PRCPEvapArea,                                 & ! (in)
   211                & xyz_Temp(i,j,k), xyz_QH2OVap(i,j,k),                    & ! (inout)
   212                & xy_SurfRainFlux(i,j), xy_SurfSnowFlux(i,j)              & ! (inout)
   213                & )
   214            end if
   215  
   216            xy_SurfRainFlux(i,j) = xy_SurfRainFlux(i,j) &
   217              & + xyz_DQRainDt(i,j,k) * xyz_DelMass(i,j,k)
   218            xy_SurfSnowFlux(i,j) = xy_SurfSnowFlux(i,j) &
   219              & + xyz_DQSnowDt(i,j,k) * xyz_DelMass(i,j,k)
   220  
   221          end do
   222        end do
   223      end do
   224  
   225  
   226      xyz_QH2OLiqTMP = 0.0_DP
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t413 = 1, xyz_qh2oliqtmp.DSC.U3*(xyz_qh2oliqtmp.DSC.U2*        
     .       1   xyz_qh2oliqtmp.DSC.U1 + xyz_qh2oliqtmp.DSC.U2)                 
     .           xyz_qh2oliqtmp(t413-1,1,1) = 0.0000000000000000e+000           
     .           xyz_qh2osoltmp(t413-1,1,1) = 0.0000000000000000e+000           
     .        enddo                                                             
   227      xyz_QH2OSolTMP = 0.0_DP
   228      call CloudNoneConsChk(                             &
   229  !!$      & FlagIncludeIcePhaseChange,                           &
   230        & xyr_Press,                                               &
   231        & xyz_TempB, xyz_QH2OVapB, xyz_QH2OLiqB  , xyz_QH2OSolB  , &
   232        & xyz_Temp , xyz_QH2OVap , xyz_QH2OLiqTMP, xyz_QH2OSolTMP, &
   233        & xy_SurfRainFlux, xy_SurfSnowFlux                         &
   234        & )
   235  
   236  
   237    end subroutine CloudNoneWithIce
   238  
   239    !--------------------------------------------------------------------------------------
   240  
   241    subroutine CloudNone(                      &
   242      & xyr_Press, xyz_Press,                  & ! (in   )
   243      & xyz_DQRainDt,                          & ! (in   )
   244      & xyz_Temp, xyz_QH2OVap,                 & ! (inout)
   245      & xy_SurfRainFlux                        & ! (out  )
   246      & )
   247  
   248      real(DP), intent(in   ) :: xyr_Press       ( 0:imax-1, 1:jmax, 0:kmax )
   249      real(DP), intent(in   ) :: xyz_Press       ( 0:imax-1, 1:jmax, 1:kmax )
   250      real(DP), intent(in   ) :: xyz_DQRainDt    ( 0:imax-1, 1:jmax, 1:kmax )
   251      real(DP), intent(inout) :: xyz_Temp        ( 0:imax-1, 1:jmax, 1:kmax )
   252      real(DP), intent(inout) :: xyz_QH2OVap     ( 0:imax-1, 1:jmax, 1:kmax )
   253      real(DP), intent(out  ) :: xy_SurfRainFlux ( 0:imax-1, 1:jmax )
   254  
   255  
   256      ! 作業変数
   257      ! Work variables
   258      !
   259      real(DP) :: xyz_DQSnowDt    ( 0:imax-1, 1:jmax, 1:kmax )
   260      real(DP) :: xy_SurfSnowFlux ( 0:imax-1, 1:jmax )
   261  
   262  
   263      ! 初期化確認
   264      ! Initialization check
   265      !
   266      if ( .not. cloud_none_inited ) then
   267        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   268      end if
   269  
   270  
   271      if ( FlagPRCPPC ) then
   272        call MessageNotify( 'E', module_name, 'FlagPRCPPC has to be .false., if CloudNone subroutine is used.' )
   273      end if
   274  
   275  
   276      xyz_DQSnowDt = 0.0_DP
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t115 = 1, xyz_dqsnowdt.DSC.U3*(xyz_dqsnowdt.DSC.U2*            
     .       1   xyz_dqsnowdt.DSC.U1 + xyz_dqsnowdt.DSC.U2)                     
     .           xyz_dqsnowdt(t115-1,1,1) = 0.0000000000000000e+000             
     .        enddo                                                             
   277  
   278      call CloudNoneWithIce(               &
   279        & xyr_Press, xyz_Press,                  & ! (in   )
   280        & xyz_DQRainDt, xyz_DQSnowDt,            & ! (in   )
   281        & xyz_Temp, xyz_QH2OVap,                 & ! (inout)
   282        & xy_SurfRainFlux, xy_SurfSnowFlux       & ! (out  )
   283        & )
   284  
   285  
   286    end subroutine CloudNone
   287  
   288    !--------------------------------------------------------------------------------------
   289  
   290    subroutine CloudNoneConsChk(                             &
   291  !!$    & FlagIncludeIcePhaseChange,                           &
   292      & xyr_Press,                                           &
   293      & xyz_TempB, xyz_QH2OVapB, xyz_QH2OLiqB, xyz_QH2OSolB, &
   294      & xyz_Temp , xyz_QH2OVap , xyz_QH2OLiq , xyz_QH2OSol , &
   295      & xy_Rain, xy_Snow                                     &
   296      & )
   297  
   298  
   299      ! 時刻管理
   300      ! Time control
   301      !
   302      use timeset, only: &
   303        & DelTime            ! $ \Delta t $ [s]
   304  
   305      ! 物理定数設定
   306      ! Physical constants settings
   307      !
   308      use constants, only: &
   309        & Grav, &
   310                                ! $ g $ [m s-2].
   311                                ! 重力加速度.
   312                                ! Gravitational acceleration
   313        & CpDry, &
   314                                ! $ C_p $ [J kg-1 K-1].
   315                                ! 乾燥大気の定圧比熱.
   316                                ! Specific heat of air at constant pressure
   317        & LatentHeat, &
   318                                ! $ L $ [J kg-1] .
   319                                ! 凝結の潜熱.
   320                                ! Latent heat of condensation
   321        & LatentHeatFusion
   322                                ! $ L $ [J kg-1] .
   323                                ! 融解の潜熱.
   324                                ! Latent heat of fusion
   325  
   326  !!$    logical , intent(in) :: FlagIncludeIcePhaseChange
   327      real(DP), intent(in) :: xyr_Press   (0:imax-1, 1:jmax, 0:kmax)
   328      real(DP), intent(in) :: xyz_TempB   (0:imax-1, 1:jmax, 1:kmax)
   329      real(DP), intent(in) :: xyz_QH2OVapB(0:imax-1, 1:jmax, 1:kmax)
   330      real(DP), intent(in) :: xyz_QH2OLiqB(0:imax-1, 1:jmax, 1:kmax)
   331      real(DP), intent(in) :: xyz_QH2OSolB(0:imax-1, 1:jmax, 1:kmax)
   332      real(DP), intent(in) :: xyz_Temp    (0:imax-1, 1:jmax, 1:kmax)
   333      real(DP), intent(in) :: xyz_QH2OVap (0:imax-1, 1:jmax, 1:kmax)
   334      real(DP), intent(in) :: xyz_QH2OLiq (0:imax-1, 1:jmax, 1:kmax)
   335      real(DP), intent(in) :: xyz_QH2OSol (0:imax-1, 1:jmax, 1:kmax)
   336      real(DP), intent(in) :: xy_Rain     (0:imax-1, 1:jmax)
   337      real(DP), intent(in) :: xy_Snow     (0:imax-1, 1:jmax)
   338  
   339      ! Local variables
   340      !
   341      real(DP) :: xyz_DelMass(0:imax-1, 1:jmax, 1:kmax)
   342      real(DP) :: xy_Val(0:imax-1, 1:jmax)
   343      real(DP) :: xy_SumB(0:imax-1, 1:jmax)
   344      real(DP) :: xy_Sum(0:imax-1, 1:jmax)
   345      real(DP) :: xy_Ratio(0:imax-1, 1:jmax)
   346      integer  :: i
   347      integer  :: j
   348      integer  :: k
   349  
   350  
   351      do k = 1, kmax
   352        xyz_DelMass(:,:,k) = ( xyr_Press(:,:,k-1) - xyr_Press(:,:,k) ) / Grav
   353      end do
     .        d1 = 1.D0/grav                                                    
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do k = 1, kmax*jmax*imax                                          
     .           xyz_delmass(k-1,1,1) = (xyr_press(k-1,1,0)-xyr_press(k-1,1,1))*
     .       1      d1                                                          
     .        enddo                                                             
   354  
   355      xy_Sum = 0.0_DP
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t460 = 1, xy_sum.DSC.U2*xy_sum.DSC.U1 + xy_sum.DSC.U2          
     .           xy_sum(t460-1,1) = 0.0000000000000000e+000                     
     .        enddo                                                             
   356      do k = kmax, 1, -1
   357        xy_Val =   CpDry * xyz_TempB(:,:,k)               &
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xy_val,xy_sum)                                             
     .        do t466 = 1, jmax*imax                                            
     .           xy_val(t466-1,1) = cpdry*xyz_tempb(t466-1,1,k) + latentheat*   
     .       1      xyz_qh2ovapb(t466-1,1,k) - latentheatfusion*xyz_qh2osolb(   
     .       2      t466-1,1,k)                                                 
     .           xy_sum(t466-1,1) = xy_sum(t466-1,1) + xy_val(t466-1,1)*        
     .       1      xyz_delmass(t466-1,1,k)                                     
     .        enddo                                                             
   358          &      + LatentHeat * xyz_QH2OVapB(:,:,k)       &
   359          &      - LatentHeatFusion * xyz_QH2OSolB(:,:,k)
   360        xy_Sum = xy_Sum + xy_Val * xyz_DelMass(:,:,k)
   361      end do
   362  
   363      xy_SumB = xy_Sum
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xy_sum)                                                    
     .        do t486 = 1, xy_sumb.DSC.U2*xy_sumb.DSC.U1 + xy_sumb.DSC.U2       
     .           xy_sumb(t486-1,1) = xy_sum(t486-1,1)                           
     .           xy_sum(t486-1,1) = 0.0000000000000000e+000                     
     .        enddo                                                             
   364  
   365      xy_Sum = 0.0_DP
   366      do k = kmax, 1, -1
   367        xy_Val =   CpDry * xyz_Temp (:,:,k)               &
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xy_val,xy_sum)                                             
     .        do t496 = 1, jmax*imax                                            
     .           xy_val(t496-1,1) = cpdry*xyz_temp(t496-1,1,k) + latentheat*    
     .       1      xyz_qh2ovap(t496-1,1,k) - latentheatfusion*xyz_qh2osol(t496-
     .       2      1,1,k)                                                      
     .           xy_sum(t496-1,1) = xy_sum(t496-1,1) + xy_val(t496-1,1)*        
     .       1      xyz_delmass(t496-1,1,k)                                     
     .        enddo                                                             
   368          &      + LatentHeat * xyz_QH2OVap (:,:,k)       &
   369          &      - LatentHeatFusion * xyz_QH2OSol (:,:,k)
   370        xy_Sum = xy_Sum + xy_Val * xyz_DelMass(:,:,k)
   371      end do
   372  !!$    if ( FlagIncludeIcePhaseChange ) then
   373        xy_Sum = xy_Sum - LatentHeatFusion * xy_Snow * 2.0_DP * DelTime
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xy_sum)                                                    
     .        do t516 = 1, xy_sum.DSC.U2*xy_sum.DSC.U1 + xy_sum.DSC.U2          
     .           xy_sum(t516-1,1) = xy_sum(t516-1,1) - latentheatfusion*xy_snow(
     .       1      t516-1,1)*2.00000000000000e+000*deltime                     
     .           xy_ratio(t516-1,1) = (xy_sum(t516-1,1)-xy_sumb(t516-1,1))/(    
     .       1      xy_sum(t516-1,1)+1.00000000000000e-100)                     
     .        enddo                                                             
   374  !!$    end if
   375  
   376      xy_Ratio = ( xy_Sum - xy_SumB ) / ( xy_Sum + 1.0d-100 )
   377      do j = 1, jmax
   378        do i = 0, imax-1
   379          if ( abs( xy_Ratio(i,j) ) > 1.0d-10 ) then
   380            call MessageNotify( 'M', module_name, 'Modified condensate static energy is not conserved, %f.', d = (/ xy_Ratio(i,j) /) )
   381          end if
   382        end do
   383      end do
   384  
   385  
   386  
   387      xy_Sum = 0.0_DP
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t534 = 1, xy_sum.DSC.U2*xy_sum.DSC.U1 + xy_sum.DSC.U2          
     .           xy_sum(t534-1,1) = 0.0000000000000000e+000                     
     .        enddo                                                             
   388      do k = kmax, 1, -1
   389        xy_Val = xyz_QH2OVapB(:,:,k) + xyz_QH2OLiqB(:,:,k) + xyz_QH2OSolB(:,:,k)
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xy_val,xy_sum)                                             
     .        do t540 = 1, jmax*imax                                            
     .           xy_val(t540-1,1) = xyz_qh2ovapb(t540-1,1,k) + xyz_qh2oliqb(t540
     .       1      -1,1,k) + xyz_qh2osolb(t540-1,1,k)                          
     .           xy_sum(t540-1,1) = xy_sum(t540-1,1) + xy_val(t540-1,1)*        
     .       1      xyz_delmass(t540-1,1,k)                                     
     .        enddo                                                             
   390        xy_Sum = xy_Sum + xy_Val * xyz_DelMass(:,:,k)
   391      end do
   392  
   393      xy_SumB = xy_Sum
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xy_sum)                                                    
     .        do t560 = 1, xy_sumb.DSC.U2*xy_sumb.DSC.U1 + xy_sumb.DSC.U2       
     .           xy_sumb(t560-1,1) = xy_sum(t560-1,1)                           
     .           xy_sum(t560-1,1) = 0.0000000000000000e+000                     
     .        enddo                                                             
   394  
   395      xy_Sum = 0.0_DP
   396      do k = kmax, 1, -1
   397        xy_Val = xyz_QH2OVap (:,:,k) + xyz_QH2OLiq (:,:,k) + xyz_QH2OSol (:,:,k)
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xy_val,xy_sum)                                             
     .        do t570 = 1, jmax*imax                                            
     .           xy_val1 = xyz_qh2ovap(t570-1,1,k) + xyz_qh2oliq(t570-1,1,k) +  
     .       1      xyz_qh2osol(t570-1,1,k)                                     
     .           xy_sum(t570-1,1) = xy_sum(t570-1,1) + xy_val1*xyz_delmass(t570-
     .       1      1,1,k)                                                      
     .        enddo                                                             
   398        xy_Sum = xy_Sum + xy_Val * xyz_DelMass(:,:,k)
   399      end do
   400      xy_Sum = xy_Sum + ( xy_Rain + xy_Snow ) * 2.0_DP * DelTime
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xy_sum)                                                    
     .        do t590 = 1, xy_sum.DSC.U2*xy_sum.DSC.U1 + xy_sum.DSC.U2          
     .           xy_sum(t590-1,1) = xy_sum(t590-1,1) + (xy_rain(t590-1,1)+      
     .       1      xy_snow(t590-1,1))*2.00000000000000e+000*deltime            
     .           xy_ratio(t590-1,1) = (xy_sum(t590-1,1)-xy_sumb(t590-1,1))/(    
     .       1      xy_sum(t590-1,1)+1.00000000000000e-100)                     
     .        enddo                                                             
   401  
   402      xy_Ratio = ( xy_Sum - xy_SumB ) / ( xy_Sum + 1.0d-100 )
   403      do j = 1, jmax
   404        do i = 0, imax-1
   405          if ( abs( xy_Ratio(i,j) ) > 1.0d-10 ) then
   406            call MessageNotify( 'M', module_name, 'H2O mass is not conserved, %f.', d = (/ xy_Ratio(i,j) /) )
   407          end if
   408        end do
   409      end do
   410  
   411  
   412    end subroutine CloudNoneConsChk
   413  
   414    !--------------------------------------------------------------------------------------
   415  
   416    subroutine CloudNoneInit( &
   417      & ArgFlagSnow             &
   418      & )
   419  
   420      ! ファイル入出力補助
   421      ! File I/O support
   422      !
   423      use dc_iounit, only: FileOpen
   424  
   425      ! NAMELIST ファイル入力に関するユーティリティ
   426      ! Utilities for NAMELIST file input
   427      !
   428      use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid
   429  
   430      ! ヒストリデータ出力
   431      ! History data output
   432      !
   433      use gtool_historyauto, only: HistoryAutoAddVariable
   434  
   435      ! 雲関系ルーチン
   436      ! Cloud-related routines
   437      !
   438      use cloud_utils, only : CloudUtilsInit
   439  
   440  
   441      ! 宣言文 ; Declaration statements
   442      !
   443  
   444      logical, intent(in) :: ArgFlagSnow
   445  
   446  
   447      character(STRING) :: CloudCoverMethod
   448      character(STRING) :: SnowMethod
   449  
   450      integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号.
   451                                ! Unit number for NAMELIST file open
   452      integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT.
   453                                ! IOSTAT of NAMELIST read
   454  
   455      ! NAMELIST 変数群
   456      ! NAMELIST group name
   457      !
   458      namelist /cloud_none_nml/ &
   459        & FlagPRCPPC,          &
   460        & FlagPRCPEvap,        &
   461        & PRCPArea,            &
   462        & PRCPEvapArea
   463            !
   464            ! デフォルト値については初期化手続 "cloud_none#CloudNoneInit"
   465            ! のソースコードを参照のこと.
   466            !
   467            ! Refer to source codes in the initialization procedure
   468            ! "cloud_none#CloudNoneInit" for the default values.
   469            !
   470  
   471      ! 実行文 ; Executable statement
   472      !
   473  
   474      if ( cloud_none_inited ) return
   475  
   476  
   477      FlagSnow = ArgFlagSnow
   478  
   479  
   480      ! デフォルト値の設定
   481      ! Default values settings
   482      !
   483      FlagPRCPPC          = .false.
   484      FlagPRCPEvap        = .false.
   485  !!$    PRCPEvapArea        = 0.5_DP
   486      PRCPArea            = 1.0_DP
   487  !!$    PRCPArea            = 0.5_DP
   488      PRCPEvapArea        = 1.0_DP
   489  !!$    PRCPEvapArea        = 0.5_DP
   490  
   491  
   492      ! NAMELIST の読み込み
   493      ! NAMELIST is input
   494      !
   495      if ( trim(namelist_filename) /= '' ) then
   496        call FileOpen( unit_nml, &          ! (out)
   497          & namelist_filename, mode = 'r' ) ! (in)
   498  
   499        rewind( unit_nml )
   500        read( unit_nml,                     & ! (in)
   501          & nml = cloud_none_nml,           & ! (out)
   502          & iostat = iostat_nml )             ! (out)
   503        close( unit_nml )
   504  
   505        call NmlutilMsg( iostat_nml, module_name ) ! (in)
   506      end if
   507  
   508  
   509  
   510      ! Initialization of modules used in this module
   511      !
   512  
   513      ! 雲関系ルーチン
   514      ! Cloud-related routines
   515      !
   516      call CloudUtilsInit( &
   517        & FlagSnow         &
   518        & )
   519  
   520  
   521      ! ヒストリデータ出力のためのへの変数登録
   522      ! Register of variables for history data output
   523      !
   524  !!$    call HistoryAutoAddVariable( 'EffCloudCover', &
   525  !!$      & (/ 'lon ', 'lat ', 'time' /), &
   526  !!$      & 'effective cloud cover', '1' )
   527  
   528  
   529  
   530      ! 印字 ; Print
   531      !
   532      call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   533      call MessageNotify( 'M', module_name, 'FlagPRCPPC          = %b', l = (/ FlagPRCPPC /) )
   534      call MessageNotify( 'M', module_name, 'FlagPRCPEvap        = %b', l = (/ FlagPRCPEvap /) )
   535      call MessageNotify( 'M', module_name, 'PRCPArea            = %f', d = (/ PRCPArea /) )
   536      call MessageNotify( 'M', module_name, 'PRCPEvapArea        = %f', d = (/ PRCPEvapArea /) )
   537      call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   538  
   539  
   540      cloud_none_inited = .true.
   541  
   542    end subroutine CloudNoneInit
   543  
   544    !--------------------------------------------------------------------------------------
   545  
   546  end module cloud_none
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:54 2016
FILE NAME: cloud_none.f90
PROGRAM NAME: cloud_none
FORMAT LIST

  LINE    LOOP      FORTRAN STATEMENT

     1:             != 雲なしモデル
     2:             !
     3:             != No cloud model
     4:             !
     5:             ! Authors::   Yoshiyuki O. Takahashi
     6:             ! Version::   $Id: cloud_none.f90,v 1.1 2015/01/29 12:19:41 yot Exp $
     7:             ! Tag Name::  $Name:  $
     8:             ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9:             ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10:             !
    11:             
    12:             module cloud_none
    13:               !
    14:               != 雲なしモデル
    15:               !
    16:               != No cloud model
    17:               !
    18:               ! <b>Note that Japanese and English are described in parallel.</b>
    19:               !
    20:               ! 
    21:               !
    22:               ! This is a no cloud model, i.e., condensation rate is converted to 
    23:               ! precipitation rate. 
    24:               !
    25:               !== Procedures List
    26:               !
    27:             !!$  ! RadiationFluxDennouAGCM :: 放射フラックスの計算
    28:             !!$  ! ------------            :: ------------
    29:             !!$  ! RadiationFluxDennouAGCM :: Calculate radiation flux
    30:               !
    31:               !== NAMELIST
    32:               !
    33:               ! NAMELIST#cloud_none_nml
    34:               !
    35:             
    36:               ! モジュール引用 ; USE statements
    37:             
    38:               !
    39:               ! Kind type parameter
    40:               !
    41:               use dc_types, only: DP, &      ! Double precision.
    42:                 &                 STRING, &  ! Strings.
    43:                 &                 TOKEN      ! Keywords.
    44:             
    45:               ! メッセージ出力
    46:               ! Message output
    47:               !
    48:               use dc_message, only: MessageNotify
    49:             
    50:               ! 格子点設定
    51:               ! Grid points settings
    52:               !
    53:               use gridset, only: imax, & ! 経度格子点数.
    54:                                          ! Number of grid points in longitude
    55:                 &                jmax, & ! 緯度格子点数.
    56:                                          ! Number of grid points in latitude
    57:                 &                kmax    ! 鉛直層数.
    58:                                          ! Number of vertical level
    59:             
    60:               implicit none
    61:             
    62:               private
    63:             
    64:             
    65:               ! 公開手続き
    66:               ! Public procedure
    67:               !
    68:               public :: CloudNoneWithIce
    69:               public :: CloudNone
    70:               public :: CloudNoneInit
    71:             
    72:             
    73:               ! 公開変数
    74:               ! Public variables
    75:               !
    76:             
    77:             
    78:               ! 非公開変数
    79:               ! Private variables
    80:               !
    81:               logical , save        :: FlagSnow
    82:                                        ! A flag for snow
    83:             
    84:               logical , save :: FlagPRCPPC
    85:               logical , save :: FlagPRCPEvap
    86:             
    87:               real(DP), save :: PRCPArea
    88:                 !                           a_p
    89:               real(DP), save :: PRCPEvapArea
    90:                 !                           A = max( a_p - a, 0 )
    91:             
    92:             
    93:               logical, save :: cloud_none_inited = .false.
    94:                                           ! 初期設定フラグ.
    95:                                           ! Initialization flag
    96:             
    97:               character(*), parameter:: module_name = 'cloud_none'
    98:                                           ! モジュールの名称.
    99:                                           ! Module name
   100:               character(*), parameter:: version = &
   101:                 & '$Name:  $' // &
   102:                 & '$Id: cloud_none.f90,v 1.1 2015/01/29 12:19:41 yot Exp $'
   103:                                           ! モジュールのバージョン
   104:                                           ! Module version
   105:             
   106:               !--------------------------------------------------------------------------------------
   107:             
   108:             contains
   109:             
   110:               !--------------------------------------------------------------------------------------
   111:             
   112:               subroutine CloudNoneWithIce(               &
   113:                 & xyr_Press, xyz_Press,                  & ! (in   )
   114:                 & xyz_DQRainDt, xyz_DQSnowDt,            & ! (in   )
   115:                 & xyz_Temp, xyz_QH2OVap,                 & ! (inout)
   116:                 & xy_SurfRainFlux, xy_SurfSnowFlux       & ! (out  )
   117:                 & )
   118:             
   119:                 ! 時刻管理
   120:                 ! Time control
   121:                 !
   122:                 use timeset, only: &
   123:                   & DelTime            ! $ \Delta t $ [s]
   124:             
   125:                 ! 物理定数設定
   126:                 ! Physical constants settings
   127:                 !
   128:                 use constants, only:  &
   129:                   & CpDry,            &
   130:                                           ! $ C_p $ [J kg-1 K-1].
   131:                                           ! 乾燥大気の定圧比熱.
   132:                                           ! Specific heat of air at constant pressure
   133:                   & Grav
   134:                                           ! $ g $ [m s-2].
   135:                                           ! 重力加速度.
   136:                                           ! Gravitational acceleration
   137:             
   138:                 ! 雲関系ルーチン
   139:                 ! Cloud-related routines
   140:                 !
   141:                 use cloud_utils, only: &
   142:                   & CloudUtilsPRCPStepPC1Grid, &
   143:                   & CloudUtilsPRCPEvap1Grid
   144:             
   145:                 real(DP), intent(in   ) :: xyr_Press       ( 0:imax-1, 1:jmax, 0:kmax )
   146:                 real(DP), intent(in   ) :: xyz_Press       ( 0:imax-1, 1:jmax, 1:kmax )
   147:                 real(DP), intent(in   ) :: xyz_DQRainDt    ( 0:imax-1, 1:jmax, 1:kmax )
   148:                 real(DP), intent(in   ) :: xyz_DQSnowDt    ( 0:imax-1, 1:jmax, 1:kmax )
   149:                 real(DP), intent(inout) :: xyz_Temp        ( 0:imax-1, 1:jmax, 1:kmax )
   150:                 real(DP), intent(inout) :: xyz_QH2OVap     ( 0:imax-1, 1:jmax, 1:kmax )
   151:                 real(DP), intent(out  ) :: xy_SurfRainFlux ( 0:imax-1, 1:jmax )
   152:                 real(DP), intent(out  ) :: xy_SurfSnowFlux ( 0:imax-1, 1:jmax )
   153:             
   154:             
   155:                 ! 作業変数
   156:                 ! Work variables
   157:                 !
   158:                 real(DP) :: xyz_TempB   ( 0:imax-1, 1:jmax, 1:kmax )
   159:                 real(DP) :: xyz_QH2OVapB( 0:imax-1, 1:jmax, 1:kmax )
   160:                 real(DP) :: xyz_QH2OLiqB( 0:imax-1, 1:jmax, 1:kmax )
   161:                 real(DP) :: xyz_QH2OSolB( 0:imax-1, 1:jmax, 1:kmax )
   162:                 real(DP) :: xyz_DelMass ( 0:imax-1, 1:jmax, 1:kmax )
   163:             
   164:                 real(DP) :: xyz_QH2OLiqTMP( 0:imax-1, 1:jmax, 1:kmax )
   165:                 real(DP) :: xyz_QH2OSolTMP( 0:imax-1, 1:jmax, 1:kmax )
   166:             
   167:                 integer  :: i
   168:                 integer  :: j
   169:                 integer  :: k
   170:             
   171:             
   172:                 ! 初期化確認
   173:                 ! Initialization check
   174:                 !
   175:                 if ( .not. cloud_none_inited ) then
   176:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   177:                 end if
   178:             
   179:             
   180:                 ! Save variables
   181:                 !
   182: **W---->A       xyz_TempB    = xyz_Temp
   183: |||     A       xyz_QH2OVapB = xyz_QH2OVap
   184: |||     A       xyz_QH2OLiqB = xyz_DQRainDt * ( 2.0_DP * DelTime )
   185: **W---- A       xyz_QH2OSolB = xyz_DQSnowDt * ( 2.0_DP * DelTime )
   186:             
   187:             
   188: W------>        do k = 1, kmax
   189: |**==== A         xyz_DelMass(:,:,k) = ( xyr_Press(:,:,k-1) - xyr_Press(:,:,k) ) / Grav
   190: W------         end do
   191:             
   192:                 ! Freezing and melting switching at temperature of TempCondWater
   193: *W----->A       xy_SurfRainFlux = 0.0_DP
   194: *W----- A       xy_SurfSnowFlux = 0.0_DP
   195: +------>        do j = 1, jmax
   196: |+----->          do i = 0, imax-1
   197: ||+---->            do k = kmax, 1, -1
   198: |||         
   199: |||                   if ( FlagPRCPPC ) then
   200: |||                     call CloudUtilsPRCPStepPC1Grid(  &
   201: |||                       & xyr_Press(i,j,k-1), xyr_Press(i,j,k),       & ! (in   )
   202: |||                       & xyz_Temp(i,j,k),                            & ! (inout)
   203: |||                       & xy_SurfRainFlux(i,j), xy_SurfSnowFlux(i,j)  & ! (out  )
   204: |||                       & )
   205: |||                   end if
   206: |||         
   207: |||                   if ( FlagPRCPEvap ) then
   208: |||                     call CloudUtilsPRCPEvap1Grid(                               &
   209: |||                       & xyz_Press(i,j,k), xyr_Press(i,j,k-1), xyr_Press(i,j,k), & ! (in)
   210: |||                       & PRCPArea, PRCPEvapArea,                                 & ! (in)
   211: |||                       & xyz_Temp(i,j,k), xyz_QH2OVap(i,j,k),                    & ! (inout)
   212: |||                       & xy_SurfRainFlux(i,j), xy_SurfSnowFlux(i,j)              & ! (inout)
   213: |||                       & )
   214: |||                   end if
   215: |||         
   216: |||                   xy_SurfRainFlux(i,j) = xy_SurfRainFlux(i,j) &
   217: |||                     & + xyz_DQRainDt(i,j,k) * xyz_DelMass(i,j,k)
   218: |||                   xy_SurfSnowFlux(i,j) = xy_SurfSnowFlux(i,j) &
   219: |||                     & + xyz_DQSnowDt(i,j,k) * xyz_DelMass(i,j,k)
   220: |||         
   221: ||+----             end do
   222: |+-----           end do
   223: +------         end do
   224:             
   225:             
   226: **W---->A       xyz_QH2OLiqTMP = 0.0_DP
   227: **W---- A       xyz_QH2OSolTMP = 0.0_DP
   228:                 call CloudNoneConsChk(                             &
   229:             !!$      & FlagIncludeIcePhaseChange,                           &
   230:                   & xyr_Press,                                               &
   231:                   & xyz_TempB, xyz_QH2OVapB, xyz_QH2OLiqB  , xyz_QH2OSolB  , &
   232:                   & xyz_Temp , xyz_QH2OVap , xyz_QH2OLiqTMP, xyz_QH2OSolTMP, &
   233:                   & xy_SurfRainFlux, xy_SurfSnowFlux                         &
   234:                   & )
   235:             
   236:             
   237:               end subroutine CloudNoneWithIce
   238:             
   239:               !--------------------------------------------------------------------------------------
   240:             
   241:               subroutine CloudNone(                      &
   242:                 & xyr_Press, xyz_Press,                  & ! (in   )
   243:                 & xyz_DQRainDt,                          & ! (in   )
   244:                 & xyz_Temp, xyz_QH2OVap,                 & ! (inout)
   245:                 & xy_SurfRainFlux                        & ! (out  )
   246:                 & )
   247:             
   248:                 real(DP), intent(in   ) :: xyr_Press       ( 0:imax-1, 1:jmax, 0:kmax )
   249:                 real(DP), intent(in   ) :: xyz_Press       ( 0:imax-1, 1:jmax, 1:kmax )
   250:                 real(DP), intent(in   ) :: xyz_DQRainDt    ( 0:imax-1, 1:jmax, 1:kmax )
   251:                 real(DP), intent(inout) :: xyz_Temp        ( 0:imax-1, 1:jmax, 1:kmax )
   252:                 real(DP), intent(inout) :: xyz_QH2OVap     ( 0:imax-1, 1:jmax, 1:kmax )
   253:                 real(DP), intent(out  ) :: xy_SurfRainFlux ( 0:imax-1, 1:jmax )
   254:             
   255:             
   256:                 ! 作業変数
   257:                 ! Work variables
   258:                 !
   259:                 real(DP) :: xyz_DQSnowDt    ( 0:imax-1, 1:jmax, 1:kmax )
   260:                 real(DP) :: xy_SurfSnowFlux ( 0:imax-1, 1:jmax )
   261:             
   262:             
   263:                 ! 初期化確認
   264:                 ! Initialization check
   265:                 !
   266:                 if ( .not. cloud_none_inited ) then
   267:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   268:                 end if
   269:             
   270:             
   271:                 if ( FlagPRCPPC ) then
   272:                   call MessageNotify( 'E', module_name, 'FlagPRCPPC has to be .false., if CloudNone subroutine is used.' )
   273:                 end if
   274:             
   275:             
   276: W**==== A       xyz_DQSnowDt = 0.0_DP
   277:             
   278:                 call CloudNoneWithIce(               &
   279:                   & xyr_Press, xyz_Press,                  & ! (in   )
   280:                   & xyz_DQRainDt, xyz_DQSnowDt,            & ! (in   )
   281:                   & xyz_Temp, xyz_QH2OVap,                 & ! (inout)
   282:                   & xy_SurfRainFlux, xy_SurfSnowFlux       & ! (out  )
   283:                   & )
   284:             
   285:             
   286:               end subroutine CloudNone
   287:             
   288:               !--------------------------------------------------------------------------------------
   289:             
   290:               subroutine CloudNoneConsChk(                             &
   291:             !!$    & FlagIncludeIcePhaseChange,                           &
   292:                 & xyr_Press,                                           &
   293:                 & xyz_TempB, xyz_QH2OVapB, xyz_QH2OLiqB, xyz_QH2OSolB, &
   294:                 & xyz_Temp , xyz_QH2OVap , xyz_QH2OLiq , xyz_QH2OSol , &
   295:                 & xy_Rain, xy_Snow                                     &
   296:                 & )
   297:             
   298:             
   299:                 ! 時刻管理
   300:                 ! Time control
   301:                 !
   302:                 use timeset, only: &
   303:                   & DelTime            ! $ \Delta t $ [s]
   304:             
   305:                 ! 物理定数設定
   306:                 ! Physical constants settings
   307:                 !
   308:                 use constants, only: &
   309:                   & Grav, & 
   310:                                           ! $ g $ [m s-2]. 
   311:                                           ! 重力加速度. 
   312:                                           ! Gravitational acceleration
   313:                   & CpDry, &
   314:                                           ! $ C_p $ [J kg-1 K-1]. 
   315:                                           ! 乾燥大気の定圧比熱. 
   316:                                           ! Specific heat of air at constant pressure
   317:                   & LatentHeat, &
   318:                                           ! $ L $ [J kg-1] . 
   319:                                           ! 凝結の潜熱. 
   320:                                           ! Latent heat of condensation
   321:                   & LatentHeatFusion
   322:                                           ! $ L $ [J kg-1] .
   323:                                           ! 融解の潜熱.
   324:                                           ! Latent heat of fusion
   325:             
   326:             !!$    logical , intent(in) :: FlagIncludeIcePhaseChange
   327:                 real(DP), intent(in) :: xyr_Press   (0:imax-1, 1:jmax, 0:kmax)
   328:                 real(DP), intent(in) :: xyz_TempB   (0:imax-1, 1:jmax, 1:kmax)
   329:                 real(DP), intent(in) :: xyz_QH2OVapB(0:imax-1, 1:jmax, 1:kmax)
   330:                 real(DP), intent(in) :: xyz_QH2OLiqB(0:imax-1, 1:jmax, 1:kmax)
   331:                 real(DP), intent(in) :: xyz_QH2OSolB(0:imax-1, 1:jmax, 1:kmax)
   332:                 real(DP), intent(in) :: xyz_Temp    (0:imax-1, 1:jmax, 1:kmax)
   333:                 real(DP), intent(in) :: xyz_QH2OVap (0:imax-1, 1:jmax, 1:kmax)
   334:                 real(DP), intent(in) :: xyz_QH2OLiq (0:imax-1, 1:jmax, 1:kmax)
   335:                 real(DP), intent(in) :: xyz_QH2OSol (0:imax-1, 1:jmax, 1:kmax)
   336:                 real(DP), intent(in) :: xy_Rain     (0:imax-1, 1:jmax)
   337:                 real(DP), intent(in) :: xy_Snow     (0:imax-1, 1:jmax)
   338:             
   339:                 ! Local variables
   340:                 !
   341:                 real(DP) :: xyz_DelMass(0:imax-1, 1:jmax, 1:kmax)
   342:                 real(DP) :: xy_Val(0:imax-1, 1:jmax)
   343:                 real(DP) :: xy_SumB(0:imax-1, 1:jmax)
   344:                 real(DP) :: xy_Sum(0:imax-1, 1:jmax)
   345:                 real(DP) :: xy_Ratio(0:imax-1, 1:jmax)
   346:                 integer  :: i
   347:                 integer  :: j
   348:                 integer  :: k
   349:             
   350:             
   351: W------>        do k = 1, kmax
   352: |**==== A         xyz_DelMass(:,:,k) = ( xyr_Press(:,:,k-1) - xyr_Press(:,:,k) ) / Grav
   353: W------         end do
   354:             
   355: W*=====         xy_Sum = 0.0_DP
   356: +------>        do k = kmax, 1, -1
   357: |*W---->A         xy_Val =   CpDry * xyz_TempB(:,:,k)               &
   358: |||                 &      + LatentHeat * xyz_QH2OVapB(:,:,k)       &
   359: |||                 &      - LatentHeatFusion * xyz_QH2OSolB(:,:,k)
   360: |*W---- A         xy_Sum = xy_Sum + xy_Val * xyz_DelMass(:,:,k)
   361: +------         end do
   362:             
   363: *W----->A       xy_SumB = xy_Sum
   364: ||          
   365: *W----- A       xy_Sum = 0.0_DP
   366: +------>        do k = kmax, 1, -1
   367: |*W---->A         xy_Val =   CpDry * xyz_Temp (:,:,k)               &
   368: |||                 &      + LatentHeat * xyz_QH2OVap (:,:,k)       &
   369: |||                 &      - LatentHeatFusion * xyz_QH2OSol (:,:,k)
   370: |*W---- A         xy_Sum = xy_Sum + xy_Val * xyz_DelMass(:,:,k)
   371: +------         end do
   372:             !!$    if ( FlagIncludeIcePhaseChange ) then
   373: *W----->A         xy_Sum = xy_Sum - LatentHeatFusion * xy_Snow * 2.0_DP * DelTime
   374: ||          !!$    end if
   375: ||          
   376: *W-----         xy_Ratio = ( xy_Sum - xy_SumB ) / ( xy_Sum + 1.0d-100 )
   377: +------>        do j = 1, jmax
   378: |+----->          do i = 0, imax-1
   379: ||                  if ( abs( xy_Ratio(i,j) ) > 1.0d-10 ) then
   380: ||                    call MessageNotify( 'M', module_name, 'Modified condensate static energy is not conserved, %f.', d = (/ xy_Ratio(i,j) /) )
   381: ||                  end if
   382: |+-----           end do
   383: +------         end do
   384:             
   385:             
   386:             
   387: W*=====         xy_Sum = 0.0_DP
   388: +------>        do k = kmax, 1, -1
   389: |*W---->A         xy_Val = xyz_QH2OVapB(:,:,k) + xyz_QH2OLiqB(:,:,k) + xyz_QH2OSolB(:,:,k)
   390: |*W---- A         xy_Sum = xy_Sum + xy_Val * xyz_DelMass(:,:,k)
   391: +------         end do
   392:             
   393: *W----->A       xy_SumB = xy_Sum
   394: ||          
   395: *W----- A       xy_Sum = 0.0_DP
   396: +------>        do k = kmax, 1, -1
   397: |*W---->A         xy_Val = xyz_QH2OVap (:,:,k) + xyz_QH2OLiq (:,:,k) + xyz_QH2OSol (:,:,k)
   398: |*W---- A         xy_Sum = xy_Sum + xy_Val * xyz_DelMass(:,:,k)
   399: +------         end do
   400: *W----->A       xy_Sum = xy_Sum + ( xy_Rain + xy_Snow ) * 2.0_DP * DelTime
   401: ||          
   402: *W-----         xy_Ratio = ( xy_Sum - xy_SumB ) / ( xy_Sum + 1.0d-100 )
   403: +------>        do j = 1, jmax
   404: |+----->          do i = 0, imax-1
   405: ||                  if ( abs( xy_Ratio(i,j) ) > 1.0d-10 ) then
   406: ||                    call MessageNotify( 'M', module_name, 'H2O mass is not conserved, %f.', d = (/ xy_Ratio(i,j) /) )
   407: ||                  end if
   408: |+-----           end do
   409: +------         end do
   410:             
   411:             
   412:               end subroutine CloudNoneConsChk
   413:             
   414:               !--------------------------------------------------------------------------------------
   415:             
   416:               subroutine CloudNoneInit( &
   417:                 & ArgFlagSnow             &
   418:                 & )
   419:             
   420:                 ! ファイル入出力補助
   421:                 ! File I/O support
   422:                 !
   423:                 use dc_iounit, only: FileOpen
   424:             
   425:                 ! NAMELIST ファイル入力に関するユーティリティ
   426:                 ! Utilities for NAMELIST file input
   427:                 !
   428:                 use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid
   429:             
   430:                 ! ヒストリデータ出力
   431:                 ! History data output
   432:                 !
   433:                 use gtool_historyauto, only: HistoryAutoAddVariable
   434:             
   435:                 ! 雲関系ルーチン
   436:                 ! Cloud-related routines
   437:                 !
   438:                 use cloud_utils, only : CloudUtilsInit
   439:             
   440:             
   441:                 ! 宣言文 ; Declaration statements
   442:                 !
   443:             
   444:                 logical, intent(in) :: ArgFlagSnow
   445:             
   446:             
   447:                 character(STRING) :: CloudCoverMethod
   448:                 character(STRING) :: SnowMethod
   449:             
   450:                 integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号.
   451:                                           ! Unit number for NAMELIST file open
   452:                 integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT.
   453:                                           ! IOSTAT of NAMELIST read
   454:             
   455:                 ! NAMELIST 変数群
   456:                 ! NAMELIST group name
   457:                 !
   458:                 namelist /cloud_none_nml/ &
   459:                   & FlagPRCPPC,          &
   460:                   & FlagPRCPEvap,        &
   461:                   & PRCPArea,            &
   462:                   & PRCPEvapArea
   463:                       !
   464:                       ! デフォルト値については初期化手続 "cloud_none#CloudNoneInit"
   465:                       ! のソースコードを参照のこと.
   466:                       !
   467:                       ! Refer to source codes in the initialization procedure
   468:                       ! "cloud_none#CloudNoneInit" for the default values.
   469:                       !
   470:             
   471:                 ! 実行文 ; Executable statement
   472:                 !
   473:             
   474:                 if ( cloud_none_inited ) return
   475:             
   476:             
   477:                 FlagSnow = ArgFlagSnow
   478:             
   479:             
   480:                 ! デフォルト値の設定
   481:                 ! Default values settings
   482:                 !
   483:                 FlagPRCPPC          = .false.
   484:                 FlagPRCPEvap        = .false.
   485:             !!$    PRCPEvapArea        = 0.5_DP
   486:                 PRCPArea            = 1.0_DP
   487:             !!$    PRCPArea            = 0.5_DP
   488:                 PRCPEvapArea        = 1.0_DP
   489:             !!$    PRCPEvapArea        = 0.5_DP
   490:             
   491:             
   492:                 ! NAMELIST の読み込み
   493:                 ! NAMELIST is input
   494:                 !
   495:                 if ( trim(namelist_filename) /= '' ) then
   496:                   call FileOpen( unit_nml, &          ! (out)
   497:                     & namelist_filename, mode = 'r' ) ! (in)
   498:             
   499:                   rewind( unit_nml )
   500:                   read( unit_nml,                     & ! (in)
   501:                     & nml = cloud_none_nml,           & ! (out)
   502:                     & iostat = iostat_nml )             ! (out)
   503:                   close( unit_nml )
   504:             
   505:                   call NmlutilMsg( iostat_nml, module_name ) ! (in)
   506:                 end if
   507:             
   508:             
   509:             
   510:                 ! Initialization of modules used in this module
   511:                 !
   512:             
   513:                 ! 雲関系ルーチン
   514:                 ! Cloud-related routines
   515:                 !
   516:                 call CloudUtilsInit( &
   517:                   & FlagSnow         &
   518:                   & )
   519:             
   520:             
   521:                 ! ヒストリデータ出力のためのへの変数登録
   522:                 ! Register of variables for history data output
   523:                 !
   524:             !!$    call HistoryAutoAddVariable( 'EffCloudCover', &
   525:             !!$      & (/ 'lon ', 'lat ', 'time' /), &
   526:             !!$      & 'effective cloud cover', '1' )
   527:             
   528:             
   529:             
   530:                 ! 印字 ; Print
   531:                 !
   532:                 call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   533:                 call MessageNotify( 'M', module_name, 'FlagPRCPPC          = %b', l = (/ FlagPRCPPC /) )
   534:                 call MessageNotify( 'M', module_name, 'FlagPRCPEvap        = %b', l = (/ FlagPRCPEvap /) )
   535:                 call MessageNotify( 'M', module_name, 'PRCPArea            = %f', d = (/ PRCPArea /) )
   536:                 call MessageNotify( 'M', module_name, 'PRCPEvapArea        = %f', d = (/ PRCPEvapArea /) )
   537:                 call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   538:             
   539:             
   540:                 cloud_none_inited = .true.
   541:             
   542:               end subroutine CloudNoneInit
   543:             
   544:               !--------------------------------------------------------------------------------------
   545:             
   546:             end module cloud_none
