Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:55 2016
FILE NAME: cloud_simple.f90
PROGRAM NAME: cloud_simple
DIAGNOSTIC LIST

  LINE  LEVEL( NO.): DIAGNOSTIC MESSAGE

   193  opt  (  11): Fused array assignments. :line 193 - 243
   193  opt  (1593): Loop nest collapsed into one loop.
   193  vec  (   4): Vectorized array expression.
   193  vec  (  29): ADB is used for array.: xyz_dqraindt
   193  vec  (  29): ADB is used for array.: xyz_qh2oliq
   193  vec  (  29): ADB is used for array.: xyz_qh2oliqb
   193  vec  (  29): ADB is used for array.: xyz_qh2ovapb
   193  vec  (  29): ADB is used for array.: xyz_qh2ovap
   193  vec  (  29): ADB is used for array.: xyz_tempb
   193  vec  (  29): ADB is used for array.: xyz_temp
   256  opt  (  11): Fused array assignments. :line 256 - 257
   256  opt  (1593): Loop nest collapsed into one loop.
   256  vec  (   4): Vectorized array expression.
   256  vec  (  29): ADB is used for array.: xyz_qh2osol
   256  vec  (  29): ADB is used for array.: xyz_qh2osolb
   268  opt  (1593): Loop nest collapsed into one loop.
   268  vec  (   4): Vectorized array expression.
   268  vec  (  29): ADB is used for array.: xyz_dqsnowdt
   277  opt  (  11): Fused array assignments. :line 277 - 278
   277  opt  (1593): Loop nest collapsed into one loop.
   277  vec  (   4): Vectorized array expression.
   277  vec  (  29): ADB is used for array.: xyz_qh2osol
   277  vec  (  29): ADB is used for array.: xyz_qh2osolb
   331  opt  (1593): Loop nest collapsed into one loop.
   331  vec  (   1): Vectorized loop.
   331  vec  (  29): ADB is used for array.: xy_surfrainflux
   331  vec  (  29): ADB is used for array.: xy_surfsnowflux
   331  vec  (  29): ADB is used for array.: xy_prcp
   331  vec  (  29): ADB is used for array.: xyz_temp
   345  opt  (  11): Fused array assignments. :line 345 - 346
   345  opt  (1593): Loop nest collapsed into one loop.
   345  vec  (   4): Vectorized array expression.
   345  vec  (  29): ADB is used for array.: xy_surfsnowflux
   345  vec  (  29): ADB is used for array.: xy_surfrainflux
   345  vec  (  29): ADB is used for array.: xy_prcp
   438  opt  (1593): Loop nest collapsed into one loop.
   438  vec  (   1): Vectorized loop.
   438  vec  (  29): ADB is used for array.: xyz_delmass
   438  vec  (  29): ADB is used for array.: xyr_press
   445  opt  (1593): Loop nest collapsed into one loop.
   445  vec  (   4): Vectorized array expression.
   445  vec  (  29): ADB is used for array.: xyz_dqh2oliqdt
   447  opt  (1593): Loop nest collapsed into one loop.
   447  vec  (   4): Vectorized array expression.
   447  vec  (  29): ADB is used for array.: xy_surfrainflux
   450  vec  (   3): Unvectorized loop.
   456  opt  (1017): Subroutine call prevents optimization.
   457  vec  (   9): Vectorization obstructive statement.
   457  vec  (  10): Vectorization obstructive procedure reference.:xyz_calcqvapsatonliq
   462  vec  (  10): Vectorization obstructive procedure reference.:cloudsimpleevap1grid
   481  opt  (1592): Outer loop unrolled inside inner loop.
   481  vec  (   4): Vectorized array expression.
   481  vec  (  29): ADB is used for array.: xy_prcp
   481  vec  (  29): ADB is used for array.: xy_surfrainflux
   481  vec  (   4): Vectorized array expression.
   481  vec  (  29): ADB is used for array.: xy_prcp
   481  vec  (  29): ADB is used for array.: xy_surfrainflux
   485  opt  (1593): Loop nest collapsed into one loop.
   485  vec  (   4): Vectorized array expression.
   485  vec  (  29): ADB is used for array.: xy_prcp
   486  vec  (   3): Unvectorized loop.
   486  vec  (  13): Overhead of loop division is too large.
   487  opt  (1593): Loop nest collapsed into one loop.
   487  vec  (   4): Vectorized array expression.
   487  vec  (  29): ADB is used for array.: xy_prcp
   487  vec  (  29): ADB is used for array.: xyr_press
   487  vec  (  29): ADB is used for array.: xyz_dqh2oliqdt
   579  opt  (  11): Fused array assignments. :line 579 - 586
   579  opt  (1593): Loop nest collapsed into one loop.
   579  vec  (   4): Vectorized array expression.
   579  vec  (  29): ADB is used for array.: xyz_qh2osolb
   579  vec  (  29): ADB is used for array.: xyz_qh2osol
   579  vec  (  29): ADB is used for array.: xyz_qh2oliqb
   579  vec  (  29): ADB is used for array.: xyz_qh2oliq
   579  vec  (  29): ADB is used for array.: xyz_qh2ovapb
   579  vec  (  29): ADB is used for array.: xyz_qh2ovap
   579  vec  (  29): ADB is used for array.: xyz_tempb
   579  vec  (  29): ADB is used for array.: xyz_temp
   588  opt  (1593): Loop nest collapsed into one loop.
   588  vec  (   1): Vectorized loop.
   588  vec  (  29): ADB is used for array.: xyr_press
   594  opt  (  11): Fused array assignments. :line 594 - 595
   594  opt  (1593): Loop nest collapsed into one loop.
   594  vec  (   4): Vectorized array expression.
   594  vec  (  29): ADB is used for array.: xy_snow
   594  vec  (  29): ADB is used for array.: xy_rain
   603  vec  (   3): Unvectorized loop.
   604  opt  (1017): Subroutine call prevents optimization.
   604  vec  (  10): Vectorization obstructive procedure reference.:cloudutilsprcpsteppc1grid
   614  vec  (   3): Unvectorized loop.
   615  opt  (1017): Subroutine call prevents optimization.
   615  vec  (  10): Vectorization obstructive procedure reference.:cloudutilsprcpevap1grid
   626  opt  (  11): Fused array assignments. :line 626 - 652
   626  opt  (1593): Loop nest collapsed into one loop.
   626  vec  (   4): Vectorized array expression.
   626  vec  (  29): ADB is used for array.: xy_snow
   626  vec  (  29): ADB is used for array.: xy_rain
   626  vec  (  29): ADB is used for array.: xyz_qh2osolb
   626  vec  (  29): ADB is used for array.: xyz_qh2osol
   626  vec  (  29): ADB is used for array.: xyz_qh2oliqb
   626  vec  (  29): ADB is used for array.: xyz_qh2oliq
   765  opt  (1593): Loop nest collapsed into one loop.
   765  vec  (   1): Vectorized loop.
   765  vec  (  29): ADB is used for array.: xyz_delmass
   765  vec  (  29): ADB is used for array.: xyr_press
   770  opt  (  11): Fused array assignments. :line 770 - 771
   770  opt  (1593): Loop nest collapsed into one loop.
   770  vec  (   4): Vectorized array expression.
   770  vec  (  29): ADB is used for array.: xy_surfsnowflux
   770  vec  (  29): ADB is used for array.: xy_surfrainflux
   821  vec  (   3): Unvectorized loop.
   824  opt  (1017): Subroutine call prevents optimization.
   825  vec  (   9): Vectorization obstructive statement.
   825  vec  (  10): Vectorization obstructive procedure reference.:xyz_calcqvapsat
   830  vec  (   9): Vectorization obstructive statement.
   830  vec  (  10): Vectorization obstructive procedure reference.:xyz_calcqvapsatonliq
   835  vec  (   9): Vectorization obstructive statement.
   835  vec  (  10): Vectorization obstructive procedure reference.:xyz_calcqvapsatonsol
   839  vec  (  10): Vectorization obstructive procedure reference.:messagenotifyc
   843  vec  (  10): Vectorization obstructive procedure reference.:cloudsimpleevap1grid
  1074  opt  (1593): Loop nest collapsed into one loop.
  1074  vec  (   1): Vectorized loop.
  1074  vec  (  29): ADB is used for array.: xyr_press
  1078  opt  (1593): Loop nest collapsed into one loop.
  1078  vec  (   4): Vectorized array expression.
  1079  vec  (   3): Unvectorized loop.
  1079  vec  (  13): Overhead of loop division is too large.
  1080  opt  (  11): Fused array assignments. :line 1080 - 1083
  1080  opt  (1593): Loop nest collapsed into one loop.
  1080  vec  (   4): Vectorized array expression.
  1080  vec  (  29): ADB is used for array.: xy_sum
  1080  vec  (  29): ADB is used for array.: xy_val
  1080  vec  (  29): ADB is used for array.: xyz_qh2osolb
  1080  vec  (  29): ADB is used for array.: xyz_qh2ovapb
  1080  vec  (  29): ADB is used for array.: xyz_tempb
  1086  opt  (  11): Fused array assignments. :line 1086 - 1088
  1086  opt  (1593): Loop nest collapsed into one loop.
  1086  vec  (   4): Vectorized array expression.
  1086  vec  (  29): ADB is used for array.: xy_sum
  1089  vec  (   3): Unvectorized loop.
  1089  vec  (  13): Overhead of loop division is too large.
  1090  opt  (  11): Fused array assignments. :line 1090 - 1093
  1090  opt  (1593): Loop nest collapsed into one loop.
  1090  vec  (   4): Vectorized array expression.
  1090  vec  (  29): ADB is used for array.: xy_sum
  1090  vec  (  29): ADB is used for array.: xy_val
  1090  vec  (  29): ADB is used for array.: xyz_qh2osol
  1090  vec  (  29): ADB is used for array.: xyz_qh2ovap
  1090  vec  (  29): ADB is used for array.: xyz_temp
  1096  opt  (1593): Loop nest collapsed into one loop.
  1096  vec  (   4): Vectorized array expression.
  1096  vec  (  29): ADB is used for array.: xy_sum
  1096  vec  (  29): ADB is used for array.: xy_snow
  1099  opt  (1593): Loop nest collapsed into one loop.
  1099  vec  (   4): Vectorized array expression.
  1099  vec  (  29): ADB is used for array.: xy_sum
  1101  vec  (   3): Unvectorized loop.
  1103  opt  (1017): Subroutine call prevents optimization.
  1103  vec  (  10): Vectorization obstructive procedure reference.:messagenotifyc
  1110  opt  (1593): Loop nest collapsed into one loop.
  1110  vec  (   4): Vectorized array expression.
  1111  vec  (   3): Unvectorized loop.
  1111  vec  (  13): Overhead of loop division is too large.
  1112  opt  (  11): Fused array assignments. :line 1112 - 1113
  1112  opt  (1593): Loop nest collapsed into one loop.
  1112  vec  (   4): Vectorized array expression.
  1112  vec  (  29): ADB is used for array.: xy_sum
  1112  vec  (  29): ADB is used for array.: xy_val
  1112  vec  (  29): ADB is used for array.: xyz_qh2osolb
  1112  vec  (  29): ADB is used for array.: xyz_qh2oliqb
  1112  vec  (  29): ADB is used for array.: xyz_qh2ovapb
  1116  opt  (  11): Fused array assignments. :line 1116 - 1118
  1116  opt  (1593): Loop nest collapsed into one loop.
  1116  vec  (   4): Vectorized array expression.
  1116  vec  (  29): ADB is used for array.: xy_sum
  1119  vec  (   3): Unvectorized loop.
  1119  vec  (  13): Overhead of loop division is too large.
  1120  opt  (  11): Fused array assignments. :line 1120 - 1121
  1120  opt  (1593): Loop nest collapsed into one loop.
  1120  vec  (   4): Vectorized array expression.
  1120  vec  (  29): ADB is used for array.: xy_sum
  1120  vec  (  29): ADB is used for array.: xyz_qh2osol
  1120  vec  (  29): ADB is used for array.: xyz_qh2oliq
  1120  vec  (  29): ADB is used for array.: xyz_qh2ovap
  1123  opt  (  11): Fused array assignments. :line 1123 - 1125
  1123  opt  (1593): Loop nest collapsed into one loop.
  1123  vec  (   4): Vectorized array expression.
  1123  vec  (  29): ADB is used for array.: xy_sum
  1123  vec  (  29): ADB is used for array.: xy_snow
  1123  vec  (  29): ADB is used for array.: xy_rain
  1127  vec  (   3): Unvectorized loop.
  1129  opt  (1017): Subroutine call prevents optimization.
  1129  vec  (  10): Vectorization obstructive procedure reference.:messagenotifyc
  1179  opt  (1592): Outer loop unrolled inside inner loop.
  1179  vec  (   4): Vectorized array expression.
  1179  vec  (  29): ADB is used for array.: xyz_cloudcover
  1179  vec  (   4): Vectorized array expression.
  1179  vec  (  29): ADB is used for array.: xyz_cloudcover
  1184  opt  (  11): Fused array assignments. :line 1184 - 1191
  1184  vec  (   4): Vectorized array expression.
  1184  vec  (  29): ADB is used for array.: xyz_cloudcover
  1184  vec  (  29): ADB is used for array.: xyz_qh2otot
  1195  opt  (  11): Fused array assignments. :line 1195 - 1196
  1195  opt  (1592): Outer loop unrolled inside inner loop.
  1195  vec  (   4): Vectorized array expression.
  1195  vec  (  29): ADB is used for array.: xyz_qh2otot
  1195  vec  (   4): Vectorized array expression.
  1195  vec  (  29): ADB is used for array.: xyz_qh2otot
  1200  opt  (1592): Outer loop unrolled inside inner loop.
  1200  vec  (   4): Vectorized array expression.
  1200  vec  (  29): ADB is used for array.: xyz_cloudcover
  1200  vec  (   4): Vectorized array expression.
  1200  vec  (  29): ADB is used for array.: xyz_cloudcover
  1204  opt  (1593): Loop nest collapsed into one loop.
  1204  vec  (   1): Vectorized loop.
  1204  vec  (  29): ADB is used for array.: xyz_cloudcover
  1217  opt  (  11): Fused array assignments. :line 1217 - 1218
  1217  opt  (1593): Loop nest collapsed into one loop.
  1217  vec  (   4): Vectorized array expression.
  1217  vec  (  29): ADB is used for array.: xyz_cloudcover
  1265  opt  (  11): Fused array assignments. :line 1265 - 1266
  1265  opt  (1593): Loop nest collapsed into one loop.
  1265  vec  (   4): Vectorized array expression.
  1265  vec  (  29): ADB is used for array.: xyz_qh2oice
  1265  vec  (  29): ADB is used for array.: xyz_qh2owat
  1265  vec  (  29): ADB is used for array.: xyz_watfrac
  1265  vec  (  29): ADB is used for array.: xyz_qh2owatandice
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:55 2016
FILE NAME: cloud_simple.f90
PROGRAM NAME: cloud_simple
TRANSFORMATION LIST

  LINE                   FORTRAN STATEMENT

     1  != 簡単雲モデル
     2  !
     3  != Simple cloud model
     4  !
     5  ! Authors::   Yoshiyuki O. Takahashi
     6  ! Version::   $Id: cloud_simple.f90,v 1.9 2015/01/29 12:06:43 yot Exp $
     7  ! Tag Name::  $Name:  $
     8  ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9  ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10  !
    11  
    12  module cloud_simple
    13    !
    14    != 簡単雲モデル
    15    !
    16    != Simple cloud model
    17    !
    18    ! <b>Note that Japanese and English are described in parallel.</b>
    19    !
    20    ! 簡単雲モデルによる雲の計算.
    21    !
    22    ! In this module, the amount of cloud is calculated by use of a simple
    23    ! cloud model.
    24    !
    25    !== Procedures List
    26    !
    27  !!$  ! RadiationFluxDennouAGCM :: 放射フラックスの計算
    28  !!$  ! ------------            :: ------------
    29  !!$  ! RadiationFluxDennouAGCM :: Calculate radiation flux
    30    !
    31    !== NAMELIST
    32    !
    33    ! NAMELIST#cloud_simple_nml
    34    !
    35  
    36    ! モジュール引用 ; USE statements
    37  
    38    !
    39    ! Kind type parameter
    40    !
    41    use dc_types, only: DP, &      ! Double precision.
    42      &                 STRING, &  ! Strings.
    43      &                 TOKEN      ! Keywords.
    44  
    45    ! メッセージ出力
    46    ! Message output
    47    !
    48    use dc_message, only: MessageNotify
    49  
    50    ! 格子点設定
    51    ! Grid points settings
    52    !
    53    use gridset, only: imax, & ! 経度格子点数.
    54                               ! Number of grid points in longitude
    55      &                jmax, & ! 緯度格子点数.
    56                               ! Number of grid points in latitude
    57      &                kmax    ! 鉛直層数.
    58                               ! Number of vertical level
    59  
    60    implicit none
    61  
    62    private
    63  
    64  
    65    ! 公開手続き
    66    ! Public procedure
    67    !
    68    public :: CloudSimple
    69    public :: CloudSimpleCalcPRCPKeyLLTemp
    70    public :: CloudSimpleCalcPRCPKeyLLTemp3D
    71    public :: CloudSimpleCalcPRCPStepPC
    72    public :: CloudSimpleWithIce
    73    public :: CloudSimpleCalcCloudCover
    74    public :: CloudSimpleInit
    75  
    76    public :: CloudSimpleDivideWatAndIce
    77  
    78  
    79    ! 公開変数
    80    ! Public variables
    81    !
    82  
    83  
    84    ! 非公開変数
    85    ! Private variables
    86    !
    87    logical , save        :: FlagSnow
    88                             ! A flag for snow
    89  
    90    integer , save        :: IDCloudCoverMethod
    91    integer , parameter   :: IDCloudCoverMethodConst    = 1
    92    integer , parameter   :: IDCloudCoverMethodRH       = 2
    93    integer , parameter   :: IDCloudCoverMethodRHLin    = 3
    94  
    95    integer , save        :: IDSnowMethod
    96    integer , parameter   :: IDSnowMethodKeyLLTemp      = 11
    97    integer , parameter   :: IDSnowMethodStepPC         = 12
    98  
    99    real(DP), save        :: CloudLifeTime
   100    real(DP), save        :: CloudWatLifeTime
   101    real(DP), save        :: CloudIceLifeTime
   102  
   103    real(DP), save        :: CloudCover
   104    real(DP), save        :: CloudCoverRHCrtl
   105    real(DP), save        :: CloudCoverMin
   106  
   107  
   108    logical , save :: FlagPRCPPC
   109  
   110    logical , save :: FlagPRCPEvap
   111    real(DP), save :: PRCPArea
   112      !                           a_p
   113    real(DP), save :: PRCPEvapArea
   114      !                           A = max( a_p - a, 0 )
   115  
   116  
   117    logical, save :: cloud_simple_inited = .false.
   118                                ! 初期設定フラグ.
   119                                ! Initialization flag
   120  
   121    character(*), parameter:: module_name = 'cloud_simple'
   122                                ! モジュールの名称.
   123                                ! Module name
   124    character(*), parameter:: version = &
   125      & '$Name:  $' // &
   126      & '$Id: cloud_simple.f90,v 1.9 2015/01/29 12:06:43 yot Exp $'
   127                                ! モジュールのバージョン
   128                                ! Module version
   129  
   130    !--------------------------------------------------------------------------------------
   131  
   132  contains
   133  
   134    !--------------------------------------------------------------------------------------
   135  
   136    subroutine CloudSimple(                             &
   137      & xyr_Press, xyz_Press,                           & ! (in)
   138      & xyz_Temp,                                       & ! (inout)
   139  !!$    & xyz_DQH2OLiqDtCum, xyz_DQH2OLiqDtLSC,           & ! (in)
   140      & xyz_QH2OVap, xyz_QH2OLiq,                       & ! (inout)
   141      & xy_Rain, xy_Snow                                & ! (out)
   142      & )
   143  
   144      ! USE statements
   145      !
   146  
   147      ! 時刻管理
   148      ! Time control
   149      !
   150      use timeset, only: &
   151        & DelTime            ! $ \Delta t $ [s]
   152  
   153  
   154      real(DP), intent(in   ) :: xyr_Press        ( 0:imax-1, 1:jmax, 0:kmax )
   155      real(DP), intent(in   ) :: xyz_Press        ( 0:imax-1, 1:jmax, 1:kmax )
   156      real(DP), intent(inout) :: xyz_Temp         ( 0:imax-1, 1:jmax, 1:kmax )
   157  !!$    real(DP), intent(in   ) :: xyz_DQH2OLiqDtCum( 0:imax-1, 1:jmax, 1:kmax )
   158  !!$    real(DP), intent(in   ) :: xyz_DQH2OLiqDtLSC( 0:imax-1, 1:jmax, 1:kmax )
   159      real(DP), intent(inout) :: xyz_QH2OVap      ( 0:imax-1, 1:jmax, 1:kmax )
   160      real(DP), intent(inout) :: xyz_QH2OLiq      ( 0:imax-1, 1:jmax, 1:kmax )
   161      real(DP), intent(out  ) :: xy_Rain          ( 0:imax-1, 1:jmax )
   162      real(DP), intent(out  ) :: xy_Snow          ( 0:imax-1, 1:jmax )
   163  
   164  
   165      ! Tentative
   166      real(DP) xyz_DQH2OLiqDtCum( 0:imax-1, 1:jmax, 1:kmax )
   167      real(DP) xyz_DQH2OLiqDtLSC( 0:imax-1, 1:jmax, 1:kmax )
   168  
   169      real(DP) :: xyz_TempB   ( 0:imax-1, 1:jmax, 1:kmax )
   170      real(DP) :: xyz_QH2OVapB( 0:imax-1, 1:jmax, 1:kmax )
   171      real(DP) :: xyz_QH2OLiqB( 0:imax-1, 1:jmax, 1:kmax )
   172      real(DP) :: xyz_DQRainDt( 0:imax-1, 1:jmax, 1:kmax )
   173      real(DP) :: xyz_DQSnowDt( 0:imax-1, 1:jmax, 1:kmax )
   174  
   175      real(DP) :: xyz_QH2OSolB( 0:imax-1, 1:jmax, 1:kmax )
   176      real(DP) :: xyz_QH2OSol ( 0:imax-1, 1:jmax, 1:kmax )
   177  
   178  !!$    real(DP) :: xyz_DTempDtPrcpPCCum( 0:imax-1, 1:jmax, 1:kmax )
   179  !!$    real(DP) :: xyz_DTempDtPrcpPCLsc( 0:imax-1, 1:jmax, 1:kmax )
   180  
   181      ! 実行文 ; Executable statement
   182      !
   183  
   184      ! 初期化確認
   185      ! Initialization check
   186      !
   187      if ( .not. cloud_simple_inited ) then
   188        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   189      end if
   190  
   191  
   192      ! tentative treatment
   193      xyz_DQH2OLiqDtCum = 0.0_DP
     .        d4 = 1.D0/(2.00000000000000e+000*deltime)                         
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t290 = 1, xyz_dqh2oliqdtcum.DSC.U3*(xyz_dqh2oliqdtcum.DSC.U2*  
     .       1   xyz_dqh2oliqdtcum.DSC.U1 + xyz_dqh2oliqdtcum.DSC.U2)           
     .           xyz_dqh2oliqdtcum1 = 0.0000000000000000e+000                   
     .           xyz_dqh2oliqdtlsc1 = 0.0000000000000000e+000                   
     .           xyz_tempb(t290-1,1,1) = xyz_temp(t290-1,1,1)                   
     .           xyz_qh2ovapb(t290-1,1,1) = xyz_qh2ovap(t290-1,1,1)             
     .           xyz_qh2oliqb(t290-1,1,1) = xyz_qh2oliq(t290-1,1,1)             
     .           xyz_qh2oliq(t290-1,1,1) = xyz_qh2oliq(t290-1,1,1)*(dexp((-((   
     .       1      2.00000000000000e+000*deltime)/(cloudlifetime +             
     .       2      1.00000000000000e-100))))) + (xyz_dqh2oliqdtcum1 +          
     .       3      xyz_dqh2oliqdtlsc1)*cloudlifetime*(1.00000000000000e+000 - (
     .       4      dexp((-((2.00000000000000e+000*deltime)/(cloudlifetime +    
     .       5      1.00000000000000e-100))))))                                 
     .           xyz_dqraindt1 = xyz_qh2oliqb(t290-1,1,1) + (xyz_dqh2oliqdtcum1 
     .       1       + xyz_dqh2oliqdtlsc1)*2.00000000000000e+000*deltime -      
     .       2      xyz_qh2oliq(t290-1,1,1)                                     
     .           xyz_dqraindt(t290-1,1,1) = xyz_dqraindt1*d4                    
     .        enddo                                                             
   194      xyz_DQH2OLiqDtLSC = 0.0_DP
   195  
   196  
   197      ! Numerical solution
   198  
   199  !!$      xyz_DQCloudWaterDt = xyz_DQCloudWaterDt &
   200  !!$        & - xyz_QCloudWater / ( CloudLifeTime + 1.0d-100 )
   201  
   202  
   203  !      ( X_{t+1} - X_{t-1} ) / ( 2 \Delta t ) = Q - X_{t+1} / \tau
   204  !
   205  !      X_{t+1} / ( 2 \Delta t )  + X_{t+1} / \tau = X_{t-1} / ( 2 \Delta t ) + Q
   206  !      ( 1 / ( 2 \Delta t )  + 1 / \tau ) X_{t+1} = X_{t-1} / ( 2 \Delta t ) + Q
   207  !      X_{t+1} = ( X_{t-1} / ( 2 \Delta t ) + Q ) / ( 1 / ( 2 \Delta t )  + 1 / \tau )
   208  
   209  !!$    xyz_QH2OLiq =                                                           &
   210  !!$      &   (                                                                 &
   211  !!$      &       xyz_QH2OLiq / ( 2.0_DP * DelTime )                            &
   212  !!$      &     + xyz_DQH2OLiqDtCum + xyz_DQH2OLiqDtLSC                         &
   213  !!$      &   )                                                                 &
   214  !!$      & / ( 1.0_DP / ( 2.0_DP * DelTime ) + 1.0_DP / ( CloudLifeTime + 1.0d-100 ) )
   215  !!$
   216  !!$    call CloudUtilsCalcPRCPKeyLLTemp3D(          &
   217  !!$      & xyr_Press, xyz_Temp, xyz_DQH2OLiqDtCum,  &  ! (in )
   218  !!$      & xy_RainCum, xy_SnowCum                   &  ! (out)
   219  !!$      & )
   220  !!$    call CloudUtilsCalcPRCPKeyLLTemp3D(          &
   221  !!$      & xyr_Press, xyz_Temp, xyz_DQH2OLiqDtLsc,  &  ! (in )
   222  !!$      & xy_RainLsc, xy_SnowLsc                   &  ! (out)
   223  !!$      & )
   224      !-----
   225  
   226  
   227      ! Analytical solution
   228  
   229      ! save values before adjustment
   230      xyz_TempB    = xyz_Temp
   231      xyz_QH2OVapB = xyz_QH2OVap
   232      xyz_QH2OLiqB = xyz_QH2OLiq
   233  
   234      xyz_QH2OLiq =                                                                 &
   235        &   xyz_QH2OLiq * exp( - 2.0_DP * DelTime / ( CloudLifeTime + 1.0e-100_DP ) )  &
   236        & + ( xyz_DQH2OLiqDtCum + xyz_DQH2OLiqDtLSC ) * CloudLifeTime               &
   237        &   * ( 1.0_DP - exp( - 2.0_DP * DelTime / ( CloudLifeTime + 1.0e-100_DP ) ) )
   238  
   239      xyz_DQRainDt =                                                     &
   240        &   xyz_QH2OLiqB                                                 &
   241        & + ( xyz_DQH2OLiqDtCum + xyz_DQH2OLiqDtLSC ) * 2.0_DP * DelTime &
   242        & - xyz_QH2OLiq
   243      xyz_DQRainDt = xyz_DQRainDt / ( 2.0_DP * DelTime )
   244  
   245  
   246  
   247      select case ( IDSnowMethod )
   248      case ( IDSnowMethodKeyLLTemp )
   249  
   250        call CloudSimpleCalcPRCPKeyLLTemp3D(      &
   251          & xyr_Press, xyz_Press, xyz_DQRainDt,   &  ! (in )
   252          & xyz_Temp, xyz_QH2OVap,                &  ! (in )
   253          & xy_Rain, xy_Snow                      &  ! (out)
   254          & )
   255  
   256        xyz_QH2OSolB = 0.0_DP
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t374 = 1, xyz_qh2osolb.DSC.U3*(xyz_qh2osolb.DSC.U2*            
     .       1   xyz_qh2osolb.DSC.U1 + xyz_qh2osolb.DSC.U2)                     
     .           xyz_qh2osolb(t374-1,1,1) = 0.0000000000000000e+000             
     .           xyz_qh2osol(t374-1,1,1) = 0.0000000000000000e+000              
     .        enddo                                                             
   257        xyz_QH2OSol  = 0.0_DP
   258        call CloudSimpleConsChk(                                 &
   259          & .false.,                                             &
   260          & xyr_Press,                                           &
   261          & xyz_TempB, xyz_QH2OVapB, xyz_QH2OLiqB, xyz_QH2OSolB, &
   262          & xyz_Temp , xyz_QH2OVap , xyz_QH2OLiq , xyz_QH2OSol , &
   263          & xy_Rain, xy_Snow                                     &
   264          & )
   265  
   266      case ( IDSnowMethodStepPC )
   267  
   268        xyz_DQSnowDt = 0.0_DP
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t353 = 1, xyz_dqsnowdt.DSC.U3*(xyz_dqsnowdt.DSC.U2*            
     .       1   xyz_dqsnowdt.DSC.U1 + xyz_dqsnowdt.DSC.U2)                     
     .           xyz_dqsnowdt(t353-1,1,1) = 0.0000000000000000e+000             
     .        enddo                                                             
   269  
   270        call CloudSimpleCalcPRCPStepPC(      &
   271          & xyr_Press, xyz_Press,                  & ! (in   )
   272          & xyz_DQRainDt, xyz_DQSnowDt,            & ! (in   )
   273          & xyz_Temp, xyz_QH2OVap,                 & ! (inout)
   274          & xy_Rain, xy_Snow                       & ! (out  )
   275          & )
   276  
   277        xyz_QH2OSolB = 0.0_DP
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t362 = 1, xyz_qh2osolb.DSC.U3*(xyz_qh2osolb.DSC.U2*            
     .       1   xyz_qh2osolb.DSC.U1 + xyz_qh2osolb.DSC.U2)                     
     .           xyz_qh2osolb(t362-1,1,1) = 0.0000000000000000e+000             
     .           xyz_qh2osol(t362-1,1,1) = 0.0000000000000000e+000              
     .        enddo                                                             
   278        xyz_QH2OSol  = 0.0_DP
   279        call CloudSimpleConsChk(                                 &
   280          & .true.,                                              &
   281          & xyr_Press,                                           &
   282          & xyz_TempB, xyz_QH2OVapB, xyz_QH2OLiqB, xyz_QH2OSolB, &
   283          & xyz_Temp , xyz_QH2OVap , xyz_QH2OLiq , xyz_QH2OSol , &
   284          & xy_Rain, xy_Snow                                     &
   285          & )
   286  
   287      end select
   288  
   289  
   290    end subroutine CloudSimple
   291  
   292    !--------------------------------------------------------------------------------------
   293  
   294    subroutine CloudSimpleCalcPRCPKeyLLTemp(  &
   295      & xyz_Temp, xy_PRCP,                   &  ! (in )
   296      & xy_SurfRainFlux, xy_SurfSnowFlux     &  ! (out)
   297      & )
   298  
   299  
   300      ! 雪と海氷の定数の設定
   301      ! Setting constants of snow and sea ice
   302      !
   303      use constants_snowseaice, only: TempCondWater
   304  
   305  
   306      real(DP), intent(in ) :: xyz_Temp       ( 0:imax-1, 1:jmax, 1:kmax )
   307      real(DP), intent(in ) :: xy_PRCP        ( 0:imax-1, 1:jmax )
   308      real(DP), intent(out) :: xy_SurfRainFlux( 0:imax-1, 1:jmax )
   309      real(DP), intent(out) :: xy_SurfSnowFlux( 0:imax-1, 1:jmax )
   310  
   311  
   312      ! 作業変数
   313      ! Work variables
   314      !
   315      integer:: i               ! 経度方向に回る DO ループ用作業変数
   316                                ! Work variables for DO loop in longitude
   317      integer:: j               ! 緯度方向に回る DO ループ用作業変数
   318                                ! Work variables for DO loop in latitude
   319  
   320  
   321      ! 初期化確認
   322      ! Initialization check
   323      !
   324      if ( .not. cloud_simple_inited ) then
   325        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   326      end if
   327  
   328  
   329      if ( FlagSnow ) then
   330  
   331        do j = 1, jmax
   332          do i = 0, imax-1
   333            if ( xyz_Temp(i,j,1) > TempCondWater ) then
   334              xy_SurfRainFlux(i,j) = xy_PRCP(i,j)
   335              xy_SurfSnowFlux(i,j) = 0.0_DP
   336            else
   337              xy_SurfRainFlux(i,j) = 0.0_DP
   338              xy_SurfSnowFlux(i,j) = xy_PRCP(i,j)
   339            end if
   340          end do
   341        end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do j = 1, jmax*imax                                               
     .           if (xyz_temp(j-1,1,1) .gt. tempcondwater) then                 
     .              xy_surfrainflux1 = xy_prcp(j-1,1)                           
     .              xy_surfsnowflux2 = 0.0000000000000000e+000                  
     .           else                                                           
     .              xy_surfrainflux1 = 0.0000000000000000e+000                  
     .              xy_surfsnowflux2 = xy_prcp(j-1,1)                           
     .           endif                                                          
     .           xy_surfsnowflux(j-1,1) = xy_surfsnowflux2                      
     .           xy_surfrainflux(j-1,1) = xy_surfrainflux1                      
     .        enddo                                                             
     .        goto 10008                                                        
   342  
   343      else
   344  
   345        xy_SurfRainFlux = xy_PRCP
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t90 = 1, jmax*imax                                             
     .           xy_surfrainflux(t90-1,1) = xy_prcp(t90-1,1)                    
     .           xy_surfsnowflux(t90-1,1) = 0.0000000000000000e+000             
     .        enddo                                                             
   346        xy_SurfSnowFlux = 0.0_DP
   347  
   348      end if
   349  
   350  
   351    end subroutine CloudSimpleCalcPRCPKeyLLTemp
   352  
   353    !--------------------------------------------------------------------------------------
   354  
   355    subroutine CloudSimpleCalcPRCPKeyLLTemp3D(  &
   356      & xyr_Press, xyz_Press, xyz_DQH2OLiqDt,   &  ! (in )
   357      & xyz_Temp, xyz_QH2OVap,                  &  ! (in )
   358      & xy_SurfRainFlux, xy_SurfSnowFlux        &  ! (out)
   359      & )
   360  
   361      ! 時刻管理
   362      ! Time control
   363      !
   364      use timeset, only: &
   365        & DelTime            ! $ \Delta t $ [s]
   366  
   367      ! 物理定数設定
   368      ! Physical constants settings
   369      !
   370      use constants, only:  &
   371        & CpDry,            &
   372                                ! $ C_p $ [J kg-1 K-1].
   373                                ! 乾燥大気の定圧比熱.
   374                                ! Specific heat of air at constant pressure
   375        & Grav,             &
   376                                ! $ g $ [m s-2].
   377                                ! 重力加速度.
   378                                ! Gravitational acceleration
   379        & LatentHeat,       &
   380                                ! $ L $ [J kg-1] .
   381                                ! 蒸発の潜熱.
   382                                ! Latent heat
   383        & LatentHeatFusion, &
   384                                ! $ L $ [J kg-1] .
   385                                ! 融解の潜熱.
   386                                ! Latent heat of fusion
   387        & EpsV
   388                                ! $ \epsilon_v $ .
   389                                ! 水蒸気分子量比.
   390                                ! Molecular weight of water vapor
   391  
   392      ! 飽和比湿の算出
   393      ! Evaluate saturation specific humidity
   394      !
   395      use saturate, only: &
   396        & xyz_CalcQVapSat, &
   397        & xyz_CalcQVapSatOnLiq
   398  
   399      real(DP), intent(in   ) :: xyr_Press       ( 0:imax-1, 1:jmax, 0:kmax )
   400      real(DP), intent(in   ) :: xyz_Press       ( 0:imax-1, 1:jmax, 1:kmax )
   401      real(DP), intent(in   ) :: xyz_DQH2OLiqDt  ( 0:imax-1, 1:jmax, 1:kmax )
   402      real(DP), intent(inout) :: xyz_Temp        ( 0:imax-1, 1:jmax, 1:kmax )
   403      real(DP), intent(inout) :: xyz_QH2OVap     ( 0:imax-1, 1:jmax, 1:kmax )
   404      real(DP), intent(out  ) :: xy_SurfRainFlux ( 0:imax-1, 1:jmax )
   405      real(DP), intent(out  ) :: xy_SurfSnowFlux ( 0:imax-1, 1:jmax )
   406  
   407  
   408      ! 作業変数
   409      ! Work variables
   410      !
   411      real(DP) :: xyz_DelMass ( 0:imax-1, 1:jmax, 1:kmax )
   412      real(DP) :: xyz_DQRainDt( 0:imax-1, 1:jmax, 1:kmax )
   413  
   414      real(DP) :: VirTemp
   415      real(DP) :: aaa_QH2OVapSat(1,1,1)
   416      real(DP) :: QH2OVapSat
   417      real(DP) :: PRCPFlux
   418      real(DP) :: DelPRCPFlux
   419      real(DP) :: DelQH2OVap
   420      real(DP) :: LatentHeatLocal
   421      character(STRING) :: CharPhase
   422  
   423      real(DP) :: xy_PRCP( 0:imax-1, 1:jmax )
   424  
   425      integer  :: i
   426      integer  :: j
   427      integer  :: k
   428  
   429  
   430      ! 初期化確認
   431      ! Initialization check
   432      !
   433      if ( .not. cloud_simple_inited ) then
   434        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   435      end if
   436  
   437  
   438      do k = 1, kmax
   439        xyz_DelMass(:,:,k) = ( xyr_Press(:,:,k-1) - xyr_Press(:,:,k) ) / Grav
   440      end do
     .        d1 = 1.D0/grav                                                    
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do k = 1, kmax*jmax*imax                                          
     .           xyz_delmass(k-1,1,1) = (xyr_press(k-1,1,0)-xyr_press(k-1,1,1))*
     .       1      d1                                                          
     .        enddo                                                             
   441  
   442  
   443      if ( FlagPRCPEvap ) then
   444  
   445        xyz_DQRainDt = xyz_DQH2OLiqDt
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t383 = 1, xyz_dqraindt.DSC.U3*(xyz_dqraindt.DSC.U2*            
     .       1   xyz_dqraindt.DSC.U1 + xyz_dqraindt.DSC.U2)                     
     .           xyz_dqraindt(t383-1,1,1) = xyz_dqh2oliqdt(t383-1,1,1)          
     .        enddo                                                             
   446  
   447        xy_SurfRainFlux = 0.0_DP
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t395 = 1, jmax*imax                                            
     .           xy_surfrainflux(t395-1,1) = 0.0000000000000000e+000            
     .        enddo                                                             
   448        do j = 1, jmax
   449          do i = 0, imax-1
   450            do k = kmax, 1, -1
   451  
   452              ! This is moved below.
   453  !!$            xy_SurfRainFlux(i,j) = xy_SurfRainFlux(i,j) &
   454  !!$              & + xyz_DQRainDt(i,j,k) * xyz_DelMass(i,j,k)
   455  
   456              CharPhase = 'liquid'
   457              aaa_QH2OVapSat(1:1,1:1,1:1) = &
   458                & xyz_CalcQVapSatOnLiq( xyz_Temp(i:i,j:j,k:k), xyz_Press(i:i,j:j,k:k) )
   459              PRCPFlux = xy_SurfRainFlux(i,j)
   460              QH2OVapSat = aaa_QH2OVapSat(1,1,1)
   461              VirTemp = xyz_Temp(i,j,k) * ( 1.0_DP + ((( 1.0_DP / EpsV ) - 1.0_DP ) * xyz_QH2OVap(i,j,k)) )
   462              call CloudSimpleEvap1Grid( &
   463                & CharPhase,                                    &
   464                & xyz_DelMass(i,j,k), xyz_Press(i,j,k), xyz_QH2OVap(i,j,k), QH2OVapSat, VirTemp, &
   465                & PRCPFlux,                                                                      &
   466                & DelPRCPFlux                                       &
   467                & )
   468              xy_SurfRainFlux(i,j) = PRCPFlux - DelPRCPFlux
   469              LatentHeatLocal      = LatentHeat
   470              DelQH2OVap = DelPRCPFlux * ( 2.0_DP * DelTime ) / xyz_DelMass(i,j,k)
   471              xyz_QH2OVap(i,j,k) = xyz_QH2OVap(i,j,k) + DelQH2OVap
   472              xyz_Temp(i,j,k) = xyz_Temp(i,j,k) - LatentHeatLocal * DelQH2OVap / CpDry
   473  
   474              xy_SurfRainFlux(i,j) = xy_SurfRainFlux(i,j) &
   475                & + xyz_DQRainDt(i,j,k) * xyz_DelMass(i,j,k)
   476  
   477            end do
   478          end do
   479        end do
   480  
   481        xy_PRCP = xy_SurfRainFlux
     .        if (xy_prcp.DSC.U2 .gt. 0) then                                   
     .           j1 = and(xy_prcp.DSC.U2,3)                                     
     .  !cdir    nodep                                                          
     .           do t401 = 1, j1                                                
     .  !cdir       nodep                                                       
     .              do t403 = 1, xy_prcp.DSC.U1 + 2 - min0(1,xy_prcp.DSC.U1 + 1)
     .                 xy_prcp(t403-1,t401) = xy_surfrainflux(t403-1,t401)      
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t401 = j1 + 1, xy_prcp.DSC.U2, 4                            
     .  !cdir       nodep                                                       
     .              do t403 = 1, xy_prcp.DSC.U1 + 2 - min0(1,xy_prcp.DSC.U1 + 1)
     .                 xy_prcp(t403-1,t401) = xy_surfrainflux(t403-1,t401)      
     .                 xy_prcp(t403-1,t401+1) = xy_surfrainflux(t403-1,t401+1)  
     .                 xy_prcp(t403-1,t401+2) = xy_surfrainflux(t403-1,t401+2)  
     .                 xy_prcp(t403-1,t401+3) = xy_surfrainflux(t403-1,t401+3)  
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
     .        goto 10024                                                        
   482  
   483      else
   484  
   485        xy_PRCP = 0.0d0
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t363 = 1, xy_prcp.DSC.U2*xy_prcp.DSC.U1 + xy_prcp.DSC.U2       
     .           xy_prcp(t363-1,1) = 0.0000000000000000e+000                    
     .        enddo                                                             
   486        do k = kmax, 1, -1
   487          xy_PRCP = xy_PRCP                                       &
     .        d2 = 1.D0/grav                                                    
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xy_prcp,xyr_press)                                         
     .        do t369 = 1, xy_prcp.DSC.U2*xy_prcp.DSC.U1 + xy_prcp.DSC.U2       
     .           xy_prcp(t369-1,1) = xy_prcp(t369-1,1) + xyz_dqh2oliqdt(t369-1,1
     .       1      ,k)*(xyr_press(t369-1,1,k-1)-xyr_press(t369-1,1,k))*d2      
     .        enddo                                                             
   488            & + xyz_DQH2OLiqDt(:,:,k)                             &
   489            & * ( xyr_Press(:,:,k-1) - xyr_Press(:,:,k) ) / Grav
   490        end do
   491  
   492      end if
   493  
   494  
   495      call CloudSimpleCalcPRCPKeyLLTemp(     &
   496        & xyz_Temp, xy_PRCP,                 &  ! (in )
   497        & xy_SurfRainFlux, xy_SurfSnowFlux   &  ! (out)
   498        & )
   499  
   500  
   501    end subroutine CloudSimpleCalcPRCPKeyLLTemp3D
   502  
   503    !--------------------------------------------------------------------------------------
   504  
   505    subroutine CloudSimpleWithIce(                      &
   506      & xyr_Press, xyz_Press,                           & ! (in)
   507      & xyz_Temp,                                       & ! (inout)
   508  !!$    & xyz_DQH2OLiqDtCum, xyz_DQH2OLiqDtLSC,           & ! (in)
   509      & xyz_QH2OVap, xyz_QH2OLiq, xyz_QH2OSol,          & ! (inout)
   510      & xy_Rain, xy_Snow                                & ! (out)
   511      & )
   512  
   513      ! USE statements
   514      !
   515  
   516      ! 時刻管理
   517      ! Time control
   518      !
   519      use timeset, only: &
   520        & DelTime            ! $ \Delta t $ [s]
   521  
   522      ! 物理定数設定
   523      ! Physical constants settings
   524      !
   525      use constants, only:  &
   526        & Grav
   527                                ! $ g $ [m s-2].
   528                                ! 重力加速度.
   529                                ! Gravitational acceleration
   530  
   531      ! 雲関系ルーチン
   532      ! Cloud-related routines
   533      !
   534      use cloud_utils, only : &
   535        & CloudUtilsPRCPStepPC1Grid, &
   536        & CloudUtilsPRCPEvap1Grid, &
   537        & CloudUtilConsChk
   538  
   539  
   540      real(DP), intent(in   ) :: xyr_Press        ( 0:imax-1, 1:jmax, 0:kmax )
   541      real(DP), intent(in   ) :: xyz_Press        ( 0:imax-1, 1:jmax, 1:kmax )
   542      real(DP), intent(inout) :: xyz_Temp         ( 0:imax-1, 1:jmax, 1:kmax )
   543  !!$    real(DP), intent(in   ) :: xyz_DQH2OLiqDtCum( 0:imax-1, 1:jmax, 1:kmax )
   544  !!$    real(DP), intent(in   ) :: xyz_DQH2OLiqDtLSC( 0:imax-1, 1:jmax, 1:kmax )
   545      real(DP), intent(inout) :: xyz_QH2OVap     ( 0:imax-1, 1:jmax, 1:kmax )
   546      real(DP), intent(inout) :: xyz_QH2OLiq      ( 0:imax-1, 1:jmax, 1:kmax )
   547      real(DP), intent(inout) :: xyz_QH2OSol      ( 0:imax-1, 1:jmax, 1:kmax )
   548      real(DP), intent(out  ) :: xy_Rain          ( 0:imax-1, 1:jmax )
   549      real(DP), intent(out  ) :: xy_Snow          ( 0:imax-1, 1:jmax )
   550  
   551  
   552      real(DP) :: xyz_TempB   ( 0:imax-1, 1:jmax, 1:kmax )
   553      real(DP) :: xyz_QH2OVapB( 0:imax-1, 1:jmax, 1:kmax )
   554      real(DP) :: xyz_QH2OLiqB( 0:imax-1, 1:jmax, 1:kmax )
   555      real(DP) :: xyz_QH2OSolB( 0:imax-1, 1:jmax, 1:kmax )
   556      real(DP) :: xyz_DQH2OLiqDt( 0:imax-1, 1:jmax, 1:kmax )
   557      real(DP) :: xyz_DQH2OSolDt( 0:imax-1, 1:jmax, 1:kmax )
   558      real(DP) :: xy_DQRainDt( 0:imax-1, 1:jmax )
   559      real(DP) :: xy_DQSnowDt( 0:imax-1, 1:jmax )
   560  
   561      real(DP) :: xyz_DelMass( 0:imax-1, 1:jmax, 1:kmax )
   562  
   563      integer :: i
   564      integer :: j
   565      integer :: k
   566  
   567  
   568      ! 実行文 ; Executable statement
   569      !
   570  
   571      ! 初期化確認
   572      ! Initialization check
   573      !
   574      if ( .not. cloud_simple_inited ) then
   575        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   576      end if
   577  
   578      ! save values before adjustment
   579      xyz_TempB    = xyz_Temp
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t450 = 1, xyz_tempb.DSC.U3*(xyz_tempb.DSC.U2*xyz_tempb.DSC.U1  
     .       1    + xyz_tempb.DSC.U2)                                           
     .           xyz_tempb(t450-1,1,1) = xyz_temp(t450-1,1,1)                   
     .           xyz_qh2ovapb(t450-1,1,1) = xyz_qh2ovap(t450-1,1,1)             
     .           xyz_qh2oliqb(t450-1,1,1) = xyz_qh2oliq(t450-1,1,1)             
     .           xyz_qh2osolb(t450-1,1,1) = xyz_qh2osol(t450-1,1,1)             
     .           xyz_dqh2oliqdt(t450-1,1,1) = 0.0000000000000000e+000           
     .           xyz_dqh2osoldt(t450-1,1,1) = 0.0000000000000000e+000           
     .        enddo                                                             
   580      xyz_QH2OVapB = xyz_QH2OVap
   581      xyz_QH2OLiqB = xyz_QH2OLiq
   582      xyz_QH2OSolB = xyz_QH2OSol
   583  
   584  
   585      xyz_DQH2OLiqDt = 0.0_DP
   586      xyz_DQH2OSolDt = 0.0_DP
   587  
   588      do k = 1, kmax
   589        xyz_DelMass(:,:,k) = ( xyr_Press(:,:,k-1) - xyr_Press(:,:,k) ) / Grav
   590      end do
     .        d1 = 1.D0/grav                                                    
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do k = 1, kmax*jmax*imax                                          
     .           xyz_delmass(k-1,1,1) = (xyr_press(k-1,1,0)-xyr_press(k-1,1,1))*
     .       1      d1                                                          
     .        enddo                                                             
   591  
   592  
   593      ! Rain and snow at the surface
   594      xy_Rain = 0.0_DP
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t496 = 1, jmax*imax                                            
     .           xy_rain(t496-1,1) = 0.0000000000000000e+000                    
     .           xy_snow(t496-1,1) = 0.0000000000000000e+000                    
     .        enddo                                                             
   595      xy_Snow = 0.0_DP
   596  
   597      k_loop : do k = kmax, 1, -1
   598  
   599        ! Freezing/melting and evaporation of precipitation
   600        !
   601        if ( FlagPRCPPC ) then
   602          do j = 1, jmax
   603            do i = 0, imax-1
   604              call CloudUtilsPRCPStepPC1Grid(  &
   605                & xyr_Press(i,j,k-1), xyr_Press(i,j,k),       & ! (in   )
   606                & xyz_Temp(i,j,k),                            & ! (inout)
   607                & xy_Rain(i,j), xy_Snow(i,j)                  & ! (inout)
   608                & )
   609            end do
   610          end do
   611        end if
   612        if ( FlagPRCPEvap ) then
   613          do j = 1, jmax
   614            do i = 0, imax-1
   615              call CloudUtilsPRCPEvap1Grid(           &
   616                & xyz_Press(i,j,k), xyr_Press(i,j,k-1), xyr_Press(i,j,k), & ! (in)
   617                & PRCPArea, PRCPEvapArea,                                 & ! (in)
   618                & xyz_Temp(i,j,k), xyz_QH2OVap(i,j,k),                    & ! (inout)
   619                & xy_Rain(i,j), xy_Snow(i,j)                              & ! (inout)
   620                & )
   621            end do
   622          end do
   623        end if
   624  
   625  
   626        xyz_QH2OLiq(:,:,k) =                                                    &
     .        d4 = 1.D0/(2.00000000000000e+000*deltime)                         
     .        d5 = 1.D0/(2.00000000000000e+000*deltime)                         
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t504 = 1, jmax*imax                                            
     .           xyz_qh2oliq(t504-1,1,k) = xyz_qh2oliq(t504-1,1,k)*(dexp((-((   
     .       1      2.00000000000000e+000*deltime)/(cloudwatlifetime +          
     .       2      1.00000000000000e-100))))) + xyz_dqh2oliqdt(t504-1,1,k)*    
     .       3      cloudwatlifetime*(1.00000000000000e+000 - (dexp((-((        
     .       4      2.00000000000000e+000*deltime)/(cloudwatlifetime +          
     .       5      1.00000000000000e-100))))))                                 
     .           xy_dqraindt1 = xyz_qh2oliqb(t504-1,1,k) + (                    
     .       1      2.00000000000000e+000*deltime)*xyz_dqh2oliqdt(t504-1,1,k) - 
     .       2      xyz_qh2oliq(t504-1,1,k)                                     
     .           xy_dqraindt1 = xy_dqraindt1*d4                                 
     .           xyz_qh2osol(t504-1,1,k) = xyz_qh2osol(t504-1,1,k)*(dexp((-((   
     .       1      2.00000000000000e+000*deltime)/(cloudicelifetime +          
     .       2      1.00000000000000e-100))))) + xyz_dqh2osoldt(t504-1,1,k)*    
     .       3      cloudicelifetime*(1.00000000000000e+000 - (dexp((-((        
     .       4      2.00000000000000e+000*deltime)/(cloudicelifetime +          
     .       5      1.00000000000000e-100))))))                                 
     .           xy_dqsnowdt1 = xyz_qh2osolb(t504-1,1,k) + (                    
     .       1      2.00000000000000e+000*deltime)*xyz_dqh2osoldt(t504-1,1,k) - 
     .       2      xyz_qh2osol(t504-1,1,k)                                     
     .           xy_dqsnowdt1 = xy_dqsnowdt1*d5                                 
     .           xy_rain(t504-1,1) = xy_rain(t504-1,1) + xy_dqraindt1*          
     .       1      xyz_delmass(t504-1,1,k)                                     
     .           xy_snow(t504-1,1) = xy_snow(t504-1,1) + xy_dqsnowdt1*          
     .       1      xyz_delmass(t504-1,1,k)                                     
     .        enddo                                                             
   627          &   xyz_QH2OLiq(:,:,k)                                                &
   628          &     * exp( - 2.0_DP * DelTime / ( CloudWatLifeTime + 1.0e-100_DP ) )&
   629          & + xyz_DQH2OLiqDt(:,:,k) * CloudWatLifeTime                          &
   630          &   * ( 1.0_DP - exp( - 2.0_DP * DelTime / ( CloudWatLifeTime + 1.0e-100_DP ) ) )
   631  
   632        xy_DQRainDt =                          &
   633          &   xyz_QH2OLiqB(:,:,k)                      &
   634          & + xyz_DQH2OLiqDt(:,:,k) * 2.0_DP * DelTime &
   635          & - xyz_QH2OLiq(:,:,k)
   636        xy_DQRainDt = xy_DQRainDt / ( 2.0_DP * DelTime )
   637  
   638  
   639        xyz_QH2OSol(:,:,k) =                                                    &
   640          &   xyz_QH2OSol(:,:,k) &
   641          &     * exp( - 2.0_DP * DelTime / ( CloudIceLifeTime + 1.0e-100_DP ) )&
   642          & + xyz_DQH2OSolDt(:,:,k) * CloudIceLifeTime                          &
   643          &   * ( 1.0_DP - exp( - 2.0_DP * DelTime / ( CloudIceLifeTime + 1.0e-100_DP ) ) )
   644  
   645        xy_DQSnowDt =                          &
   646          &   xyz_QH2OSolB(:,:,k)                      &
   647          & + xyz_DQH2OSolDt(:,:,k) * 2.0_DP * DelTime &
   648          & - xyz_QH2OSol(:,:,k)
   649        xy_DQSnowDt = xy_DQSnowDt / ( 2.0_DP * DelTime )
   650  
   651        xy_Rain = xy_Rain + xy_DQRainDt * xyz_DelMass(:,:,k)
   652        xy_Snow = xy_Snow + xy_DQSnowDt * xyz_DelMass(:,:,k)
   653  
   654  
   655      end do k_loop
   656  
   657  
   658      call CloudUtilConsChk(                                   &
   659        & "CloudSimpleWithIce",                                &
   660        & xyr_Press,                                           &
   661        & xyz_TempB, xyz_QH2OVapB, xyz_QH2OLiqB, xyz_QH2OSolB, &
   662        & xyz_Temp , xyz_QH2OVap , xyz_QH2OLiq , xyz_QH2OSol , &
   663        & xy_Rain, xy_Snow                                     &
   664        & )
   665  
   666  
   667    end subroutine CloudSimpleWithIce
   668  
   669    !--------------------------------------------------------------------------------------
   670  
   671    subroutine CloudSimpleCalcPRCPStepPC(      &
   672      & xyr_Press, xyz_Press,                  & ! (in   )
   673      & xyz_DQRainDt, xyz_DQSnowDt,            & ! (in   )
   674      & xyz_Temp, xyz_QH2OVap,                 & ! (inout)
   675      & xy_SurfRainFlux, xy_SurfSnowFlux       & ! (out  )
   676      & )
   677  
   678      ! 時刻管理
   679      ! Time control
   680      !
   681      use timeset, only: &
   682        & DelTime            ! $ \Delta t $ [s]
   683  
   684      ! 物理定数設定
   685      ! Physical constants settings
   686      !
   687      use constants, only:  &
   688        & CpDry,            &
   689                                ! $ C_p $ [J kg-1 K-1].
   690                                ! 乾燥大気の定圧比熱.
   691                                ! Specific heat of air at constant pressure
   692        & Grav,             &
   693                                ! $ g $ [m s-2].
   694                                ! 重力加速度.
   695                                ! Gravitational acceleration
   696        & LatentHeat,       &
   697                                ! $ L $ [J kg-1] .
   698                                ! 蒸発の潜熱.
   699                                ! Latent heat
   700        & LatentHeatFusion, &
   701                                ! $ L $ [J kg-1] .
   702                                ! 融解の潜熱.
   703                                ! Latent heat of fusion
   704        & EpsV
   705                                ! $ \epsilon_v $ .
   706                                ! 水蒸気分子量比.
   707                                ! Molecular weight of water vapor
   708  
   709      ! 雪と海氷の定数の設定
   710      ! Setting constants of snow and sea ice
   711      !
   712      use constants_snowseaice, only: TempCondWater
   713  
   714      ! 飽和比湿の算出
   715      ! Evaluate saturation specific humidity
   716      !
   717      use saturate, only:       &
   718        & xyz_CalcQVapSat,      &
   719        & xyz_CalcQVapSatOnLiq, &
   720        & xyz_CalcQVapSatOnSol
   721  
   722  
   723      real(DP), intent(in   ) :: xyr_Press       ( 0:imax-1, 1:jmax, 0:kmax )
   724      real(DP), intent(in   ) :: xyz_Press       ( 0:imax-1, 1:jmax, 1:kmax )
   725      real(DP), intent(in   ) :: xyz_DQRainDt    ( 0:imax-1, 1:jmax, 1:kmax )
   726      real(DP), intent(in   ) :: xyz_DQSnowDt    ( 0:imax-1, 1:jmax, 1:kmax )
   727      real(DP), intent(inout) :: xyz_Temp        ( 0:imax-1, 1:jmax, 1:kmax )
   728      real(DP), intent(inout) :: xyz_QH2OVap     ( 0:imax-1, 1:jmax, 1:kmax )
   729      real(DP), intent(out  ) :: xy_SurfRainFlux ( 0:imax-1, 1:jmax )
   730      real(DP), intent(out  ) :: xy_SurfSnowFlux ( 0:imax-1, 1:jmax )
   731  
   732  
   733      ! 作業変数
   734      ! Work variables
   735      !
   736      real(DP) :: xyz_DelMass( 0:imax-1, 1:jmax, 1:kmax )
   737      real(DP) :: MassMaxFreezeRate
   738      real(DP) :: MassFreezeRate
   739      real(DP) :: MassMaxMeltRate
   740      real(DP) :: MassMeltRate
   741  
   742      real(DP) :: VirTemp
   743      real(DP) :: aaa_QH2OVapSat(1,1,1)
   744      real(DP) :: QH2OVapSat
   745      real(DP) :: PRCPFlux
   746      real(DP) :: DelPRCPFlux
   747      real(DP) :: DelQH2OVap
   748      real(DP) :: LatentHeatLocal
   749      character(STRING) :: CharPhase
   750  
   751      integer  :: i
   752      integer  :: j
   753      integer  :: k
   754      integer  :: l
   755  
   756  
   757      ! 初期化確認
   758      ! Initialization check
   759      !
   760      if ( .not. cloud_simple_inited ) then
   761        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   762      end if
   763  
   764  
   765      do k = 1, kmax
   766        xyz_DelMass(:,:,k) = ( xyr_Press(:,:,k-1) - xyr_Press(:,:,k) ) / Grav
   767      end do
     .        d1 = 1.D0/grav                                                    
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do k = 1, kmax*jmax*imax                                          
     .           xyz_delmass(k-1,1,1) = (xyr_press(k-1,1,0)-xyr_press(k-1,1,1))*
     .       1      d1                                                          
     .        enddo                                                             
   768  
   769      ! Freezing and melting switching at temperature of TempCondWater
   770      xy_SurfRainFlux = 0.0_DP
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t533 = 1, jmax*imax                                            
     .           xy_surfrainflux(t533-1,1) = 0.0000000000000000e+000            
     .           xy_surfsnowflux(t533-1,1) = 0.0000000000000000e+000            
     .        enddo                                                             
   771      xy_SurfSnowFlux = 0.0_DP
   772      do j = 1, jmax
   773        do i = 0, imax-1
   774          do k = kmax, 1, -1
   775  
   776            ! These are moved below.
   777  !!$          xy_SurfRainFlux(i,j) = xy_SurfRainFlux(i,j) &
   778  !!$            & + xyz_DQRainDt(i,j,k) * xyz_DelMass(i,j,k)
   779  !!$          xy_SurfSnowFlux(i,j) = xy_SurfSnowFlux(i,j) &
   780  !!$            & + xyz_DQSnowDt(i,j,k) * xyz_DelMass(i,j,k)
   781  
   782            if ( FlagPRCPPC ) then
   783  
   784              MassMaxFreezeRate =                               &
   785                &   CpDry * ( TempCondWater - xyz_Temp(i,j,k) ) &
   786                & * xyz_DelMass(i,j,k)                          &
   787                & / LatentHeatFusion                            &
   788                & / ( 2.0_DP * DelTime )
   789              if ( MassMaxFreezeRate >= 0.0_DP ) then
   790                ! freezing
   791                if ( xy_SurfRainFlux(i,j) >= MassMaxFreezeRate ) then
   792                  MassFreezeRate = MassMaxFreezeRate
   793                else
   794                  MassFreezeRate = xy_SurfRainFlux(i,j)
   795                end if
   796                xy_SurfRainFlux(i,j) = xy_SurfRainFlux(i,j) - MassFreezeRate
   797                xy_SurfSnowFlux(i,j) = xy_SurfSnowFlux(i,j) + MassFreezeRate
   798                xyz_Temp(i,j,k) = xyz_Temp(i,j,k)                          &
   799                  & + LatentHeatFusion * MassFreezeRate * 2.0_DP * DelTime &
   800                  &   / ( CpDry * xyz_DelMass(i,j,k) )
   801              else
   802                ! melting
   803                MassMaxMeltRate = - MassMaxFreezeRate
   804                if ( xy_SurfSnowFlux(i,j) >= MassMaxMeltRate ) then
   805                  MassMeltRate = MassMaxMeltRate
   806                else
   807                  MassMeltRate = xy_SurfSnowFlux(i,j)
   808                end if
   809                xy_SurfRainFlux(i,j) = xy_SurfRainFlux(i,j) + MassMeltRate
   810                xy_SurfSnowFlux(i,j) = xy_SurfSnowFlux(i,j) - MassMeltRate
   811                xyz_Temp(i,j,k) = xyz_Temp(i,j,k)                        &
   812                  & - LatentHeatFusion * MassMeltRate * 2.0_DP * DelTime &
   813                  &   / ( CpDry * xyz_DelMass(i,j,k) )
   814              end if
   815  
   816            end if
   817  
   818  
   819            if ( FlagPRCPEvap ) then
   820  !!$            do l = 0, 0   ! for test
   821              do l = 1, 2
   822                select case ( l )
   823                case ( 0 ) ! mixture
   824                  CharPhase = 'mixture'
   825                  aaa_QH2OVapSat(1:1,1:1,1:1) = &
   826                    & xyz_CalcQVapSat     ( xyz_Temp(i:i,j:j,k:k), xyz_Press(i:i,j:j,k:k) )
   827                  PRCPFlux = xy_SurfRainFlux(i,j)
   828                case ( 1 ) ! liquid
   829                  CharPhase = 'liquid'
   830                  aaa_QH2OVapSat(1:1,1:1,1:1) = &
   831                    & xyz_CalcQVapSatOnLiq( xyz_Temp(i:i,j:j,k:k), xyz_Press(i:i,j:j,k:k) )
   832                  PRCPFlux = xy_SurfRainFlux(i,j)
   833                case ( 2 ) ! solid
   834                  CharPhase = 'solid'
   835                  aaa_QH2OVapSat(1:1,1:1,1:1) = &
   836                    & xyz_CalcQVapSatOnSol( xyz_Temp(i:i,j:j,k:k), xyz_Press(i:i,j:j,k:k) )
   837                  PRCPFlux = xy_SurfSnowFlux(i,j)
   838                case default
   839                  call MessageNotify( 'E', module_name, 'Unexpected number for select case.' )
   840                end select
   841                QH2OVapSat = aaa_QH2OVapSat(1,1,1)
   842                VirTemp = xyz_Temp(i,j,k) * ( 1.0_DP + ((( 1.0_DP / EpsV ) - 1.0_DP ) * xyz_QH2OVap(i,j,k)) )
   843                call CloudSimpleEvap1Grid( &
   844                  & CharPhase,                                    &
   845                  & xyz_DelMass(i,j,k), xyz_Press(i,j,k), xyz_QH2OVap(i,j,k), QH2OVapSat, VirTemp, &
   846                  & PRCPFlux,                                                                      &
   847                  & DelPRCPFlux                                       &
   848                  & )
   849                select case ( l )
   850                case ( 0 ) ! mixture
   851                  xy_SurfRainFlux(i,j) = PRCPFlux - DelPRCPFlux
   852                  LatentHeatLocal      = LatentHeat
   853                case ( 1 ) ! liquid
   854                  xy_SurfRainFlux(i,j) = PRCPFlux - DelPRCPFlux
   855                  LatentHeatLocal      = LatentHeat
   856                case ( 2 ) ! solid
   857                  xy_SurfSnowFlux(i,j) = PRCPFlux - DelPRCPFlux
   858                  LatentHeatLocal      = LatentHeat + LatentHeatFusion
   859                end select
   860                DelQH2OVap = DelPRCPFlux * ( 2.0_DP * DelTime ) / xyz_DelMass(i,j,k)
   861                xyz_QH2OVap(i,j,k) = xyz_QH2OVap(i,j,k) + DelQH2OVap
   862                xyz_Temp(i,j,k) = xyz_Temp(i,j,k) - LatentHeatLocal * DelQH2OVap / CpDry
   863              end do
   864            end if
   865  
   866            xy_SurfRainFlux(i,j) = xy_SurfRainFlux(i,j) &
   867              & + xyz_DQRainDt(i,j,k) * xyz_DelMass(i,j,k)
   868            xy_SurfSnowFlux(i,j) = xy_SurfSnowFlux(i,j) &
   869              & + xyz_DQSnowDt(i,j,k) * xyz_DelMass(i,j,k)
   870  
   871          end do
   872        end do
   873      end do
   874  
   875  
   876    end subroutine CloudSimpleCalcPRCPStepPC
   877  
   878    !--------------------------------------------------------------------------------------
   879  
   880    subroutine CloudSimpleEvap1Grid( &
   881      & CharPhase,                                    &
   882      & DelMass, Press, QH2OVap, QH2OVapSat, VirTemp, &
   883      & PRCP,                                         &
   884      & DelPRCPFlux                                   &
   885      & )
   886  
   887      ! 物理・数学定数設定
   888      ! Physical and mathematical constants settings
   889      !
   890      use constants0, only: &
   891        & PI                    ! $ \pi $ .
   892                                ! 円周率.  Circular constant
   893  
   894      ! 物理定数設定
   895      ! Physical constants settings
   896      !
   897      use constants, only: &
   898        & Grav, &
   899                                ! $ g $ [m s-2].
   900                                ! 重力加速度.
   901                                ! Gravitational acceleration
   902        & GasRDry
   903                                ! $ R $ [J kg-1 K-1].
   904                                ! 乾燥大気の気体定数.
   905                                ! Gas constant of air
   906  
   907  
   908      character(*), intent(in ) :: CharPhase
   909      real(DP)    , intent(in ) :: DelMass
   910      real(DP)    , intent(in ) :: Press
   911      real(DP)    , intent(in ) :: QH2OVap
   912      real(DP)    , intent(in ) :: QH2OVapSat
   913      real(DP)    , intent(in ) :: VirTemp
   914      real(DP)    , intent(in ) :: PRCP
   915      real(DP)    , intent(out) :: DelPRCPFlux
   916  
   917  
   918      ! Parameters for evaporation of rain
   919      real(DP), parameter :: DensWater            = 1.0d3
   920      !                            rho_w
   921      !   Values below are from Kessler (1969)
   922      real(DP), parameter :: PRCPFallVelFactor0        = 130.0d0
   923      !                            K
   924      real(DP), parameter :: MedianDiameterFactor      = 3.67d0
   925      !                            C'
   926      real(DP), parameter :: PRCPDistFactor            = 1.0d7
   927      !                            N0
   928      real(DP), parameter :: PRCPEvapRatUnitDiamFactor = 2.24d3
   929      !                            C
   930      real(DP), parameter :: H2OVapDiffCoef            = 1.0d-5
   931      !                            Kd
   932  
   933      real(DP) :: PRCPFallVelRatio
   934      real(DP) :: PRCPFallVelFactor
   935  
   936      real(DP) :: Dens0
   937      !                            rho_0
   938      real(DP) :: V00
   939      !                            V_{00}
   940      real(DP) :: PRCPEvapFactor
   941  
   942      real(DP) :: Dens
   943      !                           rho
   944      real(DP) :: DensPRCP
   945      !                           (rho q_r)
   946  !!$    real(DP) :: RainArea
   947  !!$    !                           a_p
   948  !!$    real(DP) :: RainEvapArea
   949  !!$    !                           A = max( a_p - a, 0 )
   950  !!$    real(DP) :: xy_CloudCover   (0:imax-1, 1:jmax)
   951  !!$    !                           a
   952      real(DP) :: PRCPEvapRate
   953  
   954      real(DP) :: DelZ
   955  
   956  
   957      select case ( CharPhase )
   958      case ( 'liquid' )
   959        ! for liquid water
   960        PRCPFallVelRatio = 1.0_DP
   961      case ( 'solid' )
   962        ! for solid water (ice)
   963        PRCPFallVelRatio = 0.5_DP
   964      case ( 'mixture' )
   965        ! for mixture, this is only for test
   966        PRCPFallVelRatio = 1.0_DP
   967      case default
   968        call MessageNotify( 'E', module_name, 'Unexpected character for select case.' )
   969      end select
   970      !
   971      PRCPFallVelFactor = PRCPFallVelFactor0 * PRCPFallVelRatio
   972  
   973      ! Parameters for evaporation of rain
   974      Dens0 = 1013.0d2 / ( GasRDry * 300.0_DP )
   975      V00 = PRCPFallVelFactor * sqrt( MedianDiameterFactor ) &
   976        & / ( PI * DensWater * PRCPDistFactor )**(1.0d0/8.0d0)
   977      PRCPEvapFactor =                                      &
   978  !      & RainEvapRatUnitDiamFactor * gamma( 13.0d0/5.0d0 ) &
   979        & PRCPEvapRatUnitDiamFactor * 1.429624558860304d0   &
   980        & * H2OVapDiffCoef * PRCPDistFactor**(7.0d0/20.0d0) &
   981        & / ( PI * DensWater )**(13.0d0/20.0d0)
   982      ! Values for evaporation of rain
   983      Dens = Press / ( GasRDry * VirTemp )
   984  
   985      DelZ = DelMass / Dens
   986  
   987  
   988  !!$    RainArea   = RainArea
   989  !!$    xy_CloudCover = CloudCover
   990  !!$    xy_RainEvapArea = max( xy_RainArea - xy_CloudCover, 0.0_DP )
   991  !!$    RainEvapArea = RainEvapArea
   992  
   993      DensPRCP =                                                   &
   994        & ( PRCP / ( PRCPArea + 1.0d-10 )                          &
   995        &   / ( V00 * sqrt( Dens0 / Dens ) ) )**(8.0d0/9.0d0)
   996      PRCPEvapRate =                                      &
   997        & Dens * PRCPEvapArea * PRCPEvapFactor            &
   998        &   * max( QH2OVapSat - QH2OVap, 0.0_DP )         &
   999        &   * DensPRCP**(13.0d0/20.0d0)
  1000  
  1001      ! PRCPEvapRate (kg m-3 s-1)
  1002      ! DelZ         (m)
  1003      ! DelPRCPFlux  (kg m-2 s-1)
  1004      DelPRCPFlux = PRCPEvapRate * DelZ
  1005  
  1006      DelPRCPFlux = min( DelPRCPFlux, PRCP )
  1007  
  1008  
  1009    end subroutine CloudSimpleEvap1Grid
  1010  
  1011    !--------------------------------------------------------------------------------------
  1012  
  1013    subroutine CloudSimpleConsChk(                           &
  1014      & FlagIncludeIcePhaseChange,                           &
  1015      & xyr_Press,                                           &
  1016      & xyz_TempB, xyz_QH2OVapB, xyz_QH2OLiqB, xyz_QH2OSolB, &
  1017      & xyz_Temp , xyz_QH2OVap , xyz_QH2OLiq , xyz_QH2OSol , &
  1018      & xy_Rain, xy_Snow                                     &
  1019      & )
  1020  
  1021  
  1022      ! 時刻管理
  1023      ! Time control
  1024      !
  1025      use timeset, only: &
  1026        & DelTime            ! $ \Delta t $ [s]
  1027  
  1028      ! 物理定数設定
  1029      ! Physical constants settings
  1030      !
  1031      use constants, only: &
  1032        & Grav, &
  1033                                ! $ g $ [m s-2].
  1034                                ! 重力加速度.
  1035                                ! Gravitational acceleration
  1036        & CpDry, &
  1037                                ! $ C_p $ [J kg-1 K-1].
  1038                                ! 乾燥大気の定圧比熱.
  1039                                ! Specific heat of air at constant pressure
  1040        & LatentHeat, &
  1041                                ! $ L $ [J kg-1] .
  1042                                ! 凝結の潜熱.
  1043                                ! Latent heat of condensation
  1044        & LatentHeatFusion
  1045                                ! $ L $ [J kg-1] .
  1046                                ! 融解の潜熱.
  1047                                ! Latent heat of fusion
  1048  
  1049      logical , intent(in) :: FlagIncludeIcePhaseChange
  1050      real(DP), intent(in) :: xyr_Press   (0:imax-1, 1:jmax, 0:kmax)
  1051      real(DP), intent(in) :: xyz_TempB   (0:imax-1, 1:jmax, 1:kmax)
  1052      real(DP), intent(in) :: xyz_QH2OVapB(0:imax-1, 1:jmax, 1:kmax)
  1053      real(DP), intent(in) :: xyz_QH2OLiqB(0:imax-1, 1:jmax, 1:kmax)
  1054      real(DP), intent(in) :: xyz_QH2OSolB(0:imax-1, 1:jmax, 1:kmax)
  1055      real(DP), intent(in) :: xyz_Temp    (0:imax-1, 1:jmax, 1:kmax)
  1056      real(DP), intent(in) :: xyz_QH2OVap (0:imax-1, 1:jmax, 1:kmax)
  1057      real(DP), intent(in) :: xyz_QH2OLiq (0:imax-1, 1:jmax, 1:kmax)
  1058      real(DP), intent(in) :: xyz_QH2OSol (0:imax-1, 1:jmax, 1:kmax)
  1059      real(DP), intent(in) :: xy_Rain     (0:imax-1, 1:jmax)
  1060      real(DP), intent(in) :: xy_Snow     (0:imax-1, 1:jmax)
  1061  
  1062      ! Local variables
  1063      !
  1064      real(DP) :: xyz_DelMass(0:imax-1, 1:jmax, 1:kmax)
  1065      real(DP) :: xy_Val(0:imax-1, 1:jmax)
  1066      real(DP) :: xy_SumB(0:imax-1, 1:jmax)
  1067      real(DP) :: xy_Sum(0:imax-1, 1:jmax)
  1068      real(DP) :: xy_Ratio(0:imax-1, 1:jmax)
  1069      integer  :: i
  1070      integer  :: j
  1071      integer  :: k
  1072  
  1073  
  1074      do k = 1, kmax
  1075        xyz_DelMass(:,:,k) = ( xyr_Press(:,:,k-1) - xyr_Press(:,:,k) ) / Grav
  1076      end do
     .        d1 = 1.D0/grav                                                    
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do k = 1, kmax*jmax*imax                                          
     .           xyz_delmass(k-1,1,1) = (xyr_press(k-1,1,0)-xyr_press(k-1,1,1))*
     .       1      d1                                                          
     .        enddo                                                             
  1077  
  1078      xy_Sum = 0.0_DP
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t466 = 1, xy_sum.DSC.U2*xy_sum.DSC.U1 + xy_sum.DSC.U2          
     .           xy_sum(t466-1,1) = 0.0000000000000000e+000                     
     .        enddo                                                             
  1079      do k = kmax, 1, -1
  1080        xy_Val =   CpDry * xyz_TempB(:,:,k)               &
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xy_val,xy_sum)                                             
     .        do t472 = 1, jmax*imax                                            
     .           xy_val(t472-1,1) = cpdry*xyz_tempb(t472-1,1,k) + latentheat*   
     .       1      xyz_qh2ovapb(t472-1,1,k) - latentheatfusion*xyz_qh2osolb(   
     .       2      t472-1,1,k)                                                 
     .           xy_sum(t472-1,1) = xy_sum(t472-1,1) + xy_val(t472-1,1)*        
     .       1      xyz_delmass(t472-1,1,k)                                     
     .        enddo                                                             
  1081          &      + LatentHeat * xyz_QH2OVapB(:,:,k)       &
  1082          &      - LatentHeatFusion * xyz_QH2OSolB(:,:,k)
  1083        xy_Sum = xy_Sum + xy_Val * xyz_DelMass(:,:,k)
  1084      end do
  1085  
  1086      xy_SumB = xy_Sum
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xy_sum)                                                    
     .        do t492 = 1, xy_sumb.DSC.U2*xy_sumb.DSC.U1 + xy_sumb.DSC.U2       
     .           xy_sumb(t492-1,1) = xy_sum(t492-1,1)                           
     .           xy_sum(t492-1,1) = 0.0000000000000000e+000                     
     .        enddo                                                             
  1087  
  1088      xy_Sum = 0.0_DP
  1089      do k = kmax, 1, -1
  1090        xy_Val =   CpDry * xyz_Temp (:,:,k)               &
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xy_val,xy_sum)                                             
     .        do t502 = 1, jmax*imax                                            
     .           xy_val(t502-1,1) = cpdry*xyz_temp(t502-1,1,k) + latentheat*    
     .       1      xyz_qh2ovap(t502-1,1,k) - latentheatfusion*xyz_qh2osol(t502-
     .       2      1,1,k)                                                      
     .           xy_sum(t502-1,1) = xy_sum(t502-1,1) + xy_val(t502-1,1)*        
     .       1      xyz_delmass(t502-1,1,k)                                     
     .        enddo                                                             
  1091          &      + LatentHeat * xyz_QH2OVap (:,:,k)       &
  1092          &      - LatentHeatFusion * xyz_QH2OSol (:,:,k)
  1093        xy_Sum = xy_Sum + xy_Val * xyz_DelMass(:,:,k)
  1094      end do
  1095      if ( FlagIncludeIcePhaseChange ) then
  1096        xy_Sum = xy_Sum - LatentHeatFusion * xy_Snow * 2.0_DP * DelTime
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xy_sum)                                                    
     .        do t610 = 1, xy_sum.DSC.U2*xy_sum.DSC.U1 + xy_sum.DSC.U2          
     .           xy_sum(t610-1,1) = xy_sum(t610-1,1) - latentheatfusion*xy_snow(
     .       1      t610-1,1)*2.00000000000000e+000*deltime                     
     .        enddo                                                             
  1097      end if
  1098  
  1099      xy_Ratio = ( xy_Sum - xy_SumB ) / ( xy_Sum + 1.0d-100 )
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xy_sum)                                                    
     .        do t522 = 1, xy_sum.DSC.U2*xy_sum.DSC.U1 + xy_sum.DSC.U2          
     .           xy_ratio(t522-1,1) = (xy_sum(t522-1,1)-xy_sumb(t522-1,1))/(    
     .       1      xy_sum(t522-1,1)+1.00000000000000e-100)                     
     .        enddo                                                             
  1100      do j = 1, jmax
  1101        do i = 0, imax-1
  1102          if ( abs( xy_Ratio(i,j) ) > 1.0d-10 ) then
  1103            call MessageNotify( 'M', module_name, 'Modified condensate static energy is not conserved, %f.', d = (/ xy_Ratio(i,j) /) )
  1104          end if
  1105        end do
  1106      end do
  1107  
  1108  
  1109  
  1110      xy_Sum = 0.0_DP
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t534 = 1, xy_sum.DSC.U2*xy_sum.DSC.U1 + xy_sum.DSC.U2          
     .           xy_sum(t534-1,1) = 0.0000000000000000e+000                     
     .        enddo                                                             
  1111      do k = kmax, 1, -1
  1112        xy_Val = xyz_QH2OVapB(:,:,k) + xyz_QH2OLiqB(:,:,k) + xyz_QH2OSolB(:,:,k)
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xy_val,xy_sum)                                             
     .        do t540 = 1, jmax*imax                                            
     .           xy_val(t540-1,1) = xyz_qh2ovapb(t540-1,1,k) + xyz_qh2oliqb(t540
     .       1      -1,1,k) + xyz_qh2osolb(t540-1,1,k)                          
     .           xy_sum(t540-1,1) = xy_sum(t540-1,1) + xy_val(t540-1,1)*        
     .       1      xyz_delmass(t540-1,1,k)                                     
     .        enddo                                                             
  1113        xy_Sum = xy_Sum + xy_Val * xyz_DelMass(:,:,k)
  1114      end do
  1115  
  1116      xy_SumB = xy_Sum
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xy_sum)                                                    
     .        do t560 = 1, xy_sumb.DSC.U2*xy_sumb.DSC.U1 + xy_sumb.DSC.U2       
     .           xy_sumb(t560-1,1) = xy_sum(t560-1,1)                           
     .           xy_sum(t560-1,1) = 0.0000000000000000e+000                     
     .        enddo                                                             
  1117  
  1118      xy_Sum = 0.0_DP
  1119      do k = kmax, 1, -1
  1120        xy_Val = xyz_QH2OVap (:,:,k) + xyz_QH2OLiq (:,:,k) + xyz_QH2OSol (:,:,k)
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xy_val,xy_sum)                                             
     .        do t570 = 1, jmax*imax                                            
     .           xy_val1 = xyz_qh2ovap(t570-1,1,k) + xyz_qh2oliq(t570-1,1,k) +  
     .       1      xyz_qh2osol(t570-1,1,k)                                     
     .           xy_sum(t570-1,1) = xy_sum(t570-1,1) + xy_val1*xyz_delmass(t570-
     .       1      1,1,k)                                                      
     .        enddo                                                             
  1121        xy_Sum = xy_Sum + xy_Val * xyz_DelMass(:,:,k)
  1122      end do
  1123      xy_Sum = xy_Sum + ( xy_Rain + xy_Snow ) * 2.0_DP * DelTime
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xy_sum)                                                    
     .        do t590 = 1, xy_sum.DSC.U2*xy_sum.DSC.U1 + xy_sum.DSC.U2          
     .           xy_sum(t590-1,1) = xy_sum(t590-1,1) + (xy_rain(t590-1,1)+      
     .       1      xy_snow(t590-1,1))*2.00000000000000e+000*deltime            
     .           xy_ratio(t590-1,1) = (xy_sum(t590-1,1)-xy_sumb(t590-1,1))/(    
     .       1      xy_sum(t590-1,1)+1.00000000000000e-100)                     
     .        enddo                                                             
  1124  
  1125      xy_Ratio = ( xy_Sum - xy_SumB ) / ( xy_Sum + 1.0d-100 )
  1126      do j = 1, jmax
  1127        do i = 0, imax-1
  1128          if ( abs( xy_Ratio(i,j) ) > 1.0d-10 ) then
  1129            call MessageNotify( 'M', module_name, 'H2O mass is not conserved, %f.', d = (/ xy_Ratio(i,j) /) )
  1130          end if
  1131        end do
  1132      end do
  1133  
  1134  
  1135    end subroutine CloudSimpleConsChk
  1136  
  1137    !--------------------------------------------------------------------------------------
  1138  
  1139    subroutine CloudSimpleCalcCloudCover(  &
  1140      & xyz_Press, xyz_Temp, xyz_QH2OTot,  & ! (in )
  1141      & xyz_CloudCover                     & ! (out)
  1142      & )
  1143  
  1144      ! USE statements
  1145      !
  1146  
  1147      ! 飽和比湿の算出
  1148      ! Evaluate saturation specific humidity
  1149      !
  1150      use saturate, only: xyz_CalcQVapSat
  1151  
  1152      real(DP), intent(in ) :: xyz_Press     ( 0:imax-1, 1:jmax, 1:kmax )
  1153      real(DP), intent(in ) :: xyz_Temp      ( 0:imax-1, 1:jmax, 1:kmax )
  1154      real(DP), intent(in ) :: xyz_QH2OTot   ( 0:imax-1, 1:jmax, 1:kmax )
  1155      real(DP), intent(out) :: xyz_CloudCover( 0:imax-1, 1:jmax, 1:kmax )
  1156  
  1157  
  1158      real(DP) :: xyz_RH(0:imax-1, 1:jmax, 1:kmax)
  1159  
  1160      integer :: i
  1161      integer :: j
  1162      integer :: k
  1163  
  1164  
  1165      ! 実行文 ; Executable statement
  1166      !
  1167  
  1168      ! 初期化確認
  1169      ! Initialization check
  1170      !
  1171      if ( .not. cloud_simple_inited ) then
  1172        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
  1173      end if
  1174  
  1175  
  1176      select case ( IDCloudCoverMethod )
  1177      case ( IDCloudCoverMethodConst )
  1178  
  1179        xyz_CloudCover = CloudCover
     .        if (1 + jmax - min0(1,jmax) .gt. 0) then                          
     .           j1 = and(1 + jmax - min0(1,jmax),3)                            
     .  !cdir    nodep                                                          
     .           do t306 = 1, j1                                                
     .  !cdir       nodep                                                       
     .              do t308 = 1, 1 + imax - min0(1,imax)                        
     .                 xyz_cloudcover(t308-1,t306,t304+1) = cloudcover          
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t306 = j1 + 1, 1 + jmax - min0(1,jmax), 4                   
     .  !cdir       nodep                                                       
     .              do t308 = 1, 1 + imax - min0(1,imax)                        
     .                 xyz_cloudcover(t308-1,t306,t304+1) = cloudcover          
     .                 xyz_cloudcover(t308-1,t306+1,t304+1) = cloudcover        
     .                 xyz_cloudcover(t308-1,t306+2,t304+1) = cloudcover        
     .                 xyz_cloudcover(t308-1,t306+3,t304+1) = cloudcover        
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
  1180  
  1181      case ( IDCloudCoverMethodRH )
  1182  
  1183        ! see Sundqvist et al. (1989), Del Genio et al. (1996)
  1184        xyz_RH = xyz_QH2OTot / xyz_CalcQVapSat( xyz_Temp, xyz_Press )
     .        d3 = 1.D0/(1.00000000000000e+000 - cloudcoverrhcrtl)              
     .  !cdir nodep                                                             
     .        do t269 = 1, imax                                                 
     .           xyz_rh1 = xyz_qh2otot(t269-1,t267+1,t265+1)/%000421(t269,t267+1
     .       1      ,t265+1)                                                    
     .           xyz_rh1 = min(xyz_rh1,1.00000000000000e+000)                   
     .           xyz_cloudcover1 = 1.00000000000000e+000 - dsqrt((              
     .       1      1.00000000000000e+000 - xyz_rh1)*d3)                        
     .           xyz_cloudcover1 = max(xyz_cloudcover1,cloudcovermin)           
     .           xyz_cloudcover(t269-1,t267+1,t265+1) = min(xyz_cloudcover1,    
     .       1      1.00000000000000e+000)                                      
     .        enddo                                                             
  1185        xyz_RH = min( xyz_RH, 1.0_DP )
  1186  
  1187        xyz_CloudCover = &
  1188          & 1.0_DP - sqrt( ( 1.0_DP - xyz_RH ) / ( 1.0_DP - CloudCoverRHCrtl ) )
  1189  
  1190        xyz_CloudCover = max( xyz_CloudCover, CloudCoverMin )
  1191        xyz_CloudCover = min( xyz_CloudCover, 1.0_DP )
  1192  
  1193      case ( IDCloudCoverMethodRHLin )
  1194  
  1195        xyz_RH = xyz_QH2OTot / xyz_CalcQVapSat( xyz_Temp, xyz_Press )
     .        if (jmax .gt. 0) then                                             
     .           j2 = and(jmax,3)                                               
     .  !cdir    nodep                                                          
     .           do t216 = 1, j2                                                
     .  !cdir       nodep                                                       
     .              do t218 = 1, imax                                           
     .                 xyz_rh2 = xyz_qh2otot(t218-1,t216,t214+1)/%000452(t218,  
     .       1            t216,t214+1)                                          
     .                 xyz_rh(t218-1,t216,t214+1) = min(xyz_rh2,                
     .       1            1.00000000000000e+000)                                
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t216 = j2 + 1, jmax, 4                                      
     .  !cdir       nodep                                                       
     .              do t218 = 1, imax                                           
     .                 xyz_rh(t218-1,t216,t214+1) = xyz_qh2otot(t218-1,t216,t214
     .       1            +1)/%000452(t218,t216,t214+1)                         
     .                 xyz_rh(t218-1,t216+1,t214+1) = xyz_qh2otot(t218-1,t216+1,
     .       1            t214+1)/%000452(t218,t216+1,t214+1)                   
     .                 xyz_rh(t218-1,t216+2,t214+1) = xyz_qh2otot(t218-1,t216+2,
     .       1            t214+1)/%000452(t218,t216+2,t214+1)                   
     .                 xyz_rh(t218-1,t216+3,t214+1) = xyz_qh2otot(t218-1,t216+3,
     .       1            t214+1)/%000452(t218,t216+3,t214+1)                   
     .                 xyz_rh(t218-1,t216,t214+1) = min(xyz_rh(t218-1,t216,t214+
     .       1            1),1.00000000000000e+000)                             
     .                 xyz_rh(t218-1,t216+1,t214+1) = min(xyz_rh(t218-1,t216+1, 
     .       1            t214+1),1.00000000000000e+000)                        
     .                 xyz_rh(t218-1,t216+2,t214+1) = min(xyz_rh(t218-1,t216+2, 
     .       1            t214+1),1.00000000000000e+000)                        
     .                 xyz_rh(t218-1,t216+3,t214+1) = min(xyz_rh(t218-1,t216+3, 
     .       1            t214+1),1.00000000000000e+000)                        
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
  1196        xyz_RH = min( xyz_RH, 1.0_DP )
  1197  
  1198        if ( CloudCoverRHCrtl < 1.0_DP ) then
  1199  !!$      xyz_CloudCover = 2.0_DP * xyz_RH - 1.0_DP
  1200          xyz_CloudCover = &
     .        if (1 + xyz_rh.DSC.U2 - min0(1,xyz_rh.DSC.U2) .gt. 0) then        
     .           j3 = and(1 + xyz_rh.DSC.U2 - min0(1,xyz_rh.DSC.U2),3)          
     .  !cdir    nodep                                                          
     .           do t255 = 1, j3                                                
     .              d5 = 1.D0/(1.00000000000000e+000 - cloudcoverrhcrtl)        
     .  !cdir       nodep                                                       
     .              do t257 = 1, xyz_rh.DSC.U1 + 2 - min0(1,xyz_rh.DSC.U1 + 1)  
     .                 xyz_cloudcover(t257-1,t255,t253+1) = xyz_rh(t257-1,t255, 
     .       1            t253+1)*d5 - cloudcoverrhcrtl/(1.00000000000000e+000  
     .       2             - cloudcoverrhcrtl)                                  
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t255 = j3 + 1, 1 + xyz_rh.DSC.U2 - min0(1,xyz_rh.DSC.U2), 4 
     .              d6 = 1.D0/(1.00000000000000e+000 - cloudcoverrhcrtl)        
     .              d7 = 1.D0/(1.00000000000000e+000 - cloudcoverrhcrtl)        
     .              d8 = 1.D0/(1.00000000000000e+000 - cloudcoverrhcrtl)        
     .              d9 = 1.D0/(1.00000000000000e+000 - cloudcoverrhcrtl)        
     .  !cdir       nodep                                                       
     .              do t257 = 1, xyz_rh.DSC.U1 + 2 - min0(1,xyz_rh.DSC.U1 + 1)  
     .                 xyz_cloudcover(t257-1,t255,t253+1) = xyz_rh(t257-1,t255, 
     .       1            t253+1)*d6 - (cloudcoverrhcrtl/(1.00000000000000e+000 
     .       2             - cloudcoverrhcrtl))                                 
     .                 xyz_cloudcover(t257-1,t255+1,t253+1) = xyz_rh(t257-1,t255
     .       1            +1,t253+1)*d7 - (cloudcoverrhcrtl/(                   
     .       2            1.00000000000000e+000 - cloudcoverrhcrtl))            
     .                 xyz_cloudcover(t257-1,t255+2,t253+1) = xyz_rh(t257-1,t255
     .       1            +2,t253+1)*d8 - (cloudcoverrhcrtl/(                   
     .       2            1.00000000000000e+000 - cloudcoverrhcrtl))            
     .                 xyz_cloudcover(t257-1,t255+3,t253+1) = xyz_rh(t257-1,t255
     .       1            +3,t253+1)*d9 - (cloudcoverrhcrtl/(                   
     .       2            1.00000000000000e+000 - cloudcoverrhcrtl))            
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
  1201            &   xyz_RH           / ( 1.0_DP - CloudCoverRHCrtl ) &
  1202            & - CloudCoverRHCrtl / ( 1.0_DP - CloudCoverRHCrtl )
  1203        else
  1204          do k = 1, kmax
  1205            do j = 1, jmax
  1206              do i = 0, imax-1
  1207                if ( xyz_RH(i,j,k) >= 1.0_DP ) then
  1208                  xyz_CloudCover(i,j,k) = 1.0_DP
  1209                else
  1210                  xyz_CloudCover(i,j,k) = 0.0_DP
  1211                end if
  1212              end do
  1213            end do
  1214          end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do k = 1, kmax*jmax*imax                                          
     .           if (xyz_rh(k-1,1,1) .ge. 1.00000000000000e+000) then           
     .              xyz_cloudcover10 = 1.00000000000000e+000                    
     .           else                                                           
     .              xyz_cloudcover10 = 0.0000000000000000e+000                  
     .           endif                                                          
     .           xyz_cloudcover(k-1,1,1) = xyz_cloudcover10                     
     .        enddo                                                             
  1215        end if
  1216  
  1217        xyz_CloudCover = max( xyz_CloudCover, CloudCoverMin )
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t235 = 1, kmax*jmax*imax                                       
     .           xyz_cloudcover(t235-1,1,1) = max(xyz_cloudcover(t235-1,1,1),   
     .       1      cloudcovermin)                                              
     .           xyz_cloudcover(t235-1,1,1) = min(xyz_cloudcover(t235-1,1,1),   
     .       1      1.00000000000000e+000)                                      
     .        enddo                                                             
  1218        xyz_CloudCover = min( xyz_CloudCover, 1.0_DP )
  1219  
  1220      end select
  1221  
  1222  
  1223    end subroutine CloudSimpleCalcCloudCover
  1224  
  1225    !--------------------------------------------------------------------------------------
  1226  
  1227    subroutine CloudSimpleDivideWatAndIce(  &
  1228      & xyz_Temp,                           & ! (in )
  1229      & xyz_QH2OWatAndIce,                  & ! (in )
  1230      & xyz_QH2OWat, xyz_QH2OIce            & ! (out)
  1231      & )
  1232  
  1233      ! USE statements
  1234      !
  1235  
  1236      ! 飽和比湿の算出
  1237      ! Evaluate saturation specific humidity
  1238      !
  1239      use saturate, only : SaturateWatFraction
  1240  
  1241      real(DP), intent(in ) :: xyz_Temp         (0:imax-1, 1:jmax, 1:kmax)
  1242      real(DP), intent(in ) :: xyz_QH2OWatAndIce(0:imax-1, 1:jmax, 1:kmax)
  1243      real(DP), intent(out) :: xyz_QH2OWat      (0:imax-1, 1:jmax, 1:kmax)
  1244      real(DP), intent(out) :: xyz_QH2OIce      (0:imax-1, 1:jmax, 1:kmax)
  1245  
  1246  
  1247      real(DP) :: xyz_WatFrac(0:imax-1, 1:jmax, 1:kmax)
  1248  
  1249      ! 実行文 ; Executable statement
  1250      !
  1251  
  1252      ! 初期化確認
  1253      ! Initialization check
  1254      !
  1255      if ( .not. cloud_simple_inited ) then
  1256        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
  1257      end if
  1258  
  1259  
  1260      call SaturateWatFraction(      &
  1261        & xyz_Temp,                  & ! (in )
  1262        & xyz_WatFrac                & ! (out)
  1263        & )
  1264  
  1265      xyz_QH2OWat = xyz_QH2OWatAndIce * xyz_WatFrac
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t87 = 1, kmax*jmax*imax                                        
     .           xyz_qh2owat(t87-1,1,1) = xyz_qh2owatandice(t87-1,1,1)*         
     .       1      xyz_watfrac(t87-1,1,1)                                      
     .           xyz_qh2oice(t87-1,1,1) = xyz_qh2owatandice(t87-1,1,1)*(        
     .       1      1.00000000000000e+000 - xyz_watfrac(t87-1,1,1))             
     .        enddo                                                             
  1266      xyz_QH2OIce = xyz_QH2OWatAndIce * ( 1.0_DP - xyz_WatFrac )
  1267  
  1268  
  1269    end subroutine CloudSimpleDivideWatAndIce
  1270  
  1271    !--------------------------------------------------------------------------------------
  1272  
  1273    subroutine CloudSimpleInit( &
  1274      & ArgFlagSnow             &
  1275      & )
  1276  
  1277      ! ファイル入出力補助
  1278      ! File I/O support
  1279      !
  1280      use dc_iounit, only: FileOpen
  1281  
  1282      ! NAMELIST ファイル入力に関するユーティリティ
  1283      ! Utilities for NAMELIST file input
  1284      !
  1285      use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid
  1286  
  1287      ! ヒストリデータ出力
  1288      ! History data output
  1289      !
  1290      use gtool_historyauto, only: HistoryAutoAddVariable
  1291  
  1292      ! 飽和比湿の算出
  1293      ! Evaluate saturation specific humidity
  1294      !
  1295      use saturate, only: SaturateInit
  1296  
  1297      ! 大規模凝結 (非対流性凝結)
  1298      ! Large scale condensation (non-convective condensation)
  1299      !
  1300      use lscond, only : LScaleCondInit
  1301  
  1302      ! 宣言文 ; Declaration statements
  1303      !
  1304  
  1305      logical, intent(in) :: ArgFlagSnow
  1306  
  1307  
  1308      character(STRING) :: CloudCoverMethod
  1309      character(STRING) :: SnowMethod
  1310  
  1311      integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号.
  1312                                ! Unit number for NAMELIST file open
  1313      integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT.
  1314                                ! IOSTAT of NAMELIST read
  1315  
  1316      ! NAMELIST 変数群
  1317      ! NAMELIST group name
  1318      !
  1319      namelist /cloud_simple_nml/ &
  1320        & CloudLifeTime,       &
  1321        & CloudWatLifeTime,    &
  1322        & CloudIceLifeTime,    &
  1323        & CloudCoverMethod,    &
  1324        & SnowMethod,          &
  1325        & CloudCover,          &
  1326        & CloudCoverRHCrtl,    &
  1327        & CloudCoverMin,       &
  1328        & FlagPRCPPC,          &
  1329        & FlagPRCPEvap,        &
  1330        & PRCPArea,            &
  1331        & PRCPEvapArea
  1332            !
  1333            ! デフォルト値については初期化手続 "cloud_simple#CloudSimpleInit"
  1334            ! のソースコードを参照のこと.
  1335            !
  1336            ! Refer to source codes in the initialization procedure
  1337            ! "cloud_simple#CloudSimpleInit" for the default values.
  1338            !
  1339  
  1340      ! 実行文 ; Executable statement
  1341      !
  1342  
  1343      if ( cloud_simple_inited ) return
  1344  
  1345  
  1346      FlagSnow = ArgFlagSnow
  1347  
  1348  
  1349      ! デフォルト値の設定
  1350      ! Default values settings
  1351      !
  1352      CloudLifeTime       = 3600.0_DP
  1353      CloudWatLifeTime    = 3600.0_DP
  1354      CloudIceLifeTime    = 3600.0_DP
  1355  
  1356      CloudCoverMethod    = 'Const'
  1357  !!$    CloudCoverMethod    = 'RH'
  1358  
  1359      SnowMethod          = 'KeyLLTemp'
  1360  
  1361      CloudCover          = 1.0_DP
  1362  
  1363      CloudCoverRHCrtl    = 0.0_DP
  1364  
  1365      CloudCoverMin       = 0.0_DP
  1366  
  1367      FlagPRCPPC          = .true.
  1368  
  1369      FlagPRCPEvap        = .true.
  1370  !!$    PRCPEvapArea        = 0.5_DP
  1371      PRCPArea            = 1.0_DP
  1372  !!$    PRCPArea            = 0.5_DP
  1373      PRCPEvapArea        = 1.0_DP
  1374  !!$    PRCPEvapArea        = 0.5_DP
  1375  
  1376  
  1377      ! NAMELIST の読み込み
  1378      ! NAMELIST is input
  1379      !
  1380      if ( trim(namelist_filename) /= '' ) then
  1381        call FileOpen( unit_nml, &          ! (out)
  1382          & namelist_filename, mode = 'r' ) ! (in)
  1383  
  1384        rewind( unit_nml )
  1385        read( unit_nml,                     & ! (in)
  1386          & nml = cloud_simple_nml,         & ! (out)
  1387          & iostat = iostat_nml )             ! (out)
  1388        close( unit_nml )
  1389  
  1390        call NmlutilMsg( iostat_nml, module_name ) ! (in)
  1391      end if
  1392  
  1393  
  1394      select case ( CloudCoverMethod )
  1395      case ( 'Const' )
  1396        IDCloudCoverMethod = IDCloudCoverMethodConst
  1397      case ( 'RH' )
  1398        IDCloudCoverMethod = IDCloudCoverMethodRH
  1399      case ( 'RHLin' )
  1400        IDCloudCoverMethod = IDCloudCoverMethodRHLin
  1401      case default
  1402        call MessageNotify( 'E', module_name,         &
  1403          & 'CloudCoverMethod=<%c> is not supported.', &
  1404          & c1 = trim(CloudCoverMethod) )
  1405      end select
  1406  
  1407  
  1408      select case ( SnowMethod )
  1409      case ( 'KeyLLTemp' )
  1410        IDSnowMethod = IDSnowMethodKeyLLTemp
  1411      case ( 'StepPC' )
  1412        IDSnowMethod = IDSnowMethodStepPC
  1413      case default
  1414        call MessageNotify( 'E', module_name,         &
  1415          & 'SnowMethod=<%c> is not supported.', &
  1416          & c1 = trim(SnowMethod) )
  1417      end select
  1418  
  1419  
  1420  
  1421      ! Initialization of modules used in this module
  1422      !
  1423  
  1424      ! 飽和比湿の算出
  1425      ! Evaluate saturation specific humidity
  1426      !
  1427      call SaturateInit
  1428  
  1429      ! 大規模凝結 (非対流性凝結) (Manabe, 1965)
  1430      ! Large scale condensation (non-convective condensation) (Le Treut and Li, 1991)
  1431      !
  1432      call LScaleCondInit( &
  1433        & FlagSnow &
  1434        & )
  1435  
  1436  
  1437      ! ヒストリデータ出力のためのへの変数登録
  1438      ! Register of variables for history data output
  1439      !
  1440  !!$    call HistoryAutoAddVariable( 'EffCloudCover', &
  1441  !!$      & (/ 'lon ', 'lat ', 'time' /), &
  1442  !!$      & 'effective cloud cover', '1' )
  1443  
  1444  
  1445  
  1446      ! 印字 ; Print
  1447      !
  1448      call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
  1449      call MessageNotify( 'M', module_name, 'CloudLifeTime       = %f', d = (/ CloudLifeTime /) )
  1450      call MessageNotify( 'M', module_name, 'CloudWatLifeTime    = %f', d = (/ CloudWatLifeTime /) )
  1451      call MessageNotify( 'M', module_name, 'CloudIceLifeTime    = %f', d = (/ CloudIceLifeTime /) )
  1452      call MessageNotify( 'M', module_name, 'CloudCoverMethod    = %c', c1 = trim(CloudCoverMethod) )
  1453      call MessageNotify( 'M', module_name, 'SnowMethod          = %c', c1 = trim(SnowMethod) )
  1454      call MessageNotify( 'M', module_name, 'CloudCover          = %f', d = (/ CloudCover /) )
  1455      call MessageNotify( 'M', module_name, 'CloudCoverRHCrtl    = %f', d = (/ CloudCoverRHCrtl /) )
  1456      call MessageNotify( 'M', module_name, 'CloudCoverMin       = %f', d = (/ CloudCoverMin /) )
  1457      call MessageNotify( 'M', module_name, 'FlagPRCPPC          = %b', l = (/ FlagPRCPPC /) )
  1458      call MessageNotify( 'M', module_name, 'FlagPRCPEvap        = %b', l = (/ FlagPRCPEvap /) )
  1459      call MessageNotify( 'M', module_name, 'PRCPArea            = %f', d = (/ PRCPArea /) )
  1460      call MessageNotify( 'M', module_name, 'PRCPEvapArea        = %f', d = (/ PRCPEvapArea /) )
  1461      call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
  1462  
  1463  
  1464      cloud_simple_inited = .true.
  1465  
  1466    end subroutine CloudSimpleInit
  1467  
  1468    !--------------------------------------------------------------------------------------
  1469  
  1470  end module cloud_simple
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:55 2016
FILE NAME: cloud_simple.f90
PROGRAM NAME: cloud_simple
FORMAT LIST

  LINE    LOOP      FORTRAN STATEMENT

     1:             != 簡単雲モデル
     2:             !
     3:             != Simple cloud model
     4:             !
     5:             ! Authors::   Yoshiyuki O. Takahashi
     6:             ! Version::   $Id: cloud_simple.f90,v 1.9 2015/01/29 12:06:43 yot Exp $
     7:             ! Tag Name::  $Name:  $
     8:             ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9:             ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10:             !
    11:             
    12:             module cloud_simple
    13:               !
    14:               != 簡単雲モデル
    15:               !
    16:               != Simple cloud model
    17:               !
    18:               ! <b>Note that Japanese and English are described in parallel.</b>
    19:               !
    20:               ! 簡単雲モデルによる雲の計算.
    21:               !
    22:               ! In this module, the amount of cloud is calculated by use of a simple
    23:               ! cloud model.
    24:               !
    25:               !== Procedures List
    26:               !
    27:             !!$  ! RadiationFluxDennouAGCM :: 放射フラックスの計算
    28:             !!$  ! ------------            :: ------------
    29:             !!$  ! RadiationFluxDennouAGCM :: Calculate radiation flux
    30:               !
    31:               !== NAMELIST
    32:               !
    33:               ! NAMELIST#cloud_simple_nml
    34:               !
    35:             
    36:               ! モジュール引用 ; USE statements
    37:             
    38:               !
    39:               ! Kind type parameter
    40:               !
    41:               use dc_types, only: DP, &      ! Double precision.
    42:                 &                 STRING, &  ! Strings.
    43:                 &                 TOKEN      ! Keywords.
    44:             
    45:               ! メッセージ出力
    46:               ! Message output
    47:               !
    48:               use dc_message, only: MessageNotify
    49:             
    50:               ! 格子点設定
    51:               ! Grid points settings
    52:               !
    53:               use gridset, only: imax, & ! 経度格子点数.
    54:                                          ! Number of grid points in longitude
    55:                 &                jmax, & ! 緯度格子点数.
    56:                                          ! Number of grid points in latitude
    57:                 &                kmax    ! 鉛直層数.
    58:                                          ! Number of vertical level
    59:             
    60:               implicit none
    61:             
    62:               private
    63:             
    64:             
    65:               ! 公開手続き
    66:               ! Public procedure
    67:               !
    68:               public :: CloudSimple
    69:               public :: CloudSimpleCalcPRCPKeyLLTemp
    70:               public :: CloudSimpleCalcPRCPKeyLLTemp3D
    71:               public :: CloudSimpleCalcPRCPStepPC
    72:               public :: CloudSimpleWithIce
    73:               public :: CloudSimpleCalcCloudCover
    74:               public :: CloudSimpleInit
    75:             
    76:               public :: CloudSimpleDivideWatAndIce
    77:             
    78:             
    79:               ! 公開変数
    80:               ! Public variables
    81:               !
    82:             
    83:             
    84:               ! 非公開変数
    85:               ! Private variables
    86:               !
    87:               logical , save        :: FlagSnow
    88:                                        ! A flag for snow
    89:             
    90:               integer , save        :: IDCloudCoverMethod
    91:               integer , parameter   :: IDCloudCoverMethodConst    = 1
    92:               integer , parameter   :: IDCloudCoverMethodRH       = 2
    93:               integer , parameter   :: IDCloudCoverMethodRHLin    = 3
    94:             
    95:               integer , save        :: IDSnowMethod
    96:               integer , parameter   :: IDSnowMethodKeyLLTemp      = 11
    97:               integer , parameter   :: IDSnowMethodStepPC         = 12
    98:             
    99:               real(DP), save        :: CloudLifeTime
   100:               real(DP), save        :: CloudWatLifeTime
   101:               real(DP), save        :: CloudIceLifeTime
   102:             
   103:               real(DP), save        :: CloudCover
   104:               real(DP), save        :: CloudCoverRHCrtl
   105:               real(DP), save        :: CloudCoverMin
   106:             
   107:             
   108:               logical , save :: FlagPRCPPC
   109:             
   110:               logical , save :: FlagPRCPEvap
   111:               real(DP), save :: PRCPArea
   112:                 !                           a_p
   113:               real(DP), save :: PRCPEvapArea
   114:                 !                           A = max( a_p - a, 0 )
   115:             
   116:             
   117:               logical, save :: cloud_simple_inited = .false.
   118:                                           ! 初期設定フラグ.
   119:                                           ! Initialization flag
   120:             
   121:               character(*), parameter:: module_name = 'cloud_simple'
   122:                                           ! モジュールの名称.
   123:                                           ! Module name
   124:               character(*), parameter:: version = &
   125:                 & '$Name:  $' // &
   126:                 & '$Id: cloud_simple.f90,v 1.9 2015/01/29 12:06:43 yot Exp $'
   127:                                           ! モジュールのバージョン
   128:                                           ! Module version
   129:             
   130:               !--------------------------------------------------------------------------------------
   131:             
   132:             contains
   133:             
   134:               !--------------------------------------------------------------------------------------
   135:             
   136:               subroutine CloudSimple(                             &
   137:                 & xyr_Press, xyz_Press,                           & ! (in)
   138:                 & xyz_Temp,                                       & ! (inout)
   139:             !!$    & xyz_DQH2OLiqDtCum, xyz_DQH2OLiqDtLSC,           & ! (in)
   140:                 & xyz_QH2OVap, xyz_QH2OLiq,                       & ! (inout)
   141:                 & xy_Rain, xy_Snow                                & ! (out)
   142:                 & )
   143:             
   144:                 ! USE statements
   145:                 !
   146:             
   147:                 ! 時刻管理
   148:                 ! Time control
   149:                 !
   150:                 use timeset, only: &
   151:                   & DelTime            ! $ \Delta t $ [s]
   152:             
   153:             
   154:                 real(DP), intent(in   ) :: xyr_Press        ( 0:imax-1, 1:jmax, 0:kmax )
   155:                 real(DP), intent(in   ) :: xyz_Press        ( 0:imax-1, 1:jmax, 1:kmax )
   156:                 real(DP), intent(inout) :: xyz_Temp         ( 0:imax-1, 1:jmax, 1:kmax )
   157:             !!$    real(DP), intent(in   ) :: xyz_DQH2OLiqDtCum( 0:imax-1, 1:jmax, 1:kmax )
   158:             !!$    real(DP), intent(in   ) :: xyz_DQH2OLiqDtLSC( 0:imax-1, 1:jmax, 1:kmax )
   159:                 real(DP), intent(inout) :: xyz_QH2OVap      ( 0:imax-1, 1:jmax, 1:kmax )
   160:                 real(DP), intent(inout) :: xyz_QH2OLiq      ( 0:imax-1, 1:jmax, 1:kmax )
   161:                 real(DP), intent(out  ) :: xy_Rain          ( 0:imax-1, 1:jmax )
   162:                 real(DP), intent(out  ) :: xy_Snow          ( 0:imax-1, 1:jmax )
   163:             
   164:             
   165:                 ! Tentative
   166:                 real(DP) xyz_DQH2OLiqDtCum( 0:imax-1, 1:jmax, 1:kmax )
   167:                 real(DP) xyz_DQH2OLiqDtLSC( 0:imax-1, 1:jmax, 1:kmax )
   168:             
   169:                 real(DP) :: xyz_TempB   ( 0:imax-1, 1:jmax, 1:kmax )
   170:                 real(DP) :: xyz_QH2OVapB( 0:imax-1, 1:jmax, 1:kmax )
   171:                 real(DP) :: xyz_QH2OLiqB( 0:imax-1, 1:jmax, 1:kmax )
   172:                 real(DP) :: xyz_DQRainDt( 0:imax-1, 1:jmax, 1:kmax )
   173:                 real(DP) :: xyz_DQSnowDt( 0:imax-1, 1:jmax, 1:kmax )
   174:             
   175:                 real(DP) :: xyz_QH2OSolB( 0:imax-1, 1:jmax, 1:kmax )
   176:                 real(DP) :: xyz_QH2OSol ( 0:imax-1, 1:jmax, 1:kmax )
   177:             
   178:             !!$    real(DP) :: xyz_DTempDtPrcpPCCum( 0:imax-1, 1:jmax, 1:kmax )
   179:             !!$    real(DP) :: xyz_DTempDtPrcpPCLsc( 0:imax-1, 1:jmax, 1:kmax )
   180:             
   181:                 ! 実行文 ; Executable statement
   182:                 !
   183:             
   184:                 ! 初期化確認
   185:                 ! Initialization check
   186:                 !
   187:                 if ( .not. cloud_simple_inited ) then
   188:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   189:                 end if
   190:             
   191:             
   192:                 ! tentative treatment
   193: **W---->        xyz_DQH2OLiqDtCum = 0.0_DP
   194: |||             xyz_DQH2OLiqDtLSC = 0.0_DP
   195: |||         
   196: |||         
   197: |||             ! Numerical solution
   198: |||         
   199: |||         !!$      xyz_DQCloudWaterDt = xyz_DQCloudWaterDt &
   200: |||         !!$        & - xyz_QCloudWater / ( CloudLifeTime + 1.0d-100 )
   201: |||         
   202: |||         
   203: |||         !      ( X_{t+1} - X_{t-1} ) / ( 2 \Delta t ) = Q - X_{t+1} / \tau
   204: |||         !
   205: |||         !      X_{t+1} / ( 2 \Delta t )  + X_{t+1} / \tau = X_{t-1} / ( 2 \Delta t ) + Q
   206: |||         !      ( 1 / ( 2 \Delta t )  + 1 / \tau ) X_{t+1} = X_{t-1} / ( 2 \Delta t ) + Q
   207: |||         !      X_{t+1} = ( X_{t-1} / ( 2 \Delta t ) + Q ) / ( 1 / ( 2 \Delta t )  + 1 / \tau ) 
   208: |||         
   209: |||         !!$    xyz_QH2OLiq =                                                           &
   210: |||         !!$      &   (                                                                 &
   211: |||         !!$      &       xyz_QH2OLiq / ( 2.0_DP * DelTime )                            &
   212: |||         !!$      &     + xyz_DQH2OLiqDtCum + xyz_DQH2OLiqDtLSC                         &
   213: |||         !!$      &   )                                                                 &
   214: |||         !!$      & / ( 1.0_DP / ( 2.0_DP * DelTime ) + 1.0_DP / ( CloudLifeTime + 1.0d-100 ) )
   215: |||         !!$
   216: |||         !!$    call CloudUtilsCalcPRCPKeyLLTemp3D(          &
   217: |||         !!$      & xyr_Press, xyz_Temp, xyz_DQH2OLiqDtCum,  &  ! (in )
   218: |||         !!$      & xy_RainCum, xy_SnowCum                   &  ! (out)
   219: |||         !!$      & )
   220: |||         !!$    call CloudUtilsCalcPRCPKeyLLTemp3D(          &
   221: |||         !!$      & xyr_Press, xyz_Temp, xyz_DQH2OLiqDtLsc,  &  ! (in )
   222: |||         !!$      & xy_RainLsc, xy_SnowLsc                   &  ! (out)
   223: |||         !!$      & )
   224: |||             !-----
   225: |||         
   226: |||         
   227: |||             ! Analytical solution
   228: |||         
   229: |||             ! save values before adjustment
   230: |||     A       xyz_TempB    = xyz_Temp
   231: |||     A       xyz_QH2OVapB = xyz_QH2OVap
   232: |||     A       xyz_QH2OLiqB = xyz_QH2OLiq
   233: |||         
   234: |||     A       xyz_QH2OLiq =                                                                 &
   235: |||               &   xyz_QH2OLiq * exp( - 2.0_DP * DelTime / ( CloudLifeTime + 1.0e-100_DP ) )  &
   236: |||               & + ( xyz_DQH2OLiqDtCum + xyz_DQH2OLiqDtLSC ) * CloudLifeTime               &
   237: |||               &   * ( 1.0_DP - exp( - 2.0_DP * DelTime / ( CloudLifeTime + 1.0e-100_DP ) ) )
   238: |||         
   239: |||             xyz_DQRainDt =                                                     &
   240: |||               &   xyz_QH2OLiqB                                                 &
   241: |||               & + ( xyz_DQH2OLiqDtCum + xyz_DQH2OLiqDtLSC ) * 2.0_DP * DelTime &
   242: |||               & - xyz_QH2OLiq
   243: **W---- A       xyz_DQRainDt = xyz_DQRainDt / ( 2.0_DP * DelTime )
   244:             
   245:             
   246:             
   247:                 select case ( IDSnowMethod )
   248:                 case ( IDSnowMethodKeyLLTemp )
   249:             
   250:                   call CloudSimpleCalcPRCPKeyLLTemp3D(      &
   251:                     & xyr_Press, xyz_Press, xyz_DQRainDt,   &  ! (in )
   252:                     & xyz_Temp, xyz_QH2OVap,                &  ! (in )
   253:                     & xy_Rain, xy_Snow                      &  ! (out)
   254:                     & )
   255:             
   256: **W---->A         xyz_QH2OSolB = 0.0_DP
   257: **W---- A         xyz_QH2OSol  = 0.0_DP
   258:                   call CloudSimpleConsChk(                                 &
   259:                     & .false.,                                             &
   260:                     & xyr_Press,                                           &
   261:                     & xyz_TempB, xyz_QH2OVapB, xyz_QH2OLiqB, xyz_QH2OSolB, &
   262:                     & xyz_Temp , xyz_QH2OVap , xyz_QH2OLiq , xyz_QH2OSol , &
   263:                     & xy_Rain, xy_Snow                                     &
   264:                     & )
   265:             
   266:                 case ( IDSnowMethodStepPC )
   267:             
   268: W**==== A         xyz_DQSnowDt = 0.0_DP
   269:             
   270:                   call CloudSimpleCalcPRCPStepPC(      &
   271:                     & xyr_Press, xyz_Press,                  & ! (in   )
   272:                     & xyz_DQRainDt, xyz_DQSnowDt,            & ! (in   )
   273:                     & xyz_Temp, xyz_QH2OVap,                 & ! (inout)
   274:                     & xy_Rain, xy_Snow                       & ! (out  )
   275:                     & )
   276:             
   277: **W---->A         xyz_QH2OSolB = 0.0_DP
   278: **W---- A         xyz_QH2OSol  = 0.0_DP
   279:                   call CloudSimpleConsChk(                                 &
   280:                     & .true.,                                              &
   281:                     & xyr_Press,                                           &
   282:                     & xyz_TempB, xyz_QH2OVapB, xyz_QH2OLiqB, xyz_QH2OSolB, &
   283:                     & xyz_Temp , xyz_QH2OVap , xyz_QH2OLiq , xyz_QH2OSol , &
   284:                     & xy_Rain, xy_Snow                                     &
   285:                     & )
   286:             
   287:                 end select
   288:             
   289:             
   290:               end subroutine CloudSimple
   291:             
   292:               !--------------------------------------------------------------------------------------
   293:             
   294:               subroutine CloudSimpleCalcPRCPKeyLLTemp(  &
   295:                 & xyz_Temp, xy_PRCP,                   &  ! (in )
   296:                 & xy_SurfRainFlux, xy_SurfSnowFlux     &  ! (out)
   297:                 & )
   298:             
   299:             
   300:                 ! 雪と海氷の定数の設定
   301:                 ! Setting constants of snow and sea ice
   302:                 !
   303:                 use constants_snowseaice, only: TempCondWater
   304:             
   305:             
   306:                 real(DP), intent(in ) :: xyz_Temp       ( 0:imax-1, 1:jmax, 1:kmax )
   307:                 real(DP), intent(in ) :: xy_PRCP        ( 0:imax-1, 1:jmax )
   308:                 real(DP), intent(out) :: xy_SurfRainFlux( 0:imax-1, 1:jmax )
   309:                 real(DP), intent(out) :: xy_SurfSnowFlux( 0:imax-1, 1:jmax )
   310:             
   311:             
   312:                 ! 作業変数
   313:                 ! Work variables
   314:                 !
   315:                 integer:: i               ! 経度方向に回る DO ループ用作業変数
   316:                                           ! Work variables for DO loop in longitude
   317:                 integer:: j               ! 緯度方向に回る DO ループ用作業変数
   318:                                           ! Work variables for DO loop in latitude
   319:             
   320:             
   321:                 ! 初期化確認
   322:                 ! Initialization check
   323:                 !
   324:                 if ( .not. cloud_simple_inited ) then
   325:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   326:                 end if
   327:             
   328:             
   329:                 if ( FlagSnow ) then
   330:             
   331: W------>          do j = 1, jmax
   332: |*----->            do i = 0, imax-1
   333: ||      A             if ( xyz_Temp(i,j,1) > TempCondWater ) then
   334: ||      A               xy_SurfRainFlux(i,j) = xy_PRCP(i,j)
   335: ||                      xy_SurfSnowFlux(i,j) = 0.0_DP
   336: ||                    else
   337: ||                      xy_SurfRainFlux(i,j) = 0.0_DP
   338: ||      A               xy_SurfSnowFlux(i,j) = xy_PRCP(i,j)
   339: ||                    end if
   340: |*----- A           end do
   341: W------           end do
   342:             
   343:                 else
   344:             
   345: *W----->A         xy_SurfRainFlux = xy_PRCP
   346: *W----- A         xy_SurfSnowFlux = 0.0_DP
   347:             
   348:                 end if
   349:             
   350:             
   351:               end subroutine CloudSimpleCalcPRCPKeyLLTemp
   352:             
   353:               !--------------------------------------------------------------------------------------
   354:             
   355:               subroutine CloudSimpleCalcPRCPKeyLLTemp3D(  &
   356:                 & xyr_Press, xyz_Press, xyz_DQH2OLiqDt,   &  ! (in )
   357:                 & xyz_Temp, xyz_QH2OVap,                  &  ! (in )
   358:                 & xy_SurfRainFlux, xy_SurfSnowFlux        &  ! (out)
   359:                 & )
   360:             
   361:                 ! 時刻管理
   362:                 ! Time control
   363:                 !
   364:                 use timeset, only: &
   365:                   & DelTime            ! $ \Delta t $ [s]
   366:             
   367:                 ! 物理定数設定
   368:                 ! Physical constants settings
   369:                 !
   370:                 use constants, only:  &
   371:                   & CpDry,            &
   372:                                           ! $ C_p $ [J kg-1 K-1].
   373:                                           ! 乾燥大気の定圧比熱.
   374:                                           ! Specific heat of air at constant pressure
   375:                   & Grav,             &
   376:                                           ! $ g $ [m s-2].
   377:                                           ! 重力加速度.
   378:                                           ! Gravitational acceleration
   379:                   & LatentHeat,       &
   380:                                           ! $ L $ [J kg-1] .
   381:                                           ! 蒸発の潜熱.
   382:                                           ! Latent heat
   383:                   & LatentHeatFusion, &
   384:                                           ! $ L $ [J kg-1] .
   385:                                           ! 融解の潜熱.
   386:                                           ! Latent heat of fusion
   387:                   & EpsV
   388:                                           ! $ \epsilon_v $ .
   389:                                           ! 水蒸気分子量比.
   390:                                           ! Molecular weight of water vapor
   391:             
   392:                 ! 飽和比湿の算出
   393:                 ! Evaluate saturation specific humidity
   394:                 !
   395:                 use saturate, only: &
   396:                   & xyz_CalcQVapSat, &
   397:                   & xyz_CalcQVapSatOnLiq
   398:             
   399:                 real(DP), intent(in   ) :: xyr_Press       ( 0:imax-1, 1:jmax, 0:kmax )
   400:                 real(DP), intent(in   ) :: xyz_Press       ( 0:imax-1, 1:jmax, 1:kmax )
   401:                 real(DP), intent(in   ) :: xyz_DQH2OLiqDt  ( 0:imax-1, 1:jmax, 1:kmax )
   402:                 real(DP), intent(inout) :: xyz_Temp        ( 0:imax-1, 1:jmax, 1:kmax )
   403:                 real(DP), intent(inout) :: xyz_QH2OVap     ( 0:imax-1, 1:jmax, 1:kmax )
   404:                 real(DP), intent(out  ) :: xy_SurfRainFlux ( 0:imax-1, 1:jmax )
   405:                 real(DP), intent(out  ) :: xy_SurfSnowFlux ( 0:imax-1, 1:jmax )
   406:             
   407:             
   408:                 ! 作業変数
   409:                 ! Work variables
   410:                 !
   411:                 real(DP) :: xyz_DelMass ( 0:imax-1, 1:jmax, 1:kmax )
   412:                 real(DP) :: xyz_DQRainDt( 0:imax-1, 1:jmax, 1:kmax )
   413:             
   414:                 real(DP) :: VirTemp
   415:                 real(DP) :: aaa_QH2OVapSat(1,1,1)
   416:                 real(DP) :: QH2OVapSat
   417:                 real(DP) :: PRCPFlux
   418:                 real(DP) :: DelPRCPFlux
   419:                 real(DP) :: DelQH2OVap
   420:                 real(DP) :: LatentHeatLocal
   421:                 character(STRING) :: CharPhase
   422:             
   423:                 real(DP) :: xy_PRCP( 0:imax-1, 1:jmax )
   424:             
   425:                 integer  :: i
   426:                 integer  :: j
   427:                 integer  :: k
   428:             
   429:             
   430:                 ! 初期化確認
   431:                 ! Initialization check
   432:                 !
   433:                 if ( .not. cloud_simple_inited ) then
   434:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   435:                 end if
   436:             
   437:             
   438: W------>        do k = 1, kmax
   439: |**==== A         xyz_DelMass(:,:,k) = ( xyr_Press(:,:,k-1) - xyr_Press(:,:,k) ) / Grav
   440: W------         end do
   441:             
   442:             
   443:                 if ( FlagPRCPEvap ) then
   444:             
   445: W**==== A         xyz_DQRainDt = xyz_DQH2OLiqDt
   446:             
   447: W*===== A         xy_SurfRainFlux = 0.0_DP
   448: +------>          do j = 1, jmax
   449: |+----->            do i = 0, imax-1
   450: ||+---->              do k = kmax, 1, -1
   451: |||         
   452: |||                     ! This is moved below.
   453: |||         !!$            xy_SurfRainFlux(i,j) = xy_SurfRainFlux(i,j) &
   454: |||         !!$              & + xyz_DQRainDt(i,j,k) * xyz_DelMass(i,j,k)
   455: |||         
   456: |||                     CharPhase = 'liquid'
   457: |||                     aaa_QH2OVapSat(1:1,1:1,1:1) = &
   458: |||                       & xyz_CalcQVapSatOnLiq( xyz_Temp(i:i,j:j,k:k), xyz_Press(i:i,j:j,k:k) )
   459: |||                     PRCPFlux = xy_SurfRainFlux(i,j)
   460: |||                     QH2OVapSat = aaa_QH2OVapSat(1,1,1)
   461: |||                     VirTemp = xyz_Temp(i,j,k) * ( 1.0_DP + ((( 1.0_DP / EpsV ) - 1.0_DP ) * xyz_QH2OVap(i,j,k)) )
   462: |||                     call CloudSimpleEvap1Grid( &
   463: |||                       & CharPhase,                                    &
   464: |||                       & xyz_DelMass(i,j,k), xyz_Press(i,j,k), xyz_QH2OVap(i,j,k), QH2OVapSat, VirTemp, &
   465: |||                       & PRCPFlux,                                                                      &
   466: |||                       & DelPRCPFlux                                       &
   467: |||                       & )
   468: |||                     xy_SurfRainFlux(i,j) = PRCPFlux - DelPRCPFlux
   469: |||                     LatentHeatLocal      = LatentHeat
   470: |||                     DelQH2OVap = DelPRCPFlux * ( 2.0_DP * DelTime ) / xyz_DelMass(i,j,k)
   471: |||                     xyz_QH2OVap(i,j,k) = xyz_QH2OVap(i,j,k) + DelQH2OVap
   472: |||                     xyz_Temp(i,j,k) = xyz_Temp(i,j,k) - LatentHeatLocal * DelQH2OVap / CpDry
   473: |||         
   474: |||                     xy_SurfRainFlux(i,j) = xy_SurfRainFlux(i,j) &
   475: |||                       & + xyz_DQRainDt(i,j,k) * xyz_DelMass(i,j,k)
   476: |||         
   477: ||+----               end do
   478: |+-----             end do
   479: +------           end do
   480:             
   481: +V===== A         xy_PRCP = xy_SurfRainFlux
   482:             
   483:                 else
   484:             
   485: W*===== A         xy_PRCP = 0.0d0
   486: +------>          do k = kmax, 1, -1
   487: |W*==== A           xy_PRCP = xy_PRCP                                       &
   488: |                     & + xyz_DQH2OLiqDt(:,:,k)                             &
   489: |                     & * ( xyr_Press(:,:,k-1) - xyr_Press(:,:,k) ) / Grav
   490: +------           end do
   491:             
   492:                 end if
   493:             
   494:             
   495:                 call CloudSimpleCalcPRCPKeyLLTemp(     &
   496:                   & xyz_Temp, xy_PRCP,                 &  ! (in )
   497:                   & xy_SurfRainFlux, xy_SurfSnowFlux   &  ! (out)
   498:                   & )
   499:             
   500:             
   501:               end subroutine CloudSimpleCalcPRCPKeyLLTemp3D
   502:             
   503:               !--------------------------------------------------------------------------------------
   504:             
   505:               subroutine CloudSimpleWithIce(                      &
   506:                 & xyr_Press, xyz_Press,                           & ! (in)
   507:                 & xyz_Temp,                                       & ! (inout)
   508:             !!$    & xyz_DQH2OLiqDtCum, xyz_DQH2OLiqDtLSC,           & ! (in)
   509:                 & xyz_QH2OVap, xyz_QH2OLiq, xyz_QH2OSol,          & ! (inout)
   510:                 & xy_Rain, xy_Snow                                & ! (out)
   511:                 & )
   512:             
   513:                 ! USE statements
   514:                 !
   515:             
   516:                 ! 時刻管理
   517:                 ! Time control
   518:                 !
   519:                 use timeset, only: &
   520:                   & DelTime            ! $ \Delta t $ [s]
   521:             
   522:                 ! 物理定数設定
   523:                 ! Physical constants settings
   524:                 !
   525:                 use constants, only:  &
   526:                   & Grav
   527:                                           ! $ g $ [m s-2].
   528:                                           ! 重力加速度.
   529:                                           ! Gravitational acceleration
   530:             
   531:                 ! 雲関系ルーチン
   532:                 ! Cloud-related routines
   533:                 !
   534:                 use cloud_utils, only : &
   535:                   & CloudUtilsPRCPStepPC1Grid, &
   536:                   & CloudUtilsPRCPEvap1Grid, &
   537:                   & CloudUtilConsChk
   538:             
   539:             
   540:                 real(DP), intent(in   ) :: xyr_Press        ( 0:imax-1, 1:jmax, 0:kmax )
   541:                 real(DP), intent(in   ) :: xyz_Press        ( 0:imax-1, 1:jmax, 1:kmax )
   542:                 real(DP), intent(inout) :: xyz_Temp         ( 0:imax-1, 1:jmax, 1:kmax )
   543:             !!$    real(DP), intent(in   ) :: xyz_DQH2OLiqDtCum( 0:imax-1, 1:jmax, 1:kmax )
   544:             !!$    real(DP), intent(in   ) :: xyz_DQH2OLiqDtLSC( 0:imax-1, 1:jmax, 1:kmax )
   545:                 real(DP), intent(inout) :: xyz_QH2OVap     ( 0:imax-1, 1:jmax, 1:kmax )
   546:                 real(DP), intent(inout) :: xyz_QH2OLiq      ( 0:imax-1, 1:jmax, 1:kmax )
   547:                 real(DP), intent(inout) :: xyz_QH2OSol      ( 0:imax-1, 1:jmax, 1:kmax )
   548:                 real(DP), intent(out  ) :: xy_Rain          ( 0:imax-1, 1:jmax )
   549:                 real(DP), intent(out  ) :: xy_Snow          ( 0:imax-1, 1:jmax )
   550:             
   551:             
   552:                 real(DP) :: xyz_TempB   ( 0:imax-1, 1:jmax, 1:kmax )
   553:                 real(DP) :: xyz_QH2OVapB( 0:imax-1, 1:jmax, 1:kmax )
   554:                 real(DP) :: xyz_QH2OLiqB( 0:imax-1, 1:jmax, 1:kmax )
   555:                 real(DP) :: xyz_QH2OSolB( 0:imax-1, 1:jmax, 1:kmax )
   556:                 real(DP) :: xyz_DQH2OLiqDt( 0:imax-1, 1:jmax, 1:kmax )
   557:                 real(DP) :: xyz_DQH2OSolDt( 0:imax-1, 1:jmax, 1:kmax )
   558:                 real(DP) :: xy_DQRainDt( 0:imax-1, 1:jmax )
   559:                 real(DP) :: xy_DQSnowDt( 0:imax-1, 1:jmax )
   560:             
   561:                 real(DP) :: xyz_DelMass( 0:imax-1, 1:jmax, 1:kmax )
   562:             
   563:                 integer :: i
   564:                 integer :: j
   565:                 integer :: k
   566:             
   567:             
   568:                 ! 実行文 ; Executable statement
   569:                 !
   570:             
   571:                 ! 初期化確認
   572:                 ! Initialization check
   573:                 !
   574:                 if ( .not. cloud_simple_inited ) then
   575:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   576:                 end if
   577:             
   578:                 ! save values before adjustment
   579: **W---->A       xyz_TempB    = xyz_Temp
   580: |||     A       xyz_QH2OVapB = xyz_QH2OVap
   581: |||     A       xyz_QH2OLiqB = xyz_QH2OLiq
   582: |||     A       xyz_QH2OSolB = xyz_QH2OSol
   583: |||         
   584: |||         
   585: |||             xyz_DQH2OLiqDt = 0.0_DP
   586: **W----         xyz_DQH2OSolDt = 0.0_DP
   587:             
   588: W------>        do k = 1, kmax
   589: |**==== A         xyz_DelMass(:,:,k) = ( xyr_Press(:,:,k-1) - xyr_Press(:,:,k) ) / Grav
   590: W------         end do
   591:             
   592:             
   593:                 ! Rain and snow at the surface
   594: *W----->A       xy_Rain = 0.0_DP
   595: *W----- A       xy_Snow = 0.0_DP
   596:             
   597: +------>        k_loop : do k = kmax, 1, -1
   598: |           
   599: |                 ! Freezing/melting and evaporation of precipitation
   600: |                 !
   601: |                 if ( FlagPRCPPC ) then
   602: |+----->            do j = 1, jmax
   603: ||+---->              do i = 0, imax-1
   604: |||                     call CloudUtilsPRCPStepPC1Grid(  &
   605: |||                       & xyr_Press(i,j,k-1), xyr_Press(i,j,k),       & ! (in   )
   606: |||                       & xyz_Temp(i,j,k),                            & ! (inout)
   607: |||                       & xy_Rain(i,j), xy_Snow(i,j)                  & ! (inout)
   608: |||                       & )
   609: ||+----               end do
   610: |+-----             end do
   611: |                 end if
   612: |                 if ( FlagPRCPEvap ) then
   613: |+----->            do j = 1, jmax
   614: ||+---->              do i = 0, imax-1
   615: |||                     call CloudUtilsPRCPEvap1Grid(           &
   616: |||                       & xyz_Press(i,j,k), xyr_Press(i,j,k-1), xyr_Press(i,j,k), & ! (in)
   617: |||                       & PRCPArea, PRCPEvapArea,                                 & ! (in)
   618: |||                       & xyz_Temp(i,j,k), xyz_QH2OVap(i,j,k),                    & ! (inout)
   619: |||                       & xy_Rain(i,j), xy_Snow(i,j)                              & ! (inout)
   620: |||                       & )
   621: ||+----               end do
   622: |+-----             end do
   623: |                 end if
   624: |           
   625: |           
   626: |*W---->A         xyz_QH2OLiq(:,:,k) =                                                    &
   627: |||                 &   xyz_QH2OLiq(:,:,k)                                                &
   628: |||                 &     * exp( - 2.0_DP * DelTime / ( CloudWatLifeTime + 1.0e-100_DP ) )&
   629: |||                 & + xyz_DQH2OLiqDt(:,:,k) * CloudWatLifeTime                          &
   630: |||                 &   * ( 1.0_DP - exp( - 2.0_DP * DelTime / ( CloudWatLifeTime + 1.0e-100_DP ) ) )
   631: |||         
   632: |||     A         xy_DQRainDt =                          &
   633: |||                 &   xyz_QH2OLiqB(:,:,k)                      &
   634: |||                 & + xyz_DQH2OLiqDt(:,:,k) * 2.0_DP * DelTime &
   635: |||                 & - xyz_QH2OLiq(:,:,k)
   636: |||               xy_DQRainDt = xy_DQRainDt / ( 2.0_DP * DelTime )
   637: |||         
   638: |||         
   639: |||     A         xyz_QH2OSol(:,:,k) =                                                    &
   640: |||                 &   xyz_QH2OSol(:,:,k) &
   641: |||                 &     * exp( - 2.0_DP * DelTime / ( CloudIceLifeTime + 1.0e-100_DP ) )&
   642: |||                 & + xyz_DQH2OSolDt(:,:,k) * CloudIceLifeTime                          &
   643: |||                 &   * ( 1.0_DP - exp( - 2.0_DP * DelTime / ( CloudIceLifeTime + 1.0e-100_DP ) ) )
   644: |||         
   645: |||     A         xy_DQSnowDt =                          &
   646: |||                 &   xyz_QH2OSolB(:,:,k)                      &
   647: |||                 & + xyz_DQH2OSolDt(:,:,k) * 2.0_DP * DelTime &
   648: |||                 & - xyz_QH2OSol(:,:,k)
   649: |||               xy_DQSnowDt = xy_DQSnowDt / ( 2.0_DP * DelTime )
   650: |||         
   651: |||     A         xy_Rain = xy_Rain + xy_DQRainDt * xyz_DelMass(:,:,k)
   652: |*W---- A         xy_Snow = xy_Snow + xy_DQSnowDt * xyz_DelMass(:,:,k)
   653: |           
   654: |           
   655: +------         end do k_loop
   656:             
   657:             
   658:                 call CloudUtilConsChk(                                   &
   659:                   & "CloudSimpleWithIce",                                &
   660:                   & xyr_Press,                                           &
   661:                   & xyz_TempB, xyz_QH2OVapB, xyz_QH2OLiqB, xyz_QH2OSolB, &
   662:                   & xyz_Temp , xyz_QH2OVap , xyz_QH2OLiq , xyz_QH2OSol , &
   663:                   & xy_Rain, xy_Snow                                     &
   664:                   & )
   665:             
   666:             
   667:               end subroutine CloudSimpleWithIce
   668:             
   669:               !--------------------------------------------------------------------------------------
   670:             
   671:               subroutine CloudSimpleCalcPRCPStepPC(      &
   672:                 & xyr_Press, xyz_Press,                  & ! (in   )
   673:                 & xyz_DQRainDt, xyz_DQSnowDt,            & ! (in   )
   674:                 & xyz_Temp, xyz_QH2OVap,                 & ! (inout)
   675:                 & xy_SurfRainFlux, xy_SurfSnowFlux       & ! (out  )
   676:                 & )
   677:             
   678:                 ! 時刻管理
   679:                 ! Time control
   680:                 !
   681:                 use timeset, only: &
   682:                   & DelTime            ! $ \Delta t $ [s]
   683:             
   684:                 ! 物理定数設定
   685:                 ! Physical constants settings
   686:                 !
   687:                 use constants, only:  &
   688:                   & CpDry,            &
   689:                                           ! $ C_p $ [J kg-1 K-1].
   690:                                           ! 乾燥大気の定圧比熱.
   691:                                           ! Specific heat of air at constant pressure
   692:                   & Grav,             &
   693:                                           ! $ g $ [m s-2].
   694:                                           ! 重力加速度.
   695:                                           ! Gravitational acceleration
   696:                   & LatentHeat,       &
   697:                                           ! $ L $ [J kg-1] .
   698:                                           ! 蒸発の潜熱.
   699:                                           ! Latent heat
   700:                   & LatentHeatFusion, &
   701:                                           ! $ L $ [J kg-1] .
   702:                                           ! 融解の潜熱.
   703:                                           ! Latent heat of fusion
   704:                   & EpsV
   705:                                           ! $ \epsilon_v $ .
   706:                                           ! 水蒸気分子量比.
   707:                                           ! Molecular weight of water vapor
   708:             
   709:                 ! 雪と海氷の定数の設定
   710:                 ! Setting constants of snow and sea ice
   711:                 !
   712:                 use constants_snowseaice, only: TempCondWater
   713:             
   714:                 ! 飽和比湿の算出
   715:                 ! Evaluate saturation specific humidity
   716:                 !
   717:                 use saturate, only:       &
   718:                   & xyz_CalcQVapSat,      &
   719:                   & xyz_CalcQVapSatOnLiq, &
   720:                   & xyz_CalcQVapSatOnSol
   721:             
   722:             
   723:                 real(DP), intent(in   ) :: xyr_Press       ( 0:imax-1, 1:jmax, 0:kmax )
   724:                 real(DP), intent(in   ) :: xyz_Press       ( 0:imax-1, 1:jmax, 1:kmax )
   725:                 real(DP), intent(in   ) :: xyz_DQRainDt    ( 0:imax-1, 1:jmax, 1:kmax )
   726:                 real(DP), intent(in   ) :: xyz_DQSnowDt    ( 0:imax-1, 1:jmax, 1:kmax )
   727:                 real(DP), intent(inout) :: xyz_Temp        ( 0:imax-1, 1:jmax, 1:kmax )
   728:                 real(DP), intent(inout) :: xyz_QH2OVap     ( 0:imax-1, 1:jmax, 1:kmax )
   729:                 real(DP), intent(out  ) :: xy_SurfRainFlux ( 0:imax-1, 1:jmax )
   730:                 real(DP), intent(out  ) :: xy_SurfSnowFlux ( 0:imax-1, 1:jmax )
   731:             
   732:             
   733:                 ! 作業変数
   734:                 ! Work variables
   735:                 !
   736:                 real(DP) :: xyz_DelMass( 0:imax-1, 1:jmax, 1:kmax )
   737:                 real(DP) :: MassMaxFreezeRate
   738:                 real(DP) :: MassFreezeRate
   739:                 real(DP) :: MassMaxMeltRate
   740:                 real(DP) :: MassMeltRate
   741:             
   742:                 real(DP) :: VirTemp
   743:                 real(DP) :: aaa_QH2OVapSat(1,1,1)
   744:                 real(DP) :: QH2OVapSat
   745:                 real(DP) :: PRCPFlux
   746:                 real(DP) :: DelPRCPFlux
   747:                 real(DP) :: DelQH2OVap
   748:                 real(DP) :: LatentHeatLocal
   749:                 character(STRING) :: CharPhase
   750:             
   751:                 integer  :: i
   752:                 integer  :: j
   753:                 integer  :: k
   754:                 integer  :: l
   755:             
   756:             
   757:                 ! 初期化確認
   758:                 ! Initialization check
   759:                 !
   760:                 if ( .not. cloud_simple_inited ) then
   761:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   762:                 end if
   763:             
   764:             
   765: W------>        do k = 1, kmax
   766: |**==== A         xyz_DelMass(:,:,k) = ( xyr_Press(:,:,k-1) - xyr_Press(:,:,k) ) / Grav
   767: W------         end do
   768:             
   769:                 ! Freezing and melting switching at temperature of TempCondWater
   770: *W----->A       xy_SurfRainFlux = 0.0_DP
   771: *W----- A       xy_SurfSnowFlux = 0.0_DP
   772: +------>        do j = 1, jmax
   773: |+----->          do i = 0, imax-1
   774: ||+---->            do k = kmax, 1, -1
   775: |||         
   776: |||                   ! These are moved below.
   777: |||         !!$          xy_SurfRainFlux(i,j) = xy_SurfRainFlux(i,j) &
   778: |||         !!$            & + xyz_DQRainDt(i,j,k) * xyz_DelMass(i,j,k)
   779: |||         !!$          xy_SurfSnowFlux(i,j) = xy_SurfSnowFlux(i,j) &
   780: |||         !!$            & + xyz_DQSnowDt(i,j,k) * xyz_DelMass(i,j,k)
   781: |||         
   782: |||                   if ( FlagPRCPPC ) then
   783: |||         
   784: |||                     MassMaxFreezeRate =                               &
   785: |||                       &   CpDry * ( TempCondWater - xyz_Temp(i,j,k) ) &
   786: |||                       & * xyz_DelMass(i,j,k)                          &
   787: |||                       & / LatentHeatFusion                            &
   788: |||                       & / ( 2.0_DP * DelTime )
   789: |||                     if ( MassMaxFreezeRate >= 0.0_DP ) then
   790: |||                       ! freezing
   791: |||                       if ( xy_SurfRainFlux(i,j) >= MassMaxFreezeRate ) then
   792: |||                         MassFreezeRate = MassMaxFreezeRate
   793: |||                       else
   794: |||                         MassFreezeRate = xy_SurfRainFlux(i,j)
   795: |||                       end if
   796: |||                       xy_SurfRainFlux(i,j) = xy_SurfRainFlux(i,j) - MassFreezeRate
   797: |||                       xy_SurfSnowFlux(i,j) = xy_SurfSnowFlux(i,j) + MassFreezeRate
   798: |||                       xyz_Temp(i,j,k) = xyz_Temp(i,j,k)                          &
   799: |||                         & + LatentHeatFusion * MassFreezeRate * 2.0_DP * DelTime &
   800: |||                         &   / ( CpDry * xyz_DelMass(i,j,k) )
   801: |||                     else
   802: |||                       ! melting
   803: |||                       MassMaxMeltRate = - MassMaxFreezeRate
   804: |||                       if ( xy_SurfSnowFlux(i,j) >= MassMaxMeltRate ) then
   805: |||                         MassMeltRate = MassMaxMeltRate
   806: |||                       else
   807: |||                         MassMeltRate = xy_SurfSnowFlux(i,j)
   808: |||                       end if
   809: |||                       xy_SurfRainFlux(i,j) = xy_SurfRainFlux(i,j) + MassMeltRate
   810: |||                       xy_SurfSnowFlux(i,j) = xy_SurfSnowFlux(i,j) - MassMeltRate
   811: |||                       xyz_Temp(i,j,k) = xyz_Temp(i,j,k)                        &
   812: |||                         & - LatentHeatFusion * MassMeltRate * 2.0_DP * DelTime &
   813: |||                         &   / ( CpDry * xyz_DelMass(i,j,k) )
   814: |||                     end if
   815: |||         
   816: |||                   end if
   817: |||         
   818: |||         
   819: |||                   if ( FlagPRCPEvap ) then
   820: |||         !!$            do l = 0, 0   ! for test
   821: |||+--->                do l = 1, 2
   822: ||||                      select case ( l )
   823: ||||                      case ( 0 ) ! mixture
   824: ||||                        CharPhase = 'mixture'
   825: ||||                        aaa_QH2OVapSat(1:1,1:1,1:1) = &
   826: ||||                          & xyz_CalcQVapSat     ( xyz_Temp(i:i,j:j,k:k), xyz_Press(i:i,j:j,k:k) )
   827: ||||                        PRCPFlux = xy_SurfRainFlux(i,j)
   828: ||||                      case ( 1 ) ! liquid
   829: ||||                        CharPhase = 'liquid'
   830: ||||                        aaa_QH2OVapSat(1:1,1:1,1:1) = &
   831: ||||                          & xyz_CalcQVapSatOnLiq( xyz_Temp(i:i,j:j,k:k), xyz_Press(i:i,j:j,k:k) )
   832: ||||                        PRCPFlux = xy_SurfRainFlux(i,j)
   833: ||||                      case ( 2 ) ! solid
   834: ||||                        CharPhase = 'solid'
   835: ||||                        aaa_QH2OVapSat(1:1,1:1,1:1) = &
   836: ||||                          & xyz_CalcQVapSatOnSol( xyz_Temp(i:i,j:j,k:k), xyz_Press(i:i,j:j,k:k) )
   837: ||||                        PRCPFlux = xy_SurfSnowFlux(i,j)
   838: ||||                      case default
   839: ||||                        call MessageNotify( 'E', module_name, 'Unexpected number for select case.' )
   840: ||||                      end select
   841: ||||                      QH2OVapSat = aaa_QH2OVapSat(1,1,1)
   842: ||||                      VirTemp = xyz_Temp(i,j,k) * ( 1.0_DP + ((( 1.0_DP / EpsV ) - 1.0_DP ) * xyz_QH2OVap(i,j,k)) )
   843: ||||                      call CloudSimpleEvap1Grid( &
   844: ||||                        & CharPhase,                                    &
   845: ||||                        & xyz_DelMass(i,j,k), xyz_Press(i,j,k), xyz_QH2OVap(i,j,k), QH2OVapSat, VirTemp, &
   846: ||||                        & PRCPFlux,                                                                      &
   847: ||||                        & DelPRCPFlux                                       &
   848: ||||                        & )
   849: ||||                      select case ( l )
   850: ||||                      case ( 0 ) ! mixture
   851: ||||                        xy_SurfRainFlux(i,j) = PRCPFlux - DelPRCPFlux
   852: ||||                        LatentHeatLocal      = LatentHeat
   853: ||||                      case ( 1 ) ! liquid
   854: ||||                        xy_SurfRainFlux(i,j) = PRCPFlux - DelPRCPFlux
   855: ||||                        LatentHeatLocal      = LatentHeat
   856: ||||                      case ( 2 ) ! solid
   857: ||||                        xy_SurfSnowFlux(i,j) = PRCPFlux - DelPRCPFlux
   858: ||||                        LatentHeatLocal      = LatentHeat + LatentHeatFusion
   859: ||||                      end select
   860: ||||                      DelQH2OVap = DelPRCPFlux * ( 2.0_DP * DelTime ) / xyz_DelMass(i,j,k)
   861: ||||                      xyz_QH2OVap(i,j,k) = xyz_QH2OVap(i,j,k) + DelQH2OVap
   862: ||||                      xyz_Temp(i,j,k) = xyz_Temp(i,j,k) - LatentHeatLocal * DelQH2OVap / CpDry
   863: |||+---                 end do
   864: |||                   end if
   865: |||         
   866: |||                   xy_SurfRainFlux(i,j) = xy_SurfRainFlux(i,j) &
   867: |||                     & + xyz_DQRainDt(i,j,k) * xyz_DelMass(i,j,k)
   868: |||                   xy_SurfSnowFlux(i,j) = xy_SurfSnowFlux(i,j) &
   869: |||                     & + xyz_DQSnowDt(i,j,k) * xyz_DelMass(i,j,k)
   870: |||         
   871: ||+----             end do
   872: |+-----           end do
   873: +------         end do
   874:             
   875:             
   876:               end subroutine CloudSimpleCalcPRCPStepPC
   877:             
   878:               !--------------------------------------------------------------------------------------
   879:             
   880:               subroutine CloudSimpleEvap1Grid( &
   881:                 & CharPhase,                                    &
   882:                 & DelMass, Press, QH2OVap, QH2OVapSat, VirTemp, &
   883:                 & PRCP,                                         &
   884:                 & DelPRCPFlux                                   &
   885:                 & )
   886:             
   887:                 ! 物理・数学定数設定
   888:                 ! Physical and mathematical constants settings
   889:                 !
   890:                 use constants0, only: &
   891:                   & PI                    ! $ \pi $ .
   892:                                           ! 円周率.  Circular constant
   893:             
   894:                 ! 物理定数設定
   895:                 ! Physical constants settings
   896:                 !
   897:                 use constants, only: &
   898:                   & Grav, &
   899:                                           ! $ g $ [m s-2].
   900:                                           ! 重力加速度.
   901:                                           ! Gravitational acceleration
   902:                   & GasRDry
   903:                                           ! $ R $ [J kg-1 K-1].
   904:                                           ! 乾燥大気の気体定数.
   905:                                           ! Gas constant of air
   906:             
   907:             
   908:                 character(*), intent(in ) :: CharPhase
   909:                 real(DP)    , intent(in ) :: DelMass
   910:                 real(DP)    , intent(in ) :: Press
   911:                 real(DP)    , intent(in ) :: QH2OVap
   912:                 real(DP)    , intent(in ) :: QH2OVapSat
   913:                 real(DP)    , intent(in ) :: VirTemp
   914:                 real(DP)    , intent(in ) :: PRCP
   915:                 real(DP)    , intent(out) :: DelPRCPFlux
   916:             
   917:             
   918:                 ! Parameters for evaporation of rain
   919:                 real(DP), parameter :: DensWater            = 1.0d3
   920:                 !                            rho_w
   921:                 !   Values below are from Kessler (1969)
   922:                 real(DP), parameter :: PRCPFallVelFactor0        = 130.0d0
   923:                 !                            K
   924:                 real(DP), parameter :: MedianDiameterFactor      = 3.67d0
   925:                 !                            C'
   926:                 real(DP), parameter :: PRCPDistFactor            = 1.0d7
   927:                 !                            N0
   928:                 real(DP), parameter :: PRCPEvapRatUnitDiamFactor = 2.24d3
   929:                 !                            C
   930:                 real(DP), parameter :: H2OVapDiffCoef            = 1.0d-5
   931:                 !                            Kd
   932:             
   933:                 real(DP) :: PRCPFallVelRatio
   934:                 real(DP) :: PRCPFallVelFactor
   935:             
   936:                 real(DP) :: Dens0
   937:                 !                            rho_0
   938:                 real(DP) :: V00
   939:                 !                            V_{00}
   940:                 real(DP) :: PRCPEvapFactor
   941:             
   942:                 real(DP) :: Dens
   943:                 !                           rho
   944:                 real(DP) :: DensPRCP
   945:                 !                           (rho q_r)
   946:             !!$    real(DP) :: RainArea
   947:             !!$    !                           a_p
   948:             !!$    real(DP) :: RainEvapArea
   949:             !!$    !                           A = max( a_p - a, 0 )
   950:             !!$    real(DP) :: xy_CloudCover   (0:imax-1, 1:jmax)
   951:             !!$    !                           a
   952:                 real(DP) :: PRCPEvapRate
   953:             
   954:                 real(DP) :: DelZ
   955:             
   956:             
   957:                 select case ( CharPhase )
   958:                 case ( 'liquid' )
   959:                   ! for liquid water
   960:                   PRCPFallVelRatio = 1.0_DP
   961:                 case ( 'solid' )
   962:                   ! for solid water (ice)
   963:                   PRCPFallVelRatio = 0.5_DP
   964:                 case ( 'mixture' )
   965:                   ! for mixture, this is only for test
   966:                   PRCPFallVelRatio = 1.0_DP
   967:                 case default
   968:                   call MessageNotify( 'E', module_name, 'Unexpected character for select case.' )
   969:                 end select
   970:                 !
   971:                 PRCPFallVelFactor = PRCPFallVelFactor0 * PRCPFallVelRatio
   972:             
   973:                 ! Parameters for evaporation of rain
   974:                 Dens0 = 1013.0d2 / ( GasRDry * 300.0_DP )
   975:                 V00 = PRCPFallVelFactor * sqrt( MedianDiameterFactor ) &
   976:                   & / ( PI * DensWater * PRCPDistFactor )**(1.0d0/8.0d0)
   977:                 PRCPEvapFactor =                                      &
   978:             !      & RainEvapRatUnitDiamFactor * gamma( 13.0d0/5.0d0 ) &
   979:                   & PRCPEvapRatUnitDiamFactor * 1.429624558860304d0   &
   980:                   & * H2OVapDiffCoef * PRCPDistFactor**(7.0d0/20.0d0) &
   981:                   & / ( PI * DensWater )**(13.0d0/20.0d0)
   982:                 ! Values for evaporation of rain
   983:                 Dens = Press / ( GasRDry * VirTemp )
   984:             
   985:                 DelZ = DelMass / Dens
   986:             
   987:             
   988:             !!$    RainArea   = RainArea
   989:             !!$    xy_CloudCover = CloudCover
   990:             !!$    xy_RainEvapArea = max( xy_RainArea - xy_CloudCover, 0.0_DP )
   991:             !!$    RainEvapArea = RainEvapArea
   992:             
   993:                 DensPRCP =                                                   &
   994:                   & ( PRCP / ( PRCPArea + 1.0d-10 )                          &
   995:                   &   / ( V00 * sqrt( Dens0 / Dens ) ) )**(8.0d0/9.0d0)
   996:                 PRCPEvapRate =                                      &
   997:                   & Dens * PRCPEvapArea * PRCPEvapFactor            &
   998:                   &   * max( QH2OVapSat - QH2OVap, 0.0_DP )         &
   999:                   &   * DensPRCP**(13.0d0/20.0d0)
  1000:             
  1001:                 ! PRCPEvapRate (kg m-3 s-1)
  1002:                 ! DelZ         (m)
  1003:                 ! DelPRCPFlux  (kg m-2 s-1)
  1004:                 DelPRCPFlux = PRCPEvapRate * DelZ
  1005:             
  1006:                 DelPRCPFlux = min( DelPRCPFlux, PRCP )
  1007:             
  1008:             
  1009:               end subroutine CloudSimpleEvap1Grid
  1010:             
  1011:               !--------------------------------------------------------------------------------------
  1012:             
  1013:               subroutine CloudSimpleConsChk(                           &
  1014:                 & FlagIncludeIcePhaseChange,                           &
  1015:                 & xyr_Press,                                           &
  1016:                 & xyz_TempB, xyz_QH2OVapB, xyz_QH2OLiqB, xyz_QH2OSolB, &
  1017:                 & xyz_Temp , xyz_QH2OVap , xyz_QH2OLiq , xyz_QH2OSol , &
  1018:                 & xy_Rain, xy_Snow                                     &
  1019:                 & )
  1020:             
  1021:             
  1022:                 ! 時刻管理
  1023:                 ! Time control
  1024:                 !
  1025:                 use timeset, only: &
  1026:                   & DelTime            ! $ \Delta t $ [s]
  1027:             
  1028:                 ! 物理定数設定
  1029:                 ! Physical constants settings
  1030:                 !
  1031:                 use constants, only: &
  1032:                   & Grav, & 
  1033:                                           ! $ g $ [m s-2]. 
  1034:                                           ! 重力加速度. 
  1035:                                           ! Gravitational acceleration
  1036:                   & CpDry, &
  1037:                                           ! $ C_p $ [J kg-1 K-1]. 
  1038:                                           ! 乾燥大気の定圧比熱. 
  1039:                                           ! Specific heat of air at constant pressure
  1040:                   & LatentHeat, &
  1041:                                           ! $ L $ [J kg-1] . 
  1042:                                           ! 凝結の潜熱. 
  1043:                                           ! Latent heat of condensation
  1044:                   & LatentHeatFusion
  1045:                                           ! $ L $ [J kg-1] .
  1046:                                           ! 融解の潜熱.
  1047:                                           ! Latent heat of fusion
  1048:             
  1049:                 logical , intent(in) :: FlagIncludeIcePhaseChange
  1050:                 real(DP), intent(in) :: xyr_Press   (0:imax-1, 1:jmax, 0:kmax)
  1051:                 real(DP), intent(in) :: xyz_TempB   (0:imax-1, 1:jmax, 1:kmax)
  1052:                 real(DP), intent(in) :: xyz_QH2OVapB(0:imax-1, 1:jmax, 1:kmax)
  1053:                 real(DP), intent(in) :: xyz_QH2OLiqB(0:imax-1, 1:jmax, 1:kmax)
  1054:                 real(DP), intent(in) :: xyz_QH2OSolB(0:imax-1, 1:jmax, 1:kmax)
  1055:                 real(DP), intent(in) :: xyz_Temp    (0:imax-1, 1:jmax, 1:kmax)
  1056:                 real(DP), intent(in) :: xyz_QH2OVap (0:imax-1, 1:jmax, 1:kmax)
  1057:                 real(DP), intent(in) :: xyz_QH2OLiq (0:imax-1, 1:jmax, 1:kmax)
  1058:                 real(DP), intent(in) :: xyz_QH2OSol (0:imax-1, 1:jmax, 1:kmax)
  1059:                 real(DP), intent(in) :: xy_Rain     (0:imax-1, 1:jmax)
  1060:                 real(DP), intent(in) :: xy_Snow     (0:imax-1, 1:jmax)
  1061:             
  1062:                 ! Local variables
  1063:                 !
  1064:                 real(DP) :: xyz_DelMass(0:imax-1, 1:jmax, 1:kmax)
  1065:                 real(DP) :: xy_Val(0:imax-1, 1:jmax)
  1066:                 real(DP) :: xy_SumB(0:imax-1, 1:jmax)
  1067:                 real(DP) :: xy_Sum(0:imax-1, 1:jmax)
  1068:                 real(DP) :: xy_Ratio(0:imax-1, 1:jmax)
  1069:                 integer  :: i
  1070:                 integer  :: j
  1071:                 integer  :: k
  1072:             
  1073:             
  1074: W------>        do k = 1, kmax
  1075: |**==== A         xyz_DelMass(:,:,k) = ( xyr_Press(:,:,k-1) - xyr_Press(:,:,k) ) / Grav
  1076: W------         end do
  1077:             
  1078: W*=====         xy_Sum = 0.0_DP
  1079: +------>        do k = kmax, 1, -1
  1080: |*W---->A         xy_Val =   CpDry * xyz_TempB(:,:,k)               &
  1081: |||                 &      + LatentHeat * xyz_QH2OVapB(:,:,k)       &
  1082: |||                 &      - LatentHeatFusion * xyz_QH2OSolB(:,:,k)
  1083: |*W---- A         xy_Sum = xy_Sum + xy_Val * xyz_DelMass(:,:,k)
  1084: +------         end do
  1085:             
  1086: *W----->A       xy_SumB = xy_Sum
  1087: ||          
  1088: *W----- A       xy_Sum = 0.0_DP
  1089: +------>        do k = kmax, 1, -1
  1090: |*W---->A         xy_Val =   CpDry * xyz_Temp (:,:,k)               &
  1091: |||                 &      + LatentHeat * xyz_QH2OVap (:,:,k)       &
  1092: |||                 &      - LatentHeatFusion * xyz_QH2OSol (:,:,k)
  1093: |*W---- A         xy_Sum = xy_Sum + xy_Val * xyz_DelMass(:,:,k)
  1094: +------         end do
  1095:                 if ( FlagIncludeIcePhaseChange ) then
  1096: W*===== A         xy_Sum = xy_Sum - LatentHeatFusion * xy_Snow * 2.0_DP * DelTime
  1097:                 end if
  1098:             
  1099: W*===== A       xy_Ratio = ( xy_Sum - xy_SumB ) / ( xy_Sum + 1.0d-100 )
  1100: +------>        do j = 1, jmax
  1101: |+----->          do i = 0, imax-1
  1102: ||                  if ( abs( xy_Ratio(i,j) ) > 1.0d-10 ) then
  1103: ||                    call MessageNotify( 'M', module_name, 'Modified condensate static energy is not conserved, %f.', d = (/ xy_Ratio(i,j) /) )
  1104: ||                  end if
  1105: |+-----           end do
  1106: +------         end do
  1107:             
  1108:             
  1109:             
  1110: W*=====         xy_Sum = 0.0_DP
  1111: +------>        do k = kmax, 1, -1
  1112: |*W---->A         xy_Val = xyz_QH2OVapB(:,:,k) + xyz_QH2OLiqB(:,:,k) + xyz_QH2OSolB(:,:,k)
  1113: |*W---- A         xy_Sum = xy_Sum + xy_Val * xyz_DelMass(:,:,k)
  1114: +------         end do
  1115:             
  1116: *W----->A       xy_SumB = xy_Sum
  1117: ||          
  1118: *W----- A       xy_Sum = 0.0_DP
  1119: +------>        do k = kmax, 1, -1
  1120: |*W---->A         xy_Val = xyz_QH2OVap (:,:,k) + xyz_QH2OLiq (:,:,k) + xyz_QH2OSol (:,:,k)
  1121: |*W---- A         xy_Sum = xy_Sum + xy_Val * xyz_DelMass(:,:,k)
  1122: +------         end do
  1123: *W----->A       xy_Sum = xy_Sum + ( xy_Rain + xy_Snow ) * 2.0_DP * DelTime
  1124: ||          
  1125: *W-----         xy_Ratio = ( xy_Sum - xy_SumB ) / ( xy_Sum + 1.0d-100 )
  1126: +------>        do j = 1, jmax
  1127: |+----->          do i = 0, imax-1
  1128: ||                  if ( abs( xy_Ratio(i,j) ) > 1.0d-10 ) then
  1129: ||                    call MessageNotify( 'M', module_name, 'H2O mass is not conserved, %f.', d = (/ xy_Ratio(i,j) /) )
  1130: ||                  end if
  1131: |+-----           end do
  1132: +------         end do
  1133:             
  1134:             
  1135:               end subroutine CloudSimpleConsChk
  1136:             
  1137:               !--------------------------------------------------------------------------------------
  1138:             
  1139:               subroutine CloudSimpleCalcCloudCover(  &
  1140:                 & xyz_Press, xyz_Temp, xyz_QH2OTot,  & ! (in )
  1141:                 & xyz_CloudCover                     & ! (out)
  1142:                 & )
  1143:             
  1144:                 ! USE statements
  1145:                 !
  1146:             
  1147:                 ! 飽和比湿の算出
  1148:                 ! Evaluate saturation specific humidity
  1149:                 !
  1150:                 use saturate, only: xyz_CalcQVapSat
  1151:             
  1152:                 real(DP), intent(in ) :: xyz_Press     ( 0:imax-1, 1:jmax, 1:kmax )
  1153:                 real(DP), intent(in ) :: xyz_Temp      ( 0:imax-1, 1:jmax, 1:kmax )
  1154:                 real(DP), intent(in ) :: xyz_QH2OTot   ( 0:imax-1, 1:jmax, 1:kmax )
  1155:                 real(DP), intent(out) :: xyz_CloudCover( 0:imax-1, 1:jmax, 1:kmax )
  1156:             
  1157:             
  1158:                 real(DP) :: xyz_RH(0:imax-1, 1:jmax, 1:kmax)
  1159:             
  1160:                 integer :: i
  1161:                 integer :: j
  1162:                 integer :: k
  1163:             
  1164:             
  1165:                 ! 実行文 ; Executable statement
  1166:                 !
  1167:             
  1168:                 ! 初期化確認
  1169:                 ! Initialization check
  1170:                 !
  1171:                 if ( .not. cloud_simple_inited ) then
  1172:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
  1173:                 end if
  1174:             
  1175:             
  1176:                 select case ( IDCloudCoverMethod )
  1177:                 case ( IDCloudCoverMethodConst )
  1178:             
  1179: ++V==== A         xyz_CloudCover = CloudCover
  1180:             
  1181:                 case ( IDCloudCoverMethodRH )
  1182:             
  1183:                   ! see Sundqvist et al. (1989), Del Genio et al. (1996)
  1184: **V---->A         xyz_RH = xyz_QH2OTot / xyz_CalcQVapSat( xyz_Temp, xyz_Press )
  1185: |||               xyz_RH = min( xyz_RH, 1.0_DP )
  1186: |||         
  1187: |||               xyz_CloudCover = &
  1188: |||                 & 1.0_DP - sqrt( ( 1.0_DP - xyz_RH ) / ( 1.0_DP - CloudCoverRHCrtl ) )
  1189: |||         
  1190: |||               xyz_CloudCover = max( xyz_CloudCover, CloudCoverMin )
  1191: **V---- A         xyz_CloudCover = min( xyz_CloudCover, 1.0_DP )
  1192:             
  1193:                 case ( IDCloudCoverMethodRHLin )
  1194:             
  1195: **V---->A         xyz_RH = xyz_QH2OTot / xyz_CalcQVapSat( xyz_Temp, xyz_Press )
  1196: **V----           xyz_RH = min( xyz_RH, 1.0_DP )
  1197:             
  1198:                   if ( CloudCoverRHCrtl < 1.0_DP ) then
  1199:             !!$      xyz_CloudCover = 2.0_DP * xyz_RH - 1.0_DP
  1200: ++V==== A           xyz_CloudCover = &
  1201:                       &   xyz_RH           / ( 1.0_DP - CloudCoverRHCrtl ) &
  1202:                       & - CloudCoverRHCrtl / ( 1.0_DP - CloudCoverRHCrtl )
  1203:                   else
  1204: W------>            do k = 1, kmax
  1205: |*----->              do j = 1, jmax
  1206: ||*---->                do i = 0, imax-1
  1207: |||                       if ( xyz_RH(i,j,k) >= 1.0_DP ) then
  1208: |||                         xyz_CloudCover(i,j,k) = 1.0_DP
  1209: |||                       else
  1210: |||                         xyz_CloudCover(i,j,k) = 0.0_DP
  1211: |||                       end if
  1212: ||*---- A               end do
  1213: |*-----               end do
  1214: W------             end do
  1215:                   end if
  1216:             
  1217: **W---->A         xyz_CloudCover = max( xyz_CloudCover, CloudCoverMin )
  1218: **W---- A         xyz_CloudCover = min( xyz_CloudCover, 1.0_DP )
  1219:             
  1220:                 end select
  1221:             
  1222:             
  1223:               end subroutine CloudSimpleCalcCloudCover
  1224:             
  1225:               !--------------------------------------------------------------------------------------
  1226:             
  1227:               subroutine CloudSimpleDivideWatAndIce(  &
  1228:                 & xyz_Temp,                           & ! (in )
  1229:                 & xyz_QH2OWatAndIce,                  & ! (in )
  1230:                 & xyz_QH2OWat, xyz_QH2OIce            & ! (out)
  1231:                 & )
  1232:             
  1233:                 ! USE statements
  1234:                 !
  1235:             
  1236:                 ! 飽和比湿の算出
  1237:                 ! Evaluate saturation specific humidity
  1238:                 !
  1239:                 use saturate, only : SaturateWatFraction
  1240:             
  1241:                 real(DP), intent(in ) :: xyz_Temp         (0:imax-1, 1:jmax, 1:kmax)
  1242:                 real(DP), intent(in ) :: xyz_QH2OWatAndIce(0:imax-1, 1:jmax, 1:kmax)
  1243:                 real(DP), intent(out) :: xyz_QH2OWat      (0:imax-1, 1:jmax, 1:kmax)
  1244:                 real(DP), intent(out) :: xyz_QH2OIce      (0:imax-1, 1:jmax, 1:kmax)
  1245:             
  1246:             
  1247:                 real(DP) :: xyz_WatFrac(0:imax-1, 1:jmax, 1:kmax)
  1248:             
  1249:                 ! 実行文 ; Executable statement
  1250:                 !
  1251:             
  1252:                 ! 初期化確認
  1253:                 ! Initialization check
  1254:                 !
  1255:                 if ( .not. cloud_simple_inited ) then
  1256:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
  1257:                 end if
  1258:             
  1259:             
  1260:                 call SaturateWatFraction(      &
  1261:                   & xyz_Temp,                  & ! (in )
  1262:                   & xyz_WatFrac                & ! (out)
  1263:                   & )
  1264:             
  1265: **W---->A       xyz_QH2OWat = xyz_QH2OWatAndIce * xyz_WatFrac
  1266: **W---- A       xyz_QH2OIce = xyz_QH2OWatAndIce * ( 1.0_DP - xyz_WatFrac )
  1267:             
  1268:             
  1269:               end subroutine CloudSimpleDivideWatAndIce
  1270:             
  1271:               !--------------------------------------------------------------------------------------
  1272:             
  1273:               subroutine CloudSimpleInit( &
  1274:                 & ArgFlagSnow             &
  1275:                 & )
  1276:             
  1277:                 ! ファイル入出力補助
  1278:                 ! File I/O support
  1279:                 !
  1280:                 use dc_iounit, only: FileOpen
  1281:             
  1282:                 ! NAMELIST ファイル入力に関するユーティリティ
  1283:                 ! Utilities for NAMELIST file input
  1284:                 !
  1285:                 use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid
  1286:             
  1287:                 ! ヒストリデータ出力
  1288:                 ! History data output
  1289:                 !
  1290:                 use gtool_historyauto, only: HistoryAutoAddVariable
  1291:             
  1292:                 ! 飽和比湿の算出
  1293:                 ! Evaluate saturation specific humidity
  1294:                 !
  1295:                 use saturate, only: SaturateInit
  1296:             
  1297:                 ! 大規模凝結 (非対流性凝結)
  1298:                 ! Large scale condensation (non-convective condensation)
  1299:                 !
  1300:                 use lscond, only : LScaleCondInit
  1301:             
  1302:                 ! 宣言文 ; Declaration statements
  1303:                 !
  1304:             
  1305:                 logical, intent(in) :: ArgFlagSnow
  1306:             
  1307:             
  1308:                 character(STRING) :: CloudCoverMethod
  1309:                 character(STRING) :: SnowMethod
  1310:             
  1311:                 integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号.
  1312:                                           ! Unit number for NAMELIST file open
  1313:                 integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT.
  1314:                                           ! IOSTAT of NAMELIST read
  1315:             
  1316:                 ! NAMELIST 変数群
  1317:                 ! NAMELIST group name
  1318:                 !
  1319:                 namelist /cloud_simple_nml/ &
  1320:                   & CloudLifeTime,       &
  1321:                   & CloudWatLifeTime,    &
  1322:                   & CloudIceLifeTime,    &
  1323:                   & CloudCoverMethod,    &
  1324:                   & SnowMethod,          &
  1325:                   & CloudCover,          &
  1326:                   & CloudCoverRHCrtl,    &
  1327:                   & CloudCoverMin,       &
  1328:                   & FlagPRCPPC,          &
  1329:                   & FlagPRCPEvap,        &
  1330:                   & PRCPArea,            &
  1331:                   & PRCPEvapArea
  1332:                       !
  1333:                       ! デフォルト値については初期化手続 "cloud_simple#CloudSimpleInit"
  1334:                       ! のソースコードを参照のこと.
  1335:                       !
  1336:                       ! Refer to source codes in the initialization procedure
  1337:                       ! "cloud_simple#CloudSimpleInit" for the default values.
  1338:                       !
  1339:             
  1340:                 ! 実行文 ; Executable statement
  1341:                 !
  1342:             
  1343:                 if ( cloud_simple_inited ) return
  1344:             
  1345:             
  1346:                 FlagSnow = ArgFlagSnow
  1347:             
  1348:             
  1349:                 ! デフォルト値の設定
  1350:                 ! Default values settings
  1351:                 !
  1352:                 CloudLifeTime       = 3600.0_DP
  1353:                 CloudWatLifeTime    = 3600.0_DP
  1354:                 CloudIceLifeTime    = 3600.0_DP
  1355:             
  1356:                 CloudCoverMethod    = 'Const'
  1357:             !!$    CloudCoverMethod    = 'RH'
  1358:             
  1359:                 SnowMethod          = 'KeyLLTemp'
  1360:             
  1361:                 CloudCover          = 1.0_DP
  1362:             
  1363:                 CloudCoverRHCrtl    = 0.0_DP
  1364:             
  1365:                 CloudCoverMin       = 0.0_DP
  1366:             
  1367:                 FlagPRCPPC          = .true.
  1368:             
  1369:                 FlagPRCPEvap        = .true.
  1370:             !!$    PRCPEvapArea        = 0.5_DP
  1371:                 PRCPArea            = 1.0_DP
  1372:             !!$    PRCPArea            = 0.5_DP
  1373:                 PRCPEvapArea        = 1.0_DP
  1374:             !!$    PRCPEvapArea        = 0.5_DP
  1375:             
  1376:             
  1377:                 ! NAMELIST の読み込み
  1378:                 ! NAMELIST is input
  1379:                 !
  1380:                 if ( trim(namelist_filename) /= '' ) then
  1381:                   call FileOpen( unit_nml, &          ! (out)
  1382:                     & namelist_filename, mode = 'r' ) ! (in)
  1383:             
  1384:                   rewind( unit_nml )
  1385:                   read( unit_nml,                     & ! (in)
  1386:                     & nml = cloud_simple_nml,         & ! (out)
  1387:                     & iostat = iostat_nml )             ! (out)
  1388:                   close( unit_nml )
  1389:             
  1390:                   call NmlutilMsg( iostat_nml, module_name ) ! (in)
  1391:                 end if
  1392:             
  1393:             
  1394:                 select case ( CloudCoverMethod )
  1395:                 case ( 'Const' )
  1396:                   IDCloudCoverMethod = IDCloudCoverMethodConst
  1397:                 case ( 'RH' )
  1398:                   IDCloudCoverMethod = IDCloudCoverMethodRH
  1399:                 case ( 'RHLin' )
  1400:                   IDCloudCoverMethod = IDCloudCoverMethodRHLin
  1401:                 case default
  1402:                   call MessageNotify( 'E', module_name,         &
  1403:                     & 'CloudCoverMethod=<%c> is not supported.', &
  1404:                     & c1 = trim(CloudCoverMethod) )
  1405:                 end select
  1406:             
  1407:             
  1408:                 select case ( SnowMethod )
  1409:                 case ( 'KeyLLTemp' )
  1410:                   IDSnowMethod = IDSnowMethodKeyLLTemp
  1411:                 case ( 'StepPC' )
  1412:                   IDSnowMethod = IDSnowMethodStepPC
  1413:                 case default
  1414:                   call MessageNotify( 'E', module_name,         &
  1415:                     & 'SnowMethod=<%c> is not supported.', &
  1416:                     & c1 = trim(SnowMethod) )
  1417:                 end select
  1418:             
  1419:             
  1420:             
  1421:                 ! Initialization of modules used in this module
  1422:                 !
  1423:             
  1424:                 ! 飽和比湿の算出
  1425:                 ! Evaluate saturation specific humidity
  1426:                 !
  1427:                 call SaturateInit
  1428:             
  1429:                 ! 大規模凝結 (非対流性凝結) (Manabe, 1965)
  1430:                 ! Large scale condensation (non-convective condensation) (Le Treut and Li, 1991)
  1431:                 !
  1432:                 call LScaleCondInit( &
  1433:                   & FlagSnow &
  1434:                   & )
  1435:             
  1436:             
  1437:                 ! ヒストリデータ出力のためのへの変数登録
  1438:                 ! Register of variables for history data output
  1439:                 !
  1440:             !!$    call HistoryAutoAddVariable( 'EffCloudCover', &
  1441:             !!$      & (/ 'lon ', 'lat ', 'time' /), &
  1442:             !!$      & 'effective cloud cover', '1' )
  1443:             
  1444:             
  1445:             
  1446:                 ! 印字 ; Print
  1447:                 !
  1448:                 call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
  1449:                 call MessageNotify( 'M', module_name, 'CloudLifeTime       = %f', d = (/ CloudLifeTime /) )
  1450:                 call MessageNotify( 'M', module_name, 'CloudWatLifeTime    = %f', d = (/ CloudWatLifeTime /) )
  1451:                 call MessageNotify( 'M', module_name, 'CloudIceLifeTime    = %f', d = (/ CloudIceLifeTime /) )
  1452:                 call MessageNotify( 'M', module_name, 'CloudCoverMethod    = %c', c1 = trim(CloudCoverMethod) )
  1453:                 call MessageNotify( 'M', module_name, 'SnowMethod          = %c', c1 = trim(SnowMethod) )
  1454:                 call MessageNotify( 'M', module_name, 'CloudCover          = %f', d = (/ CloudCover /) )
  1455:                 call MessageNotify( 'M', module_name, 'CloudCoverRHCrtl    = %f', d = (/ CloudCoverRHCrtl /) )
  1456:                 call MessageNotify( 'M', module_name, 'CloudCoverMin       = %f', d = (/ CloudCoverMin /) )
  1457:                 call MessageNotify( 'M', module_name, 'FlagPRCPPC          = %b', l = (/ FlagPRCPPC /) )
  1458:                 call MessageNotify( 'M', module_name, 'FlagPRCPEvap        = %b', l = (/ FlagPRCPEvap /) )
  1459:                 call MessageNotify( 'M', module_name, 'PRCPArea            = %f', d = (/ PRCPArea /) )
  1460:                 call MessageNotify( 'M', module_name, 'PRCPEvapArea        = %f', d = (/ PRCPEvapArea /) )
  1461:                 call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
  1462:             
  1463:             
  1464:                 cloud_simple_inited = .true.
  1465:             
  1466:               end subroutine CloudSimpleInit
  1467:             
  1468:               !--------------------------------------------------------------------------------------
  1469:             
  1470:             end module cloud_simple
