Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:50 2016
FILE NAME: cloud_utils.f90
PROGRAM NAME: cloud_utils
DIAGNOSTIC LIST

  LINE  LEVEL( NO.): DIAGNOSTIC MESSAGE

   177  opt  (1593): Loop nest collapsed into one loop.
   177  vec  (   4): Vectorized array expression.
   177  vec  (  29): ADB is used for array.: xyz_transcloudonelayer
   177  vec  (  29): ADB is used for array.: xyz_cloudcover
   181  opt  (1593): Loop nest collapsed into one loop.
   181  vec  (   4): Vectorized array expression.
   181  vec  (  29): ADB is used for array.: xyrr_overlappedcloudtrans
   182  vec  (   3): Unvectorized loop.
   182  vec  (  13): Overhead of loop division is too large.
   183  opt  (1037): Feedback of array elements.
   183  opt  (1593): Loop nest collapsed into one loop.
   183  vec  (   4): Vectorized array expression.
   183  vec  (  29): ADB is used for array.: xyrr_overlappedcloudtrans
   190  vec  (   3): Unvectorized loop.
   190  vec  (  13): Overhead of loop division is too large.
   191  opt  (1036): Potential feedback - use directive if OK.
   191  opt  (1593): Loop nest collapsed into one loop.
   191  vec  (   4): Vectorized array expression.
   191  vec  (  29): ADB is used for array.: xyrr_overlappedcloudtrans
   199  opt  (1593): Loop nest collapsed into one loop.
   199  vec  (   4): Vectorized array expression.
   199  vec  (  29): ADB is used for array.: xyz_transcloudonelayer
   199  vec  (  29): ADB is used for array.: xyz_cloudcover
   249  opt  (  11): Fused array assignments. :line 249 - 251
   249  opt  (1036): Potential feedback - use directive if OK.
   249  opt  (1036): Potential feedback - use directive if OK.
   249  opt  (1036): Potential feedback - use directive if OK.
   249  opt  (1033): Potential multiple store conflict -- use directive if OK.
   249  opt  (1033): Potential multiple store conflict -- use directive if OK.
   249  opt  (1593): Loop nest collapsed into one loop.
   249  vec  (   4): Vectorized array expression.
   249  vec  (  29): ADB is used for array.: xyz_transcloudonelayersorted
   249  vec  (  29): ADB is used for array.: xyz_transcloudonelayer
   249  vec  (  29): ADB is used for array.: xyz_effcloudcoversorted
   249  vec  (  29): ADB is used for array.: xyz_effcloudcover
   249  vec  (  29): ADB is used for array.: xyz_cloudcoversorted
   249  vec  (  29): ADB is used for array.: xyz_cloudcover
   250  opt  (1036): Potential feedback - use directive if OK.
   250  opt  (1036): Potential feedback - use directive if OK.
   250  opt  (1033): Potential multiple store conflict -- use directive if OK.
   250  opt  (1033): Potential multiple store conflict -- use directive if OK.
   254  opt  (1593): Loop nest collapsed into one loop.
   254  vec  (   4): Vectorized array expression.
   254  vec  (  29): ADB is used for array.: xyrr_overlappedcloudtrans
   264  vec  (   1): Vectorized loop.
   264  vec  (  29): ADB is used for array.: xyz_cloudcoversorted
   266  opt  (1036): Potential feedback - use directive if OK.
   266  opt  (1036): Potential feedback - use directive if OK.
   266  opt  (1036): Potential feedback - use directive if OK.
   266  opt  (1036): Potential feedback - use directive if OK.
   266  opt  (1036): Potential feedback - use directive if OK.
   266  opt  (1036): Potential feedback - use directive if OK.
   266  opt  (1036): Potential feedback - use directive if OK.
   266  opt  (1036): Potential feedback - use directive if OK.
   266  vec  (  26): Macro operation Search.
   267  opt  (1084): Branch out of the loop inhibits optimization.
   275  opt  (1036): Potential feedback - use directive if OK.
   275  opt  (1036): Potential feedback - use directive if OK.
   276  opt  (1036): Potential feedback - use directive if OK.
   276  opt  (1036): Potential feedback - use directive if OK.
   279  vec  (   1): Vectorized loop.
   279  vec  (  29): ADB is used for array.: xyz_transcloudonelayersorted
   279  vec  (  29): ADB is used for array.: xyz_effcloudcoversorted
   279  vec  (  29): ADB is used for array.: xyz_cloudcoversorted
   280  opt  (1037): Feedback of array elements.
   280  opt  (1036): Potential feedback - use directive if OK.
   280  opt  (1033): Potential multiple store conflict -- use directive if OK.
   280  opt  (1033): Potential multiple store conflict -- use directive if OK.
   280  opt  (1037): Feedback of array elements.
   280  opt  (1036): Potential feedback - use directive if OK.
   280  opt  (1033): Potential multiple store conflict -- use directive if OK.
   282  opt  (1037): Feedback of array elements.
   282  opt  (1036): Potential feedback - use directive if OK.
   282  opt  (1033): Potential multiple store conflict -- use directive if OK.
   282  opt  (1036): Potential feedback - use directive if OK.
   282  opt  (1033): Potential multiple store conflict -- use directive if OK.
   284  opt  (1033): Potential multiple store conflict -- use directive if OK.
   289  opt  (1036): Potential feedback - use directive if OK.
   319  opt  (1593): Loop nest collapsed into one loop.
   319  vec  (   4): Vectorized array expression.
   319  vec  (  29): ADB is used for array.: xyrr_overlappedcloudtrans
   320  vec  (   3): Unvectorized loop.
   320  vec  (  13): Overhead of loop division is too large.
   321  opt  (1019): Feedback of scalar value from one loop pass to another.
   321  opt  (1593): Loop nest collapsed into one loop.
   321  vec  (   4): Vectorized array expression.
   321  vec  (  29): ADB is used for array.: xyrr_overlappedcloudtrans
   321  vec  (  29): ADB is used for array.: xyz_transcloudonelayersorted
   321  vec  (  29): ADB is used for array.: xyz_effcloudcoversorted
   326  opt  (1593): Loop nest collapsed into one loop.
   326  vec  (   4): Vectorized array expression.
   326  vec  (  29): ADB is used for array.: xyrr_overlappedcloudtrans
   330  opt  (1062): Too many data dependency problems.
   335  vec  (   3): Unvectorized loop.
   335  vec  (  13): Overhead of loop division is too large.
   336  opt  (1036): Potential feedback - use directive if OK.
   336  opt  (1593): Loop nest collapsed into one loop.
   336  vec  (   4): Vectorized array expression.
   336  vec  (  29): ADB is used for array.: xyrr_overlappedcloudtrans
   378  opt  (1593): Loop nest collapsed into one loop.
   378  vec  (   4): Vectorized array expression.
   378  vec  (  29): ADB is used for array.: xyz_delcloudoptdep
   378  vec  (  29): ADB is used for array.: xyz_cloudcover
   410  opt  (1593): Loop nest collapsed into one loop.
   410  vec  (   4): Vectorized array expression.
   410  vec  (  29): ADB is used for array.: xyz_delcloudoptdep
   410  vec  (  29): ADB is used for array.: xyz_cloudcover
   586  vec  (   3): Unvectorized loop.
   596  vec  (  10): Vectorization obstructive procedure reference.:messagenotifyc
   599  vec  (  10): Vectorization obstructive procedure reference.:cloudutilsprcpevap1gridcore
   614  vec  (  10): Vectorization obstructive procedure reference.:messagenotifyc
   621  warn (  82): Name "qh2ovapsat" is not used.
   785  vec  (   3): Unvectorized loop.
   790  vec  (  10): Vectorization obstructive procedure reference.:calcqvapsatonliq
   791  vec  (  10): Vectorization obstructive procedure reference.:calcdqvapsatdtemponliq
   794  vec  (  10): Vectorization obstructive procedure reference.:calcqvapsatonsol
   795  vec  (  10): Vectorization obstructive procedure reference.:calcdqvapsatdtemponsol
   797  opt  (1017): Subroutine call prevents optimization.
   797  vec  (  10): Vectorization obstructive procedure reference.:messagenotifyc
   837  warn (  82): Name "qh2ovapsata" is not used.
   837  warn (  82): Name "prcpfallvelfactor" is not used.
  1065  opt  (1593): Loop nest collapsed into one loop.
  1065  vec  (   1): Vectorized loop.
  1065  vec  (  29): ADB is used for array.: xyr_press
  1069  opt  (1593): Loop nest collapsed into one loop.
  1069  vec  (   4): Vectorized array expression.
  1070  vec  (   3): Unvectorized loop.
  1070  vec  (  13): Overhead of loop division is too large.
  1071  opt  (  11): Fused array assignments. :line 1071 - 1074
  1071  opt  (1593): Loop nest collapsed into one loop.
  1071  vec  (   4): Vectorized array expression.
  1071  vec  (  29): ADB is used for array.: xy_sum
  1071  vec  (  29): ADB is used for array.: xy_val
  1071  vec  (  29): ADB is used for array.: xyz_qh2osolb
  1071  vec  (  29): ADB is used for array.: xyz_qh2ovapb
  1071  vec  (  29): ADB is used for array.: xyz_tempb
  1077  opt  (  11): Fused array assignments. :line 1077 - 1079
  1077  opt  (1593): Loop nest collapsed into one loop.
  1077  vec  (   4): Vectorized array expression.
  1077  vec  (  29): ADB is used for array.: xy_sum
  1080  vec  (   3): Unvectorized loop.
  1080  vec  (  13): Overhead of loop division is too large.
  1081  opt  (  11): Fused array assignments. :line 1081 - 1084
  1081  opt  (1593): Loop nest collapsed into one loop.
  1081  vec  (   4): Vectorized array expression.
  1081  vec  (  29): ADB is used for array.: xy_sum
  1081  vec  (  29): ADB is used for array.: xy_val
  1081  vec  (  29): ADB is used for array.: xyz_qh2osol
  1081  vec  (  29): ADB is used for array.: xyz_qh2ovap
  1081  vec  (  29): ADB is used for array.: xyz_temp
  1087  opt  (  11): Fused array assignments. :line 1087 - 1090
  1087  opt  (1593): Loop nest collapsed into one loop.
  1087  vec  (   4): Vectorized array expression.
  1087  vec  (  29): ADB is used for array.: xy_sum
  1087  vec  (  29): ADB is used for array.: xy_snow
  1092  vec  (   3): Unvectorized loop.
  1094  opt  (1017): Subroutine call prevents optimization.
  1094  vec  (   9): Vectorization obstructive statement.
  1094  vec  (  10): Vectorization obstructive procedure reference.:messagenotifyc
  1102  opt  (1593): Loop nest collapsed into one loop.
  1102  vec  (   4): Vectorized array expression.
  1103  vec  (   3): Unvectorized loop.
  1103  vec  (  13): Overhead of loop division is too large.
  1104  opt  (  11): Fused array assignments. :line 1104 - 1105
  1104  opt  (1593): Loop nest collapsed into one loop.
  1104  vec  (   4): Vectorized array expression.
  1104  vec  (  29): ADB is used for array.: xy_sum
  1104  vec  (  29): ADB is used for array.: xy_val
  1104  vec  (  29): ADB is used for array.: xyz_qh2osolb
  1104  vec  (  29): ADB is used for array.: xyz_qh2oliqb
  1104  vec  (  29): ADB is used for array.: xyz_qh2ovapb
  1108  opt  (  11): Fused array assignments. :line 1108 - 1110
  1108  opt  (1593): Loop nest collapsed into one loop.
  1108  vec  (   4): Vectorized array expression.
  1108  vec  (  29): ADB is used for array.: xy_sum
  1111  vec  (   3): Unvectorized loop.
  1111  vec  (  13): Overhead of loop division is too large.
  1112  opt  (  11): Fused array assignments. :line 1112 - 1113
  1112  opt  (1593): Loop nest collapsed into one loop.
  1112  vec  (   4): Vectorized array expression.
  1112  vec  (  29): ADB is used for array.: xy_sum
  1112  vec  (  29): ADB is used for array.: xyz_qh2osol
  1112  vec  (  29): ADB is used for array.: xyz_qh2oliq
  1112  vec  (  29): ADB is used for array.: xyz_qh2ovap
  1115  opt  (  11): Fused array assignments. :line 1115 - 1117
  1115  opt  (1593): Loop nest collapsed into one loop.
  1115  vec  (   4): Vectorized array expression.
  1115  vec  (  29): ADB is used for array.: xy_sum
  1115  vec  (  29): ADB is used for array.: xy_snow
  1115  vec  (  29): ADB is used for array.: xy_rain
  1119  vec  (   3): Unvectorized loop.
  1121  opt  (1017): Subroutine call prevents optimization.
  1121  vec  (   9): Vectorization obstructive statement.
  1121  vec  (  10): Vectorization obstructive procedure reference.:messagenotifyc
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:50 2016
FILE NAME: cloud_utils.f90
PROGRAM NAME: cloud_utils
TRANSFORMATION LIST

  LINE                   FORTRAN STATEMENT

     1  != 雲関系ルーチン
     2  !
     3  != Cloud-related routines
     4  !
     5  ! Authors::   Yoshiyuki O. Takahashi
     6  ! Version::   $Id: cloud_utils.f90,v 1.7 2015/02/11 11:55:19 yot Exp $
     7  ! Tag Name::  $Name:  $
     8  ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9  ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10  !
    11  module cloud_utils
    12    !
    13    != 雲関系ルーチン
    14    !
    15    != Cloud-related routines
    16    !
    17    ! <b>Note that Japanese and English are described in parallel.</b>
    18    !
    19    ! 雲の分布を設定.
    20    !
    21    ! In this module, the amount of cloud or cloud optical depth are set.
    22    ! This module is under development and is still a preliminary version.
    23    !
    24    !== Procedures List
    25    !
    26  !!$  ! RadiationFluxDennouAGCM :: 放射フラックスの計算
    27  !!$  ! ------------            :: ------------
    28  !!$  ! RadiationFluxDennouAGCM :: Calculate radiation flux
    29    !
    30    !== NAMELIST
    31    !
    32    ! NAMELIST#cloud_utils_nml
    33    !
    34  
    35    ! モジュール引用 ; USE statements
    36  
    37    !
    38    ! Kind type parameter
    39    !
    40    use dc_types, only: DP, &      ! Double precision.
    41      &                 STRING, &  ! Strings.
    42      &                 TOKEN      ! Keywords.
    43  
    44    ! メッセージ出力
    45    ! Message output
    46    !
    47    use dc_message, only: MessageNotify
    48  
    49    ! 格子点設定
    50    ! Grid points settings
    51    !
    52    use gridset, only: imax, & ! 経度格子点数.
    53                               ! Number of grid points in longitude
    54      &                jmax, & ! 緯度格子点数.
    55                               ! Number of grid points in latitude
    56      &                kmax    ! 鉛直層数.
    57                               ! Number of vertical level
    58  
    59    implicit none
    60  
    61    private
    62  
    63  
    64    ! 公開手続き
    65    ! Public procedure
    66    !
    67    public :: CloudUtilsCalcOverlapCloudTrans
    68    public :: CloudUtilsSmearCloudOptDep
    69    public :: CloudUtilsLocalizeCloud
    70    public :: CloudUtilsPRCPStepPC1Grid
    71    public :: CloudUtilsPRCPEvap1Grid
    72    public :: CloudUtilConsChk
    73    public :: CloudUtilsInit
    74  
    75  
    76    ! 公開変数
    77    ! Public variables
    78    !
    79  
    80  
    81    ! 非公開変数
    82    ! Private variables
    83    !
    84    logical , save        :: FlagSnow
    85                             ! A flag for snow
    86  
    87    real(DP), save :: CCNMixRatPerUnitMass
    88    !                            number of CCN per atmospheric mass (kg-1)
    89    !                            CCN : Cloud Condensation Nuclei
    90  
    91    integer , save        :: IDCloudOverlapType
    92    integer , parameter   :: IDCloudOverlapTypeRandom     = 1
    93    integer , parameter   :: IDCloudOverlapTypeMaxOverlap = 2
    94  
    95    logical, save :: cloud_utils_inited = .false.
    96                                ! 初期設定フラグ.
    97                                ! Initialization flag
    98  
    99    character(*), parameter:: module_name = 'cloud_utils'
   100                                ! モジュールの名称.
   101                                ! Module name
   102    character(*), parameter:: version = &
   103      & '$Name:  $' // &
   104      & '$Id: cloud_utils.f90,v 1.7 2015/02/11 11:55:19 yot Exp $'
   105                                ! モジュールのバージョン
   106                                ! Module version
   107  
   108    !--------------------------------------------------------------------------------------
   109  
   110  contains
   111  
   112    !--------------------------------------------------------------------------------------
   113  
   114    subroutine CloudUtilsCalcOverlapCloudTrans(  &
   115      & xyz_TransCloudOneLayer, xyz_CloudCover,  & ! (in)
   116      & xyrr_OverlappedCloudTrans                & ! (out)
   117      & )
   118  
   119      ! USE statements
   120      !
   121  
   122      ! ヒストリデータ出力
   123      ! History data output
   124      !
   125      use gtool_historyauto, only: HistoryAutoPut
   126  
   127      ! 時刻管理
   128      ! Time control
   129      !
   130      use timeset, only: &
   131        & TimeN, &              ! ステップ $ t $ の時刻.
   132                                ! Time of step $ t $.
   133        & EndTime, &            ! 計算終了時刻.
   134                                ! End time of calculation
   135        & TimesetClockStart, TimesetClockStop
   136  
   137  !!$    use sort, only : SortQuick
   138  
   139      real(DP), intent(in ) :: xyz_TransCloudOneLayer   (0:imax-1, 1:jmax, 1:kmax)
   140      real(DP), intent(in ) :: xyz_CloudCover           (0:imax-1, 1:jmax, 1:kmax)
   141      real(DP), intent(out) :: xyrr_OverlappedCloudTrans(0:imax-1, 1:jmax, 0:kmax, 0:kmax)
   142  
   143  
   144      real(DP) :: xyz_EffCloudCover           (0:imax-1, 1:jmax, 1:kmax)
   145      real(DP) :: xyz_CloudCoverSorted        (0:imax-1, 1:jmax, 1:kmax)
   146      real(DP) :: xyz_EffCloudCoverSorted     (0:imax-1, 1:jmax, 1:kmax)
   147      real(DP) :: xyz_TransCloudOneLayerSorted(0:imax-1, 1:jmax, 1:kmax)
   148      real(DP) :: CloudCoverSortedCur
   149      real(DP) :: EffCloudCoverSortedCur
   150      real(DP) :: TransCloudOneLayerSortedCur
   151      integer  :: KInsPos
   152      integer  :: i
   153      integer  :: j
   154      integer  :: k
   155      integer  :: kk
   156      integer  :: kkk
   157  
   158  
   159  
   160      ! 実行文 ; Executable statement
   161      !
   162  
   163      ! 初期化確認
   164      ! Initialization check
   165      !
   166      if ( .not. cloud_utils_inited ) then
   167        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   168      end if
   169  
   170  
   171      ! Cloud optical depth
   172      !
   173  
   174      select case ( IDCloudOverlapType )
   175      case ( IDCloudOverlapTypeRandom )
   176  
   177        xyz_EffCloudCover = xyz_CloudCover * ( 1.0_DP - xyz_TransCloudOneLayer )
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t479 = 1, kmax*jmax*imax                                       
     .           xyz_effcloudcover(t479-1,1,1) = xyz_cloudcover(t479-1,1,1)*(   
     .       1      1.00000000000000e+000 - xyz_transcloudonelayer(t479-1,1,1)) 
     .        enddo                                                             
   178  
   179        do k = 0, kmax
   180          kk = k
   181          xyrr_OverlappedCloudTrans(:,:,k,kk) = 1.0_DP
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t494 = 1, jmax*imax                                            
     .           xyrr_overlappedcloudtrans(t494-1,1,k,kk) =                     
     .       1      1.00000000000000e+000                                       
     .        enddo                                                             
   182          do kk = k+1, kmax
   183            xyrr_OverlappedCloudTrans(:,:,k,kk) =        &
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xyrr_overlappedcloudtrans)                                 
     .        do t500 = 1, jmax*imax                                            
     .           xyrr_overlappedcloudtrans(t500-1,1,k,kk) =                     
     .       1      xyrr_overlappedcloudtrans(t500-1,1,k,kk-1)*(                
     .       2      1.00000000000000e+000 - xyz_effcloudcover(t500-1,1,kk))     
     .        enddo                                                             
   184              & xyrr_OverlappedCloudTrans(:,:,k,kk-1)    &
   185              & * ( 1.0_DP - xyz_EffCloudCover(:,:,kk) )
   186          end do
   187        end do
   188  
   189        do k = 0, kmax
   190          do kk = 0, k-1
   191            xyrr_OverlappedCloudTrans(:,:,k,kk) = xyrr_OverlappedCloudTrans(:,:,kk,k)
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xyrr_overlappedcloudtrans)                                 
     .        do t510 = 1, jmax*imax                                            
     .           xyrr_overlappedcloudtrans(t510-1,1,k,kk) =                     
     .       1      xyrr_overlappedcloudtrans(t510-1,1,kk,k)                    
     .        enddo                                                             
   192          end do
   193        end do
   194  
   195      case ( IDCloudOverlapTypeMaxOverlap )
   196  
   197        ! see Chou et al. (2001)
   198  
   199        xyz_EffCloudCover = xyz_CloudCover * ( 1.0_DP - xyz_TransCloudOneLayer )
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t400 = 1, kmax*jmax*imax                                       
     .           xyz_effcloudcover(t400-1,1,1) = xyz_cloudcover(t400-1,1,1)*(   
     .       1      1.00000000000000e+000 - xyz_transcloudonelayer(t400-1,1,1)) 
     .        enddo                                                             
   200  
   201  
   202        ! Original method (computationally expensive, probably)
   203        !
   204  !!$        do k = 0, kmax
   205  !!$          kk = k
   206  !!$          xyrr_OverlappedCloudTrans(:,:,k,kk) = 1.0_DP
   207  !!$          do kk = k+1, kmax
   208  !!$
   209  !!$            xyz_CloudCoverSorted         = xyz_CloudCover
   210  !!$            xyz_EffCloudCoverSorted      = xyz_EffCloudCover
   211  !!$            xyz_TransCloudOneLayerSorted = xyz_TransCloudOneLayer
   212  !!$
   213  !!$            call SortQuick( imax, jmax, kk-k,             &
   214  !!$              & xyz_CloudCoverSorted        (:,:,k+1:kk), &
   215  !!$              & xyz_EffCloudCoverSorted     (:,:,k+1:kk), &
   216  !!$              & xyz_TransCloudOneLayerSorted(:,:,k+1:kk)  &
   217  !!$              & )
   218  !!$
   219  !!$            xyrr_OverlappedCloudTrans(:,:,k,kk) = 0.0_DP
   220  !!$            do kkk = k+1, kk
   221  !!$              xyrr_OverlappedCloudTrans(:,:,k,kk) =         &
   222  !!$                & xyz_EffCloudCoverSorted(:,:,kkk)          &
   223  !!$                & + xyrr_OverlappedCloudTrans(:,:,k,kk)     &
   224  !!$                &   * xyz_TransCloudOneLayerSorted(:,:,kkk)
   225  !!$            end do
   226  !!$            xyrr_OverlappedCloudTrans(:,:,k,kk) = &
   227  !!$              & 1.0_DP - xyrr_OverlappedCloudTrans(:,:,k,kk)
   228  !!$
   229  !!$          end do
   230  !!$        end do
   231  
   232  
   233        ! Economical method (probably)
   234        !
   235        do k = 0, kmax
   236  
   237  !!$          do kkk = 1, kmax
   238  !!$              xyz_CloudCoverSorted(:,:,kkk) = real( kmax-kkk ) / real(kmax)
   239  !!$!              xyz_CloudCoverSorted(:,:,kkk) = abs( 0.55d0 - real( kmax-kkk ) / real(kmax) )
   240  !!$          end do
   241  !!$          ! debug output
   242  !!$          if ( k == 0 ) then
   243  !!$            kk = kmax
   244  !!$            do kkk = k+1, kk
   245  !!$              write( 6, * ) kkk, xyz_CloudCoverSorted(0,jmax/2+1,kkk)
   246  !!$            end do
   247  !!$          end if
   248  
   249          xyz_CloudCoverSorted         = xyz_CloudCover
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xyz_cloudcover,xyz_cloudcoversorted,xyz_effcloudcover,xyz_e
     .       1   ffcloudcoversorted,xyz_transcloudonelayer,xyz_transcloudonelaye
     .       2   rsorted)                                                       
     .        do t415 = 1, xyz_cloudcoversorted.DSC.U3*(                        
     .       1   xyz_cloudcoversorted.DSC.U2*xyz_cloudcoversorted.DSC.U1 +      
     .       2   xyz_cloudcoversorted.DSC.U2)                                   
     .           xyz_cloudcoversorted(t415-1,1,1) = xyz_cloudcover(t415-1,1,1)  
     .           xyz_effcloudcoversorted(t415-1,1,1) = xyz_effcloudcover(t415-1,
     .       1      1,1)                                                        
     .           xyz_transcloudonelayersorted(t415-1,1,1) =                     
     .       1      xyz_transcloudonelayer(t415-1,1,1)                          
     .        enddo                                                             
   250          xyz_EffCloudCoverSorted      = xyz_EffCloudCover
   251          xyz_TransCloudOneLayerSorted = xyz_TransCloudOneLayer
   252  
   253          kk = k
   254          xyrr_OverlappedCloudTrans(:,:,k,kk) = 1.0_DP
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t439 = 1, jmax*imax                                            
     .           xyrr_overlappedcloudtrans(t439-1,1,k,kk) =                     
     .       1      1.00000000000000e+000                                       
     .        enddo                                                             
   255          do kk = k+1, kmax
   256  
   257  
   258            do j = 1, jmax
   259              do i = 0, imax-1
   260  
   261                ! xyz_CloudCoverSorted(i,j,kk) is inserved in an appropriate position.
   262                !
   263                KInsPos = kk
   264                loop : do kkk = k+1, kk-1
     .  !cdir on_adb(xyz_cloudcoversorted)                                      
     .        do kkk = k + 1, kk - 1                                            
   265  
   266                  if ( xyz_CloudCoverSorted(i,j,kk) < xyz_CloudCoverSorted(i,j,kkk) ) then
   267                    KInsPos = kkk
   268                    exit loop
   269                  end if
   270  
   271                end do loop
   272  
   273                ! values are saved
   274                CloudCoverSortedCur         = xyz_CloudCoverSorted        (i,j,kk)
   275                EffCloudCoverSortedCur      = xyz_EffCloudCoverSorted     (i,j,kk)
   276                TransCloudOneLayerSortedCur = xyz_TransCloudOneLayerSorted(i,j,kk)
   277  
   278                ! values are shifted upward to empty an array at insert position
   279                do kkk = kk, KInsPos+1, -1
     .  !cdir    nodep                                                          
     .  !cdir on_adb(xyz_cloudcoversorted,xyz_effcloudcoversorted,xyz_transcloud
     .       1   onelayersorted)                                                
     .        do kkk = kk, 1 + kinspos, -1                                      
   280                  xyz_CloudCoverSorted        (i,j,kkk) = &
   281                    & xyz_CloudCoverSorted        (i,j,kkk-1)
   282                  xyz_EffCloudCoverSorted     (i,j,kkk) = &
   283                    & xyz_EffCloudCoverSorted     (i,j,kkk-1)
   284                  xyz_TransCloudOneLayerSorted(i,j,kkk) = &
   285                    & xyz_TransCloudOneLayerSorted(i,j,kkk-1)
   286                end do
   287                kkk = KInsPos
   288                xyz_CloudCoverSorted        (i,j,kkk) = CloudCoverSortedCur
   289                xyz_EffCloudCoverSorted     (i,j,kkk) = EffCloudCoverSortedCur
   290                xyz_TransCloudOneLayerSorted(i,j,kkk) = TransCloudOneLayerSortedCur
   291  
   292              end do
   293            end do
   294  
   295  
   296  !!$            xyz_CloudCoverSorted         = xyz_CloudCover
   297  !!$            do kkk = 1, kmax
   298  !!$              xyz_CloudCoverSorted(:,:,kkk) = real( kmax-kkk ) / real(kmax)
   299  !!$            end do
   300  !!$            xyz_EffCloudCoverSorted      = xyz_EffCloudCover
   301  !!$            xyz_TransCloudOneLayerSorted = xyz_TransCloudOneLayer
   302  !!$
   303  !!$            call SortQuick( imax, jmax, kk-k,             &
   304  !!$              & xyz_CloudCoverSorted        (:,:,k+1:kk), &
   305  !!$              & xyz_EffCloudCoverSorted     (:,:,k+1:kk), &
   306  !!$              & xyz_TransCloudOneLayerSorted(:,:,k+1:kk)  &
   307  !!$              & )
   308  
   309  
   310  !!$            ! debug output
   311  !!$            if ( ( k == 0 ) .and. ( kk == kmax-2 ) ) then
   312  !!$              do kkk = k+1, kk
   313  !!$                write( 6, * ) kkk, xyz_CloudCoverSorted(0,jmax/2+1,kkk)
   314  !!$              end do
   315  !!$              write( 6, * ) '-----'
   316  !!$            end if
   317  
   318  
   319            xyrr_OverlappedCloudTrans(:,:,k,kk) = 0.0_DP
     .  !cdir    nodep                                                          
     .  !cdir noassume                                                          
     .        do t445 = 1, jmax*imax                                            
     .           xyrr_overlappedcloudtrans(t445-1,1,k,kk) =                     
     .       1      0.0000000000000000e+000                                     
     .        enddo                                                             
   320            do kkk = k+1, kk
   321              xyrr_OverlappedCloudTrans(:,:,k,kk) =         &
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xyz_effcloudcoversorted,xyz_transcloudonelayersorted,xyrr_o
     .       1   verlappedcloudtrans)                                           
     .        do t451 = 1, xyz_effcloudcoversorted.DSC.U2*                      
     .       1   xyz_effcloudcoversorted.DSC.U1 + xyz_effcloudcoversorted.DSC.U2
     .           xyrr_overlappedcloudtrans(t451-1,1,k,kk) =                     
     .       1      xyz_effcloudcoversorted(t451-1,1,kkk) +                     
     .       2      xyrr_overlappedcloudtrans(t451-1,1,k,kk)*                   
     .       3      xyz_transcloudonelayersorted(t451-1,1,kkk)                  
     .        enddo                                                             
   322                & xyz_EffCloudCoverSorted(:,:,kkk)          &
   323                & + xyrr_OverlappedCloudTrans(:,:,k,kk)     &
   324                &   * xyz_TransCloudOneLayerSorted(:,:,kkk)
   325            end do
   326            xyrr_OverlappedCloudTrans(:,:,k,kk) = &
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xyrr_overlappedcloudtrans)                                 
     .        do t463 = 1, jmax*imax                                            
     .           xyrr_overlappedcloudtrans(t463-1,1,k,kk) =                     
     .       1      1.00000000000000e+000 - xyrr_overlappedcloudtrans(t463-1,1,k
     .       2      ,kk)                                                        
     .        enddo                                                             
   327              & 1.0_DP - xyrr_OverlappedCloudTrans(:,:,k,kk)
   328  
   329          end do
   330        end do
   331  
   332  
   333  
   334        do k = 0, kmax
   335          do kk = 0, k-1
   336            xyrr_OverlappedCloudTrans(:,:,k,kk) = xyrr_OverlappedCloudTrans(:,:,kk,k)
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xyrr_overlappedcloudtrans)                                 
     .        do t471 = 1, jmax*imax                                            
     .           xyrr_overlappedcloudtrans(t471-1,1,k,kk) =                     
     .       1      xyrr_overlappedcloudtrans(t471-1,1,kk,k)                    
     .        enddo                                                             
   337          end do
   338        end do
   339  
   340  
   341      end select
   342  
   343      ! Output effective cloud cover
   344      !
   345  !!$    call HistoryAutoPut( TimeN, 'EffCloudCover', &
   346  !!$      & 1.0_DP - xyrr_OverlappedCloudTrans(:,:,0,kmax) )
   347  
   348  
   349    end subroutine CloudUtilsCalcOverlapCloudTrans
   350  
   351    !--------------------------------------------------------------------------------------
   352  
   353    subroutine CloudUtilsSmearCloudOptDep(  &
   354      & xyz_CloudCover,                     & ! (in   )
   355      & xyz_DelCloudOptDep                  & ! (inout)
   356      & )
   357  
   358      ! USE statements
   359      !
   360  
   361      real(DP), intent(in   ) :: xyz_CloudCover    (0:imax-1, 1:jmax, 1:kmax)
   362      real(DP), intent(inout) :: xyz_DelCloudOptDep(0:imax-1, 1:jmax, 1:kmax)
   363  
   364  
   365      ! 実行文 ; Executable statement
   366      !
   367  
   368      ! 初期化確認
   369      ! Initialization check
   370      !
   371      if ( .not. cloud_utils_inited ) then
   372        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   373      end if
   374  
   375  
   376      ! Cloud optical depth is scaled by the way of Kiehl et al. (1994).
   377  
   378      xyz_DelCloudOptDep = xyz_DelCloudOptDep * xyz_CloudCover**1.5_DP
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t41 = 1, kmax*jmax*imax                                        
     .           xyz_delcloudoptdep(t41-1,1,1) = xyz_delcloudoptdep(t41-1,1,1)* 
     .       1      xyz_cloudcover(t41-1,1,1)**1.50000000000000e+000            
     .        enddo                                                             
   379  
   380  
   381    end subroutine CloudUtilsSmearCloudOptDep
   382  
   383    !--------------------------------------------------------------------------------------
   384  
   385    subroutine CloudUtilsLocalizeCloud(  &
   386      & xyz_CloudCover,                  & ! (in   )
   387      & xyz_DelCloudOptDep               & ! (inout)
   388      & )
   389  
   390      ! USE statements
   391      !
   392  
   393      real(DP), intent(in   ) :: xyz_CloudCover    (0:imax-1, 1:jmax, 1:kmax)
   394      real(DP), intent(inout) :: xyz_DelCloudOptDep(0:imax-1, 1:jmax, 1:kmax)
   395  
   396  
   397      ! 実行文 ; Executable statement
   398      !
   399  
   400      ! 初期化確認
   401      ! Initialization check
   402      !
   403      if ( .not. cloud_utils_inited ) then
   404        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   405      end if
   406  
   407  
   408      ! Cloud optical depth is scaled by considering cloud cover less than 1.
   409  
   410      xyz_DelCloudOptDep = xyz_DelCloudOptDep / max( xyz_CloudCover, 1.0d-3 )
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t41 = 1, kmax*jmax*imax                                        
     .           xyz_delcloudoptdep(t41-1,1,1) = xyz_delcloudoptdep(t41-1,1,1)/ 
     .       1      max(xyz_cloudcover(t41-1,1,1),1.00000000000000e-003)        
     .        enddo                                                             
   411  
   412  
   413    end subroutine CloudUtilsLocalizeCloud
   414  
   415    !--------------------------------------------------------------------------------------
   416  
   417    subroutine CloudUtilsPRCPStepPC1Grid(  &
   418      & PressLI, PressUI,                & ! (in   )
   419      & Temp,                            & ! (inout)
   420      & SurfRainFlux, SurfSnowFlux       & ! (out  )
   421      & )
   422  
   423      ! 時刻管理
   424      ! Time control
   425      !
   426      use timeset, only: &
   427        & DelTime            ! $ \Delta t $ [s]
   428  
   429      ! 物理定数設定
   430      ! Physical constants settings
   431      !
   432      use constants, only:  &
   433        & CpDry,            &
   434                                ! $ C_p $ [J kg-1 K-1].
   435                                ! 乾燥大気の定圧比熱.
   436                                ! Specific heat of air at constant pressure
   437        & Grav,             &
   438                                ! $ g $ [m s-2].
   439                                ! 重力加速度.
   440                                ! Gravitational acceleration
   441        & LatentHeatFusion
   442                                ! $ L $ [J kg-1] .
   443                                ! 融解の潜熱.
   444                                ! Latent heat of fusion
   445  
   446      ! 雪と海氷の定数の設定
   447      ! Setting constants of snow and sea ice
   448      !
   449      use constants_snowseaice, only: TempCondWater
   450  
   451  
   452  
   453      real(DP), intent(in   ) :: PressLI
   454      real(DP), intent(in   ) :: PressUI
   455      real(DP), intent(inout) :: Temp
   456      real(DP), intent(inout) :: SurfRainFlux
   457      real(DP), intent(inout) :: SurfSnowFlux
   458  
   459  
   460      ! 作業変数
   461      ! Work variables
   462      !
   463      real(DP) :: DelMass
   464      real(DP) :: MassMaxFreezeRate
   465      real(DP) :: MassFreezeRate
   466      real(DP) :: MassMaxMeltRate
   467      real(DP) :: MassMeltRate
   468  
   469  
   470      ! 初期化確認
   471      ! Initialization check
   472      !
   473      if ( .not. cloud_utils_inited ) then
   474        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   475      end if
   476  
   477  
   478      DelMass = ( PressLI - PressUI ) / Grav
   479  
   480      ! Freezing and melting switching at temperature of TempCondWater
   481  
   482      MassMaxFreezeRate =                    &
   483        &   CpDry * ( TempCondWater - Temp ) &
   484        & * DelMass                          &
   485        & / LatentHeatFusion                 &
   486        & / ( 2.0_DP * DelTime )
   487      if ( MassMaxFreezeRate >= 0.0_DP ) then
   488        ! freezing
   489        if ( SurfRainFlux >= MassMaxFreezeRate ) then
   490          MassFreezeRate = MassMaxFreezeRate
   491        else
   492          MassFreezeRate = SurfRainFlux
   493        end if
   494        SurfRainFlux = SurfRainFlux - MassFreezeRate
   495        SurfSnowFlux = SurfSnowFlux + MassFreezeRate
   496        Temp = Temp                                &
   497          & + LatentHeatFusion * MassFreezeRate * 2.0_DP * DelTime &
   498          &   / ( CpDry * DelMass )
   499      else
   500        ! melting
   501        MassMaxMeltRate = - MassMaxFreezeRate
   502        if ( SurfSnowFlux >= MassMaxMeltRate ) then
   503          MassMeltRate = MassMaxMeltRate
   504        else
   505          MassMeltRate = SurfSnowFlux
   506        end if
   507        SurfRainFlux = SurfRainFlux + MassMeltRate
   508        SurfSnowFlux = SurfSnowFlux - MassMeltRate
   509        Temp = Temp                              &
   510          & - LatentHeatFusion * MassMeltRate * 2.0_DP * DelTime &
   511          &   / ( CpDry * DelMass )
   512      end if
   513  
   514  
   515    end subroutine CloudUtilsPRCPStepPC1Grid
   516  
   517    !----------------------------------------------------------------------------
   518  
   519    subroutine CloudUtilsPRCPEvap1Grid(           &
   520      & Press, PressLI, PressUI,            & ! (in)
   521      & PRCPArea, PRCPEvapArea,             & ! (in)
   522      & Temp, QH2OVap,                      & ! (inout)
   523      & SurfRainFlux, SurfSnowFlux          & ! (inout)
   524      & )
   525  
   526      ! USE statements
   527      !
   528  
   529      ! 時刻管理
   530      ! Time control
   531      !
   532      use timeset, only: &
   533        & DelTime            ! $ \Delta t $ [s]
   534  
   535      ! 物理定数設定
   536      ! Physical constants settings
   537      !
   538      use constants, only: &
   539        & Grav
   540                                ! $ g $ [m s-2].
   541                                ! 重力加速度.
   542                                ! Gravitational acceleration
   543  
   544      real(DP), intent(in   ) :: Press
   545      real(DP), intent(in   ) :: PressLI
   546      real(DP), intent(in   ) :: PressUI
   547      real(DP), intent(in   ) :: PRCPArea
   548      real(DP), intent(in   ) :: PRCPEvapArea
   549      real(DP), intent(inout) :: Temp
   550      real(DP), intent(inout) :: QH2OVap
   551      real(DP), intent(inout) :: SurfRainFlux
   552      real(DP), intent(inout) :: SurfSnowFlux
   553  
   554  
   555      ! Local variables
   556      !
   557      real(DP) :: DelTemp
   558      real(DP) :: DelQH2OVap
   559  
   560      real(DP) :: DelMass
   561  
   562      real(DP) :: QH2OVapSat
   563      real(DP) :: PRCPFlux
   564      real(DP) :: DelPRCPFlux
   565  !!$    real(DP) :: DelQH2OVap
   566      character(STRING) :: CharPhase
   567  
   568  
   569      integer :: l
   570  
   571  
   572      ! 実行文 ; Executable statement
   573      !
   574  
   575      ! 初期化確認
   576      ! Initialization check
   577      !
   578      if ( .not. cloud_utils_inited ) then
   579        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   580      end if
   581  
   582  
   583      DelMass = ( PressLI - PressUI ) / Grav
   584  
   585  
   586      do l = 1, 2
   587  
   588        select case ( l )
   589        case ( 1 ) ! liquid
   590          CharPhase = 'liquid'
   591          PRCPFlux = SurfRainFlux
   592        case ( 2 ) ! solid
   593          CharPhase = 'solid'
   594          PRCPFlux = SurfSnowFlux
   595        case default
   596          call MessageNotify( 'E', module_name, 'Unexpected number for select case.' )
   597        end select
   598  
   599        call CloudUtilsPRCPEvap1GridCore( &
   600          & ( 2.0_DP * DelTime ),             & ! (in)
   601          & CharPhase,                        & ! (in)
   602          & DelMass, Press, Temp, QH2OVap,    & ! (in)
   603          & PRCPFlux,                         & ! (in)
   604          & PRCPArea, PRCPEvapArea,           & ! (in)
   605          & DelPRCPFlux, DelTemp, DelQH2OVap  & ! (out)
   606          & )
   607  
   608        select case ( l )
   609        case ( 1 ) ! liquid
   610          SurfRainFlux = PRCPFlux + DelPRCPFlux
   611        case ( 2 ) ! solid
   612          SurfSnowFlux = PRCPFlux + DelPRCPFlux
   613        case default
   614          call MessageNotify( 'E', module_name, 'Unexpected number for select case.' )
   615        end select
   616        QH2OVap    = QH2OVap + DelQH2OVap
   617        Temp       = Temp    + DelTemp
   618      end do
   619  
   620  
   621    end subroutine CloudUtilsPRCPEvap1Grid
   622  
   623    !--------------------------------------------------------------------------------------
   624  
   625    subroutine CloudUtilsPRCPEvap1GridCore( &
   626      & TimeStep,                           & ! (in)
   627      & CharPhase,                          & ! (in)
   628      & DelMass, Press, Temp, QH2OVap,      & ! (in)
   629      & PRCPFlux,                           & ! (in)
   630      & PRCPArea, PRCPEvapArea,             & ! (in)
   631      & DelPRCPFlux, DelTemp, DelQH2OVap    & ! (out)
   632      & )
   633  
   634      ! 物理・数学定数設定
   635      ! Physical and mathematical constants settings
   636      !
   637      use constants0, only: &
   638        & PI                    ! $ \pi $ .
   639                                ! 円周率.  Circular constant
   640  
   641      ! 物理定数設定
   642      ! Physical constants settings
   643      !
   644      use constants, only: &
   645        & Grav, &
   646                                ! $ g $ [m s-2].
   647                                ! 重力加速度.
   648                                ! Gravitational acceleration
   649        & CpDry, &
   650                                ! $ C_p $ [J kg-1 K-1].
   651                                ! 乾燥大気の定圧比熱.
   652                                ! Specific heat of air at constant pressure
   653        & GasRDry, &
   654                                ! $ R $ [J kg-1 K-1].
   655                                ! 乾燥大気の気体定数.
   656                                ! Gas constant of air
   657        & LatentHeat, &
   658                                ! $ L $ [J kg-1] .
   659                                ! 凝結の潜熱.
   660                                ! Latent heat of condensation
   661        & LatentHeatFusion, &
   662                                ! $ L $ [J kg-1] .
   663                                ! 融解の潜熱.
   664                                ! Latent heat of fusion
   665        & EpsV
   666                                ! $ \epsilon_v $ .
   667                                ! 水蒸気分子量比.
   668                                ! Molecular weight of water vapor
   669  
   670      ! 飽和比湿の算出
   671      ! Evaluate saturation specific humidity
   672      !
   673      use saturate, only:         &
   674        & CalcQVapSatOnLiq,       &
   675        & CalcDQVapSatDTempOnLiq, &
   676        & CalcQVapSatOnSol,       &
   677        & CalcDQVapSatDTempOnSol
   678  
   679  
   680      real(DP)    , intent(in ) :: TimeStep
   681      character(*), intent(in ) :: CharPhase
   682      real(DP)    , intent(in ) :: DelMass
   683      real(DP)    , intent(in ) :: Press
   684      real(DP)    , intent(in ) :: Temp
   685      real(DP)    , intent(in ) :: QH2OVap
   686      real(DP)    , intent(in ) :: PRCPFlux
   687      real(DP)    , intent(in ) :: PRCPArea
   688      real(DP)    , intent(in ) :: PRCPEvapArea
   689      real(DP)    , intent(out) :: DelPRCPFlux
   690      real(DP)    , intent(out) :: DelTemp
   691      real(DP)    , intent(out) :: DelQH2OVap
   692  
   693  
   694      ! Parameters for evaporation of rain
   695      real(DP), parameter :: DensWater            = 1.0d3
   696      !                            rho_w
   697      real(DP)            :: CCNND
   698      !                            number density of CCN, N0 or Nt (m-3)
   699      real(DP), parameter :: H2OVapDiffCoef       = 1.0d-5
   700      !                            Kd
   701      real(DP), parameter :: PRCPFallVel0         = 10.0_DP
   702      !                            m s-1
   703  
   704      real(DP) :: PRCPFallVelRatio
   705      real(DP) :: PRCPFallVelFactor
   706  
   707      real(DP) :: PRCPFallVel
   708      !                            m s-1
   709  
   710      real(DP) :: Dens
   711      !                           rho
   712      real(DP) :: DensPRCP
   713      !                           (rho q_r)
   714  
   715      real(DP) :: DelZ
   716  
   717      real(DP) :: FactorF
   718      real(DP) :: FactorG
   719      real(DP) :: FactorH
   720      real(DP) :: FactorI
   721  
   722      real(DP) :: LatentHeatSubl
   723      real(DP) :: LatentHeatLocal
   724  
   725      real(DP) :: VirTemp
   726      real(DP) :: QH2OVapSat
   727      real(DP) :: DQH2OVapSatDTemp
   728      real(DP) :: QH2OVapSatA
   729  
   730      real(DP) :: TempN
   731      real(DP) :: QH2OVapN
   732      real(DP) :: PRCPN
   733      real(DP) :: TempA
   734      real(DP) :: QH2OVapA
   735      real(DP) :: PRCPA
   736  
   737      real(DP) :: DelPRCP
   738  
   739      real(DP), parameter :: DelTempThreshold = 1.0e-2_DP
   740      integer, parameter :: ItrMax = 100
   741      real(DP) :: a_DelTemp(ItrMax)
   742  
   743      integer :: itr
   744  
   745  
   746      LatentHeatSubl = LatentHeat + LatentHeatFusion
   747  
   748  
   749      select case ( CharPhase )
   750      case ( 'liquid' )
   751        ! for liquid water
   752        PRCPFallVelRatio = 1.0_DP
   753        LatentHeatLocal  = LatentHeat
   754      case ( 'solid' )
   755        ! for solid water (ice)
   756        PRCPFallVelRatio = 0.5_DP
   757        LatentHeatLocal  = LatentHeatSubl
   758      case default
   759        call MessageNotify( 'E', module_name, 'Unexpected character for select case.' )
   760      end select
   761  
   762  
   763      VirTemp = Temp * ( 1.0_DP + ((( 1.0_DP / EpsV ) - 1.0_DP ) * QH2OVap) )
   764      Dens = Press / ( GasRDry * VirTemp )
   765      DelZ = DelMass / Dens
   766  
   767      PRCPFallVel = PRCPFallVel0 * PRCPFallVelRatio
   768  !!$    DensPRCP = ( PRCPFlux / ( PRCPArea + 1.0e-10_DP ) ) / PRCPFallVel
   769      DensPRCP = ( max( PRCPFlux, 0.0_DP ) / ( PRCPArea + 1.0e-10_DP ) ) / PRCPFallVel
   770  
   771      ! cloud condensation
   772      CCNND = CCNMixRatPerUnitMass * Dens
   773  
   774      FactorF =                                                          &
   775        &   Dens * H2OVapDiffCoef * PRCPEvapArea                         &
   776        & * ( 48.0_DP * ( PI * CCNND )**2 / DensWater * DensPRCP )**(1.0_DP/3.0_DP)
   777      FactorG = DelZ * TimeStep * FactorF
   778      FactorH = FactorG / DelMass
   779      FactorI = LatentHeatLocal / CpDry * FactorH
   780  
   781      TempN    = Temp
   782      QH2OVapN = QH2OVap
   783  !!$    PRCPN    = PRCPFlux * TimeStep
   784      PRCPN    = max( PRCPFlux, 0.0_DP ) * TimeStep
   785      loop_evap : do itr = 1, ItrMax
   786  
   787        select case ( CharPhase )
   788        case ( 'liquid' )
   789          ! for liquid water
   790          QH2OVapSat       = CalcQVapSatOnLiq( TempN, Press )
   791          DQH2OVapSatDTemp = CalcDQVapSatDTempOnLiq( TempN, QH2OVapSat )
   792        case ( 'solid' )
   793          ! for solid water (ice)
   794          QH2OVapSat       = CalcQVapSatOnSol( TempN, Press )
   795          DQH2OVapSatDTemp = CalcDQVapSatDTempOnSol( TempN, QH2OVapSat )
   796        case default
   797          call MessageNotify( 'E', module_name, 'Unexpected character for select case.' )
   798        end select
   799  
   800        DelTemp = - FactorI * ( QH2OVapSat - QH2OVapN ) &
   801          &           / ( 1.0_DP + FactorH + FactorI * DQH2OVapSatDTemp )
   802  
   803        DelQH2OVap = - CpDry * DelTemp / LatentHeatLocal
   804        DelPRCP    = - DelQH2OVap * DelMass
   805  
   806        if ( ( PRCPN + DelPRCP ) >= 0.0_DP ) then
   807          ! part of precipitation is evaporated
   808          ! nothing to do
   809        else
   810          ! all precipitation is evaporated
   811          DelPRCP    = - PRCPN
   812          DelQH2OVap = - DelPRCP / DelMass
   813          DelTemp    = - LatentHeatLocal * DelQH2OVap / CpDry
   814        end if
   815  
   816  
   817        if ( abs( DelTemp ) < DelTempThreshold ) exit loop_evap
   818  
   819        PRCPA    = PRCPN    + DelPRCP
   820        TempA    = TempN    + DelTemp
   821        QH2OVapA = QH2OVapN + DelQH2OVap
   822  
   823        PRCPN    = PRCPA
   824        TempN    = TempA
   825        QH2OVapN = QH2OVapA
   826  
   827        a_DelTemp(itr) = DelTemp
   828      end do loop_evap
   829      if ( itr > 100 ) then
   830        write( 6, * ) a_DelTemp
   831        call MessageNotify( 'E', module_name, 'Evaporation loop is not convergent, %d, %f.', i = (/ itr /), d = (/ DelTemp /) )
   832      end if
   833  
   834      DelPRCPFlux = DelPRCP / TimeStep
   835  
   836  
   837    end subroutine CloudUtilsPRCPEvap1GridCore
   838  
   839    !--------------------------------------------------------------------------------------
   840  
   841    subroutine CloudUtilsPRCPEvap1GridCoreExp( &
   842      & CharPhase,                                    & ! (in)
   843      & DelMass, Press, QH2OVap, QH2OVapSat, VirTemp, & ! (in)
   844      & PRCP,                                         & ! (in)
   845      & PRCPArea, PRCPEvapArea,                       & ! (in)
   846      & DelPRCPFlux                                   & ! (out)
   847      & )
   848  
   849      ! 物理・数学定数設定
   850      ! Physical and mathematical constants settings
   851      !
   852      use constants0, only: &
   853        & PI                    ! $ \pi $ .
   854                                ! 円周率.  Circular constant
   855  
   856      ! 物理定数設定
   857      ! Physical constants settings
   858      !
   859      use constants, only: &
   860        & Grav, &
   861                                ! $ g $ [m s-2].
   862                                ! 重力加速度.
   863                                ! Gravitational acceleration
   864        & GasRDry
   865                                ! $ R $ [J kg-1 K-1].
   866                                ! 乾燥大気の気体定数.
   867                                ! Gas constant of air
   868  
   869  
   870      character(*), intent(in ) :: CharPhase
   871      real(DP)    , intent(in ) :: DelMass
   872      real(DP)    , intent(in ) :: Press
   873      real(DP)    , intent(in ) :: QH2OVap
   874      real(DP)    , intent(in ) :: QH2OVapSat
   875      real(DP)    , intent(in ) :: VirTemp
   876      real(DP)    , intent(in ) :: PRCP
   877      real(DP)    , intent(in ) :: PRCPArea
   878      real(DP)    , intent(in ) :: PRCPEvapArea
   879      real(DP)    , intent(out) :: DelPRCPFlux
   880  
   881  
   882      ! Parameters for evaporation of rain
   883      real(DP), parameter :: DensWater            = 1.0d3
   884      !                            rho_w
   885      !   Values below are from Kessler (1969)
   886      real(DP), parameter :: PRCPFallVelFactor0        = 130.0d0
   887      !                            K
   888      real(DP), parameter :: MedianDiameterFactor      = 3.67d0
   889      !                            C'
   890      real(DP), parameter :: PRCPDistFactor            = 1.0d7
   891      !                            N0
   892      real(DP), parameter :: PRCPEvapRatUnitDiamFactor = 2.24d3
   893      !                            C
   894      real(DP), parameter :: H2OVapDiffCoef            = 1.0d-5
   895      !                            Kd
   896  
   897      real(DP), parameter :: PRCPFallVelSimple0        = 10.0d0
   898      !                            m s-1
   899  
   900      real(DP) :: PRCPFallVelRatio
   901      real(DP) :: PRCPFallVelFactor
   902  
   903      real(DP) :: Dens0
   904      !                            rho_0
   905      real(DP) :: V00
   906      !                            V_{00}
   907      real(DP) :: PRCPEvapFactor
   908  
   909      real(DP) :: Dens
   910      !                           rho
   911      real(DP) :: DensPRCP
   912      !                           (rho q_r)
   913  !!$    real(DP) :: RainArea
   914  !!$    !                           a_p
   915  !!$    real(DP) :: RainEvapArea
   916  !!$    !                           A = max( a_p - a, 0 )
   917  !!$    real(DP) :: xy_CloudCover   (0:imax-1, 1:jmax)
   918  !!$    !                           a
   919      real(DP) :: PRCPEvapRate
   920  
   921      real(DP) :: DelZ
   922  
   923  
   924      select case ( CharPhase )
   925      case ( 'liquid' )
   926        ! for liquid water
   927        PRCPFallVelRatio = 1.0_DP
   928      case ( 'solid' )
   929        ! for solid water (ice)
   930        PRCPFallVelRatio = 0.5_DP
   931      case ( 'mixture' )
   932        ! for mixture, this is only for test
   933        PRCPFallVelRatio = 1.0_DP
   934      case default
   935        call MessageNotify( 'E', module_name, 'Unexpected character for select case.' )
   936      end select
   937      !
   938  
   939      ! Values for evaporation of rain
   940      Dens = Press / ( GasRDry * VirTemp )
   941  
   942      DelZ = DelMass / Dens
   943  
   944  
   945      if ( .false. ) then ! ECMWF version
   946  
   947        PRCPFallVelFactor = PRCPFallVelFactor0 * PRCPFallVelRatio
   948  
   949        ! Parameters for evaporation of rain
   950        Dens0 = 1013.0d2 / ( GasRDry * 300.0_DP )
   951        V00 = PRCPFallVelFactor * sqrt( MedianDiameterFactor ) &
   952          & / ( PI * DensWater * PRCPDistFactor )**(1.0d0/8.0d0)
   953        PRCPEvapFactor =                                      &
   954  !      & RainEvapRatUnitDiamFactor * gamma( 13.0d0/5.0d0 ) &
   955          & PRCPEvapRatUnitDiamFactor * 1.429624558860304d0   &
   956          & * H2OVapDiffCoef * PRCPDistFactor**(7.0d0/20.0d0) &
   957          & / ( PI * DensWater )**(13.0d0/20.0d0)
   958  
   959  !!$    RainArea   = RainArea
   960  !!$    xy_CloudCover = CloudCover
   961  !!$    xy_RainEvapArea = max( xy_RainArea - xy_CloudCover, 0.0_DP )
   962  !!$    RainEvapArea = RainEvapArea
   963  
   964        DensPRCP =                                                   &
   965          & ( PRCP / ( PRCPArea + 1.0d-10 )                          &
   966          &   / ( V00 * sqrt( Dens0 / Dens ) ) )**(8.0d0/9.0d0)
   967        PRCPEvapRate =                                      &
   968          & Dens * PRCPEvapArea * PRCPEvapFactor            &
   969          &   * max( QH2OVapSat - QH2OVap, 0.0_DP )         &
   970          &   * DensPRCP**(13.0d0/20.0d0)
   971  
   972      else ! simple version
   973  
   974        V00 = PRCPFallVelSimple0 * PRCPFallVelRatio
   975  
   976        PRCPEvapFactor =                                                 &
   977          & ( 48.0_DP * ( PI * PRCPDistFactor )**2 / DensWater )**(1.0_DP/3.0_DP) &
   978          & * H2OVapDiffCoef
   979  
   980        DensPRCP =                                                   &
   981          & ( PRCP / ( PRCPArea + 1.0d-10 ) )                        &
   982          &   / V00
   983        PRCPEvapRate =                                      &
   984          & Dens * PRCPEvapArea * PRCPEvapFactor            &
   985          &   * max( QH2OVapSat - QH2OVap, 0.0_DP )         &
   986          &   * DensPRCP**(1.0_DP/3.0_DP)
   987  
   988      end if
   989  
   990      ! PRCPEvapRate (kg m-3 s-1)
   991      ! DelZ         (m)
   992      ! DelPRCPFlux  (kg m-2 s-1)
   993      DelPRCPFlux = PRCPEvapRate * DelZ
   994  
   995      DelPRCPFlux = min( DelPRCPFlux, PRCP )
   996  
   997  
   998    end subroutine CloudUtilsPRCPEvap1GridCoreExp
   999  
  1000    !--------------------------------------------------------------------------------------
  1001  
  1002    subroutine CloudUtilConsChk(                             &
  1003      & ParentRoutineName,                                   &
  1004  !!$    & FlagIncludeSnowPhaseChange,                          &
  1005      & xyr_Press,                                           &
  1006      & xyz_TempB, xyz_QH2OVapB, xyz_QH2OLiqB, xyz_QH2OSolB, &
  1007      & xyz_Temp , xyz_QH2OVap , xyz_QH2OLiq , xyz_QH2OSol , &
  1008      & xy_Rain, xy_Snow                                     &
  1009      & )
  1010  
  1011  
  1012      ! 時刻管理
  1013      ! Time control
  1014      !
  1015      use timeset, only: &
  1016        & DelTime            ! $ \Delta t $ [s]
  1017  
  1018      ! 物理定数設定
  1019      ! Physical constants settings
  1020      !
  1021      use constants, only: &
  1022        & Grav, &
  1023                                ! $ g $ [m s-2].
  1024                                ! 重力加速度.
  1025                                ! Gravitational acceleration
  1026        & CpDry, &
  1027                                ! $ C_p $ [J kg-1 K-1].
  1028                                ! 乾燥大気の定圧比熱.
  1029                                ! Specific heat of air at constant pressure
  1030        & LatentHeat, &
  1031                                ! $ L $ [J kg-1] .
  1032                                ! 凝結の潜熱.
  1033                                ! Latent heat of condensation
  1034        & LatentHeatFusion
  1035                                ! $ L $ [J kg-1] .
  1036                                ! 融解の潜熱.
  1037                                ! Latent heat of fusion
  1038  
  1039      character(*), intent(in) :: ParentRoutineName
  1040  !!$    logical , intent(in) :: FlagIncludeSnowPhaseChange
  1041      real(DP), intent(in) :: xyr_Press   (0:imax-1, 1:jmax, 0:kmax)
  1042      real(DP), intent(in) :: xyz_TempB   (0:imax-1, 1:jmax, 1:kmax)
  1043      real(DP), intent(in) :: xyz_QH2OVapB(0:imax-1, 1:jmax, 1:kmax)
  1044      real(DP), intent(in) :: xyz_QH2OLiqB(0:imax-1, 1:jmax, 1:kmax)
  1045      real(DP), intent(in) :: xyz_QH2OSolB(0:imax-1, 1:jmax, 1:kmax)
  1046      real(DP), intent(in) :: xyz_Temp    (0:imax-1, 1:jmax, 1:kmax)
  1047      real(DP), intent(in) :: xyz_QH2OVap (0:imax-1, 1:jmax, 1:kmax)
  1048      real(DP), intent(in) :: xyz_QH2OLiq (0:imax-1, 1:jmax, 1:kmax)
  1049      real(DP), intent(in) :: xyz_QH2OSol (0:imax-1, 1:jmax, 1:kmax)
  1050      real(DP), intent(in) :: xy_Rain     (0:imax-1, 1:jmax)
  1051      real(DP), intent(in) :: xy_Snow     (0:imax-1, 1:jmax)
  1052  
  1053      ! Local variables
  1054      !
  1055      real(DP) :: xyz_DelMass(0:imax-1, 1:jmax, 1:kmax)
  1056      real(DP) :: xy_Val(0:imax-1, 1:jmax)
  1057      real(DP) :: xy_SumB(0:imax-1, 1:jmax)
  1058      real(DP) :: xy_Sum(0:imax-1, 1:jmax)
  1059      real(DP) :: xy_Ratio(0:imax-1, 1:jmax)
  1060      integer  :: i
  1061      integer  :: j
  1062      integer  :: k
  1063  
  1064  
  1065      do k = 1, kmax
  1066        xyz_DelMass(:,:,k) = ( xyr_Press(:,:,k-1) - xyr_Press(:,:,k) ) / Grav
  1067      end do
     .        d1 = 1.D0/grav                                                    
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do k = 1, kmax*jmax*imax                                          
     .           xyz_delmass(k-1,1,1) = (xyr_press(k-1,1,0)-xyr_press(k-1,1,1))*
     .       1      d1                                                          
     .        enddo                                                             
  1068  
  1069      xy_Sum = 0.0_DP
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t474 = 1, xy_sum.DSC.U2*xy_sum.DSC.U1 + xy_sum.DSC.U2          
     .           xy_sum(t474-1,1) = 0.0000000000000000e+000                     
     .        enddo                                                             
  1070      do k = kmax, 1, -1
  1071        xy_Val =   CpDry * xyz_TempB(:,:,k)               &
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xy_val,xy_sum)                                             
     .        do t480 = 1, jmax*imax                                            
     .           xy_val(t480-1,1) = cpdry*xyz_tempb(t480-1,1,k) + latentheat*   
     .       1      xyz_qh2ovapb(t480-1,1,k) - latentheatfusion*xyz_qh2osolb(   
     .       2      t480-1,1,k)                                                 
     .           xy_sum(t480-1,1) = xy_sum(t480-1,1) + xy_val(t480-1,1)*        
     .       1      xyz_delmass(t480-1,1,k)                                     
     .        enddo                                                             
  1072          &      + LatentHeat * xyz_QH2OVapB(:,:,k)       &
  1073          &      - LatentHeatFusion * xyz_QH2OSolB(:,:,k)
  1074        xy_Sum = xy_Sum + xy_Val * xyz_DelMass(:,:,k)
  1075      end do
  1076  
  1077      xy_SumB = xy_Sum
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xy_sum)                                                    
     .        do t500 = 1, xy_sumb.DSC.U2*xy_sumb.DSC.U1 + xy_sumb.DSC.U2       
     .           xy_sumb(t500-1,1) = xy_sum(t500-1,1)                           
     .           xy_sum(t500-1,1) = 0.0000000000000000e+000                     
     .        enddo                                                             
  1078  
  1079      xy_Sum = 0.0_DP
  1080      do k = kmax, 1, -1
  1081        xy_Val =   CpDry * xyz_Temp (:,:,k)               &
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xy_val,xy_sum)                                             
     .        do t510 = 1, jmax*imax                                            
     .           xy_val(t510-1,1) = cpdry*xyz_temp(t510-1,1,k) + latentheat*    
     .       1      xyz_qh2ovap(t510-1,1,k) - latentheatfusion*xyz_qh2osol(t510-
     .       2      1,1,k)                                                      
     .           xy_sum(t510-1,1) = xy_sum(t510-1,1) + xy_val(t510-1,1)*        
     .       1      xyz_delmass(t510-1,1,k)                                     
     .        enddo                                                             
  1082          &      + LatentHeat * xyz_QH2OVap (:,:,k)       &
  1083          &      - LatentHeatFusion * xyz_QH2OSol (:,:,k)
  1084        xy_Sum = xy_Sum + xy_Val * xyz_DelMass(:,:,k)
  1085      end do
  1086  !!$    if ( FlagIncludeSnowPhaseChange ) then
  1087        xy_Sum = xy_Sum - LatentHeatFusion * xy_Snow * 2.0_DP * DelTime
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xy_sum)                                                    
     .        do t530 = 1, xy_sum.DSC.U2*xy_sum.DSC.U1 + xy_sum.DSC.U2          
     .           xy_sum(t530-1,1) = xy_sum(t530-1,1) - latentheatfusion*xy_snow(
     .       1      t530-1,1)*2.00000000000000e+000*deltime                     
     .           xy_ratio(t530-1,1) = (xy_sum(t530-1,1)-xy_sumb(t530-1,1))/(    
     .       1      xy_sum(t530-1,1)+1.00000000000000e-100)                     
     .        enddo                                                             
  1088  !!$    end if
  1089  
  1090      xy_Ratio = ( xy_Sum - xy_SumB ) / ( xy_Sum + 1.0d-100 )
  1091      do j = 1, jmax
  1092        do i = 0, imax-1
  1093          if ( abs( xy_Ratio(i,j) ) > 1.0d-10 ) then
  1094            call MessageNotify( 'M', module_name, '%c, Modified condensate static energy is not conserved, %f.', &
  1095              & c1 = trim(ParentRoutineName), d = (/ xy_Ratio(i,j) /) )
  1096          end if
  1097        end do
  1098      end do
  1099  
  1100  
  1101  
  1102      xy_Sum = 0.0_DP
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t548 = 1, xy_sum.DSC.U2*xy_sum.DSC.U1 + xy_sum.DSC.U2          
     .           xy_sum(t548-1,1) = 0.0000000000000000e+000                     
     .        enddo                                                             
  1103      do k = kmax, 1, -1
  1104        xy_Val = xyz_QH2OVapB(:,:,k) + xyz_QH2OLiqB(:,:,k) + xyz_QH2OSolB(:,:,k)
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xy_val,xy_sum)                                             
     .        do t554 = 1, jmax*imax                                            
     .           xy_val(t554-1,1) = xyz_qh2ovapb(t554-1,1,k) + xyz_qh2oliqb(t554
     .       1      -1,1,k) + xyz_qh2osolb(t554-1,1,k)                          
     .           xy_sum(t554-1,1) = xy_sum(t554-1,1) + xy_val(t554-1,1)*        
     .       1      xyz_delmass(t554-1,1,k)                                     
     .        enddo                                                             
  1105        xy_Sum = xy_Sum + xy_Val * xyz_DelMass(:,:,k)
  1106      end do
  1107  
  1108      xy_SumB = xy_Sum
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xy_sum)                                                    
     .        do t574 = 1, xy_sumb.DSC.U2*xy_sumb.DSC.U1 + xy_sumb.DSC.U2       
     .           xy_sumb(t574-1,1) = xy_sum(t574-1,1)                           
     .           xy_sum(t574-1,1) = 0.0000000000000000e+000                     
     .        enddo                                                             
  1109  
  1110      xy_Sum = 0.0_DP
  1111      do k = kmax, 1, -1
  1112        xy_Val = xyz_QH2OVap (:,:,k) + xyz_QH2OLiq (:,:,k) + xyz_QH2OSol (:,:,k)
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xy_val,xy_sum)                                             
     .        do t584 = 1, jmax*imax                                            
     .           xy_val1 = xyz_qh2ovap(t584-1,1,k) + xyz_qh2oliq(t584-1,1,k) +  
     .       1      xyz_qh2osol(t584-1,1,k)                                     
     .           xy_sum(t584-1,1) = xy_sum(t584-1,1) + xy_val1*xyz_delmass(t584-
     .       1      1,1,k)                                                      
     .        enddo                                                             
  1113        xy_Sum = xy_Sum + xy_Val * xyz_DelMass(:,:,k)
  1114      end do
  1115      xy_Sum = xy_Sum + ( xy_Rain + xy_Snow ) * 2.0_DP * DelTime
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xy_sum)                                                    
     .        do t604 = 1, xy_sum.DSC.U2*xy_sum.DSC.U1 + xy_sum.DSC.U2          
     .           xy_sum(t604-1,1) = xy_sum(t604-1,1) + (xy_rain(t604-1,1)+      
     .       1      xy_snow(t604-1,1))*2.00000000000000e+000*deltime            
     .           xy_ratio(t604-1,1) = (xy_sum(t604-1,1)-xy_sumb(t604-1,1))/(    
     .       1      xy_sum(t604-1,1)+1.00000000000000e-100)                     
     .        enddo                                                             
  1116  
  1117      xy_Ratio = ( xy_Sum - xy_SumB ) / ( xy_Sum + 1.0d-100 )
  1118      do j = 1, jmax
  1119        do i = 0, imax-1
  1120          if ( abs( xy_Ratio(i,j) ) > 1.0d-10 ) then
  1121            call MessageNotify( 'M', module_name, '%c, H2O mass is not conserved, %f.', &
  1122              & c1 = trim(ParentRoutineName), d = (/ xy_Ratio(i,j) /) )
  1123          end if
  1124        end do
  1125      end do
  1126  
  1127  
  1128    end subroutine CloudUtilConsChk
  1129  
  1130    !--------------------------------------------------------------------------------------
  1131  
  1132    subroutine CloudUtilsInit( &
  1133      & ArgFlagSnow            &
  1134      & )
  1135  
  1136      ! ファイル入出力補助
  1137      ! File I/O support
  1138      !
  1139      use dc_iounit, only: FileOpen
  1140  
  1141      ! NAMELIST ファイル入力に関するユーティリティ
  1142      ! Utilities for NAMELIST file input
  1143      !
  1144      use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid
  1145  
  1146      ! ヒストリデータ出力
  1147      ! History data output
  1148      !
  1149      use gtool_historyauto, only: HistoryAutoAddVariable
  1150  
  1151      ! 飽和比湿の算出
  1152      ! Evaluate saturation specific humidity
  1153      !
  1154      use saturate, only: &
  1155        & SaturateInit
  1156  
  1157  
  1158      ! 宣言文 ; Declaration statements
  1159      !
  1160  
  1161      logical, intent(in) :: ArgFlagSnow
  1162  
  1163  
  1164      character(STRING) :: CloudOverlapType
  1165  
  1166      integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号.
  1167                                ! Unit number for NAMELIST file open
  1168      integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT.
  1169                                ! IOSTAT of NAMELIST read
  1170  
  1171      ! NAMELIST 変数群
  1172      ! NAMELIST group name
  1173      !
  1174      namelist /cloud_utils_nml/  &
  1175        & CloudOverlapType,       &
  1176        & CCNMixRatPerUnitMass
  1177            !
  1178            ! デフォルト値については初期化手続 "cloud_utils#CloudUtilsInit"
  1179            ! のソースコードを参照のこと.
  1180            !
  1181            ! Refer to source codes in the initialization procedure
  1182            ! "cloud_utils#CloudUtilsInit" for the default values.
  1183            !
  1184  
  1185      ! 実行文 ; Executable statement
  1186      !
  1187  
  1188      if ( cloud_utils_inited ) return
  1189  
  1190  
  1191      FlagSnow = ArgFlagSnow
  1192  
  1193  
  1194      ! デフォルト値の設定
  1195      ! Default values settings
  1196      !
  1197  
  1198      CloudOverlapType    = "Random"
  1199  !!$    CloudOverlapType    = "MaxOverlap"
  1200  
  1201      CCNMixRatPerUnitMass = 1.0e8_DP
  1202  
  1203  
  1204      ! NAMELIST の読み込み
  1205      ! NAMELIST is input
  1206      !
  1207      if ( trim(namelist_filename) /= '' ) then
  1208        call FileOpen( unit_nml, &          ! (out)
  1209          & namelist_filename, mode = 'r' ) ! (in)
  1210  
  1211        rewind( unit_nml )
  1212        read( unit_nml,                     & ! (in)
  1213          & nml = cloud_utils_nml,          & ! (out)
  1214          & iostat = iostat_nml )             ! (out)
  1215        close( unit_nml )
  1216  
  1217        call NmlutilMsg( iostat_nml, module_name ) ! (in)
  1218      end if
  1219  
  1220  
  1221      select case ( CloudOverlapType )
  1222      case ( 'Random' )
  1223        IDCloudOverlapType = IDCloudOverlapTypeRandom
  1224      case ( 'MaxOverlap' )
  1225        IDCloudOverlapType = IDCloudOverlapTypeMaxOverlap
  1226      case default
  1227        call MessageNotify( 'E', module_name,         &
  1228          & 'CloudOverlapType=<%c> is not supported.', &
  1229          & c1 = trim(CloudOverlapType) )
  1230      end select
  1231  
  1232  
  1233      ! Initialization of modules used in this module
  1234      !
  1235  
  1236      ! 飽和比湿の算出
  1237      ! Evaluate saturation specific humidity
  1238      !
  1239      call SaturateInit
  1240  
  1241  
  1242      ! ヒストリデータ出力のためのへの変数登録
  1243      ! Register of variables for history data output
  1244      !
  1245  !!$    call HistoryAutoAddVariable( 'EffCloudCover', &
  1246  !!$      & (/ 'lon ', 'lat ', 'time' /), &
  1247  !!$      & 'effective cloud cover', '1' )
  1248  
  1249  
  1250  
  1251      ! 印字 ; Print
  1252      !
  1253      call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
  1254      call MessageNotify( 'M', module_name, 'CloudOverlapType     = %c', c1 = trim(CloudOverlapType) )
  1255      call MessageNotify( 'M', module_name, 'CCNMixRatPerUnitMass = %f', d = (/ CCNMixRatPerUnitMass /) )
  1256      call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
  1257  
  1258      cloud_utils_inited = .true.
  1259  
  1260    end subroutine CloudUtilsInit
  1261  
  1262    !--------------------------------------------------------------------------------------
  1263  
  1264  end module cloud_utils
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:50 2016
FILE NAME: cloud_utils.f90
PROGRAM NAME: cloud_utils
FORMAT LIST

  LINE    LOOP      FORTRAN STATEMENT

     1:             != 雲関系ルーチン
     2:             !
     3:             != Cloud-related routines
     4:             !
     5:             ! Authors::   Yoshiyuki O. Takahashi
     6:             ! Version::   $Id: cloud_utils.f90,v 1.7 2015/02/11 11:55:19 yot Exp $
     7:             ! Tag Name::  $Name:  $
     8:             ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9:             ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10:             !
    11:             module cloud_utils
    12:               !
    13:               != 雲関系ルーチン
    14:               !
    15:               != Cloud-related routines
    16:               !
    17:               ! <b>Note that Japanese and English are described in parallel.</b>
    18:               !
    19:               ! 雲の分布を設定.
    20:               !
    21:               ! In this module, the amount of cloud or cloud optical depth are set.
    22:               ! This module is under development and is still a preliminary version. 
    23:               !
    24:               !== Procedures List
    25:               !
    26:             !!$  ! RadiationFluxDennouAGCM :: 放射フラックスの計算
    27:             !!$  ! ------------            :: ------------
    28:             !!$  ! RadiationFluxDennouAGCM :: Calculate radiation flux
    29:               !
    30:               !== NAMELIST
    31:               !
    32:               ! NAMELIST#cloud_utils_nml
    33:               !
    34:             
    35:               ! モジュール引用 ; USE statements
    36:             
    37:               !
    38:               ! Kind type parameter
    39:               !
    40:               use dc_types, only: DP, &      ! Double precision.
    41:                 &                 STRING, &  ! Strings.
    42:                 &                 TOKEN      ! Keywords.
    43:             
    44:               ! メッセージ出力
    45:               ! Message output
    46:               !
    47:               use dc_message, only: MessageNotify
    48:             
    49:               ! 格子点設定
    50:               ! Grid points settings
    51:               !
    52:               use gridset, only: imax, & ! 経度格子点数.
    53:                                          ! Number of grid points in longitude
    54:                 &                jmax, & ! 緯度格子点数.
    55:                                          ! Number of grid points in latitude
    56:                 &                kmax    ! 鉛直層数.
    57:                                          ! Number of vertical level
    58:             
    59:               implicit none
    60:             
    61:               private
    62:             
    63:             
    64:               ! 公開手続き
    65:               ! Public procedure
    66:               !
    67:               public :: CloudUtilsCalcOverlapCloudTrans
    68:               public :: CloudUtilsSmearCloudOptDep
    69:               public :: CloudUtilsLocalizeCloud
    70:               public :: CloudUtilsPRCPStepPC1Grid
    71:               public :: CloudUtilsPRCPEvap1Grid
    72:               public :: CloudUtilConsChk
    73:               public :: CloudUtilsInit
    74:             
    75:             
    76:               ! 公開変数
    77:               ! Public variables
    78:               !
    79:             
    80:             
    81:               ! 非公開変数
    82:               ! Private variables
    83:               !
    84:               logical , save        :: FlagSnow
    85:                                        ! A flag for snow
    86:             
    87:               real(DP), save :: CCNMixRatPerUnitMass
    88:               !                            number of CCN per atmospheric mass (kg-1)
    89:               !                            CCN : Cloud Condensation Nuclei
    90:             
    91:               integer , save        :: IDCloudOverlapType
    92:               integer , parameter   :: IDCloudOverlapTypeRandom     = 1
    93:               integer , parameter   :: IDCloudOverlapTypeMaxOverlap = 2
    94:             
    95:               logical, save :: cloud_utils_inited = .false.
    96:                                           ! 初期設定フラグ.
    97:                                           ! Initialization flag
    98:             
    99:               character(*), parameter:: module_name = 'cloud_utils'
   100:                                           ! モジュールの名称.
   101:                                           ! Module name
   102:               character(*), parameter:: version = &
   103:                 & '$Name:  $' // &
   104:                 & '$Id: cloud_utils.f90,v 1.7 2015/02/11 11:55:19 yot Exp $'
   105:                                           ! モジュールのバージョン
   106:                                           ! Module version
   107:             
   108:               !--------------------------------------------------------------------------------------
   109:             
   110:             contains
   111:             
   112:               !--------------------------------------------------------------------------------------
   113:             
   114:               subroutine CloudUtilsCalcOverlapCloudTrans(  &
   115:                 & xyz_TransCloudOneLayer, xyz_CloudCover,  & ! (in)
   116:                 & xyrr_OverlappedCloudTrans                & ! (out)
   117:                 & )
   118:             
   119:                 ! USE statements
   120:                 !
   121:             
   122:                 ! ヒストリデータ出力
   123:                 ! History data output
   124:                 !
   125:                 use gtool_historyauto, only: HistoryAutoPut
   126:             
   127:                 ! 時刻管理
   128:                 ! Time control
   129:                 !
   130:                 use timeset, only: &
   131:                   & TimeN, &              ! ステップ $ t $ の時刻.
   132:                                           ! Time of step $ t $.
   133:                   & EndTime, &            ! 計算終了時刻.
   134:                                           ! End time of calculation
   135:                   & TimesetClockStart, TimesetClockStop
   136:             
   137:             !!$    use sort, only : SortQuick
   138:             
   139:                 real(DP), intent(in ) :: xyz_TransCloudOneLayer   (0:imax-1, 1:jmax, 1:kmax)
   140:                 real(DP), intent(in ) :: xyz_CloudCover           (0:imax-1, 1:jmax, 1:kmax)
   141:                 real(DP), intent(out) :: xyrr_OverlappedCloudTrans(0:imax-1, 1:jmax, 0:kmax, 0:kmax)
   142:             
   143:             
   144:                 real(DP) :: xyz_EffCloudCover           (0:imax-1, 1:jmax, 1:kmax)
   145:                 real(DP) :: xyz_CloudCoverSorted        (0:imax-1, 1:jmax, 1:kmax)
   146:                 real(DP) :: xyz_EffCloudCoverSorted     (0:imax-1, 1:jmax, 1:kmax)
   147:                 real(DP) :: xyz_TransCloudOneLayerSorted(0:imax-1, 1:jmax, 1:kmax)
   148:                 real(DP) :: CloudCoverSortedCur
   149:                 real(DP) :: EffCloudCoverSortedCur
   150:                 real(DP) :: TransCloudOneLayerSortedCur
   151:                 integer  :: KInsPos
   152:                 integer  :: i
   153:                 integer  :: j
   154:                 integer  :: k
   155:                 integer  :: kk
   156:                 integer  :: kkk
   157:             
   158:             
   159:             
   160:                 ! 実行文 ; Executable statement
   161:                 !
   162:             
   163:                 ! 初期化確認
   164:                 ! Initialization check
   165:                 !
   166:                 if ( .not. cloud_utils_inited ) then
   167:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   168:                 end if
   169:             
   170:             
   171:                 ! Cloud optical depth
   172:                 !
   173:             
   174:                 select case ( IDCloudOverlapType )
   175:                 case ( IDCloudOverlapTypeRandom )
   176:             
   177: W**==== A         xyz_EffCloudCover = xyz_CloudCover * ( 1.0_DP - xyz_TransCloudOneLayer )
   178:             
   179: +------>          do k = 0, kmax
   180: |                   kk = k
   181: |W*==== A           xyrr_OverlappedCloudTrans(:,:,k,kk) = 1.0_DP
   182: |+----->            do kk = k+1, kmax
   183: ||W*=== A             xyrr_OverlappedCloudTrans(:,:,k,kk) =        &
   184: ||                      & xyrr_OverlappedCloudTrans(:,:,k,kk-1)    &
   185: ||                      & * ( 1.0_DP - xyz_EffCloudCover(:,:,kk) )
   186: |+-----             end do
   187: +------           end do
   188:             
   189: +------>          do k = 0, kmax
   190: |+----->            do kk = 0, k-1
   191: ||W*=== A             xyrr_OverlappedCloudTrans(:,:,k,kk) = xyrr_OverlappedCloudTrans(:,:,kk,k)
   192: |+-----             end do
   193: +------           end do
   194:             
   195:                 case ( IDCloudOverlapTypeMaxOverlap )
   196:             
   197:                   ! see Chou et al. (2001)
   198:             
   199: W**==== A         xyz_EffCloudCover = xyz_CloudCover * ( 1.0_DP - xyz_TransCloudOneLayer )
   200:             
   201:             
   202:                   ! Original method (computationally expensive, probably)
   203:                   !
   204:             !!$        do k = 0, kmax
   205:             !!$          kk = k
   206:             !!$          xyrr_OverlappedCloudTrans(:,:,k,kk) = 1.0_DP
   207:             !!$          do kk = k+1, kmax
   208:             !!$
   209:             !!$            xyz_CloudCoverSorted         = xyz_CloudCover
   210:             !!$            xyz_EffCloudCoverSorted      = xyz_EffCloudCover
   211:             !!$            xyz_TransCloudOneLayerSorted = xyz_TransCloudOneLayer
   212:             !!$
   213:             !!$            call SortQuick( imax, jmax, kk-k,             &
   214:             !!$              & xyz_CloudCoverSorted        (:,:,k+1:kk), &
   215:             !!$              & xyz_EffCloudCoverSorted     (:,:,k+1:kk), &
   216:             !!$              & xyz_TransCloudOneLayerSorted(:,:,k+1:kk)  &
   217:             !!$              & )
   218:             !!$
   219:             !!$            xyrr_OverlappedCloudTrans(:,:,k,kk) = 0.0_DP
   220:             !!$            do kkk = k+1, kk
   221:             !!$              xyrr_OverlappedCloudTrans(:,:,k,kk) =         &
   222:             !!$                & xyz_EffCloudCoverSorted(:,:,kkk)          &
   223:             !!$                & + xyrr_OverlappedCloudTrans(:,:,k,kk)     &
   224:             !!$                &   * xyz_TransCloudOneLayerSorted(:,:,kkk)
   225:             !!$            end do
   226:             !!$            xyrr_OverlappedCloudTrans(:,:,k,kk) = &
   227:             !!$              & 1.0_DP - xyrr_OverlappedCloudTrans(:,:,k,kk)
   228:             !!$
   229:             !!$          end do
   230:             !!$        end do
   231:             
   232:             
   233:                   ! Economical method (probably)
   234:                   !
   235: +------>          do k = 0, kmax
   236: |           
   237: |           !!$          do kkk = 1, kmax
   238: |           !!$              xyz_CloudCoverSorted(:,:,kkk) = real( kmax-kkk ) / real(kmax)
   239: |           !!$!              xyz_CloudCoverSorted(:,:,kkk) = abs( 0.55d0 - real( kmax-kkk ) / real(kmax) )
   240: |           !!$          end do
   241: |           !!$          ! debug output
   242: |           !!$          if ( k == 0 ) then
   243: |           !!$            kk = kmax
   244: |           !!$            do kkk = k+1, kk
   245: |           !!$              write( 6, * ) kkk, xyz_CloudCoverSorted(0,jmax/2+1,kkk)
   246: |           !!$            end do
   247: |           !!$          end if
   248: |           
   249: |**W--->A           xyz_CloudCoverSorted         = xyz_CloudCover
   250: ||||    A           xyz_EffCloudCoverSorted      = xyz_EffCloudCover
   251: |**W--- A           xyz_TransCloudOneLayerSorted = xyz_TransCloudOneLayer
   252: |           
   253: |                   kk = k
   254: |W*==== A           xyrr_OverlappedCloudTrans(:,:,k,kk) = 1.0_DP
   255: |+----->            do kk = k+1, kmax
   256: ||          
   257: ||          
   258: ||+---->              do j = 1, jmax
   259: |||+--->                do i = 0, imax-1
   260: ||||        
   261: ||||                      ! xyz_CloudCoverSorted(i,j,kk) is inserved in an appropriate position.
   262: ||||                      !
   263: ||||                      KInsPos = kk
   264: ||||V-->                  loop : do kkk = k+1, kk-1
   265: |||||       
   266: |||||   A                   if ( xyz_CloudCoverSorted(i,j,kk) < xyz_CloudCoverSorted(i,j,kkk) ) then
   267: |||||                         KInsPos = kkk
   268: |||||                         exit loop
   269: |||||                       end if
   270: |||||       
   271: ||||V--                   end do loop
   272: ||||        
   273: ||||                      ! values are saved
   274: ||||                      CloudCoverSortedCur         = xyz_CloudCoverSorted        (i,j,kk)
   275: ||||                      EffCloudCoverSortedCur      = xyz_EffCloudCoverSorted     (i,j,kk)
   276: ||||                      TransCloudOneLayerSortedCur = xyz_TransCloudOneLayerSorted(i,j,kk)
   277: ||||        
   278: ||||                      ! values are shifted upward to empty an array at insert position
   279: ||||V-->                  do kkk = kk, KInsPos+1, -1
   280: |||||   A                   xyz_CloudCoverSorted        (i,j,kkk) = &
   281: |||||                         & xyz_CloudCoverSorted        (i,j,kkk-1)
   282: |||||   A                   xyz_EffCloudCoverSorted     (i,j,kkk) = &
   283: |||||                         & xyz_EffCloudCoverSorted     (i,j,kkk-1)
   284: |||||   A                   xyz_TransCloudOneLayerSorted(i,j,kkk) = &
   285: |||||                         & xyz_TransCloudOneLayerSorted(i,j,kkk-1)
   286: ||||V--                   end do
   287: ||||                      kkk = KInsPos
   288: ||||                      xyz_CloudCoverSorted        (i,j,kkk) = CloudCoverSortedCur
   289: ||||                      xyz_EffCloudCoverSorted     (i,j,kkk) = EffCloudCoverSortedCur
   290: ||||                      xyz_TransCloudOneLayerSorted(i,j,kkk) = TransCloudOneLayerSortedCur
   291: ||||        
   292: |||+---                 end do
   293: ||+----               end do
   294: ||          
   295: ||          
   296: ||          !!$            xyz_CloudCoverSorted         = xyz_CloudCover
   297: ||          !!$            do kkk = 1, kmax
   298: ||          !!$              xyz_CloudCoverSorted(:,:,kkk) = real( kmax-kkk ) / real(kmax)
   299: ||          !!$            end do
   300: ||          !!$            xyz_EffCloudCoverSorted      = xyz_EffCloudCover
   301: ||          !!$            xyz_TransCloudOneLayerSorted = xyz_TransCloudOneLayer
   302: ||          !!$
   303: ||          !!$            call SortQuick( imax, jmax, kk-k,             &
   304: ||          !!$              & xyz_CloudCoverSorted        (:,:,k+1:kk), &
   305: ||          !!$              & xyz_EffCloudCoverSorted     (:,:,k+1:kk), &
   306: ||          !!$              & xyz_TransCloudOneLayerSorted(:,:,k+1:kk)  &
   307: ||          !!$              & )
   308: ||          
   309: ||          
   310: ||          !!$            ! debug output
   311: ||          !!$            if ( ( k == 0 ) .and. ( kk == kmax-2 ) ) then
   312: ||          !!$              do kkk = k+1, kk
   313: ||          !!$                write( 6, * ) kkk, xyz_CloudCoverSorted(0,jmax/2+1,kkk)
   314: ||          !!$              end do
   315: ||          !!$              write( 6, * ) '-----'
   316: ||          !!$            end if
   317: ||          
   318: ||          
   319: ||W*=== A             xyrr_OverlappedCloudTrans(:,:,k,kk) = 0.0_DP
   320: ||+---->              do kkk = k+1, kk
   321: |||W*== A               xyrr_OverlappedCloudTrans(:,:,k,kk) =         &
   322: |||                       & xyz_EffCloudCoverSorted(:,:,kkk)          &
   323: |||                       & + xyrr_OverlappedCloudTrans(:,:,k,kk)     &
   324: |||                       &   * xyz_TransCloudOneLayerSorted(:,:,kkk)
   325: ||+----               end do
   326: ||W*=== A             xyrr_OverlappedCloudTrans(:,:,k,kk) = &
   327: ||                      & 1.0_DP - xyrr_OverlappedCloudTrans(:,:,k,kk)
   328: ||          
   329: |+-----             end do
   330: +------           end do
   331:             
   332:             
   333:             
   334: +------>          do k = 0, kmax
   335: |+----->            do kk = 0, k-1
   336: ||W*=== A             xyrr_OverlappedCloudTrans(:,:,k,kk) = xyrr_OverlappedCloudTrans(:,:,kk,k)
   337: |+-----             end do
   338: +------           end do
   339:             
   340:             
   341:                 end select
   342:             
   343:                 ! Output effective cloud cover
   344:                 !
   345:             !!$    call HistoryAutoPut( TimeN, 'EffCloudCover', &
   346:             !!$      & 1.0_DP - xyrr_OverlappedCloudTrans(:,:,0,kmax) )
   347:             
   348:             
   349:               end subroutine CloudUtilsCalcOverlapCloudTrans
   350:             
   351:               !--------------------------------------------------------------------------------------
   352:             
   353:               subroutine CloudUtilsSmearCloudOptDep(  &
   354:                 & xyz_CloudCover,                     & ! (in   )
   355:                 & xyz_DelCloudOptDep                  & ! (inout)
   356:                 & )
   357:             
   358:                 ! USE statements
   359:                 !
   360:             
   361:                 real(DP), intent(in   ) :: xyz_CloudCover    (0:imax-1, 1:jmax, 1:kmax)
   362:                 real(DP), intent(inout) :: xyz_DelCloudOptDep(0:imax-1, 1:jmax, 1:kmax)
   363:             
   364:             
   365:                 ! 実行文 ; Executable statement
   366:                 !
   367:             
   368:                 ! 初期化確認
   369:                 ! Initialization check
   370:                 !
   371:                 if ( .not. cloud_utils_inited ) then
   372:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   373:                 end if
   374:             
   375:             
   376:                 ! Cloud optical depth is scaled by the way of Kiehl et al. (1994).
   377:             
   378: W**==== A       xyz_DelCloudOptDep = xyz_DelCloudOptDep * xyz_CloudCover**1.5_DP
   379:             
   380:             
   381:               end subroutine CloudUtilsSmearCloudOptDep
   382:             
   383:               !--------------------------------------------------------------------------------------
   384:             
   385:               subroutine CloudUtilsLocalizeCloud(  &
   386:                 & xyz_CloudCover,                  & ! (in   )
   387:                 & xyz_DelCloudOptDep               & ! (inout)
   388:                 & )
   389:             
   390:                 ! USE statements
   391:                 !
   392:             
   393:                 real(DP), intent(in   ) :: xyz_CloudCover    (0:imax-1, 1:jmax, 1:kmax)
   394:                 real(DP), intent(inout) :: xyz_DelCloudOptDep(0:imax-1, 1:jmax, 1:kmax)
   395:             
   396:             
   397:                 ! 実行文 ; Executable statement
   398:                 !
   399:             
   400:                 ! 初期化確認
   401:                 ! Initialization check
   402:                 !
   403:                 if ( .not. cloud_utils_inited ) then
   404:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   405:                 end if
   406:             
   407:             
   408:                 ! Cloud optical depth is scaled by considering cloud cover less than 1. 
   409:             
   410: W**==== A       xyz_DelCloudOptDep = xyz_DelCloudOptDep / max( xyz_CloudCover, 1.0d-3 )
   411:             
   412:             
   413:               end subroutine CloudUtilsLocalizeCloud
   414:             
   415:               !--------------------------------------------------------------------------------------
   416:             
   417:               subroutine CloudUtilsPRCPStepPC1Grid(  &
   418:                 & PressLI, PressUI,                & ! (in   )
   419:                 & Temp,                            & ! (inout)
   420:                 & SurfRainFlux, SurfSnowFlux       & ! (out  )
   421:                 & )
   422:             
   423:                 ! 時刻管理
   424:                 ! Time control
   425:                 !
   426:                 use timeset, only: &
   427:                   & DelTime            ! $ \Delta t $ [s]
   428:             
   429:                 ! 物理定数設定
   430:                 ! Physical constants settings
   431:                 !
   432:                 use constants, only:  &
   433:                   & CpDry,            &
   434:                                           ! $ C_p $ [J kg-1 K-1].
   435:                                           ! 乾燥大気の定圧比熱.
   436:                                           ! Specific heat of air at constant pressure
   437:                   & Grav,             &
   438:                                           ! $ g $ [m s-2].
   439:                                           ! 重力加速度.
   440:                                           ! Gravitational acceleration
   441:                   & LatentHeatFusion
   442:                                           ! $ L $ [J kg-1] .
   443:                                           ! 融解の潜熱.
   444:                                           ! Latent heat of fusion
   445:             
   446:                 ! 雪と海氷の定数の設定
   447:                 ! Setting constants of snow and sea ice
   448:                 !
   449:                 use constants_snowseaice, only: TempCondWater
   450:             
   451:             
   452:             
   453:                 real(DP), intent(in   ) :: PressLI
   454:                 real(DP), intent(in   ) :: PressUI
   455:                 real(DP), intent(inout) :: Temp
   456:                 real(DP), intent(inout) :: SurfRainFlux
   457:                 real(DP), intent(inout) :: SurfSnowFlux
   458:             
   459:             
   460:                 ! 作業変数
   461:                 ! Work variables
   462:                 !
   463:                 real(DP) :: DelMass
   464:                 real(DP) :: MassMaxFreezeRate
   465:                 real(DP) :: MassFreezeRate
   466:                 real(DP) :: MassMaxMeltRate
   467:                 real(DP) :: MassMeltRate
   468:             
   469:             
   470:                 ! 初期化確認
   471:                 ! Initialization check
   472:                 !
   473:                 if ( .not. cloud_utils_inited ) then
   474:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   475:                 end if
   476:             
   477:             
   478:                 DelMass = ( PressLI - PressUI ) / Grav
   479:             
   480:                 ! Freezing and melting switching at temperature of TempCondWater
   481:             
   482:                 MassMaxFreezeRate =                    &
   483:                   &   CpDry * ( TempCondWater - Temp ) &
   484:                   & * DelMass                          &
   485:                   & / LatentHeatFusion                 &
   486:                   & / ( 2.0_DP * DelTime )
   487:                 if ( MassMaxFreezeRate >= 0.0_DP ) then
   488:                   ! freezing
   489:                   if ( SurfRainFlux >= MassMaxFreezeRate ) then
   490:                     MassFreezeRate = MassMaxFreezeRate
   491:                   else
   492:                     MassFreezeRate = SurfRainFlux
   493:                   end if
   494:                   SurfRainFlux = SurfRainFlux - MassFreezeRate
   495:                   SurfSnowFlux = SurfSnowFlux + MassFreezeRate
   496:                   Temp = Temp                                &
   497:                     & + LatentHeatFusion * MassFreezeRate * 2.0_DP * DelTime &
   498:                     &   / ( CpDry * DelMass )
   499:                 else
   500:                   ! melting
   501:                   MassMaxMeltRate = - MassMaxFreezeRate
   502:                   if ( SurfSnowFlux >= MassMaxMeltRate ) then
   503:                     MassMeltRate = MassMaxMeltRate
   504:                   else
   505:                     MassMeltRate = SurfSnowFlux
   506:                   end if
   507:                   SurfRainFlux = SurfRainFlux + MassMeltRate
   508:                   SurfSnowFlux = SurfSnowFlux - MassMeltRate
   509:                   Temp = Temp                              &
   510:                     & - LatentHeatFusion * MassMeltRate * 2.0_DP * DelTime &
   511:                     &   / ( CpDry * DelMass )
   512:                 end if
   513:             
   514:             
   515:               end subroutine CloudUtilsPRCPStepPC1Grid
   516:             
   517:               !----------------------------------------------------------------------------
   518:             
   519:               subroutine CloudUtilsPRCPEvap1Grid(           &
   520:                 & Press, PressLI, PressUI,            & ! (in)
   521:                 & PRCPArea, PRCPEvapArea,             & ! (in)
   522:                 & Temp, QH2OVap,                      & ! (inout)
   523:                 & SurfRainFlux, SurfSnowFlux          & ! (inout)
   524:                 & )
   525:             
   526:                 ! USE statements
   527:                 !
   528:             
   529:                 ! 時刻管理
   530:                 ! Time control
   531:                 !
   532:                 use timeset, only: &
   533:                   & DelTime            ! $ \Delta t $ [s]
   534:             
   535:                 ! 物理定数設定
   536:                 ! Physical constants settings
   537:                 !
   538:                 use constants, only: &
   539:                   & Grav
   540:                                           ! $ g $ [m s-2].
   541:                                           ! 重力加速度.
   542:                                           ! Gravitational acceleration
   543:             
   544:                 real(DP), intent(in   ) :: Press
   545:                 real(DP), intent(in   ) :: PressLI
   546:                 real(DP), intent(in   ) :: PressUI
   547:                 real(DP), intent(in   ) :: PRCPArea
   548:                 real(DP), intent(in   ) :: PRCPEvapArea
   549:                 real(DP), intent(inout) :: Temp
   550:                 real(DP), intent(inout) :: QH2OVap
   551:                 real(DP), intent(inout) :: SurfRainFlux
   552:                 real(DP), intent(inout) :: SurfSnowFlux
   553:             
   554:             
   555:                 ! Local variables
   556:                 !
   557:                 real(DP) :: DelTemp
   558:                 real(DP) :: DelQH2OVap
   559:             
   560:                 real(DP) :: DelMass
   561:             
   562:                 real(DP) :: QH2OVapSat
   563:                 real(DP) :: PRCPFlux
   564:                 real(DP) :: DelPRCPFlux
   565:             !!$    real(DP) :: DelQH2OVap
   566:                 character(STRING) :: CharPhase
   567:             
   568:             
   569:                 integer :: l
   570:             
   571:             
   572:                 ! 実行文 ; Executable statement
   573:                 !
   574:             
   575:                 ! 初期化確認
   576:                 ! Initialization check
   577:                 !
   578:                 if ( .not. cloud_utils_inited ) then
   579:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   580:                 end if
   581:             
   582:             
   583:                 DelMass = ( PressLI - PressUI ) / Grav
   584:             
   585:             
   586: +------>        do l = 1, 2
   587: |           
   588: |                 select case ( l )
   589: |                 case ( 1 ) ! liquid
   590: |                   CharPhase = 'liquid'
   591: |                   PRCPFlux = SurfRainFlux
   592: |                 case ( 2 ) ! solid
   593: |                   CharPhase = 'solid'
   594: |                   PRCPFlux = SurfSnowFlux
   595: |                 case default
   596: |                   call MessageNotify( 'E', module_name, 'Unexpected number for select case.' )
   597: |                 end select
   598: |           
   599: |                 call CloudUtilsPRCPEvap1GridCore( &
   600: |                   & ( 2.0_DP * DelTime ),             & ! (in)
   601: |                   & CharPhase,                        & ! (in)
   602: |                   & DelMass, Press, Temp, QH2OVap,    & ! (in)
   603: |                   & PRCPFlux,                         & ! (in)
   604: |                   & PRCPArea, PRCPEvapArea,           & ! (in)
   605: |                   & DelPRCPFlux, DelTemp, DelQH2OVap  & ! (out)
   606: |                   & )
   607: |           
   608: |                 select case ( l )
   609: |                 case ( 1 ) ! liquid
   610: |                   SurfRainFlux = PRCPFlux + DelPRCPFlux
   611: |                 case ( 2 ) ! solid
   612: |                   SurfSnowFlux = PRCPFlux + DelPRCPFlux
   613: |                 case default
   614: |                   call MessageNotify( 'E', module_name, 'Unexpected number for select case.' )
   615: |                 end select
   616: |                 QH2OVap    = QH2OVap + DelQH2OVap
   617: |                 Temp       = Temp    + DelTemp
   618: +------         end do
   619:             
   620:             
   621:               end subroutine CloudUtilsPRCPEvap1Grid
   622:             
   623:               !--------------------------------------------------------------------------------------
   624:             
   625:               subroutine CloudUtilsPRCPEvap1GridCore( &
   626:                 & TimeStep,                           & ! (in)
   627:                 & CharPhase,                          & ! (in)
   628:                 & DelMass, Press, Temp, QH2OVap,      & ! (in)
   629:                 & PRCPFlux,                           & ! (in)
   630:                 & PRCPArea, PRCPEvapArea,             & ! (in)
   631:                 & DelPRCPFlux, DelTemp, DelQH2OVap    & ! (out)
   632:                 & )
   633:             
   634:                 ! 物理・数学定数設定
   635:                 ! Physical and mathematical constants settings
   636:                 !
   637:                 use constants0, only: &
   638:                   & PI                    ! $ \pi $ .
   639:                                           ! 円周率.  Circular constant
   640:             
   641:                 ! 物理定数設定
   642:                 ! Physical constants settings
   643:                 !
   644:                 use constants, only: &
   645:                   & Grav, &
   646:                                           ! $ g $ [m s-2].
   647:                                           ! 重力加速度.
   648:                                           ! Gravitational acceleration
   649:                   & CpDry, &
   650:                                           ! $ C_p $ [J kg-1 K-1].
   651:                                           ! 乾燥大気の定圧比熱.
   652:                                           ! Specific heat of air at constant pressure
   653:                   & GasRDry, &
   654:                                           ! $ R $ [J kg-1 K-1].
   655:                                           ! 乾燥大気の気体定数.
   656:                                           ! Gas constant of air
   657:                   & LatentHeat, &
   658:                                           ! $ L $ [J kg-1] .
   659:                                           ! 凝結の潜熱.
   660:                                           ! Latent heat of condensation
   661:                   & LatentHeatFusion, &
   662:                                           ! $ L $ [J kg-1] .
   663:                                           ! 融解の潜熱.
   664:                                           ! Latent heat of fusion
   665:                   & EpsV
   666:                                           ! $ \epsilon_v $ .
   667:                                           ! 水蒸気分子量比.
   668:                                           ! Molecular weight of water vapor
   669:             
   670:                 ! 飽和比湿の算出
   671:                 ! Evaluate saturation specific humidity
   672:                 !
   673:                 use saturate, only:         &
   674:                   & CalcQVapSatOnLiq,       &
   675:                   & CalcDQVapSatDTempOnLiq, &
   676:                   & CalcQVapSatOnSol,       &
   677:                   & CalcDQVapSatDTempOnSol
   678:             
   679:             
   680:                 real(DP)    , intent(in ) :: TimeStep
   681:                 character(*), intent(in ) :: CharPhase
   682:                 real(DP)    , intent(in ) :: DelMass
   683:                 real(DP)    , intent(in ) :: Press
   684:                 real(DP)    , intent(in ) :: Temp
   685:                 real(DP)    , intent(in ) :: QH2OVap
   686:                 real(DP)    , intent(in ) :: PRCPFlux
   687:                 real(DP)    , intent(in ) :: PRCPArea
   688:                 real(DP)    , intent(in ) :: PRCPEvapArea
   689:                 real(DP)    , intent(out) :: DelPRCPFlux
   690:                 real(DP)    , intent(out) :: DelTemp
   691:                 real(DP)    , intent(out) :: DelQH2OVap
   692:             
   693:             
   694:                 ! Parameters for evaporation of rain
   695:                 real(DP), parameter :: DensWater            = 1.0d3
   696:                 !                            rho_w
   697:                 real(DP)            :: CCNND
   698:                 !                            number density of CCN, N0 or Nt (m-3)
   699:                 real(DP), parameter :: H2OVapDiffCoef       = 1.0d-5
   700:                 !                            Kd
   701:                 real(DP), parameter :: PRCPFallVel0         = 10.0_DP
   702:                 !                            m s-1
   703:             
   704:                 real(DP) :: PRCPFallVelRatio
   705:                 real(DP) :: PRCPFallVelFactor
   706:             
   707:                 real(DP) :: PRCPFallVel
   708:                 !                            m s-1
   709:             
   710:                 real(DP) :: Dens
   711:                 !                           rho
   712:                 real(DP) :: DensPRCP
   713:                 !                           (rho q_r)
   714:             
   715:                 real(DP) :: DelZ
   716:             
   717:                 real(DP) :: FactorF
   718:                 real(DP) :: FactorG
   719:                 real(DP) :: FactorH
   720:                 real(DP) :: FactorI
   721:             
   722:                 real(DP) :: LatentHeatSubl
   723:                 real(DP) :: LatentHeatLocal
   724:             
   725:                 real(DP) :: VirTemp
   726:                 real(DP) :: QH2OVapSat
   727:                 real(DP) :: DQH2OVapSatDTemp
   728:                 real(DP) :: QH2OVapSatA
   729:             
   730:                 real(DP) :: TempN
   731:                 real(DP) :: QH2OVapN
   732:                 real(DP) :: PRCPN
   733:                 real(DP) :: TempA
   734:                 real(DP) :: QH2OVapA
   735:                 real(DP) :: PRCPA
   736:             
   737:                 real(DP) :: DelPRCP
   738:             
   739:                 real(DP), parameter :: DelTempThreshold = 1.0e-2_DP
   740:                 integer, parameter :: ItrMax = 100
   741:                 real(DP) :: a_DelTemp(ItrMax)
   742:             
   743:                 integer :: itr
   744:             
   745:             
   746:                 LatentHeatSubl = LatentHeat + LatentHeatFusion
   747:             
   748:             
   749:                 select case ( CharPhase )
   750:                 case ( 'liquid' )
   751:                   ! for liquid water
   752:                   PRCPFallVelRatio = 1.0_DP
   753:                   LatentHeatLocal  = LatentHeat
   754:                 case ( 'solid' )
   755:                   ! for solid water (ice)
   756:                   PRCPFallVelRatio = 0.5_DP
   757:                   LatentHeatLocal  = LatentHeatSubl
   758:                 case default
   759:                   call MessageNotify( 'E', module_name, 'Unexpected character for select case.' )
   760:                 end select
   761:             
   762:             
   763:                 VirTemp = Temp * ( 1.0_DP + ((( 1.0_DP / EpsV ) - 1.0_DP ) * QH2OVap) )
   764:                 Dens = Press / ( GasRDry * VirTemp )
   765:                 DelZ = DelMass / Dens
   766:             
   767:                 PRCPFallVel = PRCPFallVel0 * PRCPFallVelRatio
   768:             !!$    DensPRCP = ( PRCPFlux / ( PRCPArea + 1.0e-10_DP ) ) / PRCPFallVel
   769:                 DensPRCP = ( max( PRCPFlux, 0.0_DP ) / ( PRCPArea + 1.0e-10_DP ) ) / PRCPFallVel
   770:             
   771:                 ! cloud condensation
   772:                 CCNND = CCNMixRatPerUnitMass * Dens
   773:             
   774:                 FactorF =                                                          &
   775:                   &   Dens * H2OVapDiffCoef * PRCPEvapArea                         &
   776:                   & * ( 48.0_DP * ( PI * CCNND )**2 / DensWater * DensPRCP )**(1.0_DP/3.0_DP)
   777:                 FactorG = DelZ * TimeStep * FactorF
   778:                 FactorH = FactorG / DelMass
   779:                 FactorI = LatentHeatLocal / CpDry * FactorH
   780:             
   781:                 TempN    = Temp
   782:                 QH2OVapN = QH2OVap
   783:             !!$    PRCPN    = PRCPFlux * TimeStep
   784:                 PRCPN    = max( PRCPFlux, 0.0_DP ) * TimeStep
   785: +------>        loop_evap : do itr = 1, ItrMax
   786: |           
   787: |                 select case ( CharPhase )
   788: |                 case ( 'liquid' )
   789: |                   ! for liquid water
   790: |                   QH2OVapSat       = CalcQVapSatOnLiq( TempN, Press )
   791: |                   DQH2OVapSatDTemp = CalcDQVapSatDTempOnLiq( TempN, QH2OVapSat )
   792: |                 case ( 'solid' )
   793: |                   ! for solid water (ice)
   794: |                   QH2OVapSat       = CalcQVapSatOnSol( TempN, Press )
   795: |                   DQH2OVapSatDTemp = CalcDQVapSatDTempOnSol( TempN, QH2OVapSat )
   796: |                 case default
   797: |                   call MessageNotify( 'E', module_name, 'Unexpected character for select case.' )
   798: |                 end select
   799: |           
   800: |                 DelTemp = - FactorI * ( QH2OVapSat - QH2OVapN ) &
   801: |                   &           / ( 1.0_DP + FactorH + FactorI * DQH2OVapSatDTemp )
   802: |           
   803: |                 DelQH2OVap = - CpDry * DelTemp / LatentHeatLocal
   804: |                 DelPRCP    = - DelQH2OVap * DelMass
   805: |           
   806: |                 if ( ( PRCPN + DelPRCP ) >= 0.0_DP ) then
   807: |                   ! part of precipitation is evaporated
   808: |                   ! nothing to do
   809: |                 else
   810: |                   ! all precipitation is evaporated
   811: |                   DelPRCP    = - PRCPN
   812: |                   DelQH2OVap = - DelPRCP / DelMass
   813: |                   DelTemp    = - LatentHeatLocal * DelQH2OVap / CpDry
   814: |                 end if
   815: |           
   816: |           
   817: |                 if ( abs( DelTemp ) < DelTempThreshold ) exit loop_evap
   818: |           
   819: |                 PRCPA    = PRCPN    + DelPRCP
   820: |                 TempA    = TempN    + DelTemp
   821: |                 QH2OVapA = QH2OVapN + DelQH2OVap
   822: |           
   823: |                 PRCPN    = PRCPA
   824: |                 TempN    = TempA
   825: |                 QH2OVapN = QH2OVapA
   826: |           
   827: |                 a_DelTemp(itr) = DelTemp
   828: +------         end do loop_evap
   829:                 if ( itr > 100 ) then
   830:                   write( 6, * ) a_DelTemp
   831:                   call MessageNotify( 'E', module_name, 'Evaporation loop is not convergent, %d, %f.', i = (/ itr /), d = (/ DelTemp /) )
   832:                 end if
   833:             
   834:                 DelPRCPFlux = DelPRCP / TimeStep
   835:             
   836:             
   837:               end subroutine CloudUtilsPRCPEvap1GridCore
   838:             
   839:               !--------------------------------------------------------------------------------------
   840:             
   841:               subroutine CloudUtilsPRCPEvap1GridCoreExp( &
   842:                 & CharPhase,                                    & ! (in)
   843:                 & DelMass, Press, QH2OVap, QH2OVapSat, VirTemp, & ! (in)
   844:                 & PRCP,                                         & ! (in)
   845:                 & PRCPArea, PRCPEvapArea,                       & ! (in)
   846:                 & DelPRCPFlux                                   & ! (out)
   847:                 & )
   848:             
   849:                 ! 物理・数学定数設定
   850:                 ! Physical and mathematical constants settings
   851:                 !
   852:                 use constants0, only: &
   853:                   & PI                    ! $ \pi $ .
   854:                                           ! 円周率.  Circular constant
   855:             
   856:                 ! 物理定数設定
   857:                 ! Physical constants settings
   858:                 !
   859:                 use constants, only: &
   860:                   & Grav, &
   861:                                           ! $ g $ [m s-2].
   862:                                           ! 重力加速度.
   863:                                           ! Gravitational acceleration
   864:                   & GasRDry
   865:                                           ! $ R $ [J kg-1 K-1].
   866:                                           ! 乾燥大気の気体定数.
   867:                                           ! Gas constant of air
   868:             
   869:             
   870:                 character(*), intent(in ) :: CharPhase
   871:                 real(DP)    , intent(in ) :: DelMass
   872:                 real(DP)    , intent(in ) :: Press
   873:                 real(DP)    , intent(in ) :: QH2OVap
   874:                 real(DP)    , intent(in ) :: QH2OVapSat
   875:                 real(DP)    , intent(in ) :: VirTemp
   876:                 real(DP)    , intent(in ) :: PRCP
   877:                 real(DP)    , intent(in ) :: PRCPArea
   878:                 real(DP)    , intent(in ) :: PRCPEvapArea
   879:                 real(DP)    , intent(out) :: DelPRCPFlux
   880:             
   881:             
   882:                 ! Parameters for evaporation of rain
   883:                 real(DP), parameter :: DensWater            = 1.0d3
   884:                 !                            rho_w
   885:                 !   Values below are from Kessler (1969)
   886:                 real(DP), parameter :: PRCPFallVelFactor0        = 130.0d0
   887:                 !                            K
   888:                 real(DP), parameter :: MedianDiameterFactor      = 3.67d0
   889:                 !                            C'
   890:                 real(DP), parameter :: PRCPDistFactor            = 1.0d7
   891:                 !                            N0
   892:                 real(DP), parameter :: PRCPEvapRatUnitDiamFactor = 2.24d3
   893:                 !                            C
   894:                 real(DP), parameter :: H2OVapDiffCoef            = 1.0d-5
   895:                 !                            Kd
   896:             
   897:                 real(DP), parameter :: PRCPFallVelSimple0        = 10.0d0
   898:                 !                            m s-1
   899:             
   900:                 real(DP) :: PRCPFallVelRatio
   901:                 real(DP) :: PRCPFallVelFactor
   902:             
   903:                 real(DP) :: Dens0
   904:                 !                            rho_0
   905:                 real(DP) :: V00
   906:                 !                            V_{00}
   907:                 real(DP) :: PRCPEvapFactor
   908:             
   909:                 real(DP) :: Dens
   910:                 !                           rho
   911:                 real(DP) :: DensPRCP
   912:                 !                           (rho q_r)
   913:             !!$    real(DP) :: RainArea
   914:             !!$    !                           a_p
   915:             !!$    real(DP) :: RainEvapArea
   916:             !!$    !                           A = max( a_p - a, 0 )
   917:             !!$    real(DP) :: xy_CloudCover   (0:imax-1, 1:jmax)
   918:             !!$    !                           a
   919:                 real(DP) :: PRCPEvapRate
   920:             
   921:                 real(DP) :: DelZ
   922:             
   923:             
   924:                 select case ( CharPhase )
   925:                 case ( 'liquid' )
   926:                   ! for liquid water
   927:                   PRCPFallVelRatio = 1.0_DP
   928:                 case ( 'solid' )
   929:                   ! for solid water (ice)
   930:                   PRCPFallVelRatio = 0.5_DP
   931:                 case ( 'mixture' )
   932:                   ! for mixture, this is only for test
   933:                   PRCPFallVelRatio = 1.0_DP
   934:                 case default
   935:                   call MessageNotify( 'E', module_name, 'Unexpected character for select case.' )
   936:                 end select
   937:                 !
   938:             
   939:                 ! Values for evaporation of rain
   940:                 Dens = Press / ( GasRDry * VirTemp )
   941:             
   942:                 DelZ = DelMass / Dens
   943:             
   944:             
   945:                 if ( .false. ) then ! ECMWF version
   946:             
   947:                   PRCPFallVelFactor = PRCPFallVelFactor0 * PRCPFallVelRatio
   948:             
   949:                   ! Parameters for evaporation of rain
   950:                   Dens0 = 1013.0d2 / ( GasRDry * 300.0_DP )
   951:                   V00 = PRCPFallVelFactor * sqrt( MedianDiameterFactor ) &
   952:                     & / ( PI * DensWater * PRCPDistFactor )**(1.0d0/8.0d0)
   953:                   PRCPEvapFactor =                                      &
   954:             !      & RainEvapRatUnitDiamFactor * gamma( 13.0d0/5.0d0 ) &
   955:                     & PRCPEvapRatUnitDiamFactor * 1.429624558860304d0   &
   956:                     & * H2OVapDiffCoef * PRCPDistFactor**(7.0d0/20.0d0) &
   957:                     & / ( PI * DensWater )**(13.0d0/20.0d0)
   958:             
   959:             !!$    RainArea   = RainArea
   960:             !!$    xy_CloudCover = CloudCover
   961:             !!$    xy_RainEvapArea = max( xy_RainArea - xy_CloudCover, 0.0_DP )
   962:             !!$    RainEvapArea = RainEvapArea
   963:             
   964:                   DensPRCP =                                                   &
   965:                     & ( PRCP / ( PRCPArea + 1.0d-10 )                          &
   966:                     &   / ( V00 * sqrt( Dens0 / Dens ) ) )**(8.0d0/9.0d0)
   967:                   PRCPEvapRate =                                      &
   968:                     & Dens * PRCPEvapArea * PRCPEvapFactor            &
   969:                     &   * max( QH2OVapSat - QH2OVap, 0.0_DP )         &
   970:                     &   * DensPRCP**(13.0d0/20.0d0)
   971:             
   972:                 else ! simple version
   973:             
   974:                   V00 = PRCPFallVelSimple0 * PRCPFallVelRatio
   975:             
   976:                   PRCPEvapFactor =                                                 &
   977:                     & ( 48.0_DP * ( PI * PRCPDistFactor )**2 / DensWater )**(1.0_DP/3.0_DP) &
   978:                     & * H2OVapDiffCoef
   979:             
   980:                   DensPRCP =                                                   &
   981:                     & ( PRCP / ( PRCPArea + 1.0d-10 ) )                        &
   982:                     &   / V00
   983:                   PRCPEvapRate =                                      &
   984:                     & Dens * PRCPEvapArea * PRCPEvapFactor            &
   985:                     &   * max( QH2OVapSat - QH2OVap, 0.0_DP )         &
   986:                     &   * DensPRCP**(1.0_DP/3.0_DP)
   987:             
   988:                 end if
   989:             
   990:                 ! PRCPEvapRate (kg m-3 s-1)
   991:                 ! DelZ         (m)
   992:                 ! DelPRCPFlux  (kg m-2 s-1)
   993:                 DelPRCPFlux = PRCPEvapRate * DelZ
   994:             
   995:                 DelPRCPFlux = min( DelPRCPFlux, PRCP )
   996:             
   997:             
   998:               end subroutine CloudUtilsPRCPEvap1GridCoreExp
   999:             
  1000:               !--------------------------------------------------------------------------------------
  1001:             
  1002:               subroutine CloudUtilConsChk(                             &
  1003:                 & ParentRoutineName,                                   &
  1004:             !!$    & FlagIncludeSnowPhaseChange,                          &
  1005:                 & xyr_Press,                                           &
  1006:                 & xyz_TempB, xyz_QH2OVapB, xyz_QH2OLiqB, xyz_QH2OSolB, &
  1007:                 & xyz_Temp , xyz_QH2OVap , xyz_QH2OLiq , xyz_QH2OSol , &
  1008:                 & xy_Rain, xy_Snow                                     &
  1009:                 & )
  1010:             
  1011:             
  1012:                 ! 時刻管理
  1013:                 ! Time control
  1014:                 !
  1015:                 use timeset, only: &
  1016:                   & DelTime            ! $ \Delta t $ [s]
  1017:             
  1018:                 ! 物理定数設定
  1019:                 ! Physical constants settings
  1020:                 !
  1021:                 use constants, only: &
  1022:                   & Grav, & 
  1023:                                           ! $ g $ [m s-2]. 
  1024:                                           ! 重力加速度. 
  1025:                                           ! Gravitational acceleration
  1026:                   & CpDry, &
  1027:                                           ! $ C_p $ [J kg-1 K-1]. 
  1028:                                           ! 乾燥大気の定圧比熱. 
  1029:                                           ! Specific heat of air at constant pressure
  1030:                   & LatentHeat, &
  1031:                                           ! $ L $ [J kg-1] . 
  1032:                                           ! 凝結の潜熱. 
  1033:                                           ! Latent heat of condensation
  1034:                   & LatentHeatFusion
  1035:                                           ! $ L $ [J kg-1] .
  1036:                                           ! 融解の潜熱.
  1037:                                           ! Latent heat of fusion
  1038:             
  1039:                 character(*), intent(in) :: ParentRoutineName
  1040:             !!$    logical , intent(in) :: FlagIncludeSnowPhaseChange
  1041:                 real(DP), intent(in) :: xyr_Press   (0:imax-1, 1:jmax, 0:kmax)
  1042:                 real(DP), intent(in) :: xyz_TempB   (0:imax-1, 1:jmax, 1:kmax)
  1043:                 real(DP), intent(in) :: xyz_QH2OVapB(0:imax-1, 1:jmax, 1:kmax)
  1044:                 real(DP), intent(in) :: xyz_QH2OLiqB(0:imax-1, 1:jmax, 1:kmax)
  1045:                 real(DP), intent(in) :: xyz_QH2OSolB(0:imax-1, 1:jmax, 1:kmax)
  1046:                 real(DP), intent(in) :: xyz_Temp    (0:imax-1, 1:jmax, 1:kmax)
  1047:                 real(DP), intent(in) :: xyz_QH2OVap (0:imax-1, 1:jmax, 1:kmax)
  1048:                 real(DP), intent(in) :: xyz_QH2OLiq (0:imax-1, 1:jmax, 1:kmax)
  1049:                 real(DP), intent(in) :: xyz_QH2OSol (0:imax-1, 1:jmax, 1:kmax)
  1050:                 real(DP), intent(in) :: xy_Rain     (0:imax-1, 1:jmax)
  1051:                 real(DP), intent(in) :: xy_Snow     (0:imax-1, 1:jmax)
  1052:             
  1053:                 ! Local variables
  1054:                 !
  1055:                 real(DP) :: xyz_DelMass(0:imax-1, 1:jmax, 1:kmax)
  1056:                 real(DP) :: xy_Val(0:imax-1, 1:jmax)
  1057:                 real(DP) :: xy_SumB(0:imax-1, 1:jmax)
  1058:                 real(DP) :: xy_Sum(0:imax-1, 1:jmax)
  1059:                 real(DP) :: xy_Ratio(0:imax-1, 1:jmax)
  1060:                 integer  :: i
  1061:                 integer  :: j
  1062:                 integer  :: k
  1063:             
  1064:             
  1065: W------>        do k = 1, kmax
  1066: |**==== A         xyz_DelMass(:,:,k) = ( xyr_Press(:,:,k-1) - xyr_Press(:,:,k) ) / Grav
  1067: W------         end do
  1068:             
  1069: W*=====         xy_Sum = 0.0_DP
  1070: +------>        do k = kmax, 1, -1
  1071: |*W---->A         xy_Val =   CpDry * xyz_TempB(:,:,k)               &
  1072: |||                 &      + LatentHeat * xyz_QH2OVapB(:,:,k)       &
  1073: |||                 &      - LatentHeatFusion * xyz_QH2OSolB(:,:,k)
  1074: |*W---- A         xy_Sum = xy_Sum + xy_Val * xyz_DelMass(:,:,k)
  1075: +------         end do
  1076:             
  1077: *W----->A       xy_SumB = xy_Sum
  1078: ||          
  1079: *W----- A       xy_Sum = 0.0_DP
  1080: +------>        do k = kmax, 1, -1
  1081: |*W---->A         xy_Val =   CpDry * xyz_Temp (:,:,k)               &
  1082: |||                 &      + LatentHeat * xyz_QH2OVap (:,:,k)       &
  1083: |||                 &      - LatentHeatFusion * xyz_QH2OSol (:,:,k)
  1084: |*W---- A         xy_Sum = xy_Sum + xy_Val * xyz_DelMass(:,:,k)
  1085: +------         end do
  1086:             !!$    if ( FlagIncludeSnowPhaseChange ) then
  1087: *W----->A         xy_Sum = xy_Sum - LatentHeatFusion * xy_Snow * 2.0_DP * DelTime
  1088: ||          !!$    end if
  1089: ||          
  1090: *W-----         xy_Ratio = ( xy_Sum - xy_SumB ) / ( xy_Sum + 1.0d-100 )
  1091: +------>        do j = 1, jmax
  1092: |+----->          do i = 0, imax-1
  1093: ||                  if ( abs( xy_Ratio(i,j) ) > 1.0d-10 ) then
  1094: ||                    call MessageNotify( 'M', module_name, '%c, Modified condensate static energy is not conserved, %f.', &
  1095: ||                      & c1 = trim(ParentRoutineName), d = (/ xy_Ratio(i,j) /) )
  1096: ||                  end if
  1097: |+-----           end do
  1098: +------         end do
  1099:             
  1100:             
  1101:             
  1102: W*=====         xy_Sum = 0.0_DP
  1103: +------>        do k = kmax, 1, -1
  1104: |*W---->A         xy_Val = xyz_QH2OVapB(:,:,k) + xyz_QH2OLiqB(:,:,k) + xyz_QH2OSolB(:,:,k)
  1105: |*W---- A         xy_Sum = xy_Sum + xy_Val * xyz_DelMass(:,:,k)
  1106: +------         end do
  1107:             
  1108: *W----->A       xy_SumB = xy_Sum
  1109: ||          
  1110: *W----- A       xy_Sum = 0.0_DP
  1111: +------>        do k = kmax, 1, -1
  1112: |*W---->A         xy_Val = xyz_QH2OVap (:,:,k) + xyz_QH2OLiq (:,:,k) + xyz_QH2OSol (:,:,k)
  1113: |*W---- A         xy_Sum = xy_Sum + xy_Val * xyz_DelMass(:,:,k)
  1114: +------         end do
  1115: *W----->A       xy_Sum = xy_Sum + ( xy_Rain + xy_Snow ) * 2.0_DP * DelTime
  1116: ||          
  1117: *W-----         xy_Ratio = ( xy_Sum - xy_SumB ) / ( xy_Sum + 1.0d-100 )
  1118: +------>        do j = 1, jmax
  1119: |+----->          do i = 0, imax-1
  1120: ||                  if ( abs( xy_Ratio(i,j) ) > 1.0d-10 ) then
  1121: ||                    call MessageNotify( 'M', module_name, '%c, H2O mass is not conserved, %f.', &
  1122: ||                      & c1 = trim(ParentRoutineName), d = (/ xy_Ratio(i,j) /) )
  1123: ||                  end if
  1124: |+-----           end do
  1125: +------         end do
  1126:             
  1127:             
  1128:               end subroutine CloudUtilConsChk
  1129:             
  1130:               !--------------------------------------------------------------------------------------
  1131:             
  1132:               subroutine CloudUtilsInit( &
  1133:                 & ArgFlagSnow            &
  1134:                 & )
  1135:             
  1136:                 ! ファイル入出力補助
  1137:                 ! File I/O support
  1138:                 !
  1139:                 use dc_iounit, only: FileOpen
  1140:             
  1141:                 ! NAMELIST ファイル入力に関するユーティリティ
  1142:                 ! Utilities for NAMELIST file input
  1143:                 !
  1144:                 use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid
  1145:             
  1146:                 ! ヒストリデータ出力
  1147:                 ! History data output
  1148:                 !
  1149:                 use gtool_historyauto, only: HistoryAutoAddVariable
  1150:             
  1151:                 ! 飽和比湿の算出
  1152:                 ! Evaluate saturation specific humidity
  1153:                 !
  1154:                 use saturate, only: &
  1155:                   & SaturateInit
  1156:             
  1157:             
  1158:                 ! 宣言文 ; Declaration statements
  1159:                 !
  1160:             
  1161:                 logical, intent(in) :: ArgFlagSnow
  1162:             
  1163:             
  1164:                 character(STRING) :: CloudOverlapType
  1165:             
  1166:                 integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号.
  1167:                                           ! Unit number for NAMELIST file open
  1168:                 integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT.
  1169:                                           ! IOSTAT of NAMELIST read
  1170:             
  1171:                 ! NAMELIST 変数群
  1172:                 ! NAMELIST group name
  1173:                 !
  1174:                 namelist /cloud_utils_nml/  &
  1175:                   & CloudOverlapType,       &
  1176:                   & CCNMixRatPerUnitMass
  1177:                       !
  1178:                       ! デフォルト値については初期化手続 "cloud_utils#CloudUtilsInit"
  1179:                       ! のソースコードを参照のこと.
  1180:                       !
  1181:                       ! Refer to source codes in the initialization procedure
  1182:                       ! "cloud_utils#CloudUtilsInit" for the default values.
  1183:                       !
  1184:             
  1185:                 ! 実行文 ; Executable statement
  1186:                 !
  1187:             
  1188:                 if ( cloud_utils_inited ) return
  1189:             
  1190:             
  1191:                 FlagSnow = ArgFlagSnow
  1192:             
  1193:             
  1194:                 ! デフォルト値の設定
  1195:                 ! Default values settings
  1196:                 !
  1197:             
  1198:                 CloudOverlapType    = "Random"
  1199:             !!$    CloudOverlapType    = "MaxOverlap"
  1200:             
  1201:                 CCNMixRatPerUnitMass = 1.0e8_DP
  1202:             
  1203:             
  1204:                 ! NAMELIST の読み込み
  1205:                 ! NAMELIST is input
  1206:                 !
  1207:                 if ( trim(namelist_filename) /= '' ) then
  1208:                   call FileOpen( unit_nml, &          ! (out)
  1209:                     & namelist_filename, mode = 'r' ) ! (in)
  1210:             
  1211:                   rewind( unit_nml )
  1212:                   read( unit_nml,                     & ! (in)
  1213:                     & nml = cloud_utils_nml,          & ! (out)
  1214:                     & iostat = iostat_nml )             ! (out)
  1215:                   close( unit_nml )
  1216:             
  1217:                   call NmlutilMsg( iostat_nml, module_name ) ! (in)
  1218:                 end if
  1219:             
  1220:             
  1221:                 select case ( CloudOverlapType )
  1222:                 case ( 'Random' )
  1223:                   IDCloudOverlapType = IDCloudOverlapTypeRandom
  1224:                 case ( 'MaxOverlap' )
  1225:                   IDCloudOverlapType = IDCloudOverlapTypeMaxOverlap
  1226:                 case default
  1227:                   call MessageNotify( 'E', module_name,         &
  1228:                     & 'CloudOverlapType=<%c> is not supported.', &
  1229:                     & c1 = trim(CloudOverlapType) )
  1230:                 end select
  1231:             
  1232:             
  1233:                 ! Initialization of modules used in this module
  1234:                 !
  1235:             
  1236:                 ! 飽和比湿の算出
  1237:                 ! Evaluate saturation specific humidity
  1238:                 !
  1239:                 call SaturateInit
  1240:             
  1241:             
  1242:                 ! ヒストリデータ出力のためのへの変数登録
  1243:                 ! Register of variables for history data output
  1244:                 !
  1245:             !!$    call HistoryAutoAddVariable( 'EffCloudCover', &
  1246:             !!$      & (/ 'lon ', 'lat ', 'time' /), &
  1247:             !!$      & 'effective cloud cover', '1' )
  1248:             
  1249:             
  1250:             
  1251:                 ! 印字 ; Print
  1252:                 !
  1253:                 call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
  1254:                 call MessageNotify( 'M', module_name, 'CloudOverlapType     = %c', c1 = trim(CloudOverlapType) )
  1255:                 call MessageNotify( 'M', module_name, 'CCNMixRatPerUnitMass = %f', d = (/ CCNMixRatPerUnitMass /) )
  1256:                 call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
  1257:             
  1258:                 cloud_utils_inited = .true.
  1259:             
  1260:               end subroutine CloudUtilsInit
  1261:             
  1262:               !--------------------------------------------------------------------------------------
  1263:             
  1264:             end module cloud_utils
