Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:55 2016
FILE NAME: grav_sed.f90
PROGRAM NAME: grav_sed
DIAGNOSTIC LIST

  LINE  LEVEL( NO.): DIAGNOSTIC MESSAGE

   247  opt  (1772): Loop nest fused with following nest(s).
   247  opt  (1593): Loop nest collapsed into one loop.
   247  vec  (   1): Vectorized loop.
   247  vec  (  29): ADB is used for array.: xyr_height
   247  vec  (  29): ADB is used for array.: xyr_press
   257  opt  (1593): Loop nest collapsed into one loop.
   257  vec  (   4): Vectorized array expression.
   257  vec  (  29): ADB is used for array.: xyz_qmix
   273  opt  (1593): Loop nest collapsed into one loop.
   273  vec  (   4): Vectorized array expression.
   273  vec  (  29): ADB is used for array.: xyr_partdia
   275  opt  (1593): Loop nest collapsed into one loop.
   275  vec  (   4): Vectorized array expression.
   275  vec  (  29): ADB is used for array.: xyr_press
   281  opt  (1592): Outer loop unrolled inside inner loop.
   281  vec  (   4): Vectorized array expression.
   281  vec  (  29): ADB is used for array.: xyr_sedvel
   281  vec  (   4): Vectorized array expression.
   281  vec  (  29): ADB is used for array.: xyr_sedvel
   297  opt  (1592): Outer loop unrolled inside inner loop.
   297  vec  (   4): Vectorized array expression.
   297  vec  (  29): ADB is used for array.: xyr_partdia
   297  vec  (   4): Vectorized array expression.
   297  vec  (  29): ADB is used for array.: xyr_partdia
   319  opt  (  11): Fused array assignments. :line 319 - 325
   319  opt  (1593): Loop nest collapsed into one loop.
   319  vec  (   4): Vectorized array expression.
   319  vec  (  29): ADB is used for array.: xyz_qmix
   327  opt  (1593): Loop nest collapsed into one loop.
   327  vec  (   4): Vectorized array expression.
   327  vec  (  29): ADB is used for array.: xyr_partdia
   328  opt  (1593): Loop nest collapsed into one loop.
   328  vec  (   4): Vectorized array expression.
   328  vec  (  29): ADB is used for array.: xyr_partdia
   331  opt  (1593): Loop nest collapsed into one loop.
   331  vec  (   4): Vectorized array expression.
   331  vec  (  29): ADB is used for array.: xyr_press
   337  opt  (1592): Outer loop unrolled inside inner loop.
   337  vec  (   4): Vectorized array expression.
   337  vec  (  29): ADB is used for array.: xyr_sedvel
   337  vec  (   4): Vectorized array expression.
   337  vec  (  29): ADB is used for array.: xyr_sedvel
   345  opt  (1592): Outer loop unrolled inside inner loop.
   345  vec  (   4): Vectorized array expression.
   345  vec  (  29): ADB is used for array.: xyr_sedvel
   345  vec  (   4): Vectorized array expression.
   345  vec  (  29): ADB is used for array.: xyr_sedvel
   354  vec  (   3): Unvectorized loop.
   354  vec  (  13): Overhead of loop division is too large.
   357  opt  (1019): Feedback of scalar value from one loop pass to another.
   366  vec  (  20): Unvectorizable dependency.:xyr_dist
   381  opt  (  11): Fused array assignments. :line 381 - 382
   381  opt  (1593): Loop nest collapsed into one loop.
   381  vec  (   4): Vectorized array expression.
   386  opt  (1593): Loop nest collapsed into one loop.
   386  vec  (   4): Vectorized array expression.
   391  vec  (   1): Vectorized loop.
   391  vec  (  29): ADB is used for array.: xyz_delcompmass
   392  vec  (  26): Macro operation Sum/InnerProd.
   403  opt  (1592): Outer loop unrolled inside inner loop.
   403  vec  (   4): Vectorized array expression.
   403  vec  (  29): ADB is used for array.: xyr_sedvel
   403  vec  (   4): Vectorized array expression.
   403  vec  (  29): ADB is used for array.: xyr_sedvel
   408  opt  (1593): Loop nest collapsed into one loop.
   408  vec  (   4): Vectorized array expression.
   411  vec  (   1): Vectorized loop.
   411  vec  (  29): ADB is used for array.: xyz_delcompmass
   411  vec  (  29): ADB is used for array.: xyr_press
   411  vec  (  29): ADB is used for array.: xyz_delz
   450  opt  (  11): Fused array assignments. :line 450 - 453
   450  opt  (1592): Outer loop unrolled inside inner loop.
   450  vec  (   4): Vectorized array expression.
   450  vec  (  29): ADB is used for array.: xyr_sedvel
   450  vec  (   4): Vectorized array expression.
   450  vec  (  29): ADB is used for array.: xyr_sedvel
   459  opt  (1593): Loop nest collapsed into one loop.
   459  vec  (   1): Vectorized loop.
   459  vec  (  29): ADB is used for array.: xyr_press
   467  opt  (  11): Fused array assignments. :line 467 - 469
   467  opt  (1593): Loop nest collapsed into one loop.
   467  vec  (   4): Vectorized array expression.
   467  vec  (  29): ADB is used for array.: xyz_qmix
   473  opt  (1593): Loop nest collapsed into one loop.
   473  vec  (   4): Vectorized array expression.
   473  vec  (  29): ADB is used for array.: xy_surfgravsedflux
   481  opt  (1592): Outer loop unrolled inside inner loop.
   481  vec  (   4): Vectorized array expression.
   481  vec  (   4): Vectorized array expression.
   484  warn (  82): Name "meanfreepath" is not used.
   523  opt  (  11): Fused array assignments. :line 523 - 527
   523  opt  (1592): Outer loop unrolled inside inner loop.
   523  vec  (   4): Vectorized array expression.
   523  vec  (  29): ADB is used for array.: aaa_partdia
   523  vec  (  29): ADB is used for array.: aaa_press
   523  vec  (   4): Vectorized array expression.
   523  vec  (  29): ADB is used for array.: aaa_partdia
   523  vec  (  29): ADB is used for array.: aaa_press
   713  warn (  82): Name "n" is not used.
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:55 2016
FILE NAME: grav_sed.f90
PROGRAM NAME: grav_sed
TRANSFORMATION LIST

  LINE                   FORTRAN STATEMENT

     1  != 重力沈降過程
     2  !
     3  != Gravitational sedimentation process
     4  !
     5  ! Authors::   Yoshiyuki O. TAKAHASHI
     6  ! Version::   $Id: grav_sed.f90,v 1.3 2014/05/07 09:39:24 murashin Exp $
     7  ! Tag Name::  $Name:  $
     8  ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9  ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10  !
    11  module grav_sed
    12    !
    13    != 重力沈降過程
    14    !
    15    != Gravitational sedimentation process
    16    !
    17    ! <b>Note that Japanese and English are described in parallel.</b>
    18    !
    19    ! 重力沈降過程を計算するモジュールです.
    20    !
    21    ! This module calculates gravitational sedimentation.
    22    !
    23    !== Procedures List
    24    !
    25    ! GravSed         :: 計算
    26    ! GravSedInit     :: 初期化
    27    ! --------------- :: ------------
    28    ! GravSed         :: Calculation
    29    ! GravSedInit     :: Initialization
    30    !
    31    !== NAMELIST
    32    !
    33    ! NAMELIST#grav_sed_nml
    34    !
    35    !== References
    36    !
    37    ! * Conrath, B. J., 1975:
    38    !   Thermal structure of the Martian atmosphere during the dissipation of
    39    !   the dust storm of 1971,
    40    !   <i>Icarus</i>, <b>24</b>, 36--46.
    41    !
    42    ! * Lin, S.-J., and R. B. Rood, 1996:
    43    !   Multidimensional flux-form semi-Lagrangian transport scheme,
    44    !   <i>Mon. Wea. Rev.</i>, <b>124</b>, 2046--2070.
    45    !
    46  
    47    ! モジュール引用 ; USE statements
    48    !
    49  
    50    ! 種別型パラメタ
    51    ! Kind type parameter
    52    !
    53    use dc_types, only: DP, &      ! 倍精度実数型. Double precision.
    54      &                 STRING     ! 文字列.       Strings.
    55  
    56    ! メッセージ出力
    57    ! Message output
    58    !
    59    use dc_message, only: MessageNotify
    60  
    61    ! 組成に関わる配列の設定
    62    ! Settings of array for atmospheric composition
    63    !
    64    use composition, only: ncmax
    65  
    66    ! 格子点設定
    67    ! Grid points settings
    68    !
    69    use gridset, only: imax, & ! 経度格子点数.
    70                               ! Number of grid points in longitude
    71      &                jmax, & ! 緯度格子点数.
    72                               ! Number of grid points in latitude
    73      &                kmax    ! 鉛直層数.
    74                               ! Number of vertical level
    75  
    76  
    77    ! 宣言文 ; Declaration statements
    78    !
    79    implicit none
    80    private
    81  
    82    ! 公開手続き
    83    ! Public procedure
    84    !
    85    public :: GravSed
    86    public :: GravSedInit
    87  
    88  
    89    ! 公開変数
    90    ! Public variables
    91    !
    92  
    93    ! 非公開変数
    94    ! Private variables
    95    !
    96    real(DP), save :: RadiusMarsH2OCloud
    97    real(DP), save :: IceNumRatio
    98    real(DP), save :: DOD067ForMarsH2OCloud
    99  
   100    logical, save :: grav_sed_inited = .false.
   101                                ! 初期設定フラグ.
   102                                ! Initialization flag
   103  
   104  
   105    character(*), parameter:: module_name = 'grav_sed'
   106                                ! モジュールの名称.
   107                                ! Module name
   108    character(*), parameter:: version = &
   109      & '$Name:  $' // &
   110      & '$Id: grav_sed.f90,v 1.3 2014/05/07 09:39:24 murashin Exp $'
   111                                ! モジュールのバージョン
   112                                ! Module version
   113  
   114  
   115    !------------------------------------------------------------------------------------
   116  
   117  contains
   118  
   119    !------------------------------------------------------------------------------------
   120    ! Gravitational sedimentation is calculated.
   121    ! This routine works as adjustment routine, i.e., mass mixing ratio is
   122    ! updated in this routine.
   123    ! Current version calculates sedimentation of dust, only.
   124    ! In this routine, gravitational sedimentation is calculated by the use of
   125    ! a method following flux-form semi-Lagrangian transport scheme (Lin and
   126    ! Rood, 1996).
   127    !
   128  
   129    subroutine GravSed(                    &
   130      & SpcName,                           & ! (in )
   131      & xyr_Press, xyr_Height,             & ! (in )
   132      & xyz_QMix,                          & ! (out)
   133      & xy_SurfGravSedFlux                 & ! (out) optional
   134      & )
   135  
   136      ! ヒストリデータ出力
   137      ! History data output
   138      !
   139      use gtool_historyauto, only: HistoryAutoPut
   140  
   141      ! 組成に関わる配列の設定
   142      ! Settings of array for atmospheric composition
   143      !
   144      use composition, only: a_QMixName
   145  
   146      ! 時刻管理
   147      ! Time control
   148      !
   149      use timeset, only: &
   150        & TimeN, &              ! ステップ $ t $ の時刻. Time of step $ t $.
   151        & TimesetClockStart, TimesetClockStop, &
   152        & DelTime                 ! $ \Delta t $ [s]
   153  
   154      ! 物理・数学定数設定
   155      ! Physical and mathematical constants settings
   156      !
   157      use constants0, only: &
   158        & PI                    ! $ \pi $ .
   159      ! 円周率.  Circular constant
   160  
   161      ! 物理定数設定
   162      ! Physical constants settings
   163      !
   164      use constants, only: &
   165        & Grav, &
   166                                ! $ g $ [m s-2].
   167                                ! 重力加速度.
   168                                ! Gravitational acceleration
   169        & GasRDry
   170                                ! $ R $ [J kg-1 K-1].
   171                                ! 乾燥大気の気体定数.
   172                                ! Gas constant of air
   173  
   174  
   175      character(*), intent(in   ) :: SpcName
   176      real(DP)    , intent(in   ) :: xyr_Press  (0:imax-1, 1:jmax, 0:kmax)
   177      real(DP)    , intent(in   ) :: xyr_Height (0:imax-1, 1:jmax, 0:kmax)
   178      real(DP)    , intent(inout) :: xyz_QMix   (0:imax-1, 1:jmax, 1:kmax)
   179      real(DP)    , intent(out  ), optional :: xy_SurfGravSedFlux(0:imax-1, 1:jmax)
   180  
   181  
   182      !
   183      ! local variables
   184      !
   185      ! rhod : dust density
   186      ! mfp  : mean free path
   187      ! mvc  : modecular viscosity coefficient
   188      ! rdia : particle diameter
   189      !
   190      real(DP) :: PartDen
   191      real(DP) :: xyr_PartDia(0:imax-1, 1:jmax, 0:kmax)
   192      real(DP) :: MeanFreePath
   193      real(DP) :: MolVisCoef
   194  
   195      real(DP) :: MeanFreePathRef
   196      real(DP) :: PressLambdaRef
   197  
   198  
   199      real(DP) :: xyz_DelAtmMass  (0:imax-1, 1:jmax, 1:kmax)
   200      real(DP) :: xyz_DelCompMass (0:imax-1, 1:jmax, 1:kmax)
   201      real(DP) :: xyz_DelZ        (0:imax-1, 1:jmax, 1:kmax)
   202      real(DP) :: xyr_SedVel      (0:imax-1, 1:jmax, 0:kmax)
   203      real(DP) :: xyr_FracSedDist (0:imax-1, 1:jmax, 0:kmax)
   204      real(DP) :: xyr_Dist        (0:imax-1, 1:jmax, 0:kmax)
   205      integer  :: xyr_KIndex      (0:imax-1, 1:jmax, 0:kmax)
   206      real(DP) :: xyr_QMixFlux    (0:imax-1, 1:jmax, 0:kmax)
   207      real(DP) :: xyr_IntQMixFlux (0:imax-1, 1:jmax, 0:kmax)
   208      real(DP) :: xyr_FracQMixFlux(0:imax-1, 1:jmax, 0:kmax)
   209      real(DP) :: xyz_DQMixDt     (0:imax-1, 1:jmax, 1:kmax)
   210      real(DP) :: xyz_QMixA       (0:imax-1, 1:jmax, 1:kmax)
   211      real(DP) :: LogPress
   212      real(DP) :: Press
   213  
   214      real(DP), parameter :: AMU = 1.6605655e-27_DP
   215  
   216      real(DP) :: DustExtEff
   217      real(DP) :: DustREff
   218      real(DP) :: DOD067Ref
   219      real(DP) :: MeanMolMass
   220      real(DP) :: PressRef
   221      real(DP) :: DustNumRatio
   222  !!$    real(DP) :: xyr_NumDensDust(0:imax-1, 1:jmax, 0:kmax)
   223  !!$    real(DP) :: xyr_NumDensIce (0:imax-1, 1:jmax, 0:kmax)
   224      real(DP) :: xyz_PartDia    (0:imax-1, 1:jmax, 1:kmax)
   225  
   226      integer  :: i
   227      integer  :: j
   228      integer  :: k
   229      integer  :: kk
   230  
   231  
   232      ! 実行文 ; Executable statement
   233      !
   234  
   235      ! 初期化確認
   236      ! Initialization check
   237      !
   238      if ( .not. grav_sed_inited ) then
   239        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   240      end if
   241  
   242  
   243  
   244      ! Calculation of mass in each layer and layer thickness in unit of meter
   245      !   Layer thickness is calculated by using mass of a layer.
   246  !!$    xyz_Rho = xyz_Press / ( GasRDry * xyz_VirTemp )
   247      do k = 1, kmax
   248        xyz_DelAtmMass(:,:,k) = ( xyr_Press(:,:,k-1) - xyr_Press(:,:,k) ) / Grav
   249      end do
   250  !!$    xyz_DelZ = xyz_DelAtmMass / xyz_Rho
   251      do k = 1, kmax
   252        xyz_DelZ(:,:,k) = xyr_Height(:,:,k) - xyr_Height(:,:,k-1)
   253      end do
   254  
   255  
   256      ! Calculation of mass of constituents in a layer
   257      xyz_DelCompMass = xyz_QMix * xyz_DelAtmMass
   258  
   259  
   260      !
   261      ! calculation of sedimentation terminal velocity
   262      !
   263      if ( SpcName == 'MarsDust' ) then
   264  
   265        !
   266        ! The values below are obtained from Conrath (1975).
   267        ! Particle radius of 1e-6 m is assumed.
   268        !
   269        MolVisCoef      = 1.5e-4_DP * 1.0e-3_DP * 1.0e2_DP
   270        MeanFreePathRef = 2.2e-4_DP * 1.0e-2_DP
   271        PressLambdaRef  = 25.0e2_DP
   272        PartDen         = 3.0e3_DP
   273        xyr_PartDia     = 2.0_DP * 1.0e-6_DP
   274  
   275        xyr_SedVel = &
   276          & aaa_SedVel( &
   277          &   MolVisCoef, MeanFreePathRef, PressLambdaRef, PartDen, xyr_PartDia, &
   278          &   max( xyr_Press, 1.0e-20_DP )                                       &
   279          & )
   280        k = kmax
   281        xyr_SedVel(:,:,k) = 0.0_DP
   282  
   283      else if ( SpcName == 'MarsH2OCloud' ) then
   284  
   285        !
   286        ! The values below are obtained from Conrath (1975).
   287        !
   288        MolVisCoef      = 1.5e-4_DP * 1.0e-3_DP * 1.0e2_DP
   289        MeanFreePathRef = 2.2e-4_DP * 1.0e-2_DP
   290        PressLambdaRef  = 25.0e2_DP
   291        !
   292        ! Particle radius of 1e-6 m is assumed.
   293        !
   294        PartDen         = 1.0e3_DP
   295  !!$      PartDia         = 2.0_DP * 1.0e-6_DP
   296        if ( RadiusMarsH2OCloud > 0.0_DP ) then
   297          xyr_PartDia         = 2.0_DP * RadiusMarsH2OCloud
   298        else
   299          MeanMolMass  = 44.0_DP * AMU
   300          ! DOD067Ref : Dust optical depth at 0.67 um
   301          if ( IceNumRatio < 0.0_DP ) then
   302            DustExtEff   = 3.04_DP    ! Ockert-Bell et al. (1997)
   303            DustREff     = 1.85e-6_DP ! Ockert-Bell et al. (1997)
   304            DOD067Ref    = DOD067ForMarsH2OCloud
   305            PressRef     = 700.0_DP
   306            ! DustNumRatio : numb. dens. of dust / num. dens. of atm. molecules.
   307            DustNumRatio = DOD067Ref * MeanMolMass &
   308              & / ( DustExtEff * PI * DustREff**2 * PressRef / Grav )
   309            IceNumRatio = DustNumRatio
   310  !!$        xyz_NumDensDust = DustNumRatio * xyz_Rho / MeanMolMass
   311  !!$        xyz_NumDensIce  = xyz_NumDensDust
   312          end if
   313          ! calculate radius, first
   314  !!$        xyz_PartDia = &
   315  !!$          & (                                                       &
   316  !!$          &     xyz_QMix * xyz_Rho                                  &
   317  !!$          &   / ( xyz_NumDensIce * PartDen * 4.0_DP / 3.0_DP * PI ) &
   318  !!$          & )**(1.0_DP/3.0_DP)
   319          xyz_PartDia =                                               &
   320            & (                                                       &
   321            &     xyz_QMix * MeanMolMass                              &
   322            &   / ( IceNumRatio * PartDen * 4.0_DP / 3.0_DP * PI )    &
   323            & )**(1.0_DP/3.0_DP)
   324          ! calculate diameter
   325          xyz_PartDia = 2.0_DP * xyz_PartDia
   326          !
   327          xyr_PartDia(:,:,0:kmax-1) = xyz_PartDia(:,:,1:kmax)
   328          xyr_PartDia(:,:,kmax) = 0.0_DP
   329        end if
   330  
   331        xyr_SedVel = &
   332          & aaa_SedVel(                                                          &
   333          &   MolVisCoef, MeanFreePathRef, PressLambdaRef, PartDen, xyr_PartDia, &
   334          &   max( xyr_Press, 1.0e-20_DP )                                       &
   335          & )
   336        k = kmax
   337        xyr_SedVel(:,:,k) = 0.0_DP
   338  
   339      else
   340        call MessageNotify( 'E', module_name, 'Specie %c is inappropriate', c1 = trim( SpcName ) )
   341      end if
   342  
   343  
   344      ! Calculation of sedimentation distance during a time step of 2 * DelTime
   345      xyr_Dist = abs( xyr_SedVel ) * 2.0_DP * DelTime
   346      do k = 0, kmax-1
   347        do j = 1, jmax
   348          do i = 0, imax-1
   349  
   350            ! A k index in which all mass of the layer does not fall is
   351            ! searched. In addition, fractional sedimentation velocity is
   352            ! calculated.
   353            xyr_KIndex(i,j,k) = -1
   354            do kk = k+1, kmax-1
   355              ! If sedimentation velocity (distance) is positive, and all of
   356              ! mass in kk layer does not fall, KIndex is kk.
   357              if ( ( xyr_Dist(i,j,k) >= 0.0_DP ) .and. &
   358                &  ( xyr_Dist(i,j,k) <= xyz_DelZ(i,j,kk) ) ) then
   359                xyr_KIndex     (i,j,k) = kk
   360                xyr_FracSedDist(i,j,k) = xyr_Dist(i,j,k)
   361              end if
   362              ! Sedimentation distance is decreased for preparation for next
   363              ! layer.
   364              ! If xyz_Dist become negative, any mass of the upper layer does
   365              ! not fall.
   366              xyr_Dist(i,j,k) = xyr_Dist(i,j,k) - xyz_DelZ(i,j,kk)
   367            end do
   368            ! Calculation for upper most layer.
   369            kk = kmax
   370            if ( xyr_Dist(i,j,k) >= 0.0_DP ) then
   371              xyr_KIndex     (i,j,k) = kk
   372              xyr_FracSedDist(i,j,k) = min( xyr_Dist(i,j,k), xyz_DelZ(i,j,kk) )
   373            end if
   374  
   375          end do
   376        end do
   377      end do
   378      ! K index and fractional sedimentation velocity at model top.
   379      ! No flux is assumed at the model top.
   380      k = kmax
   381      xyr_KIndex     (:,:,k) = -1
   382      xyr_FracSedDist(:,:,k) = 0.0_DP
   383  
   384  
   385      ! Calculation of integer mass flux.
   386      xyr_IntQMixFlux = 0.0_DP
   387      do k = 0, kmax-1
   388        do j = 1, jmax
   389          do i = 0, imax-1
   390  
   391            do kk = k+1, xyr_KIndex(i,j,k)-1
   392              xyr_IntQMixFlux(i,j,k) = xyr_IntQMixFlux(i,j,k) &
   393                & + xyz_DelCompMass(i,j,kk)
   394            end do
   395            xyr_IntQMixFlux(i,j,k) = xyr_IntQMixFlux(i,j,k) / ( 2.0_DP * DelTime )
   396  
   397          end do
   398        end do
   399      end do
   400  
   401      ! Add sign of sedimentation velocity.
   402      ! This is equivalent to mulplying -1.
   403      xyr_IntQMixFlux = sign( 1.0_DP, xyr_SedVel ) * xyr_IntQMixFlux
   404  
   405  
   406      ! Calculation of fractional mass flux
   407      k = kmax
   408      xyr_FracQMixFlux(:,:,k) = 0.0_DP
   409      do k = kmax-1, 0, -1
   410        do j = 1, jmax
   411          do i = 0, imax-1
   412            kk = xyr_KIndex(i,j,k)
   413            !-----
   414            ! Simple method
   415  !!$            xyrf_FracQMixFlux(i,j,k,n) =                       &
   416  !!$              &   xyrf_FracSedDist(i,j,k,n) / xyz_DelZ(i,j,kk) &
   417  !!$              & * xyzf_DelCompMass(i,j,kk,n)
   418            !-----
   419            ! Method considering exponential distribution of mass with height
   420            if ( xyr_Press(i,j,kk) == 0.0_DP ) then
   421              LogPress =                                                      &
   422                &   log( xyr_Press(i,j,kk-1) * 1.0e-1_DP / xyr_Press(i,j,kk-1) ) &
   423                & / xyz_DelZ(i,j,kk) * xyr_FracSedDist(i,j,k)                 &
   424                & + log( xyr_Press(i,j,kk-1) )
   425              Press = exp( LogPress )
   426              xyr_FracQMixFlux(i,j,k) =                                     &
   427                &   ( xyr_Press(i,j,kk-1) - Press                        )  &
   428                & / ( xyr_Press(i,j,kk-1) - xyr_Press(i,j,kk-1) * 1.0e-1_DP )  &
   429                & * xyz_DelCompMass(i,j,kk)
   430            else
   431              LogPress =                                           &
   432                &   log( xyr_Press(i,j,kk) / xyr_Press(i,j,kk-1) ) &
   433                & / xyz_DelZ(i,j,kk) * xyr_FracSedDist(i,j,k)      &
   434                & + log( xyr_Press(i,j,kk-1) )
   435              Press = exp( LogPress )
   436              xyr_FracQMixFlux(i,j,k) =                          &
   437                &   ( xyr_Press(i,j,kk-1) - Press             )  &
   438                & / ( xyr_Press(i,j,kk-1) - xyr_Press(i,j,kk) )  &
   439                & * xyz_DelCompMass(i,j,kk)
   440            end if
   441            !-----
   442            xyr_FracQMixFlux(i,j,k) = xyr_FracQMixFlux(i,j,k) &
   443              & / ( 2.0_DP * DelTime )
   444          end do
   445        end do
   446      end do
   447  
   448      ! Add sign of sedimentation velocity.
   449      ! This is equivalent to mulplying -1.
   450      xyr_FracQMixFlux = sign( 1.0_DP, xyr_SedVel ) * xyr_FracQMixFlux
   451  
   452  
   453      xyr_QMixFlux = xyr_IntQMixFlux + xyr_FracQMixFlux
   454  
   455  
   456      !
   457      ! estimate dust mixing ratio at next time step
   458      !
   459      do k = 1, kmax
   460        xyz_DQMixDt(:,:,k) =                                  &
   461          &   ( xyr_QMixFlux(:,:,k) - xyr_QMixFlux(:,:,k-1) ) &
   462          & / ( xyr_Press   (:,:,k) - xyr_Press   (:,:,k-1) ) &
   463          & * Grav
   464      end do
   465  
   466  
   467      xyz_QMixA = xyz_QMix + xyz_DQMixDt * 2.0_DP * DelTime
   468  
   469      xyz_QMix  = xyz_QMixA
   470  
   471  
   472      if ( present ( xy_SurfGravSedFlux ) ) then
   473        xy_SurfGravSedFlux = xyr_QMixFlux(:,:,0)
   474      end if
   475  
   476  
   477      ! ヒストリデータ出力
   478      ! History data output
   479      !
   480      if ( SpcName == 'MarsH2OCloud' ) then
   481        call HistoryAutoPut( TimeN, 'MarsH2OCloudRadius', xyz_PartDia/2.0_DP )
   482      end if
   483  
   484    end subroutine GravSed
     .        if (grav_sed_inited .ne. 0) goto 10001                            
     .        call messagenotifyc ('E', module_name,                            
     .       1   'This module has not been initialized.', 1, 1, 1, 1, 1, 1, 1, 1
     .       2   , 1, 1, 1, 8, 37, 0, 0, 0, 0)                                  
     .  10001 continue                                                          
     .        d1 = 1.D0/grav                                                    
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do k = 1, kmax*jmax*imax                                          
     .           xyz_delatmmass(k-1,1,1) = (xyr_press(k-1,1,0)-xyr_press(k-1,1,1
     .       1      ))*d1                                                       
     .           xyz_delz(k-1,1,1) = xyr_height(k-1,1,1) - xyr_height(k-1,1,0)  
     .        enddo                                                             
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t962 = 1, kmax*jmax*imax                                       
     .           xyz_delcompmass(t962-1,1,1) = xyz_qmix(t962-1,1,1)*            
     .       1      xyz_delatmmass(t962-1,1,1)                                  
     .        enddo                                                             
     .        if (fy_ccompi(4,spcname,'MarsDust',CHARLEN.spcname,8) .eq. 0)     
     .       1   goto 10027                                                     
     .        molviscoef = 1.49999999999999e-005                                
     .        meanfreepathref = 2.20000000000000e-006                           
     .        presslambdaref = 2.50000000000000e+003                            
     .        partden = 3.00000000000000e+003                                   
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1169 = 1, (xyr_partdia.DSC.U3 + 1)*xyr_partdia.DSC.U2*(       
     .       1   xyr_partdia.DSC.U1 + 1)                                        
     .           xyr_partdia(t1169-1,1,0) = 1.99999999999999e-006               
     .        enddo                                                             
     .        %IG0.DSC.U1 = imax - 1 + 1                                        
     .        %IG0.DSC.U2 = jmax - 1 + 1                                        
     .        %IG0.DSC.U3 = kmax + 1                                            
     .        allocate (%IG0(1:imax-1+1,1:jmax-1+1,1:kmax+1))                   
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1178 = 1, jmax*(kmax*imax + imax)                             
     .           %IG0(t1178,1,1) = max(xyr_press(t1178-1,1,0),                  
     .       1      9.99999999999999e-021)                                      
     .        enddo                                                             
     .        call aaa_sedvel (xyr_sedvel, molviscoef, meanfreepathref,         
     .       1   presslambdaref, partden, xyr_partdia, %IG0)                    
     .        xyr_sedvel.DSC.L1 = xyr_sedvel.DSC.L1                             
     .        xyr_sedvel.DSC.U1 = xyr_sedvel.DSC.U1                             
     .        xyr_sedvel.DSC.S1 = xyr_sedvel.DSC.S1                             
     .        xyr_sedvel.DSC.L2 = xyr_sedvel.DSC.L2                             
     .        xyr_sedvel.DSC.U2 = xyr_sedvel.DSC.U2                             
     .        xyr_sedvel.DSC.S2 = xyr_sedvel.DSC.S2                             
     .        xyr_sedvel.DSC.L3 = xyr_sedvel.DSC.L3                             
     .        xyr_sedvel.DSC.U3 = xyr_sedvel.DSC.U3                             
     .        xyr_sedvel.DSC.S3 = xyr_sedvel.DSC.S3                             
     .        deallocate (%IG0)                                                 
     .        k = kmax                                                          
     .        if (t105 + 1 .le. 0) goto 10030                                   
     .        if (t106 .gt. 0) then                                             
     .           j1 = and(t106,3)                                               
     .  !cdir    nodep                                                          
     .           do t1190 = 1, j1                                               
     .  !cdir       nodep                                                       
     .              do t1192 = 1, t105 + 2 - min0(1,t105 + 1)                   
     .                 xyr_sedvel(t1192-1,t1190,k) = 0.0000000000000000e+000    
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t1190 = j1 + 1, t106, 4                                     
     .  !cdir       nodep                                                       
     .              do t1192 = 1, t105 + 2 - min0(1,t105 + 1)                   
     .                 xyr_sedvel(t1192-1,t1190,k) = 0.0000000000000000e+000    
     .                 xyr_sedvel(t1192-1,t1190+1,k) = 0.0000000000000000e+000  
     .                 xyr_sedvel(t1192-1,t1190+2,k) = 0.0000000000000000e+000  
     .                 xyr_sedvel(t1192-1,t1190+3,k) = 0.0000000000000000e+000  
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
     .        goto 10030                                                        
     .  10027 continue                                                          
     .        if (fy_ccompi(4,spcname,'MarsH2OCloud',CHARLEN.spcname,12) .eq. 0 
     .       1   ) goto 10028                                                   
     .        molviscoef = 1.49999999999999e-005                                
     .        meanfreepathref = 2.20000000000000e-006                           
     .        presslambdaref = 2.50000000000000e+003                            
     .        partden = 1.00000000000000e+003                                   
     .        if (radiusmarsh2ocloud .le. 0.0000000000000000e+000) goto 10145   
     .        if (xyr_partdia.DSC.U2 - 1 + 1 .le. 0) goto 10170                 
     .        if (xyr_partdia.DSC.U1 + 1 .le. 0) goto 10170                     
     .  !cdir nodep                                                             
     .        do t1160 = 0, xyr_partdia.DSC.U3                                  
     .           if(1+xyr_partdia.DSC.U2-min0(1,xyr_partdia.DSC.U2).gt.0)then   
     .              j2=and(1+xyr_partdia.DSC.U2-min0(1,xyr_partdia.DSC.U2),3)   
     .  !cdir       nodep                                                       
     .              do t1162 = 1, j2                                            
     .  !cdir          nodep                                                    
     .                 do t1164 = 1, xyr_partdia.DSC.U1 + 2 - min0(1,           
     .       1            xyr_partdia.DSC.U1 + 1)                               
     .                    xyr_partdia(t1164-1,t1162,t1160) =                    
     .       1               2.00000000000000e+000*radiusmarsh2ocloud           
     .                 enddo                                                    
     .              enddo                                                       
     .  !cdir       nodep                                                       
     .              do t1162 = j2 + 1, 1 + xyr_partdia.DSC.U2 - min0(1,         
     .       1         xyr_partdia.DSC.U2), 4                                   
     .  !cdir          nodep                                                    
     .                 do t1164 = 1, xyr_partdia.DSC.U1 + 2 - min0(1,           
     .       1            xyr_partdia.DSC.U1 + 1)                               
     .                    xyr_partdia(t1164-1,t1162,t1160) = (                  
     .       1               2.00000000000000e+000*radiusmarsh2ocloud)          
     .                    xyr_partdia(t1164-1,t1162+1,t1160) = (                
     .       1               2.00000000000000e+000*radiusmarsh2ocloud)          
     .                    xyr_partdia(t1164-1,t1162+2,t1160) = (                
     .       1               2.00000000000000e+000*radiusmarsh2ocloud)          
     .                    xyr_partdia(t1164-1,t1162+3,t1160) = (                
     .       1               2.00000000000000e+000*radiusmarsh2ocloud)          
     .                 enddo                                                    
     .              enddo                                                       
     .           endif                                                          
     .        enddo                                                             
     .        goto 10170                                                        
     .  10145 continue                                                          
     .        meanmolmass = 7.30648819999999e-026                               
     .        if (icenumratio .ge. 0.0000000000000000e+000) goto 10146          
     .        dustexteff = 3.04000000000000e+000                                
     .        dustreff = 1.85000000000000e-006                                  
     .        dod067ref = dod067formarsh2ocloud                                 
     .        pressref = 7.00000000000000e+002                                  
     .        dustnumratio = dod067ref*meanmolmass/(dustexteff*                 
     .       1   3.14159265358979e+000*dustreff**2*pressref/grav)               
     .        icenumratio = dustnumratio                                        
     .  10146 continue                                                          
     .        d3 = meanmolmass/(icenumratio*partden*4.00000000000000e+000/      
     .       1   3.00000000000000e+000*3.14159265358979e+000)                   
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1106 = 1, kmax*jmax*imax                                      
     .           xyz_partdia1 = (xyz_qmix(t1106-1,1,1)*d3)**                    
     .       1      3.33333333333333e-001                                       
     .           xyz_partdia(t1106-1,1,1) = 2.00000000000000e+000*xyz_partdia1  
     .        enddo                                                             
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1124 = 1, kmax*(xyr_partdia.DSC.U2*xyr_partdia.DSC.U1 +       
     .       1   xyr_partdia.DSC.U2)                                            
     .           xyr_partdia(t1124-1,1,0) = xyz_partdia(t1124-1,1,1)            
     .        enddo                                                             
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1136 = 1, xyr_partdia.DSC.U2*xyr_partdia.DSC.U1 +             
     .       1   xyr_partdia.DSC.U2                                             
     .           xyr_partdia(t1136-1,1,kmax) = 0.0000000000000000e+000          
     .        enddo                                                             
     .  10170 continue                                                          
     .        %IG7.DSC.U1 = imax - 1 + 1                                        
     .        %IG7.DSC.U2 = jmax - 1 + 1                                        
     .        %IG7.DSC.U3 = kmax + 1                                            
     .        allocate (%IG7(1:imax-1+1,1:jmax-1+1,1:kmax+1))                   
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1142 = 1, jmax*(kmax*imax + imax)                             
     .           %IG7(t1142,1,1) = max(xyr_press(t1142-1,1,0),                  
     .       1      9.99999999999999e-021)                                      
     .        enddo                                                             
     .        call aaa_sedvel (xyr_sedvel, molviscoef, meanfreepathref,         
     .       1   presslambdaref, partden, xyr_partdia, %IG7)                    
     .        xyr_sedvel.DSC.L1 = xyr_sedvel.DSC.L1                             
     .        xyr_sedvel.DSC.U1 = xyr_sedvel.DSC.U1                             
     .        xyr_sedvel.DSC.S1 = xyr_sedvel.DSC.S1                             
     .        xyr_sedvel.DSC.L2 = xyr_sedvel.DSC.L2                             
     .        xyr_sedvel.DSC.U2 = xyr_sedvel.DSC.U2                             
     .        xyr_sedvel.DSC.S2 = xyr_sedvel.DSC.S2                             
     .        xyr_sedvel.DSC.L3 = xyr_sedvel.DSC.L3                             
     .        xyr_sedvel.DSC.U3 = xyr_sedvel.DSC.U3                             
     .        xyr_sedvel.DSC.S3 = xyr_sedvel.DSC.S3                             
     .        deallocate (%IG7)                                                 
     .        k = kmax                                                          
     .        if (t105 + 1 .le. 0) goto 10030                                   
     .        if (t106 .gt. 0) then                                             
     .           j3 = and(t106,3)                                               
     .  !cdir    nodep                                                          
     .           do t1154 = 1, j3                                               
     .  !cdir       nodep                                                       
     .              do t1156 = 1, t105 + 2 - min0(1,t105 + 1)                   
     .                 xyr_sedvel(t1156-1,t1154,k) = 0.0000000000000000e+000    
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t1154 = j3 + 1, t106, 4                                     
     .  !cdir       nodep                                                       
     .              do t1156 = 1, t105 + 2 - min0(1,t105 + 1)                   
     .                 xyr_sedvel(t1156-1,t1154,k) = 0.0000000000000000e+000    
     .                 xyr_sedvel(t1156-1,t1154+1,k) = 0.0000000000000000e+000  
     .                 xyr_sedvel(t1156-1,t1154+2,k) = 0.0000000000000000e+000  
     .                 xyr_sedvel(t1156-1,t1154+3,k) = 0.0000000000000000e+000  
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
     .        goto 10030                                                        
     .  10028 continue                                                          
     .        call f_null (%000102)                                             
     .        call fy_chtrim (%000102, %000101, spcname, CHARLEN.spcname)       
     .        call messagenotifyc ('E', module_name,                            
     .       1   'Specie %c is inappropriate', 1, 1, 1, 1, 1, %000102, 1, 1, 1, 
     .       2   1, 1, 8, 26, %000101, 0, 0, 0)                                 
     .        deallocate (%000102)                                              
     .  10030 continue                                                          
     .  !cdir nodep                                                             
     .        do t977 = 0, t107                                                 
     .           if (t106 .gt. 0) then                                          
     .              j4 = and(t106,3)                                            
     .  !cdir       nodep                                                       
     .              do t979 = 1, j4                                             
     .  !cdir          nodep                                                    
     .                 do t981 = 1, t105 + 1                                    
     .                    xyr_dist(t981-1,t979,t977) = abs(xyr_sedvel(t981-1,   
     .       1               t979,t977))*2.00000000000000e+000*deltime          
     .                 enddo                                                    
     .              enddo                                                       
     .  !cdir       nodep                                                       
     .              do t979 = j4 + 1, t106, 4                                   
     .  !cdir          nodep                                                    
     .                 do t981 = 1, t105 + 1                                    
     .                    xyr_dist(t981-1,t979,t977) = abs(xyr_sedvel(t981-1,   
     .       1               t979,t977))*2.00000000000000e+000*deltime          
     .                    xyr_dist(t981-1,t979+1,t977) = abs(xyr_sedvel(t981-1, 
     .       1               t979+1,t977))*2.00000000000000e+000*deltime        
     .                    xyr_dist(t981-1,t979+2,t977) = abs(xyr_sedvel(t981-1, 
     .       1               t979+2,t977))*2.00000000000000e+000*deltime        
     .                    xyr_dist(t981-1,t979+3,t977) = abs(xyr_sedvel(t981-1, 
     .       1               t979+3,t977))*2.00000000000000e+000*deltime        
     .                 enddo                                                    
     .              enddo                                                       
     .           endif                                                          
     .        enddo                                                             
     .        do k = 0, kmax - 1                                                
     .           do j = 1, jmax                                                 
     .              do i = 0, imax - 1                                          
     .                 xyr_kindex(i,j,k) = -1                                   
     .                 do kk = k + 1, kmax - 1                                  
     .                    if (xyr_dist(i,j,k).ge.0.0000000000000000e+000 .and.  
     .       1               xyr_dist(i,j,k).le.xyz_delz(i,j,kk)) then          
     .                       xyr_kindex(i,j,k) = kk                             
     .                       xyr_fracseddist(i,j,k) = xyr_dist(i,j,k)           
     .                    endif                                                 
     .                    xyr_dist(i,j,k) = xyr_dist(i,j,k) - xyz_delz(i,j,kk)  
     .                 enddo                                                    
     .                 kk = kmax                                                
     .                 if (xyr_dist(i,j,k) .lt. 0.0000000000000000e+000) goto   
     .       1            10046                                                 
     .                 xyr_kindex(i,j,k) = kk                                   
     .                 xyr_fracseddist(i,j,k) = min(xyr_dist(i,j,k),xyz_delz(i,j
     .       1            ,kk))                                                 
     .  10046          continue                                                 
     .              enddo                                                       
     .           enddo                                                          
     .        enddo                                                             
     .        k = kmax                                                          
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t989 = 1, xyr_kindex.DSC.U2*xyr_kindex.DSC.U1 +                
     .       1   xyr_kindex.DSC.U2                                              
     .           xyr_kindex(t989-1,1,k) = -1                                    
     .           xyr_fracseddist(t989-1,1,k) = 0.0000000000000000e+000          
     .        enddo                                                             
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t997 = 1, (xyr_intqmixflux.DSC.U3 + 1)*xyr_intqmixflux.DSC.U2*(
     .       1   xyr_intqmixflux.DSC.U1 + 1)                                    
     .           xyr_intqmixflux(t997-1,1,0) = 0.0000000000000000e+000          
     .        enddo                                                             
     .        do k = 0, kmax - 1                                                
     .           do j = 1, jmax                                                 
     .              do i = 0, imax - 1                                          
     .                 if (xyr_kindex(i,j,k) - k - 1 .gt. 0) then               
     .                    xyr_intqmixflux5 = xyr_intqmixflux(i,j,k)             
     .  !cdir             nodep                                                 
     .                    do kk = 1, xyr_kindex(i,j,k) - k - 1                  
     .                       xyr_intqmixflux5 = xyr_intqmixflux5 +              
     .       1                  xyz_delcompmass(i,j,k+kk)                       
     .                    enddo                                                 
     .                    xyr_intqmixflux(i,j,k) = xyr_intqmixflux5             
     .                 endif                                                    
     .                 xyr_intqmixflux(i,j,k) = xyr_intqmixflux(i,j,k)/(        
     .       1            2.00000000000000e+000*deltime)                        
     .              enddo                                                       
     .           enddo                                                          
     .        enddo                                                             
     .  !cdir nodep                                                             
     .        do t1006 = 0, t107                                                
     .           if (t106 .gt. 0) then                                          
     .              j6 = and(t106,3)                                            
     .  !cdir       nodep                                                       
     .              do t1008 = 1, j6                                            
     .  !cdir          nodep                                                    
     .                 do t1010 = 1, t105 + 1                                   
     .                    xyr_intqmixflux(t1010-1,t1008,t1006) = sign(          
     .       1               1.00000000000000e+000,xyr_sedvel(t1010-1,t1008,    
     .       2               t1006))*xyr_intqmixflux(t1010-1,t1008,t1006)       
     .                 enddo                                                    
     .              enddo                                                       
     .  !cdir       nodep                                                       
     .              do t1008 = j6 + 1, t106, 4                                  
     .  !cdir          nodep                                                    
     .                 do t1010 = 1, t105 + 1                                   
     .                    xyr_intqmixflux(t1010-1,t1008,t1006) = sign(          
     .       1               1.00000000000000e+000,xyr_sedvel(t1010-1,t1008,    
     .       2               t1006))*xyr_intqmixflux(t1010-1,t1008,t1006)       
     .                    xyr_intqmixflux(t1010-1,t1008+1,t1006) = sign(        
     .       1               1.00000000000000e+000,xyr_sedvel(t1010-1,t1008+1,  
     .       2               t1006))*xyr_intqmixflux(t1010-1,t1008+1,t1006)     
     .                    xyr_intqmixflux(t1010-1,t1008+2,t1006) = sign(        
     .       1               1.00000000000000e+000,xyr_sedvel(t1010-1,t1008+2,  
     .       2               t1006))*xyr_intqmixflux(t1010-1,t1008+2,t1006)     
     .                    xyr_intqmixflux(t1010-1,t1008+3,t1006) = sign(        
     .       1               1.00000000000000e+000,xyr_sedvel(t1010-1,t1008+3,  
     .       2               t1006))*xyr_intqmixflux(t1010-1,t1008+3,t1006)     
     .                 enddo                                                    
     .              enddo                                                       
     .           endif                                                          
     .        enddo                                                             
     .        k = kmax                                                          
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1021 = 1, xyr_fracqmixflux.DSC.U2*xyr_fracqmixflux.DSC.U1 +   
     .       1   xyr_fracqmixflux.DSC.U2                                        
     .           xyr_fracqmixflux(t1021-1,1,k) = 0.0000000000000000e+000        
     .        enddo                                                             
     .        do k = kmax - 1, 0, -1                                            
     .           do j = 1, jmax                                                 
     .              d7 = 1.D0/(2.00000000000000e+000*deltime)                   
     .  !cdir       nodep                                                       
     .  !cdir       on_adb(xyr_press)                                           
     .              do i = 1, imax                                              
     .                 xyr_fracqmixflux1 = xyr_fracqmixflux(i-1,j,k)            
     .                 kk = xyr_kindex(i-1,j,k)                                 
     .                 if (xyr_press(i-1,j,kk) .eq. 0.0000000000000000e+000)    
     .       1            then                                                  
     .                    logpress = dlog(1.00000000000000e-001)/xyz_delz(i-1,j,
     .       1               kk)*xyr_fracseddist(i-1,j,k) + dlog(xyr_press(i-1,j
     .       2               ,kk-1))                                            
     .                    press = dexp(logpress)                                
     .                    xyr_fracqmixflux1 = (xyr_press(i-1,j,kk-1)-press)/(   
     .       1               xyr_press(i-1,j,kk-1)-xyr_press(i-1,j,kk-1)*       
     .       2               1.00000000000000e-001)*xyz_delcompmass(i-1,j,kk)   
     .                 else                                                     
     .                    logpress = dlog(xyr_press(i-1,j,kk)/xyr_press(i-1,j,kk
     .       1               -1))/xyz_delz(i-1,j,kk)*xyr_fracseddist(i-1,j,k) + 
     .       2               dlog(xyr_press(i-1,j,kk-1))                        
     .                    press = dexp(logpress)                                
     .                    xyr_fracqmixflux1 = (xyr_press(i-1,j,kk-1)-press)/(   
     .       1               xyr_press(i-1,j,kk-1)-xyr_press(i-1,j,kk))*        
     .       2               xyz_delcompmass(i-1,j,kk)                          
     .                 endif                                                    
     .                 xyr_fracqmixflux(i-1,j,k) = xyr_fracqmixflux1*d7         
     .              enddo                                                       
     .           enddo                                                          
     .        enddo                                                             
     .  !cdir nodep                                                             
     .        do t1027 = 0, t107                                                
     .           if (t106 .gt. 0) then                                          
     .              j7 = and(t106,3)                                            
     .  !cdir       nodep                                                       
     .              do t1029 = 1, j7                                            
     .  !cdir          nodep                                                    
     .                 do t1031 = 1, t105 + 1                                   
     .                    xyr_fracqmixflux(t1031-1,t1029,t1027) = sign(         
     .       1               1.00000000000000e+000,xyr_sedvel(t1031-1,t1029,    
     .       2               t1027))*xyr_fracqmixflux(t1031-1,t1029,t1027)      
     .                    xyr_qmixflux(t1031-1,t1029,t1027) = xyr_intqmixflux(  
     .       1               t1031-1,t1029,t1027) + xyr_fracqmixflux(t1031-1,   
     .       2               t1029,t1027)                                       
     .                 enddo                                                    
     .              enddo                                                       
     .  !cdir       nodep                                                       
     .              do t1029 = j7 + 1, t106, 4                                  
     .  !cdir          nodep                                                    
     .                 do t1031 = 1, t105 + 1                                   
     .                    xyr_fracqmixflux(t1031-1,t1029,t1027) = sign(         
     .       1               1.00000000000000e+000,xyr_sedvel(t1031-1,t1029,    
     .       2               t1027))*xyr_fracqmixflux(t1031-1,t1029,t1027)      
     .                    xyr_fracqmixflux(t1031-1,t1029+1,t1027) = sign(       
     .       1               1.00000000000000e+000,xyr_sedvel(t1031-1,t1029+1,  
     .       2               t1027))*xyr_fracqmixflux(t1031-1,t1029+1,t1027)    
     .                    xyr_fracqmixflux(t1031-1,t1029+2,t1027) = sign(       
     .       1               1.00000000000000e+000,xyr_sedvel(t1031-1,t1029+2,  
     .       2               t1027))*xyr_fracqmixflux(t1031-1,t1029+2,t1027)    
     .                    xyr_fracqmixflux(t1031-1,t1029+3,t1027) = sign(       
     .       1               1.00000000000000e+000,xyr_sedvel(t1031-1,t1029+3,  
     .       2               t1027))*xyr_fracqmixflux(t1031-1,t1029+3,t1027)    
     .                    xyr_qmixflux(t1031-1,t1029,t1027) = xyr_intqmixflux(  
     .       1               t1031-1,t1029,t1027) + xyr_fracqmixflux(t1031-1,   
     .       2               t1029,t1027)                                       
     .                    xyr_qmixflux(t1031-1,t1029+1,t1027) = xyr_intqmixflux(
     .       1               t1031-1,t1029+1,t1027) + xyr_fracqmixflux(t1031-1, 
     .       2               t1029+1,t1027)                                     
     .                    xyr_qmixflux(t1031-1,t1029+2,t1027) = xyr_intqmixflux(
     .       1               t1031-1,t1029+2,t1027) + xyr_fracqmixflux(t1031-1, 
     .       2               t1029+2,t1027)                                     
     .                    xyr_qmixflux(t1031-1,t1029+3,t1027) = xyr_intqmixflux(
     .       1               t1031-1,t1029+3,t1027) + xyr_fracqmixflux(t1031-1, 
     .       2               t1029+3,t1027)                                     
     .                 enddo                                                    
     .              enddo                                                       
     .           endif                                                          
     .        enddo                                                             
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xyr_press)                                                 
     .        do k = 1, kmax*(xyr_qmixflux.DSC.U2*xyr_qmixflux.DSC.U1 +         
     .       1   xyr_qmixflux.DSC.U2)                                           
     .           xyz_dqmixdt(k-1,1,1) = (xyr_qmixflux(k-1,1,1)-xyr_qmixflux(k-1,
     .       1      1,0))/(xyr_press(k-1,1,1)-xyr_press(k-1,1,0))*grav          
     .        enddo                                                             
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1065 = 1, kmax*jmax*imax                                      
     .           xyz_qmixa1 = xyz_qmix(t1065-1,1,1) + xyz_dqmixdt(t1065-1,1,1)* 
     .       1      2.00000000000000e+000*deltime                               
     .           xyz_qmix(t1065-1,1,1) = xyz_qmixa1                             
     .        enddo                                                             
     .        t913 = cvmgt(0,1,loc(xy_surfgravsedflux).eq.1)                    
     .        if (t913 .eq. 0) goto 10122                                       
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1098 = 1, jmax*imax                                           
     .           xy_surfgravsedflux(t1098-1,1) = xyr_qmixflux(t1098-1,1,0)      
     .        enddo                                                             
     .  10122 continue                                                          
     .        if (fy_ccompi(4,spcname,'MarsH2OCloud',CHARLEN.spcname,12) .eq. 0 
     .       1   ) goto 10123                                                   
     .        %IG14.DSC.U1 = xyz_partdia.DSC.U1 + 1                             
     .        %IG14.DSC.U2 = xyz_partdia.DSC.U2 - 1 + 1                         
     .        %IG14.DSC.U3 = xyz_partdia.DSC.U3 - 1 + 1                         
     .        allocate (%IG14(1:xyz_partdia.DSC.U1+1,1:xyz_partdia.DSC.U2-1+1,1:
     .       1   xyz_partdia.DSC.U3-1+1))                                       
     .  !cdir nodep                                                             
     .        do t1086 = 0, xyz_partdia.DSC.U3 - 1                              
     .           if (xyz_partdia.DSC.U2 .gt. 0) then                            
     .              j8 = and(xyz_partdia.DSC.U2,3)                              
     .  !cdir       nodep                                                       
     .              do t1088 = 1, j8                                            
     .                 d9 = 1.D0/2.00000000000000e+000                          
     .  !cdir          nodep                                                    
     .                 do t1090 = 1, xyz_partdia.DSC.U1 + 1                     
     .                    %IG14(t1090,t1088,t1086+1) = xyz_partdia(t1090-1,t1088
     .       1               ,t1086+1)*d9                                       
     .                 enddo                                                    
     .              enddo                                                       
     .  !cdir       nodep                                                       
     .              do t1088 = j8 + 1, xyz_partdia.DSC.U2, 4                    
     .                 d10 = 1.D0/2.00000000000000e+000                         
     .                 d11 = 1.D0/2.00000000000000e+000                         
     .                 d12 = 1.D0/2.00000000000000e+000                         
     .                 d13 = 1.D0/2.00000000000000e+000                         
     .  !cdir          nodep                                                    
     .                 do t1090 = 1, xyz_partdia.DSC.U1 + 1                     
     .                    %IG14(t1090,t1088,t1086+1) = xyz_partdia(t1090-1,t1088
     .       1               ,t1086+1)*d10                                      
     .                    %IG14(t1090,t1088+1,t1086+1) = xyz_partdia(t1090-1,   
     .       1               t1088+1,t1086+1)*d11                               
     .                    %IG14(t1090,t1088+2,t1086+1) = xyz_partdia(t1090-1,   
     .       1               t1088+2,t1086+1)*d12                               
     .                    %IG14(t1090,t1088+3,t1086+1) = xyz_partdia(t1090-1,   
     .       1               t1088+3,t1086+1)*d13                               
     .                 enddo                                                    
     .              enddo                                                       
     .           endif                                                          
     .        enddo                                                             
     .        call historyautoputdouble3 (timen, 'MarsH2OCloudRadius', %IG14, 1 
     .       1   , 18)                                                          
     .        deallocate (%IG14)                                                
     .  10123 continue                                                          
   485  
   486    !------------------------------------------------------------------------------------
   487    ! Sedimentation velocity is calculated by the use of a formula of Conrath (1975)
   488    !
   489  
   490    function aaa_SedVel(                                                   &
   491      & MolVisCoef, MeanFreePathRef, PressLambdaRef, PartDen, aaa_PartDia, &
   492      & aaa_Press                                                          &
   493      & ) result( aaa_Result )
   494  
   495      ! 物理定数設定
   496      ! Physical constants settings
   497      !
   498      use constants, only: &
   499        & Grav
   500                                ! $ g $ [m s-2].
   501                                ! 重力加速度.
   502                                ! Gravitational acceleration
   503  
   504  
   505      real(DP), intent(in) :: MolVisCoef
   506      real(DP), intent(in) :: MeanFreePathRef
   507      real(DP), intent(in) :: PressLambdaRef
   508      real(DP), intent(in) :: PartDen
   509      real(DP), intent(in) :: aaa_PartDia(:,:,:)
   510      real(DP), intent(in) :: aaa_Press(:,:,:)
   511  
   512      real(DP) :: aaa_Result(size(aaa_Press,1),size(aaa_Press,2),size(aaa_Press,3))
   513  
   514      !
   515      ! local variables
   516      !
   517      real(DP) :: aaa_MeanFreePath(size(aaa_Press,1),size(aaa_Press,2),size(aaa_Press,3))
   518  
   519  
   520      ! 実行文 ; Executable statement
   521      !
   522  
   523      aaa_MeanFreePath = MeanFreePathRef * ( PressLambdaRef / aaa_Press )
     .        if (aaa_press.DSC.U2 .gt. 0) then                                 
     .           j7 = and(aaa_press.DSC.U2,3)                                   
     .  !cdir    nodep                                                          
     .           do t84 = 1, j7                                                 
     .              d2 = partden*grav/(1.80000000000000e+001*molviscoef)        
     .  !cdir       nodep                                                       
     .              do t86 = 1, aaa_press.DSC.U1                                
     .                 aaa_meanfreepath1 = meanfreepathref*(presslambdaref/     
     .       1            aaa_press(t86,t84,t82+1))                             
     .                 aaa_result(t86,t84,t82+1) = -aaa_partdia(t86,t84,t82+1)* 
     .       1            d2*(aaa_partdia(t86,t84,t82+1)+2.00000000000000e+000* 
     .       2            aaa_meanfreepath1)                                    
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t84 = j7 + 1, aaa_press.DSC.U2, 4                           
     .              d3 = (partden*grav)/(1.80000000000000e+001*molviscoef)      
     .              d4 = (partden*grav)/(1.80000000000000e+001*molviscoef)      
     .              d5 = (partden*grav)/(1.80000000000000e+001*molviscoef)      
     .              d6 = (partden*grav)/(1.80000000000000e+001*molviscoef)      
     .  !cdir       nodep                                                       
     .              do t86 = 1, aaa_press.DSC.U1                                
     .                 aaa_meanfreepath(t86,t84,t82+1) = meanfreepathref*(      
     .       1            presslambdaref/aaa_press(t86,t84,t82+1))              
     .                 aaa_meanfreepath(t86,t84+1,t82+1) = meanfreepathref*(    
     .       1            presslambdaref/aaa_press(t86,t84+1,t82+1))            
     .                 aaa_meanfreepath(t86,t84+2,t82+1) = meanfreepathref*(    
     .       1            presslambdaref/aaa_press(t86,t84+2,t82+1))            
     .                 aaa_meanfreepath(t86,t84+3,t82+1) = meanfreepathref*(    
     .       1            presslambdaref/aaa_press(t86,t84+3,t82+1))            
     .                 aaa_result(t86,t84,t82+1) = -aaa_partdia(t86,t84,t82+1)* 
     .       1            d3*(aaa_partdia(t86,t84,t82+1)+2.00000000000000e+000* 
     .       2            aaa_meanfreepath(t86,t84,t82+1))                      
     .                 aaa_result(t86,t84+1,t82+1) = -aaa_partdia(t86,t84+1,t82+
     .       1            1)*d4*(aaa_partdia(t86,t84+1,t82+1)+                  
     .       2            2.00000000000000e+000*aaa_meanfreepath(t86,t84+1,t82+1
     .       3            ))                                                    
     .                 aaa_result(t86,t84+2,t82+1) = -aaa_partdia(t86,t84+2,t82+
     .       1            1)*d5*(aaa_partdia(t86,t84+2,t82+1)+                  
     .       2            2.00000000000000e+000*aaa_meanfreepath(t86,t84+2,t82+1
     .       3            ))                                                    
     .                 aaa_result(t86,t84+3,t82+1) = -aaa_partdia(t86,t84+3,t82+
     .       1            1)*d6*(aaa_partdia(t86,t84+3,t82+1)+                  
     .       2            2.00000000000000e+000*aaa_meanfreepath(t86,t84+3,t82+1
     .       3            ))                                                    
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
   524  !!$    aaa_Result =                                                     &
   525  !!$      & - PartDen * Grav * aaa_PartDia**2 / ( 18.0_DP * MolVisCoef ) &
   526  !!$      & * ( 1.0_DP + 2.0_DP * aaa_MeanFreePath / aaa_PartDia )
   527      aaa_Result =                                                  &
   528        & - PartDen * Grav * aaa_PartDia / ( 18.0_DP * MolVisCoef ) &
   529        & * ( aaa_PartDia + 2.0_DP * aaa_MeanFreePath )
   530  
   531  
   532    end function aaa_SedVel
   533  
   534    !--------------------------------------------------------------------------------------
   535  !!$  !
   536  !!$  ! This routine works as an adjustment-type one.
   537  !!$  !
   538  !!$
   539  !!$  subroutine dust_borrowingfrombelow( damassn, gdmmrn, gdmassg, ijs, ije )
   540  !!$
   541  !!$    use matype
   542  !!$    use maparam, only : imax, jmax, kmax
   543  !!$
   544  !!$    implicit none
   545  !!$
   546  !!$    real(dp)    , intent(in   ) :: damassn( imax, jmax, kmax )
   547  !!$    real(dp)    , intent(inout) :: gdmmrn ( imax, jmax, kmax )
   548  !!$    real(dp)    , intent(inout) :: gdmassg( imax, jmax )
   549  !!$    integer(i4b), intent(in   ) :: ijs, ije
   550  !!$
   551  !!$
   552  !!$    !
   553  !!$    ! local variables
   554  !!$    !
   555  !!$    ! ddm     : dust deficit mass
   556  !!$    !
   557  !!$    real(dp)                :: ddm
   558  !!$
   559  !!$    integer(i4b)            :: ij, k
   560  !!$    integer(i4b), parameter :: j = 1
   561  !!$
   562  !!$
   563  !!$    !
   564  !!$    ! borrowing
   565  !!$    !
   566  !!$    do k = 1, kmax-1
   567  !!$      do ij = ijs, ije
   568  !!$        ddm = -min( gdmmrn( ij, j, k ), 0.0d0 ) * damassn( ij, j, k )
   569  !!$        gdmmrn( ij, j, k   ) = max( gdmmrn( ij, j, k ), 0.0d0 )
   570  !!$        gdmmrn( ij, j, k+1 ) = gdmmrn( ij, j, k+1 ) &
   571  !!$          - ddm / damassn( ij, j, k+1 )
   572  !!$      end do
   573  !!$    end do
   574  !!$    k = kmax
   575  !!$    do ij = ijs, ije
   576  !!$      ddm = -min( gdmmrn( ij, j, k ), 0.0d0 ) * damassn( ij, j, k )
   577  !!$      gdmmrn ( ij, j, k ) = max( gdmmrn( ij, j, k ), 0.0d0 )
   578  !!$      gdmassg( ij, j )    = gdmassg( ij, j ) + ddm
   579  !!$    end do
   580  !!$
   581  !!$
   582  !!$  end subroutine dust_borrowingfrombelow
   583  !!$
   584    !--------------------------------------------------------------------------------------
   585  
   586    subroutine GravSedInit
   587  
   588      ! モジュール引用 ; USE statements
   589      !
   590  
   591      ! 種別型パラメタ
   592      ! Kind type parameter
   593      !
   594      use dc_types, only: STDOUT ! 標準出力の装置番号. Unit number of standard output
   595  
   596      ! NAMELIST ファイル入力に関するユーティリティ
   597      ! Utilities for NAMELIST file input
   598      !
   599      use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid
   600  
   601      ! ファイル入出力補助
   602      ! File I/O support
   603      !
   604      use dc_iounit, only: FileOpen
   605  
   606      ! ヒストリデータ出力
   607      ! History data output
   608      !
   609      use gtool_historyauto, only: HistoryAutoAddVariable
   610  
   611      ! 組成に関わる配列の設定
   612      ! Settings of array for atmospheric composition
   613      !
   614      use composition, only: a_QMixName
   615  
   616      ! 座標データ設定
   617      ! Axes data settings
   618      !
   619      use axesset, only : &
   620        & AxnameX, &
   621        & AxnameY, &
   622        & AxnameZ, &
   623        & AxnameT
   624  
   625  
   626      ! 宣言文 ; Declaration statements
   627      !
   628      implicit none
   629  
   630      integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号.
   631                                ! Unit number for NAMELIST file open
   632      integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT.
   633                                ! IOSTAT of NAMELIST read
   634  
   635      integer  :: n
   636  
   637      ! NAMELIST 変数群
   638      ! NAMELIST group name
   639      !
   640      namelist /grav_sed_nml/    &
   641        & RadiusMarsH2OCloud,    &
   642        & IceNumRatio,           &
   643        & DOD067ForMarsH2OCloud
   644  !!$      & FlagConstDiffCoef,              &
   645  !!$      & ConstDiffCoefM, ConstDiffCoefH, &
   646  !!$!
   647  !!$      & SquareVelMin, BulkRiNumMin,     &
   648  !!$!
   649  !!$      & MixLengthMax, TildeShMin, TildeSmMin, &
   650  !!$      & VelDiffCoefMin, TempDiffCoefMin, QMixDiffCoefMin, &
   651  !!$      & VelDiffCoefMax, TempDiffCoefMax, QMixDiffCoefMax, &
   652  !!$!
   653  !!$      & MYLv2ParamA1, MYLv2ParamB1, MYLv2ParamA2, MYLv2ParamB2, MYLv2ParamC1, &
   654  !!$      & FlagCalcRiWithTv
   655  
   656  
   657      ! 実行文 ; Executable statement
   658      !
   659  
   660      if ( grav_sed_inited ) return
   661  
   662  
   663      ! デフォルト値の設定
   664      ! Default values settings
   665      !
   666      RadiusMarsH2OCloud    =  1.0e-6_DP
   667      IceNumRatio           = -1.0_DP
   668      DOD067ForMarsH2OCloud =  0.3_DP
   669  
   670      ! NAMELIST の読み込み
   671      ! NAMELIST is input
   672      !
   673      if ( trim(namelist_filename) /= '' ) then
   674        call FileOpen( unit_nml, &          ! (out)
   675          & namelist_filename, mode = 'r' ) ! (in)
   676  
   677        rewind( unit_nml )
   678        read( unit_nml, &                   ! (in)
   679          & nml = grav_sed_nml, &           ! (out)
   680          & iostat = iostat_nml )           ! (out)
   681        close( unit_nml )
   682  
   683        call NmlutilMsg( iostat_nml, module_name ) ! (in)
   684        if ( iostat_nml == 0 ) write( STDOUT, nml = grav_sed_nml )
   685      end if
   686  
   687      ! ヒストリデータ出力のためのへの変数登録
   688      ! Register of variables for history data output
   689      !
   690      call HistoryAutoAddVariable( 'MarsH2OCloudRadius', &
   691        & (/ AxnameX, AxnameY, AxnameZ, AxnameT /), &
   692        & 'Mars H2O Cloud Radius', &
   693        & 'm' )
   694  
   695  !!$    do n = 1, ncmax
   696  !!$      call HistoryAutoAddVariable( 'Surf'//trim(a_QMixName(n))//'GravSedFlux', &
   697  !!$        & (/ 'lon ', 'lat ', 'time' /), &
   698  !!$        & 'surface gravitational sedimentation flux of ' // trim(a_QMixName(n)), &
   699  !!$        & 'kg m-2 s-1' )
   700  !!$    end do
   701  
   702  
   703      ! 印字 ; Print
   704      !
   705      call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   706      call MessageNotify( 'M', module_name, ' RadiusMarsH2OCloud    = %f', d = (/ RadiusMarsH2OCloud /) )
   707      call MessageNotify( 'M', module_name, ' IceNumRatio           = %f', d = (/ IceNumRatio /) )
   708      call MessageNotify( 'M', module_name, ' DOD067ForMarsH2OCloud = %f', d = (/ DOD067ForMarsH2OCloud /) )
   709      call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   710  
   711      grav_sed_inited = .true.
   712  
   713    end subroutine GravSedInit
   714  
   715    !--------------------------------------------------------------------------------------
   716  
   717  end module grav_sed
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:55 2016
FILE NAME: grav_sed.f90
PROGRAM NAME: grav_sed
FORMAT LIST

  LINE    LOOP      FORTRAN STATEMENT

     1:             != 重力沈降過程
     2:             !
     3:             != Gravitational sedimentation process
     4:             !
     5:             ! Authors::   Yoshiyuki O. TAKAHASHI
     6:             ! Version::   $Id: grav_sed.f90,v 1.3 2014/05/07 09:39:24 murashin Exp $
     7:             ! Tag Name::  $Name:  $
     8:             ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9:             ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10:             !
    11:             module grav_sed
    12:               !
    13:               != 重力沈降過程
    14:               !
    15:               != Gravitational sedimentation process
    16:               !
    17:               ! <b>Note that Japanese and English are described in parallel.</b>
    18:               !
    19:               ! 重力沈降過程を計算するモジュールです.
    20:               !
    21:               ! This module calculates gravitational sedimentation. 
    22:               !
    23:               !== Procedures List
    24:               !
    25:               ! GravSed         :: 計算
    26:               ! GravSedInit     :: 初期化
    27:               ! --------------- :: ------------
    28:               ! GravSed         :: Calculation
    29:               ! GravSedInit     :: Initialization
    30:               !
    31:               !== NAMELIST
    32:               !
    33:               ! NAMELIST#grav_sed_nml
    34:               !
    35:               !== References
    36:               !
    37:               ! * Conrath, B. J., 1975:
    38:               !   Thermal structure of the Martian atmosphere during the dissipation of 
    39:               !   the dust storm of 1971, 
    40:               !   <i>Icarus</i>, <b>24</b>, 36--46.
    41:               !
    42:               ! * Lin, S.-J., and R. B. Rood, 1996:
    43:               !   Multidimensional flux-form semi-Lagrangian transport scheme, 
    44:               !   <i>Mon. Wea. Rev.</i>, <b>124</b>, 2046--2070.
    45:               !
    46:             
    47:               ! モジュール引用 ; USE statements
    48:               !
    49:             
    50:               ! 種別型パラメタ
    51:               ! Kind type parameter
    52:               !
    53:               use dc_types, only: DP, &      ! 倍精度実数型. Double precision.
    54:                 &                 STRING     ! 文字列.       Strings.
    55:             
    56:               ! メッセージ出力
    57:               ! Message output
    58:               !
    59:               use dc_message, only: MessageNotify
    60:             
    61:               ! 組成に関わる配列の設定
    62:               ! Settings of array for atmospheric composition
    63:               !
    64:               use composition, only: ncmax
    65:             
    66:               ! 格子点設定
    67:               ! Grid points settings
    68:               !
    69:               use gridset, only: imax, & ! 経度格子点数.
    70:                                          ! Number of grid points in longitude
    71:                 &                jmax, & ! 緯度格子点数.
    72:                                          ! Number of grid points in latitude
    73:                 &                kmax    ! 鉛直層数.
    74:                                          ! Number of vertical level
    75:             
    76:             
    77:               ! 宣言文 ; Declaration statements
    78:               !
    79:               implicit none
    80:               private
    81:             
    82:               ! 公開手続き
    83:               ! Public procedure
    84:               !
    85:               public :: GravSed
    86:               public :: GravSedInit
    87:             
    88:             
    89:               ! 公開変数
    90:               ! Public variables
    91:               !
    92:             
    93:               ! 非公開変数
    94:               ! Private variables
    95:               !
    96:               real(DP), save :: RadiusMarsH2OCloud
    97:               real(DP), save :: IceNumRatio
    98:               real(DP), save :: DOD067ForMarsH2OCloud
    99:             
   100:               logical, save :: grav_sed_inited = .false.
   101:                                           ! 初期設定フラグ.
   102:                                           ! Initialization flag
   103:             
   104:             
   105:               character(*), parameter:: module_name = 'grav_sed'
   106:                                           ! モジュールの名称.
   107:                                           ! Module name
   108:               character(*), parameter:: version = &
   109:                 & '$Name:  $' // &
   110:                 & '$Id: grav_sed.f90,v 1.3 2014/05/07 09:39:24 murashin Exp $'
   111:                                           ! モジュールのバージョン
   112:                                           ! Module version
   113:             
   114:             
   115:               !------------------------------------------------------------------------------------
   116:             
   117:             contains
   118:             
   119:               !------------------------------------------------------------------------------------
   120:               ! Gravitational sedimentation is calculated.
   121:               ! This routine works as adjustment routine, i.e., mass mixing ratio is 
   122:               ! updated in this routine. 
   123:               ! Current version calculates sedimentation of dust, only. 
   124:               ! In this routine, gravitational sedimentation is calculated by the use of 
   125:               ! a method following flux-form semi-Lagrangian transport scheme (Lin and 
   126:               ! Rood, 1996). 
   127:               !
   128:             
   129:               subroutine GravSed(                    &
   130:                 & SpcName,                           & ! (in )
   131:                 & xyr_Press, xyr_Height,             & ! (in )
   132:                 & xyz_QMix,                          & ! (out)
   133:                 & xy_SurfGravSedFlux                 & ! (out) optional
   134:                 & )
   135:             
   136:                 ! ヒストリデータ出力
   137:                 ! History data output
   138:                 !
   139:                 use gtool_historyauto, only: HistoryAutoPut
   140:             
   141:                 ! 組成に関わる配列の設定
   142:                 ! Settings of array for atmospheric composition
   143:                 !
   144:                 use composition, only: a_QMixName
   145:             
   146:                 ! 時刻管理
   147:                 ! Time control
   148:                 !
   149:                 use timeset, only: &
   150:                   & TimeN, &              ! ステップ $ t $ の時刻. Time of step $ t $.
   151:                   & TimesetClockStart, TimesetClockStop, &
   152:                   & DelTime                 ! $ \Delta t $ [s]
   153:             
   154:                 ! 物理・数学定数設定
   155:                 ! Physical and mathematical constants settings
   156:                 !
   157:                 use constants0, only: &
   158:                   & PI                    ! $ \pi $ .
   159:                 ! 円周率.  Circular constant
   160:             
   161:                 ! 物理定数設定
   162:                 ! Physical constants settings
   163:                 !
   164:                 use constants, only: &
   165:                   & Grav, &
   166:                                           ! $ g $ [m s-2].
   167:                                           ! 重力加速度.
   168:                                           ! Gravitational acceleration
   169:                   & GasRDry
   170:                                           ! $ R $ [J kg-1 K-1].
   171:                                           ! 乾燥大気の気体定数.
   172:                                           ! Gas constant of air
   173:             
   174:             
   175:                 character(*), intent(in   ) :: SpcName
   176:                 real(DP)    , intent(in   ) :: xyr_Press  (0:imax-1, 1:jmax, 0:kmax)
   177:                 real(DP)    , intent(in   ) :: xyr_Height (0:imax-1, 1:jmax, 0:kmax)
   178:                 real(DP)    , intent(inout) :: xyz_QMix   (0:imax-1, 1:jmax, 1:kmax)
   179:                 real(DP)    , intent(out  ), optional :: xy_SurfGravSedFlux(0:imax-1, 1:jmax)
   180:             
   181:             
   182:                 !
   183:                 ! local variables
   184:                 !
   185:                 ! rhod : dust density
   186:                 ! mfp  : mean free path
   187:                 ! mvc  : modecular viscosity coefficient
   188:                 ! rdia : particle diameter
   189:                 !
   190:                 real(DP) :: PartDen
   191:                 real(DP) :: xyr_PartDia(0:imax-1, 1:jmax, 0:kmax)
   192:                 real(DP) :: MeanFreePath
   193:                 real(DP) :: MolVisCoef
   194:             
   195:                 real(DP) :: MeanFreePathRef
   196:                 real(DP) :: PressLambdaRef
   197:             
   198:             
   199:                 real(DP) :: xyz_DelAtmMass  (0:imax-1, 1:jmax, 1:kmax)
   200:                 real(DP) :: xyz_DelCompMass (0:imax-1, 1:jmax, 1:kmax)
   201:                 real(DP) :: xyz_DelZ        (0:imax-1, 1:jmax, 1:kmax)
   202:                 real(DP) :: xyr_SedVel      (0:imax-1, 1:jmax, 0:kmax)
   203:                 real(DP) :: xyr_FracSedDist (0:imax-1, 1:jmax, 0:kmax)
   204:                 real(DP) :: xyr_Dist        (0:imax-1, 1:jmax, 0:kmax)
   205:                 integer  :: xyr_KIndex      (0:imax-1, 1:jmax, 0:kmax)
   206:                 real(DP) :: xyr_QMixFlux    (0:imax-1, 1:jmax, 0:kmax)
   207:                 real(DP) :: xyr_IntQMixFlux (0:imax-1, 1:jmax, 0:kmax)
   208:                 real(DP) :: xyr_FracQMixFlux(0:imax-1, 1:jmax, 0:kmax)
   209:                 real(DP) :: xyz_DQMixDt     (0:imax-1, 1:jmax, 1:kmax)
   210:                 real(DP) :: xyz_QMixA       (0:imax-1, 1:jmax, 1:kmax)
   211:                 real(DP) :: LogPress
   212:                 real(DP) :: Press
   213:             
   214:                 real(DP), parameter :: AMU = 1.6605655e-27_DP
   215:             
   216:                 real(DP) :: DustExtEff
   217:                 real(DP) :: DustREff
   218:                 real(DP) :: DOD067Ref
   219:                 real(DP) :: MeanMolMass
   220:                 real(DP) :: PressRef
   221:                 real(DP) :: DustNumRatio
   222:             !!$    real(DP) :: xyr_NumDensDust(0:imax-1, 1:jmax, 0:kmax)
   223:             !!$    real(DP) :: xyr_NumDensIce (0:imax-1, 1:jmax, 0:kmax)
   224:                 real(DP) :: xyz_PartDia    (0:imax-1, 1:jmax, 1:kmax)
   225:             
   226:                 integer  :: i
   227:                 integer  :: j
   228:                 integer  :: k
   229:                 integer  :: kk
   230:             
   231:             
   232:                 ! 実行文 ; Executable statement
   233:                 !
   234:             
   235:                 ! 初期化確認
   236:                 ! Initialization check
   237:                 !
   238:                 if ( .not. grav_sed_inited ) then
   239:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   240:                 end if
   241:             
   242:             
   243:             
   244:                 ! Calculation of mass in each layer and layer thickness in unit of meter
   245:                 !   Layer thickness is calculated by using mass of a layer.
   246:             !!$    xyz_Rho = xyz_Press / ( GasRDry * xyz_VirTemp )
   247: W------>        do k = 1, kmax
   248: |**---->A         xyz_DelAtmMass(:,:,k) = ( xyr_Press(:,:,k-1) - xyr_Press(:,:,k) ) / Grav
   249: |||             end do
   250: |||         !!$    xyz_DelZ = xyz_DelAtmMass / xyz_Rho
   251: |||             do k = 1, kmax
   252: |**----           xyz_DelZ(:,:,k) = xyr_Height(:,:,k) - xyr_Height(:,:,k-1)
   253: W------         end do
   254:             
   255:             
   256:                 ! Calculation of mass of constituents in a layer
   257: W**==== A       xyz_DelCompMass = xyz_QMix * xyz_DelAtmMass
   258:             
   259:             
   260:                 !
   261:                 ! calculation of sedimentation terminal velocity
   262:                 !
   263:                 if ( SpcName == 'MarsDust' ) then
   264:             
   265:                   !
   266:                   ! The values below are obtained from Conrath (1975). 
   267:                   ! Particle radius of 1e-6 m is assumed. 
   268:                   !
   269:                   MolVisCoef      = 1.5e-4_DP * 1.0e-3_DP * 1.0e2_DP
   270:                   MeanFreePathRef = 2.2e-4_DP * 1.0e-2_DP
   271:                   PressLambdaRef  = 25.0e2_DP
   272:                   PartDen         = 3.0e3_DP
   273: W**==== A         xyr_PartDia     = 2.0_DP * 1.0e-6_DP
   274:             
   275: W**==== A         xyr_SedVel = &
   276:                     & aaa_SedVel( &
   277:                     &   MolVisCoef, MeanFreePathRef, PressLambdaRef, PartDen, xyr_PartDia, &
   278:                     &   max( xyr_Press, 1.0e-20_DP )                                       &
   279:                     & )
   280:                   k = kmax
   281: +V===== A         xyr_SedVel(:,:,k) = 0.0_DP
   282:             
   283:                 else if ( SpcName == 'MarsH2OCloud' ) then
   284:             
   285:                   !
   286:                   ! The values below are obtained from Conrath (1975). 
   287:                   !
   288:                   MolVisCoef      = 1.5e-4_DP * 1.0e-3_DP * 1.0e2_DP
   289:                   MeanFreePathRef = 2.2e-4_DP * 1.0e-2_DP
   290:                   PressLambdaRef  = 25.0e2_DP
   291:                   !
   292:                   ! Particle radius of 1e-6 m is assumed. 
   293:                   !
   294:                   PartDen         = 1.0e3_DP
   295:             !!$      PartDia         = 2.0_DP * 1.0e-6_DP
   296:                   if ( RadiusMarsH2OCloud > 0.0_DP ) then
   297: ++V==== A           xyr_PartDia         = 2.0_DP * RadiusMarsH2OCloud
   298:                   else
   299:                     MeanMolMass  = 44.0_DP * AMU
   300:                     ! DOD067Ref : Dust optical depth at 0.67 um
   301:                     if ( IceNumRatio < 0.0_DP ) then
   302:                       DustExtEff   = 3.04_DP    ! Ockert-Bell et al. (1997)
   303:                       DustREff     = 1.85e-6_DP ! Ockert-Bell et al. (1997)
   304:                       DOD067Ref    = DOD067ForMarsH2OCloud
   305:                       PressRef     = 700.0_DP
   306:                       ! DustNumRatio : numb. dens. of dust / num. dens. of atm. molecules.
   307:                       DustNumRatio = DOD067Ref * MeanMolMass &
   308:                         & / ( DustExtEff * PI * DustREff**2 * PressRef / Grav )
   309:                       IceNumRatio = DustNumRatio
   310:             !!$        xyz_NumDensDust = DustNumRatio * xyz_Rho / MeanMolMass
   311:             !!$        xyz_NumDensIce  = xyz_NumDensDust
   312:                     end if
   313:                     ! calculate radius, first
   314:             !!$        xyz_PartDia = &
   315:             !!$          & (                                                       &
   316:             !!$          &     xyz_QMix * xyz_Rho                                  &
   317:             !!$          &   / ( xyz_NumDensIce * PartDen * 4.0_DP / 3.0_DP * PI ) &
   318:             !!$          & )**(1.0_DP/3.0_DP)
   319: **W---->A           xyz_PartDia =                                               &
   320: |||                   & (                                                       &
   321: |||                   &     xyz_QMix * MeanMolMass                              &
   322: |||                   &   / ( IceNumRatio * PartDen * 4.0_DP / 3.0_DP * PI )    &
   323: |||                   & )**(1.0_DP/3.0_DP)
   324: |||                 ! calculate diameter
   325: **W----             xyz_PartDia = 2.0_DP * xyz_PartDia
   326:                     !
   327: W**==== A           xyr_PartDia(:,:,0:kmax-1) = xyz_PartDia(:,:,1:kmax)
   328: W*===== A           xyr_PartDia(:,:,kmax) = 0.0_DP
   329:                   end if
   330:             
   331: W**==== A         xyr_SedVel = &
   332:                     & aaa_SedVel(                                                          &
   333:                     &   MolVisCoef, MeanFreePathRef, PressLambdaRef, PartDen, xyr_PartDia, &
   334:                     &   max( xyr_Press, 1.0e-20_DP )                                       &
   335:                     & )
   336:                   k = kmax
   337: +V===== A         xyr_SedVel(:,:,k) = 0.0_DP
   338:             
   339:                 else
   340:                   call MessageNotify( 'E', module_name, 'Specie %c is inappropriate', c1 = trim( SpcName ) )
   341:                 end if
   342:             
   343:             
   344:                 ! Calculation of sedimentation distance during a time step of 2 * DelTime
   345: ++V==== A       xyr_Dist = abs( xyr_SedVel ) * 2.0_DP * DelTime
   346: +------>        do k = 0, kmax-1
   347: |+----->          do j = 1, jmax
   348: ||+---->            do i = 0, imax-1
   349: |||         
   350: |||                   ! A k index in which all mass of the layer does not fall is 
   351: |||                   ! searched. In addition, fractional sedimentation velocity is 
   352: |||                   ! calculated. 
   353: |||                   xyr_KIndex(i,j,k) = -1
   354: |||+--->              do kk = k+1, kmax-1
   355: ||||                    ! If sedimentation velocity (distance) is positive, and all of 
   356: ||||                    ! mass in kk layer does not fall, KIndex is kk.
   357: ||||                    if ( ( xyr_Dist(i,j,k) >= 0.0_DP ) .and. &
   358: ||||                      &  ( xyr_Dist(i,j,k) <= xyz_DelZ(i,j,kk) ) ) then
   359: ||||                      xyr_KIndex     (i,j,k) = kk
   360: ||||                      xyr_FracSedDist(i,j,k) = xyr_Dist(i,j,k)
   361: ||||                    end if
   362: ||||                    ! Sedimentation distance is decreased for preparation for next 
   363: ||||                    ! layer.
   364: ||||                    ! If xyz_Dist become negative, any mass of the upper layer does 
   365: ||||                    ! not fall.
   366: ||||                    xyr_Dist(i,j,k) = xyr_Dist(i,j,k) - xyz_DelZ(i,j,kk)
   367: |||+---               end do
   368: |||                   ! Calculation for upper most layer.
   369: |||                   kk = kmax
   370: |||                   if ( xyr_Dist(i,j,k) >= 0.0_DP ) then
   371: |||                     xyr_KIndex     (i,j,k) = kk
   372: |||                     xyr_FracSedDist(i,j,k) = min( xyr_Dist(i,j,k), xyz_DelZ(i,j,kk) )
   373: |||                   end if
   374: |||         
   375: ||+----             end do
   376: |+-----           end do
   377: +------         end do
   378:                 ! K index and fractional sedimentation velocity at model top.
   379:                 ! No flux is assumed at the model top. 
   380:                 k = kmax
   381: *W----->        xyr_KIndex     (:,:,k) = -1
   382: *W-----         xyr_FracSedDist(:,:,k) = 0.0_DP
   383:             
   384:             
   385:                 ! Calculation of integer mass flux.
   386: W**====         xyr_IntQMixFlux = 0.0_DP
   387: +------>        do k = 0, kmax-1
   388: |+----->          do j = 1, jmax
   389: ||+---->            do i = 0, imax-1
   390: |||         
   391: |||V--->              do kk = k+1, xyr_KIndex(i,j,k)-1
   392: ||||    A               xyr_IntQMixFlux(i,j,k) = xyr_IntQMixFlux(i,j,k) &
   393: ||||                      & + xyz_DelCompMass(i,j,kk)
   394: |||V---               end do
   395: |||                   xyr_IntQMixFlux(i,j,k) = xyr_IntQMixFlux(i,j,k) / ( 2.0_DP * DelTime )
   396: |||         
   397: ||+----             end do
   398: |+-----           end do
   399: +------         end do
   400:             
   401:                 ! Add sign of sedimentation velocity.
   402:                 ! This is equivalent to mulplying -1.
   403: ++V==== A       xyr_IntQMixFlux = sign( 1.0_DP, xyr_SedVel ) * xyr_IntQMixFlux
   404:             
   405:             
   406:                 ! Calculation of fractional mass flux
   407:                 k = kmax
   408: W*=====         xyr_FracQMixFlux(:,:,k) = 0.0_DP
   409: +------>        do k = kmax-1, 0, -1
   410: |+----->          do j = 1, jmax
   411: ||V---->            do i = 0, imax-1
   412: |||                   kk = xyr_KIndex(i,j,k)
   413: |||                   !-----
   414: |||                   ! Simple method
   415: |||         !!$            xyrf_FracQMixFlux(i,j,k,n) =                       &
   416: |||         !!$              &   xyrf_FracSedDist(i,j,k,n) / xyz_DelZ(i,j,kk) &
   417: |||         !!$              & * xyzf_DelCompMass(i,j,kk,n)
   418: |||                   !-----
   419: |||                   ! Method considering exponential distribution of mass with height
   420: |||     A             if ( xyr_Press(i,j,kk) == 0.0_DP ) then
   421: |||     A               LogPress =                                                      &
   422: |||                       &   log( xyr_Press(i,j,kk-1) * 1.0e-1_DP / xyr_Press(i,j,kk-1) ) &
   423: |||                       & / xyz_DelZ(i,j,kk) * xyr_FracSedDist(i,j,k)                 &
   424: |||                       & + log( xyr_Press(i,j,kk-1) )
   425: |||                     Press = exp( LogPress )
   426: |||     A               xyr_FracQMixFlux(i,j,k) =                                     &
   427: |||                       &   ( xyr_Press(i,j,kk-1) - Press                        )  &
   428: |||                       & / ( xyr_Press(i,j,kk-1) - xyr_Press(i,j,kk-1) * 1.0e-1_DP )  &
   429: |||                       & * xyz_DelCompMass(i,j,kk)
   430: |||                   else
   431: |||     A               LogPress =                                           &
   432: |||                       &   log( xyr_Press(i,j,kk) / xyr_Press(i,j,kk-1) ) &
   433: |||                       & / xyz_DelZ(i,j,kk) * xyr_FracSedDist(i,j,k)      &
   434: |||                       & + log( xyr_Press(i,j,kk-1) )
   435: |||                     Press = exp( LogPress )
   436: |||     A               xyr_FracQMixFlux(i,j,k) =                          &
   437: |||                       &   ( xyr_Press(i,j,kk-1) - Press             )  &
   438: |||                       & / ( xyr_Press(i,j,kk-1) - xyr_Press(i,j,kk) )  &
   439: |||                       & * xyz_DelCompMass(i,j,kk)
   440: |||                   end if
   441: |||                   !-----
   442: |||                   xyr_FracQMixFlux(i,j,k) = xyr_FracQMixFlux(i,j,k) &
   443: |||                     & / ( 2.0_DP * DelTime )
   444: ||V----             end do
   445: |+-----           end do
   446: +------         end do
   447:             
   448:                 ! Add sign of sedimentation velocity.
   449:                 ! This is equivalent to mulplying -1.
   450: **V---->A       xyr_FracQMixFlux = sign( 1.0_DP, xyr_SedVel ) * xyr_FracQMixFlux
   451: |||         
   452: |||         
   453: **V----         xyr_QMixFlux = xyr_IntQMixFlux + xyr_FracQMixFlux
   454:             
   455:             
   456:                 !
   457:                 ! estimate dust mixing ratio at next time step
   458:                 !
   459: W------>        do k = 1, kmax
   460: |**==== A         xyz_DQMixDt(:,:,k) =                                  &
   461: |                   &   ( xyr_QMixFlux(:,:,k) - xyr_QMixFlux(:,:,k-1) ) &
   462: |                   & / ( xyr_Press   (:,:,k) - xyr_Press   (:,:,k-1) ) &
   463: |                   & * Grav
   464: W------         end do
   465:             
   466:             
   467: **W---->A       xyz_QMixA = xyz_QMix + xyz_DQMixDt * 2.0_DP * DelTime
   468: |||         
   469: **W---- A       xyz_QMix  = xyz_QMixA
   470:             
   471:             
   472:                 if ( present ( xy_SurfGravSedFlux ) ) then
   473: W*===== A         xy_SurfGravSedFlux = xyr_QMixFlux(:,:,0)
   474:                 end if
   475:             
   476:             
   477:                 ! ヒストリデータ出力
   478:                 ! History data output
   479:                 !
   480:                 if ( SpcName == 'MarsH2OCloud' ) then
   481: ++V====           call HistoryAutoPut( TimeN, 'MarsH2OCloudRadius', xyz_PartDia/2.0_DP )
   482:                 end if
   483:             
   484:               end subroutine GravSed
   485:             
   486:               !------------------------------------------------------------------------------------
   487:               ! Sedimentation velocity is calculated by the use of a formula of Conrath (1975)
   488:               !
   489:             
   490:               function aaa_SedVel(                                                   &
   491:                 & MolVisCoef, MeanFreePathRef, PressLambdaRef, PartDen, aaa_PartDia, &
   492:                 & aaa_Press                                                          &
   493:                 & ) result( aaa_Result )
   494:             
   495:                 ! 物理定数設定
   496:                 ! Physical constants settings
   497:                 !
   498:                 use constants, only: &
   499:                   & Grav
   500:                                           ! $ g $ [m s-2].
   501:                                           ! 重力加速度.
   502:                                           ! Gravitational acceleration
   503:             
   504:             
   505:                 real(DP), intent(in) :: MolVisCoef
   506:                 real(DP), intent(in) :: MeanFreePathRef
   507:                 real(DP), intent(in) :: PressLambdaRef
   508:                 real(DP), intent(in) :: PartDen
   509:                 real(DP), intent(in) :: aaa_PartDia(:,:,:)
   510:                 real(DP), intent(in) :: aaa_Press(:,:,:)
   511:             
   512:                 real(DP) :: aaa_Result(size(aaa_Press,1),size(aaa_Press,2),size(aaa_Press,3))
   513:             
   514:                 !
   515:                 ! local variables
   516:                 !
   517:                 real(DP) :: aaa_MeanFreePath(size(aaa_Press,1),size(aaa_Press,2),size(aaa_Press,3))
   518:             
   519:             
   520:                 ! 実行文 ; Executable statement
   521:                 !
   522:             
   523: **V---->A       aaa_MeanFreePath = MeanFreePathRef * ( PressLambdaRef / aaa_Press )
   524: |||         !!$    aaa_Result =                                                     &
   525: |||         !!$      & - PartDen * Grav * aaa_PartDia**2 / ( 18.0_DP * MolVisCoef ) &
   526: |||         !!$      & * ( 1.0_DP + 2.0_DP * aaa_MeanFreePath / aaa_PartDia )
   527: **V---- A       aaa_Result =                                                  &
   528:                   & - PartDen * Grav * aaa_PartDia / ( 18.0_DP * MolVisCoef ) &
   529:                   & * ( aaa_PartDia + 2.0_DP * aaa_MeanFreePath )
   530:             
   531:             
   532:               end function aaa_SedVel
   533:             
   534:               !--------------------------------------------------------------------------------------
   535:             !!$  !
   536:             !!$  ! This routine works as an adjustment-type one. 
   537:             !!$  !
   538:             !!$
   539:             !!$  subroutine dust_borrowingfrombelow( damassn, gdmmrn, gdmassg, ijs, ije )
   540:             !!$
   541:             !!$    use matype
   542:             !!$    use maparam, only : imax, jmax, kmax
   543:             !!$
   544:             !!$    implicit none
   545:             !!$
   546:             !!$    real(dp)    , intent(in   ) :: damassn( imax, jmax, kmax )
   547:             !!$    real(dp)    , intent(inout) :: gdmmrn ( imax, jmax, kmax )
   548:             !!$    real(dp)    , intent(inout) :: gdmassg( imax, jmax )
   549:             !!$    integer(i4b), intent(in   ) :: ijs, ije
   550:             !!$
   551:             !!$
   552:             !!$    !
   553:             !!$    ! local variables
   554:             !!$    !
   555:             !!$    ! ddm     : dust deficit mass
   556:             !!$    !
   557:             !!$    real(dp)                :: ddm
   558:             !!$
   559:             !!$    integer(i4b)            :: ij, k
   560:             !!$    integer(i4b), parameter :: j = 1
   561:             !!$
   562:             !!$
   563:             !!$    !
   564:             !!$    ! borrowing
   565:             !!$    !
   566:             !!$    do k = 1, kmax-1
   567:             !!$      do ij = ijs, ije
   568:             !!$        ddm = -min( gdmmrn( ij, j, k ), 0.0d0 ) * damassn( ij, j, k )
   569:             !!$        gdmmrn( ij, j, k   ) = max( gdmmrn( ij, j, k ), 0.0d0 )
   570:             !!$        gdmmrn( ij, j, k+1 ) = gdmmrn( ij, j, k+1 ) &
   571:             !!$          - ddm / damassn( ij, j, k+1 )
   572:             !!$      end do
   573:             !!$    end do
   574:             !!$    k = kmax
   575:             !!$    do ij = ijs, ije
   576:             !!$      ddm = -min( gdmmrn( ij, j, k ), 0.0d0 ) * damassn( ij, j, k )
   577:             !!$      gdmmrn ( ij, j, k ) = max( gdmmrn( ij, j, k ), 0.0d0 )
   578:             !!$      gdmassg( ij, j )    = gdmassg( ij, j ) + ddm
   579:             !!$    end do
   580:             !!$
   581:             !!$
   582:             !!$  end subroutine dust_borrowingfrombelow
   583:             !!$
   584:               !--------------------------------------------------------------------------------------
   585:             
   586:               subroutine GravSedInit
   587:             
   588:                 ! モジュール引用 ; USE statements
   589:                 !
   590:             
   591:                 ! 種別型パラメタ
   592:                 ! Kind type parameter
   593:                 !
   594:                 use dc_types, only: STDOUT ! 標準出力の装置番号. Unit number of standard output
   595:             
   596:                 ! NAMELIST ファイル入力に関するユーティリティ
   597:                 ! Utilities for NAMELIST file input
   598:                 !
   599:                 use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid
   600:             
   601:                 ! ファイル入出力補助
   602:                 ! File I/O support
   603:                 !
   604:                 use dc_iounit, only: FileOpen
   605:             
   606:                 ! ヒストリデータ出力
   607:                 ! History data output
   608:                 !
   609:                 use gtool_historyauto, only: HistoryAutoAddVariable
   610:             
   611:                 ! 組成に関わる配列の設定
   612:                 ! Settings of array for atmospheric composition
   613:                 !
   614:                 use composition, only: a_QMixName
   615:             
   616:                 ! 座標データ設定
   617:                 ! Axes data settings
   618:                 !
   619:                 use axesset, only : &
   620:                   & AxnameX, &
   621:                   & AxnameY, &
   622:                   & AxnameZ, &
   623:                   & AxnameT
   624:             
   625:             
   626:                 ! 宣言文 ; Declaration statements
   627:                 !
   628:                 implicit none
   629:             
   630:                 integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号.
   631:                                           ! Unit number for NAMELIST file open
   632:                 integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT.
   633:                                           ! IOSTAT of NAMELIST read
   634:             
   635:                 integer  :: n
   636:             
   637:                 ! NAMELIST 変数群
   638:                 ! NAMELIST group name
   639:                 !
   640:                 namelist /grav_sed_nml/    &
   641:                   & RadiusMarsH2OCloud,    &
   642:                   & IceNumRatio,           &
   643:                   & DOD067ForMarsH2OCloud
   644:             !!$      & FlagConstDiffCoef,              &
   645:             !!$      & ConstDiffCoefM, ConstDiffCoefH, &
   646:             !!$!
   647:             !!$      & SquareVelMin, BulkRiNumMin,     &
   648:             !!$!
   649:             !!$      & MixLengthMax, TildeShMin, TildeSmMin, &
   650:             !!$      & VelDiffCoefMin, TempDiffCoefMin, QMixDiffCoefMin, &
   651:             !!$      & VelDiffCoefMax, TempDiffCoefMax, QMixDiffCoefMax, &
   652:             !!$!
   653:             !!$      & MYLv2ParamA1, MYLv2ParamB1, MYLv2ParamA2, MYLv2ParamB2, MYLv2ParamC1, &
   654:             !!$      & FlagCalcRiWithTv
   655:             
   656:             
   657:                 ! 実行文 ; Executable statement
   658:                 !
   659:             
   660:                 if ( grav_sed_inited ) return
   661:             
   662:             
   663:                 ! デフォルト値の設定
   664:                 ! Default values settings
   665:                 !
   666:                 RadiusMarsH2OCloud    =  1.0e-6_DP
   667:                 IceNumRatio           = -1.0_DP
   668:                 DOD067ForMarsH2OCloud =  0.3_DP
   669:             
   670:                 ! NAMELIST の読み込み
   671:                 ! NAMELIST is input
   672:                 !
   673:                 if ( trim(namelist_filename) /= '' ) then
   674:                   call FileOpen( unit_nml, &          ! (out)
   675:                     & namelist_filename, mode = 'r' ) ! (in)
   676:             
   677:                   rewind( unit_nml )
   678:                   read( unit_nml, &                   ! (in)
   679:                     & nml = grav_sed_nml, &           ! (out)
   680:                     & iostat = iostat_nml )           ! (out)
   681:                   close( unit_nml )
   682:             
   683:                   call NmlutilMsg( iostat_nml, module_name ) ! (in)
   684:                   if ( iostat_nml == 0 ) write( STDOUT, nml = grav_sed_nml )
   685:                 end if
   686:             
   687:                 ! ヒストリデータ出力のためのへの変数登録
   688:                 ! Register of variables for history data output
   689:                 !
   690:                 call HistoryAutoAddVariable( 'MarsH2OCloudRadius', &
   691:                   & (/ AxnameX, AxnameY, AxnameZ, AxnameT /), &
   692:                   & 'Mars H2O Cloud Radius', &
   693:                   & 'm' )
   694:             
   695:             !!$    do n = 1, ncmax
   696:             !!$      call HistoryAutoAddVariable( 'Surf'//trim(a_QMixName(n))//'GravSedFlux', &
   697:             !!$        & (/ 'lon ', 'lat ', 'time' /), &
   698:             !!$        & 'surface gravitational sedimentation flux of ' // trim(a_QMixName(n)), &
   699:             !!$        & 'kg m-2 s-1' )
   700:             !!$    end do
   701:             
   702:             
   703:                 ! 印字 ; Print
   704:                 !
   705:                 call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   706:                 call MessageNotify( 'M', module_name, ' RadiusMarsH2OCloud    = %f', d = (/ RadiusMarsH2OCloud /) )
   707:                 call MessageNotify( 'M', module_name, ' IceNumRatio           = %f', d = (/ IceNumRatio /) )
   708:                 call MessageNotify( 'M', module_name, ' DOD067ForMarsH2OCloud = %f', d = (/ DOD067ForMarsH2OCloud /) )
   709:                 call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   710:             
   711:                 grav_sed_inited = .true.
   712:             
   713:               end subroutine GravSedInit
   714:             
   715:               !--------------------------------------------------------------------------------------
   716:             
   717:             end module grav_sed
