Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:51 2016
FILE NAME: i.rad_CK1991.F90
PROGRAM NAME: rad_ck1991
DIAGNOSTIC LIST

  LINE  LEVEL( NO.): DIAGNOSTIC MESSAGE

   494  opt  (  11): Fused array assignments. :line 494 - 496
   494  opt  (1593): Loop nest collapsed into one loop.
   494  vec  (   4): Vectorized array expression.
   497  vec  (   3): Unvectorized loop.
   497  vec  (  13): Overhead of loop division is too large.
   498  opt  (  11): Fused array assignments. :line 498 - 500
   498  opt  (1593): Loop nest collapsed into one loop.
   498  vec  (   4): Vectorized array expression.
   498  vec  (  29): ADB is used for array.: xy_absamt
   498  vec  (  29): ADB is used for array.: xy_effpress
   498  vec  (  29): ADB is used for array.: xyz_press
   498  vec  (  29): ADB is used for array.: xy_efftemp
   498  vec  (  29): ADB is used for array.: xyz_delabsmass
   498  vec  (  29): ADB is used for array.: xyz_temp
   502  opt  (  11): Fused array assignments. :line 502 - 507
   502  opt  (1593): Loop nest collapsed into one loop.
   502  vec  (   4): Vectorized array expression.
   502  vec  (  29): ADB is used for array.: xy_log10absamt
   502  vec  (  29): ADB is used for array.: xy_log10effpress
   502  vec  (  29): ADB is used for array.: xy_effpress
   502  vec  (  29): ADB is used for array.: xy_efftemp
   502  vec  (  29): ADB is used for array.: xy_absamt
   524  vec  (   1): Vectorized loop.
   524  vec  (  29): ADB is used for array.: a_tablog10press
   525  opt  (1084): Branch out of the loop inhibits optimization.
   525  vec  (  26): Macro operation Search.
   554  vec  (   1): Vectorized loop.
   554  vec  (  29): ADB is used for array.: a_tablog10absamt
   555  opt  (1084): Branch out of the loop inhibits optimization.
   555  vec  (  26): Macro operation Search.
   576  opt  (1017): Subroutine call prevents optimization.
   595  opt  (  11): Fused array assignments. :line 595 - 600
   595  opt  (1593): Loop nest collapsed into one loop.
   595  vec  (   4): Vectorized array expression.
   595  vec  (  29): ADB is used for array.: xyrr_trans
   595  vec  (  29): ADB is used for array.: xy_beta
   595  vec  (  29): ADB is used for array.: xy_efftemp
   595  vec  (  29): ADB is used for array.: xy_alpha
   595  vec  (  29): ADB is used for array.: xy_absatreftemp
   608  opt  (1593): Loop nest collapsed into one loop.
   608  vec  (   1): Vectorized loop.
   608  vec  (  29): ADB is used for array.: xyrr_trans
   610  opt  (1037): Feedback of array elements.
   619  vec  (   3): Unvectorized loop.
   619  vec  (  13): Overhead of loop division is too large.
   620  opt  (1036): Potential feedback - use directive if OK.
   620  opt  (1593): Loop nest collapsed into one loop.
   620  vec  (   4): Vectorized array expression.
   620  vec  (  29): ADB is used for array.: xyrr_trans
   623  opt  (1593): Loop nest collapsed into one loop.
   623  vec  (   4): Vectorized array expression.
   623  vec  (  29): ADB is used for array.: xyrr_trans
   674  opt  (1593): Loop nest collapsed into one loop.
   674  vec  (   1): Vectorized loop.
   674  vec  (  29): ADB is used for array.: xy_array
   674  vec  (  29): ADB is used for array.: xy_log10press
   674  vec  (  29): ADB is used for array.: a_tablog10press
   674  vec  (  29): ADB is used for array.: xy_log10absamt
   674  vec  (  29): ADB is used for array.: a_tablog10absamt
   674  vec  (  29): ADB is used for array.: aa_tab
   674  vec  (  29): ADB is used for array.: xy_indexabsamt
   674  vec  (  29): ADB is used for array.: xy_indexpress
   761  opt  (  11): Fused array assignments. :line 761 - 763
   761  vec  (   4): Vectorized array expression.
   761  vec  (  29): ADB is used for array.: a_tablog10press
   775  opt  (  11): Fused array assignments. :line 775 - 783
   775  vec  (   4): Vectorized array expression.
   775  vec  (  29): ADB is used for array.: a_o3tablog10absamt
   775  vec  (  29): ADB is used for array.: a_co2tablog10absamt
   787  opt  (  11): Fused array assignments. :line 787 - 803
   787  opt  (1593): Loop nest collapsed into one loop.
   787  vec  (   4): Vectorized array expression.
   787  vec  (  29): ADB is used for array.: aa_o3tabbeta
   787  vec  (  29): ADB is used for array.: aa_co2tabbeta
   787  vec  (  29): ADB is used for array.: aa_o3tabalpha
   787  vec  (  29): ADB is used for array.: aa_co2tabalpha
   787  vec  (  29): ADB is used for array.: aa_o3tababs
   787  vec  (  29): ADB is used for array.: aa_co2tababs
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:51 2016
FILE NAME: i.rad_CK1991.F90
PROGRAM NAME: rad_ck1991
TRANSFORMATION LIST

  LINE                   FORTRAN STATEMENT

     1  != Chou and Kouvaris (1991) による長波放射モデル
     2  !
     3  != Long radiation model described by Chou and Kouvaris (1991)
     4  !
     5  ! Authors::   Yoshiyuki O. TAKAHASHI
     6  ! Version::   $Id: rad_CK1991.F90,v 1.2 2013/01/18 02:35:37 yot Exp $
     7  ! Tag Name::  $Name:  $
     8  ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9  ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10  !
    11  
    12  module rad_CK1991
    13    !
    14    != Chou and Kouvaris (1991) による長波放射モデル
    15    !
    16    != Long radiation model described by Chou and Kouvaris (1991)
    17    !
    18    ! <b>Note that Japanese and English are described in parallel.</b>
    19    !
    20    ! 長波放射モデル.
    21    !
    22    ! This is a model of long wave radiation.
    23    !
    24    !== References
    25    !
    26    !  Chou, M.-D., and L. Kouvaris,
    27    !    Calculations of transmittion functions in the infrared CO2 and O3 bands,
    28    !    J. Geophys. Res., 96, 9003-9012, 1991.
    29    !
    30    !== Procedures List
    31    !
    32  !!$  ! RadiationFluxDennouAGCM :: 放射フラックスの計算
    33  !!$  ! RadiationDTempDt        :: 放射フラックスによる温度変化の計算
    34  !!$  ! RadiationFluxOutput     :: 放射フラックスの出力
    35  !!$  ! RadiationFinalize       :: 終了処理 (モジュール内部の変数の割り付け解除)
    36  !!$  ! ------------            :: ------------
    37  !!$  ! RadiationFluxDennouAGCM :: Calculate radiation flux
    38  !!$  ! RadiationDTempDt        :: Calculate temperature tendency with radiation flux
    39  !!$  ! RadiationFluxOutput     :: Output radiation fluxes
    40  !!$  ! RadiationFinalize       :: Termination (deallocate variables in this module)
    41    !
    42    !== NAMELIST
    43    !
    44  !!$  ! NAMELIST#radiation_DennouAGCM_nml
    45    !
    46  
    47    ! USE statements
    48    !
    49  
    50    !
    51    ! Kind type parameter
    52    !
    53    use dc_types, only: DP, &      ! Double precision.
    54      &                 STRING, &  ! Strings.
    55      &                 TOKEN      ! Keywords.
    56  
    57    ! メッセージ出力
    58    ! Message output
    59    !
    60    use dc_message, only: MessageNotify
    61  
    62    !
    63    ! Grid points settings
    64    !
    65    use gridset, only: imax, & !
    66                               ! Number of grid points in longitude
    67      &                jmax, & !
    68                               ! Number of grid points in latitude
    69      &                kmax    !
    70                               ! Number of vertical level
    71  
    72    ! Declaration statements
    73    !
    74    implicit none
    75    private
    76  
    77  
    78    integer , parameter :: NTabPress = 26
    79    real(DP), save      :: a_TabLog10Press (NTabPress)
    80  
    81    integer , parameter :: NCO2TabAbsAmt = 21
    82    real(DP), save      :: a_CO2TabLog10AbsAmt(NCO2TabAbsAmt)
    83    real(DP), save      :: aa_CO2TabAlpha     (NCO2TabAbsAmt, NTabPress)
    84    real(DP), save      :: aa_CO2TabBeta      (NCO2TabAbsAmt, NTabPress)
    85    real(DP), save      :: aa_CO2TabAbs       (NCO2TabAbsAmt, NTabPress)
    86  
    87    integer , parameter :: NO3TabAbsAmt = 21
    88    real(DP), save      :: a_O3TabLog10AbsAmt(NO3TabAbsAmt)
    89    real(DP), save      :: aa_O3TabAlpha     (NO3TabAbsAmt, NTabPress)
    90    real(DP), save      :: aa_O3TabBeta      (NO3TabAbsAmt, NTabPress)
    91    real(DP), save      :: aa_O3TabAbs       (NO3TabAbsAmt, NTabPress)
    92  
    93  
    94  
    95    data a_TabLog10Press &
    96      & / &
    97      & -2.0, -1.8, -1.6, -1.4, -1.2, -1.0, -0.8, -0.6, -0.4, -0.2,  0.0,  0.2,  0.4,  &
    98      &        0.6,  0.8,  1.0,  1.2,  1.4,  1.6,  1.8,  2.0,  2.2,  2.4,  2.6,  2.8,  3.0 &
    99      & /
   100  
   101    data a_CO2TabLog10AbsAmt &
   102      & / &
   103      & -3.0, -2.7, -2.4, -2.1, -1.8, -1.5, -1.2, -0.9, -0.6, -0.3,  0.0,  0.3,  0.6,  &
   104      &        0.9,  1.2,  1.5,  1.8,  2.1,  2.4,  2.7,  3.0 &
   105      &/
   106  
   107    data aa_CO2TabAlpha &
   108      & / &
   109      ! -3.0 -2.7 -2.4 -2.1 -1.8 -1.5 -1.2 -0.9 -0.6 -0.3 0.0 0.3 0.6 0.9 1.2 1.5 1.8 2.1 2.4 2.7 3.0
   110      &  43, 53, 60, 65, 67, 67, 68, 70, 74, 77, 79, 81, 82, 82, 82, 81, 79, 77, 74, 72, 68, & ! -2.0
   111      &  43, 53, 60, 65, 66, 67, 68, 70, 72, 75, 77, 79, 79, 80, 79, 77, 76, 73, 71, 68, 64, & ! -1.8
   112      &  43, 53, 60, 64, 66, 66, 67, 69, 71, 73, 75, 76, 76, 76, 76, 74, 72, 70, 67, 64, 60, & ! -1.6
   113      &  43, 52, 60, 64, 65, 65, 66, 67, 69, 71, 72, 73, 73, 73, 72, 70, 68, 66, 63, 60, 57, & ! -1.4
   114      &  42, 52, 59, 63, 64, 64, 64, 65, 66, 68, 69, 69, 69, 69, 68, 66, 64, 61, 59, 56, 53, & ! -1.2
   115      &  42, 51, 58, 62, 63, 62, 62, 62, 63, 64, 65, 65, 65, 65, 64, 62, 60, 57, 55, 52, 50, & ! -1.0
   116      &  41, 50, 57, 60, 60, 59, 59, 59, 59, 60, 61, 61, 61, 61, 60, 58, 56, 54, 51, 49, 47, & ! -0.8
   117      &  40, 48, 54, 57, 57, 56, 55, 55, 55, 56, 57, 57, 57, 56, 55, 54, 52, 50, 48, 46, 44, & ! -0.6
   118      &  38, 46, 51, 54, 54, 52, 51, 51, 51, 52, 53, 53, 53, 52, 52, 50, 48, 47, 45, 43, 42, & ! -0.4
   119      &  36, 43, 48, 50, 49, 48, 47, 46, 47, 48, 49, 49, 49, 49, 48, 47, 45, 44, 42, 41, 40, & ! -0.2
   120      &  33, 39, 43, 45, 45, 43, 42, 43, 43, 44, 45, 46, 46, 46, 45, 44, 43, 42, 40, 40, 39, & !  0.0
   121      &  29, 34, 38, 40, 40, 39, 39, 39, 40, 41, 42, 43, 43, 43, 42, 42, 41, 40, 39, 38, 38, & !  0.2
   122      &  24, 29, 32, 35, 36, 36, 36, 36, 37, 39, 40, 40, 40, 40, 40, 40, 39, 38, 38, 37, 37, & !  0.4
   123      &  19, 24, 27, 30, 32, 33, 33, 34, 35, 36, 37, 38, 38, 39, 38, 38, 38, 37, 37, 37, 36, & !  0.6
   124      &  15, 19, 23, 26, 29, 30, 31, 32, 33, 35, 36, 36, 37, 37, 37, 37, 37, 36, 36, 36, 36, & !  0.8
   125      &  11, 15, 19, 23, 26, 29, 30, 31, 32, 33, 34, 35, 36, 36, 36, 37, 37, 37, 37, 36, 35, & !  1.0
   126      &   8, 11, 15, 20, 24, 27, 29, 30, 31, 32, 33, 34, 35, 36, 36, 36, 37, 37, 37, 36, 34, & !  1.2
   127      &   6,  9, 13, 17, 21, 25, 28, 29, 30, 31, 32, 32, 33, 33, 33, 33, 33, 33, 33, 32, 31, & !  1.4
   128      &   4,  7, 10, 14, 19, 23, 26, 28, 29, 30, 30, 31, 31, 32, 32, 32, 33, 33, 33, 32, 30, & !  1.6
   129      &   3,  5,  8, 12, 17, 21, 24, 27, 28, 29, 29, 30, 30, 31, 32, 32, 33, 33, 32, 31, 30, & !  1.8
   130      &   2,  4,  7, 11, 14, 18, 22, 25, 27, 28, 28, 28, 29, 30, 31, 32, 32, 32, 32, 30, 29, & !  2.0
   131      &   2,  4,  6,  9, 12, 16, 19, 22, 25, 26, 27, 27, 28, 29, 30, 32, 32, 32, 30, 29, 27, & !  2.2
   132      &   2,  3,  6,  8, 11, 13, 16, 20, 23, 25, 26, 27, 28, 29, 30, 31, 31, 31, 29, 27, 26, & !  2.4
   133      &   2,  3,  5,  7,  9, 11, 14, 17, 20, 23, 25, 27, 28, 29, 30, 30, 30, 29, 28, 26, 25, & !  2.6
   134      &   1,  2,  4,  6,  8,  9, 11, 14, 17, 20, 23, 26, 28, 30, 30, 30, 29, 28, 26, 25, 25, & !  2.8
   135      &   1,  2,  3,  5,  6,  7,  9, 11, 15, 18, 22, 26, 29, 31, 30, 29, 28, 26, 25, 25, 25  & !  3.0
   136      & /
   137  
   138    data aa_CO2TabBeta &
   139      & / &
   140      ! -3.0 -2.7 -2.4 -2.1 -1.8 -1.5 -1.2 -0.9 -0.6 -0.3 0.0 0.3 0.6 0.9 1.2 1.5 1.8 2.1 2.4 2.7 3.0
   141      &    6,  9, 11, 12, 12, 13, 16, 19, 22, 23, 24, 25, 26, 27, 27, 25, 24, 22, 21, 19, 17, & ! -2.0
   142      &    6,  9, 11, 12, 12, 13, 16, 19, 22, 23, 23, 24, 25, 26, 26, 24, 22, 21, 19, 18, 16, & ! -1.8
   143      &    6,  9, 11, 12, 12, 13, 16, 19, 21, 22, 23, 23, 24, 25, 24, 23, 21, 20, 18, 16, 14, & ! -1.6
   144      &    6,  9, 11, 12, 12, 13, 16, 19, 21, 22, 22, 22, 23, 23, 23, 21, 20, 18, 17, 15, 13, & ! -1.4
   145      &    6,  9, 11, 12, 12, 13, 16, 18, 20, 21, 21, 21, 21, 22, 21, 20, 18, 17, 15, 14, 12, & ! -1.2
   146      &    6,  9, 11, 12, 12, 13, 15, 18, 19, 20, 19, 19, 20, 20, 20, 18, 17, 15, 14, 13, 11, & ! -1.0
   147      &    6,  9, 11, 12, 12, 13, 15, 17, 18, 18, 18, 18, 18, 18, 18, 17, 15, 14, 13, 11, 10, & ! -0.8
   148      &    6,  9, 11, 12, 12, 12, 14, 16, 17, 17, 16, 16, 17, 17, 17, 16, 15, 14, 12, 11, 10, & ! -0.6
   149      &    6,  9, 11, 11, 11, 12, 13, 14, 15, 15, 15, 15, 15, 15, 15, 14, 13, 12, 11, 10,  9, & ! -0.4
   150      &    6,  9, 11, 11, 11, 11, 12, 13, 14, 14, 13, 13, 14, 14, 14, 13, 12, 12, 11, 10,  8, & ! -0.2
   151      &    6,  8, 10, 10, 10, 10, 10, 12, 12, 12, 12, 12, 13, 13, 13, 12, 12, 11, 10,  9,  7, & !  0.0
   152      &    6,  8,  9, 10,  9,  9,  9, 10, 11, 11, 11, 11, 12, 12, 12, 11, 11, 10,  9,  8,  6, & !  0.2
   153      &    6,  8,  9,  9,  8,  7,  8,  9, 10, 10, 10, 10, 11, 11, 11, 11, 10,  9,  8,  6,  4, & !  0.4
   154      &    5,  7,  8,  8,  7,  7,  7,  8,  9,  9, 10, 10, 10, 10, 10, 10, 10,  8,  7,  5,  3, & !  0.6
   155      &    5,  6,  7,  7,  7,  6,  6,  7,  8,  9,  9, 10, 10, 10, 10, 10,  9,  7,  6,  4,  2, & !  0.8
   156      &    4,  5,  6,  6,  6,  6,  5,  6,  7,  8,  8,  9,  9,  9,  9,  9,  8,  6,  4,  2,  1, & !  1.0
   157      &    3,  4,  5,  6,  6,  6,  5,  5,  6,  7,  8,  8,  8,  9,  8,  8,  6,  4,  2,  1,  0, & !  1.2
   158      &    2,  3,  4,  5,  5,  5,  5,  5,  5,  6,  6,  6,  6,  6,  6,  5,  4,  2,  1,  0,  0, & !  1.4
   159      &    2,  2,  3,  4,  5,  5,  5,  5,  4,  4,  5,  5,  5,  5,  4,  3,  1,  0,  0, -1, -2, & !  1.6
   160      &    1,  2,  2,  3,  4,  5,  5,  5,  4,  4,  4,  4,  5,  4,  3,  2,  0,  0, -1, -2, -3, & !  1.8
   161      &    1,  1,  1,  2,  3,  4,  5,  5,  5,  4,  3,  3,  3,  3,  2,  1,  0, -1, -2, -3, -3, & !  2.0
   162      &    0,  0,  1,  1,  3,  4,  5,  5,  5,  4,  3,  3,  2,  2,  1,  0,  0, -1, -2, -3, -3, & !  2.2
   163      &    0,  0,  0,  1,  2,  3,  4,  5,  5,  4,  3,  2,  1,  1,  0,  0, -1, -2, -3, -3, -2, & !  2.4
   164      &    0,  0,  0,  1,  2,  2,  3,  4,  5,  4,  3,  2,  1,  0, -1, -1, -2, -2, -3, -2, -1, & !  2.6
   165      &    0,  0,  0,  1,  1,  2,  3,  4,  4,  4,  3,  2,  0, -1, -2, -2, -2, -2, -2, -1,  0, & !  2.8
   166      &    0,  0,  0,  1,  1,  2,  2,  3,  3,  3,  2,  1,  0, -1, -3, -4, -3, -3, -1,  0,  0  & !  3.0
   167      & /
   168  
   169    ! The value at log10(p) = 0.4, log10(w) = 2.1 is deduced to be 685 by interpolating with 3rd order
   170    ! Lagrange interpoation in direction of w, since that in the paper by Chou and Kouvaris (1991) is a BLANK.
   171    data aa_CO2TabAbs &
   172      & / &
   173      ! -3.0  -2.7  -2.4  -2.1  -1.8  -1.5  -1.2  -0.9  -0.6  -0.3   0.0   0.3   0.6   0.9   1.2   1.5   1.8   2.1   2.4   2.7   3.0
   174      & 3241, 3099, 2956, 2810, 2667, 2532, 2407, 2290, 2177, 2067, 1959, 1852, 1747, &
   175      &       1643, 1540, 1439, 1341, 1247, 1154, 1063,  973, & ! -2.0
   176      & 3241, 3099, 2955, 2809, 2666, 2531, 2405, 2287, 2173, 2061, 1951, 1842, 1735, &
   177      &       1628, 1523, 1420, 1320, 1222, 1127, 1033,  940, & ! -1.8
   178      & 3240, 3098, 2954, 2808, 2664, 2528, 2401, 2282, 2166, 2052, 1940, 1828, 1718, &
   179      &       1609, 1501, 1396, 1293, 1193, 1095,  998,  902, & ! -1.6
   180      & 3239, 3096, 2952, 2805, 2661, 2524, 2396, 2274, 2156, 2040, 1924, 1810, 1698, &
   181      &       1586, 1475, 1367, 1262, 1159, 1057,  958,  860, & ! -1.4
   182      & 3238, 3094, 2949, 2802, 2656, 2518, 2387, 2263, 2143, 2023, 1904, 1787, 1672, &
   183      &       1557, 1444, 1334, 1225, 1119, 1015,  913,  815, & ! -1.2
   184      & 3235, 3091, 2945, 2796, 2649, 2508, 2375, 2248, 2124, 2001, 1879, 1759, 1640, &
   185      &       1523, 1407, 1294, 1183, 1074,  968,  865,  767, & ! -1.0
   186      & 3231, 3085, 2938, 2788, 2638, 2495, 2358, 2227, 2099, 1972, 1847, 1724, 1603, &
   187      &       1483, 1365, 1249, 1135, 1024,  917,  815,  718, & ! -0.8
   188      & 3225, 3078, 2928, 2775, 2623, 2476, 2335, 2200, 2068, 1938, 1809, 1683, 1559, &
   189      &       1438, 1317, 1199, 1084,  972,  866,  765,  673, & ! -0.6
   190      & 3216, 3066, 2913, 2757, 2601, 2450, 2305, 2165, 2030, 1896, 1765, 1636, 1510, &
   191      &       1386, 1263, 1144, 1027,  916,  811,  713,  625, & ! -0.4
   192      & 3202, 3048, 2892, 2731, 2571, 2415, 2266, 2123, 1984, 1847, 1713, 1582, 1454, &
   193      &       1328, 1205, 1084,  968,  858,  755,  662,  579, & ! -0.2
   194      & 3183, 3023, 2862, 2697, 2533, 2372, 2219, 2073, 1930, 1791, 1656, 1523, 1394, &
   195      &       1266, 1142, 1021,  906,  799,  701,  613,  535, & !  0.0
   196      & 3156, 2990, 2823, 2655, 2486, 2321, 2165, 2015, 1871, 1730, 1593, 1459, 1329, &
   197      &       1200, 1076,  956,  844,  741,  648,  566,  494, & !  0.2
   198      & 3120, 2948, 2776, 2603, 2431, 2263, 2104, 1952, 1806, 1664, 1526, 1392, 1260, &
   199      &       1132, 1008,  892,  783,  685,  598,  522,  456, & !  0.4
   200      & 3078, 2897, 2720, 2544, 2369, 2200, 2038, 1884, 1737, 1595, 1456, 1321, 1189, &
   201      &       1062,  941,  828,  725,  632,  552,  482,  421, & !  0.6
   202      & 3029, 2840, 2658, 2480, 2303, 2132, 1969, 1814, 1666, 1524, 1385, 1249, 1118, &
   203      &        993,  875,  766,  669,  583,  509,  445,  389, & !  0.8
   204      & 2978, 2779, 2593, 2412, 2235, 2063, 1899, 1743, 1595, 1451, 1311, 1176, 1046, &
   205      &        923,  809,  706,  614,  533,  463,  401,  348, & !  1.0
   206      & 2927, 2717, 2525, 2343, 2166, 1995, 1831, 1674, 1524, 1379, 1239, 1104,  976, &
   207      &        856,  747,  649,  562,  485,  418,  358,  307, & !  1.2
   208      & 2883, 2662, 2461, 2275, 2098, 1927, 1762, 1603, 1450, 1303, 1161, 1026,  898, &
   209      &        780,  672,  576,  493,  422,  362,  311,  266, & !  1.4
   210      & 2846, 2612, 2401, 2210, 2031, 1861, 1696, 1535, 1379, 1228, 1085,  950,  824, &
   211      &        709,  605,  516,  440,  377,  323,  276,  233, & !  1.6
   212      & 2817, 2572, 2350, 2150, 1968, 1797, 1632, 1469, 1310, 1157, 1013,  880,  758, &
   213      &        648,  552,  470,  402,  344,  293,  247,  206, & !  1.8
   214      & 2796, 2541, 2308, 2098, 1910, 1736, 1569, 1405, 1243, 1089,  944,  812,  694, &
   215      &        591,  503,  430,  368,  314,  266,  222,  183, & !  2.0
   216      & 2781, 2519, 2275, 2055, 1857, 1677, 1507, 1341, 1179, 1024,  880,  750,  637, &
   217      &        542,  462,  397,  340,  288,  241,  200,  165, & !  2.2
   218      & 2772, 2504, 2252, 2022, 1813, 1624, 1448, 1280, 1118,  963,  821,  695,  588, &
   219      &        500,  428,  368,  314,  264,  220,  181,  150, & !  2.4
   220      & 2766, 2494, 2236, 1997, 1778, 1577, 1393, 1221, 1058,  906,  767,  647,  546, &
   221      &        465,  399,  342,  290,  243,  201,  166,  138, & !  2.6
   222      & 2762, 2486, 2224, 1977, 1749, 1538, 1343, 1164, 1001,  852,  719,  605,  511, &
   223      &        436,  373,  318,  269,  225,  186,  155,  128, & !  2.8
   224      & 2759, 2480, 2213, 1961, 1725, 1505, 1299, 1113,  947,  801,  675,  570,  485, &
   225      &        414,  352,  298,  250,  209,  175,  147,  121  & !  3.0
   226      & /
   227  
   228    data a_O3TabLog10AbsAmt &
   229      & / &
   230      & -4.0, -3.8, -3.6, -3.4, -3.2, -3.0, -2.8, -2.6, -2.4, -2.2, -2.0, -1.8, -1.6, -1.4, -1.2, -1.0, -0.8, -0.6, -0.4, -0.2,  0.0 &
   231      &/
   232  
   233    data aa_O3TabAlpha &
   234      & / &
   235      !     -4.0 -3.8 -3.6 -3.4 -3.2 -3.0 -2.8 -2.6 -2.4 -2.2 -2.0 -1.8 -1.6 -1.4 -1.2 -1.0 -0.8 -0.6 -0.4 -0.2 0.0
   236      &    1,  2,  4,  6,  9, 13, 17, 22, 28, 33, 37, 42, 45, 49, 51, 54, 55, 55, 55, 53, 52, & ! -2.0
   237      &    1,  2,  4,  6,  9, 13, 17, 22, 28, 33, 37, 42, 45, 49, 51, 53, 55, 55, 54, 53, 51, & ! -1.8
   238      &    1,  2,  4,  6,  9, 13, 17, 22, 27, 33, 37, 41, 45, 48, 51, 53, 54, 54, 54, 52, 51, & ! -1.6
   239      &    1,  2,  4,  6,  9, 13, 17, 22, 27, 32, 37, 41, 45, 48, 51, 53, 54, 54, 53, 52, 50, & ! -1.4
   240      &    1,  2,  4,  6,  9, 13, 17, 22, 27, 32, 37, 41, 45, 48, 50, 52, 53, 53, 52, 50, 48, & ! -1.2
   241      &    1,  2,  4,  6,  9, 13, 17, 22, 27, 32, 37, 41, 44, 47, 50, 51, 52, 52, 51, 49, 46, & ! -1.0
   242      &    1,  2,  4,  6,  9, 13, 17, 22, 27, 32, 36, 40, 43, 46, 48, 50, 50, 50, 48, 46, 44, & ! -0.8
   243      &    1,  2,  4,  6,  9, 12, 16, 21, 26, 31, 35, 39, 42, 45, 47, 48, 48, 47, 46, 44, 41, & ! -0.6
   244      &    1,  2,  4,  6,  9, 12, 16, 21, 25, 30, 34, 38, 41, 43, 45, 45, 45, 44, 42, 40, 38, & ! -0.4
   245      &    1,  2,  4,  6,  8, 11, 15, 20, 24, 29, 32, 36, 38, 40, 41, 42, 42, 40, 39, 37, 34, & ! -0.2
   246      &    1,  2,  3,  5,  7, 11, 14, 18, 23, 27, 30, 33, 35, 37, 38, 38, 38, 36, 35, 33, 31, & !  0.0
   247      &    0,  1,  3,  4,  7,  9, 13, 17, 20, 24, 27, 30, 32, 33, 34, 34, 33, 33, 31, 30, 28, & !  0.2
   248      &    0,  1,  2,  4,  6,  8, 11, 14, 18, 21, 24, 26, 27, 28, 29, 30, 29, 29, 28, 27, 25, & !  0.4
   249      &    0,  1,  1,  3,  4,  6,  9, 11, 14, 17, 20, 22, 23, 24, 25, 26, 26, 26, 25, 24, 23, & !  0.6
   250      &    0,  0,  1,  2,  3,  4,  6,  9, 11, 14, 16, 18, 19, 21, 22, 22, 23, 23, 23, 22, 22, & !  0.8
   251      &    0,  0,  0,  1,  2,  3,  4,  6,  8, 10, 12, 14, 16, 17, 19, 20, 21, 21, 21, 21, 20, & !  1.0
   252      &    0,  0,  0,  0,  1,  2,  3,  4,  6,  7,  9, 11, 13, 15, 16, 18, 19, 20, 20, 20, 19, & !  1.2
   253      &    0,  0,  0,  0,  0,  1,  1,  2,  4,  5,  7,  9, 11, 12, 14, 16, 17, 18, 19, 19, 19, & !  1.4
   254      &    0,  0,  0,  0,  0,  0,  1,  1,  2,  4,  5,  7,  9, 11, 12, 14, 16, 17, 18, 18, 18, & !  1.6
   255      &    0,  0,  0,  0,  0,  0,  0,  1,  1,  2,  4,  5,  7,  9, 11, 13, 14, 16, 17, 17, 17, & !  1.8
   256      &    0, -1,  0,  0,  0,  0,  0,  0,  1,  2,  3,  4,  6,  8, 10, 12, 13, 15, 16, 17, 17, & !  2.0
   257      &   -1, -1,  0,  0,  0,  0,  0,  0,  0,  1,  2,  3,  5,  7,  9, 11, 13, 14, 15, 16, 16, & !  2.2
   258      &   -1, -1, -1,  0,  0,  0,  0,  0,  0,  1,  1,  3,  4,  6,  8, 10, 12, 14, 15, 16, 16, & !  2.4
   259      &   -1, -1,  0,  0,  0,  0,  0,  0,  0,  0,  1,  2,  4,  5,  7,  9, 11, 13, 15, 16, 16, & !  2.6
   260      &   -1, -1,  0,  0,  0,  0,  0,  0,  0,  0,  1,  2,  3,  5,  7,  9, 11, 13, 15, 16, 16, & !  2.8
   261      &    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1,  2,  3,  5,  7,  9, 11, 13, 15, 16, 16  & !  3.0
   262      & /
   263  
   264    data aa_O3TabBeta &
   265      & / &
   266      ! -4.0 -3.8 -3.6 -3.4 -3.2 -3.0 -2.8 -2.6 -2.4 -2.2 -2.0 -1.8 -1.6 -1.4 -1.2 -1.0 -0.8 -0.6 -0.4 -0.2 0.0
   267      &   -3, -3, -4, -4, -5, -5, -5, -5, -4, -3, -1,  0,  1,  2,  3,  3,  2,  1,  0, -1, -3, & ! -2.0
   268      &   -3, -3, -3, -4, -5, -5, -5, -5, -4, -3, -1,  0,  1,  2,  3,  3,  2,  1,  0, -1, -3, & ! -1.8
   269      &   -3, -3, -4, -4, -5, -5, -5, -5, -4, -3, -1,  0,  1,  2,  3,  3,  2,  1,  0, -1, -3, & ! -1.6
   270      &   -3, -3, -4, -4, -5, -5, -5, -5, -4, -3, -1,  0,  1,  2,  3,  3,  2,  1,  0, -1, -3, & ! -1.4
   271      &   -3, -3, -4, -4, -5, -5, -5, -5, -4, -3, -1,  0,  1,  2,  3,  3,  2,  1,  0, -1, -3, & ! -1.2
   272      &   -2, -3, -4, -4, -5, -5, -5, -5, -4, -3, -1,  0,  1,  2,  3,  3,  3,  1,  0, -1, -2, & ! -1.0
   273      &   -2, -3, -4, -4, -5, -5, -5, -5, -4, -3, -1,  0,  1,  2,  3,  3,  3,  2,  0, -1, -2, & ! -0.8
   274      &   -3, -3, -4, -4, -4, -5, -5, -5, -4, -3, -1,  0,  1,  2,  3,  3,  3,  2,  0, -1, -2, & ! -0.6
   275      &   -2, -3, -3, -4, -4, -5, -5, -5, -4, -2, -1,  0,  1,  2,  3,  3,  3,  2,  0, -1, -2, & ! -0.4
   276      &   -3, -3, -4, -4, -4, -4, -5, -4, -3, -2, -1,  0,  1,  2,  3,  3,  3,  1,  0, -1, -2, & ! -0.2
   277      &   -2, -3, -3, -3, -4, -4, -4, -4, -3, -2,  0,  0,  1,  2,  3,  3,  2,  1,  0, -1, -2, & !  0.0
   278      &   -3, -3, -3, -3, -3, -4, -4, -3, -3, -2,  0,  0,  1,  2,  2,  2,  2,  1,  0, -1, -3, & !  0.2
   279      &   -2, -2, -2, -3, -3, -3, -3, -3, -2, -1,  0,  0,  1,  2,  2,  2,  1,  0,  0, -1, -3, & !  0.4
   280      &   -1, -2, -2, -2, -2, -3, -3, -2, -2, -1,  0,  0,  1,  1,  1,  1,  1,  0,  0, -2, -3, & !  0.6
   281      &   -1, -2, -2, -2, -2, -2, -2, -2, -2, -1,  0,  0,  0,  0,  1,  0,  0,  0, -1, -2, -3, & !  0.8
   282      &   -1, -1, -2, -2, -2, -2, -2, -2, -1, -1, -1,  0,  0,  0,  0,  0,  0,  0, -1, -2, -3, & !  1.0
   283      &   -2, -2, -2, -2, -2, -2, -2, -2, -2, -1, -1,  0,  0,  0,  0,  0,  0,  0, -1, -2, -3, & !  1.2
   284      &   -2, -2, -2, -2, -2, -2, -2, -2, -2, -1, -1, -1, -1,  0,  0,  0,  0,  0, -1, -2, -2, & !  1.4
   285      &   -1, -2, -2, -2, -1, -2, -2, -2, -2, -2, -1, -1, -1, -1, -1,  0,  0, -1, -1, -1, -2, & !  1.6
   286      &   -1, -1, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -1, -1, -1, -1, -1, -1, -1, -1, -2, & !  1.8
   287      &   -2, -2, -1, -2, -1, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -1, -1, -1, -1, -2, -2, & !  2.0
   288      &   -1, -2, -2, -1, -2, -1, -1, -2, -2, -2, -2, -2, -2, -2, -2, -2, -1, -1, -1, -2, -2, & !  2.2
   289      &   -1, -2, -1, -1, -2, -1, -1, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, & !  2.4
   290      &   -1, -2, -2, -2, -2, -1, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -3, & !  2.6
   291      &   -1, -2, -2, -1, -2, -1, -1, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -3, & !  2.8
   292      &   -2, -1, -2, -1, -2, -2, -1, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -3  & !  3.0
   293      & /
   294  
   295    data aa_O3TabAbs &
   296      & / &
   297      ! -4.0, -3.8, -3.6, -3.4, -3.2, -3.0, -2.8, -2.6, -2.4, -2.2, -2.0, -1.8, -1.6, -1.4, -1.2, -1.0, -0.8, -0.6, -0.4, -0.2,  0.0
   298      & 3186, 2996, 2811, 2632, 2460, 2297, 2145, 2007, 1881, 1768, 1665, 1569, 1478, &
   299      &       1389, 1302, 1216, 1132, 1051,  974,  901,  834, & ! -2.0
   300      & 3186, 2996, 2811, 2632, 2460, 2297, 2145, 2007, 1881, 1768, 1665, 1569, 1478, &
   301      &       1389, 1301, 1215, 1131, 1050,  972,  899,  832, & ! -1.8
   302      & 3186, 2996, 2811, 2632, 2460, 2297, 2145, 2006, 1881, 1768, 1665, 1568, 1477, &
   303      &       1388, 1300, 1214, 1130, 1048,  970,  897,  829, & ! -1.6
   304      & 3186, 2996, 2811, 2632, 2459, 2297, 2145, 2006, 1880, 1767, 1664, 1568, 1476, &
   305      &       1387, 1299, 1212, 1127, 1045,  967,  893,  824, & ! -1.4
   306      & 3186, 2996, 2811, 2631, 2459, 2296, 2145, 2005, 1880, 1766, 1663, 1566, 1474, &
   307      &       1385, 1296, 1209, 1124, 1041,  962,  887,  816, & ! -1.2
   308      & 3186, 2996, 2811, 2631, 2459, 2296, 2144, 2005, 1879, 1765, 1661, 1464, 1471, &
   309      &       1381, 1292, 1205, 1118, 1035,  954,  878,  806, & ! -1.0
   310      & 3186, 2996, 2811, 2631, 2458, 2295, 2143, 2003, 1877, 1763, 1658, 1561, 1467, &
   311      &       1376, 1287, 1198, 1110, 1025,  943,  864,  790, & ! -0.8
   312      & 3185, 2996, 2810, 2630, 2458, 2294, 2141, 2001, 1874, 1759, 1654, 1555, 1461, &
   313      &       1369, 1278, 1187, 1098, 1011,  927,  846,  770, & ! -0.6
   314      & 3185, 2996, 2810, 2629, 2456, 2292, 2139, 1998, 1870, 1754, 1647, 1547, 1451, &
   315      &       1357, 1264, 1172, 1080,  991,  904,  821,  743, & ! -0.4
   316      & 3185, 2995, 2809, 2628, 2454, 2289, 2135, 1993, 1863, 1746, 1637, 1535, 1437, &
   317      &       1341, 1245, 1150, 1056,  964,  875,  790,  709, & ! -0.2
   318      & 3185, 2994, 2807, 2626, 2451, 2285, 2129, 1985, 1854, 1733, 1622, 1518, 1417, &
   319      &       1317, 1219, 1121, 1024,  930,  838,  751,  669, & !  0.0
   320      & 3183, 2993, 2805, 2623, 2447, 2279, 2121, 1974, 1840, 1716, 1602, 1493, 1389, &
   321      &       1286, 1184, 1083,  984,  888,  795,  706,  623, & !  0.2
   322      & 3183, 2991, 2802, 2619, 2441, 2270, 2110, 1959, 1821, 1693, 1574, 1461, 1352, &
   323      &       1246, 1141, 1038,  937,  839,  745,  656,  572, & !  0.4
   324      & 3181, 2988, 2799, 2613, 2433, 2260, 2095, 1940, 1796, 1662, 1538, 1420, 1307, &
   325      &       1198, 1090,  985,  883,  784,  690,  602,  520, & !  0.6
   326      & 3179, 2985, 2794, 2606, 2424, 2247, 2077, 1917, 1767, 1627, 1496, 1373, 1256, &
   327      &       1143, 1033,  927,  824,  726,  633,  546,  467, & !  0.8
   328      & 3177, 2982, 2789, 2599, 2413, 2232, 2058, 1892, 1734, 1587, 1450, 1322, 1200, &
   329      &       1084,  973,  867,  764,  667,  576,  492,  416, & !  1.0
   330      & 3167, 2971, 2777, 2585, 2396, 2211, 2033, 1861, 1698, 1544, 1400, 1267, 1141, &
   331      &       1023,  911,  804,  702,  607,  518,  437,  364, & !  1.2
   332      & 3169, 2972, 2776, 2582, 2390, 2203, 2019, 1841, 1671, 1510, 1358, 1217, 1086, &
   333      &        964,  850,  743,  643,  551,  465,  389,  321, & !  1.4
   334      & 3170, 2972, 2775, 2580, 2386, 2195, 2008, 1826, 1650, 1481, 1322, 1174, 1036, &
   335      &        910,  794,  687,  589,  499,  418,  346,  284, & !  1.6
   336      & 3171, 2972, 2774, 2578, 2382, 2189, 1999, 1813, 1633, 1459, 1293, 1138,  994, &
   337      &        862,  743,  636,  540,  454,  377,  311,  253, & !  1.8
   338      & 3170, 2971, 2773, 2576, 2379, 2185, 1993, 1804, 1620, 1441, 1271, 1110,  960, &
   339      &        823,  701,  592,  497,  414,  343,  281,  229, & !  2.0
   340      & 3170, 2971, 2772, 2574, 2377, 2182, 1988, 1798, 1611, 1430, 1255, 1089,  934, &
   341      &        793,  667,  556,  462,  382,  315,  258,  211, & !  2.2
   342      & 3170, 2971, 2772, 2573, 2376, 2180, 1985, 1793, 1605, 1421, 1244, 1075,  916, &
   343      &        771,  641,  529,  434,  356,  293,  241,  197, & !  2.4
   344      & 3170, 2971, 2771, 2573, 2375, 2178, 1983, 1791, 1601, 1416, 1237, 1065,  904, &
   345      &        756,  623,  509,  414,  338,  278,  229,  188, & !  2.6
   346      & 3171, 2971, 2772, 2573, 2375, 2178, 1983, 1790, 1600, 1414, 1233, 1060,  897, &
   347      &        747,  612,  496,  401,  326,  268,  222,  183, & !  2.8
   348      & 3172, 2973, 2773, 2575, 2376, 2179, 1984, 1790, 1600, 1413, 1232, 1058,  893, &
   349      &        742,  606,  489,  394,  319,  262,  217,  179  & !  3.0
   350      & /
   351  
   352  
   353    ! 公開変数
   354    ! Public variables
   355    !
   356    logical, save :: rad_ck1991_inited = .false.
   357                                ! 初期設定フラグ.
   358                                ! Initialization flag
   359  
   360    !
   361    ! Public procedure
   362    !
   363    public :: RadCK1991CalcTrans
   364    public :: RadCK1991Interpolate
   365    public :: RadCK1991Init
   366  
   367  
   368    character(*), parameter:: module_name = 'rad_CK1991'
   369                                ! モジュールの名称.
   370                                ! Module name
   371    character(*), parameter:: version = &
   372      & '$Name:  $' // &
   373      & '$Id: rad_CK1991.F90,v 1.2 2013/01/18 02:35:37 yot Exp $'
   374                                ! モジュールのバージョン
   375                                ! Module version
   376  
   377  
   378  contains
   379  
   380  
   381    !--------------------------------------------------------------------------------------
   382  
   383    subroutine RadCK1991CalcTrans(     &
   384      & xyz_DelAbsMass, xyz_Press, xyz_Temp, & ! (in)
   385      & Spec,                                & ! (in)
   386      & xyrr_Trans                           & ! (out)
   387      & )
   388  
   389      ! USE statements
   390      !
   391  
   392      real(DP)        , intent(in ) :: xyz_DelAbsMass(0:imax-1, 1:jmax, 1:kmax)
   393      real(DP)        , intent(in ) :: xyz_Press     (0:imax-1, 1:jmax, 1:kmax)
   394      real(DP)        , intent(in ) :: xyz_Temp      (0:imax-1, 1:jmax, 1:kmax)
   395      character(len=*), intent(in ) :: Spec
   396      real(DP)        , intent(out) :: xyrr_Trans    (0:imax-1, 1:jmax, 0:kmax, 0:kmax)
   397  
   398  
   399      ! 初期化確認
   400      ! Initialization check
   401      !
   402      if ( .not. rad_ck1991_inited ) then
   403        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   404      end if
   405  
   406  
   407      if ( Spec == 'CO2' ) then
   408        call RadCK1991CalcTransCore(                     &
   409          & NTabPress, NCO2TabAbsAmt,                    & ! (in)
   410          & a_TabLog10Press, a_CO2TabLog10AbsAmt,        & ! (in)
   411          & aa_CO2TabAlpha, aa_CO2TabBeta, aa_CO2TabAbs, & ! (in)
   412          & xyz_DelAbsMass, xyz_Press, xyz_Temp,         & ! (in)
   413          & xyrr_Trans                                   & ! (out)
   414          & )
   415      else if ( Spec == 'O3' ) then
   416        call RadCK1991CalcTransCore(                  &
   417          & NTabPress, NO3TabAbsAmt,                  & ! (in)
   418          & a_TabLog10Press, a_O3TabLog10AbsAmt,      & ! (in)
   419          & aa_O3TabAlpha, aa_O3TabBeta, aa_O3TabAbs, & ! (in)
   420          & xyz_DelAbsMass, xyz_Press, xyz_Temp,      & ! (in)
   421          & xyrr_Trans                                & ! (out)
   422          & )
   423      else
   424        call MessageNotify( 'E', module_name, &
   425          & 'Specified composition, %c, is inappropriate', c1 = trim(Spec) )
   426      end if
   427  
   428  
   429    end subroutine RadCK1991CalcTrans
   430  
   431    !--------------------------------------------------------------------------------------
   432  
   433    subroutine RadCK1991CalcTransCore(       &
   434      & NTabPress, NTabAbsAmt,               & ! (in)
   435      & a_TabLog10Press, a_TabLog10AbsAmt,   & ! (in)
   436      & aa_TabAlpha, aa_TabBeta, aa_TabAbs,  & ! (in)
   437      & xyz_DelAbsMass, xyz_Press, xyz_Temp, & ! (in)
   438      & xyrr_Trans                           & ! (out)
   439      & )
   440  
   441      ! USE statements
   442      !
   443  
   444  
   445      integer , intent(in ) :: NTabPress
   446      integer , intent(in ) :: NTabAbsAmt
   447      real(DP), intent(in ) :: a_TabLog10Press (NTabPress )
   448      real(DP), intent(in ) :: a_TabLog10AbsAmt(NTabAbsAmt)
   449      real(DP), intent(in ) :: aa_TabAlpha     (NTabAbsAmt, NTabPress)
   450      real(DP), intent(in ) :: aa_TabBeta      (NTabAbsAmt, NTabPress)
   451      real(DP), intent(in ) :: aa_TabAbs       (NTabAbsAmt, NTabPress)
   452      real(DP), intent(in ) :: xyz_DelAbsMass  (0:imax-1, 1:jmax, 1:kmax)
   453      real(DP), intent(in ) :: xyz_Press       (0:imax-1, 1:jmax, 1:kmax)
   454      real(DP), intent(in ) :: xyz_Temp        (0:imax-1, 1:jmax, 1:kmax)
   455      real(DP), intent(out) :: xyrr_Trans      (0:imax-1, 1:jmax, 0:kmax, 0:kmax)
   456  
   457      !
   458      ! Work variables
   459      !
   460      real(DP), parameter :: RefTemp = 250.0_DP
   461  
   462      real(DP) :: xy_EffTemp      (0:imax-1, 1:jmax)
   463      real(DP) :: xy_EffPress     (0:imax-1, 1:jmax)
   464      real(DP) :: xy_AbsAmt       (0:imax-1, 1:jmax)
   465      real(DP) :: xy_Log10EffPress(0:imax-1, 1:jmax)
   466      real(DP) :: xy_Log10AbsAmt  (0:imax-1, 1:jmax)
   467      integer  :: xy_IndexPress   (0:imax-1, 1:jmax)
   468      integer  :: xy_IndexAbsAmt  (0:imax-1, 1:jmax)
   469  
   470      real(DP) :: xy_Alpha        (0:imax-1, 1:jmax)
   471      real(DP) :: xy_Beta         (0:imax-1, 1:jmax)
   472      real(DP) :: xy_AbsAtRefTemp (0:imax-1, 1:jmax)
   473  
   474      real(DP) :: xy_Abs          (0:imax-1, 1:jmax)
   475  
   476      integer :: i
   477      integer :: j
   478      integer :: k
   479      integer :: kk
   480      integer :: l
   481  
   482  
   483      ! 初期化確認
   484      ! Initialization check
   485      !
   486      if ( .not. rad_ck1991_inited ) then
   487        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   488      end if
   489  
   490  
   491      do k = 0, kmax
   492        do kk = k+1, kmax
   493  
   494          xy_EffTemp  = 0.0_DP
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t486 = 1, xy_efftemp.DSC.U2*xy_efftemp.DSC.U1 +                
     .       1   xy_efftemp.DSC.U2                                              
     .           xy_efftemp(t486-1,1) = 0.0000000000000000e+000                 
     .           xy_effpress(t486-1,1) = 0.0000000000000000e+000                
     .           xy_absamt(t486-1,1) = 0.0000000000000000e+000                  
     .        enddo                                                             
   495          xy_EffPress = 0.0_DP
   496          xy_AbsAmt   = 0.0_DP
   497          do l = k+1, kk
   498            xy_EffTemp  = xy_EffTemp  + xyz_Temp (:,:,l) * xyz_DelAbsMass(:,:,l)
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xy_efftemp,xy_effpress,xy_absamt)                          
     .        do t496 = 1, xy_efftemp.DSC.U2*xy_efftemp.DSC.U1 +                
     .       1   xy_efftemp.DSC.U2                                              
     .           xy_efftemp(t496-1,1) = xy_efftemp(t496-1,1) + xyz_temp(t496-1,1
     .       1      ,l)*xyz_delabsmass(t496-1,1,l)                              
     .           xy_effpress(t496-1,1) = xy_effpress(t496-1,1) + xyz_press(t496-
     .       1      1,1,l)*xyz_delabsmass(t496-1,1,l)                           
     .           xy_absamt(t496-1,1) = xy_absamt(t496-1,1) + xyz_delabsmass(t496
     .       1      -1,1,l)                                                     
     .        enddo                                                             
   499            xy_EffPress = xy_EffPress + xyz_Press(:,:,l) * xyz_DelAbsMass(:,:,l)
   500            xy_AbsAmt   = xy_AbsAmt   +                    xyz_DelAbsMass(:,:,l)
   501          end do
   502          xy_EffTemp  = xy_EffTemp  / ( xy_AbsAmt + 1.0d-100 )
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xy_efftemp,xy_effpress,xy_absamt)                          
     .        do t522 = 1, xy_efftemp.DSC.U2*xy_efftemp.DSC.U1 +                
     .       1   xy_efftemp.DSC.U2                                              
     .           xy_efftemp(t522-1,1) = xy_efftemp(t522-1,1)/(xy_absamt(t522-1,1
     .       1      )+1.00000000000000e-100)                                    
     .           xy_effpress(t522-1,1) = xy_effpress(t522-1,1)/(xy_absamt(t522-1
     .       1      ,1)+1.00000000000000e-100)                                  
     .           xy_log10effpress(t522-1,1) = dlog10(xy_effpress(t522-1,1)+     
     .       1      1.00000000000000e-100)                                      
     .           xy_log10absamt(t522-1,1) = dlog10((xy_absamt(t522-1,1)+        
     .       1      1.00000000000000e-100))                                     
     .        enddo                                                             
   503          xy_EffPress = xy_EffPress / ( xy_AbsAmt + 1.0d-100 )
   504  
   505  
   506          xy_Log10EffPress = log10( xy_EffPress + 1.0d-100 )
   507          xy_Log10AbsAmt   = log10( xy_AbsAmt   + 1.0d-100 )
   508  
   509  
   510          do j = 1, jmax
   511            do i = 0, imax-1
   512  
   513              if ( xy_Log10EffPress(i,j) < a_TabLog10Press (1) ) then
   514  !!$              call MessageNotify( 'E', module_name, &
   515  !!$                & 'at k = %d and kk = %d, Log10EffPress(%d,%d) = %f < %f. too small', &
   516  !!$                & i = (/k, kk, i, j/), &
   517  !!$                & d = (/xy_Log10EffPress(i,j), a_TabLog10Press(1)/) )
   518  
   519                xy_IndexPress(i,j) = 2
   520  
   521              else
   522  
   523  
   524                Loop_Search_Press  : do l = 1+1, NTabPress
   525                  if ( a_TabLog10Press (l) > xy_Log10EffPress(i,j) ) then
   526                    exit Loop_Search_Press
   527                  end if
   528                end do Loop_Search_Press
   529                if ( l > NTabPress ) then
   530                  l = NTabPress
   531  
   532  !!$                call MessageNotify( 'E', module_name, &
   533  !!$                  & 'at k = %d and kk = %d, Log10EffPress(%d,%d) = %f > %f. too large', &
   534  !!$                  & i = (/k, kk, i, j/), &
   535  !!$                  & d = (/xy_Log10EffPress(i,j), a_TabLog10Press(NTabPress)/) )
   536  
   537                end if
   538                xy_IndexPress(i,j) = l
   539  
   540  
   541              end if
   542  
   543  
   544              if ( xy_Log10AbsAmt(i,j) < a_TabLog10AbsAmt(1) ) then
   545  !!$              call MessageNotify( 'E', module_name, &
   546  !!$                & 'at k = %d and kk = %d, Log10AbsAmt(%d,%d) = %f < %f. too small', &
   547  !!$                & i = (/k, kk, i, j/), &
   548  !!$                & d = (/xy_Log10AbsAmt(i,j), a_TabLog10AbsAmt(1)/) )
   549  
   550                xy_IndexAbsAmt(i,j) = 2
   551              else
   552  
   553  
   554                Loop_Search_AbsAmt : do l = 1+1, NTabAbsAmt
   555                  if ( a_TabLog10AbsAmt(l) > xy_Log10AbsAmt(i,j) ) then
   556                    exit Loop_Search_AbsAmt
   557                  end if
   558                end do Loop_Search_AbsAmt
   559                if ( l > NTabAbsAmt ) then
   560  
   561                  l = NTabAbsAmt
   562  !!$                call MessageNotify( 'E', module_name, &
   563  !!$                  & 'at k = %d and kk = %d, Log10AbsAmt(%d,%d) = %f > %f. too large', &
   564  !!$                  & i = (/k, kk, i, j/), &
   565  !!$                  & d = (/xy_Log10AbsAmt(i,j), a_TabLog10AbsAmt(NTabAbsAmt)/) )
   566                end if
   567                xy_IndexAbsAmt(i,j) = l
   568  
   569  
   570              end if
   571  
   572            end do
   573          end do
   574  
   575  
   576          call RadCK1991Interpolate(                                           &
   577            & NTabPress, NTabAbsAmt,                                           & ! (in)
   578            & a_TabLog10Press, a_TabLog10AbsAmt, aa_TabAlpha,                  & ! (in)
   579            & xy_IndexPress, xy_IndexAbsAmt, xy_Log10EffPress, xy_Log10AbsAmt, & ! (in)
   580            & xy_Alpha                                                         & ! (out)
   581            & )
   582          call RadCK1991Interpolate(                                           &
   583            & NTabPress, NTabAbsAmt,                                           & ! (in)
   584            & a_TabLog10Press, a_TabLog10AbsAmt, aa_TabBeta,                   & ! (in)
   585            & xy_IndexPress, xy_IndexAbsAmt, xy_Log10EffPress, xy_Log10AbsAmt, & ! (in)
   586            & xy_Beta                                                          & ! (out)
   587            & )
   588          call RadCK1991Interpolate(                                           &
   589            & NTabPress, NTabAbsAmt,                                           & ! (in)
   590            & a_TabLog10Press, a_TabLog10AbsAmt, aa_TabAbs,                    & ! (in)
   591            & xy_IndexPress, xy_IndexAbsAmt, xy_Log10EffPress, xy_Log10AbsAmt, & ! (in)
   592            & xy_AbsAtRefTemp                                                  & ! (out)
   593            & )
   594  
   595          xy_AbsAtRefTemp = 10.0d0**xy_AbsAtRefTemp
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xy_efftemp)                                                
     .        do t546 = 1, xy_absatreftemp.DSC.U2*xy_absatreftemp.DSC.U1 +      
     .       1   xy_absatreftemp.DSC.U2                                         
     .           xy_absatreftemp(t546-1,1) = 1.00000000000000e+001**            
     .       1      xy_absatreftemp(t546-1,1)                                   
     .           xy_abs1 = xy_absatreftemp(t546-1,1)*(1.00000000000000e+000 +   
     .       1      xy_alpha(t546-1,1)*(xy_efftemp(t546-1,1)-                   
     .       2      2.50000000000000e+002)+xy_beta(t546-1,1)*(xy_efftemp(t546-1,
     .       3      1)-2.50000000000000e+002)**2)                               
     .           xyrr_trans(t546-1,1,k,kk) = 1.00000000000000e+000 - xy_abs1    
     .        enddo                                                             
   596          xy_Abs = xy_AbsAtRefTemp                                  &
   597            & * ( 1.0_DP + xy_Alpha * ( xy_EffTemp - RefTemp )      &
   598            &            + xy_Beta  * ( xy_EffTemp - RefTemp )**2 )
   599  
   600          xyrr_Trans(:,:,k,kk) = 1.0_DP - xy_Abs
   601        end do
   602      end do
   603      !
   604      ! correction
   605      !
   606      do k = 0, kmax
   607        do kk = k+2, kmax
   608          do j = 1, jmax
   609            do i = 0, imax-1
   610              if ( xyrr_Trans(i,j,k,kk) > xyrr_Trans(i,j,k,kk-1) ) then
   611                xyrr_Trans(i,j,k,kk) = xyrr_Trans(i,j,k,kk-1)
   612              end if
   613            end do
   614          end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xyrr_trans)                                                
     .        do j = 1, jmax*imax                                               
     .           if (xyrr_trans(j-1,1,k,kk) .gt. xyrr_trans(j-1,1,k,kk-1)) then 
     .              xyrr_trans(j-1,1,k,kk) = xyrr_trans(j-1,1,k,kk-1)           
     .           endif                                                          
     .        enddo                                                             
   615        end do
   616      end do
   617  
   618      do k = 0, kmax
   619        do kk = 0, k-1
   620          xyrr_Trans(:,:,k,kk) = xyrr_Trans(:,:,kk,k)
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xyrr_trans)                                                
     .        do t570 = 1, jmax*imax                                            
     .           xyrr_trans(t570-1,1,k,kk) = xyrr_trans(t570-1,1,kk,k)          
     .        enddo                                                             
   621        end do
   622        kk = k
   623        xyrr_Trans(:,:,k,kk) = 1.0_DP
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t578 = 1, jmax*imax                                            
     .           xyrr_trans(t578-1,1,k,kk) = 1.00000000000000e+000              
     .        enddo                                                             
   624      end do
   625  
   626  
   627    end subroutine RadCK1991CalcTransCore
   628  
   629    !--------------------------------------------------------------------------------------
   630  
   631    subroutine RadCK1991Interpolate(                                  &
   632      & NTabPress, NTabAbsAmt,                                        & ! (in)
   633      & a_TabLog10Press, a_TabLog10AbsAmt, aa_Tab,                    & ! (in)
   634      & xy_IndexPress, xy_IndexAbsAmt, xy_Log10Press, xy_Log10AbsAmt, & ! (in)
   635      & xy_Array                                                      & ! (out)
   636      & )
   637  
   638      ! USE statements
   639      !
   640  
   641  
   642      integer , intent(in ) :: NTabPress
   643      integer , intent(in ) :: NTabAbsAmt
   644      real(DP), intent(in ) :: a_TabLog10Press (NTabPress )
   645      real(DP), intent(in ) :: a_TabLog10AbsAmt(NTabAbsAmt)
   646      real(DP), intent(in ) :: aa_Tab          (NTabAbsAmt, NTabPress)
   647      integer , intent(in ) :: xy_IndexPress   (0:imax-1, 1:jmax)
   648      integer , intent(in ) :: xy_IndexAbsAmt  (0:imax-1, 1:jmax)
   649      real(DP), intent(in ) :: xy_Log10Press   (0:imax-1, 1:jmax)
   650      real(DP), intent(in ) :: xy_Log10AbsAmt  (0:imax-1, 1:jmax)
   651      real(DP), intent(out) :: xy_Array        (0:imax-1, 1:jmax)
   652  
   653      !
   654      ! Work variables
   655      !
   656      real(DP) :: val1
   657      real(DP) :: val2
   658      integer  :: ip1
   659      integer  :: ip2
   660      integer  :: iw1
   661      integer  :: iw2
   662      integer  :: i
   663      integer  :: j
   664  
   665  
   666      ! 初期化確認
   667      ! Initialization check
   668      !
   669      if ( .not. rad_ck1991_inited ) then
   670        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   671      end if
   672  
   673  
   674      do j = 1, jmax
   675        do i = 0, imax-1
   676  
   677          ip1 = xy_IndexPress (i,j) - 1
   678          ip2 = xy_IndexPress (i,j)
   679          iw1 = xy_IndexAbsAmt(i,j) - 1
   680          iw2 = xy_IndexAbsAmt(i,j)
   681  
   682          val1 =                                                          &
   683            &   ( aa_Tab          (iw2,ip1) - aa_Tab          (iw1,ip1) ) &
   684            & / ( a_TabLog10AbsAmt(iw2)     - a_TabLog10AbsAmt(iw1)     ) &
   685            & * ( xy_Log10AbsAmt  (i,j)     - a_TabLog10AbsAmt(iw1)     ) &
   686            & + aa_Tab            (iw1,ip1)
   687          val2 =                                                          &
   688            &   ( aa_Tab          (iw2,ip2) - aa_Tab          (iw1,ip2) ) &
   689            & / ( a_TabLog10AbsAmt(iw2)     - a_TabLog10AbsAmt(iw1)     ) &
   690            & * ( xy_Log10AbsAmt  (i,j)     - a_TabLog10AbsAmt(iw1)     ) &
   691            & + aa_Tab            (iw1,ip2)
   692  
   693          xy_Array(i,j) =                                       &
   694            &   ( val2                 - val1                 ) &
   695            & / ( a_TabLog10Press(ip2) - a_TabLog10Press(ip1) ) &
   696            & * ( xy_Log10Press  (i,j) - a_TabLog10Press(ip1) ) &
   697            & + val1
   698  
   699        end do
   700      end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do j = 1, jmax*imax                                               
     .           ip1 = xy_indexpress(j-1,1) - 1                                 
     .           iw1 = xy_indexabsamt(j-1,1) - 1                                
     .           val1 = (aa_tab(xy_indexabsamt(j-1,1),ip1)-aa_tab(iw1,ip1))/((  
     .       1      a_tablog10absamt(xy_indexabsamt(j-1,1)))-(a_tablog10absamt( 
     .       2      iw1)))*(xy_log10absamt(j-1,1)-(a_tablog10absamt(iw1))) +    
     .       3      aa_tab(iw1,ip1)                                             
     .           val2 = (aa_tab(xy_indexabsamt(j-1,1),xy_indexpress(j-1,1))-    
     .       1      aa_tab(iw1,xy_indexpress(j-1,1)))/((a_tablog10absamt(       
     .       2      xy_indexabsamt(j-1,1)))-(a_tablog10absamt(iw1)))*(          
     .       3      xy_log10absamt(j-1,1)-(a_tablog10absamt(iw1))) + aa_tab(iw1,
     .       4      xy_indexpress(j-1,1))                                       
     .           xy_array(j-1,1) = (val2 - val1)/(a_tablog10press(xy_indexpress(
     .       1      j-1,1))-(a_tablog10press(ip1)))*(xy_log10press(j-1,1)-(     
     .       2      a_tablog10press(ip1))) + val1                               
     .        enddo                                                             
   701  
   702    end subroutine RadCK1991Interpolate
   703  
   704    !--------------------------------------------------------------------------------------
   705  
   706    subroutine RadCK1991Init
   707  
   708  
   709      ! ファイル入出力補助
   710      ! File I/O support
   711      !
   712      use dc_iounit, only: FileOpen
   713  
   714  !!$    ! NAMELIST ファイル入力に関するユーティリティ
   715  !!$    ! Utilities for NAMELIST file input
   716  !!$    !
   717  !!$    use namelist_util, only: NmlutilMsg, NmlutilAryValid
   718  
   719  
   720  !!$    integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号.
   721  !!$                              ! Unit number for NAMELIST file open
   722  !!$    integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT.
   723  !!$                              ! IOSTAT of NAMELIST read
   724  
   725  
   726  !!$    namelist /rad_RL78_nml/ &
   727  !!$      & VMRCO2,                   &
   728  !!$      & DelTimeCalcTransValue,    &
   729  !!$      & DelTimeCalcTransUnit,     &
   730  !!$      & flag_save_time
   731  
   732  
   733      if ( rad_CK1991_inited ) return
   734  
   735  !!$
   736  !!$    VMRCO2                = 382.0d-6
   737  !!$
   738  !!$    DelTimeCalcTransValue = 3.0
   739  !!$    DelTimeCalcTransUnit  = 'hrs'
   740  !!$    flag_save_time        = .false.
   741  !!$
   742  !!$
   743  !!$    ! NAMELIST is input
   744  !!$    !
   745  !!$    if ( trim(namelist_filename) /= '' ) then
   746  !!$      call FileOpen( unit_nml, &          ! (out)
   747  !!$        & namelist_filename, mode = 'r' ) ! (in)
   748  !!$
   749  !!$      rewind( unit_nml )
   750  !!$      read( unit_nml,                     & ! (in)
   751  !!$        & nml = rad_RL78_nml,       & ! (out)
   752  !!$        & iostat = iostat_nml )             ! (out)
   753  !!$      close( unit_nml )
   754  !!$
   755  !!$      call NmlutilMsg( iostat_nml, module_name ) ! (in)
   756  !!$    end if
   757  
   758  
   759      ! Convert unit of pressure from mbar to Pa
   760      !
   761      a_TabLog10Press = 10.0d0**a_TabLog10Press
   762      a_TabLog10Press = a_TabLog10Press * 1.0d2
   763      a_TabLog10Press = log10( a_TabLog10Press )
   764  
   765      ! Convert unit of absorber amount from (atm cm)_{STP} to kg m-2
   766      !   To convert from (atm cm)_{STP} to kg m-2, the value is divided by
   767      !   1.0d2 / 101325.0d0 * 8.31432d0 / ( 44.0d-3 ) * 273.15d0, and
   768      !   1.0d2 / 101325.0d0 * 8.31432d0 / ( 48.0d-3 ) * 273.15d0,
   769      !   for CO2 and O3, respectively.
   770      !   MEMO: In a calculation below, GasRUniv variable in constants module can be used.
   771      !         But, I do not use it, since unit of value is just converted by
   772      !         multiplying a factor. Of course, non-use of GasRUniv must not cause
   773      !         significant effect on result.
   774      !
   775      a_CO2TabLog10AbsAmt = 10.0d0**a_CO2TabLog10AbsAmt
     .           d1 = 1.D0/5.09399660857277e+001                                
     .        d2 = 1.D0/4.66949689119170e+001                                   
     .  !cdir nodep                                                             
     .        do t111 = 1, 21                                                   
     .           a_co2tablog10absamt(t111) = 1.00000000000000e+001**            
     .       1      a_co2tablog10absamt(t111)                                   
     .           a_co2tablog10absamt(t111) = a_co2tablog10absamt(t111)*d1       
     .           a_co2tablog10absamt(t111) = dlog10(a_co2tablog10absamt(t111))  
     .           a_o3tablog10absamt(t111) = 1.00000000000000e+001**             
     .       1      a_o3tablog10absamt(t111)                                    
     .           a_o3tablog10absamt(t111) = a_o3tablog10absamt(t111)*d2         
     .           a_o3tablog10absamt(t111) = dlog10(a_o3tablog10absamt(t111))    
     .        enddo                                                             
   776      a_CO2TabLog10AbsAmt = a_CO2TabLog10AbsAmt &
   777        & / ( 1.0d2 / 101325.0d0 * 8.31432d0 / ( 44.0d-3 ) * 273.15d0 )
   778      a_CO2TabLog10AbsAmt = log10( a_CO2TabLog10AbsAmt )
   779      !
   780      a_O3TabLog10AbsAmt  = 10.0d0**a_O3TabLog10AbsAmt
   781      a_O3TabLog10AbsAmt  = a_O3TabLog10AbsAmt &
   782        & / ( 1.0d2 / 101325.0d0 * 8.31432d0 / ( 48.0d-3 ) * 273.15d0 )
   783      a_O3TabLog10AbsAmt  = log10( a_O3TabLog10AbsAmt )
   784      !
   785      ! Convert values absorptance from -1e3 * log10(A) to log10(A)
   786      !
   787      aa_CO2TabAbs = 10.0d0**( aa_CO2TabAbs / ( -1.0d3 ) )
     .        d3 = 1.D0/(-1.00000000000000e+003)                                
     .        d4 = 1.D0/(-1.00000000000000e+003)                                
     .        d5 = 1.D0/1.00000000000000e+004                                   
     .        d6 = 1.D0/1.00000000000000e+004                                   
     .        d7 = 1.D0/1.00000000000000e+006                                   
     .        d8 = 1.D0/1.00000000000000e+006                                   
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t125 = 1, 546                                                  
     .           aa_co2tababs(t125,1) = 1.00000000000000e+001**(aa_co2tababs(   
     .       1      t125,1)*d3)                                                 
     .           aa_co2tababs(t125,1) = dlog10(aa_co2tababs(t125,1))            
     .           aa_o3tababs(t125,1) = 1.00000000000000e+001**(aa_o3tababs(t125,
     .       1      1)*d4)                                                      
     .           aa_o3tababs(t125,1) = dlog10(aa_o3tababs(t125,1))              
     .           aa_co2tabalpha(t125,1) = aa_co2tabalpha(t125,1)*d5             
     .           aa_o3tabalpha(t125,1) = aa_o3tabalpha(t125,1)*d6               
     .           aa_co2tabbeta(t125,1) = aa_co2tabbeta(t125,1)*d7               
     .           aa_o3tabbeta(t125,1) = aa_o3tabbeta(t125,1)*d8                 
     .        enddo                                                             
   788      aa_CO2TabAbs = log10( aa_CO2TabAbs )
   789      !
   790      aa_O3TabAbs  = 10.0d0**( aa_O3TabAbs / ( -1.0d3 ) )
   791      aa_O3TabAbs  = log10( aa_O3TabAbs )
   792      !
   793      ! Convert values of alpha absorptance from 1e4 * alpha to alpha
   794      !
   795      aa_CO2TabAlpha = aa_CO2TabAlpha / ( 1.0d4 )
   796      !
   797      aa_O3TabAlpha  = aa_O3TabAlpha  / ( 1.0d4 )
   798      !
   799      ! Convert values of beta absorptance from 1e6 * beta to beta
   800      !
   801      aa_CO2TabBeta  = aa_CO2TabBeta  / ( 1.0d6 )
   802      !
   803      aa_O3TabBeta   = aa_O3TabBeta   / ( 1.0d6 )
   804  
   805  
   806  
   807      ! 印字 ; Print
   808      !
   809      call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   810  !!$    call MessageNotify( 'M', module_name, '  DelTimeCalcTrans  = %f [%c]', &
   811  !!$      & d = (/ DelTimeCalcTransValue /), c1 = trim( DelTimeCalcTransUnit ) )
   812      call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   813  
   814      rad_ck1991_inited = .true.
   815  
   816    end subroutine RadCK1991Init
   817  
   818    !--------------------------------------------------------------------------------------
   819  
   820  end module rad_CK1991
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:51 2016
FILE NAME: i.rad_CK1991.F90
PROGRAM NAME: rad_ck1991
FORMAT LIST

  LINE    LOOP      FORTRAN STATEMENT

     1:             != Chou and Kouvaris (1991) による長波放射モデル
     2:             !
     3:             != Long radiation model described by Chou and Kouvaris (1991)
     4:             !
     5:             ! Authors::   Yoshiyuki O. TAKAHASHI
     6:             ! Version::   $Id: rad_CK1991.F90,v 1.2 2013/01/18 02:35:37 yot Exp $
     7:             ! Tag Name::  $Name:  $
     8:             ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9:             ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10:             !
    11:             
    12:             module rad_CK1991
    13:               !
    14:               != Chou and Kouvaris (1991) による長波放射モデル
    15:               !
    16:               != Long radiation model described by Chou and Kouvaris (1991)
    17:               !
    18:               ! <b>Note that Japanese and English are described in parallel.</b>
    19:               !
    20:               ! 長波放射モデル.
    21:               !
    22:               ! This is a model of long wave radiation. 
    23:               !
    24:               !== References
    25:               !
    26:               !  Chou, M.-D., and L. Kouvaris, 
    27:               !    Calculations of transmittion functions in the infrared CO2 and O3 bands, 
    28:               !    J. Geophys. Res., 96, 9003-9012, 1991.
    29:               !
    30:               !== Procedures List
    31:               !
    32:             !!$  ! RadiationFluxDennouAGCM :: 放射フラックスの計算
    33:             !!$  ! RadiationDTempDt        :: 放射フラックスによる温度変化の計算
    34:             !!$  ! RadiationFluxOutput     :: 放射フラックスの出力
    35:             !!$  ! RadiationFinalize       :: 終了処理 (モジュール内部の変数の割り付け解除)
    36:             !!$  ! ------------            :: ------------
    37:             !!$  ! RadiationFluxDennouAGCM :: Calculate radiation flux
    38:             !!$  ! RadiationDTempDt        :: Calculate temperature tendency with radiation flux
    39:             !!$  ! RadiationFluxOutput     :: Output radiation fluxes
    40:             !!$  ! RadiationFinalize       :: Termination (deallocate variables in this module)
    41:               !
    42:               !== NAMELIST
    43:               !
    44:             !!$  ! NAMELIST#radiation_DennouAGCM_nml
    45:               !
    46:             
    47:               ! USE statements
    48:               !
    49:             
    50:               ! 
    51:               ! Kind type parameter
    52:               !
    53:               use dc_types, only: DP, &      ! Double precision.
    54:                 &                 STRING, &  ! Strings.
    55:                 &                 TOKEN      ! Keywords.
    56:             
    57:               ! メッセージ出力
    58:               ! Message output
    59:               !
    60:               use dc_message, only: MessageNotify
    61:             
    62:               !
    63:               ! Grid points settings
    64:               !
    65:               use gridset, only: imax, & ! 
    66:                                          ! Number of grid points in longitude
    67:                 &                jmax, & ! 
    68:                                          ! Number of grid points in latitude
    69:                 &                kmax    ! 
    70:                                          ! Number of vertical level
    71:             
    72:               ! Declaration statements
    73:               !
    74:               implicit none
    75:               private
    76:             
    77:             
    78:               integer , parameter :: NTabPress = 26
    79:               real(DP), save      :: a_TabLog10Press (NTabPress)
    80:             
    81:               integer , parameter :: NCO2TabAbsAmt = 21
    82:               real(DP), save      :: a_CO2TabLog10AbsAmt(NCO2TabAbsAmt)
    83:               real(DP), save      :: aa_CO2TabAlpha     (NCO2TabAbsAmt, NTabPress)
    84:               real(DP), save      :: aa_CO2TabBeta      (NCO2TabAbsAmt, NTabPress)
    85:               real(DP), save      :: aa_CO2TabAbs       (NCO2TabAbsAmt, NTabPress)
    86:             
    87:               integer , parameter :: NO3TabAbsAmt = 21
    88:               real(DP), save      :: a_O3TabLog10AbsAmt(NO3TabAbsAmt)
    89:               real(DP), save      :: aa_O3TabAlpha     (NO3TabAbsAmt, NTabPress)
    90:               real(DP), save      :: aa_O3TabBeta      (NO3TabAbsAmt, NTabPress)
    91:               real(DP), save      :: aa_O3TabAbs       (NO3TabAbsAmt, NTabPress)
    92:             
    93:             
    94:             
    95:               data a_TabLog10Press &
    96:                 & / &
    97:                 & -2.0, -1.8, -1.6, -1.4, -1.2, -1.0, -0.8, -0.6, -0.4, -0.2,  0.0,  0.2,  0.4,  &
    98:                 &        0.6,  0.8,  1.0,  1.2,  1.4,  1.6,  1.8,  2.0,  2.2,  2.4,  2.6,  2.8,  3.0 &
    99:                 & /
   100:             
   101:               data a_CO2TabLog10AbsAmt &
   102:                 & / &
   103:                 & -3.0, -2.7, -2.4, -2.1, -1.8, -1.5, -1.2, -0.9, -0.6, -0.3,  0.0,  0.3,  0.6,  &
   104:                 &        0.9,  1.2,  1.5,  1.8,  2.1,  2.4,  2.7,  3.0 &
   105:                 &/
   106:             
   107:               data aa_CO2TabAlpha &
   108:                 & / &
   109:                 ! -3.0 -2.7 -2.4 -2.1 -1.8 -1.5 -1.2 -0.9 -0.6 -0.3 0.0 0.3 0.6 0.9 1.2 1.5 1.8 2.1 2.4 2.7 3.0
   110:                 &  43, 53, 60, 65, 67, 67, 68, 70, 74, 77, 79, 81, 82, 82, 82, 81, 79, 77, 74, 72, 68, & ! -2.0
   111:                 &  43, 53, 60, 65, 66, 67, 68, 70, 72, 75, 77, 79, 79, 80, 79, 77, 76, 73, 71, 68, 64, & ! -1.8
   112:                 &  43, 53, 60, 64, 66, 66, 67, 69, 71, 73, 75, 76, 76, 76, 76, 74, 72, 70, 67, 64, 60, & ! -1.6
   113:                 &  43, 52, 60, 64, 65, 65, 66, 67, 69, 71, 72, 73, 73, 73, 72, 70, 68, 66, 63, 60, 57, & ! -1.4
   114:                 &  42, 52, 59, 63, 64, 64, 64, 65, 66, 68, 69, 69, 69, 69, 68, 66, 64, 61, 59, 56, 53, & ! -1.2
   115:                 &  42, 51, 58, 62, 63, 62, 62, 62, 63, 64, 65, 65, 65, 65, 64, 62, 60, 57, 55, 52, 50, & ! -1.0
   116:                 &  41, 50, 57, 60, 60, 59, 59, 59, 59, 60, 61, 61, 61, 61, 60, 58, 56, 54, 51, 49, 47, & ! -0.8
   117:                 &  40, 48, 54, 57, 57, 56, 55, 55, 55, 56, 57, 57, 57, 56, 55, 54, 52, 50, 48, 46, 44, & ! -0.6
   118:                 &  38, 46, 51, 54, 54, 52, 51, 51, 51, 52, 53, 53, 53, 52, 52, 50, 48, 47, 45, 43, 42, & ! -0.4
   119:                 &  36, 43, 48, 50, 49, 48, 47, 46, 47, 48, 49, 49, 49, 49, 48, 47, 45, 44, 42, 41, 40, & ! -0.2
   120:                 &  33, 39, 43, 45, 45, 43, 42, 43, 43, 44, 45, 46, 46, 46, 45, 44, 43, 42, 40, 40, 39, & !  0.0
   121:                 &  29, 34, 38, 40, 40, 39, 39, 39, 40, 41, 42, 43, 43, 43, 42, 42, 41, 40, 39, 38, 38, & !  0.2
   122:                 &  24, 29, 32, 35, 36, 36, 36, 36, 37, 39, 40, 40, 40, 40, 40, 40, 39, 38, 38, 37, 37, & !  0.4
   123:                 &  19, 24, 27, 30, 32, 33, 33, 34, 35, 36, 37, 38, 38, 39, 38, 38, 38, 37, 37, 37, 36, & !  0.6
   124:                 &  15, 19, 23, 26, 29, 30, 31, 32, 33, 35, 36, 36, 37, 37, 37, 37, 37, 36, 36, 36, 36, & !  0.8
   125:                 &  11, 15, 19, 23, 26, 29, 30, 31, 32, 33, 34, 35, 36, 36, 36, 37, 37, 37, 37, 36, 35, & !  1.0
   126:                 &   8, 11, 15, 20, 24, 27, 29, 30, 31, 32, 33, 34, 35, 36, 36, 36, 37, 37, 37, 36, 34, & !  1.2
   127:                 &   6,  9, 13, 17, 21, 25, 28, 29, 30, 31, 32, 32, 33, 33, 33, 33, 33, 33, 33, 32, 31, & !  1.4
   128:                 &   4,  7, 10, 14, 19, 23, 26, 28, 29, 30, 30, 31, 31, 32, 32, 32, 33, 33, 33, 32, 30, & !  1.6
   129:                 &   3,  5,  8, 12, 17, 21, 24, 27, 28, 29, 29, 30, 30, 31, 32, 32, 33, 33, 32, 31, 30, & !  1.8
   130:                 &   2,  4,  7, 11, 14, 18, 22, 25, 27, 28, 28, 28, 29, 30, 31, 32, 32, 32, 32, 30, 29, & !  2.0
   131:                 &   2,  4,  6,  9, 12, 16, 19, 22, 25, 26, 27, 27, 28, 29, 30, 32, 32, 32, 30, 29, 27, & !  2.2
   132:                 &   2,  3,  6,  8, 11, 13, 16, 20, 23, 25, 26, 27, 28, 29, 30, 31, 31, 31, 29, 27, 26, & !  2.4
   133:                 &   2,  3,  5,  7,  9, 11, 14, 17, 20, 23, 25, 27, 28, 29, 30, 30, 30, 29, 28, 26, 25, & !  2.6
   134:                 &   1,  2,  4,  6,  8,  9, 11, 14, 17, 20, 23, 26, 28, 30, 30, 30, 29, 28, 26, 25, 25, & !  2.8
   135:                 &   1,  2,  3,  5,  6,  7,  9, 11, 15, 18, 22, 26, 29, 31, 30, 29, 28, 26, 25, 25, 25  & !  3.0
   136:                 & / 
   137:             
   138:               data aa_CO2TabBeta &
   139:                 & / &
   140:                 ! -3.0 -2.7 -2.4 -2.1 -1.8 -1.5 -1.2 -0.9 -0.6 -0.3 0.0 0.3 0.6 0.9 1.2 1.5 1.8 2.1 2.4 2.7 3.0
   141:                 &    6,  9, 11, 12, 12, 13, 16, 19, 22, 23, 24, 25, 26, 27, 27, 25, 24, 22, 21, 19, 17, & ! -2.0
   142:                 &    6,  9, 11, 12, 12, 13, 16, 19, 22, 23, 23, 24, 25, 26, 26, 24, 22, 21, 19, 18, 16, & ! -1.8
   143:                 &    6,  9, 11, 12, 12, 13, 16, 19, 21, 22, 23, 23, 24, 25, 24, 23, 21, 20, 18, 16, 14, & ! -1.6
   144:                 &    6,  9, 11, 12, 12, 13, 16, 19, 21, 22, 22, 22, 23, 23, 23, 21, 20, 18, 17, 15, 13, & ! -1.4
   145:                 &    6,  9, 11, 12, 12, 13, 16, 18, 20, 21, 21, 21, 21, 22, 21, 20, 18, 17, 15, 14, 12, & ! -1.2
   146:                 &    6,  9, 11, 12, 12, 13, 15, 18, 19, 20, 19, 19, 20, 20, 20, 18, 17, 15, 14, 13, 11, & ! -1.0
   147:                 &    6,  9, 11, 12, 12, 13, 15, 17, 18, 18, 18, 18, 18, 18, 18, 17, 15, 14, 13, 11, 10, & ! -0.8
   148:                 &    6,  9, 11, 12, 12, 12, 14, 16, 17, 17, 16, 16, 17, 17, 17, 16, 15, 14, 12, 11, 10, & ! -0.6
   149:                 &    6,  9, 11, 11, 11, 12, 13, 14, 15, 15, 15, 15, 15, 15, 15, 14, 13, 12, 11, 10,  9, & ! -0.4
   150:                 &    6,  9, 11, 11, 11, 11, 12, 13, 14, 14, 13, 13, 14, 14, 14, 13, 12, 12, 11, 10,  8, & ! -0.2
   151:                 &    6,  8, 10, 10, 10, 10, 10, 12, 12, 12, 12, 12, 13, 13, 13, 12, 12, 11, 10,  9,  7, & !  0.0
   152:                 &    6,  8,  9, 10,  9,  9,  9, 10, 11, 11, 11, 11, 12, 12, 12, 11, 11, 10,  9,  8,  6, & !  0.2
   153:                 &    6,  8,  9,  9,  8,  7,  8,  9, 10, 10, 10, 10, 11, 11, 11, 11, 10,  9,  8,  6,  4, & !  0.4
   154:                 &    5,  7,  8,  8,  7,  7,  7,  8,  9,  9, 10, 10, 10, 10, 10, 10, 10,  8,  7,  5,  3, & !  0.6
   155:                 &    5,  6,  7,  7,  7,  6,  6,  7,  8,  9,  9, 10, 10, 10, 10, 10,  9,  7,  6,  4,  2, & !  0.8
   156:                 &    4,  5,  6,  6,  6,  6,  5,  6,  7,  8,  8,  9,  9,  9,  9,  9,  8,  6,  4,  2,  1, & !  1.0
   157:                 &    3,  4,  5,  6,  6,  6,  5,  5,  6,  7,  8,  8,  8,  9,  8,  8,  6,  4,  2,  1,  0, & !  1.2
   158:                 &    2,  3,  4,  5,  5,  5,  5,  5,  5,  6,  6,  6,  6,  6,  6,  5,  4,  2,  1,  0,  0, & !  1.4
   159:                 &    2,  2,  3,  4,  5,  5,  5,  5,  4,  4,  5,  5,  5,  5,  4,  3,  1,  0,  0, -1, -2, & !  1.6
   160:                 &    1,  2,  2,  3,  4,  5,  5,  5,  4,  4,  4,  4,  5,  4,  3,  2,  0,  0, -1, -2, -3, & !  1.8
   161:                 &    1,  1,  1,  2,  3,  4,  5,  5,  5,  4,  3,  3,  3,  3,  2,  1,  0, -1, -2, -3, -3, & !  2.0
   162:                 &    0,  0,  1,  1,  3,  4,  5,  5,  5,  4,  3,  3,  2,  2,  1,  0,  0, -1, -2, -3, -3, & !  2.2
   163:                 &    0,  0,  0,  1,  2,  3,  4,  5,  5,  4,  3,  2,  1,  1,  0,  0, -1, -2, -3, -3, -2, & !  2.4
   164:                 &    0,  0,  0,  1,  2,  2,  3,  4,  5,  4,  3,  2,  1,  0, -1, -1, -2, -2, -3, -2, -1, & !  2.6
   165:                 &    0,  0,  0,  1,  1,  2,  3,  4,  4,  4,  3,  2,  0, -1, -2, -2, -2, -2, -2, -1,  0, & !  2.8
   166:                 &    0,  0,  0,  1,  1,  2,  2,  3,  3,  3,  2,  1,  0, -1, -3, -4, -3, -3, -1,  0,  0  & !  3.0
   167:                 & /
   168:             
   169:               ! The value at log10(p) = 0.4, log10(w) = 2.1 is deduced to be 685 by interpolating with 3rd order 
   170:               ! Lagrange interpoation in direction of w, since that in the paper by Chou and Kouvaris (1991) is a BLANK. 
   171:               data aa_CO2TabAbs &
   172:                 & / &
   173:                 ! -3.0  -2.7  -2.4  -2.1  -1.8  -1.5  -1.2  -0.9  -0.6  -0.3   0.0   0.3   0.6   0.9   1.2   1.5   1.8   2.1   2.4   2.7   3.0
   174:                 & 3241, 3099, 2956, 2810, 2667, 2532, 2407, 2290, 2177, 2067, 1959, 1852, 1747, &
   175:                 &       1643, 1540, 1439, 1341, 1247, 1154, 1063,  973, & ! -2.0
   176:                 & 3241, 3099, 2955, 2809, 2666, 2531, 2405, 2287, 2173, 2061, 1951, 1842, 1735, &
   177:                 &       1628, 1523, 1420, 1320, 1222, 1127, 1033,  940, & ! -1.8
   178:                 & 3240, 3098, 2954, 2808, 2664, 2528, 2401, 2282, 2166, 2052, 1940, 1828, 1718, &
   179:                 &       1609, 1501, 1396, 1293, 1193, 1095,  998,  902, & ! -1.6
   180:                 & 3239, 3096, 2952, 2805, 2661, 2524, 2396, 2274, 2156, 2040, 1924, 1810, 1698, &
   181:                 &       1586, 1475, 1367, 1262, 1159, 1057,  958,  860, & ! -1.4
   182:                 & 3238, 3094, 2949, 2802, 2656, 2518, 2387, 2263, 2143, 2023, 1904, 1787, 1672, &
   183:                 &       1557, 1444, 1334, 1225, 1119, 1015,  913,  815, & ! -1.2
   184:                 & 3235, 3091, 2945, 2796, 2649, 2508, 2375, 2248, 2124, 2001, 1879, 1759, 1640, &
   185:                 &       1523, 1407, 1294, 1183, 1074,  968,  865,  767, & ! -1.0
   186:                 & 3231, 3085, 2938, 2788, 2638, 2495, 2358, 2227, 2099, 1972, 1847, 1724, 1603, &
   187:                 &       1483, 1365, 1249, 1135, 1024,  917,  815,  718, & ! -0.8
   188:                 & 3225, 3078, 2928, 2775, 2623, 2476, 2335, 2200, 2068, 1938, 1809, 1683, 1559, &
   189:                 &       1438, 1317, 1199, 1084,  972,  866,  765,  673, & ! -0.6
   190:                 & 3216, 3066, 2913, 2757, 2601, 2450, 2305, 2165, 2030, 1896, 1765, 1636, 1510, &
   191:                 &       1386, 1263, 1144, 1027,  916,  811,  713,  625, & ! -0.4
   192:                 & 3202, 3048, 2892, 2731, 2571, 2415, 2266, 2123, 1984, 1847, 1713, 1582, 1454, &
   193:                 &       1328, 1205, 1084,  968,  858,  755,  662,  579, & ! -0.2
   194:                 & 3183, 3023, 2862, 2697, 2533, 2372, 2219, 2073, 1930, 1791, 1656, 1523, 1394, &
   195:                 &       1266, 1142, 1021,  906,  799,  701,  613,  535, & !  0.0
   196:                 & 3156, 2990, 2823, 2655, 2486, 2321, 2165, 2015, 1871, 1730, 1593, 1459, 1329, &
   197:                 &       1200, 1076,  956,  844,  741,  648,  566,  494, & !  0.2
   198:                 & 3120, 2948, 2776, 2603, 2431, 2263, 2104, 1952, 1806, 1664, 1526, 1392, 1260, &
   199:                 &       1132, 1008,  892,  783,  685,  598,  522,  456, & !  0.4
   200:                 & 3078, 2897, 2720, 2544, 2369, 2200, 2038, 1884, 1737, 1595, 1456, 1321, 1189, &
   201:                 &       1062,  941,  828,  725,  632,  552,  482,  421, & !  0.6
   202:                 & 3029, 2840, 2658, 2480, 2303, 2132, 1969, 1814, 1666, 1524, 1385, 1249, 1118, &
   203:                 &        993,  875,  766,  669,  583,  509,  445,  389, & !  0.8
   204:                 & 2978, 2779, 2593, 2412, 2235, 2063, 1899, 1743, 1595, 1451, 1311, 1176, 1046, &
   205:                 &        923,  809,  706,  614,  533,  463,  401,  348, & !  1.0
   206:                 & 2927, 2717, 2525, 2343, 2166, 1995, 1831, 1674, 1524, 1379, 1239, 1104,  976, &
   207:                 &        856,  747,  649,  562,  485,  418,  358,  307, & !  1.2
   208:                 & 2883, 2662, 2461, 2275, 2098, 1927, 1762, 1603, 1450, 1303, 1161, 1026,  898, &
   209:                 &        780,  672,  576,  493,  422,  362,  311,  266, & !  1.4
   210:                 & 2846, 2612, 2401, 2210, 2031, 1861, 1696, 1535, 1379, 1228, 1085,  950,  824, &
   211:                 &        709,  605,  516,  440,  377,  323,  276,  233, & !  1.6
   212:                 & 2817, 2572, 2350, 2150, 1968, 1797, 1632, 1469, 1310, 1157, 1013,  880,  758, &
   213:                 &        648,  552,  470,  402,  344,  293,  247,  206, & !  1.8
   214:                 & 2796, 2541, 2308, 2098, 1910, 1736, 1569, 1405, 1243, 1089,  944,  812,  694, &
   215:                 &        591,  503,  430,  368,  314,  266,  222,  183, & !  2.0
   216:                 & 2781, 2519, 2275, 2055, 1857, 1677, 1507, 1341, 1179, 1024,  880,  750,  637, &
   217:                 &        542,  462,  397,  340,  288,  241,  200,  165, & !  2.2
   218:                 & 2772, 2504, 2252, 2022, 1813, 1624, 1448, 1280, 1118,  963,  821,  695,  588, &
   219:                 &        500,  428,  368,  314,  264,  220,  181,  150, & !  2.4
   220:                 & 2766, 2494, 2236, 1997, 1778, 1577, 1393, 1221, 1058,  906,  767,  647,  546, &
   221:                 &        465,  399,  342,  290,  243,  201,  166,  138, & !  2.6
   222:                 & 2762, 2486, 2224, 1977, 1749, 1538, 1343, 1164, 1001,  852,  719,  605,  511, &
   223:                 &        436,  373,  318,  269,  225,  186,  155,  128, & !  2.8
   224:                 & 2759, 2480, 2213, 1961, 1725, 1505, 1299, 1113,  947,  801,  675,  570,  485, &
   225:                 &        414,  352,  298,  250,  209,  175,  147,  121  & !  3.0
   226:                 & /
   227:             
   228:               data a_O3TabLog10AbsAmt &
   229:                 & / &
   230:                 & -4.0, -3.8, -3.6, -3.4, -3.2, -3.0, -2.8, -2.6, -2.4, -2.2, -2.0, -1.8, -1.6, -1.4, -1.2, -1.0, -0.8, -0.6, -0.4, -0.2,  0.0 &
   231:                 &/
   232:             
   233:               data aa_O3TabAlpha &
   234:                 & / &
   235:                 !     -4.0 -3.8 -3.6 -3.4 -3.2 -3.0 -2.8 -2.6 -2.4 -2.2 -2.0 -1.8 -1.6 -1.4 -1.2 -1.0 -0.8 -0.6 -0.4 -0.2 0.0
   236:                 &    1,  2,  4,  6,  9, 13, 17, 22, 28, 33, 37, 42, 45, 49, 51, 54, 55, 55, 55, 53, 52, & ! -2.0
   237:                 &    1,  2,  4,  6,  9, 13, 17, 22, 28, 33, 37, 42, 45, 49, 51, 53, 55, 55, 54, 53, 51, & ! -1.8
   238:                 &    1,  2,  4,  6,  9, 13, 17, 22, 27, 33, 37, 41, 45, 48, 51, 53, 54, 54, 54, 52, 51, & ! -1.6
   239:                 &    1,  2,  4,  6,  9, 13, 17, 22, 27, 32, 37, 41, 45, 48, 51, 53, 54, 54, 53, 52, 50, & ! -1.4
   240:                 &    1,  2,  4,  6,  9, 13, 17, 22, 27, 32, 37, 41, 45, 48, 50, 52, 53, 53, 52, 50, 48, & ! -1.2
   241:                 &    1,  2,  4,  6,  9, 13, 17, 22, 27, 32, 37, 41, 44, 47, 50, 51, 52, 52, 51, 49, 46, & ! -1.0
   242:                 &    1,  2,  4,  6,  9, 13, 17, 22, 27, 32, 36, 40, 43, 46, 48, 50, 50, 50, 48, 46, 44, & ! -0.8
   243:                 &    1,  2,  4,  6,  9, 12, 16, 21, 26, 31, 35, 39, 42, 45, 47, 48, 48, 47, 46, 44, 41, & ! -0.6
   244:                 &    1,  2,  4,  6,  9, 12, 16, 21, 25, 30, 34, 38, 41, 43, 45, 45, 45, 44, 42, 40, 38, & ! -0.4
   245:                 &    1,  2,  4,  6,  8, 11, 15, 20, 24, 29, 32, 36, 38, 40, 41, 42, 42, 40, 39, 37, 34, & ! -0.2
   246:                 &    1,  2,  3,  5,  7, 11, 14, 18, 23, 27, 30, 33, 35, 37, 38, 38, 38, 36, 35, 33, 31, & !  0.0
   247:                 &    0,  1,  3,  4,  7,  9, 13, 17, 20, 24, 27, 30, 32, 33, 34, 34, 33, 33, 31, 30, 28, & !  0.2
   248:                 &    0,  1,  2,  4,  6,  8, 11, 14, 18, 21, 24, 26, 27, 28, 29, 30, 29, 29, 28, 27, 25, & !  0.4
   249:                 &    0,  1,  1,  3,  4,  6,  9, 11, 14, 17, 20, 22, 23, 24, 25, 26, 26, 26, 25, 24, 23, & !  0.6
   250:                 &    0,  0,  1,  2,  3,  4,  6,  9, 11, 14, 16, 18, 19, 21, 22, 22, 23, 23, 23, 22, 22, & !  0.8
   251:                 &    0,  0,  0,  1,  2,  3,  4,  6,  8, 10, 12, 14, 16, 17, 19, 20, 21, 21, 21, 21, 20, & !  1.0
   252:                 &    0,  0,  0,  0,  1,  2,  3,  4,  6,  7,  9, 11, 13, 15, 16, 18, 19, 20, 20, 20, 19, & !  1.2
   253:                 &    0,  0,  0,  0,  0,  1,  1,  2,  4,  5,  7,  9, 11, 12, 14, 16, 17, 18, 19, 19, 19, & !  1.4
   254:                 &    0,  0,  0,  0,  0,  0,  1,  1,  2,  4,  5,  7,  9, 11, 12, 14, 16, 17, 18, 18, 18, & !  1.6
   255:                 &    0,  0,  0,  0,  0,  0,  0,  1,  1,  2,  4,  5,  7,  9, 11, 13, 14, 16, 17, 17, 17, & !  1.8
   256:                 &    0, -1,  0,  0,  0,  0,  0,  0,  1,  2,  3,  4,  6,  8, 10, 12, 13, 15, 16, 17, 17, & !  2.0
   257:                 &   -1, -1,  0,  0,  0,  0,  0,  0,  0,  1,  2,  3,  5,  7,  9, 11, 13, 14, 15, 16, 16, & !  2.2
   258:                 &   -1, -1, -1,  0,  0,  0,  0,  0,  0,  1,  1,  3,  4,  6,  8, 10, 12, 14, 15, 16, 16, & !  2.4
   259:                 &   -1, -1,  0,  0,  0,  0,  0,  0,  0,  0,  1,  2,  4,  5,  7,  9, 11, 13, 15, 16, 16, & !  2.6
   260:                 &   -1, -1,  0,  0,  0,  0,  0,  0,  0,  0,  1,  2,  3,  5,  7,  9, 11, 13, 15, 16, 16, & !  2.8
   261:                 &    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1,  2,  3,  5,  7,  9, 11, 13, 15, 16, 16  & !  3.0
   262:                 & /
   263:             
   264:               data aa_O3TabBeta &
   265:                 & / &
   266:                 ! -4.0 -3.8 -3.6 -3.4 -3.2 -3.0 -2.8 -2.6 -2.4 -2.2 -2.0 -1.8 -1.6 -1.4 -1.2 -1.0 -0.8 -0.6 -0.4 -0.2 0.0
   267:                 &   -3, -3, -4, -4, -5, -5, -5, -5, -4, -3, -1,  0,  1,  2,  3,  3,  2,  1,  0, -1, -3, & ! -2.0
   268:                 &   -3, -3, -3, -4, -5, -5, -5, -5, -4, -3, -1,  0,  1,  2,  3,  3,  2,  1,  0, -1, -3, & ! -1.8
   269:                 &   -3, -3, -4, -4, -5, -5, -5, -5, -4, -3, -1,  0,  1,  2,  3,  3,  2,  1,  0, -1, -3, & ! -1.6
   270:                 &   -3, -3, -4, -4, -5, -5, -5, -5, -4, -3, -1,  0,  1,  2,  3,  3,  2,  1,  0, -1, -3, & ! -1.4
   271:                 &   -3, -3, -4, -4, -5, -5, -5, -5, -4, -3, -1,  0,  1,  2,  3,  3,  2,  1,  0, -1, -3, & ! -1.2
   272:                 &   -2, -3, -4, -4, -5, -5, -5, -5, -4, -3, -1,  0,  1,  2,  3,  3,  3,  1,  0, -1, -2, & ! -1.0
   273:                 &   -2, -3, -4, -4, -5, -5, -5, -5, -4, -3, -1,  0,  1,  2,  3,  3,  3,  2,  0, -1, -2, & ! -0.8
   274:                 &   -3, -3, -4, -4, -4, -5, -5, -5, -4, -3, -1,  0,  1,  2,  3,  3,  3,  2,  0, -1, -2, & ! -0.6
   275:                 &   -2, -3, -3, -4, -4, -5, -5, -5, -4, -2, -1,  0,  1,  2,  3,  3,  3,  2,  0, -1, -2, & ! -0.4
   276:                 &   -3, -3, -4, -4, -4, -4, -5, -4, -3, -2, -1,  0,  1,  2,  3,  3,  3,  1,  0, -1, -2, & ! -0.2
   277:                 &   -2, -3, -3, -3, -4, -4, -4, -4, -3, -2,  0,  0,  1,  2,  3,  3,  2,  1,  0, -1, -2, & !  0.0
   278:                 &   -3, -3, -3, -3, -3, -4, -4, -3, -3, -2,  0,  0,  1,  2,  2,  2,  2,  1,  0, -1, -3, & !  0.2
   279:                 &   -2, -2, -2, -3, -3, -3, -3, -3, -2, -1,  0,  0,  1,  2,  2,  2,  1,  0,  0, -1, -3, & !  0.4
   280:                 &   -1, -2, -2, -2, -2, -3, -3, -2, -2, -1,  0,  0,  1,  1,  1,  1,  1,  0,  0, -2, -3, & !  0.6
   281:                 &   -1, -2, -2, -2, -2, -2, -2, -2, -2, -1,  0,  0,  0,  0,  1,  0,  0,  0, -1, -2, -3, & !  0.8
   282:                 &   -1, -1, -2, -2, -2, -2, -2, -2, -1, -1, -1,  0,  0,  0,  0,  0,  0,  0, -1, -2, -3, & !  1.0
   283:                 &   -2, -2, -2, -2, -2, -2, -2, -2, -2, -1, -1,  0,  0,  0,  0,  0,  0,  0, -1, -2, -3, & !  1.2
   284:                 &   -2, -2, -2, -2, -2, -2, -2, -2, -2, -1, -1, -1, -1,  0,  0,  0,  0,  0, -1, -2, -2, & !  1.4
   285:                 &   -1, -2, -2, -2, -1, -2, -2, -2, -2, -2, -1, -1, -1, -1, -1,  0,  0, -1, -1, -1, -2, & !  1.6
   286:                 &   -1, -1, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -1, -1, -1, -1, -1, -1, -1, -1, -2, & !  1.8
   287:                 &   -2, -2, -1, -2, -1, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -1, -1, -1, -1, -2, -2, & !  2.0
   288:                 &   -1, -2, -2, -1, -2, -1, -1, -2, -2, -2, -2, -2, -2, -2, -2, -2, -1, -1, -1, -2, -2, & !  2.2
   289:                 &   -1, -2, -1, -1, -2, -1, -1, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, & !  2.4
   290:                 &   -1, -2, -2, -2, -2, -1, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -3, & !  2.6
   291:                 &   -1, -2, -2, -1, -2, -1, -1, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -3, & !  2.8
   292:                 &   -2, -1, -2, -1, -2, -2, -1, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -3  & !  3.0
   293:                 & /
   294:             
   295:               data aa_O3TabAbs &
   296:                 & / &
   297:                 ! -4.0, -3.8, -3.6, -3.4, -3.2, -3.0, -2.8, -2.6, -2.4, -2.2, -2.0, -1.8, -1.6, -1.4, -1.2, -1.0, -0.8, -0.6, -0.4, -0.2,  0.0
   298:                 & 3186, 2996, 2811, 2632, 2460, 2297, 2145, 2007, 1881, 1768, 1665, 1569, 1478, &
   299:                 &       1389, 1302, 1216, 1132, 1051,  974,  901,  834, & ! -2.0
   300:                 & 3186, 2996, 2811, 2632, 2460, 2297, 2145, 2007, 1881, 1768, 1665, 1569, 1478, &
   301:                 &       1389, 1301, 1215, 1131, 1050,  972,  899,  832, & ! -1.8
   302:                 & 3186, 2996, 2811, 2632, 2460, 2297, 2145, 2006, 1881, 1768, 1665, 1568, 1477, &
   303:                 &       1388, 1300, 1214, 1130, 1048,  970,  897,  829, & ! -1.6
   304:                 & 3186, 2996, 2811, 2632, 2459, 2297, 2145, 2006, 1880, 1767, 1664, 1568, 1476, &
   305:                 &       1387, 1299, 1212, 1127, 1045,  967,  893,  824, & ! -1.4
   306:                 & 3186, 2996, 2811, 2631, 2459, 2296, 2145, 2005, 1880, 1766, 1663, 1566, 1474, &
   307:                 &       1385, 1296, 1209, 1124, 1041,  962,  887,  816, & ! -1.2
   308:                 & 3186, 2996, 2811, 2631, 2459, 2296, 2144, 2005, 1879, 1765, 1661, 1464, 1471, &
   309:                 &       1381, 1292, 1205, 1118, 1035,  954,  878,  806, & ! -1.0
   310:                 & 3186, 2996, 2811, 2631, 2458, 2295, 2143, 2003, 1877, 1763, 1658, 1561, 1467, &
   311:                 &       1376, 1287, 1198, 1110, 1025,  943,  864,  790, & ! -0.8
   312:                 & 3185, 2996, 2810, 2630, 2458, 2294, 2141, 2001, 1874, 1759, 1654, 1555, 1461, &
   313:                 &       1369, 1278, 1187, 1098, 1011,  927,  846,  770, & ! -0.6
   314:                 & 3185, 2996, 2810, 2629, 2456, 2292, 2139, 1998, 1870, 1754, 1647, 1547, 1451, &
   315:                 &       1357, 1264, 1172, 1080,  991,  904,  821,  743, & ! -0.4
   316:                 & 3185, 2995, 2809, 2628, 2454, 2289, 2135, 1993, 1863, 1746, 1637, 1535, 1437, &
   317:                 &       1341, 1245, 1150, 1056,  964,  875,  790,  709, & ! -0.2
   318:                 & 3185, 2994, 2807, 2626, 2451, 2285, 2129, 1985, 1854, 1733, 1622, 1518, 1417, &
   319:                 &       1317, 1219, 1121, 1024,  930,  838,  751,  669, & !  0.0
   320:                 & 3183, 2993, 2805, 2623, 2447, 2279, 2121, 1974, 1840, 1716, 1602, 1493, 1389, &
   321:                 &       1286, 1184, 1083,  984,  888,  795,  706,  623, & !  0.2
   322:                 & 3183, 2991, 2802, 2619, 2441, 2270, 2110, 1959, 1821, 1693, 1574, 1461, 1352, &
   323:                 &       1246, 1141, 1038,  937,  839,  745,  656,  572, & !  0.4
   324:                 & 3181, 2988, 2799, 2613, 2433, 2260, 2095, 1940, 1796, 1662, 1538, 1420, 1307, &
   325:                 &       1198, 1090,  985,  883,  784,  690,  602,  520, & !  0.6
   326:                 & 3179, 2985, 2794, 2606, 2424, 2247, 2077, 1917, 1767, 1627, 1496, 1373, 1256, &
   327:                 &       1143, 1033,  927,  824,  726,  633,  546,  467, & !  0.8
   328:                 & 3177, 2982, 2789, 2599, 2413, 2232, 2058, 1892, 1734, 1587, 1450, 1322, 1200, &
   329:                 &       1084,  973,  867,  764,  667,  576,  492,  416, & !  1.0
   330:                 & 3167, 2971, 2777, 2585, 2396, 2211, 2033, 1861, 1698, 1544, 1400, 1267, 1141, &
   331:                 &       1023,  911,  804,  702,  607,  518,  437,  364, & !  1.2
   332:                 & 3169, 2972, 2776, 2582, 2390, 2203, 2019, 1841, 1671, 1510, 1358, 1217, 1086, &
   333:                 &        964,  850,  743,  643,  551,  465,  389,  321, & !  1.4
   334:                 & 3170, 2972, 2775, 2580, 2386, 2195, 2008, 1826, 1650, 1481, 1322, 1174, 1036, &
   335:                 &        910,  794,  687,  589,  499,  418,  346,  284, & !  1.6
   336:                 & 3171, 2972, 2774, 2578, 2382, 2189, 1999, 1813, 1633, 1459, 1293, 1138,  994, &
   337:                 &        862,  743,  636,  540,  454,  377,  311,  253, & !  1.8
   338:                 & 3170, 2971, 2773, 2576, 2379, 2185, 1993, 1804, 1620, 1441, 1271, 1110,  960, &
   339:                 &        823,  701,  592,  497,  414,  343,  281,  229, & !  2.0
   340:                 & 3170, 2971, 2772, 2574, 2377, 2182, 1988, 1798, 1611, 1430, 1255, 1089,  934, &
   341:                 &        793,  667,  556,  462,  382,  315,  258,  211, & !  2.2
   342:                 & 3170, 2971, 2772, 2573, 2376, 2180, 1985, 1793, 1605, 1421, 1244, 1075,  916, &
   343:                 &        771,  641,  529,  434,  356,  293,  241,  197, & !  2.4
   344:                 & 3170, 2971, 2771, 2573, 2375, 2178, 1983, 1791, 1601, 1416, 1237, 1065,  904, &
   345:                 &        756,  623,  509,  414,  338,  278,  229,  188, & !  2.6
   346:                 & 3171, 2971, 2772, 2573, 2375, 2178, 1983, 1790, 1600, 1414, 1233, 1060,  897, &
   347:                 &        747,  612,  496,  401,  326,  268,  222,  183, & !  2.8
   348:                 & 3172, 2973, 2773, 2575, 2376, 2179, 1984, 1790, 1600, 1413, 1232, 1058,  893, &
   349:                 &        742,  606,  489,  394,  319,  262,  217,  179  & !  3.0
   350:                 & /
   351:             
   352:             
   353:               ! 公開変数
   354:               ! Public variables
   355:               !
   356:               logical, save :: rad_ck1991_inited = .false.
   357:                                           ! 初期設定フラグ.
   358:                                           ! Initialization flag
   359:             
   360:               ! 
   361:               ! Public procedure
   362:               !
   363:               public :: RadCK1991CalcTrans
   364:               public :: RadCK1991Interpolate
   365:               public :: RadCK1991Init
   366:             
   367:             
   368:               character(*), parameter:: module_name = 'rad_CK1991'
   369:                                           ! モジュールの名称.
   370:                                           ! Module name
   371:               character(*), parameter:: version = &
   372:                 & '$Name:  $' // &
   373:                 & '$Id: rad_CK1991.F90,v 1.2 2013/01/18 02:35:37 yot Exp $'
   374:                                           ! モジュールのバージョン
   375:                                           ! Module version
   376:             
   377:             
   378:             contains
   379:             
   380:             
   381:               !--------------------------------------------------------------------------------------
   382:             
   383:               subroutine RadCK1991CalcTrans(     &
   384:                 & xyz_DelAbsMass, xyz_Press, xyz_Temp, & ! (in)
   385:                 & Spec,                                & ! (in)
   386:                 & xyrr_Trans                           & ! (out)
   387:                 & )
   388:             
   389:                 ! USE statements
   390:                 !
   391:             
   392:                 real(DP)        , intent(in ) :: xyz_DelAbsMass(0:imax-1, 1:jmax, 1:kmax)
   393:                 real(DP)        , intent(in ) :: xyz_Press     (0:imax-1, 1:jmax, 1:kmax)
   394:                 real(DP)        , intent(in ) :: xyz_Temp      (0:imax-1, 1:jmax, 1:kmax)
   395:                 character(len=*), intent(in ) :: Spec
   396:                 real(DP)        , intent(out) :: xyrr_Trans    (0:imax-1, 1:jmax, 0:kmax, 0:kmax)
   397:             
   398:             
   399:                 ! 初期化確認
   400:                 ! Initialization check
   401:                 !
   402:                 if ( .not. rad_ck1991_inited ) then
   403:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   404:                 end if
   405:             
   406:             
   407:                 if ( Spec == 'CO2' ) then
   408:                   call RadCK1991CalcTransCore(                     &
   409:                     & NTabPress, NCO2TabAbsAmt,                    & ! (in)
   410:                     & a_TabLog10Press, a_CO2TabLog10AbsAmt,        & ! (in)
   411:                     & aa_CO2TabAlpha, aa_CO2TabBeta, aa_CO2TabAbs, & ! (in)
   412:                     & xyz_DelAbsMass, xyz_Press, xyz_Temp,         & ! (in)
   413:                     & xyrr_Trans                                   & ! (out)
   414:                     & )
   415:                 else if ( Spec == 'O3' ) then
   416:                   call RadCK1991CalcTransCore(                  &
   417:                     & NTabPress, NO3TabAbsAmt,                  & ! (in)
   418:                     & a_TabLog10Press, a_O3TabLog10AbsAmt,      & ! (in)
   419:                     & aa_O3TabAlpha, aa_O3TabBeta, aa_O3TabAbs, & ! (in)
   420:                     & xyz_DelAbsMass, xyz_Press, xyz_Temp,      & ! (in)
   421:                     & xyrr_Trans                                & ! (out)
   422:                     & )
   423:                 else
   424:                   call MessageNotify( 'E', module_name, &
   425:                     & 'Specified composition, %c, is inappropriate', c1 = trim(Spec) )
   426:                 end if
   427:             
   428:             
   429:               end subroutine RadCK1991CalcTrans
   430:             
   431:               !--------------------------------------------------------------------------------------
   432:             
   433:               subroutine RadCK1991CalcTransCore(       &
   434:                 & NTabPress, NTabAbsAmt,               & ! (in)
   435:                 & a_TabLog10Press, a_TabLog10AbsAmt,   & ! (in)
   436:                 & aa_TabAlpha, aa_TabBeta, aa_TabAbs,  & ! (in)
   437:                 & xyz_DelAbsMass, xyz_Press, xyz_Temp, & ! (in)
   438:                 & xyrr_Trans                           & ! (out)
   439:                 & )
   440:             
   441:                 ! USE statements
   442:                 !
   443:             
   444:             
   445:                 integer , intent(in ) :: NTabPress
   446:                 integer , intent(in ) :: NTabAbsAmt
   447:                 real(DP), intent(in ) :: a_TabLog10Press (NTabPress )
   448:                 real(DP), intent(in ) :: a_TabLog10AbsAmt(NTabAbsAmt)
   449:                 real(DP), intent(in ) :: aa_TabAlpha     (NTabAbsAmt, NTabPress)
   450:                 real(DP), intent(in ) :: aa_TabBeta      (NTabAbsAmt, NTabPress)
   451:                 real(DP), intent(in ) :: aa_TabAbs       (NTabAbsAmt, NTabPress)
   452:                 real(DP), intent(in ) :: xyz_DelAbsMass  (0:imax-1, 1:jmax, 1:kmax)
   453:                 real(DP), intent(in ) :: xyz_Press       (0:imax-1, 1:jmax, 1:kmax)
   454:                 real(DP), intent(in ) :: xyz_Temp        (0:imax-1, 1:jmax, 1:kmax)
   455:                 real(DP), intent(out) :: xyrr_Trans      (0:imax-1, 1:jmax, 0:kmax, 0:kmax)
   456:             
   457:                 !
   458:                 ! Work variables
   459:                 !
   460:                 real(DP), parameter :: RefTemp = 250.0_DP
   461:             
   462:                 real(DP) :: xy_EffTemp      (0:imax-1, 1:jmax)
   463:                 real(DP) :: xy_EffPress     (0:imax-1, 1:jmax)
   464:                 real(DP) :: xy_AbsAmt       (0:imax-1, 1:jmax)
   465:                 real(DP) :: xy_Log10EffPress(0:imax-1, 1:jmax)
   466:                 real(DP) :: xy_Log10AbsAmt  (0:imax-1, 1:jmax)
   467:                 integer  :: xy_IndexPress   (0:imax-1, 1:jmax)
   468:                 integer  :: xy_IndexAbsAmt  (0:imax-1, 1:jmax)
   469:             
   470:                 real(DP) :: xy_Alpha        (0:imax-1, 1:jmax)
   471:                 real(DP) :: xy_Beta         (0:imax-1, 1:jmax)
   472:                 real(DP) :: xy_AbsAtRefTemp (0:imax-1, 1:jmax)
   473:             
   474:                 real(DP) :: xy_Abs          (0:imax-1, 1:jmax)
   475:             
   476:                 integer :: i
   477:                 integer :: j
   478:                 integer :: k
   479:                 integer :: kk
   480:                 integer :: l
   481:             
   482:             
   483:                 ! 初期化確認
   484:                 ! Initialization check
   485:                 !
   486:                 if ( .not. rad_ck1991_inited ) then
   487:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   488:                 end if
   489:             
   490:             
   491: +------>        do k = 0, kmax
   492: |+----->          do kk = k+1, kmax
   493: ||          
   494: ||*W--->            xy_EffTemp  = 0.0_DP
   495: ||||                xy_EffPress = 0.0_DP
   496: ||*W---             xy_AbsAmt   = 0.0_DP
   497: ||+---->            do l = k+1, kk
   498: |||*W-->A             xy_EffTemp  = xy_EffTemp  + xyz_Temp (:,:,l) * xyz_DelAbsMass(:,:,l)
   499: |||||   A             xy_EffPress = xy_EffPress + xyz_Press(:,:,l) * xyz_DelAbsMass(:,:,l)
   500: |||*W-- A             xy_AbsAmt   = xy_AbsAmt   +                    xyz_DelAbsMass(:,:,l)
   501: ||+----             end do
   502: ||*W--->A           xy_EffTemp  = xy_EffTemp  / ( xy_AbsAmt + 1.0d-100 )
   503: ||||    A           xy_EffPress = xy_EffPress / ( xy_AbsAmt + 1.0d-100 )
   504: ||||        
   505: ||||        
   506: ||||    A           xy_Log10EffPress = log10( xy_EffPress + 1.0d-100 )
   507: ||*W--- A           xy_Log10AbsAmt   = log10( xy_AbsAmt   + 1.0d-100 )
   508: ||          
   509: ||          
   510: ||+---->            do j = 1, jmax
   511: |||+--->              do i = 0, imax-1
   512: ||||        
   513: ||||                    if ( xy_Log10EffPress(i,j) < a_TabLog10Press (1) ) then
   514: ||||        !!$              call MessageNotify( 'E', module_name, &
   515: ||||        !!$                & 'at k = %d and kk = %d, Log10EffPress(%d,%d) = %f < %f. too small', &
   516: ||||        !!$                & i = (/k, kk, i, j/), &
   517: ||||        !!$                & d = (/xy_Log10EffPress(i,j), a_TabLog10Press(1)/) )
   518: ||||        
   519: ||||                      xy_IndexPress(i,j) = 2
   520: ||||        
   521: ||||                    else
   522: ||||        
   523: ||||        
   524: ||||V-->                  Loop_Search_Press  : do l = 1+1, NTabPress
   525: |||||   A                   if ( a_TabLog10Press (l) > xy_Log10EffPress(i,j) ) then
   526: |||||                         exit Loop_Search_Press
   527: |||||                       end if
   528: ||||V--                   end do Loop_Search_Press
   529: ||||                      if ( l > NTabPress ) then
   530: ||||                        l = NTabPress
   531: ||||        
   532: ||||        !!$                call MessageNotify( 'E', module_name, &
   533: ||||        !!$                  & 'at k = %d and kk = %d, Log10EffPress(%d,%d) = %f > %f. too large', &
   534: ||||        !!$                  & i = (/k, kk, i, j/), &
   535: ||||        !!$                  & d = (/xy_Log10EffPress(i,j), a_TabLog10Press(NTabPress)/) )
   536: ||||        
   537: ||||                      end if
   538: ||||                      xy_IndexPress(i,j) = l
   539: ||||        
   540: ||||        
   541: ||||                    end if
   542: ||||        
   543: ||||        
   544: ||||                    if ( xy_Log10AbsAmt(i,j) < a_TabLog10AbsAmt(1) ) then
   545: ||||        !!$              call MessageNotify( 'E', module_name, &
   546: ||||        !!$                & 'at k = %d and kk = %d, Log10AbsAmt(%d,%d) = %f < %f. too small', &
   547: ||||        !!$                & i = (/k, kk, i, j/), &
   548: ||||        !!$                & d = (/xy_Log10AbsAmt(i,j), a_TabLog10AbsAmt(1)/) )
   549: ||||        
   550: ||||                      xy_IndexAbsAmt(i,j) = 2
   551: ||||                    else
   552: ||||        
   553: ||||        
   554: ||||V-->                  Loop_Search_AbsAmt : do l = 1+1, NTabAbsAmt
   555: |||||   A                   if ( a_TabLog10AbsAmt(l) > xy_Log10AbsAmt(i,j) ) then
   556: |||||                         exit Loop_Search_AbsAmt
   557: |||||                       end if
   558: ||||V--                   end do Loop_Search_AbsAmt
   559: ||||                      if ( l > NTabAbsAmt ) then
   560: ||||        
   561: ||||                        l = NTabAbsAmt
   562: ||||        !!$                call MessageNotify( 'E', module_name, &
   563: ||||        !!$                  & 'at k = %d and kk = %d, Log10AbsAmt(%d,%d) = %f > %f. too large', &
   564: ||||        !!$                  & i = (/k, kk, i, j/), &
   565: ||||        !!$                  & d = (/xy_Log10AbsAmt(i,j), a_TabLog10AbsAmt(NTabAbsAmt)/) )
   566: ||||                      end if
   567: ||||                      xy_IndexAbsAmt(i,j) = l
   568: ||||        
   569: ||||        
   570: ||||                    end if
   571: ||||        
   572: |||+---               end do
   573: ||+----             end do
   574: ||          
   575: ||          
   576: ||                  call RadCK1991Interpolate(                                           &
   577: ||                    & NTabPress, NTabAbsAmt,                                           & ! (in)
   578: ||                    & a_TabLog10Press, a_TabLog10AbsAmt, aa_TabAlpha,                  & ! (in)
   579: ||                    & xy_IndexPress, xy_IndexAbsAmt, xy_Log10EffPress, xy_Log10AbsAmt, & ! (in)
   580: ||                    & xy_Alpha                                                         & ! (out)
   581: ||                    & )
   582: ||                  call RadCK1991Interpolate(                                           &
   583: ||                    & NTabPress, NTabAbsAmt,                                           & ! (in)
   584: ||                    & a_TabLog10Press, a_TabLog10AbsAmt, aa_TabBeta,                   & ! (in)
   585: ||                    & xy_IndexPress, xy_IndexAbsAmt, xy_Log10EffPress, xy_Log10AbsAmt, & ! (in)
   586: ||                    & xy_Beta                                                          & ! (out)
   587: ||                    & )
   588: ||                  call RadCK1991Interpolate(                                           &
   589: ||                    & NTabPress, NTabAbsAmt,                                           & ! (in)
   590: ||                    & a_TabLog10Press, a_TabLog10AbsAmt, aa_TabAbs,                    & ! (in)
   591: ||                    & xy_IndexPress, xy_IndexAbsAmt, xy_Log10EffPress, xy_Log10AbsAmt, & ! (in)
   592: ||                    & xy_AbsAtRefTemp                                                  & ! (out)
   593: ||                    & )
   594: ||          
   595: ||*W--->A           xy_AbsAtRefTemp = 10.0d0**xy_AbsAtRefTemp
   596: ||||    A           xy_Abs = xy_AbsAtRefTemp                                  &
   597: ||||                  & * ( 1.0_DP + xy_Alpha * ( xy_EffTemp - RefTemp )      &
   598: ||||                  &            + xy_Beta  * ( xy_EffTemp - RefTemp )**2 )
   599: ||||        
   600: ||*W--- A           xyrr_Trans(:,:,k,kk) = 1.0_DP - xy_Abs
   601: |+-----           end do
   602: +------         end do
   603:                 !
   604:                 ! correction
   605:                 !
   606: +------>        do k = 0, kmax
   607: |+----->          do kk = k+2, kmax
   608: ||W---->            do j = 1, jmax
   609: |||*--->              do i = 0, imax-1
   610: ||||    A               if ( xyrr_Trans(i,j,k,kk) > xyrr_Trans(i,j,k,kk-1) ) then
   611: ||||    A                 xyrr_Trans(i,j,k,kk) = xyrr_Trans(i,j,k,kk-1)
   612: ||||                    end if
   613: |||*---               end do
   614: ||W----             end do
   615: |+-----           end do
   616: +------         end do
   617:             
   618: +------>        do k = 0, kmax
   619: |+----->          do kk = 0, k-1
   620: ||W*=== A           xyrr_Trans(:,:,k,kk) = xyrr_Trans(:,:,kk,k)
   621: |+-----           end do
   622: |                 kk = k
   623: |W*==== A         xyrr_Trans(:,:,k,kk) = 1.0_DP
   624: +------         end do
   625:             
   626:             
   627:               end subroutine RadCK1991CalcTransCore
   628:             
   629:               !--------------------------------------------------------------------------------------
   630:             
   631:               subroutine RadCK1991Interpolate(                                  &
   632:                 & NTabPress, NTabAbsAmt,                                        & ! (in)
   633:                 & a_TabLog10Press, a_TabLog10AbsAmt, aa_Tab,                    & ! (in)
   634:                 & xy_IndexPress, xy_IndexAbsAmt, xy_Log10Press, xy_Log10AbsAmt, & ! (in)
   635:                 & xy_Array                                                      & ! (out)
   636:                 & )
   637:             
   638:                 ! USE statements
   639:                 !
   640:             
   641:             
   642:                 integer , intent(in ) :: NTabPress
   643:                 integer , intent(in ) :: NTabAbsAmt
   644:                 real(DP), intent(in ) :: a_TabLog10Press (NTabPress )
   645:                 real(DP), intent(in ) :: a_TabLog10AbsAmt(NTabAbsAmt)
   646:                 real(DP), intent(in ) :: aa_Tab          (NTabAbsAmt, NTabPress)
   647:                 integer , intent(in ) :: xy_IndexPress   (0:imax-1, 1:jmax)
   648:                 integer , intent(in ) :: xy_IndexAbsAmt  (0:imax-1, 1:jmax)
   649:                 real(DP), intent(in ) :: xy_Log10Press   (0:imax-1, 1:jmax)
   650:                 real(DP), intent(in ) :: xy_Log10AbsAmt  (0:imax-1, 1:jmax)
   651:                 real(DP), intent(out) :: xy_Array        (0:imax-1, 1:jmax)
   652:             
   653:                 !
   654:                 ! Work variables
   655:                 !
   656:                 real(DP) :: val1
   657:                 real(DP) :: val2
   658:                 integer  :: ip1
   659:                 integer  :: ip2
   660:                 integer  :: iw1
   661:                 integer  :: iw2
   662:                 integer  :: i
   663:                 integer  :: j
   664:             
   665:             
   666:                 ! 初期化確認
   667:                 ! Initialization check
   668:                 !
   669:                 if ( .not. rad_ck1991_inited ) then
   670:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   671:                 end if
   672:             
   673:             
   674: W------>        do j = 1, jmax
   675: |*----->          do i = 0, imax-1
   676: ||          
   677: ||      A           ip1 = xy_IndexPress (i,j) - 1
   678: ||                  ip2 = xy_IndexPress (i,j)
   679: ||      A           iw1 = xy_IndexAbsAmt(i,j) - 1
   680: ||                  iw2 = xy_IndexAbsAmt(i,j)
   681: ||          
   682: ||      A           val1 =                                                          &
   683: ||                    &   ( aa_Tab          (iw2,ip1) - aa_Tab          (iw1,ip1) ) &
   684: ||                    & / ( a_TabLog10AbsAmt(iw2)     - a_TabLog10AbsAmt(iw1)     ) &
   685: ||                    & * ( xy_Log10AbsAmt  (i,j)     - a_TabLog10AbsAmt(iw1)     ) &
   686: ||                    & + aa_Tab            (iw1,ip1)
   687: ||      A           val2 =                                                          &
   688: ||                    &   ( aa_Tab          (iw2,ip2) - aa_Tab          (iw1,ip2) ) &
   689: ||                    & / ( a_TabLog10AbsAmt(iw2)     - a_TabLog10AbsAmt(iw1)     ) &
   690: ||                    & * ( xy_Log10AbsAmt  (i,j)     - a_TabLog10AbsAmt(iw1)     ) &
   691: ||                    & + aa_Tab            (iw1,ip2)
   692: ||          
   693: ||      A           xy_Array(i,j) =                                       &
   694: ||                    &   ( val2                 - val1                 ) &
   695: ||                    & / ( a_TabLog10Press(ip2) - a_TabLog10Press(ip1) ) &
   696: ||                    & * ( xy_Log10Press  (i,j) - a_TabLog10Press(ip1) ) &
   697: ||                    & + val1
   698: ||          
   699: |*-----           end do
   700: W------         end do
   701:             
   702:               end subroutine RadCK1991Interpolate
   703:             
   704:               !--------------------------------------------------------------------------------------
   705:             
   706:               subroutine RadCK1991Init
   707:             
   708:             
   709:                 ! ファイル入出力補助
   710:                 ! File I/O support
   711:                 !
   712:                 use dc_iounit, only: FileOpen
   713:             
   714:             !!$    ! NAMELIST ファイル入力に関するユーティリティ
   715:             !!$    ! Utilities for NAMELIST file input
   716:             !!$    !
   717:             !!$    use namelist_util, only: NmlutilMsg, NmlutilAryValid
   718:             
   719:             
   720:             !!$    integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号.
   721:             !!$                              ! Unit number for NAMELIST file open
   722:             !!$    integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT.
   723:             !!$                              ! IOSTAT of NAMELIST read
   724:             
   725:             
   726:             !!$    namelist /rad_RL78_nml/ &
   727:             !!$      & VMRCO2,                   &
   728:             !!$      & DelTimeCalcTransValue,    &
   729:             !!$      & DelTimeCalcTransUnit,     &
   730:             !!$      & flag_save_time
   731:             
   732:             
   733:                 if ( rad_CK1991_inited ) return
   734:             
   735:             !!$
   736:             !!$    VMRCO2                = 382.0d-6
   737:             !!$
   738:             !!$    DelTimeCalcTransValue = 3.0
   739:             !!$    DelTimeCalcTransUnit  = 'hrs'
   740:             !!$    flag_save_time        = .false.
   741:             !!$
   742:             !!$
   743:             !!$    ! NAMELIST is input
   744:             !!$    !
   745:             !!$    if ( trim(namelist_filename) /= '' ) then
   746:             !!$      call FileOpen( unit_nml, &          ! (out)
   747:             !!$        & namelist_filename, mode = 'r' ) ! (in)
   748:             !!$
   749:             !!$      rewind( unit_nml )
   750:             !!$      read( unit_nml,                     & ! (in)
   751:             !!$        & nml = rad_RL78_nml,       & ! (out)
   752:             !!$        & iostat = iostat_nml )             ! (out)
   753:             !!$      close( unit_nml )
   754:             !!$
   755:             !!$      call NmlutilMsg( iostat_nml, module_name ) ! (in)
   756:             !!$    end if
   757:             
   758:             
   759:                 ! Convert unit of pressure from mbar to Pa
   760:                 !
   761: V------>A       a_TabLog10Press = 10.0d0**a_TabLog10Press
   762: |               a_TabLog10Press = a_TabLog10Press * 1.0d2
   763: V------ A       a_TabLog10Press = log10( a_TabLog10Press )
   764:             
   765:                 ! Convert unit of absorber amount from (atm cm)_{STP} to kg m-2
   766:                 !   To convert from (atm cm)_{STP} to kg m-2, the value is divided by
   767:                 !   1.0d2 / 101325.0d0 * 8.31432d0 / ( 44.0d-3 ) * 273.15d0, and
   768:                 !   1.0d2 / 101325.0d0 * 8.31432d0 / ( 48.0d-3 ) * 273.15d0, 
   769:                 !   for CO2 and O3, respectively.
   770:                 !   MEMO: In a calculation below, GasRUniv variable in constants module can be used. 
   771:                 !         But, I do not use it, since unit of value is just converted by 
   772:                 !         multiplying a factor. Of course, non-use of GasRUniv must not cause 
   773:                 !         significant effect on result.
   774:                 !
   775: V------>A       a_CO2TabLog10AbsAmt = 10.0d0**a_CO2TabLog10AbsAmt
   776: |               a_CO2TabLog10AbsAmt = a_CO2TabLog10AbsAmt &
   777: |                 & / ( 1.0d2 / 101325.0d0 * 8.31432d0 / ( 44.0d-3 ) * 273.15d0 )
   778: |       A       a_CO2TabLog10AbsAmt = log10( a_CO2TabLog10AbsAmt )
   779: |               !
   780: |       A       a_O3TabLog10AbsAmt  = 10.0d0**a_O3TabLog10AbsAmt
   781: |               a_O3TabLog10AbsAmt  = a_O3TabLog10AbsAmt &
   782: |                 & / ( 1.0d2 / 101325.0d0 * 8.31432d0 / ( 48.0d-3 ) * 273.15d0 )
   783: V------ A       a_O3TabLog10AbsAmt  = log10( a_O3TabLog10AbsAmt )
   784:                 !
   785:                 ! Convert values absorptance from -1e3 * log10(A) to log10(A)
   786:                 !
   787: *W----->A       aa_CO2TabAbs = 10.0d0**( aa_CO2TabAbs / ( -1.0d3 ) )
   788: ||      A       aa_CO2TabAbs = log10( aa_CO2TabAbs )
   789: ||              !
   790: ||      A       aa_O3TabAbs  = 10.0d0**( aa_O3TabAbs / ( -1.0d3 ) )
   791: ||      A       aa_O3TabAbs  = log10( aa_O3TabAbs )
   792: ||              !
   793: ||              ! Convert values of alpha absorptance from 1e4 * alpha to alpha
   794: ||              !
   795: ||      A       aa_CO2TabAlpha = aa_CO2TabAlpha / ( 1.0d4 )
   796: ||              !
   797: ||      A       aa_O3TabAlpha  = aa_O3TabAlpha  / ( 1.0d4 )
   798: ||              !
   799: ||              ! Convert values of beta absorptance from 1e6 * beta to beta
   800: ||              !
   801: ||      A       aa_CO2TabBeta  = aa_CO2TabBeta  / ( 1.0d6 )
   802: ||              !
   803: *W----- A       aa_O3TabBeta   = aa_O3TabBeta   / ( 1.0d6 )
   804:             
   805:             
   806:             
   807:                 ! 印字 ; Print
   808:                 !
   809:                 call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   810:             !!$    call MessageNotify( 'M', module_name, '  DelTimeCalcTrans  = %f [%c]', &
   811:             !!$      & d = (/ DelTimeCalcTransValue /), c1 = trim( DelTimeCalcTransUnit ) )
   812:                 call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   813:             
   814:                 rad_ck1991_inited = .true.
   815:             
   816:               end subroutine RadCK1991Init
   817:             
   818:               !--------------------------------------------------------------------------------------
   819:             
   820:             end module rad_CK1991
