Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:39:01 2016
FILE NAME: i.rad_rrtmg_wrapper.F90
PROGRAM NAME: rad_rrtmg_wrapper
DIAGNOSTIC LIST

  LINE  LEVEL( NO.): DIAGNOSTIC MESSAGE

   218  opt  (1593): Loop nest collapsed into one loop.
   218  vec  (   1): Vectorized loop.
   218  vec  (  29): ADB is used for array.: xyz_delatmmass
   218  vec  (  29): ADB is used for array.: xyr_press
   536  warn (  83): Dummy argument "xyz_delatmmass" is not used.
   536  warn (  83): Dummy argument "xyz_press" is not used.
   536  warn (  83): Dummy argument "xyra_delradldwflux" is not used.
   536  warn (  83): Dummy argument "xyra_delradluwflux" is not used.
   536  warn (  83): Dummy argument "xy_surfalbedo" is not used.
   536  warn (  83): Dummy argument "xy_surftemp" is not used.
   536  warn (  83): Dummy argument "xyz_cloudcover" is not used.
   536  warn (  83): Dummy argument "xyr_press" is not used.
   536  warn (  83): Dummy argument "xyz_temp" is not used.
   536  warn (  83): Dummy argument "xyr_temp" is not used.
   536  warn (  83): Dummy argument "xyz_qh2oliq" is not used.
   536  warn (  83): Dummy argument "xyz_qh2osol" is not used.
   536  warn (  83): Dummy argument "xyz_qh2ovap" is not used.
   536  warn (  83): Dummy argument "xyr_radldwflux" is not used.
   536  warn (  83): Dummy argument "xyr_radluwflux" is not used.
   536  warn (  83): Dummy argument "xyr_radsdwflux" is not used.
   536  warn (  83): Dummy argument "xyr_radsuwflux" is not used.
   779  warn (  83): Dummy argument "flagsnow" is not used.
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:39:01 2016
FILE NAME: i.rad_rrtmg_wrapper.F90
PROGRAM NAME: rad_rrtmg_wrapper
TRANSFORMATION LIST

  LINE                   FORTRAN STATEMENT

     1  != wrapper of RRTMG
     2  !
     3  != wrapper of RRTMG
     4  !
     5  ! Authors::   Yoshiyuki O. Takahashi
     6  ! Version::   $Id: rad_rrtmg_wrapper.F90,v 1.1 2015/01/29 12:12:48 yot Exp $
     7  ! Tag Name::  $Name:  $
     8  ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9  ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10  !
    11  module rad_rrtmg_wrapper
    12    !
    13    != wrapper of RRTMG
    14    !
    15    != wrapper of RRTMG
    16    !
    17    ! <b>Note that Japanese and English are described in parallel.</b>
    18    !
    19    !
    20    !
    21    ! This is a wrapper program of radiation model, RRTMG.
    22    !
    23  
    24    ! Preparation
    25    ! * Extract src/radiation_rrtmg.tgz
    26    !   * src/radiation_rrtmg.tgz includes rrtmg_lw_read_nc_wrapper,
    27    !     rrtmg_sw_read_nc_wrapper, and Makefile.
    28    ! * Copy following files from rrtmg_lw_v4.85 and rrtmg_sw_v3.9 packages to
    29    !   dcpam5/src/radiation_rrtmg.
    30    !   % cp rrtmg_lw_v4.85/gcm_model/src/... dcpam5/src/radiation_rrtmg
    31    !   Copied files:
    32    !     parkind.f90 parrrsw.f90 parrrtm.f90
    33    !     rrlw_cld.f90 rrlw_con.f90
    34    !     rrlw_kg01.f90 rrlw_kg02.f90 rrlw_kg03.f90 rrlw_kg04.f90 rrlw_kg05.f90
    35    !     rrlw_kg06.f90 rrlw_kg07.f90 rrlw_kg08.f90 rrlw_kg09.f90 rrlw_kg10.f90
    36    !     rrlw_kg11.f90 rrlw_kg12.f90 rrlw_kg13.f90 rrlw_kg14.f90 rrlw_kg15.f90
    37    !     rrlw_kg16.f90
    38    !     rrlw_ncpar.f90 rrlw_ref.f90 rrlw_tbl.f90 rrlw_vsn.f90 rrlw_wvn.f90
    39    !     rrtmg_lw_cldprmc.f90 rrtmg_lw_cldprop.f90 rrtmg_lw_init.f90
    40    !     rrtmg_lw_rad.nomcica.f90 rrtmg_lw_read_nc.f90 rrtmg_lw_rtrn.f90
    41    !     rrtmg_lw_rtrnmc.f90 rrtmg_lw_rtrnmr.f90 rrtmg_lw_setcoef.f90
    42    !     rrtmg_lw_taumol.f90
    43    !     rrsw_aer.f90 rrsw_cld.f90 rrsw_con.f90
    44    !     rrsw_kg16.f90 rrsw_kg17.f90 rrsw_kg18.f90 rrsw_kg19.f90 rrsw_kg20.f90
    45    !     rrsw_kg21.f90 rrsw_kg22.f90 rrsw_kg23.f90 rrsw_kg24.f90 rrsw_kg25.f90
    46    !     rrsw_kg26.f90 rrsw_kg27.f90 rrsw_kg28.f90 rrsw_kg29.f90
    47    !     rrsw_ncpar.f90 rrsw_ref.f90 rrsw_tbl.f90 rrsw_vsn.f90 rrsw_wvn.f90
    48    !     rrtmg_sw_cldprmc.f90 rrtmg_sw_cldprop.f90 rrtmg_sw_init.f90
    49    !     rrtmg_sw_rad.nomcica.f90 rrtmg_sw_read_nc.f90 rrtmg_sw_reftra.f90
    50    !     rrtmg_sw_setcoef.f90 rrtmg_sw_spcvmc.f90 rrtmg_sw_spcvrt.f90
    51    !     rrtmg_sw_taumol.f90 rrtmg_sw_vrtqdr.f90
    52    ! * Add a following line in rrtmg_lw_init.f90.
    53    !     use rrtmg_lw_read_nc_wrapper
    54    ! * Add a following line in rrtmg_sw_init.f90.
    55    !     use rrtmg_sw_read_nc_wrapper
    56    ! * Compile with FFLAGS=-DRRTMG
    57    !   * Add radiation_rrtmg in LIBDIRS in src/Makefile
    58    !   * Perform make clean.depend after configuration once
    59    !   * Perform make depend
    60    !   * Perform make distclean
    61    !   * Perform configure with FFLAGS=-DRRTMG
    62    !   * Perform make
    63    !
    64    !== References
    65    !
    66    !
    67    !== Procedures List
    68    !
    69  !!$  ! RadEarthV2Flux :: 放射フラックスの計算
    70  !!$  ! ------------          :: ------------
    71  !!$  ! RadEarthV2Flux :: Calculate radiation flux
    72    !
    73    !== NAMELIST
    74    !
    75    ! NAMELIST#rad_rrtmg_wrapper_nml
    76    !
    77  
    78    ! USE statements
    79    !
    80  
    81    !
    82    ! Kind type parameter
    83    !
    84    use dc_types, only: DP, &      ! Double precision.
    85      &                 STRING, &  ! Strings.
    86      &                 TOKEN      ! Keywords.
    87  
    88    ! メッセージ出力
    89    ! Message output
    90    !
    91    use dc_message, only: MessageNotify
    92  
    93    !
    94    ! Physical constants settings
    95    !
    96    use constants, only: Grav     ! $ g $ [m s-2].
    97                                  !
    98                                  ! Gravitational acceleration
    99  
   100    ! 格子点設定
   101    ! Grid points settings
   102    !
   103    use gridset, only: imax, & ! 経度格子点数.
   104                               ! Number of grid points in longitude
   105      &                jmax, & ! 緯度格子点数.
   106                               ! Number of grid points in latitude
   107      &                kmax    ! 鉛直層数.
   108                               ! Number of vertical level
   109  
   110    implicit none
   111  
   112    private
   113  
   114    real(DP), save :: MeanMolWeight
   115    real(DP), save :: H2OMolWeight
   116    real(DP), save :: CO2MolWeight
   117    real(DP), save :: N2OMolWeight
   118    real(DP), save :: CH4MolWeight
   119  
   120    integer, save     :: IDCloudIceREffMethod
   121    !
   122    integer, parameter:: IDCloudIceREffMethodConst = 0
   123    integer, parameter:: IDCloudIceREffMethodLin   = 1
   124  
   125    real(DP), save :: CloudWatREff
   126    real(DP), save :: CloudIceREff
   127  
   128    real(DP), allocatable, save :: xyz_QO3(:,:,:)
   129                                ! O3 分布 (1)
   130                                ! O3 distribution (1)
   131  
   132  !!$  integer , save              :: SWVer
   133  !!$  integer , save              :: LWVer
   134  
   135    ! 公開変数
   136    ! Public variables
   137    !
   138    logical, save :: rad_rrtmg_wrapper_inited = .false.
   139                                ! 初期設定フラグ.
   140                                ! Initialization flag
   141  
   142    public :: RadRRTMGWrapperFlux
   143    public :: RadRRTMGWrapperInit
   144  
   145  
   146    character(*), parameter:: module_name = 'rad_rrtmg_wrapper'
   147                                ! モジュールの名称.
   148                                ! Module name
   149    character(*), parameter:: version = &
   150      & '$Name:  $' // &
   151      & '$Id: rad_rrtmg_wrapper.F90,v 1.1 2015/01/29 12:12:48 yot Exp $'
   152                                ! モジュールのバージョン
   153                                ! Module version
   154  
   155    !--------------------------------------------------------------------------------------
   156  
   157  contains
   158  
   159    !--------------------------------------------------------------------------------------
   160  
   161    subroutine RadRRTMGWrapperFlux(               &
   162      & xy_SurfAlbedo,                            & ! (in)
   163      & xyz_Press, xyr_Press, xyz_Temp, xyr_Temp, & ! (in)
   164      & xyz_QH2OVap, xyz_QH2OLiq, xyz_QH2OSol,    & ! (in)
   165      & xyz_CloudCover,                           & ! (in)
   166      & xy_SurfTemp,                              & ! (in)
   167      & xyr_RadSUwFlux, xyr_RadSDwFlux,           & ! (out)
   168      & xyr_RadLUwFlux, xyr_RadLDwFlux,           & ! (out)
   169      & xyra_DelRadLUwFlux, xyra_DelRadLDwFlux    & ! (out)
   170      & )
   171  
   172  
   173      ! USE statements
   174      !
   175  
   176      real(DP), intent(in ) :: xy_SurfAlbedo   (0:imax-1, 1:jmax)
   177      real(DP), intent(in ) :: xyz_Press       (0:imax-1, 1:jmax, 1:kmax)
   178      real(DP), intent(in ) :: xyr_Press       (0:imax-1, 1:jmax, 0:kmax)
   179      real(DP), intent(in ) :: xyz_Temp        (0:imax-1, 1:jmax, 1:kmax)
   180      real(DP), intent(in ) :: xyr_Temp        (0:imax-1, 1:jmax, 0:kmax)
   181      real(DP), intent(in ) :: xyz_QH2OVap     (0:imax-1, 1:jmax, 1:kmax)
   182                                ! $ q $ .   混合比. Mass mixing ratio of constituents (1)
   183      real(DP), intent(in ) :: xyz_QH2OLiq     (0:imax-1, 1:jmax, 1:kmax)
   184      real(DP), intent(in ) :: xyz_QH2OSol     (0:imax-1, 1:jmax, 1:kmax)
   185      real(DP), intent(in ) :: xyz_CloudCover  (0:imax-1, 1:jmax, 1:kmax)
   186      real(DP), intent(in ) :: xy_SurfTemp     (0:imax-1, 1:jmax)
   187      real(DP), intent(out) :: xyr_RadSUwFlux   (0:imax-1, 1:jmax, 0:kmax)
   188      real(DP), intent(out) :: xyr_RadSDwFlux   (0:imax-1, 1:jmax, 0:kmax)
   189      real(DP), intent(out) :: xyr_RadLUwFlux    (0:imax-1, 1:jmax, 0:kmax)
   190      real(DP), intent(out) :: xyr_RadLDwFlux    (0:imax-1, 1:jmax, 0:kmax)
   191      real(DP), intent(out) :: xyra_DelRadLUwFlux(0:imax-1, 1:jmax, 0:kmax, 0:1)
   192      real(DP), intent(out) :: xyra_DelRadLDwFlux(0:imax-1, 1:jmax, 0:kmax, 0:1)
   193  
   194  !!$    real(DP):: xyr_RadLUwFlux    (0:imax-1, 1:jmax, 0:kmax)
   195  !!$    real(DP):: xyr_RadLDwFlux    (0:imax-1, 1:jmax, 0:kmax)
   196  !!$    real(DP):: xyra_DelRadLUwFlux(0:imax-1, 1:jmax, 0:kmax, 0:1)
   197  !!$    real(DP):: xyra_DelRadLDwFlux(0:imax-1, 1:jmax, 0:kmax, 0:1)
   198  
   199  
   200      ! Work variables
   201      !
   202      real(DP) :: xyz_DelAtmMass   (0:imax-1, 1:jmax, 1:kmax)
   203  
   204      integer  :: k
   205  
   206  
   207      ! 初期化確認
   208      ! Initialization check
   209      !
   210      if ( .not. rad_rrtmg_wrapper_inited ) then
   211        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   212      end if
   213  
   214  
   215      call MessageNotify( 'E', module_name, 'RRTMG modules are not included in compilation.' )
   216  
   217  
   218      do k = 1, kmax
   219        xyz_DelAtmMass(:,:,k) = ( xyr_Press(:,:,k-1) - xyr_Press(:,:,k ) ) / Grav
   220      end do
     .        d1 = 1.D0/grav                                                    
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do k = 1, kmax*jmax*imax                                          
     .           xyz_delatmmass(k-1,1,1) = (xyr_press(k-1,1,0)-xyr_press(k-1,1,1
     .       1      ))*d1                                                       
     .        enddo                                                             
   221  
   222      call RadRRTMGWrapperFluxCore(                          &
   223        & xy_SurfAlbedo,                                     &
   224        & xyz_DelAtmMass, &
   225        & xyz_Press, xyr_Press, &
   226        & xyz_Temp, xyr_Temp, &
   227        & xyz_QH2OVap, xyz_QH2OLiq, xyz_QH2OSol, &
   228        & xyz_CloudCover,                                    &
   229        & xy_SurfTemp,                                       &
   230        & xyr_RadSUwFlux, xyr_RadSDwFlux,                    &
   231        & xyr_RadLUwFlux, xyr_RadLDwFlux,                          & ! (out)
   232        & xyra_DelRadLUwFlux, xyra_DelRadLDwFlux                   & ! (out)
   233        & )
   234  
   235  
   236    end subroutine RadRRTMGWrapperFlux
   237  
   238    !--------------------------------------------------------------------------------------
   239  !!$
   240  !!$  subroutine RadEarthV2FluxforNHM(                                          &
   241  !!$    & r_Height, xy_SurfAlbedo,                                              &
   242  !!$    & xyz_Dens, xyz_Press, xyz_Temp, xyz_QH2OVap, xyz_QH2OLiq, xyz_QH2OSol, &
   243  !!$    & xy_SurfTemp,                                                          &
   244  !!$    & xyr_RadSFlux, xyr_RadLFlux, xyra_DelRadLFlux                          &
   245  !!$    & )
   246  !!$
   247  !!$
   248  !!$    ! USE statements
   249  !!$    !
   250  !!$
   251  !!$    real(DP), intent(in ) :: r_Height                          (0:kmax)
   252  !!$    real(DP), intent(in ) :: xy_SurfAlbedo   (0:imax-1, 1:jmax)
   253  !!$    real(DP), intent(in ) :: xyz_Dens        (0:imax-1, 1:jmax, 1:kmax)
   254  !!$    real(DP), intent(in ) :: xyz_Press       (0:imax-1, 1:jmax, 1:kmax)
   255  !!$    real(DP), intent(in ) :: xyz_Temp        (0:imax-1, 1:jmax, 1:kmax)
   256  !!$    real(DP), intent(in ) :: xyz_QH2OVap     (0:imax-1, 1:jmax, 1:kmax)
   257  !!$                              ! $ q $ .   混合比. Mass mixing ratio of constituents (1)
   258  !!$    real(DP), intent(in ) :: xyz_QH2OLiq     (0:imax-1, 1:jmax, 1:kmax)
   259  !!$    real(DP), intent(in ) :: xyz_QH2OSol     (0:imax-1, 1:jmax, 1:kmax)
   260  !!$    real(DP), intent(in ) :: xy_SurfTemp     (0:imax-1, 1:jmax)
   261  !!$    real(DP), intent(out) :: xyr_RadSFlux    (0:imax-1, 1:jmax, 0:kmax)
   262  !!$    real(DP), intent(out) :: xyr_RadLFlux    (0:imax-1, 1:jmax, 0:kmax)
   263  !!$    real(DP), intent(out) :: xyra_DelRadLFlux(0:imax-1, 1:jmax, 0:kmax, 0:1)
   264  !!$
   265  !!$
   266  !!$    ! Work variables
   267  !!$    !
   268  !!$    real(DP) :: xyz_DelAtmMass   (0:imax-1, 1:jmax, 1:kmax)
   269  !!$
   270  !!$    integer  :: k
   271  !!$
   272  !!$
   273  !!$    ! 初期化確認
   274  !!$    ! Initialization check
   275  !!$    !
   276  !!$    if ( .not. rad_Earth_V2_inited ) then
   277  !!$      call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   278  !!$    end if
   279  !!$
   280  !!$
   281  !!$    do k = 1, kmax
   282  !!$      xyz_DelAtmMass(:,:,k) = xyz_Dens(:,:,k) * ( r_Height(k) - r_Height(k-1) )
   283  !!$    end do
   284  !!$
   285  !!$    call RadEarthV2FluxCore(                                                        &
   286  !!$      & xy_SurfAlbedo,                                                              &
   287  !!$      & xyz_DelAtmMass, xyz_Press, xyz_Temp, xyz_QH2OVap, xyz_QH2OLiq, xyz_QH2OSol, &
   288  !!$      & xy_SurfTemp,                                                                &
   289  !!$      & xyr_RadSFlux, xyr_RadLFlux, xyra_DelRadLFlux                                &
   290  !!$      & )
   291  !!$
   292  !!$
   293  !!$  end subroutine RadEarthV2FluxforNHM
   294  !!$
   295    !--------------------------------------------------------------------------------------
   296  !!$
   297  !!$  subroutine RadDcpamEV2FluxforNHM2DWrapper(                    &
   298  !!$    & r_Height, x_SurfAlbedo,                                   &
   299  !!$    & xz_Dens, xz_Press, xz_Temp, xz_QH2OVap, xz_QH2OLiq,       &
   300  !!$    & x_SurfTemp,                                               &
   301  !!$    & xr_RadSFlux, xr_RadLFlux, xra_DelRadLFlux                 &
   302  !!$    & )
   303  !!$
   304  !!$
   305  !!$    ! USE statements
   306  !!$    !
   307  !!$
   308  !!$
   309  !!$    real(DP), intent(in ) :: r_Height                 (0:kmax)
   310  !!$    real(DP), intent(in ) :: x_SurfAlbedo   (0:imax-1)
   311  !!$    real(DP), intent(in ) :: xz_Dens        (0:imax-1, 1:kmax)
   312  !!$    real(DP), intent(in ) :: xz_Press       (0:imax-1, 1:kmax)
   313  !!$    real(DP), intent(in ) :: xz_Temp        (0:imax-1, 1:kmax)
   314  !!$    real(DP), intent(in ) :: xz_QH2OVap     (0:imax-1, 1:kmax)
   315  !!$    real(DP), intent(in ) :: xz_QH2OLiq     (0:imax-1, 1:kmax)
   316  !!$    real(DP), intent(in ) :: x_SurfTemp     (0:imax-1)
   317  !!$    real(DP), intent(out) :: xr_RadSFlux    (0:imax-1, 0:kmax)
   318  !!$    real(DP), intent(out) :: xr_RadLFlux    (0:imax-1, 0:kmax)
   319  !!$    real(DP), intent(out) :: xra_DelRadLFlux(0:imax-1, 0:kmax, 0:1)
   320  !!$
   321  !!$
   322  !!$    ! Work variables
   323  !!$    !
   324  !!$    real(DP) :: xy_SurfAlbedo   (0:imax-1, 1:jmax)
   325  !!$    real(DP) :: xyz_Dens        (0:imax-1, 1:jmax, 1:kmax)
   326  !!$    real(DP) :: xyz_Press       (0:imax-1, 1:jmax, 1:kmax)
   327  !!$    real(DP) :: xyz_Temp        (0:imax-1, 1:jmax, 1:kmax)
   328  !!$    real(DP) :: xyz_QH2OVap     (0:imax-1, 1:jmax, 1:kmax)
   329  !!$    real(DP) :: xyz_QH2OLiq     (0:imax-1, 1:jmax, 1:kmax)
   330  !!$    real(DP) :: xy_SurfTemp     (0:imax-1, 1:jmax)
   331  !!$    real(DP) :: xyr_RadSFlux    (0:imax-1, 1:jmax, 0:kmax)
   332  !!$    real(DP) :: xyr_RadLFlux    (0:imax-1, 1:jmax, 0:kmax)
   333  !!$    real(DP) :: xyra_DelRadLFlux(0:imax-1, 1:jmax, 0:kmax, 0:1)
   334  !!$
   335  !!$    integer  :: k
   336  !!$
   337  !!$
   338  !!$    ! 初期化確認
   339  !!$    ! Initialization check
   340  !!$    !
   341  !!$    if ( .not. rad_dcpam_E_V2_inited ) then
   342  !!$      call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   343  !!$    end if
   344  !!$
   345  !!$
   346  !!$    if ( jmax /= 1 ) then
   347  !!$      call MessageNotify( 'E', module_name, 'jmax must be 1.' )
   348  !!$    end if
   349  !!$
   350  !!$
   351  !!$    xy_SurfAlbedo   (:, 1)       = x_SurfAlbedo   (:)
   352  !!$    do k = 1, kmax
   353  !!$      xyz_Dens        (:, 1, k)    = xz_Dens        (:, k)
   354  !!$      xyz_Press       (:, 1, k)    = xz_Press       (:, k)
   355  !!$      xyz_Temp        (:, 1, k)    = xz_Temp        (:, k)
   356  !!$      xyz_QH2OVap     (:, 1, k)    = xz_QH2OVap     (:, k)
   357  !!$      xyz_QH2OLiq     (:, 1, k)    = xz_QH2OLiq     (:, k)
   358  !!$    end do
   359  !!$    xy_SurfTemp     (:, 1)       = x_SurfTemp     (:)
   360  !!$
   361  !!$    call RadDcpamEV2FluxforNHM(                                       &
   362  !!$      & r_Height, xy_SurfAlbedo,                                      &
   363  !!$      & xyz_Dens, xyz_Press, xyz_Temp, xyz_QH2OVap, xyz_QH2OLiq,      &
   364  !!$      & xy_SurfTemp,                                                  &
   365  !!$      & xyr_RadSFlux, xyr_RadLFlux, xyra_DelRadLFlux                  &
   366  !!$      & )
   367  !!$
   368  !!$    xr_RadSFlux    (:, :)    = xyr_RadSFlux    (:, 1, :)
   369  !!$    xr_RadLFlux    (:, :)    = xyr_RadLFlux    (:, 1, :)
   370  !!$    xra_DelRadLFlux(:, :, :) = xyra_DelRadLFlux(:, 1, :, :)
   371  !!$
   372  !!$
   373  !!$  end subroutine RadDcpamEV2FluxforNHM2DWrapper
   374  !!$
   375    !--------------------------------------------------------------------------------------
   376  !!$
   377  !!$  subroutine RadDcpamEV2Flux2DWrapper(                         &
   378  !!$    & x_SurfAlbedo,                                            &
   379  !!$    & xz_Press, xr_Press, xz_Temp, xz_QH2OVap, xz_QH2OLiq,     &
   380  !!$    & x_SurfTemp,                                              &
   381  !!$    & xr_RadSFlux, xr_RadLFlux, xra_DelRadLFlux                &
   382  !!$    & )
   383  !!$
   384  !!$
   385  !!$    ! USE statements
   386  !!$    !
   387  !!$
   388  !!$
   389  !!$
   390  !!$    real(DP), intent(in ) :: x_SurfAlbedo   (0:imax-1)
   391  !!$    real(DP), intent(in ) :: xz_Press       (0:imax-1, 1:kmax)
   392  !!$    real(DP), intent(in ) :: xr_Press       (0:imax-1, 0:kmax)
   393  !!$    real(DP), intent(in ) :: xz_Temp        (0:imax-1, 1:kmax)
   394  !!$    real(DP), intent(in ) :: xz_QH2OVap     (0:imax-1, 1:kmax)
   395  !!$    real(DP), intent(in ) :: xz_QH2OLiq     (0:imax-1, 1:kmax)
   396  !!$    real(DP), intent(in ) :: x_SurfTemp     (0:imax-1)
   397  !!$    real(DP), intent(out) :: xr_RadSFlux    (0:imax-1, 0:kmax)
   398  !!$    real(DP), intent(out) :: xr_RadLFlux    (0:imax-1, 0:kmax)
   399  !!$    real(DP), intent(out) :: xra_DelRadLFlux(0:imax-1, 0:kmax, 0:1)
   400  !!$
   401  !!$
   402  !!$    ! Work variables
   403  !!$    !
   404  !!$    real(DP) :: xy_SurfAlbedo   (0:imax-1, 1:jmax)
   405  !!$    real(DP) :: xyz_Press       (0:imax-1, 1:jmax, 1:kmax)
   406  !!$    real(DP) :: xyr_Press       (0:imax-1, 1:jmax, 0:kmax)
   407  !!$    real(DP) :: xyz_Temp        (0:imax-1, 1:jmax, 1:kmax)
   408  !!$    real(DP) :: xyz_QH2OVap     (0:imax-1, 1:jmax, 1:kmax)
   409  !!$    real(DP) :: xyz_QH2OLiq     (0:imax-1, 1:jmax, 1:kmax)
   410  !!$    real(DP) :: xy_SurfTemp     (0:imax-1, 1:jmax)
   411  !!$    real(DP) :: xyr_RadSFlux    (0:imax-1, 1:jmax, 0:kmax)
   412  !!$    real(DP) :: xyr_RadLFlux    (0:imax-1, 1:jmax, 0:kmax)
   413  !!$    real(DP) :: xyra_DelRadLFlux(0:imax-1, 1:jmax, 0:kmax, 0:1)
   414  !!$
   415  !!$
   416  !!$    ! 初期化確認
   417  !!$    ! Initialization check
   418  !!$    !
   419  !!$    if ( .not. rad_dcpam_E_V2_inited ) then
   420  !!$      call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   421  !!$    end if
   422  !!$
   423  !!$
   424  !!$    if ( jmax /= 1 ) then
   425  !!$      call MessageNotify( 'E', module_name, 'jmax must be 1.' )
   426  !!$    end if
   427  !!$
   428  !!$
   429  !!$    xy_SurfAlbedo   (:, 1)       = x_SurfAlbedo   (:)
   430  !!$    xyz_Press       (:, 1, :)    = xz_Press       (:, :)
   431  !!$    xyr_Press       (:, 1, :)    = xr_Press       (:, :)
   432  !!$    xyz_Temp        (:, 1, :)    = xz_Temp        (:, :)
   433  !!$    xyz_QH2OVap     (:, 1, :)    = xz_QH2OVap     (:, :)
   434  !!$    xyz_QH2OLiq     (:, 1, :)    = xz_QH2OLiq     (:, :)
   435  !!$    xy_SurfTemp     (:, 1)       = x_SurfTemp     (:)
   436  !!$
   437  !!$    call RadDcpamEV2Flux(                                             &
   438  !!$      & xy_SurfAlbedo,                                                &
   439  !!$      & xyz_Press, xyr_Press, xyz_Temp, xyz_QH2OVap, xyz_QH2OLiq,     &
   440  !!$      & xy_SurfTemp,                                                  &
   441  !!$      & xyr_RadSFlux, xyr_RadLFlux, xyra_DelRadLFlux                  &
   442  !!$      & )
   443  !!$
   444  !!$    xr_RadSFlux    (:, :)    = xyr_RadSFlux    (:, 1, :)
   445  !!$    xr_RadLFlux    (:, :)    = xyr_RadLFlux    (:, 1, :)
   446  !!$    xra_DelRadLFlux(:, :, :) = xyra_DelRadLFlux(:, 1, :, :)
   447  !!$
   448  !!$
   449  !!$  end subroutine RadDcpamEV2Flux2DWrapper
   450  !!$
   451    !--------------------------------------------------------------------------------------
   452  
   453    subroutine RadRRTMGWrapperFluxCore(                          &
   454      & xy_SurfAlbedo,                                           &
   455      & xyz_DelAtmMass,                                          &
   456      & xyz_Press, xyr_Press, xyz_Temp, xyr_Temp,                &
   457      & xyz_QH2OVap, xyz_QH2OLiq, xyz_QH2OSol,                   &
   458      & xyz_CloudCover,                                          &
   459      & xy_SurfTemp,                                             &
   460      & xyr_RadSUwFlux, xyr_RadSDwFlux,                          &
   461      & xyr_RadLUwFlux, xyr_RadLDwFlux,                          & ! (out)
   462      & xyra_DelRadLUwFlux, xyra_DelRadLDwFlux                   & ! (out)
   463      & )
   464  
   465  
   466      ! USE statements
   467      !
   468  
   469      ! ヒストリデータ出力
   470      ! History data output
   471      !
   472      use gtool_historyauto, only: HistoryAutoPut
   473  
   474      ! 時刻管理
   475      ! Time control
   476      !
   477      use timeset, only: &
   478        & TimeN                 ! ステップ $ t $ の時刻.
   479                                ! Time of step $ t $.
   480  
   481      ! 全球一定体積混合比の設定
   482      ! Set globally constant volume mixing ratio
   483      !
   484      use set_gcmr, only : SetGCMR
   485  
   486      ! O3 分布の設定
   487      ! Set O3 distribution
   488      !
   489      use set_o3, only: SetO3
   490  
   491  !!$    ! 地球大気向け短波放射モデル Ver. 2.6
   492  !!$    ! short wave radiation model for the Earth's atmosphere Ver. 2.6
   493  !!$    !
   494  !!$    use rad_Earth_SW_V2_6, only: RadEarthSWV26Flux
   495  !!$
   496  !!$    ! 地球大気向け長波放射モデル Ver. 2.4
   497  !!$    ! long wave radiation model for the Earth's atmosphere Ver. 2.4
   498  !!$    !
   499  !!$    use rad_Earth_LW_V2_4, only : RadEarthLWV24Flux
   500  
   501  
   502  
   503      ! 太陽放射フラックスの設定
   504      ! Set solar constant
   505      !
   506      use set_solarconst, only : SetSolarConst
   507  
   508      ! 短波入射 (太陽入射)
   509      ! Short wave (insolation) incoming
   510      !
   511      use rad_short_income, only : RadShortIncome
   512  
   513  
   514      real(DP), intent(in ) :: xy_SurfAlbedo   (0:imax-1, 1:jmax)
   515      real(DP), intent(in ) :: xyz_DelAtmMass  (0:imax-1, 1:jmax, 1:kmax)
   516      real(DP), intent(in ) :: xyz_Press       (0:imax-1, 1:jmax, 1:kmax)
   517      real(DP), intent(in ) :: xyr_Press       (0:imax-1, 1:jmax, 0:kmax)
   518      real(DP), intent(in ) :: xyz_Temp        (0:imax-1, 1:jmax, 1:kmax)
   519      real(DP), intent(in ) :: xyr_Temp        (0:imax-1, 1:jmax, 0:kmax)
   520      real(DP), intent(in ) :: xyz_QH2OVap     (0:imax-1, 1:jmax, 1:kmax)
   521                                ! $ q $ .   混合比. Mass mixing ratio of constituents (1)
   522      real(DP), intent(in ) :: xyz_QH2OLiq     (0:imax-1, 1:jmax, 1:kmax)
   523      real(DP), intent(in ) :: xyz_QH2OSol     (0:imax-1, 1:jmax, 1:kmax)
   524      real(DP), intent(in ) :: xyz_CloudCover  (0:imax-1, 1:jmax, 1:kmax)
   525      real(DP), intent(in ) :: xy_SurfTemp     (0:imax-1, 1:jmax)
   526      real(DP), intent(out) :: xyr_RadSUwFlux    (0:imax-1, 1:jmax, 0:kmax)
   527      real(DP), intent(out) :: xyr_RadSDwFlux    (0:imax-1, 1:jmax, 0:kmax)
   528      real(DP), intent(out) :: xyr_RadLUwFlux    (0:imax-1, 1:jmax, 0:kmax)
   529      real(DP), intent(out) :: xyr_RadLDwFlux    (0:imax-1, 1:jmax, 0:kmax)
   530      real(DP), intent(out) :: xyra_DelRadLUwFlux(0:imax-1, 1:jmax, 0:kmax, 0:1)
   531      real(DP), intent(out) :: xyra_DelRadLDwFlux(0:imax-1, 1:jmax, 0:kmax, 0:1)
   532  
   533  
   534  
   535  
   536    end subroutine RadRRTMGWrapperFluxCore
   537  
   538    !--------------------------------------------------------------------------------------
   539  
   540    subroutine RadRRTMGWrapperInit(    &
   541      & FlagSnow                  &
   542      & )
   543  
   544      ! ファイル入出力補助
   545      ! File I/O support
   546      !
   547      use dc_iounit, only: FileOpen
   548  
   549      ! ヒストリデータ出力
   550      ! History data output
   551      !
   552      use gtool_historyauto, only: HistoryAutoAddVariable
   553  
   554      ! NAMELIST ファイル入力に関するユーティリティ
   555      ! Utilities for NAMELIST file input
   556      !
   557      use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid
   558  
   559      ! 全球一定体積混合比の設定
   560      ! Set globally constant volume mixing ratio
   561      !
   562      use set_gcmr, only : SetGCMRInit
   563  
   564      ! O3 分布の設定
   565      ! Set O3 distribution
   566      !
   567      use set_o3, only : SetO3Init
   568  
   569      !
   570      ! Physical constants settings
   571      !
   572      use constants, only: &
   573        & CpDry
   574                              ! $ C_p $ [J kg-1 K-1].
   575                              ! 乾燥大気の定圧比熱.
   576                              ! Specific heat of air at constant pressure
   577  
   578  !!$    ! 地球大気向け短波放射モデル Ver. 2.6
   579  !!$    ! short wave radiation model for the Earth's atmosphere Ver. 2.6
   580  !!$    !
   581  !!$    use rad_Earth_SW_V2_6, only: RadEarthSWV26Init
   582  !!$
   583  !!$    ! 地球大気向け長波放射モデル Ver. 2.4
   584  !!$    ! long wave radiation model for the Earth's atmosphere Ver. 2.4
   585  !!$    !
   586  !!$    use rad_Earth_LW_V2_4, only : RadEarthLWV24Init
   587  
   588  
   589  
   590      ! 太陽放射フラックスの設定
   591      ! Set solar constant
   592      !
   593      use set_solarconst, only : SetSolarConstInit
   594  
   595      ! 短波入射 (太陽入射)
   596      ! Short wave (insolation) incoming
   597      !
   598      use rad_short_income, only : RadShortIncomeInit
   599  
   600      ! 座標データ設定
   601      ! Axes data settings
   602      !
   603      use axesset, only : AxnameX, AxnameY, AxnameZ, AxnameR, AxnameT
   604  
   605      ! 宣言文 ; Declaration statements
   606      !
   607  
   608      logical, intent(in) :: FlagSnow
   609  
   610      character(STRING)   :: CloudIceREffMethod
   611  
   612      integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号.
   613                                ! Unit number for NAMELIST file open
   614      integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT.
   615                                ! IOSTAT of NAMELIST read
   616  
   617      ! NAMELIST 変数群
   618      ! NAMELIST group name
   619      !
   620      namelist /rad_rrtmg_wrapper_nml/ &
   621        & CloudIceREffMethod,     &
   622        & CloudWatREff,           &
   623        & CloudIceREff
   624  
   625  !!$      & SWVer, LWVer
   626            !
   627            ! デフォルト値については初期化手続 "rad_rrtmg_wrapper#RadEarthV2Init"
   628            ! のソースコードを参照のこと.
   629            !
   630            ! Refer to source codes in the initialization procedure
   631            ! "rad_rrtmg_wrapper#RadEarthV2Init" for the default values.
   632            !
   633  
   634      if ( rad_rrtmg_wrapper_inited ) return
   635  
   636  
   637      ! Molecular weights of atmosphere, CO2, H2O, N2O, CH4
   638      !
   639      MeanMolWeight = 28.0d-3
   640      CO2MolWeight  = 44.0d-3
   641      H2OMolWeight  = 18.0d-3
   642      N2OMolWeight  = 44.0d-3
   643      CH4MolWeight  = 16.0d-3
   644  
   645  
   646      ! デフォルト値の設定
   647      ! Default values settings
   648      !
   649      CloudIceREffMethod = 'Const'
   650  !!$    CloudIceREffMethod = 'Lin'
   651  
   652      CloudWatREff    = 10.0d-6
   653      CloudIceREff    = 50.0d-6
   654  
   655  
   656  !!$    SWVer = 1
   657  !!$    LWVer = 3
   658  
   659  
   660      ! NAMELIST の読み込み
   661      ! NAMELIST is input
   662      !
   663      if ( trim(namelist_filename) /= '' ) then
   664        call FileOpen( unit_nml, &          ! (out)
   665          & namelist_filename, mode = 'r' ) ! (in)
   666  
   667        rewind( unit_nml )
   668        read( unit_nml,                     & ! (in)
   669          & nml = rad_rrtmg_wrapper_nml,         & ! (out)
   670          & iostat = iostat_nml )             ! (out)
   671        close( unit_nml )
   672  
   673        call NmlutilMsg( iostat_nml, module_name ) ! (in)
   674      end if
   675  
   676  
   677      ! Identification of calculation method of cloud particle effective radius
   678      !
   679      call MessageNotify( 'M', module_name, &
   680        & 'CloudIceREffMethod=<%c>.', &
   681        & c1 = trim(CloudIceREffMethod) )
   682      !
   683      select case ( CloudIceREffMethod )
   684      case ( 'Const' )
   685        IDCloudIceREffMethod = IDCloudIceREffMethodConst
   686      case ( 'Lin' )
   687        IDCloudIceREffMethod = IDCloudIceREffMethodLin
   688      case default
   689        call MessageNotify( 'E', module_name, &
   690          & 'CloudIceREffMethod=<%c> is not supported.', &
   691          & c1 = trim(CloudIceREffMethod) )
   692      end select
   693  
   694  
   695      ! Allocate a local variable for O3 distribution
   696      !
   697      allocate( xyz_QO3(0:imax-1, 1:jmax, 1:kmax) )
   698  
   699  
   700      ! Initialization of modules used in this module
   701      !
   702  
   703      ! 全球一定体積混合比の設定
   704      ! Set globally constant volume mixing ratio
   705      !
   706      call SetGCMRInit
   707  
   708      ! O3 分布の設定
   709      ! Set O3 distribution
   710      !
   711      call SetO3Init
   712  
   713  
   714  !!$    ! 地球大気向け短波放射モデル Ver. 2.6
   715  !!$    ! short wave radiation model for the Earth's atmosphere Ver. 2.6
   716  !!$    !
   717  !!$    call RadEarthSWV26Init( &
   718  !!$      & FlagSnow &
   719  !!$      & )
   720  !!$
   721  !!$    ! 地球大気向け長波放射モデル Ver. 2.4
   722  !!$    ! long wave radiation model for the Earth's atmosphere Ver. 2.4
   723  !!$    !
   724  !!$    call RadEarthLWV24Init( &
   725  !!$      & FlagSnow            &
   726  !!$      & )
   727  
   728  
   729  
   730  
   731      ! 太陽放射フラックスの設定
   732      ! Set solar constant
   733      !
   734      call SetSolarConstInit
   735  
   736      ! 短波入射 (太陽入射)
   737      ! Short wave (insolation) incoming
   738      !
   739      call RadShortIncomeInit
   740  
   741  
   742      ! ヒストリデータ出力のためのへの変数登録
   743      ! Register of variables for history data output
   744      !
   745      call HistoryAutoAddVariable( 'CloudCoverforRad', &
   746        & (/ AxnameX, AxnameY, AxnameZ, AxnameT /), &
   747        & 'cloud cover', '1' )
   748      call HistoryAutoAddVariable( 'CloudCoverRand', &
   749        & (/ AxnameX, AxnameY, AxnameT /), &
   750        & 'cloud cover', '1' )
   751  
   752      call HistoryAutoAddVariable( 'RadCSLUWFLXB', &
   753        & (/ AxnameX, AxnameY, AxnameR, AxnameT /), &
   754        & 'clear sky upward longwave flux', 'W m-2' )
   755      call HistoryAutoAddVariable( 'RadCSLDWFLXB', &
   756        & (/ AxnameX, AxnameY, AxnameR, AxnameT /), &
   757        & 'clear sky downward longwave flux', 'W m-2' )
   758      call HistoryAutoAddVariable( 'RadCSSUWFLXB', &
   759        & (/ AxnameX, AxnameY, AxnameR, AxnameT /), &
   760        & 'clear sky upward shortwave flux', 'W m-2' )
   761      call HistoryAutoAddVariable( 'RadCSSDWFLXB', &
   762        & (/ AxnameX, AxnameY, AxnameR, AxnameT /), &
   763        & 'clear sky downward shortwave flux', 'W m-2' )
   764  
   765      ! 印字 ; Print
   766      !
   767      call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   768      call MessageNotify( 'M', module_name, '  CloudWatREff      = %f', &
   769        & d = (/ CloudWatREff /) )
   770      call MessageNotify( 'M', module_name, '  CloudIceREff      = %f', &
   771        & d = (/ CloudIceREff /) )
   772  !!$    call MessageNotify( 'M', module_name, 'SWVer = %d', i = (/ SWVer /) )
   773  !!$    call MessageNotify( 'M', module_name, 'LWVer = %d', i = (/ LWVer /) )
   774      call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   775  
   776  
   777      rad_rrtmg_wrapper_inited = .true.
   778  
   779    end subroutine RadRRTMGWrapperInit
   780  
   781    !--------------------------------------------------------------------------------------
   782  
   783  end module rad_rrtmg_wrapper
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:39:01 2016
FILE NAME: i.rad_rrtmg_wrapper.F90
PROGRAM NAME: rad_rrtmg_wrapper
FORMAT LIST

  LINE    LOOP      FORTRAN STATEMENT

     1:             != wrapper of RRTMG
     2:             !
     3:             != wrapper of RRTMG
     4:             !
     5:             ! Authors::   Yoshiyuki O. Takahashi
     6:             ! Version::   $Id: rad_rrtmg_wrapper.F90,v 1.1 2015/01/29 12:12:48 yot Exp $
     7:             ! Tag Name::  $Name:  $
     8:             ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9:             ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10:             !
    11:             module rad_rrtmg_wrapper
    12:               !
    13:               != wrapper of RRTMG
    14:               !
    15:               != wrapper of RRTMG
    16:               !
    17:               ! <b>Note that Japanese and English are described in parallel.</b>
    18:               !
    19:               ! 
    20:               !
    21:               ! This is a wrapper program of radiation model, RRTMG.
    22:               !
    23:             
    24:               ! Preparation
    25:               ! * Extract src/radiation_rrtmg.tgz
    26:               !   * src/radiation_rrtmg.tgz includes rrtmg_lw_read_nc_wrapper, 
    27:               !     rrtmg_sw_read_nc_wrapper, and Makefile.
    28:               ! * Copy following files from rrtmg_lw_v4.85 and rrtmg_sw_v3.9 packages to 
    29:               !   dcpam5/src/radiation_rrtmg.
    30:               !   % cp rrtmg_lw_v4.85/gcm_model/src/... dcpam5/src/radiation_rrtmg
    31:               !   Copied files:
    32:               !     parkind.f90 parrrsw.f90 parrrtm.f90 
    33:               !     rrlw_cld.f90 rrlw_con.f90
    34:               !     rrlw_kg01.f90 rrlw_kg02.f90 rrlw_kg03.f90 rrlw_kg04.f90 rrlw_kg05.f90
    35:               !     rrlw_kg06.f90 rrlw_kg07.f90 rrlw_kg08.f90 rrlw_kg09.f90 rrlw_kg10.f90
    36:               !     rrlw_kg11.f90 rrlw_kg12.f90 rrlw_kg13.f90 rrlw_kg14.f90 rrlw_kg15.f90
    37:               !     rrlw_kg16.f90
    38:               !     rrlw_ncpar.f90 rrlw_ref.f90 rrlw_tbl.f90 rrlw_vsn.f90 rrlw_wvn.f90
    39:               !     rrtmg_lw_cldprmc.f90 rrtmg_lw_cldprop.f90 rrtmg_lw_init.f90
    40:               !     rrtmg_lw_rad.nomcica.f90 rrtmg_lw_read_nc.f90 rrtmg_lw_rtrn.f90
    41:               !     rrtmg_lw_rtrnmc.f90 rrtmg_lw_rtrnmr.f90 rrtmg_lw_setcoef.f90
    42:               !     rrtmg_lw_taumol.f90 
    43:               !     rrsw_aer.f90 rrsw_cld.f90 rrsw_con.f90
    44:               !     rrsw_kg16.f90 rrsw_kg17.f90 rrsw_kg18.f90 rrsw_kg19.f90 rrsw_kg20.f90
    45:               !     rrsw_kg21.f90 rrsw_kg22.f90 rrsw_kg23.f90 rrsw_kg24.f90 rrsw_kg25.f90
    46:               !     rrsw_kg26.f90 rrsw_kg27.f90 rrsw_kg28.f90 rrsw_kg29.f90 
    47:               !     rrsw_ncpar.f90 rrsw_ref.f90 rrsw_tbl.f90 rrsw_vsn.f90 rrsw_wvn.f90
    48:               !     rrtmg_sw_cldprmc.f90 rrtmg_sw_cldprop.f90 rrtmg_sw_init.f90
    49:               !     rrtmg_sw_rad.nomcica.f90 rrtmg_sw_read_nc.f90 rrtmg_sw_reftra.f90
    50:               !     rrtmg_sw_setcoef.f90 rrtmg_sw_spcvmc.f90 rrtmg_sw_spcvrt.f90
    51:               !     rrtmg_sw_taumol.f90 rrtmg_sw_vrtqdr.f90
    52:               ! * Add a following line in rrtmg_lw_init.f90.
    53:               !     use rrtmg_lw_read_nc_wrapper
    54:               ! * Add a following line in rrtmg_sw_init.f90.
    55:               !     use rrtmg_sw_read_nc_wrapper
    56:               ! * Compile with FFLAGS=-DRRTMG
    57:               !   * Add radiation_rrtmg in LIBDIRS in src/Makefile
    58:               !   * Perform make clean.depend after configuration once
    59:               !   * Perform make depend
    60:               !   * Perform make distclean
    61:               !   * Perform configure with FFLAGS=-DRRTMG
    62:               !   * Perform make
    63:               !
    64:               !== References
    65:               !
    66:               !
    67:               !== Procedures List
    68:               !
    69:             !!$  ! RadEarthV2Flux :: 放射フラックスの計算
    70:             !!$  ! ------------          :: ------------
    71:             !!$  ! RadEarthV2Flux :: Calculate radiation flux
    72:               !
    73:               !== NAMELIST
    74:               !
    75:               ! NAMELIST#rad_rrtmg_wrapper_nml
    76:               !
    77:             
    78:               ! USE statements
    79:               !
    80:             
    81:               !
    82:               ! Kind type parameter
    83:               !
    84:               use dc_types, only: DP, &      ! Double precision.
    85:                 &                 STRING, &  ! Strings.
    86:                 &                 TOKEN      ! Keywords.
    87:             
    88:               ! メッセージ出力
    89:               ! Message output
    90:               !
    91:               use dc_message, only: MessageNotify
    92:             
    93:               !
    94:               ! Physical constants settings
    95:               !
    96:               use constants, only: Grav     ! $ g $ [m s-2].
    97:                                             !
    98:                                             ! Gravitational acceleration
    99:             
   100:               ! 格子点設定
   101:               ! Grid points settings
   102:               !
   103:               use gridset, only: imax, & ! 経度格子点数.
   104:                                          ! Number of grid points in longitude
   105:                 &                jmax, & ! 緯度格子点数.
   106:                                          ! Number of grid points in latitude
   107:                 &                kmax    ! 鉛直層数.
   108:                                          ! Number of vertical level
   109:             
   110:               implicit none
   111:             
   112:               private
   113:             
   114:               real(DP), save :: MeanMolWeight
   115:               real(DP), save :: H2OMolWeight
   116:               real(DP), save :: CO2MolWeight
   117:               real(DP), save :: N2OMolWeight
   118:               real(DP), save :: CH4MolWeight
   119:             
   120:               integer, save     :: IDCloudIceREffMethod
   121:               !
   122:               integer, parameter:: IDCloudIceREffMethodConst = 0
   123:               integer, parameter:: IDCloudIceREffMethodLin   = 1
   124:             
   125:               real(DP), save :: CloudWatREff
   126:               real(DP), save :: CloudIceREff
   127:             
   128:               real(DP), allocatable, save :: xyz_QO3(:,:,:)
   129:                                           ! O3 分布 (1)
   130:                                           ! O3 distribution (1)
   131:             
   132:             !!$  integer , save              :: SWVer
   133:             !!$  integer , save              :: LWVer
   134:             
   135:               ! 公開変数
   136:               ! Public variables
   137:               !
   138:               logical, save :: rad_rrtmg_wrapper_inited = .false.
   139:                                           ! 初期設定フラグ.
   140:                                           ! Initialization flag
   141:             
   142:               public :: RadRRTMGWrapperFlux
   143:               public :: RadRRTMGWrapperInit
   144:             
   145:             
   146:               character(*), parameter:: module_name = 'rad_rrtmg_wrapper'
   147:                                           ! モジュールの名称.
   148:                                           ! Module name
   149:               character(*), parameter:: version = &
   150:                 & '$Name:  $' // &
   151:                 & '$Id: rad_rrtmg_wrapper.F90,v 1.1 2015/01/29 12:12:48 yot Exp $'
   152:                                           ! モジュールのバージョン
   153:                                           ! Module version
   154:             
   155:               !--------------------------------------------------------------------------------------
   156:             
   157:             contains
   158:             
   159:               !--------------------------------------------------------------------------------------
   160:             
   161:               subroutine RadRRTMGWrapperFlux(               &
   162:                 & xy_SurfAlbedo,                            & ! (in)
   163:                 & xyz_Press, xyr_Press, xyz_Temp, xyr_Temp, & ! (in)
   164:                 & xyz_QH2OVap, xyz_QH2OLiq, xyz_QH2OSol,    & ! (in)
   165:                 & xyz_CloudCover,                           & ! (in)
   166:                 & xy_SurfTemp,                              & ! (in)
   167:                 & xyr_RadSUwFlux, xyr_RadSDwFlux,           & ! (out)
   168:                 & xyr_RadLUwFlux, xyr_RadLDwFlux,           & ! (out)
   169:                 & xyra_DelRadLUwFlux, xyra_DelRadLDwFlux    & ! (out)
   170:                 & )
   171:             
   172:             
   173:                 ! USE statements
   174:                 !
   175:             
   176:                 real(DP), intent(in ) :: xy_SurfAlbedo   (0:imax-1, 1:jmax)
   177:                 real(DP), intent(in ) :: xyz_Press       (0:imax-1, 1:jmax, 1:kmax)
   178:                 real(DP), intent(in ) :: xyr_Press       (0:imax-1, 1:jmax, 0:kmax)
   179:                 real(DP), intent(in ) :: xyz_Temp        (0:imax-1, 1:jmax, 1:kmax)
   180:                 real(DP), intent(in ) :: xyr_Temp        (0:imax-1, 1:jmax, 0:kmax)
   181:                 real(DP), intent(in ) :: xyz_QH2OVap     (0:imax-1, 1:jmax, 1:kmax)
   182:                                           ! $ q $ .   混合比. Mass mixing ratio of constituents (1)
   183:                 real(DP), intent(in ) :: xyz_QH2OLiq     (0:imax-1, 1:jmax, 1:kmax)
   184:                 real(DP), intent(in ) :: xyz_QH2OSol     (0:imax-1, 1:jmax, 1:kmax)
   185:                 real(DP), intent(in ) :: xyz_CloudCover  (0:imax-1, 1:jmax, 1:kmax)
   186:                 real(DP), intent(in ) :: xy_SurfTemp     (0:imax-1, 1:jmax)
   187:                 real(DP), intent(out) :: xyr_RadSUwFlux   (0:imax-1, 1:jmax, 0:kmax)
   188:                 real(DP), intent(out) :: xyr_RadSDwFlux   (0:imax-1, 1:jmax, 0:kmax)
   189:                 real(DP), intent(out) :: xyr_RadLUwFlux    (0:imax-1, 1:jmax, 0:kmax)
   190:                 real(DP), intent(out) :: xyr_RadLDwFlux    (0:imax-1, 1:jmax, 0:kmax)
   191:                 real(DP), intent(out) :: xyra_DelRadLUwFlux(0:imax-1, 1:jmax, 0:kmax, 0:1)
   192:                 real(DP), intent(out) :: xyra_DelRadLDwFlux(0:imax-1, 1:jmax, 0:kmax, 0:1)
   193:             
   194:             !!$    real(DP):: xyr_RadLUwFlux    (0:imax-1, 1:jmax, 0:kmax)
   195:             !!$    real(DP):: xyr_RadLDwFlux    (0:imax-1, 1:jmax, 0:kmax)
   196:             !!$    real(DP):: xyra_DelRadLUwFlux(0:imax-1, 1:jmax, 0:kmax, 0:1)
   197:             !!$    real(DP):: xyra_DelRadLDwFlux(0:imax-1, 1:jmax, 0:kmax, 0:1)
   198:             
   199:             
   200:                 ! Work variables
   201:                 !
   202:                 real(DP) :: xyz_DelAtmMass   (0:imax-1, 1:jmax, 1:kmax)
   203:             
   204:                 integer  :: k
   205:             
   206:             
   207:                 ! 初期化確認
   208:                 ! Initialization check
   209:                 !
   210:                 if ( .not. rad_rrtmg_wrapper_inited ) then
   211:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   212:                 end if
   213:             
   214:             
   215:                 call MessageNotify( 'E', module_name, 'RRTMG modules are not included in compilation.' )
   216:             
   217:             
   218: W------>        do k = 1, kmax
   219: |**==== A         xyz_DelAtmMass(:,:,k) = ( xyr_Press(:,:,k-1) - xyr_Press(:,:,k ) ) / Grav
   220: W------         end do
   221:             
   222:                 call RadRRTMGWrapperFluxCore(                          &
   223:                   & xy_SurfAlbedo,                                     &
   224:                   & xyz_DelAtmMass, &
   225:                   & xyz_Press, xyr_Press, &
   226:                   & xyz_Temp, xyr_Temp, &
   227:                   & xyz_QH2OVap, xyz_QH2OLiq, xyz_QH2OSol, &
   228:                   & xyz_CloudCover,                                    &
   229:                   & xy_SurfTemp,                                       &
   230:                   & xyr_RadSUwFlux, xyr_RadSDwFlux,                    &
   231:                   & xyr_RadLUwFlux, xyr_RadLDwFlux,                          & ! (out)
   232:                   & xyra_DelRadLUwFlux, xyra_DelRadLDwFlux                   & ! (out)
   233:                   & )
   234:             
   235:             
   236:               end subroutine RadRRTMGWrapperFlux
   237:             
   238:               !--------------------------------------------------------------------------------------
   239:             !!$
   240:             !!$  subroutine RadEarthV2FluxforNHM(                                          &
   241:             !!$    & r_Height, xy_SurfAlbedo,                                              &
   242:             !!$    & xyz_Dens, xyz_Press, xyz_Temp, xyz_QH2OVap, xyz_QH2OLiq, xyz_QH2OSol, &
   243:             !!$    & xy_SurfTemp,                                                          &
   244:             !!$    & xyr_RadSFlux, xyr_RadLFlux, xyra_DelRadLFlux                          &
   245:             !!$    & )
   246:             !!$
   247:             !!$
   248:             !!$    ! USE statements
   249:             !!$    !
   250:             !!$
   251:             !!$    real(DP), intent(in ) :: r_Height                          (0:kmax)
   252:             !!$    real(DP), intent(in ) :: xy_SurfAlbedo   (0:imax-1, 1:jmax)
   253:             !!$    real(DP), intent(in ) :: xyz_Dens        (0:imax-1, 1:jmax, 1:kmax)
   254:             !!$    real(DP), intent(in ) :: xyz_Press       (0:imax-1, 1:jmax, 1:kmax)
   255:             !!$    real(DP), intent(in ) :: xyz_Temp        (0:imax-1, 1:jmax, 1:kmax)
   256:             !!$    real(DP), intent(in ) :: xyz_QH2OVap     (0:imax-1, 1:jmax, 1:kmax)
   257:             !!$                              ! $ q $ .   混合比. Mass mixing ratio of constituents (1)
   258:             !!$    real(DP), intent(in ) :: xyz_QH2OLiq     (0:imax-1, 1:jmax, 1:kmax)
   259:             !!$    real(DP), intent(in ) :: xyz_QH2OSol     (0:imax-1, 1:jmax, 1:kmax)
   260:             !!$    real(DP), intent(in ) :: xy_SurfTemp     (0:imax-1, 1:jmax)
   261:             !!$    real(DP), intent(out) :: xyr_RadSFlux    (0:imax-1, 1:jmax, 0:kmax)
   262:             !!$    real(DP), intent(out) :: xyr_RadLFlux    (0:imax-1, 1:jmax, 0:kmax)
   263:             !!$    real(DP), intent(out) :: xyra_DelRadLFlux(0:imax-1, 1:jmax, 0:kmax, 0:1)
   264:             !!$
   265:             !!$
   266:             !!$    ! Work variables
   267:             !!$    !
   268:             !!$    real(DP) :: xyz_DelAtmMass   (0:imax-1, 1:jmax, 1:kmax)
   269:             !!$
   270:             !!$    integer  :: k
   271:             !!$
   272:             !!$
   273:             !!$    ! 初期化確認
   274:             !!$    ! Initialization check
   275:             !!$    !
   276:             !!$    if ( .not. rad_Earth_V2_inited ) then
   277:             !!$      call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   278:             !!$    end if
   279:             !!$
   280:             !!$
   281:             !!$    do k = 1, kmax
   282:             !!$      xyz_DelAtmMass(:,:,k) = xyz_Dens(:,:,k) * ( r_Height(k) - r_Height(k-1) )
   283:             !!$    end do
   284:             !!$
   285:             !!$    call RadEarthV2FluxCore(                                                        &
   286:             !!$      & xy_SurfAlbedo,                                                              &
   287:             !!$      & xyz_DelAtmMass, xyz_Press, xyz_Temp, xyz_QH2OVap, xyz_QH2OLiq, xyz_QH2OSol, &
   288:             !!$      & xy_SurfTemp,                                                                &
   289:             !!$      & xyr_RadSFlux, xyr_RadLFlux, xyra_DelRadLFlux                                &
   290:             !!$      & )
   291:             !!$
   292:             !!$
   293:             !!$  end subroutine RadEarthV2FluxforNHM
   294:             !!$
   295:               !--------------------------------------------------------------------------------------
   296:             !!$
   297:             !!$  subroutine RadDcpamEV2FluxforNHM2DWrapper(                    &
   298:             !!$    & r_Height, x_SurfAlbedo,                                   &
   299:             !!$    & xz_Dens, xz_Press, xz_Temp, xz_QH2OVap, xz_QH2OLiq,       &
   300:             !!$    & x_SurfTemp,                                               &
   301:             !!$    & xr_RadSFlux, xr_RadLFlux, xra_DelRadLFlux                 &
   302:             !!$    & )
   303:             !!$
   304:             !!$
   305:             !!$    ! USE statements
   306:             !!$    !
   307:             !!$
   308:             !!$
   309:             !!$    real(DP), intent(in ) :: r_Height                 (0:kmax)
   310:             !!$    real(DP), intent(in ) :: x_SurfAlbedo   (0:imax-1)
   311:             !!$    real(DP), intent(in ) :: xz_Dens        (0:imax-1, 1:kmax)
   312:             !!$    real(DP), intent(in ) :: xz_Press       (0:imax-1, 1:kmax)
   313:             !!$    real(DP), intent(in ) :: xz_Temp        (0:imax-1, 1:kmax)
   314:             !!$    real(DP), intent(in ) :: xz_QH2OVap     (0:imax-1, 1:kmax)
   315:             !!$    real(DP), intent(in ) :: xz_QH2OLiq     (0:imax-1, 1:kmax)
   316:             !!$    real(DP), intent(in ) :: x_SurfTemp     (0:imax-1)
   317:             !!$    real(DP), intent(out) :: xr_RadSFlux    (0:imax-1, 0:kmax)
   318:             !!$    real(DP), intent(out) :: xr_RadLFlux    (0:imax-1, 0:kmax)
   319:             !!$    real(DP), intent(out) :: xra_DelRadLFlux(0:imax-1, 0:kmax, 0:1)
   320:             !!$
   321:             !!$
   322:             !!$    ! Work variables
   323:             !!$    !
   324:             !!$    real(DP) :: xy_SurfAlbedo   (0:imax-1, 1:jmax)
   325:             !!$    real(DP) :: xyz_Dens        (0:imax-1, 1:jmax, 1:kmax)
   326:             !!$    real(DP) :: xyz_Press       (0:imax-1, 1:jmax, 1:kmax)
   327:             !!$    real(DP) :: xyz_Temp        (0:imax-1, 1:jmax, 1:kmax)
   328:             !!$    real(DP) :: xyz_QH2OVap     (0:imax-1, 1:jmax, 1:kmax)
   329:             !!$    real(DP) :: xyz_QH2OLiq     (0:imax-1, 1:jmax, 1:kmax)
   330:             !!$    real(DP) :: xy_SurfTemp     (0:imax-1, 1:jmax)
   331:             !!$    real(DP) :: xyr_RadSFlux    (0:imax-1, 1:jmax, 0:kmax)
   332:             !!$    real(DP) :: xyr_RadLFlux    (0:imax-1, 1:jmax, 0:kmax)
   333:             !!$    real(DP) :: xyra_DelRadLFlux(0:imax-1, 1:jmax, 0:kmax, 0:1)
   334:             !!$
   335:             !!$    integer  :: k
   336:             !!$
   337:             !!$
   338:             !!$    ! 初期化確認
   339:             !!$    ! Initialization check
   340:             !!$    !
   341:             !!$    if ( .not. rad_dcpam_E_V2_inited ) then
   342:             !!$      call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   343:             !!$    end if
   344:             !!$
   345:             !!$
   346:             !!$    if ( jmax /= 1 ) then
   347:             !!$      call MessageNotify( 'E', module_name, 'jmax must be 1.' )
   348:             !!$    end if
   349:             !!$
   350:             !!$
   351:             !!$    xy_SurfAlbedo   (:, 1)       = x_SurfAlbedo   (:)
   352:             !!$    do k = 1, kmax
   353:             !!$      xyz_Dens        (:, 1, k)    = xz_Dens        (:, k)
   354:             !!$      xyz_Press       (:, 1, k)    = xz_Press       (:, k)
   355:             !!$      xyz_Temp        (:, 1, k)    = xz_Temp        (:, k)
   356:             !!$      xyz_QH2OVap     (:, 1, k)    = xz_QH2OVap     (:, k)
   357:             !!$      xyz_QH2OLiq     (:, 1, k)    = xz_QH2OLiq     (:, k)
   358:             !!$    end do
   359:             !!$    xy_SurfTemp     (:, 1)       = x_SurfTemp     (:)
   360:             !!$
   361:             !!$    call RadDcpamEV2FluxforNHM(                                       &
   362:             !!$      & r_Height, xy_SurfAlbedo,                                      &
   363:             !!$      & xyz_Dens, xyz_Press, xyz_Temp, xyz_QH2OVap, xyz_QH2OLiq,      &
   364:             !!$      & xy_SurfTemp,                                                  &
   365:             !!$      & xyr_RadSFlux, xyr_RadLFlux, xyra_DelRadLFlux                  &
   366:             !!$      & )
   367:             !!$
   368:             !!$    xr_RadSFlux    (:, :)    = xyr_RadSFlux    (:, 1, :)
   369:             !!$    xr_RadLFlux    (:, :)    = xyr_RadLFlux    (:, 1, :)
   370:             !!$    xra_DelRadLFlux(:, :, :) = xyra_DelRadLFlux(:, 1, :, :)
   371:             !!$
   372:             !!$
   373:             !!$  end subroutine RadDcpamEV2FluxforNHM2DWrapper
   374:             !!$
   375:               !--------------------------------------------------------------------------------------
   376:             !!$
   377:             !!$  subroutine RadDcpamEV2Flux2DWrapper(                         &
   378:             !!$    & x_SurfAlbedo,                                            &
   379:             !!$    & xz_Press, xr_Press, xz_Temp, xz_QH2OVap, xz_QH2OLiq,     &
   380:             !!$    & x_SurfTemp,                                              &
   381:             !!$    & xr_RadSFlux, xr_RadLFlux, xra_DelRadLFlux                &
   382:             !!$    & )
   383:             !!$
   384:             !!$
   385:             !!$    ! USE statements
   386:             !!$    !
   387:             !!$
   388:             !!$
   389:             !!$
   390:             !!$    real(DP), intent(in ) :: x_SurfAlbedo   (0:imax-1)
   391:             !!$    real(DP), intent(in ) :: xz_Press       (0:imax-1, 1:kmax)
   392:             !!$    real(DP), intent(in ) :: xr_Press       (0:imax-1, 0:kmax)
   393:             !!$    real(DP), intent(in ) :: xz_Temp        (0:imax-1, 1:kmax)
   394:             !!$    real(DP), intent(in ) :: xz_QH2OVap     (0:imax-1, 1:kmax)
   395:             !!$    real(DP), intent(in ) :: xz_QH2OLiq     (0:imax-1, 1:kmax)
   396:             !!$    real(DP), intent(in ) :: x_SurfTemp     (0:imax-1)
   397:             !!$    real(DP), intent(out) :: xr_RadSFlux    (0:imax-1, 0:kmax)
   398:             !!$    real(DP), intent(out) :: xr_RadLFlux    (0:imax-1, 0:kmax)
   399:             !!$    real(DP), intent(out) :: xra_DelRadLFlux(0:imax-1, 0:kmax, 0:1)
   400:             !!$
   401:             !!$
   402:             !!$    ! Work variables
   403:             !!$    !
   404:             !!$    real(DP) :: xy_SurfAlbedo   (0:imax-1, 1:jmax)
   405:             !!$    real(DP) :: xyz_Press       (0:imax-1, 1:jmax, 1:kmax)
   406:             !!$    real(DP) :: xyr_Press       (0:imax-1, 1:jmax, 0:kmax)
   407:             !!$    real(DP) :: xyz_Temp        (0:imax-1, 1:jmax, 1:kmax)
   408:             !!$    real(DP) :: xyz_QH2OVap     (0:imax-1, 1:jmax, 1:kmax)
   409:             !!$    real(DP) :: xyz_QH2OLiq     (0:imax-1, 1:jmax, 1:kmax)
   410:             !!$    real(DP) :: xy_SurfTemp     (0:imax-1, 1:jmax)
   411:             !!$    real(DP) :: xyr_RadSFlux    (0:imax-1, 1:jmax, 0:kmax)
   412:             !!$    real(DP) :: xyr_RadLFlux    (0:imax-1, 1:jmax, 0:kmax)
   413:             !!$    real(DP) :: xyra_DelRadLFlux(0:imax-1, 1:jmax, 0:kmax, 0:1)
   414:             !!$
   415:             !!$
   416:             !!$    ! 初期化確認
   417:             !!$    ! Initialization check
   418:             !!$    !
   419:             !!$    if ( .not. rad_dcpam_E_V2_inited ) then
   420:             !!$      call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   421:             !!$    end if
   422:             !!$
   423:             !!$
   424:             !!$    if ( jmax /= 1 ) then
   425:             !!$      call MessageNotify( 'E', module_name, 'jmax must be 1.' )
   426:             !!$    end if
   427:             !!$
   428:             !!$
   429:             !!$    xy_SurfAlbedo   (:, 1)       = x_SurfAlbedo   (:)
   430:             !!$    xyz_Press       (:, 1, :)    = xz_Press       (:, :)
   431:             !!$    xyr_Press       (:, 1, :)    = xr_Press       (:, :)
   432:             !!$    xyz_Temp        (:, 1, :)    = xz_Temp        (:, :)
   433:             !!$    xyz_QH2OVap     (:, 1, :)    = xz_QH2OVap     (:, :)
   434:             !!$    xyz_QH2OLiq     (:, 1, :)    = xz_QH2OLiq     (:, :)
   435:             !!$    xy_SurfTemp     (:, 1)       = x_SurfTemp     (:)
   436:             !!$
   437:             !!$    call RadDcpamEV2Flux(                                             &
   438:             !!$      & xy_SurfAlbedo,                                                &
   439:             !!$      & xyz_Press, xyr_Press, xyz_Temp, xyz_QH2OVap, xyz_QH2OLiq,     &
   440:             !!$      & xy_SurfTemp,                                                  &
   441:             !!$      & xyr_RadSFlux, xyr_RadLFlux, xyra_DelRadLFlux                  &
   442:             !!$      & )
   443:             !!$
   444:             !!$    xr_RadSFlux    (:, :)    = xyr_RadSFlux    (:, 1, :)
   445:             !!$    xr_RadLFlux    (:, :)    = xyr_RadLFlux    (:, 1, :)
   446:             !!$    xra_DelRadLFlux(:, :, :) = xyra_DelRadLFlux(:, 1, :, :)
   447:             !!$
   448:             !!$
   449:             !!$  end subroutine RadDcpamEV2Flux2DWrapper
   450:             !!$
   451:               !--------------------------------------------------------------------------------------
   452:             
   453:               subroutine RadRRTMGWrapperFluxCore(                          &
   454:                 & xy_SurfAlbedo,                                           &
   455:                 & xyz_DelAtmMass,                                          &
   456:                 & xyz_Press, xyr_Press, xyz_Temp, xyr_Temp,                &
   457:                 & xyz_QH2OVap, xyz_QH2OLiq, xyz_QH2OSol,                   &
   458:                 & xyz_CloudCover,                                          &
   459:                 & xy_SurfTemp,                                             &
   460:                 & xyr_RadSUwFlux, xyr_RadSDwFlux,                          &
   461:                 & xyr_RadLUwFlux, xyr_RadLDwFlux,                          & ! (out)
   462:                 & xyra_DelRadLUwFlux, xyra_DelRadLDwFlux                   & ! (out)
   463:                 & )
   464:             
   465:             
   466:                 ! USE statements
   467:                 !
   468:             
   469:                 ! ヒストリデータ出力
   470:                 ! History data output
   471:                 !
   472:                 use gtool_historyauto, only: HistoryAutoPut
   473:             
   474:                 ! 時刻管理
   475:                 ! Time control
   476:                 !
   477:                 use timeset, only: &
   478:                   & TimeN                 ! ステップ $ t $ の時刻.
   479:                                           ! Time of step $ t $.
   480:             
   481:                 ! 全球一定体積混合比の設定
   482:                 ! Set globally constant volume mixing ratio
   483:                 !
   484:                 use set_gcmr, only : SetGCMR
   485:             
   486:                 ! O3 分布の設定
   487:                 ! Set O3 distribution
   488:                 !
   489:                 use set_o3, only: SetO3
   490:             
   491:             !!$    ! 地球大気向け短波放射モデル Ver. 2.6
   492:             !!$    ! short wave radiation model for the Earth's atmosphere Ver. 2.6
   493:             !!$    !
   494:             !!$    use rad_Earth_SW_V2_6, only: RadEarthSWV26Flux
   495:             !!$
   496:             !!$    ! 地球大気向け長波放射モデル Ver. 2.4
   497:             !!$    ! long wave radiation model for the Earth's atmosphere Ver. 2.4
   498:             !!$    !
   499:             !!$    use rad_Earth_LW_V2_4, only : RadEarthLWV24Flux
   500:             
   501:             
   502:             
   503:                 ! 太陽放射フラックスの設定
   504:                 ! Set solar constant
   505:                 !
   506:                 use set_solarconst, only : SetSolarConst
   507:             
   508:                 ! 短波入射 (太陽入射)
   509:                 ! Short wave (insolation) incoming
   510:                 !
   511:                 use rad_short_income, only : RadShortIncome
   512:             
   513:             
   514:                 real(DP), intent(in ) :: xy_SurfAlbedo   (0:imax-1, 1:jmax)
   515:                 real(DP), intent(in ) :: xyz_DelAtmMass  (0:imax-1, 1:jmax, 1:kmax)
   516:                 real(DP), intent(in ) :: xyz_Press       (0:imax-1, 1:jmax, 1:kmax)
   517:                 real(DP), intent(in ) :: xyr_Press       (0:imax-1, 1:jmax, 0:kmax)
   518:                 real(DP), intent(in ) :: xyz_Temp        (0:imax-1, 1:jmax, 1:kmax)
   519:                 real(DP), intent(in ) :: xyr_Temp        (0:imax-1, 1:jmax, 0:kmax)
   520:                 real(DP), intent(in ) :: xyz_QH2OVap     (0:imax-1, 1:jmax, 1:kmax)
   521:                                           ! $ q $ .   混合比. Mass mixing ratio of constituents (1)
   522:                 real(DP), intent(in ) :: xyz_QH2OLiq     (0:imax-1, 1:jmax, 1:kmax)
   523:                 real(DP), intent(in ) :: xyz_QH2OSol     (0:imax-1, 1:jmax, 1:kmax)
   524:                 real(DP), intent(in ) :: xyz_CloudCover  (0:imax-1, 1:jmax, 1:kmax)
   525:                 real(DP), intent(in ) :: xy_SurfTemp     (0:imax-1, 1:jmax)
   526:                 real(DP), intent(out) :: xyr_RadSUwFlux    (0:imax-1, 1:jmax, 0:kmax)
   527:                 real(DP), intent(out) :: xyr_RadSDwFlux    (0:imax-1, 1:jmax, 0:kmax)
   528:                 real(DP), intent(out) :: xyr_RadLUwFlux    (0:imax-1, 1:jmax, 0:kmax)
   529:                 real(DP), intent(out) :: xyr_RadLDwFlux    (0:imax-1, 1:jmax, 0:kmax)
   530:                 real(DP), intent(out) :: xyra_DelRadLUwFlux(0:imax-1, 1:jmax, 0:kmax, 0:1)
   531:                 real(DP), intent(out) :: xyra_DelRadLDwFlux(0:imax-1, 1:jmax, 0:kmax, 0:1)
   532:             
   533:             
   534:             
   535:             
   536:               end subroutine RadRRTMGWrapperFluxCore
   537:             
   538:               !--------------------------------------------------------------------------------------
   539:             
   540:               subroutine RadRRTMGWrapperInit(    &
   541:                 & FlagSnow                  &
   542:                 & )
   543:             
   544:                 ! ファイル入出力補助
   545:                 ! File I/O support
   546:                 !
   547:                 use dc_iounit, only: FileOpen
   548:             
   549:                 ! ヒストリデータ出力
   550:                 ! History data output
   551:                 !
   552:                 use gtool_historyauto, only: HistoryAutoAddVariable
   553:             
   554:                 ! NAMELIST ファイル入力に関するユーティリティ
   555:                 ! Utilities for NAMELIST file input
   556:                 !
   557:                 use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid
   558:             
   559:                 ! 全球一定体積混合比の設定
   560:                 ! Set globally constant volume mixing ratio
   561:                 !
   562:                 use set_gcmr, only : SetGCMRInit
   563:             
   564:                 ! O3 分布の設定
   565:                 ! Set O3 distribution
   566:                 !
   567:                 use set_o3, only : SetO3Init
   568:             
   569:                 !
   570:                 ! Physical constants settings
   571:                 !
   572:                 use constants, only: &
   573:                   & CpDry
   574:                                         ! $ C_p $ [J kg-1 K-1].
   575:                                         ! 乾燥大気の定圧比熱.
   576:                                         ! Specific heat of air at constant pressure
   577:             
   578:             !!$    ! 地球大気向け短波放射モデル Ver. 2.6
   579:             !!$    ! short wave radiation model for the Earth's atmosphere Ver. 2.6
   580:             !!$    !
   581:             !!$    use rad_Earth_SW_V2_6, only: RadEarthSWV26Init
   582:             !!$
   583:             !!$    ! 地球大気向け長波放射モデル Ver. 2.4
   584:             !!$    ! long wave radiation model for the Earth's atmosphere Ver. 2.4
   585:             !!$    !
   586:             !!$    use rad_Earth_LW_V2_4, only : RadEarthLWV24Init
   587:             
   588:             
   589:             
   590:                 ! 太陽放射フラックスの設定
   591:                 ! Set solar constant
   592:                 !
   593:                 use set_solarconst, only : SetSolarConstInit
   594:             
   595:                 ! 短波入射 (太陽入射)
   596:                 ! Short wave (insolation) incoming
   597:                 !
   598:                 use rad_short_income, only : RadShortIncomeInit
   599:             
   600:                 ! 座標データ設定
   601:                 ! Axes data settings
   602:                 !
   603:                 use axesset, only : AxnameX, AxnameY, AxnameZ, AxnameR, AxnameT
   604:             
   605:                 ! 宣言文 ; Declaration statements
   606:                 !
   607:             
   608:                 logical, intent(in) :: FlagSnow
   609:             
   610:                 character(STRING)   :: CloudIceREffMethod
   611:             
   612:                 integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号.
   613:                                           ! Unit number for NAMELIST file open
   614:                 integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT.
   615:                                           ! IOSTAT of NAMELIST read
   616:             
   617:                 ! NAMELIST 変数群
   618:                 ! NAMELIST group name
   619:                 !
   620:                 namelist /rad_rrtmg_wrapper_nml/ &
   621:                   & CloudIceREffMethod,     &
   622:                   & CloudWatREff,           &
   623:                   & CloudIceREff
   624:             
   625:             !!$      & SWVer, LWVer
   626:                       !
   627:                       ! デフォルト値については初期化手続 "rad_rrtmg_wrapper#RadEarthV2Init"
   628:                       ! のソースコードを参照のこと.
   629:                       !
   630:                       ! Refer to source codes in the initialization procedure
   631:                       ! "rad_rrtmg_wrapper#RadEarthV2Init" for the default values.
   632:                       !
   633:             
   634:                 if ( rad_rrtmg_wrapper_inited ) return
   635:             
   636:             
   637:                 ! Molecular weights of atmosphere, CO2, H2O, N2O, CH4
   638:                 !
   639:                 MeanMolWeight = 28.0d-3
   640:                 CO2MolWeight  = 44.0d-3
   641:                 H2OMolWeight  = 18.0d-3
   642:                 N2OMolWeight  = 44.0d-3
   643:                 CH4MolWeight  = 16.0d-3
   644:             
   645:             
   646:                 ! デフォルト値の設定
   647:                 ! Default values settings
   648:                 !
   649:                 CloudIceREffMethod = 'Const'
   650:             !!$    CloudIceREffMethod = 'Lin'
   651:             
   652:                 CloudWatREff    = 10.0d-6
   653:                 CloudIceREff    = 50.0d-6
   654:             
   655:             
   656:             !!$    SWVer = 1
   657:             !!$    LWVer = 3
   658:             
   659:             
   660:                 ! NAMELIST の読み込み
   661:                 ! NAMELIST is input
   662:                 !
   663:                 if ( trim(namelist_filename) /= '' ) then
   664:                   call FileOpen( unit_nml, &          ! (out)
   665:                     & namelist_filename, mode = 'r' ) ! (in)
   666:             
   667:                   rewind( unit_nml )
   668:                   read( unit_nml,                     & ! (in)
   669:                     & nml = rad_rrtmg_wrapper_nml,         & ! (out)
   670:                     & iostat = iostat_nml )             ! (out)
   671:                   close( unit_nml )
   672:             
   673:                   call NmlutilMsg( iostat_nml, module_name ) ! (in)
   674:                 end if
   675:             
   676:             
   677:                 ! Identification of calculation method of cloud particle effective radius
   678:                 !
   679:                 call MessageNotify( 'M', module_name, &
   680:                   & 'CloudIceREffMethod=<%c>.', &
   681:                   & c1 = trim(CloudIceREffMethod) )
   682:                 !
   683:                 select case ( CloudIceREffMethod )
   684:                 case ( 'Const' )
   685:                   IDCloudIceREffMethod = IDCloudIceREffMethodConst
   686:                 case ( 'Lin' )
   687:                   IDCloudIceREffMethod = IDCloudIceREffMethodLin
   688:                 case default
   689:                   call MessageNotify( 'E', module_name, &
   690:                     & 'CloudIceREffMethod=<%c> is not supported.', &
   691:                     & c1 = trim(CloudIceREffMethod) )
   692:                 end select
   693:             
   694:             
   695:                 ! Allocate a local variable for O3 distribution
   696:                 !
   697:                 allocate( xyz_QO3(0:imax-1, 1:jmax, 1:kmax) )
   698:             
   699:             
   700:                 ! Initialization of modules used in this module
   701:                 !
   702:             
   703:                 ! 全球一定体積混合比の設定
   704:                 ! Set globally constant volume mixing ratio
   705:                 !
   706:                 call SetGCMRInit
   707:             
   708:                 ! O3 分布の設定
   709:                 ! Set O3 distribution
   710:                 !
   711:                 call SetO3Init
   712:             
   713:             
   714:             !!$    ! 地球大気向け短波放射モデル Ver. 2.6
   715:             !!$    ! short wave radiation model for the Earth's atmosphere Ver. 2.6
   716:             !!$    !
   717:             !!$    call RadEarthSWV26Init( &
   718:             !!$      & FlagSnow &
   719:             !!$      & )
   720:             !!$
   721:             !!$    ! 地球大気向け長波放射モデル Ver. 2.4
   722:             !!$    ! long wave radiation model for the Earth's atmosphere Ver. 2.4
   723:             !!$    !
   724:             !!$    call RadEarthLWV24Init( &
   725:             !!$      & FlagSnow            &
   726:             !!$      & )
   727:             
   728:             
   729:             
   730:             
   731:                 ! 太陽放射フラックスの設定
   732:                 ! Set solar constant
   733:                 !
   734:                 call SetSolarConstInit
   735:             
   736:                 ! 短波入射 (太陽入射)
   737:                 ! Short wave (insolation) incoming
   738:                 !
   739:                 call RadShortIncomeInit
   740:             
   741:             
   742:                 ! ヒストリデータ出力のためのへの変数登録
   743:                 ! Register of variables for history data output
   744:                 !
   745:                 call HistoryAutoAddVariable( 'CloudCoverforRad', &
   746:                   & (/ AxnameX, AxnameY, AxnameZ, AxnameT /), &
   747:                   & 'cloud cover', '1' )
   748:                 call HistoryAutoAddVariable( 'CloudCoverRand', &
   749:                   & (/ AxnameX, AxnameY, AxnameT /), &
   750:                   & 'cloud cover', '1' )
   751:             
   752:                 call HistoryAutoAddVariable( 'RadCSLUWFLXB', &
   753:                   & (/ AxnameX, AxnameY, AxnameR, AxnameT /), &
   754:                   & 'clear sky upward longwave flux', 'W m-2' )
   755:                 call HistoryAutoAddVariable( 'RadCSLDWFLXB', &
   756:                   & (/ AxnameX, AxnameY, AxnameR, AxnameT /), &
   757:                   & 'clear sky downward longwave flux', 'W m-2' )
   758:                 call HistoryAutoAddVariable( 'RadCSSUWFLXB', &
   759:                   & (/ AxnameX, AxnameY, AxnameR, AxnameT /), &
   760:                   & 'clear sky upward shortwave flux', 'W m-2' )
   761:                 call HistoryAutoAddVariable( 'RadCSSDWFLXB', &
   762:                   & (/ AxnameX, AxnameY, AxnameR, AxnameT /), &
   763:                   & 'clear sky downward shortwave flux', 'W m-2' )
   764:             
   765:                 ! 印字 ; Print
   766:                 !
   767:                 call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   768:                 call MessageNotify( 'M', module_name, '  CloudWatREff      = %f', &
   769:                   & d = (/ CloudWatREff /) )
   770:                 call MessageNotify( 'M', module_name, '  CloudIceREff      = %f', &
   771:                   & d = (/ CloudIceREff /) )
   772:             !!$    call MessageNotify( 'M', module_name, 'SWVer = %d', i = (/ SWVer /) )
   773:             !!$    call MessageNotify( 'M', module_name, 'LWVer = %d', i = (/ LWVer /) )
   774:                 call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   775:             
   776:             
   777:                 rad_rrtmg_wrapper_inited = .true.
   778:             
   779:               end subroutine RadRRTMGWrapperInit
   780:             
   781:               !--------------------------------------------------------------------------------------
   782:             
   783:             end module rad_rrtmg_wrapper
