Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:54 2016
FILE NAME: lscond.f90
PROGRAM NAME: lscond
DIAGNOSTIC LIST

  LINE  LEVEL( NO.): DIAGNOSTIC MESSAGE

   263  opt  (  11): Fused array assignments. :line 263 - 274
   263  vec  (   4): Vectorized array expression.
   263  vec  (  29): ADB is used for array.: xyz_qvapsat
   263  vec  (  29): ADB is used for array.: xyz_temp
   263  vec  (  29): ADB is used for array.: xyz_qvap
   277  opt  (1592): Outer loop unrolled inside inner loop.
   278  vec  (   1): Vectorized loop.
   278  vec  (  29): ADB is used for array.: xyz_qvapsat
   278  vec  (  29): ADB is used for array.: xyz_qvap
   278  vec  (   1): Vectorized loop.
   278  vec  (  29): ADB is used for array.: xyz_qvapsat
   278  vec  (  29): ADB is used for array.: xyz_qvap
   298  opt  (1017): Subroutine call prevents optimization.
   303  opt  (1592): Outer loop unrolled inside inner loop.
   304  vec  (   1): Vectorized loop.
   304  vec  (  29): ADB is used for array.: xyz_temp
   304  vec  (  29): ADB is used for array.: xyz_qvap
   304  vec  (  29): ADB is used for array.: xyz_dqvapsatdtemp
   304  vec  (  29): ADB is used for array.: xyz_qvapsat
   304  vec  (   1): Vectorized loop.
   304  vec  (  29): ADB is used for array.: xyz_temp
   304  vec  (  29): ADB is used for array.: xyz_qvap
   304  vec  (  29): ADB is used for array.: xyz_dqvapsatdtemp
   304  vec  (  29): ADB is used for array.: xyz_qvapsat
   361  opt  (  11): Fused array assignments. :line 361 - 364
   361  opt  (1593): Loop nest collapsed into one loop.
   361  vec  (   4): Vectorized array expression.
   361  vec  (  29): ADB is used for array.: xyz_dqh2oliqdt
   361  vec  (  29): ADB is used for array.: xyz_dtempdtlsc
   361  vec  (  29): ADB is used for array.: xyz_temp
   361  vec  (  29): ADB is used for array.: xyz_dqvapdtlsc
   361  vec  (  29): ADB is used for array.: xyz_qvap
   368  opt  (1593): Loop nest collapsed into one loop.
   368  vec  (   4): Vectorized array expression.
   369  vec  (   3): Unvectorized loop.
   369  vec  (  13): Overhead of loop division is too large.
   370  opt  (1593): Loop nest collapsed into one loop.
   370  vec  (   4): Vectorized array expression.
   370  vec  (  29): ADB is used for array.: xy_rainlsc
   370  vec  (  29): ADB is used for array.: xyr_press
   370  vec  (  29): ADB is used for array.: xyz_dqh2oliqdt
   396  warn (  82): Name "tempbefadj" is not used.
   396  warn (  82): Name "qvapbefadj" is not used.
   396  warn (  82): Name "xyz_rainlsc" is not used.
   532  vec  (   1): Vectorized loop.
   532  vec  (  29): ADB is used for array.: z_press
   532  vec  (  29): ADB is used for array.: xyz_press
   532  vec  (  29): ADB is used for array.: z_qh2osol
   532  vec  (  29): ADB is used for array.: xyz_qh2osol
   532  vec  (  29): ADB is used for array.: z_qh2oliq
   532  vec  (  29): ADB is used for array.: xyz_qh2oliq
   532  vec  (  29): ADB is used for array.: z_qvap
   532  vec  (  29): ADB is used for array.: xyz_qvap
   532  vec  (  29): ADB is used for array.: z_temp
   532  vec  (  29): ADB is used for array.: xyz_temp
   539  vec  (   1): Vectorized loop.
   539  vec  (  29): ADB is used for array.: r_press
   539  vec  (  29): ADB is used for array.: xyr_press
   543  opt  (1017): Subroutine call prevents optimization.
   549  vec  (   1): Vectorized loop.
   549  vec  (  29): ADB is used for array.: xyz_dqh2osoldt
   549  vec  (  29): ADB is used for array.: z_dqh2osoldt
   549  vec  (  29): ADB is used for array.: xyz_dqh2oliqdt
   549  vec  (  29): ADB is used for array.: z_dqh2oliqdt
   549  vec  (  29): ADB is used for array.: xyz_qh2osol
   549  vec  (  29): ADB is used for array.: z_qh2osol
   549  vec  (  29): ADB is used for array.: xyz_qh2oliq
   549  vec  (  29): ADB is used for array.: z_qh2oliq
   549  vec  (  29): ADB is used for array.: xyz_qvap
   549  vec  (  29): ADB is used for array.: z_qvap
   549  vec  (  29): ADB is used for array.: xyz_temp
   549  vec  (  29): ADB is used for array.: z_temp
   563  opt  (1593): Loop nest collapsed into one loop.
   563  vec  (   4): Vectorized array expression.
   564  vec  (   3): Unvectorized loop.
   564  vec  (  13): Overhead of loop division is too large.
   565  opt  (1593): Loop nest collapsed into one loop.
   565  vec  (   4): Vectorized array expression.
   565  vec  (  29): ADB is used for array.: xy_rainlsc
   565  vec  (  29): ADB is used for array.: xyr_press
   565  vec  (  29): ADB is used for array.: xyz_dqh2oliqdt
   593  warn (  81): Name "xyz_dqvapdtlsc" is referenced but not defined.
   593  warn (  81): Name "xyz_dtempdtlsc" is referenced but not defined.
   759  opt  (  11): Fused array assignments. :line 759 - 762
   759  vec  (   4): Vectorized array expression.
   759  vec  (  29): ADB is used for array.: z_temp0
   759  vec  (  29): ADB is used for array.: z_temp
   759  vec  (  29): ADB is used for array.: z_qh2osol0
   759  vec  (  29): ADB is used for array.: z_qh2osol
   759  vec  (  29): ADB is used for array.: z_qh2oliq0
   759  vec  (  29): ADB is used for array.: z_qh2oliq
   759  vec  (  29): ADB is used for array.: z_qh2ovap0
   759  vec  (  29): ADB is used for array.: z_qvap
   774  opt  (  11): Fused array assignments. :line 774 - 778
   774  vec  (   4): Vectorized array expression.
   774  vec  (  29): ADB is used for array.: z_qh2osol
   774  vec  (  29): ADB is used for array.: z_qh2oliq
   774  vec  (  29): ADB is used for array.: z_qvap
   774  vec  (  29): ADB is used for array.: z_temp
   782  opt  (  11): Fused array assignments. :line 782 - 783
   782  vec  (   4): Vectorized array expression.
   782  vec  (  29): ADB is used for array.: z_qh2osol
   782  vec  (  29): ADB is used for array.: z_qh2oliq
   788  vec  (   1): Vectorized loop.
   788  vec  (  29): ADB is used for array.: z_qvapsat
   788  vec  (  29): ADB is used for array.: z_qvap
   799  opt  (  11): Fused array assignments. :line 799 - 807
   799  vec  (   4): Vectorized array expression.
   799  vec  (  29): ADB is used for array.: z_qvapsat
   799  vec  (  29): ADB is used for array.: z_qh2osol
   799  vec  (  29): ADB is used for array.: z_qh2oliq
   799  vec  (  29): ADB is used for array.: z_qvap
   811  vec  (   3): Unvectorized loop.
   820  opt  (1017): Subroutine call prevents optimization.
   820  vec  (  10): Vectorization obstructive procedure reference.:saturatewatfraction0d
   864  opt  (  11): Fused array assignments. :line 864 - 865
   864  vec  (   4): Vectorized array expression.
   864  vec  (  29): ADB is used for array.: z_qh2osol
   864  vec  (  29): ADB is used for array.: z_qh2osol0
   864  vec  (  29): ADB is used for array.: z_qh2oliq
   864  vec  (  29): ADB is used for array.: z_qh2oliq0
   873  opt  (  11): Fused array assignments. :line 873 - 876
   873  vec  (   4): Vectorized array expression.
   873  vec  (  29): ADB is used for array.: z_dqh2osoldt
   873  vec  (  29): ADB is used for array.: z_qh2osol0
   873  vec  (  29): ADB is used for array.: z_qh2osol
   873  vec  (  29): ADB is used for array.: z_dqh2oliqdt
   873  vec  (  29): ADB is used for array.: z_qh2oliq0
   873  vec  (  29): ADB is used for array.: z_qh2oliq
   890  warn (  83): Dummy argument "r_press" is not used.
   999  vec  (   3): Unvectorized loop.
  1000  opt  (1017): Subroutine call prevents optimization.
  1000  vec  (  10): Vectorization obstructive procedure reference.:lscalecond1grid
  1216  vec  (   3): Unvectorized loop.
  1226  vec  (  10): Vectorization obstructive procedure reference.:calcqvapsat
  1227  vec  (  10): Vectorization obstructive procedure reference.:calcdqvapsatdtemp
  1237  opt  (1017): Subroutine call prevents optimization.
  1237  vec  (  10): Vectorization obstructive procedure reference.:saturatewatfraction0d
  1309  warn (  83): Dummy argument "pressli" is not used.
  1309  warn (  83): Dummy argument "pressui" is not used.
  1473  vec  (   3): Unvectorized loop.
  1473  vec  (   7): Iteration count is too small.
  1512  opt  (1593): Loop nest collapsed into one loop.
  1512  vec  (   1): Vectorized loop.
  1512  vec  (  29): ADB is used for array.: xyz_qvap
  1512  vec  (  29): ADB is used for array.: xyz_temp
  1513  opt  (  11): Fused array assignments. :line 1513 - 1514
  1521  vec  (   1): Vectorized loop.
  1521  vec  (  29): ADB is used for array.: z_press
  1521  vec  (  29): ADB is used for array.: xyz_press
  1521  vec  (  29): ADB is used for array.: z_qh2osol
  1521  vec  (  29): ADB is used for array.: xyz_qh2osol
  1521  vec  (  29): ADB is used for array.: z_qh2oliq
  1521  vec  (  29): ADB is used for array.: xyz_qh2oliq
  1521  vec  (  29): ADB is used for array.: z_qvap
  1521  vec  (  29): ADB is used for array.: xyz_qvap
  1521  vec  (  29): ADB is used for array.: z_temp
  1521  vec  (  29): ADB is used for array.: xyz_temp
  1528  vec  (   1): Vectorized loop.
  1528  vec  (  29): ADB is used for array.: r_press
  1528  vec  (  29): ADB is used for array.: xyr_press
  1532  opt  (1017): Subroutine call prevents optimization.
  1539  vec  (   1): Vectorized loop.
  1539  vec  (  29): ADB is used for array.: xyz_dqh2osoldt
  1539  vec  (  29): ADB is used for array.: z_dqh2osoldt
  1539  vec  (  29): ADB is used for array.: xyz_dqh2oliqdt
  1539  vec  (  29): ADB is used for array.: z_dqh2oliqdt
  1539  vec  (  29): ADB is used for array.: xyz_qh2osol
  1539  vec  (  29): ADB is used for array.: z_qh2osol
  1539  vec  (  29): ADB is used for array.: xyz_qh2oliq
  1539  vec  (  29): ADB is used for array.: z_qh2oliq
  1539  vec  (  29): ADB is used for array.: xyz_qvap
  1539  vec  (  29): ADB is used for array.: z_qvap
  1539  vec  (  29): ADB is used for array.: xyz_temp
  1539  vec  (  29): ADB is used for array.: z_temp
  1548  vec  (   1): Vectorized loop.
  1548  vec  (  29): ADB is used for array.: xyz_cloudcover
  1548  vec  (  29): ADB is used for array.: z_cloudcover
  1558  vec  (  13): Overhead of loop division is too large.
  1559  vec  (   4): Vectorized array expression.
  1560  opt  (1592): Outer loop unrolled inside inner loop.
  1560  vec  (  16): Unvectorizable procedure reference.:maxvl
  1560  vec  (   3): Unvectorized loop.
  1560  vec  (  13): Overhead of loop division is too large.
  1560  vec  (   3): Unvectorized loop.
  1560  vec  (  13): Overhead of loop division is too large.
  1561  opt  (1395): Inner loop stripped and strip loop moved outside outer loop.
  1561  vec  (  16): Unvectorizable procedure reference.:maxvl
  1561  vec  (   4): Vectorized array expression.
  1561  vec  (  29): ADB is used for array.: xy_rainlsc
  1561  vec  (  29): ADB is used for array.: xyr_press
  1561  vec  (  29): ADB is used for array.: xyz_dqh2oliqdt
  1561  vec  (   4): Vectorized array expression.
  1561  vec  (  29): ADB is used for array.: xy_rainlsc
  1561  vec  (  29): ADB is used for array.: xyr_press
  1561  vec  (  29): ADB is used for array.: xyz_dqh2oliqdt
  1567  opt  (1593): Loop nest collapsed into one loop.
  1567  vec  (   1): Vectorized loop.
  1567  vec  (  29): ADB is used for array.: xyz_dqvapdtlsc
  1567  vec  (  29): ADB is used for array.: xyz_qvap
  1567  vec  (  29): ADB is used for array.: xyz_dtempdtlsc
  1567  vec  (  29): ADB is used for array.: xyz_temp
  1568  opt  (  11): Fused array assignments. :line 1568 - 1569
  1785  opt  (  11): Fused array assignments. :line 1785 - 1815
  1785  vec  (   4): Vectorized array expression.
  1785  vec  (  29): ADB is used for array.: z_temp0
  1785  vec  (  29): ADB is used for array.: z_temp
  1785  vec  (  29): ADB is used for array.: z_qh2osol0
  1785  vec  (  29): ADB is used for array.: z_qh2osol
  1785  vec  (  29): ADB is used for array.: z_qh2oliq0
  1785  vec  (  29): ADB is used for array.: z_qh2oliq
  1785  vec  (  29): ADB is used for array.: z_qh2ovap0
  1785  vec  (  29): ADB is used for array.: z_qh2ovap
  1820  opt  (  11): Fused array assignments. :line 1820 - 1828
  1820  vec  (   4): Vectorized array expression.
  1820  vec  (  29): ADB is used for array.: z_qh2ovapsat
  1832  vec  (   3): Unvectorized loop.
  1841  opt  (1017): Subroutine call prevents optimization.
  1841  vec  (  10): Vectorization obstructive procedure reference.:saturatewatfraction0d
  1907  opt  (  11): Fused array assignments. :line 1907 - 1910
  1907  vec  (   4): Vectorized array expression.
  1907  vec  (  29): ADB is used for array.: z_dqh2osoldt
  1907  vec  (  29): ADB is used for array.: z_qh2osol0
  1907  vec  (  29): ADB is used for array.: z_qh2osol
  1907  vec  (  29): ADB is used for array.: z_dqh2oliqdt
  1907  vec  (  29): ADB is used for array.: z_qh2oliq0
  1907  vec  (  29): ADB is used for array.: z_qh2oliq
  1924  warn (  83): Dummy argument "r_press" is not used.
  1971  vec  (   3): Unvectorized loop.
  1983  opt  (1017): Subroutine call prevents optimization.
  1983  vec  (  10): Vectorization obstructive procedure reference.:messagenotifyc
  1989  vec  (   3): Unvectorized loop.
  1997  opt  (1017): Subroutine call prevents optimization.
  1997  vec  (  10): Vectorization obstructive procedure reference.:messagenotifyc
  2075  warn (  82): Name "k" is not used.
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:54 2016
FILE NAME: lscond.f90
PROGRAM NAME: lscond
TRANSFORMATION LIST

  LINE                   FORTRAN STATEMENT

     1  != 大規模凝結 (非対流性凝結) (Manabe et al., 1965)
     2  !
     3  != Large scale condensation (non-convective condensation) (Manabe et al., 1965)
     4  !
     5  ! Authors::   Yasuhiro MORIKAWA, Yukiko YAMADA, Satoshi NODA, Yoshiyuki O. Takahashi
     6  ! Version::   $Id: lscond.f90,v 1.22 2015/03/11 04:53:25 yot Exp $
     7  ! Tag Name::  $Name:  $
     8  ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9  ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10  !
    11  
    12  module lscond
    13    !
    14    != 大規模凝結 (非対流性凝結)
    15    !
    16    != Large scale condensation (non-convective condensation)
    17    !
    18    ! <b>Note that Japanese and English are described in parallel.</b>
    19    !
    20    ! 大規模凝結過程によって温度と比湿を調節します.
    21    !
    22    ! Adjust temperature and specific humidity by
    23    ! a large scale condensation process.
    24    !
    25    !== References
    26    !
    27    !  Manabe, S., J. Smagorinsky, R. F. Strickler,
    28    !    Simulated climatology of a general circulation model with a hydrologic cycle,
    29    !    Mon. Wea. Rev., 93, 769-798, 1965.
    30    !
    31    !== Procedures List
    32    !
    33    ! LScaleCond    :: 温度と比湿の調節
    34    ! ------------  :: ------------
    35    ! LScaleCond    :: Adjust temperature and specific humidity
    36    !
    37    !== NAMELIST
    38    !
    39    ! NAMELIST#lscond_nml
    40    !
    41  
    42    ! モジュール引用 ; USE statements
    43    !
    44  
    45    ! 格子点設定
    46    ! Grid points settings
    47    !
    48    use gridset, only: imax, & ! 経度格子点数.
    49                               ! Number of grid points in longitude
    50      &                jmax, & ! 緯度格子点数.
    51                               ! Number of grid points in latitude
    52      &                kmax    ! 鉛直層数.
    53                               ! Number of vertical level
    54  
    55    ! 種別型パラメタ
    56    ! Kind type parameter
    57    !
    58    use dc_types, only: DP, &      ! 倍精度実数型. Double precision.
    59      &                 STRING     ! 文字列.       Strings.
    60  
    61    ! メッセージ出力
    62    ! Message output
    63    !
    64    use dc_message, only: MessageNotify
    65  
    66    ! 宣言文 ; Declaration statements
    67    !
    68    implicit none
    69    private
    70  
    71    ! 公開手続き
    72    ! Public procedure
    73    !
    74    public:: LScaleCond
    75    public:: LScaleCond1D3DWrapper
    76    public:: LScaleCond1Grid
    77    public:: LScaleCondLL911D3DWrapper
    78    public:: LScaleCondInit
    79  
    80    ! 公開変数
    81    ! Public variables
    82    !
    83    logical, save :: lscond_inited = .false.
    84                                ! 初期設定フラグ.
    85                                ! Initialization flag
    86  
    87    ! 非公開変数
    88    ! Private variables
    89    !
    90    real(DP), save:: QH2OFlucRatio
    91  
    92    real(DP), save:: CrtlRH
    93                                ! 臨界相対湿度.
    94                                ! Critical relative humidity
    95    integer, save:: ItrtMax
    96                                ! イテレーション回数.
    97                                ! Number of iteration
    98    logical, save:: FlagSatAdj
    99                                !
   100                                ! flag for saturation adjustment
   101  
   102    character(*), parameter:: module_name = 'lscond'
   103                                ! モジュールの名称.
   104                                ! Module name
   105    character(*), parameter:: version = &
   106      & '$Name:  $' // &
   107      & '$Id: lscond.f90,v 1.22 2015/03/11 04:53:25 yot Exp $'
   108                                ! モジュールのバージョン
   109                                ! Module version
   110  
   111  contains
   112  
   113    !--------------------------------------------------------------------------------------
   114  
   115    subroutine LScaleCond(        &
   116      & xyz_Temp, xyz_QVap,       &  ! (inout)
   117      & xyz_Press, xyr_Press,     &  ! (in)
   118      & xyz_DQH2OLiqDt,           &  ! (out)
   119      & FlagOutput                &  ! (in) optional
   120      & )
   121      !
   122      ! 大規模凝結スキームにより, 温度と比湿を調節します.
   123      !
   124      ! Adjust temperature and specific humidity by
   125      ! large scale condensation scheme.
   126      !
   127  
   128      ! モジュール引用 ; USE statements
   129      !
   130  
   131      ! 物理定数設定
   132      ! Physical constants settings
   133      !
   134      use constants, only: &
   135        & Grav, &
   136                                ! $ g $ [m s-2].
   137                                ! 重力加速度.
   138                                ! Gravitational acceleration
   139        & CpDry, &
   140                                ! $ C_p $ [J kg-1 K-1].
   141                                ! 乾燥大気の定圧比熱.
   142                                ! Specific heat of air at constant pressure
   143        & LatentHeat, &
   144                                ! $ L $ [J kg-1] .
   145                                ! 凝結の潜熱.
   146                                ! Latent heat of condensation
   147        & LatentHeatFusion
   148                                ! $ L $ [J kg-1] .
   149                                ! 融解の潜熱.
   150                                ! Latent heat of fusion
   151  
   152      ! 時刻管理
   153      ! Time control
   154      !
   155      use timeset, only: &
   156        & DelTime, &            ! $ \Delta t $
   157        & TimeN, &              ! ステップ $ t $ の時刻. Time of step $ t $.
   158        & TimesetClockStart, TimesetClockStop
   159  
   160      ! ヒストリデータ出力
   161      ! History data output
   162      !
   163      use gtool_historyauto, only: HistoryAutoPut
   164  
   165      ! 飽和比湿の算出
   166      ! Evaluate saturation specific humidity
   167      !
   168      use saturate, only: xyz_CalcQVapSat, xyz_CalcDQVapSatDTemp
   169  
   170  
   171      ! 宣言文 ; Declaration statements
   172      !
   173      implicit none
   174  
   175      real(DP), intent(inout):: xyz_Temp (0:imax-1, 1:jmax, 1:kmax)
   176                                ! $ T $ .     温度. Temperature
   177      real(DP), intent(inout):: xyz_QVap (0:imax-1, 1:jmax, 1:kmax)
   178                                ! $ q $ .     比湿. Specific humidity
   179      real(DP), intent(in):: xyz_Press (0:imax-1, 1:jmax, 1:kmax)
   180                                ! $ p $ . 気圧 (整数レベル).
   181                                ! Air pressure (full level)
   182      real(DP), intent(in):: xyr_Press (0:imax-1, 1:jmax, 0:kmax)
   183                                ! $ \hat{p} $ . 気圧 (半整数レベル).
   184                                ! Air pressure (half level)
   185      real(DP), intent(out) :: xyz_DQH2OLiqDt(0:imax-1,1:jmax,1:kmax)
   186                                !
   187                                ! Tendency of H2O liquid mixing ratio
   188      logical , intent(in ), optional :: FlagOutput
   189                                !
   190                                ! Flag for output
   191  
   192  
   193      ! 作業変数
   194      ! Work variables
   195      !
   196      real(DP):: xy_RainLsc (0:imax-1, 1:jmax)
   197                                ! 降水量.
   198                                ! Precipitation
   199      real(DP):: xyz_DTempDtLsc (0:imax-1, 1:jmax, 1:kmax)
   200                                ! 温度変化率.
   201                                ! Temperature tendency
   202      real(DP):: xyz_DQVapDtLsc (0:imax-1, 1:jmax, 1:kmax)
   203                                ! 比湿変化率.
   204                                ! Specific humidity tendency
   205  
   206      real(DP):: xyz_QVapB (0:imax-1, 1:jmax, 1:kmax)
   207                                ! 調節前の比湿.
   208                                ! Specific humidity before adjust.
   209      real(DP):: xyz_TempB (0:imax-1, 1:jmax, 1:kmax)
   210                                ! 調節前の温度.
   211                                ! Temperature before adjust.
   212                                !
   213      real(DP):: xyz_QVapSat      (0:imax-1, 1:jmax, 1:kmax)
   214                                ! 飽和比湿.
   215                                ! Saturation specific humidity.
   216      real(DP):: xyz_DQVapSatDTemp(0:imax-1, 1:jmax, 1:kmax)
   217                                ! $ \DD{q_{\rm{sat}}}{T} $
   218      real(DP):: DelTemp
   219                                ! 調節による温度変化量.
   220                                ! Temperature variation by adjustment
   221  
   222      real(DP):: LatentHeatLocal
   223                                !
   224                                ! Latent heat used in this routine
   225  
   226      integer:: i               ! 経度方向に回る DO ループ用作業変数
   227                                ! Work variables for DO loop in longitude
   228      integer:: j               ! 緯度方向に回る DO ループ用作業変数
   229                                ! Work variables for DO loop in latitude
   230      integer:: k               ! 鉛直方向に回る DO ループ用作業変数
   231                                ! Work variables for DO loop in vertical direction
   232      integer:: itr             ! イテレーション方向に回る DO ループ用作業変数
   233                                ! Work variables for DO loop in iteration direction
   234  
   235      real(DP):: xyz_RainLSC(0:imax-1, 1:jmax, 1:kmax)
   236  
   237      real(DP):: TempBefAdj
   238      real(DP):: QVapBefAdj
   239  
   240      logical:: xyz_FlagSaturated(0:imax-1, 1:jmax, 1:kmax)
   241  
   242  
   243      ! 実行文 ; Executable statement
   244      !
   245  
   246      ! 初期化確認
   247      ! Initialization check
   248      !
   249      if ( .not. lscond_inited ) then
   250        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   251      end if
   252  
   253  
   254      ! 計算時間計測開始
   255      ! Start measurement of computation time
   256      !
   257      call TimesetClockStart( module_name )
   258  
   259  
   260      ! 調節前 "QVap", "Temp" の保存
   261      ! Store "QVap", "Temp" before adjustment
   262      !
   263      xyz_QVapB  = xyz_QVap
   264      xyz_TempB  = xyz_Temp
   265  
   266  
   267      ! 調節
   268      ! Adjustment
   269      !
   270  
   271      ! 飽和比湿計算
   272      ! Calculate saturation specific humidity
   273      !
   274      xyz_QVapSat = xyz_CalcQVapSat( xyz_Temp, xyz_Press )
   275  
   276      do k = 1, kmax
   277        do j = 1, jmax
   278          do i = 0, imax-1
   279  
   280            if ( ( xyz_QVap(i,j,k) / xyz_QVapSat(i,j,k) ) >= CrtlRH ) then
   281              xyz_FlagSaturated(i,j,k) = .true.
   282            else
   283              xyz_FlagSaturated(i,j,k) = .false.
   284            end if
   285  
   286          end do
   287        end do
     .           if (jmax .gt. 0) then                                          
     .           j1 = and(jmax,3)                                               
     .           do j = 1, j1                                                   
     .  !cdir       nodep                                                       
     .              do i = 1, imax                                              
     .                 if (xyz_qvap(i-1,j,k)/xyz_qvapsat(i-1,j,k) .ge. crtlrh)  
     .       1            then                                                  
     .                    xyz_flagsaturated2 = 1                                
     .                 else                                                     
     .                    xyz_flagsaturated2 = 0                                
     .                 endif                                                    
     .                 xyz_flagsaturated(i-1,j,k) = xyz_flagsaturated2          
     .              enddo                                                       
     .           enddo                                                          
     .           do j = j1 + 1, jmax, 4                                         
     .  !cdir       nodep                                                       
     .              do i = 1, imax                                              
     .                 if (xyz_qvap(i-1,j,k)/xyz_qvapsat(i-1,j,k) .ge. crtlrh)  
     .       1            then                                                  
     .                    xyz_flagsaturated3 = 1                                
     .                 else                                                     
     .                    xyz_flagsaturated3 = 0                                
     .                 endif                                                    
     .                 xyz_flagsaturated(i-1,j,k) = xyz_flagsaturated3          
     .                 if (xyz_qvap(i-1,j+1,k)/xyz_qvapsat(i-1,j+1,k) .ge.      
     .       1            crtlrh) then                                          
     .                    xyz_flagsaturated4 = 1                                
     .                 else                                                     
     .                    xyz_flagsaturated4 = 0                                
     .                 endif                                                    
     .                 xyz_flagsaturated(i-1,j+1,k) = xyz_flagsaturated4        
     .                 if (xyz_qvap(i-1,j+2,k)/xyz_qvapsat(i-1,j+2,k) .ge.      
     .       1            crtlrh) then                                          
     .                    xyz_flagsaturated5 = 1                                
     .                 else                                                     
     .                    xyz_flagsaturated5 = 0                                
     .                 endif                                                    
     .                 xyz_flagsaturated(i-1,j+2,k) = xyz_flagsaturated5        
     .                 if (xyz_qvap(i-1,j+3,k)/xyz_qvapsat(i-1,j+3,k) .ge.      
     .       1            crtlrh) then                                          
     .                    xyz_flagsaturated6 = 1                                
     .                 else                                                     
     .                    xyz_flagsaturated6 = 0                                
     .                 endif                                                    
     .                 xyz_flagsaturated(i-1,j+3,k) = xyz_flagsaturated6        
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
   288      end do
   289  
   290      ! Set a value for latent heat
   291      LatentHeatLocal = LatentHeat
   292  
   293      do itr = 1, ItrtMax
   294  
   295        ! 飽和比湿計算
   296        ! Calculate saturation specific humidity
   297        !
   298        xyz_QVapSat       = xyz_CalcQVapSat      ( xyz_Temp, xyz_Press   )
   299        xyz_DQVapSatDTemp = xyz_CalcDQVapSatDTemp( xyz_Temp, xyz_QVapSat )
   300  
   301  
   302        do k = 1, kmax
   303          do j = 1, jmax
   304            do i = 0, imax-1
   305  
   306              ! 飽和していたら, 温度と比湿の変化を計算
   307              ! Calculate tendency of temperature and humidity
   308              ! if moist is saturation.
   309              !
   310              if ( xyz_FlagSaturated(i,j,k) ) then
   311  
   312                ! 温度の変化分をニュートン法で求める
   313                ! Calculate variation of temperature
   314                !
   315                DelTemp =                                                 &
   316                  & LatentHeatLocal                                       &
   317                  &   * ( xyz_QVap(i,j,k) - CrtlRH * xyz_QVapSat(i,j,k) ) &
   318                  &   / ( CpDry + LatentHeatLocal * CrtlRH * xyz_DQVapSatDTemp(i,j,k) )
   319  
   320  
   321                !=========
   322                ! check routine
   323                !---------
   324  !!$              TempBefAdj = xyz_Temp(i,j,k)
   325  !!$              QVapBefAdj = xyz_QVap(i,j,k)
   326                !=========
   327  
   328                ! 温度と比湿の調節
   329                ! Adjust temperature and specific humidity
   330                !
   331                xyz_Temp(i,j,k) = xyz_Temp(i,j,k) + DelTemp
   332  !!$              xyz_QVap(i,j,k) = xyz_QVapSat(i,j,k) + xyz_DQVapSatDTemp(i,j,k) * DelTemp
   333                xyz_QVap(i,j,k) = &
   334                  & CrtlRH * ( xyz_QVapSat(i,j,k) + xyz_DQVapSatDTemp(i,j,k) * DelTemp )
   335  
   336                !=========
   337                ! check routine
   338                !---------
   339  !!$              write( 6, * ) '====='
   340  !!$              write( 6, * ) 'Energy difference before and after adjustment and each energy'
   341  !!$              write( 6, * ) &
   342  !!$                &     CpDry * TempBefAdj      + LatentHeatLocal * QVapBefAdj            &
   343  !!$                & - ( CpDry * xyz_Temp(i,j,k) + LatentHeatLocal * xyz_QVap(i,j,k) ),    &
   344  !!$                &     CpDry * TempBefAdj      + LatentHeatLocal * QVapBefAdj,           &
   345  !!$                &   ( CpDry * xyz_Temp(i,j,k) + LatentHeatLocal * xyz_QVap(i,j,k) )
   346                !=========
   347  
   348  
   349              end if
   350  
   351            end do
   352          end do
     .        if (jmax .gt. 0) then                                             
     .           j7 = and(jmax,3)                                               
     .           do j = 1, j7                                                   
     .  !cdir       nodep                                                       
     .              do i = 1, imax                                              
     .                 if (xyz_flagsaturated(i-1,j,k) .ne. 0) then              
     .                    deltemp = latentheatlocal*(xyz_qvap(i-1,j,k)-crtlrh*  
     .       1               xyz_qvapsat(i-1,j,k))/(cpdry + latentheatlocal*    
     .       2               crtlrh*xyz_dqvapsatdtemp(i-1,j,k))                 
     .                    xyz_temp(i-1,j,k) = xyz_temp(i-1,j,k) + deltemp       
     .                    xyz_qvap(i-1,j,k) = crtlrh*(xyz_qvapsat(i-1,j,k)+     
     .       1               xyz_dqvapsatdtemp(i-1,j,k)*deltemp)                
     .                 endif                                                    
     .              enddo                                                       
     .           enddo                                                          
     .           do j = j7 + 1, jmax, 4                                         
     .  !cdir       nodep                                                       
     .              do i = 1, imax                                              
     .                 if (xyz_flagsaturated(i-1,j,k) .ne. 0) then              
     .                    deltemp4 = latentheatlocal*(xyz_qvap(i-1,j,k)-crtlrh* 
     .       1               xyz_qvapsat(i-1,j,k))/(cpdry + latentheatlocal*    
     .       2               crtlrh*xyz_dqvapsatdtemp(i-1,j,k))                 
     .                    xyz_temp(i-1,j,k) = xyz_temp(i-1,j,k) + deltemp4      
     .                    xyz_qvap(i-1,j,k) = crtlrh*(xyz_qvapsat(i-1,j,k)+     
     .       1               xyz_dqvapsatdtemp(i-1,j,k)*deltemp4)               
     .                 endif                                                    
     .                 if (xyz_flagsaturated(i-1,j+1,k) .ne. 0) then            
     .                    deltemp3 = latentheatlocal*(xyz_qvap(i-1,j+1,k)-crtlrh
     .       1               *xyz_qvapsat(i-1,j+1,k))/(cpdry + latentheatlocal* 
     .       2               crtlrh*xyz_dqvapsatdtemp(i-1,j+1,k))               
     .                    xyz_temp(i-1,j+1,k) = xyz_temp(i-1,j+1,k) + deltemp3  
     .                    xyz_qvap(i-1,j+1,k) = crtlrh*(xyz_qvapsat(i-1,j+1,k)+ 
     .       1               xyz_dqvapsatdtemp(i-1,j+1,k)*deltemp3)             
     .                 endif                                                    
     .                 if (xyz_flagsaturated(i-1,j+2,k) .ne. 0) then            
     .                    deltemp2 = latentheatlocal*(xyz_qvap(i-1,j+2,k)-crtlrh
     .       1               *xyz_qvapsat(i-1,j+2,k))/(cpdry + latentheatlocal* 
     .       2               crtlrh*xyz_dqvapsatdtemp(i-1,j+2,k))               
     .                    xyz_temp(i-1,j+2,k) = xyz_temp(i-1,j+2,k) + deltemp2  
     .                    xyz_qvap(i-1,j+2,k) = crtlrh*(xyz_qvapsat(i-1,j+2,k)+ 
     .       1               xyz_dqvapsatdtemp(i-1,j+2,k)*deltemp2)             
     .                 endif                                                    
     .                 if (xyz_flagsaturated(i-1,j+3,k) .ne. 0) then            
     .                    deltemp1 = latentheatlocal*(xyz_qvap(i-1,j+3,k)-crtlrh
     .       1               *xyz_qvapsat(i-1,j+3,k))/(cpdry + latentheatlocal* 
     .       2               crtlrh*xyz_dqvapsatdtemp(i-1,j+3,k))               
     .                    xyz_temp(i-1,j+3,k) = xyz_temp(i-1,j+3,k) + deltemp1  
     .                    xyz_qvap(i-1,j+3,k) = crtlrh*(xyz_qvapsat(i-1,j+3,k)+ 
     .       1               xyz_dqvapsatdtemp(i-1,j+3,k)*deltemp1)             
     .                 endif                                                    
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
   353        end do
   354  
   355      end do
   356  
   357      ! 比湿変化率, 温度変化率, 降水量の算出
   358      ! Calculate specific humidity tendency, temperature tendency,
   359      ! precipitation
   360      !
   361      xyz_DQVapDtLsc = ( xyz_QVap - xyz_QVapB ) / ( 2.0_DP * DelTime )
     .        d5 = 1.D0/(2.00000000000000e+000*deltime)                         
     .        d6 = 1.D0/(2.00000000000000e+000*deltime)                         
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t502 = 1, kmax*jmax*imax                                       
     .           xyz_dqvapdtlsc(t502-1,1,1) = (xyz_qvap(t502-1,1,1)-xyz_qvapb(  
     .       1      t502-1,1,1))*d5                                             
     .           xyz_dtempdtlsc(t502-1,1,1) = (xyz_temp(t502-1,1,1)-xyz_tempb(  
     .       1      t502-1,1,1))*d6                                             
     .           xyz_dqh2oliqdt(t502-1,1,1) = -xyz_dqvapdtlsc(t502-1,1,1)       
     .        enddo                                                             
   362      xyz_DTempDtLsc = ( xyz_Temp - xyz_TempB ) / ( 2.0_DP * DelTime )
   363  
   364      xyz_DQH2OLiqDt = - xyz_DQVapDtLsc
   365  
   366  
   367      ! calculation for output
   368      xy_RainLsc     = 0.0_DP
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t532 = 1, xy_rainlsc.DSC.U2*xy_rainlsc.DSC.U1 +                
     .       1   xy_rainlsc.DSC.U2                                              
     .           xy_rainlsc(t532-1,1) = 0.0000000000000000e+000                 
     .        enddo                                                             
   369      do k = kmax, 1, -1
   370        xy_RainLsc = xy_RainLsc                                     &
     .        d7 = 1.D0/grav                                                    
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xy_rainlsc,xyr_press)                                      
     .        do t538 = 1, xy_rainlsc.DSC.U2*xy_rainlsc.DSC.U1 +                
     .       1   xy_rainlsc.DSC.U2                                              
     .           xy_rainlsc(t538-1,1) = xy_rainlsc(t538-1,1) + xyz_dqh2oliqdt(  
     .       1      t538-1,1,k)*(xyr_press(t538-1,1,k-1)-xyr_press(t538-1,1,k))*
     .       2      d7                                                          
     .        enddo                                                             
   371          & + xyz_DQH2OLiqDt(:,:,k) * ( xyr_Press(:,:,k-1) - xyr_Press(:,:,k) ) / Grav
   372      end do
   373  
   374  
   375      ! ヒストリデータ出力
   376      ! History data output
   377      !
   378      if ( .not. present( FlagOutput ) ) then
   379        call HistoryAutoPut( TimeN, 'DTempDtLsc', xyz_DTempDtLsc )
   380        call HistoryAutoPut( TimeN, 'DQH2OVapDtLsc', xyz_DQVapDtLsc )
   381        call HistoryAutoPut( TimeN, 'DQH2OLiqDtLsc', xyz_DQH2OLiqDt )
   382      else
   383        if ( FlagOutput ) then
   384          call HistoryAutoPut( TimeN, 'DTempDtLsc', xyz_DTempDtLsc )
   385          call HistoryAutoPut( TimeN, 'DQH2OVapDtLsc', xyz_DQVapDtLsc )
   386          call HistoryAutoPut( TimeN, 'DQH2OLiqDtLsc', xyz_DQH2OLiqDt )
   387        end if
   388      end if
   389  
   390  
   391      ! 計算時間計測一時停止
   392      ! Pause measurement of computation time
   393      !
   394      call TimesetClockStop( module_name )
   395  
   396    end subroutine LScaleCond
   397  
   398    !--------------------------------------------------------------------------------------
   399  
   400    subroutine LScaleCond1D3DWrapper(                 &
   401      & xyz_Temp, xyz_QVap, xyz_QH2OLiq, xyz_QH2OSol, &  ! (inout)
   402      & xyz_Press, xyr_Press,                         &  ! (in)
   403      & xyz_DQH2OLiqDt, xyz_DQH2OSolDt,               &  ! (out)
   404      & FlagOutput                                    &  ! (in) optional
   405      & )
   406      !
   407      ! 大規模凝結スキームにより, 温度と比湿を調節します.
   408      !
   409      ! Adjust temperature and specific humidity by
   410      ! large scale condensation scheme.
   411      !
   412  
   413      ! モジュール引用 ; USE statements
   414      !
   415  
   416      ! 物理定数設定
   417      ! Physical constants settings
   418      !
   419      use constants, only: &
   420        & Grav
   421                                ! $ g $ [m s-2].
   422                                ! 重力加速度.
   423                                ! Gravitational acceleration
   424  
   425      ! 時刻管理
   426      ! Time control
   427      !
   428      use timeset, only: &
   429        & DelTime, &            ! $ \Delta t $
   430        & TimeN, &              ! ステップ $ t $ の時刻. Time of step $ t $.
   431        & TimesetClockStart, TimesetClockStop
   432  
   433      ! ヒストリデータ出力
   434      ! History data output
   435      !
   436      use gtool_historyauto, only: HistoryAutoPut
   437  
   438  
   439      ! 宣言文 ; Declaration statements
   440      !
   441      implicit none
   442  
   443      real(DP), intent(inout):: xyz_Temp (0:imax-1, 1:jmax, 1:kmax)
   444                                ! $ T $ .     温度. Temperature
   445      real(DP), intent(inout):: xyz_QVap (0:imax-1, 1:jmax, 1:kmax)
   446                                ! $ q $ .     比湿. Specific humidity
   447      real(DP), intent(inout):: xyz_QH2OLiq(0:imax-1, 1:jmax, 1:kmax)
   448                                ! Specific liquid water content
   449      real(DP), intent(inout):: xyz_QH2OSol(0:imax-1, 1:jmax, 1:kmax)
   450                                ! Specific ice content
   451      real(DP), intent(in):: xyz_Press (0:imax-1, 1:jmax, 1:kmax)
   452                                ! $ p $ . 気圧 (整数レベル).
   453                                ! Air pressure (full level)
   454      real(DP), intent(in):: xyr_Press (0:imax-1, 1:jmax, 0:kmax)
   455                                ! $ \hat{p} $ . 気圧 (半整数レベル).
   456                                ! Air pressure (half level)
   457      real(DP), intent(out) :: xyz_DQH2OLiqDt(0:imax-1,1:jmax,1:kmax)
   458                                !
   459                                ! Tendency of H2O liquid mixing ratio
   460      real(DP), intent(out) :: xyz_DQH2OSolDt(0:imax-1,1:jmax,1:kmax)
   461                                !
   462                                ! Tendency of H2O ice mixing ratio
   463      logical , intent(in ), optional :: FlagOutput
   464                                !
   465                                ! Flag for output
   466  
   467  
   468      ! 作業変数
   469      ! Work variables
   470      !
   471      real(DP):: xy_RainLsc (0:imax-1, 1:jmax)
   472                                ! 降水量.
   473                                ! Precipitation
   474  
   475      real(DP):: xyz_DTempDtLsc (0:imax-1, 1:jmax, 1:kmax)
   476                                ! 温度変化率.
   477                                ! Temperature tendency
   478      real(DP):: xyz_DQVapDtLsc (0:imax-1, 1:jmax, 1:kmax)
   479                                ! 比湿変化率.
   480                                ! Specific humidity tendency
   481  
   482      real(DP) :: z_Temp (1:kmax)
   483                                ! $ T $ .     温度. Temperature
   484      real(DP) :: z_QVap (1:kmax)
   485                                ! $ q $ .     比湿. Specific humidity
   486      real(DP) :: z_QH2OLiq(1:kmax)
   487                                ! Specic liquid water content
   488      real(DP) :: z_QH2OSol(1:kmax)
   489                                ! Specic ice content
   490      real(DP) :: z_Press (1:kmax)
   491                                ! $ p $ . 気圧 (整数レベル).
   492                                ! Air pressure (full level)
   493      real(DP) :: r_Press (0:kmax)
   494                                ! $ \hat{p} $ . 気圧 (半整数レベル).
   495                                ! Air pressure (half level)
   496      real(DP) :: z_DQH2OLiqDt(1:kmax)
   497                                !
   498                                ! Tendency of H2O liquid mixing ratio
   499      real(DP) :: z_DQH2OSolDt(1:kmax)
   500                                !
   501                                ! Tendency of H2O ice mixing ratio
   502  
   503  
   504      integer:: i               ! 経度方向に回る DO ループ用作業変数
   505                                ! Work variables for DO loop in longitude
   506      integer:: j               ! 緯度方向に回る DO ループ用作業変数
   507                                ! Work variables for DO loop in latitude
   508      integer:: k               ! 鉛直方向に回る DO ループ用作業変数
   509                                ! Work variables for DO loop in vertical direction
   510  
   511      ! 実行文 ; Executable statement
   512      !
   513  
   514      ! 初期化確認
   515      ! Initialization check
   516      !
   517      if ( .not. lscond_inited ) then
   518        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   519      end if
   520  
   521  
   522      ! 計算時間計測開始
   523      ! Start measurement of computation time
   524      !
   525      call TimesetClockStart( module_name )
   526  
   527  
   528  
   529      do j = 1, jmax
   530        do i = 0, imax-1
   531  
   532          do k = 1, kmax
   533            z_Temp   (k) = xyz_Temp   (i,j,k)
   534            z_QVap   (k) = xyz_QVap   (i,j,k)
   535            z_QH2OLiq(k) = xyz_QH2OLiq(i,j,k)
   536            z_QH2OSol(k) = xyz_QH2OSol(i,j,k)
   537            z_Press  (k) = xyz_Press  (i,j,k)
   538          end do
   539          do k = 0, kmax
   540            r_Press  (k) = xyr_Press  (i,j,k)
   541          end do
   542  
   543          call LScaleCond1D(                        &
   544            & z_Temp, z_QVap, z_QH2OLiq, z_QH2OSol, &  ! (inout)
   545            & z_Press, r_Press,                     &  ! (in)
   546            & z_DQH2OLiqDt, z_DQH2OSolDt            &  ! (out)
   547            & )
   548  
   549          do k = 1, kmax
   550            xyz_Temp      (i,j,k) = z_Temp      (k)
   551            xyz_QVap      (i,j,k) = z_QVap      (k)
   552            xyz_QH2OLiq   (i,j,k) = z_QH2OLiq   (k)
   553            xyz_QH2OSol   (i,j,k) = z_QH2OSol   (k)
   554            xyz_DQH2OLiqDt(i,j,k) = z_DQH2OLiqDt(k)
   555            xyz_DQH2OSolDt(i,j,k) = z_DQH2OSolDt(k)
   556          end do
   557  
   558        end do
   559      end do
   560  
   561  
   562      ! calculation for output
   563      xy_RainLsc     = 0.0_DP
     .  !cdir    nodep                                                          
     .  !cdir noassume                                                          
     .        do t370 = 1, xy_rainlsc.DSC.U2*xy_rainlsc.DSC.U1 +                
     .       1   xy_rainlsc.DSC.U2                                              
     .           xy_rainlsc(t370-1,1) = 0.0000000000000000e+000                 
     .        enddo                                                             
   564      do k = kmax, 1, -1
   565        xy_RainLsc = xy_RainLsc                                     &
     .        d1 = 1.D0/grav                                                    
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xy_rainlsc,xyr_press)                                      
     .        do t376 = 1, xy_rainlsc.DSC.U2*xy_rainlsc.DSC.U1 +                
     .       1   xy_rainlsc.DSC.U2                                              
     .           xy_rainlsc(t376-1,1) = xy_rainlsc(t376-1,1) + xyz_dqh2oliqdt(  
     .       1      t376-1,1,k)*(xyr_press(t376-1,1,k-1)-xyr_press(t376-1,1,k))*
     .       2      d1                                                          
     .        enddo                                                             
   566          & + xyz_DQH2OLiqDt(:,:,k) * ( xyr_Press(:,:,k-1) - xyr_Press(:,:,k) ) / Grav
   567      end do
   568  
   569  
   570      ! ヒストリデータ出力
   571      ! History data output
   572      !
   573      if ( .not. present( FlagOutput ) ) then
   574        call HistoryAutoPut( TimeN, 'DTempDtLsc', xyz_DTempDtLsc )
   575        call HistoryAutoPut( TimeN, 'DQH2OVapDtLsc', xyz_DQVapDtLsc )
   576        call HistoryAutoPut( TimeN, 'DQH2OLiqDtLsc', xyz_DQH2OLiqDt )
   577        call HistoryAutoPut( TimeN, 'DQH2OSolDtLsc', xyz_DQH2OSolDt )
   578      else
   579        if ( FlagOutput ) then
   580          call HistoryAutoPut( TimeN, 'DTempDtLsc', xyz_DTempDtLsc )
   581          call HistoryAutoPut( TimeN, 'DQH2OVapDtLsc', xyz_DQVapDtLsc )
   582          call HistoryAutoPut( TimeN, 'DQH2OLiqDtLsc', xyz_DQH2OLiqDt )
   583          call HistoryAutoPut( TimeN, 'DQH2OSolDtLsc', xyz_DQH2OSolDt )
   584        end if
   585      end if
   586  
   587  
   588      ! 計算時間計測一時停止
   589      ! Pause measurement of computation time
   590      !
   591      call TimesetClockStop( module_name )
   592  
   593    end subroutine LScaleCond1D3DWrapper
   594  
   595    !--------------------------------------------------------------------------------------
   596  
   597    subroutine LScaleCond1D_BK(  &
   598      & z_Temp, z_QVap, z_QH2OLiq, z_QH2OSol, &  ! (inout)
   599      & z_Press, r_Press,                     &  ! (in)
   600      & z_DQH2OLiqDt, z_DQH2OSolDt            &  ! (out)
   601      & )
   602      !
   603      ! 大規模凝結スキームにより, 温度と比湿を調節します.
   604      !
   605      ! Adjust temperature and specific humidity by
   606      ! large scale condensation scheme.
   607      !
   608  
   609      ! モジュール引用 ; USE statements
   610      !
   611  
   612      ! 物理定数設定
   613      ! Physical constants settings
   614      !
   615      use constants, only: &
   616        & Grav, &
   617                                ! $ g $ [m s-2].
   618                                ! 重力加速度.
   619                                ! Gravitational acceleration
   620        & CpDry, &
   621                                ! $ C_p $ [J kg-1 K-1].
   622                                ! 乾燥大気の定圧比熱.
   623                                ! Specific heat of air at constant pressure
   624        & LatentHeat, &
   625                                ! $ L $ [J kg-1] .
   626                                ! 凝結の潜熱.
   627                                ! Latent heat of condensation
   628        & LatentHeatFusion
   629                                ! $ L $ [J kg-1] .
   630                                ! 融解の潜熱.
   631                                ! Latent heat of fusion
   632  
   633      ! 時刻管理
   634      ! Time control
   635      !
   636      use timeset, only: &
   637        & DelTime, &            ! $ \Delta t $
   638        & TimeN, &              ! ステップ $ t $ の時刻. Time of step $ t $.
   639        & TimesetClockStart, TimesetClockStop
   640  
   641      ! ヒストリデータ出力
   642      ! History data output
   643      !
   644      use gtool_historyauto, only: HistoryAutoPut
   645  
   646      ! 飽和比湿の算出
   647      ! Evaluate saturation specific humidity
   648      !
   649      use saturate, only: a_CalcQVapSat, a_CalcDQVapSatDTemp
   650  
   651      ! 飽和比湿の算出
   652      ! Evaluate saturation specific humidity
   653      !
   654      use saturate, only : SaturateWatFraction
   655  
   656  
   657      ! 宣言文 ; Declaration statements
   658      !
   659      implicit none
   660  
   661      real(DP), intent(inout):: z_Temp (1:kmax)
   662                                ! $ T $ .     温度. Temperature
   663      real(DP), intent(inout):: z_QVap (1:kmax)
   664                                ! $ q $ .     比湿. Specific humidity
   665      real(DP), intent(inout):: z_QH2OLiq(1:kmax)
   666                                ! Specific liquid water content
   667      real(DP), intent(inout):: z_QH2OSol(1:kmax)
   668                                ! Specific ice content
   669      real(DP), intent(in   ):: z_Press (1:kmax)
   670                                ! $ p $ . 気圧 (整数レベル).
   671                                ! Air pressure (full level)
   672      real(DP), intent(in   ):: r_Press (0:kmax)
   673                                ! $ \hat{p} $ . 気圧 (半整数レベル).
   674                                ! Air pressure (half level)
   675      real(DP), intent(out  ):: z_DQH2OLiqDt(1:kmax)
   676                                !
   677                                ! Tendency of H2O liquid mixing ratio
   678      real(DP), intent(out  ):: z_DQH2OSolDt(1:kmax)
   679                                !
   680                                ! Tendency of H2O ice mixing ratio
   681  
   682  
   683      ! 作業変数
   684      ! Work variables
   685      !
   686      real(DP):: z_DTempDtLsc (1:kmax)
   687                                ! 温度変化率.
   688                                ! Temperature tendency
   689      real(DP):: z_DQVapDtLsc (1:kmax)
   690                                ! 比湿変化率.
   691                                ! Specific humidity tendency
   692  
   693      real(DP):: z_QH2OVap0 (1:kmax)
   694                                ! 調節前の比湿.
   695                                ! Specific humidity before adjust.
   696      real(DP):: z_QH2OLiq0 (1:kmax)
   697                                !
   698                                ! Specific liquid water content before adjust.
   699      real(DP):: z_QH2OSol0 (1:kmax)
   700                                !
   701                                ! Specific liquid water content before adjust.
   702      real(DP):: z_Temp0    (1:kmax)
   703                                ! 調節前の温度.
   704                                ! Temperature before adjust.
   705                                !
   706      real(DP):: z_QH2OVapB (1:kmax)
   707                                ! 調節前の比湿.
   708                                ! Specific humidity before adjust.
   709      real(DP):: z_QH2OLiqB (1:kmax)
   710                                !
   711                                ! Specific liquid water content before adjust.
   712      real(DP):: z_QH2OSolB (1:kmax)
   713                                !
   714                                ! Specific liquid water content before adjust.
   715      real(DP):: z_TempB    (1:kmax)
   716                                ! 調節前の温度.
   717                                ! Temperature before adjust.
   718                                !
   719      real(DP):: z_QVapSat      (1:kmax)
   720                                ! 飽和比湿.
   721                                ! Saturation specific humidity.
   722      real(DP):: z_DQVapSatDTemp(1:kmax)
   723                                ! $ \DD{q_{\rm{sat}}}{T} $
   724      real(DP):: DelTemp
   725                                ! 調節による温度変化量.
   726                                ! Temperature variation by adjustment
   727  
   728      real(DP) :: WatFrac
   729      real(DP) :: IceFrac
   730  
   731  
   732      integer:: k               ! 鉛直方向に回る DO ループ用作業変数
   733                                ! Work variables for DO loop in vertical direction
   734      integer:: itr             ! イテレーション方向に回る DO ループ用作業変数
   735                                ! Work variables for DO loop in iteration direction
   736      logical:: z_FlagProcess(1:kmax)
   737  
   738  
   739      ! 実行文 ; Executable statement
   740      !
   741  
   742      ! 初期化確認
   743      ! Initialization check
   744      !
   745      if ( .not. lscond_inited ) then
   746        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   747      end if
   748  
   749  
   750  !!$    ! 計算時間計測開始
   751  !!$    ! Start measurement of computation time
   752  !!$    !
   753  !!$    call TimesetClockStart( module_name )
   754  
   755  
   756      ! 調節前 "QVap", "Temp" の保存
   757      ! Store "QVap", "Temp" before adjustment
   758      !
   759      z_QH2OVap0 = z_QVap
   760      z_QH2OLiq0 = z_QH2OLiq
   761      z_QH2OSol0 = z_QH2OSol
   762      z_Temp0    = z_Temp
   763  
   764  
   765      ! 調節
   766      ! Adjustment
   767      !
   768  
   769      ! 飽和比湿計算
   770      ! Calculate saturation specific humidity
   771      !
   772  
   773      if ( FlagSatAdj ) then
   774        z_Temp = z_Temp &
     .           d1 = 1.D0/cpdry                                                
     .  !cdir nodep                                                             
     .        do t386 = 1, z_temp.DSC.U1                                        
     .           z_temp(t386) = z_temp(t386) + (latentheat*z_qh2oliq(t386)+(    
     .       1      latentheat+latentheatfusion)*z_qh2osol(t386))*d1            
     .           z_qvap(t386) = z_qvap(t386) + z_qh2oliq(t386) + z_qh2osol(t386)
     .           z_qh2oliq(t386) = 0.0000000000000000e+000                      
     .           z_qh2osol(t386) = 0.0000000000000000e+000                      
     .        enddo                                                             
     .        goto 10008                                                        
   775          & + ( LatentHeat * z_QH2OLiq + ( LatentHeat + LatentHeatFusion ) * z_QH2OSol ) / CpDry
   776        z_QVap = z_QVap + z_QH2OLiq + z_QH2OSol
   777        z_QH2OLiq = 0.0_DP
   778        z_QH2OSol = 0.0_DP
   779      else
   780        ! Pre-existing cloud water and ice are removed, since those are not
   781        ! responsible with condensation (assumption).
   782        z_QH2OLiq = 0.0_DP
   783        z_QH2OSol = 0.0_DP
   784      end if
   785      !
   786      z_QVapSat = a_CalcQVapSat( z_Temp, z_Press )
   787      !
   788      do k = 1, kmax
   789        if ( ( z_QVap(k) / z_QVapSat(k) ) >= CrtlRH ) then
   790          z_FlagProcess(k) = .true.
   791        else
   792          z_FlagProcess(k) = .false.
   793        end if
   794      end do
     .  !cdir    nodep                                                          
     .        do k = 1, kmax                                                    
     .           if (z_qvap(k)/z_qvapsat(k) .ge. crtlrh) then                   
     .              z_flagprocess1 = 1                                          
     .           else                                                           
     .              z_flagprocess1 = 0                                          
     .           endif                                                          
     .           z_flagprocess(k) = z_flagprocess1                              
     .        enddo                                                             
   795  
   796  
   797      do itr = 1, ItrtMax
   798  
   799        z_QH2OVapB = z_QVap
     .  !cdir nodep                                                             
     .        do t352 = 1, 1 + z_qh2ovapb.DSC.U1 - min0(1,z_qh2ovapb.DSC.U1)    
     .           z_qh2ovapb(t352) = z_qvap(t352)                                
     .           z_qh2oliqb(t352) = z_qh2oliq(t352)                             
     .           z_qh2osolb(t352) = z_qh2osol(t352)                             
     .           z_qvapsat(t352) = %00029b(t352)                                
     .        enddo                                                             
     .        goto 10018                                                        
   800        z_QH2OLiqB = z_QH2OLiq
   801        z_QH2OSolB = z_QH2OSol
   802        z_TempB    = z_Temp
   803  
   804        ! 飽和比湿計算
   805        ! Calculate saturation specific humidity
   806        !
   807        z_QVapSat       = a_CalcQVapSat      ( z_Temp, z_Press   )
   808        z_DQVapSatDTemp = a_CalcDQVapSatDTemp( z_Temp, z_QVapSat )
   809  
   810  
   811        do k = 1, kmax
   812  
   813          ! 飽和していたら, 温度と比湿の変化を計算
   814          ! Calculate tendency of temperature and humidity
   815          ! if moist is saturation.
   816          !
   817          if ( z_FlagProcess(k) ) then
   818  
   819            ! Liquid water and ice fractions
   820            call SaturateWatFraction(   &
   821              & z_Temp(k),              & ! (in )
   822              & WatFrac                 & ! (out)
   823              & )
   824            IceFrac = 1.0_DP - WatFrac
   825  
   826            ! 温度の変化分をニュートン法で求める
   827            ! Calculate variation of temperature
   828            !
   829            DelTemp =                                                         &
   830              &   (   LatentHeat * z_QVap(k)                                  &
   831              &     - LatentHeatFusion * z_QH2OSol(k)                         &
   832              &     + LatentHeatFusion                                        &
   833              &       * IceFrac * ( z_QVap(k) + z_QH2OLiq(k) + z_QH2OSol(k) ) &
   834              &     - ( LatentHeat + LatentHeatFusion * IceFrac )             &
   835              &       * CrtlRH * z_QVapSat(k) )                               &
   836              & / (   CpDry &
   837              &     + ( LatentHeat + LatentHeatFusion * IceFrac ) &
   838              &       * CrtlRH * z_DQVapSatDTemp(k) )
   839  
   840  
   841            ! 温度と比湿の調節
   842            ! Adjust temperature and specific humidity
   843            !
   844            z_Temp(k) = z_Temp(k) + DelTemp
   845            z_QVap(k) = &
   846              & CrtlRH * ( z_QVapSat(k) + z_DQVapSatDTemp(k) * DelTemp )
   847            z_QH2OLiq(k) = &
   848              & WatFrac &
   849              & * ( z_QH2OVapB(k) + z_QH2OLiqB(k) + z_QH2OSolB(k) - z_QVap(k) )
   850            z_QH2OSol(k) = &
   851              & IceFrac &
   852              & * ( z_QH2OVapB(k) + z_QH2OLiqB(k) + z_QH2OSolB(k) - z_QVap(k) )
   853  
   854          end if
   855  
   856        end do
   857  
   858      end do
   859  
   860  
   861      if ( FlagSatAdj ) then
   862      else
   863        ! Pre-existing cloud water and ice amount are restored.
   864        z_QH2OLiq = z_QH2OLiq + z_QH2OLiq0
   865        z_QH2OSol = z_QH2OSol + z_QH2OSol0
   866      end if
   867  
   868  
   869      ! 比湿変化率, 温度変化率, 降水量の算出
   870      ! Calculate specific humidity tendency, temperature tendency,
   871      ! precipitation
   872      !
   873      z_DTempDtLsc = ( z_Temp    - z_Temp0    ) / ( 2.0_DP * DelTime )
     .           d2 = 1.D0/(2.00000000000000e+000*deltime)                      
     .        d3 = 1.D0/(2.00000000000000e+000*deltime)                         
     .  !cdir nodep                                                             
     .        do t372 = 1, z_temp.DSC.U1                                        
     .           z_dqh2oliqdt(t372) = (z_qh2oliq(t372)-z_qh2oliq0(t372))*d2     
     .           z_dqh2osoldt(t372) = (z_qh2osol(t372)-z_qh2osol0(t372))*d3     
     .        enddo                                                             
   874      z_DQVapDtLsc = ( z_QVap    - z_QH2OVap0 ) / ( 2.0_DP * DelTime )
   875      z_DQH2OLiqDt = ( z_QH2OLiq - z_QH2OLiq0 ) / ( 2.0_DP * DelTime )
   876      z_DQH2OSolDt = ( z_QH2OSol - z_QH2OSol0 ) / ( 2.0_DP * DelTime )
   877  
   878  
   879      call LScaleCond1DConsChk(                        &
   880        & z_Temp0, z_QH2OVap0, z_QH2OLiq0, z_QH2OSol0, &
   881        & z_Temp , z_QVap    , z_QH2OLiq , z_QH2OSol   &
   882        & )
   883  
   884  
   885  !!$    ! 計算時間計測一時停止
   886  !!$    ! Pause measurement of computation time
   887  !!$    !
   888  !!$    call TimesetClockStop( module_name )
   889  
   890    end subroutine LScaleCond1D_BK
   891  
   892    !--------------------------------------------------------------------------------------
   893  
   894    subroutine LScaleCond1D(  &
   895      & z_Temp, z_QVap, z_QH2OLiq, z_QH2OSol, &  ! (inout)
   896      & z_Press, r_Press,                     &  ! (in)
   897      & z_DQH2OLiqDt, z_DQH2OSolDt            &  ! (out)
   898      & )
   899      !
   900      ! 大規模凝結スキームにより, 温度と比湿を調節します.
   901      !
   902      ! Adjust temperature and specific humidity by
   903      ! large scale condensation scheme.
   904      !
   905  
   906      ! モジュール引用 ; USE statements
   907      !
   908  
   909      ! 物理定数設定
   910      ! Physical constants settings
   911      !
   912      use constants, only: &
   913        & Grav, &
   914                                ! $ g $ [m s-2].
   915                                ! 重力加速度.
   916                                ! Gravitational acceleration
   917        & CpDry, &
   918                                ! $ C_p $ [J kg-1 K-1].
   919                                ! 乾燥大気の定圧比熱.
   920                                ! Specific heat of air at constant pressure
   921        & LatentHeat, &
   922                                ! $ L $ [J kg-1] .
   923                                ! 凝結の潜熱.
   924                                ! Latent heat of condensation
   925        & LatentHeatFusion
   926                                ! $ L $ [J kg-1] .
   927                                ! 融解の潜熱.
   928                                ! Latent heat of fusion
   929  
   930      ! 時刻管理
   931      ! Time control
   932      !
   933      use timeset, only: &
   934        & DelTime, &            ! $ \Delta t $
   935        & TimeN, &              ! ステップ $ t $ の時刻. Time of step $ t $.
   936        & TimesetClockStart, TimesetClockStop
   937  
   938      ! ヒストリデータ出力
   939      ! History data output
   940      !
   941      use gtool_historyauto, only: HistoryAutoPut
   942  
   943      ! 飽和比湿の算出
   944      ! Evaluate saturation specific humidity
   945      !
   946      use saturate, only: a_CalcQVapSat, a_CalcDQVapSatDTemp
   947  
   948  
   949      ! 宣言文 ; Declaration statements
   950      !
   951      implicit none
   952  
   953      real(DP), intent(inout):: z_Temp (1:kmax)
   954                                ! $ T $ .     温度. Temperature
   955      real(DP), intent(inout):: z_QVap (1:kmax)
   956                                ! $ q $ .     比湿. Specific humidity
   957      real(DP), intent(inout):: z_QH2OLiq(1:kmax)
   958                                ! Specific liquid water content
   959      real(DP), intent(inout):: z_QH2OSol(1:kmax)
   960                                ! Specific ice content
   961      real(DP), intent(in   ):: z_Press (1:kmax)
   962                                ! $ p $ . 気圧 (整数レベル).
   963                                ! Air pressure (full level)
   964      real(DP), intent(in   ):: r_Press (0:kmax)
   965                                ! $ \hat{p} $ . 気圧 (半整数レベル).
   966                                ! Air pressure (half level)
   967      real(DP), intent(out  ):: z_DQH2OLiqDt(1:kmax)
   968                                !
   969                                ! Tendency of H2O liquid mixing ratio
   970      real(DP), intent(out  ):: z_DQH2OSolDt(1:kmax)
   971                                !
   972                                ! Tendency of H2O ice mixing ratio
   973  
   974  
   975      ! 作業変数
   976      ! Work variables
   977      !
   978      integer:: k               ! 鉛直方向に回る DO ループ用作業変数
   979                                ! Work variables for DO loop in vertical direction
   980  
   981  
   982      ! 実行文 ; Executable statement
   983      !
   984  
   985      ! 初期化確認
   986      ! Initialization check
   987      !
   988      if ( .not. lscond_inited ) then
   989        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   990      end if
   991  
   992  
   993  !!$    ! 計算時間計測開始
   994  !!$    ! Start measurement of computation time
   995  !!$    !
   996  !!$    call TimesetClockStart( module_name )
   997  
   998  
   999      do k = 1, kmax
  1000        call LScaleCond1Grid(  &
  1001          & z_Temp(k), z_QVap(k), z_QH2OLiq(k), z_QH2OSol(k), &  ! (inout)
  1002          & z_Press(k), r_Press(k-1), r_Press(k),      &  ! (in)
  1003          & z_DQH2OLiqDt(k), z_DQH2OSolDt(k)        &  ! (out)
  1004          & )
  1005      end do
  1006  
  1007  
  1008  !!$    ! 計算時間計測一時停止
  1009  !!$    ! Pause measurement of computation time
  1010  !!$    !
  1011  !!$    call TimesetClockStop( module_name )
  1012  
  1013    end subroutine LScaleCond1D
  1014  
  1015    !--------------------------------------------------------------------------------------
  1016  
  1017    subroutine LScaleCond1Grid(  &
  1018      & Temp, QVap, QH2OLiq, QH2OSol, &  ! (inout)
  1019      & Press, PressLI, PressUI,      &  ! (in)
  1020      & DQH2OLiqDt, DQH2OSolDt        &  ! (out)
  1021      & )
  1022      !
  1023      ! 大規模凝結スキームにより, 温度と比湿を調節します.
  1024      !
  1025      ! Adjust temperature and specific humidity by
  1026      ! large scale condensation scheme.
  1027      !
  1028  
  1029      ! モジュール引用 ; USE statements
  1030      !
  1031  
  1032      ! 物理定数設定
  1033      ! Physical constants settings
  1034      !
  1035      use constants, only: &
  1036        & Grav, &
  1037                                ! $ g $ [m s-2].
  1038                                ! 重力加速度.
  1039                                ! Gravitational acceleration
  1040        & CpDry, &
  1041                                ! $ C_p $ [J kg-1 K-1].
  1042                                ! 乾燥大気の定圧比熱.
  1043                                ! Specific heat of air at constant pressure
  1044        & LatentHeat, &
  1045                                ! $ L $ [J kg-1] .
  1046                                ! 凝結の潜熱.
  1047                                ! Latent heat of condensation
  1048        & LatentHeatFusion
  1049                                ! $ L $ [J kg-1] .
  1050                                ! 融解の潜熱.
  1051                                ! Latent heat of fusion
  1052  
  1053      ! 時刻管理
  1054      ! Time control
  1055      !
  1056      use timeset, only: &
  1057        & DelTime, &            ! $ \Delta t $
  1058        & TimeN, &              ! ステップ $ t $ の時刻. Time of step $ t $.
  1059        & TimesetClockStart, TimesetClockStop
  1060  
  1061      ! ヒストリデータ出力
  1062      ! History data output
  1063      !
  1064      use gtool_historyauto, only: HistoryAutoPut
  1065  
  1066      ! 飽和比湿の算出
  1067      ! Evaluate saturation specific humidity
  1068      !
  1069      use saturate, only: CalcQVapSat, CalcDQVapSatDTemp
  1070  
  1071      ! 飽和比湿の算出
  1072      ! Evaluate saturation specific humidity
  1073      !
  1074      use saturate, only : SaturateWatFraction
  1075  
  1076  
  1077      ! 宣言文 ; Declaration statements
  1078      !
  1079      implicit none
  1080  
  1081      real(DP), intent(inout):: Temp
  1082                                ! $ T $ .     温度. Temperature
  1083      real(DP), intent(inout):: QVap
  1084                                ! $ q $ .     比湿. Specific humidity
  1085      real(DP), intent(inout):: QH2OLiq
  1086                                ! Specific liquid water content
  1087      real(DP), intent(inout):: QH2OSol
  1088                                ! Specific ice content
  1089      real(DP), intent(in   ):: Press
  1090                                ! $ p $ . 気圧 (整数レベル).
  1091                                ! Air pressure (full level)
  1092      real(DP), intent(in   ):: PressLI
  1093                                ! $ \hat{p} $ . 気圧 (半整数レベル).
  1094                                ! Air pressure (half level)
  1095      real(DP), intent(in   ):: PressUI
  1096                                ! $ \hat{p} $ . 気圧 (半整数レベル).
  1097                                ! Air pressure (half level)
  1098      real(DP), intent(out  ):: DQH2OLiqDt
  1099                                !
  1100                                ! Tendency of H2O liquid mixing ratio
  1101      real(DP), intent(out  ):: DQH2OSolDt
  1102                                !
  1103                                ! Tendency of H2O ice mixing ratio
  1104  
  1105  
  1106      ! 作業変数
  1107      ! Work variables
  1108      !
  1109      real(DP):: DTempDtLsc
  1110                                ! 温度変化率.
  1111                                ! Temperature tendency
  1112      real(DP):: DQVapDtLsc
  1113                                ! 比湿変化率.
  1114                                ! Specific humidity tendency
  1115  
  1116      real(DP):: QH2OVap0
  1117                                ! 調節前の比湿.
  1118                                ! Specific humidity before adjust.
  1119      real(DP):: QH2OLiq0
  1120                                !
  1121                                ! Specific liquid water content before adjust.
  1122      real(DP):: QH2OSol0
  1123                                !
  1124                                ! Specific liquid water content before adjust.
  1125      real(DP):: Temp0
  1126                                ! 調節前の温度.
  1127                                ! Temperature before adjust.
  1128                                !
  1129      real(DP):: QH2OVapB
  1130                                ! 調節前の比湿.
  1131                                ! Specific humidity before adjust.
  1132      real(DP):: QH2OLiqB
  1133                                !
  1134                                ! Specific liquid water content before adjust.
  1135      real(DP):: QH2OSolB
  1136                                !
  1137                                ! Specific liquid water content before adjust.
  1138      real(DP):: TempB
  1139                                ! 調節前の温度.
  1140                                ! Temperature before adjust.
  1141                                !
  1142      real(DP):: QVapSat
  1143                                ! 飽和比湿.
  1144                                ! Saturation specific humidity.
  1145      real(DP):: DQVapSatDTemp
  1146                                ! $ \DD{q_{\rm{sat}}}{T} $
  1147      real(DP):: DelTemp
  1148                                ! 調節による温度変化量.
  1149                                ! Temperature variation by adjustment
  1150  
  1151      real(DP) :: WatFrac
  1152      real(DP) :: IceFrac
  1153  
  1154  
  1155      integer:: itr             ! イテレーション方向に回る DO ループ用作業変数
  1156                                ! Work variables for DO loop in iteration direction
  1157      logical:: FlagProcess
  1158  
  1159  
  1160      ! 実行文 ; Executable statement
  1161      !
  1162  
  1163      ! 初期化確認
  1164      ! Initialization check
  1165      !
  1166      if ( .not. lscond_inited ) then
  1167        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
  1168      end if
  1169  
  1170  
  1171  !!$    ! 計算時間計測開始
  1172  !!$    ! Start measurement of computation time
  1173  !!$    !
  1174  !!$    call TimesetClockStart( module_name )
  1175  
  1176  
  1177      ! 調節前 "QVap", "Temp" の保存
  1178      ! Store "QVap", "Temp" before adjustment
  1179      !
  1180      QH2OVap0 = QVap
  1181      QH2OLiq0 = QH2OLiq
  1182      QH2OSol0 = QH2OSol
  1183      Temp0    = Temp
  1184  
  1185  
  1186      ! 調節
  1187      ! Adjustment
  1188      !
  1189  
  1190      ! 飽和比湿計算
  1191      ! Calculate saturation specific humidity
  1192      !
  1193  
  1194      if ( FlagSatAdj ) then
  1195        Temp = Temp &
  1196          & + ( LatentHeat * QH2OLiq + ( LatentHeat + LatentHeatFusion ) * QH2OSol ) / CpDry
  1197        QVap    = QVap + QH2OLiq + QH2OSol
  1198        QH2OLiq = 0.0_DP
  1199        QH2OSol = 0.0_DP
  1200      else
  1201        ! Pre-existing cloud water and ice are removed, since those are not
  1202        ! responsible with condensation (assumption).
  1203        QH2OLiq = 0.0_DP
  1204        QH2OSol = 0.0_DP
  1205      end if
  1206      !
  1207      QVapSat = CalcQVapSat( Temp, Press )
  1208      !
  1209      if ( ( QVap / QVapSat ) >= CrtlRH ) then
  1210        FlagProcess = .true.
  1211      else
  1212        FlagProcess = .false.
  1213      end if
  1214  
  1215  
  1216      do itr = 1, ItrtMax
  1217  
  1218        QH2OVapB = QVap
  1219        QH2OLiqB = QH2OLiq
  1220        QH2OSolB = QH2OSol
  1221        TempB    = Temp
  1222  
  1223        ! 飽和比湿計算
  1224        ! Calculate saturation specific humidity
  1225        !
  1226        QVapSat       = CalcQVapSat      ( Temp, Press   )
  1227        DQVapSatDTemp = CalcDQVapSatDTemp( Temp, QVapSat )
  1228  
  1229  
  1230        ! 飽和していたら, 温度と比湿の変化を計算
  1231        ! Calculate tendency of temperature and humidity
  1232        ! if moist is saturation.
  1233        !
  1234        if ( FlagProcess ) then
  1235  
  1236          ! Liquid water and ice fractions
  1237          call SaturateWatFraction(   &
  1238            & Temp,                   & ! (in )
  1239            & WatFrac                 & ! (out)
  1240            & )
  1241          IceFrac = 1.0_DP - WatFrac
  1242  
  1243          ! 温度の変化分をニュートン法で求める
  1244          ! Calculate variation of temperature
  1245          !
  1246  !!$          DelTemp =                                                 &
  1247  !!$            & LatentHeatLocal                                       &
  1248  !!$            &   * ( z_QVap(k) - CrtlRH * z_QVapSat(k) )             &
  1249  !!$            &   / ( CpDry + LatentHeatLocal * CrtlRH * z_DQVapSatDTemp(k) )
  1250          DelTemp =                                                         &
  1251            &   (   LatentHeat * QVap                                  &
  1252            &     - LatentHeatFusion * QH2OSol                         &
  1253            &     + LatentHeatFusion                                        &
  1254            &       * IceFrac * ( QVap + QH2OLiq + QH2OSol ) &
  1255            &     - ( LatentHeat + LatentHeatFusion * IceFrac )             &
  1256            &       * CrtlRH * QVapSat )                               &
  1257            & / (   CpDry &
  1258            &     + ( LatentHeat + LatentHeatFusion * IceFrac ) &
  1259            &       * CrtlRH * DQVapSatDTemp )
  1260  
  1261  
  1262          ! 温度と比湿の調節
  1263          ! Adjust temperature and specific humidity
  1264          !
  1265          Temp = Temp + DelTemp
  1266          QVap = &
  1267            & CrtlRH * ( QVapSat + DQVapSatDTemp * DelTemp )
  1268          QH2OLiq = &
  1269            & WatFrac &
  1270            & * ( QH2OVapB + QH2OLiqB + QH2OSolB - QVap )
  1271          QH2OSol = &
  1272            & IceFrac &
  1273            & * ( QH2OVapB + QH2OLiqB + QH2OSolB - QVap )
  1274  
  1275        end if
  1276  
  1277      end do
  1278  
  1279  
  1280      if ( FlagSatAdj ) then
  1281      else
  1282        ! Pre-existing cloud water and ice amount are restored.
  1283        QH2OLiq = QH2OLiq + QH2OLiq0
  1284        QH2OSol = QH2OSol + QH2OSol0
  1285      end if
  1286  
  1287  
  1288      ! 比湿変化率, 温度変化率, 降水量の算出
  1289      ! Calculate specific humidity tendency, temperature tendency,
  1290      ! precipitation
  1291      !
  1292      DTempDtLsc = ( Temp    - Temp0    ) / ( 2.0_DP * DelTime )
  1293      DQVapDtLsc = ( QVap    - QH2OVap0 ) / ( 2.0_DP * DelTime )
  1294      DQH2OLiqDt = ( QH2OLiq - QH2OLiq0 ) / ( 2.0_DP * DelTime )
  1295      DQH2OSolDt = ( QH2OSol - QH2OSol0 ) / ( 2.0_DP * DelTime )
  1296  
  1297  
  1298      call LScaleCond1GridConsChk(             &
  1299        & Temp0, QH2OVap0, QH2OLiq0, QH2OSol0, &
  1300        & Temp , QVap    , QH2OLiq , QH2OSol   &
  1301        & )
  1302  
  1303  
  1304  !!$    ! 計算時間計測一時停止
  1305  !!$    ! Pause measurement of computation time
  1306  !!$    !
  1307  !!$    call TimesetClockStop( module_name )
  1308  
  1309    end subroutine LScaleCond1Grid
  1310  
  1311    !--------------------------------------------------------------------------------------
  1312  
  1313    subroutine LScaleCondLL911D3DWrapper(             &
  1314      & xyz_Temp, xyz_QVap, xyz_QH2OLiq, xyz_QH2OSol, &  ! (inout)
  1315      & xyz_Press, xyr_Press,                         &  ! (in)
  1316      & xyz_DQH2OLiqDt, xyz_DQH2OSolDt,               &  ! (out)
  1317      & xyz_CloudCover,                               &  ! (out)optional
  1318      & FlagOutput                                    &  ! (in) optional
  1319      & )
  1320      !
  1321      ! 大規模凝結スキームにより, 温度と比湿を調節します.
  1322      !
  1323      ! Adjust temperature and specific humidity by
  1324      ! large scale condensation scheme.
  1325      !
  1326  
  1327      ! モジュール引用 ; USE statements
  1328      !
  1329  
  1330      ! OpenMP
  1331      !
  1332      !$ use omp_lib
  1333  
  1334      ! 物理定数設定
  1335      ! Physical constants settings
  1336      !
  1337      use constants, only: &
  1338        & Grav
  1339                                ! $ g $ [m s-2].
  1340                                ! 重力加速度.
  1341                                ! Gravitational acceleration
  1342  
  1343      ! 時刻管理
  1344      ! Time control
  1345      !
  1346      use timeset, only: &
  1347        & DelTime, &            ! $ \Delta t $
  1348        & TimeN, &              ! ステップ $ t $ の時刻. Time of step $ t $.
  1349        & TimesetClockStart, TimesetClockStop
  1350  
  1351      ! ヒストリデータ出力
  1352      ! History data output
  1353      !
  1354      use gtool_historyauto, only: HistoryAutoPut
  1355  
  1356  
  1357      ! 宣言文 ; Declaration statements
  1358      !
  1359      implicit none
  1360  
  1361      real(DP), intent(inout):: xyz_Temp (0:imax-1, 1:jmax, 1:kmax)
  1362                                ! $ T $ .     温度. Temperature
  1363      real(DP), intent(inout):: xyz_QVap (0:imax-1, 1:jmax, 1:kmax)
  1364                                ! $ q $ .     比湿. Specific humidity
  1365      real(DP), intent(inout):: xyz_QH2OLiq(0:imax-1, 1:jmax, 1:kmax)
  1366                                ! Specific liquid water content
  1367      real(DP), intent(inout):: xyz_QH2OSol(0:imax-1, 1:jmax, 1:kmax)
  1368                                ! Specific ice content
  1369      real(DP), intent(in):: xyz_Press (0:imax-1, 1:jmax, 1:kmax)
  1370                                ! $ p $ . 気圧 (整数レベル).
  1371                                ! Air pressure (full level)
  1372      real(DP), intent(in):: xyr_Press (0:imax-1, 1:jmax, 0:kmax)
  1373                                ! $ \hat{p} $ . 気圧 (半整数レベル).
  1374                                ! Air pressure (half level)
  1375      real(DP), intent(out) :: xyz_DQH2OLiqDt(0:imax-1,1:jmax,1:kmax)
  1376                                !
  1377                                ! Tendency of H2O liquid mixing ratio
  1378      real(DP), intent(out) :: xyz_DQH2OSolDt(0:imax-1,1:jmax,1:kmax)
  1379                                !
  1380                                ! Tendency of H2O ice mixing ratio
  1381      real(DP), intent(out), optional :: xyz_CloudCover(0:imax-1, 1:jmax, 1:kmax)
  1382                                !
  1383                                ! Cloud cover
  1384      logical , intent(in ), optional :: FlagOutput
  1385                                !
  1386                                ! Flag for output
  1387  
  1388  
  1389      ! 作業変数
  1390      ! Work variables
  1391      !
  1392      integer :: js
  1393      integer :: je
  1394  
  1395      integer :: nthreads
  1396      integer, allocatable :: a_js(:)
  1397      integer, allocatable :: a_je(:)
  1398  
  1399      real(DP):: xyz_TempB (0:imax-1, 1:jmax, 1:kmax)
  1400                                ! $ T $ .     温度. Temperature
  1401      real(DP):: xyz_QVapB (0:imax-1, 1:jmax, 1:kmax)
  1402                                ! $ q $ .     比湿. Specific humidity
  1403  
  1404      real(DP):: xy_RainLsc (0:imax-1, 1:jmax)
  1405                                ! 降水量.
  1406                                ! Precipitation
  1407  
  1408      real(DP):: xyz_DTempDtLsc (0:imax-1, 1:jmax, 1:kmax)
  1409                                ! 温度変化率.
  1410                                ! Temperature tendency
  1411      real(DP):: xyz_DQVapDtLsc (0:imax-1, 1:jmax, 1:kmax)
  1412                                ! 比湿変化率.
  1413                                ! Specific humidity tendency
  1414  
  1415      real(DP) :: z_Temp (1:kmax)
  1416                                ! $ T $ .     温度. Temperature
  1417      real(DP) :: z_QVap (1:kmax)
  1418                                ! $ q $ .     比湿. Specific humidity
  1419      real(DP) :: z_QH2OLiq(1:kmax)
  1420                                ! Specic liquid water content
  1421      real(DP) :: z_QH2OSol(1:kmax)
  1422                                ! Specic ice content
  1423      real(DP) :: z_Press (1:kmax)
  1424                                ! $ p $ . 気圧 (整数レベル).
  1425                                ! Air pressure (full level)
  1426      real(DP) :: r_Press (0:kmax)
  1427                                ! $ \hat{p} $ . 気圧 (半整数レベル).
  1428                                ! Air pressure (half level)
  1429      real(DP) :: z_DQH2OLiqDt(1:kmax)
  1430                                !
  1431                                ! Tendency of H2O liquid mixing ratio
  1432      real(DP) :: z_DQH2OSolDt(1:kmax)
  1433                                !
  1434                                ! Tendency of H2O ice mixing ratio
  1435  
  1436      real(DP) :: z_CloudCover(1:kmax)
  1437  
  1438  
  1439      integer:: i               ! 経度方向に回る DO ループ用作業変数
  1440                                ! Work variables for DO loop in longitude
  1441      integer:: j               ! 緯度方向に回る DO ループ用作業変数
  1442                                ! Work variables for DO loop in latitude
  1443      integer:: k               ! 鉛直方向に回る DO ループ用作業変数
  1444                                ! Work variables for DO loop in vertical direction
  1445      integer :: n
  1446  
  1447  
  1448      ! 実行文 ; Executable statement
  1449      !
  1450  
  1451      ! 初期化確認
  1452      ! Initialization check
  1453      !
  1454      if ( .not. lscond_inited ) then
  1455        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
  1456      end if
  1457  
  1458  
  1459      ! 計算時間計測開始
  1460      ! Start measurement of computation time
  1461      !
  1462      call TimesetClockStart( module_name )
  1463  
  1464  
  1465      nthreads = 1
  1466      !$ nthreads  = omp_get_max_threads()
  1467  !!$    !$ write( 6, * ) "Number of processors : ", omp_get_num_procs()
  1468  !!$    !$ write( 6, * ) "Number of threads    : ", nthreads
  1469  
  1470      allocate( a_js(0:nthreads-1) )
  1471      allocate( a_je(0:nthreads-1) )
  1472  
  1473      do n = 0, nthreads-1
  1474  
  1475        if ( n == 0 ) then
  1476          a_js(n) = 1
  1477        else
  1478          a_js(n) = a_je(n-1) + 1
  1479        end if
  1480  
  1481        a_je(n) = a_js(n  ) + jmax / nthreads - 1
  1482        if ( n + 1 <= mod( jmax, nthreads ) ) then
  1483          a_je(n) = a_je(n) + 1
  1484        end if
  1485  
  1486      end do
  1487  
  1488  
  1489  !!$    !$OMP PARALLEL DEFAULT(PRIVATE) &
  1490  !!$    !$OMP SHARED( &
  1491  !!$    !$OMP         nthreads, a_js, a_je, &
  1492  !!$    !$OMP         imax, kmax, &
  1493  !!$    !$OMP         xyz_TempB, xyz_QVapB, &
  1494  !!$    !$OMP         xyz_Temp, xyz_QVap, xyz_QH2OLiq, xyz_QH2OSol, &
  1495  !!$    !$OMP         xyz_Press, xyr_Press, &
  1496  !!$    !$OMP         xyz_DQH2OLiqDt, xyz_DQH2OSolDt, &
  1497  !!$    !$OMP         xyz_CloudCover, &
  1498  !!$    !$OMP         xy_RainLsc, xyz_DTempDtLsc, xyz_DQVapDtLsc, DelTime &
  1499  !!$    !$OMP       )
  1500  !!$
  1501  !!$    !$OMP DO
  1502  
  1503      do n = 0, nthreads-1
  1504  
  1505        js = a_js(n)
  1506        je = a_je(n)
  1507  
  1508        if ( js > je ) cycle
  1509  
  1510  
  1511        do k = 1, kmax
  1512          do j = js, je
  1513            xyz_TempB(:,j,k) = xyz_Temp(:,j,k)
  1514            xyz_QVapB(:,j,k) = xyz_QVap(:,j,k)
  1515          end do
  1516        end do
  1517  
  1518        do j = js, je
  1519          do i = 0, imax-1
  1520  
  1521            do k = 1, kmax
  1522              z_Temp   (k) = xyz_Temp   (i,j,k)
  1523              z_QVap   (k) = xyz_QVap   (i,j,k)
  1524              z_QH2OLiq(k) = xyz_QH2OLiq(i,j,k)
  1525              z_QH2OSol(k) = xyz_QH2OSol(i,j,k)
  1526              z_Press  (k) = xyz_Press  (i,j,k)
  1527            end do
  1528            do k = 0, kmax
  1529              r_Press  (k) = xyr_Press  (i,j,k)
  1530            end do
  1531  
  1532            call LScaleCondLL911D(                    &
  1533              & z_Temp, z_QVap, z_QH2OLiq, z_QH2OSol, &  ! (inout)
  1534              & z_Press, r_Press,                     &  ! (in)
  1535              & z_DQH2OLiqDt, z_DQH2OSolDt,           &  ! (out)
  1536              & z_CloudCover                          &  ! (out)
  1537              & )
  1538  
  1539            do k = 1, kmax
  1540              xyz_Temp      (i,j,k) = z_Temp      (k)
  1541              xyz_QVap      (i,j,k) = z_QVap      (k)
  1542              xyz_QH2OLiq   (i,j,k) = z_QH2OLiq   (k)
  1543              xyz_QH2OSol   (i,j,k) = z_QH2OSol   (k)
  1544              xyz_DQH2OLiqDt(i,j,k) = z_DQH2OLiqDt(k)
  1545              xyz_DQH2OSolDt(i,j,k) = z_DQH2OSolDt(k)
  1546            end do
  1547            if ( present( xyz_CloudCover ) ) then
  1548              do k = 1, kmax
  1549                xyz_CloudCover(i,j,k) = z_CloudCover(k)
  1550              end do
  1551            end if
  1552  
  1553          end do
  1554        end do
  1555  
  1556  
  1557        ! calculation for output
  1558        do j = js, je
  1559          xy_RainLsc(:,j)     = 0.0_DP
  1560          do k = kmax, 1, -1
  1561            xy_RainLsc(:,j) = xy_RainLsc(:,j)                                     &
  1562              & + xyz_DQH2OLiqDt(:,j,k) * ( xyr_Press(:,j,k-1) - xyr_Press(:,j,k) ) / Grav
  1563          end do
  1564        end do
  1565  
  1566        do k = 1, kmax
  1567          do j = js, je
  1568            xyz_DTempDtLsc(:,j,k) = ( xyz_Temp(:,j,k) - xyz_TempB(:,j,k) ) / ( 2.0_DP * DelTime )
  1569            xyz_DQVapDtLsc(:,j,k) = ( xyz_QVap(:,j,k) - xyz_QVapB(:,j,k) ) / ( 2.0_DP * DelTime )
  1570          end do
  1571        end do
  1572  
  1573      end do
     .        js = a_js(0)                                                      
     .        je = a_je(0)                                                      
     .        if (js .gt. je) goto 31051                                        
     .        do k = 1, kmax                                                    
     .  !cdir    nodep                                                          
     .  !cdir    noassume                                                       
     .           do j = 1, (je + 1 - js)*(xyz_tempb.DSC.U1 + 1)                 
     .              xyz_tempb(j-1,js,k) = xyz_temp(j-1,js,k)                    
     .              xyz_qvapb(j-1,js,k) = xyz_qvap(j-1,js,k)                    
     .           enddo                                                          
     .        enddo                                                             
     .        do j = js, je                                                     
     .           do i = 0, imax - 1                                             
     .  !cdir       nodep                                                       
     .              do k = 1, kmax                                              
     .                 z_temp(k) = xyz_temp(i,j,k)                              
     .                 z_qvap(k) = xyz_qvap(i,j,k)                              
     .                 z_qh2oliq(k) = xyz_qh2oliq(i,j,k)                        
     .                 z_qh2osol(k) = xyz_qh2osol(i,j,k)                        
     .                 z_press(k) = xyz_press(i,j,k)                            
     .              enddo                                                       
     .  !cdir       nodep                                                       
     .              do k = 0, kmax                                              
     .                 r_press(k) = xyr_press(i,j,k)                            
     .              enddo                                                       
     .              call lscalecondll911d (z_temp, z_qvap, z_qh2oliq, z_qh2osol 
     .       1         , z_press, r_press, z_dqh2oliqdt, z_dqh2osoldt,          
     .       2         z_cloudcover)                                            
     .  !cdir       nodep                                                       
     .              do k = 1, kmax                                              
     .                 xyz_temp(i,j,k) = z_temp(k)                              
     .                 xyz_qvap(i,j,k) = z_qvap(k)                              
     .                 xyz_qh2oliq(i,j,k) = z_qh2oliq(k)                        
     .                 xyz_qh2osol(i,j,k) = z_qh2osol(k)                        
     .                 xyz_dqh2oliqdt(i,j,k) = z_dqh2oliqdt(k)                  
     .                 xyz_dqh2osoldt(i,j,k) = z_dqh2osoldt(k)                  
     .              enddo                                                       
     .              t472 = cvmgt(0,1,loc(xyz_cloudcover).eq.1)                  
     .              if (t472 .eq. 0) goto 31052                                 
     .  !cdir       nodep                                                       
     .              do k = 1, kmax                                              
     .                 xyz_cloudcover(i,j,k) = z_cloudcover(k)                  
     .              enddo                                                       
     .  31052       continue                                                    
     .           enddo                                                          
     .        enddo                                                             
     .        do j = js, je                                                     
     .  !cdir    nodep                                                          
     .           do t639 = 0, xy_rainlsc.DSC.U1                                 
     .              xy_rainlsc(t639,j) = 0.0000000000000000e+000                
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .  !cdir    noassume                                                       
     .           do t6421 = 0, xy_rainlsc.DSC.U1, maxvl()                       
     .              t6422 = min0(xy_rainlsc.DSC.U1 + 1 - t6421,maxvl())         
     .              if (kmax .gt. 0) then                                       
     .                 j1 = and(kmax,3)                                         
     .                 do k = 1, j1                                             
     .                    d1 = 1.D0/grav                                        
     .  !cdir             shortloop                                             
     .  !cdir             nodep                                                 
     .  !cdir             on_adb(xy_rainlsc,xyr_press)                          
     .                    do t642 = 1, t6422                                    
     .                       xy_rainlsc(t6421+t642-1,j) = xy_rainlsc(t6421+t642-
     .       1                  1,j) + xyz_dqh2oliqdt(t6421+t642-1,j,kmax+1-k)*(
     .       2                  xyr_press(t6421+t642-1,j,kmax-k)-xyr_press(t6421
     .       3                  +t642-1,j,kmax+1-k))*d1                         
     .                    enddo                                                 
     .                 enddo                                                    
     .                 do k = j1 + 1, kmax, 4                                   
     .                    d2 = 1.D0/grav                                        
     .                    d3 = 1.D0/grav                                        
     .                    d4 = 1.D0/grav                                        
     .                    d5 = 1.D0/grav                                        
     .  !cdir             shortloop                                             
     .  !cdir             nodep                                                 
     .  !cdir             on_adb(xy_rainlsc,xyr_press)                          
     .                    do t642 = 1, t6422                                    
     .                       xy_rainlsc(t6421+t642-1,j) = xy_rainlsc(t6421+t642-
     .       1                  1,j) + xyz_dqh2oliqdt(t6421+t642-1,j,kmax+1-k)*(
     .       2                  xyr_press(t6421+t642-1,j,kmax-k)-xyr_press(t6421
     .       3                  +t642-1,j,kmax+1-k))*d2 + xyz_dqh2oliqdt(t6421+ 
     .       4                  t642-1,j,kmax-k)*(xyr_press(t6421+t642-1,j,kmax-
     .       5                  1-k)-xyr_press(t6421+t642-1,j,kmax-k))*d3 +     
     .       6                  xyz_dqh2oliqdt(t6421+t642-1,j,kmax-1-k)*(       
     .       7                  xyr_press(t6421+t642-1,j,kmax-2-k)-xyr_press(   
     .       8                  t6421+t642-1,j,kmax-1-k))*d4 + xyz_dqh2oliqdt(  
     .       9                  t6421+t642-1,j,kmax-2-k)*(xyr_press(t6421+t642-1
     .       .                  ,j,kmax-3-k)-xyr_press(t6421+t642-1,j,kmax-2-k))
     .       1                  *d5                                             
     .                    enddo                                                 
     .                 enddo                                                    
     .              endif                                                       
     .           enddo                                                          
     .        enddo                                                             
     .        do k = 1, kmax                                                    
     .           d6 = 1.D0/(2.00000000000000e+000*deltime)                      
     .           d7 = 1.D0/(2.00000000000000e+000*deltime)                      
     .  !cdir    nodep                                                          
     .  !cdir    noassume                                                       
     .           do j = 1, imax - (js - je)*imax                                
     .              xyz_dtempdtlsc(j-1,js,k) = (xyz_temp(j-1,js,k)-xyz_tempb(j-1
     .       1         ,js,k))*d6                                               
     .              xyz_dqvapdtlsc(j-1,js,k) = (xyz_qvap(j-1,js,k)-xyz_qvapb(j-1
     .       1         ,js,k))*d7                                               
     .           enddo                                                          
     .        enddo                                                             
     .  31051 continue                                                          
  1574  
  1575  !!$    !$OMP END DO
  1576  !!$    !$OMP END PARALLEL
  1577  
  1578  
  1579      deallocate( a_js )
  1580      deallocate( a_je )
  1581  
  1582  
  1583      ! ヒストリデータ出力
  1584      ! History data output
  1585      !
  1586      if ( .not. present( FlagOutput ) ) then
  1587        call HistoryAutoPut( TimeN, 'DTempDtLsc'   , xyz_DTempDtLsc )
  1588        call HistoryAutoPut( TimeN, 'DQH2OVapDtLsc', xyz_DQVapDtLsc )
  1589        call HistoryAutoPut( TimeN, 'DQH2OLiqDtLsc', xyz_DQH2OLiqDt )
  1590        call HistoryAutoPut( TimeN, 'DQH2OSolDtLsc', xyz_DQH2OSolDt )
  1591      else
  1592        if ( FlagOutput ) then
  1593          call HistoryAutoPut( TimeN, 'DTempDtLsc'   , xyz_DTempDtLsc )
  1594          call HistoryAutoPut( TimeN, 'DQH2OVapDtLsc', xyz_DQVapDtLsc )
  1595          call HistoryAutoPut( TimeN, 'DQH2OLiqDtLsc', xyz_DQH2OLiqDt )
  1596          call HistoryAutoPut( TimeN, 'DQH2OSolDtLsc', xyz_DQH2OSolDt )
  1597        end if
  1598      end if
  1599  
  1600  
  1601      ! 計算時間計測一時停止
  1602      ! Pause measurement of computation time
  1603      !
  1604      call TimesetClockStop( module_name )
  1605  
  1606    end subroutine LScaleCondLL911D3DWrapper
  1607  
  1608    !--------------------------------------------------------------------------------------
  1609  
  1610    subroutine LScaleCondLL911D(  &
  1611      & z_Temp, z_QH2OVap, z_QH2OLiq, z_QH2OSol, &  ! (inout)
  1612      & z_Press, r_Press,                        &  ! (in)
  1613      & z_DQH2OLiqDt, z_DQH2OSolDt,              &  ! (out)
  1614      & z_CloudCover                             &  ! (out)
  1615      & )
  1616      !
  1617      ! 大規模凝結スキームにより, 温度と比湿を調節します.
  1618      !
  1619      ! Adjust temperature and specific humidity by
  1620      ! large scale condensation scheme.
  1621      !
  1622  
  1623      ! モジュール引用 ; USE statements
  1624      !
  1625  
  1626      ! 物理定数設定
  1627      ! Physical constants settings
  1628      !
  1629      use constants, only: &
  1630        & Grav, &
  1631                                ! $ g $ [m s-2].
  1632                                ! 重力加速度.
  1633                                ! Gravitational acceleration
  1634        & CpDry, &
  1635                                ! $ C_p $ [J kg-1 K-1].
  1636                                ! 乾燥大気の定圧比熱.
  1637                                ! Specific heat of air at constant pressure
  1638        & LatentHeat, &
  1639                                ! $ L $ [J kg-1] .
  1640                                ! 凝結の潜熱.
  1641                                ! Latent heat of condensation
  1642        & LatentHeatFusion
  1643                                ! $ L $ [J kg-1] .
  1644                                ! 融解の潜熱.
  1645                                ! Latent heat of fusion
  1646  
  1647      ! 時刻管理
  1648      ! Time control
  1649      !
  1650      use timeset, only: &
  1651        & DelTime, &            ! $ \Delta t $
  1652        & TimeN, &              ! ステップ $ t $ の時刻. Time of step $ t $.
  1653        & TimesetClockStart, TimesetClockStop
  1654  
  1655      ! ヒストリデータ出力
  1656      ! History data output
  1657      !
  1658      use gtool_historyauto, only: HistoryAutoPut
  1659  
  1660      ! 飽和比湿の算出
  1661      ! Evaluate saturation specific humidity
  1662      !
  1663      use saturate, only: a_CalcQVapSat, a_CalcDQVapSatDTemp
  1664  
  1665      ! 飽和比湿の算出
  1666      ! Evaluate saturation specific humidity
  1667      !
  1668      use saturate, only : SaturateWatFraction
  1669  
  1670  
  1671      ! 宣言文 ; Declaration statements
  1672      !
  1673      implicit none
  1674  
  1675      real(DP), intent(inout):: z_Temp (1:kmax)
  1676                                ! $ T $ .     温度. Temperature
  1677      real(DP), intent(inout):: z_QH2OVap (1:kmax)
  1678                                ! $ q $ .     比湿. Specific humidity
  1679      real(DP), intent(inout):: z_QH2OLiq(1:kmax)
  1680                                ! Specific liquid water content
  1681      real(DP), intent(inout):: z_QH2OSol(1:kmax)
  1682                                ! Specific ice content
  1683      real(DP), intent(in   ):: z_Press (1:kmax)
  1684                                ! $ p $ . 気圧 (整数レベル).
  1685                                ! Air pressure (full level)
  1686      real(DP), intent(in   ):: r_Press (0:kmax)
  1687                                ! $ \hat{p} $ . 気圧 (半整数レベル).
  1688                                ! Air pressure (half level)
  1689      real(DP), intent(out  ):: z_DQH2OLiqDt(1:kmax)
  1690                                !
  1691                                ! Tendency of H2O liquid mixing ratio
  1692      real(DP), intent(out  ):: z_DQH2OSolDt(1:kmax)
  1693                                !
  1694                                ! Tendency of H2O ice mixing ratio
  1695      real(DP), intent(out  ):: z_CloudCover(1:kmax)
  1696  
  1697  
  1698      ! 作業変数
  1699      ! Work variables
  1700      !
  1701      real(DP):: z_DTempDtLsc (1:kmax)
  1702                                ! 温度変化率.
  1703                                ! Temperature tendency
  1704      real(DP):: z_DQH2OVapDtLsc (1:kmax)
  1705                                ! 比湿変化率.
  1706                                ! Specific humidity tendency
  1707  
  1708      real(DP):: z_QH2OTot  (1:kmax)
  1709                                ! 調節前の水量.
  1710                                ! Specific water content before adjust.
  1711  
  1712      real(DP):: z_QH2OVap0 (1:kmax)
  1713                                ! 調節前の比湿.
  1714                                ! Specific humidity before adjust.
  1715      real(DP):: z_QH2OLiq0 (1:kmax)
  1716                                !
  1717                                ! Specific liquid water content before adjust.
  1718      real(DP):: z_QH2OSol0 (1:kmax)
  1719                                !
  1720                                ! Specific liquid water content before adjust.
  1721      real(DP):: z_Temp0    (1:kmax)
  1722                                ! 調節前の温度.
  1723                                ! Temperature before adjust.
  1724                                !
  1725      real(DP):: z_QH2OVapB (1:kmax)
  1726                                ! 調節前の比湿.
  1727                                ! Specific humidity before adjust.
  1728      real(DP):: z_QH2OLiqB (1:kmax)
  1729                                !
  1730                                ! Specific liquid water content before adjust.
  1731      real(DP):: z_QH2OSolB (1:kmax)
  1732                                !
  1733                                ! Specific liquid water content before adjust.
  1734      real(DP):: z_TempB    (1:kmax)
  1735                                ! 調節前の温度.
  1736                                ! Temperature before adjust.
  1737                                !
  1738      real(DP):: z_QH2OVapSat      (1:kmax)
  1739                                ! 飽和比湿.
  1740                                ! Saturation specific humidity.
  1741      real(DP):: z_DQH2OVapSatDTemp(1:kmax)
  1742                                ! $ \DD{q_{\rm{sat}}}{T} $
  1743      real(DP):: DelTemp
  1744                                ! 調節による温度変化量.
  1745                                ! Temperature variation by adjustment
  1746  
  1747      real(DP) :: CoefA
  1748      real(DP) :: CoefB
  1749      real(DP) :: QH2OCond
  1750  
  1751      real(DP):: z_QH2OTotFluc(1:kmax)
  1752  
  1753      real(DP) :: WatFrac
  1754      real(DP) :: IceFrac
  1755  
  1756      real(DP) :: QH2OVapSat
  1757  
  1758      integer:: k               ! 鉛直方向に回る DO ループ用作業変数
  1759                                ! Work variables for DO loop in vertical direction
  1760      integer:: itr             ! イテレーション方向に回る DO ループ用作業変数
  1761                                ! Work variables for DO loop in iteration direction
  1762      logical:: z_FlagProcess(1:kmax)
  1763  
  1764  
  1765      ! 実行文 ; Executable statement
  1766      !
  1767  
  1768      ! 初期化確認
  1769      ! Initialization check
  1770      !
  1771      if ( .not. lscond_inited ) then
  1772        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
  1773      end if
  1774  
  1775  
  1776  !!$    ! 計算時間計測開始
  1777  !!$    ! Start measurement of computation time
  1778  !!$    !
  1779  !!$    call TimesetClockStart( module_name )
  1780  
  1781  
  1782      ! 調節前 "QH2OVap", "Temp" の保存
  1783      ! Store "QH2OVap", "Temp" before adjustment
  1784      !
  1785      z_QH2OVap0 = z_QH2OVap
  1786      z_QH2OLiq0 = z_QH2OLiq
  1787      z_QH2OSol0 = z_QH2OSol
  1788      z_Temp0    = z_Temp
  1789  
  1790      ! 調節
  1791      ! Adjustment
  1792      !
  1793  
  1794      z_QH2OTot     = z_QH2OVap + z_QH2OLiq + z_QH2OSol
  1795      z_QH2OTotFluc = QH2OFlucRatio * z_QH2OTot
  1796  
  1797      ! 飽和比湿計算
  1798      ! Calculate saturation specific humidity
  1799      !
  1800  !!$    z_QH2OVapSat = a_CalcQVapSat( z_Temp, z_Press )
  1801  !!$    !
  1802  !!$    do k = 1, kmax
  1803  !!$      if ( &
  1804  !!$        &  ( z_QH2OVapSat(k) <= ( z_QH2OTot(k) + z_QH2OTotFluc(k) ) ) &
  1805  !!$        &  .or. &
  1806  !!$        &  ( ( z_QH2OVap(k) < z_QH2OVapSat(k) ) .and. &
  1807  !!$        &    ( z_QH2OLiq(k) + z_QH2OLiq(k) > 0.0_DP ) ) &
  1808  !!$        & ) then
  1809  !!$        z_FlagProcess(k) = .true.
  1810  !!$      else
  1811  !!$        z_FlagProcess(k) = .false.
  1812  !!$      end if
  1813  !!$    end do
  1814  
  1815      z_FlagProcess = .true.
  1816  
  1817  
  1818      do itr = 1, ItrtMax
  1819  
  1820        z_QH2OVapB = z_QH2OVap
     .  !cdir    nodep                                                          
     .        do t379 = 1, 1 + z_qh2ovapb.DSC.U1 - min0(1,z_qh2ovapb.DSC.U1)    
     .           z_qh2ovapsat(t379) = %000336(t379)                             
     .        enddo                                                             
     .        goto 10009                                                        
  1821        z_QH2OLiqB = z_QH2OLiq
  1822        z_QH2OSolB = z_QH2OSol
  1823        z_TempB    = z_Temp
  1824  
  1825        ! 飽和比湿計算
  1826        ! Calculate saturation specific humidity
  1827        !
  1828        z_QH2OVapSat       = a_CalcQVapSat      ( z_Temp, z_Press      )
  1829        z_DQH2OVapSatDTemp = a_CalcDQVapSatDTemp( z_Temp, z_QH2OVapSat )
  1830  
  1831  
  1832        do k = 1, kmax
  1833  
  1834          ! 飽和していたら, 温度と比湿の変化を計算
  1835          ! Calculate tendency of temperature and humidity
  1836          ! if moist is saturation.
  1837          !
  1838          if ( z_FlagProcess(k) ) then
  1839  
  1840            ! Liquid water and ice fractions
  1841            call SaturateWatFraction(   &
  1842              & z_Temp(k),              & ! (in )
  1843              & WatFrac                 & ! (out)
  1844              & )
  1845            IceFrac = 1.0_DP - WatFrac
  1846  
  1847  
  1848            if ( z_QH2OVapSat(k) < z_QH2OTot(k) - z_QH2OTotFluc(k) ) then
  1849              CoefA =   z_QH2OTot(k) - z_QH2OVapSat(k)
  1850              CoefB = - z_DQH2OVapSatDTemp(k)
  1851            else if ( z_QH2OVapSat(k) < z_QH2OTot(k) + z_QH2OTotFluc(k) ) then
  1852              CoefA =     ( z_QH2OTot(k) + z_QH2OTotFluc(k) - z_QH2OVapSat(k) )**2&
  1853                &       / ( 4.0_DP * z_QH2OTotFluc(k) )
  1854              CoefB = -   ( z_QH2OTot(k) + z_QH2OTotFluc(k) - z_QH2OVapSat(k) )   &
  1855                &       / ( 2.0_DP * z_QH2OTotFluc(k) )                           &
  1856                &       * z_DQH2OVapSatDTemp(k)
  1857            else
  1858              CoefA = 0.0_DP
  1859              CoefB = 0.0_DP
  1860            end if
  1861  
  1862            ! 温度の変化分をニュートン法で求める
  1863            ! Calculate variation of temperature
  1864            !
  1865            DelTemp =                                                         &
  1866              &   ( - LatentHeat * z_QH2OLiq(k)                               &
  1867              &     - ( LatentHeat + LatentHeatFusion ) * z_QH2OSol(k)        &
  1868              &     + ( LatentHeat + LatentHeatFusion * IceFrac ) * CoefA )   &
  1869              & / (   CpDry &
  1870              &     - ( LatentHeat + LatentHeatFusion * IceFrac ) * CoefB )
  1871  
  1872  
  1873            ! 温度と比湿の調節
  1874            ! Adjust temperature and specific humidity
  1875            !
  1876            z_Temp(k) = z_Temp(k) + DelTemp
  1877            QH2OCond  = CoefA + CoefB * DelTemp
  1878            z_QH2OVap(k) = z_QH2OTot(k) - QH2OCond
  1879            z_QH2OLiq(k) = WatFrac * QH2OCond
  1880            z_QH2OSol(k) = IceFrac * QH2OCond
  1881  
  1882            QH2OVapSat = z_QH2OVapSat(k) + z_DQH2OVapSatDTemp(k) * DelTemp
  1883  
  1884            ! It should be noted that, in general, z_QH2OVapSat(k) is not
  1885            ! equal to QH2OVapSat.
  1886            if ( z_QH2OVapSat(k) < z_QH2OTot(k) - z_QH2OTotFluc(k) ) then
  1887              z_CloudCover(k) = 1.0_DP
  1888            else if ( z_QH2OVapSat(k) < z_QH2OTot(k) + z_QH2OTotFluc(k) ) then
  1889              z_CloudCover(k) = ( z_QH2OTot(k) + z_QH2OTotFluc(k) - QH2OVapSat ) / ( 2.0_DP * z_QH2OTotFluc(k) )
  1890              z_CloudCover(k) = max( min( z_CloudCover(k), 1.0_DP ), 0.0_DP )
  1891            else
  1892              z_CloudCover(k) = 0.0_DP
  1893            end if
  1894          else
  1895            z_CloudCover(k) = 0.0_DP
  1896          end if
  1897  
  1898        end do
  1899  
  1900      end do
  1901  
  1902  
  1903      ! 比湿変化率, 温度変化率, 降水量の算出
  1904      ! Calculate specific humidity tendency, temperature tendency,
  1905      ! precipitation
  1906      !
  1907      z_DTempDtLsc    = ( z_Temp    - z_Temp0    ) / ( 2.0_DP * DelTime )
     .        d1 = 1.D0/(2.00000000000000e+000*deltime)                         
     .        d2 = 1.D0/(2.00000000000000e+000*deltime)                         
     .  !cdir nodep                                                             
     .        do t391 = 1, z_temp.DSC.U1                                        
     .           z_dqh2oliqdt(t391) = (z_qh2oliq(t391)-z_qh2oliq0(t391))*d1     
     .           z_dqh2osoldt(t391) = (z_qh2osol(t391)-z_qh2osol0(t391))*d2     
     .        enddo                                                             
  1908      z_DQH2OVapDtLsc = ( z_QH2OVap - z_QH2OVap0 ) / ( 2.0_DP * DelTime )
  1909      z_DQH2OLiqDt    = ( z_QH2OLiq - z_QH2OLiq0 ) / ( 2.0_DP * DelTime )
  1910      z_DQH2OSolDt    = ( z_QH2OSol - z_QH2OSol0 ) / ( 2.0_DP * DelTime )
  1911  
  1912  
  1913      call LScaleCond1DConsChk(                        &
  1914        & z_Temp0, z_QH2OVap0, z_QH2OLiq0, z_QH2OSol0, &
  1915        & z_Temp , z_QH2OVap , z_QH2OLiq , z_QH2OSol   &
  1916        & )
  1917  
  1918  
  1919  !!$    ! 計算時間計測一時停止
  1920  !!$    ! Pause measurement of computation time
  1921  !!$    !
  1922  !!$    call TimesetClockStop( module_name )
  1923  
  1924    end subroutine LScaleCondLL911D
  1925  
  1926    !--------------------------------------------------------------------------------------
  1927  
  1928    subroutine LScaleCond1DConsChk(                  &
  1929      & z_TempB, z_QH2OVapB, z_QH2OLiqB, z_QH2OSolB, &
  1930      & z_Temp , z_QH2OVap , z_QH2OLiq , z_QH2OSol   &
  1931      & )
  1932  
  1933      ! 物理定数設定
  1934      ! Physical constants settings
  1935      !
  1936      use constants, only: &
  1937        & Grav, &
  1938                                ! $ g $ [m s-2].
  1939                                ! 重力加速度.
  1940                                ! Gravitational acceleration
  1941        & CpDry, &
  1942                                ! $ C_p $ [J kg-1 K-1].
  1943                                ! 乾燥大気の定圧比熱.
  1944                                ! Specific heat of air at constant pressure
  1945        & LatentHeat, &
  1946                                ! $ L $ [J kg-1] .
  1947                                ! 凝結の潜熱.
  1948                                ! Latent heat of condensation
  1949        & LatentHeatFusion
  1950                                ! $ L $ [J kg-1] .
  1951                                ! 融解の潜熱.
  1952                                ! Latent heat of fusion
  1953  
  1954      real(DP), intent(in) :: z_TempB   (1:kmax)
  1955      real(DP), intent(in) :: z_QH2OVapB(1:kmax)
  1956      real(DP), intent(in) :: z_QH2OLiqB(1:kmax)
  1957      real(DP), intent(in) :: z_QH2OSolB(1:kmax)
  1958      real(DP), intent(in) :: z_Temp    (1:kmax)
  1959      real(DP), intent(in) :: z_QH2OVap (1:kmax)
  1960      real(DP), intent(in) :: z_QH2OLiq (1:kmax)
  1961      real(DP), intent(in) :: z_QH2OSol (1:kmax)
  1962  
  1963      ! Local variables
  1964      !
  1965      real(DP) :: ValB
  1966      real(DP) :: Val
  1967      real(DP) :: Ratio
  1968      integer  :: k
  1969  
  1970  
  1971      do k = kmax, 1, -1
  1972        Val =   CpDry * z_TempB(k)               &
  1973          &   + LatentHeat * z_QH2OVapB(k)       &
  1974          &   - LatentHeatFusion * z_QH2OSolB(k)
  1975        ValB = Val
  1976  
  1977        Val =   CpDry * z_Temp(k)               &
  1978          &   + LatentHeat * z_QH2OVap(k)       &
  1979          &   - LatentHeatFusion * z_QH2OSol(k)
  1980  
  1981        Ratio = ( Val - ValB ) / ( Val + 1.0d-100 )
  1982        if ( abs( Ratio ) > 1.0d-10 ) then
  1983          call MessageNotify( 'M', module_name, 'Simplified condensate static energy is not conserved, %f.', d = (/ Ratio /) )
  1984        end if
  1985      end do
  1986  
  1987  
  1988  
  1989      do k = kmax, 1, -1
  1990        Val = z_QH2OVapB(k) + z_QH2OLiqB(k) + z_QH2OSolB(k)
  1991        ValB = Val
  1992  
  1993        Val = z_QH2OVap (k) + z_QH2OLiq (k) + z_QH2OSol (k)
  1994  
  1995        Ratio = ( Val - ValB ) / ( Val + 1.0d-100 )
  1996        if ( abs( Ratio ) > 1.0d-10 ) then
  1997          call MessageNotify( 'M', module_name, 'H2O mass is not conserved, %f.', d = (/ Ratio /) )
  1998        end if
  1999      end do
  2000  
  2001  
  2002    end subroutine LScaleCond1DConsChk
  2003  
  2004    !--------------------------------------------------------------------------------------
  2005  
  2006    subroutine LScaleCond1GridConsChk(       &
  2007      & TempB, QH2OVapB, QH2OLiqB, QH2OSolB, &
  2008      & Temp , QH2OVap , QH2OLiq , QH2OSol   &
  2009      & )
  2010  
  2011      ! 物理定数設定
  2012      ! Physical constants settings
  2013      !
  2014      use constants, only: &
  2015        & Grav, &
  2016                                ! $ g $ [m s-2].
  2017                                ! 重力加速度.
  2018                                ! Gravitational acceleration
  2019        & CpDry, &
  2020                                ! $ C_p $ [J kg-1 K-1].
  2021                                ! 乾燥大気の定圧比熱.
  2022                                ! Specific heat of air at constant pressure
  2023        & LatentHeat, &
  2024                                ! $ L $ [J kg-1] .
  2025                                ! 凝結の潜熱.
  2026                                ! Latent heat of condensation
  2027        & LatentHeatFusion
  2028                                ! $ L $ [J kg-1] .
  2029                                ! 融解の潜熱.
  2030                                ! Latent heat of fusion
  2031  
  2032      real(DP), intent(in) :: TempB
  2033      real(DP), intent(in) :: QH2OVapB
  2034      real(DP), intent(in) :: QH2OLiqB
  2035      real(DP), intent(in) :: QH2OSolB
  2036      real(DP), intent(in) :: Temp
  2037      real(DP), intent(in) :: QH2OVap
  2038      real(DP), intent(in) :: QH2OLiq
  2039      real(DP), intent(in) :: QH2OSol
  2040  
  2041      ! Local variables
  2042      !
  2043      real(DP) :: ValB
  2044      real(DP) :: Val
  2045      real(DP) :: Ratio
  2046      integer  :: k
  2047  
  2048  
  2049      Val =   CpDry * TempB               &
  2050        &   + LatentHeat * QH2OVapB       &
  2051        &   - LatentHeatFusion * QH2OSolB
  2052      ValB = Val
  2053  
  2054      Val =   CpDry * Temp               &
  2055        &   + LatentHeat * QH2OVap       &
  2056        &   - LatentHeatFusion * QH2OSol
  2057  
  2058      Ratio = ( Val - ValB ) / ( Val + 1.0d-100 )
  2059      if ( abs( Ratio ) > 1.0d-10 ) then
  2060        call MessageNotify( 'M', module_name, 'Simplified condensate static energy is not conserved, %f.', d = (/ Ratio /) )
  2061      end if
  2062  
  2063  
  2064      Val = QH2OVapB + QH2OLiqB + QH2OSolB
  2065      ValB = Val
  2066  
  2067      Val = QH2OVap  + QH2OLiq  + QH2OSol
  2068  
  2069      Ratio = ( Val - ValB ) / ( Val + 1.0d-100 )
  2070      if ( abs( Ratio ) > 1.0d-10 ) then
  2071        call MessageNotify( 'M', module_name, 'H2O mass is not conserved, %f.', d = (/ Ratio /) )
  2072      end if
  2073  
  2074  
  2075    end subroutine LScaleCond1GridConsChk
  2076  
  2077    !--------------------------------------------------------------------------------------
  2078  
  2079    subroutine LScaleCondInit( &
  2080      & FlagSnow &
  2081      & )
  2082      !
  2083      ! lscond モジュールの初期化を行います.
  2084      ! NAMELIST#lscond_nml の読み込みはこの手続きで行われます.
  2085      !
  2086      ! "lscond" module is initialized.
  2087      ! "NAMELIST#lscond_nml" is loaded in this procedure.
  2088      !
  2089  
  2090      ! モジュール引用 ; USE statements
  2091      !
  2092  
  2093      ! NAMELIST ファイル入力に関するユーティリティ
  2094      ! Utilities for NAMELIST file input
  2095      !
  2096      use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid
  2097  
  2098      ! ファイル入出力補助
  2099      ! File I/O support
  2100      !
  2101      use dc_iounit, only: FileOpen
  2102  
  2103      ! 種別型パラメタ
  2104      ! Kind type parameter
  2105      !
  2106      use dc_types, only: STDOUT ! 標準出力の装置番号. Unit number of standard output
  2107  
  2108      ! 文字列操作
  2109      ! Character handling
  2110      !
  2111      use dc_string, only: StoA
  2112  
  2113      ! ヒストリデータ出力
  2114      ! History data output
  2115      !
  2116      use gtool_historyauto, only: HistoryAutoAddVariable
  2117  
  2118      ! 飽和比湿の算出
  2119      ! Evaluate saturation specific humidity
  2120      !
  2121      use saturate, only: SaturateInit
  2122  
  2123      ! 雲関系ルーチン
  2124      ! Cloud-related routines
  2125      !
  2126      use cloud_utils, only : CloudUtilsInit
  2127  
  2128      ! 宣言文 ; Declaration statements
  2129      !
  2130      implicit none
  2131  
  2132      logical, intent(in) :: FlagSnow
  2133  
  2134  
  2135      integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号.
  2136                                ! Unit number for NAMELIST file open
  2137      integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT.
  2138                                ! IOSTAT of NAMELIST read
  2139  
  2140      ! NAMELIST 変数群
  2141      ! NAMELIST group name
  2142      !
  2143      namelist /lscond_nml/ &
  2144        & QH2OFlucRatio, CrtlRH, ItrtMax, FlagSatAdj
  2145            !
  2146            ! デフォルト値については初期化手続 "lscond#LSCondInit"
  2147            ! のソースコードを参照のこと.
  2148            !
  2149            ! Refer to source codes in the initialization procedure
  2150            ! "lscond#LSCondInit" for the default values.
  2151            !
  2152  
  2153      ! 実行文 ; Executable statement
  2154      !
  2155  
  2156      if ( lscond_inited ) return
  2157  
  2158  
  2159      ! デフォルト値の設定
  2160      ! Default values settings
  2161      !
  2162      QH2OFlucRatio   = 0.2_DP
  2163      CrtlRH          = 1.0_DP
  2164      ItrtMax         = 3
  2165      FlagSatAdj      = .false.
  2166  
  2167      ! NAMELIST の読み込み
  2168      ! NAMELIST is input
  2169      !
  2170      if ( trim(namelist_filename) /= '' ) then
  2171        call FileOpen( unit_nml, &          ! (out)
  2172          & namelist_filename, mode = 'r' ) ! (in)
  2173  
  2174        rewind( unit_nml )
  2175        read( unit_nml, &         ! (in)
  2176          & nml = lscond_nml, &   ! (out)
  2177          & iostat = iostat_nml ) ! (out)
  2178        close( unit_nml )
  2179  
  2180        call NmlutilMsg( iostat_nml, module_name ) ! (in)
  2181        if ( iostat_nml == 0 ) write( STDOUT, nml = lscond_nml )
  2182      end if
  2183  
  2184      ! Initialization of modules used in this module
  2185      !
  2186  
  2187      ! Initialization of modules used in this module
  2188      !
  2189      call SaturateInit
  2190  
  2191      ! 雲関系ルーチン
  2192      ! Cloud-related routines
  2193      !
  2194      call CloudUtilsInit( &
  2195        & FlagSnow         &
  2196        & )
  2197  
  2198  
  2199      ! ヒストリデータ出力のためのへの変数登録
  2200      ! Register of variables for history data output
  2201      !
  2202      call HistoryAutoAddVariable( 'DTempDtLsc', &
  2203        & (/ 'lon ', 'lat ', 'sig ', 'time' /), &
  2204        & 'large-scale condensation heating', 'K s-1' )
  2205      call HistoryAutoAddVariable( 'DQH2OVapDtLsc', &
  2206        & (/ 'lon ', 'lat ', 'sig ', 'time' /), &
  2207        & 'large-scale condensation moistening', 'kg kg-1 s-1' )
  2208      call HistoryAutoAddVariable( 'DQH2OLiqDtLsc', &
  2209        & (/ 'lon ', 'lat ', 'sig ', 'time' /), &
  2210        & 'large-scale H2O liquid production rate', 'kg kg-1 s-1' )
  2211      call HistoryAutoAddVariable( 'DQH2OSolDtLsc', &
  2212        & (/ 'lon ', 'lat ', 'sig ', 'time' /), &
  2213        & 'large-scale H2O solid production rate', 'kg kg-1 s-1' )
  2214  
  2215  
  2216      ! 印字 ; Print
  2217      !
  2218      call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
  2219      call MessageNotify( 'M', module_name, '  QH2OFlucRatio   = %f', d = (/ QH2OFlucRatio /) )
  2220      call MessageNotify( 'M', module_name, '  CrtlRH          = %f', d = (/ CrtlRH /) )
  2221      call MessageNotify( 'M', module_name, '  ItrtMax         = %d', i = (/ ItrtMax /) )
  2222      call MessageNotify( 'M', module_name, '  FlagSatAdj      = %b', l = (/ FlagSatAdj /) )
  2223      call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
  2224  
  2225      lscond_inited = .true.
  2226  
  2227    end subroutine LScaleCondInit
  2228  
  2229    !--------------------------------------------------------------------------------------
  2230  
  2231  end module lscond
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:54 2016
FILE NAME: lscond.f90
PROGRAM NAME: lscond
FORMAT LIST

  LINE    LOOP      FORTRAN STATEMENT

     1:             != 大規模凝結 (非対流性凝結) (Manabe et al., 1965)
     2:             !
     3:             != Large scale condensation (non-convective condensation) (Manabe et al., 1965)
     4:             !
     5:             ! Authors::   Yasuhiro MORIKAWA, Yukiko YAMADA, Satoshi NODA, Yoshiyuki O. Takahashi
     6:             ! Version::   $Id: lscond.f90,v 1.22 2015/03/11 04:53:25 yot Exp $ 
     7:             ! Tag Name::  $Name:  $
     8:             ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9:             ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10:             !
    11:             
    12:             module lscond
    13:               !
    14:               != 大規模凝結 (非対流性凝結)
    15:               !
    16:               != Large scale condensation (non-convective condensation)
    17:               !
    18:               ! <b>Note that Japanese and English are described in parallel.</b>
    19:               !
    20:               ! 大規模凝結過程によって温度と比湿を調節します. 
    21:               !
    22:               ! Adjust temperature and specific humidity by 
    23:               ! a large scale condensation process.
    24:               !
    25:               !== References
    26:               !
    27:               !  Manabe, S., J. Smagorinsky, R. F. Strickler,
    28:               !    Simulated climatology of a general circulation model with a hydrologic cycle,
    29:               !    Mon. Wea. Rev., 93, 769-798, 1965.
    30:               !
    31:               !== Procedures List
    32:               ! 
    33:               ! LScaleCond    :: 温度と比湿の調節
    34:               ! ------------  :: ------------
    35:               ! LScaleCond    :: Adjust temperature and specific humidity
    36:               !
    37:               !== NAMELIST
    38:               !
    39:               ! NAMELIST#lscond_nml
    40:               !
    41:             
    42:               ! モジュール引用 ; USE statements
    43:               !
    44:             
    45:               ! 格子点設定
    46:               ! Grid points settings
    47:               !
    48:               use gridset, only: imax, & ! 経度格子点数. 
    49:                                          ! Number of grid points in longitude
    50:                 &                jmax, & ! 緯度格子点数. 
    51:                                          ! Number of grid points in latitude
    52:                 &                kmax    ! 鉛直層数. 
    53:                                          ! Number of vertical level
    54:             
    55:               ! 種別型パラメタ
    56:               ! Kind type parameter
    57:               !
    58:               use dc_types, only: DP, &      ! 倍精度実数型. Double precision. 
    59:                 &                 STRING     ! 文字列.       Strings. 
    60:             
    61:               ! メッセージ出力
    62:               ! Message output
    63:               !
    64:               use dc_message, only: MessageNotify
    65:             
    66:               ! 宣言文 ; Declaration statements
    67:               !
    68:               implicit none
    69:               private
    70:             
    71:               ! 公開手続き
    72:               ! Public procedure
    73:               !
    74:               public:: LScaleCond
    75:               public:: LScaleCond1D3DWrapper
    76:               public:: LScaleCond1Grid
    77:               public:: LScaleCondLL911D3DWrapper
    78:               public:: LScaleCondInit
    79:             
    80:               ! 公開変数
    81:               ! Public variables
    82:               !
    83:               logical, save :: lscond_inited = .false.
    84:                                           ! 初期設定フラグ. 
    85:                                           ! Initialization flag
    86:             
    87:               ! 非公開変数
    88:               ! Private variables
    89:               !
    90:               real(DP), save:: QH2OFlucRatio
    91:             
    92:               real(DP), save:: CrtlRH
    93:                                           ! 臨界相対湿度. 
    94:                                           ! Critical relative humidity
    95:               integer, save:: ItrtMax
    96:                                           ! イテレーション回数. 
    97:                                           ! Number of iteration
    98:               logical, save:: FlagSatAdj
    99:                                           ! 
   100:                                           ! flag for saturation adjustment
   101:             
   102:               character(*), parameter:: module_name = 'lscond'
   103:                                           ! モジュールの名称. 
   104:                                           ! Module name
   105:               character(*), parameter:: version = &
   106:                 & '$Name:  $' // &
   107:                 & '$Id: lscond.f90,v 1.22 2015/03/11 04:53:25 yot Exp $'
   108:                                           ! モジュールのバージョン
   109:                                           ! Module version
   110:             
   111:             contains
   112:             
   113:               !--------------------------------------------------------------------------------------
   114:             
   115:               subroutine LScaleCond(        &
   116:                 & xyz_Temp, xyz_QVap,       &  ! (inout)
   117:                 & xyz_Press, xyr_Press,     &  ! (in)
   118:                 & xyz_DQH2OLiqDt,           &  ! (out)
   119:                 & FlagOutput                &  ! (in) optional
   120:                 & )
   121:                 !
   122:                 ! 大規模凝結スキームにより, 温度と比湿を調節します. 
   123:                 !
   124:                 ! Adjust temperature and specific humidity by 
   125:                 ! large scale condensation scheme. 
   126:                 !
   127:             
   128:                 ! モジュール引用 ; USE statements
   129:                 !
   130:             
   131:                 ! 物理定数設定
   132:                 ! Physical constants settings
   133:                 !
   134:                 use constants, only: &
   135:                   & Grav, & 
   136:                                           ! $ g $ [m s-2]. 
   137:                                           ! 重力加速度. 
   138:                                           ! Gravitational acceleration
   139:                   & CpDry, &
   140:                                           ! $ C_p $ [J kg-1 K-1]. 
   141:                                           ! 乾燥大気の定圧比熱. 
   142:                                           ! Specific heat of air at constant pressure
   143:                   & LatentHeat, &
   144:                                           ! $ L $ [J kg-1] . 
   145:                                           ! 凝結の潜熱. 
   146:                                           ! Latent heat of condensation
   147:                   & LatentHeatFusion
   148:                                           ! $ L $ [J kg-1] .
   149:                                           ! 融解の潜熱.
   150:                                           ! Latent heat of fusion
   151:             
   152:                 ! 時刻管理
   153:                 ! Time control
   154:                 !
   155:                 use timeset, only: &
   156:                   & DelTime, &            ! $ \Delta t $
   157:                   & TimeN, &              ! ステップ $ t $ の時刻. Time of step $ t $. 
   158:                   & TimesetClockStart, TimesetClockStop
   159:             
   160:                 ! ヒストリデータ出力
   161:                 ! History data output
   162:                 !
   163:                 use gtool_historyauto, only: HistoryAutoPut
   164:             
   165:                 ! 飽和比湿の算出
   166:                 ! Evaluate saturation specific humidity
   167:                 !
   168:                 use saturate, only: xyz_CalcQVapSat, xyz_CalcDQVapSatDTemp
   169:             
   170:             
   171:                 ! 宣言文 ; Declaration statements
   172:                 !
   173:                 implicit none
   174:             
   175:                 real(DP), intent(inout):: xyz_Temp (0:imax-1, 1:jmax, 1:kmax)
   176:                                           ! $ T $ .     温度. Temperature
   177:                 real(DP), intent(inout):: xyz_QVap (0:imax-1, 1:jmax, 1:kmax)
   178:                                           ! $ q $ .     比湿. Specific humidity
   179:                 real(DP), intent(in):: xyz_Press (0:imax-1, 1:jmax, 1:kmax)
   180:                                           ! $ p $ . 気圧 (整数レベル). 
   181:                                           ! Air pressure (full level)
   182:                 real(DP), intent(in):: xyr_Press (0:imax-1, 1:jmax, 0:kmax)
   183:                                           ! $ \hat{p} $ . 気圧 (半整数レベル). 
   184:                                           ! Air pressure (half level)
   185:                 real(DP), intent(out) :: xyz_DQH2OLiqDt(0:imax-1,1:jmax,1:kmax)
   186:                                           !
   187:                                           ! Tendency of H2O liquid mixing ratio
   188:                 logical , intent(in ), optional :: FlagOutput
   189:                                           !
   190:                                           ! Flag for output
   191:             
   192:             
   193:                 ! 作業変数
   194:                 ! Work variables
   195:                 !
   196:                 real(DP):: xy_RainLsc (0:imax-1, 1:jmax)
   197:                                           ! 降水量. 
   198:                                           ! Precipitation
   199:                 real(DP):: xyz_DTempDtLsc (0:imax-1, 1:jmax, 1:kmax)
   200:                                           ! 温度変化率. 
   201:                                           ! Temperature tendency
   202:                 real(DP):: xyz_DQVapDtLsc (0:imax-1, 1:jmax, 1:kmax)
   203:                                           ! 比湿変化率. 
   204:                                           ! Specific humidity tendency
   205:             
   206:                 real(DP):: xyz_QVapB (0:imax-1, 1:jmax, 1:kmax)
   207:                                           ! 調節前の比湿. 
   208:                                           ! Specific humidity before adjust. 
   209:                 real(DP):: xyz_TempB (0:imax-1, 1:jmax, 1:kmax)
   210:                                           ! 調節前の温度. 
   211:                                           ! Temperature before adjust. 
   212:                                           !
   213:                 real(DP):: xyz_QVapSat      (0:imax-1, 1:jmax, 1:kmax)
   214:                                           ! 飽和比湿. 
   215:                                           ! Saturation specific humidity. 
   216:                 real(DP):: xyz_DQVapSatDTemp(0:imax-1, 1:jmax, 1:kmax)
   217:                                           ! $ \DD{q_{\rm{sat}}}{T} $
   218:                 real(DP):: DelTemp
   219:                                           ! 調節による温度変化量. 
   220:                                           ! Temperature variation by adjustment
   221:             
   222:                 real(DP):: LatentHeatLocal
   223:                                           ! 
   224:                                           ! Latent heat used in this routine
   225:             
   226:                 integer:: i               ! 経度方向に回る DO ループ用作業変数
   227:                                           ! Work variables for DO loop in longitude
   228:                 integer:: j               ! 緯度方向に回る DO ループ用作業変数
   229:                                           ! Work variables for DO loop in latitude
   230:                 integer:: k               ! 鉛直方向に回る DO ループ用作業変数
   231:                                           ! Work variables for DO loop in vertical direction
   232:                 integer:: itr             ! イテレーション方向に回る DO ループ用作業変数
   233:                                           ! Work variables for DO loop in iteration direction
   234:             
   235:                 real(DP):: xyz_RainLSC(0:imax-1, 1:jmax, 1:kmax)
   236:             
   237:                 real(DP):: TempBefAdj
   238:                 real(DP):: QVapBefAdj
   239:             
   240:                 logical:: xyz_FlagSaturated(0:imax-1, 1:jmax, 1:kmax)
   241:             
   242:             
   243:                 ! 実行文 ; Executable statement
   244:                 !
   245:             
   246:                 ! 初期化確認
   247:                 ! Initialization check
   248:                 !
   249:                 if ( .not. lscond_inited ) then
   250:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   251:                 end if
   252:             
   253:             
   254:                 ! 計算時間計測開始
   255:                 ! Start measurement of computation time
   256:                 !
   257:                 call TimesetClockStart( module_name )
   258:             
   259:             
   260:                 ! 調節前 "QVap", "Temp" の保存
   261:                 ! Store "QVap", "Temp" before adjustment
   262:                 !
   263: **V---->A       xyz_QVapB  = xyz_QVap
   264: |||     A       xyz_TempB  = xyz_Temp
   265: |||         
   266: |||         
   267: |||             ! 調節
   268: |||             ! Adjustment
   269: |||             !
   270: |||         
   271: |||             ! 飽和比湿計算
   272: |||             ! Calculate saturation specific humidity 
   273: |||             !
   274: **V---- A       xyz_QVapSat = xyz_CalcQVapSat( xyz_Temp, xyz_Press )
   275:             
   276: +------>        do k = 1, kmax
   277: |+----->          do j = 1, jmax
   278: ||V---->            do i = 0, imax-1
   279: |||         
   280: |||     A             if ( ( xyz_QVap(i,j,k) / xyz_QVapSat(i,j,k) ) >= CrtlRH ) then
   281: |||                     xyz_FlagSaturated(i,j,k) = .true.
   282: |||                   else
   283: |||                     xyz_FlagSaturated(i,j,k) = .false.
   284: |||                   end if
   285: |||         
   286: ||V---- A           end do
   287: |+-----           end do
   288: +------         end do
   289:             
   290:                 ! Set a value for latent heat
   291:                 LatentHeatLocal = LatentHeat
   292:             
   293: +------>        do itr = 1, ItrtMax
   294: |           
   295: |                 ! 飽和比湿計算
   296: |                 ! Calculate saturation specific humidity
   297: |                 !
   298: |                 xyz_QVapSat       = xyz_CalcQVapSat      ( xyz_Temp, xyz_Press   )
   299: |                 xyz_DQVapSatDTemp = xyz_CalcDQVapSatDTemp( xyz_Temp, xyz_QVapSat )
   300: |           
   301: |           
   302: |+----->          do k = 1, kmax
   303: ||+---->            do j = 1, jmax
   304: |||V--->              do i = 0, imax-1
   305: ||||        
   306: ||||                    ! 飽和していたら, 温度と比湿の変化を計算
   307: ||||                    ! Calculate tendency of temperature and humidity 
   308: ||||                    ! if moist is saturation. 
   309: ||||                    !
   310: ||||                    if ( xyz_FlagSaturated(i,j,k) ) then
   311: ||||        
   312: ||||                      ! 温度の変化分をニュートン法で求める
   313: ||||                      ! Calculate variation of temperature
   314: ||||                      !
   315: ||||    A                 DelTemp =                                                 &
   316: ||||                        & LatentHeatLocal                                       &
   317: ||||                        &   * ( xyz_QVap(i,j,k) - CrtlRH * xyz_QVapSat(i,j,k) ) &
   318: ||||                        &   / ( CpDry + LatentHeatLocal * CrtlRH * xyz_DQVapSatDTemp(i,j,k) )
   319: ||||        
   320: ||||        
   321: ||||                      !=========
   322: ||||                      ! check routine
   323: ||||                      !---------
   324: ||||        !!$              TempBefAdj = xyz_Temp(i,j,k)
   325: ||||        !!$              QVapBefAdj = xyz_QVap(i,j,k)
   326: ||||                      !=========
   327: ||||        
   328: ||||                      ! 温度と比湿の調節
   329: ||||                      ! Adjust temperature and specific humidity
   330: ||||                      !
   331: ||||    A                 xyz_Temp(i,j,k) = xyz_Temp(i,j,k) + DelTemp
   332: ||||    A   !!$              xyz_QVap(i,j,k) = xyz_QVapSat(i,j,k) + xyz_DQVapSatDTemp(i,j,k) * DelTemp
   333: ||||    A                 xyz_QVap(i,j,k) = &
   334: ||||                        & CrtlRH * ( xyz_QVapSat(i,j,k) + xyz_DQVapSatDTemp(i,j,k) * DelTemp )
   335: ||||        
   336: ||||                      !=========
   337: ||||                      ! check routine
   338: ||||                      !---------
   339: ||||        !!$              write( 6, * ) '====='
   340: ||||        !!$              write( 6, * ) 'Energy difference before and after adjustment and each energy'
   341: ||||        !!$              write( 6, * ) &
   342: ||||        !!$                &     CpDry * TempBefAdj      + LatentHeatLocal * QVapBefAdj            &
   343: ||||        !!$                & - ( CpDry * xyz_Temp(i,j,k) + LatentHeatLocal * xyz_QVap(i,j,k) ),    &
   344: ||||        !!$                &     CpDry * TempBefAdj      + LatentHeatLocal * QVapBefAdj,           &
   345: ||||        !!$                &   ( CpDry * xyz_Temp(i,j,k) + LatentHeatLocal * xyz_QVap(i,j,k) )
   346: ||||                      !=========
   347: ||||        
   348: ||||        
   349: ||||                    end if
   350: ||||        
   351: |||V--- A             end do
   352: ||+----             end do
   353: |+-----           end do
   354: |           
   355: +------         end do
   356:             
   357:                 ! 比湿変化率, 温度変化率, 降水量の算出
   358:                 ! Calculate specific humidity tendency, temperature tendency, 
   359:                 ! precipitation
   360:                 !
   361: **W---->A       xyz_DQVapDtLsc = ( xyz_QVap - xyz_QVapB ) / ( 2.0_DP * DelTime )
   362: |||     A       xyz_DTempDtLsc = ( xyz_Temp - xyz_TempB ) / ( 2.0_DP * DelTime )
   363: |||         
   364: **W---- A       xyz_DQH2OLiqDt = - xyz_DQVapDtLsc
   365:             
   366:             
   367:                 ! calculation for output
   368: W*=====         xy_RainLsc     = 0.0_DP
   369: +------>        do k = kmax, 1, -1
   370: |W*==== A         xy_RainLsc = xy_RainLsc                                     &
   371: |                   & + xyz_DQH2OLiqDt(:,:,k) * ( xyr_Press(:,:,k-1) - xyr_Press(:,:,k) ) / Grav
   372: +------         end do
   373:             
   374:             
   375:                 ! ヒストリデータ出力
   376:                 ! History data output
   377:                 !
   378:                 if ( .not. present( FlagOutput ) ) then
   379:                   call HistoryAutoPut( TimeN, 'DTempDtLsc', xyz_DTempDtLsc )
   380:                   call HistoryAutoPut( TimeN, 'DQH2OVapDtLsc', xyz_DQVapDtLsc )
   381:                   call HistoryAutoPut( TimeN, 'DQH2OLiqDtLsc', xyz_DQH2OLiqDt )
   382:                 else
   383:                   if ( FlagOutput ) then
   384:                     call HistoryAutoPut( TimeN, 'DTempDtLsc', xyz_DTempDtLsc )
   385:                     call HistoryAutoPut( TimeN, 'DQH2OVapDtLsc', xyz_DQVapDtLsc )
   386:                     call HistoryAutoPut( TimeN, 'DQH2OLiqDtLsc', xyz_DQH2OLiqDt )
   387:                   end if
   388:                 end if
   389:             
   390:             
   391:                 ! 計算時間計測一時停止
   392:                 ! Pause measurement of computation time
   393:                 !
   394:                 call TimesetClockStop( module_name )
   395:             
   396:               end subroutine LScaleCond
   397:             
   398:               !--------------------------------------------------------------------------------------
   399:             
   400:               subroutine LScaleCond1D3DWrapper(                 &
   401:                 & xyz_Temp, xyz_QVap, xyz_QH2OLiq, xyz_QH2OSol, &  ! (inout)
   402:                 & xyz_Press, xyr_Press,                         &  ! (in)
   403:                 & xyz_DQH2OLiqDt, xyz_DQH2OSolDt,               &  ! (out)
   404:                 & FlagOutput                                    &  ! (in) optional
   405:                 & )
   406:                 !
   407:                 ! 大規模凝結スキームにより, 温度と比湿を調節します. 
   408:                 !
   409:                 ! Adjust temperature and specific humidity by 
   410:                 ! large scale condensation scheme. 
   411:                 !
   412:             
   413:                 ! モジュール引用 ; USE statements
   414:                 !
   415:             
   416:                 ! 物理定数設定
   417:                 ! Physical constants settings
   418:                 !
   419:                 use constants, only: &
   420:                   & Grav
   421:                                           ! $ g $ [m s-2]. 
   422:                                           ! 重力加速度. 
   423:                                           ! Gravitational acceleration
   424:             
   425:                 ! 時刻管理
   426:                 ! Time control
   427:                 !
   428:                 use timeset, only: &
   429:                   & DelTime, &            ! $ \Delta t $
   430:                   & TimeN, &              ! ステップ $ t $ の時刻. Time of step $ t $. 
   431:                   & TimesetClockStart, TimesetClockStop
   432:             
   433:                 ! ヒストリデータ出力
   434:                 ! History data output
   435:                 !
   436:                 use gtool_historyauto, only: HistoryAutoPut
   437:             
   438:             
   439:                 ! 宣言文 ; Declaration statements
   440:                 !
   441:                 implicit none
   442:             
   443:                 real(DP), intent(inout):: xyz_Temp (0:imax-1, 1:jmax, 1:kmax)
   444:                                           ! $ T $ .     温度. Temperature
   445:                 real(DP), intent(inout):: xyz_QVap (0:imax-1, 1:jmax, 1:kmax)
   446:                                           ! $ q $ .     比湿. Specific humidity
   447:                 real(DP), intent(inout):: xyz_QH2OLiq(0:imax-1, 1:jmax, 1:kmax)
   448:                                           ! Specific liquid water content
   449:                 real(DP), intent(inout):: xyz_QH2OSol(0:imax-1, 1:jmax, 1:kmax)
   450:                                           ! Specific ice content
   451:                 real(DP), intent(in):: xyz_Press (0:imax-1, 1:jmax, 1:kmax)
   452:                                           ! $ p $ . 気圧 (整数レベル). 
   453:                                           ! Air pressure (full level)
   454:                 real(DP), intent(in):: xyr_Press (0:imax-1, 1:jmax, 0:kmax)
   455:                                           ! $ \hat{p} $ . 気圧 (半整数レベル). 
   456:                                           ! Air pressure (half level)
   457:                 real(DP), intent(out) :: xyz_DQH2OLiqDt(0:imax-1,1:jmax,1:kmax)
   458:                                           !
   459:                                           ! Tendency of H2O liquid mixing ratio
   460:                 real(DP), intent(out) :: xyz_DQH2OSolDt(0:imax-1,1:jmax,1:kmax)
   461:                                           !
   462:                                           ! Tendency of H2O ice mixing ratio
   463:                 logical , intent(in ), optional :: FlagOutput
   464:                                           !
   465:                                           ! Flag for output
   466:             
   467:             
   468:                 ! 作業変数
   469:                 ! Work variables
   470:                 !
   471:                 real(DP):: xy_RainLsc (0:imax-1, 1:jmax)
   472:                                           ! 降水量. 
   473:                                           ! Precipitation
   474:             
   475:                 real(DP):: xyz_DTempDtLsc (0:imax-1, 1:jmax, 1:kmax)
   476:                                           ! 温度変化率. 
   477:                                           ! Temperature tendency
   478:                 real(DP):: xyz_DQVapDtLsc (0:imax-1, 1:jmax, 1:kmax)
   479:                                           ! 比湿変化率. 
   480:                                           ! Specific humidity tendency
   481:             
   482:                 real(DP) :: z_Temp (1:kmax)
   483:                                           ! $ T $ .     温度. Temperature
   484:                 real(DP) :: z_QVap (1:kmax)
   485:                                           ! $ q $ .     比湿. Specific humidity
   486:                 real(DP) :: z_QH2OLiq(1:kmax)
   487:                                           ! Specic liquid water content
   488:                 real(DP) :: z_QH2OSol(1:kmax)
   489:                                           ! Specic ice content
   490:                 real(DP) :: z_Press (1:kmax)
   491:                                           ! $ p $ . 気圧 (整数レベル). 
   492:                                           ! Air pressure (full level)
   493:                 real(DP) :: r_Press (0:kmax)
   494:                                           ! $ \hat{p} $ . 気圧 (半整数レベル). 
   495:                                           ! Air pressure (half level)
   496:                 real(DP) :: z_DQH2OLiqDt(1:kmax)
   497:                                           !
   498:                                           ! Tendency of H2O liquid mixing ratio
   499:                 real(DP) :: z_DQH2OSolDt(1:kmax)
   500:                                           !
   501:                                           ! Tendency of H2O ice mixing ratio
   502:             
   503:             
   504:                 integer:: i               ! 経度方向に回る DO ループ用作業変数
   505:                                           ! Work variables for DO loop in longitude
   506:                 integer:: j               ! 緯度方向に回る DO ループ用作業変数
   507:                                           ! Work variables for DO loop in latitude
   508:                 integer:: k               ! 鉛直方向に回る DO ループ用作業変数
   509:                                           ! Work variables for DO loop in vertical direction
   510:             
   511:                 ! 実行文 ; Executable statement
   512:                 !
   513:             
   514:                 ! 初期化確認
   515:                 ! Initialization check
   516:                 !
   517:                 if ( .not. lscond_inited ) then
   518:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   519:                 end if
   520:             
   521:             
   522:                 ! 計算時間計測開始
   523:                 ! Start measurement of computation time
   524:                 !
   525:                 call TimesetClockStart( module_name )
   526:             
   527:             
   528:             
   529: +------>        do j = 1, jmax
   530: |+----->          do i = 0, imax-1
   531: ||          
   532: ||V---->            do k = 1, kmax
   533: |||     A             z_Temp   (k) = xyz_Temp   (i,j,k)
   534: |||     A             z_QVap   (k) = xyz_QVap   (i,j,k)
   535: |||     A             z_QH2OLiq(k) = xyz_QH2OLiq(i,j,k)
   536: |||     A             z_QH2OSol(k) = xyz_QH2OSol(i,j,k)
   537: |||     A             z_Press  (k) = xyz_Press  (i,j,k)
   538: ||V----             end do
   539: ||V---->            do k = 0, kmax
   540: |||     A             r_Press  (k) = xyr_Press  (i,j,k)
   541: ||V----             end do
   542: ||          
   543: ||                  call LScaleCond1D(                        &
   544: ||                    & z_Temp, z_QVap, z_QH2OLiq, z_QH2OSol, &  ! (inout)
   545: ||                    & z_Press, r_Press,                     &  ! (in)
   546: ||                    & z_DQH2OLiqDt, z_DQH2OSolDt            &  ! (out)
   547: ||                    & )
   548: ||          
   549: ||V---->            do k = 1, kmax
   550: |||     A             xyz_Temp      (i,j,k) = z_Temp      (k)
   551: |||     A             xyz_QVap      (i,j,k) = z_QVap      (k)
   552: |||     A             xyz_QH2OLiq   (i,j,k) = z_QH2OLiq   (k)
   553: |||     A             xyz_QH2OSol   (i,j,k) = z_QH2OSol   (k)
   554: |||     A             xyz_DQH2OLiqDt(i,j,k) = z_DQH2OLiqDt(k)
   555: |||     A             xyz_DQH2OSolDt(i,j,k) = z_DQH2OSolDt(k)
   556: ||V----             end do
   557: ||          
   558: |+-----           end do
   559: +------         end do
   560:             
   561:             
   562:                 ! calculation for output
   563: W*=====         xy_RainLsc     = 0.0_DP
   564: +------>        do k = kmax, 1, -1
   565: |W*==== A         xy_RainLsc = xy_RainLsc                                     &
   566: |                   & + xyz_DQH2OLiqDt(:,:,k) * ( xyr_Press(:,:,k-1) - xyr_Press(:,:,k) ) / Grav
   567: +------         end do
   568:             
   569:             
   570:                 ! ヒストリデータ出力
   571:                 ! History data output
   572:                 !
   573:                 if ( .not. present( FlagOutput ) ) then
   574:                   call HistoryAutoPut( TimeN, 'DTempDtLsc', xyz_DTempDtLsc )
   575:                   call HistoryAutoPut( TimeN, 'DQH2OVapDtLsc', xyz_DQVapDtLsc )
   576:                   call HistoryAutoPut( TimeN, 'DQH2OLiqDtLsc', xyz_DQH2OLiqDt )
   577:                   call HistoryAutoPut( TimeN, 'DQH2OSolDtLsc', xyz_DQH2OSolDt )
   578:                 else
   579:                   if ( FlagOutput ) then
   580:                     call HistoryAutoPut( TimeN, 'DTempDtLsc', xyz_DTempDtLsc )
   581:                     call HistoryAutoPut( TimeN, 'DQH2OVapDtLsc', xyz_DQVapDtLsc )
   582:                     call HistoryAutoPut( TimeN, 'DQH2OLiqDtLsc', xyz_DQH2OLiqDt )
   583:                     call HistoryAutoPut( TimeN, 'DQH2OSolDtLsc', xyz_DQH2OSolDt )
   584:                   end if
   585:                 end if
   586:             
   587:             
   588:                 ! 計算時間計測一時停止
   589:                 ! Pause measurement of computation time
   590:                 !
   591:                 call TimesetClockStop( module_name )
   592:             
   593:               end subroutine LScaleCond1D3DWrapper
   594:             
   595:               !--------------------------------------------------------------------------------------
   596:             
   597:               subroutine LScaleCond1D_BK(  &
   598:                 & z_Temp, z_QVap, z_QH2OLiq, z_QH2OSol, &  ! (inout)
   599:                 & z_Press, r_Press,                     &  ! (in)
   600:                 & z_DQH2OLiqDt, z_DQH2OSolDt            &  ! (out)
   601:                 & )
   602:                 !
   603:                 ! 大規模凝結スキームにより, 温度と比湿を調節します. 
   604:                 !
   605:                 ! Adjust temperature and specific humidity by 
   606:                 ! large scale condensation scheme. 
   607:                 !
   608:             
   609:                 ! モジュール引用 ; USE statements
   610:                 !
   611:             
   612:                 ! 物理定数設定
   613:                 ! Physical constants settings
   614:                 !
   615:                 use constants, only: &
   616:                   & Grav, & 
   617:                                           ! $ g $ [m s-2]. 
   618:                                           ! 重力加速度. 
   619:                                           ! Gravitational acceleration
   620:                   & CpDry, &
   621:                                           ! $ C_p $ [J kg-1 K-1]. 
   622:                                           ! 乾燥大気の定圧比熱. 
   623:                                           ! Specific heat of air at constant pressure
   624:                   & LatentHeat, &
   625:                                           ! $ L $ [J kg-1] . 
   626:                                           ! 凝結の潜熱. 
   627:                                           ! Latent heat of condensation
   628:                   & LatentHeatFusion
   629:                                           ! $ L $ [J kg-1] .
   630:                                           ! 融解の潜熱.
   631:                                           ! Latent heat of fusion
   632:             
   633:                 ! 時刻管理
   634:                 ! Time control
   635:                 !
   636:                 use timeset, only: &
   637:                   & DelTime, &            ! $ \Delta t $
   638:                   & TimeN, &              ! ステップ $ t $ の時刻. Time of step $ t $. 
   639:                   & TimesetClockStart, TimesetClockStop
   640:             
   641:                 ! ヒストリデータ出力
   642:                 ! History data output
   643:                 !
   644:                 use gtool_historyauto, only: HistoryAutoPut
   645:             
   646:                 ! 飽和比湿の算出
   647:                 ! Evaluate saturation specific humidity
   648:                 !
   649:                 use saturate, only: a_CalcQVapSat, a_CalcDQVapSatDTemp
   650:             
   651:                 ! 飽和比湿の算出
   652:                 ! Evaluate saturation specific humidity
   653:                 !
   654:                 use saturate, only : SaturateWatFraction
   655:             
   656:             
   657:                 ! 宣言文 ; Declaration statements
   658:                 !
   659:                 implicit none
   660:             
   661:                 real(DP), intent(inout):: z_Temp (1:kmax)
   662:                                           ! $ T $ .     温度. Temperature
   663:                 real(DP), intent(inout):: z_QVap (1:kmax)
   664:                                           ! $ q $ .     比湿. Specific humidity
   665:                 real(DP), intent(inout):: z_QH2OLiq(1:kmax)
   666:                                           ! Specific liquid water content
   667:                 real(DP), intent(inout):: z_QH2OSol(1:kmax)
   668:                                           ! Specific ice content
   669:                 real(DP), intent(in   ):: z_Press (1:kmax)
   670:                                           ! $ p $ . 気圧 (整数レベル). 
   671:                                           ! Air pressure (full level)
   672:                 real(DP), intent(in   ):: r_Press (0:kmax)
   673:                                           ! $ \hat{p} $ . 気圧 (半整数レベル). 
   674:                                           ! Air pressure (half level)
   675:                 real(DP), intent(out  ):: z_DQH2OLiqDt(1:kmax)
   676:                                           !
   677:                                           ! Tendency of H2O liquid mixing ratio
   678:                 real(DP), intent(out  ):: z_DQH2OSolDt(1:kmax)
   679:                                           !
   680:                                           ! Tendency of H2O ice mixing ratio
   681:             
   682:             
   683:                 ! 作業変数
   684:                 ! Work variables
   685:                 !
   686:                 real(DP):: z_DTempDtLsc (1:kmax)
   687:                                           ! 温度変化率. 
   688:                                           ! Temperature tendency
   689:                 real(DP):: z_DQVapDtLsc (1:kmax)
   690:                                           ! 比湿変化率. 
   691:                                           ! Specific humidity tendency
   692:             
   693:                 real(DP):: z_QH2OVap0 (1:kmax)
   694:                                           ! 調節前の比湿. 
   695:                                           ! Specific humidity before adjust. 
   696:                 real(DP):: z_QH2OLiq0 (1:kmax)
   697:                                           ! 
   698:                                           ! Specific liquid water content before adjust. 
   699:                 real(DP):: z_QH2OSol0 (1:kmax)
   700:                                           ! 
   701:                                           ! Specific liquid water content before adjust. 
   702:                 real(DP):: z_Temp0    (1:kmax)
   703:                                           ! 調節前の温度. 
   704:                                           ! Temperature before adjust. 
   705:                                           !
   706:                 real(DP):: z_QH2OVapB (1:kmax)
   707:                                           ! 調節前の比湿. 
   708:                                           ! Specific humidity before adjust. 
   709:                 real(DP):: z_QH2OLiqB (1:kmax)
   710:                                           ! 
   711:                                           ! Specific liquid water content before adjust. 
   712:                 real(DP):: z_QH2OSolB (1:kmax)
   713:                                           ! 
   714:                                           ! Specific liquid water content before adjust. 
   715:                 real(DP):: z_TempB    (1:kmax)
   716:                                           ! 調節前の温度. 
   717:                                           ! Temperature before adjust. 
   718:                                           !
   719:                 real(DP):: z_QVapSat      (1:kmax)
   720:                                           ! 飽和比湿. 
   721:                                           ! Saturation specific humidity. 
   722:                 real(DP):: z_DQVapSatDTemp(1:kmax)
   723:                                           ! $ \DD{q_{\rm{sat}}}{T} $
   724:                 real(DP):: DelTemp
   725:                                           ! 調節による温度変化量. 
   726:                                           ! Temperature variation by adjustment
   727:             
   728:                 real(DP) :: WatFrac
   729:                 real(DP) :: IceFrac
   730:             
   731:             
   732:                 integer:: k               ! 鉛直方向に回る DO ループ用作業変数
   733:                                           ! Work variables for DO loop in vertical direction
   734:                 integer:: itr             ! イテレーション方向に回る DO ループ用作業変数
   735:                                           ! Work variables for DO loop in iteration direction
   736:                 logical:: z_FlagProcess(1:kmax)
   737:             
   738:             
   739:                 ! 実行文 ; Executable statement
   740:                 !
   741:             
   742:                 ! 初期化確認
   743:                 ! Initialization check
   744:                 !
   745:                 if ( .not. lscond_inited ) then
   746:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   747:                 end if
   748:             
   749:             
   750:             !!$    ! 計算時間計測開始
   751:             !!$    ! Start measurement of computation time
   752:             !!$    !
   753:             !!$    call TimesetClockStart( module_name )
   754:             
   755:             
   756:                 ! 調節前 "QVap", "Temp" の保存
   757:                 ! Store "QVap", "Temp" before adjustment
   758:                 !
   759: V------>A       z_QH2OVap0 = z_QVap
   760: |       A       z_QH2OLiq0 = z_QH2OLiq
   761: |       A       z_QH2OSol0 = z_QH2OSol
   762: V------ A       z_Temp0    = z_Temp
   763:             
   764:             
   765:                 ! 調節
   766:                 ! Adjustment
   767:                 !
   768:             
   769:                 ! 飽和比湿計算
   770:                 ! Calculate saturation specific humidity 
   771:                 !
   772:             
   773:                 if ( FlagSatAdj ) then
   774: V------>A         z_Temp = z_Temp &
   775: |                   & + ( LatentHeat * z_QH2OLiq + ( LatentHeat + LatentHeatFusion ) * z_QH2OSol ) / CpDry
   776: |       A         z_QVap = z_QVap + z_QH2OLiq + z_QH2OSol
   777: |       A         z_QH2OLiq = 0.0_DP
   778: V------ A         z_QH2OSol = 0.0_DP
   779:                 else
   780:                   ! Pre-existing cloud water and ice are removed, since those are not 
   781:                   ! responsible with condensation (assumption).
   782: V------>A         z_QH2OLiq = 0.0_DP
   783: V------ A         z_QH2OSol = 0.0_DP
   784:                 end if
   785:                 !
   786:                 z_QVapSat = a_CalcQVapSat( z_Temp, z_Press )
   787:                 !
   788: V------>        do k = 1, kmax
   789: |       A         if ( ( z_QVap(k) / z_QVapSat(k) ) >= CrtlRH ) then
   790: |                   z_FlagProcess(k) = .true.
   791: |                 else
   792: |                   z_FlagProcess(k) = .false.
   793: |                 end if
   794: V------         end do
   795:             
   796:             
   797: +------>        do itr = 1, ItrtMax
   798: |           
   799: |V----->A         z_QH2OVapB = z_QVap
   800: ||      A         z_QH2OLiqB = z_QH2OLiq
   801: ||      A         z_QH2OSolB = z_QH2OSol
   802: ||                z_TempB    = z_Temp
   803: ||          
   804: ||                ! 飽和比湿計算
   805: ||                ! Calculate saturation specific humidity
   806: ||                !
   807: |V----- A         z_QVapSat       = a_CalcQVapSat      ( z_Temp, z_Press   )
   808: |                 z_DQVapSatDTemp = a_CalcDQVapSatDTemp( z_Temp, z_QVapSat )
   809: |           
   810: |           
   811: |+----->          do k = 1, kmax
   812: ||          
   813: ||                  ! 飽和していたら, 温度と比湿の変化を計算
   814: ||                  ! Calculate tendency of temperature and humidity 
   815: ||                  ! if moist is saturation. 
   816: ||                  !
   817: ||                  if ( z_FlagProcess(k) ) then
   818: ||          
   819: ||                    ! Liquid water and ice fractions
   820: ||                    call SaturateWatFraction(   &
   821: ||                      & z_Temp(k),              & ! (in )
   822: ||                      & WatFrac                 & ! (out)
   823: ||                      & )
   824: ||                    IceFrac = 1.0_DP - WatFrac
   825: ||          
   826: ||                    ! 温度の変化分をニュートン法で求める
   827: ||                    ! Calculate variation of temperature
   828: ||                    !
   829: ||                    DelTemp =                                                         &
   830: ||                      &   (   LatentHeat * z_QVap(k)                                  &
   831: ||                      &     - LatentHeatFusion * z_QH2OSol(k)                         &
   832: ||                      &     + LatentHeatFusion                                        &
   833: ||                      &       * IceFrac * ( z_QVap(k) + z_QH2OLiq(k) + z_QH2OSol(k) ) &
   834: ||                      &     - ( LatentHeat + LatentHeatFusion * IceFrac )             &
   835: ||                      &       * CrtlRH * z_QVapSat(k) )                               &
   836: ||                      & / (   CpDry &
   837: ||                      &     + ( LatentHeat + LatentHeatFusion * IceFrac ) &
   838: ||                      &       * CrtlRH * z_DQVapSatDTemp(k) )
   839: ||          
   840: ||          
   841: ||                    ! 温度と比湿の調節
   842: ||                    ! Adjust temperature and specific humidity
   843: ||                    !
   844: ||                    z_Temp(k) = z_Temp(k) + DelTemp
   845: ||                    z_QVap(k) = &
   846: ||                      & CrtlRH * ( z_QVapSat(k) + z_DQVapSatDTemp(k) * DelTemp )
   847: ||                    z_QH2OLiq(k) = &
   848: ||                      & WatFrac &
   849: ||                      & * ( z_QH2OVapB(k) + z_QH2OLiqB(k) + z_QH2OSolB(k) - z_QVap(k) )
   850: ||                    z_QH2OSol(k) = &
   851: ||                      & IceFrac &
   852: ||                      & * ( z_QH2OVapB(k) + z_QH2OLiqB(k) + z_QH2OSolB(k) - z_QVap(k) )
   853: ||          
   854: ||                  end if
   855: ||          
   856: |+-----           end do
   857: |           
   858: +------         end do
   859:             
   860:             
   861:                 if ( FlagSatAdj ) then
   862:                 else
   863:                   ! Pre-existing cloud water and ice amount are restored. 
   864: V------>A         z_QH2OLiq = z_QH2OLiq + z_QH2OLiq0
   865: V------ A         z_QH2OSol = z_QH2OSol + z_QH2OSol0
   866:                 end if
   867:             
   868:             
   869:                 ! 比湿変化率, 温度変化率, 降水量の算出
   870:                 ! Calculate specific humidity tendency, temperature tendency, 
   871:                 ! precipitation
   872:                 !
   873: V------>        z_DTempDtLsc = ( z_Temp    - z_Temp0    ) / ( 2.0_DP * DelTime )
   874: |               z_DQVapDtLsc = ( z_QVap    - z_QH2OVap0 ) / ( 2.0_DP * DelTime )
   875: |       A       z_DQH2OLiqDt = ( z_QH2OLiq - z_QH2OLiq0 ) / ( 2.0_DP * DelTime )
   876: V------ A       z_DQH2OSolDt = ( z_QH2OSol - z_QH2OSol0 ) / ( 2.0_DP * DelTime )
   877:             
   878:             
   879:                 call LScaleCond1DConsChk(                        &
   880:                   & z_Temp0, z_QH2OVap0, z_QH2OLiq0, z_QH2OSol0, &
   881:                   & z_Temp , z_QVap    , z_QH2OLiq , z_QH2OSol   &
   882:                   & )
   883:             
   884:             
   885:             !!$    ! 計算時間計測一時停止
   886:             !!$    ! Pause measurement of computation time
   887:             !!$    !
   888:             !!$    call TimesetClockStop( module_name )
   889:             
   890:               end subroutine LScaleCond1D_BK
   891:             
   892:               !--------------------------------------------------------------------------------------
   893:             
   894:               subroutine LScaleCond1D(  &
   895:                 & z_Temp, z_QVap, z_QH2OLiq, z_QH2OSol, &  ! (inout)
   896:                 & z_Press, r_Press,                     &  ! (in)
   897:                 & z_DQH2OLiqDt, z_DQH2OSolDt            &  ! (out)
   898:                 & )
   899:                 !
   900:                 ! 大規模凝結スキームにより, 温度と比湿を調節します. 
   901:                 !
   902:                 ! Adjust temperature and specific humidity by 
   903:                 ! large scale condensation scheme. 
   904:                 !
   905:             
   906:                 ! モジュール引用 ; USE statements
   907:                 !
   908:             
   909:                 ! 物理定数設定
   910:                 ! Physical constants settings
   911:                 !
   912:                 use constants, only: &
   913:                   & Grav, & 
   914:                                           ! $ g $ [m s-2]. 
   915:                                           ! 重力加速度. 
   916:                                           ! Gravitational acceleration
   917:                   & CpDry, &
   918:                                           ! $ C_p $ [J kg-1 K-1]. 
   919:                                           ! 乾燥大気の定圧比熱. 
   920:                                           ! Specific heat of air at constant pressure
   921:                   & LatentHeat, &
   922:                                           ! $ L $ [J kg-1] . 
   923:                                           ! 凝結の潜熱. 
   924:                                           ! Latent heat of condensation
   925:                   & LatentHeatFusion
   926:                                           ! $ L $ [J kg-1] .
   927:                                           ! 融解の潜熱.
   928:                                           ! Latent heat of fusion
   929:             
   930:                 ! 時刻管理
   931:                 ! Time control
   932:                 !
   933:                 use timeset, only: &
   934:                   & DelTime, &            ! $ \Delta t $
   935:                   & TimeN, &              ! ステップ $ t $ の時刻. Time of step $ t $. 
   936:                   & TimesetClockStart, TimesetClockStop
   937:             
   938:                 ! ヒストリデータ出力
   939:                 ! History data output
   940:                 !
   941:                 use gtool_historyauto, only: HistoryAutoPut
   942:             
   943:                 ! 飽和比湿の算出
   944:                 ! Evaluate saturation specific humidity
   945:                 !
   946:                 use saturate, only: a_CalcQVapSat, a_CalcDQVapSatDTemp
   947:             
   948:             
   949:                 ! 宣言文 ; Declaration statements
   950:                 !
   951:                 implicit none
   952:             
   953:                 real(DP), intent(inout):: z_Temp (1:kmax)
   954:                                           ! $ T $ .     温度. Temperature
   955:                 real(DP), intent(inout):: z_QVap (1:kmax)
   956:                                           ! $ q $ .     比湿. Specific humidity
   957:                 real(DP), intent(inout):: z_QH2OLiq(1:kmax)
   958:                                           ! Specific liquid water content
   959:                 real(DP), intent(inout):: z_QH2OSol(1:kmax)
   960:                                           ! Specific ice content
   961:                 real(DP), intent(in   ):: z_Press (1:kmax)
   962:                                           ! $ p $ . 気圧 (整数レベル). 
   963:                                           ! Air pressure (full level)
   964:                 real(DP), intent(in   ):: r_Press (0:kmax)
   965:                                           ! $ \hat{p} $ . 気圧 (半整数レベル). 
   966:                                           ! Air pressure (half level)
   967:                 real(DP), intent(out  ):: z_DQH2OLiqDt(1:kmax)
   968:                                           !
   969:                                           ! Tendency of H2O liquid mixing ratio
   970:                 real(DP), intent(out  ):: z_DQH2OSolDt(1:kmax)
   971:                                           !
   972:                                           ! Tendency of H2O ice mixing ratio
   973:             
   974:             
   975:                 ! 作業変数
   976:                 ! Work variables
   977:                 !
   978:                 integer:: k               ! 鉛直方向に回る DO ループ用作業変数
   979:                                           ! Work variables for DO loop in vertical direction
   980:             
   981:             
   982:                 ! 実行文 ; Executable statement
   983:                 !
   984:             
   985:                 ! 初期化確認
   986:                 ! Initialization check
   987:                 !
   988:                 if ( .not. lscond_inited ) then
   989:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   990:                 end if
   991:             
   992:             
   993:             !!$    ! 計算時間計測開始
   994:             !!$    ! Start measurement of computation time
   995:             !!$    !
   996:             !!$    call TimesetClockStart( module_name )
   997:             
   998:             
   999: +------>        do k = 1, kmax
  1000: |                 call LScaleCond1Grid(  &
  1001: |                   & z_Temp(k), z_QVap(k), z_QH2OLiq(k), z_QH2OSol(k), &  ! (inout)
  1002: |                   & z_Press(k), r_Press(k-1), r_Press(k),      &  ! (in)
  1003: |                   & z_DQH2OLiqDt(k), z_DQH2OSolDt(k)        &  ! (out)
  1004: |                   & )
  1005: +------         end do
  1006:             
  1007:             
  1008:             !!$    ! 計算時間計測一時停止
  1009:             !!$    ! Pause measurement of computation time
  1010:             !!$    !
  1011:             !!$    call TimesetClockStop( module_name )
  1012:             
  1013:               end subroutine LScaleCond1D
  1014:             
  1015:               !--------------------------------------------------------------------------------------
  1016:             
  1017:               subroutine LScaleCond1Grid(  &
  1018:                 & Temp, QVap, QH2OLiq, QH2OSol, &  ! (inout)
  1019:                 & Press, PressLI, PressUI,      &  ! (in)
  1020:                 & DQH2OLiqDt, DQH2OSolDt        &  ! (out)
  1021:                 & )
  1022:                 !
  1023:                 ! 大規模凝結スキームにより, 温度と比湿を調節します. 
  1024:                 !
  1025:                 ! Adjust temperature and specific humidity by 
  1026:                 ! large scale condensation scheme. 
  1027:                 !
  1028:             
  1029:                 ! モジュール引用 ; USE statements
  1030:                 !
  1031:             
  1032:                 ! 物理定数設定
  1033:                 ! Physical constants settings
  1034:                 !
  1035:                 use constants, only: &
  1036:                   & Grav, & 
  1037:                                           ! $ g $ [m s-2]. 
  1038:                                           ! 重力加速度. 
  1039:                                           ! Gravitational acceleration
  1040:                   & CpDry, &
  1041:                                           ! $ C_p $ [J kg-1 K-1]. 
  1042:                                           ! 乾燥大気の定圧比熱. 
  1043:                                           ! Specific heat of air at constant pressure
  1044:                   & LatentHeat, &
  1045:                                           ! $ L $ [J kg-1] . 
  1046:                                           ! 凝結の潜熱. 
  1047:                                           ! Latent heat of condensation
  1048:                   & LatentHeatFusion
  1049:                                           ! $ L $ [J kg-1] .
  1050:                                           ! 融解の潜熱.
  1051:                                           ! Latent heat of fusion
  1052:             
  1053:                 ! 時刻管理
  1054:                 ! Time control
  1055:                 !
  1056:                 use timeset, only: &
  1057:                   & DelTime, &            ! $ \Delta t $
  1058:                   & TimeN, &              ! ステップ $ t $ の時刻. Time of step $ t $. 
  1059:                   & TimesetClockStart, TimesetClockStop
  1060:             
  1061:                 ! ヒストリデータ出力
  1062:                 ! History data output
  1063:                 !
  1064:                 use gtool_historyauto, only: HistoryAutoPut
  1065:             
  1066:                 ! 飽和比湿の算出
  1067:                 ! Evaluate saturation specific humidity
  1068:                 !
  1069:                 use saturate, only: CalcQVapSat, CalcDQVapSatDTemp
  1070:             
  1071:                 ! 飽和比湿の算出
  1072:                 ! Evaluate saturation specific humidity
  1073:                 !
  1074:                 use saturate, only : SaturateWatFraction
  1075:             
  1076:             
  1077:                 ! 宣言文 ; Declaration statements
  1078:                 !
  1079:                 implicit none
  1080:             
  1081:                 real(DP), intent(inout):: Temp
  1082:                                           ! $ T $ .     温度. Temperature
  1083:                 real(DP), intent(inout):: QVap
  1084:                                           ! $ q $ .     比湿. Specific humidity
  1085:                 real(DP), intent(inout):: QH2OLiq
  1086:                                           ! Specific liquid water content
  1087:                 real(DP), intent(inout):: QH2OSol
  1088:                                           ! Specific ice content
  1089:                 real(DP), intent(in   ):: Press
  1090:                                           ! $ p $ . 気圧 (整数レベル). 
  1091:                                           ! Air pressure (full level)
  1092:                 real(DP), intent(in   ):: PressLI
  1093:                                           ! $ \hat{p} $ . 気圧 (半整数レベル). 
  1094:                                           ! Air pressure (half level)
  1095:                 real(DP), intent(in   ):: PressUI
  1096:                                           ! $ \hat{p} $ . 気圧 (半整数レベル). 
  1097:                                           ! Air pressure (half level)
  1098:                 real(DP), intent(out  ):: DQH2OLiqDt
  1099:                                           !
  1100:                                           ! Tendency of H2O liquid mixing ratio
  1101:                 real(DP), intent(out  ):: DQH2OSolDt
  1102:                                           !
  1103:                                           ! Tendency of H2O ice mixing ratio
  1104:             
  1105:             
  1106:                 ! 作業変数
  1107:                 ! Work variables
  1108:                 !
  1109:                 real(DP):: DTempDtLsc
  1110:                                           ! 温度変化率. 
  1111:                                           ! Temperature tendency
  1112:                 real(DP):: DQVapDtLsc
  1113:                                           ! 比湿変化率. 
  1114:                                           ! Specific humidity tendency
  1115:             
  1116:                 real(DP):: QH2OVap0
  1117:                                           ! 調節前の比湿. 
  1118:                                           ! Specific humidity before adjust. 
  1119:                 real(DP):: QH2OLiq0
  1120:                                           ! 
  1121:                                           ! Specific liquid water content before adjust. 
  1122:                 real(DP):: QH2OSol0
  1123:                                           ! 
  1124:                                           ! Specific liquid water content before adjust. 
  1125:                 real(DP):: Temp0
  1126:                                           ! 調節前の温度. 
  1127:                                           ! Temperature before adjust. 
  1128:                                           !
  1129:                 real(DP):: QH2OVapB
  1130:                                           ! 調節前の比湿. 
  1131:                                           ! Specific humidity before adjust. 
  1132:                 real(DP):: QH2OLiqB
  1133:                                           ! 
  1134:                                           ! Specific liquid water content before adjust. 
  1135:                 real(DP):: QH2OSolB
  1136:                                           ! 
  1137:                                           ! Specific liquid water content before adjust. 
  1138:                 real(DP):: TempB
  1139:                                           ! 調節前の温度. 
  1140:                                           ! Temperature before adjust. 
  1141:                                           !
  1142:                 real(DP):: QVapSat
  1143:                                           ! 飽和比湿. 
  1144:                                           ! Saturation specific humidity. 
  1145:                 real(DP):: DQVapSatDTemp
  1146:                                           ! $ \DD{q_{\rm{sat}}}{T} $
  1147:                 real(DP):: DelTemp
  1148:                                           ! 調節による温度変化量. 
  1149:                                           ! Temperature variation by adjustment
  1150:             
  1151:                 real(DP) :: WatFrac
  1152:                 real(DP) :: IceFrac
  1153:             
  1154:             
  1155:                 integer:: itr             ! イテレーション方向に回る DO ループ用作業変数
  1156:                                           ! Work variables for DO loop in iteration direction
  1157:                 logical:: FlagProcess
  1158:             
  1159:             
  1160:                 ! 実行文 ; Executable statement
  1161:                 !
  1162:             
  1163:                 ! 初期化確認
  1164:                 ! Initialization check
  1165:                 !
  1166:                 if ( .not. lscond_inited ) then
  1167:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
  1168:                 end if
  1169:             
  1170:             
  1171:             !!$    ! 計算時間計測開始
  1172:             !!$    ! Start measurement of computation time
  1173:             !!$    !
  1174:             !!$    call TimesetClockStart( module_name )
  1175:             
  1176:             
  1177:                 ! 調節前 "QVap", "Temp" の保存
  1178:                 ! Store "QVap", "Temp" before adjustment
  1179:                 !
  1180:                 QH2OVap0 = QVap
  1181:                 QH2OLiq0 = QH2OLiq
  1182:                 QH2OSol0 = QH2OSol
  1183:                 Temp0    = Temp
  1184:             
  1185:             
  1186:                 ! 調節
  1187:                 ! Adjustment
  1188:                 !
  1189:             
  1190:                 ! 飽和比湿計算
  1191:                 ! Calculate saturation specific humidity 
  1192:                 !
  1193:             
  1194:                 if ( FlagSatAdj ) then
  1195:                   Temp = Temp &
  1196:                     & + ( LatentHeat * QH2OLiq + ( LatentHeat + LatentHeatFusion ) * QH2OSol ) / CpDry
  1197:                   QVap    = QVap + QH2OLiq + QH2OSol
  1198:                   QH2OLiq = 0.0_DP
  1199:                   QH2OSol = 0.0_DP
  1200:                 else
  1201:                   ! Pre-existing cloud water and ice are removed, since those are not 
  1202:                   ! responsible with condensation (assumption).
  1203:                   QH2OLiq = 0.0_DP
  1204:                   QH2OSol = 0.0_DP
  1205:                 end if
  1206:                 !
  1207:                 QVapSat = CalcQVapSat( Temp, Press )
  1208:                 !
  1209:                 if ( ( QVap / QVapSat ) >= CrtlRH ) then
  1210:                   FlagProcess = .true.
  1211:                 else
  1212:                   FlagProcess = .false.
  1213:                 end if
  1214:             
  1215:             
  1216: +------>        do itr = 1, ItrtMax
  1217: |           
  1218: |                 QH2OVapB = QVap
  1219: |                 QH2OLiqB = QH2OLiq
  1220: |                 QH2OSolB = QH2OSol
  1221: |                 TempB    = Temp
  1222: |           
  1223: |                 ! 飽和比湿計算
  1224: |                 ! Calculate saturation specific humidity
  1225: |                 !
  1226: |                 QVapSat       = CalcQVapSat      ( Temp, Press   )
  1227: |                 DQVapSatDTemp = CalcDQVapSatDTemp( Temp, QVapSat )
  1228: |           
  1229: |           
  1230: |                 ! 飽和していたら, 温度と比湿の変化を計算
  1231: |                 ! Calculate tendency of temperature and humidity 
  1232: |                 ! if moist is saturation. 
  1233: |                 !
  1234: |                 if ( FlagProcess ) then
  1235: |           
  1236: |                   ! Liquid water and ice fractions
  1237: |                   call SaturateWatFraction(   &
  1238: |                     & Temp,                   & ! (in )
  1239: |                     & WatFrac                 & ! (out)
  1240: |                     & )
  1241: |                   IceFrac = 1.0_DP - WatFrac
  1242: |           
  1243: |                   ! 温度の変化分をニュートン法で求める
  1244: |                   ! Calculate variation of temperature
  1245: |                   !
  1246: |           !!$          DelTemp =                                                 &
  1247: |           !!$            & LatentHeatLocal                                       &
  1248: |           !!$            &   * ( z_QVap(k) - CrtlRH * z_QVapSat(k) )             &
  1249: |           !!$            &   / ( CpDry + LatentHeatLocal * CrtlRH * z_DQVapSatDTemp(k) )
  1250: |                   DelTemp =                                                         &
  1251: |                     &   (   LatentHeat * QVap                                  &
  1252: |                     &     - LatentHeatFusion * QH2OSol                         &
  1253: |                     &     + LatentHeatFusion                                        &
  1254: |                     &       * IceFrac * ( QVap + QH2OLiq + QH2OSol ) &
  1255: |                     &     - ( LatentHeat + LatentHeatFusion * IceFrac )             &
  1256: |                     &       * CrtlRH * QVapSat )                               &
  1257: |                     & / (   CpDry &
  1258: |                     &     + ( LatentHeat + LatentHeatFusion * IceFrac ) &
  1259: |                     &       * CrtlRH * DQVapSatDTemp )
  1260: |           
  1261: |           
  1262: |                   ! 温度と比湿の調節
  1263: |                   ! Adjust temperature and specific humidity
  1264: |                   !
  1265: |                   Temp = Temp + DelTemp
  1266: |                   QVap = &
  1267: |                     & CrtlRH * ( QVapSat + DQVapSatDTemp * DelTemp )
  1268: |                   QH2OLiq = &
  1269: |                     & WatFrac &
  1270: |                     & * ( QH2OVapB + QH2OLiqB + QH2OSolB - QVap )
  1271: |                   QH2OSol = &
  1272: |                     & IceFrac &
  1273: |                     & * ( QH2OVapB + QH2OLiqB + QH2OSolB - QVap )
  1274: |           
  1275: |                 end if
  1276: |           
  1277: +------         end do
  1278:             
  1279:             
  1280:                 if ( FlagSatAdj ) then
  1281:                 else
  1282:                   ! Pre-existing cloud water and ice amount are restored. 
  1283:                   QH2OLiq = QH2OLiq + QH2OLiq0
  1284:                   QH2OSol = QH2OSol + QH2OSol0
  1285:                 end if
  1286:             
  1287:             
  1288:                 ! 比湿変化率, 温度変化率, 降水量の算出
  1289:                 ! Calculate specific humidity tendency, temperature tendency, 
  1290:                 ! precipitation
  1291:                 !
  1292:                 DTempDtLsc = ( Temp    - Temp0    ) / ( 2.0_DP * DelTime )
  1293:                 DQVapDtLsc = ( QVap    - QH2OVap0 ) / ( 2.0_DP * DelTime )
  1294:                 DQH2OLiqDt = ( QH2OLiq - QH2OLiq0 ) / ( 2.0_DP * DelTime )
  1295:                 DQH2OSolDt = ( QH2OSol - QH2OSol0 ) / ( 2.0_DP * DelTime )
  1296:             
  1297:             
  1298:                 call LScaleCond1GridConsChk(             &
  1299:                   & Temp0, QH2OVap0, QH2OLiq0, QH2OSol0, &
  1300:                   & Temp , QVap    , QH2OLiq , QH2OSol   &
  1301:                   & )
  1302:             
  1303:             
  1304:             !!$    ! 計算時間計測一時停止
  1305:             !!$    ! Pause measurement of computation time
  1306:             !!$    !
  1307:             !!$    call TimesetClockStop( module_name )
  1308:             
  1309:               end subroutine LScaleCond1Grid
  1310:             
  1311:               !--------------------------------------------------------------------------------------
  1312:             
  1313:               subroutine LScaleCondLL911D3DWrapper(             &
  1314:                 & xyz_Temp, xyz_QVap, xyz_QH2OLiq, xyz_QH2OSol, &  ! (inout)
  1315:                 & xyz_Press, xyr_Press,                         &  ! (in)
  1316:                 & xyz_DQH2OLiqDt, xyz_DQH2OSolDt,               &  ! (out)
  1317:                 & xyz_CloudCover,                               &  ! (out)optional
  1318:                 & FlagOutput                                    &  ! (in) optional
  1319:                 & )
  1320:                 !
  1321:                 ! 大規模凝結スキームにより, 温度と比湿を調節します. 
  1322:                 !
  1323:                 ! Adjust temperature and specific humidity by 
  1324:                 ! large scale condensation scheme. 
  1325:                 !
  1326:             
  1327:                 ! モジュール引用 ; USE statements
  1328:                 !
  1329:             
  1330:                 ! OpenMP
  1331:                 !
  1332:                 !$ use omp_lib
  1333:             
  1334:                 ! 物理定数設定
  1335:                 ! Physical constants settings
  1336:                 !
  1337:                 use constants, only: &
  1338:                   & Grav
  1339:                                           ! $ g $ [m s-2]. 
  1340:                                           ! 重力加速度. 
  1341:                                           ! Gravitational acceleration
  1342:             
  1343:                 ! 時刻管理
  1344:                 ! Time control
  1345:                 !
  1346:                 use timeset, only: &
  1347:                   & DelTime, &            ! $ \Delta t $
  1348:                   & TimeN, &              ! ステップ $ t $ の時刻. Time of step $ t $. 
  1349:                   & TimesetClockStart, TimesetClockStop
  1350:             
  1351:                 ! ヒストリデータ出力
  1352:                 ! History data output
  1353:                 !
  1354:                 use gtool_historyauto, only: HistoryAutoPut
  1355:             
  1356:             
  1357:                 ! 宣言文 ; Declaration statements
  1358:                 !
  1359:                 implicit none
  1360:             
  1361:                 real(DP), intent(inout):: xyz_Temp (0:imax-1, 1:jmax, 1:kmax)
  1362:                                           ! $ T $ .     温度. Temperature
  1363:                 real(DP), intent(inout):: xyz_QVap (0:imax-1, 1:jmax, 1:kmax)
  1364:                                           ! $ q $ .     比湿. Specific humidity
  1365:                 real(DP), intent(inout):: xyz_QH2OLiq(0:imax-1, 1:jmax, 1:kmax)
  1366:                                           ! Specific liquid water content
  1367:                 real(DP), intent(inout):: xyz_QH2OSol(0:imax-1, 1:jmax, 1:kmax)
  1368:                                           ! Specific ice content
  1369:                 real(DP), intent(in):: xyz_Press (0:imax-1, 1:jmax, 1:kmax)
  1370:                                           ! $ p $ . 気圧 (整数レベル). 
  1371:                                           ! Air pressure (full level)
  1372:                 real(DP), intent(in):: xyr_Press (0:imax-1, 1:jmax, 0:kmax)
  1373:                                           ! $ \hat{p} $ . 気圧 (半整数レベル). 
  1374:                                           ! Air pressure (half level)
  1375:                 real(DP), intent(out) :: xyz_DQH2OLiqDt(0:imax-1,1:jmax,1:kmax)
  1376:                                           !
  1377:                                           ! Tendency of H2O liquid mixing ratio
  1378:                 real(DP), intent(out) :: xyz_DQH2OSolDt(0:imax-1,1:jmax,1:kmax)
  1379:                                           !
  1380:                                           ! Tendency of H2O ice mixing ratio
  1381:                 real(DP), intent(out), optional :: xyz_CloudCover(0:imax-1, 1:jmax, 1:kmax)
  1382:                                           !
  1383:                                           ! Cloud cover
  1384:                 logical , intent(in ), optional :: FlagOutput
  1385:                                           !
  1386:                                           ! Flag for output
  1387:             
  1388:             
  1389:                 ! 作業変数
  1390:                 ! Work variables
  1391:                 !
  1392:                 integer :: js
  1393:                 integer :: je
  1394:             
  1395:                 integer :: nthreads
  1396:                 integer, allocatable :: a_js(:)
  1397:                 integer, allocatable :: a_je(:)
  1398:             
  1399:                 real(DP):: xyz_TempB (0:imax-1, 1:jmax, 1:kmax)
  1400:                                           ! $ T $ .     温度. Temperature
  1401:                 real(DP):: xyz_QVapB (0:imax-1, 1:jmax, 1:kmax)
  1402:                                           ! $ q $ .     比湿. Specific humidity
  1403:             
  1404:                 real(DP):: xy_RainLsc (0:imax-1, 1:jmax)
  1405:                                           ! 降水量. 
  1406:                                           ! Precipitation
  1407:             
  1408:                 real(DP):: xyz_DTempDtLsc (0:imax-1, 1:jmax, 1:kmax)
  1409:                                           ! 温度変化率. 
  1410:                                           ! Temperature tendency
  1411:                 real(DP):: xyz_DQVapDtLsc (0:imax-1, 1:jmax, 1:kmax)
  1412:                                           ! 比湿変化率. 
  1413:                                           ! Specific humidity tendency
  1414:             
  1415:                 real(DP) :: z_Temp (1:kmax)
  1416:                                           ! $ T $ .     温度. Temperature
  1417:                 real(DP) :: z_QVap (1:kmax)
  1418:                                           ! $ q $ .     比湿. Specific humidity
  1419:                 real(DP) :: z_QH2OLiq(1:kmax)
  1420:                                           ! Specic liquid water content
  1421:                 real(DP) :: z_QH2OSol(1:kmax)
  1422:                                           ! Specic ice content
  1423:                 real(DP) :: z_Press (1:kmax)
  1424:                                           ! $ p $ . 気圧 (整数レベル). 
  1425:                                           ! Air pressure (full level)
  1426:                 real(DP) :: r_Press (0:kmax)
  1427:                                           ! $ \hat{p} $ . 気圧 (半整数レベル). 
  1428:                                           ! Air pressure (half level)
  1429:                 real(DP) :: z_DQH2OLiqDt(1:kmax)
  1430:                                           !
  1431:                                           ! Tendency of H2O liquid mixing ratio
  1432:                 real(DP) :: z_DQH2OSolDt(1:kmax)
  1433:                                           !
  1434:                                           ! Tendency of H2O ice mixing ratio
  1435:             
  1436:                 real(DP) :: z_CloudCover(1:kmax)
  1437:             
  1438:             
  1439:                 integer:: i               ! 経度方向に回る DO ループ用作業変数
  1440:                                           ! Work variables for DO loop in longitude
  1441:                 integer:: j               ! 緯度方向に回る DO ループ用作業変数
  1442:                                           ! Work variables for DO loop in latitude
  1443:                 integer:: k               ! 鉛直方向に回る DO ループ用作業変数
  1444:                                           ! Work variables for DO loop in vertical direction
  1445:                 integer :: n
  1446:             
  1447:             
  1448:                 ! 実行文 ; Executable statement
  1449:                 !
  1450:             
  1451:                 ! 初期化確認
  1452:                 ! Initialization check
  1453:                 !
  1454:                 if ( .not. lscond_inited ) then
  1455:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
  1456:                 end if
  1457:             
  1458:             
  1459:                 ! 計算時間計測開始
  1460:                 ! Start measurement of computation time
  1461:                 !
  1462:                 call TimesetClockStart( module_name )
  1463:             
  1464:             
  1465:                 nthreads = 1
  1466:                 !$ nthreads  = omp_get_max_threads()
  1467:             !!$    !$ write( 6, * ) "Number of processors : ", omp_get_num_procs()
  1468:             !!$    !$ write( 6, * ) "Number of threads    : ", nthreads
  1469:             
  1470:                 allocate( a_js(0:nthreads-1) )
  1471:                 allocate( a_je(0:nthreads-1) )
  1472:             
  1473: *------>        do n = 0, nthreads-1
  1474: |           
  1475: |                 if ( n == 0 ) then
  1476: |                   a_js(n) = 1
  1477: |                 else
  1478: |                   a_js(n) = a_je(n-1) + 1
  1479: |                 end if
  1480: |           
  1481: |                 a_je(n) = a_js(n  ) + jmax / nthreads - 1
  1482: |                 if ( n + 1 <= mod( jmax, nthreads ) ) then
  1483: |                   a_je(n) = a_je(n) + 1
  1484: |                 end if
  1485: |           
  1486: *------         end do
  1487:             
  1488:             
  1489:             !!$    !$OMP PARALLEL DEFAULT(PRIVATE) &
  1490:             !!$    !$OMP SHARED( &
  1491:             !!$    !$OMP         nthreads, a_js, a_je, &
  1492:             !!$    !$OMP         imax, kmax, &
  1493:             !!$    !$OMP         xyz_TempB, xyz_QVapB, &
  1494:             !!$    !$OMP         xyz_Temp, xyz_QVap, xyz_QH2OLiq, xyz_QH2OSol, &
  1495:             !!$    !$OMP         xyz_Press, xyr_Press, &
  1496:             !!$    !$OMP         xyz_DQH2OLiqDt, xyz_DQH2OSolDt, &
  1497:             !!$    !$OMP         xyz_CloudCover, &
  1498:             !!$    !$OMP         xy_RainLsc, xyz_DTempDtLsc, xyz_DQVapDtLsc, DelTime &
  1499:             !!$    !$OMP       )
  1500:             !!$
  1501:             !!$    !$OMP DO
  1502:             
  1503: *------>        do n = 0, nthreads-1
  1504: |           
  1505: |                 js = a_js(n)
  1506: |                 je = a_je(n)
  1507: |           
  1508: |                 if ( js > je ) cycle
  1509: |           
  1510: |           
  1511: |+----->          do k = 1, kmax
  1512: ||W---->            do j = js, je
  1513: |||*--->A             xyz_TempB(:,j,k) = xyz_Temp(:,j,k)
  1514: |||*--- A             xyz_QVapB(:,j,k) = xyz_QVap(:,j,k)
  1515: ||W----             end do
  1516: |+-----           end do
  1517: |           
  1518: |+----->          do j = js, je
  1519: ||+---->            do i = 0, imax-1
  1520: |||         
  1521: |||V--->              do k = 1, kmax
  1522: ||||    A               z_Temp   (k) = xyz_Temp   (i,j,k)
  1523: ||||    A               z_QVap   (k) = xyz_QVap   (i,j,k)
  1524: ||||    A               z_QH2OLiq(k) = xyz_QH2OLiq(i,j,k)
  1525: ||||    A               z_QH2OSol(k) = xyz_QH2OSol(i,j,k)
  1526: ||||    A               z_Press  (k) = xyz_Press  (i,j,k)
  1527: |||V---               end do
  1528: |||V--->              do k = 0, kmax
  1529: ||||    A               r_Press  (k) = xyr_Press  (i,j,k)
  1530: |||V---               end do
  1531: |||         
  1532: |||                   call LScaleCondLL911D(                    &
  1533: |||                     & z_Temp, z_QVap, z_QH2OLiq, z_QH2OSol, &  ! (inout)
  1534: |||                     & z_Press, r_Press,                     &  ! (in)
  1535: |||                     & z_DQH2OLiqDt, z_DQH2OSolDt,           &  ! (out)
  1536: |||                     & z_CloudCover                          &  ! (out)
  1537: |||                     & )
  1538: |||         
  1539: |||V--->              do k = 1, kmax
  1540: ||||    A               xyz_Temp      (i,j,k) = z_Temp      (k)
  1541: ||||    A               xyz_QVap      (i,j,k) = z_QVap      (k)
  1542: ||||    A               xyz_QH2OLiq   (i,j,k) = z_QH2OLiq   (k)
  1543: ||||    A               xyz_QH2OSol   (i,j,k) = z_QH2OSol   (k)
  1544: ||||    A               xyz_DQH2OLiqDt(i,j,k) = z_DQH2OLiqDt(k)
  1545: ||||    A               xyz_DQH2OSolDt(i,j,k) = z_DQH2OSolDt(k)
  1546: |||V---               end do
  1547: |||                   if ( present( xyz_CloudCover ) ) then
  1548: |||V--->                do k = 1, kmax
  1549: ||||    A                 xyz_CloudCover(i,j,k) = z_CloudCover(k)
  1550: |||V---                 end do
  1551: |||                   end if
  1552: |||         
  1553: ||+----             end do
  1554: |+-----           end do
  1555: |           
  1556: |           
  1557: |                 ! calculation for output
  1558: |+----->          do j = js, je
  1559: ||V====             xy_RainLsc(:,j)     = 0.0_DP
  1560: ||+---->            do k = kmax, 1, -1
  1561: |||V=== A             xy_RainLsc(:,j) = xy_RainLsc(:,j)                                     &
  1562: |||                     & + xyz_DQH2OLiqDt(:,j,k) * ( xyr_Press(:,j,k-1) - xyr_Press(:,j,k) ) / Grav
  1563: ||+----             end do
  1564: |+-----           end do
  1565: |           
  1566: |+----->          do k = 1, kmax
  1567: ||W---->            do j = js, je
  1568: |||*--->A             xyz_DTempDtLsc(:,j,k) = ( xyz_Temp(:,j,k) - xyz_TempB(:,j,k) ) / ( 2.0_DP * DelTime )
  1569: |||*--- A             xyz_DQVapDtLsc(:,j,k) = ( xyz_QVap(:,j,k) - xyz_QVapB(:,j,k) ) / ( 2.0_DP * DelTime )
  1570: ||W----             end do
  1571: |+-----           end do
  1572: |           
  1573: *------         end do
  1574:             
  1575:             !!$    !$OMP END DO
  1576:             !!$    !$OMP END PARALLEL
  1577:             
  1578:             
  1579:                 deallocate( a_js )
  1580:                 deallocate( a_je )
  1581:             
  1582:             
  1583:                 ! ヒストリデータ出力
  1584:                 ! History data output
  1585:                 !
  1586:                 if ( .not. present( FlagOutput ) ) then
  1587:                   call HistoryAutoPut( TimeN, 'DTempDtLsc'   , xyz_DTempDtLsc )
  1588:                   call HistoryAutoPut( TimeN, 'DQH2OVapDtLsc', xyz_DQVapDtLsc )
  1589:                   call HistoryAutoPut( TimeN, 'DQH2OLiqDtLsc', xyz_DQH2OLiqDt )
  1590:                   call HistoryAutoPut( TimeN, 'DQH2OSolDtLsc', xyz_DQH2OSolDt )
  1591:                 else
  1592:                   if ( FlagOutput ) then
  1593:                     call HistoryAutoPut( TimeN, 'DTempDtLsc'   , xyz_DTempDtLsc )
  1594:                     call HistoryAutoPut( TimeN, 'DQH2OVapDtLsc', xyz_DQVapDtLsc )
  1595:                     call HistoryAutoPut( TimeN, 'DQH2OLiqDtLsc', xyz_DQH2OLiqDt )
  1596:                     call HistoryAutoPut( TimeN, 'DQH2OSolDtLsc', xyz_DQH2OSolDt )
  1597:                   end if
  1598:                 end if
  1599:             
  1600:             
  1601:                 ! 計算時間計測一時停止
  1602:                 ! Pause measurement of computation time
  1603:                 !
  1604:                 call TimesetClockStop( module_name )
  1605:             
  1606:               end subroutine LScaleCondLL911D3DWrapper
  1607:             
  1608:               !--------------------------------------------------------------------------------------
  1609:             
  1610:               subroutine LScaleCondLL911D(  &
  1611:                 & z_Temp, z_QH2OVap, z_QH2OLiq, z_QH2OSol, &  ! (inout)
  1612:                 & z_Press, r_Press,                        &  ! (in)
  1613:                 & z_DQH2OLiqDt, z_DQH2OSolDt,              &  ! (out)
  1614:                 & z_CloudCover                             &  ! (out)
  1615:                 & )
  1616:                 !
  1617:                 ! 大規模凝結スキームにより, 温度と比湿を調節します. 
  1618:                 !
  1619:                 ! Adjust temperature and specific humidity by 
  1620:                 ! large scale condensation scheme. 
  1621:                 !
  1622:             
  1623:                 ! モジュール引用 ; USE statements
  1624:                 !
  1625:             
  1626:                 ! 物理定数設定
  1627:                 ! Physical constants settings
  1628:                 !
  1629:                 use constants, only: &
  1630:                   & Grav, & 
  1631:                                           ! $ g $ [m s-2]. 
  1632:                                           ! 重力加速度. 
  1633:                                           ! Gravitational acceleration
  1634:                   & CpDry, &
  1635:                                           ! $ C_p $ [J kg-1 K-1]. 
  1636:                                           ! 乾燥大気の定圧比熱. 
  1637:                                           ! Specific heat of air at constant pressure
  1638:                   & LatentHeat, &
  1639:                                           ! $ L $ [J kg-1] . 
  1640:                                           ! 凝結の潜熱. 
  1641:                                           ! Latent heat of condensation
  1642:                   & LatentHeatFusion
  1643:                                           ! $ L $ [J kg-1] .
  1644:                                           ! 融解の潜熱.
  1645:                                           ! Latent heat of fusion
  1646:             
  1647:                 ! 時刻管理
  1648:                 ! Time control
  1649:                 !
  1650:                 use timeset, only: &
  1651:                   & DelTime, &            ! $ \Delta t $
  1652:                   & TimeN, &              ! ステップ $ t $ の時刻. Time of step $ t $. 
  1653:                   & TimesetClockStart, TimesetClockStop
  1654:             
  1655:                 ! ヒストリデータ出力
  1656:                 ! History data output
  1657:                 !
  1658:                 use gtool_historyauto, only: HistoryAutoPut
  1659:             
  1660:                 ! 飽和比湿の算出
  1661:                 ! Evaluate saturation specific humidity
  1662:                 !
  1663:                 use saturate, only: a_CalcQVapSat, a_CalcDQVapSatDTemp
  1664:             
  1665:                 ! 飽和比湿の算出
  1666:                 ! Evaluate saturation specific humidity
  1667:                 !
  1668:                 use saturate, only : SaturateWatFraction
  1669:             
  1670:             
  1671:                 ! 宣言文 ; Declaration statements
  1672:                 !
  1673:                 implicit none
  1674:             
  1675:                 real(DP), intent(inout):: z_Temp (1:kmax)
  1676:                                           ! $ T $ .     温度. Temperature
  1677:                 real(DP), intent(inout):: z_QH2OVap (1:kmax)
  1678:                                           ! $ q $ .     比湿. Specific humidity
  1679:                 real(DP), intent(inout):: z_QH2OLiq(1:kmax)
  1680:                                           ! Specific liquid water content
  1681:                 real(DP), intent(inout):: z_QH2OSol(1:kmax)
  1682:                                           ! Specific ice content
  1683:                 real(DP), intent(in   ):: z_Press (1:kmax)
  1684:                                           ! $ p $ . 気圧 (整数レベル). 
  1685:                                           ! Air pressure (full level)
  1686:                 real(DP), intent(in   ):: r_Press (0:kmax)
  1687:                                           ! $ \hat{p} $ . 気圧 (半整数レベル). 
  1688:                                           ! Air pressure (half level)
  1689:                 real(DP), intent(out  ):: z_DQH2OLiqDt(1:kmax)
  1690:                                           !
  1691:                                           ! Tendency of H2O liquid mixing ratio
  1692:                 real(DP), intent(out  ):: z_DQH2OSolDt(1:kmax)
  1693:                                           !
  1694:                                           ! Tendency of H2O ice mixing ratio
  1695:                 real(DP), intent(out  ):: z_CloudCover(1:kmax)
  1696:             
  1697:             
  1698:                 ! 作業変数
  1699:                 ! Work variables
  1700:                 !
  1701:                 real(DP):: z_DTempDtLsc (1:kmax)
  1702:                                           ! 温度変化率. 
  1703:                                           ! Temperature tendency
  1704:                 real(DP):: z_DQH2OVapDtLsc (1:kmax)
  1705:                                           ! 比湿変化率. 
  1706:                                           ! Specific humidity tendency
  1707:             
  1708:                 real(DP):: z_QH2OTot  (1:kmax)
  1709:                                           ! 調節前の水量. 
  1710:                                           ! Specific water content before adjust. 
  1711:             
  1712:                 real(DP):: z_QH2OVap0 (1:kmax)
  1713:                                           ! 調節前の比湿. 
  1714:                                           ! Specific humidity before adjust. 
  1715:                 real(DP):: z_QH2OLiq0 (1:kmax)
  1716:                                           ! 
  1717:                                           ! Specific liquid water content before adjust. 
  1718:                 real(DP):: z_QH2OSol0 (1:kmax)
  1719:                                           ! 
  1720:                                           ! Specific liquid water content before adjust. 
  1721:                 real(DP):: z_Temp0    (1:kmax)
  1722:                                           ! 調節前の温度. 
  1723:                                           ! Temperature before adjust. 
  1724:                                           !
  1725:                 real(DP):: z_QH2OVapB (1:kmax)
  1726:                                           ! 調節前の比湿. 
  1727:                                           ! Specific humidity before adjust. 
  1728:                 real(DP):: z_QH2OLiqB (1:kmax)
  1729:                                           ! 
  1730:                                           ! Specific liquid water content before adjust. 
  1731:                 real(DP):: z_QH2OSolB (1:kmax)
  1732:                                           ! 
  1733:                                           ! Specific liquid water content before adjust. 
  1734:                 real(DP):: z_TempB    (1:kmax)
  1735:                                           ! 調節前の温度. 
  1736:                                           ! Temperature before adjust. 
  1737:                                           !
  1738:                 real(DP):: z_QH2OVapSat      (1:kmax)
  1739:                                           ! 飽和比湿. 
  1740:                                           ! Saturation specific humidity. 
  1741:                 real(DP):: z_DQH2OVapSatDTemp(1:kmax)
  1742:                                           ! $ \DD{q_{\rm{sat}}}{T} $
  1743:                 real(DP):: DelTemp
  1744:                                           ! 調節による温度変化量. 
  1745:                                           ! Temperature variation by adjustment
  1746:             
  1747:                 real(DP) :: CoefA
  1748:                 real(DP) :: CoefB
  1749:                 real(DP) :: QH2OCond
  1750:             
  1751:                 real(DP):: z_QH2OTotFluc(1:kmax)
  1752:             
  1753:                 real(DP) :: WatFrac
  1754:                 real(DP) :: IceFrac
  1755:             
  1756:                 real(DP) :: QH2OVapSat
  1757:             
  1758:                 integer:: k               ! 鉛直方向に回る DO ループ用作業変数
  1759:                                           ! Work variables for DO loop in vertical direction
  1760:                 integer:: itr             ! イテレーション方向に回る DO ループ用作業変数
  1761:                                           ! Work variables for DO loop in iteration direction
  1762:                 logical:: z_FlagProcess(1:kmax)
  1763:             
  1764:             
  1765:                 ! 実行文 ; Executable statement
  1766:                 !
  1767:             
  1768:                 ! 初期化確認
  1769:                 ! Initialization check
  1770:                 !
  1771:                 if ( .not. lscond_inited ) then
  1772:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
  1773:                 end if
  1774:             
  1775:             
  1776:             !!$    ! 計算時間計測開始
  1777:             !!$    ! Start measurement of computation time
  1778:             !!$    !
  1779:             !!$    call TimesetClockStart( module_name )
  1780:             
  1781:             
  1782:                 ! 調節前 "QH2OVap", "Temp" の保存
  1783:                 ! Store "QH2OVap", "Temp" before adjustment
  1784:                 !
  1785: V------>A       z_QH2OVap0 = z_QH2OVap
  1786: |       A       z_QH2OLiq0 = z_QH2OLiq
  1787: |       A       z_QH2OSol0 = z_QH2OSol
  1788: |       A       z_Temp0    = z_Temp
  1789: |           
  1790: |               ! 調節
  1791: |               ! Adjustment
  1792: |               !
  1793: |           
  1794: |               z_QH2OTot     = z_QH2OVap + z_QH2OLiq + z_QH2OSol
  1795: |               z_QH2OTotFluc = QH2OFlucRatio * z_QH2OTot
  1796: |           
  1797: |               ! 飽和比湿計算
  1798: |               ! Calculate saturation specific humidity 
  1799: |               !
  1800: |           !!$    z_QH2OVapSat = a_CalcQVapSat( z_Temp, z_Press )
  1801: |           !!$    !
  1802: |           !!$    do k = 1, kmax
  1803: |           !!$      if ( &
  1804: |           !!$        &  ( z_QH2OVapSat(k) <= ( z_QH2OTot(k) + z_QH2OTotFluc(k) ) ) &
  1805: |           !!$        &  .or. &
  1806: |           !!$        &  ( ( z_QH2OVap(k) < z_QH2OVapSat(k) ) .and. &
  1807: |           !!$        &    ( z_QH2OLiq(k) + z_QH2OLiq(k) > 0.0_DP ) ) &
  1808: |           !!$        & ) then
  1809: |           !!$        z_FlagProcess(k) = .true.
  1810: |           !!$      else
  1811: |           !!$        z_FlagProcess(k) = .false.
  1812: |           !!$      end if
  1813: |           !!$    end do
  1814: |           
  1815: V------         z_FlagProcess = .true.
  1816:             
  1817:             
  1818: +------>        do itr = 1, ItrtMax
  1819: |           
  1820: |V----->          z_QH2OVapB = z_QH2OVap
  1821: ||                z_QH2OLiqB = z_QH2OLiq
  1822: ||                z_QH2OSolB = z_QH2OSol
  1823: ||                z_TempB    = z_Temp
  1824: ||          
  1825: ||                ! 飽和比湿計算
  1826: ||                ! Calculate saturation specific humidity
  1827: ||                !
  1828: |V----- A         z_QH2OVapSat       = a_CalcQVapSat      ( z_Temp, z_Press      )
  1829: |                 z_DQH2OVapSatDTemp = a_CalcDQVapSatDTemp( z_Temp, z_QH2OVapSat )
  1830: |           
  1831: |           
  1832: |+----->          do k = 1, kmax
  1833: ||          
  1834: ||                  ! 飽和していたら, 温度と比湿の変化を計算
  1835: ||                  ! Calculate tendency of temperature and humidity 
  1836: ||                  ! if moist is saturation. 
  1837: ||                  !
  1838: ||                  if ( z_FlagProcess(k) ) then
  1839: ||          
  1840: ||                    ! Liquid water and ice fractions
  1841: ||                    call SaturateWatFraction(   &
  1842: ||                      & z_Temp(k),              & ! (in )
  1843: ||                      & WatFrac                 & ! (out)
  1844: ||                      & )
  1845: ||                    IceFrac = 1.0_DP - WatFrac
  1846: ||          
  1847: ||          
  1848: ||                    if ( z_QH2OVapSat(k) < z_QH2OTot(k) - z_QH2OTotFluc(k) ) then
  1849: ||                      CoefA =   z_QH2OTot(k) - z_QH2OVapSat(k)
  1850: ||                      CoefB = - z_DQH2OVapSatDTemp(k)
  1851: ||                    else if ( z_QH2OVapSat(k) < z_QH2OTot(k) + z_QH2OTotFluc(k) ) then
  1852: ||                      CoefA =     ( z_QH2OTot(k) + z_QH2OTotFluc(k) - z_QH2OVapSat(k) )**2&
  1853: ||                        &       / ( 4.0_DP * z_QH2OTotFluc(k) )
  1854: ||                      CoefB = -   ( z_QH2OTot(k) + z_QH2OTotFluc(k) - z_QH2OVapSat(k) )   &
  1855: ||                        &       / ( 2.0_DP * z_QH2OTotFluc(k) )                           &
  1856: ||                        &       * z_DQH2OVapSatDTemp(k)
  1857: ||                    else
  1858: ||                      CoefA = 0.0_DP
  1859: ||                      CoefB = 0.0_DP
  1860: ||                    end if
  1861: ||          
  1862: ||                    ! 温度の変化分をニュートン法で求める
  1863: ||                    ! Calculate variation of temperature
  1864: ||                    !
  1865: ||                    DelTemp =                                                         &
  1866: ||                      &   ( - LatentHeat * z_QH2OLiq(k)                               &
  1867: ||                      &     - ( LatentHeat + LatentHeatFusion ) * z_QH2OSol(k)        &
  1868: ||                      &     + ( LatentHeat + LatentHeatFusion * IceFrac ) * CoefA )   &
  1869: ||                      & / (   CpDry &
  1870: ||                      &     - ( LatentHeat + LatentHeatFusion * IceFrac ) * CoefB )
  1871: ||          
  1872: ||          
  1873: ||                    ! 温度と比湿の調節
  1874: ||                    ! Adjust temperature and specific humidity
  1875: ||                    !
  1876: ||                    z_Temp(k) = z_Temp(k) + DelTemp
  1877: ||                    QH2OCond  = CoefA + CoefB * DelTemp
  1878: ||                    z_QH2OVap(k) = z_QH2OTot(k) - QH2OCond
  1879: ||                    z_QH2OLiq(k) = WatFrac * QH2OCond
  1880: ||                    z_QH2OSol(k) = IceFrac * QH2OCond
  1881: ||          
  1882: ||                    QH2OVapSat = z_QH2OVapSat(k) + z_DQH2OVapSatDTemp(k) * DelTemp
  1883: ||          
  1884: ||                    ! It should be noted that, in general, z_QH2OVapSat(k) is not 
  1885: ||                    ! equal to QH2OVapSat.
  1886: ||                    if ( z_QH2OVapSat(k) < z_QH2OTot(k) - z_QH2OTotFluc(k) ) then
  1887: ||                      z_CloudCover(k) = 1.0_DP
  1888: ||                    else if ( z_QH2OVapSat(k) < z_QH2OTot(k) + z_QH2OTotFluc(k) ) then
  1889: ||                      z_CloudCover(k) = ( z_QH2OTot(k) + z_QH2OTotFluc(k) - QH2OVapSat ) / ( 2.0_DP * z_QH2OTotFluc(k) )
  1890: ||                      z_CloudCover(k) = max( min( z_CloudCover(k), 1.0_DP ), 0.0_DP )
  1891: ||                    else
  1892: ||                      z_CloudCover(k) = 0.0_DP
  1893: ||                    end if
  1894: ||                  else
  1895: ||                    z_CloudCover(k) = 0.0_DP
  1896: ||                  end if
  1897: ||          
  1898: |+-----           end do
  1899: |           
  1900: +------         end do
  1901:             
  1902:             
  1903:                 ! 比湿変化率, 温度変化率, 降水量の算出
  1904:                 ! Calculate specific humidity tendency, temperature tendency, 
  1905:                 ! precipitation
  1906:                 !
  1907: V------>        z_DTempDtLsc    = ( z_Temp    - z_Temp0    ) / ( 2.0_DP * DelTime )
  1908: |               z_DQH2OVapDtLsc = ( z_QH2OVap - z_QH2OVap0 ) / ( 2.0_DP * DelTime )
  1909: |       A       z_DQH2OLiqDt    = ( z_QH2OLiq - z_QH2OLiq0 ) / ( 2.0_DP * DelTime )
  1910: V------ A       z_DQH2OSolDt    = ( z_QH2OSol - z_QH2OSol0 ) / ( 2.0_DP * DelTime )
  1911:             
  1912:             
  1913:                 call LScaleCond1DConsChk(                        &
  1914:                   & z_Temp0, z_QH2OVap0, z_QH2OLiq0, z_QH2OSol0, &
  1915:                   & z_Temp , z_QH2OVap , z_QH2OLiq , z_QH2OSol   &
  1916:                   & )
  1917:             
  1918:             
  1919:             !!$    ! 計算時間計測一時停止
  1920:             !!$    ! Pause measurement of computation time
  1921:             !!$    !
  1922:             !!$    call TimesetClockStop( module_name )
  1923:             
  1924:               end subroutine LScaleCondLL911D
  1925:             
  1926:               !--------------------------------------------------------------------------------------
  1927:             
  1928:               subroutine LScaleCond1DConsChk(                  &
  1929:                 & z_TempB, z_QH2OVapB, z_QH2OLiqB, z_QH2OSolB, &
  1930:                 & z_Temp , z_QH2OVap , z_QH2OLiq , z_QH2OSol   &
  1931:                 & )
  1932:             
  1933:                 ! 物理定数設定
  1934:                 ! Physical constants settings
  1935:                 !
  1936:                 use constants, only: &
  1937:                   & Grav, & 
  1938:                                           ! $ g $ [m s-2]. 
  1939:                                           ! 重力加速度. 
  1940:                                           ! Gravitational acceleration
  1941:                   & CpDry, &
  1942:                                           ! $ C_p $ [J kg-1 K-1]. 
  1943:                                           ! 乾燥大気の定圧比熱. 
  1944:                                           ! Specific heat of air at constant pressure
  1945:                   & LatentHeat, &
  1946:                                           ! $ L $ [J kg-1] . 
  1947:                                           ! 凝結の潜熱. 
  1948:                                           ! Latent heat of condensation
  1949:                   & LatentHeatFusion
  1950:                                           ! $ L $ [J kg-1] .
  1951:                                           ! 融解の潜熱.
  1952:                                           ! Latent heat of fusion
  1953:             
  1954:                 real(DP), intent(in) :: z_TempB   (1:kmax)
  1955:                 real(DP), intent(in) :: z_QH2OVapB(1:kmax)
  1956:                 real(DP), intent(in) :: z_QH2OLiqB(1:kmax)
  1957:                 real(DP), intent(in) :: z_QH2OSolB(1:kmax)
  1958:                 real(DP), intent(in) :: z_Temp    (1:kmax)
  1959:                 real(DP), intent(in) :: z_QH2OVap (1:kmax)
  1960:                 real(DP), intent(in) :: z_QH2OLiq (1:kmax)
  1961:                 real(DP), intent(in) :: z_QH2OSol (1:kmax)
  1962:             
  1963:                 ! Local variables
  1964:                 !
  1965:                 real(DP) :: ValB
  1966:                 real(DP) :: Val
  1967:                 real(DP) :: Ratio
  1968:                 integer  :: k
  1969:             
  1970:             
  1971: +------>        do k = kmax, 1, -1
  1972: |                 Val =   CpDry * z_TempB(k)               &
  1973: |                   &   + LatentHeat * z_QH2OVapB(k)       &
  1974: |                   &   - LatentHeatFusion * z_QH2OSolB(k)
  1975: |                 ValB = Val
  1976: |           
  1977: |                 Val =   CpDry * z_Temp(k)               &
  1978: |                   &   + LatentHeat * z_QH2OVap(k)       &
  1979: |                   &   - LatentHeatFusion * z_QH2OSol(k)
  1980: |           
  1981: |                 Ratio = ( Val - ValB ) / ( Val + 1.0d-100 )
  1982: |                 if ( abs( Ratio ) > 1.0d-10 ) then
  1983: |                   call MessageNotify( 'M', module_name, 'Simplified condensate static energy is not conserved, %f.', d = (/ Ratio /) )
  1984: |                 end if
  1985: +------         end do
  1986:             
  1987:             
  1988:             
  1989: +------>        do k = kmax, 1, -1
  1990: |                 Val = z_QH2OVapB(k) + z_QH2OLiqB(k) + z_QH2OSolB(k)
  1991: |                 ValB = Val
  1992: |           
  1993: |                 Val = z_QH2OVap (k) + z_QH2OLiq (k) + z_QH2OSol (k)
  1994: |           
  1995: |                 Ratio = ( Val - ValB ) / ( Val + 1.0d-100 )
  1996: |                 if ( abs( Ratio ) > 1.0d-10 ) then
  1997: |                   call MessageNotify( 'M', module_name, 'H2O mass is not conserved, %f.', d = (/ Ratio /) )
  1998: |                 end if
  1999: +------         end do
  2000:             
  2001:             
  2002:               end subroutine LScaleCond1DConsChk
  2003:             
  2004:               !--------------------------------------------------------------------------------------
  2005:             
  2006:               subroutine LScaleCond1GridConsChk(       &
  2007:                 & TempB, QH2OVapB, QH2OLiqB, QH2OSolB, &
  2008:                 & Temp , QH2OVap , QH2OLiq , QH2OSol   &
  2009:                 & )
  2010:             
  2011:                 ! 物理定数設定
  2012:                 ! Physical constants settings
  2013:                 !
  2014:                 use constants, only: &
  2015:                   & Grav, & 
  2016:                                           ! $ g $ [m s-2]. 
  2017:                                           ! 重力加速度. 
  2018:                                           ! Gravitational acceleration
  2019:                   & CpDry, &
  2020:                                           ! $ C_p $ [J kg-1 K-1]. 
  2021:                                           ! 乾燥大気の定圧比熱. 
  2022:                                           ! Specific heat of air at constant pressure
  2023:                   & LatentHeat, &
  2024:                                           ! $ L $ [J kg-1] . 
  2025:                                           ! 凝結の潜熱. 
  2026:                                           ! Latent heat of condensation
  2027:                   & LatentHeatFusion
  2028:                                           ! $ L $ [J kg-1] .
  2029:                                           ! 融解の潜熱.
  2030:                                           ! Latent heat of fusion
  2031:             
  2032:                 real(DP), intent(in) :: TempB
  2033:                 real(DP), intent(in) :: QH2OVapB
  2034:                 real(DP), intent(in) :: QH2OLiqB
  2035:                 real(DP), intent(in) :: QH2OSolB
  2036:                 real(DP), intent(in) :: Temp
  2037:                 real(DP), intent(in) :: QH2OVap
  2038:                 real(DP), intent(in) :: QH2OLiq
  2039:                 real(DP), intent(in) :: QH2OSol
  2040:             
  2041:                 ! Local variables
  2042:                 !
  2043:                 real(DP) :: ValB
  2044:                 real(DP) :: Val
  2045:                 real(DP) :: Ratio
  2046:                 integer  :: k
  2047:             
  2048:             
  2049:                 Val =   CpDry * TempB               &
  2050:                   &   + LatentHeat * QH2OVapB       &
  2051:                   &   - LatentHeatFusion * QH2OSolB
  2052:                 ValB = Val
  2053:             
  2054:                 Val =   CpDry * Temp               &
  2055:                   &   + LatentHeat * QH2OVap       &
  2056:                   &   - LatentHeatFusion * QH2OSol
  2057:             
  2058:                 Ratio = ( Val - ValB ) / ( Val + 1.0d-100 )
  2059:                 if ( abs( Ratio ) > 1.0d-10 ) then
  2060:                   call MessageNotify( 'M', module_name, 'Simplified condensate static energy is not conserved, %f.', d = (/ Ratio /) )
  2061:                 end if
  2062:             
  2063:             
  2064:                 Val = QH2OVapB + QH2OLiqB + QH2OSolB
  2065:                 ValB = Val
  2066:             
  2067:                 Val = QH2OVap  + QH2OLiq  + QH2OSol
  2068:             
  2069:                 Ratio = ( Val - ValB ) / ( Val + 1.0d-100 )
  2070:                 if ( abs( Ratio ) > 1.0d-10 ) then
  2071:                   call MessageNotify( 'M', module_name, 'H2O mass is not conserved, %f.', d = (/ Ratio /) )
  2072:                 end if
  2073:             
  2074:             
  2075:               end subroutine LScaleCond1GridConsChk
  2076:             
  2077:               !--------------------------------------------------------------------------------------
  2078:             
  2079:               subroutine LScaleCondInit( &
  2080:                 & FlagSnow &
  2081:                 & )
  2082:                 !
  2083:                 ! lscond モジュールの初期化を行います. 
  2084:                 ! NAMELIST#lscond_nml の読み込みはこの手続きで行われます. 
  2085:                 !
  2086:                 ! "lscond" module is initialized. 
  2087:                 ! "NAMELIST#lscond_nml" is loaded in this procedure. 
  2088:                 !
  2089:             
  2090:                 ! モジュール引用 ; USE statements
  2091:                 !
  2092:             
  2093:                 ! NAMELIST ファイル入力に関するユーティリティ
  2094:                 ! Utilities for NAMELIST file input
  2095:                 !
  2096:                 use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid
  2097:             
  2098:                 ! ファイル入出力補助
  2099:                 ! File I/O support
  2100:                 !
  2101:                 use dc_iounit, only: FileOpen
  2102:             
  2103:                 ! 種別型パラメタ
  2104:                 ! Kind type parameter
  2105:                 !
  2106:                 use dc_types, only: STDOUT ! 標準出力の装置番号. Unit number of standard output
  2107:             
  2108:                 ! 文字列操作
  2109:                 ! Character handling
  2110:                 !
  2111:                 use dc_string, only: StoA
  2112:             
  2113:                 ! ヒストリデータ出力
  2114:                 ! History data output
  2115:                 !
  2116:                 use gtool_historyauto, only: HistoryAutoAddVariable
  2117:             
  2118:                 ! 飽和比湿の算出
  2119:                 ! Evaluate saturation specific humidity
  2120:                 !
  2121:                 use saturate, only: SaturateInit
  2122:             
  2123:                 ! 雲関系ルーチン
  2124:                 ! Cloud-related routines
  2125:                 !
  2126:                 use cloud_utils, only : CloudUtilsInit
  2127:             
  2128:                 ! 宣言文 ; Declaration statements
  2129:                 !
  2130:                 implicit none
  2131:             
  2132:                 logical, intent(in) :: FlagSnow
  2133:             
  2134:             
  2135:                 integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号. 
  2136:                                           ! Unit number for NAMELIST file open
  2137:                 integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT. 
  2138:                                           ! IOSTAT of NAMELIST read
  2139:             
  2140:                 ! NAMELIST 変数群
  2141:                 ! NAMELIST group name
  2142:                 !
  2143:                 namelist /lscond_nml/ &
  2144:                   & QH2OFlucRatio, CrtlRH, ItrtMax, FlagSatAdj
  2145:                       !
  2146:                       ! デフォルト値については初期化手続 "lscond#LSCondInit" 
  2147:                       ! のソースコードを参照のこと. 
  2148:                       !
  2149:                       ! Refer to source codes in the initialization procedure
  2150:                       ! "lscond#LSCondInit" for the default values. 
  2151:                       !
  2152:             
  2153:                 ! 実行文 ; Executable statement
  2154:                 !
  2155:             
  2156:                 if ( lscond_inited ) return
  2157:             
  2158:             
  2159:                 ! デフォルト値の設定
  2160:                 ! Default values settings
  2161:                 !
  2162:                 QH2OFlucRatio   = 0.2_DP
  2163:                 CrtlRH          = 1.0_DP
  2164:                 ItrtMax         = 3
  2165:                 FlagSatAdj      = .false.
  2166:             
  2167:                 ! NAMELIST の読み込み
  2168:                 ! NAMELIST is input
  2169:                 !
  2170:                 if ( trim(namelist_filename) /= '' ) then
  2171:                   call FileOpen( unit_nml, &          ! (out)
  2172:                     & namelist_filename, mode = 'r' ) ! (in)
  2173:             
  2174:                   rewind( unit_nml )
  2175:                   read( unit_nml, &         ! (in)
  2176:                     & nml = lscond_nml, &   ! (out)
  2177:                     & iostat = iostat_nml ) ! (out)
  2178:                   close( unit_nml )
  2179:             
  2180:                   call NmlutilMsg( iostat_nml, module_name ) ! (in)
  2181:                   if ( iostat_nml == 0 ) write( STDOUT, nml = lscond_nml )
  2182:                 end if
  2183:             
  2184:                 ! Initialization of modules used in this module
  2185:                 !
  2186:             
  2187:                 ! Initialization of modules used in this module
  2188:                 !
  2189:                 call SaturateInit
  2190:             
  2191:                 ! 雲関系ルーチン
  2192:                 ! Cloud-related routines
  2193:                 !
  2194:                 call CloudUtilsInit( &
  2195:                   & FlagSnow         &
  2196:                   & )
  2197:             
  2198:             
  2199:                 ! ヒストリデータ出力のためのへの変数登録
  2200:                 ! Register of variables for history data output
  2201:                 !
  2202:                 call HistoryAutoAddVariable( 'DTempDtLsc', &
  2203:                   & (/ 'lon ', 'lat ', 'sig ', 'time' /), &
  2204:                   & 'large-scale condensation heating', 'K s-1' )
  2205:                 call HistoryAutoAddVariable( 'DQH2OVapDtLsc', &
  2206:                   & (/ 'lon ', 'lat ', 'sig ', 'time' /), &
  2207:                   & 'large-scale condensation moistening', 'kg kg-1 s-1' )
  2208:                 call HistoryAutoAddVariable( 'DQH2OLiqDtLsc', &
  2209:                   & (/ 'lon ', 'lat ', 'sig ', 'time' /), &
  2210:                   & 'large-scale H2O liquid production rate', 'kg kg-1 s-1' )
  2211:                 call HistoryAutoAddVariable( 'DQH2OSolDtLsc', &
  2212:                   & (/ 'lon ', 'lat ', 'sig ', 'time' /), &
  2213:                   & 'large-scale H2O solid production rate', 'kg kg-1 s-1' )
  2214:             
  2215:             
  2216:                 ! 印字 ; Print
  2217:                 !
  2218:                 call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
  2219:                 call MessageNotify( 'M', module_name, '  QH2OFlucRatio   = %f', d = (/ QH2OFlucRatio /) )
  2220:                 call MessageNotify( 'M', module_name, '  CrtlRH          = %f', d = (/ CrtlRH /) )
  2221:                 call MessageNotify( 'M', module_name, '  ItrtMax         = %d', i = (/ ItrtMax /) )
  2222:                 call MessageNotify( 'M', module_name, '  FlagSatAdj      = %b', l = (/ FlagSatAdj /) )
  2223:                 call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
  2224:             
  2225:                 lscond_inited = .true.
  2226:             
  2227:               end subroutine LScaleCondInit
  2228:             
  2229:               !--------------------------------------------------------------------------------------
  2230:             
  2231:             end module lscond
