Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:46 2016
FILE NAME: planck_func.f90
PROGRAM NAME: planck_func
DIAGNOSTIC LIST

  LINE  LEVEL( NO.): DIAGNOSTIC MESSAGE

   131  opt  (1593): Loop nest collapsed into one loop.
   131  vec  (   4): Vectorized array expression.
   131  vec  (  29): ADB is used for array.: aaa_temp
   209  opt  (1593): Loop nest collapsed into one loop.
   209  vec  (   4): Vectorized array expression.
   209  vec  (  29): ADB is used for array.: aaa_pfinted
   211  vec  (   3): Unvectorized loop.
   212  opt  (1017): Subroutine call prevents optimization.
   212  opt  (1592): Outer loop unrolled inside inner loop.
   212  vec  (   4): Vectorized array expression.
   212  vec  (  29): ADB is used for array.: aaa_pfinted
   212  vec  (   4): Vectorized array expression.
   212  vec  (  29): ADB is used for array.: aaa_pfinted
   250  opt  (1593): Loop nest collapsed into one loop.
   250  vec  (   4): Vectorized array expression.
   250  vec  (  29): ADB is used for array.: temp3d
   250  vec  (  29): ADB is used for array.: temp
   257  opt  (1592): Outer loop unrolled inside inner loop.
   257  vec  (   4): Vectorized array expression.
   257  vec  (  29): ADB is used for array.: pfinted
   257  vec  (  29): ADB is used for array.: pfinted3d
   257  vec  (   4): Vectorized array expression.
   257  vec  (  29): ADB is used for array.: pfinted
   257  vec  (  29): ADB is used for array.: pfinted3d
   327  opt  (  11): Fused array assignments. :line 327 - 332
   327  opt  (1593): Loop nest collapsed into one loop.
   327  vec  (   4): Vectorized array expression.
   327  vec  (  29): ADB is used for array.: aaa_temp
   379  opt  (1593): Loop nest collapsed into one loop.
   379  vec  (   4): Vectorized array expression.
   379  vec  (  29): ADB is used for array.: aaa_dpfdtinted
   381  vec  (   3): Unvectorized loop.
   382  opt  (1017): Subroutine call prevents optimization.
   382  opt  (1592): Outer loop unrolled inside inner loop.
   382  vec  (   4): Vectorized array expression.
   382  vec  (  29): ADB is used for array.: aaa_dpfdtinted
   382  vec  (   4): Vectorized array expression.
   382  vec  (  29): ADB is used for array.: aaa_dpfdtinted
   423  opt  (1593): Loop nest collapsed into one loop.
   423  vec  (   4): Vectorized array expression.
   423  vec  (  29): ADB is used for array.: aaa_temp
   423  vec  (  29): ADB is used for array.: aa_temp
   431  opt  (1592): Outer loop unrolled inside inner loop.
   431  vec  (   4): Vectorized array expression.
   431  vec  (  29): ADB is used for array.: aa_dpfdtinted
   431  vec  (  29): ADB is used for array.: aaa_dpfdtinted
   431  vec  (   4): Vectorized array expression.
   431  vec  (  29): ADB is used for array.: aa_dpfdtinted
   431  vec  (  29): ADB is used for array.: aaa_dpfdtinted
   506  vec  (   1): Vectorized loop.
   506  vec  (  29): ADB is used for array.: a_tabletemp
   511  opt  (  11): Fused array assignments. :line 511 - 512
   511  vec  (   4): Vectorized array expression.
   511  vec  (  29): ADB is used for array.: a_tableidpfdt
   511  vec  (  29): ADB is used for array.: a_tableipf
   521  vec  (   3): Unvectorized loop.
   522  opt  (1025): Reference to this function inhibits optimization.
   522  vec  (  10): Vectorization obstructive procedure reference.:pf
   523  vec  (  10): Vectorization obstructive procedure reference.:dpfdt
   543  vec  (   1): Vectorized loop.
   543  vec  (  29): ADB is used for array.: aa_temptmp
   576  vec  (   3): Unvectorized loop.
   579  opt  (1017): Subroutine call prevents optimization.
   579  vec  (  10): Vectorization obstructive procedure reference.:messagenotifyc
   585  vec  (  10): Vectorization obstructive procedure reference.:messagenotifyc
   630  opt  (1593): Loop nest collapsed into one loop.
   630  vec  (   4): Vectorized array expression.
   630  vec  (  29): ADB is used for array.: xyz_temp
   630  vec  (  29): ADB is used for array.: xy_temp
   639  opt  (1592): Outer loop unrolled inside inner loop.
   639  vec  (   4): Vectorized array expression.
   639  vec  (  29): ADB is used for array.: xy_integpf
   639  vec  (  29): ADB is used for array.: xyz_integpf
   639  vec  (   4): Vectorized array expression.
   639  vec  (  29): ADB is used for array.: xy_integpf
   639  vec  (  29): ADB is used for array.: xyz_integpf
   697  vec  (   3): Unvectorized loop.
   701  opt  (1017): Subroutine call prevents optimization.
   701  vec  (  10): Vectorization obstructive procedure reference.:messagenotifyc
   736  opt  (1593): Loop nest collapsed into one loop.
   736  vec  (   1): Vectorized loop.
   736  vec  (  29): ADB is used for array.: xyz_integpf
   736  vec  (  29): ADB is used for array.: a_tabletemp
   736  vec  (  29): ADB is used for array.: xyz_temp
   736  vec  (  29): ADB is used for array.: a_tableipf
   767  opt  (1593): Loop nest collapsed into one loop.
   767  vec  (   1): Vectorized loop.
   767  vec  (  29): ADB is used for array.: xyz_integpf
   767  vec  (  29): ADB is used for array.: a_tabletemp
   767  vec  (  29): ADB is used for array.: xyz_temp
   767  vec  (  29): ADB is used for array.: a_tableipf
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:46 2016
FILE NAME: planck_func.f90
PROGRAM NAME: planck_func
TRANSFORMATION LIST

  LINE                   FORTRAN STATEMENT

     1  != プランク関数の計算
     2  !
     3  != Calculate Planck function
     4  !
     5  ! Authors::   Yoshiyuki O. Takahashi
     6  ! Version::   $Id: planck_func.f90,v 1.6 2014/05/07 09:39:21 murashin Exp $
     7  ! Tag Name::  $Name:  $
     8  ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9  ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10  !
    11  
    12  module planck_func
    13    !
    14    != プランク関数の計算
    15    !
    16    != Calculate Planck function
    17    !
    18    ! <b>Note that Japanese and English are described in parallel.</b>
    19    !
    20    !
    21    !
    22    !
    23    !
    24    !== Procedures List
    25    !
    26  !!$  ! RadiationFluxDennouAGCM :: 放射フラックスの計算
    27  !!$  ! RadiationDTempDt        :: 放射フラックスによる温度変化の計算
    28  !!$  ! RadiationFluxOutput     :: 放射フラックスの出力
    29  !!$  ! RadiationFinalize       :: 終了処理 (モジュール内部の変数の割り付け解除)
    30  !!$  ! ------------            :: ------------
    31  !!$  ! RadiationFluxDennouAGCM :: Calculate radiation flux
    32  !!$  ! RadiationDTempDt        :: Calculate temperature tendency with radiation flux
    33  !!$  ! RadiationFluxOutput     :: Output radiation fluxes
    34  !!$  ! RadiationFinalize       :: Termination (deallocate variables in this module)
    35    !
    36    !== NAMELIST
    37    !
    38  !!$  ! NAMELIST#radiation_DennouAGCM_nml
    39    !
    40  
    41    ! モジュール引用 ; USE statements
    42    !
    43  
    44    ! 種別型パラメタ
    45    ! Kind type parameter
    46    !
    47    use dc_types, only: DP, &      ! 倍精度実数型. Double precision.
    48      &                 STRING, &  ! 文字列.       Strings.
    49      &                 TOKEN      ! キーワード.   Keywords.
    50  
    51  
    52    ! 宣言文 ; Declaration statements
    53    !
    54    implicit none
    55    private
    56  
    57    ! 公開手続き
    58    ! Public procedure
    59    !
    60    public :: aaa_PF
    61    public :: PF
    62    public :: DPFDT
    63    public :: Integ_PF_GQ_Array3D
    64    public :: Integ_PF_GQ_Array2D
    65    public :: Integ_DPFDT_GQ_Array2D
    66    public :: Integ_DPFDT_GQ_Array3D
    67  
    68    ! 公開変数
    69    ! Public variables
    70    !
    71  !!$  logical, save :: planck_func_inited = .false.
    72                                ! 初期設定フラグ.
    73                                ! Initialization flag
    74  
    75  
    76    ! 非公開変数
    77    ! Private variables
    78    !
    79    real(DP), parameter ::                &
    80      & SOL    = 2.99792458e8_DP        , &
    81      & Planc  = 6.6260755e-34_DP       , &
    82      & Boltz  = 1.380658e-23_DP
    83  
    84    character(*), parameter:: module_name = 'planck_func'
    85                                ! モジュールの名称.
    86                                ! Module name
    87    character(*), parameter:: version = &
    88      & '$Name:  $' // &
    89      & '$Id: planck_func.f90,v 1.6 2014/05/07 09:39:21 murashin Exp $'
    90                                ! モジュールのバージョン
    91                                ! Module version
    92  
    93  contains
    94  
    95    !--------------------------------------------------------------------------------------
    96  
    97    function aaa_PF( &
    98      & is, ie, js, je, ks, ke, &
    99      & WN, aaa_Temp &
   100      & ) &
   101      result( aaa_Res )
   102      !
   103      ! 温度, 比湿, 気圧から, 放射フラックスを計算します.
   104      !
   105      ! Calculate radiation flux from temperature, specific humidity, and
   106      ! air pressure.
   107      !
   108  
   109      ! モジュール引用 ; USE statements
   110      !
   111  
   112      ! 宣言文 ; Declaration statements
   113      !
   114      integer , intent(in) :: is
   115      integer , intent(in) :: ie
   116      integer , intent(in) :: js
   117      integer , intent(in) :: je
   118      integer , intent(in) :: ks
   119      integer , intent(in) :: ke
   120      real(DP), intent(in) :: WN
   121      real(DP), intent(in) :: aaa_Temp(is:ie, js:je, ks:ke)
   122      real(DP)             :: aaa_Res (is:ie, js:je, ks:ke)
   123  
   124      ! 作業変数
   125      ! Work variables
   126      !
   127  
   128      ! 実行文 ; Executable statement
   129      !
   130  
   131      aaa_Res = 2.0_DP * Planc * SOL * SOL * WN * WN * WN &
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t68 = 1, (ke + 1 - ks)*(je + 1 - js)*(ie + 1 - is)             
     .           aaa_res(aaa_res.DESCRIPT.RETVAL.DSC.L1+t68-1,                  
     .       1      aaa_res.DESCRIPT.RETVAL.DSC.L2,                             
     .       2      aaa_res.DESCRIPT.RETVAL.DSC.L3) = 1.19104393406522e-016*wn* 
     .       3      wn*wn/(dexp(1.98644746103857e-025*(wn +                     
     .       4      1.00000000000000e-010)/(1.38065800000000e-023*aaa_temp(is+  
     .       5      t68-1,js,ks)))-1.00000000000000e+000)                       
     .        enddo                                                             
   132        / ( exp( Planc * SOL * ( WN+1.0e-10_DP ) / ( Boltz * aaa_Temp ) ) - 1.0_DP )
   133  
   134  
   135    end function aaa_PF
   136  
   137    !--------------------------------------------------------------------------------------
   138  
   139    function PF( WN, Temp ) result( Res )
   140      !
   141      ! 温度, 比湿, 気圧から, 放射フラックスを計算します.
   142      !
   143      ! Calculate radiation flux from temperature, specific humidity, and
   144      ! air pressure.
   145      !
   146  
   147      ! モジュール引用 ; USE statements
   148      !
   149  
   150      ! 宣言文 ; Declaration statements
   151      !
   152      real(DP), intent(in) :: WN
   153      real(DP), intent(in) :: Temp
   154      real(DP)             :: Res
   155  
   156      ! 作業変数
   157      ! Work variables
   158      !
   159      real(DP) :: aaa_Temp(1,1,1)
   160      real(DP) :: aaa_Res (1,1,1)
   161  
   162      ! 実行文 ; Executable statement
   163      !
   164  
   165      aaa_Temp(1,1,1) = Temp
   166      aaa_Res = &
   167        & aaa_PF( &
   168        &         1, 1, 1, 1, 1, 1, &
   169        &         WN, aaa_Temp &
   170        &       )
   171  
   172      Res = aaa_Res(1,1,1)
   173  
   174  
   175    end function PF
   176  
   177    !--------------------------------------------------------------------------------------
   178  
   179    subroutine Integ_PF_GQ_Array3D( &
   180      & wn1, wn2, num, &
   181      & is, ie, js, je, ks, ke, &
   182      & aaa_temp, &
   183      & aaa_pfinted &
   184      & )
   185  
   186      ! ガウス重み, 分点の計算
   187      ! Calculate Gauss node and Gaussian weight
   188      !
   189      use gauss_quad, only : GauLeg
   190  
   191      real(DP), intent(in ) :: wn1,wn2
   192      integer , intent(in ) :: num
   193      integer , intent(in ) :: is, ie
   194      integer , intent(in ) :: js, je
   195      integer , intent(in ) :: ks, ke
   196      real(DP), intent(in ) :: aaa_temp   (is:ie, js:je, ks:ke)
   197      real(DP), intent(out) :: aaa_pfinted(is:ie, js:je, ks:ke)
   198  
   199  
   200      !
   201      ! local variables
   202      !
   203      real(DP):: x( num ), w( num )
   204      integer :: l
   205  
   206  
   207      call GauLeg( wn1, wn2, num, x, w )
   208  
   209      aaa_pfinted(:,:,:) = 0.0_DP
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t96 = 1, (ke + 1 - ks)*(je + 1 - js)*(ie + 1 - is)             
     .           aaa_pfinted(is+t96-1,js,ks) = 0.0000000000000000e+000          
     .        enddo                                                             
   210  
   211      do l = 1, num
   212        aaa_pfinted(:,:,:) = aaa_pfinted(:,:,:)       &
     .        if (t37 + 1 - t38 .gt. 0) then                                    
     .           j1 = and(t37 + 1 - t38,3)                                      
     .  !cdir    nodep                                                          
     .           do t107 = 1, j1                                                
     .  !cdir       nodep                                                       
     .              do t109 = 1, t35 + 1 - t36                                  
     .                 aaa_pfinted(t36+t109-1,t107-1+t38,t105+t40) = aaa_pfinted
     .       1            (t36+t109-1,t107-1+t38,t105+t40) + %000130(           
     .       2            %000130.DSC.L1+t109-1,t107-1+%000130.DSC.L2,t105+     
     .       3            %000130.DSC.L3)*w(l)                                  
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t107 = j1 + 1, t37 + 1 - t38, 4                             
     .  !cdir       nodep                                                       
     .              do t109 = 1, t35 + 1 - t36                                  
     .                 d1 = w(l)                                                
     .                 aaa_pfinted(t36+t109-1,t107-1+t38,t105+t40) = aaa_pfinted
     .       1            (t36+t109-1,t107-1+t38,t105+t40) + %000130(           
     .       2            %000130.DSC.L1+t109-1,t107-1+%000130.DSC.L2,t105+     
     .       3            %000130.DSC.L3)*d1                                    
     .                 aaa_pfinted(t36+t109-1,t107+t38,t105+t40) = aaa_pfinted( 
     .       1            t36+t109-1,t107+t38,t105+t40) + %000130(%000130.DSC.L1
     .       2            +t109-1,t107+%000130.DSC.L2,t105+%000130.DSC.L3)*d1   
     .                 aaa_pfinted(t36+t109-1,t107+1+t38,t105+t40) = aaa_pfinted
     .       1            (t36+t109-1,t107+1+t38,t105+t40) + %000130(           
     .       2            %000130.DSC.L1+t109-1,t107+1+%000130.DSC.L2,t105+     
     .       3            %000130.DSC.L3)*d1                                    
     .                 aaa_pfinted(t36+t109-1,t107+2+t38,t105+t40) = aaa_pfinted
     .       1            (t36+t109-1,t107+2+t38,t105+t40) + %000130(           
     .       2            %000130.DSC.L1+t109-1,t107+2+%000130.DSC.L2,t105+     
     .       3            %000130.DSC.L3)*d1                                    
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
   213          & + aaa_PF(                         &
   214          &           is, ie, js, je, ks, ke, &
   215          &           x(l), aaa_Temp          &
   216          &         )                         &
   217          & * w( l )
   218      end do
   219  
   220  
   221    end subroutine Integ_PF_GQ_Array3D
   222  
   223    !--------------------------------------------------------------------------------------
   224  
   225    subroutine Integ_PF_GQ_Array2D( &
   226      & wn1, wn2, num, &
   227      & is, ie, js, je, &
   228      & temp, &
   229      & pfinted &
   230      & )
   231  
   232  
   233      real(DP), intent(in ) :: wn1,wn2
   234      integer , intent(in ) :: num
   235      integer , intent(in ) :: is
   236      integer , intent(in ) :: ie
   237      integer , intent(in ) :: js
   238      integer , intent(in ) :: je
   239      real(DP), intent(in ) :: temp   (is:ie, js:je)
   240      real(DP), intent(out) :: pfinted(is:ie, js:je)
   241  
   242  
   243      !
   244      ! local variables
   245      !
   246      real(DP) :: temp3d   (is:ie, js:je, 1:1)
   247      real(DP) :: pfinted3d(is:ie, js:je, 1:1)
   248  
   249  
   250      temp3d(:,:,1) = temp(:,:)
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t72 = 1, (temp3d.DSC.U2 + 1 - temp3d.DSC.L2)*(temp3d.DSC.U1 + 1
     .       1    - temp3d.DSC.L1)                                              
     .           temp3d(temp3d.DSC.L1+t72-1,temp3d.DSC.L2,1) = temp(is+t72-1,js)
     .        enddo                                                             
   251      call Integ_PF_GQ_Array3D( &
   252        & wn1, wn2, num, &
   253        & is, ie, js, je, 1, 1, &
   254        & temp3d, &
   255        & pfinted3d &
   256        & )
   257      pfinted(:,:) = pfinted3d(:,:,1)
     .        if (t32 + 1 - t33 .gt. 0) then                                    
     .           j1 = and(t32 + 1 - t33,3)                                      
     .  !cdir    nodep                                                          
     .           do t80 = 1, j1                                                 
     .  !cdir       nodep                                                       
     .              do t82 = 1, t30 + 1 - t31                                   
     .                 pfinted(t31+t82-1,t80-1+t33) = pfinted3d(pfinted3d.DSC.L1
     .       1            +t82-1,t80-1+pfinted3d.DSC.L2,1)                      
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t80 = j1 + 1, t32 + 1 - t33, 4                              
     .  !cdir       nodep                                                       
     .              do t82 = 1, t30 + 1 - t31                                   
     .                 pfinted(t31+t82-1,t80-1+t33) = pfinted3d(pfinted3d.DSC.L1
     .       1            +t82-1,t80-1+pfinted3d.DSC.L2,1)                      
     .                 pfinted(t31+t82-1,t80+t33) = pfinted3d(pfinted3d.DSC.L1+ 
     .       1            t82-1,t80+pfinted3d.DSC.L2,1)                         
     .                 pfinted(t31+t82-1,t80+1+t33) = pfinted3d(pfinted3d.DSC.L1
     .       1            +t82-1,t80+1+pfinted3d.DSC.L2,1)                      
     .                 pfinted(t31+t82-1,t80+2+t33) = pfinted3d(pfinted3d.DSC.L1
     .       1            +t82-1,t80+2+pfinted3d.DSC.L2,1)                      
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
   258  
   259  
   260    end subroutine Integ_PF_GQ_Array2D
   261  
   262    !--------------------------------------------------------------------------------------
   263  
   264    function DPFDT( &
   265      & WN,    & ! (in )
   266      & Temp   & ! (in )
   267      & )      &
   268      & result( Res )
   269  
   270      ! USE statements
   271      !
   272  
   273      ! 宣言文 ; Declaration statements
   274      !
   275      real(DP), intent(in ) :: WN
   276      real(DP), intent(in ) :: Temp
   277      real(DP)              :: Res
   278  
   279  
   280      ! 作業変数
   281      ! Work variables
   282      !
   283      real(DP) :: aaa_Temp(1,1,1)
   284      real(DP) :: aaa_Res (1,1,1)
   285  
   286  
   287      aaa_Temp(1,1,1) = Temp
   288  
   289      aaa_Res = aaa_DPFDT(                  &
   290        &                 1, 1, 1, 1, 1, 1, & ! (in )
   291        &                 WN,               & ! (in )
   292        &                 aaa_Temp          & ! (in )
   293        & )
   294  
   295      Res = aaa_Res(1,1,1)
   296  
   297  
   298    end function DPFDT
   299  
   300    !--------------------------------------------------------------------------------------
   301  
   302    function aaa_DPFDT( &
   303      & is, ie, js, je, ks, ke, & ! (in )
   304      & WN,                     & ! (in )
   305      & aaa_Temp                & ! (in )
   306      & )                       &
   307      & result( aaa_Res )
   308  
   309      ! USE statements
   310      !
   311  
   312      integer , intent(in ) :: is
   313      integer , intent(in ) :: ie
   314      integer , intent(in ) :: js
   315      integer , intent(in ) :: je
   316      integer , intent(in ) :: ks
   317      integer , intent(in ) :: ke
   318      real(DP), intent(in ) :: WN
   319      real(DP), intent(in ) :: aaa_Temp(is:ie, js:je, ks:ke)
   320      real(DP)              :: aaa_Res (is:ie, js:je, ks:ke)
   321  
   322  
   323      real(DP) :: aaa_ExpTerm(is:ie, js:je, ks:ke)
   324      real(DP) :: aaa_PF     (is:ie, js:je, ks:ke)
   325  
   326  
   327      aaa_ExpTerm = exp( Planc * SOL * ( WN + 1.0e-10_DP ) / ( Boltz * aaa_Temp ) )
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t118 = 1, (ke + 1 - ks)*(je + 1 - js)*(ie + 1 - is)            
     .           aaa_expterm1 = dexp(1.98644746103857e-025*(wn +                
     .       1      1.00000000000000e-010)/(1.38065800000000e-023*aaa_temp(is+  
     .       2      t118-1,js,ks)))                                             
     .           aaa_pf1 = (wn*wn)*1.19104393406522e-016*wn/(aaa_expterm1 -     
     .       1      1.00000000000000e+000)                                      
     .           aaa_res(aaa_res.DESCRIPT.RETVAL.DSC.L1+t118-1,                 
     .       1      aaa_res.DESCRIPT.RETVAL.DSC.L2,                             
     .       2      aaa_res.DESCRIPT.RETVAL.DSC.L3) = 1.00000000000000e+000/((wn
     .       3      *wn)*5.99584916000000e+008*1.38065800000000e-023)*(aaa_pf1/ 
     .       4      aaa_temp(is+t118-1,js,ks))**2*aaa_expterm1                  
     .        enddo                                                             
   328  
   329      aaa_PF = 2.0_DP * Planc * SOL * SOL * WN * WN * WN &
   330        / ( aaa_ExpTerm - 1.0_DP )
   331  
   332      aaa_Res = &
   333        & 1.0_DP / ( 2.0_DP * SOL * WN * WN * Boltz ) &
   334        & * ( aaa_PF / aaa_Temp )**2 &
   335        & * aaa_ExpTerm
   336  
   337  
   338    end function aaa_DPFDT
   339  
   340    !--------------------------------------------------------------------------------------
   341  
   342    subroutine Integ_DPFDT_GQ_Array3D(    &
   343      & WN1, WN2, Num,                    & ! (in )
   344      & is, ie, js, je, ks, ke, aaa_Temp, & ! (in )
   345      & aaa_DPFDTInted                    & ! (out)
   346      & )
   347  
   348      ! USE statements
   349      !
   350  
   351      ! ガウス重み, 分点の計算
   352      ! Calculate Gauss node and Gaussian weight
   353      !
   354      use gauss_quad, only : GauLeg
   355  
   356      real(DP), intent(in ) :: WN1
   357      real(DP), intent(in ) :: WN2
   358      integer , intent(in ) :: Num
   359      integer , intent(in ) :: is
   360      integer , intent(in ) :: ie
   361      integer , intent(in ) :: js
   362      integer , intent(in ) :: je
   363      integer , intent(in ) :: ks
   364      integer , intent(in ) :: ke
   365      real(DP), intent(in ) :: aaa_Temp      (is:ie, js:je, ks:ke)
   366      real(DP), intent(out) :: aaa_DPFDTInted(is:ie, js:je, ks:ke)
   367  
   368  
   369      !
   370      ! local variables
   371      !
   372      real(DP):: GP( Num )
   373      real(DP):: GW( Num )
   374      integer :: l
   375  
   376  
   377      call GauLeg( WN1, WN2, Num, GP, GW )
   378  
   379      aaa_DPFDTInted = 0.0_DP
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t102 = 1, (ke + 1 - ks)*(je + 1 - js)*(ie + 1 - is)            
     .           aaa_dpfdtinted(is+t102-1,js,ks) = 0.0000000000000000e+000      
     .        enddo                                                             
   380  
   381      do l = 1, num
   382        aaa_DPFDTInted = aaa_DPFDTInted &
     .        if (t37 + 1 - t38 .gt. 0) then                                    
     .           j1 = and(t37 + 1 - t38,3)                                      
     .  !cdir    nodep                                                          
     .           do t113 = 1, j1                                                
     .  !cdir       nodep                                                       
     .              do t115 = 1, t35 + 1 - t36                                  
     .                 aaa_dpfdtinted(t36+t115-1,t113-1+t38,t111+t40) =         
     .       1            aaa_dpfdtinted(t36+t115-1,t113-1+t38,t111+t40) +      
     .       2            %000185(%000185.DSC.L1+t115-1,t113-1+%000185.DSC.L2,  
     .       3            t111+%000185.DSC.L3)*gw(l)                            
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t113 = j1 + 1, t37 + 1 - t38, 4                             
     .  !cdir       nodep                                                       
     .              do t115 = 1, t35 + 1 - t36                                  
     .                 d1 = gw(l)                                               
     .                 aaa_dpfdtinted(t36+t115-1,t113-1+t38,t111+t40) =         
     .       1            aaa_dpfdtinted(t36+t115-1,t113-1+t38,t111+t40) +      
     .       2            %000185(%000185.DSC.L1+t115-1,t113-1+%000185.DSC.L2,  
     .       3            t111+%000185.DSC.L3)*d1                               
     .                 aaa_dpfdtinted(t36+t115-1,t113+t38,t111+t40) =           
     .       1            aaa_dpfdtinted(t36+t115-1,t113+t38,t111+t40) + %000185
     .       2            (%000185.DSC.L1+t115-1,t113+%000185.DSC.L2,t111+      
     .       3            %000185.DSC.L3)*d1                                    
     .                 aaa_dpfdtinted(t36+t115-1,t113+1+t38,t111+t40) =         
     .       1            aaa_dpfdtinted(t36+t115-1,t113+1+t38,t111+t40) +      
     .       2            %000185(%000185.DSC.L1+t115-1,t113+1+%000185.DSC.L2,  
     .       3            t111+%000185.DSC.L3)*d1                               
     .                 aaa_dpfdtinted(t36+t115-1,t113+2+t38,t111+t40) =         
     .       1            aaa_dpfdtinted(t36+t115-1,t113+2+t38,t111+t40) +      
     .       2            %000185(%000185.DSC.L1+t115-1,t113+2+%000185.DSC.L2,  
     .       3            t111+%000185.DSC.L3)*d1                               
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
   383          & + aaa_DPFDT(                         &
   384          &              is, ie, js, je, ks, ke, & ! (in )
   385          &              GP(l),                  & ! (in )
   386          &              aaa_Temp                & ! (in )
   387          &           ) &
   388          & * GW(l)
   389      end do
   390  
   391  
   392    end subroutine Integ_DPFDT_GQ_Array3D
   393  
   394    !--------------------------------------------------------------------------------------
   395  
   396    subroutine Integ_DPFDT_GQ_Array2D( &
   397      & WN1, WN2, Num,                 & ! (in )
   398      & is, ie, js, je, aa_Temp,       & ! (in )
   399      & aa_DPFDTInted                  & ! (out)
   400      & )
   401  
   402      ! USE statements
   403      !
   404  
   405      real(DP), intent(in ) :: WN1
   406      real(DP), intent(in ) :: WN2
   407      integer , intent(in ) :: Num
   408      integer , intent(in ) :: is
   409      integer , intent(in ) :: ie
   410      integer , intent(in ) :: js
   411      integer , intent(in ) :: je
   412      real(DP), intent(in ) :: aa_Temp      (is:ie, js:je)
   413      real(DP), intent(out) :: aa_DPFDTInted(is:ie, js:je)
   414  
   415  
   416      !
   417      ! local variables
   418      !
   419      real(DP) :: aaa_Temp      (is:ie, js:je, 1:1)
   420      real(DP) :: aaa_DPFDTInted(is:ie, js:je, 1:1)
   421  
   422  
   423      aaa_Temp(:,:,1) = aa_Temp
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t74 = 1, (aaa_temp.DSC.U2 + 1 - aaa_temp.DSC.L2)*(             
     .       1   aaa_temp.DSC.U1 + 1 - aaa_temp.DSC.L1)                         
     .           aaa_temp(aaa_temp.DSC.L1+t74-1,aaa_temp.DSC.L2,1) = aa_temp(is+
     .       1      t74-1,js)                                                   
     .        enddo                                                             
   424  
   425      call Integ_DPFDT_GQ_Array3D(        &
   426        & WN1, WN2, Num,                  & ! (in )
   427        & is, ie, js, je, 1, 1, aaa_Temp, & ! (in )
   428        & aaa_DPFDTInted                  & ! (out)
   429        & )
   430  
   431      aa_DPFDTInted = aaa_DPFDTInted(:,:,1)
     .        if (t32 + 1 - t33 .gt. 0) then                                    
     .           j1 = and(t32 + 1 - t33,3)                                      
     .  !cdir    nodep                                                          
     .           do t82 = 1, j1                                                 
     .  !cdir       nodep                                                       
     .              do t84 = 1, t30 + 1 - t31                                   
     .                 aa_dpfdtinted(t31+t84-1,t82-1+t33) = aaa_dpfdtinted(     
     .       1            aaa_dpfdtinted.DSC.L1+t84-1,t82-1+                    
     .       2            aaa_dpfdtinted.DSC.L2,1)                              
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t82 = j1 + 1, t32 + 1 - t33, 4                              
     .  !cdir       nodep                                                       
     .              do t84 = 1, t30 + 1 - t31                                   
     .                 aa_dpfdtinted(t31+t84-1,t82-1+t33) = aaa_dpfdtinted(     
     .       1            aaa_dpfdtinted.DSC.L1+t84-1,t82-1+                    
     .       2            aaa_dpfdtinted.DSC.L2,1)                              
     .                 aa_dpfdtinted(t31+t84-1,t82+t33) = aaa_dpfdtinted(       
     .       1            aaa_dpfdtinted.DSC.L1+t84-1,t82+aaa_dpfdtinted.DSC.L2,
     .       2            1)                                                    
     .                 aa_dpfdtinted(t31+t84-1,t82+1+t33) = aaa_dpfdtinted(     
     .       1            aaa_dpfdtinted.DSC.L1+t84-1,t82+1+                    
     .       2            aaa_dpfdtinted.DSC.L2,1)                              
     .                 aa_dpfdtinted(t31+t84-1,t82+2+t33) = aaa_dpfdtinted(     
     .       1            aaa_dpfdtinted.DSC.L1+t84-1,t82+2+                    
     .       2            aaa_dpfdtinted.DSC.L2,1)                              
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
   432  
   433  
   434    end subroutine Integ_DPFDT_GQ_Array2D
   435  
   436    !--------------------------------------------------------------------------------------
   437    !--------------------------------------------------------------------------------------
   438    !--------------------------------------------------------------------------------------
   439    !--------------------------------------------------------------------------------------
   440    !--------------------------------------------------------------------------------------
   441    !--------------------------------------------------------------------------------------
   442    !--------------------------------------------------------------------------------------
   443    !--------------------------------------------------------------------------------------
   444    !--------------------------------------------------------------------------------------
   445    !--------------------------------------------------------------------------------------
   446    !--------------------------------------------------------------------------------------
   447  
   448    subroutine PlanckFuncPrepPFTable(                            &
   449      & WNs, WNe, NGaussQuad, TableTempMin, TableTempMax, ntmax, &
   450      & a_TableTemp, a_TableIPF, a_TableIDPFDT                   &
   451      & )
   452  
   453      ! メッセージ出力
   454      ! Message output
   455      !
   456      use dc_message, only: MessageNotify
   457  
   458      ! ガウス重み, 分点の計算
   459      ! Calculate Gauss node and Gaussian weight
   460      !
   461      use gauss_quad, only : GauLeg
   462  
   463  
   464      real(DP), intent(in ) :: WNs
   465      real(DP), intent(in ) :: WNe
   466      integer , intent(in ) :: NGaussQuad
   467      real(DP), intent(in ) :: TableTempMin
   468      real(DP), intent(in ) :: TableTempMax
   469      integer , intent(in ) :: ntmax
   470      real(DP), intent(out) :: a_TableTemp  (1:ntmax)
   471      real(DP), intent(out) :: a_TableIPF   (1:ntmax)
   472      real(DP), intent(out) :: a_TableIDPFDT(1:ntmax)
   473  
   474  
   475      ! Local variables
   476      !
   477      real(DP)              :: TableTempIncrement
   478      integer               :: nn
   479      real(DP), allocatable :: aa_TempTMP   (:,:)
   480      real(DP), allocatable :: aa_PF        (:,:)
   481      real(DP), allocatable :: aa_DPFDT     (:,:)
   482      real(DP), allocatable :: aa_PFTable   (:,:)
   483      real(DP), allocatable :: aa_DPFDTTable(:,:)
   484      real(DP)              :: ErrorPFInteg
   485      real(DP), parameter   :: ThresholdErrorPFInteg = 1.0d-3
   486                                ! Threshold for checking accuracy of calculation of
   487                                ! integrated Planc function by using a pre-calculated
   488                                ! table.
   489  
   490      ! Variables for preparation for calculation of Plank function
   491      !
   492      real(DP)      , allocatable :: a_GQP(:)
   493      real(DP)      , allocatable :: a_GQW(:)
   494  
   495  
   496      integer:: i
   497      integer:: j
   498      integer:: l
   499      integer:: m
   500  
   501  
   502      ! Preparation of tables for calculation of Plank function
   503      !
   504      TableTempIncrement = ( TableTempMax - TableTempMin ) / ( ntmax - 1 )
   505  
   506      do m = 1, ntmax
   507        a_TableTemp(m) = TableTempMin + TableTempIncrement * ( m - 1 )
   508      end do
   509  
   510  
   511      a_TableIPF    = 0.0_DP
   512      a_TableIDPFDT = 0.0_DP
   513  
   514      allocate( a_GQP(1:NGaussQuad) )
   515      allocate( a_GQW(1:NGaussQuad) )
   516      call GauLeg(              &
   517        & WNs, WNe, NGaussQuad, & ! (in )
   518        & a_GQP, a_GQW          & ! (out)
   519        & )
   520      do m = 1, ntmax
   521        do l = 1, NGaussQuad
   522          a_TableIPF   (m) = a_TableIPF   (m) + PF   ( a_GQP(l), a_TableTemp(m) ) * a_GQW(l)
   523          a_TableIDPFDT(m) = a_TableIDPFDT(m) + DPFDT( a_GQP(l), a_TableTemp(m) ) * a_GQW(l)
   524        end do
   525      end do
   526      deallocate( a_GQP )
   527      deallocate( a_GQW )
   528  
   529  
   530      !----------------------------------------------------
   531      ! Check accuracy of integration of Planc function by using a pre-calculated table.
   532      !
   533  
   534      nn = ntmax-1
   535      allocate( aa_TempTMP   (1:nn, 1:1) )
   536      allocate( aa_PF        (1:nn, 1:1) )
   537      allocate( aa_DPFDT     (1:nn, 1:1) )
   538      allocate( aa_PFTable   (1:nn, 1:1) )
   539      allocate( aa_DPFDTTable(1:nn, 1:1) )
   540  
   541      j = 1
   542  
   543      do i = 1, nn
   544        aa_TempTMP(i,j) =                                                &
   545          &   a_TableTemp(1)                                             &
   546          & + ( a_TableTemp(2) - a_TableTemp(1) ) * 0.5_DP               &
   547          & + ( a_TableTemp(2) - a_TableTemp(1) ) * ( i - 1 )
   548      end do
     .  !cdir    nodep                                                          
     .        do i = 1, nn                                                      
     .           aa_temptmp(i,1) = a_tabletemp(1) + (a_tabletemp(2)-a_tabletemp(
     .       1      1))*5.00000000000000e-001 + (a_tabletemp(2)-a_tabletemp(1))*
     .       2      dfloat(i - 1)                                               
     .        enddo                                                             
   549  
   550  
   551  
   552      call Integ_PF_GQ_Array2D(    &
   553        & WNs, WNe, NGaussQuad,    &
   554        & 1, nn, 1, 1, aa_TempTMP, &
   555        & aa_PF                    &
   556        & )
   557      call Integ_DPFDT_GQ_Array2D(     &
   558        & WNs, WNe, NGaussQuad,        & ! (in )
   559        & 1, nn, 1, 1, aa_TempTMP,     & ! (in )
   560        & aa_DPFDT                     & ! (out)
   561        & )
   562  
   563      call CalcIntegratedPFWithTable2D(   &
   564        & ntmax, a_TableTemp, a_TableIPF, &
   565        & 1, nn, 1, 1, aa_TempTMP,        &
   566        & aa_PFTable,                     &
   567        & .false.                         &
   568        & )
   569      call CalcIntegratedPFWithTable2D(      &
   570        & ntmax, a_TableTemp, a_TableIDPFDT, &
   571        & 1, nn, 1, 1, aa_TempTMP,           &
   572        & aa_DPFDTTable,                     &
   573        & .true.                             &
   574        & )
   575  
   576      do i = 1, nn
   577        ErrorPFInteg = abs( aa_PF   (i,j) - aa_PFTable   (i,j) ) / aa_PF   (i,j)
   578        if ( ErrorPFInteg > ThresholdErrorPFInteg ) then
   579          call MessageNotify( 'E', module_name, &
   580            & 'Error of integrated PF, %f, is greater than threshold, %f.', &
   581            & d = (/ ErrorPFInteg, ThresholdErrorPFInteg /) )
   582        end if
   583        ErrorPFInteg = abs( aa_DPFDT(i,j) - aa_DPFDTTable(i,j) ) / aa_DPFDT(i,j)
   584        if ( ErrorPFInteg > ThresholdErrorPFInteg ) then
   585          call MessageNotify( 'E', module_name, &
   586            & 'Error of integrated DPFDT, %f, is greater than threshold, %f.', &
   587            & d = (/ ErrorPFInteg, ThresholdErrorPFInteg /) )
   588        end if
   589      end do
   590  
   591      deallocate( aa_TempTMP    )
   592      deallocate( aa_PF         )
   593      deallocate( aa_DPFDT      )
   594      deallocate( aa_PFTable    )
   595      deallocate( aa_DPFDTTable )
   596  
   597  
   598    end subroutine PlanckFuncPrepPFTable
   599  
   600    !--------------------------------------------------------------------------------------
   601  
   602    subroutine CalcIntegratedPFWithTable2D( &
   603      & ntmax, a_TableTemp, a_TableIPF,     &
   604      & is, ie, js, je, xy_Temp,            &
   605      & xy_IntegPF,                         &
   606      & flag_DPFDT                          &
   607      & )
   608  
   609      ! USE statements
   610      !
   611  
   612      integer , intent(in )           :: ntmax
   613      real(DP), intent(in )           :: a_TableTemp(1:ntmax)
   614      real(DP), intent(in )           :: a_TableIPF (1:ntmax)
   615      integer , intent(in )           :: is
   616      integer , intent(in )           :: ie
   617      integer , intent(in )           :: js
   618      integer , intent(in )           :: je
   619      real(DP), intent(in )           :: xy_Temp    (is:ie, js:je)
   620      real(DP), intent(out)           :: xy_IntegPF (is:ie, js:je)
   621      logical , intent(in ), optional :: flag_DPFDT
   622  
   623      !
   624      ! local variables
   625      !
   626      real(DP) :: xyz_Temp   (is:ie, js:je, 1)
   627      real(DP) :: xyz_IntegPF(is:ie, js:je, 1)
   628  
   629  
   630      xyz_Temp(:,:,1) = xy_Temp
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t81 = 1, (xyz_temp.DSC.U2 + 1 - xyz_temp.DSC.L2)*(             
     .       1   xyz_temp.DSC.U1 + 1 - xyz_temp.DSC.L1)                         
     .           xyz_temp(xyz_temp.DSC.L1+t81-1,xyz_temp.DSC.L2,1) = xy_temp(is+
     .       1      t81-1,js)                                                   
     .        enddo                                                             
   631  
   632      call CalcIntegratedPFWithTable3D( &
   633        & ntmax, a_TableTemp, a_TableIPF,     &
   634        & is, ie, js, je, 1, 1, xyz_Temp,     &
   635        & xyz_IntegPF,                        &
   636        & flag_DPFDT                          &
   637        & )
   638  
   639      xy_IntegPF = xyz_IntegPF(:,:,1)
     .        if (t36 + 1 - t37 .gt. 0) then                                    
     .           j1 = and(t36 + 1 - t37,3)                                      
     .  !cdir    nodep                                                          
     .           do t89 = 1, j1                                                 
     .  !cdir       nodep                                                       
     .              do t91 = 1, t34 + 1 - t35                                   
     .                 xy_integpf(t35+t91-1,t89-1+t37) = xyz_integpf(           
     .       1            xyz_integpf.DSC.L1+t91-1,t89-1+xyz_integpf.DSC.L2,1)  
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t89 = j1 + 1, t36 + 1 - t37, 4                              
     .  !cdir       nodep                                                       
     .              do t91 = 1, t34 + 1 - t35                                   
     .                 xy_integpf(t35+t91-1,t89-1+t37) = xyz_integpf(           
     .       1            xyz_integpf.DSC.L1+t91-1,t89-1+xyz_integpf.DSC.L2,1)  
     .                 xy_integpf(t35+t91-1,t89+t37) = xyz_integpf(             
     .       1            xyz_integpf.DSC.L1+t91-1,t89+xyz_integpf.DSC.L2,1)    
     .                 xy_integpf(t35+t91-1,t89+1+t37) = xyz_integpf(           
     .       1            xyz_integpf.DSC.L1+t91-1,t89+1+xyz_integpf.DSC.L2,1)  
     .                 xy_integpf(t35+t91-1,t89+2+t37) = xyz_integpf(           
     .       1            xyz_integpf.DSC.L1+t91-1,t89+2+xyz_integpf.DSC.L2,1)  
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
   640  
   641  
   642    end subroutine CalcIntegratedPFWithTable2D
   643  
   644    !--------------------------------------------------------------------------------------
   645  
   646    subroutine CalcIntegratedPFWithTable3D( &
   647      & ntmax, a_TableTemp, a_TableIPF,     &
   648      & is, ie, js, je, ks, ke, xyz_Temp,   &
   649      & xyz_IntegPF,                        &
   650      & flag_DPFDT                          &
   651      & )
   652  
   653      ! USE statements
   654      !
   655  
   656      ! メッセージ出力
   657      ! Message output
   658      !
   659      use dc_message, only: MessageNotify
   660  
   661      integer , intent(in )           :: ntmax
   662      real(DP), intent(in )           :: a_TableTemp(1:ntmax)
   663      real(DP), intent(in )           :: a_TableIPF (1:ntmax)
   664      integer , intent(in )           :: is
   665      integer , intent(in )           :: ie
   666      integer , intent(in )           :: js
   667      integer , intent(in )           :: je
   668      integer , intent(in )           :: ks
   669      integer , intent(in )           :: ke
   670      real(DP), intent(in )           :: xyz_Temp   (is:ie, js:je, ks:ke)
   671      real(DP), intent(out)           :: xyz_IntegPF(is:ie, js:je, ks:ke)
   672      logical , intent(in ), optional :: flag_DPFDT
   673  
   674      !
   675      ! local variables
   676      !
   677      real(DP)                    :: TableTempMin
   678      real(DP)                    :: TableTempMax
   679      real(DP)                    :: TableTempIncrement
   680  
   681      logical                     :: local_flag_DPFDT
   682  
   683      integer                     :: xyz_TempIndex(is:ie, js:je, ks:ke)
   684      integer                     :: i
   685      integer                     :: j
   686      integer                     :: k
   687      integer                     :: m
   688  
   689  
   690      TableTempMin       = a_TableTemp(1)
   691      TableTempMax       = a_TableTemp(ntmax)
   692      TableTempIncrement = ( TableTempMax - TableTempMin ) / ( ntmax - 1 )
   693  
   694  
   695      do k = ks, ke
   696        do j = js, je
   697          do i = is, ie
   698  
   699            if ( ( xyz_Temp(i,j,k) < a_TableTemp(1)     ) .or. &
   700              &  ( xyz_Temp(i,j,k) > a_TableTemp(ntmax) ) ) then
   701              call MessageNotify( 'E', module_name, &
   702                & 'Temperature is not appropriate, Temp(%d,%d,%d) = %f.', &
   703                & i = (/i, j, k/), d = (/xyz_Temp(i,j,k)/) )
   704            end if
   705  
   706            xyz_TempIndex(i,j,k) = &
   707              & int( ( xyz_Temp(i,j,k) - TableTempMin ) / TableTempIncrement ) + 2
   708  
   709            if ( xyz_TempIndex(i,j,k) == 1 ) then
   710               xyz_TempIndex(i,j,k) = 2
   711            else if ( xyz_TempIndex(i,j,k) >= ntmax ) then
   712               xyz_TempIndex(i,j,k) = ntmax - 1
   713            end if
   714  
   715  !!$          xyz_TempIndex(i,j,k) = ntmax-1
   716  !!$          search_index: do m = 2, ntmax-1
   717  !!$            if ( a_TableTemp(m) >= xyz_Temp(i,j,k) ) then
   718  !!$              xyz_TempIndex(i,j,k) = m
   719  !!$              exit search_index
   720  !!$            end if
   721  !!$          end do search_index
   722  
   723          end do
   724        end do
   725      end do
   726  
   727  
   728      local_flag_DPFDT = .false.
   729      if ( present( flag_DPFDT ) ) then
   730        if ( flag_DPFDT ) then
   731          local_flag_DPFDT = .true.
   732        end if
   733      end if
   734  
   735      if ( .not. local_flag_DPFDT ) then
   736        do k = ks, ke
   737          do j = js, je
   738            do i = is, ie
   739              m = xyz_TempIndex(i,j,k)
   740  
   741  !!$            xyz_IntegPF(i,j,k) = &
   742  !!$              &   ( aa_TableIPF( m, iband ) - aa_TableIPF( m-1, iband ) ) &
   743  !!$              & / ( a_TableTemp( m )        - a_TableTemp( m-1 )        ) &
   744  !!$              & * ( xyz_Temp(i,j,k)         - a_TableTemp( m-1 )        ) &
   745  !!$              & +   aa_TableIPF( m-1, iband )
   746  
   747              xyz_IntegPF(i,j,k) = &
   748                &   a_TableIPF(m-1)                                  &
   749                &   * ( xyz_Temp   (i,j,k) - a_TableTemp( m   ) )    &
   750                &   * ( xyz_Temp   (i,j,k) - a_TableTemp( m+1 ) )    &
   751                & / ( ( a_TableTemp( m-1 ) - a_TableTemp( m   ) )    &
   752                &   * ( a_TableTemp( m-1 ) - a_TableTemp( m+1 ) ) )  &
   753                & + a_TableIPF(m  )                                  &
   754                &   * ( xyz_Temp   (i,j,k) - a_TableTemp( m-1 ) )    &
   755                &   * ( xyz_Temp   (i,j,k) - a_TableTemp( m+1 ) )    &
   756                & / ( ( a_TableTemp( m   ) - a_TableTemp( m-1 ) )    &
   757                &   * ( a_TableTemp( m   ) - a_TableTemp( m+1 ) ) )  &
   758                & + a_TableIPF(m+1)                                  &
   759                &   * ( xyz_Temp   (i,j,k) - a_TableTemp( m-1 ) )    &
   760                &   * ( xyz_Temp   (i,j,k) - a_TableTemp( m   ) )    &
   761                & / ( ( a_TableTemp( m+1 ) - a_TableTemp( m-1 ) )    &
   762                &   * ( a_TableTemp( m+1 ) - a_TableTemp( m   ) ) )
   763            end do
   764          end do
   765        end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do k = 1, (ke + 1 - ks)*(je + 1 - js)*(ie + 1 - is)               
     .           m = xyz_tempindex(is+k-1,js,ks)                                
     .           xyz_integpf(is+k-1,js,ks) = a_tableipf(m-1)*(xyz_temp(is+k-1,js
     .       1      ,ks)-(a_tabletemp(m)))*(xyz_temp(is+k-1,js,ks)-a_tabletemp(m
     .       2      +1))/((a_tabletemp(m-1)-(a_tabletemp(m)))*(a_tabletemp(m-1)-
     .       3      a_tabletemp(m+1))) + a_tableipf(m)*(xyz_temp(is+k-1,js,ks)- 
     .       4      a_tabletemp(m-1))*(xyz_temp(is+k-1,js,ks)-a_tabletemp(m+1))/
     .       5      (((a_tabletemp(m))-a_tabletemp(m-1))*((a_tabletemp(m))-     
     .       6      a_tabletemp(m+1))) + a_tableipf(m+1)*(xyz_temp(is+k-1,js,ks)
     .       7      -a_tabletemp(m-1))*(xyz_temp(is+k-1,js,ks)-(a_tabletemp(m)))
     .       8      /((a_tabletemp(m+1)-a_tabletemp(m-1))*(a_tabletemp(m+1)-(   
     .       9      a_tabletemp(m))))                                           
     .        enddo                                                             
     .        goto 10017                                                        
   766      else
   767        do k = ks, ke
   768          do j = js, je
   769            do i = is, ie
   770              m = xyz_TempIndex(i,j,k)
   771  
   772  !!$            xyz_IntegPF(i,j,k) = &
   773  !!$              &   ( aa_TableIDPFDT( m, iband ) - aa_TableIDPFDT( m-1, iband ) ) &
   774  !!$              & / ( a_TableTemp   ( m )        - a_TableTemp   ( m-1 )        ) &
   775  !!$              & * ( xyz_Temp(i,j,k)         - a_TableTemp( m-1 )        ) &
   776  !!$              & +   aa_TableIPF( m-1, iband )
   777  
   778              xyz_IntegPF(i,j,k) = &
   779                &   a_TableIPF(m-1)                                  &
   780                &   * ( xyz_Temp   (i,j,k) - a_TableTemp( m   ) )    &
   781                &   * ( xyz_Temp   (i,j,k) - a_TableTemp( m+1 ) )    &
   782                & / ( ( a_TableTemp( m-1 ) - a_TableTemp( m   ) )    &
   783                &   * ( a_TableTemp( m-1 ) - a_TableTemp( m+1 ) ) )  &
   784                & + a_TableIPF(m  )                                  &
   785                &   * ( xyz_Temp   (i,j,k) - a_TableTemp( m-1 ) )    &
   786                &   * ( xyz_Temp   (i,j,k) - a_TableTemp( m+1 ) )    &
   787                & / ( ( a_TableTemp( m   ) - a_TableTemp( m-1 ) )    &
   788                &   * ( a_TableTemp( m   ) - a_TableTemp( m+1 ) ) )  &
   789                & + a_TableIPF(m+1)                                  &
   790                &   * ( xyz_Temp   (i,j,k) - a_TableTemp( m-1 ) )    &
   791                &   * ( xyz_Temp   (i,j,k) - a_TableTemp( m   ) )    &
   792                & / ( ( a_TableTemp( m+1 ) - a_TableTemp( m-1 ) )    &
   793                &   * ( a_TableTemp( m+1 ) - a_TableTemp( m   ) ) )
   794            end do
   795          end do
   796        end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do k = 1, (ke + 1 - ks)*(je + 1 - js)*(ie + 1 - is)               
     .           m = xyz_tempindex(is+k-1,js,ks)                                
     .           xyz_integpf(is+k-1,js,ks) = a_tableipf(m-1)*(xyz_temp(is+k-1,js
     .       1      ,ks)-(a_tabletemp(m)))*(xyz_temp(is+k-1,js,ks)-a_tabletemp(m
     .       2      +1))/((a_tabletemp(m-1)-(a_tabletemp(m)))*(a_tabletemp(m-1)-
     .       3      a_tabletemp(m+1))) + a_tableipf(m)*(xyz_temp(is+k-1,js,ks)- 
     .       4      a_tabletemp(m-1))*(xyz_temp(is+k-1,js,ks)-a_tabletemp(m+1))/
     .       5      (((a_tabletemp(m))-a_tabletemp(m-1))*((a_tabletemp(m))-     
     .       6      a_tabletemp(m+1))) + a_tableipf(m+1)*(xyz_temp(is+k-1,js,ks)
     .       7      -a_tabletemp(m-1))*(xyz_temp(is+k-1,js,ks)-(a_tabletemp(m)))
     .       8      /((a_tabletemp(m+1)-a_tabletemp(m-1))*(a_tabletemp(m+1)-(   
     .       9      a_tabletemp(m))))                                           
     .        enddo                                                             
   797      end if
   798  
   799  
   800    end subroutine CalcIntegratedPFWithTable3D
   801  
   802    !--------------------------------------------------------------------------------------
   803  
   804  end module planck_func
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:46 2016
FILE NAME: planck_func.f90
PROGRAM NAME: 
DIAGNOSTIC LIST

  LINE  LEVEL( NO.): DIAGNOSTIC MESSAGE

   808  warn (   6): Only comment lines in program.
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:46 2016
FILE NAME: planck_func.f90
PROGRAM NAME: 
TRANSFORMATION LIST

  LINE                   FORTRAN STATEMENT

   805  
   806  
   807  
   808  
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:46 2016
FILE NAME: planck_func.f90
PROGRAM NAME: planck_func
FORMAT LIST

  LINE    LOOP      FORTRAN STATEMENT

     1:             != プランク関数の計算
     2:             !
     3:             != Calculate Planck function
     4:             !
     5:             ! Authors::   Yoshiyuki O. Takahashi
     6:             ! Version::   $Id: planck_func.f90,v 1.6 2014/05/07 09:39:21 murashin Exp $ 
     7:             ! Tag Name::  $Name:  $
     8:             ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9:             ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10:             !
    11:             
    12:             module planck_func
    13:               !
    14:               != プランク関数の計算
    15:               !
    16:               != Calculate Planck function
    17:               !
    18:               ! <b>Note that Japanese and English are described in parallel.</b>
    19:               !
    20:               ! 
    21:               !
    22:               ! 
    23:               !
    24:               !== Procedures List
    25:               !
    26:             !!$  ! RadiationFluxDennouAGCM :: 放射フラックスの計算
    27:             !!$  ! RadiationDTempDt        :: 放射フラックスによる温度変化の計算
    28:             !!$  ! RadiationFluxOutput     :: 放射フラックスの出力
    29:             !!$  ! RadiationFinalize       :: 終了処理 (モジュール内部の変数の割り付け解除)
    30:             !!$  ! ------------            :: ------------
    31:             !!$  ! RadiationFluxDennouAGCM :: Calculate radiation flux
    32:             !!$  ! RadiationDTempDt        :: Calculate temperature tendency with radiation flux
    33:             !!$  ! RadiationFluxOutput     :: Output radiation fluxes
    34:             !!$  ! RadiationFinalize       :: Termination (deallocate variables in this module)
    35:               !
    36:               !== NAMELIST
    37:               !
    38:             !!$  ! NAMELIST#radiation_DennouAGCM_nml
    39:               !
    40:             
    41:               ! モジュール引用 ; USE statements
    42:               !
    43:             
    44:               ! 種別型パラメタ
    45:               ! Kind type parameter
    46:               !
    47:               use dc_types, only: DP, &      ! 倍精度実数型. Double precision. 
    48:                 &                 STRING, &  ! 文字列.       Strings. 
    49:                 &                 TOKEN      ! キーワード.   Keywords. 
    50:             
    51:             
    52:               ! 宣言文 ; Declaration statements
    53:               !
    54:               implicit none
    55:               private
    56:             
    57:               ! 公開手続き
    58:               ! Public procedure
    59:               !
    60:               public :: aaa_PF
    61:               public :: PF
    62:               public :: DPFDT
    63:               public :: Integ_PF_GQ_Array3D
    64:               public :: Integ_PF_GQ_Array2D
    65:               public :: Integ_DPFDT_GQ_Array2D
    66:               public :: Integ_DPFDT_GQ_Array3D
    67:             
    68:               ! 公開変数
    69:               ! Public variables
    70:               !
    71:             !!$  logical, save :: planck_func_inited = .false.
    72:                                           ! 初期設定フラグ. 
    73:                                           ! Initialization flag
    74:             
    75:             
    76:               ! 非公開変数
    77:               ! Private variables
    78:               !
    79:               real(DP), parameter ::                &
    80:                 & SOL    = 2.99792458e8_DP        , &
    81:                 & Planc  = 6.6260755e-34_DP       , &
    82:                 & Boltz  = 1.380658e-23_DP
    83:             
    84:               character(*), parameter:: module_name = 'planck_func'
    85:                                           ! モジュールの名称. 
    86:                                           ! Module name
    87:               character(*), parameter:: version = &
    88:                 & '$Name:  $' // &
    89:                 & '$Id: planck_func.f90,v 1.6 2014/05/07 09:39:21 murashin Exp $'
    90:                                           ! モジュールのバージョン
    91:                                           ! Module version
    92:             
    93:             contains
    94:             
    95:               !--------------------------------------------------------------------------------------
    96:             
    97:               function aaa_PF( &
    98:                 & is, ie, js, je, ks, ke, &
    99:                 & WN, aaa_Temp &
   100:                 & ) &
   101:                 result( aaa_Res )
   102:                 !
   103:                 ! 温度, 比湿, 気圧から, 放射フラックスを計算します. 
   104:                 !
   105:                 ! Calculate radiation flux from temperature, specific humidity, and 
   106:                 ! air pressure. 
   107:                 !
   108:             
   109:                 ! モジュール引用 ; USE statements
   110:                 !
   111:             
   112:                 ! 宣言文 ; Declaration statements
   113:                 !
   114:                 integer , intent(in) :: is
   115:                 integer , intent(in) :: ie
   116:                 integer , intent(in) :: js
   117:                 integer , intent(in) :: je
   118:                 integer , intent(in) :: ks
   119:                 integer , intent(in) :: ke
   120:                 real(DP), intent(in) :: WN
   121:                 real(DP), intent(in) :: aaa_Temp(is:ie, js:je, ks:ke)
   122:                 real(DP)             :: aaa_Res (is:ie, js:je, ks:ke)
   123:             
   124:                 ! 作業変数
   125:                 ! Work variables
   126:                 !
   127:             
   128:                 ! 実行文 ; Executable statement
   129:                 !
   130:             
   131: W**==== A       aaa_Res = 2.0_DP * Planc * SOL * SOL * WN * WN * WN &
   132:                   / ( exp( Planc * SOL * ( WN+1.0e-10_DP ) / ( Boltz * aaa_Temp ) ) - 1.0_DP )
   133:             
   134:             
   135:               end function aaa_PF
   136:             
   137:               !--------------------------------------------------------------------------------------
   138:             
   139:               function PF( WN, Temp ) result( Res )
   140:                 !
   141:                 ! 温度, 比湿, 気圧から, 放射フラックスを計算します. 
   142:                 !
   143:                 ! Calculate radiation flux from temperature, specific humidity, and 
   144:                 ! air pressure. 
   145:                 !
   146:             
   147:                 ! モジュール引用 ; USE statements
   148:                 !
   149:             
   150:                 ! 宣言文 ; Declaration statements
   151:                 !
   152:                 real(DP), intent(in) :: WN
   153:                 real(DP), intent(in) :: Temp
   154:                 real(DP)             :: Res
   155:             
   156:                 ! 作業変数
   157:                 ! Work variables
   158:                 !
   159:                 real(DP) :: aaa_Temp(1,1,1)
   160:                 real(DP) :: aaa_Res (1,1,1)
   161:             
   162:                 ! 実行文 ; Executable statement
   163:                 !
   164:             
   165:                 aaa_Temp(1,1,1) = Temp
   166:                 aaa_Res = &
   167:                   & aaa_PF( &
   168:                   &         1, 1, 1, 1, 1, 1, &
   169:                   &         WN, aaa_Temp &
   170:                   &       )
   171:             
   172:                 Res = aaa_Res(1,1,1)
   173:             
   174:             
   175:               end function PF
   176:             
   177:               !--------------------------------------------------------------------------------------
   178:             
   179:               subroutine Integ_PF_GQ_Array3D( &
   180:                 & wn1, wn2, num, &
   181:                 & is, ie, js, je, ks, ke, &
   182:                 & aaa_temp, &
   183:                 & aaa_pfinted &
   184:                 & )
   185:             
   186:                 ! ガウス重み, 分点の計算
   187:                 ! Calculate Gauss node and Gaussian weight
   188:                 !
   189:                 use gauss_quad, only : GauLeg
   190:             
   191:                 real(DP), intent(in ) :: wn1,wn2
   192:                 integer , intent(in ) :: num
   193:                 integer , intent(in ) :: is, ie
   194:                 integer , intent(in ) :: js, je
   195:                 integer , intent(in ) :: ks, ke
   196:                 real(DP), intent(in ) :: aaa_temp   (is:ie, js:je, ks:ke)
   197:                 real(DP), intent(out) :: aaa_pfinted(is:ie, js:je, ks:ke)
   198:             
   199:             
   200:                 !
   201:                 ! local variables
   202:                 !
   203:                 real(DP):: x( num ), w( num )
   204:                 integer :: l
   205:             
   206:             
   207:                 call GauLeg( wn1, wn2, num, x, w )
   208:             
   209: W**==== A       aaa_pfinted(:,:,:) = 0.0_DP
   210:             
   211: +------>        do l = 1, num
   212: |++V=== A         aaa_pfinted(:,:,:) = aaa_pfinted(:,:,:)       &
   213: |                   & + aaa_PF(                         &
   214: |                   &           is, ie, js, je, ks, ke, &
   215: |                   &           x(l), aaa_Temp          &
   216: |                   &         )                         &
   217: |                   & * w( l )
   218: +------         end do
   219:             
   220:             
   221:               end subroutine Integ_PF_GQ_Array3D
   222:             
   223:               !--------------------------------------------------------------------------------------
   224:             
   225:               subroutine Integ_PF_GQ_Array2D( &
   226:                 & wn1, wn2, num, &
   227:                 & is, ie, js, je, &
   228:                 & temp, &
   229:                 & pfinted &
   230:                 & )
   231:             
   232:             
   233:                 real(DP), intent(in ) :: wn1,wn2
   234:                 integer , intent(in ) :: num
   235:                 integer , intent(in ) :: is
   236:                 integer , intent(in ) :: ie
   237:                 integer , intent(in ) :: js
   238:                 integer , intent(in ) :: je
   239:                 real(DP), intent(in ) :: temp   (is:ie, js:je)
   240:                 real(DP), intent(out) :: pfinted(is:ie, js:je)
   241:             
   242:             
   243:                 !
   244:                 ! local variables
   245:                 !
   246:                 real(DP) :: temp3d   (is:ie, js:je, 1:1)
   247:                 real(DP) :: pfinted3d(is:ie, js:je, 1:1)
   248:             
   249:             
   250: W*===== A       temp3d(:,:,1) = temp(:,:)
   251:                 call Integ_PF_GQ_Array3D( &
   252:                   & wn1, wn2, num, &
   253:                   & is, ie, js, je, 1, 1, &
   254:                   & temp3d, &
   255:                   & pfinted3d &
   256:                   & )
   257: +V===== A       pfinted(:,:) = pfinted3d(:,:,1)
   258:             
   259:             
   260:               end subroutine Integ_PF_GQ_Array2D
   261:             
   262:               !--------------------------------------------------------------------------------------
   263:             
   264:               function DPFDT( &
   265:                 & WN,    & ! (in )
   266:                 & Temp   & ! (in )
   267:                 & )      &
   268:                 & result( Res )
   269:             
   270:                 ! USE statements
   271:                 !
   272:             
   273:                 ! 宣言文 ; Declaration statements
   274:                 !
   275:                 real(DP), intent(in ) :: WN
   276:                 real(DP), intent(in ) :: Temp
   277:                 real(DP)              :: Res
   278:             
   279:             
   280:                 ! 作業変数
   281:                 ! Work variables
   282:                 !
   283:                 real(DP) :: aaa_Temp(1,1,1)
   284:                 real(DP) :: aaa_Res (1,1,1)
   285:             
   286:             
   287:                 aaa_Temp(1,1,1) = Temp
   288:             
   289:                 aaa_Res = aaa_DPFDT(                  &
   290:                   &                 1, 1, 1, 1, 1, 1, & ! (in )
   291:                   &                 WN,               & ! (in )
   292:                   &                 aaa_Temp          & ! (in )
   293:                   & )
   294:             
   295:                 Res = aaa_Res(1,1,1)
   296:             
   297:             
   298:               end function DPFDT
   299:             
   300:               !--------------------------------------------------------------------------------------
   301:             
   302:               function aaa_DPFDT( &
   303:                 & is, ie, js, je, ks, ke, & ! (in )
   304:                 & WN,                     & ! (in )
   305:                 & aaa_Temp                & ! (in )
   306:                 & )                       &
   307:                 & result( aaa_Res )
   308:             
   309:                 ! USE statements
   310:                 !
   311:             
   312:                 integer , intent(in ) :: is
   313:                 integer , intent(in ) :: ie
   314:                 integer , intent(in ) :: js
   315:                 integer , intent(in ) :: je
   316:                 integer , intent(in ) :: ks
   317:                 integer , intent(in ) :: ke
   318:                 real(DP), intent(in ) :: WN
   319:                 real(DP), intent(in ) :: aaa_Temp(is:ie, js:je, ks:ke)
   320:                 real(DP)              :: aaa_Res (is:ie, js:je, ks:ke)
   321:             
   322:             
   323:                 real(DP) :: aaa_ExpTerm(is:ie, js:je, ks:ke)
   324:                 real(DP) :: aaa_PF     (is:ie, js:je, ks:ke)
   325:             
   326:             
   327: **W---->A       aaa_ExpTerm = exp( Planc * SOL * ( WN + 1.0e-10_DP ) / ( Boltz * aaa_Temp ) )
   328: |||         
   329: |||             aaa_PF = 2.0_DP * Planc * SOL * SOL * WN * WN * WN &
   330: |||               / ( aaa_ExpTerm - 1.0_DP )
   331: |||         
   332: **W----         aaa_Res = &
   333:                   & 1.0_DP / ( 2.0_DP * SOL * WN * WN * Boltz ) &
   334:                   & * ( aaa_PF / aaa_Temp )**2 &
   335:                   & * aaa_ExpTerm
   336:             
   337:             
   338:               end function aaa_DPFDT
   339:             
   340:               !--------------------------------------------------------------------------------------
   341:             
   342:               subroutine Integ_DPFDT_GQ_Array3D(    &
   343:                 & WN1, WN2, Num,                    & ! (in )
   344:                 & is, ie, js, je, ks, ke, aaa_Temp, & ! (in )
   345:                 & aaa_DPFDTInted                    & ! (out)
   346:                 & )
   347:             
   348:                 ! USE statements
   349:                 !
   350:             
   351:                 ! ガウス重み, 分点の計算
   352:                 ! Calculate Gauss node and Gaussian weight
   353:                 !
   354:                 use gauss_quad, only : GauLeg
   355:             
   356:                 real(DP), intent(in ) :: WN1
   357:                 real(DP), intent(in ) :: WN2
   358:                 integer , intent(in ) :: Num
   359:                 integer , intent(in ) :: is
   360:                 integer , intent(in ) :: ie
   361:                 integer , intent(in ) :: js
   362:                 integer , intent(in ) :: je
   363:                 integer , intent(in ) :: ks
   364:                 integer , intent(in ) :: ke
   365:                 real(DP), intent(in ) :: aaa_Temp      (is:ie, js:je, ks:ke)
   366:                 real(DP), intent(out) :: aaa_DPFDTInted(is:ie, js:je, ks:ke)
   367:             
   368:             
   369:                 !
   370:                 ! local variables
   371:                 !
   372:                 real(DP):: GP( Num )
   373:                 real(DP):: GW( Num )
   374:                 integer :: l
   375:             
   376:             
   377:                 call GauLeg( WN1, WN2, Num, GP, GW )
   378:             
   379: W**==== A       aaa_DPFDTInted = 0.0_DP
   380:             
   381: +------>        do l = 1, num
   382: |++V=== A         aaa_DPFDTInted = aaa_DPFDTInted &
   383: |                   & + aaa_DPFDT(                         &
   384: |                   &              is, ie, js, je, ks, ke, & ! (in )
   385: |                   &              GP(l),                  & ! (in )
   386: |                   &              aaa_Temp                & ! (in )
   387: |                   &           ) &
   388: |                   & * GW(l)
   389: +------         end do
   390:             
   391:             
   392:               end subroutine Integ_DPFDT_GQ_Array3D
   393:             
   394:               !--------------------------------------------------------------------------------------
   395:             
   396:               subroutine Integ_DPFDT_GQ_Array2D( &
   397:                 & WN1, WN2, Num,                 & ! (in )
   398:                 & is, ie, js, je, aa_Temp,       & ! (in )
   399:                 & aa_DPFDTInted                  & ! (out)
   400:                 & )
   401:             
   402:                 ! USE statements
   403:                 !
   404:             
   405:                 real(DP), intent(in ) :: WN1
   406:                 real(DP), intent(in ) :: WN2
   407:                 integer , intent(in ) :: Num
   408:                 integer , intent(in ) :: is
   409:                 integer , intent(in ) :: ie
   410:                 integer , intent(in ) :: js
   411:                 integer , intent(in ) :: je
   412:                 real(DP), intent(in ) :: aa_Temp      (is:ie, js:je)
   413:                 real(DP), intent(out) :: aa_DPFDTInted(is:ie, js:je)
   414:             
   415:             
   416:                 !
   417:                 ! local variables
   418:                 !
   419:                 real(DP) :: aaa_Temp      (is:ie, js:je, 1:1)
   420:                 real(DP) :: aaa_DPFDTInted(is:ie, js:je, 1:1)
   421:             
   422:             
   423: W*===== A       aaa_Temp(:,:,1) = aa_Temp
   424:             
   425:                 call Integ_DPFDT_GQ_Array3D(        &
   426:                   & WN1, WN2, Num,                  & ! (in )
   427:                   & is, ie, js, je, 1, 1, aaa_Temp, & ! (in )
   428:                   & aaa_DPFDTInted                  & ! (out)
   429:                   & )
   430:             
   431: +V===== A       aa_DPFDTInted = aaa_DPFDTInted(:,:,1)
   432:             
   433:             
   434:               end subroutine Integ_DPFDT_GQ_Array2D
   435:             
   436:               !--------------------------------------------------------------------------------------
   437:               !--------------------------------------------------------------------------------------
   438:               !--------------------------------------------------------------------------------------
   439:               !--------------------------------------------------------------------------------------
   440:               !--------------------------------------------------------------------------------------
   441:               !--------------------------------------------------------------------------------------
   442:               !--------------------------------------------------------------------------------------
   443:               !--------------------------------------------------------------------------------------
   444:               !--------------------------------------------------------------------------------------
   445:               !--------------------------------------------------------------------------------------
   446:               !--------------------------------------------------------------------------------------
   447:             
   448:               subroutine PlanckFuncPrepPFTable(                            &
   449:                 & WNs, WNe, NGaussQuad, TableTempMin, TableTempMax, ntmax, &
   450:                 & a_TableTemp, a_TableIPF, a_TableIDPFDT                   &
   451:                 & )
   452:             
   453:                 ! メッセージ出力
   454:                 ! Message output
   455:                 !
   456:                 use dc_message, only: MessageNotify
   457:             
   458:                 ! ガウス重み, 分点の計算
   459:                 ! Calculate Gauss node and Gaussian weight
   460:                 !
   461:                 use gauss_quad, only : GauLeg
   462:             
   463:             
   464:                 real(DP), intent(in ) :: WNs
   465:                 real(DP), intent(in ) :: WNe
   466:                 integer , intent(in ) :: NGaussQuad
   467:                 real(DP), intent(in ) :: TableTempMin
   468:                 real(DP), intent(in ) :: TableTempMax
   469:                 integer , intent(in ) :: ntmax
   470:                 real(DP), intent(out) :: a_TableTemp  (1:ntmax)
   471:                 real(DP), intent(out) :: a_TableIPF   (1:ntmax)
   472:                 real(DP), intent(out) :: a_TableIDPFDT(1:ntmax)
   473:             
   474:             
   475:                 ! Local variables
   476:                 !
   477:                 real(DP)              :: TableTempIncrement
   478:                 integer               :: nn
   479:                 real(DP), allocatable :: aa_TempTMP   (:,:)
   480:                 real(DP), allocatable :: aa_PF        (:,:)
   481:                 real(DP), allocatable :: aa_DPFDT     (:,:)
   482:                 real(DP), allocatable :: aa_PFTable   (:,:)
   483:                 real(DP), allocatable :: aa_DPFDTTable(:,:)
   484:                 real(DP)              :: ErrorPFInteg
   485:                 real(DP), parameter   :: ThresholdErrorPFInteg = 1.0d-3
   486:                                           ! Threshold for checking accuracy of calculation of
   487:                                           ! integrated Planc function by using a pre-calculated
   488:                                           ! table.
   489:             
   490:                 ! Variables for preparation for calculation of Plank function
   491:                 !
   492:                 real(DP)      , allocatable :: a_GQP(:)
   493:                 real(DP)      , allocatable :: a_GQW(:)
   494:             
   495:             
   496:                 integer:: i
   497:                 integer:: j
   498:                 integer:: l
   499:                 integer:: m
   500:             
   501:             
   502:                 ! Preparation of tables for calculation of Plank function
   503:                 !
   504:                 TableTempIncrement = ( TableTempMax - TableTempMin ) / ( ntmax - 1 )
   505:             
   506: V------>        do m = 1, ntmax
   507: |       A         a_TableTemp(m) = TableTempMin + TableTempIncrement * ( m - 1 )
   508: V------         end do
   509:             
   510:             
   511: V------>A       a_TableIPF    = 0.0_DP
   512: V------ A       a_TableIDPFDT = 0.0_DP
   513:             
   514:                 allocate( a_GQP(1:NGaussQuad) )
   515:                 allocate( a_GQW(1:NGaussQuad) )
   516:                 call GauLeg(              &
   517:                   & WNs, WNe, NGaussQuad, & ! (in )
   518:                   & a_GQP, a_GQW          & ! (out)
   519:                   & )
   520: +------>        do m = 1, ntmax
   521: |+----->          do l = 1, NGaussQuad
   522: ||                  a_TableIPF   (m) = a_TableIPF   (m) + PF   ( a_GQP(l), a_TableTemp(m) ) * a_GQW(l)
   523: ||                  a_TableIDPFDT(m) = a_TableIDPFDT(m) + DPFDT( a_GQP(l), a_TableTemp(m) ) * a_GQW(l)
   524: |+-----           end do
   525: +------         end do
   526:                 deallocate( a_GQP )
   527:                 deallocate( a_GQW )
   528:             
   529:             
   530:                 !----------------------------------------------------
   531:                 ! Check accuracy of integration of Planc function by using a pre-calculated table.
   532:                 !
   533:             
   534:                 nn = ntmax-1
   535:                 allocate( aa_TempTMP   (1:nn, 1:1) )
   536:                 allocate( aa_PF        (1:nn, 1:1) )
   537:                 allocate( aa_DPFDT     (1:nn, 1:1) )
   538:                 allocate( aa_PFTable   (1:nn, 1:1) )
   539:                 allocate( aa_DPFDTTable(1:nn, 1:1) )
   540:             
   541:                 j = 1
   542:             
   543: V------>        do i = 1, nn
   544: |       A         aa_TempTMP(i,j) =                                                &
   545: |                   &   a_TableTemp(1)                                             &
   546: |                   & + ( a_TableTemp(2) - a_TableTemp(1) ) * 0.5_DP               &
   547: |                   & + ( a_TableTemp(2) - a_TableTemp(1) ) * ( i - 1 )
   548: V------         end do
   549:             
   550:             
   551:             
   552:                 call Integ_PF_GQ_Array2D(    &
   553:                   & WNs, WNe, NGaussQuad,    &
   554:                   & 1, nn, 1, 1, aa_TempTMP, &
   555:                   & aa_PF                    &
   556:                   & )
   557:                 call Integ_DPFDT_GQ_Array2D(     &
   558:                   & WNs, WNe, NGaussQuad,        & ! (in )
   559:                   & 1, nn, 1, 1, aa_TempTMP,     & ! (in )
   560:                   & aa_DPFDT                     & ! (out)
   561:                   & )
   562:             
   563:                 call CalcIntegratedPFWithTable2D(   &
   564:                   & ntmax, a_TableTemp, a_TableIPF, &
   565:                   & 1, nn, 1, 1, aa_TempTMP,        &
   566:                   & aa_PFTable,                     &
   567:                   & .false.                         &
   568:                   & )
   569:                 call CalcIntegratedPFWithTable2D(      &
   570:                   & ntmax, a_TableTemp, a_TableIDPFDT, &
   571:                   & 1, nn, 1, 1, aa_TempTMP,           &
   572:                   & aa_DPFDTTable,                     &
   573:                   & .true.                             &
   574:                   & )
   575:             
   576: +------>        do i = 1, nn
   577: |                 ErrorPFInteg = abs( aa_PF   (i,j) - aa_PFTable   (i,j) ) / aa_PF   (i,j)
   578: |                 if ( ErrorPFInteg > ThresholdErrorPFInteg ) then
   579: |                   call MessageNotify( 'E', module_name, &
   580: |                     & 'Error of integrated PF, %f, is greater than threshold, %f.', &
   581: |                     & d = (/ ErrorPFInteg, ThresholdErrorPFInteg /) )
   582: |                 end if
   583: |                 ErrorPFInteg = abs( aa_DPFDT(i,j) - aa_DPFDTTable(i,j) ) / aa_DPFDT(i,j)
   584: |                 if ( ErrorPFInteg > ThresholdErrorPFInteg ) then
   585: |                   call MessageNotify( 'E', module_name, &
   586: |                     & 'Error of integrated DPFDT, %f, is greater than threshold, %f.', &
   587: |                     & d = (/ ErrorPFInteg, ThresholdErrorPFInteg /) )
   588: |                 end if
   589: +------         end do
   590:             
   591:                 deallocate( aa_TempTMP    )
   592:                 deallocate( aa_PF         )
   593:                 deallocate( aa_DPFDT      )
   594:                 deallocate( aa_PFTable    )
   595:                 deallocate( aa_DPFDTTable )
   596:             
   597:             
   598:               end subroutine PlanckFuncPrepPFTable
   599:             
   600:               !--------------------------------------------------------------------------------------
   601:             
   602:               subroutine CalcIntegratedPFWithTable2D( &
   603:                 & ntmax, a_TableTemp, a_TableIPF,     &
   604:                 & is, ie, js, je, xy_Temp,            &
   605:                 & xy_IntegPF,                         &
   606:                 & flag_DPFDT                          &
   607:                 & )
   608:             
   609:                 ! USE statements
   610:                 !
   611:             
   612:                 integer , intent(in )           :: ntmax
   613:                 real(DP), intent(in )           :: a_TableTemp(1:ntmax)
   614:                 real(DP), intent(in )           :: a_TableIPF (1:ntmax)
   615:                 integer , intent(in )           :: is
   616:                 integer , intent(in )           :: ie
   617:                 integer , intent(in )           :: js
   618:                 integer , intent(in )           :: je
   619:                 real(DP), intent(in )           :: xy_Temp    (is:ie, js:je)
   620:                 real(DP), intent(out)           :: xy_IntegPF (is:ie, js:je)
   621:                 logical , intent(in ), optional :: flag_DPFDT
   622:             
   623:                 !
   624:                 ! local variables
   625:                 !
   626:                 real(DP) :: xyz_Temp   (is:ie, js:je, 1)
   627:                 real(DP) :: xyz_IntegPF(is:ie, js:je, 1)
   628:             
   629:             
   630: W*===== A       xyz_Temp(:,:,1) = xy_Temp
   631:             
   632:                 call CalcIntegratedPFWithTable3D( &
   633:                   & ntmax, a_TableTemp, a_TableIPF,     &
   634:                   & is, ie, js, je, 1, 1, xyz_Temp,     &
   635:                   & xyz_IntegPF,                        &
   636:                   & flag_DPFDT                          &
   637:                   & )
   638:             
   639: +V===== A       xy_IntegPF = xyz_IntegPF(:,:,1)
   640:             
   641:             
   642:               end subroutine CalcIntegratedPFWithTable2D
   643:             
   644:               !--------------------------------------------------------------------------------------
   645:             
   646:               subroutine CalcIntegratedPFWithTable3D( &
   647:                 & ntmax, a_TableTemp, a_TableIPF,     &
   648:                 & is, ie, js, je, ks, ke, xyz_Temp,   &
   649:                 & xyz_IntegPF,                        &
   650:                 & flag_DPFDT                          &
   651:                 & )
   652:             
   653:                 ! USE statements
   654:                 !
   655:             
   656:                 ! メッセージ出力
   657:                 ! Message output
   658:                 !
   659:                 use dc_message, only: MessageNotify
   660:             
   661:                 integer , intent(in )           :: ntmax
   662:                 real(DP), intent(in )           :: a_TableTemp(1:ntmax)
   663:                 real(DP), intent(in )           :: a_TableIPF (1:ntmax)
   664:                 integer , intent(in )           :: is
   665:                 integer , intent(in )           :: ie
   666:                 integer , intent(in )           :: js
   667:                 integer , intent(in )           :: je
   668:                 integer , intent(in )           :: ks
   669:                 integer , intent(in )           :: ke
   670:                 real(DP), intent(in )           :: xyz_Temp   (is:ie, js:je, ks:ke)
   671:                 real(DP), intent(out)           :: xyz_IntegPF(is:ie, js:je, ks:ke)
   672:                 logical , intent(in ), optional :: flag_DPFDT
   673:             
   674:                 !
   675:                 ! local variables
   676:                 !
   677:                 real(DP)                    :: TableTempMin
   678:                 real(DP)                    :: TableTempMax
   679:                 real(DP)                    :: TableTempIncrement
   680:             
   681:                 logical                     :: local_flag_DPFDT
   682:             
   683:                 integer                     :: xyz_TempIndex(is:ie, js:je, ks:ke)
   684:                 integer                     :: i
   685:                 integer                     :: j
   686:                 integer                     :: k
   687:                 integer                     :: m
   688:             
   689:             
   690:                 TableTempMin       = a_TableTemp(1)
   691:                 TableTempMax       = a_TableTemp(ntmax)
   692:                 TableTempIncrement = ( TableTempMax - TableTempMin ) / ( ntmax - 1 )
   693:             
   694:             
   695: +------>        do k = ks, ke
   696: |+----->          do j = js, je
   697: ||+---->            do i = is, ie
   698: |||         
   699: |||                   if ( ( xyz_Temp(i,j,k) < a_TableTemp(1)     ) .or. &
   700: |||                     &  ( xyz_Temp(i,j,k) > a_TableTemp(ntmax) ) ) then
   701: |||                     call MessageNotify( 'E', module_name, &
   702: |||                       & 'Temperature is not appropriate, Temp(%d,%d,%d) = %f.', &
   703: |||                       & i = (/i, j, k/), d = (/xyz_Temp(i,j,k)/) )
   704: |||                   end if
   705: |||         
   706: |||                   xyz_TempIndex(i,j,k) = &
   707: |||                     & int( ( xyz_Temp(i,j,k) - TableTempMin ) / TableTempIncrement ) + 2
   708: |||         
   709: |||                   if ( xyz_TempIndex(i,j,k) == 1 ) then
   710: |||                      xyz_TempIndex(i,j,k) = 2
   711: |||                   else if ( xyz_TempIndex(i,j,k) >= ntmax ) then
   712: |||                      xyz_TempIndex(i,j,k) = ntmax - 1
   713: |||                   end if
   714: |||         
   715: |||         !!$          xyz_TempIndex(i,j,k) = ntmax-1
   716: |||         !!$          search_index: do m = 2, ntmax-1
   717: |||         !!$            if ( a_TableTemp(m) >= xyz_Temp(i,j,k) ) then
   718: |||         !!$              xyz_TempIndex(i,j,k) = m
   719: |||         !!$              exit search_index
   720: |||         !!$            end if
   721: |||         !!$          end do search_index
   722: |||         
   723: ||+----             end do
   724: |+-----           end do
   725: +------         end do
   726:             
   727:             
   728:                 local_flag_DPFDT = .false.
   729:                 if ( present( flag_DPFDT ) ) then
   730:                   if ( flag_DPFDT ) then
   731:                     local_flag_DPFDT = .true.
   732:                   end if
   733:                 end if
   734:             
   735:                 if ( .not. local_flag_DPFDT ) then
   736: W------>          do k = ks, ke
   737: |*----->            do j = js, je
   738: ||*---->              do i = is, ie
   739: |||                     m = xyz_TempIndex(i,j,k)
   740: |||         
   741: |||         !!$            xyz_IntegPF(i,j,k) = &
   742: |||         !!$              &   ( aa_TableIPF( m, iband ) - aa_TableIPF( m-1, iband ) ) &
   743: |||         !!$              & / ( a_TableTemp( m )        - a_TableTemp( m-1 )        ) &
   744: |||         !!$              & * ( xyz_Temp(i,j,k)         - a_TableTemp( m-1 )        ) &
   745: |||         !!$              & +   aa_TableIPF( m-1, iband )
   746: |||         
   747: |||     A               xyz_IntegPF(i,j,k) = &
   748: |||                       &   a_TableIPF(m-1)                                  &
   749: |||                       &   * ( xyz_Temp   (i,j,k) - a_TableTemp( m   ) )    &
   750: |||                       &   * ( xyz_Temp   (i,j,k) - a_TableTemp( m+1 ) )    &
   751: |||                       & / ( ( a_TableTemp( m-1 ) - a_TableTemp( m   ) )    &
   752: |||                       &   * ( a_TableTemp( m-1 ) - a_TableTemp( m+1 ) ) )  &
   753: |||                       & + a_TableIPF(m  )                                  &
   754: |||                       &   * ( xyz_Temp   (i,j,k) - a_TableTemp( m-1 ) )    &
   755: |||                       &   * ( xyz_Temp   (i,j,k) - a_TableTemp( m+1 ) )    &
   756: |||                       & / ( ( a_TableTemp( m   ) - a_TableTemp( m-1 ) )    &
   757: |||                       &   * ( a_TableTemp( m   ) - a_TableTemp( m+1 ) ) )  &
   758: |||                       & + a_TableIPF(m+1)                                  &
   759: |||                       &   * ( xyz_Temp   (i,j,k) - a_TableTemp( m-1 ) )    &
   760: |||                       &   * ( xyz_Temp   (i,j,k) - a_TableTemp( m   ) )    &
   761: |||                       & / ( ( a_TableTemp( m+1 ) - a_TableTemp( m-1 ) )    &
   762: |||                       &   * ( a_TableTemp( m+1 ) - a_TableTemp( m   ) ) )
   763: ||*----               end do
   764: |*-----             end do
   765: W------           end do
   766:                 else
   767: W------>          do k = ks, ke
   768: |*----->            do j = js, je
   769: ||*---->              do i = is, ie
   770: |||                     m = xyz_TempIndex(i,j,k)
   771: |||         
   772: |||         !!$            xyz_IntegPF(i,j,k) = &
   773: |||         !!$              &   ( aa_TableIDPFDT( m, iband ) - aa_TableIDPFDT( m-1, iband ) ) &
   774: |||         !!$              & / ( a_TableTemp   ( m )        - a_TableTemp   ( m-1 )        ) &
   775: |||         !!$              & * ( xyz_Temp(i,j,k)         - a_TableTemp( m-1 )        ) &
   776: |||         !!$              & +   aa_TableIPF( m-1, iband )
   777: |||         
   778: |||     A               xyz_IntegPF(i,j,k) = &
   779: |||                       &   a_TableIPF(m-1)                                  &
   780: |||                       &   * ( xyz_Temp   (i,j,k) - a_TableTemp( m   ) )    &
   781: |||                       &   * ( xyz_Temp   (i,j,k) - a_TableTemp( m+1 ) )    &
   782: |||                       & / ( ( a_TableTemp( m-1 ) - a_TableTemp( m   ) )    &
   783: |||                       &   * ( a_TableTemp( m-1 ) - a_TableTemp( m+1 ) ) )  &
   784: |||                       & + a_TableIPF(m  )                                  &
   785: |||                       &   * ( xyz_Temp   (i,j,k) - a_TableTemp( m-1 ) )    &
   786: |||                       &   * ( xyz_Temp   (i,j,k) - a_TableTemp( m+1 ) )    &
   787: |||                       & / ( ( a_TableTemp( m   ) - a_TableTemp( m-1 ) )    &
   788: |||                       &   * ( a_TableTemp( m   ) - a_TableTemp( m+1 ) ) )  &
   789: |||                       & + a_TableIPF(m+1)                                  &
   790: |||                       &   * ( xyz_Temp   (i,j,k) - a_TableTemp( m-1 ) )    &
   791: |||                       &   * ( xyz_Temp   (i,j,k) - a_TableTemp( m   ) )    &
   792: |||                       & / ( ( a_TableTemp( m+1 ) - a_TableTemp( m-1 ) )    &
   793: |||                       &   * ( a_TableTemp( m+1 ) - a_TableTemp( m   ) ) )
   794: ||*----               end do
   795: |*-----             end do
   796: W------           end do
   797:                 end if
   798:             
   799:             
   800:               end subroutine CalcIntegratedPFWithTable3D
   801:             
   802:               !--------------------------------------------------------------------------------------
   803:             
   804:             end module planck_func
