Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:39:01 2016
FILE NAME: rad_15m_NLTE.f90
PROGRAM NAME: rad_15m_nlte
DIAGNOSTIC LIST

  LINE  LEVEL( NO.): DIAGNOSTIC MESSAGE

   259  opt  (1593): Loop nest collapsed into one loop.
   259  vec  (   4): Vectorized array expression.
   259  vec  (  29): ADB is used for array.: xyz_virtemp
   259  vec  (  29): ADB is used for array.: xyz_press
   273  vec  (   1): Vectorized loop.
   273  vec  (  29): ADB is used for array.: xyz_press
   274  opt  (1084): Branch out of the loop inhibits optimization.
   274  vec  (  26): Macro operation Search.
   327  vec  (   1): Vectorized loop.
   327  vec  (  29): ADB is used for array.: a_table15mnltesn
   328  opt  (1084): Branch out of the loop inhibits optimization.
   328  vec  (  26): Macro operation Search.
   337  vec  (   1): Vectorized loop.
   337  vec  (  29): ADB is used for array.: a_table15mnltesn
   338  opt  (1084): Branch out of the loop inhibits optimization.
   338  vec  (  26): Macro operation Search.
   417  opt  (1593): Loop nest collapsed into one loop.
   417  vec  (   4): Vectorized array expression.
   417  vec  (  29): ADB is used for array.: xyz_dtempdt
   417  vec  (  29): ADB is used for array.: xyz_dtempdt15mnlte
   417  vec  (  29): ADB is used for array.: xyz_weight
   455  vec  (   1): Vectorized loop.
   455  vec  (  29): ADB is used for array.: xyz_press
   456  opt  (1084): Branch out of the loop inhibits optimization.
   456  vec  (  26): Macro operation Search.
   497  opt  (1593): Loop nest collapsed into one loop.
   497  vec  (   1): Vectorized loop.
   497  vec  (  29): ADB is used for array.: xyz_weight
   497  vec  (  29): ADB is used for array.: xyz_press
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:39:01 2016
FILE NAME: rad_15m_NLTE.f90
PROGRAM NAME: rad_15m_nlte
TRANSFORMATION LIST

  LINE                   FORTRAN STATEMENT

     1  != (火星大気向け) Non-LTE 放射モデル
     2  !
     3  != Non-NLTE radiation model (for the Mars' atmosphere)
     4  !
     5  ! Authors::   Yoshiyuki O. Takahashi
     6  ! Version::   $Id: rad_15m_NLTE.f90,v 1.1 2012/11/15 03:30:10 yot Exp $
     7  ! Tag Name::  $Name:  $
     8  ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9  ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10  !
    11  module rad_15m_NLTE
    12    !
    13    != (火星大気向け) Non-LTE 放射モデル
    14    !
    15    != Non-NLTE radiation model (for the Mars' atmosphere)
    16    !
    17    ! <b>Note that Japanese and English are described in parallel.</b>
    18    !
    19    ! (火星大気向け) Non-LTE 放射モデル
    20    !
    21    ! Non-NLTE radiation model (for the Mars' atmosphere)
    22    !
    23    !== References
    24    !
    25    ! See Takahashi et al. (2003) for reference
    26    !
    27    !== Procedures List
    28    !
    29  !!$  ! RadiationFluxDennouAGCM :: 放射フラックスの計算
    30  !!$  ! RadiationDTempDt        :: 放射フラックスによる温度変化の計算
    31  !!$  ! RadiationFluxOutput     :: 放射フラックスの出力
    32  !!$  ! RadiationFinalize       :: 終了処理 (モジュール内部の変数の割り付け解除)
    33  !!$  ! ------------            :: ------------
    34  !!$  ! RadiationFluxDennouAGCM :: Calculate radiation flux
    35  !!$  ! RadiationDTempDt        :: Calculate temperature tendency with radiation flux
    36  !!$  ! RadiationFluxOutput     :: Output radiation fluxes
    37  !!$  ! RadiationFinalize       :: Termination (deallocate variables in this module)
    38    !
    39    !== NAMELIST
    40    !
    41  !!$  ! NAMELIST#rad_15m_NLTE_nml
    42    !
    43  
    44    ! モジュール引用 ; USE statements
    45    !
    46  
    47    ! 種別型パラメタ
    48    ! Kind type parameter
    49    !
    50    use dc_types, only: DP, &      ! 倍精度実数型. Double precision.
    51      &                 STRING     ! 文字列.       Strings.
    52  
    53    ! メッセージ出力
    54    ! Message output
    55    !
    56    use dc_message, only: MessageNotify
    57  
    58    ! 格子点設定
    59    ! Grid points settings
    60    !
    61    use gridset, only: imax, & ! 経度格子点数.
    62                               ! Number of grid points in longitude
    63      &                jmax, & ! 緯度格子点数.
    64                               ! Number of grid points in latitude
    65      &                kmax    ! 鉛直層数.
    66                               ! Number of vertical level
    67  
    68    ! 宣言文 ; Declaration statements
    69    !
    70    implicit none
    71    private
    72  
    73    ! 公開手続き
    74    ! Public procedure
    75    !
    76  !!$  public :: rad15mNLTE
    77    public :: rad15mNLTEMergeHR
    78    public :: rad15mNLTEInit
    79  
    80  !!$  public :: rad15mNLTECalckMin
    81  !!$  public :: rad15mNLTECalcWeight
    82  
    83    ! 公開変数
    84    ! Public variables
    85    !
    86    logical, save, public:: rad_15m_NLTE_inited = .false.
    87                                ! 初期設定フラグ.
    88                                ! Initialization flag
    89  
    90    ! 非公開変数
    91    ! Private variables
    92    !
    93  
    94    ! nl15fn               : maximum number of factors for 15 micron Non-LTE
    95    !                      : radiative cooling rate calculation
    96    ! nl15sn               : "reduced" optical depth for 15 micron Non-LTE
    97    !                      : radiative cooling rate calculation
    98    ! nl15fa               : parameter for 15 micron Non-LTE
    99    !                      : radiative cooling rate calculation
   100  
   101    integer , parameter :: nTable15mNLTE = 70
   102    real(DP)            :: a_Table15mNLTEsn( nTable15mNLTE )
   103                                          ! sigma N (non dimension)
   104    real(DP)            :: a_Table15mNLTEfa( nTable15mNLTE )
   105                                          ! E(tau)
   106  
   107  
   108    data a_Table15mNLTEsn &
   109      & / &
   110      & 0.1000e-6, 0.1000e-1, 0.1389e-1, 0.1931e-1, 0.2683e-1, &
   111      & 0.3728e-1, 0.5179e-1, 0.7197e-1, 0.1000e0 , 0.1389e0 , &
   112      & 0.1931e0 , 0.2683e0 , 0.3728e0 , 0.5179e0 , 0.7197e0 , &
   113      & 0.1000e1 , 0.1389e1 , 0.1931e1 , 0.2683e1 , 0.3728e1 , &
   114      & 0.5179e1 , 0.7197e1 , 0.1000e2 , 0.1389e2 , 0.1931e2 , &
   115      & 0.2683e2 , 0.3728e2 , 0.5179e2 , 0.7197e2 , 0.1000e3 , &
   116      & 0.1389e3 , 0.1931e3 , 0.2683e3 , 0.3728e3 , 0.5179e3 , &
   117      & 0.7197e3 , 0.1000e4 , 0.1389e4 , 0.1931e4 , 0.2683e4 , &
   118      & 0.3728e4 , 0.5179e4 , 0.7197e4 , 0.1000e5 , 0.1389e5 , &
   119      & 0.1931e5 , 0.2683e5 , 0.3728e5 , 0.5179e5 , 0.7197e5 , &
   120      & 0.1000e6 , 0.1389e6 , 0.1931e6 , 0.2683e6 , 0.3728e6 , &
   121      & 0.5179e6 , 0.7197e6 , 0.1000e7 , 0.1389e7 , 0.1931e7 , &
   122      & 0.2683e7 , 0.3728e7 , 0.5179e7 , 0.7197e7 , 0.1000e8 , &
   123      & 0.1389e8 , 0.1931e8 , 0.2683e8 , 0.3728e8 , 0.5179e8   &
   124      & /
   125  
   126  
   127    data a_Table15mNLTEfa &
   128      & / &
   129      & 0.5000e0 , 0.4993e0 , 0.4991e0 , 0.4987e0 , 0.4982e0 , &
   130      & 0.4975e0 , 0.4966e0 , 0.4953e0 , 0.4936e0 , 0.4913e0 , &
   131      & 0.4883e0 , 0.4844e0 , 0.4796e0 , 0.4734e0 , 0.4656e0 , &
   132      & 0.4557e0 , 0.4432e0 , 0.4279e0 , 0.4090e0 , 0.3864e0 , &
   133      & 0.3595e0 , 0.3284e0 , 0.2933e0 , 0.2550e0 , 0.2149e0 , &
   134      & 0.1750e0 , 0.1373e0 , 0.1041e0 , 0.7679e-1, 0.5566e-1, &
   135      & 0.4009e-1, 0.2892e-1, 0.2096e-1, 0.1530e-1, 0.1127e-1, &
   136      & 0.8387e-2, 0.6329e-2, 0.4851e-2, 0.3783e-2, 0.3005e-2, &
   137      & 0.2431e-2, 0.1999e-2, 0.1671e-2, 0.1415e-2, 0.1211e-2, &
   138      & 0.1044e-2, 0.9018e-3, 0.7798e-3, 0.6735e-3, 0.5801e-3, &
   139      & 0.4982e-3, 0.4267e-3, 0.3645e-3, 0.3108e-3, 0.2646e-3, &
   140      & 0.2249e-3, 0.1911e-3, 0.1622e-3, 0.1376e-3, 0.1167e-3, &
   141      & 0.9891e-4, 0.8382e-4, 0.7101e-4, 0.6013e-4, 0.5091e-4, &
   142      & 0.4307e-4, 0.3643e-4, 0.3079e-4, 0.2600e-4, 0.2194e-4  &
   143      & /
   144  
   145  
   146    character(*), parameter:: module_name = 'rad_15m_NLTE'
   147                                ! モジュールの名称.
   148                                ! Module name
   149    character(*), parameter:: version = &
   150      & '$Name:  $' // &
   151      & '$Id: rad_15m_NLTE.f90,v 1.1 2012/11/15 03:30:10 yot Exp $'
   152                                ! モジュールのバージョン
   153                                ! Module version
   154  
   155  contains
   156  
   157    !**************************************************************************
   158    !     subroutine nlteradiation
   159    !     calculate Non-LTE radiative cooling rate
   160    !**************************************************************************
   161    ! pi
   162    ! amu      : atomic mass unit
   163    ! day      : one solar day (sec)
   164    ! grav     : gravitational acceleration
   165    ! im       : number of the vertical layers
   166    ! jm       : number of the meridional grids
   167    ! km       : number of the zonal grids
   168    ! ntemp    : neutral temperature (K)
   169    ! press    : pressure at midpoint of layer (Pa)
   170    ! cp       : specific heat at constant pressure
   171    ! q15m1    : infrared heating rate in 15 micron band below about 80 km
   172    ! rho      : mass density at midpoint of layers
   173    !**************************************************************************
   174  
   175    subroutine rad15mNLTE(                &
   176      & xyz_Press, xyz_Temp, xyz_VirTemp, &
   177      & xyz_DTempDt15mNLTE                &
   178      & )
   179  
   180      ! 物理定数設定
   181      ! Physical constants settings
   182      !
   183      use constants, only: &
   184        & Grav, &
   185                                ! $ g $ [m s-2].
   186                                ! 重力加速度.
   187                                ! Gravitational acceleration
   188        & CpDry, &
   189                                ! $ C_p $ [J kg-1 K-1].
   190                                ! 乾燥大気の定圧比熱.
   191                                ! Specific heat of air at constant pressure
   192        & GasRDry
   193                                ! $ R $ [J kg-1 K-1].
   194                                ! 乾燥大気の気体定数.
   195                                ! Gas constant of air
   196  
   197      real(DP), intent(in ) :: xyz_Press   (0:imax-1, 1:jmax, 1:kmax)
   198      real(DP), intent(in ) :: xyz_Temp    (0:imax-1, 1:jmax, 1:kmax)
   199      real(DP), intent(in ) :: xyz_VirTemp (0:imax-1, 1:jmax, 1:kmax)
   200      real(DP), intent(out) :: xyz_DTempDt15mNLTE(0:imax-1, 1:jmax, 1:kmax)
   201  
   202  
   203      ! Local variables
   204      !
   205      real(DP) :: xyz_Rho(0:imax-1, 1:jmax, 1:kmax)
   206      integer  :: i
   207      integer  :: j
   208      integer  :: k
   209      integer  :: l
   210  
   211      real(DP) :: tau
   212      real(DP) :: e1, e2
   213      real(DP) :: ltau
   214      real(DP) :: ramda
   215      real(DP), parameter :: a10 = 2.44d0
   216      real(DP), parameter :: g10 = 2.0d0
   217      real(DP) :: kco2, ko
   218      real(DP) :: co2nd, ond
   219      real(DP) :: tmpfac
   220      real(DP) :: NLTECR
   221  !!$    real(DP) :: xyz_Weight(0:imax-1, 1:jmax, 1:kmax)
   222  
   223  
   224      ! Variables for Reference Pressure
   225      !
   226      real(DP) :: p0, t0, ond0, f0
   227  
   228      ! kmin     : maximum index used for calculation of
   229      !          : atmospheric radiative cooling rate
   230  !!$    integer  :: xy_kMin(0:imax-1, 1:jmax)
   231  
   232      real(DP), parameter :: AMU = 1.6605655d-27
   233  
   234  
   235      ! 初期化
   236      ! Initialization
   237      !
   238      if ( .not. rad_15m_NLTE_inited ) then
   239        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   240      end if
   241  
   242  !!$    call calcimin(im,iup,jm,km,press,imin)
   243  !!$    xy_kMin = kmax
   244  
   245  !!$    call rad15mNLTECalcWeight( &
   246  !!$      & xyz_Press,                   &
   247  !!$!      &  xy_kMin,                    &
   248  !!$      & xyz_Weight                   &
   249  !!$      & )
   250  !!$    xyz_Weight = 1.0_DP
   251  
   252      ! Set Variables for Reference Pressure
   253      !
   254      p0 = 1.2d-3 * 1.0d-6 * 1.0d5
   255      f0 = 0.5d0 * 1.0d-2
   256  !            f0=1.0d0*1.0d-2
   257  
   258  
   259      xyz_Rho = xyz_Press / ( GasRDry * xyz_VirTemp )
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t415 = 1, kmax*jmax*imax                                       
     .           xyz_rho(t415-1,1,1) = xyz_press(t415-1,1,1)/(gasrdry*          
     .       1      xyz_virtemp(t415-1,1,1))                                    
     .        enddo                                                             
   260  
   261      do j = 1, jmax
   262        do i = 0, imax-1
   263  
   264          ! Number Density is in CGS Unit
   265          !
   266          if( p0 <= xyz_Press(i,j,kmax) ) then
   267            t0 = xyz_Temp(i,j,kmax)
   268            ond0 = xyz_Rho(i,j,kmax) / ( 44.0d0 * AMU ) &
   269              * ( p0 / xyz_Press(i,j,kmax) ) &
   270              * f0 &
   271              * 1.0d-6
   272          else if( p0 <= xyz_Press(i,j,1) ) then
   273            search_p : do l = kmax-1, 2, -1
   274              if( p0 <= xyz_Press(i,j,l) ) exit search_p
   275            end do search_p
   276            t0 = ( xyz_Temp(i,j,l+1) - xyz_Temp(i,j,l) )        &
   277              &  / log( xyz_Press(i,j,l+1) / xyz_Press(i,j,l) ) &
   278              &  * log( p0 / xyz_Press(i,j,l) )                 &
   279              &  + xyz_Temp(i,j,l)
   280            ond0 =                                   &
   281              & xyz_Temp(i,j,l) / t0                 &
   282              &  * xyz_Rho(i,j,l) / ( 44.0d0 * AMU ) &
   283              &  * ( p0 / xyz_Press(i,j,l) )         &
   284              &  * f0                                &
   285              &  * 1.0d-6
   286          else
   287            write( 6, * ) 'Reference pressure or pressure is inappropriate.'
   288            write( 6, * ) 'Unexpected Error'
   289            write( 6, * ) 'Stop'
   290            stop
   291          endif
   292  
   293          do k = 1, kmax
   294            ! cgs unit
   295            co2nd = xyz_Rho(i,j,k) / ( 44.0d0 * AMU ) &
   296              & * 1.0d-6
   297  
   298  !               kco2=1.0d-15
   299            ! from Lunt et al., 1985
   300            if( xyz_Temp(i,j,k) < 175.0_DP ) then
   301              kco2 = 4.2d-12 * exp( -2988.0d0 /175.0d0 + 303930.0d0 / ( 175.0d0 * 175.0d0 ) )
   302            else
   303              kco2 = 4.2d-12 * exp( -2988.0d0 / xyz_Temp(i,j,k) + 303930.0d0 / ( xyz_Temp(i,j,k) * xyz_Temp(i,j,k) ) )
   304            endif
   305  
   306            ! ond0 has already been set in cgs unit
   307            ond = t0 / xyz_Temp(i,j,k) &
   308              & * ond0                 &
   309              & * ( ( xyz_Press(i,j,k) /p0 )**(16.0d0/44.0d0) )
   310  
   311  !               ko=1.5d-11*dexp(-800.0d0/ntemp(i,j,k))
   312            ! from Lopez-Valvelde and Lopez-Puertas, 1994,
   313            ! Bougher et al., 1994
   314            ko = 3.0d-12
   315            tau = 6.4d-15 * xyz_Press(i,j,k) &
   316              & / ( 44.0d0 * AMU * Grav )    &
   317              & * 1.0d-4
   318  
   319  
   320  !!$  integer , parameter :: nTable15mNLTE = 70
   321  !!$  real(DP),           :: a_Table15mNLTEsn( nTable15mNLTE )
   322  !!$                                        ! sigma N (non dimension)
   323  !!$  real(DP),           :: a_Table15mNLTEfa( nTable15mNLTE )
   324  !!$                                        ! E(tau)
   325  
   326  !----------------------
   327            search_sn_1 : do l = 2, nTable15mNLTE-1
   328              if ( tau < a_Table15mNLTEsn(l) ) exit search_sn_1
   329            end do search_sn_1
   330            e1 =   ( a_Table15mNLTEfa(l) - a_Table15mNLTEfa(l-1) ) &
   331              &  / ( a_Table15mNLTEsn(l) - a_Table15mNLTEsn(l-1) ) &
   332              &  * ( tau - a_Table15mNLTEsn(l-1) )                 &
   333              &  + a_Table15mNLTEfa(l-1)
   334            if ( e1 > 0.5d0 ) e1 = 0.5d0
   335            if ( e1 < 0.0d0 ) e1 = 0.0d0
   336  !----------------------
   337            search_sn_2 : do l = 2, nTable15mNLTE-1
   338              if ( ( tau / 2.0d0 ) <  a_Table15mNLTEsn(l) ) exit search_sn_2
   339            end do search_sn_2
   340            e2 =   ( a_Table15mNLTEfa(l) - a_Table15mNLTEfa(l-1) ) &
   341              &  / ( a_Table15mNLTEsn(l) - a_Table15mNLTEsn(l-1) ) &
   342              &  * ( ( tau / 2.0d0 ) - a_Table15mNLTEsn(l-1) )     &
   343              &  + a_Table15mNLTEfa(l-1)
   344            if ( e2 > 0.5d0 ) e2 = 0.5d0
   345            if ( e2 < 0.0d0 ) e2 = 0.0d0
   346  !----------------------
   347            ltau = e1 + e2
   348            ramda = a10 / ( a10 + kco2 * co2nd + ko * ond )
   349            tmpfac = 0.5d0 * ramda * ltau / ( 1.0d0 - ramda + 0.5d0 * ramda * ltau )
   350  
   351            NLTECR = 1.33d-13 * g10 * exp( -960.0d0 / xyz_Temp(i,j,k) ) * co2nd &
   352              & * ( kco2 * co2nd + ko * ond ) * tmpfac &
   353              & * 1.0d-1 &
   354              & / ( xyz_Rho(i,j,k) * CpDry )
   355  
   356  !!$          xyz_DTempDt15mNLTE(i,j,k) = &
   357  !!$            & ( 1.0d0 - xyz_Weight(i,j,k) ) * ( -NLTECR )
   358            xyz_DTempDt15mNLTE(i,j,k) = - NLTECR
   359          end do
   360  
   361        end do
   362      end do
   363  
   364    end subroutine rad15mNLTE
   365  
   366    !----------------------------------------------------------------------------
   367  
   368    subroutine rad15mNLTEMergeHR(         &
   369      & xyz_Press, xyz_Temp, xyz_VirTemp, &
   370      & xyz_DTempDt                       &
   371      & )
   372  
   373      ! ヒストリデータ出力
   374      ! History data output
   375      !
   376      use gtool_historyauto, only: HistoryAutoPut
   377  
   378      ! 時刻管理
   379      ! Time control
   380      !
   381      use timeset, only: &
   382        & TimeN                 ! ステップ $ t $ の時刻.
   383                                ! Time of step $ t $.
   384  
   385      real(DP), intent(in   ) :: xyz_Press  (0:imax-1, 1:jmax, 1:kmax)
   386      real(DP), intent(in   ) :: xyz_Temp   (0:imax-1, 1:jmax, 1:kmax)
   387      real(DP), intent(in   ) :: xyz_VirTemp(0:imax-1, 1:jmax, 1:kmax)
   388      real(DP), intent(inout) :: xyz_DTempDt(0:imax-1, 1:jmax, 1:kmax)
   389  
   390  
   391      ! Local variables
   392      !
   393      real(DP) :: xyz_Weight        (0:imax-1, 1:jmax, 1:kmax)
   394      real(DP) :: xyz_DTempDt15mNLTE(0:imax-1, 1:jmax, 1:kmax)
   395  
   396  
   397      ! 初期化
   398      ! Initialization
   399      !
   400      if ( .not. rad_15m_NLTE_inited ) then
   401        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   402      end if
   403  
   404  
   405      call rad15mNLTECalcWeight( &
   406        & xyz_Press,                   &
   407  !      &  xy_kMin,                    &
   408        & xyz_Weight                   &
   409        & )
   410  !!$    xyz_Weight = 1.0_DP
   411  
   412      call rad15mNLTE(                      &
   413        & xyz_Press, xyz_Temp, xyz_VirTemp, &
   414        & xyz_DTempDt15mNLTE                &
   415        & )
   416  
   417      xyz_DTempDt =                                              &
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t107 = 1, xyz_weight.DSC.U3*(xyz_weight.DSC.U2*                
     .       1   xyz_weight.DSC.U1 + xyz_weight.DSC.U2)                         
     .           xyz_dtempdt(t107-1,1,1) = xyz_weight(t107-1,1,1)*xyz_dtempdt(  
     .       1      t107-1,1,1) + (1.00000000000000e+000 - xyz_weight(t107-1,1,1
     .       2      ))*xyz_dtempdt15mnlte(t107-1,1,1)                           
     .        enddo                                                             
   418        &   xyz_Weight             * xyz_DTempDt                 &
   419        & + ( 1.0d0 - xyz_Weight ) * xyz_DTempDt15mNLTE
   420  
   421  
   422      call HistoryAutoPut( TimeN, 'DTempDt15mNLTE'   , xyz_DTempDt15mNLTE )
   423      call HistoryAutoPut( TimeN, 'DTempDtRadLMerged', xyz_DTempDt )
   424  
   425  
   426    end subroutine rad15mNLTEMergeHR
   427  
   428    !----------------------------------------------------------------------------
   429  
   430    subroutine rad15mNLTECalckMin( &
   431      & xyz_Press, &
   432      & xy_kMin    &
   433      & )
   434  
   435      real(DP), intent(in ) :: xyz_Press(0:imax-1, 1:jmax, 1:kmax)
   436      integer , intent(out) :: xy_kMin  (0:imax-1, 1:jmax)
   437  
   438      integer :: i
   439      integer :: j
   440      integer :: k
   441  
   442      ! 初期化
   443      ! Initialization
   444      !
   445      if ( .not. rad_15m_NLTE_inited ) then
   446        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   447      end if
   448  
   449      ! set minimum index used for calculation of
   450      ! atmospheric radiative cooling rate
   451  !    imin=im-25
   452  
   453      do j = 1, jmax
   454        do i = 0, imax-1
   455          find_kmin : do k = kmax, 1, -1
   456            if ( xyz_Press(i,j,k) > 1.0d-2 ) exit find_kmin
   457          end do find_kmin
   458          xy_kMin(i,j) = k
   459        end do
   460      end do
   461  
   462    end subroutine rad15mNLTECalckMin
   463  
   464    !----------------------------------------------------------------------------
   465  
   466    subroutine rad15mNLTECalcWeight( &
   467      & xyz_Press,                   &
   468  !!$    & xy_kMin,          &
   469      & xyz_Weight                   &
   470      & )
   471  
   472      ! 物理・数学定数設定
   473      ! Physical and mathematical constants settings
   474      !
   475      use constants0, only: &
   476        & PI                    ! $ \pi $ .
   477                                ! 円周率.  Circular constant
   478  
   479      real(DP), intent(in ) :: xyz_Press (0:imax-1, 1:jmax, 1:kmax)
   480  !!$    integer , intent(in ) :: xy_kMin   (0:imax-1, 1:jmax)
   481      real(DP), intent(out) :: xyz_Weight(0:imax-1, 1:jmax, 1:kmax)
   482  
   483  
   484      ! Local variables
   485      !
   486      integer :: i
   487      integer :: j
   488      integer :: k
   489  
   490      ! 初期化
   491      ! Initialization
   492      !
   493      if ( .not. rad_15m_NLTE_inited ) then
   494        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   495      end if
   496  
   497      do k = 1, kmax
   498        do j = 1, jmax
   499          do i = 0, imax-1
   500  
   501  !               weight(i,j,k)=(atan(2.0d0 &
   502  !                    *dlog(dsqrt(press(i,j,k)*press(i+1,j,k)) &
   503  !                    /dsqrt(press(imin+4,j,k)*press(imin+4+1,j,k)))) &
   504  !                    *1.2d0 &
   505  !                    +pi/2.0d0)/pi
   506  
   507            xyz_Weight(i,j,k) = &
   508              & ( atan( 2.0d0 * log( xyz_Press(i,j,k) / ( 1.0d-2 * exp( 2.0d0 ) ) ) ) &
   509              &   * 1.2d0 + Pi / 2.0d0 ) &
   510              & / Pi
   511            xyz_Weight(i,j,k) = max( xyz_Weight(i,j,k), 0.0d0 )
   512            xyz_Weight(i,j,k) = min( xyz_Weight(i,j,k), 1.0d0 )
   513          end do
   514        end do
   515      end do
     .        d2 = 1.D0/(1.00000000000000e-002*dexp(2.00000000000000e+000))     
     .        d3 = 1.D0/3.14159265358979e+000                                   
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do k = 1, kmax*jmax*imax                                          
     .           xyz_weight1 = (datan(2.00000000000000e+000*dlog(xyz_press(k-1,1
     .       1      ,1)*d2))*1.20000000000000e+000+1.57079632679489e+000)*d3    
     .           xyz_weight1 = max(xyz_weight1,0.0000000000000000e+000)         
     .           xyz_weight(k-1,1,1) = min(xyz_weight1,1.00000000000000e+000)   
     .        enddo                                                             
   516  
   517  
   518    end subroutine rad15mNLTECalcWeight
   519  
   520    !----------------------------------------------------------------------------
   521  
   522    subroutine Rad15mNLTEInit
   523  
   524      ! ファイル入出力補助
   525      ! File I/O support
   526      !
   527  !!$    use dc_iounit, only: FileOpen
   528  
   529      ! NAMELIST ファイル入力に関するユーティリティ
   530      ! Utilities for NAMELIST file input
   531      !
   532  !!$    use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid
   533  
   534      ! ヒストリデータ出力
   535      ! History data output
   536      !
   537      use gtool_historyauto, only: HistoryAutoAddVariable
   538  
   539      ! 座標データ設定
   540      ! Axes data settings
   541      !
   542      use axesset, only: &
   543        & AxnameX, &
   544        & AxnameY, &
   545        & AxnameZ, &
   546        & AxnameR, &
   547        & AxnameT
   548  
   549      ! 宣言文 ; Declaration statements
   550      !
   551  
   552  !!$    integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号.
   553  !!$                              ! Unit number for NAMELIST file open
   554  !!$    integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT.
   555  !!$                              ! IOSTAT of NAMELIST read
   556  
   557      ! NAMELIST 変数群
   558      ! NAMELIST group name
   559      !
   560  !!$    namelist /rad_15m_NLTE_nml/ &
   561  !!$      & SolarConst
   562            !
   563            ! デフォルト値については初期化手続 "rad_15m_NLTE#Rad15mNLTEInit"
   564            ! のソースコードを参照のこと.
   565            !
   566            ! Refer to source codes in the initialization procedure
   567            ! "rad_15m_NLTE#Rad15mNLTEInit" for the default values.
   568            !
   569  
   570      if ( rad_15m_NLTE_inited ) return
   571  
   572      ! デフォルト値の設定
   573      ! Default values settings
   574      !
   575  !!$    SolarConst      = 1380.0_DP / 1.52_DP**2
   576  
   577      ! NAMELIST の読み込み
   578      ! NAMELIST is input
   579      !
   580  !!$    if ( trim(namelist_filename) /= '' ) then
   581  !!$      call FileOpen( unit_nml, &          ! (out)
   582  !!$        & namelist_filename, mode = 'r' ) ! (in)
   583  !!$
   584  !!$      rewind( unit_nml )
   585  !!$      read( unit_nml,                     & ! (in)
   586  !!$        & nml = rad_15m_NLTE_nml,         & ! (out)
   587  !!$        & iostat = iostat_nml )             ! (out)
   588  !!$      close( unit_nml )
   589  !!$
   590  !!$      call NmlutilMsg( iostat_nml, module_name ) ! (in)
   591  !!$    end if
   592  
   593  
   594      ! Initialization of modules used in this module
   595      !
   596  
   597  
   598      ! ヒストリデータ出力のためのへの変数登録
   599      ! Register of variables for history data output
   600      !
   601      call HistoryAutoAddVariable( 'DTempDt15mNLTE',     &
   602        & (/ AxnameX, AxnameY, AxnameZ, AxnameT /),      &
   603        & 'radiative calculation by NLTE process at 15 micron meter', 'K s-1' )
   604      call HistoryAutoAddVariable( 'DTempDtRadLMerged',  &
   605        & (/ AxnameX, AxnameY, AxnameZ, AxnameT /),      &
   606        & 'radiative calculation in long wave merged with NLTE heating rate', 'K s-1' )
   607  
   608      ! 印字 ; Print
   609      !
   610      call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   611  !!$    call MessageNotify( 'M', module_name, 'SolarConst = %f', d = (/ SolarConst /) )
   612      call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   613  
   614      rad_15m_NLTE_inited = .true.
   615  
   616    end subroutine Rad15mNLTEInit
   617  
   618  !!$    !**************************************************************************
   619  !!$    subroutine readnirfac(fn,nirfn,nirfp,nirfac)
   620  !!$
   621  !!$      use vtype
   622  !!$
   623  !!$      implicit none
   624  !!$
   625  !!$      character(len=128) :: fn
   626  !!$      integer(i4b) :: nirfn
   627  !!$      real(dp) :: nirfp(nirfn)
   628  !!$      real(dp) :: nirfac(nirfn)
   629  !!$
   630  !!$
   631  !!$      ! Local variables
   632  !!$      !
   633  !!$      integer(i4b) :: i
   634  !!$      character(len=128) :: tmpl
   635  !!$
   636  !!$
   637  !!$      open(70,file='./'//fn,status='unknown')
   638  !!$      read(70,'(a128)') tmpl
   639  !!$      do i=1,nirfn
   640  !!$         read(70,*) nirfp(i),nirfac(i)
   641  !!$         nirfp(i)=nirfp(i)*1.0d-6*1.0d5
   642  !!$      enddo
   643  !!$      close(70)
   644  !!$
   645  !!$      return
   646  !!$    end subroutine readnirfac
   647  !!$
   648  !!$    !**************************************************************************
   649  !!$    !     subroutine nirhrcorrect
   650  !!$    !     correct near infrared heating rate
   651  !!$    !**************************************************************************
   652  !!$    ! im       : number of the vertical layers
   653  !!$    ! jm       : number of the meridional grids
   654  !!$    ! km       : number of the zonal grids
   655  !!$    ! press    : pressure at midpoint of layer (Pa)
   656  !!$    ! nirfn    : maximum number of near infrared heating rate
   657  !!$    !          : factor
   658  !!$    ! nirfp    : pressure for table of near infrared heating rate
   659  !!$    !          : correct factor
   660  !!$    ! nirfa    : near infrared heating rate correct factor
   661  !!$    ! qnir     : near infrared heating rate
   662  !!$    ! corsw    : artificial correction switch,
   663  !!$    !          : if sw is equal to 1 correction is down
   664  !!$    !**************************************************************************
   665  !!$
   666  !!$    subroutine nirhrcorrect(im,jm,km,press,nirfn,nirfp,nirfac,qnir, &
   667  !!$         corsw)
   668  !!$
   669  !!$      use vtype
   670  !!$
   671  !!$      implicit none
   672  !!$
   673  !!$      integer(i4b) :: im,jm,km
   674  !!$      real(dp) :: press(im+1,jm,km)
   675  !!$      integer(i4b) :: nirfn
   676  !!$      real(dp) :: nirfp(nirfn)
   677  !!$      real(dp) :: nirfac(nirfn)
   678  !!$      real(dp) :: qnir(im,jm,km)
   679  !!$      integer(i4b) :: corsw
   680  !!$
   681  !!$
   682  !!$      ! Local variables
   683  !!$      !
   684  !!$      integer(i4b) :: i,j,k,l
   685  !!$      real(dp) :: tmpp
   686  !!$      real(dp) :: tmpfac
   687  !!$
   688  !!$
   689  !!$      do k=1,km
   690  !!$         do j=1,jm
   691  !!$            do i=1,im
   692  !!$               tmpp=dsqrt(press(i,j,k)*press(i+1,j,k))
   693  !!$               if(tmpp.lt.nirfp(nirfn)) then
   694  !!$
   695  !!$!                  qnir(i,j,k)=qnir(i,j,k) &
   696  !!$!                       /(nirfac(nirfn)*nirfp(nirfn)/tmpp)
   697  !!$
   698  !!$                  tmpfac=nirfac(nirfn) &
   699  !!$                       *(nirfp(nirfn)/tmpp)*(nirfp(nirfn)/tmpp) &
   700  !!$                       *(nirfp(nirfn)/tmpp)*(nirfp(nirfn)/tmpp)
   701  !!$                  tmpfac=1.0d0/tmpfac
   702  !!$               else if(tmpp.le.nirfp(1)) then
   703  !!$                  do l=2,nirfn
   704  !!$                     if(tmpp.gt.nirfp(l)) go to 100
   705  !!$                  enddo
   706  !!$100               continue
   707  !!$                  tmpfac=(nirfac(l)-nirfac(l-1))/(nirfp(l)-nirfp(l-1)) &
   708  !!$                       *(tmpp-nirfp(l-1))+nirfac(l-1)
   709  !!$                  tmpfac=1.0d0/tmpfac
   710  !!$                  if(tmpfac.gt.1.0d0) then
   711  !!$                     write(*,*) 'Factor is greater than 1'
   712  !!$                     write(*,*) 'Stop'
   713  !!$                     stop
   714  !!$                  endif
   715  !!$               endif
   716  !!$
   717  !!$               ! This is artificial correction for 2.7 micron band
   718  !!$               !
   719  !!$               if((corsw.eq.1).and.(tmpp.lt.(1.2d-8*1.0d5))) then
   720  !!$!                  qnir(i,j,k)=qnir(i,j,k)*dsqrt(tmpp/(1.2d-8*1.0d5))
   721  !!$                  tmpfac=tmpfac*dsqrt(tmpp/(1.2d-8*1.0d5))
   722  !!$               endif
   723  !!$
   724  !!$               qnir(i,j,k)=qnir(i,j,k)*tmpfac
   725  !!$
   726  !!$            enddo
   727  !!$         enddo
   728  !!$      enddo
   729  !!$
   730  !!$      return
   731  !!$    end subroutine nirhrcorrect
   732  
   733  end module rad_15m_NLTE
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:39:01 2016
FILE NAME: rad_15m_NLTE.f90
PROGRAM NAME: rad_15m_nlte
FORMAT LIST

  LINE    LOOP      FORTRAN STATEMENT

     1:             != (火星大気向け) Non-LTE 放射モデル
     2:             !
     3:             != Non-NLTE radiation model (for the Mars' atmosphere)
     4:             !
     5:             ! Authors::   Yoshiyuki O. Takahashi
     6:             ! Version::   $Id: rad_15m_NLTE.f90,v 1.1 2012/11/15 03:30:10 yot Exp $
     7:             ! Tag Name::  $Name:  $
     8:             ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9:             ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10:             !
    11:             module rad_15m_NLTE
    12:               !
    13:               != (火星大気向け) Non-LTE 放射モデル
    14:               !
    15:               != Non-NLTE radiation model (for the Mars' atmosphere)
    16:               !
    17:               ! <b>Note that Japanese and English are described in parallel.</b>
    18:               !
    19:               ! (火星大気向け) Non-LTE 放射モデル
    20:               !
    21:               ! Non-NLTE radiation model (for the Mars' atmosphere)
    22:               !
    23:               !== References
    24:               !
    25:               ! See Takahashi et al. (2003) for reference
    26:               !
    27:               !== Procedures List
    28:               !
    29:             !!$  ! RadiationFluxDennouAGCM :: 放射フラックスの計算
    30:             !!$  ! RadiationDTempDt        :: 放射フラックスによる温度変化の計算
    31:             !!$  ! RadiationFluxOutput     :: 放射フラックスの出力
    32:             !!$  ! RadiationFinalize       :: 終了処理 (モジュール内部の変数の割り付け解除)
    33:             !!$  ! ------------            :: ------------
    34:             !!$  ! RadiationFluxDennouAGCM :: Calculate radiation flux
    35:             !!$  ! RadiationDTempDt        :: Calculate temperature tendency with radiation flux
    36:             !!$  ! RadiationFluxOutput     :: Output radiation fluxes
    37:             !!$  ! RadiationFinalize       :: Termination (deallocate variables in this module)
    38:               !
    39:               !== NAMELIST
    40:               !
    41:             !!$  ! NAMELIST#rad_15m_NLTE_nml
    42:               !
    43:             
    44:               ! モジュール引用 ; USE statements
    45:               !
    46:             
    47:               ! 種別型パラメタ
    48:               ! Kind type parameter
    49:               !
    50:               use dc_types, only: DP, &      ! 倍精度実数型. Double precision.
    51:                 &                 STRING     ! 文字列.       Strings.
    52:             
    53:               ! メッセージ出力
    54:               ! Message output
    55:               !
    56:               use dc_message, only: MessageNotify
    57:             
    58:               ! 格子点設定
    59:               ! Grid points settings
    60:               !
    61:               use gridset, only: imax, & ! 経度格子点数.
    62:                                          ! Number of grid points in longitude
    63:                 &                jmax, & ! 緯度格子点数.
    64:                                          ! Number of grid points in latitude
    65:                 &                kmax    ! 鉛直層数.
    66:                                          ! Number of vertical level
    67:             
    68:               ! 宣言文 ; Declaration statements
    69:               !
    70:               implicit none
    71:               private
    72:             
    73:               ! 公開手続き
    74:               ! Public procedure
    75:               !
    76:             !!$  public :: rad15mNLTE
    77:               public :: rad15mNLTEMergeHR
    78:               public :: rad15mNLTEInit
    79:             
    80:             !!$  public :: rad15mNLTECalckMin
    81:             !!$  public :: rad15mNLTECalcWeight
    82:             
    83:               ! 公開変数
    84:               ! Public variables
    85:               !
    86:               logical, save, public:: rad_15m_NLTE_inited = .false.
    87:                                           ! 初期設定フラグ.
    88:                                           ! Initialization flag
    89:             
    90:               ! 非公開変数
    91:               ! Private variables
    92:               !
    93:             
    94:               ! nl15fn               : maximum number of factors for 15 micron Non-LTE
    95:               !                      : radiative cooling rate calculation
    96:               ! nl15sn               : "reduced" optical depth for 15 micron Non-LTE
    97:               !                      : radiative cooling rate calculation
    98:               ! nl15fa               : parameter for 15 micron Non-LTE
    99:               !                      : radiative cooling rate calculation
   100:             
   101:               integer , parameter :: nTable15mNLTE = 70
   102:               real(DP)            :: a_Table15mNLTEsn( nTable15mNLTE )
   103:                                                     ! sigma N (non dimension)
   104:               real(DP)            :: a_Table15mNLTEfa( nTable15mNLTE )
   105:                                                     ! E(tau)
   106:             
   107:             
   108:               data a_Table15mNLTEsn &
   109:                 & / &
   110:                 & 0.1000e-6, 0.1000e-1, 0.1389e-1, 0.1931e-1, 0.2683e-1, &
   111:                 & 0.3728e-1, 0.5179e-1, 0.7197e-1, 0.1000e0 , 0.1389e0 , &
   112:                 & 0.1931e0 , 0.2683e0 , 0.3728e0 , 0.5179e0 , 0.7197e0 , &
   113:                 & 0.1000e1 , 0.1389e1 , 0.1931e1 , 0.2683e1 , 0.3728e1 , &
   114:                 & 0.5179e1 , 0.7197e1 , 0.1000e2 , 0.1389e2 , 0.1931e2 , &
   115:                 & 0.2683e2 , 0.3728e2 , 0.5179e2 , 0.7197e2 , 0.1000e3 , &
   116:                 & 0.1389e3 , 0.1931e3 , 0.2683e3 , 0.3728e3 , 0.5179e3 , &
   117:                 & 0.7197e3 , 0.1000e4 , 0.1389e4 , 0.1931e4 , 0.2683e4 , &
   118:                 & 0.3728e4 , 0.5179e4 , 0.7197e4 , 0.1000e5 , 0.1389e5 , &
   119:                 & 0.1931e5 , 0.2683e5 , 0.3728e5 , 0.5179e5 , 0.7197e5 , &
   120:                 & 0.1000e6 , 0.1389e6 , 0.1931e6 , 0.2683e6 , 0.3728e6 , &
   121:                 & 0.5179e6 , 0.7197e6 , 0.1000e7 , 0.1389e7 , 0.1931e7 , &
   122:                 & 0.2683e7 , 0.3728e7 , 0.5179e7 , 0.7197e7 , 0.1000e8 , &
   123:                 & 0.1389e8 , 0.1931e8 , 0.2683e8 , 0.3728e8 , 0.5179e8   &
   124:                 & /
   125:             
   126:             
   127:               data a_Table15mNLTEfa &
   128:                 & / &
   129:                 & 0.5000e0 , 0.4993e0 , 0.4991e0 , 0.4987e0 , 0.4982e0 , &
   130:                 & 0.4975e0 , 0.4966e0 , 0.4953e0 , 0.4936e0 , 0.4913e0 , &
   131:                 & 0.4883e0 , 0.4844e0 , 0.4796e0 , 0.4734e0 , 0.4656e0 , &
   132:                 & 0.4557e0 , 0.4432e0 , 0.4279e0 , 0.4090e0 , 0.3864e0 , &
   133:                 & 0.3595e0 , 0.3284e0 , 0.2933e0 , 0.2550e0 , 0.2149e0 , &
   134:                 & 0.1750e0 , 0.1373e0 , 0.1041e0 , 0.7679e-1, 0.5566e-1, &
   135:                 & 0.4009e-1, 0.2892e-1, 0.2096e-1, 0.1530e-1, 0.1127e-1, &
   136:                 & 0.8387e-2, 0.6329e-2, 0.4851e-2, 0.3783e-2, 0.3005e-2, &
   137:                 & 0.2431e-2, 0.1999e-2, 0.1671e-2, 0.1415e-2, 0.1211e-2, &
   138:                 & 0.1044e-2, 0.9018e-3, 0.7798e-3, 0.6735e-3, 0.5801e-3, &
   139:                 & 0.4982e-3, 0.4267e-3, 0.3645e-3, 0.3108e-3, 0.2646e-3, &
   140:                 & 0.2249e-3, 0.1911e-3, 0.1622e-3, 0.1376e-3, 0.1167e-3, &
   141:                 & 0.9891e-4, 0.8382e-4, 0.7101e-4, 0.6013e-4, 0.5091e-4, &
   142:                 & 0.4307e-4, 0.3643e-4, 0.3079e-4, 0.2600e-4, 0.2194e-4  &
   143:                 & / 
   144:             
   145:             
   146:               character(*), parameter:: module_name = 'rad_15m_NLTE'
   147:                                           ! モジュールの名称.
   148:                                           ! Module name
   149:               character(*), parameter:: version = &
   150:                 & '$Name:  $' // &
   151:                 & '$Id: rad_15m_NLTE.f90,v 1.1 2012/11/15 03:30:10 yot Exp $'
   152:                                           ! モジュールのバージョン
   153:                                           ! Module version
   154:             
   155:             contains
   156:             
   157:               !**************************************************************************
   158:               !     subroutine nlteradiation
   159:               !     calculate Non-LTE radiative cooling rate
   160:               !**************************************************************************
   161:               ! pi
   162:               ! amu      : atomic mass unit
   163:               ! day      : one solar day (sec)
   164:               ! grav     : gravitational acceleration
   165:               ! im       : number of the vertical layers
   166:               ! jm       : number of the meridional grids
   167:               ! km       : number of the zonal grids
   168:               ! ntemp    : neutral temperature (K)
   169:               ! press    : pressure at midpoint of layer (Pa)
   170:               ! cp       : specific heat at constant pressure
   171:               ! q15m1    : infrared heating rate in 15 micron band below about 80 km
   172:               ! rho      : mass density at midpoint of layers
   173:               !**************************************************************************
   174:             
   175:               subroutine rad15mNLTE(                &
   176:                 & xyz_Press, xyz_Temp, xyz_VirTemp, &
   177:                 & xyz_DTempDt15mNLTE                &
   178:                 & )
   179:             
   180:                 ! 物理定数設定
   181:                 ! Physical constants settings
   182:                 !
   183:                 use constants, only: &
   184:                   & Grav, &
   185:                                           ! $ g $ [m s-2].
   186:                                           ! 重力加速度.
   187:                                           ! Gravitational acceleration
   188:                   & CpDry, &
   189:                                           ! $ C_p $ [J kg-1 K-1].
   190:                                           ! 乾燥大気の定圧比熱.
   191:                                           ! Specific heat of air at constant pressure
   192:                   & GasRDry
   193:                                           ! $ R $ [J kg-1 K-1].
   194:                                           ! 乾燥大気の気体定数.
   195:                                           ! Gas constant of air
   196:             
   197:                 real(DP), intent(in ) :: xyz_Press   (0:imax-1, 1:jmax, 1:kmax)
   198:                 real(DP), intent(in ) :: xyz_Temp    (0:imax-1, 1:jmax, 1:kmax)
   199:                 real(DP), intent(in ) :: xyz_VirTemp (0:imax-1, 1:jmax, 1:kmax)
   200:                 real(DP), intent(out) :: xyz_DTempDt15mNLTE(0:imax-1, 1:jmax, 1:kmax)
   201:             
   202:             
   203:                 ! Local variables
   204:                 !
   205:                 real(DP) :: xyz_Rho(0:imax-1, 1:jmax, 1:kmax)
   206:                 integer  :: i
   207:                 integer  :: j
   208:                 integer  :: k
   209:                 integer  :: l
   210:             
   211:                 real(DP) :: tau
   212:                 real(DP) :: e1, e2
   213:                 real(DP) :: ltau
   214:                 real(DP) :: ramda
   215:                 real(DP), parameter :: a10 = 2.44d0
   216:                 real(DP), parameter :: g10 = 2.0d0
   217:                 real(DP) :: kco2, ko
   218:                 real(DP) :: co2nd, ond
   219:                 real(DP) :: tmpfac
   220:                 real(DP) :: NLTECR
   221:             !!$    real(DP) :: xyz_Weight(0:imax-1, 1:jmax, 1:kmax)
   222:             
   223:             
   224:                 ! Variables for Reference Pressure
   225:                 !
   226:                 real(DP) :: p0, t0, ond0, f0
   227:             
   228:                 ! kmin     : maximum index used for calculation of
   229:                 !          : atmospheric radiative cooling rate
   230:             !!$    integer  :: xy_kMin(0:imax-1, 1:jmax)
   231:             
   232:                 real(DP), parameter :: AMU = 1.6605655d-27
   233:             
   234:             
   235:                 ! 初期化
   236:                 ! Initialization
   237:                 !
   238:                 if ( .not. rad_15m_NLTE_inited ) then
   239:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   240:                 end if
   241:             
   242:             !!$    call calcimin(im,iup,jm,km,press,imin)
   243:             !!$    xy_kMin = kmax
   244:             
   245:             !!$    call rad15mNLTECalcWeight( &
   246:             !!$      & xyz_Press,                   &
   247:             !!$!      &  xy_kMin,                    &
   248:             !!$      & xyz_Weight                   &
   249:             !!$      & )
   250:             !!$    xyz_Weight = 1.0_DP
   251:             
   252:                 ! Set Variables for Reference Pressure
   253:                 !
   254:                 p0 = 1.2d-3 * 1.0d-6 * 1.0d5
   255:                 f0 = 0.5d0 * 1.0d-2
   256:             !            f0=1.0d0*1.0d-2
   257:             
   258:             
   259: W**==== A       xyz_Rho = xyz_Press / ( GasRDry * xyz_VirTemp )
   260:             
   261: +------>        do j = 1, jmax
   262: |+----->          do i = 0, imax-1
   263: ||          
   264: ||                  ! Number Density is in CGS Unit
   265: ||                  !
   266: ||                  if( p0 <= xyz_Press(i,j,kmax) ) then
   267: ||                    t0 = xyz_Temp(i,j,kmax)
   268: ||                    ond0 = xyz_Rho(i,j,kmax) / ( 44.0d0 * AMU ) &
   269: ||                      * ( p0 / xyz_Press(i,j,kmax) ) &
   270: ||                      * f0 &
   271: ||                      * 1.0d-6
   272: ||                  else if( p0 <= xyz_Press(i,j,1) ) then
   273: ||V---->              search_p : do l = kmax-1, 2, -1
   274: |||     A               if( p0 <= xyz_Press(i,j,l) ) exit search_p
   275: ||V----               end do search_p
   276: ||                    t0 = ( xyz_Temp(i,j,l+1) - xyz_Temp(i,j,l) )        &
   277: ||                      &  / log( xyz_Press(i,j,l+1) / xyz_Press(i,j,l) ) &
   278: ||                      &  * log( p0 / xyz_Press(i,j,l) )                 &
   279: ||                      &  + xyz_Temp(i,j,l)
   280: ||                    ond0 =                                   &
   281: ||                      & xyz_Temp(i,j,l) / t0                 &
   282: ||                      &  * xyz_Rho(i,j,l) / ( 44.0d0 * AMU ) &
   283: ||                      &  * ( p0 / xyz_Press(i,j,l) )         &
   284: ||                      &  * f0                                &
   285: ||                      &  * 1.0d-6
   286: ||                  else
   287: ||                    write( 6, * ) 'Reference pressure or pressure is inappropriate.'
   288: ||                    write( 6, * ) 'Unexpected Error'
   289: ||                    write( 6, * ) 'Stop'
   290: ||                    stop
   291: ||                  endif
   292: ||          
   293: ||+---->            do k = 1, kmax
   294: |||                   ! cgs unit
   295: |||                   co2nd = xyz_Rho(i,j,k) / ( 44.0d0 * AMU ) &
   296: |||                     & * 1.0d-6
   297: |||         
   298: |||         !               kco2=1.0d-15
   299: |||                   ! from Lunt et al., 1985
   300: |||                   if( xyz_Temp(i,j,k) < 175.0_DP ) then
   301: |||                     kco2 = 4.2d-12 * exp( -2988.0d0 /175.0d0 + 303930.0d0 / ( 175.0d0 * 175.0d0 ) )
   302: |||                   else
   303: |||                     kco2 = 4.2d-12 * exp( -2988.0d0 / xyz_Temp(i,j,k) + 303930.0d0 / ( xyz_Temp(i,j,k) * xyz_Temp(i,j,k) ) )
   304: |||                   endif
   305: |||         
   306: |||                   ! ond0 has already been set in cgs unit
   307: |||                   ond = t0 / xyz_Temp(i,j,k) &
   308: |||                     & * ond0                 &
   309: |||                     & * ( ( xyz_Press(i,j,k) /p0 )**(16.0d0/44.0d0) )
   310: |||         
   311: |||         !               ko=1.5d-11*dexp(-800.0d0/ntemp(i,j,k))
   312: |||                   ! from Lopez-Valvelde and Lopez-Puertas, 1994, 
   313: |||                   ! Bougher et al., 1994
   314: |||                   ko = 3.0d-12
   315: |||                   tau = 6.4d-15 * xyz_Press(i,j,k) &
   316: |||                     & / ( 44.0d0 * AMU * Grav )    &
   317: |||                     & * 1.0d-4
   318: |||         
   319: |||         
   320: |||         !!$  integer , parameter :: nTable15mNLTE = 70
   321: |||         !!$  real(DP),           :: a_Table15mNLTEsn( nTable15mNLTE )
   322: |||         !!$                                        ! sigma N (non dimension)
   323: |||         !!$  real(DP),           :: a_Table15mNLTEfa( nTable15mNLTE )
   324: |||         !!$                                        ! E(tau)
   325: |||         
   326: |||         !----------------------
   327: |||V--->              search_sn_1 : do l = 2, nTable15mNLTE-1
   328: ||||    A               if ( tau < a_Table15mNLTEsn(l) ) exit search_sn_1
   329: |||V---               end do search_sn_1
   330: |||                   e1 =   ( a_Table15mNLTEfa(l) - a_Table15mNLTEfa(l-1) ) &
   331: |||                     &  / ( a_Table15mNLTEsn(l) - a_Table15mNLTEsn(l-1) ) &
   332: |||                     &  * ( tau - a_Table15mNLTEsn(l-1) )                 &
   333: |||                     &  + a_Table15mNLTEfa(l-1)
   334: |||                   if ( e1 > 0.5d0 ) e1 = 0.5d0
   335: |||                   if ( e1 < 0.0d0 ) e1 = 0.0d0
   336: |||         !----------------------
   337: |||V--->              search_sn_2 : do l = 2, nTable15mNLTE-1
   338: ||||    A               if ( ( tau / 2.0d0 ) <  a_Table15mNLTEsn(l) ) exit search_sn_2
   339: |||V---               end do search_sn_2
   340: |||                   e2 =   ( a_Table15mNLTEfa(l) - a_Table15mNLTEfa(l-1) ) &
   341: |||                     &  / ( a_Table15mNLTEsn(l) - a_Table15mNLTEsn(l-1) ) &
   342: |||                     &  * ( ( tau / 2.0d0 ) - a_Table15mNLTEsn(l-1) )     &
   343: |||                     &  + a_Table15mNLTEfa(l-1)
   344: |||                   if ( e2 > 0.5d0 ) e2 = 0.5d0
   345: |||                   if ( e2 < 0.0d0 ) e2 = 0.0d0
   346: |||         !----------------------
   347: |||                   ltau = e1 + e2
   348: |||                   ramda = a10 / ( a10 + kco2 * co2nd + ko * ond )
   349: |||                   tmpfac = 0.5d0 * ramda * ltau / ( 1.0d0 - ramda + 0.5d0 * ramda * ltau )
   350: |||         
   351: |||                   NLTECR = 1.33d-13 * g10 * exp( -960.0d0 / xyz_Temp(i,j,k) ) * co2nd &
   352: |||                     & * ( kco2 * co2nd + ko * ond ) * tmpfac &
   353: |||                     & * 1.0d-1 &
   354: |||                     & / ( xyz_Rho(i,j,k) * CpDry )
   355: |||         
   356: |||         !!$          xyz_DTempDt15mNLTE(i,j,k) = &
   357: |||         !!$            & ( 1.0d0 - xyz_Weight(i,j,k) ) * ( -NLTECR )
   358: |||                   xyz_DTempDt15mNLTE(i,j,k) = - NLTECR
   359: ||+----             end do
   360: ||          
   361: |+-----           end do
   362: +------         end do
   363:             
   364:               end subroutine rad15mNLTE
   365:             
   366:               !----------------------------------------------------------------------------
   367:             
   368:               subroutine rad15mNLTEMergeHR(         &
   369:                 & xyz_Press, xyz_Temp, xyz_VirTemp, &
   370:                 & xyz_DTempDt                       &
   371:                 & )
   372:             
   373:                 ! ヒストリデータ出力
   374:                 ! History data output
   375:                 !
   376:                 use gtool_historyauto, only: HistoryAutoPut
   377:             
   378:                 ! 時刻管理
   379:                 ! Time control
   380:                 !
   381:                 use timeset, only: &
   382:                   & TimeN                 ! ステップ $ t $ の時刻.
   383:                                           ! Time of step $ t $.
   384:             
   385:                 real(DP), intent(in   ) :: xyz_Press  (0:imax-1, 1:jmax, 1:kmax)
   386:                 real(DP), intent(in   ) :: xyz_Temp   (0:imax-1, 1:jmax, 1:kmax)
   387:                 real(DP), intent(in   ) :: xyz_VirTemp(0:imax-1, 1:jmax, 1:kmax)
   388:                 real(DP), intent(inout) :: xyz_DTempDt(0:imax-1, 1:jmax, 1:kmax)
   389:             
   390:             
   391:                 ! Local variables
   392:                 !
   393:                 real(DP) :: xyz_Weight        (0:imax-1, 1:jmax, 1:kmax)
   394:                 real(DP) :: xyz_DTempDt15mNLTE(0:imax-1, 1:jmax, 1:kmax)
   395:             
   396:             
   397:                 ! 初期化
   398:                 ! Initialization
   399:                 !
   400:                 if ( .not. rad_15m_NLTE_inited ) then
   401:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   402:                 end if
   403:             
   404:             
   405:                 call rad15mNLTECalcWeight( &
   406:                   & xyz_Press,                   &
   407:             !      &  xy_kMin,                    &
   408:                   & xyz_Weight                   &
   409:                   & )
   410:             !!$    xyz_Weight = 1.0_DP
   411:             
   412:                 call rad15mNLTE(                      &
   413:                   & xyz_Press, xyz_Temp, xyz_VirTemp, &
   414:                   & xyz_DTempDt15mNLTE                &
   415:                   & )
   416:             
   417: W**==== A       xyz_DTempDt =                                              &
   418:                   &   xyz_Weight             * xyz_DTempDt                 &
   419:                   & + ( 1.0d0 - xyz_Weight ) * xyz_DTempDt15mNLTE
   420:             
   421:             
   422:                 call HistoryAutoPut( TimeN, 'DTempDt15mNLTE'   , xyz_DTempDt15mNLTE )
   423:                 call HistoryAutoPut( TimeN, 'DTempDtRadLMerged', xyz_DTempDt )
   424:             
   425:             
   426:               end subroutine rad15mNLTEMergeHR
   427:             
   428:               !----------------------------------------------------------------------------
   429:             
   430:               subroutine rad15mNLTECalckMin( &
   431:                 & xyz_Press, &
   432:                 & xy_kMin    &
   433:                 & )
   434:             
   435:                 real(DP), intent(in ) :: xyz_Press(0:imax-1, 1:jmax, 1:kmax)
   436:                 integer , intent(out) :: xy_kMin  (0:imax-1, 1:jmax)
   437:             
   438:                 integer :: i
   439:                 integer :: j
   440:                 integer :: k
   441:             
   442:                 ! 初期化
   443:                 ! Initialization
   444:                 !
   445:                 if ( .not. rad_15m_NLTE_inited ) then
   446:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   447:                 end if
   448:             
   449:                 ! set minimum index used for calculation of
   450:                 ! atmospheric radiative cooling rate
   451:             !    imin=im-25
   452:             
   453: +------>        do j = 1, jmax
   454: |+----->          do i = 0, imax-1
   455: ||V---->            find_kmin : do k = kmax, 1, -1
   456: |||     A             if ( xyz_Press(i,j,k) > 1.0d-2 ) exit find_kmin
   457: ||V----             end do find_kmin
   458: ||                  xy_kMin(i,j) = k
   459: |+-----           end do
   460: +------         end do
   461:             
   462:               end subroutine rad15mNLTECalckMin
   463:             
   464:               !----------------------------------------------------------------------------
   465:             
   466:               subroutine rad15mNLTECalcWeight( &
   467:                 & xyz_Press,                   &
   468:             !!$    & xy_kMin,          &
   469:                 & xyz_Weight                   &
   470:                 & )
   471:             
   472:                 ! 物理・数学定数設定
   473:                 ! Physical and mathematical constants settings
   474:                 !
   475:                 use constants0, only: &
   476:                   & PI                    ! $ \pi $ .
   477:                                           ! 円周率.  Circular constant
   478:             
   479:                 real(DP), intent(in ) :: xyz_Press (0:imax-1, 1:jmax, 1:kmax)
   480:             !!$    integer , intent(in ) :: xy_kMin   (0:imax-1, 1:jmax)
   481:                 real(DP), intent(out) :: xyz_Weight(0:imax-1, 1:jmax, 1:kmax)
   482:             
   483:             
   484:                 ! Local variables
   485:                 !
   486:                 integer :: i
   487:                 integer :: j
   488:                 integer :: k
   489:             
   490:                 ! 初期化
   491:                 ! Initialization
   492:                 !
   493:                 if ( .not. rad_15m_NLTE_inited ) then
   494:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   495:                 end if
   496:             
   497: W------>        do k = 1, kmax
   498: |*----->          do j = 1, jmax
   499: ||*---->            do i = 0, imax-1
   500: |||         
   501: |||         !               weight(i,j,k)=(atan(2.0d0 &
   502: |||         !                    *dlog(dsqrt(press(i,j,k)*press(i+1,j,k)) &
   503: |||         !                    /dsqrt(press(imin+4,j,k)*press(imin+4+1,j,k)))) &
   504: |||         !                    *1.2d0 &
   505: |||         !                    +pi/2.0d0)/pi
   506: |||         
   507: |||     A             xyz_Weight(i,j,k) = &
   508: |||                     & ( atan( 2.0d0 * log( xyz_Press(i,j,k) / ( 1.0d-2 * exp( 2.0d0 ) ) ) ) &
   509: |||                     &   * 1.2d0 + Pi / 2.0d0 ) &
   510: |||                     & / Pi
   511: |||                   xyz_Weight(i,j,k) = max( xyz_Weight(i,j,k), 0.0d0 )
   512: |||     A             xyz_Weight(i,j,k) = min( xyz_Weight(i,j,k), 1.0d0 )
   513: ||*----             end do
   514: |*-----           end do
   515: W------         end do
   516:             
   517:             
   518:               end subroutine rad15mNLTECalcWeight
   519:             
   520:               !----------------------------------------------------------------------------
   521:             
   522:               subroutine Rad15mNLTEInit
   523:             
   524:                 ! ファイル入出力補助
   525:                 ! File I/O support
   526:                 !
   527:             !!$    use dc_iounit, only: FileOpen
   528:             
   529:                 ! NAMELIST ファイル入力に関するユーティリティ
   530:                 ! Utilities for NAMELIST file input
   531:                 !
   532:             !!$    use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid
   533:             
   534:                 ! ヒストリデータ出力
   535:                 ! History data output
   536:                 !
   537:                 use gtool_historyauto, only: HistoryAutoAddVariable
   538:             
   539:                 ! 座標データ設定
   540:                 ! Axes data settings
   541:                 !
   542:                 use axesset, only: &
   543:                   & AxnameX, &
   544:                   & AxnameY, &
   545:                   & AxnameZ, &
   546:                   & AxnameR, &
   547:                   & AxnameT
   548:             
   549:                 ! 宣言文 ; Declaration statements
   550:                 !
   551:             
   552:             !!$    integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号.
   553:             !!$                              ! Unit number for NAMELIST file open
   554:             !!$    integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT.
   555:             !!$                              ! IOSTAT of NAMELIST read
   556:             
   557:                 ! NAMELIST 変数群
   558:                 ! NAMELIST group name
   559:                 !
   560:             !!$    namelist /rad_15m_NLTE_nml/ &
   561:             !!$      & SolarConst
   562:                       !
   563:                       ! デフォルト値については初期化手続 "rad_15m_NLTE#Rad15mNLTEInit"
   564:                       ! のソースコードを参照のこと.
   565:                       !
   566:                       ! Refer to source codes in the initialization procedure
   567:                       ! "rad_15m_NLTE#Rad15mNLTEInit" for the default values.
   568:                       !
   569:             
   570:                 if ( rad_15m_NLTE_inited ) return
   571:             
   572:                 ! デフォルト値の設定
   573:                 ! Default values settings
   574:                 !
   575:             !!$    SolarConst      = 1380.0_DP / 1.52_DP**2
   576:             
   577:                 ! NAMELIST の読み込み
   578:                 ! NAMELIST is input
   579:                 !
   580:             !!$    if ( trim(namelist_filename) /= '' ) then
   581:             !!$      call FileOpen( unit_nml, &          ! (out)
   582:             !!$        & namelist_filename, mode = 'r' ) ! (in)
   583:             !!$
   584:             !!$      rewind( unit_nml )
   585:             !!$      read( unit_nml,                     & ! (in)
   586:             !!$        & nml = rad_15m_NLTE_nml,         & ! (out)
   587:             !!$        & iostat = iostat_nml )             ! (out)
   588:             !!$      close( unit_nml )
   589:             !!$
   590:             !!$      call NmlutilMsg( iostat_nml, module_name ) ! (in)
   591:             !!$    end if
   592:             
   593:             
   594:                 ! Initialization of modules used in this module
   595:                 !
   596:             
   597:             
   598:                 ! ヒストリデータ出力のためのへの変数登録
   599:                 ! Register of variables for history data output
   600:                 !
   601:                 call HistoryAutoAddVariable( 'DTempDt15mNLTE',     &
   602:                   & (/ AxnameX, AxnameY, AxnameZ, AxnameT /),      &
   603:                   & 'radiative calculation by NLTE process at 15 micron meter', 'K s-1' )
   604:                 call HistoryAutoAddVariable( 'DTempDtRadLMerged',  &
   605:                   & (/ AxnameX, AxnameY, AxnameZ, AxnameT /),      &
   606:                   & 'radiative calculation in long wave merged with NLTE heating rate', 'K s-1' )
   607:             
   608:                 ! 印字 ; Print
   609:                 !
   610:                 call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   611:             !!$    call MessageNotify( 'M', module_name, 'SolarConst = %f', d = (/ SolarConst /) )
   612:                 call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   613:             
   614:                 rad_15m_NLTE_inited = .true.
   615:             
   616:               end subroutine Rad15mNLTEInit
   617:             
   618:             !!$    !**************************************************************************
   619:             !!$    subroutine readnirfac(fn,nirfn,nirfp,nirfac)
   620:             !!$
   621:             !!$      use vtype
   622:             !!$
   623:             !!$      implicit none
   624:             !!$
   625:             !!$      character(len=128) :: fn
   626:             !!$      integer(i4b) :: nirfn
   627:             !!$      real(dp) :: nirfp(nirfn)
   628:             !!$      real(dp) :: nirfac(nirfn)
   629:             !!$
   630:             !!$
   631:             !!$      ! Local variables
   632:             !!$      !
   633:             !!$      integer(i4b) :: i
   634:             !!$      character(len=128) :: tmpl
   635:             !!$
   636:             !!$
   637:             !!$      open(70,file='./'//fn,status='unknown')
   638:             !!$      read(70,'(a128)') tmpl
   639:             !!$      do i=1,nirfn
   640:             !!$         read(70,*) nirfp(i),nirfac(i)
   641:             !!$         nirfp(i)=nirfp(i)*1.0d-6*1.0d5
   642:             !!$      enddo
   643:             !!$      close(70)
   644:             !!$
   645:             !!$      return
   646:             !!$    end subroutine readnirfac
   647:             !!$
   648:             !!$    !**************************************************************************
   649:             !!$    !     subroutine nirhrcorrect
   650:             !!$    !     correct near infrared heating rate
   651:             !!$    !**************************************************************************
   652:             !!$    ! im       : number of the vertical layers
   653:             !!$    ! jm       : number of the meridional grids
   654:             !!$    ! km       : number of the zonal grids
   655:             !!$    ! press    : pressure at midpoint of layer (Pa)
   656:             !!$    ! nirfn    : maximum number of near infrared heating rate
   657:             !!$    !          : factor
   658:             !!$    ! nirfp    : pressure for table of near infrared heating rate
   659:             !!$    !          : correct factor
   660:             !!$    ! nirfa    : near infrared heating rate correct factor
   661:             !!$    ! qnir     : near infrared heating rate
   662:             !!$    ! corsw    : artificial correction switch, 
   663:             !!$    !          : if sw is equal to 1 correction is down
   664:             !!$    !**************************************************************************
   665:             !!$
   666:             !!$    subroutine nirhrcorrect(im,jm,km,press,nirfn,nirfp,nirfac,qnir, &
   667:             !!$         corsw)
   668:             !!$
   669:             !!$      use vtype
   670:             !!$
   671:             !!$      implicit none
   672:             !!$
   673:             !!$      integer(i4b) :: im,jm,km
   674:             !!$      real(dp) :: press(im+1,jm,km)
   675:             !!$      integer(i4b) :: nirfn
   676:             !!$      real(dp) :: nirfp(nirfn)
   677:             !!$      real(dp) :: nirfac(nirfn)
   678:             !!$      real(dp) :: qnir(im,jm,km)
   679:             !!$      integer(i4b) :: corsw
   680:             !!$
   681:             !!$
   682:             !!$      ! Local variables
   683:             !!$      !
   684:             !!$      integer(i4b) :: i,j,k,l
   685:             !!$      real(dp) :: tmpp
   686:             !!$      real(dp) :: tmpfac
   687:             !!$
   688:             !!$
   689:             !!$      do k=1,km
   690:             !!$         do j=1,jm
   691:             !!$            do i=1,im
   692:             !!$               tmpp=dsqrt(press(i,j,k)*press(i+1,j,k))
   693:             !!$               if(tmpp.lt.nirfp(nirfn)) then
   694:             !!$
   695:             !!$!                  qnir(i,j,k)=qnir(i,j,k) &
   696:             !!$!                       /(nirfac(nirfn)*nirfp(nirfn)/tmpp)
   697:             !!$
   698:             !!$                  tmpfac=nirfac(nirfn) &
   699:             !!$                       *(nirfp(nirfn)/tmpp)*(nirfp(nirfn)/tmpp) &
   700:             !!$                       *(nirfp(nirfn)/tmpp)*(nirfp(nirfn)/tmpp)
   701:             !!$                  tmpfac=1.0d0/tmpfac
   702:             !!$               else if(tmpp.le.nirfp(1)) then
   703:             !!$                  do l=2,nirfn
   704:             !!$                     if(tmpp.gt.nirfp(l)) go to 100
   705:             !!$                  enddo
   706:             !!$100               continue
   707:             !!$                  tmpfac=(nirfac(l)-nirfac(l-1))/(nirfp(l)-nirfp(l-1)) &
   708:             !!$                       *(tmpp-nirfp(l-1))+nirfac(l-1)
   709:             !!$                  tmpfac=1.0d0/tmpfac
   710:             !!$                  if(tmpfac.gt.1.0d0) then
   711:             !!$                     write(*,*) 'Factor is greater than 1'
   712:             !!$                     write(*,*) 'Stop'
   713:             !!$                     stop
   714:             !!$                  endif
   715:             !!$               endif
   716:             !!$
   717:             !!$               ! This is artificial correction for 2.7 micron band
   718:             !!$               !
   719:             !!$               if((corsw.eq.1).and.(tmpp.lt.(1.2d-8*1.0d5))) then
   720:             !!$!                  qnir(i,j,k)=qnir(i,j,k)*dsqrt(tmpp/(1.2d-8*1.0d5))
   721:             !!$                  tmpfac=tmpfac*dsqrt(tmpp/(1.2d-8*1.0d5))
   722:             !!$               endif
   723:             !!$
   724:             !!$               qnir(i,j,k)=qnir(i,j,k)*tmpfac
   725:             !!$
   726:             !!$            enddo
   727:             !!$         enddo
   728:             !!$      enddo
   729:             !!$
   730:             !!$      return
   731:             !!$    end subroutine nirhrcorrect
   732:             
   733:             end module rad_15m_NLTE
