Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:50 2016
FILE NAME: rad_C1998.f90
PROGRAM NAME: rad_c1998
DIAGNOSTIC LIST

  LINE  LEVEL( NO.): DIAGNOSTIC MESSAGE

   255  opt  (  11): Fused array assignments. :line 255 - 264
   255  vec  (   4): Vectorized array expression.
   255  vec  (  29): ADB is used for array.: xyz_cloudaf
   255  vec  (  29): ADB is used for array.: xyz_reff
   255  vec  (  29): ADB is used for array.: xyz_cloudcoalb
   255  vec  (  29): ADB is used for array.: xyz_cloudextcoef
   271  opt  (  11): Fused array assignments. :line 271 - 280
   271  vec  (   4): Vectorized array expression.
   271  vec  (  29): ADB is used for array.: xyz_cloudaf
   271  vec  (  29): ADB is used for array.: xyz_reff
   271  vec  (  29): ADB is used for array.: xyz_cloudcoalb
   271  vec  (  29): ADB is used for array.: xyz_cloudextcoef
   359  vec  (   1): Vectorized loop.
   359  vec  (  29): ADB is used for array.: aa_icecloudafparams
   359  vec  (  29): ADB is used for array.: aa_watcloudafparams
   359  vec  (  29): ADB is used for array.: aa_icecloudcoalbparams
   359  vec  (  29): ADB is used for array.: aa_watcloudcoalbparams
   359  vec  (  29): ADB is used for array.: aa_icecloudextcoefparams
   359  vec  (  29): ADB is used for array.: aa_watcloudextcoefparams
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:50 2016
FILE NAME: rad_C1998.f90
PROGRAM NAME: rad_c1998
TRANSFORMATION LIST

  LINE                   FORTRAN STATEMENT

     1  != Chou et al (1998) による短波放射用雲モデル
     2  !
     3  != Cloud model for short wave radiation model described by Chou et al (1998)
     4  !
     5  ! Authors::   Yoshiyuki O. Takahashi
     6  ! Version::   $Id: rad_C1998.f90,v 1.4 2011/11/30 03:44:09 yot Exp $
     7  ! Tag Name::  $Name:  $
     8  ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9  ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10  !
    11  
    12  module rad_C1998
    13    !
    14    != Chou et al (1998) による短波放射用雲モデル
    15    !
    16    != Cloud model for short wave radiation model described by Chou et al (1998)
    17    !
    18    ! <b>Note that Japanese and English are described in parallel.</b>
    19    !
    20    ! 短波放射モデル.
    21    !
    22    ! This is a model of short wave radiation.
    23    !
    24    !== References
    25    !
    26    !  Chou, M.-D., M. J. Suarez, C.-H. Ho, M. M.-H. Yan, and K.-T. Lee,
    27    !    Parameterizations for cloud overlapping and shortwave single-scattering
    28    !    properties for use in general circulation and cloud ensemble models,
    29    !    J. Climate, 11, 202-214, 1998.
    30    !
    31    !== Procedures List
    32    !
    33  !!$  ! RadiationFluxDennouAGCM :: 放射フラックスの計算
    34  !!$  ! RadiationDTempDt        :: 放射フラックスによる温度変化の計算
    35  !!$  ! RadiationFluxOutput     :: 放射フラックスの出力
    36  !!$  ! RadiationFinalize       :: 終了処理 (モジュール内部の変数の割り付け解除)
    37  !!$  ! ------------            :: ------------
    38  !!$  ! RadiationFluxDennouAGCM :: Calculate radiation flux
    39  !!$  ! RadiationDTempDt        :: Calculate temperature tendency with radiation flux
    40  !!$  ! RadiationFluxOutput     :: Output radiation fluxes
    41  !!$  ! RadiationFinalize       :: Termination (deallocate variables in this module)
    42    !
    43    !== NAMELIST
    44    !
    45  !!$  ! NAMELIST#radiation_DennouAGCM_nml
    46    !
    47  
    48    ! USE statements
    49    !
    50  
    51    !
    52    ! Kind type parameter
    53    !
    54    use dc_types, only: DP, &      ! Double precision.
    55      &                 STRING, &  ! Strings.
    56      &                 TOKEN      ! Keywords.
    57  
    58    ! メッセージ出力
    59    ! Message output
    60    !
    61    use dc_message, only: MessageNotify
    62  
    63    !
    64    ! Grid points settings
    65    !
    66    use gridset, only: imax, & !
    67                               ! Number of grid points in longitude
    68      &                jmax, & !
    69                               ! Number of grid points in latitude
    70      &                kmax    !
    71                               ! Number of vertical level
    72  
    73    ! Declaration statements
    74    !
    75    implicit none
    76    private
    77  
    78    !
    79    ! Public procedure
    80    !
    81    public :: RadC1998CalcCloudOptProp
    82    public :: RadC1998Init
    83  
    84  
    85    integer , parameter :: nband1 = 8  ! * 14500 to 57143 cm-1 (0.175 to 0.70 micron)
    86    integer , parameter :: nband2 = 3  ! *  2600 to 14500 cm-1 (0.70-10 micron)
    87  
    88    real(DP), save      :: aa_WatCloudExtCoefParams(1:2, 1:nband1+nband2)
    89    real(DP), save      :: aa_WatCloudCoAlbParams  (1:3, 1:nband1+nband2)
    90    real(DP), save      :: aa_WatCloudAFParams     (1:3, 1:nband1+nband2)
    91    real(DP), save      :: aa_IceCloudExtCoefParams(1:2, 1:nband1+nband2)
    92    real(DP), save      :: aa_IceCloudCoAlbParams  (1:3, 1:nband1+nband2)
    93    real(DP), save      :: aa_IceCloudAFParams     (1:3, 1:nband1+nband2)
    94  
    95  
    96    logical , save     :: rad_c1998_inited
    97  
    98    data rad_c1998_inited /.false./
    99  
   100  
   101  
   102    ! Table 2.
   103    data aa_WatCloudExtCoefParams &
   104      & / &
   105      !   a0       a1
   106      &   -6.59d-3,  1.65d0, & ! 1(1)
   107      &   -6.59d-3,  1.65d0, & ! 2(1)
   108      &   -6.59d-3,  1.65d0, & ! 3(1)
   109      &   -6.59d-3,  1.65d0, & ! 4(1)
   110      &   -6.59d-3,  1.65d0, & ! 5(1)
   111      &   -6.59d-3,  1.65d0, & ! 6(1)
   112      &   -6.59d-3,  1.65d0, & ! 7(1)
   113      &   -6.59d-3,  1.65d0, & ! 8(1)
   114      &   -1.01d-2,  1.72d0, & ! 9
   115      &   -1.66d-2,  1.85d0, & !10
   116      &   -3.39d-2,  2.16d0  & !11
   117      & /
   118  
   119  
   120    ! Table 3.
   121    data aa_WatCloudCoAlbParams &
   122      & / &
   123      !    b0       b1        b2
   124      &    0.0d0  , 0.0d0  ,  0.0d0  , & ! 1
   125      &    0.0d0  , 0.0d0  ,  0.0d0  , & ! 2
   126      &    0.0d0  , 0.0d0  ,  0.0d0  , & ! 3
   127      &    0.0d0  , 0.0d0  ,  0.0d0  , & ! 4
   128      &    0.0d0  , 0.0d0  ,  0.0d0  , & ! 5
   129      &    0.0d0  , 0.0d0  ,  0.0d0  , & ! 6
   130      &    0.0d0  , 0.0d0  ,  0.0d0  , & ! 7
   131      &    0.0d0  , 0.0d0  ,  0.0d0  , & ! 8
   132      &    7.15d-8, 8.45d-6, -4.15d-8, & ! 1
   133      &   -1.99d-4, 8.88d-4, -6.50d-6, & !10
   134      &    1.21d-2, 1.79d-2, -3.69d-4  & !11
   135      & /
   136  
   137    ! Table 4.
   138    data aa_WatCloudAFParams &
   139      & / &
   140      !    c0       c1       c2
   141      &    8.26d-1, 5.29d-3, -1.49d-6, & ! 1
   142      &    8.26d-1, 5.29d-3, -1.49d-6, & ! 2
   143      &    8.26d-1, 5.29d-3, -1.49d-6, & ! 3
   144      &    8.26d-1, 5.29d-3, -1.49d-6, & ! 4
   145      &    8.26d-1, 5.29d-3, -1.49d-6, & ! 5
   146      &    8.26d-1, 5.29d-3, -1.49d-6, & ! 6
   147      &    8.26d-1, 5.29d-3, -1.49d-6, & ! 7
   148      &    8.26d-1, 5.29d-3, -1.49d-6, & ! 8
   149      &    7.94d-1, 8.32d-3, -2.33d-4, & ! 9
   150      &    7.45d-1, 1.37d-2, -3.82d-4, & !10
   151      &    8.35d-1, 2.57d-3,  5.52d-5  & !11
   152      & /
   153  
   154  
   155    data aa_IceCloudExtCoefParams &
   156      & / &
   157      !   a0       a1
   158      &   3.33d-3, 2.52d0, & ! 1
   159      &   3.33d-3, 2.52d0, & ! 2
   160      &   3.33d-3, 2.52d0, & ! 3
   161      &   3.33d-3, 2.52d0, & ! 4
   162      &   3.33d-3, 2.52d0, & ! 5
   163      &   3.33d-3, 2.52d0, & ! 6
   164      &   3.33d-3, 2.52d0, & ! 7
   165      &   3.33d-3, 2.52d0, & ! 8
   166      &   3.33d-3, 2.52d0, & ! 9
   167      &   3.33d-3, 2.52d0, & !10
   168      &   3.33d-3, 2.52d0  & !11
   169      & /
   170  
   171    ! Table 3.
   172    data aa_IceCloudCoAlbParams &
   173      & / &
   174      !    b0       b1        b2
   175      &    0.0d0  , 0.0d0  ,  0.0d0  , & ! 1
   176      &    0.0d0  , 0.0d0  ,  0.0d0  , & ! 2
   177      &    0.0d0  , 0.0d0  ,  0.0d0  , & ! 3
   178      &    0.0d0  , 0.0d0  ,  0.0d0  , & ! 4
   179      &    0.0d0  , 0.0d0  ,  0.0d0  , & ! 5
   180      &    0.0d0  , 0.0d0  ,  0.0d0  , & ! 6
   181      &    0.0d0  , 0.0d0  ,  0.0d0  , & ! 7
   182      &    0.0d0  , 0.0d0  ,  0.0d0  , & ! 8
   183      &   -2.60d-6, 7.46d-6,  0.0d0  , & ! 9
   184      &    2.15d-3, 7.37d-4, -1.34d-6, & !10
   185      &    8.94d-2, 2.99d-3, -1.04d-5  & !11
   186      & /
   187  
   188    ! Table 4.
   189    data aa_IceCloudAFParams &
   190      & / &
   191      !    c0       c1       c2
   192      &    7.46d-1, 1.05d-3, -2.64d-6, & ! 1
   193      &    7.46d-1, 1.05d-3, -2.64d-6, & ! 2
   194      &    7.46d-1, 1.05d-3, -2.64d-6, & ! 3
   195      &    7.46d-1, 1.05d-3, -2.64d-6, & ! 4
   196      &    7.46d-1, 1.05d-3, -2.64d-6, & ! 5
   197      &    7.46d-1, 1.05d-3, -2.64d-6, & ! 6
   198      &    7.46d-1, 1.05d-3, -2.64d-6, & ! 7
   199      &    7.46d-1, 1.05d-3, -2.64d-6, & ! 8
   200      &    7.49d-1, 1.20d-3, -3.67d-6, & ! 9
   201      &    7.61d-1, 1.42d-3, -3.96d-6, & !10
   202      &    8.41d-1, 1.26d-3, -3.85d-6  & !11
   203      & /
   204  
   205  
   206    character(*), parameter:: module_name = 'rad_C1998'
   207                                ! モジュールの名称.
   208                                ! Module name
   209    character(*), parameter:: version = &
   210      & '$Name:  $' // &
   211      & '$Id: rad_C1998.f90,v 1.4 2011/11/30 03:44:09 yot Exp $'
   212                                ! モジュールのバージョン
   213                                ! Module version
   214  
   215  contains
   216  
   217    !--------------------------------------------------------------------------------------
   218  
   219    subroutine RadC1998CalcCloudOptProp(               &
   220      & Spec, iband, xyz_REff,                         & ! (in )
   221      & xyz_CloudExtCoef, xyz_CloudCoAlb, xyz_CloudAF  & ! (out)
   222      & )
   223  
   224  
   225      ! USE statements
   226      !
   227  
   228      character(len=*), intent(in ) :: SPEC
   229      integer         , intent(in ) :: iband
   230      real(DP)        , intent(in ) :: xyz_REff        (0:imax-1, 1:jmax, 1:kmax)
   231      real(DP)        , intent(out) :: xyz_CloudExtCoef(0:imax-1, 1:jmax, 1:kmax)
   232      real(DP)        , intent(out) :: xyz_CloudCoAlb  (0:imax-1, 1:jmax, 1:kmax)
   233      real(DP)        , intent(out) :: xyz_CloudAF     (0:imax-1, 1:jmax, 1:kmax)
   234  
   235  
   236  
   237      !
   238      ! Work variables
   239      !
   240      integer :: l
   241  
   242  
   243      ! 初期化確認
   244      ! Initialization check
   245      !
   246      if ( .not. rad_c1998_inited ) then
   247        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   248      end if
   249  
   250  
   251      l = iband
   252  
   253      if ( Spec == 'Ice' ) then
   254  
   255        xyz_CloudExtCoef =                         &
   256          &   aa_IceCloudExtCoefParams(1,l)        &
   257          & + aa_IceCloudExtCoefParams(2,l) / xyz_REff
   258  
   259        xyz_CloudCoAlb  =                               &
   260          &   aa_IceCloudCoAlbParams(1,l)               &
   261          & + aa_IceCloudCoAlbParams(2,l) * xyz_REff    &
   262          & + aa_IceCloudCoAlbParams(3,l) * xyz_REff**2
   263  
   264        xyz_CloudAF =                                &
   265          &   aa_IceCloudAFParams(1,l)               &
   266          & + aa_IceCloudAFParams(2,l) * xyz_REff    &
   267          & + aa_IceCloudAFParams(3,l) * xyz_REff**2
   268  
   269      else if ( Spec == 'Liquid' ) then
   270  
   271        xyz_CloudExtCoef =                             &
   272          &   aa_WatCloudExtCoefParams(1,l)            &
   273          & + aa_WatCloudExtCoefParams(2,l) / xyz_REff
   274  
   275        xyz_CloudCoAlb  =                               &
   276          &   aa_WatCloudCoAlbParams(1,l)               &
   277          & + aa_WatCloudCoAlbParams(2,l) * xyz_REff    &
   278          & + aa_WatCloudCoAlbParams(3,l) * xyz_REff**2
   279  
   280        xyz_CloudAF =                                &
   281          &   aa_WatCloudAFParams(1,l)               &
   282          & + aa_WatCloudAFParams(2,l) * xyz_REff    &
   283          & + aa_WatCloudAFParams(3,l) * xyz_REff**2
   284  
   285      else
   286        call MessageNotify( 'E', module_name, 'Unsupported specie, %c', c1 = trim( Spec ) )
   287      end if
   288  
   289  
   290    end subroutine RadC1998CalcCloudOptProp
   291  
   292    !--------------------------------------------------------------------------------------
   293  
   294    subroutine RadC1998Init
   295  
   296  
   297  !!$    ! NAMELIST ファイル入力に関するユーティリティ
   298  !!$    ! Utilities for NAMELIST file input
   299  !!$    !
   300  !!$    use namelist_util, only: namelist_filename, NmlutilMsg
   301  
   302      ! ファイル入出力補助
   303      ! File I/O support
   304      !
   305      use dc_iounit, only: FileOpen
   306  
   307  !!$    ! ヒストリデータ出力
   308  !!$    ! History data output
   309  !!$    !
   310  !!$    use gtool_historyauto, only: HistoryAutoAddVariable
   311  
   312  
   313  !!$    integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号.
   314  !!$                              ! Unit number for NAMELIST file open
   315  !!$    integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT.
   316  !!$                              ! IOSTAT of NAMELIST read
   317  
   318      integer :: l
   319  
   320  
   321  !!$    ! NAMELIST 変数群
   322  !!$    ! NAMELIST group name
   323  !!$    !
   324  !!$    namelist /rad_C1998_nml/ !&
   325  !!$      & ShortAtmosAlbedo
   326  !!$          !
   327  !!$          ! デフォルト値については初期化手続 "rad_C1998#RadC1998Init"
   328  !!$          ! のソースコードを参照のこと.
   329  !!$          !
   330  !!$          ! Refer to source codes in the initialization procedure
   331  !!$          ! "rad_LH74#RadLH74Init" for the default values.
   332  !!$          !
   333  
   334  
   335      if ( rad_c1998_inited ) return
   336  
   337  
   338      ! デフォルト値の設定
   339      ! Default values settings
   340      !
   341  
   342  !!$    ! NAMELIST の読み込み
   343  !!$    ! NAMELIST is input
   344  !!$    !
   345  !!$    if ( trim(namelist_filename) /= '' ) then
   346  !!$      call FileOpen( unit_nml, &          ! (out)
   347  !!$        & namelist_filename, mode = 'r' ) ! (in)
   348  !!$
   349  !!$      rewind( unit_nml )
   350  !!$      read( unit_nml,                     & ! (in)
   351  !!$        & nml = rad_C1998_nml,      & ! (out)
   352  !!$        & iostat = iostat_nml )             ! (out)
   353  !!$      close( unit_nml )
   354  !!$
   355  !!$      call NmlutilMsg( iostat_nml, module_name ) ! (in)
   356  !!$    end if
   357  
   358  
   359      do l = 1, nband1 + nband2
   360        ! from g-1 m2 to kg-1 m2
   361        aa_WatCloudExtCoefParams(1,l) = aa_WatCloudExtCoefParams(1,l) * 1.0d3
   362        aa_IceCloudExtCoefParams(1,l) = aa_IceCloudExtCoefParams(1,l) * 1.0d3
   363        ! from g-1 m2 micron to kg-1 m2 m
   364        aa_WatCloudExtCoefParams(2,l) = aa_WatCloudExtCoefParams(2,l) * 1.0d3 * 1.0d-6
   365        aa_IceCloudExtCoefParams(2,l) = aa_IceCloudExtCoefParams(2,l) * 1.0d3 * 1.0d-6
   366  
   367        ! from micron-1 to m-1
   368        aa_WatCloudCoAlbParams  (2,l) = aa_WatCloudCoAlbParams  (2,l) * 1.0d6
   369        aa_IceCloudCoAlbParams  (2,l) = aa_IceCloudCoAlbParams  (2,l) * 1.0d6
   370        ! from micron-2 to m-2
   371        aa_WatCloudCoAlbParams  (3,l) = aa_WatCloudCoAlbParams  (3,l) * 1.0d12
   372        aa_IceCloudCoAlbParams  (3,l) = aa_IceCloudCoAlbParams  (3,l) * 1.0d12
   373  
   374        ! from micron-1 to m-1
   375        aa_WatCloudAFParams     (2,l) = aa_WatCloudAFParams     (2,l) * 1.0d6
   376        aa_IceCloudAFParams     (2,l) = aa_IceCloudAFParams     (2,l) * 1.0d6
   377        ! from micron-2 to m-2
   378        aa_WatCloudAFParams     (3,l) = aa_WatCloudAFParams     (3,l) * 1.0d6
   379        aa_IceCloudAFParams     (3,l) = aa_IceCloudAFParams     (3,l) * 1.0d6
   380      end do
     .  !cdir nodep                                                             
     .        do l = 1, 11                                                      
     .           aa_watcloudextcoefparams(1,l) = aa_watcloudextcoefparams(1,l)* 
     .       1      1.00000000000000e+003                                       
     .           aa_icecloudextcoefparams(1,l) = aa_icecloudextcoefparams(1,l)* 
     .       1      1.00000000000000e+003                                       
     .           aa_watcloudextcoefparams(2,l) = (1.00000000000000e+003*        
     .       1      9.99999999999999e-007)*aa_watcloudextcoefparams(2,l)        
     .           aa_icecloudextcoefparams(2,l) = (1.00000000000000e+003*        
     .       1      9.99999999999999e-007)*aa_icecloudextcoefparams(2,l)        
     .           aa_watcloudcoalbparams(2,l) = aa_watcloudcoalbparams(2,l)*     
     .       1      1.00000000000000e+006                                       
     .           aa_icecloudcoalbparams(2,l) = aa_icecloudcoalbparams(2,l)*     
     .       1      1.00000000000000e+006                                       
     .           aa_watcloudcoalbparams(3,l) = aa_watcloudcoalbparams(3,l)*     
     .       1      1.00000000000000e+012                                       
     .           aa_icecloudcoalbparams(3,l) = aa_icecloudcoalbparams(3,l)*     
     .       1      1.00000000000000e+012                                       
     .           aa_watcloudafparams(2,l) = aa_watcloudafparams(2,l)*           
     .       1      1.00000000000000e+006                                       
     .           aa_icecloudafparams(2,l) = aa_icecloudafparams(2,l)*           
     .       1      1.00000000000000e+006                                       
     .           aa_watcloudafparams(3,l) = aa_watcloudafparams(3,l)*           
     .       1      1.00000000000000e+006                                       
     .           aa_icecloudafparams(3,l) = aa_icecloudafparams(3,l)*           
     .       1      1.00000000000000e+006                                       
     .        enddo                                                             
   381  
   382  
   383      ! 印字 ; Print
   384      !
   385      call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   386  !!$    call MessageNotify( 'M', module_name, 'ShortAtmosAlbedo = %f', d = (/ ShortAtmosAlbedo /) )
   387      call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   388  
   389  
   390      rad_c1998_inited = .true.
   391  
   392    end subroutine RadC1998Init
   393  
   394    !--------------------------------------------------------------------------------------
   395  
   396  end module rad_C1998
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:50 2016
FILE NAME: rad_C1998.f90
PROGRAM NAME: rad_c1998
FORMAT LIST

  LINE    LOOP      FORTRAN STATEMENT

     1:             != Chou et al (1998) による短波放射用雲モデル
     2:             !
     3:             != Cloud model for short wave radiation model described by Chou et al (1998)
     4:             !
     5:             ! Authors::   Yoshiyuki O. Takahashi
     6:             ! Version::   $Id: rad_C1998.f90,v 1.4 2011/11/30 03:44:09 yot Exp $
     7:             ! Tag Name::  $Name:  $
     8:             ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9:             ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10:             !
    11:             
    12:             module rad_C1998
    13:               !
    14:               != Chou et al (1998) による短波放射用雲モデル
    15:               !
    16:               != Cloud model for short wave radiation model described by Chou et al (1998)
    17:               !
    18:               ! <b>Note that Japanese and English are described in parallel.</b>
    19:               !
    20:               ! 短波放射モデル.
    21:               !
    22:               ! This is a model of short wave radiation. 
    23:               !
    24:               !== References
    25:               !
    26:               !  Chou, M.-D., M. J. Suarez, C.-H. Ho, M. M.-H. Yan, and K.-T. Lee, 
    27:               !    Parameterizations for cloud overlapping and shortwave single-scattering 
    28:               !    properties for use in general circulation and cloud ensemble models, 
    29:               !    J. Climate, 11, 202-214, 1998.
    30:               !
    31:               !== Procedures List
    32:               !
    33:             !!$  ! RadiationFluxDennouAGCM :: 放射フラックスの計算
    34:             !!$  ! RadiationDTempDt        :: 放射フラックスによる温度変化の計算
    35:             !!$  ! RadiationFluxOutput     :: 放射フラックスの出力
    36:             !!$  ! RadiationFinalize       :: 終了処理 (モジュール内部の変数の割り付け解除)
    37:             !!$  ! ------------            :: ------------
    38:             !!$  ! RadiationFluxDennouAGCM :: Calculate radiation flux
    39:             !!$  ! RadiationDTempDt        :: Calculate temperature tendency with radiation flux
    40:             !!$  ! RadiationFluxOutput     :: Output radiation fluxes
    41:             !!$  ! RadiationFinalize       :: Termination (deallocate variables in this module)
    42:               !
    43:               !== NAMELIST
    44:               !
    45:             !!$  ! NAMELIST#radiation_DennouAGCM_nml
    46:               !
    47:             
    48:               ! USE statements
    49:               !
    50:             
    51:               ! 
    52:               ! Kind type parameter
    53:               !
    54:               use dc_types, only: DP, &      ! Double precision.
    55:                 &                 STRING, &  ! Strings.
    56:                 &                 TOKEN      ! Keywords.
    57:             
    58:               ! メッセージ出力
    59:               ! Message output
    60:               !
    61:               use dc_message, only: MessageNotify
    62:             
    63:               !
    64:               ! Grid points settings
    65:               !
    66:               use gridset, only: imax, & !
    67:                                          ! Number of grid points in longitude
    68:                 &                jmax, & !
    69:                                          ! Number of grid points in latitude
    70:                 &                kmax    !
    71:                                          ! Number of vertical level
    72:             
    73:               ! Declaration statements
    74:               !
    75:               implicit none
    76:               private
    77:             
    78:               !
    79:               ! Public procedure
    80:               !
    81:               public :: RadC1998CalcCloudOptProp
    82:               public :: RadC1998Init
    83:             
    84:             
    85:               integer , parameter :: nband1 = 8  ! * 14500 to 57143 cm-1 (0.175 to 0.70 micron)
    86:               integer , parameter :: nband2 = 3  ! *  2600 to 14500 cm-1 (0.70-10 micron)
    87:             
    88:               real(DP), save      :: aa_WatCloudExtCoefParams(1:2, 1:nband1+nband2)
    89:               real(DP), save      :: aa_WatCloudCoAlbParams  (1:3, 1:nband1+nband2)
    90:               real(DP), save      :: aa_WatCloudAFParams     (1:3, 1:nband1+nband2)
    91:               real(DP), save      :: aa_IceCloudExtCoefParams(1:2, 1:nband1+nband2)
    92:               real(DP), save      :: aa_IceCloudCoAlbParams  (1:3, 1:nband1+nband2)
    93:               real(DP), save      :: aa_IceCloudAFParams     (1:3, 1:nband1+nband2)
    94:             
    95:             
    96:               logical , save     :: rad_c1998_inited
    97:             
    98:               data rad_c1998_inited /.false./
    99:             
   100:             
   101:             
   102:               ! Table 2.
   103:               data aa_WatCloudExtCoefParams &
   104:                 & / &
   105:                 !   a0       a1
   106:                 &   -6.59d-3,  1.65d0, & ! 1(1)
   107:                 &   -6.59d-3,  1.65d0, & ! 2(1)
   108:                 &   -6.59d-3,  1.65d0, & ! 3(1)
   109:                 &   -6.59d-3,  1.65d0, & ! 4(1)
   110:                 &   -6.59d-3,  1.65d0, & ! 5(1)
   111:                 &   -6.59d-3,  1.65d0, & ! 6(1)
   112:                 &   -6.59d-3,  1.65d0, & ! 7(1)
   113:                 &   -6.59d-3,  1.65d0, & ! 8(1)
   114:                 &   -1.01d-2,  1.72d0, & ! 9
   115:                 &   -1.66d-2,  1.85d0, & !10
   116:                 &   -3.39d-2,  2.16d0  & !11
   117:                 & /
   118:             
   119:             
   120:               ! Table 3.
   121:               data aa_WatCloudCoAlbParams &
   122:                 & / &
   123:                 !    b0       b1        b2
   124:                 &    0.0d0  , 0.0d0  ,  0.0d0  , & ! 1
   125:                 &    0.0d0  , 0.0d0  ,  0.0d0  , & ! 2
   126:                 &    0.0d0  , 0.0d0  ,  0.0d0  , & ! 3
   127:                 &    0.0d0  , 0.0d0  ,  0.0d0  , & ! 4
   128:                 &    0.0d0  , 0.0d0  ,  0.0d0  , & ! 5
   129:                 &    0.0d0  , 0.0d0  ,  0.0d0  , & ! 6
   130:                 &    0.0d0  , 0.0d0  ,  0.0d0  , & ! 7
   131:                 &    0.0d0  , 0.0d0  ,  0.0d0  , & ! 8
   132:                 &    7.15d-8, 8.45d-6, -4.15d-8, & ! 1
   133:                 &   -1.99d-4, 8.88d-4, -6.50d-6, & !10
   134:                 &    1.21d-2, 1.79d-2, -3.69d-4  & !11
   135:                 & /
   136:             
   137:               ! Table 4.
   138:               data aa_WatCloudAFParams &
   139:                 & / &
   140:                 !    c0       c1       c2
   141:                 &    8.26d-1, 5.29d-3, -1.49d-6, & ! 1
   142:                 &    8.26d-1, 5.29d-3, -1.49d-6, & ! 2
   143:                 &    8.26d-1, 5.29d-3, -1.49d-6, & ! 3
   144:                 &    8.26d-1, 5.29d-3, -1.49d-6, & ! 4
   145:                 &    8.26d-1, 5.29d-3, -1.49d-6, & ! 5
   146:                 &    8.26d-1, 5.29d-3, -1.49d-6, & ! 6
   147:                 &    8.26d-1, 5.29d-3, -1.49d-6, & ! 7
   148:                 &    8.26d-1, 5.29d-3, -1.49d-6, & ! 8
   149:                 &    7.94d-1, 8.32d-3, -2.33d-4, & ! 9
   150:                 &    7.45d-1, 1.37d-2, -3.82d-4, & !10
   151:                 &    8.35d-1, 2.57d-3,  5.52d-5  & !11
   152:                 & /
   153:             
   154:             
   155:               data aa_IceCloudExtCoefParams &
   156:                 & / &
   157:                 !   a0       a1
   158:                 &   3.33d-3, 2.52d0, & ! 1
   159:                 &   3.33d-3, 2.52d0, & ! 2
   160:                 &   3.33d-3, 2.52d0, & ! 3
   161:                 &   3.33d-3, 2.52d0, & ! 4
   162:                 &   3.33d-3, 2.52d0, & ! 5
   163:                 &   3.33d-3, 2.52d0, & ! 6
   164:                 &   3.33d-3, 2.52d0, & ! 7
   165:                 &   3.33d-3, 2.52d0, & ! 8
   166:                 &   3.33d-3, 2.52d0, & ! 9
   167:                 &   3.33d-3, 2.52d0, & !10
   168:                 &   3.33d-3, 2.52d0  & !11
   169:                 & /
   170:             
   171:               ! Table 3.
   172:               data aa_IceCloudCoAlbParams &
   173:                 & / &
   174:                 !    b0       b1        b2
   175:                 &    0.0d0  , 0.0d0  ,  0.0d0  , & ! 1
   176:                 &    0.0d0  , 0.0d0  ,  0.0d0  , & ! 2
   177:                 &    0.0d0  , 0.0d0  ,  0.0d0  , & ! 3
   178:                 &    0.0d0  , 0.0d0  ,  0.0d0  , & ! 4
   179:                 &    0.0d0  , 0.0d0  ,  0.0d0  , & ! 5
   180:                 &    0.0d0  , 0.0d0  ,  0.0d0  , & ! 6
   181:                 &    0.0d0  , 0.0d0  ,  0.0d0  , & ! 7
   182:                 &    0.0d0  , 0.0d0  ,  0.0d0  , & ! 8
   183:                 &   -2.60d-6, 7.46d-6,  0.0d0  , & ! 9
   184:                 &    2.15d-3, 7.37d-4, -1.34d-6, & !10
   185:                 &    8.94d-2, 2.99d-3, -1.04d-5  & !11
   186:                 & /
   187:             
   188:               ! Table 4.
   189:               data aa_IceCloudAFParams &
   190:                 & / &
   191:                 !    c0       c1       c2
   192:                 &    7.46d-1, 1.05d-3, -2.64d-6, & ! 1
   193:                 &    7.46d-1, 1.05d-3, -2.64d-6, & ! 2
   194:                 &    7.46d-1, 1.05d-3, -2.64d-6, & ! 3
   195:                 &    7.46d-1, 1.05d-3, -2.64d-6, & ! 4
   196:                 &    7.46d-1, 1.05d-3, -2.64d-6, & ! 5
   197:                 &    7.46d-1, 1.05d-3, -2.64d-6, & ! 6
   198:                 &    7.46d-1, 1.05d-3, -2.64d-6, & ! 7
   199:                 &    7.46d-1, 1.05d-3, -2.64d-6, & ! 8
   200:                 &    7.49d-1, 1.20d-3, -3.67d-6, & ! 9
   201:                 &    7.61d-1, 1.42d-3, -3.96d-6, & !10
   202:                 &    8.41d-1, 1.26d-3, -3.85d-6  & !11
   203:                 & /
   204:             
   205:             
   206:               character(*), parameter:: module_name = 'rad_C1998'
   207:                                           ! モジュールの名称.
   208:                                           ! Module name
   209:               character(*), parameter:: version = &
   210:                 & '$Name:  $' // &
   211:                 & '$Id: rad_C1998.f90,v 1.4 2011/11/30 03:44:09 yot Exp $'
   212:                                           ! モジュールのバージョン
   213:                                           ! Module version
   214:             
   215:             contains
   216:             
   217:               !--------------------------------------------------------------------------------------
   218:             
   219:               subroutine RadC1998CalcCloudOptProp(               &
   220:                 & Spec, iband, xyz_REff,                         & ! (in )
   221:                 & xyz_CloudExtCoef, xyz_CloudCoAlb, xyz_CloudAF  & ! (out)
   222:                 & )
   223:             
   224:             
   225:                 ! USE statements
   226:                 !
   227:             
   228:                 character(len=*), intent(in ) :: SPEC
   229:                 integer         , intent(in ) :: iband
   230:                 real(DP)        , intent(in ) :: xyz_REff        (0:imax-1, 1:jmax, 1:kmax)
   231:                 real(DP)        , intent(out) :: xyz_CloudExtCoef(0:imax-1, 1:jmax, 1:kmax)
   232:                 real(DP)        , intent(out) :: xyz_CloudCoAlb  (0:imax-1, 1:jmax, 1:kmax)
   233:                 real(DP)        , intent(out) :: xyz_CloudAF     (0:imax-1, 1:jmax, 1:kmax)
   234:             
   235:             
   236:             
   237:                 !
   238:                 ! Work variables
   239:                 !
   240:                 integer :: l
   241:             
   242:             
   243:                 ! 初期化確認
   244:                 ! Initialization check
   245:                 !
   246:                 if ( .not. rad_c1998_inited ) then
   247:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   248:                 end if
   249:             
   250:             
   251:                 l = iband
   252:             
   253:                 if ( Spec == 'Ice' ) then
   254:             
   255: **V---->A         xyz_CloudExtCoef =                         &
   256: |||                 &   aa_IceCloudExtCoefParams(1,l)        &
   257: |||                 & + aa_IceCloudExtCoefParams(2,l) / xyz_REff
   258: |||         
   259: |||     A         xyz_CloudCoAlb  =                               &
   260: |||                 &   aa_IceCloudCoAlbParams(1,l)               &
   261: |||                 & + aa_IceCloudCoAlbParams(2,l) * xyz_REff    &
   262: |||                 & + aa_IceCloudCoAlbParams(3,l) * xyz_REff**2
   263: |||         
   264: **V---- A         xyz_CloudAF =                                &
   265:                     &   aa_IceCloudAFParams(1,l)               &
   266:                     & + aa_IceCloudAFParams(2,l) * xyz_REff    &
   267:                     & + aa_IceCloudAFParams(3,l) * xyz_REff**2
   268:             
   269:                 else if ( Spec == 'Liquid' ) then
   270:             
   271: **V---->A         xyz_CloudExtCoef =                             &
   272: |||                 &   aa_WatCloudExtCoefParams(1,l)            &
   273: |||                 & + aa_WatCloudExtCoefParams(2,l) / xyz_REff
   274: |||         
   275: |||     A         xyz_CloudCoAlb  =                               &
   276: |||                 &   aa_WatCloudCoAlbParams(1,l)               &
   277: |||                 & + aa_WatCloudCoAlbParams(2,l) * xyz_REff    &
   278: |||                 & + aa_WatCloudCoAlbParams(3,l) * xyz_REff**2
   279: |||         
   280: **V---- A         xyz_CloudAF =                                &
   281:                     &   aa_WatCloudAFParams(1,l)               &
   282:                     & + aa_WatCloudAFParams(2,l) * xyz_REff    &
   283:                     & + aa_WatCloudAFParams(3,l) * xyz_REff**2
   284:             
   285:                 else
   286:                   call MessageNotify( 'E', module_name, 'Unsupported specie, %c', c1 = trim( Spec ) )
   287:                 end if
   288:             
   289:             
   290:               end subroutine RadC1998CalcCloudOptProp
   291:             
   292:               !--------------------------------------------------------------------------------------
   293:             
   294:               subroutine RadC1998Init
   295:             
   296:             
   297:             !!$    ! NAMELIST ファイル入力に関するユーティリティ
   298:             !!$    ! Utilities for NAMELIST file input
   299:             !!$    !
   300:             !!$    use namelist_util, only: namelist_filename, NmlutilMsg
   301:             
   302:                 ! ファイル入出力補助
   303:                 ! File I/O support
   304:                 !
   305:                 use dc_iounit, only: FileOpen
   306:             
   307:             !!$    ! ヒストリデータ出力
   308:             !!$    ! History data output
   309:             !!$    !
   310:             !!$    use gtool_historyauto, only: HistoryAutoAddVariable
   311:             
   312:             
   313:             !!$    integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号.
   314:             !!$                              ! Unit number for NAMELIST file open
   315:             !!$    integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT.
   316:             !!$                              ! IOSTAT of NAMELIST read
   317:             
   318:                 integer :: l
   319:             
   320:             
   321:             !!$    ! NAMELIST 変数群
   322:             !!$    ! NAMELIST group name
   323:             !!$    !
   324:             !!$    namelist /rad_C1998_nml/ !&
   325:             !!$      & ShortAtmosAlbedo
   326:             !!$          !
   327:             !!$          ! デフォルト値については初期化手続 "rad_C1998#RadC1998Init"
   328:             !!$          ! のソースコードを参照のこと.
   329:             !!$          !
   330:             !!$          ! Refer to source codes in the initialization procedure
   331:             !!$          ! "rad_LH74#RadLH74Init" for the default values.
   332:             !!$          !
   333:             
   334:             
   335:                 if ( rad_c1998_inited ) return
   336:             
   337:             
   338:                 ! デフォルト値の設定
   339:                 ! Default values settings
   340:                 !
   341:             
   342:             !!$    ! NAMELIST の読み込み
   343:             !!$    ! NAMELIST is input
   344:             !!$    !
   345:             !!$    if ( trim(namelist_filename) /= '' ) then
   346:             !!$      call FileOpen( unit_nml, &          ! (out)
   347:             !!$        & namelist_filename, mode = 'r' ) ! (in)
   348:             !!$
   349:             !!$      rewind( unit_nml )
   350:             !!$      read( unit_nml,                     & ! (in)
   351:             !!$        & nml = rad_C1998_nml,      & ! (out)
   352:             !!$        & iostat = iostat_nml )             ! (out)
   353:             !!$      close( unit_nml )
   354:             !!$
   355:             !!$      call NmlutilMsg( iostat_nml, module_name ) ! (in)
   356:             !!$    end if
   357:             
   358:             
   359: V------>        do l = 1, nband1 + nband2
   360: |                 ! from g-1 m2 to kg-1 m2
   361: |       A         aa_WatCloudExtCoefParams(1,l) = aa_WatCloudExtCoefParams(1,l) * 1.0d3
   362: |       A         aa_IceCloudExtCoefParams(1,l) = aa_IceCloudExtCoefParams(1,l) * 1.0d3
   363: |                 ! from g-1 m2 micron to kg-1 m2 m
   364: |       A         aa_WatCloudExtCoefParams(2,l) = aa_WatCloudExtCoefParams(2,l) * 1.0d3 * 1.0d-6
   365: |       A         aa_IceCloudExtCoefParams(2,l) = aa_IceCloudExtCoefParams(2,l) * 1.0d3 * 1.0d-6
   366: |           
   367: |                 ! from micron-1 to m-1
   368: |       A         aa_WatCloudCoAlbParams  (2,l) = aa_WatCloudCoAlbParams  (2,l) * 1.0d6
   369: |       A         aa_IceCloudCoAlbParams  (2,l) = aa_IceCloudCoAlbParams  (2,l) * 1.0d6
   370: |                 ! from micron-2 to m-2
   371: |       A         aa_WatCloudCoAlbParams  (3,l) = aa_WatCloudCoAlbParams  (3,l) * 1.0d12
   372: |       A         aa_IceCloudCoAlbParams  (3,l) = aa_IceCloudCoAlbParams  (3,l) * 1.0d12
   373: |           
   374: |                 ! from micron-1 to m-1
   375: |       A         aa_WatCloudAFParams     (2,l) = aa_WatCloudAFParams     (2,l) * 1.0d6
   376: |       A         aa_IceCloudAFParams     (2,l) = aa_IceCloudAFParams     (2,l) * 1.0d6
   377: |       A         ! from micron-2 to m-2
   378: |       A         aa_WatCloudAFParams     (3,l) = aa_WatCloudAFParams     (3,l) * 1.0d6
   379: |       A         aa_IceCloudAFParams     (3,l) = aa_IceCloudAFParams     (3,l) * 1.0d6
   380: V------         end do
   381:             
   382:             
   383:                 ! 印字 ; Print
   384:                 !
   385:                 call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   386:             !!$    call MessageNotify( 'M', module_name, 'ShortAtmosAlbedo = %f', d = (/ ShortAtmosAlbedo /) )
   387:                 call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   388:             
   389:             
   390:                 rad_c1998_inited = .true.
   391:             
   392:               end subroutine RadC1998Init
   393:             
   394:               !--------------------------------------------------------------------------------------
   395:             
   396:             end module rad_C1998
