Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:52 2016
FILE NAME: rad_C2001.f90
PROGRAM NAME: rad_c2001
DIAGNOSTIC LIST

  LINE  LEVEL( NO.): DIAGNOSTIC MESSAGE

   546  opt  (  11): Fused array assignments. :line 546 - 550
   546  opt  (1593): Loop nest collapsed into one loop.
   546  vec  (   4): Vectorized array expression.
   546  vec  (  29): ADB is used for array.: xyz_af
   546  vec  (  29): ADB is used for array.: xyz_ssa
   546  vec  (  29): ADB is used for array.: xyz_extcoef
   546  vec  (  29): ADB is used for array.: xyz_reff
   554  opt  (  11): Fused array assignments. :line 554 - 558
   554  opt  (1593): Loop nest collapsed into one loop.
   554  vec  (   4): Vectorized array expression.
   554  vec  (  29): ADB is used for array.: xyz_extcoef
   559  vec  (   3): Unvectorized loop.
   561  opt  (  11): Fused array assignments. :line 561 - 563
   561  opt  (1593): Loop nest collapsed into one loop.
   561  vec  (   4): Vectorized array expression.
   561  vec  (  29): ADB is used for array.: xyz_af
   561  vec  (  29): ADB is used for array.: xyz_ssa
   561  vec  (  29): ADB is used for array.: xyz_reffinmicron
   566  vec  (   3): Unvectorized loop.
   568  opt  (1593): Loop nest collapsed into one loop.
   568  vec  (   4): Vectorized array expression.
   568  vec  (  29): ADB is used for array.: xyz_extcoef
   568  vec  (  29): ADB is used for array.: xyz_reffinmicron
   571  opt  (1593): Loop nest collapsed into one loop.
   571  vec  (   4): Vectorized array expression.
   571  vec  (  29): ADB is used for array.: xyz_extcoef
   572  vec  (   3): Unvectorized loop.
   574  opt  (  11): Fused array assignments. :line 574 - 576
   574  opt  (1593): Loop nest collapsed into one loop.
   574  vec  (   4): Vectorized array expression.
   574  vec  (  29): ADB is used for array.: xyz_af
   574  vec  (  29): ADB is used for array.: xyz_ssa
   574  vec  (  29): ADB is used for array.: xyz_reffinmicron
   623  opt  (1593): Loop nest collapsed into one loop.
   623  vec  (   4): Vectorized array expression.
   624  vec  (   3): Unvectorized loop.
   625  opt  (1593): Loop nest collapsed into one loop.
   625  vec  (   4): Vectorized array expression.
   625  vec  (  29): ADB is used for array.: xyz_funcf
   625  vec  (  29): ADB is used for array.: xyz_af
   630  opt  (1593): Loop nest collapsed into one loop.
   630  vec  (   4): Vectorized array expression.
   630  vec  (  29): ADB is used for array.: xyz_deloptdep
   630  vec  (  29): ADB is used for array.: xyz_funcf
   630  vec  (  29): ADB is used for array.: xyz_ssa
   671  opt  (1593): Loop nest collapsed into one loop.
   671  vec  (   4): Vectorized array expression.
   671  vec  (  29): ADB is used for array.: xyrr_trans
   675  opt  (1017): Subroutine call prevents optimization.
   682  vec  (   3): Unvectorized loop.
   682  vec  (  13): Overhead of loop division is too large.
   684  opt  (1592): Outer loop unrolled inside inner loop.
   684  vec  (   4): Vectorized array expression.
   684  vec  (  29): ADB is used for array.: xyrr_trans
   684  vec  (   4): Vectorized array expression.
   684  vec  (  29): ADB is used for array.: xyrr_trans
   686  opt  (1593): Loop nest collapsed into one loop.
   686  vec  (   4): Vectorized array expression.
   686  vec  (  29): ADB is used for array.: xyrr_trans
   686  vec  (  29): ADB is used for array.: xyrr_transeach
   732  opt  (1593): Loop nest collapsed into one loop.
   732  vec  (   4): Vectorized array expression.
   732  vec  (  29): ADB is used for array.: xyrr_trans
   735  opt  (1017): Subroutine call prevents optimization.
   749  vec  (   3): Unvectorized loop.
   749  vec  (  13): Overhead of loop division is too large.
   751  opt  (1592): Outer loop unrolled inside inner loop.
   751  vec  (   4): Vectorized array expression.
   751  vec  (  29): ADB is used for array.: xyrr_trans
   751  vec  (   4): Vectorized array expression.
   751  vec  (  29): ADB is used for array.: xyrr_trans
   753  opt  (1593): Loop nest collapsed into one loop.
   753  vec  (   4): Vectorized array expression.
   753  vec  (  29): ADB is used for array.: xyrr_trans
   753  vec  (  29): ADB is used for array.: xyrr_transline
   753  vec  (  29): ADB is used for array.: xyrr_transcont
   837  vec  (   4): Vectorized array expression.
   837  vec  (  29): ADB is used for array.: aa_bandh2olineparams
   858  vec  (   4): Vectorized array expression.
   858  vec  (  29): ADB is used for array.: aa_subbandh2olineparams
   868  vec  (   4): Vectorized array expression.
   868  vec  (  29): ADB is used for array.: aa_subbandco2lineparams
   878  vec  (   4): Vectorized array expression.
   878  vec  (  29): ADB is used for array.: aa_bandn2olineparams
   888  vec  (   4): Vectorized array expression.
   888  vec  (  29): ADB is used for array.: aa_bandch4lineparams
   898  vec  (   4): Vectorized array expression.
   898  vec  (  29): ADB is used for array.: aa_weakbandco2lineparams
   905  opt  (1592): Outer loop unrolled inside inner loop.
   905  vec  (   4): Vectorized array expression.
   905  vec  (  29): ADB is used for array.: xyrr_trans
   905  vec  (   4): Vectorized array expression.
   905  vec  (  29): ADB is used for array.: xyrr_trans
   924  opt  (1593): Loop nest collapsed into one loop.
   924  vec  (   4): Vectorized array expression.
   924  vec  (  29): ADB is used for array.: xyz_delabsmassscaled
   928  opt  (1593): Loop nest collapsed into one loop.
   928  vec  (   4): Vectorized array expression.
   929  vec  (   3): Unvectorized loop.
   929  vec  (  13): Overhead of loop division is too large.
   930  opt  (1037): Feedback of array elements.
   930  opt  (1593): Loop nest collapsed into one loop.
   930  vec  (   4): Vectorized array expression.
   930  vec  (  29): ADB is used for array.: xyrr_transelem
   937  vec  (   3): Unvectorized loop.
   937  vec  (  13): Overhead of loop division is too large.
   938  opt  (1593): Loop nest collapsed into one loop.
   938  vec  (   4): Vectorized array expression.
   938  vec  (  29): ADB is used for array.: xyrr_trans
   950  vec  (   3): Unvectorized loop.
   950  vec  (  13): Overhead of loop division is too large.
   951  opt  (1593): Loop nest collapsed into one loop.
   951  vec  (   4): Vectorized array expression.
   951  vec  (  29): ADB is used for array.: xyrr_trans
   951  vec  (  29): ADB is used for array.: xyrr_transelem
   959  vec  (   3): Unvectorized loop.
   959  vec  (  13): Overhead of loop division is too large.
   960  opt  (1019): Feedback of scalar value from one loop pass to another.
   960  opt  (1593): Loop nest collapsed into one loop.
   960  vec  (   4): Vectorized array expression.
   960  vec  (  29): ADB is used for array.: xyrr_transelem
   969  vec  (   3): Unvectorized loop.
   969  vec  (  13): Overhead of loop division is too large.
   971  opt  (1593): Loop nest collapsed into one loop.
   971  vec  (   4): Vectorized array expression.
   971  vec  (  29): ADB is used for array.: xyrr_trans
   975  vec  (   3): Unvectorized loop.
   975  vec  (  13): Overhead of loop division is too large.
   976  opt  (1036): Potential feedback - use directive if OK.
   976  opt  (1593): Loop nest collapsed into one loop.
   976  vec  (   4): Vectorized array expression.
   976  vec  (  29): ADB is used for array.: xyrr_trans
  1017  opt  (  11): Fused array assignments. :line 1017 - 1018
  1017  opt  (1593): Loop nest collapsed into one loop.
  1017  vec  (   4): Vectorized array expression.
  1017  vec  (  29): ADB is used for array.: xyz_contdelabsmassscaled
  1017  vec  (  29): ADB is used for array.: xyz_temp
  1017  vec  (  29): ADB is used for array.: xyz_delabsmass
  1017  vec  (  29): ADB is used for array.: xyz_qh2ovap
  1017  vec  (  29): ADB is used for array.: xyz_press
  1063  opt  (1593): Loop nest collapsed into one loop.
  1063  vec  (   4): Vectorized array expression.
  1063  vec  (  29): ADB is used for array.: xyz_delabsmassscaled
  1063  vec  (  29): ADB is used for array.: xyz_temp
  1063  vec  (  29): ADB is used for array.: xyz_press
  1063  vec  (  29): ADB is used for array.: xyz_delabsmass
  1112  vec  (   3): Unvectorized loop.
  1115  opt  (1017): Subroutine call prevents optimization.
  1115  vec  (  10): Vectorization obstructive procedure reference.:messagenotifyc
  1134  opt  (1593): Loop nest collapsed into one loop.
  1134  vec  (   4): Vectorized array expression.
  1134  vec  (  29): ADB is used for array.: xyz_integpf
  1135  vec  (   3): Unvectorized loop.
  1135  vec  (  13): Overhead of loop division is too large.
  1136  opt  (1593): Loop nest collapsed into one loop.
  1136  vec  (   4): Vectorized array expression.
  1136  vec  (  29): ADB is used for array.: xyz_integpf
  1136  vec  (  29): ADB is used for array.: xyz_temp
  1142  opt  (1593): Loop nest collapsed into one loop.
  1142  vec  (   4): Vectorized array expression.
  1142  vec  (  29): ADB is used for array.: xyz_integpf
  1143  vec  (   3): Unvectorized loop.
  1144  opt  (1593): Loop nest collapsed into one loop.
  1144  vec  (   4): Vectorized array expression.
  1144  vec  (  29): ADB is used for array.: xyz_integpf
  1144  vec  (  29): ADB is used for array.: xyz_temp
  1183  opt  (1593): Loop nest collapsed into one loop.
  1183  vec  (   4): Vectorized array expression.
  1183  vec  (  29): ADB is used for array.: xyz_temp
  1183  vec  (  29): ADB is used for array.: xy_temp
  1191  opt  (1593): Loop nest collapsed into one loop.
  1191  vec  (   4): Vectorized array expression.
  1191  vec  (  29): ADB is used for array.: xy_integpf
  1191  vec  (  29): ADB is used for array.: xyz_integpf
  1243  vec  (   4): Vectorized array expression.
  1243  vec  (  29): ADB is used for array.: aa_bandwn
  1246  vec  (   1): Vectorized loop.
  1246  vec  (  29): ADB is used for array.: aa_bandh2ocontparams
  1246  vec  (  29): ADB is used for array.: aa_bandh2olineparams
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:52 2016
FILE NAME: rad_C2001.f90
PROGRAM NAME: rad_c2001
TRANSFORMATION LIST

  LINE                   FORTRAN STATEMENT

     1  != Chou et al. (2001) による長波放射モデル
     2  !
     3  != Long radiation model described by Chou et al. (2001)
     4  !
     5  ! Authors::   Yoshiyuki O. TAKAHASHI
     6  ! Version::   $Id: rad_C2001.f90,v 1.4 2013/01/27 11:31:14 yot Exp $
     7  ! Tag Name::  $Name:  $
     8  ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9  ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10  !
    11  
    12  module rad_C2001
    13    !
    14    != Chou et al. (2001) による長波放射モデル
    15    !
    16    != Long radiation model described by Chou et al. (2001)
    17    !
    18    ! <b>Note that Japanese and English are described in parallel.</b>
    19    !
    20    ! 長波放射モデル.
    21    !
    22    ! This is a model of long wave radiation.
    23    !
    24    !== References
    25    !
    26    !  Chou, M.-D., M. J. Suarez, X.-Z. Liang, and M. M.-H. Yan,
    27    !    A thermal infrared radiation parameterization for atmospheric studies,
    28    !    NASA Technical Report Series on Global Modeling and Data Assimilation,
    29    !    19, NASA/TM-2001-104606, 2001.
    30    !
    31    !== Procedures List
    32    !
    33  !!$  ! RadiationFluxDennouAGCM :: 放射フラックスの計算
    34  !!$  ! RadiationDTempDt        :: 放射フラックスによる温度変化の計算
    35  !!$  ! RadiationFluxOutput     :: 放射フラックスの出力
    36  !!$  ! RadiationFinalize       :: 終了処理 (モジュール内部の変数の割り付け解除)
    37  !!$  ! ------------            :: ------------
    38  !!$  ! RadiationFluxDennouAGCM :: Calculate radiation flux
    39  !!$  ! RadiationDTempDt        :: Calculate temperature tendency with radiation flux
    40  !!$  ! RadiationFluxOutput     :: Output radiation fluxes
    41  !!$  ! RadiationFinalize       :: Termination (deallocate variables in this module)
    42    !
    43    !== NAMELIST
    44    !
    45  !!$  ! NAMELIST#radiation_DennouAGCM_nml
    46    !
    47  
    48    ! USE statements
    49    !
    50  
    51    !
    52    ! Kind type parameter
    53    !
    54    use dc_types, only: DP, &      ! Double precision.
    55      &                 STRING, &  ! Strings.
    56      &                 TOKEN      ! Keywords.
    57  
    58    ! メッセージ出力
    59    ! Message output
    60    !
    61    use dc_message, only: MessageNotify
    62  
    63    !
    64    ! Grid points settings
    65    !
    66    use gridset, only: imax, & !
    67                               ! Number of grid points in longitude
    68      &                jmax, & !
    69                               ! Number of grid points in latitude
    70      &                kmax    !
    71                               ! Number of vertical level
    72  
    73    ! Declaration statements
    74    !
    75    implicit none
    76    private
    77  
    78  
    79    integer , parameter         :: nbmax = 10
    80  
    81    real(DP)             , save :: aa_BandWN              (1:2, 1:nbmax)
    82    real(DP)             , save :: aa_BandIntegPFCoefs    (0:5, 1:nbmax)
    83    real(DP)             , save :: aa_BandH2OSclParams    (1:5, 1:nbmax)
    84    real(DP)             , save :: aa_BandH2OLineParams   (1:8, 1:nbmax)
    85    real(DP)             , save :: aa_BandH2OContParams   (1:1, 1:nbmax)
    86  
    87    integer , parameter         :: nsbmax = 3
    88    real(DP)             , save :: aa_SubBandWN           (1:2, 1:nsbmax)
    89    real(DP)             , save :: aa_SubBandH2OSclParams (1:5, 1:nsbmax)
    90    real(DP)             , save :: aa_SubBandH2OLineParams(1:8, 1:nsbmax)
    91    real(DP)             , save :: aa_SubBandH2OContParams(1:1, 1:nsbmax)
    92    real(DP)             , save :: aa_SubBandCO2SclParams (1:5, 1:2)
    93    real(DP)             , save :: aa_SubBandCO2LineParams(1:8, 1:2)
    94  
    95    real(DP)             , save :: aa_BandN2OSclParams (1:5, 1:nbmax)
    96    real(DP)             , save :: aa_BandN2OLineParams(1:8, 1:nbmax)
    97    real(DP)             , save :: aa_BandCH4SclParams (1:5, 1:nbmax)
    98    real(DP)             , save :: aa_BandCH4LineParams(1:8, 1:nbmax)
    99  
   100    real(DP)             , save :: aa_WeakBandCO2SclParams (1:5, 1:nbmax)
   101    real(DP)             , save :: aa_WeakBandCO2LineParams(1:8, 1:nbmax)
   102  
   103    integer , parameter         :: ncloudparam = 4
   104    real(DP)             , save :: aa_BandCloudIceExtParams(1:ncloudparam, 1:nbmax)
   105    real(DP)             , save :: aa_BandCloudIceSSAParams(1:ncloudparam, 1:nbmax)
   106    real(DP)             , save :: aa_BandCloudIceAFParams (1:ncloudparam, 1:nbmax)
   107    real(DP)             , save :: aa_BandCloudLiqExtParams(1:ncloudparam, 1:nbmax)
   108    real(DP)             , save :: aa_BandCloudLiqSSAParams(1:ncloudparam, 1:nbmax)
   109    real(DP)             , save :: aa_BandCloudLiqAFParams (1:ncloudparam, 1:nbmax)
   110  
   111  
   112    ! MEMO:
   113    ! Bands range from 0 to 3000 cm-1.
   114    !
   115  
   116    ! Table 1
   117    !
   118    data aa_BandWN &
   119      & / &
   120      &    0.0d0,  340.0d0, & ! 1:H2O
   121      &  340.0d0,  540.0d0, & ! 2:H2O
   122      &  540.0d0,  800.0d0, & ! 3:H2O + CO2
   123      &  800.0d0,  980.0d0, & ! 4:H2O + CO2
   124      &  980.0d0, 1100.0d0, & ! 5:H2O + O3 + CO2
   125      & 1100.0d0, 1215.0d0, & ! 6:H2O + N2O + CH4
   126      & 1215.0d0, 1380.0d0, & ! 7:H2O + N2O + CH4
   127      & 1380.0d0, 1900.0d0, & ! 8:H2O
   128      & 1900.0d0, 3000.0d0, & ! 9:H2O
   129      &  540.0d0,  620.0d0  & !10:H2O + CO2 + N2O  ! This band is not used, now.
   130      & /
   131  
   132    ! Table 2
   133    !
   134    data aa_BandIntegPFCoefs &
   135      & / &
   136      ! c0         c1         c2         c3         c4         c5
   137      &  5.344e+0, -2.062e-1,  2.533e-3, -6.863e-6,  1.012e-8, -6.267e-12, & ! 1
   138      &  2.715e+1, -5.404e-1,  2.950e-3,  2.723e-7, -9.338e-9,  9.968e-12, & ! 2
   139      & -3.486e+1,  1.113e+0, -1.301e-2,  6.496e-5, -1.182e-7,  8.042e-11, & ! 3
   140      & -6.051e+1,  1.409e+0, -1.208e-2,  4.405e-5, -5.674e-8,  2.566e-11, & ! 4
   141      & -2.669e+1,  5.283e-1, -3.445e-3,  6.072e-6,  1.252e-8, -2.155e-11, & ! 5
   142      & -6.727e+0,  4.226e-2,  1.044e-3, -1.292e-5,  4.740e-8, -4.486e-11, & ! 6
   143      &  1.879e+1, -5.836e-1,  6.968e-3, -3.939e-5,  1.012e-7, -8.230e-11, & ! 7
   144      &  1.034e+2, -2.513e+0,  2.375e-2, -1.069e-4,  2.184e-7, -1.370e-10, & ! 8
   145      & -1.048e+1,  3.821e-1, -5.227e-3,  3.441e-5, -1.108e-7,  1.409e-10, & ! 9
   146      &  1.677e+0,  6.540e-2, -1.813e-3,  1.291e-5, -2.672e-8,  1.979e-11  & !10
   147      & /
   148  
   149  
   150    ! Table 3
   151    !
   152    data aa_BandH2OSclParams &
   153      & / &
   154      !  pr        Tr        m         a         b
   155      &  500.0d2 , 250.0d0 , 1.0d0   , 0.0021d0, -1.01d-5, & ! 1:H2O
   156      &  500.0d2 , 250.0d0 , 1.0d0   , 0.0140d0,  5.57d-5, & ! 2:H2O
   157      &  -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, & ! 3:H2O + CO2
   158      &  500.0d2 , 250.0d0 , 1.0d0   , 0.0302d0,  2.96d-4, & ! 4:H2O
   159      &  500.0d2 , 250.0d0 , 1.0d0   , 0.0307d0,  2.86d-4, & ! 5:H2O + O3
   160      &  500.0d2 , 250.0d0 , 0.77d0  , 0.0195d0,  1.11d-4, & ! 6:H2O
   161      &  500.0d2 , 250.0d0 , 0.5d0   , 0.0152d0,  7.61d-5, & ! 7:H2O
   162      &  500.0d2 , 250.0d0 , 1.0d0   , 0.0008d0, -3.52d-6, & ! 8:H2O
   163      &  500.0d2 , 250.0d0 , 1.0d0   , 0.0096d0,  1.64d-5, & ! 9:H2O
   164      &  500.0d2 , 250.0d0 , 1.0d0   , 0.0149d0,  6.20d-5  & !10:H2O
   165      & /
   166  
   167  
   168    ! Table 4
   169    !
   170    data aa_BandH2OLineParams &
   171      & / &
   172      ! k1/mu    n   dg1       dg2       dg3       dg4       dg5       dg6
   173      & 2.96d1 ,  6, 0.2747d0, 0.2717d0, 0.2752d0, 0.1177d0, 0.0352d0, 0.0255d0, & ! 1
   174      & 4.17d-1,  6, 0.1521d0, 0.3974d0, 0.1778d0, 0.1826d0, 0.0374d0, 0.0527d0, & ! 2
   175      & -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, & ! 3
   176      & 5.25d-4,  6, 0.4654d0, 0.2991d0, 0.1343d0, 0.0646d0, 0.0226d0, 0.0140d0, & ! 4
   177      & 5.25d-4,  6, 0.5543d0, 0.2723d0, 0.1131d0, 0.0443d0, 0.0160d0, -1.0d100, & ! 5
   178      & 9.37d-3,  8, 0.5955d0, 0.2693d0, 0.0953d0, 0.0335d0, 0.0064d0, -1.0d100, & ! 6
   179      & 4.72d-2,  9, 0.1958d0, 0.3469d0, 0.3147d0, 0.1013d0, 0.0365d0, 0.0048d0, & ! 7
   180      & 1.32d0 ,  6, 0.0740d0, 0.1636d0, 0.4174d0, 0.1783d0, 0.1101d0, 0.0566d0, & ! 8
   181      & 5.25d-4, 16, 0.1437d0, 0.2197d0, 0.3185d0, 0.2351d0, 0.0647d0, 0.0183d0, & ! 9
   182      & 1.06d-1,  8, 0.3153d0, 0.4604d0, 0.1326d0, 0.0798d0, 0.0119d0, -1.0d100  & !10
   183      & /
   184  
   185    ! Table 9
   186    !
   187    data aa_BandH2OContParams &
   188      & / &
   189      ! k/mu
   190      & -1.0d100, & ! 1
   191      & -1.0d100, & ! 2
   192      & -1.0d100, & ! 3
   193      & 15.8d0  , & ! 4
   194      &  9.40d0 , & ! 5
   195      &  7.75d0 , & ! 6
   196      &  8.78d0 , & ! 7
   197      & -1.0d100, & ! 8
   198      & -1.0d100, & ! 9
   199      & -1.0d100  & !10
   200      & /
   201  
   202  
   203    ! Table 1
   204    !
   205    data aa_SubBandWN &
   206      & / &
   207      &  540.0d0,  620.0d0, & ! 1:H2O + CO2
   208      &  620.0d0,  720.0d0, & ! 2:H2O + CO2
   209      &  720.0d0,  800.0d0  & ! 3:H2O + CO2
   210      & /
   211  
   212    ! Table 3
   213    !
   214    data aa_SubBandH2OSclParams &
   215      & / &
   216      !  pr       Tr       m       a          b
   217      &  500.0d2, 250.0d0, 1.0d0 , 0.0167d0,  8.54d-5, & ! 1
   218      &  500.0d2, 250.0d0, 1.0d0 , 0.0167d0,  8.54d-5, & ! 2
   219      &  500.0d2, 250.0d0, 1.0d0 , 0.0167d0,  8.54d-5  & ! 3
   220      & /
   221  
   222    ! Table 10 (H2O)
   223    !
   224    data aa_SubBandH2OLineParams &
   225      & / &
   226      ! k1        n  dg1       dg2       dg3       dg4       dg5       dg6
   227      & 1.33d-2 , 8, 0.1782d0, 0.0593d0, 0.0215d0, 0.0068d0, 0.0022d0, -1.0d100, & ! a
   228      & 1.33d-2 , 8, 0.0923d0, 0.1675d0, 0.0923d0, 0.0187d0, 0.0178d0, -1.0d100, & ! b
   229      & 1.33d-2 , 8, 0.0000d0, 0.1083d0, 0.1581d0, 0.0455d0, 0.0274d0, 0.0041d0  & ! c
   230      & /
   231  
   232    ! Table 9
   233    !
   234    data aa_SubBandH2OContParams &
   235      & / &
   236      ! k/mu
   237      & 109.6d0 , & ! 1
   238      &  54.8d0 , & ! 2
   239      &  27.4d0   & ! 3
   240      & /
   241  
   242    ! Table 3
   243    !   Memo: Parameters to scale absorber amount are given for three subbands
   244    !         in Table 3 (below). But, parameters for k-distribution methods,
   245    !         i.e., absorption coefficients and width of bins, are only given
   246    !         for two bands of "Wings" and "Center" in Table 10.
   247    !         So, k-distribution parameters in 3c is regarded as same as those
   248    !         in 3a.
   249    !         See brief description about this in p. 23.
   250  !!$  data aa_SubBandCO2SclParams &
   251  !!$    & / &
   252  !!$    !  pr       Tr       m      a          b
   253  !!$    &  300.0d2 , 250.0d0 , 0.5d0   , 0.0179d0,  1.02d-4, & ! 1:H2O + CO2
   254  !!$    &   30.0d2 , 250.0d0 , 0.85d0  , 0.0042d0,  2.00d-5, & ! 2:H2O + CO2
   255  !!$    &  300.0d2 , 250.0d0 , 0.5d0   , 0.0184d0,  1.12d-4  & ! 3:H2O + CO2
   256  !!$    & /
   257    data aa_SubBandCO2SclParams &
   258      & / &
   259      !  pr        Tr        m       a          b
   260      &  300.0d2 , 250.0d0 , 0.5d0 , 0.0179d0,  1.02d-4, & ! Wings
   261      &   30.0d2 , 250.0d0 , 0.85d0, 0.0042d0,  2.00d-5  & ! Center
   262      & /
   263  
   264    ! Table 10 (CO2)
   265    !
   266    data aa_SubBandCO2LineParams &
   267      & / &
   268      ! k1        n  dg1       dg2       dg3       dg4       dg5       dg6
   269      & 2.66d-5,  8, 0.1395d0, 0.1407d0, 0.1549d0, 0.1357d0, 0.0182d0, 0.0220d0, & ! Wings
   270      & 2.66d-3,  8, 0.0766d0, 0.1372d0, 0.1189d0, 0.0335d0, 0.0169d0, 0.0059d0  & ! Center
   271      & /
   272  
   273  
   274    ! Table 5 (N2O)
   275    !
   276    data aa_BandN2OLineParams &
   277      & / &
   278      ! k1       n   dg1       dg2       dg3       dg4       dg5       dg6
   279      & -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, & ! 1
   280      & -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, & ! 2
   281      & -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, & ! 3
   282      & -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, & ! 4
   283      & -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, & ! 5
   284      & 6.32d-2, 21, 0.9404d0, 0.0596d0, -1.0d100, -1.0d100, -1.0d100, -1.0d100, & ! 6
   285      & 5.36d-2,  8, 0.5620d0, 0.1387d0, 0.2406d0, 0.0587d0, -1.0d100, -1.0d100, & ! 7
   286      & -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, & ! 8
   287      & -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, & ! 9
   288      & 2.52d-1, 58, 0.971d0 , 0.029d0 , -1.0d100, -1.0d100, -1.0d100, -1.0d100  & !10
   289      & /
   290    data aa_BandN2OSclParams &
   291      & / &
   292      !  pr        Tr        m       a          b
   293      & -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, & ! 1
   294      & -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, & ! 2
   295      & -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, & ! 3
   296      & -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, & ! 4
   297      & -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, & ! 5
   298      &  500.0d2 , 250.0d0 , 0.0d0 , 1.93d-3 ,  4.38d-6, & ! 6
   299      &  500.0d2 , 250.0d0 , 0.48d0, 1.38d-3 ,  7.48d-6, & ! 7
   300      & -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, & ! 8
   301      & -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, & ! 9
   302      &  500.0d2 , 250.0d0 , 0.0d0 , 1.45d-3 ,  3.67d-6  & !10
   303      & /
   304  
   305    ! Table 5 (CH4)
   306    !
   307    data aa_BandCH4LineParams &
   308      & / &
   309      ! k1       n   dg1       dg2       dg3       dg4       dg5       dg6
   310      & -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, & ! 1
   311      & -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, & ! 2
   312      & -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, & ! 3
   313      & -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, & ! 4
   314      & -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, & ! 5
   315      & 5.81d-3,  1, 1.0d0   , -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, & ! 6
   316      & 6.29d-2, 12, 0.6107d0, 0.2802d0, 0.1073d0, 0.0018d0, -1.0d100, -1.0d100, & ! 7
   317      & -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, & ! 8
   318      & -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, & ! 9
   319      & -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100  & !10
   320      & /
   321    data aa_BandCH4SclParams &
   322      & / &
   323      !  pr        Tr        m       a          b
   324      & -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, & ! 1
   325      & -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, & ! 2
   326      & -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, & ! 3
   327      & -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, & ! 4
   328      & -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, & ! 5
   329      &  500.0d2 , 250.0d0 , 0.0d0 , 1.70d-2 ,  1.58d-4, & ! 6
   330      &  500.0d2 , 250.0d0 , 0.65d0, 5.96d-4 , -2.29d-6, & ! 7
   331      & -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, & ! 8
   332      & -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, & ! 9
   333      & -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100  & !10
   334      & /
   335  
   336    ! Table 6
   337    !
   338    data aa_WeakBandCO2LineParams &
   339      & / &
   340      ! k1       n   dg1       dg2       dg3       dg4       dg5       dg6
   341      & -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, & ! 1
   342      & -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, & ! 2
   343      & -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, & ! 3
   344      & 1.92d-7,  5, 0.1216d0, 0.2436d0, 0.2498d0, 0.2622d0, 0.0781d0, 0.0427d0, & ! 4
   345      & 1.92d-7,  5, 0.0687d0, 0.1480d0, 0.1951d0, 0.3344d0, 0.1720d0, 0.0818d0, & ! 5
   346      & -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, & ! 6
   347      & -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, & ! 7
   348      & -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, & ! 8
   349      & -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, & ! 9
   350      & 2.66d-5,  8, 0.267d0 , 0.220d0 , 0.210d0 , 0.241d0 , 0.020d0 , 0.042d0   & !10
   351      & /
   352    data aa_WeakBandCO2SclParams &
   353      & / &
   354      !  pr        Tr        m       a          b
   355      & -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, & ! 1
   356      & -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, & ! 2
   357      & -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, & ! 3
   358      &  500.0d2 , 250.0d0 , 0.0d0 , 3.58d-2 ,  4.05d-4, & ! 4
   359      &  500.0d2 , 250.0d0 , 0.0d0 , 3.43d-2 ,  3.74d-4, & ! 5
   360      & -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, & ! 6
   361      & -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, & ! 7
   362      & -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, & ! 8
   363      & -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, & ! 9
   364      &  300.0d2 , 250.0d0 , 0.5d0 , 1.79d-2 ,  1.02d-4  & !10
   365      & /
   366  
   367  
   368  
   369    ! Table 11a
   370    !   Unit of effective radius of particle is micron meter.
   371    !   Unit of extinction parameters would be g-1 m2 ?
   372    data aa_BandCloudIceExtParams &
   373      & / &
   374      & -0.44171, 0.62951, 0.06465, -1.0d100, &
   375      & -0.13727, 0.61291, 0.28962, -1.0d100, &
   376      & -0.01878, 1.67680, 0.79080, -1.0d100, &
   377      & -0.01896, 1.06510, 0.69493, -1.0d100, &
   378      & -0.04788, 0.88178, 0.54492, -1.0d100, &
   379      & -0.02265, 1.57390, 0.76161, -1.0d100, &
   380      & -0.01038, 2.15640, 0.89045, -1.0d100, &
   381      & -0.00450, 2.51370, 0.95989, -1.0d100, &
   382      & -0.00044, 3.15050, 1.03750, -1.0d100, &
   383      & -0.02956, 1.44680, 0.71283, -1.0d100  &
   384      & /
   385  
   386    ! Table 11b
   387    !   Unit of effective radius of particle is micron meter.
   388    !   Unit of extinction parameters would be g-1 m2 ?
   389    data aa_BandCloudLiqExtParams &
   390      & / &
   391      & 0.08641,  0.01769, -1.5572E-3,  3.4896E-5, &
   392      & 0.22027,  0.00997, -1.8719E-3,  5.3112E-5, &
   393      & 0.38074, -0.03027,  1.0154E-3, -1.1849E-5, &
   394      & 0.15587,  0.00371, -7.7705E-4,  2.0547E-5, &
   395      & 0.05518,  0.04544, -4.2067E-3,  1.0184E-4, &
   396      & 0.12724,  0.04751, -5.2037E-3,  1.3711E-4, &
   397      & 0.30390,  0.01656, -3.5271E-3,  1.0828E-4, &
   398      & 0.63617, -0.06287,  2.2350E-3, -2.3177E-5, &
   399      & 1.15470, -0.19282,  1.2084E-2, -2.5612E-4, &
   400      & 0.34021, -0.02805,  1.0654E-3, -1.5443E-5  &
   401      & /
   402  
   403    ! Table 12a
   404    !   Unit of effective radius of particle is micron meter.
   405    data aa_BandCloudIceSSAParams &
   406      & / &
   407      & 0.17201,  1.2229E-2, -1.4837E-4,  5.8020E-7, &
   408      & 0.81470, -2.7293E-3,  9.7816E-8,  5.7650E-8, &
   409      & 0.54859, -4.8273E-4,  5.4353E-6, -1.5679E-8, &
   410      & 0.39218,  4.1717E-3, -4.8869E-5,  1.9144E-7, &
   411      & 0.71773, -3.3640E-3,  1.9713E-5, -3.3189E-8, &
   412      & 0.77345, -5.5228E-3,  4.8379E-5, -1.5151E-7, &
   413      & 0.74975, -5.6604E-3,  5.6475E-5, -1.9664E-7, &
   414      & 0.69011, -4.5348E-3,  4.9322E-5, -1.8255E-7, &
   415      & 0.83963, -6.7253E-3,  6.1900E-5, -2.0862E-7, &
   416      & 0.64860, -2.8692E-3,  2.7656E-5, -8.9680E-8  &
   417      & /
   418  
   419    ! Table 12b
   420    !   Unit of effective radius of particle is micron meter.
   421    data aa_BandCloudLiqSSAParams &
   422      & / &
   423      &  0.17201,  1.2229E-2, -1.4837E-4, 5.8020E-7, &
   424      & -0.01338,  9.3134E-2, -6.0491E-3, 1.3059E-4, &
   425      &  0.03710,  7.3211E-2, -4.4211E-3, 9.2448E-5, &
   426      & -0.00376,  9.3344E-2, -5.6561E-3, 1.1387E-4, &
   427      &  0.40212,  7.8083E-2, -5.9583E-3, 1.2883E-4, &
   428      &  0.57928,  5.9094E-2, -5.4425E-3, 1.2725E-4, &
   429      &  0.68974,  4.2334E-2, -4.9469E-3, 1.2863E-4, &
   430      &  0.80122,  9.4578E-3, -2.8508E-3, 9.0078E-5, &
   431      &  1.02340, -2.6204E-2,  4.2552E-4, 3.2160E-6, &
   432      &  0.05092,  7.5409E-2, -4.7305E-3, 1.0121E-4  &
   433      & /
   434  
   435    ! Table 13a
   436    !   Unit of effective radius of particle is micron meter.
   437    data aa_BandCloudIceAFParams &
   438      & / &
   439      & 0.57867, 1.0135E-2, -1.1142E-4, 4.1537E-7, &
   440      & 0.72259, 3.1149E-3, -1.9927E-5, 5.6024E-8, &
   441      & 0.76109, 4.5449E-3, -4.6199E-5, 1.6446E-7, &
   442      & 0.86934, 2.7474E-3, -3.1301E-5, 1.1959E-7, &
   443      & 0.89103, 1.8513E-3, -1.6551E-5, 5.5193E-8, &
   444      & 0.86325, 2.1408E-3, -1.6846E-5, 4.9473E-8, &
   445      & 0.85064, 2.5028E-3, -2.0812E-5, 6.3427E-8, &
   446      & 0.86945, 2.4615E-3, -2.3882E-5, 8.2431E-8, &
   447      & 0.80122, 3.1906E-3, -2.4856E-5, 7.2411E-8, &
   448      & 0.73290, 4.8034E-3, -4.4425E-5, 1.4839E-7  &
   449      & /
   450  
   451    ! Table 13b
   452    !   Unit of effective radius of particle is micron meter.
   453    data aa_BandCloudLiqAFParams &
   454      & / &
   455      & -0.51930,  0.20290  , -1.1747E-2,  2.3868E-4, &
   456      & -0.22151,  0.19708  , -1.2462E-2,  2.6646E-4, &
   457      &  0.14157,  0.14705  , -9.5802E-3,  2.0819E-4, &
   458      &  0.41590,  0.10482  , -6.9118E-3,  1.5115E-4, &
   459      &  0.55338,  7.7016E-2, -5.2218E-3,  1.1587E-4, &
   460      &  0.61384,  6.4402E-2, -4.6241E-3,  1.0746E-4, &
   461      &  0.67891,  4.8698E-2, -3.7021E-3,  9.1966E-5, &
   462      &  0.78169,  2.0803E-2, -1.4749E-3,  3.9362E-5, &
   463      &  0.93218, -3.3425E-2,  2.9632E-3, -6.9362E-5, &
   464      &  0.01649,  0.16561  , -1.0723E-2,  2.3220E-4  &
   465      & /
   466  
   467  
   468    !
   469    ! Public procedure
   470    !
   471    public :: RadC2001CalcTransBand3CO2
   472    public :: RadC2001CalcTransBand3H2O
   473    public :: RadC2001CalcTrans
   474  
   475    public :: RadC2001CalcCloudOptProp
   476    public :: RadC2001ReduceCloudOptDep
   477  
   478    public :: RadC2001CalcIntegratedPF3D
   479    public :: RadC2001CalcIntegratedPF2D
   480  
   481    public :: RadC2001Init
   482  
   483  
   484    real(DP), save :: MeanMolWeight = 28.97d-3
   485    real(DP), save :: H2OMolWeight  = 18.0d-3
   486    real(DP), save :: CO2MolWeight  = 44.0d-3
   487  
   488  
   489  
   490    ! 公開変数
   491    ! Public variables
   492    !
   493    logical, save :: rad_C2001_inited = .false.
   494                                ! 初期設定フラグ.
   495                                ! Initialization flag
   496  
   497  
   498    character(*), parameter:: module_name = 'rad_C2001'
   499                                ! モジュールの名称.
   500                                ! Module name
   501    character(*), parameter:: version = &
   502      & '$Name:  $' // &
   503      & '$Id: rad_C2001.f90,v 1.4 2013/01/27 11:31:14 yot Exp $'
   504                                ! モジュールのバージョン
   505                                ! Module version
   506  
   507  
   508    !--------------------------------------------------------------------------------------
   509  
   510  contains
   511  
   512    !--------------------------------------------------------------------------------------
   513  
   514    subroutine RadC2001CalcCloudOptProp(       &
   515      & Spec, iband, xyz_REff,                       & ! (in)
   516      & xyz_ExtCoef, xyz_SSA, xyz_AF                 & ! (out)
   517      & )
   518  
   519      ! USE statements
   520      !
   521  
   522  
   523      character(len=*), intent(in ) :: SPEC
   524      integer         , intent(in ) :: iband
   525      real(DP)        , intent(in ) :: xyz_REff   (0:imax-1, 1:jmax, 1:kmax)
   526      real(DP)        , intent(out) :: xyz_ExtCoef(0:imax-1, 1:jmax, 1:kmax)
   527      real(DP)        , intent(out) :: xyz_SSA    (0:imax-1, 1:jmax, 1:kmax)
   528      real(DP)        , intent(out) :: xyz_AF     (0:imax-1, 1:jmax, 1:kmax)
   529  
   530  
   531      !
   532      ! Work variables
   533      !
   534      real(DP) :: xyz_REffInMicron(0:imax-1, 1:jmax, 1:kmax)
   535      integer  :: l
   536  
   537  
   538      ! 初期化確認
   539      ! Initialization check
   540      !
   541      if ( .not. rad_C2001_inited ) then
   542        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   543      end if
   544  
   545  
   546      xyz_REffInMicron = xyz_REff * 1.0d6
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t228 = 1, kmax*jmax*imax                                       
     .           xyz_reffinmicron(t228-1,1,1) = xyz_reff(t228-1,1,1)*           
     .       1      1.00000000000000e+006                                       
     .           xyz_extcoef(t228-1,1,1) = 0.0000000000000000e+000              
     .           xyz_ssa(t228-1,1,1) = 0.0000000000000000e+000                  
     .           xyz_af(t228-1,1,1) = 0.0000000000000000e+000                   
     .        enddo                                                             
   547  
   548      xyz_ExtCoef = 0.0_DP
   549      xyz_SSA     = 0.0_DP
   550      xyz_AF      = 0.0_DP
   551  
   552      if ( Spec == 'Ice' ) then
   553        ! Eq. (6.4a)
   554        xyz_ExtCoef = aa_BandCloudIceExtParams(1,iband) &
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t300 = 1, xyz_reffinmicron.DSC.U3*(xyz_reffinmicron.DSC.U2*    
     .       1   xyz_reffinmicron.DSC.U1 + xyz_reffinmicron.DSC.U2)             
     .           xyz_extcoef1 = aa_bandcloudiceextparams(1,iband) +             
     .       1      aa_bandcloudiceextparams(2,iband)/xyz_reffinmicron(t300-1,1,
     .       2      1)**aa_bandcloudiceextparams(3,iband)                       
     .           xyz_extcoef(t300-1,1,1) = xyz_extcoef1*1.00000000000000e+003   
     .        enddo                                                             
   555          &     + aa_BandCloudIceExtParams(2,iband) &
   556          &       / xyz_REffInMicron**aa_BandCloudIceExtParams(3,iband)
   557        !  Convert unit from g-1 m2 to kg-1 m2
   558        xyz_ExtCoef = xyz_ExtCoef * 1.0d3
   559        do l = 1, ncloudparam
   560          ! Eq. (6.5)
   561          xyz_SSA = xyz_SSA + aa_BandCloudIceSSAParams(l,iband) * xyz_REffInMicron**(l-1)
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xyz_ssa,xyz_reffinmicron,xyz_af)                           
     .        do t318 = 1, kmax*jmax*imax                                       
     .           xyz_ssa(t318-1,1,1) = xyz_ssa(t318-1,1,1) +                    
     .       1      aa_bandcloudicessaparams(l,iband)*(xyz_reffinmicron(t318-1,1
     .       2      ,1)**(l-1))                                                 
     .           xyz_af(t318-1,1,1) = xyz_af(t318-1,1,1) +                      
     .       1      aa_bandcloudiceafparams(l,iband)*(xyz_reffinmicron(t318-1,1,
     .       2      1)**(l-1))                                                  
     .        enddo                                                             
   562          ! Eq. (6.6)
   563          xyz_AF  = xyz_AF  + aa_BandCloudIceAFParams (l,iband) * xyz_REffInMicron**(l-1)
   564        end do
   565      else if ( Spec == 'Liquid' ) then
   566        do l = 1, ncloudparam
   567          ! Eq. (6.4b)
   568          xyz_ExtCoef = xyz_ExtCoef + aa_BandCloudLiqExtParams(l,iband) * xyz_REffInMicron**(l-1)
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xyz_extcoef,xyz_reffinmicron)                              
     .        do t249 = 1, kmax*jmax*imax                                       
     .           xyz_extcoef(t249-1,1,1) = xyz_extcoef(t249-1,1,1) +            
     .       1      aa_bandcloudliqextparams(l,iband)*xyz_reffinmicron(t249-1,1,
     .       2      1)**(l - 1)                                                 
     .        enddo                                                             
   569        end do
   570        !  Convert unit from g-1 m2 to kg-1 m2
   571        xyz_ExtCoef = xyz_ExtCoef * 1.0d3
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xyz_extcoef)                                               
     .        do t264 = 1, kmax*jmax*imax                                       
     .           xyz_extcoef(t264-1,1,1) = xyz_extcoef(t264-1,1,1)*             
     .       1      1.00000000000000e+003                                       
     .        enddo                                                             
   572        do l = 1, ncloudparam
   573          ! Eq. (6.5)
   574          xyz_SSA = xyz_SSA + aa_BandCloudLiqSSAParams(l,iband) * xyz_REffInMicron**(l-1)
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xyz_reffinmicron,xyz_ssa,xyz_af)                           
     .        do t276 = 1, kmax*jmax*imax                                       
     .           xyz_ssa(t276-1,1,1) = xyz_ssa(t276-1,1,1) +                    
     .       1      aa_bandcloudliqssaparams(l,iband)*(xyz_reffinmicron(t276-1,1
     .       2      ,1)**(l-1))                                                 
     .           xyz_af(t276-1,1,1) = xyz_af(t276-1,1,1) +                      
     .       1      aa_bandcloudliqafparams(l,iband)*(xyz_reffinmicron(t276-1,1,
     .       2      1)**(l-1))                                                  
     .        enddo                                                             
   575          ! Eq. (6.6)
   576          xyz_AF  = xyz_AF  + aa_BandCloudLiqAFParams (l,iband) * xyz_REffInMicron**(l-1)
   577        end do
   578      else
   579        call MessageNotify( 'E', module_name, 'Unsupported specie, %c', c1 = trim( Spec ) )
   580      end if
   581  
   582  
   583    end subroutine RadC2001CalcCloudOptProp
   584  
   585    !--------------------------------------------------------------------------------------
   586  
   587    subroutine RadC2001ReduceCloudOptDep(      &
   588      & xyz_SSA, xyz_AF,                             & ! (in)
   589      & xyz_DelOptDep                                & ! (inout)
   590      & )
   591  
   592      ! USE statements
   593      !
   594  
   595  
   596      real(DP), intent(in   ) :: xyz_SSA      (0:imax-1, 1:jmax, 1:kmax)
   597      real(DP), intent(in   ) :: xyz_AF       (0:imax-1, 1:jmax, 1:kmax)
   598      real(DP), intent(inout) :: xyz_DelOptDep(0:imax-1, 1:jmax, 1:kmax)
   599  
   600  
   601      !
   602      ! Work variables
   603      !
   604      real(DP) :: xyz_FuncF(0:imax-1, 1:jmax, 1:kmax)
   605      real(DP) :: a_CoefA(1:4)
   606      integer  :: l
   607  
   608      data a_CoefA / 0.5d0, 0.3738d0, 0.0076d0, 0.1186d0 /
   609  
   610  
   611      ! 初期化確認
   612      ! Initialization check
   613      !
   614      if ( .not. rad_C2001_inited ) then
   615        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   616      end if
   617  
   618  
   619      ! Extinction coefficient is modified to account for effect of scattering.
   620  
   621      ! Eq. (6.12)
   622      !
   623      xyz_FuncF = 0.0_DP
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t100 = 1, xyz_funcf.DSC.U3*(xyz_funcf.DSC.U2*xyz_funcf.DSC.U1  
     .       1    + xyz_funcf.DSC.U2)                                           
     .           xyz_funcf(t100-1,1,1) = 0.0000000000000000e+000                
     .        enddo                                                             
   624      do l = 1, 4
   625        xyz_FuncF = xyz_FuncF + a_CoefA(l) * xyz_AF**(l-1)
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xyz_funcf,xyz_af)                                          
     .        do t109 = 1, xyz_funcf.DSC.U3*(xyz_funcf.DSC.U2*xyz_funcf.DSC.U1  
     .       1    + xyz_funcf.DSC.U2)                                           
     .           xyz_funcf(t109-1,1,1) = xyz_funcf(t109-1,1,1) + a_coefa(l)*    
     .       1      xyz_af(t109-1,1,1)**(l - 1)                                 
     .        enddo                                                             
   626      end do
   627  
   628      ! Eq. (6.11)
   629      !
   630      xyz_DelOptDep = ( 1.0_DP - xyz_SSA * xyz_FuncF ) * xyz_DelOptDep
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xyz_funcf)                                                 
     .        do t124 = 1, kmax*jmax*imax                                       
     .           xyz_deloptdep(t124-1,1,1) = (1.00000000000000e+000 - xyz_ssa(  
     .       1      t124-1,1,1)*xyz_funcf(t124-1,1,1))*xyz_deloptdep(t124-1,1,1)
     .        enddo                                                             
   631  
   632  
   633    end subroutine RadC2001ReduceCloudOptDep
   634  
   635    !--------------------------------------------------------------------------------------
   636  
   637    subroutine RadC2001CalcTransBand3CO2(           &
   638      & xyz_DelCO2Mass, xyz_Press, xyz_Temp, xyz_QCO2,    & ! (in)
   639      & xyrr_Trans                                        & ! (out)
   640      & )
   641  
   642      ! USE statements
   643      !
   644  
   645  
   646      real(DP)        , intent(in ) :: xyz_DelCO2Mass(0:imax-1, 1:jmax, 1:kmax)
   647      real(DP)        , intent(in ) :: xyz_Press     (0:imax-1, 1:jmax, 1:kmax)
   648      real(DP)        , intent(in ) :: xyz_Temp      (0:imax-1, 1:jmax, 1:kmax)
   649      real(DP)        , intent(in ) :: xyz_QCO2      (0:imax-1, 1:jmax, 1:kmax)
   650      real(DP)        , intent(out) :: xyrr_Trans    (0:imax-1, 1:jmax, 0:kmax, 0:kmax)
   651  
   652  
   653      !
   654      ! Work variables
   655      !
   656      real(DP)              :: xyrr_TransEach (0:imax-1, 1:jmax, 0:kmax, 0:kmax)
   657      character(len=STRING) :: Spec
   658      integer               :: iband
   659      integer               :: k
   660      integer               :: kk
   661  
   662  
   663      ! 初期化確認
   664      ! Initialization check
   665      !
   666      if ( .not. rad_C2001_inited ) then
   667        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   668      end if
   669  
   670  
   671      xyrr_Trans = 0.0_DP
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t146 = 1, (kmax + 1)*(kmax + 1)*jmax*imax                      
     .           xyrr_trans(t146-1,1,0,0) = 0.0000000000000000e+000             
     .        enddo                                                             
   672  
   673      Spec = 'SubBandCO2'
   674      do iband = 1, 2
   675        call RadC2001CalcTrans(                               &
   676          & Spec, iband,                                      & ! (in)
   677          & xyz_DelCO2Mass, xyz_Press, xyz_Temp, xyz_QCO2,    & ! (in)
   678          & xyrr_TransEach                                    & ! (out)
   679          & )
   680  
   681        do k = 0, kmax
   682          do kk = 0, kmax
   683            if ( k == kk ) then
   684              xyrr_Trans(:,:,k,kk) = 1.0_DP
     .        if (jmax .gt. 0) then                                             
     .           j1 = and(jmax,3)                                               
     .  !cdir    nodep                                                          
     .           do t168 = 1, j1                                                
     .  !cdir       nodep                                                       
     .              do t170 = 1, 1 + imax - min0(1,imax)                        
     .                 xyrr_trans(t170-1,t168,k,kk) = 1.00000000000000e+000     
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t168 = j1 + 1, jmax, 4                                      
     .  !cdir       nodep                                                       
     .              do t170 = 1, 1 + imax - min0(1,imax)                        
     .                 xyrr_trans(t170-1,t168,k,kk) = 1.00000000000000e+000     
     .                 xyrr_trans(t170-1,t168+1,k,kk) = 1.00000000000000e+000   
     .                 xyrr_trans(t170-1,t168+2,k,kk) = 1.00000000000000e+000   
     .                 xyrr_trans(t170-1,t168+3,k,kk) = 1.00000000000000e+000   
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
     .        goto 10024                                                        
   685            else
   686              xyrr_Trans(:,:,k,kk) = xyrr_Trans(:,:,k,kk) + xyrr_TransEach(:,:,k,kk)
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t158 = 1, jmax*imax                                            
     .           xyrr_trans(t158-1,1,k,kk) = xyrr_trans(t158-1,1,k,kk) +        
     .       1      xyrr_transeach(t158-1,1,k,kk)                               
     .        enddo                                                             
   687            end if
   688          end do
   689        end do
   690      end do
   691  
   692  
   693    end subroutine RadC2001CalcTransBand3CO2
   694  
   695    !--------------------------------------------------------------------------------------
   696  
   697    subroutine RadC2001CalcTransBand3H2O(                    &
   698      & xyz_DelH2OVapMass, xyz_Press, xyz_Temp, xyz_QH2OVap, & ! (in)
   699      & xyrr_Trans                                           & ! (out)
   700      & )
   701  
   702      ! USE statements
   703      !
   704  
   705  
   706      real(DP), intent(in ) :: xyz_DelH2OVapMass(0:imax-1, 1:jmax, 1:kmax)
   707      real(DP), intent(in ) :: xyz_Press        (0:imax-1, 1:jmax, 1:kmax)
   708      real(DP), intent(in ) :: xyz_Temp         (0:imax-1, 1:jmax, 1:kmax)
   709      real(DP), intent(in ) :: xyz_QH2OVap      (0:imax-1, 1:jmax, 1:kmax)
   710      real(DP), intent(out) :: xyrr_Trans       (0:imax-1, 1:jmax, 0:kmax, 0:kmax)
   711  
   712  
   713      !
   714      ! Work variables
   715      !
   716      real(DP)              :: xyrr_TransCont (0:imax-1, 1:jmax, 0:kmax, 0:kmax)
   717      real(DP)              :: xyrr_TransLine (0:imax-1, 1:jmax, 0:kmax, 0:kmax)
   718      character(len=STRING) :: Spec
   719      integer               :: iband
   720      integer               :: k
   721      integer               :: kk
   722  
   723  
   724      ! 初期化確認
   725      ! Initialization check
   726      !
   727      if ( .not. rad_C2001_inited ) then
   728        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   729      end if
   730  
   731  
   732      xyrr_Trans = 0.0_DP
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t173 = 1, (kmax + 1)*(kmax + 1)*jmax*imax                      
     .           xyrr_trans(t173-1,1,0,0) = 0.0000000000000000e+000             
     .        enddo                                                             
   733  
   734      do iband = 1, nsbmax
   735        Spec = 'SubBandH2OCont'
   736        call RadC2001CalcTrans(                                  &
   737          & Spec, iband,                                         & ! (in)
   738          & xyz_DelH2OVapMass, xyz_Press, xyz_Temp, xyz_QH2OVap, & ! (in)
   739          & xyrr_TransCont                                       & ! (out)
   740          & )
   741        Spec = 'SubBandH2OLine'
   742        call RadC2001CalcTrans(                                  &
   743          & Spec, iband,                                         & ! (in)
   744          & xyz_DelH2OVapMass, xyz_Press, xyz_Temp, xyz_QH2OVap, & ! (in)
   745          & xyrr_TransLine                                       & ! (out)
   746          & )
   747  
   748        do k = 0, kmax
   749          do kk = 0, kmax
   750            if ( k == kk ) then
   751              xyrr_Trans(:,:,k,kk) = 1.0_DP
     .        if (jmax .gt. 0) then                                             
     .           j1 = and(jmax,3)                                               
     .  !cdir    nodep                                                          
     .           do t197 = 1, j1                                                
     .  !cdir       nodep                                                       
     .              do t199 = 1, 1 + imax - min0(1,imax)                        
     .                 xyrr_trans(t199-1,t197,k,kk) = 1.00000000000000e+000     
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t197 = j1 + 1, jmax, 4                                      
     .  !cdir       nodep                                                       
     .              do t199 = 1, 1 + imax - min0(1,imax)                        
     .                 xyrr_trans(t199-1,t197,k,kk) = 1.00000000000000e+000     
     .                 xyrr_trans(t199-1,t197+1,k,kk) = 1.00000000000000e+000   
     .                 xyrr_trans(t199-1,t197+2,k,kk) = 1.00000000000000e+000   
     .                 xyrr_trans(t199-1,t197+3,k,kk) = 1.00000000000000e+000   
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
     .        goto 10025                                                        
   752            else
   753              xyrr_Trans(:,:,k,kk) = xyrr_Trans(:,:,k,kk) &
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t185 = 1, jmax*imax                                            
     .           xyrr_trans(t185-1,1,k,kk) = xyrr_trans(t185-1,1,k,kk) +        
     .       1      xyrr_transcont(t185-1,1,k,kk)*xyrr_transline(t185-1,1,k,kk) 
     .        enddo                                                             
   754                & + xyrr_TransCont(:,:,k,kk) * xyrr_TransLine(:,:,k,kk)
   755            end if
   756          end do
   757        end do
   758      end do
   759  
   760  
   761    end subroutine RadC2001CalcTransBand3H2O
   762  
   763    !--------------------------------------------------------------------------------------
   764  
   765    subroutine RadC2001CalcTrans(                         &
   766      & Spec, iband,                                      & ! (in)
   767      & xyz_DelAbsMass, xyz_Press, xyz_Temp, xyz_QMix,    & ! (in)
   768      & xyrr_Trans                                        & ! (out)
   769      & )
   770  
   771      ! USE statements
   772      !
   773  
   774  
   775      character(len=*), intent(in ) :: Spec
   776      integer         , intent(in ) :: iband
   777      real(DP)        , intent(in ) :: xyz_DelAbsMass(0:imax-1, 1:jmax, 1:kmax)
   778      real(DP)        , intent(in ) :: xyz_Press     (0:imax-1, 1:jmax, 1:kmax)
   779      real(DP)        , intent(in ) :: xyz_Temp      (0:imax-1, 1:jmax, 1:kmax)
   780      real(DP)        , intent(in ) :: xyz_QMix      (0:imax-1, 1:jmax, 1:kmax)
   781      real(DP)        , intent(out) :: xyrr_Trans    (0:imax-1, 1:jmax, 0:kmax, 0:kmax)
   782  
   783  
   784      !
   785      ! Work variables
   786      !
   787      real(DP) :: RefPress
   788      real(DP) :: RefTemp
   789      real(DP) :: PressScaleIndex
   790      real(DP) :: CoefA
   791      real(DP) :: CoefB
   792      real(DP) :: CoefC            ! width of bin (dg) ! This notation is used in Chou et al. (1993)
   793      integer  :: CoefN
   794      real(DP) :: AbsCoef
   795  
   796      integer  :: NCoefC
   797      real(DP) :: a_CoefC(1:6)
   798  
   799  
   800      real(DP) :: xyz_DelAbsMassScaled  (0:imax-1, 1:jmax, 1:kmax)
   801  
   802      real(DP) :: xyz_TransOneLayer     (0:imax-1, 1:jmax, 1:kmax)
   803      real(DP) :: xyrr_TransElem        (0:imax-1, 1:jmax, 0:kmax, 0:kmax)
   804  
   805      integer  :: k
   806      integer  :: kk
   807      integer  :: l
   808  
   809  
   810      ! 初期化確認
   811      ! Initialization check
   812      !
   813      if ( .not. rad_C2001_inited ) then
   814        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   815      end if
   816  
   817  
   818      if ( Spec == 'H2OCont' ) then
   819        RefPress        =     -1.0d100
   820        RefTemp         =     -1.0d100
   821        PressScaleIndex =     -1.0d100
   822        CoefA           =     -1.0d100
   823        CoefB           =     -1.0d100
   824        AbsCoef         =      aa_BandH2OContParams(1  ,iband)
   825        a_CoefC(1:1)    =      1.0_DP
     .        a_coefc(1) = 1.00000000000000e+000                                
   826        a_CoefC(2:6)    =      1.0d100
     .        a_coefc(2) = 1.00000000000000e+100                                
     .        a_coefc(3) = 1.00000000000000e+100                                
     .        a_coefc(4) = 1.00000000000000e+100                                
     .        a_coefc(5) = 1.00000000000000e+100                                
     .        a_coefc(6) = 1.00000000000000e+100                                
   827        CoefN           = 1
   828        NCoefC          = 1
   829      else if ( Spec == 'H2OLine' ) then
   830        RefPress        =      aa_BandH2OSclParams (1  ,iband)
   831        RefTemp         =      aa_BandH2OSclParams (2  ,iband)
   832        PressScaleIndex =      aa_BandH2OSclParams (3  ,iband)
   833        CoefA           =      aa_BandH2OSclParams (4  ,iband)
   834        CoefB           =      aa_BandH2OSclParams (5  ,iband)
   835        AbsCoef         =      aa_BandH2OLineParams(1  ,iband)
   836        CoefN           = int( aa_BandH2OLineParams(2  ,iband) )
   837        a_CoefC         =      aa_BandH2OLineParams(3:8,iband)
   838        NCoefC          = 6
   839      else if ( Spec == 'SubBandH2OCont' ) then
   840        RefPress        =     -1.0d100
   841        RefTemp         =     -1.0d100
   842        PressScaleIndex =     -1.0d100
   843        CoefA           =     -1.0d100
   844        CoefB           =     -1.0d100
   845        AbsCoef         =      aa_SubBandH2OContParams(1  ,iband)
   846        a_CoefC(1:1)    =      1.0_DP
     .           a_coefc(1) = 1.00000000000000e+000                             
   847        a_CoefC(2:6)    =      1.0d100
     .        a_coefc(2) = 1.00000000000000e+100                                
     .        a_coefc(3) = 1.00000000000000e+100                                
     .        a_coefc(4) = 1.00000000000000e+100                                
     .        a_coefc(5) = 1.00000000000000e+100                                
     .        a_coefc(6) = 1.00000000000000e+100                                
   848        CoefN           = 1
   849        NCoefC          = 1
   850      else if ( Spec == 'SubBandH2OLine' ) then
   851        RefPress        =      aa_SubBandH2OSclParams (1  ,iband)
   852        RefTemp         =      aa_SubBandH2OSclParams (2  ,iband)
   853        PressScaleIndex =      aa_SubBandH2OSclParams (3  ,iband)
   854        CoefA           =      aa_SubBandH2OSclParams (4  ,iband)
   855        CoefB           =      aa_SubBandH2OSclParams (5  ,iband)
   856        AbsCoef         =      aa_SubBandH2OLineParams(1  ,iband)
   857        CoefN           = int( aa_SubBandH2OLineParams(2  ,iband) )
   858        a_CoefC         =      aa_SubBandH2OLineParams(3:8,iband)
   859        NCoefC          = 6
   860      else if ( Spec == 'SubBandCO2' ) then
   861        RefPress        =      aa_SubBandCO2SclParams (1  ,iband)
   862        RefTemp         =      aa_SubBandCO2SclParams (2  ,iband)
   863        PressScaleIndex =      aa_SubBandCO2SclParams (3  ,iband)
   864        CoefA           =      aa_SubBandCO2SclParams (4  ,iband)
   865        CoefB           =      aa_SubBandCO2SclParams (5  ,iband)
   866        AbsCoef         =      aa_SubBandCO2LineParams(1  ,iband)
   867        CoefN           = int( aa_SubBandCO2LineParams(2  ,iband) )
   868        a_CoefC         =      aa_SubBandCO2LineParams(3:8,iband)
   869        NCoefC          = 6
   870      else if ( Spec == 'N2OLine' ) then
   871        RefPress        =      aa_BandN2OSclParams (1  ,iband)
   872        RefTemp         =      aa_BandN2OSclParams (2  ,iband)
   873        PressScaleIndex =      aa_BandN2OSclParams (3  ,iband)
   874        CoefA           =      aa_BandN2OSclParams (4  ,iband)
   875        CoefB           =      aa_BandN2OSclParams (5  ,iband)
   876        AbsCoef         =      aa_BandN2OLineParams(1  ,iband)
   877        CoefN           = int( aa_BandN2OLineParams(2  ,iband) )
   878        a_CoefC         =      aa_BandN2OLineParams(3:8,iband)
   879        NCoefC          = 6
   880      else if ( Spec == 'CH4Line' ) then
   881        RefPress        =      aa_BandCH4SclParams (1  ,iband)
   882        RefTemp         =      aa_BandCH4SclParams (2  ,iband)
   883        PressScaleIndex =      aa_BandCH4SclParams (3  ,iband)
   884        CoefA           =      aa_BandCH4SclParams (4  ,iband)
   885        CoefB           =      aa_BandCH4SclParams (5  ,iband)
   886        AbsCoef         =      aa_BandCH4LineParams(1  ,iband)
   887        CoefN           = int( aa_BandCH4LineParams(2  ,iband) )
   888        a_CoefC         =      aa_BandCH4LineParams(3:8,iband)
   889        NCoefC          = 6
   890      else if ( Spec == 'WeakBandCO2Line' ) then
   891        RefPress        =      aa_WeakBandCO2SclParams (1  ,iband)
   892        RefTemp         =      aa_WeakBandCO2SclParams (2  ,iband)
   893        PressScaleIndex =      aa_WeakBandCO2SclParams (3  ,iband)
   894        CoefA           =      aa_WeakBandCO2SclParams (4  ,iband)
   895        CoefB           =      aa_WeakBandCO2SclParams (5  ,iband)
   896        AbsCoef         =      aa_WeakBandCO2LineParams(1  ,iband)
   897        CoefN           = int( aa_WeakBandCO2LineParams(2  ,iband) )
   898        a_CoefC         =      aa_WeakBandCO2LineParams(3:8,iband)
   899        NCoefC          = 6
   900      else
   901        call MessageNotify( 'E', module_name, 'Unsupported specie, %c', c1 = trim( Spec ) )
   902      end if
   903  
   904      if ( AbsCoef < 0.0_DP ) then
   905        xyrr_Trans = 1.0_DP
     .           if (1 + jmax - min0(1,jmax) .gt. 0) then                       
     .           j1 = and(1 + jmax - min0(1,jmax),3)                            
     .  !cdir    nodep                                                          
     .           do t638 = 1, j1                                                
     .  !cdir       nodep                                                       
     .              do t640 = 1, 1 + imax - min0(1,imax)                        
     .                 xyrr_trans(t640-1,t638,t636,t634) = 1.00000000000000e+000
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t638 = j1 + 1, 1 + jmax - min0(1,jmax), 4                   
     .  !cdir       nodep                                                       
     .              do t640 = 1, 1 + imax - min0(1,imax)                        
     .                 xyrr_trans(t640-1,t638,t636,t634) = 1.00000000000000e+000
     .                 xyrr_trans(t640-1,t638+1,t636,t634) =                    
     .       1            1.00000000000000e+000                                 
     .                 xyrr_trans(t640-1,t638+2,t636,t634) =                    
     .       1            1.00000000000000e+000                                 
     .                 xyrr_trans(t640-1,t638+3,t636,t634) =                    
     .       1            1.00000000000000e+000                                 
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
   906        return
   907      end if
   908  
   909  
   910      if ( ( Spec == 'H2OCont' ) .or. ( Spec == 'SubBandH2OCont' ) ) then
   911        call RadC2001ContScaleH2OAmt(                      &
   912          & xyz_DelAbsMass, xyz_Press, xyz_Temp, xyz_QMix, & ! (in)
   913          & xyz_DelAbsMassScaled                           & ! (out)
   914          & )
   915      else
   916        call RadC2001LineScaleAmt(                            &
   917          & xyz_DelAbsMass,                                   & ! (in)
   918          & xyz_Press, xyz_Temp,                              & ! (in)
   919          & RefPress, RefTemp, PressScaleIndex, CoefA, CoefB, & ! (in)
   920          & xyz_DelAbsMassScaled                              & ! (out)
   921          & )
   922      end if
   923  
   924      xyz_TransOneLayer = exp( - AbsCoef * xyz_DelAbsMassScaled )
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t568 = 1, xyz_delabsmassscaled.DSC.U3*(                        
     .       1   xyz_delabsmassscaled.DSC.U2*xyz_delabsmassscaled.DSC.U1 +      
     .       2   xyz_delabsmassscaled.DSC.U2)                                   
     .           xyz_transonelayer(t568-1,1,1) = dexp((-abscoef*                
     .       1      xyz_delabsmassscaled(t568-1,1,1)))                          
     .        enddo                                                             
   925  
   926      do k = 0, kmax
   927        kk = k
   928        xyrr_TransElem(:,:,k,kk) = 1.0_DP
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t580 = 1, xyrr_transelem.DSC.U2*xyrr_transelem.DSC.U1 +        
     .       1   xyrr_transelem.DSC.U2                                          
     .           xyrr_transelem(t580-1,1,k,kk) = 1.00000000000000e+000          
     .        enddo                                                             
   929        do kk = k+1, kmax
   930          xyrr_TransElem(:,:,k,kk) = xyrr_TransElem(:,:,k,kk-1) * xyz_TransOneLayer(:,:,kk)
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xyrr_transelem)                                            
     .        do t586 = 1, xyrr_transelem.DSC.U2*xyrr_transelem.DSC.U1 +        
     .       1   xyrr_transelem.DSC.U2                                          
     .           xyrr_transelem(t586-1,1,k,kk) = xyrr_transelem(t586-1,1,k,kk-1)
     .       1      *xyz_transonelayer(t586-1,1,kk)                             
     .        enddo                                                             
   931        end do
   932      end do
   933  
   934  
   935      ! initialization
   936      do k = 0, kmax
   937        do kk = k+1, kmax
   938          xyrr_Trans(:,:,k,kk) = 0.0_DP
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t596 = 1, jmax*imax                                            
     .           xyrr_trans(t596-1,1,k,kk) = 0.0000000000000000e+000            
     .        enddo                                                             
   939        end do
   940      end do
   941  
   942      ! Summation of fitted exponential functions
   943      Loop_Sum : do l = 1, NCoefC
   944  
   945        CoefC = a_CoefC(l)
   946  
   947        if ( CoefC > 0.0_DP ) then
   948  
   949          do k = 0, kmax
   950            do kk = k+1, kmax
   951              xyrr_Trans(:,:,k,kk) = xyrr_Trans(:,:,k,kk) &
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xyrr_transelem,xyrr_trans)                                 
     .        do t616 = 1, jmax*imax                                            
     .           xyrr_trans(t616-1,1,k,kk) = xyrr_trans(t616-1,1,k,kk) + coefc* 
     .       1      xyrr_transelem(t616-1,1,k,kk)                               
     .        enddo                                                             
   952                & + CoefC * xyrr_TransElem(:,:,k,kk)
   953            end do
   954          end do
   955  
   956          ! Calculate fitted exponential function used in next loop
   957          if ( l /= NCoefC ) then
   958            do k = 0, kmax
   959              do kk = k+1, kmax
   960                xyrr_TransElem(:,:,k,kk) = xyrr_TransElem(:,:,k,kk)**CoefN
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xyrr_transelem)                                            
     .        do t626 = 1, xyrr_transelem.DSC.U2*xyrr_transelem.DSC.U1 +        
     .       1   xyrr_transelem.DSC.U2                                          
     .           xyrr_transelem(t626-1,1,k,kk) = xyrr_transelem(t626-1,1,k,kk)**
     .       1      coefn                                                       
     .        enddo                                                             
   961              end do
   962            end do
   963          end if
   964  
   965        end if
   966  
   967      end do Loop_Sum
   968  
   969      do k = 0, kmax
   970        do kk = k, k
   971          xyrr_Trans(:,:,k,kk) = 1.0_DP
   972        end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t602 = 1, jmax*imax                                            
     .           xyrr_trans(t602-1,1,k,k) = 1.00000000000000e+000               
     .        enddo                                                             
   973      end do
   974      do k = 0, kmax
   975        do kk = 0, k-1
   976          xyrr_Trans(:,:,k,kk) = xyrr_Trans(:,:,kk,k)
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xyrr_trans)                                                
     .        do t608 = 1, jmax*imax                                            
     .           xyrr_trans(t608-1,1,k,kk) = xyrr_trans(t608-1,1,kk,k)          
     .        enddo                                                             
   977        end do
   978      end do
   979  
   980  
   981    end subroutine RadC2001CalcTrans
   982  
   983    !--------------------------------------------------------------------------------------
   984  
   985    subroutine RadC2001ContScaleH2OAmt(                   &
   986      & xyz_DelAbsMass, xyz_Press, xyz_Temp, xyz_QH2OVap, & ! (in)
   987      & xyz_ContDelAbsMassScaled                          & ! (out)
   988      & )
   989  
   990      ! Equation (4.21), (4.19)
   991  
   992      ! USE statements
   993      !
   994  
   995  
   996      real(DP), intent(in ) :: xyz_DelAbsMass          (0:imax-1, 1:jmax, 1:kmax)
   997      real(DP), intent(in ) :: xyz_Press               (0:imax-1, 1:jmax, 1:kmax)
   998      real(DP), intent(in ) :: xyz_Temp                (0:imax-1, 1:jmax, 1:kmax)
   999      real(DP), intent(in ) :: xyz_QH2OVap             (0:imax-1, 1:jmax, 1:kmax)
  1000      real(DP), intent(out) :: xyz_ContDelAbsMassScaled(0:imax-1, 1:jmax, 1:kmax)
  1001  
  1002  
  1003      !
  1004      ! Work variables
  1005      !
  1006      real(DP) :: xyz_PressH2O (0:imax-1, 1:jmax, 1:kmax)
  1007  
  1008  
  1009      ! 初期化確認
  1010      ! Initialization check
  1011      !
  1012      if ( .not. rad_C2001_inited ) then
  1013        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
  1014      end if
  1015  
  1016  
  1017      xyz_PressH2O            = xyz_Press * xyz_QH2OVap * MeanMolWeight / H2OMolWeight
     .        d2 = meanmolweight/h2omolweight                                   
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t104 = 1, kmax*jmax*imax                                       
     .           xyz_pressh2o1 = xyz_press(t104-1,1,1)*xyz_qh2ovap(t104-1,1,1)* 
     .       1      d2                                                          
     .           d3 = xyz_pressh2o1/1.01325000000000e+005                       
     .           xyz_contdelabsmassscaled(t104-1,1,1) = xyz_delabsmass(t104-1,1,
     .       1      1)*d3*dexp(1.80000000000000e+003*(1.00000000000000e+000/    
     .       2      xyz_temp(t104-1,1,1)-3.37837837837837e-003))                
     .        enddo                                                             
  1018      xyz_ContDelAbsMassScaled = xyz_DelAbsMass                      &
  1019        & * xyz_PressH2O / 101325d0                                  & ! Pa to atm.
  1020        & * exp( 1800.0d0 * ( 1.0d0 / xyz_Temp - 1.0d0 / 296.0d0 ) )
  1021  
  1022  
  1023    end subroutine RadC2001ContScaleH2OAmt
  1024  
  1025    !--------------------------------------------------------------------------------------
  1026  
  1027    subroutine RadC2001LineScaleAmt(                      &
  1028      & xyz_DelAbsMass,                                   & ! (in)
  1029      & xyz_Press, xyz_Temp,                              & ! (in)
  1030      & RefPress, RefTemp, PressScaleIndex, CoefA, CoefB, & ! (in)
  1031      & xyz_DelAbsMassScaled                              & ! (out)
  1032      & )
  1033  
  1034      ! Equation (4.4)
  1035  
  1036      ! USE statements
  1037      !
  1038  
  1039      real(DP), intent(in ) :: xyz_DelAbsMass      (0:imax-1, 1:jmax, 1:kmax)
  1040      real(DP), intent(in ) :: xyz_Press           (0:imax-1, 1:jmax, 1:kmax)
  1041      real(DP), intent(in ) :: xyz_Temp            (0:imax-1, 1:jmax, 1:kmax)
  1042      real(DP), intent(in ) :: RefPress
  1043      real(DP), intent(in ) :: RefTemp
  1044      real(DP), intent(in ) :: PressScaleIndex
  1045      real(DP), intent(in ) :: CoefA
  1046      real(DP), intent(in ) :: CoefB
  1047      real(DP), intent(out) :: xyz_DelAbsMassScaled(0:imax-1, 1:jmax, 1:kmax)
  1048  
  1049  
  1050      !
  1051      ! Work variables
  1052      !
  1053  
  1054  
  1055      ! 初期化確認
  1056      ! Initialization check
  1057      !
  1058      if ( .not. rad_C2001_inited ) then
  1059        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
  1060      end if
  1061  
  1062  
  1063      xyz_DelAbsMassScaled = xyz_DelAbsMass                                     &
     .        d1 = 1.D0/refpress                                                
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t87 = 1, kmax*jmax*imax                                        
     .           xyz_delabsmassscaled(t87-1,1,1) = xyz_delabsmass(t87-1,1,1)*(  
     .       1      xyz_press(t87-1,1,1)*d1)**pressscaleindex*(                 
     .       2      1.00000000000000e+000 + coefa*(xyz_temp(t87-1,1,1)-reftemp)+
     .       3      coefb*(xyz_temp(t87-1,1,1)-reftemp)**2)                     
     .        enddo                                                             
  1064        & * ( xyz_Press / RefPress )**PressScaleIndex                           &
  1065        & * ( 1.0_DP + CoefA * ( xyz_Temp - RefTemp ) + CoefB * ( xyz_Temp - RefTemp )**2 )
  1066  
  1067  
  1068    end subroutine RadC2001LineScaleAmt
  1069  
  1070    !--------------------------------------------------------------------------------------
  1071  
  1072    subroutine RadC2001CalcIntegratedPF3D(  &
  1073      & iband, km, xyz_Temp,                &
  1074      & xyz_IntegPF,                        &
  1075      & flag_DPFDT                          &
  1076      & )
  1077  
  1078      ! USE statements
  1079      !
  1080  
  1081  
  1082      integer , intent(in )           :: iband
  1083      integer , intent(in )           :: km
  1084      real(DP), intent(in )           :: xyz_Temp   (0:imax-1, 1:jmax, 1:km)
  1085      real(DP), intent(out)           :: xyz_IntegPF(0:imax-1, 1:jmax, 1:km)
  1086      logical , intent(in ), optional :: flag_DPFDT
  1087  
  1088      !
  1089      ! local variables
  1090      !
  1091      logical                     :: local_flag_DPFDT
  1092  
  1093  !!$    integer                     :: xyz_TempIndex(0:imax-1, 1:jmax, 1:km)
  1094      integer                     :: i
  1095      integer                     :: j
  1096      integer                     :: k
  1097      integer                     :: l
  1098  
  1099  
  1100      ! 初期化確認
  1101      ! Initialization check
  1102      !
  1103      if ( .not. rad_C2001_inited ) then
  1104        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
  1105      end if
  1106  
  1107  
  1108      ! Temperature check
  1109      !
  1110      do k = 1, km
  1111        do j = 1, jmax
  1112          do i = 0, imax-1
  1113            if ( ( xyz_Temp(i,j,k) < 150.0_DP ) .or. &
  1114              &  ( xyz_Temp(i,j,k) > 350.0_DP ) ) then
  1115              call MessageNotify( 'M', module_name, &
  1116                & 'Temperature is not appropriate, Temp(%d,%d,%d) = %f.', &
  1117                & i = (/i, j, k/), d = (/xyz_Temp(i,j,k)/) )
  1118            end if
  1119          end do
  1120        end do
  1121      end do
  1122  
  1123  
  1124      local_flag_DPFDT = .false.
  1125      if ( present( flag_DPFDT ) ) then
  1126        if ( flag_DPFDT ) then
  1127          local_flag_DPFDT = .true.
  1128        end if
  1129      end if
  1130  
  1131      if ( .not. local_flag_DPFDT ) then
  1132        ! Calculation of integrated Planck function
  1133  
  1134        xyz_IntegPF = aa_BandIntegPFCoefs(0,iband)
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t187 = 1, km*jmax*imax                                         
     .           xyz_integpf(t187-1,1,1) = aa_bandintegpfcoefs(0,iband)         
     .        enddo                                                             
  1135        do l = 1, 5
  1136          xyz_IntegPF = xyz_IntegPF + aa_BandIntegPFCoefs(l,iband) * xyz_Temp**l
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xyz_integpf,xyz_temp)                                      
     .        do t196 = 1, km*jmax*imax                                         
     .           xyz_integpf(t196-1,1,1) = xyz_integpf(t196-1,1,1) +            
     .       1      aa_bandintegpfcoefs(l,iband)*xyz_temp(t196-1,1,1)**l        
     .        enddo                                                             
  1137        end do
  1138  
  1139      else
  1140        ! Calculation of derivative of integrated Planck function
  1141  
  1142        xyz_IntegPF = aa_BandIntegPFCoefs(1,iband)
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t163 = 1, km*jmax*imax                                         
     .           xyz_integpf(t163-1,1,1) = aa_bandintegpfcoefs(1,iband)         
     .        enddo                                                             
  1143        do l = 2, 5
  1144          xyz_IntegPF = xyz_IntegPF + aa_BandIntegPFCoefs(l,iband) * l * xyz_Temp**(l-1)
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xyz_integpf,xyz_temp)                                      
     .        do t172 = 1, km*jmax*imax                                         
     .           xyz_integpf(t172-1,1,1) = xyz_integpf(t172-1,1,1) +            
     .       1      aa_bandintegpfcoefs(l,iband)*dfloat(l)*xyz_temp(t172-1,1,1) 
     .       2      **(l - 1)                                                   
     .        enddo                                                             
  1145        end do
  1146  
  1147      end if
  1148  
  1149  
  1150    end subroutine RadC2001CalcIntegratedPF3D
  1151  
  1152    !--------------------------------------------------------------------------------------
  1153  
  1154    subroutine RadC2001CalcIntegratedPF2D(  &
  1155      & iband, xy_Temp,                     &
  1156      & xy_IntegPF,                         &
  1157      & flag_DPFDT                          &
  1158      & )
  1159  
  1160      ! USE statements
  1161      !
  1162  
  1163      integer , intent(in )           :: iband
  1164      real(DP), intent(in )           :: xy_Temp   (0:imax-1, 1:jmax)
  1165      real(DP), intent(out)           :: xy_IntegPF(0:imax-1, 1:jmax)
  1166      logical , intent(in ), optional :: flag_DPFDT
  1167  
  1168      !
  1169      ! local variables
  1170      !
  1171      real(DP) :: xyz_Temp   (0:imax-1, 1:jmax, 1)
  1172      real(DP) :: xyz_IntegPF(0:imax-1, 1:jmax, 1)
  1173  
  1174  
  1175      ! 初期化確認
  1176      ! Initialization check
  1177      !
  1178      if ( .not. rad_C2001_inited ) then
  1179        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
  1180      end if
  1181  
  1182  
  1183      xyz_Temp(:,:,1) = xy_Temp
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t59 = 1, xyz_temp.DSC.U2*xyz_temp.DSC.U1 + xyz_temp.DSC.U2     
     .           xyz_temp(t59-1,1,1) = xy_temp(t59-1,1)                         
     .        enddo                                                             
  1184  
  1185      call RadC2001CalcIntegratedPF3D(        &
  1186        & iband, 1, xyz_temp,                 &
  1187        & xyz_IntegPF,                        &
  1188        & flag_DPFDT                          &
  1189        & )
  1190  
  1191      xy_IntegPF = xyz_IntegPF(:,:,1)
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t67 = 1, jmax*imax                                             
     .           xy_integpf(t67-1,1) = xyz_integpf(t67-1,1,1)                   
     .        enddo                                                             
  1192  
  1193  
  1194    end subroutine RadC2001CalcIntegratedPF2D
  1195  
  1196    !--------------------------------------------------------------------------------------
  1197  
  1198    subroutine RadC2001Init
  1199  
  1200  
  1201  !!$    ! ファイル入出力補助
  1202  !!$    ! File I/O support
  1203  !!$    !
  1204  !!$    use dc_iounit, only: FileOpen
  1205  !!$
  1206  !!$    ! NAMELIST ファイル入力に関するユーティリティ
  1207  !!$    ! Utilities for NAMELIST file input
  1208  !!$    !
  1209  !!$    use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid
  1210  
  1211  
  1212  !!$    integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号.
  1213  !!$                              ! Unit number for NAMELIST file open
  1214  !!$    integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT.
  1215  !!$                              ! IOSTAT of NAMELIST read
  1216  
  1217      integer :: l
  1218  
  1219  !!$    namelist /rad_C1991_nml/ &
  1220  !!$      & flag_save_time
  1221  
  1222  
  1223      if ( rad_C2001_inited ) return
  1224  
  1225  
  1226  !!$    ! NAMELIST is input
  1227  !!$    !
  1228  !!$    if ( trim(namelist_filename) /= '' ) then
  1229  !!$      call FileOpen( unit_nml, &          ! (out)
  1230  !!$        & namelist_filename, mode = 'r' ) ! (in)
  1231  !!$
  1232  !!$      rewind( unit_nml )
  1233  !!$      read( unit_nml,                        & ! (in)
  1234  !!$        & nml = rad_dcpam_E_LW_V2_nml, & ! (out)
  1235  !!$        & iostat = iostat_nml )                ! (out)
  1236  !!$      close( unit_nml )
  1237  !!$
  1238  !!$      call NmlutilMsg( iostat_nml, module_name ) ! (in)
  1239  !!$    end if
  1240  
  1241  
  1242      ! Convert unit from cm-1 to m-1
  1243      aa_BandWN = aa_BandWN * 1.0d2
  1244  
  1245      ! Convert unit from gm-1 cm2 to kg-1 m2
  1246      do l = 1, nbmax
  1247        aa_BandH2OLineParams(1,l) = aa_BandH2OLineParams(1,l) * 1.0d-4 * 1.0d3
  1248      end do
  1249      do l = 1, nbmax
  1250        if ( aa_BandH2OContParams(1,l) > 0.0_DP ) then
  1251          aa_BandH2OContParams(1,l) = aa_BandH2OContParams(1,l) * 1.0d-4 * 1.0d3
  1252        end if
  1253      end do
     .  !cdir nodep                                                             
     .        do t100 = 0, 9                                                    
     .           aa_bandwn(1,t100+1) = aa_bandwn(1,t100+1)*1.00000000000000e+002
     .           aa_bandwn(2,t100+1) = aa_bandwn(2,t100+1)*1.00000000000000e+002
     .        enddo                                                             
     .  !cdir nodep                                                             
     .        do l = 1, 10                                                      
     .           aa_bandh2olineparams(1,l) = (1.00000000000000e-004*            
     .       1      1.00000000000000e+003)*aa_bandh2olineparams(1,l)            
     .           if (aa_bandh2ocontparams(1,l) .gt. 0.0000000000000000e+000)    
     .       1      then                                                        
     .              aa_bandh2ocontparams(1,l) = (1.00000000000000e-004*         
     .       1         1.00000000000000e+003)*aa_bandh2ocontparams(1,l)         
     .           endif                                                          
     .        enddo                                                             
  1254  
  1255  
  1256      ! Convert unit from cm-1 to m-1
  1257      aa_SubBandWN = aa_SubBandWN * 1.0d2
     .        aa_subbandwn(1,1) = aa_subbandwn(1,1)*1.00000000000000e+002       
     .        aa_subbandwn(2,1) = aa_subbandwn(2,1)*1.00000000000000e+002       
     .        aa_subbandwn(1,2) = aa_subbandwn(1,2)*1.00000000000000e+002       
     .        aa_subbandwn(2,2) = aa_subbandwn(2,2)*1.00000000000000e+002       
     .        aa_subbandwn(1,3) = aa_subbandwn(1,3)*1.00000000000000e+002       
     .        aa_subbandwn(2,3) = aa_subbandwn(2,3)*1.00000000000000e+002       
  1258  
  1259      ! Convert unit from gm-1 cm2 to kg-1 m2
  1260      do l = 1, nsbmax
  1261        aa_SubBandH2OLineParams(1,l) = aa_SubBandH2OLineParams(1,l) * 1.0d-4 * 1.0d3
  1262      end do
     .        aa_subbandh2olineparams(1,1) = aa_subbandh2olineparams(1,1)*      
     .       1   1.00000000000000e-004*1.00000000000000e+003                    
     .        aa_subbandh2olineparams(1,2) = aa_subbandh2olineparams(1,2)*      
     .       1   1.00000000000000e-004*1.00000000000000e+003                    
     .        aa_subbandh2olineparams(1,3) = aa_subbandh2olineparams(1,3)*      
     .       1   1.00000000000000e-004*1.00000000000000e+003                    
  1263      do l = 1, nsbmax
  1264        aa_SubBandH2OContParams(1,l) = aa_SubBandH2OContParams(1,l) * 1.0d-4 * 1.0d3
  1265      end do
     .        aa_subbandh2ocontparams(1,1) = aa_subbandh2ocontparams(1,1)*      
     .       1   1.00000000000000e-004*1.00000000000000e+003                    
     .        aa_subbandh2ocontparams(1,2) = aa_subbandh2ocontparams(1,2)*      
     .       1   1.00000000000000e-004*1.00000000000000e+003                    
     .        aa_subbandh2ocontparams(1,3) = aa_subbandh2ocontparams(1,3)*      
     .       1   1.00000000000000e-004*1.00000000000000e+003                    
  1266  
  1267      ! Convert unit from {(cm-atm)_{STP}}^{-1} to m2 kg-1
  1268      !   MEMO: In a calculation below, GasRUniv variable in constants module can be used.
  1269      !         But, I do not use it, since unit of value is just converted by
  1270      !         multiplying a factor. Of course, non-use of GasRUniv must not cause
  1271      !         significant effect on result.
  1272      do l = 1, 2
  1273        aa_SubBandCO2LineParams(1,l) = aa_SubBandCO2LineParams(1,l) &
  1274          & * 1.0d2 / 101325.0d0 * 8.31432d0 / ( 44.0d-3 ) * 273.15d0
  1275      end do
     .        aa_subbandco2lineparams(1,1) = aa_subbandco2lineparams(1,1)*      
     .       1   1.00000000000000e+002/1.01325000000000e+005*                   
     .       2   8.31432000000000e+000/4.39999999999999e-002*                   
     .       3   2.73149999999999e+002                                          
     .        aa_subbandco2lineparams(1,2) = aa_subbandco2lineparams(1,2)*      
     .       1   1.00000000000000e+002/1.01325000000000e+005*                   
     .       2   8.31432000000000e+000/4.39999999999999e-002*                   
     .       3   2.73149999999999e+002                                          
  1276  
  1277  
  1278      ! 印字 ; Print
  1279      !
  1280      call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
  1281  !!$    call MessageNotify( 'M', module_name, '  DelTimeCalcTrans  = %f [%c]', &
  1282  !!$      & d = (/ DelTimeCalcTransValue /), c1 = trim( DelTimeCalcTransUnit ) )
  1283      call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
  1284  
  1285  
  1286      rad_C2001_inited = .true.
  1287  
  1288    end subroutine RadC2001Init
  1289  
  1290    !--------------------------------------------------------------------------------------
  1291  
  1292  end module rad_C2001
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:52 2016
FILE NAME: rad_C2001.f90
PROGRAM NAME: 
DIAGNOSTIC LIST

  LINE  LEVEL( NO.): DIAGNOSTIC MESSAGE

  1293  warn (   6): Only comment lines in program.
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:52 2016
FILE NAME: rad_C2001.f90
PROGRAM NAME: 
TRANSFORMATION LIST

  LINE                   FORTRAN STATEMENT

  1293  
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:52 2016
FILE NAME: rad_C2001.f90
PROGRAM NAME: rad_c2001
FORMAT LIST

  LINE    LOOP      FORTRAN STATEMENT

     1:             != Chou et al. (2001) による長波放射モデル
     2:             !
     3:             != Long radiation model described by Chou et al. (2001)
     4:             !
     5:             ! Authors::   Yoshiyuki O. TAKAHASHI
     6:             ! Version::   $Id: rad_C2001.f90,v 1.4 2013/01/27 11:31:14 yot Exp $
     7:             ! Tag Name::  $Name:  $
     8:             ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9:             ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10:             !
    11:             
    12:             module rad_C2001
    13:               !
    14:               != Chou et al. (2001) による長波放射モデル
    15:               !
    16:               != Long radiation model described by Chou et al. (2001)
    17:               !
    18:               ! <b>Note that Japanese and English are described in parallel.</b>
    19:               !
    20:               ! 長波放射モデル.
    21:               !
    22:               ! This is a model of long wave radiation. 
    23:               !
    24:               !== References
    25:               !
    26:               !  Chou, M.-D., M. J. Suarez, X.-Z. Liang, and M. M.-H. Yan, 
    27:               !    A thermal infrared radiation parameterization for atmospheric studies, 
    28:               !    NASA Technical Report Series on Global Modeling and Data Assimilation, 
    29:               !    19, NASA/TM-2001-104606, 2001.
    30:               !
    31:               !== Procedures List
    32:               !
    33:             !!$  ! RadiationFluxDennouAGCM :: 放射フラックスの計算
    34:             !!$  ! RadiationDTempDt        :: 放射フラックスによる温度変化の計算
    35:             !!$  ! RadiationFluxOutput     :: 放射フラックスの出力
    36:             !!$  ! RadiationFinalize       :: 終了処理 (モジュール内部の変数の割り付け解除)
    37:             !!$  ! ------------            :: ------------
    38:             !!$  ! RadiationFluxDennouAGCM :: Calculate radiation flux
    39:             !!$  ! RadiationDTempDt        :: Calculate temperature tendency with radiation flux
    40:             !!$  ! RadiationFluxOutput     :: Output radiation fluxes
    41:             !!$  ! RadiationFinalize       :: Termination (deallocate variables in this module)
    42:               !
    43:               !== NAMELIST
    44:               !
    45:             !!$  ! NAMELIST#radiation_DennouAGCM_nml
    46:               !
    47:             
    48:               ! USE statements
    49:               !
    50:             
    51:               ! 
    52:               ! Kind type parameter
    53:               !
    54:               use dc_types, only: DP, &      ! Double precision.
    55:                 &                 STRING, &  ! Strings.
    56:                 &                 TOKEN      ! Keywords.
    57:             
    58:               ! メッセージ出力
    59:               ! Message output
    60:               !
    61:               use dc_message, only: MessageNotify
    62:             
    63:               !
    64:               ! Grid points settings
    65:               !
    66:               use gridset, only: imax, & ! 
    67:                                          ! Number of grid points in longitude
    68:                 &                jmax, & ! 
    69:                                          ! Number of grid points in latitude
    70:                 &                kmax    ! 
    71:                                          ! Number of vertical level
    72:             
    73:               ! Declaration statements
    74:               !
    75:               implicit none
    76:               private
    77:             
    78:             
    79:               integer , parameter         :: nbmax = 10
    80:             
    81:               real(DP)             , save :: aa_BandWN              (1:2, 1:nbmax)
    82:               real(DP)             , save :: aa_BandIntegPFCoefs    (0:5, 1:nbmax)
    83:               real(DP)             , save :: aa_BandH2OSclParams    (1:5, 1:nbmax)
    84:               real(DP)             , save :: aa_BandH2OLineParams   (1:8, 1:nbmax)
    85:               real(DP)             , save :: aa_BandH2OContParams   (1:1, 1:nbmax)
    86:             
    87:               integer , parameter         :: nsbmax = 3
    88:               real(DP)             , save :: aa_SubBandWN           (1:2, 1:nsbmax)
    89:               real(DP)             , save :: aa_SubBandH2OSclParams (1:5, 1:nsbmax)
    90:               real(DP)             , save :: aa_SubBandH2OLineParams(1:8, 1:nsbmax)
    91:               real(DP)             , save :: aa_SubBandH2OContParams(1:1, 1:nsbmax)
    92:               real(DP)             , save :: aa_SubBandCO2SclParams (1:5, 1:2)
    93:               real(DP)             , save :: aa_SubBandCO2LineParams(1:8, 1:2)
    94:             
    95:               real(DP)             , save :: aa_BandN2OSclParams (1:5, 1:nbmax)
    96:               real(DP)             , save :: aa_BandN2OLineParams(1:8, 1:nbmax)
    97:               real(DP)             , save :: aa_BandCH4SclParams (1:5, 1:nbmax)
    98:               real(DP)             , save :: aa_BandCH4LineParams(1:8, 1:nbmax)
    99:             
   100:               real(DP)             , save :: aa_WeakBandCO2SclParams (1:5, 1:nbmax)
   101:               real(DP)             , save :: aa_WeakBandCO2LineParams(1:8, 1:nbmax)
   102:             
   103:               integer , parameter         :: ncloudparam = 4
   104:               real(DP)             , save :: aa_BandCloudIceExtParams(1:ncloudparam, 1:nbmax)
   105:               real(DP)             , save :: aa_BandCloudIceSSAParams(1:ncloudparam, 1:nbmax)
   106:               real(DP)             , save :: aa_BandCloudIceAFParams (1:ncloudparam, 1:nbmax)
   107:               real(DP)             , save :: aa_BandCloudLiqExtParams(1:ncloudparam, 1:nbmax)
   108:               real(DP)             , save :: aa_BandCloudLiqSSAParams(1:ncloudparam, 1:nbmax)
   109:               real(DP)             , save :: aa_BandCloudLiqAFParams (1:ncloudparam, 1:nbmax)
   110:             
   111:             
   112:               ! MEMO:
   113:               ! Bands range from 0 to 3000 cm-1.
   114:               !
   115:             
   116:               ! Table 1
   117:               !
   118:               data aa_BandWN &
   119:                 & / &
   120:                 &    0.0d0,  340.0d0, & ! 1:H2O
   121:                 &  340.0d0,  540.0d0, & ! 2:H2O
   122:                 &  540.0d0,  800.0d0, & ! 3:H2O + CO2
   123:                 &  800.0d0,  980.0d0, & ! 4:H2O + CO2
   124:                 &  980.0d0, 1100.0d0, & ! 5:H2O + O3 + CO2
   125:                 & 1100.0d0, 1215.0d0, & ! 6:H2O + N2O + CH4
   126:                 & 1215.0d0, 1380.0d0, & ! 7:H2O + N2O + CH4
   127:                 & 1380.0d0, 1900.0d0, & ! 8:H2O
   128:                 & 1900.0d0, 3000.0d0, & ! 9:H2O
   129:                 &  540.0d0,  620.0d0  & !10:H2O + CO2 + N2O  ! This band is not used, now.
   130:                 & /
   131:             
   132:               ! Table 2
   133:               !
   134:               data aa_BandIntegPFCoefs &
   135:                 & / &
   136:                 ! c0         c1         c2         c3         c4         c5
   137:                 &  5.344e+0, -2.062e-1,  2.533e-3, -6.863e-6,  1.012e-8, -6.267e-12, & ! 1
   138:                 &  2.715e+1, -5.404e-1,  2.950e-3,  2.723e-7, -9.338e-9,  9.968e-12, & ! 2
   139:                 & -3.486e+1,  1.113e+0, -1.301e-2,  6.496e-5, -1.182e-7,  8.042e-11, & ! 3
   140:                 & -6.051e+1,  1.409e+0, -1.208e-2,  4.405e-5, -5.674e-8,  2.566e-11, & ! 4
   141:                 & -2.669e+1,  5.283e-1, -3.445e-3,  6.072e-6,  1.252e-8, -2.155e-11, & ! 5
   142:                 & -6.727e+0,  4.226e-2,  1.044e-3, -1.292e-5,  4.740e-8, -4.486e-11, & ! 6
   143:                 &  1.879e+1, -5.836e-1,  6.968e-3, -3.939e-5,  1.012e-7, -8.230e-11, & ! 7
   144:                 &  1.034e+2, -2.513e+0,  2.375e-2, -1.069e-4,  2.184e-7, -1.370e-10, & ! 8
   145:                 & -1.048e+1,  3.821e-1, -5.227e-3,  3.441e-5, -1.108e-7,  1.409e-10, & ! 9
   146:                 &  1.677e+0,  6.540e-2, -1.813e-3,  1.291e-5, -2.672e-8,  1.979e-11  & !10
   147:                 & /
   148:             
   149:             
   150:               ! Table 3
   151:               !
   152:               data aa_BandH2OSclParams &
   153:                 & / &
   154:                 !  pr        Tr        m         a         b
   155:                 &  500.0d2 , 250.0d0 , 1.0d0   , 0.0021d0, -1.01d-5, & ! 1:H2O
   156:                 &  500.0d2 , 250.0d0 , 1.0d0   , 0.0140d0,  5.57d-5, & ! 2:H2O
   157:                 &  -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, & ! 3:H2O + CO2
   158:                 &  500.0d2 , 250.0d0 , 1.0d0   , 0.0302d0,  2.96d-4, & ! 4:H2O
   159:                 &  500.0d2 , 250.0d0 , 1.0d0   , 0.0307d0,  2.86d-4, & ! 5:H2O + O3
   160:                 &  500.0d2 , 250.0d0 , 0.77d0  , 0.0195d0,  1.11d-4, & ! 6:H2O
   161:                 &  500.0d2 , 250.0d0 , 0.5d0   , 0.0152d0,  7.61d-5, & ! 7:H2O
   162:                 &  500.0d2 , 250.0d0 , 1.0d0   , 0.0008d0, -3.52d-6, & ! 8:H2O
   163:                 &  500.0d2 , 250.0d0 , 1.0d0   , 0.0096d0,  1.64d-5, & ! 9:H2O
   164:                 &  500.0d2 , 250.0d0 , 1.0d0   , 0.0149d0,  6.20d-5  & !10:H2O
   165:                 & /
   166:             
   167:             
   168:               ! Table 4
   169:               !
   170:               data aa_BandH2OLineParams &
   171:                 & / &
   172:                 ! k1/mu    n   dg1       dg2       dg3       dg4       dg5       dg6
   173:                 & 2.96d1 ,  6, 0.2747d0, 0.2717d0, 0.2752d0, 0.1177d0, 0.0352d0, 0.0255d0, & ! 1
   174:                 & 4.17d-1,  6, 0.1521d0, 0.3974d0, 0.1778d0, 0.1826d0, 0.0374d0, 0.0527d0, & ! 2
   175:                 & -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, & ! 3
   176:                 & 5.25d-4,  6, 0.4654d0, 0.2991d0, 0.1343d0, 0.0646d0, 0.0226d0, 0.0140d0, & ! 4
   177:                 & 5.25d-4,  6, 0.5543d0, 0.2723d0, 0.1131d0, 0.0443d0, 0.0160d0, -1.0d100, & ! 5
   178:                 & 9.37d-3,  8, 0.5955d0, 0.2693d0, 0.0953d0, 0.0335d0, 0.0064d0, -1.0d100, & ! 6
   179:                 & 4.72d-2,  9, 0.1958d0, 0.3469d0, 0.3147d0, 0.1013d0, 0.0365d0, 0.0048d0, & ! 7
   180:                 & 1.32d0 ,  6, 0.0740d0, 0.1636d0, 0.4174d0, 0.1783d0, 0.1101d0, 0.0566d0, & ! 8
   181:                 & 5.25d-4, 16, 0.1437d0, 0.2197d0, 0.3185d0, 0.2351d0, 0.0647d0, 0.0183d0, & ! 9
   182:                 & 1.06d-1,  8, 0.3153d0, 0.4604d0, 0.1326d0, 0.0798d0, 0.0119d0, -1.0d100  & !10
   183:                 & /
   184:             
   185:               ! Table 9
   186:               !
   187:               data aa_BandH2OContParams &
   188:                 & / &
   189:                 ! k/mu
   190:                 & -1.0d100, & ! 1
   191:                 & -1.0d100, & ! 2
   192:                 & -1.0d100, & ! 3
   193:                 & 15.8d0  , & ! 4
   194:                 &  9.40d0 , & ! 5
   195:                 &  7.75d0 , & ! 6
   196:                 &  8.78d0 , & ! 7
   197:                 & -1.0d100, & ! 8
   198:                 & -1.0d100, & ! 9
   199:                 & -1.0d100  & !10
   200:                 & /
   201:             
   202:             
   203:               ! Table 1
   204:               !
   205:               data aa_SubBandWN &
   206:                 & / &
   207:                 &  540.0d0,  620.0d0, & ! 1:H2O + CO2
   208:                 &  620.0d0,  720.0d0, & ! 2:H2O + CO2
   209:                 &  720.0d0,  800.0d0  & ! 3:H2O + CO2
   210:                 & /
   211:             
   212:               ! Table 3
   213:               !
   214:               data aa_SubBandH2OSclParams &
   215:                 & / &
   216:                 !  pr       Tr       m       a          b
   217:                 &  500.0d2, 250.0d0, 1.0d0 , 0.0167d0,  8.54d-5, & ! 1
   218:                 &  500.0d2, 250.0d0, 1.0d0 , 0.0167d0,  8.54d-5, & ! 2
   219:                 &  500.0d2, 250.0d0, 1.0d0 , 0.0167d0,  8.54d-5  & ! 3
   220:                 & /
   221:             
   222:               ! Table 10 (H2O)
   223:               !
   224:               data aa_SubBandH2OLineParams &
   225:                 & / &
   226:                 ! k1        n  dg1       dg2       dg3       dg4       dg5       dg6
   227:                 & 1.33d-2 , 8, 0.1782d0, 0.0593d0, 0.0215d0, 0.0068d0, 0.0022d0, -1.0d100, & ! a
   228:                 & 1.33d-2 , 8, 0.0923d0, 0.1675d0, 0.0923d0, 0.0187d0, 0.0178d0, -1.0d100, & ! b
   229:                 & 1.33d-2 , 8, 0.0000d0, 0.1083d0, 0.1581d0, 0.0455d0, 0.0274d0, 0.0041d0  & ! c
   230:                 & /
   231:             
   232:               ! Table 9
   233:               !
   234:               data aa_SubBandH2OContParams &
   235:                 & / &
   236:                 ! k/mu
   237:                 & 109.6d0 , & ! 1
   238:                 &  54.8d0 , & ! 2
   239:                 &  27.4d0   & ! 3
   240:                 & /
   241:             
   242:               ! Table 3
   243:               !   Memo: Parameters to scale absorber amount are given for three subbands 
   244:               !         in Table 3 (below). But, parameters for k-distribution methods, 
   245:               !         i.e., absorption coefficients and width of bins, are only given 
   246:               !         for two bands of "Wings" and "Center" in Table 10.
   247:               !         So, k-distribution parameters in 3c is regarded as same as those 
   248:               !         in 3a. 
   249:               !         See brief description about this in p. 23.
   250:             !!$  data aa_SubBandCO2SclParams &
   251:             !!$    & / &
   252:             !!$    !  pr       Tr       m      a          b
   253:             !!$    &  300.0d2 , 250.0d0 , 0.5d0   , 0.0179d0,  1.02d-4, & ! 1:H2O + CO2
   254:             !!$    &   30.0d2 , 250.0d0 , 0.85d0  , 0.0042d0,  2.00d-5, & ! 2:H2O + CO2
   255:             !!$    &  300.0d2 , 250.0d0 , 0.5d0   , 0.0184d0,  1.12d-4  & ! 3:H2O + CO2
   256:             !!$    & /
   257:               data aa_SubBandCO2SclParams &
   258:                 & / &
   259:                 !  pr        Tr        m       a          b
   260:                 &  300.0d2 , 250.0d0 , 0.5d0 , 0.0179d0,  1.02d-4, & ! Wings
   261:                 &   30.0d2 , 250.0d0 , 0.85d0, 0.0042d0,  2.00d-5  & ! Center
   262:                 & /
   263:             
   264:               ! Table 10 (CO2)
   265:               !
   266:               data aa_SubBandCO2LineParams &
   267:                 & / &
   268:                 ! k1        n  dg1       dg2       dg3       dg4       dg5       dg6
   269:                 & 2.66d-5,  8, 0.1395d0, 0.1407d0, 0.1549d0, 0.1357d0, 0.0182d0, 0.0220d0, & ! Wings
   270:                 & 2.66d-3,  8, 0.0766d0, 0.1372d0, 0.1189d0, 0.0335d0, 0.0169d0, 0.0059d0  & ! Center
   271:                 & /
   272:             
   273:             
   274:               ! Table 5 (N2O)
   275:               !
   276:               data aa_BandN2OLineParams &
   277:                 & / &
   278:                 ! k1       n   dg1       dg2       dg3       dg4       dg5       dg6
   279:                 & -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, & ! 1
   280:                 & -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, & ! 2
   281:                 & -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, & ! 3
   282:                 & -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, & ! 4
   283:                 & -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, & ! 5
   284:                 & 6.32d-2, 21, 0.9404d0, 0.0596d0, -1.0d100, -1.0d100, -1.0d100, -1.0d100, & ! 6
   285:                 & 5.36d-2,  8, 0.5620d0, 0.1387d0, 0.2406d0, 0.0587d0, -1.0d100, -1.0d100, & ! 7
   286:                 & -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, & ! 8
   287:                 & -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, & ! 9
   288:                 & 2.52d-1, 58, 0.971d0 , 0.029d0 , -1.0d100, -1.0d100, -1.0d100, -1.0d100  & !10
   289:                 & /
   290:               data aa_BandN2OSclParams &
   291:                 & / &
   292:                 !  pr        Tr        m       a          b
   293:                 & -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, & ! 1
   294:                 & -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, & ! 2
   295:                 & -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, & ! 3
   296:                 & -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, & ! 4
   297:                 & -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, & ! 5
   298:                 &  500.0d2 , 250.0d0 , 0.0d0 , 1.93d-3 ,  4.38d-6, & ! 6
   299:                 &  500.0d2 , 250.0d0 , 0.48d0, 1.38d-3 ,  7.48d-6, & ! 7
   300:                 & -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, & ! 8
   301:                 & -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, & ! 9
   302:                 &  500.0d2 , 250.0d0 , 0.0d0 , 1.45d-3 ,  3.67d-6  & !10
   303:                 & /
   304:             
   305:               ! Table 5 (CH4)
   306:               !
   307:               data aa_BandCH4LineParams &
   308:                 & / &
   309:                 ! k1       n   dg1       dg2       dg3       dg4       dg5       dg6
   310:                 & -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, & ! 1
   311:                 & -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, & ! 2
   312:                 & -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, & ! 3
   313:                 & -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, & ! 4
   314:                 & -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, & ! 5
   315:                 & 5.81d-3,  1, 1.0d0   , -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, & ! 6
   316:                 & 6.29d-2, 12, 0.6107d0, 0.2802d0, 0.1073d0, 0.0018d0, -1.0d100, -1.0d100, & ! 7
   317:                 & -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, & ! 8
   318:                 & -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, & ! 9
   319:                 & -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100  & !10
   320:                 & /
   321:               data aa_BandCH4SclParams &
   322:                 & / &
   323:                 !  pr        Tr        m       a          b
   324:                 & -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, & ! 1
   325:                 & -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, & ! 2
   326:                 & -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, & ! 3
   327:                 & -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, & ! 4
   328:                 & -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, & ! 5
   329:                 &  500.0d2 , 250.0d0 , 0.0d0 , 1.70d-2 ,  1.58d-4, & ! 6
   330:                 &  500.0d2 , 250.0d0 , 0.65d0, 5.96d-4 , -2.29d-6, & ! 7
   331:                 & -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, & ! 8
   332:                 & -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, & ! 9
   333:                 & -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100  & !10
   334:                 & /
   335:             
   336:               ! Table 6
   337:               !
   338:               data aa_WeakBandCO2LineParams &
   339:                 & / &
   340:                 ! k1       n   dg1       dg2       dg3       dg4       dg5       dg6
   341:                 & -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, & ! 1
   342:                 & -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, & ! 2
   343:                 & -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, & ! 3
   344:                 & 1.92d-7,  5, 0.1216d0, 0.2436d0, 0.2498d0, 0.2622d0, 0.0781d0, 0.0427d0, & ! 4
   345:                 & 1.92d-7,  5, 0.0687d0, 0.1480d0, 0.1951d0, 0.3344d0, 0.1720d0, 0.0818d0, & ! 5
   346:                 & -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, & ! 6
   347:                 & -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, & ! 7
   348:                 & -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, & ! 8
   349:                 & -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, & ! 9
   350:                 & 2.66d-5,  8, 0.267d0 , 0.220d0 , 0.210d0 , 0.241d0 , 0.020d0 , 0.042d0   & !10
   351:                 & /
   352:               data aa_WeakBandCO2SclParams &
   353:                 & / &
   354:                 !  pr        Tr        m       a          b
   355:                 & -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, & ! 1
   356:                 & -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, & ! 2
   357:                 & -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, & ! 3
   358:                 &  500.0d2 , 250.0d0 , 0.0d0 , 3.58d-2 ,  4.05d-4, & ! 4
   359:                 &  500.0d2 , 250.0d0 , 0.0d0 , 3.43d-2 ,  3.74d-4, & ! 5
   360:                 & -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, & ! 6
   361:                 & -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, & ! 7
   362:                 & -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, & ! 8
   363:                 & -1.0d100, -1.0d100, -1.0d100, -1.0d100, -1.0d100, & ! 9
   364:                 &  300.0d2 , 250.0d0 , 0.5d0 , 1.79d-2 ,  1.02d-4  & !10
   365:                 & /
   366:             
   367:             
   368:             
   369:               ! Table 11a
   370:               !   Unit of effective radius of particle is micron meter.
   371:               !   Unit of extinction parameters would be g-1 m2 ?
   372:               data aa_BandCloudIceExtParams &
   373:                 & / &
   374:                 & -0.44171, 0.62951, 0.06465, -1.0d100, &
   375:                 & -0.13727, 0.61291, 0.28962, -1.0d100, &
   376:                 & -0.01878, 1.67680, 0.79080, -1.0d100, &
   377:                 & -0.01896, 1.06510, 0.69493, -1.0d100, &
   378:                 & -0.04788, 0.88178, 0.54492, -1.0d100, &
   379:                 & -0.02265, 1.57390, 0.76161, -1.0d100, &
   380:                 & -0.01038, 2.15640, 0.89045, -1.0d100, &
   381:                 & -0.00450, 2.51370, 0.95989, -1.0d100, &
   382:                 & -0.00044, 3.15050, 1.03750, -1.0d100, &
   383:                 & -0.02956, 1.44680, 0.71283, -1.0d100  &
   384:                 & /
   385:             
   386:               ! Table 11b
   387:               !   Unit of effective radius of particle is micron meter.
   388:               !   Unit of extinction parameters would be g-1 m2 ?
   389:               data aa_BandCloudLiqExtParams &
   390:                 & / &
   391:                 & 0.08641,  0.01769, -1.5572E-3,  3.4896E-5, &
   392:                 & 0.22027,  0.00997, -1.8719E-3,  5.3112E-5, &
   393:                 & 0.38074, -0.03027,  1.0154E-3, -1.1849E-5, &
   394:                 & 0.15587,  0.00371, -7.7705E-4,  2.0547E-5, &
   395:                 & 0.05518,  0.04544, -4.2067E-3,  1.0184E-4, &
   396:                 & 0.12724,  0.04751, -5.2037E-3,  1.3711E-4, &
   397:                 & 0.30390,  0.01656, -3.5271E-3,  1.0828E-4, &
   398:                 & 0.63617, -0.06287,  2.2350E-3, -2.3177E-5, &
   399:                 & 1.15470, -0.19282,  1.2084E-2, -2.5612E-4, &
   400:                 & 0.34021, -0.02805,  1.0654E-3, -1.5443E-5  &
   401:                 & /
   402:             
   403:               ! Table 12a
   404:               !   Unit of effective radius of particle is micron meter.
   405:               data aa_BandCloudIceSSAParams &
   406:                 & / &
   407:                 & 0.17201,  1.2229E-2, -1.4837E-4,  5.8020E-7, &
   408:                 & 0.81470, -2.7293E-3,  9.7816E-8,  5.7650E-8, &
   409:                 & 0.54859, -4.8273E-4,  5.4353E-6, -1.5679E-8, &
   410:                 & 0.39218,  4.1717E-3, -4.8869E-5,  1.9144E-7, &
   411:                 & 0.71773, -3.3640E-3,  1.9713E-5, -3.3189E-8, &
   412:                 & 0.77345, -5.5228E-3,  4.8379E-5, -1.5151E-7, &
   413:                 & 0.74975, -5.6604E-3,  5.6475E-5, -1.9664E-7, &
   414:                 & 0.69011, -4.5348E-3,  4.9322E-5, -1.8255E-7, &
   415:                 & 0.83963, -6.7253E-3,  6.1900E-5, -2.0862E-7, &
   416:                 & 0.64860, -2.8692E-3,  2.7656E-5, -8.9680E-8  &
   417:                 & /
   418:             
   419:               ! Table 12b
   420:               !   Unit of effective radius of particle is micron meter.
   421:               data aa_BandCloudLiqSSAParams &
   422:                 & / &
   423:                 &  0.17201,  1.2229E-2, -1.4837E-4, 5.8020E-7, &
   424:                 & -0.01338,  9.3134E-2, -6.0491E-3, 1.3059E-4, &
   425:                 &  0.03710,  7.3211E-2, -4.4211E-3, 9.2448E-5, &
   426:                 & -0.00376,  9.3344E-2, -5.6561E-3, 1.1387E-4, &
   427:                 &  0.40212,  7.8083E-2, -5.9583E-3, 1.2883E-4, &
   428:                 &  0.57928,  5.9094E-2, -5.4425E-3, 1.2725E-4, &
   429:                 &  0.68974,  4.2334E-2, -4.9469E-3, 1.2863E-4, &
   430:                 &  0.80122,  9.4578E-3, -2.8508E-3, 9.0078E-5, &
   431:                 &  1.02340, -2.6204E-2,  4.2552E-4, 3.2160E-6, &
   432:                 &  0.05092,  7.5409E-2, -4.7305E-3, 1.0121E-4  &
   433:                 & /
   434:             
   435:               ! Table 13a
   436:               !   Unit of effective radius of particle is micron meter.
   437:               data aa_BandCloudIceAFParams &
   438:                 & / &
   439:                 & 0.57867, 1.0135E-2, -1.1142E-4, 4.1537E-7, &
   440:                 & 0.72259, 3.1149E-3, -1.9927E-5, 5.6024E-8, &
   441:                 & 0.76109, 4.5449E-3, -4.6199E-5, 1.6446E-7, &
   442:                 & 0.86934, 2.7474E-3, -3.1301E-5, 1.1959E-7, &
   443:                 & 0.89103, 1.8513E-3, -1.6551E-5, 5.5193E-8, &
   444:                 & 0.86325, 2.1408E-3, -1.6846E-5, 4.9473E-8, &
   445:                 & 0.85064, 2.5028E-3, -2.0812E-5, 6.3427E-8, &
   446:                 & 0.86945, 2.4615E-3, -2.3882E-5, 8.2431E-8, &
   447:                 & 0.80122, 3.1906E-3, -2.4856E-5, 7.2411E-8, &
   448:                 & 0.73290, 4.8034E-3, -4.4425E-5, 1.4839E-7  &
   449:                 & /
   450:             
   451:               ! Table 13b
   452:               !   Unit of effective radius of particle is micron meter.
   453:               data aa_BandCloudLiqAFParams &
   454:                 & / &
   455:                 & -0.51930,  0.20290  , -1.1747E-2,  2.3868E-4, &
   456:                 & -0.22151,  0.19708  , -1.2462E-2,  2.6646E-4, &
   457:                 &  0.14157,  0.14705  , -9.5802E-3,  2.0819E-4, &
   458:                 &  0.41590,  0.10482  , -6.9118E-3,  1.5115E-4, &
   459:                 &  0.55338,  7.7016E-2, -5.2218E-3,  1.1587E-4, &
   460:                 &  0.61384,  6.4402E-2, -4.6241E-3,  1.0746E-4, &
   461:                 &  0.67891,  4.8698E-2, -3.7021E-3,  9.1966E-5, &
   462:                 &  0.78169,  2.0803E-2, -1.4749E-3,  3.9362E-5, &
   463:                 &  0.93218, -3.3425E-2,  2.9632E-3, -6.9362E-5, &
   464:                 &  0.01649,  0.16561  , -1.0723E-2,  2.3220E-4  &
   465:                 & /
   466:             
   467:             
   468:               ! 
   469:               ! Public procedure
   470:               !
   471:               public :: RadC2001CalcTransBand3CO2
   472:               public :: RadC2001CalcTransBand3H2O
   473:               public :: RadC2001CalcTrans
   474:             
   475:               public :: RadC2001CalcCloudOptProp
   476:               public :: RadC2001ReduceCloudOptDep
   477:             
   478:               public :: RadC2001CalcIntegratedPF3D
   479:               public :: RadC2001CalcIntegratedPF2D
   480:             
   481:               public :: RadC2001Init
   482:             
   483:             
   484:               real(DP), save :: MeanMolWeight = 28.97d-3
   485:               real(DP), save :: H2OMolWeight  = 18.0d-3
   486:               real(DP), save :: CO2MolWeight  = 44.0d-3
   487:             
   488:             
   489:             
   490:               ! 公開変数
   491:               ! Public variables
   492:               !
   493:               logical, save :: rad_C2001_inited = .false.
   494:                                           ! 初期設定フラグ.
   495:                                           ! Initialization flag
   496:             
   497:             
   498:               character(*), parameter:: module_name = 'rad_C2001'
   499:                                           ! モジュールの名称.
   500:                                           ! Module name
   501:               character(*), parameter:: version = &
   502:                 & '$Name:  $' // &
   503:                 & '$Id: rad_C2001.f90,v 1.4 2013/01/27 11:31:14 yot Exp $'
   504:                                           ! モジュールのバージョン
   505:                                           ! Module version
   506:             
   507:             
   508:               !--------------------------------------------------------------------------------------
   509:             
   510:             contains
   511:             
   512:               !--------------------------------------------------------------------------------------
   513:             
   514:               subroutine RadC2001CalcCloudOptProp(       &
   515:                 & Spec, iband, xyz_REff,                       & ! (in)
   516:                 & xyz_ExtCoef, xyz_SSA, xyz_AF                 & ! (out)
   517:                 & )
   518:             
   519:                 ! USE statements
   520:                 !
   521:             
   522:             
   523:                 character(len=*), intent(in ) :: SPEC
   524:                 integer         , intent(in ) :: iband
   525:                 real(DP)        , intent(in ) :: xyz_REff   (0:imax-1, 1:jmax, 1:kmax)
   526:                 real(DP)        , intent(out) :: xyz_ExtCoef(0:imax-1, 1:jmax, 1:kmax)
   527:                 real(DP)        , intent(out) :: xyz_SSA    (0:imax-1, 1:jmax, 1:kmax)
   528:                 real(DP)        , intent(out) :: xyz_AF     (0:imax-1, 1:jmax, 1:kmax)
   529:             
   530:             
   531:                 !
   532:                 ! Work variables
   533:                 !
   534:                 real(DP) :: xyz_REffInMicron(0:imax-1, 1:jmax, 1:kmax)
   535:                 integer  :: l
   536:             
   537:             
   538:                 ! 初期化確認
   539:                 ! Initialization check
   540:                 !
   541:                 if ( .not. rad_C2001_inited ) then
   542:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   543:                 end if
   544:             
   545:             
   546: **W---->A       xyz_REffInMicron = xyz_REff * 1.0d6
   547: |||         
   548: |||     A       xyz_ExtCoef = 0.0_DP
   549: |||     A       xyz_SSA     = 0.0_DP
   550: **W---- A       xyz_AF      = 0.0_DP
   551:             
   552:                 if ( Spec == 'Ice' ) then
   553:                   ! Eq. (6.4a)
   554: **W---->          xyz_ExtCoef = aa_BandCloudIceExtParams(1,iband) &
   555: |||                 &     + aa_BandCloudIceExtParams(2,iband) &
   556: |||                 &       / xyz_REffInMicron**aa_BandCloudIceExtParams(3,iband)
   557: |||               !  Convert unit from g-1 m2 to kg-1 m2
   558: **W---- A         xyz_ExtCoef = xyz_ExtCoef * 1.0d3
   559: +------>          do l = 1, ncloudparam
   560: |                   ! Eq. (6.5)
   561: |**W--->A           xyz_SSA = xyz_SSA + aa_BandCloudIceSSAParams(l,iband) * xyz_REffInMicron**(l-1)
   562: ||||                ! Eq. (6.6)
   563: |**W--- A           xyz_AF  = xyz_AF  + aa_BandCloudIceAFParams (l,iband) * xyz_REffInMicron**(l-1)
   564: +------           end do
   565:                 else if ( Spec == 'Liquid' ) then
   566: +------>          do l = 1, ncloudparam
   567: |                   ! Eq. (6.4b)
   568: |W**=== A           xyz_ExtCoef = xyz_ExtCoef + aa_BandCloudLiqExtParams(l,iband) * xyz_REffInMicron**(l-1)
   569: +------           end do
   570:                   !  Convert unit from g-1 m2 to kg-1 m2
   571: W**==== A         xyz_ExtCoef = xyz_ExtCoef * 1.0d3
   572: +------>          do l = 1, ncloudparam
   573: |                   ! Eq. (6.5)
   574: |**W--->A           xyz_SSA = xyz_SSA + aa_BandCloudLiqSSAParams(l,iband) * xyz_REffInMicron**(l-1)
   575: ||||                ! Eq. (6.6)
   576: |**W--- A           xyz_AF  = xyz_AF  + aa_BandCloudLiqAFParams (l,iband) * xyz_REffInMicron**(l-1)
   577: +------           end do
   578:                 else
   579:                   call MessageNotify( 'E', module_name, 'Unsupported specie, %c', c1 = trim( Spec ) )
   580:                 end if
   581:             
   582:             
   583:               end subroutine RadC2001CalcCloudOptProp
   584:             
   585:               !--------------------------------------------------------------------------------------
   586:             
   587:               subroutine RadC2001ReduceCloudOptDep(      &
   588:                 & xyz_SSA, xyz_AF,                             & ! (in)
   589:                 & xyz_DelOptDep                                & ! (inout)
   590:                 & )
   591:             
   592:                 ! USE statements
   593:                 !
   594:             
   595:             
   596:                 real(DP), intent(in   ) :: xyz_SSA      (0:imax-1, 1:jmax, 1:kmax)
   597:                 real(DP), intent(in   ) :: xyz_AF       (0:imax-1, 1:jmax, 1:kmax)
   598:                 real(DP), intent(inout) :: xyz_DelOptDep(0:imax-1, 1:jmax, 1:kmax)
   599:             
   600:             
   601:                 !
   602:                 ! Work variables
   603:                 !
   604:                 real(DP) :: xyz_FuncF(0:imax-1, 1:jmax, 1:kmax)
   605:                 real(DP) :: a_CoefA(1:4)
   606:                 integer  :: l
   607:             
   608:                 data a_CoefA / 0.5d0, 0.3738d0, 0.0076d0, 0.1186d0 /
   609:             
   610:             
   611:                 ! 初期化確認
   612:                 ! Initialization check
   613:                 !
   614:                 if ( .not. rad_C2001_inited ) then
   615:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   616:                 end if
   617:             
   618:             
   619:                 ! Extinction coefficient is modified to account for effect of scattering.
   620:             
   621:                 ! Eq. (6.12)
   622:                 !
   623: W**====         xyz_FuncF = 0.0_DP
   624: +------>        do l = 1, 4
   625: |W**=== A         xyz_FuncF = xyz_FuncF + a_CoefA(l) * xyz_AF**(l-1)
   626: +------         end do
   627:             
   628:                 ! Eq. (6.11)
   629:                 !
   630: W**==== A       xyz_DelOptDep = ( 1.0_DP - xyz_SSA * xyz_FuncF ) * xyz_DelOptDep
   631:             
   632:             
   633:               end subroutine RadC2001ReduceCloudOptDep
   634:             
   635:               !--------------------------------------------------------------------------------------
   636:             
   637:               subroutine RadC2001CalcTransBand3CO2(           &
   638:                 & xyz_DelCO2Mass, xyz_Press, xyz_Temp, xyz_QCO2,    & ! (in)
   639:                 & xyrr_Trans                                        & ! (out)
   640:                 & )
   641:             
   642:                 ! USE statements
   643:                 !
   644:             
   645:             
   646:                 real(DP)        , intent(in ) :: xyz_DelCO2Mass(0:imax-1, 1:jmax, 1:kmax)
   647:                 real(DP)        , intent(in ) :: xyz_Press     (0:imax-1, 1:jmax, 1:kmax)
   648:                 real(DP)        , intent(in ) :: xyz_Temp      (0:imax-1, 1:jmax, 1:kmax)
   649:                 real(DP)        , intent(in ) :: xyz_QCO2      (0:imax-1, 1:jmax, 1:kmax)
   650:                 real(DP)        , intent(out) :: xyrr_Trans    (0:imax-1, 1:jmax, 0:kmax, 0:kmax)
   651:             
   652:             
   653:                 !
   654:                 ! Work variables
   655:                 !
   656:                 real(DP)              :: xyrr_TransEach (0:imax-1, 1:jmax, 0:kmax, 0:kmax)
   657:                 character(len=STRING) :: Spec
   658:                 integer               :: iband
   659:                 integer               :: k
   660:                 integer               :: kk
   661:             
   662:             
   663:                 ! 初期化確認
   664:                 ! Initialization check
   665:                 !
   666:                 if ( .not. rad_C2001_inited ) then
   667:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   668:                 end if
   669:             
   670:             
   671: W***=== A       xyrr_Trans = 0.0_DP
   672:             
   673:                 Spec = 'SubBandCO2'
   674: +------>        do iband = 1, 2
   675: |                 call RadC2001CalcTrans(                               &
   676: |                   & Spec, iband,                                      & ! (in)
   677: |                   & xyz_DelCO2Mass, xyz_Press, xyz_Temp, xyz_QCO2,    & ! (in)
   678: |                   & xyrr_TransEach                                    & ! (out)
   679: |                   & )
   680: |           
   681: |+----->          do k = 0, kmax
   682: ||+---->            do kk = 0, kmax
   683: |||                   if ( k == kk ) then
   684: |||+V== A               xyrr_Trans(:,:,k,kk) = 1.0_DP
   685: |||                   else
   686: |||W*== A               xyrr_Trans(:,:,k,kk) = xyrr_Trans(:,:,k,kk) + xyrr_TransEach(:,:,k,kk)
   687: |||                   end if
   688: ||+----             end do
   689: |+-----           end do
   690: +------         end do
   691:             
   692:             
   693:               end subroutine RadC2001CalcTransBand3CO2
   694:             
   695:               !--------------------------------------------------------------------------------------
   696:             
   697:               subroutine RadC2001CalcTransBand3H2O(                    &
   698:                 & xyz_DelH2OVapMass, xyz_Press, xyz_Temp, xyz_QH2OVap, & ! (in)
   699:                 & xyrr_Trans                                           & ! (out)
   700:                 & )
   701:             
   702:                 ! USE statements
   703:                 !
   704:             
   705:             
   706:                 real(DP), intent(in ) :: xyz_DelH2OVapMass(0:imax-1, 1:jmax, 1:kmax)
   707:                 real(DP), intent(in ) :: xyz_Press        (0:imax-1, 1:jmax, 1:kmax)
   708:                 real(DP), intent(in ) :: xyz_Temp         (0:imax-1, 1:jmax, 1:kmax)
   709:                 real(DP), intent(in ) :: xyz_QH2OVap      (0:imax-1, 1:jmax, 1:kmax)
   710:                 real(DP), intent(out) :: xyrr_Trans       (0:imax-1, 1:jmax, 0:kmax, 0:kmax)
   711:             
   712:             
   713:                 !
   714:                 ! Work variables
   715:                 !
   716:                 real(DP)              :: xyrr_TransCont (0:imax-1, 1:jmax, 0:kmax, 0:kmax)
   717:                 real(DP)              :: xyrr_TransLine (0:imax-1, 1:jmax, 0:kmax, 0:kmax)
   718:                 character(len=STRING) :: Spec
   719:                 integer               :: iband
   720:                 integer               :: k
   721:                 integer               :: kk
   722:             
   723:             
   724:                 ! 初期化確認
   725:                 ! Initialization check
   726:                 !
   727:                 if ( .not. rad_C2001_inited ) then
   728:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   729:                 end if
   730:             
   731:             
   732: W***=== A       xyrr_Trans = 0.0_DP
   733:             
   734: +------>        do iband = 1, nsbmax
   735: |                 Spec = 'SubBandH2OCont'
   736: |                 call RadC2001CalcTrans(                                  &
   737: |                   & Spec, iband,                                         & ! (in)
   738: |                   & xyz_DelH2OVapMass, xyz_Press, xyz_Temp, xyz_QH2OVap, & ! (in)
   739: |                   & xyrr_TransCont                                       & ! (out)
   740: |                   & )
   741: |                 Spec = 'SubBandH2OLine'
   742: |                 call RadC2001CalcTrans(                                  &
   743: |                   & Spec, iband,                                         & ! (in)
   744: |                   & xyz_DelH2OVapMass, xyz_Press, xyz_Temp, xyz_QH2OVap, & ! (in)
   745: |                   & xyrr_TransLine                                       & ! (out)
   746: |                   & )
   747: |           
   748: |+----->          do k = 0, kmax
   749: ||+---->            do kk = 0, kmax
   750: |||                   if ( k == kk ) then
   751: |||+V== A               xyrr_Trans(:,:,k,kk) = 1.0_DP
   752: |||                   else
   753: |||W*== A               xyrr_Trans(:,:,k,kk) = xyrr_Trans(:,:,k,kk) &
   754: |||                       & + xyrr_TransCont(:,:,k,kk) * xyrr_TransLine(:,:,k,kk)
   755: |||                   end if
   756: ||+----             end do
   757: |+-----           end do
   758: +------         end do
   759:             
   760:             
   761:               end subroutine RadC2001CalcTransBand3H2O
   762:             
   763:               !--------------------------------------------------------------------------------------
   764:             
   765:               subroutine RadC2001CalcTrans(                         &
   766:                 & Spec, iband,                                      & ! (in)
   767:                 & xyz_DelAbsMass, xyz_Press, xyz_Temp, xyz_QMix,    & ! (in)
   768:                 & xyrr_Trans                                        & ! (out)
   769:                 & )
   770:             
   771:                 ! USE statements
   772:                 !
   773:             
   774:             
   775:                 character(len=*), intent(in ) :: Spec
   776:                 integer         , intent(in ) :: iband
   777:                 real(DP)        , intent(in ) :: xyz_DelAbsMass(0:imax-1, 1:jmax, 1:kmax)
   778:                 real(DP)        , intent(in ) :: xyz_Press     (0:imax-1, 1:jmax, 1:kmax)
   779:                 real(DP)        , intent(in ) :: xyz_Temp      (0:imax-1, 1:jmax, 1:kmax)
   780:                 real(DP)        , intent(in ) :: xyz_QMix      (0:imax-1, 1:jmax, 1:kmax)
   781:                 real(DP)        , intent(out) :: xyrr_Trans    (0:imax-1, 1:jmax, 0:kmax, 0:kmax)
   782:             
   783:             
   784:                 !
   785:                 ! Work variables
   786:                 !
   787:                 real(DP) :: RefPress
   788:                 real(DP) :: RefTemp
   789:                 real(DP) :: PressScaleIndex
   790:                 real(DP) :: CoefA
   791:                 real(DP) :: CoefB
   792:                 real(DP) :: CoefC            ! width of bin (dg) ! This notation is used in Chou et al. (1993)
   793:                 integer  :: CoefN
   794:                 real(DP) :: AbsCoef
   795:             
   796:                 integer  :: NCoefC
   797:                 real(DP) :: a_CoefC(1:6)
   798:             
   799:             
   800:                 real(DP) :: xyz_DelAbsMassScaled  (0:imax-1, 1:jmax, 1:kmax)
   801:             
   802:                 real(DP) :: xyz_TransOneLayer     (0:imax-1, 1:jmax, 1:kmax)
   803:                 real(DP) :: xyrr_TransElem        (0:imax-1, 1:jmax, 0:kmax, 0:kmax)
   804:             
   805:                 integer  :: k
   806:                 integer  :: kk
   807:                 integer  :: l
   808:             
   809:             
   810:                 ! 初期化確認
   811:                 ! Initialization check
   812:                 !
   813:                 if ( .not. rad_C2001_inited ) then
   814:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   815:                 end if
   816:             
   817:             
   818:                 if ( Spec == 'H2OCont' ) then
   819:                   RefPress        =     -1.0d100
   820:                   RefTemp         =     -1.0d100
   821:                   PressScaleIndex =     -1.0d100
   822:                   CoefA           =     -1.0d100
   823:                   CoefB           =     -1.0d100
   824:                   AbsCoef         =      aa_BandH2OContParams(1  ,iband)
   825: *======           a_CoefC(1:1)    =      1.0_DP
   826: *======           a_CoefC(2:6)    =      1.0d100
   827:                   CoefN           = 1
   828:                   NCoefC          = 1
   829:                 else if ( Spec == 'H2OLine' ) then
   830:                   RefPress        =      aa_BandH2OSclParams (1  ,iband)
   831:                   RefTemp         =      aa_BandH2OSclParams (2  ,iband)
   832:                   PressScaleIndex =      aa_BandH2OSclParams (3  ,iband)
   833:                   CoefA           =      aa_BandH2OSclParams (4  ,iband)
   834:                   CoefB           =      aa_BandH2OSclParams (5  ,iband)
   835:                   AbsCoef         =      aa_BandH2OLineParams(1  ,iband)
   836:                   CoefN           = int( aa_BandH2OLineParams(2  ,iband) )
   837: V====== A         a_CoefC         =      aa_BandH2OLineParams(3:8,iband)
   838:                   NCoefC          = 6
   839:                 else if ( Spec == 'SubBandH2OCont' ) then
   840:                   RefPress        =     -1.0d100
   841:                   RefTemp         =     -1.0d100
   842:                   PressScaleIndex =     -1.0d100
   843:                   CoefA           =     -1.0d100
   844:                   CoefB           =     -1.0d100
   845:                   AbsCoef         =      aa_SubBandH2OContParams(1  ,iband)
   846: *======           a_CoefC(1:1)    =      1.0_DP
   847: *======           a_CoefC(2:6)    =      1.0d100
   848:                   CoefN           = 1
   849:                   NCoefC          = 1
   850:                 else if ( Spec == 'SubBandH2OLine' ) then
   851:                   RefPress        =      aa_SubBandH2OSclParams (1  ,iband)
   852:                   RefTemp         =      aa_SubBandH2OSclParams (2  ,iband)
   853:                   PressScaleIndex =      aa_SubBandH2OSclParams (3  ,iband)
   854:                   CoefA           =      aa_SubBandH2OSclParams (4  ,iband)
   855:                   CoefB           =      aa_SubBandH2OSclParams (5  ,iband)
   856:                   AbsCoef         =      aa_SubBandH2OLineParams(1  ,iband)
   857:                   CoefN           = int( aa_SubBandH2OLineParams(2  ,iband) )
   858: V====== A         a_CoefC         =      aa_SubBandH2OLineParams(3:8,iband)
   859:                   NCoefC          = 6
   860:                 else if ( Spec == 'SubBandCO2' ) then
   861:                   RefPress        =      aa_SubBandCO2SclParams (1  ,iband)
   862:                   RefTemp         =      aa_SubBandCO2SclParams (2  ,iband)
   863:                   PressScaleIndex =      aa_SubBandCO2SclParams (3  ,iband)
   864:                   CoefA           =      aa_SubBandCO2SclParams (4  ,iband)
   865:                   CoefB           =      aa_SubBandCO2SclParams (5  ,iband)
   866:                   AbsCoef         =      aa_SubBandCO2LineParams(1  ,iband)
   867:                   CoefN           = int( aa_SubBandCO2LineParams(2  ,iband) )
   868: V====== A         a_CoefC         =      aa_SubBandCO2LineParams(3:8,iband)
   869:                   NCoefC          = 6
   870:                 else if ( Spec == 'N2OLine' ) then
   871:                   RefPress        =      aa_BandN2OSclParams (1  ,iband)
   872:                   RefTemp         =      aa_BandN2OSclParams (2  ,iband)
   873:                   PressScaleIndex =      aa_BandN2OSclParams (3  ,iband)
   874:                   CoefA           =      aa_BandN2OSclParams (4  ,iband)
   875:                   CoefB           =      aa_BandN2OSclParams (5  ,iband)
   876:                   AbsCoef         =      aa_BandN2OLineParams(1  ,iband)
   877:                   CoefN           = int( aa_BandN2OLineParams(2  ,iband) )
   878: V====== A         a_CoefC         =      aa_BandN2OLineParams(3:8,iband)
   879:                   NCoefC          = 6
   880:                 else if ( Spec == 'CH4Line' ) then
   881:                   RefPress        =      aa_BandCH4SclParams (1  ,iband)
   882:                   RefTemp         =      aa_BandCH4SclParams (2  ,iband)
   883:                   PressScaleIndex =      aa_BandCH4SclParams (3  ,iband)
   884:                   CoefA           =      aa_BandCH4SclParams (4  ,iband)
   885:                   CoefB           =      aa_BandCH4SclParams (5  ,iband)
   886:                   AbsCoef         =      aa_BandCH4LineParams(1  ,iband)
   887:                   CoefN           = int( aa_BandCH4LineParams(2  ,iband) )
   888: V====== A         a_CoefC         =      aa_BandCH4LineParams(3:8,iband)
   889:                   NCoefC          = 6
   890:                 else if ( Spec == 'WeakBandCO2Line' ) then
   891:                   RefPress        =      aa_WeakBandCO2SclParams (1  ,iband)
   892:                   RefTemp         =      aa_WeakBandCO2SclParams (2  ,iband)
   893:                   PressScaleIndex =      aa_WeakBandCO2SclParams (3  ,iband)
   894:                   CoefA           =      aa_WeakBandCO2SclParams (4  ,iband)
   895:                   CoefB           =      aa_WeakBandCO2SclParams (5  ,iband)
   896:                   AbsCoef         =      aa_WeakBandCO2LineParams(1  ,iband)
   897:                   CoefN           = int( aa_WeakBandCO2LineParams(2  ,iband) )
   898: V====== A         a_CoefC         =      aa_WeakBandCO2LineParams(3:8,iband)
   899:                   NCoefC          = 6
   900:                 else
   901:                   call MessageNotify( 'E', module_name, 'Unsupported specie, %c', c1 = trim( Spec ) )
   902:                 end if
   903:             
   904:                 if ( AbsCoef < 0.0_DP ) then
   905: +++V=== A         xyrr_Trans = 1.0_DP
   906:                   return
   907:                 end if
   908:             
   909:             
   910:                 if ( ( Spec == 'H2OCont' ) .or. ( Spec == 'SubBandH2OCont' ) ) then
   911:                   call RadC2001ContScaleH2OAmt(                      &
   912:                     & xyz_DelAbsMass, xyz_Press, xyz_Temp, xyz_QMix, & ! (in)
   913:                     & xyz_DelAbsMassScaled                           & ! (out)
   914:                     & )
   915:                 else
   916:                   call RadC2001LineScaleAmt(                            &
   917:                     & xyz_DelAbsMass,                                   & ! (in)
   918:                     & xyz_Press, xyz_Temp,                              & ! (in)
   919:                     & RefPress, RefTemp, PressScaleIndex, CoefA, CoefB, & ! (in)
   920:                     & xyz_DelAbsMassScaled                              & ! (out)
   921:                     & )
   922:                 end if
   923:             
   924: W**==== A       xyz_TransOneLayer = exp( - AbsCoef * xyz_DelAbsMassScaled )
   925:             
   926: +------>        do k = 0, kmax
   927: |                 kk = k
   928: |W*====           xyrr_TransElem(:,:,k,kk) = 1.0_DP
   929: |+----->          do kk = k+1, kmax
   930: ||W*=== A           xyrr_TransElem(:,:,k,kk) = xyrr_TransElem(:,:,k,kk-1) * xyz_TransOneLayer(:,:,kk)
   931: |+-----           end do
   932: +------         end do
   933:             
   934:             
   935:                 ! initialization
   936: +------>        do k = 0, kmax
   937: |+----->          do kk = k+1, kmax
   938: ||W*=== A           xyrr_Trans(:,:,k,kk) = 0.0_DP
   939: |+-----           end do
   940: +------         end do
   941:             
   942:                 ! Summation of fitted exponential functions
   943: +------>        Loop_Sum : do l = 1, NCoefC
   944: |           
   945: |                 CoefC = a_CoefC(l)
   946: |           
   947: |                 if ( CoefC > 0.0_DP ) then
   948: |           
   949: |+----->            do k = 0, kmax
   950: ||+---->              do kk = k+1, kmax
   951: |||W*== A               xyrr_Trans(:,:,k,kk) = xyrr_Trans(:,:,k,kk) &
   952: |||                       & + CoefC * xyrr_TransElem(:,:,k,kk)
   953: ||+----               end do
   954: |+-----             end do
   955: |           
   956: |                   ! Calculate fitted exponential function used in next loop
   957: |                   if ( l /= NCoefC ) then
   958: |+----->              do k = 0, kmax
   959: ||+---->                do kk = k+1, kmax
   960: |||W*== A                 xyrr_TransElem(:,:,k,kk) = xyrr_TransElem(:,:,k,kk)**CoefN
   961: ||+----                 end do
   962: |+-----               end do
   963: |                   end if
   964: |           
   965: |                 end if
   966: |           
   967: +------         end do Loop_Sum
   968:             
   969: +------>        do k = 0, kmax
   970: |*----->          do kk = k, k
   971: ||W*=== A           xyrr_Trans(:,:,k,kk) = 1.0_DP
   972: |*-----           end do
   973: +------         end do
   974: +------>        do k = 0, kmax
   975: |+----->          do kk = 0, k-1
   976: ||W*=== A           xyrr_Trans(:,:,k,kk) = xyrr_Trans(:,:,kk,k)
   977: |+-----           end do
   978: +------         end do
   979:             
   980:             
   981:               end subroutine RadC2001CalcTrans
   982:             
   983:               !--------------------------------------------------------------------------------------
   984:             
   985:               subroutine RadC2001ContScaleH2OAmt(                   &
   986:                 & xyz_DelAbsMass, xyz_Press, xyz_Temp, xyz_QH2OVap, & ! (in)
   987:                 & xyz_ContDelAbsMassScaled                          & ! (out)
   988:                 & )
   989:             
   990:                 ! Equation (4.21), (4.19)
   991:             
   992:                 ! USE statements
   993:                 !
   994:             
   995:             
   996:                 real(DP), intent(in ) :: xyz_DelAbsMass          (0:imax-1, 1:jmax, 1:kmax)
   997:                 real(DP), intent(in ) :: xyz_Press               (0:imax-1, 1:jmax, 1:kmax)
   998:                 real(DP), intent(in ) :: xyz_Temp                (0:imax-1, 1:jmax, 1:kmax)
   999:                 real(DP), intent(in ) :: xyz_QH2OVap             (0:imax-1, 1:jmax, 1:kmax)
  1000:                 real(DP), intent(out) :: xyz_ContDelAbsMassScaled(0:imax-1, 1:jmax, 1:kmax)
  1001:             
  1002:             
  1003:                 !
  1004:                 ! Work variables
  1005:                 !
  1006:                 real(DP) :: xyz_PressH2O (0:imax-1, 1:jmax, 1:kmax)
  1007:             
  1008:             
  1009:                 ! 初期化確認
  1010:                 ! Initialization check
  1011:                 !
  1012:                 if ( .not. rad_C2001_inited ) then
  1013:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
  1014:                 end if
  1015:             
  1016:             
  1017: **W---->A       xyz_PressH2O            = xyz_Press * xyz_QH2OVap * MeanMolWeight / H2OMolWeight
  1018: **W---- A       xyz_ContDelAbsMassScaled = xyz_DelAbsMass                      &
  1019:                   & * xyz_PressH2O / 101325d0                                  & ! Pa to atm.
  1020:                   & * exp( 1800.0d0 * ( 1.0d0 / xyz_Temp - 1.0d0 / 296.0d0 ) )
  1021:             
  1022:             
  1023:               end subroutine RadC2001ContScaleH2OAmt
  1024:             
  1025:               !--------------------------------------------------------------------------------------
  1026:             
  1027:               subroutine RadC2001LineScaleAmt(                      &
  1028:                 & xyz_DelAbsMass,                                   & ! (in)
  1029:                 & xyz_Press, xyz_Temp,                              & ! (in)
  1030:                 & RefPress, RefTemp, PressScaleIndex, CoefA, CoefB, & ! (in)
  1031:                 & xyz_DelAbsMassScaled                              & ! (out)
  1032:                 & )
  1033:             
  1034:                 ! Equation (4.4)
  1035:             
  1036:                 ! USE statements
  1037:                 !
  1038:             
  1039:                 real(DP), intent(in ) :: xyz_DelAbsMass      (0:imax-1, 1:jmax, 1:kmax)
  1040:                 real(DP), intent(in ) :: xyz_Press           (0:imax-1, 1:jmax, 1:kmax)
  1041:                 real(DP), intent(in ) :: xyz_Temp            (0:imax-1, 1:jmax, 1:kmax)
  1042:                 real(DP), intent(in ) :: RefPress
  1043:                 real(DP), intent(in ) :: RefTemp
  1044:                 real(DP), intent(in ) :: PressScaleIndex
  1045:                 real(DP), intent(in ) :: CoefA
  1046:                 real(DP), intent(in ) :: CoefB
  1047:                 real(DP), intent(out) :: xyz_DelAbsMassScaled(0:imax-1, 1:jmax, 1:kmax)
  1048:             
  1049:             
  1050:                 !
  1051:                 ! Work variables
  1052:                 !
  1053:             
  1054:             
  1055:                 ! 初期化確認
  1056:                 ! Initialization check
  1057:                 !
  1058:                 if ( .not. rad_C2001_inited ) then
  1059:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
  1060:                 end if
  1061:             
  1062:             
  1063: W**==== A       xyz_DelAbsMassScaled = xyz_DelAbsMass                                     &
  1064:                   & * ( xyz_Press / RefPress )**PressScaleIndex                           &
  1065:                   & * ( 1.0_DP + CoefA * ( xyz_Temp - RefTemp ) + CoefB * ( xyz_Temp - RefTemp )**2 )
  1066:             
  1067:             
  1068:               end subroutine RadC2001LineScaleAmt
  1069:             
  1070:               !--------------------------------------------------------------------------------------
  1071:             
  1072:               subroutine RadC2001CalcIntegratedPF3D(  &
  1073:                 & iband, km, xyz_Temp,                &
  1074:                 & xyz_IntegPF,                        &
  1075:                 & flag_DPFDT                          &
  1076:                 & )
  1077:             
  1078:                 ! USE statements
  1079:                 !
  1080:             
  1081:             
  1082:                 integer , intent(in )           :: iband
  1083:                 integer , intent(in )           :: km
  1084:                 real(DP), intent(in )           :: xyz_Temp   (0:imax-1, 1:jmax, 1:km)
  1085:                 real(DP), intent(out)           :: xyz_IntegPF(0:imax-1, 1:jmax, 1:km)
  1086:                 logical , intent(in ), optional :: flag_DPFDT
  1087:             
  1088:                 !
  1089:                 ! local variables
  1090:                 !
  1091:                 logical                     :: local_flag_DPFDT
  1092:             
  1093:             !!$    integer                     :: xyz_TempIndex(0:imax-1, 1:jmax, 1:km)
  1094:                 integer                     :: i
  1095:                 integer                     :: j
  1096:                 integer                     :: k
  1097:                 integer                     :: l
  1098:             
  1099:             
  1100:                 ! 初期化確認
  1101:                 ! Initialization check
  1102:                 !
  1103:                 if ( .not. rad_C2001_inited ) then
  1104:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
  1105:                 end if
  1106:             
  1107:             
  1108:                 ! Temperature check
  1109:                 !
  1110: +------>        do k = 1, km
  1111: |+----->          do j = 1, jmax
  1112: ||+---->            do i = 0, imax-1
  1113: |||                   if ( ( xyz_Temp(i,j,k) < 150.0_DP ) .or. &
  1114: |||                     &  ( xyz_Temp(i,j,k) > 350.0_DP ) ) then
  1115: |||                     call MessageNotify( 'M', module_name, &
  1116: |||                       & 'Temperature is not appropriate, Temp(%d,%d,%d) = %f.', &
  1117: |||                       & i = (/i, j, k/), d = (/xyz_Temp(i,j,k)/) )
  1118: |||                   end if
  1119: ||+----             end do
  1120: |+-----           end do
  1121: +------         end do
  1122:             
  1123:             
  1124:                 local_flag_DPFDT = .false.
  1125:                 if ( present( flag_DPFDT ) ) then
  1126:                   if ( flag_DPFDT ) then
  1127:                     local_flag_DPFDT = .true.
  1128:                   end if
  1129:                 end if
  1130:             
  1131:                 if ( .not. local_flag_DPFDT ) then
  1132:                   ! Calculation of integrated Planck function
  1133:             
  1134: W**==== A         xyz_IntegPF = aa_BandIntegPFCoefs(0,iband)
  1135: +------>          do l = 1, 5
  1136: |W**=== A           xyz_IntegPF = xyz_IntegPF + aa_BandIntegPFCoefs(l,iband) * xyz_Temp**l
  1137: +------           end do
  1138:             
  1139:                 else
  1140:                   ! Calculation of derivative of integrated Planck function
  1141:             
  1142: W**==== A         xyz_IntegPF = aa_BandIntegPFCoefs(1,iband)
  1143: +------>          do l = 2, 5
  1144: |W**=== A           xyz_IntegPF = xyz_IntegPF + aa_BandIntegPFCoefs(l,iband) * l * xyz_Temp**(l-1)
  1145: +------           end do
  1146:             
  1147:                 end if
  1148:             
  1149:             
  1150:               end subroutine RadC2001CalcIntegratedPF3D
  1151:             
  1152:               !--------------------------------------------------------------------------------------
  1153:             
  1154:               subroutine RadC2001CalcIntegratedPF2D(  &
  1155:                 & iband, xy_Temp,                     &
  1156:                 & xy_IntegPF,                         &
  1157:                 & flag_DPFDT                          &
  1158:                 & )
  1159:             
  1160:                 ! USE statements
  1161:                 !
  1162:             
  1163:                 integer , intent(in )           :: iband
  1164:                 real(DP), intent(in )           :: xy_Temp   (0:imax-1, 1:jmax)
  1165:                 real(DP), intent(out)           :: xy_IntegPF(0:imax-1, 1:jmax)
  1166:                 logical , intent(in ), optional :: flag_DPFDT
  1167:             
  1168:                 !
  1169:                 ! local variables
  1170:                 !
  1171:                 real(DP) :: xyz_Temp   (0:imax-1, 1:jmax, 1)
  1172:                 real(DP) :: xyz_IntegPF(0:imax-1, 1:jmax, 1)
  1173:             
  1174:             
  1175:                 ! 初期化確認
  1176:                 ! Initialization check
  1177:                 !
  1178:                 if ( .not. rad_C2001_inited ) then
  1179:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
  1180:                 end if
  1181:             
  1182:             
  1183: W*===== A       xyz_Temp(:,:,1) = xy_Temp
  1184:             
  1185:                 call RadC2001CalcIntegratedPF3D(        &
  1186:                   & iband, 1, xyz_temp,                 &
  1187:                   & xyz_IntegPF,                        &
  1188:                   & flag_DPFDT                          &
  1189:                   & )
  1190:             
  1191: W*===== A       xy_IntegPF = xyz_IntegPF(:,:,1)
  1192:             
  1193:             
  1194:               end subroutine RadC2001CalcIntegratedPF2D
  1195:             
  1196:               !--------------------------------------------------------------------------------------
  1197:             
  1198:               subroutine RadC2001Init
  1199:             
  1200:             
  1201:             !!$    ! ファイル入出力補助
  1202:             !!$    ! File I/O support
  1203:             !!$    !
  1204:             !!$    use dc_iounit, only: FileOpen
  1205:             !!$
  1206:             !!$    ! NAMELIST ファイル入力に関するユーティリティ
  1207:             !!$    ! Utilities for NAMELIST file input
  1208:             !!$    !
  1209:             !!$    use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid
  1210:             
  1211:             
  1212:             !!$    integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号.
  1213:             !!$                              ! Unit number for NAMELIST file open
  1214:             !!$    integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT.
  1215:             !!$                              ! IOSTAT of NAMELIST read
  1216:             
  1217:                 integer :: l
  1218:             
  1219:             !!$    namelist /rad_C1991_nml/ &
  1220:             !!$      & flag_save_time
  1221:             
  1222:             
  1223:                 if ( rad_C2001_inited ) return
  1224:             
  1225:             
  1226:             !!$    ! NAMELIST is input
  1227:             !!$    !
  1228:             !!$    if ( trim(namelist_filename) /= '' ) then
  1229:             !!$      call FileOpen( unit_nml, &          ! (out)
  1230:             !!$        & namelist_filename, mode = 'r' ) ! (in)
  1231:             !!$
  1232:             !!$      rewind( unit_nml )
  1233:             !!$      read( unit_nml,                        & ! (in)
  1234:             !!$        & nml = rad_dcpam_E_LW_V2_nml, & ! (out)
  1235:             !!$        & iostat = iostat_nml )                ! (out)
  1236:             !!$      close( unit_nml )
  1237:             !!$
  1238:             !!$      call NmlutilMsg( iostat_nml, module_name ) ! (in)
  1239:             !!$    end if
  1240:             
  1241:             
  1242:                 ! Convert unit from cm-1 to m-1
  1243: +V===== A       aa_BandWN = aa_BandWN * 1.0d2
  1244:             
  1245:                 ! Convert unit from gm-1 cm2 to kg-1 m2
  1246: V------>        do l = 1, nbmax
  1247: |       A         aa_BandH2OLineParams(1,l) = aa_BandH2OLineParams(1,l) * 1.0d-4 * 1.0d3
  1248: |               end do
  1249: |               do l = 1, nbmax
  1250: |                 if ( aa_BandH2OContParams(1,l) > 0.0_DP ) then
  1251: |                   aa_BandH2OContParams(1,l) = aa_BandH2OContParams(1,l) * 1.0d-4 * 1.0d3
  1252: |                 end if
  1253: V------         end do
  1254:             
  1255:             
  1256:                 ! Convert unit from cm-1 to m-1
  1257: **=====         aa_SubBandWN = aa_SubBandWN * 1.0d2
  1258:             
  1259:                 ! Convert unit from gm-1 cm2 to kg-1 m2
  1260: *------>        do l = 1, nsbmax
  1261: |                 aa_SubBandH2OLineParams(1,l) = aa_SubBandH2OLineParams(1,l) * 1.0d-4 * 1.0d3
  1262: *------         end do
  1263: *------>        do l = 1, nsbmax
  1264: |                 aa_SubBandH2OContParams(1,l) = aa_SubBandH2OContParams(1,l) * 1.0d-4 * 1.0d3
  1265: *------         end do
  1266:             
  1267:                 ! Convert unit from {(cm-atm)_{STP}}^{-1} to m2 kg-1
  1268:                 !   MEMO: In a calculation below, GasRUniv variable in constants module can be used. 
  1269:                 !         But, I do not use it, since unit of value is just converted by 
  1270:                 !         multiplying a factor. Of course, non-use of GasRUniv must not cause 
  1271:                 !         significant effect on result.
  1272: *------>        do l = 1, 2
  1273: |                 aa_SubBandCO2LineParams(1,l) = aa_SubBandCO2LineParams(1,l) &
  1274: |                   & * 1.0d2 / 101325.0d0 * 8.31432d0 / ( 44.0d-3 ) * 273.15d0
  1275: *------         end do
  1276:             
  1277:             
  1278:                 ! 印字 ; Print
  1279:                 !
  1280:                 call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
  1281:             !!$    call MessageNotify( 'M', module_name, '  DelTimeCalcTrans  = %f [%c]', &
  1282:             !!$      & d = (/ DelTimeCalcTransValue /), c1 = trim( DelTimeCalcTransUnit ) )
  1283:                 call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
  1284:             
  1285:             
  1286:                 rad_C2001_inited = .true.
  1287:             
  1288:               end subroutine RadC2001Init
  1289:             
  1290:               !--------------------------------------------------------------------------------------
  1291:             
  1292:             end module rad_C2001
