Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:50 2016
FILE NAME: rad_CL1996.f90
PROGRAM NAME: rad_cl1996
DIAGNOSTIC LIST

  LINE  LEVEL( NO.): DIAGNOSTIC MESSAGE

   250  opt  (1593): Loop nest collapsed into one loop.
   250  vec  (   4): Vectorized array expression.
   250  vec  (  29): ADB is used for array.: xyz_delh2ovapmassscaled
   250  vec  (  29): ADB is used for array.: xyz_delh2ovapmass
   250  vec  (  29): ADB is used for array.: xyz_temp
   250  vec  (  29): ADB is used for array.: xyz_press
   409  vec  (   4): Vectorized array expression.
   409  vec  (  29): ADB is used for array.: a_irh2okdfk
   415  opt  (  11): Fused array assignments. :line 415 - 433
   415  vec  (   4): Vectorized array expression.
   415  vec  (  29): ADB is used for array.: a_uvvisrayscatcoef
   415  vec  (  29): ADB is used for array.: a_uvviso3abscoef
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:50 2016
FILE NAME: rad_CL1996.f90
PROGRAM NAME: rad_cl1996
TRANSFORMATION LIST

  LINE                   FORTRAN STATEMENT

     1  != Chou and Lee (1996) による短波放射モデル
     2  !
     3  != Short wave radiation model described by Chou and Lee (1996)
     4  !
     5  ! Authors::   Yoshiyuki O. Takahashi
     6  ! Version::   $Id: rad_CL1996.f90,v 1.4 2011/06/19 11:12:42 yot Exp $
     7  ! Tag Name::  $Name:  $
     8  ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9  ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10  !
    11  
    12  module rad_CL1996
    13    !
    14    != Chou and Lee (1996) による短波放射モデル
    15    !
    16    != Short wave radiation model described by Chou and Lee (1996)
    17    !
    18    ! <b>Note that Japanese and English are described in parallel.</b>
    19    !
    20    ! 短波放射モデル.
    21    !
    22    ! This is a model of short wave radiation.
    23    !
    24    !== References
    25    !
    26    !  Chou, M.-D., and K.-T. Lee,
    27    !    Parameterizations for the absorption of solar radiation by water vapor and ozone,
    28    !    J. Atmos. Sci., 53, 1203-1208, 1996.
    29    !
    30    !== Procedures List
    31    !
    32  !!$  ! RadiationFluxDennouAGCM :: 放射フラックスの計算
    33  !!$  ! RadiationDTempDt        :: 放射フラックスによる温度変化の計算
    34  !!$  ! RadiationFluxOutput     :: 放射フラックスの出力
    35  !!$  ! RadiationFinalize       :: 終了処理 (モジュール内部の変数の割り付け解除)
    36  !!$  ! ------------            :: ------------
    37  !!$  ! RadiationFluxDennouAGCM :: Calculate radiation flux
    38  !!$  ! RadiationDTempDt        :: Calculate temperature tendency with radiation flux
    39  !!$  ! RadiationFluxOutput     :: Output radiation fluxes
    40  !!$  ! RadiationFinalize       :: Termination (deallocate variables in this module)
    41    !
    42    !== NAMELIST
    43    !
    44  !!$  ! NAMELIST#radiation_DennouAGCM_nml
    45    !
    46  
    47    ! USE statements
    48    !
    49  
    50    !
    51    ! Kind type parameter
    52    !
    53    use dc_types, only: DP, &      ! Double precision.
    54      &                 STRING, &  ! Strings.
    55      &                 TOKEN      ! Keywords.
    56  
    57    ! メッセージ出力
    58    ! Message output
    59    !
    60    use dc_message, only: MessageNotify
    61  
    62    !
    63    ! Grid points settings
    64    !
    65    use gridset, only: imax, & !
    66                               ! Number of grid points in longitude
    67      &                jmax, & !
    68                               ! Number of grid points in latitude
    69      &                kmax    !
    70                               ! Number of vertical level
    71  
    72    ! Declaration statements
    73    !
    74    implicit none
    75    private
    76  
    77    !
    78    ! Public procedure
    79    !
    80    public :: RadCL1996NumBands
    81    public :: RadCL1996UVVISParams
    82    public :: RadCL1996IRH2ONumKDFBin
    83    public :: RadCL1996IRH2OKDFParams
    84    public :: RadCL1996ScaleH2OVapMass
    85    public :: RadCL1996Init
    86  
    87  
    88  
    89    integer , parameter :: nband1 = 8  ! * 14500 to 57143 cm-1 (0.175 to 0.70 micron)
    90    integer , parameter :: nband2 = 3  ! *  2600 to 14500 cm-1 (0.70-10 micron)
    91    integer , parameter :: nkdf     = 10
    92  
    93    real(DP), save      :: a_UVVIFracSolarFlux(1:nband1)
    94    real(DP), save      :: a_UVVISO3AbsCoef   (1:nband1)
    95    real(DP), save      :: a_UVVISRayScatCoef (1:nband1)
    96  
    97    real(DP), save      :: a_IRH2Okdfk   (1:nkdf)                        ! k
    98    real(DP), save      :: aa_IRH2Okdfdgi(1:nkdf,nband1+1:nband1+nband2) ! k dist. func.
    99  
   100  
   101  
   102    logical , save     :: rad_cl1996_inited
   103  
   104    data rad_cl1996_inited /.false./
   105  
   106  
   107  
   108  
   109    ! Table 1
   110    ! Unit of k is g-1 cm2.
   111    data a_IRH2Okdfk &
   112      & / &
   113      & 0.0010 , 0.0133 , 0.0422 , 0.1334 , 0.4217 , 1.334  , 5.623  , 31.62  , 177.8  , 1000.0    &
   114      & /
   115  
   116    ! Table 1
   117    data aa_IRH2Okdfdgi &
   118      & / &
   119      & 0.20673, 0.03497, 0.03011, 0.02260, 0.01336, 0.00696, 0.00441, 0.00115, 0.00026, 0.00000,  &  ! 0.7 -1.22
   120      & 0.08236, 0.01157, 0.01133, 0.01143, 0.01240, 0.01258, 0.01381, 0.00650, 0.00244, 0.00094,  &  ! 1.22-2.27
   121      & 0.01074, 0.00360, 0.00411, 0.00421, 0.00389, 0.00326, 0.00499, 0.00465, 0.00245, 0.00145   &  ! 2.27-10
   122      & /
   123  
   124  
   125  !!$  data aa_KDFParams &
   126  !!$    & / &
   127  !!$    !  (0.7-10)
   128  !!$    &  0.29983, 0.05014, 0.04555, 0.03824, 0.02965, 0.02280, 0.02321, 0.01230, 0.00515, 0.00239   &
   129  !!$    & /
   130  
   131  
   132  !!$  data aa_UVVISBandParams &
   133  !!$    & / &
   134  !!$    &   , & ! 0.175-0.225              (UV-C)
   135  !!$    &   , & ! 0.225-0.245, 0.260-0.280 (UV-C)
   136  !!$    &   , & ! 0.245-0.260              (UV-C)
   137  !!$    &   , & ! 0.280-0.295              (UV-B)
   138  !!$    &   , & ! 0.295-0.310              (UV-B)
   139  !!$    &   , & ! 0.310-0.320              (UV-B)
   140  !!$    &   , & ! 0.320-0.400              (UV-A)
   141  !!$    &     & ! 0.400-0.700              (PAR)
   142  !!$    & /
   143  
   144  
   145  
   146    ! Table 3.
   147    data a_UVVIFracSolarFlux &
   148      & /    0.00057,   0.00367,   0.00083,   0.00417,   0.00600,   0.00556,   0.05913,    0.39081 /
   149  
   150    ! Table 3.
   151    ! Unit is (cm-atm)_{STP}^{-1}
   152    data a_UVVISO3AbsCoef &
   153      & /   30.47   , 187.24   , 301.92   ,  42.83   ,   7.09   ,   1.25   ,   0.0345 ,    0.0539  /
   154  
   155    ! Table 3.
   156    ! Unit is (mb)^{-1}
   157    data a_UVVISRayScatCoef &
   158      & /    0.00604,   0.00170,   0.00222,   0.00132,   0.00107,   0.00091,   0.00055,    0.00012 /
   159  
   160  
   161  
   162    character(*), parameter:: module_name = 'rad_CL1996'
   163                                ! モジュールの名称.
   164                                ! Module name
   165    character(*), parameter:: version = &
   166      & '$Name:  $' // &
   167      & '$Id: rad_CL1996.f90,v 1.4 2011/06/19 11:12:42 yot Exp $'
   168                                ! モジュールのバージョン
   169                                ! Module version
   170  
   171  contains
   172  
   173    !--------------------------------------------------------------------------------------
   174  
   175    subroutine RadCL1996NumBands( &
   176      & nbands1, nbands2 & ! (out)
   177      & )
   178  
   179      integer, intent(out) :: nbands1
   180      integer, intent(out) :: nbands2
   181  
   182  
   183      ! 初期化確認
   184      ! Initialization check
   185      !
   186      if ( .not. rad_cl1996_inited ) then
   187        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   188      end if
   189  
   190  
   191      nbands1 = nband1
   192      nbands2 = nband2
   193  
   194    end subroutine RadCL1996NumBands
   195  
   196    !--------------------------------------------------------------------------------------
   197  
   198    subroutine RadCL1996IRH2ONumKDFBin( &
   199      & nbin & ! (out)
   200      & )
   201  
   202      integer, intent(out) :: nbin
   203  
   204  
   205      ! 初期化確認
   206      ! Initialization check
   207      !
   208      if ( .not. rad_cl1996_inited ) then
   209        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   210      end if
   211  
   212  
   213      nbin = nkdf
   214  
   215    end subroutine RadCL1996IRH2ONumKDFBin
   216  
   217    !--------------------------------------------------------------------------------------
   218  
   219    subroutine RadCL1996ScaleH2OVapMass(  &
   220      & xyz_Temp, xyz_DelH2OVapMass, xyz_Press, & ! (in )
   221      & xyz_DelH2OVapMassScaled                 & ! (out)
   222      & )
   223  
   224  
   225      ! USE statements
   226      !
   227  
   228      real(DP), intent(in ):: xyz_Temp               (0:imax-1, 1:jmax, 1:kmax)
   229      real(DP), intent(in ):: xyz_DelH2OVapMass      (0:imax-1, 1:jmax, 1:kmax)
   230      real(DP), intent(in ):: xyz_Press              (0:imax-1, 1:jmax, 1:kmax)
   231      real(DP), intent(out):: xyz_DelH2OVapMassScaled(0:imax-1, 1:jmax, 1:kmax)
   232  
   233  
   234      !
   235      ! Work variables
   236      !
   237      real(DP), parameter :: H2OScaleIndex = 0.8_DP
   238      real(DP), parameter :: RefPress      = 300.0d2
   239      real(DP), parameter :: RefTemp       = 240.0d0
   240  
   241  
   242      ! 初期化確認
   243      ! Initialization check
   244      !
   245      if ( .not. rad_cl1996_inited ) then
   246        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   247      end if
   248  
   249  
   250      xyz_DelH2OVapMassScaled =                                         &
     .        d1 = 1.D0/3.00000000000000e+004                                   
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t72 = 1, kmax*jmax*imax                                        
     .           xyz_delh2ovapmassscaled(t72-1,1,1) = (xyz_press(t72-1,1,1)*d1) 
     .       1      **8.00000000000000e-001*dexp(1.35000000000000e-003*(xyz_temp
     .       2      (t72-1,1,1)-2.40000000000000e+002))*xyz_delh2ovapmass(t72-1,
     .       3      1,1)                                                        
     .        enddo                                                             
   251        &   ( xyz_Press / RefPress )**H2OScaleIndex                     &
   252        & * exp( 0.00135_DP * ( xyz_Temp - RefTemp ) )                  &
   253        & * xyz_DelH2OVapMass
   254  
   255  
   256    end subroutine RadCL1996ScaleH2OVapMass
   257  
   258    !--------------------------------------------------------------------------------------
   259  
   260    subroutine RadCL1996IRH2OKDFParams(        &
   261      & iband, ikdfbin,                              & ! (in )
   262      & KDFAbsCoef, KDFWeight                        & ! (out)
   263      & )
   264  
   265  
   266      ! USE statements
   267      !
   268  
   269      integer , intent(in ):: iband
   270      integer , intent(in ):: ikdfbin
   271      real(DP), intent(out):: KDFAbsCoef
   272      real(DP), intent(out):: KDFWeight
   273  
   274  
   275      !
   276      ! Work variables
   277      !
   278      integer :: l
   279      integer :: m
   280  
   281  
   282      ! 初期化確認
   283      ! Initialization check
   284      !
   285      if ( .not. rad_cl1996_inited ) then
   286        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   287      end if
   288  
   289  
   290      l = iband
   291      m = ikdfbin
   292  
   293      KDFAbsCoef = a_IRH2Okdfk   (m)
   294  
   295      KDFWeight  = aa_IRH2Okdfdgi(m,l)
   296  
   297  
   298    end subroutine RadCL1996IRH2OKDFParams
   299  
   300    !--------------------------------------------------------------------------------------
   301  
   302    subroutine RadCL1996UVVISParams(                    &
   303      & iband,                                                & ! (in )
   304      & UVVISFracSolarFlux, UVVISO3AbsCoef, UVVISRayScatCoef  & ! (out)
   305      & )
   306  
   307  
   308      ! USE statements
   309      !
   310  
   311      integer , intent(in ):: iband
   312      real(DP), intent(out):: UVVISFracSolarFlux
   313      real(DP), intent(out):: UVVISO3AbsCoef
   314      real(DP), intent(out):: UVVISRayScatCoef
   315  
   316  
   317      !
   318      ! Work variables
   319      !
   320      integer :: l
   321  
   322  
   323      ! 初期化確認
   324      ! Initialization check
   325      !
   326      if ( .not. rad_cl1996_inited ) then
   327        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   328      end if
   329  
   330  
   331      l = iband
   332  
   333      UVVISFracSolarFlux = a_UVVIFracSolarFlux(l)
   334      UVVISO3AbsCoef     = a_UVVISO3AbsCoef   (l)
   335      UVVISRayScatCoef   = a_UVVISRayScatCoef (l)
   336  
   337  
   338    end subroutine RadCL1996UVVISParams
   339  
   340    !--------------------------------------------------------------------------------------
   341  
   342    subroutine RadCL1996Init
   343  
   344  
   345  !!$    ! NAMELIST ファイル入力に関するユーティリティ
   346  !!$    ! Utilities for NAMELIST file input
   347  !!$    !
   348  !!$    use namelist_util, only: NmlutilMsg
   349  
   350  !!$    ! ファイル入出力補助
   351  !!$    ! File I/O support
   352  !!$    !
   353  !!$    use dc_iounit, only: FileOpen
   354  
   355  
   356  !!$    ! ヒストリデータ出力
   357  !!$    ! History data output
   358  !!$    !
   359  !!$    use gtool_historyauto, only: HistoryAutoAddVariable
   360  
   361  
   362  !!$    integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号.
   363  !!$                              ! Unit number for NAMELIST file open
   364  !!$    integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT.
   365  !!$                              ! IOSTAT of NAMELIST read
   366  
   367  !!$    ! NAMELIST 変数群
   368  !!$    ! NAMELIST group name
   369  !!$    !
   370  !!$    namelist /rad_CL1996_nml/ !&
   371  !!$      & ShortAtmosAlbedo
   372  !!$          !
   373  !!$          ! デフォルト値については初期化手続 "rad_CL1996#RadCL1996Init"
   374  !!$          ! のソースコードを参照のこと.
   375  !!$          !
   376  !!$          ! Refer to source codes in the initialization procedure
   377  !!$          ! "rad_LH74#RadLH74Init" for the default values.
   378  !!$          !
   379  
   380  
   381  
   382      if ( rad_cl1996_inited ) return
   383  
   384  
   385      ! デフォルト値の設定
   386      ! Default values settings
   387      !
   388  
   389  !!$    ! NAMELIST の読み込み
   390  !!$    ! NAMELIST is input
   391  !!$    !
   392  !!$    if ( trim(namelist_filename) /= '' ) then
   393  !!$      call FileOpen( unit_nml, &          ! (out)
   394  !!$        & namelist_filename, mode = 'r' ) ! (in)
   395  !!$
   396  !!$      rewind( unit_nml )
   397  !!$      read( unit_nml,                     & ! (in)
   398  !!$        & nml = rad_CL1996_nml,     & ! (out)
   399  !!$        & iostat = iostat_nml )             ! (out)
   400  !!$      close( unit_nml )
   401  !!$
   402  !!$      call NmlutilMsg( iostat_nml, module_name ) ! (in)
   403  !!$    end if
   404  
   405  
   406  
   407      ! Unit is changed of k from g-1 cm2 to kg-1 m2.
   408      !
   409      a_IRH2Okdfk = a_IRH2Okdfk * 1.0d3 * 1.0d-4
   410  
   411      ! Convert unit of O3 absorption coefficient from (cm-atm)^{-1} to (kg m-2)^{-1}
   412      !   In order to convert unit from cm-1 atm-1 to m2 kg-1, multiply by
   413      !     1.0d2 / 101325.0d0 * 8.31432d0 / ( 48.0d-3 ) * 273.15d0.
   414      !
   415      a_UVVISO3AbsCoef = a_UVVISO3AbsCoef &
     .           d1 = 1.00000000000000e+002/1.01325000000000e+005               
     .        d2 = 8.31432000000000e+000/4.80000000000000e-002                  
     .  !cdir nodep                                                             
     .        do t37 = 1, 8                                                     
     .           a_uvviso3abscoef(t37) = a_uvviso3abscoef(t37)*d1*d2*           
     .       1      2.73149999999999e+002                                       
     .           a_uvvisrayscatcoef(t37) = a_uvvisrayscatcoef(t37)*             
     .       1      1.00000000000000e-002*9.80000000000000e+000                 
     .        enddo                                                             
   416          & * 1.0d2 / 101325.0d0 * 8.31432d0 / ( 48.0d-3 ) * 273.15d0
   417  
   418      ! Convert unit of Rayleigh scattering coefficient from (mb)^{-1} to (kg m-2)^{-1}
   419      !   memo:
   420      !     1    mbar = 1e2 Pa
   421      !     1e-2 mbar = 1   Pa
   422      !
   423      ! In order to convert unit from (mb)^{-1} to (kg m-2)^{-1}, scattering
   424      ! coefficient is multiplied by 1.0d-1 * g, where g is the gravitational
   425      ! acceleration. In the old version of the code, a variable Grav in constants
   426      ! module is used for gravitational acceleration, as is shown in a line below.
   427      ! However, this variable is replaced with a constant value 9.8_DP.
   428      ! This is because the value of Grav may be changed to a value which is
   429      ! different from the Earth's value. (Of course, the scattering coefficient
   430      ! in unit of (kg m-2)^{-1} is independent on gravitational acceleration.)
   431      !
   432  !!$    a_UVVISRayScatCoef = a_UVVISRayScatCoef * 1.0d-2 * Grav
   433      a_UVVISRayScatCoef = a_UVVISRayScatCoef * 1.0d-2 * 9.8_DP
   434  
   435  
   436  
   437      ! 印字 ; Print
   438      !
   439      call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   440  !!$    call MessageNotify( 'M', module_name, 'ShortAtmosAlbedo = %f', d = (/ ShortAtmosAlbedo /) )
   441      call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   442  
   443  
   444      rad_cl1996_inited = .true.
   445  
   446    end subroutine RadCL1996Init
   447  
   448    !--------------------------------------------------------------------------------------
   449  
   450  end module rad_CL1996
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:50 2016
FILE NAME: rad_CL1996.f90
PROGRAM NAME: rad_cl1996
FORMAT LIST

  LINE    LOOP      FORTRAN STATEMENT

     1:             != Chou and Lee (1996) による短波放射モデル
     2:             !
     3:             != Short wave radiation model described by Chou and Lee (1996)
     4:             !
     5:             ! Authors::   Yoshiyuki O. Takahashi
     6:             ! Version::   $Id: rad_CL1996.f90,v 1.4 2011/06/19 11:12:42 yot Exp $
     7:             ! Tag Name::  $Name:  $
     8:             ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9:             ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10:             !
    11:             
    12:             module rad_CL1996
    13:               !
    14:               != Chou and Lee (1996) による短波放射モデル
    15:               !
    16:               != Short wave radiation model described by Chou and Lee (1996)
    17:               !
    18:               ! <b>Note that Japanese and English are described in parallel.</b>
    19:               !
    20:               ! 短波放射モデル.
    21:               !
    22:               ! This is a model of short wave radiation. 
    23:               !
    24:               !== References
    25:               !
    26:               !  Chou, M.-D., and K.-T. Lee, 
    27:               !    Parameterizations for the absorption of solar radiation by water vapor and ozone, 
    28:               !    J. Atmos. Sci., 53, 1203-1208, 1996.
    29:               !
    30:               !== Procedures List
    31:               !
    32:             !!$  ! RadiationFluxDennouAGCM :: 放射フラックスの計算
    33:             !!$  ! RadiationDTempDt        :: 放射フラックスによる温度変化の計算
    34:             !!$  ! RadiationFluxOutput     :: 放射フラックスの出力
    35:             !!$  ! RadiationFinalize       :: 終了処理 (モジュール内部の変数の割り付け解除)
    36:             !!$  ! ------------            :: ------------
    37:             !!$  ! RadiationFluxDennouAGCM :: Calculate radiation flux
    38:             !!$  ! RadiationDTempDt        :: Calculate temperature tendency with radiation flux
    39:             !!$  ! RadiationFluxOutput     :: Output radiation fluxes
    40:             !!$  ! RadiationFinalize       :: Termination (deallocate variables in this module)
    41:               !
    42:               !== NAMELIST
    43:               !
    44:             !!$  ! NAMELIST#radiation_DennouAGCM_nml
    45:               !
    46:             
    47:               ! USE statements
    48:               !
    49:             
    50:               ! 
    51:               ! Kind type parameter
    52:               !
    53:               use dc_types, only: DP, &      ! Double precision.
    54:                 &                 STRING, &  ! Strings.
    55:                 &                 TOKEN      ! Keywords.
    56:             
    57:               ! メッセージ出力
    58:               ! Message output
    59:               !
    60:               use dc_message, only: MessageNotify
    61:             
    62:               ! 
    63:               ! Grid points settings
    64:               !
    65:               use gridset, only: imax, & ! 
    66:                                          ! Number of grid points in longitude
    67:                 &                jmax, & ! 
    68:                                          ! Number of grid points in latitude
    69:                 &                kmax    ! 
    70:                                          ! Number of vertical level
    71:             
    72:               ! Declaration statements
    73:               !
    74:               implicit none
    75:               private
    76:             
    77:               !
    78:               ! Public procedure
    79:               !
    80:               public :: RadCL1996NumBands
    81:               public :: RadCL1996UVVISParams
    82:               public :: RadCL1996IRH2ONumKDFBin
    83:               public :: RadCL1996IRH2OKDFParams
    84:               public :: RadCL1996ScaleH2OVapMass
    85:               public :: RadCL1996Init
    86:             
    87:             
    88:             
    89:               integer , parameter :: nband1 = 8  ! * 14500 to 57143 cm-1 (0.175 to 0.70 micron)
    90:               integer , parameter :: nband2 = 3  ! *  2600 to 14500 cm-1 (0.70-10 micron)
    91:               integer , parameter :: nkdf     = 10
    92:             
    93:               real(DP), save      :: a_UVVIFracSolarFlux(1:nband1)
    94:               real(DP), save      :: a_UVVISO3AbsCoef   (1:nband1)
    95:               real(DP), save      :: a_UVVISRayScatCoef (1:nband1)
    96:             
    97:               real(DP), save      :: a_IRH2Okdfk   (1:nkdf)                        ! k
    98:               real(DP), save      :: aa_IRH2Okdfdgi(1:nkdf,nband1+1:nband1+nband2) ! k dist. func.
    99:             
   100:             
   101:             
   102:               logical , save     :: rad_cl1996_inited
   103:             
   104:               data rad_cl1996_inited /.false./
   105:             
   106:             
   107:             
   108:             
   109:               ! Table 1
   110:               ! Unit of k is g-1 cm2.
   111:               data a_IRH2Okdfk &
   112:                 & / &
   113:                 & 0.0010 , 0.0133 , 0.0422 , 0.1334 , 0.4217 , 1.334  , 5.623  , 31.62  , 177.8  , 1000.0    &
   114:                 & /
   115:             
   116:               ! Table 1
   117:               data aa_IRH2Okdfdgi &
   118:                 & / &
   119:                 & 0.20673, 0.03497, 0.03011, 0.02260, 0.01336, 0.00696, 0.00441, 0.00115, 0.00026, 0.00000,  &  ! 0.7 -1.22
   120:                 & 0.08236, 0.01157, 0.01133, 0.01143, 0.01240, 0.01258, 0.01381, 0.00650, 0.00244, 0.00094,  &  ! 1.22-2.27
   121:                 & 0.01074, 0.00360, 0.00411, 0.00421, 0.00389, 0.00326, 0.00499, 0.00465, 0.00245, 0.00145   &  ! 2.27-10
   122:                 & /
   123:             
   124:             
   125:             !!$  data aa_KDFParams &
   126:             !!$    & / &
   127:             !!$    !  (0.7-10)  
   128:             !!$    &  0.29983, 0.05014, 0.04555, 0.03824, 0.02965, 0.02280, 0.02321, 0.01230, 0.00515, 0.00239   &
   129:             !!$    & /
   130:             
   131:             
   132:             !!$  data aa_UVVISBandParams &
   133:             !!$    & / &
   134:             !!$    &   , & ! 0.175-0.225              (UV-C)
   135:             !!$    &   , & ! 0.225-0.245, 0.260-0.280 (UV-C)
   136:             !!$    &   , & ! 0.245-0.260              (UV-C)
   137:             !!$    &   , & ! 0.280-0.295              (UV-B)
   138:             !!$    &   , & ! 0.295-0.310              (UV-B)
   139:             !!$    &   , & ! 0.310-0.320              (UV-B)
   140:             !!$    &   , & ! 0.320-0.400              (UV-A)
   141:             !!$    &     & ! 0.400-0.700              (PAR)
   142:             !!$    & /
   143:             
   144:             
   145:             
   146:               ! Table 3.
   147:               data a_UVVIFracSolarFlux &
   148:                 & /    0.00057,   0.00367,   0.00083,   0.00417,   0.00600,   0.00556,   0.05913,    0.39081 /
   149:             
   150:               ! Table 3.
   151:               ! Unit is (cm-atm)_{STP}^{-1}
   152:               data a_UVVISO3AbsCoef &
   153:                 & /   30.47   , 187.24   , 301.92   ,  42.83   ,   7.09   ,   1.25   ,   0.0345 ,    0.0539  /
   154:             
   155:               ! Table 3.
   156:               ! Unit is (mb)^{-1}
   157:               data a_UVVISRayScatCoef &
   158:                 & /    0.00604,   0.00170,   0.00222,   0.00132,   0.00107,   0.00091,   0.00055,    0.00012 /
   159:             
   160:             
   161:             
   162:               character(*), parameter:: module_name = 'rad_CL1996'
   163:                                           ! モジュールの名称.
   164:                                           ! Module name
   165:               character(*), parameter:: version = &
   166:                 & '$Name:  $' // &
   167:                 & '$Id: rad_CL1996.f90,v 1.4 2011/06/19 11:12:42 yot Exp $'
   168:                                           ! モジュールのバージョン
   169:                                           ! Module version
   170:             
   171:             contains
   172:             
   173:               !--------------------------------------------------------------------------------------
   174:             
   175:               subroutine RadCL1996NumBands( &
   176:                 & nbands1, nbands2 & ! (out)
   177:                 & )
   178:             
   179:                 integer, intent(out) :: nbands1
   180:                 integer, intent(out) :: nbands2
   181:             
   182:             
   183:                 ! 初期化確認
   184:                 ! Initialization check
   185:                 !
   186:                 if ( .not. rad_cl1996_inited ) then
   187:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   188:                 end if
   189:             
   190:             
   191:                 nbands1 = nband1
   192:                 nbands2 = nband2
   193:             
   194:               end subroutine RadCL1996NumBands
   195:             
   196:               !--------------------------------------------------------------------------------------
   197:             
   198:               subroutine RadCL1996IRH2ONumKDFBin( &
   199:                 & nbin & ! (out)
   200:                 & )
   201:             
   202:                 integer, intent(out) :: nbin
   203:             
   204:             
   205:                 ! 初期化確認
   206:                 ! Initialization check
   207:                 !
   208:                 if ( .not. rad_cl1996_inited ) then
   209:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   210:                 end if
   211:             
   212:             
   213:                 nbin = nkdf
   214:             
   215:               end subroutine RadCL1996IRH2ONumKDFBin
   216:             
   217:               !--------------------------------------------------------------------------------------
   218:             
   219:               subroutine RadCL1996ScaleH2OVapMass(  &
   220:                 & xyz_Temp, xyz_DelH2OVapMass, xyz_Press, & ! (in )
   221:                 & xyz_DelH2OVapMassScaled                 & ! (out)
   222:                 & )
   223:             
   224:             
   225:                 ! USE statements
   226:                 !
   227:             
   228:                 real(DP), intent(in ):: xyz_Temp               (0:imax-1, 1:jmax, 1:kmax)
   229:                 real(DP), intent(in ):: xyz_DelH2OVapMass      (0:imax-1, 1:jmax, 1:kmax)
   230:                 real(DP), intent(in ):: xyz_Press              (0:imax-1, 1:jmax, 1:kmax)
   231:                 real(DP), intent(out):: xyz_DelH2OVapMassScaled(0:imax-1, 1:jmax, 1:kmax)
   232:             
   233:             
   234:                 !
   235:                 ! Work variables
   236:                 !
   237:                 real(DP), parameter :: H2OScaleIndex = 0.8_DP
   238:                 real(DP), parameter :: RefPress      = 300.0d2
   239:                 real(DP), parameter :: RefTemp       = 240.0d0
   240:             
   241:             
   242:                 ! 初期化確認
   243:                 ! Initialization check
   244:                 !
   245:                 if ( .not. rad_cl1996_inited ) then
   246:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   247:                 end if
   248:             
   249:             
   250: W**==== A       xyz_DelH2OVapMassScaled =                                         &
   251:                   &   ( xyz_Press / RefPress )**H2OScaleIndex                     &
   252:                   & * exp( 0.00135_DP * ( xyz_Temp - RefTemp ) )                  &
   253:                   & * xyz_DelH2OVapMass
   254:             
   255:             
   256:               end subroutine RadCL1996ScaleH2OVapMass
   257:             
   258:               !--------------------------------------------------------------------------------------
   259:             
   260:               subroutine RadCL1996IRH2OKDFParams(        &
   261:                 & iband, ikdfbin,                              & ! (in )
   262:                 & KDFAbsCoef, KDFWeight                        & ! (out)
   263:                 & )
   264:             
   265:             
   266:                 ! USE statements
   267:                 !
   268:             
   269:                 integer , intent(in ):: iband
   270:                 integer , intent(in ):: ikdfbin
   271:                 real(DP), intent(out):: KDFAbsCoef
   272:                 real(DP), intent(out):: KDFWeight
   273:             
   274:             
   275:                 !
   276:                 ! Work variables
   277:                 !
   278:                 integer :: l
   279:                 integer :: m
   280:             
   281:             
   282:                 ! 初期化確認
   283:                 ! Initialization check
   284:                 !
   285:                 if ( .not. rad_cl1996_inited ) then
   286:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   287:                 end if
   288:             
   289:             
   290:                 l = iband
   291:                 m = ikdfbin
   292:             
   293:                 KDFAbsCoef = a_IRH2Okdfk   (m)
   294:             
   295:                 KDFWeight  = aa_IRH2Okdfdgi(m,l)
   296:             
   297:             
   298:               end subroutine RadCL1996IRH2OKDFParams
   299:             
   300:               !--------------------------------------------------------------------------------------
   301:             
   302:               subroutine RadCL1996UVVISParams(                    &
   303:                 & iband,                                                & ! (in )
   304:                 & UVVISFracSolarFlux, UVVISO3AbsCoef, UVVISRayScatCoef  & ! (out)
   305:                 & )
   306:             
   307:             
   308:                 ! USE statements
   309:                 !
   310:             
   311:                 integer , intent(in ):: iband
   312:                 real(DP), intent(out):: UVVISFracSolarFlux
   313:                 real(DP), intent(out):: UVVISO3AbsCoef
   314:                 real(DP), intent(out):: UVVISRayScatCoef
   315:             
   316:             
   317:                 !
   318:                 ! Work variables
   319:                 !
   320:                 integer :: l
   321:             
   322:             
   323:                 ! 初期化確認
   324:                 ! Initialization check
   325:                 !
   326:                 if ( .not. rad_cl1996_inited ) then
   327:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   328:                 end if
   329:             
   330:             
   331:                 l = iband
   332:             
   333:                 UVVISFracSolarFlux = a_UVVIFracSolarFlux(l)
   334:                 UVVISO3AbsCoef     = a_UVVISO3AbsCoef   (l)
   335:                 UVVISRayScatCoef   = a_UVVISRayScatCoef (l)
   336:             
   337:             
   338:               end subroutine RadCL1996UVVISParams
   339:             
   340:               !--------------------------------------------------------------------------------------
   341:             
   342:               subroutine RadCL1996Init
   343:             
   344:             
   345:             !!$    ! NAMELIST ファイル入力に関するユーティリティ
   346:             !!$    ! Utilities for NAMELIST file input
   347:             !!$    !
   348:             !!$    use namelist_util, only: NmlutilMsg
   349:             
   350:             !!$    ! ファイル入出力補助
   351:             !!$    ! File I/O support
   352:             !!$    !
   353:             !!$    use dc_iounit, only: FileOpen
   354:             
   355:             
   356:             !!$    ! ヒストリデータ出力
   357:             !!$    ! History data output
   358:             !!$    !
   359:             !!$    use gtool_historyauto, only: HistoryAutoAddVariable
   360:             
   361:             
   362:             !!$    integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号.
   363:             !!$                              ! Unit number for NAMELIST file open
   364:             !!$    integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT.
   365:             !!$                              ! IOSTAT of NAMELIST read
   366:             
   367:             !!$    ! NAMELIST 変数群
   368:             !!$    ! NAMELIST group name
   369:             !!$    !
   370:             !!$    namelist /rad_CL1996_nml/ !&
   371:             !!$      & ShortAtmosAlbedo
   372:             !!$          !
   373:             !!$          ! デフォルト値については初期化手続 "rad_CL1996#RadCL1996Init"
   374:             !!$          ! のソースコードを参照のこと.
   375:             !!$          !
   376:             !!$          ! Refer to source codes in the initialization procedure
   377:             !!$          ! "rad_LH74#RadLH74Init" for the default values.
   378:             !!$          !
   379:             
   380:             
   381:             
   382:                 if ( rad_cl1996_inited ) return
   383:             
   384:             
   385:                 ! デフォルト値の設定
   386:                 ! Default values settings
   387:                 !
   388:             
   389:             !!$    ! NAMELIST の読み込み
   390:             !!$    ! NAMELIST is input
   391:             !!$    !
   392:             !!$    if ( trim(namelist_filename) /= '' ) then
   393:             !!$      call FileOpen( unit_nml, &          ! (out)
   394:             !!$        & namelist_filename, mode = 'r' ) ! (in)
   395:             !!$
   396:             !!$      rewind( unit_nml )
   397:             !!$      read( unit_nml,                     & ! (in)
   398:             !!$        & nml = rad_CL1996_nml,     & ! (out)
   399:             !!$        & iostat = iostat_nml )             ! (out)
   400:             !!$      close( unit_nml )
   401:             !!$
   402:             !!$      call NmlutilMsg( iostat_nml, module_name ) ! (in)
   403:             !!$    end if
   404:             
   405:             
   406:             
   407:                 ! Unit is changed of k from g-1 cm2 to kg-1 m2.
   408:                 !
   409: V====== A       a_IRH2Okdfk = a_IRH2Okdfk * 1.0d3 * 1.0d-4
   410:             
   411:                 ! Convert unit of O3 absorption coefficient from (cm-atm)^{-1} to (kg m-2)^{-1}
   412:                 !   In order to convert unit from cm-1 atm-1 to m2 kg-1, multiply by
   413:                 !     1.0d2 / 101325.0d0 * 8.31432d0 / ( 48.0d-3 ) * 273.15d0.
   414:                 !
   415: V------>A       a_UVVISO3AbsCoef = a_UVVISO3AbsCoef &
   416: |                   & * 1.0d2 / 101325.0d0 * 8.31432d0 / ( 48.0d-3 ) * 273.15d0
   417: |           
   418: |               ! Convert unit of Rayleigh scattering coefficient from (mb)^{-1} to (kg m-2)^{-1}
   419: |               !   memo:
   420: |               !     1    mbar = 1e2 Pa
   421: |               !     1e-2 mbar = 1   Pa
   422: |               !
   423: |               ! In order to convert unit from (mb)^{-1} to (kg m-2)^{-1}, scattering 
   424: |               ! coefficient is multiplied by 1.0d-1 * g, where g is the gravitational 
   425: |               ! acceleration. In the old version of the code, a variable Grav in constants 
   426: |               ! module is used for gravitational acceleration, as is shown in a line below. 
   427: |               ! However, this variable is replaced with a constant value 9.8_DP. 
   428: |               ! This is because the value of Grav may be changed to a value which is 
   429: |               ! different from the Earth's value. (Of course, the scattering coefficient 
   430: |               ! in unit of (kg m-2)^{-1} is independent on gravitational acceleration.)
   431: |               !
   432: |           !!$    a_UVVISRayScatCoef = a_UVVISRayScatCoef * 1.0d-2 * Grav
   433: V------ A       a_UVVISRayScatCoef = a_UVVISRayScatCoef * 1.0d-2 * 9.8_DP
   434:             
   435:             
   436:             
   437:                 ! 印字 ; Print
   438:                 !
   439:                 call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   440:             !!$    call MessageNotify( 'M', module_name, 'ShortAtmosAlbedo = %f', d = (/ ShortAtmosAlbedo /) )
   441:                 call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   442:             
   443:             
   444:                 rad_cl1996_inited = .true.
   445:             
   446:               end subroutine RadCL1996Init
   447:             
   448:               !--------------------------------------------------------------------------------------
   449:             
   450:             end module rad_CL1996
