Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:50 2016
FILE NAME: rad_DennouAGCM.f90
PROGRAM NAME: rad_dennouagcm
DIAGNOSTIC LIST

  LINE  LEVEL( NO.): DIAGNOSTIC MESSAGE

   388  opt  (  11): Fused array assignments. :line 388 - 389
   388  opt  (1593): Loop nest collapsed into one loop.
   388  vec  (   4): Vectorized array expression.
   388  vec  (  29): ADB is used for array.: xyr_coldendryair
   388  vec  (  29): ADB is used for array.: xyr_coldenqvap
   391  vec  (   3): Unvectorized loop.
   391  vec  (  13): Overhead of loop division is too large.
   392  opt  (  11): Fused array assignments. :line 392 - 397
   392  opt  (1037): Feedback of array elements.
   392  opt  (1593): Loop nest collapsed into one loop.
   392  vec  (   4): Vectorized array expression.
   392  vec  (  29): ADB is used for array.: xyr_coldendryair
   392  vec  (  29): ADB is used for array.: xyr_coldenqvap
   392  vec  (  29): ADB is used for array.: xyr_press
   392  vec  (  29): ADB is used for array.: xyz_qvap
   397  opt  (1037): Feedback of array elements.
   425  opt  (  11): Fused array assignments. :line 425 - 426
   425  opt  (1592): Outer loop unrolled inside inner loop.
   425  vec  (   4): Vectorized array expression.
   425  vec  (  29): ADB is used for array.: xyr_radldwflux
   425  vec  (  29): ADB is used for array.: xyr_radldwfluxsave
   425  vec  (  29): ADB is used for array.: xyr_radluwflux
   425  vec  (  29): ADB is used for array.: xyr_radluwfluxsave
   425  vec  (   4): Vectorized array expression.
   425  vec  (  29): ADB is used for array.: xyr_radldwflux
   425  vec  (  29): ADB is used for array.: xyr_radldwfluxsave
   425  vec  (  29): ADB is used for array.: xyr_radluwflux
   425  vec  (  29): ADB is used for array.: xyr_radluwfluxsave
   427  opt  (  11): Fused array assignments. :line 427 - 428
   427  opt  (1772): Loop nest fused with following nest(s).
   427  opt  (1592): Outer loop unrolled inside inner loop.
   427  vec  (   4): Vectorized array expression.
   427  vec  (  29): ADB is used for array.: xyra_delradldwflux
   427  vec  (  29): ADB is used for array.: xyra_delradldwfluxsave
   427  vec  (  29): ADB is used for array.: xyra_delradluwflux
   427  vec  (  29): ADB is used for array.: xyra_delradluwfluxsave
   427  vec  (   4): Vectorized array expression.
   427  vec  (  29): ADB is used for array.: xyra_delradldwflux
   427  vec  (  29): ADB is used for array.: xyra_delradldwfluxsave
   427  vec  (  29): ADB is used for array.: xyra_delradluwflux
   427  vec  (  29): ADB is used for array.: xyra_delradluwfluxsave
   431  vec  (   3): Unvectorized loop.
   431  vec  (  13): Overhead of loop division is too large.
   432  opt  (  11): Fused array assignments. :line 432 - 439
   432  opt  (1592): Outer loop unrolled inside inner loop.
   432  vec  (   4): Vectorized array expression.
   432  vec  (  29): ADB is used for array.: xyra_delradldwflux
   432  vec  (  29): ADB is used for array.: xyr_radldwflux
   432  vec  (  29): ADB is used for array.: xyra_delradluwflux
   432  vec  (  29): ADB is used for array.: xyr_radluwflux
   432  vec  (  29): ADB is used for array.: xy_tempsave
   432  vec  (  29): ADB is used for array.: xyz_temp
   432  vec  (   4): Vectorized array expression.
   432  vec  (  29): ADB is used for array.: xyra_delradldwflux
   432  vec  (  29): ADB is used for array.: xyr_radldwflux
   432  vec  (  29): ADB is used for array.: xyra_delradluwflux
   432  vec  (  29): ADB is used for array.: xyr_radluwflux
   432  vec  (  29): ADB is used for array.: xyz_temp
   432  vec  (  29): ADB is used for array.: xy_tempsave
   477  opt  (1592): Outer loop unrolled inside inner loop.
   478  vec  (   1): Vectorized loop.
   478  vec  (  29): ADB is used for array.: xy_incomradsflux
   478  vec  (  29): ADB is used for array.: xy_cossza
   478  vec  (   1): Vectorized loop.
   478  vec  (  29): ADB is used for array.: xy_incomradsflux
   478  vec  (  29): ADB is used for array.: xy_cossza
   489  opt  (  11): Fused array assignments. :line 489 - 495
   489  opt  (1593): Loop nest collapsed into one loop.
   489  vec  (   4): Vectorized array expression.
   489  vec  (  29): ADB is used for array.: xy_incomradsflux
   509  opt  (  11): Fused array assignments. :line 509 - 510
   509  opt  (1592): Outer loop unrolled inside inner loop.
   509  vec  (   4): Vectorized array expression.
   509  vec  (  29): ADB is used for array.: xyr_radsdwflux
   509  vec  (  29): ADB is used for array.: xyr_radsdwfluxsave
   509  vec  (  29): ADB is used for array.: xyr_radsuwflux
   509  vec  (  29): ADB is used for array.: xyr_radsuwfluxsave
   509  vec  (   4): Vectorized array expression.
   509  vec  (  29): ADB is used for array.: xyr_radsdwflux
   509  vec  (  29): ADB is used for array.: xyr_radsdwfluxsave
   509  vec  (  29): ADB is used for array.: xyr_radsuwflux
   509  vec  (  29): ADB is used for array.: xyr_radsuwfluxsave
   518  opt  (1592): Outer loop unrolled inside inner loop.
   518  vec  (   4): Vectorized array expression.
   518  vec  (  29): ADB is used for array.: xy_tempsave
   518  vec  (  29): ADB is used for array.: xyz_temp
   518  vec  (   4): Vectorized array expression.
   518  vec  (  29): ADB is used for array.: xy_tempsave
   518  vec  (  29): ADB is used for array.: xyz_temp
   520  opt  (  11): Fused array assignments. :line 520 - 524
   520  opt  (1592): Outer loop unrolled inside inner loop.
   520  vec  (   4): Vectorized array expression.
   520  vec  (  29): ADB is used for array.: xyr_radldwfluxsave
   520  vec  (  29): ADB is used for array.: xyr_radldwflux
   520  vec  (  29): ADB is used for array.: xyr_radluwfluxsave
   520  vec  (  29): ADB is used for array.: xyr_radluwflux
   520  vec  (  29): ADB is used for array.: xyr_radsdwfluxsave
   520  vec  (  29): ADB is used for array.: xyr_radsdwflux
   520  vec  (  29): ADB is used for array.: xyr_radsuwfluxsave
   520  vec  (  29): ADB is used for array.: xyr_radsuwflux
   520  vec  (   4): Vectorized array expression.
   520  vec  (  29): ADB is used for array.: xyr_radldwfluxsave
   520  vec  (  29): ADB is used for array.: xyr_radldwflux
   520  vec  (  29): ADB is used for array.: xyr_radluwfluxsave
   520  vec  (  29): ADB is used for array.: xyr_radluwflux
   520  vec  (  29): ADB is used for array.: xyr_radsdwfluxsave
   520  vec  (  29): ADB is used for array.: xyr_radsdwflux
   520  vec  (  29): ADB is used for array.: xyr_radsuwfluxsave
   520  vec  (  29): ADB is used for array.: xyr_radsuwflux
   525  opt  (  11): Fused array assignments. :line 525 - 526
   525  opt  (1772): Loop nest fused with following nest(s).
   525  opt  (1592): Outer loop unrolled inside inner loop.
   525  vec  (   4): Vectorized array expression.
   525  vec  (  29): ADB is used for array.: xyra_delradldwfluxsave
   525  vec  (  29): ADB is used for array.: xyra_delradldwflux
   525  vec  (  29): ADB is used for array.: xyra_delradluwfluxsave
   525  vec  (  29): ADB is used for array.: xyra_delradluwflux
   525  vec  (   4): Vectorized array expression.
   525  vec  (  29): ADB is used for array.: xyra_delradldwfluxsave
   525  vec  (  29): ADB is used for array.: xyra_delradldwflux
   525  vec  (  29): ADB is used for array.: xyra_delradluwfluxsave
   525  vec  (  29): ADB is used for array.: xyra_delradluwflux
   602  warn (  82): Name "maxerror" is not used.
   697  opt  (1593): Loop nest collapsed into one loop.
   697  vec  (   4): Vectorized array expression.
   697  vec  (  29): ADB is used for array.: xyrr_trans
   702  vec  (   3): Unvectorized loop.
   702  vec  (  13): Overhead of loop division is too large.
   703  opt  (1593): Loop nest collapsed into one loop.
   703  vec  (   4): Vectorized array expression.
   703  vec  (  29): ADB is used for array.: xyrr_trans
   703  vec  (  29): ADB is used for array.: xyr_coldendryair
   703  vec  (  29): ADB is used for array.: xyr_coldenqvap
   719  vec  (   3): Unvectorized loop.
   719  vec  (  13): Overhead of loop division is too large.
   720  opt  (1036): Potential feedback - use directive if OK.
   720  opt  (1593): Loop nest collapsed into one loop.
   720  vec  (   4): Vectorized array expression.
   720  vec  (  29): ADB is used for array.: xyrr_trans
   728  opt  (1593): Loop nest collapsed into one loop.
   728  vec  (   4): Vectorized array expression.
   728  vec  (  29): ADB is used for array.: xyz_pib
   728  vec  (  29): ADB is used for array.: xyz_temp
   729  opt  (  11): Fused array assignments. :line 729 - 731
   729  opt  (1593): Loop nest collapsed into one loop.
   729  vec  (   4): Vectorized array expression.
   729  vec  (  29): ADB is used for array.: xy_surfpidbdt
   729  vec  (  29): ADB is used for array.: xy_pidbdt1
   729  vec  (  29): ADB is used for array.: xyz_temp
   729  vec  (  29): ADB is used for array.: xyz_pib
   729  vec  (  29): ADB is used for array.: xy_surfpib
   729  vec  (  29): ADB is used for array.: xy_surftemp
   743  warn (  82): Name "bandweightsum" is not used.
   803  opt  (1593): Loop nest collapsed into one loop.
   803  vec  (   4): Vectorized array expression.
   805  vec  (   3): Unvectorized loop.
   805  vec  (  13): Overhead of loop division is too large.
   806  opt  (1592): Outer loop unrolled inside inner loop.
   806  vec  (   4): Vectorized array expression.
   806  vec  (  29): ADB is used for array.: xyr_transfordwflux
   806  vec  (  29): ADB is used for array.: xyr_coldendryair
   806  vec  (  29): ADB is used for array.: xyr_coldenqvap
   806  vec  (  29): ADB is used for array.: xy_inangle
   806  vec  (   4): Vectorized array expression.
   806  vec  (  29): ADB is used for array.: xyr_transfordwflux
   806  vec  (  29): ADB is used for array.: xyr_coldendryair
   806  vec  (  29): ADB is used for array.: xyr_coldenqvap
   806  vec  (  29): ADB is used for array.: xy_inangle
   815  opt  (1593): Loop nest collapsed into one loop.
   815  vec  (   4): Vectorized array expression.
   817  vec  (   3): Unvectorized loop.
   817  vec  (  13): Overhead of loop division is too large.
   818  vec  (   4): Vectorized array expression.
   818  vec  (  29): ADB is used for array.: xyr_transforuwflux
   818  vec  (  29): ADB is used for array.: xy_surfalbedo
   818  vec  (  29): ADB is used for array.: xyr_coldendryair
   818  vec  (  29): ADB is used for array.: xyr_coldenqvap
   818  vec  (  29): ADB is used for array.: xy_inangle
   835  vec  (   3): Unvectorized loop.
   835  vec  (  13): Overhead of loop division is too large.
   836  opt  (  11): Fused array assignments. :line 836 - 837
   836  opt  (1593): Loop nest collapsed into one loop.
   836  vec  (   4): Vectorized array expression.
   836  vec  (  29): ADB is used for array.: xyr_radsuwflux
   836  vec  (  29): ADB is used for array.: xyr_transforuwflux
   836  vec  (  29): ADB is used for array.: xyr_radsdwflux
   836  vec  (  29): ADB is used for array.: xyr_transfordwflux
   836  vec  (  29): ADB is used for array.: xy_toaradsdwflux
  1071  opt  (  11): Fused array assignments. :line 1071 - 1073
  1071  vec  (   4): Vectorized array expression.
  1071  vec  (  29): ADB is used for array.: longbandweight
  1071  vec  (  29): ADB is used for array.: longabsorpcoefdryair
  1071  vec  (  29): ADB is used for array.: longabsorpcoefqvap
  1074  opt  (  11): Fused array assignments. :line 1074 - 1076
  1090  opt  (  11): Fused array assignments. :line 1090 - 1092
  1090  vec  (   4): Vectorized array expression.
  1090  vec  (  29): ADB is used for array.: shortbandweight
  1090  vec  (  29): ADB is used for array.: shortabsorpcoefdryair
  1090  vec  (  29): ADB is used for array.: shortabsorpcoefqvap
  1093  opt  (  11): Fused array assignments. :line 1093 - 1095
  1134  vec  (   1): Vectorized loop.
  1134  vec  (  24): Iteration count is assumed. Iteration count=256
  1134  vec  (  29): ADB is used for array.: longbandweight
  1135  vec  (  26): Macro operation Sum/InnerProd.
  1137  vec  (   1): Vectorized loop.
  1137  vec  (  24): Iteration count is assumed. Iteration count=256
  1137  vec  (  29): ADB is used for array.: longbandweight
  1142  vec  (   1): Vectorized loop.
  1142  vec  (  24): Iteration count is assumed. Iteration count=256
  1142  vec  (  29): ADB is used for array.: shortbandweight
  1143  vec  (  26): Macro operation Sum/InnerProd.
  1145  vec  (   1): Vectorized loop.
  1145  vec  (  24): Iteration count is assumed. Iteration count=256
  1145  vec  (  29): ADB is used for array.: shortbandweight
  1358  vec  (   4): Vectorized array expression.
  1358  vec  (  29): ADB is used for array.: x_lon
  1361  vec  (   4): Vectorized array expression.
  1361  vec  (  29): ADB is used for array.: y_lat
  1509  vec  (   4): Vectorized array expression.
  1509  vec  (  24): Iteration count is assumed. Iteration count=256
  1509  vec  (  29): ADB is used for array.: longabsorpcoefqvap
  1511  vec  (   4): Vectorized array expression.
  1511  vec  (  24): Iteration count is assumed. Iteration count=256
  1511  vec  (  29): ADB is used for array.: longabsorpcoefdryair
  1513  vec  (   4): Vectorized array expression.
  1513  vec  (  24): Iteration count is assumed. Iteration count=256
  1513  vec  (  29): ADB is used for array.: longbandweight
  1519  vec  (   4): Vectorized array expression.
  1519  vec  (  24): Iteration count is assumed. Iteration count=256
  1519  vec  (  29): ADB is used for array.: shortabsorpcoefqvap
  1521  vec  (   4): Vectorized array expression.
  1521  vec  (  24): Iteration count is assumed. Iteration count=256
  1521  vec  (  29): ADB is used for array.: shortabsorpcoefdryair
  1523  vec  (   4): Vectorized array expression.
  1523  vec  (  24): Iteration count is assumed. Iteration count=256
  1523  vec  (  29): ADB is used for array.: shortbandweight
  1532  warn (  82): Name "origin_time" is not used.
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:50 2016
FILE NAME: rad_DennouAGCM.f90
PROGRAM NAME: rad_dennouagcm
TRANSFORMATION LIST

  LINE                   FORTRAN STATEMENT

     1  != 放射フラックス (GFD 電脳倶楽部開発の放射モデル)
     2  !
     3  != Radiation flux (radiation model developed by GFD Dennou Club)
     4  !
     5  ! Authors::   Yoshiyuki O. Takahashi, Yasuhiro MORIKAWA, Yukiko YAMADA, Satoshi NODA
     6  ! Version::   $Id: rad_DennouAGCM.f90,v 1.3 2012/02/01 05:19:53 yot Exp $
     7  ! Tag Name::  $Name:  $
     8  ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9  ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10  !
    11  
    12  module rad_DennouAGCM
    13    !
    14    != 放射フラックス (GFD 電脳倶楽部開発の放射モデル)
    15    !
    16    != Radiation flux (radiation model developed by GFD Dennou Club)
    17    !
    18    ! <b>Note that Japanese and English are described in parallel.</b>
    19    !
    20    ! 温度, 比湿, 気圧から, 放射フラックスを計算する放射モデルです.
    21    !
    22    ! This is a radiation model that calculates radiation flux from
    23    ! temperature, specific humidity, and air pressure.
    24    !
    25    !== References
    26    !
    27    !  Numaguti, Atusi, 1992:
    28    !    熱帯における積雲活動の大規模構造に関する数値実験. Doctor thesis, 218pp. (Japanese)
    29    !
    30    !== Procedures List
    31    !
    32    ! RadDennouAGCMFlux     :: 放射フラックスの計算
    33    ! RadDennouAGCMFinalize :: 終了処理 (モジュール内部の変数の割り付け解除)
    34    ! ------------                :: ------------
    35    ! RadDennouAGCMFlux     :: Calculate radiation flux
    36    ! RadDennouAGCMFinalize :: Termination (deallocate variables in this module)
    37    !
    38    !== NAMELIST
    39    !
    40    ! NAMELIST#rad_DennouAGCM_nml
    41    !
    42  
    43    ! モジュール引用 ; USE statements
    44    !
    45  
    46    ! 格子点設定
    47    ! Grid points settings
    48    !
    49    use gridset, only: imax, & ! 経度格子点数.
    50                               ! Number of grid points in longitude
    51      &                jmax, & ! 緯度格子点数.
    52                               ! Number of grid points in latitude
    53      &                kmax    ! 鉛直層数.
    54                               ! Number of vertical level
    55  
    56    ! リスタートデータ入出力
    57    ! Restart data input/output
    58    !
    59    use restart_file_io, only: &
    60      & RstFileIntValue => IntValue, &
    61                                ! リスタートデータの出力間隔 (数値).
    62                                ! Interval of restart data output (numerical value)
    63      & RstFileIntUnit  => IntUnit, &
    64                                ! リスタートデータの出力間隔 (単位).
    65                                ! Interval of restart data output (unit)
    66      & RstFileIntTime  => IntTime
    67                                ! リスタートデータの出力間隔.
    68                                ! Interval of restart data output
    69  
    70    ! 種別型パラメタ
    71    ! Kind type parameter
    72    !
    73    use dc_types, only: DP, &      ! 倍精度実数型. Double precision.
    74      &                 STRING, &  ! 文字列.       Strings.
    75      &                 TOKEN      ! キーワード.   Keywords.
    76  
    77    ! NAMELIST ファイル入力に関するユーティリティ
    78    ! Utilities for NAMELIST file input
    79    !
    80    use namelist_util, only: MaxNmlArySize
    81                                ! NAMELIST から読み込む配列の最大サイズ.
    82                                ! Maximum size of arrays loaded from NAMELIST
    83  
    84    ! メッセージ出力
    85    ! Message output
    86    !
    87    use dc_message, only: MessageNotify
    88  
    89    ! リスタートデータ出力
    90    ! Restart data output
    91    !
    92    use gtool_history, only: GT_HISTORY
    93  
    94    ! 宣言文 ; Declaration statements
    95    !
    96    implicit none
    97    private
    98  
    99    ! 公開手続き
   100    ! Public procedure
   101    !
   102    public:: RadDennouAGCMFlux
   103    public:: RadDennouAGCMInit
   104    public:: RadDennouAGCMFinalize
   105  
   106    ! 公開変数
   107    ! Public variables
   108    !
   109    logical, save :: rad_DennouAGCM_inited = .false.
   110                                ! 初期設定フラグ.
   111                                ! Initialization flag
   112  
   113  
   114    ! 非公開変数
   115    ! Private variables
   116    !
   117    logical, save:: Old_Flux_saved = .false.
   118                                ! 一度計算したフラックスを保存したことを示すフラグ.
   119                                ! Flag for saving of flux calculated once
   120  
   121    type(GT_HISTORY), save:: gthst_rst
   122                                ! リスタートデータ用 gtool_history#GT_HISTORY 変数.
   123                                ! "gtool_history#GT_HISTORY" variable for restart data
   124    real(DP), save:: PrevRstOutputTime
   125                                ! 前回のリスタートファイルの出力時間.
   126                                ! Previous output time of a restart file
   127    logical, save:: flag_rst_output_end
   128                                ! 計算最終時刻の出力完了のフラグ.
   129                                ! Flag for completion of output at the end time of calculation
   130    logical, save:: flag_rst_input = .false.
   131                                ! 現在の保存値がリスタートファイルから読み込まれたことを示すフラグ.
   132                                ! Flag that indicates that saved value is input from a restart file.
   133  
   134    ! 長波フラックス用情報
   135    ! Information for long wave flux
   136    !
   137    real(DP), save:: IntTimeLong
   138                                ! 長波フラックスを計算する時間間隔.
   139                                ! Interval time of long wave flux calculation
   140    real(DP), save:: PrevTimeLong
   141                                ! 前回長波フラックスを計算した時刻.
   142                                ! Time when long wave flux is calculated
   143    real(DP), save:: DelTimeLongValue
   144                                ! 長波フラックスを計算する時間間隔の数値.
   145                                ! Value of interval step of long wave flux calculation
   146    character(STRING), save:: DelTimeLongUnit
   147                                ! 長波フラックスを計算する時間間隔の単位.
   148                                ! Unit of interval step of long wave flux calculation
   149  
   150    integer, save:: LongBandNum
   151                                ! 長波バンド数.
   152                                ! Number of long wave band
   153    real(DP), save:: LongAbsorpCoefQVap (1:MaxNmlArySize)
   154                                ! $ k_R $ . 水の吸収係数.
   155                                ! Absorption coefficient of water.
   156    real(DP), save:: LongAbsorpCoefDryAir (1:MaxNmlArySize)
   157                                ! $ \bar{k}_R $ . 空気の吸収係数.
   158                                ! Absorption coefficient of air.
   159    real(DP), save:: LongBandWeight (1:MaxNmlArySize)
   160                                ! バンドウェイト.
   161                                ! Band weight.
   162    real(DP), save:: LongPathLengthFact
   163                                ! 光路長のファクタ.
   164                                ! Factor of optical length
   165  
   166    real(DP), allocatable, save:: xy_TempSave (:,:)
   167                                ! $ T $ .     温度 (保存用). Temperature (for save)
   168    real(DP), allocatable, save:: xyr_RadLUwFluxSave (:,:,:)
   169                                ! 長波フラックス (保存用).
   170                                ! Upward long wave flux (for save)
   171    real(DP), allocatable, save:: xyr_RadLDwFluxSave (:,:,:)
   172                                ! 長波フラックス (保存用).
   173                                ! Downward long wave flux (for save)
   174    real(DP), allocatable, save:: xyra_DelRadLUwFluxSave (:,:,:,:)
   175                                ! 長波地表温度変化 (保存用).
   176                                !
   177    real(DP), allocatable, save:: xyra_DelRadLDwFluxSave (:,:,:,:)
   178                                ! 長波地表温度変化 (保存用).
   179                                !
   180  
   181    ! 短波フラックス用情報
   182    ! Information for short wave flux
   183    !
   184    real(DP), save:: SolarConst
   185                                ! 太陽定数.
   186                                ! Solar constant.
   187    real(DP), save:: IntTimeShort
   188                                ! 短波フラックスを計算する時間間隔.
   189                                ! Interval time of short wave flux calculation
   190    real(DP), save:: PrevTimeShort
   191                                ! 前回短波フラックスを計算した時刻
   192                                ! Time when short wave flux is calculated
   193    real(DP), save:: DelTimeShortValue
   194                                ! 短波 (日射) フラックスを計算する時間間隔の数値.
   195                                ! Value of interval step of short wave (insolation) flux calculation
   196    character(STRING), save:: DelTimeShortUnit
   197                                ! 短波 (日射) フラックスを計算する時間間隔の単位.
   198                                ! Unit of interval step of short wave (insolation) flux calculation
   199  
   200  
   201    integer, save:: ShortBandNum
   202                                ! 短波バンド数.
   203                                ! Number of short wave band
   204    real(DP), save:: ShortAbsorpCoefQVap (1:MaxNmlArySize)
   205                                ! $ k_S $ . 水の吸収係数.
   206                                ! Absorption coefficient of water.
   207    real(DP), save:: ShortAbsorpCoefDryAir (1:MaxNmlArySize)
   208                                ! $ \bar{k}_S $ . 空気の吸収係数.
   209                                ! Absorption coefficient of air.
   210    real(DP), save:: ShortBandWeight (1:MaxNmlArySize)
   211                                ! バンドウェイト.
   212                                ! Band weight.
   213    real(DP), save:: ShortSecScat
   214                                ! 散乱の $ \sec \zeta $ .
   215                                ! $ \sec \zeta $ of scattering
   216    real(DP), save:: ShortAtmosAlbedo
   217                                ! 大気アルベド.
   218                                ! Albedo of air.
   219  
   220    real(DP), allocatable, save:: xyr_RadSUwFluxSave (:,:,:)
   221                                ! 短波 (日射) フラックス (保存用).
   222                                ! Upward short wave (insolation) flux (for save)
   223    real(DP), allocatable, save:: xyr_RadSDwFluxSave (:,:,:)
   224                                ! 短波 (日射) フラックス (保存用).
   225                                ! Downward short wave (insolation) flux (for save)
   226  
   227    ! 短波入射用情報
   228    ! Information for short wave incoming
   229    !
   230    real(DP), allocatable, save:: xy_IncomRadSFlux (:,:)
   231                                ! 短波 (日射) フラックス.
   232                                ! Short wave (insolation) flux
   233    real(DP), allocatable, save:: xy_InAngle (:,:)
   234                                ! sec (入射角).
   235                                ! sec (angle of incidence)
   236  
   237  
   238    character(*), parameter:: module_name = 'rad_DennouAGCM'
   239                                ! モジュールの名称.
   240                                ! Module name
   241    character(*), parameter:: version = &
   242      & '$Name:  $' // &
   243      & '$Id: rad_DennouAGCM.f90,v 1.3 2012/02/01 05:19:53 yot Exp $'
   244                                ! モジュールのバージョン
   245                                ! Module version
   246  
   247  contains
   248  
   249    !--------------------------------------------------------------------------------------
   250  
   251    subroutine RadDennouAGCMFlux(                  &
   252      & xyz_Temp, xyz_QVap, xyr_Press,             & ! (in)
   253      & xy_SurfTemp, xy_SurfAlbedo,                & ! (in)
   254      & xyr_RadSUwFlux, xyr_RadSDwFlux,            & ! (out)
   255      & xyr_RadLUwFlux, xyr_RadLDwFlux,            & ! (out)
   256      & xyra_DelRadLUwFlux, xyra_DelRadLDwFlux     & ! (out)
   257      & )
   258      !
   259      ! 温度, 比湿, 気圧から, 放射フラックスを計算します.
   260      !
   261      ! Calculate radiation flux from temperature, specific humidity, and
   262      ! air pressure.
   263      !
   264  
   265      ! モジュール引用 ; USE statements
   266      !
   267  
   268      ! 短波入射 (太陽入射)
   269      ! Short wave (insolation) incoming
   270      !
   271      use rad_short_income, only: RadShortIncome
   272  
   273      ! 物理定数設定
   274      ! Physical constants settings
   275      !
   276      use constants, only: Grav ! $ g $ [m s-2].
   277                                ! 重力加速度.
   278                                ! Gravitational acceleration
   279  
   280      ! 時刻管理
   281      ! Time control
   282      !
   283      use timeset, only: &
   284        & TimeN, &              ! ステップ $ t $ の時刻.
   285                                ! Time of step $ t $.
   286        & EndTime, &            ! 計算終了時刻.
   287                                ! End time of calculation
   288        & TimesetClockStart, TimesetClockStop
   289  
   290      ! リスタートデータ出力
   291      ! Restart data output
   292      !
   293      use gtool_history, only: HistoryPut, HistorySetTime
   294  
   295      ! デバッグ用ユーティリティ
   296      ! Utilities for debug
   297      !
   298      use dc_trace, only: DbgMessage, BeginSub, EndSub
   299  
   300      ! 宣言文 ; Declaration statements
   301      !
   302      implicit none
   303  
   304      real(DP), intent(in):: xyz_Temp  (0:imax-1, 1:jmax, 1:kmax)
   305                                ! $ T $ .     温度. Temperature
   306      real(DP), intent(in):: xyz_QVap  (0:imax-1, 1:jmax, 1:kmax)
   307                                ! $ q $ .     比湿. Specific humidity
   308      real(DP), intent(in):: xyr_Press (0:imax-1, 1:jmax, 0:kmax)
   309                                ! $ \hat{p} $ . 気圧 (半整数レベル).
   310                                ! Air pressure (half level)
   311      real(DP), intent(in):: xy_SurfTemp (0:imax-1, 1:jmax)
   312                                ! 地表面温度.
   313                                ! Surface temperature
   314      real(DP), intent(in):: xy_SurfAlbedo (0:imax-1, 1:jmax)
   315                                ! 地表アルベド.
   316                                ! Surface albedo
   317  
   318      real(DP), intent(out):: xyr_RadSUwFlux (0:imax-1, 1:jmax, 0:kmax)
   319                                ! 短波 (日射) フラックス.
   320                                ! Upward shortwave (insolation) flux
   321      real(DP), intent(out):: xyr_RadSDwFlux (0:imax-1, 1:jmax, 0:kmax)
   322                                ! 短波 (日射) フラックス.
   323                                ! Downward shortwave (insolation) flux
   324  
   325      real(DP), intent(out):: xyr_RadLUwFlux (0:imax-1, 1:jmax, 0:kmax)
   326                                ! 長波フラックス.
   327                                ! Upward longwave flux
   328      real(DP), intent(out):: xyr_RadLDwFlux (0:imax-1, 1:jmax, 0:kmax)
   329                                ! 長波フラックス.
   330                                ! Downward longwave flux
   331      real(DP), intent(out):: xyra_DelRadLUwFlux (0:imax-1, 1:jmax, 0:kmax, 0:1)
   332                                ! 長波地表温度変化.
   333                                !
   334      real(DP), intent(out):: xyra_DelRadLDwFlux (0:imax-1, 1:jmax, 0:kmax, 0:1)
   335                                ! 長波地表温度変化.
   336                                !
   337  
   338  
   339  
   340      ! 作業変数
   341      ! Work variables
   342      !
   343      real(DP):: xyr_ColDenQVap (0:imax-1, 1:jmax, 0:kmax)
   344                                ! $ \int_z^{\infty} \rho q \, dz $ .
   345                                ! 鉛直層 k より上空の水蒸気のカラム密度.
   346                                ! Column density of water vapor above vertical level k.
   347      real(DP):: xyr_ColDenDryAir (0:imax-1, 1:jmax, 0:kmax)
   348                                ! $ \int_z^{\infty} \rho \, dz $ .
   349                                ! 鉛直層 k より上空の空気のカラム密度.
   350                                ! Column density of air above vertical level k.
   351      integer:: k               ! 鉛直方向に回る DO ループ用作業変数
   352                                ! Work variables for DO loop in vertical direction
   353      logical:: flag_rst_output
   354                                ! リスタートファイル出力のフラグ.
   355                                ! Flag for output of a restart file
   356  
   357      real(DP) :: xy_CosSZA(0:imax-1, 1:jmax)
   358      real(DP) :: DistFromStarScld
   359      real(DP) :: DiurnalMeanFactor
   360  
   361      integer:: i
   362      integer:: j
   363  
   364  
   365      real(DP) :: MaxError
   366  
   367  
   368      ! 実行文 ; Executable statement
   369      !
   370  
   371      ! 初期化確認
   372      ! Initialization check
   373      !
   374      if ( .not. rad_DennouAGCM_inited ) then
   375        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   376      end if
   377  
   378  
   379      ! 計算時間計測開始
   380      ! Start measurement of computation time
   381      !
   382      call TimesetClockStart( module_name )
   383  
   384  
   385      ! 鉛直層 k より上空のカラム密度の計算
   386      ! Calculate column density above vertical level k
   387      !
   388      xyr_ColDenQVap  (:,:,kmax) = 0.
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t872 = 1, xyr_coldenqvap.DSC.U2*xyr_coldenqvap.DSC.U1 +        
     .       1   xyr_coldenqvap.DSC.U2                                          
     .           xyr_coldenqvap(t872-1,1,kmax) = 0.0000000000000000e+000        
     .           xyr_coldendryair(t872-1,1,kmax) = 0.0000000000000000e+000      
     .        enddo                                                             
   389      xyr_ColDenDryAir(:,:,kmax) = 0.
   390  
   391      do k = kmax-1, 0, -1
   392        xyr_ColDenQVap(:,:,k) = &
     .        d1 = 1.D0/grav                                                    
     .        d2 = 1.D0/grav                                                    
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t880 = 1, xyr_coldenqvap.DSC.U2*xyr_coldenqvap.DSC.U1 +        
     .       1   xyr_coldenqvap.DSC.U2                                          
     .           xyr_coldenqvap(t880-1,1,k) = xyr_coldenqvap(t880-1,1,k+1) +    
     .       1      xyz_qvap(t880-1,1,k+1)*(xyr_press(t880-1,1,k)-xyr_press(t880
     .       2      -1,1,k+1))*d1                                               
     .           xyr_coldendryair(t880-1,1,k) = xyr_coldendryair(t880-1,1,k+1)  
     .       1       + (xyr_press(t880-1,1,k)-xyr_press(t880-1,1,k+1))*d2       
     .        enddo                                                             
   393          &   xyr_ColDenQVap(:,:,k+1) &
   394          & + xyz_QVap(:,:,k+1) &
   395          &   * ( xyr_Press(:,:,k) - xyr_Press(:,:,k+1) ) / Grav
   396  
   397        xyr_ColDenDryAir(:,:,k) = &
   398          &   xyr_ColDenDryAir(:,:,k+1) &
   399          & + ( xyr_Press(:,:,k) - xyr_Press(:,:,k+1) ) / Grav
   400      end do
   401  
   402      ! 長波フラックスの算出
   403      ! Calculate long wave flux
   404      !
   405      if ( ( TimeN - PrevTimeLong >= IntTimeLong ) .or. ( .not. Old_Flux_saved ) ) then
   406  
   407        if ( .not. Old_Flux_saved ) then
   408          PrevTimeLong = TimeN
   409        else
   410          PrevTimeLong = PrevTimeLong + IntTimeLong
   411        end if
   412  
   413  
   414        call LongFlux( &
   415          & xyz_Temp, xy_SurfTemp, xyr_ColDenQVap, xyr_ColDenDryAir,                & ! (in)
   416          & xyr_RadLUwFlux, xyr_RadLDwFlux, xyra_DelRadLUwFlux, xyra_DelRadLDwFlux  & ! (out)
   417          & )
   418  
   419  
   420      ! 前回の値を利用
   421      ! Use values in last time
   422      !
   423      else
   424  
   425        xyr_RadLUwFlux     = xyr_RadLUwFluxSave
     .        if (jmax .gt. 0) then                                             
     .           j1 = and(jmax,3)                                               
     .  !cdir    nodep                                                          
     .           do t904 = 1, j1                                                
     .  !cdir       nodep                                                       
     .              do t906 = 1, imax                                           
     .                 xyr_radluwflux(t906-1,t904,t902) = xyr_radluwfluxsave(t64
     .       1            +t906-1,t904-1+t66,t902+t68)                          
     .                 xyr_radldwflux(t906-1,t904,t902) = xyr_radldwfluxsave(t53
     .       1            +t906-1,t904-1+t55,t902+t57)                          
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t904 = j1 + 1, jmax, 4                                      
     .  !cdir       nodep                                                       
     .              do t906 = 1, imax                                           
     .                 xyr_radluwflux(t906-1,t904,t902) = xyr_radluwfluxsave(t64
     .       1            +t906-1,t904-1+t66,t902+t68)                          
     .                 xyr_radluwflux(t906-1,t904+1,t902) = xyr_radluwfluxsave( 
     .       1            t64+t906-1,t904+t66,t902+t68)                         
     .                 xyr_radluwflux(t906-1,t904+2,t902) = xyr_radluwfluxsave( 
     .       1            t64+t906-1,t904+1+t66,t902+t68)                       
     .                 xyr_radluwflux(t906-1,t904+3,t902) = xyr_radluwfluxsave( 
     .       1            t64+t906-1,t904+2+t66,t902+t68)                       
     .                 xyr_radldwflux(t906-1,t904,t902) = xyr_radldwfluxsave(t53
     .       1            +t906-1,t904-1+t55,t902+t57)                          
     .                 xyr_radldwflux(t906-1,t904+1,t902) = xyr_radldwfluxsave( 
     .       1            t53+t906-1,t904+t55,t902+t57)                         
     .                 xyr_radldwflux(t906-1,t904+2,t902) = xyr_radldwfluxsave( 
     .       1            t53+t906-1,t904+1+t55,t902+t57)                       
     .                 xyr_radldwflux(t906-1,t904+3,t902) = xyr_radldwfluxsave( 
     .       1            t53+t906-1,t904+2+t55,t902+t57)                       
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
   426        xyr_RadLDwFlux     = xyr_RadLDwFluxSave
   427        xyra_DelRadLUwFlux = xyra_DelRadLUwFluxSave
     .  !cdir nodep                                                             
     .        do t922 = 0, kmax                                                 
     .           if (jmax .gt. 0) then                                          
     .              j2 = and(jmax,3)                                            
     .  !cdir       nodep                                                       
     .              do t924 = 1, j2                                             
     .  !cdir          nodep                                                    
     .                 do t926 = 1, imax                                        
     .                    xyra_delradluwflux(t926-1,t924,t922,0) =              
     .       1               xyra_delradluwfluxsave(t23+t926-1,t924-1+t25,t922+ 
     .       2               t27,t29)                                           
     .                    xyra_delradldwflux(t926-1,t924,t922,0) =              
     .       1               xyra_delradldwfluxsave(t9+t926-1,t924-1+t11,t922+  
     .       2               t13,t15)                                           
     .                    xyra_delradluwflux(t926-1,t924,t922,1) =              
     .       1               xyra_delradluwfluxsave(t23+t926-1,t924-1+t25,t922+ 
     .       2               t27,1+t29)                                         
     .                    xyra_delradldwflux(t926-1,t924,t922,1) =              
     .       1               xyra_delradldwfluxsave(t9+t926-1,t924-1+t11,t922+  
     .       2               t13,1+t15)                                         
     .                 enddo                                                    
     .              enddo                                                       
     .  !cdir       nodep                                                       
     .              do t924 = j2 + 1, jmax, 4                                   
     .  !cdir          nodep                                                    
     .                 do t926 = 1, imax                                        
     .                    xyra_delradluwflux(t926-1,t924,t922,0) =              
     .       1               xyra_delradluwfluxsave(t23+t926-1,t924-1+t25,t922+ 
     .       2               t27,t29)                                           
     .                    xyra_delradluwflux(t926-1,t924+1,t922,0) =            
     .       1               xyra_delradluwfluxsave(t23+t926-1,t924+t25,t922+t27
     .       2               ,t29)                                              
     .                    xyra_delradluwflux(t926-1,t924+2,t922,0) =            
     .       1               xyra_delradluwfluxsave(t23+t926-1,t924+1+t25,t922+ 
     .       2               t27,t29)                                           
     .                    xyra_delradluwflux(t926-1,t924+3,t922,0) =            
     .       1               xyra_delradluwfluxsave(t23+t926-1,t924+2+t25,t922+ 
     .       2               t27,t29)                                           
     .                    xyra_delradldwflux(t926-1,t924,t922,0) =              
     .       1               xyra_delradldwfluxsave(t9+t926-1,t924-1+t11,t922+  
     .       2               t13,t15)                                           
     .                    xyra_delradldwflux(t926-1,t924+1,t922,0) =            
     .       1               xyra_delradldwfluxsave(t9+t926-1,t924+t11,t922+t13,
     .       2               t15)                                               
     .                    xyra_delradldwflux(t926-1,t924+2,t922,0) =            
     .       1               xyra_delradldwfluxsave(t9+t926-1,t924+1+t11,t922+  
     .       2               t13,t15)                                           
     .                    xyra_delradldwflux(t926-1,t924+3,t922,0) =            
     .       1               xyra_delradldwfluxsave(t9+t926-1,t924+2+t11,t922+  
     .       2               t13,t15)                                           
     .                    xyra_delradluwflux(t926-1,t924,t922,1) =              
     .       1               xyra_delradluwfluxsave(t23+t926-1,t924-1+t25,t922+ 
     .       2               t27,1+t29)                                         
     .                    xyra_delradluwflux(t926-1,t924+1,t922,1) =            
     .       1               xyra_delradluwfluxsave(t23+t926-1,t924+t25,t922+t27
     .       2               ,1+t29)                                            
     .                    xyra_delradluwflux(t926-1,t924+2,t922,1) =            
     .       1               xyra_delradluwfluxsave(t23+t926-1,t924+1+t25,t922+ 
     .       2               t27,1+t29)                                         
     .                    xyra_delradluwflux(t926-1,t924+3,t922,1) =            
     .       1               xyra_delradluwfluxsave(t23+t926-1,t924+2+t25,t922+ 
     .       2               t27,1+t29)                                         
     .                    xyra_delradldwflux(t926-1,t924,t922,1) =              
     .       1               xyra_delradldwfluxsave(t9+t926-1,t924-1+t11,t922+  
     .       2               t13,1+t15)                                         
     .                    xyra_delradldwflux(t926-1,t924+1,t922,1) =            
     .       1               xyra_delradldwfluxsave(t9+t926-1,t924+t11,t922+t13,
     .       2               1+t15)                                             
     .                    xyra_delradldwflux(t926-1,t924+2,t922,1) =            
     .       1               xyra_delradldwfluxsave(t9+t926-1,t924+1+t11,t922+  
     .       2               t13,1+t15)                                         
     .                    xyra_delradldwflux(t926-1,t924+3,t922,1) =            
     .       1               xyra_delradldwfluxsave(t9+t926-1,t924+2+t11,t922+  
     .       2               t13,1+t15)                                         
     .                 enddo                                                    
     .              enddo                                                       
     .           endif                                                          
     .        enddo                                                             
   428        xyra_DelRadLDwFlux = xyra_DelRadLDwFluxSave
   429  
   430        if ( .not. flag_rst_input ) then
   431          do k = 0, kmax
   432            xyr_RadLUwFlux(:,:,k) = xyr_RadLUwFlux(:,:,k) &
     .        if (jmax .gt. 0) then                                             
     .           j3 = and(jmax,3)                                               
     .  !cdir    nodep                                                          
     .           do t1036 = 1, j3                                               
     .  !cdir       nodep                                                       
     .  !cdir       on_adb(xyz_temp,xy_tempsave)                                
     .              do t1038 = 1, imax                                          
     .                 xyr_radluwflux(t1038-1,t1036,k) = xyr_radluwflux(t1038-1,
     .       1            t1036,k) + xyra_delradluwflux(t1038-1,t1036,k,1)*(    
     .       2            xyz_temp(t1038-1,t1036,1)-xy_tempsave(t1+t1038-1,t1036
     .       3            -1+t3))                                               
     .                 xyr_radldwflux(t1038-1,t1036,k) = xyr_radldwflux(t1038-1,
     .       1            t1036,k) + xyra_delradldwflux(t1038-1,t1036,k,1)*(    
     .       2            xyz_temp(t1038-1,t1036,1)-xy_tempsave(t1+t1038-1,t1036
     .       3            -1+t3))                                               
     .                 xyra_delradluwflux(t1038-1,t1036,k,1) =                  
     .       1            xyra_delradluwflux(t1038-1,t1036,k,1)/(xy_tempsave(t1+
     .       2            t1038-1,t1036-1+t3)**3)*(xyz_temp(t1038-1,t1036,1)**3)
     .                 xyra_delradldwflux(t1038-1,t1036,k,1) =                  
     .       1            xyra_delradldwflux(t1038-1,t1036,k,1)/(xy_tempsave(t1+
     .       2            t1038-1,t1036-1+t3)**3)*(xyz_temp(t1038-1,t1036,1)**3)
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t1036 = j3 + 1, jmax, 4                                     
     .  !cdir       nodep                                                       
     .  !cdir       on_adb(xyz_temp,xy_tempsave)                                
     .              do t1038 = 1, imax                                          
     .                 xyr_radluwflux(t1038-1,t1036,k) = xyr_radluwflux(t1038-1,
     .       1            t1036,k) + xyra_delradluwflux(t1038-1,t1036,k,1)*(    
     .       2            xyz_temp(t1038-1,t1036,1)-xy_tempsave(t1+t1038-1,t1036
     .       3            -1+t3))                                               
     .                 xyr_radluwflux(t1038-1,t1036+1,k) = xyr_radluwflux(t1038-
     .       1            1,t1036+1,k) + xyra_delradluwflux(t1038-1,t1036+1,k,1)
     .       2            *(xyz_temp(t1038-1,t1036+1,1)-xy_tempsave(t1+t1038-1, 
     .       3            t1036+t3))                                            
     .                 xyr_radluwflux(t1038-1,t1036+2,k) = xyr_radluwflux(t1038-
     .       1            1,t1036+2,k) + xyra_delradluwflux(t1038-1,t1036+2,k,1)
     .       2            *(xyz_temp(t1038-1,t1036+2,1)-xy_tempsave(t1+t1038-1, 
     .       3            t1036+1+t3))                                          
     .                 xyr_radluwflux(t1038-1,t1036+3,k) = xyr_radluwflux(t1038-
     .       1            1,t1036+3,k) + xyra_delradluwflux(t1038-1,t1036+3,k,1)
     .       2            *(xyz_temp(t1038-1,t1036+3,1)-xy_tempsave(t1+t1038-1, 
     .       3            t1036+2+t3))                                          
     .                 xyr_radldwflux(t1038-1,t1036,k) = xyr_radldwflux(t1038-1,
     .       1            t1036,k) + xyra_delradldwflux(t1038-1,t1036,k,1)*(    
     .       2            xyz_temp(t1038-1,t1036,1)-xy_tempsave(t1+t1038-1,t1036
     .       3            -1+t3))                                               
     .                 xyr_radldwflux(t1038-1,t1036+1,k) = xyr_radldwflux(t1038-
     .       1            1,t1036+1,k) + xyra_delradldwflux(t1038-1,t1036+1,k,1)
     .       2            *(xyz_temp(t1038-1,t1036+1,1)-xy_tempsave(t1+t1038-1, 
     .       3            t1036+t3))                                            
     .                 xyr_radldwflux(t1038-1,t1036+2,k) = xyr_radldwflux(t1038-
     .       1            1,t1036+2,k) + xyra_delradldwflux(t1038-1,t1036+2,k,1)
     .       2            *(xyz_temp(t1038-1,t1036+2,1)-xy_tempsave(t1+t1038-1, 
     .       3            t1036+1+t3))                                          
     .                 xyr_radldwflux(t1038-1,t1036+3,k) = xyr_radldwflux(t1038-
     .       1            1,t1036+3,k) + xyra_delradldwflux(t1038-1,t1036+3,k,1)
     .       2            *(xyz_temp(t1038-1,t1036+3,1)-xy_tempsave(t1+t1038-1, 
     .       3            t1036+2+t3))                                          
     .                 xyra_delradluwflux(t1038-1,t1036,k,1) =                  
     .       1            xyra_delradluwflux(t1038-1,t1036,k,1)/(xy_tempsave(t1+
     .       2            t1038-1,t1036-1+t3)**3)*(xyz_temp(t1038-1,t1036,1)**3)
     .                 xyra_delradluwflux(t1038-1,t1036+1,k,1) =                
     .       1            xyra_delradluwflux(t1038-1,t1036+1,k,1)/(xy_tempsave( 
     .       2            t1+t1038-1,t1036+t3)**3)*(xyz_temp(t1038-1,t1036+1,1) 
     .       3            **3)                                                  
     .                 xyra_delradluwflux(t1038-1,t1036+2,k,1) =                
     .       1            xyra_delradluwflux(t1038-1,t1036+2,k,1)/(xy_tempsave( 
     .       2            t1+t1038-1,t1036+1+t3)**3)*(xyz_temp(t1038-1,t1036+2,1
     .       3            )**3)                                                 
     .                 xyra_delradluwflux(t1038-1,t1036+3,k,1) =                
     .       1            xyra_delradluwflux(t1038-1,t1036+3,k,1)/(xy_tempsave( 
     .       2            t1+t1038-1,t1036+2+t3)**3)*(xyz_temp(t1038-1,t1036+3,1
     .       3            )**3)                                                 
     .                 xyra_delradldwflux(t1038-1,t1036,k,1) =                  
     .       1            xyra_delradldwflux(t1038-1,t1036,k,1)/(xy_tempsave(t1+
     .       2            t1038-1,t1036-1+t3)**3)*(xyz_temp(t1038-1,t1036,1)**3)
     .                 xyra_delradldwflux(t1038-1,t1036+1,k,1) =                
     .       1            xyra_delradldwflux(t1038-1,t1036+1,k,1)/(xy_tempsave( 
     .       2            t1+t1038-1,t1036+t3)**3)*(xyz_temp(t1038-1,t1036+1,1) 
     .       3            **3)                                                  
     .                 xyra_delradldwflux(t1038-1,t1036+2,k,1) =                
     .       1            xyra_delradldwflux(t1038-1,t1036+2,k,1)/(xy_tempsave( 
     .       2            t1+t1038-1,t1036+1+t3)**3)*(xyz_temp(t1038-1,t1036+2,1
     .       3            )**3)                                                 
     .                 xyra_delradldwflux(t1038-1,t1036+3,k,1) =                
     .       1            xyra_delradldwflux(t1038-1,t1036+3,k,1)/(xy_tempsave( 
     .       2            t1+t1038-1,t1036+2+t3)**3)*(xyz_temp(t1038-1,t1036+3,1
     .       3            )**3)                                                 
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
   433              & + xyra_DelRadLUwFlux(:,:,k,1) * ( xyz_Temp(:,:,1) - xy_TempSave )
   434            xyr_RadLDwFlux(:,:,k) = xyr_RadLDwFlux(:,:,k) &
   435              & + xyra_DelRadLDwFlux(:,:,k,1) * ( xyz_Temp(:,:,1) - xy_TempSave )
   436  
   437            xyra_DelRadLUwFlux(:,:,k,1) = xyra_DelRadLUwFlux(:,:,k,1) &
   438              &     / ( xy_TempSave**3 ) * ( xyz_Temp(:,:,1)**3 )
   439            xyra_DelRadLDwFlux(:,:,k,1) = xyra_DelRadLDwFlux(:,:,k,1) &
   440              &     / ( xy_TempSave**3 ) * ( xyz_Temp(:,:,1)**3 )
   441          end do
   442        else
   443          flag_rst_input = .false.
   444          call DbgMessage( '%c: restart data is used. ', c1 = module_name )
   445        end if
   446  
   447      end if
   448  
   449  
   450  
   451      ! 短波 (日射) フラックスの算出
   452      ! Calculate short wave (insolation)
   453      !
   454      if ( ( TimeN - PrevTimeShort >= IntTimeShort ) .or. ( .not. Old_Flux_saved ) ) then
   455  
   456        if ( .not. Old_Flux_saved ) then
   457          PrevTimeShort = TimeN
   458        else
   459          PrevTimeShort = PrevTimeShort + IntTimeShort
   460        end if
   461  
   462        ! 短波入射の計算
   463        ! Calculate short wave (insolation) incoming radiation
   464        !
   465        call RadShortIncome(                       &
   466          & xy_CosZet         = xy_CosSZA,         & ! (out) optional
   467          & xy_InAngle        = xy_InAngle,        & ! (out) optional
   468          & DistFromStarScld  = DistFromStarScld,  &
   469          & DiurnalMeanFactor = DiurnalMeanFactor  &
   470          & )
   471  
   472  
   473        ! 短波フラックスの計算
   474        ! Calculate short wave (insolation) flux
   475        !
   476  
   477        do j = 1, jmax
   478          do i = 0, imax-1
   479            if ( xy_CosSZA(i,j) > 0.0_DP ) then
   480              xy_IncomRadSFlux(i,j) = SolarConst / DistFromStarScld**2 * xy_CosSZA(i,j)
   481            else
   482              xy_IncomRadSFlux(i,j) = 0.0_DP
   483            end if
   484          end do
   485        end do
     .        if (jmax .gt. 0) then                                             
     .           j4 = and(jmax,3)                                               
     .           do j = 1, j4                                                   
     .  !cdir       nodep                                                       
     .              do i = 1, imax                                              
     .                 if (xy_cossza(i-1,j) .gt. 0.0000000000000000e+000) then  
     .                    xy_incomradsflux3 = solarconst/distfromstarscld**2*   
     .       1               xy_cossza(i-1,j)                                   
     .                 else                                                     
     .                    xy_incomradsflux3 = 0.0000000000000000e+000           
     .                 endif                                                    
     .                 xy_incomradsflux(i-1,j) = xy_incomradsflux3              
     .              enddo                                                       
     .           enddo                                                          
     .           do j = j4 + 1, jmax, 4                                         
     .  !cdir       nodep                                                       
     .              do i = 1, imax                                              
     .                 if (xy_cossza(i-1,j) .gt. 0.0000000000000000e+000) then  
     .                    xy_incomradsflux4 = solarconst/distfromstarscld**2*   
     .       1               xy_cossza(i-1,j)                                   
     .                 else                                                     
     .                    xy_incomradsflux4 = 0.0000000000000000e+000           
     .                 endif                                                    
     .                 xy_incomradsflux(i-1,j) = xy_incomradsflux4              
     .                 if (xy_cossza(i-1,j+1) .gt. 0.0000000000000000e+000) then
     .                    xy_incomradsflux5 = solarconst/distfromstarscld**2*   
     .       1               xy_cossza(i-1,j+1)                                 
     .                 else                                                     
     .                    xy_incomradsflux5 = 0.0000000000000000e+000           
     .                 endif                                                    
     .                 xy_incomradsflux(i-1,j+1) = xy_incomradsflux5            
     .                 if (xy_cossza(i-1,j+2) .gt. 0.0000000000000000e+000) then
     .                    xy_incomradsflux6 = solarconst/distfromstarscld**2*   
     .       1               xy_cossza(i-1,j+2)                                 
     .                 else                                                     
     .                    xy_incomradsflux6 = 0.0000000000000000e+000           
     .                 endif                                                    
     .                 xy_incomradsflux(i-1,j+2) = xy_incomradsflux6            
     .                 if (xy_cossza(i-1,j+3) .gt. 0.0000000000000000e+000) then
     .                    xy_incomradsflux7 = solarconst/distfromstarscld**2*   
     .       1               xy_cossza(i-1,j+3)                                 
     .                 else                                                     
     .                    xy_incomradsflux7 = 0.0000000000000000e+000           
     .                 endif                                                    
     .                 xy_incomradsflux(i-1,j+3) = xy_incomradsflux7            
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
   486        ! Correction of incoming solar flux when diurnal mean insolation is assumed.
   487        ! If diurnal mean insolation is assumed, DiurnalMeanFactor = 1 / PI.
   488        ! If diurnal mean insolation is not assumed, DiurnalMeanFactor = 1.
   489        xy_IncomRadSFlux = xy_IncomRadSFlux * DiurnalMeanFactor
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1024 = 1, (xy_incomradsflux.DSC.U2 + 1 -                      
     .       1   xy_incomradsflux.DSC.L2)*(xy_incomradsflux.DSC.U1 + 1 -        
     .       2   xy_incomradsflux.DSC.L1)                                       
     .           xy_incomradsflux(xy_incomradsflux.DSC.L1+t1024-1,              
     .       1      xy_incomradsflux.DSC.L2) = xy_incomradsflux(                
     .       2      xy_incomradsflux.DSC.L1+t1024-1,xy_incomradsflux.DSC.L2)*   
     .       3      diurnalmeanfactor                                           
     .           xy_incomradsflux(xy_incomradsflux.DSC.L1+t1024-1,              
     .       1      xy_incomradsflux.DSC.L2) = xy_incomradsflux(                
     .       2      xy_incomradsflux.DSC.L1+t1024-1,xy_incomradsflux.DSC.L2)*(  
     .       3      1.00000000000000e+000 - shortatmosalbedo)                   
     .        enddo                                                             
   490  
   491  
   492        ! 大気アルベドの考慮
   493        ! Taking atmospheric albedo into consideration
   494        !
   495        xy_IncomRadSFlux = xy_IncomRadSFlux * ( 1.0d0 - ShortAtmosAlbedo )
   496  
   497  
   498        call ShortFlux(                                      &
   499          & xyr_ColDenQVap, xyr_ColDenDryAir, xy_SurfAlbedo, & ! (in)
   500          & xy_IncomRadSFlux,                                & ! (in)
   501          & xyr_RadSUwFlux, xyr_RadSDwFlux                   & ! (out)
   502          & )
   503  
   504  
   505      else
   506        ! 前回の値を利用
   507        ! Use values in last time
   508  
   509        xyr_RadSUwFlux = xyr_RadSUwFluxSave
     .        if (jmax .gt. 0) then                                             
     .           j5 = and(jmax,3)                                               
     .  !cdir    nodep                                                          
     .           do t946 = 1, j5                                                
     .  !cdir       nodep                                                       
     .              do t948 = 1, imax                                           
     .                 xyr_radsuwflux(t948-1,t946,t944) = xyr_radsuwfluxsave(t86
     .       1            +t948-1,t946-1+t88,t944+t90)                          
     .                 xyr_radsdwflux(t948-1,t946,t944) = xyr_radsdwfluxsave(t75
     .       1            +t948-1,t946-1+t77,t944+t79)                          
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t946 = j5 + 1, jmax, 4                                      
     .  !cdir       nodep                                                       
     .              do t948 = 1, imax                                           
     .                 xyr_radsuwflux(t948-1,t946,t944) = xyr_radsuwfluxsave(t86
     .       1            +t948-1,t946-1+t88,t944+t90)                          
     .                 xyr_radsuwflux(t948-1,t946+1,t944) = xyr_radsuwfluxsave( 
     .       1            t86+t948-1,t946+t88,t944+t90)                         
     .                 xyr_radsuwflux(t948-1,t946+2,t944) = xyr_radsuwfluxsave( 
     .       1            t86+t948-1,t946+1+t88,t944+t90)                       
     .                 xyr_radsuwflux(t948-1,t946+3,t944) = xyr_radsuwfluxsave( 
     .       1            t86+t948-1,t946+2+t88,t944+t90)                       
     .                 xyr_radsdwflux(t948-1,t946,t944) = xyr_radsdwfluxsave(t75
     .       1            +t948-1,t946-1+t77,t944+t79)                          
     .                 xyr_radsdwflux(t948-1,t946+1,t944) = xyr_radsdwfluxsave( 
     .       1            t75+t948-1,t946+t77,t944+t79)                         
     .                 xyr_radsdwflux(t948-1,t946+2,t944) = xyr_radsdwfluxsave( 
     .       1            t75+t948-1,t946+1+t77,t944+t79)                       
     .                 xyr_radsdwflux(t948-1,t946+3,t944) = xyr_radsdwfluxsave( 
     .       1            t75+t948-1,t946+2+t77,t944+t79)                       
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
   510        xyr_RadSDwFlux = xyr_RadSDwFluxSave
   511      end if
   512  
   513  
   514  
   515      ! 今回計算した値を保存
   516      ! Save calculated values in this time
   517      !
   518      xy_TempSave            = xyz_Temp (:,:,1)
     .        if (xy_tempsave.DSC.U2 + 1 - xy_tempsave.DSC.L2 .gt. 0) then      
     .           j6 = and(xy_tempsave.DSC.U2 + 1 - xy_tempsave.DSC.L2,3)        
     .  !cdir    nodep                                                          
     .           do t962 = 1, j6                                                
     .  !cdir       nodep                                                       
     .  !cdir       on_adb(xyz_temp)                                            
     .              do t964 = 1, xy_tempsave.DSC.U1 + 1 - xy_tempsave.DSC.L1    
     .                 xy_tempsave(t1+t964-1,t962-1+t3)=xyz_temp(t964-1,t962,1) 
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t962=j6+1,xy_tempsave.DSC.U2+1-xy_tempsave.DSC.L2,4         
     .  !cdir       nodep                                                       
     .  !cdir       on_adb(xyz_temp)                                            
     .              do t964 = 1, xy_tempsave.DSC.U1 + 1 - xy_tempsave.DSC.L1    
     .                 xy_tempsave(t1+t964-1,t962-1+t3)=xyz_temp(t964-1,t962,1) 
     .                 xy_tempsave(t1+t964-1,t962+t3)=xyz_temp(t964-1,t962+1,1) 
     .                 xy_tempsave(t1+t964-1,t962+1+t3) = xyz_temp(t964-1,t962+2
     .       1            ,1)                                                   
     .                 xy_tempsave(t1+t964-1,t962+2+t3) = xyz_temp(t964-1,t962+3
     .       1            ,1)                                                   
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
   519  
   520      xyr_RadSUwFluxSave     = xyr_RadSUwFlux
     .        if (xyr_radsuwfluxsave.DSC.U2 + 1 - xyr_radsuwfluxsave.DSC.L2 .gt.
     .       1    0) then                                                       
     .           j7 = and(xyr_radsuwfluxsave.DSC.U2 + 1 -                       
     .       1      xyr_radsuwfluxsave.DSC.L2,3)                                
     .  !cdir    nodep                                                          
     .           do t972 = 1, j7                                                
     .  !cdir       nodep                                                       
     .              do t974 = 1, xyr_radsuwfluxsave.DSC.U1 + 1 -                
     .       1         xyr_radsuwfluxsave.DSC.L1                                
     .                 xyr_radsuwfluxsave(t86+t974-1,t972-1+t88,t970+t90) =     
     .       1            xyr_radsuwflux(t974-1,t972,t970)                      
     .                 xyr_radsdwfluxsave(t75+t974-1,t972-1+t77,t970+t79) =     
     .       1            xyr_radsdwflux(t974-1,t972,t970)                      
     .                 xyr_radluwfluxsave(t64+t974-1,t972-1+t66,t970+t68) =     
     .       1            xyr_radluwflux(t974-1,t972,t970)                      
     .                 xyr_radldwfluxsave(t53+t974-1,t972-1+t55,t970+t57) =     
     .       1            xyr_radldwflux(t974-1,t972,t970)                      
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t972 = j7 + 1, xyr_radsuwfluxsave.DSC.U2 + 1 -              
     .       1      xyr_radsuwfluxsave.DSC.L2, 4                                
     .  !cdir       nodep                                                       
     .              do t974 = 1, xyr_radsuwfluxsave.DSC.U1 + 1 -                
     .       1         xyr_radsuwfluxsave.DSC.L1                                
     .                 xyr_radsuwfluxsave(t86+t974-1,t972-1+t88,t970+t90) =     
     .       1            xyr_radsuwflux(t974-1,t972,t970)                      
     .                 xyr_radsuwfluxsave(t86+t974-1,t972+t88,t970+t90) =       
     .       1            xyr_radsuwflux(t974-1,t972+1,t970)                    
     .                 xyr_radsuwfluxsave(t86+t974-1,t972+1+t88,t970+t90) =     
     .       1            xyr_radsuwflux(t974-1,t972+2,t970)                    
     .                 xyr_radsuwfluxsave(t86+t974-1,t972+2+t88,t970+t90) =     
     .       1            xyr_radsuwflux(t974-1,t972+3,t970)                    
     .                 xyr_radsdwfluxsave(t75+t974-1,t972-1+t77,t970+t79) =     
     .       1            xyr_radsdwflux(t974-1,t972,t970)                      
     .                 xyr_radsdwfluxsave(t75+t974-1,t972+t77,t970+t79) =       
     .       1            xyr_radsdwflux(t974-1,t972+1,t970)                    
     .                 xyr_radsdwfluxsave(t75+t974-1,t972+1+t77,t970+t79) =     
     .       1            xyr_radsdwflux(t974-1,t972+2,t970)                    
     .                 xyr_radsdwfluxsave(t75+t974-1,t972+2+t77,t970+t79) =     
     .       1            xyr_radsdwflux(t974-1,t972+3,t970)                    
     .                 xyr_radluwfluxsave(t64+t974-1,t972-1+t66,t970+t68) =     
     .       1            xyr_radluwflux(t974-1,t972,t970)                      
     .                 xyr_radluwfluxsave(t64+t974-1,t972+t66,t970+t68) =       
     .       1            xyr_radluwflux(t974-1,t972+1,t970)                    
     .                 xyr_radluwfluxsave(t64+t974-1,t972+1+t66,t970+t68) =     
     .       1            xyr_radluwflux(t974-1,t972+2,t970)                    
     .                 xyr_radluwfluxsave(t64+t974-1,t972+2+t66,t970+t68) =     
     .       1            xyr_radluwflux(t974-1,t972+3,t970)                    
     .                 xyr_radldwfluxsave(t53+t974-1,t972-1+t55,t970+t57) =     
     .       1            xyr_radldwflux(t974-1,t972,t970)                      
     .                 xyr_radldwfluxsave(t53+t974-1,t972+t55,t970+t57) =       
     .       1            xyr_radldwflux(t974-1,t972+1,t970)                    
     .                 xyr_radldwfluxsave(t53+t974-1,t972+1+t55,t970+t57) =     
     .       1            xyr_radldwflux(t974-1,t972+2,t970)                    
     .                 xyr_radldwfluxsave(t53+t974-1,t972+2+t55,t970+t57) =     
     .       1            xyr_radldwflux(t974-1,t972+3,t970)                    
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
   521      xyr_RadSDwFluxSave     = xyr_RadSDwFlux
   522  
   523      xyr_RadLUwFluxSave     = xyr_RadLUwFlux
   524      xyr_RadLDwFluxSave     = xyr_RadLDwFlux
   525      xyra_DelRadLUwFluxSave = xyra_DelRadLUwFlux
     .  !cdir nodep                                                             
     .        do t1002 = 0, xyra_delradluwfluxsave.DSC.U3 -                     
     .       1   xyra_delradluwfluxsave.DSC.L3                                  
     .           if (xyra_delradluwfluxsave.DSC.U2 + 1 -                        
     .       1      xyra_delradluwfluxsave.DSC.L2 .gt. 0) then                  
     .              j8 = and(xyra_delradluwfluxsave.DSC.U2 + 1 -                
     .       1         xyra_delradluwfluxsave.DSC.L2,3)                         
     .  !cdir       nodep                                                       
     .              do t1004 = 1, j8                                            
     .  !cdir          nodep                                                    
     .                 do t1006 = 1, xyra_delradluwfluxsave.DSC.U1 + 1 -        
     .       1            xyra_delradluwfluxsave.DSC.L1                         
     .                    xyra_delradluwfluxsave(t23+t1006-1,t1004-1+t25,t1002+ 
     .       1               t27,t29) = xyra_delradluwflux(t1006-1,t1004,t1002,0
     .       2               )                                                  
     .                    xyra_delradldwfluxsave(t9+t1006-1,t1004-1+t11,t1002+  
     .       1               t13,t15) = xyra_delradldwflux(t1006-1,t1004,t1002,0
     .       2               )                                                  
     .                    xyra_delradluwfluxsave(t23+t1006-1,t1004-1+t25,t1002+ 
     .       1               t27,1+t29) = xyra_delradluwflux(t1006-1,t1004,t1002
     .       2               ,1)                                                
     .                    xyra_delradldwfluxsave(t9+t1006-1,t1004-1+t11,t1002+  
     .       1               t13,1+t15) = xyra_delradldwflux(t1006-1,t1004,t1002
     .       2               ,1)                                                
     .                 enddo                                                    
     .              enddo                                                       
     .  !cdir       nodep                                                       
     .              do t1004 = j8 + 1, xyra_delradluwfluxsave.DSC.U2 + 1 -      
     .       1         xyra_delradluwfluxsave.DSC.L2, 4                         
     .  !cdir          nodep                                                    
     .                 do t1006 = 1, xyra_delradluwfluxsave.DSC.U1 + 1 -        
     .       1            xyra_delradluwfluxsave.DSC.L1                         
     .                    xyra_delradluwfluxsave(t23+t1006-1,t1004-1+t25,t1002+ 
     .       1               t27,t29) = xyra_delradluwflux(t1006-1,t1004,t1002,0
     .       2               )                                                  
     .                    xyra_delradluwfluxsave(t23+t1006-1,t1004+t25,t1002+t27
     .       1               ,t29) = xyra_delradluwflux(t1006-1,t1004+1,t1002,0)
     .                    xyra_delradluwfluxsave(t23+t1006-1,t1004+1+t25,t1002+ 
     .       1               t27,t29) = xyra_delradluwflux(t1006-1,t1004+2,t1002
     .       2               ,0)                                                
     .                    xyra_delradluwfluxsave(t23+t1006-1,t1004+2+t25,t1002+ 
     .       1               t27,t29) = xyra_delradluwflux(t1006-1,t1004+3,t1002
     .       2               ,0)                                                
     .                    xyra_delradldwfluxsave(t9+t1006-1,t1004-1+t11,t1002+  
     .       1               t13,t15) = xyra_delradldwflux(t1006-1,t1004,t1002,0
     .       2               )                                                  
     .                    xyra_delradldwfluxsave(t9+t1006-1,t1004+t11,t1002+t13,
     .       1               t15) = xyra_delradldwflux(t1006-1,t1004+1,t1002,0) 
     .                    xyra_delradldwfluxsave(t9+t1006-1,t1004+1+t11,t1002+  
     .       1               t13,t15) = xyra_delradldwflux(t1006-1,t1004+2,t1002
     .       2               ,0)                                                
     .                    xyra_delradldwfluxsave(t9+t1006-1,t1004+2+t11,t1002+  
     .       1               t13,t15) = xyra_delradldwflux(t1006-1,t1004+3,t1002
     .       2               ,0)                                                
     .                    xyra_delradluwfluxsave(t23+t1006-1,t1004-1+t25,t1002+ 
     .       1               t27,1+t29) = xyra_delradluwflux(t1006-1,t1004,t1002
     .       2               ,1)                                                
     .                    xyra_delradluwfluxsave(t23+t1006-1,t1004+t25,t1002+t27
     .       1               ,1+t29) = xyra_delradluwflux(t1006-1,t1004+1,t1002,
     .       2               1)                                                 
     .                    xyra_delradluwfluxsave(t23+t1006-1,t1004+1+t25,t1002+ 
     .       1               t27,1+t29) = xyra_delradluwflux(t1006-1,t1004+2,   
     .       2               t1002,1)                                           
     .                    xyra_delradluwfluxsave(t23+t1006-1,t1004+2+t25,t1002+ 
     .       1               t27,1+t29) = xyra_delradluwflux(t1006-1,t1004+3,   
     .       2               t1002,1)                                           
     .                    xyra_delradldwfluxsave(t9+t1006-1,t1004-1+t11,t1002+  
     .       1               t13,1+t15) = xyra_delradldwflux(t1006-1,t1004,t1002
     .       2               ,1)                                                
     .                    xyra_delradldwfluxsave(t9+t1006-1,t1004+t11,t1002+t13,
     .       1               1+t15) = xyra_delradldwflux(t1006-1,t1004+1,t1002,1
     .       2               )                                                  
     .                    xyra_delradldwfluxsave(t9+t1006-1,t1004+1+t11,t1002+  
     .       1               t13,1+t15) = xyra_delradldwflux(t1006-1,t1004+2,   
     .       2               t1002,1)                                           
     .                    xyra_delradldwfluxsave(t9+t1006-1,t1004+2+t11,t1002+  
     .       1               t13,1+t15) = xyra_delradldwflux(t1006-1,t1004+3,   
     .       2               t1002,1)                                           
     .                 enddo                                                    
     .              enddo                                                       
     .           endif                                                          
     .        enddo                                                             
   526      xyra_DelRadLDwFluxSave = xyra_DelRadLDwFlux
   527  
   528      if ( .not. Old_Flux_saved ) Old_Flux_saved = .true.
   529  
   530      ! リスタートファイルの出力タイミングのチェック
   531      ! Check output timing of a restart file
   532      !
   533  !!
   534  !! old code to be deleted
   535  !!
   536  !    flag_rst_output = ( TimeN - PrevRstOutputTime >= RstFileIntTime )
   537  !    if ( TimeN >= EndTime .and. .not. flag_rst_output_end ) then
   538  !      flag_rst_output = .true.
   539  !      flag_rst_output_end = .true.
   540  !    end if
   541  !    flag_rst_output = ( .not. TimeN == PrevRstOutputTime ) .and. flag_rst_output
   542  
   543  
   544      if ( TimeN - PrevRstOutputTime >= RstFileIntTime ) then
   545         flag_rst_output = .true.
   546      else
   547         flag_rst_output = .false.
   548      end if
   549      if ( TimeN >= EndTime .and. .not. flag_rst_output_end ) then
   550        flag_rst_output = .true.
   551        flag_rst_output_end = .true.
   552      end if
   553      if ( ( .not. TimeN == PrevRstOutputTime ) .and. flag_rst_output ) then
   554         flag_rst_output = .true.
   555      else
   556         flag_rst_output = .false.
   557      end if
   558  
   559  
   560      if ( flag_rst_output ) then
   561        ! 次回用に, 今回の出力 (希望) 時刻 を保存
   562        ! Save output time (expected) in this time, for next time
   563        !
   564        PrevRstOutputTime = PrevRstOutputTime + RstFileIntTime
   565  
   566        ! 時刻の設定
   567        ! Set time
   568        !
   569        call HistorySetTime( timed = TimeN, history = gthst_rst )
   570  
   571        ! データ出力
   572        ! Data output
   573        !
   574        call HistoryPut( &
   575          & 'PrevTimeLong', PrevTimeLong, & ! (in)
   576          & history = gthst_rst ) ! (in)
   577        call HistoryPut( &
   578          & 'PrevTimeShort', PrevTimeShort, & ! (in)
   579          & history = gthst_rst ) ! (in)
   580        call HistoryPut( &
   581          & 'SurfTemp', xy_TempSave, history = gthst_rst ) ! (in)
   582        call HistoryPut( &
   583          & 'RadLUwFlux', xyr_RadLUwFluxSave, history = gthst_rst ) ! (in)
   584        call HistoryPut( &
   585          & 'RadLDwFlux', xyr_RadLDwFluxSave, history = gthst_rst ) ! (in)
   586        call HistoryPut( &
   587          & 'RadSUwFlux', xyr_RadSUwFluxSave, history = gthst_rst ) ! (in)
   588        call HistoryPut( &
   589          & 'RadSDwFlux', xyr_RadSDwFluxSave, history = gthst_rst ) ! (in)
   590        call HistoryPut( &
   591          & 'DelRadLUwFlux', xyra_DelRadLUwFluxSave, history = gthst_rst ) ! (in)
   592        call HistoryPut( &
   593          & 'DelRadLDwFlux', xyra_DelRadLDwFluxSave, history = gthst_rst ) ! (in)
   594  
   595      end if
   596  
   597      ! 計算時間計測一時停止
   598      ! Pause measurement of computation time
   599      !
   600      call TimesetClockStop( module_name )
   601  
   602    end subroutine RadDennouAGCMFlux
   603  
   604    !--------------------------------------------------------------------------------------
   605  
   606    subroutine LongFlux( &
   607      & xyz_Temp, xy_SurfTemp, xyr_ColDenQVap, xyr_ColDenDryAir,                & ! (in)
   608      & xyr_RadLUwFlux, xyr_RadLDwFlux, xyra_DelRadLUwFlux, xyra_DelRadLDwFlux  & ! (out)
   609      & )
   610      !
   611      ! 長波フラックスの計算
   612      !
   613      ! Calculate long wave flux
   614      !
   615  
   616      ! モジュール引用 ; USE statements
   617      !
   618  
   619      ! 物理・数学定数設定
   620      ! Physical and mathematical constants settings
   621      !
   622      use constants0, only: &
   623        & StB                   ! $ \sigma_{SB} $ .
   624                                ! ステファンボルツマン定数.
   625                                ! Stefan-Boltzmann constant
   626  
   627      ! 散乱を無視した放射伝達方程式
   628      ! Radiative transfer equation without considering scattering
   629      !
   630      use rad_rte_nonscat, only : RadRTENonScat
   631  
   632  
   633      ! 宣言文 ; Declaration statements
   634      !
   635      implicit none
   636      real(DP), intent(in):: xyz_Temp (0:imax-1, 1:jmax, 1:kmax)
   637                                ! $ T $ .     温度. Temperature
   638  
   639      real(DP), intent(in):: xy_SurfTemp (0:imax-1, 1:jmax)
   640                                ! 地表面温度.
   641                                ! Surface temperature
   642      real(DP), intent(in):: xyr_ColDenQVap (0:imax-1, 1:jmax, 0:kmax)
   643                                ! $ \int_z^{\infty} \rho q \, dz $ .
   644                                ! 鉛直層 k より上空の水蒸気のカラム密度.
   645                                ! Column density of water vapor above vertical level k.
   646      real(DP), intent(in):: xyr_ColDenDryAir (0:imax-1, 1:jmax, 0:kmax)
   647                                ! $ \int_z^{\infty} \rho \, dz $ .
   648                                ! 鉛直層 k より上空の空気のカラム密度.
   649                                ! Column density of air above vertical level k.
   650      real(DP), intent(out):: xyr_RadLUwFlux (0:imax-1, 1:jmax, 0:kmax)
   651                                ! 長波フラックス.
   652                                ! Upward longwave flux
   653      real(DP), intent(out):: xyr_RadLDwFlux (0:imax-1, 1:jmax, 0:kmax)
   654                                ! 長波フラックス.
   655                                ! Downward longwave flux
   656      real(DP), intent(out):: xyra_DelRadLUwFlux (0:imax-1, 1:jmax, 0:kmax, 0:1)
   657                                ! 長波地表温度変化.
   658                                !
   659      real(DP), intent(out):: xyra_DelRadLDwFlux (0:imax-1, 1:jmax, 0:kmax, 0:1)
   660                                ! 長波地表温度変化.
   661                                !
   662  
   663      ! 作業変数
   664      ! Work variables
   665      !
   666      real(DP):: xyrr_Trans(0:imax-1, 1:jmax, 0:kmax, 0:kmax)
   667                                ! 透過係数.
   668                                ! Transmission coefficient
   669      real(DP):: xyz_PiB (0:imax-1, 1:jmax, 1:kmax)
   670                                ! $ \pi B = \sigma T^{4} $
   671      real(DP):: xy_SurfPiB (0:imax-1, 1:jmax)
   672                                ! 地表面の $ \pi B $ .
   673                                ! $ \pi B $ on surface
   674      real(DP):: xy_PiDBDT1    (0:imax-1, 1:jmax)
   675                                ! $ \pi DBDT = 4 \sigma T^{3} at lowest level$
   676      real(DP):: xy_SurfPiDBDT (0:imax-1, 1:jmax)
   677                                ! 地表面の $ \pi DBDT $ .
   678                                ! $ \pi B $ on surface
   679  
   680      real(DP):: BandWeightSum  ! バンドウェイトの和
   681                                ! Sum of band weights
   682  
   683      integer:: k, kk           ! 鉛直方向に回る DO ループ用作業変数
   684                                ! Work variables for DO loop in vertical direction
   685      integer:: bn              ! 波長について回る DO ループ用作業変数
   686                                ! Work variables for DO loop in wavenumber bands
   687  
   688      ! 実行文 ; Executable statement
   689      !
   690  
   691  
   692      ! 透過関数計算
   693      ! Calculate transmission functions
   694      !
   695      !   Initialization
   696      !
   697      xyrr_Trans = 0.
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t303 = 1, (xyrr_trans.DSC.U4 + 1)*(xyrr_trans.DSC.U3 + 1)*     
     .       1   xyrr_trans.DSC.U2*(xyrr_trans.DSC.U1 + 1)                      
     .           xyrr_trans(t303-1,1,0,0) = 0.0000000000000000e+000             
     .        enddo                                                             
   698      !
   699      do bn = 1, LongBandNum
   700  
   701        do k = 0, kmax
   702          do kk = k, kmax
   703            xyrr_Trans(:,:,k,kk) = &
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xyrr_trans,xyr_coldenqvap,xyr_coldendryair)                
     .        do t315 = 1, jmax*imax                                            
     .           xyrr_trans(t315-1,1,k,kk) = xyrr_trans(t315-1,1,k,kk) +        
     .       1      longbandweight(bn)*dexp((-longpathlengthfact*(              
     .       2      longabsorpcoefqvap(bn)*abs(xyr_coldenqvap(t315-1,1,kk)-     
     .       3      xyr_coldenqvap(t315-1,1,k))+longabsorpcoefdryair(bn)*abs(   
     .       4      xyr_coldendryair(t315-1,1,kk)-xyr_coldendryair(t315-1,1,k)))
     .       5      ))                                                          
     .        enddo                                                             
   704              &   xyrr_Trans(:,:,k,kk) &
   705              & + LongBandWeight(bn) &
   706              &   * exp( - LongPathLengthFact &
   707              &            * (   LongAbsorpCoefQVap(bn) &
   708              &                  * abs(   xyr_ColDenQVap(:,:,kk) &
   709              &                         - xyr_ColDenQVap(:,:,k)  ) &
   710              &                + LongAbsorpCoefDryAir(bn) &
   711              &                  * abs(   xyr_ColDenDryAir(:,:,kk) &
   712              &                         - xyr_ColDenDryAir(:,:,k)  ) ) )
   713          end do
   714        end do
   715  
   716      end do
   717  
   718      do k = 0, kmax
   719        do kk = 0, k-1
   720          xyrr_Trans(:,:,k,kk) = xyrr_Trans(:,:,kk,k)
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xyrr_trans)                                                
     .        do t331 = 1, xyrr_trans.DSC.U2*xyrr_trans.DSC.U1 +                
     .       1   xyrr_trans.DSC.U2                                              
     .           xyrr_trans(t331-1,1,k,kk) = xyrr_trans(t331-1,1,kk,k)          
     .        enddo                                                             
   721        end do
   722      end do
   723  
   724  
   725      ! $ \pi B $, $ \pi DBDT $ の計算
   726      ! Calculate $ \pi B $ and $ \pi DBDT $
   727      !
   728      xyz_PiB       = StB * ( xyz_Temp**4 )
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t339 = 1, kmax*jmax*imax                                       
     .           xyz_pib(t339-1,1,1) = 5.67037300000000e-008*xyz_temp(t339-1,1,1
     .       1      )**4                                                        
     .        enddo                                                             
   729      xy_SurfPiB    = StB * ( xy_SurfTemp**4 )
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t351 = 1, jmax*imax                                            
     .           xy_surfpib(t351-1,1) = 5.67037300000000e-008*xy_surftemp(t351-1
     .       1      ,1)**4                                                      
     .           xy_pidbdt1(t351-1,1) = 4.00000000000000e+000*xyz_pib(t351-1,1,1
     .       1      )/xyz_temp(t351-1,1,1)                                      
     .           xy_surfpidbdt(t351-1,1) = 4.00000000000000e+000*xy_surfpib(t351
     .       1      -1,1)/xy_surftemp(t351-1,1)                                 
     .        enddo                                                             
   730      xy_PiDBDT1    = 4.0_DP * xyz_PiB(:,:,1) / xyz_Temp(:,:,1)
   731      xy_SurfPiDBDT = 4.0_DP * xy_SurfPiB / xy_SurfTemp
   732  
   733  
   734  
   735      call RadRTENonScat(                                 &
   736        & xyz_PiB, xy_SurfPiB, xy_PiDBDT1, xy_SurfPiDBDT, & ! (in)
   737        & xyrr_Trans,                                     & ! (in)
   738        & xyr_RadLUwFlux, xyr_RadLDwFlux,                 & ! (out)
   739        & xyra_DelRadLUwFlux, xyra_DelRadLDwFlux          & ! (out)
   740        & )
   741  
   742  
   743    end subroutine LongFlux
   744  
   745    !--------------------------------------------------------------------------------------
   746  
   747    subroutine ShortFlux(                                &
   748      & xyr_ColDenQVap, xyr_ColDenDryAir, xy_SurfAlbedo, & ! (in)
   749      & xy_TOARadSDwFlux,                                & ! (in)
   750      & xyr_RadSUwFlux, xyr_RadSDwFlux                   & ! (out)
   751      & )
   752      !
   753      ! 短波フラックスを計算します.
   754      !
   755      ! Calculate short wave flux.
   756      !
   757  
   758      ! モジュール引用 ; USE statements
   759      !
   760  
   761      ! 宣言文 ; Declaration statements
   762      !
   763      implicit none
   764  
   765      real(DP), intent(in):: xyr_ColDenQVap (0:imax-1, 1:jmax, 0:kmax)
   766                                ! $ \int_z^{\infty} \rho q \, dz $ .
   767                                ! 鉛直層 k より上空の水蒸気のカラム密度.
   768                                ! Column density of water vapor above vertical level k.
   769      real(DP), intent(in):: xyr_ColDenDryAir (0:imax-1, 1:jmax, 0:kmax)
   770                                ! $ \int_z^{\infty} \rho \, dz $ .
   771                                ! 鉛直層 k より上空の空気のカラム密度.
   772                                ! Column density of air above vertical level k.
   773      real(DP), intent(in):: xy_SurfAlbedo (0:imax-1, 1:jmax)
   774                                ! 地表アルベド.
   775                                ! Surface albedo
   776      real(DP), intent(in):: xy_TOARadSDwFlux (0:imax-1, 1:jmax)
   777                                ! 短波 (日射) フラックス.
   778                                ! Shortwave (insolation) flux at the top of the atmosphere
   779      real(DP), intent(out):: xyr_RadSUwFlux (0:imax-1, 1:jmax, 0:kmax)
   780                                ! 短波 (日射) フラックス.
   781                                ! Upward shortwave (insolation) flux
   782      real(DP), intent(out):: xyr_RadSDwFlux (0:imax-1, 1:jmax, 0:kmax)
   783                                ! 短波 (日射) フラックス.
   784                                ! Downward shortwave (insolation) flux
   785  
   786      ! 作業変数
   787      ! Work variables
   788      !
   789      real(DP) :: xyr_TransForDwFlux(0:imax-1, 1:jmax, 0:kmax)
   790                                !
   791                                ! Transmittance from level k to top of the atmosphere
   792      real(DP) :: xyr_TransForUwFlux(0:imax-1, 1:jmax, 0:kmax)
   793                                !
   794                                ! Transmittance from surface to level k
   795      integer:: k               ! 鉛直方向に回る DO ループ用作業変数
   796                                ! Work variables for DO loop in vertical direction
   797      integer:: bn              ! 波長について回る DO ループ用作業変数
   798                                ! Work variables for DO loop in wavenumber bands
   799  
   800      ! 実行文 ; Executable statement
   801      !
   802  
   803      xyr_TransForDwFlux = 0.0_DP
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t271 = 1, (xyr_transfordwflux.DSC.U3 + 1)*                     
     .       1   xyr_transfordwflux.DSC.U2*(xyr_transfordwflux.DSC.U1 + 1)      
     .           xyr_transfordwflux(t271-1,1,0) = 0.0000000000000000e+000       
     .        enddo                                                             
   804      do k = 0, kmax
   805        do bn = 1, ShortBandNum
   806          xyr_TransForDwFlux(:,:,k) = xyr_TransForDwFlux(:,:,k)                      &
     .        if (xy_inangle.DSC.U2 + 1 - xy_inangle.DSC.L2 .gt. 0) then        
     .           j1 = and(xy_inangle.DSC.U2 + 1 - xy_inangle.DSC.L2,3)          
     .  !cdir    nodep                                                          
     .           do t280 = 1, j1                                                
     .  !cdir       nodep                                                       
     .  !cdir       on_adb(xyr_transfordwflux,xy_inangle,xyr_coldenqvap,xyr_cold
     .       1         endryair)                                                
     .              do t282 = 1, xy_inangle.DSC.U1 + 1 - xy_inangle.DSC.L1      
     .                 xyr_transfordwflux(t282-1,t280,k) = xyr_transfordwflux(  
     .       1            t282-1,t280,k) + shortbandweight(bn)*dexp((-xy_inangle
     .       2            (t4+t282-1,t280-1+t6)*(shortabsorpcoefqvap(bn)*       
     .       3            xyr_coldenqvap(t282-1,t280,k)+shortabsorpcoefdryair(bn
     .       4            )*xyr_coldendryair(t282-1,t280,k))))                  
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t280 = j1 + 1, xy_inangle.DSC.U2 + 1 - xy_inangle.DSC.L2, 4 
     .  !cdir       nodep                                                       
     .  !cdir       on_adb(xyr_transfordwflux,xy_inangle,xyr_coldenqvap,xyr_cold
     .       1         endryair)                                                
     .              do t282 = 1, xy_inangle.DSC.U1 + 1 - xy_inangle.DSC.L1      
     .                 d3 = shortabsorpcoefdryair(bn)                           
     .                 d2 = shortabsorpcoefqvap(bn)                             
     .                 d1 = shortbandweight(bn)                                 
     .                 xyr_transfordwflux(t282-1,t280,k) = xyr_transfordwflux(  
     .       1            t282-1,t280,k) + d1*dexp((-xy_inangle(t4+t282-1,t280-1
     .       2            +t6)*(d2*xyr_coldenqvap(t282-1,t280,k)+d3*            
     .       3            xyr_coldendryair(t282-1,t280,k))))                    
     .                 xyr_transfordwflux(t282-1,t280+1,k) = xyr_transfordwflux(
     .       1            t282-1,t280+1,k) + d1*dexp((-xy_inangle(t4+t282-1,t280
     .       2            +t6)*(d2*xyr_coldenqvap(t282-1,t280+1,k)+d3*          
     .       3            xyr_coldendryair(t282-1,t280+1,k))))                  
     .                 xyr_transfordwflux(t282-1,t280+2,k) = xyr_transfordwflux(
     .       1            t282-1,t280+2,k) + d1*dexp((-xy_inangle(t4+t282-1,t280
     .       2            +1+t6)*(d2*xyr_coldenqvap(t282-1,t280+2,k)+d3*        
     .       3            xyr_coldendryair(t282-1,t280+2,k))))                  
     .                 xyr_transfordwflux(t282-1,t280+3,k) = xyr_transfordwflux(
     .       1            t282-1,t280+3,k) + d1*dexp((-xy_inangle(t4+t282-1,t280
     .       2            +2+t6)*(d2*xyr_coldenqvap(t282-1,t280+3,k)+d3*        
     .       3            xyr_coldendryair(t282-1,t280+3,k))))                  
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
   807            & + ShortBandWeight(bn)                                                  &
   808            &   * exp( - xy_InAngle                                                  &
   809            &            * (   ShortAbsorpCoefQVap  (bn) * xyr_ColDenQVap  (:,:,k)   &
   810            &                + ShortAbsorpCoefDryAir(bn) * xyr_ColDenDryAir(:,:,k) ) &
   811            &        )
   812        end do
   813      end do
   814      !
   815      xyr_TransForUwFlux = 0.0_DP
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t294 = 1, (xyr_transforuwflux.DSC.U3 + 1)*                     
     .       1   xyr_transforuwflux.DSC.U2*(xyr_transforuwflux.DSC.U1 + 1)      
     .           xyr_transforuwflux(t294-1,1,0) = 0.0000000000000000e+000       
     .        enddo                                                             
   816      do k = 0, kmax
   817        do bn = 1, ShortBandNum
   818          xyr_TransForUwFlux(:,:,k) = xyr_TransForUwFlux(:,:,k)                        &
     .  !cdir nodep                                                             
     .  !cdir on_adb(xy_inangle,xyr_coldenqvap,xyr_coldendryair,xyr_transforuwfl
     .       1   ux,xy_surfalbedo)                                              
     .        do t305 = 0, xy_inangle.DSC.U1 - xy_inangle.DSC.L1                
   819            & + ShortBandWeight(bn)                                                    &
   820            &   * exp( - xy_InAngle                                                    &
   821            &            * (   ShortAbsorpCoefQVap  (bn) * xyr_ColDenQVap  (:,:,0)     &
   822            &                + ShortAbsorpCoefDryAir(bn) * xyr_ColDenDryAir(:,:,0) )   &
   823            &        )                                                                 &
   824            &   * xy_SurfAlbedo                                                        &
   825            &   * exp( - ShortSecScat                                                  &
   826            &            * (   ShortAbsorpCoefQVap(bn)                                 &
   827            &                  * ( xyr_ColDenQVap  (:,:,0) - xyr_ColDenQVap  (:,:,k) ) &
   828            &                + ShortAbsorpCoefDryAir(bn)                               &
   829            &                  * ( xyr_ColDenDryAir(:,:,0) - xyr_ColDenDryAir(:,:,k) ) &
   830            &              )                                                           &
   831            &        )
   832        end do
   833      end do
   834  
   835      do k = 0, kmax
   836        xyr_RadSDwFlux(:,:,k) = xy_TOARadSDwFlux * xyr_TransForDwFlux(:,:,k)
     .  !cdir    nodep                                                          
     .  !cdir noassume                                                          
     .  !cdir on_adb(xyr_transfordwflux,xyr_transforuwflux,xy_toaradsdwflux)    
     .        do t327 = 1, jmax*imax                                            
     .           xyr_radsdwflux(t327-1,1,k) = xy_toaradsdwflux(t327-1,1)*       
     .       1      xyr_transfordwflux(t327-1,1,k)                              
     .           xyr_radsuwflux(t327-1,1,k) = xy_toaradsdwflux(t327-1,1)*       
     .       1      xyr_transforuwflux(t327-1,1,k)                              
     .        enddo                                                             
   837        xyr_RadSUwFlux(:,:,k) = xy_TOARadSDwFlux * xyr_TransForUwFlux(:,:,k)
   838      end do
   839  
   840  
   841    end subroutine ShortFlux
   842  
   843    !--------------------------------------------------------------------------------------
   844  
   845    subroutine RadDennouAGCMInit( flag_rst )
   846      !
   847      ! rad_DennouAGCM モジュールの初期化を行います.
   848      ! NAMELIST#rad_DennouAGCM_nml の読み込みはこの手続きで行われます.
   849      !
   850      ! "rad_DennouAGCM" module is initialized.
   851      ! "NAMELIST#rad_DennouAGCM_nml" is loaded in this procedure.
   852      !
   853  
   854      ! モジュール引用 ; USE statements
   855      !
   856  
   857      ! 出力ファイルの基本情報
   858      ! Basic information for output files
   859      !
   860      use fileset, only: &
   861        & FileTitle, &
   862                                ! 出力データファイルの表題.
   863                                ! Title of output data files
   864        & FileSource, &
   865                                ! データファイル作成の手段.
   866                                ! Source of data file
   867        & FileInstitution
   868                                ! データファイルを最終的に変更した組織/個人.
   869                                ! Institution or person that changes data files for the last time
   870  
   871      ! 物理・数学定数設定
   872      ! Physical and mathematical constants settings
   873      !
   874      use constants0, only: &
   875        & PI                    ! $ \pi $ .
   876                                ! 円周率.  Circular constant
   877  
   878      ! 座標データ設定
   879      ! Axes data settings
   880      !
   881      use axesset, only: &
   882        & x_Lon, &
   883                                ! $ \lambda $ [rad.] . 経度. Longitude
   884        & x_Lon_Weight, &
   885                                ! $ \Delta \lambda $ [rad.] .
   886                                ! 経度座標重み.
   887                                ! Weight of longitude
   888        & y_Lat, &
   889                                ! $ \varphi $ [rad.] . 緯度. Latitude
   890        & y_Lat_Weight, &
   891                                ! $ \Delta \varphi $ [rad.] .
   892                                ! 緯度座標重み.
   893                                ! Weight of latitude
   894        & z_Sigma, &
   895                                ! $ \sigma $ レベル (整数).
   896                                ! Full $ \sigma $ level
   897        & r_Sigma, &
   898                                ! $ \sigma $ レベル (半整数).
   899                                ! Half $ \sigma $ level
   900        & z_DelSigma
   901                                ! $ \Delta \sigma $ (整数).
   902                                ! $ \Delta \sigma $ (Full)
   903  
   904      ! 時刻管理
   905      ! Time control
   906      !
   907      use timeset, only: &
   908        & RestartTime           ! リスタート開始時刻.
   909                                ! Retart time of calculation
   910  
   911  
   912      ! NAMELIST ファイル入力に関するユーティリティ
   913      ! Utilities for NAMELIST file input
   914      !
   915      use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid
   916  
   917      ! 暦と日時の取り扱い
   918      ! Calendar and Date handler
   919      !
   920      use dc_calendar, only: DCCalConvertByUnit
   921  
   922      ! ファイル入出力補助
   923      ! File I/O support
   924      !
   925      use dc_iounit, only: FileOpen
   926  
   927      ! 種別型パラメタ
   928      ! Kind type parameter
   929      !
   930      use dc_types, only: STDOUT ! 標準出力の装置番号. Unit number of standard output
   931  
   932      ! 組み込み関数 PRESENT の拡張版関数
   933      ! Extended functions of intrinsic function "PRESENT"
   934      !
   935      use dc_present, only: present_and_true
   936  
   937      ! 文字列操作
   938      ! Character handling
   939      !
   940      use dc_string, only: toChar
   941  
   942      ! リスタートデータ入出力
   943      ! Restart data input/output
   944      !
   945      use gtool_history, only: HistoryCreate, HistoryAddAttr, &
   946        & HistoryAddVariable, HistoryPut, &
   947        & HistoryGet, HistoryGetAttr
   948  
   949      ! 短波入射 (太陽入射)
   950      ! Short wave (insolation) incoming
   951      !
   952      use rad_short_income, only : RadShortIncomeInit
   953  
   954      ! 散乱を無視した放射伝達方程式
   955      ! Radiative transfer equation without considering scattering
   956      !
   957      use rad_rte_nonscat, only : RadRTENonScatInit
   958  
   959      ! 宣言文 ; Declaration statements
   960      !
   961      implicit none
   962      logical, intent(in), optional:: flag_rst
   963                                ! リスタートであることを示すフラグ.
   964                                ! .true. が与えられる場合,
   965                                ! 長波放射, 短波放射に関するリスタート
   966                                ! ファイルが必要になります.
   967                                ! リスタートファイルに関する情報は
   968                                ! NAMELIST#rad_DennouAGCM_nml
   969                                ! で指定されます.
   970                                ! デフォルトは .false. です.
   971                                !
   972                                ! Flag for restart.
   973                                ! If .true. is given,
   974                                ! a restart file for long radiation
   975                                ! and short radiation is needed.
   976                                ! Information about the restart file
   977                                ! is specified by "NAMELIST#rad_DennouAGCM_nml".
   978                                ! Default value is .false.
   979                                !
   980  
   981      character(STRING):: RstInputFile
   982                                ! 入力するリスタートデータのファイル名
   983                                ! Filename of input restart data
   984  
   985      character(STRING):: RstOutputFile
   986                                ! 出力するリスタートデータのファイル名
   987                                ! Filename of output restart data
   988      character(STRING):: time_range
   989                                ! 時刻の指定.
   990                                ! Specification of time
   991  
   992      character(TOKEN):: dummy_str
   993                                ! 入力チェック用のダミー変数
   994                                ! Dummy variable for check of input
   995      logical:: get_err
   996                                ! 入力時のエラーフラグ.
   997                                ! Error flag for input
   998  
   999      integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号.
  1000                                ! Unit number for NAMELIST file open
  1001      integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT.
  1002                                ! IOSTAT of NAMELIST read
  1003  
  1004      character(STRING):: title_msg
  1005                                ! 表題に付加するメッセージ.
  1006                                ! Message added to title
  1007  
  1008      real(DP):: origin_time
  1009                                ! 計算開始時刻.
  1010                                ! Start time of calculation
  1011      character(STRING):: time_unit
  1012                                ! 日時の単位. Units of date and time
  1013  
  1014      logical:: flag_mpi_init
  1015  
  1016      real(DP):: BandWeightSum  ! バンドウェイトの和
  1017                                ! Sum of band weights
  1018      integer:: bn              ! 波長について回る DO ループ用作業変数
  1019                                ! Work variables for DO loop in wavenumber bands
  1020  
  1021  
  1022      ! NAMELIST 変数群
  1023      ! NAMELIST group name
  1024      !
  1025      namelist /rad_DennouAGCM_nml/ &
  1026        & SolarConst, &
  1027  !
  1028        & DelTimeLongValue, DelTimeLongUnit, &
  1029        & DelTimeShortValue, DelTimeShortUnit, &
  1030  !
  1031        & LongBandNum, &
  1032        & LongAbsorpCoefQVap, LongAbsorpCoefDryAir, &
  1033        & LongBandWeight, LongPathLengthFact, &
  1034  !
  1035        & ShortBandNum, &
  1036        & ShortAbsorpCoefQVap, ShortAbsorpCoefDryAir, &
  1037        & ShortBandWeight, ShortSecScat, &
  1038        & ShortAtmosAlbedo, &
  1039  !
  1040        & RstInputFile, RstOutputFile
  1041            !
  1042            ! デフォルト値については初期化手続 "rad_DennouAGCM#RadInit"
  1043            ! のソースコードを参照のこと.
  1044            !
  1045            ! Refer to source codes in the initialization procedure
  1046            ! "rad_DennouAGCM#RadInit" for the default values.
  1047            !
  1048  
  1049      ! 実行文 ; Executable statement
  1050      !
  1051  
  1052      if ( rad_DennouAGCM_inited ) return
  1053  
  1054  
  1055  !    flag_mpi_init = .false.
  1056      flag_mpi_init = .true.
  1057  
  1058      ! デフォルト値の設定
  1059      ! Default values settings
  1060      !
  1061  
  1062      ! 長波フラックス用情報
  1063      ! Information for long wave flux
  1064      !
  1065      PrevTimeLong = RestartTime
  1066  
  1067      DelTimeLongValue = 3.0_DP
  1068      DelTimeLongUnit  = 'hrs.'
  1069  
  1070      LongBandNum      = 4
  1071      LongAbsorpCoefQVap     = -999.9_DP
     .  !cdir nodep                                                             
     .  !cdir on_adb(longabsorpcoefqvap,longabsorpcoefdryair,longbandweight)    
     .        do t1470 = 0, 255                                                 
  1072      LongAbsorpCoefDryAir   = -999.9_DP
  1073      LongBandWeight         = -999.9_DP
  1074      LongAbsorpCoefQVap    (1:LongBandNum) = (/ 8.0_DP, 1.0_DP, 0.1_DP, 0.0_DP /)
     .           longabsorpcoefqvap(1) = %IG0(1)                                
     .        longabsorpcoefdryair(1) = %IG1(1)                                 
     .        longbandweight(1) = %IG2(1)                                       
     .        longabsorpcoefqvap(2) = %IG0(2)                                   
     .        longabsorpcoefdryair(2) = %IG1(2)                                 
     .        longbandweight(2) = %IG2(2)                                       
     .        longabsorpcoefqvap(3) = %IG0(3)                                   
     .        longabsorpcoefdryair(3) = %IG1(3)                                 
     .        longbandweight(3) = %IG2(3)                                       
     .        longabsorpcoefqvap(4) = %IG0(4)                                   
     .        longabsorpcoefdryair(4) = %IG1(4)                                 
     .        longbandweight(4) = %IG2(4)                                       
  1075      LongAbsorpCoefDryAir  (1:LongBandNum) = (/ 0.0_DP, 0.0_DP, 0.0_DP, 5.0e-5_DP /)
  1076      LongBandWeight        (1:LongBandNum) = (/ 0.2_DP, 0.1_DP, 0.1_DP, 0.6_DP /)
  1077      LongPathLengthFact = 1.5_DP
  1078  
  1079      ! 短波フラックス用情報
  1080      ! Information for short wave flux
  1081      !
  1082      SolarConst             = 1380.0_DP
  1083  
  1084      PrevTimeShort = RestartTime
  1085  
  1086      DelTimeShortValue = 1.0_DP
  1087      DelTimeShortUnit  = 'hrs.'
  1088  
  1089      ShortBandNum = 1
  1090      ShortAbsorpCoefQVap    = -999.9_DP
     .  !cdir nodep                                                             
     .  !cdir on_adb(shortabsorpcoefqvap,shortabsorpcoefdryair,shortbandweight) 
     .        do t1483 = 0, 255                                                 
  1091      ShortAbsorpCoefDryAir  = -999.9_DP
  1092      ShortBandWeight        = -999.9_DP
  1093      ShortAbsorpCoefQVap   (1:ShortBandNum) = (/ 0.002_DP /)
     .           shortabsorpcoefqvap(1) = %IG3(1)                               
     .        shortabsorpcoefdryair(1) = %IG4(1)                                
     .        shortbandweight(1) = %IG5(1)                                      
  1094      ShortAbsorpCoefDryAir (1:ShortBandNum) = (/ 0.0_DP /)
  1095      ShortBandWeight       (1:ShortBandNum) = (/ 1.0_DP /)
  1096      ShortSecScat           = 1.66_DP
  1097      ShortAtmosAlbedo       = 0.2_DP
  1098  
  1099      ! リスタートファイル情報
  1100      ! Information about a restart file
  1101      !
  1102      RstInputFile  = ''
  1103      RstOutputFile = 'rst_rad.nc'
  1104  
  1105      ! NAMELIST の読み込み
  1106      ! NAMELIST is input
  1107      !
  1108      if ( trim(namelist_filename) /= '' ) then
  1109        call FileOpen( unit_nml, &          ! (out)
  1110          & namelist_filename, mode = 'r' ) ! (in)
  1111  
  1112        rewind( unit_nml )
  1113        read( unit_nml,                     & ! (in)
  1114          & nml = rad_DennouAGCM_nml,       & ! (out)
  1115          & iostat = iostat_nml )             ! (out)
  1116        close( unit_nml )
  1117  
  1118        call NmlutilMsg( iostat_nml, module_name ) ! (in)
  1119      end if
  1120  
  1121  
  1122      if ( LongBandNum <= 0 ) then
  1123        call MessageNotify( 'E', module_name, 'LongBandNum has to be positive.' )
  1124      end if
  1125      if ( ShortBandNum <= 0 ) then
  1126        call MessageNotify( 'E', module_name, 'ShortBandNum has to be positive.' )
  1127      end if
  1128  
  1129  
  1130      ! バンドウェイトの設定
  1131      ! Configure band weight
  1132      !
  1133      BandWeightSum = 0.
  1134      do bn = 1, LongBandNum
  1135        BandWeightSum =  BandWeightSum + LongBandWeight(bn)
  1136      end do
     .  !cdir nodep                                                             
     .  !cdir on_adb(longbandweight)                                            
     .        do bn = 1, longbandnum                                            
     .           bandweightsum = bandweightsum + longbandweight(bn)             
     .        enddo                                                             
  1137      do bn = 1, LongBandNum
  1138        LongBandWeight(bn) = LongBandWeight(bn) / BandWeightSum
  1139      end do
     .        d1 = 1.D0/bandweightsum                                           
     .  !cdir nodep                                                             
     .  !cdir on_adb(longbandweight)                                            
     .        do bn = 1, longbandnum                                            
     .           longbandweight(bn) = longbandweight(bn)*d1                     
     .        enddo                                                             
  1140      !
  1141      BandWeightSum = 0.
  1142      do bn = 1, ShortBandNum
  1143        BandWeightSum = BandWeightSum + ShortBandWeight(bn)
  1144      end do
     .  !cdir nodep                                                             
     .  !cdir on_adb(shortbandweight)                                           
     .        do bn = 1, shortbandnum                                           
     .           bandweightsum = bandweightsum + shortbandweight(bn)            
     .        enddo                                                             
  1145      do bn = 1, ShortBandNum
  1146        ShortBandWeight(bn) = ShortBandWeight(bn) / BandWeightSum
  1147      end do
     .        d2 = 1.D0/bandweightsum                                           
     .  !cdir nodep                                                             
     .  !cdir on_adb(shortbandweight)                                           
     .        do bn = 1, shortbandnum                                           
     .           shortbandweight(bn) = shortbandweight(bn)*d2                   
     .        enddo                                                             
  1148  
  1149  
  1150  
  1151      ! 時間間隔の処理
  1152      ! Handle interval time
  1153      !
  1154      IntTimeLong  = DCCalConvertByUnit( DelTimeLongValue,  DelTimeLongUnit,  'sec' ) ! (in)
  1155      IntTimeShort = DCCalConvertByUnit( DelTimeShortValue, DelTimeShortUnit, 'sec' ) ! (in)
  1156  
  1157      ! バンド数, 吸収係数, バンドウェイトのチェック
  1158      ! Check number of band, absorption coefficients, band weight
  1159      !
  1160      call NmlutilAryValid( module_name, &            ! (in)
  1161        & LongAbsorpCoefQVap, 'LongAbsorpCoefQVap', & ! (in)
  1162        & LongBandNum,        'LongBandNum' )         ! (in)
  1163  
  1164      call NmlutilAryValid( module_name, &                ! (in)
  1165        & LongAbsorpCoefDryAir, 'LongAbsorpCoefDryAir', & ! (in)
  1166        & LongBandNum,          'LongBandNum' )           ! (in)
  1167  
  1168      call NmlutilAryValid( module_name, &     ! (in)
  1169        & LongBandWeight, 'LongBandWeight', &  ! (in)
  1170        & LongBandNum,    'LongBandNum' )      ! (in)
  1171  
  1172      call NmlutilAryValid( module_name, &              ! (in)
  1173        & ShortAbsorpCoefQVap, 'ShortAbsorpCoefQVap', & ! (in)
  1174        & ShortBandNum,        'ShortBandNum' )         ! (in)
  1175  
  1176      call NmlutilAryValid( module_name, &                  ! (in)
  1177        & ShortAbsorpCoefDryAir, 'ShortAbsorpCoefDryAir', & ! (in)
  1178        & ShortBandNum,          'ShortBandNum' )           ! (in)
  1179  
  1180      call NmlutilAryValid( module_name, &       ! (in)
  1181        & ShortBandWeight, 'ShortBandWeight', &  ! (in)
  1182        & ShortBandNum,    'ShortBandNum' )      ! (in)
  1183  
  1184      ! 短波入射用変数の割付
  1185      ! Allocate variables for short wave (insolation) incoming radiation
  1186      !
  1187      allocate( xy_IncomRadSFlux (0:imax-1, 1:jmax) )
  1188      allocate( xy_InAngle (0:imax-1, 1:jmax) )
  1189  
  1190      ! 保存用の変数の割り付け
  1191      ! Allocate variables for saving
  1192      !
  1193      allocate( xy_TempSave            (0:imax-1, 1:jmax) )
  1194      allocate( xyr_RadSUwFluxSave     (0:imax-1, 1:jmax, 0:kmax) )
  1195      allocate( xyr_RadSDwFluxSave     (0:imax-1, 1:jmax, 0:kmax) )
  1196      allocate( xyr_RadLUwFluxSave     (0:imax-1, 1:jmax, 0:kmax) )
  1197      allocate( xyr_RadLDwFluxSave     (0:imax-1, 1:jmax, 0:kmax) )
  1198      allocate( xyra_DelRadLUwFluxSave (0:imax-1, 1:jmax, 0:kmax, 0:1) )
  1199      allocate( xyra_DelRadLDwFluxSave (0:imax-1, 1:jmax, 0:kmax, 0:1) )
  1200  
  1201      ! リスタートファイルの入力
  1202      ! Input restart file
  1203      !
  1204      if ( present_and_true( flag_rst ) ) then
  1205  
  1206        if ( trim(RstInputFile) == '' ) then
  1207          call MessageNotify( 'E', module_name, &
  1208            & 'a restart file is needed. ' // &
  1209            & 'Specify the restart file to "RstInputFile" in NAMELIST "rad_DennouAGCM_nml"' )
  1210        end if
  1211  
  1212        ! 時刻情報の取得
  1213        ! Get time information
  1214        !
  1215        time_range = 'time=' // toChar( RestartTime )
  1216  
  1217        ! ファイルの有無を確認
  1218        ! Conform an existence of an input file
  1219        !
  1220        call HistoryGetAttr( RstInputFile, 'lon', 'units', & ! (in)
  1221          & dummy_str, &                                     ! (out)
  1222          & flag_mpi_split = flag_mpi_init, &                ! (in) optional
  1223          & err = get_err )                                  ! (out)
  1224  
  1225        if ( get_err ) then
  1226          call MessageNotify( 'E', module_name, &
  1227            & 'restart/initial data file "%c" is not found.', &
  1228            & c1 = trim(RstInputFile) )
  1229        end if
  1230  
  1231        ! 入力
  1232        ! Input
  1233        !
  1234        call HistoryGet( &
  1235          & RstInputFile, 'SurfTemp', &      ! (in)
  1236          & xy_TempSave, &                   ! (out)
  1237          & range = time_range, &            ! (in) optional
  1238          & flag_mpi_split = flag_mpi_init ) ! (in) optional
  1239        call HistoryGet( &
  1240          & RstInputFile, 'RadSUwFlux', &    ! (in)
  1241          & xyr_RadSUwFluxSave, &            ! (out)
  1242          & range = time_range, &            ! (in) optional
  1243          & flag_mpi_split = flag_mpi_init ) ! (in) optional
  1244        call HistoryGet( &
  1245          & RstInputFile, 'RadSDwFlux', &    ! (in)
  1246          & xyr_RadSDwFluxSave, &            ! (out)
  1247          & range = time_range, &            ! (in) optional
  1248          & flag_mpi_split = flag_mpi_init ) ! (in) optional
  1249        call HistoryGet( &
  1250          & RstInputFile, 'RadLUwFlux', &    ! (in)
  1251          & xyr_RadLUwFluxSave, &            ! (out)
  1252          & range = time_range, &            ! (in) optional
  1253          & flag_mpi_split = flag_mpi_init ) ! (in) optional
  1254        call HistoryGet( &
  1255          & RstInputFile, 'RadLDwFlux', &    ! (in)
  1256          & xyr_RadLDwFluxSave, &            ! (out)
  1257          & range = time_range, &            ! (in) optional
  1258          & flag_mpi_split = flag_mpi_init ) ! (in) optional
  1259        call HistoryGet( &
  1260          & RstInputFile, 'DelRadLUwFlux', & ! (in)
  1261          & xyra_DelRadLUwFluxSave, &        ! (out)
  1262          & range = time_range, &            ! (in) optional
  1263          & flag_mpi_split = flag_mpi_init ) ! (in) optional
  1264        call HistoryGet( &
  1265          & RstInputFile, 'DelRadLDwFlux', & ! (in)
  1266          & xyra_DelRadLDwFluxSave, &        ! (out)
  1267          & range = time_range, &            ! (in) optional
  1268          & flag_mpi_split = flag_mpi_init ) ! (in) optional
  1269  
  1270        call HistoryGet( &
  1271          & RstInputFile, 'PrevTimeLong', &  ! (in)
  1272          & PrevTimeLong, &                  ! (out)
  1273          & range = time_range, &            ! (in) optional
  1274          & flag_mpi_split = flag_mpi_init ) ! (in) optional
  1275  
  1276        call HistoryGet( &
  1277          & RstInputFile, 'PrevTimeShort', & ! (in)
  1278          & PrevTimeShort, &                 ! (out)
  1279          & range = time_range, &            ! (in) optional
  1280          & flag_mpi_split = flag_mpi_init ) ! (in) optional
  1281  
  1282        flag_rst_input = .true.
  1283        Old_Flux_saved = .true.
  1284      else
  1285        RstInputFile = ''
  1286        flag_rst_input = .false.
  1287        Old_Flux_saved = .false.
  1288      end if
  1289  
  1290      ! 出力時間間隔の設定
  1291      ! Configure time interval of output
  1292      !
  1293      PrevRstOutputTime = RestartTime
  1294  
  1295      ! リスタートファイルの作成
  1296      ! Create a restart file
  1297      !
  1298      title_msg = ' restart data for "' // module_name // '" module'
  1299  !!$    origin_time = EvalByUnit( RestartTime, RstFileIntUnit )
  1300  !!$    time_unit = RstFileIntUnit
  1301      time_unit = 'sec'
  1302  
  1303      call HistoryCreate( &
  1304        &      file = RstOutputFile, &                                ! (in)
  1305        &     title = trim(FileTitle) // trim(title_msg), &           ! (in)
  1306        &    source = FileSource, institution = FileInstitution, &    ! (in)
  1307        &      dims = (/ 'lon  ', 'lat  ', 'sig  ', 'sigm ', &
  1308        &                'sorbl', 'time ' /), &                       ! (in)
  1309        &  dimsizes = (/ imax, jmax, kmax, kmax + 1, 2, 0 /), &       ! (in)
  1310        & longnames = (/ 'longitude                             ', &
  1311        &                'latitude                              ', &
  1312        &                'sigma at layer midpoints              ', &
  1313        &                'sigma at layer end-points (half level)', &
  1314        &                'surface or bottom layer               ', &
  1315        &                'time                                  ' /), & ! (in)
  1316        &     units = (/ 'degrees_east ', 'degrees_north', &
  1317        &                '1            ', '1            ', &
  1318        &                '1            ', time_unit(1:13) /), &            ! (in)
  1319        & xtypes = (/'double', 'double', 'double', &
  1320        &            'double', 'int   ', 'double'/), &                  ! (in)
  1321        &        origind = RestartTime, &         ! (in) optional
  1322        &      intervald = RstFileIntValue, &     ! (in) optional
  1323        & flag_mpi_split = flag_mpi_init, &       ! (in) optional
  1324        &        history = gthst_rst )            ! (out) optional
  1325  
  1326      ! 座標データの設定
  1327      ! Axes data settings
  1328      !
  1329      call HistoryAddAttr( &
  1330        & 'lon', attrname = 'standard_name', &     ! (in)
  1331        & value = 'longitude', &                   ! (in)
  1332        & history = gthst_rst )                    ! (inout)
  1333      call HistoryAddAttr( &
  1334        & 'lat', attrname = 'standard_name', &     ! (in)
  1335        & value = 'latitude', &                    ! (in)
  1336        & history = gthst_rst )                    ! (inout)
  1337      call HistoryAddAttr( &
  1338        & 'sig', attrname = 'standard_name', &     ! (in)
  1339        & value = 'atmosphere_sigma_coordinate', & ! (in)
  1340        & history = gthst_rst )                    ! (inout)
  1341      call HistoryAddAttr( &
  1342        & 'sigm', attrname = 'standard_name', &    ! (in)
  1343        & value = 'atmosphere_sigma_coordinate', & ! (in)
  1344        & history = gthst_rst )                    ! (inout)
  1345      call HistoryAddAttr( &
  1346        & 'time', attrname = 'standard_name', &    ! (in)
  1347        & value = 'time', &                        ! (in)
  1348        & history = gthst_rst )                    ! (inout)
  1349      call HistoryAddAttr( &
  1350        & 'sig', attrname = 'positive', &          ! (in)
  1351        & value = 'down', &                        ! (in)
  1352        & history = gthst_rst )                    ! (inout)
  1353      call HistoryAddAttr( &
  1354        & 'sigm', attrname = 'positive', &         ! (in)
  1355        & value = 'down', &                        ! (in)
  1356        & history = gthst_rst )                    ! (inout)
  1357  
  1358      call HistoryPut( &
     .        d3 = 1.D0/3.14159265358979e+000                                   
     .  !cdir nodep                                                             
     .        do t1496 = 1, x_lon.DSC.U1 + 1 - x_lon.DSC.L1                     
     .           %IG15(t1496) = x_lon(x_lon.DSC.L1+t1496-1)*d3*                 
     .       1      1.80000000000000e+002                                       
     .        enddo                                                             
  1359        & 'lon', x_Lon / PI * 180.0_DP, & ! (in)
  1360        & history = gthst_rst )           ! (inout)
  1361      call HistoryPut( &
     .        d4 = 1.D0/3.14159265358979e+000                                   
     .  !cdir nodep                                                             
     .        do t1500 = 1, y_lat.DSC.U1 + 1 - y_lat.DSC.L1                     
     .           %IG18(t1500) = y_lat(y_lat.DSC.L1+t1500-1)*d4*                 
     .       1      1.80000000000000e+002                                       
     .        enddo                                                             
  1362        & 'lat', y_Lat / PI * 180.0_DP, & ! (in)
  1363        & history = gthst_rst )           ! (inout)
  1364      call HistoryPut( &
  1365        & 'sig', z_Sigma, &               ! (in)
  1366        & history = gthst_rst )           ! (inout)
  1367      call HistoryPut( &
  1368        & 'sigm', r_Sigma, &              ! (in)
  1369        & history = gthst_rst )           ! (inout)
  1370      call HistoryPut( &
  1371        & 'sorbl', (/ 0, 1 /), &          ! (in)
  1372        & history = gthst_rst )           ! (inout)
  1373  
  1374      ! 座標重みの設定
  1375      ! Axes weights settings
  1376      !
  1377      call HistoryAddVariable( 'lon_weight', &               ! (in)
  1378        & (/'lon'/), &                                       ! (in)
  1379        & 'weight for integration in longitude', 'radian', & ! (in)
  1380        & xtype = 'double', &                                ! (in)
  1381        & history = gthst_rst )                              ! (inout)
  1382      call HistoryAddAttr( &
  1383        & 'lon', attrname = 'gt_calc_weight', &     ! (in)
  1384        & value = 'lon_weight', &                   ! (in)
  1385        & history = gthst_rst )                     ! (inout)
  1386      call HistoryPut( &
  1387        & 'lon_weight', x_Lon_Weight, &             ! (in)
  1388        & history = gthst_rst )                     ! (inout)
  1389  
  1390      call HistoryAddVariable( 'lat_weight', &                      ! (in)
  1391        & (/'lat'/), &                                              ! (in)
  1392        & 'weight for integration in latitude', units = 'radian', & ! (in)
  1393        & xtype = 'double', &                                       ! (in)
  1394        & history = gthst_rst )                                     ! (inout)
  1395      call HistoryAddAttr( &
  1396        & 'lat', attrname = 'gt_calc_weight', &     ! (in)
  1397        & value = 'lat_weight', &                   ! (in)
  1398        & history = gthst_rst )                     ! (inout)
  1399      call HistoryPut( &
  1400        & 'lat_weight', y_Lat_Weight, &             ! (in)
  1401        & history = gthst_rst )                     ! (inout)
  1402  
  1403      call HistoryAddVariable( 'sig_weight', &      ! (in)
  1404        & (/'sig'/), &                              ! (in)
  1405        & 'weight for integration in sigma', '1', & ! (in)
  1406        & xtype = 'double', &                       ! (in)
  1407        & history = gthst_rst )                     ! (inout)
  1408      call HistoryAddAttr( &
  1409        & 'sig', attrname = 'gt_calc_weight', &     ! (in)
  1410        & value = 'sig_weight', &                   ! (in)
  1411        & history = gthst_rst )                     ! (inout)
  1412      call HistoryPut( &
  1413        & 'sig_weight', z_DelSigma, &               ! (in)
  1414        & history = gthst_rst )                     ! (inout)
  1415  
  1416      call HistoryAddVariable( 'PrevTimeLong', &      ! (in)
  1417        & (/ 'time' /), &                             ! (in)
  1418        & 'previous time at which longwave flux is calculated', & ! (in)
  1419        & 'sec', &                                    ! (in)
  1420        & xtype = 'double', &                         ! (in)
  1421        & history = gthst_rst )                       ! (inout)
  1422      call HistoryAddVariable( 'PrevTimeShort', &     ! (in)
  1423        & (/ 'time' /), &                             ! (in)
  1424        & 'previous time at which shortwave flux is calculated', & ! (in)
  1425        & 'sec', &                                    ! (in)
  1426        & xtype = 'double', &                         ! (in)
  1427        & history = gthst_rst )                       ! (inout)
  1428  
  1429      call HistoryAddVariable( 'SurfTemp', &          ! (in)
  1430        & (/ 'lon ', 'lat ', 'time' /), &             ! (in)
  1431        & 'surface temperature', 'K', &               ! (in)
  1432        & xtype = 'double', &                         ! (in)
  1433        & history = gthst_rst )                       ! (inout)
  1434      call HistoryAddVariable( 'RadSUwFlux', &        ! (in)
  1435        & (/ 'lon ', 'lat ', 'sigm', 'time' /), &     ! (in)
  1436        & 'upward shortwave flux', 'W m-2', &         ! (in)
  1437        & xtype = 'double', &                         ! (in)
  1438        & history = gthst_rst )                       ! (inout)
  1439      call HistoryAddVariable( 'RadSDwFlux', &        ! (in)
  1440        & (/ 'lon ', 'lat ', 'sigm', 'time' /), &     ! (in)
  1441        & 'downward shortwave flux', 'W m-2', &       ! (in)
  1442        & xtype = 'double', &                         ! (in)
  1443        & history = gthst_rst )                       ! (inout)
  1444      call HistoryAddVariable( 'RadLUwFlux', &        ! (in)
  1445        & (/ 'lon ', 'lat ', 'sigm', 'time' /), &     ! (in)
  1446        & 'upward longwave flux', 'W m-2', &          ! (in)
  1447        & xtype = 'double', &                         ! (in)
  1448        & history = gthst_rst )                       ! (inout)
  1449      call HistoryAddVariable( 'RadLDwFlux', &        ! (in)
  1450        & (/ 'lon ', 'lat ', 'sigm', 'time' /), &     ! (in)
  1451        & 'downward longwave flux', 'W m-2', &        ! (in)
  1452        & xtype = 'double', &                         ! (in)
  1453        & history = gthst_rst )                       ! (inout)
  1454      call HistoryAddVariable( 'DelRadLUwFlux', &                           ! (in)
  1455        & (/ 'lon  ', 'lat  ', 'sigm ', 'sorbl', 'time ' /), &              ! (in)
  1456        & 'longwave flux tendency with surface temperature', 'W m-2 K-1', & ! (in)
  1457        & xtype = 'double', &                                               ! (in)
  1458        & history = gthst_rst )                                             ! (inout)
  1459      call HistoryAddVariable( 'DelRadLDwFlux', &                           ! (in)
  1460        & (/ 'lon  ', 'lat  ', 'sigm ', 'sorbl', 'time ' /), &              ! (in)
  1461        & 'longwave flux tendency with surface temperature', 'W m-2 K-1', & ! (in)
  1462        & xtype = 'double', &                                               ! (in)
  1463        & history = gthst_rst )                                             ! (inout)
  1464  
  1465  
  1466  
  1467      ! Initialization of modules used in this module
  1468      !
  1469  
  1470      ! 短波入射 (太陽入射)
  1471      ! Short wave (insolation) incoming
  1472      !
  1473      call RadShortIncomeInit
  1474  
  1475      ! 散乱を無視した放射伝達方程式
  1476      ! Radiative transfer equation without considering scattering
  1477      !
  1478      call RadRTENonScatInit
  1479  
  1480  
  1481      ! 印字 ; Print
  1482      !
  1483      call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
  1484      call MessageNotify( 'M', module_name, 'Restart:' )
  1485  
  1486      if ( trim(RstInputFile) == '' ) then
  1487        call MessageNotify( 'M', module_name, '  InputFile  = <no input>', c1 = trim( RstInputFile ) )
  1488      else
  1489        call MessageNotify( 'M', module_name, '  InputFile       = %c', c1 = trim( RstInputFile ) )
  1490        call MessageNotify( 'M', module_name, '    PrevTimeLong  = %f [%c]', &
  1491        & d = (/ PrevTimeLong /), c1 = 'sec' )
  1492        call MessageNotify( 'M', module_name, '    PrevTimeShort = %f [%c]', &
  1493        & d = (/ PrevTimeShort /), c1 = 'sec' )
  1494      end if
  1495  
  1496      call MessageNotify( 'M', module_name, '  OutputFile = %c', c1 = trim( RstOutputFile ) )
  1497      call MessageNotify( 'M', module_name, '  IntTime    = %f [%c] (same as IntTime in "restart_file_io" module)', &
  1498        & d = (/ RstFileIntValue /), c1 = trim( RstFileIntUnit ) )
  1499  !
  1500      call MessageNotify( 'M', module_name, '  SolarConst   = %f', d = (/ SolarConst /) )
  1501      call MessageNotify( 'M', module_name, 'DelTime:' )
  1502      call MessageNotify( 'M', module_name, '  DelTimeLong  = %f [%c]', &
  1503        & d = (/ DelTimeLongValue /), c1 = trim( DelTimeLongUnit ) )
  1504      call MessageNotify( 'M', module_name, '  DelTimeShort = %f [%c]', &
  1505        & d = (/ DelTimeShortValue /), c1 = trim( DelTimeShortUnit ) )
  1506  !
  1507      call MessageNotify( 'M', module_name, 'LongFlux:' )
  1508      call MessageNotify( 'M', module_name, '  LongBandNum            = %d', i = (/ LongBandNum /) )
  1509      call MessageNotify( 'M', module_name, '  LongAbsorpCoefQVap     = (/ %*r /)', &
     .  !cdir nodep                                                             
     .  !cdir on_adb(longabsorpcoefqvap)                                        
     .        do t1504 = 0, longbandnum - 1                                     
  1510        & r = real( LongAbsorpCoefQVap(1:LongBandNum) ), n = (/ LongBandNum /) )
  1511      call MessageNotify( 'M', module_name, '  LongAbsorpCoefDryAir   = (/ %*r /)', &
     .  !cdir    nodep                                                          
     .  !cdir on_adb(longabsorpcoefdryair)                                      
     .        do t1508 = 0, longbandnum - 1                                     
  1512        & r = real( LongAbsorpCoefDryAir(1:LongBandNum) ), n = (/ LongBandNum /) )
  1513      call MessageNotify( 'M', module_name, '  LongBandWeight         = (/ %*r /)', &
     .  !cdir    nodep                                                          
     .  !cdir on_adb(longbandweight)                                            
     .        do t1512 = 0, longbandnum - 1                                     
  1514        & r = real( LongBandWeight(1:LongBandNum) ), n = (/ LongBandNum /) )
  1515      call MessageNotify( 'M', module_name, '  LongPathLengthFact     = %f', d = (/ LongPathLengthFact /) )
  1516  !
  1517      call MessageNotify( 'M', module_name, 'ShortFlux:' )
  1518      call MessageNotify( 'M', module_name, '  ShortBandNum           = %d', i = (/ ShortBandNum /) )
  1519      call MessageNotify( 'M', module_name, '  ShortAbsorpCoefQVap    = (/ %*r /)', &
     .  !cdir    nodep                                                          
     .  !cdir on_adb(shortabsorpcoefqvap)                                       
     .        do t1516 = 0, shortbandnum - 1                                    
  1520        & r = real( ShortAbsorpCoefQVap(1:ShortBandNum) ), n = (/ ShortBandNum /) )
  1521      call MessageNotify( 'M', module_name, '  ShortAbsorpCoefDryAir  = (/ %*r /)', &
     .  !cdir    nodep                                                          
     .  !cdir on_adb(shortabsorpcoefdryair)                                     
     .        do t1520 = 0, shortbandnum - 1                                    
  1522        & r = real( ShortAbsorpCoefDryAir(1:ShortBandNum) ), n = (/ ShortBandNum /) )
  1523      call MessageNotify( 'M', module_name, '  ShortBandWeight        = (/ %*r /)', &
     .  !cdir    nodep                                                          
     .  !cdir on_adb(shortbandweight)                                           
     .        do t1524 = 0, shortbandnum - 1                                    
  1524        & r = real( ShortBandWeight(1:ShortBandNum) ), n = (/ ShortBandNum /) )
  1525      call MessageNotify( 'M', module_name, '  ShortSecScat           = %f', d = (/ ShortSecScat /) )
  1526      call MessageNotify( 'M', module_name, '  ShortAtmosAlbedo       = %f', d = (/ ShortAtmosAlbedo /) )
  1527  
  1528      call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
  1529  
  1530      rad_DennouAGCM_inited = .true.
  1531  
  1532    end subroutine RadDennouAGCMInit
  1533  
  1534    !--------------------------------------------------------------------------------------
  1535  
  1536    subroutine RadDennouAGCMFinalize
  1537      !
  1538      ! リスタートファイルのクローズと,
  1539      ! モジュール内部の変数の割り付け解除を行います.
  1540      !
  1541      ! Close a restart file, and
  1542      ! deallocate variables in this module.
  1543      !
  1544  
  1545      ! モジュール引用 ; USE statements
  1546      !
  1547  
  1548      ! リスタートデータ入出力
  1549      ! Restart data input/output
  1550      !
  1551      use gtool_history, only: HistoryClose
  1552  
  1553      ! 宣言文 ; Declaration statements
  1554      !
  1555      implicit none
  1556  
  1557      ! 実行文 ; Executable statement
  1558      !
  1559  
  1560      if ( .not. rad_DennouAGCM_inited ) return
  1561  
  1562  
  1563      ! デフォルト値へ戻す
  1564      ! Return to default values
  1565      !
  1566      Old_Flux_saved = .false.
  1567  
  1568      ! リスタートファイルのクローズ
  1569      ! close a restart file
  1570      !
  1571      call HistoryClose( history = gthst_rst ) ! (inout)
  1572  
  1573      ! 割り付け解除
  1574      ! Deallocation
  1575      !
  1576      if ( allocated( xy_IncomRadSFlux       ) ) deallocate( xy_IncomRadSFlux       )
  1577      if ( allocated( xy_InAngle             ) ) deallocate( xy_InAngle             )
  1578      if ( allocated( xy_TempSave            ) ) deallocate( xy_TempSave            )
  1579      if ( allocated( xyr_RadSUwFluxSave     ) ) deallocate( xyr_RadSUwFluxSave     )
  1580      if ( allocated( xyr_RadSDwFluxSave     ) ) deallocate( xyr_RadSDwFluxSave     )
  1581      if ( allocated( xyr_RadLUwFluxSave     ) ) deallocate( xyr_RadLUwFluxSave     )
  1582      if ( allocated( xyr_RadLDwFluxSave     ) ) deallocate( xyr_RadLDwFluxSave     )
  1583      if ( allocated( xyra_DelRadLUwFluxSave ) ) deallocate( xyra_DelRadLUwFluxSave )
  1584      if ( allocated( xyra_DelRadLDwFluxSave ) ) deallocate( xyra_DelRadLDwFluxSave )
  1585  
  1586      rad_DennouAGCM_inited = .false.
  1587  
  1588  
  1589    end subroutine RadDennouAGCMFinalize
  1590  
  1591    !--------------------------------------------------------------------------------------
  1592  
  1593  end module rad_DennouAGCM
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:50 2016
FILE NAME: rad_DennouAGCM.f90
PROGRAM NAME: rad_dennouagcm
FORMAT LIST

  LINE    LOOP      FORTRAN STATEMENT

     1:             != 放射フラックス (GFD 電脳倶楽部開発の放射モデル)
     2:             !
     3:             != Radiation flux (radiation model developed by GFD Dennou Club)
     4:             !
     5:             ! Authors::   Yoshiyuki O. Takahashi, Yasuhiro MORIKAWA, Yukiko YAMADA, Satoshi NODA
     6:             ! Version::   $Id: rad_DennouAGCM.f90,v 1.3 2012/02/01 05:19:53 yot Exp $ 
     7:             ! Tag Name::  $Name:  $
     8:             ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9:             ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10:             !
    11:             
    12:             module rad_DennouAGCM
    13:               !
    14:               != 放射フラックス (GFD 電脳倶楽部開発の放射モデル)
    15:               !
    16:               != Radiation flux (radiation model developed by GFD Dennou Club)
    17:               !
    18:               ! <b>Note that Japanese and English are described in parallel.</b>
    19:               !
    20:               ! 温度, 比湿, 気圧から, 放射フラックスを計算する放射モデルです. 
    21:               !
    22:               ! This is a radiation model that calculates radiation flux from
    23:               ! temperature, specific humidity, and air pressure.
    24:               !
    25:               !== References
    26:               !
    27:               !  Numaguti, Atusi, 1992: 
    28:               !    熱帯における積雲活動の大規模構造に関する数値実験. Doctor thesis, 218pp. (Japanese)
    29:               !
    30:               !== Procedures List
    31:               !
    32:               ! RadDennouAGCMFlux     :: 放射フラックスの計算
    33:               ! RadDennouAGCMFinalize :: 終了処理 (モジュール内部の変数の割り付け解除)
    34:               ! ------------                :: ------------
    35:               ! RadDennouAGCMFlux     :: Calculate radiation flux
    36:               ! RadDennouAGCMFinalize :: Termination (deallocate variables in this module)
    37:               !
    38:               !== NAMELIST
    39:               !
    40:               ! NAMELIST#rad_DennouAGCM_nml
    41:               !
    42:             
    43:               ! モジュール引用 ; USE statements
    44:               !
    45:             
    46:               ! 格子点設定
    47:               ! Grid points settings
    48:               !
    49:               use gridset, only: imax, & ! 経度格子点数. 
    50:                                          ! Number of grid points in longitude
    51:                 &                jmax, & ! 緯度格子点数. 
    52:                                          ! Number of grid points in latitude
    53:                 &                kmax    ! 鉛直層数. 
    54:                                          ! Number of vertical level
    55:             
    56:               ! リスタートデータ入出力
    57:               ! Restart data input/output
    58:               !
    59:               use restart_file_io, only: &
    60:                 & RstFileIntValue => IntValue, &
    61:                                           ! リスタートデータの出力間隔 (数値). 
    62:                                           ! Interval of restart data output (numerical value)
    63:                 & RstFileIntUnit  => IntUnit, &
    64:                                           ! リスタートデータの出力間隔 (単位). 
    65:                                           ! Interval of restart data output (unit)
    66:                 & RstFileIntTime  => IntTime
    67:                                           ! リスタートデータの出力間隔. 
    68:                                           ! Interval of restart data output
    69:             
    70:               ! 種別型パラメタ
    71:               ! Kind type parameter
    72:               !
    73:               use dc_types, only: DP, &      ! 倍精度実数型. Double precision. 
    74:                 &                 STRING, &  ! 文字列.       Strings. 
    75:                 &                 TOKEN      ! キーワード.   Keywords. 
    76:             
    77:               ! NAMELIST ファイル入力に関するユーティリティ
    78:               ! Utilities for NAMELIST file input
    79:               !
    80:               use namelist_util, only: MaxNmlArySize
    81:                                           ! NAMELIST から読み込む配列の最大サイズ. 
    82:                                           ! Maximum size of arrays loaded from NAMELIST
    83:             
    84:               ! メッセージ出力
    85:               ! Message output
    86:               !
    87:               use dc_message, only: MessageNotify
    88:             
    89:               ! リスタートデータ出力
    90:               ! Restart data output
    91:               !
    92:               use gtool_history, only: GT_HISTORY
    93:             
    94:               ! 宣言文 ; Declaration statements
    95:               !
    96:               implicit none
    97:               private
    98:             
    99:               ! 公開手続き
   100:               ! Public procedure
   101:               !
   102:               public:: RadDennouAGCMFlux
   103:               public:: RadDennouAGCMInit
   104:               public:: RadDennouAGCMFinalize
   105:             
   106:               ! 公開変数
   107:               ! Public variables
   108:               !
   109:               logical, save :: rad_DennouAGCM_inited = .false.
   110:                                           ! 初期設定フラグ. 
   111:                                           ! Initialization flag
   112:             
   113:             
   114:               ! 非公開変数
   115:               ! Private variables
   116:               !
   117:               logical, save:: Old_Flux_saved = .false.
   118:                                           ! 一度計算したフラックスを保存したことを示すフラグ. 
   119:                                           ! Flag for saving of flux calculated once
   120:             
   121:               type(GT_HISTORY), save:: gthst_rst
   122:                                           ! リスタートデータ用 gtool_history#GT_HISTORY 変数. 
   123:                                           ! "gtool_history#GT_HISTORY" variable for restart data
   124:               real(DP), save:: PrevRstOutputTime
   125:                                           ! 前回のリスタートファイルの出力時間. 
   126:                                           ! Previous output time of a restart file
   127:               logical, save:: flag_rst_output_end
   128:                                           ! 計算最終時刻の出力完了のフラグ. 
   129:                                           ! Flag for completion of output at the end time of calculation
   130:               logical, save:: flag_rst_input = .false.
   131:                                           ! 現在の保存値がリスタートファイルから読み込まれたことを示すフラグ. 
   132:                                           ! Flag that indicates that saved value is input from a restart file. 
   133:             
   134:               ! 長波フラックス用情報
   135:               ! Information for long wave flux
   136:               !
   137:               real(DP), save:: IntTimeLong
   138:                                           ! 長波フラックスを計算する時間間隔. 
   139:                                           ! Interval time of long wave flux calculation
   140:               real(DP), save:: PrevTimeLong
   141:                                           ! 前回長波フラックスを計算した時刻. 
   142:                                           ! Time when long wave flux is calculated
   143:               real(DP), save:: DelTimeLongValue
   144:                                           ! 長波フラックスを計算する時間間隔の数値. 
   145:                                           ! Value of interval step of long wave flux calculation
   146:               character(STRING), save:: DelTimeLongUnit
   147:                                           ! 長波フラックスを計算する時間間隔の単位. 
   148:                                           ! Unit of interval step of long wave flux calculation
   149:             
   150:               integer, save:: LongBandNum
   151:                                           ! 長波バンド数. 
   152:                                           ! Number of long wave band
   153:               real(DP), save:: LongAbsorpCoefQVap (1:MaxNmlArySize)
   154:                                           ! $ k_R $ . 水の吸収係数. 
   155:                                           ! Absorption coefficient of water. 
   156:               real(DP), save:: LongAbsorpCoefDryAir (1:MaxNmlArySize)
   157:                                           ! $ \bar{k}_R $ . 空気の吸収係数. 
   158:                                           ! Absorption coefficient of air. 
   159:               real(DP), save:: LongBandWeight (1:MaxNmlArySize)
   160:                                           ! バンドウェイト. 
   161:                                           ! Band weight. 
   162:               real(DP), save:: LongPathLengthFact
   163:                                           ! 光路長のファクタ. 
   164:                                           ! Factor of optical length
   165:             
   166:               real(DP), allocatable, save:: xy_TempSave (:,:)
   167:                                           ! $ T $ .     温度 (保存用). Temperature (for save)
   168:               real(DP), allocatable, save:: xyr_RadLUwFluxSave (:,:,:)
   169:                                           ! 長波フラックス (保存用). 
   170:                                           ! Upward long wave flux (for save)
   171:               real(DP), allocatable, save:: xyr_RadLDwFluxSave (:,:,:)
   172:                                           ! 長波フラックス (保存用). 
   173:                                           ! Downward long wave flux (for save)
   174:               real(DP), allocatable, save:: xyra_DelRadLUwFluxSave (:,:,:,:)
   175:                                           ! 長波地表温度変化 (保存用). 
   176:                                           ! 
   177:               real(DP), allocatable, save:: xyra_DelRadLDwFluxSave (:,:,:,:)
   178:                                           ! 長波地表温度変化 (保存用). 
   179:                                           ! 
   180:             
   181:               ! 短波フラックス用情報
   182:               ! Information for short wave flux
   183:               !
   184:               real(DP), save:: SolarConst
   185:                                           ! 太陽定数. 
   186:                                           ! Solar constant.
   187:               real(DP), save:: IntTimeShort
   188:                                           ! 短波フラックスを計算する時間間隔. 
   189:                                           ! Interval time of short wave flux calculation
   190:               real(DP), save:: PrevTimeShort
   191:                                           ! 前回短波フラックスを計算した時刻
   192:                                           ! Time when short wave flux is calculated
   193:               real(DP), save:: DelTimeShortValue
   194:                                           ! 短波 (日射) フラックスを計算する時間間隔の数値. 
   195:                                           ! Value of interval step of short wave (insolation) flux calculation
   196:               character(STRING), save:: DelTimeShortUnit
   197:                                           ! 短波 (日射) フラックスを計算する時間間隔の単位. 
   198:                                           ! Unit of interval step of short wave (insolation) flux calculation
   199:             
   200:             
   201:               integer, save:: ShortBandNum
   202:                                           ! 短波バンド数. 
   203:                                           ! Number of short wave band
   204:               real(DP), save:: ShortAbsorpCoefQVap (1:MaxNmlArySize)
   205:                                           ! $ k_S $ . 水の吸収係数. 
   206:                                           ! Absorption coefficient of water. 
   207:               real(DP), save:: ShortAbsorpCoefDryAir (1:MaxNmlArySize)
   208:                                           ! $ \bar{k}_S $ . 空気の吸収係数. 
   209:                                           ! Absorption coefficient of air. 
   210:               real(DP), save:: ShortBandWeight (1:MaxNmlArySize)
   211:                                           ! バンドウェイト. 
   212:                                           ! Band weight. 
   213:               real(DP), save:: ShortSecScat
   214:                                           ! 散乱の $ \sec \zeta $ .
   215:                                           ! $ \sec \zeta $ of scattering
   216:               real(DP), save:: ShortAtmosAlbedo
   217:                                           ! 大気アルベド. 
   218:                                           ! Albedo of air.
   219:             
   220:               real(DP), allocatable, save:: xyr_RadSUwFluxSave (:,:,:)
   221:                                           ! 短波 (日射) フラックス (保存用). 
   222:                                           ! Upward short wave (insolation) flux (for save)
   223:               real(DP), allocatable, save:: xyr_RadSDwFluxSave (:,:,:)
   224:                                           ! 短波 (日射) フラックス (保存用). 
   225:                                           ! Downward short wave (insolation) flux (for save)
   226:             
   227:               ! 短波入射用情報
   228:               ! Information for short wave incoming
   229:               !
   230:               real(DP), allocatable, save:: xy_IncomRadSFlux (:,:)
   231:                                           ! 短波 (日射) フラックス. 
   232:                                           ! Short wave (insolation) flux
   233:               real(DP), allocatable, save:: xy_InAngle (:,:)
   234:                                           ! sec (入射角). 
   235:                                           ! sec (angle of incidence)
   236:             
   237:             
   238:               character(*), parameter:: module_name = 'rad_DennouAGCM'
   239:                                           ! モジュールの名称. 
   240:                                           ! Module name
   241:               character(*), parameter:: version = &
   242:                 & '$Name:  $' // &
   243:                 & '$Id: rad_DennouAGCM.f90,v 1.3 2012/02/01 05:19:53 yot Exp $'
   244:                                           ! モジュールのバージョン
   245:                                           ! Module version
   246:             
   247:             contains
   248:             
   249:               !--------------------------------------------------------------------------------------
   250:             
   251:               subroutine RadDennouAGCMFlux(                  &
   252:                 & xyz_Temp, xyz_QVap, xyr_Press,             & ! (in)
   253:                 & xy_SurfTemp, xy_SurfAlbedo,                & ! (in)
   254:                 & xyr_RadSUwFlux, xyr_RadSDwFlux,            & ! (out)
   255:                 & xyr_RadLUwFlux, xyr_RadLDwFlux,            & ! (out)
   256:                 & xyra_DelRadLUwFlux, xyra_DelRadLDwFlux     & ! (out)
   257:                 & )
   258:                 !
   259:                 ! 温度, 比湿, 気圧から, 放射フラックスを計算します. 
   260:                 !
   261:                 ! Calculate radiation flux from temperature, specific humidity, and 
   262:                 ! air pressure. 
   263:                 !
   264:             
   265:                 ! モジュール引用 ; USE statements
   266:                 !
   267:             
   268:                 ! 短波入射 (太陽入射)
   269:                 ! Short wave (insolation) incoming
   270:                 !
   271:                 use rad_short_income, only: RadShortIncome
   272:             
   273:                 ! 物理定数設定
   274:                 ! Physical constants settings
   275:                 !
   276:                 use constants, only: Grav ! $ g $ [m s-2]. 
   277:                                           ! 重力加速度. 
   278:                                           ! Gravitational acceleration
   279:             
   280:                 ! 時刻管理
   281:                 ! Time control
   282:                 !
   283:                 use timeset, only: &
   284:                   & TimeN, &              ! ステップ $ t $ の時刻. 
   285:                                           ! Time of step $ t $. 
   286:                   & EndTime, &            ! 計算終了時刻. 
   287:                                           ! End time of calculation
   288:                   & TimesetClockStart, TimesetClockStop
   289:             
   290:                 ! リスタートデータ出力
   291:                 ! Restart data output
   292:                 !
   293:                 use gtool_history, only: HistoryPut, HistorySetTime
   294:             
   295:                 ! デバッグ用ユーティリティ
   296:                 ! Utilities for debug
   297:                 !
   298:                 use dc_trace, only: DbgMessage, BeginSub, EndSub
   299:             
   300:                 ! 宣言文 ; Declaration statements
   301:                 !
   302:                 implicit none
   303:             
   304:                 real(DP), intent(in):: xyz_Temp  (0:imax-1, 1:jmax, 1:kmax)
   305:                                           ! $ T $ .     温度. Temperature
   306:                 real(DP), intent(in):: xyz_QVap  (0:imax-1, 1:jmax, 1:kmax)
   307:                                           ! $ q $ .     比湿. Specific humidity
   308:                 real(DP), intent(in):: xyr_Press (0:imax-1, 1:jmax, 0:kmax)
   309:                                           ! $ \hat{p} $ . 気圧 (半整数レベル). 
   310:                                           ! Air pressure (half level)
   311:                 real(DP), intent(in):: xy_SurfTemp (0:imax-1, 1:jmax)
   312:                                           ! 地表面温度. 
   313:                                           ! Surface temperature
   314:                 real(DP), intent(in):: xy_SurfAlbedo (0:imax-1, 1:jmax)
   315:                                           ! 地表アルベド. 
   316:                                           ! Surface albedo
   317:             
   318:                 real(DP), intent(out):: xyr_RadSUwFlux (0:imax-1, 1:jmax, 0:kmax)
   319:                                           ! 短波 (日射) フラックス. 
   320:                                           ! Upward shortwave (insolation) flux
   321:                 real(DP), intent(out):: xyr_RadSDwFlux (0:imax-1, 1:jmax, 0:kmax)
   322:                                           ! 短波 (日射) フラックス. 
   323:                                           ! Downward shortwave (insolation) flux
   324:             
   325:                 real(DP), intent(out):: xyr_RadLUwFlux (0:imax-1, 1:jmax, 0:kmax)
   326:                                           ! 長波フラックス. 
   327:                                           ! Upward longwave flux
   328:                 real(DP), intent(out):: xyr_RadLDwFlux (0:imax-1, 1:jmax, 0:kmax)
   329:                                           ! 長波フラックス. 
   330:                                           ! Downward longwave flux
   331:                 real(DP), intent(out):: xyra_DelRadLUwFlux (0:imax-1, 1:jmax, 0:kmax, 0:1)
   332:                                           ! 長波地表温度変化. 
   333:                                           ! 
   334:                 real(DP), intent(out):: xyra_DelRadLDwFlux (0:imax-1, 1:jmax, 0:kmax, 0:1)
   335:                                           ! 長波地表温度変化. 
   336:                                           ! 
   337:             
   338:             
   339:             
   340:                 ! 作業変数
   341:                 ! Work variables
   342:                 !
   343:                 real(DP):: xyr_ColDenQVap (0:imax-1, 1:jmax, 0:kmax)
   344:                                           ! $ \int_z^{\infty} \rho q \, dz $ . 
   345:                                           ! 鉛直層 k より上空の水蒸気のカラム密度. 
   346:                                           ! Column density of water vapor above vertical level k. 
   347:                 real(DP):: xyr_ColDenDryAir (0:imax-1, 1:jmax, 0:kmax)
   348:                                           ! $ \int_z^{\infty} \rho \, dz $ . 
   349:                                           ! 鉛直層 k より上空の空気のカラム密度. 
   350:                                           ! Column density of air above vertical level k. 
   351:                 integer:: k               ! 鉛直方向に回る DO ループ用作業変数
   352:                                           ! Work variables for DO loop in vertical direction
   353:                 logical:: flag_rst_output
   354:                                           ! リスタートファイル出力のフラグ. 
   355:                                           ! Flag for output of a restart file
   356:             
   357:                 real(DP) :: xy_CosSZA(0:imax-1, 1:jmax)
   358:                 real(DP) :: DistFromStarScld
   359:                 real(DP) :: DiurnalMeanFactor
   360:             
   361:                 integer:: i
   362:                 integer:: j
   363:             
   364:             
   365:                 real(DP) :: MaxError
   366:             
   367:             
   368:                 ! 実行文 ; Executable statement
   369:                 !
   370:             
   371:                 ! 初期化確認
   372:                 ! Initialization check
   373:                 !
   374:                 if ( .not. rad_DennouAGCM_inited ) then
   375:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   376:                 end if
   377:             
   378:             
   379:                 ! 計算時間計測開始
   380:                 ! Start measurement of computation time
   381:                 !
   382:                 call TimesetClockStart( module_name )
   383:             
   384:             
   385:                 ! 鉛直層 k より上空のカラム密度の計算
   386:                 ! Calculate column density above vertical level k
   387:                 !
   388: *W----->A       xyr_ColDenQVap  (:,:,kmax) = 0.
   389: *W----- A       xyr_ColDenDryAir(:,:,kmax) = 0.
   390:             
   391: +------>        do k = kmax-1, 0, -1
   392: |*W---->A         xyr_ColDenQVap(:,:,k) = &
   393: |||                 &   xyr_ColDenQVap(:,:,k+1) &
   394: |||                 & + xyz_QVap(:,:,k+1) &
   395: |||                 &   * ( xyr_Press(:,:,k) - xyr_Press(:,:,k+1) ) / Grav
   396: |||         
   397: |*W---- A         xyr_ColDenDryAir(:,:,k) = &
   398: |                   &   xyr_ColDenDryAir(:,:,k+1) &
   399: |                   & + ( xyr_Press(:,:,k) - xyr_Press(:,:,k+1) ) / Grav
   400: +------         end do
   401:             
   402:                 ! 長波フラックスの算出
   403:                 ! Calculate long wave flux
   404:                 !
   405:                 if ( ( TimeN - PrevTimeLong >= IntTimeLong ) .or. ( .not. Old_Flux_saved ) ) then
   406:             
   407:                   if ( .not. Old_Flux_saved ) then
   408:                     PrevTimeLong = TimeN
   409:                   else
   410:                     PrevTimeLong = PrevTimeLong + IntTimeLong
   411:                   end if
   412:             
   413:             
   414:                   call LongFlux( &
   415:                     & xyz_Temp, xy_SurfTemp, xyr_ColDenQVap, xyr_ColDenDryAir,                & ! (in)
   416:                     & xyr_RadLUwFlux, xyr_RadLDwFlux, xyra_DelRadLUwFlux, xyra_DelRadLDwFlux  & ! (out)
   417:                     & )
   418:             
   419:             
   420:                 ! 前回の値を利用
   421:                 ! Use values in last time
   422:                 !
   423:                 else
   424:             
   425: **V---->A         xyr_RadLUwFlux     = xyr_RadLUwFluxSave
   426: **V---- A         xyr_RadLDwFlux     = xyr_RadLDwFluxSave
   427: ***V--->A         xyra_DelRadLUwFlux = xyra_DelRadLUwFluxSave
   428: ***V--- A         xyra_DelRadLDwFlux = xyra_DelRadLDwFluxSave
   429:             
   430:                   if ( .not. flag_rst_input ) then
   431: +------>            do k = 0, kmax
   432: |*V---->A             xyr_RadLUwFlux(:,:,k) = xyr_RadLUwFlux(:,:,k) &
   433: |||                     & + xyra_DelRadLUwFlux(:,:,k,1) * ( xyz_Temp(:,:,1) - xy_TempSave )
   434: |||     A             xyr_RadLDwFlux(:,:,k) = xyr_RadLDwFlux(:,:,k) &
   435: |||     A               & + xyra_DelRadLDwFlux(:,:,k,1) * ( xyz_Temp(:,:,1) - xy_TempSave )
   436: |||     A   
   437: |||     A             xyra_DelRadLUwFlux(:,:,k,1) = xyra_DelRadLUwFlux(:,:,k,1) &
   438: |||                     &     / ( xy_TempSave**3 ) * ( xyz_Temp(:,:,1)**3 )
   439: |*V---- A             xyra_DelRadLDwFlux(:,:,k,1) = xyra_DelRadLDwFlux(:,:,k,1) &
   440: |                       &     / ( xy_TempSave**3 ) * ( xyz_Temp(:,:,1)**3 )
   441: +------             end do
   442:                   else
   443:                     flag_rst_input = .false.
   444:                     call DbgMessage( '%c: restart data is used. ', c1 = module_name )
   445:                   end if
   446:             
   447:                 end if
   448:             
   449:             
   450:             
   451:                 ! 短波 (日射) フラックスの算出
   452:                 ! Calculate short wave (insolation)
   453:                 !
   454:                 if ( ( TimeN - PrevTimeShort >= IntTimeShort ) .or. ( .not. Old_Flux_saved ) ) then
   455:             
   456:                   if ( .not. Old_Flux_saved ) then
   457:                     PrevTimeShort = TimeN
   458:                   else
   459:                     PrevTimeShort = PrevTimeShort + IntTimeShort
   460:                   end if
   461:             
   462:                   ! 短波入射の計算
   463:                   ! Calculate short wave (insolation) incoming radiation
   464:                   !
   465:                   call RadShortIncome(                       &
   466:                     & xy_CosZet         = xy_CosSZA,         & ! (out) optional
   467:                     & xy_InAngle        = xy_InAngle,        & ! (out) optional
   468:                     & DistFromStarScld  = DistFromStarScld,  &
   469:                     & DiurnalMeanFactor = DiurnalMeanFactor  &
   470:                     & )
   471:             
   472:             
   473:                   ! 短波フラックスの計算
   474:                   ! Calculate short wave (insolation) flux
   475:                   !
   476:             
   477: +------>          do j = 1, jmax
   478: |V----->            do i = 0, imax-1
   479: ||      A             if ( xy_CosSZA(i,j) > 0.0_DP ) then
   480: ||      A               xy_IncomRadSFlux(i,j) = SolarConst / DistFromStarScld**2 * xy_CosSZA(i,j)
   481: ||                    else
   482: ||                      xy_IncomRadSFlux(i,j) = 0.0_DP
   483: ||                    end if
   484: |V----- A           end do
   485: +------           end do
   486:                   ! Correction of incoming solar flux when diurnal mean insolation is assumed.
   487:                   ! If diurnal mean insolation is assumed, DiurnalMeanFactor = 1 / PI.
   488:                   ! If diurnal mean insolation is not assumed, DiurnalMeanFactor = 1.
   489: *W----->A         xy_IncomRadSFlux = xy_IncomRadSFlux * DiurnalMeanFactor
   490: ||          
   491: ||          
   492: ||                ! 大気アルベドの考慮
   493: ||                ! Taking atmospheric albedo into consideration
   494: ||                !
   495: *W----- A         xy_IncomRadSFlux = xy_IncomRadSFlux * ( 1.0d0 - ShortAtmosAlbedo )
   496:             
   497:             
   498:                   call ShortFlux(                                      &
   499:                     & xyr_ColDenQVap, xyr_ColDenDryAir, xy_SurfAlbedo, & ! (in)
   500:                     & xy_IncomRadSFlux,                                & ! (in)
   501:                     & xyr_RadSUwFlux, xyr_RadSDwFlux                   & ! (out)
   502:                     & )
   503:             
   504:             
   505:                 else
   506:                   ! 前回の値を利用
   507:                   ! Use values in last time
   508:             
   509: **V---->A         xyr_RadSUwFlux = xyr_RadSUwFluxSave
   510: **V---- A         xyr_RadSDwFlux = xyr_RadSDwFluxSave
   511:                 end if
   512:             
   513:             
   514:             
   515:                 ! 今回計算した値を保存
   516:                 ! Save calculated values in this time
   517:                 !
   518: +V===== A       xy_TempSave            = xyz_Temp (:,:,1)
   519:             
   520: **V---->A       xyr_RadSUwFluxSave     = xyr_RadSUwFlux
   521: |||     A       xyr_RadSDwFluxSave     = xyr_RadSDwFlux
   522: |||         
   523: |||     A       xyr_RadLUwFluxSave     = xyr_RadLUwFlux
   524: **V---- A       xyr_RadLDwFluxSave     = xyr_RadLDwFlux
   525: ***V--->A       xyra_DelRadLUwFluxSave = xyra_DelRadLUwFlux
   526: ***V--- A       xyra_DelRadLDwFluxSave = xyra_DelRadLDwFlux
   527:             
   528:                 if ( .not. Old_Flux_saved ) Old_Flux_saved = .true.
   529:             
   530:                 ! リスタートファイルの出力タイミングのチェック
   531:                 ! Check output timing of a restart file
   532:                 !
   533:             !!
   534:             !! old code to be deleted
   535:             !! 
   536:             !    flag_rst_output = ( TimeN - PrevRstOutputTime >= RstFileIntTime )
   537:             !    if ( TimeN >= EndTime .and. .not. flag_rst_output_end ) then
   538:             !      flag_rst_output = .true.
   539:             !      flag_rst_output_end = .true.
   540:             !    end if
   541:             !    flag_rst_output = ( .not. TimeN == PrevRstOutputTime ) .and. flag_rst_output
   542:             
   543:             
   544:                 if ( TimeN - PrevRstOutputTime >= RstFileIntTime ) then
   545:                    flag_rst_output = .true.
   546:                 else
   547:                    flag_rst_output = .false.
   548:                 end if
   549:                 if ( TimeN >= EndTime .and. .not. flag_rst_output_end ) then
   550:                   flag_rst_output = .true.
   551:                   flag_rst_output_end = .true.
   552:                 end if
   553:                 if ( ( .not. TimeN == PrevRstOutputTime ) .and. flag_rst_output ) then
   554:                    flag_rst_output = .true.
   555:                 else
   556:                    flag_rst_output = .false.
   557:                 end if
   558:             
   559:             
   560:                 if ( flag_rst_output ) then
   561:                   ! 次回用に, 今回の出力 (希望) 時刻 を保存
   562:                   ! Save output time (expected) in this time, for next time
   563:                   !
   564:                   PrevRstOutputTime = PrevRstOutputTime + RstFileIntTime
   565:             
   566:                   ! 時刻の設定
   567:                   ! Set time
   568:                   !
   569:                   call HistorySetTime( timed = TimeN, history = gthst_rst )
   570:             
   571:                   ! データ出力
   572:                   ! Data output
   573:                   !
   574:                   call HistoryPut( &
   575:                     & 'PrevTimeLong', PrevTimeLong, & ! (in)
   576:                     & history = gthst_rst ) ! (in)
   577:                   call HistoryPut( &
   578:                     & 'PrevTimeShort', PrevTimeShort, & ! (in)
   579:                     & history = gthst_rst ) ! (in)
   580:                   call HistoryPut( &
   581:                     & 'SurfTemp', xy_TempSave, history = gthst_rst ) ! (in)
   582:                   call HistoryPut( &
   583:                     & 'RadLUwFlux', xyr_RadLUwFluxSave, history = gthst_rst ) ! (in)
   584:                   call HistoryPut( &
   585:                     & 'RadLDwFlux', xyr_RadLDwFluxSave, history = gthst_rst ) ! (in)
   586:                   call HistoryPut( &
   587:                     & 'RadSUwFlux', xyr_RadSUwFluxSave, history = gthst_rst ) ! (in)
   588:                   call HistoryPut( &
   589:                     & 'RadSDwFlux', xyr_RadSDwFluxSave, history = gthst_rst ) ! (in)
   590:                   call HistoryPut( &
   591:                     & 'DelRadLUwFlux', xyra_DelRadLUwFluxSave, history = gthst_rst ) ! (in)
   592:                   call HistoryPut( &
   593:                     & 'DelRadLDwFlux', xyra_DelRadLDwFluxSave, history = gthst_rst ) ! (in)
   594:             
   595:                 end if
   596:             
   597:                 ! 計算時間計測一時停止
   598:                 ! Pause measurement of computation time
   599:                 !
   600:                 call TimesetClockStop( module_name )
   601:             
   602:               end subroutine RadDennouAGCMFlux
   603:             
   604:               !--------------------------------------------------------------------------------------
   605:             
   606:               subroutine LongFlux( &
   607:                 & xyz_Temp, xy_SurfTemp, xyr_ColDenQVap, xyr_ColDenDryAir,                & ! (in)
   608:                 & xyr_RadLUwFlux, xyr_RadLDwFlux, xyra_DelRadLUwFlux, xyra_DelRadLDwFlux  & ! (out)
   609:                 & )
   610:                 !
   611:                 ! 長波フラックスの計算
   612:                 !
   613:                 ! Calculate long wave flux
   614:                 !
   615:             
   616:                 ! モジュール引用 ; USE statements
   617:                 !
   618:             
   619:                 ! 物理・数学定数設定
   620:                 ! Physical and mathematical constants settings
   621:                 !
   622:                 use constants0, only: &
   623:                   & StB                   ! $ \sigma_{SB} $ . 
   624:                                           ! ステファンボルツマン定数. 
   625:                                           ! Stefan-Boltzmann constant
   626:             
   627:                 ! 散乱を無視した放射伝達方程式
   628:                 ! Radiative transfer equation without considering scattering
   629:                 !
   630:                 use rad_rte_nonscat, only : RadRTENonScat
   631:             
   632:             
   633:                 ! 宣言文 ; Declaration statements
   634:                 !
   635:                 implicit none
   636:                 real(DP), intent(in):: xyz_Temp (0:imax-1, 1:jmax, 1:kmax)
   637:                                           ! $ T $ .     温度. Temperature
   638:             
   639:                 real(DP), intent(in):: xy_SurfTemp (0:imax-1, 1:jmax)
   640:                                           ! 地表面温度. 
   641:                                           ! Surface temperature
   642:                 real(DP), intent(in):: xyr_ColDenQVap (0:imax-1, 1:jmax, 0:kmax)
   643:                                           ! $ \int_z^{\infty} \rho q \, dz $ . 
   644:                                           ! 鉛直層 k より上空の水蒸気のカラム密度. 
   645:                                           ! Column density of water vapor above vertical level k. 
   646:                 real(DP), intent(in):: xyr_ColDenDryAir (0:imax-1, 1:jmax, 0:kmax)
   647:                                           ! $ \int_z^{\infty} \rho \, dz $ . 
   648:                                           ! 鉛直層 k より上空の空気のカラム密度. 
   649:                                           ! Column density of air above vertical level k. 
   650:                 real(DP), intent(out):: xyr_RadLUwFlux (0:imax-1, 1:jmax, 0:kmax)
   651:                                           ! 長波フラックス. 
   652:                                           ! Upward longwave flux
   653:                 real(DP), intent(out):: xyr_RadLDwFlux (0:imax-1, 1:jmax, 0:kmax)
   654:                                           ! 長波フラックス. 
   655:                                           ! Downward longwave flux
   656:                 real(DP), intent(out):: xyra_DelRadLUwFlux (0:imax-1, 1:jmax, 0:kmax, 0:1)
   657:                                           ! 長波地表温度変化. 
   658:                                           ! 
   659:                 real(DP), intent(out):: xyra_DelRadLDwFlux (0:imax-1, 1:jmax, 0:kmax, 0:1)
   660:                                           ! 長波地表温度変化. 
   661:                                           ! 
   662:             
   663:                 ! 作業変数
   664:                 ! Work variables
   665:                 !
   666:                 real(DP):: xyrr_Trans(0:imax-1, 1:jmax, 0:kmax, 0:kmax)
   667:                                           ! 透過係数. 
   668:                                           ! Transmission coefficient
   669:                 real(DP):: xyz_PiB (0:imax-1, 1:jmax, 1:kmax)
   670:                                           ! $ \pi B = \sigma T^{4} $
   671:                 real(DP):: xy_SurfPiB (0:imax-1, 1:jmax)
   672:                                           ! 地表面の $ \pi B $ . 
   673:                                           ! $ \pi B $ on surface
   674:                 real(DP):: xy_PiDBDT1    (0:imax-1, 1:jmax)
   675:                                           ! $ \pi DBDT = 4 \sigma T^{3} at lowest level$
   676:                 real(DP):: xy_SurfPiDBDT (0:imax-1, 1:jmax)
   677:                                           ! 地表面の $ \pi DBDT $ . 
   678:                                           ! $ \pi B $ on surface
   679:             
   680:                 real(DP):: BandWeightSum  ! バンドウェイトの和
   681:                                           ! Sum of band weights
   682:             
   683:                 integer:: k, kk           ! 鉛直方向に回る DO ループ用作業変数
   684:                                           ! Work variables for DO loop in vertical direction
   685:                 integer:: bn              ! 波長について回る DO ループ用作業変数
   686:                                           ! Work variables for DO loop in wavenumber bands
   687:             
   688:                 ! 実行文 ; Executable statement
   689:                 !
   690:             
   691:             
   692:                 ! 透過関数計算
   693:                 ! Calculate transmission functions
   694:                 !
   695:                 !   Initialization
   696:                 !
   697: W***=== A       xyrr_Trans = 0.
   698:                 !
   699: +------>        do bn = 1, LongBandNum
   700: |           
   701: |+----->          do k = 0, kmax
   702: ||+---->            do kk = k, kmax
   703: |||W*== A             xyrr_Trans(:,:,k,kk) = &
   704: |||                     &   xyrr_Trans(:,:,k,kk) &
   705: |||                     & + LongBandWeight(bn) &
   706: |||                     &   * exp( - LongPathLengthFact &
   707: |||                     &            * (   LongAbsorpCoefQVap(bn) &
   708: |||                     &                  * abs(   xyr_ColDenQVap(:,:,kk) &
   709: |||                     &                         - xyr_ColDenQVap(:,:,k)  ) &
   710: |||                     &                + LongAbsorpCoefDryAir(bn) &
   711: |||                     &                  * abs(   xyr_ColDenDryAir(:,:,kk) &
   712: |||                     &                         - xyr_ColDenDryAir(:,:,k)  ) ) )
   713: ||+----             end do
   714: |+-----           end do
   715: |           
   716: +------         end do
   717:             
   718: +------>        do k = 0, kmax
   719: |+----->          do kk = 0, k-1
   720: ||W*=== A           xyrr_Trans(:,:,k,kk) = xyrr_Trans(:,:,kk,k)
   721: |+-----           end do
   722: +------         end do
   723:             
   724:             
   725:                 ! $ \pi B $, $ \pi DBDT $ の計算
   726:                 ! Calculate $ \pi B $ and $ \pi DBDT $
   727:                 !
   728: W**==== A       xyz_PiB       = StB * ( xyz_Temp**4 )
   729: *W----->A       xy_SurfPiB    = StB * ( xy_SurfTemp**4 )
   730: ||      A       xy_PiDBDT1    = 4.0_DP * xyz_PiB(:,:,1) / xyz_Temp(:,:,1)
   731: *W----- A       xy_SurfPiDBDT = 4.0_DP * xy_SurfPiB / xy_SurfTemp
   732:             
   733:             
   734:             
   735:                 call RadRTENonScat(                                 &
   736:                   & xyz_PiB, xy_SurfPiB, xy_PiDBDT1, xy_SurfPiDBDT, & ! (in)
   737:                   & xyrr_Trans,                                     & ! (in)
   738:                   & xyr_RadLUwFlux, xyr_RadLDwFlux,                 & ! (out)
   739:                   & xyra_DelRadLUwFlux, xyra_DelRadLDwFlux          & ! (out)
   740:                   & )
   741:             
   742:             
   743:               end subroutine LongFlux
   744:             
   745:               !--------------------------------------------------------------------------------------
   746:             
   747:               subroutine ShortFlux(                                &
   748:                 & xyr_ColDenQVap, xyr_ColDenDryAir, xy_SurfAlbedo, & ! (in)
   749:                 & xy_TOARadSDwFlux,                                & ! (in)
   750:                 & xyr_RadSUwFlux, xyr_RadSDwFlux                   & ! (out)
   751:                 & )
   752:                 !
   753:                 ! 短波フラックスを計算します.
   754:                 !
   755:                 ! Calculate short wave flux. 
   756:                 !
   757:             
   758:                 ! モジュール引用 ; USE statements
   759:                 !
   760:             
   761:                 ! 宣言文 ; Declaration statements
   762:                 !
   763:                 implicit none
   764:             
   765:                 real(DP), intent(in):: xyr_ColDenQVap (0:imax-1, 1:jmax, 0:kmax)
   766:                                           ! $ \int_z^{\infty} \rho q \, dz $ . 
   767:                                           ! 鉛直層 k より上空の水蒸気のカラム密度. 
   768:                                           ! Column density of water vapor above vertical level k. 
   769:                 real(DP), intent(in):: xyr_ColDenDryAir (0:imax-1, 1:jmax, 0:kmax)
   770:                                           ! $ \int_z^{\infty} \rho \, dz $ . 
   771:                                           ! 鉛直層 k より上空の空気のカラム密度. 
   772:                                           ! Column density of air above vertical level k. 
   773:                 real(DP), intent(in):: xy_SurfAlbedo (0:imax-1, 1:jmax)
   774:                                           ! 地表アルベド. 
   775:                                           ! Surface albedo
   776:                 real(DP), intent(in):: xy_TOARadSDwFlux (0:imax-1, 1:jmax)
   777:                                           ! 短波 (日射) フラックス. 
   778:                                           ! Shortwave (insolation) flux at the top of the atmosphere
   779:                 real(DP), intent(out):: xyr_RadSUwFlux (0:imax-1, 1:jmax, 0:kmax)
   780:                                           ! 短波 (日射) フラックス. 
   781:                                           ! Upward shortwave (insolation) flux
   782:                 real(DP), intent(out):: xyr_RadSDwFlux (0:imax-1, 1:jmax, 0:kmax)
   783:                                           ! 短波 (日射) フラックス. 
   784:                                           ! Downward shortwave (insolation) flux
   785:             
   786:                 ! 作業変数
   787:                 ! Work variables
   788:                 !
   789:                 real(DP) :: xyr_TransForDwFlux(0:imax-1, 1:jmax, 0:kmax)
   790:                                           ! 
   791:                                           ! Transmittance from level k to top of the atmosphere
   792:                 real(DP) :: xyr_TransForUwFlux(0:imax-1, 1:jmax, 0:kmax)
   793:                                           ! 
   794:                                           ! Transmittance from surface to level k
   795:                 integer:: k               ! 鉛直方向に回る DO ループ用作業変数
   796:                                           ! Work variables for DO loop in vertical direction
   797:                 integer:: bn              ! 波長について回る DO ループ用作業変数
   798:                                           ! Work variables for DO loop in wavenumber bands
   799:             
   800:                 ! 実行文 ; Executable statement
   801:                 !
   802:             
   803: W**====         xyr_TransForDwFlux = 0.0_DP
   804: +------>        do k = 0, kmax
   805: |+----->          do bn = 1, ShortBandNum
   806: ||+V=== A           xyr_TransForDwFlux(:,:,k) = xyr_TransForDwFlux(:,:,k)                      &
   807: ||                    & + ShortBandWeight(bn)                                                  &
   808: ||                    &   * exp( - xy_InAngle                                                  &
   809: ||                    &            * (   ShortAbsorpCoefQVap  (bn) * xyr_ColDenQVap  (:,:,k)   &
   810: ||                    &                + ShortAbsorpCoefDryAir(bn) * xyr_ColDenDryAir(:,:,k) ) &
   811: ||                    &        )
   812: |+-----           end do
   813: +------         end do
   814:                 !
   815: W**====         xyr_TransForUwFlux = 0.0_DP
   816: +------>        do k = 0, kmax
   817: |+----->          do bn = 1, ShortBandNum
   818: ||+V=== A           xyr_TransForUwFlux(:,:,k) = xyr_TransForUwFlux(:,:,k)                        &
   819: ||                    & + ShortBandWeight(bn)                                                    &
   820: ||                    &   * exp( - xy_InAngle                                                    &
   821: ||                    &            * (   ShortAbsorpCoefQVap  (bn) * xyr_ColDenQVap  (:,:,0)     &
   822: ||                    &                + ShortAbsorpCoefDryAir(bn) * xyr_ColDenDryAir(:,:,0) )   &
   823: ||                    &        )                                                                 &
   824: ||                    &   * xy_SurfAlbedo                                                        &
   825: ||                    &   * exp( - ShortSecScat                                                  &
   826: ||                    &            * (   ShortAbsorpCoefQVap(bn)                                 &
   827: ||                    &                  * ( xyr_ColDenQVap  (:,:,0) - xyr_ColDenQVap  (:,:,k) ) &
   828: ||                    &                + ShortAbsorpCoefDryAir(bn)                               &
   829: ||                    &                  * ( xyr_ColDenDryAir(:,:,0) - xyr_ColDenDryAir(:,:,k) ) &
   830: ||                    &              )                                                           &
   831: ||                    &        )
   832: |+-----           end do
   833: +------         end do
   834:             
   835: +------>        do k = 0, kmax
   836: |*W---->A         xyr_RadSDwFlux(:,:,k) = xy_TOARadSDwFlux * xyr_TransForDwFlux(:,:,k)
   837: |*W---- A         xyr_RadSUwFlux(:,:,k) = xy_TOARadSDwFlux * xyr_TransForUwFlux(:,:,k)
   838: +------         end do
   839:             
   840:             
   841:               end subroutine ShortFlux
   842:             
   843:               !--------------------------------------------------------------------------------------
   844:             
   845:               subroutine RadDennouAGCMInit( flag_rst )
   846:                 !
   847:                 ! rad_DennouAGCM モジュールの初期化を行います. 
   848:                 ! NAMELIST#rad_DennouAGCM_nml の読み込みはこの手続きで行われます. 
   849:                 !
   850:                 ! "rad_DennouAGCM" module is initialized. 
   851:                 ! "NAMELIST#rad_DennouAGCM_nml" is loaded in this procedure. 
   852:                 !
   853:             
   854:                 ! モジュール引用 ; USE statements
   855:                 !
   856:             
   857:                 ! 出力ファイルの基本情報
   858:                 ! Basic information for output files
   859:                 ! 
   860:                 use fileset, only: &
   861:                   & FileTitle, &
   862:                                           ! 出力データファイルの表題.
   863:                                           ! Title of output data files
   864:                   & FileSource, &
   865:                                           ! データファイル作成の手段. 
   866:                                           ! Source of data file
   867:                   & FileInstitution
   868:                                           ! データファイルを最終的に変更した組織/個人. 
   869:                                           ! Institution or person that changes data files for the last time
   870:             
   871:                 ! 物理・数学定数設定
   872:                 ! Physical and mathematical constants settings
   873:                 !
   874:                 use constants0, only: &
   875:                   & PI                    ! $ \pi $ .
   876:                                           ! 円周率.  Circular constant
   877:             
   878:                 ! 座標データ設定
   879:                 ! Axes data settings
   880:                 !
   881:                 use axesset, only: &
   882:                   & x_Lon, &
   883:                                           ! $ \lambda $ [rad.] . 経度. Longitude
   884:                   & x_Lon_Weight, &
   885:                                           ! $ \Delta \lambda $ [rad.] . 
   886:                                           ! 経度座標重み. 
   887:                                           ! Weight of longitude
   888:                   & y_Lat, &
   889:                                           ! $ \varphi $ [rad.] . 緯度. Latitude
   890:                   & y_Lat_Weight, &
   891:                                           ! $ \Delta \varphi $ [rad.] . 
   892:                                           ! 緯度座標重み. 
   893:                                           ! Weight of latitude
   894:                   & z_Sigma, &
   895:                                           ! $ \sigma $ レベル (整数). 
   896:                                           ! Full $ \sigma $ level
   897:                   & r_Sigma, &
   898:                                           ! $ \sigma $ レベル (半整数). 
   899:                                           ! Half $ \sigma $ level
   900:                   & z_DelSigma
   901:                                           ! $ \Delta \sigma $ (整数). 
   902:                                           ! $ \Delta \sigma $ (Full)
   903:             
   904:                 ! 時刻管理
   905:                 ! Time control
   906:                 !
   907:                 use timeset, only: &
   908:                   & RestartTime           ! リスタート開始時刻. 
   909:                                           ! Retart time of calculation
   910:             
   911:             
   912:                 ! NAMELIST ファイル入力に関するユーティリティ
   913:                 ! Utilities for NAMELIST file input
   914:                 !
   915:                 use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid
   916:             
   917:                 ! 暦と日時の取り扱い
   918:                 ! Calendar and Date handler
   919:                 !
   920:                 use dc_calendar, only: DCCalConvertByUnit
   921:             
   922:                 ! ファイル入出力補助
   923:                 ! File I/O support
   924:                 !
   925:                 use dc_iounit, only: FileOpen
   926:             
   927:                 ! 種別型パラメタ
   928:                 ! Kind type parameter
   929:                 !
   930:                 use dc_types, only: STDOUT ! 標準出力の装置番号. Unit number of standard output
   931:             
   932:                 ! 組み込み関数 PRESENT の拡張版関数
   933:                 ! Extended functions of intrinsic function "PRESENT"
   934:                 !
   935:                 use dc_present, only: present_and_true
   936:             
   937:                 ! 文字列操作
   938:                 ! Character handling
   939:                 !
   940:                 use dc_string, only: toChar
   941:             
   942:                 ! リスタートデータ入出力
   943:                 ! Restart data input/output
   944:                 !
   945:                 use gtool_history, only: HistoryCreate, HistoryAddAttr, &
   946:                   & HistoryAddVariable, HistoryPut, &
   947:                   & HistoryGet, HistoryGetAttr
   948:             
   949:                 ! 短波入射 (太陽入射)
   950:                 ! Short wave (insolation) incoming
   951:                 !
   952:                 use rad_short_income, only : RadShortIncomeInit
   953:             
   954:                 ! 散乱を無視した放射伝達方程式
   955:                 ! Radiative transfer equation without considering scattering
   956:                 !
   957:                 use rad_rte_nonscat, only : RadRTENonScatInit
   958:             
   959:                 ! 宣言文 ; Declaration statements
   960:                 !
   961:                 implicit none
   962:                 logical, intent(in), optional:: flag_rst
   963:                                           ! リスタートであることを示すフラグ. 
   964:                                           ! .true. が与えられる場合, 
   965:                                           ! 長波放射, 短波放射に関するリスタート
   966:                                           ! ファイルが必要になります. 
   967:                                           ! リスタートファイルに関する情報は
   968:                                           ! NAMELIST#rad_DennouAGCM_nml
   969:                                           ! で指定されます. 
   970:                                           ! デフォルトは .false. です. 
   971:                                           ! 
   972:                                           ! Flag for restart. 
   973:                                           ! If .true. is given, 
   974:                                           ! a restart file for long radiation 
   975:                                           ! and short radiation is needed. 
   976:                                           ! Information about the restart file 
   977:                                           ! is specified by "NAMELIST#rad_DennouAGCM_nml".
   978:                                           ! Default value is .false.
   979:                                           ! 
   980:             
   981:                 character(STRING):: RstInputFile
   982:                                           ! 入力するリスタートデータのファイル名
   983:                                           ! Filename of input restart data
   984:             
   985:                 character(STRING):: RstOutputFile
   986:                                           ! 出力するリスタートデータのファイル名
   987:                                           ! Filename of output restart data
   988:                 character(STRING):: time_range
   989:                                           ! 時刻の指定. 
   990:                                           ! Specification of time
   991:             
   992:                 character(TOKEN):: dummy_str
   993:                                           ! 入力チェック用のダミー変数
   994:                                           ! Dummy variable for check of input
   995:                 logical:: get_err
   996:                                           ! 入力時のエラーフラグ. 
   997:                                           ! Error flag for input
   998:             
   999:                 integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号. 
  1000:                                           ! Unit number for NAMELIST file open
  1001:                 integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT. 
  1002:                                           ! IOSTAT of NAMELIST read
  1003:             
  1004:                 character(STRING):: title_msg
  1005:                                           ! 表題に付加するメッセージ. 
  1006:                                           ! Message added to title
  1007:             
  1008:                 real(DP):: origin_time
  1009:                                           ! 計算開始時刻. 
  1010:                                           ! Start time of calculation
  1011:                 character(STRING):: time_unit
  1012:                                           ! 日時の単位. Units of date and time
  1013:             
  1014:                 logical:: flag_mpi_init
  1015:             
  1016:                 real(DP):: BandWeightSum  ! バンドウェイトの和
  1017:                                           ! Sum of band weights
  1018:                 integer:: bn              ! 波長について回る DO ループ用作業変数
  1019:                                           ! Work variables for DO loop in wavenumber bands
  1020:             
  1021:             
  1022:                 ! NAMELIST 変数群
  1023:                 ! NAMELIST group name
  1024:                 !
  1025:                 namelist /rad_DennouAGCM_nml/ &
  1026:                   & SolarConst, &
  1027:             !
  1028:                   & DelTimeLongValue, DelTimeLongUnit, &
  1029:                   & DelTimeShortValue, DelTimeShortUnit, &
  1030:             !
  1031:                   & LongBandNum, &
  1032:                   & LongAbsorpCoefQVap, LongAbsorpCoefDryAir, &
  1033:                   & LongBandWeight, LongPathLengthFact, &
  1034:             !
  1035:                   & ShortBandNum, &
  1036:                   & ShortAbsorpCoefQVap, ShortAbsorpCoefDryAir, &
  1037:                   & ShortBandWeight, ShortSecScat, &
  1038:                   & ShortAtmosAlbedo, &
  1039:             !
  1040:                   & RstInputFile, RstOutputFile
  1041:                       !
  1042:                       ! デフォルト値については初期化手続 "rad_DennouAGCM#RadInit" 
  1043:                       ! のソースコードを参照のこと. 
  1044:                       !
  1045:                       ! Refer to source codes in the initialization procedure
  1046:                       ! "rad_DennouAGCM#RadInit" for the default values. 
  1047:                       !
  1048:             
  1049:                 ! 実行文 ; Executable statement
  1050:                 !
  1051:             
  1052:                 if ( rad_DennouAGCM_inited ) return
  1053:             
  1054:             
  1055:             !    flag_mpi_init = .false.
  1056:                 flag_mpi_init = .true.
  1057:             
  1058:                 ! デフォルト値の設定
  1059:                 ! Default values settings
  1060:                 !
  1061:             
  1062:                 ! 長波フラックス用情報
  1063:                 ! Information for long wave flux
  1064:                 !
  1065:                 PrevTimeLong = RestartTime
  1066:             
  1067:                 DelTimeLongValue = 3.0_DP
  1068:                 DelTimeLongUnit  = 'hrs.'
  1069:             
  1070:                 LongBandNum      = 4
  1071: V------>A       LongAbsorpCoefQVap     = -999.9_DP
  1072: |       A       LongAbsorpCoefDryAir   = -999.9_DP
  1073: V------ A       LongBandWeight         = -999.9_DP
  1074: *------>        LongAbsorpCoefQVap    (1:LongBandNum) = (/ 8.0_DP, 1.0_DP, 0.1_DP, 0.0_DP /)
  1075: |               LongAbsorpCoefDryAir  (1:LongBandNum) = (/ 0.0_DP, 0.0_DP, 0.0_DP, 5.0e-5_DP /)
  1076: *------         LongBandWeight        (1:LongBandNum) = (/ 0.2_DP, 0.1_DP, 0.1_DP, 0.6_DP /)
  1077:                 LongPathLengthFact = 1.5_DP
  1078:             
  1079:                 ! 短波フラックス用情報
  1080:                 ! Information for short wave flux
  1081:                 !
  1082:                 SolarConst             = 1380.0_DP
  1083:             
  1084:                 PrevTimeShort = RestartTime
  1085:             
  1086:                 DelTimeShortValue = 1.0_DP
  1087:                 DelTimeShortUnit  = 'hrs.'
  1088:             
  1089:                 ShortBandNum = 1
  1090: V------>A       ShortAbsorpCoefQVap    = -999.9_DP
  1091: |       A       ShortAbsorpCoefDryAir  = -999.9_DP
  1092: V------ A       ShortBandWeight        = -999.9_DP
  1093: *------>        ShortAbsorpCoefQVap   (1:ShortBandNum) = (/ 0.002_DP /)
  1094: |               ShortAbsorpCoefDryAir (1:ShortBandNum) = (/ 0.0_DP /)
  1095: *------         ShortBandWeight       (1:ShortBandNum) = (/ 1.0_DP /)
  1096:                 ShortSecScat           = 1.66_DP
  1097:                 ShortAtmosAlbedo       = 0.2_DP
  1098:             
  1099:                 ! リスタートファイル情報
  1100:                 ! Information about a restart file
  1101:                 !
  1102:                 RstInputFile  = ''
  1103:                 RstOutputFile = 'rst_rad.nc'
  1104:             
  1105:                 ! NAMELIST の読み込み
  1106:                 ! NAMELIST is input
  1107:                 !
  1108:                 if ( trim(namelist_filename) /= '' ) then
  1109:                   call FileOpen( unit_nml, &          ! (out)
  1110:                     & namelist_filename, mode = 'r' ) ! (in)
  1111:             
  1112:                   rewind( unit_nml )
  1113:                   read( unit_nml,                     & ! (in)
  1114:                     & nml = rad_DennouAGCM_nml,       & ! (out)
  1115:                     & iostat = iostat_nml )             ! (out)
  1116:                   close( unit_nml )
  1117:             
  1118:                   call NmlutilMsg( iostat_nml, module_name ) ! (in)
  1119:                 end if
  1120:             
  1121:             
  1122:                 if ( LongBandNum <= 0 ) then
  1123:                   call MessageNotify( 'E', module_name, 'LongBandNum has to be positive.' )
  1124:                 end if
  1125:                 if ( ShortBandNum <= 0 ) then
  1126:                   call MessageNotify( 'E', module_name, 'ShortBandNum has to be positive.' )
  1127:                 end if
  1128:             
  1129:             
  1130:                 ! バンドウェイトの設定
  1131:                 ! Configure band weight
  1132:                 !
  1133:                 BandWeightSum = 0.
  1134: V------>        do bn = 1, LongBandNum
  1135: |       A         BandWeightSum =  BandWeightSum + LongBandWeight(bn)
  1136: V------         end do
  1137: V------>        do bn = 1, LongBandNum
  1138: |       A         LongBandWeight(bn) = LongBandWeight(bn) / BandWeightSum
  1139: V------         end do
  1140:                 !
  1141:                 BandWeightSum = 0.
  1142: V------>        do bn = 1, ShortBandNum
  1143: |       A         BandWeightSum = BandWeightSum + ShortBandWeight(bn)
  1144: V------         end do
  1145: V------>        do bn = 1, ShortBandNum
  1146: |       A         ShortBandWeight(bn) = ShortBandWeight(bn) / BandWeightSum
  1147: V------         end do
  1148:             
  1149:             
  1150:             
  1151:                 ! 時間間隔の処理
  1152:                 ! Handle interval time
  1153:                 !
  1154:                 IntTimeLong  = DCCalConvertByUnit( DelTimeLongValue,  DelTimeLongUnit,  'sec' ) ! (in)
  1155:                 IntTimeShort = DCCalConvertByUnit( DelTimeShortValue, DelTimeShortUnit, 'sec' ) ! (in)
  1156:             
  1157:                 ! バンド数, 吸収係数, バンドウェイトのチェック
  1158:                 ! Check number of band, absorption coefficients, band weight
  1159:                 !
  1160:                 call NmlutilAryValid( module_name, &            ! (in)
  1161:                   & LongAbsorpCoefQVap, 'LongAbsorpCoefQVap', & ! (in)
  1162:                   & LongBandNum,        'LongBandNum' )         ! (in)
  1163:             
  1164:                 call NmlutilAryValid( module_name, &                ! (in)
  1165:                   & LongAbsorpCoefDryAir, 'LongAbsorpCoefDryAir', & ! (in)
  1166:                   & LongBandNum,          'LongBandNum' )           ! (in)
  1167:             
  1168:                 call NmlutilAryValid( module_name, &     ! (in)
  1169:                   & LongBandWeight, 'LongBandWeight', &  ! (in)
  1170:                   & LongBandNum,    'LongBandNum' )      ! (in)
  1171:             
  1172:                 call NmlutilAryValid( module_name, &              ! (in)
  1173:                   & ShortAbsorpCoefQVap, 'ShortAbsorpCoefQVap', & ! (in)
  1174:                   & ShortBandNum,        'ShortBandNum' )         ! (in)
  1175:             
  1176:                 call NmlutilAryValid( module_name, &                  ! (in)
  1177:                   & ShortAbsorpCoefDryAir, 'ShortAbsorpCoefDryAir', & ! (in)
  1178:                   & ShortBandNum,          'ShortBandNum' )           ! (in)
  1179:             
  1180:                 call NmlutilAryValid( module_name, &       ! (in)
  1181:                   & ShortBandWeight, 'ShortBandWeight', &  ! (in)
  1182:                   & ShortBandNum,    'ShortBandNum' )      ! (in)
  1183:             
  1184:                 ! 短波入射用変数の割付
  1185:                 ! Allocate variables for short wave (insolation) incoming radiation
  1186:                 !
  1187:                 allocate( xy_IncomRadSFlux (0:imax-1, 1:jmax) )
  1188:                 allocate( xy_InAngle (0:imax-1, 1:jmax) )
  1189:             
  1190:                 ! 保存用の変数の割り付け
  1191:                 ! Allocate variables for saving
  1192:                 !
  1193:                 allocate( xy_TempSave            (0:imax-1, 1:jmax) )
  1194:                 allocate( xyr_RadSUwFluxSave     (0:imax-1, 1:jmax, 0:kmax) )
  1195:                 allocate( xyr_RadSDwFluxSave     (0:imax-1, 1:jmax, 0:kmax) )
  1196:                 allocate( xyr_RadLUwFluxSave     (0:imax-1, 1:jmax, 0:kmax) )
  1197:                 allocate( xyr_RadLDwFluxSave     (0:imax-1, 1:jmax, 0:kmax) )
  1198:                 allocate( xyra_DelRadLUwFluxSave (0:imax-1, 1:jmax, 0:kmax, 0:1) )
  1199:                 allocate( xyra_DelRadLDwFluxSave (0:imax-1, 1:jmax, 0:kmax, 0:1) )
  1200:             
  1201:                 ! リスタートファイルの入力
  1202:                 ! Input restart file
  1203:                 !
  1204:                 if ( present_and_true( flag_rst ) ) then
  1205:             
  1206:                   if ( trim(RstInputFile) == '' ) then
  1207:                     call MessageNotify( 'E', module_name, &
  1208:                       & 'a restart file is needed. ' // &
  1209:                       & 'Specify the restart file to "RstInputFile" in NAMELIST "rad_DennouAGCM_nml"' )
  1210:                   end if
  1211:             
  1212:                   ! 時刻情報の取得
  1213:                   ! Get time information
  1214:                   !
  1215:                   time_range = 'time=' // toChar( RestartTime )
  1216:             
  1217:                   ! ファイルの有無を確認
  1218:                   ! Conform an existence of an input file
  1219:                   ! 
  1220:                   call HistoryGetAttr( RstInputFile, 'lon', 'units', & ! (in)
  1221:                     & dummy_str, &                                     ! (out)
  1222:                     & flag_mpi_split = flag_mpi_init, &                ! (in) optional
  1223:                     & err = get_err )                                  ! (out)
  1224:             
  1225:                   if ( get_err ) then
  1226:                     call MessageNotify( 'E', module_name, &
  1227:                       & 'restart/initial data file "%c" is not found.', &
  1228:                       & c1 = trim(RstInputFile) )
  1229:                   end if
  1230:             
  1231:                   ! 入力
  1232:                   ! Input
  1233:                   !
  1234:                   call HistoryGet( &
  1235:                     & RstInputFile, 'SurfTemp', &      ! (in)
  1236:                     & xy_TempSave, &                   ! (out)
  1237:                     & range = time_range, &            ! (in) optional
  1238:                     & flag_mpi_split = flag_mpi_init ) ! (in) optional
  1239:                   call HistoryGet( &
  1240:                     & RstInputFile, 'RadSUwFlux', &    ! (in)
  1241:                     & xyr_RadSUwFluxSave, &            ! (out)
  1242:                     & range = time_range, &            ! (in) optional
  1243:                     & flag_mpi_split = flag_mpi_init ) ! (in) optional
  1244:                   call HistoryGet( &
  1245:                     & RstInputFile, 'RadSDwFlux', &    ! (in)
  1246:                     & xyr_RadSDwFluxSave, &            ! (out)
  1247:                     & range = time_range, &            ! (in) optional
  1248:                     & flag_mpi_split = flag_mpi_init ) ! (in) optional
  1249:                   call HistoryGet( &
  1250:                     & RstInputFile, 'RadLUwFlux', &    ! (in)
  1251:                     & xyr_RadLUwFluxSave, &            ! (out)
  1252:                     & range = time_range, &            ! (in) optional
  1253:                     & flag_mpi_split = flag_mpi_init ) ! (in) optional
  1254:                   call HistoryGet( &
  1255:                     & RstInputFile, 'RadLDwFlux', &    ! (in)
  1256:                     & xyr_RadLDwFluxSave, &            ! (out)
  1257:                     & range = time_range, &            ! (in) optional
  1258:                     & flag_mpi_split = flag_mpi_init ) ! (in) optional
  1259:                   call HistoryGet( &
  1260:                     & RstInputFile, 'DelRadLUwFlux', & ! (in)
  1261:                     & xyra_DelRadLUwFluxSave, &        ! (out)
  1262:                     & range = time_range, &            ! (in) optional
  1263:                     & flag_mpi_split = flag_mpi_init ) ! (in) optional
  1264:                   call HistoryGet( &
  1265:                     & RstInputFile, 'DelRadLDwFlux', & ! (in)
  1266:                     & xyra_DelRadLDwFluxSave, &        ! (out)
  1267:                     & range = time_range, &            ! (in) optional
  1268:                     & flag_mpi_split = flag_mpi_init ) ! (in) optional
  1269:             
  1270:                   call HistoryGet( &
  1271:                     & RstInputFile, 'PrevTimeLong', &  ! (in)
  1272:                     & PrevTimeLong, &                  ! (out)
  1273:                     & range = time_range, &            ! (in) optional
  1274:                     & flag_mpi_split = flag_mpi_init ) ! (in) optional
  1275:             
  1276:                   call HistoryGet( &
  1277:                     & RstInputFile, 'PrevTimeShort', & ! (in)
  1278:                     & PrevTimeShort, &                 ! (out)
  1279:                     & range = time_range, &            ! (in) optional
  1280:                     & flag_mpi_split = flag_mpi_init ) ! (in) optional
  1281:             
  1282:                   flag_rst_input = .true.
  1283:                   Old_Flux_saved = .true.
  1284:                 else
  1285:                   RstInputFile = ''
  1286:                   flag_rst_input = .false.
  1287:                   Old_Flux_saved = .false.
  1288:                 end if
  1289:             
  1290:                 ! 出力時間間隔の設定
  1291:                 ! Configure time interval of output
  1292:                 !
  1293:                 PrevRstOutputTime = RestartTime
  1294:             
  1295:                 ! リスタートファイルの作成
  1296:                 ! Create a restart file
  1297:                 !
  1298:                 title_msg = ' restart data for "' // module_name // '" module'
  1299:             !!$    origin_time = EvalByUnit( RestartTime, RstFileIntUnit )
  1300:             !!$    time_unit = RstFileIntUnit
  1301:                 time_unit = 'sec'
  1302:             
  1303:                 call HistoryCreate( &
  1304:                   &      file = RstOutputFile, &                                ! (in)
  1305:                   &     title = trim(FileTitle) // trim(title_msg), &           ! (in)
  1306:                   &    source = FileSource, institution = FileInstitution, &    ! (in)
  1307:                   &      dims = (/ 'lon  ', 'lat  ', 'sig  ', 'sigm ', &
  1308:                   &                'sorbl', 'time ' /), &                       ! (in)
  1309:                   &  dimsizes = (/ imax, jmax, kmax, kmax + 1, 2, 0 /), &       ! (in)
  1310:                   & longnames = (/ 'longitude                             ', &
  1311:                   &                'latitude                              ', &
  1312:                   &                'sigma at layer midpoints              ', &
  1313:                   &                'sigma at layer end-points (half level)', &
  1314:                   &                'surface or bottom layer               ', &
  1315:                   &                'time                                  ' /), & ! (in)
  1316:                   &     units = (/ 'degrees_east ', 'degrees_north', &
  1317:                   &                '1            ', '1            ', &
  1318:                   &                '1            ', time_unit(1:13) /), &            ! (in)
  1319:                   & xtypes = (/'double', 'double', 'double', &
  1320:                   &            'double', 'int   ', 'double'/), &                  ! (in)
  1321:                   &        origind = RestartTime, &         ! (in) optional
  1322:                   &      intervald = RstFileIntValue, &     ! (in) optional
  1323:                   & flag_mpi_split = flag_mpi_init, &       ! (in) optional
  1324:                   &        history = gthst_rst )            ! (out) optional
  1325:             
  1326:                 ! 座標データの設定
  1327:                 ! Axes data settings
  1328:                 !
  1329:                 call HistoryAddAttr( &
  1330:                   & 'lon', attrname = 'standard_name', &     ! (in)
  1331:                   & value = 'longitude', &                   ! (in)
  1332:                   & history = gthst_rst )                    ! (inout)
  1333:                 call HistoryAddAttr( &
  1334:                   & 'lat', attrname = 'standard_name', &     ! (in)
  1335:                   & value = 'latitude', &                    ! (in)
  1336:                   & history = gthst_rst )                    ! (inout)
  1337:                 call HistoryAddAttr( &
  1338:                   & 'sig', attrname = 'standard_name', &     ! (in)
  1339:                   & value = 'atmosphere_sigma_coordinate', & ! (in)
  1340:                   & history = gthst_rst )                    ! (inout)
  1341:                 call HistoryAddAttr( &
  1342:                   & 'sigm', attrname = 'standard_name', &    ! (in)
  1343:                   & value = 'atmosphere_sigma_coordinate', & ! (in)
  1344:                   & history = gthst_rst )                    ! (inout)
  1345:                 call HistoryAddAttr( &
  1346:                   & 'time', attrname = 'standard_name', &    ! (in)
  1347:                   & value = 'time', &                        ! (in)
  1348:                   & history = gthst_rst )                    ! (inout)
  1349:                 call HistoryAddAttr( &
  1350:                   & 'sig', attrname = 'positive', &          ! (in)
  1351:                   & value = 'down', &                        ! (in)
  1352:                   & history = gthst_rst )                    ! (inout)
  1353:                 call HistoryAddAttr( &
  1354:                   & 'sigm', attrname = 'positive', &         ! (in)
  1355:                   & value = 'down', &                        ! (in)
  1356:                   & history = gthst_rst )                    ! (inout)
  1357:             
  1358: V====== A       call HistoryPut( &
  1359:                   & 'lon', x_Lon / PI * 180.0_DP, & ! (in)
  1360:                   & history = gthst_rst )           ! (inout)
  1361: V====== A       call HistoryPut( &
  1362:                   & 'lat', y_Lat / PI * 180.0_DP, & ! (in)
  1363:                   & history = gthst_rst )           ! (inout)
  1364:                 call HistoryPut( &
  1365:                   & 'sig', z_Sigma, &               ! (in)
  1366:                   & history = gthst_rst )           ! (inout)
  1367:                 call HistoryPut( & 
  1368:                   & 'sigm', r_Sigma, &              ! (in)
  1369:                   & history = gthst_rst )           ! (inout)
  1370:                 call HistoryPut( & 
  1371:                   & 'sorbl', (/ 0, 1 /), &          ! (in)
  1372:                   & history = gthst_rst )           ! (inout)
  1373:             
  1374:                 ! 座標重みの設定
  1375:                 ! Axes weights settings
  1376:                 !
  1377:                 call HistoryAddVariable( 'lon_weight', &               ! (in)
  1378:                   & (/'lon'/), &                                       ! (in)
  1379:                   & 'weight for integration in longitude', 'radian', & ! (in)
  1380:                   & xtype = 'double', &                                ! (in)
  1381:                   & history = gthst_rst )                              ! (inout)
  1382:                 call HistoryAddAttr( &
  1383:                   & 'lon', attrname = 'gt_calc_weight', &     ! (in)
  1384:                   & value = 'lon_weight', &                   ! (in)
  1385:                   & history = gthst_rst )                     ! (inout)
  1386:                 call HistoryPut( &
  1387:                   & 'lon_weight', x_Lon_Weight, &             ! (in)
  1388:                   & history = gthst_rst )                     ! (inout)
  1389:             
  1390:                 call HistoryAddVariable( 'lat_weight', &                      ! (in)
  1391:                   & (/'lat'/), &                                              ! (in)
  1392:                   & 'weight for integration in latitude', units = 'radian', & ! (in)
  1393:                   & xtype = 'double', &                                       ! (in)
  1394:                   & history = gthst_rst )                                     ! (inout)
  1395:                 call HistoryAddAttr( &
  1396:                   & 'lat', attrname = 'gt_calc_weight', &     ! (in)
  1397:                   & value = 'lat_weight', &                   ! (in)
  1398:                   & history = gthst_rst )                     ! (inout)
  1399:                 call HistoryPut( &
  1400:                   & 'lat_weight', y_Lat_Weight, &             ! (in)
  1401:                   & history = gthst_rst )                     ! (inout)
  1402:             
  1403:                 call HistoryAddVariable( 'sig_weight', &      ! (in)
  1404:                   & (/'sig'/), &                              ! (in)
  1405:                   & 'weight for integration in sigma', '1', & ! (in)
  1406:                   & xtype = 'double', &                       ! (in)
  1407:                   & history = gthst_rst )                     ! (inout)
  1408:                 call HistoryAddAttr( &
  1409:                   & 'sig', attrname = 'gt_calc_weight', &     ! (in)
  1410:                   & value = 'sig_weight', &                   ! (in)
  1411:                   & history = gthst_rst )                     ! (inout)
  1412:                 call HistoryPut( &
  1413:                   & 'sig_weight', z_DelSigma, &               ! (in)
  1414:                   & history = gthst_rst )                     ! (inout)
  1415:             
  1416:                 call HistoryAddVariable( 'PrevTimeLong', &      ! (in)
  1417:                   & (/ 'time' /), &                             ! (in)
  1418:                   & 'previous time at which longwave flux is calculated', & ! (in)
  1419:                   & 'sec', &                                    ! (in)
  1420:                   & xtype = 'double', &                         ! (in)
  1421:                   & history = gthst_rst )                       ! (inout)
  1422:                 call HistoryAddVariable( 'PrevTimeShort', &     ! (in)
  1423:                   & (/ 'time' /), &                             ! (in)
  1424:                   & 'previous time at which shortwave flux is calculated', & ! (in)
  1425:                   & 'sec', &                                    ! (in)
  1426:                   & xtype = 'double', &                         ! (in)
  1427:                   & history = gthst_rst )                       ! (inout)
  1428:             
  1429:                 call HistoryAddVariable( 'SurfTemp', &          ! (in)
  1430:                   & (/ 'lon ', 'lat ', 'time' /), &             ! (in)
  1431:                   & 'surface temperature', 'K', &               ! (in)
  1432:                   & xtype = 'double', &                         ! (in)
  1433:                   & history = gthst_rst )                       ! (inout)
  1434:                 call HistoryAddVariable( 'RadSUwFlux', &        ! (in)
  1435:                   & (/ 'lon ', 'lat ', 'sigm', 'time' /), &     ! (in)
  1436:                   & 'upward shortwave flux', 'W m-2', &         ! (in)
  1437:                   & xtype = 'double', &                         ! (in)
  1438:                   & history = gthst_rst )                       ! (inout)
  1439:                 call HistoryAddVariable( 'RadSDwFlux', &        ! (in)
  1440:                   & (/ 'lon ', 'lat ', 'sigm', 'time' /), &     ! (in)
  1441:                   & 'downward shortwave flux', 'W m-2', &       ! (in)
  1442:                   & xtype = 'double', &                         ! (in)
  1443:                   & history = gthst_rst )                       ! (inout)
  1444:                 call HistoryAddVariable( 'RadLUwFlux', &        ! (in)
  1445:                   & (/ 'lon ', 'lat ', 'sigm', 'time' /), &     ! (in)
  1446:                   & 'upward longwave flux', 'W m-2', &          ! (in)
  1447:                   & xtype = 'double', &                         ! (in)
  1448:                   & history = gthst_rst )                       ! (inout)
  1449:                 call HistoryAddVariable( 'RadLDwFlux', &        ! (in)
  1450:                   & (/ 'lon ', 'lat ', 'sigm', 'time' /), &     ! (in)
  1451:                   & 'downward longwave flux', 'W m-2', &        ! (in)
  1452:                   & xtype = 'double', &                         ! (in)
  1453:                   & history = gthst_rst )                       ! (inout)
  1454:                 call HistoryAddVariable( 'DelRadLUwFlux', &                           ! (in)
  1455:                   & (/ 'lon  ', 'lat  ', 'sigm ', 'sorbl', 'time ' /), &              ! (in)
  1456:                   & 'longwave flux tendency with surface temperature', 'W m-2 K-1', & ! (in)
  1457:                   & xtype = 'double', &                                               ! (in)
  1458:                   & history = gthst_rst )                                             ! (inout)
  1459:                 call HistoryAddVariable( 'DelRadLDwFlux', &                           ! (in)
  1460:                   & (/ 'lon  ', 'lat  ', 'sigm ', 'sorbl', 'time ' /), &              ! (in)
  1461:                   & 'longwave flux tendency with surface temperature', 'W m-2 K-1', & ! (in)
  1462:                   & xtype = 'double', &                                               ! (in)
  1463:                   & history = gthst_rst )                                             ! (inout)
  1464:             
  1465:             
  1466:             
  1467:                 ! Initialization of modules used in this module
  1468:                 !
  1469:             
  1470:                 ! 短波入射 (太陽入射)
  1471:                 ! Short wave (insolation) incoming
  1472:                 !
  1473:                 call RadShortIncomeInit
  1474:             
  1475:                 ! 散乱を無視した放射伝達方程式
  1476:                 ! Radiative transfer equation without considering scattering
  1477:                 !
  1478:                 call RadRTENonScatInit
  1479:             
  1480:             
  1481:                 ! 印字 ; Print
  1482:                 !
  1483:                 call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
  1484:                 call MessageNotify( 'M', module_name, 'Restart:' )
  1485:             
  1486:                 if ( trim(RstInputFile) == '' ) then
  1487:                   call MessageNotify( 'M', module_name, '  InputFile  = <no input>', c1 = trim( RstInputFile ) )
  1488:                 else
  1489:                   call MessageNotify( 'M', module_name, '  InputFile       = %c', c1 = trim( RstInputFile ) )
  1490:                   call MessageNotify( 'M', module_name, '    PrevTimeLong  = %f [%c]', &
  1491:                   & d = (/ PrevTimeLong /), c1 = 'sec' )
  1492:                   call MessageNotify( 'M', module_name, '    PrevTimeShort = %f [%c]', &
  1493:                   & d = (/ PrevTimeShort /), c1 = 'sec' )
  1494:                 end if
  1495:             
  1496:                 call MessageNotify( 'M', module_name, '  OutputFile = %c', c1 = trim( RstOutputFile ) )
  1497:                 call MessageNotify( 'M', module_name, '  IntTime    = %f [%c] (same as IntTime in "restart_file_io" module)', &
  1498:                   & d = (/ RstFileIntValue /), c1 = trim( RstFileIntUnit ) )
  1499:             !
  1500:                 call MessageNotify( 'M', module_name, '  SolarConst   = %f', d = (/ SolarConst /) )
  1501:                 call MessageNotify( 'M', module_name, 'DelTime:' )
  1502:                 call MessageNotify( 'M', module_name, '  DelTimeLong  = %f [%c]', &
  1503:                   & d = (/ DelTimeLongValue /), c1 = trim( DelTimeLongUnit ) )
  1504:                 call MessageNotify( 'M', module_name, '  DelTimeShort = %f [%c]', &
  1505:                   & d = (/ DelTimeShortValue /), c1 = trim( DelTimeShortUnit ) )
  1506:             !
  1507:                 call MessageNotify( 'M', module_name, 'LongFlux:' )
  1508:                 call MessageNotify( 'M', module_name, '  LongBandNum            = %d', i = (/ LongBandNum /) )
  1509: V====== A       call MessageNotify( 'M', module_name, '  LongAbsorpCoefQVap     = (/ %*r /)', &
  1510:                   & r = real( LongAbsorpCoefQVap(1:LongBandNum) ), n = (/ LongBandNum /) )
  1511: V====== A       call MessageNotify( 'M', module_name, '  LongAbsorpCoefDryAir   = (/ %*r /)', &
  1512:                   & r = real( LongAbsorpCoefDryAir(1:LongBandNum) ), n = (/ LongBandNum /) )
  1513: V====== A       call MessageNotify( 'M', module_name, '  LongBandWeight         = (/ %*r /)', &
  1514:                   & r = real( LongBandWeight(1:LongBandNum) ), n = (/ LongBandNum /) )
  1515:                 call MessageNotify( 'M', module_name, '  LongPathLengthFact     = %f', d = (/ LongPathLengthFact /) )
  1516:             !
  1517:                 call MessageNotify( 'M', module_name, 'ShortFlux:' )
  1518:                 call MessageNotify( 'M', module_name, '  ShortBandNum           = %d', i = (/ ShortBandNum /) )
  1519: V====== A       call MessageNotify( 'M', module_name, '  ShortAbsorpCoefQVap    = (/ %*r /)', &
  1520:                   & r = real( ShortAbsorpCoefQVap(1:ShortBandNum) ), n = (/ ShortBandNum /) )
  1521: V====== A       call MessageNotify( 'M', module_name, '  ShortAbsorpCoefDryAir  = (/ %*r /)', &
  1522:                   & r = real( ShortAbsorpCoefDryAir(1:ShortBandNum) ), n = (/ ShortBandNum /) )
  1523: V====== A       call MessageNotify( 'M', module_name, '  ShortBandWeight        = (/ %*r /)', &
  1524:                   & r = real( ShortBandWeight(1:ShortBandNum) ), n = (/ ShortBandNum /) )
  1525:                 call MessageNotify( 'M', module_name, '  ShortSecScat           = %f', d = (/ ShortSecScat /) )
  1526:                 call MessageNotify( 'M', module_name, '  ShortAtmosAlbedo       = %f', d = (/ ShortAtmosAlbedo /) )
  1527:             
  1528:                 call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
  1529:             
  1530:                 rad_DennouAGCM_inited = .true.
  1531:             
  1532:               end subroutine RadDennouAGCMInit
  1533:             
  1534:               !--------------------------------------------------------------------------------------
  1535:             
  1536:               subroutine RadDennouAGCMFinalize
  1537:                 !
  1538:                 ! リスタートファイルのクローズと, 
  1539:                 ! モジュール内部の変数の割り付け解除を行います. 
  1540:                 !
  1541:                 ! Close a restart file, and 
  1542:                 ! deallocate variables in this module. 
  1543:                 !
  1544:             
  1545:                 ! モジュール引用 ; USE statements
  1546:                 !
  1547:             
  1548:                 ! リスタートデータ入出力
  1549:                 ! Restart data input/output
  1550:                 !
  1551:                 use gtool_history, only: HistoryClose
  1552:             
  1553:                 ! 宣言文 ; Declaration statements
  1554:                 !
  1555:                 implicit none
  1556:             
  1557:                 ! 実行文 ; Executable statement
  1558:                 !
  1559:             
  1560:                 if ( .not. rad_DennouAGCM_inited ) return
  1561:             
  1562:             
  1563:                 ! デフォルト値へ戻す
  1564:                 ! Return to default values
  1565:                 !
  1566:                 Old_Flux_saved = .false.
  1567:             
  1568:                 ! リスタートファイルのクローズ
  1569:                 ! close a restart file
  1570:                 !
  1571:                 call HistoryClose( history = gthst_rst ) ! (inout)
  1572:             
  1573:                 ! 割り付け解除
  1574:                 ! Deallocation
  1575:                 !
  1576:                 if ( allocated( xy_IncomRadSFlux       ) ) deallocate( xy_IncomRadSFlux       )
  1577:                 if ( allocated( xy_InAngle             ) ) deallocate( xy_InAngle             )
  1578:                 if ( allocated( xy_TempSave            ) ) deallocate( xy_TempSave            )
  1579:                 if ( allocated( xyr_RadSUwFluxSave     ) ) deallocate( xyr_RadSUwFluxSave     )
  1580:                 if ( allocated( xyr_RadSDwFluxSave     ) ) deallocate( xyr_RadSDwFluxSave     )
  1581:                 if ( allocated( xyr_RadLUwFluxSave     ) ) deallocate( xyr_RadLUwFluxSave     )
  1582:                 if ( allocated( xyr_RadLDwFluxSave     ) ) deallocate( xyr_RadLDwFluxSave     )
  1583:                 if ( allocated( xyra_DelRadLUwFluxSave ) ) deallocate( xyra_DelRadLUwFluxSave )
  1584:                 if ( allocated( xyra_DelRadLDwFluxSave ) ) deallocate( xyra_DelRadLDwFluxSave )
  1585:             
  1586:                 rad_DennouAGCM_inited = .false.
  1587:             
  1588:             
  1589:               end subroutine RadDennouAGCMFinalize
  1590:             
  1591:               !--------------------------------------------------------------------------------------
  1592:             
  1593:             end module rad_DennouAGCM
