Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:53 2016
FILE NAME: rad_Earth_LW_V2_4.f90
PROGRAM NAME: rad_earth_lw_v2_4
DIAGNOSTIC LIST

  LINE  LEVEL( NO.): DIAGNOSTIC MESSAGE

   349  vec  (   3): Unvectorized loop.
   351  opt  (1593): Loop nest collapsed into one loop.
   351  vec  (   4): Vectorized array expression.
   351  vec  (  29): ADB is used for array.: xyrr_trans
   361  opt  (1017): Subroutine call prevents optimization.
   365  opt  (1593): Loop nest collapsed into one loop.
   365  vec  (   4): Vectorized array expression.
   365  vec  (  29): ADB is used for array.: xyrr_trans
   365  vec  (  29): ADB is used for array.: xyrr_transeach
   381  opt  (1592): Outer loop unrolled inside inner loop.
   381  vec  (   4): Vectorized array expression.
   381  vec  (  29): ADB is used for array.: xyrr_trans
   381  vec  (  29): ADB is used for array.: xyrr_transeach
   381  vec  (   4): Vectorized array expression.
   381  vec  (  29): ADB is used for array.: xyrr_trans
   381  vec  (  29): ADB is used for array.: xyrr_transeach
   391  opt  (1593): Loop nest collapsed into one loop.
   391  vec  (   4): Vectorized array expression.
   391  vec  (  29): ADB is used for array.: xyrr_trans
   391  vec  (  29): ADB is used for array.: xyrr_transeach
   398  opt  (1593): Loop nest collapsed into one loop.
   398  vec  (   4): Vectorized array expression.
   398  vec  (  29): ADB is used for array.: xyrr_trans
   398  vec  (  29): ADB is used for array.: xyrr_transeach
   408  opt  (1593): Loop nest collapsed into one loop.
   408  vec  (   4): Vectorized array expression.
   408  vec  (  29): ADB is used for array.: xyrr_trans
   408  vec  (  29): ADB is used for array.: xyrr_transeach
   413  opt  (1592): Outer loop unrolled inside inner loop.
   413  vec  (   4): Vectorized array expression.
   413  vec  (  26): Macro operation Max/Min.
   413  vec  (  29): ADB is used for array.: xyz_deln2omass
   413  vec  (   4): Vectorized array expression.
   413  vec  (  26): Macro operation Max/Min.
   413  vec  (  29): ADB is used for array.: xyz_deln2omass
   419  opt  (1593): Loop nest collapsed into one loop.
   419  vec  (   4): Vectorized array expression.
   419  vec  (  29): ADB is used for array.: xyrr_trans
   419  vec  (  29): ADB is used for array.: xyrr_transeach
   425  opt  (1592): Outer loop unrolled inside inner loop.
   425  vec  (   4): Vectorized array expression.
   425  vec  (  26): Macro operation Max/Min.
   425  vec  (  29): ADB is used for array.: xyz_delch4mass
   425  vec  (   4): Vectorized array expression.
   425  vec  (  26): Macro operation Max/Min.
   425  vec  (  29): ADB is used for array.: xyz_delch4mass
   431  opt  (1593): Loop nest collapsed into one loop.
   431  vec  (   4): Vectorized array expression.
   431  vec  (  29): ADB is used for array.: xyrr_trans
   431  vec  (  29): ADB is used for array.: xyrr_transeach
   442  opt  (1593): Loop nest collapsed into one loop.
   442  vec  (   4): Vectorized array expression.
   442  vec  (  29): ADB is used for array.: xyrr_trans
   442  vec  (  29): ADB is used for array.: xyrr_transeach
   447  opt  (1592): Outer loop unrolled inside inner loop.
   447  vec  (   4): Vectorized array expression.
   447  vec  (  29): ADB is used for array.: xyrra_transsaved
   447  vec  (  29): ADB is used for array.: xyrr_trans
   447  vec  (   4): Vectorized array expression.
   447  vec  (  29): ADB is used for array.: xyrra_transsaved
   447  vec  (  29): ADB is used for array.: xyrr_trans
   459  opt  (  11): Fused array assignments. :line 459 - 461
   459  opt  (1592): Outer loop unrolled inside inner loop.
   459  vec  (   4): Vectorized array expression.
   459  vec  (  29): ADB is used for array.: xyrr_transmasaved
   459  vec  (  29): ADB is used for array.: xyrr_trans
   459  vec  (   4): Vectorized array expression.
   459  vec  (  29): ADB is used for array.: xyrr_transmasaved
   459  vec  (  29): ADB is used for array.: xyrr_trans
   471  opt  (1593): Loop nest collapsed into one loop.
   471  vec  (   4): Vectorized array expression.
   473  opt  (  11): Fused array assignments. :line 473 - 474
   473  opt  (1593): Loop nest collapsed into one loop.
   473  vec  (   4): Vectorized array expression.
   473  vec  (  29): ADB is used for array.: xyr_radldwflux
   473  vec  (  29): ADB is used for array.: xyr_radluwflux
   475  opt  (  11): Fused array assignments. :line 475 - 476
   475  opt  (1772): Loop nest fused with following nest(s).
   475  opt  (1593): Loop nest collapsed into one loop.
   475  vec  (   4): Vectorized array expression.
   475  vec  (  29): ADB is used for array.: xyra_delradldwflux
   475  vec  (  29): ADB is used for array.: xyra_delradluwflux
   479  vec  (   3): Unvectorized loop.
   482  opt  (1593): Loop nest collapsed into one loop.
   482  vec  (   4): Vectorized array expression.
   482  vec  (  29): ADB is used for array.: xyz_cloudreff
   482  vec  (  29): ADB is used for array.: xyz_cloudwatreff
   483  opt  (1017): Subroutine call prevents optimization.
   487  opt  (  11): Fused array assignments. :line 487 - 489
   487  opt  (1593): Loop nest collapsed into one loop.
   487  vec  (   4): Vectorized array expression.
   487  vec  (  29): ADB is used for array.: xyz_cloudreff
   487  vec  (  29): ADB is used for array.: xyz_cloudicereff
   487  vec  (  29): ADB is used for array.: xyz_delcloudwatoptdep
   487  vec  (  29): ADB is used for array.: xyz_delh2oliqmass
   487  vec  (  29): ADB is used for array.: xyz_cloudextcoef
   494  opt  (1593): Loop nest collapsed into one loop.
   494  vec  (   4): Vectorized array expression.
   494  vec  (  29): ADB is used for array.: xyz_delcloudiceoptdep
   494  vec  (  29): ADB is used for array.: xyz_delh2osolmass
   494  vec  (  29): ADB is used for array.: xyz_cloudextcoef
   514  opt  (1593): Loop nest collapsed into one loop.
   514  vec  (   4): Vectorized array expression.
   514  vec  (  29): ADB is used for array.: xyz_transcloudonelayer
   514  vec  (  29): ADB is used for array.: xyz_delcloudiceoptdep
   514  vec  (  29): ADB is used for array.: xyz_delcloudwatoptdep
   527  opt  (  11): Fused array assignments. :line 527 - 529
   527  opt  (1592): Outer loop unrolled inside inner loop.
   527  vec  (   4): Vectorized array expression.
   527  vec  (  29): ADB is used for array.: xyrr_trans
   527  vec  (  29): ADB is used for array.: xyrr_transcloud
   527  vec  (  29): ADB is used for array.: xyrra_transsaved
   527  vec  (   4): Vectorized array expression.
   527  vec  (  29): ADB is used for array.: xyrr_trans
   527  vec  (  29): ADB is used for array.: xyrr_transcloud
   527  vec  (  29): ADB is used for array.: xyrra_transsaved
   557  opt  (1593): Loop nest collapsed into one loop.
   557  vec  (   4): Vectorized array expression.
   557  vec  (  29): ADB is used for array.: xy_surfintpf
   558  opt  (1593): Loop nest collapsed into one loop.
   558  vec  (   4): Vectorized array expression.
   558  vec  (  29): ADB is used for array.: xyz_intpf
   559  opt  (  11): Fused array assignments. :line 559 - 560
   559  opt  (1593): Loop nest collapsed into one loop.
   559  vec  (   4): Vectorized array expression.
   559  vec  (  29): ADB is used for array.: xy_intdpfdt1
   559  vec  (  29): ADB is used for array.: xy_intdpfdt0
   687  opt  (  11): Fused array assignments. :line 687 - 688
   687  opt  (1593): Loop nest collapsed into one loop.
   687  vec  (   4): Vectorized array expression.
   687  vec  (  29): ADB is used for array.: xyr_radldwflux
   687  vec  (  29): ADB is used for array.: xyr_raddwflux
   687  vec  (  29): ADB is used for array.: xyr_radluwflux
   687  vec  (  29): ADB is used for array.: xyr_raduwflux
   689  opt  (  11): Fused array assignments. :line 689 - 690
   689  opt  (1772): Loop nest fused with following nest(s).
   689  opt  (1593): Loop nest collapsed into one loop.
   689  vec  (   4): Vectorized array expression.
   689  vec  (  29): ADB is used for array.: xyra_delradldwflux
   689  vec  (  29): ADB is used for array.: xyra_delraddwflux
   689  vec  (  29): ADB is used for array.: xyra_delradluwflux
   689  vec  (  29): ADB is used for array.: xyra_delraduwflux
   732  warn (  82): Name "xyz_intpf2" is not used.
   732  warn (  82): Name "i" is not used.
   732  warn (  82): Name "xyra_delradflux" is not used.
   732  warn (  82): Name "j" is not used.
   732  warn (  82): Name "xy_surfintpf2" is not used.
   732  warn (  82): Name "k" is not used.
   732  warn (  82): Name "xy_intdpfdt02" is not used.
   732  warn (  82): Name "xy_intdpfdt12" is not used.
   732  warn (  82): Name "xyr_radflux" is not used.
  1001  vec  (   1): Vectorized loop.
  1001  vec  (  29): ADB is used for array.: aa_bandparam
  1112  vec  (   1): Vectorized loop.
  1112  vec  (  29): ADB is used for array.: a_tabletemp
  1117  opt  (1593): Loop nest collapsed into one loop.
  1117  vec  (   4): Vectorized array expression.
  1117  vec  (  29): ADB is used for array.: aa_tableipf
  1118  opt  (1593): Loop nest collapsed into one loop.
  1118  vec  (   4): Vectorized array expression.
  1118  vec  (  29): ADB is used for array.: aa_tableidpfdt
  1128  vec  (   3): Unvectorized loop.
  1129  opt  (1025): Reference to this function inhibits optimization.
  1129  vec  (  10): Vectorization obstructive procedure reference.:pf
  1131  vec  (  10): Vectorization obstructive procedure reference.:dpfdt
  1146  opt  (1593): Loop nest collapsed into one loop.
  1146  vec  (   4): Vectorized array expression.
  1146  vec  (  29): ADB is used for array.: xy_temptmp
  1161  vec  (   1): Vectorized loop.
  1161  vec  (  29): ADB is used for array.: xy_temptmp
  1170  opt  (1593): Loop nest collapsed into one loop.
  1170  vec  (   1): Vectorized loop.
  1170  vec  (  29): ADB is used for array.: xy_temptmp
  1205  vec  (   3): Unvectorized loop.
  1209  opt  (1017): Subroutine call prevents optimization.
  1209  vec  (  10): Vectorization obstructive procedure reference.:messagenotifyc
  1215  vec  (  10): Vectorization obstructive procedure reference.:messagenotifyc
  1256  opt  (1593): Loop nest collapsed into one loop.
  1256  vec  (   1): Vectorized loop.
  1256  vec  (  29): ADB is used for array.: xyz_temp
  1256  vec  (  29): ADB is used for array.: xy_temp
  1267  opt  (1593): Loop nest collapsed into one loop.
  1267  vec  (   1): Vectorized loop.
  1267  vec  (  29): ADB is used for array.: xy_integpf
  1267  vec  (  29): ADB is used for array.: xyz_integpf
  1313  vec  (   3): Unvectorized loop.
  1317  opt  (1017): Subroutine call prevents optimization.
  1317  vec  (  10): Vectorization obstructive procedure reference.:messagenotifyc
  1353  opt  (1593): Loop nest collapsed into one loop.
  1353  vec  (   1): Vectorized loop.
  1353  vec  (  29): ADB is used for array.: xyz_integpf
  1353  vec  (  29): ADB is used for array.: a_tabletemp
  1353  vec  (  29): ADB is used for array.: xyz_temp
  1353  vec  (  29): ADB is used for array.: aa_tableipf
  1384  opt  (1593): Loop nest collapsed into one loop.
  1384  vec  (   1): Vectorized loop.
  1384  vec  (  29): ADB is used for array.: xyz_integpf
  1384  vec  (  29): ADB is used for array.: a_tabletemp
  1384  vec  (  29): ADB is used for array.: xyz_temp
  1384  vec  (  29): ADB is used for array.: aa_tableidpfdt
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:53 2016
FILE NAME: rad_Earth_LW_V2_4.f90
PROGRAM NAME: rad_earth_lw_v2_4
TRANSFORMATION LIST

  LINE                   FORTRAN STATEMENT

     1  != 地球大気向け長波放射モデル Ver. 2.4
     2  !
     3  != long wave radiation model for the Earth's atmosphere Ver. 2.4
     4  !
     5  ! Authors::   Yoshiyuki O. TAKAHASHI
     6  ! Version::   $Id: rad_Earth_LW_V2_4.f90,v 1.3 2015/01/29 12:06:43 yot Exp $
     7  ! Tag Name::  $Name:  $
     8  ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9  ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10  !
    11  
    12  module rad_Earth_LW_V2_4
    13    !
    14    != 地球大気向け長波放射モデル Ver. 2.4
    15    !
    16    != long wave radiation model for the Earth's atmosphere Ver. 2.4
    17    !
    18    ! <b>Note that Japanese and English are described in parallel.</b>
    19    !
    20    ! 長波放射モデル.
    21    !
    22    ! This is a model of long wave radiation for the Earth's atmospehre.
    23    ! Radiation in the wavenumber range from    0 to  3000 cm-1
    24    ! is calculated following the scheme by Chou et al. (2001).
    25    ! But absorptions by CFC and weak bands desinated as band 10 in Chou et al. (2001) are neglected.
    26    !
    27    !== References
    28    !
    29    !  Chou, M.-D., M. J. Suarez, X.-Z. Liang, and M. M.-H. Yan,
    30    !    A thermal infrared radiation parameterization for atmospheric studies,
    31    !    NASA Technical Report Series on Global Modeling and Data Assimilation,
    32    !    19, NASA/TM-2001-104606, 2001.
    33    !
    34    !== Procedures List
    35    !
    36    ! RadEarthLWV24Flux :: 放射フラックスの計算
    37    ! ------------      :: ------------
    38    ! RadEarthLWV24Flux :: Calculate radiation flux
    39    !
    40    !== NAMELIST
    41    !
    42    ! NAMELIST#rad_Earth_LW_V2_4_nml
    43    !
    44  
    45    ! USE statements
    46    !
    47  
    48    !
    49    ! Kind type parameter
    50    !
    51    use dc_types, only: DP, &      ! Double precision.
    52      &                 STRING, &  ! Strings.
    53      &                 TOKEN      ! Keywords.
    54  
    55    ! 物理・数学定数設定
    56    ! Physical and mathematical constants settings
    57    !
    58    use constants0, only: &
    59      & PI                    ! $ \pi $ .
    60                              ! 円周率.  Circular constant
    61  
    62    !
    63    ! Grid points settings
    64    !
    65    use gridset, only: imax, & !
    66                               ! Number of grid points in longitude
    67      &                jmax, & !
    68                               ! Number of grid points in latitude
    69      &                kmax    !
    70                               ! Number of vertical level
    71  
    72  
    73    ! Declaration statements
    74    !
    75    implicit none
    76    private
    77  
    78    !
    79    ! Public procedure
    80    !
    81    public :: RadEarthLWV24Flux
    82    public :: RadEarthLWV24Init
    83  
    84  
    85    character(*), parameter:: module_name = 'rad_Earth_LW_V2_4'
    86                                ! モジュールの名称.
    87                                ! Module name
    88    character(*), parameter:: version = &
    89      & '$Name:  $' // &
    90      & '$Id: rad_Earth_LW_V2_4.f90,v 1.3 2015/01/29 12:06:43 yot Exp $'
    91                                ! モジュールのバージョン
    92                                ! Module version
    93  
    94  
    95    logical , save :: FlagHighAlt
    96  
    97  
    98    integer , parameter :: nbmax = 10
    99    real(DP), save      :: aa_BandParam(1:2, 1:nbmax)
   100  
   101    real(DP), allocatable, save :: xyrra_TransSaved (:,:,:,:,:)
   102    real(DP), allocatable, save :: xyrr_TransMASaved(:,:,:,:)
   103  
   104    real(DP), parameter :: DiffFactor = 1.66d0
   105  
   106  
   107  
   108    ! MEMO:
   109    ! Bands range from 0 to 3000 cm-1.
   110    !
   111    data aa_BandParam &
   112      & / &
   113      &    0.0d0,  340.0d0, & ! 1:H2O
   114      &  340.0d0,  540.0d0, & ! 2:H2O
   115      &  540.0d0,  800.0d0, & ! 3:H2O + CO2
   116      &  800.0d0,  980.0d0, & ! 4:H2O (+ CO2)
   117      &  980.0d0, 1100.0d0, & ! 5:H2O (+ CO2) + O3
   118      & 1100.0d0, 1215.0d0, & ! 6:H2O + N2O + CH4
   119      & 1215.0d0, 1380.0d0, & ! 7:H2O + N2O + CH4
   120      & 1380.0d0, 1900.0d0, & ! 8:H2O
   121      & 1900.0d0, 3000.0d0, & ! 9:H2O
   122      &  540.0d0,  620.0d0  & !10:H2O + CO2, N2O  ! This band is not used, now.
   123      & /
   124  
   125  
   126    logical , save:: flag_save_time
   127  
   128  
   129    real(DP), save:: IntTimeSave
   130                                ! 長波フラックスを計算する時間間隔.
   131                                ! Interval time of long wave flux calculation
   132    real(DP), save:: PrevTimeSave
   133                                ! 前回長波フラックスを計算した時刻.
   134                                ! Time when long wave flux is calculated
   135  
   136  
   137    logical              , save:: FlagTransSaved
   138    data FlagTransSaved / .false. /
   139  
   140  
   141  
   142    ! Variables for integration of Planc function by using a pre-calculated table.
   143    !
   144    integer , save              :: ntmax
   145    real(DP), save, allocatable :: a_TableTemp   (:)
   146    real(DP), save              :: TableTempMin
   147    real(DP), save              :: TableTempMax
   148    real(DP), save              :: TableTempIncrement
   149    real(DP), save, allocatable :: aa_TableIPF   (:,:)
   150    real(DP), save, allocatable :: aa_TableIDPFDT(:,:)
   151  
   152  
   153  
   154    ! 公開変数
   155    ! Public variables
   156    !
   157    logical, save :: rad_Earth_LW_V2_4_inited = .false.
   158                                ! 初期設定フラグ.
   159                                ! Initialization flag
   160  
   161  
   162  
   163  contains
   164  
   165    !--------------------------------------------------------------------------------------
   166  
   167    subroutine RadEarthLWV24Flux(                                &
   168      & xyz_DelCO2Mass,                                          & ! (in )
   169      & xyz_DelH2OVapMass, xyz_DelH2OLiqMass, xyz_DelH2OSolMass, & ! (in )
   170      & xyz_DelO3Mass,                                           & ! (in )
   171      & xyz_DelN2OMass, xyz_DelCH4Mass,                          & ! (in )
   172      & xyz_Press, xyz_Temp, xy_SurfTemp,                        & ! (in )
   173      & xyz_QCO2, xyz_QH2OVap,                                   & ! (in )
   174      & xyz_QN2O, xyz_QCH4,                                      & ! (in )
   175      & xyz_CloudCover,                                          & ! (in )
   176      & xyz_CloudWatREff, xyz_CloudIceREff,                      & ! (in )
   177      & xyr_RadLUwFlux, xyr_RadLDwFlux,                          & ! (out)
   178      & xyra_DelRadLUwFlux, xyra_DelRadLDwFlux                   & ! (out)
   179      & )
   180  
   181  
   182      ! USE statements
   183      !
   184  
   185      ! メッセージ出力
   186      ! Message output
   187      !
   188      use dc_message, only: MessageNotify
   189  
   190      ! 時刻管理
   191      ! Time control
   192      !
   193      use timeset, only: &
   194        & TimeN, &              ! ステップ $ t $ の時刻.
   195                                ! Time of step $ t $.
   196        & TimesetClockStart, TimesetClockStop
   197  
   198  
   199  !!$    ! Chou et al (1991) による長波放射モデル
   200  !!$    ! Long radiation model described by Chou et al (1991)
   201  !!$    !
   202  !!$    use rad_C1991, only :               &
   203  !!$      & RadC1991CalcTransMAH2O
   204  
   205      ! Chou and Kouvaris (1991) による長波放射モデル
   206      ! Long radiation model described by Chou and Kouvaris (1991)
   207      !
   208      use rad_CK1991, only : RadCK1991CalcTrans
   209  
   210      ! Chou et al. (2001) による長波放射モデル
   211      ! Long radiation model described by Chou et al. (2001)
   212      !
   213      use rad_C2001, only :          &
   214        & RadC2001CalcTransBand3CO2, &
   215        & RadC2001CalcTransBand3H2O, &
   216        & RadC2001CalcTrans,         &
   217        & RadC2001ReduceCloudOptDep, &
   218        & RadC2001CalcCloudOptProp , &
   219        & RadC2001CalcIntegratedPF2D, &
   220        & RadC2001CalcIntegratedPF3D
   221  
   222      ! 散乱を無視した放射伝達方程式
   223      ! Radiative transfer equation without considering scattering
   224      !
   225      use rad_rte_nonscat, only : RadRTENonScat !, RadRTENonScatAnotherForm
   226  
   227      ! 雲関系ルーチン
   228      ! Cloud-related routines
   229      !
   230      use cloud_utils, only :         &
   231        & CloudUtilsLocalizeCloud,    &
   232        & CloudUtilsCalcOverlapCloudTrans
   233  
   234  
   235      real(DP), intent(in ):: xyz_DelCO2Mass   (0:imax-1, 1:jmax, 1:kmax)
   236      real(DP), intent(in ):: xyz_DelH2OVapMass(0:imax-1, 1:jmax, 1:kmax)
   237      real(DP), intent(in ):: xyz_DelH2OLiqMass(0:imax-1, 1:jmax, 1:kmax)
   238      real(DP), intent(in ):: xyz_DelH2OSolMass(0:imax-1, 1:jmax, 1:kmax)
   239      real(DP), intent(in ):: xyz_DelO3Mass    (0:imax-1, 1:jmax, 1:kmax)
   240      real(DP), intent(in ):: xyz_DelN2OMass   (0:imax-1, 1:jmax, 1:kmax)
   241      real(DP), intent(in ):: xyz_DelCH4Mass   (0:imax-1, 1:jmax, 1:kmax)
   242      real(DP), intent(in ):: xyz_Press        (0:imax-1, 1:jmax, 1:kmax)
   243      real(DP), intent(in ):: xyz_Temp         (0:imax-1, 1:jmax, 1:kmax)
   244      real(DP), intent(in ):: xy_SurfTemp      (0:imax-1, 1:jmax)
   245      real(DP), intent(in ):: xyz_QCO2         (0:imax-1, 1:jmax, 1:kmax)
   246      real(DP), intent(in ):: xyz_QH2OVap      (0:imax-1, 1:jmax, 1:kmax)
   247      real(DP), intent(in ):: xyz_QN2O         (0:imax-1, 1:jmax, 1:kmax)
   248      real(DP), intent(in ):: xyz_QCH4         (0:imax-1, 1:jmax, 1:kmax)
   249      real(DP), intent(in ):: xyz_CloudCover   (0:imax-1, 1:jmax, 1:kmax)
   250      real(DP), intent(in ):: xyz_CloudWatREff (0:imax-1, 1:jmax, 1:kmax)
   251      real(DP), intent(in ):: xyz_CloudIceREff (0:imax-1, 1:jmax, 1:kmax)
   252      real(DP), intent(out):: xyr_RadLUwFlux    (0:imax-1, 1:jmax, 0:kmax)
   253      real(DP), intent(out):: xyr_RadLDwFlux    (0:imax-1, 1:jmax, 0:kmax)
   254      real(DP), intent(out):: xyra_DelRadLUwFlux(0:imax-1, 1:jmax, 0:kmax, 0:1)
   255      real(DP), intent(out):: xyra_DelRadLDwFlux(0:imax-1, 1:jmax, 0:kmax, 0:1)
   256  
   257  
   258      !
   259      ! Work variables
   260      !
   261      real(DP) :: xy_SurfEmis       (0:imax-1, 1:jmax)
   262  
   263      real(DP) :: xyz_CloudREff     (0:imax-1, 1:jmax, 1:kmax)
   264      real(DP) :: xyz_CloudExtCoef  (0:imax-1, 1:jmax, 1:kmax)
   265  
   266      real(DP) :: xyz_CloudWatSSA      (0:imax-1, 1:jmax, 1:kmax)
   267      real(DP) :: xyz_CloudIceSSA      (0:imax-1, 1:jmax, 1:kmax)
   268      real(DP) :: xyz_CloudWatAF       (0:imax-1, 1:jmax, 1:kmax)
   269      real(DP) :: xyz_CloudIceAF       (0:imax-1, 1:jmax, 1:kmax)
   270  
   271      real(DP) :: xyz_DelCloudWatOptDep(0:imax-1, 1:jmax, 1:kmax)
   272      real(DP) :: xyz_DelCloudIceOptDep(0:imax-1, 1:jmax, 1:kmax)
   273  
   274      real(DP) :: xyz_TransCloudOneLayer (0:imax-1, 1:jmax, 1:kmax)
   275      real(DP) :: xyrr_TransCloud        (0:imax-1, 1:jmax, 0:kmax, 0:kmax)
   276  
   277      real(DP) :: xyrr_Trans            (0:imax-1, 1:jmax, 0:kmax, 0:kmax)
   278      real(DP) :: xyrr_TransEach        (0:imax-1, 1:jmax, 0:kmax, 0:kmax)
   279      real(DP) :: xyr_RadFlux           (0:imax-1, 1:jmax, 0:kmax)
   280      real(DP) :: xyra_DelRadFlux       (0:imax-1, 1:jmax, 0:kmax, 0:1)
   281  
   282      real(DP) :: xyz_IntPF   (0:imax-1, 1:jmax, 1:kmax)
   283      real(DP) :: xy_SurfIntPF(0:imax-1, 1:jmax)
   284      real(DP) :: xy_IntDPFDT0(0:imax-1, 1:jmax)
   285      real(DP) :: xy_IntDPFDT1(0:imax-1, 1:jmax)
   286  
   287  
   288  !!$    real(DP) :: xyr_RadFluxMA    (0:imax-1, 1:jmax, 0:kmax)
   289  !!$    real(DP) :: xyra_DelRadFluxMA(0:imax-1, 1:jmax, 0:kmax, 0:1)
   290  
   291      real(DP) :: xyz_IntPF2   (0:imax-1, 1:jmax, 1:kmax)
   292      real(DP) :: xy_SurfIntPF2(0:imax-1, 1:jmax)
   293      real(DP) :: xy_IntDPFDT02(0:imax-1, 1:jmax)
   294      real(DP) :: xy_IntDPFDT12(0:imax-1, 1:jmax)
   295  
   296  
   297      real(DP) :: xyr_RadUwFlux (0:imax-1, 1:jmax, 0:kmax)
   298      real(DP) :: xyr_RadDwFlux (0:imax-1, 1:jmax, 0:kmax)
   299      real(DP) :: xyra_DelRadUwFlux (0:imax-1, 1:jmax, 0:kmax, 0:1)
   300      real(DP) :: xyra_DelRadDwFlux (0:imax-1, 1:jmax, 0:kmax, 0:1)
   301  
   302  
   303      integer  :: n
   304  
   305      integer  :: i, j, k
   306  
   307  
   308      ! 初期化確認
   309      ! Initialization check
   310      !
   311      if ( .not. rad_Earth_LW_V2_4_inited ) then
   312        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   313      end if
   314  
   315  
   316      ! 計算時間計測開始
   317      ! Start measurement of computation time
   318      !
   319      call TimesetClockStart( module_name )
   320  
   321  
   322      ! Check whether the transmittance is saved or not
   323      !
   324      if (  .not. FlagTransSaved ) then
   325        if ( TimeN - PrevTimeSave >= IntTimeSave ) then
   326          call MessageNotify( 'M', module_name, &
   327            & 'Transmittance is not saved, but criterion for transmittance calculation is met.' )
   328        else
   329          call MessageNotify( 'M', module_name, &
   330            & 'Transmittance is not saved, and criterion for transmittance calculation ' &
   331            & // 'is not met. However, transmittance will be calculated.' )
   332        end if
   333      end if
   334  
   335  
   336      if ( ( TimeN - PrevTimeSave >= IntTimeSave ) .or. ( .not. FlagTransSaved ) ) then
   337  
   338  !!$      write( 6, * ) 'CalcTrans'
   339  
   340        if ( .not. FlagTransSaved ) then
   341          PrevTimeSave = TimeN
   342        else
   343          PrevTimeSave = PrevTimeSave + IntTimeSave
   344        end if
   345  
   346        FlagTransSaved = .true.
   347  
   348  
   349        LOOP_band_trans: do n = 1, nbmax
   350  
   351          xyrr_Trans = 1.0_DP
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1276 = 1, (xyrr_trans.DSC.U4 + 1)*(xyrr_trans.DSC.U3 + 1)*    
     .       1   xyrr_trans.DSC.U2*(xyrr_trans.DSC.U1 + 1)                      
     .           xyrr_trans(t1276-1,1,0,0) = 1.00000000000000e+000              
     .        enddo                                                             
   352  
   353          if ( n == nbmax ) then
   354  
   355            ! Now, nothing is done when n = nbmax.
   356  
   357          else if ( n == 3 ) then
   358            ! 540-800 cm-1
   359  
   360            !   Calculation of H2O line and continuum transmittance
   361            call RadC2001CalcTransBand3H2O(                          &
   362              & xyz_DelH2OVapMass, xyz_Press, xyz_Temp, xyz_QH2OVap, & ! (in)
   363              & xyrr_TransEach                                       & ! (out)
   364              & )
   365            xyrr_Trans = xyrr_Trans * xyrr_TransEach
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1444 = 1, (xyrr_trans.DSC.U4 + 1)*(xyrr_trans.DSC.U3 + 1)*    
     .       1   xyrr_trans.DSC.U2*(xyrr_trans.DSC.U1 + 1)                      
     .           xyrr_trans(t1444-1,1,0,0) = xyrr_trans(t1444-1,1,0,0)*         
     .       1      xyrr_transeach(t1444-1,1,0,0)                               
     .        enddo                                                             
   366            !   Calculation of CO2 transmittance
   367            if ( FlagHighAlt ) then
   368              ! Transmittance calculation for middle atmospehre as well as lower atmosphere
   369              call RadCK1991CalcTrans(                 &
   370                & xyz_DelCO2Mass, xyz_Press, xyz_Temp, & ! (in)
   371                & 'CO2',                               & ! (in)
   372                & xyrr_TransEach                       & ! (out)
   373                & )
   374            else
   375              ! Transmittance calculation for lower atmoshere
   376              call RadC2001CalcTransBand3CO2(                       &
   377                & xyz_DelCO2Mass, xyz_Press, xyz_Temp, xyz_QCO2,    & ! (in)
   378                & xyrr_TransEach                                    & ! (out)
   379                & )
   380            end if
   381            xyrr_Trans = xyrr_Trans * xyrr_TransEach
     .        if (1 + xyrr_trans.DSC.U2 - min0(1,xyrr_trans.DSC.U2) .gt. 0) then
     .           j1 = and(1 + xyrr_trans.DSC.U2 - min0(1,xyrr_trans.DSC.U2),3)  
     .  !cdir    nodep                                                          
     .           do t1468 = 1, j1                                               
     .  !cdir       nodep                                                       
     .              do t1470 = 1, xyrr_trans.DSC.U1 + 2 - min0(1,               
     .       1         xyrr_trans.DSC.U1 + 1)                                   
     .                 xyrr_trans(t1470-1,t1468,t1466,t1464) = xyrr_trans(t1470-
     .       1            1,t1468,t1466,t1464)*xyrr_transeach(t1470-1,t1468,    
     .       2            t1466,t1464)                                          
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t1468 = j1 + 1, 1 + xyrr_trans.DSC.U2 - min0(1,             
     .       1      xyrr_trans.DSC.U2), 4                                       
     .  !cdir       nodep                                                       
     .              do t1470 = 1, xyrr_trans.DSC.U1 + 2 - min0(1,               
     .       1         xyrr_trans.DSC.U1 + 1)                                   
     .                 xyrr_trans(t1470-1,t1468,t1466,t1464) = xyrr_trans(t1470-
     .       1            1,t1468,t1466,t1464)*xyrr_transeach(t1470-1,t1468,    
     .       2            t1466,t1464)                                          
     .                 xyrr_trans(t1470-1,t1468+1,t1466,t1464) = xyrr_trans(    
     .       1            t1470-1,t1468+1,t1466,t1464)*xyrr_transeach(t1470-1,  
     .       2            t1468+1,t1466,t1464)                                  
     .                 xyrr_trans(t1470-1,t1468+2,t1466,t1464) = xyrr_trans(    
     .       1            t1470-1,t1468+2,t1466,t1464)*xyrr_transeach(t1470-1,  
     .       2            t1468+2,t1466,t1464)                                  
     .                 xyrr_trans(t1470-1,t1468+3,t1466,t1464) = xyrr_trans(    
     .       1            t1470-1,t1468+3,t1466,t1464)*xyrr_transeach(t1470-1,  
     .       2            t1468+3,t1466,t1464)                                  
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
   382  
   383          else
   384  
   385            !   Calculation of H2O continuum transmittance
   386            call RadC2001CalcTrans(                                  &
   387              & 'H2OCont', n,                                        & ! (in)
   388              & xyz_DelH2OVapMass, xyz_Press, xyz_Temp, xyz_QH2OVap, & ! (in)
   389              & xyrr_TransEach                                       & ! (out)
   390              & )
   391            xyrr_Trans = xyrr_Trans * xyrr_TransEach
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1288 = 1, (xyrr_trans.DSC.U4 + 1)*(xyrr_trans.DSC.U3 + 1)*    
     .       1   xyrr_trans.DSC.U2*(xyrr_trans.DSC.U1 + 1)                      
     .           xyrr_trans(t1288-1,1,0,0) = xyrr_trans(t1288-1,1,0,0)*         
     .       1      xyrr_transeach(t1288-1,1,0,0)                               
     .        enddo                                                             
   392            !   Calculation of H2O line transmittance
   393            call RadC2001CalcTrans(                                  &
   394              & 'H2OLine', n,                                        & ! (in)
   395              & xyz_DelH2OVapMass, xyz_Press, xyz_Temp, xyz_QH2OVap, & ! (in)
   396              & xyrr_TransEach                                       & ! (out)
   397              & )
   398            xyrr_Trans = xyrr_Trans * xyrr_TransEach
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1308 = 1, (xyrr_trans.DSC.U4 + 1)*(xyrr_trans.DSC.U3 + 1)*    
     .       1   xyrr_trans.DSC.U2*(xyrr_trans.DSC.U1 + 1)                      
     .           xyrr_trans(t1308-1,1,0,0) = xyrr_trans(t1308-1,1,0,0)*         
     .       1      xyrr_transeach(t1308-1,1,0,0)                               
     .        enddo                                                             
   399  
   400            ! Calculation of O3 transmittance
   401            if ( n == 5 ) then
   402              ! 980-1100 cm-1
   403              call RadCK1991CalcTrans(                &
   404                & xyz_DelO3Mass, xyz_Press, xyz_Temp, & ! (in)
   405                & 'O3',                               & ! (in)
   406                & xyrr_TransEach                      & ! (out)
   407                & )
   408              xyrr_Trans = xyrr_Trans * xyrr_TransEach
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1424 = 1, (xyrr_trans.DSC.U4 + 1)*(xyrr_trans.DSC.U3 + 1)*    
     .       1   xyrr_trans.DSC.U2*(xyrr_trans.DSC.U1 + 1)                      
     .           xyrr_trans(t1424-1,1,0,0) = xyrr_trans(t1424-1,1,0,0)*         
     .       1      xyrr_transeach(t1424-1,1,0,0)                               
     .        enddo                                                             
   409            end if
   410  
   411            ! Calculation of N2O transmittance
   412            if ( ( n == 6 ) .or. ( n == 7 ) .or. ( n == 10 ) ) then
   413              if ( maxval( xyz_DelN2OMass ) > 0.0_DP ) then
     .        if (xyz_deln2omass.DSC.U2 .gt. 0) then                            
     .           j2 = and(xyz_deln2omass.DSC.U2,3)                              
     .  !cdir    nodep                                                          
     .           do t817 = 1, j2                                                
     .  !cdir       nodep                                                       
     .              do t819 = 1, xyz_deln2omass.DSC.U1 + 1                      
     .                 t813 = max(xyz_deln2omass(t819-1,t817,t815),t813)        
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t817 = j2 + 1, xyz_deln2omass.DSC.U2, 4                     
     .  !cdir       nodep                                                       
     .              do t819 = 1, xyz_deln2omass.DSC.U1 + 1                      
     .                 t813 = max(xyz_deln2omass(t819-1,t817,t815),             
     .       1            xyz_deln2omass(t819-1,t817+1,t815),xyz_deln2omass(t819
     .       2            -1,t817+2,t815),xyz_deln2omass(t819-1,t817+3,t815),   
     .       3            t813)                                                 
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
   414                call RadC2001CalcTrans(                                  &
   415                  & 'N2OLine', n,                                        & ! (in)
   416                  & xyz_DelN2OMass, xyz_Press, xyz_Temp, xyz_QN2O,       & ! (in)
   417                  & xyrr_TransEach                                       & ! (out)
   418                  & )
   419                xyrr_Trans = xyrr_Trans * xyrr_TransEach
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1404 = 1, (xyrr_trans.DSC.U4 + 1)*(xyrr_trans.DSC.U3 + 1)*    
     .       1   xyrr_trans.DSC.U2*(xyrr_trans.DSC.U1 + 1)                      
     .           xyrr_trans(t1404-1,1,0,0) = xyrr_trans(t1404-1,1,0,0)*         
     .       1      xyrr_transeach(t1404-1,1,0,0)                               
     .        enddo                                                             
   420              end if
   421            end if
   422  
   423            ! Calculation of CH4 transmittance
   424            if ( ( n == 6 ) .or. ( n == 7 ) ) then
   425              if ( maxval( xyz_DelCH4Mass ) > 0.0_DP ) then
     .        if (xyz_delch4mass.DSC.U2 .gt. 0) then                            
     .           j3 = and(xyz_delch4mass.DSC.U2,3)                              
     .  !cdir    nodep                                                          
     .           do t848 = 1, j3                                                
     .  !cdir       nodep                                                       
     .              do t850 = 1, xyz_delch4mass.DSC.U1 + 1                      
     .                 t844 = max(xyz_delch4mass(t850-1,t848,t846),t844)        
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t848 = j3 + 1, xyz_delch4mass.DSC.U2, 4                     
     .  !cdir       nodep                                                       
     .              do t850 = 1, xyz_delch4mass.DSC.U1 + 1                      
     .                 t844 = max(xyz_delch4mass(t850-1,t848,t846),             
     .       1            xyz_delch4mass(t850-1,t848+1,t846),xyz_delch4mass(t850
     .       2            -1,t848+2,t846),xyz_delch4mass(t850-1,t848+3,t846),   
     .       3            t844)                                                 
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
   426                call RadC2001CalcTrans(                                  &
   427                  & 'CH4Line', n,                                        & ! (in)
   428                  & xyz_DelCH4Mass, xyz_Press, xyz_Temp, xyz_QCH4,       & ! (in)
   429                  & xyrr_TransEach                                       & ! (out)
   430                  & )
   431                xyrr_Trans = xyrr_Trans * xyrr_TransEach
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1384 = 1, (xyrr_trans.DSC.U4 + 1)*(xyrr_trans.DSC.U3 + 1)*    
     .       1   xyrr_trans.DSC.U2*(xyrr_trans.DSC.U1 + 1)                      
     .           xyrr_trans(t1384-1,1,0,0) = xyrr_trans(t1384-1,1,0,0)*         
     .       1      xyrr_transeach(t1384-1,1,0,0)                               
     .        enddo                                                             
   432              end if
   433            end if
   434  
   435            ! Calculation of CO2 transmittance in weak bands
   436            if ( ( n == 4 ) .or. ( n == 5 ) .or. ( n == 10 ) ) then
   437              call RadC2001CalcTrans(                                  &
   438                & 'WeakBandCO2Line', n,                                & ! (in)
   439                & xyz_DelCO2Mass, xyz_Press, xyz_Temp, xyz_QCO2,       & ! (in)
   440                & xyrr_TransEach                                       & ! (out)
   441                & )
   442              xyrr_Trans = xyrr_Trans * xyrr_TransEach
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1364 = 1, (xyrr_trans.DSC.U4 + 1)*(xyrr_trans.DSC.U3 + 1)*    
     .       1   xyrr_trans.DSC.U2*(xyrr_trans.DSC.U1 + 1)                      
     .           xyrr_trans(t1364-1,1,0,0) = xyrr_trans(t1364-1,1,0,0)*         
     .       1      xyrr_transeach(t1364-1,1,0,0)                               
     .        enddo                                                             
   443            end if
   444  
   445          end if
   446  
   447          xyrra_TransSaved(:,:,:,:,n) = xyrr_Trans
     .        if(xyrra_transsaved.DSC.U2+1-xyrra_transsaved.DSC.L2.gt.0)then    
     .           j4=and(xyrra_transsaved.DSC.U2+1-xyrra_transsaved.DSC.L2,3)    
     .  !cdir    nodep                                                          
     .           do t1332 = 1, j4                                               
     .  !cdir       nodep                                                       
     .              do t1334 = 1, xyrra_transsaved.DSC.U1 + 1 -                 
     .       1         xyrra_transsaved.DSC.L1                                  
     .                 xyrra_transsaved(t15+t1334-1,t1332-1+t17,t1330+t19,t1328+
     .       1            t21,n) = xyrr_trans(t1334-1,t1332,t1330,t1328)        
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t1332 = j4 + 1, xyrra_transsaved.DSC.U2 + 1 -               
     .       1      xyrra_transsaved.DSC.L2, 4                                  
     .  !cdir       nodep                                                       
     .              do t1334 = 1, xyrra_transsaved.DSC.U1 + 1 -                 
     .       1         xyrra_transsaved.DSC.L1                                  
     .                 xyrra_transsaved(t15+t1334-1,t1332-1+t17,t1330+t19,t1328+
     .       1            t21,n) = xyrr_trans(t1334-1,t1332,t1330,t1328)        
     .                 xyrra_transsaved(t15+t1334-1,t1332+t17,t1330+t19,t1328+  
     .       1            t21,n) = xyrr_trans(t1334-1,t1332+1,t1330,t1328)      
     .                 xyrra_transsaved(t15+t1334-1,t1332+1+t17,t1330+t19,t1328+
     .       1            t21,n) = xyrr_trans(t1334-1,t1332+2,t1330,t1328)      
     .                 xyrra_transsaved(t15+t1334-1,t1332+2+t17,t1330+t19,t1328+
     .       1            t21,n) = xyrr_trans(t1334-1,t1332+3,t1330,t1328)      
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
   448  
   449        end do LOOP_band_trans
   450  
   451        !
   452        !   Calculation of transmittance of water vapor by using a method for middle
   453        !   atmosphere
   454        !
   455  !!$      call RadC1991CalcTransMAH2O(      &
   456  !!$        & xyr_Press, xyz_Press, xyz_Temp, xyz_QH2OVap, & ! (in)
   457  !!$        & xyrr_Trans                                & ! (out)
   458  !!$        & )
   459        xyrr_Trans = -1.0d100
     .        if (xyrr_trans.DSC.U2 .gt. 0) then                                
     .           j5 = and(xyrr_trans.DSC.U2,3)                                  
     .  !cdir    nodep                                                          
     .           do t1348 = 1, j5                                               
     .  !cdir       nodep                                                       
     .              do t1350 = 1, xyrr_trans.DSC.U1 + 1                         
     .                 xyrr_trans(t1350-1,t1348,t1346,t1344) =                  
     .       1            -1.00000000000000e+100                                
     .                 xyrr_transmasaved(xyrr_transmasaved.DSC.L1+t1350-1,t1348-
     .       1            1+xyrr_transmasaved.DSC.L2,t1346+                     
     .       2            xyrr_transmasaved.DSC.L3,t1344+                       
     .       3            xyrr_transmasaved.DSC.L4) = xyrr_trans(t1350-1,t1348, 
     .       4            t1346,t1344)                                          
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t1348 = j5 + 1, xyrr_trans.DSC.U2, 4                        
     .  !cdir       nodep                                                       
     .              do t1350 = 1, xyrr_trans.DSC.U1 + 1                         
     .                 xyrr_trans(t1350-1,t1348,t1346,t1344) =                  
     .       1            -1.00000000000000e+100                                
     .                 xyrr_trans(t1350-1,t1348+1,t1346,t1344) =                
     .       1            -1.00000000000000e+100                                
     .                 xyrr_trans(t1350-1,t1348+2,t1346,t1344) =                
     .       1            -1.00000000000000e+100                                
     .                 xyrr_trans(t1350-1,t1348+3,t1346,t1344) =                
     .       1            -1.00000000000000e+100                                
     .                 xyrr_transmasaved(xyrr_transmasaved.DSC.L1+t1350-1,t1348-
     .       1            1+xyrr_transmasaved.DSC.L2,t1346+                     
     .       2            xyrr_transmasaved.DSC.L3,t1344+                       
     .       3            xyrr_transmasaved.DSC.L4) = xyrr_trans(t1350-1,t1348, 
     .       4            t1346,t1344)                                          
     .                 xyrr_transmasaved(xyrr_transmasaved.DSC.L1+t1350-1,t1348+
     .       1            xyrr_transmasaved.DSC.L2,t1346+                       
     .       2            xyrr_transmasaved.DSC.L3,t1344+                       
     .       3            xyrr_transmasaved.DSC.L4) = xyrr_trans(t1350-1,t1348+1
     .       4            ,t1346,t1344)                                         
     .                 xyrr_transmasaved(xyrr_transmasaved.DSC.L1+t1350-1,t1348+
     .       1            1+xyrr_transmasaved.DSC.L2,t1346+                     
     .       2            xyrr_transmasaved.DSC.L3,t1344+                       
     .       3            xyrr_transmasaved.DSC.L4) = xyrr_trans(t1350-1,t1348+2
     .       4            ,t1346,t1344)                                         
     .                 xyrr_transmasaved(xyrr_transmasaved.DSC.L1+t1350-1,t1348+
     .       1            2+xyrr_transmasaved.DSC.L2,t1346+                     
     .       2            xyrr_transmasaved.DSC.L3,t1344+                       
     .       3            xyrr_transmasaved.DSC.L4) = xyrr_trans(t1350-1,t1348+3
     .       4            ,t1346,t1344)                                         
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
   460  
   461        xyrr_TransMASaved = xyrr_Trans
   462  
   463      end if
   464  
   465  
   466  
   467      !
   468      ! Calculate radiative flux
   469      !
   470  
   471      xy_SurfEmis = 1.0_DP
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1059 = 1, xy_surfemis.DSC.U2*xy_surfemis.DSC.U1 +             
     .       1   xy_surfemis.DSC.U2                                             
     .           xy_surfemis(t1059-1,1) = 1.00000000000000e+000                 
     .        enddo                                                             
   472  
   473      xyr_RadLUwFlux     = 0.0_DP
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1065 = 1, jmax*(kmax*imax + imax)                             
     .           xyr_radluwflux(t1065-1,1,0) = 0.0000000000000000e+000          
     .           xyr_radldwflux(t1065-1,1,0) = 0.0000000000000000e+000          
     .        enddo                                                             
   474      xyr_RadLDwFlux     = 0.0_DP
   475      xyra_DelRadLUwFlux = 0.0_DP
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1079 = 1, jmax*(kmax*imax + imax)                             
     .           xyra_delradluwflux(t1079-1,1,0,0) = 0.0000000000000000e+000    
     .           xyra_delradldwflux(t1079-1,1,0,0) = 0.0000000000000000e+000    
     .           xyra_delradluwflux(t1079-1,1,0,1) = 0.0000000000000000e+000    
     .           xyra_delradldwflux(t1079-1,1,0,1) = 0.0000000000000000e+000    
     .        enddo                                                             
   476      xyra_DelRadLDwFlux = 0.0_DP
   477  
   478  
   479      LOOP_band_RTE : do n = 1, nbmax
   480  
   481  
   482        xyz_CloudREff = xyz_CloudWatREff
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1093 = 1, xyz_cloudreff.DSC.U3*(xyz_cloudreff.DSC.U2*         
     .       1   xyz_cloudreff.DSC.U1 + xyz_cloudreff.DSC.U2)                   
     .           xyz_cloudreff(t1093-1,1,1) = xyz_cloudwatreff(t1093-1,1,1)     
     .        enddo                                                             
   483        call RadC2001CalcCloudOptProp(                         &
   484          & 'Liquid', n, xyz_CloudREff,                        & ! (in)
   485          & xyz_CloudExtCoef, xyz_CloudWatSSA, xyz_CloudWatAF  & ! (out)
   486          & )
   487        xyz_DelCloudWatOptDep = xyz_CloudExtCoef * xyz_DelH2OLiqMass
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1105 = 1, xyz_cloudextcoef.DSC.U3*(xyz_cloudextcoef.DSC.U2*   
     .       1   xyz_cloudextcoef.DSC.U1 + xyz_cloudextcoef.DSC.U2)             
     .           xyz_delcloudwatoptdep(t1105-1,1,1) = xyz_cloudextcoef(t1105-1,1
     .       1      ,1)*xyz_delh2oliqmass(t1105-1,1,1)                          
     .           xyz_cloudreff(t1105-1,1,1) = xyz_cloudicereff(t1105-1,1,1)     
     .        enddo                                                             
   488        !
   489        xyz_CloudREff = xyz_CloudIceREff
   490        call RadC2001CalcCloudOptProp(                         &
   491          & 'Ice', n, xyz_CloudREff,                           & ! (in)
   492          & xyz_CloudExtCoef, xyz_CloudIceSSA, xyz_CloudIceAF  & ! (out)
   493          & )
   494        xyz_DelCloudIceOptDep = xyz_CloudExtCoef * xyz_DelH2OSolMass
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1126 = 1, xyz_cloudextcoef.DSC.U3*(xyz_cloudextcoef.DSC.U2*   
     .       1   xyz_cloudextcoef.DSC.U1 + xyz_cloudextcoef.DSC.U2)             
     .           xyz_delcloudiceoptdep(t1126-1,1,1) = xyz_cloudextcoef(t1126-1,1
     .       1      ,1)*xyz_delh2osolmass(t1126-1,1,1)                          
     .        enddo                                                             
   495  
   496        call RadC2001ReduceCloudOptDep(      &
   497          & xyz_CloudWatSSA, xyz_CloudWatAF, & ! (in)
   498          & xyz_DelCloudWatOptDep            & ! (inout)
   499          & )
   500        call RadC2001ReduceCloudOptDep(      &
   501          & xyz_CloudIceSSA, xyz_CloudIceAF, & ! (in)
   502          & xyz_DelCloudIceOptDep            & ! (inout)
   503          & )
   504        !
   505        call CloudUtilsLocalizeCloud(  &
   506          & xyz_CloudCover,            & ! (in   )
   507          & xyz_DelCloudWatOptDep      & ! (inout)
   508          & )
   509        call CloudUtilsLocalizeCloud(  &
   510          & xyz_CloudCover,            & ! (in   )
   511          & xyz_DelCloudIceOptDep      & ! (inout)
   512          & )
   513        !
   514        xyz_TransCloudOneLayer = &
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1141 = 1, xyz_delcloudwatoptdep.DSC.U3*(                      
     .       1   xyz_delcloudwatoptdep.DSC.U2*xyz_delcloudwatoptdep.DSC.U1 +    
     .       2   xyz_delcloudwatoptdep.DSC.U2)                                  
     .           xyz_transcloudonelayer(t1141-1,1,1) = dexp((-(                 
     .       1      xyz_delcloudwatoptdep(t1141-1,1,1)+xyz_delcloudiceoptdep(   
     .       2      t1141-1,1,1))*1.65999999999999e+000))                       
     .        enddo                                                             
   515          & exp( - ( xyz_DelCloudWatOptDep + xyz_DelCloudIceOptDep ) * DiffFactor )
   516        !
   517        call CloudUtilsCalcOverlapCloudTrans(       &
   518          & xyz_TransCloudOneLayer, xyz_CloudCover, & ! (in)
   519          & xyrr_TransCloud                         & ! (out)
   520          & )
   521  
   522  
   523        ! Now, nothing is done when n = nbmax.
   524        if ( n == nbmax ) cycle
   525  
   526  
   527        xyrr_Trans = xyrra_TransSaved(:,:,:,:,n)
     .        if (xyrr_trans.DSC.U2 .gt. 0) then                                
     .           j6 = and(xyrr_trans.DSC.U2,3)                                  
     .  !cdir    nodep                                                          
     .           do t1160 = 1, j6                                               
     .  !cdir       nodep                                                       
     .              do t1162 = 1, xyrr_trans.DSC.U1 + 1                         
     .                 xyrr_trans1 = xyrra_transsaved(t15+t1162-1,t1160-1+t17,  
     .       1            t1158+t19,t1156+t21,n)                                
     .                 xyrr_trans(t1162-1,t1160,t1158,t1156) = xyrr_trans1*     
     .       1            xyrr_transcloud(t1162-1,t1160,t1158,t1156)            
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t1160 = j6 + 1, xyrr_trans.DSC.U2, 4                        
     .  !cdir       nodep                                                       
     .              do t1162 = 1, xyrr_trans.DSC.U1 + 1                         
     .                 xyrr_trans(t1162-1,t1160,t1158,t1156) = xyrra_transsaved(
     .       1            t15+t1162-1,t1160-1+t17,t1158+t19,t1156+t21,n)        
     .                 xyrr_trans(t1162-1,t1160+1,t1158,t1156) =                
     .       1            xyrra_transsaved(t15+t1162-1,t1160+t17,t1158+t19,t1156
     .       2            +t21,n)                                               
     .                 xyrr_trans(t1162-1,t1160+2,t1158,t1156) =                
     .       1            xyrra_transsaved(t15+t1162-1,t1160+1+t17,t1158+t19,   
     .       2            t1156+t21,n)                                          
     .                 xyrr_trans(t1162-1,t1160+3,t1158,t1156) =                
     .       1            xyrra_transsaved(t15+t1162-1,t1160+2+t17,t1158+t19,   
     .       2            t1156+t21,n)                                          
     .                 xyrr_trans(t1162-1,t1160,t1158,t1156) = xyrr_trans(t1162-
     .       1            1,t1160,t1158,t1156)*xyrr_transcloud(t1162-1,t1160,   
     .       2            t1158,t1156)                                          
     .                 xyrr_trans(t1162-1,t1160+1,t1158,t1156) = xyrr_trans(    
     .       1            t1162-1,t1160+1,t1158,t1156)*xyrr_transcloud(t1162-1, 
     .       2            t1160+1,t1158,t1156)                                  
     .                 xyrr_trans(t1162-1,t1160+2,t1158,t1156) = xyrr_trans(    
     .       1            t1162-1,t1160+2,t1158,t1156)*xyrr_transcloud(t1162-1, 
     .       2            t1160+2,t1158,t1156)                                  
     .                 xyrr_trans(t1162-1,t1160+3,t1158,t1156) = xyrr_trans(    
     .       1            t1162-1,t1160+3,t1158,t1156)*xyrr_transcloud(t1162-1, 
     .       2            t1160+3,t1158,t1156)                                  
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
   528  
   529        xyrr_Trans = xyrr_Trans * xyrr_TransCloud
   530  
   531  
   532  
   533        call CalcIntegratedPFWithTable2D( &
   534          & n, xy_SurfTemp,                         &
   535          & xy_SurfIntPF,                           &
   536          & 1, jmax                                 &
   537          & )
   538        call CalcIntegratedPFWithTable3D( &
   539          & n, kmax, xyz_Temp,                    &
   540          & xyz_IntPF,                            &
   541          & 1, jmax                               &
   542          & )
   543  
   544        call CalcIntegratedPFWithTable2D( &
   545          & n, xy_SurfTemp,                         &
   546          & xy_IntDPFDT0,                           &
   547          & 1, jmax,                                &
   548          & .true.                                  &
   549          & )
   550        call CalcIntegratedPFWithTable2D( &
   551          & n, xyz_Temp(:,:,1),                     &
   552          & xy_IntDPFDT1,                           &
   553          & 1, jmax,                                &
   554          & .true.                                  &
   555          & )
   556  
   557        xy_SurfIntPF = xy_SurfEmis * PI * xy_SurfIntPF
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1184 = 1, xy_surfemis.DSC.U2*xy_surfemis.DSC.U1 +             
     .       1   xy_surfemis.DSC.U2                                             
     .           xy_surfintpf(t1184-1,1) = xy_surfemis(t1184-1,1)*              
     .       1      3.14159265358979e+000*xy_surfintpf(t1184-1,1)               
     .        enddo                                                             
   558        xyz_IntPF    =               PI * xyz_IntPF
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1194 = 1, xyz_intpf.DSC.U3*(xyz_intpf.DSC.U2*xyz_intpf.DSC.U1 
     .       1    + xyz_intpf.DSC.U2)                                           
     .           xyz_intpf(t1194-1,1,1) = 3.14159265358979e+000*xyz_intpf(t1194-
     .       1      1,1,1)                                                      
     .        enddo                                                             
   559        xy_IntDPFDT0 = xy_SurfEmis * PI * xy_IntDPFDT0
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1206 = 1, xy_surfemis.DSC.U2*xy_surfemis.DSC.U1 +             
     .       1   xy_surfemis.DSC.U2                                             
     .           xy_intdpfdt0(t1206-1,1) = xy_surfemis(t1206-1,1)*              
     .       1      3.14159265358979e+000*xy_intdpfdt0(t1206-1,1)               
     .           xy_intdpfdt1(t1206-1,1) = 3.14159265358979e+000*xy_intdpfdt1(  
     .       1      t1206-1,1)                                                  
     .        enddo                                                             
   560        xy_IntDPFDT1 =               PI * xy_IntDPFDT1
   561  
   562  
   563  
   564        ! Lines below are under testing.
   565        !
   566  !!$      xy_SurfIntPF2 = xy_SurfIntPF
   567  !!$      xyz_IntPF2    = xyz_IntPF
   568  !!$      xy_IntDPFDT02 = xy_IntDPFDT0
   569  !!$      xy_IntDPFDT12 = xy_IntDPFDT1
   570  !!$
   571  !!$
   572  !!$      call RadC2001CalcIntegratedPF2D(       &
   573  !!$        & n, xy_SurfTemp,                    &
   574  !!$        & xy_SurfIntPF                       &
   575  !!$        & )
   576  !!$      call RadC2001CalcIntegratedPF3D(       &
   577  !!$        & n, kmax, xyz_Temp,                 &
   578  !!$        & xyz_IntPF                          &
   579  !!$        & )
   580  !!$
   581  !!$      call RadC2001CalcIntegratedPF2D(       &
   582  !!$        & n, xy_SurfTemp,                    &
   583  !!$        & xy_IntDPFDT0,                      &
   584  !!$        & .true.                             &
   585  !!$        & )
   586  !!$      call RadC2001CalcIntegratedPF2D(       &
   587  !!$        & n, xyz_Temp(:,:,1),                &
   588  !!$        & xy_IntDPFDT1,                      &
   589  !!$        & .true.                             &
   590  !!$        & )
   591  !!$
   592  !!$      xy_SurfIntPF = xy_SurfEmis * xy_SurfIntPF
   593  !!$      xyz_IntPF    =               xyz_IntPF
   594  !!$      xy_IntDPFDT0 = xy_SurfEmis * xy_IntDPFDT0
   595  !!$      xy_IntDPFDT1 =               xy_IntDPFDT1
   596  !!$
   597  !!$      do j = 1, jmax
   598  !!$        do i = 0, imax-1
   599  !!$          write( 20+n, * ) xy_SurfTemp(i,j), xy_SurfIntPF2(i,j), xy_SurfIntPF(i,j), &
   600  !!$            & xy_IntDPFDT02(i,j), xy_IntDPFDT02(i,j)
   601  !!$        end do
   602  !!$      end do
   603  !!$      do j = 1, jmax
   604  !!$        do i = 0, imax-1
   605  !!$          write( 40+n, * ) xyz_Temp(i,j,1), xy_IntDPFDT12(i,j), xy_IntDPFDT12(i,j)
   606  !!$        end do
   607  !!$      end do
   608  !!$      do k = 1, kmax
   609  !!$        do j = 1, jmax
   610  !!$          do i = 0, imax-1
   611  !!$            write( 60+n, * ) xyz_Temp(i,j,k), xyz_IntPF2(i,j,k), xyz_IntPF(i,j,k)
   612  !!$          end do
   613  !!$        end do
   614  !!$      end do
   615  !!$      call flush( 20+n )
   616  !!$      call flush( 40+n )
   617  !!$      call flush( 60+n )
   618  
   619  
   620  
   621  !!$      call OLD_RadRTENonScat(                                      &
   622  !!$        & xyz_IntPF, xy_SurfIntPF, xy_IntDPFDT1, xy_IntDPFDT0, & ! (in)
   623  !!$        & xyrr_Trans,                                          & ! (in)
   624  !!$        & xyr_RadFlux, xyra_DelRadFlux                         & ! (out)
   625  !!$        & )
   626  
   627        call RadRTENonScat(                                                &
   628  !!$      call RadRTENonScatAnotherForm( &
   629          & xyz_IntPF, xy_SurfIntPF, xy_IntDPFDT1, xy_IntDPFDT0, & ! (in)
   630          & xyrr_Trans,                                          & ! (in)
   631          & xyr_RadUwFlux, xyr_RadDwFlux,                      & ! (out)
   632          & xyra_DelRadUwFlux, xyra_DelRadDwFlux               & ! (out)
   633          & )
   634  
   635  
   636  
   637  !!$      i = 0
   638  !!$      j = jmax/2+1
   639  !!$      do k = 0, kmax
   640  !!$        write( 6, * ) k, xyr_RadFlux(i,j,k), &
   641  !!$          & xyr_RadFlux(i,j,k) - ( xyr_RadUwFlux(i,j,k) - xyr_RadDwFlux(i,j,k) )
   642  !!$      end do
   643  !!$      do k = 0, kmax
   644  !!$        write( 6, * ) k, &
   645  !!$          & xyra_DelRadFlux(i,j,k,0), &
   646  !!$          & xyra_DelRadFlux(i,j,k,0) - ( xyra_DelRadUwFlux(i,j,k,0) - xyra_DelRadDwFlux(i,j,k,0) ), &
   647  !!$          & xyra_DelRadFlux(i,j,k,1), &
   648  !!$          & xyra_DelRadFlux(i,j,k,1) - ( xyra_DelRadUwFlux(i,j,k,1) - xyra_DelRadDwFlux(i,j,k,1) )
   649  !!$      end do
   650  
   651  
   652  
   653  !!$      if ( ( n == 1 ) .or. ( n == 2 ) .or. ( n == 9 ) ) then
   654  !!$        !
   655  !!$        ! For bands 0-340, 340-540, 1380-1900
   656  !!$        ! merge with flux calculated with a method for middle atmosphere
   657  !!$        !
   658  !!$
   659  !!$        xyrr_Trans = xyrr_TransMASaved
   660  !!$
   661  !!$        call RadELWV22IntegRTE(                               &
   662  !!$          & n,                                                & ! (in )
   663  !!$          & xyz_Temp, xy_SurfTemp, xy_SurfEmis, xyrr_Trans,   & ! (in )
   664  !!$          & xyr_RadFluxMA, xyra_DelRadFluxMA                  & ! (out)
   665  !!$          & )
   666  !!$
   667  !!$        call RadDcpamELWV22CutMergeFlux(          &
   668  !!$          & xyr_Press,                            & ! (in)
   669  !!$          & xyr_RadFlux, xyra_DelRadFlux,         & ! (inout)
   670  !!$          & xyr_RadFluxMA, xyra_DelRadFluxMA      & ! (in) optional
   671  !!$          & )
   672  !!$
   673  !!$      else if ( ( n == 4 ) .or. ( n == 6 ) .or. ( n == 8 ) ) then
   674  !!$        !
   675  !!$        ! For bands 800-980, 1100-1380, 1900-3000
   676  !!$        ! flux above a pressure level is modified to be constant
   677  !!$        !
   678  !!$
   679  !!$        call RadDcpamELWV22CutMergeFlux(          &
   680  !!$          & xyr_Press,                            & ! (in)
   681  !!$          & xyr_RadFlux, xyra_DelRadFlux          & ! (inout)
   682  !!$          & )
   683  !!$
   684  !!$      end if
   685  
   686  
   687        xyr_RadLUwFlux     = xyr_RadLUwFlux     + xyr_RadUwFlux
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1220 = 1, jmax*(kmax*imax + imax)                             
     .           xyr_radluwflux(t1220-1,1,0) = xyr_radluwflux(t1220-1,1,0) +    
     .       1      xyr_raduwflux(t1220-1,1,0)                                  
     .           xyr_radldwflux(t1220-1,1,0) = xyr_radldwflux(t1220-1,1,0) +    
     .       1      xyr_raddwflux(t1220-1,1,0)                                  
     .        enddo                                                             
   688        xyr_RadLDwFlux     = xyr_RadLDwFlux     + xyr_RadDwFlux
   689        xyra_DelRadLUwFlux = xyra_DelRadLUwFlux + xyra_DelRadUwFlux
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1246 = 1, jmax*(kmax*imax + imax)                             
     .           xyra_delradluwflux(t1246-1,1,0,0) = xyra_delradluwflux(t1246-1,
     .       1      1,0,0) + xyra_delraduwflux(t1246-1,1,0,0)                   
     .           xyra_delradldwflux(t1246-1,1,0,0) = xyra_delradldwflux(t1246-1,
     .       1      1,0,0) + xyra_delraddwflux(t1246-1,1,0,0)                   
     .           xyra_delradluwflux(t1246-1,1,0,1) = xyra_delradluwflux(t1246-1,
     .       1      1,0,1) + xyra_delraduwflux(t1246-1,1,0,1)                   
     .           xyra_delradldwflux(t1246-1,1,0,1) = xyra_delradldwflux(t1246-1,
     .       1      1,0,1) + xyra_delraddwflux(t1246-1,1,0,1)                   
     .        enddo                                                             
   690        xyra_DelRadLDwFlux = xyra_DelRadLDwFlux + xyra_DelRadDwFlux
   691  
   692      end do LOOP_band_RTE
   693  
   694  
   695  
   696  
   697  
   698  !!$    i = 0
   699  !!$    j = jmax / 2 + 1
   700  !!$    write( 73, * ) xy_SurfTemp(i,j), 0.0d0, 0.0d0, xyr_Press(i,j,0)
   701  !!$    do k = 1, kmax
   702  !!$      write( 73, * ) xyz_Temp(i,j,k), xyz_QH2OVap(i,j,k), xyz_QO3(i,j,k), &
   703  !!$        & xyz_Press(i,j,k)
   704  !!$    end do
   705  !!$    call flush( 73 )
   706  !!$
   707  !!$    i = 0
   708  !!$    j = jmax / 2 + 1
   709  !!$    do k = 1, kmax
   710  !!$      write( 83, * ) &
   711  !!$        & + (     xyr_RadLFlux(i,j,k-1) - xyr_RadLFlux(i,j,k) )  &
   712  !!$        &     / ( xyr_Press(i,j,k-1)    - xyr_Press(i,j,k) )     &
   713  !!$        &     / 1004.6 * 9.8, &
   714  !!$        & xyz_Press(i,j,k)
   715  !!$    end do
   716  !!$    call flush( 83 )
   717  !!$
   718  !!$    i = 0
   719  !!$    j = jmax / 2 + 1
   720  !!$    do k = 0, kmax
   721  !!$      write( 93, * ) xyr_RadLFlux(i,j,k), xyr_Press(i,j,k)
   722  !!$    end do
   723  !!$    call flush( 93 )
   724  !!$    stop
   725  
   726  
   727      ! 計算時間計測一時停止
   728      ! Pause measurement of computation time
   729      !
   730      call TimesetClockStop( module_name )
   731  
   732    end subroutine RadEarthLWV24Flux
   733  
   734    !--------------------------------------------------------------------------------------
   735  !!$
   736  !!$  subroutine RadiationDcpamELWV23CutMergeFlux( &
   737  !!$    & xyr_Press,                              & ! (in)
   738  !!$    & xyr_RadLFlux, xyra_DelRadLFlux,         & ! (inout)
   739  !!$    & xyr_RadLFluxMA, xyra_DelRadLFluxMA      & ! (in) optional
   740  !!$    & )
   741  !!$    !
   742  !!$    ! Radiative flux above a pressure level is modified to be constant or is merged with
   743  !!$    ! that in middle atmosphere
   744  !!$    !
   745  !!$
   746  !!$    ! USE statements
   747  !!$    !
   748  !!$
   749  !!$    !
   750  !!$    ! Grid points settings
   751  !!$    !
   752  !!$    use gridset, only: imax, & !
   753  !!$                               ! Number of grid points in longitude
   754  !!$      &                jmax, & !
   755  !!$                               ! Number of grid points in latitude
   756  !!$      &                kmax    !
   757  !!$                               ! Number of vertical level
   758  !!$
   759  !!$    real(DP), intent(in   )           :: xyr_Press         (0:imax-1, 1:jmax, 0:kmax)
   760  !!$    real(DP), intent(inout)           :: xyr_RadLFlux      (0:imax-1, 1:jmax, 0:kmax)
   761  !!$    real(DP), intent(inout)           :: xyra_DelRadLFlux  (0:imax-1, 1:jmax, 0:kmax, 0:1)
   762  !!$    real(DP), intent(in   ), optional :: xyr_RadLFluxMA    (0:imax-1, 1:jmax, 0:kmax)
   763  !!$    real(DP), intent(in   ), optional :: xyra_DelRadLFluxMA(0:imax-1, 1:jmax, 0:kmax, 0:1)
   764  !!$
   765  !!$    !
   766  !!$    ! Work variables
   767  !!$    !
   768  !!$    real(DP), parameter :: BoundaryPress = 30.0d2
   769  !!$    integer             :: xy_kcut            (0:imax-1, 1:jmax)
   770  !!$    real(DP)            :: xy_BoundaryFlux    (0:imax-1, 1:jmax)
   771  !!$    real(DP)            :: xya_BoundaryDelFlux(0:imax-1, 1:jmax, 0:1)
   772  !!$    integer             :: i
   773  !!$    integer             :: j
   774  !!$    integer             :: k
   775  !!$
   776  !!$
   777  !!$    do k = 0, kmax
   778  !!$      do j = 1, jmax
   779  !!$        do i = 0, imax-1
   780  !!$          if ( xyr_Press(i,j,k) >= BoundaryPress ) then
   781  !!$            xy_kcut(i,j) = k
   782  !!$          end if
   783  !!$        end do
   784  !!$      end do
   785  !!$    end do
   786  !!$    do j = 1, jmax
   787  !!$      do i = 0, imax-1
   788  !!$        if ( xy_kcut(i,j) == kmax ) then
   789  !!$          xy_kcut(i,j) = kmax - 1
   790  !!$        end if
   791  !!$      end do
   792  !!$    end do
   793  !!$
   794  !!$    do j = 1, jmax
   795  !!$      do i = 0, imax-1
   796  !!$        k = xy_kcut(i,j)
   797  !!$        xy_BoundaryFlux(i,j) =                                              &
   798  !!$          &   ( xyr_RadLFlux(i,j,k+1) - xyr_RadLFlux(i,j,k) )               &
   799  !!$          & / log( ( xyr_Press(i,j,k+1) + 1.0d-100 ) / ( xyr_Press(i,j,k) + 1.0d-100 ) )&
   800  !!$          & * log( BoundaryPress                     / ( xyr_Press(i,j,k) + 1.0d-100 ) )&
   801  !!$          & + xyr_RadLFlux(i,j,k)
   802  !!$        xya_BoundaryDelFlux(i,j,0) =                                        &
   803  !!$          &   ( xyra_DelRadLFlux(i,j,k+1,0) - xyra_DelRadLFlux(i,j,k,0) )   &
   804  !!$          & / log( ( xyr_Press(i,j,k+1) + 1.0d-100 ) / ( xyr_Press(i,j,k) + 1.0d-100 ) )&
   805  !!$          & * log( BoundaryPress                     / ( xyr_Press(i,j,k) + 1.0d-100 ) )&
   806  !!$          & + xyra_DelRadLFlux(i,j,k,0)
   807  !!$        xya_BoundaryDelFlux(i,j,1) =                                        &
   808  !!$          &   ( xyra_DelRadLFlux(i,j,k+1,1) - xyra_DelRadLFlux(i,j,k,1) )   &
   809  !!$          & / log( ( xyr_Press(i,j,k+1) + 1.0d-100 ) / ( xyr_Press(i,j,k) + 1.0d-100 ) )&
   810  !!$          & * log( BoundaryPress                     / ( xyr_Press(i,j,k) + 1.0d-100 ) )&
   811  !!$          & + xyra_DelRadLFlux(i,j,k,1)
   812  !!$      end do
   813  !!$    end do
   814  !!$
   815  !!$    do k = 0, kmax
   816  !!$      do j = 1, jmax
   817  !!$        do i = 0, imax-1
   818  !!$          if ( xyr_Press(i,j,k) < BoundaryPress ) then
   819  !!$            xyr_RadLFlux(i,j,k) = xy_BoundaryFlux(i,j)
   820  !!$          end if
   821  !!$        end do
   822  !!$      end do
   823  !!$    end do
   824  !!$    do k = 0, kmax
   825  !!$      do j = 1, jmax
   826  !!$        do i = 0, imax-1
   827  !!$          if ( xyr_Press(i,j,k) < BoundaryPress ) then
   828  !!$            xyra_DelRadLFlux(i,j,k,0) = xya_BoundaryDelFlux(i,j,0)
   829  !!$            xyra_DelRadLFlux(i,j,k,1) = xya_BoundaryDelFlux(i,j,1)
   830  !!$          end if
   831  !!$        end do
   832  !!$      end do
   833  !!$    end do
   834  !!$
   835  !!$
   836  !!$    if ( present( xyr_RadLFluxMA ) ) then
   837  !!$
   838  !!$      do j = 1, jmax
   839  !!$        do i = 0, imax-1
   840  !!$          k = xy_kcut(i,j)
   841  !!$          xy_BoundaryFlux(i,j) =                                              &
   842  !!$            &   ( xyr_RadLFluxMA(i,j,k+1) - xyr_RadLFluxMA(i,j,k) )           &
   843  !!$            & / log( ( xyr_Press(i,j,k+1) + 1.0d-100 ) / ( xyr_Press(i,j,k) + 1.0d-100 ) )   &
   844  !!$            & * log( BoundaryPress                     / ( xyr_Press(i,j,k) + 1.0d-100 ) )   &
   845  !!$            & + xyr_RadLFluxMA(i,j,k)
   846  !!$        end do
   847  !!$      end do
   848  !!$
   849  !!$      do k = 0, kmax
   850  !!$        do j = 1, jmax
   851  !!$          do i = 0, imax-1
   852  !!$            if ( xyr_Press(i,j,k) < BoundaryPress ) then
   853  !!$              xyr_RadLFlux(i,j,k) = xyr_RadLFlux(i,j,k) &
   854  !!$                & + xyr_RadLFluxMA(i,j,k) - xy_BoundaryFlux(i,j)
   855  !!$            end if
   856  !!$          end do
   857  !!$        end do
   858  !!$      end do
   859  !!$
   860  !!$    end if
   861  !!$
   862  !!$    if ( present( xyra_DelRadLFluxMA ) ) then
   863  !!$
   864  !!$      do j = 1, jmax
   865  !!$        do i = 0, imax-1
   866  !!$          k = xy_kcut(i,j)
   867  !!$          xya_BoundaryDelFlux(i,j,0) =                                            &
   868  !!$            &   ( xyra_DelRadLFluxMA(i,j,k+1,0) - xyra_DelRadLFluxMA(i,j,k,0) )   &
   869  !!$            & / log( ( xyr_Press(i,j,k+1) + 1.0d-100 ) / ( xyr_Press(i,j,k) + 1.0d-100 ) )       &
   870  !!$            & * log( BoundaryPress                     / ( xyr_Press(i,j,k) + 1.0d-100 ) )       &
   871  !!$            & + xyra_DelRadLFluxMA(i,j,k,0)
   872  !!$          xya_BoundaryDelFlux(i,j,1) =                                            &
   873  !!$            &   ( xyra_DelRadLFluxMA(i,j,k+1,1) - xyra_DelRadLFluxMA(i,j,k,1) )   &
   874  !!$            & / log( ( xyr_Press(i,j,k+1) + 1.0d-100 ) / ( xyr_Press(i,j,k) + 1.0d-100 ) )       &
   875  !!$            & * log( BoundaryPress                     / ( xyr_Press(i,j,k) + 1.0d-100 ) )       &
   876  !!$            & + xyra_DelRadLFluxMA(i,j,k,1)
   877  !!$        end do
   878  !!$      end do
   879  !!$
   880  !!$      do k = 0, kmax
   881  !!$        do j = 1, jmax
   882  !!$          do i = 0, imax-1
   883  !!$            if ( xyr_Press(i,j,k) < BoundaryPress ) then
   884  !!$              xyra_DelRadLFlux(i,j,k,0) = xyra_DelRadLFlux(i,j,k,0) &
   885  !!$                & + xyra_DelRadLFluxMA(i,j,k,0) - xya_BoundaryDelFlux(i,j,0)
   886  !!$              xyra_DelRadLFlux(i,j,k,1) = xyra_DelRadLFlux(i,j,k,1) &
   887  !!$                & + xyra_DelRadLFluxMA(i,j,k,1) - xya_BoundaryDelFlux(i,j,1)
   888  !!$            end if
   889  !!$          end do
   890  !!$        end do
   891  !!$      end do
   892  !!$
   893  !!$    end if
   894  !!$
   895  !!$
   896  !!$  end subroutine RadiationDcpamELWV23CutMergeFlux
   897  
   898    !--------------------------------------------------------------------------------------
   899  
   900    subroutine RadEarthLWV24Init( &
   901      & FlagSnow                  &
   902      & )
   903  
   904      ! USE statements
   905      !
   906  
   907      ! メッセージ出力
   908      ! Message output
   909      !
   910      use dc_message, only: MessageNotify
   911  
   912      ! ファイル入出力補助
   913      ! File I/O support
   914      !
   915      use dc_iounit, only: FileOpen
   916  
   917      ! 暦と日時の取り扱い
   918      ! Calendar and Date handler
   919      !
   920      use dc_calendar, only: DCCalConvertByUnit
   921  
   922      ! NAMELIST ファイル入力に関するユーティリティ
   923      ! Utilities for NAMELIST file input
   924      !
   925      use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid
   926  
   927      ! Chou and Kouvaris (1991) による長波放射モデル
   928      ! Long radiation model described by Chou and Kouvaris (1991)
   929      !
   930      use rad_CK1991, only : RadCK1991Init
   931  
   932      ! Chou et al. (2001) による長波放射モデル
   933      ! Long radiation model described by Chou et al. (2001)
   934      !
   935      use rad_C2001, only : RadC2001Init
   936  
   937      ! 散乱を無視した放射伝達方程式
   938      ! Radiative transfer equation without considering scattering
   939      !
   940      use rad_rte_nonscat, only : RadRTENonScatInit
   941  
   942      ! 雲関系ルーチン
   943      ! Cloud-related routines
   944      !
   945      use cloud_utils, only : CloudUtilsInit
   946  
   947  
   948      logical, intent(in) :: FlagSnow
   949  
   950  
   951      real(DP)          :: DelTimeCalcTransValue
   952      character(STRING) :: DelTimeCalcTransUnit
   953  
   954      integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号.
   955                                ! Unit number for NAMELIST file open
   956      integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT.
   957                                ! IOSTAT of NAMELIST read
   958  
   959      integer :: n
   960  
   961  
   962      namelist /rad_Earth_LW_V2_4_nml/ &
   963        & FlagHighAlt,              &
   964        & DelTimeCalcTransValue,    &
   965        & DelTimeCalcTransUnit,     &
   966        & flag_save_time
   967  
   968  
   969      if ( rad_Earth_LW_V2_4_inited ) return
   970  
   971  
   972      FlagHighAlt           = .false.
   973  
   974      DelTimeCalcTransValue = 3.0
   975      DelTimeCalcTransUnit  = 'hrs'
   976      flag_save_time        = .false.
   977  
   978  
   979      ! NAMELIST is input
   980      !
   981      if ( trim(namelist_filename) /= '' ) then
   982        call FileOpen( unit_nml, &          ! (out)
   983          & namelist_filename, mode = 'r' ) ! (in)
   984  
   985        rewind( unit_nml )
   986        read( unit_nml,                          & ! (in)
   987          & nml = rad_Earth_LW_V2_4_nml,         & ! (out)
   988          & iostat = iostat_nml )                  ! (out)
   989        close( unit_nml )
   990  
   991        call NmlutilMsg( iostat_nml, module_name ) ! (in)
   992      end if
   993  
   994      ! Handle interval time
   995      !
   996      IntTimeSave = DCCalConvertByUnit( DelTimeCalcTransValue, DelTimeCalcTransUnit, 'sec' ) ! (in)
   997  
   998  
   999  
  1000  
  1001      do n = 1, nbmax
  1002        ! unit conversion from (cm-1) to (m-1)
  1003        aa_BandParam(1,n) = aa_BandParam(1,n) * 1.0d2
  1004        aa_BandParam(2,n) = aa_BandParam(2,n) * 1.0d2
  1005      end do
  1006  
  1007  
  1008      ! allocate a variable for saving transmittance
  1009      !
  1010      allocate( xyrra_TransSaved (0:imax-1,1:jmax,0:kmax,0:kmax,1:nbmax) )
  1011      allocate( xyrr_TransMASaved(0:imax-1,1:jmax,0:kmax,0:kmax)         )
  1012  
  1013  
  1014      call RadEarthLWV24PrepPFTable
  1015  
  1016  
  1017      ! Initialization of modules used in this module
  1018      !
  1019  
  1020      ! Chou and Kouvaris (1991) による長波放射モデル
  1021      ! Long radiation model described by Chou and Kouvaris (1991)
  1022      !
  1023      call RadCK1991Init
  1024  
  1025      ! Chou et al. (2001) による長波放射モデル
  1026      ! Long radiation model described by Chou et al. (2001)
  1027      !
  1028      call RadC2001Init
  1029  
  1030      ! 散乱を無視した放射伝達方程式
  1031      ! Radiative transfer equation without considering scattering
  1032      !
  1033      call RadRTENonScatInit
  1034  
  1035      ! 雲関系ルーチン
  1036      ! Cloud-related routines
  1037      !
  1038      call CloudUtilsInit( &
  1039        & FlagSnow         &
  1040        & )
  1041  
  1042  
  1043      ! 印字 ; Print
  1044      !
  1045      call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
  1046      call MessageNotify( 'M', module_name, '  FlagHighAlt       = %b', &
  1047        & l = (/ FlagHighAlt /) )
  1048      call MessageNotify( 'M', module_name, '  DelTimeCalcTrans  = %f [%c]', &
  1049        & d = (/ DelTimeCalcTransValue /), c1 = trim( DelTimeCalcTransUnit ) )
  1050      call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
  1051  
  1052  
  1053      rad_Earth_LW_V2_4_inited = .true.
  1054  
  1055    end subroutine RadEarthLWV24Init
  1056  
  1057    !--------------------------------------------------------------------------------------
  1058  
  1059    subroutine RadEarthLWV24PrepPFTable
  1060  
  1061      ! メッセージ出力
  1062      ! Message output
  1063      !
  1064      use dc_message, only: MessageNotify
  1065  
  1066      ! ガウス重み, 分点の計算
  1067      ! Calculate Gauss node and Gaussian weight
  1068      !
  1069      use gauss_quad, only : GauLeg
  1070  
  1071      ! プランク関数の計算
  1072      ! Calculate Planck function
  1073      !
  1074      use planck_func, only : PF, DPFDT, Integ_PF_GQ_Array2D, Integ_DPFDT_GQ_Array2D
  1075  
  1076      integer , parameter :: NGaussQuad = 5
  1077      logical             :: FlagCheckLoopExit
  1078      real(DP)            :: xy_TempTMP   (0:imax-1, 1:jmax)
  1079      real(DP)            :: xy_PF        (0:imax-1, 1:jmax)
  1080      real(DP)            :: xy_DPFDT     (0:imax-1, 1:jmax)
  1081      real(DP)            :: xy_PFTable   (0:imax-1, 1:jmax)
  1082      real(DP)            :: xy_DPFDTTable(0:imax-1, 1:jmax)
  1083      real(DP)            :: ErrorPFInteg
  1084      real(DP), parameter :: ThresholdErrorPFInteg = 1.0d-3
  1085                                ! Threshold for checking accuracy of calculation of
  1086                                ! integrated Planc function by using a pre-calculated
  1087                                ! table.
  1088  
  1089      ! Variables for preparation for calculation of Plank function
  1090      !
  1091      real(DP)      , allocatable :: GQP(:)
  1092      real(DP)      , allocatable :: GQW(:)
  1093  
  1094  
  1095      integer:: i
  1096      integer:: j
  1097      integer:: l
  1098      integer:: m
  1099      integer:: n
  1100  
  1101  
  1102      ! Preparation of tables for calculation of Plank function
  1103      !
  1104      TableTempMin       =  50.0d0
  1105      TableTempMax       = 600.0d0
  1106      TableTempIncrement =   0.1d0
  1107      ntmax              = ( TableTempMax - TableTempMin ) / TableTempIncrement + 1
  1108      allocate( a_TableTemp   (1:ntmax) )
  1109      allocate( aa_TableIPF   (1:ntmax, 1:nbmax) )
  1110      allocate( aa_TableIDPFDT(1:ntmax, 1:nbmax) )
  1111  
  1112      do m = 1, ntmax
  1113        a_TableTemp(m) = TableTempMin + TableTempIncrement * ( m - 1 )
  1114      end do
  1115  
  1116  
  1117      aa_TableIPF   (:,:) = 0.0d0
     .  !cdir    nodep                                                          
     .  !cdir noassume                                                          
     .        do t455 = 1, (aa_tableipf.DSC.U2 + 1 - aa_tableipf.DSC.L2)*(      
     .       1   aa_tableipf.DSC.U1 + 1 - aa_tableipf.DSC.L1)                   
     .           aa_tableipf(aa_tableipf.DSC.L1+t455-1,aa_tableipf.DSC.L2) =    
     .       1      0.0000000000000000e+000                                     
     .        enddo                                                             
  1118      aa_TableIDPFDT(:,:) = 0.0d0
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t461 = 1, (aa_tableidpfdt.DSC.U2 + 1 - aa_tableidpfdt.DSC.L2)*(
     .       1   aa_tableidpfdt.DSC.U1 + 1 - aa_tableidpfdt.DSC.L1)             
     .           aa_tableidpfdt(aa_tableidpfdt.DSC.L1+t461-1,                   
     .       1      aa_tableidpfdt.DSC.L2) = 0.0000000000000000e+000            
     .        enddo                                                             
  1119  
  1120      allocate( GQP(1:NGaussQuad) )
  1121      allocate( GQW(1:NGaussQuad) )
  1122      do n = 1, nbmax
  1123        call GauLeg( &
  1124          & aa_BandParam(1,n), aa_BandParam(2,n), NGaussQuad, & ! (in )
  1125          & GQP, GQW                                          & ! (out)
  1126          & )
  1127        do m = 1, ntmax
  1128          do l = 1, NGaussQuad
  1129            aa_TableIPF   (m,n) = &
  1130              & aa_TableIPF   (m,n) + PF   ( GQP(l), a_TableTemp(m) ) * GQW(l)
  1131            aa_TableIDPFDT(m,n) = &
  1132              & aa_TableIDPFDT(m,n) + DPFDT( GQP(l), a_TableTemp(m) ) * GQW(l)
  1133          end do
  1134        end do
  1135      end do
  1136      deallocate( GQP )
  1137      deallocate( GQW )
  1138  
  1139  
  1140      !----------------------------------------------------
  1141      ! Check accuracy of integration of Planc function by using a pre-calculated table.
  1142      !
  1143  
  1144      !      This routine is called once here, to initialize a pre-calculated table.
  1145      n = 1
  1146      xy_TempTMP = 300.0d0
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t467 = 1, xy_temptmp.DSC.U2*xy_temptmp.DSC.U1 +                
     .       1   xy_temptmp.DSC.U2                                              
     .           xy_temptmp(t467-1,1) = 3.00000000000000e+002                   
     .        enddo                                                             
  1147      call CalcIntegratedPFWithTable2D( &
  1148        & n, xy_TempTMP,                &
  1149        & xy_PFTable,                   &
  1150        & 1, jmax,                      &
  1151        & .false.                       &
  1152        & )
  1153  
  1154      do n = 1, nbmax
  1155  
  1156        FlagCheckLoopExit = .false.
  1157        l = 1
  1158        do
  1159  
  1160          do j = 1, jmax
  1161            do i = 0, imax-1
  1162              xy_TempTMP(i,j) = &
  1163                &   a_TableTemp(1)                                                     &
  1164                & + ( a_TableTemp(2) - a_TableTemp(1) ) * 0.5d0                        &
  1165                & + ( a_TableTemp(2) - a_TableTemp(1) ) &
  1166                &     * ( imax * jmax * ( l - 1 ) + imax * ( j - 1 ) + i )
  1167            end do
     .  !cdir nodep                                                             
     .        do i = 1, imax                                                    
     .           xy_temptmp(i-1,j) = a_tabletemp(1) + (a_tabletemp(2)-          
     .       1      a_tabletemp(1))*5.00000000000000e-001 + (a_tabletemp(2)-    
     .       2      a_tabletemp(1))*dfloat(imax*(jmax*l - jmax + j) - imax + i  
     .       3       - 1)                                                       
     .        enddo                                                             
  1168          end do
  1169  
  1170          do j = 1, jmax
  1171            do i = 0, imax-1
  1172              if ( xy_TempTMP(i,j) > a_TableTemp(ntmax) ) then
  1173                xy_TempTMP(i,j) = a_TableTemp(ntmax)
  1174                FlagCheckLoopExit = .true.
  1175              end if
  1176            end do
  1177          end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do j = 1, jmax*imax                                               
     .           if (xy_temptmp(j-1,1) .gt. a_tabletemp(ntmax)) then            
     .              xy_temptmp(j-1,1) = a_tabletemp(ntmax)                      
     .              flagcheckloopexit = 1                                       
     .           endif                                                          
     .        enddo                                                             
  1178  
  1179  
  1180          call Integ_PF_GQ_Array2D(                             &
  1181            & aa_BandParam(1,n), aa_BandParam(2,n), NGaussQuad, &
  1182            & 0, imax-1, 1, jmax, xy_TempTMP,                   &
  1183            & xy_PF                                             &
  1184            & )
  1185          call Integ_DPFDT_GQ_Array2D(                          &
  1186            & aa_BandParam(1,n), aa_BandParam(2,n), NGaussQuad, & ! (in )
  1187            & 0, imax-1, 1, jmax, xy_TempTMP,                   & ! (in )
  1188            & xy_DPFDT                                          & ! (out)
  1189            & )
  1190  
  1191          call CalcIntegratedPFWithTable2D( &
  1192            & n, xy_TempTMP,                &
  1193            & xy_PFTable,                   &
  1194            & 1, jmax,                      &
  1195            & .false.                       &
  1196            & )
  1197          call CalcIntegratedPFWithTable2D( &
  1198            & n, xy_TempTMP,                &
  1199            & xy_DPFDTTable,                &
  1200            & 1, jmax,                      &
  1201            & .true.                        &
  1202            & )
  1203  
  1204          do j = 1, jmax
  1205            do i = 0, imax-1
  1206              ErrorPFInteg = &
  1207                & abs( xy_PF   (i,j) - xy_PFTable   (i,j) ) / xy_PF   (i,j)
  1208              if ( ErrorPFInteg > ThresholdErrorPFInteg ) then
  1209                call MessageNotify( 'E', module_name, 'Error of integrated PF, %f, is greater than threshold, %f, in band %d.', &
  1210                  & d = (/ ErrorPFInteg, ThresholdErrorPFInteg /), i = (/n/) )
  1211              end if
  1212              ErrorPFInteg = &
  1213                & abs( xy_DPFDT(i,j) - xy_DPFDTTable(i,j) ) / xy_DPFDT(i,j)
  1214              if ( ErrorPFInteg > ThresholdErrorPFInteg ) then
  1215                call MessageNotify( 'E', module_name, 'Error of integrated DPFDT, %f, is greater than threshold, %f, in band %d', &
  1216                  & d = (/ ErrorPFInteg, ThresholdErrorPFInteg /), i = (/n/) )
  1217              end if
  1218            end do
  1219          end do
  1220  
  1221          if ( FlagCheckLoopExit ) exit
  1222          l = l + 1
  1223        end do
  1224  
  1225      end do
  1226  
  1227    end subroutine RadEarthLWV24PrepPFTable
  1228  
  1229    !--------------------------------------------------------------------------------------
  1230  
  1231    subroutine CalcIntegratedPFWithTable2D( &
  1232      & iband, xy_Temp,                     &
  1233      & xy_IntegPF,                         &
  1234      & js, je,                             &
  1235      & flag_DPFDT                          &
  1236      & )
  1237  
  1238      ! USE statements
  1239      !
  1240  
  1241      integer , intent(in )           :: iband
  1242      real(DP), intent(in )           :: xy_temp   (0:imax-1, 1:jmax)
  1243      real(DP), intent(out)           :: xy_IntegPF(0:imax-1, 1:jmax)
  1244      integer , intent(in )           :: js
  1245      integer , intent(in )           :: je
  1246      logical , intent(in ), optional :: flag_DPFDT
  1247  
  1248      !
  1249      ! local variables
  1250      !
  1251      real(DP) :: xyz_Temp   (0:imax-1, 1:jmax, 1)
  1252      real(DP) :: xyz_IntegPF(0:imax-1, 1:jmax, 1)
  1253      integer  :: j
  1254  
  1255  
  1256      do j = js, je
  1257        xyz_Temp(:,j,1) = xy_Temp(:,j)
  1258      end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do j = 1, (je + 1 - js)*(xyz_temp.DSC.U1 + 1)                     
     .           xyz_temp(j-1,js,1) = xy_temp(j-1,js)                           
     .        enddo                                                             
  1259  
  1260      call CalcIntegratedPFWithTable3D( &
  1261        & iband, 1, xyz_temp,                 &
  1262        & xyz_IntegPF,                        &
  1263        & js, je,                             &
  1264        & flag_DPFDT                          &
  1265        & )
  1266  
  1267      do j = js, je
  1268        xy_IntegPF(:,j) = xyz_IntegPF(:,j,1)
  1269      end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do j = 1, imax - (js - je)*imax                                   
     .           xy_integpf(j-1,js) = xyz_integpf(j-1,js,1)                     
     .        enddo                                                             
  1270  
  1271  
  1272    end subroutine CalcIntegratedPFWithTable2D
  1273  
  1274    !--------------------------------------------------------------------------------------
  1275  
  1276    subroutine CalcIntegratedPFWithTable3D( &
  1277      & iband, km, xyz_temp,                &
  1278      & xyz_IntegPF,                        &
  1279      & js, je,                             &
  1280      & flag_DPFDT                          &
  1281      & )
  1282  
  1283      ! USE statements
  1284      !
  1285  
  1286      ! メッセージ出力
  1287      ! Message output
  1288      !
  1289      use dc_message, only: MessageNotify
  1290  
  1291      integer , intent(in ) :: iband
  1292      integer , intent(in ) :: km
  1293      real(DP), intent(in ) :: xyz_temp   (0:imax-1, 1:jmax, 1:km)
  1294      real(DP), intent(out) :: xyz_IntegPF(0:imax-1, 1:jmax, 1:km)
  1295      logical , intent(in ), optional :: flag_DPFDT
  1296      integer , intent(in )           :: js
  1297      integer , intent(in )           :: je
  1298  
  1299      !
  1300      ! local variables
  1301      !
  1302      logical                     :: local_flag_DPFDT
  1303  
  1304      integer                     :: xyz_TempIndex(0:imax-1, 1:jmax, 1:km)
  1305      integer                     :: i
  1306      integer                     :: j
  1307      integer                     :: k
  1308      integer                     :: m
  1309  
  1310  
  1311      do k = 1, km
  1312        do j = js, je
  1313          do i = 0, imax-1
  1314  
  1315            if ( ( xyz_Temp(i,j,k) < a_TableTemp(1)     ) .or. &
  1316              &  ( xyz_Temp(i,j,k) > a_TableTemp(ntmax) ) ) then
  1317              call MessageNotify( 'E', module_name, &
  1318                & 'Temperature is not appropriate, Temp(%d,%d,%d) = %f.', &
  1319                & i = (/i, j, k/), d = (/xyz_Temp(i,j,k)/) )
  1320            end if
  1321  
  1322            xyz_TempIndex(i,j,k) = &
  1323              & int( ( xyz_Temp(i,j,k) - TableTempMin ) / TableTempIncrement ) + 2
  1324  
  1325            if ( xyz_TempIndex(i,j,k) == 1 ) then
  1326               xyz_TempIndex(i,j,k) = 2
  1327            else if ( xyz_TempIndex(i,j,k) >= ntmax ) then
  1328               xyz_TempIndex(i,j,k) = ntmax - 1
  1329            end if
  1330  
  1331  !!$          xyz_TempIndex(i,j,k) = ntmax-1
  1332  !!$          search_index: do m = 2, ntmax-1
  1333  !!$            if ( a_TableTemp(m) >= xyz_Temp(i,j,k) ) then
  1334  !!$              xyz_TempIndex(i,j,k) = m
  1335  !!$              exit search_index
  1336  !!$            end if
  1337  !!$          end do search_index
  1338  
  1339          end do
  1340        end do
  1341      end do
  1342  
  1343  
  1344      local_flag_DPFDT = .false.
  1345      if ( present( flag_DPFDT ) ) then
  1346        if ( flag_DPFDT ) then
  1347          local_flag_DPFDT = .true.
  1348        end if
  1349      end if
  1350  
  1351      if ( .not. local_flag_DPFDT ) then
  1352        do k = 1, km
  1353          do j = js, je
  1354            do i = 0, imax-1
  1355              m = xyz_TempIndex(i,j,k)
  1356  
  1357  !!$            xyz_IntegPF(i,j,k) = &
  1358  !!$              &   ( aa_TableIPF( m, iband ) - aa_TableIPF( m-1, iband ) ) &
  1359  !!$              & / ( a_TableTemp( m )        - a_TableTemp( m-1 )        ) &
  1360  !!$              & * ( xyz_Temp(i,j,k)         - a_TableTemp( m-1 )        ) &
  1361  !!$              & +   aa_TableIPF( m-1, iband )
  1362  
  1363              xyz_IntegPF(i,j,k) = &
  1364                &   aa_TableIPF(m-1,iband)                           &
  1365                &   * ( xyz_Temp   (i,j,k) - a_TableTemp( m   ) )    &
  1366                &   * ( xyz_Temp   (i,j,k) - a_TableTemp( m+1 ) )    &
  1367                & / ( ( a_TableTemp( m-1 ) - a_TableTemp( m   ) )    &
  1368                &   * ( a_TableTemp( m-1 ) - a_TableTemp( m+1 ) ) )  &
  1369                & + aa_TableIPF(m  ,iband)                           &
  1370                &   * ( xyz_Temp   (i,j,k) - a_TableTemp( m-1 ) )    &
  1371                &   * ( xyz_Temp   (i,j,k) - a_TableTemp( m+1 ) )    &
  1372                & / ( ( a_TableTemp( m   ) - a_TableTemp( m-1 ) )    &
  1373                &   * ( a_TableTemp( m   ) - a_TableTemp( m+1 ) ) )  &
  1374                & + aa_TableIPF(m+1,iband)                           &
  1375                &   * ( xyz_Temp   (i,j,k) - a_TableTemp( m-1 ) )    &
  1376                &   * ( xyz_Temp   (i,j,k) - a_TableTemp( m   ) )    &
  1377                & / ( ( a_TableTemp( m+1 ) - a_TableTemp( m-1 ) )    &
  1378                &   * ( a_TableTemp( m+1 ) - a_TableTemp( m   ) ) )
  1379            end do
  1380          end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do j = 1, imax - (js - je)*imax                                   
     .           m = xyz_tempindex(j-1,js,k)                                    
     .           xyz_integpf(j-1,js,k) = aa_tableipf(m-1,iband)*(xyz_temp(j-1,js
     .       1      ,k)-(a_tabletemp(m)))*(xyz_temp(j-1,js,k)-a_tabletemp(m+1))/
     .       2      ((a_tabletemp(m-1)-(a_tabletemp(m)))*(a_tabletemp(m-1)-     
     .       3      a_tabletemp(m+1))) + aa_tableipf(m,iband)*(xyz_temp(j-1,js,k
     .       4      )-a_tabletemp(m-1))*(xyz_temp(j-1,js,k)-a_tabletemp(m+1))/((
     .       5      (a_tabletemp(m))-a_tabletemp(m-1))*((a_tabletemp(m))-       
     .       6      a_tabletemp(m+1))) + aa_tableipf(m+1,iband)*(xyz_temp(j-1,js
     .       7      ,k)-a_tabletemp(m-1))*(xyz_temp(j-1,js,k)-(a_tabletemp(m)))/
     .       8      ((a_tabletemp(m+1)-a_tabletemp(m-1))*(a_tabletemp(m+1)-(    
     .       9      a_tabletemp(m))))                                           
     .        enddo                                                             
  1381        end do
  1382      else
  1383        do k = 1, km
  1384          do j = js, je
  1385            do i = 0, imax-1
  1386              m = xyz_TempIndex(i,j,k)
  1387  
  1388  !!$            xyz_IntegPF(i,j,k) = &
  1389  !!$              &   ( aa_TableIDPFDT( m, iband ) - aa_TableIDPFDT( m-1, iband ) ) &
  1390  !!$              & / ( a_TableTemp   ( m )        - a_TableTemp   ( m-1 )        ) &
  1391  !!$              & * ( xyz_Temp(i,j,k)         - a_TableTemp( m-1 )        ) &
  1392  !!$              & +   aa_TableIDPFDT( m-1, iband )
  1393  
  1394              xyz_IntegPF(i,j,k) = &
  1395                &   aa_TableIDPFDT(m-1,iband)                        &
  1396                &   * ( xyz_Temp   (i,j,k) - a_TableTemp( m   ) )    &
  1397                &   * ( xyz_Temp   (i,j,k) - a_TableTemp( m+1 ) )    &
  1398                & / ( ( a_TableTemp( m-1 ) - a_TableTemp( m   ) )    &
  1399                &   * ( a_TableTemp( m-1 ) - a_TableTemp( m+1 ) ) )  &
  1400                & + aa_TableIDPFDT(m  ,iband)                        &
  1401                &   * ( xyz_Temp   (i,j,k) - a_TableTemp( m-1 ) )    &
  1402                &   * ( xyz_Temp   (i,j,k) - a_TableTemp( m+1 ) )    &
  1403                & / ( ( a_TableTemp( m   ) - a_TableTemp( m-1 ) )    &
  1404                &   * ( a_TableTemp( m   ) - a_TableTemp( m+1 ) ) )  &
  1405                & + aa_TableIDPFDT(m+1,iband)                        &
  1406                &   * ( xyz_Temp   (i,j,k) - a_TableTemp( m-1 ) )    &
  1407                &   * ( xyz_Temp   (i,j,k) - a_TableTemp( m   ) )    &
  1408                & / ( ( a_TableTemp( m+1 ) - a_TableTemp( m-1 ) )    &
  1409                &   * ( a_TableTemp( m+1 ) - a_TableTemp( m   ) ) )
  1410            end do
  1411          end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do j = 1, imax - (js - je)*imax                                   
     .           m = xyz_tempindex(j-1,js,k)                                    
     .           xyz_integpf(j-1,js,k) = aa_tableidpfdt(m-1,iband)*(xyz_temp(j-1
     .       1      ,js,k)-(a_tabletemp(m)))*(xyz_temp(j-1,js,k)-a_tabletemp(m+1
     .       2      ))/((a_tabletemp(m-1)-(a_tabletemp(m)))*(a_tabletemp(m-1)-  
     .       3      a_tabletemp(m+1))) + aa_tableidpfdt(m,iband)*(xyz_temp(j-1, 
     .       4      js,k)-a_tabletemp(m-1))*(xyz_temp(j-1,js,k)-a_tabletemp(m+1)
     .       5      )/(((a_tabletemp(m))-a_tabletemp(m-1))*((a_tabletemp(m))-   
     .       6      a_tabletemp(m+1))) + aa_tableidpfdt(m+1,iband)*(xyz_temp(j-1
     .       7      ,js,k)-a_tabletemp(m-1))*(xyz_temp(j-1,js,k)-(a_tabletemp(m)
     .       8      ))/((a_tabletemp(m+1)-a_tabletemp(m-1))*(a_tabletemp(m+1)-( 
     .       9      a_tabletemp(m))))                                           
     .        enddo                                                             
  1412        end do
  1413      end if
  1414  
  1415  
  1416    end subroutine CalcIntegratedPFWithTable3D
  1417  
  1418    !--------------------------------------------------------------------------------------
  1419  
  1420  end module rad_Earth_LW_V2_4
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:53 2016
FILE NAME: rad_Earth_LW_V2_4.f90
PROGRAM NAME: rad_earth_lw_v2_4
FORMAT LIST

  LINE    LOOP      FORTRAN STATEMENT

     1:             != 地球大気向け長波放射モデル Ver. 2.4
     2:             !
     3:             != long wave radiation model for the Earth's atmosphere Ver. 2.4
     4:             !
     5:             ! Authors::   Yoshiyuki O. TAKAHASHI
     6:             ! Version::   $Id: rad_Earth_LW_V2_4.f90,v 1.3 2015/01/29 12:06:43 yot Exp $
     7:             ! Tag Name::  $Name:  $
     8:             ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9:             ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10:             !
    11:             
    12:             module rad_Earth_LW_V2_4
    13:               !
    14:               != 地球大気向け長波放射モデル Ver. 2.4
    15:               !
    16:               != long wave radiation model for the Earth's atmosphere Ver. 2.4
    17:               !
    18:               ! <b>Note that Japanese and English are described in parallel.</b>
    19:               !
    20:               ! 長波放射モデル.
    21:               !
    22:               ! This is a model of long wave radiation for the Earth's atmospehre. 
    23:               ! Radiation in the wavenumber range from    0 to  3000 cm-1 
    24:               ! is calculated following the scheme by Chou et al. (2001). 
    25:               ! But absorptions by CFC and weak bands desinated as band 10 in Chou et al. (2001) are neglected.
    26:               !
    27:               !== References
    28:               !
    29:               !  Chou, M.-D., M. J. Suarez, X.-Z. Liang, and M. M.-H. Yan, 
    30:               !    A thermal infrared radiation parameterization for atmospheric studies, 
    31:               !    NASA Technical Report Series on Global Modeling and Data Assimilation, 
    32:               !    19, NASA/TM-2001-104606, 2001.
    33:               !
    34:               !== Procedures List
    35:               !
    36:               ! RadEarthLWV24Flux :: 放射フラックスの計算
    37:               ! ------------      :: ------------
    38:               ! RadEarthLWV24Flux :: Calculate radiation flux
    39:               !
    40:               !== NAMELIST
    41:               !
    42:               ! NAMELIST#rad_Earth_LW_V2_4_nml
    43:               !
    44:             
    45:               ! USE statements
    46:               !
    47:             
    48:               ! 
    49:               ! Kind type parameter
    50:               !
    51:               use dc_types, only: DP, &      ! Double precision.
    52:                 &                 STRING, &  ! Strings.
    53:                 &                 TOKEN      ! Keywords.
    54:             
    55:               ! 物理・数学定数設定
    56:               ! Physical and mathematical constants settings
    57:               !
    58:               use constants0, only: &
    59:                 & PI                    ! $ \pi $ .
    60:                                         ! 円周率.  Circular constant
    61:             
    62:               ! 
    63:               ! Grid points settings
    64:               !
    65:               use gridset, only: imax, & ! 
    66:                                          ! Number of grid points in longitude
    67:                 &                jmax, & ! 
    68:                                          ! Number of grid points in latitude
    69:                 &                kmax    ! 
    70:                                          ! Number of vertical level
    71:             
    72:             
    73:               ! Declaration statements
    74:               !
    75:               implicit none
    76:               private
    77:             
    78:               !
    79:               ! Public procedure
    80:               !
    81:               public :: RadEarthLWV24Flux
    82:               public :: RadEarthLWV24Init
    83:             
    84:             
    85:               character(*), parameter:: module_name = 'rad_Earth_LW_V2_4'
    86:                                           ! モジュールの名称.
    87:                                           ! Module name
    88:               character(*), parameter:: version = &
    89:                 & '$Name:  $' // &
    90:                 & '$Id: rad_Earth_LW_V2_4.f90,v 1.3 2015/01/29 12:06:43 yot Exp $'
    91:                                           ! モジュールのバージョン
    92:                                           ! Module version
    93:             
    94:             
    95:               logical , save :: FlagHighAlt
    96:             
    97:             
    98:               integer , parameter :: nbmax = 10
    99:               real(DP), save      :: aa_BandParam(1:2, 1:nbmax)
   100:             
   101:               real(DP), allocatable, save :: xyrra_TransSaved (:,:,:,:,:)
   102:               real(DP), allocatable, save :: xyrr_TransMASaved(:,:,:,:)
   103:             
   104:               real(DP), parameter :: DiffFactor = 1.66d0
   105:             
   106:             
   107:             
   108:               ! MEMO:
   109:               ! Bands range from 0 to 3000 cm-1.
   110:               !
   111:               data aa_BandParam &
   112:                 & / &
   113:                 &    0.0d0,  340.0d0, & ! 1:H2O
   114:                 &  340.0d0,  540.0d0, & ! 2:H2O
   115:                 &  540.0d0,  800.0d0, & ! 3:H2O + CO2
   116:                 &  800.0d0,  980.0d0, & ! 4:H2O (+ CO2)
   117:                 &  980.0d0, 1100.0d0, & ! 5:H2O (+ CO2) + O3
   118:                 & 1100.0d0, 1215.0d0, & ! 6:H2O + N2O + CH4
   119:                 & 1215.0d0, 1380.0d0, & ! 7:H2O + N2O + CH4
   120:                 & 1380.0d0, 1900.0d0, & ! 8:H2O
   121:                 & 1900.0d0, 3000.0d0, & ! 9:H2O
   122:                 &  540.0d0,  620.0d0  & !10:H2O + CO2, N2O  ! This band is not used, now.
   123:                 & /
   124:             
   125:             
   126:               logical , save:: flag_save_time
   127:             
   128:             
   129:               real(DP), save:: IntTimeSave
   130:                                           ! 長波フラックスを計算する時間間隔.
   131:                                           ! Interval time of long wave flux calculation
   132:               real(DP), save:: PrevTimeSave
   133:                                           ! 前回長波フラックスを計算した時刻.
   134:                                           ! Time when long wave flux is calculated
   135:             
   136:             
   137:               logical              , save:: FlagTransSaved
   138:               data FlagTransSaved / .false. /
   139:             
   140:             
   141:             
   142:               ! Variables for integration of Planc function by using a pre-calculated table.
   143:               !
   144:               integer , save              :: ntmax
   145:               real(DP), save, allocatable :: a_TableTemp   (:)
   146:               real(DP), save              :: TableTempMin
   147:               real(DP), save              :: TableTempMax
   148:               real(DP), save              :: TableTempIncrement
   149:               real(DP), save, allocatable :: aa_TableIPF   (:,:)
   150:               real(DP), save, allocatable :: aa_TableIDPFDT(:,:)
   151:             
   152:             
   153:             
   154:               ! 公開変数
   155:               ! Public variables
   156:               !
   157:               logical, save :: rad_Earth_LW_V2_4_inited = .false.
   158:                                           ! 初期設定フラグ.
   159:                                           ! Initialization flag
   160:             
   161:             
   162:             
   163:             contains
   164:             
   165:               !--------------------------------------------------------------------------------------
   166:             
   167:               subroutine RadEarthLWV24Flux(                                &
   168:                 & xyz_DelCO2Mass,                                          & ! (in )
   169:                 & xyz_DelH2OVapMass, xyz_DelH2OLiqMass, xyz_DelH2OSolMass, & ! (in )
   170:                 & xyz_DelO3Mass,                                           & ! (in )
   171:                 & xyz_DelN2OMass, xyz_DelCH4Mass,                          & ! (in )
   172:                 & xyz_Press, xyz_Temp, xy_SurfTemp,                        & ! (in )
   173:                 & xyz_QCO2, xyz_QH2OVap,                                   & ! (in )
   174:                 & xyz_QN2O, xyz_QCH4,                                      & ! (in )
   175:                 & xyz_CloudCover,                                          & ! (in )
   176:                 & xyz_CloudWatREff, xyz_CloudIceREff,                      & ! (in )
   177:                 & xyr_RadLUwFlux, xyr_RadLDwFlux,                          & ! (out)
   178:                 & xyra_DelRadLUwFlux, xyra_DelRadLDwFlux                   & ! (out)
   179:                 & )
   180:             
   181:             
   182:                 ! USE statements
   183:                 !
   184:             
   185:                 ! メッセージ出力
   186:                 ! Message output
   187:                 !
   188:                 use dc_message, only: MessageNotify
   189:             
   190:                 ! 時刻管理
   191:                 ! Time control
   192:                 !
   193:                 use timeset, only: &
   194:                   & TimeN, &              ! ステップ $ t $ の時刻.
   195:                                           ! Time of step $ t $.
   196:                   & TimesetClockStart, TimesetClockStop
   197:             
   198:             
   199:             !!$    ! Chou et al (1991) による長波放射モデル
   200:             !!$    ! Long radiation model described by Chou et al (1991)
   201:             !!$    !
   202:             !!$    use rad_C1991, only :               &
   203:             !!$      & RadC1991CalcTransMAH2O
   204:             
   205:                 ! Chou and Kouvaris (1991) による長波放射モデル
   206:                 ! Long radiation model described by Chou and Kouvaris (1991)
   207:                 !
   208:                 use rad_CK1991, only : RadCK1991CalcTrans
   209:             
   210:                 ! Chou et al. (2001) による長波放射モデル
   211:                 ! Long radiation model described by Chou et al. (2001)
   212:                 !
   213:                 use rad_C2001, only :          &
   214:                   & RadC2001CalcTransBand3CO2, &
   215:                   & RadC2001CalcTransBand3H2O, &
   216:                   & RadC2001CalcTrans,         &
   217:                   & RadC2001ReduceCloudOptDep, &
   218:                   & RadC2001CalcCloudOptProp , &
   219:                   & RadC2001CalcIntegratedPF2D, &
   220:                   & RadC2001CalcIntegratedPF3D
   221:             
   222:                 ! 散乱を無視した放射伝達方程式
   223:                 ! Radiative transfer equation without considering scattering
   224:                 !
   225:                 use rad_rte_nonscat, only : RadRTENonScat !, RadRTENonScatAnotherForm
   226:             
   227:                 ! 雲関系ルーチン
   228:                 ! Cloud-related routines
   229:                 !
   230:                 use cloud_utils, only :         &
   231:                   & CloudUtilsLocalizeCloud,    &
   232:                   & CloudUtilsCalcOverlapCloudTrans
   233:             
   234:             
   235:                 real(DP), intent(in ):: xyz_DelCO2Mass   (0:imax-1, 1:jmax, 1:kmax)
   236:                 real(DP), intent(in ):: xyz_DelH2OVapMass(0:imax-1, 1:jmax, 1:kmax)
   237:                 real(DP), intent(in ):: xyz_DelH2OLiqMass(0:imax-1, 1:jmax, 1:kmax)
   238:                 real(DP), intent(in ):: xyz_DelH2OSolMass(0:imax-1, 1:jmax, 1:kmax)
   239:                 real(DP), intent(in ):: xyz_DelO3Mass    (0:imax-1, 1:jmax, 1:kmax)
   240:                 real(DP), intent(in ):: xyz_DelN2OMass   (0:imax-1, 1:jmax, 1:kmax)
   241:                 real(DP), intent(in ):: xyz_DelCH4Mass   (0:imax-1, 1:jmax, 1:kmax)
   242:                 real(DP), intent(in ):: xyz_Press        (0:imax-1, 1:jmax, 1:kmax)
   243:                 real(DP), intent(in ):: xyz_Temp         (0:imax-1, 1:jmax, 1:kmax)
   244:                 real(DP), intent(in ):: xy_SurfTemp      (0:imax-1, 1:jmax)
   245:                 real(DP), intent(in ):: xyz_QCO2         (0:imax-1, 1:jmax, 1:kmax)
   246:                 real(DP), intent(in ):: xyz_QH2OVap      (0:imax-1, 1:jmax, 1:kmax)
   247:                 real(DP), intent(in ):: xyz_QN2O         (0:imax-1, 1:jmax, 1:kmax)
   248:                 real(DP), intent(in ):: xyz_QCH4         (0:imax-1, 1:jmax, 1:kmax)
   249:                 real(DP), intent(in ):: xyz_CloudCover   (0:imax-1, 1:jmax, 1:kmax)
   250:                 real(DP), intent(in ):: xyz_CloudWatREff (0:imax-1, 1:jmax, 1:kmax)
   251:                 real(DP), intent(in ):: xyz_CloudIceREff (0:imax-1, 1:jmax, 1:kmax)
   252:                 real(DP), intent(out):: xyr_RadLUwFlux    (0:imax-1, 1:jmax, 0:kmax)
   253:                 real(DP), intent(out):: xyr_RadLDwFlux    (0:imax-1, 1:jmax, 0:kmax)
   254:                 real(DP), intent(out):: xyra_DelRadLUwFlux(0:imax-1, 1:jmax, 0:kmax, 0:1)
   255:                 real(DP), intent(out):: xyra_DelRadLDwFlux(0:imax-1, 1:jmax, 0:kmax, 0:1)
   256:             
   257:             
   258:                 !
   259:                 ! Work variables
   260:                 !
   261:                 real(DP) :: xy_SurfEmis       (0:imax-1, 1:jmax)
   262:             
   263:                 real(DP) :: xyz_CloudREff     (0:imax-1, 1:jmax, 1:kmax)
   264:                 real(DP) :: xyz_CloudExtCoef  (0:imax-1, 1:jmax, 1:kmax)
   265:             
   266:                 real(DP) :: xyz_CloudWatSSA      (0:imax-1, 1:jmax, 1:kmax)
   267:                 real(DP) :: xyz_CloudIceSSA      (0:imax-1, 1:jmax, 1:kmax)
   268:                 real(DP) :: xyz_CloudWatAF       (0:imax-1, 1:jmax, 1:kmax)
   269:                 real(DP) :: xyz_CloudIceAF       (0:imax-1, 1:jmax, 1:kmax)
   270:             
   271:                 real(DP) :: xyz_DelCloudWatOptDep(0:imax-1, 1:jmax, 1:kmax)
   272:                 real(DP) :: xyz_DelCloudIceOptDep(0:imax-1, 1:jmax, 1:kmax)
   273:             
   274:                 real(DP) :: xyz_TransCloudOneLayer (0:imax-1, 1:jmax, 1:kmax)
   275:                 real(DP) :: xyrr_TransCloud        (0:imax-1, 1:jmax, 0:kmax, 0:kmax)
   276:             
   277:                 real(DP) :: xyrr_Trans            (0:imax-1, 1:jmax, 0:kmax, 0:kmax)
   278:                 real(DP) :: xyrr_TransEach        (0:imax-1, 1:jmax, 0:kmax, 0:kmax)
   279:                 real(DP) :: xyr_RadFlux           (0:imax-1, 1:jmax, 0:kmax)
   280:                 real(DP) :: xyra_DelRadFlux       (0:imax-1, 1:jmax, 0:kmax, 0:1)
   281:             
   282:                 real(DP) :: xyz_IntPF   (0:imax-1, 1:jmax, 1:kmax)
   283:                 real(DP) :: xy_SurfIntPF(0:imax-1, 1:jmax)
   284:                 real(DP) :: xy_IntDPFDT0(0:imax-1, 1:jmax)
   285:                 real(DP) :: xy_IntDPFDT1(0:imax-1, 1:jmax)
   286:             
   287:             
   288:             !!$    real(DP) :: xyr_RadFluxMA    (0:imax-1, 1:jmax, 0:kmax)
   289:             !!$    real(DP) :: xyra_DelRadFluxMA(0:imax-1, 1:jmax, 0:kmax, 0:1)
   290:             
   291:                 real(DP) :: xyz_IntPF2   (0:imax-1, 1:jmax, 1:kmax)
   292:                 real(DP) :: xy_SurfIntPF2(0:imax-1, 1:jmax)
   293:                 real(DP) :: xy_IntDPFDT02(0:imax-1, 1:jmax)
   294:                 real(DP) :: xy_IntDPFDT12(0:imax-1, 1:jmax)
   295:             
   296:             
   297:                 real(DP) :: xyr_RadUwFlux (0:imax-1, 1:jmax, 0:kmax)
   298:                 real(DP) :: xyr_RadDwFlux (0:imax-1, 1:jmax, 0:kmax)
   299:                 real(DP) :: xyra_DelRadUwFlux (0:imax-1, 1:jmax, 0:kmax, 0:1)
   300:                 real(DP) :: xyra_DelRadDwFlux (0:imax-1, 1:jmax, 0:kmax, 0:1)
   301:             
   302:             
   303:                 integer  :: n
   304:             
   305:                 integer  :: i, j, k
   306:             
   307:             
   308:                 ! 初期化確認
   309:                 ! Initialization check
   310:                 !
   311:                 if ( .not. rad_Earth_LW_V2_4_inited ) then
   312:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   313:                 end if
   314:             
   315:             
   316:                 ! 計算時間計測開始
   317:                 ! Start measurement of computation time
   318:                 !
   319:                 call TimesetClockStart( module_name )
   320:             
   321:             
   322:                 ! Check whether the transmittance is saved or not
   323:                 !
   324:                 if (  .not. FlagTransSaved ) then
   325:                   if ( TimeN - PrevTimeSave >= IntTimeSave ) then
   326:                     call MessageNotify( 'M', module_name, &
   327:                       & 'Transmittance is not saved, but criterion for transmittance calculation is met.' )
   328:                   else
   329:                     call MessageNotify( 'M', module_name, &
   330:                       & 'Transmittance is not saved, and criterion for transmittance calculation ' &
   331:                       & // 'is not met. However, transmittance will be calculated.' )
   332:                   end if
   333:                 end if
   334:             
   335:             
   336:                 if ( ( TimeN - PrevTimeSave >= IntTimeSave ) .or. ( .not. FlagTransSaved ) ) then
   337:             
   338:             !!$      write( 6, * ) 'CalcTrans'
   339:             
   340:                   if ( .not. FlagTransSaved ) then
   341:                     PrevTimeSave = TimeN
   342:                   else
   343:                     PrevTimeSave = PrevTimeSave + IntTimeSave
   344:                   end if
   345:             
   346:                   FlagTransSaved = .true.
   347:             
   348:             
   349: +------>          LOOP_band_trans: do n = 1, nbmax
   350: |           
   351: |W***== A           xyrr_Trans = 1.0_DP
   352: |           
   353: |                   if ( n == nbmax ) then
   354: |           
   355: |                     ! Now, nothing is done when n = nbmax.
   356: |           
   357: |                   else if ( n == 3 ) then
   358: |                     ! 540-800 cm-1
   359: |           
   360: |                     !   Calculation of H2O line and continuum transmittance
   361: |                     call RadC2001CalcTransBand3H2O(                          &
   362: |                       & xyz_DelH2OVapMass, xyz_Press, xyz_Temp, xyz_QH2OVap, & ! (in)
   363: |                       & xyrr_TransEach                                       & ! (out)
   364: |                       & )
   365: |W***== A             xyrr_Trans = xyrr_Trans * xyrr_TransEach
   366: |                     !   Calculation of CO2 transmittance
   367: |                     if ( FlagHighAlt ) then
   368: |                       ! Transmittance calculation for middle atmospehre as well as lower atmosphere
   369: |                       call RadCK1991CalcTrans(                 &
   370: |                         & xyz_DelCO2Mass, xyz_Press, xyz_Temp, & ! (in)
   371: |                         & 'CO2',                               & ! (in)
   372: |                         & xyrr_TransEach                       & ! (out)
   373: |                         & )
   374: |                     else
   375: |                       ! Transmittance calculation for lower atmoshere
   376: |                       call RadC2001CalcTransBand3CO2(                       &
   377: |                         & xyz_DelCO2Mass, xyz_Press, xyz_Temp, xyz_QCO2,    & ! (in)
   378: |                         & xyrr_TransEach                                    & ! (out)
   379: |                         & )
   380: |                     end if
   381: |+++V== A             xyrr_Trans = xyrr_Trans * xyrr_TransEach
   382: |           
   383: |                   else
   384: |           
   385: |                     !   Calculation of H2O continuum transmittance
   386: |                     call RadC2001CalcTrans(                                  &
   387: |                       & 'H2OCont', n,                                        & ! (in)
   388: |                       & xyz_DelH2OVapMass, xyz_Press, xyz_Temp, xyz_QH2OVap, & ! (in)
   389: |                       & xyrr_TransEach                                       & ! (out)
   390: |                       & )
   391: |W***== A             xyrr_Trans = xyrr_Trans * xyrr_TransEach
   392: |                     !   Calculation of H2O line transmittance
   393: |                     call RadC2001CalcTrans(                                  &
   394: |                       & 'H2OLine', n,                                        & ! (in)
   395: |                       & xyz_DelH2OVapMass, xyz_Press, xyz_Temp, xyz_QH2OVap, & ! (in)
   396: |                       & xyrr_TransEach                                       & ! (out)
   397: |                       & )
   398: |W***== A             xyrr_Trans = xyrr_Trans * xyrr_TransEach
   399: |           
   400: |                     ! Calculation of O3 transmittance
   401: |                     if ( n == 5 ) then
   402: |                       ! 980-1100 cm-1
   403: |                       call RadCK1991CalcTrans(                &
   404: |                         & xyz_DelO3Mass, xyz_Press, xyz_Temp, & ! (in)
   405: |                         & 'O3',                               & ! (in)
   406: |                         & xyrr_TransEach                      & ! (out)
   407: |                         & )
   408: |W***== A               xyrr_Trans = xyrr_Trans * xyrr_TransEach
   409: |                     end if
   410: |           
   411: |                     ! Calculation of N2O transmittance
   412: |                     if ( ( n == 6 ) .or. ( n == 7 ) .or. ( n == 10 ) ) then
   413: |++V=== A               if ( maxval( xyz_DelN2OMass ) > 0.0_DP ) then
   414: |                         call RadC2001CalcTrans(                                  &
   415: |                           & 'N2OLine', n,                                        & ! (in)
   416: |                           & xyz_DelN2OMass, xyz_Press, xyz_Temp, xyz_QN2O,       & ! (in)
   417: |                           & xyrr_TransEach                                       & ! (out)
   418: |                           & )
   419: |W***== A                 xyrr_Trans = xyrr_Trans * xyrr_TransEach
   420: |                       end if
   421: |                     end if
   422: |           
   423: |                     ! Calculation of CH4 transmittance
   424: |                     if ( ( n == 6 ) .or. ( n == 7 ) ) then
   425: |++V=== A               if ( maxval( xyz_DelCH4Mass ) > 0.0_DP ) then
   426: |                         call RadC2001CalcTrans(                                  &
   427: |                           & 'CH4Line', n,                                        & ! (in)
   428: |                           & xyz_DelCH4Mass, xyz_Press, xyz_Temp, xyz_QCH4,       & ! (in)
   429: |                           & xyrr_TransEach                                       & ! (out)
   430: |                           & )
   431: |W***== A                 xyrr_Trans = xyrr_Trans * xyrr_TransEach
   432: |                       end if
   433: |                     end if
   434: |           
   435: |                     ! Calculation of CO2 transmittance in weak bands
   436: |                     if ( ( n == 4 ) .or. ( n == 5 ) .or. ( n == 10 ) ) then
   437: |                       call RadC2001CalcTrans(                                  &
   438: |                         & 'WeakBandCO2Line', n,                                & ! (in)
   439: |                         & xyz_DelCO2Mass, xyz_Press, xyz_Temp, xyz_QCO2,       & ! (in)
   440: |                         & xyrr_TransEach                                       & ! (out)
   441: |                         & )
   442: |W***== A               xyrr_Trans = xyrr_Trans * xyrr_TransEach
   443: |                     end if
   444: |           
   445: |                   end if
   446: |           
   447: |+++V== A           xyrra_TransSaved(:,:,:,:,n) = xyrr_Trans
   448: |           
   449: +------           end do LOOP_band_trans
   450:             
   451:                   !
   452:                   !   Calculation of transmittance of water vapor by using a method for middle 
   453:                   !   atmosphere
   454:                   !
   455:             !!$      call RadC1991CalcTransMAH2O(      &
   456:             !!$        & xyr_Press, xyz_Press, xyz_Temp, xyz_QH2OVap, & ! (in)
   457:             !!$        & xyrr_Trans                                & ! (out)
   458:             !!$        & )
   459: ***V--->A         xyrr_Trans = -1.0d100
   460: ||||        
   461: ***V--- A         xyrr_TransMASaved = xyrr_Trans
   462:             
   463:                 end if
   464:             
   465:             
   466:             
   467:                 !
   468:                 ! Calculate radiative flux
   469:                 !
   470:             
   471: W*=====         xy_SurfEmis = 1.0_DP
   472:             
   473: **W---->A       xyr_RadLUwFlux     = 0.0_DP
   474: **W---- A       xyr_RadLDwFlux     = 0.0_DP
   475: ***W--->A       xyra_DelRadLUwFlux = 0.0_DP
   476: ***W--- A       xyra_DelRadLDwFlux = 0.0_DP
   477:             
   478:             
   479: +------>        LOOP_band_RTE : do n = 1, nbmax
   480: |           
   481: |           
   482: |W**=== A         xyz_CloudREff = xyz_CloudWatREff
   483: |                 call RadC2001CalcCloudOptProp(                         &
   484: |                   & 'Liquid', n, xyz_CloudREff,                        & ! (in)
   485: |                   & xyz_CloudExtCoef, xyz_CloudWatSSA, xyz_CloudWatAF  & ! (out)
   486: |                   & )
   487: |**W--->A         xyz_DelCloudWatOptDep = xyz_CloudExtCoef * xyz_DelH2OLiqMass
   488: ||||              !
   489: |**W--- A         xyz_CloudREff = xyz_CloudIceREff
   490: |                 call RadC2001CalcCloudOptProp(                         &
   491: |                   & 'Ice', n, xyz_CloudREff,                           & ! (in)
   492: |                   & xyz_CloudExtCoef, xyz_CloudIceSSA, xyz_CloudIceAF  & ! (out)
   493: |                   & )
   494: |W**=== A         xyz_DelCloudIceOptDep = xyz_CloudExtCoef * xyz_DelH2OSolMass
   495: |           
   496: |                 call RadC2001ReduceCloudOptDep(      &
   497: |                   & xyz_CloudWatSSA, xyz_CloudWatAF, & ! (in)
   498: |                   & xyz_DelCloudWatOptDep            & ! (inout)
   499: |                   & )
   500: |                 call RadC2001ReduceCloudOptDep(      &
   501: |                   & xyz_CloudIceSSA, xyz_CloudIceAF, & ! (in)
   502: |                   & xyz_DelCloudIceOptDep            & ! (inout)
   503: |                   & )
   504: |                 !
   505: |                 call CloudUtilsLocalizeCloud(  &
   506: |                   & xyz_CloudCover,            & ! (in   )
   507: |                   & xyz_DelCloudWatOptDep      & ! (inout)
   508: |                   & )
   509: |                 call CloudUtilsLocalizeCloud(  &
   510: |                   & xyz_CloudCover,            & ! (in   )
   511: |                   & xyz_DelCloudIceOptDep      & ! (inout)
   512: |                   & )
   513: |                 !
   514: |W**=== A         xyz_TransCloudOneLayer = &
   515: |                   & exp( - ( xyz_DelCloudWatOptDep + xyz_DelCloudIceOptDep ) * DiffFactor )
   516: |                 !
   517: |                 call CloudUtilsCalcOverlapCloudTrans(       &
   518: |                   & xyz_TransCloudOneLayer, xyz_CloudCover, & ! (in)
   519: |                   & xyrr_TransCloud                         & ! (out)
   520: |                   & )
   521: |           
   522: |           
   523: |                 ! Now, nothing is done when n = nbmax.
   524: |                 if ( n == nbmax ) cycle
   525: |           
   526: |           
   527: |***V-->A         xyrr_Trans = xyrra_TransSaved(:,:,:,:,n)
   528: |||||       
   529: |***V-- A         xyrr_Trans = xyrr_Trans * xyrr_TransCloud
   530: |           
   531: |           
   532: |           
   533: |                 call CalcIntegratedPFWithTable2D( &
   534: |                   & n, xy_SurfTemp,                         &
   535: |                   & xy_SurfIntPF,                           &
   536: |                   & 1, jmax                                 &
   537: |                   & )
   538: |                 call CalcIntegratedPFWithTable3D( &
   539: |                   & n, kmax, xyz_Temp,                    &
   540: |                   & xyz_IntPF,                            &
   541: |                   & 1, jmax                               &
   542: |                   & )
   543: |           
   544: |                 call CalcIntegratedPFWithTable2D( &
   545: |                   & n, xy_SurfTemp,                         &
   546: |                   & xy_IntDPFDT0,                           &
   547: |                   & 1, jmax,                                &
   548: |                   & .true.                                  &
   549: |                   & )
   550: |                 call CalcIntegratedPFWithTable2D( &
   551: |                   & n, xyz_Temp(:,:,1),                     &
   552: |                   & xy_IntDPFDT1,                           &
   553: |                   & 1, jmax,                                &
   554: |                   & .true.                                  &
   555: |                   & )
   556: |           
   557: |W*==== A         xy_SurfIntPF = xy_SurfEmis * PI * xy_SurfIntPF
   558: |W**=== A         xyz_IntPF    =               PI * xyz_IntPF
   559: |*W---->A         xy_IntDPFDT0 = xy_SurfEmis * PI * xy_IntDPFDT0
   560: |*W---- A         xy_IntDPFDT1 =               PI * xy_IntDPFDT1
   561: |           
   562: |           
   563: |           
   564: |                 ! Lines below are under testing.
   565: |                 !
   566: |           !!$      xy_SurfIntPF2 = xy_SurfIntPF
   567: |           !!$      xyz_IntPF2    = xyz_IntPF
   568: |           !!$      xy_IntDPFDT02 = xy_IntDPFDT0
   569: |           !!$      xy_IntDPFDT12 = xy_IntDPFDT1
   570: |           !!$
   571: |           !!$
   572: |           !!$      call RadC2001CalcIntegratedPF2D(       &
   573: |           !!$        & n, xy_SurfTemp,                    &
   574: |           !!$        & xy_SurfIntPF                       &
   575: |           !!$        & )
   576: |           !!$      call RadC2001CalcIntegratedPF3D(       &
   577: |           !!$        & n, kmax, xyz_Temp,                 &
   578: |           !!$        & xyz_IntPF                          &
   579: |           !!$        & )
   580: |           !!$
   581: |           !!$      call RadC2001CalcIntegratedPF2D(       &
   582: |           !!$        & n, xy_SurfTemp,                    &
   583: |           !!$        & xy_IntDPFDT0,                      &
   584: |           !!$        & .true.                             &
   585: |           !!$        & )
   586: |           !!$      call RadC2001CalcIntegratedPF2D(       &
   587: |           !!$        & n, xyz_Temp(:,:,1),                &
   588: |           !!$        & xy_IntDPFDT1,                      &
   589: |           !!$        & .true.                             &
   590: |           !!$        & )
   591: |           !!$
   592: |           !!$      xy_SurfIntPF = xy_SurfEmis * xy_SurfIntPF
   593: |           !!$      xyz_IntPF    =               xyz_IntPF
   594: |           !!$      xy_IntDPFDT0 = xy_SurfEmis * xy_IntDPFDT0
   595: |           !!$      xy_IntDPFDT1 =               xy_IntDPFDT1
   596: |           !!$
   597: |           !!$      do j = 1, jmax
   598: |           !!$        do i = 0, imax-1
   599: |           !!$          write( 20+n, * ) xy_SurfTemp(i,j), xy_SurfIntPF2(i,j), xy_SurfIntPF(i,j), &
   600: |           !!$            & xy_IntDPFDT02(i,j), xy_IntDPFDT02(i,j)
   601: |           !!$        end do
   602: |           !!$      end do
   603: |           !!$      do j = 1, jmax
   604: |           !!$        do i = 0, imax-1
   605: |           !!$          write( 40+n, * ) xyz_Temp(i,j,1), xy_IntDPFDT12(i,j), xy_IntDPFDT12(i,j)
   606: |           !!$        end do
   607: |           !!$      end do
   608: |           !!$      do k = 1, kmax
   609: |           !!$        do j = 1, jmax
   610: |           !!$          do i = 0, imax-1
   611: |           !!$            write( 60+n, * ) xyz_Temp(i,j,k), xyz_IntPF2(i,j,k), xyz_IntPF(i,j,k)
   612: |           !!$          end do
   613: |           !!$        end do
   614: |           !!$      end do
   615: |           !!$      call flush( 20+n )
   616: |           !!$      call flush( 40+n )
   617: |           !!$      call flush( 60+n )
   618: |           
   619: |           
   620: |           
   621: |           !!$      call OLD_RadRTENonScat(                                      &
   622: |           !!$        & xyz_IntPF, xy_SurfIntPF, xy_IntDPFDT1, xy_IntDPFDT0, & ! (in)
   623: |           !!$        & xyrr_Trans,                                          & ! (in)
   624: |           !!$        & xyr_RadFlux, xyra_DelRadFlux                         & ! (out)
   625: |           !!$        & )
   626: |           
   627: |                 call RadRTENonScat(                                                &
   628: |           !!$      call RadRTENonScatAnotherForm( &
   629: |                   & xyz_IntPF, xy_SurfIntPF, xy_IntDPFDT1, xy_IntDPFDT0, & ! (in)
   630: |                   & xyrr_Trans,                                          & ! (in)
   631: |                   & xyr_RadUwFlux, xyr_RadDwFlux,                      & ! (out)
   632: |                   & xyra_DelRadUwFlux, xyra_DelRadDwFlux               & ! (out)
   633: |                   & )
   634: |           
   635: |           
   636: |           
   637: |           !!$      i = 0
   638: |           !!$      j = jmax/2+1
   639: |           !!$      do k = 0, kmax
   640: |           !!$        write( 6, * ) k, xyr_RadFlux(i,j,k), &
   641: |           !!$          & xyr_RadFlux(i,j,k) - ( xyr_RadUwFlux(i,j,k) - xyr_RadDwFlux(i,j,k) )
   642: |           !!$      end do
   643: |           !!$      do k = 0, kmax
   644: |           !!$        write( 6, * ) k, &
   645: |           !!$          & xyra_DelRadFlux(i,j,k,0), &
   646: |           !!$          & xyra_DelRadFlux(i,j,k,0) - ( xyra_DelRadUwFlux(i,j,k,0) - xyra_DelRadDwFlux(i,j,k,0) ), &
   647: |           !!$          & xyra_DelRadFlux(i,j,k,1), &
   648: |           !!$          & xyra_DelRadFlux(i,j,k,1) - ( xyra_DelRadUwFlux(i,j,k,1) - xyra_DelRadDwFlux(i,j,k,1) )
   649: |           !!$      end do
   650: |           
   651: |           
   652: |           
   653: |           !!$      if ( ( n == 1 ) .or. ( n == 2 ) .or. ( n == 9 ) ) then
   654: |           !!$        !
   655: |           !!$        ! For bands 0-340, 340-540, 1380-1900
   656: |           !!$        ! merge with flux calculated with a method for middle atmosphere
   657: |           !!$        !
   658: |           !!$
   659: |           !!$        xyrr_Trans = xyrr_TransMASaved
   660: |           !!$
   661: |           !!$        call RadELWV22IntegRTE(                               &
   662: |           !!$          & n,                                                & ! (in )
   663: |           !!$          & xyz_Temp, xy_SurfTemp, xy_SurfEmis, xyrr_Trans,   & ! (in )
   664: |           !!$          & xyr_RadFluxMA, xyra_DelRadFluxMA                  & ! (out)
   665: |           !!$          & )
   666: |           !!$
   667: |           !!$        call RadDcpamELWV22CutMergeFlux(          &
   668: |           !!$          & xyr_Press,                            & ! (in)
   669: |           !!$          & xyr_RadFlux, xyra_DelRadFlux,         & ! (inout)
   670: |           !!$          & xyr_RadFluxMA, xyra_DelRadFluxMA      & ! (in) optional
   671: |           !!$          & )
   672: |           !!$
   673: |           !!$      else if ( ( n == 4 ) .or. ( n == 6 ) .or. ( n == 8 ) ) then
   674: |           !!$        !
   675: |           !!$        ! For bands 800-980, 1100-1380, 1900-3000
   676: |           !!$        ! flux above a pressure level is modified to be constant
   677: |           !!$        !
   678: |           !!$
   679: |           !!$        call RadDcpamELWV22CutMergeFlux(          &
   680: |           !!$          & xyr_Press,                            & ! (in)
   681: |           !!$          & xyr_RadFlux, xyra_DelRadFlux          & ! (inout)
   682: |           !!$          & )
   683: |           !!$
   684: |           !!$      end if
   685: |           
   686: |           
   687: |**W--->A         xyr_RadLUwFlux     = xyr_RadLUwFlux     + xyr_RadUwFlux
   688: |**W--- A         xyr_RadLDwFlux     = xyr_RadLDwFlux     + xyr_RadDwFlux
   689: |***W-->A         xyra_DelRadLUwFlux = xyra_DelRadLUwFlux + xyra_DelRadUwFlux
   690: |***W-- A         xyra_DelRadLDwFlux = xyra_DelRadLDwFlux + xyra_DelRadDwFlux
   691: |           
   692: +------         end do LOOP_band_RTE
   693:             
   694:             
   695:             
   696:             
   697:             
   698:             !!$    i = 0
   699:             !!$    j = jmax / 2 + 1
   700:             !!$    write( 73, * ) xy_SurfTemp(i,j), 0.0d0, 0.0d0, xyr_Press(i,j,0)
   701:             !!$    do k = 1, kmax
   702:             !!$      write( 73, * ) xyz_Temp(i,j,k), xyz_QH2OVap(i,j,k), xyz_QO3(i,j,k), &
   703:             !!$        & xyz_Press(i,j,k)
   704:             !!$    end do
   705:             !!$    call flush( 73 )
   706:             !!$
   707:             !!$    i = 0
   708:             !!$    j = jmax / 2 + 1
   709:             !!$    do k = 1, kmax
   710:             !!$      write( 83, * ) &
   711:             !!$        & + (     xyr_RadLFlux(i,j,k-1) - xyr_RadLFlux(i,j,k) )  &
   712:             !!$        &     / ( xyr_Press(i,j,k-1)    - xyr_Press(i,j,k) )     &
   713:             !!$        &     / 1004.6 * 9.8, &
   714:             !!$        & xyz_Press(i,j,k)
   715:             !!$    end do
   716:             !!$    call flush( 83 )
   717:             !!$
   718:             !!$    i = 0
   719:             !!$    j = jmax / 2 + 1
   720:             !!$    do k = 0, kmax
   721:             !!$      write( 93, * ) xyr_RadLFlux(i,j,k), xyr_Press(i,j,k)
   722:             !!$    end do
   723:             !!$    call flush( 93 )
   724:             !!$    stop
   725:             
   726:             
   727:                 ! 計算時間計測一時停止
   728:                 ! Pause measurement of computation time
   729:                 !
   730:                 call TimesetClockStop( module_name )
   731:             
   732:               end subroutine RadEarthLWV24Flux
   733:             
   734:               !--------------------------------------------------------------------------------------
   735:             !!$
   736:             !!$  subroutine RadiationDcpamELWV23CutMergeFlux( &
   737:             !!$    & xyr_Press,                              & ! (in)
   738:             !!$    & xyr_RadLFlux, xyra_DelRadLFlux,         & ! (inout)
   739:             !!$    & xyr_RadLFluxMA, xyra_DelRadLFluxMA      & ! (in) optional
   740:             !!$    & )
   741:             !!$    !
   742:             !!$    ! Radiative flux above a pressure level is modified to be constant or is merged with
   743:             !!$    ! that in middle atmosphere
   744:             !!$    !
   745:             !!$
   746:             !!$    ! USE statements
   747:             !!$    !
   748:             !!$
   749:             !!$    !
   750:             !!$    ! Grid points settings
   751:             !!$    !
   752:             !!$    use gridset, only: imax, & ! 
   753:             !!$                               ! Number of grid points in longitude
   754:             !!$      &                jmax, & ! 
   755:             !!$                               ! Number of grid points in latitude
   756:             !!$      &                kmax    ! 
   757:             !!$                               ! Number of vertical level
   758:             !!$
   759:             !!$    real(DP), intent(in   )           :: xyr_Press         (0:imax-1, 1:jmax, 0:kmax)
   760:             !!$    real(DP), intent(inout)           :: xyr_RadLFlux      (0:imax-1, 1:jmax, 0:kmax)
   761:             !!$    real(DP), intent(inout)           :: xyra_DelRadLFlux  (0:imax-1, 1:jmax, 0:kmax, 0:1)
   762:             !!$    real(DP), intent(in   ), optional :: xyr_RadLFluxMA    (0:imax-1, 1:jmax, 0:kmax)
   763:             !!$    real(DP), intent(in   ), optional :: xyra_DelRadLFluxMA(0:imax-1, 1:jmax, 0:kmax, 0:1)
   764:             !!$
   765:             !!$    !
   766:             !!$    ! Work variables
   767:             !!$    !
   768:             !!$    real(DP), parameter :: BoundaryPress = 30.0d2
   769:             !!$    integer             :: xy_kcut            (0:imax-1, 1:jmax)
   770:             !!$    real(DP)            :: xy_BoundaryFlux    (0:imax-1, 1:jmax)
   771:             !!$    real(DP)            :: xya_BoundaryDelFlux(0:imax-1, 1:jmax, 0:1)
   772:             !!$    integer             :: i
   773:             !!$    integer             :: j
   774:             !!$    integer             :: k
   775:             !!$
   776:             !!$
   777:             !!$    do k = 0, kmax
   778:             !!$      do j = 1, jmax
   779:             !!$        do i = 0, imax-1
   780:             !!$          if ( xyr_Press(i,j,k) >= BoundaryPress ) then
   781:             !!$            xy_kcut(i,j) = k
   782:             !!$          end if
   783:             !!$        end do
   784:             !!$      end do
   785:             !!$    end do
   786:             !!$    do j = 1, jmax
   787:             !!$      do i = 0, imax-1
   788:             !!$        if ( xy_kcut(i,j) == kmax ) then
   789:             !!$          xy_kcut(i,j) = kmax - 1
   790:             !!$        end if
   791:             !!$      end do
   792:             !!$    end do
   793:             !!$
   794:             !!$    do j = 1, jmax
   795:             !!$      do i = 0, imax-1
   796:             !!$        k = xy_kcut(i,j)
   797:             !!$        xy_BoundaryFlux(i,j) =                                              &
   798:             !!$          &   ( xyr_RadLFlux(i,j,k+1) - xyr_RadLFlux(i,j,k) )               &
   799:             !!$          & / log( ( xyr_Press(i,j,k+1) + 1.0d-100 ) / ( xyr_Press(i,j,k) + 1.0d-100 ) )&
   800:             !!$          & * log( BoundaryPress                     / ( xyr_Press(i,j,k) + 1.0d-100 ) )&
   801:             !!$          & + xyr_RadLFlux(i,j,k)
   802:             !!$        xya_BoundaryDelFlux(i,j,0) =                                        &
   803:             !!$          &   ( xyra_DelRadLFlux(i,j,k+1,0) - xyra_DelRadLFlux(i,j,k,0) )   &
   804:             !!$          & / log( ( xyr_Press(i,j,k+1) + 1.0d-100 ) / ( xyr_Press(i,j,k) + 1.0d-100 ) )&
   805:             !!$          & * log( BoundaryPress                     / ( xyr_Press(i,j,k) + 1.0d-100 ) )&
   806:             !!$          & + xyra_DelRadLFlux(i,j,k,0)
   807:             !!$        xya_BoundaryDelFlux(i,j,1) =                                        &
   808:             !!$          &   ( xyra_DelRadLFlux(i,j,k+1,1) - xyra_DelRadLFlux(i,j,k,1) )   &
   809:             !!$          & / log( ( xyr_Press(i,j,k+1) + 1.0d-100 ) / ( xyr_Press(i,j,k) + 1.0d-100 ) )&
   810:             !!$          & * log( BoundaryPress                     / ( xyr_Press(i,j,k) + 1.0d-100 ) )&
   811:             !!$          & + xyra_DelRadLFlux(i,j,k,1)
   812:             !!$      end do
   813:             !!$    end do
   814:             !!$
   815:             !!$    do k = 0, kmax
   816:             !!$      do j = 1, jmax
   817:             !!$        do i = 0, imax-1
   818:             !!$          if ( xyr_Press(i,j,k) < BoundaryPress ) then
   819:             !!$            xyr_RadLFlux(i,j,k) = xy_BoundaryFlux(i,j)
   820:             !!$          end if
   821:             !!$        end do
   822:             !!$      end do
   823:             !!$    end do
   824:             !!$    do k = 0, kmax
   825:             !!$      do j = 1, jmax
   826:             !!$        do i = 0, imax-1
   827:             !!$          if ( xyr_Press(i,j,k) < BoundaryPress ) then
   828:             !!$            xyra_DelRadLFlux(i,j,k,0) = xya_BoundaryDelFlux(i,j,0)
   829:             !!$            xyra_DelRadLFlux(i,j,k,1) = xya_BoundaryDelFlux(i,j,1)
   830:             !!$          end if
   831:             !!$        end do
   832:             !!$      end do
   833:             !!$    end do
   834:             !!$
   835:             !!$
   836:             !!$    if ( present( xyr_RadLFluxMA ) ) then
   837:             !!$
   838:             !!$      do j = 1, jmax
   839:             !!$        do i = 0, imax-1
   840:             !!$          k = xy_kcut(i,j)
   841:             !!$          xy_BoundaryFlux(i,j) =                                              &
   842:             !!$            &   ( xyr_RadLFluxMA(i,j,k+1) - xyr_RadLFluxMA(i,j,k) )           &
   843:             !!$            & / log( ( xyr_Press(i,j,k+1) + 1.0d-100 ) / ( xyr_Press(i,j,k) + 1.0d-100 ) )   &
   844:             !!$            & * log( BoundaryPress                     / ( xyr_Press(i,j,k) + 1.0d-100 ) )   &
   845:             !!$            & + xyr_RadLFluxMA(i,j,k)
   846:             !!$        end do
   847:             !!$      end do
   848:             !!$
   849:             !!$      do k = 0, kmax
   850:             !!$        do j = 1, jmax
   851:             !!$          do i = 0, imax-1
   852:             !!$            if ( xyr_Press(i,j,k) < BoundaryPress ) then
   853:             !!$              xyr_RadLFlux(i,j,k) = xyr_RadLFlux(i,j,k) &
   854:             !!$                & + xyr_RadLFluxMA(i,j,k) - xy_BoundaryFlux(i,j)
   855:             !!$            end if
   856:             !!$          end do
   857:             !!$        end do
   858:             !!$      end do
   859:             !!$
   860:             !!$    end if
   861:             !!$
   862:             !!$    if ( present( xyra_DelRadLFluxMA ) ) then
   863:             !!$
   864:             !!$      do j = 1, jmax
   865:             !!$        do i = 0, imax-1
   866:             !!$          k = xy_kcut(i,j)
   867:             !!$          xya_BoundaryDelFlux(i,j,0) =                                            &
   868:             !!$            &   ( xyra_DelRadLFluxMA(i,j,k+1,0) - xyra_DelRadLFluxMA(i,j,k,0) )   &
   869:             !!$            & / log( ( xyr_Press(i,j,k+1) + 1.0d-100 ) / ( xyr_Press(i,j,k) + 1.0d-100 ) )       &
   870:             !!$            & * log( BoundaryPress                     / ( xyr_Press(i,j,k) + 1.0d-100 ) )       &
   871:             !!$            & + xyra_DelRadLFluxMA(i,j,k,0)
   872:             !!$          xya_BoundaryDelFlux(i,j,1) =                                            &
   873:             !!$            &   ( xyra_DelRadLFluxMA(i,j,k+1,1) - xyra_DelRadLFluxMA(i,j,k,1) )   &
   874:             !!$            & / log( ( xyr_Press(i,j,k+1) + 1.0d-100 ) / ( xyr_Press(i,j,k) + 1.0d-100 ) )       &
   875:             !!$            & * log( BoundaryPress                     / ( xyr_Press(i,j,k) + 1.0d-100 ) )       &
   876:             !!$            & + xyra_DelRadLFluxMA(i,j,k,1)
   877:             !!$        end do
   878:             !!$      end do
   879:             !!$
   880:             !!$      do k = 0, kmax
   881:             !!$        do j = 1, jmax
   882:             !!$          do i = 0, imax-1
   883:             !!$            if ( xyr_Press(i,j,k) < BoundaryPress ) then
   884:             !!$              xyra_DelRadLFlux(i,j,k,0) = xyra_DelRadLFlux(i,j,k,0) &
   885:             !!$                & + xyra_DelRadLFluxMA(i,j,k,0) - xya_BoundaryDelFlux(i,j,0)
   886:             !!$              xyra_DelRadLFlux(i,j,k,1) = xyra_DelRadLFlux(i,j,k,1) &
   887:             !!$                & + xyra_DelRadLFluxMA(i,j,k,1) - xya_BoundaryDelFlux(i,j,1)
   888:             !!$            end if
   889:             !!$          end do
   890:             !!$        end do
   891:             !!$      end do
   892:             !!$
   893:             !!$    end if
   894:             !!$
   895:             !!$
   896:             !!$  end subroutine RadiationDcpamELWV23CutMergeFlux
   897:             
   898:               !--------------------------------------------------------------------------------------
   899:             
   900:               subroutine RadEarthLWV24Init( &
   901:                 & FlagSnow                  &
   902:                 & )
   903:             
   904:                 ! USE statements
   905:                 !
   906:             
   907:                 ! メッセージ出力
   908:                 ! Message output
   909:                 !
   910:                 use dc_message, only: MessageNotify
   911:             
   912:                 ! ファイル入出力補助
   913:                 ! File I/O support
   914:                 !
   915:                 use dc_iounit, only: FileOpen
   916:             
   917:                 ! 暦と日時の取り扱い
   918:                 ! Calendar and Date handler
   919:                 !
   920:                 use dc_calendar, only: DCCalConvertByUnit
   921:             
   922:                 ! NAMELIST ファイル入力に関するユーティリティ
   923:                 ! Utilities for NAMELIST file input
   924:                 !
   925:                 use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid
   926:             
   927:                 ! Chou and Kouvaris (1991) による長波放射モデル
   928:                 ! Long radiation model described by Chou and Kouvaris (1991)
   929:                 !
   930:                 use rad_CK1991, only : RadCK1991Init
   931:             
   932:                 ! Chou et al. (2001) による長波放射モデル
   933:                 ! Long radiation model described by Chou et al. (2001)
   934:                 !
   935:                 use rad_C2001, only : RadC2001Init
   936:             
   937:                 ! 散乱を無視した放射伝達方程式
   938:                 ! Radiative transfer equation without considering scattering
   939:                 !
   940:                 use rad_rte_nonscat, only : RadRTENonScatInit
   941:             
   942:                 ! 雲関系ルーチン
   943:                 ! Cloud-related routines
   944:                 !
   945:                 use cloud_utils, only : CloudUtilsInit
   946:             
   947:             
   948:                 logical, intent(in) :: FlagSnow
   949:             
   950:             
   951:                 real(DP)          :: DelTimeCalcTransValue
   952:                 character(STRING) :: DelTimeCalcTransUnit
   953:             
   954:                 integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号.
   955:                                           ! Unit number for NAMELIST file open
   956:                 integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT.
   957:                                           ! IOSTAT of NAMELIST read
   958:             
   959:                 integer :: n
   960:             
   961:             
   962:                 namelist /rad_Earth_LW_V2_4_nml/ &
   963:                   & FlagHighAlt,              &
   964:                   & DelTimeCalcTransValue,    &
   965:                   & DelTimeCalcTransUnit,     &
   966:                   & flag_save_time
   967:             
   968:             
   969:                 if ( rad_Earth_LW_V2_4_inited ) return
   970:             
   971:             
   972:                 FlagHighAlt           = .false.
   973:             
   974:                 DelTimeCalcTransValue = 3.0
   975:                 DelTimeCalcTransUnit  = 'hrs'
   976:                 flag_save_time        = .false.
   977:             
   978:             
   979:                 ! NAMELIST is input
   980:                 !
   981:                 if ( trim(namelist_filename) /= '' ) then
   982:                   call FileOpen( unit_nml, &          ! (out)
   983:                     & namelist_filename, mode = 'r' ) ! (in)
   984:             
   985:                   rewind( unit_nml )
   986:                   read( unit_nml,                          & ! (in)
   987:                     & nml = rad_Earth_LW_V2_4_nml,         & ! (out)
   988:                     & iostat = iostat_nml )                  ! (out)
   989:                   close( unit_nml )
   990:             
   991:                   call NmlutilMsg( iostat_nml, module_name ) ! (in)
   992:                 end if
   993:             
   994:                 ! Handle interval time
   995:                 !
   996:                 IntTimeSave = DCCalConvertByUnit( DelTimeCalcTransValue, DelTimeCalcTransUnit, 'sec' ) ! (in)
   997:             
   998:             
   999:             
  1000:             
  1001: V------>        do n = 1, nbmax
  1002: |                 ! unit conversion from (cm-1) to (m-1)
  1003: |       A         aa_BandParam(1,n) = aa_BandParam(1,n) * 1.0d2
  1004: |       A         aa_BandParam(2,n) = aa_BandParam(2,n) * 1.0d2
  1005: V------         end do
  1006:             
  1007:             
  1008:                 ! allocate a variable for saving transmittance
  1009:                 !
  1010:                 allocate( xyrra_TransSaved (0:imax-1,1:jmax,0:kmax,0:kmax,1:nbmax) )
  1011:                 allocate( xyrr_TransMASaved(0:imax-1,1:jmax,0:kmax,0:kmax)         )
  1012:             
  1013:             
  1014:                 call RadEarthLWV24PrepPFTable
  1015:             
  1016:             
  1017:                 ! Initialization of modules used in this module
  1018:                 !
  1019:             
  1020:                 ! Chou and Kouvaris (1991) による長波放射モデル
  1021:                 ! Long radiation model described by Chou and Kouvaris (1991)
  1022:                 !
  1023:                 call RadCK1991Init
  1024:             
  1025:                 ! Chou et al. (2001) による長波放射モデル
  1026:                 ! Long radiation model described by Chou et al. (2001)
  1027:                 !
  1028:                 call RadC2001Init
  1029:             
  1030:                 ! 散乱を無視した放射伝達方程式
  1031:                 ! Radiative transfer equation without considering scattering
  1032:                 !
  1033:                 call RadRTENonScatInit
  1034:             
  1035:                 ! 雲関系ルーチン
  1036:                 ! Cloud-related routines
  1037:                 !
  1038:                 call CloudUtilsInit( &
  1039:                   & FlagSnow         &
  1040:                   & )
  1041:             
  1042:             
  1043:                 ! 印字 ; Print
  1044:                 !
  1045:                 call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
  1046:                 call MessageNotify( 'M', module_name, '  FlagHighAlt       = %b', &
  1047:                   & l = (/ FlagHighAlt /) )
  1048:                 call MessageNotify( 'M', module_name, '  DelTimeCalcTrans  = %f [%c]', &
  1049:                   & d = (/ DelTimeCalcTransValue /), c1 = trim( DelTimeCalcTransUnit ) )
  1050:                 call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
  1051:             
  1052:             
  1053:                 rad_Earth_LW_V2_4_inited = .true.
  1054:             
  1055:               end subroutine RadEarthLWV24Init
  1056:             
  1057:               !--------------------------------------------------------------------------------------
  1058:             
  1059:               subroutine RadEarthLWV24PrepPFTable
  1060:             
  1061:                 ! メッセージ出力
  1062:                 ! Message output
  1063:                 !
  1064:                 use dc_message, only: MessageNotify
  1065:             
  1066:                 ! ガウス重み, 分点の計算
  1067:                 ! Calculate Gauss node and Gaussian weight
  1068:                 !
  1069:                 use gauss_quad, only : GauLeg
  1070:             
  1071:                 ! プランク関数の計算
  1072:                 ! Calculate Planck function
  1073:                 !
  1074:                 use planck_func, only : PF, DPFDT, Integ_PF_GQ_Array2D, Integ_DPFDT_GQ_Array2D
  1075:             
  1076:                 integer , parameter :: NGaussQuad = 5
  1077:                 logical             :: FlagCheckLoopExit
  1078:                 real(DP)            :: xy_TempTMP   (0:imax-1, 1:jmax)
  1079:                 real(DP)            :: xy_PF        (0:imax-1, 1:jmax)
  1080:                 real(DP)            :: xy_DPFDT     (0:imax-1, 1:jmax)
  1081:                 real(DP)            :: xy_PFTable   (0:imax-1, 1:jmax)
  1082:                 real(DP)            :: xy_DPFDTTable(0:imax-1, 1:jmax)
  1083:                 real(DP)            :: ErrorPFInteg
  1084:                 real(DP), parameter :: ThresholdErrorPFInteg = 1.0d-3
  1085:                                           ! Threshold for checking accuracy of calculation of
  1086:                                           ! integrated Planc function by using a pre-calculated
  1087:                                           ! table.
  1088:             
  1089:                 ! Variables for preparation for calculation of Plank function
  1090:                 !
  1091:                 real(DP)      , allocatable :: GQP(:)
  1092:                 real(DP)      , allocatable :: GQW(:)
  1093:             
  1094:             
  1095:                 integer:: i
  1096:                 integer:: j
  1097:                 integer:: l
  1098:                 integer:: m
  1099:                 integer:: n
  1100:             
  1101:             
  1102:                 ! Preparation of tables for calculation of Plank function
  1103:                 !
  1104:                 TableTempMin       =  50.0d0
  1105:                 TableTempMax       = 600.0d0
  1106:                 TableTempIncrement =   0.1d0
  1107:                 ntmax              = ( TableTempMax - TableTempMin ) / TableTempIncrement + 1
  1108:                 allocate( a_TableTemp   (1:ntmax) )
  1109:                 allocate( aa_TableIPF   (1:ntmax, 1:nbmax) )
  1110:                 allocate( aa_TableIDPFDT(1:ntmax, 1:nbmax) )
  1111:             
  1112: V------>        do m = 1, ntmax
  1113: |       A         a_TableTemp(m) = TableTempMin + TableTempIncrement * ( m - 1 )
  1114: V------         end do
  1115:             
  1116:             
  1117: W*===== A       aa_TableIPF   (:,:) = 0.0d0
  1118: W*===== A       aa_TableIDPFDT(:,:) = 0.0d0
  1119:             
  1120:                 allocate( GQP(1:NGaussQuad) )
  1121:                 allocate( GQW(1:NGaussQuad) )
  1122: +------>        do n = 1, nbmax
  1123: |                 call GauLeg( &
  1124: |                   & aa_BandParam(1,n), aa_BandParam(2,n), NGaussQuad, & ! (in )
  1125: |                   & GQP, GQW                                          & ! (out)
  1126: |                   & )
  1127: |+----->          do m = 1, ntmax
  1128: ||+---->            do l = 1, NGaussQuad
  1129: |||                   aa_TableIPF   (m,n) = &
  1130: |||                     & aa_TableIPF   (m,n) + PF   ( GQP(l), a_TableTemp(m) ) * GQW(l)
  1131: |||                   aa_TableIDPFDT(m,n) = &
  1132: |||                     & aa_TableIDPFDT(m,n) + DPFDT( GQP(l), a_TableTemp(m) ) * GQW(l)
  1133: ||+----             end do
  1134: |+-----           end do
  1135: +------         end do
  1136:                 deallocate( GQP )
  1137:                 deallocate( GQW )
  1138:             
  1139:             
  1140:                 !----------------------------------------------------
  1141:                 ! Check accuracy of integration of Planc function by using a pre-calculated table.
  1142:                 !
  1143:             
  1144:                 !      This routine is called once here, to initialize a pre-calculated table.
  1145:                 n = 1
  1146: W*===== A       xy_TempTMP = 300.0d0
  1147:                 call CalcIntegratedPFWithTable2D( &
  1148:                   & n, xy_TempTMP,                &
  1149:                   & xy_PFTable,                   &
  1150:                   & 1, jmax,                      &
  1151:                   & .false.                       &
  1152:                   & )
  1153:             
  1154: +------>        do n = 1, nbmax
  1155: |           
  1156: |                 FlagCheckLoopExit = .false.
  1157: |                 l = 1
  1158: |+----->          do
  1159: ||          
  1160: ||+---->            do j = 1, jmax
  1161: |||V--->              do i = 0, imax-1
  1162: ||||    A               xy_TempTMP(i,j) = &
  1163: ||||                      &   a_TableTemp(1)                                                     &
  1164: ||||                      & + ( a_TableTemp(2) - a_TableTemp(1) ) * 0.5d0                        &
  1165: ||||                      & + ( a_TableTemp(2) - a_TableTemp(1) ) &
  1166: ||||                      &     * ( imax * jmax * ( l - 1 ) + imax * ( j - 1 ) + i )
  1167: |||V---               end do
  1168: ||+----             end do
  1169: ||          
  1170: ||W---->            do j = 1, jmax
  1171: |||*--->              do i = 0, imax-1
  1172: ||||    A               if ( xy_TempTMP(i,j) > a_TableTemp(ntmax) ) then
  1173: ||||    A                 xy_TempTMP(i,j) = a_TableTemp(ntmax)
  1174: ||||                      FlagCheckLoopExit = .true.
  1175: ||||                    end if
  1176: |||*---               end do
  1177: ||W----             end do
  1178: ||          
  1179: ||          
  1180: ||                  call Integ_PF_GQ_Array2D(                             &
  1181: ||                    & aa_BandParam(1,n), aa_BandParam(2,n), NGaussQuad, &
  1182: ||                    & 0, imax-1, 1, jmax, xy_TempTMP,                   &
  1183: ||                    & xy_PF                                             &
  1184: ||                    & )
  1185: ||                  call Integ_DPFDT_GQ_Array2D(                          &
  1186: ||                    & aa_BandParam(1,n), aa_BandParam(2,n), NGaussQuad, & ! (in )
  1187: ||                    & 0, imax-1, 1, jmax, xy_TempTMP,                   & ! (in )
  1188: ||                    & xy_DPFDT                                          & ! (out)
  1189: ||                    & )
  1190: ||          
  1191: ||                  call CalcIntegratedPFWithTable2D( &
  1192: ||                    & n, xy_TempTMP,                &
  1193: ||                    & xy_PFTable,                   &
  1194: ||                    & 1, jmax,                      &
  1195: ||                    & .false.                       &
  1196: ||                    & )
  1197: ||                  call CalcIntegratedPFWithTable2D( &
  1198: ||                    & n, xy_TempTMP,                &
  1199: ||                    & xy_DPFDTTable,                &
  1200: ||                    & 1, jmax,                      &
  1201: ||                    & .true.                        &
  1202: ||                    & )
  1203: ||          
  1204: ||+---->            do j = 1, jmax
  1205: |||+--->              do i = 0, imax-1
  1206: ||||                    ErrorPFInteg = &
  1207: ||||                      & abs( xy_PF   (i,j) - xy_PFTable   (i,j) ) / xy_PF   (i,j)
  1208: ||||                    if ( ErrorPFInteg > ThresholdErrorPFInteg ) then
  1209: ||||                      call MessageNotify( 'E', module_name, 'Error of integrated PF, %f, is greater than threshold, %f, in band %d.', &
  1210: ||||                        & d = (/ ErrorPFInteg, ThresholdErrorPFInteg /), i = (/n/) )
  1211: ||||                    end if
  1212: ||||                    ErrorPFInteg = &
  1213: ||||                      & abs( xy_DPFDT(i,j) - xy_DPFDTTable(i,j) ) / xy_DPFDT(i,j)
  1214: ||||                    if ( ErrorPFInteg > ThresholdErrorPFInteg ) then
  1215: ||||                      call MessageNotify( 'E', module_name, 'Error of integrated DPFDT, %f, is greater than threshold, %f, in band %d', &
  1216: ||||                        & d = (/ ErrorPFInteg, ThresholdErrorPFInteg /), i = (/n/) )
  1217: ||||                    end if
  1218: |||+---               end do
  1219: ||+----             end do
  1220: ||          
  1221: ||                  if ( FlagCheckLoopExit ) exit
  1222: ||                  l = l + 1
  1223: |+-----           end do
  1224: |           
  1225: +------         end do
  1226:             
  1227:               end subroutine RadEarthLWV24PrepPFTable
  1228:             
  1229:               !--------------------------------------------------------------------------------------
  1230:             
  1231:               subroutine CalcIntegratedPFWithTable2D( &
  1232:                 & iband, xy_Temp,                     &
  1233:                 & xy_IntegPF,                         &
  1234:                 & js, je,                             &
  1235:                 & flag_DPFDT                          &
  1236:                 & )
  1237:             
  1238:                 ! USE statements
  1239:                 !
  1240:             
  1241:                 integer , intent(in )           :: iband
  1242:                 real(DP), intent(in )           :: xy_temp   (0:imax-1, 1:jmax)
  1243:                 real(DP), intent(out)           :: xy_IntegPF(0:imax-1, 1:jmax)
  1244:                 integer , intent(in )           :: js
  1245:                 integer , intent(in )           :: je
  1246:                 logical , intent(in ), optional :: flag_DPFDT
  1247:             
  1248:                 !
  1249:                 ! local variables
  1250:                 !
  1251:                 real(DP) :: xyz_Temp   (0:imax-1, 1:jmax, 1)
  1252:                 real(DP) :: xyz_IntegPF(0:imax-1, 1:jmax, 1)
  1253:                 integer  :: j
  1254:             
  1255:             
  1256: W------>        do j = js, je
  1257: |*===== A         xyz_Temp(:,j,1) = xy_Temp(:,j)
  1258: W------         end do
  1259:             
  1260:                 call CalcIntegratedPFWithTable3D( &
  1261:                   & iband, 1, xyz_temp,                 &
  1262:                   & xyz_IntegPF,                        &
  1263:                   & js, je,                             &
  1264:                   & flag_DPFDT                          &
  1265:                   & )
  1266:             
  1267: W------>        do j = js, je
  1268: |*===== A         xy_IntegPF(:,j) = xyz_IntegPF(:,j,1)
  1269: W------         end do
  1270:             
  1271:             
  1272:               end subroutine CalcIntegratedPFWithTable2D
  1273:             
  1274:               !--------------------------------------------------------------------------------------
  1275:             
  1276:               subroutine CalcIntegratedPFWithTable3D( &
  1277:                 & iband, km, xyz_temp,                &
  1278:                 & xyz_IntegPF,                        &
  1279:                 & js, je,                             &
  1280:                 & flag_DPFDT                          &
  1281:                 & )
  1282:             
  1283:                 ! USE statements
  1284:                 !
  1285:             
  1286:                 ! メッセージ出力
  1287:                 ! Message output
  1288:                 !
  1289:                 use dc_message, only: MessageNotify
  1290:             
  1291:                 integer , intent(in ) :: iband
  1292:                 integer , intent(in ) :: km
  1293:                 real(DP), intent(in ) :: xyz_temp   (0:imax-1, 1:jmax, 1:km)
  1294:                 real(DP), intent(out) :: xyz_IntegPF(0:imax-1, 1:jmax, 1:km)
  1295:                 logical , intent(in ), optional :: flag_DPFDT
  1296:                 integer , intent(in )           :: js
  1297:                 integer , intent(in )           :: je
  1298:             
  1299:                 !
  1300:                 ! local variables
  1301:                 !
  1302:                 logical                     :: local_flag_DPFDT
  1303:             
  1304:                 integer                     :: xyz_TempIndex(0:imax-1, 1:jmax, 1:km)
  1305:                 integer                     :: i
  1306:                 integer                     :: j
  1307:                 integer                     :: k
  1308:                 integer                     :: m
  1309:             
  1310:             
  1311: +------>        do k = 1, km
  1312: |+----->          do j = js, je
  1313: ||+---->            do i = 0, imax-1
  1314: |||         
  1315: |||                   if ( ( xyz_Temp(i,j,k) < a_TableTemp(1)     ) .or. &
  1316: |||                     &  ( xyz_Temp(i,j,k) > a_TableTemp(ntmax) ) ) then
  1317: |||                     call MessageNotify( 'E', module_name, &
  1318: |||                       & 'Temperature is not appropriate, Temp(%d,%d,%d) = %f.', &
  1319: |||                       & i = (/i, j, k/), d = (/xyz_Temp(i,j,k)/) )
  1320: |||                   end if
  1321: |||         
  1322: |||                   xyz_TempIndex(i,j,k) = &
  1323: |||                     & int( ( xyz_Temp(i,j,k) - TableTempMin ) / TableTempIncrement ) + 2
  1324: |||         
  1325: |||                   if ( xyz_TempIndex(i,j,k) == 1 ) then
  1326: |||                      xyz_TempIndex(i,j,k) = 2
  1327: |||                   else if ( xyz_TempIndex(i,j,k) >= ntmax ) then
  1328: |||                      xyz_TempIndex(i,j,k) = ntmax - 1
  1329: |||                   end if
  1330: |||         
  1331: |||         !!$          xyz_TempIndex(i,j,k) = ntmax-1
  1332: |||         !!$          search_index: do m = 2, ntmax-1
  1333: |||         !!$            if ( a_TableTemp(m) >= xyz_Temp(i,j,k) ) then
  1334: |||         !!$              xyz_TempIndex(i,j,k) = m
  1335: |||         !!$              exit search_index
  1336: |||         !!$            end if
  1337: |||         !!$          end do search_index
  1338: |||         
  1339: ||+----             end do
  1340: |+-----           end do
  1341: +------         end do
  1342:             
  1343:             
  1344:                 local_flag_DPFDT = .false.
  1345:                 if ( present( flag_DPFDT ) ) then
  1346:                   if ( flag_DPFDT ) then
  1347:                     local_flag_DPFDT = .true.
  1348:                   end if
  1349:                 end if
  1350:             
  1351:                 if ( .not. local_flag_DPFDT ) then
  1352: +------>          do k = 1, km
  1353: |W----->            do j = js, je
  1354: ||*---->              do i = 0, imax-1
  1355: |||                     m = xyz_TempIndex(i,j,k)
  1356: |||         
  1357: |||         !!$            xyz_IntegPF(i,j,k) = &
  1358: |||         !!$              &   ( aa_TableIPF( m, iband ) - aa_TableIPF( m-1, iband ) ) &
  1359: |||         !!$              & / ( a_TableTemp( m )        - a_TableTemp( m-1 )        ) &
  1360: |||         !!$              & * ( xyz_Temp(i,j,k)         - a_TableTemp( m-1 )        ) &
  1361: |||         !!$              & +   aa_TableIPF( m-1, iband )
  1362: |||         
  1363: |||     A               xyz_IntegPF(i,j,k) = &
  1364: |||                       &   aa_TableIPF(m-1,iband)                           &
  1365: |||                       &   * ( xyz_Temp   (i,j,k) - a_TableTemp( m   ) )    &
  1366: |||                       &   * ( xyz_Temp   (i,j,k) - a_TableTemp( m+1 ) )    &
  1367: |||                       & / ( ( a_TableTemp( m-1 ) - a_TableTemp( m   ) )    &
  1368: |||                       &   * ( a_TableTemp( m-1 ) - a_TableTemp( m+1 ) ) )  &
  1369: |||                       & + aa_TableIPF(m  ,iband)                           &
  1370: |||                       &   * ( xyz_Temp   (i,j,k) - a_TableTemp( m-1 ) )    &
  1371: |||                       &   * ( xyz_Temp   (i,j,k) - a_TableTemp( m+1 ) )    &
  1372: |||                       & / ( ( a_TableTemp( m   ) - a_TableTemp( m-1 ) )    &
  1373: |||                       &   * ( a_TableTemp( m   ) - a_TableTemp( m+1 ) ) )  &
  1374: |||                       & + aa_TableIPF(m+1,iband)                           &
  1375: |||                       &   * ( xyz_Temp   (i,j,k) - a_TableTemp( m-1 ) )    &
  1376: |||                       &   * ( xyz_Temp   (i,j,k) - a_TableTemp( m   ) )    &
  1377: |||                       & / ( ( a_TableTemp( m+1 ) - a_TableTemp( m-1 ) )    &
  1378: |||                       &   * ( a_TableTemp( m+1 ) - a_TableTemp( m   ) ) )
  1379: ||*----               end do
  1380: |W-----             end do
  1381: +------           end do
  1382:                 else
  1383: +------>          do k = 1, km
  1384: |W----->            do j = js, je
  1385: ||*---->              do i = 0, imax-1
  1386: |||                     m = xyz_TempIndex(i,j,k)
  1387: |||         
  1388: |||         !!$            xyz_IntegPF(i,j,k) = &
  1389: |||         !!$              &   ( aa_TableIDPFDT( m, iband ) - aa_TableIDPFDT( m-1, iband ) ) &
  1390: |||         !!$              & / ( a_TableTemp   ( m )        - a_TableTemp   ( m-1 )        ) &
  1391: |||         !!$              & * ( xyz_Temp(i,j,k)         - a_TableTemp( m-1 )        ) &
  1392: |||         !!$              & +   aa_TableIDPFDT( m-1, iband )
  1393: |||         
  1394: |||     A               xyz_IntegPF(i,j,k) = &
  1395: |||                       &   aa_TableIDPFDT(m-1,iband)                        &
  1396: |||                       &   * ( xyz_Temp   (i,j,k) - a_TableTemp( m   ) )    &
  1397: |||                       &   * ( xyz_Temp   (i,j,k) - a_TableTemp( m+1 ) )    &
  1398: |||                       & / ( ( a_TableTemp( m-1 ) - a_TableTemp( m   ) )    &
  1399: |||                       &   * ( a_TableTemp( m-1 ) - a_TableTemp( m+1 ) ) )  &
  1400: |||                       & + aa_TableIDPFDT(m  ,iband)                        &
  1401: |||                       &   * ( xyz_Temp   (i,j,k) - a_TableTemp( m-1 ) )    &
  1402: |||                       &   * ( xyz_Temp   (i,j,k) - a_TableTemp( m+1 ) )    &
  1403: |||                       & / ( ( a_TableTemp( m   ) - a_TableTemp( m-1 ) )    &
  1404: |||                       &   * ( a_TableTemp( m   ) - a_TableTemp( m+1 ) ) )  &
  1405: |||                       & + aa_TableIDPFDT(m+1,iband)                        &
  1406: |||                       &   * ( xyz_Temp   (i,j,k) - a_TableTemp( m-1 ) )    &
  1407: |||                       &   * ( xyz_Temp   (i,j,k) - a_TableTemp( m   ) )    &
  1408: |||                       & / ( ( a_TableTemp( m+1 ) - a_TableTemp( m-1 ) )    &
  1409: |||                       &   * ( a_TableTemp( m+1 ) - a_TableTemp( m   ) ) )
  1410: ||*----               end do
  1411: |W-----             end do
  1412: +------           end do
  1413:                 end if
  1414:             
  1415:             
  1416:               end subroutine CalcIntegratedPFWithTable3D
  1417:             
  1418:               !--------------------------------------------------------------------------------------
  1419:             
  1420:             end module rad_Earth_LW_V2_4
