Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:53 2016
FILE NAME: rad_Earth_SW_V2_1.f90
PROGRAM NAME: rad_earth_sw_v2_1
DIAGNOSTIC LIST

  LINE  LEVEL( NO.): DIAGNOSTIC MESSAGE

   293  opt  (  11): Fused array assignments. :line 293 - 294
   293  opt  (1593): Loop nest collapsed into one loop.
   293  vec  (   4): Vectorized array expression.
   293  vec  (  29): ADB is used for array.: xyr_radsdwflux
   293  vec  (  29): ADB is used for array.: xyr_radsuwflux
   306  opt  (1593): Loop nest collapsed into one loop.
   306  vec  (   4): Vectorized array expression.
   306  vec  (  29): ADB is used for array.: xyz_cloudreff
   307  opt  (1017): Subroutine call prevents optimization.
   311  opt  (  11): Fused array assignments. :line 311 - 316
   311  opt  (1593): Loop nest collapsed into one loop.
   311  vec  (   4): Vectorized array expression.
   311  vec  (  29): ADB is used for array.: xyz_cloudreff
   311  vec  (  29): ADB is used for array.: xyz_cloudcoalb
   311  vec  (  29): ADB is used for array.: xyz_delh2oliqmass
   311  vec  (  29): ADB is used for array.: xyz_cloudextcoef
   321  opt  (  11): Fused array assignments. :line 321 - 322
   321  opt  (1593): Loop nest collapsed into one loop.
   321  vec  (   4): Vectorized array expression.
   321  vec  (  29): ADB is used for array.: xyz_cloudcoalb
   321  vec  (  29): ADB is used for array.: xyz_delh2osolmass
   321  vec  (  29): ADB is used for array.: xyz_cloudextcoef
   338  opt  (1592): Outer loop unrolled inside inner loop.
   338  vec  (   4): Vectorized array expression.
   338  vec  (  29): ADB is used for array.: xyz_delatmmass
   338  vec  (   4): Vectorized array expression.
   338  vec  (  29): ADB is used for array.: xyz_delatmmass
   340  opt  (1593): Loop nest collapsed into one loop.
   340  vec  (   4): Vectorized array expression.
   346  opt  (  11): Fused array assignments. :line 346 - 351
   346  opt  (1593): Loop nest collapsed into one loop.
   346  vec  (   4): Vectorized array expression.
   346  vec  (  29): ADB is used for array.: xyz_delo3mass
   357  opt  (1593): Loop nest collapsed into one loop.
   357  vec  (   4): Vectorized array expression.
   357  vec  (  29): ADB is used for array.: xyr_totoptdep
   358  vec  (   3): Unvectorized loop.
   358  vec  (  13): Overhead of loop division is too large.
   359  opt  (1037): Feedback of array elements.
   359  opt  (1593): Loop nest collapsed into one loop.
   359  vec  (   4): Vectorized array expression.
   359  vec  (  29): ADB is used for array.: xyr_totoptdep
   362  opt  (1593): Loop nest collapsed into one loop.
   362  vec  (   4): Vectorized array expression.
   362  vec  (  29): ADB is used for array.: xyz_ssa
   368  opt  (1593): Loop nest collapsed into one loop.
   368  vec  (   1): Vectorized loop.
   368  vec  (  29): ADB is used for array.: xyz_ssa
   377  opt  (1593): Loop nest collapsed into one loop.
   377  vec  (   4): Vectorized array expression.
   377  vec  (  29): ADB is used for array.: xyz_af
   377  vec  (  29): ADB is used for array.: xyz_ssa
   377  vec  (  29): ADB is used for array.: xyz_cloudiceaf
   377  vec  (  29): ADB is used for array.: xyz_cloudwataf
   393  opt  (  11): Fused array assignments. :line 393 - 394
   393  opt  (1593): Loop nest collapsed into one loop.
   393  vec  (   4): Vectorized array expression.
   393  vec  (  29): ADB is used for array.: xyr_radsdwflux
   393  vec  (  29): ADB is used for array.: xyr_raddwflux
   393  vec  (  29): ADB is used for array.: xyr_radsuwflux
   393  vec  (  29): ADB is used for array.: xyr_raduwflux
   421  opt  (1593): Loop nest collapsed into one loop.
   421  vec  (   4): Vectorized array expression.
   421  vec  (  29): ADB is used for array.: xyz_cloudreff
   426  opt  (  11): Fused array assignments. :line 426 - 431
   426  opt  (1593): Loop nest collapsed into one loop.
   426  vec  (   4): Vectorized array expression.
   426  vec  (  29): ADB is used for array.: xyz_cloudreff
   426  vec  (  29): ADB is used for array.: xyz_cloudcoalb
   426  vec  (  29): ADB is used for array.: xyz_delh2oliqmass
   426  vec  (  29): ADB is used for array.: xyz_cloudextcoef
   436  opt  (  11): Fused array assignments. :line 436 - 437
   436  opt  (1593): Loop nest collapsed into one loop.
   436  vec  (   4): Vectorized array expression.
   436  vec  (  29): ADB is used for array.: xyz_cloudcoalb
   436  vec  (  29): ADB is used for array.: xyz_delh2osolmass
   436  vec  (  29): ADB is used for array.: xyz_cloudextcoef
   442  opt  (1017): Subroutine call prevents optimization.
   447  opt  (  11): Fused array assignments. :line 447 - 452
   447  opt  (1593): Loop nest collapsed into one loop.
   447  vec  (   4): Vectorized array expression.
   447  vec  (  29): ADB is used for array.: xyz_delh2ovapmassscaled
   457  opt  (1593): Loop nest collapsed into one loop.
   457  vec  (   4): Vectorized array expression.
   457  vec  (  29): ADB is used for array.: xyr_totoptdep
   458  vec  (   3): Unvectorized loop.
   458  vec  (  13): Overhead of loop division is too large.
   459  opt  (1037): Feedback of array elements.
   459  opt  (1593): Loop nest collapsed into one loop.
   459  vec  (   4): Vectorized array expression.
   459  vec  (  29): ADB is used for array.: xyr_totoptdep
   462  opt  (1593): Loop nest collapsed into one loop.
   462  vec  (   4): Vectorized array expression.
   462  vec  (  29): ADB is used for array.: xyz_ssa
   467  opt  (1593): Loop nest collapsed into one loop.
   467  vec  (   1): Vectorized loop.
   467  vec  (  29): ADB is used for array.: xyz_ssa
   476  opt  (1593): Loop nest collapsed into one loop.
   476  vec  (   4): Vectorized array expression.
   476  vec  (  29): ADB is used for array.: xyz_af
   476  vec  (  29): ADB is used for array.: xyz_ssa
   476  vec  (  29): ADB is used for array.: xyz_cloudiceaf
   476  vec  (  29): ADB is used for array.: xyz_cloudwataf
   492  opt  (  11): Fused array assignments. :line 492 - 496
   492  opt  (1593): Loop nest collapsed into one loop.
   492  vec  (   4): Vectorized array expression.
   492  vec  (  29): ADB is used for array.: xyr_radsdwflux
   492  vec  (  29): ADB is used for array.: xyr_radsuwflux
   492  vec  (  29): ADB is used for array.: xyr_raddwflux
   492  vec  (  29): ADB is used for array.: xyr_raduwflux
   543  warn (  83): Dummy argument "xyz_cloudcover" is not used.
   543  warn (  82): Name "xyr_radflux" is not used.
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:53 2016
FILE NAME: rad_Earth_SW_V2_1.f90
PROGRAM NAME: rad_earth_sw_v2_1
TRANSFORMATION LIST

  LINE                   FORTRAN STATEMENT

     1  != 地球大気向け短波放射モデル Ver. 2.1
     2  !
     3  != short wave radiation model for the Earth's atmosphere Ver. 2.1
     4  !
     5  ! Authors::   Yoshiyuki O. Takahashi
     6  ! Version::   $Id: rad_Earth_SW_V2_1.f90,v 1.6 2013/01/18 02:40:46 yot Exp $
     7  ! Tag Name::  $Name:  $
     8  ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9  ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10  !
    11  module rad_Earth_SW_V2_1
    12  
    13    !
    14    != 地球大気向け短波放射モデル Ver. 2.1
    15    !
    16    != short wave radiation model for the Earth's atmosphere Ver. 2.1
    17    !
    18    ! <b>Note that Japanese and English are described in parallel.</b>
    19    !
    20    ! 地球大気向け短波放射モデル.
    21    !
    22    ! This is a short wave radiation model for the Earth's atmospehre.
    23    !
    24    ! The wavenumber range of shortwave radiation treated by this routine is
    25    ! from 1000 to 57143 cm-1 (0.175 to 10 micron).
    26    !
    27    ! From 1000 to 57143 cm-1, the following effects are considered.
    28    ! * 1000 to 14286 cm-1 (0.70-10 micron):
    29    !   * absorption by H2O,
    30    !     * absorption by H2O is considered by using k-distribution method
    31    !       following Chou and Lee (1996),
    32    !   * absorption and scattering by cloud droplets.
    33    !     * optical properties of cloud is obtained from Chou et al. (1998)
    34    ! * 14286 to 57143 cm-1 (0.175 to 0.70 micron):
    35    !   * Rayleigh scattering,
    36    !     * scattering coefficient is obtained from Chou and Lee (1996),
    37    !   * scattering by cloud droplets.
    38    !     * optical properties of cloud is obtained from Chou et al. (1998)
    39    !
    40    !
    41    !== References
    42    !
    43    !  Chou, M.-D., and K.-T. Lee,
    44    !    Parameterizations for the absorption of solar radiation by water vapor and ozone,
    45    !    J. Atmos. Sci., 53, 1203-1208, 1996.
    46    !
    47    !  Chou, M.-D., M. J. Suarez, C.-H. Ho, M. M.-H. Yan, and K.-T. Lee,
    48    !    Parameterizations for cloud overlapping and shortwave single-scattering
    49    !    properties for use in general circulation and cloud ensemble models,
    50    !    J. Climate, 11, 202-214, 1998.
    51    !
    52    !== Procedures List
    53    !
    54    ! RadEarthSWV21Flux   :: 放射フラックスの計算
    55    ! ------------        :: ------------
    56    ! RadEarthSWV21Flux   :: Calculate radiation flux
    57    !
    58    !== NAMELIST
    59    !
    60    ! NAMELIST#rad_Earth_SW_V2_1_nml
    61    !
    62  
    63    ! USE statements
    64    !
    65  
    66    !
    67    ! Kind type parameter
    68    !
    69    use dc_types, only: DP, &      ! Double precision.
    70      &                 STRING, &  ! Strings.
    71      &                 TOKEN      ! Keywords.
    72  
    73    ! メッセージ出力
    74    ! Message output
    75    !
    76    use dc_message, only: MessageNotify
    77  
    78  
    79    ! 格子点設定
    80    ! Grid points settings
    81    !
    82    use gridset, only: imax, & ! 経度格子点数.
    83                               ! Number of grid points in longitude
    84      &                jmax, & ! 緯度格子点数.
    85                               ! Number of grid points in latitude
    86      &                kmax    ! 鉛直層数.
    87                               ! Number of vertical level
    88  
    89    ! 時刻管理
    90    ! Time control
    91    !
    92    use timeset, only: &
    93      & TimesetClockStart, TimesetClockStop
    94  
    95    implicit none
    96  
    97    private
    98  
    99    logical , save      :: FlagRayleighScattering
   100  
   101    real(DP), save      :: CloudWatREff
   102    real(DP), save      :: CloudIceREff
   103  
   104  
   105    ! 公開変数
   106    ! Public variables
   107    !
   108    logical, save :: rad_Earth_SW_V2_1_inited = .false.
   109                                ! 初期設定フラグ.
   110                                ! Initialization flag
   111  
   112    public :: RadEarthSWV21Flux
   113    public :: RadEarthSWV21Init
   114  
   115    character(*), parameter:: module_name = 'rad_Earth_SW_V2_1'
   116                                ! モジュールの名称.
   117                                ! Module name
   118    character(*), parameter:: version = &
   119      & '$Name:  $' // &
   120      & '$Id: rad_Earth_SW_V2_1.f90,v 1.6 2013/01/18 02:40:46 yot Exp $'
   121                                ! モジュールのバージョン
   122                                ! Module version
   123  
   124    !--------------------------------------------------------------------------------------
   125  
   126  contains
   127  
   128    !--------------------------------------------------------------------------------------
   129  
   130    subroutine RadEarthSWV21Flux(                                &
   131      & xy_SurfAlbedo,                                           &
   132      & xyz_DelAtmMass,                                          &
   133      & xyz_DelH2OVapMass, xyz_DelH2OLiqMass, xyz_DelH2OSolMass, &
   134      & xyz_DelO3Mass,                                           &
   135      & xyz_Press, xyz_Temp,                                     &
   136      & xyz_CloudCover,                                          &
   137      & xyr_RadSUwFlux, xyr_RadSDwFlux                           &
   138      & )
   139  
   140      ! USE statements
   141      !
   142  
   143      ! 太陽放射フラックスの設定
   144      ! Set solar constant
   145      !
   146      use set_solarconst, only : SetSolarConst
   147  
   148      ! 短波入射 (太陽入射)
   149      ! Short wave (insolation) incoming
   150      !
   151      use rad_short_income, only : RadShortIncome
   152  
   153      !
   154      ! Solve radiative transfer equation in two stream approximation
   155      !
   156      use rad_rte_two_stream_app, only: RadRTETwoStreamAppSW
   157  
   158      ! Chou and Lee (1996) による短波放射モデル
   159      ! Short wave radiation model described by Chou and Lee (1996)
   160      !
   161      use rad_CL1996, only :       &
   162        & RadCL1996NumBands      , &
   163        & RadCL1996UVVISParams   , &
   164        & RadCL1996IRH2ONumKDFBin, &
   165        & RadCL1996IRH2OKDFParams, &
   166        & RadCL1996ScaleH2OVapMass
   167  
   168  
   169      ! Chou et al (1998) による短波放射用雲モデル
   170      ! Cloud model for short wave radiation model described by Chou et al (1998)
   171      !
   172      use rad_C1998, only : RadC1998CalcCloudOptProp
   173  
   174  
   175      real(DP), intent(in ) :: xy_SurfAlbedo    (0:imax-1, 1:jmax )
   176      real(DP), intent(in ) :: xyz_DelAtmMass   (0:imax-1, 1:jmax, 1:kmax)
   177      real(DP), intent(in ) :: xyz_DelH2OVapMass(0:imax-1, 1:jmax, 1:kmax)
   178      real(DP), intent(in ) :: xyz_DelH2OLiqMass(0:imax-1, 1:jmax, 1:kmax)
   179      real(DP), intent(in ) :: xyz_DelH2OSolMass(0:imax-1, 1:jmax, 1:kmax)
   180      real(DP), intent(in ) :: xyz_DelO3Mass    (0:imax-1, 1:jmax, 1:kmax)
   181      real(DP), intent(in ) :: xyz_Press        (0:imax-1, 1:jmax, 1:kmax)
   182      real(DP), intent(in ) :: xyz_Temp         (0:imax-1, 1:jmax, 1:kmax)
   183      real(DP), intent(in ) :: xyz_CloudCover   (0:imax-1, 1:jmax, 1:kmax)
   184      real(DP), intent(out) :: xyr_RadSUwFlux   (0:imax-1, 1:jmax, 0:kmax)
   185      real(DP), intent(out) :: xyr_RadSDwFlux   (0:imax-1, 1:jmax, 0:kmax)
   186  
   187  
   188      real(DP) :: SolarConst
   189  
   190      real(DP) :: xy_InAngle    (0:imax-1, 1:jmax)
   191                                ! sec (入射角).
   192                                ! sec (angle of incidence)
   193      real(DP) :: DistFromStarScld
   194                                 ! Distance between the central star and the planet
   195      real(DP) :: DiurnalMeanFactor
   196  
   197  
   198      integer  :: nbands1
   199      integer  :: nbands2
   200  
   201      real(DP) :: UVVISFracSolarFlux
   202      real(DP) :: UVVISO3AbsCoef
   203      real(DP) :: UVVISRayScatCoef
   204  
   205      real(DP) :: SolarFluxTOA
   206  
   207  
   208  
   209      real(DP) :: xyz_SSA       (0:imax-1, 1:jmax, 1:kmax)
   210      real(DP) :: xyz_AF        (0:imax-1, 1:jmax, 1:kmax)
   211  
   212  
   213      real(DP), parameter :: RayScatSinScatAlb = 1.0d0 - 1.0d-10
   214      real(DP), parameter :: RayScatAsymFact   = 0.0d0
   215  
   216      real(DP)            :: xyz_DelH2OVapMassScaled( 0:imax-1, 1:jmax, 1:kmax )
   217  
   218      real(DP)            :: xyz_DelCloudWatOptDep( 0:imax-1, 1:jmax, 1:kmax )
   219      real(DP)            :: xyz_DelCloudIceOptDep( 0:imax-1, 1:jmax, 1:kmax )
   220  
   221      real(DP)            :: xyz_RayScatDelOptDep( 0:imax-1, 1:jmax, 1:kmax )
   222  
   223      real(DP)            :: xyz_O3AbsDelOptDep  ( 0:imax-1, 1:jmax, 1:kmax )
   224  
   225      real(DP)            :: xyz_DelTotOptDep( 0:imax-1, 1:jmax, 1:kmax )
   226      real(DP)            :: xyr_TotOptDep   ( 0:imax-1, 1:jmax, 0:kmax )
   227      real(DP)            :: xyr_RadFlux     ( 0:imax-1, 1:jmax, 0:kmax )
   228      real(DP)            :: xyr_RadUwFlux   ( 0:imax-1, 1:jmax, 0:kmax )
   229      real(DP)            :: xyr_RadDwFlux   ( 0:imax-1, 1:jmax, 0:kmax )
   230  
   231      integer  :: nkdf
   232  
   233      integer  :: ikdfbin
   234      real(DP) :: KDFAbsCoef
   235      real(DP) :: KDFWeight
   236      real(DP) :: xyz_H2ODelOptDep( 0:imax-1, 1:jmax, 1:kmax )
   237  
   238  
   239      real(DP) :: xyz_CloudREff   (0:imax-1, 1:jmax, 1:kmax)
   240      real(DP) :: xyz_CloudExtCoef(0:imax-1, 1:jmax, 1:kmax)
   241      real(DP) :: xyz_CloudCoAlb  (0:imax-1, 1:jmax, 1:kmax)
   242      real(DP) :: xyz_CloudWatSSA (0:imax-1, 1:jmax, 1:kmax)
   243      real(DP) :: xyz_CloudWatAF  (0:imax-1, 1:jmax, 1:kmax)
   244      real(DP) :: xyz_CloudIceSSA (0:imax-1, 1:jmax, 1:kmax)
   245      real(DP) :: xyz_CloudIceAF  (0:imax-1, 1:jmax, 1:kmax)
   246  
   247  
   248  
   249      integer  :: i
   250      integer  :: j
   251      integer  :: k
   252      integer  :: l
   253  
   254  
   255      ! 初期化確認
   256      ! Initialization check
   257      !
   258      if ( .not. rad_Earth_SW_V2_1_inited ) then
   259        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   260      end if
   261  
   262  
   263      ! 計算時間計測開始
   264      ! Start measurement of computation time
   265      !
   266      call TimesetClockStart( module_name )
   267  
   268  
   269      ! 太陽放射フラックスの設定
   270      ! Set solar constant
   271      !
   272      call SetSolarConst( &
   273        & SolarConst      & ! (out)
   274        & )
   275  
   276      ! 短波入射の計算
   277      ! Calculate short wave (insolation) incoming radiation
   278      !
   279      call RadShortIncome(                       &
   280        & xy_InAngle        = xy_InAngle,        & ! (out) optional
   281        & DistFromStarScld  = DistFromStarScld,  & ! (out) optional
   282        & DiurnalMeanFactor = DiurnalMeanFactor  &
   283        & )
   284  
   285  
   286      call RadCL1996NumBands(   &
   287        & nbands1, nbands2      & ! (out)
   288        & )
   289  
   290  
   291      ! Initialization
   292      !
   293      xyr_RadSUwFlux = 0.0_DP
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t871 = 1, jmax*(kmax*imax + imax)                              
     .           xyr_radsuwflux(t871-1,1,0) = 0.0000000000000000e+000           
     .           xyr_radsdwflux(t871-1,1,0) = 0.0000000000000000e+000           
     .        enddo                                                             
   294      xyr_RadSDwFlux = 0.0_DP
   295  
   296  
   297      ! * 14286 to 57143 cm-1 (0.175 to 0.70 micron):
   298      !   * Rayleigh scattering,
   299      !   * scattering by cloud droplets.
   300      !   * O3 absorption
   301      !
   302      do l = 1, nbands1
   303  
   304        ! Water cloud optical properties
   305        !
   306        xyz_CloudREff = CloudWatREff
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t883 = 1, xyz_cloudreff.DSC.U3*(xyz_cloudreff.DSC.U2*          
     .       1   xyz_cloudreff.DSC.U1 + xyz_cloudreff.DSC.U2)                   
     .           xyz_cloudreff(t883-1,1,1) = cloudwatreff                       
     .        enddo                                                             
   307        call RadC1998CalcCloudOptProp(                        &
   308          & 'Liquid', l, xyz_CloudREff,                       & ! (in )
   309          & xyz_CloudExtCoef, xyz_CloudCoAlb, xyz_CloudWatAF  & ! (out)
   310          & )
   311        xyz_DelCloudWatOptDep = xyz_CloudExtCoef * xyz_DelH2OLiqMass
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t892 = 1, xyz_cloudextcoef.DSC.U3*(xyz_cloudextcoef.DSC.U2*    
     .       1   xyz_cloudextcoef.DSC.U1 + xyz_cloudextcoef.DSC.U2)             
     .           xyz_delcloudwatoptdep(t892-1,1,1) = xyz_cloudextcoef(t892-1,1,1
     .       1      )*xyz_delh2oliqmass(t892-1,1,1)                             
     .           xyz_cloudwatssa(t892-1,1,1) = 1.00000000000000e+000 -          
     .       1      xyz_cloudcoalb(t892-1,1,1)                                  
     .           xyz_cloudreff(t892-1,1,1) = cloudicereff                       
     .        enddo                                                             
   312        xyz_CloudWatSSA       = 1.0_DP - xyz_CloudCoAlb
   313  
   314        ! Ice cloud optical properties
   315        !
   316        xyz_CloudREff = CloudIceREff
   317        call RadC1998CalcCloudOptProp(                        &
   318          & 'Ice', l, xyz_CloudREff,                          & ! (in )
   319          & xyz_CloudExtCoef, xyz_CloudCoAlb, xyz_CloudIceAF  & ! (out)
   320          & )
   321        xyz_DelCloudIceOptDep = xyz_CloudExtCoef * xyz_DelH2OSolMass
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t916 = 1, xyz_cloudextcoef.DSC.U3*(xyz_cloudextcoef.DSC.U2*    
     .       1   xyz_cloudextcoef.DSC.U1 + xyz_cloudextcoef.DSC.U2)             
     .           xyz_delcloudiceoptdep(t916-1,1,1) = xyz_cloudextcoef(t916-1,1,1
     .       1      )*xyz_delh2osolmass(t916-1,1,1)                             
     .           xyz_cloudicessa(t916-1,1,1) = 1.00000000000000e+000 -          
     .       1      xyz_cloudcoalb(t916-1,1,1)                                  
     .        enddo                                                             
   322        xyz_CloudIceSSA       = 1.0_DP - xyz_CloudCoAlb
   323  
   324  
   325        ! UV and Visible optical properties and solar flux
   326        !
   327        call RadCL1996UVVISParams(                                &
   328          & l,                                                    & ! (in )
   329          & UVVISFracSolarFlux, UVVISO3AbsCoef, UVVISRayScatCoef  & ! (out)
   330          & )
   331  
   332        SolarFluxTOA = UVVISFracSolarFlux * SolarConst / DistFromStarScld**2 * DiurnalMeanFactor
   333  
   334  
   335        ! Rayleigh scattering
   336        !
   337        if ( FlagRayleighScattering ) then
   338          xyz_RayScatDelOptDep = UVVISRayScatCoef * xyz_DelAtmMass
     .        if (1 + jmax - min0(1,jmax) .gt. 0) then                          
     .           j1 = and(1 + jmax - min0(1,jmax),3)                            
     .  !cdir    nodep                                                          
     .           do t1277 = 1, j1                                               
     .  !cdir       nodep                                                       
     .              do t1279 = 1, 1 + imax - min0(1,imax)                       
     .                 xyz_rayscatdeloptdep(t1279-1,t1277,t1275+1) =            
     .       1            uvvisrayscatcoef*xyz_delatmmass(t1279-1,t1277,t1275+1)
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t1277 = j1 + 1, 1 + jmax - min0(1,jmax), 4                  
     .  !cdir       nodep                                                       
     .              do t1279 = 1, 1 + imax - min0(1,imax)                       
     .                 xyz_rayscatdeloptdep(t1279-1,t1277,t1275+1) =            
     .       1            uvvisrayscatcoef*xyz_delatmmass(t1279-1,t1277,t1275+1)
     .                 xyz_rayscatdeloptdep(t1279-1,t1277+1,t1275+1) =          
     .       1            uvvisrayscatcoef*xyz_delatmmass(t1279-1,t1277+1,t1275+
     .       2            1)                                                    
     .                 xyz_rayscatdeloptdep(t1279-1,t1277+2,t1275+1) =          
     .       1            uvvisrayscatcoef*xyz_delatmmass(t1279-1,t1277+2,t1275+
     .       2            1)                                                    
     .                 xyz_rayscatdeloptdep(t1279-1,t1277+3,t1275+1) =          
     .       1            uvvisrayscatcoef*xyz_delatmmass(t1279-1,t1277+3,t1275+
     .       2            1)                                                    
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
   339        else
   340          xyz_RayScatDelOptDep = 0.0d0
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t937 = 1, xyz_rayscatdeloptdep.DSC.U3*(                        
     .       1   xyz_rayscatdeloptdep.DSC.U2*xyz_rayscatdeloptdep.DSC.U1 +      
     .       2   xyz_rayscatdeloptdep.DSC.U2)                                   
     .           xyz_rayscatdeloptdep(t937-1,1,1) = 0.0000000000000000e+000     
     .        enddo                                                             
   341        end if
   342  
   343  
   344        ! O3 absorption
   345        !
   346        xyz_O3AbsDelOptDep = UVVISO3AbsCoef * xyz_DelO3Mass
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t946 = 1, kmax*jmax*imax                                       
     .           xyz_o3absdeloptdep(t946-1,1,1) = uvviso3abscoef*xyz_delo3mass( 
     .       1      t946-1,1,1)                                                 
     .           xyz_deltotoptdep(t946-1,1,1) = xyz_delcloudwatoptdep(t946-1,1,1
     .       1      ) + xyz_delcloudiceoptdep(t946-1,1,1) + xyz_rayscatdeloptdep
     .       2      (t946-1,1,1) + xyz_o3absdeloptdep(t946-1,1,1)               
     .        enddo                                                             
   347  
   348  
   349        ! Total optical parameter
   350        !
   351        xyz_DelTotOptDep =            &
   352          &   xyz_DelCloudWatOptDep   &
   353          & + xyz_DelCloudIceOptDep   &
   354          & + xyz_RayScatDelOptDep    &
   355          & + xyz_O3AbsDelOptDep
   356        !
   357        xyr_TotOptDep(:,:,kmax) = 0.0d0
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t973 = 1, xyr_totoptdep.DSC.U2*xyr_totoptdep.DSC.U1 +          
     .       1   xyr_totoptdep.DSC.U2                                           
     .           xyr_totoptdep(t973-1,1,kmax) = 0.0000000000000000e+000         
     .        enddo                                                             
   358        do k = kmax-1, 0, -1
   359          xyr_TotOptDep(:,:,k) = xyr_TotOptDep(:,:,k+1) + xyz_DelTotOptDep(:,:,k+1)
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xyr_totoptdep)                                             
     .        do t979 = 1, xyr_totoptdep.DSC.U2*xyr_totoptdep.DSC.U1 +          
     .       1   xyr_totoptdep.DSC.U2                                           
     .           xyr_totoptdep(t979-1,1,k) = xyr_totoptdep(t979-1,1,k+1) +      
     .       1      xyz_deltotoptdep(t979-1,1,k+1)                              
     .        enddo                                                             
   360        end do
   361        !
   362        xyz_SSA =                                           &
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t989 = 1, xyz_cloudwatssa.DSC.U3*(xyz_cloudwatssa.DSC.U2*      
     .       1   xyz_cloudwatssa.DSC.U1 + xyz_cloudwatssa.DSC.U2)               
     .           xyz_ssa(t989-1,1,1) = (xyz_cloudwatssa(t989-1,1,1)*            
     .       1      xyz_delcloudwatoptdep(t989-1,1,1)+xyz_cloudicessa(t989-1,1,1
     .       2      )*xyz_delcloudiceoptdep(t989-1,1,1)+9.99999999899999e-001*  
     .       3      xyz_rayscatdeloptdep(t989-1,1,1)+0.0000000000000000e+000*   
     .       4      xyz_o3absdeloptdep(t989-1,1,1))/(xyz_deltotoptdep(t989-1,1,1
     .       5      )+1.00000000000000e-100)                                    
     .        enddo                                                             
   363          &   ( xyz_CloudWatSSA   * xyz_DelCloudWatOptDep   &
   364          &   + xyz_CloudIceSSA   * xyz_DelCloudIceOptDep   &
   365          &   + RayScatSinScatAlb * xyz_RayScatDelOptDep    &
   366          &   + 0.0d0             * xyz_O3AbsDelOptDep   )  &
   367          & / ( xyz_DelTotOptDep + 1.0d-100 )
   368        do k = 1, kmax
   369          do j = 1, jmax
   370            do i = 0, imax-1
   371              if ( xyz_SSA(i,j,k) >= 1.0d0 ) then
   372                xyz_SSA(i,j,k) = 1.0d0 - 1.0d-10
   373              end if
   374            end do
   375          end do
   376        end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do k = 1, kmax*jmax*imax                                          
     .           if (xyz_ssa(k-1,1,1) .ge. 1.00000000000000e+000) then          
     .              xyz_ssa(k-1,1,1) = 9.99999999899999e-001                    
     .           endif                                                          
     .        enddo                                                             
   377        xyz_AF  =                                                               &
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1019 = 1, xyz_cloudwataf.DSC.U3*(xyz_cloudwataf.DSC.U2*       
     .       1   xyz_cloudwataf.DSC.U1 + xyz_cloudwataf.DSC.U2)                 
     .           xyz_af(t1019-1,1,1) = (xyz_cloudwataf(t1019-1,1,1)*            
     .       1      xyz_cloudwatssa(t1019-1,1,1)*xyz_delcloudwatoptdep(t1019-1,1
     .       2      ,1)+xyz_cloudiceaf(t1019-1,1,1)*xyz_cloudicessa(t1019-1,1,1)
     .       3      *xyz_delcloudiceoptdep(t1019-1,1,1)+0.0000000000000000e+000*
     .       4      xyz_rayscatdeloptdep(t1019-1,1,1)+0.0000000000000000e+000*  
     .       5      xyz_o3absdeloptdep(t1019-1,1,1))/(xyz_ssa(t1019-1,1,1)*     
     .       6      xyz_deltotoptdep(t1019-1,1,1)+1.00000000000000e-100)        
     .        enddo                                                             
   378          &   ( xyz_CloudWatAF    * xyz_CloudWatSSA   * xyz_DelCloudWatOptDep   &
   379          &   + xyz_CloudIceAF    * xyz_CloudIceSSA   * xyz_DelCloudIceOptDep   &
   380          &   + RayScatAsymFact   * RayScatSinScatAlb * xyz_RayScatDelOptDep    &
   381          &   + 0.0d0             * 0.0d0             * xyz_O3AbsDelOptDep   )  &
   382          & / ( xyz_SSA * xyz_DelTotOptDep + 1.0d-100 )
   383  
   384  
   385        call RadRTETwoStreamAppSW(        &
   386          & xyz_SSA, xyz_AF,              & ! (in)
   387          & xyr_TotOptDep,                & ! (in)
   388          & xy_SurfAlbedo,                & ! (in)
   389          & SolarFluxTOA, xy_InAngle,     & ! (in)
   390          & xyr_RadUwFlux, xyr_RadDwFlux  & ! (out)
   391          & )
   392  
   393        xyr_RadSUwFlux = xyr_RadSUwFlux + xyr_RadUwFlux
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1058 = 1, jmax*(kmax*imax + imax)                             
     .           xyr_radsuwflux(t1058-1,1,0) = xyr_radsuwflux(t1058-1,1,0) +    
     .       1      xyr_raduwflux(t1058-1,1,0)                                  
     .           xyr_radsdwflux(t1058-1,1,0) = xyr_radsdwflux(t1058-1,1,0) +    
     .       1      xyr_raddwflux(t1058-1,1,0)                                  
     .        enddo                                                             
   394        xyr_RadSDwFlux = xyr_RadSDwFlux + xyr_RadDwFlux
   395  
   396      end do
   397  
   398  
   399      ! * 1000 to 14286 cm-1 (0.70-10 micron):
   400      !   * absorption by H2O,
   401      !   * scattering by cloud droplets.
   402      !
   403  
   404      call RadCL1996ScaleH2OVapMass(              &
   405        & xyz_Temp, xyz_DelH2OVapMass, xyz_Press, & ! (in )
   406        & xyz_DelH2OVapMassScaled                 & ! (out)
   407        & )
   408  
   409  
   410      call RadCL1996IRH2ONumKDFBin( &
   411        & nkdf & ! (out)
   412        & )
   413  
   414  
   415      SolarFluxTOA = SolarConst / DistFromStarScld**2 * DiurnalMeanFactor
   416  
   417      do l = nbands1+1, nbands1+nbands2
   418  
   419        ! Water cloud optical properties
   420        !
   421        xyz_CloudREff = CloudWatREff
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1082 = 1, xyz_cloudreff.DSC.U3*(xyz_cloudreff.DSC.U2*         
     .       1   xyz_cloudreff.DSC.U1 + xyz_cloudreff.DSC.U2)                   
     .           xyz_cloudreff(t1082-1,1,1) = cloudwatreff                      
     .        enddo                                                             
   422        call RadC1998CalcCloudOptProp(                        &
   423          & 'Liquid', l, xyz_CloudREff,                       & ! (in )
   424          & xyz_CloudExtCoef, xyz_CloudCoAlb, xyz_CloudWatAF  & ! (out)
   425          & )
   426        xyz_DelCloudWatOptDep = xyz_CloudExtCoef * xyz_DelH2OLiqMass
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1091 = 1, xyz_cloudextcoef.DSC.U3*(xyz_cloudextcoef.DSC.U2*   
     .       1   xyz_cloudextcoef.DSC.U1 + xyz_cloudextcoef.DSC.U2)             
     .           xyz_delcloudwatoptdep(t1091-1,1,1) = xyz_cloudextcoef(t1091-1,1
     .       1      ,1)*xyz_delh2oliqmass(t1091-1,1,1)                          
     .           xyz_cloudwatssa(t1091-1,1,1) = 1.00000000000000e+000 -         
     .       1      xyz_cloudcoalb(t1091-1,1,1)                                 
     .           xyz_cloudreff(t1091-1,1,1) = cloudicereff                      
     .        enddo                                                             
   427        xyz_CloudWatSSA       = 1.0_DP - xyz_CloudCoAlb
   428  
   429        ! Ice cloud optical properties
   430        !
   431        xyz_CloudREff = CloudIceREff
   432        call RadC1998CalcCloudOptProp(                        &
   433          & 'Ice', l, xyz_CloudREff,                          & ! (in )
   434          & xyz_CloudExtCoef, xyz_CloudCoAlb, xyz_CloudIceAF  & ! (out)
   435          & )
   436        xyz_DelCloudIceOptDep = xyz_CloudExtCoef * xyz_DelH2OSolMass
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1115 = 1, xyz_cloudextcoef.DSC.U3*(xyz_cloudextcoef.DSC.U2*   
     .       1   xyz_cloudextcoef.DSC.U1 + xyz_cloudextcoef.DSC.U2)             
     .           xyz_delcloudiceoptdep(t1115-1,1,1) = xyz_cloudextcoef(t1115-1,1
     .       1      ,1)*xyz_delh2osolmass(t1115-1,1,1)                          
     .           xyz_cloudicessa(t1115-1,1,1) = 1.00000000000000e+000 -         
     .       1      xyz_cloudcoalb(t1115-1,1,1)                                 
     .        enddo                                                             
   437        xyz_CloudIceSSA       = 1.0_DP - xyz_CloudCoAlb
   438  
   439  
   440        do ikdfbin = 1, nkdf
   441  
   442          call RadCL1996IRH2OKDFParams(              &
   443            & l, ikdfbin,                            & ! (in )
   444            & KDFAbsCoef, KDFWeight                  & ! (out)
   445            & )
   446  
   447          xyz_H2ODelOptDep = KDFAbsCoef * xyz_DelH2OVapMassScaled
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1136 = 1, xyz_delh2ovapmassscaled.DSC.U3*(                    
     .       1   xyz_delh2ovapmassscaled.DSC.U2*xyz_delh2ovapmassscaled.DSC.U1  
     .       2    + xyz_delh2ovapmassscaled.DSC.U2)                             
     .           xyz_h2odeloptdep(t1136-1,1,1) = kdfabscoef*                    
     .       1      xyz_delh2ovapmassscaled(t1136-1,1,1)                        
     .           xyz_deltotoptdep(t1136-1,1,1) = xyz_delcloudwatoptdep(t1136-1,1
     .       1      ,1) + xyz_delcloudiceoptdep(t1136-1,1,1) + xyz_h2odeloptdep(
     .       2      t1136-1,1,1)                                                
     .        enddo                                                             
   448  
   449  
   450          ! Total optical parameter
   451          !
   452          xyz_DelTotOptDep =          &
   453            &   xyz_DelCloudWatOptDep &
   454            & + xyz_DelCloudIceOptDep &
   455            & + xyz_H2ODelOptDep
   456  
   457          xyr_TotOptDep(:,:,kmax) = 0.0d0
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1160 = 1, xyr_totoptdep.DSC.U2*xyr_totoptdep.DSC.U1 +         
     .       1   xyr_totoptdep.DSC.U2                                           
     .           xyr_totoptdep(t1160-1,1,kmax) = 0.0000000000000000e+000        
     .        enddo                                                             
   458          do k = kmax-1, 0, -1
   459            xyr_TotOptDep(:,:,k) = xyr_TotOptDep(:,:,k+1) + xyz_DelTotOptDep(:,:,k+1)
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xyr_totoptdep)                                             
     .        do t1166 = 1, xyr_totoptdep.DSC.U2*xyr_totoptdep.DSC.U1 +         
     .       1   xyr_totoptdep.DSC.U2                                           
     .           xyr_totoptdep(t1166-1,1,k) = xyr_totoptdep(t1166-1,1,k+1) +    
     .       1      xyz_deltotoptdep(t1166-1,1,k+1)                             
     .        enddo                                                             
   460          end do
   461  
   462          xyz_SSA =                                            &
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1176 = 1, xyz_cloudwatssa.DSC.U3*(xyz_cloudwatssa.DSC.U2*     
     .       1   xyz_cloudwatssa.DSC.U1 + xyz_cloudwatssa.DSC.U2)               
     .           xyz_ssa(t1176-1,1,1) = (xyz_cloudwatssa(t1176-1,1,1)*          
     .       1      xyz_delcloudwatoptdep(t1176-1,1,1)+xyz_cloudicessa(t1176-1,1
     .       2      ,1)*xyz_delcloudiceoptdep(t1176-1,1,1)+                     
     .       3      0.0000000000000000e+000*xyz_h2odeloptdep(t1176-1,1,1))/(    
     .       4      xyz_deltotoptdep(t1176-1,1,1)+1.00000000000000e-100)        
     .        enddo                                                             
   463            &   ( xyz_CloudWatSSA   * xyz_DelCloudWatOptDep    &
   464            &   + xyz_CloudIceSSA   * xyz_DelCloudIceOptDep    &
   465            &   + 0.0d0             * xyz_H2ODelOptDep      )  &
   466            & / ( xyz_DelTotOptDep + 1.0d-100 )
   467          do k = 1, kmax
   468            do j = 1, jmax
   469              do i = 0, imax-1
   470                if ( xyz_SSA(i,j,k) >= 1.0d0 ) then
   471                  xyz_SSA(i,j,k) = 1.0d0 - 1.0d-10
   472                end if
   473              end do
   474            end do
   475          end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do k = 1, kmax*jmax*imax                                          
     .           if (xyz_ssa(k-1,1,1) .ge. 1.00000000000000e+000) then          
     .              xyz_ssa(k-1,1,1) = 9.99999999899999e-001                    
     .           endif                                                          
     .        enddo                                                             
   476          xyz_AF  =                                                               &
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1203 = 1, xyz_cloudwataf.DSC.U3*(xyz_cloudwataf.DSC.U2*       
     .       1   xyz_cloudwataf.DSC.U1 + xyz_cloudwataf.DSC.U2)                 
     .           xyz_af(t1203-1,1,1) = (xyz_cloudwataf(t1203-1,1,1)*            
     .       1      xyz_cloudwatssa(t1203-1,1,1)*xyz_delcloudwatoptdep(t1203-1,1
     .       2      ,1)+xyz_cloudiceaf(t1203-1,1,1)*xyz_cloudicessa(t1203-1,1,1)
     .       3      *xyz_delcloudiceoptdep(t1203-1,1,1)+0.0000000000000000e+000*
     .       4      xyz_h2odeloptdep(t1203-1,1,1))/(xyz_ssa(t1203-1,1,1)*       
     .       5      xyz_deltotoptdep(t1203-1,1,1)+1.00000000000000e-100)        
     .        enddo                                                             
   477            &   ( xyz_CloudWatAF    * xyz_CloudWatSSA   * xyz_DelCloudWatOptDep   &
   478            &   + xyz_CloudIceAF    * xyz_CloudIceSSA   * xyz_DelCloudIceOptDep   &
   479            &   + 0.0d0             * 0.0d0             * xyz_H2ODelOptDep     )  &
   480            & / ( xyz_ssa * xyz_DelTotOptDep + 1.0d-100 )
   481  
   482  
   483          call RadRTETwoStreamAppSW(        &
   484            & xyz_SSA, xyz_AF,              & ! (in)
   485            & xyr_TotOptDep,                & ! (in)
   486            & xy_SurfAlbedo,                & ! (in)
   487            & SolarFluxTOA, xy_InAngle,     & ! (in)
   488            & xyr_RadUwFlux, xyr_RadDwFlux  & ! (out)
   489            & )
   490  
   491  
   492          xyr_RadUwFlux = xyr_RadUwFlux * KDFWeight
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1239 = 1, (xyr_raduwflux.DSC.U3 + 1)*xyr_raduwflux.DSC.U2*(   
     .       1   xyr_raduwflux.DSC.U1 + 1)                                      
     .           xyr_raduwflux(t1239-1,1,0) = xyr_raduwflux(t1239-1,1,0)*       
     .       1      kdfweight                                                   
     .           xyr_raddwflux(t1239-1,1,0) = xyr_raddwflux(t1239-1,1,0)*       
     .       1      kdfweight                                                   
     .           xyr_radsuwflux(t1239-1,1,0) = xyr_radsuwflux(t1239-1,1,0) +    
     .       1      xyr_raduwflux(t1239-1,1,0)                                  
     .           xyr_radsdwflux(t1239-1,1,0) = xyr_radsdwflux(t1239-1,1,0) +    
     .       1      xyr_raddwflux(t1239-1,1,0)                                  
     .        enddo                                                             
   493          xyr_RadDwFlux = xyr_RadDwFlux * KDFWeight
   494  
   495          xyr_RadSUwFlux = xyr_RadSUwFlux + xyr_RadUwFlux
   496          xyr_RadSDwFlux = xyr_RadSDwFlux + xyr_RadDwFlux
   497  
   498        end do
   499  
   500      end do
   501  
   502  
   503  
   504  !!$    i = 0
   505  !!$    j = jmax / 2 + 1
   506  !!$    do k = 1, kmax
   507  !!$      write( 73, * ) xyz_Temp(i,j,k), xyz_QH2OVap(i,j,k), &
   508  !!$        & xyz_Press(i,j,k)
   509  !!$    end do
   510  !!$    call flush( 73 )
   511  !!$
   512  !!$    i = 0
   513  !!$    j = jmax / 2 + 1
   514  !!$    do k = 1, kmax
   515  !!$      write( 83, * ) &
   516  !!$        & + (     xyr_RadSFlux(i,j,k-1) - xyr_RadSFlux(i,j,k) )  &
   517  !!$        &     / ( xyr_Press(i,j,k-1)    - xyr_Press(i,j,k) )     &
   518  !!$        &     / 1004.6 * Grav, &
   519  !!$        & xyz_Press(i,j,k)
   520  !!$    end do
   521  !!$    call flush( 83 )
   522  !!$
   523  !!$!    write( 6, * ) '########## ', acos( 1.0d0 / xy_InAngle(i,j) ) * 180.0d0 / 3.141592d0
   524  !!$
   525  !!$
   526  !!$    i = 0
   527  !!$    j = jmax / 2 + 1
   528  !!$    write( 93, * ) '# ', xy_SurfAlbedo(i,j)
   529  !!$    write( 93, * ) '# ', 1.0_DP / xy_InAngle(i,j)
   530  !!$    do k = 0, kmax
   531  !!$      write( 93, * ) xyr_RadSFlux(i,j,k), xyr_Press(i,j,k)
   532  !!$    end do
   533  !!$    call flush( 93 )
   534  !!$    stop
   535  
   536  
   537      ! 計算時間計測一時停止
   538      ! Pause measurement of computation time
   539      !
   540      call TimesetClockStop( module_name )
   541  
   542  
   543    end subroutine RadEarthSWV21Flux
   544  
   545    !--------------------------------------------------------------------------------------
   546  
   547    subroutine RadEarthSWV21Init
   548  
   549      ! ファイル入出力補助
   550      ! File I/O support
   551      !
   552      use dc_iounit, only: FileOpen
   553  
   554      ! NAMELIST ファイル入力に関するユーティリティ
   555      ! Utilities for NAMELIST file input
   556      !
   557      use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid
   558  
   559      ! 太陽放射フラックスの設定
   560      ! Set solar constant
   561      !
   562      use set_solarconst, only : SetSolarConstInit
   563  
   564      ! 短波入射 (太陽入射)
   565      ! Short wave (insolation) incoming
   566      !
   567      use rad_short_income, only : RadShortIncomeInit
   568  
   569      !
   570      ! Solve radiative transfer equation in two stream approximation
   571      !
   572      use rad_rte_two_stream_app, only: RadRTETwoStreamAppInit
   573  
   574      ! Chou and Lee (1996) による短波放射モデル
   575      ! Short wave radiation model described by Chou and Lee (1996)
   576      !
   577      use rad_CL1996, only : RadCL1996Init
   578  
   579      ! Chou et al (1998) による短波放射用雲モデル
   580      ! Cloud model for short wave radiation model described by Chou et al (1998)
   581      !
   582      use rad_C1998, only : RadC1998Init
   583  
   584  
   585      ! 宣言文 ; Declaration statements
   586      !
   587  
   588      integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号.
   589                                ! Unit number for NAMELIST file open
   590      integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT.
   591                                ! IOSTAT of NAMELIST read
   592  
   593      ! NAMELIST 変数群
   594      ! NAMELIST group name
   595      !
   596      namelist /rad_Earth_SW_V2_1_nml/ &
   597        & FlagRayleighScattering, &
   598        & CloudWatREff, CloudIceREff
   599            !
   600            ! デフォルト値については初期化手続 "rad_Earth_SW_V2_1#RadEarthSWV21Init"
   601            ! のソースコードを参照のこと.
   602            !
   603            ! Refer to source codes in the initialization procedure
   604            ! "rad_Earth_SW_V2_1#RadEarthSWEV21Init" for the default values.
   605            !
   606  
   607      if ( rad_Earth_SW_V2_1_inited ) return
   608  
   609  
   610      ! デフォルト値の設定
   611      ! Default values settings
   612      !
   613      FlagRayleighScattering = .true.
   614  
   615      CloudWatREff           = 10.0d-6
   616      CloudIceREff           = 50.0d-6
   617  
   618      ! NAMELIST の読み込み
   619      ! NAMELIST is input
   620      !
   621      if ( trim(namelist_filename) /= '' ) then
   622        call FileOpen( unit_nml, &          ! (out)
   623          & namelist_filename, mode = 'r' ) ! (in)
   624  
   625        rewind( unit_nml )
   626        read( unit_nml,                          & ! (in)
   627          & nml = rad_Earth_SW_V2_1_nml,         & ! (out)
   628          & iostat = iostat_nml )                  ! (out)
   629        close( unit_nml )
   630  
   631        call NmlutilMsg( iostat_nml, module_name ) ! (in)
   632      end if
   633  
   634  
   635  
   636      ! Initialization of modules used in this module
   637      !
   638  
   639      ! 太陽放射フラックスの設定
   640      ! Set solar constant
   641      !
   642      call SetSolarConstInit
   643  
   644      ! 短波入射 (太陽入射)
   645      ! Short wave (insolation) incoming
   646      !
   647      call RadShortIncomeInit
   648  
   649      !
   650      ! Solve radiative transfer equation in two stream approximation
   651      !
   652      call RadRTETwoStreamAppInit
   653  
   654      ! Chou and Lee (1996) による短波放射モデル
   655      ! Short wave radiation model described by Chou and Lee (1996)
   656      !
   657      call RadCL1996Init
   658  
   659      ! Chou et al (1998) による短波放射用雲モデル
   660      ! Cloud model for short wave radiation model described by Chou et al (1998)
   661      !
   662      call RadC1998Init
   663  
   664  
   665      ! 印字 ; Print
   666      !
   667      call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   668      call MessageNotify( 'M', module_name, 'FlagRayleighScattering = %b', l = (/ FlagRayleighScattering /) )
   669      call MessageNotify( 'M', module_name, 'CloudWatREff           = %f', &
   670        & d = (/ CloudWatREff /) )
   671      call MessageNotify( 'M', module_name, 'CloudIceREff           = %f', &
   672        & d = (/ CloudIceREff /) )
   673      call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   674  
   675  
   676      rad_Earth_SW_V2_1_inited = .true.
   677  
   678    end subroutine RadEarthSWV21Init
   679  
   680    !--------------------------------------------------------------------------------------
   681  
   682  end module rad_Earth_SW_V2_1
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:53 2016
FILE NAME: rad_Earth_SW_V2_1.f90
PROGRAM NAME: rad_earth_sw_v2_1
FORMAT LIST

  LINE    LOOP      FORTRAN STATEMENT

     1:             != 地球大気向け短波放射モデル Ver. 2.1
     2:             !
     3:             != short wave radiation model for the Earth's atmosphere Ver. 2.1
     4:             !
     5:             ! Authors::   Yoshiyuki O. Takahashi
     6:             ! Version::   $Id: rad_Earth_SW_V2_1.f90,v 1.6 2013/01/18 02:40:46 yot Exp $
     7:             ! Tag Name::  $Name:  $
     8:             ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9:             ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10:             !
    11:             module rad_Earth_SW_V2_1
    12:             
    13:               !
    14:               != 地球大気向け短波放射モデル Ver. 2.1
    15:               !
    16:               != short wave radiation model for the Earth's atmosphere Ver. 2.1
    17:               !
    18:               ! <b>Note that Japanese and English are described in parallel.</b>
    19:               !
    20:               ! 地球大気向け短波放射モデル.
    21:               !
    22:               ! This is a short wave radiation model for the Earth's atmospehre.
    23:               !
    24:               ! The wavenumber range of shortwave radiation treated by this routine is 
    25:               ! from 1000 to 57143 cm-1 (0.175 to 10 micron). 
    26:               !
    27:               ! From 1000 to 57143 cm-1, the following effects are considered. 
    28:               ! * 1000 to 14286 cm-1 (0.70-10 micron): 
    29:               !   * absorption by H2O, 
    30:               !     * absorption by H2O is considered by using k-distribution method 
    31:               !       following Chou and Lee (1996), 
    32:               !   * absorption and scattering by cloud droplets.
    33:               !     * optical properties of cloud is obtained from Chou et al. (1998)
    34:               ! * 14286 to 57143 cm-1 (0.175 to 0.70 micron): 
    35:               !   * Rayleigh scattering, 
    36:               !     * scattering coefficient is obtained from Chou and Lee (1996), 
    37:               !   * scattering by cloud droplets. 
    38:               !     * optical properties of cloud is obtained from Chou et al. (1998)
    39:               !
    40:               !
    41:               !== References
    42:               !
    43:               !  Chou, M.-D., and K.-T. Lee, 
    44:               !    Parameterizations for the absorption of solar radiation by water vapor and ozone,
    45:               !    J. Atmos. Sci., 53, 1203-1208, 1996.
    46:               !
    47:               !  Chou, M.-D., M. J. Suarez, C.-H. Ho, M. M.-H. Yan, and K.-T. Lee, 
    48:               !    Parameterizations for cloud overlapping and shortwave single-scattering 
    49:               !    properties for use in general circulation and cloud ensemble models, 
    50:               !    J. Climate, 11, 202-214, 1998.
    51:               !
    52:               !== Procedures List
    53:               !
    54:               ! RadEarthSWV21Flux   :: 放射フラックスの計算
    55:               ! ------------        :: ------------
    56:               ! RadEarthSWV21Flux   :: Calculate radiation flux
    57:               !
    58:               !== NAMELIST
    59:               !
    60:               ! NAMELIST#rad_Earth_SW_V2_1_nml
    61:               !
    62:             
    63:               ! USE statements
    64:               !
    65:             
    66:               !
    67:               ! Kind type parameter
    68:               !
    69:               use dc_types, only: DP, &      ! Double precision.
    70:                 &                 STRING, &  ! Strings.
    71:                 &                 TOKEN      ! Keywords.
    72:             
    73:               ! メッセージ出力
    74:               ! Message output
    75:               !
    76:               use dc_message, only: MessageNotify
    77:             
    78:             
    79:               ! 格子点設定
    80:               ! Grid points settings
    81:               !
    82:               use gridset, only: imax, & ! 経度格子点数.
    83:                                          ! Number of grid points in longitude
    84:                 &                jmax, & ! 緯度格子点数.
    85:                                          ! Number of grid points in latitude
    86:                 &                kmax    ! 鉛直層数.
    87:                                          ! Number of vertical level
    88:             
    89:               ! 時刻管理
    90:               ! Time control
    91:               !
    92:               use timeset, only: &
    93:                 & TimesetClockStart, TimesetClockStop
    94:             
    95:               implicit none
    96:             
    97:               private
    98:             
    99:               logical , save      :: FlagRayleighScattering
   100:             
   101:               real(DP), save      :: CloudWatREff
   102:               real(DP), save      :: CloudIceREff
   103:             
   104:             
   105:               ! 公開変数
   106:               ! Public variables
   107:               !
   108:               logical, save :: rad_Earth_SW_V2_1_inited = .false.
   109:                                           ! 初期設定フラグ.
   110:                                           ! Initialization flag
   111:             
   112:               public :: RadEarthSWV21Flux
   113:               public :: RadEarthSWV21Init
   114:             
   115:               character(*), parameter:: module_name = 'rad_Earth_SW_V2_1'
   116:                                           ! モジュールの名称.
   117:                                           ! Module name
   118:               character(*), parameter:: version = &
   119:                 & '$Name:  $' // &
   120:                 & '$Id: rad_Earth_SW_V2_1.f90,v 1.6 2013/01/18 02:40:46 yot Exp $'
   121:                                           ! モジュールのバージョン
   122:                                           ! Module version
   123:             
   124:               !--------------------------------------------------------------------------------------
   125:             
   126:             contains
   127:             
   128:               !--------------------------------------------------------------------------------------
   129:             
   130:               subroutine RadEarthSWV21Flux(                                &
   131:                 & xy_SurfAlbedo,                                           &
   132:                 & xyz_DelAtmMass,                                          &
   133:                 & xyz_DelH2OVapMass, xyz_DelH2OLiqMass, xyz_DelH2OSolMass, &
   134:                 & xyz_DelO3Mass,                                           &
   135:                 & xyz_Press, xyz_Temp,                                     &
   136:                 & xyz_CloudCover,                                          &
   137:                 & xyr_RadSUwFlux, xyr_RadSDwFlux                           &
   138:                 & )
   139:             
   140:                 ! USE statements
   141:                 !
   142:             
   143:                 ! 太陽放射フラックスの設定
   144:                 ! Set solar constant
   145:                 !
   146:                 use set_solarconst, only : SetSolarConst
   147:             
   148:                 ! 短波入射 (太陽入射)
   149:                 ! Short wave (insolation) incoming
   150:                 !
   151:                 use rad_short_income, only : RadShortIncome
   152:             
   153:                 !
   154:                 ! Solve radiative transfer equation in two stream approximation
   155:                 !
   156:                 use rad_rte_two_stream_app, only: RadRTETwoStreamAppSW
   157:             
   158:                 ! Chou and Lee (1996) による短波放射モデル
   159:                 ! Short wave radiation model described by Chou and Lee (1996)
   160:                 !
   161:                 use rad_CL1996, only :       &
   162:                   & RadCL1996NumBands      , &
   163:                   & RadCL1996UVVISParams   , &
   164:                   & RadCL1996IRH2ONumKDFBin, &
   165:                   & RadCL1996IRH2OKDFParams, &
   166:                   & RadCL1996ScaleH2OVapMass
   167:             
   168:             
   169:                 ! Chou et al (1998) による短波放射用雲モデル
   170:                 ! Cloud model for short wave radiation model described by Chou et al (1998)
   171:                 !
   172:                 use rad_C1998, only : RadC1998CalcCloudOptProp
   173:             
   174:             
   175:                 real(DP), intent(in ) :: xy_SurfAlbedo    (0:imax-1, 1:jmax )
   176:                 real(DP), intent(in ) :: xyz_DelAtmMass   (0:imax-1, 1:jmax, 1:kmax)
   177:                 real(DP), intent(in ) :: xyz_DelH2OVapMass(0:imax-1, 1:jmax, 1:kmax)
   178:                 real(DP), intent(in ) :: xyz_DelH2OLiqMass(0:imax-1, 1:jmax, 1:kmax)
   179:                 real(DP), intent(in ) :: xyz_DelH2OSolMass(0:imax-1, 1:jmax, 1:kmax)
   180:                 real(DP), intent(in ) :: xyz_DelO3Mass    (0:imax-1, 1:jmax, 1:kmax)
   181:                 real(DP), intent(in ) :: xyz_Press        (0:imax-1, 1:jmax, 1:kmax)
   182:                 real(DP), intent(in ) :: xyz_Temp         (0:imax-1, 1:jmax, 1:kmax)
   183:                 real(DP), intent(in ) :: xyz_CloudCover   (0:imax-1, 1:jmax, 1:kmax)
   184:                 real(DP), intent(out) :: xyr_RadSUwFlux   (0:imax-1, 1:jmax, 0:kmax)
   185:                 real(DP), intent(out) :: xyr_RadSDwFlux   (0:imax-1, 1:jmax, 0:kmax)
   186:             
   187:             
   188:                 real(DP) :: SolarConst
   189:             
   190:                 real(DP) :: xy_InAngle    (0:imax-1, 1:jmax)
   191:                                           ! sec (入射角).
   192:                                           ! sec (angle of incidence)
   193:                 real(DP) :: DistFromStarScld
   194:                                            ! Distance between the central star and the planet
   195:                 real(DP) :: DiurnalMeanFactor
   196:             
   197:             
   198:                 integer  :: nbands1
   199:                 integer  :: nbands2
   200:             
   201:                 real(DP) :: UVVISFracSolarFlux
   202:                 real(DP) :: UVVISO3AbsCoef
   203:                 real(DP) :: UVVISRayScatCoef
   204:             
   205:                 real(DP) :: SolarFluxTOA
   206:             
   207:             
   208:             
   209:                 real(DP) :: xyz_SSA       (0:imax-1, 1:jmax, 1:kmax)
   210:                 real(DP) :: xyz_AF        (0:imax-1, 1:jmax, 1:kmax)
   211:             
   212:             
   213:                 real(DP), parameter :: RayScatSinScatAlb = 1.0d0 - 1.0d-10
   214:                 real(DP), parameter :: RayScatAsymFact   = 0.0d0
   215:             
   216:                 real(DP)            :: xyz_DelH2OVapMassScaled( 0:imax-1, 1:jmax, 1:kmax )
   217:             
   218:                 real(DP)            :: xyz_DelCloudWatOptDep( 0:imax-1, 1:jmax, 1:kmax )
   219:                 real(DP)            :: xyz_DelCloudIceOptDep( 0:imax-1, 1:jmax, 1:kmax )
   220:             
   221:                 real(DP)            :: xyz_RayScatDelOptDep( 0:imax-1, 1:jmax, 1:kmax )
   222:             
   223:                 real(DP)            :: xyz_O3AbsDelOptDep  ( 0:imax-1, 1:jmax, 1:kmax )
   224:             
   225:                 real(DP)            :: xyz_DelTotOptDep( 0:imax-1, 1:jmax, 1:kmax )
   226:                 real(DP)            :: xyr_TotOptDep   ( 0:imax-1, 1:jmax, 0:kmax )
   227:                 real(DP)            :: xyr_RadFlux     ( 0:imax-1, 1:jmax, 0:kmax )
   228:                 real(DP)            :: xyr_RadUwFlux   ( 0:imax-1, 1:jmax, 0:kmax )
   229:                 real(DP)            :: xyr_RadDwFlux   ( 0:imax-1, 1:jmax, 0:kmax )
   230:             
   231:                 integer  :: nkdf
   232:             
   233:                 integer  :: ikdfbin
   234:                 real(DP) :: KDFAbsCoef
   235:                 real(DP) :: KDFWeight
   236:                 real(DP) :: xyz_H2ODelOptDep( 0:imax-1, 1:jmax, 1:kmax )
   237:             
   238:             
   239:                 real(DP) :: xyz_CloudREff   (0:imax-1, 1:jmax, 1:kmax)
   240:                 real(DP) :: xyz_CloudExtCoef(0:imax-1, 1:jmax, 1:kmax)
   241:                 real(DP) :: xyz_CloudCoAlb  (0:imax-1, 1:jmax, 1:kmax)
   242:                 real(DP) :: xyz_CloudWatSSA (0:imax-1, 1:jmax, 1:kmax)
   243:                 real(DP) :: xyz_CloudWatAF  (0:imax-1, 1:jmax, 1:kmax)
   244:                 real(DP) :: xyz_CloudIceSSA (0:imax-1, 1:jmax, 1:kmax)
   245:                 real(DP) :: xyz_CloudIceAF  (0:imax-1, 1:jmax, 1:kmax)
   246:             
   247:             
   248:             
   249:                 integer  :: i
   250:                 integer  :: j
   251:                 integer  :: k
   252:                 integer  :: l
   253:             
   254:             
   255:                 ! 初期化確認
   256:                 ! Initialization check
   257:                 !
   258:                 if ( .not. rad_Earth_SW_V2_1_inited ) then
   259:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   260:                 end if
   261:             
   262:             
   263:                 ! 計算時間計測開始
   264:                 ! Start measurement of computation time
   265:                 !
   266:                 call TimesetClockStart( module_name )
   267:             
   268:             
   269:                 ! 太陽放射フラックスの設定
   270:                 ! Set solar constant
   271:                 !
   272:                 call SetSolarConst( &
   273:                   & SolarConst      & ! (out)
   274:                   & )
   275:             
   276:                 ! 短波入射の計算
   277:                 ! Calculate short wave (insolation) incoming radiation
   278:                 !
   279:                 call RadShortIncome(                       &
   280:                   & xy_InAngle        = xy_InAngle,        & ! (out) optional
   281:                   & DistFromStarScld  = DistFromStarScld,  & ! (out) optional
   282:                   & DiurnalMeanFactor = DiurnalMeanFactor  &
   283:                   & )
   284:             
   285:             
   286:                 call RadCL1996NumBands(   &
   287:                   & nbands1, nbands2      & ! (out)
   288:                   & )
   289:             
   290:             
   291:                 ! Initialization
   292:                 !
   293: **W---->A       xyr_RadSUwFlux = 0.0_DP
   294: **W---- A       xyr_RadSDwFlux = 0.0_DP
   295:             
   296:             
   297:                 ! * 14286 to 57143 cm-1 (0.175 to 0.70 micron): 
   298:                 !   * Rayleigh scattering, 
   299:                 !   * scattering by cloud droplets. 
   300:                 !   * O3 absorption
   301:                 !
   302: +------>        do l = 1, nbands1
   303: |           
   304: |                 ! Water cloud optical properties
   305: |                 !
   306: |W**=== A         xyz_CloudREff = CloudWatREff
   307: |                 call RadC1998CalcCloudOptProp(                        &
   308: |                   & 'Liquid', l, xyz_CloudREff,                       & ! (in )
   309: |                   & xyz_CloudExtCoef, xyz_CloudCoAlb, xyz_CloudWatAF  & ! (out)
   310: |                   & )
   311: |**W--->A         xyz_DelCloudWatOptDep = xyz_CloudExtCoef * xyz_DelH2OLiqMass
   312: ||||    A         xyz_CloudWatSSA       = 1.0_DP - xyz_CloudCoAlb
   313: ||||        
   314: ||||              ! Ice cloud optical properties
   315: ||||              !
   316: |**W--- A         xyz_CloudREff = CloudIceREff
   317: |                 call RadC1998CalcCloudOptProp(                        &
   318: |                   & 'Ice', l, xyz_CloudREff,                          & ! (in )
   319: |                   & xyz_CloudExtCoef, xyz_CloudCoAlb, xyz_CloudIceAF  & ! (out)
   320: |                   & )
   321: |**W--->A         xyz_DelCloudIceOptDep = xyz_CloudExtCoef * xyz_DelH2OSolMass
   322: |**W--- A         xyz_CloudIceSSA       = 1.0_DP - xyz_CloudCoAlb
   323: |           
   324: |           
   325: |                 ! UV and Visible optical properties and solar flux
   326: |                 !
   327: |                 call RadCL1996UVVISParams(                                &
   328: |                   & l,                                                    & ! (in )
   329: |                   & UVVISFracSolarFlux, UVVISO3AbsCoef, UVVISRayScatCoef  & ! (out)
   330: |                   & )
   331: |           
   332: |                 SolarFluxTOA = UVVISFracSolarFlux * SolarConst / DistFromStarScld**2 * DiurnalMeanFactor
   333: |           
   334: |           
   335: |                 ! Rayleigh scattering
   336: |                 !
   337: |                 if ( FlagRayleighScattering ) then
   338: |++V=== A           xyz_RayScatDelOptDep = UVVISRayScatCoef * xyz_DelAtmMass
   339: |                 else
   340: |W**===             xyz_RayScatDelOptDep = 0.0d0
   341: |                 end if
   342: |           
   343: |           
   344: |                 ! O3 absorption
   345: |                 !
   346: |**W--->A         xyz_O3AbsDelOptDep = UVVISO3AbsCoef * xyz_DelO3Mass
   347: ||||        
   348: ||||        
   349: ||||              ! Total optical parameter
   350: ||||              !
   351: |**W---           xyz_DelTotOptDep =            &
   352: |                   &   xyz_DelCloudWatOptDep   &
   353: |                   & + xyz_DelCloudIceOptDep   &
   354: |                   & + xyz_RayScatDelOptDep    &
   355: |                   & + xyz_O3AbsDelOptDep
   356: |                 !
   357: |W*==== A         xyr_TotOptDep(:,:,kmax) = 0.0d0
   358: |+----->          do k = kmax-1, 0, -1
   359: ||W*=== A           xyr_TotOptDep(:,:,k) = xyr_TotOptDep(:,:,k+1) + xyz_DelTotOptDep(:,:,k+1)
   360: |+-----           end do
   361: |                 !
   362: |W**=== A         xyz_SSA =                                           &
   363: |                   &   ( xyz_CloudWatSSA   * xyz_DelCloudWatOptDep   &
   364: |                   &   + xyz_CloudIceSSA   * xyz_DelCloudIceOptDep   &
   365: |                   &   + RayScatSinScatAlb * xyz_RayScatDelOptDep    &
   366: |                   &   + 0.0d0             * xyz_O3AbsDelOptDep   )  &
   367: |                   & / ( xyz_DelTotOptDep + 1.0d-100 )
   368: |W----->          do k = 1, kmax
   369: ||*---->            do j = 1, jmax
   370: |||*--->              do i = 0, imax-1
   371: ||||    A               if ( xyz_SSA(i,j,k) >= 1.0d0 ) then
   372: ||||    A                 xyz_SSA(i,j,k) = 1.0d0 - 1.0d-10
   373: ||||                    end if
   374: |||*---               end do
   375: ||*----             end do
   376: |W-----           end do
   377: |W**=== A         xyz_AF  =                                                               &
   378: |                   &   ( xyz_CloudWatAF    * xyz_CloudWatSSA   * xyz_DelCloudWatOptDep   &
   379: |                   &   + xyz_CloudIceAF    * xyz_CloudIceSSA   * xyz_DelCloudIceOptDep   &
   380: |                   &   + RayScatAsymFact   * RayScatSinScatAlb * xyz_RayScatDelOptDep    &
   381: |                   &   + 0.0d0             * 0.0d0             * xyz_O3AbsDelOptDep   )  &
   382: |                   & / ( xyz_SSA * xyz_DelTotOptDep + 1.0d-100 )
   383: |           
   384: |           
   385: |                 call RadRTETwoStreamAppSW(        &
   386: |                   & xyz_SSA, xyz_AF,              & ! (in)
   387: |                   & xyr_TotOptDep,                & ! (in)
   388: |                   & xy_SurfAlbedo,                & ! (in)
   389: |                   & SolarFluxTOA, xy_InAngle,     & ! (in)
   390: |                   & xyr_RadUwFlux, xyr_RadDwFlux  & ! (out)
   391: |                   & )
   392: |           
   393: |**W--->A         xyr_RadSUwFlux = xyr_RadSUwFlux + xyr_RadUwFlux
   394: |**W--- A         xyr_RadSDwFlux = xyr_RadSDwFlux + xyr_RadDwFlux
   395: |           
   396: +------         end do
   397:             
   398:             
   399:                 ! * 1000 to 14286 cm-1 (0.70-10 micron): 
   400:                 !   * absorption by H2O, 
   401:                 !   * scattering by cloud droplets.
   402:                 !
   403:             
   404:                 call RadCL1996ScaleH2OVapMass(              &
   405:                   & xyz_Temp, xyz_DelH2OVapMass, xyz_Press, & ! (in )
   406:                   & xyz_DelH2OVapMassScaled                 & ! (out)
   407:                   & )
   408:             
   409:             
   410:                 call RadCL1996IRH2ONumKDFBin( &
   411:                   & nkdf & ! (out)
   412:                   & )
   413:             
   414:             
   415:                 SolarFluxTOA = SolarConst / DistFromStarScld**2 * DiurnalMeanFactor
   416:             
   417: +------>        do l = nbands1+1, nbands1+nbands2
   418: |           
   419: |                 ! Water cloud optical properties
   420: |                 !
   421: |W**=== A         xyz_CloudREff = CloudWatREff
   422: |                 call RadC1998CalcCloudOptProp(                        &
   423: |                   & 'Liquid', l, xyz_CloudREff,                       & ! (in )
   424: |                   & xyz_CloudExtCoef, xyz_CloudCoAlb, xyz_CloudWatAF  & ! (out)
   425: |                   & )
   426: |**W--->A         xyz_DelCloudWatOptDep = xyz_CloudExtCoef * xyz_DelH2OLiqMass
   427: ||||    A         xyz_CloudWatSSA       = 1.0_DP - xyz_CloudCoAlb
   428: ||||        
   429: ||||              ! Ice cloud optical properties
   430: ||||              !
   431: |**W--- A         xyz_CloudREff = CloudIceREff
   432: |                 call RadC1998CalcCloudOptProp(                        &
   433: |                   & 'Ice', l, xyz_CloudREff,                          & ! (in )
   434: |                   & xyz_CloudExtCoef, xyz_CloudCoAlb, xyz_CloudIceAF  & ! (out)
   435: |                   & )
   436: |**W--->A         xyz_DelCloudIceOptDep = xyz_CloudExtCoef * xyz_DelH2OSolMass
   437: |**W--- A         xyz_CloudIceSSA       = 1.0_DP - xyz_CloudCoAlb
   438: |           
   439: |           
   440: |+----->          do ikdfbin = 1, nkdf
   441: ||          
   442: ||                  call RadCL1996IRH2OKDFParams(              &
   443: ||                    & l, ikdfbin,                            & ! (in )
   444: ||                    & KDFAbsCoef, KDFWeight                  & ! (out)
   445: ||                    & )
   446: ||          
   447: ||**W-->A           xyz_H2ODelOptDep = KDFAbsCoef * xyz_DelH2OVapMassScaled
   448: |||||       
   449: |||||       
   450: |||||               ! Total optical parameter
   451: |||||               !
   452: ||**W--             xyz_DelTotOptDep =          &
   453: ||                    &   xyz_DelCloudWatOptDep &
   454: ||                    & + xyz_DelCloudIceOptDep &
   455: ||                    & + xyz_H2ODelOptDep
   456: ||          
   457: ||W*=== A           xyr_TotOptDep(:,:,kmax) = 0.0d0
   458: ||+---->            do k = kmax-1, 0, -1
   459: |||W*== A             xyr_TotOptDep(:,:,k) = xyr_TotOptDep(:,:,k+1) + xyz_DelTotOptDep(:,:,k+1)
   460: ||+----             end do
   461: ||          
   462: ||W**== A           xyz_SSA =                                            &
   463: ||                    &   ( xyz_CloudWatSSA   * xyz_DelCloudWatOptDep    &
   464: ||                    &   + xyz_CloudIceSSA   * xyz_DelCloudIceOptDep    &
   465: ||                    &   + 0.0d0             * xyz_H2ODelOptDep      )  &
   466: ||                    & / ( xyz_DelTotOptDep + 1.0d-100 )
   467: ||W---->            do k = 1, kmax
   468: |||*--->              do j = 1, jmax
   469: ||||*-->                do i = 0, imax-1
   470: |||||   A                 if ( xyz_SSA(i,j,k) >= 1.0d0 ) then
   471: |||||   A                   xyz_SSA(i,j,k) = 1.0d0 - 1.0d-10
   472: |||||                     end if
   473: ||||*--                 end do
   474: |||*---               end do
   475: ||W----             end do
   476: ||W**== A           xyz_AF  =                                                               &
   477: ||                    &   ( xyz_CloudWatAF    * xyz_CloudWatSSA   * xyz_DelCloudWatOptDep   &
   478: ||                    &   + xyz_CloudIceAF    * xyz_CloudIceSSA   * xyz_DelCloudIceOptDep   &
   479: ||                    &   + 0.0d0             * 0.0d0             * xyz_H2ODelOptDep     )  &
   480: ||                    & / ( xyz_ssa * xyz_DelTotOptDep + 1.0d-100 )
   481: ||          
   482: ||          
   483: ||                  call RadRTETwoStreamAppSW(        &
   484: ||                    & xyz_SSA, xyz_AF,              & ! (in)
   485: ||                    & xyr_TotOptDep,                & ! (in)
   486: ||                    & xy_SurfAlbedo,                & ! (in)
   487: ||                    & SolarFluxTOA, xy_InAngle,     & ! (in)
   488: ||                    & xyr_RadUwFlux, xyr_RadDwFlux  & ! (out)
   489: ||                    & )
   490: ||          
   491: ||          
   492: ||**W-->A           xyr_RadUwFlux = xyr_RadUwFlux * KDFWeight
   493: |||||   A           xyr_RadDwFlux = xyr_RadDwFlux * KDFWeight
   494: |||||       
   495: |||||   A           xyr_RadSUwFlux = xyr_RadSUwFlux + xyr_RadUwFlux
   496: ||**W-- A           xyr_RadSDwFlux = xyr_RadSDwFlux + xyr_RadDwFlux
   497: ||          
   498: |+-----           end do
   499: |           
   500: +------         end do
   501:             
   502:             
   503:             
   504:             !!$    i = 0
   505:             !!$    j = jmax / 2 + 1
   506:             !!$    do k = 1, kmax
   507:             !!$      write( 73, * ) xyz_Temp(i,j,k), xyz_QH2OVap(i,j,k), &
   508:             !!$        & xyz_Press(i,j,k)
   509:             !!$    end do
   510:             !!$    call flush( 73 )
   511:             !!$
   512:             !!$    i = 0
   513:             !!$    j = jmax / 2 + 1
   514:             !!$    do k = 1, kmax
   515:             !!$      write( 83, * ) &
   516:             !!$        & + (     xyr_RadSFlux(i,j,k-1) - xyr_RadSFlux(i,j,k) )  &
   517:             !!$        &     / ( xyr_Press(i,j,k-1)    - xyr_Press(i,j,k) )     &
   518:             !!$        &     / 1004.6 * Grav, &
   519:             !!$        & xyz_Press(i,j,k)
   520:             !!$    end do
   521:             !!$    call flush( 83 )
   522:             !!$
   523:             !!$!    write( 6, * ) '########## ', acos( 1.0d0 / xy_InAngle(i,j) ) * 180.0d0 / 3.141592d0
   524:             !!$
   525:             !!$
   526:             !!$    i = 0
   527:             !!$    j = jmax / 2 + 1
   528:             !!$    write( 93, * ) '# ', xy_SurfAlbedo(i,j)
   529:             !!$    write( 93, * ) '# ', 1.0_DP / xy_InAngle(i,j)
   530:             !!$    do k = 0, kmax
   531:             !!$      write( 93, * ) xyr_RadSFlux(i,j,k), xyr_Press(i,j,k)
   532:             !!$    end do
   533:             !!$    call flush( 93 )
   534:             !!$    stop
   535:             
   536:             
   537:                 ! 計算時間計測一時停止
   538:                 ! Pause measurement of computation time
   539:                 !
   540:                 call TimesetClockStop( module_name )
   541:             
   542:             
   543:               end subroutine RadEarthSWV21Flux
   544:             
   545:               !--------------------------------------------------------------------------------------
   546:             
   547:               subroutine RadEarthSWV21Init
   548:             
   549:                 ! ファイル入出力補助
   550:                 ! File I/O support
   551:                 !
   552:                 use dc_iounit, only: FileOpen
   553:             
   554:                 ! NAMELIST ファイル入力に関するユーティリティ
   555:                 ! Utilities for NAMELIST file input
   556:                 !
   557:                 use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid
   558:             
   559:                 ! 太陽放射フラックスの設定
   560:                 ! Set solar constant
   561:                 !
   562:                 use set_solarconst, only : SetSolarConstInit
   563:             
   564:                 ! 短波入射 (太陽入射)
   565:                 ! Short wave (insolation) incoming
   566:                 !
   567:                 use rad_short_income, only : RadShortIncomeInit
   568:             
   569:                 !
   570:                 ! Solve radiative transfer equation in two stream approximation
   571:                 !
   572:                 use rad_rte_two_stream_app, only: RadRTETwoStreamAppInit
   573:             
   574:                 ! Chou and Lee (1996) による短波放射モデル
   575:                 ! Short wave radiation model described by Chou and Lee (1996)
   576:                 !
   577:                 use rad_CL1996, only : RadCL1996Init
   578:             
   579:                 ! Chou et al (1998) による短波放射用雲モデル
   580:                 ! Cloud model for short wave radiation model described by Chou et al (1998)
   581:                 !
   582:                 use rad_C1998, only : RadC1998Init
   583:             
   584:             
   585:                 ! 宣言文 ; Declaration statements
   586:                 !
   587:             
   588:                 integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号.
   589:                                           ! Unit number for NAMELIST file open
   590:                 integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT.
   591:                                           ! IOSTAT of NAMELIST read
   592:             
   593:                 ! NAMELIST 変数群
   594:                 ! NAMELIST group name
   595:                 !
   596:                 namelist /rad_Earth_SW_V2_1_nml/ &
   597:                   & FlagRayleighScattering, &
   598:                   & CloudWatREff, CloudIceREff
   599:                       !
   600:                       ! デフォルト値については初期化手続 "rad_Earth_SW_V2_1#RadEarthSWV21Init"
   601:                       ! のソースコードを参照のこと.
   602:                       !
   603:                       ! Refer to source codes in the initialization procedure
   604:                       ! "rad_Earth_SW_V2_1#RadEarthSWEV21Init" for the default values.
   605:                       !
   606:             
   607:                 if ( rad_Earth_SW_V2_1_inited ) return
   608:             
   609:             
   610:                 ! デフォルト値の設定
   611:                 ! Default values settings
   612:                 !
   613:                 FlagRayleighScattering = .true.
   614:             
   615:                 CloudWatREff           = 10.0d-6
   616:                 CloudIceREff           = 50.0d-6
   617:             
   618:                 ! NAMELIST の読み込み
   619:                 ! NAMELIST is input
   620:                 !
   621:                 if ( trim(namelist_filename) /= '' ) then
   622:                   call FileOpen( unit_nml, &          ! (out)
   623:                     & namelist_filename, mode = 'r' ) ! (in)
   624:             
   625:                   rewind( unit_nml )
   626:                   read( unit_nml,                          & ! (in)
   627:                     & nml = rad_Earth_SW_V2_1_nml,         & ! (out)
   628:                     & iostat = iostat_nml )                  ! (out)
   629:                   close( unit_nml )
   630:             
   631:                   call NmlutilMsg( iostat_nml, module_name ) ! (in)
   632:                 end if
   633:             
   634:             
   635:             
   636:                 ! Initialization of modules used in this module
   637:                 !
   638:             
   639:                 ! 太陽放射フラックスの設定
   640:                 ! Set solar constant
   641:                 !
   642:                 call SetSolarConstInit
   643:             
   644:                 ! 短波入射 (太陽入射)
   645:                 ! Short wave (insolation) incoming
   646:                 !
   647:                 call RadShortIncomeInit
   648:             
   649:                 !
   650:                 ! Solve radiative transfer equation in two stream approximation
   651:                 !
   652:                 call RadRTETwoStreamAppInit
   653:             
   654:                 ! Chou and Lee (1996) による短波放射モデル
   655:                 ! Short wave radiation model described by Chou and Lee (1996)
   656:                 !
   657:                 call RadCL1996Init
   658:             
   659:                 ! Chou et al (1998) による短波放射用雲モデル
   660:                 ! Cloud model for short wave radiation model described by Chou et al (1998)
   661:                 !
   662:                 call RadC1998Init
   663:             
   664:             
   665:                 ! 印字 ; Print
   666:                 !
   667:                 call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   668:                 call MessageNotify( 'M', module_name, 'FlagRayleighScattering = %b', l = (/ FlagRayleighScattering /) )
   669:                 call MessageNotify( 'M', module_name, 'CloudWatREff           = %f', &
   670:                   & d = (/ CloudWatREff /) )
   671:                 call MessageNotify( 'M', module_name, 'CloudIceREff           = %f', &
   672:                   & d = (/ CloudIceREff /) )
   673:                 call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   674:             
   675:             
   676:                 rad_Earth_SW_V2_1_inited = .true.
   677:             
   678:               end subroutine RadEarthSWV21Init
   679:             
   680:               !--------------------------------------------------------------------------------------
   681:             
   682:             end module rad_Earth_SW_V2_1
