Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:51 2016
FILE NAME: rad_Earth_SW_V2_6.f90
PROGRAM NAME: rad_earth_sw_v2_6
DIAGNOSTIC LIST

  LINE  LEVEL( NO.): DIAGNOSTIC MESSAGE

   302  opt  (  11): Fused array assignments. :line 302 - 303
   302  opt  (1593): Loop nest collapsed into one loop.
   302  vec  (   4): Vectorized array expression.
   302  vec  (  29): ADB is used for array.: xyr_radsdwflux
   302  vec  (  29): ADB is used for array.: xyr_radsuwflux
   315  opt  (1593): Loop nest collapsed into one loop.
   315  vec  (   4): Vectorized array expression.
   315  vec  (  29): ADB is used for array.: xyz_cloudreff
   315  vec  (  29): ADB is used for array.: xyz_cloudwatreff
   316  opt  (1017): Subroutine call prevents optimization.
   320  opt  (  11): Fused array assignments. :line 320 - 325
   320  opt  (1593): Loop nest collapsed into one loop.
   320  vec  (   4): Vectorized array expression.
   320  vec  (  29): ADB is used for array.: xyz_cloudreff
   320  vec  (  29): ADB is used for array.: xyz_cloudicereff
   320  vec  (  29): ADB is used for array.: xyz_cloudcoalb
   320  vec  (  29): ADB is used for array.: xyz_delcloudwatoptdep
   320  vec  (  29): ADB is used for array.: xyz_delh2oliqmass
   320  vec  (  29): ADB is used for array.: xyz_cloudextcoef
   330  opt  (  11): Fused array assignments. :line 330 - 331
   330  opt  (1593): Loop nest collapsed into one loop.
   330  vec  (   4): Vectorized array expression.
   330  vec  (  29): ADB is used for array.: xyz_cloudcoalb
   330  vec  (  29): ADB is used for array.: xyz_delcloudiceoptdep
   330  vec  (  29): ADB is used for array.: xyz_delh2osolmass
   330  vec  (  29): ADB is used for array.: xyz_cloudextcoef
   360  opt  (1592): Outer loop unrolled inside inner loop.
   360  vec  (   4): Vectorized array expression.
   360  vec  (  29): ADB is used for array.: xyz_delatmmass
   360  vec  (   4): Vectorized array expression.
   360  vec  (  29): ADB is used for array.: xyz_delatmmass
   362  opt  (1593): Loop nest collapsed into one loop.
   362  vec  (   4): Vectorized array expression.
   368  opt  (  11): Fused array assignments. :line 368 - 373
   368  opt  (1593): Loop nest collapsed into one loop.
   368  vec  (   4): Vectorized array expression.
   368  vec  (  29): ADB is used for array.: xyz_delcloudiceoptdep
   368  vec  (  29): ADB is used for array.: xyz_delcloudwatoptdep
   368  vec  (  29): ADB is used for array.: xyz_delo3mass
   379  opt  (1593): Loop nest collapsed into one loop.
   379  vec  (   4): Vectorized array expression.
   379  vec  (  29): ADB is used for array.: xyr_totoptdep
   380  vec  (   3): Unvectorized loop.
   380  vec  (  13): Overhead of loop division is too large.
   381  opt  (1037): Feedback of array elements.
   381  opt  (1593): Loop nest collapsed into one loop.
   381  vec  (   4): Vectorized array expression.
   381  vec  (  29): ADB is used for array.: xyr_totoptdep
   384  opt  (1593): Loop nest collapsed into one loop.
   384  vec  (   4): Vectorized array expression.
   384  vec  (  29): ADB is used for array.: xyz_ssa
   384  vec  (  29): ADB is used for array.: xyz_delcloudiceoptdep
   384  vec  (  29): ADB is used for array.: xyz_delcloudwatoptdep
   390  opt  (1593): Loop nest collapsed into one loop.
   390  vec  (   1): Vectorized loop.
   390  vec  (  29): ADB is used for array.: xyz_ssa
   399  opt  (1593): Loop nest collapsed into one loop.
   399  vec  (   4): Vectorized array expression.
   399  vec  (  29): ADB is used for array.: xyz_af
   399  vec  (  29): ADB is used for array.: xyz_ssa
   399  vec  (  29): ADB is used for array.: xyz_delcloudiceoptdep
   399  vec  (  29): ADB is used for array.: xyz_cloudiceaf
   399  vec  (  29): ADB is used for array.: xyz_delcloudwatoptdep
   399  vec  (  29): ADB is used for array.: xyz_cloudwataf
   415  opt  (  11): Fused array assignments. :line 415 - 416
   415  opt  (1593): Loop nest collapsed into one loop.
   415  vec  (   4): Vectorized array expression.
   415  vec  (  29): ADB is used for array.: xyr_radsdwflux
   415  vec  (  29): ADB is used for array.: xyr_raddwflux
   415  vec  (  29): ADB is used for array.: xyr_radsuwflux
   415  vec  (  29): ADB is used for array.: xyr_raduwflux
   443  opt  (1593): Loop nest collapsed into one loop.
   443  vec  (   4): Vectorized array expression.
   443  vec  (  29): ADB is used for array.: xyz_cloudreff
   443  vec  (  29): ADB is used for array.: xyz_cloudwatreff
   448  opt  (  11): Fused array assignments. :line 448 - 453
   448  opt  (1593): Loop nest collapsed into one loop.
   448  vec  (   4): Vectorized array expression.
   448  vec  (  29): ADB is used for array.: xyz_cloudreff
   448  vec  (  29): ADB is used for array.: xyz_cloudicereff
   448  vec  (  29): ADB is used for array.: xyz_cloudcoalb
   448  vec  (  29): ADB is used for array.: xyz_delcloudwatoptdep
   448  vec  (  29): ADB is used for array.: xyz_delh2oliqmass
   448  vec  (  29): ADB is used for array.: xyz_cloudextcoef
   458  opt  (  11): Fused array assignments. :line 458 - 459
   458  opt  (1593): Loop nest collapsed into one loop.
   458  vec  (   4): Vectorized array expression.
   458  vec  (  29): ADB is used for array.: xyz_cloudcoalb
   458  vec  (  29): ADB is used for array.: xyz_delcloudiceoptdep
   458  vec  (  29): ADB is used for array.: xyz_delh2osolmass
   458  vec  (  29): ADB is used for array.: xyz_cloudextcoef
   476  opt  (1017): Subroutine call prevents optimization.
   481  opt  (  11): Fused array assignments. :line 481 - 486
   481  opt  (1593): Loop nest collapsed into one loop.
   481  vec  (   4): Vectorized array expression.
   481  vec  (  29): ADB is used for array.: xyz_delcloudiceoptdep
   481  vec  (  29): ADB is used for array.: xyz_delcloudwatoptdep
   481  vec  (  29): ADB is used for array.: xyz_delh2ovapmassscaled
   491  opt  (1593): Loop nest collapsed into one loop.
   491  vec  (   4): Vectorized array expression.
   491  vec  (  29): ADB is used for array.: xyr_totoptdep
   492  vec  (   3): Unvectorized loop.
   492  vec  (  13): Overhead of loop division is too large.
   493  opt  (1037): Feedback of array elements.
   493  opt  (1593): Loop nest collapsed into one loop.
   493  vec  (   4): Vectorized array expression.
   493  vec  (  29): ADB is used for array.: xyr_totoptdep
   496  opt  (1593): Loop nest collapsed into one loop.
   496  vec  (   4): Vectorized array expression.
   496  vec  (  29): ADB is used for array.: xyz_ssa
   496  vec  (  29): ADB is used for array.: xyz_delcloudiceoptdep
   496  vec  (  29): ADB is used for array.: xyz_delcloudwatoptdep
   501  opt  (1593): Loop nest collapsed into one loop.
   501  vec  (   1): Vectorized loop.
   501  vec  (  29): ADB is used for array.: xyz_ssa
   510  opt  (1593): Loop nest collapsed into one loop.
   510  vec  (   4): Vectorized array expression.
   510  vec  (  29): ADB is used for array.: xyz_af
   510  vec  (  29): ADB is used for array.: xyz_ssa
   510  vec  (  29): ADB is used for array.: xyz_delcloudiceoptdep
   510  vec  (  29): ADB is used for array.: xyz_cloudiceaf
   510  vec  (  29): ADB is used for array.: xyz_delcloudwatoptdep
   510  vec  (  29): ADB is used for array.: xyz_cloudwataf
   526  opt  (  11): Fused array assignments. :line 526 - 530
   526  opt  (1593): Loop nest collapsed into one loop.
   526  vec  (   4): Vectorized array expression.
   526  vec  (  29): ADB is used for array.: xyr_radsdwflux
   526  vec  (  29): ADB is used for array.: xyr_radsuwflux
   526  vec  (  29): ADB is used for array.: xyr_raddwflux
   526  vec  (  29): ADB is used for array.: xyr_raduwflux
   577  warn (  82): Name "xyr_radflux" is not used.
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:51 2016
FILE NAME: rad_Earth_SW_V2_6.f90
PROGRAM NAME: rad_earth_sw_v2_6
TRANSFORMATION LIST

  LINE                   FORTRAN STATEMENT

     1  != 地球大気向け短波放射モデル Ver. 2.6
     2  !
     3  != short wave radiation model for the Earth's atmosphere Ver. 2.6
     4  !
     5  ! Authors::   Yoshiyuki O. Takahashi
     6  ! Version::   $Id: rad_Earth_SW_V2_6.f90,v 1.1 2015/01/29 12:16:19 yot Exp $
     7  ! Tag Name::  $Name:  $
     8  ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9  ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10  !
    11  module rad_Earth_SW_V2_6
    12  
    13    !
    14    != 地球大気向け短波放射モデル Ver. 2.6
    15    !
    16    != short wave radiation model for the Earth's atmosphere Ver. 2.6
    17    !
    18    ! <b>Note that Japanese and English are described in parallel.</b>
    19    !
    20    ! 地球大気向け短波放射モデル.
    21    !
    22    ! This is a short wave radiation model for the Earth's atmospehre.
    23    !
    24    ! This module is a simple extention of Ver. 2.1. A difference between
    25    ! this version (Ver. 2.6) and Ver. 2.1 is inclusion of effect of cloud
    26    ! fraction less than 1.
    27    !
    28    ! The wavenumber range of shortwave radiation treated by this routine is
    29    ! from 1000 to 57143 cm-1 (0.175 to 10 micron).
    30    !
    31    ! From 1000 to 57143 cm-1, the following effects are considered.
    32    ! * 1000 to 14286 cm-1 (0.70-10 micron):
    33    !   * absorption by H2O,
    34    !     * absorption by H2O is considered by using k-distribution method
    35    !       following Chou and Lee (1996),
    36    !   * absorption and scattering by cloud droplets.
    37    !     * optical properties of cloud is obtained from Chou et al. (1998)
    38    ! * 14286 to 57143 cm-1 (0.175 to 0.70 micron):
    39    !   * Rayleigh scattering,
    40    !     * scattering coefficient is obtained from Chou and Lee (1996),
    41    !   * scattering by cloud droplets.
    42    !     * optical properties of cloud is obtained from Chou et al. (1998)
    43    !
    44    !
    45    !== References
    46    !
    47    !  Chou, M.-D., and K.-T. Lee,
    48    !    Parameterizations for the absorption of solar radiation by water vapor and ozone,
    49    !    J. Atmos. Sci., 53, 1203-1208, 1996.
    50    !
    51    !  Chou, M.-D., M. J. Suarez, C.-H. Ho, M. M.-H. Yan, and K.-T. Lee,
    52    !    Parameterizations for cloud overlapping and shortwave single-scattering
    53    !    properties for use in general circulation and cloud ensemble models,
    54    !    J. Climate, 11, 202-214, 1998.
    55    !
    56    !== Procedures List
    57    !
    58    ! RadEarthSWV26Flux   :: 放射フラックスの計算
    59    ! ------------        :: ------------
    60    ! RadEarthSWV26Flux   :: Calculate radiation flux
    61    !
    62    !== NAMELIST
    63    !
    64    ! NAMELIST#rad_Earth_SW_V2_6_nml
    65    !
    66  
    67    ! USE statements
    68    !
    69  
    70    !
    71    ! Kind type parameter
    72    !
    73    use dc_types, only: DP, &      ! Double precision.
    74      &                 STRING, &  ! Strings.
    75      &                 TOKEN      ! Keywords.
    76  
    77    ! メッセージ出力
    78    ! Message output
    79    !
    80    use dc_message, only: MessageNotify
    81  
    82  
    83    ! 格子点設定
    84    ! Grid points settings
    85    !
    86    use gridset, only: imax, & ! 経度格子点数.
    87                               ! Number of grid points in longitude
    88      &                jmax, & ! 緯度格子点数.
    89                               ! Number of grid points in latitude
    90      &                kmax    ! 鉛直層数.
    91                               ! Number of vertical level
    92  
    93    ! 時刻管理
    94    ! Time control
    95    !
    96    use timeset, only: &
    97      & TimesetClockStart, TimesetClockStop
    98  
    99    implicit none
   100  
   101    private
   102  
   103    logical , save      :: FlagRayleighScattering
   104  
   105  
   106    ! 公開変数
   107    ! Public variables
   108    !
   109    logical, save :: rad_Earth_SW_V2_6_inited = .false.
   110                                ! 初期設定フラグ.
   111                                ! Initialization flag
   112  
   113    public :: RadEarthSWV26Flux
   114    public :: RadEarthSWV26Init
   115  
   116    character(*), parameter:: module_name = 'rad_Earth_SW_V2_6'
   117                                ! モジュールの名称.
   118                                ! Module name
   119    character(*), parameter:: version = &
   120      & '$Name:  $' // &
   121      & '$Id: rad_Earth_SW_V2_6.f90,v 1.1 2015/01/29 12:16:19 yot Exp $'
   122                                ! モジュールのバージョン
   123                                ! Module version
   124  
   125    !--------------------------------------------------------------------------------------
   126  
   127  contains
   128  
   129    !--------------------------------------------------------------------------------------
   130  
   131    subroutine RadEarthSWV26Flux(                                &
   132      & xy_SurfAlbedo,                                           &
   133      & xyz_DelAtmMass,                                          &
   134      & xyz_DelH2OVapMass, xyz_DelH2OLiqMass, xyz_DelH2OSolMass, &
   135      & xyz_DelO3Mass,                                           &
   136      & xyz_Press, xyz_Temp,                                     &
   137      & xyz_CloudCover,                                          &
   138      & xyz_CloudWatREff, xyz_CloudIceREff,                      &
   139      & xyr_RadSUwFlux, xyr_RadSDwFlux                           &
   140      & )
   141  
   142      ! USE statements
   143      !
   144  
   145      ! 太陽放射フラックスの設定
   146      ! Set solar constant
   147      !
   148      use set_solarconst, only : SetSolarConst
   149  
   150      ! 短波入射 (太陽入射)
   151      ! Short wave (insolation) incoming
   152      !
   153      use rad_short_income, only : RadShortIncome
   154  
   155      !
   156      ! Solve radiative transfer equation in two stream approximation
   157      !
   158      use rad_rte_two_stream_app, only: RadRTETwoStreamAppSW
   159  
   160      ! Chou and Lee (1996) による短波放射モデル
   161      ! Short wave radiation model described by Chou and Lee (1996)
   162      !
   163      use rad_CL1996, only :       &
   164        & RadCL1996NumBands      , &
   165        & RadCL1996UVVISParams   , &
   166        & RadCL1996IRH2ONumKDFBin, &
   167        & RadCL1996IRH2OKDFParams, &
   168        & RadCL1996ScaleH2OVapMass
   169  
   170  
   171      ! Chou et al (1998) による短波放射用雲モデル
   172      ! Cloud model for short wave radiation model described by Chou et al (1998)
   173      !
   174      use rad_C1998, only : RadC1998CalcCloudOptProp
   175  
   176      ! 雲関系ルーチン
   177      ! Cloud-related routines
   178      !
   179      use cloud_utils, only : CloudUtilsSmearCloudOptDep
   180  
   181  
   182      real(DP), intent(in ) :: xy_SurfAlbedo    (0:imax-1, 1:jmax )
   183      real(DP), intent(in ) :: xyz_DelAtmMass   (0:imax-1, 1:jmax, 1:kmax)
   184      real(DP), intent(in ) :: xyz_DelH2OVapMass(0:imax-1, 1:jmax, 1:kmax)
   185      real(DP), intent(in ) :: xyz_DelH2OLiqMass(0:imax-1, 1:jmax, 1:kmax)
   186      real(DP), intent(in ) :: xyz_DelH2OSolMass(0:imax-1, 1:jmax, 1:kmax)
   187      real(DP), intent(in ) :: xyz_DelO3Mass    (0:imax-1, 1:jmax, 1:kmax)
   188      real(DP), intent(in ) :: xyz_Press        (0:imax-1, 1:jmax, 1:kmax)
   189      real(DP), intent(in ) :: xyz_Temp         (0:imax-1, 1:jmax, 1:kmax)
   190      real(DP), intent(in ) :: xyz_CloudCover   (0:imax-1, 1:jmax, 1:kmax)
   191      real(DP), intent(in ) :: xyz_CloudWatREff (0:imax-1, 1:jmax, 1:kmax)
   192      real(DP), intent(in ) :: xyz_CloudIceREff (0:imax-1, 1:jmax, 1:kmax)
   193      real(DP), intent(out) :: xyr_RadSUwFlux   (0:imax-1, 1:jmax, 0:kmax)
   194      real(DP), intent(out) :: xyr_RadSDwFlux   (0:imax-1, 1:jmax, 0:kmax)
   195  
   196  
   197      real(DP) :: SolarConst
   198  
   199      real(DP) :: xy_InAngle    (0:imax-1, 1:jmax)
   200                                ! sec (入射角).
   201                                ! sec (angle of incidence)
   202      real(DP) :: DistFromStarScld
   203                                 ! Distance between the central star and the planet
   204      real(DP) :: DiurnalMeanFactor
   205  
   206  
   207      integer  :: nbands1
   208      integer  :: nbands2
   209  
   210      real(DP) :: UVVISFracSolarFlux
   211      real(DP) :: UVVISO3AbsCoef
   212      real(DP) :: UVVISRayScatCoef
   213  
   214      real(DP) :: SolarFluxTOA
   215  
   216  
   217  
   218      real(DP) :: xyz_SSA       (0:imax-1, 1:jmax, 1:kmax)
   219      real(DP) :: xyz_AF        (0:imax-1, 1:jmax, 1:kmax)
   220  
   221  
   222      real(DP), parameter :: RayScatSinScatAlb = 1.0d0 - 1.0d-10
   223      real(DP), parameter :: RayScatAsymFact   = 0.0d0
   224  
   225      real(DP)            :: xyz_DelH2OVapMassScaled( 0:imax-1, 1:jmax, 1:kmax )
   226  
   227      real(DP)            :: xyz_DelCloudWatOptDep( 0:imax-1, 1:jmax, 1:kmax )
   228      real(DP)            :: xyz_DelCloudIceOptDep( 0:imax-1, 1:jmax, 1:kmax )
   229  
   230      real(DP)            :: xyz_RayScatDelOptDep( 0:imax-1, 1:jmax, 1:kmax )
   231  
   232      real(DP)            :: xyz_O3AbsDelOptDep  ( 0:imax-1, 1:jmax, 1:kmax )
   233  
   234      real(DP)            :: xyz_DelTotOptDep( 0:imax-1, 1:jmax, 1:kmax )
   235      real(DP)            :: xyr_TotOptDep   ( 0:imax-1, 1:jmax, 0:kmax )
   236      real(DP)            :: xyr_RadFlux     ( 0:imax-1, 1:jmax, 0:kmax )
   237      real(DP)            :: xyr_RadUwFlux   ( 0:imax-1, 1:jmax, 0:kmax )
   238      real(DP)            :: xyr_RadDwFlux   ( 0:imax-1, 1:jmax, 0:kmax )
   239  
   240      integer  :: nkdf
   241  
   242      integer  :: ikdfbin
   243      real(DP) :: KDFAbsCoef
   244      real(DP) :: KDFWeight
   245      real(DP) :: xyz_H2ODelOptDep( 0:imax-1, 1:jmax, 1:kmax )
   246  
   247  
   248      real(DP) :: xyz_CloudREff   (0:imax-1, 1:jmax, 1:kmax)
   249      real(DP) :: xyz_CloudExtCoef(0:imax-1, 1:jmax, 1:kmax)
   250      real(DP) :: xyz_CloudCoAlb  (0:imax-1, 1:jmax, 1:kmax)
   251      real(DP) :: xyz_CloudWatSSA (0:imax-1, 1:jmax, 1:kmax)
   252      real(DP) :: xyz_CloudWatAF  (0:imax-1, 1:jmax, 1:kmax)
   253      real(DP) :: xyz_CloudIceSSA (0:imax-1, 1:jmax, 1:kmax)
   254      real(DP) :: xyz_CloudIceAF  (0:imax-1, 1:jmax, 1:kmax)
   255  
   256  
   257  
   258      integer  :: i
   259      integer  :: j
   260      integer  :: k
   261      integer  :: l
   262  
   263  
   264      ! 初期化確認
   265      ! Initialization check
   266      !
   267      if ( .not. rad_Earth_SW_V2_6_inited ) then
   268        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   269      end if
   270  
   271  
   272      ! 計算時間計測開始
   273      ! Start measurement of computation time
   274      !
   275      call TimesetClockStart( module_name )
   276  
   277  
   278      ! 太陽放射フラックスの設定
   279      ! Set solar constant
   280      !
   281      call SetSolarConst( &
   282        & SolarConst      & ! (out)
   283        & )
   284  
   285      ! 短波入射の計算
   286      ! Calculate short wave (insolation) incoming radiation
   287      !
   288      call RadShortIncome(                       &
   289        & xy_InAngle        = xy_InAngle,        & ! (out) optional
   290        & DistFromStarScld  = DistFromStarScld,  & ! (out) optional
   291        & DiurnalMeanFactor = DiurnalMeanFactor  &
   292        & )
   293  
   294  
   295      call RadCL1996NumBands(   &
   296        & nbands1, nbands2      & ! (out)
   297        & )
   298  
   299  
   300      ! Initialization
   301      !
   302      xyr_RadSUwFlux = 0.0_DP
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t897 = 1, jmax*(kmax*imax + imax)                              
     .           xyr_radsuwflux(t897-1,1,0) = 0.0000000000000000e+000           
     .           xyr_radsdwflux(t897-1,1,0) = 0.0000000000000000e+000           
     .        enddo                                                             
   303      xyr_RadSDwFlux = 0.0_DP
   304  
   305  
   306      ! * 14286 to 57143 cm-1 (0.175 to 0.70 micron):
   307      !   * Rayleigh scattering,
   308      !   * scattering by cloud droplets.
   309      !   * O3 absorption
   310      !
   311      do l = 1, nbands1
   312  
   313        ! Water cloud optical properties
   314        !
   315        xyz_CloudREff = xyz_CloudWatREff
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t909 = 1, xyz_cloudreff.DSC.U3*(xyz_cloudreff.DSC.U2*          
     .       1   xyz_cloudreff.DSC.U1 + xyz_cloudreff.DSC.U2)                   
     .           xyz_cloudreff(t909-1,1,1) = xyz_cloudwatreff(t909-1,1,1)       
     .        enddo                                                             
   316        call RadC1998CalcCloudOptProp(                        &
   317          & 'Liquid', l, xyz_CloudREff,                       & ! (in )
   318          & xyz_CloudExtCoef, xyz_CloudCoAlb, xyz_CloudWatAF  & ! (out)
   319          & )
   320        xyz_DelCloudWatOptDep = xyz_CloudExtCoef * xyz_DelH2OLiqMass
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t921 = 1, xyz_cloudextcoef.DSC.U3*(xyz_cloudextcoef.DSC.U2*    
     .       1   xyz_cloudextcoef.DSC.U1 + xyz_cloudextcoef.DSC.U2)             
     .           xyz_delcloudwatoptdep(t921-1,1,1) = xyz_cloudextcoef(t921-1,1,1
     .       1      )*xyz_delh2oliqmass(t921-1,1,1)                             
     .           xyz_cloudwatssa(t921-1,1,1) = 1.00000000000000e+000 -          
     .       1      xyz_cloudcoalb(t921-1,1,1)                                  
     .           xyz_cloudreff(t921-1,1,1) = xyz_cloudicereff(t921-1,1,1)       
     .        enddo                                                             
   321        xyz_CloudWatSSA       = 1.0_DP - xyz_CloudCoAlb
   322  
   323        ! Ice cloud optical properties
   324        !
   325        xyz_CloudREff = xyz_CloudIceREff
   326        call RadC1998CalcCloudOptProp(                        &
   327          & 'Ice', l, xyz_CloudREff,                          & ! (in )
   328          & xyz_CloudExtCoef, xyz_CloudCoAlb, xyz_CloudIceAF  & ! (out)
   329          & )
   330        xyz_DelCloudIceOptDep = xyz_CloudExtCoef * xyz_DelH2OSolMass
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t948 = 1, xyz_cloudextcoef.DSC.U3*(xyz_cloudextcoef.DSC.U2*    
     .       1   xyz_cloudextcoef.DSC.U1 + xyz_cloudextcoef.DSC.U2)             
     .           xyz_delcloudiceoptdep(t948-1,1,1) = xyz_cloudextcoef(t948-1,1,1
     .       1      )*xyz_delh2osolmass(t948-1,1,1)                             
     .           xyz_cloudicessa(t948-1,1,1) = 1.00000000000000e+000 -          
     .       1      xyz_cloudcoalb(t948-1,1,1)                                  
     .        enddo                                                             
   331        xyz_CloudIceSSA       = 1.0_DP - xyz_CloudCoAlb
   332  
   333  
   334        ! Smearing cloud
   335        !
   336        call CloudUtilsSmearCloudOptDep(  &
   337          & xyz_CloudCover,               & ! (in   )
   338          & xyz_DelCloudWatOptDep         & ! (inout)
   339          & )
   340        call CloudUtilsSmearCloudOptDep(  &
   341          & xyz_CloudCover,               & ! (in   )
   342          & xyz_DelCloudIceOptDep         & ! (inout)
   343          & )
   344  
   345  
   346  
   347        ! UV and Visible optical properties and solar flux
   348        !
   349        call RadCL1996UVVISParams(                                &
   350          & l,                                                    & ! (in )
   351          & UVVISFracSolarFlux, UVVISO3AbsCoef, UVVISRayScatCoef  & ! (out)
   352          & )
   353  
   354        SolarFluxTOA = UVVISFracSolarFlux * SolarConst / DistFromStarScld**2 * DiurnalMeanFactor
   355  
   356  
   357        ! Rayleigh scattering
   358        !
   359        if ( FlagRayleighScattering ) then
   360          xyz_RayScatDelOptDep = UVVISRayScatCoef * xyz_DelAtmMass
     .        if (1 + jmax - min0(1,jmax) .gt. 0) then                          
     .           j1 = and(1 + jmax - min0(1,jmax),3)                            
     .  !cdir    nodep                                                          
     .           do t1315 = 1, j1                                               
     .  !cdir       nodep                                                       
     .              do t1317 = 1, 1 + imax - min0(1,imax)                       
     .                 xyz_rayscatdeloptdep(t1317-1,t1315,t1313+1) =            
     .       1            uvvisrayscatcoef*xyz_delatmmass(t1317-1,t1315,t1313+1)
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t1315 = j1 + 1, 1 + jmax - min0(1,jmax), 4                  
     .  !cdir       nodep                                                       
     .              do t1317 = 1, 1 + imax - min0(1,imax)                       
     .                 xyz_rayscatdeloptdep(t1317-1,t1315,t1313+1) =            
     .       1            uvvisrayscatcoef*xyz_delatmmass(t1317-1,t1315,t1313+1)
     .                 xyz_rayscatdeloptdep(t1317-1,t1315+1,t1313+1) =          
     .       1            uvvisrayscatcoef*xyz_delatmmass(t1317-1,t1315+1,t1313+
     .       2            1)                                                    
     .                 xyz_rayscatdeloptdep(t1317-1,t1315+2,t1313+1) =          
     .       1            uvvisrayscatcoef*xyz_delatmmass(t1317-1,t1315+2,t1313+
     .       2            1)                                                    
     .                 xyz_rayscatdeloptdep(t1317-1,t1315+3,t1313+1) =          
     .       1            uvvisrayscatcoef*xyz_delatmmass(t1317-1,t1315+3,t1313+
     .       2            1)                                                    
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
   361        else
   362          xyz_RayScatDelOptDep = 0.0d0
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t969 = 1, xyz_rayscatdeloptdep.DSC.U3*(                        
     .       1   xyz_rayscatdeloptdep.DSC.U2*xyz_rayscatdeloptdep.DSC.U1 +      
     .       2   xyz_rayscatdeloptdep.DSC.U2)                                   
     .           xyz_rayscatdeloptdep(t969-1,1,1) = 0.0000000000000000e+000     
     .        enddo                                                             
   363        end if
   364  
   365  
   366        ! O3 absorption
   367        !
   368        xyz_O3AbsDelOptDep = UVVISO3AbsCoef * xyz_DelO3Mass
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t978 = 1, kmax*jmax*imax                                       
     .           xyz_o3absdeloptdep(t978-1,1,1) = uvviso3abscoef*xyz_delo3mass( 
     .       1      t978-1,1,1)                                                 
     .           xyz_deltotoptdep(t978-1,1,1) = xyz_delcloudwatoptdep(t978-1,1,1
     .       1      ) + xyz_delcloudiceoptdep(t978-1,1,1) + xyz_rayscatdeloptdep
     .       2      (t978-1,1,1) + xyz_o3absdeloptdep(t978-1,1,1)               
     .        enddo                                                             
   369  
   370  
   371        ! Total optical parameter
   372        !
   373        xyz_DelTotOptDep =            &
   374          &   xyz_DelCloudWatOptDep   &
   375          & + xyz_DelCloudIceOptDep   &
   376          & + xyz_RayScatDelOptDep    &
   377          & + xyz_O3AbsDelOptDep
   378        !
   379        xyr_TotOptDep(:,:,kmax) = 0.0d0
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1005 = 1, xyr_totoptdep.DSC.U2*xyr_totoptdep.DSC.U1 +         
     .       1   xyr_totoptdep.DSC.U2                                           
     .           xyr_totoptdep(t1005-1,1,kmax) = 0.0000000000000000e+000        
     .        enddo                                                             
   380        do k = kmax-1, 0, -1
   381          xyr_TotOptDep(:,:,k) = xyr_TotOptDep(:,:,k+1) + xyz_DelTotOptDep(:,:,k+1)
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xyr_totoptdep)                                             
     .        do t1011 = 1, xyr_totoptdep.DSC.U2*xyr_totoptdep.DSC.U1 +         
     .       1   xyr_totoptdep.DSC.U2                                           
     .           xyr_totoptdep(t1011-1,1,k) = xyr_totoptdep(t1011-1,1,k+1) +    
     .       1      xyz_deltotoptdep(t1011-1,1,k+1)                             
     .        enddo                                                             
   382        end do
   383        !
   384        xyz_SSA =                                           &
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1021 = 1, xyz_cloudwatssa.DSC.U3*(xyz_cloudwatssa.DSC.U2*     
     .       1   xyz_cloudwatssa.DSC.U1 + xyz_cloudwatssa.DSC.U2)               
     .           xyz_ssa(t1021-1,1,1) = (xyz_cloudwatssa(t1021-1,1,1)*          
     .       1      xyz_delcloudwatoptdep(t1021-1,1,1)+xyz_cloudicessa(t1021-1,1
     .       2      ,1)*xyz_delcloudiceoptdep(t1021-1,1,1)+9.99999999899999e-001
     .       3      *xyz_rayscatdeloptdep(t1021-1,1,1)+0.0000000000000000e+000* 
     .       4      xyz_o3absdeloptdep(t1021-1,1,1))/(xyz_deltotoptdep(t1021-1,1
     .       5      ,1)+1.00000000000000e-100)                                  
     .        enddo                                                             
   385          &   ( xyz_CloudWatSSA   * xyz_DelCloudWatOptDep   &
   386          &   + xyz_CloudIceSSA   * xyz_DelCloudIceOptDep   &
   387          &   + RayScatSinScatAlb * xyz_RayScatDelOptDep    &
   388          &   + 0.0d0             * xyz_O3AbsDelOptDep   )  &
   389          & / ( xyz_DelTotOptDep + 1.0d-100 )
   390        do k = 1, kmax
   391          do j = 1, jmax
   392            do i = 0, imax-1
   393              if ( xyz_SSA(i,j,k) >= 1.0d0 ) then
   394                xyz_SSA(i,j,k) = 1.0d0 - 1.0d-10
   395              end if
   396            end do
   397          end do
   398        end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do k = 1, kmax*jmax*imax                                          
     .           if (xyz_ssa(k-1,1,1) .ge. 1.00000000000000e+000) then          
     .              xyz_ssa(k-1,1,1) = 9.99999999899999e-001                    
     .           endif                                                          
     .        enddo                                                             
   399        xyz_AF  =                                                               &
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1051 = 1, xyz_cloudwataf.DSC.U3*(xyz_cloudwataf.DSC.U2*       
     .       1   xyz_cloudwataf.DSC.U1 + xyz_cloudwataf.DSC.U2)                 
     .           xyz_af(t1051-1,1,1) = (xyz_cloudwataf(t1051-1,1,1)*            
     .       1      xyz_cloudwatssa(t1051-1,1,1)*xyz_delcloudwatoptdep(t1051-1,1
     .       2      ,1)+xyz_cloudiceaf(t1051-1,1,1)*xyz_cloudicessa(t1051-1,1,1)
     .       3      *xyz_delcloudiceoptdep(t1051-1,1,1)+0.0000000000000000e+000*
     .       4      xyz_rayscatdeloptdep(t1051-1,1,1)+0.0000000000000000e+000*  
     .       5      xyz_o3absdeloptdep(t1051-1,1,1))/(xyz_ssa(t1051-1,1,1)*     
     .       6      xyz_deltotoptdep(t1051-1,1,1)+1.00000000000000e-100)        
     .        enddo                                                             
   400          &   ( xyz_CloudWatAF    * xyz_CloudWatSSA   * xyz_DelCloudWatOptDep   &
   401          &   + xyz_CloudIceAF    * xyz_CloudIceSSA   * xyz_DelCloudIceOptDep   &
   402          &   + RayScatAsymFact   * RayScatSinScatAlb * xyz_RayScatDelOptDep    &
   403          &   + 0.0d0             * 0.0d0             * xyz_O3AbsDelOptDep   )  &
   404          & / ( xyz_SSA * xyz_DelTotOptDep + 1.0d-100 )
   405  
   406  
   407        call RadRTETwoStreamAppSW(        &
   408          & xyz_SSA, xyz_AF,              & ! (in)
   409          & xyr_TotOptDep,                & ! (in)
   410          & xy_SurfAlbedo,                & ! (in)
   411          & SolarFluxTOA, xy_InAngle,     & ! (in)
   412          & xyr_RadUwFlux, xyr_RadDwFlux  & ! (out)
   413          & )
   414  
   415        xyr_RadSUwFlux = xyr_RadSUwFlux + xyr_RadUwFlux
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1090 = 1, jmax*(kmax*imax + imax)                             
     .           xyr_radsuwflux(t1090-1,1,0) = xyr_radsuwflux(t1090-1,1,0) +    
     .       1      xyr_raduwflux(t1090-1,1,0)                                  
     .           xyr_radsdwflux(t1090-1,1,0) = xyr_radsdwflux(t1090-1,1,0) +    
     .       1      xyr_raddwflux(t1090-1,1,0)                                  
     .        enddo                                                             
   416        xyr_RadSDwFlux = xyr_RadSDwFlux + xyr_RadDwFlux
   417  
   418      end do
   419  
   420  
   421      ! * 1000 to 14286 cm-1 (0.70-10 micron):
   422      !   * absorption by H2O,
   423      !   * scattering by cloud droplets.
   424      !
   425  
   426      call RadCL1996ScaleH2OVapMass(              &
   427        & xyz_Temp, xyz_DelH2OVapMass, xyz_Press, & ! (in )
   428        & xyz_DelH2OVapMassScaled                 & ! (out)
   429        & )
   430  
   431  
   432      call RadCL1996IRH2ONumKDFBin( &
   433        & nkdf & ! (out)
   434        & )
   435  
   436  
   437      SolarFluxTOA = SolarConst / DistFromStarScld**2 * DiurnalMeanFactor
   438  
   439      do l = nbands1+1, nbands1+nbands2
   440  
   441        ! Water cloud optical properties
   442        !
   443        xyz_CloudREff = xyz_CloudWatREff
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1114 = 1, xyz_cloudreff.DSC.U3*(xyz_cloudreff.DSC.U2*         
     .       1   xyz_cloudreff.DSC.U1 + xyz_cloudreff.DSC.U2)                   
     .           xyz_cloudreff(t1114-1,1,1) = xyz_cloudwatreff(t1114-1,1,1)     
     .        enddo                                                             
   444        call RadC1998CalcCloudOptProp(                        &
   445          & 'Liquid', l, xyz_CloudREff,                       & ! (in )
   446          & xyz_CloudExtCoef, xyz_CloudCoAlb, xyz_CloudWatAF  & ! (out)
   447          & )
   448        xyz_DelCloudWatOptDep = xyz_CloudExtCoef * xyz_DelH2OLiqMass
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1126 = 1, xyz_cloudextcoef.DSC.U3*(xyz_cloudextcoef.DSC.U2*   
     .       1   xyz_cloudextcoef.DSC.U1 + xyz_cloudextcoef.DSC.U2)             
     .           xyz_delcloudwatoptdep(t1126-1,1,1) = xyz_cloudextcoef(t1126-1,1
     .       1      ,1)*xyz_delh2oliqmass(t1126-1,1,1)                          
     .           xyz_cloudwatssa(t1126-1,1,1) = 1.00000000000000e+000 -         
     .       1      xyz_cloudcoalb(t1126-1,1,1)                                 
     .           xyz_cloudreff(t1126-1,1,1) = xyz_cloudicereff(t1126-1,1,1)     
     .        enddo                                                             
   449        xyz_CloudWatSSA       = 1.0_DP - xyz_CloudCoAlb
   450  
   451        ! Ice cloud optical properties
   452        !
   453        xyz_CloudREff = xyz_CloudIceREff
   454        call RadC1998CalcCloudOptProp(                        &
   455          & 'Ice', l, xyz_CloudREff,                          & ! (in )
   456          & xyz_CloudExtCoef, xyz_CloudCoAlb, xyz_CloudIceAF  & ! (out)
   457          & )
   458        xyz_DelCloudIceOptDep = xyz_CloudExtCoef * xyz_DelH2OSolMass
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1153 = 1, xyz_cloudextcoef.DSC.U3*(xyz_cloudextcoef.DSC.U2*   
     .       1   xyz_cloudextcoef.DSC.U1 + xyz_cloudextcoef.DSC.U2)             
     .           xyz_delcloudiceoptdep(t1153-1,1,1) = xyz_cloudextcoef(t1153-1,1
     .       1      ,1)*xyz_delh2osolmass(t1153-1,1,1)                          
     .           xyz_cloudicessa(t1153-1,1,1) = 1.00000000000000e+000 -         
     .       1      xyz_cloudcoalb(t1153-1,1,1)                                 
     .        enddo                                                             
   459        xyz_CloudIceSSA       = 1.0_DP - xyz_CloudCoAlb
   460  
   461  
   462        ! Smearing cloud
   463        !
   464        call CloudUtilsSmearCloudOptDep(  &
   465          & xyz_CloudCover,               & ! (in   )
   466          & xyz_DelCloudWatOptDep         & ! (inout)
   467          & )
   468        call CloudUtilsSmearCloudOptDep(  &
   469          & xyz_CloudCover,               & ! (in   )
   470          & xyz_DelCloudIceOptDep         & ! (inout)
   471          & )
   472  
   473  
   474        do ikdfbin = 1, nkdf
   475  
   476          call RadCL1996IRH2OKDFParams(              &
   477            & l, ikdfbin,                            & ! (in )
   478            & KDFAbsCoef, KDFWeight                  & ! (out)
   479            & )
   480  
   481          xyz_H2ODelOptDep = KDFAbsCoef * xyz_DelH2OVapMassScaled
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1174 = 1, xyz_delh2ovapmassscaled.DSC.U3*(                    
     .       1   xyz_delh2ovapmassscaled.DSC.U2*xyz_delh2ovapmassscaled.DSC.U1  
     .       2    + xyz_delh2ovapmassscaled.DSC.U2)                             
     .           xyz_h2odeloptdep(t1174-1,1,1) = kdfabscoef*                    
     .       1      xyz_delh2ovapmassscaled(t1174-1,1,1)                        
     .           xyz_deltotoptdep(t1174-1,1,1) = xyz_delcloudwatoptdep(t1174-1,1
     .       1      ,1) + xyz_delcloudiceoptdep(t1174-1,1,1) + xyz_h2odeloptdep(
     .       2      t1174-1,1,1)                                                
     .        enddo                                                             
   482  
   483  
   484          ! Total optical parameter
   485          !
   486          xyz_DelTotOptDep =          &
   487            &   xyz_DelCloudWatOptDep &
   488            & + xyz_DelCloudIceOptDep &
   489            & + xyz_H2ODelOptDep
   490  
   491          xyr_TotOptDep(:,:,kmax) = 0.0d0
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1198 = 1, xyr_totoptdep.DSC.U2*xyr_totoptdep.DSC.U1 +         
     .       1   xyr_totoptdep.DSC.U2                                           
     .           xyr_totoptdep(t1198-1,1,kmax) = 0.0000000000000000e+000        
     .        enddo                                                             
   492          do k = kmax-1, 0, -1
   493            xyr_TotOptDep(:,:,k) = xyr_TotOptDep(:,:,k+1) + xyz_DelTotOptDep(:,:,k+1)
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xyr_totoptdep)                                             
     .        do t1204 = 1, xyr_totoptdep.DSC.U2*xyr_totoptdep.DSC.U1 +         
     .       1   xyr_totoptdep.DSC.U2                                           
     .           xyr_totoptdep(t1204-1,1,k) = xyr_totoptdep(t1204-1,1,k+1) +    
     .       1      xyz_deltotoptdep(t1204-1,1,k+1)                             
     .        enddo                                                             
   494          end do
   495  
   496          xyz_SSA =                                            &
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1214 = 1, xyz_cloudwatssa.DSC.U3*(xyz_cloudwatssa.DSC.U2*     
     .       1   xyz_cloudwatssa.DSC.U1 + xyz_cloudwatssa.DSC.U2)               
     .           xyz_ssa(t1214-1,1,1) = (xyz_cloudwatssa(t1214-1,1,1)*          
     .       1      xyz_delcloudwatoptdep(t1214-1,1,1)+xyz_cloudicessa(t1214-1,1
     .       2      ,1)*xyz_delcloudiceoptdep(t1214-1,1,1)+                     
     .       3      0.0000000000000000e+000*xyz_h2odeloptdep(t1214-1,1,1))/(    
     .       4      xyz_deltotoptdep(t1214-1,1,1)+1.00000000000000e-100)        
     .        enddo                                                             
   497            &   ( xyz_CloudWatSSA   * xyz_DelCloudWatOptDep    &
   498            &   + xyz_CloudIceSSA   * xyz_DelCloudIceOptDep    &
   499            &   + 0.0d0             * xyz_H2ODelOptDep      )  &
   500            & / ( xyz_DelTotOptDep + 1.0d-100 )
   501          do k = 1, kmax
   502            do j = 1, jmax
   503              do i = 0, imax-1
   504                if ( xyz_SSA(i,j,k) >= 1.0d0 ) then
   505                  xyz_SSA(i,j,k) = 1.0d0 - 1.0d-10
   506                end if
   507              end do
   508            end do
   509          end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do k = 1, kmax*jmax*imax                                          
     .           if (xyz_ssa(k-1,1,1) .ge. 1.00000000000000e+000) then          
     .              xyz_ssa(k-1,1,1) = 9.99999999899999e-001                    
     .           endif                                                          
     .        enddo                                                             
   510          xyz_AF  =                                                               &
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1241 = 1, xyz_cloudwataf.DSC.U3*(xyz_cloudwataf.DSC.U2*       
     .       1   xyz_cloudwataf.DSC.U1 + xyz_cloudwataf.DSC.U2)                 
     .           xyz_af(t1241-1,1,1) = (xyz_cloudwataf(t1241-1,1,1)*            
     .       1      xyz_cloudwatssa(t1241-1,1,1)*xyz_delcloudwatoptdep(t1241-1,1
     .       2      ,1)+xyz_cloudiceaf(t1241-1,1,1)*xyz_cloudicessa(t1241-1,1,1)
     .       3      *xyz_delcloudiceoptdep(t1241-1,1,1)+0.0000000000000000e+000*
     .       4      xyz_h2odeloptdep(t1241-1,1,1))/(xyz_ssa(t1241-1,1,1)*       
     .       5      xyz_deltotoptdep(t1241-1,1,1)+1.00000000000000e-100)        
     .        enddo                                                             
   511            &   ( xyz_CloudWatAF    * xyz_CloudWatSSA   * xyz_DelCloudWatOptDep   &
   512            &   + xyz_CloudIceAF    * xyz_CloudIceSSA   * xyz_DelCloudIceOptDep   &
   513            &   + 0.0d0             * 0.0d0             * xyz_H2ODelOptDep     )  &
   514            & / ( xyz_ssa * xyz_DelTotOptDep + 1.0d-100 )
   515  
   516  
   517          call RadRTETwoStreamAppSW(        &
   518            & xyz_SSA, xyz_AF,              & ! (in)
   519            & xyr_TotOptDep,                & ! (in)
   520            & xy_SurfAlbedo,                & ! (in)
   521            & SolarFluxTOA, xy_InAngle,     & ! (in)
   522            & xyr_RadUwFlux, xyr_RadDwFlux  & ! (out)
   523            & )
   524  
   525  
   526          xyr_RadUwFlux = xyr_RadUwFlux * KDFWeight
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1277 = 1, (xyr_raduwflux.DSC.U3 + 1)*xyr_raduwflux.DSC.U2*(   
     .       1   xyr_raduwflux.DSC.U1 + 1)                                      
     .           xyr_raduwflux(t1277-1,1,0) = xyr_raduwflux(t1277-1,1,0)*       
     .       1      kdfweight                                                   
     .           xyr_raddwflux(t1277-1,1,0) = xyr_raddwflux(t1277-1,1,0)*       
     .       1      kdfweight                                                   
     .           xyr_radsuwflux(t1277-1,1,0) = xyr_radsuwflux(t1277-1,1,0) +    
     .       1      xyr_raduwflux(t1277-1,1,0)                                  
     .           xyr_radsdwflux(t1277-1,1,0) = xyr_radsdwflux(t1277-1,1,0) +    
     .       1      xyr_raddwflux(t1277-1,1,0)                                  
     .        enddo                                                             
   527          xyr_RadDwFlux = xyr_RadDwFlux * KDFWeight
   528  
   529          xyr_RadSUwFlux = xyr_RadSUwFlux + xyr_RadUwFlux
   530          xyr_RadSDwFlux = xyr_RadSDwFlux + xyr_RadDwFlux
   531  
   532        end do
   533  
   534      end do
   535  
   536  
   537  
   538  !!$    i = 0
   539  !!$    j = jmax / 2 + 1
   540  !!$    do k = 1, kmax
   541  !!$      write( 73, * ) xyz_Temp(i,j,k), xyz_QH2OVap(i,j,k), &
   542  !!$        & xyz_Press(i,j,k)
   543  !!$    end do
   544  !!$    call flush( 73 )
   545  !!$
   546  !!$    i = 0
   547  !!$    j = jmax / 2 + 1
   548  !!$    do k = 1, kmax
   549  !!$      write( 83, * ) &
   550  !!$        & + (     xyr_RadSFlux(i,j,k-1) - xyr_RadSFlux(i,j,k) )  &
   551  !!$        &     / ( xyr_Press(i,j,k-1)    - xyr_Press(i,j,k) )     &
   552  !!$        &     / 1004.6 * Grav, &
   553  !!$        & xyz_Press(i,j,k)
   554  !!$    end do
   555  !!$    call flush( 83 )
   556  !!$
   557  !!$!    write( 6, * ) '########## ', acos( 1.0d0 / xy_InAngle(i,j) ) * 180.0d0 / 3.141592d0
   558  !!$
   559  !!$
   560  !!$    i = 0
   561  !!$    j = jmax / 2 + 1
   562  !!$    write( 93, * ) '# ', xy_SurfAlbedo(i,j)
   563  !!$    write( 93, * ) '# ', 1.0_DP / xy_InAngle(i,j)
   564  !!$    do k = 0, kmax
   565  !!$      write( 93, * ) xyr_RadSFlux(i,j,k), xyr_Press(i,j,k)
   566  !!$    end do
   567  !!$    call flush( 93 )
   568  !!$    stop
   569  
   570  
   571      ! 計算時間計測一時停止
   572      ! Pause measurement of computation time
   573      !
   574      call TimesetClockStop( module_name )
   575  
   576  
   577    end subroutine RadEarthSWV26Flux
   578  
   579    !--------------------------------------------------------------------------------------
   580  
   581    subroutine RadEarthSWV26Init( &
   582      & ArgFlagSnow &
   583      & )
   584  
   585      ! ファイル入出力補助
   586      ! File I/O support
   587      !
   588      use dc_iounit, only: FileOpen
   589  
   590      ! NAMELIST ファイル入力に関するユーティリティ
   591      ! Utilities for NAMELIST file input
   592      !
   593      use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid
   594  
   595      ! 太陽放射フラックスの設定
   596      ! Set solar constant
   597      !
   598      use set_solarconst, only : SetSolarConstInit
   599  
   600      ! 短波入射 (太陽入射)
   601      ! Short wave (insolation) incoming
   602      !
   603      use rad_short_income, only : RadShortIncomeInit
   604  
   605      !
   606      ! Solve radiative transfer equation in two stream approximation
   607      !
   608      use rad_rte_two_stream_app, only: RadRTETwoStreamAppInit
   609  
   610      ! Chou and Lee (1996) による短波放射モデル
   611      ! Short wave radiation model described by Chou and Lee (1996)
   612      !
   613      use rad_CL1996, only : RadCL1996Init
   614  
   615      ! Chou et al (1998) による短波放射用雲モデル
   616      ! Cloud model for short wave radiation model described by Chou et al (1998)
   617      !
   618      use rad_C1998, only : RadC1998Init
   619  
   620      ! 雲関系ルーチン
   621      ! Cloud-related routines
   622      !
   623      use cloud_utils, only : CloudUtilsInit
   624  
   625  
   626      ! 宣言文 ; Declaration statements
   627      !
   628      logical, intent(in) :: ArgFlagSnow
   629  
   630  
   631      integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号.
   632                                ! Unit number for NAMELIST file open
   633      integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT.
   634                                ! IOSTAT of NAMELIST read
   635  
   636      ! NAMELIST 変数群
   637      ! NAMELIST group name
   638      !
   639      namelist /rad_Earth_SW_V2_6_nml/ &
   640        & FlagRayleighScattering
   641            !
   642            ! デフォルト値については初期化手続 "rad_Earth_SW_V2_6#RadEarthSWV26Init"
   643            ! のソースコードを参照のこと.
   644            !
   645            ! Refer to source codes in the initialization procedure
   646            ! "rad_Earth_SW_V2_6#RadEarthSWEV26Init" for the default values.
   647            !
   648  
   649      if ( rad_Earth_SW_V2_6_inited ) return
   650  
   651  
   652      ! デフォルト値の設定
   653      ! Default values settings
   654      !
   655      FlagRayleighScattering = .true.
   656  
   657  
   658      ! NAMELIST の読み込み
   659      ! NAMELIST is input
   660      !
   661      if ( trim(namelist_filename) /= '' ) then
   662        call FileOpen( unit_nml, &          ! (out)
   663          & namelist_filename, mode = 'r' ) ! (in)
   664  
   665        rewind( unit_nml )
   666        read( unit_nml,                          & ! (in)
   667          & nml = rad_Earth_SW_V2_6_nml,         & ! (out)
   668          & iostat = iostat_nml )                  ! (out)
   669        close( unit_nml )
   670  
   671        call NmlutilMsg( iostat_nml, module_name ) ! (in)
   672      end if
   673  
   674  
   675  
   676      ! Initialization of modules used in this module
   677      !
   678  
   679      ! 太陽放射フラックスの設定
   680      ! Set solar constant
   681      !
   682      call SetSolarConstInit
   683  
   684      ! 短波入射 (太陽入射)
   685      ! Short wave (insolation) incoming
   686      !
   687      call RadShortIncomeInit
   688  
   689      !
   690      ! Solve radiative transfer equation in two stream approximation
   691      !
   692      call RadRTETwoStreamAppInit
   693  
   694      ! Chou and Lee (1996) による短波放射モデル
   695      ! Short wave radiation model described by Chou and Lee (1996)
   696      !
   697      call RadCL1996Init
   698  
   699      ! Chou et al (1998) による短波放射用雲モデル
   700      ! Cloud model for short wave radiation model described by Chou et al (1998)
   701      !
   702      call RadC1998Init
   703  
   704      ! 雲関系ルーチン
   705      ! Cloud-related routines
   706      !
   707      call CloudUtilsInit( &
   708        & ArgFlagSnow            &
   709        & )
   710  
   711  
   712      ! 印字 ; Print
   713      !
   714      call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   715      call MessageNotify( 'M', module_name, 'FlagRayleighScattering = %b', l = (/ FlagRayleighScattering /) )
   716      call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   717  
   718  
   719      rad_Earth_SW_V2_6_inited = .true.
   720  
   721    end subroutine RadEarthSWV26Init
   722  
   723    !--------------------------------------------------------------------------------------
   724  
   725  end module rad_Earth_SW_V2_6
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:51 2016
FILE NAME: rad_Earth_SW_V2_6.f90
PROGRAM NAME: rad_earth_sw_v2_6
FORMAT LIST

  LINE    LOOP      FORTRAN STATEMENT

     1:             != 地球大気向け短波放射モデル Ver. 2.6
     2:             !
     3:             != short wave radiation model for the Earth's atmosphere Ver. 2.6
     4:             !
     5:             ! Authors::   Yoshiyuki O. Takahashi
     6:             ! Version::   $Id: rad_Earth_SW_V2_6.f90,v 1.1 2015/01/29 12:16:19 yot Exp $
     7:             ! Tag Name::  $Name:  $
     8:             ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9:             ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10:             !
    11:             module rad_Earth_SW_V2_6
    12:             
    13:               !
    14:               != 地球大気向け短波放射モデル Ver. 2.6
    15:               !
    16:               != short wave radiation model for the Earth's atmosphere Ver. 2.6
    17:               !
    18:               ! <b>Note that Japanese and English are described in parallel.</b>
    19:               !
    20:               ! 地球大気向け短波放射モデル.
    21:               !
    22:               ! This is a short wave radiation model for the Earth's atmospehre.
    23:               !
    24:               ! This module is a simple extention of Ver. 2.1. A difference between 
    25:               ! this version (Ver. 2.6) and Ver. 2.1 is inclusion of effect of cloud 
    26:               ! fraction less than 1.
    27:               !
    28:               ! The wavenumber range of shortwave radiation treated by this routine is 
    29:               ! from 1000 to 57143 cm-1 (0.175 to 10 micron). 
    30:               !
    31:               ! From 1000 to 57143 cm-1, the following effects are considered. 
    32:               ! * 1000 to 14286 cm-1 (0.70-10 micron): 
    33:               !   * absorption by H2O, 
    34:               !     * absorption by H2O is considered by using k-distribution method 
    35:               !       following Chou and Lee (1996), 
    36:               !   * absorption and scattering by cloud droplets.
    37:               !     * optical properties of cloud is obtained from Chou et al. (1998)
    38:               ! * 14286 to 57143 cm-1 (0.175 to 0.70 micron): 
    39:               !   * Rayleigh scattering, 
    40:               !     * scattering coefficient is obtained from Chou and Lee (1996), 
    41:               !   * scattering by cloud droplets. 
    42:               !     * optical properties of cloud is obtained from Chou et al. (1998)
    43:               !
    44:               !
    45:               !== References
    46:               !
    47:               !  Chou, M.-D., and K.-T. Lee, 
    48:               !    Parameterizations for the absorption of solar radiation by water vapor and ozone,
    49:               !    J. Atmos. Sci., 53, 1203-1208, 1996.
    50:               !
    51:               !  Chou, M.-D., M. J. Suarez, C.-H. Ho, M. M.-H. Yan, and K.-T. Lee, 
    52:               !    Parameterizations for cloud overlapping and shortwave single-scattering 
    53:               !    properties for use in general circulation and cloud ensemble models, 
    54:               !    J. Climate, 11, 202-214, 1998.
    55:               !
    56:               !== Procedures List
    57:               !
    58:               ! RadEarthSWV26Flux   :: 放射フラックスの計算
    59:               ! ------------        :: ------------
    60:               ! RadEarthSWV26Flux   :: Calculate radiation flux
    61:               !
    62:               !== NAMELIST
    63:               !
    64:               ! NAMELIST#rad_Earth_SW_V2_6_nml
    65:               !
    66:             
    67:               ! USE statements
    68:               !
    69:             
    70:               !
    71:               ! Kind type parameter
    72:               !
    73:               use dc_types, only: DP, &      ! Double precision.
    74:                 &                 STRING, &  ! Strings.
    75:                 &                 TOKEN      ! Keywords.
    76:             
    77:               ! メッセージ出力
    78:               ! Message output
    79:               !
    80:               use dc_message, only: MessageNotify
    81:             
    82:             
    83:               ! 格子点設定
    84:               ! Grid points settings
    85:               !
    86:               use gridset, only: imax, & ! 経度格子点数.
    87:                                          ! Number of grid points in longitude
    88:                 &                jmax, & ! 緯度格子点数.
    89:                                          ! Number of grid points in latitude
    90:                 &                kmax    ! 鉛直層数.
    91:                                          ! Number of vertical level
    92:             
    93:               ! 時刻管理
    94:               ! Time control
    95:               !
    96:               use timeset, only: &
    97:                 & TimesetClockStart, TimesetClockStop
    98:             
    99:               implicit none
   100:             
   101:               private
   102:             
   103:               logical , save      :: FlagRayleighScattering
   104:             
   105:             
   106:               ! 公開変数
   107:               ! Public variables
   108:               !
   109:               logical, save :: rad_Earth_SW_V2_6_inited = .false.
   110:                                           ! 初期設定フラグ.
   111:                                           ! Initialization flag
   112:             
   113:               public :: RadEarthSWV26Flux
   114:               public :: RadEarthSWV26Init
   115:             
   116:               character(*), parameter:: module_name = 'rad_Earth_SW_V2_6'
   117:                                           ! モジュールの名称.
   118:                                           ! Module name
   119:               character(*), parameter:: version = &
   120:                 & '$Name:  $' // &
   121:                 & '$Id: rad_Earth_SW_V2_6.f90,v 1.1 2015/01/29 12:16:19 yot Exp $'
   122:                                           ! モジュールのバージョン
   123:                                           ! Module version
   124:             
   125:               !--------------------------------------------------------------------------------------
   126:             
   127:             contains
   128:             
   129:               !--------------------------------------------------------------------------------------
   130:             
   131:               subroutine RadEarthSWV26Flux(                                &
   132:                 & xy_SurfAlbedo,                                           &
   133:                 & xyz_DelAtmMass,                                          &
   134:                 & xyz_DelH2OVapMass, xyz_DelH2OLiqMass, xyz_DelH2OSolMass, &
   135:                 & xyz_DelO3Mass,                                           &
   136:                 & xyz_Press, xyz_Temp,                                     &
   137:                 & xyz_CloudCover,                                          &
   138:                 & xyz_CloudWatREff, xyz_CloudIceREff,                      &
   139:                 & xyr_RadSUwFlux, xyr_RadSDwFlux                           &
   140:                 & )
   141:             
   142:                 ! USE statements
   143:                 !
   144:             
   145:                 ! 太陽放射フラックスの設定
   146:                 ! Set solar constant
   147:                 !
   148:                 use set_solarconst, only : SetSolarConst
   149:             
   150:                 ! 短波入射 (太陽入射)
   151:                 ! Short wave (insolation) incoming
   152:                 !
   153:                 use rad_short_income, only : RadShortIncome
   154:             
   155:                 !
   156:                 ! Solve radiative transfer equation in two stream approximation
   157:                 !
   158:                 use rad_rte_two_stream_app, only: RadRTETwoStreamAppSW
   159:             
   160:                 ! Chou and Lee (1996) による短波放射モデル
   161:                 ! Short wave radiation model described by Chou and Lee (1996)
   162:                 !
   163:                 use rad_CL1996, only :       &
   164:                   & RadCL1996NumBands      , &
   165:                   & RadCL1996UVVISParams   , &
   166:                   & RadCL1996IRH2ONumKDFBin, &
   167:                   & RadCL1996IRH2OKDFParams, &
   168:                   & RadCL1996ScaleH2OVapMass
   169:             
   170:             
   171:                 ! Chou et al (1998) による短波放射用雲モデル
   172:                 ! Cloud model for short wave radiation model described by Chou et al (1998)
   173:                 !
   174:                 use rad_C1998, only : RadC1998CalcCloudOptProp
   175:             
   176:                 ! 雲関系ルーチン
   177:                 ! Cloud-related routines
   178:                 !
   179:                 use cloud_utils, only : CloudUtilsSmearCloudOptDep
   180:             
   181:             
   182:                 real(DP), intent(in ) :: xy_SurfAlbedo    (0:imax-1, 1:jmax )
   183:                 real(DP), intent(in ) :: xyz_DelAtmMass   (0:imax-1, 1:jmax, 1:kmax)
   184:                 real(DP), intent(in ) :: xyz_DelH2OVapMass(0:imax-1, 1:jmax, 1:kmax)
   185:                 real(DP), intent(in ) :: xyz_DelH2OLiqMass(0:imax-1, 1:jmax, 1:kmax)
   186:                 real(DP), intent(in ) :: xyz_DelH2OSolMass(0:imax-1, 1:jmax, 1:kmax)
   187:                 real(DP), intent(in ) :: xyz_DelO3Mass    (0:imax-1, 1:jmax, 1:kmax)
   188:                 real(DP), intent(in ) :: xyz_Press        (0:imax-1, 1:jmax, 1:kmax)
   189:                 real(DP), intent(in ) :: xyz_Temp         (0:imax-1, 1:jmax, 1:kmax)
   190:                 real(DP), intent(in ) :: xyz_CloudCover   (0:imax-1, 1:jmax, 1:kmax)
   191:                 real(DP), intent(in ) :: xyz_CloudWatREff (0:imax-1, 1:jmax, 1:kmax)
   192:                 real(DP), intent(in ) :: xyz_CloudIceREff (0:imax-1, 1:jmax, 1:kmax)
   193:                 real(DP), intent(out) :: xyr_RadSUwFlux   (0:imax-1, 1:jmax, 0:kmax)
   194:                 real(DP), intent(out) :: xyr_RadSDwFlux   (0:imax-1, 1:jmax, 0:kmax)
   195:             
   196:             
   197:                 real(DP) :: SolarConst
   198:             
   199:                 real(DP) :: xy_InAngle    (0:imax-1, 1:jmax)
   200:                                           ! sec (入射角).
   201:                                           ! sec (angle of incidence)
   202:                 real(DP) :: DistFromStarScld
   203:                                            ! Distance between the central star and the planet
   204:                 real(DP) :: DiurnalMeanFactor
   205:             
   206:             
   207:                 integer  :: nbands1
   208:                 integer  :: nbands2
   209:             
   210:                 real(DP) :: UVVISFracSolarFlux
   211:                 real(DP) :: UVVISO3AbsCoef
   212:                 real(DP) :: UVVISRayScatCoef
   213:             
   214:                 real(DP) :: SolarFluxTOA
   215:             
   216:             
   217:             
   218:                 real(DP) :: xyz_SSA       (0:imax-1, 1:jmax, 1:kmax)
   219:                 real(DP) :: xyz_AF        (0:imax-1, 1:jmax, 1:kmax)
   220:             
   221:             
   222:                 real(DP), parameter :: RayScatSinScatAlb = 1.0d0 - 1.0d-10
   223:                 real(DP), parameter :: RayScatAsymFact   = 0.0d0
   224:             
   225:                 real(DP)            :: xyz_DelH2OVapMassScaled( 0:imax-1, 1:jmax, 1:kmax )
   226:             
   227:                 real(DP)            :: xyz_DelCloudWatOptDep( 0:imax-1, 1:jmax, 1:kmax )
   228:                 real(DP)            :: xyz_DelCloudIceOptDep( 0:imax-1, 1:jmax, 1:kmax )
   229:             
   230:                 real(DP)            :: xyz_RayScatDelOptDep( 0:imax-1, 1:jmax, 1:kmax )
   231:             
   232:                 real(DP)            :: xyz_O3AbsDelOptDep  ( 0:imax-1, 1:jmax, 1:kmax )
   233:             
   234:                 real(DP)            :: xyz_DelTotOptDep( 0:imax-1, 1:jmax, 1:kmax )
   235:                 real(DP)            :: xyr_TotOptDep   ( 0:imax-1, 1:jmax, 0:kmax )
   236:                 real(DP)            :: xyr_RadFlux     ( 0:imax-1, 1:jmax, 0:kmax )
   237:                 real(DP)            :: xyr_RadUwFlux   ( 0:imax-1, 1:jmax, 0:kmax )
   238:                 real(DP)            :: xyr_RadDwFlux   ( 0:imax-1, 1:jmax, 0:kmax )
   239:             
   240:                 integer  :: nkdf
   241:             
   242:                 integer  :: ikdfbin
   243:                 real(DP) :: KDFAbsCoef
   244:                 real(DP) :: KDFWeight
   245:                 real(DP) :: xyz_H2ODelOptDep( 0:imax-1, 1:jmax, 1:kmax )
   246:             
   247:             
   248:                 real(DP) :: xyz_CloudREff   (0:imax-1, 1:jmax, 1:kmax)
   249:                 real(DP) :: xyz_CloudExtCoef(0:imax-1, 1:jmax, 1:kmax)
   250:                 real(DP) :: xyz_CloudCoAlb  (0:imax-1, 1:jmax, 1:kmax)
   251:                 real(DP) :: xyz_CloudWatSSA (0:imax-1, 1:jmax, 1:kmax)
   252:                 real(DP) :: xyz_CloudWatAF  (0:imax-1, 1:jmax, 1:kmax)
   253:                 real(DP) :: xyz_CloudIceSSA (0:imax-1, 1:jmax, 1:kmax)
   254:                 real(DP) :: xyz_CloudIceAF  (0:imax-1, 1:jmax, 1:kmax)
   255:             
   256:             
   257:             
   258:                 integer  :: i
   259:                 integer  :: j
   260:                 integer  :: k
   261:                 integer  :: l
   262:             
   263:             
   264:                 ! 初期化確認
   265:                 ! Initialization check
   266:                 !
   267:                 if ( .not. rad_Earth_SW_V2_6_inited ) then
   268:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   269:                 end if
   270:             
   271:             
   272:                 ! 計算時間計測開始
   273:                 ! Start measurement of computation time
   274:                 !
   275:                 call TimesetClockStart( module_name )
   276:             
   277:             
   278:                 ! 太陽放射フラックスの設定
   279:                 ! Set solar constant
   280:                 !
   281:                 call SetSolarConst( &
   282:                   & SolarConst      & ! (out)
   283:                   & )
   284:             
   285:                 ! 短波入射の計算
   286:                 ! Calculate short wave (insolation) incoming radiation
   287:                 !
   288:                 call RadShortIncome(                       &
   289:                   & xy_InAngle        = xy_InAngle,        & ! (out) optional
   290:                   & DistFromStarScld  = DistFromStarScld,  & ! (out) optional
   291:                   & DiurnalMeanFactor = DiurnalMeanFactor  &
   292:                   & )
   293:             
   294:             
   295:                 call RadCL1996NumBands(   &
   296:                   & nbands1, nbands2      & ! (out)
   297:                   & )
   298:             
   299:             
   300:                 ! Initialization
   301:                 !
   302: **W---->A       xyr_RadSUwFlux = 0.0_DP
   303: **W---- A       xyr_RadSDwFlux = 0.0_DP
   304:             
   305:             
   306:                 ! * 14286 to 57143 cm-1 (0.175 to 0.70 micron): 
   307:                 !   * Rayleigh scattering, 
   308:                 !   * scattering by cloud droplets. 
   309:                 !   * O3 absorption
   310:                 !
   311: +------>        do l = 1, nbands1
   312: |           
   313: |                 ! Water cloud optical properties
   314: |                 !
   315: |W**=== A         xyz_CloudREff = xyz_CloudWatREff
   316: |                 call RadC1998CalcCloudOptProp(                        &
   317: |                   & 'Liquid', l, xyz_CloudREff,                       & ! (in )
   318: |                   & xyz_CloudExtCoef, xyz_CloudCoAlb, xyz_CloudWatAF  & ! (out)
   319: |                   & )
   320: |**W--->A         xyz_DelCloudWatOptDep = xyz_CloudExtCoef * xyz_DelH2OLiqMass
   321: ||||    A         xyz_CloudWatSSA       = 1.0_DP - xyz_CloudCoAlb
   322: ||||        
   323: ||||              ! Ice cloud optical properties
   324: ||||              !
   325: |**W--- A         xyz_CloudREff = xyz_CloudIceREff
   326: |                 call RadC1998CalcCloudOptProp(                        &
   327: |                   & 'Ice', l, xyz_CloudREff,                          & ! (in )
   328: |                   & xyz_CloudExtCoef, xyz_CloudCoAlb, xyz_CloudIceAF  & ! (out)
   329: |                   & )
   330: |**W--->A         xyz_DelCloudIceOptDep = xyz_CloudExtCoef * xyz_DelH2OSolMass
   331: |**W--- A         xyz_CloudIceSSA       = 1.0_DP - xyz_CloudCoAlb
   332: |           
   333: |           
   334: |                 ! Smearing cloud
   335: |                 !
   336: |                 call CloudUtilsSmearCloudOptDep(  &
   337: |                   & xyz_CloudCover,               & ! (in   )
   338: |                   & xyz_DelCloudWatOptDep         & ! (inout)
   339: |                   & )
   340: |                 call CloudUtilsSmearCloudOptDep(  &
   341: |                   & xyz_CloudCover,               & ! (in   )
   342: |                   & xyz_DelCloudIceOptDep         & ! (inout)
   343: |                   & )
   344: |           
   345: |           
   346: |           
   347: |                 ! UV and Visible optical properties and solar flux
   348: |                 !
   349: |                 call RadCL1996UVVISParams(                                &
   350: |                   & l,                                                    & ! (in )
   351: |                   & UVVISFracSolarFlux, UVVISO3AbsCoef, UVVISRayScatCoef  & ! (out)
   352: |                   & )
   353: |           
   354: |                 SolarFluxTOA = UVVISFracSolarFlux * SolarConst / DistFromStarScld**2 * DiurnalMeanFactor
   355: |           
   356: |           
   357: |                 ! Rayleigh scattering
   358: |                 !
   359: |                 if ( FlagRayleighScattering ) then
   360: |++V=== A           xyz_RayScatDelOptDep = UVVISRayScatCoef * xyz_DelAtmMass
   361: |                 else
   362: |W**===             xyz_RayScatDelOptDep = 0.0d0
   363: |                 end if
   364: |           
   365: |           
   366: |                 ! O3 absorption
   367: |                 !
   368: |**W--->A         xyz_O3AbsDelOptDep = UVVISO3AbsCoef * xyz_DelO3Mass
   369: ||||        
   370: ||||        
   371: ||||              ! Total optical parameter
   372: ||||              !
   373: |**W--- A         xyz_DelTotOptDep =            &
   374: |                   &   xyz_DelCloudWatOptDep   &
   375: |                   & + xyz_DelCloudIceOptDep   &
   376: |                   & + xyz_RayScatDelOptDep    &
   377: |                   & + xyz_O3AbsDelOptDep
   378: |                 !
   379: |W*==== A         xyr_TotOptDep(:,:,kmax) = 0.0d0
   380: |+----->          do k = kmax-1, 0, -1
   381: ||W*=== A           xyr_TotOptDep(:,:,k) = xyr_TotOptDep(:,:,k+1) + xyz_DelTotOptDep(:,:,k+1)
   382: |+-----           end do
   383: |                 !
   384: |W**=== A         xyz_SSA =                                           &
   385: |                   &   ( xyz_CloudWatSSA   * xyz_DelCloudWatOptDep   &
   386: |                   &   + xyz_CloudIceSSA   * xyz_DelCloudIceOptDep   &
   387: |                   &   + RayScatSinScatAlb * xyz_RayScatDelOptDep    &
   388: |                   &   + 0.0d0             * xyz_O3AbsDelOptDep   )  &
   389: |                   & / ( xyz_DelTotOptDep + 1.0d-100 )
   390: |W----->          do k = 1, kmax
   391: ||*---->            do j = 1, jmax
   392: |||*--->              do i = 0, imax-1
   393: ||||    A               if ( xyz_SSA(i,j,k) >= 1.0d0 ) then
   394: ||||    A                 xyz_SSA(i,j,k) = 1.0d0 - 1.0d-10
   395: ||||                    end if
   396: |||*---               end do
   397: ||*----             end do
   398: |W-----           end do
   399: |W**=== A         xyz_AF  =                                                               &
   400: |                   &   ( xyz_CloudWatAF    * xyz_CloudWatSSA   * xyz_DelCloudWatOptDep   &
   401: |                   &   + xyz_CloudIceAF    * xyz_CloudIceSSA   * xyz_DelCloudIceOptDep   &
   402: |                   &   + RayScatAsymFact   * RayScatSinScatAlb * xyz_RayScatDelOptDep    &
   403: |                   &   + 0.0d0             * 0.0d0             * xyz_O3AbsDelOptDep   )  &
   404: |                   & / ( xyz_SSA * xyz_DelTotOptDep + 1.0d-100 )
   405: |           
   406: |           
   407: |                 call RadRTETwoStreamAppSW(        &
   408: |                   & xyz_SSA, xyz_AF,              & ! (in)
   409: |                   & xyr_TotOptDep,                & ! (in)
   410: |                   & xy_SurfAlbedo,                & ! (in)
   411: |                   & SolarFluxTOA, xy_InAngle,     & ! (in)
   412: |                   & xyr_RadUwFlux, xyr_RadDwFlux  & ! (out)
   413: |                   & )
   414: |           
   415: |**W--->A         xyr_RadSUwFlux = xyr_RadSUwFlux + xyr_RadUwFlux
   416: |**W--- A         xyr_RadSDwFlux = xyr_RadSDwFlux + xyr_RadDwFlux
   417: |           
   418: +------         end do
   419:             
   420:             
   421:                 ! * 1000 to 14286 cm-1 (0.70-10 micron): 
   422:                 !   * absorption by H2O, 
   423:                 !   * scattering by cloud droplets.
   424:                 !
   425:             
   426:                 call RadCL1996ScaleH2OVapMass(              &
   427:                   & xyz_Temp, xyz_DelH2OVapMass, xyz_Press, & ! (in )
   428:                   & xyz_DelH2OVapMassScaled                 & ! (out)
   429:                   & )
   430:             
   431:             
   432:                 call RadCL1996IRH2ONumKDFBin( &
   433:                   & nkdf & ! (out)
   434:                   & )
   435:             
   436:             
   437:                 SolarFluxTOA = SolarConst / DistFromStarScld**2 * DiurnalMeanFactor
   438:             
   439: +------>        do l = nbands1+1, nbands1+nbands2
   440: |           
   441: |                 ! Water cloud optical properties
   442: |                 !
   443: |W**=== A         xyz_CloudREff = xyz_CloudWatREff
   444: |                 call RadC1998CalcCloudOptProp(                        &
   445: |                   & 'Liquid', l, xyz_CloudREff,                       & ! (in )
   446: |                   & xyz_CloudExtCoef, xyz_CloudCoAlb, xyz_CloudWatAF  & ! (out)
   447: |                   & )
   448: |**W--->A         xyz_DelCloudWatOptDep = xyz_CloudExtCoef * xyz_DelH2OLiqMass
   449: ||||    A         xyz_CloudWatSSA       = 1.0_DP - xyz_CloudCoAlb
   450: ||||        
   451: ||||              ! Ice cloud optical properties
   452: ||||              !
   453: |**W--- A         xyz_CloudREff = xyz_CloudIceREff
   454: |                 call RadC1998CalcCloudOptProp(                        &
   455: |                   & 'Ice', l, xyz_CloudREff,                          & ! (in )
   456: |                   & xyz_CloudExtCoef, xyz_CloudCoAlb, xyz_CloudIceAF  & ! (out)
   457: |                   & )
   458: |**W--->A         xyz_DelCloudIceOptDep = xyz_CloudExtCoef * xyz_DelH2OSolMass
   459: |**W--- A         xyz_CloudIceSSA       = 1.0_DP - xyz_CloudCoAlb
   460: |           
   461: |           
   462: |                 ! Smearing cloud
   463: |                 !
   464: |                 call CloudUtilsSmearCloudOptDep(  &
   465: |                   & xyz_CloudCover,               & ! (in   )
   466: |                   & xyz_DelCloudWatOptDep         & ! (inout)
   467: |                   & )
   468: |                 call CloudUtilsSmearCloudOptDep(  &
   469: |                   & xyz_CloudCover,               & ! (in   )
   470: |                   & xyz_DelCloudIceOptDep         & ! (inout)
   471: |                   & )
   472: |           
   473: |           
   474: |+----->          do ikdfbin = 1, nkdf
   475: ||          
   476: ||                  call RadCL1996IRH2OKDFParams(              &
   477: ||                    & l, ikdfbin,                            & ! (in )
   478: ||                    & KDFAbsCoef, KDFWeight                  & ! (out)
   479: ||                    & )
   480: ||          
   481: ||**W-->A           xyz_H2ODelOptDep = KDFAbsCoef * xyz_DelH2OVapMassScaled
   482: |||||       
   483: |||||       
   484: |||||               ! Total optical parameter
   485: |||||               !
   486: ||**W-- A           xyz_DelTotOptDep =          &
   487: ||                    &   xyz_DelCloudWatOptDep &
   488: ||                    & + xyz_DelCloudIceOptDep &
   489: ||                    & + xyz_H2ODelOptDep
   490: ||          
   491: ||W*=== A           xyr_TotOptDep(:,:,kmax) = 0.0d0
   492: ||+---->            do k = kmax-1, 0, -1
   493: |||W*== A             xyr_TotOptDep(:,:,k) = xyr_TotOptDep(:,:,k+1) + xyz_DelTotOptDep(:,:,k+1)
   494: ||+----             end do
   495: ||          
   496: ||W**== A           xyz_SSA =                                            &
   497: ||                    &   ( xyz_CloudWatSSA   * xyz_DelCloudWatOptDep    &
   498: ||                    &   + xyz_CloudIceSSA   * xyz_DelCloudIceOptDep    &
   499: ||                    &   + 0.0d0             * xyz_H2ODelOptDep      )  &
   500: ||                    & / ( xyz_DelTotOptDep + 1.0d-100 )
   501: ||W---->            do k = 1, kmax
   502: |||*--->              do j = 1, jmax
   503: ||||*-->                do i = 0, imax-1
   504: |||||   A                 if ( xyz_SSA(i,j,k) >= 1.0d0 ) then
   505: |||||   A                   xyz_SSA(i,j,k) = 1.0d0 - 1.0d-10
   506: |||||                     end if
   507: ||||*--                 end do
   508: |||*---               end do
   509: ||W----             end do
   510: ||W**== A           xyz_AF  =                                                               &
   511: ||                    &   ( xyz_CloudWatAF    * xyz_CloudWatSSA   * xyz_DelCloudWatOptDep   &
   512: ||                    &   + xyz_CloudIceAF    * xyz_CloudIceSSA   * xyz_DelCloudIceOptDep   &
   513: ||                    &   + 0.0d0             * 0.0d0             * xyz_H2ODelOptDep     )  &
   514: ||                    & / ( xyz_ssa * xyz_DelTotOptDep + 1.0d-100 )
   515: ||          
   516: ||          
   517: ||                  call RadRTETwoStreamAppSW(        &
   518: ||                    & xyz_SSA, xyz_AF,              & ! (in)
   519: ||                    & xyr_TotOptDep,                & ! (in)
   520: ||                    & xy_SurfAlbedo,                & ! (in)
   521: ||                    & SolarFluxTOA, xy_InAngle,     & ! (in)
   522: ||                    & xyr_RadUwFlux, xyr_RadDwFlux  & ! (out)
   523: ||                    & )
   524: ||          
   525: ||          
   526: ||**W-->A           xyr_RadUwFlux = xyr_RadUwFlux * KDFWeight
   527: |||||   A           xyr_RadDwFlux = xyr_RadDwFlux * KDFWeight
   528: |||||       
   529: |||||   A           xyr_RadSUwFlux = xyr_RadSUwFlux + xyr_RadUwFlux
   530: ||**W-- A           xyr_RadSDwFlux = xyr_RadSDwFlux + xyr_RadDwFlux
   531: ||          
   532: |+-----           end do
   533: |           
   534: +------         end do
   535:             
   536:             
   537:             
   538:             !!$    i = 0
   539:             !!$    j = jmax / 2 + 1
   540:             !!$    do k = 1, kmax
   541:             !!$      write( 73, * ) xyz_Temp(i,j,k), xyz_QH2OVap(i,j,k), &
   542:             !!$        & xyz_Press(i,j,k)
   543:             !!$    end do
   544:             !!$    call flush( 73 )
   545:             !!$
   546:             !!$    i = 0
   547:             !!$    j = jmax / 2 + 1
   548:             !!$    do k = 1, kmax
   549:             !!$      write( 83, * ) &
   550:             !!$        & + (     xyr_RadSFlux(i,j,k-1) - xyr_RadSFlux(i,j,k) )  &
   551:             !!$        &     / ( xyr_Press(i,j,k-1)    - xyr_Press(i,j,k) )     &
   552:             !!$        &     / 1004.6 * Grav, &
   553:             !!$        & xyz_Press(i,j,k)
   554:             !!$    end do
   555:             !!$    call flush( 83 )
   556:             !!$
   557:             !!$!    write( 6, * ) '########## ', acos( 1.0d0 / xy_InAngle(i,j) ) * 180.0d0 / 3.141592d0
   558:             !!$
   559:             !!$
   560:             !!$    i = 0
   561:             !!$    j = jmax / 2 + 1
   562:             !!$    write( 93, * ) '# ', xy_SurfAlbedo(i,j)
   563:             !!$    write( 93, * ) '# ', 1.0_DP / xy_InAngle(i,j)
   564:             !!$    do k = 0, kmax
   565:             !!$      write( 93, * ) xyr_RadSFlux(i,j,k), xyr_Press(i,j,k)
   566:             !!$    end do
   567:             !!$    call flush( 93 )
   568:             !!$    stop
   569:             
   570:             
   571:                 ! 計算時間計測一時停止
   572:                 ! Pause measurement of computation time
   573:                 !
   574:                 call TimesetClockStop( module_name )
   575:             
   576:             
   577:               end subroutine RadEarthSWV26Flux
   578:             
   579:               !--------------------------------------------------------------------------------------
   580:             
   581:               subroutine RadEarthSWV26Init( &
   582:                 & ArgFlagSnow &
   583:                 & )
   584:             
   585:                 ! ファイル入出力補助
   586:                 ! File I/O support
   587:                 !
   588:                 use dc_iounit, only: FileOpen
   589:             
   590:                 ! NAMELIST ファイル入力に関するユーティリティ
   591:                 ! Utilities for NAMELIST file input
   592:                 !
   593:                 use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid
   594:             
   595:                 ! 太陽放射フラックスの設定
   596:                 ! Set solar constant
   597:                 !
   598:                 use set_solarconst, only : SetSolarConstInit
   599:             
   600:                 ! 短波入射 (太陽入射)
   601:                 ! Short wave (insolation) incoming
   602:                 !
   603:                 use rad_short_income, only : RadShortIncomeInit
   604:             
   605:                 !
   606:                 ! Solve radiative transfer equation in two stream approximation
   607:                 !
   608:                 use rad_rte_two_stream_app, only: RadRTETwoStreamAppInit
   609:             
   610:                 ! Chou and Lee (1996) による短波放射モデル
   611:                 ! Short wave radiation model described by Chou and Lee (1996)
   612:                 !
   613:                 use rad_CL1996, only : RadCL1996Init
   614:             
   615:                 ! Chou et al (1998) による短波放射用雲モデル
   616:                 ! Cloud model for short wave radiation model described by Chou et al (1998)
   617:                 !
   618:                 use rad_C1998, only : RadC1998Init
   619:             
   620:                 ! 雲関系ルーチン
   621:                 ! Cloud-related routines
   622:                 !
   623:                 use cloud_utils, only : CloudUtilsInit
   624:             
   625:             
   626:                 ! 宣言文 ; Declaration statements
   627:                 !
   628:                 logical, intent(in) :: ArgFlagSnow
   629:             
   630:             
   631:                 integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号.
   632:                                           ! Unit number for NAMELIST file open
   633:                 integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT.
   634:                                           ! IOSTAT of NAMELIST read
   635:             
   636:                 ! NAMELIST 変数群
   637:                 ! NAMELIST group name
   638:                 !
   639:                 namelist /rad_Earth_SW_V2_6_nml/ &
   640:                   & FlagRayleighScattering
   641:                       !
   642:                       ! デフォルト値については初期化手続 "rad_Earth_SW_V2_6#RadEarthSWV26Init"
   643:                       ! のソースコードを参照のこと.
   644:                       !
   645:                       ! Refer to source codes in the initialization procedure
   646:                       ! "rad_Earth_SW_V2_6#RadEarthSWEV26Init" for the default values.
   647:                       !
   648:             
   649:                 if ( rad_Earth_SW_V2_6_inited ) return
   650:             
   651:             
   652:                 ! デフォルト値の設定
   653:                 ! Default values settings
   654:                 !
   655:                 FlagRayleighScattering = .true.
   656:             
   657:             
   658:                 ! NAMELIST の読み込み
   659:                 ! NAMELIST is input
   660:                 !
   661:                 if ( trim(namelist_filename) /= '' ) then
   662:                   call FileOpen( unit_nml, &          ! (out)
   663:                     & namelist_filename, mode = 'r' ) ! (in)
   664:             
   665:                   rewind( unit_nml )
   666:                   read( unit_nml,                          & ! (in)
   667:                     & nml = rad_Earth_SW_V2_6_nml,         & ! (out)
   668:                     & iostat = iostat_nml )                  ! (out)
   669:                   close( unit_nml )
   670:             
   671:                   call NmlutilMsg( iostat_nml, module_name ) ! (in)
   672:                 end if
   673:             
   674:             
   675:             
   676:                 ! Initialization of modules used in this module
   677:                 !
   678:             
   679:                 ! 太陽放射フラックスの設定
   680:                 ! Set solar constant
   681:                 !
   682:                 call SetSolarConstInit
   683:             
   684:                 ! 短波入射 (太陽入射)
   685:                 ! Short wave (insolation) incoming
   686:                 !
   687:                 call RadShortIncomeInit
   688:             
   689:                 !
   690:                 ! Solve radiative transfer equation in two stream approximation
   691:                 !
   692:                 call RadRTETwoStreamAppInit
   693:             
   694:                 ! Chou and Lee (1996) による短波放射モデル
   695:                 ! Short wave radiation model described by Chou and Lee (1996)
   696:                 !
   697:                 call RadCL1996Init
   698:             
   699:                 ! Chou et al (1998) による短波放射用雲モデル
   700:                 ! Cloud model for short wave radiation model described by Chou et al (1998)
   701:                 !
   702:                 call RadC1998Init
   703:             
   704:                 ! 雲関系ルーチン
   705:                 ! Cloud-related routines
   706:                 !
   707:                 call CloudUtilsInit( &
   708:                   & ArgFlagSnow            &
   709:                   & )
   710:             
   711:             
   712:                 ! 印字 ; Print
   713:                 !
   714:                 call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   715:                 call MessageNotify( 'M', module_name, 'FlagRayleighScattering = %b', l = (/ FlagRayleighScattering /) )
   716:                 call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   717:             
   718:             
   719:                 rad_Earth_SW_V2_6_inited = .true.
   720:             
   721:               end subroutine RadEarthSWV26Init
   722:             
   723:               !--------------------------------------------------------------------------------------
   724:             
   725:             end module rad_Earth_SW_V2_6
