Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:53 2016
FILE NAME: rad_Earth_V2.f90
PROGRAM NAME: rad_earth_v2
DIAGNOSTIC LIST

  LINE  LEVEL( NO.): DIAGNOSTIC MESSAGE

   177  opt  (1593): Loop nest collapsed into one loop.
   177  vec  (   1): Vectorized loop.
   177  vec  (  29): ADB is used for array.: xyz_delatmmass
   177  vec  (  29): ADB is used for array.: xyr_press
   547  opt  (1593): Loop nest collapsed into one loop.
   547  vec  (   4): Vectorized array expression.
   547  vec  (  29): ADB is used for array.: xyz_qco2
   556  opt  (1593): Loop nest collapsed into one loop.
   556  vec  (   4): Vectorized array expression.
   556  vec  (  29): ADB is used for array.: xyz_qn2o
   565  opt  (1593): Loop nest collapsed into one loop.
   565  vec  (   4): Vectorized array expression.
   565  vec  (  29): ADB is used for array.: xyz_qch4
   580  opt  (1593): Loop nest collapsed into one loop.
   580  vec  (   4): Vectorized array expression.
   580  vec  (  29): ADB is used for array.: xyz_cloudwatreff
   584  opt  (1592): Outer loop unrolled inside inner loop.
   584  vec  (   4): Vectorized array expression.
   584  vec  (  29): ADB is used for array.: xyz_cloudicereff
   584  vec  (   4): Vectorized array expression.
   584  vec  (  29): ADB is used for array.: xyz_cloudicereff
   588  opt  (  11): Fused array assignments. :line 588 - 593
   588  opt  (1593): Loop nest collapsed into one loop.
   588  vec  (   4): Vectorized array expression.
   588  vec  (  29): ADB is used for array.: xyz_cloudicereff
   588  vec  (  29): ADB is used for array.: xyz_temp
   597  opt  (  11): Fused array assignments. :line 597 - 603
   597  vec  (   4): Vectorized array expression.
   597  vec  (  29): ADB is used for array.: xyz_delch4mass
   597  vec  (  29): ADB is used for array.: xyz_qch4
   597  vec  (  29): ADB is used for array.: xyz_delatmmass
   597  vec  (  29): ADB is used for array.: xyz_deln2omass
   597  vec  (  29): ADB is used for array.: xyz_qn2o
   597  vec  (  29): ADB is used for array.: xyz_delo3mass
   597  vec  (  29): ADB is used for array.: xyz_qo3
   597  vec  (  29): ADB is used for array.: xyz_delh2osolmass
   597  vec  (  29): ADB is used for array.: xyz_qh2osol
   597  vec  (  29): ADB is used for array.: xyz_delh2oliqmass
   597  vec  (  29): ADB is used for array.: xyz_qh2oliq
   597  vec  (  29): ADB is used for array.: xyz_delh2ovapmass
   597  vec  (  29): ADB is used for array.: xyz_qh2ovap
   597  vec  (  29): ADB is used for array.: xyz_delco2mass
   597  vec  (  29): ADB is used for array.: xyz_qco2
   713  opt  (1593): Loop nest collapsed into one loop.
   713  vec  (   4): Vectorized array expression.
   713  vec  (  29): ADB is used for array.: xy_cloudcoverrand
   714  vec  (   3): Unvectorized loop.
   714  vec  (  13): Overhead of loop division is too large.
   715  opt  (1593): Loop nest collapsed into one loop.
   715  vec  (   4): Vectorized array expression.
   715  vec  (  29): ADB is used for array.: xy_cloudcoverrand
   715  vec  (  29): ADB is used for array.: xyz_cloudcover
   717  opt  (1593): Loop nest collapsed into one loop.
   717  vec  (   4): Vectorized array expression.
   717  vec  (  29): ADB is used for array.: xy_cloudcoverrand
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:53 2016
FILE NAME: rad_Earth_V2.f90
PROGRAM NAME: rad_earth_v2
TRANSFORMATION LIST

  LINE                   FORTRAN STATEMENT

     1  != 地球大気向け放射モデル Ver. 2
     2  !
     3  != radiation model for the Earth's atmosphere Ver. 2
     4  !
     5  ! Authors::   Yoshiyuki O. Takahashi
     6  ! Version::   $Id: rad_Earth_V2.f90,v 1.9 2015/01/29 12:06:43 yot Exp $
     7  ! Tag Name::  $Name:  $
     8  ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9  ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10  !
    11  module rad_Earth_V2
    12    !
    13    != 地球大気向け放射モデル Ver. 2
    14    !
    15    != radiation model for the Earth's atmosphere Ver. 1
    16    !
    17    ! <b>Note that Japanese and English are described in parallel.</b>
    18    !
    19    ! 地球大気向け放射モデル.
    20    !
    21    ! This is a radiation model for the Earth's atmospehre.
    22    !
    23    ! Radiation in the wavenumber range from    0 to  3000 cm-1
    24    ! is calculated in the routine of long wave radiation.
    25    ! Radiation in the wavenumber range from 1000 to 57143 cm-1 (0.175 to 10 micron)
    26    ! is calculated in the routine of shortwave radiation.
    27    !
    28    !== References
    29    !
    30    !
    31    !== Procedures List
    32    !
    33    ! RadEarthV2Flux :: 放射フラックスの計算
    34    ! ------------          :: ------------
    35    ! RadEarthV2Flux :: Calculate radiation flux
    36    !
    37    !== NAMELIST
    38    !
    39    ! NAMELIST#rad_Earth_V2_nml
    40    !
    41  
    42    ! USE statements
    43    !
    44  
    45    !
    46    ! Kind type parameter
    47    !
    48    use dc_types, only: DP, &      ! Double precision.
    49      &                 STRING, &  ! Strings.
    50      &                 TOKEN      ! Keywords.
    51  
    52    ! メッセージ出力
    53    ! Message output
    54    !
    55    use dc_message, only: MessageNotify
    56  
    57    !
    58    ! Physical constants settings
    59    !
    60    use constants, only: Grav     ! $ g $ [m s-2].
    61                                  !
    62                                  ! Gravitational acceleration
    63  
    64    ! 格子点設定
    65    ! Grid points settings
    66    !
    67    use gridset, only: imax, & ! 経度格子点数.
    68                               ! Number of grid points in longitude
    69      &                jmax, & ! 緯度格子点数.
    70                               ! Number of grid points in latitude
    71      &                kmax    ! 鉛直層数.
    72                               ! Number of vertical level
    73  
    74    implicit none
    75  
    76    private
    77  
    78    real(DP), save :: MeanMolWeight
    79    real(DP), save :: H2OMolWeight
    80    real(DP), save :: CO2MolWeight
    81    real(DP), save :: N2OMolWeight
    82    real(DP), save :: CH4MolWeight
    83  
    84    integer, save     :: IDCloudIceREffMethod
    85    !
    86    integer, parameter:: IDCloudIceREffMethodConst = 0
    87    integer, parameter:: IDCloudIceREffMethodLin   = 1
    88  
    89    real(DP), save :: CloudWatREff
    90    real(DP), save :: CloudIceREff
    91  
    92    real(DP), allocatable, save :: xyz_QO3(:,:,:)
    93                                ! O3 分布 (1)
    94                                ! O3 distribution (1)
    95  
    96  !!$  integer , save              :: SWVer
    97  !!$  integer , save              :: LWVer
    98  
    99    ! 公開変数
   100    ! Public variables
   101    !
   102    logical, save :: rad_Earth_V2_inited = .false.
   103                                ! 初期設定フラグ.
   104                                ! Initialization flag
   105  
   106    public :: RadEarthV2Flux
   107  !!$  public :: RadEarthV2FluxforNHM
   108    public :: RadEarthV2Init
   109  
   110    character(*), parameter:: module_name = 'rad_Earth_V2'
   111                                ! モジュールの名称.
   112                                ! Module name
   113    character(*), parameter:: version = &
   114      & '$Name:  $' // &
   115      & '$Id: rad_Earth_V2.f90,v 1.9 2015/01/29 12:06:43 yot Exp $'
   116                                ! モジュールのバージョン
   117                                ! Module version
   118  
   119    !--------------------------------------------------------------------------------------
   120  
   121  contains
   122  
   123    !--------------------------------------------------------------------------------------
   124  
   125    subroutine RadEarthV2Flux(                                                 &
   126      & xy_SurfAlbedo,                                                         & ! (in)
   127      & xyz_Press, xyr_Press, xyz_Temp, xyz_QH2OVap, xyz_QH2OLiq, xyz_QH2OSol, & ! (in)
   128      & xyz_CloudCover,                                                        & ! (in)
   129      & xy_SurfTemp,                                                           & ! (in)
   130      & xyr_RadSUwFlux, xyr_RadSDwFlux,                                        & ! (out)
   131      & xyr_RadLUwFlux, xyr_RadLDwFlux,                                        & ! (out)
   132      & xyra_DelRadLUwFlux, xyra_DelRadLDwFlux                                 & ! (out)
   133      & )
   134  
   135  
   136      ! USE statements
   137      !
   138  
   139      real(DP), intent(in ) :: xy_SurfAlbedo   (0:imax-1, 1:jmax)
   140      real(DP), intent(in ) :: xyz_Press       (0:imax-1, 1:jmax, 1:kmax)
   141      real(DP), intent(in ) :: xyr_Press       (0:imax-1, 1:jmax, 0:kmax)
   142      real(DP), intent(in ) :: xyz_Temp        (0:imax-1, 1:jmax, 1:kmax)
   143      real(DP), intent(in ) :: xyz_QH2OVap     (0:imax-1, 1:jmax, 1:kmax)
   144                                ! $ q $ .   混合比. Mass mixing ratio of constituents (1)
   145      real(DP), intent(in ) :: xyz_QH2OLiq     (0:imax-1, 1:jmax, 1:kmax)
   146      real(DP), intent(in ) :: xyz_QH2OSol     (0:imax-1, 1:jmax, 1:kmax)
   147      real(DP), intent(in ) :: xyz_CloudCover  (0:imax-1, 1:jmax, 1:kmax)
   148      real(DP), intent(in ) :: xy_SurfTemp     (0:imax-1, 1:jmax)
   149      real(DP), intent(out) :: xyr_RadSUwFlux   (0:imax-1, 1:jmax, 0:kmax)
   150      real(DP), intent(out) :: xyr_RadSDwFlux   (0:imax-1, 1:jmax, 0:kmax)
   151      real(DP), intent(out) :: xyr_RadLUwFlux    (0:imax-1, 1:jmax, 0:kmax)
   152      real(DP), intent(out) :: xyr_RadLDwFlux    (0:imax-1, 1:jmax, 0:kmax)
   153      real(DP), intent(out) :: xyra_DelRadLUwFlux(0:imax-1, 1:jmax, 0:kmax, 0:1)
   154      real(DP), intent(out) :: xyra_DelRadLDwFlux(0:imax-1, 1:jmax, 0:kmax, 0:1)
   155  
   156  !!$    real(DP):: xyr_RadLUwFlux    (0:imax-1, 1:jmax, 0:kmax)
   157  !!$    real(DP):: xyr_RadLDwFlux    (0:imax-1, 1:jmax, 0:kmax)
   158  !!$    real(DP):: xyra_DelRadLUwFlux(0:imax-1, 1:jmax, 0:kmax, 0:1)
   159  !!$    real(DP):: xyra_DelRadLDwFlux(0:imax-1, 1:jmax, 0:kmax, 0:1)
   160  
   161  
   162      ! Work variables
   163      !
   164      real(DP) :: xyz_DelAtmMass   (0:imax-1, 1:jmax, 1:kmax)
   165  
   166      integer  :: k
   167  
   168  
   169      ! 初期化確認
   170      ! Initialization check
   171      !
   172      if ( .not. rad_Earth_V2_inited ) then
   173        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   174      end if
   175  
   176  
   177      do k = 1, kmax
   178        xyz_DelAtmMass(:,:,k) = ( xyr_Press(:,:,k-1) - xyr_Press(:,:,k ) ) / Grav
   179      end do
     .        d1 = 1.D0/grav                                                    
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do k = 1, kmax*jmax*imax                                          
     .           xyz_delatmmass(k-1,1,1) = (xyr_press(k-1,1,0)-xyr_press(k-1,1,1
     .       1      ))*d1                                                       
     .        enddo                                                             
   180  
   181      call RadEarthV2FluxCore(                                                        &
   182        & xy_SurfAlbedo,                                                              &
   183        & xyz_DelAtmMass, xyz_Press, xyz_Temp, xyz_QH2OVap, xyz_QH2OLiq, xyz_QH2OSol, &
   184        & xyz_CloudCover,                                                             &
   185        & xy_SurfTemp,                                                                &
   186        & xyr_RadSUwFlux, xyr_RadSDwFlux,                                             &
   187        & xyr_RadLUwFlux, xyr_RadLDwFlux,                          & ! (out)
   188        & xyra_DelRadLUwFlux, xyra_DelRadLDwFlux                   & ! (out)
   189        & )
   190  
   191  
   192    end subroutine RadEarthV2Flux
   193  
   194    !--------------------------------------------------------------------------------------
   195  !!$
   196  !!$  subroutine RadEarthV2FluxforNHM(                                          &
   197  !!$    & r_Height, xy_SurfAlbedo,                                              &
   198  !!$    & xyz_Dens, xyz_Press, xyz_Temp, xyz_QH2OVap, xyz_QH2OLiq, xyz_QH2OSol, &
   199  !!$    & xy_SurfTemp,                                                          &
   200  !!$    & xyr_RadSFlux, xyr_RadLFlux, xyra_DelRadLFlux                          &
   201  !!$    & )
   202  !!$
   203  !!$
   204  !!$    ! USE statements
   205  !!$    !
   206  !!$
   207  !!$    real(DP), intent(in ) :: r_Height                          (0:kmax)
   208  !!$    real(DP), intent(in ) :: xy_SurfAlbedo   (0:imax-1, 1:jmax)
   209  !!$    real(DP), intent(in ) :: xyz_Dens        (0:imax-1, 1:jmax, 1:kmax)
   210  !!$    real(DP), intent(in ) :: xyz_Press       (0:imax-1, 1:jmax, 1:kmax)
   211  !!$    real(DP), intent(in ) :: xyz_Temp        (0:imax-1, 1:jmax, 1:kmax)
   212  !!$    real(DP), intent(in ) :: xyz_QH2OVap     (0:imax-1, 1:jmax, 1:kmax)
   213  !!$                              ! $ q $ .   混合比. Mass mixing ratio of constituents (1)
   214  !!$    real(DP), intent(in ) :: xyz_QH2OLiq     (0:imax-1, 1:jmax, 1:kmax)
   215  !!$    real(DP), intent(in ) :: xyz_QH2OSol     (0:imax-1, 1:jmax, 1:kmax)
   216  !!$    real(DP), intent(in ) :: xy_SurfTemp     (0:imax-1, 1:jmax)
   217  !!$    real(DP), intent(out) :: xyr_RadSFlux    (0:imax-1, 1:jmax, 0:kmax)
   218  !!$    real(DP), intent(out) :: xyr_RadLFlux    (0:imax-1, 1:jmax, 0:kmax)
   219  !!$    real(DP), intent(out) :: xyra_DelRadLFlux(0:imax-1, 1:jmax, 0:kmax, 0:1)
   220  !!$
   221  !!$
   222  !!$    ! Work variables
   223  !!$    !
   224  !!$    real(DP) :: xyz_DelAtmMass   (0:imax-1, 1:jmax, 1:kmax)
   225  !!$
   226  !!$    integer  :: k
   227  !!$
   228  !!$
   229  !!$    ! 初期化確認
   230  !!$    ! Initialization check
   231  !!$    !
   232  !!$    if ( .not. rad_Earth_V2_inited ) then
   233  !!$      call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   234  !!$    end if
   235  !!$
   236  !!$
   237  !!$    do k = 1, kmax
   238  !!$      xyz_DelAtmMass(:,:,k) = xyz_Dens(:,:,k) * ( r_Height(k) - r_Height(k-1) )
   239  !!$    end do
   240  !!$
   241  !!$    call RadEarthV2FluxCore(                                                        &
   242  !!$      & xy_SurfAlbedo,                                                              &
   243  !!$      & xyz_DelAtmMass, xyz_Press, xyz_Temp, xyz_QH2OVap, xyz_QH2OLiq, xyz_QH2OSol, &
   244  !!$      & xy_SurfTemp,                                                                &
   245  !!$      & xyr_RadSFlux, xyr_RadLFlux, xyra_DelRadLFlux                                &
   246  !!$      & )
   247  !!$
   248  !!$
   249  !!$  end subroutine RadEarthV2FluxforNHM
   250  !!$
   251    !--------------------------------------------------------------------------------------
   252  !!$
   253  !!$  subroutine RadDcpamEV2FluxforNHM2DWrapper(                    &
   254  !!$    & r_Height, x_SurfAlbedo,                                   &
   255  !!$    & xz_Dens, xz_Press, xz_Temp, xz_QH2OVap, xz_QH2OLiq,       &
   256  !!$    & x_SurfTemp,                                               &
   257  !!$    & xr_RadSFlux, xr_RadLFlux, xra_DelRadLFlux                 &
   258  !!$    & )
   259  !!$
   260  !!$
   261  !!$    ! USE statements
   262  !!$    !
   263  !!$
   264  !!$
   265  !!$    real(DP), intent(in ) :: r_Height                 (0:kmax)
   266  !!$    real(DP), intent(in ) :: x_SurfAlbedo   (0:imax-1)
   267  !!$    real(DP), intent(in ) :: xz_Dens        (0:imax-1, 1:kmax)
   268  !!$    real(DP), intent(in ) :: xz_Press       (0:imax-1, 1:kmax)
   269  !!$    real(DP), intent(in ) :: xz_Temp        (0:imax-1, 1:kmax)
   270  !!$    real(DP), intent(in ) :: xz_QH2OVap     (0:imax-1, 1:kmax)
   271  !!$    real(DP), intent(in ) :: xz_QH2OLiq     (0:imax-1, 1:kmax)
   272  !!$    real(DP), intent(in ) :: x_SurfTemp     (0:imax-1)
   273  !!$    real(DP), intent(out) :: xr_RadSFlux    (0:imax-1, 0:kmax)
   274  !!$    real(DP), intent(out) :: xr_RadLFlux    (0:imax-1, 0:kmax)
   275  !!$    real(DP), intent(out) :: xra_DelRadLFlux(0:imax-1, 0:kmax, 0:1)
   276  !!$
   277  !!$
   278  !!$    ! Work variables
   279  !!$    !
   280  !!$    real(DP) :: xy_SurfAlbedo   (0:imax-1, 1:jmax)
   281  !!$    real(DP) :: xyz_Dens        (0:imax-1, 1:jmax, 1:kmax)
   282  !!$    real(DP) :: xyz_Press       (0:imax-1, 1:jmax, 1:kmax)
   283  !!$    real(DP) :: xyz_Temp        (0:imax-1, 1:jmax, 1:kmax)
   284  !!$    real(DP) :: xyz_QH2OVap     (0:imax-1, 1:jmax, 1:kmax)
   285  !!$    real(DP) :: xyz_QH2OLiq     (0:imax-1, 1:jmax, 1:kmax)
   286  !!$    real(DP) :: xy_SurfTemp     (0:imax-1, 1:jmax)
   287  !!$    real(DP) :: xyr_RadSFlux    (0:imax-1, 1:jmax, 0:kmax)
   288  !!$    real(DP) :: xyr_RadLFlux    (0:imax-1, 1:jmax, 0:kmax)
   289  !!$    real(DP) :: xyra_DelRadLFlux(0:imax-1, 1:jmax, 0:kmax, 0:1)
   290  !!$
   291  !!$    integer  :: k
   292  !!$
   293  !!$
   294  !!$    ! 初期化確認
   295  !!$    ! Initialization check
   296  !!$    !
   297  !!$    if ( .not. rad_dcpam_E_V2_inited ) then
   298  !!$      call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   299  !!$    end if
   300  !!$
   301  !!$
   302  !!$    if ( jmax /= 1 ) then
   303  !!$      call MessageNotify( 'E', module_name, 'jmax must be 1.' )
   304  !!$    end if
   305  !!$
   306  !!$
   307  !!$    xy_SurfAlbedo   (:, 1)       = x_SurfAlbedo   (:)
   308  !!$    do k = 1, kmax
   309  !!$      xyz_Dens        (:, 1, k)    = xz_Dens        (:, k)
   310  !!$      xyz_Press       (:, 1, k)    = xz_Press       (:, k)
   311  !!$      xyz_Temp        (:, 1, k)    = xz_Temp        (:, k)
   312  !!$      xyz_QH2OVap     (:, 1, k)    = xz_QH2OVap     (:, k)
   313  !!$      xyz_QH2OLiq     (:, 1, k)    = xz_QH2OLiq     (:, k)
   314  !!$    end do
   315  !!$    xy_SurfTemp     (:, 1)       = x_SurfTemp     (:)
   316  !!$
   317  !!$    call RadDcpamEV2FluxforNHM(                                       &
   318  !!$      & r_Height, xy_SurfAlbedo,                                      &
   319  !!$      & xyz_Dens, xyz_Press, xyz_Temp, xyz_QH2OVap, xyz_QH2OLiq,      &
   320  !!$      & xy_SurfTemp,                                                  &
   321  !!$      & xyr_RadSFlux, xyr_RadLFlux, xyra_DelRadLFlux                  &
   322  !!$      & )
   323  !!$
   324  !!$    xr_RadSFlux    (:, :)    = xyr_RadSFlux    (:, 1, :)
   325  !!$    xr_RadLFlux    (:, :)    = xyr_RadLFlux    (:, 1, :)
   326  !!$    xra_DelRadLFlux(:, :, :) = xyra_DelRadLFlux(:, 1, :, :)
   327  !!$
   328  !!$
   329  !!$  end subroutine RadDcpamEV2FluxforNHM2DWrapper
   330  !!$
   331    !--------------------------------------------------------------------------------------
   332  !!$
   333  !!$  subroutine RadDcpamEV2Flux2DWrapper(                         &
   334  !!$    & x_SurfAlbedo,                                            &
   335  !!$    & xz_Press, xr_Press, xz_Temp, xz_QH2OVap, xz_QH2OLiq,     &
   336  !!$    & x_SurfTemp,                                              &
   337  !!$    & xr_RadSFlux, xr_RadLFlux, xra_DelRadLFlux                &
   338  !!$    & )
   339  !!$
   340  !!$
   341  !!$    ! USE statements
   342  !!$    !
   343  !!$
   344  !!$
   345  !!$
   346  !!$    real(DP), intent(in ) :: x_SurfAlbedo   (0:imax-1)
   347  !!$    real(DP), intent(in ) :: xz_Press       (0:imax-1, 1:kmax)
   348  !!$    real(DP), intent(in ) :: xr_Press       (0:imax-1, 0:kmax)
   349  !!$    real(DP), intent(in ) :: xz_Temp        (0:imax-1, 1:kmax)
   350  !!$    real(DP), intent(in ) :: xz_QH2OVap     (0:imax-1, 1:kmax)
   351  !!$    real(DP), intent(in ) :: xz_QH2OLiq     (0:imax-1, 1:kmax)
   352  !!$    real(DP), intent(in ) :: x_SurfTemp     (0:imax-1)
   353  !!$    real(DP), intent(out) :: xr_RadSFlux    (0:imax-1, 0:kmax)
   354  !!$    real(DP), intent(out) :: xr_RadLFlux    (0:imax-1, 0:kmax)
   355  !!$    real(DP), intent(out) :: xra_DelRadLFlux(0:imax-1, 0:kmax, 0:1)
   356  !!$
   357  !!$
   358  !!$    ! Work variables
   359  !!$    !
   360  !!$    real(DP) :: xy_SurfAlbedo   (0:imax-1, 1:jmax)
   361  !!$    real(DP) :: xyz_Press       (0:imax-1, 1:jmax, 1:kmax)
   362  !!$    real(DP) :: xyr_Press       (0:imax-1, 1:jmax, 0:kmax)
   363  !!$    real(DP) :: xyz_Temp        (0:imax-1, 1:jmax, 1:kmax)
   364  !!$    real(DP) :: xyz_QH2OVap     (0:imax-1, 1:jmax, 1:kmax)
   365  !!$    real(DP) :: xyz_QH2OLiq     (0:imax-1, 1:jmax, 1:kmax)
   366  !!$    real(DP) :: xy_SurfTemp     (0:imax-1, 1:jmax)
   367  !!$    real(DP) :: xyr_RadSFlux    (0:imax-1, 1:jmax, 0:kmax)
   368  !!$    real(DP) :: xyr_RadLFlux    (0:imax-1, 1:jmax, 0:kmax)
   369  !!$    real(DP) :: xyra_DelRadLFlux(0:imax-1, 1:jmax, 0:kmax, 0:1)
   370  !!$
   371  !!$
   372  !!$    ! 初期化確認
   373  !!$    ! Initialization check
   374  !!$    !
   375  !!$    if ( .not. rad_dcpam_E_V2_inited ) then
   376  !!$      call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   377  !!$    end if
   378  !!$
   379  !!$
   380  !!$    if ( jmax /= 1 ) then
   381  !!$      call MessageNotify( 'E', module_name, 'jmax must be 1.' )
   382  !!$    end if
   383  !!$
   384  !!$
   385  !!$    xy_SurfAlbedo   (:, 1)       = x_SurfAlbedo   (:)
   386  !!$    xyz_Press       (:, 1, :)    = xz_Press       (:, :)
   387  !!$    xyr_Press       (:, 1, :)    = xr_Press       (:, :)
   388  !!$    xyz_Temp        (:, 1, :)    = xz_Temp        (:, :)
   389  !!$    xyz_QH2OVap     (:, 1, :)    = xz_QH2OVap     (:, :)
   390  !!$    xyz_QH2OLiq     (:, 1, :)    = xz_QH2OLiq     (:, :)
   391  !!$    xy_SurfTemp     (:, 1)       = x_SurfTemp     (:)
   392  !!$
   393  !!$    call RadDcpamEV2Flux(                                             &
   394  !!$      & xy_SurfAlbedo,                                                &
   395  !!$      & xyz_Press, xyr_Press, xyz_Temp, xyz_QH2OVap, xyz_QH2OLiq,     &
   396  !!$      & xy_SurfTemp,                                                  &
   397  !!$      & xyr_RadSFlux, xyr_RadLFlux, xyra_DelRadLFlux                  &
   398  !!$      & )
   399  !!$
   400  !!$    xr_RadSFlux    (:, :)    = xyr_RadSFlux    (:, 1, :)
   401  !!$    xr_RadLFlux    (:, :)    = xyr_RadLFlux    (:, 1, :)
   402  !!$    xra_DelRadLFlux(:, :, :) = xyra_DelRadLFlux(:, 1, :, :)
   403  !!$
   404  !!$
   405  !!$  end subroutine RadDcpamEV2Flux2DWrapper
   406  !!$
   407    !--------------------------------------------------------------------------------------
   408  
   409    subroutine RadEarthV2FluxCore(                                                  &
   410      & xy_SurfAlbedo,                                                              &
   411      & xyz_DelAtmMass, xyz_Press, xyz_Temp, xyz_QH2OVap, xyz_QH2OLiq, xyz_QH2OSol, &
   412      & xyz_CloudCover,                                                             &
   413      & xy_SurfTemp,                                                                &
   414      & xyr_RadSUwFlux, xyr_RadSDwFlux,                                             &
   415      & xyr_RadLUwFlux, xyr_RadLDwFlux,                          & ! (out)
   416      & xyra_DelRadLUwFlux, xyra_DelRadLDwFlux                   & ! (out)
   417      & )
   418  
   419  
   420      ! USE statements
   421      !
   422  
   423      ! ヒストリデータ出力
   424      ! History data output
   425      !
   426      use gtool_historyauto, only: HistoryAutoPut
   427  
   428      ! 時刻管理
   429      ! Time control
   430      !
   431      use timeset, only: &
   432        & TimeN                 ! ステップ $ t $ の時刻.
   433                                ! Time of step $ t $.
   434  
   435      ! 全球一定体積混合比の設定
   436      ! Set globally constant volume mixing ratio
   437      !
   438      use set_gcmr, only : SetGCMR
   439  
   440      ! O3 分布の設定
   441      ! Set O3 distribution
   442      !
   443      use set_o3, only: SetO3
   444  
   445  !!$    ! dcpam 地球大気向け短波放射モデル Ver. 2
   446  !!$    ! dcpam short wave radiation model for the Earth's atmosphere Ver. 2
   447  !!$    !
   448  !!$    use radiation_dcpam_E_SW_V2, only: RadiationDcpamESWV2Flux
   449  
   450  !!$    ! 地球大気向け短波放射モデル Ver. 2.1
   451  !!$    ! short wave radiation model for the Earth's atmosphere Ver. 2.1
   452  !!$    !
   453  !!$    use rad_Earth_SW_V2_1, only: RadEarthSWV21Flux
   454  !!$
   455  !!$    ! 地球大気向け短波放射モデル Ver. 2.2
   456  !!$    ! short wave radiation model for the Earth's atmosphere Ver. 2.2
   457  !!$    !
   458  !!$    use rad_Earth_SW_V2_2, only: RadEarthSWV22Flux
   459  
   460      ! 地球大気向け短波放射モデル Ver. 2.6
   461      ! short wave radiation model for the Earth's atmosphere Ver. 2.6
   462      !
   463      use rad_Earth_SW_V2_6, only: RadEarthSWV26Flux
   464  
   465  !!$    ! dcpam 地球大気向け長波放射モデル Ver. 2
   466  !!$    ! dcpam long wave radiation model for the Earth's atmosphere Ver. 2
   467  !!$    !
   468  !!$    use radiation_dcpam_E_LW_V2, only : RadiationDcpamELWV2Flux
   469  !!$
   470  !!$    ! dcpam 地球大気向け長波放射モデル Ver. 2.1
   471  !!$    ! dcpam long wave radiation model for the Earth's atmosphere Ver. 2.1
   472  !!$    !
   473  !!$    use radiation_dcpam_E_LW_V2_1, only : RadiationDcpamELWV21Flux
   474  !!$
   475  !!$    ! dcpam 地球大気向け長波放射モデル Ver. 2.2
   476  !!$    ! dcpam long wave radiation model for the Earth's atmosphere Ver. 2.2
   477  !!$    !
   478  !!$    use radiation_dcpam_E_LW_V2_2, only : RadiationDcpamELWV22Flux
   479  !!$
   480  !!$    ! 地球大気向け長波放射モデル Ver. 2.3
   481  !!$    ! long wave radiation model for the Earth's atmosphere Ver. 2.3
   482  !!$    !
   483  !!$    use rad_Earth_LW_V2_3, only : RadEarthLWV23Flux
   484  !!$
   485      ! 地球大気向け長波放射モデル Ver. 2.4
   486      ! long wave radiation model for the Earth's atmosphere Ver. 2.4
   487      !
   488      use rad_Earth_LW_V2_4, only : RadEarthLWV24Flux
   489  
   490  
   491      real(DP), intent(in ) :: xy_SurfAlbedo   (0:imax-1, 1:jmax)
   492      real(DP), intent(in ) :: xyz_DelAtmMass  (0:imax-1, 1:jmax, 1:kmax)
   493      real(DP), intent(in ) :: xyz_Press       (0:imax-1, 1:jmax, 1:kmax)
   494      real(DP), intent(in ) :: xyz_Temp        (0:imax-1, 1:jmax, 1:kmax)
   495      real(DP), intent(in ) :: xyz_QH2OVap     (0:imax-1, 1:jmax, 1:kmax)
   496                                ! $ q $ .   混合比. Mass mixing ratio of constituents (1)
   497      real(DP), intent(in ) :: xyz_QH2OLiq     (0:imax-1, 1:jmax, 1:kmax)
   498      real(DP), intent(in ) :: xyz_QH2OSol     (0:imax-1, 1:jmax, 1:kmax)
   499      real(DP), intent(in ) :: xyz_CloudCover  (0:imax-1, 1:jmax, 1:kmax)
   500      real(DP), intent(in ) :: xy_SurfTemp     (0:imax-1, 1:jmax)
   501      real(DP), intent(out) :: xyr_RadSUwFlux    (0:imax-1, 1:jmax, 0:kmax)
   502      real(DP), intent(out) :: xyr_RadSDwFlux    (0:imax-1, 1:jmax, 0:kmax)
   503      real(DP), intent(out) :: xyr_RadLUwFlux    (0:imax-1, 1:jmax, 0:kmax)
   504      real(DP), intent(out) :: xyr_RadLDwFlux    (0:imax-1, 1:jmax, 0:kmax)
   505      real(DP), intent(out) :: xyra_DelRadLUwFlux(0:imax-1, 1:jmax, 0:kmax, 0:1)
   506      real(DP), intent(out) :: xyra_DelRadLDwFlux(0:imax-1, 1:jmax, 0:kmax, 0:1)
   507  
   508  
   509      ! Work variables
   510      !
   511      real(DP) :: VMRCO2
   512      real(DP) :: xyz_QCO2         (0:imax-1, 1:jmax, 1:kmax)
   513      real(DP) :: VMRN2O
   514      real(DP) :: xyz_QN2O         (0:imax-1, 1:jmax, 1:kmax)
   515      real(DP) :: VMRCH4
   516      real(DP) :: xyz_QCH4         (0:imax-1, 1:jmax, 1:kmax)
   517  
   518      real(DP) :: xyz_DelCO2Mass   (0:imax-1, 1:jmax, 1:kmax)
   519      real(DP) :: xyz_DelH2OVapMass(0:imax-1, 1:jmax, 1:kmax)
   520      real(DP) :: xyz_DelH2OLiqMass(0:imax-1, 1:jmax, 1:kmax)
   521      real(DP) :: xyz_DelH2OSolMass(0:imax-1, 1:jmax, 1:kmax)
   522      real(DP) :: xyz_DelO3Mass    (0:imax-1, 1:jmax, 1:kmax)
   523      real(DP) :: xyz_DelN2OMass   (0:imax-1, 1:jmax, 1:kmax)
   524      real(DP) :: xyz_DelCH4Mass   (0:imax-1, 1:jmax, 1:kmax)
   525  
   526      real(DP) :: xyz_CloudWatREff (0:imax-1, 1:jmax, 1:kmax)
   527      real(DP) :: xyz_CloudIceREff (0:imax-1, 1:jmax, 1:kmax)
   528  
   529      real(DP) :: xy_CloudCoverRand(0:imax-1, 1:jmax)
   530  
   531      integer :: k
   532  
   533      ! 初期化確認
   534      ! Initialization check
   535      !
   536      if ( .not. rad_Earth_V2_inited ) then
   537        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   538      end if
   539  
   540      ! 全球一定体積混合比の設定
   541      ! Set globally constant volume mixing ratio
   542      !
   543      call SetGCMR( &
   544        & 'CO2',    & ! (in)
   545        & VMRCO2    & ! (out)
   546        & )
   547      xyz_QCO2 = VMRCO2 * CO2MolWeight / MeanMolWeight
     .        d1 = vmrco2/meanmolweight                                         
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t533 = 1, xyz_qco2.DSC.U3*(xyz_qco2.DSC.U2*xyz_qco2.DSC.U1 +   
     .       1   xyz_qco2.DSC.U2)                                               
     .           xyz_qco2(t533-1,1,1) = co2molweight*d1                         
     .        enddo                                                             
   548  
   549      ! 全球一定体積混合比の設定
   550      ! Set globally constant volume mixing ratio
   551      !
   552      call SetGCMR( &
   553        & 'N2O',    & ! (in)
   554        & VMRN2O    & ! (out)
   555        & )
   556      xyz_QN2O = VMRN2O * N2OMolWeight / MeanMolWeight
     .        d2 = vmrn2o/meanmolweight                                         
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t542 = 1, xyz_qn2o.DSC.U3*(xyz_qn2o.DSC.U2*xyz_qn2o.DSC.U1 +   
     .       1   xyz_qn2o.DSC.U2)                                               
     .           xyz_qn2o(t542-1,1,1) = n2omolweight*d2                         
     .        enddo                                                             
   557  
   558      ! 全球一定体積混合比の設定
   559      ! Set globally constant volume mixing ratio
   560      !
   561      call SetGCMR( &
   562        & 'CH4',    & ! (in)
   563        & VMRCH4    & ! (out)
   564        & )
   565      xyz_QCH4 = VMRCH4 * CH4MolWeight / MeanMolWeight
     .        d3 = vmrch4/meanmolweight                                         
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t551 = 1, xyz_qch4.DSC.U3*(xyz_qch4.DSC.U2*xyz_qch4.DSC.U1 +   
     .       1   xyz_qch4.DSC.U2)                                               
     .           xyz_qch4(t551-1,1,1) = ch4molweight*d3                         
     .        enddo                                                             
   566  
   567  
   568      ! O3 分布の設定
   569      ! Setting of O3 distribution
   570      !
   571      call SetO3( &
   572        & xyz_Press, & ! (in )
   573        & xyz_QO3    & ! (out)
   574        & )
   575  
   576  
   577      !
   578      ! Set cloud effective radius
   579      !
   580      xyz_CloudWatREff = CloudWatREff
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t560 = 1, xyz_cloudwatreff.DSC.U3*(xyz_cloudwatreff.DSC.U2*    
     .       1   xyz_cloudwatreff.DSC.U1 + xyz_cloudwatreff.DSC.U2)             
     .           xyz_cloudwatreff(t560-1,1,1) = cloudwatreff                    
     .        enddo                                                             
   581      !
   582      select case ( IDCloudIceREffMethod )
   583      case ( IDCloudIceREffMethodConst )
   584        xyz_CloudIceREff = CloudIceREff
     .        if (1 + xyz_cloudicereff.DSC.U2 - min0(1,xyz_cloudicereff.DSC.U2) 
     .       1   .gt. 0) then                                                   
     .           j1 = and(1 + xyz_cloudicereff.DSC.U2 - min0(1,                 
     .       1      xyz_cloudicereff.DSC.U2),3)                                 
     .  !cdir    nodep                                                          
     .           do t682 = 1, j1                                                
     .  !cdir       nodep                                                       
     .              do t684 = 1, xyz_cloudicereff.DSC.U1 + 2 - min0(1,          
     .       1         xyz_cloudicereff.DSC.U1 + 1)                             
     .                 xyz_cloudicereff(t684-1,t682,t680+1) = cloudicereff      
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t682 = j1 + 1, 1 + xyz_cloudicereff.DSC.U2 - min0(1,        
     .       1      xyz_cloudicereff.DSC.U2), 4                                 
     .  !cdir       nodep                                                       
     .              do t684 = 1, xyz_cloudicereff.DSC.U1 + 2 - min0(1,          
     .       1         xyz_cloudicereff.DSC.U1 + 1)                             
     .                 xyz_cloudicereff(t684-1,t682,t680+1) = cloudicereff      
     .                 xyz_cloudicereff(t684-1,t682+1,t680+1) = cloudicereff    
     .                 xyz_cloudicereff(t684-1,t682+2,t680+1) = cloudicereff    
     .                 xyz_cloudicereff(t684-1,t682+3,t680+1) = cloudicereff    
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
   585      case ( IDCloudIceREffMethodLin )
   586        ! This is a simple model mimicing a result of Ou and Liou (1995).
   587        ! This was used in MRI model probably.
   588        xyz_CloudIceREff = &
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t662 = 1, kmax*jmax*imax                                       
     .           xyz_cloudicereff1 = 3.24999999999999e-006*(xyz_temp(t662-1,1,1)
     .       1      -2.53149999999999e+002) + 1.49999999999999e-004             
     .           xyz_cloudicereff(t662-1,1,1) = min(max(xyz_cloudicereff1,      
     .       1      2.00000000000000e-005),1.49999999999999e-004)               
     .        enddo                                                             
   589          &   ( 20.0e-6_DP              - 150.0e-6_DP             ) &
   590          & / ( ( 273.15_DP - 60.0_DP ) - ( 273.15_DP - 20.0_DP ) ) &
   591          & * ( xyz_Temp                - ( 273.15_DP - 20.0_DP ) ) &
   592          & + 150.0e-6_DP
   593        xyz_CloudIceREff = min( max( xyz_CloudIceREff, 20.0e-6_DP ), 150.0e-6_DP )
   594      end select
   595  
   596  
   597      xyz_DelCO2Mass    = xyz_DelAtmMass * xyz_QCO2
   598      xyz_DelH2OVapMass = xyz_DelAtmMass * xyz_QH2OVap
   599      xyz_DelH2OLiqMass = xyz_DelAtmMass * xyz_QH2OLiq
   600      xyz_DelH2OSolMass = xyz_DelAtmMass * xyz_QH2OSol
   601      xyz_DelO3Mass     = xyz_DelAtmMass * xyz_QO3
   602      xyz_DelN2OMass    = xyz_DelAtmMass * xyz_QN2O
   603      xyz_DelCH4Mass    = xyz_DelAtmMass * xyz_QCH4
   604  
   605  
   606  !!$    select case ( SWVer )
   607  !!$    case ( 0 )
   608  !!$      ! dcpam 地球大気向け短波放射モデル Ver. 2
   609  !!$      ! dcpam short wave radiation model for the Earth's atmosphere Ver. 2
   610  !!$      !
   611  !!$      call RadiationDcpamESWV2Flux(                                 &
   612  !!$        & xy_SurfAlbedo,                                                  &
   613  !!$        & xyz_Press, xyr_Press, xyz_Temp, xyz_QH2OVap, xyz_QO3, xyz_Height,  &
   614  !!$        & xyr_RadSFlux                                                    &
   615  !!$        & )
   616  !!$    case ( 1 )
   617  !!$      ! 地球大気向け短波放射モデル Ver. 2.1
   618  !!$      ! short wave radiation model for the Earth's atmosphere Ver. 2.1
   619  !!$      !
   620  !!$      call RadEarthSWV21Flux(                                      &
   621  !!$        & xy_SurfAlbedo,                                           &
   622  !!$        & xyz_DelAtmMass,                                          &
   623  !!$        & xyz_DelH2OVapMass, xyz_DelH2OLiqMass, xyz_DelH2OSolMass, &
   624  !!$        & xyz_DelO3Mass,                                           &
   625  !!$        & xyz_Press, xyz_Temp,                                     &
   626  !!$        & xyz_CloudCover,                                          &
   627  !!$        & xyr_RadSUwFlux, xyr_RadSDwFlux                           &
   628  !!$        & )
   629  !!$    case ( 2 )
   630  !!$      ! 地球大気向け短波放射モデル Ver. 2.2
   631  !!$      ! short wave radiation model for the Earth's atmosphere Ver. 2.2
   632  !!$      !
   633  !!$      call RadEarthSWV22Flux(                                      &
   634  !!$        & xy_SurfAlbedo,                                           &
   635  !!$        & xyz_DelAtmMass,                                          &
   636  !!$        & xyz_DelH2OVapMass, xyz_DelH2OLiqMass, xyz_DelH2OSolMass, &
   637  !!$        & xyz_DelO3Mass,                                           &
   638  !!$        & xyz_Press, xyz_Temp,                                     &
   639  !!$        & xyz_CloudCover,                                          &
   640  !!$        & xyr_RadSUwFlux, xyr_RadSDwFlux                           &
   641  !!$        & )
   642  !!$    case ( 6 )
   643        ! 地球大気向け短波放射モデル Ver. 2.6
   644        ! short wave radiation model for the Earth's atmosphere Ver. 2.6
   645        !
   646        call RadEarthSWV26Flux(                                      &
   647          & xy_SurfAlbedo,                                           &
   648          & xyz_DelAtmMass,                                          &
   649          & xyz_DelH2OVapMass, xyz_DelH2OLiqMass, xyz_DelH2OSolMass, &
   650          & xyz_DelO3Mass,                                           &
   651          & xyz_Press, xyz_Temp,                                     &
   652          & xyz_CloudCover,                                          &
   653          & xyz_CloudWatREff, xyz_CloudIceREff,                      &
   654          & xyr_RadSUwFlux, xyr_RadSDwFlux                           &
   655          & )
   656  !!$    case default
   657  !!$      call MessageNotify( 'E', module_name, 'SW model version %d is not supported.', i = (/ LWVer /) )
   658  !!$    end select
   659  
   660  !!$    select case ( LWVer )
   661  !!$    case ( 0 )
   662  !!$      call RadiationDcpamELWV2Flux( &
   663  !!$        & xyz_Press, xyr_Press, xyz_Temp, xy_SurfTemp,                    & ! (in )
   664  !!$        & xyz_QH2OVap, xyz_QO3,                                           & ! (in )
   665  !!$        & xyr_RadLFlux, xyra_DelRadLFlux                                  & ! (out)
   666  !!$        & )
   667  !!$    case ( 1 )
   668  !!$      call RadiationDcpamELWV21Flux( &
   669  !!$        & xyz_Press, xyr_Press, xyz_Temp, xy_SurfTemp,                    & ! (in )
   670  !!$        & xyz_QH2OVap, xyz_QO3,                                           & ! (in )
   671  !!$        & xyr_RadLFlux, xyra_DelRadLFlux                                  & ! (out)
   672  !!$        & )
   673  !!$    case ( 2 )
   674  !!$      call RadiationDcpamELWV22Flux( &
   675  !!$        & xyz_Press, xyr_Press, xyz_Temp, xy_SurfTemp,                    & ! (in )
   676  !!$        & xyz_QH2OVap, xyz_QO3,                                           & ! (in )
   677  !!$        & xyr_RadLFlux, xyra_DelRadLFlux                                  & ! (out)
   678  !!$        & )
   679  !!$    case ( 3 )
   680  !!$      call RadEarthLWV23Flux(                                      &
   681  !!$        & xyz_DelCO2Mass,                                          &
   682  !!$        & xyz_DelH2OVapMass, xyz_DelH2OLiqMass, xyz_DelH2OSolMass, &
   683  !!$        & xyz_DelO3Mass,                                           &
   684  !!$        & xyz_Press, xyz_Temp, xy_SurfTemp,                        & ! (in )
   685  !!$        & xyz_QCO2, xyz_QH2OVap,                                   & ! (in )
   686  !!$        & xyz_CloudCover,                                          & ! (in )
   687  !!$        & xyr_RadLUwFlux, xyr_RadLDwFlux,                          & ! (out)
   688  !!$        & xyra_DelRadLUwFlux, xyra_DelRadLDwFlux                   & ! (out)
   689  !!$        & )
   690  !!$    case ( 4 )
   691        call RadEarthLWV24Flux(                                      &
   692          & xyz_DelCO2Mass,                                          &
   693          & xyz_DelH2OVapMass, xyz_DelH2OLiqMass, xyz_DelH2OSolMass, &
   694          & xyz_DelO3Mass,                                           &
   695          & xyz_DelN2OMass, xyz_DelCH4Mass,                          &
   696          & xyz_Press, xyz_Temp, xy_SurfTemp,                        & ! (in )
   697          & xyz_QCO2, xyz_QH2OVap,                                   & ! (in )
   698          & xyz_QN2O, xyz_QCH4,                                      & ! (in )
   699          & xyz_CloudCover,                                          & ! (in )
   700          & xyz_CloudWatREff, xyz_CloudIceREff,                      & ! (in )
   701          & xyr_RadLUwFlux, xyr_RadLDwFlux,                          & ! (out)
   702          & xyra_DelRadLUwFlux, xyra_DelRadLDwFlux                   & ! (out)
   703          & )
   704  !!$    case default
   705  !!$      call MessageNotify( 'E', module_name, 'LW model version %d is not supported.', i = (/ LWVer /) )
   706  !!$    end select
   707  
   708  
   709      ! Output variables
   710      !
   711      call HistoryAutoPut( TimeN, 'CloudCoverforRad', xyz_CloudCover )
   712      !
   713      xy_CloudCoverRand = 1.0_DP
     .  !cdir    nodep                                                          
     .  !cdir noassume                                                          
     .        do t638 = 1, xy_cloudcoverrand.DSC.U2*xy_cloudcoverrand.DSC.U1 +  
     .       1   xy_cloudcoverrand.DSC.U2                                       
     .           xy_cloudcoverrand(t638-1,1) = 1.00000000000000e+000            
     .        enddo                                                             
   714      do k = 1, kmax
   715        xy_CloudCoverRand = xy_CloudCoverRand * ( 1.0_DP - xyz_CloudCover(:,:,k) )
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xy_cloudcoverrand)                                         
     .        do t644 = 1, xy_cloudcoverrand.DSC.U2*xy_cloudcoverrand.DSC.U1 +  
     .       1   xy_cloudcoverrand.DSC.U2                                       
     .           xy_cloudcoverrand(t644-1,1) = xy_cloudcoverrand(t644-1,1)*(    
     .       1      1.00000000000000e+000 - xyz_cloudcover(t644-1,1,k))         
     .        enddo                                                             
   716      end do
   717      xy_CloudCoverRand = 1.0_DP - xy_CloudCoverRand
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xy_cloudcoverrand)                                         
     .        do t654 = 1, xy_cloudcoverrand.DSC.U2*xy_cloudcoverrand.DSC.U1 +  
     .       1   xy_cloudcoverrand.DSC.U2                                       
     .           xy_cloudcoverrand(t654-1,1) = 1.00000000000000e+000 -          
     .       1      xy_cloudcoverrand(t654-1,1)                                 
     .        enddo                                                             
   718      call HistoryAutoPut( TimeN, 'CloudCoverRand', xy_CloudCoverRand )
   719  
   720  
   721    end subroutine RadEarthV2FluxCore
   722  
   723    !--------------------------------------------------------------------------------------
   724  
   725    subroutine RadEarthV2Init(    &
   726      & FlagSnow                  &
   727      & )
   728  
   729      ! ファイル入出力補助
   730      ! File I/O support
   731      !
   732      use dc_iounit, only: FileOpen
   733  
   734      ! ヒストリデータ出力
   735      ! History data output
   736      !
   737      use gtool_historyauto, only: HistoryAutoAddVariable
   738  
   739      ! NAMELIST ファイル入力に関するユーティリティ
   740      ! Utilities for NAMELIST file input
   741      !
   742      use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid
   743  
   744      ! 全球一定体積混合比の設定
   745      ! Set globally constant volume mixing ratio
   746      !
   747      use set_gcmr, only : SetGCMRInit
   748  
   749      ! O3 分布の設定
   750      ! Set O3 distribution
   751      !
   752      use set_o3, only : SetO3Init
   753  
   754  !!$    ! 地球大気向け短波放射モデル Ver. 2.1
   755  !!$    ! short wave radiation model for the Earth's atmosphere Ver. 2.1
   756  !!$    !
   757  !!$    use rad_Earth_SW_V2_1, only: RadEarthSWV21Init
   758  !!$
   759  !!$    ! 地球大気向け短波放射モデル Ver. 2.2
   760  !!$    ! short wave radiation model for the Earth's atmosphere Ver. 2.2
   761  !!$    !
   762  !!$    use rad_Earth_SW_V2_2, only: RadEarthSWV22Init
   763  
   764      ! 地球大気向け短波放射モデル Ver. 2.6
   765      ! short wave radiation model for the Earth's atmosphere Ver. 2.6
   766      !
   767      use rad_Earth_SW_V2_6, only: RadEarthSWV26Init
   768  
   769  !!$    ! 地球大気向け長波放射モデル Ver. 2.3
   770  !!$    ! long wave radiation model for the Earth's atmosphere Ver. 2.3
   771  !!$    !
   772  !!$    use rad_Earth_LW_V2_3, only : RadEarthLWV23Init
   773  
   774      ! 地球大気向け長波放射モデル Ver. 2.4
   775      ! long wave radiation model for the Earth's atmosphere Ver. 2.4
   776      !
   777      use rad_Earth_LW_V2_4, only : RadEarthLWV24Init
   778  
   779  
   780      ! 宣言文 ; Declaration statements
   781      !
   782      logical, intent(in) :: FlagSnow
   783  
   784      character(STRING)   :: CloudIceREffMethod
   785  
   786      integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号.
   787                                ! Unit number for NAMELIST file open
   788      integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT.
   789                                ! IOSTAT of NAMELIST read
   790  
   791      ! NAMELIST 変数群
   792      ! NAMELIST group name
   793      !
   794      namelist /rad_Earth_V2_nml/ &
   795        & CloudIceREffMethod,     &
   796        & CloudWatREff,           &
   797        & CloudIceREff
   798  
   799  !!$      & SWVer, LWVer
   800            !
   801            ! デフォルト値については初期化手続 "rad_Earth_V2#RadEarthV2Init"
   802            ! のソースコードを参照のこと.
   803            !
   804            ! Refer to source codes in the initialization procedure
   805            ! "rad_Earth_V2#RadEarthV2Init" for the default values.
   806            !
   807  
   808      if ( rad_Earth_V2_inited ) return
   809  
   810  
   811      ! Molecular weights of atmosphere, CO2, H2O, N2O, CH4
   812      !
   813      MeanMolWeight = 28.0d-3
   814      CO2MolWeight  = 44.0d-3
   815      H2OMolWeight  = 18.0d-3
   816      N2OMolWeight  = 44.0d-3
   817      CH4MolWeight  = 16.0d-3
   818  
   819  
   820      ! デフォルト値の設定
   821      ! Default values settings
   822      !
   823      CloudIceREffMethod = 'Const'
   824  !!$    CloudIceREffMethod = 'Lin'
   825  
   826      CloudWatREff    = 10.0d-6
   827      CloudIceREff    = 50.0d-6
   828  
   829  
   830  !!$    SWVer = 1
   831  !!$    LWVer = 3
   832  
   833  
   834      ! NAMELIST の読み込み
   835      ! NAMELIST is input
   836      !
   837      if ( trim(namelist_filename) /= '' ) then
   838        call FileOpen( unit_nml, &          ! (out)
   839          & namelist_filename, mode = 'r' ) ! (in)
   840  
   841        rewind( unit_nml )
   842        read( unit_nml,                     & ! (in)
   843          & nml = rad_Earth_V2_nml,         & ! (out)
   844          & iostat = iostat_nml )             ! (out)
   845        close( unit_nml )
   846  
   847        call NmlutilMsg( iostat_nml, module_name ) ! (in)
   848      end if
   849  
   850  
   851      ! Identification of calculation method of cloud particle effective radius
   852      !
   853      call MessageNotify( 'M', module_name, &
   854        & 'CloudIceREffMethod=<%c>.', &
   855        & c1 = trim(CloudIceREffMethod) )
   856      !
   857      select case ( CloudIceREffMethod )
   858      case ( 'Const' )
   859        IDCloudIceREffMethod = IDCloudIceREffMethodConst
   860      case ( 'Lin' )
   861        IDCloudIceREffMethod = IDCloudIceREffMethodLin
   862      case default
   863        call MessageNotify( 'E', module_name, &
   864          & 'CloudIceREffMethod=<%c> is not supported.', &
   865          & c1 = trim(CloudIceREffMethod) )
   866      end select
   867  
   868  
   869      ! Allocate a local variable for O3 distribution
   870      !
   871      allocate( xyz_QO3(0:imax-1, 1:jmax, 1:kmax) )
   872  
   873  
   874      ! Initialization of modules used in this module
   875      !
   876  
   877      ! 全球一定体積混合比の設定
   878      ! Set globally constant volume mixing ratio
   879      !
   880      call SetGCMRInit
   881  
   882      ! O3 分布の設定
   883      ! Set O3 distribution
   884      !
   885      call SetO3Init
   886  
   887  !!$    ! 地球大気向け短波放射モデル Ver. 2.1
   888  !!$    ! short wave radiation model for the Earth's atmosphere Ver. 2.1
   889  !!$    !
   890  !!$    call RadEarthSWV21Init
   891  !!$
   892  !!$    ! 地球大気向け短波放射モデル Ver. 2.2
   893  !!$    ! short wave radiation model for the Earth's atmosphere Ver. 2.2
   894  !!$    !
   895  !!$    call RadEarthSWV22Init( &
   896  !!$      & FlagSnow            &
   897  !!$      & )
   898  
   899      ! 地球大気向け短波放射モデル Ver. 2.6
   900      ! short wave radiation model for the Earth's atmosphere Ver. 2.6
   901      !
   902      call RadEarthSWV26Init( &
   903        & FlagSnow &
   904        & )
   905  
   906  !!$    ! 地球大気向け長波放射モデル Ver. 2.3
   907  !!$    ! long wave radiation model for the Earth's atmosphere Ver. 2.3
   908  !!$    !
   909  !!$    call RadEarthLWV23Init( &
   910  !!$      & FlagSnow            &
   911  !!$      & )
   912  
   913      ! 地球大気向け長波放射モデル Ver. 2.4
   914      ! long wave radiation model for the Earth's atmosphere Ver. 2.4
   915      !
   916      call RadEarthLWV24Init( &
   917        & FlagSnow            &
   918        & )
   919  
   920  
   921      ! ヒストリデータ出力のためのへの変数登録
   922      ! Register of variables for history data output
   923      !
   924      call HistoryAutoAddVariable( 'CloudCoverforRad', &
   925        & (/ 'lon ', 'lat ', 'sig ', 'time' /), &
   926        & 'cloud cover', '1' )
   927      call HistoryAutoAddVariable( 'CloudCoverRand', &
   928        & (/ 'lon ', 'lat ', 'time' /), &
   929        & 'cloud cover', '1' )
   930  
   931  
   932      ! 印字 ; Print
   933      !
   934      call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   935      call MessageNotify( 'M', module_name, '  CloudWatREff      = %f', &
   936        & d = (/ CloudWatREff /) )
   937      call MessageNotify( 'M', module_name, '  CloudIceREff      = %f', &
   938        & d = (/ CloudIceREff /) )
   939  !!$    call MessageNotify( 'M', module_name, 'SWVer = %d', i = (/ SWVer /) )
   940  !!$    call MessageNotify( 'M', module_name, 'LWVer = %d', i = (/ LWVer /) )
   941      call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   942  
   943  
   944      rad_Earth_V2_inited = .true.
   945  
   946    end subroutine RadEarthV2Init
   947  
   948    !--------------------------------------------------------------------------------------
   949  
   950  end module rad_Earth_V2
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:53 2016
FILE NAME: rad_Earth_V2.f90
PROGRAM NAME: rad_earth_v2
FORMAT LIST

  LINE    LOOP      FORTRAN STATEMENT

     1:             != 地球大気向け放射モデル Ver. 2
     2:             !
     3:             != radiation model for the Earth's atmosphere Ver. 2
     4:             !
     5:             ! Authors::   Yoshiyuki O. Takahashi
     6:             ! Version::   $Id: rad_Earth_V2.f90,v 1.9 2015/01/29 12:06:43 yot Exp $
     7:             ! Tag Name::  $Name:  $
     8:             ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9:             ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10:             !
    11:             module rad_Earth_V2
    12:               !
    13:               != 地球大気向け放射モデル Ver. 2
    14:               !
    15:               != radiation model for the Earth's atmosphere Ver. 1
    16:               !
    17:               ! <b>Note that Japanese and English are described in parallel.</b>
    18:               !
    19:               ! 地球大気向け放射モデル.
    20:               !
    21:               ! This is a radiation model for the Earth's atmospehre.
    22:               !
    23:               ! Radiation in the wavenumber range from    0 to  3000 cm-1 
    24:               ! is calculated in the routine of long wave radiation. 
    25:               ! Radiation in the wavenumber range from 1000 to 57143 cm-1 (0.175 to 10 micron) 
    26:               ! is calculated in the routine of shortwave radiation. 
    27:               !
    28:               !== References
    29:               !
    30:               !
    31:               !== Procedures List
    32:               !
    33:               ! RadEarthV2Flux :: 放射フラックスの計算
    34:               ! ------------          :: ------------
    35:               ! RadEarthV2Flux :: Calculate radiation flux
    36:               !
    37:               !== NAMELIST
    38:               !
    39:               ! NAMELIST#rad_Earth_V2_nml
    40:               !
    41:             
    42:               ! USE statements
    43:               !
    44:             
    45:               !
    46:               ! Kind type parameter
    47:               !
    48:               use dc_types, only: DP, &      ! Double precision.
    49:                 &                 STRING, &  ! Strings.
    50:                 &                 TOKEN      ! Keywords.
    51:             
    52:               ! メッセージ出力
    53:               ! Message output
    54:               !
    55:               use dc_message, only: MessageNotify
    56:             
    57:               !
    58:               ! Physical constants settings
    59:               !
    60:               use constants, only: Grav     ! $ g $ [m s-2].
    61:                                             !
    62:                                             ! Gravitational acceleration
    63:             
    64:               ! 格子点設定
    65:               ! Grid points settings
    66:               !
    67:               use gridset, only: imax, & ! 経度格子点数.
    68:                                          ! Number of grid points in longitude
    69:                 &                jmax, & ! 緯度格子点数.
    70:                                          ! Number of grid points in latitude
    71:                 &                kmax    ! 鉛直層数.
    72:                                          ! Number of vertical level
    73:             
    74:               implicit none
    75:             
    76:               private
    77:             
    78:               real(DP), save :: MeanMolWeight
    79:               real(DP), save :: H2OMolWeight
    80:               real(DP), save :: CO2MolWeight
    81:               real(DP), save :: N2OMolWeight
    82:               real(DP), save :: CH4MolWeight
    83:             
    84:               integer, save     :: IDCloudIceREffMethod
    85:               !
    86:               integer, parameter:: IDCloudIceREffMethodConst = 0
    87:               integer, parameter:: IDCloudIceREffMethodLin   = 1
    88:             
    89:               real(DP), save :: CloudWatREff
    90:               real(DP), save :: CloudIceREff
    91:             
    92:               real(DP), allocatable, save :: xyz_QO3(:,:,:)
    93:                                           ! O3 分布 (1)
    94:                                           ! O3 distribution (1)
    95:             
    96:             !!$  integer , save              :: SWVer
    97:             !!$  integer , save              :: LWVer
    98:             
    99:               ! 公開変数
   100:               ! Public variables
   101:               !
   102:               logical, save :: rad_Earth_V2_inited = .false.
   103:                                           ! 初期設定フラグ.
   104:                                           ! Initialization flag
   105:             
   106:               public :: RadEarthV2Flux
   107:             !!$  public :: RadEarthV2FluxforNHM
   108:               public :: RadEarthV2Init
   109:             
   110:               character(*), parameter:: module_name = 'rad_Earth_V2'
   111:                                           ! モジュールの名称.
   112:                                           ! Module name
   113:               character(*), parameter:: version = &
   114:                 & '$Name:  $' // &
   115:                 & '$Id: rad_Earth_V2.f90,v 1.9 2015/01/29 12:06:43 yot Exp $'
   116:                                           ! モジュールのバージョン
   117:                                           ! Module version
   118:             
   119:               !--------------------------------------------------------------------------------------
   120:             
   121:             contains
   122:             
   123:               !--------------------------------------------------------------------------------------
   124:             
   125:               subroutine RadEarthV2Flux(                                                 &
   126:                 & xy_SurfAlbedo,                                                         & ! (in)
   127:                 & xyz_Press, xyr_Press, xyz_Temp, xyz_QH2OVap, xyz_QH2OLiq, xyz_QH2OSol, & ! (in)
   128:                 & xyz_CloudCover,                                                        & ! (in)
   129:                 & xy_SurfTemp,                                                           & ! (in)
   130:                 & xyr_RadSUwFlux, xyr_RadSDwFlux,                                        & ! (out)
   131:                 & xyr_RadLUwFlux, xyr_RadLDwFlux,                                        & ! (out)
   132:                 & xyra_DelRadLUwFlux, xyra_DelRadLDwFlux                                 & ! (out)
   133:                 & )
   134:             
   135:             
   136:                 ! USE statements
   137:                 !
   138:             
   139:                 real(DP), intent(in ) :: xy_SurfAlbedo   (0:imax-1, 1:jmax)
   140:                 real(DP), intent(in ) :: xyz_Press       (0:imax-1, 1:jmax, 1:kmax)
   141:                 real(DP), intent(in ) :: xyr_Press       (0:imax-1, 1:jmax, 0:kmax)
   142:                 real(DP), intent(in ) :: xyz_Temp        (0:imax-1, 1:jmax, 1:kmax)
   143:                 real(DP), intent(in ) :: xyz_QH2OVap     (0:imax-1, 1:jmax, 1:kmax)
   144:                                           ! $ q $ .   混合比. Mass mixing ratio of constituents (1)
   145:                 real(DP), intent(in ) :: xyz_QH2OLiq     (0:imax-1, 1:jmax, 1:kmax)
   146:                 real(DP), intent(in ) :: xyz_QH2OSol     (0:imax-1, 1:jmax, 1:kmax)
   147:                 real(DP), intent(in ) :: xyz_CloudCover  (0:imax-1, 1:jmax, 1:kmax)
   148:                 real(DP), intent(in ) :: xy_SurfTemp     (0:imax-1, 1:jmax)
   149:                 real(DP), intent(out) :: xyr_RadSUwFlux   (0:imax-1, 1:jmax, 0:kmax)
   150:                 real(DP), intent(out) :: xyr_RadSDwFlux   (0:imax-1, 1:jmax, 0:kmax)
   151:                 real(DP), intent(out) :: xyr_RadLUwFlux    (0:imax-1, 1:jmax, 0:kmax)
   152:                 real(DP), intent(out) :: xyr_RadLDwFlux    (0:imax-1, 1:jmax, 0:kmax)
   153:                 real(DP), intent(out) :: xyra_DelRadLUwFlux(0:imax-1, 1:jmax, 0:kmax, 0:1)
   154:                 real(DP), intent(out) :: xyra_DelRadLDwFlux(0:imax-1, 1:jmax, 0:kmax, 0:1)
   155:             
   156:             !!$    real(DP):: xyr_RadLUwFlux    (0:imax-1, 1:jmax, 0:kmax)
   157:             !!$    real(DP):: xyr_RadLDwFlux    (0:imax-1, 1:jmax, 0:kmax)
   158:             !!$    real(DP):: xyra_DelRadLUwFlux(0:imax-1, 1:jmax, 0:kmax, 0:1)
   159:             !!$    real(DP):: xyra_DelRadLDwFlux(0:imax-1, 1:jmax, 0:kmax, 0:1)
   160:             
   161:             
   162:                 ! Work variables
   163:                 !
   164:                 real(DP) :: xyz_DelAtmMass   (0:imax-1, 1:jmax, 1:kmax)
   165:             
   166:                 integer  :: k
   167:             
   168:             
   169:                 ! 初期化確認
   170:                 ! Initialization check
   171:                 !
   172:                 if ( .not. rad_Earth_V2_inited ) then
   173:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   174:                 end if
   175:             
   176:             
   177: W------>        do k = 1, kmax
   178: |**==== A         xyz_DelAtmMass(:,:,k) = ( xyr_Press(:,:,k-1) - xyr_Press(:,:,k ) ) / Grav
   179: W------         end do
   180:             
   181:                 call RadEarthV2FluxCore(                                                        &
   182:                   & xy_SurfAlbedo,                                                              &
   183:                   & xyz_DelAtmMass, xyz_Press, xyz_Temp, xyz_QH2OVap, xyz_QH2OLiq, xyz_QH2OSol, &
   184:                   & xyz_CloudCover,                                                             &
   185:                   & xy_SurfTemp,                                                                &
   186:                   & xyr_RadSUwFlux, xyr_RadSDwFlux,                                             &
   187:                   & xyr_RadLUwFlux, xyr_RadLDwFlux,                          & ! (out)
   188:                   & xyra_DelRadLUwFlux, xyra_DelRadLDwFlux                   & ! (out)
   189:                   & )
   190:             
   191:             
   192:               end subroutine RadEarthV2Flux
   193:             
   194:               !--------------------------------------------------------------------------------------
   195:             !!$
   196:             !!$  subroutine RadEarthV2FluxforNHM(                                          &
   197:             !!$    & r_Height, xy_SurfAlbedo,                                              &
   198:             !!$    & xyz_Dens, xyz_Press, xyz_Temp, xyz_QH2OVap, xyz_QH2OLiq, xyz_QH2OSol, &
   199:             !!$    & xy_SurfTemp,                                                          &
   200:             !!$    & xyr_RadSFlux, xyr_RadLFlux, xyra_DelRadLFlux                          &
   201:             !!$    & )
   202:             !!$
   203:             !!$
   204:             !!$    ! USE statements
   205:             !!$    !
   206:             !!$
   207:             !!$    real(DP), intent(in ) :: r_Height                          (0:kmax)
   208:             !!$    real(DP), intent(in ) :: xy_SurfAlbedo   (0:imax-1, 1:jmax)
   209:             !!$    real(DP), intent(in ) :: xyz_Dens        (0:imax-1, 1:jmax, 1:kmax)
   210:             !!$    real(DP), intent(in ) :: xyz_Press       (0:imax-1, 1:jmax, 1:kmax)
   211:             !!$    real(DP), intent(in ) :: xyz_Temp        (0:imax-1, 1:jmax, 1:kmax)
   212:             !!$    real(DP), intent(in ) :: xyz_QH2OVap     (0:imax-1, 1:jmax, 1:kmax)
   213:             !!$                              ! $ q $ .   混合比. Mass mixing ratio of constituents (1)
   214:             !!$    real(DP), intent(in ) :: xyz_QH2OLiq     (0:imax-1, 1:jmax, 1:kmax)
   215:             !!$    real(DP), intent(in ) :: xyz_QH2OSol     (0:imax-1, 1:jmax, 1:kmax)
   216:             !!$    real(DP), intent(in ) :: xy_SurfTemp     (0:imax-1, 1:jmax)
   217:             !!$    real(DP), intent(out) :: xyr_RadSFlux    (0:imax-1, 1:jmax, 0:kmax)
   218:             !!$    real(DP), intent(out) :: xyr_RadLFlux    (0:imax-1, 1:jmax, 0:kmax)
   219:             !!$    real(DP), intent(out) :: xyra_DelRadLFlux(0:imax-1, 1:jmax, 0:kmax, 0:1)
   220:             !!$
   221:             !!$
   222:             !!$    ! Work variables
   223:             !!$    !
   224:             !!$    real(DP) :: xyz_DelAtmMass   (0:imax-1, 1:jmax, 1:kmax)
   225:             !!$
   226:             !!$    integer  :: k
   227:             !!$
   228:             !!$
   229:             !!$    ! 初期化確認
   230:             !!$    ! Initialization check
   231:             !!$    !
   232:             !!$    if ( .not. rad_Earth_V2_inited ) then
   233:             !!$      call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   234:             !!$    end if
   235:             !!$
   236:             !!$
   237:             !!$    do k = 1, kmax
   238:             !!$      xyz_DelAtmMass(:,:,k) = xyz_Dens(:,:,k) * ( r_Height(k) - r_Height(k-1) )
   239:             !!$    end do
   240:             !!$
   241:             !!$    call RadEarthV2FluxCore(                                                        &
   242:             !!$      & xy_SurfAlbedo,                                                              &
   243:             !!$      & xyz_DelAtmMass, xyz_Press, xyz_Temp, xyz_QH2OVap, xyz_QH2OLiq, xyz_QH2OSol, &
   244:             !!$      & xy_SurfTemp,                                                                &
   245:             !!$      & xyr_RadSFlux, xyr_RadLFlux, xyra_DelRadLFlux                                &
   246:             !!$      & )
   247:             !!$
   248:             !!$
   249:             !!$  end subroutine RadEarthV2FluxforNHM
   250:             !!$
   251:               !--------------------------------------------------------------------------------------
   252:             !!$
   253:             !!$  subroutine RadDcpamEV2FluxforNHM2DWrapper(                    &
   254:             !!$    & r_Height, x_SurfAlbedo,                                   &
   255:             !!$    & xz_Dens, xz_Press, xz_Temp, xz_QH2OVap, xz_QH2OLiq,       &
   256:             !!$    & x_SurfTemp,                                               &
   257:             !!$    & xr_RadSFlux, xr_RadLFlux, xra_DelRadLFlux                 &
   258:             !!$    & )
   259:             !!$
   260:             !!$
   261:             !!$    ! USE statements
   262:             !!$    !
   263:             !!$
   264:             !!$
   265:             !!$    real(DP), intent(in ) :: r_Height                 (0:kmax)
   266:             !!$    real(DP), intent(in ) :: x_SurfAlbedo   (0:imax-1)
   267:             !!$    real(DP), intent(in ) :: xz_Dens        (0:imax-1, 1:kmax)
   268:             !!$    real(DP), intent(in ) :: xz_Press       (0:imax-1, 1:kmax)
   269:             !!$    real(DP), intent(in ) :: xz_Temp        (0:imax-1, 1:kmax)
   270:             !!$    real(DP), intent(in ) :: xz_QH2OVap     (0:imax-1, 1:kmax)
   271:             !!$    real(DP), intent(in ) :: xz_QH2OLiq     (0:imax-1, 1:kmax)
   272:             !!$    real(DP), intent(in ) :: x_SurfTemp     (0:imax-1)
   273:             !!$    real(DP), intent(out) :: xr_RadSFlux    (0:imax-1, 0:kmax)
   274:             !!$    real(DP), intent(out) :: xr_RadLFlux    (0:imax-1, 0:kmax)
   275:             !!$    real(DP), intent(out) :: xra_DelRadLFlux(0:imax-1, 0:kmax, 0:1)
   276:             !!$
   277:             !!$
   278:             !!$    ! Work variables
   279:             !!$    !
   280:             !!$    real(DP) :: xy_SurfAlbedo   (0:imax-1, 1:jmax)
   281:             !!$    real(DP) :: xyz_Dens        (0:imax-1, 1:jmax, 1:kmax)
   282:             !!$    real(DP) :: xyz_Press       (0:imax-1, 1:jmax, 1:kmax)
   283:             !!$    real(DP) :: xyz_Temp        (0:imax-1, 1:jmax, 1:kmax)
   284:             !!$    real(DP) :: xyz_QH2OVap     (0:imax-1, 1:jmax, 1:kmax)
   285:             !!$    real(DP) :: xyz_QH2OLiq     (0:imax-1, 1:jmax, 1:kmax)
   286:             !!$    real(DP) :: xy_SurfTemp     (0:imax-1, 1:jmax)
   287:             !!$    real(DP) :: xyr_RadSFlux    (0:imax-1, 1:jmax, 0:kmax)
   288:             !!$    real(DP) :: xyr_RadLFlux    (0:imax-1, 1:jmax, 0:kmax)
   289:             !!$    real(DP) :: xyra_DelRadLFlux(0:imax-1, 1:jmax, 0:kmax, 0:1)
   290:             !!$
   291:             !!$    integer  :: k
   292:             !!$
   293:             !!$
   294:             !!$    ! 初期化確認
   295:             !!$    ! Initialization check
   296:             !!$    !
   297:             !!$    if ( .not. rad_dcpam_E_V2_inited ) then
   298:             !!$      call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   299:             !!$    end if
   300:             !!$
   301:             !!$
   302:             !!$    if ( jmax /= 1 ) then
   303:             !!$      call MessageNotify( 'E', module_name, 'jmax must be 1.' )
   304:             !!$    end if
   305:             !!$
   306:             !!$
   307:             !!$    xy_SurfAlbedo   (:, 1)       = x_SurfAlbedo   (:)
   308:             !!$    do k = 1, kmax
   309:             !!$      xyz_Dens        (:, 1, k)    = xz_Dens        (:, k)
   310:             !!$      xyz_Press       (:, 1, k)    = xz_Press       (:, k)
   311:             !!$      xyz_Temp        (:, 1, k)    = xz_Temp        (:, k)
   312:             !!$      xyz_QH2OVap     (:, 1, k)    = xz_QH2OVap     (:, k)
   313:             !!$      xyz_QH2OLiq     (:, 1, k)    = xz_QH2OLiq     (:, k)
   314:             !!$    end do
   315:             !!$    xy_SurfTemp     (:, 1)       = x_SurfTemp     (:)
   316:             !!$
   317:             !!$    call RadDcpamEV2FluxforNHM(                                       &
   318:             !!$      & r_Height, xy_SurfAlbedo,                                      &
   319:             !!$      & xyz_Dens, xyz_Press, xyz_Temp, xyz_QH2OVap, xyz_QH2OLiq,      &
   320:             !!$      & xy_SurfTemp,                                                  &
   321:             !!$      & xyr_RadSFlux, xyr_RadLFlux, xyra_DelRadLFlux                  &
   322:             !!$      & )
   323:             !!$
   324:             !!$    xr_RadSFlux    (:, :)    = xyr_RadSFlux    (:, 1, :)
   325:             !!$    xr_RadLFlux    (:, :)    = xyr_RadLFlux    (:, 1, :)
   326:             !!$    xra_DelRadLFlux(:, :, :) = xyra_DelRadLFlux(:, 1, :, :)
   327:             !!$
   328:             !!$
   329:             !!$  end subroutine RadDcpamEV2FluxforNHM2DWrapper
   330:             !!$
   331:               !--------------------------------------------------------------------------------------
   332:             !!$
   333:             !!$  subroutine RadDcpamEV2Flux2DWrapper(                         &
   334:             !!$    & x_SurfAlbedo,                                            &
   335:             !!$    & xz_Press, xr_Press, xz_Temp, xz_QH2OVap, xz_QH2OLiq,     &
   336:             !!$    & x_SurfTemp,                                              &
   337:             !!$    & xr_RadSFlux, xr_RadLFlux, xra_DelRadLFlux                &
   338:             !!$    & )
   339:             !!$
   340:             !!$
   341:             !!$    ! USE statements
   342:             !!$    !
   343:             !!$
   344:             !!$
   345:             !!$
   346:             !!$    real(DP), intent(in ) :: x_SurfAlbedo   (0:imax-1)
   347:             !!$    real(DP), intent(in ) :: xz_Press       (0:imax-1, 1:kmax)
   348:             !!$    real(DP), intent(in ) :: xr_Press       (0:imax-1, 0:kmax)
   349:             !!$    real(DP), intent(in ) :: xz_Temp        (0:imax-1, 1:kmax)
   350:             !!$    real(DP), intent(in ) :: xz_QH2OVap     (0:imax-1, 1:kmax)
   351:             !!$    real(DP), intent(in ) :: xz_QH2OLiq     (0:imax-1, 1:kmax)
   352:             !!$    real(DP), intent(in ) :: x_SurfTemp     (0:imax-1)
   353:             !!$    real(DP), intent(out) :: xr_RadSFlux    (0:imax-1, 0:kmax)
   354:             !!$    real(DP), intent(out) :: xr_RadLFlux    (0:imax-1, 0:kmax)
   355:             !!$    real(DP), intent(out) :: xra_DelRadLFlux(0:imax-1, 0:kmax, 0:1)
   356:             !!$
   357:             !!$
   358:             !!$    ! Work variables
   359:             !!$    !
   360:             !!$    real(DP) :: xy_SurfAlbedo   (0:imax-1, 1:jmax)
   361:             !!$    real(DP) :: xyz_Press       (0:imax-1, 1:jmax, 1:kmax)
   362:             !!$    real(DP) :: xyr_Press       (0:imax-1, 1:jmax, 0:kmax)
   363:             !!$    real(DP) :: xyz_Temp        (0:imax-1, 1:jmax, 1:kmax)
   364:             !!$    real(DP) :: xyz_QH2OVap     (0:imax-1, 1:jmax, 1:kmax)
   365:             !!$    real(DP) :: xyz_QH2OLiq     (0:imax-1, 1:jmax, 1:kmax)
   366:             !!$    real(DP) :: xy_SurfTemp     (0:imax-1, 1:jmax)
   367:             !!$    real(DP) :: xyr_RadSFlux    (0:imax-1, 1:jmax, 0:kmax)
   368:             !!$    real(DP) :: xyr_RadLFlux    (0:imax-1, 1:jmax, 0:kmax)
   369:             !!$    real(DP) :: xyra_DelRadLFlux(0:imax-1, 1:jmax, 0:kmax, 0:1)
   370:             !!$
   371:             !!$
   372:             !!$    ! 初期化確認
   373:             !!$    ! Initialization check
   374:             !!$    !
   375:             !!$    if ( .not. rad_dcpam_E_V2_inited ) then
   376:             !!$      call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   377:             !!$    end if
   378:             !!$
   379:             !!$
   380:             !!$    if ( jmax /= 1 ) then
   381:             !!$      call MessageNotify( 'E', module_name, 'jmax must be 1.' )
   382:             !!$    end if
   383:             !!$
   384:             !!$
   385:             !!$    xy_SurfAlbedo   (:, 1)       = x_SurfAlbedo   (:)
   386:             !!$    xyz_Press       (:, 1, :)    = xz_Press       (:, :)
   387:             !!$    xyr_Press       (:, 1, :)    = xr_Press       (:, :)
   388:             !!$    xyz_Temp        (:, 1, :)    = xz_Temp        (:, :)
   389:             !!$    xyz_QH2OVap     (:, 1, :)    = xz_QH2OVap     (:, :)
   390:             !!$    xyz_QH2OLiq     (:, 1, :)    = xz_QH2OLiq     (:, :)
   391:             !!$    xy_SurfTemp     (:, 1)       = x_SurfTemp     (:)
   392:             !!$
   393:             !!$    call RadDcpamEV2Flux(                                             &
   394:             !!$      & xy_SurfAlbedo,                                                &
   395:             !!$      & xyz_Press, xyr_Press, xyz_Temp, xyz_QH2OVap, xyz_QH2OLiq,     &
   396:             !!$      & xy_SurfTemp,                                                  &
   397:             !!$      & xyr_RadSFlux, xyr_RadLFlux, xyra_DelRadLFlux                  &
   398:             !!$      & )
   399:             !!$
   400:             !!$    xr_RadSFlux    (:, :)    = xyr_RadSFlux    (:, 1, :)
   401:             !!$    xr_RadLFlux    (:, :)    = xyr_RadLFlux    (:, 1, :)
   402:             !!$    xra_DelRadLFlux(:, :, :) = xyra_DelRadLFlux(:, 1, :, :)
   403:             !!$
   404:             !!$
   405:             !!$  end subroutine RadDcpamEV2Flux2DWrapper
   406:             !!$
   407:               !--------------------------------------------------------------------------------------
   408:             
   409:               subroutine RadEarthV2FluxCore(                                                  &
   410:                 & xy_SurfAlbedo,                                                              &
   411:                 & xyz_DelAtmMass, xyz_Press, xyz_Temp, xyz_QH2OVap, xyz_QH2OLiq, xyz_QH2OSol, &
   412:                 & xyz_CloudCover,                                                             &
   413:                 & xy_SurfTemp,                                                                &
   414:                 & xyr_RadSUwFlux, xyr_RadSDwFlux,                                             &
   415:                 & xyr_RadLUwFlux, xyr_RadLDwFlux,                          & ! (out)
   416:                 & xyra_DelRadLUwFlux, xyra_DelRadLDwFlux                   & ! (out)
   417:                 & )
   418:             
   419:             
   420:                 ! USE statements
   421:                 !
   422:             
   423:                 ! ヒストリデータ出力
   424:                 ! History data output
   425:                 !
   426:                 use gtool_historyauto, only: HistoryAutoPut
   427:             
   428:                 ! 時刻管理
   429:                 ! Time control
   430:                 !
   431:                 use timeset, only: &
   432:                   & TimeN                 ! ステップ $ t $ の時刻.
   433:                                           ! Time of step $ t $.
   434:             
   435:                 ! 全球一定体積混合比の設定
   436:                 ! Set globally constant volume mixing ratio
   437:                 !
   438:                 use set_gcmr, only : SetGCMR
   439:             
   440:                 ! O3 分布の設定
   441:                 ! Set O3 distribution
   442:                 !
   443:                 use set_o3, only: SetO3
   444:             
   445:             !!$    ! dcpam 地球大気向け短波放射モデル Ver. 2
   446:             !!$    ! dcpam short wave radiation model for the Earth's atmosphere Ver. 2
   447:             !!$    !
   448:             !!$    use radiation_dcpam_E_SW_V2, only: RadiationDcpamESWV2Flux
   449:             
   450:             !!$    ! 地球大気向け短波放射モデル Ver. 2.1
   451:             !!$    ! short wave radiation model for the Earth's atmosphere Ver. 2.1
   452:             !!$    !
   453:             !!$    use rad_Earth_SW_V2_1, only: RadEarthSWV21Flux
   454:             !!$
   455:             !!$    ! 地球大気向け短波放射モデル Ver. 2.2
   456:             !!$    ! short wave radiation model for the Earth's atmosphere Ver. 2.2
   457:             !!$    !
   458:             !!$    use rad_Earth_SW_V2_2, only: RadEarthSWV22Flux
   459:             
   460:                 ! 地球大気向け短波放射モデル Ver. 2.6
   461:                 ! short wave radiation model for the Earth's atmosphere Ver. 2.6
   462:                 !
   463:                 use rad_Earth_SW_V2_6, only: RadEarthSWV26Flux
   464:             
   465:             !!$    ! dcpam 地球大気向け長波放射モデル Ver. 2
   466:             !!$    ! dcpam long wave radiation model for the Earth's atmosphere Ver. 2
   467:             !!$    !
   468:             !!$    use radiation_dcpam_E_LW_V2, only : RadiationDcpamELWV2Flux
   469:             !!$
   470:             !!$    ! dcpam 地球大気向け長波放射モデル Ver. 2.1
   471:             !!$    ! dcpam long wave radiation model for the Earth's atmosphere Ver. 2.1
   472:             !!$    !
   473:             !!$    use radiation_dcpam_E_LW_V2_1, only : RadiationDcpamELWV21Flux
   474:             !!$
   475:             !!$    ! dcpam 地球大気向け長波放射モデル Ver. 2.2
   476:             !!$    ! dcpam long wave radiation model for the Earth's atmosphere Ver. 2.2
   477:             !!$    !
   478:             !!$    use radiation_dcpam_E_LW_V2_2, only : RadiationDcpamELWV22Flux
   479:             !!$
   480:             !!$    ! 地球大気向け長波放射モデル Ver. 2.3
   481:             !!$    ! long wave radiation model for the Earth's atmosphere Ver. 2.3
   482:             !!$    !
   483:             !!$    use rad_Earth_LW_V2_3, only : RadEarthLWV23Flux
   484:             !!$
   485:                 ! 地球大気向け長波放射モデル Ver. 2.4
   486:                 ! long wave radiation model for the Earth's atmosphere Ver. 2.4
   487:                 !
   488:                 use rad_Earth_LW_V2_4, only : RadEarthLWV24Flux
   489:             
   490:             
   491:                 real(DP), intent(in ) :: xy_SurfAlbedo   (0:imax-1, 1:jmax)
   492:                 real(DP), intent(in ) :: xyz_DelAtmMass  (0:imax-1, 1:jmax, 1:kmax)
   493:                 real(DP), intent(in ) :: xyz_Press       (0:imax-1, 1:jmax, 1:kmax)
   494:                 real(DP), intent(in ) :: xyz_Temp        (0:imax-1, 1:jmax, 1:kmax)
   495:                 real(DP), intent(in ) :: xyz_QH2OVap     (0:imax-1, 1:jmax, 1:kmax)
   496:                                           ! $ q $ .   混合比. Mass mixing ratio of constituents (1)
   497:                 real(DP), intent(in ) :: xyz_QH2OLiq     (0:imax-1, 1:jmax, 1:kmax)
   498:                 real(DP), intent(in ) :: xyz_QH2OSol     (0:imax-1, 1:jmax, 1:kmax)
   499:                 real(DP), intent(in ) :: xyz_CloudCover  (0:imax-1, 1:jmax, 1:kmax)
   500:                 real(DP), intent(in ) :: xy_SurfTemp     (0:imax-1, 1:jmax)
   501:                 real(DP), intent(out) :: xyr_RadSUwFlux    (0:imax-1, 1:jmax, 0:kmax)
   502:                 real(DP), intent(out) :: xyr_RadSDwFlux    (0:imax-1, 1:jmax, 0:kmax)
   503:                 real(DP), intent(out) :: xyr_RadLUwFlux    (0:imax-1, 1:jmax, 0:kmax)
   504:                 real(DP), intent(out) :: xyr_RadLDwFlux    (0:imax-1, 1:jmax, 0:kmax)
   505:                 real(DP), intent(out) :: xyra_DelRadLUwFlux(0:imax-1, 1:jmax, 0:kmax, 0:1)
   506:                 real(DP), intent(out) :: xyra_DelRadLDwFlux(0:imax-1, 1:jmax, 0:kmax, 0:1)
   507:             
   508:             
   509:                 ! Work variables
   510:                 !
   511:                 real(DP) :: VMRCO2
   512:                 real(DP) :: xyz_QCO2         (0:imax-1, 1:jmax, 1:kmax)
   513:                 real(DP) :: VMRN2O
   514:                 real(DP) :: xyz_QN2O         (0:imax-1, 1:jmax, 1:kmax)
   515:                 real(DP) :: VMRCH4
   516:                 real(DP) :: xyz_QCH4         (0:imax-1, 1:jmax, 1:kmax)
   517:             
   518:                 real(DP) :: xyz_DelCO2Mass   (0:imax-1, 1:jmax, 1:kmax)
   519:                 real(DP) :: xyz_DelH2OVapMass(0:imax-1, 1:jmax, 1:kmax)
   520:                 real(DP) :: xyz_DelH2OLiqMass(0:imax-1, 1:jmax, 1:kmax)
   521:                 real(DP) :: xyz_DelH2OSolMass(0:imax-1, 1:jmax, 1:kmax)
   522:                 real(DP) :: xyz_DelO3Mass    (0:imax-1, 1:jmax, 1:kmax)
   523:                 real(DP) :: xyz_DelN2OMass   (0:imax-1, 1:jmax, 1:kmax)
   524:                 real(DP) :: xyz_DelCH4Mass   (0:imax-1, 1:jmax, 1:kmax)
   525:             
   526:                 real(DP) :: xyz_CloudWatREff (0:imax-1, 1:jmax, 1:kmax)
   527:                 real(DP) :: xyz_CloudIceREff (0:imax-1, 1:jmax, 1:kmax)
   528:             
   529:                 real(DP) :: xy_CloudCoverRand(0:imax-1, 1:jmax)
   530:             
   531:                 integer :: k
   532:             
   533:                 ! 初期化確認
   534:                 ! Initialization check
   535:                 !
   536:                 if ( .not. rad_Earth_V2_inited ) then
   537:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   538:                 end if
   539:             
   540:                 ! 全球一定体積混合比の設定
   541:                 ! Set globally constant volume mixing ratio
   542:                 !
   543:                 call SetGCMR( &
   544:                   & 'CO2',    & ! (in)
   545:                   & VMRCO2    & ! (out)
   546:                   & )
   547: W**==== A       xyz_QCO2 = VMRCO2 * CO2MolWeight / MeanMolWeight
   548:             
   549:                 ! 全球一定体積混合比の設定
   550:                 ! Set globally constant volume mixing ratio
   551:                 !
   552:                 call SetGCMR( &
   553:                   & 'N2O',    & ! (in)
   554:                   & VMRN2O    & ! (out)
   555:                   & )
   556: W**==== A       xyz_QN2O = VMRN2O * N2OMolWeight / MeanMolWeight
   557:             
   558:                 ! 全球一定体積混合比の設定
   559:                 ! Set globally constant volume mixing ratio
   560:                 !
   561:                 call SetGCMR( &
   562:                   & 'CH4',    & ! (in)
   563:                   & VMRCH4    & ! (out)
   564:                   & )
   565: W**==== A       xyz_QCH4 = VMRCH4 * CH4MolWeight / MeanMolWeight
   566:             
   567:             
   568:                 ! O3 分布の設定
   569:                 ! Setting of O3 distribution
   570:                 !
   571:                 call SetO3( &
   572:                   & xyz_Press, & ! (in )
   573:                   & xyz_QO3    & ! (out)
   574:                   & )
   575:             
   576:             
   577:                 !
   578:                 ! Set cloud effective radius
   579:                 !
   580: W**==== A       xyz_CloudWatREff = CloudWatREff
   581:                 !
   582:                 select case ( IDCloudIceREffMethod )
   583:                 case ( IDCloudIceREffMethodConst )
   584: ++V==== A         xyz_CloudIceREff = CloudIceREff
   585:                 case ( IDCloudIceREffMethodLin )
   586:                   ! This is a simple model mimicing a result of Ou and Liou (1995).
   587:                   ! This was used in MRI model probably.
   588: **W---->A         xyz_CloudIceREff = &
   589: |||                 &   ( 20.0e-6_DP              - 150.0e-6_DP             ) &
   590: |||                 & / ( ( 273.15_DP - 60.0_DP ) - ( 273.15_DP - 20.0_DP ) ) &
   591: |||                 & * ( xyz_Temp                - ( 273.15_DP - 20.0_DP ) ) &
   592: |||                 & + 150.0e-6_DP
   593: **W---- A         xyz_CloudIceREff = min( max( xyz_CloudIceREff, 20.0e-6_DP ), 150.0e-6_DP )
   594:                 end select
   595:             
   596:             
   597: **V---->A       xyz_DelCO2Mass    = xyz_DelAtmMass * xyz_QCO2
   598: |||     A       xyz_DelH2OVapMass = xyz_DelAtmMass * xyz_QH2OVap
   599: |||     A       xyz_DelH2OLiqMass = xyz_DelAtmMass * xyz_QH2OLiq
   600: |||     A       xyz_DelH2OSolMass = xyz_DelAtmMass * xyz_QH2OSol
   601: |||     A       xyz_DelO3Mass     = xyz_DelAtmMass * xyz_QO3
   602: |||     A       xyz_DelN2OMass    = xyz_DelAtmMass * xyz_QN2O
   603: **V---- A       xyz_DelCH4Mass    = xyz_DelAtmMass * xyz_QCH4
   604:             
   605:             
   606:             !!$    select case ( SWVer )
   607:             !!$    case ( 0 )
   608:             !!$      ! dcpam 地球大気向け短波放射モデル Ver. 2
   609:             !!$      ! dcpam short wave radiation model for the Earth's atmosphere Ver. 2
   610:             !!$      !
   611:             !!$      call RadiationDcpamESWV2Flux(                                 &
   612:             !!$        & xy_SurfAlbedo,                                                  &
   613:             !!$        & xyz_Press, xyr_Press, xyz_Temp, xyz_QH2OVap, xyz_QO3, xyz_Height,  &
   614:             !!$        & xyr_RadSFlux                                                    &
   615:             !!$        & )
   616:             !!$    case ( 1 )
   617:             !!$      ! 地球大気向け短波放射モデル Ver. 2.1
   618:             !!$      ! short wave radiation model for the Earth's atmosphere Ver. 2.1
   619:             !!$      !
   620:             !!$      call RadEarthSWV21Flux(                                      &
   621:             !!$        & xy_SurfAlbedo,                                           &
   622:             !!$        & xyz_DelAtmMass,                                          &
   623:             !!$        & xyz_DelH2OVapMass, xyz_DelH2OLiqMass, xyz_DelH2OSolMass, &
   624:             !!$        & xyz_DelO3Mass,                                           &
   625:             !!$        & xyz_Press, xyz_Temp,                                     &
   626:             !!$        & xyz_CloudCover,                                          &
   627:             !!$        & xyr_RadSUwFlux, xyr_RadSDwFlux                           &
   628:             !!$        & )
   629:             !!$    case ( 2 )
   630:             !!$      ! 地球大気向け短波放射モデル Ver. 2.2
   631:             !!$      ! short wave radiation model for the Earth's atmosphere Ver. 2.2
   632:             !!$      !
   633:             !!$      call RadEarthSWV22Flux(                                      &
   634:             !!$        & xy_SurfAlbedo,                                           &
   635:             !!$        & xyz_DelAtmMass,                                          &
   636:             !!$        & xyz_DelH2OVapMass, xyz_DelH2OLiqMass, xyz_DelH2OSolMass, &
   637:             !!$        & xyz_DelO3Mass,                                           &
   638:             !!$        & xyz_Press, xyz_Temp,                                     &
   639:             !!$        & xyz_CloudCover,                                          &
   640:             !!$        & xyr_RadSUwFlux, xyr_RadSDwFlux                           &
   641:             !!$        & )
   642:             !!$    case ( 6 )
   643:                   ! 地球大気向け短波放射モデル Ver. 2.6
   644:                   ! short wave radiation model for the Earth's atmosphere Ver. 2.6
   645:                   !
   646:                   call RadEarthSWV26Flux(                                      &
   647:                     & xy_SurfAlbedo,                                           &
   648:                     & xyz_DelAtmMass,                                          &
   649:                     & xyz_DelH2OVapMass, xyz_DelH2OLiqMass, xyz_DelH2OSolMass, &
   650:                     & xyz_DelO3Mass,                                           &
   651:                     & xyz_Press, xyz_Temp,                                     &
   652:                     & xyz_CloudCover,                                          &
   653:                     & xyz_CloudWatREff, xyz_CloudIceREff,                      &
   654:                     & xyr_RadSUwFlux, xyr_RadSDwFlux                           &
   655:                     & )
   656:             !!$    case default
   657:             !!$      call MessageNotify( 'E', module_name, 'SW model version %d is not supported.', i = (/ LWVer /) )
   658:             !!$    end select
   659:             
   660:             !!$    select case ( LWVer )
   661:             !!$    case ( 0 )
   662:             !!$      call RadiationDcpamELWV2Flux( &
   663:             !!$        & xyz_Press, xyr_Press, xyz_Temp, xy_SurfTemp,                    & ! (in )
   664:             !!$        & xyz_QH2OVap, xyz_QO3,                                           & ! (in )
   665:             !!$        & xyr_RadLFlux, xyra_DelRadLFlux                                  & ! (out)
   666:             !!$        & )
   667:             !!$    case ( 1 )
   668:             !!$      call RadiationDcpamELWV21Flux( &
   669:             !!$        & xyz_Press, xyr_Press, xyz_Temp, xy_SurfTemp,                    & ! (in )
   670:             !!$        & xyz_QH2OVap, xyz_QO3,                                           & ! (in )
   671:             !!$        & xyr_RadLFlux, xyra_DelRadLFlux                                  & ! (out)
   672:             !!$        & )
   673:             !!$    case ( 2 )
   674:             !!$      call RadiationDcpamELWV22Flux( &
   675:             !!$        & xyz_Press, xyr_Press, xyz_Temp, xy_SurfTemp,                    & ! (in )
   676:             !!$        & xyz_QH2OVap, xyz_QO3,                                           & ! (in )
   677:             !!$        & xyr_RadLFlux, xyra_DelRadLFlux                                  & ! (out)
   678:             !!$        & )
   679:             !!$    case ( 3 )
   680:             !!$      call RadEarthLWV23Flux(                                      &
   681:             !!$        & xyz_DelCO2Mass,                                          &
   682:             !!$        & xyz_DelH2OVapMass, xyz_DelH2OLiqMass, xyz_DelH2OSolMass, &
   683:             !!$        & xyz_DelO3Mass,                                           &
   684:             !!$        & xyz_Press, xyz_Temp, xy_SurfTemp,                        & ! (in )
   685:             !!$        & xyz_QCO2, xyz_QH2OVap,                                   & ! (in )
   686:             !!$        & xyz_CloudCover,                                          & ! (in )
   687:             !!$        & xyr_RadLUwFlux, xyr_RadLDwFlux,                          & ! (out)
   688:             !!$        & xyra_DelRadLUwFlux, xyra_DelRadLDwFlux                   & ! (out)
   689:             !!$        & )
   690:             !!$    case ( 4 )
   691:                   call RadEarthLWV24Flux(                                      &
   692:                     & xyz_DelCO2Mass,                                          &
   693:                     & xyz_DelH2OVapMass, xyz_DelH2OLiqMass, xyz_DelH2OSolMass, &
   694:                     & xyz_DelO3Mass,                                           &
   695:                     & xyz_DelN2OMass, xyz_DelCH4Mass,                          &
   696:                     & xyz_Press, xyz_Temp, xy_SurfTemp,                        & ! (in )
   697:                     & xyz_QCO2, xyz_QH2OVap,                                   & ! (in )
   698:                     & xyz_QN2O, xyz_QCH4,                                      & ! (in )
   699:                     & xyz_CloudCover,                                          & ! (in )
   700:                     & xyz_CloudWatREff, xyz_CloudIceREff,                      & ! (in )
   701:                     & xyr_RadLUwFlux, xyr_RadLDwFlux,                          & ! (out)
   702:                     & xyra_DelRadLUwFlux, xyra_DelRadLDwFlux                   & ! (out)
   703:                     & )
   704:             !!$    case default
   705:             !!$      call MessageNotify( 'E', module_name, 'LW model version %d is not supported.', i = (/ LWVer /) )
   706:             !!$    end select
   707:             
   708:             
   709:                 ! Output variables
   710:                 !
   711:                 call HistoryAutoPut( TimeN, 'CloudCoverforRad', xyz_CloudCover )
   712:                 !
   713: W*===== A       xy_CloudCoverRand = 1.0_DP
   714: +------>        do k = 1, kmax
   715: |W*==== A         xy_CloudCoverRand = xy_CloudCoverRand * ( 1.0_DP - xyz_CloudCover(:,:,k) )
   716: +------         end do
   717: W*===== A       xy_CloudCoverRand = 1.0_DP - xy_CloudCoverRand
   718:                 call HistoryAutoPut( TimeN, 'CloudCoverRand', xy_CloudCoverRand )
   719:             
   720:             
   721:               end subroutine RadEarthV2FluxCore
   722:             
   723:               !--------------------------------------------------------------------------------------
   724:             
   725:               subroutine RadEarthV2Init(    &
   726:                 & FlagSnow                  &
   727:                 & )
   728:             
   729:                 ! ファイル入出力補助
   730:                 ! File I/O support
   731:                 !
   732:                 use dc_iounit, only: FileOpen
   733:             
   734:                 ! ヒストリデータ出力
   735:                 ! History data output
   736:                 !
   737:                 use gtool_historyauto, only: HistoryAutoAddVariable
   738:             
   739:                 ! NAMELIST ファイル入力に関するユーティリティ
   740:                 ! Utilities for NAMELIST file input
   741:                 !
   742:                 use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid
   743:             
   744:                 ! 全球一定体積混合比の設定
   745:                 ! Set globally constant volume mixing ratio
   746:                 !
   747:                 use set_gcmr, only : SetGCMRInit
   748:             
   749:                 ! O3 分布の設定
   750:                 ! Set O3 distribution
   751:                 !
   752:                 use set_o3, only : SetO3Init
   753:             
   754:             !!$    ! 地球大気向け短波放射モデル Ver. 2.1
   755:             !!$    ! short wave radiation model for the Earth's atmosphere Ver. 2.1
   756:             !!$    !
   757:             !!$    use rad_Earth_SW_V2_1, only: RadEarthSWV21Init
   758:             !!$
   759:             !!$    ! 地球大気向け短波放射モデル Ver. 2.2
   760:             !!$    ! short wave radiation model for the Earth's atmosphere Ver. 2.2
   761:             !!$    !
   762:             !!$    use rad_Earth_SW_V2_2, only: RadEarthSWV22Init
   763:             
   764:                 ! 地球大気向け短波放射モデル Ver. 2.6
   765:                 ! short wave radiation model for the Earth's atmosphere Ver. 2.6
   766:                 !
   767:                 use rad_Earth_SW_V2_6, only: RadEarthSWV26Init
   768:             
   769:             !!$    ! 地球大気向け長波放射モデル Ver. 2.3
   770:             !!$    ! long wave radiation model for the Earth's atmosphere Ver. 2.3
   771:             !!$    !
   772:             !!$    use rad_Earth_LW_V2_3, only : RadEarthLWV23Init
   773:             
   774:                 ! 地球大気向け長波放射モデル Ver. 2.4
   775:                 ! long wave radiation model for the Earth's atmosphere Ver. 2.4
   776:                 !
   777:                 use rad_Earth_LW_V2_4, only : RadEarthLWV24Init
   778:             
   779:             
   780:                 ! 宣言文 ; Declaration statements
   781:                 !
   782:                 logical, intent(in) :: FlagSnow
   783:             
   784:                 character(STRING)   :: CloudIceREffMethod
   785:             
   786:                 integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号.
   787:                                           ! Unit number for NAMELIST file open
   788:                 integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT.
   789:                                           ! IOSTAT of NAMELIST read
   790:             
   791:                 ! NAMELIST 変数群
   792:                 ! NAMELIST group name
   793:                 !
   794:                 namelist /rad_Earth_V2_nml/ &
   795:                   & CloudIceREffMethod,     &
   796:                   & CloudWatREff,           &
   797:                   & CloudIceREff
   798:             
   799:             !!$      & SWVer, LWVer
   800:                       !
   801:                       ! デフォルト値については初期化手続 "rad_Earth_V2#RadEarthV2Init"
   802:                       ! のソースコードを参照のこと.
   803:                       !
   804:                       ! Refer to source codes in the initialization procedure
   805:                       ! "rad_Earth_V2#RadEarthV2Init" for the default values.
   806:                       !
   807:             
   808:                 if ( rad_Earth_V2_inited ) return
   809:             
   810:             
   811:                 ! Molecular weights of atmosphere, CO2, H2O, N2O, CH4
   812:                 !
   813:                 MeanMolWeight = 28.0d-3
   814:                 CO2MolWeight  = 44.0d-3
   815:                 H2OMolWeight  = 18.0d-3
   816:                 N2OMolWeight  = 44.0d-3
   817:                 CH4MolWeight  = 16.0d-3
   818:             
   819:             
   820:                 ! デフォルト値の設定
   821:                 ! Default values settings
   822:                 !
   823:                 CloudIceREffMethod = 'Const'
   824:             !!$    CloudIceREffMethod = 'Lin'
   825:             
   826:                 CloudWatREff    = 10.0d-6
   827:                 CloudIceREff    = 50.0d-6
   828:             
   829:             
   830:             !!$    SWVer = 1
   831:             !!$    LWVer = 3
   832:             
   833:             
   834:                 ! NAMELIST の読み込み
   835:                 ! NAMELIST is input
   836:                 !
   837:                 if ( trim(namelist_filename) /= '' ) then
   838:                   call FileOpen( unit_nml, &          ! (out)
   839:                     & namelist_filename, mode = 'r' ) ! (in)
   840:             
   841:                   rewind( unit_nml )
   842:                   read( unit_nml,                     & ! (in)
   843:                     & nml = rad_Earth_V2_nml,         & ! (out)
   844:                     & iostat = iostat_nml )             ! (out)
   845:                   close( unit_nml )
   846:             
   847:                   call NmlutilMsg( iostat_nml, module_name ) ! (in)
   848:                 end if
   849:             
   850:             
   851:                 ! Identification of calculation method of cloud particle effective radius
   852:                 !
   853:                 call MessageNotify( 'M', module_name, &
   854:                   & 'CloudIceREffMethod=<%c>.', &
   855:                   & c1 = trim(CloudIceREffMethod) )
   856:                 !
   857:                 select case ( CloudIceREffMethod )
   858:                 case ( 'Const' )
   859:                   IDCloudIceREffMethod = IDCloudIceREffMethodConst
   860:                 case ( 'Lin' )
   861:                   IDCloudIceREffMethod = IDCloudIceREffMethodLin
   862:                 case default
   863:                   call MessageNotify( 'E', module_name, &
   864:                     & 'CloudIceREffMethod=<%c> is not supported.', &
   865:                     & c1 = trim(CloudIceREffMethod) )
   866:                 end select
   867:             
   868:             
   869:                 ! Allocate a local variable for O3 distribution
   870:                 !
   871:                 allocate( xyz_QO3(0:imax-1, 1:jmax, 1:kmax) )
   872:             
   873:             
   874:                 ! Initialization of modules used in this module
   875:                 !
   876:             
   877:                 ! 全球一定体積混合比の設定
   878:                 ! Set globally constant volume mixing ratio
   879:                 !
   880:                 call SetGCMRInit
   881:             
   882:                 ! O3 分布の設定
   883:                 ! Set O3 distribution
   884:                 !
   885:                 call SetO3Init
   886:             
   887:             !!$    ! 地球大気向け短波放射モデル Ver. 2.1
   888:             !!$    ! short wave radiation model for the Earth's atmosphere Ver. 2.1
   889:             !!$    !
   890:             !!$    call RadEarthSWV21Init
   891:             !!$
   892:             !!$    ! 地球大気向け短波放射モデル Ver. 2.2
   893:             !!$    ! short wave radiation model for the Earth's atmosphere Ver. 2.2
   894:             !!$    !
   895:             !!$    call RadEarthSWV22Init( &
   896:             !!$      & FlagSnow            &
   897:             !!$      & )
   898:             
   899:                 ! 地球大気向け短波放射モデル Ver. 2.6
   900:                 ! short wave radiation model for the Earth's atmosphere Ver. 2.6
   901:                 !
   902:                 call RadEarthSWV26Init( &
   903:                   & FlagSnow &
   904:                   & )
   905:             
   906:             !!$    ! 地球大気向け長波放射モデル Ver. 2.3
   907:             !!$    ! long wave radiation model for the Earth's atmosphere Ver. 2.3
   908:             !!$    !
   909:             !!$    call RadEarthLWV23Init( &
   910:             !!$      & FlagSnow            &
   911:             !!$      & )
   912:             
   913:                 ! 地球大気向け長波放射モデル Ver. 2.4
   914:                 ! long wave radiation model for the Earth's atmosphere Ver. 2.4
   915:                 !
   916:                 call RadEarthLWV24Init( &
   917:                   & FlagSnow            &
   918:                   & )
   919:             
   920:             
   921:                 ! ヒストリデータ出力のためのへの変数登録
   922:                 ! Register of variables for history data output
   923:                 !
   924:                 call HistoryAutoAddVariable( 'CloudCoverforRad', &
   925:                   & (/ 'lon ', 'lat ', 'sig ', 'time' /), &
   926:                   & 'cloud cover', '1' )
   927:                 call HistoryAutoAddVariable( 'CloudCoverRand', &
   928:                   & (/ 'lon ', 'lat ', 'time' /), &
   929:                   & 'cloud cover', '1' )
   930:             
   931:             
   932:                 ! 印字 ; Print
   933:                 !
   934:                 call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   935:                 call MessageNotify( 'M', module_name, '  CloudWatREff      = %f', &
   936:                   & d = (/ CloudWatREff /) )
   937:                 call MessageNotify( 'M', module_name, '  CloudIceREff      = %f', &
   938:                   & d = (/ CloudIceREff /) )
   939:             !!$    call MessageNotify( 'M', module_name, 'SWVer = %d', i = (/ SWVer /) )
   940:             !!$    call MessageNotify( 'M', module_name, 'LWVer = %d', i = (/ LWVer /) )
   941:                 call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   942:             
   943:             
   944:                 rad_Earth_V2_inited = .true.
   945:             
   946:               end subroutine RadEarthV2Init
   947:             
   948:               !--------------------------------------------------------------------------------------
   949:             
   950:             end module rad_Earth_V2
