Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:59 2016
FILE NAME: rad_Mars_15m.f90
PROGRAM NAME: rad_mars_15m
DIAGNOSTIC LIST

  LINE  LEVEL( NO.): DIAGNOSTIC MESSAGE

   341  opt  (1593): Loop nest collapsed into one loop.
   341  vec  (   1): Vectorized loop.
   341  vec  (  29): ADB is used for array.: xyr_temp
   341  vec  (  29): ADB is used for array.: xyr_press
   341  vec  (  29): ADB is used for array.: xyz_press
   341  vec  (  29): ADB is used for array.: xyz_temp
   351  opt  (1593): Loop nest collapsed into one loop.
   351  vec  (   1): Vectorized loop.
   351  vec  (  29): ADB is used for array.: xyr_temp
   351  vec  (  29): ADB is used for array.: xyr_press
   351  vec  (  29): ADB is used for array.: xyz_press
   351  vec  (  29): ADB is used for array.: xyz_temp
   363  opt  (1593): Loop nest collapsed into one loop.
   363  vec  (   1): Vectorized loop.
   363  vec  (  29): ADB is used for array.: xyr_temp
   363  vec  (  29): ADB is used for array.: xyz_temp
   408  opt  (1593): Loop nest collapsed into one loop.
   408  vec  (   1): Vectorized loop.
   408  vec  (  29): ADB is used for array.: xyr_dod
   408  vec  (  29): ADB is used for array.: xyr_dod067
   425  opt  (1593): Loop nest collapsed into one loop.
   425  vec  (   1): Vectorized loop.
   425  vec  (  29): ADB is used for array.: xyz_press
   427  vec  (  26): Macro operation Max/Min.
   428  vec  (  26): Macro operation Max/Min.
   443  opt  (1593): Loop nest collapsed into one loop.
   443  vec  (   4): Vectorized array expression.
   443  vec  (  29): ADB is used for array.: xyz_mmmass
   444  opt  (1593): Loop nest collapsed into one loop.
   444  vec  (   1): Vectorized loop.
   444  vec  (  29): ADB is used for array.: xyza_vmr
   466  opt  (1593): Loop nest collapsed into one loop.
   466  vec  (   4): Vectorized array expression.
   466  vec  (  29): ADB is used for array.: xy_lnps
   466  vec  (  29): ADB is used for array.: xyr_press
   473  opt  (1592): Outer loop unrolled inside inner loop.
   474  vec  (   1): Vectorized loop.
   474  vec  (  29): ADB is used for array.: trans_i2i_s
   474  vec  (  29): ADB is used for array.: trans_i2i_boa
   474  vec  (  29): ADB is used for array.: trans_i2i_toa
   474  vec  (   1): Vectorized loop.
   474  vec  (  29): ADB is used for array.: trans_i2i_s
   474  vec  (  29): ADB is used for array.: trans_i2i_boa
   474  vec  (  29): ADB is used for array.: trans_i2i_toa
   483  opt  (1592): Outer loop unrolled inside inner loop.
   484  vec  (   1): Vectorized loop.
   484  vec  (  29): ADB is used for array.: trans_i2m_lli
   484  vec  (  29): ADB is used for array.: trans_i2m_uli
   484  vec  (   1): Vectorized loop.
   484  vec  (  29): ADB is used for array.: trans_i2m_lli
   484  vec  (  29): ADB is used for array.: trans_i2m_uli
   525  vec  (   3): Unvectorized loop.
   526  opt  (1017): Subroutine call prevents optimization.
   526  vec  (  10): Vectorization obstructive procedure reference.:getlnac_givenindices
   531  opt  (1593): Loop nest collapsed into one loop.
   531  vec  (   1): Vectorized loop.
   531  vec  (  29): ADB is used for array.: xyza_ac
   553  opt  (1593): Loop nest collapsed into one loop.
   553  vec  (   4): Vectorized array expression.
   553  vec  (  29): ADB is used for array.: xyz_pfrat
   554  opt  (1593): Loop nest collapsed into one loop.
   554  vec  (   1): Vectorized loop.
   554  vec  (  29): ADB is used for array.: xyz_pfrat
   557  opt  (1593): Loop nest collapsed into one loop.
   557  vec  (   4): Vectorized array expression.
   557  vec  (  29): ADB is used for array.: xyz_pfrat
   564  opt  (1592): Outer loop unrolled inside inner loop.
   565  vec  (   1): Vectorized loop.
   565  vec  (  29): ADB is used for array.: trans_i2i_s
   565  vec  (  29): ADB is used for array.: xy_surfpfrat
   565  vec  (  29): ADB is used for array.: trans_i2i_boa
   565  vec  (  29): ADB is used for array.: trans_i2i_toa
   565  vec  (  29): ADB is used for array.: xyr_pfrat
   565  vec  (  29): ADB is used for array.: xyra_trans
   565  vec  (   1): Vectorized loop.
   565  vec  (  29): ADB is used for array.: trans_i2i_s
   565  vec  (  29): ADB is used for array.: xy_surfpfrat
   565  vec  (  29): ADB is used for array.: trans_i2i_boa
   565  vec  (  29): ADB is used for array.: xyr_pfrat
   565  vec  (  29): ADB is used for array.: trans_i2i_toa
   565  vec  (  29): ADB is used for array.: xyra_trans
   587  opt  (1592): Outer loop unrolled inside inner loop.
   588  vec  (   1): Vectorized loop.
   588  vec  (  29): ADB is used for array.: trans_i2m_lli
   588  vec  (  29): ADB is used for array.: trans_i2m_uli
   588  vec  (  29): ADB is used for array.: xyr_pfrat
   588  vec  (  29): ADB is used for array.: xyra_trans
   588  vec  (   1): Vectorized loop.
   588  vec  (  29): ADB is used for array.: trans_i2m_lli
   588  vec  (  29): ADB is used for array.: xyr_pfrat
   588  vec  (  29): ADB is used for array.: trans_i2m_uli
   588  vec  (  29): ADB is used for array.: xyra_trans
   638  opt  (1772): Loop nest fused with following nest(s).
   638  opt  (1593): Loop nest collapsed into one loop.
   638  vec  (   1): Vectorized loop.
   638  vec  (  29): ADB is used for array.: xyra_delrad15mflux
   682  warn (   7): Characters in a line over this form limitation.
   682  warn (   7): Characters in a line over this form limitation.
   682  warn (  82): Name "weight_integral" is not used.
   682  warn (  82): Name "jjs_for_gradcalc" is not used.
   682  warn (  82): Name "kks_for_gradcalc" is not used.
   682  warn (  82): Name "xy_surftemp_for_gradcalc" is not used.
   682  warn (  82): Name "xy_dpfdt" is not used.
   719  opt  (1593): Loop nest collapsed into one loop.
   719  vec  (   4): Vectorized array expression.
   719  vec  (  29): ADB is used for array.: xyra_trans
   722  opt  (1593): Loop nest collapsed into one loop.
   722  vec  (   4): Vectorized array expression.
   724  opt  (1593): Loop nest collapsed into one loop.
   724  vec  (   1): Vectorized loop.
   724  vec  (  29): ADB is used for array.: xyz_delopdep
   724  vec  (  29): ADB is used for array.: xyr_press
   724  vec  (  29): ADB is used for array.: xyz_mmmass
   724  vec  (  29): ADB is used for array.: xyza_vmr
   724  vec  (  29): ADB is used for array.: xyza_ac
   734  opt  (1593): Loop nest collapsed into one loop.
   734  vec  (   1): Vectorized loop.
   734  vec  (  29): ADB is used for array.: xyz_delopdep
   734  vec  (  29): ADB is used for array.: xyr_dod
   739  opt  (1593): Loop nest collapsed into one loop.
   739  vec  (   4): Vectorized array expression.
   739  vec  (  29): ADB is used for array.: xyz_delopdep
   745  vec  (   3): Unvectorized loop.
   745  vec  (  13): Overhead of loop division is too large.
   747  opt  (1593): Loop nest collapsed into one loop.
   747  vec  (   4): Vectorized array expression.
   747  vec  (  29): ADB is used for array.: xyra_trans
   751  opt  (1593): Loop nest collapsed into one loop.
   751  vec  (   4): Vectorized array expression.
   751  vec  (  29): ADB is used for array.: xy_trans
   752  vec  (   3): Unvectorized loop.
   752  vec  (  13): Overhead of loop division is too large.
   753  opt  (  11): Fused array assignments. :line 753 - 754
   753  opt  (1019): Feedback of scalar value from one loop pass to another.
   753  opt  (1593): Loop nest collapsed into one loop.
   753  vec  (   4): Vectorized array expression.
   753  vec  (  29): ADB is used for array.: xyra_trans
   753  vec  (  29): ADB is used for array.: xy_trans
   759  vec  (   3): Unvectorized loop.
   759  vec  (  13): Overhead of loop division is too large.
   760  opt  (1036): Potential feedback - use directive if OK.
   760  opt  (1593): Loop nest collapsed into one loop.
   760  vec  (   4): Vectorized array expression.
   760  vec  (  29): ADB is used for array.: xyra_trans
   765  warn (  82): Name "k2" is not used.
   802  opt  (1593): Loop nest collapsed into one loop.
   802  vec  (   1): Vectorized loop.
   802  vec  (  29): ADB is used for array.: netflh
   812  opt  (1593): Loop nest collapsed into one loop.
   812  vec  (   1): Vectorized loop.
   812  vec  (  29): ADB is used for array.: netflh
   812  vec  (  29): ADB is used for array.: trans_i2i_toa
   812  vec  (  29): ADB is used for array.: xyr_pf
   812  vec  (  29): ADB is used for array.: trans_i2i_boa
   812  vec  (  29): ADB is used for array.: trans_i2i_s
   812  vec  (  29): ADB is used for array.: xy_surfemis
   812  vec  (  29): ADB is used for array.: xy_surfpf
   822  opt  (1593): Loop nest collapsed into one loop.
   822  vec  (   1): Vectorized loop.
   822  vec  (  29): ADB is used for array.: netflh
   822  vec  (  29): ADB is used for array.: trans_i2m_lli
   822  vec  (  29): ADB is used for array.: trans_i2m_uli
   822  vec  (  29): ADB is used for array.: xyr_pf
   849  opt  (1593): Loop nest collapsed into one loop.
   849  vec  (   4): Vectorized array expression.
   849  vec  (  29): ADB is used for array.: xyz_lnpress
   849  vec  (  29): ADB is used for array.: xyz_press
  1242  vec  (   3): Unvectorized loop.
  1242  vec  (   8): Unvectorizable loop structure.
  1243  opt  (1084): Branch out of the loop inhibits optimization.
  1286  opt  (1593): Loop nest collapsed into one loop.
  1286  vec  (   1): Vectorized loop.
  1286  vec  (  29): ADB is used for array.: xyz_ac
  1286  vec  (  29): ADB is used for array.: xyz_lnpress
  1286  vec  (  29): ADB is used for array.: lnp
  1286  vec  (  29): ADB is used for array.: xyz_temp
  1286  vec  (  29): ADB is used for array.: t
  1286  vec  (  29): ADB is used for array.: lnac
  1286  vec  (  29): ADB is used for array.: xyz_kk
  1286  vec  (  29): ADB is used for array.: xyz_jj
  1367  opt  (1593): Loop nest collapsed into one loop.
  1367  vec  (   1): Vectorized loop.
  1367  vec  (  29): ADB is used for array.: xyz_kk
  1376  opt  (1593): Loop nest collapsed into one loop.
  1376  vec  (   1): Vectorized loop.
  1376  vec  (  29): ADB is used for array.: xyz_kk
  1376  vec  (  29): ADB is used for array.: xyz_temp
  1379  opt  (1059): Unable to determine last value of scalar temporary.
  1385  opt  (1593): Loop nest collapsed into one loop.
  1385  vec  (   1): Vectorized loop.
  1385  vec  (  29): ADB is used for array.: xyz_jj
  1393  opt  (1593): Loop nest collapsed into one loop.
  1393  vec  (   1): Vectorized loop.
  1393  vec  (  29): ADB is used for array.: xyz_jj
  1393  vec  (  29): ADB is used for array.: xyz_lnpress
  1396  opt  (1059): Unable to determine last value of scalar temporary.
  1455  opt  (  11): Fused array assignments. :line 1455 - 1456
  1455  opt  (1593): Loop nest collapsed into one loop.
  1455  vec  (   4): Vectorized array expression.
  1455  vec  (  29): ADB is used for array.: xyz_lnpress
  1455  vec  (  29): ADB is used for array.: xy_lnpress
  1455  vec  (  29): ADB is used for array.: xyz_temp
  1455  vec  (  29): ADB is used for array.: xy_temp
  1463  opt  (  11): Fused array assignments. :line 1463 - 1464
  1463  opt  (1593): Loop nest collapsed into one loop.
  1463  vec  (   4): Vectorized array expression.
  1463  vec  (  29): ADB is used for array.: xy_kk
  1463  vec  (  29): ADB is used for array.: xyz_kk
  1463  vec  (  29): ADB is used for array.: xy_jj
  1463  vec  (  29): ADB is used for array.: xyz_jj
  1509  opt  (1593): Loop nest collapsed into one loop.
  1509  vec  (   1): Vectorized loop.
  1509  vec  (  29): ADB is used for array.: xyr_pf
  1516  opt  (1593): Loop nest collapsed into one loop.
  1516  vec  (   1): Vectorized loop.
  1516  vec  (  29): ADB is used for array.: xy_surfpf
  1552  opt  (1593): Loop nest collapsed into one loop.
  1552  vec  (   1): Vectorized loop.
  1552  vec  (  29): ADB is used for array.: xyz_pfrat
  1552  vec  (  29): ADB is used for array.: xyz_lnpress
  1552  vec  (  29): ADB is used for array.: lnp
  1552  vec  (  29): ADB is used for array.: xyz_temp
  1552  vec  (  29): ADB is used for array.: t
  1552  vec  (  29): ADB is used for array.: pfr
  1552  vec  (  29): ADB is used for array.: xyz_kk
  1552  vec  (  29): ADB is used for array.: xyz_jj
  1583  warn (  82): Name "l" is not used.
  1640  opt  (  11): Fused array assignments. :line 1640 - 1643
  1640  opt  (1593): Loop nest collapsed into one loop.
  1640  vec  (   4): Vectorized array expression.
  1640  vec  (  29): ADB is used for array.: xyz_kk
  1640  vec  (  29): ADB is used for array.: xy_kk
  1640  vec  (  29): ADB is used for array.: xyz_jj
  1640  vec  (  29): ADB is used for array.: xy_jj
  1640  vec  (  29): ADB is used for array.: xyz_lnpress
  1640  vec  (  29): ADB is used for array.: xy_lnpress
  1640  vec  (  29): ADB is used for array.: xyz_temp
  1640  vec  (  29): ADB is used for array.: xy_temp
  1651  opt  (1593): Loop nest collapsed into one loop.
  1651  vec  (   4): Vectorized array expression.
  1651  vec  (  29): ADB is used for array.: xy_pfrat
  1651  vec  (  29): ADB is used for array.: xyz_pfrat
  2470  opt  (1593): Loop nest collapsed into one loop.
  2470  vec  (   4): Vectorized array expression.
  2470  vec  (  29): ADB is used for array.: trans_i2i_toa
  2471  opt  (1593): Loop nest collapsed into one loop.
  2471  vec  (   4): Vectorized array expression.
  2471  vec  (  29): ADB is used for array.: trans_i2i_boa
  2472  opt  (1593): Loop nest collapsed into one loop.
  2472  vec  (   4): Vectorized array expression.
  2472  vec  (  29): ADB is used for array.: trans_i2i_s
  2473  opt  (1593): Loop nest collapsed into one loop.
  2473  vec  (   4): Vectorized array expression.
  2473  vec  (  29): ADB is used for array.: trans_i2m_lli
  2474  opt  (1593): Loop nest collapsed into one loop.
  2474  vec  (   4): Vectorized array expression.
  2474  vec  (  29): ADB is used for array.: trans_i2m_uli
  2496  vec  (   1): Vectorized loop.
  2496  vec  (  29): ADB is used for array.: ng
  2497  vec  (  26): Macro operation Sum/InnerProd.
  2521  warn (  82): Name "rad15mnf_fn" is not used.
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:59 2016
FILE NAME: rad_Mars_15m.f90
PROGRAM NAME: rad_mars_15m
TRANSFORMATION LIST

  LINE                   FORTRAN STATEMENT

     1  module rad_Mars_15m
     2  
     3    ! モジュール引用 ; USE statements
     4    !
     5  
     6    ! 種別型パラメタ
     7    ! Kind type parameter
     8    !
     9    use dc_types, only: DP, &      ! 倍精度実数型. Double precision.
    10      &                 STRING, &  ! 文字列.       Strings.
    11      &                 TOKEN      ! キーワード.   Keywords.
    12  
    13    ! 格子点設定
    14    ! Grid points settings
    15    !
    16    use gridset, only: imax, & ! 経度格子点数.
    17                               ! Number of grid points in longitude
    18      &                jmax, & ! 緯度格子点数.
    19                               ! Number of grid points in latitude
    20      &                kmax    ! 鉛直層数.
    21                               ! Number of vertical level
    22  
    23  
    24    ! 宣言文 ; Declaration statements
    25    !
    26    implicit none
    27    private
    28  
    29    ! 公開手続き
    30    ! Public procedure
    31    !
    32    public :: RadMars15mInit
    33    public :: RadMars15m
    34  
    35  
    36    ! 公開変数
    37    ! Public variables
    38    !
    39    logical, save, public:: rad_Mars_15m_inited = .false.
    40                                ! 初期設定フラグ.
    41                                ! Initialization flag.
    42  
    43  
    44    ! 非公開変数
    45    ! Private variables
    46    !
    47    real(DP), parameter :: VMRCO2 = 0.95d0
    48    real(DP), parameter :: AMU    = 1.6605655d-27
    49  
    50  
    51  
    52    ! Variables for radiation calculation
    53    !
    54    ! kg1,kg2,kg3          : maximum number of first, second, third index
    55    !                      :   for tables of absorption coefficient (cumulative
    56    !                      : probability function)
    57    ! kg1(kg1n)            : increament of cumulative probability function
    58    ! kg2(kg2n)            : pressure (hPa)
    59    ! kg3(kg3n)            : temperature (K)
    60    ! dg(kg1n)             : increament of cumulative probability function
    61    ! lnkg???(...,...,...) : table of absorption coefficient as a function of
    62    !                      : cumulative probability function, pressure
    63    !                      : and temperature (m^-1 / (kg m^-2))
    64    !
    65    integer , parameter :: kg1n = 16, kg2n = 55, kg3n = 3
    66    real(DP), save      :: kg1( kg1n ), kg2( kg2n ), kg3( kg3n )
    67    real(DP), save      :: lnkg( kg1n, kg2n, kg3n )
    68  
    69  
    70    ! nl15fn               : maximum number of factors for 15 micron Non-LTE
    71    !                      : radiative cooling rate calculation
    72    ! nl15sn               : "reduced" optical depth for 15 micron Non-LTE
    73    !                      : radiative cooling rate calculation
    74    ! nl15fa               : parameter for 15 micron Non-LTE
    75    !                      : radiative cooling rate calculation
    76    !
    77    integer , parameter :: nl15fn = 70
    78    real(DP), save      :: nl15sn( nl15fn )
    79    real(DP), save      :: nl15fa( nl15fn )
    80  
    81  
    82    ! Variables below must have save attribute since these variables are not
    83    ! necessarily updated every time steps.
    84    !
    85    ! trans0_res : Transmission from top of the atmosphere to each level.
    86    ! trans_res  : Transmission between the atmospheric levels
    87    !
    88  !    real(dp), save :: &
    89  !         trans0_res( km+1, im, jm ), trans_res( km+1, km+1, im, jm )
    90  
    91    real(DP), allocatable, save :: &
    92      trans_res(:,:,:,:)
    93  
    94  
    95    !
    96    !
    97    !
    98    real(DP), parameter :: nlte_refp = 1.0d-2
    99  
   100  
   101    logical , save :: sw_prep_rv
   102    data sw_prep_rv /.false./
   103  
   104  
   105    integer        , parameter :: lc     = 16
   106  
   107  
   108  !!$    character(len=lc   ), save      :: ihed( 5 )
   109  !!$    character(len=lc+lc), save      :: titl( 5 )
   110  !!$    data  ihed / 'RAD_P', 'RAD_PH', 'RAD_T', 'RAD_TS', 'RAD_DOD' /
   111  !!$    data  titl / 'RAD_P', 'RAD_PH', 'RAD_T', 'RAD_TS', 'RAD_DOD' /
   112  
   113  
   114    real(DP),              save :: rad_time
   115    real(DP), allocatable, save :: &
   116      & rad_gp  ( :, :, : ), &
   117      & rad_gph ( :, :, : ), &
   118      & rad_gt  ( :, :, : ), &
   119      & rad_gts ( :, :, : ), &
   120      & rad_gdod( :, :, : )
   121  
   122  
   123    real(DP)             , save :: Rad15mInt
   124  
   125    integer              , save :: nwnl
   126  
   127  
   128  
   129    !
   130    ! nwnsl : number of wavenumber sub loop
   131    !       : (inner most loop for optimization)
   132    !
   133    integer             , save :: nras, nrps
   134    integer             , save :: nwnsl
   135  
   136  
   137  !!$  real(DP)    , allocatable, save :: sgmh_f( : ), sgm_f( : )
   138  !!$  real(DP)    , allocatable, save :: gph_f ( :, :, : ), gp_f( :, :, : ), &
   139  !!$    & gth_f( :, :, : )
   140  !!$
   141  !!$  real(DP)    , allocatable, save :: pfh_f ( :, :, : )
   142  
   143  
   144  
   145    !
   146    ! *_f( :, ... )             :: variable on fine vertical grids
   147    !
   148    ! gvmr_f  ( km, nras+nrps ) :: volume mixing ratio
   149    ! mmmass_f( km )            :: mean molecular mass
   150    !
   151    ! ac( nwnsl, km, nras )   :: absorption coefficient
   152    !
   153    ! trans_f( iwnsl, k1, k2 ) :: transmittance between layer interface k1
   154    !                          :: and layer midlevel k2
   155    !
   156  !!$  real(DP)    , allocatable, save :: gvmr_f  ( :, :, :, : )
   157  !!$  real(DP)    , allocatable, save :: mmmass_f( :, :, : )
   158  !!$  real(DP)    , allocatable, save :: ac_f    ( :, :, :, : )
   159    real(DP)    , allocatable, save :: xyra_Trans (:,:,:,:)
   160  !!$  real(DP)    , allocatable, save :: gdod_f  ( :, :, : )
   161  !!$
   162  !!$  real(DP)    , allocatable, save :: uwflh_f( :, :, : ), dwflh_f( :, :, : )
   163  
   164  
   165  
   166  
   167  
   168    real(DP)    , allocatable, save :: &
   169      & trans_i2i_toa(:,:,:), &          ! f_{1/2}    T_{k+1/2,1/2}
   170      & trans_i2i_boa(:,:,:), &          ! f_{km+1/2} T_{k+1/2,km+1/2}
   171      & trans_i2i_s  (:,:,:), &          ! f_{s}      T_{k+1/2,km+1/2}
   172      & trans_i2m_lli(:,:,:,:), & ! upper layer interface
   173      & trans_i2m_uli(:,:,:,:) ! lower layer interface
   174  
   175  
   176    character(*), parameter:: module_name = 'rad_Mars_15m'
   177                                ! モジュールの名称.
   178                                ! Module name
   179    character(*), parameter:: version = &
   180      & '$Name:  $' // &
   181      & '$Id: rad_Mars_15m.f90,v 1.7 2012/11/10 05:00:50 yot Exp $'
   182                                ! モジュールのバージョン
   183                                ! Module version
   184  
   185  
   186  contains
   187  
   188    !**************************************************************************
   189    ! subroutine rad15m_lowatm_main
   190    ! calculate radiative heating/cooling rate in CO2 15 micron band
   191    !**************************************************************************
   192  
   193    subroutine RadMars15m( Time, DelTime, &
   194      & xyz_Temp, xyr_Press, xyz_Press, xy_SurfTemp, &
   195      & xyr_DOD067, QeRat, SSA, xy_SurfEmis, &
   196      & xyr_Rad15mFlux, xyra_DelRad15mFlux &
   197      & )
   198  
   199      ! メッセージ出力
   200      ! Message output
   201      !
   202      use dc_message, only: MessageNotify
   203  
   204      real(DP)    , intent(in ) :: Time
   205      real(DP)    , intent(in ) :: DelTime
   206      real(DP)    , intent(in ) :: xyz_Temp          (0:imax-1, 1:jmax, 1:kmax)
   207      real(DP)    , intent(in ) :: xyr_Press         (0:imax-1, 1:jmax, 0:kmax)
   208      real(DP)    , intent(in ) :: xyz_Press         (0:imax-1, 1:jmax, 1:kmax)
   209      real(DP)    , intent(in ) :: xy_SurfTemp       (0:imax-1, 1:jmax)
   210      real(DP)    , intent(out) :: xyr_Rad15mFlux    (0:imax-1, 1:jmax, 0:kmax)
   211      real(DP)    , intent(out) :: xyra_DelRad15mFlux(0:imax-1, 1:jmax, 0:kmax, 0:1)
   212      real(DP)    , intent(in ) :: xyr_DOD067        (0:imax-1, 1:jmax, 0:kmax)
   213      real(DP)    , intent(in ) :: QeRat
   214      real(DP)    , intent(in ) :: SSA
   215      real(DP)    , intent(in ) :: xy_SurfEmis       (0:imax-1, 1:jmax)
   216  
   217  
   218      !
   219      ! local variables
   220      !
   221  
   222  
   223      ! 実行文 ; Executable statement
   224      !
   225  
   226      ! 初期化
   227      ! Initialization
   228      !
   229      if ( .not. rad_Mars_15m_inited ) then
   230        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   231      end if
   232  
   233      call rad15m_lowatm_newscheme2006( Time, DelTime, &
   234        & xyz_Temp, xyr_Press, xyz_Press, xy_SurfTemp, &
   235        & xyr_DOD067, QeRat, SSA, xy_SurfEmis, &
   236        & xyr_Rad15mFlux, xyra_DelRad15mFlux &
   237        & )
   238  
   239    end subroutine RadMars15m
   240  
   241    !**************************************************************************
   242    ! subroutine radiation15m
   243    ! calculate radiative heating/cooling rate in CO2 15 micron band
   244    !**************************************************************************
   245  
   246    subroutine rad15m_lowatm_newscheme2006( Time, DelTime, &
   247      & xyz_Temp, xyr_Press, xyz_Press, xy_SurfTemp, &
   248      & xyr_DOD067, QeRat, SSA, xy_SurfEmis, &
   249      & xyr_Rad15mFlux, xyra_DelRad15mFlux &
   250      & )
   251  
   252  
   253      use constants , only : &
   254        & Grav, &
   255        & CpDry
   256  
   257      ! メッセージ出力
   258      ! Message output
   259      !
   260      use dc_message, only: MessageNotify
   261  
   262      use ckd_module, only : ckdp
   263  
   264  
   265      real(DP)    , intent(in ) :: Time
   266      real(DP)    , intent(in ) :: DelTime
   267      real(DP)    , intent(in ) :: xyr_Press(0:imax-1, 1:jmax, 0:kmax)
   268      real(DP)    , intent(in ) :: xyz_Press(0:imax-1, 1:jmax, 1:kmax)
   269      real(DP)    , intent(in ) :: xyz_Temp   (0:imax-1, 1:jmax, 1:kmax)
   270      real(DP)    , intent(in ) :: xy_SurfTemp(0:imax-1, 1:jmax)
   271      real(DP)    , intent(in ) :: xyr_DOD067(0:imax-1, 1:jmax, 0:kmax)
   272      real(DP)    , intent(in ) :: QeRat
   273      real(DP)    , intent(in ) :: SSA
   274      real(DP)    , intent(in ) :: xy_SurfEmis(0:imax-1, 1:jmax)
   275  
   276      real(DP)    , intent(out) :: xyr_Rad15mFlux (0:imax-1, 1:jmax, 0:kmax)
   277      real(DP)    , intent(out) :: xyra_DelRad15mFlux(0:imax-1, 1:jmax, 0:kmax, 0:1)
   278  
   279      !
   280      ! local variables
   281      !
   282      real(DP) :: xyr_Temp  (0:imax-1, 1:jmax, 0:kmax)
   283      real(DP) :: xyz_MMMass(0:imax-1, 1:jmax, 1:kmax)
   284      real(DP) :: xyza_VMR(0:imax-1, 1:jmax, 1:kmax, 1:nras+nrps )
   285      real(DP) :: xyza_AC (0:imax-1, 1:jmax, 1:kmax, 1:nras      )
   286      real(DP) :: xyr_PF   (0:imax-1, 1:jmax, 0:kmax)
   287      real(DP) :: xy_SurfPF(0:imax-1, 1:jmax)
   288  
   289      real(DP) :: xy_DPFDT(0:imax-1, 1:jmax)
   290  
   291      real(DP) :: weight_integral
   292      integer  :: ig, iband
   293  
   294      integer  :: i, j, k, l, m, n
   295      integer  :: k2
   296  
   297      !
   298      ! dod      : dust optical depth
   299      !
   300      real(DP) :: xyr_DOD(0:imax-1, 1:jmax, 0:kmax)
   301  
   302      !
   303      ! local variables for pfint
   304      !
   305  
   306      real(DP) :: MinPress
   307      real(DP) :: MaxPress
   308  
   309      integer  :: iband_reserve
   310      real(DP) :: xy_lnPs    (0:imax-1, 1:jmax)
   311      real(DP) :: xyz_lnPress(0:imax-1, 1:jmax, 1:kmax )
   312      integer  :: xyz_jj(0:imax-1, 1:jmax, 1:kmax)
   313      integer  :: xyz_kk(0:imax-1, 1:jmax, 1:kmax)
   314      integer  :: xy_jj (0:imax-1, 1:jmax)
   315      integer  :: xy_kk (0:imax-1, 1:jmax)
   316  
   317  
   318      ! Surface temperature for calculation of gradient of radiative flux
   319      real(DP) :: xy_SurfTemp_for_gradcalc(0:imax-1, 1:jmax)
   320      ! Indices for calculation of gradient of radiative flux
   321      integer  :: jjs_for_gradcalc(0:imax-1, 1:jmax), kks_for_gradcalc(0:imax-1, 1:jmax)
   322  
   323      real(DP)     :: xyr_PFRat   (0:imax-1, 1:jmax, 0:kmax)
   324      real(DP)     :: xyz_PFRat   (0:imax-1, 1:jmax, 1:kmax)
   325      real(DP)     :: xy_SurfPFRat(0:imax-1, 1:jmax)
   326  
   327      logical, save :: FlagCalcTrans
   328  
   329      data FlagCalcTrans / .false. /
   330  
   331  
   332      ! 初期化
   333      ! Initialization
   334      !
   335      if ( .not. rad_Mars_15m_inited ) then
   336        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   337      end if
   338  
   339  
   340      k = 0
   341      do j = 1, jmax
   342        do i = 0, imax-1
   343  !!$        gth(i,j,k) = gt(i,j,k+1)
   344          xyr_Temp(i,j,k) = &
   345            &  ( xyz_Temp(i,j,2) - xyz_Temp(i,j,1) ) &
   346            & / log( xyz_Press(i,j,2) / xyz_Press(i,j,1) ) &
   347            & * log( xyr_Press(i,j,k) / xyz_Press(i,j,1) ) &
   348            & + xyz_Temp(i,j,1)
   349        end do
   350      end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do j = 1, jmax*imax                                               
     .           xyr_temp(j-1,1,0) = (xyz_temp(j-1,1,2)-xyz_temp(j-1,1,1))/dlog(
     .       1      xyz_press(j-1,1,2)/xyz_press(j-1,1,1))*dlog(xyr_press(j-1,1,
     .       2      0)/xyz_press(j-1,1,1)) + xyz_temp(j-1,1,1)                  
     .        enddo                                                             
   351      do k = 1, kmax-1
   352        do j = 1, jmax
   353          do i = 0, imax-1
   354            xyr_Temp(i,j,k) = &
   355              &  ( xyz_Temp(i,j,k+1) - xyz_Temp(i,j,k) ) &
   356              & / log( xyz_Press(i,j,k+1) / xyz_Press(i,j,k) ) &
   357              & * log( xyr_Press(i,j,k  ) / xyz_Press(i,j,k) ) &
   358              & + xyz_Temp(i,j,k)
   359          end do
   360        end do
   361      end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do k = 1, jmax*(kmax*imax - imax)                                 
     .           xyr_temp(k-1,1,1) = (xyz_temp(k-1,1,2)-xyz_temp(k-1,1,1))/dlog(
     .       1      xyz_press(k-1,1,2)/xyz_press(k-1,1,1))*dlog(xyr_press(k-1,1,
     .       2      1)/xyz_press(k-1,1,1)) + xyz_temp(k-1,1,1)                  
     .        enddo                                                             
   362      k = kmax
   363      do j = 1, jmax
   364        do i = 0, imax-1
   365          xyr_Temp(i,j,k) = xyz_Temp(i,j,k)
   366        end do
   367      end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do j = 1, jmax*imax                                               
     .           xyr_temp(j-1,1,k) = xyz_temp(j-1,1,k)                          
     .        enddo                                                             
   368  
   369  
   370  !!$    do k = 1, km*nvr+1
   371  !!$      do ij = ijs, ije
   372  !!$        gph_f( ij, 1, k ) = sgmh_f( k ) * gph( ij, 1, km+1 )
   373  !!$      end do
   374  !!$    end do
   375  !!$    call calc_lnp( im, jm, km*nvr+1, gph_f , glnph_f , ijs, ije )
   376  !!$
   377  !!$    call increase_vreso_boundary_arr3d( im, jm, km, nvr, gth, gth_f, &
   378  !!$      & "linear", ijs, ije )
   379  
   380  
   381  
   382      if (  .not. FlagCalcTrans ) then
   383        if ( Time - dble( int( Time / Rad15mInt ) ) * Rad15mInt < DelTime ) then
   384          call MessageNotify( 'M', module_name, &
   385            & 'Transmittance is not saved, but criterion for transmittance calculation is met.' )
   386        else
   387          call MessageNotify( 'M', module_name, &
   388            & 'Transmittance is not saved, and criterion for transmittance calculation ' &
   389            & // 'is not met. However, transmittance will be calculated.' )
   390        end if
   391      end if
   392  
   393  
   394      !
   395      ! Calculation of transmission
   396      !
   397      if( ( .not. FlagCalcTrans ) .or. &
   398        & ( Time - dble( int( Time / Rad15mInt )  ) * Rad15mInt ) < DelTime ) then
   399  
   400        FlagCalcTrans = .true.
   401  
   402  !!$      call MessageNotify( 'M', module_name, 'Transmission is calculated.' )
   403  
   404        !
   405        ! Calculation of "absorption" dust optical depth
   406        ! This formulation is obtained from Forget et al. [1999].
   407        !
   408        do k = 0, kmax
   409          do j = 1, jmax
   410            do i = 0, imax-1
   411              xyr_DOD(i,j,k) = ( 1.0d0 - SSA ) * xyr_DOD067(i,j,k) * QeRat
   412            end do
   413          end do
   414        end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do k = 1, jmax*(kmax*imax + imax)                                 
     .           xyr_dod(k-1,1,0) = (1.00000000000000e+000 - ssa)*xyr_dod067(k-1
     .       1      ,1,0)*qerat                                                 
     .        enddo                                                             
   415  
   416  !!$      call increase_vreso_boundary_arr3d( im, jm, km, nvr, gdod, gdod_f, &
   417  !!$        & "log", ijs, ije )
   418  
   419  
   420        !
   421        ! check pressure
   422        !
   423        MinPress = 1.0d100
   424        MaxPress = 0.0d0
   425        do j = 1, jmax
   426          do i = 0, imax-1
   427            MinPress = min( MinPress, xyz_Press(i,j,kmax) )
   428            MaxPress = max( MaxPress, xyz_Press(i,j,1   ) )
   429          end do
   430        end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do j = 1, jmax*imax                                               
     .           minpress = min(minpress,xyz_press(j-1,1,kmax))                 
     .           maxpress = max(maxpress,xyz_press(j-1,1,1))                    
     .        enddo                                                             
   431        if( ckdp(1)%lnp(1) > log(MinPress) ) then
   432          write( 6, * ) 'MARS: pressure is too small.'
   433          write( 6, * ) MinPress, exp(ckdp(1)%lnp(1))
   434          stop
   435        end if
   436        if( ckdp(1)%lnp(ckdp(1)%nlnp) .lt. log(MaxPress) ) then
   437          write( 6, * ) 'MARS: pressure is too large.'
   438          write( 6, * ) MaxPress, exp(ckdp(1)%lnp(ckdp(1)%nlnp))
   439          stop
   440        end if
   441  
   442  
   443        xyz_MMMass = 43.5d0 * AMU
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1462 = 1, xyz_mmmass.DSC.U3*(xyz_mmmass.DSC.U2*               
     .       1   xyz_mmmass.DSC.U1 + xyz_mmmass.DSC.U2)                         
     .           xyz_mmmass(t1462-1,1,1) = 7.22345992499999e-026                
     .        enddo                                                             
   444        do n = 1, nras + nrps
   445          do k = 1, kmax
   446            do j = 1, jmax
   447              do i = 0, imax-1
   448                xyza_VMR(i,j,k,n) = VMRCO2
   449              end do
   450            end do
   451          end do
   452        end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do n = 1, (nras + nrps)*kmax*jmax*imax                            
     .           xyza_vmr(n-1,1,1,1) = 9.49999999999999e-001                    
     .        enddo                                                             
   453  
   454  
   455  !!$      do n = 1, nras + nrps
   456  !!$        call increase_vreso_b2m_arr3d( im, jm, km, nvr, &
   457  !!$          & gvmrh(:,:,:,n), gvmr_f(:,:,:,n), "log", &
   458  !!$          & ijs, ije )
   459  !!$      end do
   460  !!$      call increase_vreso_b2m_arr3d( im, jm, km, nvr, &
   461  !!$        & mmmassh, mmmass_f, "linear", &
   462  !!$        & ijs, ije )
   463  
   464  !!$      call calc_lnp( im, jm, km+1    , gph   , glnph   , ijs, ije )
   465        call calc_lnp( xyz_Press, xyz_lnPress )
   466        xy_lnPs(:,:) = log( xyr_Press(:,:,0) )
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1471 = 1, jmax*imax                                           
     .           xy_lnps(t1471-1,1) = dlog(xyr_press(t1471-1,1,0))              
     .        enddo                                                             
   467  
   468  
   469        !
   470        ! initialization
   471        !
   472        do k = 0, kmax
   473          do j = 1, jmax
   474            do i = 0, imax-1
   475              trans_i2i_toa(i,j,k) = 0.0d0         ! f_{1/2}    T_{k+1/2,1/2}
   476              trans_i2i_boa(i,j,k) = 0.0d0         ! f_{km+1/2} T_{k+1/2,km+1/2}
   477              trans_i2i_s  (i,j,k) = 0.0d0         ! f_{s}      T_{k+1/2,km+1/2}
   478            end do
   479          end do
     .        if (jmax .gt. 0) then                                             
     .           j1 = and(jmax,3)                                               
     .           do j = 1, j1                                                   
     .  !cdir       nodep                                                       
     .              do i = 1, imax                                              
     .                 trans_i2i_toa(i-1,j,k) = 0.0000000000000000e+000         
     .                 trans_i2i_boa(i-1,j,k) = 0.0000000000000000e+000         
     .                 trans_i2i_s(i-1,j,k) = 0.0000000000000000e+000           
     .              enddo                                                       
     .           enddo                                                          
     .           do j = j1 + 1, jmax, 4                                         
     .  !cdir       nodep                                                       
     .              do i = 1, imax                                              
     .                 trans_i2i_toa(i-1,j,k) = 0.0000000000000000e+000         
     .                 trans_i2i_toa(i-1,j+1,k) = 0.0000000000000000e+000       
     .                 trans_i2i_toa(i-1,j+2,k) = 0.0000000000000000e+000       
     .                 trans_i2i_toa(i-1,j+3,k) = 0.0000000000000000e+000       
     .                 trans_i2i_boa(i-1,j,k) = 0.0000000000000000e+000         
     .                 trans_i2i_boa(i-1,j+1,k) = 0.0000000000000000e+000       
     .                 trans_i2i_boa(i-1,j+2,k) = 0.0000000000000000e+000       
     .                 trans_i2i_boa(i-1,j+3,k) = 0.0000000000000000e+000       
     .                 trans_i2i_s(i-1,j,k) = 0.0000000000000000e+000           
     .                 trans_i2i_s(i-1,j+1,k) = 0.0000000000000000e+000         
     .                 trans_i2i_s(i-1,j+2,k) = 0.0000000000000000e+000         
     .                 trans_i2i_s(i-1,j+3,k) = 0.0000000000000000e+000         
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
   480        end do
   481        do k2 = 1, kmax
   482          do k = 0, kmax
   483            do j = 1, jmax
   484              do i = 0, imax-1
   485                trans_i2m_uli(i,j,k,k2) = 0.0d0
   486                trans_i2m_lli(i,j,k,k2) = 0.0d0
   487              end do
   488            end do
     .        if (jmax .gt. 0) then                                             
     .           j2 = and(jmax,3)                                               
     .           do j = 1, j2                                                   
     .  !cdir       nodep                                                       
     .              do i = 1, imax                                              
     .                 trans_i2m_uli(i-1,j,k,k2) = 0.0000000000000000e+000      
     .                 trans_i2m_lli(i-1,j,k,k2) = 0.0000000000000000e+000      
     .              enddo                                                       
     .           enddo                                                          
     .           do j = j2 + 1, jmax, 4                                         
     .  !cdir       nodep                                                       
     .              do i = 1, imax                                              
     .                 trans_i2m_uli(i-1,j,k,k2) = 0.0000000000000000e+000      
     .                 trans_i2m_uli(i-1,j+1,k,k2) = 0.0000000000000000e+000    
     .                 trans_i2m_uli(i-1,j+2,k,k2) = 0.0000000000000000e+000    
     .                 trans_i2m_uli(i-1,j+3,k,k2) = 0.0000000000000000e+000    
     .                 trans_i2m_lli(i-1,j,k,k2) = 0.0000000000000000e+000      
     .                 trans_i2m_lli(i-1,j+1,k,k2) = 0.0000000000000000e+000    
     .                 trans_i2m_lli(i-1,j+2,k,k2) = 0.0000000000000000e+000    
     .                 trans_i2m_lli(i-1,j+3,k,k2) = 0.0000000000000000e+000    
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
   489          end do
   490        end do
   491  
   492  
   493        !
   494        ! loop for wavenumber
   495        !
   496  
   497        iband_reserve = 0
   498  
   499        do m = 1, nwnl
   500  
   501          call m2ckdpindices( m, ig, iband )
   502  
   503  
   504          if( iband .ne. iband_reserve ) then
   505            call findindices3D( &
   506              & xyz_Temp, xyz_lnPress, iband, &
   507              & xyz_jj, xyz_kk &
   508              & )
   509            call findindices2D(   &
   510              & xy_SurfTemp, xy_lnPs,       &
   511              & iband, xy_jj, xy_kk   &
   512              & )
   513  
   514            iband_reserve = iband
   515          end if
   516  
   517  
   518          ! IMPORTANT!
   519          ! This loop for n is confusing.
   520          ! We have to reconsider about it.
   521          ! Maybe, the component of ckdp structure has to be reconsidered.
   522          ! Now, it cannot include multiple radiatively active species.
   523          ! (yot, 2010/09/12)
   524          !
   525          do n = 1, nras
   526            call getlnac_givenindices( &
   527              & xyz_Temp, xyz_lnPress, xyz_jj, xyz_kk, ig, iband, &
   528              & xyza_AC(:,:,:,n) &
   529              & )
   530          end do
   531          do n = 1, nras
   532            xyza_AC(:,:,:,n) = exp( xyza_AC(:,:,:,n) )
   533          end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do n = 1, nras*xyza_ac.DSC.U3*xyza_ac.DSC.U2*(xyza_ac.DSC.U1 + 1) 
     .           xyza_ac(n-1,1,1,1) = dexp(xyza_ac(n-1,1,1,1))                  
     .        enddo                                                             
   534  
   535  !!$        do n = 1, nras
   536  !!$          call increase_vreso_b2m_arr3d( im, jm, km, nvr, &
   537  !!$            & ach(:,:,:,n), ac_f(:,:,:,n), "log", &
   538  !!$            & ijs, ije )
   539  !!$        end do
   540  
   541  
   542          call calc_trans_mp_arr3d(   &
   543            & nras, nrps, xyr_Press, xyza_VMR, xyz_MMMass, &
   544            & xyza_AC, xyr_DOD,                     &
   545            & xyra_Trans                         &
   546            & )
   547  
   548  
   549          call getpfr_givenindices3D( &
   550            & xyz_Temp, xyz_lnPress, xyz_jj, xyz_kk, ig, iband, &
   551            & xyz_PFRat &
   552            & )
   553          xyr_PFRat(:,:,0) = xyz_PFRat(:,:,1)
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1491 = 1, xyr_pfrat.DSC.U2*xyr_pfrat.DSC.U1 + xyr_pfrat.DSC.U2
     .           xyr_pfrat(t1491-1,1,0) = xyz_pfrat(t1491-1,1,1)                
     .        enddo                                                             
   554          do k = 1, kmax-1
   555            xyr_PFRat(:,:,k) = ( xyz_PFRat(:,:,k) + xyz_PFRat(:,:,k+1) ) * 0.5_DP
   556          end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do k = 1, (kmax - 1)*xyz_pfrat.DSC.U2*(xyz_pfrat.DSC.U1 + 1)      
     .           xyr_pfrat(k-1,1,1) = (xyz_pfrat(k-1,1,1)+xyz_pfrat(k-1,1,2))*  
     .       1      5.00000000000000e-001                                       
     .        enddo                                                             
   557          xyr_PFRat(:,:,kmax) = xyz_PFRat(:,:,kmax)
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1509 = 1, xyr_pfrat.DSC.U2*xyr_pfrat.DSC.U1 + xyr_pfrat.DSC.U2
     .           xyr_pfrat(t1509-1,1,kmax) = xyz_pfrat(t1509-1,1,kmax)          
     .        enddo                                                             
   558          call getpfr_givenindices2D( &
   559            & xy_SurfTemp, xy_lnPs, xy_jj, xy_kk, ig, iband, &
   560            & xy_SurfPFRat &
   561            & )
   562  
   563          do k = 0, kmax
   564            do j = 1, jmax
   565              do i = 0, imax-1
   566                trans_i2i_toa(i,j,k) =       &        ! f_{1/2}    T_{k+1/2,1/2}
   567                  & trans_i2i_toa(i,j,k)     &
   568                  & + xyra_Trans(i,j,k,kmax)      &
   569                  & * xyr_PFRat(i,j,kmax)    &
   570                  & * ckdp(iband)%weight(ig)
   571                trans_i2i_boa(i,j,k) =       &        ! f_{km+1/2} T_{k+1/2,km+1/2}
   572                  & trans_i2i_boa(i,j,k)     &
   573                  & + xyra_Trans(i,j,k,0)         &
   574                  & * xyr_PFRat(i,j,0)       &
   575                  & * ckdp(iband)%weight(ig)
   576                trans_i2i_s  (i,j,k) =       &        ! f_{s}      T_{k+1/2,km+1/2}
   577                  & trans_i2i_s  (i,j,k)     &
   578                  & + xyra_Trans(i,j,k,0)         &
   579                  & * xy_SurfPFRat(i,j)      &
   580                  & * ckdp(iband)%weight(ig)
   581              end do
   582            end do
     .        if (jmax .gt. 0) then                                             
     .           j3 = and(jmax,3)                                               
     .           do j = 1, j3                                                   
     .  !cdir       nodep                                                       
     .  !cdir       on_adb(xyr_pfrat,xy_surfpfrat)                              
     .              do i = 1, imax                                              
     .                 trans_i2i_toa(i-1,j,k) = trans_i2i_toa(i-1,j,k) +        
     .       1            xyra_trans(i-1,j,k,kmax)*xyr_pfrat(i-1,j,kmax)*       
     .       2            ckdp.weight(ig,iband)                                 
     .                 trans_i2i_boa(i-1,j,k) = trans_i2i_boa(i-1,j,k) + (      
     .       1            xyra_trans(i-1,j,k,0)*ckdp.weight(ig,iband))*xyr_pfrat
     .       2            (i-1,j,0)                                             
     .                 trans_i2i_s(i-1,j,k) = trans_i2i_s(i-1,j,k) + (xyra_trans
     .       1            (i-1,j,k,0)*ckdp.weight(ig,iband))*xy_surfpfrat(i-1,j)
     .              enddo                                                       
     .           enddo                                                          
     .           do j = j3 + 1, jmax, 4                                         
     .  !cdir       nodep                                                       
     .  !cdir       on_adb(xyr_pfrat,xy_surfpfrat)                              
     .              do i = 1, imax                                              
     .                 d1 = ckdp.weight(ig,iband)                               
     .                 trans_i2i_toa(i-1,j,k) = trans_i2i_toa(i-1,j,k) +        
     .       1            xyra_trans(i-1,j,k,kmax)*xyr_pfrat(i-1,j,kmax)*d1     
     .                 trans_i2i_toa(i-1,j+1,k) = trans_i2i_toa(i-1,j+1,k) +    
     .       1            xyra_trans(i-1,j+1,k,kmax)*xyr_pfrat(i-1,j+1,kmax)*d1 
     .                 trans_i2i_toa(i-1,j+2,k) = trans_i2i_toa(i-1,j+2,k) +    
     .       1            xyra_trans(i-1,j+2,k,kmax)*xyr_pfrat(i-1,j+2,kmax)*d1 
     .                 trans_i2i_toa(i-1,j+3,k) = trans_i2i_toa(i-1,j+3,k) +    
     .       1            xyra_trans(i-1,j+3,k,kmax)*xyr_pfrat(i-1,j+3,kmax)*d1 
     .                 trans_i2i_boa(i-1,j,k) = trans_i2i_boa(i-1,j,k) + (      
     .       1            xyra_trans(i-1,j,k,0)*d1)*xyr_pfrat(i-1,j,0)          
     .                 trans_i2i_boa(i-1,j+1,k) = trans_i2i_boa(i-1,j+1,k) + (  
     .       1            xyra_trans(i-1,j+1,k,0)*d1)*xyr_pfrat(i-1,j+1,0)      
     .                 trans_i2i_boa(i-1,j+2,k) = trans_i2i_boa(i-1,j+2,k) + (  
     .       1            xyra_trans(i-1,j+2,k,0)*d1)*xyr_pfrat(i-1,j+2,0)      
     .                 trans_i2i_boa(i-1,j+3,k) = trans_i2i_boa(i-1,j+3,k) + (  
     .       1            xyra_trans(i-1,j+3,k,0)*d1)*xyr_pfrat(i-1,j+3,0)      
     .                 trans_i2i_s(i-1,j,k) = trans_i2i_s(i-1,j,k) + (xyra_trans
     .       1            (i-1,j,k,0)*d1)*xy_surfpfrat(i-1,j)                   
     .                 trans_i2i_s(i-1,j+1,k) = trans_i2i_s(i-1,j+1,k) + (      
     .       1            xyra_trans(i-1,j+1,k,0)*d1)*xy_surfpfrat(i-1,j+1)     
     .                 trans_i2i_s(i-1,j+2,k) = trans_i2i_s(i-1,j+2,k) + (      
     .       1            xyra_trans(i-1,j+2,k,0)*d1)*xy_surfpfrat(i-1,j+2)     
     .                 trans_i2i_s(i-1,j+3,k) = trans_i2i_s(i-1,j+3,k) + (      
     .       1            xyra_trans(i-1,j+3,k,0)*d1)*xy_surfpfrat(i-1,j+3)     
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
   583          end do
   584  
   585          do k2 = 1, kmax
   586            do k = 0, kmax
   587              do j = 1, jmax
   588                do i = 0, imax-1
   589                  trans_i2m_uli(i,j,k,k2) =                              &
   590                    & trans_i2m_uli(i,j,k,k2)                            &
   591                    & + ( xyra_Trans(i,j,k,k2-1) + xyra_Trans(i,j,k,k2) ) * 0.5d0  &
   592                    & * xyr_PFRat(i,j,k2  )                              &
   593                    & * ckdp(iband)%weight(ig)
   594                  trans_i2m_lli(i,j,k,k2) =                              &
   595                    & trans_i2m_lli(i,j,k,k2)                            &
   596                    & + ( xyra_Trans(i,j,k,k2-1) + xyra_Trans(i,j,k,k2) ) * 0.5d0  &
   597                    & * xyr_PFRat(i,j,k2-1)                              &
   598                    & * ckdp(iband)%weight(ig)
   599                end do
   600              end do
     .        if (jmax .gt. 0) then                                             
     .           j4 = and(jmax,3)                                               
     .           do j = 1, j4                                                   
     .  !cdir       nodep                                                       
     .  !cdir       on_adb(xyr_pfrat,xyra_trans)                                
     .              do i = 1, imax                                              
     .                 trans_i2m_uli(i-1,j,k,k2) = trans_i2m_uli(i-1,j,k,k2) + (
     .       1            (xyra_trans(i-1,j,k,k2-1)+xyra_trans(i-1,j,k,k2))*    
     .       2            5.00000000000000e-001)*xyr_pfrat(i-1,j,k2)*ckdp.weight
     .       3            (ig,iband)                                            
     .                 trans_i2m_lli(i-1,j,k,k2) = trans_i2m_lli(i-1,j,k,k2) + (
     .       1            (xyra_trans(i-1,j,k,k2-1)+xyra_trans(i-1,j,k,k2))*    
     .       2            5.00000000000000e-001)*xyr_pfrat(i-1,j,k2-1)*         
     .       3            ckdp.weight(ig,iband)                                 
     .              enddo                                                       
     .           enddo                                                          
     .           do j = j4 + 1, jmax, 4                                         
     .  !cdir       nodep                                                       
     .  !cdir       on_adb(xyr_pfrat,xyra_trans)                                
     .              do i = 1, imax                                              
     .                 d2 = ckdp.weight(ig,iband)                               
     .                 trans_i2m_uli(i-1,j,k,k2) = trans_i2m_uli(i-1,j,k,k2) + (
     .       1            (xyra_trans(i-1,j,k,k2-1)+xyra_trans(i-1,j,k,k2))*    
     .       2            5.00000000000000e-001)*xyr_pfrat(i-1,j,k2)*d2         
     .                 trans_i2m_uli(i-1,j+1,k,k2) = trans_i2m_uli(i-1,j+1,k,k2)
     .       1             + ((xyra_trans(i-1,j+1,k,k2-1)+xyra_trans(i-1,j+1,k, 
     .       2            k2))*5.00000000000000e-001)*xyr_pfrat(i-1,j+1,k2)*d2  
     .                 trans_i2m_uli(i-1,j+2,k,k2) = trans_i2m_uli(i-1,j+2,k,k2)
     .       1             + ((xyra_trans(i-1,j+2,k,k2-1)+xyra_trans(i-1,j+2,k, 
     .       2            k2))*5.00000000000000e-001)*xyr_pfrat(i-1,j+2,k2)*d2  
     .                 trans_i2m_uli(i-1,j+3,k,k2) = trans_i2m_uli(i-1,j+3,k,k2)
     .       1             + ((xyra_trans(i-1,j+3,k,k2-1)+xyra_trans(i-1,j+3,k, 
     .       2            k2))*5.00000000000000e-001)*xyr_pfrat(i-1,j+3,k2)*d2  
     .                 trans_i2m_lli(i-1,j,k,k2) = trans_i2m_lli(i-1,j,k,k2) + (
     .       1            (xyra_trans(i-1,j,k,k2-1)+xyra_trans(i-1,j,k,k2))*    
     .       2            5.00000000000000e-001)*xyr_pfrat(i-1,j,k2-1)*d2       
     .                 trans_i2m_lli(i-1,j+1,k,k2) = trans_i2m_lli(i-1,j+1,k,k2)
     .       1             + ((xyra_trans(i-1,j+1,k,k2-1)+xyra_trans(i-1,j+1,k, 
     .       2            k2))*5.00000000000000e-001)*xyr_pfrat(i-1,j+1,k2-1)*d2
     .                 trans_i2m_lli(i-1,j+2,k,k2) = trans_i2m_lli(i-1,j+2,k,k2)
     .       1             + ((xyra_trans(i-1,j+2,k,k2-1)+xyra_trans(i-1,j+2,k, 
     .       2            k2))*5.00000000000000e-001)*xyr_pfrat(i-1,j+2,k2-1)*d2
     .                 trans_i2m_lli(i-1,j+3,k,k2) = trans_i2m_lli(i-1,j+3,k,k2)
     .       1             + ((xyra_trans(i-1,j+3,k,k2-1)+xyra_trans(i-1,j+3,k, 
     .       2            k2))*5.00000000000000e-001)*xyr_pfrat(i-1,j+3,k2-1)*d2
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
   601            end do
   602          end do
   603  
   604  
   605        end do
   606  
   607  
   608  !!$      call rad15m_rv_put_newscheme2006( time, gt, gph, gp, gts, gdod, ijs, ije )
   609  
   610      else
   611  
   612        if ( trans_i2i_toa(0,1,1) > 1.0d99 ) then
   613          write( 6, * ) 'transmission function would not be calculated.'
   614          stop
   615        end if
   616  
   617      end if
   618  
   619  
   620      ! Is this OK?
   621      iband = 1
   622  
   623      call getpf_arr3d_norat( &
   624        & xyr_Temp, xy_SurfTemp, iband, &
   625        & xyr_PF, xy_SurfPF &
   626        & )
   627  
   628  
   629      call calc_rteq_use_meantrans_arr3d( &
   630        & ( ckdp(iband)%wnbnds(2) - ckdp(iband)%wnbnds(1) ), xy_SurfEmis, &
   631        & trans_i2i_toa, trans_i2i_boa, trans_i2i_s, &
   632        & trans_i2m_lli, trans_i2m_uli, &
   633        & xyr_PF, xy_SurfPF, xyr_Rad15mFlux &
   634        & )
   635  
   636  
   637      do l = 0, 1
   638        do k = 0, kmax
   639          do j = 1, jmax
   640            do i = 0, imax-1
   641              xyra_DelRad15mFlux(i,j,k,l) = 0.0_DP
   642            end do
   643          end do
   644        end do
   645      end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do k = 1, jmax*(kmax*imax + imax)                                 
     .           xyra_delrad15mflux(k-1,1,0,0) = 0.0000000000000000e+000        
     .           xyra_delrad15mflux(k-1,1,0,1) = 0.0000000000000000e+000        
     .        enddo                                                             
   646  
   647  
   648  !!$    do k = kmax, 0, -1
   649  !!$      write( 6, * ) gph(0,1,k), gr15mnetflh(0,1,k)
   650  !!$    end do
   651  !!$    stop
   652  
   653  
   654  !!$      ij = ( ije - ijs + 1 ) / 2
   655  !!$      k  = km + 1
   656  !!$!      write( 6, * ) 'RAD15M : ', gr15mnetflh(ij,1,k), rad_gdr15mnetfldtsh0(ij,1,k-1) * ( gts(ij,1) - rad_gtsbase(ij,1,1) ), emis(ij,1) * 5.67d-8 * gts(ij,1)**4, gts(ij,1)
   657  !!$!      write( 61, * ) gr15mnetflh(ij,1,k-1), rad_gdr15mnetfldtsh0(ij,1,k-1) * ( gts(ij,1) - rad_gtsbase(ij,1,1) ), emis(ij,1) * 5.67d-8 * gts(ij,1)**4, gts(ij,1), gt(ij,1,km), gt(ij,1,km-1), gt(ij,1,km-2), gt(ij,1,km-3), gt(ij,1,km-4), gt(ij,1,km-5)
   658  !!$      write( 6, * ) 'RAD15M : ', gr15mnetflh(ij,1,k), &
   659  !!$        & emis(ij,1) * 5.67d-8 * gts(ij,1)**4, gts(ij,1)
   660  !!$      write( 61, * ) gr15mnetflh(ij,1,k-1), &
   661  !!$        & emis(ij,1) * 5.67d-8 * gts(ij,1)**4, gts(ij,1), &
   662  !!$        & gt(ij,1,km), gt(ij,1,km-1), gt(ij,1,km-2), gt(ij,1,km-3), &
   663  !!$        & gt(ij,1,km-4), gt(ij,1,km-5)
   664  !!$      call flush( 61 )
   665  
   666      !
   667      ! output variables
   668      !
   669  !!$    do j = 1, jmax
   670  !!$      do i = 0, imax-1
   671  !!$        goru(i,j) = uwflh_sum(i,j,kmax)
   672  !!$        gord(i,j) = 0.0d0
   673  !!$        gsru(i,j) = uwflh_sum(i,j,0)
   674  !!$        gsrd(i,j) = dwflh_sum(i,j,0)
   675  !!$        gor (i,j) = goru(i,j) - gord(i,j)
   676  !!$        gsr (i,j) = gsru(i,j) - gsrd(i,j)
   677  !!$      end do
   678  !!$    end do
   679  
   680  
   681  
   682    end subroutine rad15m_lowatm_newscheme2006
   683  
   684    !**************************************************************************
   685  
   686    subroutine calc_trans_mp_arr3d(   &
   687      & nras, nrps, xyr_Press, xyza_VMR, xyz_MMMass, &
   688      & xyza_AC, xyr_DOD,                     &
   689      & xyra_Trans                         &
   690      & )
   691  
   692      use constants , only : &
   693        & Grav
   694  
   695      integer , intent(in ) :: nras
   696      integer , intent(in ) :: nrps
   697      real(DP), intent(in ) :: xyr_Press(0:imax-1, 1:jmax, 0:kmax)
   698      real(DP), intent(in ) :: xyza_VMR (0:imax-1, 1:jmax, 1:kmax, 1:nras+nrps)
   699      real(DP), intent(in ) :: xyz_MMMass(0:imax-1, 1:jmax, 1:kmax)
   700      real(DP), intent(in ) :: xyza_AC(0:imax-1, 1:jmax, 1:kmax, 1:nras)
   701      real(DP), intent(in ) :: xyr_DOD(0:imax-1, 1:jmax, 0:kmax)
   702      real(DP), intent(out) :: xyra_Trans  (0:imax-1, 1:jmax, 0:kmax, 0:kmax)
   703  
   704  
   705      !
   706      ! local variables
   707      !
   708      real(DP)     :: xyz_DelOpDep(0:imax-1, 1:jmax, 1:kmax)
   709      real(DP)     :: xyz_DelTrans(0:imax-1, 1:jmax, 1:kmax)
   710      real(DP)     :: xy_Trans(0:imax-1, 1:jmax)
   711      real(DP), parameter :: DifFac = 1.66_DP
   712  
   713  
   714      integer :: k, k2, n
   715      integer :: ks, ke
   716  
   717  
   718  
   719      xyra_Trans = 1.0d100
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t299 = 1, (kmax + 1)*(kmax + 1)*jmax*imax                      
     .           xyra_trans(t299-1,1,0,0) = 1.00000000000000e+100               
     .        enddo                                                             
   720  
   721  
   722      xyz_DelOpDep = 0.0_DP
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t311 = 1, xyz_delopdep.DSC.U3*(xyz_delopdep.DSC.U2*            
     .       1   xyz_delopdep.DSC.U1 + xyz_delopdep.DSC.U2)                     
     .           xyz_delopdep(t311-1,1,1) = 0.0000000000000000e+000             
     .        enddo                                                             
   723      do n = 1, nras
   724        do k = 1, kmax
   725          xyz_DelOpDep(:,:,k) = xyz_DelOpDep(:,:,k)                      &
   726            & + xyza_AC(:,:,k,n) * xyza_VMR(:,:,k,n) / xyz_MMMass(:,:,k) &
   727            & * ( xyr_Press(:,:,k-1) - xyr_Press(:,:,k) ) / Grav
   728        end do
     .        d1 = 1.D0/grav                                                    
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xyz_delopdep,xyz_mmmass,xyr_press)                         
     .        do k = 1, kmax*(xyz_delopdep.DSC.U2*xyz_delopdep.DSC.U1 +         
     .       1   xyz_delopdep.DSC.U2)                                           
     .           xyz_delopdep(k-1,1,1) = xyz_delopdep(k-1,1,1) + xyza_ac(k-1,1,1
     .       1      ,n)*xyza_vmr(k-1,1,1,n)/xyz_mmmass(k-1,1,1)*(xyr_press(k-1,1
     .       2      ,0)-xyr_press(k-1,1,1))*d1                                  
     .        enddo                                                             
   729      end do
   730  
   731      !
   732      ! add dust optical depth
   733      !
   734      do k = 1, kmax
   735        xyz_DelOpDep(:,:,k) = xyz_DelOpDep(:,:,k) &
   736          & + xyr_DOD(:,:,k-1) - xyr_DOD(:,:,k)
   737      end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xyz_delopdep)                                              
     .        do k = 1, kmax*(xyz_delopdep.DSC.U2*xyz_delopdep.DSC.U1 +         
     .       1   xyz_delopdep.DSC.U2)                                           
     .           xyz_delopdep(k-1,1,1) = xyz_delopdep(k-1,1,1) + xyr_dod(k-1,1,0
     .       1      ) - xyr_dod(k-1,1,1)                                        
     .        enddo                                                             
   738  
   739      xyz_DelTrans = exp( - xyz_DelOpDep * DifFac )
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xyz_delopdep)                                              
     .        do t350 = 1, xyz_delopdep.DSC.U3*(xyz_delopdep.DSC.U2*            
     .       1   xyz_delopdep.DSC.U1 + xyz_delopdep.DSC.U2)                     
     .           xyz_deltrans(t350-1,1,1) = dexp((-xyz_delopdep(t350-1,1,1)*    
     .       1      1.65999999999999e+000))                                     
     .        enddo                                                             
   740  
   741  
   742      !
   743      ! transmission for "zero thickness" layer ( = 1.0 )
   744      !
   745      do ks = 0, kmax
   746        ke = ks
   747        xyra_Trans(:,:,ks,ke) = 1.0_DP
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t362 = 1, jmax*imax                                            
     .           xyra_trans(t362-1,1,ks,ke) = 1.00000000000000e+000             
     .        enddo                                                             
   748      end do
   749  
   750      do ks = 0, kmax
   751        xy_Trans = 1.0_DP
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xy_trans)                                                  
     .        do t368 = 1, xy_trans.DSC.U2*xy_trans.DSC.U1 + xy_trans.DSC.U2    
     .           xy_trans(t368-1,1) = 1.00000000000000e+000                     
     .        enddo                                                             
   752        do ke = ks+1, kmax
   753          xy_Trans = xy_Trans * xyz_DelTrans(:,:,ke)
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xy_trans)                                                  
     .        do t374 = 1, xy_trans.DSC.U2*xy_trans.DSC.U1 + xy_trans.DSC.U2    
     .           xy_trans(t374-1,1) = xy_trans(t374-1,1)*xyz_deltrans(t374-1,1, 
     .       1      ke)                                                         
     .           xyra_trans(t374-1,1,ks,ke) = xy_trans(t374-1,1)                
     .        enddo                                                             
   754          xyra_Trans(:,:,ks,ke) = xy_Trans
   755        end do
   756      end do
   757  
   758      do ks = 0, kmax
   759        do ke = 0, ks-1
   760          xyra_Trans(:,:,ks,ke) = xyra_Trans(:,:,ke,ks)
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t388 = 1, jmax*imax                                            
     .           xyra_trans(t388-1,1,ks,ke) = xyra_trans(t388-1,1,ke,ks)        
     .        enddo                                                             
   761        end do
   762      end do
   763  
   764  
   765    end subroutine calc_trans_mp_arr3d
   766  
   767    !--------------------------------------------------------------------------------------
   768  
   769    subroutine calc_rteq_use_meantrans_arr3d( &
   770      & dlambda, xy_SurfEmis, &
   771      & trans_i2i_toa, trans_i2i_boa, trans_i2i_s, &
   772      & trans_i2m_lli, trans_i2m_uli, &
   773      & xyr_PF, xy_SurfPF, netflh &
   774      & )
   775  
   776      ! 物理・数学定数設定
   777      ! Physical and mathematical constants settings
   778      !
   779      use constants0, only: &
   780        & PI                    ! $ \pi $ .
   781                                ! 円周率.  Circular constant
   782  
   783      real(DP), intent(in ) :: dlambda
   784      real(DP), intent(in ) :: xy_SurfEmis(0:imax-1, 1:jmax)
   785      real(DP), intent(in ) :: trans_i2i_toa(0:imax-1, 1:jmax, 0:kmax)    ! f_{1/2}    T_{k+1/2,1/2}
   786      real(DP), intent(in ) :: trans_i2i_boa(0:imax-1, 1:jmax, 0:kmax)    ! f_{km+1/2} T_{k+1/2,km+1/2}
   787      real(DP), intent(in ) :: trans_i2i_s  (0:imax-1, 1:jmax, 0:kmax)    ! f_{s}      T_{k+1/2,km+1/2}
   788      real(DP), intent(in ) :: trans_i2m_lli(0:imax-1, 1:jmax, 0:kmax, 1:kmax) ! upper layer interface
   789      real(DP), intent(in ) :: trans_i2m_uli(0:imax-1, 1:jmax, 0:kmax, 1:kmax) ! lower layer interface
   790      real(DP), intent(in ) :: xyr_PF   (0:imax-1, 1:jmax, 0:kmax)
   791      real(DP), intent(in ) :: xy_SurfPF(0:imax-1, 1:jmax)
   792      real(DP), intent(out) :: netflh(0:imax-1, 1:jmax, 0:kmax)
   793  
   794  
   795  
   796      !
   797      ! local variables
   798      !
   799      integer :: i, j, k, k2
   800  
   801  
   802      do k = 0, kmax
   803        do j = 1, jmax
   804          do i = 0, imax-1
   805            netflh(i,j,k) = 0.0d0
   806          end do
   807        end do
   808      end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do k = 1, jmax*(kmax*imax + imax)                                 
     .           netflh(k-1,1,0) = 0.0000000000000000e+000                      
     .        enddo                                                             
   809  
   810      do k = 0, kmax
   811  
   812        do j = 1, jmax
   813          do i = 0, imax-1
   814            netflh(i,j,k) = netflh(i,j,k) &
   815              & + PI * xy_SurfEmis(i,j) * xy_SurfPF(i,j) * dlambda * trans_i2i_s  (i,j,k) &
   816              & - PI * xyr_PF(i,j,0   ) * dlambda * trans_i2i_boa(i,j,k) &
   817              & + PI * xyr_PF(i,j,kmax) * dlambda * trans_i2i_toa(i,j,k)
   818          end do
   819        end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xy_surfemis,xy_surfpf,xyr_pf)                              
     .        do j = 1, jmax*imax                                               
     .           netflh(j-1,1,k) = netflh(j-1,1,k) + (3.14159265358979e+000*    
     .       1      dlambda)*xy_surfpf(j-1,1)*xy_surfemis(j-1,1)*trans_i2i_s(j-1
     .       2      ,1,k) - (3.14159265358979e+000*dlambda)*xyr_pf(j-1,1,0)*    
     .       3      trans_i2i_boa(j-1,1,k) + (3.14159265358979e+000*dlambda)*   
     .       4      xyr_pf(j-1,1,kmax)*trans_i2i_toa(j-1,1,k)                   
     .        enddo                                                             
   820  
   821        do k2 = 1, kmax
   822          do j = 1, jmax
   823            do i = 0, imax-1
   824              netflh(i,j,k) = netflh(i,j,k) &
   825                & - PI * xyr_PF(i,j,k2  ) * dlambda * trans_i2m_uli(i,j,k,k2) &
   826                & + PI * xyr_PF(i,j,k2-1) * dlambda * trans_i2m_lli(i,j,k,k2)
   827            end do
   828          end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xyr_pf,netflh)                                             
     .        do j = 1, jmax*imax                                               
     .           netflh(j-1,1,k) = netflh(j-1,1,k) - (3.14159265358979e+000*    
     .       1      dlambda)*xyr_pf(j-1,1,k2)*trans_i2m_uli(j-1,1,k,k2) + (     
     .       2      3.14159265358979e+000*dlambda)*xyr_pf(j-1,1,k2-1)*          
     .       3      trans_i2m_lli(j-1,1,k,k2)                                   
     .        enddo                                                             
   829        end do
   830  
   831      end do
   832  
   833  
   834    end subroutine calc_rteq_use_meantrans_arr3d
   835  
   836    !**************************************************************************
   837  
   838    subroutine calc_lnp( xyz_Press, xyz_lnPress )
   839  
   840      real(DP), intent(in ) :: xyz_Press  (0:imax-1, 1:jmax, 1:kmax)
   841      real(DP), intent(out) :: xyz_lnPress(0:imax-1, 1:jmax, 1:kmax)
   842  
   843  
   844      !
   845      ! local variables
   846      !
   847  
   848  
   849      xyz_lnPress = log( xyz_Press + 1.0d-20 )
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t36 = 1, kmax*jmax*imax                                        
     .           xyz_lnpress(t36-1,1,1) = dlog(xyz_press(t36-1,1,1)+            
     .       1      9.99999999999999e-021)                                      
     .        enddo                                                             
   850  
   851  
   852    end subroutine calc_lnp
   853  
   854    !**************************************************************************
   855  
   856  !!$  subroutine rad15m_2006_rv_read_calctrans( &
   857  !!$    & gt, gph, gp, gts, &
   858  !!$    & gdod, &
   859  !!$    & ijs, ije )
   860  !!$
   861  !!$
   862  !!$    use mars_const, only : vmr_co2, amu
   863  !!$
   864  !!$
   865  !!$    use ckd_module
   866  !!$
   867  !!$
   868  !!$    real(DP), intent(in ) :: gph( im, jm, km+1 ), gp ( im, jm, km )
   869  !!$    real(DP), intent(in ) :: gt( im, jm, km ), gts( im, jm )
   870  !!$    real(DP), intent(in ) :: gdod( im, jm, km+1 )
   871  !!$    integer , intent(in ) :: ijs, ije
   872  !!$
   873  !!$
   874  !!$    !
   875  !!$    ! local variables
   876  !!$    !
   877  !!$    real(DP)                  :: gth( im, jm, km+1 )
   878  !!$    real(DP)                  :: &
   879  !!$      & mmmassh( im, jm, km+1 ), gvmrh( im, jm, km+1, nras+nrps )
   880  !!$    real(DP) :: ach  ( im, jm, km+1, nras )
   881  !!$    real(DP) :: pfh  ( im, jm, km+1 ), pfs  ( im, jm )
   882  !!$    real(DP) :: uwflh( im, jm, km+1 ), dwflh( im, jm, km+1 )
   883  !!$
   884  !!$    real(DP) :: uwflh_sum( im, jm, km+1 ), dwflh_sum( im, jm, km+1 )
   885  !!$
   886  !!$    real(DP) :: pfs_for_gradcalc( im, jm )
   887  !!$    real(DP) :: uwflh_sum_for_gradcalc( im, jm, km+1 ), dwflh_sum_for_gradcalc( im, jm, km+1 )
   888  !!$
   889  !!$    real(DP)                  :: weight_integral
   890  !!$    integer              :: ig, iband
   891  !!$
   892  !!$    integer              :: ij, k, l, m, n
   893  !!$    integer              :: k2
   894  !!$
   895  !!$    real(DP) :: minp, maxp
   896  !!$
   897  !!$    integer :: iband_reserve
   898  !!$    real(DP)     :: glnph  ( im, jm, km+1     )
   899  !!$    real(DP)     :: glnph_f( im, jm, km*nvr+1 )
   900  !!$    real(DP)     :: gts3d1 ( im, jm, 1        )
   901  !!$    integer :: &
   902  !!$      & jjh   ( im, jm, km+1     ), kkh   ( im, jm, km+1     ), &
   903  !!$      & jjh_f ( im, jm, km*nvr+1 ), kkh_f ( im, jm, km*nvr+1 ), &
   904  !!$      & jjs3d1( im, jm, 1        ), kks3d1( im, jm, 1        ), &
   905  !!$      & jjs   ( im, jm )          , kks   ( im, jm )
   906  !!$
   907  !!$
   908  !!$    ! Surface temperature for calculation of gradient of radiative flux
   909  !!$    real(DP) :: gts_for_gradcalc( im, jm )
   910  !!$    ! Indices for calculation of gradient of radiative flux
   911  !!$    integer  :: jjs_for_gradcalc( im, jm ), kks_for_gradcalc( im, jm )
   912  !!$
   913  !!$
   914  !!$    real(DP)     :: glnps3d1( im, jm, 1 )
   915  !!$
   916  !!$    real(DP)     :: pfrh_f( im, jm, km*nvr+1 )
   917  !!$    real(DP)     :: pfr3d1( im, jm, 1        )
   918  !!$
   919  !!$
   920  !!$    k = 1
   921  !!$    do ij = ijs, ije
   922  !!$      gth( ij, 1, k ) = gt( ij, 1, k )
   923  !!$    end do
   924  !!$    do k = 1+1, km+1-1
   925  !!$      do ij = ijs, ije
   926  !!$        gth( ij, 1, k ) &
   927  !!$          = ( gt( ij, 1, k ) - gt( ij, 1, k-1 ) ) &
   928  !!$          / log( gp( ij, 1, k ) / gp( ij, 1, k-1 ) ) &
   929  !!$          * log( gph( ij, 1, k ) / gp( ij, 1, k-1 ) ) &
   930  !!$          + gt( ij, 1, k-1 )
   931  !!$      end do
   932  !!$    end do
   933  !!$    k = km+1
   934  !!$    do ij = ijs, ije
   935  !!$      gth( ij, 1, k ) &
   936  !!$        = ( gt( ij, 1, km ) - gt( ij, 1, km-1 ) ) &
   937  !!$        / log( gp( ij, 1, km ) / gp( ij, 1, km-1 ) ) &
   938  !!$        * log( gph( ij, 1, km+1 ) / gp( ij, 1, km-1 ) ) &
   939  !!$        + gt( ij, 1, km-1 )
   940  !!$    end do
   941  !!$
   942  !!$
   943  !!$    do k = 1, km*nvr+1
   944  !!$      do ij = ijs, ije
   945  !!$        gph_f( ij, 1, k ) = sgmh_f( k ) * gph( ij, 1, km+1 )
   946  !!$      end do
   947  !!$    end do
   948  !!$    call calc_lnp( im, jm, km*nvr+1, gph_f , glnph_f , ijs, ije )
   949  !!$
   950  !!$    call increase_vreso_boundary_arr3d( im, jm, km, nvr, gth, gth_f, &
   951  !!$      & "linear", ijs, ije )
   952  !!$
   953  !!$
   954  !!$
   955  !!$    !
   956  !!$    ! Set interval for radiation/transmission calculation
   957  !!$    !
   958  !!$!      radint = hourm * mins
   959  !!$
   960  !!$
   961  !!$    !
   962  !!$    ! Calculation of transmission
   963  !!$    !
   964  !!$!      if( ( ( time - dble( int( time / rad15mint )  ) * rad15mint ) .lt. dt ) &
   965  !!$!        .or. ( rad_gtsbase( ijs, 1, 1 ) .gt. 1.0d99 ) ) then
   966  !!$!
   967  !!$!
   968  !!$!         write( 6, * ) '########## rad15m in if'
   969  !!$
   970  !!$
   971  !!$    !
   972  !!$    ! Calculation of "absorption" dust optical depth
   973  !!$    ! This formulation is obtained from Forget et al. [1999].
   974  !!$    !
   975  !!$!         do k = 1, km+1
   976  !!$!            do ij = ijs, ije
   977  !!$!               gdod( ij, 1, k ) = ( 1.0d0 - ssa ) * dod067( ij, 1, k ) * qerat
   978  !!$!            end do
   979  !!$!         end do
   980  !!$
   981  !!$    call increase_vreso_boundary_arr3d( im, jm, km, nvr, gdod, gdod_f, &
   982  !!$      & "log", ijs, ije )
   983  !!$
   984  !!$
   985  !!$    !
   986  !!$    ! check pressure
   987  !!$    !
   988  !!$    minp = 1.0d100
   989  !!$    maxp = 0.0d0
   990  !!$    do ij = ijs, ije
   991  !!$      minp = min( minp, gp( ij, 1, 2  ) )
   992  !!$      maxp = max( maxp, gp( ij, 1, km ) )
   993  !!$    end do
   994  !!$    if( ckdp(1)%lnp(1) .gt. log(minp) ) then
   995  !!$      write( 6, * ) 'MARS: pressure is too small.'
   996  !!$      write( 6, * ) minp, exp(ckdp(1)%lnp(1))
   997  !!$      stop
   998  !!$    end if
   999  !!$    if( ckdp(1)%lnp(ckdp(1)%nlnp) .lt. log(maxp) ) then
  1000  !!$      write( 6, * ) 'MARS: pressure is too large.'
  1001  !!$      write( 6, * ) maxp, exp(ckdp(1)%lnp(ckdp(1)%nlnp))
  1002  !!$      stop
  1003  !!$    end if
  1004  !!$
  1005  !!$
  1006  !!$    do k = 1, km+1
  1007  !!$      do ij = ijs, ije
  1008  !!$        mmmassh( ij, 1, k ) = 43.5d0 * amu
  1009  !!$      end do
  1010  !!$    end do
  1011  !!$    do n = 1, nras + nrps
  1012  !!$      do k = 1, km+1
  1013  !!$        do ij = ijs, ije
  1014  !!$          gvmrh( ij, 1, k, n ) = vmr_co2
  1015  !!$        end do
  1016  !!$      end do
  1017  !!$    end do
  1018  !!$
  1019  !!$
  1020  !!$!    do n = 1, nras + nrps
  1021  !!$!      call increase_vreso_b2m_arr3d( im, jm, km, nvr, &
  1022  !!$!        gvmrh(:,:,:,n), gvmr_f(:,:,:,n), "log", &
  1023  !!$!        ijs, ije )
  1024  !!$!    end do
  1025  !!$!    call increase_vreso_b2m_arr3d( im, jm, km, nvr, &
  1026  !!$!      mmmassh, mmmass_f, "linear", &
  1027  !!$!      ijs, ije )
  1028  !!$
  1029  !!$!    call calc_lnp( im, jm, km+1    , gph   , glnph   , ijs, ije )
  1030  !!$    call calc_lnph( gph, glnph )
  1031  !!$
  1032  !!$
  1033  !!$    !
  1034  !!$    ! initialization
  1035  !!$    !
  1036  !!$    do k = 0, kmax
  1037  !!$      do j = 1, jmax
  1038  !!$        do i = 0, imax-1
  1039  !!$          trans_i2i_toa(i,j,k) = 0.0d0         ! f_{1/2}    T_{k+1/2,1/2}
  1040  !!$          trans_i2i_boa(i,j,k) = 0.0d0         ! f_{km+1/2} T_{k+1/2,km+1/2}
  1041  !!$          trans_i2i_s  (i,j,k) = 0.0d0         ! f_{s}      T_{k+1/2,km+1/2}
  1042  !!$        end do
  1043  !!$      end do
  1044  !!$    end do
  1045  !!$    do k2 = 1, kmax
  1046  !!$      do k = 0, kmax
  1047  !!$        do j = 1, jmax
  1048  !!$          do i = 0, imax-1
  1049  !!$            trans_i2m_uli_f(i,j,k,k2) = 0.0d0
  1050  !!$            trans_i2m_lli_f(i,j,k,k2) = 0.0d0
  1051  !!$          end do
  1052  !!$        end do
  1053  !!$      end do
  1054  !!$    end do
  1055  !!$
  1056  !!$
  1057  !!$    !
  1058  !!$    ! loop for wavenumber
  1059  !!$    !
  1060  !!$
  1061  !!$    iband_reserve = 0
  1062  !!$
  1063  !!$    do m = 1, nwnl
  1064  !!$
  1065  !!$      call m2ckdpindices( m, ig, iband )
  1066  !!$
  1067  !!$
  1068  !!$      if( iband .ne. iband_reserve ) then
  1069  !!$        call findindices( im, jm, km+1, gth, glnph, iband, &
  1070  !!$          jjh, kkh, ijs, ije )
  1071  !!$
  1072  !!$
  1073  !!$        call findindices( im, jm, km*nvr+1, &
  1074  !!$          gth_f , glnph_f , &
  1075  !!$          iband, jjh_f , kkh_f , ijs, ije )
  1076  !!$        do ij = ijs, ije
  1077  !!$          gts3d1( ij, 1, 1 ) = gts( ij, 1 )
  1078  !!$        end do
  1079  !!$        call findindices( im, jm, 1       , &
  1080  !!$          gts3d1, glnph_f(:,:,km*nvr+1), &
  1081  !!$          iband, jjs3d1, kks3d1, ijs, ije )
  1082  !!$        do ij = ijs, ije
  1083  !!$          jjs( ij, 1 ) = jjs3d1( ij, 1, 1 )
  1084  !!$          kks( ij, 1 ) = kks3d1( ij, 1, 1 )
  1085  !!$        end do
  1086  !!$
  1087  !!$
  1088  !!$        iband_reserve = iband
  1089  !!$      end if
  1090  !!$
  1091  !!$
  1092  !!$      do n = 1, nras
  1093  !!$        call getlnac_givenindices( im, jm, km+1, gth, glnph, jjh, kkh, &
  1094  !!$          & ach(:,:,:,n), ig, iband, ijs, ije )
  1095  !!$      end do
  1096  !!$      do n = 1, nras
  1097  !!$        do k = 1, km+1
  1098  !!$          do ij = ijs, ije
  1099  !!$            ach( ij, 1, k, n ) = exp( ach( ij, 1, k, n ) )
  1100  !!$          end do
  1101  !!$        end do
  1102  !!$      end do
  1103  !!$
  1104  !!$      do n = 1, nras
  1105  !!$        call increase_vreso_b2m_arr3d( im, jm, km, nvr, &
  1106  !!$          ach(:,:,:,n), ac_f(:,:,:,n), "log", &
  1107  !!$          ijs, ije )
  1108  !!$      end do
  1109  !!$
  1110  !!$
  1111  !!$      call calc_trans_mp_arr3d( nras, nrps, im, jm, km*nvr, &
  1112  !!$        gph_f, gvmr_f, mmmass_f, &
  1113  !!$        ac_f, gdod_f, trans_f, ijs, ije )
  1114  !!$
  1115  !!$
  1116  !!$      do ij = ijs, ije
  1117  !!$        gts3d1  ( ij, 1, 1 ) = gts    ( ij, 1 )
  1118  !!$        glnps3d1( ij, 1, 1 ) = glnph_f( ij, 1, km*nvr+1 )
  1119  !!$        jjs3d1  ( ij, 1, 1 ) = jjs    ( ij, 1 )
  1120  !!$        kks3d1  ( ij, 1, 1 ) = kks    ( ij, 1 )
  1121  !!$      end do
  1122  !!$
  1123  !!$      call getpfr_givenindices( im, jm, km*nvr+1, gth_f , glnph_f , jjh_f , kkh_f , pfrh_f, ig, iband, ijs, ije )
  1124  !!$      call getpfr_givenindices( im, jm, 1       , gts3d1, glnps3d1, jjs3d1, kks3d1, pfr3d1, ig, iband, ijs, ije )
  1125  !!$
  1126  !!$
  1127  !!$      do k = 1, km*nvr+1
  1128  !!$        do ij = ijs, ije
  1129  !!$          trans_i2i_toa_f(ij,1,k) = &        ! f_{1/2}    T_{k+1/2,1/2}
  1130  !!$            & trans_i2i_toa_f(ij,1,k) &
  1131  !!$            & + trans_f(ij,1,k,1   ) &
  1132  !!$            & * pfrh_f(ij,1,1  ) &
  1133  !!$            & * ckdp(iband)%weight(ig)
  1134  !!$          trans_i2i_boa_f(ij,1,k) = &        ! f_{km+1/2} T_{k+1/2,km+1/2}
  1135  !!$            & trans_i2i_boa_f(ij,1,k) &
  1136  !!$            & + trans_f(ij,1,k,km+1) &
  1137  !!$            & * pfrh_f(ij,1,km+1) &
  1138  !!$            & * ckdp(iband)%weight(ig)
  1139  !!$          trans_i2i_s_f  (ij,1,k) = &        ! f_{s}      T_{k+1/2,km+1/2}
  1140  !!$            & trans_i2i_s_f  (ij,1,k) &
  1141  !!$            & + trans_f(ij,1,k,km+1) &
  1142  !!$            & * pfr3d1(ij,1,1) &
  1143  !!$            & * ckdp(iband)%weight(ig)
  1144  !!$        end do
  1145  !!$      end do
  1146  !!$
  1147  !!$      do k2 = 1, km*nvr
  1148  !!$        do k = 1, km*nvr+1
  1149  !!$          do ij = ijs, ije
  1150  !!$            trans_i2m_uli_f(ij,1,k,k2) = &
  1151  !!$              & trans_i2m_uli_f(ij,1,k,k2) &
  1152  !!$              & + ( trans_f(ij,1,k,k2) + trans_f(ij,1,k,k2+1) ) * 0.5d0 &
  1153  !!$              & * pfrh_f(ij,1,k2  ) &
  1154  !!$              & * ckdp(iband)%weight(ig)
  1155  !!$            trans_i2m_lli_f(ij,1,k,k2) = &
  1156  !!$              & trans_i2m_lli_f(ij,1,k,k2) &
  1157  !!$              & + ( trans_f(ij,1,k,k2) + trans_f(ij,1,k,k2+1) ) * 0.5d0 &
  1158  !!$              & * pfrh_f(ij,1,k2+1) &
  1159  !!$              & * ckdp(iband)%weight(ig)
  1160  !!$          end do
  1161  !!$        end do
  1162  !!$      end do
  1163  !!$
  1164  !!$
  1165  !!$
  1166  !!$    end do
  1167  !!$
  1168  !!$
  1169  !!$
  1170  !!$
  1171  !!$
  1172  !!$!      end if
  1173  !!$
  1174  !!$
  1175  !!$  end subroutine rad15m_2006_rv_read_calctrans
  1176  
  1177    !**************************************************************************
  1178  
  1179  !!$  subroutine rad15m_readnlte15mfac( fn )
  1180  !!$
  1181  !!$
  1182  !!$    interface
  1183  !!$      subroutine findfu( fn, ios, fu, mode )
  1184  !!$        use matype
  1185  !!$        implicit none
  1186  !!$        character(len=*), intent(in )           :: fn
  1187  !!$        integer    , intent(out)           :: ios, fu
  1188  !!$        character(len=*), intent(in ), optional :: mode
  1189  !!$      end subroutine findfu
  1190  !!$    end interface
  1191  !!$
  1192  !!$
  1193  !!$    character(len=*), intent(in) :: fn
  1194  !!$
  1195  !!$
  1196  !!$    !
  1197  !!$    ! local variables
  1198  !!$    !
  1199  !!$    character(len=128) :: tmpl
  1200  !!$    integer       :: ios, fu
  1201  !!$    integer       :: i
  1202  !!$
  1203  !!$
  1204  !!$    call findfu( fn, ios, fu )
  1205  !!$    if( ios /= 0 ) then
  1206  !!$      write( 6, * ) 'STOP in parse_ctl: ', ios
  1207  !!$      stop
  1208  !!$    endif
  1209  !!$    open( fu, file = fn, status='unknown' )
  1210  !!$    read( fu, '(a)' ) tmpl
  1211  !!$    do i = 1, nl15fn
  1212  !!$      read( fu, * ) nl15sn( i ), nl15fa( i )
  1213  !!$    enddo
  1214  !!$    close( fu )
  1215  !!$
  1216  !!$
  1217  !!$  end subroutine rad15m_readnlte15mfac
  1218  
  1219    !**************************************************************************
  1220  
  1221    !--------------------------------------------------------------------------------------
  1222  
  1223    subroutine m2ckdpindices( m, ig, iband )
  1224  
  1225      use ckd_module, only : ckdp, nband
  1226  
  1227      integer, intent(in ) :: m
  1228      integer, intent(out) :: ig
  1229      integer, intent(out) :: iband
  1230  
  1231  
  1232      !
  1233      ! local variables
  1234      !
  1235      integer :: num
  1236  
  1237  
  1238      ! The comments below will be removed.
  1239  
  1240  
  1241      num = 0
  1242      do iband = 1, nband
  1243        if( num + ckdp( iband ) % ng .ge. m ) exit
  1244        num = num + ckdp( iband ) % ng
  1245      end do
  1246      if( iband > nband ) then
  1247        write( 6, * ) 'Unexpected m'
  1248        write( 6, * ) m
  1249        stop
  1250      end if
  1251      ig = m - num
  1252      if( ig > ckdp( iband ) % ng ) then
  1253        write( 6, * ) 'Unexpected ig'
  1254        write( 6, * ) iband, ig
  1255        stop
  1256      end if
  1257  
  1258  
  1259    end subroutine m2ckdpindices
  1260  
  1261    !--------------------------------------------------------------------------------------
  1262  
  1263    subroutine getlnac_givenindices( &
  1264      & xyz_Temp, xyz_lnPress, xyz_jj, xyz_kk, ig, iband, &
  1265      & xyz_AC &
  1266      & )
  1267  
  1268      use ckd_module, only : ckdp
  1269  
  1270      real(DP), intent(in ) :: xyz_Temp   (0:imax-1, 1:jmax, 1:kmax)
  1271      real(DP), intent(in ) :: xyz_lnPress(0:imax-1, 1:jmax, 1:kmax)
  1272      integer , intent(in ) :: xyz_jj  (0:imax-1, 1:jmax, 1:kmax)
  1273      integer , intent(in ) :: xyz_kk  (0:imax-1, 1:jmax, 1:kmax)
  1274      integer , intent(in ) :: ig
  1275      integer , intent(in ) :: iband
  1276      real(DP), intent(out) :: xyz_AC  (0:imax-1, 1:jmax, 1:kmax)
  1277  
  1278  
  1279      !
  1280      ! local variables
  1281      !
  1282      real(DP) :: lnac1, lnac2
  1283      integer  :: i, j, k
  1284  
  1285  
  1286      do k = 1, kmax
  1287        do j = 1, jmax
  1288          do i = 0, imax-1
  1289  
  1290            lnac1 &
  1291              & = ( ckdp(iband)%lnac( ig, xyz_jj(i,j,k)  , xyz_kk(i,j,k)+1 )      &
  1292              &   - ckdp(iband)%lnac( ig, xyz_jj(i,j,k)  , xyz_kk(i,j,k)   ) )    &
  1293              &  / ( ckdp(iband)%t( xyz_kk(i,j,k)+1 )                          &
  1294              &    - ckdp(iband)%t( xyz_kk(i,j,k)   ) )                        &
  1295              & * ( xyz_Temp(i,j,k) - ckdp( iband ) % t( xyz_kk(i,j,k) ) )          &
  1296              & + ckdp(iband)%lnac( ig, xyz_jj(i,j,k)  , xyz_kk(i,j,k)   )
  1297            lnac2 &
  1298              & = ( ckdp(iband)%lnac( ig, xyz_jj(i,j,k)+1, xyz_kk(i,j,k)+1 )      &
  1299              &   - ckdp(iband)%lnac( ig, xyz_jj(i,j,k)+1, xyz_kk(i,j,k)   ) )    &
  1300              &  / ( ckdp(iband)%t( xyz_kk(i,j,k)+1 )                          &
  1301              &    - ckdp(iband)%t( xyz_kk(i,j,k)   ) )                        &
  1302              & * ( xyz_Temp(i,j,k) - ckdp( iband ) % t( xyz_kk(i,j,k) ) )          &
  1303              & + ckdp(iband)%lnac( ig, xyz_jj(i,j,k)+1, xyz_kk(i,j,k)   )
  1304  
  1305            xyz_AC(i,j,k) &
  1306              & = ( lnac2 - lnac1 ) &
  1307              & / ( ckdp( iband ) % lnp( xyz_jj(i,j,k)+1 ) &
  1308              & - ckdp( iband ) % lnp( xyz_jj(i,j,k)   ) ) &
  1309              & * ( xyz_lnPress(i,j,k) - ckdp( iband ) % lnp( xyz_jj(i,j,k) ) ) &
  1310              & + lnac1
  1311          end do
  1312        end do
  1313      end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do k = 1, kmax*jmax*imax                                          
     .           lnac1 = (ckdp.lnac(ig,xyz_jj(k-1,1,1),xyz_kk(k-1,1,1)+1,iband)-
     .       1      ckdp.lnac(ig,xyz_jj(k-1,1,1),xyz_kk(k-1,1,1),iband))/(ckdp.t
     .       2      (xyz_kk(k-1,1,1)+1,iband)-ckdp.t(xyz_kk(k-1,1,1),iband))*(  
     .       3      xyz_temp(k-1,1,1)-ckdp.t(xyz_kk(k-1,1,1),iband)) + ckdp.lnac
     .       4      (ig,xyz_jj(k-1,1,1),xyz_kk(k-1,1,1),iband)                  
     .           lnac2 = (ckdp.lnac(ig,xyz_jj(k-1,1,1)+1,xyz_kk(k-1,1,1)+1,iband
     .       1      )-ckdp.lnac(ig,xyz_jj(k-1,1,1)+1,xyz_kk(k-1,1,1),iband))/(  
     .       2      ckdp.t(xyz_kk(k-1,1,1)+1,iband)-ckdp.t(xyz_kk(k-1,1,1),iband
     .       3      ))*(xyz_temp(k-1,1,1)-ckdp.t(xyz_kk(k-1,1,1),iband)) +      
     .       4      ckdp.lnac(ig,xyz_jj(k-1,1,1)+1,xyz_kk(k-1,1,1),iband)       
     .           xyz_ac(k-1,1,1) = (lnac2 - lnac1)/(ckdp.lnp(xyz_jj(k-1,1,1)+1, 
     .       1      iband)-ckdp.lnp(xyz_jj(k-1,1,1),iband))*(xyz_lnpress(k-1,1,1
     .       2      )-ckdp.lnp(xyz_jj(k-1,1,1),iband)) + lnac1                  
     .        enddo                                                             
  1314  
  1315  
  1316    end subroutine getlnac_givenindices
  1317  
  1318    !--------------------------------------------------------------------------------------
  1319  !!$
  1320  !!$  subroutine calc_lnph( gph, glnph )
  1321  !!$
  1322  !!$    real(DP), intent(in ) :: gph  (0:imax-1, 1:jmax, 1:kmax)
  1323  !!$    real(DP), intent(out) :: glnph(0:imax-1, 1:jmax, 0:kmax)
  1324  !!$
  1325  !!$
  1326  !!$    !
  1327  !!$    ! local variables
  1328  !!$    !
  1329  !!$    integer :: i, j, k
  1330  !!$
  1331  !!$
  1332  !!$    do k = 0, kmax
  1333  !!$      do j = 1, jmax
  1334  !!$        do i = 0, imax-1
  1335  !!$          glnph(i,j,k) = log( gph(i,j,k) + 1.0d-20 )
  1336  !!$        end do
  1337  !!$      end do
  1338  !!$    end do
  1339  !!$
  1340  !!$
  1341  !!$  end subroutine calc_lnph
  1342  !!$
  1343    !--------------------------------------------------------------------------------------
  1344  
  1345    subroutine findindices( &
  1346      & ks, ke, xyz_Temp, xyz_lnPress, iband, &
  1347      & xyz_jj, xyz_kk &
  1348      & )
  1349  
  1350      use ckd_module, only : ckdp
  1351  
  1352      integer , intent(in ) :: ks
  1353      integer , intent(in ) :: ke
  1354      real(DP), intent(in ) :: xyz_Temp   (0:imax-1, 1:jmax, ks:ke)
  1355      real(DP), intent(in ) :: xyz_lnPress(0:imax-1, 1:jmax, ks:ke)
  1356      integer , intent(in ) :: iband
  1357      integer , intent(out) :: xyz_jj(0:imax-1, 1:jmax, ks:ke)
  1358      integer , intent(out) :: xyz_kk(0:imax-1, 1:jmax, ks:ke)
  1359  
  1360  
  1361      !
  1362      ! local variables
  1363      !
  1364      integer :: i, j, k, l
  1365  
  1366  
  1367      do k = ks, ke
  1368        do j = 1, jmax
  1369          do i = 0, imax-1
  1370            xyz_kk(i,j,k) = 1
  1371          end do
  1372        end do
  1373      end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do k = 1, jmax*(imax - (ks - ke)*imax)                            
     .           xyz_kk(k-1,1,ks) = 1                                           
     .        enddo                                                             
  1374  
  1375      do l = 1+1, ckdp( iband ) % nt - 1
  1376        do k = ks, ke
  1377          do j = 1, jmax
  1378            do i = 0, imax-1
  1379              if( ckdp( iband ) % t( l ) .le. xyz_Temp(i,j,k) ) xyz_kk(i,j,k) = l
  1380            end do
  1381          end do
  1382        end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xyz_temp,xyz_kk)                                           
     .        do k = 1, jmax*(imax - (ks - ke)*imax)                            
     .           if (ckdp.t(l,iband) .le. xyz_temp(k-1,1,ks)) then              
     .              xyz_kk(k-1,1,ks) = l                                        
     .           endif                                                          
     .        enddo                                                             
  1383      end do
  1384  
  1385      do k = ks, ke
  1386        do j = 1, jmax
  1387          do i = 0, imax-1
  1388            xyz_jj(i,j,k) = 1
  1389          end do
  1390        end do
  1391      end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do k = 1, jmax*(imax - (ks - ke)*imax)                            
     .           xyz_jj(k-1,1,ks) = 1                                           
     .        enddo                                                             
  1392      do l = 1+1, ckdp( iband ) % nlnp - 1
  1393        do k = ks, ke
  1394          do j = 1, jmax
  1395            do i = 0, imax-1
  1396              if( ckdp( iband ) % lnp( l ) <= xyz_lnPress(i,j,k) ) xyz_jj(i,j,k) = l
  1397            end do
  1398          end do
  1399        end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xyz_lnpress,xyz_jj)                                        
     .        do k = 1, jmax*(imax - (ks - ke)*imax)                            
     .           if (ckdp.lnp(l,iband) .le. xyz_lnpress(k-1,1,ks)) then         
     .              xyz_jj(k-1,1,ks) = l                                        
     .           endif                                                          
     .        enddo                                                             
  1400      end do
  1401  
  1402  
  1403    end subroutine findindices
  1404  
  1405    !--------------------------------------------------------------------------------------
  1406  
  1407    subroutine findindices3D( &
  1408      & xyz_Temp, xyz_lnPress, iband, &
  1409      & xyz_jj, xyz_kk &
  1410      & )
  1411  
  1412      real(DP), intent(in ) :: xyz_Temp   (0:imax-1, 1:jmax, 1:kmax)
  1413      real(DP), intent(in ) :: xyz_lnPress(0:imax-1, 1:jmax, 1:kmax)
  1414      integer , intent(in ) :: iband
  1415      integer , intent(out) :: xyz_jj(0:imax-1, 1:jmax, 1:kmax)
  1416      integer , intent(out) :: xyz_kk(0:imax-1, 1:jmax, 1:kmax)
  1417  
  1418  
  1419      !
  1420      ! local variables
  1421      !
  1422  
  1423  
  1424      call findindices(             &
  1425        & 1, kmax, xyz_Temp, xyz_lnPress, iband, &
  1426        & xyz_jj, xyz_kk                    &
  1427        & )
  1428  
  1429  
  1430    end subroutine findindices3D
  1431  
  1432    !--------------------------------------------------------------------------------------
  1433  
  1434    subroutine findindices2D( &
  1435      & xy_Temp, xy_lnPress, iband, &
  1436      & xy_jj, xy_kk &
  1437      & )
  1438  
  1439      real(DP), intent(in ) :: xy_Temp   (0:imax-1, 1:jmax)
  1440      real(DP), intent(in ) :: xy_lnPress(0:imax-1, 1:jmax)
  1441      integer , intent(in ) :: iband
  1442      integer , intent(out) :: xy_jj(0:imax-1, 1:jmax)
  1443      integer , intent(out) :: xy_kk(0:imax-1, 1:jmax)
  1444  
  1445  
  1446      !
  1447      ! local variables
  1448      !
  1449      real(DP) :: xyz_Temp   (0:imax-1, 1:jmax, 1:1)
  1450      real(DP) :: xyz_lnPress(0:imax-1, 1:jmax, 1:1)
  1451      integer  :: xyz_jj(0:imax-1, 1:jmax, 1:1)
  1452      integer  :: xyz_kk(0:imax-1, 1:jmax, 1:1)
  1453  
  1454  
  1455      xyz_Temp   (:,:,1) = xy_Temp
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t101 = 1, xyz_temp.DSC.U2*xyz_temp.DSC.U1 + xyz_temp.DSC.U2    
     .           xyz_temp(t101-1,1,1) = xy_temp(t101-1,1)                       
     .           xyz_lnpress(t101-1,1,1) = xy_lnpress(t101-1,1)                 
     .        enddo                                                             
  1456      xyz_lnPress(:,:,1) = xy_lnPress
  1457  
  1458      call findindices(              &
  1459        & 1, 1, xyz_Temp, xyz_lnPress, iband, &
  1460        & xyz_jj, xyz_kk                 &
  1461        & )
  1462  
  1463      xy_jj = xyz_jj(:,:,1)
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t113 = 1, jmax*imax                                            
     .           xy_jj(t113-1,1) = xyz_jj(t113-1,1,1)                           
     .           xy_kk(t113-1,1) = xyz_kk(t113-1,1,1)                           
     .        enddo                                                             
  1464      xy_kk = xyz_kk(:,:,1)
  1465  
  1466  
  1467    end subroutine findindices2D
  1468  
  1469    !--------------------------------------------------------------------------------------
  1470  
  1471    subroutine getpf_arr3d_norat( &
  1472      & xyz_Temp, xy_SurfTemp, iband, &
  1473      & xyr_PF, xy_SurfPF &
  1474      & )
  1475  
  1476      use planck_func, only : Integ_PF_GQ_Array3D, Integ_PF_GQ_Array2D
  1477  
  1478      use ckd_module, only : ckdp
  1479  
  1480      real(DP), intent(in ) :: xyz_Temp   (0:imax-1, 1:jmax, 0:kmax)
  1481      real(DP), intent(in ) :: xy_SurfTemp(0:imax-1, 1:jmax)
  1482      integer , intent(in ) :: iband
  1483      real(DP), intent(out) :: xyr_PF   (0:imax-1, 1:jmax, 0:kmax)
  1484      real(DP), intent(out) :: xy_SurfPF(0:imax-1, 1:jmax)
  1485  
  1486  
  1487      !
  1488      ! local variables
  1489      !
  1490      integer :: ncp_pfint
  1491      integer :: i, j, k
  1492  
  1493  
  1494      ncp_pfint = 5
  1495  
  1496      call Integ_PF_GQ_Array3D( &
  1497        & ckdp(iband)%wnbnds(1), ckdp(iband)%wnbnds(2), ncp_pfint, &
  1498        & 0, imax-1, 1, jmax, 0, kmax, &
  1499        & xyz_Temp, &
  1500        & xyr_PF &
  1501        & )
  1502      call Integ_PF_GQ_Array2D( &
  1503        & ckdp(iband)%wnbnds(1), ckdp(iband)%wnbnds(2), ncp_pfint, &
  1504        & 0, imax-1, 1, jmax, &
  1505        & xy_SurfTemp, &
  1506        & xy_SurfPF &
  1507        & )
  1508  
  1509      do k = 0, kmax
  1510        do j = 1, jmax
  1511          do i = 0, imax-1
  1512            xyr_PF(i,j,k) = xyr_PF(i,j,k) / ( ckdp(iband)%wnbnds(2) - ckdp(iband)%wnbnds(1) )
  1513          end do
  1514        end do
  1515      end do
     .        d1 = 1.D0/(ckdp%wnbnds(2,iband)-ckdp%wnbnds(1,iband))             
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do k = 1, jmax*(kmax*imax + imax)                                 
     .           xyr_pf(k-1,1,0) = xyr_pf(k-1,1,0)*d1                           
     .        enddo                                                             
  1516      do j = 1, jmax
  1517        do i = 0, imax-1
  1518          xy_SurfPF(i,j) = xy_SurfPF(i,j) / ( ckdp(iband)%wnbnds(2) - ckdp(iband)%wnbnds(1) )
  1519        end do
  1520      end do
     .        d2 = 1.D0/(ckdp%wnbnds(2,iband)-ckdp%wnbnds(1,iband))             
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do j = 1, jmax*imax                                               
     .           xy_surfpf(j-1,1) = xy_surfpf(j-1,1)*d2                         
     .        enddo                                                             
  1521  
  1522  
  1523    end subroutine getpf_arr3d_norat
  1524  
  1525    !--------------------------------------------------------------------------------------
  1526  
  1527    subroutine getpfr_givenindices( &
  1528      & ks, ke, &
  1529      & xyz_Temp, xyz_lnPress, xyz_jj, xyz_kk, ig, iband, &
  1530      & xyz_PFRat &
  1531      & )
  1532  
  1533      use ckd_module, only: ckdp
  1534  
  1535      integer , intent(in ) :: ks
  1536      integer , intent(in ) :: ke
  1537      real(DP), intent(in ) :: xyz_Temp   (0:imax-1, 1:jmax, ks:ke)
  1538      real(DP), intent(in ) :: xyz_lnPress(0:imax-1, 1:jmax, ks:ke)
  1539      integer , intent(in ) :: xyz_jj  (0:imax-1, 1:jmax, ks:ke)
  1540      integer , intent(in ) :: xyz_kk  (0:imax-1, 1:jmax, ks:ke)
  1541      integer , intent(in ) :: ig, iband
  1542      real(DP), intent(out) :: xyz_PFRat(0:imax-1, 1:jmax, ks:ke)
  1543  
  1544  
  1545      !
  1546      ! local variables
  1547      !
  1548      real(DP) :: pfr1, pfr2
  1549      integer  :: i, j, k, l
  1550  
  1551  
  1552      do k = ks, ke
  1553        do j = 1, jmax
  1554          do i = 0, imax-1
  1555  
  1556            pfr1 = &
  1557              &   ( ckdp(iband)%pfr( ig, xyz_jj(i,j,k)  , xyz_kk(i,j,k)+1 )     &
  1558              &   - ckdp(iband)%pfr( ig, xyz_jj(i,j,k)  , xyz_kk(i,j,k)   ) )   &
  1559              & / ( ckdp(iband)%t( xyz_kk(i,j,k)+1 )                         &
  1560              &   - ckdp(iband)%t( xyz_kk(i,j,k)   ) )                       &
  1561              & * ( xyz_Temp(i,j,k) - ckdp( iband ) % t( xyz_kk(i,j,k) ) )         &
  1562              & + ckdp(iband)%pfr( ig, xyz_jj(i,j,k)  , xyz_kk(i,j,k)   )
  1563            pfr2 = &
  1564              &   ( ckdp(iband)%pfr( ig, xyz_jj(i,j,k)+1, xyz_kk(i,j,k)+1 )      &
  1565              &   - ckdp(iband)%pfr( ig, xyz_jj(i,j,k)+1, xyz_kk(i,j,k)   ) )    &
  1566              & / ( ckdp(iband)%t( xyz_kk(i,j,k)+1 )                         &
  1567              &   - ckdp(iband)%t( xyz_kk(i,j,k)   ) )                       &
  1568              & * ( xyz_Temp(i,j,k) - ckdp( iband ) % t( xyz_kk(i,j,k) ) )         &
  1569              & + ckdp(iband)%pfr( ig, xyz_jj(i,j,k)+1, xyz_kk(i,j,k)   )
  1570  
  1571  
  1572            xyz_PFRat(i,j,k) = &
  1573              &   ( pfr2 - pfr1 ) &
  1574              & / ( ckdp( iband ) % lnp( xyz_jj(i,j,k)+1 ) &
  1575              &   - ckdp( iband ) % lnp( xyz_jj(i,j,k)   ) ) &
  1576              & * ( xyz_lnPress(i,j,k) - ckdp( iband ) % lnp( xyz_jj(i,j,k) ) ) &
  1577              & + pfr1
  1578          end do
  1579        end do
  1580      end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do k = 1, jmax*(imax - (ks - ke)*imax)                            
     .           pfr1 = (ckdp.pfr(ig,xyz_jj(k-1,1,ks),xyz_kk(k-1,1,ks)+1,iband)-
     .       1      ckdp.pfr(ig,xyz_jj(k-1,1,ks),xyz_kk(k-1,1,ks),iband))/(     
     .       2      ckdp.t(xyz_kk(k-1,1,ks)+1,iband)-ckdp.t(xyz_kk(k-1,1,ks),   
     .       3      iband))*(xyz_temp(k-1,1,ks)-ckdp.t(xyz_kk(k-1,1,ks),iband)) 
     .       4       + ckdp.pfr(ig,xyz_jj(k-1,1,ks),xyz_kk(k-1,1,ks),iband)     
     .           pfr2 = (ckdp.pfr(ig,xyz_jj(k-1,1,ks)+1,xyz_kk(k-1,1,ks)+1,iband
     .       1      )-ckdp.pfr(ig,xyz_jj(k-1,1,ks)+1,xyz_kk(k-1,1,ks),iband))/( 
     .       2      ckdp.t(xyz_kk(k-1,1,ks)+1,iband)-ckdp.t(xyz_kk(k-1,1,ks),   
     .       3      iband))*(xyz_temp(k-1,1,ks)-ckdp.t(xyz_kk(k-1,1,ks),iband)) 
     .       4       + ckdp.pfr(ig,xyz_jj(k-1,1,ks)+1,xyz_kk(k-1,1,ks),iband)   
     .           xyz_pfrat(k-1,1,ks) = (pfr2 - pfr1)/(ckdp.lnp(xyz_jj(k-1,1,ks)+
     .       1      1,iband)-ckdp.lnp(xyz_jj(k-1,1,ks),iband))*(xyz_lnpress(k-1,
     .       2      1,ks)-ckdp.lnp(xyz_jj(k-1,1,ks),iband)) + pfr1              
     .        enddo                                                             
  1581  
  1582  
  1583    end subroutine getpfr_givenindices
  1584  
  1585    !--------------------------------------------------------------------------------------
  1586  
  1587    subroutine getpfr_givenindices3D( &
  1588      & xyz_Temp, xyz_lnPress, xyz_jj, xyz_kk, ig, iband, &
  1589      & xyz_PFRat &
  1590      & )
  1591  
  1592      use ckd_module, only: ckdp
  1593  
  1594      real(DP), intent(in ) :: xyz_Temp   (0:imax-1, 1:jmax, 1:kmax)
  1595      real(DP), intent(in ) :: xyz_lnPress(0:imax-1, 1:jmax, 1:kmax)
  1596      integer , intent(in ) :: xyz_jj  (0:imax-1, 1:jmax, 1:kmax)
  1597      integer , intent(in ) :: xyz_kk  (0:imax-1, 1:jmax, 1:kmax)
  1598      integer , intent(in ) :: ig, iband
  1599      real(DP), intent(out) :: xyz_PFRat(0:imax-1, 1:jmax, 1:kmax)
  1600  
  1601  
  1602      !
  1603      ! local variables
  1604      !
  1605  
  1606      call getpfr_givenindices( &
  1607        & 1, kmax, &
  1608        & xyz_Temp, xyz_lnPress, xyz_jj, xyz_kk, ig, iband, &
  1609        & xyz_PFRat &
  1610        & )
  1611  
  1612  
  1613    end subroutine getpfr_givenindices3D
  1614  
  1615    !--------------------------------------------------------------------------------------
  1616  
  1617    subroutine getpfr_givenindices2D( &
  1618      & xy_Temp, xy_lnPress, xy_jj, xy_kk, ig, iband, &
  1619      & xy_PFRat &
  1620      & )
  1621  
  1622      real(DP), intent(in ) :: xy_Temp   (0:imax-1, 1:jmax)
  1623      real(DP), intent(in ) :: xy_lnPress(0:imax-1, 1:jmax)
  1624      integer , intent(in ) :: xy_jj  (0:imax-1, 1:jmax)
  1625      integer , intent(in ) :: xy_kk  (0:imax-1, 1:jmax)
  1626      integer , intent(in ) :: ig, iband
  1627      real(DP), intent(out) :: xy_PFRat (0:imax-1, 1:jmax)
  1628  
  1629  
  1630      !
  1631      ! local variables
  1632      !
  1633      real(DP) :: xyz_Temp   (0:imax-1, 1:jmax, 1:1)
  1634      real(DP) :: xyz_lnPress(0:imax-1, 1:jmax, 1:1)
  1635      integer  :: xyz_jj  (0:imax-1, 1:jmax, 1:1)
  1636      integer  :: xyz_kk  (0:imax-1, 1:jmax, 1:1)
  1637      real(DP) :: xyz_PFRat(0:imax-1, 1:jmax, 1:1)
  1638  
  1639  
  1640      xyz_Temp   (:,:,1) = xy_Temp
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t122 = 1, xyz_temp.DSC.U2*xyz_temp.DSC.U1 + xyz_temp.DSC.U2    
     .           xyz_temp(t122-1,1,1) = xy_temp(t122-1,1)                       
     .           xyz_lnpress(t122-1,1,1) = xy_lnpress(t122-1,1)                 
     .           xyz_jj(t122-1,1,1) = xy_jj(t122-1,1)                           
     .           xyz_kk(t122-1,1,1) = xy_kk(t122-1,1)                           
     .        enddo                                                             
  1641      xyz_lnPress(:,:,1) = xy_lnPress
  1642      xyz_jj  (:,:,1) = xy_jj
  1643      xyz_kk  (:,:,1) = xy_kk
  1644  
  1645      call getpfr_givenindices( &
  1646        & 1, 1, &
  1647        & xyz_Temp, xyz_lnPress, xyz_jj, xyz_kk, ig, iband, &
  1648        & xyz_PFRat &
  1649        & )
  1650  
  1651      xy_PFRat(:,:) = xyz_PFRat(:,:,1)
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t142 = 1, jmax*imax                                            
     .           xy_pfrat(t142-1,1) = xyz_pfrat(t142-1,1,1)                     
     .        enddo                                                             
  1652  
  1653  
  1654    end subroutine getpfr_givenindices2D
  1655  
  1656    !--------------------------------------------------------------------------------------
  1657  
  1658  !!$  function m2ib( m ) result( iband )
  1659  !!$
  1660  !!$    use matype
  1661  !!$    use ckd_module
  1662  !!$
  1663  !!$    integer(i4b), intent(in ) :: m
  1664  !!$    integer(i4b)              :: iband
  1665  !!$
  1666  !!$
  1667  !!$    !
  1668  !!$    ! local variables
  1669  !!$    !
  1670  !!$    integer(i4b) :: ig
  1671  !!$    integer(i4b) :: num
  1672  !!$
  1673  !!$
  1674  !!$    num = 0
  1675  !!$    do iband = 1, nband
  1676  !!$      if( num + ckdp( iband ) % ng .ge. m ) exit
  1677  !!$      num = num + ckdp( iband ) % ng
  1678  !!$    end do
  1679  !!$    if( iband .gt. nband ) then
  1680  !!$      write( 6, * ) 'Unexpected m'
  1681  !!$      write( 6, * ) m
  1682  !!$      stop
  1683  !!$    end if
  1684  !!$    ig = m - num
  1685  !!$    if( ig .gt. ckdp( iband ) % ng ) then
  1686  !!$      write( 6, * ) 'Unexpected ig'
  1687  !!$      write( 6, * ) iband, ig
  1688  !!$      stop
  1689  !!$    end if
  1690  !!$
  1691  !!$
  1692  !!$  end function m2ib
  1693  
  1694    !--------------------------------------------------------------------------------------
  1695  
  1696  !!$  function m2ig( m ) result( ig )
  1697  !!$
  1698  !!$    use matype
  1699  !!$    use ckd_module
  1700  !!$
  1701  !!$    integer(i4b), intent(in ) :: m
  1702  !!$    integer(i4b)              :: ig
  1703  !!$
  1704  !!$
  1705  !!$    !
  1706  !!$    ! local variables
  1707  !!$    !
  1708  !!$    integer(i4b) :: iband
  1709  !!$    integer(i4b) :: num
  1710  !!$
  1711  !!$
  1712  !!$    num = 0
  1713  !!$    do iband = 1, nband
  1714  !!$      if( num + ckdp( iband ) % ng .ge. m ) exit
  1715  !!$      num = num + ckdp( iband ) % ng
  1716  !!$    end do
  1717  !!$    if( iband .gt. nband ) then
  1718  !!$      write( 6, * ) 'Unexpected m'
  1719  !!$      write( 6, * ) m
  1720  !!$      stop
  1721  !!$    end if
  1722  !!$    ig = m - num
  1723  !!$    if( ig .gt. ckdp( iband ) % ng ) then
  1724  !!$      write( 6, * ) 'Unexpected ig'
  1725  !!$      write( 6, * ) iband, ig
  1726  !!$      stop
  1727  !!$    end if
  1728  !!$
  1729  !!$
  1730  !!$  end function m2ig
  1731  
  1732    !--------------------------------------------------------------------------------------
  1733  
  1734  !!$  subroutine getlnac_lblinterface( nwnsl, km, nras, gt, gp, ac, m )
  1735  !!$
  1736  !!$    use matype
  1737  !!$    use ckd_module
  1738  !!$
  1739  !!$    integer(i4b), intent(in ) :: nwnsl, km, nras
  1740  !!$    real(dp)    , intent(in ) :: gt( km ), gp( km )
  1741  !!$    real(dp)    , intent(out) :: ac( nwnsl, km, nras )
  1742  !!$    integer(i4b), intent(in ) :: m
  1743  !!$
  1744  !!$
  1745  !!$    !
  1746  !!$    ! local variables
  1747  !!$    !
  1748  !!$    real(dp)     :: ac_1d( km )
  1749  !!$    integer(i4b) :: ig, iband
  1750  !!$    integer(i4b) :: k
  1751  !!$
  1752  !!$
  1753  !!$    if( nwnsl .ne. 1 ) then
  1754  !!$      write( 6, * ) 'Unexpected nwnsl.'
  1755  !!$      write( 6, * ) nwnsl
  1756  !!$      stop
  1757  !!$    end if
  1758  !!$    if( nras .ne. 1 ) then
  1759  !!$      write( 6, * ) 'Unexpected nras.'
  1760  !!$      write( 6, * ) nras
  1761  !!$      stop
  1762  !!$    end if
  1763  !!$
  1764  !!$    call m2ckdpindices( m, ig, iband )
  1765  !!$
  1766  !!$    call getlnac_1d( km, gt, gp, ac_1d, ig, iband )
  1767  !!$
  1768  !!$    do k = 1, km
  1769  !!$      ac( :, k, 1 ) = ac_1d( k )
  1770  !!$    end do
  1771  !!$
  1772  !!$
  1773  !!$  end subroutine getlnac_lblinterface
  1774  
  1775    !--------------------------------------------------------------------------------------
  1776  
  1777  !!$  subroutine getlnac_1d( km, gt, gp, ac, ig, iband )
  1778  !!$
  1779  !!$    use matype
  1780  !!$
  1781  !!$    integer(i4b), intent(in ) :: km
  1782  !!$    real(dp)    , intent(in ) :: gt( km ), gp( km )
  1783  !!$    real(dp)    , intent(out) :: ac( km )
  1784  !!$    integer(i4b), intent(in ) :: ig, iband
  1785  !!$
  1786  !!$
  1787  !!$    !
  1788  !!$    ! local variables
  1789  !!$    !
  1790  !!$    real(dp)     :: gt3d( 1, 1, km ), gp3d( 1, 1, km )
  1791  !!$    real(dp)     :: ac3d( 1, 1, km )
  1792  !!$    integer(i4b) :: k
  1793  !!$
  1794  !!$
  1795  !!$    do k = 1, km
  1796  !!$      gt3d( 1, 1, k ) = gt( k )
  1797  !!$      gp3d( 1, 1, k ) = gp( k )
  1798  !!$    end do
  1799  !!$
  1800  !!$    call getlnac( 1, 1, km, gt3d, gp3d, ac3d, ig, iband, 1, 1 )
  1801  !!$
  1802  !!$    do k = 1, km
  1803  !!$      ac( k ) = ac3d( 1, 1, k )
  1804  !!$    end do
  1805  !!$
  1806  !!$
  1807  !!$  end subroutine getlnac_1d
  1808  
  1809    !--------------------------------------------------------------------------------------
  1810  !!$
  1811  !!$  subroutine getlnac( im, jm, km, gt, gp, ac, ig, iband, ijs, ije )
  1812  !!$
  1813  !!$    use matype
  1814  !!$    use ckd_module
  1815  !!$
  1816  !!$    integer(i4b), intent(in ) :: im, jm, km
  1817  !!$    real(dp)    , intent(in ) :: gt( im, jm, km ), gp( im, jm, km )
  1818  !!$    real(dp)    , intent(out) :: ac( im, jm, km )
  1819  !!$    integer(i4b), intent(in ) :: ig, iband
  1820  !!$    integer(i4b), intent(in ) :: ijs, ije
  1821  !!$
  1822  !!$
  1823  !!$    !
  1824  !!$    ! local variables
  1825  !!$    !
  1826  !!$    real(dp)     :: glnp( im, jm, km )
  1827  !!$    real(dp)     :: lnac1, lnac2
  1828  !!$    integer(i4b) :: ij, k, l
  1829  !!$    integer(i4b) :: jj( im, jm, km ), kk( im, jm, km )
  1830  !!$
  1831  !!$
  1832  !!$    do k = 1, km
  1833  !!$      do ij = ijs, ije
  1834  !!$
  1835  !!$        glnp( ij, 1, k ) = log( gp( ij, 1, k ) + 1.0d-20 )
  1836  !!$
  1837  !!$      end do
  1838  !!$    end do
  1839  !!$
  1840  !!$    do k = 1, km
  1841  !!$      do ij = ijs, ije
  1842  !!$        kk( ij, 1, k ) = 1
  1843  !!$      end do
  1844  !!$    end do
  1845  !!$    do l = 1+1, ckdp( iband ) % nt - 1
  1846  !!$      do k = 1, km
  1847  !!$        do ij = ijs, ije
  1848  !!$          if( ckdp( iband ) % t( l ) .le. gt( ij, 1, k ) ) &
  1849  !!$            kk( ij, 1, k ) = l
  1850  !!$        end do
  1851  !!$      end do
  1852  !!$    end do
  1853  !!$
  1854  !!$    do k = 1, km
  1855  !!$      do ij = ijs, ije
  1856  !!$        jj( ij, 1, k ) = 1
  1857  !!$      end do
  1858  !!$    end do
  1859  !!$    do l = 1+1, ckdp( iband ) % nlnp - 1
  1860  !!$      do k = 1, km
  1861  !!$        do ij = ijs, ije
  1862  !!$          if( ckdp( iband ) % lnp( l ) .le. glnp( ij, 1, k ) ) &
  1863  !!$            jj( ij, 1, k ) = l
  1864  !!$        end do
  1865  !!$      end do
  1866  !!$    end do
  1867  !!$
  1868  !!$
  1869  !!$    do k = 1, km
  1870  !!$      do ij = ijs, ije
  1871  !!$
  1872  !!$        lnac1 &
  1873  !!$          = ( ckdp(iband)%lnac( ig, jj(ij,1,k)  , kk(ij,1,k)+1 )      &
  1874  !!$          - ckdp(iband)%lnac( ig, jj(ij,1,k)  , kk(ij,1,k)   ) )    &
  1875  !!$          / ( ckdp(iband)%t( kk(ij,1,k)+1 )                          &
  1876  !!$          - ckdp(iband)%t( kk(ij,1,k)   ) )                        &
  1877  !!$          * ( gt(ij,1,k) - ckdp( iband ) % t( kk(ij,1,k) ) )          &
  1878  !!$          + ckdp(iband)%lnac( ig, jj(ij,1,k)  , kk(ij,1,k)   )
  1879  !!$        lnac2 &
  1880  !!$          = ( ckdp(iband)%lnac( ig, jj(ij,1,k)+1, kk(ij,1,k)+1 )      &
  1881  !!$          - ckdp(iband)%lnac( ig, jj(ij,1,k)+1, kk(ij,1,k)   ) )    &
  1882  !!$          / ( ckdp(iband)%t( kk(ij,1,k)+1 )                          &
  1883  !!$          - ckdp(iband)%t( kk(ij,1,k)   ) )                        &
  1884  !!$          * ( gt(ij,1,k) - ckdp( iband ) % t( kk(ij,1,k) ) )          &
  1885  !!$          + ckdp(iband)%lnac( ig, jj(ij,1,k)+1, kk(ij,1,k)   )
  1886  !!$
  1887  !!$        ac( ij, 1, k ) &
  1888  !!$          = ( lnac2 - lnac1 ) &
  1889  !!$          / ( ckdp( iband ) % lnp( jj(ij,1,k)+1 ) &
  1890  !!$          - ckdp( iband ) % lnp( jj(ij,1,k)   ) ) &
  1891  !!$          * ( glnp(ij,1,k) - ckdp( iband ) % lnp( jj(ij,1,k) ) ) &
  1892  !!$          + lnac1
  1893  !!$      end do
  1894  !!$    end do
  1895  !!$
  1896  !!$
  1897  !!$  end subroutine getlnac
  1898  
  1899    !--------------------------------------------------------------------------------------
  1900  
  1901  !!$  subroutine getpf_arr3d( im, jm, km, gt, gts, gp, gps, &
  1902  !!$    pfarr, pfsarr, ig, iband, ijs, ije )
  1903  !!$
  1904  !!$    use matype
  1905  !!$    use ckd_module
  1906  !!$    use pf_module
  1907  !!$
  1908  !!$    integer(i4b), intent(in ) :: im, jm, km
  1909  !!$    real(dp)    , intent(in ) :: gt( im, jm, km ), gts( im, jm ), gp( im, jm, km ), gps( im, jm )
  1910  !!$    real(dp)    , intent(out) :: pfarr( im, jm, km ), pfsarr( im, jm )
  1911  !!$    integer(i4b), intent(in ) :: ig, iband
  1912  !!$    integer(i4b), intent(in ) :: ijs, ije
  1913  !!$
  1914  !!$
  1915  !!$    !
  1916  !!$    ! local variables
  1917  !!$    !
  1918  !!$    real(dp)     :: pfr   ( im, jm, km )
  1919  !!$    real(dp)     :: gts3d1( im, jm, 1  ), gps3d1( im, jm, 1 ), pfr3d1( im, jm, 1 )
  1920  !!$    integer(i4b) :: ncp_pfint
  1921  !!$    integer(i4b) :: ij, k
  1922  !!$
  1923  !!$
  1924  !!$    ncp_pfint = 5
  1925  !!$
  1926  !!$    call getpfr( im, jm, km, gt    , gp    , pfr   , ig, iband, ijs, ije )
  1927  !!$    do ij = ijs, ije
  1928  !!$      gts3d1( ij, 1, 1 ) = gts( ij, 1 )
  1929  !!$      gps3d1( ij, 1, 1 ) = gps( ij, 1 )
  1930  !!$    end do
  1931  !!$    call getpfr( im, jm, 1 , gts3d1, gps3d1, pfr3d1, ig, iband, ijs, ije )
  1932  !!$
  1933  !!$
  1934  !!$    call pfint_gq_array( ckdp(iband)%wnbnds(1), ckdp(iband)%wnbnds(2), &
  1935  !!$      ncp_pfint, im, jm, km, gt, pfarr, &
  1936  !!$      ijs, ije )
  1937  !!$    call pfint_gq_array2d( ckdp(iband)%wnbnds(1), ckdp(iband)%wnbnds(2), &
  1938  !!$      ncp_pfint, im, jm, gts, pfsarr, &
  1939  !!$      ijs, ije )
  1940  !!$
  1941  !!$    do k = 1, km
  1942  !!$      do ij = ijs, ije
  1943  !!$        pfarr( ij, 1, k ) = pfarr( ij, 1, k ) &
  1944  !!$          / ( ckdp(iband)%wnbnds(2) - ckdp(iband)%wnbnds(1) )       &
  1945  !!$          * pfr( ij, 1, k )
  1946  !!$      end do
  1947  !!$    end do
  1948  !!$    do ij = ijs, ije
  1949  !!$      pfsarr( ij, 1 ) = pfsarr( ij, 1 ) &
  1950  !!$        / ( ckdp(iband)%wnbnds(2) - ckdp(iband)%wnbnds(1) )       &
  1951  !!$        * pfr3d1( ij, 1, 1 )
  1952  !!$    end do
  1953  !!$
  1954  !!$
  1955  !!$  end subroutine getpf_arr3d
  1956  
  1957    !--------------------------------------------------------------------------------------
  1958  
  1959  !!$  subroutine getpf_arr3d_givenindices( im, jm, km, gt, gts, glnp, glnps, &
  1960  !!$    jj, kk, jjs, kks, &
  1961  !!$    pfarr, pfsarr, ig, iband, ijs, ije )
  1962  !!$
  1963  !!$    use matype
  1964  !!$    use ckd_module
  1965  !!$    use pf_module
  1966  !!$
  1967  !!$    integer(i4b), intent(in ) :: im, jm, km
  1968  !!$    real(dp)    , intent(in ) :: gt( im, jm, km ), gts( im, jm ), glnp( im, jm, km ), glnps( im, jm )
  1969  !!$    integer(i4b), intent(in ) :: jj ( im, jm, km ), kk ( im, jm, km )
  1970  !!$    integer(i4b), intent(in ) :: jjs( im, jm )    , kks( im, jm )
  1971  !!$    real(dp)    , intent(out) :: pfarr( im, jm, km ), pfsarr( im, jm )
  1972  !!$    integer(i4b), intent(in ) :: ig, iband
  1973  !!$    integer(i4b), intent(in ) :: ijs, ije
  1974  !!$
  1975  !!$
  1976  !!$    !
  1977  !!$    ! local variables
  1978  !!$    !
  1979  !!$    real(dp)     :: pfr   ( im, jm, km )
  1980  !!$    real(dp)     :: gts3d1( im, jm, 1  ), glnps3d1( im, jm, 1 ), pfr3d1( im, jm, 1 )
  1981  !!$    integer(i4b) :: jjs3d1( im, jm, 1  ), kks3d1  ( im, jm, 1 )
  1982  !!$    integer(i4b) :: ncp_pfint
  1983  !!$    integer(i4b) :: ij, k
  1984  !!$
  1985  !!$
  1986  !!$    ncp_pfint = 5
  1987  !!$
  1988  !!$
  1989  !!$    do ij = ijs, ije
  1990  !!$      gts3d1  ( ij, 1, 1 ) = gts  ( ij, 1 )
  1991  !!$      glnps3d1( ij, 1, 1 ) = glnps( ij, 1 )
  1992  !!$      jjs3d1  ( ij, 1, 1 ) = jjs  ( ij, 1 )
  1993  !!$      kks3d1  ( ij, 1, 1 ) = kks  ( ij, 1 )
  1994  !!$    end do
  1995  !!$
  1996  !!$
  1997  !!$    call getpfr_givenindices( im, jm, km, gt    , glnp    , jj    , kk    , pfr   , ig, iband, ijs, ije )
  1998  !!$    call getpfr_givenindices( im, jm, 1 , gts3d1, glnps3d1, jjs3d1, kks3d1, pfr3d1, ig, iband, ijs, ije )
  1999  !!$
  2000  !!$
  2001  !!$    call pfint_gq_array( ckdp(iband)%wnbnds(1), ckdp(iband)%wnbnds(2), &
  2002  !!$      ncp_pfint, im, jm, km, gt, pfarr, &
  2003  !!$      ijs, ije )
  2004  !!$    call pfint_gq_array2d( ckdp(iband)%wnbnds(1), ckdp(iband)%wnbnds(2), &
  2005  !!$      ncp_pfint, im, jm, gts, pfsarr, &
  2006  !!$      ijs, ije )
  2007  !!$
  2008  !!$    do k = 1, km
  2009  !!$      do ij = ijs, ije
  2010  !!$        pfarr( ij, 1, k ) = pfarr( ij, 1, k ) &
  2011  !!$          / ( ckdp(iband)%wnbnds(2) - ckdp(iband)%wnbnds(1) )       &
  2012  !!$          * pfr( ij, 1, k )
  2013  !!$      end do
  2014  !!$    end do
  2015  !!$    do ij = ijs, ije
  2016  !!$      pfsarr( ij, 1 ) = pfsarr( ij, 1 ) &
  2017  !!$        / ( ckdp(iband)%wnbnds(2) - ckdp(iband)%wnbnds(1) )       &
  2018  !!$        * pfr3d1( ij, 1, 1 )
  2019  !!$    end do
  2020  !!$
  2021  !!$
  2022  !!$  end subroutine getpf_arr3d_givenindices
  2023  
  2024    !--------------------------------------------------------------------------------------
  2025  
  2026  !!$  subroutine getpf_arr3d_givenindices_norat( im, jm, km, gt, gts, glnp, glnps, &
  2027  !!$    pfarr, pfsarr, iband, ijs, ije )
  2028  !!$
  2029  !!$    use matype
  2030  !!$    use ckd_module
  2031  !!$    use pf_module
  2032  !!$
  2033  !!$    integer(i4b), intent(in ) :: im, jm, km
  2034  !!$    real(dp)    , intent(in ) :: gt( im, jm, km ), gts( im, jm ), glnp( im, jm, km ), glnps( im, jm )
  2035  !!$    real(dp)    , intent(out) :: pfarr( im, jm, km ), pfsarr( im, jm )
  2036  !!$    integer(i4b), intent(in ) :: iband
  2037  !!$    integer(i4b), intent(in ) :: ijs, ije
  2038  !!$
  2039  !!$
  2040  !!$    !
  2041  !!$    ! local variables
  2042  !!$    !
  2043  !!$    integer(i4b) :: ncp_pfint
  2044  !!$    integer(i4b) :: ij, k
  2045  !!$
  2046  !!$
  2047  !!$    ncp_pfint = 5
  2048  !!$
  2049  !!$
  2050  !!$    call pfint_gq_array( ckdp(iband)%wnbnds(1), ckdp(iband)%wnbnds(2), &
  2051  !!$      ncp_pfint, im, jm, km, gt, pfarr, &
  2052  !!$      ijs, ije )
  2053  !!$    call pfint_gq_array2d( ckdp(iband)%wnbnds(1), ckdp(iband)%wnbnds(2), &
  2054  !!$      ncp_pfint, im, jm, gts, pfsarr, &
  2055  !!$      ijs, ije )
  2056  !!$
  2057  !!$    do k = 1, km
  2058  !!$      do ij = ijs, ije
  2059  !!$        pfarr( ij, 1, k ) = pfarr( ij, 1, k ) &
  2060  !!$          / ( ckdp(iband)%wnbnds(2) - ckdp(iband)%wnbnds(1) )
  2061  !!$      end do
  2062  !!$    end do
  2063  !!$    do ij = ijs, ije
  2064  !!$      pfsarr( ij, 1 ) = pfsarr( ij, 1 ) &
  2065  !!$        / ( ckdp(iband)%wnbnds(2) - ckdp(iband)%wnbnds(1) )
  2066  !!$    end do
  2067  !!$
  2068  !!$
  2069  !!$  end subroutine getpf_arr3d_givenindices_norat
  2070  
  2071    !--------------------------------------------------------------------------------------
  2072  
  2073  !!$  subroutine getpf_arr2d_givenindices( im, jm, gts, glnps, &
  2074  !!$    & jjs, kks, &
  2075  !!$    & pfsarr, ig, iband, ijs, ije )
  2076  !!$
  2077  !!$    use matype
  2078  !!$    use ckd_module
  2079  !!$    use pf_module
  2080  !!$
  2081  !!$    integer(i4b), intent(in ) :: im, jm
  2082  !!$    real(dp)    , intent(in ) :: gts( im, jm ), glnps( im, jm )
  2083  !!$    integer(i4b), intent(in ) :: jjs( im, jm )    , kks( im, jm )
  2084  !!$    real(dp)    , intent(out) :: pfsarr( im, jm )
  2085  !!$    integer(i4b), intent(in ) :: ig, iband
  2086  !!$    integer(i4b), intent(in ) :: ijs, ije
  2087  !!$
  2088  !!$
  2089  !!$    !
  2090  !!$    ! local variables
  2091  !!$    !
  2092  !!$    real(dp)     :: gts3d1( im, jm, 1  ), glnps3d1( im, jm, 1 ), pfr3d1( im, jm, 1 )
  2093  !!$    integer(i4b) :: jjs3d1( im, jm, 1  ), kks3d1  ( im, jm, 1 )
  2094  !!$    integer(i4b) :: ncp_pfint
  2095  !!$    integer(i4b) :: ij, k
  2096  !!$
  2097  !!$
  2098  !!$    ncp_pfint = 5
  2099  !!$
  2100  !!$
  2101  !!$    do ij = ijs, ije
  2102  !!$      gts3d1  ( ij, 1, 1 ) = gts  ( ij, 1 )
  2103  !!$      glnps3d1( ij, 1, 1 ) = glnps( ij, 1 )
  2104  !!$      jjs3d1  ( ij, 1, 1 ) = jjs  ( ij, 1 )
  2105  !!$      kks3d1  ( ij, 1, 1 ) = kks  ( ij, 1 )
  2106  !!$    end do
  2107  !!$
  2108  !!$
  2109  !!$    call getpfr_givenindices( im, jm, 1 , gts3d1, glnps3d1, jjs3d1, kks3d1, pfr3d1, ig, iband, ijs, ije )
  2110  !!$
  2111  !!$
  2112  !!$    call pfint_gq_array2d( ckdp(iband)%wnbnds(1), ckdp(iband)%wnbnds(2), &
  2113  !!$      ncp_pfint, im, jm, gts, pfsarr, &
  2114  !!$      ijs, ije )
  2115  !!$
  2116  !!$    do ij = ijs, ije
  2117  !!$      pfsarr( ij, 1 ) = pfsarr( ij, 1 ) &
  2118  !!$        / ( ckdp(iband)%wnbnds(2) - ckdp(iband)%wnbnds(1) )       &
  2119  !!$        * pfr3d1( ij, 1, 1 )
  2120  !!$    end do
  2121  !!$
  2122  !!$
  2123  !!$  end subroutine getpf_arr2d_givenindices
  2124  
  2125    !--------------------------------------------------------------------------------------
  2126  
  2127  !!$  subroutine getpf_lblinterface( nwnsl, km, gt, gts, gp, gps, &
  2128  !!$    pfarr, pfsarr, iwnsls, iwnsle, m )
  2129  !!$
  2130  !!$    use matype
  2131  !!$    use ckd_module
  2132  !!$    use pf_module
  2133  !!$
  2134  !!$
  2135  !!$    integer(i4b), intent(in ) :: nwnsl, km
  2136  !!$    real(dp)    , intent(in ) :: gt( km ), gts, gp( km ), gps
  2137  !!$    real(dp)    , intent(out) :: pfarr( nwnsl, km ), pfsarr( nwnsl )
  2138  !!$    integer(i4b), intent(in ) :: iwnsls, iwnsle, m
  2139  !!$
  2140  !!$
  2141  !!$    !
  2142  !!$    ! local variables
  2143  !!$    !
  2144  !!$    real(dp)     :: pfr( km )
  2145  !!$    real(dp)     :: gt1( 1 ), gp1( 1 ), pfr1( 1 )
  2146  !!$    integer(i4b) :: ncp_pfint
  2147  !!$    integer(i4b) :: ig, iband
  2148  !!$    integer(i4b) :: k, iwnsl
  2149  !!$
  2150  !!$
  2151  !!$    call m2ckdpindices( m, ig, iband )
  2152  !!$
  2153  !!$    call getpfr_1d( km, gt , gp , pfr , ig, iband )
  2154  !!$    gt1( 1 ) = gts
  2155  !!$    gp1( 1 ) = gps
  2156  !!$    call getpfr_1d( 1 , gt1, gp1, pfr1, ig, iband )
  2157  !!$
  2158  !!$    ncp_pfint = 5
  2159  !!$
  2160  !!$    do k = 1, km
  2161  !!$      do iwnsl = iwnsls, iwnsle
  2162  !!$        pfarr( iwnsl, k ) &
  2163  !!$          = pfint_gq( ckdp(iband)%wnbnds(1), ckdp(iband)%wnbnds(2), &
  2164  !!$          ncp_pfint, gt( k ) )                          &
  2165  !!$          / ( ckdp(iband)%wnbnds(2) - ckdp(iband)%wnbnds(1) )       &
  2166  !!$          * pfr( k )
  2167  !!$      end do
  2168  !!$    end do
  2169  !!$    do iwnsl = iwnsls, iwnsle
  2170  !!$      pfsarr( iwnsl ) &
  2171  !!$        = pfint_gq( ckdp(iband)%wnbnds(1), ckdp(iband)%wnbnds(2), &
  2172  !!$        ncp_pfint, gts )                          &
  2173  !!$        / ( ckdp(iband)%wnbnds(2) - ckdp(iband)%wnbnds(1) )       &
  2174  !!$        * pfr1( 1 )
  2175  !!$    end do
  2176  !!$
  2177  !!$
  2178  !!$  end subroutine getpf_lblinterface
  2179  
  2180    !--------------------------------------------------------------------------------------
  2181  
  2182  !!$  subroutine getpfr_1d( km, gt, gp, pfr, ig, iband )
  2183  !!$
  2184  !!$    use matype
  2185  !!$
  2186  !!$    integer(i4b), intent(in ) :: km
  2187  !!$    real(dp)    , intent(in ) :: gt( km ), gp( km )
  2188  !!$    real(dp)    , intent(out) :: pfr( km )
  2189  !!$    integer(i4b), intent(in ) :: ig, iband
  2190  !!$
  2191  !!$
  2192  !!$    !
  2193  !!$    ! local variables
  2194  !!$    !
  2195  !!$    real(dp)     :: gt3d ( 1, 1, km ), gp3d( 1, 1, km )
  2196  !!$    real(dp)     :: pfr3d( 1, 1, km )
  2197  !!$    integer(i4b) :: k
  2198  !!$
  2199  !!$
  2200  !!$    do k = 1, km
  2201  !!$      gt3d( 1, 1, k ) = gt( k )
  2202  !!$      gp3d( 1, 1, k ) = gp( k )
  2203  !!$    end do
  2204  !!$
  2205  !!$    call getpfr( 1, 1, km, gt3d, gp3d, pfr3d, ig, iband, 1, 1 )
  2206  !!$
  2207  !!$    do k = 1, km
  2208  !!$      pfr( k ) = pfr3d( 1, 1, k )
  2209  !!$    end do
  2210  !!$
  2211  !!$
  2212  !!$  end subroutine getpfr_1d
  2213  
  2214    !--------------------------------------------------------------------------------------
  2215  
  2216  !!$  subroutine getpfr( im, jm, km, gt, gp, pfr, ig, iband, ijs, ije )
  2217  !!$
  2218  !!$    use matype
  2219  !!$    use ckd_module
  2220  !!$
  2221  !!$    integer(i4b), intent(in ) :: im, jm, km
  2222  !!$    real(dp)    , intent(in ) :: gt( im, jm, km ), gp( im, jm, km )
  2223  !!$    real(dp)    , intent(out) :: pfr( im, jm, km )
  2224  !!$    integer(i4b), intent(in ) :: ig, iband
  2225  !!$    integer(i4b), intent(in ) :: ijs, ije
  2226  !!$
  2227  !!$
  2228  !!$    !
  2229  !!$    ! local variables
  2230  !!$    !
  2231  !!$    real(dp)     :: glnp( im, jm, km )
  2232  !!$    real(dp)     :: pfr1, pfr2
  2233  !!$    integer(i4b) :: ij, k, l
  2234  !!$    integer(i4b) :: jj( im, jm, km ), kk( im, jm, km )
  2235  !!$
  2236  !!$
  2237  !!$    do k = 1, km
  2238  !!$      do ij = ijs, ije
  2239  !!$
  2240  !!$        glnp( ij, 1, k ) = log( gp( ij, 1, k ) + 1.0d-20 )
  2241  !!$
  2242  !!$      end do
  2243  !!$    end do
  2244  !!$
  2245  !!$
  2246  !!$    do k = 1, km
  2247  !!$      do ij = ijs, ije
  2248  !!$        kk( ij, 1, k ) = 1
  2249  !!$      end do
  2250  !!$    end do
  2251  !!$    do l = 1+1, ckdp( iband ) % nt - 1
  2252  !!$      do k = 1, km
  2253  !!$        do ij = ijs, ije
  2254  !!$          if( ckdp( iband ) % t( l ) .le. gt( ij, 1, k ) ) &
  2255  !!$            kk( ij, 1, k ) = l
  2256  !!$        end do
  2257  !!$      end do
  2258  !!$    end do
  2259  !!$
  2260  !!$    do k = 1, km
  2261  !!$      do ij = ijs, ije
  2262  !!$        jj( ij, 1, k ) = 1
  2263  !!$      end do
  2264  !!$    end do
  2265  !!$    do l = 1+1, ckdp( iband ) % nlnp - 1
  2266  !!$      do k = 1, km
  2267  !!$        do ij = ijs, ije
  2268  !!$          if( ckdp( iband ) % lnp( l ) .le. glnp( ij, 1, k ) ) &
  2269  !!$            jj( ij, 1, k ) = l
  2270  !!$        end do
  2271  !!$      end do
  2272  !!$    end do
  2273  !!$
  2274  !!$
  2275  !!$    do k = 1, km
  2276  !!$      do ij = ijs, ije
  2277  !!$
  2278  !!$        pfr1 &
  2279  !!$          = ( ckdp(iband)%pfr( ig, jj(ij,1,k)  , kk(ij,1,k)+1 )      &
  2280  !!$          - ckdp(iband)%pfr( ig, jj(ij,1,k)  , kk(ij,1,k)   ) )    &
  2281  !!$          / ( ckdp(iband)%t( kk(ij,1,k)+1 )                          &
  2282  !!$          - ckdp(iband)%t( kk(ij,1,k)   ) )                        &
  2283  !!$          * ( gt(ij,1,k) - ckdp( iband ) % t( kk(ij,1,k) ) )          &
  2284  !!$          + ckdp(iband)%pfr( ig, jj(ij,1,k)  , kk(ij,1,k)   )
  2285  !!$        pfr2 &
  2286  !!$          = ( ckdp(iband)%pfr( ig, jj(ij,1,k)+1, kk(ij,1,k)+1 )      &
  2287  !!$          - ckdp(iband)%pfr( ig, jj(ij,1,k)+1, kk(ij,1,k)   ) )    &
  2288  !!$          / ( ckdp(iband)%t( kk(ij,1,k)+1 )                          &
  2289  !!$          - ckdp(iband)%t( kk(ij,1,k)   ) )                        &
  2290  !!$          * ( gt(ij,1,k) - ckdp( iband ) % t( kk(ij,1,k) ) )          &
  2291  !!$          + ckdp(iband)%pfr( ig, jj(ij,1,k)+1, kk(ij,1,k)   )
  2292  !!$
  2293  !!$
  2294  !!$        pfr( ij, 1, k ) &
  2295  !!$          = ( pfr2 - pfr1 ) &
  2296  !!$          / ( ckdp( iband ) % lnp( jj(ij,1,k)+1 ) &
  2297  !!$          - ckdp( iband ) % lnp( jj(ij,1,k)   ) ) &
  2298  !!$          * ( glnp(ij,1,k) - ckdp( iband ) % lnp( jj(ij,1,k) ) ) &
  2299  !!$          + pfr1
  2300  !!$      end do
  2301  !!$    end do
  2302  !!$
  2303  !!$
  2304  !!$  end subroutine getpfr
  2305  
  2306    !--------------------------------------------------------------------------------------
  2307  
  2308  !!$  subroutine getweight_lblinterface( nwnsl, weight, m )
  2309  !!$
  2310  !!$    use matype
  2311  !!$    use ckd_module
  2312  !!$    use pf_module
  2313  !!$
  2314  !!$    integer(i4b), intent(in ) :: nwnsl
  2315  !!$    real(dp)    , intent(out) :: weight
  2316  !!$    integer(i4b), intent(in ) :: m
  2317  !!$
  2318  !!$
  2319  !!$    !
  2320  !!$    ! local variables
  2321  !!$    !
  2322  !!$    integer(i4b) :: ig, iband
  2323  !!$
  2324  !!$
  2325  !!$    if( nwnsl .ne. 1 ) then
  2326  !!$      write( 6, * ) 'Now, nwnsl must be 1.'
  2327  !!$      write( 6, * ) nwnsl
  2328  !!$      stop
  2329  !!$    end if
  2330  !!$
  2331  !!$
  2332  !!$    call m2ckdpindices( m, ig, iband )
  2333  !!$
  2334  !!$    weight = ( ckdp(iband)%wnbnds(2) - ckdp(iband)%wnbnds(1) ) &
  2335  !!$      * ckdp(iband)%weight(ig)
  2336  !!$
  2337  !!$
  2338  !!$  end subroutine getweight_lblinterface
  2339  
  2340    !--------------------------------------------------------------------------------------
  2341  
  2342  !!$  subroutine getweight_gcm( ig, iband, weight )
  2343  !!$
  2344  !!$    use matype
  2345  !!$    use ckd_module
  2346  !!$
  2347  !!$    integer(i4b), intent(in ) :: ig, iband
  2348  !!$    real(dp)    , intent(out) :: weight
  2349  !!$
  2350  !!$
  2351  !!$    !
  2352  !!$    ! local variables
  2353  !!$    !
  2354  !!$
  2355  !!$
  2356  !!$    weight = ( ckdp(iband)%wnbnds(2) - ckdp(iband)%wnbnds(1) ) &
  2357  !!$      * ckdp(iband)%weight(ig)
  2358  !!$
  2359  !!$
  2360  !!$  end subroutine getweight_gcm
  2361  
  2362  
  2363    !**************************************************************************
  2364  
  2365    subroutine RadMars15mInit
  2366  
  2367      ! モジュール引用 ; USE statements
  2368      !
  2369  
  2370      ! NAMELIST ファイル入力に関するユーティリティ
  2371      ! Utilities for NAMELIST file input
  2372      !
  2373      use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid
  2374  
  2375      ! ファイル入出力補助
  2376      ! File I/O support
  2377      !
  2378      use dc_iounit, only: FileOpen
  2379  
  2380      use ckd_module, only : ckd_input, ckdp, nband
  2381  
  2382  
  2383      !
  2384      ! local variables
  2385      !
  2386      integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号.
  2387                                ! Unit number for NAMELIST file open
  2388      integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT.
  2389                                ! IOSTAT of NAMELIST read
  2390  
  2391      character(STRING) :: rad15mkg_fn
  2392      character(STRING) :: rad15mnf_fn
  2393  
  2394      integer           :: m
  2395  
  2396      namelist /rad_Mars_15m_nml/ &
  2397        & rad15mkg_fn, &
  2398  !!$      & rad15mnf_fn, &
  2399        & Rad15mInt
  2400  
  2401  
  2402      ! 実行文 ; Executable statement
  2403      !
  2404  
  2405      if ( rad_Mars_15m_inited ) return
  2406  
  2407      ! デフォルト値の設定
  2408      ! Default values settings
  2409      !
  2410  
  2411      rad15mkg_fn = "./kg15m"
  2412  !!$    rad15mnf_fn = "./nlte15mfactor"
  2413      Rad15mInt   = 925.0_DP
  2414  
  2415      ! NAMELIST の読み込み
  2416      ! NAMELIST is input
  2417      !
  2418      if ( trim(namelist_filename) /= '' ) then
  2419        call FileOpen( unit_nml, &          ! (out)
  2420          & namelist_filename, mode = 'r' ) ! (in)
  2421  
  2422        rewind( unit_nml )
  2423        read( unit_nml,                &  ! (in)
  2424          & nml = rad_Mars_15m_nml,    &  ! (out)
  2425          & iostat = iostat_nml )         ! (out)
  2426        close( unit_nml )
  2427  
  2428        call NmlutilMsg( iostat_nml, module_name ) ! (in)
  2429      end if
  2430  
  2431  
  2432  !!$    allocate( rad_gp   ( im, jm,   km ) )
  2433  !!$    allocate( rad_gph  ( im, jm, 0:km ) )
  2434  !!$    allocate( rad_gt   ( im, jm,   km ) )
  2435  !!$    allocate( rad_gts  ( im, jm,   1  ) )
  2436  !!$    allocate( rad_gdod ( im, jm, 0:km ) )
  2437  
  2438  
  2439      nras = 1
  2440      nrps = 0
  2441  
  2442  !!$    allocate( sgmh_f          ( km*nvr+1 ), &
  2443  !!$      &       sgm_f           ( km*nvr   ) )
  2444  !!$    allocate( gph_f    ( im, jm, km*nvr+1 ), &
  2445  !!$      &       gp_f     ( im, jm, km*nvr   ), &
  2446  !!$      &       gth_f    ( im, jm, km*nvr+1 ) )
  2447  !!$
  2448  !!$    allocate( gvmr_f   ( im, jm, km*nvr  , nras + nrps ) )
  2449  !!$    allocate( mmmass_f ( im, jm, km*nvr   ) )
  2450  !!$    allocate( ac_f     ( im, jm, km*nvr  , nras        ) )
  2451  !!$
  2452  !!$    allocate( gdod_f   ( im, jm, km*nvr+1 ) )
  2453  !!$
  2454  !!$
  2455      allocate( xyra_Trans  (0:imax-1, 1:jmax, 0:kmax, 0:kmax) )
  2456  !!$    allocate( pfh_f    ( im, jm, km*nvr+1 ) )
  2457  !!$
  2458  !!$    allocate( uwflh_f  ( im, jm, km*nvr+1 ), &
  2459  !!$      &       dwflh_f  ( im, jm, km*nvr+1 ) )
  2460  
  2461  
  2462      allocate( &
  2463        & trans_i2i_toa(0:imax-1, 1:jmax, 0:kmax), &
  2464        & trans_i2i_boa(0:imax-1, 1:jmax, 0:kmax), &
  2465        & trans_i2i_s  (0:imax-1, 1:jmax, 0:kmax), &
  2466        & trans_i2m_lli(0:imax-1, 1:jmax, 0:kmax, 1:kmax), &
  2467        & trans_i2m_uli(0:imax-1, 1:jmax, 0:kmax, 1:kmax)  &
  2468        & )
  2469  
  2470      trans_i2i_toa(:,:,:)   = 1.0d100
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t236 = 1, (trans_i2i_toa.DSC.U3 + 1 - trans_i2i_toa.DSC.L3)*(  
     .       1   trans_i2i_toa.DSC.U2 + 1 - trans_i2i_toa.DSC.L2)*(             
     .       2   trans_i2i_toa.DSC.U1 + 1 - trans_i2i_toa.DSC.L1)               
     .           trans_i2i_toa(trans_i2i_toa.DSC.L1+t236-1,trans_i2i_toa.DSC.L2,
     .       1      trans_i2i_toa.DSC.L3) = 1.00000000000000e+100               
     .        enddo                                                             
  2471      trans_i2i_boa(:,:,:)   = 1.0d100
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t245 = 1, (trans_i2i_boa.DSC.U3 + 1 - trans_i2i_boa.DSC.L3)*(  
     .       1   trans_i2i_boa.DSC.U2 + 1 - trans_i2i_boa.DSC.L2)*(             
     .       2   trans_i2i_boa.DSC.U1 + 1 - trans_i2i_boa.DSC.L1)               
     .           trans_i2i_boa(trans_i2i_boa.DSC.L1+t245-1,trans_i2i_boa.DSC.L2,
     .       1      trans_i2i_boa.DSC.L3) = 1.00000000000000e+100               
     .        enddo                                                             
  2472      trans_i2i_s  (:,:,:)   = 1.0d100
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t254 = 1, (trans_i2i_s.DSC.U3 + 1 - trans_i2i_s.DSC.L3)*(      
     .       1   trans_i2i_s.DSC.U2 + 1 - trans_i2i_s.DSC.L2)*(                 
     .       2   trans_i2i_s.DSC.U1 + 1 - trans_i2i_s.DSC.L1)                   
     .           trans_i2i_s(trans_i2i_s.DSC.L1+t254-1,trans_i2i_s.DSC.L2,      
     .       1      trans_i2i_s.DSC.L3) = 1.00000000000000e+100                 
     .        enddo                                                             
  2473      trans_i2m_lli(:,:,:,:) = 1.0d100
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t263 = 1, (trans_i2m_lli.DSC.U4 + 1 - trans_i2m_lli.DSC.L4)*(  
     .       1   trans_i2m_lli.DSC.U3 + 1 - trans_i2m_lli.DSC.L3)*(             
     .       2   trans_i2m_lli.DSC.U2 + 1 - trans_i2m_lli.DSC.L2)*(             
     .       3   trans_i2m_lli.DSC.U1 + 1 - trans_i2m_lli.DSC.L1)               
     .           trans_i2m_lli(trans_i2m_lli.DSC.L1+t263-1,trans_i2m_lli.DSC.L2,
     .       1      trans_i2m_lli.DSC.L3,trans_i2m_lli.DSC.L4) =                
     .       2      1.00000000000000e+100                                       
     .        enddo                                                             
  2474      trans_i2m_uli(:,:,:,:) = 1.0d100
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t275 = 1, (trans_i2m_uli.DSC.U4 + 1 - trans_i2m_uli.DSC.L4)*(  
     .       1   trans_i2m_uli.DSC.U3 + 1 - trans_i2m_uli.DSC.L3)*(             
     .       2   trans_i2m_uli.DSC.U2 + 1 - trans_i2m_uli.DSC.L2)*(             
     .       3   trans_i2m_uli.DSC.U1 + 1 - trans_i2m_uli.DSC.L1)               
     .           trans_i2m_uli(trans_i2m_uli.DSC.L1+t275-1,trans_i2m_uli.DSC.L2,
     .       1      trans_i2m_uli.DSC.L3,trans_i2m_uli.DSC.L4) =                
     .       2      1.00000000000000e+100                                       
     .        enddo                                                             
  2475  
  2476  
  2477      !
  2478      ! check
  2479      !
  2480      if( nras .ne. 1 ) then
  2481        write( 6, * ) 'nras is not 1.'
  2482        write( 6, * ) nras
  2483        stop
  2484      end if
  2485  
  2486      call ckd_input( rad15mkg_fn )
  2487  
  2488      ! check
  2489      if( nband /= 1 ) then
  2490        write( 6, * ) ' nband is not 1.'
  2491        write( 6, * ) nband
  2492        stop
  2493      end if
  2494  
  2495      nwnl = 0
  2496      do m = 1, nband
  2497        nwnl = nwnl + ckdp( m ) % ng
  2498      end do
  2499  
  2500  
  2501  
  2502  !!$    call increase_vreso_boundary( km, nvr, sgmh, sgmh_f, "log" )
  2503  !!$    do k = 1, km * nvr
  2504  !!$      sgm_f( k ) = sqrt( sgmh_f( k ) * sgmh_f( k+1 ) )
  2505  !!$    end do
  2506  
  2507  
  2508  !!$    call rad15m_readnlte15mfac( rad15mnf_fn )
  2509  
  2510  
  2511      !
  2512      ! This routine must be called after rad15m_readkgtbl.
  2513      !
  2514  !!$      call rad15m_rv_read( time )
  2515  !!$    call rad15m_rv_read_newscheme2006( time )
  2516  
  2517  
  2518      rad_Mars_15m_inited = .true.
  2519  
  2520  
  2521    end subroutine RadMars15mInit
  2522  
  2523    !**************************************************************************
  2524  
  2525  !!$  subroutine rad15m_rv_put_newscheme2006( time, gt, gph, gp, gts, gdod, ijs, ije )
  2526  !!$
  2527  !!$    real(DP), intent(in ) :: time
  2528  !!$    real(DP), intent(in ) :: gt ( im, jm, km   )
  2529  !!$    real(DP), intent(in ) :: gph( im, jm, km+1 ), gp( im, jm, km )
  2530  !!$    real(DP), intent(in ) :: gts( im, jm )
  2531  !!$    real(DP), intent(in ) :: gdod( im, jm, km+1 )
  2532  !!$    integer , intent(in ) :: ijs, ije
  2533  !!$
  2534  !!$
  2535  !!$    !
  2536  !!$    ! local variables
  2537  !!$    !
  2538  !!$    integer  :: ij, k
  2539  !!$    real(DP) :: q15m( im, jm, km )
  2540  !!$    real(DP) :: gdf15m( im, jm )
  2541  !!$
  2542  !!$
  2543  !!$    q15m(:,:,:) = 1.0d100
  2544  !!$    gdf15m(:,:) = 1.0d100
  2545  !!$
  2546  !!$
  2547  !!$    rad_time = time
  2548  !!$
  2549  !!$
  2550  !!$    do k = 1, km
  2551  !!$      do ij = ijs, ije
  2552  !!$        rad_gt( ij, 1, k ) = gt( ij, 1, k )
  2553  !!$      end do
  2554  !!$    end do
  2555  !!$    do k = 1, km+1
  2556  !!$      do ij = ijs, ije
  2557  !!$        rad_gph( ij, 1, k-1 ) = gph( ij, 1, k )
  2558  !!$      end do
  2559  !!$    end do
  2560  !!$    do k = 1, km
  2561  !!$      do ij = ijs, ije
  2562  !!$        rad_gp( ij, 1, k ) = gp( ij, 1, k )
  2563  !!$      end do
  2564  !!$    end do
  2565  !!$    do ij = ijs, ije
  2566  !!$      rad_gts( ij, 1, 1 ) = gts( ij, 1 )
  2567  !!$    end do
  2568  !!$    do k = 1, km+1
  2569  !!$      do ij = ijs, ije
  2570  !!$        rad_gdod( ij, 1, k-1 ) = gdod( ij, 1, k )
  2571  !!$      end do
  2572  !!$    end do
  2573  !!$
  2574  !!$
  2575  !!$    sw_prep_rv = .true.
  2576  !!$
  2577  !!$
  2578  !!$  end subroutine rad15m_rv_put_newscheme2006
  2579  
  2580    !**************************************************************************
  2581  
  2582  !!$  subroutine rad15m_rv_read_newscheme2006( timei )
  2583  !!$
  2584  !!$    use mamicro   , only : ntask, ijstart, ijend
  2585  !!$
  2586  !!$
  2587  !!$    real(DP), intent(in ) :: timei
  2588  !!$
  2589  !!$
  2590  !!$    !
  2591  !!$    ! local variables
  2592  !!$    !
  2593  !!$    integer, parameter :: mch = -1
  2594  !!$    logical     , parameter :: lgf = .false.
  2595  !!$
  2596  !!$    real(DP)                :: time
  2597  !!$    integer            :: ierr, ierr1, ierr2, ierr3, ierr4, ierr5
  2598  !!$    integer            :: iter
  2599  !!$
  2600  !!$
  2601  !!$    call ainini( rad_gp  , time, iter, ierr1, ihed(1), timei, &
  2602  !!$      &          mch     , lgf , im  , jm   , km   )
  2603  !!$    call ainini( rad_gph , time, iter, ierr2, ihed(2), timei, &
  2604  !!$      &          mch     , lgf , im  , jm   , km+1 )
  2605  !!$    call ainini( rad_gt  , time, iter, ierr3, ihed(3), timei, &
  2606  !!$      &          mch     , lgf , im  , jm   , km   )
  2607  !!$    call ainini( rad_gts , time, iter, ierr4, ihed(4), timei, &
  2608  !!$      &          mch     , lgf , im  , jm   , 1    )
  2609  !!$    call ainini( rad_gdod, time, iter, ierr5, ihed(5), timei, &
  2610  !!$      &          mch     , lgf , im  , jm   , km+1 )
  2611  !!$
  2612  !!$
  2613  !!$    ierr = max( ierr1, ierr2, ierr3, ierr4, ierr5 )
  2614  !!$
  2615  !!$    if( ierr .gt. 0 ) then
  2616  !!$      write( 6, * ) 'MARS: Radiative restart variables cannot be found.'
  2617  !!$    end if
  2618  !!$
  2619  !!$
  2620  !!$    rad_time = time
  2621  !!$
  2622  !!$
  2623  !!$    if( ierr .lt. 1 ) sw_prep_rv = .true.
  2624  !!$
  2625  !!$
  2626  !!$    if( ierr .lt. 1 ) then
  2627  !!$
  2628  !!$      write( 6, * ) 'MARS: Transmission is calculated.'
  2629  !!$
  2630  !!$      call rad15m_2006_rv_read_calctransW
  2631  !!$
  2632  !!$    end if
  2633  !!$
  2634  !!$
  2635  !!$  end subroutine rad15m_rv_read_newscheme2006
  2636  
  2637    !**************************************************************************
  2638  
  2639  !!$  subroutine rad15m_2006_rv_read_calctransW
  2640  !!$
  2641  !!$    use mamicro   , only : ntask, ijstart, ijend
  2642  !!$
  2643  !!$
  2644  !!$    !
  2645  !!$    ! local variables
  2646  !!$    !
  2647  !!$    integer            :: m
  2648  !!$    integer            :: ij, k
  2649  !!$    integer            :: ijs, ije
  2650  !!$
  2651  !!$    real(DP)                :: &
  2652  !!$      gph( im, jm, km+1 ), gp( im, jm, km ), &
  2653  !!$      gt ( im, jm, km   ), gts( im, jm ), &
  2654  !!$      gdod( im, jm, km+1 )
  2655  !!$
  2656  !!$
  2657  !!$!cdir pardo for
  2658  !!$    do m = 1,ntask
  2659  !!$      ijs = ijstart( m )
  2660  !!$      ije = ijend( m )
  2661  !!$
  2662  !!$
  2663  !!$      do k = 1, km
  2664  !!$        do ij = ijs, ije
  2665  !!$          gp  ( ij, 1, k ) = rad_gp  ( ij, 1, k )
  2666  !!$          gt  ( ij, 1, k ) = rad_gt  ( ij, 1, k )
  2667  !!$        end do
  2668  !!$      end do
  2669  !!$      do ij = ijs, ije
  2670  !!$        gts( ij, 1 ) = rad_gts( ij, 1, 1 )
  2671  !!$      end do
  2672  !!$      do k = 0, km
  2673  !!$        do ij = ijs, ije
  2674  !!$          gph ( ij, 1, k+1 ) = rad_gph ( ij, 1, k )
  2675  !!$          gdod( ij, 1, k+1 ) = rad_gdod( ij, 1, k )
  2676  !!$        end do
  2677  !!$      end do
  2678  !!$
  2679  !!$
  2680  !!$      call rad15m_2006_rv_read_calctrans( &
  2681  !!$        & gt, gph, gp, gts, &
  2682  !!$        & gdod, &
  2683  !!$        & ijs, ije )
  2684  !!$
  2685  !!$    end do
  2686  !!$
  2687  !!$
  2688  !!$  end subroutine rad15m_2006_rv_read_calctransW
  2689  
  2690    !**************************************************************************
  2691  
  2692  !!$  subroutine rad15m_rv_wrt_newscheme2006( ifl )
  2693  !!$
  2694  !!$    use maaxisr, only : signame, sighname
  2695  !!$
  2696  !!$
  2697  !!$    integer, intent(in ) :: ifl
  2698  !!$
  2699  !!$
  2700  !!$    !
  2701  !!$    ! local variables
  2702  !!$    !
  2703  !!$    integer     , parameter :: izero  = 0
  2704  !!$    integer(i8b)     , parameter :: notime = 0
  2705  !!$    character(len=lc), parameter :: nounit = '   '
  2706  !!$    character(len= 3), parameter :: dfmt   = 'UR8'
  2707  !!$    real(DP)         , parameter :: miss   = -1.0d30
  2708  !!$
  2709  !!$    integer                 :: iter, idate( 6 )
  2710  !!$
  2711  !!$
  2712  !!$    if( sw_prep_rv ) then
  2713  !!$      call ansymd( idate, rad_time )
  2714  !!$
  2715  !!$
  2716  !!$      call aonjrf( rad_gp  , ihed(1), titl(1), 'Pa'   , signame , &
  2717  !!$        &          km      , iter   , idate  , izero  , nounit  , &
  2718  !!$        &          notime  , idate  , notime , dfmt   , miss    , ifl )
  2719  !!$      call aonjrf( rad_gph , ihed(2), titl(2), 'Pa'   , sighname, &
  2720  !!$        &          km+1    , iter   , idate  , izero  , nounit  , &
  2721  !!$        &          notime  , idate  , notime , dfmt   , miss    , ifl )
  2722  !!$      call aonjrf( rad_gt  , ihed(3), titl(3), 'K'    , signame , &
  2723  !!$        &          km      , iter   , idate  , izero  , nounit  , &
  2724  !!$        &          notime  , idate  , notime , dfmt   , miss    , ifl )
  2725  !!$      call aonjrf( rad_gts , ihed(4), titl(4), 'K'    , sighname, &
  2726  !!$        &          1       , iter   , idate  , izero  , nounit  , &
  2727  !!$        &          notime  , idate  , notime , dfmt   , miss    , ifl )
  2728  !!$      call aonjrf( rad_gdod, ihed(5), titl(5), '1'    , sighname, &
  2729  !!$        &          km+1    , iter   , idate  , izero  , nounit  , &
  2730  !!$        &          notime  , idate  , notime , dfmt   , miss    , ifl )
  2731  !!$    end if
  2732  !!$
  2733  !!$
  2734  !!$
  2735  !!$  end subroutine rad15m_rv_wrt_newscheme2006
  2736  
  2737    !**************************************************************************
  2738  
  2739  
  2740  
  2741  
  2742  end module rad_Mars_15m
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:59 2016
FILE NAME: rad_Mars_15m.f90
PROGRAM NAME: rad_mars_15m
FORMAT LIST

  LINE    LOOP      FORTRAN STATEMENT

     1:             module rad_Mars_15m
     2:             
     3:               ! モジュール引用 ; USE statements
     4:               !
     5:             
     6:               ! 種別型パラメタ
     7:               ! Kind type parameter
     8:               !
     9:               use dc_types, only: DP, &      ! 倍精度実数型. Double precision.
    10:                 &                 STRING, &  ! 文字列.       Strings.
    11:                 &                 TOKEN      ! キーワード.   Keywords.
    12:             
    13:               ! 格子点設定
    14:               ! Grid points settings
    15:               !
    16:               use gridset, only: imax, & ! 経度格子点数.
    17:                                          ! Number of grid points in longitude
    18:                 &                jmax, & ! 緯度格子点数.
    19:                                          ! Number of grid points in latitude
    20:                 &                kmax    ! 鉛直層数.
    21:                                          ! Number of vertical level
    22:             
    23:             
    24:               ! 宣言文 ; Declaration statements
    25:               !
    26:               implicit none
    27:               private
    28:             
    29:               ! 公開手続き
    30:               ! Public procedure
    31:               !
    32:               public :: RadMars15mInit
    33:               public :: RadMars15m
    34:             
    35:             
    36:               ! 公開変数
    37:               ! Public variables
    38:               !
    39:               logical, save, public:: rad_Mars_15m_inited = .false.
    40:                                           ! 初期設定フラグ.
    41:                                           ! Initialization flag.
    42:             
    43:             
    44:               ! 非公開変数
    45:               ! Private variables
    46:               !
    47:               real(DP), parameter :: VMRCO2 = 0.95d0
    48:               real(DP), parameter :: AMU    = 1.6605655d-27
    49:             
    50:             
    51:             
    52:               ! Variables for radiation calculation
    53:               !
    54:               ! kg1,kg2,kg3          : maximum number of first, second, third index
    55:               !                      :   for tables of absorption coefficient (cumulative
    56:               !                      : probability function)
    57:               ! kg1(kg1n)            : increament of cumulative probability function
    58:               ! kg2(kg2n)            : pressure (hPa)
    59:               ! kg3(kg3n)            : temperature (K)
    60:               ! dg(kg1n)             : increament of cumulative probability function
    61:               ! lnkg???(...,...,...) : table of absorption coefficient as a function of
    62:               !                      : cumulative probability function, pressure
    63:               !                      : and temperature (m^-1 / (kg m^-2))
    64:               !
    65:               integer , parameter :: kg1n = 16, kg2n = 55, kg3n = 3
    66:               real(DP), save      :: kg1( kg1n ), kg2( kg2n ), kg3( kg3n )
    67:               real(DP), save      :: lnkg( kg1n, kg2n, kg3n )
    68:             
    69:             
    70:               ! nl15fn               : maximum number of factors for 15 micron Non-LTE
    71:               !                      : radiative cooling rate calculation
    72:               ! nl15sn               : "reduced" optical depth for 15 micron Non-LTE
    73:               !                      : radiative cooling rate calculation
    74:               ! nl15fa               : parameter for 15 micron Non-LTE
    75:               !                      : radiative cooling rate calculation
    76:               !
    77:               integer , parameter :: nl15fn = 70
    78:               real(DP), save      :: nl15sn( nl15fn )
    79:               real(DP), save      :: nl15fa( nl15fn )
    80:             
    81:             
    82:               ! Variables below must have save attribute since these variables are not 
    83:               ! necessarily updated every time steps. 
    84:               !
    85:               ! trans0_res : Transmission from top of the atmosphere to each level.
    86:               ! trans_res  : Transmission between the atmospheric levels
    87:               !
    88:             !    real(dp), save :: &
    89:             !         trans0_res( km+1, im, jm ), trans_res( km+1, km+1, im, jm )
    90:             
    91:               real(DP), allocatable, save :: &
    92:                 trans_res(:,:,:,:)
    93:             
    94:             
    95:               !
    96:               ! 
    97:               !
    98:               real(DP), parameter :: nlte_refp = 1.0d-2
    99:             
   100:             
   101:               logical , save :: sw_prep_rv
   102:               data sw_prep_rv /.false./
   103:             
   104:             
   105:               integer        , parameter :: lc     = 16
   106:             
   107:             
   108:             !!$    character(len=lc   ), save      :: ihed( 5 )
   109:             !!$    character(len=lc+lc), save      :: titl( 5 )
   110:             !!$    data  ihed / 'RAD_P', 'RAD_PH', 'RAD_T', 'RAD_TS', 'RAD_DOD' /
   111:             !!$    data  titl / 'RAD_P', 'RAD_PH', 'RAD_T', 'RAD_TS', 'RAD_DOD' /
   112:             
   113:             
   114:               real(DP),              save :: rad_time
   115:               real(DP), allocatable, save :: &
   116:                 & rad_gp  ( :, :, : ), &
   117:                 & rad_gph ( :, :, : ), &
   118:                 & rad_gt  ( :, :, : ), &
   119:                 & rad_gts ( :, :, : ), &
   120:                 & rad_gdod( :, :, : )
   121:             
   122:             
   123:               real(DP)             , save :: Rad15mInt
   124:             
   125:               integer              , save :: nwnl
   126:             
   127:             
   128:             
   129:               !
   130:               ! nwnsl : number of wavenumber sub loop 
   131:               !       : (inner most loop for optimization)
   132:               !
   133:               integer             , save :: nras, nrps
   134:               integer             , save :: nwnsl
   135:             
   136:             
   137:             !!$  real(DP)    , allocatable, save :: sgmh_f( : ), sgm_f( : )
   138:             !!$  real(DP)    , allocatable, save :: gph_f ( :, :, : ), gp_f( :, :, : ), &
   139:             !!$    & gth_f( :, :, : )
   140:             !!$
   141:             !!$  real(DP)    , allocatable, save :: pfh_f ( :, :, : )
   142:             
   143:             
   144:             
   145:               !
   146:               ! *_f( :, ... )             :: variable on fine vertical grids
   147:               !
   148:               ! gvmr_f  ( km, nras+nrps ) :: volume mixing ratio
   149:               ! mmmass_f( km )            :: mean molecular mass
   150:               !
   151:               ! ac( nwnsl, km, nras )   :: absorption coefficient
   152:               !
   153:               ! trans_f( iwnsl, k1, k2 ) :: transmittance between layer interface k1 
   154:               !                          :: and layer midlevel k2
   155:               !
   156:             !!$  real(DP)    , allocatable, save :: gvmr_f  ( :, :, :, : )
   157:             !!$  real(DP)    , allocatable, save :: mmmass_f( :, :, : )
   158:             !!$  real(DP)    , allocatable, save :: ac_f    ( :, :, :, : )
   159:               real(DP)    , allocatable, save :: xyra_Trans (:,:,:,:)
   160:             !!$  real(DP)    , allocatable, save :: gdod_f  ( :, :, : )
   161:             !!$
   162:             !!$  real(DP)    , allocatable, save :: uwflh_f( :, :, : ), dwflh_f( :, :, : )
   163:             
   164:             
   165:             
   166:             
   167:             
   168:               real(DP)    , allocatable, save :: &
   169:                 & trans_i2i_toa(:,:,:), &          ! f_{1/2}    T_{k+1/2,1/2}
   170:                 & trans_i2i_boa(:,:,:), &          ! f_{km+1/2} T_{k+1/2,km+1/2}
   171:                 & trans_i2i_s  (:,:,:), &          ! f_{s}      T_{k+1/2,km+1/2}
   172:                 & trans_i2m_lli(:,:,:,:), & ! upper layer interface
   173:                 & trans_i2m_uli(:,:,:,:) ! lower layer interface
   174:             
   175:             
   176:               character(*), parameter:: module_name = 'rad_Mars_15m'
   177:                                           ! モジュールの名称.
   178:                                           ! Module name
   179:               character(*), parameter:: version = &
   180:                 & '$Name:  $' // &
   181:                 & '$Id: rad_Mars_15m.f90,v 1.7 2012/11/10 05:00:50 yot Exp $'
   182:                                           ! モジュールのバージョン
   183:                                           ! Module version
   184:             
   185:             
   186:             contains
   187:             
   188:               !**************************************************************************
   189:               ! subroutine rad15m_lowatm_main
   190:               ! calculate radiative heating/cooling rate in CO2 15 micron band
   191:               !**************************************************************************
   192:             
   193:               subroutine RadMars15m( Time, DelTime, &
   194:                 & xyz_Temp, xyr_Press, xyz_Press, xy_SurfTemp, &
   195:                 & xyr_DOD067, QeRat, SSA, xy_SurfEmis, &
   196:                 & xyr_Rad15mFlux, xyra_DelRad15mFlux &
   197:                 & )
   198:             
   199:                 ! メッセージ出力
   200:                 ! Message output
   201:                 !
   202:                 use dc_message, only: MessageNotify
   203:             
   204:                 real(DP)    , intent(in ) :: Time
   205:                 real(DP)    , intent(in ) :: DelTime
   206:                 real(DP)    , intent(in ) :: xyz_Temp          (0:imax-1, 1:jmax, 1:kmax)
   207:                 real(DP)    , intent(in ) :: xyr_Press         (0:imax-1, 1:jmax, 0:kmax)
   208:                 real(DP)    , intent(in ) :: xyz_Press         (0:imax-1, 1:jmax, 1:kmax)
   209:                 real(DP)    , intent(in ) :: xy_SurfTemp       (0:imax-1, 1:jmax)
   210:                 real(DP)    , intent(out) :: xyr_Rad15mFlux    (0:imax-1, 1:jmax, 0:kmax)
   211:                 real(DP)    , intent(out) :: xyra_DelRad15mFlux(0:imax-1, 1:jmax, 0:kmax, 0:1)
   212:                 real(DP)    , intent(in ) :: xyr_DOD067        (0:imax-1, 1:jmax, 0:kmax)
   213:                 real(DP)    , intent(in ) :: QeRat
   214:                 real(DP)    , intent(in ) :: SSA
   215:                 real(DP)    , intent(in ) :: xy_SurfEmis       (0:imax-1, 1:jmax)
   216:             
   217:             
   218:                 !
   219:                 ! local variables
   220:                 !
   221:             
   222:             
   223:                 ! 実行文 ; Executable statement
   224:                 !
   225:             
   226:                 ! 初期化
   227:                 ! Initialization
   228:                 !
   229:                 if ( .not. rad_Mars_15m_inited ) then
   230:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   231:                 end if
   232:             
   233:                 call rad15m_lowatm_newscheme2006( Time, DelTime, &
   234:                   & xyz_Temp, xyr_Press, xyz_Press, xy_SurfTemp, &
   235:                   & xyr_DOD067, QeRat, SSA, xy_SurfEmis, &
   236:                   & xyr_Rad15mFlux, xyra_DelRad15mFlux &
   237:                   & )
   238:             
   239:               end subroutine RadMars15m
   240:             
   241:               !**************************************************************************
   242:               ! subroutine radiation15m
   243:               ! calculate radiative heating/cooling rate in CO2 15 micron band
   244:               !**************************************************************************
   245:             
   246:               subroutine rad15m_lowatm_newscheme2006( Time, DelTime, &
   247:                 & xyz_Temp, xyr_Press, xyz_Press, xy_SurfTemp, &
   248:                 & xyr_DOD067, QeRat, SSA, xy_SurfEmis, &
   249:                 & xyr_Rad15mFlux, xyra_DelRad15mFlux &
   250:                 & )
   251:             
   252:             
   253:                 use constants , only : &
   254:                   & Grav, &
   255:                   & CpDry
   256:             
   257:                 ! メッセージ出力
   258:                 ! Message output
   259:                 !
   260:                 use dc_message, only: MessageNotify
   261:             
   262:                 use ckd_module, only : ckdp
   263:             
   264:             
   265:                 real(DP)    , intent(in ) :: Time
   266:                 real(DP)    , intent(in ) :: DelTime
   267:                 real(DP)    , intent(in ) :: xyr_Press(0:imax-1, 1:jmax, 0:kmax)
   268:                 real(DP)    , intent(in ) :: xyz_Press(0:imax-1, 1:jmax, 1:kmax)
   269:                 real(DP)    , intent(in ) :: xyz_Temp   (0:imax-1, 1:jmax, 1:kmax)
   270:                 real(DP)    , intent(in ) :: xy_SurfTemp(0:imax-1, 1:jmax)
   271:                 real(DP)    , intent(in ) :: xyr_DOD067(0:imax-1, 1:jmax, 0:kmax)
   272:                 real(DP)    , intent(in ) :: QeRat
   273:                 real(DP)    , intent(in ) :: SSA
   274:                 real(DP)    , intent(in ) :: xy_SurfEmis(0:imax-1, 1:jmax)
   275:             
   276:                 real(DP)    , intent(out) :: xyr_Rad15mFlux (0:imax-1, 1:jmax, 0:kmax)
   277:                 real(DP)    , intent(out) :: xyra_DelRad15mFlux(0:imax-1, 1:jmax, 0:kmax, 0:1)
   278:             
   279:                 !
   280:                 ! local variables
   281:                 !
   282:                 real(DP) :: xyr_Temp  (0:imax-1, 1:jmax, 0:kmax)
   283:                 real(DP) :: xyz_MMMass(0:imax-1, 1:jmax, 1:kmax)
   284:                 real(DP) :: xyza_VMR(0:imax-1, 1:jmax, 1:kmax, 1:nras+nrps )
   285:                 real(DP) :: xyza_AC (0:imax-1, 1:jmax, 1:kmax, 1:nras      )
   286:                 real(DP) :: xyr_PF   (0:imax-1, 1:jmax, 0:kmax)
   287:                 real(DP) :: xy_SurfPF(0:imax-1, 1:jmax)
   288:             
   289:                 real(DP) :: xy_DPFDT(0:imax-1, 1:jmax)
   290:             
   291:                 real(DP) :: weight_integral
   292:                 integer  :: ig, iband
   293:             
   294:                 integer  :: i, j, k, l, m, n
   295:                 integer  :: k2
   296:             
   297:                 !
   298:                 ! dod      : dust optical depth
   299:                 !
   300:                 real(DP) :: xyr_DOD(0:imax-1, 1:jmax, 0:kmax)
   301:             
   302:                 !
   303:                 ! local variables for pfint
   304:                 !
   305:             
   306:                 real(DP) :: MinPress
   307:                 real(DP) :: MaxPress
   308:             
   309:                 integer  :: iband_reserve
   310:                 real(DP) :: xy_lnPs    (0:imax-1, 1:jmax)
   311:                 real(DP) :: xyz_lnPress(0:imax-1, 1:jmax, 1:kmax )
   312:                 integer  :: xyz_jj(0:imax-1, 1:jmax, 1:kmax)
   313:                 integer  :: xyz_kk(0:imax-1, 1:jmax, 1:kmax)
   314:                 integer  :: xy_jj (0:imax-1, 1:jmax)
   315:                 integer  :: xy_kk (0:imax-1, 1:jmax)
   316:             
   317:             
   318:                 ! Surface temperature for calculation of gradient of radiative flux
   319:                 real(DP) :: xy_SurfTemp_for_gradcalc(0:imax-1, 1:jmax)
   320:                 ! Indices for calculation of gradient of radiative flux
   321:                 integer  :: jjs_for_gradcalc(0:imax-1, 1:jmax), kks_for_gradcalc(0:imax-1, 1:jmax)
   322:             
   323:                 real(DP)     :: xyr_PFRat   (0:imax-1, 1:jmax, 0:kmax)
   324:                 real(DP)     :: xyz_PFRat   (0:imax-1, 1:jmax, 1:kmax)
   325:                 real(DP)     :: xy_SurfPFRat(0:imax-1, 1:jmax)
   326:             
   327:                 logical, save :: FlagCalcTrans
   328:             
   329:                 data FlagCalcTrans / .false. /
   330:             
   331:             
   332:                 ! 初期化
   333:                 ! Initialization
   334:                 !
   335:                 if ( .not. rad_Mars_15m_inited ) then
   336:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   337:                 end if
   338:             
   339:             
   340:                 k = 0
   341: W------>        do j = 1, jmax
   342: |*----->          do i = 0, imax-1
   343: ||          !!$        gth(i,j,k) = gt(i,j,k+1)
   344: ||      A           xyr_Temp(i,j,k) = &
   345: ||                    &  ( xyz_Temp(i,j,2) - xyz_Temp(i,j,1) ) &
   346: ||                    & / log( xyz_Press(i,j,2) / xyz_Press(i,j,1) ) &
   347: ||                    & * log( xyr_Press(i,j,k) / xyz_Press(i,j,1) ) &
   348: ||                    & + xyz_Temp(i,j,1)
   349: |*-----           end do
   350: W------         end do
   351: W------>        do k = 1, kmax-1
   352: |*----->          do j = 1, jmax
   353: ||*---->            do i = 0, imax-1
   354: |||     A             xyr_Temp(i,j,k) = &
   355: |||                     &  ( xyz_Temp(i,j,k+1) - xyz_Temp(i,j,k) ) &
   356: |||                     & / log( xyz_Press(i,j,k+1) / xyz_Press(i,j,k) ) &
   357: |||                     & * log( xyr_Press(i,j,k  ) / xyz_Press(i,j,k) ) &
   358: |||                     & + xyz_Temp(i,j,k)
   359: ||*----             end do
   360: |*-----           end do
   361: W------         end do
   362:                 k = kmax
   363: W------>        do j = 1, jmax
   364: |*----->          do i = 0, imax-1
   365: ||      A           xyr_Temp(i,j,k) = xyz_Temp(i,j,k)
   366: |*-----           end do
   367: W------         end do
   368:             
   369:             
   370:             !!$    do k = 1, km*nvr+1
   371:             !!$      do ij = ijs, ije
   372:             !!$        gph_f( ij, 1, k ) = sgmh_f( k ) * gph( ij, 1, km+1 )
   373:             !!$      end do
   374:             !!$    end do
   375:             !!$    call calc_lnp( im, jm, km*nvr+1, gph_f , glnph_f , ijs, ije )
   376:             !!$
   377:             !!$    call increase_vreso_boundary_arr3d( im, jm, km, nvr, gth, gth_f, &
   378:             !!$      & "linear", ijs, ije )
   379:             
   380:             
   381:             
   382:                 if (  .not. FlagCalcTrans ) then
   383:                   if ( Time - dble( int( Time / Rad15mInt ) ) * Rad15mInt < DelTime ) then
   384:                     call MessageNotify( 'M', module_name, &
   385:                       & 'Transmittance is not saved, but criterion for transmittance calculation is met.' )
   386:                   else
   387:                     call MessageNotify( 'M', module_name, &
   388:                       & 'Transmittance is not saved, and criterion for transmittance calculation ' &
   389:                       & // 'is not met. However, transmittance will be calculated.' )
   390:                   end if
   391:                 end if
   392:             
   393:             
   394:                 !
   395:                 ! Calculation of transmission
   396:                 !
   397:                 if( ( .not. FlagCalcTrans ) .or. &
   398:                   & ( Time - dble( int( Time / Rad15mInt )  ) * Rad15mInt ) < DelTime ) then
   399:             
   400:                   FlagCalcTrans = .true.
   401:             
   402:             !!$      call MessageNotify( 'M', module_name, 'Transmission is calculated.' )
   403:             
   404:                   !
   405:                   ! Calculation of "absorption" dust optical depth
   406:                   ! This formulation is obtained from Forget et al. [1999].
   407:                   !
   408: W------>          do k = 0, kmax
   409: |*----->            do j = 1, jmax
   410: ||*---->              do i = 0, imax-1
   411: |||     A               xyr_DOD(i,j,k) = ( 1.0d0 - SSA ) * xyr_DOD067(i,j,k) * QeRat
   412: ||*----               end do
   413: |*-----             end do
   414: W------           end do
   415:             
   416:             !!$      call increase_vreso_boundary_arr3d( im, jm, km, nvr, gdod, gdod_f, &
   417:             !!$        & "log", ijs, ije )
   418:             
   419:             
   420:                   !
   421:                   ! check pressure
   422:                   !
   423:                   MinPress = 1.0d100
   424:                   MaxPress = 0.0d0
   425: W------>          do j = 1, jmax
   426: |*----->            do i = 0, imax-1
   427: ||      A             MinPress = min( MinPress, xyz_Press(i,j,kmax) )
   428: ||      A             MaxPress = max( MaxPress, xyz_Press(i,j,1   ) )
   429: |*-----             end do
   430: W------           end do
   431:                   if( ckdp(1)%lnp(1) > log(MinPress) ) then
   432:                     write( 6, * ) 'MARS: pressure is too small.'
   433:                     write( 6, * ) MinPress, exp(ckdp(1)%lnp(1))
   434:                     stop
   435:                   end if
   436:                   if( ckdp(1)%lnp(ckdp(1)%nlnp) .lt. log(MaxPress) ) then
   437:                     write( 6, * ) 'MARS: pressure is too large.'
   438:                     write( 6, * ) MaxPress, exp(ckdp(1)%lnp(ckdp(1)%nlnp))
   439:                     stop
   440:                   end if
   441:             
   442:             
   443: W**==== A         xyz_MMMass = 43.5d0 * AMU
   444: W------>          do n = 1, nras + nrps
   445: |*----->            do k = 1, kmax
   446: ||*---->              do j = 1, jmax
   447: |||*--->                do i = 0, imax-1
   448: ||||    A                 xyza_VMR(i,j,k,n) = VMRCO2
   449: |||*---                 end do
   450: ||*----               end do
   451: |*-----             end do
   452: W------           end do
   453:             
   454:             
   455:             !!$      do n = 1, nras + nrps
   456:             !!$        call increase_vreso_b2m_arr3d( im, jm, km, nvr, &
   457:             !!$          & gvmrh(:,:,:,n), gvmr_f(:,:,:,n), "log", &
   458:             !!$          & ijs, ije )
   459:             !!$      end do
   460:             !!$      call increase_vreso_b2m_arr3d( im, jm, km, nvr, &
   461:             !!$        & mmmassh, mmmass_f, "linear", &
   462:             !!$        & ijs, ije )
   463:             
   464:             !!$      call calc_lnp( im, jm, km+1    , gph   , glnph   , ijs, ije )
   465:                   call calc_lnp( xyz_Press, xyz_lnPress )
   466: W*===== A         xy_lnPs(:,:) = log( xyr_Press(:,:,0) )
   467:             
   468:             
   469:                   !
   470:                   ! initialization
   471:                   !
   472: +------>          do k = 0, kmax
   473: |+----->            do j = 1, jmax
   474: ||V---->              do i = 0, imax-1
   475: |||     A               trans_i2i_toa(i,j,k) = 0.0d0         ! f_{1/2}    T_{k+1/2,1/2}
   476: |||     A               trans_i2i_boa(i,j,k) = 0.0d0         ! f_{km+1/2} T_{k+1/2,km+1/2}
   477: |||     A               trans_i2i_s  (i,j,k) = 0.0d0         ! f_{s}      T_{k+1/2,km+1/2}
   478: ||V----               end do
   479: |+-----             end do
   480: +------           end do
   481: +------>          do k2 = 1, kmax
   482: |+----->            do k = 0, kmax
   483: ||+---->              do j = 1, jmax
   484: |||V--->                do i = 0, imax-1
   485: ||||    A                 trans_i2m_uli(i,j,k,k2) = 0.0d0
   486: ||||    A                 trans_i2m_lli(i,j,k,k2) = 0.0d0
   487: |||V---                 end do
   488: ||+----               end do
   489: |+-----             end do
   490: +------           end do
   491:             
   492:             
   493:                   !
   494:                   ! loop for wavenumber
   495:                   !
   496:             
   497:                   iband_reserve = 0
   498:             
   499: +------>          do m = 1, nwnl
   500: |           
   501: |                   call m2ckdpindices( m, ig, iband )
   502: |           
   503: |           
   504: |                   if( iband .ne. iband_reserve ) then
   505: |                     call findindices3D( &
   506: |                       & xyz_Temp, xyz_lnPress, iband, &
   507: |                       & xyz_jj, xyz_kk &
   508: |                       & )
   509: |                     call findindices2D(   &
   510: |                       & xy_SurfTemp, xy_lnPs,       &
   511: |                       & iband, xy_jj, xy_kk   &
   512: |                       & )
   513: |           
   514: |                     iband_reserve = iband
   515: |                   end if
   516: |           
   517: |           
   518: |                   ! IMPORTANT!
   519: |                   ! This loop for n is confusing.
   520: |                   ! We have to reconsider about it.
   521: |                   ! Maybe, the component of ckdp structure has to be reconsidered. 
   522: |                   ! Now, it cannot include multiple radiatively active species. 
   523: |                   ! (yot, 2010/09/12)
   524: |                   !
   525: |+----->            do n = 1, nras
   526: ||                    call getlnac_givenindices( &
   527: ||                      & xyz_Temp, xyz_lnPress, xyz_jj, xyz_kk, ig, iband, &
   528: ||                      & xyza_AC(:,:,:,n) &
   529: ||                      & )
   530: |+-----             end do
   531: |W----->            do n = 1, nras
   532: ||***== A             xyza_AC(:,:,:,n) = exp( xyza_AC(:,:,:,n) )
   533: |W-----             end do
   534: |           
   535: |           !!$        do n = 1, nras
   536: |           !!$          call increase_vreso_b2m_arr3d( im, jm, km, nvr, &
   537: |           !!$            & ach(:,:,:,n), ac_f(:,:,:,n), "log", &
   538: |           !!$            & ijs, ije )
   539: |           !!$        end do
   540: |           
   541: |           
   542: |                   call calc_trans_mp_arr3d(   &
   543: |                     & nras, nrps, xyr_Press, xyza_VMR, xyz_MMMass, &
   544: |                     & xyza_AC, xyr_DOD,                     &
   545: |                     & xyra_Trans                         &
   546: |                     & )
   547: |           
   548: |           
   549: |                   call getpfr_givenindices3D( &
   550: |                     & xyz_Temp, xyz_lnPress, xyz_jj, xyz_kk, ig, iband, &
   551: |                     & xyz_PFRat &
   552: |                     & )
   553: |W*==== A           xyr_PFRat(:,:,0) = xyz_PFRat(:,:,1)
   554: |W----->            do k = 1, kmax-1
   555: ||**=== A             xyr_PFRat(:,:,k) = ( xyz_PFRat(:,:,k) + xyz_PFRat(:,:,k+1) ) * 0.5_DP
   556: |W-----             end do
   557: |W*==== A           xyr_PFRat(:,:,kmax) = xyz_PFRat(:,:,kmax)
   558: |                   call getpfr_givenindices2D( &
   559: |                     & xy_SurfTemp, xy_lnPs, xy_jj, xy_kk, ig, iband, &
   560: |                     & xy_SurfPFRat &
   561: |                     & )
   562: |           
   563: |+----->            do k = 0, kmax
   564: ||+---->              do j = 1, jmax
   565: |||V--->                do i = 0, imax-1
   566: ||||    A                 trans_i2i_toa(i,j,k) =       &        ! f_{1/2}    T_{k+1/2,1/2}
   567: ||||                        & trans_i2i_toa(i,j,k)     &
   568: ||||                        & + xyra_Trans(i,j,k,kmax)      &
   569: ||||                        & * xyr_PFRat(i,j,kmax)    &
   570: ||||                        & * ckdp(iband)%weight(ig)
   571: ||||    A                 trans_i2i_boa(i,j,k) =       &        ! f_{km+1/2} T_{k+1/2,km+1/2}
   572: ||||                        & trans_i2i_boa(i,j,k)     &
   573: ||||                        & + xyra_Trans(i,j,k,0)         &
   574: ||||                        & * xyr_PFRat(i,j,0)       &
   575: ||||                        & * ckdp(iband)%weight(ig)
   576: ||||    A                 trans_i2i_s  (i,j,k) =       &        ! f_{s}      T_{k+1/2,km+1/2}
   577: ||||                        & trans_i2i_s  (i,j,k)     &
   578: ||||                        & + xyra_Trans(i,j,k,0)         &
   579: ||||                        & * xy_SurfPFRat(i,j)      &
   580: ||||                        & * ckdp(iband)%weight(ig)
   581: |||V---                 end do
   582: ||+----               end do
   583: |+-----             end do
   584: |           
   585: |+----->            do k2 = 1, kmax
   586: ||+---->              do k = 0, kmax
   587: |||+--->                do j = 1, jmax
   588: ||||V-->                  do i = 0, imax-1
   589: |||||   A                   trans_i2m_uli(i,j,k,k2) =                              &
   590: |||||                         & trans_i2m_uli(i,j,k,k2)                            &
   591: |||||                         & + ( xyra_Trans(i,j,k,k2-1) + xyra_Trans(i,j,k,k2) ) * 0.5d0  &
   592: |||||                         & * xyr_PFRat(i,j,k2  )                              &
   593: |||||                         & * ckdp(iband)%weight(ig)
   594: |||||   A                   trans_i2m_lli(i,j,k,k2) =                              &
   595: |||||                         & trans_i2m_lli(i,j,k,k2)                            &
   596: |||||                         & + ( xyra_Trans(i,j,k,k2-1) + xyra_Trans(i,j,k,k2) ) * 0.5d0  &
   597: |||||                         & * xyr_PFRat(i,j,k2-1)                              &
   598: |||||                         & * ckdp(iband)%weight(ig)
   599: ||||V--                   end do
   600: |||+---                 end do
   601: ||+----               end do
   602: |+-----             end do
   603: |           
   604: |           
   605: +------           end do
   606:             
   607:             
   608:             !!$      call rad15m_rv_put_newscheme2006( time, gt, gph, gp, gts, gdod, ijs, ije )
   609:             
   610:                 else
   611:             
   612:                   if ( trans_i2i_toa(0,1,1) > 1.0d99 ) then
   613:                     write( 6, * ) 'transmission function would not be calculated.'
   614:                     stop
   615:                   end if
   616:             
   617:                 end if
   618:             
   619:             
   620:                 ! Is this OK?
   621:                 iband = 1
   622:             
   623:                 call getpf_arr3d_norat( &
   624:                   & xyr_Temp, xy_SurfTemp, iband, &
   625:                   & xyr_PF, xy_SurfPF &
   626:                   & )
   627:             
   628:             
   629:                 call calc_rteq_use_meantrans_arr3d( &
   630:                   & ( ckdp(iband)%wnbnds(2) - ckdp(iband)%wnbnds(1) ), xy_SurfEmis, &
   631:                   & trans_i2i_toa, trans_i2i_boa, trans_i2i_s, &
   632:                   & trans_i2m_lli, trans_i2m_uli, &
   633:                   & xyr_PF, xy_SurfPF, xyr_Rad15mFlux &
   634:                   & )
   635:             
   636:             
   637: *------>        do l = 0, 1
   638: |W----->          do k = 0, kmax
   639: ||*---->            do j = 1, jmax
   640: |||*--->              do i = 0, imax-1
   641: ||||    A               xyra_DelRad15mFlux(i,j,k,l) = 0.0_DP
   642: |||*---               end do
   643: ||*----             end do
   644: |W-----           end do
   645: *------         end do
   646:             
   647:             
   648:             !!$    do k = kmax, 0, -1
   649:             !!$      write( 6, * ) gph(0,1,k), gr15mnetflh(0,1,k)
   650:             !!$    end do
   651:             !!$    stop
   652:             
   653:             
   654:             !!$      ij = ( ije - ijs + 1 ) / 2
   655:             !!$      k  = km + 1
   656:             !!$!      write( 6, * ) 'RAD15M : ', gr15mnetflh(ij,1,k), rad_gdr15mnetfldtsh0(ij,1,k-1) * ( gts(ij,1) - rad_gtsbase(ij,1,1) ), emis(ij,1) * 5.67d-8 * gts(ij,1)**4, gts(ij,1)
   657:             !!$!      write( 61, * ) gr15mnetflh(ij,1,k-1), rad_gdr15mnetfldtsh0(ij,1,k-1) * ( gts(ij,1) - rad_gtsbase(ij,1,1) ), emis(ij,1) * 5.67d-8 * gts(ij,1)**4, gts(ij,1), gt(ij,1,km), gt(ij,1,km-1), gt(ij,1,km-2), gt(ij,1,km-3), gt(ij,1,km-4), gt(ij,1,km-5)
   658:             !!$      write( 6, * ) 'RAD15M : ', gr15mnetflh(ij,1,k), &
   659:             !!$        & emis(ij,1) * 5.67d-8 * gts(ij,1)**4, gts(ij,1)
   660:             !!$      write( 61, * ) gr15mnetflh(ij,1,k-1), &
   661:             !!$        & emis(ij,1) * 5.67d-8 * gts(ij,1)**4, gts(ij,1), &
   662:             !!$        & gt(ij,1,km), gt(ij,1,km-1), gt(ij,1,km-2), gt(ij,1,km-3), &
   663:             !!$        & gt(ij,1,km-4), gt(ij,1,km-5)
   664:             !!$      call flush( 61 )
   665:             
   666:                 !
   667:                 ! output variables
   668:                 !
   669:             !!$    do j = 1, jmax
   670:             !!$      do i = 0, imax-1
   671:             !!$        goru(i,j) = uwflh_sum(i,j,kmax)
   672:             !!$        gord(i,j) = 0.0d0
   673:             !!$        gsru(i,j) = uwflh_sum(i,j,0)
   674:             !!$        gsrd(i,j) = dwflh_sum(i,j,0)
   675:             !!$        gor (i,j) = goru(i,j) - gord(i,j)
   676:             !!$        gsr (i,j) = gsru(i,j) - gsrd(i,j)
   677:             !!$      end do
   678:             !!$    end do
   679:             
   680:             
   681:             
   682:               end subroutine rad15m_lowatm_newscheme2006
   683:             
   684:               !**************************************************************************
   685:             
   686:               subroutine calc_trans_mp_arr3d(   &
   687:                 & nras, nrps, xyr_Press, xyza_VMR, xyz_MMMass, &
   688:                 & xyza_AC, xyr_DOD,                     &
   689:                 & xyra_Trans                         &
   690:                 & )
   691:             
   692:                 use constants , only : &
   693:                   & Grav
   694:             
   695:                 integer , intent(in ) :: nras
   696:                 integer , intent(in ) :: nrps
   697:                 real(DP), intent(in ) :: xyr_Press(0:imax-1, 1:jmax, 0:kmax)
   698:                 real(DP), intent(in ) :: xyza_VMR (0:imax-1, 1:jmax, 1:kmax, 1:nras+nrps)
   699:                 real(DP), intent(in ) :: xyz_MMMass(0:imax-1, 1:jmax, 1:kmax)
   700:                 real(DP), intent(in ) :: xyza_AC(0:imax-1, 1:jmax, 1:kmax, 1:nras)
   701:                 real(DP), intent(in ) :: xyr_DOD(0:imax-1, 1:jmax, 0:kmax)
   702:                 real(DP), intent(out) :: xyra_Trans  (0:imax-1, 1:jmax, 0:kmax, 0:kmax)
   703:             
   704:             
   705:                 !
   706:                 ! local variables
   707:                 !
   708:                 real(DP)     :: xyz_DelOpDep(0:imax-1, 1:jmax, 1:kmax)
   709:                 real(DP)     :: xyz_DelTrans(0:imax-1, 1:jmax, 1:kmax)
   710:                 real(DP)     :: xy_Trans(0:imax-1, 1:jmax)
   711:                 real(DP), parameter :: DifFac = 1.66_DP
   712:             
   713:             
   714:                 integer :: k, k2, n
   715:                 integer :: ks, ke
   716:             
   717:             
   718:             
   719: W***=== A       xyra_Trans = 1.0d100
   720:             
   721:             
   722: W**====         xyz_DelOpDep = 0.0_DP
   723: +------>        do n = 1, nras
   724: |W----->          do k = 1, kmax
   725: ||**=== A           xyz_DelOpDep(:,:,k) = xyz_DelOpDep(:,:,k)                      &
   726: ||                    & + xyza_AC(:,:,k,n) * xyza_VMR(:,:,k,n) / xyz_MMMass(:,:,k) &
   727: ||                    & * ( xyr_Press(:,:,k-1) - xyr_Press(:,:,k) ) / Grav
   728: |W-----           end do
   729: +------         end do
   730:             
   731:                 !
   732:                 ! add dust optical depth
   733:                 !
   734: W------>        do k = 1, kmax
   735: |**==== A         xyz_DelOpDep(:,:,k) = xyz_DelOpDep(:,:,k) &
   736: |                   & + xyr_DOD(:,:,k-1) - xyr_DOD(:,:,k)
   737: W------         end do
   738:             
   739: W**==== A       xyz_DelTrans = exp( - xyz_DelOpDep * DifFac )
   740:             
   741:             
   742:                 !
   743:                 ! transmission for "zero thickness" layer ( = 1.0 )
   744:                 !
   745: +------>        do ks = 0, kmax
   746: |                 ke = ks
   747: |W*==== A         xyra_Trans(:,:,ks,ke) = 1.0_DP
   748: +------         end do
   749:             
   750: +------>        do ks = 0, kmax
   751: |W*==== A         xy_Trans = 1.0_DP
   752: |+----->          do ke = ks+1, kmax
   753: ||*W--->A           xy_Trans = xy_Trans * xyz_DelTrans(:,:,ke)
   754: ||*W--- A           xyra_Trans(:,:,ks,ke) = xy_Trans
   755: |+-----           end do
   756: +------         end do
   757:             
   758: +------>        do ks = 0, kmax
   759: |+----->          do ke = 0, ks-1
   760: ||W*=== A           xyra_Trans(:,:,ks,ke) = xyra_Trans(:,:,ke,ks)
   761: |+-----           end do
   762: +------         end do
   763:             
   764:             
   765:               end subroutine calc_trans_mp_arr3d
   766:             
   767:               !--------------------------------------------------------------------------------------
   768:             
   769:               subroutine calc_rteq_use_meantrans_arr3d( &
   770:                 & dlambda, xy_SurfEmis, &
   771:                 & trans_i2i_toa, trans_i2i_boa, trans_i2i_s, &
   772:                 & trans_i2m_lli, trans_i2m_uli, &
   773:                 & xyr_PF, xy_SurfPF, netflh &
   774:                 & )
   775:             
   776:                 ! 物理・数学定数設定
   777:                 ! Physical and mathematical constants settings
   778:                 !
   779:                 use constants0, only: &
   780:                   & PI                    ! $ \pi $ .
   781:                                           ! 円周率.  Circular constant
   782:             
   783:                 real(DP), intent(in ) :: dlambda
   784:                 real(DP), intent(in ) :: xy_SurfEmis(0:imax-1, 1:jmax)
   785:                 real(DP), intent(in ) :: trans_i2i_toa(0:imax-1, 1:jmax, 0:kmax)    ! f_{1/2}    T_{k+1/2,1/2}
   786:                 real(DP), intent(in ) :: trans_i2i_boa(0:imax-1, 1:jmax, 0:kmax)    ! f_{km+1/2} T_{k+1/2,km+1/2}
   787:                 real(DP), intent(in ) :: trans_i2i_s  (0:imax-1, 1:jmax, 0:kmax)    ! f_{s}      T_{k+1/2,km+1/2}
   788:                 real(DP), intent(in ) :: trans_i2m_lli(0:imax-1, 1:jmax, 0:kmax, 1:kmax) ! upper layer interface
   789:                 real(DP), intent(in ) :: trans_i2m_uli(0:imax-1, 1:jmax, 0:kmax, 1:kmax) ! lower layer interface
   790:                 real(DP), intent(in ) :: xyr_PF   (0:imax-1, 1:jmax, 0:kmax)
   791:                 real(DP), intent(in ) :: xy_SurfPF(0:imax-1, 1:jmax)
   792:                 real(DP), intent(out) :: netflh(0:imax-1, 1:jmax, 0:kmax)
   793:             
   794:             
   795:             
   796:                 !
   797:                 ! local variables
   798:                 !
   799:                 integer :: i, j, k, k2
   800:             
   801:             
   802: W------>        do k = 0, kmax
   803: |*----->          do j = 1, jmax
   804: ||*---->            do i = 0, imax-1
   805: |||     A             netflh(i,j,k) = 0.0d0
   806: ||*----             end do
   807: |*-----           end do
   808: W------         end do
   809:             
   810: +------>        do k = 0, kmax
   811: |           
   812: |W----->          do j = 1, jmax
   813: ||*---->            do i = 0, imax-1
   814: |||     A             netflh(i,j,k) = netflh(i,j,k) &
   815: |||                     & + PI * xy_SurfEmis(i,j) * xy_SurfPF(i,j) * dlambda * trans_i2i_s  (i,j,k) &
   816: |||                     & - PI * xyr_PF(i,j,0   ) * dlambda * trans_i2i_boa(i,j,k) &
   817: |||                     & + PI * xyr_PF(i,j,kmax) * dlambda * trans_i2i_toa(i,j,k)
   818: ||*----             end do
   819: |W-----           end do
   820: |           
   821: |+----->          do k2 = 1, kmax
   822: ||W---->            do j = 1, jmax
   823: |||*--->              do i = 0, imax-1
   824: ||||    A               netflh(i,j,k) = netflh(i,j,k) &
   825: ||||                      & - PI * xyr_PF(i,j,k2  ) * dlambda * trans_i2m_uli(i,j,k,k2) &
   826: ||||                      & + PI * xyr_PF(i,j,k2-1) * dlambda * trans_i2m_lli(i,j,k,k2)
   827: |||*---               end do
   828: ||W----             end do
   829: |+-----           end do
   830: |           
   831: +------         end do
   832:             
   833:             
   834:               end subroutine calc_rteq_use_meantrans_arr3d
   835:             
   836:               !**************************************************************************
   837:             
   838:               subroutine calc_lnp( xyz_Press, xyz_lnPress )
   839:             
   840:                 real(DP), intent(in ) :: xyz_Press  (0:imax-1, 1:jmax, 1:kmax)
   841:                 real(DP), intent(out) :: xyz_lnPress(0:imax-1, 1:jmax, 1:kmax)
   842:             
   843:             
   844:                 !
   845:                 ! local variables
   846:                 !
   847:             
   848:             
   849: W**==== A       xyz_lnPress = log( xyz_Press + 1.0d-20 )
   850:             
   851:             
   852:               end subroutine calc_lnp
   853:             
   854:               !**************************************************************************
   855:             
   856:             !!$  subroutine rad15m_2006_rv_read_calctrans( &
   857:             !!$    & gt, gph, gp, gts, &
   858:             !!$    & gdod, &
   859:             !!$    & ijs, ije )
   860:             !!$
   861:             !!$
   862:             !!$    use mars_const, only : vmr_co2, amu
   863:             !!$
   864:             !!$
   865:             !!$    use ckd_module
   866:             !!$
   867:             !!$
   868:             !!$    real(DP), intent(in ) :: gph( im, jm, km+1 ), gp ( im, jm, km )
   869:             !!$    real(DP), intent(in ) :: gt( im, jm, km ), gts( im, jm )
   870:             !!$    real(DP), intent(in ) :: gdod( im, jm, km+1 )
   871:             !!$    integer , intent(in ) :: ijs, ije
   872:             !!$
   873:             !!$
   874:             !!$    !
   875:             !!$    ! local variables
   876:             !!$    !
   877:             !!$    real(DP)                  :: gth( im, jm, km+1 )
   878:             !!$    real(DP)                  :: &
   879:             !!$      & mmmassh( im, jm, km+1 ), gvmrh( im, jm, km+1, nras+nrps )
   880:             !!$    real(DP) :: ach  ( im, jm, km+1, nras )
   881:             !!$    real(DP) :: pfh  ( im, jm, km+1 ), pfs  ( im, jm )
   882:             !!$    real(DP) :: uwflh( im, jm, km+1 ), dwflh( im, jm, km+1 )
   883:             !!$
   884:             !!$    real(DP) :: uwflh_sum( im, jm, km+1 ), dwflh_sum( im, jm, km+1 )
   885:             !!$
   886:             !!$    real(DP) :: pfs_for_gradcalc( im, jm )
   887:             !!$    real(DP) :: uwflh_sum_for_gradcalc( im, jm, km+1 ), dwflh_sum_for_gradcalc( im, jm, km+1 )
   888:             !!$
   889:             !!$    real(DP)                  :: weight_integral
   890:             !!$    integer              :: ig, iband
   891:             !!$
   892:             !!$    integer              :: ij, k, l, m, n
   893:             !!$    integer              :: k2
   894:             !!$
   895:             !!$    real(DP) :: minp, maxp
   896:             !!$
   897:             !!$    integer :: iband_reserve
   898:             !!$    real(DP)     :: glnph  ( im, jm, km+1     )
   899:             !!$    real(DP)     :: glnph_f( im, jm, km*nvr+1 )
   900:             !!$    real(DP)     :: gts3d1 ( im, jm, 1        )
   901:             !!$    integer :: &
   902:             !!$      & jjh   ( im, jm, km+1     ), kkh   ( im, jm, km+1     ), &
   903:             !!$      & jjh_f ( im, jm, km*nvr+1 ), kkh_f ( im, jm, km*nvr+1 ), &
   904:             !!$      & jjs3d1( im, jm, 1        ), kks3d1( im, jm, 1        ), &
   905:             !!$      & jjs   ( im, jm )          , kks   ( im, jm )
   906:             !!$
   907:             !!$
   908:             !!$    ! Surface temperature for calculation of gradient of radiative flux
   909:             !!$    real(DP) :: gts_for_gradcalc( im, jm )
   910:             !!$    ! Indices for calculation of gradient of radiative flux
   911:             !!$    integer  :: jjs_for_gradcalc( im, jm ), kks_for_gradcalc( im, jm )
   912:             !!$
   913:             !!$
   914:             !!$    real(DP)     :: glnps3d1( im, jm, 1 )
   915:             !!$
   916:             !!$    real(DP)     :: pfrh_f( im, jm, km*nvr+1 )
   917:             !!$    real(DP)     :: pfr3d1( im, jm, 1        )
   918:             !!$
   919:             !!$
   920:             !!$    k = 1
   921:             !!$    do ij = ijs, ije
   922:             !!$      gth( ij, 1, k ) = gt( ij, 1, k )
   923:             !!$    end do
   924:             !!$    do k = 1+1, km+1-1
   925:             !!$      do ij = ijs, ije
   926:             !!$        gth( ij, 1, k ) &
   927:             !!$          = ( gt( ij, 1, k ) - gt( ij, 1, k-1 ) ) &
   928:             !!$          / log( gp( ij, 1, k ) / gp( ij, 1, k-1 ) ) &
   929:             !!$          * log( gph( ij, 1, k ) / gp( ij, 1, k-1 ) ) &
   930:             !!$          + gt( ij, 1, k-1 )
   931:             !!$      end do
   932:             !!$    end do
   933:             !!$    k = km+1
   934:             !!$    do ij = ijs, ije
   935:             !!$      gth( ij, 1, k ) &
   936:             !!$        = ( gt( ij, 1, km ) - gt( ij, 1, km-1 ) ) &
   937:             !!$        / log( gp( ij, 1, km ) / gp( ij, 1, km-1 ) ) &
   938:             !!$        * log( gph( ij, 1, km+1 ) / gp( ij, 1, km-1 ) ) &
   939:             !!$        + gt( ij, 1, km-1 )
   940:             !!$    end do
   941:             !!$
   942:             !!$
   943:             !!$    do k = 1, km*nvr+1
   944:             !!$      do ij = ijs, ije
   945:             !!$        gph_f( ij, 1, k ) = sgmh_f( k ) * gph( ij, 1, km+1 )
   946:             !!$      end do
   947:             !!$    end do
   948:             !!$    call calc_lnp( im, jm, km*nvr+1, gph_f , glnph_f , ijs, ije )
   949:             !!$
   950:             !!$    call increase_vreso_boundary_arr3d( im, jm, km, nvr, gth, gth_f, &
   951:             !!$      & "linear", ijs, ije )
   952:             !!$
   953:             !!$
   954:             !!$
   955:             !!$    !
   956:             !!$    ! Set interval for radiation/transmission calculation
   957:             !!$    !
   958:             !!$!      radint = hourm * mins
   959:             !!$
   960:             !!$
   961:             !!$    !
   962:             !!$    ! Calculation of transmission
   963:             !!$    !
   964:             !!$!      if( ( ( time - dble( int( time / rad15mint )  ) * rad15mint ) .lt. dt ) &
   965:             !!$!        .or. ( rad_gtsbase( ijs, 1, 1 ) .gt. 1.0d99 ) ) then
   966:             !!$!
   967:             !!$!
   968:             !!$!         write( 6, * ) '########## rad15m in if'
   969:             !!$
   970:             !!$
   971:             !!$    !
   972:             !!$    ! Calculation of "absorption" dust optical depth
   973:             !!$    ! This formulation is obtained from Forget et al. [1999].
   974:             !!$    !
   975:             !!$!         do k = 1, km+1
   976:             !!$!            do ij = ijs, ije
   977:             !!$!               gdod( ij, 1, k ) = ( 1.0d0 - ssa ) * dod067( ij, 1, k ) * qerat
   978:             !!$!            end do
   979:             !!$!         end do
   980:             !!$
   981:             !!$    call increase_vreso_boundary_arr3d( im, jm, km, nvr, gdod, gdod_f, &
   982:             !!$      & "log", ijs, ije )
   983:             !!$
   984:             !!$
   985:             !!$    !
   986:             !!$    ! check pressure
   987:             !!$    !
   988:             !!$    minp = 1.0d100
   989:             !!$    maxp = 0.0d0
   990:             !!$    do ij = ijs, ije
   991:             !!$      minp = min( minp, gp( ij, 1, 2  ) )
   992:             !!$      maxp = max( maxp, gp( ij, 1, km ) )
   993:             !!$    end do
   994:             !!$    if( ckdp(1)%lnp(1) .gt. log(minp) ) then
   995:             !!$      write( 6, * ) 'MARS: pressure is too small.'
   996:             !!$      write( 6, * ) minp, exp(ckdp(1)%lnp(1))
   997:             !!$      stop
   998:             !!$    end if
   999:             !!$    if( ckdp(1)%lnp(ckdp(1)%nlnp) .lt. log(maxp) ) then
  1000:             !!$      write( 6, * ) 'MARS: pressure is too large.'
  1001:             !!$      write( 6, * ) maxp, exp(ckdp(1)%lnp(ckdp(1)%nlnp))
  1002:             !!$      stop
  1003:             !!$    end if
  1004:             !!$
  1005:             !!$
  1006:             !!$    do k = 1, km+1
  1007:             !!$      do ij = ijs, ije
  1008:             !!$        mmmassh( ij, 1, k ) = 43.5d0 * amu
  1009:             !!$      end do
  1010:             !!$    end do
  1011:             !!$    do n = 1, nras + nrps
  1012:             !!$      do k = 1, km+1
  1013:             !!$        do ij = ijs, ije
  1014:             !!$          gvmrh( ij, 1, k, n ) = vmr_co2
  1015:             !!$        end do
  1016:             !!$      end do
  1017:             !!$    end do
  1018:             !!$
  1019:             !!$
  1020:             !!$!    do n = 1, nras + nrps
  1021:             !!$!      call increase_vreso_b2m_arr3d( im, jm, km, nvr, &
  1022:             !!$!        gvmrh(:,:,:,n), gvmr_f(:,:,:,n), "log", &
  1023:             !!$!        ijs, ije )
  1024:             !!$!    end do
  1025:             !!$!    call increase_vreso_b2m_arr3d( im, jm, km, nvr, &
  1026:             !!$!      mmmassh, mmmass_f, "linear", &
  1027:             !!$!      ijs, ije )
  1028:             !!$
  1029:             !!$!    call calc_lnp( im, jm, km+1    , gph   , glnph   , ijs, ije )
  1030:             !!$    call calc_lnph( gph, glnph )
  1031:             !!$
  1032:             !!$
  1033:             !!$    !
  1034:             !!$    ! initialization
  1035:             !!$    !
  1036:             !!$    do k = 0, kmax
  1037:             !!$      do j = 1, jmax
  1038:             !!$        do i = 0, imax-1
  1039:             !!$          trans_i2i_toa(i,j,k) = 0.0d0         ! f_{1/2}    T_{k+1/2,1/2}
  1040:             !!$          trans_i2i_boa(i,j,k) = 0.0d0         ! f_{km+1/2} T_{k+1/2,km+1/2}
  1041:             !!$          trans_i2i_s  (i,j,k) = 0.0d0         ! f_{s}      T_{k+1/2,km+1/2}
  1042:             !!$        end do
  1043:             !!$      end do
  1044:             !!$    end do
  1045:             !!$    do k2 = 1, kmax
  1046:             !!$      do k = 0, kmax
  1047:             !!$        do j = 1, jmax
  1048:             !!$          do i = 0, imax-1
  1049:             !!$            trans_i2m_uli_f(i,j,k,k2) = 0.0d0
  1050:             !!$            trans_i2m_lli_f(i,j,k,k2) = 0.0d0
  1051:             !!$          end do
  1052:             !!$        end do
  1053:             !!$      end do
  1054:             !!$    end do
  1055:             !!$
  1056:             !!$
  1057:             !!$    !
  1058:             !!$    ! loop for wavenumber
  1059:             !!$    !
  1060:             !!$
  1061:             !!$    iband_reserve = 0
  1062:             !!$
  1063:             !!$    do m = 1, nwnl
  1064:             !!$
  1065:             !!$      call m2ckdpindices( m, ig, iband )
  1066:             !!$
  1067:             !!$
  1068:             !!$      if( iband .ne. iband_reserve ) then
  1069:             !!$        call findindices( im, jm, km+1, gth, glnph, iband, &
  1070:             !!$          jjh, kkh, ijs, ije )
  1071:             !!$
  1072:             !!$
  1073:             !!$        call findindices( im, jm, km*nvr+1, &
  1074:             !!$          gth_f , glnph_f , &
  1075:             !!$          iband, jjh_f , kkh_f , ijs, ije )
  1076:             !!$        do ij = ijs, ije
  1077:             !!$          gts3d1( ij, 1, 1 ) = gts( ij, 1 )
  1078:             !!$        end do
  1079:             !!$        call findindices( im, jm, 1       , &
  1080:             !!$          gts3d1, glnph_f(:,:,km*nvr+1), &
  1081:             !!$          iband, jjs3d1, kks3d1, ijs, ije )
  1082:             !!$        do ij = ijs, ije
  1083:             !!$          jjs( ij, 1 ) = jjs3d1( ij, 1, 1 )
  1084:             !!$          kks( ij, 1 ) = kks3d1( ij, 1, 1 )
  1085:             !!$        end do
  1086:             !!$
  1087:             !!$
  1088:             !!$        iband_reserve = iband
  1089:             !!$      end if
  1090:             !!$
  1091:             !!$
  1092:             !!$      do n = 1, nras
  1093:             !!$        call getlnac_givenindices( im, jm, km+1, gth, glnph, jjh, kkh, &
  1094:             !!$          & ach(:,:,:,n), ig, iband, ijs, ije )
  1095:             !!$      end do
  1096:             !!$      do n = 1, nras
  1097:             !!$        do k = 1, km+1
  1098:             !!$          do ij = ijs, ije
  1099:             !!$            ach( ij, 1, k, n ) = exp( ach( ij, 1, k, n ) )
  1100:             !!$          end do
  1101:             !!$        end do
  1102:             !!$      end do
  1103:             !!$
  1104:             !!$      do n = 1, nras
  1105:             !!$        call increase_vreso_b2m_arr3d( im, jm, km, nvr, &
  1106:             !!$          ach(:,:,:,n), ac_f(:,:,:,n), "log", &
  1107:             !!$          ijs, ije )
  1108:             !!$      end do
  1109:             !!$
  1110:             !!$
  1111:             !!$      call calc_trans_mp_arr3d( nras, nrps, im, jm, km*nvr, &
  1112:             !!$        gph_f, gvmr_f, mmmass_f, &
  1113:             !!$        ac_f, gdod_f, trans_f, ijs, ije )
  1114:             !!$
  1115:             !!$
  1116:             !!$      do ij = ijs, ije
  1117:             !!$        gts3d1  ( ij, 1, 1 ) = gts    ( ij, 1 )
  1118:             !!$        glnps3d1( ij, 1, 1 ) = glnph_f( ij, 1, km*nvr+1 )
  1119:             !!$        jjs3d1  ( ij, 1, 1 ) = jjs    ( ij, 1 )
  1120:             !!$        kks3d1  ( ij, 1, 1 ) = kks    ( ij, 1 )
  1121:             !!$      end do
  1122:             !!$
  1123:             !!$      call getpfr_givenindices( im, jm, km*nvr+1, gth_f , glnph_f , jjh_f , kkh_f , pfrh_f, ig, iband, ijs, ije )
  1124:             !!$      call getpfr_givenindices( im, jm, 1       , gts3d1, glnps3d1, jjs3d1, kks3d1, pfr3d1, ig, iband, ijs, ije )
  1125:             !!$
  1126:             !!$
  1127:             !!$      do k = 1, km*nvr+1
  1128:             !!$        do ij = ijs, ije
  1129:             !!$          trans_i2i_toa_f(ij,1,k) = &        ! f_{1/2}    T_{k+1/2,1/2}
  1130:             !!$            & trans_i2i_toa_f(ij,1,k) &
  1131:             !!$            & + trans_f(ij,1,k,1   ) &
  1132:             !!$            & * pfrh_f(ij,1,1  ) &
  1133:             !!$            & * ckdp(iband)%weight(ig)
  1134:             !!$          trans_i2i_boa_f(ij,1,k) = &        ! f_{km+1/2} T_{k+1/2,km+1/2}
  1135:             !!$            & trans_i2i_boa_f(ij,1,k) &
  1136:             !!$            & + trans_f(ij,1,k,km+1) &
  1137:             !!$            & * pfrh_f(ij,1,km+1) &
  1138:             !!$            & * ckdp(iband)%weight(ig)
  1139:             !!$          trans_i2i_s_f  (ij,1,k) = &        ! f_{s}      T_{k+1/2,km+1/2}
  1140:             !!$            & trans_i2i_s_f  (ij,1,k) &
  1141:             !!$            & + trans_f(ij,1,k,km+1) &
  1142:             !!$            & * pfr3d1(ij,1,1) &
  1143:             !!$            & * ckdp(iband)%weight(ig)
  1144:             !!$        end do
  1145:             !!$      end do
  1146:             !!$
  1147:             !!$      do k2 = 1, km*nvr
  1148:             !!$        do k = 1, km*nvr+1
  1149:             !!$          do ij = ijs, ije
  1150:             !!$            trans_i2m_uli_f(ij,1,k,k2) = &
  1151:             !!$              & trans_i2m_uli_f(ij,1,k,k2) &
  1152:             !!$              & + ( trans_f(ij,1,k,k2) + trans_f(ij,1,k,k2+1) ) * 0.5d0 &
  1153:             !!$              & * pfrh_f(ij,1,k2  ) &
  1154:             !!$              & * ckdp(iband)%weight(ig)
  1155:             !!$            trans_i2m_lli_f(ij,1,k,k2) = &
  1156:             !!$              & trans_i2m_lli_f(ij,1,k,k2) &
  1157:             !!$              & + ( trans_f(ij,1,k,k2) + trans_f(ij,1,k,k2+1) ) * 0.5d0 &
  1158:             !!$              & * pfrh_f(ij,1,k2+1) &
  1159:             !!$              & * ckdp(iband)%weight(ig)
  1160:             !!$          end do
  1161:             !!$        end do
  1162:             !!$      end do
  1163:             !!$
  1164:             !!$
  1165:             !!$
  1166:             !!$    end do
  1167:             !!$
  1168:             !!$
  1169:             !!$
  1170:             !!$
  1171:             !!$
  1172:             !!$!      end if
  1173:             !!$
  1174:             !!$
  1175:             !!$  end subroutine rad15m_2006_rv_read_calctrans
  1176:             
  1177:               !**************************************************************************
  1178:             
  1179:             !!$  subroutine rad15m_readnlte15mfac( fn )
  1180:             !!$
  1181:             !!$
  1182:             !!$    interface
  1183:             !!$      subroutine findfu( fn, ios, fu, mode )
  1184:             !!$        use matype
  1185:             !!$        implicit none
  1186:             !!$        character(len=*), intent(in )           :: fn
  1187:             !!$        integer    , intent(out)           :: ios, fu
  1188:             !!$        character(len=*), intent(in ), optional :: mode
  1189:             !!$      end subroutine findfu
  1190:             !!$    end interface
  1191:             !!$
  1192:             !!$
  1193:             !!$    character(len=*), intent(in) :: fn
  1194:             !!$
  1195:             !!$
  1196:             !!$    !
  1197:             !!$    ! local variables
  1198:             !!$    !
  1199:             !!$    character(len=128) :: tmpl
  1200:             !!$    integer       :: ios, fu
  1201:             !!$    integer       :: i
  1202:             !!$
  1203:             !!$
  1204:             !!$    call findfu( fn, ios, fu )
  1205:             !!$    if( ios /= 0 ) then
  1206:             !!$      write( 6, * ) 'STOP in parse_ctl: ', ios
  1207:             !!$      stop
  1208:             !!$    endif
  1209:             !!$    open( fu, file = fn, status='unknown' )
  1210:             !!$    read( fu, '(a)' ) tmpl
  1211:             !!$    do i = 1, nl15fn
  1212:             !!$      read( fu, * ) nl15sn( i ), nl15fa( i )
  1213:             !!$    enddo
  1214:             !!$    close( fu )
  1215:             !!$
  1216:             !!$
  1217:             !!$  end subroutine rad15m_readnlte15mfac
  1218:             
  1219:               !**************************************************************************
  1220:             
  1221:               !--------------------------------------------------------------------------------------
  1222:             
  1223:               subroutine m2ckdpindices( m, ig, iband )
  1224:             
  1225:                 use ckd_module, only : ckdp, nband
  1226:             
  1227:                 integer, intent(in ) :: m
  1228:                 integer, intent(out) :: ig
  1229:                 integer, intent(out) :: iband
  1230:             
  1231:             
  1232:                 !
  1233:                 ! local variables
  1234:                 !
  1235:                 integer :: num
  1236:             
  1237:             
  1238:                 ! The comments below will be removed.
  1239:             
  1240:             
  1241:                 num = 0
  1242: +------>        do iband = 1, nband
  1243: |                 if( num + ckdp( iband ) % ng .ge. m ) exit
  1244: |                 num = num + ckdp( iband ) % ng
  1245: +------         end do
  1246:                 if( iband > nband ) then
  1247:                   write( 6, * ) 'Unexpected m'
  1248:                   write( 6, * ) m
  1249:                   stop
  1250:                 end if
  1251:                 ig = m - num
  1252:                 if( ig > ckdp( iband ) % ng ) then
  1253:                   write( 6, * ) 'Unexpected ig'
  1254:                   write( 6, * ) iband, ig
  1255:                   stop
  1256:                 end if
  1257:             
  1258:             
  1259:               end subroutine m2ckdpindices
  1260:             
  1261:               !--------------------------------------------------------------------------------------
  1262:             
  1263:               subroutine getlnac_givenindices( &
  1264:                 & xyz_Temp, xyz_lnPress, xyz_jj, xyz_kk, ig, iband, &
  1265:                 & xyz_AC &
  1266:                 & )
  1267:             
  1268:                 use ckd_module, only : ckdp
  1269:             
  1270:                 real(DP), intent(in ) :: xyz_Temp   (0:imax-1, 1:jmax, 1:kmax)
  1271:                 real(DP), intent(in ) :: xyz_lnPress(0:imax-1, 1:jmax, 1:kmax)
  1272:                 integer , intent(in ) :: xyz_jj  (0:imax-1, 1:jmax, 1:kmax)
  1273:                 integer , intent(in ) :: xyz_kk  (0:imax-1, 1:jmax, 1:kmax)
  1274:                 integer , intent(in ) :: ig
  1275:                 integer , intent(in ) :: iband
  1276:                 real(DP), intent(out) :: xyz_AC  (0:imax-1, 1:jmax, 1:kmax)
  1277:             
  1278:             
  1279:                 !
  1280:                 ! local variables
  1281:                 !
  1282:                 real(DP) :: lnac1, lnac2
  1283:                 integer  :: i, j, k
  1284:             
  1285:             
  1286: W------>        do k = 1, kmax
  1287: |*----->          do j = 1, jmax
  1288: ||*---->            do i = 0, imax-1
  1289: |||         
  1290: |||     A             lnac1 &
  1291: |||                     & = ( ckdp(iband)%lnac( ig, xyz_jj(i,j,k)  , xyz_kk(i,j,k)+1 )      &
  1292: |||                     &   - ckdp(iband)%lnac( ig, xyz_jj(i,j,k)  , xyz_kk(i,j,k)   ) )    &
  1293: |||                     &  / ( ckdp(iband)%t( xyz_kk(i,j,k)+1 )                          &
  1294: |||                     &    - ckdp(iband)%t( xyz_kk(i,j,k)   ) )                        &
  1295: |||                     & * ( xyz_Temp(i,j,k) - ckdp( iband ) % t( xyz_kk(i,j,k) ) )          &
  1296: |||                     & + ckdp(iband)%lnac( ig, xyz_jj(i,j,k)  , xyz_kk(i,j,k)   )
  1297: |||     A             lnac2 &
  1298: |||                     & = ( ckdp(iband)%lnac( ig, xyz_jj(i,j,k)+1, xyz_kk(i,j,k)+1 )      &
  1299: |||                     &   - ckdp(iband)%lnac( ig, xyz_jj(i,j,k)+1, xyz_kk(i,j,k)   ) )    &
  1300: |||                     &  / ( ckdp(iband)%t( xyz_kk(i,j,k)+1 )                          &
  1301: |||                     &    - ckdp(iband)%t( xyz_kk(i,j,k)   ) )                        &
  1302: |||                     & * ( xyz_Temp(i,j,k) - ckdp( iband ) % t( xyz_kk(i,j,k) ) )          &
  1303: |||                     & + ckdp(iband)%lnac( ig, xyz_jj(i,j,k)+1, xyz_kk(i,j,k)   )
  1304: |||         
  1305: |||     A             xyz_AC(i,j,k) &
  1306: |||                     & = ( lnac2 - lnac1 ) &
  1307: |||                     & / ( ckdp( iband ) % lnp( xyz_jj(i,j,k)+1 ) &
  1308: |||                     & - ckdp( iband ) % lnp( xyz_jj(i,j,k)   ) ) &
  1309: |||                     & * ( xyz_lnPress(i,j,k) - ckdp( iband ) % lnp( xyz_jj(i,j,k) ) ) &
  1310: |||                     & + lnac1
  1311: ||*----             end do
  1312: |*-----           end do
  1313: W------         end do
  1314:             
  1315:             
  1316:               end subroutine getlnac_givenindices
  1317:             
  1318:               !--------------------------------------------------------------------------------------
  1319:             !!$
  1320:             !!$  subroutine calc_lnph( gph, glnph )
  1321:             !!$
  1322:             !!$    real(DP), intent(in ) :: gph  (0:imax-1, 1:jmax, 1:kmax)
  1323:             !!$    real(DP), intent(out) :: glnph(0:imax-1, 1:jmax, 0:kmax)
  1324:             !!$
  1325:             !!$
  1326:             !!$    !
  1327:             !!$    ! local variables
  1328:             !!$    !
  1329:             !!$    integer :: i, j, k
  1330:             !!$
  1331:             !!$
  1332:             !!$    do k = 0, kmax
  1333:             !!$      do j = 1, jmax
  1334:             !!$        do i = 0, imax-1
  1335:             !!$          glnph(i,j,k) = log( gph(i,j,k) + 1.0d-20 )
  1336:             !!$        end do
  1337:             !!$      end do
  1338:             !!$    end do
  1339:             !!$
  1340:             !!$
  1341:             !!$  end subroutine calc_lnph
  1342:             !!$
  1343:               !--------------------------------------------------------------------------------------
  1344:             
  1345:               subroutine findindices( &
  1346:                 & ks, ke, xyz_Temp, xyz_lnPress, iband, &
  1347:                 & xyz_jj, xyz_kk &
  1348:                 & )
  1349:             
  1350:                 use ckd_module, only : ckdp
  1351:             
  1352:                 integer , intent(in ) :: ks
  1353:                 integer , intent(in ) :: ke
  1354:                 real(DP), intent(in ) :: xyz_Temp   (0:imax-1, 1:jmax, ks:ke)
  1355:                 real(DP), intent(in ) :: xyz_lnPress(0:imax-1, 1:jmax, ks:ke)
  1356:                 integer , intent(in ) :: iband
  1357:                 integer , intent(out) :: xyz_jj(0:imax-1, 1:jmax, ks:ke)
  1358:                 integer , intent(out) :: xyz_kk(0:imax-1, 1:jmax, ks:ke)
  1359:             
  1360:             
  1361:                 !
  1362:                 ! local variables
  1363:                 !
  1364:                 integer :: i, j, k, l
  1365:             
  1366:             
  1367: W------>        do k = ks, ke
  1368: |*----->          do j = 1, jmax
  1369: ||*---->            do i = 0, imax-1
  1370: |||     A             xyz_kk(i,j,k) = 1
  1371: ||*----             end do
  1372: |*-----           end do
  1373: W------         end do
  1374:             
  1375: +------>        do l = 1+1, ckdp( iband ) % nt - 1
  1376: |W----->          do k = ks, ke
  1377: ||*---->            do j = 1, jmax
  1378: |||*--->              do i = 0, imax-1
  1379: ||||    A               if( ckdp( iband ) % t( l ) .le. xyz_Temp(i,j,k) ) xyz_kk(i,j,k) = l
  1380: |||*---               end do
  1381: ||*----             end do
  1382: |W-----           end do
  1383: +------         end do
  1384:             
  1385: W------>        do k = ks, ke
  1386: |*----->          do j = 1, jmax
  1387: ||*---->            do i = 0, imax-1
  1388: |||     A             xyz_jj(i,j,k) = 1
  1389: ||*----             end do
  1390: |*-----           end do
  1391: W------         end do
  1392: +------>        do l = 1+1, ckdp( iband ) % nlnp - 1
  1393: |W----->          do k = ks, ke
  1394: ||*---->            do j = 1, jmax
  1395: |||*--->              do i = 0, imax-1
  1396: ||||    A               if( ckdp( iband ) % lnp( l ) <= xyz_lnPress(i,j,k) ) xyz_jj(i,j,k) = l
  1397: |||*---               end do
  1398: ||*----             end do
  1399: |W-----           end do
  1400: +------         end do
  1401:             
  1402:             
  1403:               end subroutine findindices
  1404:             
  1405:               !--------------------------------------------------------------------------------------
  1406:             
  1407:               subroutine findindices3D( &
  1408:                 & xyz_Temp, xyz_lnPress, iband, &
  1409:                 & xyz_jj, xyz_kk &
  1410:                 & )
  1411:             
  1412:                 real(DP), intent(in ) :: xyz_Temp   (0:imax-1, 1:jmax, 1:kmax)
  1413:                 real(DP), intent(in ) :: xyz_lnPress(0:imax-1, 1:jmax, 1:kmax)
  1414:                 integer , intent(in ) :: iband
  1415:                 integer , intent(out) :: xyz_jj(0:imax-1, 1:jmax, 1:kmax)
  1416:                 integer , intent(out) :: xyz_kk(0:imax-1, 1:jmax, 1:kmax)
  1417:             
  1418:             
  1419:                 !
  1420:                 ! local variables
  1421:                 !
  1422:             
  1423:             
  1424:                 call findindices(             &
  1425:                   & 1, kmax, xyz_Temp, xyz_lnPress, iband, &
  1426:                   & xyz_jj, xyz_kk                    &
  1427:                   & )
  1428:             
  1429:             
  1430:               end subroutine findindices3D
  1431:             
  1432:               !--------------------------------------------------------------------------------------
  1433:             
  1434:               subroutine findindices2D( &
  1435:                 & xy_Temp, xy_lnPress, iband, &
  1436:                 & xy_jj, xy_kk &
  1437:                 & )
  1438:             
  1439:                 real(DP), intent(in ) :: xy_Temp   (0:imax-1, 1:jmax)
  1440:                 real(DP), intent(in ) :: xy_lnPress(0:imax-1, 1:jmax)
  1441:                 integer , intent(in ) :: iband
  1442:                 integer , intent(out) :: xy_jj(0:imax-1, 1:jmax)
  1443:                 integer , intent(out) :: xy_kk(0:imax-1, 1:jmax)
  1444:             
  1445:             
  1446:                 !
  1447:                 ! local variables
  1448:                 !
  1449:                 real(DP) :: xyz_Temp   (0:imax-1, 1:jmax, 1:1)
  1450:                 real(DP) :: xyz_lnPress(0:imax-1, 1:jmax, 1:1)
  1451:                 integer  :: xyz_jj(0:imax-1, 1:jmax, 1:1)
  1452:                 integer  :: xyz_kk(0:imax-1, 1:jmax, 1:1)
  1453:             
  1454:             
  1455: *W----->A       xyz_Temp   (:,:,1) = xy_Temp
  1456: *W----- A       xyz_lnPress(:,:,1) = xy_lnPress
  1457:             
  1458:                 call findindices(              &
  1459:                   & 1, 1, xyz_Temp, xyz_lnPress, iband, &
  1460:                   & xyz_jj, xyz_kk                 &
  1461:                   & )
  1462:             
  1463: *W----->A       xy_jj = xyz_jj(:,:,1)
  1464: *W----- A       xy_kk = xyz_kk(:,:,1)
  1465:             
  1466:             
  1467:               end subroutine findindices2D
  1468:             
  1469:               !--------------------------------------------------------------------------------------
  1470:             
  1471:               subroutine getpf_arr3d_norat( &
  1472:                 & xyz_Temp, xy_SurfTemp, iband, &
  1473:                 & xyr_PF, xy_SurfPF &
  1474:                 & )
  1475:             
  1476:                 use planck_func, only : Integ_PF_GQ_Array3D, Integ_PF_GQ_Array2D
  1477:             
  1478:                 use ckd_module, only : ckdp
  1479:             
  1480:                 real(DP), intent(in ) :: xyz_Temp   (0:imax-1, 1:jmax, 0:kmax)
  1481:                 real(DP), intent(in ) :: xy_SurfTemp(0:imax-1, 1:jmax)
  1482:                 integer , intent(in ) :: iband
  1483:                 real(DP), intent(out) :: xyr_PF   (0:imax-1, 1:jmax, 0:kmax)
  1484:                 real(DP), intent(out) :: xy_SurfPF(0:imax-1, 1:jmax)
  1485:             
  1486:             
  1487:                 !
  1488:                 ! local variables
  1489:                 !
  1490:                 integer :: ncp_pfint
  1491:                 integer :: i, j, k
  1492:             
  1493:             
  1494:                 ncp_pfint = 5
  1495:             
  1496:                 call Integ_PF_GQ_Array3D( &
  1497:                   & ckdp(iband)%wnbnds(1), ckdp(iband)%wnbnds(2), ncp_pfint, &
  1498:                   & 0, imax-1, 1, jmax, 0, kmax, &
  1499:                   & xyz_Temp, &
  1500:                   & xyr_PF &
  1501:                   & )
  1502:                 call Integ_PF_GQ_Array2D( &
  1503:                   & ckdp(iband)%wnbnds(1), ckdp(iband)%wnbnds(2), ncp_pfint, &
  1504:                   & 0, imax-1, 1, jmax, &
  1505:                   & xy_SurfTemp, &
  1506:                   & xy_SurfPF &
  1507:                   & )
  1508:             
  1509: W------>        do k = 0, kmax
  1510: |*----->          do j = 1, jmax
  1511: ||*---->            do i = 0, imax-1
  1512: |||     A             xyr_PF(i,j,k) = xyr_PF(i,j,k) / ( ckdp(iband)%wnbnds(2) - ckdp(iband)%wnbnds(1) )
  1513: ||*----             end do
  1514: |*-----           end do
  1515: W------         end do
  1516: W------>        do j = 1, jmax
  1517: |*----->          do i = 0, imax-1
  1518: ||      A           xy_SurfPF(i,j) = xy_SurfPF(i,j) / ( ckdp(iband)%wnbnds(2) - ckdp(iband)%wnbnds(1) )
  1519: |*-----           end do
  1520: W------         end do
  1521:             
  1522:             
  1523:               end subroutine getpf_arr3d_norat
  1524:             
  1525:               !--------------------------------------------------------------------------------------
  1526:             
  1527:               subroutine getpfr_givenindices( &
  1528:                 & ks, ke, &
  1529:                 & xyz_Temp, xyz_lnPress, xyz_jj, xyz_kk, ig, iband, &
  1530:                 & xyz_PFRat &
  1531:                 & )
  1532:             
  1533:                 use ckd_module, only: ckdp
  1534:             
  1535:                 integer , intent(in ) :: ks
  1536:                 integer , intent(in ) :: ke
  1537:                 real(DP), intent(in ) :: xyz_Temp   (0:imax-1, 1:jmax, ks:ke)
  1538:                 real(DP), intent(in ) :: xyz_lnPress(0:imax-1, 1:jmax, ks:ke)
  1539:                 integer , intent(in ) :: xyz_jj  (0:imax-1, 1:jmax, ks:ke)
  1540:                 integer , intent(in ) :: xyz_kk  (0:imax-1, 1:jmax, ks:ke)
  1541:                 integer , intent(in ) :: ig, iband
  1542:                 real(DP), intent(out) :: xyz_PFRat(0:imax-1, 1:jmax, ks:ke)
  1543:             
  1544:             
  1545:                 !
  1546:                 ! local variables
  1547:                 !
  1548:                 real(DP) :: pfr1, pfr2
  1549:                 integer  :: i, j, k, l
  1550:             
  1551:             
  1552: W------>        do k = ks, ke
  1553: |*----->          do j = 1, jmax
  1554: ||*---->            do i = 0, imax-1
  1555: |||         
  1556: |||     A             pfr1 = &
  1557: |||                     &   ( ckdp(iband)%pfr( ig, xyz_jj(i,j,k)  , xyz_kk(i,j,k)+1 )     &
  1558: |||                     &   - ckdp(iband)%pfr( ig, xyz_jj(i,j,k)  , xyz_kk(i,j,k)   ) )   &
  1559: |||                     & / ( ckdp(iband)%t( xyz_kk(i,j,k)+1 )                         &
  1560: |||                     &   - ckdp(iband)%t( xyz_kk(i,j,k)   ) )                       &
  1561: |||                     & * ( xyz_Temp(i,j,k) - ckdp( iband ) % t( xyz_kk(i,j,k) ) )         &
  1562: |||                     & + ckdp(iband)%pfr( ig, xyz_jj(i,j,k)  , xyz_kk(i,j,k)   )
  1563: |||     A             pfr2 = &
  1564: |||                     &   ( ckdp(iband)%pfr( ig, xyz_jj(i,j,k)+1, xyz_kk(i,j,k)+1 )      &
  1565: |||                     &   - ckdp(iband)%pfr( ig, xyz_jj(i,j,k)+1, xyz_kk(i,j,k)   ) )    &
  1566: |||                     & / ( ckdp(iband)%t( xyz_kk(i,j,k)+1 )                         &
  1567: |||                     &   - ckdp(iband)%t( xyz_kk(i,j,k)   ) )                       &
  1568: |||                     & * ( xyz_Temp(i,j,k) - ckdp( iband ) % t( xyz_kk(i,j,k) ) )         &
  1569: |||                     & + ckdp(iband)%pfr( ig, xyz_jj(i,j,k)+1, xyz_kk(i,j,k)   )
  1570: |||         
  1571: |||         
  1572: |||     A             xyz_PFRat(i,j,k) = &
  1573: |||                     &   ( pfr2 - pfr1 ) &
  1574: |||                     & / ( ckdp( iband ) % lnp( xyz_jj(i,j,k)+1 ) &
  1575: |||                     &   - ckdp( iband ) % lnp( xyz_jj(i,j,k)   ) ) &
  1576: |||                     & * ( xyz_lnPress(i,j,k) - ckdp( iband ) % lnp( xyz_jj(i,j,k) ) ) &
  1577: |||                     & + pfr1
  1578: ||*----             end do
  1579: |*-----           end do
  1580: W------         end do
  1581:             
  1582:             
  1583:               end subroutine getpfr_givenindices
  1584:             
  1585:               !--------------------------------------------------------------------------------------
  1586:             
  1587:               subroutine getpfr_givenindices3D( &
  1588:                 & xyz_Temp, xyz_lnPress, xyz_jj, xyz_kk, ig, iband, &
  1589:                 & xyz_PFRat &
  1590:                 & )
  1591:             
  1592:                 use ckd_module, only: ckdp
  1593:             
  1594:                 real(DP), intent(in ) :: xyz_Temp   (0:imax-1, 1:jmax, 1:kmax)
  1595:                 real(DP), intent(in ) :: xyz_lnPress(0:imax-1, 1:jmax, 1:kmax)
  1596:                 integer , intent(in ) :: xyz_jj  (0:imax-1, 1:jmax, 1:kmax)
  1597:                 integer , intent(in ) :: xyz_kk  (0:imax-1, 1:jmax, 1:kmax)
  1598:                 integer , intent(in ) :: ig, iband
  1599:                 real(DP), intent(out) :: xyz_PFRat(0:imax-1, 1:jmax, 1:kmax)
  1600:             
  1601:             
  1602:                 !
  1603:                 ! local variables
  1604:                 !
  1605:             
  1606:                 call getpfr_givenindices( &
  1607:                   & 1, kmax, &
  1608:                   & xyz_Temp, xyz_lnPress, xyz_jj, xyz_kk, ig, iband, &
  1609:                   & xyz_PFRat &
  1610:                   & )
  1611:             
  1612:             
  1613:               end subroutine getpfr_givenindices3D
  1614:             
  1615:               !--------------------------------------------------------------------------------------
  1616:             
  1617:               subroutine getpfr_givenindices2D( &
  1618:                 & xy_Temp, xy_lnPress, xy_jj, xy_kk, ig, iband, &
  1619:                 & xy_PFRat &
  1620:                 & )
  1621:             
  1622:                 real(DP), intent(in ) :: xy_Temp   (0:imax-1, 1:jmax)
  1623:                 real(DP), intent(in ) :: xy_lnPress(0:imax-1, 1:jmax)
  1624:                 integer , intent(in ) :: xy_jj  (0:imax-1, 1:jmax)
  1625:                 integer , intent(in ) :: xy_kk  (0:imax-1, 1:jmax)
  1626:                 integer , intent(in ) :: ig, iband
  1627:                 real(DP), intent(out) :: xy_PFRat (0:imax-1, 1:jmax)
  1628:             
  1629:             
  1630:                 !
  1631:                 ! local variables
  1632:                 !
  1633:                 real(DP) :: xyz_Temp   (0:imax-1, 1:jmax, 1:1)
  1634:                 real(DP) :: xyz_lnPress(0:imax-1, 1:jmax, 1:1)
  1635:                 integer  :: xyz_jj  (0:imax-1, 1:jmax, 1:1)
  1636:                 integer  :: xyz_kk  (0:imax-1, 1:jmax, 1:1)
  1637:                 real(DP) :: xyz_PFRat(0:imax-1, 1:jmax, 1:1)
  1638:             
  1639:             
  1640: *W----->A       xyz_Temp   (:,:,1) = xy_Temp
  1641: ||      A       xyz_lnPress(:,:,1) = xy_lnPress
  1642: ||      A       xyz_jj  (:,:,1) = xy_jj
  1643: *W----- A       xyz_kk  (:,:,1) = xy_kk
  1644:             
  1645:                 call getpfr_givenindices( &
  1646:                   & 1, 1, &
  1647:                   & xyz_Temp, xyz_lnPress, xyz_jj, xyz_kk, ig, iband, &
  1648:                   & xyz_PFRat &
  1649:                   & )
  1650:             
  1651: W*===== A       xy_PFRat(:,:) = xyz_PFRat(:,:,1)
  1652:             
  1653:             
  1654:               end subroutine getpfr_givenindices2D
  1655:             
  1656:               !--------------------------------------------------------------------------------------
  1657:             
  1658:             !!$  function m2ib( m ) result( iband )
  1659:             !!$
  1660:             !!$    use matype
  1661:             !!$    use ckd_module
  1662:             !!$
  1663:             !!$    integer(i4b), intent(in ) :: m
  1664:             !!$    integer(i4b)              :: iband
  1665:             !!$
  1666:             !!$
  1667:             !!$    !
  1668:             !!$    ! local variables
  1669:             !!$    !
  1670:             !!$    integer(i4b) :: ig
  1671:             !!$    integer(i4b) :: num
  1672:             !!$
  1673:             !!$
  1674:             !!$    num = 0
  1675:             !!$    do iband = 1, nband
  1676:             !!$      if( num + ckdp( iband ) % ng .ge. m ) exit
  1677:             !!$      num = num + ckdp( iband ) % ng
  1678:             !!$    end do
  1679:             !!$    if( iband .gt. nband ) then
  1680:             !!$      write( 6, * ) 'Unexpected m'
  1681:             !!$      write( 6, * ) m
  1682:             !!$      stop
  1683:             !!$    end if
  1684:             !!$    ig = m - num
  1685:             !!$    if( ig .gt. ckdp( iband ) % ng ) then
  1686:             !!$      write( 6, * ) 'Unexpected ig'
  1687:             !!$      write( 6, * ) iband, ig
  1688:             !!$      stop
  1689:             !!$    end if
  1690:             !!$
  1691:             !!$
  1692:             !!$  end function m2ib
  1693:             
  1694:               !--------------------------------------------------------------------------------------
  1695:             
  1696:             !!$  function m2ig( m ) result( ig )
  1697:             !!$
  1698:             !!$    use matype
  1699:             !!$    use ckd_module
  1700:             !!$
  1701:             !!$    integer(i4b), intent(in ) :: m
  1702:             !!$    integer(i4b)              :: ig
  1703:             !!$
  1704:             !!$
  1705:             !!$    !
  1706:             !!$    ! local variables
  1707:             !!$    !
  1708:             !!$    integer(i4b) :: iband
  1709:             !!$    integer(i4b) :: num
  1710:             !!$
  1711:             !!$
  1712:             !!$    num = 0
  1713:             !!$    do iband = 1, nband
  1714:             !!$      if( num + ckdp( iband ) % ng .ge. m ) exit
  1715:             !!$      num = num + ckdp( iband ) % ng
  1716:             !!$    end do
  1717:             !!$    if( iband .gt. nband ) then
  1718:             !!$      write( 6, * ) 'Unexpected m'
  1719:             !!$      write( 6, * ) m
  1720:             !!$      stop
  1721:             !!$    end if
  1722:             !!$    ig = m - num
  1723:             !!$    if( ig .gt. ckdp( iband ) % ng ) then
  1724:             !!$      write( 6, * ) 'Unexpected ig'
  1725:             !!$      write( 6, * ) iband, ig
  1726:             !!$      stop
  1727:             !!$    end if
  1728:             !!$
  1729:             !!$
  1730:             !!$  end function m2ig
  1731:             
  1732:               !--------------------------------------------------------------------------------------
  1733:             
  1734:             !!$  subroutine getlnac_lblinterface( nwnsl, km, nras, gt, gp, ac, m )
  1735:             !!$
  1736:             !!$    use matype
  1737:             !!$    use ckd_module
  1738:             !!$
  1739:             !!$    integer(i4b), intent(in ) :: nwnsl, km, nras
  1740:             !!$    real(dp)    , intent(in ) :: gt( km ), gp( km )
  1741:             !!$    real(dp)    , intent(out) :: ac( nwnsl, km, nras )
  1742:             !!$    integer(i4b), intent(in ) :: m
  1743:             !!$
  1744:             !!$
  1745:             !!$    !
  1746:             !!$    ! local variables
  1747:             !!$    !
  1748:             !!$    real(dp)     :: ac_1d( km )
  1749:             !!$    integer(i4b) :: ig, iband
  1750:             !!$    integer(i4b) :: k
  1751:             !!$
  1752:             !!$
  1753:             !!$    if( nwnsl .ne. 1 ) then
  1754:             !!$      write( 6, * ) 'Unexpected nwnsl.'
  1755:             !!$      write( 6, * ) nwnsl
  1756:             !!$      stop
  1757:             !!$    end if
  1758:             !!$    if( nras .ne. 1 ) then
  1759:             !!$      write( 6, * ) 'Unexpected nras.'
  1760:             !!$      write( 6, * ) nras
  1761:             !!$      stop
  1762:             !!$    end if
  1763:             !!$
  1764:             !!$    call m2ckdpindices( m, ig, iband )
  1765:             !!$
  1766:             !!$    call getlnac_1d( km, gt, gp, ac_1d, ig, iband )
  1767:             !!$
  1768:             !!$    do k = 1, km
  1769:             !!$      ac( :, k, 1 ) = ac_1d( k )
  1770:             !!$    end do
  1771:             !!$
  1772:             !!$
  1773:             !!$  end subroutine getlnac_lblinterface
  1774:             
  1775:               !--------------------------------------------------------------------------------------
  1776:             
  1777:             !!$  subroutine getlnac_1d( km, gt, gp, ac, ig, iband )
  1778:             !!$
  1779:             !!$    use matype
  1780:             !!$
  1781:             !!$    integer(i4b), intent(in ) :: km
  1782:             !!$    real(dp)    , intent(in ) :: gt( km ), gp( km )
  1783:             !!$    real(dp)    , intent(out) :: ac( km )
  1784:             !!$    integer(i4b), intent(in ) :: ig, iband
  1785:             !!$
  1786:             !!$
  1787:             !!$    !
  1788:             !!$    ! local variables
  1789:             !!$    !
  1790:             !!$    real(dp)     :: gt3d( 1, 1, km ), gp3d( 1, 1, km )
  1791:             !!$    real(dp)     :: ac3d( 1, 1, km )
  1792:             !!$    integer(i4b) :: k
  1793:             !!$
  1794:             !!$
  1795:             !!$    do k = 1, km
  1796:             !!$      gt3d( 1, 1, k ) = gt( k )
  1797:             !!$      gp3d( 1, 1, k ) = gp( k )
  1798:             !!$    end do
  1799:             !!$
  1800:             !!$    call getlnac( 1, 1, km, gt3d, gp3d, ac3d, ig, iband, 1, 1 )
  1801:             !!$
  1802:             !!$    do k = 1, km
  1803:             !!$      ac( k ) = ac3d( 1, 1, k )
  1804:             !!$    end do
  1805:             !!$
  1806:             !!$
  1807:             !!$  end subroutine getlnac_1d
  1808:             
  1809:               !--------------------------------------------------------------------------------------
  1810:             !!$
  1811:             !!$  subroutine getlnac( im, jm, km, gt, gp, ac, ig, iband, ijs, ije )
  1812:             !!$
  1813:             !!$    use matype
  1814:             !!$    use ckd_module
  1815:             !!$
  1816:             !!$    integer(i4b), intent(in ) :: im, jm, km
  1817:             !!$    real(dp)    , intent(in ) :: gt( im, jm, km ), gp( im, jm, km )
  1818:             !!$    real(dp)    , intent(out) :: ac( im, jm, km )
  1819:             !!$    integer(i4b), intent(in ) :: ig, iband
  1820:             !!$    integer(i4b), intent(in ) :: ijs, ije
  1821:             !!$
  1822:             !!$
  1823:             !!$    !
  1824:             !!$    ! local variables
  1825:             !!$    !
  1826:             !!$    real(dp)     :: glnp( im, jm, km )
  1827:             !!$    real(dp)     :: lnac1, lnac2
  1828:             !!$    integer(i4b) :: ij, k, l
  1829:             !!$    integer(i4b) :: jj( im, jm, km ), kk( im, jm, km )
  1830:             !!$
  1831:             !!$
  1832:             !!$    do k = 1, km
  1833:             !!$      do ij = ijs, ije
  1834:             !!$
  1835:             !!$        glnp( ij, 1, k ) = log( gp( ij, 1, k ) + 1.0d-20 )
  1836:             !!$
  1837:             !!$      end do
  1838:             !!$    end do
  1839:             !!$
  1840:             !!$    do k = 1, km
  1841:             !!$      do ij = ijs, ije
  1842:             !!$        kk( ij, 1, k ) = 1
  1843:             !!$      end do
  1844:             !!$    end do
  1845:             !!$    do l = 1+1, ckdp( iband ) % nt - 1
  1846:             !!$      do k = 1, km
  1847:             !!$        do ij = ijs, ije
  1848:             !!$          if( ckdp( iband ) % t( l ) .le. gt( ij, 1, k ) ) &
  1849:             !!$            kk( ij, 1, k ) = l
  1850:             !!$        end do
  1851:             !!$      end do
  1852:             !!$    end do
  1853:             !!$
  1854:             !!$    do k = 1, km
  1855:             !!$      do ij = ijs, ije
  1856:             !!$        jj( ij, 1, k ) = 1
  1857:             !!$      end do
  1858:             !!$    end do
  1859:             !!$    do l = 1+1, ckdp( iband ) % nlnp - 1
  1860:             !!$      do k = 1, km
  1861:             !!$        do ij = ijs, ije
  1862:             !!$          if( ckdp( iband ) % lnp( l ) .le. glnp( ij, 1, k ) ) &
  1863:             !!$            jj( ij, 1, k ) = l
  1864:             !!$        end do
  1865:             !!$      end do
  1866:             !!$    end do
  1867:             !!$
  1868:             !!$
  1869:             !!$    do k = 1, km
  1870:             !!$      do ij = ijs, ije
  1871:             !!$
  1872:             !!$        lnac1 &
  1873:             !!$          = ( ckdp(iband)%lnac( ig, jj(ij,1,k)  , kk(ij,1,k)+1 )      &
  1874:             !!$          - ckdp(iband)%lnac( ig, jj(ij,1,k)  , kk(ij,1,k)   ) )    &
  1875:             !!$          / ( ckdp(iband)%t( kk(ij,1,k)+1 )                          &
  1876:             !!$          - ckdp(iband)%t( kk(ij,1,k)   ) )                        &
  1877:             !!$          * ( gt(ij,1,k) - ckdp( iband ) % t( kk(ij,1,k) ) )          &
  1878:             !!$          + ckdp(iband)%lnac( ig, jj(ij,1,k)  , kk(ij,1,k)   )
  1879:             !!$        lnac2 &
  1880:             !!$          = ( ckdp(iband)%lnac( ig, jj(ij,1,k)+1, kk(ij,1,k)+1 )      &
  1881:             !!$          - ckdp(iband)%lnac( ig, jj(ij,1,k)+1, kk(ij,1,k)   ) )    &
  1882:             !!$          / ( ckdp(iband)%t( kk(ij,1,k)+1 )                          &
  1883:             !!$          - ckdp(iband)%t( kk(ij,1,k)   ) )                        &
  1884:             !!$          * ( gt(ij,1,k) - ckdp( iband ) % t( kk(ij,1,k) ) )          &
  1885:             !!$          + ckdp(iband)%lnac( ig, jj(ij,1,k)+1, kk(ij,1,k)   )
  1886:             !!$
  1887:             !!$        ac( ij, 1, k ) &
  1888:             !!$          = ( lnac2 - lnac1 ) &
  1889:             !!$          / ( ckdp( iband ) % lnp( jj(ij,1,k)+1 ) &
  1890:             !!$          - ckdp( iband ) % lnp( jj(ij,1,k)   ) ) &
  1891:             !!$          * ( glnp(ij,1,k) - ckdp( iband ) % lnp( jj(ij,1,k) ) ) &
  1892:             !!$          + lnac1
  1893:             !!$      end do
  1894:             !!$    end do
  1895:             !!$
  1896:             !!$
  1897:             !!$  end subroutine getlnac
  1898:             
  1899:               !--------------------------------------------------------------------------------------
  1900:             
  1901:             !!$  subroutine getpf_arr3d( im, jm, km, gt, gts, gp, gps, &
  1902:             !!$    pfarr, pfsarr, ig, iband, ijs, ije )
  1903:             !!$
  1904:             !!$    use matype
  1905:             !!$    use ckd_module
  1906:             !!$    use pf_module
  1907:             !!$
  1908:             !!$    integer(i4b), intent(in ) :: im, jm, km
  1909:             !!$    real(dp)    , intent(in ) :: gt( im, jm, km ), gts( im, jm ), gp( im, jm, km ), gps( im, jm )
  1910:             !!$    real(dp)    , intent(out) :: pfarr( im, jm, km ), pfsarr( im, jm )
  1911:             !!$    integer(i4b), intent(in ) :: ig, iband
  1912:             !!$    integer(i4b), intent(in ) :: ijs, ije
  1913:             !!$
  1914:             !!$
  1915:             !!$    !
  1916:             !!$    ! local variables
  1917:             !!$    !
  1918:             !!$    real(dp)     :: pfr   ( im, jm, km )
  1919:             !!$    real(dp)     :: gts3d1( im, jm, 1  ), gps3d1( im, jm, 1 ), pfr3d1( im, jm, 1 )
  1920:             !!$    integer(i4b) :: ncp_pfint
  1921:             !!$    integer(i4b) :: ij, k
  1922:             !!$
  1923:             !!$
  1924:             !!$    ncp_pfint = 5
  1925:             !!$
  1926:             !!$    call getpfr( im, jm, km, gt    , gp    , pfr   , ig, iband, ijs, ije )
  1927:             !!$    do ij = ijs, ije
  1928:             !!$      gts3d1( ij, 1, 1 ) = gts( ij, 1 )
  1929:             !!$      gps3d1( ij, 1, 1 ) = gps( ij, 1 )
  1930:             !!$    end do
  1931:             !!$    call getpfr( im, jm, 1 , gts3d1, gps3d1, pfr3d1, ig, iband, ijs, ije )
  1932:             !!$
  1933:             !!$
  1934:             !!$    call pfint_gq_array( ckdp(iband)%wnbnds(1), ckdp(iband)%wnbnds(2), &
  1935:             !!$      ncp_pfint, im, jm, km, gt, pfarr, &
  1936:             !!$      ijs, ije )
  1937:             !!$    call pfint_gq_array2d( ckdp(iband)%wnbnds(1), ckdp(iband)%wnbnds(2), &
  1938:             !!$      ncp_pfint, im, jm, gts, pfsarr, &
  1939:             !!$      ijs, ije )
  1940:             !!$
  1941:             !!$    do k = 1, km
  1942:             !!$      do ij = ijs, ije
  1943:             !!$        pfarr( ij, 1, k ) = pfarr( ij, 1, k ) &
  1944:             !!$          / ( ckdp(iband)%wnbnds(2) - ckdp(iband)%wnbnds(1) )       &
  1945:             !!$          * pfr( ij, 1, k )
  1946:             !!$      end do
  1947:             !!$    end do
  1948:             !!$    do ij = ijs, ije
  1949:             !!$      pfsarr( ij, 1 ) = pfsarr( ij, 1 ) &
  1950:             !!$        / ( ckdp(iband)%wnbnds(2) - ckdp(iband)%wnbnds(1) )       &
  1951:             !!$        * pfr3d1( ij, 1, 1 )
  1952:             !!$    end do
  1953:             !!$
  1954:             !!$
  1955:             !!$  end subroutine getpf_arr3d
  1956:             
  1957:               !--------------------------------------------------------------------------------------
  1958:             
  1959:             !!$  subroutine getpf_arr3d_givenindices( im, jm, km, gt, gts, glnp, glnps, &
  1960:             !!$    jj, kk, jjs, kks, &
  1961:             !!$    pfarr, pfsarr, ig, iband, ijs, ije )
  1962:             !!$
  1963:             !!$    use matype
  1964:             !!$    use ckd_module
  1965:             !!$    use pf_module
  1966:             !!$
  1967:             !!$    integer(i4b), intent(in ) :: im, jm, km
  1968:             !!$    real(dp)    , intent(in ) :: gt( im, jm, km ), gts( im, jm ), glnp( im, jm, km ), glnps( im, jm )
  1969:             !!$    integer(i4b), intent(in ) :: jj ( im, jm, km ), kk ( im, jm, km )
  1970:             !!$    integer(i4b), intent(in ) :: jjs( im, jm )    , kks( im, jm )
  1971:             !!$    real(dp)    , intent(out) :: pfarr( im, jm, km ), pfsarr( im, jm )
  1972:             !!$    integer(i4b), intent(in ) :: ig, iband
  1973:             !!$    integer(i4b), intent(in ) :: ijs, ije
  1974:             !!$
  1975:             !!$
  1976:             !!$    !
  1977:             !!$    ! local variables
  1978:             !!$    !
  1979:             !!$    real(dp)     :: pfr   ( im, jm, km )
  1980:             !!$    real(dp)     :: gts3d1( im, jm, 1  ), glnps3d1( im, jm, 1 ), pfr3d1( im, jm, 1 )
  1981:             !!$    integer(i4b) :: jjs3d1( im, jm, 1  ), kks3d1  ( im, jm, 1 )
  1982:             !!$    integer(i4b) :: ncp_pfint
  1983:             !!$    integer(i4b) :: ij, k
  1984:             !!$
  1985:             !!$
  1986:             !!$    ncp_pfint = 5
  1987:             !!$
  1988:             !!$
  1989:             !!$    do ij = ijs, ije
  1990:             !!$      gts3d1  ( ij, 1, 1 ) = gts  ( ij, 1 )
  1991:             !!$      glnps3d1( ij, 1, 1 ) = glnps( ij, 1 )
  1992:             !!$      jjs3d1  ( ij, 1, 1 ) = jjs  ( ij, 1 )
  1993:             !!$      kks3d1  ( ij, 1, 1 ) = kks  ( ij, 1 )
  1994:             !!$    end do
  1995:             !!$
  1996:             !!$
  1997:             !!$    call getpfr_givenindices( im, jm, km, gt    , glnp    , jj    , kk    , pfr   , ig, iband, ijs, ije )
  1998:             !!$    call getpfr_givenindices( im, jm, 1 , gts3d1, glnps3d1, jjs3d1, kks3d1, pfr3d1, ig, iband, ijs, ije )
  1999:             !!$
  2000:             !!$
  2001:             !!$    call pfint_gq_array( ckdp(iband)%wnbnds(1), ckdp(iband)%wnbnds(2), &
  2002:             !!$      ncp_pfint, im, jm, km, gt, pfarr, &
  2003:             !!$      ijs, ije )
  2004:             !!$    call pfint_gq_array2d( ckdp(iband)%wnbnds(1), ckdp(iband)%wnbnds(2), &
  2005:             !!$      ncp_pfint, im, jm, gts, pfsarr, &
  2006:             !!$      ijs, ije )
  2007:             !!$
  2008:             !!$    do k = 1, km
  2009:             !!$      do ij = ijs, ije
  2010:             !!$        pfarr( ij, 1, k ) = pfarr( ij, 1, k ) &
  2011:             !!$          / ( ckdp(iband)%wnbnds(2) - ckdp(iband)%wnbnds(1) )       &
  2012:             !!$          * pfr( ij, 1, k )
  2013:             !!$      end do
  2014:             !!$    end do
  2015:             !!$    do ij = ijs, ije
  2016:             !!$      pfsarr( ij, 1 ) = pfsarr( ij, 1 ) &
  2017:             !!$        / ( ckdp(iband)%wnbnds(2) - ckdp(iband)%wnbnds(1) )       &
  2018:             !!$        * pfr3d1( ij, 1, 1 )
  2019:             !!$    end do
  2020:             !!$
  2021:             !!$
  2022:             !!$  end subroutine getpf_arr3d_givenindices
  2023:             
  2024:               !--------------------------------------------------------------------------------------
  2025:             
  2026:             !!$  subroutine getpf_arr3d_givenindices_norat( im, jm, km, gt, gts, glnp, glnps, &
  2027:             !!$    pfarr, pfsarr, iband, ijs, ije )
  2028:             !!$
  2029:             !!$    use matype
  2030:             !!$    use ckd_module
  2031:             !!$    use pf_module
  2032:             !!$
  2033:             !!$    integer(i4b), intent(in ) :: im, jm, km
  2034:             !!$    real(dp)    , intent(in ) :: gt( im, jm, km ), gts( im, jm ), glnp( im, jm, km ), glnps( im, jm )
  2035:             !!$    real(dp)    , intent(out) :: pfarr( im, jm, km ), pfsarr( im, jm )
  2036:             !!$    integer(i4b), intent(in ) :: iband
  2037:             !!$    integer(i4b), intent(in ) :: ijs, ije
  2038:             !!$
  2039:             !!$
  2040:             !!$    !
  2041:             !!$    ! local variables
  2042:             !!$    !
  2043:             !!$    integer(i4b) :: ncp_pfint
  2044:             !!$    integer(i4b) :: ij, k
  2045:             !!$
  2046:             !!$
  2047:             !!$    ncp_pfint = 5
  2048:             !!$
  2049:             !!$
  2050:             !!$    call pfint_gq_array( ckdp(iband)%wnbnds(1), ckdp(iband)%wnbnds(2), &
  2051:             !!$      ncp_pfint, im, jm, km, gt, pfarr, &
  2052:             !!$      ijs, ije )
  2053:             !!$    call pfint_gq_array2d( ckdp(iband)%wnbnds(1), ckdp(iband)%wnbnds(2), &
  2054:             !!$      ncp_pfint, im, jm, gts, pfsarr, &
  2055:             !!$      ijs, ije )
  2056:             !!$
  2057:             !!$    do k = 1, km
  2058:             !!$      do ij = ijs, ije
  2059:             !!$        pfarr( ij, 1, k ) = pfarr( ij, 1, k ) &
  2060:             !!$          / ( ckdp(iband)%wnbnds(2) - ckdp(iband)%wnbnds(1) )
  2061:             !!$      end do
  2062:             !!$    end do
  2063:             !!$    do ij = ijs, ije
  2064:             !!$      pfsarr( ij, 1 ) = pfsarr( ij, 1 ) &
  2065:             !!$        / ( ckdp(iband)%wnbnds(2) - ckdp(iband)%wnbnds(1) )
  2066:             !!$    end do
  2067:             !!$
  2068:             !!$
  2069:             !!$  end subroutine getpf_arr3d_givenindices_norat
  2070:             
  2071:               !--------------------------------------------------------------------------------------
  2072:             
  2073:             !!$  subroutine getpf_arr2d_givenindices( im, jm, gts, glnps, &
  2074:             !!$    & jjs, kks, &
  2075:             !!$    & pfsarr, ig, iband, ijs, ije )
  2076:             !!$
  2077:             !!$    use matype
  2078:             !!$    use ckd_module
  2079:             !!$    use pf_module
  2080:             !!$
  2081:             !!$    integer(i4b), intent(in ) :: im, jm
  2082:             !!$    real(dp)    , intent(in ) :: gts( im, jm ), glnps( im, jm )
  2083:             !!$    integer(i4b), intent(in ) :: jjs( im, jm )    , kks( im, jm )
  2084:             !!$    real(dp)    , intent(out) :: pfsarr( im, jm )
  2085:             !!$    integer(i4b), intent(in ) :: ig, iband
  2086:             !!$    integer(i4b), intent(in ) :: ijs, ije
  2087:             !!$
  2088:             !!$
  2089:             !!$    !
  2090:             !!$    ! local variables
  2091:             !!$    !
  2092:             !!$    real(dp)     :: gts3d1( im, jm, 1  ), glnps3d1( im, jm, 1 ), pfr3d1( im, jm, 1 )
  2093:             !!$    integer(i4b) :: jjs3d1( im, jm, 1  ), kks3d1  ( im, jm, 1 )
  2094:             !!$    integer(i4b) :: ncp_pfint
  2095:             !!$    integer(i4b) :: ij, k
  2096:             !!$
  2097:             !!$
  2098:             !!$    ncp_pfint = 5
  2099:             !!$
  2100:             !!$
  2101:             !!$    do ij = ijs, ije
  2102:             !!$      gts3d1  ( ij, 1, 1 ) = gts  ( ij, 1 )
  2103:             !!$      glnps3d1( ij, 1, 1 ) = glnps( ij, 1 )
  2104:             !!$      jjs3d1  ( ij, 1, 1 ) = jjs  ( ij, 1 )
  2105:             !!$      kks3d1  ( ij, 1, 1 ) = kks  ( ij, 1 )
  2106:             !!$    end do
  2107:             !!$
  2108:             !!$
  2109:             !!$    call getpfr_givenindices( im, jm, 1 , gts3d1, glnps3d1, jjs3d1, kks3d1, pfr3d1, ig, iband, ijs, ije )
  2110:             !!$
  2111:             !!$
  2112:             !!$    call pfint_gq_array2d( ckdp(iband)%wnbnds(1), ckdp(iband)%wnbnds(2), &
  2113:             !!$      ncp_pfint, im, jm, gts, pfsarr, &
  2114:             !!$      ijs, ije )
  2115:             !!$
  2116:             !!$    do ij = ijs, ije
  2117:             !!$      pfsarr( ij, 1 ) = pfsarr( ij, 1 ) &
  2118:             !!$        / ( ckdp(iband)%wnbnds(2) - ckdp(iband)%wnbnds(1) )       &
  2119:             !!$        * pfr3d1( ij, 1, 1 )
  2120:             !!$    end do
  2121:             !!$
  2122:             !!$
  2123:             !!$  end subroutine getpf_arr2d_givenindices
  2124:             
  2125:               !--------------------------------------------------------------------------------------
  2126:             
  2127:             !!$  subroutine getpf_lblinterface( nwnsl, km, gt, gts, gp, gps, &
  2128:             !!$    pfarr, pfsarr, iwnsls, iwnsle, m )
  2129:             !!$
  2130:             !!$    use matype
  2131:             !!$    use ckd_module
  2132:             !!$    use pf_module
  2133:             !!$
  2134:             !!$
  2135:             !!$    integer(i4b), intent(in ) :: nwnsl, km
  2136:             !!$    real(dp)    , intent(in ) :: gt( km ), gts, gp( km ), gps
  2137:             !!$    real(dp)    , intent(out) :: pfarr( nwnsl, km ), pfsarr( nwnsl )
  2138:             !!$    integer(i4b), intent(in ) :: iwnsls, iwnsle, m
  2139:             !!$
  2140:             !!$
  2141:             !!$    !
  2142:             !!$    ! local variables
  2143:             !!$    !
  2144:             !!$    real(dp)     :: pfr( km )
  2145:             !!$    real(dp)     :: gt1( 1 ), gp1( 1 ), pfr1( 1 )
  2146:             !!$    integer(i4b) :: ncp_pfint
  2147:             !!$    integer(i4b) :: ig, iband
  2148:             !!$    integer(i4b) :: k, iwnsl
  2149:             !!$
  2150:             !!$
  2151:             !!$    call m2ckdpindices( m, ig, iband )
  2152:             !!$
  2153:             !!$    call getpfr_1d( km, gt , gp , pfr , ig, iband )
  2154:             !!$    gt1( 1 ) = gts
  2155:             !!$    gp1( 1 ) = gps
  2156:             !!$    call getpfr_1d( 1 , gt1, gp1, pfr1, ig, iband )
  2157:             !!$
  2158:             !!$    ncp_pfint = 5
  2159:             !!$
  2160:             !!$    do k = 1, km
  2161:             !!$      do iwnsl = iwnsls, iwnsle
  2162:             !!$        pfarr( iwnsl, k ) &
  2163:             !!$          = pfint_gq( ckdp(iband)%wnbnds(1), ckdp(iband)%wnbnds(2), &
  2164:             !!$          ncp_pfint, gt( k ) )                          &
  2165:             !!$          / ( ckdp(iband)%wnbnds(2) - ckdp(iband)%wnbnds(1) )       &
  2166:             !!$          * pfr( k )
  2167:             !!$      end do
  2168:             !!$    end do
  2169:             !!$    do iwnsl = iwnsls, iwnsle
  2170:             !!$      pfsarr( iwnsl ) &
  2171:             !!$        = pfint_gq( ckdp(iband)%wnbnds(1), ckdp(iband)%wnbnds(2), &
  2172:             !!$        ncp_pfint, gts )                          &
  2173:             !!$        / ( ckdp(iband)%wnbnds(2) - ckdp(iband)%wnbnds(1) )       &
  2174:             !!$        * pfr1( 1 )
  2175:             !!$    end do
  2176:             !!$
  2177:             !!$
  2178:             !!$  end subroutine getpf_lblinterface
  2179:             
  2180:               !--------------------------------------------------------------------------------------
  2181:             
  2182:             !!$  subroutine getpfr_1d( km, gt, gp, pfr, ig, iband )
  2183:             !!$
  2184:             !!$    use matype
  2185:             !!$
  2186:             !!$    integer(i4b), intent(in ) :: km
  2187:             !!$    real(dp)    , intent(in ) :: gt( km ), gp( km )
  2188:             !!$    real(dp)    , intent(out) :: pfr( km )
  2189:             !!$    integer(i4b), intent(in ) :: ig, iband
  2190:             !!$
  2191:             !!$
  2192:             !!$    !
  2193:             !!$    ! local variables
  2194:             !!$    !
  2195:             !!$    real(dp)     :: gt3d ( 1, 1, km ), gp3d( 1, 1, km )
  2196:             !!$    real(dp)     :: pfr3d( 1, 1, km )
  2197:             !!$    integer(i4b) :: k
  2198:             !!$
  2199:             !!$
  2200:             !!$    do k = 1, km
  2201:             !!$      gt3d( 1, 1, k ) = gt( k )
  2202:             !!$      gp3d( 1, 1, k ) = gp( k )
  2203:             !!$    end do
  2204:             !!$
  2205:             !!$    call getpfr( 1, 1, km, gt3d, gp3d, pfr3d, ig, iband, 1, 1 )
  2206:             !!$
  2207:             !!$    do k = 1, km
  2208:             !!$      pfr( k ) = pfr3d( 1, 1, k )
  2209:             !!$    end do
  2210:             !!$
  2211:             !!$
  2212:             !!$  end subroutine getpfr_1d
  2213:             
  2214:               !--------------------------------------------------------------------------------------
  2215:             
  2216:             !!$  subroutine getpfr( im, jm, km, gt, gp, pfr, ig, iband, ijs, ije )
  2217:             !!$
  2218:             !!$    use matype
  2219:             !!$    use ckd_module
  2220:             !!$
  2221:             !!$    integer(i4b), intent(in ) :: im, jm, km
  2222:             !!$    real(dp)    , intent(in ) :: gt( im, jm, km ), gp( im, jm, km )
  2223:             !!$    real(dp)    , intent(out) :: pfr( im, jm, km )
  2224:             !!$    integer(i4b), intent(in ) :: ig, iband
  2225:             !!$    integer(i4b), intent(in ) :: ijs, ije
  2226:             !!$
  2227:             !!$
  2228:             !!$    !
  2229:             !!$    ! local variables
  2230:             !!$    !
  2231:             !!$    real(dp)     :: glnp( im, jm, km )
  2232:             !!$    real(dp)     :: pfr1, pfr2
  2233:             !!$    integer(i4b) :: ij, k, l
  2234:             !!$    integer(i4b) :: jj( im, jm, km ), kk( im, jm, km )
  2235:             !!$
  2236:             !!$
  2237:             !!$    do k = 1, km
  2238:             !!$      do ij = ijs, ije
  2239:             !!$
  2240:             !!$        glnp( ij, 1, k ) = log( gp( ij, 1, k ) + 1.0d-20 )
  2241:             !!$
  2242:             !!$      end do
  2243:             !!$    end do
  2244:             !!$
  2245:             !!$
  2246:             !!$    do k = 1, km
  2247:             !!$      do ij = ijs, ije
  2248:             !!$        kk( ij, 1, k ) = 1
  2249:             !!$      end do
  2250:             !!$    end do
  2251:             !!$    do l = 1+1, ckdp( iband ) % nt - 1
  2252:             !!$      do k = 1, km
  2253:             !!$        do ij = ijs, ije
  2254:             !!$          if( ckdp( iband ) % t( l ) .le. gt( ij, 1, k ) ) &
  2255:             !!$            kk( ij, 1, k ) = l
  2256:             !!$        end do
  2257:             !!$      end do
  2258:             !!$    end do
  2259:             !!$
  2260:             !!$    do k = 1, km
  2261:             !!$      do ij = ijs, ije
  2262:             !!$        jj( ij, 1, k ) = 1
  2263:             !!$      end do
  2264:             !!$    end do
  2265:             !!$    do l = 1+1, ckdp( iband ) % nlnp - 1
  2266:             !!$      do k = 1, km
  2267:             !!$        do ij = ijs, ije
  2268:             !!$          if( ckdp( iband ) % lnp( l ) .le. glnp( ij, 1, k ) ) &
  2269:             !!$            jj( ij, 1, k ) = l
  2270:             !!$        end do
  2271:             !!$      end do
  2272:             !!$    end do
  2273:             !!$
  2274:             !!$
  2275:             !!$    do k = 1, km
  2276:             !!$      do ij = ijs, ije
  2277:             !!$
  2278:             !!$        pfr1 &
  2279:             !!$          = ( ckdp(iband)%pfr( ig, jj(ij,1,k)  , kk(ij,1,k)+1 )      &
  2280:             !!$          - ckdp(iband)%pfr( ig, jj(ij,1,k)  , kk(ij,1,k)   ) )    &
  2281:             !!$          / ( ckdp(iband)%t( kk(ij,1,k)+1 )                          &
  2282:             !!$          - ckdp(iband)%t( kk(ij,1,k)   ) )                        &
  2283:             !!$          * ( gt(ij,1,k) - ckdp( iband ) % t( kk(ij,1,k) ) )          &
  2284:             !!$          + ckdp(iband)%pfr( ig, jj(ij,1,k)  , kk(ij,1,k)   )
  2285:             !!$        pfr2 &
  2286:             !!$          = ( ckdp(iband)%pfr( ig, jj(ij,1,k)+1, kk(ij,1,k)+1 )      &
  2287:             !!$          - ckdp(iband)%pfr( ig, jj(ij,1,k)+1, kk(ij,1,k)   ) )    &
  2288:             !!$          / ( ckdp(iband)%t( kk(ij,1,k)+1 )                          &
  2289:             !!$          - ckdp(iband)%t( kk(ij,1,k)   ) )                        &
  2290:             !!$          * ( gt(ij,1,k) - ckdp( iband ) % t( kk(ij,1,k) ) )          &
  2291:             !!$          + ckdp(iband)%pfr( ig, jj(ij,1,k)+1, kk(ij,1,k)   )
  2292:             !!$
  2293:             !!$
  2294:             !!$        pfr( ij, 1, k ) &
  2295:             !!$          = ( pfr2 - pfr1 ) &
  2296:             !!$          / ( ckdp( iband ) % lnp( jj(ij,1,k)+1 ) &
  2297:             !!$          - ckdp( iband ) % lnp( jj(ij,1,k)   ) ) &
  2298:             !!$          * ( glnp(ij,1,k) - ckdp( iband ) % lnp( jj(ij,1,k) ) ) &
  2299:             !!$          + pfr1
  2300:             !!$      end do
  2301:             !!$    end do
  2302:             !!$
  2303:             !!$
  2304:             !!$  end subroutine getpfr
  2305:             
  2306:               !--------------------------------------------------------------------------------------
  2307:             
  2308:             !!$  subroutine getweight_lblinterface( nwnsl, weight, m )
  2309:             !!$
  2310:             !!$    use matype
  2311:             !!$    use ckd_module
  2312:             !!$    use pf_module
  2313:             !!$
  2314:             !!$    integer(i4b), intent(in ) :: nwnsl
  2315:             !!$    real(dp)    , intent(out) :: weight
  2316:             !!$    integer(i4b), intent(in ) :: m
  2317:             !!$
  2318:             !!$
  2319:             !!$    !
  2320:             !!$    ! local variables
  2321:             !!$    !
  2322:             !!$    integer(i4b) :: ig, iband
  2323:             !!$
  2324:             !!$
  2325:             !!$    if( nwnsl .ne. 1 ) then
  2326:             !!$      write( 6, * ) 'Now, nwnsl must be 1.'
  2327:             !!$      write( 6, * ) nwnsl
  2328:             !!$      stop
  2329:             !!$    end if
  2330:             !!$
  2331:             !!$
  2332:             !!$    call m2ckdpindices( m, ig, iband )
  2333:             !!$
  2334:             !!$    weight = ( ckdp(iband)%wnbnds(2) - ckdp(iband)%wnbnds(1) ) &
  2335:             !!$      * ckdp(iband)%weight(ig)
  2336:             !!$
  2337:             !!$
  2338:             !!$  end subroutine getweight_lblinterface
  2339:             
  2340:               !--------------------------------------------------------------------------------------
  2341:             
  2342:             !!$  subroutine getweight_gcm( ig, iband, weight )
  2343:             !!$
  2344:             !!$    use matype
  2345:             !!$    use ckd_module
  2346:             !!$
  2347:             !!$    integer(i4b), intent(in ) :: ig, iband
  2348:             !!$    real(dp)    , intent(out) :: weight
  2349:             !!$
  2350:             !!$
  2351:             !!$    !
  2352:             !!$    ! local variables
  2353:             !!$    !
  2354:             !!$
  2355:             !!$
  2356:             !!$    weight = ( ckdp(iband)%wnbnds(2) - ckdp(iband)%wnbnds(1) ) &
  2357:             !!$      * ckdp(iband)%weight(ig)
  2358:             !!$
  2359:             !!$
  2360:             !!$  end subroutine getweight_gcm
  2361:             
  2362:             
  2363:               !**************************************************************************
  2364:             
  2365:               subroutine RadMars15mInit
  2366:             
  2367:                 ! モジュール引用 ; USE statements
  2368:                 !
  2369:             
  2370:                 ! NAMELIST ファイル入力に関するユーティリティ
  2371:                 ! Utilities for NAMELIST file input
  2372:                 !
  2373:                 use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid
  2374:             
  2375:                 ! ファイル入出力補助
  2376:                 ! File I/O support
  2377:                 !
  2378:                 use dc_iounit, only: FileOpen
  2379:             
  2380:                 use ckd_module, only : ckd_input, ckdp, nband
  2381:             
  2382:             
  2383:                 !
  2384:                 ! local variables
  2385:                 !
  2386:                 integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号.
  2387:                                           ! Unit number for NAMELIST file open
  2388:                 integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT.
  2389:                                           ! IOSTAT of NAMELIST read
  2390:             
  2391:                 character(STRING) :: rad15mkg_fn
  2392:                 character(STRING) :: rad15mnf_fn
  2393:             
  2394:                 integer           :: m
  2395:             
  2396:                 namelist /rad_Mars_15m_nml/ &
  2397:                   & rad15mkg_fn, &
  2398:             !!$      & rad15mnf_fn, &
  2399:                   & Rad15mInt
  2400:             
  2401:             
  2402:                 ! 実行文 ; Executable statement
  2403:                 !
  2404:             
  2405:                 if ( rad_Mars_15m_inited ) return
  2406:             
  2407:                 ! デフォルト値の設定
  2408:                 ! Default values settings
  2409:                 !
  2410:             
  2411:                 rad15mkg_fn = "./kg15m"
  2412:             !!$    rad15mnf_fn = "./nlte15mfactor"
  2413:                 Rad15mInt   = 925.0_DP
  2414:             
  2415:                 ! NAMELIST の読み込み
  2416:                 ! NAMELIST is input
  2417:                 !
  2418:                 if ( trim(namelist_filename) /= '' ) then
  2419:                   call FileOpen( unit_nml, &          ! (out)
  2420:                     & namelist_filename, mode = 'r' ) ! (in)
  2421:             
  2422:                   rewind( unit_nml )
  2423:                   read( unit_nml,                &  ! (in)
  2424:                     & nml = rad_Mars_15m_nml,    &  ! (out)
  2425:                     & iostat = iostat_nml )         ! (out)
  2426:                   close( unit_nml )
  2427:             
  2428:                   call NmlutilMsg( iostat_nml, module_name ) ! (in)
  2429:                 end if
  2430:             
  2431:             
  2432:             !!$    allocate( rad_gp   ( im, jm,   km ) )
  2433:             !!$    allocate( rad_gph  ( im, jm, 0:km ) )
  2434:             !!$    allocate( rad_gt   ( im, jm,   km ) )
  2435:             !!$    allocate( rad_gts  ( im, jm,   1  ) )
  2436:             !!$    allocate( rad_gdod ( im, jm, 0:km ) )
  2437:             
  2438:             
  2439:                 nras = 1
  2440:                 nrps = 0
  2441:             
  2442:             !!$    allocate( sgmh_f          ( km*nvr+1 ), &
  2443:             !!$      &       sgm_f           ( km*nvr   ) )
  2444:             !!$    allocate( gph_f    ( im, jm, km*nvr+1 ), &
  2445:             !!$      &       gp_f     ( im, jm, km*nvr   ), &
  2446:             !!$      &       gth_f    ( im, jm, km*nvr+1 ) )
  2447:             !!$
  2448:             !!$    allocate( gvmr_f   ( im, jm, km*nvr  , nras + nrps ) )
  2449:             !!$    allocate( mmmass_f ( im, jm, km*nvr   ) )
  2450:             !!$    allocate( ac_f     ( im, jm, km*nvr  , nras        ) )
  2451:             !!$
  2452:             !!$    allocate( gdod_f   ( im, jm, km*nvr+1 ) )
  2453:             !!$
  2454:             !!$
  2455:                 allocate( xyra_Trans  (0:imax-1, 1:jmax, 0:kmax, 0:kmax) )
  2456:             !!$    allocate( pfh_f    ( im, jm, km*nvr+1 ) )
  2457:             !!$
  2458:             !!$    allocate( uwflh_f  ( im, jm, km*nvr+1 ), &
  2459:             !!$      &       dwflh_f  ( im, jm, km*nvr+1 ) )
  2460:             
  2461:             
  2462:                 allocate( &
  2463:                   & trans_i2i_toa(0:imax-1, 1:jmax, 0:kmax), &
  2464:                   & trans_i2i_boa(0:imax-1, 1:jmax, 0:kmax), &
  2465:                   & trans_i2i_s  (0:imax-1, 1:jmax, 0:kmax), &
  2466:                   & trans_i2m_lli(0:imax-1, 1:jmax, 0:kmax, 1:kmax), &
  2467:                   & trans_i2m_uli(0:imax-1, 1:jmax, 0:kmax, 1:kmax)  &
  2468:                   & )
  2469:             
  2470: W**==== A       trans_i2i_toa(:,:,:)   = 1.0d100
  2471: W**==== A       trans_i2i_boa(:,:,:)   = 1.0d100
  2472: W**==== A       trans_i2i_s  (:,:,:)   = 1.0d100
  2473: W***=== A       trans_i2m_lli(:,:,:,:) = 1.0d100
  2474: W***=== A       trans_i2m_uli(:,:,:,:) = 1.0d100
  2475:             
  2476:             
  2477:                 !
  2478:                 ! check
  2479:                 !
  2480:                 if( nras .ne. 1 ) then
  2481:                   write( 6, * ) 'nras is not 1.'
  2482:                   write( 6, * ) nras
  2483:                   stop
  2484:                 end if
  2485:             
  2486:                 call ckd_input( rad15mkg_fn )
  2487:             
  2488:                 ! check
  2489:                 if( nband /= 1 ) then
  2490:                   write( 6, * ) ' nband is not 1.'
  2491:                   write( 6, * ) nband
  2492:                   stop
  2493:                 end if
  2494:             
  2495:                 nwnl = 0
  2496: V------>        do m = 1, nband
  2497: |       A         nwnl = nwnl + ckdp( m ) % ng
  2498: V------         end do
  2499:             
  2500:             
  2501:             
  2502:             !!$    call increase_vreso_boundary( km, nvr, sgmh, sgmh_f, "log" )
  2503:             !!$    do k = 1, km * nvr
  2504:             !!$      sgm_f( k ) = sqrt( sgmh_f( k ) * sgmh_f( k+1 ) )
  2505:             !!$    end do
  2506:             
  2507:             
  2508:             !!$    call rad15m_readnlte15mfac( rad15mnf_fn )
  2509:             
  2510:             
  2511:                 !
  2512:                 ! This routine must be called after rad15m_readkgtbl.
  2513:                 !
  2514:             !!$      call rad15m_rv_read( time )
  2515:             !!$    call rad15m_rv_read_newscheme2006( time )
  2516:             
  2517:             
  2518:                 rad_Mars_15m_inited = .true.
  2519:             
  2520:             
  2521:               end subroutine RadMars15mInit
  2522:             
  2523:               !**************************************************************************
  2524:             
  2525:             !!$  subroutine rad15m_rv_put_newscheme2006( time, gt, gph, gp, gts, gdod, ijs, ije )
  2526:             !!$
  2527:             !!$    real(DP), intent(in ) :: time
  2528:             !!$    real(DP), intent(in ) :: gt ( im, jm, km   )
  2529:             !!$    real(DP), intent(in ) :: gph( im, jm, km+1 ), gp( im, jm, km )
  2530:             !!$    real(DP), intent(in ) :: gts( im, jm )
  2531:             !!$    real(DP), intent(in ) :: gdod( im, jm, km+1 )
  2532:             !!$    integer , intent(in ) :: ijs, ije
  2533:             !!$
  2534:             !!$
  2535:             !!$    !
  2536:             !!$    ! local variables
  2537:             !!$    !
  2538:             !!$    integer  :: ij, k
  2539:             !!$    real(DP) :: q15m( im, jm, km )
  2540:             !!$    real(DP) :: gdf15m( im, jm )
  2541:             !!$
  2542:             !!$
  2543:             !!$    q15m(:,:,:) = 1.0d100
  2544:             !!$    gdf15m(:,:) = 1.0d100
  2545:             !!$
  2546:             !!$
  2547:             !!$    rad_time = time
  2548:             !!$
  2549:             !!$
  2550:             !!$    do k = 1, km
  2551:             !!$      do ij = ijs, ije
  2552:             !!$        rad_gt( ij, 1, k ) = gt( ij, 1, k )
  2553:             !!$      end do
  2554:             !!$    end do
  2555:             !!$    do k = 1, km+1
  2556:             !!$      do ij = ijs, ije
  2557:             !!$        rad_gph( ij, 1, k-1 ) = gph( ij, 1, k )
  2558:             !!$      end do
  2559:             !!$    end do
  2560:             !!$    do k = 1, km
  2561:             !!$      do ij = ijs, ije
  2562:             !!$        rad_gp( ij, 1, k ) = gp( ij, 1, k )
  2563:             !!$      end do
  2564:             !!$    end do
  2565:             !!$    do ij = ijs, ije
  2566:             !!$      rad_gts( ij, 1, 1 ) = gts( ij, 1 )
  2567:             !!$    end do
  2568:             !!$    do k = 1, km+1
  2569:             !!$      do ij = ijs, ije
  2570:             !!$        rad_gdod( ij, 1, k-1 ) = gdod( ij, 1, k )
  2571:             !!$      end do
  2572:             !!$    end do
  2573:             !!$
  2574:             !!$
  2575:             !!$    sw_prep_rv = .true.
  2576:             !!$
  2577:             !!$
  2578:             !!$  end subroutine rad15m_rv_put_newscheme2006
  2579:             
  2580:               !**************************************************************************
  2581:             
  2582:             !!$  subroutine rad15m_rv_read_newscheme2006( timei )
  2583:             !!$
  2584:             !!$    use mamicro   , only : ntask, ijstart, ijend
  2585:             !!$
  2586:             !!$
  2587:             !!$    real(DP), intent(in ) :: timei
  2588:             !!$
  2589:             !!$
  2590:             !!$    !
  2591:             !!$    ! local variables
  2592:             !!$    !
  2593:             !!$    integer, parameter :: mch = -1
  2594:             !!$    logical     , parameter :: lgf = .false.
  2595:             !!$
  2596:             !!$    real(DP)                :: time
  2597:             !!$    integer            :: ierr, ierr1, ierr2, ierr3, ierr4, ierr5
  2598:             !!$    integer            :: iter
  2599:             !!$
  2600:             !!$
  2601:             !!$    call ainini( rad_gp  , time, iter, ierr1, ihed(1), timei, &
  2602:             !!$      &          mch     , lgf , im  , jm   , km   )
  2603:             !!$    call ainini( rad_gph , time, iter, ierr2, ihed(2), timei, &
  2604:             !!$      &          mch     , lgf , im  , jm   , km+1 )
  2605:             !!$    call ainini( rad_gt  , time, iter, ierr3, ihed(3), timei, &
  2606:             !!$      &          mch     , lgf , im  , jm   , km   )
  2607:             !!$    call ainini( rad_gts , time, iter, ierr4, ihed(4), timei, &
  2608:             !!$      &          mch     , lgf , im  , jm   , 1    )
  2609:             !!$    call ainini( rad_gdod, time, iter, ierr5, ihed(5), timei, &
  2610:             !!$      &          mch     , lgf , im  , jm   , km+1 )
  2611:             !!$
  2612:             !!$
  2613:             !!$    ierr = max( ierr1, ierr2, ierr3, ierr4, ierr5 )
  2614:             !!$
  2615:             !!$    if( ierr .gt. 0 ) then
  2616:             !!$      write( 6, * ) 'MARS: Radiative restart variables cannot be found.'
  2617:             !!$    end if
  2618:             !!$
  2619:             !!$
  2620:             !!$    rad_time = time
  2621:             !!$
  2622:             !!$
  2623:             !!$    if( ierr .lt. 1 ) sw_prep_rv = .true.
  2624:             !!$
  2625:             !!$
  2626:             !!$    if( ierr .lt. 1 ) then
  2627:             !!$
  2628:             !!$      write( 6, * ) 'MARS: Transmission is calculated.'
  2629:             !!$
  2630:             !!$      call rad15m_2006_rv_read_calctransW
  2631:             !!$
  2632:             !!$    end if
  2633:             !!$
  2634:             !!$
  2635:             !!$  end subroutine rad15m_rv_read_newscheme2006
  2636:             
  2637:               !**************************************************************************
  2638:             
  2639:             !!$  subroutine rad15m_2006_rv_read_calctransW
  2640:             !!$
  2641:             !!$    use mamicro   , only : ntask, ijstart, ijend
  2642:             !!$
  2643:             !!$
  2644:             !!$    !
  2645:             !!$    ! local variables
  2646:             !!$    !
  2647:             !!$    integer            :: m
  2648:             !!$    integer            :: ij, k
  2649:             !!$    integer            :: ijs, ije
  2650:             !!$
  2651:             !!$    real(DP)                :: &
  2652:             !!$      gph( im, jm, km+1 ), gp( im, jm, km ), &
  2653:             !!$      gt ( im, jm, km   ), gts( im, jm ), &
  2654:             !!$      gdod( im, jm, km+1 )
  2655:             !!$
  2656:             !!$
  2657:             !!$!cdir pardo for
  2658:             !!$    do m = 1,ntask
  2659:             !!$      ijs = ijstart( m )
  2660:             !!$      ije = ijend( m )
  2661:             !!$
  2662:             !!$
  2663:             !!$      do k = 1, km
  2664:             !!$        do ij = ijs, ije
  2665:             !!$          gp  ( ij, 1, k ) = rad_gp  ( ij, 1, k )
  2666:             !!$          gt  ( ij, 1, k ) = rad_gt  ( ij, 1, k )
  2667:             !!$        end do
  2668:             !!$      end do
  2669:             !!$      do ij = ijs, ije
  2670:             !!$        gts( ij, 1 ) = rad_gts( ij, 1, 1 )
  2671:             !!$      end do
  2672:             !!$      do k = 0, km
  2673:             !!$        do ij = ijs, ije
  2674:             !!$          gph ( ij, 1, k+1 ) = rad_gph ( ij, 1, k )
  2675:             !!$          gdod( ij, 1, k+1 ) = rad_gdod( ij, 1, k )
  2676:             !!$        end do
  2677:             !!$      end do
  2678:             !!$
  2679:             !!$
  2680:             !!$      call rad15m_2006_rv_read_calctrans( &
  2681:             !!$        & gt, gph, gp, gts, &
  2682:             !!$        & gdod, &
  2683:             !!$        & ijs, ije )
  2684:             !!$
  2685:             !!$    end do
  2686:             !!$
  2687:             !!$
  2688:             !!$  end subroutine rad15m_2006_rv_read_calctransW
  2689:             
  2690:               !**************************************************************************
  2691:             
  2692:             !!$  subroutine rad15m_rv_wrt_newscheme2006( ifl )
  2693:             !!$
  2694:             !!$    use maaxisr, only : signame, sighname
  2695:             !!$
  2696:             !!$
  2697:             !!$    integer, intent(in ) :: ifl
  2698:             !!$
  2699:             !!$
  2700:             !!$    !
  2701:             !!$    ! local variables
  2702:             !!$    !
  2703:             !!$    integer     , parameter :: izero  = 0
  2704:             !!$    integer(i8b)     , parameter :: notime = 0
  2705:             !!$    character(len=lc), parameter :: nounit = '   '
  2706:             !!$    character(len= 3), parameter :: dfmt   = 'UR8'
  2707:             !!$    real(DP)         , parameter :: miss   = -1.0d30
  2708:             !!$
  2709:             !!$    integer                 :: iter, idate( 6 )
  2710:             !!$
  2711:             !!$
  2712:             !!$    if( sw_prep_rv ) then
  2713:             !!$      call ansymd( idate, rad_time )
  2714:             !!$
  2715:             !!$
  2716:             !!$      call aonjrf( rad_gp  , ihed(1), titl(1), 'Pa'   , signame , &
  2717:             !!$        &          km      , iter   , idate  , izero  , nounit  , &
  2718:             !!$        &          notime  , idate  , notime , dfmt   , miss    , ifl )
  2719:             !!$      call aonjrf( rad_gph , ihed(2), titl(2), 'Pa'   , sighname, &
  2720:             !!$        &          km+1    , iter   , idate  , izero  , nounit  , &
  2721:             !!$        &          notime  , idate  , notime , dfmt   , miss    , ifl )
  2722:             !!$      call aonjrf( rad_gt  , ihed(3), titl(3), 'K'    , signame , &
  2723:             !!$        &          km      , iter   , idate  , izero  , nounit  , &
  2724:             !!$        &          notime  , idate  , notime , dfmt   , miss    , ifl )
  2725:             !!$      call aonjrf( rad_gts , ihed(4), titl(4), 'K'    , sighname, &
  2726:             !!$        &          1       , iter   , idate  , izero  , nounit  , &
  2727:             !!$        &          notime  , idate  , notime , dfmt   , miss    , ifl )
  2728:             !!$      call aonjrf( rad_gdod, ihed(5), titl(5), '1'    , sighname, &
  2729:             !!$        &          km+1    , iter   , idate  , izero  , nounit  , &
  2730:             !!$        &          notime  , idate  , notime , dfmt   , miss    , ifl )
  2731:             !!$    end if
  2732:             !!$
  2733:             !!$
  2734:             !!$
  2735:             !!$  end subroutine rad15m_rv_wrt_newscheme2006
  2736:             
  2737:               !**************************************************************************
  2738:             
  2739:             
  2740:             
  2741:             
  2742:             end module rad_Mars_15m
