Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:39:00 2016
FILE NAME: rad_Mars_NIR.f90
PROGRAM NAME: rad_mars_nir
DIAGNOSTIC LIST

  LINE  LEVEL( NO.): DIAGNOSTIC MESSAGE

   218  opt  (1593): Loop nest collapsed into one loop.
   218  vec  (   4): Vectorized array expression.
   218  vec  (  29): ADB is used for array.: xy_coszet
   224  vec  (   1): Vectorized loop.
   224  vec  (  29): ADB is used for array.: xyz_dtempdt
   229  vec  (   1): Vectorized loop.
   229  vec  (  29): ADB is used for array.: xyz_dtempdt
   229  vec  (  29): ADB is used for array.: xyz_press
   240  opt  (1592): Outer loop unrolled inside inner loop.
   240  vec  (   4): Vectorized array expression.
   240  vec  (  29): ADB is used for array.: xyz_dtempdt
   240  vec  (   4): Vectorized array expression.
   240  vec  (  29): ADB is used for array.: xyz_dtempdt
   308  opt  (1593): Loop nest collapsed into one loop.
   308  vec  (   4): Vectorized array expression.
   308  vec  (  29): ADB is used for array.: xyz_dtempdt
   308  vec  (  29): ADB is used for array.: xyz_dtempdtlocal
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:39:00 2016
FILE NAME: rad_Mars_NIR.f90
PROGRAM NAME: rad_mars_nir
TRANSFORMATION LIST

  LINE                   FORTRAN STATEMENT

     1  != 火星計算用近赤外加熱率計算
     2  !
     3  != Calculation of near infrared heating rate in the case of Mars
     4  !
     5  ! Authors::   Yoshiyuki O. Takahashi
     6  ! Version::   $Id: rad_Mars_NIR.f90,v 1.4 2012/10/08 12:48:44 yot Exp $
     7  ! Tag Name::  $Name:  $
     8  ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9  ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10  !
    11  
    12  module rad_Mars_NIR
    13    !
    14    != 火星計算用近赤外加熱率計算
    15    !
    16    != Calculation of near infrared heating rate in the case of Mars
    17    !
    18    ! <b>Note that Japanese and English are described in parallel.</b>
    19    !
    20    !== Procedures List
    21    !
    22  !!$  ! DryConvAdjust :: 乾燥対流調節
    23  !!$  ! ------------  :: ------------
    24  !!$  ! DryConvAdjust :: Dry convective adjustment
    25    !
    26    !== NAMELIST
    27    !
    28    ! NAMELIST#rad_M_NIR_nml
    29    !
    30  
    31    ! モジュール引用 ; USE statements
    32    !
    33  
    34    ! 格子点設定
    35    ! Grid points settings
    36    !
    37    use gridset, only: imax, & ! 経度格子点数.
    38                               ! Number of grid points in longitude
    39      &                jmax, & ! 緯度格子点数.
    40                               ! Number of grid points in latitude
    41      &                kmax    ! 鉛直層数.
    42                               ! Number of vertical level
    43  
    44    ! 種別型パラメタ
    45    ! Kind type parameter
    46    !
    47    use dc_types, only: DP, &      ! 倍精度実数型. Double precision.
    48      &                 STRING     ! 文字列.       Strings.
    49  
    50    ! NAMELIST ファイル入力に関するユーティリティ
    51    ! Utilities for NAMELIST file input
    52    !
    53    use namelist_util, only: MaxNmlArySize
    54                                ! NAMELIST から読み込む配列の最大サイズ.
    55                                ! Maximum size of arrays loaded from NAMELIST
    56  
    57    ! メッセージ出力
    58    ! Message output
    59    !
    60    use dc_message, only: MessageNotify
    61  
    62    ! 宣言文 ; Declaration statements
    63    !
    64    implicit none
    65    private
    66  
    67    ! 公開手続き
    68    ! Public procedure
    69    !
    70    public :: RadMarsNIRInit
    71    public :: RadMarsNIR
    72    public :: RadMarsNIRINOUT
    73  
    74    ! 公開変数
    75    ! Public variables
    76    !
    77    logical, save, public:: rad_Mars_NIR_inited = .false.
    78                                ! 初期設定フラグ.
    79                                ! Initialization flag
    80  
    81    ! 非公開変数
    82    ! Private variables
    83    !
    84    logical, save:: FlagUse
    85                                ! 使用フラグ
    86                                ! flag for use of this scheme
    87  
    88    character(*), parameter:: module_name = 'rad_Mars_NIR'
    89                                ! モジュールの名称.
    90                                ! Module name
    91    character(*), parameter:: version = &
    92      & '$Name:  $' // &
    93      & '$Id: rad_Mars_NIR.f90,v 1.4 2012/10/08 12:48:44 yot Exp $'
    94                                ! モジュールのバージョン
    95                                ! Module version
    96  
    97  contains
    98  
    99    subroutine RadMarsNIR(         &
   100      & xyz_Press,                 &  ! (in)
   101      & xyz_DTempDt                &  ! (out)
   102      & )
   103      !
   104      ! 火星計算用近赤外加熱率計算
   105      !
   106      ! Calculation of near infrared heating rate in the case of Mars
   107      !
   108      ! Calculation schume of solar nir infrared heating rate follows
   109      ! that shown in Forget et al., 1999
   110  
   111  
   112      ! モジュール引用 ; USE statements
   113      !
   114  
   115      ! 時刻管理
   116      ! Time control
   117      !
   118      use timeset, only: &
   119        & DelTime, &            ! $ \Delta t $
   120        & TimeN, &              ! ステップ $ t $ の時刻. Time of step $ t $.
   121        & TimesetClockStart, TimesetClockStop
   122  
   123      ! ヒストリデータ出力
   124      ! History data output
   125      !
   126      use gtool_historyauto, only: HistoryAutoPut
   127  
   128      ! 日付および時刻の取り扱い
   129      ! Date and time handler
   130      !
   131      use dc_calendar, only: DCCalInquire
   132  
   133      ! 物理・数学定数設定
   134      ! Physical and mathematical constants settings
   135      !
   136      use constants0, only: &
   137        & PI                    ! $ \pi $ .
   138                                ! 円周率.  Circular constant
   139  
   140      ! 短波入射 (太陽入射)
   141      ! Short wave (insolation) incoming
   142      !
   143      use rad_short_income, only : RadShortIncome
   144  
   145  
   146      ! 宣言文 ; Declaration statements
   147      !
   148      implicit none
   149  
   150      real(DP), intent(in ):: xyz_Press  (0:imax-1, 1:jmax, 1:kmax)
   151                                ! $ p $ . 気圧 (整数レベル).
   152                                ! Air pressure (full level)
   153      real(DP), intent(out):: xyz_DTempDt(0:imax-1, 1:jmax, 1:kmax)
   154                                ! 温度変化率.
   155                                ! Temperature tendency
   156  
   157      ! 作業変数
   158      ! Work variables
   159      !
   160      real(DP) :: qnir0
   161      real(DP) :: RefPress
   162      real(DP) :: NLTEPress
   163  
   164      integer  :: hour_in_day
   165      integer  :: min_in_hour
   166      real(DP) :: sec_in_min
   167  
   168      real(DP) :: DistFromStarScld
   169      real(DP) :: DiurnalMeanFactor
   170      real(DP) :: xy_CosZet  (0:imax-1, 1:jmax)
   171      real(DP) :: xy_CosZetSq(0:imax-1, 1:jmax)
   172  
   173      real(DP) :: MuFac
   174  
   175      integer:: i               ! 経度方向に回る DO ループ用作業変数
   176                                ! Work variables for DO loop in longitude
   177      integer:: j               ! 緯度方向に回る DO ループ用作業変数
   178                                ! Work variables for DO loop in latitude
   179      integer:: k               ! 鉛直方向に回る DO ループ用作業変数
   180                                ! Work variables for DO loop in vertical direction
   181  
   182      ! 実行文 ; Executable statement
   183      !
   184  
   185      ! 計算時間計測開始
   186      ! Start measurement of computation time
   187      !
   188      call TimesetClockStart( module_name )
   189  
   190      ! 初期化
   191      ! Initialization
   192      !
   193      if ( .not. rad_Mars_NIR_inited ) then
   194        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   195      end if
   196  
   197  
   198      call DCCalInquire( &
   199        & hour_in_day      = hour_in_day  , &     ! (out)
   200        & min_in_hour      = min_in_hour  , &     ! (out)
   201        & sec_in_min       = sec_in_min     &     ! (out)
   202        & )
   203  
   204      ! constants
   205      !
   206      qnir0     = 1.3_DP / ( hour_in_day * min_in_hour * sec_in_min )
   207      RefPress  = 700.0_DP
   208      NLTEPress = 0.0075_DP
   209  
   210  
   211      call RadShortIncome( &
   212        & DistFromStarScld   = DistFromStarScld,   & ! (out) optional
   213        & xy_CosZet          = xy_CosZet,          & ! (out) optional
   214        & DiurnalMeanFactor  = DiurnalMeanFactor,  & ! (out) optional
   215        & FlagOutput         = .false.             & ! (in)  optional
   216        & )
   217  
   218      xy_CosZetSq = xy_CosZet**2
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t166 = 1, xy_coszet.DSC.U2*xy_coszet.DSC.U1 + xy_coszet.DSC.U2 
     .           xy_coszetsq(t166-1,1) = xy_coszet(t166-1,1)**2                 
     .        enddo                                                             
   219  
   220      do j = 1, jmax
   221        do i = 0, imax-1
   222  
   223          if( xy_CosZet(i,j) < 0.0_DP ) then
   224            do k = 1, kmax
   225              xyz_DTempDt(i,j,k) = 0.0_DP
   226            end do
   227          else
   228            MuFac = sqrt( ( 1224.0_DP * xy_CosZetSq(i,j) + 1.0d0 ) / 1225.0_DP )
   229            do k = 1, kmax
   230              xyz_DTempDt(i,j,k) = &
   231                & qnir0 / DistFromStarScld**2 &
   232                & * sqrt( RefPress / xyz_Press(i,j,k) * MuFac ) &
   233                & / ( 1.0d0 + NLTEPress / xyz_Press(i,j,k) )
   234            end do
   235          end if
   236  
   237        end do
   238      end do
   239  
   240      xyz_DTempDt = xyz_DTempDt * DiurnalMeanFactor
     .           if (xyz_dtempdt.DSC.U2 .gt. 0) then                            
     .           j1 = and(xyz_dtempdt.DSC.U2,3)                                 
     .  !cdir    nodep                                                          
     .           do t176 = 1, j1                                                
     .  !cdir       nodep                                                       
     .              do t178 = 1, xyz_dtempdt.DSC.U1 + 1                         
     .                 xyz_dtempdt(t178-1,t176,t174+1) = xyz_dtempdt(t178-1,t176
     .       1            ,t174+1)*diurnalmeanfactor                            
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t176 = j1 + 1, xyz_dtempdt.DSC.U2, 4                        
     .  !cdir       nodep                                                       
     .              do t178 = 1, xyz_dtempdt.DSC.U1 + 1                         
     .                 xyz_dtempdt(t178-1,t176,t174+1) = xyz_dtempdt(t178-1,t176
     .       1            ,t174+1)*diurnalmeanfactor                            
     .                 xyz_dtempdt(t178-1,t176+1,t174+1) = xyz_dtempdt(t178-1,  
     .       1            t176+1,t174+1)*diurnalmeanfactor                      
     .                 xyz_dtempdt(t178-1,t176+2,t174+1) = xyz_dtempdt(t178-1,  
     .       1            t176+2,t174+1)*diurnalmeanfactor                      
     .                 xyz_dtempdt(t178-1,t176+3,t174+1) = xyz_dtempdt(t178-1,  
     .       1            t176+3,t174+1)*diurnalmeanfactor                      
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
   241  
   242  
   243      ! ヒストリデータ出力
   244      ! History data output
   245      !
   246      call HistoryAutoPut( TimeN, 'DTempDtMNIR', xyz_DTempDt )
   247  
   248  
   249      ! 計算時間計測一時停止
   250      ! Pause measurement of computation time
   251      !
   252      call TimesetClockStop( module_name )
   253  
   254    end subroutine RadMarsNIR
   255  
   256    !-------------------------------------------------------------------
   257  
   258    subroutine RadMarsNIRINOUT(  &
   259      & xyz_Press,                 &  ! (in   )
   260      & xyz_DTempDt                &  ! (inout)
   261      & )
   262      !
   263      ! 火星計算用近赤外加熱率計算
   264      !
   265      ! Calculation of near infrared heating rate in the case of Mars
   266      !
   267      ! Calculation schume of solar nir infrared heating rate follows
   268      ! that shown in Forget et al., 1999
   269  
   270  
   271      ! モジュール引用 ; USE statements
   272      !
   273  
   274  
   275      ! 宣言文 ; Declaration statements
   276      !
   277      implicit none
   278  
   279      real(DP), intent(in   ):: xyz_Press (0:imax-1, 1:jmax, 1:kmax)
   280                                ! $ p $ . 気圧 (整数レベル).
   281                                ! Air pressure (full level)
   282      real(DP), intent(inout):: xyz_DTempDt(0:imax-1, 1:jmax, 1:kmax)
   283                                ! 温度変化率.
   284                                ! Temperature tendency
   285  
   286      ! 作業変数
   287      ! Work variables
   288      !
   289      real(DP) :: xyz_DTempDtLocal(0:imax-1, 1:jmax, 1:kmax)
   290  
   291      ! 実行文 ; Executable statement
   292      !
   293  
   294  
   295      ! 初期化
   296      ! Initialization
   297      !
   298      if ( .not. rad_Mars_NIR_inited ) then
   299        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   300      end if
   301  
   302  
   303      call RadMarsNIR(         &
   304        & xyz_Press,           &  ! (in )
   305        & xyz_DTempDtLocal     &  ! (out)
   306        & )
   307  
   308      xyz_DTempDt = xyz_DTempDt + xyz_DTempDtLocal
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t55 = 1, kmax*jmax*imax                                        
     .           xyz_dtempdt(t55-1,1,1) = xyz_dtempdt(t55-1,1,1) +              
     .       1      xyz_dtempdtlocal(t55-1,1,1)                                 
     .        enddo                                                             
   309  
   310  
   311    end subroutine RadMarsNIRINOUT
   312  
   313    !-------------------------------------------------------------------
   314  
   315    subroutine RadMarsNIRInit
   316      !
   317      ! rad_Mars_NIR モジュールの初期化を行います.
   318      ! NAMELIST#rad_Mars_NIR_nml の読み込みはこの手続きで行われます.
   319      !
   320      ! "rad_Mars_NIR" module is initialized.
   321      ! "NAMELIST#rad_Mars_NIR_nml" is loaded in this procedure.
   322      !
   323  
   324      ! モジュール引用 ; USE statements
   325      !
   326  
   327      ! NAMELIST ファイル入力に関するユーティリティ
   328      ! Utilities for NAMELIST file input
   329      !
   330      use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid
   331  
   332      ! ファイル入出力補助
   333      ! File I/O support
   334      !
   335      use dc_iounit, only: FileOpen
   336  
   337      ! 種別型パラメタ
   338      ! Kind type parameter
   339      !
   340      use dc_types, only: STDOUT ! 標準出力の装置番号. Unit number of standard output
   341  
   342      ! 文字列操作
   343      ! Character handling
   344      !
   345      use dc_string, only: StoA
   346  
   347      ! ヒストリデータ出力
   348      ! History data output
   349      !
   350      use gtool_historyauto, only: HistoryAutoAddVariable
   351  
   352      ! 座標データ設定
   353      ! Axes data settings
   354      !
   355      use axesset, only: &
   356        & AxnameX, &
   357        & AxnameY, &
   358        & AxnameZ, &
   359        & AxnameT
   360  
   361      ! 短波入射 (太陽入射)
   362      ! Short wave (insolation) incoming
   363      !
   364      use rad_short_income, only : RadShortIncomeInit
   365  
   366      ! 宣言文 ; Declaration statements
   367      !
   368      implicit none
   369  
   370      integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号.
   371                                ! Unit number for NAMELIST file open
   372      integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT.
   373                                ! IOSTAT of NAMELIST read
   374  
   375      ! NAMELIST 変数群
   376      ! NAMELIST group name
   377      !
   378      namelist /rad_Mars_NIR_nml/ &
   379        & FlagUse
   380  
   381            ! デフォルト値については初期化手続 "dry_conv_adjust#DryConvAdjustInit"
   382            ! のソースコードを参照のこと.
   383            !
   384            ! Refer to source codes in the initialization procedure
   385            ! "dry_conv_adjust#DryConvAdjustInit" for the default values.
   386            !
   387  
   388      ! 実行文 ; Executable statement
   389      !
   390  
   391      if ( rad_Mars_NIR_inited ) return
   392  
   393      ! デフォルト値の設定
   394      ! Default values settings
   395      !
   396      FlagUse = .true.
   397  
   398      ! NAMELIST の読み込み
   399      ! NAMELIST is input
   400      !
   401      if ( trim(namelist_filename) /= '' ) then
   402        call FileOpen( unit_nml, &          ! (out)
   403          & namelist_filename, mode = 'r' ) ! (in)
   404  
   405        rewind( unit_nml )
   406        read( unit_nml,                &  ! (in)
   407          & nml = rad_Mars_NIR_nml,    &  ! (out)
   408          & iostat = iostat_nml )         ! (out)
   409        close( unit_nml )
   410  
   411        call NmlutilMsg( iostat_nml, module_name ) ! (in)
   412      end if
   413  
   414  
   415      ! ヒストリデータ出力のためのへの変数登録
   416      ! Register of variables for history data output
   417      !
   418      call HistoryAutoAddVariable( 'DTempDtMNIR',    &
   419        & (/ AxnameX, AxnameY, AxnameZ, AxnameT /),  &
   420        & 'near infrared heating rate', 'K s-1' )
   421  
   422  
   423  
   424      ! Initialization of modules used in this module
   425      !
   426  
   427      ! 短波入射 (太陽入射)
   428      ! Short wave (insolation) incoming
   429      !
   430      call RadShortIncomeInit
   431  
   432  
   433  
   434      ! 印字 ; Print
   435      !
   436      call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   437      call MessageNotify( 'M', module_name, '  FlagUse    = %b', l = (/ FlagUse /) )
   438      call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   439  
   440      rad_Mars_NIR_inited = .true.
   441  
   442    end subroutine RadMarsNIRInit
   443  
   444    !-------------------------------------------------------------------
   445  
   446  end module rad_Mars_NIR
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:39:00 2016
FILE NAME: rad_Mars_NIR.f90
PROGRAM NAME: rad_mars_nir
FORMAT LIST

  LINE    LOOP      FORTRAN STATEMENT

     1:             != 火星計算用近赤外加熱率計算
     2:             !
     3:             != Calculation of near infrared heating rate in the case of Mars
     4:             !
     5:             ! Authors::   Yoshiyuki O. Takahashi
     6:             ! Version::   $Id: rad_Mars_NIR.f90,v 1.4 2012/10/08 12:48:44 yot Exp $ 
     7:             ! Tag Name::  $Name:  $
     8:             ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9:             ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10:             !
    11:             
    12:             module rad_Mars_NIR
    13:               !
    14:               != 火星計算用近赤外加熱率計算
    15:               !
    16:               != Calculation of near infrared heating rate in the case of Mars
    17:               !
    18:               ! <b>Note that Japanese and English are described in parallel.</b>
    19:               !
    20:               !== Procedures List
    21:               !
    22:             !!$  ! DryConvAdjust :: 乾燥対流調節
    23:             !!$  ! ------------  :: ------------
    24:             !!$  ! DryConvAdjust :: Dry convective adjustment
    25:               !
    26:               !== NAMELIST
    27:               !
    28:               ! NAMELIST#rad_M_NIR_nml
    29:               !
    30:             
    31:               ! モジュール引用 ; USE statements
    32:               !
    33:             
    34:               ! 格子点設定
    35:               ! Grid points settings
    36:               !
    37:               use gridset, only: imax, & ! 経度格子点数. 
    38:                                          ! Number of grid points in longitude
    39:                 &                jmax, & ! 緯度格子点数. 
    40:                                          ! Number of grid points in latitude
    41:                 &                kmax    ! 鉛直層数. 
    42:                                          ! Number of vertical level
    43:             
    44:               ! 種別型パラメタ
    45:               ! Kind type parameter
    46:               !
    47:               use dc_types, only: DP, &      ! 倍精度実数型. Double precision. 
    48:                 &                 STRING     ! 文字列.       Strings. 
    49:             
    50:               ! NAMELIST ファイル入力に関するユーティリティ
    51:               ! Utilities for NAMELIST file input
    52:               !
    53:               use namelist_util, only: MaxNmlArySize
    54:                                           ! NAMELIST から読み込む配列の最大サイズ. 
    55:                                           ! Maximum size of arrays loaded from NAMELIST
    56:             
    57:               ! メッセージ出力
    58:               ! Message output
    59:               !
    60:               use dc_message, only: MessageNotify
    61:             
    62:               ! 宣言文 ; Declaration statements
    63:               !
    64:               implicit none
    65:               private
    66:             
    67:               ! 公開手続き
    68:               ! Public procedure
    69:               !
    70:               public :: RadMarsNIRInit
    71:               public :: RadMarsNIR
    72:               public :: RadMarsNIRINOUT
    73:             
    74:               ! 公開変数
    75:               ! Public variables
    76:               !
    77:               logical, save, public:: rad_Mars_NIR_inited = .false.
    78:                                           ! 初期設定フラグ. 
    79:                                           ! Initialization flag
    80:             
    81:               ! 非公開変数
    82:               ! Private variables
    83:               !
    84:               logical, save:: FlagUse
    85:                                           ! 使用フラグ
    86:                                           ! flag for use of this scheme
    87:             
    88:               character(*), parameter:: module_name = 'rad_Mars_NIR'
    89:                                           ! モジュールの名称. 
    90:                                           ! Module name
    91:               character(*), parameter:: version = &
    92:                 & '$Name:  $' // &
    93:                 & '$Id: rad_Mars_NIR.f90,v 1.4 2012/10/08 12:48:44 yot Exp $'
    94:                                           ! モジュールのバージョン
    95:                                           ! Module version
    96:             
    97:             contains
    98:             
    99:               subroutine RadMarsNIR(         &
   100:                 & xyz_Press,                 &  ! (in)
   101:                 & xyz_DTempDt                &  ! (out)
   102:                 & )
   103:                 !
   104:                 ! 火星計算用近赤外加熱率計算
   105:                 !
   106:                 ! Calculation of near infrared heating rate in the case of Mars
   107:                 !
   108:                 ! Calculation schume of solar nir infrared heating rate follows
   109:                 ! that shown in Forget et al., 1999
   110:             
   111:             
   112:                 ! モジュール引用 ; USE statements
   113:                 !
   114:             
   115:                 ! 時刻管理
   116:                 ! Time control
   117:                 !
   118:                 use timeset, only: &
   119:                   & DelTime, &            ! $ \Delta t $
   120:                   & TimeN, &              ! ステップ $ t $ の時刻. Time of step $ t $. 
   121:                   & TimesetClockStart, TimesetClockStop
   122:             
   123:                 ! ヒストリデータ出力
   124:                 ! History data output
   125:                 !
   126:                 use gtool_historyauto, only: HistoryAutoPut
   127:             
   128:                 ! 日付および時刻の取り扱い
   129:                 ! Date and time handler
   130:                 !
   131:                 use dc_calendar, only: DCCalInquire
   132:             
   133:                 ! 物理・数学定数設定
   134:                 ! Physical and mathematical constants settings
   135:                 !
   136:                 use constants0, only: &
   137:                   & PI                    ! $ \pi $ .
   138:                                           ! 円周率.  Circular constant
   139:             
   140:                 ! 短波入射 (太陽入射)
   141:                 ! Short wave (insolation) incoming
   142:                 !
   143:                 use rad_short_income, only : RadShortIncome
   144:             
   145:             
   146:                 ! 宣言文 ; Declaration statements
   147:                 !
   148:                 implicit none
   149:             
   150:                 real(DP), intent(in ):: xyz_Press  (0:imax-1, 1:jmax, 1:kmax)
   151:                                           ! $ p $ . 気圧 (整数レベル). 
   152:                                           ! Air pressure (full level)
   153:                 real(DP), intent(out):: xyz_DTempDt(0:imax-1, 1:jmax, 1:kmax)
   154:                                           ! 温度変化率. 
   155:                                           ! Temperature tendency
   156:             
   157:                 ! 作業変数
   158:                 ! Work variables
   159:                 !
   160:                 real(DP) :: qnir0
   161:                 real(DP) :: RefPress
   162:                 real(DP) :: NLTEPress
   163:             
   164:                 integer  :: hour_in_day
   165:                 integer  :: min_in_hour
   166:                 real(DP) :: sec_in_min
   167:             
   168:                 real(DP) :: DistFromStarScld
   169:                 real(DP) :: DiurnalMeanFactor
   170:                 real(DP) :: xy_CosZet  (0:imax-1, 1:jmax)
   171:                 real(DP) :: xy_CosZetSq(0:imax-1, 1:jmax)
   172:             
   173:                 real(DP) :: MuFac
   174:             
   175:                 integer:: i               ! 経度方向に回る DO ループ用作業変数
   176:                                           ! Work variables for DO loop in longitude
   177:                 integer:: j               ! 緯度方向に回る DO ループ用作業変数
   178:                                           ! Work variables for DO loop in latitude
   179:                 integer:: k               ! 鉛直方向に回る DO ループ用作業変数
   180:                                           ! Work variables for DO loop in vertical direction
   181:             
   182:                 ! 実行文 ; Executable statement
   183:                 !
   184:             
   185:                 ! 計算時間計測開始
   186:                 ! Start measurement of computation time
   187:                 !
   188:                 call TimesetClockStart( module_name )
   189:             
   190:                 ! 初期化
   191:                 ! Initialization
   192:                 !
   193:                 if ( .not. rad_Mars_NIR_inited ) then
   194:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   195:                 end if
   196:             
   197:             
   198:                 call DCCalInquire( &
   199:                   & hour_in_day      = hour_in_day  , &     ! (out)
   200:                   & min_in_hour      = min_in_hour  , &     ! (out)
   201:                   & sec_in_min       = sec_in_min     &     ! (out)
   202:                   & )
   203:             
   204:                 ! constants
   205:                 !
   206:                 qnir0     = 1.3_DP / ( hour_in_day * min_in_hour * sec_in_min )
   207:                 RefPress  = 700.0_DP
   208:                 NLTEPress = 0.0075_DP
   209:             
   210:             
   211:                 call RadShortIncome( &
   212:                   & DistFromStarScld   = DistFromStarScld,   & ! (out) optional
   213:                   & xy_CosZet          = xy_CosZet,          & ! (out) optional
   214:                   & DiurnalMeanFactor  = DiurnalMeanFactor,  & ! (out) optional
   215:                   & FlagOutput         = .false.             & ! (in)  optional
   216:                   & )
   217:             
   218: W*===== A       xy_CosZetSq = xy_CosZet**2
   219:             
   220: +------>        do j = 1, jmax
   221: |+----->          do i = 0, imax-1
   222: ||          
   223: ||                  if( xy_CosZet(i,j) < 0.0_DP ) then
   224: ||V---->              do k = 1, kmax
   225: |||     A               xyz_DTempDt(i,j,k) = 0.0_DP
   226: ||V----               end do
   227: ||                  else
   228: ||                    MuFac = sqrt( ( 1224.0_DP * xy_CosZetSq(i,j) + 1.0d0 ) / 1225.0_DP )
   229: ||V---->              do k = 1, kmax
   230: |||     A               xyz_DTempDt(i,j,k) = &
   231: |||                       & qnir0 / DistFromStarScld**2 &
   232: |||                       & * sqrt( RefPress / xyz_Press(i,j,k) * MuFac ) &
   233: |||                       & / ( 1.0d0 + NLTEPress / xyz_Press(i,j,k) )
   234: ||V----               end do
   235: ||                  end if
   236: ||          
   237: |+-----           end do
   238: +------         end do
   239:             
   240: ++V==== A       xyz_DTempDt = xyz_DTempDt * DiurnalMeanFactor
   241:             
   242:             
   243:                 ! ヒストリデータ出力
   244:                 ! History data output
   245:                 !
   246:                 call HistoryAutoPut( TimeN, 'DTempDtMNIR', xyz_DTempDt )
   247:             
   248:             
   249:                 ! 計算時間計測一時停止
   250:                 ! Pause measurement of computation time
   251:                 !
   252:                 call TimesetClockStop( module_name )
   253:             
   254:               end subroutine RadMarsNIR
   255:             
   256:               !-------------------------------------------------------------------
   257:             
   258:               subroutine RadMarsNIRINOUT(  &
   259:                 & xyz_Press,                 &  ! (in   )
   260:                 & xyz_DTempDt                &  ! (inout)
   261:                 & )
   262:                 !
   263:                 ! 火星計算用近赤外加熱率計算
   264:                 !
   265:                 ! Calculation of near infrared heating rate in the case of Mars
   266:                 !
   267:                 ! Calculation schume of solar nir infrared heating rate follows
   268:                 ! that shown in Forget et al., 1999
   269:             
   270:             
   271:                 ! モジュール引用 ; USE statements
   272:                 !
   273:             
   274:             
   275:                 ! 宣言文 ; Declaration statements
   276:                 !
   277:                 implicit none
   278:             
   279:                 real(DP), intent(in   ):: xyz_Press (0:imax-1, 1:jmax, 1:kmax)
   280:                                           ! $ p $ . 気圧 (整数レベル). 
   281:                                           ! Air pressure (full level)
   282:                 real(DP), intent(inout):: xyz_DTempDt(0:imax-1, 1:jmax, 1:kmax)
   283:                                           ! 温度変化率. 
   284:                                           ! Temperature tendency
   285:             
   286:                 ! 作業変数
   287:                 ! Work variables
   288:                 !
   289:                 real(DP) :: xyz_DTempDtLocal(0:imax-1, 1:jmax, 1:kmax)
   290:             
   291:                 ! 実行文 ; Executable statement
   292:                 !
   293:             
   294:             
   295:                 ! 初期化
   296:                 ! Initialization
   297:                 !
   298:                 if ( .not. rad_Mars_NIR_inited ) then
   299:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   300:                 end if
   301:             
   302:             
   303:                 call RadMarsNIR(         &
   304:                   & xyz_Press,           &  ! (in )
   305:                   & xyz_DTempDtLocal     &  ! (out)
   306:                   & )
   307:             
   308: W**==== A       xyz_DTempDt = xyz_DTempDt + xyz_DTempDtLocal
   309:             
   310:             
   311:               end subroutine RadMarsNIRINOUT
   312:             
   313:               !-------------------------------------------------------------------
   314:             
   315:               subroutine RadMarsNIRInit
   316:                 !
   317:                 ! rad_Mars_NIR モジュールの初期化を行います. 
   318:                 ! NAMELIST#rad_Mars_NIR_nml の読み込みはこの手続きで行われます. 
   319:                 !
   320:                 ! "rad_Mars_NIR" module is initialized. 
   321:                 ! "NAMELIST#rad_Mars_NIR_nml" is loaded in this procedure. 
   322:                 !
   323:             
   324:                 ! モジュール引用 ; USE statements
   325:                 !
   326:             
   327:                 ! NAMELIST ファイル入力に関するユーティリティ
   328:                 ! Utilities for NAMELIST file input
   329:                 !
   330:                 use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid
   331:             
   332:                 ! ファイル入出力補助
   333:                 ! File I/O support
   334:                 !
   335:                 use dc_iounit, only: FileOpen
   336:             
   337:                 ! 種別型パラメタ
   338:                 ! Kind type parameter
   339:                 !
   340:                 use dc_types, only: STDOUT ! 標準出力の装置番号. Unit number of standard output
   341:             
   342:                 ! 文字列操作
   343:                 ! Character handling
   344:                 !
   345:                 use dc_string, only: StoA
   346:             
   347:                 ! ヒストリデータ出力
   348:                 ! History data output
   349:                 !
   350:                 use gtool_historyauto, only: HistoryAutoAddVariable
   351:             
   352:                 ! 座標データ設定
   353:                 ! Axes data settings
   354:                 !
   355:                 use axesset, only: &
   356:                   & AxnameX, &
   357:                   & AxnameY, &
   358:                   & AxnameZ, &
   359:                   & AxnameT
   360:             
   361:                 ! 短波入射 (太陽入射)
   362:                 ! Short wave (insolation) incoming
   363:                 !
   364:                 use rad_short_income, only : RadShortIncomeInit
   365:             
   366:                 ! 宣言文 ; Declaration statements
   367:                 !
   368:                 implicit none
   369:             
   370:                 integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号. 
   371:                                           ! Unit number for NAMELIST file open
   372:                 integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT. 
   373:                                           ! IOSTAT of NAMELIST read
   374:             
   375:                 ! NAMELIST 変数群
   376:                 ! NAMELIST group name
   377:                 !
   378:                 namelist /rad_Mars_NIR_nml/ &
   379:                   & FlagUse
   380:             
   381:                       ! デフォルト値については初期化手続 "dry_conv_adjust#DryConvAdjustInit" 
   382:                       ! のソースコードを参照のこと. 
   383:                       !
   384:                       ! Refer to source codes in the initialization procedure
   385:                       ! "dry_conv_adjust#DryConvAdjustInit" for the default values. 
   386:                       !
   387:             
   388:                 ! 実行文 ; Executable statement
   389:                 !
   390:             
   391:                 if ( rad_Mars_NIR_inited ) return
   392:             
   393:                 ! デフォルト値の設定
   394:                 ! Default values settings
   395:                 !
   396:                 FlagUse = .true.
   397:             
   398:                 ! NAMELIST の読み込み
   399:                 ! NAMELIST is input
   400:                 !
   401:                 if ( trim(namelist_filename) /= '' ) then
   402:                   call FileOpen( unit_nml, &          ! (out)
   403:                     & namelist_filename, mode = 'r' ) ! (in)
   404:             
   405:                   rewind( unit_nml )
   406:                   read( unit_nml,                &  ! (in)
   407:                     & nml = rad_Mars_NIR_nml,    &  ! (out)
   408:                     & iostat = iostat_nml )         ! (out)
   409:                   close( unit_nml )
   410:             
   411:                   call NmlutilMsg( iostat_nml, module_name ) ! (in)
   412:                 end if
   413:             
   414:             
   415:                 ! ヒストリデータ出力のためのへの変数登録
   416:                 ! Register of variables for history data output
   417:                 !
   418:                 call HistoryAutoAddVariable( 'DTempDtMNIR',    &
   419:                   & (/ AxnameX, AxnameY, AxnameZ, AxnameT /),  &
   420:                   & 'near infrared heating rate', 'K s-1' )
   421:             
   422:             
   423:             
   424:                 ! Initialization of modules used in this module
   425:                 !
   426:             
   427:                 ! 短波入射 (太陽入射)
   428:                 ! Short wave (insolation) incoming
   429:                 !
   430:                 call RadShortIncomeInit
   431:             
   432:             
   433:             
   434:                 ! 印字 ; Print
   435:                 !
   436:                 call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   437:                 call MessageNotify( 'M', module_name, '  FlagUse    = %b', l = (/ FlagUse /) )
   438:                 call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   439:             
   440:                 rad_Mars_NIR_inited = .true.
   441:             
   442:               end subroutine RadMarsNIRInit
   443:             
   444:               !-------------------------------------------------------------------
   445:             
   446:             end module rad_Mars_NIR
