Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:59 2016
FILE NAME: rad_Mars_V1.f90
PROGRAM NAME: rad_mars_v1
DIAGNOSTIC LIST

  LINE  LEVEL( NO.): DIAGNOSTIC MESSAGE

   362  opt  (1593): Loop nest collapsed into one loop.
   362  vec  (   4): Vectorized array expression.
   362  vec  (  29): ADB is used for array.: xy_lwsurfalbedo
   364  opt  (  11): Fused array assignments. :line 364 - 365
   364  opt  (1593): Loop nest collapsed into one loop.
   364  vec  (   4): Vectorized array expression.
   364  vec  (  29): ADB is used for array.: xyr_radldwflux
   364  vec  (  29): ADB is used for array.: xyr_radluwflux
   366  opt  (  11): Fused array assignments. :line 366 - 367
   366  opt  (1772): Loop nest fused with following nest(s).
   366  opt  (1593): Loop nest collapsed into one loop.
   366  vec  (   4): Vectorized array expression.
   366  vec  (  29): ADB is used for array.: xyra_delradldwflux
   366  vec  (  29): ADB is used for array.: xyra_delradluwflux
   372  opt  (1593): Loop nest collapsed into one loop.
   372  vec  (   4): Vectorized array expression.
   372  vec  (  29): ADB is used for array.: xy_surfemis
   381  vec  (   1): Vectorized loop.
   381  vec  (  29): ADB is used for array.: xy_surfemis
   381  vec  (  29): ADB is used for array.: xy_surfmajcompice
   381  vec  (  29): ADB is used for array.: xy_surftype
   407  opt  (  11): Fused array assignments. :line 407 - 408
   407  opt  (1593): Loop nest collapsed into one loop.
   407  vec  (   4): Vectorized array expression.
   407  vec  (  29): ADB is used for array.: xyz_af
   407  vec  (  29): ADB is used for array.: xyz_ssa
   410  opt  (1593): Loop nest collapsed into one loop.
   410  vec  (   4): Vectorized array expression.
   410  vec  (  29): ADB is used for array.: xyr_dod
   410  vec  (  29): ADB is used for array.: xyr_dod067
   482  opt  (1593): Loop nest collapsed into one loop.
   482  vec  (   4): Vectorized array expression.
   482  vec  (  29): ADB is used for array.: xyr_intpf
   483  opt  (  11): Fused array assignments. :line 483 - 485
   483  opt  (1593): Loop nest collapsed into one loop.
   483  vec  (   4): Vectorized array expression.
   483  vec  (  29): ADB is used for array.: xy_surfintdpfdt
   483  vec  (  29): ADB is used for array.: xy_surfintpf
   483  vec  (  29): ADB is used for array.: xy_surfemis
   512  opt  (  11): Fused array assignments. :line 512 - 513
   512  opt  (1593): Loop nest collapsed into one loop.
   512  vec  (   4): Vectorized array expression.
   512  vec  (  29): ADB is used for array.: xyr_radldwflux
   512  vec  (  29): ADB is used for array.: xyr_radldwfluxcomp
   512  vec  (  29): ADB is used for array.: xyr_radluwflux
   512  vec  (  29): ADB is used for array.: xyr_radluwfluxcomp
   514  opt  (  11): Fused array assignments. :line 514 - 515
   514  opt  (1772): Loop nest fused with following nest(s).
   514  opt  (1593): Loop nest collapsed into one loop.
   514  vec  (   4): Vectorized array expression.
   514  vec  (  29): ADB is used for array.: xyra_delradldwflux
   514  vec  (  29): ADB is used for array.: xyra_delradldwfluxcomp
   514  vec  (  29): ADB is used for array.: xyra_delradluwflux
   514  vec  (  29): ADB is used for array.: xyra_delradluwfluxcomp
   530  opt  (1593): Loop nest collapsed into one loop.
   530  vec  (   4): Vectorized array expression.
   530  vec  (  29): ADB is used for array.: xyr_radldwfluxcomp
   531  opt  (1772): Loop nest fused with following nest(s).
   531  opt  (1593): Loop nest collapsed into one loop.
   531  vec  (   4): Vectorized array expression.
   531  vec  (  29): ADB is used for array.: xyra_delradldwfluxcomp
   533  opt  (  11): Fused array assignments. :line 533 - 534
   533  opt  (1593): Loop nest collapsed into one loop.
   533  vec  (   4): Vectorized array expression.
   533  vec  (  29): ADB is used for array.: xyr_radldwflux
   533  vec  (  29): ADB is used for array.: xyr_radldwfluxcomp
   533  vec  (  29): ADB is used for array.: xyr_radluwflux
   533  vec  (  29): ADB is used for array.: xyr_radluwfluxcomp
   535  opt  (  11): Fused array assignments. :line 535 - 536
   535  opt  (1772): Loop nest fused with following nest(s).
   535  opt  (1593): Loop nest collapsed into one loop.
   535  vec  (   4): Vectorized array expression.
   535  vec  (  29): ADB is used for array.: xyra_delradldwflux
   535  vec  (  29): ADB is used for array.: xyra_delradldwfluxcomp
   535  vec  (  29): ADB is used for array.: xyra_delradluwflux
   535  vec  (  29): ADB is used for array.: xyra_delradluwfluxcomp
   548  opt  (  11): Fused array assignments. :line 548 - 549
   548  opt  (1593): Loop nest collapsed into one loop.
   548  vec  (   4): Vectorized array expression.
   548  vec  (  29): ADB is used for array.: xyz_af
   548  vec  (  29): ADB is used for array.: xyz_ssa
   551  opt  (1593): Loop nest collapsed into one loop.
   551  vec  (   4): Vectorized array expression.
   551  vec  (  29): ADB is used for array.: xyr_dod
   551  vec  (  29): ADB is used for array.: xyr_dod067
   609  opt  (1593): Loop nest collapsed into one loop.
   609  vec  (   4): Vectorized array expression.
   609  vec  (  29): ADB is used for array.: xyr_intpf
   610  opt  (  11): Fused array assignments. :line 610 - 612
   610  opt  (1593): Loop nest collapsed into one loop.
   610  vec  (   4): Vectorized array expression.
   610  vec  (  29): ADB is used for array.: xy_surfintdpfdt
   610  vec  (  29): ADB is used for array.: xy_surfintpf
   610  vec  (  29): ADB is used for array.: xy_surfemis
   625  opt  (  11): Fused array assignments. :line 625 - 626
   625  opt  (1593): Loop nest collapsed into one loop.
   625  vec  (   4): Vectorized array expression.
   625  vec  (  29): ADB is used for array.: xyr_radldwflux
   625  vec  (  29): ADB is used for array.: xyr_radldwfluxcomp
   625  vec  (  29): ADB is used for array.: xyr_radluwflux
   625  vec  (  29): ADB is used for array.: xyr_radluwfluxcomp
   627  opt  (  11): Fused array assignments. :line 627 - 628
   627  opt  (1772): Loop nest fused with following nest(s).
   627  opt  (1593): Loop nest collapsed into one loop.
   627  vec  (   4): Vectorized array expression.
   627  vec  (  29): ADB is used for array.: xyra_delradldwflux
   627  vec  (  29): ADB is used for array.: xyra_delradldwfluxcomp
   627  vec  (  29): ADB is used for array.: xyra_delradluwflux
   627  vec  (  29): ADB is used for array.: xyra_delradluwfluxcomp
   635  opt  (1593): Loop nest collapsed into one loop.
   635  vec  (   1): Vectorized loop.
   635  vec  (  29): ADB is used for array.: xyz_dustdensscledoptdep
   635  vec  (  29): ADB is used for array.: xyr_press
   635  vec  (  29): ADB is used for array.: xyr_dod067
   644  warn (  82): Name "kk" is not used.
   644  warn (  82): Name "xyz_deltrans" is not used.
   644  warn (  82): Name "xyrr_trans" is not used.
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:59 2016
FILE NAME: rad_Mars_V1.f90
PROGRAM NAME: rad_mars_v1
TRANSFORMATION LIST

  LINE                   FORTRAN STATEMENT

     1  != 火星大気向け放射モデル Ver. 1
     2  !
     3  != radiation model for the Mars' atmosphere Ver. 1
     4  !
     5  ! Authors::   Yoshiyuki O. Takahashi
     6  ! Version::   $Id: rad_Mars_V1.f90,v 1.8 2013/09/21 14:41:35 yot Exp $
     7  ! Tag Name::  $Name:  $
     8  ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9  ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10  !
    11  module rad_Mars_V1
    12    !
    13    != 火星大気向け放射モデル Ver. 1
    14    !
    15    != radiation model for the Mars' atmosphere Ver. 1
    16    !
    17    ! <b>Note that Japanese and English are described in parallel.</b>
    18    !
    19    ! 地球大気向け放射モデル.
    20    !
    21    ! This is a radiation model for the Mars' atmospehre.
    22    !
    23    ! Radiation in the wavenumber range from   40 to  2600 cm-1
    24    ! is calculated in the routine of long wave radiation.
    25    ! Radiation in the wavenumber range from 2600 to 66667 cm-1 (0.15 to 3.85 micron)
    26    ! is calculated in the routine of shortwave radiation.
    27    !
    28    !== References
    29    !
    30    !
    31    !== Procedures List
    32    !
    33  !!$  ! RadiationFluxDennouAGCM :: 放射フラックスの計算
    34  !!$  ! RadiationDTempDt        :: 放射フラックスによる温度変化の計算
    35  !!$  ! RadiationFluxOutput     :: 放射フラックスの出力
    36  !!$  ! RadiationFinalize       :: 終了処理 (モジュール内部の変数の割り付け解除)
    37  !!$  ! ------------            :: ------------
    38  !!$  ! RadiationFluxDennouAGCM :: Calculate radiation flux
    39  !!$  ! RadiationDTempDt        :: Calculate temperature tendency with radiation flux
    40  !!$  ! RadiationFluxOutput     :: Output radiation fluxes
    41  !!$  ! RadiationFinalize       :: Termination (deallocate variables in this module)
    42    !
    43    !== NAMELIST
    44    !
    45  !!$  ! NAMELIST#radiation_DennouAGCM_nml
    46    !
    47  
    48    ! USE statements
    49    !
    50  
    51    !
    52    ! Kind type parameter
    53    !
    54    use dc_types, only: DP, &      ! Double precision.
    55      &                 STRING, &  ! Strings.
    56      &                 TOKEN      ! Keywords.
    57  
    58    ! メッセージ出力
    59    ! Message output
    60    !
    61    use dc_message, only: MessageNotify
    62  
    63    ! 格子点設定
    64    ! Grid points settings
    65    !
    66    use gridset, only: imax, & ! 経度格子点数.
    67                               ! Number of grid points in longitude
    68      &                jmax, & ! 緯度格子点数.
    69                               ! Number of grid points in latitude
    70      &                kmax    ! 鉛直層数.
    71                               ! Number of vertical level
    72  
    73    implicit none
    74  
    75    private
    76  
    77  
    78    ! 公開変数
    79    ! Public variables
    80    !
    81    logical, save, public:: rad_Mars_V1_inited = .false.
    82                                ! 初期設定フラグ.
    83                                ! Initialization flag
    84  
    85    ! Private variables
    86    !
    87  
    88    logical, save :: FlagRadActiveDust
    89  
    90    real(DP), save :: SolarConst   ! Solar radiation at the distance of semi-major axis
    91  
    92    public :: RadMarsV1Init
    93    public :: RadMarsV1Flux
    94  
    95    character(*), parameter:: module_name = 'rad_Mars_V1'
    96                                ! モジュールの名称.
    97                                ! Module name
    98    character(*), parameter:: version = &
    99      & '$Name:  $' // &
   100      & '$Id: rad_Mars_V1.f90,v 1.8 2013/09/21 14:41:35 yot Exp $'
   101                                ! モジュールのバージョン
   102                                ! Module version
   103  
   104    !--------------------------------------------------------------------------------------
   105  
   106  contains
   107  
   108    !--------------------------------------------------------------------------------------
   109  
   110    subroutine RadMarsV1Flux(                                   &
   111      & xy_SurfType, xy_SurfMajCompIce,                         &
   112      & xy_SurfAlbedo,                                          &
   113      & xyz_Press, xyr_Press, xyz_Temp, xyr_Temp, xy_SurfTemp,  &
   114      & xyz_QDust,                                              &
   115      & xyr_RadSUwFlux, xyr_RadSDwFlux,                         &
   116      & xyr_RadLUwFlux, xyr_RadLDwFlux,                         &
   117      & xyra_DelRadLUwFlux, xyra_DelRadLDwFlux                  &
   118      & )
   119  
   120      ! USE statements
   121      !
   122  
   123      ! 物理・数学定数設定
   124      ! Physical and mathematical constants settings
   125      !
   126      use constants0, only: &
   127        & PI                    ! $ \pi $ .
   128                                ! 円周率.  Circular constant
   129  
   130      ! 物理定数設定
   131      ! Physical constants settings
   132      !
   133      use constants, only: &
   134        & Grav, &
   135                              ! $ g $ [m s-2].
   136                              ! 重力加速度.
   137                              ! Gravitational acceleration
   138        & GasRDry
   139  
   140      ! 雪と海氷の定数の設定
   141      ! Setting constants of snow and sea ice
   142      !
   143      use constants_snowseaice, only: &
   144        & CO2IceThreshold, &
   145        & CO2IceEmisS,     &
   146        & CO2IceEmisN
   147  
   148      ! 座標データ設定
   149      ! Axes data settings
   150      !
   151      use axesset, only: y_Lat
   152  
   153      ! 時刻管理
   154      ! Time control
   155      !
   156      use timeset, only: &
   157        & TimeN, &              ! ステップ $ t $ の時刻.
   158                                ! Time of step $ t $.
   159        & DelTime, &            ! $ \Delta t $
   160        & TimesetClockStart, TimesetClockStop
   161  
   162      ! 短波入射 (太陽入射)
   163      ! Short wave (insolation) incoming
   164      !
   165      use rad_short_income, only : RadShortIncome
   166  
   167      use rad_Mars_15m, only : RadMars15m
   168  
   169      use set_Mars_dust, only : &
   170        & SetMarsDustSetDOD067, &
   171        & SetMarsDustCalcDOD067
   172  
   173      ! 散乱を無視した放射伝達方程式
   174      ! Radiative transfer equation without considering scattering
   175      !
   176      use rad_rte_nonscat, only : RadRTENonScatWrapper
   177  
   178      !
   179      ! Solve radiative transfer equation in two stream approximation
   180      !
   181      use rad_rte_two_stream_app, only: RadRTETwoStreamAppHomogAtm, RadRTETwoStreamAppLW
   182  
   183      ! プランク関数の計算
   184      ! Calculate Planck function
   185      !
   186      use planck_func, only :                            &
   187        & Integ_PF_GQ_Array3D, Integ_PF_GQ_Array2D, Integ_DPFDT_GQ_Array2D
   188  
   189      ! ヒストリデータ出力
   190      ! History data output
   191      !
   192      use gtool_historyauto, only: HistoryAutoPut
   193  
   194  
   195      integer , intent(in ) :: xy_SurfType       (0:imax-1, 1:jmax)
   196      real(DP), intent(in ) :: xy_SurfMajCompIce (0:imax-1, 1:jmax)
   197      real(DP), intent(in ) :: xy_SurfAlbedo     (0:imax-1, 1:jmax)
   198      real(DP), intent(in ) :: xyz_Press         (0:imax-1, 1:jmax, 1:kmax)
   199      real(DP), intent(in ) :: xyr_Press         (0:imax-1, 1:jmax, 0:kmax)
   200      real(DP), intent(in ) :: xyz_Temp          (0:imax-1, 1:jmax, 1:kmax)
   201      real(DP), intent(in ) :: xyr_Temp          (0:imax-1, 1:jmax, 0:kmax)
   202      real(DP), intent(in ) :: xy_SurfTemp       (0:imax-1, 1:jmax)
   203      real(DP), intent(in ) :: xyz_QDust         (0:imax-1, 1:jmax, 1:kmax)
   204      real(DP), intent(out) :: xyr_RadSUwFlux    (0:imax-1, 1:jmax, 0:kmax)
   205      real(DP), intent(out) :: xyr_RadSDwFlux    (0:imax-1, 1:jmax, 0:kmax)
   206      real(DP), intent(out) :: xyr_RadLUwFlux    (0:imax-1, 1:jmax, 0:kmax)
   207      real(DP), intent(out) :: xyr_RadLDwFlux    (0:imax-1, 1:jmax, 0:kmax)
   208      real(DP), intent(out) :: xyra_DelRadLUwFlux(0:imax-1, 1:jmax, 0:kmax, 0:1)
   209      real(DP), intent(out) :: xyra_DelRadLDwFlux(0:imax-1, 1:jmax, 0:kmax, 0:1)
   210  
   211  
   212  
   213      real(DP), parameter :: DiffFact = 1.66_DP
   214  
   215      real(DP) :: PlanetLonFromVE
   216      real(DP) :: xyr_DOD067  (0:imax-1, 1:jmax, 0:kmax)
   217      real(DP) :: xyr_DOD     (0:imax-1, 1:jmax, 0:kmax)
   218      real(DP) :: xyz_DelTrans(0:imax-1, 1:jmax, 1:kmax)
   219      real(DP) :: xyrr_Trans  (0:imax-1, 1:jmax, 0:kmax, 0:kmax)
   220  
   221      real(DP) :: QeRat
   222      real(DP) :: SSA
   223      real(DP) :: AF
   224      real(DP) :: xyz_SSA(0:imax-1, 1:jmax, 1:kmax)
   225      real(DP) :: xyz_AF (0:imax-1, 1:jmax, 1:kmax)
   226  
   227      real(DP) :: xy_LWSurfAlbedo(0:imax-1, 1:jmax)
   228  
   229      real(DP) :: xyr_IntPF      (0:imax-1, 1:jmax, 0:kmax)
   230      real(DP) :: xy_SurfIntPF   (0:imax-1, 1:jmax)
   231      real(DP) :: xy_SurfIntDPFDT(0:imax-1, 1:jmax)
   232  
   233      real(DP) :: xyr_RadLUwFluxComp    (0:imax-1, 1:jmax, 0:kmax)
   234      real(DP) :: xyr_RadLDwFluxComp    (0:imax-1, 1:jmax, 0:kmax)
   235      real(DP) :: xyra_DelRadLUwFluxComp(0:imax-1, 1:jmax, 0:kmax, 0:1)
   236      real(DP) :: xyra_DelRadLDwFluxComp(0:imax-1, 1:jmax, 0:kmax, 0:1)
   237  
   238  
   239      real(DP) :: MajCompIceThreshold
   240      real(DP) :: MajCompIceEmis
   241      real(DP) :: xy_SurfEmis(0:imax-1, 1:jmax)
   242  
   243      real(DP) :: xy_InAngle (0:imax-1, 1:jmax)
   244      real(DP) :: DistFromStarScld
   245      real(DP) :: DiurnalMeanFactor
   246      real(DP) :: SolarFluxTOA
   247  
   248      real(DP) :: xyz_DustDensScledOptDep(0:imax-1, 1:jmax, 1:kmax)
   249  
   250      real(DP)           :: WNs
   251      real(DP)           :: WNe
   252      integer, parameter :: NumGaussNode = 5
   253  
   254      integer :: i
   255      integer :: j
   256      integer :: k
   257      integer :: kk
   258  
   259  
   260  !!$    real(DP) :: MaxError
   261  
   262  
   263  
   264      ! 初期化
   265      ! Initialization
   266      !
   267      if ( .not. rad_Mars_V1_inited ) then
   268        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   269      end if
   270  
   271  
   272      call RadShortIncome(                        &
   273        & xy_InAngle         = xy_InAngle,        & ! (out) optional
   274        & DistFromStarScld   = DistFromStarScld,  & ! (out) optional
   275        & DiurnalMeanFactor  = DiurnalMeanFactor, & ! (out) optional
   276        & PlanetLonFromVE    = PlanetLonFromVE    & ! (out) optional
   277        & )
   278      SolarFluxTOA = SolarConst / DistFromStarScld**2 * DiurnalMeanFactor
   279      PlanetLonFromVE = PlanetLonFromVE * 180.0_DP / PI
   280  
   281      !  Dust optical depth
   282      !
   283      if ( FlagRadActiveDust ) then
   284        call SetMarsDustCalcDOD067( &
   285          & xyr_Press, xyz_QDust,   & ! (in)
   286          & xyr_DOD067              & ! (out)
   287          & )
   288      else
   289        call SetMarsDustSetDOD067(                  &
   290          & PlanetLonFromVE, xyr_Press, xyz_Press,  & ! (in)
   291          & xyr_DOD067                              & ! (out)
   292          & )
   293  !!$    call SetMarsDustCalcDOD067( &
   294  !!$      & xyr_Press, xyz_QDust,   & ! (in)
   295  !!$      & xyr_DOD067              & ! (out)
   296  !!$      & )
   297      end if
   298  
   299  
   300      ! 短波放射
   301      ! Short wave radiation
   302      !
   303  
   304  
   305  !!$    QeRat   = 0.9837_DP    !   Ockert-Bell et al. (1997)
   306  !!$    xyz_SSA = 0.86_DP
   307  !!$    xyz_AF  = 0.68_DP
   308  !!$    QeRat   = 1.0_DP       !   Clancy and Lee (1991)
   309      SSA = 0.92_DP
   310      AF  = 0.55_DP
   311  
   312  
   313      call RadRTETwoStreamAppHomogAtm(                                   &
   314        & xy_SurfAlbedo, SolarFluxTOA, xy_InAngle, SSA, AF, xyr_DOD067,  & ! (in )
   315        & xyr_RadSUwFlux, xyr_RadSDwFlux                                 & ! (out)
   316        & )
   317  
   318  
   319  !!$      MaxError = 0.0_DP
   320  !!$      do k = 0, kmax
   321  !!$        do j = 1, jmax
   322  !!$          do i = 0, imax-1
   323  !!$            MaxError = max( MaxError, &
   324  !!$              & abs( OLD_xyr_RadSFlux(i,j,k) - xyr_RadSFlux(i,j,k) ) )
   325  !!$            MaxError = max( MaxError, &
   326  !!$              & abs( OLD_xyr_RadSFlux(i,j,k) - ( xyr_RadSUwFlux(i,j,k) - xyr_RadSDwFlux(i,j,k) ) ) )
   327  !!$          end do
   328  !!$        end do
   329  !!$      end do
   330  !!$      write( 6, * ) MaxError
   331  !!$      write( 6, * ) MaxError, xyr_RadSUwFlux(0,jmax/2+1,kmax)
   332  
   333  !!$      MaxError = 0.0_DP
   334  !!$      do k = 0, kmax
   335  !!$        do j = 1, jmax
   336  !!$          do i = 0, imax-1
   337  !!$            MaxError = max( MaxError, &
   338  !!$              & abs( OLD_xyr_RadLFlux(i,j,k) - xyr_RadLFlux(i,j,k) ) )
   339  !!$            MaxError = max( MaxError, &
   340  !!$              & abs( OLD_xyra_DelRadLFlux(i,j,k,0) - xyra_DelRadLFlux(i,j,k,0) ) )
   341  !!$            MaxError = max( MaxError, &
   342  !!$              & abs( OLD_xyra_DelRadLFlux(i,j,k,1) - xyra_DelRadLFlux(i,j,k,1) ) )
   343  !!$          end do
   344  !!$        end do
   345  !!$      end do
   346  !!$      write( 6, * ) MaxError
   347  !!$      !
   348  !!$      xyr_RadSFlux     = OLD_xyr_RadSFlux
   349  !!$      xyr_RadLFlux     = OLD_xyr_RadLFlux
   350  !!$      xyra_DelRadLFlux = OLD_xyra_DelRadLFlux
   351  
   352  !!$      xyr_RadSUwFlux     = OLD_xyr_RadSFlux
   353  !!$      xyr_RadSDwFlux     = 0.0_DP
   354  
   355  
   356      ! 長波放射
   357      ! Long wave radiation
   358      !
   359  
   360      !   Surface albedo for long wave is set.
   361      !
   362      xy_LWSurfAlbedo = 0.0_DP
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t784 = 1, xy_lwsurfalbedo.DSC.U2*xy_lwsurfalbedo.DSC.U1 +      
     .       1   xy_lwsurfalbedo.DSC.U2                                         
     .           xy_lwsurfalbedo(t784-1,1) = 0.0000000000000000e+000            
     .        enddo                                                             
   363  
   364      xyr_RadLUwFlux     = 0.0_DP
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t790 = 1, jmax*(kmax*imax + imax)                              
     .           xyr_radluwflux(t790-1,1,0) = 0.0000000000000000e+000           
     .           xyr_radldwflux(t790-1,1,0) = 0.0000000000000000e+000           
     .        enddo                                                             
   365      xyr_RadLDwFlux     = 0.0_DP
   366      xyra_DelRadLUwFlux = 0.0_DP
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t804 = 1, jmax*(kmax*imax + imax)                              
     .           xyra_delradluwflux(t804-1,1,0,0) = 0.0000000000000000e+000     
     .           xyra_delradldwflux(t804-1,1,0,0) = 0.0000000000000000e+000     
     .           xyra_delradluwflux(t804-1,1,0,1) = 0.0000000000000000e+000     
     .           xyra_delradldwflux(t804-1,1,0,1) = 0.0000000000000000e+000     
     .        enddo                                                             
   367      xyra_DelRadLDwFlux = 0.0_DP
   368  
   369  
   370      !  Surface emissivity
   371      !
   372      xy_SurfEmis = 1.0_DP
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t818 = 1, xy_surfemis.DSC.U2*xy_surfemis.DSC.U1 +              
     .       1   xy_surfemis.DSC.U2                                             
     .           xy_surfemis(t818-1,1) = 1.00000000000000e+000                  
     .        enddo                                                             
   373  
   374      MajCompIceThreshold = CO2IceThreshold
   375      do j = 1, jmax
   376        if ( y_Lat(j) < 0.0_DP ) then
   377          MajCompIceEmis = CO2IceEmisS
   378        else
   379          MajCompIceEmis = CO2IceEmisN
   380        end if
   381        do i = 0, imax-1
   382          if ( xy_SurfType(i,j) > 0 ) then
   383            if ( xy_SurfMajCompIce(i,j) > MajCompIceThreshold ) then
   384              xy_SurfEmis(i,j) = MajCompIceEmis
   385            else if ( xy_SurfMajCompIce(i,j) < 0.0_DP ) then
   386              xy_SurfEmis(i,j) = xy_SurfEmis(i,j)
   387            else
   388              xy_SurfEmis(i,j) =                                    &
   389                &   ( MajCompIceEmis         - xy_SurfEmis(i,j) )   &
   390                & / ( MajCompIceThreshold    - 0.0_DP           )   &
   391                & * ( xy_SurfMajCompIce(i,j) - 0.0_DP           )   &
   392                & + xy_SurfEmis(i,j)
   393            end if
   394          end if
   395        end do
     .  !cdir nodep                                                             
     .        do i = 1, imax                                                    
     .           if (xy_surftype(i-1,j) .gt. 0) then                            
     .              if (xy_surfmajcompice(i-1,j) .gt. majcompicethreshold) then 
     .                 xy_surfemis(i-1,j) = majcompiceemis                      
     .              else                                                        
     .                 if (xy_surfmajcompice(i-1,j) .ge. 0.0000000000000000e+000
     .       1            ) then                                                
     .                    xy_surfemis(i-1,j) = (majcompiceemis - xy_surfemis(i-1
     .       1               ,j))/(majcompicethreshold - 0.0000000000000000e+000
     .       2               )*(xy_surfmajcompice(i-1,j)-0.0000000000000000e+000
     .       3               ) + xy_surfemis(i-1,j)                             
     .                 endif                                                    
     .              endif                                                       
     .           endif                                                          
     .        enddo                                                             
   396      end do
   397  
   398  
   399      !    Flux from 0 to 500 cm-1
   400      !
   401      WNs     =   0.0d2
   402      WNe     = 500.0d2
   403      QeRat   = 0.17_DP                       ! Wavenumber averaged extinction coefficient
   404      SSA     = 0.35_DP
   405      AF      = 0.36_DP
   406  
   407      xyz_SSA = SSA
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t824 = 1, xyz_ssa.DSC.U3*(xyz_ssa.DSC.U2*xyz_ssa.DSC.U1 +      
     .       1   xyz_ssa.DSC.U2)                                                
     .           xyz_ssa(t824-1,1,1) = ssa                                      
     .           xyz_af(t824-1,1,1) = af                                        
     .        enddo                                                             
   408      xyz_AF  = AF
   409  
   410      xyr_DOD = QeRat * xyr_DOD067
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t836 = 1, (xyr_dod067.DSC.U3 + 1)*xyr_dod067.DSC.U2*(          
     .       1   xyr_dod067.DSC.U1 + 1)                                         
     .           xyr_dod(t836-1,1,0) = qerat*xyr_dod067(t836-1,1,0)             
     .        enddo                                                             
   411  
   412      !----------
   413      !    Modification of dust optical depth for use in non-scattering calculation
   414  !!$    xyr_DOD = ( 1.0_DP - SSA ) * xyr_DOD
   415      !
   416  !!$    do k = 1, kmax
   417  !!$      xyz_DelTrans(:,:,k) = exp( - DiffFact * ( xyr_DOD(:,:,k-1) - xyr_DOD(:,:,k) ) )
   418  !!$    end do
   419  !!$    !
   420  !!$    do k = 0, kmax
   421  !!$      do kk = k, k
   422  !!$        xyrr_Trans(:,:,k,kk) = 1.0_DP
   423  !!$      end do
   424  !!$      do kk = k+1, kmax
   425  !!$        xyrr_Trans(:,:,k,kk) = xyrr_Trans(:,:,k,kk-1) * xyz_DelTrans(:,:,kk)
   426  !!$      end do
   427  !!$    end do
   428  !!$    do k = 0, kmax
   429  !!$      do kk = 0, k-1
   430  !!$        xyrr_Trans(:,:,k,kk) = xyrr_Trans(:,:,kk,k)
   431  !!$      end do
   432  !!$    end do
   433  !!$    !
   434  !!$    call RadRTENonScatWrapper(                          &
   435  !!$      & xyz_Temp, xy_SurfTemp, xy_SurfEmis, xyrr_Trans, & ! (in )
   436  !!$      & xyr_RadLUwFluxComp, xyr_RadLDwFluxComp,         & ! (out)
   437  !!$      & xyra_DelRadLUwFluxComp, xyra_DelRadLDwFluxComp, & ! (out)
   438  !!$      & WNs, WNe, NumGaussNode                          & ! (in ) optional
   439  !!$      & )
   440  
   441      !----------
   442  
   443  !!$    i = 0
   444  !!$    j = jmax/2+1
   445  !!$    do k = 0, kmax
   446  !!$      write( 70, * ) k, &
   447  !!$        & xyr_RadLUwFluxComp(i,j,k), &
   448  !!$        & xyr_RadLDwFluxComp(i,j,k), &
   449  !!$        & xyra_DelRadLUwFluxComp(i,j,k,0), &
   450  !!$        & xyra_DelRadLUwFluxComp(i,j,k,1), &
   451  !!$        & xyra_DelRadLDwFluxComp(i,j,k,0), &
   452  !!$        & xyra_DelRadLDwFluxComp(i,j,k,1)
   453  !!$    end do
   454  !!$    call flush( 70 )
   455  
   456  
   457      ! Integrate Planck function and temperature derivative of it
   458      !
   459      call Integ_PF_GQ_Array3D(        &
   460        & WNs, WNe, NumGaussNode,      &
   461        & 0, imax-1, 1, jmax, 0, kmax, &
   462        & xyr_Temp,                    &
   463        & xyr_IntPF                    &
   464        & )
   465      call Integ_PF_GQ_Array2D(        &
   466        & WNs, WNe, NumGaussNode,      &
   467        & 0, imax-1, 1, jmax,          &
   468        & xy_SurfTemp,                 &
   469        & xy_SurfIntPF                 &
   470        & )
   471  !    call Integ_DPFDT_GQ_Array2D(             &
   472  !      & WNs, WNe, NumGaussNode,              & ! (in )
   473  !      & 0, imax-1, 1, jmax, xyz_Temp(:,:,1), & ! (in )
   474  !      & xy_IntDPFDT1                         & ! (out)
   475  !      & )
   476      call Integ_DPFDT_GQ_Array2D(         &
   477        & WNs, WNe, NumGaussNode,          & ! (in )
   478        & 0, imax-1, 1, jmax, xy_SurfTemp, & ! (in )
   479        & xy_SurfIntDPFDT                  & ! (out)
   480        & )
   481      !
   482      xyr_IntPF       =               PI * xyr_IntPF
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t848 = 1, (xyr_intpf.DSC.U3 + 1)*xyr_intpf.DSC.U2*(            
     .       1   xyr_intpf.DSC.U1 + 1)                                          
     .           xyr_intpf(t848-1,1,0) = 3.14159265358979e+000*xyr_intpf(t848-1,
     .       1      1,0)                                                        
     .        enddo                                                             
   483      xy_SurfIntPF    = xy_SurfEmis * PI * xy_SurfIntPF
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t860 = 1, xy_surfemis.DSC.U2*xy_surfemis.DSC.U1 +              
     .       1   xy_surfemis.DSC.U2                                             
     .           xy_surfintpf(t860-1,1) = (xy_surfemis(t860-1,1)*               
     .       1      3.14159265358979e+000)*xy_surfintpf(t860-1,1)               
     .           xy_surfintdpfdt(t860-1,1) = (xy_surfemis(t860-1,1)*            
     .       1      3.14159265358979e+000)*xy_surfintdpfdt(t860-1,1)            
     .        enddo                                                             
   484  !    xy_IntDPFDT1    =               PI * xy_IntDPFDT1
   485      xy_SurfIntDPFDT = xy_SurfEmis * PI * xy_SurfIntDPFDT
   486      !
   487      call RadRTETwoStreamAppLW(                          &
   488        & xyz_SSA, xyz_AF,                                & ! (in)
   489        & xyr_DOD,                                        & ! (in)
   490        & xy_LWSurfAlbedo,                                & ! (in)
   491        & xyr_IntPF, xy_SurfIntPF, xy_SurfIntDPFDT,       & ! (in)
   492        & xyr_RadLUwFluxComp, xyr_RadLDwFluxComp,         & ! (out)
   493        & xyra_DelRadLUwFluxComp, xyra_DelRadLDwFluxComp  & ! (out)
   494        & )
   495  
   496  !!$    i = 0
   497  !!$    j = jmax/2+1
   498  !!$    do k = 0, kmax
   499  !!$      write( 80, * ) k, &
   500  !!$        & xyr_RadLUwFluxComp(i,j,k), &
   501  !!$        & xyr_RadLDwFluxComp(i,j,k), &
   502  !!$        & xyra_DelRadLUwFluxComp(i,j,k,0), &
   503  !!$        & xyra_DelRadLUwFluxComp(i,j,k,1), &
   504  !!$        & xyra_DelRadLDwFluxComp(i,j,k,0), &
   505  !!$        & xyra_DelRadLDwFluxComp(i,j,k,1)
   506  !!$    end do
   507  !!$    call flush( 80 )
   508  !!$    stop
   509  
   510      !----------
   511  
   512      xyr_RadLUwFlux     = xyr_RadLUwFlux     + xyr_RadLUwFluxComp
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t876 = 1, jmax*(kmax*imax + imax)                              
     .           xyr_radluwflux(t876-1,1,0) = xyr_radluwflux(t876-1,1,0) +      
     .       1      xyr_radluwfluxcomp(t876-1,1,0)                              
     .           xyr_radldwflux(t876-1,1,0) = xyr_radldwflux(t876-1,1,0) +      
     .       1      xyr_radldwfluxcomp(t876-1,1,0)                              
     .        enddo                                                             
   513      xyr_RadLDwFlux     = xyr_RadLDwFlux     + xyr_RadLDwFluxComp
   514      xyra_DelRadLUwFlux = xyra_DelRadLUwFlux + xyra_DelRadLUwFluxComp
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t902 = 1, jmax*(kmax*imax + imax)                              
     .           xyra_delradluwflux(t902-1,1,0,0) = xyra_delradluwflux(t902-1,1,
     .       1      0,0) + xyra_delradluwfluxcomp(t902-1,1,0,0)                 
     .           xyra_delradldwflux(t902-1,1,0,0) = xyra_delradldwflux(t902-1,1,
     .       1      0,0) + xyra_delradldwfluxcomp(t902-1,1,0,0)                 
     .           xyra_delradluwflux(t902-1,1,0,1) = xyra_delradluwflux(t902-1,1,
     .       1      0,1) + xyra_delradluwfluxcomp(t902-1,1,0,1)                 
     .           xyra_delradldwflux(t902-1,1,0,1) = xyra_delradldwflux(t902-1,1,
     .       1      0,1) + xyra_delradldwfluxcomp(t902-1,1,0,1)                 
     .        enddo                                                             
   515      xyra_DelRadLDwFlux = xyra_DelRadLDwFlux + xyra_DelRadLDwFluxComp
   516  
   517  
   518  
   519      !    Flux from 500 to 850 cm-1
   520      !
   521  
   522      QeRat = 0.25_DP                      ! Wavenumber averaged extinction coefficient
   523      SSA   = 0.45_DP                      ! Wavenumber averaged single scattering albedo
   524  
   525      call RadMars15m( TimeN, DelTime, &
   526        & xyz_Temp, xyr_Press, xyz_Press, xy_SurfTemp, &
   527        & xyr_DOD067, QeRat, SSA, xy_SurfEmis, &
   528        & xyr_RadLUwFluxComp, xyra_DelRadLUwFluxComp &
   529        & )
   530      xyr_RadLDwFluxComp     = 0.0_DP
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t932 = 1, (xyr_radldwfluxcomp.DSC.U3 + 1)*                     
     .       1   xyr_radldwfluxcomp.DSC.U2*(xyr_radldwfluxcomp.DSC.U1 + 1)      
     .           xyr_radldwfluxcomp(t932-1,1,0) = 0.0000000000000000e+000       
     .        enddo                                                             
   531      xyra_DelRadLDwFluxComp = 0.0_DP
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t943 = 1, (xyra_delradldwfluxcomp.DSC.U3 + 1)*                 
     .       1   xyra_delradldwfluxcomp.DSC.U2*(xyra_delradldwfluxcomp.DSC.U1 + 
     .       2   1)                                                             
     .           xyra_delradldwfluxcomp(t943-1,1,0,0) = 0.0000000000000000e+000 
     .           xyra_delradldwfluxcomp(t943-1,1,0,1) = 0.0000000000000000e+000 
     .        enddo                                                             
   532  
   533      xyr_RadLUwFlux     = xyr_RadLUwFlux     + xyr_RadLUwFluxComp
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t953 = 1, jmax*(kmax*imax + imax)                              
     .           xyr_radluwflux(t953-1,1,0) = xyr_radluwflux(t953-1,1,0) +      
     .       1      xyr_radluwfluxcomp(t953-1,1,0)                              
     .           xyr_radldwflux(t953-1,1,0) = xyr_radldwflux(t953-1,1,0) +      
     .       1      xyr_radldwfluxcomp(t953-1,1,0)                              
     .        enddo                                                             
   534      xyr_RadLDwFlux     = xyr_RadLDwFlux     + xyr_RadLDwFluxComp
   535      xyra_DelRadLUwFlux = xyra_DelRadLUwFlux + xyra_DelRadLUwFluxComp
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t979 = 1, jmax*(kmax*imax + imax)                              
     .           xyra_delradluwflux(t979-1,1,0,0) = xyra_delradluwflux(t979-1,1,
     .       1      0,0) + xyra_delradluwfluxcomp(t979-1,1,0,0)                 
     .           xyra_delradldwflux(t979-1,1,0,0) = xyra_delradldwflux(t979-1,1,
     .       1      0,0) + xyra_delradldwfluxcomp(t979-1,1,0,0)                 
     .           xyra_delradluwflux(t979-1,1,0,1) = xyra_delradluwflux(t979-1,1,
     .       1      0,1) + xyra_delradluwfluxcomp(t979-1,1,0,1)                 
     .           xyra_delradldwflux(t979-1,1,0,1) = xyra_delradldwflux(t979-1,1,
     .       1      0,1) + xyra_delradldwfluxcomp(t979-1,1,0,1)                 
     .        enddo                                                             
   536      xyra_DelRadLDwFlux = xyra_DelRadLDwFlux + xyra_DelRadLDwFluxComp
   537  
   538  
   539  
   540      !    Flux from 850 to 2000 cm-1
   541      !
   542      WNs     =  850.0d2
   543      WNe     = 2000.0d2
   544      QeRat   =    0.41_DP                    ! Wavenumber averaged extinction coefficient
   545      SSA     = 0.55_DP
   546      AF      = 0.55_DP
   547  
   548      xyz_SSA = SSA
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1009 = 1, xyz_ssa.DSC.U3*(xyz_ssa.DSC.U2*xyz_ssa.DSC.U1 +     
     .       1   xyz_ssa.DSC.U2)                                                
     .           xyz_ssa(t1009-1,1,1) = ssa                                     
     .           xyz_af(t1009-1,1,1) = af                                       
     .        enddo                                                             
   549      xyz_AF  = AF
   550  
   551      xyr_DOD = QeRat * xyr_DOD067
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1021 = 1, (xyr_dod067.DSC.U3 + 1)*xyr_dod067.DSC.U2*(         
     .       1   xyr_dod067.DSC.U1 + 1)                                         
     .           xyr_dod(t1021-1,1,0) = qerat*xyr_dod067(t1021-1,1,0)           
     .        enddo                                                             
   552  
   553      !----------
   554      !    Modification of dust optical depth for use in non-scattering calculation
   555  !!$    xyr_DOD = ( 1.0_DP - SSA ) * xyr_DOD
   556      !
   557  !!$    do k = 1, kmax
   558  !!$      xyz_DelTrans(:,:,k) = exp( - DiffFact * ( xyr_DOD(:,:,k-1) - xyr_DOD(:,:,k) ) )
   559  !!$    end do
   560  !!$    !
   561  !!$    do k = 0, kmax
   562  !!$      do kk = k, k
   563  !!$        xyrr_Trans(:,:,k,kk) = 1.0_DP
   564  !!$      end do
   565  !!$      do kk = k+1, kmax
   566  !!$        xyrr_Trans(:,:,k,kk) = xyrr_Trans(:,:,k,kk-1) * xyz_DelTrans(:,:,kk)
   567  !!$      end do
   568  !!$    end do
   569  !!$    do k = 0, kmax
   570  !!$      do kk = 0, k-1
   571  !!$        xyrr_Trans(:,:,k,kk) = xyrr_Trans(:,:,kk,k)
   572  !!$      end do
   573  !!$    end do
   574  !!$    !
   575  !!$    call RadRTENonScatWrapper(                          &
   576  !!$      & xyz_Temp, xy_SurfTemp, xy_SurfEmis, xyrr_Trans, & ! (in )
   577  !!$      & xyr_RadLUwFluxComp, xyr_RadLDwFluxComp,         & ! (out)
   578  !!$      & xyra_DelRadLUwFluxComp, xyra_DelRadLDwFluxComp, & ! (out)
   579  !!$      & WNs, WNe, NumGaussNode                          & ! (in ) optional
   580  !!$      & )
   581      !----------
   582  
   583  
   584      ! Integrate Planck function and temperature derivative of it
   585      !
   586      call Integ_PF_GQ_Array3D(        &
   587        & WNs, WNe, NumGaussNode,      &
   588        & 0, imax-1, 1, jmax, 0, kmax, &
   589        & xyr_Temp,                    &
   590        & xyr_IntPF                    &
   591        & )
   592      call Integ_PF_GQ_Array2D(        &
   593        & WNs, WNe, NumGaussNode,      &
   594        & 0, imax-1, 1, jmax,          &
   595        & xy_SurfTemp,                 &
   596        & xy_SurfIntPF                 &
   597        & )
   598  !    call Integ_DPFDT_GQ_Array2D(             &
   599  !      & WNs, WNe, NumGaussNode,              & ! (in )
   600  !      & 0, imax-1, 1, jmax, xyz_Temp(:,:,1), & ! (in )
   601  !      & xy_IntDPFDT1                         & ! (out)
   602  !      & )
   603      call Integ_DPFDT_GQ_Array2D(         &
   604        & WNs, WNe, NumGaussNode,          & ! (in )
   605        & 0, imax-1, 1, jmax, xy_SurfTemp, & ! (in )
   606        & xy_SurfIntDPFDT                  & ! (out)
   607        & )
   608      !
   609      xyr_IntPF       =               PI * xyr_IntPF
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1033 = 1, (xyr_intpf.DSC.U3 + 1)*xyr_intpf.DSC.U2*(           
     .       1   xyr_intpf.DSC.U1 + 1)                                          
     .           xyr_intpf(t1033-1,1,0) = 3.14159265358979e+000*xyr_intpf(t1033-
     .       1      1,1,0)                                                      
     .        enddo                                                             
   610      xy_SurfIntPF    = xy_SurfEmis * PI * xy_SurfIntPF
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1045 = 1, xy_surfemis.DSC.U2*xy_surfemis.DSC.U1 +             
     .       1   xy_surfemis.DSC.U2                                             
     .           xy_surfintpf(t1045-1,1) = (xy_surfemis(t1045-1,1)*             
     .       1      3.14159265358979e+000)*xy_surfintpf(t1045-1,1)              
     .           xy_surfintdpfdt(t1045-1,1) = (xy_surfemis(t1045-1,1)*          
     .       1      3.14159265358979e+000)*xy_surfintdpfdt(t1045-1,1)           
     .        enddo                                                             
   611  !    xy_IntDPFDT1    =               PI * xy_IntDPFDT1
   612      xy_SurfIntDPFDT = xy_SurfEmis * PI * xy_SurfIntDPFDT
   613      !
   614      call RadRTETwoStreamAppLW(                          &
   615        & xyz_SSA, xyz_AF,                                & ! (in)
   616        & xyr_DOD,                                        & ! (in)
   617        & xy_LWSurfAlbedo,                                & ! (in)
   618        & xyr_IntPF, xy_SurfIntPF, xy_SurfIntDPFDT,       & ! (in)
   619        & xyr_RadLUwFluxComp, xyr_RadLDwFluxComp,         & ! (out)
   620        & xyra_DelRadLUwFluxComp, xyra_DelRadLDwFluxComp  & ! (out)
   621        & )
   622  
   623      !----------
   624  
   625      xyr_RadLUwFlux     = xyr_RadLUwFlux     + xyr_RadLUwFluxComp
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1061 = 1, jmax*(kmax*imax + imax)                             
     .           xyr_radluwflux(t1061-1,1,0) = xyr_radluwflux(t1061-1,1,0) +    
     .       1      xyr_radluwfluxcomp(t1061-1,1,0)                             
     .           xyr_radldwflux(t1061-1,1,0) = xyr_radldwflux(t1061-1,1,0) +    
     .       1      xyr_radldwfluxcomp(t1061-1,1,0)                             
     .        enddo                                                             
   626      xyr_RadLDwFlux     = xyr_RadLDwFlux     + xyr_RadLDwFluxComp
   627      xyra_DelRadLUwFlux = xyra_DelRadLUwFlux + xyra_DelRadLUwFluxComp
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1087 = 1, jmax*(kmax*imax + imax)                             
     .           xyra_delradluwflux(t1087-1,1,0,0) = xyra_delradluwflux(t1087-1,
     .       1      1,0,0) + xyra_delradluwfluxcomp(t1087-1,1,0,0)              
     .           xyra_delradldwflux(t1087-1,1,0,0) = xyra_delradldwflux(t1087-1,
     .       1      1,0,0) + xyra_delradldwfluxcomp(t1087-1,1,0,0)              
     .           xyra_delradluwflux(t1087-1,1,0,1) = xyra_delradluwflux(t1087-1,
     .       1      1,0,1) + xyra_delradluwfluxcomp(t1087-1,1,0,1)              
     .           xyra_delradldwflux(t1087-1,1,0,1) = xyra_delradldwflux(t1087-1,
     .       1      1,0,1) + xyra_delradldwfluxcomp(t1087-1,1,0,1)              
     .        enddo                                                             
   628      xyra_DelRadLDwFlux = xyra_DelRadLDwFlux + xyra_DelRadLDwFluxComp
   629  
   630  
   631  
   632      ! Output variables
   633      !
   634      call HistoryAutoPut( TimeN, 'DOD067', xyr_DOD067 )
   635      do k = 1, kmax
   636        xyz_DustDensScledOptDep(:,:,k) =                  &
   637          &   ( xyr_DOD067(:,:,k-1) - xyr_DOD067(:,:,k) ) &
   638          & / ( xyr_Press (:,:,k-1) - xyr_Press (:,:,k) ) &
   639          & * Grav
   640      end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do k = 1, kmax*(xyr_dod067.DSC.U2*xyr_dod067.DSC.U1 +             
     .       1   xyr_dod067.DSC.U2)                                             
     .           xyz_dustdensscledoptdep(k-1,1,1) = (xyr_dod067(k-1,1,0)-       
     .       1      xyr_dod067(k-1,1,1))/(xyr_press(k-1,1,0)-xyr_press(k-1,1,1))
     .       2      *grav                                                       
     .        enddo                                                             
   641      call HistoryAutoPut( TimeN, 'DustDensScledOptDep', xyz_DustDensScledOptDep )
   642  
   643  
   644    end subroutine RadMarsV1Flux
   645  
   646    !-------------------------------------------------------------------
   647    ! This subroutine will be deleted in future.
   648    !
   649  !!$
   650  !!$  subroutine RadiationRTEQNonScat(                    &
   651  !!$    & WNs, WNe, NumGaussNode,                         & ! (in)
   652  !!$    & xyz_Temp, xy_SurfTemp, xy_SurfEmis, xyr_OptDep, & ! (in)
   653  !!$    & xyr_RadLFlux, xyra_DelRadLFlux                  & ! (out)
   654  !!$    & )
   655  !!$    !
   656  !!$    ! 散乱なしの場合の放射伝達方程式の計算
   657  !!$    !
   658  !!$    ! Integrate radiative transfer equation without scattering
   659  !!$    !
   660  !!$
   661  !!$    ! モジュール引用 ; USE statements
   662  !!$    !
   663  !!$
   664  !!$    ! 物理定数設定
   665  !!$    ! Physical constants settings
   666  !!$    !
   667  !!$    use constants, only: PI
   668  !!$
   669  !!$    ! プランク関数の計算
   670  !!$    ! Calculate Planck function
   671  !!$    !
   672  !!$    use planck_func, only :                            &
   673  !!$      & Integ_PF_GQ_Array3D   , Integ_PF_GQ_Array2D,   &
   674  !!$      & Integ_DPFDT_GQ_Array3D, Integ_DPFDT_GQ_Array2D
   675  !!$
   676  !!$    ! 宣言文 ; Declaration statements
   677  !!$    !
   678  !!$
   679  !!$    real(DP), intent(in ):: WNs
   680  !!$    real(DP), intent(in ):: WNe
   681  !!$    integer,  intent(in ):: NumGaussNode
   682  !!$    real(DP), intent(in ):: xyz_Temp    (0:imax-1, 1:jmax, 1:kmax)
   683  !!$                              ! $ T $ .     温度. Temperature
   684  !!$    real(DP), intent(in ):: xy_SurfTemp (0:imax-1, 1:jmax)
   685  !!$                              ! 地表面温度.
   686  !!$                              ! Surface temperature
   687  !!$    real(DP), intent(in ):: xy_SurfEmis (0:imax-1, 1:jmax)
   688  !!$                              ! 惑星表面射出率.
   689  !!$                              ! Surface emissivity
   690  !!$    real(DP), intent(in ):: xyr_OptDep  (0:imax-1, 1:jmax, 0:kmax)
   691  !!$                              ! Optical depth
   692  !!$    real(DP), intent(out):: xyr_RadLFlux (0:imax-1, 1:jmax, 0:kmax)
   693  !!$                              ! 長波フラックス.
   694  !!$                              ! Longwave flux
   695  !!$    real(DP), intent(out):: xyra_DelRadLFlux (0:imax-1, 1:jmax, 0:kmax, 0:1)
   696  !!$                              ! 長波地表温度変化.
   697  !!$                              ! Surface temperature tendency with longwave
   698  !!$
   699  !!$    ! 作業変数
   700  !!$    ! Work variables
   701  !!$    !
   702  !!$    real(DP), parameter :: DiffFact = 1.66_DP
   703  !!$
   704  !!$    real(DP):: xyz_DelTrans (0:imax-1, 1:jmax, 1:kmax)
   705  !!$    real(DP):: xyrr_Trans   (0:imax-1, 1:jmax, 0:kmax, 0:kmax)
   706  !!$                              ! 透過係数.
   707  !!$                              ! Transmission coefficient
   708  !!$    real(DP):: xyz_IntPF      (0:imax-1, 1:jmax, 1:kmax)
   709  !!$                              ! Integrated Planck function
   710  !!$    real(DP):: xy_SurfIntPF   (0:imax-1, 1:jmax)
   711  !!$                              ! Integrated Planck function with surface temperature
   712  !!$    real(DP):: xyz_IntDPFDT   (0:imax-1, 1:jmax, 1:kmax)
   713  !!$                              ! Integrated temperature derivative of Planck function
   714  !!$    real(DP):: xy_SurfIntDPFDT(0:imax-1, 1:jmax)
   715  !!$                              ! Integrated temperature derivative of Planck function
   716  !!$                              ! with surface temperature
   717  !!$
   718  !!$    integer:: k, kk           ! 鉛直方向に回る DO ループ用作業変数
   719  !!$                              ! Work variables for DO loop in vertical direction
   720  !!$
   721  !!$    ! 実行文 ; Executable statement
   722  !!$    !
   723  !!$
   724  !!$    ! 初期化
   725  !!$    ! Initialization
   726  !!$    !
   727  !!$    if ( .not. radiation_dcpam_M_V1_inited ) call RadiationDcpamMV1Init
   728  !!$
   729  !!$    ! Integrate Planck function and temperature derivative of it
   730  !!$    !
   731  !!$    call Integ_PF_GQ_Array3D( &
   732  !!$      & WNs, WNe, NumGaussNode, &
   733  !!$      & 0, imax-1, 1, jmax, 1, kmax, &
   734  !!$      & xyz_Temp, &
   735  !!$      & xyz_IntPF &
   736  !!$      & )
   737  !!$    call Integ_PF_GQ_Array2D( &
   738  !!$      & WNs, WNe, NumGaussNode, &
   739  !!$      & 0, imax-1, 1, jmax, &
   740  !!$      & xy_SurfTemp, &
   741  !!$      & xy_SurfIntPF &
   742  !!$      & )
   743  !!$    call Integ_DPFDT_GQ_Array3D( &
   744  !!$      & 0, imax-1, 1, jmax, 1, kmax, &
   745  !!$      & WNs, WNe, NumGaussNode, xyz_Temp, & ! (in )
   746  !!$      & xyz_IntDPFDT          & ! (out)
   747  !!$      & )
   748  !!$    call Integ_DPFDT_GQ_Array2D( &
   749  !!$      & 0, imax-1, 1, jmax, &
   750  !!$      & WNs, WNe, NumGaussNode, xy_SurfTemp, & ! (in )
   751  !!$      & xy_SurfIntDPFDT           & ! (out)
   752  !!$      & )
   753  !!$
   754  !!$
   755  !!$    ! 透過関数計算
   756  !!$    ! Calculate transmission functions
   757  !!$    !
   758  !!$    do k = 1, kmax
   759  !!$      xyz_DelTrans(:,:,k) = &
   760  !!$        & exp( - DiffFact * ( xyr_OptDep(:,:,k-1) - xyr_OptDep(:,:,k) ) )
   761  !!$    end do
   762  !!$    !
   763  !!$    do k = 0, kmax
   764  !!$      do kk = k, k
   765  !!$        xyrr_Trans(:,:,k,kk) = 1.0_DP
   766  !!$      end do
   767  !!$      do kk = k+1, kmax
   768  !!$        xyrr_Trans(:,:,k,kk) = xyrr_Trans(:,:,k,kk-1) * xyz_DelTrans(:,:,kk)
   769  !!$      end do
   770  !!$    end do
   771  !!$    do k = 0, kmax
   772  !!$      do kk = 0, k-1
   773  !!$        xyrr_Trans(:,:,k,kk) = xyrr_Trans(:,:,kk,k)
   774  !!$      end do
   775  !!$    end do
   776  !!$
   777  !!$
   778  !!$    ! 放射フラックス計算
   779  !!$    ! Calculate radiation flux
   780  !!$    !
   781  !!$    do k = 0, kmax
   782  !!$
   783  !!$      xyr_RadLFlux(:,:,k) = xy_SurfEmis * PI * xy_SurfIntPF * xyrr_Trans(:,:,k,0)
   784  !!$
   785  !!$      do kk = 0, kmax-1
   786  !!$        xyr_RadLFlux(:,:,k) = xyr_RadLFlux(:,:,k)                &
   787  !!$          & - PI * xyz_IntPF(:,:,kk+1)                           &
   788  !!$          & * ( xyrr_Trans(:,:,k,kk) - xyrr_Trans(:,:,k,kk+1) )
   789  !!$      end do
   790  !!$
   791  !!$    end do
   792  !!$
   793  !!$
   794  !!$    ! 放射フラックスの変化率の計算
   795  !!$    ! Calculate rate of change of radiative flux
   796  !!$    !
   797  !!$    do k = 0, kmax
   798  !!$      xyra_DelRadLFlux(:,:,k,0) =                           &
   799  !!$        & xy_SurfEmis * xy_SurfIntDPFDT * xyrr_Trans(:,:,k,0)
   800  !!$
   801  !!$      xyra_DelRadLFlux(:,:,k,1) =                           &
   802  !!$        & xyz_IntDPFDT(:,:,1)                               &
   803  !!$        &   * ( xyrr_Trans(:,:,k,1) - xyrr_Trans(:,:,k,0) )
   804  !!$    end do
   805  !!$
   806  !!$
   807  !!$  end subroutine RadiationRTEQNonScat
   808  !!$
   809    !-------------------------------------------------------------------
   810  
   811    subroutine RadMarsV1Init
   812  
   813      ! ファイル入出力補助
   814      ! File I/O support
   815      !
   816      use dc_iounit, only: FileOpen
   817  
   818      ! NAMELIST ファイル入力に関するユーティリティ
   819      ! Utilities for NAMELIST file input
   820      !
   821      use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid
   822  
   823      ! ヒストリデータ出力
   824      ! History data output
   825      !
   826      use gtool_historyauto, only: HistoryAutoAddVariable
   827  
   828      ! 座標データ設定
   829      ! Axes data settings
   830      !
   831      use axesset, only: &
   832        & AxnameX, &
   833        & AxnameY, &
   834        & AxnameZ, &
   835        & AxnameR, &
   836        & AxnameT
   837  
   838      ! 短波入射 (太陽入射)
   839      ! Short wave (insolation) incoming
   840      !
   841      use rad_short_income, only : RadShortIncomeInit
   842  
   843      ! 散乱を無視した放射伝達方程式
   844      ! Radiative transfer equation without considering scattering
   845      !
   846      use rad_rte_nonscat, only : RadRTENonScatInit
   847  
   848      !
   849      ! Solve radiative transfer equation in two stream approximation
   850      !
   851      use rad_rte_two_stream_app, only: RadRTETwoStreamAppInit
   852  
   853      use rad_Mars_15m, only : RadMars15mInit
   854  
   855      use set_Mars_dust, only : SetMarsDustInit
   856  
   857      ! 宣言文 ; Declaration statements
   858      !
   859  
   860      integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号.
   861                                ! Unit number for NAMELIST file open
   862      integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT.
   863                                ! IOSTAT of NAMELIST read
   864  
   865      ! NAMELIST 変数群
   866      ! NAMELIST group name
   867      !
   868      namelist /rad_Mars_V1_nml/ &
   869        & SolarConst,            &
   870        & FlagRadActiveDust
   871            !
   872            ! デフォルト値については初期化手続 "rad_Mars_V1#RadMarsV1Init"
   873            ! のソースコードを参照のこと.
   874            !
   875            ! Refer to source codes in the initialization procedure
   876            ! "rad_Mars_V1#RadMarsV1Init" for the default values.
   877            !
   878  
   879      if ( rad_Mars_V1_inited ) return
   880  
   881      ! デフォルト値の設定
   882      ! Default values settings
   883      !
   884      SolarConst        = 1380.0_DP / 1.52_DP**2
   885  
   886      FlagRadActiveDust = .false.
   887  
   888  
   889      ! NAMELIST の読み込み
   890      ! NAMELIST is input
   891      !
   892      if ( trim(namelist_filename) /= '' ) then
   893        call FileOpen( unit_nml, &          ! (out)
   894          & namelist_filename, mode = 'r' ) ! (in)
   895  
   896        rewind( unit_nml )
   897        read( unit_nml,                     & ! (in)
   898          & nml = rad_Mars_V1_nml,          & ! (out)
   899          & iostat = iostat_nml )             ! (out)
   900        close( unit_nml )
   901  
   902        call NmlutilMsg( iostat_nml, module_name ) ! (in)
   903      end if
   904  
   905  
   906      ! Initialization of modules used in this module
   907      !
   908  
   909      ! 短波入射 (太陽入射)
   910      ! Short wave (insolation) incoming
   911      !
   912      call RadShortIncomeInit
   913  
   914      ! 散乱を無視した放射伝達方程式
   915      ! Radiative transfer equation without considering scattering
   916      !
   917      call RadRTENonScatInit
   918  
   919      !
   920      ! Solve radiative transfer equation in two stream approximation
   921      !
   922      call RadRTETwoStreamAppInit
   923  
   924      call RadMars15mInit
   925  
   926      call SetMarsDustInit
   927  
   928      ! ヒストリデータ出力のためのへの変数登録
   929      ! Register of variables for history data output
   930      !
   931      call HistoryAutoAddVariable( 'DOD067',             &
   932        & (/ AxnameX, AxnameY, AxnameR, AxnameT /),      &
   933        & 'dust optical depth at 0.67 micron meter at the surface', '1' )
   934      call HistoryAutoAddVariable( 'DustDensScledOptDep',    &
   935        & (/ AxnameX, AxnameY, AxnameZ, AxnameT /),         &
   936        & 'dust density-scaled optical depth at 0.67 micron meter', 'm2 kg-1' )
   937  
   938  
   939      ! 印字 ; Print
   940      !
   941      call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   942      call MessageNotify( 'M', module_name, 'SolarConst        = %f', d = (/ SolarConst /) )
   943      call MessageNotify( 'M', module_name, 'FlagRadActiveDust = %b', l = (/ FlagRadActiveDust /) )
   944      call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   945  
   946  
   947      rad_Mars_V1_inited = .true.
   948  
   949    end subroutine RadMarsV1Init
   950  
   951    !--------------------------------------------------------------------------------------
   952  
   953  end module rad_Mars_V1
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:59 2016
FILE NAME: rad_Mars_V1.f90
PROGRAM NAME: rad_mars_v1
FORMAT LIST

  LINE    LOOP      FORTRAN STATEMENT

     1:             != 火星大気向け放射モデル Ver. 1
     2:             !
     3:             != radiation model for the Mars' atmosphere Ver. 1
     4:             !
     5:             ! Authors::   Yoshiyuki O. Takahashi
     6:             ! Version::   $Id: rad_Mars_V1.f90,v 1.8 2013/09/21 14:41:35 yot Exp $
     7:             ! Tag Name::  $Name:  $
     8:             ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9:             ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10:             !
    11:             module rad_Mars_V1
    12:               !
    13:               != 火星大気向け放射モデル Ver. 1
    14:               !
    15:               != radiation model for the Mars' atmosphere Ver. 1
    16:               !
    17:               ! <b>Note that Japanese and English are described in parallel.</b>
    18:               !
    19:               ! 地球大気向け放射モデル.
    20:               !
    21:               ! This is a radiation model for the Mars' atmospehre.
    22:               !
    23:               ! Radiation in the wavenumber range from   40 to  2600 cm-1 
    24:               ! is calculated in the routine of long wave radiation. 
    25:               ! Radiation in the wavenumber range from 2600 to 66667 cm-1 (0.15 to 3.85 micron) 
    26:               ! is calculated in the routine of shortwave radiation. 
    27:               !
    28:               !== References
    29:               !
    30:               !
    31:               !== Procedures List
    32:               !
    33:             !!$  ! RadiationFluxDennouAGCM :: 放射フラックスの計算
    34:             !!$  ! RadiationDTempDt        :: 放射フラックスによる温度変化の計算
    35:             !!$  ! RadiationFluxOutput     :: 放射フラックスの出力
    36:             !!$  ! RadiationFinalize       :: 終了処理 (モジュール内部の変数の割り付け解除)
    37:             !!$  ! ------------            :: ------------
    38:             !!$  ! RadiationFluxDennouAGCM :: Calculate radiation flux
    39:             !!$  ! RadiationDTempDt        :: Calculate temperature tendency with radiation flux
    40:             !!$  ! RadiationFluxOutput     :: Output radiation fluxes
    41:             !!$  ! RadiationFinalize       :: Termination (deallocate variables in this module)
    42:               !
    43:               !== NAMELIST
    44:               !
    45:             !!$  ! NAMELIST#radiation_DennouAGCM_nml
    46:               !
    47:             
    48:               ! USE statements
    49:               !
    50:             
    51:               !
    52:               ! Kind type parameter
    53:               !
    54:               use dc_types, only: DP, &      ! Double precision.
    55:                 &                 STRING, &  ! Strings.
    56:                 &                 TOKEN      ! Keywords.
    57:             
    58:               ! メッセージ出力
    59:               ! Message output
    60:               !
    61:               use dc_message, only: MessageNotify
    62:             
    63:               ! 格子点設定
    64:               ! Grid points settings
    65:               !
    66:               use gridset, only: imax, & ! 経度格子点数.
    67:                                          ! Number of grid points in longitude
    68:                 &                jmax, & ! 緯度格子点数.
    69:                                          ! Number of grid points in latitude
    70:                 &                kmax    ! 鉛直層数.
    71:                                          ! Number of vertical level
    72:             
    73:               implicit none
    74:             
    75:               private
    76:             
    77:             
    78:               ! 公開変数
    79:               ! Public variables
    80:               !
    81:               logical, save, public:: rad_Mars_V1_inited = .false.
    82:                                           ! 初期設定フラグ.
    83:                                           ! Initialization flag
    84:             
    85:               ! Private variables
    86:               !
    87:             
    88:               logical, save :: FlagRadActiveDust
    89:             
    90:               real(DP), save :: SolarConst   ! Solar radiation at the distance of semi-major axis
    91:             
    92:               public :: RadMarsV1Init
    93:               public :: RadMarsV1Flux
    94:             
    95:               character(*), parameter:: module_name = 'rad_Mars_V1'
    96:                                           ! モジュールの名称.
    97:                                           ! Module name
    98:               character(*), parameter:: version = &
    99:                 & '$Name:  $' // &
   100:                 & '$Id: rad_Mars_V1.f90,v 1.8 2013/09/21 14:41:35 yot Exp $'
   101:                                           ! モジュールのバージョン
   102:                                           ! Module version
   103:             
   104:               !--------------------------------------------------------------------------------------
   105:             
   106:             contains
   107:             
   108:               !--------------------------------------------------------------------------------------
   109:             
   110:               subroutine RadMarsV1Flux(                                   &
   111:                 & xy_SurfType, xy_SurfMajCompIce,                         &
   112:                 & xy_SurfAlbedo,                                          &
   113:                 & xyz_Press, xyr_Press, xyz_Temp, xyr_Temp, xy_SurfTemp,  &
   114:                 & xyz_QDust,                                              &
   115:                 & xyr_RadSUwFlux, xyr_RadSDwFlux,                         &
   116:                 & xyr_RadLUwFlux, xyr_RadLDwFlux,                         &
   117:                 & xyra_DelRadLUwFlux, xyra_DelRadLDwFlux                  &
   118:                 & )
   119:             
   120:                 ! USE statements
   121:                 !
   122:             
   123:                 ! 物理・数学定数設定
   124:                 ! Physical and mathematical constants settings
   125:                 !
   126:                 use constants0, only: &
   127:                   & PI                    ! $ \pi $ .
   128:                                           ! 円周率.  Circular constant
   129:             
   130:                 ! 物理定数設定
   131:                 ! Physical constants settings
   132:                 !
   133:                 use constants, only: &
   134:                   & Grav, &
   135:                                         ! $ g $ [m s-2].
   136:                                         ! 重力加速度.
   137:                                         ! Gravitational acceleration
   138:                   & GasRDry
   139:             
   140:                 ! 雪と海氷の定数の設定
   141:                 ! Setting constants of snow and sea ice
   142:                 !
   143:                 use constants_snowseaice, only: &
   144:                   & CO2IceThreshold, &
   145:                   & CO2IceEmisS,     &
   146:                   & CO2IceEmisN
   147:             
   148:                 ! 座標データ設定
   149:                 ! Axes data settings
   150:                 !
   151:                 use axesset, only: y_Lat
   152:             
   153:                 ! 時刻管理
   154:                 ! Time control
   155:                 !
   156:                 use timeset, only: &
   157:                   & TimeN, &              ! ステップ $ t $ の時刻.
   158:                                           ! Time of step $ t $.
   159:                   & DelTime, &            ! $ \Delta t $
   160:                   & TimesetClockStart, TimesetClockStop
   161:             
   162:                 ! 短波入射 (太陽入射)
   163:                 ! Short wave (insolation) incoming
   164:                 !
   165:                 use rad_short_income, only : RadShortIncome
   166:             
   167:                 use rad_Mars_15m, only : RadMars15m
   168:             
   169:                 use set_Mars_dust, only : &
   170:                   & SetMarsDustSetDOD067, &
   171:                   & SetMarsDustCalcDOD067
   172:             
   173:                 ! 散乱を無視した放射伝達方程式
   174:                 ! Radiative transfer equation without considering scattering
   175:                 !
   176:                 use rad_rte_nonscat, only : RadRTENonScatWrapper
   177:             
   178:                 !
   179:                 ! Solve radiative transfer equation in two stream approximation
   180:                 !
   181:                 use rad_rte_two_stream_app, only: RadRTETwoStreamAppHomogAtm, RadRTETwoStreamAppLW
   182:             
   183:                 ! プランク関数の計算
   184:                 ! Calculate Planck function
   185:                 !
   186:                 use planck_func, only :                            &
   187:                   & Integ_PF_GQ_Array3D, Integ_PF_GQ_Array2D, Integ_DPFDT_GQ_Array2D
   188:             
   189:                 ! ヒストリデータ出力
   190:                 ! History data output
   191:                 !
   192:                 use gtool_historyauto, only: HistoryAutoPut
   193:             
   194:             
   195:                 integer , intent(in ) :: xy_SurfType       (0:imax-1, 1:jmax)
   196:                 real(DP), intent(in ) :: xy_SurfMajCompIce (0:imax-1, 1:jmax)
   197:                 real(DP), intent(in ) :: xy_SurfAlbedo     (0:imax-1, 1:jmax)
   198:                 real(DP), intent(in ) :: xyz_Press         (0:imax-1, 1:jmax, 1:kmax)
   199:                 real(DP), intent(in ) :: xyr_Press         (0:imax-1, 1:jmax, 0:kmax)
   200:                 real(DP), intent(in ) :: xyz_Temp          (0:imax-1, 1:jmax, 1:kmax)
   201:                 real(DP), intent(in ) :: xyr_Temp          (0:imax-1, 1:jmax, 0:kmax)
   202:                 real(DP), intent(in ) :: xy_SurfTemp       (0:imax-1, 1:jmax)
   203:                 real(DP), intent(in ) :: xyz_QDust         (0:imax-1, 1:jmax, 1:kmax)
   204:                 real(DP), intent(out) :: xyr_RadSUwFlux    (0:imax-1, 1:jmax, 0:kmax)
   205:                 real(DP), intent(out) :: xyr_RadSDwFlux    (0:imax-1, 1:jmax, 0:kmax)
   206:                 real(DP), intent(out) :: xyr_RadLUwFlux    (0:imax-1, 1:jmax, 0:kmax)
   207:                 real(DP), intent(out) :: xyr_RadLDwFlux    (0:imax-1, 1:jmax, 0:kmax)
   208:                 real(DP), intent(out) :: xyra_DelRadLUwFlux(0:imax-1, 1:jmax, 0:kmax, 0:1)
   209:                 real(DP), intent(out) :: xyra_DelRadLDwFlux(0:imax-1, 1:jmax, 0:kmax, 0:1)
   210:             
   211:             
   212:             
   213:                 real(DP), parameter :: DiffFact = 1.66_DP
   214:             
   215:                 real(DP) :: PlanetLonFromVE
   216:                 real(DP) :: xyr_DOD067  (0:imax-1, 1:jmax, 0:kmax)
   217:                 real(DP) :: xyr_DOD     (0:imax-1, 1:jmax, 0:kmax)
   218:                 real(DP) :: xyz_DelTrans(0:imax-1, 1:jmax, 1:kmax)
   219:                 real(DP) :: xyrr_Trans  (0:imax-1, 1:jmax, 0:kmax, 0:kmax)
   220:             
   221:                 real(DP) :: QeRat
   222:                 real(DP) :: SSA
   223:                 real(DP) :: AF
   224:                 real(DP) :: xyz_SSA(0:imax-1, 1:jmax, 1:kmax)
   225:                 real(DP) :: xyz_AF (0:imax-1, 1:jmax, 1:kmax)
   226:             
   227:                 real(DP) :: xy_LWSurfAlbedo(0:imax-1, 1:jmax)
   228:             
   229:                 real(DP) :: xyr_IntPF      (0:imax-1, 1:jmax, 0:kmax)
   230:                 real(DP) :: xy_SurfIntPF   (0:imax-1, 1:jmax)
   231:                 real(DP) :: xy_SurfIntDPFDT(0:imax-1, 1:jmax)
   232:             
   233:                 real(DP) :: xyr_RadLUwFluxComp    (0:imax-1, 1:jmax, 0:kmax)
   234:                 real(DP) :: xyr_RadLDwFluxComp    (0:imax-1, 1:jmax, 0:kmax)
   235:                 real(DP) :: xyra_DelRadLUwFluxComp(0:imax-1, 1:jmax, 0:kmax, 0:1)
   236:                 real(DP) :: xyra_DelRadLDwFluxComp(0:imax-1, 1:jmax, 0:kmax, 0:1)
   237:             
   238:             
   239:                 real(DP) :: MajCompIceThreshold
   240:                 real(DP) :: MajCompIceEmis
   241:                 real(DP) :: xy_SurfEmis(0:imax-1, 1:jmax)
   242:             
   243:                 real(DP) :: xy_InAngle (0:imax-1, 1:jmax)
   244:                 real(DP) :: DistFromStarScld
   245:                 real(DP) :: DiurnalMeanFactor
   246:                 real(DP) :: SolarFluxTOA
   247:             
   248:                 real(DP) :: xyz_DustDensScledOptDep(0:imax-1, 1:jmax, 1:kmax)
   249:             
   250:                 real(DP)           :: WNs
   251:                 real(DP)           :: WNe
   252:                 integer, parameter :: NumGaussNode = 5
   253:             
   254:                 integer :: i
   255:                 integer :: j
   256:                 integer :: k
   257:                 integer :: kk
   258:             
   259:             
   260:             !!$    real(DP) :: MaxError
   261:             
   262:             
   263:             
   264:                 ! 初期化
   265:                 ! Initialization
   266:                 !
   267:                 if ( .not. rad_Mars_V1_inited ) then
   268:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   269:                 end if
   270:             
   271:             
   272:                 call RadShortIncome(                        &
   273:                   & xy_InAngle         = xy_InAngle,        & ! (out) optional
   274:                   & DistFromStarScld   = DistFromStarScld,  & ! (out) optional
   275:                   & DiurnalMeanFactor  = DiurnalMeanFactor, & ! (out) optional
   276:                   & PlanetLonFromVE    = PlanetLonFromVE    & ! (out) optional
   277:                   & )
   278:                 SolarFluxTOA = SolarConst / DistFromStarScld**2 * DiurnalMeanFactor
   279:                 PlanetLonFromVE = PlanetLonFromVE * 180.0_DP / PI
   280:             
   281:                 !  Dust optical depth
   282:                 !
   283:                 if ( FlagRadActiveDust ) then
   284:                   call SetMarsDustCalcDOD067( &
   285:                     & xyr_Press, xyz_QDust,   & ! (in)
   286:                     & xyr_DOD067              & ! (out)
   287:                     & )
   288:                 else
   289:                   call SetMarsDustSetDOD067(                  &
   290:                     & PlanetLonFromVE, xyr_Press, xyz_Press,  & ! (in)
   291:                     & xyr_DOD067                              & ! (out)
   292:                     & )
   293:             !!$    call SetMarsDustCalcDOD067( &
   294:             !!$      & xyr_Press, xyz_QDust,   & ! (in)
   295:             !!$      & xyr_DOD067              & ! (out)
   296:             !!$      & )
   297:                 end if
   298:             
   299:             
   300:                 ! 短波放射
   301:                 ! Short wave radiation
   302:                 !
   303:             
   304:             
   305:             !!$    QeRat   = 0.9837_DP    !   Ockert-Bell et al. (1997)
   306:             !!$    xyz_SSA = 0.86_DP
   307:             !!$    xyz_AF  = 0.68_DP
   308:             !!$    QeRat   = 1.0_DP       !   Clancy and Lee (1991)
   309:                 SSA = 0.92_DP
   310:                 AF  = 0.55_DP
   311:             
   312:             
   313:                 call RadRTETwoStreamAppHomogAtm(                                   &
   314:                   & xy_SurfAlbedo, SolarFluxTOA, xy_InAngle, SSA, AF, xyr_DOD067,  & ! (in )
   315:                   & xyr_RadSUwFlux, xyr_RadSDwFlux                                 & ! (out)
   316:                   & )
   317:             
   318:             
   319:             !!$      MaxError = 0.0_DP
   320:             !!$      do k = 0, kmax
   321:             !!$        do j = 1, jmax
   322:             !!$          do i = 0, imax-1
   323:             !!$            MaxError = max( MaxError, &
   324:             !!$              & abs( OLD_xyr_RadSFlux(i,j,k) - xyr_RadSFlux(i,j,k) ) )
   325:             !!$            MaxError = max( MaxError, &
   326:             !!$              & abs( OLD_xyr_RadSFlux(i,j,k) - ( xyr_RadSUwFlux(i,j,k) - xyr_RadSDwFlux(i,j,k) ) ) )
   327:             !!$          end do
   328:             !!$        end do
   329:             !!$      end do
   330:             !!$      write( 6, * ) MaxError
   331:             !!$      write( 6, * ) MaxError, xyr_RadSUwFlux(0,jmax/2+1,kmax)
   332:             
   333:             !!$      MaxError = 0.0_DP
   334:             !!$      do k = 0, kmax
   335:             !!$        do j = 1, jmax
   336:             !!$          do i = 0, imax-1
   337:             !!$            MaxError = max( MaxError, &
   338:             !!$              & abs( OLD_xyr_RadLFlux(i,j,k) - xyr_RadLFlux(i,j,k) ) )
   339:             !!$            MaxError = max( MaxError, &
   340:             !!$              & abs( OLD_xyra_DelRadLFlux(i,j,k,0) - xyra_DelRadLFlux(i,j,k,0) ) )
   341:             !!$            MaxError = max( MaxError, &
   342:             !!$              & abs( OLD_xyra_DelRadLFlux(i,j,k,1) - xyra_DelRadLFlux(i,j,k,1) ) )
   343:             !!$          end do
   344:             !!$        end do
   345:             !!$      end do
   346:             !!$      write( 6, * ) MaxError
   347:             !!$      !
   348:             !!$      xyr_RadSFlux     = OLD_xyr_RadSFlux
   349:             !!$      xyr_RadLFlux     = OLD_xyr_RadLFlux
   350:             !!$      xyra_DelRadLFlux = OLD_xyra_DelRadLFlux
   351:             
   352:             !!$      xyr_RadSUwFlux     = OLD_xyr_RadSFlux
   353:             !!$      xyr_RadSDwFlux     = 0.0_DP
   354:             
   355:             
   356:                 ! 長波放射
   357:                 ! Long wave radiation
   358:                 !
   359:             
   360:                 !   Surface albedo for long wave is set.
   361:                 !
   362: W*===== A       xy_LWSurfAlbedo = 0.0_DP
   363:             
   364: **W---->A       xyr_RadLUwFlux     = 0.0_DP
   365: **W---- A       xyr_RadLDwFlux     = 0.0_DP
   366: ***W--->A       xyra_DelRadLUwFlux = 0.0_DP
   367: ***W--- A       xyra_DelRadLDwFlux = 0.0_DP
   368:             
   369:             
   370:                 !  Surface emissivity
   371:                 !
   372: W*===== A       xy_SurfEmis = 1.0_DP
   373:             
   374:                 MajCompIceThreshold = CO2IceThreshold
   375: +------>        do j = 1, jmax
   376: |                 if ( y_Lat(j) < 0.0_DP ) then
   377: |                   MajCompIceEmis = CO2IceEmisS
   378: |                 else
   379: |                   MajCompIceEmis = CO2IceEmisN
   380: |                 end if
   381: |V----->          do i = 0, imax-1
   382: ||                  if ( xy_SurfType(i,j) > 0 ) then
   383: ||      A             if ( xy_SurfMajCompIce(i,j) > MajCompIceThreshold ) then
   384: ||      A               xy_SurfEmis(i,j) = MajCompIceEmis
   385: ||                    else if ( xy_SurfMajCompIce(i,j) < 0.0_DP ) then
   386: ||                      xy_SurfEmis(i,j) = xy_SurfEmis(i,j)
   387: ||                    else
   388: ||      A               xy_SurfEmis(i,j) =                                    &
   389: ||                        &   ( MajCompIceEmis         - xy_SurfEmis(i,j) )   &
   390: ||                        & / ( MajCompIceThreshold    - 0.0_DP           )   &
   391: ||                        & * ( xy_SurfMajCompIce(i,j) - 0.0_DP           )   &
   392: ||                        & + xy_SurfEmis(i,j)
   393: ||                    end if
   394: ||                  end if
   395: |V-----           end do
   396: +------         end do
   397:             
   398:             
   399:                 !    Flux from 0 to 500 cm-1
   400:                 !
   401:                 WNs     =   0.0d2
   402:                 WNe     = 500.0d2
   403:                 QeRat   = 0.17_DP                       ! Wavenumber averaged extinction coefficient
   404:                 SSA     = 0.35_DP
   405:                 AF      = 0.36_DP
   406:             
   407: **W---->A       xyz_SSA = SSA
   408: **W---- A       xyz_AF  = AF
   409:             
   410: W**==== A       xyr_DOD = QeRat * xyr_DOD067
   411:             
   412:                 !----------
   413:                 !    Modification of dust optical depth for use in non-scattering calculation
   414:             !!$    xyr_DOD = ( 1.0_DP - SSA ) * xyr_DOD
   415:                 !
   416:             !!$    do k = 1, kmax
   417:             !!$      xyz_DelTrans(:,:,k) = exp( - DiffFact * ( xyr_DOD(:,:,k-1) - xyr_DOD(:,:,k) ) )
   418:             !!$    end do
   419:             !!$    !
   420:             !!$    do k = 0, kmax
   421:             !!$      do kk = k, k
   422:             !!$        xyrr_Trans(:,:,k,kk) = 1.0_DP
   423:             !!$      end do
   424:             !!$      do kk = k+1, kmax
   425:             !!$        xyrr_Trans(:,:,k,kk) = xyrr_Trans(:,:,k,kk-1) * xyz_DelTrans(:,:,kk)
   426:             !!$      end do
   427:             !!$    end do
   428:             !!$    do k = 0, kmax
   429:             !!$      do kk = 0, k-1
   430:             !!$        xyrr_Trans(:,:,k,kk) = xyrr_Trans(:,:,kk,k)
   431:             !!$      end do
   432:             !!$    end do
   433:             !!$    !
   434:             !!$    call RadRTENonScatWrapper(                          &
   435:             !!$      & xyz_Temp, xy_SurfTemp, xy_SurfEmis, xyrr_Trans, & ! (in )
   436:             !!$      & xyr_RadLUwFluxComp, xyr_RadLDwFluxComp,         & ! (out)
   437:             !!$      & xyra_DelRadLUwFluxComp, xyra_DelRadLDwFluxComp, & ! (out)
   438:             !!$      & WNs, WNe, NumGaussNode                          & ! (in ) optional
   439:             !!$      & )
   440:             
   441:                 !----------
   442:             
   443:             !!$    i = 0
   444:             !!$    j = jmax/2+1
   445:             !!$    do k = 0, kmax
   446:             !!$      write( 70, * ) k, &
   447:             !!$        & xyr_RadLUwFluxComp(i,j,k), &
   448:             !!$        & xyr_RadLDwFluxComp(i,j,k), &
   449:             !!$        & xyra_DelRadLUwFluxComp(i,j,k,0), &
   450:             !!$        & xyra_DelRadLUwFluxComp(i,j,k,1), &
   451:             !!$        & xyra_DelRadLDwFluxComp(i,j,k,0), &
   452:             !!$        & xyra_DelRadLDwFluxComp(i,j,k,1)
   453:             !!$    end do
   454:             !!$    call flush( 70 )
   455:             
   456:             
   457:                 ! Integrate Planck function and temperature derivative of it
   458:                 !
   459:                 call Integ_PF_GQ_Array3D(        &
   460:                   & WNs, WNe, NumGaussNode,      &
   461:                   & 0, imax-1, 1, jmax, 0, kmax, &
   462:                   & xyr_Temp,                    &
   463:                   & xyr_IntPF                    &
   464:                   & )
   465:                 call Integ_PF_GQ_Array2D(        &
   466:                   & WNs, WNe, NumGaussNode,      &
   467:                   & 0, imax-1, 1, jmax,          &
   468:                   & xy_SurfTemp,                 &
   469:                   & xy_SurfIntPF                 &
   470:                   & )
   471:             !    call Integ_DPFDT_GQ_Array2D(             &
   472:             !      & WNs, WNe, NumGaussNode,              & ! (in )
   473:             !      & 0, imax-1, 1, jmax, xyz_Temp(:,:,1), & ! (in )
   474:             !      & xy_IntDPFDT1                         & ! (out)
   475:             !      & )
   476:                 call Integ_DPFDT_GQ_Array2D(         &
   477:                   & WNs, WNe, NumGaussNode,          & ! (in )
   478:                   & 0, imax-1, 1, jmax, xy_SurfTemp, & ! (in )
   479:                   & xy_SurfIntDPFDT                  & ! (out)
   480:                   & )
   481:                 !
   482: W**==== A       xyr_IntPF       =               PI * xyr_IntPF
   483: *W----->A       xy_SurfIntPF    = xy_SurfEmis * PI * xy_SurfIntPF
   484: ||          !    xy_IntDPFDT1    =               PI * xy_IntDPFDT1
   485: *W----- A       xy_SurfIntDPFDT = xy_SurfEmis * PI * xy_SurfIntDPFDT
   486:                 !
   487:                 call RadRTETwoStreamAppLW(                          &
   488:                   & xyz_SSA, xyz_AF,                                & ! (in)
   489:                   & xyr_DOD,                                        & ! (in)
   490:                   & xy_LWSurfAlbedo,                                & ! (in)
   491:                   & xyr_IntPF, xy_SurfIntPF, xy_SurfIntDPFDT,       & ! (in)
   492:                   & xyr_RadLUwFluxComp, xyr_RadLDwFluxComp,         & ! (out)
   493:                   & xyra_DelRadLUwFluxComp, xyra_DelRadLDwFluxComp  & ! (out)
   494:                   & )
   495:             
   496:             !!$    i = 0
   497:             !!$    j = jmax/2+1
   498:             !!$    do k = 0, kmax
   499:             !!$      write( 80, * ) k, &
   500:             !!$        & xyr_RadLUwFluxComp(i,j,k), &
   501:             !!$        & xyr_RadLDwFluxComp(i,j,k), &
   502:             !!$        & xyra_DelRadLUwFluxComp(i,j,k,0), &
   503:             !!$        & xyra_DelRadLUwFluxComp(i,j,k,1), &
   504:             !!$        & xyra_DelRadLDwFluxComp(i,j,k,0), &
   505:             !!$        & xyra_DelRadLDwFluxComp(i,j,k,1)
   506:             !!$    end do
   507:             !!$    call flush( 80 )
   508:             !!$    stop
   509:             
   510:                 !----------
   511:             
   512: **W---->A       xyr_RadLUwFlux     = xyr_RadLUwFlux     + xyr_RadLUwFluxComp
   513: **W---- A       xyr_RadLDwFlux     = xyr_RadLDwFlux     + xyr_RadLDwFluxComp
   514: ***W--->A       xyra_DelRadLUwFlux = xyra_DelRadLUwFlux + xyra_DelRadLUwFluxComp
   515: ***W--- A       xyra_DelRadLDwFlux = xyra_DelRadLDwFlux + xyra_DelRadLDwFluxComp
   516:             
   517:             
   518:             
   519:                 !    Flux from 500 to 850 cm-1
   520:                 !
   521:             
   522:                 QeRat = 0.25_DP                      ! Wavenumber averaged extinction coefficient
   523:                 SSA   = 0.45_DP                      ! Wavenumber averaged single scattering albedo
   524:             
   525:                 call RadMars15m( TimeN, DelTime, &
   526:                   & xyz_Temp, xyr_Press, xyz_Press, xy_SurfTemp, &
   527:                   & xyr_DOD067, QeRat, SSA, xy_SurfEmis, &
   528:                   & xyr_RadLUwFluxComp, xyra_DelRadLUwFluxComp &
   529:                   & )
   530: W**==== A       xyr_RadLDwFluxComp     = 0.0_DP
   531: W***=== A       xyra_DelRadLDwFluxComp = 0.0_DP
   532:             
   533: **W---->A       xyr_RadLUwFlux     = xyr_RadLUwFlux     + xyr_RadLUwFluxComp
   534: **W---- A       xyr_RadLDwFlux     = xyr_RadLDwFlux     + xyr_RadLDwFluxComp
   535: ***W--->A       xyra_DelRadLUwFlux = xyra_DelRadLUwFlux + xyra_DelRadLUwFluxComp
   536: ***W--- A       xyra_DelRadLDwFlux = xyra_DelRadLDwFlux + xyra_DelRadLDwFluxComp
   537:             
   538:             
   539:             
   540:                 !    Flux from 850 to 2000 cm-1
   541:                 !
   542:                 WNs     =  850.0d2
   543:                 WNe     = 2000.0d2
   544:                 QeRat   =    0.41_DP                    ! Wavenumber averaged extinction coefficient
   545:                 SSA     = 0.55_DP
   546:                 AF      = 0.55_DP
   547:             
   548: **W---->A       xyz_SSA = SSA
   549: **W---- A       xyz_AF  = AF
   550:             
   551: W**==== A       xyr_DOD = QeRat * xyr_DOD067
   552:             
   553:                 !----------
   554:                 !    Modification of dust optical depth for use in non-scattering calculation
   555:             !!$    xyr_DOD = ( 1.0_DP - SSA ) * xyr_DOD
   556:                 !
   557:             !!$    do k = 1, kmax
   558:             !!$      xyz_DelTrans(:,:,k) = exp( - DiffFact * ( xyr_DOD(:,:,k-1) - xyr_DOD(:,:,k) ) )
   559:             !!$    end do
   560:             !!$    !
   561:             !!$    do k = 0, kmax
   562:             !!$      do kk = k, k
   563:             !!$        xyrr_Trans(:,:,k,kk) = 1.0_DP
   564:             !!$      end do
   565:             !!$      do kk = k+1, kmax
   566:             !!$        xyrr_Trans(:,:,k,kk) = xyrr_Trans(:,:,k,kk-1) * xyz_DelTrans(:,:,kk)
   567:             !!$      end do
   568:             !!$    end do
   569:             !!$    do k = 0, kmax
   570:             !!$      do kk = 0, k-1
   571:             !!$        xyrr_Trans(:,:,k,kk) = xyrr_Trans(:,:,kk,k)
   572:             !!$      end do
   573:             !!$    end do
   574:             !!$    !
   575:             !!$    call RadRTENonScatWrapper(                          &
   576:             !!$      & xyz_Temp, xy_SurfTemp, xy_SurfEmis, xyrr_Trans, & ! (in )
   577:             !!$      & xyr_RadLUwFluxComp, xyr_RadLDwFluxComp,         & ! (out)
   578:             !!$      & xyra_DelRadLUwFluxComp, xyra_DelRadLDwFluxComp, & ! (out)
   579:             !!$      & WNs, WNe, NumGaussNode                          & ! (in ) optional
   580:             !!$      & )
   581:                 !----------
   582:             
   583:             
   584:                 ! Integrate Planck function and temperature derivative of it
   585:                 !
   586:                 call Integ_PF_GQ_Array3D(        &
   587:                   & WNs, WNe, NumGaussNode,      &
   588:                   & 0, imax-1, 1, jmax, 0, kmax, &
   589:                   & xyr_Temp,                    &
   590:                   & xyr_IntPF                    &
   591:                   & )
   592:                 call Integ_PF_GQ_Array2D(        &
   593:                   & WNs, WNe, NumGaussNode,      &
   594:                   & 0, imax-1, 1, jmax,          &
   595:                   & xy_SurfTemp,                 &
   596:                   & xy_SurfIntPF                 &
   597:                   & )
   598:             !    call Integ_DPFDT_GQ_Array2D(             &
   599:             !      & WNs, WNe, NumGaussNode,              & ! (in )
   600:             !      & 0, imax-1, 1, jmax, xyz_Temp(:,:,1), & ! (in )
   601:             !      & xy_IntDPFDT1                         & ! (out)
   602:             !      & )
   603:                 call Integ_DPFDT_GQ_Array2D(         &
   604:                   & WNs, WNe, NumGaussNode,          & ! (in )
   605:                   & 0, imax-1, 1, jmax, xy_SurfTemp, & ! (in )
   606:                   & xy_SurfIntDPFDT                  & ! (out)
   607:                   & )
   608:                 !
   609: W**==== A       xyr_IntPF       =               PI * xyr_IntPF
   610: *W----->A       xy_SurfIntPF    = xy_SurfEmis * PI * xy_SurfIntPF
   611: ||          !    xy_IntDPFDT1    =               PI * xy_IntDPFDT1
   612: *W----- A       xy_SurfIntDPFDT = xy_SurfEmis * PI * xy_SurfIntDPFDT
   613:                 !
   614:                 call RadRTETwoStreamAppLW(                          &
   615:                   & xyz_SSA, xyz_AF,                                & ! (in)
   616:                   & xyr_DOD,                                        & ! (in)
   617:                   & xy_LWSurfAlbedo,                                & ! (in)
   618:                   & xyr_IntPF, xy_SurfIntPF, xy_SurfIntDPFDT,       & ! (in)
   619:                   & xyr_RadLUwFluxComp, xyr_RadLDwFluxComp,         & ! (out)
   620:                   & xyra_DelRadLUwFluxComp, xyra_DelRadLDwFluxComp  & ! (out)
   621:                   & )
   622:             
   623:                 !----------
   624:             
   625: **W---->A       xyr_RadLUwFlux     = xyr_RadLUwFlux     + xyr_RadLUwFluxComp
   626: **W---- A       xyr_RadLDwFlux     = xyr_RadLDwFlux     + xyr_RadLDwFluxComp
   627: ***W--->A       xyra_DelRadLUwFlux = xyra_DelRadLUwFlux + xyra_DelRadLUwFluxComp
   628: ***W--- A       xyra_DelRadLDwFlux = xyra_DelRadLDwFlux + xyra_DelRadLDwFluxComp
   629:             
   630:             
   631:             
   632:                 ! Output variables
   633:                 !
   634:                 call HistoryAutoPut( TimeN, 'DOD067', xyr_DOD067 )
   635: W------>        do k = 1, kmax
   636: |**==== A         xyz_DustDensScledOptDep(:,:,k) =                  &
   637: |                   &   ( xyr_DOD067(:,:,k-1) - xyr_DOD067(:,:,k) ) &
   638: |                   & / ( xyr_Press (:,:,k-1) - xyr_Press (:,:,k) ) &
   639: |                   & * Grav
   640: W------         end do
   641:                 call HistoryAutoPut( TimeN, 'DustDensScledOptDep', xyz_DustDensScledOptDep )
   642:             
   643:             
   644:               end subroutine RadMarsV1Flux
   645:             
   646:               !-------------------------------------------------------------------
   647:               ! This subroutine will be deleted in future.
   648:               !
   649:             !!$
   650:             !!$  subroutine RadiationRTEQNonScat(                    &
   651:             !!$    & WNs, WNe, NumGaussNode,                         & ! (in)
   652:             !!$    & xyz_Temp, xy_SurfTemp, xy_SurfEmis, xyr_OptDep, & ! (in)
   653:             !!$    & xyr_RadLFlux, xyra_DelRadLFlux                  & ! (out)
   654:             !!$    & )
   655:             !!$    !
   656:             !!$    ! 散乱なしの場合の放射伝達方程式の計算
   657:             !!$    !
   658:             !!$    ! Integrate radiative transfer equation without scattering
   659:             !!$    !
   660:             !!$
   661:             !!$    ! モジュール引用 ; USE statements
   662:             !!$    !
   663:             !!$
   664:             !!$    ! 物理定数設定
   665:             !!$    ! Physical constants settings
   666:             !!$    !
   667:             !!$    use constants, only: PI
   668:             !!$
   669:             !!$    ! プランク関数の計算
   670:             !!$    ! Calculate Planck function
   671:             !!$    !
   672:             !!$    use planck_func, only :                            &
   673:             !!$      & Integ_PF_GQ_Array3D   , Integ_PF_GQ_Array2D,   &
   674:             !!$      & Integ_DPFDT_GQ_Array3D, Integ_DPFDT_GQ_Array2D
   675:             !!$
   676:             !!$    ! 宣言文 ; Declaration statements
   677:             !!$    !
   678:             !!$
   679:             !!$    real(DP), intent(in ):: WNs
   680:             !!$    real(DP), intent(in ):: WNe
   681:             !!$    integer,  intent(in ):: NumGaussNode
   682:             !!$    real(DP), intent(in ):: xyz_Temp    (0:imax-1, 1:jmax, 1:kmax)
   683:             !!$                              ! $ T $ .     温度. Temperature
   684:             !!$    real(DP), intent(in ):: xy_SurfTemp (0:imax-1, 1:jmax)
   685:             !!$                              ! 地表面温度. 
   686:             !!$                              ! Surface temperature
   687:             !!$    real(DP), intent(in ):: xy_SurfEmis (0:imax-1, 1:jmax)
   688:             !!$                              ! 惑星表面射出率. 
   689:             !!$                              ! Surface emissivity
   690:             !!$    real(DP), intent(in ):: xyr_OptDep  (0:imax-1, 1:jmax, 0:kmax)
   691:             !!$                              ! Optical depth
   692:             !!$    real(DP), intent(out):: xyr_RadLFlux (0:imax-1, 1:jmax, 0:kmax)
   693:             !!$                              ! 長波フラックス. 
   694:             !!$                              ! Longwave flux
   695:             !!$    real(DP), intent(out):: xyra_DelRadLFlux (0:imax-1, 1:jmax, 0:kmax, 0:1)
   696:             !!$                              ! 長波地表温度変化. 
   697:             !!$                              ! Surface temperature tendency with longwave
   698:             !!$
   699:             !!$    ! 作業変数
   700:             !!$    ! Work variables
   701:             !!$    !
   702:             !!$    real(DP), parameter :: DiffFact = 1.66_DP
   703:             !!$
   704:             !!$    real(DP):: xyz_DelTrans (0:imax-1, 1:jmax, 1:kmax)
   705:             !!$    real(DP):: xyrr_Trans   (0:imax-1, 1:jmax, 0:kmax, 0:kmax)
   706:             !!$                              ! 透過係数. 
   707:             !!$                              ! Transmission coefficient
   708:             !!$    real(DP):: xyz_IntPF      (0:imax-1, 1:jmax, 1:kmax)
   709:             !!$                              ! Integrated Planck function
   710:             !!$    real(DP):: xy_SurfIntPF   (0:imax-1, 1:jmax)
   711:             !!$                              ! Integrated Planck function with surface temperature
   712:             !!$    real(DP):: xyz_IntDPFDT   (0:imax-1, 1:jmax, 1:kmax)
   713:             !!$                              ! Integrated temperature derivative of Planck function
   714:             !!$    real(DP):: xy_SurfIntDPFDT(0:imax-1, 1:jmax)
   715:             !!$                              ! Integrated temperature derivative of Planck function
   716:             !!$                              ! with surface temperature
   717:             !!$
   718:             !!$    integer:: k, kk           ! 鉛直方向に回る DO ループ用作業変数
   719:             !!$                              ! Work variables for DO loop in vertical direction
   720:             !!$
   721:             !!$    ! 実行文 ; Executable statement
   722:             !!$    !
   723:             !!$
   724:             !!$    ! 初期化
   725:             !!$    ! Initialization
   726:             !!$    !
   727:             !!$    if ( .not. radiation_dcpam_M_V1_inited ) call RadiationDcpamMV1Init
   728:             !!$
   729:             !!$    ! Integrate Planck function and temperature derivative of it
   730:             !!$    !
   731:             !!$    call Integ_PF_GQ_Array3D( &
   732:             !!$      & WNs, WNe, NumGaussNode, &
   733:             !!$      & 0, imax-1, 1, jmax, 1, kmax, &
   734:             !!$      & xyz_Temp, &
   735:             !!$      & xyz_IntPF &
   736:             !!$      & )
   737:             !!$    call Integ_PF_GQ_Array2D( &
   738:             !!$      & WNs, WNe, NumGaussNode, &
   739:             !!$      & 0, imax-1, 1, jmax, &
   740:             !!$      & xy_SurfTemp, &
   741:             !!$      & xy_SurfIntPF &
   742:             !!$      & )
   743:             !!$    call Integ_DPFDT_GQ_Array3D( &
   744:             !!$      & 0, imax-1, 1, jmax, 1, kmax, &
   745:             !!$      & WNs, WNe, NumGaussNode, xyz_Temp, & ! (in )
   746:             !!$      & xyz_IntDPFDT          & ! (out)
   747:             !!$      & )
   748:             !!$    call Integ_DPFDT_GQ_Array2D( &
   749:             !!$      & 0, imax-1, 1, jmax, &
   750:             !!$      & WNs, WNe, NumGaussNode, xy_SurfTemp, & ! (in )
   751:             !!$      & xy_SurfIntDPFDT           & ! (out)
   752:             !!$      & )
   753:             !!$
   754:             !!$
   755:             !!$    ! 透過関数計算
   756:             !!$    ! Calculate transmission functions
   757:             !!$    !
   758:             !!$    do k = 1, kmax
   759:             !!$      xyz_DelTrans(:,:,k) = &
   760:             !!$        & exp( - DiffFact * ( xyr_OptDep(:,:,k-1) - xyr_OptDep(:,:,k) ) )
   761:             !!$    end do
   762:             !!$    !
   763:             !!$    do k = 0, kmax
   764:             !!$      do kk = k, k
   765:             !!$        xyrr_Trans(:,:,k,kk) = 1.0_DP
   766:             !!$      end do
   767:             !!$      do kk = k+1, kmax
   768:             !!$        xyrr_Trans(:,:,k,kk) = xyrr_Trans(:,:,k,kk-1) * xyz_DelTrans(:,:,kk)
   769:             !!$      end do
   770:             !!$    end do
   771:             !!$    do k = 0, kmax
   772:             !!$      do kk = 0, k-1
   773:             !!$        xyrr_Trans(:,:,k,kk) = xyrr_Trans(:,:,kk,k)
   774:             !!$      end do
   775:             !!$    end do
   776:             !!$
   777:             !!$
   778:             !!$    ! 放射フラックス計算
   779:             !!$    ! Calculate radiation flux
   780:             !!$    !
   781:             !!$    do k = 0, kmax
   782:             !!$
   783:             !!$      xyr_RadLFlux(:,:,k) = xy_SurfEmis * PI * xy_SurfIntPF * xyrr_Trans(:,:,k,0)
   784:             !!$
   785:             !!$      do kk = 0, kmax-1
   786:             !!$        xyr_RadLFlux(:,:,k) = xyr_RadLFlux(:,:,k)                &
   787:             !!$          & - PI * xyz_IntPF(:,:,kk+1)                           &
   788:             !!$          & * ( xyrr_Trans(:,:,k,kk) - xyrr_Trans(:,:,k,kk+1) )
   789:             !!$      end do
   790:             !!$
   791:             !!$    end do
   792:             !!$
   793:             !!$
   794:             !!$    ! 放射フラックスの変化率の計算
   795:             !!$    ! Calculate rate of change of radiative flux
   796:             !!$    !
   797:             !!$    do k = 0, kmax
   798:             !!$      xyra_DelRadLFlux(:,:,k,0) =                           &
   799:             !!$        & xy_SurfEmis * xy_SurfIntDPFDT * xyrr_Trans(:,:,k,0)
   800:             !!$
   801:             !!$      xyra_DelRadLFlux(:,:,k,1) =                           &
   802:             !!$        & xyz_IntDPFDT(:,:,1)                               &
   803:             !!$        &   * ( xyrr_Trans(:,:,k,1) - xyrr_Trans(:,:,k,0) )
   804:             !!$    end do
   805:             !!$
   806:             !!$
   807:             !!$  end subroutine RadiationRTEQNonScat
   808:             !!$
   809:               !-------------------------------------------------------------------
   810:             
   811:               subroutine RadMarsV1Init
   812:             
   813:                 ! ファイル入出力補助
   814:                 ! File I/O support
   815:                 !
   816:                 use dc_iounit, only: FileOpen
   817:             
   818:                 ! NAMELIST ファイル入力に関するユーティリティ
   819:                 ! Utilities for NAMELIST file input
   820:                 !
   821:                 use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid
   822:             
   823:                 ! ヒストリデータ出力
   824:                 ! History data output
   825:                 !
   826:                 use gtool_historyauto, only: HistoryAutoAddVariable
   827:             
   828:                 ! 座標データ設定
   829:                 ! Axes data settings
   830:                 !
   831:                 use axesset, only: &
   832:                   & AxnameX, &
   833:                   & AxnameY, &
   834:                   & AxnameZ, &
   835:                   & AxnameR, &
   836:                   & AxnameT
   837:             
   838:                 ! 短波入射 (太陽入射)
   839:                 ! Short wave (insolation) incoming
   840:                 !
   841:                 use rad_short_income, only : RadShortIncomeInit
   842:             
   843:                 ! 散乱を無視した放射伝達方程式
   844:                 ! Radiative transfer equation without considering scattering
   845:                 !
   846:                 use rad_rte_nonscat, only : RadRTENonScatInit
   847:             
   848:                 !
   849:                 ! Solve radiative transfer equation in two stream approximation
   850:                 !
   851:                 use rad_rte_two_stream_app, only: RadRTETwoStreamAppInit
   852:             
   853:                 use rad_Mars_15m, only : RadMars15mInit
   854:             
   855:                 use set_Mars_dust, only : SetMarsDustInit
   856:             
   857:                 ! 宣言文 ; Declaration statements
   858:                 !
   859:             
   860:                 integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号.
   861:                                           ! Unit number for NAMELIST file open
   862:                 integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT.
   863:                                           ! IOSTAT of NAMELIST read
   864:             
   865:                 ! NAMELIST 変数群
   866:                 ! NAMELIST group name
   867:                 !
   868:                 namelist /rad_Mars_V1_nml/ &
   869:                   & SolarConst,            &
   870:                   & FlagRadActiveDust
   871:                       !
   872:                       ! デフォルト値については初期化手続 "rad_Mars_V1#RadMarsV1Init"
   873:                       ! のソースコードを参照のこと.
   874:                       !
   875:                       ! Refer to source codes in the initialization procedure
   876:                       ! "rad_Mars_V1#RadMarsV1Init" for the default values.
   877:                       !
   878:             
   879:                 if ( rad_Mars_V1_inited ) return
   880:             
   881:                 ! デフォルト値の設定
   882:                 ! Default values settings
   883:                 !
   884:                 SolarConst        = 1380.0_DP / 1.52_DP**2
   885:             
   886:                 FlagRadActiveDust = .false.
   887:             
   888:             
   889:                 ! NAMELIST の読み込み
   890:                 ! NAMELIST is input
   891:                 !
   892:                 if ( trim(namelist_filename) /= '' ) then
   893:                   call FileOpen( unit_nml, &          ! (out)
   894:                     & namelist_filename, mode = 'r' ) ! (in)
   895:             
   896:                   rewind( unit_nml )
   897:                   read( unit_nml,                     & ! (in)
   898:                     & nml = rad_Mars_V1_nml,          & ! (out)
   899:                     & iostat = iostat_nml )             ! (out)
   900:                   close( unit_nml )
   901:             
   902:                   call NmlutilMsg( iostat_nml, module_name ) ! (in)
   903:                 end if
   904:             
   905:             
   906:                 ! Initialization of modules used in this module
   907:                 !
   908:             
   909:                 ! 短波入射 (太陽入射)
   910:                 ! Short wave (insolation) incoming
   911:                 !
   912:                 call RadShortIncomeInit
   913:             
   914:                 ! 散乱を無視した放射伝達方程式
   915:                 ! Radiative transfer equation without considering scattering
   916:                 !
   917:                 call RadRTENonScatInit
   918:             
   919:                 !
   920:                 ! Solve radiative transfer equation in two stream approximation
   921:                 !
   922:                 call RadRTETwoStreamAppInit
   923:             
   924:                 call RadMars15mInit
   925:             
   926:                 call SetMarsDustInit
   927:             
   928:                 ! ヒストリデータ出力のためのへの変数登録
   929:                 ! Register of variables for history data output
   930:                 !
   931:                 call HistoryAutoAddVariable( 'DOD067',             &
   932:                   & (/ AxnameX, AxnameY, AxnameR, AxnameT /),      &
   933:                   & 'dust optical depth at 0.67 micron meter at the surface', '1' )
   934:                 call HistoryAutoAddVariable( 'DustDensScledOptDep',    &
   935:                   & (/ AxnameX, AxnameY, AxnameZ, AxnameT /),         &
   936:                   & 'dust density-scaled optical depth at 0.67 micron meter', 'm2 kg-1' )
   937:             
   938:             
   939:                 ! 印字 ; Print
   940:                 !
   941:                 call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   942:                 call MessageNotify( 'M', module_name, 'SolarConst        = %f', d = (/ SolarConst /) )
   943:                 call MessageNotify( 'M', module_name, 'FlagRadActiveDust = %b', l = (/ FlagRadActiveDust /) )
   944:                 call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   945:             
   946:             
   947:                 rad_Mars_V1_inited = .true.
   948:             
   949:               end subroutine RadMarsV1Init
   950:             
   951:               !--------------------------------------------------------------------------------------
   952:             
   953:             end module rad_Mars_V1
