Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:39:00 2016
FILE NAME: rad_SL09.f90
PROGRAM NAME: rad_sl09
DIAGNOSTIC LIST

  LINE  LEVEL( NO.): DIAGNOSTIC MESSAGE

   183  opt  (1593): Loop nest collapsed into one loop.
   183  vec  (   4): Vectorized array expression.
   183  vec  (  29): ADB is used for array.: xyr_optdep
   183  vec  (  29): ADB is used for array.: xyr_press
   194  opt  (1592): Outer loop unrolled inside inner loop.
   194  vec  (   4): Vectorized array expression.
   194  vec  (  29): ADB is used for array.: xy_cossza
   194  vec  (   4): Vectorized array expression.
   194  vec  (  29): ADB is used for array.: xy_cossza
   197  opt  (1592): Outer loop unrolled inside inner loop.
   197  vec  (   3): Unvectorized loop.
   197  vec  (  13): Overhead of loop division is too large.
   197  vec  (   3): Unvectorized loop.
   197  vec  (  13): Overhead of loop division is too large.
   198  vec  (   4): Vectorized array expression.
   198  vec  (  29): ADB is used for array.: xy_cossza
   198  vec  (   4): Vectorized array expression.
   198  vec  (  29): ADB is used for array.: xy_cossza
   231  opt  (  11): Fused array assignments. :line 231 - 240
   231  opt  (1593): Loop nest collapsed into one loop.
   231  vec  (   4): Vectorized array expression.
   231  vec  (  29): ADB is used for array.: xyr_optdep
   231  vec  (  29): ADB is used for array.: xyr_press
   231  vec  (  29): ADB is used for array.: xyr_radsdwflux
   253  opt  (1593): Loop nest collapsed into one loop.
   253  vec  (   4): Vectorized array expression.
   253  vec  (  29): ADB is used for array.: xyr_radsdwflux
   253  vec  (  29): ADB is used for array.: xyr_radsuwflux
   347  opt  (  11): Fused array assignments. :line 347 - 348
   347  opt  (1593): Loop nest collapsed into one loop.
   347  vec  (   4): Vectorized array expression.
   347  vec  (  29): ADB is used for array.: xyz_temp
   354  opt  (1593): Loop nest collapsed into one loop.
   354  vec  (   1): Vectorized loop.
   354  vec  (  29): ADB is used for array.: xyr_optdep
   361  opt  (1593): Loop nest collapsed into one loop.
   361  vec  (   4): Vectorized array expression.
   363  vec  (   3): Unvectorized loop.
   363  vec  (  13): Overhead of loop division is too large.
   364  opt  (1037): Feedback of array elements.
   364  opt  (1593): Loop nest collapsed into one loop.
   364  vec  (   4): Vectorized array expression.
   364  vec  (  29): ADB is used for array.: xyrr_trans
   368  vec  (   3): Unvectorized loop.
   368  vec  (  13): Overhead of loop division is too large.
   369  opt  (1036): Potential feedback - use directive if OK.
   369  opt  (1593): Loop nest collapsed into one loop.
   369  vec  (   4): Vectorized array expression.
   369  vec  (  29): ADB is used for array.: xyrr_trans
   380  opt  (  11): Fused array assignments. :line 380 - 381
   380  opt  (1593): Loop nest collapsed into one loop.
   380  vec  (   4): Vectorized array expression.
   387  vec  (   3): Unvectorized loop.
   387  vec  (  13): Overhead of loop division is too large.
   388  opt  (1593): Loop nest collapsed into one loop.
   388  vec  (   4): Vectorized array expression.
   388  vec  (  29): ADB is used for array.: xyr_radldoflux
   388  vec  (  29): ADB is used for array.: xyrr_trans
   388  vec  (  29): ADB is used for array.: xyz_intpf
   399  opt  (1593): Loop nest collapsed into one loop.
   399  vec  (   4): Vectorized array expression.
   399  vec  (  29): ADB is used for array.: xy_surfupradlfluxbase
   399  vec  (  29): ADB is used for array.: xyr_radldoflux
   403  opt  (1593): Loop nest collapsed into one loop.
   403  vec  (   4): Vectorized array expression.
   403  vec  (  29): ADB is used for array.: xyrr_trans
   403  vec  (  29): ADB is used for array.: xy_surfupradlflux
   405  vec  (   3): Unvectorized loop.
   405  vec  (  13): Overhead of loop division is too large.
   406  opt  (1593): Loop nest collapsed into one loop.
   406  vec  (   4): Vectorized array expression.
   406  vec  (  29): ADB is used for array.: xyr_radlupflux
   406  vec  (  29): ADB is used for array.: xyrr_trans
   406  vec  (  29): ADB is used for array.: xyz_intpf
   413  opt  (1593): Loop nest collapsed into one loop.
   413  vec  (   4): Vectorized array expression.
   413  vec  (  29): ADB is used for array.: xyr_radlflux
   413  vec  (  29): ADB is used for array.: xyr_radldoflux
   413  vec  (  29): ADB is used for array.: xyr_radlupflux
   419  vec  (   3): Unvectorized loop.
   419  vec  (  13): Overhead of loop division is too large.
   420  opt  (  11): Fused array assignments. :line 420 - 422
   420  opt  (1593): Loop nest collapsed into one loop.
   420  vec  (   4): Vectorized array expression.
   420  vec  (  29): ADB is used for array.: xyra_delradlflux
   420  vec  (  29): ADB is used for array.: xyrr_trans
   420  vec  (  29): ADB is used for array.: xyz_intdpfdt
   511  opt  (1593): Loop nest collapsed into one loop.
   511  vec  (   4): Vectorized array expression.
   511  vec  (  29): ADB is used for array.: xyr_press
   511  vec  (  29): ADB is used for array.: xyz_press
   511  vec  (  29): ADB is used for array.: xyz_temp
   516  opt  (1593): Loop nest collapsed into one loop.
   516  vec  (   1): Vectorized loop.
   516  vec  (  29): ADB is used for array.: xyr_press
   516  vec  (  29): ADB is used for array.: xyz_press
   516  vec  (  29): ADB is used for array.: xyz_temp
   524  opt  (1593): Loop nest collapsed into one loop.
   524  vec  (   4): Vectorized array expression.
   524  vec  (  29): ADB is used for array.: xyz_temp
   527  opt  (1593): Loop nest collapsed into one loop.
   527  vec  (   4): Vectorized array expression.
   529  opt  (1593): Loop nest collapsed into one loop.
   529  vec  (   1): Vectorized loop.
   529  vec  (  29): ADB is used for array.: xyr_optdep
   533  opt  (1593): Loop nest collapsed into one loop.
   533  vec  (   4): Vectorized array expression.
   535  opt  (1593): Loop nest collapsed into one loop.
   535  vec  (   1): Vectorized loop.
   550  opt  (1593): Loop nest collapsed into one loop.
   550  vec  (   4): Vectorized array expression.
   550  vec  (  29): ADB is used for array.: xyr_radldwflux
   551  vec  (   3): Unvectorized loop.
   551  vec  (  13): Overhead of loop division is too large.
   552  opt  (1037): Feedback of array elements.
   552  opt  (1593): Loop nest collapsed into one loop.
   552  vec  (   4): Vectorized array expression.
   552  vec  (  29): ADB is used for array.: xyr_radldwflux
   564  opt  (1593): Loop nest collapsed into one loop.
   564  vec  (   4): Vectorized array expression.
   564  vec  (  29): ADB is used for array.: xyr_radluwflux
   564  vec  (  29): ADB is used for array.: xy_surfradsflux
   564  vec  (  29): ADB is used for array.: xyr_radldwflux
   566  vec  (   3): Unvectorized loop.
   566  vec  (  13): Overhead of loop division is too large.
   567  opt  (1037): Feedback of array elements.
   567  opt  (1593): Loop nest collapsed into one loop.
   567  vec  (   4): Vectorized array expression.
   567  vec  (  29): ADB is used for array.: xyr_radluwflux
   579  opt  (  11): Fused array assignments. :line 579 - 580
   579  opt  (1772): Loop nest fused with following nest(s).
   579  opt  (1593): Loop nest collapsed into one loop.
   579  vec  (   4): Vectorized array expression.
   579  vec  (  29): ADB is used for array.: xyra_delradldwflux
   579  vec  (  29): ADB is used for array.: xyra_delradluwflux
   613  opt  (1593): Loop nest collapsed into one loop.
   613  vec  (   1): Vectorized loop.
   613  vec  (  29): ADB is used for array.: xyr_radsflux
   613  vec  (  29): ADB is used for array.: xyr_optdep
   613  vec  (  29): ADB is used for array.: xy_cossza
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:39:00 2016
FILE NAME: rad_SL09.f90
PROGRAM NAME: rad_sl09
TRANSFORMATION LIST

  LINE                   FORTRAN STATEMENT

     1  != Schneider and Liu (2009) の放射モデル
     2  !
     3  != Radiation model by Schneider and Liu (2009)
     4  !
     5  ! Authors::   Yoshiyuki O. Takahashi
     6  ! Version::   $Id: rad_SL09.f90,v 1.6 2013/05/25 06:49:44 yot Exp $
     7  ! Tag Name::  $Name:  $
     8  ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9  ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10  !
    11  module rad_SL09
    12    !
    13    != Schneider and Liu (2009) の放射モデル
    14    !
    15    != Radiation model by Schneider and Liu (2009)
    16    !
    17    ! <b>Note that Japanese and English are described in parallel.</b>
    18    !
    19    !
    20    !
    21    ! This is a radiation model described by Schneider and Liu (2009).
    22    !
    23    !== References
    24    !
    25    !  Schneider, T. and J. Liu,
    26    !    Formation of jets and equatorial superrotation on Jupiter,
    27    !    J. Atmos. Sci., 69, 579, 2009.
    28    !
    29    !== Procedures List
    30    !
    31  !!$  ! RadiationFluxDennouAGCM :: 放射フラックスの計算
    32  !!$  ! RadiationDTempDt        :: 放射フラックスによる温度変化の計算
    33  !!$  ! RadiationFluxOutput     :: 放射フラックスの出力
    34  !!$  ! RadiationFinalize       :: 終了処理 (モジュール内部の変数の割り付け解除)
    35  !!$  ! ------------            :: ------------
    36  !!$  ! RadiationFluxDennouAGCM :: Calculate radiation flux
    37  !!$  ! RadiationDTempDt        :: Calculate temperature tendency with radiation flux
    38  !!$  ! RadiationFluxOutput     :: Output radiation fluxes
    39  !!$  ! RadiationFinalize       :: Termination (deallocate variables in this module)
    40    !
    41    !== NAMELIST
    42    !
    43    ! NAMELIST#rad_SL09_nml
    44    !
    45  
    46    ! USE statements
    47    !
    48  
    49    !
    50    ! Kind type parameter
    51    !
    52    use dc_types, only: DP, &      ! Double precision.
    53      &                 STRING, &  ! Strings.
    54      &                 TOKEN      ! Keywords.
    55  
    56    ! 格子点設定
    57    ! Grid points settings
    58    !
    59    use gridset, only: imax, & ! 経度格子点数.
    60                               ! Number of grid points in longitude
    61      &                jmax, & ! 緯度格子点数.
    62                               ! Number of grid points in latitude
    63      &                kmax    ! 鉛直層数.
    64                               ! Number of vertical level
    65  
    66    implicit none
    67  
    68    private
    69  
    70  
    71    ! Private variables
    72    !
    73    logical, save :: FlagGMIns
    74  
    75    real(DP), save :: SWOptDepAtRefPress
    76    real(DP), save :: SWRefPress
    77    real(DP), save :: SWOrd
    78    real(DP), save :: LWOptDepAtRefPress
    79    real(DP), save :: LWRefPress
    80    real(DP), save :: LWOrd
    81    real(DP), save :: SolarConst
    82  
    83  
    84    ! 公開変数
    85    ! Public variables
    86    !
    87    logical, save, public:: rad_SL09_inited = .false.
    88                                ! 初期設定フラグ.
    89                                ! Initialization flag
    90  
    91    public :: RadSL09Init
    92    public :: RadSL09Flux
    93  
    94    character(*), parameter:: module_name = 'rad_SL09'
    95                                ! モジュールの名称.
    96                                ! Module name
    97    character(*), parameter:: version = &
    98      & '$Name:  $' // &
    99      & '$Id: rad_SL09.f90,v 1.6 2013/05/25 06:49:44 yot Exp $'
   100                                ! モジュールのバージョン
   101                                ! Module version
   102  
   103    !--------------------------------------------------------------------------------------
   104  
   105  contains
   106  
   107    !--------------------------------------------------------------------------------------
   108  
   109    subroutine RadSL09Flux(                     &
   110      & xyr_Press, xyz_Press, xyz_Temp,         & ! (in)
   111      & xyr_RadSUwFlux, xyr_RadSDwFlux,         & ! (out)
   112      & xyr_RadLUwFlux, xyr_RadLDwFlux,         & ! (out)
   113      & xyra_DelRadLUwFlux, xyra_DelRadLDwFlux  & ! (out)
   114      & )
   115  
   116  
   117      ! USE statements
   118      !
   119  
   120      ! メッセージ出力
   121      ! Message output
   122      !
   123      use dc_message, only: MessageNotify
   124  
   125      ! 物理・数学定数設定
   126      ! Physical and mathematical constants settings
   127      !
   128      use constants0, only: &
   129        & PI                    ! $ \pi $ .
   130                                ! 円周率.  Circular constant
   131  
   132      ! 座標データ設定
   133      ! Axes data settings
   134      !
   135      use axesset, only : y_Lat
   136  
   137      !
   138      ! Solve radiative transfer equation in two stream approximation
   139      !
   140  !!$    use rad_rte_two_stream_app, only: OLD_RadRTETwoStreamAppHomogAtm
   141      use rad_rte_two_stream_app, only: RadRTETwoStreamAppHomogAtm
   142  
   143      real(DP), intent(in ) :: xyr_Press         (0:imax-1, 1:jmax, 0:kmax)
   144      real(DP), intent(in ) :: xyz_Press         (0:imax-1, 1:jmax, 1:kmax)
   145      real(DP), intent(in ) :: xyz_Temp          (0:imax-1, 1:jmax, 1:kmax)
   146      real(DP), intent(out) :: xyr_RadSUwFlux    (0:imax-1, 1:jmax, 0:kmax)
   147      real(DP), intent(out) :: xyr_RadSDwFlux    (0:imax-1, 1:jmax, 0:kmax)
   148      real(DP), intent(out) :: xyr_RadLUwFlux    (0:imax-1, 1:jmax, 0:kmax)
   149      real(DP), intent(out) :: xyr_RadLDwFlux    (0:imax-1, 1:jmax, 0:kmax)
   150      real(DP), intent(out) :: xyra_DelRadLUwFlux(0:imax-1, 1:jmax, 0:kmax, 0:1)
   151      real(DP), intent(out) :: xyra_DelRadLDwFlux(0:imax-1, 1:jmax, 0:kmax, 0:1)
   152  
   153  
   154      ! Work variables
   155      !
   156      real(DP) :: SolarFluxTOA
   157  !!$    real(DP) :: QeRatio
   158  !!$    real(DP) :: xyz_SSA      (0:imax-1, 1:jmax, 1:kmax)
   159  !!$    real(DP) :: xyz_AF       (0:imax-1, 1:jmax, 1:kmax)
   160  !!$    real(DP) :: xy_SurfAlbedo(0:imax-1, 1:jmax)
   161  !!$    real(DP) :: xy_InAngle   (0:imax-1, 1:jmax)
   162      real(DP) :: xy_CosSZA    (0:imax-1, 1:jmax)
   163      real(DP) :: xyr_OptDep   (0:imax-1, 1:jmax, 0:kmax)
   164  
   165      real(DP) :: SSA
   166      real(DP) :: AF
   167  
   168  !!$    integer  :: i
   169      integer  :: j
   170  !!$    integer  :: k
   171  
   172  
   173      ! 初期化
   174      ! Initialization
   175      !
   176      if ( .not. rad_SL09_inited ) then
   177        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   178      end if
   179  
   180  
   181      ! Short wave radiation
   182      !
   183      xyr_OptDep = SWOptDepAtRefPress * ( xyr_Press / SWRefPress )**SWOrd
     .        d1 = 1.D0/swrefpress                                              
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t225 = 1, jmax*(kmax*imax + imax)                              
     .           xyr_optdep(t225-1,1,0) = swoptdepatrefpress*(xyr_press(t225-1,1
     .       1      ,0)*d1)**sword                                              
     .        enddo                                                             
   184  
   185  
   186      SSA = 0.8_DP
   187      AF  = 0.204_DP
   188      !   Af = 0 may be much better than 0.204 when Eddington approximation is used.
   189  !!$    AF         = 0.0_DP
   190  
   191  
   192      if ( FlagGMIns ) then
   193        SolarFluxTOA = SolarConst / 4.0_DP
   194        xy_CosSZA    = 1.0_DP
     .        if (xy_cossza.DSC.U2 .gt. 0) then                                 
     .           j1 = and(xy_cossza.DSC.U2,3)                                   
     .  !cdir    nodep                                                          
     .           do t265 = 1, j1                                                
     .  !cdir       nodep                                                       
     .              do t267=1,xy_cossza.DSC.U1+2-min0(1,xy_cossza.DSC.U1+1)     
     .                 xy_cossza(t267-1,t265) = 1.00000000000000e+000           
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t265 = j1 + 1, xy_cossza.DSC.U2, 4                          
     .  !cdir       nodep                                                       
     .              do t267=1,xy_cossza.DSC.U1+2-min0(1,xy_cossza.DSC.U1+1)     
     .                 xy_cossza(t267-1,t265) = 1.00000000000000e+000           
     .                 xy_cossza(t267-1,t265+1) = 1.00000000000000e+000         
     .                 xy_cossza(t267-1,t265+2) = 1.00000000000000e+000         
     .                 xy_cossza(t267-1,t265+3) = 1.00000000000000e+000         
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
     .        goto 10016                                                        
   195      else
   196        SolarFluxTOA = SolarConst / PI
   197        do j = 1, jmax
   198          xy_CosSZA(:,j) = cos( y_Lat(j) )
   199        end do
     .        if (jmax .gt. 0) then                                             
     .           j2 = and(jmax,3)                                               
     .           do j = 1, j2                                                   
     .  !cdir       nodep                                                       
     .              do t237 = 1, xy_cossza.DSC.U1 + 1                           
     .                 xy_cossza(t237-1,j) = dcos(y_lat(j))                     
     .              enddo                                                       
     .           enddo                                                          
     .           do j = j2 + 1, jmax, 4                                         
     .  !cdir       nodep                                                       
     .              do t237 = 1, xy_cossza.DSC.U1 + 1                           
     .                 xy_cossza(t237-1,j) = dcos(y_lat(j))                     
     .                 xy_cossza(t237-1,j+1) = dcos(y_lat(j+1))                 
     .                 xy_cossza(t237-1,j+2) = dcos(y_lat(j+2))                 
     .                 xy_cossza(t237-1,j+3) = dcos(y_lat(j+3))                 
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
   200      end if
   201  !!$    do j = 1, jmax
   202  !!$      do i = 0, imax-1
   203  !!$        if ( xy_CosSZA(i,j) > 0.0_DP ) then
   204  !!$          xy_InAngle(i,j) = 1.0_DP / xy_CosSZA(i,j)
   205  !!$        else
   206  !!$          xy_InAngle(i,j) = 0.0_DP
   207  !!$        end if
   208  !!$      end do
   209  !!$    end do
   210  !!$
   211  !!$    !   Unused variable but this is required as an argument
   212  !!$    !
   213  !!$    xy_SurfAlbedo = 1.0d100
   214  !!$
   215  !!$    call OLD_RadRTETwoStreamAppHomogAtm(                                   &
   216  !!$      & xy_SurfAlbedo, SolarFluxTOA, xy_InAngle, SSA, AF, xyr_OptDep,  & ! (in )
   217  !!$      & xyr_RadSFlux,                                                  & ! (out)
   218  !!$      & FlagSemiInfAtm = .true., FlagSL09 = .true.                     & ! (in ) optional
   219  !!$      & )
   220  !!$
   221  !!$    call RadRTETwoStreamAppHomogAtm(                               &
   222  !!$      & xy_SurfAlbedo, SolarFluxTOA, xy_InAngle, SSA, AF, xyr_OptDep,  & ! (in )
   223  !!$      & xyr_RadSUwFlux, xyr_RadSDwFlux,                                & ! (out)
   224  !!$      & FlagSemiInfAtm = .true., FlagSL09 = .true                      & ! (in ) optional
   225  !!$      & )
   226  
   227      call RadSL09SWFlux(                                     &
   228        & SolarFluxTOA, xy_CosSZA, SSA, AF, xyr_OptDep,       &
   229        & xyr_RadSUwFlux                                      &
   230        & )
   231      xyr_RadSDwFlux = 0.0_DP
     .        d2 = 1.D0/lwrefpress                                              
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t240 = 1, jmax*(kmax*imax + imax)                              
     .           xyr_radsdwflux(t240-1,1,0) = 0.0000000000000000e+000           
     .           xyr_optdep(t240-1,1,0) = lwoptdepatrefpress*(xyr_press(t240-1,1
     .       1      ,0)*d2)**lword                                              
     .        enddo                                                             
   232  
   233  
   234  
   235      ! Long wave radiation
   236      !
   237  
   238      !   Although the surface temperature and surface emissivity are set, but are not used.
   239      !
   240      xyr_OptDep = LWOptDepAtRefPress * ( xyr_Press / LWRefPress )**LWOrd
   241  
   242  
   243  !!$    call RadiationRTEQNonScat(                    &
   244  !!$      & xyz_Temp, xy_SurfTemp, xy_SurfEmis, xyr_OptDep, & ! (in )
   245  !!$      & xyr_RadLFlux, xyra_DelRadLFlux,                 & ! (out)
   246  !!$      & xy_SurfUpRadLFluxBase = xyr_RadSFlux(:,:,0)     & ! (in ) optional
   247  !!$      & )
   248  !!$    call RadSL09LWFlux(                           &
   249  !!$      & xyz_Temp, xyr_OptDep,                     & ! (in )
   250  !!$      & xyr_RadSFlux(:,:,0),                      & ! (in )
   251  !!$      & xyr_RadLFlux, xyra_DelRadLFlux            & ! (out)
   252  !!$      & )
   253      call RadSL09LWFlux(                       &
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t255 = 1, jmax*imax                                            
     .           %IG0(t255,1) = xyr_radsuwflux(t255-1,1,0) - xyr_radsdwflux(t255
     .       1      -1,1,0)                                                     
     .        enddo                                                             
   254        & xyr_Press, xyz_Press, xyz_Temp, xyr_OptDep,  & ! (in )
   255        & xyr_RadSUwFlux(:,:,0)-xyr_RadSDwFlux(:,:,0), & ! (in )
   256        & xyr_RadLUwFlux, xyr_RadLDwFlux,              & ! (out)
   257        & xyra_DelRadLUwFlux, xyra_DelRadLDwFlux       & ! (out)
   258        & )
   259  
   260  
   261    end subroutine RadSL09Flux
   262  
   263    !--------------------------------------------------------------------------------------
   264  
   265    subroutine OLD_RadSL09LWFlux(                           &
   266      & xyz_Temp, xyr_OptDep,                           & ! (in )
   267      & xy_SurfUpRadLFluxBase,                          & ! (in )
   268      & xyr_RadLFlux, xyra_DelRadLFlux                  & ! (out)
   269      & )
   270      !
   271      ! 散乱なしの場合の放射伝達方程式の計算
   272      !
   273      ! Integrate radiative transfer equation without scattering
   274      !
   275  
   276      ! モジュール引用 ; USE statements
   277      !
   278  
   279      ! メッセージ出力
   280      ! Message output
   281      !
   282      use dc_message, only: MessageNotify
   283  
   284      ! 物理・数学定数設定
   285      ! Physical and mathematical constants settings
   286      !
   287      use constants0, only: &
   288        & PI, &
   289                                ! $ \pi $ .
   290                                ! 円周率.  Circular constant
   291        & StB
   292                                ! $ \sigma_{SB} $ .
   293                                ! ステファンボルツマン定数.
   294                                ! Stefan-Boltzmann constant
   295  
   296      ! 宣言文 ; Declaration statements
   297      !
   298  
   299      real(DP), intent(in ) :: xyz_Temp    (0:imax-1, 1:jmax, 1:kmax)
   300                                ! $ T $ .     温度. Temperature
   301      real(DP), intent(in ) :: xyr_OptDep  (0:imax-1, 1:jmax, 0:kmax)
   302                                ! Optical depth
   303      real(DP), intent(in ) :: xy_SurfUpRadLFluxBase(0:imax-1, 1:jmax)
   304      real(DP), intent(out) :: xyr_RadLFlux (0:imax-1, 1:jmax, 0:kmax)
   305                                ! 長波フラックス.
   306                                ! Longwave flux
   307      real(DP), intent(out) :: xyra_DelRadLFlux (0:imax-1, 1:jmax, 0:kmax, 0:1)
   308                                ! 長波地表温度変化.
   309                                ! Surface temperature tendency with longwave
   310  
   311  
   312      ! 作業変数
   313      ! Work variables
   314      !
   315      real(DP), parameter :: DiffFact = 1.66_DP
   316  
   317      real(DP):: xyr_RadLDoFlux (0:imax-1, 1:jmax, 0:kmax)
   318      real(DP):: xyr_RadLUpFlux (0:imax-1, 1:jmax, 0:kmax)
   319  
   320      real(DP):: xyz_DelTrans (0:imax-1, 1:jmax, 1:kmax)
   321      real(DP):: xyrr_Trans   (0:imax-1, 1:jmax, 0:kmax, 0:kmax)
   322                                ! 透過係数.
   323                                ! Transmission coefficient
   324      real(DP):: xyz_IntPF        (0:imax-1, 1:jmax, 1:kmax)
   325                                ! Integrated Planck function
   326      real(DP):: xyz_IntDPFDT     (0:imax-1, 1:jmax, 1:kmax)
   327                                ! Integrated temperature derivative of Planck function
   328  
   329      real(DP):: xy_SurfUpRadLFlux(0:imax-1, 1:jmax)
   330  
   331      integer:: k, kk           ! 鉛直方向に回る DO ループ用作業変数
   332                                ! Work variables for DO loop in vertical direction
   333  
   334      ! 実行文 ; Executable statement
   335      !
   336  
   337      ! 初期化
   338      ! Initialization
   339      !
   340      if ( .not. rad_SL09_inited ) then
   341        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   342      end if
   343  
   344  
   345      ! Case for grey atmosphere
   346      !
   347      xyz_IntPF       = StB * xyz_Temp**4
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t407 = 1, kmax*jmax*imax                                       
     .           xyz_intpf(t407-1,1,1) = 5.67037300000000e-008*xyz_temp(t407-1,1
     .       1      ,1)**4                                                      
     .           xyz_intdpfdt(t407-1,1,1) = 2.26814920000000e-007*xyz_temp(t407-
     .       1      1,1,1)**3                                                   
     .        enddo                                                             
   348      xyz_IntDPFDT    = 4.0_DP * StB * xyz_Temp**3
   349  
   350  
   351      ! 透過関数計算
   352      ! Calculate transmission functions
   353      !
   354      do k = 1, kmax
   355        xyz_DelTrans(:,:,k) = &
   356          & exp( - DiffFact * ( xyr_OptDep(:,:,k-1) - xyr_OptDep(:,:,k) ) )
   357      end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do k = 1, kmax*jmax*imax                                          
     .           xyz_deltrans(k-1,1,1) = dexp((-1.65999999999999e+000*(         
     .       1      xyr_optdep(k-1,1,0)-xyr_optdep(k-1,1,1))))                  
     .        enddo                                                             
   358      !
   359      do k = 0, kmax
   360        do kk = k, k
   361          xyrr_Trans(:,:,k,kk) = 1.0_DP
   362        end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t435 = 1, xyrr_trans.DSC.U2*xyrr_trans.DSC.U1 +                
     .       1   xyrr_trans.DSC.U2                                              
     .           xyrr_trans(t435-1,1,k,k) = 1.00000000000000e+000               
     .        enddo                                                             
   363        do kk = k+1, kmax
   364          xyrr_Trans(:,:,k,kk) = xyrr_Trans(:,:,k,kk-1) * xyz_DelTrans(:,:,kk)
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xyrr_trans)                                                
     .        do t441 = 1, xyrr_trans.DSC.U2*xyrr_trans.DSC.U1 +                
     .       1   xyrr_trans.DSC.U2                                              
     .           xyrr_trans(t441-1,1,k,kk) = xyrr_trans(t441-1,1,k,kk-1)*       
     .       1      xyz_deltrans(t441-1,1,kk)                                   
     .        enddo                                                             
   365        end do
   366      end do
   367      do k = 0, kmax
   368        do kk = 0, k-1
   369          xyrr_Trans(:,:,k,kk) = xyrr_Trans(:,:,kk,k)
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xyrr_trans)                                                
     .        do t451 = 1, xyrr_trans.DSC.U2*xyrr_trans.DSC.U1 +                
     .       1   xyrr_trans.DSC.U2                                              
     .           xyrr_trans(t451-1,1,k,kk) = xyrr_trans(t451-1,1,kk,k)          
     .        enddo                                                             
   370        end do
   371      end do
   372  
   373  
   374      ! 放射フラックス計算
   375      ! Calculate radiation flux
   376      !
   377  
   378      !   Initialization
   379      !
   380      xyr_RadLDoFlux = 0.0_DP
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t459 = 1, (xyr_radldoflux.DSC.U3 + 1)*xyr_radldoflux.DSC.U2*(  
     .       1   xyr_radldoflux.DSC.U1 + 1)                                     
     .           xyr_radldoflux(t459-1,1,0) = 0.0000000000000000e+000           
     .           xyr_radlupflux(t459-1,1,0) = 0.0000000000000000e+000           
     .        enddo                                                             
   381      xyr_RadLUpFlux = 0.0_DP
   382      !
   383      !   Downward flux
   384      !
   385      do k = kmax, 0, -1
   386  
   387        do kk = kmax, k+1, -1
   388          xyr_RadLDoFlux(:,:,k) = xyr_RadLDoFlux(:,:,k)          &
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xyrr_trans,xyr_radldoflux,xyz_intpf)                       
     .        do t471 = 1, xyr_radldoflux.DSC.U2*xyr_radldoflux.DSC.U1 +        
     .       1   xyr_radldoflux.DSC.U2                                          
     .           xyr_radldoflux(t471-1,1,k) = xyr_radldoflux(t471-1,1,k) +      
     .       1      xyz_intpf(t471-1,1,kk)*(xyrr_trans(t471-1,1,k,kk-1)-        
     .       2      xyrr_trans(t471-1,1,k,kk))                                  
     .        enddo                                                             
   389            & + xyz_IntPF(:,:,kk)                                &
   390            & * ( xyrr_Trans(:,:,k,kk-1) - xyrr_Trans(:,:,k,kk) )
   391        end do
   392  
   393      end do
   394      !
   395      !   Upward flux
   396      !
   397      !     Set upward flux
   398      !
   399      xy_SurfUpRadLFlux = xyr_RadLDoFlux(:,:,0) - xy_SurfUpRadLFluxBase
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xyr_radldoflux)                                            
     .        do t485 = 1, xyr_radldoflux.DSC.U2*xyr_radldoflux.DSC.U1 +        
     .       1   xyr_radldoflux.DSC.U2                                          
     .           xy_surfupradlflux(t485-1,1) = xyr_radldoflux(t485-1,1,0) -     
     .       1      xy_surfupradlfluxbase(t485-1,1)                             
     .        enddo                                                             
   400      !
   401      do k = 0, kmax
   402  
   403        xyr_RadLUpFlux(:,:,k) = xy_SurfUpRadLFlux * xyrr_Trans(:,:,k,0)
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xyrr_trans,xy_surfupradlflux)                              
     .        do t495 = 1, xy_surfupradlflux.DSC.U2*xy_surfupradlflux.DSC.U1 +  
     .       1   xy_surfupradlflux.DSC.U2                                       
     .           xyr_radlupflux(t495-1,1,k) = xy_surfupradlflux(t495-1,1)*      
     .       1      xyrr_trans(t495-1,1,k,0)                                    
     .        enddo                                                             
   404  
   405        do kk = 1, k
   406          xyr_RadLUpFlux(:,:,k) = xyr_RadLUpFlux(:,:,k)          &
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xyrr_trans,xyz_intpf,xyr_radlupflux)                       
     .        do t505 = 1, xyr_radlupflux.DSC.U2*xyr_radlupflux.DSC.U1 +        
     .       1   xyr_radlupflux.DSC.U2                                          
     .           xyr_radlupflux(t505-1,1,k) = xyr_radlupflux(t505-1,1,k) -      
     .       1      xyz_intpf(t505-1,1,kk)*(xyrr_trans(t505-1,1,k,kk-1)-        
     .       2      xyrr_trans(t505-1,1,k,kk))                                  
     .        enddo                                                             
   407            & - xyz_IntPF(:,:,kk)                                &
   408            & * ( xyrr_Trans(:,:,k,kk-1) - xyrr_Trans(:,:,k,kk) )
   409        end do
   410  
   411      end do
   412  
   413      xyr_RadLFlux = xyr_RadLUpFlux - xyr_RadLDoFlux
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xyr_radldoflux,xyr_radlupflux)                             
     .        do t519 = 1, (xyr_radlupflux.DSC.U3 + 1)*xyr_radlupflux.DSC.U2*(  
     .       1   xyr_radlupflux.DSC.U1 + 1)                                     
     .           xyr_radlflux(t519-1,1,0) = xyr_radlupflux(t519-1,1,0) -        
     .       1      xyr_radldoflux(t519-1,1,0)                                  
     .        enddo                                                             
   414  
   415  
   416      ! 放射フラックスの変化率の計算
   417      ! Calculate rate of change of radiative flux
   418      !
   419      do k = 0, kmax
   420        xyra_DelRadLFlux(:,:,k,0) = 0.0_DP
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xyrr_trans,xyz_intdpfdt)                                   
     .        do t534 = 1, jmax*imax                                            
     .           xyra_delradlflux(t534-1,1,k,0) = 0.0000000000000000e+000       
     .           xyra_delradlflux(t534-1,1,k,1) = -xyz_intdpfdt(t534-1,1,1)*(   
     .       1      xyrr_trans(t534-1,1,k,0)-xyrr_trans(t534-1,1,k,1))          
     .        enddo                                                             
   421  
   422        xyra_DelRadLFlux(:,:,k,1) =                           &
   423          & - xyz_IntDPFDT(:,:,1)                             &
   424          &   * ( xyrr_Trans(:,:,k,0) - xyrr_Trans(:,:,k,1) )
   425      end do
   426  
   427    end subroutine OLD_RadSL09LWFlux
   428  
   429    !--------------------------------------------------------------------------------------
   430  
   431    subroutine RadSL09LWFlux(                       &
   432      & xyr_Press, xyz_Press, xyz_Temp, xyr_OptDep, & ! (in )
   433      & xy_SurfRadSFlux,                            & ! (in )
   434      & xyr_RadLUwFlux, xyr_RadLDwFlux,             & ! (out)
   435      & xyra_DelRadLUwFlux, xyra_DelRadLDwFlux      & ! (out)
   436      & )
   437      !
   438      ! 散乱なしの場合の放射伝達方程式の計算
   439      !
   440      ! Integrate radiative transfer equation without scattering
   441      !
   442  
   443      ! モジュール引用 ; USE statements
   444      !
   445  
   446      ! メッセージ出力
   447      ! Message output
   448      !
   449      use dc_message, only: MessageNotify
   450  
   451      ! 物理・数学定数設定
   452      ! Physical and mathematical constants settings
   453      !
   454      use constants0, only: &
   455        & StB
   456                                ! $ \sigma_{SB} $ .
   457                                ! ステファンボルツマン定数.
   458                                ! Stefan-Boltzmann constant
   459  
   460      ! 宣言文 ; Declaration statements
   461      !
   462  
   463      real(DP), intent(in ) :: xyr_Press   (0:imax-1, 1:jmax, 0:kmax)
   464      real(DP), intent(in ) :: xyz_Press   (0:imax-1, 1:jmax, 1:kmax)
   465      real(DP), intent(in ) :: xyz_Temp    (0:imax-1, 1:jmax, 1:kmax)
   466                                ! $ T $ .     温度. Temperature
   467      real(DP), intent(in ) :: xyr_OptDep  (0:imax-1, 1:jmax, 0:kmax)
   468                                ! Optical depth
   469      real(DP), intent(in ) :: xy_SurfRadSFlux(0:imax-1, 1:jmax)
   470      real(DP), intent(out) :: xyr_RadLUwFlux (0:imax-1, 1:jmax, 0:kmax)
   471                                ! 長波フラックス.
   472                                ! Longwave flux
   473      real(DP), intent(out) :: xyr_RadLDwFlux (0:imax-1, 1:jmax, 0:kmax)
   474                                ! 長波フラックス.
   475                                ! Longwave flux
   476      real(DP), intent(out) :: xyra_DelRadLUwFlux (0:imax-1, 1:jmax, 0:kmax, 0:1)
   477                                ! 長波地表温度変化.
   478                                ! Surface temperature tendency with longwave
   479      real(DP), intent(out) :: xyra_DelRadLDwFlux (0:imax-1, 1:jmax, 0:kmax, 0:1)
   480                                ! 長波地表温度変化.
   481                                ! Surface temperature tendency with longwave
   482  
   483  
   484      ! 作業変数
   485      ! Work variables
   486      !
   487      real(DP):: xyr_Temp       (0:imax-1, 1:jmax, 0:kmax)
   488      real(DP):: xyr_IntPF      (0:imax-1, 1:jmax, 0:kmax)
   489                                ! Integrated Planck function
   490      real(DP):: xyz_DPFDOptDep (0:imax-1, 1:jmax, 1:kmax)
   491      real(DP):: xyz_DelOptDep     (0:imax-1, 1:jmax, 1:kmax)
   492      real(DP):: xyz_TransEachLayer(0:imax-1, 1:jmax, 1:kmax)
   493                                ! 透過係数.
   494                                ! Transmission coefficient
   495  
   496      integer:: k               ! 鉛直方向に回る DO ループ用作業変数
   497                                ! Work variables for DO loop in vertical direction
   498  
   499      ! 実行文 ; Executable statement
   500      !
   501  
   502      ! 初期化
   503      ! Initialization
   504      !
   505      if ( .not. rad_SL09_inited ) then
   506        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   507      end if
   508  
   509  
   510      k = 0
   511      xyr_Temp(:,:,k) =                                    &
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t406 = 1, jmax*imax                                            
     .           xyr_temp(t406-1,1,0) = (xyz_temp(t406-1,1,2)-xyz_temp(t406-1,1,
     .       1      1))/dlog(xyz_press(t406-1,1,2)/xyz_press(t406-1,1,1))*dlog( 
     .       2      xyr_press(t406-1,1,0)/xyz_press(t406-1,1,1)) + xyz_temp(t406
     .       3      -1,1,1)                                                     
     .        enddo                                                             
   512        &      ( xyz_Temp (:,:,k+2) - xyz_Temp (:,:,k+1) ) &
   513        & / log( xyz_Press(:,:,k+2) / xyz_Press(:,:,k+1) ) &
   514        & * log( xyr_Press(:,:,k  ) / xyz_Press(:,:,k+1) ) &
   515        & + xyz_Temp(:,:,k+1)
   516      do k = 1, kmax-1
   517        xyr_Temp(:,:,k) =                                &
   518          &      ( xyz_Temp (:,:,k+1) - xyz_Temp (:,:,k) ) &
   519          & / log( xyz_Press(:,:,k+1) / xyz_Press(:,:,k) ) &
   520          & * log( xyr_Press(:,:,k  ) / xyz_Press(:,:,k) ) &
   521          & + xyz_Temp(:,:,k)
   522      end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do k = 1, jmax*(kmax*imax - imax)                                 
     .           xyr_temp(k-1,1,1) = (xyz_temp(k-1,1,2)-xyz_temp(k-1,1,1))/dlog(
     .       1      xyz_press(k-1,1,2)/xyz_press(k-1,1,1))*dlog(xyr_press(k-1,1,
     .       2      1)/xyz_press(k-1,1,1)) + xyz_temp(k-1,1,1)                  
     .        enddo                                                             
   523      k = kmax
   524      xyr_Temp(:,:,k) = xyz_Temp(:,:,k)
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t446 = 1, xyr_temp.DSC.U2*xyr_temp.DSC.U1 + xyr_temp.DSC.U2    
     .           xyr_temp(t446-1,1,k) = xyz_temp(t446-1,1,k)                    
     .        enddo                                                             
   525  
   526  
   527      xyr_IntPF       = StB * xyr_Temp**4
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t454 = 1, (xyr_temp.DSC.U3 + 1)*xyr_temp.DSC.U2*(              
     .       1   xyr_temp.DSC.U1 + 1)                                           
     .           xyr_intpf(t454-1,1,0) = 5.67037300000000e-008*xyr_temp(t454-1,1
     .       1      ,0)**4                                                      
     .        enddo                                                             
   528      !
   529      do k = 1, kmax
   530        xyz_DelOptDep(:,:,k) = xyr_OptDep(:,:,k-1) - xyr_OptDep(:,:,k)
   531      end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do k = 1, kmax*jmax*imax                                          
     .           xyz_deloptdep(k-1,1,1)=xyr_optdep(k-1,1,0)-xyr_optdep(k-1,1,1) 
     .        enddo                                                             
   532      !
   533      xyz_TransEachLayer = exp( - xyz_DelOptDep )
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t476 = 1, xyz_deloptdep.DSC.U3*(xyz_deloptdep.DSC.U2*          
     .       1   xyz_deloptdep.DSC.U1 + xyz_deloptdep.DSC.U2)                   
     .           xyz_transeachlayer(t476-1,1,1) = dexp((-xyz_deloptdep(t476-1,1,
     .       1      1)))                                                        
     .        enddo                                                             
   534      !
   535      do k = 1, kmax
   536        xyz_DPFDOptDep(:,:,k) =                      &
   537          &   ( xyr_IntPF(:,:,k-1) - xyr_IntPF(:,:,k) ) &
   538          & / max( xyz_DelOptDep(:,:,k), 1.0d-100 )
   539      end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do k = 1, kmax*(xyr_intpf.DSC.U2*xyr_intpf.DSC.U1 +               
     .       1   xyr_intpf.DSC.U2)                                              
     .           xyz_dpfdoptdep(k-1,1,1) = (xyr_intpf(k-1,1,0)-xyr_intpf(k-1,1,1
     .       1      ))/max(xyz_deloptdep(k-1,1,1),1.00000000000000e-100)        
     .        enddo                                                             
   540  
   541  
   542      ! 放射フラックス計算
   543      ! Calculate radiation flux
   544      !
   545  
   546      !
   547      !   Downward flux
   548      !
   549      k = kmax
   550      xyr_RadLDwFlux(:,:,k) = 0.0_DP
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t500 = 1, jmax*imax                                            
     .           xyr_radldwflux(t500-1,1,k) = 0.0000000000000000e+000           
     .        enddo                                                             
   551      do k = kmax-1, 0, -1
   552        xyr_RadLDwFlux(:,:,k) =                                &
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t506 = 1, jmax*imax                                            
     .           xyr_radldwflux(t506-1,1,k) = (xyr_radldwflux(t506-1,1,k+1)-    
     .       1      xyr_intpf(t506-1,1,k+1))*xyz_transeachlayer(t506-1,1,k+1) + 
     .       2      xyr_intpf(t506-1,1,k) - xyz_dpfdoptdep(t506-1,1,k+1)*(      
     .       3      1.00000000000000e+000 - xyz_transeachlayer(t506-1,1,k+1))   
     .        enddo                                                             
   553          &   ( xyr_RadLDwFlux(:,:,k+1) - xyr_IntPF(:,:,k+1) ) &
   554          & * xyz_TransEachLayer(:,:,k+1)                      &
   555          & + xyr_IntPF(:,:,k)                                 &
   556          & - xyz_DPFDOptDep(:,:,k+1)                          &
   557          &   * ( 1.0_DP - xyz_TransEachLayer(:,:,k+1) )
   558      end do
   559      !
   560      !   Upward flux
   561      !
   562      !     Set upward flux
   563      k = 0
   564      xyr_RadLUwFlux(:,:,k) = xyr_RadLDwFlux(:,:,0) - xy_SurfRadSFlux
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t524 = 1, jmax*imax                                            
     .           xyr_radluwflux(t524-1,1,0) = xyr_radldwflux(t524-1,1,0) -      
     .       1      xy_surfradsflux(t524-1,1)                                   
     .        enddo                                                             
   565      !
   566      do k = 1, kmax
   567        xyr_RadLUwFlux(:,:,k) =                                &
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t534 = 1, jmax*imax                                            
     .           xyr_radluwflux(t534-1,1,k) = (xyr_radluwflux(t534-1,1,k-1)-    
     .       1      xyr_intpf(t534-1,1,k-1))*xyz_transeachlayer(t534-1,1,k) +   
     .       2      xyr_intpf(t534-1,1,k) + xyz_dpfdoptdep(t534-1,1,k)*(        
     .       3      1.00000000000000e+000 - xyz_transeachlayer(t534-1,1,k))     
     .        enddo                                                             
   568          &   ( xyr_RadLUwFlux(:,:,k-1) - xyr_IntPF(:,:,k-1) ) &
   569          & * xyz_TransEachLayer(:,:,k)                        &
   570          & + xyr_IntPF(:,:,k)                                 &
   571          & + xyz_DPFDOptDep(:,:,k)                            &
   572          &   * ( 1.0_DP - xyz_TransEachLayer(:,:,k) )
   573      end do
   574  
   575  
   576      ! 放射フラックスの変化率の計算
   577      ! Calculate rate of change of radiative flux
   578      !
   579      xyra_DelRadLUwFlux = 0.0_DP
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t554 = 1, jmax*(kmax*imax + imax)                              
     .           xyra_delradluwflux(t554-1,1,0,0) = 0.0000000000000000e+000     
     .           xyra_delradldwflux(t554-1,1,0,0) = 0.0000000000000000e+000     
     .           xyra_delradluwflux(t554-1,1,0,1) = 0.0000000000000000e+000     
     .           xyra_delradldwflux(t554-1,1,0,1) = 0.0000000000000000e+000     
     .        enddo                                                             
   580      xyra_DelRadLDwFlux = 0.0_DP
   581  
   582  
   583    end subroutine RadSL09LWFlux
   584  
   585    !--------------------------------------------------------------------------------------
   586  
   587    subroutine RadSL09SWFlux(                                     &
   588      & SolarFluxTOA, xy_CosSZA, SSA, AF, xyr_OptDep,             &
   589      & xyr_RadSFlux                                              &
   590      & )
   591  
   592      real(DP), intent(in ) :: SolarFluxTOA
   593      real(DP), intent(in ) :: xy_CosSZA(0:imax-1, 1:jmax)
   594      real(DP), intent(in ) :: SSA
   595      real(DP), intent(in ) :: AF
   596      real(DP), intent(in ) :: xyr_OptDep   ( 0:imax-1, 1:jmax, 0:kmax )
   597      real(DP), intent(out) :: xyr_RadSFlux ( 0:imax-1, 1:jmax, 0:kmax )
   598  
   599      ! Work variables
   600      !
   601      real(DP) :: BondAlbedo
   602      real(DP) :: Gamma
   603      integer  :: j, k
   604  
   605  
   606      BondAlbedo = &
   607        &   ( sqrt( 1.0_DP - SSA * AF ) - sqrt( 1.0_DP - SSA ) ) &
   608        & / ( sqrt( 1.0_DP - SSA * AF ) + sqrt( 1.0_DP - SSA ) )
   609  
   610      Gamma = 2.0_DP * sqrt( 1.0_DP - SSA ) * sqrt( 1.0_DP - SSA * AF )
   611  
   612      do k = 0, kmax
   613        do j = 1, jmax
   614          xyr_RadSFlux(:,j,k) =                   &
   615            & - SolarFluxTOA * xy_CosSZA(:,j) &
   616            & * ( 1.0_DP - BondAlbedo ) * exp( -Gamma * xyr_OptDep(:,j,k) )
   617        end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xy_cossza)                                                 
     .        do j = 1, jmax*imax                                               
     .           xyr_radsflux(j-1,1,k) = -solarfluxtoa*xy_cossza(j-1,1)*(       
     .       1      1.00000000000000e+000 - bondalbedo)*dexp((-gamma*xyr_optdep(
     .       2      j-1,1,k)))                                                  
     .        enddo                                                             
   618      end do
   619  
   620  
   621    end subroutine RadSL09SWFlux
   622  
   623    !--------------------------------------------------------------------------------------
   624  
   625    subroutine RadSL09Init
   626  
   627      ! ファイル入出力補助
   628      ! File I/O support
   629      !
   630      use dc_iounit, only: FileOpen
   631  
   632      ! NAMELIST ファイル入力に関するユーティリティ
   633      ! Utilities for NAMELIST file input
   634      !
   635      use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid
   636  
   637      ! メッセージ出力
   638      ! Message output
   639      !
   640      use dc_message, only: MessageNotify
   641  
   642      !
   643      ! Solve radiative transfer equation in two stream approximation
   644      !
   645      use rad_rte_two_stream_app, only: RadRTETwoStreamAppInit
   646  
   647  
   648      ! 宣言文 ; Declaration statements
   649      !
   650  
   651      integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号.
   652                                ! Unit number for NAMELIST file open
   653      integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT.
   654                                ! IOSTAT of NAMELIST read
   655  
   656      ! NAMELIST 変数群
   657      ! NAMELIST group name
   658      !
   659      namelist /rad_SL09_nml/ &
   660        & FlagGMIns,                             &
   661        & SWOptDepAtRefPress, SWRefPress, SWOrd, &
   662        & LWOptDepAtRefPress, LWRefPress, LWOrd, &
   663        & SolarConst
   664            !
   665            ! デフォルト値については初期化手続 "rad_SL09#RadSL09Init"
   666            ! のソースコードを参照のこと.
   667            !
   668            ! Refer to source codes in the initialization procedure
   669            ! "rad_SL09#RadSL09Init" for the default values.
   670            !
   671  
   672  
   673      if ( rad_SL09_inited ) return
   674  
   675  
   676      ! デフォルト値の設定
   677      ! Default values settings
   678      !
   679      FlagGMIns          = .false.
   680  
   681      SWOptDepAtRefPress =  3.0_DP
   682      SWRefPress         =  3.0d5
   683      SWOrd              =  1.0_DP
   684  
   685      LWOptDepAtRefPress = 80.0_DP
   686      LWRefPress         =  3.0d5
   687      LWOrd              =  2.0_DP
   688  
   689      SolarConst         = 50.7_DP
   690  
   691  
   692  
   693  
   694      ! NAMELIST の読み込み
   695      ! NAMELIST is input
   696      !
   697      if ( trim(namelist_filename) /= '' ) then
   698        call FileOpen( unit_nml, &          ! (out)
   699          & namelist_filename, mode = 'r' ) ! (in)
   700  
   701        rewind( unit_nml )
   702        read( unit_nml,                     & ! (in)
   703          & nml = rad_SL09_nml,             & ! (out)
   704          & iostat = iostat_nml )             ! (out)
   705        close( unit_nml )
   706  
   707        call NmlutilMsg( iostat_nml, module_name ) ! (in)
   708      end if
   709  
   710  
   711      ! Initialization of modules used in this module
   712      !
   713  
   714      !
   715      ! Solve radiative transfer equation in two stream approximation
   716      !
   717      call RadRTETwoStreamAppInit
   718  
   719  
   720      ! 印字 ; Print
   721      !
   722      call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   723      call MessageNotify( 'M', module_name, 'FlagGMIns          = %b', l = (/ FlagGMIns /) )
   724      call MessageNotify( 'M', module_name, 'SWOptDepAtRefPress = %f', d = (/ SWOptDepAtRefPress /) )
   725      call MessageNotify( 'M', module_name, 'SWRefPress         = %f', d = (/ SWRefPress /) )
   726      call MessageNotify( 'M', module_name, 'SWOrd              = %f', d = (/ SWOrd /) )
   727      call MessageNotify( 'M', module_name, 'LWOptDepAtRefPress = %f', d = (/ LWOptDepAtRefPress /) )
   728      call MessageNotify( 'M', module_name, 'LWRefPress         = %f', d = (/ LWRefPress /) )
   729      call MessageNotify( 'M', module_name, 'LWOrd              = %f', d = (/ LWOrd /) )
   730      call MessageNotify( 'M', module_name, 'SolarConst         = %f', d = (/ SolarConst /) )
   731      call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   732  
   733  
   734      rad_SL09_inited = .true.
   735  
   736    end subroutine RadSL09Init
   737  
   738    !--------------------------------------------------------------------------------------
   739  
   740  end module rad_SL09
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:39:00 2016
FILE NAME: rad_SL09.f90
PROGRAM NAME: rad_sl09
FORMAT LIST

  LINE    LOOP      FORTRAN STATEMENT

     1:             != Schneider and Liu (2009) の放射モデル
     2:             !
     3:             != Radiation model by Schneider and Liu (2009)
     4:             !
     5:             ! Authors::   Yoshiyuki O. Takahashi
     6:             ! Version::   $Id: rad_SL09.f90,v 1.6 2013/05/25 06:49:44 yot Exp $
     7:             ! Tag Name::  $Name:  $
     8:             ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9:             ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10:             !
    11:             module rad_SL09
    12:               !
    13:               != Schneider and Liu (2009) の放射モデル
    14:               !
    15:               != Radiation model by Schneider and Liu (2009)
    16:               !
    17:               ! <b>Note that Japanese and English are described in parallel.</b>
    18:               !
    19:               ! 
    20:               !
    21:               ! This is a radiation model described by Schneider and Liu (2009). 
    22:               !
    23:               !== References
    24:               !
    25:               !  Schneider, T. and J. Liu, 
    26:               !    Formation of jets and equatorial superrotation on Jupiter, 
    27:               !    J. Atmos. Sci., 69, 579, 2009.
    28:               !
    29:               !== Procedures List
    30:               !
    31:             !!$  ! RadiationFluxDennouAGCM :: 放射フラックスの計算
    32:             !!$  ! RadiationDTempDt        :: 放射フラックスによる温度変化の計算
    33:             !!$  ! RadiationFluxOutput     :: 放射フラックスの出力
    34:             !!$  ! RadiationFinalize       :: 終了処理 (モジュール内部の変数の割り付け解除)
    35:             !!$  ! ------------            :: ------------
    36:             !!$  ! RadiationFluxDennouAGCM :: Calculate radiation flux
    37:             !!$  ! RadiationDTempDt        :: Calculate temperature tendency with radiation flux
    38:             !!$  ! RadiationFluxOutput     :: Output radiation fluxes
    39:             !!$  ! RadiationFinalize       :: Termination (deallocate variables in this module)
    40:               !
    41:               !== NAMELIST
    42:               !
    43:               ! NAMELIST#rad_SL09_nml
    44:               !
    45:             
    46:               ! USE statements
    47:               !
    48:             
    49:               !
    50:               ! Kind type parameter
    51:               !
    52:               use dc_types, only: DP, &      ! Double precision.
    53:                 &                 STRING, &  ! Strings.
    54:                 &                 TOKEN      ! Keywords.
    55:             
    56:               ! 格子点設定
    57:               ! Grid points settings
    58:               !
    59:               use gridset, only: imax, & ! 経度格子点数.
    60:                                          ! Number of grid points in longitude
    61:                 &                jmax, & ! 緯度格子点数.
    62:                                          ! Number of grid points in latitude
    63:                 &                kmax    ! 鉛直層数.
    64:                                          ! Number of vertical level
    65:             
    66:               implicit none
    67:             
    68:               private
    69:             
    70:             
    71:               ! Private variables
    72:               !
    73:               logical, save :: FlagGMIns
    74:             
    75:               real(DP), save :: SWOptDepAtRefPress
    76:               real(DP), save :: SWRefPress
    77:               real(DP), save :: SWOrd
    78:               real(DP), save :: LWOptDepAtRefPress
    79:               real(DP), save :: LWRefPress
    80:               real(DP), save :: LWOrd
    81:               real(DP), save :: SolarConst
    82:             
    83:             
    84:               ! 公開変数
    85:               ! Public variables
    86:               !
    87:               logical, save, public:: rad_SL09_inited = .false.
    88:                                           ! 初期設定フラグ.
    89:                                           ! Initialization flag
    90:             
    91:               public :: RadSL09Init
    92:               public :: RadSL09Flux
    93:             
    94:               character(*), parameter:: module_name = 'rad_SL09'
    95:                                           ! モジュールの名称.
    96:                                           ! Module name
    97:               character(*), parameter:: version = &
    98:                 & '$Name:  $' // &
    99:                 & '$Id: rad_SL09.f90,v 1.6 2013/05/25 06:49:44 yot Exp $'
   100:                                           ! モジュールのバージョン
   101:                                           ! Module version
   102:             
   103:               !--------------------------------------------------------------------------------------
   104:             
   105:             contains
   106:             
   107:               !--------------------------------------------------------------------------------------
   108:             
   109:               subroutine RadSL09Flux(                     &
   110:                 & xyr_Press, xyz_Press, xyz_Temp,         & ! (in)
   111:                 & xyr_RadSUwFlux, xyr_RadSDwFlux,         & ! (out)
   112:                 & xyr_RadLUwFlux, xyr_RadLDwFlux,         & ! (out)
   113:                 & xyra_DelRadLUwFlux, xyra_DelRadLDwFlux  & ! (out)
   114:                 & )
   115:             
   116:             
   117:                 ! USE statements
   118:                 !
   119:             
   120:                 ! メッセージ出力
   121:                 ! Message output
   122:                 !
   123:                 use dc_message, only: MessageNotify
   124:             
   125:                 ! 物理・数学定数設定
   126:                 ! Physical and mathematical constants settings
   127:                 !
   128:                 use constants0, only: &
   129:                   & PI                    ! $ \pi $ .
   130:                                           ! 円周率.  Circular constant
   131:             
   132:                 ! 座標データ設定
   133:                 ! Axes data settings
   134:                 !
   135:                 use axesset, only : y_Lat
   136:             
   137:                 !
   138:                 ! Solve radiative transfer equation in two stream approximation
   139:                 !
   140:             !!$    use rad_rte_two_stream_app, only: OLD_RadRTETwoStreamAppHomogAtm
   141:                 use rad_rte_two_stream_app, only: RadRTETwoStreamAppHomogAtm
   142:             
   143:                 real(DP), intent(in ) :: xyr_Press         (0:imax-1, 1:jmax, 0:kmax)
   144:                 real(DP), intent(in ) :: xyz_Press         (0:imax-1, 1:jmax, 1:kmax)
   145:                 real(DP), intent(in ) :: xyz_Temp          (0:imax-1, 1:jmax, 1:kmax)
   146:                 real(DP), intent(out) :: xyr_RadSUwFlux    (0:imax-1, 1:jmax, 0:kmax)
   147:                 real(DP), intent(out) :: xyr_RadSDwFlux    (0:imax-1, 1:jmax, 0:kmax)
   148:                 real(DP), intent(out) :: xyr_RadLUwFlux    (0:imax-1, 1:jmax, 0:kmax)
   149:                 real(DP), intent(out) :: xyr_RadLDwFlux    (0:imax-1, 1:jmax, 0:kmax)
   150:                 real(DP), intent(out) :: xyra_DelRadLUwFlux(0:imax-1, 1:jmax, 0:kmax, 0:1)
   151:                 real(DP), intent(out) :: xyra_DelRadLDwFlux(0:imax-1, 1:jmax, 0:kmax, 0:1)
   152:             
   153:             
   154:                 ! Work variables
   155:                 !
   156:                 real(DP) :: SolarFluxTOA
   157:             !!$    real(DP) :: QeRatio
   158:             !!$    real(DP) :: xyz_SSA      (0:imax-1, 1:jmax, 1:kmax)
   159:             !!$    real(DP) :: xyz_AF       (0:imax-1, 1:jmax, 1:kmax)
   160:             !!$    real(DP) :: xy_SurfAlbedo(0:imax-1, 1:jmax)
   161:             !!$    real(DP) :: xy_InAngle   (0:imax-1, 1:jmax)
   162:                 real(DP) :: xy_CosSZA    (0:imax-1, 1:jmax)
   163:                 real(DP) :: xyr_OptDep   (0:imax-1, 1:jmax, 0:kmax)
   164:             
   165:                 real(DP) :: SSA
   166:                 real(DP) :: AF
   167:             
   168:             !!$    integer  :: i
   169:                 integer  :: j
   170:             !!$    integer  :: k
   171:             
   172:             
   173:                 ! 初期化
   174:                 ! Initialization
   175:                 !
   176:                 if ( .not. rad_SL09_inited ) then
   177:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   178:                 end if
   179:             
   180:             
   181:                 ! Short wave radiation
   182:                 !
   183: W**==== A       xyr_OptDep = SWOptDepAtRefPress * ( xyr_Press / SWRefPress )**SWOrd
   184:             
   185:             
   186:                 SSA = 0.8_DP
   187:                 AF  = 0.204_DP
   188:                 !   Af = 0 may be much better than 0.204 when Eddington approximation is used.
   189:             !!$    AF         = 0.0_DP
   190:             
   191:             
   192:                 if ( FlagGMIns ) then
   193:                   SolarFluxTOA = SolarConst / 4.0_DP
   194: +V===== A         xy_CosSZA    = 1.0_DP
   195:                 else
   196:                   SolarFluxTOA = SolarConst / PI
   197: +------>          do j = 1, jmax
   198: |V===== A           xy_CosSZA(:,j) = cos( y_Lat(j) )
   199: +------           end do
   200:                 end if
   201:             !!$    do j = 1, jmax
   202:             !!$      do i = 0, imax-1
   203:             !!$        if ( xy_CosSZA(i,j) > 0.0_DP ) then
   204:             !!$          xy_InAngle(i,j) = 1.0_DP / xy_CosSZA(i,j)
   205:             !!$        else
   206:             !!$          xy_InAngle(i,j) = 0.0_DP
   207:             !!$        end if
   208:             !!$      end do
   209:             !!$    end do
   210:             !!$
   211:             !!$    !   Unused variable but this is required as an argument
   212:             !!$    !
   213:             !!$    xy_SurfAlbedo = 1.0d100
   214:             !!$
   215:             !!$    call OLD_RadRTETwoStreamAppHomogAtm(                                   &
   216:             !!$      & xy_SurfAlbedo, SolarFluxTOA, xy_InAngle, SSA, AF, xyr_OptDep,  & ! (in )
   217:             !!$      & xyr_RadSFlux,                                                  & ! (out)
   218:             !!$      & FlagSemiInfAtm = .true., FlagSL09 = .true.                     & ! (in ) optional
   219:             !!$      & )
   220:             !!$
   221:             !!$    call RadRTETwoStreamAppHomogAtm(                               &
   222:             !!$      & xy_SurfAlbedo, SolarFluxTOA, xy_InAngle, SSA, AF, xyr_OptDep,  & ! (in )
   223:             !!$      & xyr_RadSUwFlux, xyr_RadSDwFlux,                                & ! (out)
   224:             !!$      & FlagSemiInfAtm = .true., FlagSL09 = .true                      & ! (in ) optional
   225:             !!$      & )
   226:             
   227:                 call RadSL09SWFlux(                                     &
   228:                   & SolarFluxTOA, xy_CosSZA, SSA, AF, xyr_OptDep,       &
   229:                   & xyr_RadSUwFlux                                      &
   230:                   & )
   231: **W---->A       xyr_RadSDwFlux = 0.0_DP
   232: |||         
   233: |||         
   234: |||         
   235: |||             ! Long wave radiation
   236: |||             !
   237: |||         
   238: |||             !   Although the surface temperature and surface emissivity are set, but are not used.
   239: |||             !
   240: **W---- A       xyr_OptDep = LWOptDepAtRefPress * ( xyr_Press / LWRefPress )**LWOrd
   241:             
   242:             
   243:             !!$    call RadiationRTEQNonScat(                    &
   244:             !!$      & xyz_Temp, xy_SurfTemp, xy_SurfEmis, xyr_OptDep, & ! (in )
   245:             !!$      & xyr_RadLFlux, xyra_DelRadLFlux,                 & ! (out)
   246:             !!$      & xy_SurfUpRadLFluxBase = xyr_RadSFlux(:,:,0)     & ! (in ) optional
   247:             !!$      & )
   248:             !!$    call RadSL09LWFlux(                           &
   249:             !!$      & xyz_Temp, xyr_OptDep,                     & ! (in )
   250:             !!$      & xyr_RadSFlux(:,:,0),                      & ! (in )
   251:             !!$      & xyr_RadLFlux, xyra_DelRadLFlux            & ! (out)
   252:             !!$      & )
   253: W*===== A       call RadSL09LWFlux(                       &
   254:                   & xyr_Press, xyz_Press, xyz_Temp, xyr_OptDep,  & ! (in )
   255:                   & xyr_RadSUwFlux(:,:,0)-xyr_RadSDwFlux(:,:,0), & ! (in )
   256:                   & xyr_RadLUwFlux, xyr_RadLDwFlux,              & ! (out)
   257:                   & xyra_DelRadLUwFlux, xyra_DelRadLDwFlux       & ! (out)
   258:                   & )
   259:             
   260:             
   261:               end subroutine RadSL09Flux
   262:             
   263:               !--------------------------------------------------------------------------------------
   264:             
   265:               subroutine OLD_RadSL09LWFlux(                           &
   266:                 & xyz_Temp, xyr_OptDep,                           & ! (in )
   267:                 & xy_SurfUpRadLFluxBase,                          & ! (in )
   268:                 & xyr_RadLFlux, xyra_DelRadLFlux                  & ! (out)
   269:                 & )
   270:                 !
   271:                 ! 散乱なしの場合の放射伝達方程式の計算
   272:                 !
   273:                 ! Integrate radiative transfer equation without scattering
   274:                 !
   275:             
   276:                 ! モジュール引用 ; USE statements
   277:                 !
   278:             
   279:                 ! メッセージ出力
   280:                 ! Message output
   281:                 !
   282:                 use dc_message, only: MessageNotify
   283:             
   284:                 ! 物理・数学定数設定
   285:                 ! Physical and mathematical constants settings
   286:                 !
   287:                 use constants0, only: &
   288:                   & PI, &
   289:                                           ! $ \pi $ .
   290:                                           ! 円周率.  Circular constant
   291:                   & StB
   292:                                           ! $ \sigma_{SB} $ .
   293:                                           ! ステファンボルツマン定数.
   294:                                           ! Stefan-Boltzmann constant
   295:             
   296:                 ! 宣言文 ; Declaration statements
   297:                 !
   298:             
   299:                 real(DP), intent(in ) :: xyz_Temp    (0:imax-1, 1:jmax, 1:kmax)
   300:                                           ! $ T $ .     温度. Temperature
   301:                 real(DP), intent(in ) :: xyr_OptDep  (0:imax-1, 1:jmax, 0:kmax)
   302:                                           ! Optical depth
   303:                 real(DP), intent(in ) :: xy_SurfUpRadLFluxBase(0:imax-1, 1:jmax)
   304:                 real(DP), intent(out) :: xyr_RadLFlux (0:imax-1, 1:jmax, 0:kmax)
   305:                                           ! 長波フラックス. 
   306:                                           ! Longwave flux
   307:                 real(DP), intent(out) :: xyra_DelRadLFlux (0:imax-1, 1:jmax, 0:kmax, 0:1)
   308:                                           ! 長波地表温度変化. 
   309:                                           ! Surface temperature tendency with longwave
   310:             
   311:             
   312:                 ! 作業変数
   313:                 ! Work variables
   314:                 !
   315:                 real(DP), parameter :: DiffFact = 1.66_DP
   316:             
   317:                 real(DP):: xyr_RadLDoFlux (0:imax-1, 1:jmax, 0:kmax)
   318:                 real(DP):: xyr_RadLUpFlux (0:imax-1, 1:jmax, 0:kmax)
   319:             
   320:                 real(DP):: xyz_DelTrans (0:imax-1, 1:jmax, 1:kmax)
   321:                 real(DP):: xyrr_Trans   (0:imax-1, 1:jmax, 0:kmax, 0:kmax)
   322:                                           ! 透過係数. 
   323:                                           ! Transmission coefficient
   324:                 real(DP):: xyz_IntPF        (0:imax-1, 1:jmax, 1:kmax)
   325:                                           ! Integrated Planck function
   326:                 real(DP):: xyz_IntDPFDT     (0:imax-1, 1:jmax, 1:kmax)
   327:                                           ! Integrated temperature derivative of Planck function
   328:             
   329:                 real(DP):: xy_SurfUpRadLFlux(0:imax-1, 1:jmax)
   330:             
   331:                 integer:: k, kk           ! 鉛直方向に回る DO ループ用作業変数
   332:                                           ! Work variables for DO loop in vertical direction
   333:             
   334:                 ! 実行文 ; Executable statement
   335:                 !
   336:             
   337:                 ! 初期化
   338:                 ! Initialization
   339:                 !
   340:                 if ( .not. rad_SL09_inited ) then
   341:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   342:                 end if
   343:             
   344:             
   345:                 ! Case for grey atmosphere
   346:                 !
   347: **W---->A       xyz_IntPF       = StB * xyz_Temp**4
   348: **W----         xyz_IntDPFDT    = 4.0_DP * StB * xyz_Temp**3
   349:             
   350:             
   351:                 ! 透過関数計算
   352:                 ! Calculate transmission functions
   353:                 !
   354: W------>        do k = 1, kmax
   355: |**==== A         xyz_DelTrans(:,:,k) = &
   356: |                   & exp( - DiffFact * ( xyr_OptDep(:,:,k-1) - xyr_OptDep(:,:,k) ) )
   357: W------         end do
   358:                 !
   359: +------>        do k = 0, kmax
   360: |*----->          do kk = k, k
   361: ||W*===             xyrr_Trans(:,:,k,kk) = 1.0_DP
   362: |*-----           end do
   363: |+----->          do kk = k+1, kmax
   364: ||W*=== A           xyrr_Trans(:,:,k,kk) = xyrr_Trans(:,:,k,kk-1) * xyz_DelTrans(:,:,kk)
   365: |+-----           end do
   366: +------         end do
   367: +------>        do k = 0, kmax
   368: |+----->          do kk = 0, k-1
   369: ||W*=== A           xyrr_Trans(:,:,k,kk) = xyrr_Trans(:,:,kk,k)
   370: |+-----           end do
   371: +------         end do
   372:             
   373:             
   374:                 ! 放射フラックス計算
   375:                 ! Calculate radiation flux
   376:                 !
   377:             
   378:                 !   Initialization
   379:                 !
   380: **W---->        xyr_RadLDoFlux = 0.0_DP
   381: **W----         xyr_RadLUpFlux = 0.0_DP
   382:                 !
   383:                 !   Downward flux
   384:                 !
   385: +------>        do k = kmax, 0, -1
   386: |           
   387: |+----->          do kk = kmax, k+1, -1
   388: ||W*=== A           xyr_RadLDoFlux(:,:,k) = xyr_RadLDoFlux(:,:,k)          &
   389: ||                    & + xyz_IntPF(:,:,kk)                                &
   390: ||                    & * ( xyrr_Trans(:,:,k,kk-1) - xyrr_Trans(:,:,k,kk) )
   391: |+-----           end do
   392: |           
   393: +------         end do
   394:                 !
   395:                 !   Upward flux
   396:                 !
   397:                 !     Set upward flux
   398:                 !
   399: W*===== A       xy_SurfUpRadLFlux = xyr_RadLDoFlux(:,:,0) - xy_SurfUpRadLFluxBase
   400:                 !
   401: +------>        do k = 0, kmax
   402: |           
   403: |W*==== A         xyr_RadLUpFlux(:,:,k) = xy_SurfUpRadLFlux * xyrr_Trans(:,:,k,0)
   404: |           
   405: |+----->          do kk = 1, k
   406: ||W*=== A           xyr_RadLUpFlux(:,:,k) = xyr_RadLUpFlux(:,:,k)          &
   407: ||                    & - xyz_IntPF(:,:,kk)                                &
   408: ||                    & * ( xyrr_Trans(:,:,k,kk-1) - xyrr_Trans(:,:,k,kk) )
   409: |+-----           end do
   410: |           
   411: +------         end do
   412:             
   413: W**==== A       xyr_RadLFlux = xyr_RadLUpFlux - xyr_RadLDoFlux
   414:             
   415:             
   416:                 ! 放射フラックスの変化率の計算
   417:                 ! Calculate rate of change of radiative flux
   418:                 !
   419: +------>        do k = 0, kmax
   420: |*W---->A         xyra_DelRadLFlux(:,:,k,0) = 0.0_DP
   421: |||         
   422: |*W---- A         xyra_DelRadLFlux(:,:,k,1) =                           &
   423: |                   & - xyz_IntDPFDT(:,:,1)                             &
   424: |                   &   * ( xyrr_Trans(:,:,k,0) - xyrr_Trans(:,:,k,1) )
   425: +------         end do
   426:             
   427:               end subroutine OLD_RadSL09LWFlux
   428:             
   429:               !--------------------------------------------------------------------------------------
   430:             
   431:               subroutine RadSL09LWFlux(                       &
   432:                 & xyr_Press, xyz_Press, xyz_Temp, xyr_OptDep, & ! (in )
   433:                 & xy_SurfRadSFlux,                            & ! (in )
   434:                 & xyr_RadLUwFlux, xyr_RadLDwFlux,             & ! (out)
   435:                 & xyra_DelRadLUwFlux, xyra_DelRadLDwFlux      & ! (out)
   436:                 & )
   437:                 !
   438:                 ! 散乱なしの場合の放射伝達方程式の計算
   439:                 !
   440:                 ! Integrate radiative transfer equation without scattering
   441:                 !
   442:             
   443:                 ! モジュール引用 ; USE statements
   444:                 !
   445:             
   446:                 ! メッセージ出力
   447:                 ! Message output
   448:                 !
   449:                 use dc_message, only: MessageNotify
   450:             
   451:                 ! 物理・数学定数設定
   452:                 ! Physical and mathematical constants settings
   453:                 !
   454:                 use constants0, only: &
   455:                   & StB
   456:                                           ! $ \sigma_{SB} $ .
   457:                                           ! ステファンボルツマン定数.
   458:                                           ! Stefan-Boltzmann constant
   459:             
   460:                 ! 宣言文 ; Declaration statements
   461:                 !
   462:             
   463:                 real(DP), intent(in ) :: xyr_Press   (0:imax-1, 1:jmax, 0:kmax)
   464:                 real(DP), intent(in ) :: xyz_Press   (0:imax-1, 1:jmax, 1:kmax)
   465:                 real(DP), intent(in ) :: xyz_Temp    (0:imax-1, 1:jmax, 1:kmax)
   466:                                           ! $ T $ .     温度. Temperature
   467:                 real(DP), intent(in ) :: xyr_OptDep  (0:imax-1, 1:jmax, 0:kmax)
   468:                                           ! Optical depth
   469:                 real(DP), intent(in ) :: xy_SurfRadSFlux(0:imax-1, 1:jmax)
   470:                 real(DP), intent(out) :: xyr_RadLUwFlux (0:imax-1, 1:jmax, 0:kmax)
   471:                                           ! 長波フラックス. 
   472:                                           ! Longwave flux
   473:                 real(DP), intent(out) :: xyr_RadLDwFlux (0:imax-1, 1:jmax, 0:kmax)
   474:                                           ! 長波フラックス. 
   475:                                           ! Longwave flux
   476:                 real(DP), intent(out) :: xyra_DelRadLUwFlux (0:imax-1, 1:jmax, 0:kmax, 0:1)
   477:                                           ! 長波地表温度変化. 
   478:                                           ! Surface temperature tendency with longwave
   479:                 real(DP), intent(out) :: xyra_DelRadLDwFlux (0:imax-1, 1:jmax, 0:kmax, 0:1)
   480:                                           ! 長波地表温度変化. 
   481:                                           ! Surface temperature tendency with longwave
   482:             
   483:             
   484:                 ! 作業変数
   485:                 ! Work variables
   486:                 !
   487:                 real(DP):: xyr_Temp       (0:imax-1, 1:jmax, 0:kmax)
   488:                 real(DP):: xyr_IntPF      (0:imax-1, 1:jmax, 0:kmax)
   489:                                           ! Integrated Planck function
   490:                 real(DP):: xyz_DPFDOptDep (0:imax-1, 1:jmax, 1:kmax)
   491:                 real(DP):: xyz_DelOptDep     (0:imax-1, 1:jmax, 1:kmax)
   492:                 real(DP):: xyz_TransEachLayer(0:imax-1, 1:jmax, 1:kmax)
   493:                                           ! 透過係数. 
   494:                                           ! Transmission coefficient
   495:             
   496:                 integer:: k               ! 鉛直方向に回る DO ループ用作業変数
   497:                                           ! Work variables for DO loop in vertical direction
   498:             
   499:                 ! 実行文 ; Executable statement
   500:                 !
   501:             
   502:                 ! 初期化
   503:                 ! Initialization
   504:                 !
   505:                 if ( .not. rad_SL09_inited ) then
   506:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   507:                 end if
   508:             
   509:             
   510:                 k = 0
   511: W*===== A       xyr_Temp(:,:,k) =                                    &
   512:                   &      ( xyz_Temp (:,:,k+2) - xyz_Temp (:,:,k+1) ) &
   513:                   & / log( xyz_Press(:,:,k+2) / xyz_Press(:,:,k+1) ) &
   514:                   & * log( xyr_Press(:,:,k  ) / xyz_Press(:,:,k+1) ) &
   515:                   & + xyz_Temp(:,:,k+1)
   516: W------>        do k = 1, kmax-1
   517: |**==== A         xyr_Temp(:,:,k) =                                &
   518: |                   &      ( xyz_Temp (:,:,k+1) - xyz_Temp (:,:,k) ) &
   519: |                   & / log( xyz_Press(:,:,k+1) / xyz_Press(:,:,k) ) &
   520: |                   & * log( xyr_Press(:,:,k  ) / xyz_Press(:,:,k) ) &
   521: |                   & + xyz_Temp(:,:,k)
   522: W------         end do
   523:                 k = kmax
   524: W*===== A       xyr_Temp(:,:,k) = xyz_Temp(:,:,k)
   525:             
   526:             
   527: W**====         xyr_IntPF       = StB * xyr_Temp**4
   528:                 !
   529: W------>        do k = 1, kmax
   530: |**==== A         xyz_DelOptDep(:,:,k) = xyr_OptDep(:,:,k-1) - xyr_OptDep(:,:,k)
   531: W------         end do
   532:                 !
   533: W**====         xyz_TransEachLayer = exp( - xyz_DelOptDep )
   534:                 !
   535: W------>        do k = 1, kmax
   536: |**====           xyz_DPFDOptDep(:,:,k) =                      &
   537: |                   &   ( xyr_IntPF(:,:,k-1) - xyr_IntPF(:,:,k) ) &
   538: |                   & / max( xyz_DelOptDep(:,:,k), 1.0d-100 )
   539: W------         end do
   540:             
   541:             
   542:                 ! 放射フラックス計算
   543:                 ! Calculate radiation flux
   544:                 !
   545:             
   546:                 !
   547:                 !   Downward flux
   548:                 !
   549:                 k = kmax
   550: W*===== A       xyr_RadLDwFlux(:,:,k) = 0.0_DP
   551: +------>        do k = kmax-1, 0, -1
   552: |W*==== A         xyr_RadLDwFlux(:,:,k) =                                &
   553: |                   &   ( xyr_RadLDwFlux(:,:,k+1) - xyr_IntPF(:,:,k+1) ) &
   554: |                   & * xyz_TransEachLayer(:,:,k+1)                      &
   555: |                   & + xyr_IntPF(:,:,k)                                 &
   556: |                   & - xyz_DPFDOptDep(:,:,k+1)                          &
   557: |                   &   * ( 1.0_DP - xyz_TransEachLayer(:,:,k+1) )
   558: +------         end do
   559:                 !
   560:                 !   Upward flux
   561:                 !
   562:                 !     Set upward flux
   563:                 k = 0
   564: W*===== A       xyr_RadLUwFlux(:,:,k) = xyr_RadLDwFlux(:,:,0) - xy_SurfRadSFlux
   565:                 !
   566: +------>        do k = 1, kmax
   567: |W*==== A         xyr_RadLUwFlux(:,:,k) =                                &
   568: |                   &   ( xyr_RadLUwFlux(:,:,k-1) - xyr_IntPF(:,:,k-1) ) &
   569: |                   & * xyz_TransEachLayer(:,:,k)                        &
   570: |                   & + xyr_IntPF(:,:,k)                                 &
   571: |                   & + xyz_DPFDOptDep(:,:,k)                            &
   572: |                   &   * ( 1.0_DP - xyz_TransEachLayer(:,:,k) )
   573: +------         end do
   574:             
   575:             
   576:                 ! 放射フラックスの変化率の計算
   577:                 ! Calculate rate of change of radiative flux
   578:                 !
   579: ***W--->A       xyra_DelRadLUwFlux = 0.0_DP
   580: ***W--- A       xyra_DelRadLDwFlux = 0.0_DP
   581:             
   582:             
   583:               end subroutine RadSL09LWFlux
   584:             
   585:               !--------------------------------------------------------------------------------------
   586:             
   587:               subroutine RadSL09SWFlux(                                     &
   588:                 & SolarFluxTOA, xy_CosSZA, SSA, AF, xyr_OptDep,             &
   589:                 & xyr_RadSFlux                                              &
   590:                 & )
   591:             
   592:                 real(DP), intent(in ) :: SolarFluxTOA
   593:                 real(DP), intent(in ) :: xy_CosSZA(0:imax-1, 1:jmax)
   594:                 real(DP), intent(in ) :: SSA
   595:                 real(DP), intent(in ) :: AF
   596:                 real(DP), intent(in ) :: xyr_OptDep   ( 0:imax-1, 1:jmax, 0:kmax )
   597:                 real(DP), intent(out) :: xyr_RadSFlux ( 0:imax-1, 1:jmax, 0:kmax )
   598:             
   599:                 ! Work variables
   600:                 !
   601:                 real(DP) :: BondAlbedo
   602:                 real(DP) :: Gamma
   603:                 integer  :: j, k
   604:             
   605:             
   606:                 BondAlbedo = &
   607:                   &   ( sqrt( 1.0_DP - SSA * AF ) - sqrt( 1.0_DP - SSA ) ) &
   608:                   & / ( sqrt( 1.0_DP - SSA * AF ) + sqrt( 1.0_DP - SSA ) )
   609:             
   610:                 Gamma = 2.0_DP * sqrt( 1.0_DP - SSA ) * sqrt( 1.0_DP - SSA * AF )
   611:             
   612: +------>        do k = 0, kmax
   613: |W----->          do j = 1, jmax
   614: ||*==== A           xyr_RadSFlux(:,j,k) =                   &
   615: ||                    & - SolarFluxTOA * xy_CosSZA(:,j) &
   616: ||                    & * ( 1.0_DP - BondAlbedo ) * exp( -Gamma * xyr_OptDep(:,j,k) )
   617: |W-----           end do
   618: +------         end do
   619:             
   620:             
   621:               end subroutine RadSL09SWFlux
   622:             
   623:               !--------------------------------------------------------------------------------------
   624:             
   625:               subroutine RadSL09Init
   626:             
   627:                 ! ファイル入出力補助
   628:                 ! File I/O support
   629:                 !
   630:                 use dc_iounit, only: FileOpen
   631:             
   632:                 ! NAMELIST ファイル入力に関するユーティリティ
   633:                 ! Utilities for NAMELIST file input
   634:                 !
   635:                 use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid
   636:             
   637:                 ! メッセージ出力
   638:                 ! Message output
   639:                 !
   640:                 use dc_message, only: MessageNotify
   641:             
   642:                 !
   643:                 ! Solve radiative transfer equation in two stream approximation
   644:                 !
   645:                 use rad_rte_two_stream_app, only: RadRTETwoStreamAppInit
   646:             
   647:             
   648:                 ! 宣言文 ; Declaration statements
   649:                 !
   650:             
   651:                 integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号.
   652:                                           ! Unit number for NAMELIST file open
   653:                 integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT.
   654:                                           ! IOSTAT of NAMELIST read
   655:             
   656:                 ! NAMELIST 変数群
   657:                 ! NAMELIST group name
   658:                 !
   659:                 namelist /rad_SL09_nml/ &
   660:                   & FlagGMIns,                             &
   661:                   & SWOptDepAtRefPress, SWRefPress, SWOrd, &
   662:                   & LWOptDepAtRefPress, LWRefPress, LWOrd, &
   663:                   & SolarConst
   664:                       !
   665:                       ! デフォルト値については初期化手続 "rad_SL09#RadSL09Init"
   666:                       ! のソースコードを参照のこと.
   667:                       !
   668:                       ! Refer to source codes in the initialization procedure
   669:                       ! "rad_SL09#RadSL09Init" for the default values.
   670:                       !
   671:             
   672:             
   673:                 if ( rad_SL09_inited ) return
   674:             
   675:             
   676:                 ! デフォルト値の設定
   677:                 ! Default values settings
   678:                 !
   679:                 FlagGMIns          = .false.
   680:             
   681:                 SWOptDepAtRefPress =  3.0_DP
   682:                 SWRefPress         =  3.0d5
   683:                 SWOrd              =  1.0_DP
   684:             
   685:                 LWOptDepAtRefPress = 80.0_DP
   686:                 LWRefPress         =  3.0d5
   687:                 LWOrd              =  2.0_DP
   688:             
   689:                 SolarConst         = 50.7_DP
   690:             
   691:             
   692:             
   693:             
   694:                 ! NAMELIST の読み込み
   695:                 ! NAMELIST is input
   696:                 !
   697:                 if ( trim(namelist_filename) /= '' ) then
   698:                   call FileOpen( unit_nml, &          ! (out)
   699:                     & namelist_filename, mode = 'r' ) ! (in)
   700:             
   701:                   rewind( unit_nml )
   702:                   read( unit_nml,                     & ! (in)
   703:                     & nml = rad_SL09_nml,             & ! (out)
   704:                     & iostat = iostat_nml )             ! (out)
   705:                   close( unit_nml )
   706:             
   707:                   call NmlutilMsg( iostat_nml, module_name ) ! (in)
   708:                 end if
   709:             
   710:             
   711:                 ! Initialization of modules used in this module
   712:                 !
   713:             
   714:                 !
   715:                 ! Solve radiative transfer equation in two stream approximation
   716:                 !
   717:                 call RadRTETwoStreamAppInit
   718:             
   719:             
   720:                 ! 印字 ; Print
   721:                 !
   722:                 call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   723:                 call MessageNotify( 'M', module_name, 'FlagGMIns          = %b', l = (/ FlagGMIns /) )
   724:                 call MessageNotify( 'M', module_name, 'SWOptDepAtRefPress = %f', d = (/ SWOptDepAtRefPress /) )
   725:                 call MessageNotify( 'M', module_name, 'SWRefPress         = %f', d = (/ SWRefPress /) )
   726:                 call MessageNotify( 'M', module_name, 'SWOrd              = %f', d = (/ SWOrd /) )
   727:                 call MessageNotify( 'M', module_name, 'LWOptDepAtRefPress = %f', d = (/ LWOptDepAtRefPress /) )
   728:                 call MessageNotify( 'M', module_name, 'LWRefPress         = %f', d = (/ LWRefPress /) )
   729:                 call MessageNotify( 'M', module_name, 'LWOrd              = %f', d = (/ LWOrd /) )
   730:                 call MessageNotify( 'M', module_name, 'SolarConst         = %f', d = (/ SolarConst /) )
   731:                 call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   732:             
   733:             
   734:                 rad_SL09_inited = .true.
   735:             
   736:               end subroutine RadSL09Init
   737:             
   738:               !--------------------------------------------------------------------------------------
   739:             
   740:             end module rad_SL09
