Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:39:01 2016
FILE NAME: rad_none.f90
PROGRAM NAME: rad_none
DIAGNOSTIC LIST

  LINE  LEVEL( NO.): DIAGNOSTIC MESSAGE

   169  opt  (1593): Loop nest collapsed into one loop.
   169  vec  (   1): Vectorized loop.
   169  vec  (  29): ADB is used for array.: xyr_radsdwflux
   169  vec  (  29): ADB is used for array.: xy_cossza
   179  opt  (1772): Loop nest fused with following nest(s).
   179  vec  (   3): Unvectorized loop.
   179  vec  (  13): Overhead of loop division is too large.
   180  opt  (1593): Loop nest collapsed into one loop.
   180  vec  (   4): Vectorized array expression.
   180  vec  (  29): ADB is used for array.: xyr_radluwflux
   180  vec  (  29): ADB is used for array.: xy_surftemp
   180  vec  (  29): ADB is used for array.: xyr_radsuwflux
   180  vec  (  29): ADB is used for array.: xyr_radsdwflux
   180  vec  (  29): ADB is used for array.: xy_surfalbedo
   187  opt  (1593): Loop nest collapsed into one loop.
   187  vec  (   4): Vectorized array expression.
   187  vec  (  29): ADB is used for array.: xyr_radldwflux
   188  opt  (  11): Fused array assignments. :line 188 - 189
   188  opt  (1772): Loop nest fused with following nest(s).
   188  opt  (1593): Loop nest collapsed into one loop.
   188  vec  (   4): Vectorized array expression.
   188  vec  (  29): ADB is used for array.: xyra_delradldwflux
   188  vec  (  29): ADB is used for array.: xyra_delradluwflux
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:39:01 2016
FILE NAME: rad_none.f90
PROGRAM NAME: rad_none
TRANSFORMATION LIST

  LINE                   FORTRAN STATEMENT

     1  != 何もしない放射モデル
     2  !
     3  != radiation model with no absorption and no scattering
     4  !
     5  ! Authors::   Yoshiyuki O. Takahashi
     6  ! Version::   $Id: rad_none.f90,v 1.1 2015/01/31 06:17:21 yot Exp $
     7  ! Tag Name::  $Name:  $
     8  ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9  ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10  !
    11  module rad_none
    12    !
    13    != 何もしない放射モデル
    14    !
    15    != radiation model with no absorption and no scattering
    16    !
    17    ! <b>Note that Japanese and English are described in parallel.</b>
    18    !
    19    !== References
    20    !
    21    !
    22    !== Procedures List
    23    !
    24    ! RadEarthV2Flux :: 放射フラックスの計算
    25    ! ------------          :: ------------
    26    ! RadEarthV2Flux :: Calculate radiation flux
    27    !
    28    !== NAMELIST
    29    !
    30    ! NAMELIST#rad_Earth_V2_nml
    31    !
    32  
    33    ! USE statements
    34    !
    35  
    36    !
    37    ! Kind type parameter
    38    !
    39    use dc_types, only: DP, &      ! Double precision.
    40      &                 STRING, &  ! Strings.
    41      &                 TOKEN      ! Keywords.
    42  
    43    ! メッセージ出力
    44    ! Message output
    45    !
    46    use dc_message, only: MessageNotify
    47  
    48    ! 格子点設定
    49    ! Grid points settings
    50    !
    51    use gridset, only: imax, & ! 経度格子点数.
    52                               ! Number of grid points in longitude
    53      &                jmax, & ! 緯度格子点数.
    54                               ! Number of grid points in latitude
    55      &                kmax    ! 鉛直層数.
    56                               ! Number of vertical level
    57  
    58    implicit none
    59  
    60    private
    61  
    62  
    63    ! 公開変数
    64    ! Public variables
    65    !
    66    logical, save :: rad_none_inited = .false.
    67                                ! 初期設定フラグ.
    68                                ! Initialization flag
    69  
    70    public :: RadNoneFlux
    71    public :: RadNoneInit
    72  
    73    character(*), parameter:: module_name = 'rad_none'
    74                                ! モジュールの名称.
    75                                ! Module name
    76    character(*), parameter:: version = &
    77      & '$Name:  $' // &
    78      & '$Id: rad_none.f90,v 1.1 2015/01/31 06:17:21 yot Exp $'
    79                                ! モジュールのバージョン
    80                                ! Module version
    81  
    82    !--------------------------------------------------------------------------------------
    83  
    84  contains
    85  
    86    !--------------------------------------------------------------------------------------
    87  
    88    subroutine RadNoneFlux(                                      &
    89      & xy_SurfAlbedo,                                           & ! (in)
    90      & xy_SurfTemp,                                             & ! (in)
    91      & xyr_RadSUwFlux, xyr_RadSDwFlux,                          & ! (out)
    92      & xyr_RadLUwFlux, xyr_RadLDwFlux,                          & ! (out)
    93      & xyra_DelRadLUwFlux, xyra_DelRadLDwFlux                   & ! (out)
    94      & )
    95  
    96  
    97      ! USE statements
    98      !
    99  
   100      ! 物理・数学定数設定
   101      ! Physical and mathematical constants settings
   102      !
   103      use constants0, only: &
   104        & StB                   ! $ \sigma_{SB} $ .
   105                                ! ステファンボルツマン定数.
   106                                ! Stefan-Boltzmann constant
   107  
   108      ! 太陽放射フラックスの設定
   109      ! Set solar constant
   110      !
   111      use set_solarconst, only : SetSolarConst
   112  
   113      ! 短波入射 (太陽入射)
   114      ! Short wave (insolation) incoming
   115      !
   116      use rad_short_income, only : RadShortIncome
   117  
   118  
   119      real(DP), intent(in ) :: xy_SurfAlbedo   (0:imax-1, 1:jmax)
   120      real(DP), intent(in ) :: xy_SurfTemp     (0:imax-1, 1:jmax)
   121      real(DP), intent(out) :: xyr_RadSUwFlux    (0:imax-1, 1:jmax, 0:kmax)
   122      real(DP), intent(out) :: xyr_RadSDwFlux    (0:imax-1, 1:jmax, 0:kmax)
   123      real(DP), intent(out) :: xyr_RadLUwFlux    (0:imax-1, 1:jmax, 0:kmax)
   124      real(DP), intent(out) :: xyr_RadLDwFlux    (0:imax-1, 1:jmax, 0:kmax)
   125      real(DP), intent(out) :: xyra_DelRadLUwFlux(0:imax-1, 1:jmax, 0:kmax, 0:1)
   126      real(DP), intent(out) :: xyra_DelRadLDwFlux(0:imax-1, 1:jmax, 0:kmax, 0:1)
   127  
   128  
   129      ! Work variables
   130      !
   131      real(DP) :: SolarConst
   132      real(DP) :: DistFromStarScld
   133      real(DP) :: DiurnalMeanFactor
   134      real(DP) :: SolarFluxTOA
   135      real(DP) :: xy_CosSZA(0:imax-1, 1:jmax)
   136  
   137      integer :: i
   138      integer :: j
   139      integer :: k
   140  
   141  
   142      ! 初期化確認
   143      ! Initialization check
   144      !
   145      if ( .not. rad_none_inited ) then
   146        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   147      end if
   148  
   149  
   150      ! 太陽放射フラックスの設定
   151      ! Set solar constant
   152      !
   153      call SetSolarConst( &
   154        & SolarConst      & ! (out)
   155        & )
   156  
   157      ! 短波入射の計算
   158      ! Calculate short wave (insolation) incoming radiation
   159      !
   160      call RadShortIncome(                       &
   161        & xy_CosZet         = xy_CosSZA,         & ! (out) optional
   162        & DistFromStarScld  = DistFromStarScld,  & ! (out) optional
   163        & DiurnalMeanFactor = DiurnalMeanFactor  &
   164        & )
   165  
   166      SolarFluxTOA = SolarConst / DistFromStarScld**2 * DiurnalMeanFactor
   167  
   168      do k = 0, kmax
   169        do j = 1, jmax
   170          do i = 0, imax-1
   171            if ( xy_CosSZA(i,j) >= 0.0_DP ) then
   172              xyr_RadSDwFlux(i,j,k) = SolarFluxTOA * xy_CosSZA(i,j)
   173            else
   174              xyr_RadSDwFlux(i,j,k) = 0.0_DP
   175            end if
   176          end do
   177        end do
   178      end do
   179      do k = 0, kmax
   180        xyr_RadSUwFlux(:,:,k) = xy_SurfAlbedo * xyr_RadSDwFlux(:,:,k)
   181      end do
   182  
   183  
   184      do k = 0, kmax
   185        xyr_RadLUwFlux(:,:,k) = StB * xy_SurfTemp**4
   186      end do
   187      xyr_RadLDwFlux     = 0.0_DP
   188      xyra_DelRadLUwFlux = 0.0_DP
     .        xy_cossza.DSC.U1 = imax - 1                                       
     .        xy_cossza.DSC.U2 = jmax                                           
     .        allocate (xy_cossza(0:imax-1,1:jmax))                             
     .        xy_cossza.DSC.S2 = (xy_cossza.DSC.U1 + 1)*8                       
     .        if (rad_none_inited .ne. 0) goto 10001                            
     .        call messagenotifyc ('E', module_name,                            
     .       1   'This module has not been initialized.', 1, 1, 1, 1, 1, 1, 1, 1
     .       2   , 1, 1, 1, 8, 37, 0, 0, 0, 0)                                  
     .  10001 continue                                                          
     .        call setsolarconst (solarconst)                                   
     .        call radshortincome (1, distfromstarscld, xy_cossza,              
     .       1   diurnalmeanfactor, 1, 1)                                       
     .        solarfluxtoa = solarconst/distfromstarscld**2*diurnalmeanfactor   
     .        do k = 0, kmax                                                    
     .  !cdir    nodep                                                          
     .  !cdir    noassume                                                       
     .  !cdir    on_adb(xy_cossza)                                              
     .           do j = 1, jmax*imax                                            
     .              if (xy_cossza(j-1,1) .ge. 0.0000000000000000e+000) then     
     .                 xyr_radsdwflux1 = solarfluxtoa*xy_cossza(j-1,1)          
     .              else                                                        
     .                 xyr_radsdwflux1 = 0.0000000000000000e+000                
     .              endif                                                       
     .              xyr_radsdwflux(j-1,1,k) = xyr_radsdwflux1                   
     .           enddo                                                          
     .        enddo                                                             
     .        do k = 0, kmax                                                    
     .  !cdir    nodep                                                          
     .  !cdir    noassume                                                       
     .  !cdir    on_adb(xy_surfalbedo,xy_surftemp)                              
     .           do t218 = 1, jmax*imax                                         
     .              xyr_radsuwflux(t218-1,1,k) = xy_surfalbedo(t218-1,1)*       
     .       1         xyr_radsdwflux(t218-1,1,k)                               
     .              xyr_radluwflux(t218-1,1,k) = 5.67037300000000e-008*         
     .       1         xy_surftemp(t218-1,1)**4                                 
     .           enddo                                                          
     .        enddo                                                             
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t236 = 1, jmax*(kmax*imax + imax)                              
     .           xyr_radldwflux(t236-1,1,0) = 0.0000000000000000e+000           
     .        enddo                                                             
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t247 = 1, jmax*(kmax*imax + imax)                              
     .           xyra_delradluwflux(t247-1,1,0,0) = 0.0000000000000000e+000     
     .           xyra_delradldwflux(t247-1,1,0,0) = 0.0000000000000000e+000     
     .           xyra_delradluwflux(t247-1,1,0,1) = 0.0000000000000000e+000     
     .           xyra_delradldwflux(t247-1,1,0,1) = 0.0000000000000000e+000     
     .        enddo                                                             
   189      xyra_DelRadLDwFlux = 0.0_DP
   190  
   191  
   192      ! Output variables
   193      !
   194  
   195    end subroutine RadNoneFlux
   196  
   197    !--------------------------------------------------------------------------------------
   198  
   199    subroutine RadNoneInit
   200  
   201      ! ファイル入出力補助
   202      ! File I/O support
   203      !
   204  !!$    use dc_iounit, only: FileOpen
   205  
   206      ! NAMELIST ファイル入力に関するユーティリティ
   207      ! Utilities for NAMELIST file input
   208      !
   209  !!$    use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid
   210  
   211      ! 太陽放射フラックスの設定
   212      ! Set solar constant
   213      !
   214      use set_solarconst, only : SetSolarConstInit
   215  
   216      ! 短波入射 (太陽入射)
   217      ! Short wave (insolation) incoming
   218      !
   219      use rad_short_income, only : RadShortIncomeInit
   220  
   221  
   222      ! 宣言文 ; Declaration statements
   223      !
   224  
   225  !!$    integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号.
   226  !!$                              ! Unit number for NAMELIST file open
   227  !!$    integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT.
   228  !!$                              ! IOSTAT of NAMELIST read
   229  
   230      ! NAMELIST 変数群
   231      ! NAMELIST group name
   232      !
   233  !!$    namelist /rad_Earth_V2_nml/ &
   234  !!$      & CloudIceREffMethod,     &
   235  !!$      & CloudWatREff,           &
   236  !!$      & CloudIceREff
   237  
   238  !!$      & SWVer, LWVer
   239            !
   240            ! デフォルト値については初期化手続 "rad_Earth_V2#RadEarthV2Init"
   241            ! のソースコードを参照のこと.
   242            !
   243            ! Refer to source codes in the initialization procedure
   244            ! "rad_Earth_V2#RadEarthV2Init" for the default values.
   245            !
   246  
   247      if ( rad_none_inited ) return
   248  
   249  
   250      ! デフォルト値の設定
   251      ! Default values settings
   252      !
   253  !!$    SWVer = 1
   254  !!$    LWVer = 3
   255  
   256  
   257      ! NAMELIST の読み込み
   258      ! NAMELIST is input
   259      !
   260  !!$    if ( trim(namelist_filename) /= '' ) then
   261  !!$      call FileOpen( unit_nml, &          ! (out)
   262  !!$        & namelist_filename, mode = 'r' ) ! (in)
   263  !!$
   264  !!$      rewind( unit_nml )
   265  !!$      read( unit_nml,                     & ! (in)
   266  !!$        & nml = rad_Earth_V2_nml,         & ! (out)
   267  !!$        & iostat = iostat_nml )             ! (out)
   268  !!$      close( unit_nml )
   269  !!$
   270  !!$      call NmlutilMsg( iostat_nml, module_name ) ! (in)
   271  !!$    end if
   272  
   273  
   274      ! 太陽放射フラックスの設定
   275      ! Set solar constant
   276      !
   277      call SetSolarConstInit
   278  
   279      ! 短波入射 (太陽入射)
   280      ! Short wave (insolation) incoming
   281      !
   282      call RadShortIncomeInit
   283  
   284  
   285      ! 印字 ; Print
   286      !
   287      call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   288  !!$    call MessageNotify( 'M', module_name, 'SWVer = %d', i = (/ SWVer /) )
   289  !!$    call MessageNotify( 'M', module_name, 'LWVer = %d', i = (/ LWVer /) )
   290      call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   291  
   292  
   293      rad_none_inited = .true.
   294  
   295    end subroutine RadNoneInit
   296  
   297    !--------------------------------------------------------------------------------------
   298  
   299  end module rad_none
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:39:01 2016
FILE NAME: rad_none.f90
PROGRAM NAME: rad_none
FORMAT LIST

  LINE    LOOP      FORTRAN STATEMENT

     1:             != 何もしない放射モデル
     2:             !
     3:             != radiation model with no absorption and no scattering
     4:             !
     5:             ! Authors::   Yoshiyuki O. Takahashi
     6:             ! Version::   $Id: rad_none.f90,v 1.1 2015/01/31 06:17:21 yot Exp $
     7:             ! Tag Name::  $Name:  $
     8:             ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9:             ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10:             !
    11:             module rad_none
    12:               !
    13:               != 何もしない放射モデル
    14:               !
    15:               != radiation model with no absorption and no scattering
    16:               !
    17:               ! <b>Note that Japanese and English are described in parallel.</b>
    18:               !
    19:               !== References
    20:               !
    21:               !
    22:               !== Procedures List
    23:               !
    24:               ! RadEarthV2Flux :: 放射フラックスの計算
    25:               ! ------------          :: ------------
    26:               ! RadEarthV2Flux :: Calculate radiation flux
    27:               !
    28:               !== NAMELIST
    29:               !
    30:               ! NAMELIST#rad_Earth_V2_nml
    31:               !
    32:             
    33:               ! USE statements
    34:               !
    35:             
    36:               !
    37:               ! Kind type parameter
    38:               !
    39:               use dc_types, only: DP, &      ! Double precision.
    40:                 &                 STRING, &  ! Strings.
    41:                 &                 TOKEN      ! Keywords.
    42:             
    43:               ! メッセージ出力
    44:               ! Message output
    45:               !
    46:               use dc_message, only: MessageNotify
    47:             
    48:               ! 格子点設定
    49:               ! Grid points settings
    50:               !
    51:               use gridset, only: imax, & ! 経度格子点数.
    52:                                          ! Number of grid points in longitude
    53:                 &                jmax, & ! 緯度格子点数.
    54:                                          ! Number of grid points in latitude
    55:                 &                kmax    ! 鉛直層数.
    56:                                          ! Number of vertical level
    57:             
    58:               implicit none
    59:             
    60:               private
    61:             
    62:             
    63:               ! 公開変数
    64:               ! Public variables
    65:               !
    66:               logical, save :: rad_none_inited = .false.
    67:                                           ! 初期設定フラグ.
    68:                                           ! Initialization flag
    69:             
    70:               public :: RadNoneFlux
    71:               public :: RadNoneInit
    72:             
    73:               character(*), parameter:: module_name = 'rad_none'
    74:                                           ! モジュールの名称.
    75:                                           ! Module name
    76:               character(*), parameter:: version = &
    77:                 & '$Name:  $' // &
    78:                 & '$Id: rad_none.f90,v 1.1 2015/01/31 06:17:21 yot Exp $'
    79:                                           ! モジュールのバージョン
    80:                                           ! Module version
    81:             
    82:               !--------------------------------------------------------------------------------------
    83:             
    84:             contains
    85:             
    86:               !--------------------------------------------------------------------------------------
    87:             
    88:               subroutine RadNoneFlux(                                      &
    89:                 & xy_SurfAlbedo,                                           & ! (in)
    90:                 & xy_SurfTemp,                                             & ! (in)
    91:                 & xyr_RadSUwFlux, xyr_RadSDwFlux,                          & ! (out)
    92:                 & xyr_RadLUwFlux, xyr_RadLDwFlux,                          & ! (out)
    93:                 & xyra_DelRadLUwFlux, xyra_DelRadLDwFlux                   & ! (out)
    94:                 & )
    95:             
    96:             
    97:                 ! USE statements
    98:                 !
    99:             
   100:                 ! 物理・数学定数設定
   101:                 ! Physical and mathematical constants settings
   102:                 !
   103:                 use constants0, only: &
   104:                   & StB                   ! $ \sigma_{SB} $ .
   105:                                           ! ステファンボルツマン定数.
   106:                                           ! Stefan-Boltzmann constant
   107:             
   108:                 ! 太陽放射フラックスの設定
   109:                 ! Set solar constant
   110:                 !
   111:                 use set_solarconst, only : SetSolarConst
   112:             
   113:                 ! 短波入射 (太陽入射)
   114:                 ! Short wave (insolation) incoming
   115:                 !
   116:                 use rad_short_income, only : RadShortIncome
   117:             
   118:             
   119:                 real(DP), intent(in ) :: xy_SurfAlbedo   (0:imax-1, 1:jmax)
   120:                 real(DP), intent(in ) :: xy_SurfTemp     (0:imax-1, 1:jmax)
   121:                 real(DP), intent(out) :: xyr_RadSUwFlux    (0:imax-1, 1:jmax, 0:kmax)
   122:                 real(DP), intent(out) :: xyr_RadSDwFlux    (0:imax-1, 1:jmax, 0:kmax)
   123:                 real(DP), intent(out) :: xyr_RadLUwFlux    (0:imax-1, 1:jmax, 0:kmax)
   124:                 real(DP), intent(out) :: xyr_RadLDwFlux    (0:imax-1, 1:jmax, 0:kmax)
   125:                 real(DP), intent(out) :: xyra_DelRadLUwFlux(0:imax-1, 1:jmax, 0:kmax, 0:1)
   126:                 real(DP), intent(out) :: xyra_DelRadLDwFlux(0:imax-1, 1:jmax, 0:kmax, 0:1)
   127:             
   128:             
   129:                 ! Work variables
   130:                 !
   131:                 real(DP) :: SolarConst
   132:                 real(DP) :: DistFromStarScld
   133:                 real(DP) :: DiurnalMeanFactor
   134:                 real(DP) :: SolarFluxTOA
   135:                 real(DP) :: xy_CosSZA(0:imax-1, 1:jmax)
   136:             
   137:                 integer :: i
   138:                 integer :: j
   139:                 integer :: k
   140:             
   141:             
   142:                 ! 初期化確認
   143:                 ! Initialization check
   144:                 !
   145:                 if ( .not. rad_none_inited ) then
   146:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   147:                 end if
   148:             
   149:             
   150:                 ! 太陽放射フラックスの設定
   151:                 ! Set solar constant
   152:                 !
   153:                 call SetSolarConst( &
   154:                   & SolarConst      & ! (out)
   155:                   & )
   156:             
   157:                 ! 短波入射の計算
   158:                 ! Calculate short wave (insolation) incoming radiation
   159:                 !
   160:                 call RadShortIncome(                       &
   161:                   & xy_CosZet         = xy_CosSZA,         & ! (out) optional
   162:                   & DistFromStarScld  = DistFromStarScld,  & ! (out) optional
   163:                   & DiurnalMeanFactor = DiurnalMeanFactor  &
   164:                   & )
   165:             
   166:                 SolarFluxTOA = SolarConst / DistFromStarScld**2 * DiurnalMeanFactor
   167:             
   168: +------>        do k = 0, kmax
   169: |W----->          do j = 1, jmax
   170: ||*---->            do i = 0, imax-1
   171: |||     A             if ( xy_CosSZA(i,j) >= 0.0_DP ) then
   172: |||     A               xyr_RadSDwFlux(i,j,k) = SolarFluxTOA * xy_CosSZA(i,j)
   173: |||                   else
   174: |||                     xyr_RadSDwFlux(i,j,k) = 0.0_DP
   175: |||                   end if
   176: ||*---- A           end do
   177: |W-----           end do
   178: +------         end do
   179: +------>        do k = 0, kmax
   180: |*W---->A         xyr_RadSUwFlux(:,:,k) = xy_SurfAlbedo * xyr_RadSDwFlux(:,:,k)
   181: |               end do
   182: |           
   183: |           
   184: |               do k = 0, kmax
   185: |*=====           xyr_RadLUwFlux(:,:,k) = StB * xy_SurfTemp**4
   186: +------         end do
   187: W**==== A       xyr_RadLDwFlux     = 0.0_DP
   188: ***W--->A       xyra_DelRadLUwFlux = 0.0_DP
   189: ***W--- A       xyra_DelRadLDwFlux = 0.0_DP
   190:             
   191:             
   192:                 ! Output variables
   193:                 !
   194:             
   195:               end subroutine RadNoneFlux
   196:             
   197:               !--------------------------------------------------------------------------------------
   198:             
   199:               subroutine RadNoneInit
   200:             
   201:                 ! ファイル入出力補助
   202:                 ! File I/O support
   203:                 !
   204:             !!$    use dc_iounit, only: FileOpen
   205:             
   206:                 ! NAMELIST ファイル入力に関するユーティリティ
   207:                 ! Utilities for NAMELIST file input
   208:                 !
   209:             !!$    use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid
   210:             
   211:                 ! 太陽放射フラックスの設定
   212:                 ! Set solar constant
   213:                 !
   214:                 use set_solarconst, only : SetSolarConstInit
   215:             
   216:                 ! 短波入射 (太陽入射)
   217:                 ! Short wave (insolation) incoming
   218:                 !
   219:                 use rad_short_income, only : RadShortIncomeInit
   220:             
   221:             
   222:                 ! 宣言文 ; Declaration statements
   223:                 !
   224:             
   225:             !!$    integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号.
   226:             !!$                              ! Unit number for NAMELIST file open
   227:             !!$    integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT.
   228:             !!$                              ! IOSTAT of NAMELIST read
   229:             
   230:                 ! NAMELIST 変数群
   231:                 ! NAMELIST group name
   232:                 !
   233:             !!$    namelist /rad_Earth_V2_nml/ &
   234:             !!$      & CloudIceREffMethod,     &
   235:             !!$      & CloudWatREff,           &
   236:             !!$      & CloudIceREff
   237:             
   238:             !!$      & SWVer, LWVer
   239:                       !
   240:                       ! デフォルト値については初期化手続 "rad_Earth_V2#RadEarthV2Init"
   241:                       ! のソースコードを参照のこと.
   242:                       !
   243:                       ! Refer to source codes in the initialization procedure
   244:                       ! "rad_Earth_V2#RadEarthV2Init" for the default values.
   245:                       !
   246:             
   247:                 if ( rad_none_inited ) return
   248:             
   249:             
   250:                 ! デフォルト値の設定
   251:                 ! Default values settings
   252:                 !
   253:             !!$    SWVer = 1
   254:             !!$    LWVer = 3
   255:             
   256:             
   257:                 ! NAMELIST の読み込み
   258:                 ! NAMELIST is input
   259:                 !
   260:             !!$    if ( trim(namelist_filename) /= '' ) then
   261:             !!$      call FileOpen( unit_nml, &          ! (out)
   262:             !!$        & namelist_filename, mode = 'r' ) ! (in)
   263:             !!$
   264:             !!$      rewind( unit_nml )
   265:             !!$      read( unit_nml,                     & ! (in)
   266:             !!$        & nml = rad_Earth_V2_nml,         & ! (out)
   267:             !!$        & iostat = iostat_nml )             ! (out)
   268:             !!$      close( unit_nml )
   269:             !!$
   270:             !!$      call NmlutilMsg( iostat_nml, module_name ) ! (in)
   271:             !!$    end if
   272:             
   273:             
   274:                 ! 太陽放射フラックスの設定
   275:                 ! Set solar constant
   276:                 !
   277:                 call SetSolarConstInit
   278:             
   279:                 ! 短波入射 (太陽入射)
   280:                 ! Short wave (insolation) incoming
   281:                 !
   282:                 call RadShortIncomeInit
   283:             
   284:             
   285:                 ! 印字 ; Print
   286:                 !
   287:                 call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   288:             !!$    call MessageNotify( 'M', module_name, 'SWVer = %d', i = (/ SWVer /) )
   289:             !!$    call MessageNotify( 'M', module_name, 'LWVer = %d', i = (/ LWVer /) )
   290:                 call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   291:             
   292:             
   293:                 rad_none_inited = .true.
   294:             
   295:               end subroutine RadNoneInit
   296:             
   297:               !--------------------------------------------------------------------------------------
   298:             
   299:             end module rad_none
