Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:47 2016
FILE NAME: rad_rte_nonscat.f90
PROGRAM NAME: rad_rte_nonscat
DIAGNOSTIC LIST

  LINE  LEVEL( NO.): DIAGNOSTIC MESSAGE

   215  vec  (   3): Unvectorized loop.
   215  vec  (   7): Iteration count is too small.
   241  vec  (   3): Unvectorized loop.
   248  vec  (  10): Vectorization obstructive procedure reference.:radrtenonscatcore
   345  opt  (1593): Loop nest collapsed into one loop.
   345  vec  (   1): Vectorized loop.
   345  vec  (  29): ADB is used for array.: xyr_radluwflux
   345  vec  (  29): ADB is used for array.: xyr_radldwflux
   346  opt  (  11): Fused array assignments. :line 346 - 347
   356  opt  (1593): Loop nest collapsed into one loop.
   356  vec  (   1): Vectorized loop.
   356  vec  (  29): ADB is used for array.: xyr_radldwflux
   356  vec  (  29): ADB is used for array.: xyrr_trans
   356  vec  (  29): ADB is used for array.: xyz_intpf
   370  vec  (  13): Overhead of loop division is too large.
   372  vec  (   4): Vectorized array expression.
   372  vec  (  29): ADB is used for array.: xyr_radluwflux
   372  vec  (  29): ADB is used for array.: xyrr_trans
   372  vec  (  29): ADB is used for array.: xy_surfintpf
   374  opt  (1592): Outer loop unrolled inside inner loop.
   374  vec  (  16): Unvectorizable procedure reference.:maxvl
   374  vec  (   3): Unvectorized loop.
   374  vec  (  13): Overhead of loop division is too large.
   374  vec  (   3): Unvectorized loop.
   374  vec  (  13): Overhead of loop division is too large.
   375  opt  (1395): Inner loop stripped and strip loop moved outside outer loop.
   375  vec  (  16): Unvectorizable procedure reference.:maxvl
   375  vec  (   4): Vectorized array expression.
   375  vec  (  29): ADB is used for array.: xyr_radluwflux
   375  vec  (  29): ADB is used for array.: xyrr_trans
   375  vec  (  29): ADB is used for array.: xyz_intpf
   375  vec  (   4): Vectorized array expression.
   375  vec  (  29): ADB is used for array.: xyr_radluwflux
   375  vec  (  29): ADB is used for array.: xyrr_trans
   375  vec  (  29): ADB is used for array.: xyz_intpf
   388  opt  (1593): Loop nest collapsed into one loop.
   388  vec  (   1): Vectorized loop.
   388  vec  (  29): ADB is used for array.: xyra_delradluwflux
   388  vec  (  29): ADB is used for array.: xyrr_trans
   388  vec  (  29): ADB is used for array.: xy_surfintdpfdt
   394  opt  (1593): Loop nest collapsed into one loop.
   394  vec  (   1): Vectorized loop.
   394  vec  (  29): ADB is used for array.: xyra_delradluwflux
   398  opt  (1593): Loop nest collapsed into one loop.
   398  vec  (   1): Vectorized loop.
   398  vec  (  29): ADB is used for array.: xyra_delradluwflux
   398  vec  (  29): ADB is used for array.: xyrr_trans
   398  vec  (  29): ADB is used for array.: xy_intdpfdt1
   405  opt  (1593): Loop nest collapsed into one loop.
   405  vec  (   1): Vectorized loop.
   405  vec  (  29): ADB is used for array.: xyra_delradldwflux
   410  opt  (1593): Loop nest collapsed into one loop.
   410  vec  (   1): Vectorized loop.
   410  vec  (  29): ADB is used for array.: xyra_delradldwflux
   410  vec  (  29): ADB is used for array.: xyrr_trans
   410  vec  (  29): ADB is used for array.: xy_intdpfdt1
   416  opt  (1593): Loop nest collapsed into one loop.
   416  vec  (   1): Vectorized loop.
   416  vec  (  29): ADB is used for array.: xyra_delradldwflux
   500  opt  (1593): Loop nest collapsed into one loop.
   500  vec  (   4): Vectorized array expression.
   500  vec  (  29): ADB is used for array.: xyz_intpf
   501  opt  (1593): Loop nest collapsed into one loop.
   501  vec  (   1): Vectorized loop.
   501  vec  (  29): ADB is used for array.: xyz_intpf
   504  opt  (1593): Loop nest collapsed into one loop.
   504  vec  (   4): Vectorized array expression.
   504  vec  (  29): ADB is used for array.: xyz_intpf
   513  opt  (  11): Fused array assignments. :line 513 - 514
   513  opt  (1593): Loop nest collapsed into one loop.
   513  vec  (   4): Vectorized array expression.
   513  vec  (  29): ADB is used for array.: xyr_radluwflux
   513  vec  (  29): ADB is used for array.: xyr_radldwflux
   520  opt  (1593): Loop nest collapsed into one loop.
   520  vec  (   4): Vectorized array expression.
   520  vec  (  29): ADB is used for array.: xyr_radldwflux
   520  vec  (  29): ADB is used for array.: xyrr_trans
   520  vec  (  29): ADB is used for array.: xyr_intpf
   524  vec  (   3): Unvectorized loop.
   524  vec  (  13): Overhead of loop division is too large.
   525  opt  (1593): Loop nest collapsed into one loop.
   525  vec  (   4): Vectorized array expression.
   525  vec  (  29): ADB is used for array.: xyr_radldwflux
   525  vec  (  29): ADB is used for array.: xyr_intpf
   525  vec  (  29): ADB is used for array.: xyrr_trans
   538  opt  (1593): Loop nest collapsed into one loop.
   538  vec  (   4): Vectorized array expression.
   538  vec  (  29): ADB is used for array.: xyr_radluwflux
   538  vec  (  29): ADB is used for array.: xyrr_trans
   538  vec  (  29): ADB is used for array.: xyr_intpf
   538  vec  (  29): ADB is used for array.: xy_surfintpf
   542  vec  (   3): Unvectorized loop.
   542  vec  (  13): Overhead of loop division is too large.
   543  opt  (1593): Loop nest collapsed into one loop.
   543  vec  (   4): Vectorized array expression.
   543  vec  (  29): ADB is used for array.: xyr_radluwflux
   543  vec  (  29): ADB is used for array.: xyr_intpf
   543  vec  (  29): ADB is used for array.: xyrr_trans
   554  vec  (   3): Unvectorized loop.
   554  vec  (  13): Overhead of loop division is too large.
   555  opt  (1593): Loop nest collapsed into one loop.
   555  vec  (   4): Vectorized array expression.
   555  vec  (  29): ADB is used for array.: xyra_delradluwflux
   555  vec  (  29): ADB is used for array.: xyrr_trans
   555  vec  (  29): ADB is used for array.: xy_surfintdpfdt
   559  opt  (1593): Loop nest collapsed into one loop.
   559  vec  (   4): Vectorized array expression.
   559  vec  (  29): ADB is used for array.: xyra_delradluwflux
   561  opt  (1593): Loop nest collapsed into one loop.
   561  vec  (   4): Vectorized array expression.
   561  vec  (  29): ADB is used for array.: xyra_delradluwflux
   561  vec  (  29): ADB is used for array.: xyrr_trans
   561  vec  (  29): ADB is used for array.: xy_intdpfdt1
   565  vec  (   3): Unvectorized loop.
   565  vec  (  13): Overhead of loop division is too large.
   566  opt  (1593): Loop nest collapsed into one loop.
   566  vec  (   4): Vectorized array expression.
   566  vec  (  29): ADB is used for array.: xyra_delradluwflux
   566  vec  (  29): ADB is used for array.: xyrr_trans
   566  vec  (  29): ADB is used for array.: xy_intdpfdt1
   572  opt  (1593): Loop nest collapsed into one loop.
   572  vec  (   1): Vectorized loop.
   572  vec  (  29): ADB is used for array.: xyra_delradldwflux
   577  opt  (1593): Loop nest collapsed into one loop.
   577  vec  (   4): Vectorized array expression.
   577  vec  (  29): ADB is used for array.: xyra_delradldwflux
   577  vec  (  29): ADB is used for array.: xyrr_trans
   577  vec  (  29): ADB is used for array.: xy_intdpfdt1
   581  opt  (1592): Outer loop unrolled inside inner loop.
   581  vec  (   4): Vectorized array expression.
   581  vec  (  29): ADB is used for array.: xyra_delradldwflux
   581  vec  (   4): Vectorized array expression.
   581  vec  (  29): ADB is used for array.: xyra_delradldwflux
   584  opt  (1593): Loop nest collapsed into one loop.
   584  vec  (   4): Vectorized array expression.
   584  vec  (  29): ADB is used for array.: xyra_delradldwflux
   584  vec  (  29): ADB is used for array.: xyrr_trans
   584  vec  (  29): ADB is used for array.: xy_intdpfdt1
   590  opt  (1593): Loop nest collapsed into one loop.
   590  vec  (   4): Vectorized array expression.
   590  vec  (  29): ADB is used for array.: xyra_delradldwflux
   590  vec  (  29): ADB is used for array.: xyrr_trans
   590  vec  (  29): ADB is used for array.: xy_intdpfdt1
   595  opt  (1593): Loop nest collapsed into one loop.
   595  vec  (   1): Vectorized loop.
   595  vec  (  29): ADB is used for array.: xyra_delradldwflux
   685  opt  (1593): Loop nest collapsed into one loop.
   685  vec  (   4): Vectorized array expression.
   685  vec  (  29): ADB is used for array.: xyz_optdep
   687  opt  (1593): Loop nest collapsed into one loop.
   687  vec  (   4): Vectorized array expression.
   688  vec  (   3): Unvectorized loop.
   688  vec  (  13): Overhead of loop division is too large.
   689  opt  (1037): Feedback of array elements.
   689  opt  (1593): Loop nest collapsed into one loop.
   689  vec  (   4): Vectorized array expression.
   691  opt  (  11): Fused array assignments. :line 691 - 692
   691  opt  (1593): Loop nest collapsed into one loop.
   691  vec  (   4): Vectorized array expression.
   693  opt  (1593): Loop nest collapsed into one loop.
   693  vec  (   1): Vectorized loop.
   699  opt  (  11): Fused array assignments. :line 699 - 700
   699  opt  (1593): Loop nest collapsed into one loop.
   699  vec  (   4): Vectorized array expression.
   699  vec  (  29): ADB is used for array.: xyr_radluwflux
   699  vec  (  29): ADB is used for array.: xyr_radldwflux
   705  opt  (1593): Loop nest collapsed into one loop.
   705  vec  (   4): Vectorized array expression.
   705  vec  (  29): ADB is used for array.: xyr_radldwflux
   706  vec  (   3): Unvectorized loop.
   706  vec  (  13): Overhead of loop division is too large.
   707  opt  (1037): Feedback of array elements.
   707  opt  (1593): Loop nest collapsed into one loop.
   707  vec  (   4): Vectorized array expression.
   707  vec  (  29): ADB is used for array.: xyr_radldwflux
   707  vec  (  29): ADB is used for array.: xyz_intpf
   715  opt  (1593): Loop nest collapsed into one loop.
   715  vec  (   4): Vectorized array expression.
   715  vec  (  29): ADB is used for array.: xyr_radluwflux
   715  vec  (  29): ADB is used for array.: xy_surfintpf
   716  vec  (   3): Unvectorized loop.
   716  vec  (  13): Overhead of loop division is too large.
   717  opt  (1037): Feedback of array elements.
   717  opt  (1593): Loop nest collapsed into one loop.
   717  vec  (   4): Vectorized array expression.
   717  vec  (  29): ADB is used for array.: xyr_radluwflux
   717  vec  (  29): ADB is used for array.: xyz_intpf
   726  vec  (   3): Unvectorized loop.
   726  vec  (  13): Overhead of loop division is too large.
   727  opt  (1593): Loop nest collapsed into one loop.
   727  vec  (   4): Vectorized array expression.
   727  vec  (  29): ADB is used for array.: xyra_delradluwflux
   727  vec  (  29): ADB is used for array.: xy_surfintdpfdt
   731  opt  (1593): Loop nest collapsed into one loop.
   731  vec  (   4): Vectorized array expression.
   731  vec  (  29): ADB is used for array.: xyra_delradluwflux
   732  vec  (   3): Unvectorized loop.
   732  vec  (  13): Overhead of loop division is too large.
   733  opt  (1593): Loop nest collapsed into one loop.
   733  vec  (   4): Vectorized array expression.
   733  vec  (  29): ADB is used for array.: xyra_delradluwflux
   733  vec  (  29): ADB is used for array.: xy_intdpfdt1
   736  opt  (1593): Loop nest collapsed into one loop.
   736  vec  (   1): Vectorized loop.
   736  vec  (  29): ADB is used for array.: xyra_delradldwflux
   740  opt  (1593): Loop nest collapsed into one loop.
   740  vec  (   4): Vectorized array expression.
   740  vec  (  29): ADB is used for array.: xyra_delradldwflux
   740  vec  (  29): ADB is used for array.: xy_intdpfdt1
   742  opt  (1593): Loop nest collapsed into one loop.
   742  vec  (   1): Vectorized loop.
   742  vec  (  29): ADB is used for array.: xyra_delradldwflux
   851  opt  (1593): Loop nest collapsed into one loop.
   851  vec  (   4): Vectorized array expression.
   851  vec  (  29): ADB is used for array.: xyz_optdep
   853  opt  (1593): Loop nest collapsed into one loop.
   853  vec  (   1): Vectorized loop.
   863  opt  (1593): Loop nest collapsed into one loop.
   863  vec  (   1): Vectorized loop.
   863  vec  (  29): ADB is used for array.: xyz_optdep
   863  vec  (  29): ADB is used for array.: xyr_intpf
   880  opt  (  11): Fused array assignments. :line 880 - 881
   880  opt  (1593): Loop nest collapsed into one loop.
   880  vec  (   4): Vectorized array expression.
   880  vec  (  29): ADB is used for array.: xyr_radldwflux
   880  vec  (  29): ADB is used for array.: xyr_radluwflux
   882  opt  (  11): Fused array assignments. :line 882 - 883
   882  opt  (1772): Loop nest fused with following nest(s).
   882  opt  (1593): Loop nest collapsed into one loop.
   882  vec  (   4): Vectorized array expression.
   882  vec  (  29): ADB is used for array.: xyra_delradldwflux
   882  vec  (  29): ADB is used for array.: xyra_delradluwflux
   898  opt  (1593): Loop nest collapsed into one loop.
   898  vec  (   4): Vectorized array expression.
   898  vec  (  29): ADB is used for array.: xyz_transeachlayer
   898  vec  (  29): ADB is used for array.: xyz_transeachlayer0
   900  opt  (1593): Loop nest collapsed into one loop.
   900  vec  (   4): Vectorized array expression.
   900  vec  (  29): ADB is used for array.: xyr_trans0
   901  vec  (   3): Unvectorized loop.
   901  vec  (  13): Overhead of loop division is too large.
   902  opt  (1037): Feedback of array elements.
   902  opt  (1593): Loop nest collapsed into one loop.
   902  vec  (   4): Vectorized array expression.
   902  vec  (  29): ADB is used for array.: xyr_trans0
   902  vec  (  29): ADB is used for array.: xyz_transeachlayer
   904  opt  (  11): Fused array assignments. :line 904 - 905
   904  opt  (1593): Loop nest collapsed into one loop.
   904  vec  (   4): Vectorized array expression.
   904  vec  (  29): ADB is used for array.: xyr_trans1
   904  vec  (  29): ADB is used for array.: xyz_transeachlayer
   906  opt  (1593): Loop nest collapsed into one loop.
   906  vec  (   3): Unvectorized loop.
   906  vec  (  13): Overhead of loop division is too large.
   907  vec  (   4): Vectorized array expression.
   914  opt  (1593): Loop nest collapsed into one loop.
   914  vec  (   4): Vectorized array expression.
   915  vec  (   3): Unvectorized loop.
   915  vec  (  13): Overhead of loop division is too large.
   916  opt  (1037): Feedback of array elements.
   916  opt  (1593): Loop nest collapsed into one loop.
   916  vec  (   4): Vectorized array expression.
   916  vec  (  29): ADB is used for array.: xyr_dwflux
   916  vec  (  29): ADB is used for array.: xyz_dpfdoptdep
   916  vec  (  29): ADB is used for array.: xyz_transeachlayer
   916  vec  (  29): ADB is used for array.: xyr_intpf
   927  opt  (1593): Loop nest collapsed into one loop.
   927  vec  (   4): Vectorized array expression.
   927  vec  (  29): ADB is used for array.: xyr_uwflux
   927  vec  (  29): ADB is used for array.: xyr_dwflux
   927  vec  (  29): ADB is used for array.: xy_surfalbedo
   927  vec  (  29): ADB is used for array.: xy_surfintpf
   930  vec  (   3): Unvectorized loop.
   930  vec  (  13): Overhead of loop division is too large.
   931  opt  (1037): Feedback of array elements.
   931  opt  (1593): Loop nest collapsed into one loop.
   931  vec  (   4): Vectorized array expression.
   931  vec  (  29): ADB is used for array.: xyr_uwflux
   931  vec  (  29): ADB is used for array.: xyz_dpfdoptdep
   931  vec  (  29): ADB is used for array.: xyz_transeachlayer
   931  vec  (  29): ADB is used for array.: xyr_intpf
   943  vec  (   3): Unvectorized loop.
   943  vec  (  13): Overhead of loop division is too large.
   944  opt  (1593): Loop nest collapsed into one loop.
   944  vec  (   4): Vectorized array expression.
   944  vec  (  29): ADB is used for array.: xyra_deluwflux
   944  vec  (  29): ADB is used for array.: xyr_trans0
   944  vec  (  29): ADB is used for array.: xy_surfintdpfdt
   946  opt  (1593): Loop nest collapsed into one loop.
   946  vec  (   1): Vectorized loop.
   946  vec  (  29): ADB is used for array.: xyra_deldwflux
   949  opt  (  11): Fused array assignments. :line 949 - 950
   949  opt  (1593): Loop nest collapsed into one loop.
   949  vec  (   4): Vectorized array expression.
   949  vec  (  29): ADB is used for array.: xyra_deldwflux
   949  vec  (  29): ADB is used for array.: xyra_deluwflux
   958  opt  (  11): Fused array assignments. :line 958 - 960
   958  opt  (1593): Loop nest collapsed into one loop.
   958  vec  (   4): Vectorized array expression.
   958  vec  (  29): ADB is used for array.: xyr_radldwflux
   958  vec  (  29): ADB is used for array.: xyr_dwflux
   958  vec  (  29): ADB is used for array.: xyr_radluwflux
   958  vec  (  29): ADB is used for array.: xyr_uwflux
   963  opt  (  11): Fused array assignments. :line 963 - 965
   963  vec  (   4): Vectorized array expression.
   963  vec  (  29): ADB is used for array.: xyra_delradldwflux
   963  vec  (  29): ADB is used for array.: xyra_deldwflux
   963  vec  (  29): ADB is used for array.: xyra_delradluwflux
   963  vec  (  29): ADB is used for array.: xyra_deluwflux
   965  opt  (1082): Backward transfers inhibit loop optimization.
   968  opt  (  11): Fused array assignments. :line 968 - 969
   968  opt  (1057): Complicated use of variable inhibits loop optimization.
   968  opt  (1593): Loop nest collapsed into one loop.
   968  vec  (   4): Vectorized array expression.
   968  vec  (  29): ADB is used for array.: xyr_radldwflux
   968  vec  (  29): ADB is used for array.: xyr_dwflux
   968  vec  (  29): ADB is used for array.: xyr_radluwflux
   968  vec  (  29): ADB is used for array.: xyr_uwflux
   971  opt  (  11): Fused array assignments. :line 971 - 972
   971  opt  (1772): Loop nest fused with following nest(s).
   971  opt  (1593): Loop nest collapsed into one loop.
   971  vec  (   4): Vectorized array expression.
   971  vec  (  29): ADB is used for array.: xyra_delradldwflux
   971  vec  (  29): ADB is used for array.: xyra_deldwflux
   971  vec  (  29): ADB is used for array.: xyra_delradluwflux
   971  vec  (  29): ADB is used for array.: xyra_deluwflux
   978  warn (  83): Dummy argument "xy_intdpfdt1" is not used.
  1099  opt  (1593): Loop nest collapsed into one loop.
  1099  vec  (   4): Vectorized array expression.
  1099  vec  (  29): ADB is used for array.: xyz_intpf
  1100  opt  (  11): Fused array assignments. :line 1100 - 1102
  1100  vec  (   4): Vectorized array expression.
  1100  vec  (  29): ADB is used for array.: xy_surfintdpfdt
  1100  vec  (  29): ADB is used for array.: xy_intdpfdt1
  1100  vec  (  29): ADB is used for array.: xy_surfintpf
  1100  vec  (  29): ADB is used for array.: xy_surfemis
  1108  opt  (1593): Loop nest collapsed into one loop.
  1108  vec  (   4): Vectorized array expression.
  1108  vec  (  29): ADB is used for array.: xyz_intpf
  1108  vec  (  29): ADB is used for array.: xyz_temp
  1109  opt  (  11): Fused array assignments. :line 1109 - 1111
  1109  opt  (1593): Loop nest collapsed into one loop.
  1109  vec  (   4): Vectorized array expression.
  1109  vec  (  29): ADB is used for array.: xy_surfintdpfdt
  1109  vec  (  29): ADB is used for array.: xy_intdpfdt1
  1109  vec  (  29): ADB is used for array.: xyz_temp
  1109  vec  (  29): ADB is used for array.: xy_surfintpf
  1109  vec  (  29): ADB is used for array.: xy_surftemp
  1109  vec  (  29): ADB is used for array.: xy_surfemis
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:47 2016
FILE NAME: rad_rte_nonscat.f90
PROGRAM NAME: rad_rte_nonscat
TRANSFORMATION LIST

  LINE                   FORTRAN STATEMENT

     1  != 散乱を無視した放射伝達方程式
     2  !
     3  != Radiative transfer equation without considering scattering
     4  !
     5  ! Authors::   Yoshiyuki O. TAKAHASHI
     6  ! Version::   $Id: rad_rte_nonscat.f90,v 1.6 2014/06/29 07:48:29 yot Exp $
     7  ! Tag Name::  $Name:  $
     8  ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9  ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10  !
    11  
    12  module rad_rte_nonscat
    13    !
    14    != 散乱を無視した放射伝達方程式
    15    !
    16    != Radiative transfer equation without considering scattering
    17    !
    18    ! <b>Note that Japanese and English are described in parallel.</b>
    19    !
    20    !
    21    !
    22    !
    23    !
    24    !== Procedures List
    25    !
    26  !!$  ! RadDTempDt        :: 放射フラックスによる温度変化の計算
    27  !!$  ! RadFluxOutput     :: 放射フラックスの出力
    28  !!$  ! ------------            :: ------------
    29  !!$  ! RadDTempDt        :: Calculate temperature tendency with radiation flux
    30  !!$  ! RadFluxOutput     :: Output radiation fluxes
    31    !
    32    !== NAMELIST
    33    !
    34    ! NAMELIST#rad_rte_nonscat_nml
    35    !
    36  
    37    ! モジュール引用 ; USE statements
    38    !
    39  
    40    ! 種別型パラメタ
    41    ! Kind type parameter
    42    !
    43    use dc_types, only: DP, &      ! 倍精度実数型. Double precision.
    44      &                 STRING, &  ! 文字列.       Strings.
    45      &                 TOKEN      ! キーワード.   Keywords.
    46  
    47    ! 物理・数学定数設定
    48    ! Physical and mathematical constants settings
    49    !
    50    use constants0, only: &
    51      & PI, &
    52                              ! $ \pi $ .
    53                              ! 円周率.  Circular constant
    54      & StB
    55                              ! $ \sigma_{SB} $ .
    56                              ! ステファンボルツマン定数.
    57                              ! Stefan-Boltzmann constant
    58  
    59    ! 物理定数設定
    60    ! Physical constants settings
    61    !
    62    use constants, only: &
    63      & Grav, &
    64                              ! $ g $ [m s-2].
    65                              ! 重力加速度.
    66                              ! Gravitational acceleration
    67      & CpDry
    68                              ! $ C_p $ [J kg-1 K-1].
    69                              ! 乾燥大気の定圧比熱.
    70                              ! Specific heat of air at constant pressure
    71  
    72  
    73    ! 格子点設定
    74    ! Grid points settings
    75    !
    76    use gridset, only: imax, & ! 経度格子点数.
    77                               ! Number of grid points in longitude
    78      &                jmax, & ! 緯度格子点数.
    79                               ! Number of grid points in latitude
    80      &                kmax    ! 鉛直層数.
    81                               ! Number of vertical level
    82  
    83    ! メッセージ出力
    84    ! Message output
    85    !
    86    use dc_message, only: MessageNotify
    87  
    88    ! 宣言文 ; Declaration statements
    89    !
    90    implicit none
    91    private
    92  
    93    ! 公開手続き
    94    ! Public procedure
    95    !
    96    public :: RadRTENonScat
    97  !!$  public :: RadRTENonScatAnotherForm
    98  !!$  public :: RadRTENonScatMonoWithDiffFact
    99    public :: RadRTENonScatMonoSemiAnal
   100    public :: RadRTENonScatWrapper
   101    public :: RadRTENonScatInit
   102  
   103  
   104    ! 公開変数
   105    ! Public variables
   106    !
   107    logical, save, public:: rad_rte_nonscat_inited = .false.
   108                                ! 初期設定フラグ.
   109                                ! Initialization flag
   110  
   111  
   112    ! 非公開変数
   113    ! Private variables
   114    !
   115    integer , save              :: NumGaussNodeZAInt
   116    real(DP), save              :: DiffFact
   117    real(DP), save, allocatable :: a_CosZA( : )
   118    real(DP), save, allocatable :: a_GaussWeight( : )
   119  
   120  
   121    character(*), parameter:: module_name = 'rad_rte_nonscat'
   122                                ! モジュールの名称.
   123                                ! Module name
   124    character(*), parameter:: version = &
   125      & '$Name:  $' // &
   126      & '$Id: rad_rte_nonscat.f90,v 1.6 2014/06/29 07:48:29 yot Exp $'
   127                                ! モジュールのバージョン
   128                                ! Module version
   129  
   130  contains
   131  
   132    !--------------------------------------------------------------------------------------
   133  
   134    subroutine RadRTENonScat(                                    &
   135      & xyz_IntPF, xy_SurfIntPF, xy_IntDPFDT1, xy_SurfIntDPFDT,  & ! (in)
   136      & xyrr_Trans,                                              & ! (in)
   137      & xyr_RadLUwFlux, xyr_RadLDwFlux,                          & ! (out)
   138      & xyra_DelRadLUwFlux, xyra_DelRadLDwFlux                   & ! (out)
   139      & )
   140      !
   141      ! 散乱なしの場合の放射伝達方程式の計算
   142      !
   143      ! Integrate radiative transfer equation without scattering
   144      !
   145  
   146      ! モジュール引用 ; USE statements
   147      !
   148  
   149      ! OpenMP
   150      !
   151      !$ use omp_lib
   152  
   153  
   154      ! 宣言文 ; Declaration statements
   155      !
   156  
   157      real(DP), intent(in ) :: xyz_IntPF        (0:imax-1, 1:jmax, 1:kmax)
   158                                ! Integrated Planck function
   159      real(DP), intent(in ) :: xy_SurfIntPF     (0:imax-1, 1:jmax)
   160                                ! Integrated Planck function with surface temperature
   161      real(DP), intent(in ) :: xy_IntDPFDT1     (0:imax-1, 1:jmax)
   162                                ! Integrated temperature derivative of Planck function
   163      real(DP), intent(in ) :: xy_SurfIntDPFDT  (0:imax-1, 1:jmax)
   164                                ! Integrated temperature derivative of Planck function
   165                                ! with surface temperature
   166      real(DP), intent(in ) :: xyrr_Trans   (0:imax-1, 1:jmax, 0:kmax, 0:kmax)
   167                                ! 透過係数.
   168                                ! Transmission coefficient
   169      real(DP), intent(out) :: xyr_RadLUwFlux (0:imax-1, 1:jmax, 0:kmax)
   170                                ! 長波フラックス.
   171                                ! Upward longwave flux
   172      real(DP), intent(out) :: xyr_RadLDwFlux (0:imax-1, 1:jmax, 0:kmax)
   173                                ! 長波フラックス.
   174                                ! Downward longwave flux
   175      real(DP), intent(out) :: xyra_DelRadLUwFlux (0:imax-1, 1:jmax, 0:kmax, 0:1)
   176                                ! 長波地表温度変化.
   177                                ! Upward longwave flux derivative
   178      real(DP), intent(out) :: xyra_DelRadLDwFlux (0:imax-1, 1:jmax, 0:kmax, 0:1)
   179                                ! 長波地表温度変化.
   180                                ! Downward longwave flux derivative
   181  
   182  
   183      ! 作業変数
   184      ! Work variables
   185      !
   186      integer :: js
   187      integer :: je
   188  
   189      integer :: nthreads
   190      integer, allocatable :: a_js(:)
   191      integer, allocatable :: a_je(:)
   192  
   193      integer :: n
   194  
   195  
   196      ! 実行文 ; Executable statement
   197      !
   198  
   199      ! 初期化確認
   200      ! Initialization check
   201      !
   202      if ( .not. rad_rte_nonscat_inited ) then
   203        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   204      end if
   205  
   206  
   207      nthreads = 1
   208      !$ nthreads  = omp_get_max_threads()
   209  !!$    !$ write( 6, * ) "Number of processors : ", omp_get_num_procs()
   210  !!$    !$ write( 6, * ) "Number of threads    : ", nthreads
   211  
   212      allocate( a_js(0:nthreads-1) )
   213      allocate( a_je(0:nthreads-1) )
   214  
   215      do n = 0, nthreads-1
   216  
   217        if ( n == 0 ) then
   218          a_js(n) = 1
   219        else
   220          a_js(n) = a_je(n-1) + 1
   221        end if
   222  
   223        a_je(n) = a_js(n  ) + jmax / nthreads - 1
   224        if ( n + 1 <= mod( jmax, nthreads ) ) then
   225          a_je(n) = a_je(n) + 1
   226        end if
   227  
   228      end do
   229  
   230      !$OMP PARALLEL DEFAULT(PRIVATE) &
   231      !$OMP SHARED( &
   232      !$OMP         nthreads, a_js, a_je, &
   233      !$OMP         xyz_IntPF, xy_SurfIntPF, xy_IntDPFDT1, xy_SurfIntDPFDT,  &
   234      !$OMP         xyrr_Trans, &
   235      !$OMP         xyr_RadLUwFlux, xyr_RadLDwFlux,                          &
   236      !$OMP         xyra_DelRadLUwFlux, xyra_DelRadLDwFlux                   &
   237      !$OMP       )
   238  
   239      !$OMP DO
   240  
   241      do n = 0, nthreads-1
   242  
   243        js = a_js(n)
   244        je = a_je(n)
   245  
   246        if ( js > je ) cycle
   247  
   248        call RadRTENonScatCore(                                &
   249          & js, je,                                                  & ! (in)
   250          & xyz_IntPF, xy_SurfIntPF, xy_IntDPFDT1, xy_SurfIntDPFDT,  & ! (in)
   251          & xyrr_Trans,                                              & ! (in)
   252          & xyr_RadLUwFlux, xyr_RadLDwFlux,                          & ! (out)
   253          & xyra_DelRadLUwFlux, xyra_DelRadLDwFlux                   & ! (out)
   254          & )
   255  
   256      end do
   257  
   258  
   259      !$OMP END DO
   260      !$OMP END PARALLEL
   261  
   262  
   263      deallocate( a_js )
   264      deallocate( a_je )
   265  
   266  
   267    end subroutine RadRTENonScat
   268  
   269    !--------------------------------------------------------------------------------------
   270  
   271    subroutine RadRTENonScatCore(                                &
   272      & js, je,                                                  & ! (in)
   273      & xyz_IntPF, xy_SurfIntPF, xy_IntDPFDT1, xy_SurfIntDPFDT,  & ! (in)
   274      & xyrr_Trans,                                              & ! (in)
   275      & xyr_RadLUwFlux, xyr_RadLDwFlux,                          & ! (out)
   276      & xyra_DelRadLUwFlux, xyra_DelRadLDwFlux                   & ! (out)
   277      & )
   278      !
   279      ! 散乱なしの場合の放射伝達方程式の計算
   280      !
   281      ! Integrate radiative transfer equation without scattering
   282      !
   283  
   284      ! モジュール引用 ; USE statements
   285      !
   286  
   287  
   288      ! 宣言文 ; Declaration statements
   289      !
   290  
   291      integer , intent(in ) :: js
   292      integer , intent(in ) :: je
   293      real(DP), intent(in ) :: xyz_IntPF        (0:imax-1, 1:jmax, 1:kmax)
   294                                ! Integrated Planck function
   295      real(DP), intent(in ) :: xy_SurfIntPF     (0:imax-1, 1:jmax)
   296                                ! Integrated Planck function with surface temperature
   297      real(DP), intent(in ) :: xy_IntDPFDT1     (0:imax-1, 1:jmax)
   298                                ! Integrated temperature derivative of Planck function
   299      real(DP), intent(in ) :: xy_SurfIntDPFDT  (0:imax-1, 1:jmax)
   300                                ! Integrated temperature derivative of Planck function
   301                                ! with surface temperature
   302      real(DP), intent(in ) :: xyrr_Trans   (0:imax-1, 1:jmax, 0:kmax, 0:kmax)
   303                                ! 透過係数.
   304                                ! Transmission coefficient
   305      real(DP), intent(out) :: xyr_RadLUwFlux (0:imax-1, 1:jmax, 0:kmax)
   306                                ! 長波フラックス.
   307                                ! Upward longwave flux
   308      real(DP), intent(out) :: xyr_RadLDwFlux (0:imax-1, 1:jmax, 0:kmax)
   309                                ! 長波フラックス.
   310                                ! Downward longwave flux
   311      real(DP), intent(out) :: xyra_DelRadLUwFlux (0:imax-1, 1:jmax, 0:kmax, 0:1)
   312                                ! 長波地表温度変化.
   313                                ! Upward longwave flux derivative
   314      real(DP), intent(out) :: xyra_DelRadLDwFlux (0:imax-1, 1:jmax, 0:kmax, 0:1)
   315                                ! 長波地表温度変化.
   316                                ! Downward longwave flux derivative
   317  
   318  
   319      ! 作業変数
   320      ! Work variables
   321      !
   322      integer:: j
   323      integer:: k, kk           ! 鉛直方向に回る DO ループ用作業変数
   324                                ! Work variables for DO loop in vertical direction
   325  
   326      ! 実行文 ; Executable statement
   327      !
   328  
   329      ! 初期化確認
   330      ! Initialization check
   331      !
   332      if ( .not. rad_rte_nonscat_inited ) then
   333        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   334      end if
   335  
   336  
   337  
   338      ! 放射フラックス計算
   339      ! Calculate radiation flux
   340      !
   341  
   342      !   Initialization
   343      !
   344      do k = 0, kmax
   345        do j = js, je
   346          xyr_RadLDwFlux(:,j,k) = 0.0_DP
   347          xyr_RadLUwFlux(:,j,k) = 0.0_DP
   348        end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do j = 1, imax - (js - je)*imax                                   
     .           xyr_radldwflux(j-1,js,k) = 0.0000000000000000e+000             
     .           xyr_radluwflux(j-1,js,k) = 0.0000000000000000e+000             
     .        enddo                                                             
   349      end do
   350      !
   351      !   Downward flux
   352      !
   353      do k = kmax, 0, -1
   354  
   355        do kk = kmax, k+1, -1
   356          do j = js, je
   357            xyr_RadLDwFlux(:,j,k) = xyr_RadLDwFlux(:,j,k)          &
   358              & + xyz_IntPF(:,j,kk)                                &
   359              & * ( xyrr_Trans(:,j,k,kk-1) - xyrr_Trans(:,j,k,kk) )
   360          end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xyr_radldwflux,xyz_intpf,xyrr_trans)                       
     .        do j = 1, imax - (js - je)*imax                                   
     .           xyr_radldwflux(j-1,js,k) = xyr_radldwflux(j-1,js,k) + xyz_intpf
     .       1      (j-1,js,kk)*(xyrr_trans(j-1,js,k,kk-1)-xyrr_trans(j-1,js,k, 
     .       2      kk))                                                        
     .        enddo                                                             
   361        end do
   362  
   363      end do
   364      !
   365      !   Upward flux
   366      !
   367      !     Set upward flux
   368      !
   369      do k = 0, kmax
   370        do j = js, je
   371  
   372          xyr_RadLUwFlux(:,j,k) = xy_SurfIntPF(:,j) * xyrr_Trans(:,j,k,0)
     .  !cdir nodep                                                             
     .  !cdir on_adb(xyrr_trans,xy_surfintpf)                                   
     .        do t436 = 0, imax - 1                                             
   373  
   374          do kk = 1, k
   375            xyr_RadLUwFlux(:,j,k) = xyr_RadLUwFlux(:,j,k)          &
   376              & - xyz_IntPF(:,j,kk)                                &
   377              & * ( xyrr_Trans(:,j,k,kk-1) - xyrr_Trans(:,j,k,kk) )
   378          end do
     .  !cdir    nodep                                                          
     .  !cdir noassume                                                          
     .        do t4411 = 0, imax - 1, maxvl()                                   
     .           t4412 = min0(imax - t4411,maxvl())                             
     .           if (k .gt. 0) then                                             
     .              j1 = and(k,3)                                               
     .              do kk = 1, j1                                               
     .  !cdir          shortloop                                                
     .  !cdir          nodep                                                    
     .  !cdir          on_adb(xyz_intpf,xyrr_trans,xyr_radluwflux)              
     .                 do t441 = 1, t4412                                       
     .                    xyr_radluwflux(t4411+t441-1,j,k) = xyr_radluwflux(    
     .       1               t4411+t441-1,j,k) - xyz_intpf(t4411+t441-1,j,kk)*( 
     .       2               xyrr_trans(t4411+t441-1,j,k,kk-1)-xyrr_trans(t4411+
     .       3               t441-1,j,k,kk))                                    
     .                 enddo                                                    
     .              enddo                                                       
     .              do kk = j1 + 1, k, 4                                        
     .  !cdir          shortloop                                                
     .  !cdir          nodep                                                    
     .  !cdir          on_adb(xyz_intpf,xyrr_trans,xyr_radluwflux)              
     .                 do t441 = 1, t4412                                       
     .                    xyr_radluwflux(t4411+t441-1,j,k) = xyr_radluwflux(    
     .       1               t4411+t441-1,j,k) - (xyz_intpf(t4411+t441-1,j,kk)*(
     .       2               xyrr_trans(t4411+t441-1,j,k,kk-1)-xyrr_trans(t4411+
     .       3               t441-1,j,k,kk))+xyz_intpf(t4411+t441-1,j,kk+1)*(   
     .       4               xyrr_trans(t4411+t441-1,j,k,kk)-xyrr_trans(t4411+  
     .       5               t441-1,j,k,kk+1))+xyz_intpf(t4411+t441-1,j,kk+2)*( 
     .       6               xyrr_trans(t4411+t441-1,j,k,kk+1)-xyrr_trans(t4411+
     .       7               t441-1,j,k,kk+2))+xyz_intpf(t4411+t441-1,j,kk+3)*( 
     .       8               xyrr_trans(t4411+t441-1,j,k,kk+2)-xyrr_trans(t4411+
     .       9               t441-1,j,k,kk+3)))                                 
     .                 enddo                                                    
     .              enddo                                                       
     .           endif                                                          
     .        enddo                                                             
   379  
   380        end do
   381      end do
   382  
   383  
   384      ! 放射フラックスの変化率の計算
   385      ! Calculate rate of change of radiative flux
   386      !
   387      do k = 0, kmax
   388        do j = js, je
   389          xyra_DelRadLUwFlux(:,j,k,0) =                         &
   390            & xy_SurfIntDPFDT(:,j) * xyrr_Trans(:,j,k,0)
   391        end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xyrr_trans,xy_surfintdpfdt)                                
     .        do j = 1, imax - (js - je)*imax                                   
     .           xyra_delradluwflux(j-1,js,k,0) = xy_surfintdpfdt(j-1,js)*      
     .       1      xyrr_trans(j-1,js,k,0)                                      
     .        enddo                                                             
   392      end do
   393      k = 0
   394      do j = js, je
   395        xyra_DelRadLUwFlux(:,j,k,1) = 0.0_DP
   396      end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do j = 1, imax - (js - je)*imax                                   
     .           xyra_delradluwflux(j-1,js,0,1) = 0.0000000000000000e+000       
     .        enddo                                                             
   397      do k = 1, kmax
   398        do j = js, je
   399          xyra_DelRadLUwFlux(:,j,k,1) =                         &
   400            & - xy_IntDPFDT1(:,j)                               &
   401            &   * ( xyrr_Trans(:,j,k,0) - xyrr_Trans(:,j,k,1) )
   402        end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xyrr_trans,xy_intdpfdt1)                                   
     .        do j = 1, imax - (js - je)*imax                                   
     .           xyra_delradluwflux(j-1,js,k,1) = -xy_intdpfdt1(j-1,js)*(       
     .       1      xyrr_trans(j-1,js,k,0)-xyrr_trans(j-1,js,k,1))              
     .        enddo                                                             
   403      end do
   404      do k = 0, kmax
   405        do j = js, je
   406          xyra_DelRadLDwFlux(:,j,k,0) = 0.0_DP
   407        end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do j = 1, imax - (js - je)*imax                                   
     .           xyra_delradldwflux(j-1,js,k,0) = 0.0000000000000000e+000       
     .        enddo                                                             
   408      end do
   409      k = 0
   410      do j = js, je
   411        xyra_DelRadLDwFlux(:,j,k,1) =                         &
   412          & + xy_IntDPFDT1(:,j)                               &
   413          &   * ( xyrr_Trans(:,j,k,0) - xyrr_Trans(:,j,k,1) )
   414      end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xyrr_trans,xy_intdpfdt1)                                   
     .        do j = 1, imax - (js - je)*imax                                   
     .           xyra_delradldwflux(j-1,js,0,1) = xy_intdpfdt1(j-1,js)*(        
     .       1      xyrr_trans(j-1,js,0,0)-xyrr_trans(j-1,js,0,1))              
     .        enddo                                                             
   415      do k = 1, kmax
   416        do j = js, je
   417          xyra_DelRadLDwFlux(:,j,k,1) = 0.0_DP
   418        end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do j = 1, imax - (js - je)*imax                                   
     .           xyra_delradldwflux(j-1,js,k,1) = 0.0000000000000000e+000       
     .        enddo                                                             
   419      end do
   420  
   421  
   422    end subroutine RadRTENonScatCore
   423  
   424    !--------------------------------------------------------------------------------------
   425    ! This is a test version, and now (2014/06/29), this is not used because of
   426    ! not good performance. So, this will be deleted in future, probably.
   427    ! This routine calculates radiative flux by solving a radiative transfer
   428    ! equation without including scattering.
   429    ! The difference between this routine and RadRTENonScat is that this
   430    ! routine solves a radiative transfer equation of a form integrated by parts.
   431  
   432    subroutine RadRTENonScatAnotherForm(                         &
   433      & xyz_IntPF, xy_SurfIntPF, xy_IntDPFDT1, xy_SurfIntDPFDT,  & ! (in)
   434      & xyrr_Trans,                                              & ! (in)
   435      & xyr_RadLUwFlux, xyr_RadLDwFlux,                          & ! (out)
   436      & xyra_DelRadLUwFlux, xyra_DelRadLDwFlux                   & ! (out)
   437      & )
   438      !
   439      ! 散乱なしの場合の放射伝達方程式の計算
   440      !
   441      ! Integrate radiative transfer equation without scattering
   442      !
   443  
   444      ! モジュール引用 ; USE statements
   445      !
   446  
   447  
   448      ! 宣言文 ; Declaration statements
   449      !
   450  
   451      real(DP), intent(in ) :: xyz_IntPF        (0:imax-1, 1:jmax, 1:kmax)
   452                                ! Integrated Planck function
   453      real(DP), intent(in ) :: xy_SurfIntPF     (0:imax-1, 1:jmax)
   454                                ! Integrated Planck function with surface temperature
   455      real(DP), intent(in ) :: xy_IntDPFDT1     (0:imax-1, 1:jmax)
   456                                ! Integrated temperature derivative of Planck function
   457      real(DP), intent(in ) :: xy_SurfIntDPFDT  (0:imax-1, 1:jmax)
   458                                ! Integrated temperature derivative of Planck function
   459                                ! with surface temperature
   460      real(DP), intent(in ) :: xyrr_Trans   (0:imax-1, 1:jmax, 0:kmax, 0:kmax)
   461                                ! 透過係数.
   462                                ! Transmission coefficient
   463      real(DP), intent(out) :: xyr_RadLUwFlux (0:imax-1, 1:jmax, 0:kmax)
   464                                ! 長波フラックス.
   465                                ! Upward longwave flux
   466      real(DP), intent(out) :: xyr_RadLDwFlux (0:imax-1, 1:jmax, 0:kmax)
   467                                ! 長波フラックス.
   468                                ! Downward longwave flux
   469      real(DP), intent(out) :: xyra_DelRadLUwFlux (0:imax-1, 1:jmax, 0:kmax, 0:1)
   470                                ! 長波地表温度変化.
   471                                ! Upward longwave flux derivative
   472      real(DP), intent(out) :: xyra_DelRadLDwFlux (0:imax-1, 1:jmax, 0:kmax, 0:1)
   473                                ! 長波地表温度変化.
   474                                ! Downward longwave flux derivative
   475  
   476  
   477      ! 作業変数
   478      ! Work variables
   479      !
   480      real(DP) :: xyr_IntPF(0:imax-1, 1:jmax, 0:kmax)
   481  
   482      integer:: k, kk           ! 鉛直方向に回る DO ループ用作業変数
   483                                ! Work variables for DO loop in vertical direction
   484  
   485      ! 実行文 ; Executable statement
   486      !
   487  
   488      ! 初期化確認
   489      ! Initialization check
   490      !
   491      if ( .not. rad_rte_nonscat_inited ) then
   492        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   493      end if
   494  
   495  
   496  
   497      !
   498      ! Calculate integrated Planck function at layer interface
   499      !
   500      xyr_IntPF(:,:,0   ) = xyz_IntPF(:,:,1   )
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t428 = 1, xyr_intpf.DSC.U2*xyr_intpf.DSC.U1 + xyr_intpf.DSC.U2 
     .           xyr_intpf(t428-1,1,0) = xyz_intpf(t428-1,1,1)                  
     .        enddo                                                             
   501      do k = 1, kmax-1
   502        xyr_IntPF(:,:,k) = ( xyz_IntPF(:,:,k) + xyz_IntPF(:,:,k+1) ) / 2.0_DP
   503      end do
     .        d1 = 1.D0/2.00000000000000e+000                                   
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do k = 1, jmax*(kmax*imax - imax)                                 
     .           xyr_intpf(k-1,1,1) = (xyz_intpf(k-1,1,1)+xyz_intpf(k-1,1,2))*d1
     .        enddo                                                             
   504      xyr_IntPF(:,:,kmax) = xyz_IntPF(:,:,kmax)
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t446 = 1, xyr_intpf.DSC.U2*xyr_intpf.DSC.U1 + xyr_intpf.DSC.U2 
     .           xyr_intpf(t446-1,1,kmax) = xyz_intpf(t446-1,1,kmax)            
     .        enddo                                                             
   505  
   506  
   507      ! 放射フラックス計算
   508      ! Calculate radiation flux
   509      !
   510  
   511      !   Initialization
   512      !
   513      xyr_RadLDwFlux = 0.0_DP
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t454 = 1, jmax*(kmax*imax + imax)                              
     .           xyr_radldwflux(t454-1,1,0) = 0.0000000000000000e+000           
     .           xyr_radluwflux(t454-1,1,0) = 0.0000000000000000e+000           
     .        enddo                                                             
   514      xyr_RadLUwFlux = 0.0_DP
   515      !
   516      !   Downward flux
   517      !
   518      do k = kmax, 0, -1
   519  
   520        xyr_RadLDwFlux(:,:,k) =   &
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xyr_intpf)                                                 
     .        do t466 = 1, xyr_intpf.DSC.U2*xyr_intpf.DSC.U1 + xyr_intpf.DSC.U2 
     .           xyr_radldwflux(t466-1,1,k) = xyr_intpf(t466-1,1,k) - xyr_intpf(
     .       1      t466-1,1,kmax)*xyrr_trans(t466-1,1,k,kmax)                  
     .        enddo                                                             
   521          &   xyr_IntPF(:,:,k   ) &
   522          & - xyr_IntPF(:,:,kmax) * xyrr_Trans(:,:,k,kmax)
   523        !
   524        do kk = kmax, k+1, -1
   525          xyr_RadLDwFlux(:,:,k) = xyr_RadLDwFlux(:,:,k)                    &
     .        d2 = 1.D0/2.00000000000000e+000                                   
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xyr_intpf,xyr_radldwflux,xyrr_trans)                       
     .        do t478 = 1, jmax*imax                                            
     .           xyr_radldwflux(t478-1,1,k) = xyr_radldwflux(t478-1,1,k) - (    
     .       1      xyrr_trans(t478-1,1,k,kk-1)+xyrr_trans(t478-1,1,k,kk))*d2*( 
     .       2      xyr_intpf(t478-1,1,kk-1)-xyr_intpf(t478-1,1,kk))            
     .        enddo                                                             
   526            & - ( xyrr_Trans(:,:,k,kk-1) + xyrr_Trans(:,:,k,kk) ) / 2.0_DP &
   527            &   * ( xyr_IntPF(:,:,kk-1) - xyr_IntPF(:,:,kk) )
   528        end do
   529  
   530      end do
   531      !
   532      !   Upward flux
   533      !
   534      !     Set upward flux
   535      !
   536      do k = 0, kmax
   537  
   538        xyr_RadLUwFlux(:,:,k) =                                         &
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xyr_intpf,xyrr_trans,xy_surfintpf)                         
     .        do t494 = 1, jmax*imax                                            
     .           xyr_radluwflux(t494-1,1,k) = (xy_surfintpf(t494-1,1)-xyr_intpf(
     .       1      t494-1,1,0))*xyrr_trans(t494-1,1,k,0) + xyr_intpf(t494-1,1,k
     .       2      )                                                           
     .        enddo                                                             
   539          &   ( xy_SurfIntPF - xyr_IntPF(:,:,0) ) * xyrr_Trans(:,:,k,0) &
   540          & + xyr_IntPF(:,:,k)
   541        !
   542        do kk = 1, k
   543          xyr_RadLUwFlux(:,:,k) = xyr_RadLUwFlux(:,:,k)                    &
     .        d3 = 1.D0/2.00000000000000e+000                                   
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xyr_intpf,xyrr_trans,xyr_radluwflux)                       
     .        do t508 = 1, jmax*imax                                            
     .           xyr_radluwflux(t508-1,1,k) = xyr_radluwflux(t508-1,1,k) + (    
     .       1      xyrr_trans(t508-1,1,k,kk-1)+xyrr_trans(t508-1,1,k,kk))*d3*( 
     .       2      xyr_intpf(t508-1,1,kk-1)-xyr_intpf(t508-1,1,kk))            
     .        enddo                                                             
   544            & + ( xyrr_Trans(:,:,k,kk-1) + xyrr_Trans(:,:,k,kk) ) / 2.0_DP &
   545            &   * ( xyr_IntPF(:,:,kk-1) - xyr_IntPF(:,:,kk) )
   546        end do
   547  
   548      end do
   549  
   550  
   551      ! 放射フラックスの変化率の計算
   552      ! Calculate rate of change of radiative flux
   553      !
   554      do k = 0, kmax
   555        xyra_DelRadLUwFlux(:,:,k,0) =                         &
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xyrr_trans,xy_surfintdpfdt)                                
     .        do t524 = 1, jmax*imax                                            
     .           xyra_delradluwflux(t524-1,1,k,0) = xy_surfintdpfdt(t524-1,1)*  
     .       1      xyrr_trans(t524-1,1,k,0)                                    
     .        enddo                                                             
   556          & xy_SurfIntDPFDT * xyrr_Trans(:,:,k,0)
   557      end do
   558      k = 0
   559      xyra_DelRadLUwFlux(:,:,k,1) = 0.0_DP
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t534 = 1, jmax*imax                                            
     .           xyra_delradluwflux(t534-1,1,0,1) = 0.0000000000000000e+000     
     .        enddo                                                             
   560      k = 1
   561      xyra_DelRadLUwFlux(:,:,k,1) =                         &
     .        d4 = 1.D0/2.00000000000000e+000                                   
     .        d5 = d4/2.00000000000000e+000                                     
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xyrr_trans)                                                
     .        do t540 = 1, jmax*imax                                            
     .           xyra_delradluwflux(t540-1,1,1,1) = xy_intdpfdt1(t540-1,1)*(    
     .       1      5.00000000000000e-001 - xyrr_trans(t540-1,1,1,0)+(xyrr_trans
     .       2      (t540-1,1,1,0)+xyrr_trans(t540-1,1,1,1))*d5)                
     .        enddo                                                             
   562        &   xy_IntDPFDT1                                    &
   563        &   * ( - xyrr_Trans(:,:,k,0) + 1.0_DP / 2.0_DP     &
   564        &       + ( xyrr_Trans(:,:,k,0) + xyrr_Trans(:,:,k,1) ) / 2.0_DP / 2.0_DP )
   565      do k = 2, kmax
   566        xyra_DelRadLUwFlux(:,:,k,1) =                         &
     .        d6 = 1.D0/2.00000000000000e+000                                   
     .        d7 = d6/2.00000000000000e+000                                     
     .        d8 = 1.D0/2.00000000000000e+000                                   
     .        d9 = d8/2.00000000000000e+000                                     
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xyrr_trans,xy_intdpfdt1)                                   
     .        do t554 = 1, jmax*imax                                            
     .           xyra_delradluwflux(t554-1,1,k,1) = xy_intdpfdt1(t554-1,1)*((   
     .       1      xyrr_trans(t554-1,1,k,0)+xyrr_trans(t554-1,1,k,1))*d7-      
     .       2      xyrr_trans(t554-1,1,k,0)+(xyrr_trans(t554-1,1,k,1)+         
     .       3      xyrr_trans(t554-1,1,k,2))*d9)                               
     .        enddo                                                             
   567          &   xy_IntDPFDT1                                    &
   568          &   * ( - xyrr_Trans(:,:,k,0)                       &
   569          &       + ( xyrr_Trans(:,:,k,0) + xyrr_Trans(:,:,k,1) ) / 2.0_DP / 2.0_DP &
   570          &       + ( xyrr_Trans(:,:,k,1) + xyrr_Trans(:,:,k,2) ) / 2.0_DP / 2.0_DP )
   571      end do
   572      do k = 0, kmax
   573        xyra_DelRadLDwFlux(:,:,k,0) = 0.0_DP
   574      end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do k = 1, jmax*(kmax*imax + imax)                                 
     .           xyra_delradldwflux(k-1,1,0,0) = 0.0000000000000000e+000        
     .        enddo                                                             
   575      if ( kmax <= 1 ) then
   576        k = 0
   577        xyra_DelRadLDwFlux(:,:,k,1) =                         &
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xyrr_trans,xy_intdpfdt1)                                   
     .        do t612 = 1, jmax*imax                                            
     .           xyra_delradldwflux(t612-1,1,0,1) = xy_intdpfdt1(t612-1,1)*(    
     .       1      1.00000000000000e+000 - xyrr_trans(t612-1,1,0,1))           
     .        enddo                                                             
   578          & + xy_IntDPFDT1                                    &
   579          &   * (   1.0_DP - xyrr_Trans(:,:,k,k+1) )
   580        k = 1
   581        xyra_DelRadLDwFlux(:,:,k,1) = 0.0_DP
     .        if (jmax .gt. 0) then                                             
     .           j1 = and(jmax,3)                                               
     .  !cdir    nodep                                                          
     .           do t622 = 1, j1                                                
     .  !cdir       nodep                                                       
     .              do t624 = 1, 1 + imax - min0(1,imax)                        
     .                 xyra_delradldwflux(t624-1,t622,1,1) =                    
     .       1            0.0000000000000000e+000                               
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t622 = j1 + 1, jmax, 4                                      
     .  !cdir       nodep                                                       
     .              do t624 = 1, 1 + imax - min0(1,imax)                        
     .                 xyra_delradldwflux(t624-1,t622,1,1) =                    
     .       1            0.0000000000000000e+000                               
     .                 xyra_delradldwflux(t624-1,t622+1,1,1) =                  
     .       1            0.0000000000000000e+000                               
     .                 xyra_delradldwflux(t624-1,t622+2,1,1) =                  
     .       1            0.0000000000000000e+000                               
     .                 xyra_delradldwflux(t624-1,t622+3,1,1) =                  
     .       1            0.0000000000000000e+000                               
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
     .        goto 10111                                                        
   582      else
   583        k = 0
   584        xyra_DelRadLDwFlux(:,:,k,1) =                         &
     .        d10 = 1.D0/2.00000000000000e+000                                  
     .        d11 = d10/2.00000000000000e+000                                   
     .        d12 = 1.D0/2.00000000000000e+000                                  
     .        d13 = d12/2.00000000000000e+000                                   
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xyrr_trans,xy_intdpfdt1)                                   
     .        do t578 = 1, jmax*imax                                            
     .           xyra_delradldwflux(t578-1,1,0,1) = xy_intdpfdt1(t578-1,1)*(    
     .       1      1.00000000000000e+000 - (xyrr_trans(t578-1,1,0,0)+xyrr_trans
     .       2      (t578-1,1,0,1))*d11-(xyrr_trans(t578-1,1,0,1)+xyrr_trans(   
     .       3      t578-1,1,0,2))*d13)                                         
     .        enddo                                                             
   585          & + xy_IntDPFDT1                                    &
   586          &   * (   1.0_DP                                      &
   587          &       - ( xyrr_Trans(:,:,k,k  ) + xyrr_Trans(:,:,k,k+1) ) / 2.0_DP / 2.0_DP &
   588          &       - ( xyrr_Trans(:,:,k,k+1) + xyrr_Trans(:,:,k,k+2) ) / 2.0_DP / 2.0_DP )
   589        k = 1
   590        xyra_DelRadLDwFlux(:,:,k,1) =                         &
     .        d14 = 1.D0/2.00000000000000e+000                                  
     .        d15 = d14/2.00000000000000e+000                                   
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xyrr_trans,xy_intdpfdt1)                                   
     .        do t594 = 1, jmax*imax                                            
     .           xyra_delradldwflux(t594-1,1,1,1) = xy_intdpfdt1(t594-1,1)*(    
     .       1      5.00000000000000e-001 - (xyrr_trans(t594-1,1,1,1)+xyrr_trans
     .       2      (t594-1,1,1,2))*d15)                                        
     .        enddo                                                             
   591          & + xy_IntDPFDT1                                    &
   592          &   * (   1.0_DP / 2.0_DP                           &
   593          &       - ( xyrr_Trans(:,:,k,k  ) + xyrr_Trans(:,:,k,k+1) ) / 2.0_DP / 2.0_DP )
   594      end if
   595      do k = 2, kmax
   596        xyra_DelRadLDwFlux(:,:,k,1) = 0.0_DP
   597      end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do k = 1, jmax*(kmax*imax - imax)                                 
     .           xyra_delradldwflux(k-1,1,2,1) = 0.0000000000000000e+000        
     .        enddo                                                             
   598  
   599  
   600    end subroutine RadRTENonScatAnotherForm
   601  
   602    !--------------------------------------------------------------------------------------
   603    ! This calculation method may not be good. Numerical integration over zenith
   604    ! angle should be performed.
   605    subroutine RadRTENonScatMonoWithDiffFact(                    &
   606      & DiffFact,                                                & ! (in)
   607      & xyz_IntPF, xy_SurfIntPF, xy_IntDPFDT1, xy_SurfIntDPFDT,  & ! (in)
   608      & xyz_OptDep,                                              & ! (in)
   609      & xyr_RadLUwFlux, xyr_RadLDwFlux,                          & ! (out)
   610      & xyra_DelRadLUwFlux, xyra_DelRadLDwFlux                   & ! (out)
   611      & )
   612      !
   613      ! 散乱なしの場合の放射伝達方程式の計算
   614      !
   615      ! Integrate radiative transfer equation without scattering
   616      !
   617  
   618      ! モジュール引用 ; USE statements
   619      !
   620  
   621  
   622      ! 宣言文 ; Declaration statements
   623      !
   624  
   625      real(DP), intent(in ) :: DiffFact
   626                                ! Diffusivity factor
   627      real(DP), intent(in ) :: xyz_IntPF        (0:imax-1, 1:jmax, 1:kmax)
   628                                ! Integrated Planck function
   629      real(DP), intent(in ) :: xy_SurfIntPF     (0:imax-1, 1:jmax)
   630                                ! Integrated Planck function with surface temperature
   631      real(DP), intent(in ) :: xy_IntDPFDT1     (0:imax-1, 1:jmax)
   632                                ! Integrated temperature derivative of Planck function
   633      real(DP), intent(in ) :: xy_SurfIntDPFDT  (0:imax-1, 1:jmax)
   634                                ! Integrated temperature derivative of Planck function
   635                                ! with surface temperature
   636      real(DP), intent(in ) :: xyz_OptDep   (0:imax-1, 1:jmax, 1:kmax)
   637                                ! 光学的厚さ.
   638                                ! Optical depth
   639      real(DP), intent(out) :: xyr_RadLUwFlux (0:imax-1, 1:jmax, 0:kmax)
   640                                ! 長波フラックス.
   641                                ! Upward longwave flux
   642      real(DP), intent(out) :: xyr_RadLDwFlux (0:imax-1, 1:jmax, 0:kmax)
   643                                ! 長波フラックス.
   644                                ! Downward longwave flux
   645      real(DP), intent(out) :: xyra_DelRadLUwFlux (0:imax-1, 1:jmax, 0:kmax, 0:1)
   646                                ! 長波地表温度変化.
   647                                ! Upward longwave flux derivative
   648      real(DP), intent(out) :: xyra_DelRadLDwFlux (0:imax-1, 1:jmax, 0:kmax, 0:1)
   649                                ! 長波地表温度変化.
   650                                ! Downward longwave flux derivative
   651  
   652  
   653      ! 作業変数
   654      ! Work variables
   655      !
   656      real(DP) :: xyz_TransEachLayer(0:imax-1, 1:jmax, 1:kmax)
   657                                ! 透過係数.
   658                                ! Transmission coefficient
   659      real(DP) :: xyr_Trans0(0:imax-1, 1:jmax, 0:kmax)
   660                                !
   661                                ! Transmission coefficient from surface to layer interfaces
   662      real(DP) :: xyr_Trans1(0:imax-1, 1:jmax, 0:kmax)
   663                                !
   664                                ! Transmission coefficient from top of the lowest layer to layer interfaces
   665  
   666      integer:: k               ! 鉛直方向に回る DO ループ用作業変数
   667                                ! Work variables for DO loop in vertical direction
   668  
   669      ! 実行文 ; Executable statement
   670      !
   671  
   672      ! 初期化確認
   673      ! Initialization check
   674      !
   675      if ( .not. rad_rte_nonscat_inited ) then
   676        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   677      end if
   678  
   679  
   680  
   681      ! 放射フラックス計算
   682      ! Calculate radiation flux
   683      !
   684  
   685      xyz_TransEachLayer = exp( - DiffFact * xyz_OptDep )
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t357 = 1, kmax*jmax*imax                                       
     .           xyz_transeachlayer(t357-1,1,1) = dexp((-difffact*xyz_optdep(   
     .       1      t357-1,1,1)))                                               
     .        enddo                                                             
   686      !
   687      xyr_Trans0(:,:,0) = 1.0_DP
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t369 = 1, xyr_trans0.DSC.U2*xyr_trans0.DSC.U1 +                
     .       1   xyr_trans0.DSC.U2                                              
     .           xyr_trans0(t369-1,1,0) = 1.00000000000000e+000                 
     .        enddo                                                             
   688      do k = 1, kmax
   689        xyr_Trans0(:,:,k) = xyr_Trans0(:,:,k-1) * xyz_TransEachLayer(:,:,k)
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t375 = 1, xyr_trans0.DSC.U2*xyr_trans0.DSC.U1 +                
     .       1   xyr_trans0.DSC.U2                                              
     .           xyr_trans0(t375-1,1,k) = xyr_trans0(t375-1,1,k-1)*             
     .       1      xyz_transeachlayer(t375-1,1,k)                              
     .        enddo                                                             
   690      end do
   691      xyr_Trans1(:,:,0) = xyz_TransEachLayer(:,:,1)
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t385 = 1, xyr_trans1.DSC.U2*xyr_trans1.DSC.U1 +                
     .       1   xyr_trans1.DSC.U2                                              
     .           xyr_trans1(t385-1,1,0) = xyz_transeachlayer(t385-1,1,1)        
     .           xyr_trans1(t385-1,1,1) = 1.00000000000000e+000                 
     .        enddo                                                             
   692      xyr_Trans1(:,:,1) = 1.0_DP
   693      do k = 2, kmax
   694        xyr_Trans1(:,:,k) = xyr_Trans0(:,:,k-1) * xyz_TransEachLayer(:,:,k)
   695      end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do k = 1, (kmax - 1)*xyr_trans0.DSC.U2*(xyr_trans0.DSC.U1 + 1)    
     .           xyr_trans1(k-1,1,2) = xyr_trans0(k-1,1,1)*xyz_transeachlayer(k-
     .       1      1,1,2)                                                      
     .        enddo                                                             
   696  
   697      !   Initialization
   698      !
   699      xyr_RadLDwFlux = 0.0_DP
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t405 = 1, jmax*(kmax*imax + imax)                              
     .           xyr_radldwflux(t405-1,1,0) = 0.0000000000000000e+000           
     .           xyr_radluwflux(t405-1,1,0) = 0.0000000000000000e+000           
     .        enddo                                                             
   700      xyr_RadLUwFlux = 0.0_DP
   701      !
   702      !   Downward flux
   703      !
   704      k = kmax
   705      xyr_RadLDwFlux(:,:,k) = 0.0_DP
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t417 = 1, jmax*imax                                            
     .           xyr_radldwflux(t417-1,1,k) = 0.0000000000000000e+000           
     .        enddo                                                             
   706      do k = kmax-1, 0, -1
   707        xyr_RadLDwFlux(:,:,k) =                                     &
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t423 = 1, jmax*imax                                            
     .           xyr_radldwflux(t423-1,1,k) = xyr_radldwflux(t423-1,1,k+1)*     
     .       1      xyz_transeachlayer(t423-1,1,k+1) + xyz_intpf(t423-1,1,k+1)*(
     .       2      1.00000000000000e+000 - xyz_transeachlayer(t423-1,1,k+1))   
     .        enddo                                                             
   708          &   xyr_RadLDwFlux(:,:,k+1) * xyz_TransEachLayer(:,:,k+1) &
   709          & + xyz_IntPF(:,:,k+1) * ( 1.0_DP - xyz_TransEachLayer(:,:,k+1) )
   710      end do
   711      !
   712      !   Upward flux
   713      !
   714      k = 0
   715      xyr_RadLUwFlux(:,:,k) = xy_SurfIntPF
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t437 = 1, jmax*imax                                            
     .           xyr_radluwflux(t437-1,1,0) = xy_surfintpf(t437-1,1)            
     .        enddo                                                             
   716      do k = 1, kmax
   717        xyr_RadLUwFlux(:,:,k) =                                   &
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t445 = 1, jmax*imax                                            
     .           xyr_radluwflux(t445-1,1,k) = xyr_radluwflux(t445-1,1,k-1)*     
     .       1      xyz_transeachlayer(t445-1,1,k) - xyz_intpf(t445-1,1,k)*(    
     .       2      xyz_transeachlayer(t445-1,1,k)-1.00000000000000e+000)       
     .        enddo                                                             
   718          &   xyr_RadLUwFlux(:,:,k-1) * xyz_TransEachLayer(:,:,k) &
   719          & - xyz_IntPF(:,:,k) * ( xyz_TransEachLayer(:,:,k) - 1.0_DP )
   720      end do
   721  
   722  
   723      ! 放射フラックスの変化率の計算
   724      ! Calculate rate of change of radiative flux
   725      !
   726      do k = 0, kmax
   727        xyra_DelRadLUwFlux(:,:,k,0) =                         &
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xy_surfintdpfdt)                                           
     .        do t459 = 1, jmax*imax                                            
     .           xyra_delradluwflux(t459-1,1,k,0) = xy_surfintdpfdt(t459-1,1)*  
     .       1      xyr_trans0(t459-1,1,k)                                      
     .        enddo                                                             
   728          & xy_SurfIntDPFDT * xyr_Trans0(:,:,k)
   729      end do
   730      k = 0
   731      xyra_DelRadLUwFlux(:,:,k,1) = 0.0_DP
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t469 = 1, jmax*imax                                            
     .           xyra_delradluwflux(t469-1,1,0,1) = 0.0000000000000000e+000     
     .        enddo                                                             
   732      do k = 1, kmax
   733        xyra_DelRadLUwFlux(:,:,k,1) =                         &
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xy_intdpfdt1)                                              
     .        do t475 = 1, jmax*imax                                            
     .           xyra_delradluwflux(t475-1,1,k,1) = -xy_intdpfdt1(t475-1,1)*(   
     .       1      xyr_trans0(t475-1,1,k)-xyr_trans1(t475-1,1,k))              
     .        enddo                                                             
   734          & - xy_IntDPFDT1 * ( xyr_Trans0(:,:,k) - xyr_Trans1(:,:,k) )
   735      end do
   736      do k = 0, kmax
   737        xyra_DelRadLDwFlux(:,:,k,0) = 0.0_DP
   738      end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do k = 1, jmax*(kmax*imax + imax)                                 
     .           xyra_delradldwflux(k-1,1,0,0) = 0.0000000000000000e+000        
     .        enddo                                                             
   739      k = 0
   740      xyra_DelRadLDwFlux(:,:,k,1) =                         &
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xy_intdpfdt1)                                              
     .        do t493 = 1, jmax*imax                                            
     .           xyra_delradldwflux(t493-1,1,0,1) = xy_intdpfdt1(t493-1,1)*(    
     .       1      xyr_trans0(t493-1,1,0)-xyr_trans1(t493-1,1,0))              
     .        enddo                                                             
   741        & + xy_IntDPFDT1 * ( xyr_Trans0(:,:,k) - xyr_Trans1(:,:,k) )
   742      do k = 1, kmax
   743        xyra_DelRadLDwFlux(:,:,k,1) = 0.0_DP
   744      end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do k = 1, kmax*jmax*imax                                          
     .           xyra_delradldwflux(k-1,1,1,1) = 0.0000000000000000e+000        
     .        enddo                                                             
   745  
   746  
   747    end subroutine RadRTENonScatMonoWithDiffFact
   748  
   749    !--------------------------------------------------------------------------------------
   750    ! ###This memo should be checked.###
   751    ! It should be noted that IntPF is Planck function integrated over
   752    ! wavenumber and azimuthal angle and divided by 2.
   753  !!$  ! So, pi is multiplied after integrated over wavenumber.
   754    !
   755    subroutine RadRTENonScatMonoSemiAnal(                        &
   756      & xy_SurfAlbedo,                                           & ! (in)
   757      & xyr_IntPF, xy_SurfIntPF, xy_IntDPFDT1, xy_SurfIntDPFDT,  & ! (in)
   758      & xyz_OptDep,                                              & ! (in)
   759      & xyr_RadLUwFlux, xyr_RadLDwFlux,                          & ! (out)
   760      & xyra_DelRadLUwFlux, xyra_DelRadLDwFlux                   & ! (out)
   761      & )
   762      !
   763      ! 散乱なしの場合の放射伝達方程式の計算
   764      !
   765      ! Integrate radiative transfer equation without scattering
   766      !
   767  
   768      ! モジュール引用 ; USE statements
   769      !
   770  
   771  
   772      ! 宣言文 ; Declaration statements
   773      !
   774  
   775      real(DP), intent(in ) :: xy_SurfAlbedo    (0:imax-1, 1:jmax)
   776      real(DP), intent(in ) :: xyr_IntPF        (0:imax-1, 1:jmax, 0:kmax)
   777                                ! Integrated Planck function
   778      real(DP), intent(in ) :: xy_SurfIntPF     (0:imax-1, 1:jmax)
   779                                ! Integrated Planck function with surface temperature
   780      real(DP), intent(in ) :: xy_IntDPFDT1     (0:imax-1, 1:jmax)
   781                                ! Integrated temperature derivative of Planck function
   782      real(DP), intent(in ) :: xy_SurfIntDPFDT  (0:imax-1, 1:jmax)
   783                                ! Integrated temperature derivative of Planck function
   784                                ! with surface temperature
   785      real(DP), intent(in ) :: xyz_OptDep   (0:imax-1, 1:jmax, 1:kmax)
   786                                ! 光学的厚さ.
   787                                ! Optical depth
   788      real(DP), intent(out) :: xyr_RadLUwFlux (0:imax-1, 1:jmax, 0:kmax)
   789                                ! 長波フラックス.
   790                                ! Upward longwave flux
   791      real(DP), intent(out) :: xyr_RadLDwFlux (0:imax-1, 1:jmax, 0:kmax)
   792                                ! 長波フラックス.
   793                                ! Downward longwave flux
   794      real(DP), intent(out) :: xyra_DelRadLUwFlux (0:imax-1, 1:jmax, 0:kmax, 0:1)
   795                                ! 長波地表温度変化.
   796                                ! Upward longwave flux derivative
   797      real(DP), intent(out) :: xyra_DelRadLDwFlux (0:imax-1, 1:jmax, 0:kmax, 0:1)
   798                                ! 長波地表温度変化.
   799                                ! Downward longwave flux derivative
   800  
   801  
   802      ! 作業変数
   803      ! Work variables
   804      !
   805      real(DP) :: CosZA
   806      real(DP) :: GaussWeight
   807  
   808      real(DP) :: xyz_TransEachLayer0(0:imax-1, 1:jmax, 1:kmax)
   809      real(DP) :: xyz_TransEachLayer (0:imax-1, 1:jmax, 1:kmax)
   810                                ! 透過係数.
   811                                ! Transmission coefficient
   812      real(DP) :: xyr_Trans0(0:imax-1, 1:jmax, 0:kmax)
   813                                !
   814                                ! Transmission coefficient from surface to layer interfaces
   815      real(DP) :: xyr_Trans1(0:imax-1, 1:jmax, 0:kmax)
   816                                !
   817                                ! Transmission coefficient from top of the lowest layer to layer interfaces
   818  
   819      real(DP) :: xyz_DPFDOptDep(0:imax-1, 1:jmax, 1:kmax)
   820  
   821      real(DP) :: xyr_UwFlux (0:imax-1, 1:jmax, 0:kmax)
   822      real(DP) :: xyr_DwFlux (0:imax-1, 1:jmax, 0:kmax)
   823      real(DP) :: xyra_DelUwFlux (0:imax-1, 1:jmax, 0:kmax, 0:1)
   824      real(DP) :: xyra_DelDwFlux (0:imax-1, 1:jmax, 0:kmax, 0:1)
   825  
   826      real(DP) :: IntFact
   827  
   828      integer:: i
   829      integer:: j
   830      integer:: k               ! 鉛直方向に回る DO ループ用作業変数
   831                                ! Work variables for DO loop in vertical direction
   832      integer:: n
   833  
   834  
   835      ! 実行文 ; Executable statement
   836      !
   837  
   838      ! 初期化確認
   839      ! Initialization check
   840      !
   841      if ( .not. rad_rte_nonscat_inited ) then
   842        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   843      end if
   844  
   845  
   846  
   847      ! 放射フラックス計算
   848      ! Calculate radiation flux
   849      !
   850  
   851      xyz_TransEachLayer0 = exp( - xyz_OptDep )
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t608 = 1, kmax*jmax*imax                                       
     .           xyz_transeachlayer0(t608-1,1,1) = dexp((-xyz_optdep(t608-1,1,1)
     .       1      ))                                                          
     .        enddo                                                             
   852      !  This is ad hoc treatment to avoid underflow.
   853      do k = 1, kmax
   854        do j = 1, jmax
   855          do i = 0, imax-1
   856            if ( xyz_TransEachLayer0(i,j,k) < 1.0e-50_DP ) then
   857              xyz_TransEachLayer0(i,j,k) = 0.0_DP
   858            end if
   859          end do
   860        end do
   861      end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do k = 1, kmax*jmax*imax                                          
     .           if (xyz_transeachlayer0(k-1,1,1) .lt. 1.00000000000000e-050)   
     .       1      then                                                        
     .              xyz_transeachlayer0(k-1,1,1) = 0.0000000000000000e+000      
     .           endif                                                          
     .        enddo                                                             
   862  
   863      do k = 1, kmax
   864        xyz_DPFDOptDep(:,:,k) =                      &
   865          &   ( xyr_IntPF(:,:,k-1) - xyr_IntPF(:,:,k) ) &
   866          & / max( xyz_OptDep(:,:,k), 1.0d-100 )
   867      end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do k = 1, kmax*jmax*imax                                          
     .           xyz_dpfdoptdep(k-1,1,1) = (xyr_intpf(k-1,1,0)-xyr_intpf(k-1,1,1
     .       1      ))/max(xyz_optdep(k-1,1,1),1.00000000000000e-100)           
     .        enddo                                                             
   868  
   869      if ( NumGaussNodeZAInt > 0 ) then
   870        ! for case with Gaussian quadrature
   871        IntFact = 2.0_DP
   872      else
   873        ! for two-stream approximation or case with diffusivity factor
   874        IntFact = 1.0_DP
   875      end if
   876  
   877  
   878      !   Initialization
   879      !
   880      xyr_RadLUwFlux     = 0.0_DP
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t632 = 1, jmax*(kmax*imax + imax)                              
     .           xyr_radluwflux(t632-1,1,0) = 0.0000000000000000e+000           
     .           xyr_radldwflux(t632-1,1,0) = 0.0000000000000000e+000           
     .        enddo                                                             
   881      xyr_RadLDwFlux     = 0.0_DP
   882      xyra_DelRadLUwFlux = 0.0_DP
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t646 = 1, jmax*(kmax*imax + imax)                              
     .           xyra_delradluwflux(t646-1,1,0,0) = 0.0000000000000000e+000     
     .           xyra_delradldwflux(t646-1,1,0,0) = 0.0000000000000000e+000     
     .           xyra_delradluwflux(t646-1,1,0,1) = 0.0000000000000000e+000     
     .           xyra_delradldwflux(t646-1,1,0,1) = 0.0000000000000000e+000     
     .        enddo                                                             
   883      xyra_DelRadLDwFlux = 0.0_DP
   884  
   885  
   886      !   Loop for Gaussian quadrature
   887      !
   888      loop_gq : do n = 1, max( NumGaussNodeZAInt, 1 )
   889  
   890        ! Preparetion
   891        !
   892        if ( NumGaussNodeZAInt > 0 ) then
   893          CosZA = a_CosZA(n)
   894        else
   895          CosZA = 1.0_DP / DiffFact
   896        end if
   897        !
   898        xyz_TransEachLayer = ( xyz_TransEachLayer0 )**(1.0d0/CosZA)
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xyz_transeachlayer0,xyz_transeachlayer)                    
     .        do t660 = 1, xyz_transeachlayer0.DSC.U3*(                         
     .       1   xyz_transeachlayer0.DSC.U2*xyz_transeachlayer0.DSC.U1 +        
     .       2   xyz_transeachlayer0.DSC.U2)                                    
     .           xyz_transeachlayer(t660-1,1,1) = xyz_transeachlayer0(t660-1,1,1
     .       1      )**(1.00000000000000e+000/cosza)                            
     .        enddo                                                             
   899        !
   900        xyr_Trans0(:,:,0) = 1.0_DP
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xyr_trans0)                                                
     .        do t672 = 1, xyr_trans0.DSC.U2*xyr_trans0.DSC.U1 +                
     .       1   xyr_trans0.DSC.U2                                              
     .           xyr_trans0(t672-1,1,0) = 1.00000000000000e+000                 
     .        enddo                                                             
   901        do k = 1, kmax
   902          xyr_Trans0(:,:,k) = xyr_Trans0(:,:,k-1) * xyz_TransEachLayer(:,:,k)
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xyz_transeachlayer,xyr_trans0)                             
     .        do t678 = 1, xyr_trans0.DSC.U2*xyr_trans0.DSC.U1 +                
     .       1   xyr_trans0.DSC.U2                                              
     .           xyr_trans0(t678-1,1,k) = xyr_trans0(t678-1,1,k-1)*             
     .       1      xyz_transeachlayer(t678-1,1,k)                              
     .        enddo                                                             
   903        end do
   904        xyr_Trans1(:,:,0) = xyz_TransEachLayer(:,:,1)
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xyz_transeachlayer,xyr_trans1)                             
     .        do t688 = 1, xyr_trans1.DSC.U2*xyr_trans1.DSC.U1 +                
     .       1   xyr_trans1.DSC.U2                                              
     .           xyr_trans1(t688-1,1,0) = xyz_transeachlayer(t688-1,1,1)        
     .        enddo                                                             
   905        xyr_Trans1(:,:,1) = 1.0_DP
   906        do k = 2, kmax
   907          xyr_Trans1(:,:,k) = xyr_Trans0(:,:,k-1) * xyz_TransEachLayer(:,:,k)
   908        end do
   909  
   910        !
   911        !   Downward flux
   912        !
   913        k = kmax
   914        xyr_DwFlux(:,:,k) = 0.0_DP
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t708 = 1, xyr_dwflux.DSC.U2*xyr_dwflux.DSC.U1 +                
     .       1   xyr_dwflux.DSC.U2                                              
     .           xyr_dwflux(t708-1,1,k) = 0.0000000000000000e+000               
     .        enddo                                                             
   915        do k = kmax-1, 0, -1
   916          xyr_DwFlux(:,:,k) =                                          &
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xyz_transeachlayer,xyr_dwflux,xyr_intpf,xyz_dpfdoptdep)    
     .        do t714 = 1, xyr_dwflux.DSC.U2*xyr_dwflux.DSC.U1 +                
     .       1   xyr_dwflux.DSC.U2                                              
     .           xyr_dwflux(t714-1,1,k) = (xyr_dwflux(t714-1,1,k+1)-intfact*    
     .       1      xyr_intpf(t714-1,1,k+1))*xyz_transeachlayer(t714-1,1,k+1) + 
     .       2      intfact*xyr_intpf(t714-1,1,k) - intfact*cosza*xyz_dpfdoptdep
     .       3      (t714-1,1,k+1)*(1.00000000000000e+000 - xyz_transeachlayer( 
     .       4      t714-1,1,k+1))                                              
     .        enddo                                                             
   917            &   ( xyr_DwFlux(:,:,k+1) - IntFact * xyr_IntPF(:,:,k+1) ) &
   918            & * xyz_TransEachLayer(:,:,k+1)                            &
   919            & + IntFact * xyr_IntPF(:,:,k)                             &
   920            & - IntFact * CosZA * xyz_DPFDOptDep(:,:,k+1)              &
   921            &   * ( 1.0_DP - xyz_TransEachLayer(:,:,k+1) )
   922        end do
   923        !
   924        !   Upward flux
   925        !
   926        k = 0
   927        xyr_UwFlux(:,:,k) =                       &
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xyr_dwflux,xy_surfintpf,xy_surfalbedo,xyr_uwflux)          
     .        do t732 = 1, jmax*imax                                            
     .           xyr_uwflux(t732-1,1,0) = intfact*xy_surfintpf(t732-1,1) +      
     .       1      xy_surfalbedo(t732-1,1)*xyr_dwflux(t732-1,1,0)              
     .        enddo                                                             
   928          &   IntFact * xy_SurfIntPF              &
   929          & + xy_SurfAlbedo * xyr_DwFlux(:,:,0)
   930        do k = 1, kmax
   931          xyr_UwFlux(:,:,k) =                                          &
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xyz_transeachlayer,xyr_intpf,xyz_dpfdoptdep,xyr_uwflux)    
     .        do t744 = 1, xyr_uwflux.DSC.U2*xyr_uwflux.DSC.U1 +                
     .       1   xyr_uwflux.DSC.U2                                              
     .           xyr_uwflux(t744-1,1,k) = (xyr_uwflux(t744-1,1,k-1)-intfact*    
     .       1      xyr_intpf(t744-1,1,k-1))*xyz_transeachlayer(t744-1,1,k) +   
     .       2      intfact*xyr_intpf(t744-1,1,k) + intfact*cosza*xyz_dpfdoptdep
     .       3      (t744-1,1,k)*(1.00000000000000e+000 - xyz_transeachlayer(   
     .       4      t744-1,1,k))                                                
     .        enddo                                                             
   932            &   ( xyr_UwFlux(:,:,k-1) - IntFact * xyr_IntPF(:,:,k-1) ) &
   933            & * xyz_TransEachLayer(:,:,k)                              &
   934            & + IntFact * xyr_IntPF(:,:,k)                             &
   935            & + IntFact * CosZA * xyz_DPFDOptDep(:,:,k)                &
   936            &   * ( 1.0_DP - xyz_TransEachLayer(:,:,k) )
   937        end do
   938  
   939  
   940        ! 放射フラックスの変化率の計算
   941        ! Calculate rate of change of radiative flux
   942        !
   943        do k = 0, kmax
   944          xyra_DelUwFlux(:,:,k,0) = IntFact * xy_SurfIntDPFDT * xyr_Trans0(:,:,k)
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xyr_trans0,xy_surfintdpfdt,xyra_deluwflux)                 
     .        do t762 = 1, jmax*imax                                            
     .           xyra_deluwflux(t762-1,1,k,0) = intfact*xy_surfintdpfdt(t762-1,1
     .       1      )*xyr_trans0(t762-1,1,k)                                    
     .        enddo                                                             
   945        end do
   946        do k = 0, kmax
   947          xyra_DelDwFlux(:,:,k,0) = 0.0_DP
   948        end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xyra_deldwflux)                                            
     .        do k=1,(kmax+1)*xyra_deldwflux.DSC.U2*(xyra_deldwflux.DSC.U1+1)   
     .           xyra_deldwflux(k-1,1,0,0) = 0.0000000000000000e+000            
     .        enddo                                                             
   949        xyra_DelUwFlux(:,:,:,1) = 0.0_DP
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xyra_deluwflux,xyra_deldwflux)                             
     .        do t778 = 1, (xyra_deluwflux.DSC.U3 + 1)*xyra_deluwflux.DSC.U2*(  
     .       1   xyra_deluwflux.DSC.U1 + 1)                                     
     .           xyra_deluwflux(t778-1,1,0,1) = 0.0000000000000000e+000         
     .           xyra_deldwflux(t778-1,1,0,1) = 0.0000000000000000e+000         
     .        enddo                                                             
   950        xyra_DelDwFlux(:,:,:,1) = 0.0_DP
   951  
   952  
   953        ! Sum over zenith angle
   954        !
   955        if ( NumGaussNodeZAInt > 0 ) then
   956          GaussWeight = a_GaussWeight( n )
   957  
   958          xyr_RadLUwFlux = xyr_RadLUwFlux &
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xyr_dwflux,xyr_uwflux,xyr_radluwflux,xyr_radldwflux)       
     .        do t832 = 1, jmax*(kmax*imax + imax)                              
     .           xyr_radluwflux(t832-1,1,0) = xyr_radluwflux(t832-1,1,0) + (    
     .       1      cosza*gaussweight)*xyr_uwflux(t832-1,1,0)                   
     .           xyr_radldwflux(t832-1,1,0) = xyr_radldwflux(t832-1,1,0) + (    
     .       1      cosza*gaussweight)*xyr_dwflux(t832-1,1,0)                   
     .        enddo                                                             
   959            & + xyr_UwFlux * CosZA * GaussWeight
   960          xyr_RadLDwFlux = xyr_RadLDwFlux &
   961            & + xyr_DwFlux * CosZA * GaussWeight
   962  
   963          xyra_DelRadLUwFlux = xyra_DelRadLUwFlux &
     .  10179 continue                                                          
     .  !cdir nodep                                                             
     .  !cdir on_adb(xyra_deluwflux,xyra_deldwflux)                             
     .        do t862 = 1, 1 + imax - min0(1,imax)                              
     .           xyra_delradluwflux(t862-1,t873,t872,t871) = xyra_delradluwflux(
     .       1      t862-1,t869,t868,t867) + (cosza*gaussweight)*xyra_deluwflux(
     .       2      t862-1,t865,t864,t863)                                      
     .           xyra_delradldwflux(t862-1,t885,t884,t883) = xyra_delradldwflux(
     .       1      t862-1,t881,t880,t879) + (cosza*gaussweight)*xyra_deldwflux(
     .       2      t862-1,t877,t876,t875)                                      
     .        enddo                                                             
   964            & + xyra_DelUwFlux * CosZA * GaussWeight
   965          xyra_DelRadLDwFlux = xyra_DelRadLDwFlux &
   966            & + xyra_DelDwFlux * CosZA * GaussWeight
   967        else
   968          xyr_RadLUwFlux = xyr_UwFlux
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xyr_dwflux,xyr_uwflux,xyr_radluwflux)                      
     .        do t790 = 1, jmax*(kmax*imax + imax)                              
     .           xyr_radluwflux(t790-1,1,0) = xyr_uwflux(t790-1,1,0)            
     .           xyr_radldwflux(t790-1,1,0) = xyr_dwflux(t790-1,1,0)            
     .        enddo                                                             
   969          xyr_RadLDwFlux = xyr_DwFlux
   970  
   971          xyra_DelRadLUwFlux = xyra_DelUwFlux
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xyra_deluwflux,xyra_deldwflux)                             
     .        do t810 = 1, jmax*(kmax*imax + imax)                              
     .           xyra_delradluwflux(t810-1,1,0,0) = xyra_deluwflux(t810-1,1,0,0)
     .           xyra_delradldwflux(t810-1,1,0,0) = xyra_deldwflux(t810-1,1,0,0)
     .           xyra_delradluwflux(t810-1,1,0,1) = xyra_deluwflux(t810-1,1,0,1)
     .           xyra_delradldwflux(t810-1,1,0,1) = xyra_deldwflux(t810-1,1,0,1)
     .        enddo                                                             
   972          xyra_DelRadLDwFlux = xyra_DelDwFlux
   973        end if
   974  
   975      end do loop_gq
   976  
   977  
   978    end subroutine RadRTENonScatMonoSemiAnal
   979  
   980    !--------------------------------------------------------------------------------------
   981  
   982    subroutine RadRTENonScatWrapper(                    &
   983      & xyz_Temp, xy_SurfTemp, xy_SurfEmis, xyrr_Trans, & ! (in )
   984      & xyr_RadLUwFlux, xyr_RadLDwFlux,                 & ! (out)
   985      & xyra_DelRadLUwFlux, xyra_DelRadLDwFlux,         & ! (out)
   986      & WNs, WNe, NumGaussNode                          & ! (in ) optional
   987      & )
   988      !
   989      ! 散乱なしの場合の放射伝達方程式の計算
   990      !
   991      ! Integrate radiative transfer equation without scattering
   992      !
   993  
   994      ! モジュール引用 ; USE statements
   995      !
   996  
   997  
   998      ! プランク関数の計算
   999      ! Calculate Planck function
  1000      !
  1001      use planck_func, only :                            &
  1002        & Integ_PF_GQ_Array3D, Integ_PF_GQ_Array2D, Integ_DPFDT_GQ_Array2D
  1003  
  1004      ! 宣言文 ; Declaration statements
  1005      !
  1006  
  1007      real(DP), intent(in ) :: xyz_Temp    (0:imax-1, 1:jmax, 1:kmax)
  1008                                ! $ T $ .     温度. Temperature
  1009      real(DP), intent(in ) :: xy_SurfTemp (0:imax-1, 1:jmax)
  1010                                ! 地表面温度.
  1011                                ! Surface temperature
  1012      real(DP), intent(in ) :: xy_SurfEmis (0:imax-1, 1:jmax)
  1013                                ! 惑星表面射出率.
  1014                                ! Surface emissivity
  1015      real(DP), intent(in ) :: xyrr_Trans   (0:imax-1, 1:jmax, 0:kmax, 0:kmax)
  1016                                ! 透過係数.
  1017                                ! Transmission coefficient
  1018      real(DP), intent(out) :: xyr_RadLUwFlux (0:imax-1, 1:jmax, 0:kmax)
  1019                                ! 長波フラックス.
  1020                                ! Upward longwave flux
  1021      real(DP), intent(out) :: xyr_RadLDwFlux (0:imax-1, 1:jmax, 0:kmax)
  1022                                ! 長波フラックス.
  1023                                ! Downward longwave flux
  1024      real(DP), intent(out) :: xyra_DelRadLUwFlux (0:imax-1, 1:jmax, 0:kmax, 0:1)
  1025                                ! 長波地表温度変化.
  1026                                ! Upward longwave flux derivative
  1027      real(DP), intent(out) :: xyra_DelRadLDwFlux (0:imax-1, 1:jmax, 0:kmax, 0:1)
  1028                                ! 長波地表温度変化.
  1029                                ! Downward longwave flux derivative
  1030      real(DP), intent(in ), optional :: WNs
  1031      real(DP), intent(in ), optional :: WNe
  1032      integer , intent(in ), optional :: NumGaussNode
  1033  
  1034  
  1035      ! 作業変数
  1036      ! Work variables
  1037      !
  1038      real(DP):: xyz_IntPF        (0:imax-1, 1:jmax, 1:kmax)
  1039                                ! Integrated Planck function
  1040      real(DP):: xy_SurfIntPF     (0:imax-1, 1:jmax)
  1041                                ! Integrated Planck function with surface temperature
  1042      real(DP):: xy_IntDPFDT1     (0:imax-1, 1:jmax)
  1043                                ! Integrated temperature derivative of Planck function
  1044      real(DP):: xy_SurfIntDPFDT  (0:imax-1, 1:jmax)
  1045                                ! Integrated temperature derivative of Planck function
  1046                                ! with surface temperature
  1047  
  1048  
  1049      ! 実行文 ; Executable statement
  1050      !
  1051  
  1052      ! 初期化確認
  1053      ! Initialization check
  1054      !
  1055      if ( .not. rad_rte_nonscat_inited ) then
  1056        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
  1057      end if
  1058  
  1059  
  1060      ! Check arguments
  1061      !
  1062      if ( present( WNs ) .or. present( WNe ) .or. present( NumGaussNode ) ) then
  1063        if ( .not. ( present( WNs ) .and. present( WNe ) .and. present( NumGaussNode ) ) ) then
  1064          call MessageNotify( 'E', module_name, &
  1065            & 'All of WNs, WNe, and NumGaussNode have to be present.' )
  1066        end if
  1067      end if
  1068  
  1069  
  1070      if ( present( WNs ) ) then
  1071        ! Case for non-grey atmosphere
  1072        !
  1073  
  1074        ! Integrate Planck function and temperature derivative of it
  1075        !
  1076        call Integ_PF_GQ_Array3D( &
  1077          & WNs, WNe, NumGaussNode, &
  1078          & 0, imax-1, 1, jmax, 1, kmax, &
  1079          & xyz_Temp, &
  1080          & xyz_IntPF &
  1081          & )
  1082        call Integ_PF_GQ_Array2D( &
  1083          & WNs, WNe, NumGaussNode, &
  1084          & 0, imax-1, 1, jmax, &
  1085          & xy_SurfTemp, &
  1086          & xy_SurfIntPF &
  1087          & )
  1088        call Integ_DPFDT_GQ_Array2D(             &
  1089          & WNs, WNe, NumGaussNode,              & ! (in )
  1090          & 0, imax-1, 1, jmax, xyz_Temp(:,:,1), & ! (in )
  1091          & xy_IntDPFDT1                         & ! (out)
  1092          & )
  1093        call Integ_DPFDT_GQ_Array2D(         &
  1094          & WNs, WNe, NumGaussNode,          & ! (in )
  1095          & 0, imax-1, 1, jmax, xy_SurfTemp, & ! (in )
  1096          & xy_SurfIntDPFDT                  & ! (out)
  1097          & )
  1098  
  1099        xyz_IntPF       =               PI * xyz_IntPF
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t276 = 1, xyz_intpf.DSC.U3*(xyz_intpf.DSC.U2*xyz_intpf.DSC.U1  
     .       1    + xyz_intpf.DSC.U2)                                           
     .           xyz_intpf(t276-1,1,1) = 3.14159265358979e+000*xyz_intpf(t276-1,
     .       1      1,1)                                                        
     .        enddo                                                             
  1100        xy_SurfIntPF    = xy_SurfEmis * PI * xy_SurfIntPF
  1101        xy_IntDPFDT1    =               PI * xy_IntDPFDT1
  1102        xy_SurfIntDPFDT = xy_SurfEmis * PI * xy_SurfIntDPFDT
  1103  
  1104      else
  1105  
  1106        ! Case for grey atmosphere
  1107        !
  1108        xyz_IntPF       =                        StB * xyz_Temp**4
     .  !cdir    nodep                                                          
     .  !cdir noassume                                                          
     .        do t244 = 1, kmax*jmax*imax                                       
     .           xyz_intpf(t244-1,1,1) = 5.67037300000000e-008*xyz_temp(t244-1,1
     .       1      ,1)**4                                                      
     .        enddo                                                             
  1109        xy_SurfIntPF    = xy_SurfEmis          * StB * xy_SurfTemp**4
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t256 = 1, jmax*imax                                            
     .           xy_surfintpf(t256-1,1) = (xy_surfemis(t256-1,1)*               
     .       1      5.67037300000000e-008)*xy_surftemp(t256-1,1)**4             
     .           xy_intdpfdt1(t256-1,1) = 2.26814920000000e-007*xyz_temp(t256-1,
     .       1      1,1)**3                                                     
     .           xy_surfintdpfdt(t256-1,1) = (xy_surfemis(t256-1,1)*            
     .       1      5.67037300000000e-008)*4.00000000000000e+000*xy_surftemp(   
     .       2      t256-1,1)**3                                                
     .        enddo                                                             
  1110        xy_IntDPFDT1    =               4.0_DP * StB * xyz_Temp(:,:,1)**3
  1111        xy_SurfIntDPFDT = xy_SurfEmis * 4.0_DP * StB * xy_SurfTemp**3
  1112  
  1113      end if
  1114  
  1115  
  1116      call RadRTENonScat(                                         &
  1117        & xyz_IntPF, xy_SurfIntPF, xy_IntDPFDT1, xy_SurfIntDPFDT, & ! (in)
  1118        & xyrr_Trans,                                             & ! (in)
  1119        & xyr_RadLUwFlux, xyr_RadLDwFlux,                         & ! (out)
  1120        & xyra_DelRadLUwFlux, xyra_DelRadLDwFlux                  & ! (out)
  1121        & )
  1122  
  1123  
  1124    end subroutine RadRTENonScatWrapper
  1125  
  1126    !--------------------------------------------------------------------------------------
  1127  
  1128    subroutine RadRTENonScatInit
  1129      !
  1130      ! rad_rte_nonscat モジュールの初期化を行います.
  1131      ! NAMELIST#rad_rte_nonscat_nml の読み込みはこの手続きで行われます.
  1132      !
  1133      ! "rad_rte_nonscat" module is initialized.
  1134      ! "NAMELIST#rad_rte_nonscat_nml" is loaded in this procedure.
  1135      !
  1136  
  1137      ! モジュール引用 ; USE statements
  1138      !
  1139  
  1140      ! NAMELIST ファイル入力に関するユーティリティ
  1141      ! Utilities for NAMELIST file input
  1142      !
  1143      use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid
  1144  
  1145      ! ファイル入出力補助
  1146      ! File I/O support
  1147      !
  1148      use dc_iounit, only: FileOpen
  1149  
  1150      ! ヒストリデータ出力
  1151      ! History data output
  1152      !
  1153      use gtool_historyauto, only: HistoryAutoAddVariable
  1154  
  1155      ! 文字列操作
  1156      ! Character handling
  1157      !
  1158      use dc_string, only: toChar
  1159  
  1160      ! ガウス重み, 分点の計算
  1161      ! Calculate Gauss node and Gaussian weight
  1162      !
  1163      use gauss_quad, only : GauLeg
  1164  
  1165      ! 宣言文 ; Declaration statements
  1166      !
  1167  
  1168      integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号.
  1169                                ! Unit number for NAMELIST file open
  1170      integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT.
  1171                                ! IOSTAT of NAMELIST read
  1172  
  1173  
  1174      ! NAMELIST 変数群
  1175      ! NAMELIST group name
  1176      !
  1177      namelist /rad_rte_nonscat_nml/ &
  1178        & DiffFact,                  &
  1179        & NumGaussNodeZAInt
  1180            !
  1181            ! デフォルト値については初期化手続 "rad_rte_nonscat#RadRTENonScatInit"
  1182            ! のソースコードを参照のこと.
  1183            !
  1184            ! Refer to source codes in the initialization procedure
  1185            ! "rad_rte_nonscat#RadRTENonScatInit" for the default values.
  1186            !
  1187  
  1188      ! 実行文 ; Executable statement
  1189      !
  1190  
  1191      if ( rad_rte_nonscat_inited ) return
  1192  
  1193  
  1194      ! デフォルト値の設定
  1195      ! Default values settings
  1196      !
  1197      NumGaussNodeZAInt = 3
  1198      DiffFact          = 1.66_DP
  1199  
  1200  
  1201      ! NAMELIST の読み込み
  1202      ! NAMELIST is input
  1203      !
  1204      if ( trim(namelist_filename) /= '' ) then
  1205        call FileOpen( unit_nml, &          ! (out)
  1206          & namelist_filename, mode = 'r' ) ! (in)
  1207  
  1208        rewind( unit_nml )
  1209        read( unit_nml,                     & ! (in)
  1210          & nml = rad_rte_nonscat_nml,      & ! (out)
  1211          & iostat = iostat_nml )             ! (out)
  1212        close( unit_nml )
  1213  
  1214        call NmlutilMsg( iostat_nml, module_name ) ! (in)
  1215      end if
  1216  
  1217  
  1218      if ( NumGaussNodeZAInt > 0 ) then
  1219        allocate( a_CosZA      ( NumGaussNodeZAInt ) )
  1220        allocate( a_GaussWeight( NumGaussNodeZAInt ) )
  1221        call GauLeg( 0.0_DP, 1.0_DP, NumGaussNodeZAInt, a_CosZA, a_GaussWeight )
  1222      end if
  1223  
  1224  
  1225      ! 印字 ; Print
  1226      !
  1227      call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
  1228      call MessageNotify( 'M', module_name, 'NumGaussNodeZAInt = %d', i = (/ NumGaussNodeZAInt /) )
  1229      call MessageNotify( 'M', module_name, 'DiffFact          = %f', d = (/ DiffFact /) )
  1230      call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
  1231  
  1232      rad_rte_nonscat_inited = .true.
  1233  
  1234    end subroutine RadRTENonScatInit
  1235  
  1236    !-------------------------------------------------------------------
  1237  
  1238  end module rad_rte_nonscat
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:47 2016
FILE NAME: rad_rte_nonscat.f90
PROGRAM NAME: rad_rte_nonscat
FORMAT LIST

  LINE    LOOP      FORTRAN STATEMENT

     1:             != 散乱を無視した放射伝達方程式
     2:             !
     3:             != Radiative transfer equation without considering scattering
     4:             !
     5:             ! Authors::   Yoshiyuki O. TAKAHASHI
     6:             ! Version::   $Id: rad_rte_nonscat.f90,v 1.6 2014/06/29 07:48:29 yot Exp $ 
     7:             ! Tag Name::  $Name:  $
     8:             ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9:             ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10:             !
    11:             
    12:             module rad_rte_nonscat
    13:               !
    14:               != 散乱を無視した放射伝達方程式
    15:               !
    16:               != Radiative transfer equation without considering scattering
    17:               !
    18:               ! <b>Note that Japanese and English are described in parallel.</b>
    19:               !
    20:               ! 
    21:               !
    22:               ! 
    23:               !
    24:               !== Procedures List
    25:               !
    26:             !!$  ! RadDTempDt        :: 放射フラックスによる温度変化の計算
    27:             !!$  ! RadFluxOutput     :: 放射フラックスの出力
    28:             !!$  ! ------------            :: ------------
    29:             !!$  ! RadDTempDt        :: Calculate temperature tendency with radiation flux
    30:             !!$  ! RadFluxOutput     :: Output radiation fluxes
    31:               !
    32:               !== NAMELIST
    33:               !
    34:               ! NAMELIST#rad_rte_nonscat_nml
    35:               !
    36:             
    37:               ! モジュール引用 ; USE statements
    38:               !
    39:             
    40:               ! 種別型パラメタ
    41:               ! Kind type parameter
    42:               !
    43:               use dc_types, only: DP, &      ! 倍精度実数型. Double precision. 
    44:                 &                 STRING, &  ! 文字列.       Strings. 
    45:                 &                 TOKEN      ! キーワード.   Keywords. 
    46:             
    47:               ! 物理・数学定数設定
    48:               ! Physical and mathematical constants settings
    49:               !
    50:               use constants0, only: &
    51:                 & PI, &
    52:                                         ! $ \pi $ .
    53:                                         ! 円周率.  Circular constant
    54:                 & StB
    55:                                         ! $ \sigma_{SB} $ .
    56:                                         ! ステファンボルツマン定数.
    57:                                         ! Stefan-Boltzmann constant
    58:             
    59:               ! 物理定数設定
    60:               ! Physical constants settings
    61:               !
    62:               use constants, only: &
    63:                 & Grav, &
    64:                                         ! $ g $ [m s-2]. 
    65:                                         ! 重力加速度. 
    66:                                         ! Gravitational acceleration
    67:                 & CpDry
    68:                                         ! $ C_p $ [J kg-1 K-1]. 
    69:                                         ! 乾燥大気の定圧比熱. 
    70:                                         ! Specific heat of air at constant pressure
    71:             
    72:             
    73:               ! 格子点設定
    74:               ! Grid points settings
    75:               !
    76:               use gridset, only: imax, & ! 経度格子点数. 
    77:                                          ! Number of grid points in longitude
    78:                 &                jmax, & ! 緯度格子点数. 
    79:                                          ! Number of grid points in latitude
    80:                 &                kmax    ! 鉛直層数. 
    81:                                          ! Number of vertical level
    82:             
    83:               ! メッセージ出力
    84:               ! Message output
    85:               !
    86:               use dc_message, only: MessageNotify
    87:             
    88:               ! 宣言文 ; Declaration statements
    89:               !
    90:               implicit none
    91:               private
    92:             
    93:               ! 公開手続き
    94:               ! Public procedure
    95:               !
    96:               public :: RadRTENonScat
    97:             !!$  public :: RadRTENonScatAnotherForm
    98:             !!$  public :: RadRTENonScatMonoWithDiffFact
    99:               public :: RadRTENonScatMonoSemiAnal
   100:               public :: RadRTENonScatWrapper
   101:               public :: RadRTENonScatInit
   102:             
   103:             
   104:               ! 公開変数
   105:               ! Public variables
   106:               !
   107:               logical, save, public:: rad_rte_nonscat_inited = .false.
   108:                                           ! 初期設定フラグ. 
   109:                                           ! Initialization flag
   110:             
   111:             
   112:               ! 非公開変数
   113:               ! Private variables
   114:               !
   115:               integer , save              :: NumGaussNodeZAInt
   116:               real(DP), save              :: DiffFact
   117:               real(DP), save, allocatable :: a_CosZA( : )
   118:               real(DP), save, allocatable :: a_GaussWeight( : )
   119:             
   120:             
   121:               character(*), parameter:: module_name = 'rad_rte_nonscat'
   122:                                           ! モジュールの名称. 
   123:                                           ! Module name
   124:               character(*), parameter:: version = &
   125:                 & '$Name:  $' // &
   126:                 & '$Id: rad_rte_nonscat.f90,v 1.6 2014/06/29 07:48:29 yot Exp $'
   127:                                           ! モジュールのバージョン
   128:                                           ! Module version
   129:             
   130:             contains
   131:             
   132:               !--------------------------------------------------------------------------------------
   133:             
   134:               subroutine RadRTENonScat(                                    &
   135:                 & xyz_IntPF, xy_SurfIntPF, xy_IntDPFDT1, xy_SurfIntDPFDT,  & ! (in)
   136:                 & xyrr_Trans,                                              & ! (in)
   137:                 & xyr_RadLUwFlux, xyr_RadLDwFlux,                          & ! (out)
   138:                 & xyra_DelRadLUwFlux, xyra_DelRadLDwFlux                   & ! (out)
   139:                 & )
   140:                 !
   141:                 ! 散乱なしの場合の放射伝達方程式の計算
   142:                 !
   143:                 ! Integrate radiative transfer equation without scattering
   144:                 !
   145:             
   146:                 ! モジュール引用 ; USE statements
   147:                 !
   148:             
   149:                 ! OpenMP
   150:                 !
   151:                 !$ use omp_lib
   152:             
   153:             
   154:                 ! 宣言文 ; Declaration statements
   155:                 !
   156:             
   157:                 real(DP), intent(in ) :: xyz_IntPF        (0:imax-1, 1:jmax, 1:kmax)
   158:                                           ! Integrated Planck function
   159:                 real(DP), intent(in ) :: xy_SurfIntPF     (0:imax-1, 1:jmax)
   160:                                           ! Integrated Planck function with surface temperature
   161:                 real(DP), intent(in ) :: xy_IntDPFDT1     (0:imax-1, 1:jmax)
   162:                                           ! Integrated temperature derivative of Planck function
   163:                 real(DP), intent(in ) :: xy_SurfIntDPFDT  (0:imax-1, 1:jmax)
   164:                                           ! Integrated temperature derivative of Planck function
   165:                                           ! with surface temperature
   166:                 real(DP), intent(in ) :: xyrr_Trans   (0:imax-1, 1:jmax, 0:kmax, 0:kmax)
   167:                                           ! 透過係数. 
   168:                                           ! Transmission coefficient
   169:                 real(DP), intent(out) :: xyr_RadLUwFlux (0:imax-1, 1:jmax, 0:kmax)
   170:                                           ! 長波フラックス. 
   171:                                           ! Upward longwave flux
   172:                 real(DP), intent(out) :: xyr_RadLDwFlux (0:imax-1, 1:jmax, 0:kmax)
   173:                                           ! 長波フラックス. 
   174:                                           ! Downward longwave flux
   175:                 real(DP), intent(out) :: xyra_DelRadLUwFlux (0:imax-1, 1:jmax, 0:kmax, 0:1)
   176:                                           ! 長波地表温度変化. 
   177:                                           ! Upward longwave flux derivative
   178:                 real(DP), intent(out) :: xyra_DelRadLDwFlux (0:imax-1, 1:jmax, 0:kmax, 0:1)
   179:                                           ! 長波地表温度変化. 
   180:                                           ! Downward longwave flux derivative
   181:             
   182:             
   183:                 ! 作業変数
   184:                 ! Work variables
   185:                 !
   186:                 integer :: js
   187:                 integer :: je
   188:             
   189:                 integer :: nthreads
   190:                 integer, allocatable :: a_js(:)
   191:                 integer, allocatable :: a_je(:)
   192:             
   193:                 integer :: n
   194:             
   195:             
   196:                 ! 実行文 ; Executable statement
   197:                 !
   198:             
   199:                 ! 初期化確認
   200:                 ! Initialization check
   201:                 !
   202:                 if ( .not. rad_rte_nonscat_inited ) then
   203:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   204:                 end if
   205:             
   206:             
   207:                 nthreads = 1
   208:                 !$ nthreads  = omp_get_max_threads()
   209:             !!$    !$ write( 6, * ) "Number of processors : ", omp_get_num_procs()
   210:             !!$    !$ write( 6, * ) "Number of threads    : ", nthreads
   211:             
   212:                 allocate( a_js(0:nthreads-1) )
   213:                 allocate( a_je(0:nthreads-1) )
   214:             
   215: *------>        do n = 0, nthreads-1
   216: |           
   217: |                 if ( n == 0 ) then
   218: |                   a_js(n) = 1
   219: |                 else
   220: |                   a_js(n) = a_je(n-1) + 1
   221: |                 end if
   222: |           
   223: |                 a_je(n) = a_js(n  ) + jmax / nthreads - 1
   224: |                 if ( n + 1 <= mod( jmax, nthreads ) ) then
   225: |                   a_je(n) = a_je(n) + 1
   226: |                 end if
   227: |           
   228: *------         end do
   229:             
   230:                 !$OMP PARALLEL DEFAULT(PRIVATE) &
   231:                 !$OMP SHARED( &
   232:                 !$OMP         nthreads, a_js, a_je, &
   233:                 !$OMP         xyz_IntPF, xy_SurfIntPF, xy_IntDPFDT1, xy_SurfIntDPFDT,  &
   234:                 !$OMP         xyrr_Trans, &
   235:                 !$OMP         xyr_RadLUwFlux, xyr_RadLDwFlux,                          &
   236:                 !$OMP         xyra_DelRadLUwFlux, xyra_DelRadLDwFlux                   &
   237:                 !$OMP       )
   238:             
   239:                 !$OMP DO
   240:             
   241: *------>        do n = 0, nthreads-1
   242: |           
   243: |                 js = a_js(n)
   244: |                 je = a_je(n)
   245: |           
   246: |                 if ( js > je ) cycle
   247: |           
   248: |                 call RadRTENonScatCore(                                &
   249: |                   & js, je,                                                  & ! (in)
   250: |                   & xyz_IntPF, xy_SurfIntPF, xy_IntDPFDT1, xy_SurfIntDPFDT,  & ! (in)
   251: |                   & xyrr_Trans,                                              & ! (in)
   252: |                   & xyr_RadLUwFlux, xyr_RadLDwFlux,                          & ! (out)
   253: |                   & xyra_DelRadLUwFlux, xyra_DelRadLDwFlux                   & ! (out)
   254: |                   & )
   255: |           
   256: *------         end do
   257:             
   258:             
   259:                 !$OMP END DO
   260:                 !$OMP END PARALLEL
   261:             
   262:             
   263:                 deallocate( a_js )
   264:                 deallocate( a_je )
   265:             
   266:             
   267:               end subroutine RadRTENonScat
   268:             
   269:               !--------------------------------------------------------------------------------------
   270:             
   271:               subroutine RadRTENonScatCore(                                &
   272:                 & js, je,                                                  & ! (in)
   273:                 & xyz_IntPF, xy_SurfIntPF, xy_IntDPFDT1, xy_SurfIntDPFDT,  & ! (in)
   274:                 & xyrr_Trans,                                              & ! (in)
   275:                 & xyr_RadLUwFlux, xyr_RadLDwFlux,                          & ! (out)
   276:                 & xyra_DelRadLUwFlux, xyra_DelRadLDwFlux                   & ! (out)
   277:                 & )
   278:                 !
   279:                 ! 散乱なしの場合の放射伝達方程式の計算
   280:                 !
   281:                 ! Integrate radiative transfer equation without scattering
   282:                 !
   283:             
   284:                 ! モジュール引用 ; USE statements
   285:                 !
   286:             
   287:             
   288:                 ! 宣言文 ; Declaration statements
   289:                 !
   290:             
   291:                 integer , intent(in ) :: js
   292:                 integer , intent(in ) :: je
   293:                 real(DP), intent(in ) :: xyz_IntPF        (0:imax-1, 1:jmax, 1:kmax)
   294:                                           ! Integrated Planck function
   295:                 real(DP), intent(in ) :: xy_SurfIntPF     (0:imax-1, 1:jmax)
   296:                                           ! Integrated Planck function with surface temperature
   297:                 real(DP), intent(in ) :: xy_IntDPFDT1     (0:imax-1, 1:jmax)
   298:                                           ! Integrated temperature derivative of Planck function
   299:                 real(DP), intent(in ) :: xy_SurfIntDPFDT  (0:imax-1, 1:jmax)
   300:                                           ! Integrated temperature derivative of Planck function
   301:                                           ! with surface temperature
   302:                 real(DP), intent(in ) :: xyrr_Trans   (0:imax-1, 1:jmax, 0:kmax, 0:kmax)
   303:                                           ! 透過係数. 
   304:                                           ! Transmission coefficient
   305:                 real(DP), intent(out) :: xyr_RadLUwFlux (0:imax-1, 1:jmax, 0:kmax)
   306:                                           ! 長波フラックス. 
   307:                                           ! Upward longwave flux
   308:                 real(DP), intent(out) :: xyr_RadLDwFlux (0:imax-1, 1:jmax, 0:kmax)
   309:                                           ! 長波フラックス. 
   310:                                           ! Downward longwave flux
   311:                 real(DP), intent(out) :: xyra_DelRadLUwFlux (0:imax-1, 1:jmax, 0:kmax, 0:1)
   312:                                           ! 長波地表温度変化. 
   313:                                           ! Upward longwave flux derivative
   314:                 real(DP), intent(out) :: xyra_DelRadLDwFlux (0:imax-1, 1:jmax, 0:kmax, 0:1)
   315:                                           ! 長波地表温度変化. 
   316:                                           ! Downward longwave flux derivative
   317:             
   318:             
   319:                 ! 作業変数
   320:                 ! Work variables
   321:                 !
   322:                 integer:: j
   323:                 integer:: k, kk           ! 鉛直方向に回る DO ループ用作業変数
   324:                                           ! Work variables for DO loop in vertical direction
   325:             
   326:                 ! 実行文 ; Executable statement
   327:                 !
   328:             
   329:                 ! 初期化確認
   330:                 ! Initialization check
   331:                 !
   332:                 if ( .not. rad_rte_nonscat_inited ) then
   333:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   334:                 end if
   335:             
   336:             
   337:             
   338:                 ! 放射フラックス計算
   339:                 ! Calculate radiation flux
   340:                 !
   341:             
   342:                 !   Initialization
   343:                 !
   344: +------>        do k = 0, kmax
   345: |W----->          do j = js, je
   346: ||*---->A           xyr_RadLDwFlux(:,j,k) = 0.0_DP
   347: ||*---- A           xyr_RadLUwFlux(:,j,k) = 0.0_DP
   348: |W-----           end do
   349: +------         end do
   350:                 !
   351:                 !   Downward flux
   352:                 !
   353: +------>        do k = kmax, 0, -1
   354: |           
   355: |+----->          do kk = kmax, k+1, -1
   356: ||W---->            do j = js, je
   357: |||*=== A             xyr_RadLDwFlux(:,j,k) = xyr_RadLDwFlux(:,j,k)          &
   358: |||                     & + xyz_IntPF(:,j,kk)                                &
   359: |||                     & * ( xyrr_Trans(:,j,k,kk-1) - xyrr_Trans(:,j,k,kk) )
   360: ||W----             end do
   361: |+-----           end do
   362: |           
   363: +------         end do
   364:                 !
   365:                 !   Upward flux
   366:                 !
   367:                 !     Set upward flux
   368:                 !
   369: +------>        do k = 0, kmax
   370: |+----->          do j = js, je
   371: ||          
   372: ||V==== A           xyr_RadLUwFlux(:,j,k) = xy_SurfIntPF(:,j) * xyrr_Trans(:,j,k,0)
   373: ||          
   374: ||+---->            do kk = 1, k
   375: |||V=== A             xyr_RadLUwFlux(:,j,k) = xyr_RadLUwFlux(:,j,k)          &
   376: |||                     & - xyz_IntPF(:,j,kk)                                &
   377: |||                     & * ( xyrr_Trans(:,j,k,kk-1) - xyrr_Trans(:,j,k,kk) )
   378: ||+----             end do
   379: ||          
   380: |+-----           end do
   381: +------         end do
   382:             
   383:             
   384:                 ! 放射フラックスの変化率の計算
   385:                 ! Calculate rate of change of radiative flux
   386:                 !
   387: +------>        do k = 0, kmax
   388: |W----->          do j = js, je
   389: ||*==== A           xyra_DelRadLUwFlux(:,j,k,0) =                         &
   390: ||                    & xy_SurfIntDPFDT(:,j) * xyrr_Trans(:,j,k,0)
   391: |W-----           end do
   392: +------         end do
   393:                 k = 0
   394: W------>        do j = js, je
   395: |*===== A         xyra_DelRadLUwFlux(:,j,k,1) = 0.0_DP
   396: W------         end do
   397: +------>        do k = 1, kmax
   398: |W----->          do j = js, je
   399: ||*==== A           xyra_DelRadLUwFlux(:,j,k,1) =                         &
   400: ||                    & - xy_IntDPFDT1(:,j)                               &
   401: ||                    &   * ( xyrr_Trans(:,j,k,0) - xyrr_Trans(:,j,k,1) )
   402: |W-----           end do
   403: +------         end do
   404: +------>        do k = 0, kmax
   405: |W----->          do j = js, je
   406: ||*==== A           xyra_DelRadLDwFlux(:,j,k,0) = 0.0_DP
   407: |W-----           end do
   408: +------         end do
   409:                 k = 0
   410: W------>        do j = js, je
   411: |*===== A         xyra_DelRadLDwFlux(:,j,k,1) =                         &
   412: |                   & + xy_IntDPFDT1(:,j)                               &
   413: |                   &   * ( xyrr_Trans(:,j,k,0) - xyrr_Trans(:,j,k,1) )
   414: W------         end do
   415: +------>        do k = 1, kmax
   416: |W----->          do j = js, je
   417: ||*==== A           xyra_DelRadLDwFlux(:,j,k,1) = 0.0_DP
   418: |W-----           end do
   419: +------         end do
   420:             
   421:             
   422:               end subroutine RadRTENonScatCore
   423:             
   424:               !--------------------------------------------------------------------------------------
   425:               ! This is a test version, and now (2014/06/29), this is not used because of 
   426:               ! not good performance. So, this will be deleted in future, probably. 
   427:               ! This routine calculates radiative flux by solving a radiative transfer 
   428:               ! equation without including scattering. 
   429:               ! The difference between this routine and RadRTENonScat is that this 
   430:               ! routine solves a radiative transfer equation of a form integrated by parts.
   431:             
   432:               subroutine RadRTENonScatAnotherForm(                         &
   433:                 & xyz_IntPF, xy_SurfIntPF, xy_IntDPFDT1, xy_SurfIntDPFDT,  & ! (in)
   434:                 & xyrr_Trans,                                              & ! (in)
   435:                 & xyr_RadLUwFlux, xyr_RadLDwFlux,                          & ! (out)
   436:                 & xyra_DelRadLUwFlux, xyra_DelRadLDwFlux                   & ! (out)
   437:                 & )
   438:                 !
   439:                 ! 散乱なしの場合の放射伝達方程式の計算
   440:                 !
   441:                 ! Integrate radiative transfer equation without scattering
   442:                 !
   443:             
   444:                 ! モジュール引用 ; USE statements
   445:                 !
   446:             
   447:             
   448:                 ! 宣言文 ; Declaration statements
   449:                 !
   450:             
   451:                 real(DP), intent(in ) :: xyz_IntPF        (0:imax-1, 1:jmax, 1:kmax)
   452:                                           ! Integrated Planck function
   453:                 real(DP), intent(in ) :: xy_SurfIntPF     (0:imax-1, 1:jmax)
   454:                                           ! Integrated Planck function with surface temperature
   455:                 real(DP), intent(in ) :: xy_IntDPFDT1     (0:imax-1, 1:jmax)
   456:                                           ! Integrated temperature derivative of Planck function
   457:                 real(DP), intent(in ) :: xy_SurfIntDPFDT  (0:imax-1, 1:jmax)
   458:                                           ! Integrated temperature derivative of Planck function
   459:                                           ! with surface temperature
   460:                 real(DP), intent(in ) :: xyrr_Trans   (0:imax-1, 1:jmax, 0:kmax, 0:kmax)
   461:                                           ! 透過係数. 
   462:                                           ! Transmission coefficient
   463:                 real(DP), intent(out) :: xyr_RadLUwFlux (0:imax-1, 1:jmax, 0:kmax)
   464:                                           ! 長波フラックス. 
   465:                                           ! Upward longwave flux
   466:                 real(DP), intent(out) :: xyr_RadLDwFlux (0:imax-1, 1:jmax, 0:kmax)
   467:                                           ! 長波フラックス. 
   468:                                           ! Downward longwave flux
   469:                 real(DP), intent(out) :: xyra_DelRadLUwFlux (0:imax-1, 1:jmax, 0:kmax, 0:1)
   470:                                           ! 長波地表温度変化. 
   471:                                           ! Upward longwave flux derivative
   472:                 real(DP), intent(out) :: xyra_DelRadLDwFlux (0:imax-1, 1:jmax, 0:kmax, 0:1)
   473:                                           ! 長波地表温度変化. 
   474:                                           ! Downward longwave flux derivative
   475:             
   476:             
   477:                 ! 作業変数
   478:                 ! Work variables
   479:                 !
   480:                 real(DP) :: xyr_IntPF(0:imax-1, 1:jmax, 0:kmax)
   481:             
   482:                 integer:: k, kk           ! 鉛直方向に回る DO ループ用作業変数
   483:                                           ! Work variables for DO loop in vertical direction
   484:             
   485:                 ! 実行文 ; Executable statement
   486:                 !
   487:             
   488:                 ! 初期化確認
   489:                 ! Initialization check
   490:                 !
   491:                 if ( .not. rad_rte_nonscat_inited ) then
   492:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   493:                 end if
   494:             
   495:             
   496:             
   497:                 ! 
   498:                 ! Calculate integrated Planck function at layer interface
   499:                 !
   500: W*===== A       xyr_IntPF(:,:,0   ) = xyz_IntPF(:,:,1   )
   501: W------>        do k = 1, kmax-1
   502: |**==== A         xyr_IntPF(:,:,k) = ( xyz_IntPF(:,:,k) + xyz_IntPF(:,:,k+1) ) / 2.0_DP
   503: W------         end do
   504: W*===== A       xyr_IntPF(:,:,kmax) = xyz_IntPF(:,:,kmax)
   505:             
   506:             
   507:                 ! 放射フラックス計算
   508:                 ! Calculate radiation flux
   509:                 !
   510:             
   511:                 !   Initialization
   512:                 !
   513: **W---->A       xyr_RadLDwFlux = 0.0_DP
   514: **W---- A       xyr_RadLUwFlux = 0.0_DP
   515:                 !
   516:                 !   Downward flux
   517:                 !
   518: +------>        do k = kmax, 0, -1
   519: |           
   520: |W*==== A         xyr_RadLDwFlux(:,:,k) =   &
   521: |                   &   xyr_IntPF(:,:,k   ) &
   522: |                   & - xyr_IntPF(:,:,kmax) * xyrr_Trans(:,:,k,kmax)
   523: |                 !
   524: |+----->          do kk = kmax, k+1, -1
   525: ||W*=== A           xyr_RadLDwFlux(:,:,k) = xyr_RadLDwFlux(:,:,k)                    &
   526: ||                    & - ( xyrr_Trans(:,:,k,kk-1) + xyrr_Trans(:,:,k,kk) ) / 2.0_DP &
   527: ||                    &   * ( xyr_IntPF(:,:,kk-1) - xyr_IntPF(:,:,kk) )
   528: |+-----           end do
   529: |           
   530: +------         end do
   531:                 !
   532:                 !   Upward flux
   533:                 !
   534:                 !     Set upward flux
   535:                 !
   536: +------>        do k = 0, kmax
   537: |           
   538: |W*==== A         xyr_RadLUwFlux(:,:,k) =                                         &
   539: |                   &   ( xy_SurfIntPF - xyr_IntPF(:,:,0) ) * xyrr_Trans(:,:,k,0) &
   540: |                   & + xyr_IntPF(:,:,k)
   541: |                 !
   542: |+----->          do kk = 1, k
   543: ||W*=== A           xyr_RadLUwFlux(:,:,k) = xyr_RadLUwFlux(:,:,k)                    &
   544: ||                    & + ( xyrr_Trans(:,:,k,kk-1) + xyrr_Trans(:,:,k,kk) ) / 2.0_DP &
   545: ||                    &   * ( xyr_IntPF(:,:,kk-1) - xyr_IntPF(:,:,kk) )
   546: |+-----           end do
   547: |           
   548: +------         end do
   549:             
   550:             
   551:                 ! 放射フラックスの変化率の計算
   552:                 ! Calculate rate of change of radiative flux
   553:                 !
   554: +------>        do k = 0, kmax
   555: |W*==== A         xyra_DelRadLUwFlux(:,:,k,0) =                         &
   556: |                   & xy_SurfIntDPFDT * xyrr_Trans(:,:,k,0)
   557: +------         end do
   558:                 k = 0
   559: W*===== A       xyra_DelRadLUwFlux(:,:,k,1) = 0.0_DP
   560:                 k = 1
   561: W*===== A       xyra_DelRadLUwFlux(:,:,k,1) =                         &
   562:                   &   xy_IntDPFDT1                                    &
   563:                   &   * ( - xyrr_Trans(:,:,k,0) + 1.0_DP / 2.0_DP     &
   564:                   &       + ( xyrr_Trans(:,:,k,0) + xyrr_Trans(:,:,k,1) ) / 2.0_DP / 2.0_DP )
   565: +------>        do k = 2, kmax
   566: |W*==== A         xyra_DelRadLUwFlux(:,:,k,1) =                         &
   567: |                   &   xy_IntDPFDT1                                    &
   568: |                   &   * ( - xyrr_Trans(:,:,k,0)                       &
   569: |                   &       + ( xyrr_Trans(:,:,k,0) + xyrr_Trans(:,:,k,1) ) / 2.0_DP / 2.0_DP &
   570: |                   &       + ( xyrr_Trans(:,:,k,1) + xyrr_Trans(:,:,k,2) ) / 2.0_DP / 2.0_DP )
   571: +------         end do
   572: W------>        do k = 0, kmax
   573: |**==== A         xyra_DelRadLDwFlux(:,:,k,0) = 0.0_DP
   574: W------         end do
   575:                 if ( kmax <= 1 ) then
   576:                   k = 0
   577: W*===== A         xyra_DelRadLDwFlux(:,:,k,1) =                         &
   578:                     & + xy_IntDPFDT1                                    &
   579:                     &   * (   1.0_DP - xyrr_Trans(:,:,k,k+1) )
   580:                   k = 1
   581: +V===== A         xyra_DelRadLDwFlux(:,:,k,1) = 0.0_DP
   582:                 else
   583:                   k = 0
   584: W*===== A         xyra_DelRadLDwFlux(:,:,k,1) =                         &
   585:                     & + xy_IntDPFDT1                                    &
   586:                     &   * (   1.0_DP                                      &
   587:                     &       - ( xyrr_Trans(:,:,k,k  ) + xyrr_Trans(:,:,k,k+1) ) / 2.0_DP / 2.0_DP &
   588:                     &       - ( xyrr_Trans(:,:,k,k+1) + xyrr_Trans(:,:,k,k+2) ) / 2.0_DP / 2.0_DP )
   589:                   k = 1
   590: W*===== A         xyra_DelRadLDwFlux(:,:,k,1) =                         &
   591:                     & + xy_IntDPFDT1                                    &
   592:                     &   * (   1.0_DP / 2.0_DP                           &
   593:                     &       - ( xyrr_Trans(:,:,k,k  ) + xyrr_Trans(:,:,k,k+1) ) / 2.0_DP / 2.0_DP )
   594:                 end if
   595: W------>        do k = 2, kmax
   596: |**==== A         xyra_DelRadLDwFlux(:,:,k,1) = 0.0_DP
   597: W------         end do
   598:             
   599:             
   600:               end subroutine RadRTENonScatAnotherForm
   601:             
   602:               !--------------------------------------------------------------------------------------
   603:               ! This calculation method may not be good. Numerical integration over zenith 
   604:               ! angle should be performed.
   605:               subroutine RadRTENonScatMonoWithDiffFact(                    &
   606:                 & DiffFact,                                                & ! (in)
   607:                 & xyz_IntPF, xy_SurfIntPF, xy_IntDPFDT1, xy_SurfIntDPFDT,  & ! (in)
   608:                 & xyz_OptDep,                                              & ! (in)
   609:                 & xyr_RadLUwFlux, xyr_RadLDwFlux,                          & ! (out)
   610:                 & xyra_DelRadLUwFlux, xyra_DelRadLDwFlux                   & ! (out)
   611:                 & )
   612:                 !
   613:                 ! 散乱なしの場合の放射伝達方程式の計算
   614:                 !
   615:                 ! Integrate radiative transfer equation without scattering
   616:                 !
   617:             
   618:                 ! モジュール引用 ; USE statements
   619:                 !
   620:             
   621:             
   622:                 ! 宣言文 ; Declaration statements
   623:                 !
   624:             
   625:                 real(DP), intent(in ) :: DiffFact
   626:                                           ! Diffusivity factor
   627:                 real(DP), intent(in ) :: xyz_IntPF        (0:imax-1, 1:jmax, 1:kmax)
   628:                                           ! Integrated Planck function
   629:                 real(DP), intent(in ) :: xy_SurfIntPF     (0:imax-1, 1:jmax)
   630:                                           ! Integrated Planck function with surface temperature
   631:                 real(DP), intent(in ) :: xy_IntDPFDT1     (0:imax-1, 1:jmax)
   632:                                           ! Integrated temperature derivative of Planck function
   633:                 real(DP), intent(in ) :: xy_SurfIntDPFDT  (0:imax-1, 1:jmax)
   634:                                           ! Integrated temperature derivative of Planck function
   635:                                           ! with surface temperature
   636:                 real(DP), intent(in ) :: xyz_OptDep   (0:imax-1, 1:jmax, 1:kmax)
   637:                                           ! 光学的厚さ. 
   638:                                           ! Optical depth
   639:                 real(DP), intent(out) :: xyr_RadLUwFlux (0:imax-1, 1:jmax, 0:kmax)
   640:                                           ! 長波フラックス. 
   641:                                           ! Upward longwave flux
   642:                 real(DP), intent(out) :: xyr_RadLDwFlux (0:imax-1, 1:jmax, 0:kmax)
   643:                                           ! 長波フラックス. 
   644:                                           ! Downward longwave flux
   645:                 real(DP), intent(out) :: xyra_DelRadLUwFlux (0:imax-1, 1:jmax, 0:kmax, 0:1)
   646:                                           ! 長波地表温度変化. 
   647:                                           ! Upward longwave flux derivative
   648:                 real(DP), intent(out) :: xyra_DelRadLDwFlux (0:imax-1, 1:jmax, 0:kmax, 0:1)
   649:                                           ! 長波地表温度変化. 
   650:                                           ! Downward longwave flux derivative
   651:             
   652:             
   653:                 ! 作業変数
   654:                 ! Work variables
   655:                 !
   656:                 real(DP) :: xyz_TransEachLayer(0:imax-1, 1:jmax, 1:kmax)
   657:                                           ! 透過係数. 
   658:                                           ! Transmission coefficient
   659:                 real(DP) :: xyr_Trans0(0:imax-1, 1:jmax, 0:kmax)
   660:                                           ! 
   661:                                           ! Transmission coefficient from surface to layer interfaces
   662:                 real(DP) :: xyr_Trans1(0:imax-1, 1:jmax, 0:kmax)
   663:                                           ! 
   664:                                           ! Transmission coefficient from top of the lowest layer to layer interfaces
   665:             
   666:                 integer:: k               ! 鉛直方向に回る DO ループ用作業変数
   667:                                           ! Work variables for DO loop in vertical direction
   668:             
   669:                 ! 実行文 ; Executable statement
   670:                 !
   671:             
   672:                 ! 初期化確認
   673:                 ! Initialization check
   674:                 !
   675:                 if ( .not. rad_rte_nonscat_inited ) then
   676:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   677:                 end if
   678:             
   679:             
   680:             
   681:                 ! 放射フラックス計算
   682:                 ! Calculate radiation flux
   683:                 !
   684:             
   685: W**==== A       xyz_TransEachLayer = exp( - DiffFact * xyz_OptDep )
   686:                 !
   687: W*=====         xyr_Trans0(:,:,0) = 1.0_DP
   688: +------>        do k = 1, kmax
   689: |W*====           xyr_Trans0(:,:,k) = xyr_Trans0(:,:,k-1) * xyz_TransEachLayer(:,:,k)
   690: +------         end do
   691: *W----->        xyr_Trans1(:,:,0) = xyz_TransEachLayer(:,:,1)
   692: *W-----         xyr_Trans1(:,:,1) = 1.0_DP
   693: W------>        do k = 2, kmax
   694: |**====           xyr_Trans1(:,:,k) = xyr_Trans0(:,:,k-1) * xyz_TransEachLayer(:,:,k)
   695: W------         end do
   696:             
   697:                 !   Initialization
   698:                 !
   699: **W---->A       xyr_RadLDwFlux = 0.0_DP
   700: **W---- A       xyr_RadLUwFlux = 0.0_DP
   701:                 !
   702:                 !   Downward flux
   703:                 !
   704:                 k = kmax
   705: W*===== A       xyr_RadLDwFlux(:,:,k) = 0.0_DP
   706: +------>        do k = kmax-1, 0, -1
   707: |W*==== A         xyr_RadLDwFlux(:,:,k) =                                     &
   708: |                   &   xyr_RadLDwFlux(:,:,k+1) * xyz_TransEachLayer(:,:,k+1) &
   709: |                   & + xyz_IntPF(:,:,k+1) * ( 1.0_DP - xyz_TransEachLayer(:,:,k+1) )
   710: +------         end do
   711:                 !
   712:                 !   Upward flux
   713:                 !
   714:                 k = 0
   715: W*===== A       xyr_RadLUwFlux(:,:,k) = xy_SurfIntPF
   716: +------>        do k = 1, kmax
   717: |W*==== A         xyr_RadLUwFlux(:,:,k) =                                   &
   718: |                   &   xyr_RadLUwFlux(:,:,k-1) * xyz_TransEachLayer(:,:,k) &
   719: |                   & - xyz_IntPF(:,:,k) * ( xyz_TransEachLayer(:,:,k) - 1.0_DP )
   720: +------         end do
   721:             
   722:             
   723:                 ! 放射フラックスの変化率の計算
   724:                 ! Calculate rate of change of radiative flux
   725:                 !
   726: +------>        do k = 0, kmax
   727: |W*==== A         xyra_DelRadLUwFlux(:,:,k,0) =                         &
   728: |                   & xy_SurfIntDPFDT * xyr_Trans0(:,:,k)
   729: +------         end do
   730:                 k = 0
   731: W*===== A       xyra_DelRadLUwFlux(:,:,k,1) = 0.0_DP
   732: +------>        do k = 1, kmax
   733: |W*==== A         xyra_DelRadLUwFlux(:,:,k,1) =                         &
   734: |                   & - xy_IntDPFDT1 * ( xyr_Trans0(:,:,k) - xyr_Trans1(:,:,k) )
   735: +------         end do
   736: W------>        do k = 0, kmax
   737: |**==== A         xyra_DelRadLDwFlux(:,:,k,0) = 0.0_DP
   738: W------         end do
   739:                 k = 0
   740: W*===== A       xyra_DelRadLDwFlux(:,:,k,1) =                         &
   741:                   & + xy_IntDPFDT1 * ( xyr_Trans0(:,:,k) - xyr_Trans1(:,:,k) )
   742: W------>        do k = 1, kmax
   743: |**==== A         xyra_DelRadLDwFlux(:,:,k,1) = 0.0_DP
   744: W------         end do
   745:             
   746:             
   747:               end subroutine RadRTENonScatMonoWithDiffFact
   748:             
   749:               !--------------------------------------------------------------------------------------
   750:               ! ###This memo should be checked.###
   751:               ! It should be noted that IntPF is Planck function integrated over 
   752:               ! wavenumber and azimuthal angle and divided by 2. 
   753:             !!$  ! So, pi is multiplied after integrated over wavenumber. 
   754:               !
   755:               subroutine RadRTENonScatMonoSemiAnal(                        &
   756:                 & xy_SurfAlbedo,                                           & ! (in)
   757:                 & xyr_IntPF, xy_SurfIntPF, xy_IntDPFDT1, xy_SurfIntDPFDT,  & ! (in)
   758:                 & xyz_OptDep,                                              & ! (in)
   759:                 & xyr_RadLUwFlux, xyr_RadLDwFlux,                          & ! (out)
   760:                 & xyra_DelRadLUwFlux, xyra_DelRadLDwFlux                   & ! (out)
   761:                 & )
   762:                 !
   763:                 ! 散乱なしの場合の放射伝達方程式の計算
   764:                 !
   765:                 ! Integrate radiative transfer equation without scattering
   766:                 !
   767:             
   768:                 ! モジュール引用 ; USE statements
   769:                 !
   770:             
   771:             
   772:                 ! 宣言文 ; Declaration statements
   773:                 !
   774:             
   775:                 real(DP), intent(in ) :: xy_SurfAlbedo    (0:imax-1, 1:jmax)
   776:                 real(DP), intent(in ) :: xyr_IntPF        (0:imax-1, 1:jmax, 0:kmax)
   777:                                           ! Integrated Planck function
   778:                 real(DP), intent(in ) :: xy_SurfIntPF     (0:imax-1, 1:jmax)
   779:                                           ! Integrated Planck function with surface temperature
   780:                 real(DP), intent(in ) :: xy_IntDPFDT1     (0:imax-1, 1:jmax)
   781:                                           ! Integrated temperature derivative of Planck function
   782:                 real(DP), intent(in ) :: xy_SurfIntDPFDT  (0:imax-1, 1:jmax)
   783:                                           ! Integrated temperature derivative of Planck function
   784:                                           ! with surface temperature
   785:                 real(DP), intent(in ) :: xyz_OptDep   (0:imax-1, 1:jmax, 1:kmax)
   786:                                           ! 光学的厚さ. 
   787:                                           ! Optical depth
   788:                 real(DP), intent(out) :: xyr_RadLUwFlux (0:imax-1, 1:jmax, 0:kmax)
   789:                                           ! 長波フラックス. 
   790:                                           ! Upward longwave flux
   791:                 real(DP), intent(out) :: xyr_RadLDwFlux (0:imax-1, 1:jmax, 0:kmax)
   792:                                           ! 長波フラックス. 
   793:                                           ! Downward longwave flux
   794:                 real(DP), intent(out) :: xyra_DelRadLUwFlux (0:imax-1, 1:jmax, 0:kmax, 0:1)
   795:                                           ! 長波地表温度変化. 
   796:                                           ! Upward longwave flux derivative
   797:                 real(DP), intent(out) :: xyra_DelRadLDwFlux (0:imax-1, 1:jmax, 0:kmax, 0:1)
   798:                                           ! 長波地表温度変化. 
   799:                                           ! Downward longwave flux derivative
   800:             
   801:             
   802:                 ! 作業変数
   803:                 ! Work variables
   804:                 !
   805:                 real(DP) :: CosZA
   806:                 real(DP) :: GaussWeight
   807:             
   808:                 real(DP) :: xyz_TransEachLayer0(0:imax-1, 1:jmax, 1:kmax)
   809:                 real(DP) :: xyz_TransEachLayer (0:imax-1, 1:jmax, 1:kmax)
   810:                                           ! 透過係数. 
   811:                                           ! Transmission coefficient
   812:                 real(DP) :: xyr_Trans0(0:imax-1, 1:jmax, 0:kmax)
   813:                                           ! 
   814:                                           ! Transmission coefficient from surface to layer interfaces
   815:                 real(DP) :: xyr_Trans1(0:imax-1, 1:jmax, 0:kmax)
   816:                                           ! 
   817:                                           ! Transmission coefficient from top of the lowest layer to layer interfaces
   818:             
   819:                 real(DP) :: xyz_DPFDOptDep(0:imax-1, 1:jmax, 1:kmax)
   820:             
   821:                 real(DP) :: xyr_UwFlux (0:imax-1, 1:jmax, 0:kmax)
   822:                 real(DP) :: xyr_DwFlux (0:imax-1, 1:jmax, 0:kmax)
   823:                 real(DP) :: xyra_DelUwFlux (0:imax-1, 1:jmax, 0:kmax, 0:1)
   824:                 real(DP) :: xyra_DelDwFlux (0:imax-1, 1:jmax, 0:kmax, 0:1)
   825:             
   826:                 real(DP) :: IntFact
   827:             
   828:                 integer:: i
   829:                 integer:: j
   830:                 integer:: k               ! 鉛直方向に回る DO ループ用作業変数
   831:                                           ! Work variables for DO loop in vertical direction
   832:                 integer:: n
   833:             
   834:             
   835:                 ! 実行文 ; Executable statement
   836:                 !
   837:             
   838:                 ! 初期化確認
   839:                 ! Initialization check
   840:                 !
   841:                 if ( .not. rad_rte_nonscat_inited ) then
   842:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   843:                 end if
   844:             
   845:             
   846:             
   847:                 ! 放射フラックス計算
   848:                 ! Calculate radiation flux
   849:                 !
   850:             
   851: W**==== A       xyz_TransEachLayer0 = exp( - xyz_OptDep )
   852:                 !  This is ad hoc treatment to avoid underflow.
   853: W------>        do k = 1, kmax
   854: |*----->          do j = 1, jmax
   855: ||*---->            do i = 0, imax-1
   856: |||                   if ( xyz_TransEachLayer0(i,j,k) < 1.0e-50_DP ) then
   857: |||                     xyz_TransEachLayer0(i,j,k) = 0.0_DP
   858: |||                   end if
   859: ||*----             end do
   860: |*-----           end do
   861: W------         end do
   862:             
   863: W------>        do k = 1, kmax
   864: |**==== A         xyz_DPFDOptDep(:,:,k) =                      &
   865: |                   &   ( xyr_IntPF(:,:,k-1) - xyr_IntPF(:,:,k) ) &
   866: |                   & / max( xyz_OptDep(:,:,k), 1.0d-100 )
   867: W------         end do
   868:             
   869:                 if ( NumGaussNodeZAInt > 0 ) then
   870:                   ! for case with Gaussian quadrature
   871:                   IntFact = 2.0_DP
   872:                 else
   873:                   ! for two-stream approximation or case with diffusivity factor
   874:                   IntFact = 1.0_DP
   875:                 end if
   876:             
   877:             
   878:                 !   Initialization
   879:                 !
   880: **W---->A       xyr_RadLUwFlux     = 0.0_DP
   881: **W---- A       xyr_RadLDwFlux     = 0.0_DP
   882: ***W--->A       xyra_DelRadLUwFlux = 0.0_DP
   883: ***W--- A       xyra_DelRadLDwFlux = 0.0_DP
   884:             
   885:             
   886:                 !   Loop for Gaussian quadrature
   887:                 !
   888: +------>        loop_gq : do n = 1, max( NumGaussNodeZAInt, 1 )
   889: |           
   890: |                 ! Preparetion
   891: |                 !
   892: |                 if ( NumGaussNodeZAInt > 0 ) then
   893: |                   CosZA = a_CosZA(n)
   894: |                 else
   895: |                   CosZA = 1.0_DP / DiffFact
   896: |                 end if
   897: |                 !
   898: |W**=== A         xyz_TransEachLayer = ( xyz_TransEachLayer0 )**(1.0d0/CosZA)
   899: |                 !
   900: |W*==== A         xyr_Trans0(:,:,0) = 1.0_DP
   901: |+----->          do k = 1, kmax
   902: ||W*=== A           xyr_Trans0(:,:,k) = xyr_Trans0(:,:,k-1) * xyz_TransEachLayer(:,:,k)
   903: |+-----           end do
   904: |*W---->A         xyr_Trans1(:,:,0) = xyz_TransEachLayer(:,:,1)
   905: |*W----           xyr_Trans1(:,:,1) = 1.0_DP
   906: |+----->          do k = 2, kmax
   907: ||+V===             xyr_Trans1(:,:,k) = xyr_Trans0(:,:,k-1) * xyz_TransEachLayer(:,:,k)
   908: |+-----           end do
   909: |           
   910: |                 !
   911: |                 !   Downward flux
   912: |                 !
   913: |                 k = kmax
   914: |W*====           xyr_DwFlux(:,:,k) = 0.0_DP
   915: |+----->          do k = kmax-1, 0, -1
   916: ||W*=== A           xyr_DwFlux(:,:,k) =                                          &
   917: ||                    &   ( xyr_DwFlux(:,:,k+1) - IntFact * xyr_IntPF(:,:,k+1) ) &
   918: ||                    & * xyz_TransEachLayer(:,:,k+1)                            &
   919: ||                    & + IntFact * xyr_IntPF(:,:,k)                             &
   920: ||                    & - IntFact * CosZA * xyz_DPFDOptDep(:,:,k+1)              &
   921: ||                    &   * ( 1.0_DP - xyz_TransEachLayer(:,:,k+1) )
   922: |+-----           end do
   923: |                 !
   924: |                 !   Upward flux
   925: |                 !
   926: |                 k = 0
   927: |W*==== A         xyr_UwFlux(:,:,k) =                       &
   928: |                   &   IntFact * xy_SurfIntPF              &
   929: |                   & + xy_SurfAlbedo * xyr_DwFlux(:,:,0)
   930: |+----->          do k = 1, kmax
   931: ||W*=== A           xyr_UwFlux(:,:,k) =                                          &
   932: ||                    &   ( xyr_UwFlux(:,:,k-1) - IntFact * xyr_IntPF(:,:,k-1) ) &
   933: ||                    & * xyz_TransEachLayer(:,:,k)                              &
   934: ||                    & + IntFact * xyr_IntPF(:,:,k)                             &
   935: ||                    & + IntFact * CosZA * xyz_DPFDOptDep(:,:,k)                &
   936: ||                    &   * ( 1.0_DP - xyz_TransEachLayer(:,:,k) )
   937: |+-----           end do
   938: |           
   939: |           
   940: |                 ! 放射フラックスの変化率の計算
   941: |                 ! Calculate rate of change of radiative flux
   942: |                 !
   943: |+----->          do k = 0, kmax
   944: ||W*=== A           xyra_DelUwFlux(:,:,k,0) = IntFact * xy_SurfIntDPFDT * xyr_Trans0(:,:,k)
   945: |+-----           end do
   946: |W----->          do k = 0, kmax
   947: ||**=== A           xyra_DelDwFlux(:,:,k,0) = 0.0_DP
   948: |W-----           end do
   949: |**W--->A         xyra_DelUwFlux(:,:,:,1) = 0.0_DP
   950: |**W--- A         xyra_DelDwFlux(:,:,:,1) = 0.0_DP
   951: |           
   952: |           
   953: |                 ! Sum over zenith angle
   954: |                 !
   955: |                 if ( NumGaussNodeZAInt > 0 ) then
   956: |                   GaussWeight = a_GaussWeight( n )
   957: |           
   958: |**W--->A           xyr_RadLUwFlux = xyr_RadLUwFlux &
   959: ||||                  & + xyr_UwFlux * CosZA * GaussWeight
   960: |**W--- A           xyr_RadLDwFlux = xyr_RadLDwFlux &
   961: |                     & + xyr_DwFlux * CosZA * GaussWeight
   962: |           
   963: |***V-->A           xyra_DelRadLUwFlux = xyra_DelRadLUwFlux &
   964: |||||                 & + xyra_DelUwFlux * CosZA * GaussWeight
   965: |***V-- A           xyra_DelRadLDwFlux = xyra_DelRadLDwFlux &
   966: |                     & + xyra_DelDwFlux * CosZA * GaussWeight
   967: |                 else
   968: |**W--->A           xyr_RadLUwFlux = xyr_UwFlux
   969: |**W--- A           xyr_RadLDwFlux = xyr_DwFlux
   970: |           
   971: |***W-->A           xyra_DelRadLUwFlux = xyra_DelUwFlux
   972: |***W-- A           xyra_DelRadLDwFlux = xyra_DelDwFlux
   973: |                 end if
   974: |           
   975: +------         end do loop_gq
   976:             
   977:             
   978:               end subroutine RadRTENonScatMonoSemiAnal
   979:             
   980:               !--------------------------------------------------------------------------------------
   981:             
   982:               subroutine RadRTENonScatWrapper(                    &
   983:                 & xyz_Temp, xy_SurfTemp, xy_SurfEmis, xyrr_Trans, & ! (in )
   984:                 & xyr_RadLUwFlux, xyr_RadLDwFlux,                 & ! (out)
   985:                 & xyra_DelRadLUwFlux, xyra_DelRadLDwFlux,         & ! (out)
   986:                 & WNs, WNe, NumGaussNode                          & ! (in ) optional
   987:                 & )
   988:                 !
   989:                 ! 散乱なしの場合の放射伝達方程式の計算
   990:                 !
   991:                 ! Integrate radiative transfer equation without scattering
   992:                 !
   993:             
   994:                 ! モジュール引用 ; USE statements
   995:                 !
   996:             
   997:             
   998:                 ! プランク関数の計算
   999:                 ! Calculate Planck function
  1000:                 !
  1001:                 use planck_func, only :                            &
  1002:                   & Integ_PF_GQ_Array3D, Integ_PF_GQ_Array2D, Integ_DPFDT_GQ_Array2D
  1003:             
  1004:                 ! 宣言文 ; Declaration statements
  1005:                 !
  1006:             
  1007:                 real(DP), intent(in ) :: xyz_Temp    (0:imax-1, 1:jmax, 1:kmax)
  1008:                                           ! $ T $ .     温度. Temperature
  1009:                 real(DP), intent(in ) :: xy_SurfTemp (0:imax-1, 1:jmax)
  1010:                                           ! 地表面温度. 
  1011:                                           ! Surface temperature
  1012:                 real(DP), intent(in ) :: xy_SurfEmis (0:imax-1, 1:jmax)
  1013:                                           ! 惑星表面射出率. 
  1014:                                           ! Surface emissivity
  1015:                 real(DP), intent(in ) :: xyrr_Trans   (0:imax-1, 1:jmax, 0:kmax, 0:kmax)
  1016:                                           ! 透過係数. 
  1017:                                           ! Transmission coefficient
  1018:                 real(DP), intent(out) :: xyr_RadLUwFlux (0:imax-1, 1:jmax, 0:kmax)
  1019:                                           ! 長波フラックス. 
  1020:                                           ! Upward longwave flux
  1021:                 real(DP), intent(out) :: xyr_RadLDwFlux (0:imax-1, 1:jmax, 0:kmax)
  1022:                                           ! 長波フラックス. 
  1023:                                           ! Downward longwave flux
  1024:                 real(DP), intent(out) :: xyra_DelRadLUwFlux (0:imax-1, 1:jmax, 0:kmax, 0:1)
  1025:                                           ! 長波地表温度変化. 
  1026:                                           ! Upward longwave flux derivative
  1027:                 real(DP), intent(out) :: xyra_DelRadLDwFlux (0:imax-1, 1:jmax, 0:kmax, 0:1)
  1028:                                           ! 長波地表温度変化. 
  1029:                                           ! Downward longwave flux derivative
  1030:                 real(DP), intent(in ), optional :: WNs
  1031:                 real(DP), intent(in ), optional :: WNe
  1032:                 integer , intent(in ), optional :: NumGaussNode
  1033:             
  1034:             
  1035:                 ! 作業変数
  1036:                 ! Work variables
  1037:                 !
  1038:                 real(DP):: xyz_IntPF        (0:imax-1, 1:jmax, 1:kmax)
  1039:                                           ! Integrated Planck function
  1040:                 real(DP):: xy_SurfIntPF     (0:imax-1, 1:jmax)
  1041:                                           ! Integrated Planck function with surface temperature
  1042:                 real(DP):: xy_IntDPFDT1     (0:imax-1, 1:jmax)
  1043:                                           ! Integrated temperature derivative of Planck function
  1044:                 real(DP):: xy_SurfIntDPFDT  (0:imax-1, 1:jmax)
  1045:                                           ! Integrated temperature derivative of Planck function
  1046:                                           ! with surface temperature
  1047:             
  1048:             
  1049:                 ! 実行文 ; Executable statement
  1050:                 !
  1051:             
  1052:                 ! 初期化確認
  1053:                 ! Initialization check
  1054:                 !
  1055:                 if ( .not. rad_rte_nonscat_inited ) then
  1056:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
  1057:                 end if
  1058:             
  1059:             
  1060:                 ! Check arguments
  1061:                 !
  1062:                 if ( present( WNs ) .or. present( WNe ) .or. present( NumGaussNode ) ) then
  1063:                   if ( .not. ( present( WNs ) .and. present( WNe ) .and. present( NumGaussNode ) ) ) then
  1064:                     call MessageNotify( 'E', module_name, &
  1065:                       & 'All of WNs, WNe, and NumGaussNode have to be present.' )
  1066:                   end if
  1067:                 end if
  1068:             
  1069:             
  1070:                 if ( present( WNs ) ) then
  1071:                   ! Case for non-grey atmosphere
  1072:                   !
  1073:             
  1074:                   ! Integrate Planck function and temperature derivative of it
  1075:                   !
  1076:                   call Integ_PF_GQ_Array3D( &
  1077:                     & WNs, WNe, NumGaussNode, &
  1078:                     & 0, imax-1, 1, jmax, 1, kmax, &
  1079:                     & xyz_Temp, &
  1080:                     & xyz_IntPF &
  1081:                     & )
  1082:                   call Integ_PF_GQ_Array2D( &
  1083:                     & WNs, WNe, NumGaussNode, &
  1084:                     & 0, imax-1, 1, jmax, &
  1085:                     & xy_SurfTemp, &
  1086:                     & xy_SurfIntPF &
  1087:                     & )
  1088:                   call Integ_DPFDT_GQ_Array2D(             &
  1089:                     & WNs, WNe, NumGaussNode,              & ! (in )
  1090:                     & 0, imax-1, 1, jmax, xyz_Temp(:,:,1), & ! (in )
  1091:                     & xy_IntDPFDT1                         & ! (out)
  1092:                     & )
  1093:                   call Integ_DPFDT_GQ_Array2D(         &
  1094:                     & WNs, WNe, NumGaussNode,          & ! (in )
  1095:                     & 0, imax-1, 1, jmax, xy_SurfTemp, & ! (in )
  1096:                     & xy_SurfIntDPFDT                  & ! (out)
  1097:                     & )
  1098:             
  1099: W**==== A         xyz_IntPF       =               PI * xyz_IntPF
  1100: *V----->A         xy_SurfIntPF    = xy_SurfEmis * PI * xy_SurfIntPF
  1101: ||      A         xy_IntDPFDT1    =               PI * xy_IntDPFDT1
  1102: *V----- A         xy_SurfIntDPFDT = xy_SurfEmis * PI * xy_SurfIntDPFDT
  1103:             
  1104:                 else
  1105:             
  1106:                   ! Case for grey atmosphere
  1107:                   !
  1108: W**==== A         xyz_IntPF       =                        StB * xyz_Temp**4
  1109: *W----->A         xy_SurfIntPF    = xy_SurfEmis          * StB * xy_SurfTemp**4
  1110: ||      A         xy_IntDPFDT1    =               4.0_DP * StB * xyz_Temp(:,:,1)**3
  1111: *W----- A         xy_SurfIntDPFDT = xy_SurfEmis * 4.0_DP * StB * xy_SurfTemp**3
  1112:             
  1113:                 end if
  1114:             
  1115:             
  1116:                 call RadRTENonScat(                                         &
  1117:                   & xyz_IntPF, xy_SurfIntPF, xy_IntDPFDT1, xy_SurfIntDPFDT, & ! (in)
  1118:                   & xyrr_Trans,                                             & ! (in)
  1119:                   & xyr_RadLUwFlux, xyr_RadLDwFlux,                         & ! (out)
  1120:                   & xyra_DelRadLUwFlux, xyra_DelRadLDwFlux                  & ! (out)
  1121:                   & )
  1122:             
  1123:             
  1124:               end subroutine RadRTENonScatWrapper
  1125:             
  1126:               !--------------------------------------------------------------------------------------
  1127:             
  1128:               subroutine RadRTENonScatInit
  1129:                 !
  1130:                 ! rad_rte_nonscat モジュールの初期化を行います. 
  1131:                 ! NAMELIST#rad_rte_nonscat_nml の読み込みはこの手続きで行われます. 
  1132:                 !
  1133:                 ! "rad_rte_nonscat" module is initialized. 
  1134:                 ! "NAMELIST#rad_rte_nonscat_nml" is loaded in this procedure. 
  1135:                 !
  1136:             
  1137:                 ! モジュール引用 ; USE statements
  1138:                 !
  1139:             
  1140:                 ! NAMELIST ファイル入力に関するユーティリティ
  1141:                 ! Utilities for NAMELIST file input
  1142:                 !
  1143:                 use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid
  1144:             
  1145:                 ! ファイル入出力補助
  1146:                 ! File I/O support
  1147:                 !
  1148:                 use dc_iounit, only: FileOpen
  1149:             
  1150:                 ! ヒストリデータ出力
  1151:                 ! History data output
  1152:                 !
  1153:                 use gtool_historyauto, only: HistoryAutoAddVariable
  1154:             
  1155:                 ! 文字列操作
  1156:                 ! Character handling
  1157:                 !
  1158:                 use dc_string, only: toChar
  1159:             
  1160:                 ! ガウス重み, 分点の計算
  1161:                 ! Calculate Gauss node and Gaussian weight
  1162:                 !
  1163:                 use gauss_quad, only : GauLeg
  1164:             
  1165:                 ! 宣言文 ; Declaration statements
  1166:                 !
  1167:             
  1168:                 integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号. 
  1169:                                           ! Unit number for NAMELIST file open
  1170:                 integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT. 
  1171:                                           ! IOSTAT of NAMELIST read
  1172:             
  1173:             
  1174:                 ! NAMELIST 変数群
  1175:                 ! NAMELIST group name
  1176:                 !
  1177:                 namelist /rad_rte_nonscat_nml/ &
  1178:                   & DiffFact,                  &
  1179:                   & NumGaussNodeZAInt
  1180:                       !
  1181:                       ! デフォルト値については初期化手続 "rad_rte_nonscat#RadRTENonScatInit" 
  1182:                       ! のソースコードを参照のこと. 
  1183:                       !
  1184:                       ! Refer to source codes in the initialization procedure
  1185:                       ! "rad_rte_nonscat#RadRTENonScatInit" for the default values. 
  1186:                       !
  1187:             
  1188:                 ! 実行文 ; Executable statement
  1189:                 !
  1190:             
  1191:                 if ( rad_rte_nonscat_inited ) return
  1192:             
  1193:             
  1194:                 ! デフォルト値の設定
  1195:                 ! Default values settings
  1196:                 !
  1197:                 NumGaussNodeZAInt = 3
  1198:                 DiffFact          = 1.66_DP
  1199:             
  1200:             
  1201:                 ! NAMELIST の読み込み
  1202:                 ! NAMELIST is input
  1203:                 !
  1204:                 if ( trim(namelist_filename) /= '' ) then
  1205:                   call FileOpen( unit_nml, &          ! (out)
  1206:                     & namelist_filename, mode = 'r' ) ! (in)
  1207:             
  1208:                   rewind( unit_nml )
  1209:                   read( unit_nml,                     & ! (in)
  1210:                     & nml = rad_rte_nonscat_nml,      & ! (out)
  1211:                     & iostat = iostat_nml )             ! (out)
  1212:                   close( unit_nml )
  1213:             
  1214:                   call NmlutilMsg( iostat_nml, module_name ) ! (in)
  1215:                 end if
  1216:             
  1217:             
  1218:                 if ( NumGaussNodeZAInt > 0 ) then
  1219:                   allocate( a_CosZA      ( NumGaussNodeZAInt ) )
  1220:                   allocate( a_GaussWeight( NumGaussNodeZAInt ) )
  1221:                   call GauLeg( 0.0_DP, 1.0_DP, NumGaussNodeZAInt, a_CosZA, a_GaussWeight )
  1222:                 end if
  1223:             
  1224:             
  1225:                 ! 印字 ; Print
  1226:                 !
  1227:                 call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
  1228:                 call MessageNotify( 'M', module_name, 'NumGaussNodeZAInt = %d', i = (/ NumGaussNodeZAInt /) )
  1229:                 call MessageNotify( 'M', module_name, 'DiffFact          = %f', d = (/ DiffFact /) )
  1230:                 call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
  1231:             
  1232:                 rad_rte_nonscat_inited = .true.
  1233:             
  1234:               end subroutine RadRTENonScatInit
  1235:             
  1236:               !-------------------------------------------------------------------
  1237:             
  1238:             end module rad_rte_nonscat
