Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:49 2016
FILE NAME: rad_rte_two_stream_app.f90
PROGRAM NAME: rad_rte_two_stream_app
DIAGNOSTIC LIST

  LINE  LEVEL( NO.): DIAGNOSTIC MESSAGE

   235  opt  (1592): Outer loop unrolled inside inner loop.
   235  vec  (   4): Vectorized array expression.
   235  vec  (  29): ADB is used for array.: xyr_optdep
   235  vec  (   4): Vectorized array expression.
   235  vec  (  29): ADB is used for array.: xyr_optdep
   241  opt  (1593): Loop nest collapsed into one loop.
   241  vec  (   4): Vectorized array expression.
   241  vec  (  29): ADB is used for array.: xyr_optdep
   245  opt  (1593): Loop nest collapsed into one loop.
   245  vec  (   1): Vectorized loop.
   245  vec  (  29): ADB is used for array.: xy_inangle
   265  opt  (  11): Fused array assignments. :line 265 - 266
   265  opt  (1592): Outer loop unrolled inside inner loop.
   265  vec  (   4): Vectorized array expression.
   265  vec  (   4): Vectorized array expression.
   272  opt  (  11): Fused array assignments. :line 272 - 273
   272  opt  (1593): Loop nest collapsed into one loop.
   272  vec  (   4): Vectorized array expression.
   280  vec  (   3): Unvectorized loop.
   280  vec  (  13): Overhead of loop division is too large.
   281  opt  (1593): Loop nest collapsed into one loop.
   281  vec  (   4): Vectorized array expression.
   281  vec  (  29): ADB is used for array.: xy_cosszainv
   286  opt  (  11): Fused array assignments. :line 286 - 287
   286  opt  (1593): Loop nest collapsed into one loop.
   286  vec  (   4): Vectorized array expression.
   288  opt  (1592): Outer loop unrolled inside inner loop.
   288  vec  (   4): Vectorized array expression.
   288  vec  (   4): Vectorized array expression.
   290  vec  (   3): Unvectorized loop.
   290  vec  (  13): Overhead of loop division is too large.
   291  opt  (  11): Fused array assignments. :line 291 - 298
   291  opt  (1593): Loop nest collapsed into one loop.
   291  vec  (   4): Vectorized array expression.
   291  vec  (  29): ADB is used for array.: xy_dwradsfluxattoa
   291  vec  (  29): ADB is used for array.: xy_gam4
   291  vec  (  29): ADB is used for array.: xy_gam3
   291  vec  (  29): ADB is used for array.: xy_cosszainv
   291  vec  (  29): ADB is used for array.: xy_cosszainvsq
   305  opt  (1593): Loop nest collapsed into one loop.
   305  vec  (   4): Vectorized array expression.
   308  opt  (  11): Fused array assignments. :line 308 - 309
   308  opt  (1592): Outer loop unrolled inside inner loop.
   308  vec  (   4): Vectorized array expression.
   308  vec  (  29): ADB is used for array.: xy_dwradsfluxattoa
   308  vec  (   4): Vectorized array expression.
   308  vec  (  29): ADB is used for array.: xy_dwradsfluxattoa
   311  opt  (  11): Fused array assignments. :line 311 - 327
   311  opt  (1593): Loop nest collapsed into one loop.
   311  vec  (   4): Vectorized array expression.
   311  vec  (  29): ADB is used for array.: xy_dwradsfluxattoa
   311  vec  (  29): ADB is used for array.: xy_surfalbedo
   339  vec  (   3): Unvectorized loop.
   339  vec  (  13): Overhead of loop division is too large.
   340  opt  (  11): Fused array assignments. :line 340 - 344
   340  opt  (1593): Loop nest collapsed into one loop.
   340  vec  (   4): Vectorized array expression.
   340  vec  (  29): ADB is used for array.: xyr_radsdwflux
   340  vec  (  29): ADB is used for array.: xyr_radsuwflux
   340  vec  (  29): ADB is used for array.: xy_k2
   340  vec  (  29): ADB is used for array.: xy_k1
   359  vec  (   3): Unvectorized loop.
   359  vec  (  13): Overhead of loop division is too large.
   360  opt  (1593): Loop nest collapsed into one loop.
   360  vec  (   4): Vectorized array expression.
   360  vec  (  29): ADB is used for array.: xyr_radsdwflux
   360  vec  (  29): ADB is used for array.: xy_cossza
   366  opt  (1593): Loop nest collapsed into one loop.
   366  vec  (   1): Vectorized loop.
   366  vec  (  29): ADB is used for array.: xyr_radsdwflux
   366  vec  (  29): ADB is used for array.: xyr_radsuwflux
   366  vec  (  29): ADB is used for array.: xy_cossza
   611  vec  (   3): Unvectorized loop.
   611  vec  (   7): Iteration count is too small.
   642  vec  (   3): Unvectorized loop.
   651  vec  (  10): Vectorization obstructive procedure reference.:radrtetwostreamappcore
   888  vec  (   3): Unvectorized loop.
   890  opt  (1017): Subroutine call prevents optimization.
   890  vec  (  10): Vectorization obstructive procedure reference.:messagenotifyc
   900  opt  (1772): Loop nest fused with following nest(s).
   900  opt  (1593): Loop nest collapsed into one loop.
   900  vec  (   1): Vectorized loop.
   900  vec  (  29): ADB is used for array.: xy_inangle
   926  opt  (1593): Loop nest collapsed into one loop.
   926  vec  (   1): Vectorized loop.
   927  opt  (  11): Fused array assignments. :line 927 - 929
   932  opt  (1593): Loop nest collapsed into one loop.
   932  vec  (   1): Vectorized loop.
   945  opt  (1593): Loop nest collapsed into one loop.
   945  vec  (   1): Vectorized loop.
   945  vec  (  29): ADB is used for array.: xyz_ssa
   945  vec  (  29): ADB is used for array.: xyz_af
   946  opt  (  11): Fused array assignments. :line 946 - 947
   953  opt  (1593): Loop nest collapsed into one loop.
   953  vec  (   1): Vectorized loop.
   958  opt  (1593): Loop nest collapsed into one loop.
   958  vec  (   1): Vectorized loop.
   958  vec  (  29): ADB is used for array.: xyr_optdep
   958  vec  (  29): ADB is used for array.: xyz_af
   958  vec  (  29): ADB is used for array.: xyz_ssa
   959  opt  (1037): Feedback of array elements.
   969  opt  (1593): Loop nest collapsed into one loop.
   969  vec  (   1): Vectorized loop.
   969  vec  (  29): ADB is used for array.: xy_cosszainv
   975  opt  (1593): Loop nest collapsed into one loop.
   975  vec  (   1): Vectorized loop.
   989  opt  (1593): Loop nest collapsed into one loop.
   989  vec  (   1): Vectorized loop.
   989  vec  (  29): ADB is used for array.: xy_cossza
   990  opt  (  11): Fused array assignments. :line 990 - 993
   998  opt  (1593): Loop nest collapsed into one loop.
   998  vec  (   1): Vectorized loop.
  1027  opt  (1593): Loop nest collapsed into one loop.
  1027  vec  (   1): Vectorized loop.
  1028  opt  (  11): Fused array assignments. :line 1028 - 1031
  1036  opt  (1593): Loop nest collapsed into one loop.
  1036  vec  (   1): Vectorized loop.
  1051  opt  (1593): Loop nest collapsed into one loop.
  1051  vec  (   1): Vectorized loop.
  1051  vec  (  29): ADB is used for array.: xyr_opdepadj
  1062  opt  (1593): Loop nest collapsed into one loop.
  1062  vec  (   1): Vectorized loop.
  1074  opt  (1593): Loop nest collapsed into one loop.
  1074  vec  (   1): Vectorized loop.
  1079  opt  (  11): Fused array assignments. :line 1079 - 1082
  1087  opt  (1593): Loop nest collapsed into one loop.
  1087  vec  (   1): Vectorized loop.
  1087  vec  (  29): ADB is used for array.: xy_tmpval
  1088  opt  (  11): Fused array assignments. :line 1088 - 1092
  1099  opt  (1593): Loop nest collapsed into one loop.
  1099  vec  (   1): Vectorized loop.
  1099  vec  (  29): ADB is used for array.: xyr_transdiradj
  1099  vec  (  29): ADB is used for array.: xy_cosszainvsq
  1099  vec  (  29): ADB is used for array.: xy_cosszainv
  1099  vec  (  29): ADB is used for array.: xy_solarfluxtoa
  1100  opt  (  11): Fused array assignments. :line 1100 - 1114
  1119  opt  (1593): Loop nest collapsed into one loop.
  1119  vec  (   1): Vectorized loop.
  1120  opt  (  11): Fused array assignments. :line 1120 - 1123
  1131  opt  (1772): Loop nest fused with following nest(s).
  1132  opt  (1593): Loop nest collapsed into one loop.
  1132  vec  (   1): Vectorized loop.
  1132  vec  (  29): ADB is used for array.: xyr_pfinted
  1182  opt  (1593): Loop nest collapsed into one loop.
  1182  vec  (   1): Vectorized loop.
  1183  opt  (  11): Fused array assignments. :line 1183 - 1186
  1193  opt  (1593): Loop nest collapsed into one loop.
  1193  vec  (   1): Vectorized loop.
  1194  opt  (  11): Fused array assignments. :line 1194 - 1197
  1203  vec  (  13): Overhead of loop division is too large.
  1204  vec  (  16): Unvectorizable procedure reference.:maxvl
  1204  vec  (   3): Unvectorized loop.
  1204  vec  (  13): Overhead of loop division is too large.
  1205  opt  (1395): Inner loop stripped and strip loop moved outside outer loop.
  1205  vec  (  16): Unvectorizable procedure reference.:maxvl
  1205  vec  (   4): Vectorized array expression.
  1205  vec  (  29): ADB is used for array.: xy_surfsrc
  1205  vec  (  29): ADB is used for array.: xy_surfpfinted
  1217  vec  (  13): Overhead of loop division is too large.
  1218  vec  (  16): Unvectorizable procedure reference.:maxvl
  1218  vec  (   3): Unvectorized loop.
  1218  vec  (  13): Overhead of loop division is too large.
  1219  opt  (1395): Inner loop stripped and strip loop moved outside outer loop.
  1219  vec  (  16): Unvectorizable procedure reference.:maxvl
  1219  vec  (   4): Vectorized array expression.
  1219  vec  (  29): ADB is used for array.: xy_surfsrc
  1225  opt  (1593): Loop nest collapsed into one loop.
  1225  vec  (   1): Vectorized loop.
  1225  vec  (  29): ADB is used for array.: xy_surfsrc
  1225  vec  (  29): ADB is used for array.: xy_cossza
  1225  vec  (  29): ADB is used for array.: xyr_transdiradj
  1225  vec  (  29): ADB is used for array.: xy_solarfluxtoa
  1225  vec  (  29): ADB is used for array.: xy_surfalbedo
  1235  opt  (1772): Loop nest fused with following nest(s).
  1235  opt  (1592): Outer loop unrolled inside inner loop.
  1236  vec  (   1): Vectorized loop.
  1236  vec  (  29): ADB is used for array.: aa_vec
  1236  vec  (  29): ADB is used for array.: xy_surfsrc
  1236  vec  (  29): ADB is used for array.: aa_tridiagmtx3
  1236  vec  (  29): ADB is used for array.: aa_tridiagmtx2
  1236  vec  (  29): ADB is used for array.: xy_surfalbedo
  1236  vec  (  29): ADB is used for array.: aa_tridiagmtx1
  1236  vec  (   1): Vectorized loop.
  1236  vec  (  29): ADB is used for array.: aa_vec
  1236  vec  (  29): ADB is used for array.: aa_tridiagmtx3
  1236  vec  (  29): ADB is used for array.: aa_tridiagmtx2
  1236  vec  (  29): ADB is used for array.: xy_surfalbedo
  1236  vec  (  29): ADB is used for array.: aa_tridiagmtx1
  1258  vec  (   1): Vectorized loop.
  1258  vec  (  29): ADB is used for array.: aa_vec
  1258  vec  (  29): ADB is used for array.: aa_tridiagmtx3
  1258  vec  (  29): ADB is used for array.: aa_tridiagmtx2
  1258  vec  (  29): ADB is used for array.: aa_tridiagmtx1
  1258  vec  (  29): ADB is used for array.: xyaz_smalle
  1296  opt  (1592): Outer loop unrolled inside inner loop.
  1297  vec  (   1): Vectorized loop.
  1297  vec  (  29): ADB is used for array.: aa_vec
  1297  vec  (  29): ADB is used for array.: aa_tridiagmtx3
  1297  vec  (  29): ADB is used for array.: aa_tridiagmtx2
  1297  vec  (  29): ADB is used for array.: xyaz_smalle
  1297  vec  (  29): ADB is used for array.: aa_tridiagmtx1
  1297  vec  (   1): Vectorized loop.
  1297  vec  (  29): ADB is used for array.: aa_vec
  1297  vec  (  29): ADB is used for array.: aa_tridiagmtx3
  1297  vec  (  29): ADB is used for array.: aa_tridiagmtx2
  1297  vec  (  29): ADB is used for array.: xyaz_smalle
  1297  vec  (  29): ADB is used for array.: aa_tridiagmtx1
  1312  opt  (1592): Outer loop unrolled inside inner loop.
  1313  vec  (   1): Vectorized loop.
  1313  vec  (  29): ADB is used for array.: xyr_raddwflux
  1313  vec  (  29): ADB is used for array.: xyaz_smalle
  1313  vec  (  29): ADB is used for array.: xyr_raduwflux
  1313  vec  (  29): ADB is used for array.: aa_vec
  1313  vec  (   1): Vectorized loop.
  1313  vec  (  29): ADB is used for array.: xyr_raddwflux
  1313  vec  (  29): ADB is used for array.: xyaz_smalle
  1313  vec  (  29): ADB is used for array.: xyr_raduwflux
  1313  vec  (  29): ADB is used for array.: aa_vec
  1326  opt  (1592): Outer loop unrolled inside inner loop.
  1327  vec  (   1): Vectorized loop.
  1327  vec  (  29): ADB is used for array.: xyr_raddwflux
  1327  vec  (  29): ADB is used for array.: xyr_raduwflux
  1327  vec  (  29): ADB is used for array.: xyaz_smalle
  1327  vec  (  29): ADB is used for array.: aa_vec
  1327  vec  (   1): Vectorized loop.
  1327  vec  (  29): ADB is used for array.: xyr_raddwflux
  1327  vec  (  29): ADB is used for array.: xyr_raduwflux
  1327  vec  (  29): ADB is used for array.: xyaz_smalle
  1327  vec  (  29): ADB is used for array.: aa_vec
  1390  warn (   7): Characters in a line over this form limitation.
  1390  warn (   7): Characters in a line over this form limitation.
  1395  opt  (1772): Loop nest fused with following nest(s).
  1396  opt  (1593): Loop nest collapsed into one loop.
  1396  vec  (   1): Vectorized loop.
  1396  vec  (  29): ADB is used for array.: xyra_delraddwflux
  1396  vec  (  29): ADB is used for array.: xyra_delraduwflux
  1396  vec  (  29): ADB is used for array.: xyr_raddwflux
  1396  vec  (  29): ADB is used for array.: xyr_raduwflux
  1397  opt  (  11): Fused array assignments. :line 1397 - 1398
  1404  opt  (  11): Fused array assignments. :line 1404 - 1407
  1415  opt  (1593): Loop nest collapsed into one loop.
  1415  vec  (   1): Vectorized loop.
  1416  opt  (1036): Potential feedback - use directive if OK.
  1416  opt  (1033): Potential multiple store conflict -- use directive if OK.
  1416  opt  (1036): Potential feedback - use directive if OK.
  1416  opt  (1036): Potential feedback - use directive if OK.
  1420  vec  (   1): Vectorized loop.
  1420  vec  (  29): ADB is used for array.: xyr_idw
  1420  vec  (  29): ADB is used for array.: xyz_deltau
  1420  vec  (  29): ADB is used for array.: xyz_gam2
  1420  vec  (  29): ADB is used for array.: xyz_gam1
  1420  vec  (  29): ADB is used for array.: xyz_b1
  1420  vec  (  29): ADB is used for array.: xyz_b0
  1420  vec  (  29): ADB is used for array.: xyz_mu1
  1420  vec  (  29): ADB is used for array.: xyz_lambda
  1420  vec  (  29): ADB is used for array.: xyz_lgamma
  1420  vec  (  29): ADB is used for array.: aa_vec
  1432  opt  (1037): Feedback of array elements.
  1432  opt  (1037): Feedback of array elements.
  1432  opt  (1037): Feedback of array elements.
  1432  opt  (1037): Feedback of array elements.
  1446  opt  (1593): Loop nest collapsed into one loop.
  1446  vec  (   1): Vectorized loop.
  1446  vec  (  29): ADB is used for array.: xyr_iuw
  1446  vec  (  29): ADB is used for array.: xy_surfpfinted
  1446  vec  (  29): ADB is used for array.: xyr_idw
  1446  vec  (  29): ADB is used for array.: xy_surfalbedo
  1451  opt  (1037): Feedback of array elements.
  1451  opt  (1037): Feedback of array elements.
  1455  vec  (   1): Vectorized loop.
  1455  vec  (  29): ADB is used for array.: xyr_iuw
  1455  vec  (  29): ADB is used for array.: xyz_deltau
  1455  vec  (  29): ADB is used for array.: xyz_gam2
  1455  vec  (  29): ADB is used for array.: xyz_gam1
  1455  vec  (  29): ADB is used for array.: xyz_b1
  1455  vec  (  29): ADB is used for array.: xyz_b0
  1455  vec  (  29): ADB is used for array.: xyz_lgamma
  1455  vec  (  29): ADB is used for array.: xyz_lambda
  1455  vec  (  29): ADB is used for array.: xyz_mu1
  1455  vec  (  29): ADB is used for array.: aa_vec
  1467  opt  (1037): Feedback of array elements.
  1467  opt  (1037): Feedback of array elements.
  1467  opt  (1037): Feedback of array elements.
  1481  opt  (1593): Loop nest collapsed into one loop.
  1481  vec  (   1): Vectorized loop.
  1481  vec  (  29): ADB is used for array.: xyr_raddwflux
  1481  vec  (  29): ADB is used for array.: xyr_idw
  1481  vec  (  29): ADB is used for array.: xyr_raduwflux
  1481  vec  (  29): ADB is used for array.: xyr_iuw
  1482  opt  (  11): Fused array assignments. :line 1482 - 1483
  1488  opt  (1593): Loop nest collapsed into one loop.
  1488  vec  (   1): Vectorized loop.
  1488  vec  (  29): ADB is used for array.: xyra_delraduwflux
  1488  vec  (  29): ADB is used for array.: xyr_opdepadj
  1488  vec  (  29): ADB is used for array.: xy_surfdpfdtinted
  1506  opt  (1593): Loop nest collapsed into one loop.
  1506  vec  (   1): Vectorized loop.
  1506  vec  (  29): ADB is used for array.: xyr_raddwflux
  1506  vec  (  29): ADB is used for array.: xy_cossza
  1506  vec  (  29): ADB is used for array.: xyr_transdiradj
  1506  vec  (  29): ADB is used for array.: xy_solarfluxtoa
  1552  vec  (   1): Vectorized loop.
  1552  vec  (  29): ADB is used for array.: f
  1552  vec  (  29): ADB is used for array.: b
  1552  vec  (  29): ADB is used for array.: c
  1558  vec  (   1): Vectorized loop.
  1558  vec  (  29): ADB is used for array.: f
  1558  vec  (  29): ADB is used for array.: c
  1558  vec  (  29): ADB is used for array.: a
  1558  vec  (  29): ADB is used for array.: b
  1559  opt  (1037): Feedback of array elements.
  1561  opt  (1037): Feedback of array elements.
  1568  vec  (   1): Vectorized loop.
  1568  vec  (  29): ADB is used for array.: f
  1569  opt  (1037): Feedback of array elements.
  1596  vec  (   3): Unvectorized loop.
  1596  vec  (  13): Overhead of loop division is too large.
  1597  opt  (1037): Feedback of array elements.
  1598  vec  (  20): Unvectorizable dependency.:q
  1599  opt  (1037): Feedback of array elements.
  1599  vec  (  20): Unvectorizable dependency.:f
  1604  vec  (   1): Vectorized loop.
  1604  vec  (  29): ADB is used for array.: f
  1604  vec  (  29): ADB is used for array.: q
  1605  opt  (1037): Feedback of array elements.
  1605  vec  (  26): Macro operation Iteration.
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:49 2016
FILE NAME: rad_rte_two_stream_app.f90
PROGRAM NAME: rad_rte_two_stream_app
TRANSFORMATION LIST

  LINE                   FORTRAN STATEMENT

     1  !=
     2  !
     3  != Solve radiative transfer equation in two stream approximation
     4  !
     5  ! Authors::   Yoshiyuki O. Takahashi
     6  ! Version::   $Id: rad_rte_two_stream_app.f90,v 1.7 2015/03/11 04:48:47 yot Exp $
     7  ! Tag Name::  $Name:  $
     8  ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9  ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10  !
    11  module rad_rte_two_stream_app
    12    !
    13    !=
    14    !
    15    != Solve radiative transfer equation in two stream approximation
    16    !
    17    ! <b>Note that Japanese and English are described in parallel.</b>
    18    !
    19    !
    20    !
    21    ! Solve radiative transfer equation in two stream approximation.
    22    ! Analytic solution is used to calculate radiative flux in a homogeneous atmosphere
    23    ! in which the single scattering albedo and the asymmetry factor are constant.
    24    ! Radiative transfer equation is solved numerically with the method by Toon et al.
    25    ! (1989) to calculate radiative flux in an inhomogeneous atmosphere.
    26    !
    27    !
    28    !== References
    29    !
    30    !  Toon, O. B., C. P. McKay, and A. P. Ackerman,
    31    !    Rapid calculation of radiative heating rates and photodissociation rates
    32    !    in inhomogeneous multiple scattering atmospheres,
    33    !    J. Geophys. Res., 94, 16287-16301, 1989.
    34    !
    35    !== Procedures List
    36    !
    37  !!$  ! RadiationFluxDennouAGCM :: 放射フラックスの計算
    38  !!$  ! RadiationDTempDt        :: 放射フラックスによる温度変化の計算
    39  !!$  ! RadiationFluxOutput     :: 放射フラックスの出力
    40  !!$  ! RadiationFinalize       :: 終了処理 (モジュール内部の変数の割り付け解除)
    41  !!$  ! ------------            :: ------------
    42  !!$  ! RadiationFluxDennouAGCM :: Calculate radiation flux
    43  !!$  ! RadiationDTempDt        :: Calculate temperature tendency with radiation flux
    44  !!$  ! RadiationFluxOutput     :: Output radiation fluxes
    45  !!$  ! RadiationFinalize       :: Termination (deallocate variables in this module)
    46    !
    47    !== NAMELIST
    48    !
    49  !!$  ! NAMELIST#radiation_DennouAGCM_nml
    50    !
    51  
    52    !
    53    ! Kind type parameter
    54    !
    55    use dc_types, only: DP, &      ! Double precision.
    56      &                 STRING, &  ! Strings.
    57      &                 TOKEN      ! Keywords.
    58  
    59    ! メッセージ出力
    60    ! Message output
    61    !
    62    use dc_message, only: MessageNotify
    63  
    64    ! 物理・数学定数設定
    65    ! Physical and mathematical constants settings
    66    !
    67    use constants0, only: &
    68      & PI
    69                              ! $ \pi $ .
    70                              ! 円周率.  Circular constant
    71  
    72    ! 格子点設定
    73    ! Grid points settings
    74    !
    75    use gridset, only: imax, & ! 経度格子点数.
    76                               ! Number of grid points in longitude
    77      &                jmax, & ! 緯度格子点数.
    78                               ! Number of grid points in latitude
    79      &                kmax    ! 鉛直層数.
    80                               ! Number of vertical level
    81  
    82    implicit none
    83  
    84    private
    85  
    86  
    87    ! Local variables
    88    !
    89    real(DP), parameter :: DelTauThreshold = 1.0e-10_DP
    90  
    91  !!$  integer, save :: NGaussQuad
    92    integer, parameter :: NGaussQuad = 8
    93    real(DP), save     :: a_GQP(1:NGaussQuad)
    94    real(DP), save     :: a_GQW(1:NGaussQuad)
    95  
    96    ! 公開変数
    97    ! Public variables
    98    !
    99    logical, save :: rad_rte_two_stream_app_inited = .false.
   100                                ! 初期設定フラグ.
   101                                ! Initialization flag
   102  
   103    integer, parameter :: IDScatApproxEddington = 11
   104    integer, parameter :: IDScatApproxHemiMean  = 12
   105  
   106    public :: RadRTETwoStreamAppHomogAtm
   107  !!$  public :: RadRTETwoStreamApp
   108    public :: RadRTETwoStreamAppSW
   109    public :: RadRTETwoStreamAppLW
   110    public :: RadRTETwoStreamAppInit
   111  
   112  
   113    ! INTERFACE 文 ; INTERFACE statements
   114    !
   115  !!$  interface RadRTETwoStreamApp
   116  !!$    module procedure RadRTETwoStreamAppWrapper, RadRTETwoStreamAppCore
   117  !!$  end interface
   118  !!$  interface RadRTETwoStreamApp
   119  !!$    module procedure RadRTETwoStreamAppWrapper
   120  !!$  end interface
   121  
   122  
   123  
   124    character(*), parameter:: module_name = 'rad_rte_two_stream_app'
   125                                ! モジュールの名称.
   126                                ! Module name
   127    character(*), parameter:: version = &
   128      & '$Name:  $' // &
   129      & '$Id: rad_rte_two_stream_app.f90,v 1.7 2015/03/11 04:48:47 yot Exp $'
   130                                ! モジュールのバージョン
   131                                ! Module version
   132  
   133    !--------------------------------------------------------------------------------------
   134  
   135  contains
   136  
   137    !--------------------------------------------------------------------------------------
   138  
   139    subroutine RadRTETwoStreamAppHomogAtm(                               &
   140      & xy_SurfAlbedo, SolarFluxAtTOA, xy_InAngle, SSA, AF, xyr_OptDep,  & ! (in )
   141      & xyr_RadSUwFlux, xyr_RadSDwFlux,                                  & ! (out)
   142      & FlagSemiInfAtm, FlagSL09                                         & ! (in ) optional
   143      & )
   144  
   145      ! Calculate radiative flux in a homogeneous scattering and absorbing atmosphere.
   146      ! Analytical solution is used for calculation of radiative flux.
   147      ! Radiative flux in a semi-infinite atmosphere is calculated if FlagSemiInfAtm
   148      ! is .true.. If FlagSemiInfAtm is not given or is .false., radiative flux in a finite
   149      ! atmosphere (bounded by the surface) is calculated.
   150      !
   151      ! If FlagSL09 is .true., short wave radiative flux is calculated with the method by
   152      ! Schneider and Liu (2009).
   153      !
   154      ! See Meador and Weaver (19??), Toon et al. (1989), Liou (200?), and so on for
   155      ! details of radiative transfer equation in this system.
   156  
   157  
   158      real(DP), intent(in ) :: xy_SurfAlbedo(0:imax-1, 1:jmax)
   159      real(DP), intent(in ) :: SolarFluxAtTOA
   160      real(DP), intent(in ) :: xy_InAngle   (0:imax-1, 1:jmax)
   161      real(DP), intent(in ) :: SSA
   162      real(DP), intent(in ) :: AF
   163      real(DP), intent(in ) :: xyr_OptDep    (0:imax-1, 1:jmax, 0:kmax)
   164      real(DP), intent(out) :: xyr_RadSUwFlux(0:imax-1, 1:jmax, 0:kmax)
   165      real(DP), intent(out) :: xyr_RadSDwFlux(0:imax-1, 1:jmax, 0:kmax)
   166      logical , intent(in ), optional :: FlagSemiInfAtm
   167      logical , intent(in ), optional :: FlagSL09
   168  
   169      !
   170      ! cosz     : cosine of solar zenith angle
   171      ! cosz2    : cosz squared
   172      !
   173      real(DP) :: xy_cosSZA     ( 0:imax-1, 1:jmax )
   174      real(DP) :: xy_cosSZAInv  ( 0:imax-1, 1:jmax )
   175      real(DP) :: xy_cosSZAInvsq( 0:imax-1, 1:jmax )
   176  
   177      real(DP) :: SSAAdj
   178      real(DP) :: AFAdj
   179      real(DP) :: xyr_OptDepAdj(0:imax-1, 1:jmax, 0:kmax )
   180  
   181      real(DP) :: Lambda
   182      real(DP) :: LSigma
   183      real(DP) :: Gam1
   184      real(DP) :: Gam2
   185      real(DP) :: xy_Gam3   (0:imax-1, 1:jmax)
   186      real(DP) :: xy_Gam4   (0:imax-1, 1:jmax)
   187      real(DP) :: xyr_Trans (0:imax-1, 1:jmax, 0:kmax)
   188      real(DP) :: xyr_TMPVal(0:imax-1, 1:jmax, 0:kmax)
   189      real(DP) :: xyr_CUp   (0:imax-1, 1:jmax, 0:kmax)
   190      real(DP) :: xyr_CDo   (0:imax-1, 1:jmax, 0:kmax)
   191  
   192      real(DP) :: xy_k1           (0:imax-1, 1:jmax)
   193      real(DP) :: xy_k2           (0:imax-1, 1:jmax)
   194      real(DP) :: xyr_ExpLamOptDep(0:imax-1, 1:jmax, 0:kmax)
   195  
   196      real(DP) :: xy_DWRadSFluxAtTOA(0:imax-1, 1:jmax)
   197  
   198      logical  :: FlagSemiInfAtmLV
   199      logical  :: FlagSL09LV
   200  
   201      integer  :: i
   202      integer  :: j
   203      integer  :: k
   204  
   205  
   206      ! 初期化確認
   207      ! Initialization check
   208      !
   209      if ( .not. rad_rte_two_stream_app_inited ) then
   210        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   211      end if
   212  
   213      ! Check flags
   214      !
   215      FlagSL09LV = .false.
   216      if ( present( FlagSL09 ) ) then
   217        if ( FlagSL09 ) then
   218          FlagSL09LV = .true.
   219        end if
   220      end if
   221      FlagSemiInfAtmLV = .false.
   222      if ( present( FlagSemiInfAtm ) ) then
   223        if ( FlagSemiInfAtm ) then
   224          FlagSemiInfAtmLV = .true.
   225        end if
   226      end if
   227      if ( FlagSL09LV .and. ( .not. FlagSemiInfAtmLV ) ) then
   228        call MessageNotify( 'E', module_name, 'FlagSemiInfAtm has to be .true. when FlagSL09 is .true.' )
   229      end if
   230  
   231  
   232      if ( FlagSL09LV ) then
   233        SSAAdj        = SSA
   234        AFAdj         = AF
   235        xyr_OptDepAdj = xyr_OptDep
     .        if(1+xyr_optdepadj.DSC.U2-min0(1,xyr_optdepadj.DSC.U2).gt.0)then  
     .           j1=and(1+xyr_optdepadj.DSC.U2-min0(1,xyr_optdepadj.DSC.U2),3)  
     .  !cdir    nodep                                                          
     .           do t837 = 1, j1                                                
     .  !cdir       nodep                                                       
     .              do t839 = 1, xyr_optdepadj.DSC.U1 + 2 - min0(1,             
     .       1         xyr_optdepadj.DSC.U1 + 1)                                
     .                 xyr_optdepadj(t839-1,t837,t835) = xyr_optdep(t839-1,t837,
     .       1            t835)                                                 
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t837 = j1 + 1, 1 + xyr_optdepadj.DSC.U2 - min0(1,           
     .       1      xyr_optdepadj.DSC.U2), 4                                    
     .  !cdir       nodep                                                       
     .              do t839 = 1, xyr_optdepadj.DSC.U1 + 2 - min0(1,             
     .       1         xyr_optdepadj.DSC.U1 + 1)                                
     .                 xyr_optdepadj(t839-1,t837,t835) = xyr_optdep(t839-1,t837,
     .       1            t835)                                                 
     .                 xyr_optdepadj(t839-1,t837+1,t835) = xyr_optdep(t839-1,   
     .       1            t837+1,t835)                                          
     .                 xyr_optdepadj(t839-1,t837+2,t835) = xyr_optdep(t839-1,   
     .       1            t837+2,t835)                                          
     .                 xyr_optdepadj(t839-1,t837+3,t835) = xyr_optdep(t839-1,   
     .       1            t837+3,t835)                                          
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
   236      else
   237        ! Delta-function adjustment
   238        !
   239        SSAAdj        =   ( 1.0_DP - AF**2 ) * SSA  / ( 1.0_DP - SSA * AF**2 )
   240        AFAdj         = AF / ( 1.0_DP + AF )
   241        xyr_OptDepAdj = ( 1.0_DP - SSA * AF**2 ) * xyr_OptDep
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t637 = 1, jmax*(kmax*imax + imax)                              
     .           xyr_optdepadj(t637-1,1,0) = (1.00000000000000e+000 - ssa*af**2)
     .       1      *xyr_optdep(t637-1,1,0)                                     
     .        enddo                                                             
   242      end if
   243  
   244  
   245      do j = 1, jmax
   246        do i = 0, imax-1
   247          if ( xy_InAngle(i,j) > 0.0_DP ) then
   248            xy_cosSZA     (i,j) = 1.0_DP / xy_InAngle(i,j)
   249            xy_cosSZAInv  (i,j) = xy_InAngle(i,j)
   250            xy_cosSZAInvsq(i,j) = xy_cosSZAInv(i,j)**2
   251          else
   252            xy_cosSZA     (i,j) = 0.0_DP
   253            xy_cosSZAInv  (i,j) = 0.0_DP
   254            xy_cosSZAInvsq(i,j) = 0.0_DP
   255          end if
   256        end do
   257      end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do j = 1, jmax*imax                                               
     .           if (xy_inangle(j-1,1) .gt. 0.0000000000000000e+000) then       
     .              xy_cossza1 = 1.00000000000000e+000/xy_inangle(j-1,1)        
     .              xy_cosszainv2 = xy_inangle(j-1,1)                           
     .              xy_cosszainvsq3 = xy_cosszainv2**2                          
     .           else                                                           
     .              xy_cossza1 = 0.0000000000000000e+000                        
     .              xy_cosszainv2 = 0.0000000000000000e+000                     
     .              xy_cosszainvsq3 = 0.0000000000000000e+000                   
     .           endif                                                          
     .           xy_cosszainvsq(j-1,1) = xy_cosszainvsq3                        
     .           xy_cosszainv(j-1,1) = xy_cosszainv2                            
     .           xy_cossza(j-1,1) = xy_cossza1                                  
     .        enddo                                                             
   258  
   259  
   260      if ( FlagSL09LV ) then
   261        ! Coefficients for Hemispheric mean approximation
   262        !
   263        Gam1    = 2.0_DP - SSAAdj * ( 1.0_DP + AFAdj )
   264        Gam2    = SSAAdj * ( 1.0_DP - AFAdj )
   265        xy_Gam3 = 1.0d100
     .        if (xy_gam3.DSC.U2 .gt. 0) then                                   
     .           j2 = and(xy_gam3.DSC.U2,3)                                     
     .  !cdir    nodep                                                          
     .           do t827 = 1, j2                                                
     .  !cdir       nodep                                                       
     .              do t829 = 1, xy_gam3.DSC.U1 + 2 - min0(1,xy_gam3.DSC.U1 + 1)
     .                 xy_gam3(t829-1,t827) = 1.00000000000000e+100             
     .                 xy_gam4(t829-1,t827) = 1.00000000000000e+100             
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t827 = j2 + 1, xy_gam3.DSC.U2, 4                            
     .  !cdir       nodep                                                       
     .              do t829 = 1, xy_gam3.DSC.U1 + 2 - min0(1,xy_gam3.DSC.U1 + 1)
     .                 xy_gam3(t829-1,t827) = 1.00000000000000e+100             
     .                 xy_gam3(t829-1,t827+1) = 1.00000000000000e+100           
     .                 xy_gam3(t829-1,t827+2) = 1.00000000000000e+100           
     .                 xy_gam3(t829-1,t827+3) = 1.00000000000000e+100           
     .                 xy_gam4(t829-1,t827) = 1.00000000000000e+100             
     .                 xy_gam4(t829-1,t827+1) = 1.00000000000000e+100           
     .                 xy_gam4(t829-1,t827+2) = 1.00000000000000e+100           
     .                 xy_gam4(t829-1,t827+3) = 1.00000000000000e+100           
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
     .        goto 10027                                                        
   266        xy_Gam4 = 1.0d100
   267      else
   268        ! Coefficients for Eddington approximation
   269        !
   270        Gam1    =  ( 7.0_DP - SSAAdj * ( 4.0_DP + 3.0_DP * AFAdj ) ) / 4.0_DP
   271        Gam2    = -( 1.0_DP - SSAAdj * ( 4.0_DP - 3.0_DP * AFAdj ) ) / 4.0_DP
   272        xy_Gam3 =  ( 2.0_DP - 3.0_DP * AFAdj * xy_cosSZA )        / 4.0_DP
     .        d4 = 1.D0/4.00000000000000e+000                                   
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t649 = 1, xy_cossza.DSC.U2*xy_cossza.DSC.U1 + xy_cossza.DSC.U2 
     .           xy_gam3(t649-1,1) = (2.00000000000000e+000 -                   
     .       1      3.00000000000000e+000*afadj*xy_cossza(t649-1,1))*d4         
     .           xy_gam4(t649-1,1) = 1.00000000000000e+000 - xy_gam3(t649-1,1)  
     .        enddo                                                             
   273        xy_Gam4 = 1.0_DP - xy_Gam3
   274      end if
   275  
   276  
   277      Lambda = sqrt( Gam1**2 - Gam2**2 )
   278      LSigma = Gam2 / ( Gam1 + Lambda )
   279  
   280      do k = 0, kmax
   281        xyr_Trans(:,:,k) = exp( - xyr_OptDepAdj(:,:,k) * xy_cosSZAInv )
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xy_cosszainv)                                              
     .        do t661 = 1, xyr_optdepadj.DSC.U2*xyr_optdepadj.DSC.U1 +          
     .       1   xyr_optdepadj.DSC.U2                                           
     .           xyr_trans(t661-1,1,k) = dexp((-xyr_optdepadj(t661-1,1,k)*      
     .       1      xy_cosszainv(t661-1,1)))                                    
     .        enddo                                                             
   282      end do
   283  
   284  
   285      if ( FlagSL09LV ) then
   286        xyr_CUp = 0.0_DP
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t807=1,(xyr_cup.DSC.U3+1)*xyr_cup.DSC.U2*(xyr_cup.DSC.U1+1)    
     .           xyr_cup(t807-1,1,0) = 0.0000000000000000e+000                  
     .           xyr_cdo(t807-1,1,0) = 0.0000000000000000e+000                  
     .        enddo                                                             
   287        xyr_CDo = 0.0_DP
   288        xy_DWRadSFluxAtTOA = SolarFluxAtTOA * xy_CosSZA
     .        if (xy_cossza.DSC.U2 .gt. 0) then                                 
     .           j3 = and(xy_cossza.DSC.U2,3)                                   
     .  !cdir    nodep                                                          
     .           do t819 = 1, j3                                                
     .  !cdir       nodep                                                       
     .              do t821=1,xy_cossza.DSC.U1+2-min0(1,xy_cossza.DSC.U1+1)     
     .                 xy_dwradsfluxattoa(t821-1,t819) = solarfluxattoa*        
     .       1            xy_cossza(t821-1,t819)                                
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t819 = j3 + 1, xy_cossza.DSC.U2, 4                          
     .  !cdir       nodep                                                       
     .              do t821=1,xy_cossza.DSC.U1+2-min0(1,xy_cossza.DSC.U1+1)     
     .                 xy_dwradsfluxattoa(t821-1,t819) = solarfluxattoa*        
     .       1            xy_cossza(t821-1,t819)                                
     .                 xy_dwradsfluxattoa(t821-1,t819+1) = solarfluxattoa*      
     .       1            xy_cossza(t821-1,t819+1)                              
     .                 xy_dwradsfluxattoa(t821-1,t819+2) = solarfluxattoa*      
     .       1            xy_cossza(t821-1,t819+2)                              
     .                 xy_dwradsfluxattoa(t821-1,t819+3) = solarfluxattoa*      
     .       1            xy_cossza(t821-1,t819+3)                              
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
     .        goto 10044                                                        
   289      else
   290        do k = 0, kmax
   291          xyr_TMPVal(:,:,k) =                                       &
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xy_cosszainv,xy_cosszainvsq,xy_gam3,xy_gam4,xy_dwradsfluxat
     .       1   toa)                                                           
     .        do t671 = 1, xyr_trans.DSC.U2*xyr_trans.DSC.U1 + xyr_trans.DSC.U2 
     .           xyr_tmpval1 = ssaadj*solarfluxattoa*xyr_trans(t671-1,1,k)/(    
     .       1      lambda**2 - xy_cosszainvsq(t671-1,1))                       
     .           xyr_cup(t671-1,1,k) = xyr_tmpval1*((gam1 - xy_cosszainv(t671-1,
     .       1      1))*xy_gam3(t671-1,1)+gam2*xy_gam4(t671-1,1))               
     .           xyr_cdo(t671-1,1,k) = xyr_tmpval1*((gam1 + xy_cosszainv(t671-1,
     .       1      1))*xy_gam4(t671-1,1)+gam2*xy_gam3(t671-1,1))               
     .           xy_dwradsfluxattoa(t671-1,1) = 0.0000000000000000e+000         
     .        enddo                                                             
   292            &   SSAAdj * SolarFluxAtTOA * xyr_Trans(:,:,k)          &
   293            & / ( Lambda**2 - xy_cosSZAInvsq )
   294          xyr_CUp(:,:,k) = xyr_TMPVal(:,:,k)                        &
   295            &   * ( ( Gam1 - xy_cosSZAInv ) * xy_Gam3 + Gam2 * xy_Gam4 )
   296          xyr_CDo(:,:,k) = xyr_TMPVal(:,:,k)                        &
   297            &   * ( ( Gam1 + xy_cosSZAInv ) * xy_Gam4 + Gam2 * xy_Gam3 )
   298          xy_DWRadSFluxAtTOA = 0.0_DP
   299        end do
   300      end if
   301  
   302  
   303      ! A variable used in the following calculation
   304      !
   305      xyr_ExpLamOptDep = exp( Lambda * xyr_OptDepAdj )
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t703 = 1, (xyr_optdepadj.DSC.U3 + 1)*xyr_optdepadj.DSC.U2*(    
     .       1   xyr_optdepadj.DSC.U1 + 1)                                      
     .           xyr_explamoptdep(t703-1,1,0) = dexp(lambda*xyr_optdepadj(t703-1
     .       1      ,1,0))                                                      
     .        enddo                                                             
   306  
   307      if ( FlagSemiInfAtmLV ) then
   308        xy_k1 = 0.0_DP
     .        if (xy_k1.DSC.U2 .gt. 0) then                                     
     .           j4 = and(xy_k1.DSC.U2,3)                                       
     .  !cdir    nodep                                                          
     .           do t795 = 1, j4                                                
     .  !cdir       nodep                                                       
     .  !cdir       on_adb(xy_dwradsfluxattoa)                                  
     .              do t797 = 1, xy_k1.DSC.U1 + 2 - min0(1,xy_k1.DSC.U1 + 1)    
     .                 xy_k1(t797-1,t795) = 0.0000000000000000e+000             
     .                 xy_k2(t797-1,t795) = xy_dwradsfluxattoa(t797-1,t795) -   
     .       1            xyr_cdo(t797-1,t795,kmax)                             
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t795 = j4 + 1, xy_k1.DSC.U2, 4                              
     .  !cdir       nodep                                                       
     .  !cdir       on_adb(xy_dwradsfluxattoa)                                  
     .              do t797 = 1, xy_k1.DSC.U1 + 2 - min0(1,xy_k1.DSC.U1 + 1)    
     .                 xy_k1(t797-1,t795) = 0.0000000000000000e+000             
     .                 xy_k1(t797-1,t795+1) = 0.0000000000000000e+000           
     .                 xy_k1(t797-1,t795+2) = 0.0000000000000000e+000           
     .                 xy_k1(t797-1,t795+3) = 0.0000000000000000e+000           
     .                 xy_k2(t797-1,t795) = xy_dwradsfluxattoa(t797-1,t795) -   
     .       1            xyr_cdo(t797-1,t795,kmax)                             
     .                 xy_k2(t797-1,t795+1) = xy_dwradsfluxattoa(t797-1,t795+1) 
     .       1             - xyr_cdo(t797-1,t795+1,kmax)                        
     .                 xy_k2(t797-1,t795+2) = xy_dwradsfluxattoa(t797-1,t795+2) 
     .       1             - xyr_cdo(t797-1,t795+2,kmax)                        
     .                 xy_k2(t797-1,t795+3) = xy_dwradsfluxattoa(t797-1,t795+3) 
     .       1             - xyr_cdo(t797-1,t795+3,kmax)                        
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
     .        goto 10060                                                        
   309        xy_k2 = xy_DWRadSFluxAtTOA - xyr_CDo(:,:,kmax)
   310      else
   311        xy_k2 = &
     .        d6 = 1.D0/lsigma                                                  
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xy_dwradsfluxattoa)                                        
     .        do t715 = 1, jmax*imax                                            
     .           xy_k2(t715-1,1) = (((xy_surfalbedo(t715-1,1)*lsigma)-          
     .       1      1.00000000000000e+000)*(xy_dwradsfluxattoa(t715-1,1)-xyr_cdo
     .       2      (t715-1,1,kmax))*xyr_explamoptdep(t715-1,1,0)+lsigma*(      
     .       3      xy_surfalbedo(t715-1,1)*(xyr_cdo(t715-1,1,0)+solarfluxattoa*
     .       4      xy_cossza(t715-1,1)*xyr_trans(t715-1,1,0))-xyr_cup(t715-1,1,
     .       5      0)))/(((xy_surfalbedo(t715-1,1)*lsigma)-                    
     .       6      1.00000000000000e+000)*xyr_explamoptdep(t715-1,1,0)-(       
     .       7      xy_surfalbedo(t715-1,1)-lsigma)*lsigma/xyr_explamoptdep(t715
     .       8      -1,1,0))                                                    
     .           xy_k1(t715-1,1) = ((xy_dwradsfluxattoa(t715-1,1)-xyr_cdo(t715-1
     .       1      ,1,kmax))-xy_k2(t715-1,1))*d6                               
     .        enddo                                                             
   312          & (                                                 &
   313          &     ( xy_SurfAlbedo * LSigma - 1.0_DP )           &
   314          &       * ( xy_DWRadSFluxAtTOA - xyr_CDo(:,:,kmax) ) * xyr_ExpLamOptDep(:,:,0)  &
   315          &   + LSigma                                                                    &
   316          &       * ( - xyr_CUp(:,:,0)                                                    &
   317          &           + xy_SurfAlbedo * (   xyr_CDo(:,:,0)                                &
   318          &                               + SolarFluxAtTOA * xy_CosSZA * xyr_Trans(:,:,0) ) &
   319          &         )                                                                     &
   320          & ) &
   321          & / &
   322          & ( &
   323          &     ( xy_SurfAlbedo * LSigma - 1.0_DP ) * xyr_ExpLamOptDep(:,:,0) &
   324          &   - ( xy_SurfAlbedo - LSigma ) * LSigma / xyr_ExpLamOptDep(:,:,0) &
   325          & )
   326  
   327        xy_k1 = ( xy_DWRadSFluxAtTOA - xyr_CDo(:,:,kmax) - xy_k2 ) / LSigma
   328      end if
   329  
   330  
   331      ! Calculate radiative flux
   332      !
   333  !!$    do k = 0, kmax
   334  !!$      xyr_RadSFlux(:,:,k) =                                                             &
   335  !!$        &   ( 1.0_DP - LSigma )                                                         &
   336  !!$        &     * ( xy_k1 * xyr_ExpLamOptDep(:,:,k) - xy_k2 / xyr_ExpLamOptDep(:,:,k) )   &
   337  !!$        & + xyr_CUp(:,:,k) - xyr_CDo(:,:,k)
   338  !!$    end do
   339      do k = 0, kmax
   340        xyr_RadSUwFlux(:,:,k) =                         &
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xy_k1,xy_k2)                                               
     .        do t755 = 1, xy_k1.DSC.U2*xy_k1.DSC.U1 + xy_k1.DSC.U2             
     .           xyr_radsuwflux(t755-1,1,k) = (xy_k1(t755-1,1)*xyr_explamoptdep(
     .       1      t755-1,1,k)) + lsigma*xy_k2(t755-1,1)/xyr_explamoptdep(t755-
     .       2      1,1,k) + xyr_cup(t755-1,1,k)                                
     .           xyr_radsdwflux(t755-1,1,k) = (xy_k1(t755-1,1)*xyr_explamoptdep(
     .       1      t755-1,1,k))*lsigma + xy_k2(t755-1,1)/xyr_explamoptdep(t755-
     .       2      1,1,k) + xyr_cdo(t755-1,1,k)                                
     .        enddo                                                             
   341          &            xy_k1 * xyr_ExpLamOptDep(:,:,k)  &
   342          & + LSigma * xy_k2 / xyr_ExpLamOptDep(:,:,k)  &
   343          & + xyr_CUp(:,:,k)
   344        xyr_RadSDwFlux(:,:,k) =                         &
   345          &   LSigma * xy_k1 * xyr_ExpLamOptDep(:,:,k)  &
   346          & +          xy_k2 / xyr_ExpLamOptDep(:,:,k)  &
   347          & + xyr_CDo(:,:,k)
   348      end do
   349  
   350  
   351      if ( .not. FlagSL09LV ) then
   352        !
   353        ! Add direct solar insolation
   354        !
   355  !!$      do k = 0, kmax
   356  !!$        xyr_RadSFlux(:,:,k) = xyr_RadSFlux(:,:,k) &
   357  !!$          & - SolarFluxAtTOA * xyr_Trans(:,:,k) * xy_cosSZA
   358  !!$      end do
   359        do k = 0, kmax
   360          xyr_RadSDwFlux(:,:,k) = xyr_RadSDwFlux(:,:,k) &
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xy_cossza)                                                 
     .        do t783 = 1, jmax*imax                                            
     .           xyr_radsdwflux(t783-1,1,k) = xyr_radsdwflux(t783-1,1,k) +      
     .       1      solarfluxattoa*xyr_trans(t783-1,1,k)*xy_cossza(t783-1,1)    
     .        enddo                                                             
   361            & + SolarFluxAtTOA * xyr_Trans(:,:,k) * xy_cosSZA
   362        end do
   363      end if
   364  
   365      do k = 0, kmax
   366        do j = 1, jmax
   367          do i = 0, imax-1
   368            if( xy_cosSZA(i,j) <= 0.0_DP ) then
   369  !!$            xyr_RadSFlux(i,j,k) = 0.0_DP
   370              xyr_RadSUwFlux(i,j,k) = 0.0_DP
   371              xyr_RadSDwFlux(i,j,k) = 0.0_DP
   372            end if
   373          end do
   374        end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xy_cossza)                                                 
     .        do j = 1, jmax*imax                                               
     .           if (xy_cossza(j-1,1) .le. 0.0000000000000000e+000) then        
     .              xyr_radsuwflux(j-1,1,k) = 0.0000000000000000e+000           
     .              xyr_radsdwflux(j-1,1,k) = 0.0000000000000000e+000           
     .           endif                                                          
     .        enddo                                                             
   375      end do
   376  
   377  
   378    end subroutine RadRTETwoStreamAppHomogAtm
   379  
   380    !------------------------------------------------------------------------------------
   381  
   382    subroutine RadRTETwoStreamAppSW(      &
   383      & xyz_SSA, xyz_AF,                  & ! (in)
   384      & xyr_OptDep,                       & ! (in)
   385      & xy_SurfAlbedo,                    & ! (in)
   386      & SolarFluxTOA, xy_InAngle,         & ! (in)
   387      & xyr_RadUwFlux, xyr_RadDwFlux      & ! (out)
   388      & )
   389  
   390      ! USE statements
   391      !
   392  
   393      real(DP), intent(in ) :: xyz_SSA       ( 0:imax-1, 1:jmax, 1:kmax )
   394      real(DP), intent(in ) :: xyz_AF        ( 0:imax-1, 1:jmax, 1:kmax )
   395      real(DP), intent(in ) :: xyr_OptDep   (0:imax-1, 1:jmax, 0:kmax)
   396      real(DP), intent(in ) :: xy_SurfAlbedo ( 0:imax-1, 1:jmax )
   397      real(DP), intent(in ) :: SolarFluxTOA
   398      real(DP), intent(in ) :: xy_InAngle    (0:imax-1, 1:jmax)
   399                                ! sec (入射角).
   400                                ! sec (angle of incidence)
   401      real(DP), intent(out) :: xyr_RadUwFlux(0:imax-1, 1:jmax, 0:kmax)
   402      real(DP), intent(out) :: xyr_RadDwFlux(0:imax-1, 1:jmax, 0:kmax)
   403  
   404      ! Local variables
   405      !
   406      integer :: IDScatApprox
   407      logical :: FlagTOAFlux
   408      logical :: FlagEmis
   409      logical :: FlagSrcFuncTech
   410  
   411      ! 初期化確認
   412      ! Initialization check
   413      !
   414      if ( .not. rad_rte_two_stream_app_inited ) then
   415        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   416      end if
   417  
   418  
   419      IDScatApprox    = IDScatApproxEddington
   420      FlagTOAFlux     = .true.
   421      FlagEmis        = .false.
   422      FlagSrcFuncTech = .false.
   423  
   424      call RadRTETwoStreamAppWrapper(                     &
   425        & IDScatApprox, FlagTOAFlux, FlagEmis, FlagSrcFuncTech, & ! (in)
   426        & xyz_SSA, xyz_AF,                                & ! (in)
   427        & xyr_OptDep,                                     & ! (in)
   428        & xy_SurfAlbedo,                                  & ! (in)
   429        & xyr_RadUwFlux, xyr_RadDwFlux,                   & ! (out)
   430        & SolarFluxTOA = SolarFluxTOA, xy_InAngle = xy_InAngle        & ! (in) optional
   431        & )
   432  
   433  
   434    end subroutine RadRTETwoStreamAppSW
   435  
   436    !------------------------------------------------------------------------------------
   437  
   438    subroutine RadRTETwoStreamAppLW(                     &
   439      & xyz_SSA, xyz_AF,                                 & ! (in)
   440      & xyr_OptDep,                                      & ! (in)
   441      & xy_SurfAlbedo,                                   & ! (in)
   442      & xyr_PFInted, xy_SurfPFInted, xy_SurfDPFDTInted,  & ! (in)
   443      & xyr_RadUwFlux, xyr_RadDwFlux,                    & ! (out)
   444      & xyra_DelRadUwFlux, xyra_DelRadDwFlux             & ! (out)
   445      & )
   446  
   447      ! USE statements
   448      !
   449  
   450      real(DP), intent(in ) :: xyz_SSA          (0:imax-1, 1:jmax, 1:kmax)
   451      real(DP), intent(in ) :: xyz_AF           (0:imax-1, 1:jmax, 1:kmax)
   452      real(DP), intent(in ) :: xyr_OptDep       (0:imax-1, 1:jmax, 0:kmax)
   453      real(DP), intent(in ) :: xy_SurfAlbedo    (0:imax-1, 1:jmax)
   454      real(DP), intent(in ) :: xyr_PFInted      (0:imax-1, 1:jmax, 0:kmax)
   455      real(DP), intent(in ) :: xy_SurfPFInted   (0:imax-1, 1:jmax)
   456      real(DP), intent(in ) :: xy_SurfDPFDTInted(0:imax-1, 1:jmax)
   457      real(DP), intent(out) :: xyr_RadUwFlux    (0:imax-1, 1:jmax, 0:kmax)
   458      real(DP), intent(out) :: xyr_RadDwFlux    (0:imax-1, 1:jmax, 0:kmax)
   459      real(DP), intent(out) :: xyra_DelRadUwFlux(0:imax-1, 1:jmax, 0:kmax, 0:1)
   460      real(DP), intent(out) :: xyra_DelRadDwFlux(0:imax-1, 1:jmax, 0:kmax, 0:1)
   461  
   462  
   463      ! Local variables
   464      !
   465      integer :: IDScatApprox
   466      logical :: FlagTOAFlux
   467      logical :: FlagEmis
   468      logical :: FlagSrcFuncTech
   469  
   470  
   471      ! 初期化確認
   472      ! Initialization check
   473      !
   474      if ( .not. rad_rte_two_stream_app_inited ) then
   475        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   476      end if
   477  
   478  
   479      IDScatApprox    = IDScatApproxHemiMean
   480      FlagTOAFlux     = .false.
   481      FlagEmis        = .true.
   482      FlagSrcFuncTech = .true.
   483  
   484      call RadRTETwoStreamAppWrapper(                     &
   485        & IDScatApprox, FlagTOAFlux, FlagEmis, FlagSrcFuncTech,  & ! (in)
   486        & xyz_SSA, xyz_AF,                                & ! (in)
   487        & xyr_OptDep,                                     & ! (in)
   488        & xy_SurfAlbedo,                                  & ! (in)
   489        & xyr_RadUwFlux, xyr_RadDwFlux,                   & ! (out)
   490        & xyr_PFInted = xyr_PFInted, xy_SurfPFInted = xy_SurfPFInted, xy_SurfDPFDTInted = xy_SurfDPFDTInted,    & ! (in) optional
   491        & xyra_DelRadUwFlux = xyra_DelRadUwFlux, xyra_DelRadDwFlux = xyra_DelRadDwFlux     & ! (out) optional
   492        & )
   493  
   494  
   495    end subroutine RadRTETwoStreamAppLW
   496  
   497    !--------------------------------------------------------------------------------------
   498    ! NOTE:
   499    ! xyr_PFInted    = \pi B
   500    ! xy_SurfPFInted = \epsilon \pi B
   501    !--------------------------------------------------------------------------------------
   502  
   503    subroutine RadRTETwoStreamAppWrapper(                &
   504      & IDScatApprox, FlagTOAFlux, FlagEmis, FlagSrcFuncTech,  & ! (in)
   505      & xyz_SSA, xyz_AF,                                 & ! (in)
   506      & xyr_OptDep,                                      & ! (in)
   507      & xy_SurfAlbedo,                                   & ! (in)
   508      & xyr_RadUwFlux, xyr_RadDwFlux,                    & ! (out)
   509      & SolarFluxTOA, xy_InAngle,                        & ! (in) optional
   510      & xyr_PFInted, xy_SurfPFInted, xy_SurfDPFDTInted,  & ! (in) optional
   511      & xyra_DelRadUwFlux, xyra_DelRadDwFlux             & ! (out) optional
   512      & )
   513  
   514      ! USE statements
   515      !
   516  
   517      ! OpenMP
   518      !
   519      !$ use omp_lib
   520  
   521  
   522      integer , intent(in ) :: IDScatApprox
   523      logical , intent(in ) :: FlagTOAFlux
   524      logical , intent(in ) :: FlagEmis
   525      logical , intent(in ) :: FlagSrcFuncTech
   526      real(DP), intent(in ) :: xyz_SSA       ( 0:imax-1, 1:jmax, 1:kmax )
   527      real(DP), intent(in ) :: xyz_AF        ( 0:imax-1, 1:jmax, 1:kmax )
   528      real(DP), intent(in ) :: xyr_OptDep   (0:imax-1, 1:jmax, 0:kmax)
   529      real(DP), intent(in ) :: xy_SurfAlbedo ( 0:imax-1, 1:jmax )
   530      real(DP), intent(out) :: xyr_RadUwFlux(0:imax-1, 1:jmax, 0:kmax)
   531      real(DP), intent(out) :: xyr_RadDwFlux(0:imax-1, 1:jmax, 0:kmax)
   532  
   533      real(DP), intent(in ), optional :: SolarFluxTOA
   534      real(DP), intent(in ), optional :: xy_InAngle    (0:imax-1, 1:jmax)
   535                                ! sec (入射角).
   536                                ! sec (angle of incidence)
   537      real(DP), intent(in ), optional :: xyr_PFInted      (0:imax-1, 1:jmax, 0:kmax)
   538      real(DP), intent(in ), optional :: xy_SurfPFInted   (0:imax-1, 1:jmax)
   539      real(DP), intent(in ), optional :: xy_SurfDPFDTInted(0:imax-1, 1:jmax)
   540      real(DP), intent(out), optional :: xyra_DelRadUwFlux(0:imax-1, 1:jmax, 0:kmax, 0:1)
   541      real(DP), intent(out), optional :: xyra_DelRadDwFlux(0:imax-1, 1:jmax, 0:kmax, 0:1)
   542  
   543      ! Local variables
   544      !
   545      integer :: js
   546      integer :: je
   547  
   548      integer :: nthreads
   549      integer, allocatable :: a_js(:)
   550      integer, allocatable :: a_je(:)
   551  
   552      integer :: n
   553  
   554  
   555      ! 初期化確認
   556      ! Initialization check
   557      !
   558      if ( .not. rad_rte_two_stream_app_inited ) then
   559        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   560      end if
   561  
   562  
   563      !
   564      ! Arguments are checked.
   565      !
   566      if ( FlagTOAFlux ) then
   567        if ( .not. present( SolarFluxTOA ) ) &
   568          & call MessageNotify( 'E', module_name, 'SolarFluxTOA has to be present.' )
   569        if ( .not. present( xy_InAngle ) ) &
   570          & call MessageNotify( 'E', module_name, 'xy_InAngle has to be present.' )
   571      else
   572        if ( present( SolarFluxTOA ) ) &
   573          & call MessageNotify( 'E', module_name, 'SolarFluxTOA need not be present.' )
   574        if ( present( xy_InAngle ) ) &
   575          & call MessageNotify( 'E', module_name, 'xy_InAngle need not be present.' )
   576      end if
   577  
   578      if ( FlagEmis ) then
   579        if ( .not. present( xyr_PFInted ) ) &
   580          & call MessageNotify( 'E', module_name, 'xyr_PFInted has to be present.' )
   581        if ( .not. present( xy_SurfPFInted ) ) &
   582          & call MessageNotify( 'E', module_name, 'xy_SurfPFInted has to be present.' )
   583        if ( .not. present( xy_SurfDPFDTInted ) ) &
   584          & call MessageNotify( 'E', module_name, 'xy_SurfDPFDTInted has to be present.' )
   585        if ( .not. present( xyra_DelRadUwFlux ) ) &
   586          & call MessageNotify( 'E', module_name, 'xyra_DelRadUwFlux has to be present.' )
   587        if ( .not. present( xyra_DelRadDwFlux ) ) &
   588          & call MessageNotify( 'E', module_name, 'xyra_DelRadLwFlux has to be present.' )
   589      else
   590        if ( present( xyr_PFInted ) ) &
   591          & call MessageNotify( 'E', module_name, 'xyr_PFInted need not be present.' )
   592        if ( present( xy_SurfPFInted ) ) &
   593          & call MessageNotify( 'E', module_name, 'xy_SurfPFInted need not be present.' )
   594        if ( present( xy_SurfDPFDTInted ) ) &
   595          & call MessageNotify( 'E', module_name, 'xy_SurfDPFDTInted need not be present.' )
   596        if ( present( xyra_DelRadUwFlux ) ) &
   597          & call MessageNotify( 'E', module_name, 'xyra_DelRadUwFlux need not be present.' )
   598        if ( present( xyra_DelRadDwFlux ) ) &
   599          & call MessageNotify( 'E', module_name, 'xyra_DelRadLwFlux need not be present.' )
   600      end if
   601  
   602  
   603      nthreads = 1
   604      !$ nthreads  = omp_get_max_threads()
   605  !!$    !$ write( 6, * ) "Number of processors : ", omp_get_num_procs()
   606  !!$    !$ write( 6, * ) "Number of threads    : ", nthreads
   607  
   608      allocate( a_js(0:nthreads-1) )
   609      allocate( a_je(0:nthreads-1) )
   610  
   611      do n = 0, nthreads-1
   612  
   613        if ( n == 0 ) then
   614          a_js(n) = 1
   615        else
   616          a_js(n) = a_je(n-1) + 1
   617        end if
   618  
   619        a_je(n) = a_js(n  ) + jmax / nthreads - 1
   620        if ( n + 1 <= mod( jmax, nthreads ) ) then
   621          a_je(n) = a_je(n) + 1
   622        end if
   623  
   624      end do
   625  
   626  
   627  !!$    !$OMP PARALLEL DEFAULT(PRIVATE) &
   628  !!$    !$OMP SHARED(nthreads,a_js,a_je, &
   629  !!$    !$OMP        xyz_SSA, xyz_AF, &
   630  !!$    !$OMP        SolarFluxTOA, &
   631  !!$    !$OMP        xy_SurfAlbedo, &
   632  !!$    !$OMP        IDScatApprox, FlagTOAFlux, FlagEmis, FlagSrcFuncTech, &
   633  !!$    !$OMP        xy_InAngle, &
   634  !!$    !$OMP        xyr_OptDep, &
   635  !!$    !$OMP        xyr_RadUwFlux, &
   636  !!$    !$OMP        xyr_RadDwFlux, &
   637  !!$    !$OMP        xyr_PFInted, xy_SurfPFInted, xy_SurfDPFDTInted, &
   638  !!$    !$OMP        xyra_DelRadUwFlux, xyra_DelRadDwFlux)
   639  !!$
   640  !!$    !$OMP DO
   641  
   642      do n = 0, nthreads-1
   643  
   644        js = a_js(n)
   645        je = a_je(n)
   646  
   647        if ( js > je ) cycle
   648  
   649  !!$      write( 6, * ) n, js, je
   650  
   651        call RadRTETwoStreamAppCore(              &
   652          & IDScatApprox, FlagTOAFlux, FlagEmis, FlagSrcFuncTech, & ! (in)
   653          & xyz_SSA, xyz_AF,                      & ! (in)
   654          & xyr_OptDep,                           & ! (in)
   655          & xy_SurfAlbedo,                        & ! (in)
   656          & xyr_RadUwFlux, xyr_RadDwFlux,         & ! (out)
   657          & js, je,                               & ! (in)
   658          & SolarFluxTOA = SolarFluxTOA, xy_InAngle = xy_InAngle,      & ! (in) optional
   659          & xyr_PFInted = xyr_PFInted, xy_SurfPFInted = xy_SurfPFInted, xy_SurfDPFDTInted = xy_SurfDPFDTInted,    & ! (in) optional
   660          & xyra_DelRadUwFlux = xyra_DelRadUwFlux, xyra_DelRadDwFlux = xyra_DelRadDwFlux     & ! (out) optional
   661          & )
   662  
   663      end do
   664  
   665  
   666  !!$    !$OMP END DO
   667  !!$    !$OMP END PARALLEL
   668  
   669  
   670      deallocate( a_js )
   671      deallocate( a_je )
   672  
   673  
   674  
   675    end subroutine RadRTETwoStreamAppWrapper
   676  
   677    !--------------------------------------------------------------------------------------
   678    ! NOTE:
   679    ! xyr_PFInted    = \pi B
   680    ! xy_SurfPFInted = \epsilon \pi B
   681    !--------------------------------------------------------------------------------------
   682  
   683    subroutine RadRTETwoStreamAppCore(                         &
   684      & IDScatApprox, FlagTOAFlux, FlagEmis, FlagSrcFuncTech,  & ! (in)
   685      & xyz_SSA, xyz_AF,                                       & ! (in)
   686      & xyr_OptDep,                                            & ! (in)
   687      & xy_SurfAlbedo,                                         & ! (in)
   688      & xyr_RadUwFlux, xyr_RadDwFlux,                          & ! (out)
   689      & js, je,                                                & ! (in)
   690      & SolarFluxTOA, xy_InAngle,                              & ! (in) optional
   691      & xyr_PFInted, xy_SurfPFInted, xy_SurfDPFDTInted,        & ! (in) optional
   692      & xyra_DelRadUwFlux, xyra_DelRadDwFlux                   & ! (out) optional
   693      & )
   694  
   695      ! USE statements
   696      !
   697  
   698  !!$  use pf_module , only : pfint_gq_array
   699  
   700  
   701      integer , intent(in ) :: IDScatApprox
   702      logical , intent(in ) :: FlagTOAFlux
   703      logical , intent(in ) :: FlagEmis
   704      logical , intent(in ) :: FlagSrcFuncTech
   705      real(DP), intent(in ) :: xyz_SSA      (0:imax-1, 1:jmax, 1:kmax)
   706      real(DP), intent(in ) :: xyz_AF       (0:imax-1, 1:jmax, 1:kmax)
   707      real(DP), intent(in ) :: xyr_OptDep   (0:imax-1, 1:jmax, 0:kmax)
   708      real(DP), intent(in ) :: xy_SurfAlbedo(0:imax-1, 1:jmax)
   709      real(DP), intent(out) :: xyr_RadUwFlux(0:imax-1, 1:jmax, 0:kmax)
   710      real(DP), intent(out) :: xyr_RadDwFlux(0:imax-1, 1:jmax, 0:kmax)
   711  
   712      integer , intent(in ) :: js
   713      integer , intent(in ) :: je
   714  
   715      real(DP), intent(in ), optional :: SolarFluxTOA
   716      real(DP), intent(in ), optional :: xy_InAngle    (0:imax-1, 1:jmax)
   717                                ! sec (入射角).
   718                                ! sec (angle of incidence)
   719      real(DP), intent(in ), optional :: xyr_PFInted      (0:imax-1, 1:jmax, 0:kmax)
   720      real(DP), intent(in ), optional :: xy_SurfPFInted   (0:imax-1, 1:jmax)
   721      real(DP), intent(in ), optional :: xy_SurfDPFDTInted(0:imax-1, 1:jmax)
   722      real(DP), intent(out), optional :: xyra_DelRadUwFlux(0:imax-1, 1:jmax, 0:kmax, 0:1)
   723      real(DP), intent(out), optional :: xyra_DelRadDwFlux(0:imax-1, 1:jmax, 0:kmax, 0:1)
   724  
   725  
   726  !!$    real(DP), intent(in ) :: gt         ( 0:imax-1, 1:jmax, 1:kmax )
   727  !!$    real(DP), intent(in ) :: gts        ( 0:imax-1, 1:jmax )
   728  !!$    real(DP), intent(in ) :: gph        ( 0:imax-1, 1:jmax, 0:kmax )
   729  
   730  !!$    real(DP), intent(in ) :: emis  ( 0:imax-1, 1:jmax )
   731  !!$    real(DP), intent(in ) :: wn1, wn2
   732  !!$    integer , intent(in ) :: divnum
   733  
   734  
   735  !!$  real(DP)    , intent(out) :: &
   736  !!$    gor ( im, jm ), goru ( im, jm ), gord ( im, jm ), &
   737  !!$    gsr ( im, jm ), gsru ( im, jm ), gsrd ( im, jm )
   738  
   739      real(DP) :: xy_SolarFluxTOA(0:imax-1, 1:jmax)
   740  
   741      !
   742      ! SSAAdj    : Delta-Function Adjusted Single-Scattering Albedo
   743      ! AFAdj     : Delta-Function Adjusted Asymmetry Factor
   744      ! OpDepAdj  : Delta-Function Adjusted Optical Depth
   745      !
   746      real(DP) :: xyz_SSAAdj     ( 0:imax-1, 1:jmax, 1:kmax )
   747      real(DP) :: xyz_AFAdj      ( 0:imax-1, 1:jmax, 1:kmax )
   748      real(DP) :: xyr_OpDepAdj   ( 0:imax-1, 1:jmax, 0:kmax )
   749      real(DP) :: xyr_TransDirAdj( 0:imax-1, 1:jmax, 0:kmax )
   750  
   751      !
   752      ! gam?    : Coefficients of Generalized Radiative Transfer Equation
   753      !
   754      real(DP) :: xyz_Gam1( 0:imax-1, 1:jmax, 1:kmax )
   755      real(DP) :: xyz_Gam2( 0:imax-1, 1:jmax, 1:kmax )
   756      real(DP) :: xyz_Gam3( 0:imax-1, 1:jmax, 1:kmax )
   757      real(DP) :: xyz_Gam4( 0:imax-1, 1:jmax, 1:kmax )
   758  
   759      !
   760      ! cosz     : cosine of solar zenith angle
   761      ! cosz2    : cosz squared
   762      !
   763      real(DP) :: xy_cosSZA     ( 0:imax-1, 1:jmax )
   764      real(DP) :: xy_cosSZAInv  ( 0:imax-1, 1:jmax )
   765      real(DP) :: xy_cosSZAInvsq( 0:imax-1, 1:jmax )
   766  
   767      !
   768      ! temporary variables
   769      !
   770      real(DP) :: xyz_DelTau( 0:imax-1, 1:jmax, 1:kmax )
   771  
   772      real(DP) :: xyz_Lambda ( 0:imax-1, 1:jmax, 1:kmax )
   773      real(DP) :: xyz_LGamma ( 0:imax-1, 1:jmax, 1:kmax )
   774      real(DP) :: xyaz_smalle( 0:imax-1, 1:jmax, 4, 1:kmax )
   775  
   776      real(DP) :: xy_SurfSrc( 0:imax-1, 1:jmax )
   777  
   778      !
   779      ! CUpB      : upward C at bottom of layer
   780      ! CUpT      : upward C at top of layer
   781      ! CDoB      : downward C at bottom of layer
   782      ! CDoT      : downward C at top of layer
   783      !
   784      real(DP) :: xyz_CUpB( 0:imax-1, 1:jmax, 1:kmax )
   785      real(DP) :: xyz_CUpT( 0:imax-1, 1:jmax, 1:kmax )
   786      real(DP) :: xyz_CDoB( 0:imax-1, 1:jmax, 1:kmax )
   787      real(DP) :: xyz_CDoT( 0:imax-1, 1:jmax, 1:kmax )
   788      !
   789      real(DP) :: xyz_CUpBDir( 0:imax-1, 1:jmax, 1:kmax )
   790      real(DP) :: xyz_CUpTDir( 0:imax-1, 1:jmax, 1:kmax )
   791      real(DP) :: xyz_CDoBDir( 0:imax-1, 1:jmax, 1:kmax )
   792      real(DP) :: xyz_CDoTDir( 0:imax-1, 1:jmax, 1:kmax )
   793      !
   794      real(DP) :: xyz_CUpBEmi( 0:imax-1, 1:jmax, 1:kmax )
   795      real(DP) :: xyz_CUpTEmi( 0:imax-1, 1:jmax, 1:kmax )
   796      real(DP) :: xyz_CDoBEmi( 0:imax-1, 1:jmax, 1:kmax )
   797      real(DP) :: xyz_CDoTEmi( 0:imax-1, 1:jmax, 1:kmax )
   798  
   799      real(DP) :: aa_TridiagMtx1( 1:imax*jmax, 1:kmax*2 )
   800      real(DP) :: aa_TridiagMtx2( 1:imax*jmax, 1:kmax*2 )
   801      real(DP) :: aa_TridiagMtx3( 1:imax*jmax, 1:kmax*2 )
   802      real(DP) :: aa_Vec        ( 1:imax*jmax, 1:kmax*2 )
   803  
   804      real(DP) :: xy_TMPVal( 0:imax-1, 1:jmax )
   805  
   806      real(DP) :: xyz_B0( 0:imax-1, 1:jmax, 1:kmax )
   807      real(DP) :: xyz_B1( 0:imax-1, 1:jmax, 1:kmax )
   808  
   809      real(DP) :: Mu
   810      real(DP) :: xyz_Mu1( 0:imax-1, 1:jmax, 1:kmax )
   811  
   812  !!$  real(DP) :: gth( im, jm, km+1 ), pfinth( im, jm, km+1 )
   813  !!$  real(DP) :: b0( ijs:ije, 1, km ), b1( ijs:ije, 1, km )
   814  !!$  real(DP) :: gemis
   815  
   816  
   817      real(DP) :: xyr_IUw( 0:imax-1, 1:jmax, 0:kmax )
   818      real(DP) :: xyr_IDw( 0:imax-1, 1:jmax, 0:kmax )
   819      real(DP) :: FactG
   820      real(DP) :: FactH
   821      real(DP) :: FactJ
   822      real(DP) :: FactK
   823      real(DP) :: Alp1
   824      real(DP) :: Alp2
   825      real(DP) :: Sig1
   826      real(DP) :: Sig2
   827  
   828      integer  :: i, j, k, l
   829      integer  :: ms, me
   830  
   831  
   832      ! Variables for debug
   833      !
   834  !!$    real(DP) :: xyr_UwFluxDebug( 0:imax-1, 1:jmax, 0:kmax )
   835  !!$    real(DP) :: xyr_DwFluxDebug( 0:imax-1, 1:jmax, 0:kmax )
   836  
   837  
   838      ! 初期化確認
   839      ! Initialization check
   840      !
   841      if ( .not. rad_rte_two_stream_app_inited ) then
   842        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   843      end if
   844  
   845  
   846      !
   847      ! Arguments are checked.
   848      !
   849      if ( FlagTOAFlux ) then
   850        if ( .not. present( SolarFluxTOA ) ) &
   851          & call MessageNotify( 'E', module_name, 'SolarFluxTOA has to be present.' )
   852        if ( .not. present( xy_InAngle ) ) &
   853          & call MessageNotify( 'E', module_name, 'xy_InAngle has to be present.' )
   854      else
   855        if ( present( SolarFluxTOA ) ) &
   856          & call MessageNotify( 'E', module_name, 'SolarFluxTOA need not be present.' )
   857        if ( present( xy_InAngle ) ) &
   858          & call MessageNotify( 'E', module_name, 'xy_InAngle need not be present.' )
   859      end if
   860  
   861      if ( FlagEmis ) then
   862        if ( .not. present( xyr_PFInted ) ) &
   863          & call MessageNotify( 'E', module_name, 'xyr_PFInted has to be present.' )
   864        if ( .not. present( xy_SurfPFInted ) ) &
   865          & call MessageNotify( 'E', module_name, 'xy_SurfPFInted has to be present.' )
   866        if ( .not. present( xy_SurfDPFDTInted ) ) &
   867          & call MessageNotify( 'E', module_name, 'xy_SurfDPFDTInted has to be present.' )
   868        if ( .not. present( xyra_DelRadUwFlux ) ) &
   869          & call MessageNotify( 'E', module_name, 'xyra_DelRadUwFlux has to be present.' )
   870        if ( .not. present( xyra_DelRadDwFlux ) ) &
   871          & call MessageNotify( 'E', module_name, 'xyra_DelRadLwFlux has to be present.' )
   872      else
   873        if ( present( xyr_PFInted ) ) &
   874          & call MessageNotify( 'E', module_name, 'xyr_PFInted need not be present.' )
   875        if ( present( xy_SurfPFInted ) ) &
   876          & call MessageNotify( 'E', module_name, 'xy_SurfPFInted need not be present.' )
   877        if ( present( xy_SurfDPFDTInted ) ) &
   878          & call MessageNotify( 'E', module_name, 'xy_SurfDPFDTInted need not be present.' )
   879        if ( present( xyra_DelRadUwFlux ) ) &
   880          & call MessageNotify( 'E', module_name, 'xyra_DelRadUwFlux need not be present.' )
   881        if ( present( xyra_DelRadDwFlux ) ) &
   882          & call MessageNotify( 'E', module_name, 'xyra_DelRadLwFlux need not be present.' )
   883      end if
   884  
   885  
   886      do k = 1, kmax
   887        do j = js, je
   888          do i = 0, imax-1
   889            if ( xyz_SSA(i,j,k) >= 1.0d0 ) then
   890              call MessageNotify( 'E', module_name, 'Single Scattering Albedo = %f', &
   891                & d = (/ xyz_SSA(i,j,k) /) )
   892            end if
   893          end do
   894        end do
   895      end do
   896  
   897  
   898      if ( FlagTOAFlux ) then
   899  
   900        do j = js, je
   901          do i = 0, imax-1
   902            if ( xy_InAngle(i,j) > 0.0d0 ) then
   903              xy_cosSZA     (i,j) = 1.0d0 / xy_InAngle(i,j)
   904              xy_cosSZAInv  (i,j) = xy_InAngle(i,j)
   905              xy_cosSZAInvsq(i,j) = xy_cosSZAInv(i,j)**2
   906            else
   907              xy_cosSZA     (i,j) = 0.0d0
   908              xy_cosSZAInv  (i,j) = 0.0d0
   909              xy_cosSZAInvsq(i,j) = 0.0d0
   910            end if
   911          end do
   912        end do
   913  
   914        do j = js, je
   915          do i = 0, imax-1
   916            if ( xy_InAngle(i,j) > 0.0d0 ) then
   917              xy_SolarFluxTOA(i,j) = SolarFluxTOA
   918            else
   919              xy_SolarFluxTOA(i,j) = 0.0_DP
   920            end if
   921          end do
   922        end do
   923  
   924      else
   925  
   926        do j = js, je
   927          xy_cosSZA     (:,j) = 1.0d100
   928          xy_cosSZAInv  (:,j) = 1.0d100
   929          xy_cosSZAInvsq(:,j) = 1.0d100
   930        end do
   931  
   932        do j = js, je
   933          do i = 0, imax-1
   934            xy_SolarFluxTOA(i,j) = 1.0d100
   935          end do
   936        end do
   937  
   938      end if
   939  
   940  
   941      !
   942      ! Delta-Function Adjustment
   943      !
   944      do k = 1, kmax
   945        do j = js, je
   946          xyz_AFAdj (:,j,k) = xyz_AF(:,j,k) / ( 1.0d0 + xyz_AF(:,j,k) )
   947          xyz_SSAAdj(:,j,k) =   ( 1.0d0 - xyz_AF(:,j,k)**2 ) * xyz_SSA(:,j,k) &
   948            &               / ( 1.0d0 - xyz_SSA(:,j,k) * xyz_AF(:,j,k)**2 )
   949        end do
   950      end do
   951      !
   952      do k = 0, kmax
   953        do j = js, je
   954          xyr_OpDepAdj(:,j,k) = 0.0d0
   955        end do
   956      end do
   957      do k = kmax-1, 0, -1
   958        do j = js, je
   959          xyr_OpDepAdj(:,j,k) =                                       &
   960            &   xyr_OpDepAdj(:,j,k+1)                                 &
   961            & + ( 1.0d0 - xyz_SSA(:,j,k+1) * xyz_AF(:,j,k+1)**2 )     &
   962            &   * ( xyr_OptDep(:,j,k) - xyr_OptDep(:,j,k+1) )
   963        end do
   964      end do
   965  
   966  
   967      if ( FlagTOAFlux ) then
   968        do k = 0, kmax
   969          do j = js, je
   970            xyr_TransDirAdj(:,j,k) = exp( -xyr_OpDepAdj(:,j,k) * xy_cosSZAInv(:,j) )
   971          end do
   972        end do
   973      else
   974        do k = 0, kmax
   975          do j = js, je
   976            xyr_TransDirAdj(:,j,k) = 1.0d100
   977          end do
   978        end do
   979      end if
   980  
   981  
   982      select case ( IDScatApprox )
   983      case ( IDScatApproxEddington )
   984  
   985        !
   986        ! Eddington approximation
   987        !
   988        do k = 1, kmax
   989          do j = js, je
   990            xyz_Gam1(:,j,k) =  ( 7.0d0 - xyz_SSAAdj(:,j,k) * ( 4.0d0 + 3.0d0 * xyz_AFAdj(:,j,k) ) ) / 4.0d0
   991            xyz_Gam2(:,j,k) = -( 1.0d0 - xyz_SSAAdj(:,j,k) * ( 4.0d0 - 3.0d0 * xyz_AFAdj(:,j,k) ) ) / 4.0d0
   992            xyz_Gam3(:,j,k) =  ( 2.0d0 - 3.0d0 * xyz_AFAdj(:,j,k) * xy_cosSZA(:,j) )              / 4.0d0
   993            xyz_Gam4(:,j,k) = 1.0d0 - xyz_Gam3(:,j,k)
   994          end do
   995        end do
   996  
   997        do k = 1, kmax
   998          do j = js, je
   999            do i = 0, imax-1
  1000  !!$            xyz_Mu1(i,j,k) = ( 1.0_DP - xyz_SSAAdj(i,j,k) ) / ( xyz_Gam1(i,j,k) - xyz_Gam2(i,j,k) )
  1001              xyz_Mu1(i,j,k) = 0.5_DP
  1002            end do
  1003          end do
  1004        end do
  1005  
  1006      case ( IDScatApproxHemiMean )
  1007  
  1008        !
  1009        ! Treatment if delta-function adjustment is not performed.
  1010        !
  1011  !!$      do k = 1, kmax
  1012  !!$        do j = js, je
  1013  !!$          xyz_AFAdj (:,j,k) = xyz_AF (:,j,k)
  1014  !!$          xyz_SSAAdj(:,j,k) = xyz_SSA(:,j,k)
  1015  !!$        end do
  1016  !!$      end do
  1017  !!$      do k = 0, kmax
  1018  !!$        do j = js, je
  1019  !!$          xyr_OpDepAdj(:,j,k) = xyr_OptDep(:,j,k)
  1020  !!$        end do
  1021  !!$      end do
  1022  
  1023        !
  1024        ! Hemispheric mean approximation
  1025        !
  1026        do k = 1, kmax
  1027          do j = js, je
  1028            xyz_Gam1(:,j,k) = 2.0_DP - xyz_SSAAdj(:,j,k) * ( 1.0_DP + xyz_AFAdj(:,j,k) )
  1029            xyz_Gam2(:,j,k) = xyz_SSAAdj(:,j,k) * ( 1.0_DP - xyz_AFAdj(:,j,k) )
  1030            xyz_Gam3(:,j,k) = 1.0d100
  1031            xyz_Gam4(:,j,k) = 1.0d100
  1032          end do
  1033        end do
  1034  
  1035        do k = 1, kmax
  1036          do j = js, je
  1037            do i = 0, imax-1
  1038  !!$            xyz_Mu1(i,j,k) = ( 1.0_DP - xyz_SSAAdj(i,j,k) ) / ( xyz_Gam1(i,j,k) - xyz_Gam2(i,j,k) )
  1039              xyz_Mu1(i,j,k) = 0.5_DP
  1040            end do
  1041          end do
  1042        end do
  1043  
  1044      case default
  1045        call MessageNotify( 'E', module_name, 'Unexpected IDScatApprox, %d', &
  1046          & i = (/ IDScatApprox /) )
  1047      end select
  1048  
  1049  
  1050      do k = 1, kmax
  1051        do j = js, je
  1052          xyz_DelTau(:,j,k) = xyr_OpDepAdj(:,j,k-1) - xyr_OpDepAdj(:,j,k)
  1053        end do
  1054      end do
  1055  
  1056  
  1057      if ( FlagEmis ) then
  1058        !
  1059        ! Avoiding singularity when dtau equal to zero
  1060        !
  1061        do k = 1, kmax
  1062          do j = js, je
  1063            do i = 0, imax-1
  1064              if( xyz_DelTau(i,j,k) < DelTauThreshold ) then
  1065                xyz_DelTau(i,j,k) = 0.0d0
  1066              end if
  1067            end do
  1068          end do
  1069        end do
  1070      end if
  1071  
  1072  
  1073      do k = 1, kmax
  1074        do j = js, je
  1075          ! In very small parameter space of single scattering albedo and asymmetry
  1076          ! factor close to asymmetry factor of 1, xyz_Gam1**2 - xyz_Gam2**2 becomes
  1077          ! negative value. (yot, 2011/11/20)
  1078  !!$        xyz_Lambda(:,j,k) = sqrt( xyz_Gam1(:,j,k) * xyz_Gam1(:,j,k) - xyz_Gam2(:,j,k) * xyz_Gam2(:,j,k) )
  1079          xyz_Lambda(:,j,k) = sqrt( max( xyz_Gam1(:,j,k) * xyz_Gam1(:,j,k) - xyz_Gam2(:,j,k) * xyz_Gam2(:,j,k), 0.0_DP ) )
  1080  !!$        xyz_Lambda(:,j,k) = sqrt( xyz_Gam1(:,j,k) * xyz_Gam1(:,j,k) - xyz_Gam2(:,j,k) * xyz_Gam2(:,j,k) + 1.0d-10 )
  1081  
  1082          xyz_LGamma(:,j,k) = xyz_Gam2(:,j,k) / ( xyz_Gam1(:,j,k) + xyz_Lambda(:,j,k) )
  1083        end do
  1084      end do
  1085  
  1086      do k = 1, kmax
  1087        do j = js, je
  1088          xy_TMPVal(:,j)       = exp( - xyz_Lambda(:,j,k) * xyz_DelTau(:,j,k) )
  1089          xyaz_smalle(:,j,1,k) = xyz_LGamma(:,j,k) * xy_TMPVal(:,j) + 1.0_DP
  1090          xyaz_smalle(:,j,2,k) = xyz_LGamma(:,j,k) * xy_TMPVal(:,j) - 1.0_DP
  1091          xyaz_smalle(:,j,3,k) = xy_TMPVal(:,j) + xyz_LGamma(:,j,k)
  1092          xyaz_smalle(:,j,4,k) = xy_TMPVal(:,j) - xyz_LGamma(:,j,k)
  1093        end do
  1094      end do
  1095  
  1096  
  1097      if ( FlagTOAFlux ) then
  1098        do k = 1, kmax
  1099          do j = js, je
  1100            xy_TMPVal(:,j) =                                                        &
  1101              &   xyz_SSAAdj(:,j,k) * xy_SolarFluxTOA(:,j)                          &
  1102              &   * ( ( xyz_Gam1(:,j,k) - xy_cosSZAInv(:,j) ) * xyz_Gam3(:,j,k)     &
  1103              &       + xyz_Gam2(:,j,k) * xyz_Gam4(:,j,k) )                         &
  1104              &   / ( xyz_Lambda(:,j,k) * xyz_Lambda(:,j,k) - xy_cosSZAInvsq(:,j) )
  1105            xyz_CUpBDir(:,j,k) = xy_TMPVal(:,j) * xyr_TransDirAdj(:,j,k-1)
  1106            xyz_CUpTDir(:,j,k) = xy_TMPVal(:,j) * xyr_TransDirAdj(:,j,k  )
  1107            !
  1108            xy_TMPVal(:,j) =                                                        &
  1109              &   xyz_SSAAdj(:,j,k) * xy_SolarFluxTOA(:,j)                          &
  1110              &   * ( ( xyz_Gam1(:,j,k) + xy_cosSZAInv(:,j) ) * xyz_Gam4(:,j,k)     &
  1111              &       + xyz_Gam2(:,j,k) * xyz_Gam3(:,j,k) )                         &
  1112              &   / ( xyz_Lambda(:,j,k) * xyz_Lambda(:,j,k) - xy_cosSZAInvsq(:,j) )
  1113            xyz_CDoBDir(:,j,k) = xy_TMPVal(:,j) * xyr_TransDirAdj(:,j,k-1)
  1114            xyz_CDoTDir(:,j,k) = xy_TMPVal(:,j) * xyr_TransDirAdj(:,j,k  )
  1115          end do
  1116        end do
  1117      else
  1118        do k = 1, kmax
  1119          do j = js, je
  1120            xyz_CUpBDir(:,j,k) = 0.0_DP
  1121            xyz_CUpTDir(:,j,k) = 0.0_DP
  1122            xyz_CDoBDir(:,j,k) = 0.0_DP
  1123            xyz_CDoTDir(:,j,k) = 0.0_DP
  1124          end do
  1125        end do
  1126      end if
  1127  
  1128  
  1129      if ( FlagEmis ) then
  1130  
  1131        do k = 1, kmax
  1132          do j = js, je
  1133            do i = 0, imax-1
  1134              !
  1135              ! Notice!
  1136              ! Avoiding singularity when dtau equal to zero.
  1137              ! dtau occationally has much smaller value.
  1138              ! When this occurs, b1 cannot be calculated correctly.
  1139              !
  1140              if( xyz_DelTau(i,j,k) /= 0.0_DP ) then
  1141                xyz_B0(i,j,k) = xyr_PFInted(i,j,k)
  1142                xyz_B1(i,j,k) = ( xyr_PFInted(i,j,k-1) - xyr_PFInted(i,j,k) ) / xyz_DelTau(i,j,k)
  1143              else
  1144  !!$              xyz_B0(i,j,k) = 0.0_DP ! replace with a line below 2015/02/22 based on discussion with Onishi-san
  1145                xyz_B0(i,j,k) = xyr_PFInted(i,j,k)
  1146                xyz_B1(i,j,k) = 0.0_DP
  1147              end if
  1148            end do
  1149          end do
  1150        end do
  1151  
  1152        do k = 1, kmax
  1153          do j = js, je
  1154            do i = 0, imax-1
  1155  !!$            xyz_CUpB(i,j,k) = 2.0_DP * PI * Mu1 &
  1156              xyz_CUpBEmi(i,j,k) = 2.0_DP * xyz_Mu1(i,j,k) &
  1157                & * (   xyz_B0(i,j,k) &
  1158                &     + xyz_B1(i,j,k) &
  1159                &       * ( xyz_DelTau(i,j,k) + 1.0_DP / ( xyz_Gam1(i,j,k) + xyz_Gam2(i,j,k) ) ) )
  1160  !!$            xyz_CUpT(i,j,k) = 2.0_DP * PI * Mu1 &
  1161              xyz_CUpTEmi(i,j,k) = 2.0_DP * xyz_Mu1(i,j,k) &
  1162                & * (   xyz_B0(i,j,k) &
  1163                &     + xyz_B1(i,j,k) &
  1164                &       * ( 0.0_DP            + 1.0_DP / ( xyz_Gam1(i,j,k) + xyz_Gam2(i,j,k) ) ) )
  1165  !!$            xyz_CDoB(i,j,k) = 2.0_DP * PI * Mu1 &
  1166              xyz_CDoBEmi(i,j,k) = 2.0_DP * xyz_Mu1(i,j,k) &
  1167                & * (   xyz_B0(i,j,k) &
  1168                &     + xyz_B1(i,j,k) &
  1169                &       * ( xyz_DelTau(i,j,k) - 1.0_DP / ( xyz_Gam1(i,j,k) + xyz_Gam2(i,j,k) ) ) )
  1170  !!$            xyz_CDoT(i,j,k) = 2.0_DP * PI * Mu1 &
  1171              xyz_CDoTEmi(i,j,k) = 2.0_DP * xyz_Mu1(i,j,k) &
  1172                & * (   xyz_B0(i,j,k) &
  1173                &     + xyz_B1(i,j,k) &
  1174                &       * ( 0.0_DP            - 1.0_DP / ( xyz_Gam1(i,j,k) + xyz_Gam2(i,j,k) ) ) )
  1175            end do
  1176          end do
  1177        end do
  1178  
  1179      else
  1180  
  1181        do k = 1, kmax
  1182          do j = js, je
  1183            xyz_CUpBEmi(:,j,k) = 0.0_DP
  1184            xyz_CUpTEmi(:,j,k) = 0.0_DP
  1185            xyz_CDoBEmi(:,j,k) = 0.0_DP
  1186            xyz_CDoTEmi(:,j,k) = 0.0_DP
  1187          end do
  1188        end do
  1189  
  1190      end if
  1191  
  1192      do k = 1, kmax
  1193        do j = js, je
  1194          xyz_CUpB(:,j,k) = xyz_CUpBDir(:,j,k) + xyz_CUpBEmi(:,j,k)
  1195          xyz_CUpT(:,j,k) = xyz_CUpTDir(:,j,k) + xyz_CUpTEmi(:,j,k)
  1196          xyz_CDoB(:,j,k) = xyz_CDoBDir(:,j,k) + xyz_CDoBEmi(:,j,k)
  1197          xyz_CDoT(:,j,k) = xyz_CDoTDir(:,j,k) + xyz_CDoTEmi(:,j,k)
  1198        end do
  1199      end do
  1200  
  1201  
  1202      if ( FlagEmis ) then
  1203        do j = js, je
  1204          do i = 0, imax-1
  1205            xy_SurfSrc(:,j) = xy_SurfPFInted(:,j)
  1206          end do
  1207        end do
  1208  !!$      else if( sw .eq. 2 ) then
  1209  !!$         do ij = ijs, ije
  1210  !!$!            gemis = 1.0d0
  1211  !!$            gemis = emis( ij, 1 )
  1212  !!$            ea( (ij-ijs+1), l ) &
  1213  !!$                 = -CUpB( ij, 1, km ) + ( 1.0d0 - gemis ) * CDoB( ij, 1, km ) &
  1214  !!$                 + gemis * pi * pfinth( ij, 1, km+1 )
  1215  !!$         end do
  1216      else
  1217        do j = js, je
  1218          do i = 0, imax-1
  1219            xy_SurfSrc(:,j) = 0.0_DP
  1220          end do
  1221        end do
  1222      end if
  1223  
  1224      if ( FlagTOAFlux ) then
  1225        do j = js, je
  1226          xy_SurfSrc(:,j) = xy_SurfSrc(:,j)                            &
  1227            & + xy_SurfAlbedo(:,j) * xy_SolarFluxTOA(:,j) * xyr_TransDirAdj(:,j,0) * xy_cosSZA(:,j)
  1228        end do
  1229      end if
  1230  
  1231  
  1232  
  1233      k = 1
  1234      l = 1
  1235      do j = js, je
  1236        do i = 0, imax-1
  1237          aa_TridiagMtx1( i+imax*(j-1)+1, l ) =                                     &
  1238            & 0.0_DP
  1239          aa_TridiagMtx2( i+imax*(j-1)+1, l ) =                                     &
  1240            &     xyaz_smalle(i,j,1,k) - xy_SurfAlbedo(i,j) * xyaz_smalle(i,j,3,k)
  1241          aa_TridiagMtx3( i+imax*(j-1)+1, l ) =                                     &
  1242            & - ( xyaz_smalle(i,j,2,k) - xy_SurfAlbedo(i,j) * xyaz_smalle(i,j,4,k) )
  1243        end do
  1244      end do
  1245      do j = js, je
  1246        do i = 0, imax-1
  1247          aa_Vec( i+imax*(j-1)+1, l ) =                                              &
  1248            & - xyz_CUpB(i,j,k)                                                      &
  1249            & + xy_SurfAlbedo(i,j) * xyz_CDoB(i,j,k)                                 &
  1250            & + xy_SurfSrc(i,j)
  1251        end do
  1252      end do
  1253  
  1254  
  1255      do k = 1, kmax-1
  1256  
  1257        do j = js, je
  1258          do i = 0, imax-1
  1259  
  1260            l = 2 * k     ! equation number
  1261            !
  1262            aa_TridiagMtx1( i+imax*(j-1)+1, l ) =                                       &
  1263              &   xyaz_smalle(i,j,1,k  ) * xyaz_smalle(i,j,2,k+1)                       &
  1264              & - xyaz_smalle(i,j,3,k  ) * xyaz_smalle(i,j,4,k+1)
  1265            aa_TridiagMtx2( i+imax*(j-1)+1, l ) =                                       &
  1266              &   xyaz_smalle(i,j,2,k  ) * xyaz_smalle(i,j,2,k+1)                       &
  1267              & - xyaz_smalle(i,j,4,k  ) * xyaz_smalle(i,j,4,k+1)
  1268            aa_TridiagMtx3( i+imax*(j-1)+1, l ) =                                       &
  1269              &   xyaz_smalle(i,j,1,k+1) * xyaz_smalle(i,j,4,k+1)                       &
  1270              & - xyaz_smalle(i,j,2,k+1) * xyaz_smalle(i,j,3,k+1)
  1271            aa_Vec        ( i+imax*(j-1)+1, l ) =                                       &
  1272              &   xyaz_smalle(i,j,2,k+1) * ( - xyz_CDoT(i,j,k  ) + xyz_CDoB(i,j,k+1) )  &
  1273              & - xyaz_smalle(i,j,4,k+1) * ( - xyz_CUpT(i,j,k  ) + xyz_CUpB(i,j,k+1) )
  1274  
  1275            l = 2 * k + 1 ! equation number
  1276            !
  1277            aa_TridiagMtx1( i+imax*(j-1)+1, l ) =                                       &
  1278              &   xyaz_smalle(i,j,2,k  ) * xyaz_smalle(i,j,3,k  )                       &
  1279              & - xyaz_smalle(i,j,1,k  ) * xyaz_smalle(i,j,4,k  )
  1280            aa_TridiagMtx2( i+imax*(j-1)+1, l ) =                                       &
  1281              &   xyaz_smalle(i,j,1,k  ) * xyaz_smalle(i,j,1,k+1)                       &
  1282              & - xyaz_smalle(i,j,3,k  ) * xyaz_smalle(i,j,3,k+1)
  1283            aa_TridiagMtx3( i+imax*(j-1)+1, l ) =                                       &
  1284              &   xyaz_smalle(i,j,3,k  ) * xyaz_smalle(i,j,4,k+1)                       &
  1285              & - xyaz_smalle(i,j,1,k  ) * xyaz_smalle(i,j,2,k+1)
  1286            aa_Vec        ( i+imax*(j-1)+1, l ) =                                       &
  1287              &   xyaz_smalle(i,j,3,k  ) * ( - xyz_CDoT(i,j,k  ) + xyz_CDoB(i,j,k+1) )  &
  1288              & - xyaz_smalle(i,j,1,k  ) * ( - xyz_CUpT(i,j,k  ) + xyz_CUpB(i,j,k+1) )
  1289          end do
  1290        end do
  1291      end do
  1292  
  1293  
  1294      k = kmax
  1295      l = 2 * kmax
  1296      do j = js, je
  1297        do i = 0, imax-1
  1298          aa_TridiagMtx1( i+imax*(j-1)+1, l ) =  xyaz_smalle(i,j,1,k)
  1299          aa_TridiagMtx2( i+imax*(j-1)+1, l ) =  xyaz_smalle(i,j,2,k)
  1300          aa_TridiagMtx3( i+imax*(j-1)+1, l ) = 0.0d0
  1301          aa_Vec        ( i+imax*(j-1)+1, l ) = -xyz_CDoT(i,j,k) + 0.0d0
  1302        end do
  1303      end do
  1304  
  1305      ms = 0      + imax*(js-1)+1
  1306      me = imax-1 + imax*(je-1)+1
  1307      call tridiag( imax*jmax, 2*kmax, aa_TridiagMtx1, aa_TridiagMtx2, aa_TridiagMtx3, aa_Vec, ms, me )
  1308  
  1309      if ( .not. FlagSrcFuncTech ) then
  1310  
  1311        k = 1
  1312        do j = js, je
  1313          do i = 0, imax-1
  1314            xyr_RadUwFlux(i,j,k-1) =                                    &
  1315              &   aa_Vec( i+imax*(j-1)+1, 2*k-1) * xyaz_smalle(i,j,1,k) &
  1316              & - aa_Vec( i+imax*(j-1)+1, 2*k  ) * xyaz_smalle(i,j,2,k) &
  1317              & + xyz_CUpB(i,j,k)
  1318            xyr_RadDwFlux(i,j,k-1) =                                    &
  1319              &   aa_Vec( i+imax*(j-1)+1, 2*k-1) * xyaz_smalle(i,j,3,k) &
  1320              & - aa_Vec( i+imax*(j-1)+1, 2*k  ) * xyaz_smalle(i,j,4,k) &
  1321              & + xyz_CDoB(i,j,k)
  1322          end do
  1323        end do
  1324  
  1325        do k = 1, kmax
  1326          do j = js, je
  1327            do i = 0, imax-1
  1328              xyr_RadUwFlux(i,j,k) =                                      &
  1329                &   aa_Vec( i+imax*(j-1)+1, 2*k-1) * xyaz_smalle(i,j,3,k) &
  1330                & + aa_Vec( i+imax*(j-1)+1, 2*k  ) * xyaz_smalle(i,j,4,k) &
  1331                & + xyz_CUpT(i,j,k)
  1332              xyr_RadDwFlux(i,j,k) =                                      &
  1333                &   aa_Vec( i+imax*(j-1)+1, 2*k-1) * xyaz_smalle(i,j,1,k) &
  1334                & + aa_Vec( i+imax*(j-1)+1, 2*k  ) * xyaz_smalle(i,j,2,k) &
  1335                & + xyz_CDoT(i,j,k)
  1336            end do
  1337          end do
  1338        end do
  1339  
  1340  
  1341  
  1342  
  1343  
  1344          ! Code for debug
  1345          !
  1346  !!$        do k = 1, kmax
  1347  !!$          do j = js, je
  1348  !!$            do i = 0, imax-1
  1349  !!$              xyr_UwFluxDebug(i,j,k-1) =                                         &
  1350  !!$                &   aa_Vec( i+imax*(j-1)+1, 2*k-1) * xyaz_smalle(i,j,1,k) &
  1351  !!$                & - aa_Vec( i+imax*(j-1)+1, 2*k  ) * xyaz_smalle(i,j,2,k) &
  1352  !!$                & + xyz_CUpB(i,j,k)
  1353  !!$              xyr_DwFluxDebug(i,j,k-1) =                                         &
  1354  !!$                &   aa_Vec( i+imax*(j-1)+1, 2*k-1) * xyaz_smalle(i,j,3,k) &
  1355  !!$                & - aa_Vec( i+imax*(j-1)+1, 2*k  ) * xyaz_smalle(i,j,4,k) &
  1356  !!$                & + xyz_CDoB(i,j,k)
  1357  !!$            end do
  1358  !!$          end do
  1359  !!$        end do
  1360  !!$
  1361  !!$        k = kmax
  1362  !!$        do j = js, je
  1363  !!$          do i = 0, imax-1
  1364  !!$            xyr_UwFluxDebug(i,j,k) =                                       &
  1365  !!$              &   aa_Vec( i+imax*(j-1)+1, 2*k-1) * xyaz_smalle(i,j,3,k) &
  1366  !!$              & + aa_Vec( i+imax*(j-1)+1, 2*k  ) * xyaz_smalle(i,j,4,k) &
  1367  !!$              & + xyz_CUpT(i,j,k)
  1368  !!$            xyr_DwFluxDebug(i,j,k) =                                       &
  1369  !!$              &   aa_Vec( i+imax*(j-1)+1, 2*k-1) * xyaz_smalle(i,j,1,k) &
  1370  !!$              & + aa_Vec( i+imax*(j-1)+1, 2*k  ) * xyaz_smalle(i,j,2,k) &
  1371  !!$              & + xyz_CDoT(i,j,k)
  1372  !!$          end do
  1373  !!$        end do
  1374  !!$
  1375  !!$
  1376  !!$        i = imax/2
  1377  !!$        j = jmax/2
  1378  !!$        do k = kmax, 0, -1
  1379  !!$          write( 6, * ) k, xyr_UwFlux(i,j,k), xyr_UwFluxDebug(i,j,k), xyr_UwFlux(i,j,k) - xyr_UwFluxDebug(i,j,k)
  1380  !!$        end do
  1381  !!$        do k = kmax, 0, -1
  1382  !!$          write( 6, * ) k, xyr_DwFlux(i,j,k), xyr_DwFluxDebug(i,j,k), xyr_DwFlux(i,j,k) - xyr_DwFluxDebug(i,j,k)
  1383  !!$        end do
  1384  !!$        k = 0
  1385  !!$        write( 6, * ) k, xyr_UwFlux(i,j,k), xy_SurfAlbedo(i,j) * xyr_DwFlux(i,j,k) + xy_SurfAlbedo(i,j) * SolarFluxTOA * xyr_TransDirAdj(i,j,0) * xy_cosSZA(i,j), &
  1386  !!$          xyr_UwFlux(i,j,k) - ( xy_SurfAlbedo(i,j) * xyr_DwFlux(i,j,k) + xy_SurfAlbedo(i,j) * SolarFluxTOA * xyr_TransDirAdj(i,j,0) * xy_cosSZA(i,j) )
  1387  !!$        stop
  1388  
  1389  
  1390      else
  1391  
  1392        ! Source function technique described by Toon et al. [1989]
  1393        ! is used to calculated infrared heating rate.
  1394        !
  1395        do k = 0, kmax
  1396          do j = js, je
  1397            xyr_RadUwFlux(:,j,k) = 0.0_DP
  1398            xyr_RadDwFlux(:,j,k) = 0.0_DP
  1399          end do
  1400        end do
  1401  
  1402        do k = 0, kmax
  1403          do j = js, je
  1404            xyra_DelRadUwFlux(:,j,k,0) = 0.0_DP
  1405            xyra_DelRadUwFlux(:,j,k,1) = 0.0_DP
  1406            xyra_DelRadDwFlux(:,j,k,0) = 0.0_DP
  1407            xyra_DelRadDwFlux(:,j,k,1) = 0.0_DP
  1408          end do
  1409        end do
  1410  
  1411        do l = 1, NGaussQuad
  1412          Mu = a_GQP( l )
  1413  
  1414          k = kmax
  1415          do j = js, je
  1416            xyr_IDw(:,j,k) = 0.0_DP
  1417          end do
  1418          do k = kmax, 1, -1
  1419            do j = js, je
  1420              do i = 0, imax-1
  1421                FactJ = &
  1422                  & ( aa_Vec( i+imax*(j-1)+1, 2*k-1 ) + aa_Vec( i+imax*(j-1)+1, 2*k ) ) &
  1423                  &   * xyz_LGamma(i,j,k) * ( xyz_Lambda(i,j,k) + 1.0_DP / xyz_Mu1(i,j,k) )
  1424                FactK = &
  1425                  & ( aa_Vec( i+imax*(j-1)+1, 2*k-1 ) - aa_Vec( i+imax*(j-1)+1, 2*k ) ) &
  1426                  &   * ( 1.0_DP / xyz_Mu1(i,j,k) - xyz_Lambda(i,j,k) )
  1427                Sig1  = &
  1428                  & 2.0_DP * (   xyz_B0(i,j,k) &
  1429                  &            - xyz_B1(i,j,k) * ( 1.0_DP / ( xyz_Gam1(i,j,k) + xyz_Gam2(i,j,k) ) - xyz_Mu1(i,j,k) ) )
  1430                Sig2  = &
  1431                  & 2.0_DP * xyz_B1(i,j,k)
  1432                xyr_IDw(i,j,k-1) = xyr_IDw(i,j,k) * exp( - xyz_DelTau(i,j,k) / Mu )           &
  1433                  & + FactJ / ( xyz_Lambda(i,j,k) * Mu + 1.0_DP )                             &
  1434                  &   * (   1.0_DP                                                            &
  1435                  &       - exp( - xyz_DelTau(i,j,k) * ( xyz_Lambda(i,j,k) + 1.0d0 / Mu ) ) ) &
  1436                  & + FactK / ( xyz_Lambda(i,j,k) * Mu - 1.0_DP )                             &
  1437                  &   * (   exp( - xyz_DelTau(i,j,k) / Mu )                                   &
  1438                  &       - exp( - xyz_DelTau(i,j,k) * xyz_Lambda(i,j,k) ) )                  &
  1439                  & + Sig1 * ( 1.0_DP - exp( - xyz_DelTau(i,j,k) / Mu ) )                     &
  1440                  & + Sig2 * ( Mu * exp( - xyz_DelTau(i,j,k) / Mu ) + xyz_DelTau(i,j,k) - Mu )
  1441              end do
  1442            end do
  1443          end do
  1444  
  1445          k = 0
  1446          do j = js, je
  1447  !               gemis = 1.0d0
  1448  !!$          gemis = emis( ij, 1 )
  1449  !!$          inteup( ij, 1, k ) = ( 1.0d0 - gemis ) * intedo( ij, 1, km+1 ) &
  1450  !!$                    + gemis * pix2 * pfinth( ij, 1, km+1 )
  1451            xyr_IUw(:,j,k) = xy_SurfAlbedo(:,j) * xyr_IDw(:,j,0) + 2.0_DP * xy_SurfPFInted(:,j)
  1452          end do
  1453          do k = 1, kmax
  1454            do j = js, je
  1455              do i = 0, imax-1
  1456                FactG = &
  1457                  & ( aa_Vec( i+imax*(j-1)+1, 2*k-1 ) + aa_Vec( i+imax*(j-1)+1, 2*k ) ) &
  1458                  &   * ( 1.0_DP / xyz_Mu1(i,j,k) - xyz_Lambda(i,j,k) )
  1459                FactH = &
  1460                  & ( aa_Vec( i+imax*(j-1)+1, 2*k-1 ) - aa_Vec( i+imax*(j-1)+1, 2*k ) ) &
  1461                  &   * xyz_LGamma(i,j,k) * ( xyz_Lambda(i,j,k) + 1.0_DP / xyz_Mu1(i,j,k) )
  1462                Alp1  = &
  1463                  & 2.0_DP * (   xyz_B0(i,j,k) &
  1464                  &            + xyz_B1(i,j,k) * ( 1.0_DP / ( xyz_Gam1(i,j,k) + xyz_Gam2(i,j,k) ) - xyz_Mu1(i,j,k) ) )
  1465                Alp2  = &
  1466                  & 2.0_DP * xyz_B1(i,j,k)
  1467                xyr_IUw(i,j,k) = xyr_IUw(i,j,k-1) * exp( - xyz_DelTau(i,j,k) / Mu )           &
  1468                  & + FactG / ( xyz_Lambda(i,j,k) * Mu - 1.0_DP )                             &
  1469                  &   * (   exp( - xyz_DelTau(i,j,k) / Mu )                                   &
  1470                  &       - exp( - xyz_DelTau(i,j,k) * xyz_Lambda(i,j,k) ) )                  &
  1471                  & + FactH / ( xyz_Lambda(i,j,k) * Mu + 1.0_DP )                             &
  1472                  &   * (   1.0_DP                                                            &
  1473                  &       - exp( - xyz_DelTau(i,j,k) * ( xyz_Lambda(i,j,k) + 1.0d0 / Mu ) ) ) &
  1474                  & + Alp1 * ( 1.0_DP - exp( - xyz_DelTau(i,j,k) / Mu ) )                     &
  1475                  & + Alp2 * ( Mu - ( xyz_DelTau(i,j,k) + Mu ) * exp( - xyz_Deltau(i,j,k) / Mu ) )
  1476              end do
  1477            end do
  1478          end do
  1479  
  1480          do k = 0, kmax
  1481            do j = js, je
  1482              xyr_RadUwFlux(:,j,k) = xyr_RadUwFlux(:,j,k) + Mu * xyr_IUw(:,j,k) * a_GQW( l )
  1483              xyr_RadDwFlux(:,j,k) = xyr_RadDwFlux(:,j,k) + Mu * xyr_IDw(:,j,k) * a_GQW( l )
  1484            end do
  1485          end do
  1486  
  1487          do k = 0, kmax
  1488            do j = js, je
  1489              xyra_DelRadUwFlux(:,j,k,0) = xyra_DelRadUwFlux(:,j,k,0)             &
  1490                & + Mu * 2.0_DP * xy_SurfDPFDTInted(:,j)                          &
  1491                &   * exp( - ( xyr_OpDepAdj(:,j,0) - xyr_OpDepAdj(:,j,k) ) / Mu ) &
  1492                &   * a_GQW( l )
  1493            end do
  1494          end do
  1495  
  1496        end do ! do l = 1, NGaussQuad
  1497  
  1498      end if
  1499  
  1500  
  1501      if ( FlagTOAFlux ) then
  1502        !
  1503        ! Addition of Direct Solar Insident
  1504        !
  1505        do k = 0, kmax
  1506          do j = js, je
  1507            xyr_RadDwFlux(:,j,k) = xyr_RadDwFlux(:,j,k) &
  1508              & + xy_SolarFluxTOA(:,j) * xyr_TransDirAdj(:,j,k) * xy_cosSZA(:,j)
  1509          end do
  1510        end do
  1511  
  1512      end if
  1513  
  1514  
  1515    end subroutine RadRTETwoStreamAppCore
     .        xy_solarfluxtoa.DSC.U1 = imax - 1                                 
     .        xy_solarfluxtoa.DSC.U2 = jmax                                     
     .        allocate (xy_solarfluxtoa(0:imax-1,1:jmax))                       
     .        xyz_ssaadj.DSC.U1 = imax - 1                                      
     .        xyz_ssaadj.DSC.U2 = jmax                                          
     .        xyz_ssaadj.DSC.U3 = kmax                                          
     .        allocate (xyz_ssaadj(0:imax-1,1:jmax,1:kmax))                     
     .        xyz_afadj.DSC.U1 = imax - 1                                       
     .        xyz_afadj.DSC.U2 = jmax                                           
     .        xyz_afadj.DSC.U3 = kmax                                           
     .        allocate (xyz_afadj(0:imax-1,1:jmax,1:kmax))                      
     .        xyr_opdepadj.DSC.U1 = imax - 1                                    
     .        xyr_opdepadj.DSC.U2 = jmax                                        
     .        xyr_opdepadj.DSC.U3 = kmax                                        
     .        allocate (xyr_opdepadj(0:imax-1,1:jmax,0:kmax))                   
     .        xyr_transdiradj.DSC.U1 = imax - 1                                 
     .        xyr_transdiradj.DSC.U2 = jmax                                     
     .        xyr_transdiradj.DSC.U3 = kmax                                     
     .        allocate (xyr_transdiradj(0:imax-1,1:jmax,0:kmax))                
     .        xyz_gam1.DSC.U1 = imax - 1                                        
     .        xyz_gam1.DSC.U2 = jmax                                            
     .        xyz_gam1.DSC.U3 = kmax                                            
     .        allocate (xyz_gam1(0:imax-1,1:jmax,1:kmax))                       
     .        xyz_gam2.DSC.U1 = imax - 1                                        
     .        xyz_gam2.DSC.U2 = jmax                                            
     .        xyz_gam2.DSC.U3 = kmax                                            
     .        allocate (xyz_gam2(0:imax-1,1:jmax,1:kmax))                       
     .        xyz_gam3.DSC.U1 = imax - 1                                        
     .        xyz_gam3.DSC.U2 = jmax                                            
     .        xyz_gam3.DSC.U3 = kmax                                            
     .        allocate (xyz_gam3(0:imax-1,1:jmax,1:kmax))                       
     .        xyz_gam4.DSC.U1 = imax - 1                                        
     .        xyz_gam4.DSC.U2 = jmax                                            
     .        xyz_gam4.DSC.U3 = kmax                                            
     .        allocate (xyz_gam4(0:imax-1,1:jmax,1:kmax))                       
     .        xy_cossza.DSC.U1 = imax - 1                                       
     .        xy_cossza.DSC.U2 = jmax                                           
     .        allocate (xy_cossza(0:imax-1,1:jmax))                             
     .        xy_cosszainv.DSC.U1 = imax - 1                                    
     .        xy_cosszainv.DSC.U2 = jmax                                        
     .        allocate (xy_cosszainv(0:imax-1,1:jmax))                          
     .        xy_cosszainvsq.DSC.U1 = imax - 1                                  
     .        xy_cosszainvsq.DSC.U2 = jmax                                      
     .        allocate (xy_cosszainvsq(0:imax-1,1:jmax))                        
     .        xyz_deltau.DSC.U1 = imax - 1                                      
     .        xyz_deltau.DSC.U2 = jmax                                          
     .        xyz_deltau.DSC.U3 = kmax                                          
     .        allocate (xyz_deltau(0:imax-1,1:jmax,1:kmax))                     
     .        xyz_lambda.DSC.U1 = imax - 1                                      
     .        xyz_lambda.DSC.U2 = jmax                                          
     .        xyz_lambda.DSC.U3 = kmax                                          
     .        allocate (xyz_lambda(0:imax-1,1:jmax,1:kmax))                     
     .        xyz_lgamma.DSC.U1 = imax - 1                                      
     .        xyz_lgamma.DSC.U2 = jmax                                          
     .        xyz_lgamma.DSC.U3 = kmax                                          
     .        allocate (xyz_lgamma(0:imax-1,1:jmax,1:kmax))                     
     .        xyaz_smalle.DSC.U1 = imax - 1                                     
     .        xyaz_smalle.DSC.U2 = jmax                                         
     .        xyaz_smalle.DSC.U4 = kmax                                         
     .        allocate (xyaz_smalle(0:imax-1,1:jmax,1:4,1:kmax))                
     .        xy_surfsrc.DSC.U1 = imax - 1                                      
     .        xy_surfsrc.DSC.U2 = jmax                                          
     .        allocate (xy_surfsrc(0:imax-1,1:jmax))                            
     .        xyz_cupb.DSC.U1 = imax - 1                                        
     .        xyz_cupb.DSC.U2 = jmax                                            
     .        xyz_cupb.DSC.U3 = kmax                                            
     .        allocate (xyz_cupb(0:imax-1,1:jmax,1:kmax))                       
     .        xyz_cupt.DSC.U1 = imax - 1                                        
     .        xyz_cupt.DSC.U2 = jmax                                            
     .        xyz_cupt.DSC.U3 = kmax                                            
     .        allocate (xyz_cupt(0:imax-1,1:jmax,1:kmax))                       
     .        xyz_cdob.DSC.U1 = imax - 1                                        
     .        xyz_cdob.DSC.U2 = jmax                                            
     .        xyz_cdob.DSC.U3 = kmax                                            
     .        allocate (xyz_cdob(0:imax-1,1:jmax,1:kmax))                       
     .        xyz_cdot.DSC.U1 = imax - 1                                        
     .        xyz_cdot.DSC.U2 = jmax                                            
     .        xyz_cdot.DSC.U3 = kmax                                            
     .        allocate (xyz_cdot(0:imax-1,1:jmax,1:kmax))                       
     .        xyz_cupbdir.DSC.U1 = imax - 1                                     
     .        xyz_cupbdir.DSC.U2 = jmax                                         
     .        xyz_cupbdir.DSC.U3 = kmax                                         
     .        allocate (xyz_cupbdir(0:imax-1,1:jmax,1:kmax))                    
     .        xyz_cuptdir.DSC.U1 = imax - 1                                     
     .        xyz_cuptdir.DSC.U2 = jmax                                         
     .        xyz_cuptdir.DSC.U3 = kmax                                         
     .        allocate (xyz_cuptdir(0:imax-1,1:jmax,1:kmax))                    
     .        xyz_cdobdir.DSC.U1 = imax - 1                                     
     .        xyz_cdobdir.DSC.U2 = jmax                                         
     .        xyz_cdobdir.DSC.U3 = kmax                                         
     .        allocate (xyz_cdobdir(0:imax-1,1:jmax,1:kmax))                    
     .        xyz_cdotdir.DSC.U1 = imax - 1                                     
     .        xyz_cdotdir.DSC.U2 = jmax                                         
     .        xyz_cdotdir.DSC.U3 = kmax                                         
     .        allocate (xyz_cdotdir(0:imax-1,1:jmax,1:kmax))                    
     .        xyz_cupbemi.DSC.U1 = imax - 1                                     
     .        xyz_cupbemi.DSC.U2 = jmax                                         
     .        xyz_cupbemi.DSC.U3 = kmax                                         
     .        allocate (xyz_cupbemi(0:imax-1,1:jmax,1:kmax))                    
     .        xyz_cuptemi.DSC.U1 = imax - 1                                     
     .        xyz_cuptemi.DSC.U2 = jmax                                         
     .        xyz_cuptemi.DSC.U3 = kmax                                         
     .        allocate (xyz_cuptemi(0:imax-1,1:jmax,1:kmax))                    
     .        xyz_cdobemi.DSC.U1 = imax - 1                                     
     .        xyz_cdobemi.DSC.U2 = jmax                                         
     .        xyz_cdobemi.DSC.U3 = kmax                                         
     .        allocate (xyz_cdobemi(0:imax-1,1:jmax,1:kmax))                    
     .        xyz_cdotemi.DSC.U1 = imax - 1                                     
     .        xyz_cdotemi.DSC.U2 = jmax                                         
     .        xyz_cdotemi.DSC.U3 = kmax                                         
     .        allocate (xyz_cdotemi(0:imax-1,1:jmax,1:kmax))                    
     .        aa_tridiagmtx1.DSC.U1 = imax*jmax                                 
     .        aa_tridiagmtx1.DSC.U2 = kmax*2                                    
     .        allocate (aa_tridiagmtx1(1:imax*jmax,1:kmax*2))                   
     .        aa_tridiagmtx2.DSC.U1 = imax*jmax                                 
     .        aa_tridiagmtx2.DSC.U2 = kmax*2                                    
     .        allocate (aa_tridiagmtx2(1:imax*jmax,1:kmax*2))                   
     .        aa_tridiagmtx3.DSC.U1 = imax*jmax                                 
     .        aa_tridiagmtx3.DSC.U2 = kmax*2                                    
     .        allocate (aa_tridiagmtx3(1:imax*jmax,1:kmax*2))                   
     .        aa_vec.DSC.U1 = imax*jmax                                         
     .        aa_vec.DSC.U2 = kmax*2                                            
     .        allocate (aa_vec(1:imax*jmax,1:kmax*2))                           
     .        xy_tmpval.DSC.U1 = imax - 1                                       
     .        xy_tmpval.DSC.U2 = jmax                                           
     .        allocate (xy_tmpval(0:imax-1,1:jmax))                             
     .        xyz_b0.DSC.U1 = imax - 1                                          
     .        xyz_b0.DSC.U2 = jmax                                              
     .        xyz_b0.DSC.U3 = kmax                                              
     .        allocate (xyz_b0(0:imax-1,1:jmax,1:kmax))                         
     .        xyz_b1.DSC.U1 = imax - 1                                          
     .        xyz_b1.DSC.U2 = jmax                                              
     .        xyz_b1.DSC.U3 = kmax                                              
     .        allocate (xyz_b1(0:imax-1,1:jmax,1:kmax))                         
     .        xyz_mu1.DSC.U1 = imax - 1                                         
     .        xyz_mu1.DSC.U2 = jmax                                             
     .        xyz_mu1.DSC.U3 = kmax                                             
     .        allocate (xyz_mu1(0:imax-1,1:jmax,1:kmax))                        
     .        xyr_iuw.DSC.U1 = imax - 1                                         
     .        xyr_iuw.DSC.U2 = jmax                                             
     .        xyr_iuw.DSC.U3 = kmax                                             
     .        allocate (xyr_iuw(0:imax-1,1:jmax,0:kmax))                        
     .        xyr_idw.DSC.U1 = imax - 1                                         
     .        xyr_idw.DSC.U2 = jmax                                             
     .        xyr_idw.DSC.U3 = kmax                                             
     .        allocate (xyr_idw(0:imax-1,1:jmax,0:kmax))                        
     .        xy_cossza.DSC.S2 = (xy_cossza.DSC.U1 + 1)*8                       
     .        xy_cosszainv.DSC.S2 = (xy_cosszainv.DSC.U1 + 1)*8                 
     .        xy_cosszainvsq.DSC.S2 = (xy_cosszainvsq.DSC.U1 + 1)*8             
     .        xyr_idw.DSC.S2 = (xyr_idw.DSC.U1 + 1)*8                           
     .        xyr_idw.DSC.S3 = xyr_idw.DSC.U2*(xyr_idw.DSC.U1 + 1)*8            
     .        xyz_gam1.DSC.S2 = (xyz_gam1.DSC.U1 + 1)*8                         
     .        xyz_gam1.DSC.S3 = xyz_gam1.DSC.U2*(xyz_gam1.DSC.U1 + 1)*8         
     .        xyz_gam2.DSC.S2 = (xyz_gam2.DSC.U1 + 1)*8                         
     .        xyz_gam2.DSC.S3 = xyz_gam2.DSC.U2*(xyz_gam2.DSC.U1 + 1)*8         
     .        xyz_gam3.DSC.S2 = (xyz_gam3.DSC.U1 + 1)*8                         
     .        xyz_gam3.DSC.S3 = xyz_gam3.DSC.U2*(xyz_gam3.DSC.U1 + 1)*8         
     .        xyz_gam4.DSC.S2 = (xyz_gam4.DSC.U1 + 1)*8                         
     .        xyz_gam4.DSC.S3 = xyz_gam4.DSC.U2*(xyz_gam4.DSC.U1 + 1)*8         
     .        xyz_afadj.DSC.S2 = (xyz_afadj.DSC.U1 + 1)*8                       
     .        xyz_afadj.DSC.S3 = xyz_afadj.DSC.U2*(xyz_afadj.DSC.U1 + 1)*8      
     .        xyz_cdob.DSC.S2 = (xyz_cdob.DSC.U1 + 1)*8                         
     .        xyz_cdob.DSC.S3 = xyz_cdob.DSC.U2*(xyz_cdob.DSC.U1 + 1)*8         
     .        xyz_cdobdir.DSC.S2 = (xyz_cdobdir.DSC.U1 + 1)*8                   
     .        xyz_cdobdir.DSC.S3 = xyz_cdobdir.DSC.U2*(xyz_cdobdir.DSC.U1 + 1)*8
     .        xyz_cdobemi.DSC.S2 = (xyz_cdobemi.DSC.U1 + 1)*8                   
     .        xyz_cdobemi.DSC.S3 = xyz_cdobemi.DSC.U2*(xyz_cdobemi.DSC.U1 + 1)*8
     .        xyz_cdot.DSC.S2 = (xyz_cdot.DSC.U1 + 1)*8                         
     .        xyz_cdot.DSC.S3 = xyz_cdot.DSC.U2*(xyz_cdot.DSC.U1 + 1)*8         
     .        xyz_cdotdir.DSC.S2 = (xyz_cdotdir.DSC.U1 + 1)*8                   
     .        xyz_cdotdir.DSC.S3 = xyz_cdotdir.DSC.U2*(xyz_cdotdir.DSC.U1 + 1)*8
     .        xyz_cdotemi.DSC.S2 = (xyz_cdotemi.DSC.U1 + 1)*8                   
     .        xyz_cdotemi.DSC.S3 = xyz_cdotemi.DSC.U2*(xyz_cdotemi.DSC.U1 + 1)*8
     .        xyz_ssaadj.DSC.S2 = (xyz_ssaadj.DSC.U1 + 1)*8                     
     .        xyz_ssaadj.DSC.S3 = xyz_ssaadj.DSC.U2*(xyz_ssaadj.DSC.U1 + 1)*8   
     .        xyz_deltau.DSC.S2 = (xyz_deltau.DSC.U1 + 1)*8                     
     .        xyz_deltau.DSC.S3 = xyz_deltau.DSC.U2*(xyz_deltau.DSC.U1 + 1)*8   
     .        xyz_lambda.DSC.S2 = (xyz_lambda.DSC.U1 + 1)*8                     
     .        xyz_lambda.DSC.S3 = xyz_lambda.DSC.U2*(xyz_lambda.DSC.U1 + 1)*8   
     .        xy_surfsrc.DSC.S2 = (xy_surfsrc.DSC.U1 + 1)*8                     
     .        xyr_transdiradj.DSC.S2 = (xyr_transdiradj.DSC.U1 + 1)*8           
     .        xyr_transdiradj.DSC.S3 = xyr_transdiradj.DSC.U2*(                 
     .       1   xyr_transdiradj.DSC.U1 + 1)*8                                  
     .        xy_solarfluxtoa.DSC.S2 = (xy_solarfluxtoa.DSC.U1 + 1)*8           
     .        aa_vec.DSC.S2 = aa_vec.DSC.U1*8                                   
     .        xyz_lgamma.DSC.S2 = (xyz_lgamma.DSC.U1 + 1)*8                     
     .        xyz_lgamma.DSC.S3 = xyz_lgamma.DSC.U2*(xyz_lgamma.DSC.U1 + 1)*8   
     .        aa_tridiagmtx1.DSC.S2 = aa_tridiagmtx1.DSC.U1*8                   
     .        aa_tridiagmtx2.DSC.S2 = aa_tridiagmtx2.DSC.U1*8                   
     .        aa_tridiagmtx3.DSC.S2 = aa_tridiagmtx3.DSC.U1*8                   
     .        xyr_iuw.DSC.S2 = (xyr_iuw.DSC.U1 + 1)*8                           
     .        xyr_iuw.DSC.S3 = xyr_iuw.DSC.U2*(xyr_iuw.DSC.U1 + 1)*8            
     .        xyz_cupb.DSC.S2 = (xyz_cupb.DSC.U1 + 1)*8                         
     .        xyz_cupb.DSC.S3 = xyz_cupb.DSC.U2*(xyz_cupb.DSC.U1 + 1)*8         
     .        xyz_cupbdir.DSC.S2 = (xyz_cupbdir.DSC.U1 + 1)*8                   
     .        xyz_cupbdir.DSC.S3 = xyz_cupbdir.DSC.U2*(xyz_cupbdir.DSC.U1 + 1)*8
     .        xyz_cupbemi.DSC.S2 = (xyz_cupbemi.DSC.U1 + 1)*8                   
     .        xyz_cupbemi.DSC.S3 = xyz_cupbemi.DSC.U2*(xyz_cupbemi.DSC.U1 + 1)*8
     .        xyz_cupt.DSC.S2 = (xyz_cupt.DSC.U1 + 1)*8                         
     .        xyz_cupt.DSC.S3 = xyz_cupt.DSC.U2*(xyz_cupt.DSC.U1 + 1)*8         
     .        xyz_cuptdir.DSC.S2 = (xyz_cuptdir.DSC.U1 + 1)*8                   
     .        xyz_cuptdir.DSC.S3 = xyz_cuptdir.DSC.U2*(xyz_cuptdir.DSC.U1 + 1)*8
     .        xyz_cuptemi.DSC.S2 = (xyz_cuptemi.DSC.U1 + 1)*8                   
     .        xyz_cuptemi.DSC.S3 = xyz_cuptemi.DSC.U2*(xyz_cuptemi.DSC.U1 + 1)*8
     .        xyr_opdepadj.DSC.S2 = (xyr_opdepadj.DSC.U1 + 1)*8                 
     .        xyr_opdepadj.DSC.S3=xyr_opdepadj.DSC.U2*(xyr_opdepadj.DSC.U1+1)*8 
     .        xyaz_smalle.DSC.S2 = (xyaz_smalle.DSC.U1 + 1)*8                   
     .        xyaz_smalle.DSC.S3 = xyaz_smalle.DSC.U2*(xyaz_smalle.DSC.U1 + 1)*8
     .        xyaz_smalle.DSC.S4=4*xyaz_smalle.DSC.U2*(xyaz_smalle.DSC.U1+1)*8  
     .        xyz_b0.DSC.S2 = (xyz_b0.DSC.U1 + 1)*8                             
     .        xyz_b0.DSC.S3 = xyz_b0.DSC.U2*(xyz_b0.DSC.U1 + 1)*8               
     .        xy_tmpval.DSC.S2 = (xy_tmpval.DSC.U1 + 1)*8                       
     .        xyz_b1.DSC.S2 = (xyz_b1.DSC.U1 + 1)*8                             
     .        xyz_b1.DSC.S3 = xyz_b1.DSC.U2*(xyz_b1.DSC.U1 + 1)*8               
     .        xyz_mu1.DSC.S2 = (xyz_mu1.DSC.U1 + 1)*8                           
     .        xyz_mu1.DSC.S3 = xyz_mu1.DSC.U2*(xyz_mu1.DSC.U1 + 1)*8            
     .        if (rad_rte_two_stream_app_inited .ne. 0) goto 10001              
     .        call messagenotifyc ('E', module_name,                            
     .       1   'This module has not been initialized.', 1, 1, 1, 1, 1, 1, 1, 1
     .       2   , 1, 1, 1, 22, 37, 0, 0, 0, 0)                                 
     .  10001 continue                                                          
     .        if (flagtoaflux .eq. 0) goto 10002                                
     .        t717 = cvmgt(0,1,loc(solarfluxtoa).eq.1)                          
     .        if (t717 .ne. 0) goto 10312                                       
     .        call messagenotifyc ('E', module_name,                            
     .       1   'SolarFluxTOA has to be present.', 1, 1, 1, 1, 1, 1, 1, 1, 1, 1
     .       2   , 1, 22, 31, 0, 0, 0, 0)                                       
     .  10312 continue                                                          
     .        t721 = cvmgt(0,1,loc(xy_inangle).eq.1)                            
     .        if (t721 .ne. 0) goto 20001                                       
     .        call messagenotifyc ('E', module_name,                            
     .       1   'xy_InAngle has to be present.', 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
     .       2   1, 22, 29, 0, 0, 0, 0)                                         
     .  20001 continue                                                          
     .        goto 10004                                                        
     .  10002 continue                                                          
     .        t725 = cvmgt(0,1,loc(solarfluxtoa).eq.1)                          
     .        if (t725 .eq. 0) goto 10003                                       
     .        call messagenotifyc ('E', module_name,                            
     .       1   'SolarFluxTOA need not be present.', 1, 1, 1, 1, 1, 1, 1, 1, 1 
     .       2   , 1, 1, 22, 33, 0, 0, 0, 0)                                    
     .  10003 continue                                                          
     .        t729 = cvmgt(0,1,loc(xy_inangle).eq.1)                            
     .        if (t729 .eq. 0) goto 10004                                       
     .        call messagenotifyc ('E', module_name,                            
     .       1   'xy_InAngle need not be present.', 1, 1, 1, 1, 1, 1, 1, 1, 1, 1
     .       2   , 1, 22, 31, 0, 0, 0, 0)                                       
     .  10004 continue                                                          
     .        if (flagemis .eq. 0) goto 10005                                   
     .        t734 = cvmgt(0,1,loc(xyr_pfinted).eq.1)                           
     .        if (t734 .ne. 0) goto 10300                                       
     .        call messagenotifyc ('E', module_name,                            
     .       1   'xyr_PFInted has to be present.', 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 
     .       2   , 1, 22, 30, 0, 0, 0, 0)                                       
     .  10300 continue                                                          
     .        t738 = cvmgt(0,1,loc(xy_surfpfinted).eq.1)                        
     .        if (t738 .ne. 0) goto 10301                                       
     .        call messagenotifyc ('E', module_name,                            
     .       1   'xy_SurfPFInted has to be present.', 1, 1, 1, 1, 1, 1, 1, 1, 1 
     .       2   , 1, 1, 22, 33, 0, 0, 0, 0)                                    
     .  10301 continue                                                          
     .        t742 = cvmgt(0,1,loc(xy_surfdpfdtinted).eq.1)                     
     .        if (t742 .ne. 0) goto 10302                                       
     .        call messagenotifyc ('E', module_name,                            
     .       1   'xy_SurfDPFDTInted has to be present.', 1, 1, 1, 1, 1, 1, 1, 1 
     .       2   , 1, 1, 1, 22, 36, 0, 0, 0, 0)                                 
     .  10302 continue                                                          
     .        t746 = cvmgt(0,1,loc(xyra_delraduwflux).eq.1)                     
     .        if (t746 .ne. 0) goto 10303                                       
     .        call messagenotifyc ('E', module_name,                            
     .       1   'xyra_DelRadUwFlux has to be present.', 1, 1, 1, 1, 1, 1, 1, 1 
     .       2   , 1, 1, 1, 22, 36, 0, 0, 0, 0)                                 
     .  10303 continue                                                          
     .        t750 = cvmgt(0,1,loc(xyra_delraddwflux).eq.1)                     
     .        if (t750 .ne. 0) goto 20002                                       
     .        call messagenotifyc ('E', module_name,                            
     .       1   'xyra_DelRadLwFlux has to be present.', 1, 1, 1, 1, 1, 1, 1, 1 
     .       2   , 1, 1, 1, 22, 36, 0, 0, 0, 0)                                 
     .  20002 continue                                                          
     .        goto 10010                                                        
     .  10005 continue                                                          
     .        t754 = cvmgt(0,1,loc(xyr_pfinted).eq.1)                           
     .        if (t754 .eq. 0) goto 10006                                       
     .        call messagenotifyc ('E', module_name,                            
     .       1   'xyr_PFInted need not be present.', 1, 1, 1, 1, 1, 1, 1, 1, 1, 
     .       2   1, 1, 22, 32, 0, 0, 0, 0)                                      
     .  10006 continue                                                          
     .        t758 = cvmgt(0,1,loc(xy_surfpfinted).eq.1)                        
     .        if (t758 .eq. 0) goto 10007                                       
     .        call messagenotifyc ('E', module_name,                            
     .       1   'xy_SurfPFInted need not be present.', 1, 1, 1, 1, 1, 1, 1, 1, 
     .       2   1, 1, 1, 22, 35, 0, 0, 0, 0)                                   
     .  10007 continue                                                          
     .        t762 = cvmgt(0,1,loc(xy_surfdpfdtinted).eq.1)                     
     .        if (t762 .eq. 0) goto 10008                                       
     .        call messagenotifyc ('E', module_name,                            
     .       1   'xy_SurfDPFDTInted need not be present.', 1, 1, 1, 1, 1, 1, 1, 
     .       2   1, 1, 1, 1, 22, 38, 0, 0, 0, 0)                                
     .  10008 continue                                                          
     .        t766 = cvmgt(0,1,loc(xyra_delraduwflux).eq.1)                     
     .        if (t766 .eq. 0) goto 10009                                       
     .        call messagenotifyc ('E', module_name,                            
     .       1   'xyra_DelRadUwFlux need not be present.', 1, 1, 1, 1, 1, 1, 1, 
     .       2   1, 1, 1, 1, 22, 38, 0, 0, 0, 0)                                
     .  10009 continue                                                          
     .        t770 = cvmgt(0,1,loc(xyra_delraddwflux).eq.1)                     
     .        if (t770 .eq. 0) goto 10010                                       
     .        call messagenotifyc ('E', module_name,                            
     .       1   'xyra_DelRadLwFlux need not be present.', 1, 1, 1, 1, 1, 1, 1, 
     .       2   1, 1, 1, 1, 22, 38, 0, 0, 0, 0)                                
     .  10010 continue                                                          
     .        do k = 1, kmax                                                    
     .           do j = js, je                                                  
     .              do i = 0, imax - 1                                          
     .                 if (xyz_ssa(i,j,k) .ge. 1.00000000000000e+000) then      
     .                    %IG0(1) = xyz_ssa(i,j,k)                              
     .                    call messagenotifyc ('E', module_name,                
     .       1               'Single Scattering Albedo = %f', 1, 1, %IG0, 1, 1, 
     .       2               1, 1, 1, 1, 1, 1, 22, 29, 0, 0, 0, 0)              
     .                 endif                                                    
     .              enddo                                                       
     .           enddo                                                          
     .        enddo                                                             
     .        if (flagtoaflux .eq. 0) goto 10018                                
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do j = 1, imax - (js - je)*imax                                   
     .           if ((xy_inangle(j-1,js).gt.0.0000000000000000e+000)) then      
     .              xy_cossza1 = 1.00000000000000e+000/xy_inangle(j-1,js)       
     .              xy_cosszainv2 = xy_inangle(j-1,js)                          
     .              xy_cosszainvsq3 = xy_cosszainv2**2                          
     .           else                                                           
     .              xy_cossza1 = 0.0000000000000000e+000                        
     .              xy_cosszainv2 = 0.0000000000000000e+000                     
     .              xy_cosszainvsq3 = 0.0000000000000000e+000                   
     .           endif                                                          
     .           xy_cosszainvsq(j-1,js) = xy_cosszainvsq3                       
     .           xy_cosszainv(j-1,js) = xy_cosszainv2                           
     .           xy_cossza(j-1,js) = xy_cossza1                                 
     .           if ((xy_inangle(j-1,js).gt.0.0000000000000000e+000)) then      
     .              xy_solarfluxtoa4 = solarfluxtoa                             
     .           else                                                           
     .              xy_solarfluxtoa4 = 0.0000000000000000e+000                  
     .           endif                                                          
     .           xy_solarfluxtoa(j-1,js) = xy_solarfluxtoa4                     
     .        enddo                                                             
     .        goto 10027                                                        
     .  10018 continue                                                          
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do j = 1, (je + 1 - js)*(xy_cossza.DSC.U1 + 1)                    
     .           xy_cossza(j-1,js) = 1.00000000000000e+100                      
     .           xy_cosszainv(j-1,js) = 1.00000000000000e+100                   
     .           xy_cosszainvsq(j-1,js) = 1.00000000000000e+100                 
     .        enddo                                                             
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do j = 1, imax - (js - je)*imax                                   
     .           xy_solarfluxtoa(j-1,js) = 1.00000000000000e+100                
     .        enddo                                                             
     .  10027 continue                                                          
     .        do k = 1, kmax                                                    
     .  !cdir    nodep                                                          
     .  !cdir    noassume                                                       
     .           do j = 1, imax - (js - je)*imax                                
     .              xyz_afadj(j-1,js,k) = xyz_af(j-1,js,k)/(                    
     .       1         1.00000000000000e+000 + xyz_af(j-1,js,k))                
     .              xyz_ssaadj(j-1,js,k) = (1.00000000000000e+000 - (xyz_af(j-1,
     .       1         js,k)**2))*xyz_ssa(j-1,js,k)/(1.00000000000000e+000 -    
     .       2         xyz_ssa(j-1,js,k)*(xyz_af(j-1,js,k)**2))                 
     .           enddo                                                          
     .        enddo                                                             
     .        do k = 0, kmax                                                    
     .  !cdir    nodep                                                          
     .  !cdir    noassume                                                       
     .           do j = 1, (je + 1 - js)*(xyr_opdepadj.DSC.U1 + 1)              
     .              xyr_opdepadj(j-1,js,k) = 0.0000000000000000e+000            
     .           enddo                                                          
     .        enddo                                                             
     .        do k = kmax - 1, 0, -1                                            
     .  !cdir    nodep                                                          
     .  !cdir    noassume                                                       
     .           do j = 1, (je + 1 - js)*(xyr_opdepadj.DSC.U1 + 1)              
     .              xyr_opdepadj(j-1,js,k) = xyr_opdepadj(j-1,js,k+1) + (       
     .       1         1.00000000000000e+000 - xyz_ssa(j-1,js,k+1)*xyz_af(j-1,js
     .       2         ,k+1)**2)*(xyr_optdep(j-1,js,k)-xyr_optdep(j-1,js,k+1))  
     .           enddo                                                          
     .        enddo                                                             
     .        if (flagtoaflux .eq. 0) goto 10049                                
     .        do k = 0, kmax                                                    
     .  !cdir    nodep                                                          
     .  !cdir    noassume                                                       
     .  !cdir    on_adb(xy_cosszainv)                                           
     .           do j = 1, (je + 1 - js)*(xyr_opdepadj.DSC.U1 + 1)              
     .              xyr_transdiradj(j-1,js,k) = dexp((-xyr_opdepadj(j-1,js,k)*  
     .       1         xy_cosszainv(j-1,js)))                                   
     .           enddo                                                          
     .        enddo                                                             
     .        goto 10056                                                        
     .  10049 continue                                                          
     .        do k = 0, kmax                                                    
     .  !cdir    nodep                                                          
     .  !cdir    noassume                                                       
     .           do j = 1, (je + 1 - js)*(xyr_transdiradj.DSC.U1 + 1)           
     .              xyr_transdiradj(j-1,js,k) = 1.00000000000000e+100           
     .           enddo                                                          
     .        enddo                                                             
     .  10056 continue                                                          
     .        if (idscatapprox.eq.11 .ne. 0) goto 10259                         
     .        if (idscatapprox.eq.12 .ne. 0) goto 10246                         
     .        goto 10058                                                        
     .  10259 continue                                                          
     .        do k = 1, kmax                                                    
     .           d5 = 1.D0/4.00000000000000e+000                                
     .           d6 = 1.D0/4.00000000000000e+000                                
     .           d7 = 1.D0/4.00000000000000e+000                                
     .  !cdir    nodep                                                          
     .  !cdir    noassume                                                       
     .  !cdir    on_adb(xy_cossza)                                              
     .           do j = 1, (je + 1 - js)*(xyz_ssaadj.DSC.U1 + 1)                
     .              xyz_gam1(j-1,js,k) = (7.00000000000000e+000 - xyz_ssaadj(j-1
     .       1         ,js,k)*(4.00000000000000e+000+(3.00000000000000e+000*    
     .       2         xyz_afadj(j-1,js,k))))*d5                                
     .              xyz_gam2(j-1,js,k) = -(1.00000000000000e+000 - xyz_ssaadj(j-
     .       1         1,js,k)*(4.00000000000000e+000-(3.00000000000000e+000*   
     .       2         xyz_afadj(j-1,js,k))))*d6                                
     .              xyz_gam3(j-1,js,k) = (2.00000000000000e+000 - (             
     .       1         3.00000000000000e+000*xyz_afadj(j-1,js,k))*xy_cossza(j-1,
     .       2         js))*d7                                                  
     .              xyz_gam4(j-1,js,k)=1.00000000000000e+000-xyz_gam3(j-1,js,k) 
     .           enddo                                                          
     .        enddo                                                             
     .        do k = 1, kmax                                                    
     .  !cdir    nodep                                                          
     .  !cdir    noassume                                                       
     .           do j = 1, imax - (js - je)*imax                                
     .              xyz_mu1(j-1,js,k) = 5.00000000000000e-001                   
     .           enddo                                                          
     .        enddo                                                             
     .        goto 10059                                                        
     .  10246 continue                                                          
     .        do k = 1, kmax                                                    
     .  !cdir    nodep                                                          
     .  !cdir    noassume                                                       
     .           do j = 1, (je + 1 - js)*(xyz_ssaadj.DSC.U1 + 1)                
     .              xyz_gam1(j-1,js,k) = 2.00000000000000e+000 - xyz_ssaadj(j-1,
     .       1         js,k)*(1.00000000000000e+000 + xyz_afadj(j-1,js,k))      
     .              xyz_gam2(j-1,js,k) = xyz_ssaadj(j-1,js,k)*(                 
     .       1         1.00000000000000e+000 - xyz_afadj(j-1,js,k))             
     .              xyz_gam3(j-1,js,k) = 1.00000000000000e+100                  
     .              xyz_gam4(j-1,js,k) = 1.00000000000000e+100                  
     .           enddo                                                          
     .        enddo                                                             
     .        do k = 1, kmax                                                    
     .  !cdir    nodep                                                          
     .  !cdir    noassume                                                       
     .           do j = 1, imax - (js - je)*imax                                
     .              xyz_mu1(j-1,js,k) = 5.00000000000000e-001                   
     .           enddo                                                          
     .        enddo                                                             
     .        goto 10059                                                        
     .  10058 continue                                                          
     .        %IG1(1) = idscatapprox                                            
     .        call messagenotifyc ('E', module_name,                            
     .       1   'Unexpected IDScatApprox, %d', %IG1, 1, 1, 1, 1, 1, 1, 1, 1, 1 
     .       2   , 1, 22, 27, 0, 0, 0, 0)                                       
     .  10059 continue                                                          
     .        do k = 1, kmax                                                    
     .  !cdir    nodep                                                          
     .  !cdir    noassume                                                       
     .  !cdir    on_adb(xyr_opdepadj)                                           
     .           do j = 1, (je + 1 - js)*(xyr_opdepadj.DSC.U1 + 1)              
     .              xyz_deltau(j-1,js,k) = xyr_opdepadj(j-1,js,k-1) -           
     .       1         xyr_opdepadj(j-1,js,k)                                   
     .           enddo                                                          
     .        enddo                                                             
     .        if (flagemis .eq. 0) goto 10067                                   
     .        do k = 1, kmax                                                    
     .  !cdir    nodep                                                          
     .  !cdir    noassume                                                       
     .           do j = 1, imax - (js - je)*imax                                
     .              if (xyz_deltau(j-1,js,k) .lt. 1.00000000000000e-010) then   
     .                 xyz_deltau(j-1,js,k) = 0.0000000000000000e+000           
     .              endif                                                       
     .           enddo                                                          
     .        enddo                                                             
     .  10067 continue                                                          
     .        do k = 1, kmax                                                    
     .  !cdir    nodep                                                          
     .  !cdir    noassume                                                       
     .           do j = 1, (je + 1 - js)*(xyz_gam1.DSC.U1 + 1)                  
     .              xyz_lambda(j-1,js,k) = dsqrt(max(xyz_gam1(j-1,js,k)*xyz_gam1
     .       1         (j-1,js,k)-xyz_gam2(j-1,js,k)*xyz_gam2(j-1,js,k),        
     .       2         0.0000000000000000e+000))                                
     .              xyz_lgamma(j-1,js,k) = xyz_gam2(j-1,js,k)/(xyz_gam1(j-1,js,k
     .       1         )+xyz_lambda(j-1,js,k))                                  
     .           enddo                                                          
     .        enddo                                                             
     .        do k = 1, kmax                                                    
     .  !cdir    nodep                                                          
     .  !cdir    noassume                                                       
     .  !cdir    on_adb(xy_tmpval)                                              
     .           do j = 1, (je + 1 - js)*(xyz_lambda.DSC.U1 + 1)                
     .              xy_tmpval(j-1,js) = dexp((-xyz_lambda(j-1,js,k)*xyz_deltau(j
     .       1         -1,js,k)))                                               
     .              xyaz_smalle(j-1,js,1,k) = (xyz_lgamma(j-1,js,k)*xy_tmpval(j-
     .       1         1,js)) + 1.00000000000000e+000                           
     .              xyaz_smalle(j-1,js,2,k) = (xyz_lgamma(j-1,js,k)*xy_tmpval(j-
     .       1         1,js)) - 1.00000000000000e+000                           
     .              xyaz_smalle(j-1,js,3,k) = xy_tmpval(j-1,js) + xyz_lgamma(j-1
     .       1         ,js,k)                                                   
     .              xyaz_smalle(j-1,js,4,k) = xy_tmpval(j-1,js) - xyz_lgamma(j-1
     .       1         ,js,k)                                                   
     .           enddo                                                          
     .        enddo                                                             
     .        if (flagtoaflux .eq. 0) goto 10082                                
     .        do k = 1, kmax                                                    
     .  !cdir    nodep                                                          
     .  !cdir    noassume                                                       
     .  !cdir    on_adb(xy_cosszainv,xy_tmpval,xy_solarfluxtoa,xy_cosszainvsq,xy
     .       1      r_transdiradj)                                              
     .           do j = 1, (je + 1 - js)*(xyz_ssaadj.DSC.U1 + 1)                
     .              xy_tmpval1 = (xyz_ssaadj(j-1,js,k)*xy_solarfluxtoa(j-1,js))*
     .       1         ((xyz_gam1(j-1,js,k)-xy_cosszainv(j-1,js))*xyz_gam3(j-1, 
     .       2         js,k)+xyz_gam2(j-1,js,k)*xyz_gam4(j-1,js,k))/((xyz_lambda
     .       3         (j-1,js,k)*xyz_lambda(j-1,js,k))-xy_cosszainvsq(j-1,js)) 
     .              xyz_cupbdir(j-1,js,k) = xy_tmpval1*xyr_transdiradj(j-1,js,k-
     .       1         1)                                                       
     .              xyz_cuptdir(j-1,js,k) = xy_tmpval1*xyr_transdiradj(j-1,js,k)
     .              xy_tmpval1 = (xyz_ssaadj(j-1,js,k)*xy_solarfluxtoa(j-1,js))*
     .       1         ((xyz_gam1(j-1,js,k)+xy_cosszainv(j-1,js))*xyz_gam4(j-1, 
     .       2         js,k)+xyz_gam2(j-1,js,k)*xyz_gam3(j-1,js,k))/((xyz_lambda
     .       3         (j-1,js,k)*xyz_lambda(j-1,js,k))-xy_cosszainvsq(j-1,js)) 
     .              xyz_cdobdir(j-1,js,k) = xy_tmpval1*xyr_transdiradj(j-1,js,k-
     .       1         1)                                                       
     .              xyz_cdotdir(j-1,js,k) = xy_tmpval1*xyr_transdiradj(j-1,js,k)
     .           enddo                                                          
     .        enddo                                                             
     .        goto 10089                                                        
     .  10082 continue                                                          
     .        do k = 1, kmax                                                    
     .  !cdir    nodep                                                          
     .  !cdir    noassume                                                       
     .           do j = 1, (je + 1 - js)*(xyz_cupbdir.DSC.U1 + 1)               
     .              xyz_cupbdir(j-1,js,k) = 0.0000000000000000e+000             
     .              xyz_cuptdir(j-1,js,k) = 0.0000000000000000e+000             
     .              xyz_cdobdir(j-1,js,k) = 0.0000000000000000e+000             
     .              xyz_cdotdir(j-1,js,k) = 0.0000000000000000e+000             
     .           enddo                                                          
     .        enddo                                                             
     .  10089 continue                                                          
     .        if (flagemis .eq. 0) goto 10090                                   
     .        do k = 1, kmax                                                    
     .  !cdir    nodep                                                          
     .  !cdir    noassume                                                       
     .  !cdir    on_adb(xyr_pfinted)                                            
     .           do j = 1, imax - (js - je)*imax                                
     .              if (xyz_deltau(j-1,js,k) .ne. 0.0000000000000000e+000) then 
     .                 xyz_b09 = xyr_pfinted(j-1,js,k)                          
     .                 xyz_b110 = (xyr_pfinted(j-1,js,k-1)-xyr_pfinted(j-1,js,k)
     .       1            )/xyz_deltau(j-1,js,k)                                
     .              else                                                        
     .                 xyz_b09 = xyr_pfinted(j-1,js,k)                          
     .                 xyz_b110 = 0.0000000000000000e+000                       
     .              endif                                                       
     .              xyz_b1(j-1,js,k) = xyz_b110                                 
     .              xyz_b0(j-1,js,k) = xyz_b09                                  
     .              xyz_cupbemi(j-1,js,k) = (2.00000000000000e+000*xyz_mu1(j-1, 
     .       1         js,k))*(xyz_b0(j-1,js,k)+xyz_b1(j-1,js,k)*(xyz_deltau(j-1
     .       2         ,js,k)+(1.00000000000000e+000/(xyz_gam1(j-1,js,k)+       
     .       3         xyz_gam2(j-1,js,k)))))                                   
     .              xyz_cuptemi(j-1,js,k) = (2.00000000000000e+000*xyz_mu1(j-1, 
     .       1         js,k))*(xyz_b0(j-1,js,k)+xyz_b1(j-1,js,k)*(              
     .       2         0.0000000000000000e+000+(1.00000000000000e+000/(xyz_gam1(
     .       3         j-1,js,k)+xyz_gam2(j-1,js,k)))))                         
     .              xyz_cdobemi(j-1,js,k) = (2.00000000000000e+000*xyz_mu1(j-1, 
     .       1         js,k))*(xyz_b0(j-1,js,k)+xyz_b1(j-1,js,k)*(xyz_deltau(j-1
     .       2         ,js,k)-(1.00000000000000e+000/(xyz_gam1(j-1,js,k)+       
     .       3         xyz_gam2(j-1,js,k)))))                                   
     .              xyz_cdotemi(j-1,js,k) = (2.00000000000000e+000*xyz_mu1(j-1, 
     .       1         js,k))*(xyz_b0(j-1,js,k)+xyz_b1(j-1,js,k)*(              
     .       2         0.0000000000000000e+000-(1.00000000000000e+000/(xyz_gam1(
     .       3         j-1,js,k)+xyz_gam2(j-1,js,k)))))                         
     .           enddo                                                          
     .        enddo                                                             
     .        goto 10097                                                        
     .  10090 continue                                                          
     .        do k = 1, kmax                                                    
     .  !cdir    nodep                                                          
     .  !cdir    noassume                                                       
     .           do j = 1, (je + 1 - js)*(xyz_cupbemi.DSC.U1 + 1)               
     .              xyz_cupbemi(j-1,js,k) = 0.0000000000000000e+000             
     .              xyz_cuptemi(j-1,js,k) = 0.0000000000000000e+000             
     .              xyz_cdobemi(j-1,js,k) = 0.0000000000000000e+000             
     .              xyz_cdotemi(j-1,js,k) = 0.0000000000000000e+000             
     .           enddo                                                          
     .        enddo                                                             
     .  10097 continue                                                          
     .        do k = 1, kmax                                                    
     .  !cdir    nodep                                                          
     .  !cdir    noassume                                                       
     .           do j = 1, (je + 1 - js)*(xyz_cupbdir.DSC.U1 + 1)               
     .              xyz_cupb(j-1,js,k) = xyz_cupbdir(j-1,js,k) + xyz_cupbemi(j-1
     .       1         ,js,k)                                                   
     .              xyz_cupt(j-1,js,k) = xyz_cuptdir(j-1,js,k) + xyz_cuptemi(j-1
     .       1         ,js,k)                                                   
     .              xyz_cdob(j-1,js,k) = xyz_cdobdir(j-1,js,k) + xyz_cdobemi(j-1
     .       1         ,js,k)                                                   
     .              xyz_cdot(j-1,js,k) = xyz_cdotdir(j-1,js,k) + xyz_cdotemi(j-1
     .       1         ,js,k)                                                   
     .           enddo                                                          
     .        enddo                                                             
     .        if (flagemis .eq. 0) goto 10105                                   
     .        do j = js, je                                                     
     .  !cdir    nodep                                                          
     .  !cdir    noassume                                                       
     .           do t36251 = 0, xy_surfsrc.DSC.U1, maxvl()                      
     .              t36252 = min0(xy_surfsrc.DSC.U1 + 1 - t36251,maxvl())       
     .              do i = 1, imax                                              
     .  !cdir          shortloop                                                
     .  !cdir          nodep                                                    
     .  !cdir          on_adb(xy_surfpfinted,xy_surfsrc)                        
     .                 do t3625 = 1, t36252                                     
     .                    xy_surfsrc(t36251+t3625-1,j) = xy_surfpfinted(t36251+ 
     .       1               t3625-1,j)                                         
     .                 enddo                                                    
     .              enddo                                                       
     .           enddo                                                          
     .        enddo                                                             
     .        goto 10112                                                        
     .  10105 continue                                                          
     .        do j = js, je                                                     
     .  !cdir    nodep                                                          
     .  !cdir    noassume                                                       
     .           do t35731 = 0, xy_surfsrc.DSC.U1, maxvl()                      
     .              t35732 = min0(xy_surfsrc.DSC.U1 + 1 - t35731,maxvl())       
     .              do i = 1, imax                                              
     .  !cdir          shortloop                                                
     .  !cdir          nodep                                                    
     .  !cdir          on_adb(xy_surfsrc)                                       
     .                 do t3573 = 1, t35732                                     
     .                    xy_surfsrc(t35731+t3573-1,j) = 0.0000000000000000e+000
     .                 enddo                                                    
     .              enddo                                                       
     .           enddo                                                          
     .        enddo                                                             
     .  10112 continue                                                          
     .        if (flagtoaflux .eq. 0) goto 10113                                
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xy_cossza,xy_solarfluxtoa,xyr_transdiradj,xy_surfsrc)      
     .        do j = 1, (je + 1 - js)*(xy_surfsrc.DSC.U1 + 1)                   
     .           xy_surfsrc(j-1,js) = xy_surfsrc(j-1,js) + xy_surfalbedo(j-1,js)
     .       1      *xy_solarfluxtoa(j-1,js)*xyr_transdiradj(j-1,js,0)*xy_cossza
     .       2      (j-1,js)                                                    
     .        enddo                                                             
     .  10113 continue                                                          
     .        k = 1                                                             
     .        l = 1                                                             
     .        if (je + 1 - js .gt. 0) then                                      
     .           j1 = and(je + 1 - js,3)                                        
     .           do j = 1, j1                                                   
     .  !cdir       nodep                                                       
     .  !cdir       on_adb(xy_surfsrc)                                          
     .              do i = 1, imax                                              
     .                 aa_tridiagmtx1(imax*(js+j)-imax-imax+i,1) =              
     .       1            0.0000000000000000e+000                               
     .                 aa_tridiagmtx2(imax*(js+j)-imax-imax+i,1) = xyaz_smalle(i
     .       1            -1,j-1+js,1,1) - xy_surfalbedo(i-1,j-1+js)*xyaz_smalle
     .       2            (i-1,j-1+js,3,1)                                      
     .                 aa_tridiagmtx3(imax*(js+j)-imax-imax+i,1) = -(xyaz_smalle
     .       1            (i-1,j-1+js,2,1)-xy_surfalbedo(i-1,j-1+js)*xyaz_smalle
     .       2            (i-1,j-1+js,4,1))                                     
     .                 aa_vec(imax*(js+j)-imax-imax+i,1) = xy_surfalbedo(i-1,j-1
     .       1            +js)*xyz_cdob(i-1,j-1+js,1) - xyz_cupb(i-1,j-1+js,1)  
     .       2             + xy_surfsrc(i-1,j-1+js)                             
     .              enddo                                                       
     .           enddo                                                          
     .           do j = j1 + 1, je + 1 - js, 4                                  
     .  !cdir       nodep                                                       
     .              do i = 1, imax                                              
     .                 aa_tridiagmtx1(imax*(js+j)-imax-imax+i,1) =              
     .       1            0.0000000000000000e+000                               
     .                 aa_tridiagmtx1(imax*(js+j)-imax+i,1) =                   
     .       1            0.0000000000000000e+000                               
     .                 aa_tridiagmtx1(imax*(js+j)+i,1) = 0.0000000000000000e+000
     .                 aa_tridiagmtx1(imax*(j+2+js)-imax+i,1) =                 
     .       1            0.0000000000000000e+000                               
     .                 aa_tridiagmtx2(imax*(js+j)-imax-imax+i,1) = xyaz_smalle(i
     .       1            -1,j-1+js,1,1) - xy_surfalbedo(i-1,j-1+js)*xyaz_smalle
     .       2            (i-1,j-1+js,3,1)                                      
     .                 aa_tridiagmtx2(imax*(js+j)-imax+i,1) = xyaz_smalle(i-1,j+
     .       1            js,1,1) - xy_surfalbedo(i-1,j+js)*xyaz_smalle(i-1,j+js
     .       2            ,3,1)                                                 
     .                 aa_tridiagmtx2(imax*(js+j)+i,1) = xyaz_smalle(i-1,j+1+js,
     .       1            1,1) - xy_surfalbedo(i-1,j+1+js)*xyaz_smalle(i-1,j+1+ 
     .       2            js,3,1)                                               
     .                 aa_tridiagmtx2(imax*(j+2+js)-imax+i,1) = xyaz_smalle(i-1,
     .       1            j+2+js,1,1) - xy_surfalbedo(i-1,j+2+js)*xyaz_smalle(i-
     .       2            1,j+2+js,3,1)                                         
     .                 aa_tridiagmtx3(imax*(js+j)-imax-imax+i,1) = xy_surfalbedo
     .       1            (i-1,j-1+js)*xyaz_smalle(i-1,j-1+js,4,1) - xyaz_smalle
     .       2            (i-1,j-1+js,2,1)                                      
     .                 aa_tridiagmtx3(imax*(js+j)-imax+i,1) = xy_surfalbedo(i-1,
     .       1            j+js)*xyaz_smalle(i-1,j+js,4,1) - xyaz_smalle(i-1,j+js
     .       2            ,2,1)                                                 
     .                 aa_tridiagmtx3(imax*(js+j)+i,1) = xy_surfalbedo(i-1,j+1+ 
     .       1            js)*xyaz_smalle(i-1,j+1+js,4,1) - xyaz_smalle(i-1,j+1+
     .       2            js,2,1)                                               
     .                 aa_tridiagmtx3(imax*(j+2+js)-imax+i,1) = xy_surfalbedo(i-
     .       1            1,j+2+js)*xyaz_smalle(i-1,j+2+js,4,1) - xyaz_smalle(i-
     .       2            1,j+2+js,2,1)                                         
     .                 aa_vec(imax*(js+j)-imax-imax+i,1) = xy_surfalbedo(i-1,j-1
     .       1            +js)*xyz_cdob(i-1,j-1+js,1) - xyz_cupb(i-1,j-1+js,1)  
     .       2             + xy_surfsrc(i-1,j-1+js)                             
     .                 aa_vec(imax*(js+j)-imax+i,1) = xy_surfalbedo(i-1,j+js)*  
     .       1            xyz_cdob(i-1,j+js,1) - xyz_cupb(i-1,j+js,1) +         
     .       2            xy_surfsrc(i-1,j+js)                                  
     .                 aa_vec(imax*(js+j)+i,1) = xy_surfalbedo(i-1,j+1+js)*     
     .       1            xyz_cdob(i-1,j+1+js,1) - xyz_cupb(i-1,j+1+js,1) +     
     .       2            xy_surfsrc(i-1,j+1+js)                                
     .                 aa_vec(imax*(j+2+js)-imax+i,1) = xy_surfalbedo(i-1,j+2+js
     .       1            )*xyz_cdob(i-1,j+2+js,1) - xyz_cupb(i-1,j+2+js,1) +   
     .       2            xy_surfsrc(i-1,j+2+js)                                
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
     .        do k = 1, kmax - 1                                                
     .           do j = js, je                                                  
     .              l1 = 2*k                                                    
     .              l = 2*k + 1                                                 
     .  !cdir       nodep                                                       
     .  !cdir       on_adb(xyaz_smalle)                                         
     .              do i = 1, imax                                              
     .                 aa_tridiagmtx1(imax*j-imax+i,l1) = (xyaz_smalle(i-1,j,1,k
     .       1            )*xyaz_smalle(i-1,j,2,k+1)) - (xyaz_smalle(i-1,j,3,k)*
     .       2            xyaz_smalle(i-1,j,4,k+1))                             
     .                 aa_tridiagmtx2(imax*j-imax+i,l1) = xyaz_smalle(i-1,j,2,k)
     .       1            *xyaz_smalle(i-1,j,2,k+1) - xyaz_smalle(i-1,j,4,k)*   
     .       2            xyaz_smalle(i-1,j,4,k+1)                              
     .                 aa_tridiagmtx3(imax*j-imax+i,l1) = xyaz_smalle(i-1,j,1,k+
     .       1            1)*xyaz_smalle(i-1,j,4,k+1) - xyaz_smalle(i-1,j,2,k+1)
     .       2            *xyaz_smalle(i-1,j,3,k+1)                             
     .                 aa_vec(imax*j-imax+i,l1) = xyaz_smalle(i-1,j,2,k+1)*(    
     .       1            xyz_cdob(i-1,j,k+1)-xyz_cdot(i-1,j,k)) - xyaz_smalle(i
     .       2            -1,j,4,k+1)*(xyz_cupb(i-1,j,k+1)-xyz_cupt(i-1,j,k))   
     .                 aa_tridiagmtx1(imax*j-imax+i,l) = xyaz_smalle(i-1,j,2,k)*
     .       1            xyaz_smalle(i-1,j,3,k) - xyaz_smalle(i-1,j,1,k)*      
     .       2            xyaz_smalle(i-1,j,4,k)                                
     .                 aa_tridiagmtx2(imax*j-imax+i,l) = xyaz_smalle(i-1,j,1,k)*
     .       1            xyaz_smalle(i-1,j,1,k+1) - xyaz_smalle(i-1,j,3,k)*    
     .       2            xyaz_smalle(i-1,j,3,k+1)                              
     .                 aa_tridiagmtx3(imax*j-imax+i,l) = (xyaz_smalle(i-1,j,3,k)
     .       1            *xyaz_smalle(i-1,j,4,k+1)) - (xyaz_smalle(i-1,j,1,k)* 
     .       2            xyaz_smalle(i-1,j,2,k+1))                             
     .                 aa_vec(imax*j-imax+i,l) = xyaz_smalle(i-1,j,3,k)*(       
     .       1            xyz_cdob(i-1,j,k+1)-xyz_cdot(i-1,j,k)) - xyaz_smalle(i
     .       2            -1,j,1,k)*(xyz_cupb(i-1,j,k+1)-xyz_cupt(i-1,j,k))     
     .              enddo                                                       
     .           enddo                                                          
     .        enddo                                                             
     .        k = kmax                                                          
     .        l = 2*kmax                                                        
     .        if (je + 1 - js .gt. 0) then                                      
     .           j3 = and(je + 1 - js,3)                                        
     .           do j = 1, j3                                                   
     .  !cdir       nodep                                                       
     .  !cdir       on_adb(xyaz_smalle)                                         
     .              do i = 1, imax                                              
     .                 aa_tridiagmtx1(imax*(js+j)-imax-imax+i,l) = xyaz_smalle(i
     .       1            -1,j-1+js,1,k)                                        
     .                 aa_tridiagmtx2(imax*(js+j)-imax-imax+i,l) = xyaz_smalle(i
     .       1            -1,j-1+js,2,k)                                        
     .                 aa_tridiagmtx3(imax*(js+j)-imax-imax+i,l) =              
     .       1            0.0000000000000000e+000                               
     .                 aa_vec(imax*(js+j)-imax-imax+i,l) =                      
     .       1            0.0000000000000000e+000 - xyz_cdot(i-1,j-1+js,k)      
     .              enddo                                                       
     .           enddo                                                          
     .           do j = j3 + 1, je + 1 - js, 4                                  
     .  !cdir       nodep                                                       
     .  !cdir       on_adb(xyaz_smalle)                                         
     .              do i = 1, imax                                              
     .                 aa_tridiagmtx1(imax*(js+j)-imax-imax+i,l) = xyaz_smalle(i
     .       1            -1,j-1+js,1,k)                                        
     .                 aa_tridiagmtx1(imax*(js+j)-imax+i,l) = xyaz_smalle(i-1,j+
     .       1            js,1,k)                                               
     .                 aa_tridiagmtx1(imax*(js+j)+i,l) = xyaz_smalle(i-1,j+1+js,
     .       1            1,k)                                                  
     .                 aa_tridiagmtx1(imax*(j+2+js)-imax+i,l) = xyaz_smalle(i-1,
     .       1            j+2+js,1,k)                                           
     .                 aa_tridiagmtx2(imax*(js+j)-imax-imax+i,l) = xyaz_smalle(i
     .       1            -1,j-1+js,2,k)                                        
     .                 aa_tridiagmtx2(imax*(js+j)-imax+i,l) = xyaz_smalle(i-1,j+
     .       1            js,2,k)                                               
     .                 aa_tridiagmtx2(imax*(js+j)+i,l) = xyaz_smalle(i-1,j+1+js,
     .       1            2,k)                                                  
     .                 aa_tridiagmtx2(imax*(j+2+js)-imax+i,l) = xyaz_smalle(i-1,
     .       1            j+2+js,2,k)                                           
     .                 aa_tridiagmtx3(imax*(js+j)-imax-imax+i,l) =              
     .       1            0.0000000000000000e+000                               
     .                 aa_tridiagmtx3(imax*(js+j)-imax+i,l) =                   
     .       1            0.0000000000000000e+000                               
     .                 aa_tridiagmtx3(imax*(js+j)+i,l) = 0.0000000000000000e+000
     .                 aa_tridiagmtx3(imax*(j+2+js)-imax+i,l) =                 
     .       1            0.0000000000000000e+000                               
     .                 aa_vec(imax*(js+j)-imax-imax+i,l) =                      
     .       1            0.0000000000000000e+000 - xyz_cdot(i-1,j-1+js,k)      
     .                 aa_vec(imax*(js+j)-imax+i,l) = 0.0000000000000000e+000 - 
     .       1            xyz_cdot(i-1,j+js,k)                                  
     .                 aa_vec(imax*(js+j)+i,l) = 0.0000000000000000e+000 -      
     .       1            xyz_cdot(i-1,j+1+js,k)                                
     .                 aa_vec(imax*(j+2+js)-imax+i,l) = 0.0000000000000000e+000 
     .       1             - xyz_cdot(i-1,j+2+js,k)                             
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
     .        ms = 1 + imax*(js - 1)                                            
     .        me = imax + imax*(je - 1)                                         
     .        call tridiag (imax*jmax, 2*kmax, aa_tridiagmtx1, aa_tridiagmtx2,  
     .       1   aa_tridiagmtx3, aa_vec, ms, me)                                
     .        if (flagsrcfunctech .ne. 0) goto 10133                            
     .        k = 1                                                             
     .        if (je + 1 - js .gt. 0) then                                      
     .           j4 = and(je + 1 - js,3)                                        
     .           do j = 1, j4                                                   
     .  !cdir       nodep                                                       
     .  !cdir       on_adb(xyaz_smalle)                                         
     .              do i = 1, imax                                              
     .                 xyr_raduwflux(i-1,j-1+js,0) = aa_vec(imax*(js+j)-imax-   
     .       1            imax+i,1)*xyaz_smalle(i-1,j-1+js,1,1) - aa_vec(imax*( 
     .       2            js+j)-imax-imax+i,2)*xyaz_smalle(i-1,j-1+js,2,1) +    
     .       3            xyz_cupb(i-1,j-1+js,1)                                
     .                 xyr_raddwflux(i-1,j-1+js,0) = aa_vec(imax*(js+j)-imax-   
     .       1            imax+i,1)*xyaz_smalle(i-1,j-1+js,3,1) - aa_vec(imax*( 
     .       2            js+j)-imax-imax+i,2)*xyaz_smalle(i-1,j-1+js,4,1) +    
     .       3            xyz_cdob(i-1,j-1+js,1)                                
     .              enddo                                                       
     .           enddo                                                          
     .           do j = j4 + 1, je + 1 - js, 4                                  
     .  !cdir       nodep                                                       
     .  !cdir       on_adb(xyaz_smalle)                                         
     .              do i = 1, imax                                              
     .                 xyr_raduwflux(i-1,j-1+js,0) = aa_vec(imax*(js+j)-imax-   
     .       1            imax+i,1)*xyaz_smalle(i-1,j-1+js,1,1) - aa_vec(imax*( 
     .       2            js+j)-imax-imax+i,2)*xyaz_smalle(i-1,j-1+js,2,1) +    
     .       3            xyz_cupb(i-1,j-1+js,1)                                
     .                 xyr_raduwflux(i-1,j+js,0) = aa_vec(imax*(js+j)-imax+i,1)*
     .       1            xyaz_smalle(i-1,j+js,1,1) - aa_vec(imax*(js+j)-imax+i,
     .       2            2)*xyaz_smalle(i-1,j+js,2,1) + xyz_cupb(i-1,j+js,1)   
     .                 xyr_raduwflux(i-1,j+1+js,0) = aa_vec(imax*(js+j)+i,1)*   
     .       1            xyaz_smalle(i-1,j+1+js,1,1) - aa_vec(imax*(js+j)+i,2)*
     .       2            xyaz_smalle(i-1,j+1+js,2,1) + xyz_cupb(i-1,j+1+js,1)  
     .                 xyr_raduwflux(i-1,j+2+js,0) = aa_vec(imax*(j+2+js)-imax+i
     .       1            ,1)*xyaz_smalle(i-1,j+2+js,1,1) - aa_vec(imax*(j+2+js)
     .       2            -imax+i,2)*xyaz_smalle(i-1,j+2+js,2,1) + xyz_cupb(i-1,
     .       3            j+2+js,1)                                             
     .                 xyr_raddwflux(i-1,j-1+js,0) = aa_vec(imax*(js+j)-imax-   
     .       1            imax+i,1)*xyaz_smalle(i-1,j-1+js,3,1) - aa_vec(imax*( 
     .       2            js+j)-imax-imax+i,2)*xyaz_smalle(i-1,j-1+js,4,1) +    
     .       3            xyz_cdob(i-1,j-1+js,1)                                
     .                 xyr_raddwflux(i-1,j+js,0) = aa_vec(imax*(js+j)-imax+i,1)*
     .       1            xyaz_smalle(i-1,j+js,3,1) - aa_vec(imax*(js+j)-imax+i,
     .       2            2)*xyaz_smalle(i-1,j+js,4,1) + xyz_cdob(i-1,j+js,1)   
     .                 xyr_raddwflux(i-1,j+1+js,0) = aa_vec(imax*(js+j)+i,1)*   
     .       1            xyaz_smalle(i-1,j+1+js,3,1) - aa_vec(imax*(js+j)+i,2)*
     .       2            xyaz_smalle(i-1,j+1+js,4,1) + xyz_cdob(i-1,j+1+js,1)  
     .                 xyr_raddwflux(i-1,j+2+js,0) = aa_vec(imax*(j+2+js)-imax+i
     .       1            ,1)*xyaz_smalle(i-1,j+2+js,3,1) - aa_vec(imax*(j+2+js)
     .       2            -imax+i,2)*xyaz_smalle(i-1,j+2+js,4,1) + xyz_cdob(i-1,
     .       3            j+2+js,1)                                             
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
     .        do k = 1, kmax                                                    
     .           if (je + 1 - js .gt. 0) then                                   
     .              j5 = and(je + 1 - js,3)                                     
     .              do j = 1, j5                                                
     .  !cdir          nodep                                                    
     .  !cdir          on_adb(xyaz_smalle,aa_vec)                               
     .                 do i = 1, imax                                           
     .                    xyr_raduwflux(i-1,j-1+js,k) = aa_vec(imax*(js+j)-imax-
     .       1               imax+i,2*k-1)*xyaz_smalle(i-1,j-1+js,3,k) + aa_vec(
     .       2               imax*(js+j)-imax-imax+i,2*k)*xyaz_smalle(i-1,j-1+js
     .       3               ,4,k) + xyz_cupt(i-1,j-1+js,k)                     
     .                    xyr_raddwflux(i-1,j-1+js,k) = aa_vec(imax*(js+j)-imax-
     .       1               imax+i,2*k-1)*xyaz_smalle(i-1,j-1+js,1,k) + aa_vec(
     .       2               imax*(js+j)-imax-imax+i,2*k)*xyaz_smalle(i-1,j-1+js
     .       3               ,2,k) + xyz_cdot(i-1,j-1+js,k)                     
     .                 enddo                                                    
     .              enddo                                                       
     .              do j = j5 + 1, je + 1 - js, 4                               
     .  !cdir          nodep                                                    
     .  !cdir          on_adb(xyaz_smalle,aa_vec)                               
     .                 do i = 1, imax                                           
     .                    xyr_raduwflux(i-1,j-1+js,k) = aa_vec(imax*(js+j)-imax-
     .       1               imax+i,2*k-1)*xyaz_smalle(i-1,j-1+js,3,k) + aa_vec(
     .       2               imax*(js+j)-imax-imax+i,2*k)*xyaz_smalle(i-1,j-1+js
     .       3               ,4,k) + xyz_cupt(i-1,j-1+js,k)                     
     .                    xyr_raduwflux(i-1,j+js,k) = aa_vec(imax*(js+j)-imax+i,
     .       1               2*k-1)*xyaz_smalle(i-1,j+js,3,k) + aa_vec(imax*(js+
     .       2               j)-imax+i,2*k)*xyaz_smalle(i-1,j+js,4,k) + xyz_cupt
     .       3               (i-1,j+js,k)                                       
     .                    xyr_raduwflux(i-1,j+1+js,k) = aa_vec(imax*(js+j)+i,2*k
     .       1               -1)*xyaz_smalle(i-1,j+1+js,3,k) + aa_vec(imax*(js+j
     .       2               )+i,2*k)*xyaz_smalle(i-1,j+1+js,4,k) + xyz_cupt(i-1
     .       3               ,j+1+js,k)                                         
     .                    xyr_raduwflux(i-1,j+2+js,k) = aa_vec(imax*(j+2+js)-   
     .       1               imax+i,2*k-1)*xyaz_smalle(i-1,j+2+js,3,k) + aa_vec(
     .       2               imax*(j+2+js)-imax+i,2*k)*xyaz_smalle(i-1,j+2+js,4,
     .       3               k) + xyz_cupt(i-1,j+2+js,k)                        
     .                    xyr_raddwflux(i-1,j-1+js,k) = aa_vec(imax*(js+j)-imax-
     .       1               imax+i,2*k-1)*xyaz_smalle(i-1,j-1+js,1,k) + aa_vec(
     .       2               imax*(js+j)-imax-imax+i,2*k)*xyaz_smalle(i-1,j-1+js
     .       3               ,2,k) + xyz_cdot(i-1,j-1+js,k)                     
     .                    xyr_raddwflux(i-1,j+js,k) = aa_vec(imax*(js+j)-imax+i,
     .       1               2*k-1)*xyaz_smalle(i-1,j+js,1,k) + aa_vec(imax*(js+
     .       2               j)-imax+i,2*k)*xyaz_smalle(i-1,j+js,2,k) + xyz_cdot
     .       3               (i-1,j+js,k)                                       
     .                    xyr_raddwflux(i-1,j+1+js,k) = aa_vec(imax*(js+j)+i,2*k
     .       1               -1)*xyaz_smalle(i-1,j+1+js,1,k) + aa_vec(imax*(js+j
     .       2               )+i,2*k)*xyaz_smalle(i-1,j+1+js,2,k) + xyz_cdot(i-1
     .       3               ,j+1+js,k)                                         
     .                    xyr_raddwflux(i-1,j+2+js,k) = aa_vec(imax*(j+2+js)-   
     .       1               imax+i,2*k-1)*xyaz_smalle(i-1,j+2+js,1,k) + aa_vec(
     .       2               imax*(j+2+js)-imax+i,2*k)*xyaz_smalle(i-1,j+2+js,2,
     .       3               k) + xyz_cdot(i-1,j+2+js,k)                        
     .                 enddo                                                    
     .              enddo                                                       
     .           endif                                                          
     .        enddo                                                             
     .        goto 10185                                                        
     .  10133 continue                                                          
     .        do k = 0, kmax                                                    
     .  !cdir    nodep                                                          
     .  !cdir    noassume                                                       
     .           do j = 1, imax - (js - je)*imax                                
     .              xyr_raduwflux(j-1,js,k) = 0.0000000000000000e+000           
     .              xyr_raddwflux(j-1,js,k) = 0.0000000000000000e+000           
     .              xyra_delraduwflux(j-1,js,k,0) = 0.0000000000000000e+000     
     .              xyra_delraduwflux(j-1,js,k,1) = 0.0000000000000000e+000     
     .              xyra_delraddwflux(j-1,js,k,0) = 0.0000000000000000e+000     
     .              xyra_delraddwflux(j-1,js,k,1) = 0.0000000000000000e+000     
     .           enddo                                                          
     .        enddo                                                             
     .        do l = 1, 8                                                       
     .           mu = a_gqp(l)                                                  
     .           k = kmax                                                       
     .  !cdir    nodep                                                          
     .  !cdir    noassume                                                       
     .           do j = 1, (je + 1 - js)*(xyr_idw.DSC.U1 + 1)                   
     .              xyr_idw(j-1,js,k) = 0.0000000000000000e+000                 
     .           enddo                                                          
     .           do k = kmax, 1, -1                                             
     .              do j = js, je                                               
     .                 d11 = 1.D0/mu                                            
     .                 d12 = 1.D0/mu                                            
     .                 d13 = 1.D0/mu                                            
     .                 d14 = 1.D0/mu                                            
     .  !cdir          nodep                                                    
     .  !cdir          on_adb(aa_vec,xyz_lgamma,xyz_lambda,xyz_mu1,xyz_b0,xyz_b1
     .       1            ,xyz_gam1,xyz_gam2,xyr_idw,xyz_deltau)                
     .                 do i = 1, imax                                           
     .                    factj = (aa_vec(imax*j-imax+i,2*k-1)+aa_vec(imax*j-   
     .       1               imax+i,2*k))*xyz_lgamma(i-1,j,k)*(xyz_lambda(i-1,j,
     .       2               k)+(1.00000000000000e+000/xyz_mu1(i-1,j,k)))       
     .                    factk = (aa_vec(imax*j-imax+i,2*k-1)-aa_vec(imax*j-   
     .       1               imax+i,2*k))*((1.00000000000000e+000/xyz_mu1(i-1,j,
     .       2               k))-xyz_lambda(i-1,j,k))                           
     .                    sig1 = 2.00000000000000e+000*(xyz_b0(i-1,j,k)-xyz_b1(i
     .       1               -1,j,k)*(1.00000000000000e+000/(xyz_gam1(i-1,j,k)+ 
     .       2               xyz_gam2(i-1,j,k))-xyz_mu1(i-1,j,k)))              
     .                    xyr_idw(i-1,j,k-1) = xyr_idw(i-1,j,k)*(dexp((-(       
     .       1               xyz_deltau(i-1,j,k)*d11)))) + factj/((xyz_lambda(i-
     .       2               1,j,k)*mu)+1.00000000000000e+000)*(                
     .       3               1.00000000000000e+000 - dexp((-xyz_deltau(i-1,j,k)*
     .       4               (xyz_lambda(i-1,j,k)+1.00000000000000e+000/mu))))  
     .       5                + factk/((xyz_lambda(i-1,j,k)*mu)-                
     .       6               1.00000000000000e+000)*((dexp((-(xyz_deltau(i-1,j,k
     .       7               )*d12))))-dexp((-xyz_deltau(i-1,j,k)*xyz_lambda(i-1
     .       8               ,j,k)))) + sig1*(1.00000000000000e+000 - (dexp((-( 
     .       9               xyz_deltau(i-1,j,k)*d13))))) +                     
     .       .               2.00000000000000e+000*xyz_b1(i-1,j,k)*(mu*(dexp((-(
     .       1               xyz_deltau(i-1,j,k)*d14))))+xyz_deltau(i-1,j,k)-mu)
     .                 enddo                                                    
     .              enddo                                                       
     .           enddo                                                          
     .           k = 0                                                          
     .  !cdir    nodep                                                          
     .  !cdir    noassume                                                       
     .  !cdir    on_adb(xy_surfpfinted,xyr_idw,xy_surfalbedo,xyr_iuw)           
     .           do j = 1, imax - (js - je)*imax                                
     .              xyr_iuw(j-1,js,0) = xy_surfalbedo(j-1,js)*xyr_idw(j-1,js,0) 
     .       1          + 2.00000000000000e+000*xy_surfpfinted(j-1,js)          
     .           enddo                                                          
     .           do k = 1, kmax                                                 
     .              do j = js, je                                               
     .                 d15 = 1.D0/mu                                            
     .                 d16 = 1.D0/mu                                            
     .                 d17 = 1.D0/mu                                            
     .                 d18 = 1.D0/mu                                            
     .  !cdir          nodep                                                    
     .  !cdir          on_adb(aa_vec,xyz_lgamma,xyz_lambda,xyz_mu1,xyz_b0,xyz_b1
     .       1            ,xyz_gam1,xyz_gam2,xyz_deltau,xyr_iuw)                
     .                 do i = 1, imax                                           
     .                    factg = (aa_vec(imax*j-imax+i,2*k-1)+aa_vec(imax*j-   
     .       1               imax+i,2*k))*((1.00000000000000e+000/xyz_mu1(i-1,j,
     .       2               k))-xyz_lambda(i-1,j,k))                           
     .                    facth = (aa_vec(imax*j-imax+i,2*k-1)-aa_vec(imax*j-   
     .       1               imax+i,2*k))*xyz_lgamma(i-1,j,k)*(xyz_lambda(i-1,j,
     .       2               k)+(1.00000000000000e+000/xyz_mu1(i-1,j,k)))       
     .                    alp1 = 2.00000000000000e+000*(xyz_b0(i-1,j,k)+xyz_b1(i
     .       1               -1,j,k)*(1.00000000000000e+000/(xyz_gam1(i-1,j,k)+ 
     .       2               xyz_gam2(i-1,j,k))-xyz_mu1(i-1,j,k)))              
     .                    xyr_iuw(i-1,j,k) = xyr_iuw(i-1,j,k-1)*(dexp((-(       
     .       1               xyz_deltau(i-1,j,k)*d15)))) + factg/((xyz_lambda(i-
     .       2               1,j,k)*mu)-1.00000000000000e+000)*((dexp((-(       
     .       3               xyz_deltau(i-1,j,k)*d16))))-dexp((-xyz_deltau(i-1,j
     .       4               ,k)*xyz_lambda(i-1,j,k)))) + facth/((xyz_lambda(i-1
     .       5               ,j,k)*mu)+1.00000000000000e+000)*(                 
     .       6               1.00000000000000e+000 - dexp((-xyz_deltau(i-1,j,k)*
     .       7               (xyz_lambda(i-1,j,k)+1.00000000000000e+000/mu))))  
     .       8                + alp1*(1.00000000000000e+000 - (dexp((-(         
     .       9               xyz_deltau(i-1,j,k)*d17))))) +                     
     .       .               2.00000000000000e+000*xyz_b1(i-1,j,k)*(mu - (      
     .       1               xyz_deltau(i-1,j,k)+mu)*(dexp((-(xyz_deltau(i-1,j,k
     .       2               )*d18)))))                                         
     .                 enddo                                                    
     .              enddo                                                       
     .           enddo                                                          
     .           do k = 0, kmax                                                 
     .  !cdir       nodep                                                       
     .  !cdir       noassume                                                    
     .  !cdir       on_adb(xyr_idw,xyr_iuw,xyr_raduwflux,xyr_raddwflux)         
     .              do j = 1, imax - (js - je)*imax                             
     .                 xyr_raduwflux(j-1,js,k) = xyr_raduwflux(j-1,js,k) + (mu* 
     .       1            a_gqw(l))*xyr_iuw(j-1,js,k)                           
     .                 xyr_raddwflux(j-1,js,k) = xyr_raddwflux(j-1,js,k) + (mu* 
     .       1            a_gqw(l))*xyr_idw(j-1,js,k)                           
     .              enddo                                                       
     .           enddo                                                          
     .           do k = 0, kmax                                                 
     .              d19 = 1.D0/mu                                               
     .  !cdir       nodep                                                       
     .  !cdir       noassume                                                    
     .  !cdir       on_adb(xyr_opdepadj,xyra_delraduwflux,xy_surfdpfdtinted)    
     .              do j = 1, (je + 1 - js)*(xyr_opdepadj.DSC.U1 + 1)           
     .                 xyra_delraduwflux(j-1,js,k,0) = xyra_delraduwflux(j-1,js,
     .       1            k,0) + mu*2.00000000000000e+000*xy_surfdpfdtinted(j-1,
     .       2            js)*dexp((-(xyr_opdepadj(j-1,js,0)-xyr_opdepadj(j-1,js
     .       3            ,k))*d19))*a_gqw(l)                                   
     .              enddo                                                       
     .           enddo                                                          
     .        enddo                                                             
     .  10185 continue                                                          
     .        if (flagtoaflux .eq. 0) goto 10186                                
     .        do k = 0, kmax                                                    
     .  !cdir    nodep                                                          
     .  !cdir    noassume                                                       
     .  !cdir    on_adb(xy_cossza,xy_solarfluxtoa,xyr_transdiradj,xyr_raddwflux)
     .           do j = 1, imax - (js - je)*imax                                
     .              xyr_raddwflux(j-1,js,k) = xyr_raddwflux(j-1,js,k) +         
     .       1         xy_solarfluxtoa(j-1,js)*xyr_transdiradj(j-1,js,k)*       
     .       2         xy_cossza(j-1,js)                                        
     .           enddo                                                          
     .        enddo                                                             
     .  10186 continue                                                          
  1516  
  1517    !--------------------------------------------------------------------------------------
  1518  
  1519    !******************************************************************************
  1520    !      subroutine tridiag
  1521    !      tidiagonal solver
  1522    !******************************************************************************
  1523    !     a(j), b(j), and c(j) are, respectively, the subdiagonal, diagonal,
  1524    !     and superdiagonal entries in row j.
  1525    !     a(1) and c(jmx) need not be initialized.
  1526    !     The output is in f; a, b, and c are unchanged.
  1527    !******************************************************************************
  1528    !     jmx    : dimensions of all the following arrays
  1529    !     a      : sub (lower) diagonal
  1530    !     b      : center diagonal
  1531    !     c      : super (upper) diagonal
  1532    !     f      : right hand side
  1533    !******************************************************************************
  1534  
  1535    subroutine tridiag( mm, jmx, a, b, c, f, ms, me )
  1536  
  1537      integer , intent(in   ) :: mm, jmx
  1538      real(DP), intent(in   ) :: a( mm, jmx ),b( mm, jmx )
  1539      real(DP), intent(in   ) :: c( mm, jmx )
  1540      real(DP), intent(inout) :: f( mm, jmx )
  1541      integer , intent(in   ) :: ms, me
  1542  
  1543  
  1544      ! Local variables
  1545      !
  1546      real(DP) :: q( mm, jmx ), p
  1547      integer  :: j, m
  1548  
  1549  
  1550      ! Forward elimination sweep
  1551      !
  1552      do m = ms, me
  1553        q( m, 1 ) = - c( m, 1 ) / b( m, 1 )
  1554        f( m, 1 ) =   f( m, 1 ) / b( m, 1 )
  1555      end do
  1556  
  1557      do j = 2, jmx
  1558        do m = ms, me
  1559          p         = 1.0d0 / ( b( m, j ) + a( m, j ) * q( m, j-1 ) )
  1560          q( m, j ) = - c( m, j ) * p
  1561          f( m, j ) = ( f( m, j ) - a( m, j ) * f( m, j-1 ) ) * p
  1562        end do
     .  !cdir    nodep                                                          
     .        do m = 1, me + 1 - ms                                             
     .           p = 1.00000000000000e+000/(b(ms+m-1,j)+a(ms+m-1,j)*q(ms+m-1,j-1
     .       1      ))                                                          
     .           q(ms+m-1,j) = -c(ms+m-1,j)*p                                   
     .           f(ms+m-1,j) = (f(ms+m-1,j)-a(ms+m-1,j)*f(ms+m-1,j-1))*p        
     .        enddo                                                             
  1563      end do
  1564  
  1565      ! Backward pass
  1566      !
  1567      do j = jmx - 1, 1, -1
  1568        do m = ms, me
  1569          f( m, j ) = f( m, j ) + q( m, j ) * f( m, j+1 )
  1570        end do
  1571      end do
  1572  
  1573    end subroutine tridiag
  1574  
  1575    !--------------------------------------------------------------------------------------
  1576  
  1577    subroutine tridiag1( jmx, a, b, c, f )
  1578  
  1579      integer , intent(in   ) :: jmx
  1580      real(DP), intent(in   ) :: a(jmx),b(jmx)
  1581      real(DP), intent(in   ) :: c(jmx)
  1582      real(DP), intent(inout) :: f(jmx)
  1583  
  1584  
  1585      ! Local variables
  1586      !
  1587      real(DP) :: q(jmx), p
  1588      integer  :: j
  1589  
  1590  
  1591      ! Forward elimination sweep
  1592      !
  1593      q( 1 ) = - c( 1 ) / b( 1 )
  1594      f( 1 ) =   f( 1 ) / b( 1 )
  1595  
  1596      do j = 2, jmx
  1597        p      = 1.0d0 / ( b( j ) + a( j ) * q( j-1 ) )
  1598        q( j ) = - c( j ) * p
  1599        f( j ) = ( f( j ) - a( j ) * f( j-1 ) ) * p
  1600      end do
  1601  
  1602      ! Backward pass
  1603      !
  1604      do j = jmx - 1, 1, -1
  1605        f( j ) = f( j ) + q( j ) * f( j+1 )
  1606      end do
  1607  
  1608    end subroutine tridiag1
  1609  
  1610    !----------------------------------------------------------------------------
  1611  
  1612    subroutine RadRTETwoStreamAppInit
  1613  
  1614  !!$    ! ファイル入出力補助
  1615  !!$    ! File I/O support
  1616  !!$    !
  1617  !!$    use dc_iounit, only: FileOpen
  1618  !!$
  1619  !!$    ! NAMELIST ファイル入力に関するユーティリティ
  1620  !!$    ! Utilities for NAMELIST file input
  1621  !!$    !
  1622  !!$    use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid
  1623  
  1624      ! ガウス重み, 分点の計算
  1625      ! Calculate Gauss node and Gaussian weight
  1626      !
  1627      use gauss_quad, only : GauLeg
  1628  
  1629  
  1630      ! 宣言文 ; Declaration statements
  1631      !
  1632  
  1633  !!$    integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号.
  1634  !!$                              ! Unit number for NAMELIST file open
  1635  !!$    integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT.
  1636  !!$                              ! IOSTAT of NAMELIST read
  1637  
  1638      ! NAMELIST 変数群
  1639      ! NAMELIST group name
  1640      !
  1641  !!$    namelist /rad_rte_two_stream_app_nml/ &
  1642  !!$      & NGaussQuad
  1643            !
  1644            ! デフォルト値については初期化手続 "rad_rte_two_stream_app#RadRTETwoStreamAppInit"
  1645            ! のソースコードを参照のこと.
  1646            !
  1647            ! Refer to source codes in the initialization procedure
  1648            ! "rad_rte_two_stream_app#RadRTETwoStreamAppInit" for the default values.
  1649            !
  1650  
  1651      if ( rad_rte_two_stream_app_inited ) return
  1652  
  1653  
  1654      ! デフォルト値の設定
  1655      ! Default values settings
  1656      !
  1657  !!$    NGaussQuad = 8
  1658  
  1659  
  1660      ! NAMELIST の読み込み
  1661      ! NAMELIST is input
  1662      !
  1663  !!$    if ( trim(namelist_filename) /= '' ) then
  1664  !!$      call FileOpen( unit_nml, &          ! (out)
  1665  !!$        & namelist_filename, mode = 'r' ) ! (in)
  1666  !!$
  1667  !!$      rewind( unit_nml )
  1668  !!$      read( unit_nml,                          & ! (in)
  1669  !!$        & nml = rad_rte_two_stream_app_nml,    & ! (out)
  1670  !!$        & iostat = iostat_nml )                  ! (out)
  1671  !!$      close( unit_nml )
  1672  !!$
  1673  !!$      call NmlutilMsg( iostat_nml, module_name ) ! (in)
  1674  !!$    end if
  1675  
  1676  
  1677  !!$    allocate( a_GQP(1:NGaussQuad) )
  1678  !!$    allocate( a_GQW(1:NGaussQuad) )
  1679  
  1680      call GauLeg( &
  1681        & 0.0_DP, 1.0_DP, NGaussQuad, & ! (in )
  1682        & a_GQP, a_GQW                & ! (out)
  1683        & )
  1684  
  1685  
  1686      ! Initialization of modules used in this module
  1687      !
  1688  
  1689  
  1690      ! 印字 ; Print
  1691      !
  1692      call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
  1693  !!$    call MessageNotify( 'M', module_name, 'NGaussQuad = %d', i = (/ NGaussQuad /) )
  1694      call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
  1695  
  1696  
  1697      rad_rte_two_stream_app_inited = .true.
  1698  
  1699  
  1700    end subroutine RadRTETwoStreamAppInit
  1701  
  1702    !----------------------------------------------------------------------------
  1703  
  1704  !******************************************************************************
  1705  !!$
  1706  !!$    subroutine twostreamapp_vis( cossza, gph, q, gdf, &
  1707  !!$         dod067, qerat, ssa, af, sf, albedo, &
  1708  !!$         gor, goru, gord, gsr, gsru, gsrd, &
  1709  !!$         ijs, ije )
  1710  !!$
  1711  !!$      use matype
  1712  !!$      use maparam, only : im => imax, jm => jmax, km => kmax
  1713  !!$
  1714  !!$      real(dp)    , intent(in ) :: cossza( ijs:ije, 1 )
  1715  !!$      real(dp)    , intent(in ) :: gph   ( im, jm, km+1 )
  1716  !!$      real(dp)    , intent(out) :: q     ( im, jm, km   )
  1717  !!$      real(dp)    , intent(out) :: gdf   ( im, jm )
  1718  !!$      real(dp)    , intent(in ) :: dod067( im, jm, km+1 )
  1719  !!$      real(dp)    , intent(in ) :: qerat, ssa, af
  1720  !!$      real(dp)    , intent(in ) :: sf
  1721  !!$      real(dp)    , intent(in ) :: albedo( im, jm )
  1722  !!$
  1723  !!$      real(dp)    , intent(out) :: &
  1724  !!$           gor ( im, jm ), goru ( im, jm ), gord ( im, jm ), &
  1725  !!$           gsr ( im, jm ), gsru ( im, jm ), gsrd ( im, jm )
  1726  !!$
  1727  !!$      integer(i4b), intent(in ) :: ijs, ije
  1728  !!$
  1729  !!$
  1730  !!$      !
  1731  !!$      ! local variables
  1732  !!$      !
  1733  !!$      real(dp)     :: gt  ( im, jm, km )
  1734  !!$      real(dp)     :: gts ( im, jm )
  1735  !!$      real(dp)     :: emis( im, jm )
  1736  !!$      real(dp)     :: wn1 = 1.0d100, wn2 = 1.0d100
  1737  !!$      integer(i4b) :: divnum = 3
  1738  !!$      integer(i4b) :: sw = 1
  1739  !!$
  1740  !!$      integer(i4b) :: ij, k
  1741  !!$
  1742  !!$
  1743  !!$      do k = 1, km
  1744  !!$         do ij = ijs, ije
  1745  !!$            gt  ( ij, 1, k ) = 1.0d100
  1746  !!$         end do
  1747  !!$      end do
  1748  !!$      do ij = ijs, ije
  1749  !!$         gts ( ij, 1 ) = 1.0d100
  1750  !!$         emis( ij, 1 ) = 1.0d100
  1751  !!$      end do
  1752  !!$
  1753  !!$      call twostreamapp( cossza, gt, gts, gph, q, gdf, &
  1754  !!$           dod067, qerat, ssa, af, sf, albedo, emis, wn1, wn2, divnum, sw, &
  1755  !!$           gor, goru, gord, gsr, gsru, gsrd, &
  1756  !!$           ijs, ije )
  1757  !!$
  1758  !!$
  1759  !!$    end subroutine twostreamapp_vis
  1760  !!$
  1761  !!$!******************************************************************************
  1762  !!$
  1763  !!$    subroutine twostreamapp_ir( gt, gts, gph, q, gdf, &
  1764  !!$         dod067, qerat, ssa, af, emis, wn1, wn2, divnum, &
  1765  !!$         gor, goru, gord, gsr, gsru, gsrd, &
  1766  !!$         ijs, ije )
  1767  !!$
  1768  !!$      use matype
  1769  !!$      use maparam, only : im => imax, jm => jmax, km => kmax
  1770  !!$
  1771  !!$      implicit none
  1772  !!$
  1773  !!$      real(dp)    , intent(in ) :: gt    ( im, jm, km   )
  1774  !!$      real(dp)    , intent(in ) :: gts   ( im, jm )
  1775  !!$      real(dp)    , intent(in ) :: gph   ( im, jm, km+1 )
  1776  !!$      real(dp)    , intent(out) :: q     ( im, jm,   km )
  1777  !!$      real(dp)    , intent(out) :: gdf   ( im, jm )
  1778  !!$      real(dp)    , intent(in ) :: dod067( im, jm, km+1 )
  1779  !!$      real(dp)    , intent(in ) :: qerat, ssa, af
  1780  !!$      real(dp)    , intent(in ) :: emis  ( im, jm )
  1781  !!$      real(dp)    , intent(in ) :: wn1, wn2
  1782  !!$      integer(i4b), intent(in ) :: divnum
  1783  !!$
  1784  !!$      real(dp)    , intent(out) :: &
  1785  !!$           gor ( im, jm ), goru ( im, jm ), gord ( im, jm ), &
  1786  !!$           gsr ( im, jm ), gsru ( im, jm ), gsrd ( im, jm )
  1787  !!$
  1788  !!$      integer(i4b), intent(in ) :: ijs, ije
  1789  !!$
  1790  !!$
  1791  !!$      !
  1792  !!$      ! local variables
  1793  !!$      !
  1794  !!$      real(dp)     :: cossza( ijs:ije, 1 )
  1795  !!$      real(dp)     :: sf    = 1.0d100
  1796  !!$      real(dp)     :: albedo( im, jm )
  1797  !!$      integer(i4b) :: sw = 2
  1798  !!$
  1799  !!$      integer(i4b) :: ij
  1800  !!$
  1801  !!$
  1802  !!$      do ij = ijs, ije
  1803  !!$         albedo( ij, 1 ) = 1.0d0 - emis( ij, 1 )
  1804  !!$         cossza( ij, 1 ) = 1.0d100
  1805  !!$      end do
  1806  !!$
  1807  !!$      call twostreamapp( cossza, gt, gts, gph, q, gdf, &
  1808  !!$           dod067, qerat, ssa, af, sf, albedo, emis, wn1, wn2, divnum, sw, &
  1809  !!$           gor, goru, gord, gsr, gsru, gsrd, &
  1810  !!$           ijs, ije )
  1811  !!$
  1812  !!$
  1813  !!$    end subroutine twostreamapp_ir
  1814  
  1815  end module rad_rte_two_stream_app
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:49 2016
FILE NAME: rad_rte_two_stream_app.f90
PROGRAM NAME: rad_rte_two_stream_app
FORMAT LIST

  LINE    LOOP      FORTRAN STATEMENT

     1:             != 
     2:             !
     3:             != Solve radiative transfer equation in two stream approximation
     4:             !
     5:             ! Authors::   Yoshiyuki O. Takahashi
     6:             ! Version::   $Id: rad_rte_two_stream_app.f90,v 1.7 2015/03/11 04:48:47 yot Exp $
     7:             ! Tag Name::  $Name:  $
     8:             ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9:             ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10:             !
    11:             module rad_rte_two_stream_app
    12:               !
    13:               != 
    14:               !
    15:               != Solve radiative transfer equation in two stream approximation
    16:               !
    17:               ! <b>Note that Japanese and English are described in parallel.</b>
    18:               !
    19:               ! 
    20:               !
    21:               ! Solve radiative transfer equation in two stream approximation. 
    22:               ! Analytic solution is used to calculate radiative flux in a homogeneous atmosphere 
    23:               ! in which the single scattering albedo and the asymmetry factor are constant. 
    24:               ! Radiative transfer equation is solved numerically with the method by Toon et al. 
    25:               ! (1989) to calculate radiative flux in an inhomogeneous atmosphere. 
    26:               !
    27:               !
    28:               !== References
    29:               !
    30:               !  Toon, O. B., C. P. McKay, and A. P. Ackerman, 
    31:               !    Rapid calculation of radiative heating rates and photodissociation rates 
    32:               !    in inhomogeneous multiple scattering atmospheres, 
    33:               !    J. Geophys. Res., 94, 16287-16301, 1989.
    34:               !
    35:               !== Procedures List
    36:               !
    37:             !!$  ! RadiationFluxDennouAGCM :: 放射フラックスの計算
    38:             !!$  ! RadiationDTempDt        :: 放射フラックスによる温度変化の計算
    39:             !!$  ! RadiationFluxOutput     :: 放射フラックスの出力
    40:             !!$  ! RadiationFinalize       :: 終了処理 (モジュール内部の変数の割り付け解除)
    41:             !!$  ! ------------            :: ------------
    42:             !!$  ! RadiationFluxDennouAGCM :: Calculate radiation flux
    43:             !!$  ! RadiationDTempDt        :: Calculate temperature tendency with radiation flux
    44:             !!$  ! RadiationFluxOutput     :: Output radiation fluxes
    45:             !!$  ! RadiationFinalize       :: Termination (deallocate variables in this module)
    46:               !
    47:               !== NAMELIST
    48:               !
    49:             !!$  ! NAMELIST#radiation_DennouAGCM_nml
    50:               !
    51:             
    52:               !
    53:               ! Kind type parameter
    54:               !
    55:               use dc_types, only: DP, &      ! Double precision.
    56:                 &                 STRING, &  ! Strings.
    57:                 &                 TOKEN      ! Keywords.
    58:             
    59:               ! メッセージ出力
    60:               ! Message output
    61:               !
    62:               use dc_message, only: MessageNotify
    63:             
    64:               ! 物理・数学定数設定
    65:               ! Physical and mathematical constants settings
    66:               !
    67:               use constants0, only: &
    68:                 & PI
    69:                                         ! $ \pi $ .
    70:                                         ! 円周率.  Circular constant
    71:             
    72:               ! 格子点設定
    73:               ! Grid points settings
    74:               !
    75:               use gridset, only: imax, & ! 経度格子点数.
    76:                                          ! Number of grid points in longitude
    77:                 &                jmax, & ! 緯度格子点数.
    78:                                          ! Number of grid points in latitude
    79:                 &                kmax    ! 鉛直層数.
    80:                                          ! Number of vertical level
    81:             
    82:               implicit none
    83:             
    84:               private
    85:             
    86:             
    87:               ! Local variables
    88:               !
    89:               real(DP), parameter :: DelTauThreshold = 1.0e-10_DP
    90:             
    91:             !!$  integer, save :: NGaussQuad
    92:               integer, parameter :: NGaussQuad = 8
    93:               real(DP), save     :: a_GQP(1:NGaussQuad)
    94:               real(DP), save     :: a_GQW(1:NGaussQuad)
    95:             
    96:               ! 公開変数
    97:               ! Public variables
    98:               !
    99:               logical, save :: rad_rte_two_stream_app_inited = .false.
   100:                                           ! 初期設定フラグ.
   101:                                           ! Initialization flag
   102:             
   103:               integer, parameter :: IDScatApproxEddington = 11
   104:               integer, parameter :: IDScatApproxHemiMean  = 12
   105:             
   106:               public :: RadRTETwoStreamAppHomogAtm
   107:             !!$  public :: RadRTETwoStreamApp
   108:               public :: RadRTETwoStreamAppSW
   109:               public :: RadRTETwoStreamAppLW
   110:               public :: RadRTETwoStreamAppInit
   111:             
   112:             
   113:               ! INTERFACE 文 ; INTERFACE statements
   114:               !
   115:             !!$  interface RadRTETwoStreamApp
   116:             !!$    module procedure RadRTETwoStreamAppWrapper, RadRTETwoStreamAppCore
   117:             !!$  end interface
   118:             !!$  interface RadRTETwoStreamApp
   119:             !!$    module procedure RadRTETwoStreamAppWrapper
   120:             !!$  end interface
   121:             
   122:             
   123:             
   124:               character(*), parameter:: module_name = 'rad_rte_two_stream_app'
   125:                                           ! モジュールの名称.
   126:                                           ! Module name
   127:               character(*), parameter:: version = &
   128:                 & '$Name:  $' // &
   129:                 & '$Id: rad_rte_two_stream_app.f90,v 1.7 2015/03/11 04:48:47 yot Exp $'
   130:                                           ! モジュールのバージョン
   131:                                           ! Module version
   132:             
   133:               !--------------------------------------------------------------------------------------
   134:             
   135:             contains
   136:             
   137:               !--------------------------------------------------------------------------------------
   138:             
   139:               subroutine RadRTETwoStreamAppHomogAtm(                               &
   140:                 & xy_SurfAlbedo, SolarFluxAtTOA, xy_InAngle, SSA, AF, xyr_OptDep,  & ! (in )
   141:                 & xyr_RadSUwFlux, xyr_RadSDwFlux,                                  & ! (out)
   142:                 & FlagSemiInfAtm, FlagSL09                                         & ! (in ) optional
   143:                 & )
   144:             
   145:                 ! Calculate radiative flux in a homogeneous scattering and absorbing atmosphere. 
   146:                 ! Analytical solution is used for calculation of radiative flux. 
   147:                 ! Radiative flux in a semi-infinite atmosphere is calculated if FlagSemiInfAtm 
   148:                 ! is .true.. If FlagSemiInfAtm is not given or is .false., radiative flux in a finite
   149:                 ! atmosphere (bounded by the surface) is calculated.
   150:                 !
   151:                 ! If FlagSL09 is .true., short wave radiative flux is calculated with the method by 
   152:                 ! Schneider and Liu (2009). 
   153:                 !
   154:                 ! See Meador and Weaver (19??), Toon et al. (1989), Liou (200?), and so on for 
   155:                 ! details of radiative transfer equation in this system.
   156:             
   157:             
   158:                 real(DP), intent(in ) :: xy_SurfAlbedo(0:imax-1, 1:jmax)
   159:                 real(DP), intent(in ) :: SolarFluxAtTOA
   160:                 real(DP), intent(in ) :: xy_InAngle   (0:imax-1, 1:jmax)
   161:                 real(DP), intent(in ) :: SSA
   162:                 real(DP), intent(in ) :: AF
   163:                 real(DP), intent(in ) :: xyr_OptDep    (0:imax-1, 1:jmax, 0:kmax)
   164:                 real(DP), intent(out) :: xyr_RadSUwFlux(0:imax-1, 1:jmax, 0:kmax)
   165:                 real(DP), intent(out) :: xyr_RadSDwFlux(0:imax-1, 1:jmax, 0:kmax)
   166:                 logical , intent(in ), optional :: FlagSemiInfAtm
   167:                 logical , intent(in ), optional :: FlagSL09
   168:             
   169:                 !
   170:                 ! cosz     : cosine of solar zenith angle
   171:                 ! cosz2    : cosz squared
   172:                 !
   173:                 real(DP) :: xy_cosSZA     ( 0:imax-1, 1:jmax )
   174:                 real(DP) :: xy_cosSZAInv  ( 0:imax-1, 1:jmax )
   175:                 real(DP) :: xy_cosSZAInvsq( 0:imax-1, 1:jmax )
   176:             
   177:                 real(DP) :: SSAAdj
   178:                 real(DP) :: AFAdj
   179:                 real(DP) :: xyr_OptDepAdj(0:imax-1, 1:jmax, 0:kmax )
   180:             
   181:                 real(DP) :: Lambda
   182:                 real(DP) :: LSigma
   183:                 real(DP) :: Gam1
   184:                 real(DP) :: Gam2
   185:                 real(DP) :: xy_Gam3   (0:imax-1, 1:jmax)
   186:                 real(DP) :: xy_Gam4   (0:imax-1, 1:jmax)
   187:                 real(DP) :: xyr_Trans (0:imax-1, 1:jmax, 0:kmax)
   188:                 real(DP) :: xyr_TMPVal(0:imax-1, 1:jmax, 0:kmax)
   189:                 real(DP) :: xyr_CUp   (0:imax-1, 1:jmax, 0:kmax)
   190:                 real(DP) :: xyr_CDo   (0:imax-1, 1:jmax, 0:kmax)
   191:             
   192:                 real(DP) :: xy_k1           (0:imax-1, 1:jmax)
   193:                 real(DP) :: xy_k2           (0:imax-1, 1:jmax)
   194:                 real(DP) :: xyr_ExpLamOptDep(0:imax-1, 1:jmax, 0:kmax)
   195:             
   196:                 real(DP) :: xy_DWRadSFluxAtTOA(0:imax-1, 1:jmax)
   197:             
   198:                 logical  :: FlagSemiInfAtmLV
   199:                 logical  :: FlagSL09LV
   200:             
   201:                 integer  :: i
   202:                 integer  :: j
   203:                 integer  :: k
   204:             
   205:             
   206:                 ! 初期化確認
   207:                 ! Initialization check
   208:                 !
   209:                 if ( .not. rad_rte_two_stream_app_inited ) then
   210:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   211:                 end if
   212:             
   213:                 ! Check flags
   214:                 !
   215:                 FlagSL09LV = .false.
   216:                 if ( present( FlagSL09 ) ) then
   217:                   if ( FlagSL09 ) then
   218:                     FlagSL09LV = .true.
   219:                   end if
   220:                 end if
   221:                 FlagSemiInfAtmLV = .false.
   222:                 if ( present( FlagSemiInfAtm ) ) then
   223:                   if ( FlagSemiInfAtm ) then
   224:                     FlagSemiInfAtmLV = .true.
   225:                   end if
   226:                 end if
   227:                 if ( FlagSL09LV .and. ( .not. FlagSemiInfAtmLV ) ) then
   228:                   call MessageNotify( 'E', module_name, 'FlagSemiInfAtm has to be .true. when FlagSL09 is .true.' )
   229:                 end if
   230:             
   231:             
   232:                 if ( FlagSL09LV ) then
   233:                   SSAAdj        = SSA
   234:                   AFAdj         = AF
   235: ++V==== A         xyr_OptDepAdj = xyr_OptDep
   236:                 else
   237:                   ! Delta-function adjustment
   238:                   !
   239:                   SSAAdj        =   ( 1.0_DP - AF**2 ) * SSA  / ( 1.0_DP - SSA * AF**2 )
   240:                   AFAdj         = AF / ( 1.0_DP + AF )
   241: W**==== A         xyr_OptDepAdj = ( 1.0_DP - SSA * AF**2 ) * xyr_OptDep
   242:                 end if
   243:             
   244:             
   245: W------>        do j = 1, jmax
   246: |*----->          do i = 0, imax-1
   247: ||      A           if ( xy_InAngle(i,j) > 0.0_DP ) then
   248: ||      A             xy_cosSZA     (i,j) = 1.0_DP / xy_InAngle(i,j)
   249: ||                    xy_cosSZAInv  (i,j) = xy_InAngle(i,j)
   250: ||                    xy_cosSZAInvsq(i,j) = xy_cosSZAInv(i,j)**2
   251: ||                  else
   252: ||                    xy_cosSZA     (i,j) = 0.0_DP
   253: ||                    xy_cosSZAInv  (i,j) = 0.0_DP
   254: ||                    xy_cosSZAInvsq(i,j) = 0.0_DP
   255: ||                  end if
   256: |*-----           end do
   257: W------         end do
   258:             
   259:             
   260:                 if ( FlagSL09LV ) then
   261:                   ! Coefficients for Hemispheric mean approximation
   262:                   !
   263:                   Gam1    = 2.0_DP - SSAAdj * ( 1.0_DP + AFAdj )
   264:                   Gam2    = SSAAdj * ( 1.0_DP - AFAdj )
   265: *V----->          xy_Gam3 = 1.0d100
   266: *V-----           xy_Gam4 = 1.0d100
   267:                 else
   268:                   ! Coefficients for Eddington approximation
   269:                   !
   270:                   Gam1    =  ( 7.0_DP - SSAAdj * ( 4.0_DP + 3.0_DP * AFAdj ) ) / 4.0_DP
   271:                   Gam2    = -( 1.0_DP - SSAAdj * ( 4.0_DP - 3.0_DP * AFAdj ) ) / 4.0_DP
   272: *W----->          xy_Gam3 =  ( 2.0_DP - 3.0_DP * AFAdj * xy_cosSZA )        / 4.0_DP
   273: *W-----           xy_Gam4 = 1.0_DP - xy_Gam3
   274:                 end if
   275:             
   276:             
   277:                 Lambda = sqrt( Gam1**2 - Gam2**2 )
   278:                 LSigma = Gam2 / ( Gam1 + Lambda )
   279:             
   280: +------>        do k = 0, kmax
   281: |W*==== A         xyr_Trans(:,:,k) = exp( - xyr_OptDepAdj(:,:,k) * xy_cosSZAInv )
   282: +------         end do
   283:             
   284:             
   285:                 if ( FlagSL09LV ) then
   286: **W---->          xyr_CUp = 0.0_DP
   287: **W----           xyr_CDo = 0.0_DP
   288: +V=====           xy_DWRadSFluxAtTOA = SolarFluxAtTOA * xy_CosSZA
   289:                 else
   290: +------>          do k = 0, kmax
   291: |*W---->A           xyr_TMPVal(:,:,k) =                                       &
   292: |||                   &   SSAAdj * SolarFluxAtTOA * xyr_Trans(:,:,k)          &
   293: |||                   & / ( Lambda**2 - xy_cosSZAInvsq )
   294: |||     A           xyr_CUp(:,:,k) = xyr_TMPVal(:,:,k)                        &
   295: |||                   &   * ( ( Gam1 - xy_cosSZAInv ) * xy_Gam3 + Gam2 * xy_Gam4 )
   296: |||                 xyr_CDo(:,:,k) = xyr_TMPVal(:,:,k)                        &
   297: |||                   &   * ( ( Gam1 + xy_cosSZAInv ) * xy_Gam4 + Gam2 * xy_Gam3 )
   298: |*W---- A           xy_DWRadSFluxAtTOA = 0.0_DP
   299: +------           end do
   300:                 end if
   301:             
   302:             
   303:                 ! A variable used in the following calculation
   304:                 !
   305: W**====         xyr_ExpLamOptDep = exp( Lambda * xyr_OptDepAdj )
   306:             
   307:                 if ( FlagSemiInfAtmLV ) then
   308: *V----->          xy_k1 = 0.0_DP
   309: *V----- A         xy_k2 = xy_DWRadSFluxAtTOA - xyr_CDo(:,:,kmax)
   310:                 else
   311: *W----->A         xy_k2 = &
   312: ||                  & (                                                 &
   313: ||                  &     ( xy_SurfAlbedo * LSigma - 1.0_DP )           &
   314: ||                  &       * ( xy_DWRadSFluxAtTOA - xyr_CDo(:,:,kmax) ) * xyr_ExpLamOptDep(:,:,0)  &
   315: ||                  &   + LSigma                                                                    &
   316: ||                  &       * ( - xyr_CUp(:,:,0)                                                    &
   317: ||                  &           + xy_SurfAlbedo * (   xyr_CDo(:,:,0)                                &
   318: ||                  &                               + SolarFluxAtTOA * xy_CosSZA * xyr_Trans(:,:,0) ) &
   319: ||                  &         )                                                                     &
   320: ||                  & ) &
   321: ||                  & / &
   322: ||                  & ( &
   323: ||                  &     ( xy_SurfAlbedo * LSigma - 1.0_DP ) * xyr_ExpLamOptDep(:,:,0) &
   324: ||                  &   - ( xy_SurfAlbedo - LSigma ) * LSigma / xyr_ExpLamOptDep(:,:,0) &
   325: ||                  & )
   326: ||          
   327: *W-----           xy_k1 = ( xy_DWRadSFluxAtTOA - xyr_CDo(:,:,kmax) - xy_k2 ) / LSigma
   328:                 end if
   329:             
   330:             
   331:                 ! Calculate radiative flux
   332:                 !
   333:             !!$    do k = 0, kmax
   334:             !!$      xyr_RadSFlux(:,:,k) =                                                             &
   335:             !!$        &   ( 1.0_DP - LSigma )                                                         &
   336:             !!$        &     * ( xy_k1 * xyr_ExpLamOptDep(:,:,k) - xy_k2 / xyr_ExpLamOptDep(:,:,k) )   &
   337:             !!$        & + xyr_CUp(:,:,k) - xyr_CDo(:,:,k)
   338:             !!$    end do
   339: +------>        do k = 0, kmax
   340: |*W---->A         xyr_RadSUwFlux(:,:,k) =                         &
   341: |||                 &            xy_k1 * xyr_ExpLamOptDep(:,:,k)  &
   342: |||                 & + LSigma * xy_k2 / xyr_ExpLamOptDep(:,:,k)  &
   343: |||                 & + xyr_CUp(:,:,k)
   344: |*W---- A         xyr_RadSDwFlux(:,:,k) =                         &
   345: |                   &   LSigma * xy_k1 * xyr_ExpLamOptDep(:,:,k)  &
   346: |                   & +          xy_k2 / xyr_ExpLamOptDep(:,:,k)  &
   347: |                   & + xyr_CDo(:,:,k)
   348: +------         end do
   349:             
   350:             
   351:                 if ( .not. FlagSL09LV ) then
   352:                   !
   353:                   ! Add direct solar insolation
   354:                   !
   355:             !!$      do k = 0, kmax
   356:             !!$        xyr_RadSFlux(:,:,k) = xyr_RadSFlux(:,:,k) &
   357:             !!$          & - SolarFluxAtTOA * xyr_Trans(:,:,k) * xy_cosSZA
   358:             !!$      end do
   359: +------>          do k = 0, kmax
   360: |W*==== A           xyr_RadSDwFlux(:,:,k) = xyr_RadSDwFlux(:,:,k) &
   361: |                     & + SolarFluxAtTOA * xyr_Trans(:,:,k) * xy_cosSZA
   362: +------           end do
   363:                 end if
   364:             
   365: +------>        do k = 0, kmax
   366: |W----->          do j = 1, jmax
   367: ||*---->            do i = 0, imax-1
   368: |||     A             if( xy_cosSZA(i,j) <= 0.0_DP ) then
   369: |||         !!$            xyr_RadSFlux(i,j,k) = 0.0_DP
   370: |||     A               xyr_RadSUwFlux(i,j,k) = 0.0_DP
   371: |||     A               xyr_RadSDwFlux(i,j,k) = 0.0_DP
   372: |||                   end if
   373: ||*----             end do
   374: |W-----           end do
   375: +------         end do
   376:             
   377:             
   378:               end subroutine RadRTETwoStreamAppHomogAtm
   379:             
   380:               !------------------------------------------------------------------------------------
   381:             
   382:               subroutine RadRTETwoStreamAppSW(      &
   383:                 & xyz_SSA, xyz_AF,                  & ! (in)
   384:                 & xyr_OptDep,                       & ! (in)
   385:                 & xy_SurfAlbedo,                    & ! (in)
   386:                 & SolarFluxTOA, xy_InAngle,         & ! (in)
   387:                 & xyr_RadUwFlux, xyr_RadDwFlux      & ! (out)
   388:                 & )
   389:             
   390:                 ! USE statements
   391:                 !
   392:             
   393:                 real(DP), intent(in ) :: xyz_SSA       ( 0:imax-1, 1:jmax, 1:kmax )
   394:                 real(DP), intent(in ) :: xyz_AF        ( 0:imax-1, 1:jmax, 1:kmax )
   395:                 real(DP), intent(in ) :: xyr_OptDep   (0:imax-1, 1:jmax, 0:kmax)
   396:                 real(DP), intent(in ) :: xy_SurfAlbedo ( 0:imax-1, 1:jmax )
   397:                 real(DP), intent(in ) :: SolarFluxTOA
   398:                 real(DP), intent(in ) :: xy_InAngle    (0:imax-1, 1:jmax)
   399:                                           ! sec (入射角).
   400:                                           ! sec (angle of incidence)
   401:                 real(DP), intent(out) :: xyr_RadUwFlux(0:imax-1, 1:jmax, 0:kmax)
   402:                 real(DP), intent(out) :: xyr_RadDwFlux(0:imax-1, 1:jmax, 0:kmax)
   403:             
   404:                 ! Local variables
   405:                 !
   406:                 integer :: IDScatApprox
   407:                 logical :: FlagTOAFlux
   408:                 logical :: FlagEmis
   409:                 logical :: FlagSrcFuncTech
   410:             
   411:                 ! 初期化確認
   412:                 ! Initialization check
   413:                 !
   414:                 if ( .not. rad_rte_two_stream_app_inited ) then
   415:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   416:                 end if
   417:             
   418:             
   419:                 IDScatApprox    = IDScatApproxEddington
   420:                 FlagTOAFlux     = .true.
   421:                 FlagEmis        = .false.
   422:                 FlagSrcFuncTech = .false.
   423:             
   424:                 call RadRTETwoStreamAppWrapper(                     &
   425:                   & IDScatApprox, FlagTOAFlux, FlagEmis, FlagSrcFuncTech, & ! (in)
   426:                   & xyz_SSA, xyz_AF,                                & ! (in)
   427:                   & xyr_OptDep,                                     & ! (in)
   428:                   & xy_SurfAlbedo,                                  & ! (in)
   429:                   & xyr_RadUwFlux, xyr_RadDwFlux,                   & ! (out)
   430:                   & SolarFluxTOA = SolarFluxTOA, xy_InAngle = xy_InAngle        & ! (in) optional
   431:                   & )
   432:             
   433:             
   434:               end subroutine RadRTETwoStreamAppSW
   435:             
   436:               !------------------------------------------------------------------------------------
   437:             
   438:               subroutine RadRTETwoStreamAppLW(                     &
   439:                 & xyz_SSA, xyz_AF,                                 & ! (in)
   440:                 & xyr_OptDep,                                      & ! (in)
   441:                 & xy_SurfAlbedo,                                   & ! (in)
   442:                 & xyr_PFInted, xy_SurfPFInted, xy_SurfDPFDTInted,  & ! (in)
   443:                 & xyr_RadUwFlux, xyr_RadDwFlux,                    & ! (out)
   444:                 & xyra_DelRadUwFlux, xyra_DelRadDwFlux             & ! (out)
   445:                 & )
   446:             
   447:                 ! USE statements
   448:                 !
   449:             
   450:                 real(DP), intent(in ) :: xyz_SSA          (0:imax-1, 1:jmax, 1:kmax)
   451:                 real(DP), intent(in ) :: xyz_AF           (0:imax-1, 1:jmax, 1:kmax)
   452:                 real(DP), intent(in ) :: xyr_OptDep       (0:imax-1, 1:jmax, 0:kmax)
   453:                 real(DP), intent(in ) :: xy_SurfAlbedo    (0:imax-1, 1:jmax)
   454:                 real(DP), intent(in ) :: xyr_PFInted      (0:imax-1, 1:jmax, 0:kmax)
   455:                 real(DP), intent(in ) :: xy_SurfPFInted   (0:imax-1, 1:jmax)
   456:                 real(DP), intent(in ) :: xy_SurfDPFDTInted(0:imax-1, 1:jmax)
   457:                 real(DP), intent(out) :: xyr_RadUwFlux    (0:imax-1, 1:jmax, 0:kmax)
   458:                 real(DP), intent(out) :: xyr_RadDwFlux    (0:imax-1, 1:jmax, 0:kmax)
   459:                 real(DP), intent(out) :: xyra_DelRadUwFlux(0:imax-1, 1:jmax, 0:kmax, 0:1)
   460:                 real(DP), intent(out) :: xyra_DelRadDwFlux(0:imax-1, 1:jmax, 0:kmax, 0:1)
   461:             
   462:             
   463:                 ! Local variables
   464:                 !
   465:                 integer :: IDScatApprox
   466:                 logical :: FlagTOAFlux
   467:                 logical :: FlagEmis
   468:                 logical :: FlagSrcFuncTech
   469:             
   470:             
   471:                 ! 初期化確認
   472:                 ! Initialization check
   473:                 !
   474:                 if ( .not. rad_rte_two_stream_app_inited ) then
   475:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   476:                 end if
   477:             
   478:             
   479:                 IDScatApprox    = IDScatApproxHemiMean
   480:                 FlagTOAFlux     = .false.
   481:                 FlagEmis        = .true.
   482:                 FlagSrcFuncTech = .true.
   483:             
   484:                 call RadRTETwoStreamAppWrapper(                     &
   485:                   & IDScatApprox, FlagTOAFlux, FlagEmis, FlagSrcFuncTech,  & ! (in)
   486:                   & xyz_SSA, xyz_AF,                                & ! (in)
   487:                   & xyr_OptDep,                                     & ! (in)
   488:                   & xy_SurfAlbedo,                                  & ! (in)
   489:                   & xyr_RadUwFlux, xyr_RadDwFlux,                   & ! (out)
   490:                   & xyr_PFInted = xyr_PFInted, xy_SurfPFInted = xy_SurfPFInted, xy_SurfDPFDTInted = xy_SurfDPFDTInted,    & ! (in) optional
   491:                   & xyra_DelRadUwFlux = xyra_DelRadUwFlux, xyra_DelRadDwFlux = xyra_DelRadDwFlux     & ! (out) optional
   492:                   & )
   493:             
   494:             
   495:               end subroutine RadRTETwoStreamAppLW
   496:             
   497:               !--------------------------------------------------------------------------------------
   498:               ! NOTE:
   499:               ! xyr_PFInted    = \pi B
   500:               ! xy_SurfPFInted = \epsilon \pi B
   501:               !--------------------------------------------------------------------------------------
   502:             
   503:               subroutine RadRTETwoStreamAppWrapper(                &
   504:                 & IDScatApprox, FlagTOAFlux, FlagEmis, FlagSrcFuncTech,  & ! (in)
   505:                 & xyz_SSA, xyz_AF,                                 & ! (in)
   506:                 & xyr_OptDep,                                      & ! (in)
   507:                 & xy_SurfAlbedo,                                   & ! (in)
   508:                 & xyr_RadUwFlux, xyr_RadDwFlux,                    & ! (out)
   509:                 & SolarFluxTOA, xy_InAngle,                        & ! (in) optional
   510:                 & xyr_PFInted, xy_SurfPFInted, xy_SurfDPFDTInted,  & ! (in) optional
   511:                 & xyra_DelRadUwFlux, xyra_DelRadDwFlux             & ! (out) optional
   512:                 & )
   513:             
   514:                 ! USE statements
   515:                 !
   516:             
   517:                 ! OpenMP
   518:                 !
   519:                 !$ use omp_lib
   520:             
   521:             
   522:                 integer , intent(in ) :: IDScatApprox
   523:                 logical , intent(in ) :: FlagTOAFlux
   524:                 logical , intent(in ) :: FlagEmis
   525:                 logical , intent(in ) :: FlagSrcFuncTech
   526:                 real(DP), intent(in ) :: xyz_SSA       ( 0:imax-1, 1:jmax, 1:kmax )
   527:                 real(DP), intent(in ) :: xyz_AF        ( 0:imax-1, 1:jmax, 1:kmax )
   528:                 real(DP), intent(in ) :: xyr_OptDep   (0:imax-1, 1:jmax, 0:kmax)
   529:                 real(DP), intent(in ) :: xy_SurfAlbedo ( 0:imax-1, 1:jmax )
   530:                 real(DP), intent(out) :: xyr_RadUwFlux(0:imax-1, 1:jmax, 0:kmax)
   531:                 real(DP), intent(out) :: xyr_RadDwFlux(0:imax-1, 1:jmax, 0:kmax)
   532:             
   533:                 real(DP), intent(in ), optional :: SolarFluxTOA
   534:                 real(DP), intent(in ), optional :: xy_InAngle    (0:imax-1, 1:jmax)
   535:                                           ! sec (入射角).
   536:                                           ! sec (angle of incidence)
   537:                 real(DP), intent(in ), optional :: xyr_PFInted      (0:imax-1, 1:jmax, 0:kmax)
   538:                 real(DP), intent(in ), optional :: xy_SurfPFInted   (0:imax-1, 1:jmax)
   539:                 real(DP), intent(in ), optional :: xy_SurfDPFDTInted(0:imax-1, 1:jmax)
   540:                 real(DP), intent(out), optional :: xyra_DelRadUwFlux(0:imax-1, 1:jmax, 0:kmax, 0:1)
   541:                 real(DP), intent(out), optional :: xyra_DelRadDwFlux(0:imax-1, 1:jmax, 0:kmax, 0:1)
   542:             
   543:                 ! Local variables
   544:                 !
   545:                 integer :: js
   546:                 integer :: je
   547:             
   548:                 integer :: nthreads
   549:                 integer, allocatable :: a_js(:)
   550:                 integer, allocatable :: a_je(:)
   551:             
   552:                 integer :: n
   553:             
   554:             
   555:                 ! 初期化確認
   556:                 ! Initialization check
   557:                 !
   558:                 if ( .not. rad_rte_two_stream_app_inited ) then
   559:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   560:                 end if
   561:             
   562:             
   563:                 !
   564:                 ! Arguments are checked.
   565:                 !
   566:                 if ( FlagTOAFlux ) then
   567:                   if ( .not. present( SolarFluxTOA ) ) &
   568:                     & call MessageNotify( 'E', module_name, 'SolarFluxTOA has to be present.' )
   569:                   if ( .not. present( xy_InAngle ) ) &
   570:                     & call MessageNotify( 'E', module_name, 'xy_InAngle has to be present.' )
   571:                 else
   572:                   if ( present( SolarFluxTOA ) ) &
   573:                     & call MessageNotify( 'E', module_name, 'SolarFluxTOA need not be present.' )
   574:                   if ( present( xy_InAngle ) ) &
   575:                     & call MessageNotify( 'E', module_name, 'xy_InAngle need not be present.' )
   576:                 end if
   577:             
   578:                 if ( FlagEmis ) then
   579:                   if ( .not. present( xyr_PFInted ) ) &
   580:                     & call MessageNotify( 'E', module_name, 'xyr_PFInted has to be present.' )
   581:                   if ( .not. present( xy_SurfPFInted ) ) &
   582:                     & call MessageNotify( 'E', module_name, 'xy_SurfPFInted has to be present.' )
   583:                   if ( .not. present( xy_SurfDPFDTInted ) ) &
   584:                     & call MessageNotify( 'E', module_name, 'xy_SurfDPFDTInted has to be present.' )
   585:                   if ( .not. present( xyra_DelRadUwFlux ) ) &
   586:                     & call MessageNotify( 'E', module_name, 'xyra_DelRadUwFlux has to be present.' )
   587:                   if ( .not. present( xyra_DelRadDwFlux ) ) &
   588:                     & call MessageNotify( 'E', module_name, 'xyra_DelRadLwFlux has to be present.' )
   589:                 else
   590:                   if ( present( xyr_PFInted ) ) &
   591:                     & call MessageNotify( 'E', module_name, 'xyr_PFInted need not be present.' )
   592:                   if ( present( xy_SurfPFInted ) ) &
   593:                     & call MessageNotify( 'E', module_name, 'xy_SurfPFInted need not be present.' )
   594:                   if ( present( xy_SurfDPFDTInted ) ) &
   595:                     & call MessageNotify( 'E', module_name, 'xy_SurfDPFDTInted need not be present.' )
   596:                   if ( present( xyra_DelRadUwFlux ) ) &
   597:                     & call MessageNotify( 'E', module_name, 'xyra_DelRadUwFlux need not be present.' )
   598:                   if ( present( xyra_DelRadDwFlux ) ) &
   599:                     & call MessageNotify( 'E', module_name, 'xyra_DelRadLwFlux need not be present.' )
   600:                 end if
   601:             
   602:             
   603:                 nthreads = 1
   604:                 !$ nthreads  = omp_get_max_threads()
   605:             !!$    !$ write( 6, * ) "Number of processors : ", omp_get_num_procs()
   606:             !!$    !$ write( 6, * ) "Number of threads    : ", nthreads
   607:             
   608:                 allocate( a_js(0:nthreads-1) )
   609:                 allocate( a_je(0:nthreads-1) )
   610:             
   611: *------>        do n = 0, nthreads-1
   612: |           
   613: |                 if ( n == 0 ) then
   614: |                   a_js(n) = 1
   615: |                 else
   616: |                   a_js(n) = a_je(n-1) + 1
   617: |                 end if
   618: |           
   619: |                 a_je(n) = a_js(n  ) + jmax / nthreads - 1
   620: |                 if ( n + 1 <= mod( jmax, nthreads ) ) then
   621: |                   a_je(n) = a_je(n) + 1
   622: |                 end if
   623: |           
   624: *------         end do
   625:             
   626:             
   627:             !!$    !$OMP PARALLEL DEFAULT(PRIVATE) &
   628:             !!$    !$OMP SHARED(nthreads,a_js,a_je, &
   629:             !!$    !$OMP        xyz_SSA, xyz_AF, &
   630:             !!$    !$OMP        SolarFluxTOA, &
   631:             !!$    !$OMP        xy_SurfAlbedo, &
   632:             !!$    !$OMP        IDScatApprox, FlagTOAFlux, FlagEmis, FlagSrcFuncTech, &
   633:             !!$    !$OMP        xy_InAngle, &
   634:             !!$    !$OMP        xyr_OptDep, &
   635:             !!$    !$OMP        xyr_RadUwFlux, &
   636:             !!$    !$OMP        xyr_RadDwFlux, &
   637:             !!$    !$OMP        xyr_PFInted, xy_SurfPFInted, xy_SurfDPFDTInted, &
   638:             !!$    !$OMP        xyra_DelRadUwFlux, xyra_DelRadDwFlux)
   639:             !!$
   640:             !!$    !$OMP DO
   641:             
   642: *------>        do n = 0, nthreads-1
   643: |           
   644: |                 js = a_js(n)
   645: |                 je = a_je(n)
   646: |           
   647: |                 if ( js > je ) cycle
   648: |           
   649: |           !!$      write( 6, * ) n, js, je
   650: |           
   651: |                 call RadRTETwoStreamAppCore(              &
   652: |                   & IDScatApprox, FlagTOAFlux, FlagEmis, FlagSrcFuncTech, & ! (in)
   653: |                   & xyz_SSA, xyz_AF,                      & ! (in)
   654: |                   & xyr_OptDep,                           & ! (in)
   655: |                   & xy_SurfAlbedo,                        & ! (in)
   656: |                   & xyr_RadUwFlux, xyr_RadDwFlux,         & ! (out)
   657: |                   & js, je,                               & ! (in)
   658: |                   & SolarFluxTOA = SolarFluxTOA, xy_InAngle = xy_InAngle,      & ! (in) optional
   659: |                   & xyr_PFInted = xyr_PFInted, xy_SurfPFInted = xy_SurfPFInted, xy_SurfDPFDTInted = xy_SurfDPFDTInted,    & ! (in) optional
   660: |                   & xyra_DelRadUwFlux = xyra_DelRadUwFlux, xyra_DelRadDwFlux = xyra_DelRadDwFlux     & ! (out) optional
   661: |                   & )
   662: |           
   663: *------         end do
   664:             
   665:             
   666:             !!$    !$OMP END DO
   667:             !!$    !$OMP END PARALLEL
   668:             
   669:             
   670:                 deallocate( a_js )
   671:                 deallocate( a_je )
   672:             
   673:             
   674:             
   675:               end subroutine RadRTETwoStreamAppWrapper
   676:             
   677:               !--------------------------------------------------------------------------------------
   678:               ! NOTE:
   679:               ! xyr_PFInted    = \pi B
   680:               ! xy_SurfPFInted = \epsilon \pi B
   681:               !--------------------------------------------------------------------------------------
   682:             
   683:               subroutine RadRTETwoStreamAppCore(                         &
   684:                 & IDScatApprox, FlagTOAFlux, FlagEmis, FlagSrcFuncTech,  & ! (in)
   685:                 & xyz_SSA, xyz_AF,                                       & ! (in)
   686:                 & xyr_OptDep,                                            & ! (in)
   687:                 & xy_SurfAlbedo,                                         & ! (in)
   688:                 & xyr_RadUwFlux, xyr_RadDwFlux,                          & ! (out)
   689:                 & js, je,                                                & ! (in)
   690:                 & SolarFluxTOA, xy_InAngle,                              & ! (in) optional
   691:                 & xyr_PFInted, xy_SurfPFInted, xy_SurfDPFDTInted,        & ! (in) optional
   692:                 & xyra_DelRadUwFlux, xyra_DelRadDwFlux                   & ! (out) optional
   693:                 & )
   694:             
   695:                 ! USE statements
   696:                 !
   697:             
   698:             !!$  use pf_module , only : pfint_gq_array
   699:             
   700:             
   701:                 integer , intent(in ) :: IDScatApprox
   702:                 logical , intent(in ) :: FlagTOAFlux
   703:                 logical , intent(in ) :: FlagEmis
   704:                 logical , intent(in ) :: FlagSrcFuncTech
   705:                 real(DP), intent(in ) :: xyz_SSA      (0:imax-1, 1:jmax, 1:kmax)
   706:                 real(DP), intent(in ) :: xyz_AF       (0:imax-1, 1:jmax, 1:kmax)
   707:                 real(DP), intent(in ) :: xyr_OptDep   (0:imax-1, 1:jmax, 0:kmax)
   708:                 real(DP), intent(in ) :: xy_SurfAlbedo(0:imax-1, 1:jmax)
   709:                 real(DP), intent(out) :: xyr_RadUwFlux(0:imax-1, 1:jmax, 0:kmax)
   710:                 real(DP), intent(out) :: xyr_RadDwFlux(0:imax-1, 1:jmax, 0:kmax)
   711:             
   712:                 integer , intent(in ) :: js
   713:                 integer , intent(in ) :: je
   714:             
   715:                 real(DP), intent(in ), optional :: SolarFluxTOA
   716:                 real(DP), intent(in ), optional :: xy_InAngle    (0:imax-1, 1:jmax)
   717:                                           ! sec (入射角).
   718:                                           ! sec (angle of incidence)
   719:                 real(DP), intent(in ), optional :: xyr_PFInted      (0:imax-1, 1:jmax, 0:kmax)
   720:                 real(DP), intent(in ), optional :: xy_SurfPFInted   (0:imax-1, 1:jmax)
   721:                 real(DP), intent(in ), optional :: xy_SurfDPFDTInted(0:imax-1, 1:jmax)
   722:                 real(DP), intent(out), optional :: xyra_DelRadUwFlux(0:imax-1, 1:jmax, 0:kmax, 0:1)
   723:                 real(DP), intent(out), optional :: xyra_DelRadDwFlux(0:imax-1, 1:jmax, 0:kmax, 0:1)
   724:             
   725:             
   726:             !!$    real(DP), intent(in ) :: gt         ( 0:imax-1, 1:jmax, 1:kmax )
   727:             !!$    real(DP), intent(in ) :: gts        ( 0:imax-1, 1:jmax )
   728:             !!$    real(DP), intent(in ) :: gph        ( 0:imax-1, 1:jmax, 0:kmax )
   729:             
   730:             !!$    real(DP), intent(in ) :: emis  ( 0:imax-1, 1:jmax )
   731:             !!$    real(DP), intent(in ) :: wn1, wn2
   732:             !!$    integer , intent(in ) :: divnum
   733:             
   734:             
   735:             !!$  real(DP)    , intent(out) :: &
   736:             !!$    gor ( im, jm ), goru ( im, jm ), gord ( im, jm ), &
   737:             !!$    gsr ( im, jm ), gsru ( im, jm ), gsrd ( im, jm )
   738:             
   739:                 real(DP) :: xy_SolarFluxTOA(0:imax-1, 1:jmax)
   740:             
   741:                 !
   742:                 ! SSAAdj    : Delta-Function Adjusted Single-Scattering Albedo
   743:                 ! AFAdj     : Delta-Function Adjusted Asymmetry Factor
   744:                 ! OpDepAdj  : Delta-Function Adjusted Optical Depth
   745:                 !
   746:                 real(DP) :: xyz_SSAAdj     ( 0:imax-1, 1:jmax, 1:kmax )
   747:                 real(DP) :: xyz_AFAdj      ( 0:imax-1, 1:jmax, 1:kmax )
   748:                 real(DP) :: xyr_OpDepAdj   ( 0:imax-1, 1:jmax, 0:kmax )
   749:                 real(DP) :: xyr_TransDirAdj( 0:imax-1, 1:jmax, 0:kmax )
   750:             
   751:                 !
   752:                 ! gam?    : Coefficients of Generalized Radiative Transfer Equation
   753:                 !
   754:                 real(DP) :: xyz_Gam1( 0:imax-1, 1:jmax, 1:kmax )
   755:                 real(DP) :: xyz_Gam2( 0:imax-1, 1:jmax, 1:kmax )
   756:                 real(DP) :: xyz_Gam3( 0:imax-1, 1:jmax, 1:kmax )
   757:                 real(DP) :: xyz_Gam4( 0:imax-1, 1:jmax, 1:kmax )
   758:             
   759:                 !
   760:                 ! cosz     : cosine of solar zenith angle
   761:                 ! cosz2    : cosz squared
   762:                 !
   763:                 real(DP) :: xy_cosSZA     ( 0:imax-1, 1:jmax )
   764:                 real(DP) :: xy_cosSZAInv  ( 0:imax-1, 1:jmax )
   765:                 real(DP) :: xy_cosSZAInvsq( 0:imax-1, 1:jmax )
   766:             
   767:                 !
   768:                 ! temporary variables
   769:                 !
   770:                 real(DP) :: xyz_DelTau( 0:imax-1, 1:jmax, 1:kmax )
   771:             
   772:                 real(DP) :: xyz_Lambda ( 0:imax-1, 1:jmax, 1:kmax )
   773:                 real(DP) :: xyz_LGamma ( 0:imax-1, 1:jmax, 1:kmax )
   774:                 real(DP) :: xyaz_smalle( 0:imax-1, 1:jmax, 4, 1:kmax )
   775:             
   776:                 real(DP) :: xy_SurfSrc( 0:imax-1, 1:jmax )
   777:             
   778:                 !
   779:                 ! CUpB      : upward C at bottom of layer
   780:                 ! CUpT      : upward C at top of layer
   781:                 ! CDoB      : downward C at bottom of layer
   782:                 ! CDoT      : downward C at top of layer
   783:                 !
   784:                 real(DP) :: xyz_CUpB( 0:imax-1, 1:jmax, 1:kmax )
   785:                 real(DP) :: xyz_CUpT( 0:imax-1, 1:jmax, 1:kmax )
   786:                 real(DP) :: xyz_CDoB( 0:imax-1, 1:jmax, 1:kmax )
   787:                 real(DP) :: xyz_CDoT( 0:imax-1, 1:jmax, 1:kmax )
   788:                 !
   789:                 real(DP) :: xyz_CUpBDir( 0:imax-1, 1:jmax, 1:kmax )
   790:                 real(DP) :: xyz_CUpTDir( 0:imax-1, 1:jmax, 1:kmax )
   791:                 real(DP) :: xyz_CDoBDir( 0:imax-1, 1:jmax, 1:kmax )
   792:                 real(DP) :: xyz_CDoTDir( 0:imax-1, 1:jmax, 1:kmax )
   793:                 !
   794:                 real(DP) :: xyz_CUpBEmi( 0:imax-1, 1:jmax, 1:kmax )
   795:                 real(DP) :: xyz_CUpTEmi( 0:imax-1, 1:jmax, 1:kmax )
   796:                 real(DP) :: xyz_CDoBEmi( 0:imax-1, 1:jmax, 1:kmax )
   797:                 real(DP) :: xyz_CDoTEmi( 0:imax-1, 1:jmax, 1:kmax )
   798:             
   799:                 real(DP) :: aa_TridiagMtx1( 1:imax*jmax, 1:kmax*2 )
   800:                 real(DP) :: aa_TridiagMtx2( 1:imax*jmax, 1:kmax*2 )
   801:                 real(DP) :: aa_TridiagMtx3( 1:imax*jmax, 1:kmax*2 )
   802:                 real(DP) :: aa_Vec        ( 1:imax*jmax, 1:kmax*2 )
   803:             
   804:                 real(DP) :: xy_TMPVal( 0:imax-1, 1:jmax )
   805:             
   806:                 real(DP) :: xyz_B0( 0:imax-1, 1:jmax, 1:kmax )
   807:                 real(DP) :: xyz_B1( 0:imax-1, 1:jmax, 1:kmax )
   808:             
   809:                 real(DP) :: Mu
   810:                 real(DP) :: xyz_Mu1( 0:imax-1, 1:jmax, 1:kmax )
   811:             
   812:             !!$  real(DP) :: gth( im, jm, km+1 ), pfinth( im, jm, km+1 )
   813:             !!$  real(DP) :: b0( ijs:ije, 1, km ), b1( ijs:ije, 1, km )
   814:             !!$  real(DP) :: gemis
   815:             
   816:             
   817:                 real(DP) :: xyr_IUw( 0:imax-1, 1:jmax, 0:kmax )
   818:                 real(DP) :: xyr_IDw( 0:imax-1, 1:jmax, 0:kmax )
   819:                 real(DP) :: FactG
   820:                 real(DP) :: FactH
   821:                 real(DP) :: FactJ
   822:                 real(DP) :: FactK
   823:                 real(DP) :: Alp1
   824:                 real(DP) :: Alp2
   825:                 real(DP) :: Sig1
   826:                 real(DP) :: Sig2
   827:             
   828:                 integer  :: i, j, k, l
   829:                 integer  :: ms, me
   830:             
   831:             
   832:                 ! Variables for debug
   833:                 !
   834:             !!$    real(DP) :: xyr_UwFluxDebug( 0:imax-1, 1:jmax, 0:kmax )
   835:             !!$    real(DP) :: xyr_DwFluxDebug( 0:imax-1, 1:jmax, 0:kmax )
   836:             
   837:             
   838:                 ! 初期化確認
   839:                 ! Initialization check
   840:                 !
   841:                 if ( .not. rad_rte_two_stream_app_inited ) then
   842:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   843:                 end if
   844:             
   845:             
   846:                 !
   847:                 ! Arguments are checked.
   848:                 !
   849:                 if ( FlagTOAFlux ) then
   850:                   if ( .not. present( SolarFluxTOA ) ) &
   851:                     & call MessageNotify( 'E', module_name, 'SolarFluxTOA has to be present.' )
   852:                   if ( .not. present( xy_InAngle ) ) &
   853:                     & call MessageNotify( 'E', module_name, 'xy_InAngle has to be present.' )
   854:                 else
   855:                   if ( present( SolarFluxTOA ) ) &
   856:                     & call MessageNotify( 'E', module_name, 'SolarFluxTOA need not be present.' )
   857:                   if ( present( xy_InAngle ) ) &
   858:                     & call MessageNotify( 'E', module_name, 'xy_InAngle need not be present.' )
   859:                 end if
   860:             
   861:                 if ( FlagEmis ) then
   862:                   if ( .not. present( xyr_PFInted ) ) &
   863:                     & call MessageNotify( 'E', module_name, 'xyr_PFInted has to be present.' )
   864:                   if ( .not. present( xy_SurfPFInted ) ) &
   865:                     & call MessageNotify( 'E', module_name, 'xy_SurfPFInted has to be present.' )
   866:                   if ( .not. present( xy_SurfDPFDTInted ) ) &
   867:                     & call MessageNotify( 'E', module_name, 'xy_SurfDPFDTInted has to be present.' )
   868:                   if ( .not. present( xyra_DelRadUwFlux ) ) &
   869:                     & call MessageNotify( 'E', module_name, 'xyra_DelRadUwFlux has to be present.' )
   870:                   if ( .not. present( xyra_DelRadDwFlux ) ) &
   871:                     & call MessageNotify( 'E', module_name, 'xyra_DelRadLwFlux has to be present.' )
   872:                 else
   873:                   if ( present( xyr_PFInted ) ) &
   874:                     & call MessageNotify( 'E', module_name, 'xyr_PFInted need not be present.' )
   875:                   if ( present( xy_SurfPFInted ) ) &
   876:                     & call MessageNotify( 'E', module_name, 'xy_SurfPFInted need not be present.' )
   877:                   if ( present( xy_SurfDPFDTInted ) ) &
   878:                     & call MessageNotify( 'E', module_name, 'xy_SurfDPFDTInted need not be present.' )
   879:                   if ( present( xyra_DelRadUwFlux ) ) &
   880:                     & call MessageNotify( 'E', module_name, 'xyra_DelRadUwFlux need not be present.' )
   881:                   if ( present( xyra_DelRadDwFlux ) ) &
   882:                     & call MessageNotify( 'E', module_name, 'xyra_DelRadLwFlux need not be present.' )
   883:                 end if
   884:             
   885:             
   886: +------>        do k = 1, kmax
   887: |+----->          do j = js, je
   888: ||+---->            do i = 0, imax-1
   889: |||                   if ( xyz_SSA(i,j,k) >= 1.0d0 ) then
   890: |||                     call MessageNotify( 'E', module_name, 'Single Scattering Albedo = %f', &
   891: |||                       & d = (/ xyz_SSA(i,j,k) /) )
   892: |||                   end if
   893: ||+----             end do
   894: |+-----           end do
   895: +------         end do
   896:             
   897:             
   898:                 if ( FlagTOAFlux ) then
   899:             
   900: W------>          do j = js, je
   901: |*----->            do i = 0, imax-1
   902: ||      A             if ( xy_InAngle(i,j) > 0.0d0 ) then
   903: ||      A               xy_cosSZA     (i,j) = 1.0d0 / xy_InAngle(i,j)
   904: ||                      xy_cosSZAInv  (i,j) = xy_InAngle(i,j)
   905: ||                      xy_cosSZAInvsq(i,j) = xy_cosSZAInv(i,j)**2
   906: ||                    else
   907: ||                      xy_cosSZA     (i,j) = 0.0d0
   908: ||                      xy_cosSZAInv  (i,j) = 0.0d0
   909: ||                      xy_cosSZAInvsq(i,j) = 0.0d0
   910: ||                    end if
   911: ||                  end do
   912: ||                end do
   913: ||          
   914: ||                do j = js, je
   915: ||                  do i = 0, imax-1
   916: ||                    if ( xy_InAngle(i,j) > 0.0d0 ) then
   917: ||                      xy_SolarFluxTOA(i,j) = SolarFluxTOA
   918: ||                    else
   919: ||                      xy_SolarFluxTOA(i,j) = 0.0_DP
   920: ||                    end if
   921: |*-----             end do
   922: W------           end do
   923:             
   924:                 else
   925:             
   926: W------>          do j = js, je
   927: |*----->            xy_cosSZA     (:,j) = 1.0d100
   928: ||                  xy_cosSZAInv  (:,j) = 1.0d100
   929: |*-----             xy_cosSZAInvsq(:,j) = 1.0d100
   930: W------           end do
   931:             
   932: W------>          do j = js, je
   933: |*----->            do i = 0, imax-1
   934: ||                    xy_SolarFluxTOA(i,j) = 1.0d100
   935: |*-----             end do
   936: W------           end do
   937:             
   938:                 end if
   939:             
   940:             
   941:                 !
   942:                 ! Delta-Function Adjustment
   943:                 !
   944: +------>        do k = 1, kmax
   945: |W----->          do j = js, je
   946: ||*---->A           xyz_AFAdj (:,j,k) = xyz_AF(:,j,k) / ( 1.0d0 + xyz_AF(:,j,k) )
   947: ||*---- A           xyz_SSAAdj(:,j,k) =   ( 1.0d0 - xyz_AF(:,j,k)**2 ) * xyz_SSA(:,j,k) &
   948: ||                    &               / ( 1.0d0 - xyz_SSA(:,j,k) * xyz_AF(:,j,k)**2 )
   949: |W-----           end do
   950: +------         end do
   951:                 !
   952: +------>        do k = 0, kmax
   953: |W----->          do j = js, je
   954: ||*====             xyr_OpDepAdj(:,j,k) = 0.0d0
   955: |W-----           end do
   956: +------         end do
   957: +------>        do k = kmax-1, 0, -1
   958: |W----->          do j = js, je
   959: ||*==== A           xyr_OpDepAdj(:,j,k) =                                       &
   960: ||                    &   xyr_OpDepAdj(:,j,k+1)                                 &
   961: ||                    & + ( 1.0d0 - xyz_SSA(:,j,k+1) * xyz_AF(:,j,k+1)**2 )     &
   962: ||                    &   * ( xyr_OptDep(:,j,k) - xyr_OptDep(:,j,k+1) )
   963: |W-----           end do
   964: +------         end do
   965:             
   966:             
   967:                 if ( FlagTOAFlux ) then
   968: +------>          do k = 0, kmax
   969: |W----->            do j = js, je
   970: ||*==== A             xyr_TransDirAdj(:,j,k) = exp( -xyr_OpDepAdj(:,j,k) * xy_cosSZAInv(:,j) )
   971: |W-----             end do
   972: +------           end do
   973:                 else
   974: +------>          do k = 0, kmax
   975: |W----->            do j = js, je
   976: ||*====               xyr_TransDirAdj(:,j,k) = 1.0d100
   977: |W-----             end do
   978: +------           end do
   979:                 end if
   980:             
   981:             
   982:                 select case ( IDScatApprox )
   983:                 case ( IDScatApproxEddington )
   984:             
   985:                   !
   986:                   ! Eddington approximation
   987:                   !
   988: +------>          do k = 1, kmax
   989: |W----->            do j = js, je
   990: ||*---->              xyz_Gam1(:,j,k) =  ( 7.0d0 - xyz_SSAAdj(:,j,k) * ( 4.0d0 + 3.0d0 * xyz_AFAdj(:,j,k) ) ) / 4.0d0
   991: |||                   xyz_Gam2(:,j,k) = -( 1.0d0 - xyz_SSAAdj(:,j,k) * ( 4.0d0 - 3.0d0 * xyz_AFAdj(:,j,k) ) ) / 4.0d0
   992: |||     A             xyz_Gam3(:,j,k) =  ( 2.0d0 - 3.0d0 * xyz_AFAdj(:,j,k) * xy_cosSZA(:,j) )              / 4.0d0
   993: ||*----               xyz_Gam4(:,j,k) = 1.0d0 - xyz_Gam3(:,j,k)
   994: |W-----             end do
   995: +------           end do
   996:             
   997: +------>          do k = 1, kmax
   998: |W----->            do j = js, je
   999: ||*---->              do i = 0, imax-1
  1000: |||         !!$            xyz_Mu1(i,j,k) = ( 1.0_DP - xyz_SSAAdj(i,j,k) ) / ( xyz_Gam1(i,j,k) - xyz_Gam2(i,j,k) )
  1001: |||                     xyz_Mu1(i,j,k) = 0.5_DP
  1002: ||*----               end do
  1003: |W-----             end do
  1004: +------           end do
  1005:             
  1006:                 case ( IDScatApproxHemiMean )
  1007:             
  1008:                   !
  1009:                   ! Treatment if delta-function adjustment is not performed.
  1010:                   !
  1011:             !!$      do k = 1, kmax
  1012:             !!$        do j = js, je
  1013:             !!$          xyz_AFAdj (:,j,k) = xyz_AF (:,j,k)
  1014:             !!$          xyz_SSAAdj(:,j,k) = xyz_SSA(:,j,k)
  1015:             !!$        end do
  1016:             !!$      end do
  1017:             !!$      do k = 0, kmax
  1018:             !!$        do j = js, je
  1019:             !!$          xyr_OpDepAdj(:,j,k) = xyr_OptDep(:,j,k)
  1020:             !!$        end do
  1021:             !!$      end do
  1022:             
  1023:                   !
  1024:                   ! Hemispheric mean approximation
  1025:                   !
  1026: +------>          do k = 1, kmax
  1027: |W----->            do j = js, je
  1028: ||*---->              xyz_Gam1(:,j,k) = 2.0_DP - xyz_SSAAdj(:,j,k) * ( 1.0_DP + xyz_AFAdj(:,j,k) )
  1029: |||                   xyz_Gam2(:,j,k) = xyz_SSAAdj(:,j,k) * ( 1.0_DP - xyz_AFAdj(:,j,k) )
  1030: |||                   xyz_Gam3(:,j,k) = 1.0d100
  1031: ||*----               xyz_Gam4(:,j,k) = 1.0d100
  1032: |W-----             end do
  1033: +------           end do
  1034:             
  1035: +------>          do k = 1, kmax
  1036: |W----->            do j = js, je
  1037: ||*---->              do i = 0, imax-1
  1038: |||         !!$            xyz_Mu1(i,j,k) = ( 1.0_DP - xyz_SSAAdj(i,j,k) ) / ( xyz_Gam1(i,j,k) - xyz_Gam2(i,j,k) )
  1039: |||                     xyz_Mu1(i,j,k) = 0.5_DP
  1040: ||*----               end do
  1041: |W-----             end do
  1042: +------           end do
  1043:             
  1044:                 case default
  1045:                   call MessageNotify( 'E', module_name, 'Unexpected IDScatApprox, %d', &
  1046:                     & i = (/ IDScatApprox /) )
  1047:                 end select
  1048:             
  1049:             
  1050: +------>        do k = 1, kmax
  1051: |W----->          do j = js, je
  1052: ||*==== A           xyz_DelTau(:,j,k) = xyr_OpDepAdj(:,j,k-1) - xyr_OpDepAdj(:,j,k)
  1053: |W-----           end do
  1054: +------         end do
  1055:             
  1056:             
  1057:                 if ( FlagEmis ) then
  1058:                   !
  1059:                   ! Avoiding singularity when dtau equal to zero 
  1060:                   !
  1061: +------>          do k = 1, kmax
  1062: |W----->            do j = js, je
  1063: ||*---->              do i = 0, imax-1
  1064: |||                     if( xyz_DelTau(i,j,k) < DelTauThreshold ) then
  1065: |||                       xyz_DelTau(i,j,k) = 0.0d0
  1066: |||                     end if
  1067: ||*----               end do
  1068: |W-----             end do
  1069: +------           end do
  1070:                 end if
  1071:             
  1072:             
  1073: +------>        do k = 1, kmax
  1074: |W----->          do j = js, je
  1075: ||                  ! In very small parameter space of single scattering albedo and asymmetry 
  1076: ||                  ! factor close to asymmetry factor of 1, xyz_Gam1**2 - xyz_Gam2**2 becomes 
  1077: ||                  ! negative value. (yot, 2011/11/20)
  1078: ||          !!$        xyz_Lambda(:,j,k) = sqrt( xyz_Gam1(:,j,k) * xyz_Gam1(:,j,k) - xyz_Gam2(:,j,k) * xyz_Gam2(:,j,k) )
  1079: ||*---->            xyz_Lambda(:,j,k) = sqrt( max( xyz_Gam1(:,j,k) * xyz_Gam1(:,j,k) - xyz_Gam2(:,j,k) * xyz_Gam2(:,j,k), 0.0_DP ) )
  1080: |||         !!$        xyz_Lambda(:,j,k) = sqrt( xyz_Gam1(:,j,k) * xyz_Gam1(:,j,k) - xyz_Gam2(:,j,k) * xyz_Gam2(:,j,k) + 1.0d-10 )
  1081: |||         
  1082: ||*----             xyz_LGamma(:,j,k) = xyz_Gam2(:,j,k) / ( xyz_Gam1(:,j,k) + xyz_Lambda(:,j,k) )
  1083: |W-----           end do
  1084: +------         end do
  1085:             
  1086: +------>        do k = 1, kmax
  1087: |W----->          do j = js, je
  1088: ||*---->A           xy_TMPVal(:,j)       = exp( - xyz_Lambda(:,j,k) * xyz_DelTau(:,j,k) )
  1089: |||                 xyaz_smalle(:,j,1,k) = xyz_LGamma(:,j,k) * xy_TMPVal(:,j) + 1.0_DP
  1090: |||                 xyaz_smalle(:,j,2,k) = xyz_LGamma(:,j,k) * xy_TMPVal(:,j) - 1.0_DP
  1091: |||                 xyaz_smalle(:,j,3,k) = xy_TMPVal(:,j) + xyz_LGamma(:,j,k)
  1092: ||*----             xyaz_smalle(:,j,4,k) = xy_TMPVal(:,j) - xyz_LGamma(:,j,k)
  1093: |W-----           end do
  1094: +------         end do
  1095:             
  1096:             
  1097:                 if ( FlagTOAFlux ) then
  1098: +------>          do k = 1, kmax
  1099: |W----->            do j = js, je
  1100: ||*---->A             xy_TMPVal(:,j) =                                                        &
  1101: |||                     &   xyz_SSAAdj(:,j,k) * xy_SolarFluxTOA(:,j)                          &
  1102: |||                     &   * ( ( xyz_Gam1(:,j,k) - xy_cosSZAInv(:,j) ) * xyz_Gam3(:,j,k)     &
  1103: |||                     &       + xyz_Gam2(:,j,k) * xyz_Gam4(:,j,k) )                         &
  1104: |||                     &   / ( xyz_Lambda(:,j,k) * xyz_Lambda(:,j,k) - xy_cosSZAInvsq(:,j) )
  1105: |||     A             xyz_CUpBDir(:,j,k) = xy_TMPVal(:,j) * xyr_TransDirAdj(:,j,k-1)
  1106: |||     A             xyz_CUpTDir(:,j,k) = xy_TMPVal(:,j) * xyr_TransDirAdj(:,j,k  )
  1107: |||                   !
  1108: |||                   xy_TMPVal(:,j) =                                                        &
  1109: |||                     &   xyz_SSAAdj(:,j,k) * xy_SolarFluxTOA(:,j)                          &
  1110: |||                     &   * ( ( xyz_Gam1(:,j,k) + xy_cosSZAInv(:,j) ) * xyz_Gam4(:,j,k)     &
  1111: |||                     &       + xyz_Gam2(:,j,k) * xyz_Gam3(:,j,k) )                         &
  1112: |||                     &   / ( xyz_Lambda(:,j,k) * xyz_Lambda(:,j,k) - xy_cosSZAInvsq(:,j) )
  1113: |||                   xyz_CDoBDir(:,j,k) = xy_TMPVal(:,j) * xyr_TransDirAdj(:,j,k-1)
  1114: ||*----               xyz_CDoTDir(:,j,k) = xy_TMPVal(:,j) * xyr_TransDirAdj(:,j,k  )
  1115: |W-----             end do
  1116: +------           end do
  1117:                 else
  1118: +------>          do k = 1, kmax
  1119: |W----->            do j = js, je
  1120: ||*---->              xyz_CUpBDir(:,j,k) = 0.0_DP
  1121: |||                   xyz_CUpTDir(:,j,k) = 0.0_DP
  1122: |||                   xyz_CDoBDir(:,j,k) = 0.0_DP
  1123: ||*----               xyz_CDoTDir(:,j,k) = 0.0_DP
  1124: |W-----             end do
  1125: +------           end do
  1126:                 end if
  1127:             
  1128:             
  1129:                 if ( FlagEmis ) then
  1130:             
  1131: +------>          do k = 1, kmax
  1132: |W----->            do j = js, je
  1133: ||*---->              do i = 0, imax-1
  1134: |||                     !
  1135: |||                     ! Notice!
  1136: |||                     ! Avoiding singularity when dtau equal to zero. 
  1137: |||                     ! dtau occationally has much smaller value. 
  1138: |||                     ! When this occurs, b1 cannot be calculated correctly. 
  1139: |||                     !
  1140: |||                     if( xyz_DelTau(i,j,k) /= 0.0_DP ) then
  1141: |||     A                 xyz_B0(i,j,k) = xyr_PFInted(i,j,k)
  1142: |||     A                 xyz_B1(i,j,k) = ( xyr_PFInted(i,j,k-1) - xyr_PFInted(i,j,k) ) / xyz_DelTau(i,j,k)
  1143: |||                     else
  1144: |||         !!$              xyz_B0(i,j,k) = 0.0_DP ! replace with a line below 2015/02/22 based on discussion with Onishi-san
  1145: |||     A                 xyz_B0(i,j,k) = xyr_PFInted(i,j,k)
  1146: |||                       xyz_B1(i,j,k) = 0.0_DP
  1147: |||                     end if
  1148: |||                   end do
  1149: |||                 end do
  1150: |||               end do
  1151: |||         
  1152: |||               do k = 1, kmax
  1153: |||                 do j = js, je
  1154: |||                   do i = 0, imax-1
  1155: |||         !!$            xyz_CUpB(i,j,k) = 2.0_DP * PI * Mu1 &
  1156: |||                     xyz_CUpBEmi(i,j,k) = 2.0_DP * xyz_Mu1(i,j,k) &
  1157: |||                       & * (   xyz_B0(i,j,k) &
  1158: |||                       &     + xyz_B1(i,j,k) &
  1159: |||                       &       * ( xyz_DelTau(i,j,k) + 1.0_DP / ( xyz_Gam1(i,j,k) + xyz_Gam2(i,j,k) ) ) )
  1160: |||         !!$            xyz_CUpT(i,j,k) = 2.0_DP * PI * Mu1 &
  1161: |||                     xyz_CUpTEmi(i,j,k) = 2.0_DP * xyz_Mu1(i,j,k) &
  1162: |||                       & * (   xyz_B0(i,j,k) &
  1163: |||                       &     + xyz_B1(i,j,k) &
  1164: |||                       &       * ( 0.0_DP            + 1.0_DP / ( xyz_Gam1(i,j,k) + xyz_Gam2(i,j,k) ) ) )
  1165: |||         !!$            xyz_CDoB(i,j,k) = 2.0_DP * PI * Mu1 &
  1166: |||                     xyz_CDoBEmi(i,j,k) = 2.0_DP * xyz_Mu1(i,j,k) &
  1167: |||                       & * (   xyz_B0(i,j,k) &
  1168: |||                       &     + xyz_B1(i,j,k) &
  1169: |||                       &       * ( xyz_DelTau(i,j,k) - 1.0_DP / ( xyz_Gam1(i,j,k) + xyz_Gam2(i,j,k) ) ) )
  1170: |||         !!$            xyz_CDoT(i,j,k) = 2.0_DP * PI * Mu1 &
  1171: |||                     xyz_CDoTEmi(i,j,k) = 2.0_DP * xyz_Mu1(i,j,k) &
  1172: |||                       & * (   xyz_B0(i,j,k) &
  1173: |||                       &     + xyz_B1(i,j,k) &
  1174: |||                       &       * ( 0.0_DP            - 1.0_DP / ( xyz_Gam1(i,j,k) + xyz_Gam2(i,j,k) ) ) )
  1175: ||*----               end do
  1176: |W-----             end do
  1177: +------           end do
  1178:             
  1179:                 else
  1180:             
  1181: +------>          do k = 1, kmax
  1182: |W----->            do j = js, je
  1183: ||*---->              xyz_CUpBEmi(:,j,k) = 0.0_DP
  1184: |||                   xyz_CUpTEmi(:,j,k) = 0.0_DP
  1185: |||                   xyz_CDoBEmi(:,j,k) = 0.0_DP
  1186: ||*----               xyz_CDoTEmi(:,j,k) = 0.0_DP
  1187: |W-----             end do
  1188: +------           end do
  1189:             
  1190:                 end if
  1191:             
  1192: +------>        do k = 1, kmax
  1193: |W----->          do j = js, je
  1194: ||*---->            xyz_CUpB(:,j,k) = xyz_CUpBDir(:,j,k) + xyz_CUpBEmi(:,j,k)
  1195: |||                 xyz_CUpT(:,j,k) = xyz_CUpTDir(:,j,k) + xyz_CUpTEmi(:,j,k)
  1196: |||                 xyz_CDoB(:,j,k) = xyz_CDoBDir(:,j,k) + xyz_CDoBEmi(:,j,k)
  1197: ||*----             xyz_CDoT(:,j,k) = xyz_CDoTDir(:,j,k) + xyz_CDoTEmi(:,j,k)
  1198: |W-----           end do
  1199: +------         end do
  1200:             
  1201:             
  1202:                 if ( FlagEmis ) then
  1203: +------>          do j = js, je
  1204: |+----->            do i = 0, imax-1
  1205: ||V==== A             xy_SurfSrc(:,j) = xy_SurfPFInted(:,j)
  1206: |+-----             end do
  1207: +------           end do
  1208:             !!$      else if( sw .eq. 2 ) then
  1209:             !!$         do ij = ijs, ije
  1210:             !!$!            gemis = 1.0d0
  1211:             !!$            gemis = emis( ij, 1 )
  1212:             !!$            ea( (ij-ijs+1), l ) &
  1213:             !!$                 = -CUpB( ij, 1, km ) + ( 1.0d0 - gemis ) * CDoB( ij, 1, km ) &
  1214:             !!$                 + gemis * pi * pfinth( ij, 1, km+1 )
  1215:             !!$         end do
  1216:                 else
  1217: +------>          do j = js, je
  1218: |+----->            do i = 0, imax-1
  1219: ||V==== A             xy_SurfSrc(:,j) = 0.0_DP
  1220: |+-----             end do
  1221: +------           end do
  1222:                 end if
  1223:             
  1224:                 if ( FlagTOAFlux ) then
  1225: W------>          do j = js, je
  1226: |*===== A           xy_SurfSrc(:,j) = xy_SurfSrc(:,j)                            &
  1227: |                     & + xy_SurfAlbedo(:,j) * xy_SolarFluxTOA(:,j) * xyr_TransDirAdj(:,j,0) * xy_cosSZA(:,j)
  1228: W------           end do
  1229:                 end if
  1230:             
  1231:             
  1232:             
  1233:                 k = 1
  1234:                 l = 1
  1235: +------>        do j = js, je
  1236: |V----->          do i = 0, imax-1
  1237: ||      A           aa_TridiagMtx1( i+imax*(j-1)+1, l ) =                                     &
  1238: ||                    & 0.0_DP
  1239: ||      A           aa_TridiagMtx2( i+imax*(j-1)+1, l ) =                                     &
  1240: ||                    &     xyaz_smalle(i,j,1,k) - xy_SurfAlbedo(i,j) * xyaz_smalle(i,j,3,k)
  1241: ||      A           aa_TridiagMtx3( i+imax*(j-1)+1, l ) =                                     &
  1242: ||                    & - ( xyaz_smalle(i,j,2,k) - xy_SurfAlbedo(i,j) * xyaz_smalle(i,j,4,k) )
  1243: ||                end do
  1244: ||              end do
  1245: ||              do j = js, je
  1246: ||                do i = 0, imax-1
  1247: ||                  aa_Vec( i+imax*(j-1)+1, l ) =                                              &
  1248: ||                    & - xyz_CUpB(i,j,k)                                                      &
  1249: ||                    & + xy_SurfAlbedo(i,j) * xyz_CDoB(i,j,k)                                 &
  1250: ||                    & + xy_SurfSrc(i,j)
  1251: |V-----           end do
  1252: +------         end do
  1253:             
  1254:             
  1255: +------>        do k = 1, kmax-1
  1256: |           
  1257: |+----->          do j = js, je
  1258: ||V---->            do i = 0, imax-1
  1259: |||         
  1260: |||                   l = 2 * k     ! equation number
  1261: |||                   !
  1262: |||     A             aa_TridiagMtx1( i+imax*(j-1)+1, l ) =                                       &
  1263: |||                     &   xyaz_smalle(i,j,1,k  ) * xyaz_smalle(i,j,2,k+1)                       &
  1264: |||                     & - xyaz_smalle(i,j,3,k  ) * xyaz_smalle(i,j,4,k+1)
  1265: |||     A             aa_TridiagMtx2( i+imax*(j-1)+1, l ) =                                       &
  1266: |||     A               &   xyaz_smalle(i,j,2,k  ) * xyaz_smalle(i,j,2,k+1)                       &
  1267: |||     A               & - xyaz_smalle(i,j,4,k  ) * xyaz_smalle(i,j,4,k+1)
  1268: |||     A             aa_TridiagMtx3( i+imax*(j-1)+1, l ) =                                       &
  1269: |||                     &   xyaz_smalle(i,j,1,k+1) * xyaz_smalle(i,j,4,k+1)                       &
  1270: |||                     & - xyaz_smalle(i,j,2,k+1) * xyaz_smalle(i,j,3,k+1)
  1271: |||     A             aa_Vec        ( i+imax*(j-1)+1, l ) =                                       &
  1272: |||                     &   xyaz_smalle(i,j,2,k+1) * ( - xyz_CDoT(i,j,k  ) + xyz_CDoB(i,j,k+1) )  &
  1273: |||                     & - xyaz_smalle(i,j,4,k+1) * ( - xyz_CUpT(i,j,k  ) + xyz_CUpB(i,j,k+1) )
  1274: |||         
  1275: |||                   l = 2 * k + 1 ! equation number
  1276: |||                   !
  1277: |||     A             aa_TridiagMtx1( i+imax*(j-1)+1, l ) =                                       &
  1278: |||                     &   xyaz_smalle(i,j,2,k  ) * xyaz_smalle(i,j,3,k  )                       &
  1279: |||                     & - xyaz_smalle(i,j,1,k  ) * xyaz_smalle(i,j,4,k  )
  1280: |||     A             aa_TridiagMtx2( i+imax*(j-1)+1, l ) =                                       &
  1281: |||                     &   xyaz_smalle(i,j,1,k  ) * xyaz_smalle(i,j,1,k+1)                       &
  1282: |||                     & - xyaz_smalle(i,j,3,k  ) * xyaz_smalle(i,j,3,k+1)
  1283: |||     A             aa_TridiagMtx3( i+imax*(j-1)+1, l ) =                                       &
  1284: |||                     &   xyaz_smalle(i,j,3,k  ) * xyaz_smalle(i,j,4,k+1)                       &
  1285: |||                     & - xyaz_smalle(i,j,1,k  ) * xyaz_smalle(i,j,2,k+1)
  1286: |||     A             aa_Vec        ( i+imax*(j-1)+1, l ) =                                       &
  1287: |||                     &   xyaz_smalle(i,j,3,k  ) * ( - xyz_CDoT(i,j,k  ) + xyz_CDoB(i,j,k+1) )  &
  1288: |||                     & - xyaz_smalle(i,j,1,k  ) * ( - xyz_CUpT(i,j,k  ) + xyz_CUpB(i,j,k+1) )
  1289: ||V----             end do
  1290: |+-----           end do
  1291: +------         end do
  1292:             
  1293:             
  1294:                 k = kmax
  1295:                 l = 2 * kmax
  1296: +------>        do j = js, je
  1297: |V----->          do i = 0, imax-1
  1298: ||      A           aa_TridiagMtx1( i+imax*(j-1)+1, l ) =  xyaz_smalle(i,j,1,k)
  1299: ||      A           aa_TridiagMtx2( i+imax*(j-1)+1, l ) =  xyaz_smalle(i,j,2,k)
  1300: ||      A           aa_TridiagMtx3( i+imax*(j-1)+1, l ) = 0.0d0
  1301: ||      A           aa_Vec        ( i+imax*(j-1)+1, l ) = -xyz_CDoT(i,j,k) + 0.0d0
  1302: |V-----           end do
  1303: +------         end do
  1304:             
  1305:                 ms = 0      + imax*(js-1)+1
  1306:                 me = imax-1 + imax*(je-1)+1
  1307:                 call tridiag( imax*jmax, 2*kmax, aa_TridiagMtx1, aa_TridiagMtx2, aa_TridiagMtx3, aa_Vec, ms, me )
  1308:             
  1309:                 if ( .not. FlagSrcFuncTech ) then
  1310:             
  1311:                   k = 1
  1312: +------>          do j = js, je
  1313: |V----->            do i = 0, imax-1
  1314: ||      A             xyr_RadUwFlux(i,j,k-1) =                                    &
  1315: ||                      &   aa_Vec( i+imax*(j-1)+1, 2*k-1) * xyaz_smalle(i,j,1,k) &
  1316: ||                      & - aa_Vec( i+imax*(j-1)+1, 2*k  ) * xyaz_smalle(i,j,2,k) &
  1317: ||                      & + xyz_CUpB(i,j,k)
  1318: ||      A             xyr_RadDwFlux(i,j,k-1) =                                    &
  1319: ||                      &   aa_Vec( i+imax*(j-1)+1, 2*k-1) * xyaz_smalle(i,j,3,k) &
  1320: ||                      & - aa_Vec( i+imax*(j-1)+1, 2*k  ) * xyaz_smalle(i,j,4,k) &
  1321: ||                      & + xyz_CDoB(i,j,k)
  1322: |V-----             end do
  1323: +------           end do
  1324:             
  1325: +------>          do k = 1, kmax
  1326: |+----->            do j = js, je
  1327: ||V---->              do i = 0, imax-1
  1328: |||     A               xyr_RadUwFlux(i,j,k) =                                      &
  1329: |||                       &   aa_Vec( i+imax*(j-1)+1, 2*k-1) * xyaz_smalle(i,j,3,k) &
  1330: |||                       & + aa_Vec( i+imax*(j-1)+1, 2*k  ) * xyaz_smalle(i,j,4,k) &
  1331: |||                       & + xyz_CUpT(i,j,k)
  1332: |||     A               xyr_RadDwFlux(i,j,k) =                                      &
  1333: |||                       &   aa_Vec( i+imax*(j-1)+1, 2*k-1) * xyaz_smalle(i,j,1,k) &
  1334: |||                       & + aa_Vec( i+imax*(j-1)+1, 2*k  ) * xyaz_smalle(i,j,2,k) &
  1335: |||                       & + xyz_CDoT(i,j,k)
  1336: ||V----               end do
  1337: |+-----             end do
  1338: +------           end do
  1339:             
  1340:             
  1341:             
  1342:             
  1343:             
  1344:                     ! Code for debug
  1345:                     !
  1346:             !!$        do k = 1, kmax
  1347:             !!$          do j = js, je
  1348:             !!$            do i = 0, imax-1
  1349:             !!$              xyr_UwFluxDebug(i,j,k-1) =                                         &
  1350:             !!$                &   aa_Vec( i+imax*(j-1)+1, 2*k-1) * xyaz_smalle(i,j,1,k) &
  1351:             !!$                & - aa_Vec( i+imax*(j-1)+1, 2*k  ) * xyaz_smalle(i,j,2,k) &
  1352:             !!$                & + xyz_CUpB(i,j,k)
  1353:             !!$              xyr_DwFluxDebug(i,j,k-1) =                                         &
  1354:             !!$                &   aa_Vec( i+imax*(j-1)+1, 2*k-1) * xyaz_smalle(i,j,3,k) &
  1355:             !!$                & - aa_Vec( i+imax*(j-1)+1, 2*k  ) * xyaz_smalle(i,j,4,k) &
  1356:             !!$                & + xyz_CDoB(i,j,k)
  1357:             !!$            end do
  1358:             !!$          end do
  1359:             !!$        end do
  1360:             !!$
  1361:             !!$        k = kmax
  1362:             !!$        do j = js, je
  1363:             !!$          do i = 0, imax-1
  1364:             !!$            xyr_UwFluxDebug(i,j,k) =                                       &
  1365:             !!$              &   aa_Vec( i+imax*(j-1)+1, 2*k-1) * xyaz_smalle(i,j,3,k) &
  1366:             !!$              & + aa_Vec( i+imax*(j-1)+1, 2*k  ) * xyaz_smalle(i,j,4,k) &
  1367:             !!$              & + xyz_CUpT(i,j,k)
  1368:             !!$            xyr_DwFluxDebug(i,j,k) =                                       &
  1369:             !!$              &   aa_Vec( i+imax*(j-1)+1, 2*k-1) * xyaz_smalle(i,j,1,k) &
  1370:             !!$              & + aa_Vec( i+imax*(j-1)+1, 2*k  ) * xyaz_smalle(i,j,2,k) &
  1371:             !!$              & + xyz_CDoT(i,j,k)
  1372:             !!$          end do
  1373:             !!$        end do
  1374:             !!$
  1375:             !!$
  1376:             !!$        i = imax/2
  1377:             !!$        j = jmax/2
  1378:             !!$        do k = kmax, 0, -1
  1379:             !!$          write( 6, * ) k, xyr_UwFlux(i,j,k), xyr_UwFluxDebug(i,j,k), xyr_UwFlux(i,j,k) - xyr_UwFluxDebug(i,j,k)
  1380:             !!$        end do
  1381:             !!$        do k = kmax, 0, -1
  1382:             !!$          write( 6, * ) k, xyr_DwFlux(i,j,k), xyr_DwFluxDebug(i,j,k), xyr_DwFlux(i,j,k) - xyr_DwFluxDebug(i,j,k)
  1383:             !!$        end do
  1384:             !!$        k = 0
  1385:             !!$        write( 6, * ) k, xyr_UwFlux(i,j,k), xy_SurfAlbedo(i,j) * xyr_DwFlux(i,j,k) + xy_SurfAlbedo(i,j) * SolarFluxTOA * xyr_TransDirAdj(i,j,0) * xy_cosSZA(i,j), &
  1386:             !!$          xyr_UwFlux(i,j,k) - ( xy_SurfAlbedo(i,j) * xyr_DwFlux(i,j,k) + xy_SurfAlbedo(i,j) * SolarFluxTOA * xyr_TransDirAdj(i,j,0) * xy_cosSZA(i,j) )
  1387:             !!$        stop
  1388:             
  1389:             
  1390:                 else
  1391:             
  1392:                   ! Source function technique described by Toon et al. [1989] 
  1393:                   ! is used to calculated infrared heating rate. 
  1394:                   !
  1395: +------>          do k = 0, kmax
  1396: |W----->            do j = js, je
  1397: ||*---->A             xyr_RadUwFlux(:,j,k) = 0.0_DP
  1398: |||     A             xyr_RadDwFlux(:,j,k) = 0.0_DP
  1399: |||                 end do
  1400: |||               end do
  1401: |||         
  1402: |||               do k = 0, kmax
  1403: |||                 do j = js, je
  1404: |||                   xyra_DelRadUwFlux(:,j,k,0) = 0.0_DP
  1405: |||                   xyra_DelRadUwFlux(:,j,k,1) = 0.0_DP
  1406: |||                   xyra_DelRadDwFlux(:,j,k,0) = 0.0_DP
  1407: ||*----               xyra_DelRadDwFlux(:,j,k,1) = 0.0_DP
  1408: |W-----             end do
  1409: +------           end do
  1410:             
  1411: +------>          do l = 1, NGaussQuad
  1412: |                   Mu = a_GQP( l )
  1413: |           
  1414: |                   k = kmax
  1415: |W----->            do j = js, je
  1416: ||*====               xyr_IDw(:,j,k) = 0.0_DP
  1417: |W-----             end do
  1418: |+----->            do k = kmax, 1, -1
  1419: ||+---->              do j = js, je
  1420: |||V--->                do i = 0, imax-1
  1421: ||||    A                 FactJ = &
  1422: ||||                        & ( aa_Vec( i+imax*(j-1)+1, 2*k-1 ) + aa_Vec( i+imax*(j-1)+1, 2*k ) ) &
  1423: ||||                        &   * xyz_LGamma(i,j,k) * ( xyz_Lambda(i,j,k) + 1.0_DP / xyz_Mu1(i,j,k) )
  1424: ||||                      FactK = &
  1425: ||||                        & ( aa_Vec( i+imax*(j-1)+1, 2*k-1 ) - aa_Vec( i+imax*(j-1)+1, 2*k ) ) &
  1426: ||||                        &   * ( 1.0_DP / xyz_Mu1(i,j,k) - xyz_Lambda(i,j,k) )
  1427: ||||    A                 Sig1  = &
  1428: ||||                        & 2.0_DP * (   xyz_B0(i,j,k) &
  1429: ||||                        &            - xyz_B1(i,j,k) * ( 1.0_DP / ( xyz_Gam1(i,j,k) + xyz_Gam2(i,j,k) ) - xyz_Mu1(i,j,k) ) )
  1430: ||||                      Sig2  = &
  1431: ||||                        & 2.0_DP * xyz_B1(i,j,k)
  1432: ||||    A                 xyr_IDw(i,j,k-1) = xyr_IDw(i,j,k) * exp( - xyz_DelTau(i,j,k) / Mu )           &
  1433: ||||                        & + FactJ / ( xyz_Lambda(i,j,k) * Mu + 1.0_DP )                             &
  1434: ||||                        &   * (   1.0_DP                                                            &
  1435: ||||                        &       - exp( - xyz_DelTau(i,j,k) * ( xyz_Lambda(i,j,k) + 1.0d0 / Mu ) ) ) &
  1436: ||||                        & + FactK / ( xyz_Lambda(i,j,k) * Mu - 1.0_DP )                             &
  1437: ||||                        &   * (   exp( - xyz_DelTau(i,j,k) / Mu )                                   &
  1438: ||||                        &       - exp( - xyz_DelTau(i,j,k) * xyz_Lambda(i,j,k) ) )                  &
  1439: ||||                        & + Sig1 * ( 1.0_DP - exp( - xyz_DelTau(i,j,k) / Mu ) )                     &
  1440: ||||                        & + Sig2 * ( Mu * exp( - xyz_DelTau(i,j,k) / Mu ) + xyz_DelTau(i,j,k) - Mu )
  1441: |||V---                 end do
  1442: ||+----               end do
  1443: |+-----             end do
  1444: |           
  1445: |                   k = 0
  1446: |W----->            do j = js, je
  1447: ||          !               gemis = 1.0d0
  1448: ||          !!$          gemis = emis( ij, 1 )
  1449: ||          !!$          inteup( ij, 1, k ) = ( 1.0d0 - gemis ) * intedo( ij, 1, km+1 ) &
  1450: ||          !!$                    + gemis * pix2 * pfinth( ij, 1, km+1 )
  1451: ||*==== A             xyr_IUw(:,j,k) = xy_SurfAlbedo(:,j) * xyr_IDw(:,j,0) + 2.0_DP * xy_SurfPFInted(:,j)
  1452: |W-----             end do
  1453: |+----->            do k = 1, kmax
  1454: ||+---->              do j = js, je
  1455: |||V--->                do i = 0, imax-1
  1456: ||||    A                 FactG = &
  1457: ||||                        & ( aa_Vec( i+imax*(j-1)+1, 2*k-1 ) + aa_Vec( i+imax*(j-1)+1, 2*k ) ) &
  1458: ||||                        &   * ( 1.0_DP / xyz_Mu1(i,j,k) - xyz_Lambda(i,j,k) )
  1459: ||||    A                 FactH = &
  1460: ||||                        & ( aa_Vec( i+imax*(j-1)+1, 2*k-1 ) - aa_Vec( i+imax*(j-1)+1, 2*k ) ) &
  1461: ||||                        &   * xyz_LGamma(i,j,k) * ( xyz_Lambda(i,j,k) + 1.0_DP / xyz_Mu1(i,j,k) )
  1462: ||||    A                 Alp1  = &
  1463: ||||                        & 2.0_DP * (   xyz_B0(i,j,k) &
  1464: ||||                        &            + xyz_B1(i,j,k) * ( 1.0_DP / ( xyz_Gam1(i,j,k) + xyz_Gam2(i,j,k) ) - xyz_Mu1(i,j,k) ) )
  1465: ||||                      Alp2  = &
  1466: ||||                        & 2.0_DP * xyz_B1(i,j,k)
  1467: ||||    A                 xyr_IUw(i,j,k) = xyr_IUw(i,j,k-1) * exp( - xyz_DelTau(i,j,k) / Mu )           &
  1468: ||||                        & + FactG / ( xyz_Lambda(i,j,k) * Mu - 1.0_DP )                             &
  1469: ||||                        &   * (   exp( - xyz_DelTau(i,j,k) / Mu )                                   &
  1470: ||||                        &       - exp( - xyz_DelTau(i,j,k) * xyz_Lambda(i,j,k) ) )                  &
  1471: ||||                        & + FactH / ( xyz_Lambda(i,j,k) * Mu + 1.0_DP )                             &
  1472: ||||                        &   * (   1.0_DP                                                            &
  1473: ||||                        &       - exp( - xyz_DelTau(i,j,k) * ( xyz_Lambda(i,j,k) + 1.0d0 / Mu ) ) ) &
  1474: ||||                        & + Alp1 * ( 1.0_DP - exp( - xyz_DelTau(i,j,k) / Mu ) )                     &
  1475: ||||                        & + Alp2 * ( Mu - ( xyz_DelTau(i,j,k) + Mu ) * exp( - xyz_Deltau(i,j,k) / Mu ) )
  1476: |||V---                 end do
  1477: ||+----               end do
  1478: |+-----             end do
  1479: |           
  1480: |+----->            do k = 0, kmax
  1481: ||W---->              do j = js, je
  1482: |||*--->A               xyr_RadUwFlux(:,j,k) = xyr_RadUwFlux(:,j,k) + Mu * xyr_IUw(:,j,k) * a_GQW( l )
  1483: |||*--- A               xyr_RadDwFlux(:,j,k) = xyr_RadDwFlux(:,j,k) + Mu * xyr_IDw(:,j,k) * a_GQW( l )
  1484: ||W----               end do
  1485: |+-----             end do
  1486: |           
  1487: |+----->            do k = 0, kmax
  1488: ||W---->              do j = js, je
  1489: |||*=== A               xyra_DelRadUwFlux(:,j,k,0) = xyra_DelRadUwFlux(:,j,k,0)             &
  1490: |||                       & + Mu * 2.0_DP * xy_SurfDPFDTInted(:,j)                          &
  1491: |||                       &   * exp( - ( xyr_OpDepAdj(:,j,0) - xyr_OpDepAdj(:,j,k) ) / Mu ) &
  1492: |||                       &   * a_GQW( l )
  1493: ||W----               end do
  1494: |+-----             end do
  1495: |           
  1496: +------           end do ! do l = 1, NGaussQuad
  1497:             
  1498:                 end if
  1499:             
  1500:             
  1501:                 if ( FlagTOAFlux ) then
  1502:                   !
  1503:                   ! Addition of Direct Solar Insident
  1504:                   !
  1505: +------>          do k = 0, kmax
  1506: |W----->            do j = js, je
  1507: ||*==== A             xyr_RadDwFlux(:,j,k) = xyr_RadDwFlux(:,j,k) &
  1508: ||                      & + xy_SolarFluxTOA(:,j) * xyr_TransDirAdj(:,j,k) * xy_cosSZA(:,j)
  1509: |W-----             end do
  1510: +------           end do
  1511:             
  1512:                 end if
  1513:             
  1514:             
  1515:               end subroutine RadRTETwoStreamAppCore
  1516:             
  1517:               !--------------------------------------------------------------------------------------
  1518:             
  1519:               !******************************************************************************
  1520:               !      subroutine tridiag
  1521:               !      tidiagonal solver
  1522:               !******************************************************************************
  1523:               !     a(j), b(j), and c(j) are, respectively, the subdiagonal, diagonal, 
  1524:               !     and superdiagonal entries in row j. 
  1525:               !     a(1) and c(jmx) need not be initialized. 
  1526:               !     The output is in f; a, b, and c are unchanged. 
  1527:               !******************************************************************************
  1528:               !     jmx    : dimensions of all the following arrays
  1529:               !     a      : sub (lower) diagonal
  1530:               !     b      : center diagonal
  1531:               !     c      : super (upper) diagonal
  1532:               !     f      : right hand side
  1533:               !******************************************************************************
  1534:             
  1535:               subroutine tridiag( mm, jmx, a, b, c, f, ms, me )
  1536:             
  1537:                 integer , intent(in   ) :: mm, jmx
  1538:                 real(DP), intent(in   ) :: a( mm, jmx ),b( mm, jmx )
  1539:                 real(DP), intent(in   ) :: c( mm, jmx )
  1540:                 real(DP), intent(inout) :: f( mm, jmx )
  1541:                 integer , intent(in   ) :: ms, me
  1542:             
  1543:             
  1544:                 ! Local variables
  1545:                 !
  1546:                 real(DP) :: q( mm, jmx ), p
  1547:                 integer  :: j, m
  1548:             
  1549:             
  1550:                 ! Forward elimination sweep
  1551:                 !
  1552: V------>        do m = ms, me
  1553: |       A         q( m, 1 ) = - c( m, 1 ) / b( m, 1 )
  1554: |       A         f( m, 1 ) =   f( m, 1 ) / b( m, 1 )
  1555: V------         end do
  1556:             
  1557: +------>        do j = 2, jmx
  1558: |V----->          do m = ms, me
  1559: ||      A           p         = 1.0d0 / ( b( m, j ) + a( m, j ) * q( m, j-1 ) )
  1560: ||      A           q( m, j ) = - c( m, j ) * p
  1561: ||      A           f( m, j ) = ( f( m, j ) - a( m, j ) * f( m, j-1 ) ) * p
  1562: |V-----           end do
  1563: +------         end do
  1564:             
  1565:                 ! Backward pass
  1566:                 !
  1567: +------>        do j = jmx - 1, 1, -1
  1568: |V----->          do m = ms, me
  1569: ||      A           f( m, j ) = f( m, j ) + q( m, j ) * f( m, j+1 )
  1570: |V-----           end do
  1571: +------         end do
  1572:             
  1573:               end subroutine tridiag
  1574:             
  1575:               !--------------------------------------------------------------------------------------
  1576:             
  1577:               subroutine tridiag1( jmx, a, b, c, f )
  1578:             
  1579:                 integer , intent(in   ) :: jmx
  1580:                 real(DP), intent(in   ) :: a(jmx),b(jmx)
  1581:                 real(DP), intent(in   ) :: c(jmx)
  1582:                 real(DP), intent(inout) :: f(jmx)
  1583:             
  1584:             
  1585:                 ! Local variables
  1586:                 !
  1587:                 real(DP) :: q(jmx), p
  1588:                 integer  :: j
  1589:             
  1590:             
  1591:                 ! Forward elimination sweep
  1592:                 !
  1593:                 q( 1 ) = - c( 1 ) / b( 1 )
  1594:                 f( 1 ) =   f( 1 ) / b( 1 )
  1595:             
  1596: +------>        do j = 2, jmx
  1597: |                 p      = 1.0d0 / ( b( j ) + a( j ) * q( j-1 ) )
  1598: |                 q( j ) = - c( j ) * p
  1599: |                 f( j ) = ( f( j ) - a( j ) * f( j-1 ) ) * p
  1600: +------         end do
  1601:             
  1602:                 ! Backward pass
  1603:                 !
  1604: V------>        do j = jmx - 1, 1, -1
  1605: |       A         f( j ) = f( j ) + q( j ) * f( j+1 )
  1606: V------         end do
  1607:             
  1608:               end subroutine tridiag1
  1609:             
  1610:               !----------------------------------------------------------------------------
  1611:             
  1612:               subroutine RadRTETwoStreamAppInit
  1613:             
  1614:             !!$    ! ファイル入出力補助
  1615:             !!$    ! File I/O support
  1616:             !!$    !
  1617:             !!$    use dc_iounit, only: FileOpen
  1618:             !!$
  1619:             !!$    ! NAMELIST ファイル入力に関するユーティリティ
  1620:             !!$    ! Utilities for NAMELIST file input
  1621:             !!$    !
  1622:             !!$    use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid
  1623:             
  1624:                 ! ガウス重み, 分点の計算
  1625:                 ! Calculate Gauss node and Gaussian weight
  1626:                 !
  1627:                 use gauss_quad, only : GauLeg
  1628:             
  1629:             
  1630:                 ! 宣言文 ; Declaration statements
  1631:                 !
  1632:             
  1633:             !!$    integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号.
  1634:             !!$                              ! Unit number for NAMELIST file open
  1635:             !!$    integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT.
  1636:             !!$                              ! IOSTAT of NAMELIST read
  1637:             
  1638:                 ! NAMELIST 変数群
  1639:                 ! NAMELIST group name
  1640:                 !
  1641:             !!$    namelist /rad_rte_two_stream_app_nml/ &
  1642:             !!$      & NGaussQuad
  1643:                       !
  1644:                       ! デフォルト値については初期化手続 "rad_rte_two_stream_app#RadRTETwoStreamAppInit"
  1645:                       ! のソースコードを参照のこと.
  1646:                       !
  1647:                       ! Refer to source codes in the initialization procedure
  1648:                       ! "rad_rte_two_stream_app#RadRTETwoStreamAppInit" for the default values.
  1649:                       !
  1650:             
  1651:                 if ( rad_rte_two_stream_app_inited ) return
  1652:             
  1653:             
  1654:                 ! デフォルト値の設定
  1655:                 ! Default values settings
  1656:                 !
  1657:             !!$    NGaussQuad = 8
  1658:             
  1659:             
  1660:                 ! NAMELIST の読み込み
  1661:                 ! NAMELIST is input
  1662:                 !
  1663:             !!$    if ( trim(namelist_filename) /= '' ) then
  1664:             !!$      call FileOpen( unit_nml, &          ! (out)
  1665:             !!$        & namelist_filename, mode = 'r' ) ! (in)
  1666:             !!$
  1667:             !!$      rewind( unit_nml )
  1668:             !!$      read( unit_nml,                          & ! (in)
  1669:             !!$        & nml = rad_rte_two_stream_app_nml,    & ! (out)
  1670:             !!$        & iostat = iostat_nml )                  ! (out)
  1671:             !!$      close( unit_nml )
  1672:             !!$
  1673:             !!$      call NmlutilMsg( iostat_nml, module_name ) ! (in)
  1674:             !!$    end if
  1675:             
  1676:             
  1677:             !!$    allocate( a_GQP(1:NGaussQuad) )
  1678:             !!$    allocate( a_GQW(1:NGaussQuad) )
  1679:             
  1680:                 call GauLeg( &
  1681:                   & 0.0_DP, 1.0_DP, NGaussQuad, & ! (in )
  1682:                   & a_GQP, a_GQW                & ! (out)
  1683:                   & )
  1684:             
  1685:             
  1686:                 ! Initialization of modules used in this module
  1687:                 !
  1688:             
  1689:             
  1690:                 ! 印字 ; Print
  1691:                 !
  1692:                 call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
  1693:             !!$    call MessageNotify( 'M', module_name, 'NGaussQuad = %d', i = (/ NGaussQuad /) )
  1694:                 call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
  1695:             
  1696:             
  1697:                 rad_rte_two_stream_app_inited = .true.
  1698:             
  1699:             
  1700:               end subroutine RadRTETwoStreamAppInit
  1701:             
  1702:               !----------------------------------------------------------------------------
  1703:             
  1704:             !******************************************************************************
  1705:             !!$
  1706:             !!$    subroutine twostreamapp_vis( cossza, gph, q, gdf, &
  1707:             !!$         dod067, qerat, ssa, af, sf, albedo, &
  1708:             !!$         gor, goru, gord, gsr, gsru, gsrd, &
  1709:             !!$         ijs, ije )
  1710:             !!$
  1711:             !!$      use matype
  1712:             !!$      use maparam, only : im => imax, jm => jmax, km => kmax
  1713:             !!$
  1714:             !!$      real(dp)    , intent(in ) :: cossza( ijs:ije, 1 )
  1715:             !!$      real(dp)    , intent(in ) :: gph   ( im, jm, km+1 )
  1716:             !!$      real(dp)    , intent(out) :: q     ( im, jm, km   )
  1717:             !!$      real(dp)    , intent(out) :: gdf   ( im, jm )
  1718:             !!$      real(dp)    , intent(in ) :: dod067( im, jm, km+1 )
  1719:             !!$      real(dp)    , intent(in ) :: qerat, ssa, af
  1720:             !!$      real(dp)    , intent(in ) :: sf
  1721:             !!$      real(dp)    , intent(in ) :: albedo( im, jm )
  1722:             !!$
  1723:             !!$      real(dp)    , intent(out) :: &
  1724:             !!$           gor ( im, jm ), goru ( im, jm ), gord ( im, jm ), &
  1725:             !!$           gsr ( im, jm ), gsru ( im, jm ), gsrd ( im, jm )
  1726:             !!$
  1727:             !!$      integer(i4b), intent(in ) :: ijs, ije
  1728:             !!$
  1729:             !!$
  1730:             !!$      !
  1731:             !!$      ! local variables
  1732:             !!$      !
  1733:             !!$      real(dp)     :: gt  ( im, jm, km )
  1734:             !!$      real(dp)     :: gts ( im, jm )
  1735:             !!$      real(dp)     :: emis( im, jm )
  1736:             !!$      real(dp)     :: wn1 = 1.0d100, wn2 = 1.0d100
  1737:             !!$      integer(i4b) :: divnum = 3
  1738:             !!$      integer(i4b) :: sw = 1
  1739:             !!$
  1740:             !!$      integer(i4b) :: ij, k
  1741:             !!$
  1742:             !!$
  1743:             !!$      do k = 1, km
  1744:             !!$         do ij = ijs, ije
  1745:             !!$            gt  ( ij, 1, k ) = 1.0d100
  1746:             !!$         end do
  1747:             !!$      end do
  1748:             !!$      do ij = ijs, ije
  1749:             !!$         gts ( ij, 1 ) = 1.0d100
  1750:             !!$         emis( ij, 1 ) = 1.0d100
  1751:             !!$      end do
  1752:             !!$
  1753:             !!$      call twostreamapp( cossza, gt, gts, gph, q, gdf, &
  1754:             !!$           dod067, qerat, ssa, af, sf, albedo, emis, wn1, wn2, divnum, sw, &
  1755:             !!$           gor, goru, gord, gsr, gsru, gsrd, &
  1756:             !!$           ijs, ije )
  1757:             !!$
  1758:             !!$
  1759:             !!$    end subroutine twostreamapp_vis
  1760:             !!$
  1761:             !!$!******************************************************************************
  1762:             !!$
  1763:             !!$    subroutine twostreamapp_ir( gt, gts, gph, q, gdf, &
  1764:             !!$         dod067, qerat, ssa, af, emis, wn1, wn2, divnum, &
  1765:             !!$         gor, goru, gord, gsr, gsru, gsrd, &
  1766:             !!$         ijs, ije )
  1767:             !!$
  1768:             !!$      use matype
  1769:             !!$      use maparam, only : im => imax, jm => jmax, km => kmax
  1770:             !!$
  1771:             !!$      implicit none
  1772:             !!$
  1773:             !!$      real(dp)    , intent(in ) :: gt    ( im, jm, km   )
  1774:             !!$      real(dp)    , intent(in ) :: gts   ( im, jm )
  1775:             !!$      real(dp)    , intent(in ) :: gph   ( im, jm, km+1 )
  1776:             !!$      real(dp)    , intent(out) :: q     ( im, jm,   km )
  1777:             !!$      real(dp)    , intent(out) :: gdf   ( im, jm )
  1778:             !!$      real(dp)    , intent(in ) :: dod067( im, jm, km+1 )
  1779:             !!$      real(dp)    , intent(in ) :: qerat, ssa, af
  1780:             !!$      real(dp)    , intent(in ) :: emis  ( im, jm )
  1781:             !!$      real(dp)    , intent(in ) :: wn1, wn2
  1782:             !!$      integer(i4b), intent(in ) :: divnum
  1783:             !!$
  1784:             !!$      real(dp)    , intent(out) :: &
  1785:             !!$           gor ( im, jm ), goru ( im, jm ), gord ( im, jm ), &
  1786:             !!$           gsr ( im, jm ), gsru ( im, jm ), gsrd ( im, jm )
  1787:             !!$
  1788:             !!$      integer(i4b), intent(in ) :: ijs, ije
  1789:             !!$
  1790:             !!$
  1791:             !!$      !
  1792:             !!$      ! local variables
  1793:             !!$      !
  1794:             !!$      real(dp)     :: cossza( ijs:ije, 1 )
  1795:             !!$      real(dp)     :: sf    = 1.0d100
  1796:             !!$      real(dp)     :: albedo( im, jm )
  1797:             !!$      integer(i4b) :: sw = 2
  1798:             !!$
  1799:             !!$      integer(i4b) :: ij
  1800:             !!$
  1801:             !!$
  1802:             !!$      do ij = ijs, ije
  1803:             !!$         albedo( ij, 1 ) = 1.0d0 - emis( ij, 1 )
  1804:             !!$         cossza( ij, 1 ) = 1.0d100
  1805:             !!$      end do
  1806:             !!$
  1807:             !!$      call twostreamapp( cossza, gt, gts, gph, q, gdf, &
  1808:             !!$           dod067, qerat, ssa, af, sf, albedo, emis, wn1, wn2, divnum, sw, &
  1809:             !!$           gor, goru, gord, gsr, gsru, gsrd, &
  1810:             !!$           ijs, ije )
  1811:             !!$
  1812:             !!$
  1813:             !!$    end subroutine twostreamapp_ir
  1814:             
  1815:             end module rad_rte_two_stream_app
