Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:45 2016
FILE NAME: rad_short_income.f90
PROGRAM NAME: rad_short_income
DIAGNOSTIC LIST

  LINE  LEVEL( NO.): DIAGNOSTIC MESSAGE

   318  opt  (1592): Outer loop unrolled inside inner loop.
   319  opt  (1395): Inner loop stripped and strip loop moved outside outer loop.
   319  vec  (   1): Vectorized loop.
   319  vec  (  29): ADB is used for array.: d1
   319  vec  (  29): ADB is used for array.: y_lat
   319  vec  (   1): Vectorized loop.
   319  vec  (  29): ADB is used for array.: xy_inanglelv
   319  vec  (  29): ADB is used for array.: xy_coszetlv
   319  vec  (  29): ADB is used for array.: d1
   319  vec  (   1): Vectorized loop.
   319  vec  (  29): ADB is used for array.: xy_inanglelv
   319  vec  (  29): ADB is used for array.: xy_coszetlv
   319  vec  (  29): ADB is used for array.: d1
   377  opt  (1395): Inner loop stripped and strip loop moved outside outer loop.
   377  vec  (   1): Vectorized loop.
   377  vec  (  29): ADB is used for array.: d8
   377  vec  (  29): ADB is used for array.: d9
   377  vec  (  29): ADB is used for array.: d10
   377  vec  (  29): ADB is used for array.: y_lat
   377  vec  (   1): Vectorized loop.
   377  vec  (  29): ADB is used for array.: xy_inanglelv
   377  vec  (  29): ADB is used for array.: xy_coszetlv
   377  vec  (  29): ADB is used for array.: d10
   377  vec  (  29): ADB is used for array.: d9
   377  vec  (  29): ADB is used for array.: d8
   420  vec  (   1): Vectorized loop.
   420  vec  (  29): ADB is used for array.: xy_inanglelv
   420  vec  (  29): ADB is used for array.: xy_coszetlv
   420  vec  (  29): ADB is used for array.: y_lat
   439  opt  (1593): Loop nest collapsed into one loop.
   439  vec  (   4): Vectorized array expression.
   439  vec  (  29): ADB is used for array.: xy_inangle
   442  opt  (1593): Loop nest collapsed into one loop.
   442  vec  (   4): Vectorized array expression.
   442  vec  (  29): ADB is used for array.: xy_coszet
   550  vec  (   4): Vectorized array expression.
   550  vec  (  26): Macro operation Sum/InnerProd.
   550  vec  (  29): ADB is used for array.: day_in_month_ptr
   565  vec  (   3): Unvectorized loop.
   565  vec  (   8): Unvectorizable loop structure.
   568  opt  (1084): Branch out of the loop inhibits optimization.
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:45 2016
FILE NAME: rad_short_income.f90
PROGRAM NAME: rad_short_income
TRANSFORMATION LIST

  LINE                   FORTRAN STATEMENT

     1  != 短波入射 (太陽入射)
     2  !
     3  != Short wave (insolation) incoming
     4  !
     5  ! Authors::   Satoshi NODA, Yasuhiro MORIKAWA, Yukiko YAMADA, Yoshiyuki O. TAKAHASHI
     6  ! Version::   $Id: rad_short_income.f90,v 1.6 2013/05/25 06:33:57 yot Exp $
     7  ! Tag Name::  $Name:  $
     8  ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9  ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10  !
    11  
    12  module rad_short_income
    13    !
    14    != 短波入射 (太陽入射)
    15    !
    16    != Short wave (insolation) incoming
    17    !
    18    ! <b>Note that Japanese and English are described in parallel.</b>
    19    !
    20    ! 短波入射 (太陽入射) を計算します.
    21    !
    22    ! Calculate short wave (insolation) incoming radiation.
    23    !
    24    !== Procedures List
    25    !
    26    ! ShortIncoming      :: 短波入射 (太陽入射) の計算
    27    ! ------------       :: ------------
    28    ! ShortIncoming      :: Calculate short wave (insolation) incoming radiation.
    29    !
    30    !== NAMELIST
    31    !
    32    ! NAMELIST#rad_short_income_nml
    33    !
    34  
    35    ! モジュール引用 ; USE statements
    36    !
    37  
    38    ! 種別型パラメタ
    39    ! Kind type parameter
    40    !
    41    use dc_types, only: DP, &      ! 倍精度実数型. Double precision.
    42      &                 STRING, &  ! 文字列.       Strings.
    43      &                 TOKEN      ! キーワード.   Keywords.
    44  
    45    ! メッセージ出力
    46    ! Message output
    47    !
    48    use dc_message, only: MessageNotify
    49  
    50    ! 物理・数学定数設定
    51    ! Physical and mathematical constants settings
    52    !
    53    use constants0, only: &
    54      & PI                    ! $ \pi $.
    55                              ! 円周率. Circular constant
    56  
    57    ! 格子点設定
    58    ! Grid points settings
    59    !
    60    use gridset, only: imax, & ! 経度格子点数.
    61                               ! Number of grid points in longitude
    62      &                jmax, & ! 緯度格子点数.
    63                               ! Number of grid points in latitude
    64      &                kmax    ! 鉛直層数.
    65                               ! Number of vertical level
    66  
    67    ! 時刻管理
    68    ! Time control
    69    !
    70    use timeset, only: &
    71      & TimeN,                & !
    72      & InitialDate             ! 計算開始日時.
    73                                ! Start date of calculation
    74  
    75    ! 座標データ設定
    76    ! Axes data settings
    77    !
    78    use axesset, only: &
    79      & y_Lat,   & ! $ \varphi $ [rad.] . 緯度. Latitude
    80      & x_Lon      ! $ \lambda $ [rad.] . 経度. Longitude
    81  
    82  
    83    ! 宣言文 ; Declaration statements
    84    !
    85    implicit none
    86    private
    87  
    88    ! 公開手続き
    89    ! Public procedure
    90    !
    91    public:: RadShortIncome
    92    public:: RadShortIncomeInit
    93  
    94    ! 公開変数
    95    ! Public variables
    96    !
    97    logical, save :: rad_short_income_inited = .false.
    98                                ! 初期設定フラグ.
    99                                ! Initialization flag.
   100  
   101  
   102    ! 非公開変数
   103    ! Private variables
   104    !
   105  
   106    logical,  save:: FlagAnnualMean
   107                                ! 年平均入射フラグ.
   108                                ! Flag for annual mean incoming radiation.
   109    logical,  save:: FlagDiurnalMean
   110                                ! 日平均入射フラグ.
   111                                ! Flag for diurnal mean incoming radiation.
   112    logical,  save:: FlagPerpetual
   113                                ! 季節変化なし入射フラグ.
   114                                ! Flag for perpetual incoming radiation.
   115  
   116    real(DP), save :: PerpSinDel
   117                                ! sine of declination angle for perpetual experiments
   118    real(DP), save :: PerpDistFromStarScld
   119                                ! distance between a planet and a central star for
   120                                ! perpetual experiment
   121    logical,  save:: FlagSpecifySolDay
   122                                !
   123                                ! Flag for specifying solar day
   124    real(DP), save :: SolDay
   125                                ! length of solar day
   126  
   127  
   128    ! NOTE:
   129    !   Distance between the central star and the planet, and the declination can be
   130    !   determined by specifying following three parameters:
   131    !     PerLonFromVE     : the longitude of the perihelion measured from the vernal
   132    !                        equinox,
   133    !     LonFromVEAtEpoch : the longitude of the planet at epoch,
   134    !     epoch            : date or time.
   135    !
   136    real(DP), save:: PerLonFromVE
   137                                ! 春分から測った近日点の経度 (近日点黄経) (degree)
   138                                ! Longitude of the perihelion from vernal equinox (degree)
   139    real(DP), save:: LonFromVEAtEpoch
   140                                ! 元期における惑星の経度 (黄経) (degree)
   141                                ! Longitude of the planet at epoch (degree)
   142    real(DP), save:: TimeAtEpoch
   143                                ! 元期における時刻 (sec)
   144                                ! Time at epoch (sec)
   145  
   146    real(DP), save:: EpsOrb
   147                                ! 赤道傾斜角.
   148                                ! Inclination of equator to orbit.
   149    real(DP), save:: Eccentricity
   150                                ! 離心率.
   151                                ! Eccentricity.
   152  
   153    integer,  save:: MaxItrEccAnomaly
   154                                ! 離心近点角を計算する時の最大繰り返し回数.
   155                                ! Maximum iteration number of times
   156                                ! to calculate eccentric anomaly.
   157    real(DP), save:: ThreEccAnomalyError
   158                                ! 離心近点角を計算する時の誤差の許容しきい値.
   159                                ! Threshold of error
   160                                ! to calculate eccentric anomaly.
   161  
   162    real(DP), save:: IncomAIns
   163                                ! $ A_{ins} $ . 年平均入射の係数.
   164                                ! Coefficient of annual mean incoming radiation.
   165    real(DP), save:: IncomBIns
   166                                ! $ B_{ins} $ . 年平均入射の係数. AIns に同じ.
   167                                ! Coefficient of annual mean incoming radiation.
   168                                ! Same as "AIns".
   169    real(DP), save:: IncomAZet
   170                                ! $ A_{\zeta} $ . 年平均入射角の係数. AIns に同じ.
   171                                ! Coefficient of annual mean incoming radiation.
   172                                ! Same as "AIns".
   173    real(DP), save:: IncomBZet
   174                                ! $ B_{\zeta} $ . 年平均入射角の係数. AIns に同じ.
   175                                ! Coefficient of annual mean incoming radiation.
   176                                ! Same as "AIns".
   177  
   178  
   179    real(DP), allocatable, save:: xy_InAngle (:,:)
   180                                ! sec (入射角).
   181                                ! sec (angle of incidence)
   182  
   183    logical:: FlagRadSynchronous
   184                                ! 同期回転日射のフラグ
   185                                ! Flag for synchronous rotation
   186  
   187    character(*), parameter:: module_name = 'rad_short_income'
   188                                ! モジュールの名称.
   189                                ! Module name
   190    character(*), parameter:: version = &
   191      & '$Name:  $' // &
   192      & '$Id: rad_short_income.f90,v 1.6 2013/05/25 06:33:57 yot Exp $'
   193                                ! モジュールのバージョン
   194                                ! Module version
   195  
   196  contains
   197  
   198    !--------------------------------------------------------------------------------------
   199  
   200    subroutine RadShortIncome(                    &
   201      & xy_InAngle, DistFromStarScld, xy_CosZet,  & ! (out) optional
   202      & DiurnalMeanFactor, PlanetLonFromVE,       & ! (out) optional
   203      & FlagOutput                                & ! (in)  optional
   204      & )
   205      !
   206      ! 短波入射 (太陽入射) を計算します.
   207      !
   208      ! Calculate short wave (insolation) incoming radiation.
   209      !
   210  
   211      ! モジュール引用 ; USE statements
   212      !
   213  
   214      ! 日付および時刻の取り扱い
   215      ! Date and time handler
   216      !
   217      use dc_calendar, only: DCCalInquire, DCCalDateEvalSecOfDay
   218  
   219      ! ヒストリデータ出力
   220      ! History data output
   221      !
   222      use gtool_historyauto, only: HistoryAutoPut
   223  
   224  
   225      ! 宣言文 ; Declaration statements
   226      !
   227      implicit none
   228      real(DP), intent(out), optional :: xy_InAngle (0:imax-1, 1:jmax)
   229                                ! sec ( 入射角 ).
   230                                ! sec ( Incident angle )
   231      real(DP), intent(out), optional :: DistFromStarScld
   232                                ! 軌道長半径でスケーリングした恒星からの距離
   233                                ! Distance from the star scaled
   234                                ! by semimajor axis of the planet's orbit
   235      real(DP), intent(out), optional :: xy_CosZet(0:imax-1, 1:jmax)
   236                                ! cos( 入射角 )
   237                                ! cos( Incident angle )
   238      real(DP), intent(out), optional :: DiurnalMeanFactor
   239      real(DP), intent(out), optional :: PlanetLonFromVE
   240                                ! 中心星を中心とする座標における春分点から測った惑星の経度
   241                                ! Longitude of the planet measured from the vernal equinox
   242                                ! in the coordinate that the central star is located on
   243                                ! the origin.
   244      logical , intent(in ), optional :: FlagOutput
   245  
   246  
   247      ! 作業変数
   248      ! Work variables
   249      !
   250      integer:: i                ! 経度方向に回る DO ループ用作業変数
   251                                 ! Work variables for DO loop in longitude
   252      integer:: j                ! 緯度方向に回る DO ループ用作業変数
   253                                 ! Work variables for DO loop in latitude
   254      real(DP):: SinDel          ! 赤緯
   255                                 ! Declination
   256      real(DP):: CosZet          ! 入射角
   257                                 ! Incidence angle
   258      real(DP):: AngleMaxLon     ! 入射が最大となる緯度
   259  
   260      real(DP):: HourAngle       ! 時角
   261                                 ! Hour angle
   262      real(DP):: ClockByDay      ! 時刻を日で表記したもの (0.0 - 1.0)
   263                                 ! Clock expressed by day (0.0 - 1.0)
   264  
   265  
   266      real(DP) :: xy_InAngleLV       (0:imax-1, 1:jmax)
   267                                 ! sec ( 入射角 ).
   268                                 ! sec ( Incident angle )
   269                                 ! (local variable)
   270      real(DP) :: DistFromStarScldLV
   271                                 ! Distance between the central star and the planet
   272                                 ! (local variable)
   273      real(DP) :: xy_CosZetLV        (0:imax-1, 1:jmax)
   274                                 ! cos( 入射角 )
   275                                 ! cos( Incident angle )
   276                                 ! (local variable)
   277      real(DP) :: PlanetLonFromVELV
   278  
   279      integer         :: hour_in_a_day, min_in_a_hour
   280      real(DP)        :: sec_in_a_min, sec_in_a_day
   281  
   282      logical :: FlagOutputLocal
   283  
   284  
   285      ! 実行文 ; Executable statement
   286      !
   287  
   288      ! 初期化確認
   289      ! Initialization check
   290      !
   291      if ( .not. rad_short_income_inited ) then
   292        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   293      end if
   294  
   295  
   296      ! Set flag for diurnally averaged insolation : This is temporary one.
   297      !
   298      if ( present( DiurnalMeanFactor ) ) then
   299        if ( ( .not. FlagAnnualMean ) .and. FlagDiurnalMean ) then
   300  !!$        DiurnalMeanFactor = 1.0_DP / PI
   301          DiurnalMeanFactor = -1.0e100_DP
   302        else
   303          DiurnalMeanFactor = 1.0_DP
   304        end if
   305      end if
   306  
   307  
   308      ! 同期回転日射のフラグ
   309      ! Flag for synchronous rotation
   310      if ( .not. FlagRadSynchronous ) then
   311  
   312        ! 年, 日平均日射の計算
   313        ! Calculate annual mean, daily mean insolation
   314        !
   315  
   316        if ( FlagAnnualMean .and. FlagDiurnalMean ) then
   317  
   318          do i = 0, imax - 1
   319            do j = 1, jmax
   320              xy_CosZetLV(i,j) = IncomAIns + IncomBIns * cos( y_Lat(j) )**2
   321  
   322              if ( xy_CosZetLV(i,j) > 0.0_DP ) then
   323                xy_InAngleLV(i,j) = 1.0_DP / xy_CosZetLV(i,j)
   324              else
   325                xy_InAngleLV(i,j) = 0.
   326              end if
   327  
   328            end do
   329          end do
     .  !cdir nodep                                                             
     .  !cdir on_adb(d1,y_lat)                                                  
     .        do j = 1, jmax                                                    
     .           d1(j) = dcos(y_lat(j))                                         
     .        enddo                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(d1)                                                        
     .        do j1 = 0, jmax - 1, maxvl()                                      
     .           j2 = min0(jmax - j1,maxvl())                                   
     .           if (imax .gt. 0) then                                          
     .              j3 = and(imax,3)                                            
     .              do i = 1, j3                                                
     .  !cdir          shortloop                                                
     .  !cdir          nodep                                                    
     .  !cdir          on_adb(d1)                                               
     .                 do j = 1, j2                                             
     .                    xy_coszetlv(i-1,j1+j)=incomains+incombins*d1(j1+j)**2 
     .                    if (xy_coszetlv(i-1,j1+j) .gt. 0.0000000000000000e+000
     .       1               ) then                                             
     .                       xy_inanglelv3 = 1.00000000000000e+000/xy_coszetlv(i
     .       1                  -1,j1+j)                                        
     .                    else                                                  
     .                       xy_inanglelv3 = 0.0000000000000000e+000            
     .                    endif                                                 
     .                    xy_inanglelv(i-1,j1+j) = xy_inanglelv3                
     .                 enddo                                                    
     .              enddo                                                       
     .              do i = j3 + 1, imax, 4                                      
     .  !cdir          shortloop                                                
     .  !cdir          nodep                                                    
     .  !cdir          on_adb(d1)                                               
     .                 do j = 1, j2                                             
     .                    d2 = d1(j1+j)                                         
     .                    xy_coszetlv(i-1,j1+j)=(incomains+(incombins*(d2**2))) 
     .                    xy_coszetlv(i,j1+j)=(incomains+(incombins*(d2**2)))   
     .                    xy_coszetlv(i+1,j1+j)=(incomains+(incombins*(d2**2))) 
     .                    xy_coszetlv(i+2,j1+j)=(incomains+(incombins*(d2**2))) 
     .                    if (xy_coszetlv(i-1,j1+j) .gt. 0.0000000000000000e+000
     .       1               ) then                                             
     .                       xy_inanglelv4 = 1.00000000000000e+000/xy_coszetlv(i
     .       1                  -1,j1+j)                                        
     .                    else                                                  
     .                       xy_inanglelv4 = 0.0000000000000000e+000            
     .                    endif                                                 
     .                    xy_inanglelv(i-1,j1+j) = xy_inanglelv4                
     .                    if (xy_coszetlv(i,j1+j) .gt. 0.0000000000000000e+000) 
     .       1               then                                               
     .                       xy_inanglelv5 = 1.00000000000000e+000/xy_coszetlv(i
     .       1                  ,j1+j)                                          
     .                    else                                                  
     .                       xy_inanglelv5 = 0.0000000000000000e+000            
     .                    endif                                                 
     .                    xy_inanglelv(i,j1+j) = xy_inanglelv5                  
     .                    if (xy_coszetlv(i+1,j1+j) .gt. 0.0000000000000000e+000
     .       1               ) then                                             
     .                       xy_inanglelv6 = 1.00000000000000e+000/xy_coszetlv(i
     .       1                  +1,j1+j)                                        
     .                    else                                                  
     .                       xy_inanglelv6 = 0.0000000000000000e+000            
     .                    endif                                                 
     .                    xy_inanglelv(i+1,j1+j) = xy_inanglelv6                
     .                    if (xy_coszetlv(i+2,j1+j) .gt. 0.0000000000000000e+000
     .       1               ) then                                             
     .                       xy_inanglelv7 = 1.00000000000000e+000/xy_coszetlv(i
     .       1                  +2,j1+j)                                        
     .                    else                                                  
     .                       xy_inanglelv7 = 0.0000000000000000e+000            
     .                    endif                                                 
     .                    xy_inanglelv(i+2,j1+j) = xy_inanglelv7                
     .                 enddo                                                    
     .              enddo                                                       
     .           endif                                                          
     .        enddo                                                             
   330  
   331          DistFromStarScldLV = 1.0_DP
   332          SinDel             = 0.0_DP
   333          PlanetLonFromVELV  = 0.0_DP
   334  
   335        else if ( .not. FlagAnnualMean ) then
   336  
   337          ! Set sine of declination and distance between a planet and a central star
   338          ! scaled with semi-major axis
   339          !
   340          if ( FlagPerpetual ) then
   341            SinDel             = PerpSinDel
   342            DistFromStarScldLV = PerpDistFromStarScld
   343          else
   344            call ShortIncomCalcOrbParam(                       &
   345              & SinDel, DistFromStarScldLV, PlanetLonFromVELV  & ! (out) optional
   346              & )
   347            if ( present( PlanetLonFromVE ) ) PlanetLonFromVE = PlanetLonFromVELV
   348          end if
   349  
   350  
   351          call DCCalInquire( &
   352            & hour_in_day      = hour_in_a_day,     & ! (out)
   353            & min_in_hour      = min_in_a_hour,     & ! (out)
   354            & sec_in_min       = sec_in_a_min       & ! (out)
   355            & )
   356          sec_in_a_day  = hour_in_a_day * min_in_a_hour * sec_in_a_min
   357  
   358  
   359          if ( FlagSpecifySolDay ) then
   360            ! case with solar day which is different from sec_in_a_day (rotation
   361            ! period)
   362            ClockByDay = mod( TimeN / SolDay, 1.0_DP )
   363          else
   364            ! case with solar day which is the same as sec_in_a_day (rotation
   365            ! period)
   366            ClockByDay = DCCalDateEvalSecOfDay( TimeN, date = InitialDate )
   367            ClockByDay = ClockByDay / sec_in_a_day
   368          end if
   369  
   370  
   371  !!$        write( 6, * ) '###', TimeN, ClockByDay, mod( TimeN / sec_in_a_day, 1.0_DP )
   372  !!$        write( 60, * ) TimeN, ClockByDay, mod( TimeN / sec_in_a_day, 1.0_DP )
   373  !!$        call flush( 60 )
   374  
   375  
   376          do i = 0, imax - 1
   377            do j = 1, jmax
   378  
   379  
   380              if ( FlagDiurnalMean ) then
   381                HourAngle = 0.0_DP
   382              else
   383                HourAngle = ClockByDay * 2.0_DP * PI - PI + x_Lon(i)
   384              end if
   385  
   386              CosZet = sin( y_Lat(j) ) * SinDel &
   387                &  + cos( y_Lat(j) ) * sqrt( 1.0_DP - SinDel**2 ) * cos( HourAngle )
   388  
   389              xy_CosZetLV(i,j) = CosZet
   390  
   391              if ( CosZet > 0.0_DP ) then
   392                xy_InAngleLV(i,j)       = 1.0_DP / CosZet
   393              else
   394                xy_InAngleLV(i,j)       = 0.
   395              end if
   396  
   397            end do
   398          end do
     .  !cdir nodep                                                             
     .  !cdir on_adb(d8,y_lat)                                                  
     .        do j = 1, jmax                                                    
     .           d8(j) = dsin(y_lat(j))                                         
     .           d9(j) = dcos(y_lat(j))                                         
     .           d10(j) = dsqrt(1.00000000000000e+000 - sindel**2)              
     .        enddo                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(d8,d9,d10)                                                 
     .        do j4 = 0, jmax - 1, maxvl()                                      
     .           j5 = min0(jmax - j4,maxvl())                                   
     .           do i = 1, imax                                                 
     .  !cdir       shortloop                                                   
     .  !cdir       nodep                                                       
     .  !cdir       on_adb(d8,d9,d10,y_lat)                                     
     .              do j = 1, j5                                                
     .                 if (flagdiurnalmean .ne. 0) then                         
     .                    hourangle = 0.0000000000000000e+000                   
     .                 else                                                     
     .                    hourangle = clockbyday*2.00000000000000e+000*         
     .       1               3.14159265358979e+000 - 3.14159265358979e+000 +    
     .       2               x_lon(i-1)                                         
     .                 endif                                                    
     .                 coszet = d8(j4+j)*sindel + d9(j4+j)*d10(j4+j)*dcos(      
     .       1            hourangle)                                            
     .                 xy_coszetlv(i-1,j4+j) = coszet                           
     .                 if (coszet .gt. 0.0000000000000000e+000) then            
     .                    xy_inanglelv11 = 1.00000000000000e+000/coszet         
     .                 else                                                     
     .                    xy_inanglelv11 = 0.0000000000000000e+000              
     .                 endif                                                    
     .                 xy_inanglelv(i-1,j4+j) = xy_inanglelv11                  
     .              enddo                                                       
     .           enddo                                                          
     .        enddo                                                             
     .        goto 10009                                                        
   399  
   400        else
   401  
   402          ! 対応していない入射タイプ
   403          ! not implemented insolation type
   404          !
   405          call MessageNotify( 'E', module_name, 'This type of insolation is not impremented' )
   406  
   407        end if
   408  
   409      else
   410  
   411        ! 短波入射 (太陽入射) を計算します.
   412        ! 同期回転惑星を想定しており,
   413        ! 常に経度 90 度で最大入射, 経度 180-360 度で入射ゼロとなっています.
   414        !
   415        ! Calculate short wave (insolation) incoming radiation.
   416        ! A planet with synchronized rotation are assumed.
   417        ! Incoming is max at latitude 90 deg., and zero between 180 and 360 deg. constantly.
   418        do i = 0, imax - 1
   419           AngleMaxLon  = - PI / 2.0_DP + x_Lon( i )
   420           do j = 1, jmax
   421              CosZet = cos( y_Lat(j) ) * cos( AngleMaxLon )
   422  
   423              xy_CosZetLV(i,j) = CosZet
   424  
   425              if ( CosZet > 0.0_DP ) then
   426                 xy_InAngleLV(i,j) = 1.0_DP / CosZet
   427              else
   428                 xy_InAngleLV(i,j) = 0.0_DP
   429              end if
   430  
   431              DistFromStarScldLV = 1.0_DP
   432           end do
     .        if (jmax .gt. 0) then                                             
     .  !cdir    nodep                                                          
     .  !cdir    on_adb(y_lat)                                                  
     .           do j = 1, jmax                                                 
     .              coszet = dcos(y_lat(j))*dcos(anglemaxlon)                   
     .              xy_coszetlv(i,j) = coszet                                   
     .              if (coszet .gt. 0.0000000000000000e+000) then               
     .                 xy_inanglelv12 = 1.00000000000000e+000/coszet            
     .              else                                                        
     .                 xy_inanglelv12 = 0.0000000000000000e+000                 
     .              endif                                                       
     .              xy_inanglelv(i,j) = xy_inanglelv12                          
     .           enddo                                                          
     .           distfromstarscldlv = 1.00000000000000e+000                     
     .        endif                                                             
   433        end do
   434  
   435      end if
   436  
   437  
   438      if ( present( xy_InAngle ) ) then
   439        xy_InAngle = xy_InAngleLV
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t292 = 1, jmax*imax                                            
     .           xy_inangle(t292-1,1) = xy_inanglelv(t292-1,1)                  
     .        enddo                                                             
   440      end if
   441      if ( present( xy_CosZet ) ) then
   442        xy_CosZet = xy_CosZetLV
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t284 = 1, jmax*imax                                            
     .           xy_coszet(t284-1,1) = xy_coszetlv(t284-1,1)                    
     .        enddo                                                             
   443      end if
   444      if ( present( DistFromStarScld ) ) then
   445        DistFromStarScld = DistFromStarScldLV
   446      end if
   447  
   448      ! ヒストリデータ出力
   449      ! History data output
   450      !
   451      FlagOutputLocal = .false.
   452      if ( present( FlagOutput ) ) then
   453        if ( FlagOutput ) then
   454          FlagOutputLocal = .true.
   455        end if
   456      else
   457        FlagOutputLocal = .true.
   458      end if
   459      if ( FlagOutputLocal ) then
   460        call HistoryAutoPut( TimeN, 'Decl'            , asin(SinDel)*180.0_DP/PI      )
   461        call HistoryAutoPut( TimeN, 'DistFromStarScld', DistFromStarScldLV            )
   462        call HistoryAutoPut( TimeN, 'PlanetLonFromVE' , PlanetLonFromVELV*180.0_DP/PI )
   463      end if
   464  
   465  
   466    end subroutine RadShortIncome
   467  
   468    !--------------------------------------------------------------------------------------
   469  
   470    subroutine ShortIncomCalcOrbParam(             &
   471      & SinDel, DistFromStarScld, PlanetLonFromVE  & ! (out)
   472      & )
   473      !
   474      ! 短波入射 (太陽入射) を計算します.
   475      !
   476      ! Calculate short wave (insolation) incoming radiation.
   477      !
   478  
   479      ! モジュール引用 ; USE statements
   480      !
   481  
   482      ! 日付および時刻の取り扱い
   483      ! Date and time handler
   484      !
   485      use dc_calendar, only: DCCalInquire, DCCalDateChkLeapYear
   486  
   487      ! 宣言文 ; Declaration statements
   488      !
   489      implicit none
   490      real(DP), intent(out) :: SinDel
   491                                ! 赤緯
   492                                ! Declination
   493      real(DP), intent(out) :: DistFromStarScld
   494                                ! 軌道長半径でスケーリングした恒星からの距離
   495                                ! Distance from the star scaled
   496                                ! by semimajor axis of the planet's orbit
   497      real(DP), intent(out) :: PlanetLonFromVE
   498                                ! 中心星を中心とする座標における春分点から測った惑星の経度
   499                                ! Longitude of the planet measured from the vernal equinox
   500                                ! in the coordinate that the central star is located on
   501                                ! the origin.
   502  
   503      ! 作業変数
   504      ! Work variables
   505      !
   506      integer:: itr              ! イテレーション方向に回る DO ループ用作業変数
   507                                 ! Work variables for DO loop in iteration direction
   508  
   509      real(DP):: MeanAnomaly     ! 平均近点角
   510                                 ! Mean anomaly
   511      real(DP):: EccAnomaly      ! 離心近点角
   512                                 ! eccentric anomaly
   513      real(DP):: EccAnomalyError ! ニュートン法における離心近点角の誤差
   514                                 ! error of eccentric anomaly in Newton method
   515      real(DP):: TrueAnomaly     ! 真点離角
   516                                 ! true anomaly
   517  
   518      integer         :: hour_in_a_day, min_in_a_hour, day_in_a_year
   519      integer, pointer:: day_in_month_ptr(:) => null()
   520      real(DP)        :: sec_in_a_min, sec_in_a_day, sec_in_a_year
   521  
   522  
   523  
   524      ! 実行文 ; Executable statement
   525      !
   526  
   527      ! 初期化確認
   528      ! Initialization check
   529      !
   530      if ( .not. rad_short_income_inited ) then
   531        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   532      end if
   533  
   534  
   535      ! 季節変化, 日変化がある場合の計算
   536      ! Calculate with seasonal change and diurnal change
   537      !
   538      call DCCalInquire( &
   539        & day_in_month_ptr = day_in_month_ptr , & ! (out)
   540        & hour_in_day      = hour_in_a_day,     & ! (out)
   541        & min_in_hour      = min_in_a_hour,     & ! (out)
   542        & sec_in_min       = sec_in_a_min       & ! (out)
   543        & )
   544      ! Add 1 to day_in_month_ptr(2) if it is leap year.
   545      !
   546      if ( DCCalDateChkLeapYear( TimeN, InitialDate ) ) then
   547        day_in_month_ptr(2) = day_in_month_ptr(2) + 1
   548      end if
   549  
   550      day_in_a_year = sum( day_in_month_ptr )
   551      deallocate( day_in_month_ptr )
   552      sec_in_a_day  = hour_in_a_day * min_in_a_hour * sec_in_a_min
   553      sec_in_a_year = day_in_a_year * sec_in_a_day
   554  
   555      MeanAnomaly  =                                               &
   556        &   2.0_DP * PI * ( TimeN - TimeAtEpoch ) / sec_in_a_year  &
   557        & + ( LonFromVEAtEpoch - PerLonFromVE ) * PI / 180.0_DP
   558      MeanAnomaly  = mod( MeanAnomaly, 2.0_DP * PI )
   559  
   560  
   561      ! ニュートン法を用いて平均近点角から離心近点角を求める.
   562      ! Calculate eccentric anomaly from mean anomaly by using Newton method.
   563  
   564      EccAnomaly = MeanAnomaly
   565      do itr = 1, MaxItrEccAnomaly
   566        EccAnomalyError = EccAnomaly                                        &
   567          & - Eccentricity * sin(EccAnomaly) - MeanAnomaly
   568        if ( abs(EccAnomalyError) <= ThreEccAnomalyError ) exit
   569        EccAnomaly      = EccAnomaly                                        &
   570          & - EccAnomalyError / ( 1.0_DP - Eccentricity * cos(EccAnomaly) )
   571        EccAnomaly      = mod( EccAnomaly, 2.0 * PI )
   572      end do
   573      if ( itr > MaxItrEccAnomaly ) then
   574        call MessageNotify( 'E', module_name,                        &
   575          & 'Calculation for eccentric anomaly does not converge.' )
   576      end if
   577  
   578      DistFromStarScld = 1.0_DP - Eccentricity * cos( EccAnomaly )
   579  
   580      TrueAnomaly = 2.0_DP                                                    &
   581        & * atan(                                                             &
   582        &         sqrt( ( 1.0d0 + Eccentricity ) / ( 1.0d0 - Eccentricity ) ) &
   583        &           * tan( EccAnomaly / 2.0_DP )                              &
   584        &       )
   585  
   586      PlanetLonFromVE = TrueAnomaly + PerLonFromVE * PI / 180.0_DP
   587      PlanetLonFromVE = mod( PlanetLonFromVE, 2.0_DP * PI )
   588  
   589      SinDel = sin( EpsOrb * PI / 180.0_DP ) * sin( PlanetLonFromVE )
   590  
   591  
   592          ! code for debug
   593  !!$        write( 60, * ) TimeN/sec_in_a_day, DCCalDateChkLeapYear(TimeN,date=InitialDate), day_in_a_year
   594  !!$        write(  6, * ) TimeN/sec_in_a_day, DCCalDateChkLeapYear(TimeN,date=InitialDate), day_in_a_year
   595  !!$        call flush( 60 )
   596  
   597  
   598  !!$        write( 60, * ) TimeN/sec_in_a_day, asin(SinDel)*180.0/PI, DistFromStarScld, PlanetLonFromVE*180.0_DP/PI
   599  !!$        write(  6, * ) TimeN/sec_in_a_day, asin(SinDel)*180.0/PI, DistFromStarScld, PlanetLonFromVE*180.0_DP/PI
   600  !!$        call flush( 60 )
   601  
   602  
   603    end subroutine ShortIncomCalcOrbParam
   604  
   605    !--------------------------------------------------------------------------------------
   606  
   607    subroutine RadShortIncomeInit
   608      !
   609      ! rad_short_income モジュールの初期化を行います.
   610      ! NAMELIST#rad_short_income_nml の読み込みはこの手続きで行われます.
   611      !
   612      ! "rad_short_income" module is initialized.
   613      ! "NAMELIST#rad_short_income_nml" is loaded in this procedure.
   614      !
   615  
   616      ! モジュール引用 ; USE statements
   617      !
   618  
   619      ! 種別型パラメタ
   620      ! Kind type parameter
   621      !
   622      use dc_types, only: STDOUT ! 標準出力の装置番号. Unit number of standard output
   623  
   624      ! ファイル入出力補助
   625      ! File I/O support
   626      !
   627      use dc_iounit, only: FileOpen
   628  
   629      ! ヒストリデータ出力
   630      ! History data output
   631      !
   632      use gtool_historyauto, only: HistoryAutoAddVariable
   633  
   634      ! 暦と日時の取り扱い
   635      ! Calendar and Date handler
   636      !
   637      use dc_calendar, only: &
   638        & DC_CAL_DATE, &          ! 日時を表現するデータ型.
   639                                  ! Data type for date and time
   640        & DCCalDateInquire, DCCalDateCreate, DCCalDateDifference, &
   641        & DCCalConvertByUnit
   642  
   643      ! NAMELIST ファイル入力に関するユーティリティ
   644      ! Utilities for NAMELIST file input
   645      !
   646      use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid
   647  
   648      ! 宣言文 ; Declaration statements
   649      !
   650      implicit none
   651  
   652      integer:: EpochYear, EpochMonth, EpochDay, EpochHour, EpochMin
   653                                ! 元期日時 (年月日時分).
   654                                ! "TimeAtEpoch" が負の場合にこちらが使用される.
   655                                !
   656                                ! Date at epoch (year, month, day, hour, minute)
   657                                ! These are used when "TimeAtEpoch" is negative.
   658      real(DP):: EpochSec
   659                                ! 元期日時 (秒).
   660                                ! "TimeAtEpoch" が負の場合にこちらが使用される.
   661                                !
   662                                ! Date at epoch (second)
   663                                ! These are used when "TimeAtEpoch" is negative.
   664  
   665      type(DC_CAL_DATE):: EpochDate
   666                                ! 元期の日時
   667                                ! Date at epoch
   668  
   669      real(DP)         :: PerpDelDeg
   670                                ! Declination angle in degree used for perpetual experiment
   671  
   672      real(DP)         :: SolDayValue
   673      character(TOKEN) :: SolDayUnit
   674  
   675      integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号.
   676                                ! Unit number for NAMELIST file open
   677      integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT.
   678                                ! IOSTAT of NAMELIST read
   679  
   680      logical         :: FlagUseOfEpochDate
   681      character(TOKEN):: date_print
   682  
   683  
   684      ! NAMELIST 変数群
   685      ! NAMELIST group name
   686      !
   687      namelist /rad_short_income_nml/                                     &
   688        & FlagRadSynchronous,                                             &
   689        & FlagAnnualMean, FlagDiurnalMean, FlagPerpetual,                 &
   690        & PerpDelDeg, PerpDistFromStarScld,                               &
   691        & EpsOrb,                                                         &
   692        & PerLonFromVE,                                                   &
   693        & LonFromVEAtEpoch,                                               &
   694        & Eccentricity,                                                   &
   695        & TimeAtEpoch,                                                    &
   696        & EpochYear, EpochMonth, EpochDay, EpochHour, EpochMin, EpochSec, &
   697        & MaxItrEccAnomaly, ThreEccAnomalyError,                          &
   698        & IncomAIns, IncomBIns, IncomAZet, IncomBZet,                     &
   699        & FlagSpecifySolDay, SolDayValue, SolDayUnit
   700            !
   701            ! デフォルト値については初期化手続 "rad_short_income#RadShortIncomeInit"
   702            ! のソースコードを参照のこと.
   703            !
   704            ! Refer to source codes in the initialization procedure
   705            ! "rad_short_income#RadShortIncomeInit" for the default values.
   706            !
   707  
   708      ! 実行文 ; Executable statement
   709      !
   710  
   711      if ( rad_short_income_inited ) return
   712  
   713  
   714      ! デフォルト値の設定
   715      ! Default values settings
   716      !
   717      FlagRadSynchronous       = .false.
   718      FlagAnnualMean           = .true.
   719      FlagDiurnalMean          = .true.
   720      FlagPerpetual            = .false.
   721  
   722      !---
   723  
   724      PerpDelDeg               = 0.0_DP
   725      PerpDistFromStarScld     = 1.0_DP
   726  
   727      !---
   728  
   729      EpsOrb               =   23.5_DP    ! Earth-like value
   730      PerLonFromVE         =    0.0_DP
   731      LonFromVEAtEpoch     =  280.0_DP    ! This value results in the fact that the planet
   732                                          ! is located at the position of vernal equinox
   733                                          ! at 80 days after calculation with the use of
   734                                          ! "360day" calendar.
   735      Eccentricity         =    0.0_DP
   736      TimeAtEpoch          =    0.0_DP
   737      EpochYear            =   -1
   738      EpochMonth           =   -1
   739      EpochDay             =   -1
   740      EpochHour            =   -1
   741      EpochMin             =   -1
   742      EpochSec             =   -1.0_DP
   743  
   744      !---
   745  
   746      ! Sample values for the Earth
   747      !  References:
   748      !    Duffett-Smith, P., Practical astronomy with your calculator Third Edition,
   749      !    Cambridge University Press, pp.185, 1988.
   750      !
   751  !!$    EpsOrb               =   23.44_DP                ! Rika nenpyo (Chronological
   752  !!$                                                     ! Scientific Tables 2010)
   753  !!$    PerLonFromVE         =  102.768413_DP + 180.0_DP ! Duffett-Smith (1988), p.105
   754  !!$                                                     ! modified (plus 180 degrees)
   755  !!$    LonFromVEAtEpoch     =   99.403308_DP + 180.0_DP ! Duffett-Smith (1988), p.105
   756  !!$                                                     ! modified (plus 180 degrees)
   757  !!$    Eccentricity         =    0.016713_DP            ! Duffett-Smith (1988), p.105
   758  !!$    TimeAtEpoch          =   -1.0_DP                 ! EpochXXX written below are used
   759  !!$                                                     ! because this is negative.
   760  !!$    EpochYear            = 1990                      ! Duffett-Smith (1988), p.105
   761  !!$    EpochMonth           =    1
   762  !!$    EpochDay             =    1
   763  !!$    EpochHour            =    0
   764  !!$    EpochMin             =    0
   765  !!$    EpochSec             =    0.0_DP
   766      !---
   767  
   768      ! Sample values for Mars
   769      !  References:
   770      !    Allison, M., Geophys. Res. Lett., 24, 1967-1970, 1997.
   771      !
   772  !!$    EpsOrb               =   25.19_DP              ! Allison (1997)
   773  !!$    PerLonFromVE         =  250.98_DP              ! Allison (1997) (modified)
   774  !!$    LonFromVEAtEpoch     =  -10.342_DP             ! Arbitrarily set for clarity
   775  !!$                                                   ! This results in Ls ~ 0 at Time = 0
   776  !!$    Eccentricity         =    0.0934_DP            ! Allison (1997), value at epoch J2000
   777  !!$    TimeAtEpoch          =    0.0_DP               ! Arbitrarily set for clarity
   778  !!$    EpochYear            =   -1                    ! not used
   779  !!$    EpochMonth           =   -1
   780  !!$    EpochDay             =   -1
   781  !!$    EpochHour            =   -1
   782  !!$    EpochMin             =   -1
   783  !!$    EpochSec             =   -1.0_DP
   784  
   785      !---
   786  
   787      MaxItrEccAnomaly     = 20
   788      ThreEccAnomalyError  = 1e-6_DP
   789  
   790      IncomAIns            = 0.127_DP   ! see dcpam document for reference
   791      IncomBIns            = 0.183_DP   ! see dcpam document for reference
   792      IncomAZet            = 0.410_DP   ! see dcpam document for reference
   793      IncomBZet            = 0.590_DP   ! see dcpam document for reference
   794  
   795      FlagSpecifySolDay = .false.
   796      SolDayValue       = 0.0_DP
   797      SolDayUnit        = 'sec'
   798  
   799  
   800      ! NAMELIST の読み込み
   801      ! NAMELIST is input
   802      !
   803      if ( trim(namelist_filename) /= '' ) then
   804        call FileOpen( unit_nml, &          ! (out)
   805          & namelist_filename, mode = 'r' ) ! (in)
   806  
   807        rewind( unit_nml )
   808        read( unit_nml, &                ! (in)
   809          & nml = rad_short_income_nml, &  ! (out)
   810          & iostat = iostat_nml )        ! (out)
   811        close( unit_nml )
   812  
   813        call NmlutilMsg( iostat_nml, module_name ) ! (in)
   814      end if
   815  
   816  
   817      if ( ( .not. FlagAnnualMean ) .and. FlagDiurnalMean ) then
   818        call MessageNotify( 'E', module_name, &
   819          & 'FlagDiurnalMean cannot be true if FlagAnnualMean is false.' )
   820      end if
   821  
   822  
   823      PerpSinDel = sin( PerpDelDeg * PI / 180.0_DP )
   824  
   825  
   826      FlagUseOfEpochDate = .false.
   827  
   828      if ( TimeAtEpoch < 0.0_DP ) then
   829        call DCCalDateCreate(    &
   830          & year  = EpochYear,   & ! (in)
   831          & month = EpochMonth,  & ! (in)
   832          & day   = EpochDay,    & ! (in)
   833          & hour  = EpochHour,   & ! (in)
   834          & min   = EpochMin,    & ! (in)
   835          & sec   = EpochSec,    & ! (in)
   836          & date  = EpochDate )    ! (out) optional
   837  
   838        TimeAtEpoch = DCCalDateDifference( &
   839          &                                 start_date = InitialDate, &  ! (in)
   840          &                                 end_date   = EpochDate    &  ! (in)
   841          &                              )
   842  
   843        FlagUseOfEpochDate = .true.
   844      end if
   845  
   846      SolDay = DCCalConvertByUnit( SolDayValue, SolDayUnit, 'sec' )
   847  
   848      ! 保存用の変数の割り付け
   849      ! Allocate variables for saving
   850      !
   851  
   852      ! ヒストリデータ出力のためのへの変数登録
   853      ! Register of variables for history data output
   854      !
   855  !!$    call HistoryAutoAddVariable( 'xxxxx' , &
   856  !!$      & (/ 'lon ', 'lat ', 'sig', 'time'/), &
   857  !!$      & 'xxxx', 'W m-2' )
   858  
   859      call HistoryAutoAddVariable( 'Decl' , &
   860        & (/ 'time'/),                      &
   861        & 'declination of the central star', 'degree' )
   862  
   863      call HistoryAutoAddVariable( 'DistFromStarScld' , &
   864        & (/ 'time'/),                                  &
   865        & 'distance between the central star and the planet', '1' )
   866  
   867      call HistoryAutoAddVariable( 'PlanetLonFromVE' , &
   868        & (/ 'time'/),                                 &
   869        & 'planetary longitude from the vernal equinox', 'degree' )
   870  
   871      ! 印字 ; Print
   872      !
   873      call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   874      call MessageNotify( 'M', module_name, 'ShortIncomming:' )
   875      call MessageNotify( 'M', module_name, '  FlagRadSynchronous       = %b', l = (/ FlagRadSynchronous /) )
   876      call MessageNotify( 'M', module_name, '  FlagAnnualMean           = %b', l = (/ FlagAnnualMean            /) )
   877      call MessageNotify( 'M', module_name, '  FlagDiurnalMean          = %b', l = (/ FlagDiurnalMean           /) )
   878      call MessageNotify( 'M', module_name, '  FlagPerpetual            = %b', l = (/ FlagPerpetual             /) )
   879      call MessageNotify( 'M', module_name, '  PerpDelDeg               = %f', d = (/ PerpDelDeg                /) )
   880      call MessageNotify( 'M', module_name, '  PerpDistFromStarScld     = %f', d = (/ PerpDistFromStarScld      /) )
   881      call MessageNotify( 'M', module_name, '  EpsOrb                   = %f', d = (/ EpsOrb                   /) )
   882      call MessageNotify( 'M', module_name, '  PerLonFromVE             = %f', d = (/ PerLonFromVE             /) )
   883      call MessageNotify( 'M', module_name, '  Eccentricity             = %f', d = (/ Eccentricity             /) )
   884  
   885      if ( FlagUseOfEpochDate ) then
   886        call DCCalDateInquire( date_print, date = EpochDate )
   887        call MessageNotify( 'M', module_name, '  EpochDate  = %c', &
   888          & c1 = trim(date_print) )
   889      end if
   890      call MessageNotify( 'M', module_name, '  TimeAtEpoch              = %f', d = (/ TimeAtEpoch              /) )
   891      call MessageNotify( 'M', module_name, '  LonFromVEAtEpoch         = %f', d = (/ LonFromVEAtEpoch         /) )
   892  
   893      call MessageNotify( 'M', module_name, '  MaxItrEccAnomaly         = %d', i = (/ MaxItrEccAnomaly         /) )
   894      call MessageNotify( 'M', module_name, '  ThreEccAnomalyError      = %f', d = (/ ThreEccAnomalyError      /) )
   895      call MessageNotify( 'M', module_name, '  IncomAIns                = %f', d = (/ IncomAIns                /) )
   896      call MessageNotify( 'M', module_name, '  IncomBIns                = %f', d = (/ IncomBIns                /) )
   897      call MessageNotify( 'M', module_name, '  IncomAZet                = %f', d = (/ IncomAZet                /) )
   898      call MessageNotify( 'M', module_name, '  IncomBZet                = %f', d = (/ IncomBZet                /) )
   899  
   900      call MessageNotify( 'M', module_name, '  FlagSpecifySolDay        = %b', l = (/ FlagSpecifySolDay        /) )
   901      call MessageNotify( 'M', module_name, '  SolDay                   = %f', d = (/ SolDay                   /) )
   902  
   903  
   904      call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   905  
   906      rad_short_income_inited = .true.
   907  
   908    end subroutine RadShortIncomeInit
   909  
   910    !-------------------------------------------------------------------
   911  
   912  end module rad_short_income
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:45 2016
FILE NAME: rad_short_income.f90
PROGRAM NAME: rad_short_income
FORMAT LIST

  LINE    LOOP      FORTRAN STATEMENT

     1:             != 短波入射 (太陽入射)
     2:             !
     3:             != Short wave (insolation) incoming
     4:             !
     5:             ! Authors::   Satoshi NODA, Yasuhiro MORIKAWA, Yukiko YAMADA, Yoshiyuki O. TAKAHASHI
     6:             ! Version::   $Id: rad_short_income.f90,v 1.6 2013/05/25 06:33:57 yot Exp $
     7:             ! Tag Name::  $Name:  $
     8:             ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9:             ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10:             !
    11:             
    12:             module rad_short_income
    13:               !
    14:               != 短波入射 (太陽入射)
    15:               !
    16:               != Short wave (insolation) incoming
    17:               !
    18:               ! <b>Note that Japanese and English are described in parallel.</b>
    19:               !
    20:               ! 短波入射 (太陽入射) を計算します.
    21:               !
    22:               ! Calculate short wave (insolation) incoming radiation. 
    23:               !
    24:               !== Procedures List
    25:               !
    26:               ! ShortIncoming      :: 短波入射 (太陽入射) の計算
    27:               ! ------------       :: ------------
    28:               ! ShortIncoming      :: Calculate short wave (insolation) incoming radiation. 
    29:               !
    30:               !== NAMELIST
    31:               !
    32:               ! NAMELIST#rad_short_income_nml
    33:               !
    34:             
    35:               ! モジュール引用 ; USE statements
    36:               !
    37:             
    38:               ! 種別型パラメタ
    39:               ! Kind type parameter
    40:               !
    41:               use dc_types, only: DP, &      ! 倍精度実数型. Double precision. 
    42:                 &                 STRING, &  ! 文字列.       Strings. 
    43:                 &                 TOKEN      ! キーワード.   Keywords.
    44:             
    45:               ! メッセージ出力
    46:               ! Message output
    47:               !
    48:               use dc_message, only: MessageNotify
    49:             
    50:               ! 物理・数学定数設定
    51:               ! Physical and mathematical constants settings
    52:               !
    53:               use constants0, only: &
    54:                 & PI                    ! $ \pi $.
    55:                                         ! 円周率. Circular constant
    56:             
    57:               ! 格子点設定
    58:               ! Grid points settings
    59:               !
    60:               use gridset, only: imax, & ! 経度格子点数. 
    61:                                          ! Number of grid points in longitude
    62:                 &                jmax, & ! 緯度格子点数. 
    63:                                          ! Number of grid points in latitude
    64:                 &                kmax    ! 鉛直層数. 
    65:                                          ! Number of vertical level
    66:             
    67:               ! 時刻管理
    68:               ! Time control
    69:               !
    70:               use timeset, only: &
    71:                 & TimeN,                & !
    72:                 & InitialDate             ! 計算開始日時.
    73:                                           ! Start date of calculation
    74:             
    75:               ! 座標データ設定
    76:               ! Axes data settings
    77:               !
    78:               use axesset, only: &
    79:                 & y_Lat,   & ! $ \varphi $ [rad.] . 緯度. Latitude
    80:                 & x_Lon      ! $ \lambda $ [rad.] . 経度. Longitude
    81:             
    82:             
    83:               ! 宣言文 ; Declaration statements
    84:               !
    85:               implicit none
    86:               private
    87:             
    88:               ! 公開手続き
    89:               ! Public procedure
    90:               !
    91:               public:: RadShortIncome
    92:               public:: RadShortIncomeInit
    93:             
    94:               ! 公開変数
    95:               ! Public variables
    96:               !
    97:               logical, save :: rad_short_income_inited = .false.
    98:                                           ! 初期設定フラグ. 
    99:                                           ! Initialization flag.
   100:             
   101:             
   102:               ! 非公開変数
   103:               ! Private variables
   104:               !
   105:             
   106:               logical,  save:: FlagAnnualMean
   107:                                           ! 年平均入射フラグ.
   108:                                           ! Flag for annual mean incoming radiation. 
   109:               logical,  save:: FlagDiurnalMean
   110:                                           ! 日平均入射フラグ.
   111:                                           ! Flag for diurnal mean incoming radiation. 
   112:               logical,  save:: FlagPerpetual
   113:                                           ! 季節変化なし入射フラグ.
   114:                                           ! Flag for perpetual incoming radiation. 
   115:             
   116:               real(DP), save :: PerpSinDel
   117:                                           ! sine of declination angle for perpetual experiments
   118:               real(DP), save :: PerpDistFromStarScld
   119:                                           ! distance between a planet and a central star for 
   120:                                           ! perpetual experiment
   121:               logical,  save:: FlagSpecifySolDay
   122:                                           ! 
   123:                                           ! Flag for specifying solar day
   124:               real(DP), save :: SolDay
   125:                                           ! length of solar day
   126:             
   127:             
   128:               ! NOTE:
   129:               !   Distance between the central star and the planet, and the declination can be
   130:               !   determined by specifying following three parameters: 
   131:               !     PerLonFromVE     : the longitude of the perihelion measured from the vernal 
   132:               !                        equinox, 
   133:               !     LonFromVEAtEpoch : the longitude of the planet at epoch, 
   134:               !     epoch            : date or time. 
   135:               !
   136:               real(DP), save:: PerLonFromVE
   137:                                           ! 春分から測った近日点の経度 (近日点黄経) (degree)
   138:                                           ! Longitude of the perihelion from vernal equinox (degree)
   139:               real(DP), save:: LonFromVEAtEpoch
   140:                                           ! 元期における惑星の経度 (黄経) (degree)
   141:                                           ! Longitude of the planet at epoch (degree)
   142:               real(DP), save:: TimeAtEpoch
   143:                                           ! 元期における時刻 (sec)
   144:                                           ! Time at epoch (sec)
   145:             
   146:               real(DP), save:: EpsOrb
   147:                                           ! 赤道傾斜角.
   148:                                           ! Inclination of equator to orbit.
   149:               real(DP), save:: Eccentricity
   150:                                           ! 離心率.
   151:                                           ! Eccentricity.
   152:             
   153:               integer,  save:: MaxItrEccAnomaly
   154:                                           ! 離心近点角を計算する時の最大繰り返し回数.
   155:                                           ! Maximum iteration number of times
   156:                                           ! to calculate eccentric anomaly.
   157:               real(DP), save:: ThreEccAnomalyError
   158:                                           ! 離心近点角を計算する時の誤差の許容しきい値.
   159:                                           ! Threshold of error
   160:                                           ! to calculate eccentric anomaly.
   161:             
   162:               real(DP), save:: IncomAIns
   163:                                           ! $ A_{ins} $ . 年平均入射の係数. 
   164:                                           ! Coefficient of annual mean incoming radiation. 
   165:               real(DP), save:: IncomBIns
   166:                                           ! $ B_{ins} $ . 年平均入射の係数. AIns に同じ. 
   167:                                           ! Coefficient of annual mean incoming radiation. 
   168:                                           ! Same as "AIns". 
   169:               real(DP), save:: IncomAZet
   170:                                           ! $ A_{\zeta} $ . 年平均入射角の係数. AIns に同じ. 
   171:                                           ! Coefficient of annual mean incoming radiation. 
   172:                                           ! Same as "AIns". 
   173:               real(DP), save:: IncomBZet
   174:                                           ! $ B_{\zeta} $ . 年平均入射角の係数. AIns に同じ. 
   175:                                           ! Coefficient of annual mean incoming radiation. 
   176:                                           ! Same as "AIns". 
   177:             
   178:             
   179:               real(DP), allocatable, save:: xy_InAngle (:,:)
   180:                                           ! sec (入射角). 
   181:                                           ! sec (angle of incidence)
   182:             
   183:               logical:: FlagRadSynchronous
   184:                                           ! 同期回転日射のフラグ
   185:                                           ! Flag for synchronous rotation
   186:             
   187:               character(*), parameter:: module_name = 'rad_short_income'
   188:                                           ! モジュールの名称. 
   189:                                           ! Module name
   190:               character(*), parameter:: version = &
   191:                 & '$Name:  $' // &
   192:                 & '$Id: rad_short_income.f90,v 1.6 2013/05/25 06:33:57 yot Exp $'
   193:                                           ! モジュールのバージョン
   194:                                           ! Module version
   195:             
   196:             contains
   197:             
   198:               !--------------------------------------------------------------------------------------
   199:             
   200:               subroutine RadShortIncome(                    &
   201:                 & xy_InAngle, DistFromStarScld, xy_CosZet,  & ! (out) optional
   202:                 & DiurnalMeanFactor, PlanetLonFromVE,       & ! (out) optional
   203:                 & FlagOutput                                & ! (in)  optional
   204:                 & )
   205:                 !
   206:                 ! 短波入射 (太陽入射) を計算します.
   207:                 !
   208:                 ! Calculate short wave (insolation) incoming radiation. 
   209:                 !
   210:             
   211:                 ! モジュール引用 ; USE statements
   212:                 !
   213:             
   214:                 ! 日付および時刻の取り扱い
   215:                 ! Date and time handler
   216:                 !
   217:                 use dc_calendar, only: DCCalInquire, DCCalDateEvalSecOfDay
   218:             
   219:                 ! ヒストリデータ出力
   220:                 ! History data output
   221:                 !
   222:                 use gtool_historyauto, only: HistoryAutoPut
   223:             
   224:             
   225:                 ! 宣言文 ; Declaration statements
   226:                 !
   227:                 implicit none
   228:                 real(DP), intent(out), optional :: xy_InAngle (0:imax-1, 1:jmax)
   229:                                           ! sec ( 入射角 ). 
   230:                                           ! sec ( Incident angle )
   231:                 real(DP), intent(out), optional :: DistFromStarScld
   232:                                           ! 軌道長半径でスケーリングした恒星からの距離
   233:                                           ! Distance from the star scaled
   234:                                           ! by semimajor axis of the planet's orbit
   235:                 real(DP), intent(out), optional :: xy_CosZet(0:imax-1, 1:jmax)
   236:                                           ! cos( 入射角 )
   237:                                           ! cos( Incident angle )
   238:                 real(DP), intent(out), optional :: DiurnalMeanFactor
   239:                 real(DP), intent(out), optional :: PlanetLonFromVE
   240:                                           ! 中心星を中心とする座標における春分点から測った惑星の経度
   241:                                           ! Longitude of the planet measured from the vernal equinox
   242:                                           ! in the coordinate that the central star is located on 
   243:                                           ! the origin.
   244:                 logical , intent(in ), optional :: FlagOutput
   245:             
   246:             
   247:                 ! 作業変数
   248:                 ! Work variables
   249:                 !
   250:                 integer:: i                ! 経度方向に回る DO ループ用作業変数
   251:                                            ! Work variables for DO loop in longitude
   252:                 integer:: j                ! 緯度方向に回る DO ループ用作業変数
   253:                                            ! Work variables for DO loop in latitude
   254:                 real(DP):: SinDel          ! 赤緯
   255:                                            ! Declination
   256:                 real(DP):: CosZet          ! 入射角
   257:                                            ! Incidence angle
   258:                 real(DP):: AngleMaxLon     ! 入射が最大となる緯度
   259:             
   260:                 real(DP):: HourAngle       ! 時角
   261:                                            ! Hour angle
   262:                 real(DP):: ClockByDay      ! 時刻を日で表記したもの (0.0 - 1.0)
   263:                                            ! Clock expressed by day (0.0 - 1.0)
   264:             
   265:             
   266:                 real(DP) :: xy_InAngleLV       (0:imax-1, 1:jmax)
   267:                                            ! sec ( 入射角 ). 
   268:                                            ! sec ( Incident angle )
   269:                                            ! (local variable)
   270:                 real(DP) :: DistFromStarScldLV
   271:                                            ! Distance between the central star and the planet
   272:                                            ! (local variable)
   273:                 real(DP) :: xy_CosZetLV        (0:imax-1, 1:jmax)
   274:                                            ! cos( 入射角 )
   275:                                            ! cos( Incident angle )
   276:                                            ! (local variable)
   277:                 real(DP) :: PlanetLonFromVELV
   278:             
   279:                 integer         :: hour_in_a_day, min_in_a_hour
   280:                 real(DP)        :: sec_in_a_min, sec_in_a_day
   281:             
   282:                 logical :: FlagOutputLocal
   283:             
   284:             
   285:                 ! 実行文 ; Executable statement
   286:                 !
   287:             
   288:                 ! 初期化確認
   289:                 ! Initialization check
   290:                 !
   291:                 if ( .not. rad_short_income_inited ) then
   292:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   293:                 end if
   294:             
   295:             
   296:                 ! Set flag for diurnally averaged insolation : This is temporary one.
   297:                 !
   298:                 if ( present( DiurnalMeanFactor ) ) then
   299:                   if ( ( .not. FlagAnnualMean ) .and. FlagDiurnalMean ) then
   300:             !!$        DiurnalMeanFactor = 1.0_DP / PI
   301:                     DiurnalMeanFactor = -1.0e100_DP
   302:                   else
   303:                     DiurnalMeanFactor = 1.0_DP
   304:                   end if
   305:                 end if
   306:             
   307:             
   308:                 ! 同期回転日射のフラグ
   309:                 ! Flag for synchronous rotation
   310:                 if ( .not. FlagRadSynchronous ) then
   311:             
   312:                   ! 年, 日平均日射の計算
   313:                   ! Calculate annual mean, daily mean insolation
   314:                   !
   315:             
   316:                   if ( FlagAnnualMean .and. FlagDiurnalMean ) then
   317:             
   318: +------>A           do i = 0, imax - 1
   319: |V----->A             do j = 1, jmax
   320: ||      A               xy_CosZetLV(i,j) = IncomAIns + IncomBIns * cos( y_Lat(j) )**2
   321: ||          
   322: ||                      if ( xy_CosZetLV(i,j) > 0.0_DP ) then
   323: ||      A                 xy_InAngleLV(i,j) = 1.0_DP / xy_CosZetLV(i,j)
   324: ||                      else
   325: ||                        xy_InAngleLV(i,j) = 0.
   326: ||                      end if
   327: ||          
   328: |V----- A             end do
   329: +------             end do
   330:             
   331:                     DistFromStarScldLV = 1.0_DP
   332:                     SinDel             = 0.0_DP
   333:                     PlanetLonFromVELV  = 0.0_DP
   334:             
   335:                   else if ( .not. FlagAnnualMean ) then
   336:             
   337:                     ! Set sine of declination and distance between a planet and a central star 
   338:                     ! scaled with semi-major axis
   339:                     !
   340:                     if ( FlagPerpetual ) then
   341:                       SinDel             = PerpSinDel
   342:                       DistFromStarScldLV = PerpDistFromStarScld
   343:                     else
   344:                       call ShortIncomCalcOrbParam(                       &
   345:                         & SinDel, DistFromStarScldLV, PlanetLonFromVELV  & ! (out) optional
   346:                         & )
   347:                       if ( present( PlanetLonFromVE ) ) PlanetLonFromVE = PlanetLonFromVELV
   348:                     end if
   349:             
   350:             
   351:                     call DCCalInquire( &
   352:                       & hour_in_day      = hour_in_a_day,     & ! (out)
   353:                       & min_in_hour      = min_in_a_hour,     & ! (out)
   354:                       & sec_in_min       = sec_in_a_min       & ! (out)
   355:                       & )
   356:                     sec_in_a_day  = hour_in_a_day * min_in_a_hour * sec_in_a_min
   357:             
   358:             
   359:                     if ( FlagSpecifySolDay ) then
   360:                       ! case with solar day which is different from sec_in_a_day (rotation
   361:                       ! period)
   362:                       ClockByDay = mod( TimeN / SolDay, 1.0_DP )
   363:                     else
   364:                       ! case with solar day which is the same as sec_in_a_day (rotation
   365:                       ! period)
   366:                       ClockByDay = DCCalDateEvalSecOfDay( TimeN, date = InitialDate )
   367:                       ClockByDay = ClockByDay / sec_in_a_day
   368:                     end if
   369:             
   370:             
   371:             !!$        write( 6, * ) '###', TimeN, ClockByDay, mod( TimeN / sec_in_a_day, 1.0_DP )
   372:             !!$        write( 60, * ) TimeN, ClockByDay, mod( TimeN / sec_in_a_day, 1.0_DP )
   373:             !!$        call flush( 60 )
   374:             
   375:             
   376: +------>A           do i = 0, imax - 1
   377: |V----->              do j = 1, jmax
   378: ||          
   379: ||          
   380: ||                      if ( FlagDiurnalMean ) then
   381: ||                        HourAngle = 0.0_DP
   382: ||                      else
   383: ||                        HourAngle = ClockByDay * 2.0_DP * PI - PI + x_Lon(i)
   384: ||                      end if
   385: ||          
   386: ||      A               CosZet = sin( y_Lat(j) ) * SinDel &
   387: ||                        &  + cos( y_Lat(j) ) * sqrt( 1.0_DP - SinDel**2 ) * cos( HourAngle )
   388: ||          
   389: ||      A               xy_CosZetLV(i,j) = CosZet
   390: ||          
   391: ||                      if ( CosZet > 0.0_DP ) then
   392: ||                        xy_InAngleLV(i,j)       = 1.0_DP / CosZet
   393: ||                      else
   394: ||                        xy_InAngleLV(i,j)       = 0.
   395: ||                      end if
   396: ||          
   397: |V----- A             end do
   398: +------             end do
   399:             
   400:                   else
   401:             
   402:                     ! 対応していない入射タイプ
   403:                     ! not implemented insolation type
   404:                     !
   405:                     call MessageNotify( 'E', module_name, 'This type of insolation is not impremented' )
   406:             
   407:                   end if
   408:             
   409:                 else
   410:             
   411:                   ! 短波入射 (太陽入射) を計算します.
   412:                   ! 同期回転惑星を想定しており,
   413:                   ! 常に経度 90 度で最大入射, 経度 180-360 度で入射ゼロとなっています.
   414:                   !
   415:                   ! Calculate short wave (insolation) incoming radiation.
   416:                   ! A planet with synchronized rotation are assumed.
   417:                   ! Incoming is max at latitude 90 deg., and zero between 180 and 360 deg. constantly.
   418: +------>          do i = 0, imax - 1
   419: |                    AngleMaxLon  = - PI / 2.0_DP + x_Lon( i )
   420: |V----->             do j = 1, jmax
   421: ||      A               CosZet = cos( y_Lat(j) ) * cos( AngleMaxLon )
   422: ||          
   423: ||      A               xy_CosZetLV(i,j) = CosZet
   424: ||          
   425: ||                      if ( CosZet > 0.0_DP ) then
   426: ||                         xy_InAngleLV(i,j) = 1.0_DP / CosZet
   427: ||                      else
   428: ||                         xy_InAngleLV(i,j) = 0.0_DP
   429: ||                      end if
   430: ||          
   431: ||      A               DistFromStarScldLV = 1.0_DP
   432: |V-----              end do
   433: +------           end do
   434:             
   435:                 end if
   436:             
   437:             
   438:                 if ( present( xy_InAngle ) ) then
   439: W*===== A         xy_InAngle = xy_InAngleLV
   440:                 end if
   441:                 if ( present( xy_CosZet ) ) then
   442: W*===== A         xy_CosZet = xy_CosZetLV
   443:                 end if
   444:                 if ( present( DistFromStarScld ) ) then
   445:                   DistFromStarScld = DistFromStarScldLV
   446:                 end if
   447:             
   448:                 ! ヒストリデータ出力
   449:                 ! History data output
   450:                 !
   451:                 FlagOutputLocal = .false.
   452:                 if ( present( FlagOutput ) ) then
   453:                   if ( FlagOutput ) then
   454:                     FlagOutputLocal = .true.
   455:                   end if
   456:                 else
   457:                   FlagOutputLocal = .true.
   458:                 end if
   459:                 if ( FlagOutputLocal ) then
   460:                   call HistoryAutoPut( TimeN, 'Decl'            , asin(SinDel)*180.0_DP/PI      )
   461:                   call HistoryAutoPut( TimeN, 'DistFromStarScld', DistFromStarScldLV            )
   462:                   call HistoryAutoPut( TimeN, 'PlanetLonFromVE' , PlanetLonFromVELV*180.0_DP/PI )
   463:                 end if
   464:             
   465:             
   466:               end subroutine RadShortIncome
   467:             
   468:               !--------------------------------------------------------------------------------------
   469:             
   470:               subroutine ShortIncomCalcOrbParam(             &
   471:                 & SinDel, DistFromStarScld, PlanetLonFromVE  & ! (out)
   472:                 & )
   473:                 !
   474:                 ! 短波入射 (太陽入射) を計算します.
   475:                 !
   476:                 ! Calculate short wave (insolation) incoming radiation. 
   477:                 !
   478:             
   479:                 ! モジュール引用 ; USE statements
   480:                 !
   481:             
   482:                 ! 日付および時刻の取り扱い
   483:                 ! Date and time handler
   484:                 !
   485:                 use dc_calendar, only: DCCalInquire, DCCalDateChkLeapYear
   486:             
   487:                 ! 宣言文 ; Declaration statements
   488:                 !
   489:                 implicit none
   490:                 real(DP), intent(out) :: SinDel
   491:                                           ! 赤緯
   492:                                           ! Declination
   493:                 real(DP), intent(out) :: DistFromStarScld
   494:                                           ! 軌道長半径でスケーリングした恒星からの距離
   495:                                           ! Distance from the star scaled
   496:                                           ! by semimajor axis of the planet's orbit
   497:                 real(DP), intent(out) :: PlanetLonFromVE
   498:                                           ! 中心星を中心とする座標における春分点から測った惑星の経度
   499:                                           ! Longitude of the planet measured from the vernal equinox
   500:                                           ! in the coordinate that the central star is located on 
   501:                                           ! the origin.
   502:             
   503:                 ! 作業変数
   504:                 ! Work variables
   505:                 !
   506:                 integer:: itr              ! イテレーション方向に回る DO ループ用作業変数
   507:                                            ! Work variables for DO loop in iteration direction
   508:             
   509:                 real(DP):: MeanAnomaly     ! 平均近点角
   510:                                            ! Mean anomaly
   511:                 real(DP):: EccAnomaly      ! 離心近点角
   512:                                            ! eccentric anomaly
   513:                 real(DP):: EccAnomalyError ! ニュートン法における離心近点角の誤差
   514:                                            ! error of eccentric anomaly in Newton method
   515:                 real(DP):: TrueAnomaly     ! 真点離角
   516:                                            ! true anomaly
   517:             
   518:                 integer         :: hour_in_a_day, min_in_a_hour, day_in_a_year
   519:                 integer, pointer:: day_in_month_ptr(:) => null()
   520:                 real(DP)        :: sec_in_a_min, sec_in_a_day, sec_in_a_year
   521:             
   522:             
   523:             
   524:                 ! 実行文 ; Executable statement
   525:                 !
   526:             
   527:                 ! 初期化確認
   528:                 ! Initialization check
   529:                 !
   530:                 if ( .not. rad_short_income_inited ) then
   531:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   532:                 end if
   533:             
   534:             
   535:                 ! 季節変化, 日変化がある場合の計算
   536:                 ! Calculate with seasonal change and diurnal change
   537:                 !
   538:                 call DCCalInquire( &
   539:                   & day_in_month_ptr = day_in_month_ptr , & ! (out)
   540:                   & hour_in_day      = hour_in_a_day,     & ! (out)
   541:                   & min_in_hour      = min_in_a_hour,     & ! (out)
   542:                   & sec_in_min       = sec_in_a_min       & ! (out)
   543:                   & )
   544:                 ! Add 1 to day_in_month_ptr(2) if it is leap year.
   545:                 !
   546:                 if ( DCCalDateChkLeapYear( TimeN, InitialDate ) ) then
   547:                   day_in_month_ptr(2) = day_in_month_ptr(2) + 1
   548:                 end if
   549:             
   550: V====== A       day_in_a_year = sum( day_in_month_ptr )
   551:                 deallocate( day_in_month_ptr )
   552:                 sec_in_a_day  = hour_in_a_day * min_in_a_hour * sec_in_a_min
   553:                 sec_in_a_year = day_in_a_year * sec_in_a_day
   554:             
   555:                 MeanAnomaly  =                                               &
   556:                   &   2.0_DP * PI * ( TimeN - TimeAtEpoch ) / sec_in_a_year  &
   557:                   & + ( LonFromVEAtEpoch - PerLonFromVE ) * PI / 180.0_DP
   558:                 MeanAnomaly  = mod( MeanAnomaly, 2.0_DP * PI )
   559:             
   560:             
   561:                 ! ニュートン法を用いて平均近点角から離心近点角を求める.
   562:                 ! Calculate eccentric anomaly from mean anomaly by using Newton method.
   563:             
   564:                 EccAnomaly = MeanAnomaly
   565: +------>        do itr = 1, MaxItrEccAnomaly
   566: |                 EccAnomalyError = EccAnomaly                                        &
   567: |                   & - Eccentricity * sin(EccAnomaly) - MeanAnomaly
   568: |                 if ( abs(EccAnomalyError) <= ThreEccAnomalyError ) exit
   569: |                 EccAnomaly      = EccAnomaly                                        &
   570: |                   & - EccAnomalyError / ( 1.0_DP - Eccentricity * cos(EccAnomaly) )
   571: |                 EccAnomaly      = mod( EccAnomaly, 2.0 * PI )
   572: +------         end do
   573:                 if ( itr > MaxItrEccAnomaly ) then
   574:                   call MessageNotify( 'E', module_name,                        &
   575:                     & 'Calculation for eccentric anomaly does not converge.' )
   576:                 end if
   577:             
   578:                 DistFromStarScld = 1.0_DP - Eccentricity * cos( EccAnomaly )
   579:             
   580:                 TrueAnomaly = 2.0_DP                                                    &
   581:                   & * atan(                                                             &
   582:                   &         sqrt( ( 1.0d0 + Eccentricity ) / ( 1.0d0 - Eccentricity ) ) &
   583:                   &           * tan( EccAnomaly / 2.0_DP )                              &
   584:                   &       )
   585:             
   586:                 PlanetLonFromVE = TrueAnomaly + PerLonFromVE * PI / 180.0_DP
   587:                 PlanetLonFromVE = mod( PlanetLonFromVE, 2.0_DP * PI )
   588:             
   589:                 SinDel = sin( EpsOrb * PI / 180.0_DP ) * sin( PlanetLonFromVE )
   590:             
   591:             
   592:                     ! code for debug
   593:             !!$        write( 60, * ) TimeN/sec_in_a_day, DCCalDateChkLeapYear(TimeN,date=InitialDate), day_in_a_year
   594:             !!$        write(  6, * ) TimeN/sec_in_a_day, DCCalDateChkLeapYear(TimeN,date=InitialDate), day_in_a_year
   595:             !!$        call flush( 60 )
   596:             
   597:             
   598:             !!$        write( 60, * ) TimeN/sec_in_a_day, asin(SinDel)*180.0/PI, DistFromStarScld, PlanetLonFromVE*180.0_DP/PI
   599:             !!$        write(  6, * ) TimeN/sec_in_a_day, asin(SinDel)*180.0/PI, DistFromStarScld, PlanetLonFromVE*180.0_DP/PI
   600:             !!$        call flush( 60 )
   601:             
   602:             
   603:               end subroutine ShortIncomCalcOrbParam
   604:             
   605:               !--------------------------------------------------------------------------------------
   606:             
   607:               subroutine RadShortIncomeInit
   608:                 !
   609:                 ! rad_short_income モジュールの初期化を行います. 
   610:                 ! NAMELIST#rad_short_income_nml の読み込みはこの手続きで行われます. 
   611:                 !
   612:                 ! "rad_short_income" module is initialized. 
   613:                 ! "NAMELIST#rad_short_income_nml" is loaded in this procedure. 
   614:                 !
   615:             
   616:                 ! モジュール引用 ; USE statements
   617:                 !
   618:             
   619:                 ! 種別型パラメタ
   620:                 ! Kind type parameter
   621:                 !
   622:                 use dc_types, only: STDOUT ! 標準出力の装置番号. Unit number of standard output
   623:             
   624:                 ! ファイル入出力補助
   625:                 ! File I/O support
   626:                 !
   627:                 use dc_iounit, only: FileOpen
   628:             
   629:                 ! ヒストリデータ出力
   630:                 ! History data output
   631:                 !
   632:                 use gtool_historyauto, only: HistoryAutoAddVariable
   633:             
   634:                 ! 暦と日時の取り扱い
   635:                 ! Calendar and Date handler
   636:                 !
   637:                 use dc_calendar, only: &
   638:                   & DC_CAL_DATE, &          ! 日時を表現するデータ型.
   639:                                             ! Data type for date and time
   640:                   & DCCalDateInquire, DCCalDateCreate, DCCalDateDifference, &
   641:                   & DCCalConvertByUnit
   642:             
   643:                 ! NAMELIST ファイル入力に関するユーティリティ
   644:                 ! Utilities for NAMELIST file input
   645:                 !
   646:                 use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid
   647:             
   648:                 ! 宣言文 ; Declaration statements
   649:                 !
   650:                 implicit none
   651:             
   652:                 integer:: EpochYear, EpochMonth, EpochDay, EpochHour, EpochMin
   653:                                           ! 元期日時 (年月日時分).
   654:                                           ! "TimeAtEpoch" が負の場合にこちらが使用される.
   655:                                           !
   656:                                           ! Date at epoch (year, month, day, hour, minute)
   657:                                           ! These are used when "TimeAtEpoch" is negative.
   658:                 real(DP):: EpochSec
   659:                                           ! 元期日時 (秒).
   660:                                           ! "TimeAtEpoch" が負の場合にこちらが使用される.
   661:                                           !
   662:                                           ! Date at epoch (second)
   663:                                           ! These are used when "TimeAtEpoch" is negative.
   664:             
   665:                 type(DC_CAL_DATE):: EpochDate
   666:                                           ! 元期の日時
   667:                                           ! Date at epoch
   668:             
   669:                 real(DP)         :: PerpDelDeg
   670:                                           ! Declination angle in degree used for perpetual experiment
   671:             
   672:                 real(DP)         :: SolDayValue
   673:                 character(TOKEN) :: SolDayUnit
   674:             
   675:                 integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号. 
   676:                                           ! Unit number for NAMELIST file open
   677:                 integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT. 
   678:                                           ! IOSTAT of NAMELIST read
   679:             
   680:                 logical         :: FlagUseOfEpochDate
   681:                 character(TOKEN):: date_print
   682:             
   683:             
   684:                 ! NAMELIST 変数群
   685:                 ! NAMELIST group name
   686:                 !
   687:                 namelist /rad_short_income_nml/                                     &
   688:                   & FlagRadSynchronous,                                             &
   689:                   & FlagAnnualMean, FlagDiurnalMean, FlagPerpetual,                 &
   690:                   & PerpDelDeg, PerpDistFromStarScld,                               &
   691:                   & EpsOrb,                                                         &
   692:                   & PerLonFromVE,                                                   &
   693:                   & LonFromVEAtEpoch,                                               &
   694:                   & Eccentricity,                                                   &
   695:                   & TimeAtEpoch,                                                    &
   696:                   & EpochYear, EpochMonth, EpochDay, EpochHour, EpochMin, EpochSec, &
   697:                   & MaxItrEccAnomaly, ThreEccAnomalyError,                          &
   698:                   & IncomAIns, IncomBIns, IncomAZet, IncomBZet,                     &
   699:                   & FlagSpecifySolDay, SolDayValue, SolDayUnit
   700:                       !
   701:                       ! デフォルト値については初期化手続 "rad_short_income#RadShortIncomeInit" 
   702:                       ! のソースコードを参照のこと. 
   703:                       !
   704:                       ! Refer to source codes in the initialization procedure
   705:                       ! "rad_short_income#RadShortIncomeInit" for the default values. 
   706:                       !
   707:             
   708:                 ! 実行文 ; Executable statement
   709:                 !
   710:             
   711:                 if ( rad_short_income_inited ) return
   712:             
   713:             
   714:                 ! デフォルト値の設定
   715:                 ! Default values settings
   716:                 !
   717:                 FlagRadSynchronous       = .false.
   718:                 FlagAnnualMean           = .true.
   719:                 FlagDiurnalMean          = .true.
   720:                 FlagPerpetual            = .false.
   721:             
   722:                 !---
   723:             
   724:                 PerpDelDeg               = 0.0_DP
   725:                 PerpDistFromStarScld     = 1.0_DP
   726:             
   727:                 !---
   728:             
   729:                 EpsOrb               =   23.5_DP    ! Earth-like value
   730:                 PerLonFromVE         =    0.0_DP
   731:                 LonFromVEAtEpoch     =  280.0_DP    ! This value results in the fact that the planet
   732:                                                     ! is located at the position of vernal equinox 
   733:                                                     ! at 80 days after calculation with the use of 
   734:                                                     ! "360day" calendar.
   735:                 Eccentricity         =    0.0_DP
   736:                 TimeAtEpoch          =    0.0_DP
   737:                 EpochYear            =   -1
   738:                 EpochMonth           =   -1
   739:                 EpochDay             =   -1
   740:                 EpochHour            =   -1
   741:                 EpochMin             =   -1
   742:                 EpochSec             =   -1.0_DP
   743:             
   744:                 !---
   745:             
   746:                 ! Sample values for the Earth
   747:                 !  References: 
   748:                 !    Duffett-Smith, P., Practical astronomy with your calculator Third Edition, 
   749:                 !    Cambridge University Press, pp.185, 1988.
   750:                 !
   751:             !!$    EpsOrb               =   23.44_DP                ! Rika nenpyo (Chronological 
   752:             !!$                                                     ! Scientific Tables 2010)
   753:             !!$    PerLonFromVE         =  102.768413_DP + 180.0_DP ! Duffett-Smith (1988), p.105
   754:             !!$                                                     ! modified (plus 180 degrees)
   755:             !!$    LonFromVEAtEpoch     =   99.403308_DP + 180.0_DP ! Duffett-Smith (1988), p.105
   756:             !!$                                                     ! modified (plus 180 degrees)
   757:             !!$    Eccentricity         =    0.016713_DP            ! Duffett-Smith (1988), p.105
   758:             !!$    TimeAtEpoch          =   -1.0_DP                 ! EpochXXX written below are used 
   759:             !!$                                                     ! because this is negative.
   760:             !!$    EpochYear            = 1990                      ! Duffett-Smith (1988), p.105
   761:             !!$    EpochMonth           =    1
   762:             !!$    EpochDay             =    1
   763:             !!$    EpochHour            =    0
   764:             !!$    EpochMin             =    0
   765:             !!$    EpochSec             =    0.0_DP
   766:                 !---
   767:             
   768:                 ! Sample values for Mars
   769:                 !  References: 
   770:                 !    Allison, M., Geophys. Res. Lett., 24, 1967-1970, 1997.
   771:                 !
   772:             !!$    EpsOrb               =   25.19_DP              ! Allison (1997)
   773:             !!$    PerLonFromVE         =  250.98_DP              ! Allison (1997) (modified)
   774:             !!$    LonFromVEAtEpoch     =  -10.342_DP             ! Arbitrarily set for clarity
   775:             !!$                                                   ! This results in Ls ~ 0 at Time = 0
   776:             !!$    Eccentricity         =    0.0934_DP            ! Allison (1997), value at epoch J2000
   777:             !!$    TimeAtEpoch          =    0.0_DP               ! Arbitrarily set for clarity
   778:             !!$    EpochYear            =   -1                    ! not used
   779:             !!$    EpochMonth           =   -1
   780:             !!$    EpochDay             =   -1
   781:             !!$    EpochHour            =   -1
   782:             !!$    EpochMin             =   -1
   783:             !!$    EpochSec             =   -1.0_DP
   784:             
   785:                 !---
   786:             
   787:                 MaxItrEccAnomaly     = 20
   788:                 ThreEccAnomalyError  = 1e-6_DP
   789:             
   790:                 IncomAIns            = 0.127_DP   ! see dcpam document for reference
   791:                 IncomBIns            = 0.183_DP   ! see dcpam document for reference
   792:                 IncomAZet            = 0.410_DP   ! see dcpam document for reference
   793:                 IncomBZet            = 0.590_DP   ! see dcpam document for reference
   794:             
   795:                 FlagSpecifySolDay = .false.
   796:                 SolDayValue       = 0.0_DP
   797:                 SolDayUnit        = 'sec'
   798:             
   799:             
   800:                 ! NAMELIST の読み込み
   801:                 ! NAMELIST is input
   802:                 !
   803:                 if ( trim(namelist_filename) /= '' ) then
   804:                   call FileOpen( unit_nml, &          ! (out)
   805:                     & namelist_filename, mode = 'r' ) ! (in)
   806:             
   807:                   rewind( unit_nml )
   808:                   read( unit_nml, &                ! (in)
   809:                     & nml = rad_short_income_nml, &  ! (out)
   810:                     & iostat = iostat_nml )        ! (out)
   811:                   close( unit_nml )
   812:             
   813:                   call NmlutilMsg( iostat_nml, module_name ) ! (in)
   814:                 end if
   815:             
   816:             
   817:                 if ( ( .not. FlagAnnualMean ) .and. FlagDiurnalMean ) then
   818:                   call MessageNotify( 'E', module_name, &
   819:                     & 'FlagDiurnalMean cannot be true if FlagAnnualMean is false.' )
   820:                 end if
   821:             
   822:             
   823:                 PerpSinDel = sin( PerpDelDeg * PI / 180.0_DP )
   824:             
   825:             
   826:                 FlagUseOfEpochDate = .false.
   827:             
   828:                 if ( TimeAtEpoch < 0.0_DP ) then
   829:                   call DCCalDateCreate(    &
   830:                     & year  = EpochYear,   & ! (in)
   831:                     & month = EpochMonth,  & ! (in)
   832:                     & day   = EpochDay,    & ! (in)
   833:                     & hour  = EpochHour,   & ! (in)
   834:                     & min   = EpochMin,    & ! (in)
   835:                     & sec   = EpochSec,    & ! (in)
   836:                     & date  = EpochDate )    ! (out) optional
   837:             
   838:                   TimeAtEpoch = DCCalDateDifference( &
   839:                     &                                 start_date = InitialDate, &  ! (in)
   840:                     &                                 end_date   = EpochDate    &  ! (in)
   841:                     &                              )
   842:             
   843:                   FlagUseOfEpochDate = .true.
   844:                 end if
   845:             
   846:                 SolDay = DCCalConvertByUnit( SolDayValue, SolDayUnit, 'sec' )
   847:             
   848:                 ! 保存用の変数の割り付け
   849:                 ! Allocate variables for saving
   850:                 !
   851:             
   852:                 ! ヒストリデータ出力のためのへの変数登録
   853:                 ! Register of variables for history data output
   854:                 !
   855:             !!$    call HistoryAutoAddVariable( 'xxxxx' , &
   856:             !!$      & (/ 'lon ', 'lat ', 'sig', 'time'/), &
   857:             !!$      & 'xxxx', 'W m-2' )
   858:             
   859:                 call HistoryAutoAddVariable( 'Decl' , &
   860:                   & (/ 'time'/),                      &
   861:                   & 'declination of the central star', 'degree' )
   862:             
   863:                 call HistoryAutoAddVariable( 'DistFromStarScld' , &
   864:                   & (/ 'time'/),                                  &
   865:                   & 'distance between the central star and the planet', '1' )
   866:             
   867:                 call HistoryAutoAddVariable( 'PlanetLonFromVE' , &
   868:                   & (/ 'time'/),                                 &
   869:                   & 'planetary longitude from the vernal equinox', 'degree' )
   870:             
   871:                 ! 印字 ; Print
   872:                 !
   873:                 call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   874:                 call MessageNotify( 'M', module_name, 'ShortIncomming:' )
   875:                 call MessageNotify( 'M', module_name, '  FlagRadSynchronous       = %b', l = (/ FlagRadSynchronous /) )
   876:                 call MessageNotify( 'M', module_name, '  FlagAnnualMean           = %b', l = (/ FlagAnnualMean            /) )
   877:                 call MessageNotify( 'M', module_name, '  FlagDiurnalMean          = %b', l = (/ FlagDiurnalMean           /) )
   878:                 call MessageNotify( 'M', module_name, '  FlagPerpetual            = %b', l = (/ FlagPerpetual             /) )
   879:                 call MessageNotify( 'M', module_name, '  PerpDelDeg               = %f', d = (/ PerpDelDeg                /) )
   880:                 call MessageNotify( 'M', module_name, '  PerpDistFromStarScld     = %f', d = (/ PerpDistFromStarScld      /) )
   881:                 call MessageNotify( 'M', module_name, '  EpsOrb                   = %f', d = (/ EpsOrb                   /) )
   882:                 call MessageNotify( 'M', module_name, '  PerLonFromVE             = %f', d = (/ PerLonFromVE             /) )
   883:                 call MessageNotify( 'M', module_name, '  Eccentricity             = %f', d = (/ Eccentricity             /) )
   884:             
   885:                 if ( FlagUseOfEpochDate ) then
   886:                   call DCCalDateInquire( date_print, date = EpochDate )
   887:                   call MessageNotify( 'M', module_name, '  EpochDate  = %c', &
   888:                     & c1 = trim(date_print) )
   889:                 end if
   890:                 call MessageNotify( 'M', module_name, '  TimeAtEpoch              = %f', d = (/ TimeAtEpoch              /) )
   891:                 call MessageNotify( 'M', module_name, '  LonFromVEAtEpoch         = %f', d = (/ LonFromVEAtEpoch         /) )
   892:             
   893:                 call MessageNotify( 'M', module_name, '  MaxItrEccAnomaly         = %d', i = (/ MaxItrEccAnomaly         /) )
   894:                 call MessageNotify( 'M', module_name, '  ThreEccAnomalyError      = %f', d = (/ ThreEccAnomalyError      /) )
   895:                 call MessageNotify( 'M', module_name, '  IncomAIns                = %f', d = (/ IncomAIns                /) )
   896:                 call MessageNotify( 'M', module_name, '  IncomBIns                = %f', d = (/ IncomBIns                /) )
   897:                 call MessageNotify( 'M', module_name, '  IncomAZet                = %f', d = (/ IncomAZet                /) )
   898:                 call MessageNotify( 'M', module_name, '  IncomBZet                = %f', d = (/ IncomBZet                /) )
   899:             
   900:                 call MessageNotify( 'M', module_name, '  FlagSpecifySolDay        = %b', l = (/ FlagSpecifySolDay        /) )
   901:                 call MessageNotify( 'M', module_name, '  SolDay                   = %f', d = (/ SolDay                   /) )
   902:             
   903:             
   904:                 call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   905:             
   906:                 rad_short_income_inited = .true.
   907:             
   908:               end subroutine RadShortIncomeInit
   909:             
   910:               !-------------------------------------------------------------------
   911:             
   912:             end module rad_short_income
