Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:39:01 2016
FILE NAME: rad_simple.f90
PROGRAM NAME: rad_simple
DIAGNOSTIC LIST

  LINE  LEVEL( NO.): DIAGNOSTIC MESSAGE

   194  opt  (1593): Loop nest collapsed into one loop.
   194  vec  (   1): Vectorized loop.
   194  vec  (  29): ADB is used for array.: xyz_delatmmass
   194  vec  (  29): ADB is used for array.: xyr_press
   216  opt  (  11): Fused array assignments. :line 216 - 217
   216  opt  (1593): Loop nest collapsed into one loop.
   216  vec  (   4): Vectorized array expression.
   216  vec  (  29): ADB is used for array.: xy_surfemis
   216  vec  (  29): ADB is used for array.: xy_surfalbedolw
   228  warn (  82): Name "solarconst" is not used.
   228  warn (  82): Name "xyz_af" is not used.
   228  warn (  82): Name "xyz_ssa" is not used.
   228  warn (  82): Name "diurnalmeanfactor" is not used.
   228  warn (  82): Name "solarfluxtoa" is not used.
   228  warn (  82): Name "xyr_optdep" is not used.
   228  warn (  82): Name "xy_inangle" is not used.
   228  warn (  82): Name "distfromstarscld" is not used.
   342  warn (  82): Name "iostat_nml" is not used.
   342  warn (  82): Name "unit_nml" is not used.
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:39:01 2016
FILE NAME: rad_simple.f90
PROGRAM NAME: rad_simple
TRANSFORMATION LIST

  LINE                   FORTRAN STATEMENT

     1  != 簡単放射モデル
     2  !
     3  != Simple radiation model
     4  !
     5  ! Authors::   Yoshiyuki O. Takahashi
     6  ! Version::   $Id: rad_simple.f90,v 1.5 2013/05/25 06:47:34 yot Exp $
     7  ! Tag Name::  $Name:  $
     8  ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9  ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10  !
    11  
    12  module rad_simple
    13    !
    14    != 簡単放射モデル
    15    !
    16    != Simple radiation model
    17    !
    18    ! <b>Note that Japanese and English are described in parallel.</b>
    19    !
    20    !
    21    !
    22    ! This is a simple radiation model.
    23    !
    24    !== References
    25    !
    26    !
    27    !
    28    !== Procedures List
    29    !
    30  !!$  ! RadiationFluxDennouAGCM :: 放射フラックスの計算
    31  !!$  ! RadiationDTempDt        :: 放射フラックスによる温度変化の計算
    32  !!$  ! RadiationFluxOutput     :: 放射フラックスの出力
    33  !!$  ! RadiationFinalize       :: 終了処理 (モジュール内部の変数の割り付け解除)
    34  !!$  ! ------------            :: ------------
    35  !!$  ! RadiationFluxDennouAGCM :: Calculate radiation flux
    36  !!$  ! RadiationDTempDt        :: Calculate temperature tendency with radiation flux
    37  !!$  ! RadiationFluxOutput     :: Output radiation fluxes
    38  !!$  ! RadiationFinalize       :: Termination (deallocate variables in this module)
    39    !
    40    !== NAMELIST
    41    !
    42    ! NAMELIST#rad_Simple_nml
    43    !
    44  
    45    ! USE statements
    46    !
    47  
    48    !
    49    ! Kind type parameter
    50    !
    51    use dc_types, only: DP, &      ! Double precision.
    52      &                 STRING, &  ! Strings.
    53      &                 TOKEN      ! Keywords.
    54  
    55    ! 格子点設定
    56    ! Grid points settings
    57    !
    58    use gridset, only: imax, & ! 経度格子点数.
    59                               ! Number of grid points in longitude
    60      &                jmax, & ! 緯度格子点数.
    61                               ! Number of grid points in latitude
    62      &                kmax    ! 鉛直層数.
    63                               ! Number of vertical level
    64  
    65    implicit none
    66  
    67    private
    68  
    69  
    70    ! Private variables
    71    !
    72  !!$  real(DP), save :: SWOptDepAtRefPress
    73  !!$  real(DP), save :: SWRefPress
    74  !!$  real(DP), save :: SWOrd
    75  !!$  real(DP), save :: LWOptDepAtRefPress
    76  !!$  real(DP), save :: LWRefPress
    77  !!$  real(DP), save :: LWOrd
    78  
    79  
    80    ! 公開変数
    81    ! Public variables
    82    !
    83    logical, save, public:: rad_simple_inited = .false.
    84                                ! 初期設定フラグ.
    85                                ! Initialization flag
    86  
    87    public :: RadSimpleFlux
    88    public :: RadSimpleInit
    89  
    90    character(*), parameter:: module_name = 'rad_simple'
    91                                ! モジュールの名称.
    92                                ! Module name
    93    character(*), parameter:: version = &
    94      & '$Name:  $' // &
    95      & '$Id: rad_simple.f90,v 1.5 2013/05/25 06:47:34 yot Exp $'
    96                                ! モジュールのバージョン
    97                                ! Module version
    98  
    99    !--------------------------------------------------------------------------------------
   100  
   101  contains
   102  
   103    !--------------------------------------------------------------------------------------
   104  
   105    subroutine RadSimpleFlux(                                                    &
   106      & xy_SurfAlbedo, xy_SurfTemp, xyr_Press, xyz_Press, xyz_Temp, xyz_QH2OVap, &
   107      & xyr_RadSUwFlux, xyr_RadSDwFlux,                                          &
   108      & xyr_RadLUwFlux, xyr_RadLDwFlux,                                          &
   109      & xyra_DelRadLUwFlux, xyra_DelRadLDwFlux                                   &
   110      & )
   111  
   112  
   113      ! USE statements
   114      !
   115  
   116      ! メッセージ出力
   117      ! Message output
   118      !
   119      use dc_message, only: MessageNotify
   120  
   121      ! 物理・数学定数設定
   122      ! Physical and mathematical constants settings
   123      !
   124      use constants0, only: &
   125        & PI                    ! $ \pi $ .
   126                                ! 円周率.  Circular constant
   127  
   128      !
   129      ! Physical constants settings
   130      !
   131      use constants, only: Grav     ! $ g $ [m s-2].
   132                                    !
   133                                    ! Gravitational acceleration
   134  
   135      ! 座標データ設定
   136      ! Axes data settings
   137      !
   138      use axesset, only : y_Lat
   139  
   140      ! 簡単短波放射モデル Ver. 2.0
   141      ! simple short wave radiation model Ver. 2.0
   142      !
   143      use rad_simple_SW_V2_0, only : RadSimpleSWV20Flux
   144  
   145      ! 長波フラックスの計算
   146      ! Calculate long wave flux
   147      !
   148      use rad_simple_LW, only : RadSimpleLWFlux
   149  
   150  
   151      real(DP), intent(in ) :: xy_SurfAlbedo( 0:imax-1, 1:jmax )
   152      real(DP), intent(in ) :: xy_SurfTemp  ( 0:imax-1, 1:jmax )
   153      real(DP), intent(in ) :: xyr_Press    ( 0:imax-1, 1:jmax, 0:kmax )
   154      real(DP), intent(in ) :: xyz_Press    ( 0:imax-1, 1:jmax, 1:kmax )
   155      real(DP), intent(in ) :: xyz_Temp     ( 0:imax-1, 1:jmax, 1:kmax )
   156      real(DP), intent(in ) :: xyz_QH2OVap  ( 0:imax-1, 1:jmax, 1:kmax )
   157      real(DP), intent(out) :: xyr_RadSUwFlux    ( 0:imax-1, 1:jmax, 0:kmax )
   158      real(DP), intent(out) :: xyr_RadSDwFlux    ( 0:imax-1, 1:jmax, 0:kmax )
   159      real(DP), intent(out) :: xyr_RadLUwFlux    (0:imax-1, 1:jmax, 0:kmax)
   160      real(DP), intent(out) :: xyr_RadLDwFlux    (0:imax-1, 1:jmax, 0:kmax)
   161      real(DP), intent(out) :: xyra_DelRadLUwFlux(0:imax-1, 1:jmax, 0:kmax, 0:1)
   162      real(DP), intent(out) :: xyra_DelRadLDwFlux(0:imax-1, 1:jmax, 0:kmax, 0:1)
   163  
   164  
   165      ! Work variables
   166      !
   167      real(DP) :: DistFromStarScld
   168                                 ! Distance between the central star and the planet
   169      real(DP) :: DiurnalMeanFactor
   170  
   171      real(DP) :: SolarConst
   172      real(DP) :: SolarFluxTOA
   173  !!$    real(DP) :: QeRatio
   174      real(DP) :: xyz_SSA       (0:imax-1, 1:jmax, 1:kmax)
   175      real(DP) :: xyz_AF        (0:imax-1, 1:jmax, 1:kmax)
   176      real(DP) :: xy_InAngle    (0:imax-1, 1:jmax)
   177      real(DP) :: xyz_DelAtmMass(0:imax-1, 1:jmax, 1:kmax)
   178      real(DP) :: xyr_OptDep    (0:imax-1, 1:jmax, 0:kmax)
   179  
   180      real(DP) :: xy_SurfAlbedoLW(0:imax-1, 1:jmax)
   181      real(DP) :: xy_SurfEmis    (0:imax-1, 1:jmax)
   182  
   183      integer  :: k
   184  
   185  
   186      ! 初期化
   187      ! Initialization
   188      !
   189      if ( .not. rad_Simple_inited ) then
   190        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   191      end if
   192  
   193  
   194      do k = 1, kmax
   195        xyz_DelAtmMass(:,:,k) = ( xyr_Press(:,:,k-1) - xyr_Press(:,:,k ) ) / Grav
   196      end do
     .        d1 = 1.D0/grav                                                    
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do k = 1, kmax*jmax*imax                                          
     .           xyz_delatmmass(k-1,1,1) = (xyr_press(k-1,1,0)-xyr_press(k-1,1,1
     .       1      ))*d1                                                       
     .        enddo                                                             
   197  
   198  
   199      ! Short wave radiation
   200      !
   201  
   202      ! 簡単短波放射モデル Ver. 2.0
   203      ! simple short wave radiation model Ver. 2.0
   204      !
   205      call RadSimpleSWV20Flux(                                     &
   206        & xy_SurfAlbedo,                                           &
   207        & xyz_Press,                                               &
   208        & xyz_DelAtmMass, xyz_QH2OVap,                             &
   209        & xyr_RadSUwFlux, xyr_RadSDwFlux                           &
   210        & )
   211  
   212  
   213      ! Long wave radiation
   214      !
   215  
   216      xy_SurfAlbedoLW = 0.0_DP
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t284 = 1, xy_surfalbedolw.DSC.U2*xy_surfalbedolw.DSC.U1 +      
     .       1   xy_surfalbedolw.DSC.U2                                         
     .           xy_surfalbedolw(t284-1,1) = 0.0000000000000000e+000            
     .           xy_surfemis(t284-1,1) = 1.00000000000000e+000                  
     .        enddo                                                             
   217      xy_SurfEmis     = 1.0_DP
   218  
   219      call RadSimpleLWFlux(                                         &
   220        & xy_SurfAlbedoLW, xy_SurfEmis,                             & ! (in)
   221        & xyr_Press, xyz_Press, xyz_Temp, xy_SurfTemp,              & ! (in)
   222        & xyz_DelAtmMass, xyz_QH2OVap,                              & ! (in)
   223        & xyr_RadLUwFlux, xyr_RadLDwFlux,                           & ! (out)
   224        & xyra_DelRadLUwFlux, xyra_DelRadLDwFlux                    & ! (out)
   225        & )
   226  
   227  
   228    end subroutine RadSimpleFlux
   229  
   230    !--------------------------------------------------------------------------------------
   231  
   232    subroutine RadSimpleInit
   233  
   234      ! ファイル入出力補助
   235      ! File I/O support
   236      !
   237      use dc_iounit, only: FileOpen
   238  
   239      ! NAMELIST ファイル入力に関するユーティリティ
   240      ! Utilities for NAMELIST file input
   241      !
   242      use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid
   243  
   244      ! メッセージ出力
   245      ! Message output
   246      !
   247      use dc_message, only: MessageNotify
   248  
   249      ! 簡単短波放射モデル Ver. 2.0
   250      ! simple short wave radiation model Ver. 2.0
   251      !
   252      use rad_simple_SW_V2_0, only : RadSimpleSWV20Init
   253  
   254      ! 放射フラックス (簡単長波バンドモデル)
   255      ! Radiation flux (simple longwave band model)
   256      !
   257      use rad_simple_LW, only : RadSimpleLWInit
   258  
   259  
   260      ! 宣言文 ; Declaration statements
   261      !
   262  
   263      integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号.
   264                                ! Unit number for NAMELIST file open
   265      integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT.
   266                                ! IOSTAT of NAMELIST read
   267  
   268      ! NAMELIST 変数群
   269      ! NAMELIST group name
   270      !
   271  !!$    namelist /rad_Simple_nml/ &
   272  !!$      & SWOptDepAtRefPress, SWRefPress, SWOrd, &
   273  !!$      & LWOptDepAtRefPress, LWRefPress, LWOrd
   274            !
   275            ! デフォルト値については初期化手続 "rad_Simple#RadSimpleInit"
   276            ! のソースコードを参照のこと.
   277            !
   278            ! Refer to source codes in the initialization procedure
   279            ! "rad_Simple#RadSimpleInit" for the default values.
   280            !
   281  
   282      if ( rad_Simple_inited ) return
   283  
   284  
   285      ! デフォルト値の設定
   286      ! Default values settings
   287      !
   288  !!$    SWOptDepAtRefPress =  3.0_DP
   289  !!$    SWRefPress         =  3.0d5
   290  !!$    SWOrd              =  1.0_DP
   291  !!$
   292  !!$    LWOptDepAtRefPress = 80.0_DP
   293  !!$    LWRefPress         =  3.0d5
   294  !!$    LWOrd              =  2.0_DP
   295  
   296  
   297      ! NAMELIST の読み込み
   298      ! NAMELIST is input
   299      !
   300  !!$    if ( trim(namelist_filename) /= '' ) then
   301  !!$      call FileOpen( unit_nml, &          ! (out)
   302  !!$        & namelist_filename, mode = 'r' ) ! (in)
   303  !!$
   304  !!$      rewind( unit_nml )
   305  !!$      read( unit_nml,                     & ! (in)
   306  !!$        & nml = rad_Simple_nml,           & ! (out)
   307  !!$        & iostat = iostat_nml )             ! (out)
   308  !!$      close( unit_nml )
   309  !!$
   310  !!$      call NmlutilMsg( iostat_nml, module_name ) ! (in)
   311  !!$    end if
   312  
   313  
   314      ! Initialization of modules used in this module
   315      !
   316  
   317      ! 簡単短波放射モデル Ver. 2.0
   318      ! simple short wave radiation model Ver. 2.0
   319      !
   320      call RadSimpleSWV20Init
   321  
   322      ! 放射フラックス (簡単長波バンドモデル)
   323      ! Radiation flux (simple longwave band model)
   324      !
   325      call RadSimpleLWInit
   326  
   327  
   328      ! 印字 ; Print
   329      !
   330      call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   331  !!$    call MessageNotify( 'M', module_name, 'SWOptDepAtRefPress = %f', d = (/ SWOptDepAtRefPress /) )
   332  !!$    call MessageNotify( 'M', module_name, 'SWRefPress         = %f', d = (/ SWRefPress /) )
   333  !!$    call MessageNotify( 'M', module_name, 'SWOrd              = %f', d = (/ SWOrd /) )
   334  !!$    call MessageNotify( 'M', module_name, 'LWOptDepAtRefPress = %f', d = (/ LWOptDepAtRefPress /) )
   335  !!$    call MessageNotify( 'M', module_name, 'LWRefPress         = %f', d = (/ LWRefPress /) )
   336  !!$    call MessageNotify( 'M', module_name, 'LWOrd              = %f', d = (/ LWOrd /) )
   337      call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   338  
   339  
   340      rad_Simple_inited = .true.
   341  
   342    end subroutine RadSimpleInit
   343  
   344    !--------------------------------------------------------------------------------------
   345  
   346  end module rad_simple
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:39:01 2016
FILE NAME: rad_simple.f90
PROGRAM NAME: rad_simple
FORMAT LIST

  LINE    LOOP      FORTRAN STATEMENT

     1:             != 簡単放射モデル
     2:             !
     3:             != Simple radiation model
     4:             !
     5:             ! Authors::   Yoshiyuki O. Takahashi
     6:             ! Version::   $Id: rad_simple.f90,v 1.5 2013/05/25 06:47:34 yot Exp $
     7:             ! Tag Name::  $Name:  $
     8:             ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9:             ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10:             !
    11:             
    12:             module rad_simple
    13:               !
    14:               != 簡単放射モデル
    15:               !
    16:               != Simple radiation model
    17:               !
    18:               ! <b>Note that Japanese and English are described in parallel.</b>
    19:               !
    20:               ! 
    21:               !
    22:               ! This is a simple radiation model.
    23:               !
    24:               !== References
    25:               !
    26:               !
    27:               !
    28:               !== Procedures List
    29:               !
    30:             !!$  ! RadiationFluxDennouAGCM :: 放射フラックスの計算
    31:             !!$  ! RadiationDTempDt        :: 放射フラックスによる温度変化の計算
    32:             !!$  ! RadiationFluxOutput     :: 放射フラックスの出力
    33:             !!$  ! RadiationFinalize       :: 終了処理 (モジュール内部の変数の割り付け解除)
    34:             !!$  ! ------------            :: ------------
    35:             !!$  ! RadiationFluxDennouAGCM :: Calculate radiation flux
    36:             !!$  ! RadiationDTempDt        :: Calculate temperature tendency with radiation flux
    37:             !!$  ! RadiationFluxOutput     :: Output radiation fluxes
    38:             !!$  ! RadiationFinalize       :: Termination (deallocate variables in this module)
    39:               !
    40:               !== NAMELIST
    41:               !
    42:               ! NAMELIST#rad_Simple_nml
    43:               !
    44:             
    45:               ! USE statements
    46:               !
    47:             
    48:               !
    49:               ! Kind type parameter
    50:               !
    51:               use dc_types, only: DP, &      ! Double precision.
    52:                 &                 STRING, &  ! Strings.
    53:                 &                 TOKEN      ! Keywords.
    54:             
    55:               ! 格子点設定
    56:               ! Grid points settings
    57:               !
    58:               use gridset, only: imax, & ! 経度格子点数.
    59:                                          ! Number of grid points in longitude
    60:                 &                jmax, & ! 緯度格子点数.
    61:                                          ! Number of grid points in latitude
    62:                 &                kmax    ! 鉛直層数.
    63:                                          ! Number of vertical level
    64:             
    65:               implicit none
    66:             
    67:               private
    68:             
    69:             
    70:               ! Private variables
    71:               !
    72:             !!$  real(DP), save :: SWOptDepAtRefPress
    73:             !!$  real(DP), save :: SWRefPress
    74:             !!$  real(DP), save :: SWOrd
    75:             !!$  real(DP), save :: LWOptDepAtRefPress
    76:             !!$  real(DP), save :: LWRefPress
    77:             !!$  real(DP), save :: LWOrd
    78:             
    79:             
    80:               ! 公開変数
    81:               ! Public variables
    82:               !
    83:               logical, save, public:: rad_simple_inited = .false.
    84:                                           ! 初期設定フラグ.
    85:                                           ! Initialization flag
    86:             
    87:               public :: RadSimpleFlux
    88:               public :: RadSimpleInit
    89:             
    90:               character(*), parameter:: module_name = 'rad_simple'
    91:                                           ! モジュールの名称.
    92:                                           ! Module name
    93:               character(*), parameter:: version = &
    94:                 & '$Name:  $' // &
    95:                 & '$Id: rad_simple.f90,v 1.5 2013/05/25 06:47:34 yot Exp $'
    96:                                           ! モジュールのバージョン
    97:                                           ! Module version
    98:             
    99:               !--------------------------------------------------------------------------------------
   100:             
   101:             contains
   102:             
   103:               !--------------------------------------------------------------------------------------
   104:             
   105:               subroutine RadSimpleFlux(                                                    &
   106:                 & xy_SurfAlbedo, xy_SurfTemp, xyr_Press, xyz_Press, xyz_Temp, xyz_QH2OVap, &
   107:                 & xyr_RadSUwFlux, xyr_RadSDwFlux,                                          &
   108:                 & xyr_RadLUwFlux, xyr_RadLDwFlux,                                          &
   109:                 & xyra_DelRadLUwFlux, xyra_DelRadLDwFlux                                   &
   110:                 & )
   111:             
   112:             
   113:                 ! USE statements
   114:                 !
   115:             
   116:                 ! メッセージ出力
   117:                 ! Message output
   118:                 !
   119:                 use dc_message, only: MessageNotify
   120:             
   121:                 ! 物理・数学定数設定
   122:                 ! Physical and mathematical constants settings
   123:                 !
   124:                 use constants0, only: &
   125:                   & PI                    ! $ \pi $ .
   126:                                           ! 円周率.  Circular constant
   127:             
   128:                 !
   129:                 ! Physical constants settings
   130:                 !
   131:                 use constants, only: Grav     ! $ g $ [m s-2].
   132:                                               !
   133:                                               ! Gravitational acceleration
   134:             
   135:                 ! 座標データ設定
   136:                 ! Axes data settings
   137:                 !
   138:                 use axesset, only : y_Lat
   139:             
   140:                 ! 簡単短波放射モデル Ver. 2.0
   141:                 ! simple short wave radiation model Ver. 2.0
   142:                 !
   143:                 use rad_simple_SW_V2_0, only : RadSimpleSWV20Flux
   144:             
   145:                 ! 長波フラックスの計算
   146:                 ! Calculate long wave flux
   147:                 !
   148:                 use rad_simple_LW, only : RadSimpleLWFlux
   149:             
   150:             
   151:                 real(DP), intent(in ) :: xy_SurfAlbedo( 0:imax-1, 1:jmax )
   152:                 real(DP), intent(in ) :: xy_SurfTemp  ( 0:imax-1, 1:jmax )
   153:                 real(DP), intent(in ) :: xyr_Press    ( 0:imax-1, 1:jmax, 0:kmax )
   154:                 real(DP), intent(in ) :: xyz_Press    ( 0:imax-1, 1:jmax, 1:kmax )
   155:                 real(DP), intent(in ) :: xyz_Temp     ( 0:imax-1, 1:jmax, 1:kmax )
   156:                 real(DP), intent(in ) :: xyz_QH2OVap  ( 0:imax-1, 1:jmax, 1:kmax )
   157:                 real(DP), intent(out) :: xyr_RadSUwFlux    ( 0:imax-1, 1:jmax, 0:kmax )
   158:                 real(DP), intent(out) :: xyr_RadSDwFlux    ( 0:imax-1, 1:jmax, 0:kmax )
   159:                 real(DP), intent(out) :: xyr_RadLUwFlux    (0:imax-1, 1:jmax, 0:kmax)
   160:                 real(DP), intent(out) :: xyr_RadLDwFlux    (0:imax-1, 1:jmax, 0:kmax)
   161:                 real(DP), intent(out) :: xyra_DelRadLUwFlux(0:imax-1, 1:jmax, 0:kmax, 0:1)
   162:                 real(DP), intent(out) :: xyra_DelRadLDwFlux(0:imax-1, 1:jmax, 0:kmax, 0:1)
   163:             
   164:             
   165:                 ! Work variables
   166:                 !
   167:                 real(DP) :: DistFromStarScld
   168:                                            ! Distance between the central star and the planet
   169:                 real(DP) :: DiurnalMeanFactor
   170:             
   171:                 real(DP) :: SolarConst
   172:                 real(DP) :: SolarFluxTOA
   173:             !!$    real(DP) :: QeRatio
   174:                 real(DP) :: xyz_SSA       (0:imax-1, 1:jmax, 1:kmax)
   175:                 real(DP) :: xyz_AF        (0:imax-1, 1:jmax, 1:kmax)
   176:                 real(DP) :: xy_InAngle    (0:imax-1, 1:jmax)
   177:                 real(DP) :: xyz_DelAtmMass(0:imax-1, 1:jmax, 1:kmax)
   178:                 real(DP) :: xyr_OptDep    (0:imax-1, 1:jmax, 0:kmax)
   179:             
   180:                 real(DP) :: xy_SurfAlbedoLW(0:imax-1, 1:jmax)
   181:                 real(DP) :: xy_SurfEmis    (0:imax-1, 1:jmax)
   182:             
   183:                 integer  :: k
   184:             
   185:             
   186:                 ! 初期化
   187:                 ! Initialization
   188:                 !
   189:                 if ( .not. rad_Simple_inited ) then
   190:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   191:                 end if
   192:             
   193:             
   194: W------>        do k = 1, kmax
   195: |**==== A         xyz_DelAtmMass(:,:,k) = ( xyr_Press(:,:,k-1) - xyr_Press(:,:,k ) ) / Grav
   196: W------         end do
   197:             
   198:             
   199:                 ! Short wave radiation
   200:                 !
   201:             
   202:                 ! 簡単短波放射モデル Ver. 2.0
   203:                 ! simple short wave radiation model Ver. 2.0
   204:                 !
   205:                 call RadSimpleSWV20Flux(                                     &
   206:                   & xy_SurfAlbedo,                                           &
   207:                   & xyz_Press,                                               &
   208:                   & xyz_DelAtmMass, xyz_QH2OVap,                             &
   209:                   & xyr_RadSUwFlux, xyr_RadSDwFlux                           &
   210:                   & )
   211:             
   212:             
   213:                 ! Long wave radiation
   214:                 !
   215:             
   216: *W----->A       xy_SurfAlbedoLW = 0.0_DP
   217: *W----- A       xy_SurfEmis     = 1.0_DP
   218:             
   219:                 call RadSimpleLWFlux(                                         &
   220:                   & xy_SurfAlbedoLW, xy_SurfEmis,                             & ! (in)
   221:                   & xyr_Press, xyz_Press, xyz_Temp, xy_SurfTemp,              & ! (in)
   222:                   & xyz_DelAtmMass, xyz_QH2OVap,                              & ! (in)
   223:                   & xyr_RadLUwFlux, xyr_RadLDwFlux,                           & ! (out)
   224:                   & xyra_DelRadLUwFlux, xyra_DelRadLDwFlux                    & ! (out)
   225:                   & )
   226:             
   227:             
   228:               end subroutine RadSimpleFlux
   229:             
   230:               !--------------------------------------------------------------------------------------
   231:             
   232:               subroutine RadSimpleInit
   233:             
   234:                 ! ファイル入出力補助
   235:                 ! File I/O support
   236:                 !
   237:                 use dc_iounit, only: FileOpen
   238:             
   239:                 ! NAMELIST ファイル入力に関するユーティリティ
   240:                 ! Utilities for NAMELIST file input
   241:                 !
   242:                 use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid
   243:             
   244:                 ! メッセージ出力
   245:                 ! Message output
   246:                 !
   247:                 use dc_message, only: MessageNotify
   248:             
   249:                 ! 簡単短波放射モデル Ver. 2.0
   250:                 ! simple short wave radiation model Ver. 2.0
   251:                 !
   252:                 use rad_simple_SW_V2_0, only : RadSimpleSWV20Init
   253:             
   254:                 ! 放射フラックス (簡単長波バンドモデル)
   255:                 ! Radiation flux (simple longwave band model)
   256:                 !
   257:                 use rad_simple_LW, only : RadSimpleLWInit
   258:             
   259:             
   260:                 ! 宣言文 ; Declaration statements
   261:                 !
   262:             
   263:                 integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号.
   264:                                           ! Unit number for NAMELIST file open
   265:                 integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT.
   266:                                           ! IOSTAT of NAMELIST read
   267:             
   268:                 ! NAMELIST 変数群
   269:                 ! NAMELIST group name
   270:                 !
   271:             !!$    namelist /rad_Simple_nml/ &
   272:             !!$      & SWOptDepAtRefPress, SWRefPress, SWOrd, &
   273:             !!$      & LWOptDepAtRefPress, LWRefPress, LWOrd
   274:                       !
   275:                       ! デフォルト値については初期化手続 "rad_Simple#RadSimpleInit"
   276:                       ! のソースコードを参照のこと.
   277:                       !
   278:                       ! Refer to source codes in the initialization procedure
   279:                       ! "rad_Simple#RadSimpleInit" for the default values.
   280:                       !
   281:             
   282:                 if ( rad_Simple_inited ) return
   283:             
   284:             
   285:                 ! デフォルト値の設定
   286:                 ! Default values settings
   287:                 !
   288:             !!$    SWOptDepAtRefPress =  3.0_DP
   289:             !!$    SWRefPress         =  3.0d5
   290:             !!$    SWOrd              =  1.0_DP
   291:             !!$
   292:             !!$    LWOptDepAtRefPress = 80.0_DP
   293:             !!$    LWRefPress         =  3.0d5
   294:             !!$    LWOrd              =  2.0_DP
   295:             
   296:             
   297:                 ! NAMELIST の読み込み
   298:                 ! NAMELIST is input
   299:                 !
   300:             !!$    if ( trim(namelist_filename) /= '' ) then
   301:             !!$      call FileOpen( unit_nml, &          ! (out)
   302:             !!$        & namelist_filename, mode = 'r' ) ! (in)
   303:             !!$
   304:             !!$      rewind( unit_nml )
   305:             !!$      read( unit_nml,                     & ! (in)
   306:             !!$        & nml = rad_Simple_nml,           & ! (out)
   307:             !!$        & iostat = iostat_nml )             ! (out)
   308:             !!$      close( unit_nml )
   309:             !!$
   310:             !!$      call NmlutilMsg( iostat_nml, module_name ) ! (in)
   311:             !!$    end if
   312:             
   313:             
   314:                 ! Initialization of modules used in this module
   315:                 !
   316:             
   317:                 ! 簡単短波放射モデル Ver. 2.0
   318:                 ! simple short wave radiation model Ver. 2.0
   319:                 !
   320:                 call RadSimpleSWV20Init
   321:             
   322:                 ! 放射フラックス (簡単長波バンドモデル)
   323:                 ! Radiation flux (simple longwave band model)
   324:                 !
   325:                 call RadSimpleLWInit
   326:             
   327:             
   328:                 ! 印字 ; Print
   329:                 !
   330:                 call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   331:             !!$    call MessageNotify( 'M', module_name, 'SWOptDepAtRefPress = %f', d = (/ SWOptDepAtRefPress /) )
   332:             !!$    call MessageNotify( 'M', module_name, 'SWRefPress         = %f', d = (/ SWRefPress /) )
   333:             !!$    call MessageNotify( 'M', module_name, 'SWOrd              = %f', d = (/ SWOrd /) )
   334:             !!$    call MessageNotify( 'M', module_name, 'LWOptDepAtRefPress = %f', d = (/ LWOptDepAtRefPress /) )
   335:             !!$    call MessageNotify( 'M', module_name, 'LWRefPress         = %f', d = (/ LWRefPress /) )
   336:             !!$    call MessageNotify( 'M', module_name, 'LWOrd              = %f', d = (/ LWOrd /) )
   337:                 call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   338:             
   339:             
   340:                 rad_Simple_inited = .true.
   341:             
   342:               end subroutine RadSimpleInit
   343:             
   344:               !--------------------------------------------------------------------------------------
   345:             
   346:             end module rad_simple
