Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:39:01 2016
FILE NAME: rad_simple_LW.f90
PROGRAM NAME: rad_simple_lw
DIAGNOSTIC LIST

  LINE  LEVEL( NO.): DIAGNOSTIC MESSAGE

   263  opt  (1593): Loop nest collapsed into one loop.
   263  vec  (   4): Vectorized array expression.
   263  vec  (  29): ADB is used for array.: xyr_temp
   263  vec  (  29): ADB is used for array.: xyr_press
   263  vec  (  29): ADB is used for array.: xyz_press
   263  vec  (  29): ADB is used for array.: xyz_temp
   268  opt  (1593): Loop nest collapsed into one loop.
   268  vec  (   1): Vectorized loop.
   268  vec  (  29): ADB is used for array.: xyr_temp
   268  vec  (  29): ADB is used for array.: xyr_press
   268  vec  (  29): ADB is used for array.: xyz_press
   268  vec  (  29): ADB is used for array.: xyz_temp
   276  opt  (1593): Loop nest collapsed into one loop.
   276  vec  (   4): Vectorized array expression.
   276  vec  (  29): ADB is used for array.: xyr_temp
   276  vec  (  29): ADB is used for array.: xyz_temp
   280  opt  (  11): Fused array assignments. :line 280 - 281
   280  opt  (1593): Loop nest collapsed into one loop.
   280  vec  (   4): Vectorized array expression.
   280  vec  (  29): ADB is used for array.: xyr_radldwflux
   280  vec  (  29): ADB is used for array.: xyr_radluwflux
   282  opt  (  11): Fused array assignments. :line 282 - 283
   282  opt  (1772): Loop nest fused with following nest(s).
   282  opt  (1593): Loop nest collapsed into one loop.
   282  vec  (   4): Vectorized array expression.
   282  vec  (  29): ADB is used for array.: xyra_delradldwflux
   282  vec  (  29): ADB is used for array.: xyra_delradluwflux
   285  vec  (   3): Unvectorized loop.
   293  opt  (1593): Loop nest collapsed into one loop.
   293  vec  (   4): Vectorized array expression.
   293  vec  (  29): ADB is used for array.: xy_surfintpf
   293  vec  (  29): ADB is used for array.: xy_surftemp
   293  vec  (  29): ADB is used for array.: xy_surfemis
   294  opt  (1593): Loop nest collapsed into one loop.
   294  vec  (   4): Vectorized array expression.
   294  vec  (  29): ADB is used for array.: xyr_intpf
   294  vec  (  29): ADB is used for array.: xyr_temp
   295  opt  (  11): Fused array assignments. :line 295 - 297
   295  vec  (   4): Vectorized array expression.
   295  vec  (  29): ADB is used for array.: xy_intdpfdt1
   295  vec  (  29): ADB is used for array.: xy_intdpfdt0
   295  vec  (  29): ADB is used for array.: xy_surftemp
   295  vec  (  29): ADB is used for array.: xy_surfintpf
   295  vec  (  29): ADB is used for array.: xy_surfemis
   303  opt  (1017): Subroutine call prevents optimization.
   320  opt  (1593): Loop nest collapsed into one loop.
   320  vec  (   4): Vectorized array expression.
   320  vec  (  29): ADB is used for array.: xy_intdpfdt1
   327  opt  (1593): Loop nest collapsed into one loop.
   327  vec  (   4): Vectorized array expression.
   327  vec  (  29): ADB is used for array.: xy_surfintpf
   327  vec  (  29): ADB is used for array.: xy_surfemis
   328  opt  (1593): Loop nest collapsed into one loop.
   328  vec  (   4): Vectorized array expression.
   328  vec  (  29): ADB is used for array.: xyr_intpf
   329  opt  (  11): Fused array assignments. :line 329 - 330
   329  opt  (1593): Loop nest collapsed into one loop.
   329  vec  (   4): Vectorized array expression.
   329  vec  (  29): ADB is used for array.: xy_intdpfdt1
   329  vec  (  29): ADB is used for array.: xy_intdpfdt0
   329  vec  (  29): ADB is used for array.: xy_surfemis
   338  opt  (  11): Fused array assignments. :line 338 - 342
   338  opt  (1593): Loop nest collapsed into one loop.
   338  vec  (   4): Vectorized array expression.
   338  vec  (  29): ADB is used for array.: xyz_qh2ovap
   338  vec  (  29): ADB is used for array.: xyz_delatmmass
   338  vec  (  29): ADB is used for array.: xyz_press
   347  opt  (1592): Outer loop unrolled inside inner loop.
   347  vec  (   4): Vectorized array expression.
   347  vec  (   4): Vectorized array expression.
   356  opt  (  11): Fused array assignments. :line 356 - 357
   356  opt  (1593): Loop nest collapsed into one loop.
   356  vec  (   4): Vectorized array expression.
   356  vec  (  29): ADB is used for array.: xyr_radldwflux
   356  vec  (  29): ADB is used for array.: xyr_raddwflux
   356  vec  (  29): ADB is used for array.: xyr_radluwflux
   356  vec  (  29): ADB is used for array.: xyr_raduwflux
   358  opt  (  11): Fused array assignments. :line 358 - 359
   358  opt  (1772): Loop nest fused with following nest(s).
   358  opt  (1593): Loop nest collapsed into one loop.
   358  vec  (   4): Vectorized array expression.
   358  vec  (  29): ADB is used for array.: xyra_delradldwflux
   358  vec  (  29): ADB is used for array.: xyra_delraddwflux
   358  vec  (  29): ADB is used for array.: xyra_delradluwflux
   358  vec  (  29): ADB is used for array.: xyra_delraduwflux
   477  opt  (  11): Fused array assignments. :line 477 - 478
   477  opt  (1593): Loop nest collapsed into one loop.
   477  vec  (   4): Vectorized array expression.
   477  vec  (  29): ADB is used for array.: xyr_radldwflux
   477  vec  (  29): ADB is used for array.: xyr_radluwflux
   479  opt  (  11): Fused array assignments. :line 479 - 480
   479  opt  (1772): Loop nest fused with following nest(s).
   479  opt  (1593): Loop nest collapsed into one loop.
   479  vec  (   4): Vectorized array expression.
   479  vec  (  29): ADB is used for array.: xyra_delradldwflux
   479  vec  (  29): ADB is used for array.: xyra_delradluwflux
   490  opt  (1593): Loop nest collapsed into one loop.
   490  vec  (   4): Vectorized array expression.
   490  vec  (  29): ADB is used for array.: xy_surfintpf
   490  vec  (  29): ADB is used for array.: xy_surftemp
   490  vec  (  29): ADB is used for array.: xy_surfemis
   491  opt  (1593): Loop nest collapsed into one loop.
   491  vec  (   4): Vectorized array expression.
   491  vec  (  29): ADB is used for array.: xyz_intpf
   491  vec  (  29): ADB is used for array.: xyz_temp
   492  opt  (  11): Fused array assignments. :line 492 - 493
   492  vec  (   4): Vectorized array expression.
   492  vec  (  29): ADB is used for array.: xy_intdpfdt1
   492  vec  (  29): ADB is used for array.: xyz_temp
   492  vec  (  29): ADB is used for array.: xyz_intpf
   492  vec  (  29): ADB is used for array.: xy_intdpfdt0
   492  vec  (  29): ADB is used for array.: xy_surftemp
   492  vec  (  29): ADB is used for array.: xy_surfintpf
   492  vec  (  29): ADB is used for array.: xy_surfemis
   499  opt  (1017): Subroutine call prevents optimization.
   522  opt  (1593): Loop nest collapsed into one loop.
   522  vec  (   4): Vectorized array expression.
   522  vec  (  29): ADB is used for array.: xy_surfintpf
   522  vec  (  29): ADB is used for array.: xy_surfemis
   523  opt  (1593): Loop nest collapsed into one loop.
   523  vec  (   4): Vectorized array expression.
   523  vec  (  29): ADB is used for array.: xyz_intpf
   524  opt  (  11): Fused array assignments. :line 524 - 525
   524  opt  (1593): Loop nest collapsed into one loop.
   524  vec  (   4): Vectorized array expression.
   524  vec  (  29): ADB is used for array.: xy_intdpfdt1
   524  vec  (  29): ADB is used for array.: xy_intdpfdt0
   524  vec  (  29): ADB is used for array.: xy_surfemis
   533  opt  (  11): Fused array assignments. :line 533 - 544
   533  opt  (1593): Loop nest collapsed into one loop.
   533  vec  (   4): Vectorized array expression.
   533  vec  (  29): ADB is used for array.: xyz_qh2ovap
   533  vec  (  29): ADB is used for array.: xyz_delatmmass
   533  vec  (  29): ADB is used for array.: xyz_press
   547  opt  (1593): Loop nest collapsed into one loop.
   547  vec  (   4): Vectorized array expression.
   547  vec  (  29): ADB is used for array.: xyrr_trans
   549  vec  (   3): Unvectorized loop.
   549  vec  (  13): Overhead of loop division is too large.
   550  opt  (1037): Feedback of array elements.
   550  opt  (1036): Potential feedback - use directive if OK.
   550  opt  (1593): Loop nest collapsed into one loop.
   550  vec  (   4): Vectorized array expression.
   550  vec  (  29): ADB is used for array.: xyrr_trans
   552  vec  (   3): Unvectorized loop.
   552  vec  (  13): Overhead of loop division is too large.
   553  opt  (1036): Potential feedback - use directive if OK.
   553  opt  (1593): Loop nest collapsed into one loop.
   553  vec  (   4): Vectorized array expression.
   553  vec  (  29): ADB is used for array.: xyrr_trans
   566  opt  (  11): Fused array assignments. :line 566 - 567
   566  opt  (1593): Loop nest collapsed into one loop.
   566  vec  (   4): Vectorized array expression.
   566  vec  (  29): ADB is used for array.: xyr_radldwflux
   566  vec  (  29): ADB is used for array.: xyr_raddwflux
   566  vec  (  29): ADB is used for array.: xyr_radluwflux
   566  vec  (  29): ADB is used for array.: xyr_raduwflux
   568  opt  (  11): Fused array assignments. :line 568 - 569
   568  opt  (1772): Loop nest fused with following nest(s).
   568  opt  (1593): Loop nest collapsed into one loop.
   568  vec  (   4): Vectorized array expression.
   568  vec  (  29): ADB is used for array.: xyra_delradldwflux
   568  vec  (  29): ADB is used for array.: xyra_delraddwflux
   568  vec  (  29): ADB is used for array.: xyra_delradluwflux
   568  vec  (  29): ADB is used for array.: xyra_delraduwflux
   727  vec  (   4): Vectorized array expression.
   727  vec  (  29): ADB is used for array.: wnbnds
   728  opt  (  11): Fused array assignments. :line 728 - 733
   728  vec  (   4): Vectorized array expression.
   728  vec  (  29): ADB is used for array.: refpressh2ovap
   728  vec  (  29): ADB is used for array.: pressscaleindh2ovap
   728  vec  (  29): ADB is used for array.: abscoefh2ovap
   728  vec  (  29): ADB is used for array.: refpressdrycom
   728  vec  (  29): ADB is used for array.: pressscaleinddrycom
   728  vec  (  29): ADB is used for array.: abscoefdrycom
   735  opt  (  11): Fused array assignments. :line 735 - 741
   770  vec  (   4): Vectorized array expression.
   770  vec  (  29): ADB is used for array.: a_wnbnds
   770  vec  (  29): ADB is used for array.: wnbnds
   772  opt  (  11): Fused array assignments. :line 772 - 779
   772  vec  (   4): Vectorized array expression.
   772  vec  (  29): ADB is used for array.: a_refpressh2ovap
   772  vec  (  29): ADB is used for array.: refpressh2ovap
   772  vec  (  29): ADB is used for array.: a_pressscaleindh2ovap
   772  vec  (  29): ADB is used for array.: pressscaleindh2ovap
   772  vec  (  29): ADB is used for array.: a_abscoefh2ovap
   772  vec  (  29): ADB is used for array.: abscoefh2ovap
   772  vec  (  29): ADB is used for array.: a_refpressdrycom
   772  vec  (  29): ADB is used for array.: refpressdrycom
   772  vec  (  29): ADB is used for array.: a_pressscaleinddrycom
   772  vec  (  29): ADB is used for array.: pressscaleinddrycom
   772  vec  (  29): ADB is used for array.: a_abscoefdrycom
   772  vec  (  29): ADB is used for array.: abscoefdrycom
   816  vec  (   3): Unvectorized loop.
   817  opt  (1017): Subroutine call prevents optimization.
   817  vec  (  10): Vectorization obstructive procedure reference.:messagenotifyc
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:39:01 2016
FILE NAME: rad_simple_LW.f90
PROGRAM NAME: rad_simple_lw
TRANSFORMATION LIST

  LINE                   FORTRAN STATEMENT

     1  != 放射フラックス (簡単長波バンドモデル)
     2  !
     3  != Radiation flux (simple longwave band model)
     4  !
     5  ! Authors::   Yoshiyuki O. Takahashi
     6  ! Version::   $Id: rad_simple_LW.f90,v 1.3 2013/05/25 06:47:33 yot Exp $
     7  ! Tag Name::  $Name:  $
     8  ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9  ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10  !
    11  
    12  module rad_simple_LW
    13    !
    14    != 放射フラックス (簡単長波バンドモデル)
    15    !
    16    != Radiation flux (simple longwave band model)
    17    !
    18    ! <b>Note that Japanese and English are described in parallel.</b>
    19    !
    20    ! 温度, 比湿, 気圧から, 放射フラックスを計算する放射モデルです.
    21    !
    22    ! This is a radiation model that calculates radiation flux from
    23    ! temperature, specific humidity, and air pressure.
    24    !
    25    !== References
    26    !
    27    !
    28    !
    29    !== Procedures List
    30    !
    31    ! RadSimpleLWFlux     :: 放射フラックスの計算
    32  !!$  ! RadSimpleLWFinalize :: 終了処理 (モジュール内部の変数の割り付け解除)
    33    ! ------------------- :: ------------
    34    ! RadSimpleLWFlux     :: Calculate radiation flux
    35  !!$  ! RadSimpleLWFinalize :: Termination (deallocate variables in this module)
    36    !
    37    !== NAMELIST
    38    !
    39    ! NAMELIST#rad_Simple_LW_nml
    40    !
    41  
    42    ! モジュール引用 ; USE statements
    43    !
    44  
    45    ! 格子点設定
    46    ! Grid points settings
    47    !
    48    use gridset, only: imax, & ! 経度格子点数.
    49                               ! Number of grid points in longitude
    50      &                jmax, & ! 緯度格子点数.
    51                               ! Number of grid points in latitude
    52      &                kmax    ! 鉛直層数.
    53                               ! Number of vertical level
    54  
    55    ! 種別型パラメタ
    56    ! Kind type parameter
    57    !
    58    use dc_types, only: DP, &      ! 倍精度実数型. Double precision.
    59      &                 STRING, &  ! 文字列.       Strings.
    60      &                 TOKEN      ! キーワード.   Keywords.
    61  
    62    ! NAMELIST ファイル入力に関するユーティリティ
    63    ! Utilities for NAMELIST file input
    64    !
    65    use namelist_util, only: MaxNmlArySize
    66                                ! NAMELIST から読み込む配列の最大サイズ.
    67                                ! Maximum size of arrays loaded from NAMELIST
    68  
    69    ! メッセージ出力
    70    ! Message output
    71    !
    72    use dc_message, only: MessageNotify
    73  
    74    ! リスタートデータ出力
    75    ! Restart data output
    76    !
    77    use gtool_history, only: GT_HISTORY
    78  
    79    ! 宣言文 ; Declaration statements
    80    !
    81    implicit none
    82    private
    83  
    84    ! 公開手続き
    85    ! Public procedure
    86    !
    87    public:: RadSimpleLWFlux
    88    public:: RadSimpleLWInit
    89  
    90    ! 公開変数
    91    ! Public variables
    92    !
    93    logical, save :: rad_simple_LW_inited = .false.
    94                                ! 初期設定フラグ.
    95                                ! Initialization flag
    96  
    97  
    98    ! 非公開変数
    99    ! Private variables
   100    !
   101    logical, save:: Old_Flux_saved = .false.
   102                                ! 一度計算したフラックスを保存したことを示すフラグ.
   103                                ! Flag for saving of flux calculated once
   104  
   105    integer , save:: nbmax
   106                                ! 長波バンド数.
   107                                ! Number of long wave band
   108    real(DP), save:: a_WNBnds(0:MaxNmlArySize)
   109                                !
   110                                ! Wavenumber bounds for bands
   111    real(DP), save:: a_AbsCoefDryCom(1:MaxNmlArySize)
   112                                ! $ \bar{k}_R $ . 空気の吸収係数
   113                                ! Absorption coefficient of dry component
   114    real(DP), save:: a_PressScaleIndDryCom(1:MaxNmlArySize)
   115                                !
   116                                ! Pressure scaling index for dry component
   117    real(DP), save:: a_RefPressDryCom(1:MaxNmlArySize)
   118                                !
   119                                ! Reference pressure for dry component.
   120    real(DP), save:: a_AbsCoefH2OVap(1:MaxNmlArySize)
   121                                ! $ k_R $ . 水の吸収係数
   122                                ! Absorption coefficient of water vapor
   123    real(DP), save:: a_PressScaleIndH2OVap(1:MaxNmlArySize)
   124                                !
   125                                ! Pressure scaling index for water vapor
   126    real(DP), save:: a_RefPressH2OVap(1:MaxNmlArySize)
   127                                !
   128                                ! Reference pressure for water vapor
   129    real(DP), save:: DiffFact
   130                                !
   131                                ! Diffusivity factor
   132    real(DP), save:: RadActDryComMMR
   133                                !
   134                                ! Mass mixing ratio of radiative active dry component
   135  
   136    integer , save:: NumGaussNode
   137  
   138  
   139    character(*), parameter:: module_name = 'rad_simple_LW'
   140                                ! モジュールの名称.
   141                                ! Module name
   142    character(*), parameter:: version = &
   143      & '$Name:  $' // &
   144      & '$Id: rad_simple_LW.f90,v 1.3 2013/05/25 06:47:33 yot Exp $'
   145                                ! モジュールのバージョン
   146                                ! Module version
   147  
   148  contains
   149  
   150    !--------------------------------------------------------------------------------------
   151  
   152    subroutine RadSimpleLWFlux(                                         &
   153      & xy_SurfAlbedo, xy_SurfEmis,                                     & ! (in)
   154      & xyr_Press, xyz_Press, xyz_Temp, xy_SurfTemp,                    & ! (in)
   155      & xyz_DelAtmMass, xyz_QH2OVap,                                    & ! (in)
   156      & xyr_RadLUwFlux, xyr_RadLDwFlux,                                 & ! (out)
   157      & xyra_DelRadLUwFlux, xyra_DelRadLDwFlux                          & ! (out)
   158      & )
   159      !
   160      ! 長波フラックスの計算
   161      !
   162      ! Calculate long wave flux
   163      !
   164  
   165      ! モジュール引用 ; USE statements
   166      !
   167  
   168      ! 物理・数学定数設定
   169      ! Physical and mathematical constants settings
   170      !
   171      use constants0, only: &
   172        & PI,               &   ! $ \pi $ .
   173                                ! 円周率.  Circular constant
   174        & StB                   ! $ \sigma_{SB} $ .
   175                                ! ステファンボルツマン定数.
   176                                ! Stefan-Boltzmann constant
   177  
   178      ! プランク関数の計算
   179      ! Calculate Planck function
   180      !
   181      use planck_func, only : Integ_PF_GQ_Array3D, Integ_PF_GQ_Array2D, Integ_DPFDT_GQ_Array2D
   182  
   183      ! 散乱を無視した放射伝達方程式
   184      ! Radiative transfer equation without considering scattering
   185      !
   186      use rad_rte_nonscat, only : RadRTENonScatMonoSemiAnal
   187  
   188  
   189      ! 宣言文 ; Declaration statements
   190      !
   191      real(DP), intent(in):: xy_SurfAlbedo     (0:imax-1, 1:jmax)
   192                                !
   193                                ! Surface albedo
   194      real(DP), intent(in):: xy_SurfEmis       (0:imax-1, 1:jmax)
   195                                ! 地表面射出率.
   196                                ! Surface emissivity
   197      real(DP), intent(in):: xyr_Press         (0:imax-1, 1:jmax, 0:kmax)
   198                                ! $ P $ .     圧力. Pressure
   199      real(DP), intent(in):: xyz_Press         (0:imax-1, 1:jmax, 1:kmax)
   200                                ! $ P $ .     圧力. Pressure
   201      real(DP), intent(in):: xyz_Temp          (0:imax-1, 1:jmax, 1:kmax)
   202                                ! $ T $ .     温度. Temperature
   203      real(DP), intent(in):: xy_SurfTemp       (0:imax-1, 1:jmax)
   204                                ! 地表面温度.
   205                                ! Surface temperature
   206      real(DP), intent(in):: xyz_DelAtmMass    (0:imax-1, 1:jmax, 1:kmax)
   207                                !
   208                                ! Atmospheric mass of layers
   209      real(DP), intent(in):: xyz_QH2OVap       (0:imax-1, 1:jmax, 1:kmax)
   210                                !
   211                                ! Specific humidity
   212      real(DP), intent(out):: xyr_RadLUwFlux     (0:imax-1, 1:jmax, 0:kmax)
   213                                ! 長波フラックス.
   214                                ! Upward longwave flux
   215      real(DP), intent(out):: xyr_RadLDwFlux     (0:imax-1, 1:jmax, 0:kmax)
   216                                ! 長波フラックス.
   217                                ! Downward longwave flux
   218      real(DP), intent(out):: xyra_DelRadLUwFlux (0:imax-1, 1:jmax, 0:kmax, 0:1)
   219                                ! 長波地表温度変化.
   220                                !
   221      real(DP), intent(out):: xyra_DelRadLDwFlux (0:imax-1, 1:jmax, 0:kmax, 0:1)
   222                                ! 長波地表温度変化.
   223                                !
   224  
   225      ! 作業変数
   226      ! Work variables
   227      !
   228      real(DP) :: xyr_Temp    (0:imax-1, 1:jmax, 0:kmax)
   229      real(DP) :: xyr_IntPF   (0:imax-1, 1:jmax, 0:kmax)
   230      real(DP) :: xy_SurfIntPF(0:imax-1, 1:jmax)
   231      real(DP) :: xy_IntDPFDT0(0:imax-1, 1:jmax)
   232      real(DP) :: xy_IntDPFDT1(0:imax-1, 1:jmax)
   233  
   234      real(DP) :: xyz_DelOptDepDryCom(0:imax-1, 1:jmax, 1:kmax)
   235      real(DP) :: xyz_DelOptDepH2OVap(0:imax-1, 1:jmax, 1:kmax)
   236  
   237      real(DP) :: xyr_RadUwFlux     (0:imax-1, 1:jmax, 0:kmax)
   238                                ! 長波フラックス.
   239                                ! Upward longwave flux
   240      real(DP) :: xyr_RadDwFlux     (0:imax-1, 1:jmax, 0:kmax)
   241                                ! 長波フラックス.
   242                                ! Downward longwave flux
   243      real(DP) :: xyra_DelRadUwFlux (0:imax-1, 1:jmax, 0:kmax, 0:1)
   244                                ! 長波地表温度変化.
   245                                !
   246      real(DP) :: xyra_DelRadDwFlux (0:imax-1, 1:jmax, 0:kmax, 0:1)
   247                                ! 長波地表温度変化.
   248                                !
   249  
   250      real(DP) :: WNs
   251      real(DP) :: WNe
   252  
   253      integer:: k               ! 鉛直方向に回る DO ループ用作業変数
   254                                ! Work variables for DO loop in vertical direction
   255      integer:: n               ! 波長について回る DO ループ用作業変数
   256                                ! Work variables for DO loop in wavenumber bands
   257  
   258      ! 実行文 ; Executable statement
   259      !
   260  
   261  
   262      k = 0
   263      xyr_Temp(:,:,k) =                                    &
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t588 = 1, jmax*imax                                            
     .           xyr_temp(t588-1,1,0) = (xyz_temp(t588-1,1,2)-xyz_temp(t588-1,1,
     .       1      1))/dlog(xyz_press(t588-1,1,2)/xyz_press(t588-1,1,1))*dlog( 
     .       2      xyr_press(t588-1,1,0)/xyz_press(t588-1,1,1)) + xyz_temp(t588
     .       3      -1,1,1)                                                     
     .        enddo                                                             
   264        &      ( xyz_Temp (:,:,k+2) - xyz_Temp (:,:,k+1) ) &
   265        & / log( xyz_Press(:,:,k+2) / xyz_Press(:,:,k+1) ) &
   266        & * log( xyr_Press(:,:,k  ) / xyz_Press(:,:,k+1) ) &
   267        & + xyz_Temp(:,:,k+1)
   268      do k = 1, kmax-1
   269        xyr_Temp(:,:,k) =                                &
   270          &      ( xyz_Temp (:,:,k+1) - xyz_Temp (:,:,k) ) &
   271          & / log( xyz_Press(:,:,k+1) / xyz_Press(:,:,k) ) &
   272          & * log( xyr_Press(:,:,k  ) / xyz_Press(:,:,k) ) &
   273          & + xyz_Temp(:,:,k)
   274      end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do k = 1, jmax*(kmax*imax - imax)                                 
     .           xyr_temp(k-1,1,1) = (xyz_temp(k-1,1,2)-xyz_temp(k-1,1,1))/dlog(
     .       1      xyz_press(k-1,1,2)/xyz_press(k-1,1,1))*dlog(xyr_press(k-1,1,
     .       2      1)/xyz_press(k-1,1,1)) + xyz_temp(k-1,1,1)                  
     .        enddo                                                             
   275      k = kmax
   276      xyr_Temp(:,:,k) = xyz_Temp(:,:,k)
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t628 = 1, xyr_temp.DSC.U2*xyr_temp.DSC.U1 + xyr_temp.DSC.U2    
     .           xyr_temp(t628-1,1,k) = xyz_temp(t628-1,1,k)                    
     .        enddo                                                             
   277  
   278      !   Initialization
   279      !
   280      xyr_RadLUwFlux     = 0.0_DP
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t636 = 1, jmax*(kmax*imax + imax)                              
     .           xyr_radluwflux(t636-1,1,0) = 0.0000000000000000e+000           
     .           xyr_radldwflux(t636-1,1,0) = 0.0000000000000000e+000           
     .        enddo                                                             
   281      xyr_RadLDwFlux     = 0.0_DP
   282      xyra_DelRadLUwFlux = 0.0_DP
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t650 = 1, jmax*(kmax*imax + imax)                              
     .           xyra_delradluwflux(t650-1,1,0,0) = 0.0000000000000000e+000     
     .           xyra_delradldwflux(t650-1,1,0,0) = 0.0000000000000000e+000     
     .           xyra_delradluwflux(t650-1,1,0,1) = 0.0000000000000000e+000     
     .           xyra_delradldwflux(t650-1,1,0,1) = 0.0000000000000000e+000     
     .        enddo                                                             
   283      xyra_DelRadLDwFlux = 0.0_DP
   284      !
   285      LOOP_BAND_RTE : do n = 1, nbmax
   286  
   287  
   288        ! $ \pi B $, $ \pi DBDT $ の計算
   289        ! Calculate $ \pi B $ and $ \pi DBDT $
   290        !
   291        if ( nbmax == 1 ) then
   292  
   293          xy_SurfIntPF = xy_SurfEmis * StB * ( xy_SurfTemp**4 )
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t804 = 1, jmax*imax                                            
     .           xy_surfintpf(t804-1,1) = xy_surfemis(t804-1,1)*                
     .       1      5.67037300000000e-008*xy_surftemp(t804-1,1)**4              
     .        enddo                                                             
   294          xyr_IntPF    =               StB * ( xyr_Temp**4 )
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t814 = 1, (xyr_temp.DSC.U3 + 1)*xyr_temp.DSC.U2*(              
     .       1   xyr_temp.DSC.U1 + 1)                                           
     .           xyr_intpf(t814-1,1,0) = 5.67037300000000e-008*xyr_temp(t814-1,1
     .       1      ,0)**4                                                      
     .        enddo                                                             
   295          xy_IntDPFDT0 = xy_SurfEmis * 4.0_DP * xy_SurfIntPF / xy_SurfTemp
   296  !!$        xy_IntDPFDT1 =               4.0_DP * xyz_IntPF(:,:,1) / xyz_Temp(:,:,1)
   297          xy_IntDPFDT1 = 0.0_DP
   298  
   299        else
   300  
   301          WNs = a_WNBnds(n-1)
   302          WNe = a_WNBnds(n  )
   303          call Integ_PF_GQ_Array3D(        &
   304            & WNs, WNe, NumGaussNode,      &
   305            & 0, imax-1, 1, jmax, 0, kmax, &
   306            & xyr_Temp,                    &
   307            & xyr_IntPF                    &
   308            & )
   309          call Integ_PF_GQ_Array2D(   &
   310            & WNs, WNe, NumGaussNode, &
   311            & 0, imax-1, 1, jmax,     &
   312            & xy_SurfTemp,            &
   313            & xy_SurfIntPF            &
   314            & )
   315  !!$        call Integ_DPFDT_GQ_Array2D(             &
   316  !!$          & WNs, WNe, NumGaussNode,              & ! (in )
   317  !!$          & 0, imax-1, 1, jmax, xyz_Temp(:,:,1), & ! (in )
   318  !!$          & xy_IntDPFDT1                         & ! (out)
   319  !!$          & )
   320          xy_IntDPFDT1 = 0.0_DP
     .  !cdir    nodep                                                          
     .  !cdir noassume                                                          
     .        do t664 = 1, xy_intdpfdt1.DSC.U2*xy_intdpfdt1.DSC.U1 +            
     .       1   xy_intdpfdt1.DSC.U2                                            
     .           xy_intdpfdt1(t664-1,1) = 0.0000000000000000e+000               
     .        enddo                                                             
   321          call Integ_DPFDT_GQ_Array2D(         &
   322            & WNs, WNe, NumGaussNode,          & ! (in )
   323            & 0, imax-1, 1, jmax, xy_SurfTemp, & ! (in )
   324            & xy_IntDPFDT0                     & ! (out)
   325            & )
   326  
   327          xy_SurfIntPF = xy_SurfEmis * PI * xy_SurfIntPF
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t670 = 1, jmax*imax                                            
     .           xy_surfintpf(t670-1,1) = xy_surfemis(t670-1,1)*                
     .       1      3.14159265358979e+000*xy_surfintpf(t670-1,1)                
     .        enddo                                                             
   328          xyr_IntPF    =               PI * xyr_IntPF
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t680 = 1, (xyr_intpf.DSC.U3 + 1)*xyr_intpf.DSC.U2*(            
     .       1   xyr_intpf.DSC.U1 + 1)                                          
     .           xyr_intpf(t680-1,1,0) = 3.14159265358979e+000*xyr_intpf(t680-1,
     .       1      1,0)                                                        
     .        enddo                                                             
   329          xy_IntDPFDT0 = xy_SurfEmis * PI * xy_IntDPFDT0
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t692 = 1, jmax*imax                                            
     .           xy_intdpfdt0(t692-1,1) = xy_surfemis(t692-1,1)*                
     .       1      3.14159265358979e+000*xy_intdpfdt0(t692-1,1)                
     .           xy_intdpfdt1(t692-1,1) = 3.14159265358979e+000*xy_intdpfdt1(   
     .       1      t692-1,1)                                                   
     .        enddo                                                             
   330          xy_IntDPFDT1 =               PI * xy_IntDPFDT1
   331  
   332        end if
   333  
   334  
   335        ! 光学的厚さの計算
   336        ! Calculate optical depth
   337        !
   338        xyz_DelOptDepDryCom = a_AbsCoefDryCom(n)                             &
     .        d1 = 1.D0/a_refpressdrycom(n)                                     
     .        d2 = 1.D0/a_refpressh2ovap(n)                                     
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t706 = 1, kmax*jmax*imax                                       
     .           xyz_deloptdepdrycom(t706-1,1,1) = a_abscoefdrycom(n)*(xyz_press
     .       1      (t706-1,1,1)*d1)**a_pressscaleinddrycom(n)*xyz_delatmmass(  
     .       2      t706-1,1,1)*radactdrycommmr                                 
     .           xyz_deloptdeph2ovap(t706-1,1,1) = a_abscoefh2ovap(n)*(xyz_press
     .       1      (t706-1,1,1)*d2)**a_pressscaleindh2ovap(n)*xyz_delatmmass(  
     .       2      t706-1,1,1)*xyz_qh2ovap(t706-1,1,1)                         
     .        enddo                                                             
   339          & * ( xyz_Press / a_RefPressDryCom(n) )**a_PressScaleIndDryCom(n)  &
   340          & * xyz_DelAtmMass                                                 &
   341          & * RadActDryComMMR
   342        xyz_DelOptDepH2OVap = a_AbsCoefH2OVap(n)                             &
   343          & * ( xyz_Press / a_RefPressH2OVap(n) )**a_PressScaleIndH2OVap(n)  &
   344          & * xyz_DelAtmMass * xyz_QH2OVap
   345  
   346  
   347        call RadRTENonScatMonoSemiAnal(                              &
     .        if (xyz_deloptdepdrycom.DSC.U2 .gt. 0) then                       
     .           j1 = and(xyz_deloptdepdrycom.DSC.U2,3)                         
     .  !cdir    nodep                                                          
     .           do t735 = 1, j1                                                
     .  !cdir       nodep                                                       
     .              do t737 = 1, xyz_deloptdepdrycom.DSC.U1 + 1                 
     .                 %IG3(t737,t735,t733+1) = xyz_deloptdepdrycom(t737-1,t735,
     .       1            t733+1) + xyz_deloptdeph2ovap(t737-1,t735,t733+1)     
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t735 = j1 + 1, xyz_deloptdepdrycom.DSC.U2, 4                
     .  !cdir       nodep                                                       
     .              do t737 = 1, xyz_deloptdepdrycom.DSC.U1 + 1                 
     .                 %IG3(t737,t735,t733+1) = xyz_deloptdepdrycom(t737-1,t735,
     .       1            t733+1) + xyz_deloptdeph2ovap(t737-1,t735,t733+1)     
     .                 %IG3(t737,t735+1,t733+1) = xyz_deloptdepdrycom(t737-1,   
     .       1            t735+1,t733+1) + xyz_deloptdeph2ovap(t737-1,t735+1,   
     .       2            t733+1)                                               
     .                 %IG3(t737,t735+2,t733+1) = xyz_deloptdepdrycom(t737-1,   
     .       1            t735+2,t733+1) + xyz_deloptdeph2ovap(t737-1,t735+2,   
     .       2            t733+1)                                               
     .                 %IG3(t737,t735+3,t733+1) = xyz_deloptdepdrycom(t737-1,   
     .       1            t735+3,t733+1) + xyz_deloptdeph2ovap(t737-1,t735+3,   
     .       2            t733+1)                                               
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
   348          & xy_SurfAlbedo,                                           & ! (in)
   349          & xyr_IntPF, xy_SurfIntPF, xy_IntDPFDT1, xy_IntDPFDT0,     & ! (in)
   350          & ( xyz_DelOptDepDryCom + xyz_DelOptDepH2OVap ),           & ! (in)
   351          & xyr_RadUwFlux, xyr_RadDwFlux,                            & ! (out)
   352          & xyra_DelRadUwFlux, xyra_DelRadDwFlux                     & ! (out)
   353          & )
   354  
   355  
   356        xyr_RadLUwFlux     = xyr_RadLUwFlux     + xyr_RadUwFlux
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t748 = 1, jmax*(kmax*imax + imax)                              
     .           xyr_radluwflux(t748-1,1,0) = xyr_radluwflux(t748-1,1,0) +      
     .       1      xyr_raduwflux(t748-1,1,0)                                   
     .           xyr_radldwflux(t748-1,1,0) = xyr_radldwflux(t748-1,1,0) +      
     .       1      xyr_raddwflux(t748-1,1,0)                                   
     .        enddo                                                             
   357        xyr_RadLDwFlux     = xyr_RadLDwFlux     + xyr_RadDwFlux
   358        xyra_DelRadLUwFlux = xyra_DelRadLUwFlux + xyra_DelRadUwFlux
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t774 = 1, jmax*(kmax*imax + imax)                              
     .           xyra_delradluwflux(t774-1,1,0,0) = xyra_delradluwflux(t774-1,1,
     .       1      0,0) + xyra_delraduwflux(t774-1,1,0,0)                      
     .           xyra_delradldwflux(t774-1,1,0,0) = xyra_delradldwflux(t774-1,1,
     .       1      0,0) + xyra_delraddwflux(t774-1,1,0,0)                      
     .           xyra_delradluwflux(t774-1,1,0,1) = xyra_delradluwflux(t774-1,1,
     .       1      0,1) + xyra_delraduwflux(t774-1,1,0,1)                      
     .           xyra_delradldwflux(t774-1,1,0,1) = xyra_delradldwflux(t774-1,1,
     .       1      0,1) + xyra_delraddwflux(t774-1,1,0,1)                      
     .        enddo                                                             
   359        xyra_DelRadLDwFlux = xyra_DelRadLDwFlux + xyra_DelRadDwFlux
   360  
   361      end do LOOP_BAND_RTE
   362  
   363  
   364    end subroutine RadSimpleLWFlux
   365  
   366    !--------------------------------------------------------------------------------------
   367  
   368    subroutine OLD_RadSimpleLWFlux(                                      &
   369      & xy_SurfEmis, xyz_Temp, xyz_Press, xy_SurfTemp,                   & ! (in)
   370      & xyz_DelAtmMass, xyz_QH2OVap,                                     & ! (in)
   371      & xyr_RadLUwFlux, xyr_RadLDwFlux,                                  & ! (out)
   372      & xyra_DelRadLUwFlux, xyra_DelRadLDwFlux                           & ! (out)
   373      & )
   374      !
   375      ! 長波フラックスの計算
   376      !
   377      ! Calculate long wave flux
   378      !
   379  
   380      ! モジュール引用 ; USE statements
   381      !
   382  
   383      ! 物理・数学定数設定
   384      ! Physical and mathematical constants settings
   385      !
   386      use constants0, only: &
   387        & PI,               &   ! $ \pi $ .
   388                                ! 円周率.  Circular constant
   389        & StB                   ! $ \sigma_{SB} $ .
   390                                ! ステファンボルツマン定数.
   391                                ! Stefan-Boltzmann constant
   392  
   393      ! プランク関数の計算
   394      ! Calculate Planck function
   395      !
   396      use planck_func, only : Integ_PF_GQ_Array3D, Integ_PF_GQ_Array2D, Integ_DPFDT_GQ_Array2D
   397  
   398      ! 散乱を無視した放射伝達方程式
   399      ! Radiative transfer equation without considering scattering
   400      !
   401      use rad_rte_nonscat, only : RadRTENonScat
   402  
   403  
   404      ! 宣言文 ; Declaration statements
   405      !
   406      real(DP), intent(in):: xy_SurfEmis       (0:imax-1, 1:jmax)
   407                                ! 地表面射出率.
   408                                ! Surface emissivity
   409      real(DP), intent(in):: xyz_Temp          (0:imax-1, 1:jmax, 1:kmax)
   410                                ! $ T $ .     温度. Temperature
   411      real(DP), intent(in):: xyz_Press         (0:imax-1, 1:jmax, 1:kmax)
   412                                ! $ T $ .     温度. Temperature
   413  
   414      real(DP), intent(in):: xy_SurfTemp       (0:imax-1, 1:jmax)
   415                                ! 地表面温度.
   416                                ! Surface temperature
   417      real(DP), intent(in):: xyz_DelAtmMass    (0:imax-1, 1:jmax, 1:kmax)
   418                                !
   419                                ! Atmospheric mass of layers
   420      real(DP), intent(in):: xyz_QH2OVap       (0:imax-1, 1:jmax, 1:kmax)
   421                                !
   422                                ! Specific humidity
   423      real(DP), intent(out):: xyr_RadLUwFlux     (0:imax-1, 1:jmax, 0:kmax)
   424                                ! 長波フラックス.
   425                                ! Upward longwave flux
   426      real(DP), intent(out):: xyr_RadLDwFlux     (0:imax-1, 1:jmax, 0:kmax)
   427                                ! 長波フラックス.
   428                                ! Downward longwave flux
   429      real(DP), intent(out):: xyra_DelRadLUwFlux (0:imax-1, 1:jmax, 0:kmax, 0:1)
   430                                ! 長波地表温度変化.
   431                                !
   432      real(DP), intent(out):: xyra_DelRadLDwFlux (0:imax-1, 1:jmax, 0:kmax, 0:1)
   433                                ! 長波地表温度変化.
   434                                !
   435  
   436      ! 作業変数
   437      ! Work variables
   438      !
   439      real(DP) :: xyz_DelOptDepDryCom(0:imax-1, 1:jmax, 1:kmax)
   440      real(DP) :: xyz_DelOptDepH2OVap(0:imax-1, 1:jmax, 1:kmax)
   441      real(DP) :: xyz_TransEachLayer (0:imax-1, 1:jmax, 1:kmax)
   442      real(DP) :: xyrr_Trans         (0:imax-1, 1:jmax, 0:kmax, 0:kmax)
   443                                ! 透過係数.
   444                                ! Transmission coefficient
   445      real(DP) :: xyz_IntPF   (0:imax-1, 1:jmax, 1:kmax)
   446      real(DP) :: xy_SurfIntPF(0:imax-1, 1:jmax)
   447      real(DP) :: xy_IntDPFDT0(0:imax-1, 1:jmax)
   448      real(DP) :: xy_IntDPFDT1(0:imax-1, 1:jmax)
   449  
   450      real(DP) :: xyr_RadUwFlux     (0:imax-1, 1:jmax, 0:kmax)
   451                                ! 長波フラックス.
   452                                ! Upward longwave flux
   453      real(DP) :: xyr_RadDwFlux     (0:imax-1, 1:jmax, 0:kmax)
   454                                ! 長波フラックス.
   455                                ! Downward longwave flux
   456      real(DP) :: xyra_DelRadUwFlux (0:imax-1, 1:jmax, 0:kmax, 0:1)
   457                                ! 長波地表温度変化.
   458                                !
   459      real(DP) :: xyra_DelRadDwFlux (0:imax-1, 1:jmax, 0:kmax, 0:1)
   460                                ! 長波地表温度変化.
   461                                !
   462  
   463      real(DP) :: WNs
   464      real(DP) :: WNe
   465  
   466      integer:: k, kk           ! 鉛直方向に回る DO ループ用作業変数
   467                                ! Work variables for DO loop in vertical direction
   468      integer:: n               ! 波長について回る DO ループ用作業変数
   469                                ! Work variables for DO loop in wavenumber bands
   470  
   471      ! 実行文 ; Executable statement
   472      !
   473  
   474  
   475      !   Initialization
   476      !
   477      xyr_RadLUwFlux     = 0.0_DP
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t568 = 1, jmax*(kmax*imax + imax)                              
     .           xyr_radluwflux(t568-1,1,0) = 0.0000000000000000e+000           
     .           xyr_radldwflux(t568-1,1,0) = 0.0000000000000000e+000           
     .        enddo                                                             
   478      xyr_RadLDwFlux     = 0.0_DP
   479      xyra_DelRadLUwFlux = 0.0_DP
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t582 = 1, jmax*(kmax*imax + imax)                              
     .           xyra_delradluwflux(t582-1,1,0,0) = 0.0000000000000000e+000     
     .           xyra_delradldwflux(t582-1,1,0,0) = 0.0000000000000000e+000     
     .           xyra_delradluwflux(t582-1,1,0,1) = 0.0000000000000000e+000     
     .           xyra_delradldwflux(t582-1,1,0,1) = 0.0000000000000000e+000     
     .        enddo                                                             
   480      xyra_DelRadLDwFlux = 0.0_DP
   481      !
   482      LOOP_BAND_RTE : do n = 1, nbmax
   483  
   484  
   485        ! $ \pi B $, $ \pi DBDT $ の計算
   486        ! Calculate $ \pi B $ and $ \pi DBDT $
   487        !
   488        if ( nbmax == 1 ) then
   489  
   490          xy_SurfIntPF = xy_SurfEmis * StB * ( xy_SurfTemp**4 )
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t748 = 1, jmax*imax                                            
     .           xy_surfintpf(t748-1,1) = xy_surfemis(t748-1,1)*                
     .       1      5.67037300000000e-008*xy_surftemp(t748-1,1)**4              
     .        enddo                                                             
   491          xyz_IntPF    =               StB * ( xyz_Temp**4 )
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t758 = 1, kmax*jmax*imax                                       
     .           xyz_intpf(t758-1,1,1) = 5.67037300000000e-008*xyz_temp(t758-1,1
     .       1      ,1)**4                                                      
     .        enddo                                                             
   492          xy_IntDPFDT0 = xy_SurfEmis * 4.0_DP * xy_SurfIntPF / xy_SurfTemp
   493          xy_IntDPFDT1 =               4.0_DP * xyz_IntPF(:,:,1) / xyz_Temp(:,:,1)
   494  
   495        else
   496  
   497          WNs = a_WNBnds(n-1)
   498          WNe = a_WNBnds(n  )
   499          call Integ_PF_GQ_Array3D(        &
   500            & WNs, WNe, NumGaussNode,      &
   501            & 0, imax-1, 1, jmax, 1, kmax, &
   502            & xyz_Temp,                    &
   503            & xyz_IntPF                    &
   504            & )
   505          call Integ_PF_GQ_Array2D(   &
   506            & WNs, WNe, NumGaussNode, &
   507            & 0, imax-1, 1, jmax,     &
   508            & xy_SurfTemp,            &
   509            & xy_SurfIntPF            &
   510            & )
   511          call Integ_DPFDT_GQ_Array2D(             &
   512            & WNs, WNe, NumGaussNode,              & ! (in )
   513            & 0, imax-1, 1, jmax, xyz_Temp(:,:,1), & ! (in )
   514            & xy_IntDPFDT1                         & ! (out)
   515            & )
   516          call Integ_DPFDT_GQ_Array2D(         &
   517            & WNs, WNe, NumGaussNode,          & ! (in )
   518            & 0, imax-1, 1, jmax, xy_SurfTemp, & ! (in )
   519            & xy_IntDPFDT0                     & ! (out)
   520            & )
   521  
   522          xy_SurfIntPF = xy_SurfEmis * PI * xy_SurfIntPF
     .  !cdir    nodep                                                          
     .  !cdir noassume                                                          
     .        do t596 = 1, jmax*imax                                            
     .           xy_surfintpf(t596-1,1) = xy_surfemis(t596-1,1)*                
     .       1      3.14159265358979e+000*xy_surfintpf(t596-1,1)                
     .        enddo                                                             
   523          xyz_IntPF    =               PI * xyz_IntPF
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t606 = 1, xyz_intpf.DSC.U3*(xyz_intpf.DSC.U2*xyz_intpf.DSC.U1  
     .       1    + xyz_intpf.DSC.U2)                                           
     .           xyz_intpf(t606-1,1,1) = 3.14159265358979e+000*xyz_intpf(t606-1,
     .       1      1,1)                                                        
     .        enddo                                                             
   524          xy_IntDPFDT0 = xy_SurfEmis * PI * xy_IntDPFDT0
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t618 = 1, jmax*imax                                            
     .           xy_intdpfdt0(t618-1,1) = xy_surfemis(t618-1,1)*                
     .       1      3.14159265358979e+000*xy_intdpfdt0(t618-1,1)                
     .           xy_intdpfdt1(t618-1,1) = 3.14159265358979e+000*xy_intdpfdt1(   
     .       1      t618-1,1)                                                   
     .        enddo                                                             
   525          xy_IntDPFDT1 =               PI * xy_IntDPFDT1
   526  
   527        end if
   528  
   529  
   530        ! 光学的厚さの計算
   531        ! Calculate optical depth
   532        !
   533        xyz_DelOptDepDryCom = a_AbsCoefDryCom(n)                             &
     .        d3 = 1.D0/a_refpressdrycom(n)                                     
     .        d4 = 1.D0/a_refpressh2ovap(n)                                     
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t632 = 1, kmax*jmax*imax                                       
     .           xyz_deloptdepdrycom1 = a_abscoefdrycom(n)*(xyz_press(t632-1,1,1
     .       1      )*d3)**a_pressscaleinddrycom(n)*xyz_delatmmass(t632-1,1,1)  
     .           xyz_deloptdeph2ovap1 = a_abscoefh2ovap(n)*(xyz_press(t632-1,1,1
     .       1      )*d4)**a_pressscaleindh2ovap(n)*xyz_delatmmass(t632-1,1,1)* 
     .       2      xyz_qh2ovap(t632-1,1,1)                                     
     .           xyz_transeachlayer(t632-1,1,1) = dexp((-difffact*(             
     .       1      xyz_deloptdepdrycom1 + xyz_deloptdeph2ovap1)))              
     .        enddo                                                             
   534          & * ( xyz_Press / a_RefPressDryCom(n) )**a_PressScaleIndDryCom(n)  &
   535          & * xyz_DelAtmMass
   536        xyz_DelOptDepH2OVap = a_AbsCoefH2OVap(n)                             &
   537          & * ( xyz_Press / a_RefPressH2OVap(n) )**a_PressScaleIndH2OVap(n)  &
   538          & * xyz_DelAtmMass * xyz_QH2OVap
   539  
   540  
   541        ! 透過関数の計算
   542        ! Calculate transmission functions
   543        !
   544        xyz_TransEachLayer = exp( - DiffFact * ( xyz_DelOptDepDryCom + xyz_DelOptDepH2OVap ) )
   545        do k = 0, kmax
   546          do kk = k, k
   547            xyrr_Trans(:,:,k,kk) = 1.0d0
   548          end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t668 = 1, xyrr_trans.DSC.U2*xyrr_trans.DSC.U1 +                
     .       1   xyrr_trans.DSC.U2                                              
     .           xyrr_trans(t668-1,1,k,k) = 1.00000000000000e+000               
     .        enddo                                                             
   549          do kk = k+1, kmax
   550            xyrr_Trans(:,:,k,kk) = xyrr_Trans(:,:,k,kk-1) * xyz_TransEachLayer(:,:,kk)
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xyrr_trans)                                                
     .        do t674 = 1, xyrr_trans.DSC.U2*xyrr_trans.DSC.U1 +                
     .       1   xyrr_trans.DSC.U2                                              
     .           xyrr_trans(t674-1,1,k,kk) = xyrr_trans(t674-1,1,k,kk-1)*       
     .       1      xyz_transeachlayer(t674-1,1,kk)                             
     .        enddo                                                             
   551          end do
   552          do kk = 0, k-1
   553            xyrr_Trans(:,:,k,kk) = xyrr_Trans(:,:,kk,k)
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xyrr_trans)                                                
     .        do t684 = 1, xyrr_trans.DSC.U2*xyrr_trans.DSC.U1 +                
     .       1   xyrr_trans.DSC.U2                                              
     .           xyrr_trans(t684-1,1,k,kk) = xyrr_trans(t684-1,1,kk,k)          
     .        enddo                                                             
   554          end do
   555        end do
   556  
   557  
   558        call RadRTENonScat(                                      &
   559          & xyz_IntPF, xy_SurfIntPF, xy_IntDPFDT1, xy_IntDPFDT0, & ! (in)
   560          & xyrr_Trans,                                          & ! (in)
   561          & xyr_RadUwFlux, xyr_RadDwFlux,                        & ! (out)
   562          & xyra_DelRadUwFlux, xyra_DelRadDwFlux                 & ! (out)
   563          & )
   564  
   565  
   566        xyr_RadLUwFlux     = xyr_RadLUwFlux     + xyr_RadUwFlux
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t692 = 1, jmax*(kmax*imax + imax)                              
     .           xyr_radluwflux(t692-1,1,0) = xyr_radluwflux(t692-1,1,0) +      
     .       1      xyr_raduwflux(t692-1,1,0)                                   
     .           xyr_radldwflux(t692-1,1,0) = xyr_radldwflux(t692-1,1,0) +      
     .       1      xyr_raddwflux(t692-1,1,0)                                   
     .        enddo                                                             
   567        xyr_RadLDwFlux     = xyr_RadLDwFlux     + xyr_RadDwFlux
   568        xyra_DelRadLUwFlux = xyra_DelRadLUwFlux + xyra_DelRadUwFlux
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t718 = 1, jmax*(kmax*imax + imax)                              
     .           xyra_delradluwflux(t718-1,1,0,0) = xyra_delradluwflux(t718-1,1,
     .       1      0,0) + xyra_delraduwflux(t718-1,1,0,0)                      
     .           xyra_delradldwflux(t718-1,1,0,0) = xyra_delradldwflux(t718-1,1,
     .       1      0,0) + xyra_delraddwflux(t718-1,1,0,0)                      
     .           xyra_delradluwflux(t718-1,1,0,1) = xyra_delradluwflux(t718-1,1,
     .       1      0,1) + xyra_delraduwflux(t718-1,1,0,1)                      
     .           xyra_delradldwflux(t718-1,1,0,1) = xyra_delradldwflux(t718-1,1,
     .       1      0,1) + xyra_delraddwflux(t718-1,1,0,1)                      
     .        enddo                                                             
   569        xyra_DelRadLDwFlux = xyra_DelRadLDwFlux + xyra_DelRadDwFlux
   570  
   571      end do LOOP_BAND_RTE
   572  
   573  
   574    end subroutine OLD_RadSimpleLWFlux
   575  
   576    !--------------------------------------------------------------------------------------
   577  
   578    subroutine RadSimpleLWInit
   579      !
   580      ! rad_simple_LW モジュールの初期化を行います.
   581      ! NAMELIST#rad_simple_LW_nml の読み込みはこの手続きで行われます.
   582      !
   583      ! "rad_simple_LW" module is initialized.
   584      ! "NAMELIST#rad_simple_LW_nml" is loaded in this procedure.
   585      !
   586  
   587      ! モジュール引用 ; USE statements
   588      !
   589  
   590      ! 出力ファイルの基本情報
   591      ! Basic information for output files
   592      !
   593      use fileset, only: &
   594        & FileTitle, &
   595                                ! 出力データファイルの表題.
   596                                ! Title of output data files
   597        & FileSource, &
   598                                ! データファイル作成の手段.
   599                                ! Source of data file
   600        & FileInstitution
   601                                ! データファイルを最終的に変更した組織/個人.
   602                                ! Institution or person that changes data files for the last time
   603  
   604      ! 物理・数学定数設定
   605      ! Physical and mathematical constants settings
   606      !
   607      use constants0, only: &
   608        & PI                    ! $ \pi $ .
   609                                ! 円周率.  Circular constant
   610  
   611      ! 座標データ設定
   612      ! Axes data settings
   613      !
   614      use axesset, only: &
   615        & x_Lon, &
   616                                ! $ \lambda $ [rad.] . 経度. Longitude
   617        & x_Lon_Weight, &
   618                                ! $ \Delta \lambda $ [rad.] .
   619                                ! 経度座標重み.
   620                                ! Weight of longitude
   621        & y_Lat, &
   622                                ! $ \varphi $ [rad.] . 緯度. Latitude
   623        & y_Lat_Weight, &
   624                                ! $ \Delta \varphi $ [rad.] .
   625                                ! 緯度座標重み.
   626                                ! Weight of latitude
   627        & z_Sigma, &
   628                                ! $ \sigma $ レベル (整数).
   629                                ! Full $ \sigma $ level
   630        & r_Sigma, &
   631                                ! $ \sigma $ レベル (半整数).
   632                                ! Half $ \sigma $ level
   633        & z_DelSigma
   634                                ! $ \Delta \sigma $ (整数).
   635                                ! $ \Delta \sigma $ (Full)
   636  
   637      ! 時刻管理
   638      ! Time control
   639      !
   640      use timeset, only: &
   641        & RestartTime           ! リスタート開始時刻.
   642                                ! Retart time of calculation
   643  
   644  
   645      ! NAMELIST ファイル入力に関するユーティリティ
   646      ! Utilities for NAMELIST file input
   647      !
   648      use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid
   649  
   650      ! 暦と日時の取り扱い
   651      ! Calendar and Date handler
   652      !
   653      use dc_calendar, only: DCCalConvertByUnit
   654  
   655      ! ファイル入出力補助
   656      ! File I/O support
   657      !
   658      use dc_iounit, only: FileOpen
   659  
   660      ! 種別型パラメタ
   661      ! Kind type parameter
   662      !
   663      use dc_types, only: STDOUT ! 標準出力の装置番号. Unit number of standard output
   664  
   665      ! 文字列操作
   666      ! Character handling
   667      !
   668      use dc_string, only: toChar
   669  
   670      ! 散乱を無視した放射伝達方程式
   671      ! Radiative transfer equation without considering scattering
   672      !
   673      use rad_rte_nonscat, only : RadRTENonScatInit
   674  
   675      ! 宣言文 ; Declaration statements
   676      !
   677      integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号.
   678                                ! Unit number for NAMELIST file open
   679      integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT.
   680                                ! IOSTAT of NAMELIST read
   681  
   682      real(DP) :: WNBnds             (0:MaxNmlArySize)
   683      real(DP) :: AbsCoefDryCom      (1:MaxNmlArySize)
   684      real(DP) :: PressScaleIndDryCom(1:MaxNmlArySize)
   685      real(DP) :: RefPressDryCom     (1:MaxNmlArySize)
   686      real(DP) :: AbsCoefH2OVap      (1:MaxNmlArySize)
   687      real(DP) :: PressScaleIndH2OVap(1:MaxNmlArySize)
   688      real(DP) :: RefPressH2OVap     (1:MaxNmlArySize)
   689  
   690      integer  :: n
   691  
   692      ! NAMELIST 変数群
   693      ! NAMELIST group name
   694      !
   695      namelist /rad_simple_LW_nml/ &
   696        & nbmax, &
   697        & WNBnds,                                             &
   698        & AbsCoefDryCom, PressScaleIndDryCom, RefPressDryCom, &
   699        & AbsCoefH2OVap, PressScaleIndH2OVap, RefPressH2OVap, &
   700        & RadActDryComMMR,                                    &
   701        & DiffFact,                                           &
   702        & NumGaussNode
   703            !
   704            ! デフォルト値については初期化手続 "rad_DennouAGCM#RadInit"
   705            ! のソースコードを参照のこと.
   706            !
   707            ! Refer to source codes in the initialization procedure
   708            ! "rad_DennouAGCM#RadInit" for the default values.
   709            !
   710  
   711      ! 実行文 ; Executable statement
   712      !
   713  
   714      if ( rad_simple_LW_inited ) return
   715  
   716  
   717      ! デフォルト値の設定
   718      ! Default values settings
   719      !
   720  
   721      ! 長波フラックス用情報
   722      ! Information for long wave flux
   723      !
   724  
   725      nbmax                  = 1
   726  
   727      WNBnds                 = -999.9_DP
     .  !cdir nodep                                                             
     .  !cdir on_adb(wnbnds)                                                    
     .        do t218 = 0, 256                                                  
   728      AbsCoefDryCom          = -999.9_DP
     .  !cdir    nodep                                                          
     .  !cdir on_adb(abscoefdrycom,pressscaleinddrycom,refpressdrycom,abscoefh2o
     .       1   vap,pressscaleindh2ovap,refpressh2ovap)                        
     .        do t221 = 0, 255                                                  
   729      PressScaleIndDryCom    = -999.9_DP
   730      RefPressDryCom         = -999.9_DP
   731      AbsCoefH2OVap          = -999.9_DP
   732      PressScaleIndH2OVap    = -999.9_DP
   733      RefPressH2OVap         = -999.9_DP
   734  
   735      AbsCoefDryCom      (1:nbmax) = (/ 5.0d-5 /)
     .           abscoefdrycom(1) = %IG14(1)                                    
     .        pressscaleinddrycom(1) = %IG15(1)                                 
     .        refpressdrycom(1) = %IG16(1)                                      
     .        abscoefh2ovap(1) = %IG17(1)                                       
     .        pressscaleindh2ovap(1) = %IG18(1)                                 
     .        refpressh2ovap(1) = %IG19(1)                                      
   736      PressScaleIndDryCom(1:nbmax) = (/ 0.0d0  /)
   737      RefPressDryCom     (1:nbmax) = (/ 1.0d5  /)
   738  
   739      AbsCoefH2OVap      (1:nbmax) = (/ 1.0d-2 /)
   740      PressScaleIndH2OVap(1:nbmax) = (/ 0.0d0  /)
   741      RefPressH2OVap     (1:nbmax) = (/ 1.0d5  /)
   742  
   743      RadActDryComMMR       = 1.0_DP
   744  
   745      DiffFact        = 1.66_DP
   746  
   747      NumGaussNode    = 5
   748  
   749  
   750      ! NAMELIST の読み込み
   751      ! NAMELIST is input
   752      !
   753      if ( trim(namelist_filename) /= '' ) then
   754        call FileOpen( unit_nml, &          ! (out)
   755          & namelist_filename, mode = 'r' ) ! (in)
   756  
   757        rewind( unit_nml )
   758        read( unit_nml,                    & ! (in)
   759          & nml = rad_simple_LW_nml,       & ! (out)
   760          & iostat = iostat_nml )            ! (out)
   761        close( unit_nml )
   762  
   763        call NmlutilMsg( iostat_nml, module_name ) ! (in)
   764      end if
   765  
   766      if ( nbmax > MaxNmlArySize ) then
   767        call MessageNotify( 'E', module_name, 'nbmax = %d > %d', i = (/ nbmax, MaxNmlArySize /) )
   768      end if
   769  
   770      a_WNBnds              = WNBnds * 100.0_DP    ! Convert from cm-1 to m-1
     .  !cdir nodep                                                             
     .  !cdir on_adb(wnbnds)                                                    
     .        do t243 = 0, 256                                                  
   771  !!$    a_AbsCoefDryCom = 5.0d-5
   772      a_AbsCoefDryCom       = AbsCoefDryCom
     .  !cdir    nodep                                                          
     .  !cdir on_adb(abscoefdrycom,pressscaleinddrycom,refpressdrycom,abscoefh2o
     .       1   vap,pressscaleindh2ovap,refpressh2ovap)                        
     .        do t247 = 0, 255                                                  
   773      a_PressScaleIndDryCom = PressScaleIndDryCom
   774      a_RefPressDryCom      = RefPressDryCom
   775  
   776  !!$    a_AbsCoefH2OVap = 1.0d-2
   777      a_AbsCoefH2OVap = AbsCoefH2OVap
   778      a_PressScaleIndH2OVap = PressScaleIndH2OVap
   779      a_RefPressH2OVap      = RefPressH2OVap
   780  
   781  
   782      ! Initialization of modules used in this module
   783      !
   784  
   785      ! 散乱を無視した放射伝達方程式
   786      ! Radiative transfer equation without considering scattering
   787      !
   788      call RadRTENonScatInit
   789  
   790  
   791      ! 印字 ; Print
   792      !
   793      call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   794  
   795  !!$    call MessageNotify( 'M', module_name, 'DelTime:' )
   796  !!$    call MessageNotify( 'M', module_name, '  DelTime  = %f [%c]', &
   797  !!$      & d = (/ DelTimeValue /), c1 = trim( DelTimeUnit ) )
   798  
   799      call MessageNotify( 'M', module_name, 'nbmax         = %d', i = (/ nbmax /) )
   800  
   801  !!$    call MessageNotify( 'M', module_name, 'WNBnds              = (/ %*r /)', &
   802  !!$      & r = real( a_WNBnds(0:nbmax) ), n = (/ nbmax+1 /) )
   803  !!$    call MessageNotify( 'M', module_name, 'AbsCoefDryCom       = (/ %*r /)', &
   804  !!$      & r = real( a_AbsCoefDryCom(1:nbmax) ), n = (/ nbmax /) )
   805  !!$    call MessageNotify( 'M', module_name, 'PressScaleIndDryCom = (/ %*r /)', &
   806  !!$      & r = real( a_PressScaleIndDryCom(1:nbmax) ), n = (/ nbmax /) )
   807  !!$    call MessageNotify( 'M', module_name, 'RefPressDryCom      = (/ %*r /)', &
   808  !!$      & r = real( a_RefPressDryCom(1:nbmax) ), n = (/ nbmax /) )
   809  !!$    call MessageNotify( 'M', module_name, 'AbsCoefH2OVap       = (/ %*r /)', &
   810  !!$      & r = real( a_AbsCoefH2OVap(1:nbmax) ), n = (/ nbmax /) )
   811  !!$    call MessageNotify( 'M', module_name, 'PressScaleIndH2OVap = (/ %*r /)', &
   812  !!$      & r = real( a_PressScaleIndH2OVap(1:nbmax) ), n = (/ nbmax /) )
   813  !!$    call MessageNotify( 'M', module_name, 'RefPressH2OVap      = (/ %*r /)', &
   814  !!$      & r = real( a_RefPressH2OVap(1:nbmax) ), n = (/ nbmax /) )
   815  
   816      do n = 1, nbmax
   817        call MessageNotify( 'M', module_name, '  %d : %f %f %f %f %f %f %f %f',       &
   818          & i = (/ n /),                                                              &
   819          & d = (/ a_WNBnds(n-1)*1.0e-2, a_WNBnds(n)*1.0e-2,                          &
   820          &        a_AbsCoefDryCom(n), a_PressScaleIndDryCom(n), a_RefPressDryCom(n), &
   821          &        a_AbsCoefH2OVap(n), a_PressScaleIndH2OVap(n), a_RefPressH2OVap(n) /) )
   822      end do
   823  
   824      call MessageNotify( 'M', module_name, 'RadActDryComMMR = %f', d = (/ RadActDryComMMR /) )
   825      call MessageNotify( 'M', module_name, 'DiffFact        = %f', d = (/ DiffFact /) )
   826  !
   827      call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   828  
   829      rad_simple_LW_inited = .true.
   830  
   831    end subroutine RadSimpleLWInit
   832  
   833    !--------------------------------------------------------------------------------------
   834  
   835  end module rad_simple_LW
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:39:01 2016
FILE NAME: rad_simple_LW.f90
PROGRAM NAME: rad_simple_lw
FORMAT LIST

  LINE    LOOP      FORTRAN STATEMENT

     1:             != 放射フラックス (簡単長波バンドモデル)
     2:             !
     3:             != Radiation flux (simple longwave band model)
     4:             !
     5:             ! Authors::   Yoshiyuki O. Takahashi
     6:             ! Version::   $Id: rad_simple_LW.f90,v 1.3 2013/05/25 06:47:33 yot Exp $ 
     7:             ! Tag Name::  $Name:  $
     8:             ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9:             ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10:             !
    11:             
    12:             module rad_simple_LW
    13:               !
    14:               != 放射フラックス (簡単長波バンドモデル)
    15:               !
    16:               != Radiation flux (simple longwave band model)
    17:               !
    18:               ! <b>Note that Japanese and English are described in parallel.</b>
    19:               !
    20:               ! 温度, 比湿, 気圧から, 放射フラックスを計算する放射モデルです. 
    21:               !
    22:               ! This is a radiation model that calculates radiation flux from
    23:               ! temperature, specific humidity, and air pressure.
    24:               !
    25:               !== References
    26:               !
    27:               !
    28:               !
    29:               !== Procedures List
    30:               !
    31:               ! RadSimpleLWFlux     :: 放射フラックスの計算
    32:             !!$  ! RadSimpleLWFinalize :: 終了処理 (モジュール内部の変数の割り付け解除)
    33:               ! ------------------- :: ------------
    34:               ! RadSimpleLWFlux     :: Calculate radiation flux
    35:             !!$  ! RadSimpleLWFinalize :: Termination (deallocate variables in this module)
    36:               !
    37:               !== NAMELIST
    38:               !
    39:               ! NAMELIST#rad_Simple_LW_nml
    40:               !
    41:             
    42:               ! モジュール引用 ; USE statements
    43:               !
    44:             
    45:               ! 格子点設定
    46:               ! Grid points settings
    47:               !
    48:               use gridset, only: imax, & ! 経度格子点数. 
    49:                                          ! Number of grid points in longitude
    50:                 &                jmax, & ! 緯度格子点数. 
    51:                                          ! Number of grid points in latitude
    52:                 &                kmax    ! 鉛直層数. 
    53:                                          ! Number of vertical level
    54:             
    55:               ! 種別型パラメタ
    56:               ! Kind type parameter
    57:               !
    58:               use dc_types, only: DP, &      ! 倍精度実数型. Double precision. 
    59:                 &                 STRING, &  ! 文字列.       Strings. 
    60:                 &                 TOKEN      ! キーワード.   Keywords. 
    61:             
    62:               ! NAMELIST ファイル入力に関するユーティリティ
    63:               ! Utilities for NAMELIST file input
    64:               !
    65:               use namelist_util, only: MaxNmlArySize
    66:                                           ! NAMELIST から読み込む配列の最大サイズ. 
    67:                                           ! Maximum size of arrays loaded from NAMELIST
    68:             
    69:               ! メッセージ出力
    70:               ! Message output
    71:               !
    72:               use dc_message, only: MessageNotify
    73:             
    74:               ! リスタートデータ出力
    75:               ! Restart data output
    76:               !
    77:               use gtool_history, only: GT_HISTORY
    78:             
    79:               ! 宣言文 ; Declaration statements
    80:               !
    81:               implicit none
    82:               private
    83:             
    84:               ! 公開手続き
    85:               ! Public procedure
    86:               !
    87:               public:: RadSimpleLWFlux
    88:               public:: RadSimpleLWInit
    89:             
    90:               ! 公開変数
    91:               ! Public variables
    92:               !
    93:               logical, save :: rad_simple_LW_inited = .false.
    94:                                           ! 初期設定フラグ. 
    95:                                           ! Initialization flag
    96:             
    97:             
    98:               ! 非公開変数
    99:               ! Private variables
   100:               !
   101:               logical, save:: Old_Flux_saved = .false.
   102:                                           ! 一度計算したフラックスを保存したことを示すフラグ. 
   103:                                           ! Flag for saving of flux calculated once
   104:             
   105:               integer , save:: nbmax
   106:                                           ! 長波バンド数. 
   107:                                           ! Number of long wave band
   108:               real(DP), save:: a_WNBnds(0:MaxNmlArySize)
   109:                                           ! 
   110:                                           ! Wavenumber bounds for bands
   111:               real(DP), save:: a_AbsCoefDryCom(1:MaxNmlArySize)
   112:                                           ! $ \bar{k}_R $ . 空気の吸収係数
   113:                                           ! Absorption coefficient of dry component
   114:               real(DP), save:: a_PressScaleIndDryCom(1:MaxNmlArySize)
   115:                                           ! 
   116:                                           ! Pressure scaling index for dry component
   117:               real(DP), save:: a_RefPressDryCom(1:MaxNmlArySize)
   118:                                           ! 
   119:                                           ! Reference pressure for dry component.
   120:               real(DP), save:: a_AbsCoefH2OVap(1:MaxNmlArySize)
   121:                                           ! $ k_R $ . 水の吸収係数
   122:                                           ! Absorption coefficient of water vapor
   123:               real(DP), save:: a_PressScaleIndH2OVap(1:MaxNmlArySize)
   124:                                           ! 
   125:                                           ! Pressure scaling index for water vapor
   126:               real(DP), save:: a_RefPressH2OVap(1:MaxNmlArySize)
   127:                                           ! 
   128:                                           ! Reference pressure for water vapor
   129:               real(DP), save:: DiffFact
   130:                                           ! 
   131:                                           ! Diffusivity factor
   132:               real(DP), save:: RadActDryComMMR
   133:                                           ! 
   134:                                           ! Mass mixing ratio of radiative active dry component
   135:             
   136:               integer , save:: NumGaussNode
   137:             
   138:             
   139:               character(*), parameter:: module_name = 'rad_simple_LW'
   140:                                           ! モジュールの名称. 
   141:                                           ! Module name
   142:               character(*), parameter:: version = &
   143:                 & '$Name:  $' // &
   144:                 & '$Id: rad_simple_LW.f90,v 1.3 2013/05/25 06:47:33 yot Exp $'
   145:                                           ! モジュールのバージョン
   146:                                           ! Module version
   147:             
   148:             contains
   149:             
   150:               !--------------------------------------------------------------------------------------
   151:             
   152:               subroutine RadSimpleLWFlux(                                         &
   153:                 & xy_SurfAlbedo, xy_SurfEmis,                                     & ! (in)
   154:                 & xyr_Press, xyz_Press, xyz_Temp, xy_SurfTemp,                    & ! (in)
   155:                 & xyz_DelAtmMass, xyz_QH2OVap,                                    & ! (in)
   156:                 & xyr_RadLUwFlux, xyr_RadLDwFlux,                                 & ! (out)
   157:                 & xyra_DelRadLUwFlux, xyra_DelRadLDwFlux                          & ! (out)
   158:                 & )
   159:                 !
   160:                 ! 長波フラックスの計算
   161:                 !
   162:                 ! Calculate long wave flux
   163:                 !
   164:             
   165:                 ! モジュール引用 ; USE statements
   166:                 !
   167:             
   168:                 ! 物理・数学定数設定
   169:                 ! Physical and mathematical constants settings
   170:                 !
   171:                 use constants0, only: &
   172:                   & PI,               &   ! $ \pi $ .
   173:                                           ! 円周率.  Circular constant
   174:                   & StB                   ! $ \sigma_{SB} $ . 
   175:                                           ! ステファンボルツマン定数. 
   176:                                           ! Stefan-Boltzmann constant
   177:             
   178:                 ! プランク関数の計算
   179:                 ! Calculate Planck function
   180:                 !
   181:                 use planck_func, only : Integ_PF_GQ_Array3D, Integ_PF_GQ_Array2D, Integ_DPFDT_GQ_Array2D
   182:             
   183:                 ! 散乱を無視した放射伝達方程式
   184:                 ! Radiative transfer equation without considering scattering
   185:                 !
   186:                 use rad_rte_nonscat, only : RadRTENonScatMonoSemiAnal
   187:             
   188:             
   189:                 ! 宣言文 ; Declaration statements
   190:                 !
   191:                 real(DP), intent(in):: xy_SurfAlbedo     (0:imax-1, 1:jmax)
   192:                                           !
   193:                                           ! Surface albedo
   194:                 real(DP), intent(in):: xy_SurfEmis       (0:imax-1, 1:jmax)
   195:                                           ! 地表面射出率.
   196:                                           ! Surface emissivity
   197:                 real(DP), intent(in):: xyr_Press         (0:imax-1, 1:jmax, 0:kmax)
   198:                                           ! $ P $ .     圧力. Pressure
   199:                 real(DP), intent(in):: xyz_Press         (0:imax-1, 1:jmax, 1:kmax)
   200:                                           ! $ P $ .     圧力. Pressure
   201:                 real(DP), intent(in):: xyz_Temp          (0:imax-1, 1:jmax, 1:kmax)
   202:                                           ! $ T $ .     温度. Temperature
   203:                 real(DP), intent(in):: xy_SurfTemp       (0:imax-1, 1:jmax)
   204:                                           ! 地表面温度. 
   205:                                           ! Surface temperature
   206:                 real(DP), intent(in):: xyz_DelAtmMass    (0:imax-1, 1:jmax, 1:kmax)
   207:                                           ! 
   208:                                           ! Atmospheric mass of layers
   209:                 real(DP), intent(in):: xyz_QH2OVap       (0:imax-1, 1:jmax, 1:kmax)
   210:                                           !
   211:                                           ! Specific humidity
   212:                 real(DP), intent(out):: xyr_RadLUwFlux     (0:imax-1, 1:jmax, 0:kmax)
   213:                                           ! 長波フラックス. 
   214:                                           ! Upward longwave flux
   215:                 real(DP), intent(out):: xyr_RadLDwFlux     (0:imax-1, 1:jmax, 0:kmax)
   216:                                           ! 長波フラックス. 
   217:                                           ! Downward longwave flux
   218:                 real(DP), intent(out):: xyra_DelRadLUwFlux (0:imax-1, 1:jmax, 0:kmax, 0:1)
   219:                                           ! 長波地表温度変化. 
   220:                                           ! 
   221:                 real(DP), intent(out):: xyra_DelRadLDwFlux (0:imax-1, 1:jmax, 0:kmax, 0:1)
   222:                                           ! 長波地表温度変化. 
   223:                                           ! 
   224:             
   225:                 ! 作業変数
   226:                 ! Work variables
   227:                 !
   228:                 real(DP) :: xyr_Temp    (0:imax-1, 1:jmax, 0:kmax)
   229:                 real(DP) :: xyr_IntPF   (0:imax-1, 1:jmax, 0:kmax)
   230:                 real(DP) :: xy_SurfIntPF(0:imax-1, 1:jmax)
   231:                 real(DP) :: xy_IntDPFDT0(0:imax-1, 1:jmax)
   232:                 real(DP) :: xy_IntDPFDT1(0:imax-1, 1:jmax)
   233:             
   234:                 real(DP) :: xyz_DelOptDepDryCom(0:imax-1, 1:jmax, 1:kmax)
   235:                 real(DP) :: xyz_DelOptDepH2OVap(0:imax-1, 1:jmax, 1:kmax)
   236:             
   237:                 real(DP) :: xyr_RadUwFlux     (0:imax-1, 1:jmax, 0:kmax)
   238:                                           ! 長波フラックス. 
   239:                                           ! Upward longwave flux
   240:                 real(DP) :: xyr_RadDwFlux     (0:imax-1, 1:jmax, 0:kmax)
   241:                                           ! 長波フラックス. 
   242:                                           ! Downward longwave flux
   243:                 real(DP) :: xyra_DelRadUwFlux (0:imax-1, 1:jmax, 0:kmax, 0:1)
   244:                                           ! 長波地表温度変化. 
   245:                                           ! 
   246:                 real(DP) :: xyra_DelRadDwFlux (0:imax-1, 1:jmax, 0:kmax, 0:1)
   247:                                           ! 長波地表温度変化. 
   248:                                           ! 
   249:             
   250:                 real(DP) :: WNs
   251:                 real(DP) :: WNe
   252:             
   253:                 integer:: k               ! 鉛直方向に回る DO ループ用作業変数
   254:                                           ! Work variables for DO loop in vertical direction
   255:                 integer:: n               ! 波長について回る DO ループ用作業変数
   256:                                           ! Work variables for DO loop in wavenumber bands
   257:             
   258:                 ! 実行文 ; Executable statement
   259:                 !
   260:             
   261:             
   262:                 k = 0
   263: W*===== A       xyr_Temp(:,:,k) =                                    &
   264:                   &      ( xyz_Temp (:,:,k+2) - xyz_Temp (:,:,k+1) ) &
   265:                   & / log( xyz_Press(:,:,k+2) / xyz_Press(:,:,k+1) ) &
   266:                   & * log( xyr_Press(:,:,k  ) / xyz_Press(:,:,k+1) ) &
   267:                   & + xyz_Temp(:,:,k+1)
   268: W------>        do k = 1, kmax-1
   269: |**==== A         xyr_Temp(:,:,k) =                                &
   270: |                   &      ( xyz_Temp (:,:,k+1) - xyz_Temp (:,:,k) ) &
   271: |                   & / log( xyz_Press(:,:,k+1) / xyz_Press(:,:,k) ) &
   272: |                   & * log( xyr_Press(:,:,k  ) / xyz_Press(:,:,k) ) &
   273: |                   & + xyz_Temp(:,:,k)
   274: W------         end do
   275:                 k = kmax
   276: W*===== A       xyr_Temp(:,:,k) = xyz_Temp(:,:,k)
   277:             
   278:                 !   Initialization
   279:                 !
   280: **W---->A       xyr_RadLUwFlux     = 0.0_DP
   281: **W---- A       xyr_RadLDwFlux     = 0.0_DP
   282: ***W--->A       xyra_DelRadLUwFlux = 0.0_DP
   283: ***W--- A       xyra_DelRadLDwFlux = 0.0_DP
   284:                 !
   285: +------>        LOOP_BAND_RTE : do n = 1, nbmax
   286: |           
   287: |           
   288: |                 ! $ \pi B $, $ \pi DBDT $ の計算
   289: |                 ! Calculate $ \pi B $ and $ \pi DBDT $
   290: |                 !
   291: |                 if ( nbmax == 1 ) then
   292: |           
   293: |W*==== A           xy_SurfIntPF = xy_SurfEmis * StB * ( xy_SurfTemp**4 )
   294: |W**=== A           xyr_IntPF    =               StB * ( xyr_Temp**4 )
   295: |*V---->A           xy_IntDPFDT0 = xy_SurfEmis * 4.0_DP * xy_SurfIntPF / xy_SurfTemp
   296: |||         !!$        xy_IntDPFDT1 =               4.0_DP * xyz_IntPF(:,:,1) / xyz_Temp(:,:,1)
   297: |*V---- A           xy_IntDPFDT1 = 0.0_DP
   298: |           
   299: |                 else
   300: |           
   301: |                   WNs = a_WNBnds(n-1)
   302: |                   WNe = a_WNBnds(n  )
   303: |                   call Integ_PF_GQ_Array3D(        &
   304: |                     & WNs, WNe, NumGaussNode,      &
   305: |                     & 0, imax-1, 1, jmax, 0, kmax, &
   306: |                     & xyr_Temp,                    &
   307: |                     & xyr_IntPF                    &
   308: |                     & )
   309: |                   call Integ_PF_GQ_Array2D(   &
   310: |                     & WNs, WNe, NumGaussNode, &
   311: |                     & 0, imax-1, 1, jmax,     &
   312: |                     & xy_SurfTemp,            &
   313: |                     & xy_SurfIntPF            &
   314: |                     & )
   315: |           !!$        call Integ_DPFDT_GQ_Array2D(             &
   316: |           !!$          & WNs, WNe, NumGaussNode,              & ! (in )
   317: |           !!$          & 0, imax-1, 1, jmax, xyz_Temp(:,:,1), & ! (in )
   318: |           !!$          & xy_IntDPFDT1                         & ! (out)
   319: |           !!$          & )
   320: |W*==== A           xy_IntDPFDT1 = 0.0_DP
   321: |                   call Integ_DPFDT_GQ_Array2D(         &
   322: |                     & WNs, WNe, NumGaussNode,          & ! (in )
   323: |                     & 0, imax-1, 1, jmax, xy_SurfTemp, & ! (in )
   324: |                     & xy_IntDPFDT0                     & ! (out)
   325: |                     & )
   326: |           
   327: |W*==== A           xy_SurfIntPF = xy_SurfEmis * PI * xy_SurfIntPF
   328: |W**=== A           xyr_IntPF    =               PI * xyr_IntPF
   329: |*W---->A           xy_IntDPFDT0 = xy_SurfEmis * PI * xy_IntDPFDT0
   330: |*W---- A           xy_IntDPFDT1 =               PI * xy_IntDPFDT1
   331: |           
   332: |                 end if
   333: |           
   334: |           
   335: |                 ! 光学的厚さの計算
   336: |                 ! Calculate optical depth
   337: |                 !
   338: |**W--->A         xyz_DelOptDepDryCom = a_AbsCoefDryCom(n)                             &
   339: ||||                & * ( xyz_Press / a_RefPressDryCom(n) )**a_PressScaleIndDryCom(n)  &
   340: ||||                & * xyz_DelAtmMass                                                 &
   341: ||||                & * RadActDryComMMR
   342: |**W--- A         xyz_DelOptDepH2OVap = a_AbsCoefH2OVap(n)                             &
   343: |                   & * ( xyz_Press / a_RefPressH2OVap(n) )**a_PressScaleIndH2OVap(n)  &
   344: |                   & * xyz_DelAtmMass * xyz_QH2OVap
   345: |           
   346: |           
   347: |++V===           call RadRTENonScatMonoSemiAnal(                              &
   348: |                   & xy_SurfAlbedo,                                           & ! (in)
   349: |                   & xyr_IntPF, xy_SurfIntPF, xy_IntDPFDT1, xy_IntDPFDT0,     & ! (in)
   350: |                   & ( xyz_DelOptDepDryCom + xyz_DelOptDepH2OVap ),           & ! (in)
   351: |                   & xyr_RadUwFlux, xyr_RadDwFlux,                            & ! (out)
   352: |                   & xyra_DelRadUwFlux, xyra_DelRadDwFlux                     & ! (out)
   353: |                   & )
   354: |           
   355: |           
   356: |**W--->A         xyr_RadLUwFlux     = xyr_RadLUwFlux     + xyr_RadUwFlux
   357: |**W--- A         xyr_RadLDwFlux     = xyr_RadLDwFlux     + xyr_RadDwFlux
   358: |***W-->A         xyra_DelRadLUwFlux = xyra_DelRadLUwFlux + xyra_DelRadUwFlux
   359: |***W-- A         xyra_DelRadLDwFlux = xyra_DelRadLDwFlux + xyra_DelRadDwFlux
   360: |           
   361: +------         end do LOOP_BAND_RTE
   362:             
   363:             
   364:               end subroutine RadSimpleLWFlux
   365:             
   366:               !--------------------------------------------------------------------------------------
   367:             
   368:               subroutine OLD_RadSimpleLWFlux(                                      &
   369:                 & xy_SurfEmis, xyz_Temp, xyz_Press, xy_SurfTemp,                   & ! (in)
   370:                 & xyz_DelAtmMass, xyz_QH2OVap,                                     & ! (in)
   371:                 & xyr_RadLUwFlux, xyr_RadLDwFlux,                                  & ! (out)
   372:                 & xyra_DelRadLUwFlux, xyra_DelRadLDwFlux                           & ! (out)
   373:                 & )
   374:                 !
   375:                 ! 長波フラックスの計算
   376:                 !
   377:                 ! Calculate long wave flux
   378:                 !
   379:             
   380:                 ! モジュール引用 ; USE statements
   381:                 !
   382:             
   383:                 ! 物理・数学定数設定
   384:                 ! Physical and mathematical constants settings
   385:                 !
   386:                 use constants0, only: &
   387:                   & PI,               &   ! $ \pi $ .
   388:                                           ! 円周率.  Circular constant
   389:                   & StB                   ! $ \sigma_{SB} $ . 
   390:                                           ! ステファンボルツマン定数. 
   391:                                           ! Stefan-Boltzmann constant
   392:             
   393:                 ! プランク関数の計算
   394:                 ! Calculate Planck function
   395:                 !
   396:                 use planck_func, only : Integ_PF_GQ_Array3D, Integ_PF_GQ_Array2D, Integ_DPFDT_GQ_Array2D
   397:             
   398:                 ! 散乱を無視した放射伝達方程式
   399:                 ! Radiative transfer equation without considering scattering
   400:                 !
   401:                 use rad_rte_nonscat, only : RadRTENonScat
   402:             
   403:             
   404:                 ! 宣言文 ; Declaration statements
   405:                 !
   406:                 real(DP), intent(in):: xy_SurfEmis       (0:imax-1, 1:jmax)
   407:                                           ! 地表面射出率.
   408:                                           ! Surface emissivity
   409:                 real(DP), intent(in):: xyz_Temp          (0:imax-1, 1:jmax, 1:kmax)
   410:                                           ! $ T $ .     温度. Temperature
   411:                 real(DP), intent(in):: xyz_Press         (0:imax-1, 1:jmax, 1:kmax)
   412:                                           ! $ T $ .     温度. Temperature
   413:             
   414:                 real(DP), intent(in):: xy_SurfTemp       (0:imax-1, 1:jmax)
   415:                                           ! 地表面温度. 
   416:                                           ! Surface temperature
   417:                 real(DP), intent(in):: xyz_DelAtmMass    (0:imax-1, 1:jmax, 1:kmax)
   418:                                           ! 
   419:                                           ! Atmospheric mass of layers
   420:                 real(DP), intent(in):: xyz_QH2OVap       (0:imax-1, 1:jmax, 1:kmax)
   421:                                           !
   422:                                           ! Specific humidity
   423:                 real(DP), intent(out):: xyr_RadLUwFlux     (0:imax-1, 1:jmax, 0:kmax)
   424:                                           ! 長波フラックス. 
   425:                                           ! Upward longwave flux
   426:                 real(DP), intent(out):: xyr_RadLDwFlux     (0:imax-1, 1:jmax, 0:kmax)
   427:                                           ! 長波フラックス. 
   428:                                           ! Downward longwave flux
   429:                 real(DP), intent(out):: xyra_DelRadLUwFlux (0:imax-1, 1:jmax, 0:kmax, 0:1)
   430:                                           ! 長波地表温度変化. 
   431:                                           ! 
   432:                 real(DP), intent(out):: xyra_DelRadLDwFlux (0:imax-1, 1:jmax, 0:kmax, 0:1)
   433:                                           ! 長波地表温度変化. 
   434:                                           ! 
   435:             
   436:                 ! 作業変数
   437:                 ! Work variables
   438:                 !
   439:                 real(DP) :: xyz_DelOptDepDryCom(0:imax-1, 1:jmax, 1:kmax)
   440:                 real(DP) :: xyz_DelOptDepH2OVap(0:imax-1, 1:jmax, 1:kmax)
   441:                 real(DP) :: xyz_TransEachLayer (0:imax-1, 1:jmax, 1:kmax)
   442:                 real(DP) :: xyrr_Trans         (0:imax-1, 1:jmax, 0:kmax, 0:kmax)
   443:                                           ! 透過係数. 
   444:                                           ! Transmission coefficient
   445:                 real(DP) :: xyz_IntPF   (0:imax-1, 1:jmax, 1:kmax)
   446:                 real(DP) :: xy_SurfIntPF(0:imax-1, 1:jmax)
   447:                 real(DP) :: xy_IntDPFDT0(0:imax-1, 1:jmax)
   448:                 real(DP) :: xy_IntDPFDT1(0:imax-1, 1:jmax)
   449:             
   450:                 real(DP) :: xyr_RadUwFlux     (0:imax-1, 1:jmax, 0:kmax)
   451:                                           ! 長波フラックス. 
   452:                                           ! Upward longwave flux
   453:                 real(DP) :: xyr_RadDwFlux     (0:imax-1, 1:jmax, 0:kmax)
   454:                                           ! 長波フラックス. 
   455:                                           ! Downward longwave flux
   456:                 real(DP) :: xyra_DelRadUwFlux (0:imax-1, 1:jmax, 0:kmax, 0:1)
   457:                                           ! 長波地表温度変化. 
   458:                                           ! 
   459:                 real(DP) :: xyra_DelRadDwFlux (0:imax-1, 1:jmax, 0:kmax, 0:1)
   460:                                           ! 長波地表温度変化. 
   461:                                           ! 
   462:             
   463:                 real(DP) :: WNs
   464:                 real(DP) :: WNe
   465:             
   466:                 integer:: k, kk           ! 鉛直方向に回る DO ループ用作業変数
   467:                                           ! Work variables for DO loop in vertical direction
   468:                 integer:: n               ! 波長について回る DO ループ用作業変数
   469:                                           ! Work variables for DO loop in wavenumber bands
   470:             
   471:                 ! 実行文 ; Executable statement
   472:                 !
   473:             
   474:             
   475:                 !   Initialization
   476:                 !
   477: **W---->A       xyr_RadLUwFlux     = 0.0_DP
   478: **W---- A       xyr_RadLDwFlux     = 0.0_DP
   479: ***W--->A       xyra_DelRadLUwFlux = 0.0_DP
   480: ***W--- A       xyra_DelRadLDwFlux = 0.0_DP
   481:                 !
   482: +------>        LOOP_BAND_RTE : do n = 1, nbmax
   483: |           
   484: |           
   485: |                 ! $ \pi B $, $ \pi DBDT $ の計算
   486: |                 ! Calculate $ \pi B $ and $ \pi DBDT $
   487: |                 !
   488: |                 if ( nbmax == 1 ) then
   489: |           
   490: |W*==== A           xy_SurfIntPF = xy_SurfEmis * StB * ( xy_SurfTemp**4 )
   491: |W**=== A           xyz_IntPF    =               StB * ( xyz_Temp**4 )
   492: |*V---->A           xy_IntDPFDT0 = xy_SurfEmis * 4.0_DP * xy_SurfIntPF / xy_SurfTemp
   493: |*V---- A           xy_IntDPFDT1 =               4.0_DP * xyz_IntPF(:,:,1) / xyz_Temp(:,:,1)
   494: |           
   495: |                 else
   496: |           
   497: |                   WNs = a_WNBnds(n-1)
   498: |                   WNe = a_WNBnds(n  )
   499: |                   call Integ_PF_GQ_Array3D(        &
   500: |                     & WNs, WNe, NumGaussNode,      &
   501: |                     & 0, imax-1, 1, jmax, 1, kmax, &
   502: |                     & xyz_Temp,                    &
   503: |                     & xyz_IntPF                    &
   504: |                     & )
   505: |                   call Integ_PF_GQ_Array2D(   &
   506: |                     & WNs, WNe, NumGaussNode, &
   507: |                     & 0, imax-1, 1, jmax,     &
   508: |                     & xy_SurfTemp,            &
   509: |                     & xy_SurfIntPF            &
   510: |                     & )
   511: |                   call Integ_DPFDT_GQ_Array2D(             &
   512: |                     & WNs, WNe, NumGaussNode,              & ! (in )
   513: |                     & 0, imax-1, 1, jmax, xyz_Temp(:,:,1), & ! (in )
   514: |                     & xy_IntDPFDT1                         & ! (out)
   515: |                     & )
   516: |                   call Integ_DPFDT_GQ_Array2D(         &
   517: |                     & WNs, WNe, NumGaussNode,          & ! (in )
   518: |                     & 0, imax-1, 1, jmax, xy_SurfTemp, & ! (in )
   519: |                     & xy_IntDPFDT0                     & ! (out)
   520: |                     & )
   521: |           
   522: |W*==== A           xy_SurfIntPF = xy_SurfEmis * PI * xy_SurfIntPF
   523: |W**=== A           xyz_IntPF    =               PI * xyz_IntPF
   524: |*W---->A           xy_IntDPFDT0 = xy_SurfEmis * PI * xy_IntDPFDT0
   525: |*W---- A           xy_IntDPFDT1 =               PI * xy_IntDPFDT1
   526: |           
   527: |                 end if
   528: |           
   529: |           
   530: |                 ! 光学的厚さの計算
   531: |                 ! Calculate optical depth
   532: |                 !
   533: |**W--->A         xyz_DelOptDepDryCom = a_AbsCoefDryCom(n)                             &
   534: ||||                & * ( xyz_Press / a_RefPressDryCom(n) )**a_PressScaleIndDryCom(n)  &
   535: ||||                & * xyz_DelAtmMass
   536: ||||    A         xyz_DelOptDepH2OVap = a_AbsCoefH2OVap(n)                             &
   537: ||||                & * ( xyz_Press / a_RefPressH2OVap(n) )**a_PressScaleIndH2OVap(n)  &
   538: ||||                & * xyz_DelAtmMass * xyz_QH2OVap
   539: ||||        
   540: ||||        
   541: ||||              ! 透過関数の計算
   542: ||||              ! Calculate transmission functions
   543: ||||              !
   544: |**W---           xyz_TransEachLayer = exp( - DiffFact * ( xyz_DelOptDepDryCom + xyz_DelOptDepH2OVap ) )
   545: |+----->          do k = 0, kmax
   546: ||*---->            do kk = k, k
   547: |||W*== A             xyrr_Trans(:,:,k,kk) = 1.0d0
   548: ||*----             end do
   549: ||+---->            do kk = k+1, kmax
   550: |||W*== A             xyrr_Trans(:,:,k,kk) = xyrr_Trans(:,:,k,kk-1) * xyz_TransEachLayer(:,:,kk)
   551: ||+----             end do
   552: ||+---->            do kk = 0, k-1
   553: |||W*== A             xyrr_Trans(:,:,k,kk) = xyrr_Trans(:,:,kk,k)
   554: ||+----             end do
   555: |+-----           end do
   556: |           
   557: |           
   558: |                 call RadRTENonScat(                                      &
   559: |                   & xyz_IntPF, xy_SurfIntPF, xy_IntDPFDT1, xy_IntDPFDT0, & ! (in)
   560: |                   & xyrr_Trans,                                          & ! (in)
   561: |                   & xyr_RadUwFlux, xyr_RadDwFlux,                        & ! (out)
   562: |                   & xyra_DelRadUwFlux, xyra_DelRadDwFlux                 & ! (out)
   563: |                   & )
   564: |           
   565: |           
   566: |**W--->A         xyr_RadLUwFlux     = xyr_RadLUwFlux     + xyr_RadUwFlux
   567: |**W--- A         xyr_RadLDwFlux     = xyr_RadLDwFlux     + xyr_RadDwFlux
   568: |***W-->A         xyra_DelRadLUwFlux = xyra_DelRadLUwFlux + xyra_DelRadUwFlux
   569: |***W-- A         xyra_DelRadLDwFlux = xyra_DelRadLDwFlux + xyra_DelRadDwFlux
   570: |           
   571: +------         end do LOOP_BAND_RTE
   572:             
   573:             
   574:               end subroutine OLD_RadSimpleLWFlux
   575:             
   576:               !--------------------------------------------------------------------------------------
   577:             
   578:               subroutine RadSimpleLWInit
   579:                 !
   580:                 ! rad_simple_LW モジュールの初期化を行います. 
   581:                 ! NAMELIST#rad_simple_LW_nml の読み込みはこの手続きで行われます. 
   582:                 !
   583:                 ! "rad_simple_LW" module is initialized. 
   584:                 ! "NAMELIST#rad_simple_LW_nml" is loaded in this procedure. 
   585:                 !
   586:             
   587:                 ! モジュール引用 ; USE statements
   588:                 !
   589:             
   590:                 ! 出力ファイルの基本情報
   591:                 ! Basic information for output files
   592:                 ! 
   593:                 use fileset, only: &
   594:                   & FileTitle, &
   595:                                           ! 出力データファイルの表題.
   596:                                           ! Title of output data files
   597:                   & FileSource, &
   598:                                           ! データファイル作成の手段. 
   599:                                           ! Source of data file
   600:                   & FileInstitution
   601:                                           ! データファイルを最終的に変更した組織/個人. 
   602:                                           ! Institution or person that changes data files for the last time
   603:             
   604:                 ! 物理・数学定数設定
   605:                 ! Physical and mathematical constants settings
   606:                 !
   607:                 use constants0, only: &
   608:                   & PI                    ! $ \pi $ .
   609:                                           ! 円周率.  Circular constant
   610:             
   611:                 ! 座標データ設定
   612:                 ! Axes data settings
   613:                 !
   614:                 use axesset, only: &
   615:                   & x_Lon, &
   616:                                           ! $ \lambda $ [rad.] . 経度. Longitude
   617:                   & x_Lon_Weight, &
   618:                                           ! $ \Delta \lambda $ [rad.] . 
   619:                                           ! 経度座標重み. 
   620:                                           ! Weight of longitude
   621:                   & y_Lat, &
   622:                                           ! $ \varphi $ [rad.] . 緯度. Latitude
   623:                   & y_Lat_Weight, &
   624:                                           ! $ \Delta \varphi $ [rad.] . 
   625:                                           ! 緯度座標重み. 
   626:                                           ! Weight of latitude
   627:                   & z_Sigma, &
   628:                                           ! $ \sigma $ レベル (整数). 
   629:                                           ! Full $ \sigma $ level
   630:                   & r_Sigma, &
   631:                                           ! $ \sigma $ レベル (半整数). 
   632:                                           ! Half $ \sigma $ level
   633:                   & z_DelSigma
   634:                                           ! $ \Delta \sigma $ (整数). 
   635:                                           ! $ \Delta \sigma $ (Full)
   636:             
   637:                 ! 時刻管理
   638:                 ! Time control
   639:                 !
   640:                 use timeset, only: &
   641:                   & RestartTime           ! リスタート開始時刻. 
   642:                                           ! Retart time of calculation
   643:             
   644:             
   645:                 ! NAMELIST ファイル入力に関するユーティリティ
   646:                 ! Utilities for NAMELIST file input
   647:                 !
   648:                 use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid
   649:             
   650:                 ! 暦と日時の取り扱い
   651:                 ! Calendar and Date handler
   652:                 !
   653:                 use dc_calendar, only: DCCalConvertByUnit
   654:             
   655:                 ! ファイル入出力補助
   656:                 ! File I/O support
   657:                 !
   658:                 use dc_iounit, only: FileOpen
   659:             
   660:                 ! 種別型パラメタ
   661:                 ! Kind type parameter
   662:                 !
   663:                 use dc_types, only: STDOUT ! 標準出力の装置番号. Unit number of standard output
   664:             
   665:                 ! 文字列操作
   666:                 ! Character handling
   667:                 !
   668:                 use dc_string, only: toChar
   669:             
   670:                 ! 散乱を無視した放射伝達方程式
   671:                 ! Radiative transfer equation without considering scattering
   672:                 !
   673:                 use rad_rte_nonscat, only : RadRTENonScatInit
   674:             
   675:                 ! 宣言文 ; Declaration statements
   676:                 !
   677:                 integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号. 
   678:                                           ! Unit number for NAMELIST file open
   679:                 integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT. 
   680:                                           ! IOSTAT of NAMELIST read
   681:             
   682:                 real(DP) :: WNBnds             (0:MaxNmlArySize)
   683:                 real(DP) :: AbsCoefDryCom      (1:MaxNmlArySize)
   684:                 real(DP) :: PressScaleIndDryCom(1:MaxNmlArySize)
   685:                 real(DP) :: RefPressDryCom     (1:MaxNmlArySize)
   686:                 real(DP) :: AbsCoefH2OVap      (1:MaxNmlArySize)
   687:                 real(DP) :: PressScaleIndH2OVap(1:MaxNmlArySize)
   688:                 real(DP) :: RefPressH2OVap     (1:MaxNmlArySize)
   689:             
   690:                 integer  :: n
   691:             
   692:                 ! NAMELIST 変数群
   693:                 ! NAMELIST group name
   694:                 !
   695:                 namelist /rad_simple_LW_nml/ &
   696:                   & nbmax, &
   697:                   & WNBnds,                                             &
   698:                   & AbsCoefDryCom, PressScaleIndDryCom, RefPressDryCom, &
   699:                   & AbsCoefH2OVap, PressScaleIndH2OVap, RefPressH2OVap, &
   700:                   & RadActDryComMMR,                                    &
   701:                   & DiffFact,                                           &
   702:                   & NumGaussNode
   703:                       !
   704:                       ! デフォルト値については初期化手続 "rad_DennouAGCM#RadInit" 
   705:                       ! のソースコードを参照のこと. 
   706:                       !
   707:                       ! Refer to source codes in the initialization procedure
   708:                       ! "rad_DennouAGCM#RadInit" for the default values. 
   709:                       !
   710:             
   711:                 ! 実行文 ; Executable statement
   712:                 !
   713:             
   714:                 if ( rad_simple_LW_inited ) return
   715:             
   716:             
   717:                 ! デフォルト値の設定
   718:                 ! Default values settings
   719:                 !
   720:             
   721:                 ! 長波フラックス用情報
   722:                 ! Information for long wave flux
   723:                 !
   724:             
   725:                 nbmax                  = 1
   726:             
   727: V====== A       WNBnds                 = -999.9_DP
   728: V------>A       AbsCoefDryCom          = -999.9_DP
   729: |       A       PressScaleIndDryCom    = -999.9_DP
   730: |       A       RefPressDryCom         = -999.9_DP
   731: |       A       AbsCoefH2OVap          = -999.9_DP
   732: |       A       PressScaleIndH2OVap    = -999.9_DP
   733: V------ A       RefPressH2OVap         = -999.9_DP
   734:             
   735: *------>        AbsCoefDryCom      (1:nbmax) = (/ 5.0d-5 /)
   736: |               PressScaleIndDryCom(1:nbmax) = (/ 0.0d0  /)
   737: |               RefPressDryCom     (1:nbmax) = (/ 1.0d5  /)
   738: |           
   739: |               AbsCoefH2OVap      (1:nbmax) = (/ 1.0d-2 /)
   740: |               PressScaleIndH2OVap(1:nbmax) = (/ 0.0d0  /)
   741: *------         RefPressH2OVap     (1:nbmax) = (/ 1.0d5  /)
   742:             
   743:                 RadActDryComMMR       = 1.0_DP
   744:             
   745:                 DiffFact        = 1.66_DP
   746:             
   747:                 NumGaussNode    = 5
   748:             
   749:             
   750:                 ! NAMELIST の読み込み
   751:                 ! NAMELIST is input
   752:                 !
   753:                 if ( trim(namelist_filename) /= '' ) then
   754:                   call FileOpen( unit_nml, &          ! (out)
   755:                     & namelist_filename, mode = 'r' ) ! (in)
   756:             
   757:                   rewind( unit_nml )
   758:                   read( unit_nml,                    & ! (in)
   759:                     & nml = rad_simple_LW_nml,       & ! (out)
   760:                     & iostat = iostat_nml )            ! (out)
   761:                   close( unit_nml )
   762:             
   763:                   call NmlutilMsg( iostat_nml, module_name ) ! (in)
   764:                 end if
   765:             
   766:                 if ( nbmax > MaxNmlArySize ) then
   767:                   call MessageNotify( 'E', module_name, 'nbmax = %d > %d', i = (/ nbmax, MaxNmlArySize /) )
   768:                 end if
   769:             
   770: V====== A       a_WNBnds              = WNBnds * 100.0_DP    ! Convert from cm-1 to m-1
   771:             !!$    a_AbsCoefDryCom = 5.0d-5
   772: V------>A       a_AbsCoefDryCom       = AbsCoefDryCom
   773: |       A       a_PressScaleIndDryCom = PressScaleIndDryCom
   774: |       A       a_RefPressDryCom      = RefPressDryCom
   775: |           
   776: |           !!$    a_AbsCoefH2OVap = 1.0d-2
   777: |       A       a_AbsCoefH2OVap = AbsCoefH2OVap
   778: |       A       a_PressScaleIndH2OVap = PressScaleIndH2OVap
   779: V------ A       a_RefPressH2OVap      = RefPressH2OVap
   780:             
   781:             
   782:                 ! Initialization of modules used in this module
   783:                 !
   784:             
   785:                 ! 散乱を無視した放射伝達方程式
   786:                 ! Radiative transfer equation without considering scattering
   787:                 !
   788:                 call RadRTENonScatInit
   789:             
   790:             
   791:                 ! 印字 ; Print
   792:                 !
   793:                 call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   794:             
   795:             !!$    call MessageNotify( 'M', module_name, 'DelTime:' )
   796:             !!$    call MessageNotify( 'M', module_name, '  DelTime  = %f [%c]', &
   797:             !!$      & d = (/ DelTimeValue /), c1 = trim( DelTimeUnit ) )
   798:             
   799:                 call MessageNotify( 'M', module_name, 'nbmax         = %d', i = (/ nbmax /) )
   800:             
   801:             !!$    call MessageNotify( 'M', module_name, 'WNBnds              = (/ %*r /)', &
   802:             !!$      & r = real( a_WNBnds(0:nbmax) ), n = (/ nbmax+1 /) )
   803:             !!$    call MessageNotify( 'M', module_name, 'AbsCoefDryCom       = (/ %*r /)', &
   804:             !!$      & r = real( a_AbsCoefDryCom(1:nbmax) ), n = (/ nbmax /) )
   805:             !!$    call MessageNotify( 'M', module_name, 'PressScaleIndDryCom = (/ %*r /)', &
   806:             !!$      & r = real( a_PressScaleIndDryCom(1:nbmax) ), n = (/ nbmax /) )
   807:             !!$    call MessageNotify( 'M', module_name, 'RefPressDryCom      = (/ %*r /)', &
   808:             !!$      & r = real( a_RefPressDryCom(1:nbmax) ), n = (/ nbmax /) )
   809:             !!$    call MessageNotify( 'M', module_name, 'AbsCoefH2OVap       = (/ %*r /)', &
   810:             !!$      & r = real( a_AbsCoefH2OVap(1:nbmax) ), n = (/ nbmax /) )
   811:             !!$    call MessageNotify( 'M', module_name, 'PressScaleIndH2OVap = (/ %*r /)', &
   812:             !!$      & r = real( a_PressScaleIndH2OVap(1:nbmax) ), n = (/ nbmax /) )
   813:             !!$    call MessageNotify( 'M', module_name, 'RefPressH2OVap      = (/ %*r /)', &
   814:             !!$      & r = real( a_RefPressH2OVap(1:nbmax) ), n = (/ nbmax /) )
   815:             
   816: +------>        do n = 1, nbmax
   817: |                 call MessageNotify( 'M', module_name, '  %d : %f %f %f %f %f %f %f %f',       &
   818: |                   & i = (/ n /),                                                              &
   819: |                   & d = (/ a_WNBnds(n-1)*1.0e-2, a_WNBnds(n)*1.0e-2,                          &
   820: |                   &        a_AbsCoefDryCom(n), a_PressScaleIndDryCom(n), a_RefPressDryCom(n), &
   821: |                   &        a_AbsCoefH2OVap(n), a_PressScaleIndH2OVap(n), a_RefPressH2OVap(n) /) )
   822: +------         end do
   823:             
   824:                 call MessageNotify( 'M', module_name, 'RadActDryComMMR = %f', d = (/ RadActDryComMMR /) )
   825:                 call MessageNotify( 'M', module_name, 'DiffFact        = %f', d = (/ DiffFact /) )
   826:             !
   827:                 call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   828:             
   829:                 rad_simple_LW_inited = .true.
   830:             
   831:               end subroutine RadSimpleLWInit
   832:             
   833:               !--------------------------------------------------------------------------------------
   834:             
   835:             end module rad_simple_LW
