Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:39:00 2016
FILE NAME: rad_simple_SW_V2_0.f90
PROGRAM NAME: rad_simple_sw_v2_0
DIAGNOSTIC LIST

  LINE  LEVEL( NO.): DIAGNOSTIC MESSAGE

   267  opt  (  11): Fused array assignments. :line 267 - 268
   267  opt  (1593): Loop nest collapsed into one loop.
   267  vec  (   4): Vectorized array expression.
   267  vec  (  29): ADB is used for array.: xyr_radsdwflux
   267  vec  (  29): ADB is used for array.: xyr_radsuwflux
   278  opt  (1017): Subroutine call prevents optimization.
   292  opt  (1592): Outer loop unrolled inside inner loop.
   292  vec  (   4): Vectorized array expression.
   292  vec  (  29): ADB is used for array.: xyz_delatmmass
   292  vec  (   4): Vectorized array expression.
   292  vec  (  29): ADB is used for array.: xyz_delatmmass
   294  opt  (1593): Loop nest collapsed into one loop.
   294  vec  (   4): Vectorized array expression.
   300  opt  (1593): Loop nest collapsed into one loop.
   300  vec  (   4): Vectorized array expression.
   303  opt  (1593): Loop nest collapsed into one loop.
   303  vec  (   4): Vectorized array expression.
   303  vec  (  29): ADB is used for array.: xyr_totoptdep
   304  vec  (   3): Unvectorized loop.
   304  vec  (  13): Overhead of loop division is too large.
   305  opt  (1037): Feedback of array elements.
   305  opt  (1593): Loop nest collapsed into one loop.
   305  vec  (   4): Vectorized array expression.
   305  vec  (  29): ADB is used for array.: xyr_totoptdep
   335  opt  (  11): Fused array assignments. :line 335 - 336
   335  opt  (1593): Loop nest collapsed into one loop.
   335  vec  (   4): Vectorized array expression.
   335  vec  (  29): ADB is used for array.: xyr_radsdwflux
   335  vec  (  29): ADB is used for array.: xyr_raddwflux
   335  vec  (  29): ADB is used for array.: xyr_radsuwflux
   335  vec  (  29): ADB is used for array.: xyr_raduwflux
   347  vec  (   3): Unvectorized loop.
   351  opt  (1017): Subroutine call prevents optimization.
   351  vec  (  10): Vectorization obstructive procedure reference.:radcl1996uvvisparams
   368  opt  (1593): Loop nest collapsed into one loop.
   368  vec  (   4): Vectorized array expression.
   368  vec  (  29): ADB is used for array.: xyz_qh2ovap
   368  vec  (  29): ADB is used for array.: xyz_delatmmass
   368  vec  (  29): ADB is used for array.: xyz_press
   372  opt  (1593): Loop nest collapsed into one loop.
   372  vec  (   4): Vectorized array expression.
   372  vec  (  29): ADB is used for array.: xyr_totoptdep
   373  vec  (   3): Unvectorized loop.
   373  vec  (  13): Overhead of loop division is too large.
   374  opt  (1037): Feedback of array elements.
   374  opt  (1593): Loop nest collapsed into one loop.
   374  vec  (   4): Vectorized array expression.
   374  vec  (  29): ADB is used for array.: xyr_totoptdep
   395  opt  (  11): Fused array assignments. :line 395 - 396
   395  opt  (1593): Loop nest collapsed into one loop.
   395  vec  (   4): Vectorized array expression.
   395  vec  (  29): ADB is used for array.: xyr_radsdwflux
   395  vec  (  29): ADB is used for array.: xyr_raddwflux
   395  vec  (  29): ADB is used for array.: xyr_radsuwflux
   395  vec  (  29): ADB is used for array.: xyr_raduwflux
   405  warn (  82): Name "i" is not used.
   405  warn (  82): Name "j" is not used.
   405  warn (  82): Name "xyr_radflux" is not used.
   488  opt  (  11): Fused array assignments. :line 488 - 490
   488  vec  (   4): Vectorized array expression.
   488  vec  (  29): ADB is used for array.: refpressh2ovap
   488  vec  (  29): ADB is used for array.: pressscaleindh2ovap
   488  vec  (  29): ADB is used for array.: abscoefh2ovap
   492  opt  (  11): Fused array assignments. :line 492 - 494
   516  opt  (  11): Fused array assignments. :line 516 - 518
   516  vec  (   4): Vectorized array expression.
   516  vec  (  29): ADB is used for array.: a_refpressh2ovap
   516  vec  (  29): ADB is used for array.: refpressh2ovap
   516  vec  (  29): ADB is used for array.: a_pressscaleindh2ovap
   516  vec  (  29): ADB is used for array.: pressscaleindh2ovap
   516  vec  (  29): ADB is used for array.: a_abscoefh2ovap
   516  vec  (  29): ADB is used for array.: abscoefh2ovap
   551  vec  (   3): Unvectorized loop.
   553  opt  (1017): Subroutine call prevents optimization.
   553  vec  (  10): Vectorization obstructive procedure reference.:messagenotifyc
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:39:00 2016
FILE NAME: rad_simple_SW_V2_0.f90
PROGRAM NAME: rad_simple_sw_v2_0
TRANSFORMATION LIST

  LINE                   FORTRAN STATEMENT

     1  != 簡単短波放射モデル Ver. 2.0
     2  !
     3  != simple short wave radiation model Ver. 2.0
     4  !
     5  ! Authors::   Yoshiyuki O. Takahashi
     6  ! Version::   $Id: rad_Earth_SW_V2_6.f90,v 1.1 2015/01/29 12:16:19 yot Exp $
     7  ! Tag Name::  $Name:  $
     8  ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9  ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10  !
    11  module rad_simple_SW_V2_0
    12  
    13    !
    14    != 簡単短波放射モデル Ver. 2.0
    15    !
    16    != simple short wave radiation model Ver. 2.0
    17    !
    18    ! <b>Note that Japanese and English are described in parallel.</b>
    19    !
    20    ! 地球大気向け短波放射モデル.
    21    !
    22    ! This is a simple short wave radiation model.
    23    !
    24    ! This module is created by simplifying rad_Earth_SW_V2_6.f90.
    25    !
    26    !== References
    27    !
    28    !
    29    !== Procedures List
    30    !
    31    ! RadSimpleSWV20Flux  :: 放射フラックスの計算
    32    ! ------------        :: ------------
    33    ! RadSimpleSWV20Flux  :: Calculate radiation flux
    34    !
    35    !== NAMELIST
    36    !
    37    ! NAMELIST#rad_simple_SW_V2_0_nml
    38    !
    39  
    40    ! USE statements
    41    !
    42  
    43    !
    44    ! Kind type parameter
    45    !
    46    use dc_types, only: DP, &      ! Double precision.
    47      &                 STRING, &  ! Strings.
    48      &                 TOKEN      ! Keywords.
    49  
    50    ! メッセージ出力
    51    ! Message output
    52    !
    53    use dc_message, only: MessageNotify
    54  
    55  
    56    ! 格子点設定
    57    ! Grid points settings
    58    !
    59    use gridset, only: imax, & ! 経度格子点数.
    60                               ! Number of grid points in longitude
    61      &                jmax, & ! 緯度格子点数.
    62                               ! Number of grid points in latitude
    63      &                kmax    ! 鉛直層数.
    64                               ! Number of vertical level
    65  
    66    ! NAMELIST ファイル入力に関するユーティリティ
    67    ! Utilities for NAMELIST file input
    68    !
    69    use namelist_util, only: MaxNmlArySize
    70                               ! NAMELIST から読み込む配列の最大サイズ.
    71                               ! Maximum size of arrays loaded from NAMELIST
    72  
    73    ! 時刻管理
    74    ! Time control
    75    !
    76    use timeset, only: &
    77      & TimesetClockStart, TimesetClockStop
    78  
    79  
    80    implicit none
    81  
    82    private
    83  
    84    logical , save      :: FlagRayleighScattering
    85  
    86    real(DP), save      :: RayleighScatCoefRatio
    87                               ! Ratio of Rayleight scattering coefficient
    88                               ! to that of Earth's atmosphere
    89  
    90    integer , save:: nbmax
    91                               ! 長波バンド数.
    92                               ! Number of long wave band
    93    real(DP), save:: a_WNBnds(0:MaxNmlArySize)
    94                               !
    95                               ! Wavenumber bounds for bands
    96    real(DP), save:: a_AbsCoefH2OVap(1:MaxNmlArySize)
    97                               ! $ k_R $ . 水の吸収係数
    98                               ! Absorption coefficient of water vapor
    99    real(DP), save:: a_PressScaleIndH2OVap(1:MaxNmlArySize)
   100                               !
   101                               ! Pressure scaling index for water vapor
   102    real(DP), save:: a_RefPressH2OVap(1:MaxNmlArySize)
   103                               !
   104                               ! Reference pressure for water vapor
   105    real(DP), save:: DiffFact
   106                               !
   107                               ! Diffusivity factor
   108  
   109    ! 公開変数
   110    ! Public variables
   111    !
   112    logical, save :: rad_simple_SW_V2_0_inited = .false.
   113                                ! 初期設定フラグ.
   114                                ! Initialization flag
   115  
   116    public :: RadSimpleSWV20Flux
   117    public :: RadSimpleSWV20Init
   118  
   119    character(*), parameter:: module_name = 'rad_simple_SW_V2_0'
   120                                ! モジュールの名称.
   121                                ! Module name
   122    character(*), parameter:: version = &
   123      & '$Name:  $' // &
   124      & '$Id: rad_Earth_SW_V2_6.f90,v 1.1 2015/01/29 12:16:19 yot Exp $'
   125                                ! モジュールのバージョン
   126                                ! Module version
   127  
   128    !--------------------------------------------------------------------------------------
   129  
   130  contains
   131  
   132    !--------------------------------------------------------------------------------------
   133  
   134    subroutine RadSimpleSWV20Flux(                               &
   135      & xy_SurfAlbedo,                                           &
   136      & xyz_Press,                                               &
   137      & xyz_DelAtmMass, xyz_QH2OVap,                             &
   138      & xyr_RadSUwFlux, xyr_RadSDwFlux                           &
   139      & )
   140  
   141      ! USE statements
   142      !
   143  
   144      ! 太陽放射フラックスの設定
   145      ! Set solar constant
   146      !
   147      use set_solarconst, only : SetSolarConst
   148  
   149      ! 短波入射 (太陽入射)
   150      ! Short wave (insolation) incoming
   151      !
   152      use rad_short_income, only : RadShortIncome
   153  
   154      !
   155      ! Solve radiative transfer equation in two stream approximation
   156      !
   157      use rad_rte_two_stream_app, only: &
   158        & RadRTETwoStreamAppSW,         &
   159        & RadRTETwoStreamAppHomogAtm
   160  
   161      ! Chou and Lee (1996) による短波放射モデル
   162      ! Short wave radiation model described by Chou and Lee (1996)
   163      !
   164      use rad_CL1996, only :       &
   165        & RadCL1996NumBands      , &
   166        & RadCL1996UVVISParams
   167  
   168  
   169      real(DP), intent(in ) :: xy_SurfAlbedo    (0:imax-1, 1:jmax )
   170      real(DP), intent(in ) :: xyz_Press        (0:imax-1, 1:jmax, 1:kmax)
   171                                  ! $ P $ .     圧力. Pressure
   172      real(DP), intent(in ) :: xyz_DelAtmMass   (0:imax-1, 1:jmax, 1:kmax)
   173      real(DP), intent(in ) :: xyz_QH2OVap      (0:imax-1, 1:jmax, 1:kmax)
   174                                  !
   175                                  ! Specific humidity
   176      real(DP), intent(out) :: xyr_RadSUwFlux   (0:imax-1, 1:jmax, 0:kmax)
   177      real(DP), intent(out) :: xyr_RadSDwFlux   (0:imax-1, 1:jmax, 0:kmax)
   178  
   179  
   180      real(DP) :: SolarConst
   181  
   182      real(DP) :: xy_InAngle    (0:imax-1, 1:jmax)
   183                                ! sec (入射角).
   184                                ! sec (angle of incidence)
   185      real(DP) :: DistFromStarScld
   186                                 ! Distance between the central star and the planet
   187      real(DP) :: DiurnalMeanFactor
   188  
   189  
   190      integer  :: nbands1
   191      integer  :: nbands2
   192  
   193      real(DP) :: UVVISFracSolarFlux
   194      real(DP) :: UVVISO3AbsCoef
   195      real(DP) :: UVVISRayScatCoef
   196  
   197      real(DP) :: SolarFluxTOA
   198  
   199  
   200  
   201  !!$    real(DP) :: xyz_SSA       (0:imax-1, 1:jmax, 1:kmax)
   202  !!$    real(DP) :: xyz_AF        (0:imax-1, 1:jmax, 1:kmax)
   203  
   204  
   205      real(DP), parameter :: RayScatSinScatAlb = 1.0d0 - 1.0d-10
   206      real(DP), parameter :: RayScatAsymFact   = 0.0d0
   207  
   208      real(DP)            :: xyz_RayScatDelOptDep( 0:imax-1, 1:jmax, 1:kmax )
   209  
   210      real(DP)            :: xyz_DelOptDepH2OVap(0:imax-1, 1:jmax, 1:kmax)
   211  
   212      real(DP)            :: xyz_DelTotOptDep( 0:imax-1, 1:jmax, 1:kmax )
   213      real(DP)            :: xyr_TotOptDep   ( 0:imax-1, 1:jmax, 0:kmax )
   214      real(DP)            :: xyr_RadFlux     ( 0:imax-1, 1:jmax, 0:kmax )
   215      real(DP)            :: xyr_RadUwFlux   ( 0:imax-1, 1:jmax, 0:kmax )
   216      real(DP)            :: xyr_RadDwFlux   ( 0:imax-1, 1:jmax, 0:kmax )
   217  
   218      real(DP) :: TotUVVISFracSolarFlux
   219  
   220  
   221  
   222      integer  :: i
   223      integer  :: j
   224      integer  :: k
   225      integer  :: l
   226      integer  :: n
   227  
   228  
   229      ! 初期化確認
   230      ! Initialization check
   231      !
   232      if ( .not. rad_simple_SW_V2_0_inited ) then
   233        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   234      end if
   235  
   236  
   237      ! 計算時間計測開始
   238      ! Start measurement of computation time
   239      !
   240      call TimesetClockStart( module_name )
   241  
   242  
   243      ! 太陽放射フラックスの設定
   244      ! Set solar constant
   245      !
   246      call SetSolarConst( &
   247        & SolarConst      & ! (out)
   248        & )
   249  
   250      ! 短波入射の計算
   251      ! Calculate short wave (insolation) incoming radiation
   252      !
   253      call RadShortIncome(                       &
   254        & xy_InAngle        = xy_InAngle,        & ! (out) optional
   255        & DistFromStarScld  = DistFromStarScld,  & ! (out) optional
   256        & DiurnalMeanFactor = DiurnalMeanFactor  &
   257        & )
   258  
   259  
   260      call RadCL1996NumBands(   &
   261        & nbands1, nbands2      & ! (out)
   262        & )
   263  
   264  
   265      ! Initialization
   266      !
   267      xyr_RadSUwFlux = 0.0_DP
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t394 = 1, jmax*(kmax*imax + imax)                              
     .           xyr_radsuwflux(t394-1,1,0) = 0.0000000000000000e+000           
     .           xyr_radsdwflux(t394-1,1,0) = 0.0000000000000000e+000           
     .        enddo                                                             
   268      xyr_RadSDwFlux = 0.0_DP
   269  
   270  
   271      ! * 14286 to 57143 cm-1 (0.175 to 0.70 micron):
   272      !   * Rayleigh scattering,
   273      !
   274      do l = 1, nbands1
   275  
   276        ! UV and Visible optical properties and solar flux
   277        !
   278        call RadCL1996UVVISParams(                                &
   279          & l,                                                    & ! (in )
   280          & UVVISFracSolarFlux, UVVISO3AbsCoef, UVVISRayScatCoef  & ! (out)
   281          & )
   282  
   283        ! Rayleigh scattering coefficient is multiplied by a ratio
   284        UVVISRayScatCoef = UVVISRayScatCoef * RayleighScatCoefRatio
   285  
   286        SolarFluxTOA = UVVISFracSolarFlux * SolarConst / DistFromStarScld**2 * DiurnalMeanFactor
   287  
   288  
   289        ! Rayleigh scattering
   290        !
   291        if ( FlagRayleighScattering ) then
   292          xyz_RayScatDelOptDep = UVVISRayScatCoef * xyz_DelAtmMass
     .        if (1 + jmax - min0(1,jmax) .gt. 0) then                          
     .           j1 = and(1 + jmax - min0(1,jmax),3)                            
     .  !cdir    nodep                                                          
     .           do t530 = 1, j1                                                
     .  !cdir       nodep                                                       
     .              do t532 = 1, 1 + imax - min0(1,imax)                        
     .                 xyz_rayscatdeloptdep(t532-1,t530,t528+1) =               
     .       1            uvvisrayscatcoef*xyz_delatmmass(t532-1,t530,t528+1)   
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t530 = j1 + 1, 1 + jmax - min0(1,jmax), 4                   
     .  !cdir       nodep                                                       
     .              do t532 = 1, 1 + imax - min0(1,imax)                        
     .                 xyz_rayscatdeloptdep(t532-1,t530,t528+1) =               
     .       1            uvvisrayscatcoef*xyz_delatmmass(t532-1,t530,t528+1)   
     .                 xyz_rayscatdeloptdep(t532-1,t530+1,t528+1) =             
     .       1            uvvisrayscatcoef*xyz_delatmmass(t532-1,t530+1,t528+1) 
     .                 xyz_rayscatdeloptdep(t532-1,t530+2,t528+1) =             
     .       1            uvvisrayscatcoef*xyz_delatmmass(t532-1,t530+2,t528+1) 
     .                 xyz_rayscatdeloptdep(t532-1,t530+3,t528+1) =             
     .       1            uvvisrayscatcoef*xyz_delatmmass(t532-1,t530+3,t528+1) 
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
   293        else
   294          xyz_RayScatDelOptDep = 0.0d0
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t406 = 1, xyz_rayscatdeloptdep.DSC.U3*(                        
     .       1   xyz_rayscatdeloptdep.DSC.U2*xyz_rayscatdeloptdep.DSC.U1 +      
     .       2   xyz_rayscatdeloptdep.DSC.U2)                                   
     .           xyz_rayscatdeloptdep(t406-1,1,1) = 0.0000000000000000e+000     
     .        enddo                                                             
   295        end if
   296  
   297  
   298        ! Total optical parameter
   299        !
   300        xyz_DelTotOptDep =            &
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t415 = 1, xyz_rayscatdeloptdep.DSC.U3*(                        
     .       1   xyz_rayscatdeloptdep.DSC.U2*xyz_rayscatdeloptdep.DSC.U1 +      
     .       2   xyz_rayscatdeloptdep.DSC.U2)                                   
     .           xyz_deltotoptdep(t415-1,1,1) = xyz_rayscatdeloptdep(t415-1,1,1)
     .        enddo                                                             
   301          & + xyz_RayScatDelOptDep
   302        !
   303        xyr_TotOptDep(:,:,kmax) = 0.0d0
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t427 = 1, xyr_totoptdep.DSC.U2*xyr_totoptdep.DSC.U1 +          
     .       1   xyr_totoptdep.DSC.U2                                           
     .           xyr_totoptdep(t427-1,1,kmax) = 0.0000000000000000e+000         
     .        enddo                                                             
   304        do k = kmax-1, 0, -1
   305          xyr_TotOptDep(:,:,k) = xyr_TotOptDep(:,:,k+1) + xyz_DelTotOptDep(:,:,k+1)
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xyr_totoptdep)                                             
     .        do t433 = 1, xyr_totoptdep.DSC.U2*xyr_totoptdep.DSC.U1 +          
     .       1   xyr_totoptdep.DSC.U2                                           
     .           xyr_totoptdep(t433-1,1,k) = xyr_totoptdep(t433-1,1,k+1) +      
     .       1      xyz_deltotoptdep(t433-1,1,k+1)                              
     .        enddo                                                             
   306        end do
   307        !
   308  !!$      xyz_SSA = RayScatSinScatAlb
   309  !!$      do k = 1, kmax
   310  !!$        do j = 1, jmax
   311  !!$          do i = 0, imax-1
   312  !!$            if ( xyz_SSA(i,j,k) >= 1.0d0 ) then
   313  !!$              xyz_SSA(i,j,k) = 1.0d0 - 1.0d-10
   314  !!$            end if
   315  !!$          end do
   316  !!$        end do
   317  !!$      end do
   318  !!$      xyz_AF  = RayScatAsymFact
   319  !!$
   320  !!$      call RadRTETwoStreamAppSW(        &
   321  !!$        & xyz_SSA, xyz_AF,              & ! (in)
   322  !!$        & xyr_TotOptDep,                & ! (in)
   323  !!$        & xy_SurfAlbedo,                & ! (in)
   324  !!$        & SolarFluxTOA, xy_InAngle,     & ! (in)
   325  !!$        & xyr_RadUwFlux, xyr_RadDwFlux  & ! (out)
   326  !!$        & )
   327  
   328        call RadRTETwoStreamAppHomogAtm(                         &
   329          & xy_SurfAlbedo, SolarFluxTOA, xy_InAngle,             & ! (in )
   330          & RayScatSinScatAlb, RayScatAsymFact, xyr_TotOptDep,   & ! (in )
   331          & xyr_RadUwFlux, xyr_RadDwFlux                         & ! (out)
   332          & )
   333  
   334  
   335        xyr_RadSUwFlux = xyr_RadSUwFlux + xyr_RadUwFlux
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t443 = 1, jmax*(kmax*imax + imax)                              
     .           xyr_radsuwflux(t443-1,1,0) = xyr_radsuwflux(t443-1,1,0) +      
     .       1      xyr_raduwflux(t443-1,1,0)                                   
     .           xyr_radsdwflux(t443-1,1,0) = xyr_radsdwflux(t443-1,1,0) +      
     .       1      xyr_raddwflux(t443-1,1,0)                                   
     .        enddo                                                             
   336        xyr_RadSDwFlux = xyr_RadSDwFlux + xyr_RadDwFlux
   337  
   338      end do
   339  
   340  
   341      ! * 1000 to 14286 cm-1 (0.70-10 micron):
   342      !
   343  
   344      SolarFluxTOA = SolarConst / DistFromStarScld**2 * DiurnalMeanFactor
   345  
   346      TotUVVISFracSolarFlux = 0.0_DP
   347      do l = 1, nbands1
   348  
   349        ! UV and Visible optical properties and solar flux
   350        !
   351        call RadCL1996UVVISParams(                                &
   352          & l,                                                    & ! (in )
   353          & UVVISFracSolarFlux, UVVISO3AbsCoef, UVVISRayScatCoef  & ! (out)
   354          & )
   355  
   356        TotUVVISFracSolarFlux = TotUVVISFracSolarFlux + UVVISFracSolarFlux
   357      end do
   358      if ( TotUVVISFracSolarFlux > 1.0_DP ) then
   359        call MessageNotify( 'E', module_name, &
   360          & 'TotUVVISFracSolarFlux, %f, is greater than 1.', &
   361          & d = (/TotUVVISFracSolarFlux/) )
   362      end if
   363  
   364      SolarFluxTOA = SolarFluxTOA * ( 1.0_DP - TotUVVISFracSolarFlux )
   365  
   366  
   367      n = 1
   368      xyz_DelOptDepH2OVap = a_AbsCoefH2OVap(n)                             &
     .        d1 = 1.D0/a_refpressh2ovap(1)                                     
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t467 = 1, kmax*jmax*imax                                       
     .           xyz_deloptdeph2ovap(t467-1,1,1) = a_abscoefh2ovap(1)*(xyz_press
     .       1      (t467-1,1,1)*d1)**a_pressscaleindh2ovap(1)*xyz_delatmmass(  
     .       2      t467-1,1,1)*xyz_qh2ovap(t467-1,1,1)                         
     .        enddo                                                             
   369        & * ( xyz_Press / a_RefPressH2OVap(n) )**a_PressScaleIndH2OVap(n)  &
   370        & * xyz_DelAtmMass * xyz_QH2OVap
   371      !
   372      xyr_TotOptDep = 0.0_DP
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t485 = 1, (xyr_totoptdep.DSC.U3 + 1)*xyr_totoptdep.DSC.U2*(    
     .       1   xyr_totoptdep.DSC.U1 + 1)                                      
     .           xyr_totoptdep(t485-1,1,0) = 0.0000000000000000e+000            
     .        enddo                                                             
   373      do k = kmax, 1, -1
   374        xyr_TotOptDep(:,:,k-1) = xyr_TotOptDep(:,:,k) + xyz_DelOptDepH2OVap(:,:,k)
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xyr_totoptdep)                                             
     .        do t494 = 1, xyr_totoptdep.DSC.U2*xyr_totoptdep.DSC.U1 +          
     .       1   xyr_totoptdep.DSC.U2                                           
     .           xyr_totoptdep(t494-1,1,k-1) = xyr_totoptdep(t494-1,1,k) +      
     .       1      xyz_deloptdeph2ovap(t494-1,1,k)                             
     .        enddo                                                             
   375      end do
   376  
   377  
   378  !!$    xyz_SSA = 1.0_DP - 1.0e-100_DP
   379  !!$    xyz_AF  = 0.0_DP
   380  !!$
   381  !!$    call RadRTETwoStreamAppSW(        &
   382  !!$      & xyz_SSA, xyz_AF,              & ! (in)
   383  !!$      & xyr_TotOptDep,                & ! (in)
   384  !!$      & xy_SurfAlbedo,                & ! (in)
   385  !!$      & SolarFluxTOA, xy_InAngle,     & ! (in)
   386  !!$      & xyr_RadUwFlux, xyr_RadDwFlux  & ! (out)
   387  !!$      & )
   388  
   389      call RadRTETwoStreamAppHomogAtm(                &
   390        & xy_SurfAlbedo, SolarFluxTOA, xy_InAngle,    & ! (in )
   391        & 1.0_DP - 1.0e-10_DP, 0.0_DP, xyr_TotOptDep, & ! (in )
   392        & xyr_RadUwFlux, xyr_RadDwFlux                & ! (out)
   393        & )
   394  
   395      xyr_RadSUwFlux = xyr_RadSUwFlux + xyr_RadUwFlux
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t504 = 1, jmax*(kmax*imax + imax)                              
     .           xyr_radsuwflux(t504-1,1,0) = xyr_radsuwflux(t504-1,1,0) +      
     .       1      xyr_raduwflux(t504-1,1,0)                                   
     .           xyr_radsdwflux(t504-1,1,0) = xyr_radsdwflux(t504-1,1,0) +      
     .       1      xyr_raddwflux(t504-1,1,0)                                   
     .        enddo                                                             
   396      xyr_RadSDwFlux = xyr_RadSDwFlux + xyr_RadDwFlux
   397  
   398  
   399      ! 計算時間計測一時停止
   400      ! Pause measurement of computation time
   401      !
   402      call TimesetClockStop( module_name )
   403  
   404  
   405    end subroutine RadSimpleSWV20Flux
   406  
   407    !--------------------------------------------------------------------------------------
   408  
   409    subroutine RadSimpleSWV20Init
   410  
   411      ! ファイル入出力補助
   412      ! File I/O support
   413      !
   414      use dc_iounit, only: FileOpen
   415  
   416      ! NAMELIST ファイル入力に関するユーティリティ
   417      ! Utilities for NAMELIST file input
   418      !
   419      use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid
   420  
   421      ! 太陽放射フラックスの設定
   422      ! Set solar constant
   423      !
   424      use set_solarconst, only : SetSolarConstInit
   425  
   426      ! 短波入射 (太陽入射)
   427      ! Short wave (insolation) incoming
   428      !
   429      use rad_short_income, only : RadShortIncomeInit
   430  
   431      !
   432      ! Solve radiative transfer equation in two stream approximation
   433      !
   434      use rad_rte_two_stream_app, only: RadRTETwoStreamAppInit
   435  
   436      ! Chou and Lee (1996) による短波放射モデル
   437      ! Short wave radiation model described by Chou and Lee (1996)
   438      !
   439      use rad_CL1996, only : RadCL1996Init
   440  
   441  
   442      ! 宣言文 ; Declaration statements
   443      !
   444  
   445      real(DP) :: WNBnds             (0:MaxNmlArySize)
   446  
   447      real(DP) :: AbsCoefH2OVap      (1:MaxNmlArySize)
   448      real(DP) :: PressScaleIndH2OVap(1:MaxNmlArySize)
   449      real(DP) :: RefPressH2OVap     (1:MaxNmlArySize)
   450  
   451  
   452      integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号.
   453                                ! Unit number for NAMELIST file open
   454      integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT.
   455                                ! IOSTAT of NAMELIST read
   456  
   457      integer:: n
   458  
   459      ! NAMELIST 変数群
   460      ! NAMELIST group name
   461      !
   462      namelist /rad_simple_SW_V2_0_nml/ &
   463        & FlagRayleighScattering,       &
   464        & RayleighScatCoefRatio,        &
   465  !!$      & nbmax, &
   466        & AbsCoefH2OVap, PressScaleIndH2OVap, RefPressH2OVap, &
   467        & DiffFact
   468            !
   469            ! デフォルト値については初期化手続 "rad_simple_SW_V2_0#RadSimpleSWV20Init"
   470            ! のソースコードを参照のこと.
   471            !
   472            ! Refer to source codes in the initialization procedure
   473            ! "rad_simple_SW_V2_6#RadSimpleSWEV20Init" for the default values.
   474            !
   475  
   476      if ( rad_simple_SW_V2_0_inited ) return
   477  
   478  
   479      ! デフォルト値の設定
   480      ! Default values settings
   481      !
   482      FlagRayleighScattering = .true.
   483      RayleighScatCoefRatio  = 1.0_DP
   484  
   485      nbmax = 1
   486      WNBnds                 = -999.9_DP
     .  

   487  
   488      AbsCoefH2OVap          = -999.9_DP
     .  !cdir nodep                                                             
     .  !cdir on_adb(abscoefh2ovap,pressscaleindh2ovap,refpressh2ovap)          
     .        do t157 = 0, 255                                                  
   489      PressScaleIndH2OVap    = -999.9_DP
   490      RefPressH2OVap         = -999.9_DP
   491  
   492      AbsCoefH2OVap      (1:nbmax) = (/ 0.0d0  /)
     .           abscoefh2ovap(1) = %IG1(1)                                     
     .        pressscaleindh2ovap(1) = %IG2(1)                                  
     .        refpressh2ovap(1) = %IG3(1)                                       
   493      PressScaleIndH2OVap(1:nbmax) = (/ 0.0d0  /)
   494      RefPressH2OVap     (1:nbmax) = (/ 1.0d5  /)
   495  
   496      DiffFact        = 1.66_DP
   497  
   498  
   499      ! NAMELIST の読み込み
   500      ! NAMELIST is input
   501      !
   502      if ( trim(namelist_filename) /= '' ) then
   503        call FileOpen( unit_nml, &          ! (out)
   504          & namelist_filename, mode = 'r' ) ! (in)
   505  
   506        rewind( unit_nml )
   507        read( unit_nml,                          & ! (in)
   508          & nml = rad_simple_SW_V2_0_nml,        & ! (out)
   509          & iostat = iostat_nml )                  ! (out)
   510        close( unit_nml )
   511  
   512        call NmlutilMsg( iostat_nml, module_name ) ! (in)
   513      end if
   514  
   515  
   516      a_AbsCoefH2OVap       = AbsCoefH2OVap
     .  !cdir nodep                                                             
     .  !cdir on_adb(abscoefh2ovap,pressscaleindh2ovap,refpressh2ovap)          
     .        do t170 = 0, 255                                                  
   517      a_PressScaleIndH2OVap = PressScaleIndH2OVap
   518      a_RefPressH2OVap      = RefPressH2OVap
   519  
   520  
   521      ! Initialization of modules used in this module
   522      !
   523  
   524      ! 太陽放射フラックスの設定
   525      ! Set solar constant
   526      !
   527      call SetSolarConstInit
   528  
   529      ! 短波入射 (太陽入射)
   530      ! Short wave (insolation) incoming
   531      !
   532      call RadShortIncomeInit
   533  
   534      !
   535      ! Solve radiative transfer equation in two stream approximation
   536      !
   537      call RadRTETwoStreamAppInit
   538  
   539      ! Chou and Lee (1996) による短波放射モデル
   540      ! Short wave radiation model described by Chou and Lee (1996)
   541      !
   542      call RadCL1996Init
   543  
   544  
   545      ! 印字 ; Print
   546      !
   547      call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   548      call MessageNotify( 'M', module_name, 'FlagRayleighScattering = %b', l = (/ FlagRayleighScattering /) )
   549      call MessageNotify( 'M', module_name, 'RayleighScatCoefRatio  = %f', d = (/ RayleighScatCoefRatio /) )
   550  
   551      do n = 1, nbmax
   552  !!$      call MessageNotify( 'M', module_name, '  %d : %f %f %f %f %f %f %f %f',       &
   553        call MessageNotify( 'M', module_name, '  %d : %f %f %f %f %f',                &
   554          & i = (/ n /),                                                              &
   555          & d = (/ a_WNBnds(n-1)*1.0e-2, a_WNBnds(n)*1.0e-2,                          &
   556  !!$        &        a_AbsCoefDryCom(n), a_PressScaleIndDryCom(n), a_RefPressDryCom(n), &
   557          &        a_AbsCoefH2OVap(n), a_PressScaleIndH2OVap(n), a_RefPressH2OVap(n) /) )
   558      end do
   559  
   560      call MessageNotify( 'M', module_name, 'DiffFact        = %f', d = (/ DiffFact /) )
   561      !
   562      call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   563  
   564  
   565      rad_simple_SW_V2_0_inited = .true.
   566  
   567    end subroutine RadSimpleSWV20Init
   568  
   569    !--------------------------------------------------------------------------------------
   570  
   571  end module rad_simple_SW_V2_0
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:39:00 2016
FILE NAME: rad_simple_SW_V2_0.f90
PROGRAM NAME: rad_simple_sw_v2_0
FORMAT LIST

  LINE    LOOP      FORTRAN STATEMENT

     1:             != 簡単短波放射モデル Ver. 2.0
     2:             !
     3:             != simple short wave radiation model Ver. 2.0
     4:             !
     5:             ! Authors::   Yoshiyuki O. Takahashi
     6:             ! Version::   $Id: rad_Earth_SW_V2_6.f90,v 1.1 2015/01/29 12:16:19 yot Exp $
     7:             ! Tag Name::  $Name:  $
     8:             ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9:             ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10:             !
    11:             module rad_simple_SW_V2_0
    12:             
    13:               !
    14:               != 簡単短波放射モデル Ver. 2.0
    15:               !
    16:               != simple short wave radiation model Ver. 2.0
    17:               !
    18:               ! <b>Note that Japanese and English are described in parallel.</b>
    19:               !
    20:               ! 地球大気向け短波放射モデル.
    21:               !
    22:               ! This is a simple short wave radiation model. 
    23:               !
    24:               ! This module is created by simplifying rad_Earth_SW_V2_6.f90. 
    25:               !
    26:               !== References
    27:               !
    28:               !
    29:               !== Procedures List
    30:               !
    31:               ! RadSimpleSWV20Flux  :: 放射フラックスの計算
    32:               ! ------------        :: ------------
    33:               ! RadSimpleSWV20Flux  :: Calculate radiation flux
    34:               !
    35:               !== NAMELIST
    36:               !
    37:               ! NAMELIST#rad_simple_SW_V2_0_nml
    38:               !
    39:             
    40:               ! USE statements
    41:               !
    42:             
    43:               !
    44:               ! Kind type parameter
    45:               !
    46:               use dc_types, only: DP, &      ! Double precision.
    47:                 &                 STRING, &  ! Strings.
    48:                 &                 TOKEN      ! Keywords.
    49:             
    50:               ! メッセージ出力
    51:               ! Message output
    52:               !
    53:               use dc_message, only: MessageNotify
    54:             
    55:             
    56:               ! 格子点設定
    57:               ! Grid points settings
    58:               !
    59:               use gridset, only: imax, & ! 経度格子点数.
    60:                                          ! Number of grid points in longitude
    61:                 &                jmax, & ! 緯度格子点数.
    62:                                          ! Number of grid points in latitude
    63:                 &                kmax    ! 鉛直層数.
    64:                                          ! Number of vertical level
    65:             
    66:               ! NAMELIST ファイル入力に関するユーティリティ
    67:               ! Utilities for NAMELIST file input
    68:               !
    69:               use namelist_util, only: MaxNmlArySize
    70:                                          ! NAMELIST から読み込む配列の最大サイズ.
    71:                                          ! Maximum size of arrays loaded from NAMELIST
    72:             
    73:               ! 時刻管理
    74:               ! Time control
    75:               !
    76:               use timeset, only: &
    77:                 & TimesetClockStart, TimesetClockStop
    78:             
    79:             
    80:               implicit none
    81:             
    82:               private
    83:             
    84:               logical , save      :: FlagRayleighScattering
    85:             
    86:               real(DP), save      :: RayleighScatCoefRatio
    87:                                          ! Ratio of Rayleight scattering coefficient 
    88:                                          ! to that of Earth's atmosphere
    89:             
    90:               integer , save:: nbmax
    91:                                          ! 長波バンド数.
    92:                                          ! Number of long wave band
    93:               real(DP), save:: a_WNBnds(0:MaxNmlArySize)
    94:                                          !
    95:                                          ! Wavenumber bounds for bands
    96:               real(DP), save:: a_AbsCoefH2OVap(1:MaxNmlArySize)
    97:                                          ! $ k_R $ . 水の吸収係数
    98:                                          ! Absorption coefficient of water vapor
    99:               real(DP), save:: a_PressScaleIndH2OVap(1:MaxNmlArySize)
   100:                                          !
   101:                                          ! Pressure scaling index for water vapor
   102:               real(DP), save:: a_RefPressH2OVap(1:MaxNmlArySize)
   103:                                          !
   104:                                          ! Reference pressure for water vapor
   105:               real(DP), save:: DiffFact
   106:                                          !
   107:                                          ! Diffusivity factor
   108:             
   109:               ! 公開変数
   110:               ! Public variables
   111:               !
   112:               logical, save :: rad_simple_SW_V2_0_inited = .false.
   113:                                           ! 初期設定フラグ.
   114:                                           ! Initialization flag
   115:             
   116:               public :: RadSimpleSWV20Flux
   117:               public :: RadSimpleSWV20Init
   118:             
   119:               character(*), parameter:: module_name = 'rad_simple_SW_V2_0'
   120:                                           ! モジュールの名称.
   121:                                           ! Module name
   122:               character(*), parameter:: version = &
   123:                 & '$Name:  $' // &
   124:                 & '$Id: rad_Earth_SW_V2_6.f90,v 1.1 2015/01/29 12:16:19 yot Exp $'
   125:                                           ! モジュールのバージョン
   126:                                           ! Module version
   127:             
   128:               !--------------------------------------------------------------------------------------
   129:             
   130:             contains
   131:             
   132:               !--------------------------------------------------------------------------------------
   133:             
   134:               subroutine RadSimpleSWV20Flux(                               &
   135:                 & xy_SurfAlbedo,                                           &
   136:                 & xyz_Press,                                               &
   137:                 & xyz_DelAtmMass, xyz_QH2OVap,                             &
   138:                 & xyr_RadSUwFlux, xyr_RadSDwFlux                           &
   139:                 & )
   140:             
   141:                 ! USE statements
   142:                 !
   143:             
   144:                 ! 太陽放射フラックスの設定
   145:                 ! Set solar constant
   146:                 !
   147:                 use set_solarconst, only : SetSolarConst
   148:             
   149:                 ! 短波入射 (太陽入射)
   150:                 ! Short wave (insolation) incoming
   151:                 !
   152:                 use rad_short_income, only : RadShortIncome
   153:             
   154:                 !
   155:                 ! Solve radiative transfer equation in two stream approximation
   156:                 !
   157:                 use rad_rte_two_stream_app, only: &
   158:                   & RadRTETwoStreamAppSW,         &
   159:                   & RadRTETwoStreamAppHomogAtm
   160:             
   161:                 ! Chou and Lee (1996) による短波放射モデル
   162:                 ! Short wave radiation model described by Chou and Lee (1996)
   163:                 !
   164:                 use rad_CL1996, only :       &
   165:                   & RadCL1996NumBands      , &
   166:                   & RadCL1996UVVISParams
   167:             
   168:             
   169:                 real(DP), intent(in ) :: xy_SurfAlbedo    (0:imax-1, 1:jmax )
   170:                 real(DP), intent(in ) :: xyz_Press        (0:imax-1, 1:jmax, 1:kmax)
   171:                                             ! $ P $ .     圧力. Pressure
   172:                 real(DP), intent(in ) :: xyz_DelAtmMass   (0:imax-1, 1:jmax, 1:kmax)
   173:                 real(DP), intent(in ) :: xyz_QH2OVap      (0:imax-1, 1:jmax, 1:kmax)
   174:                                             !
   175:                                             ! Specific humidity
   176:                 real(DP), intent(out) :: xyr_RadSUwFlux   (0:imax-1, 1:jmax, 0:kmax)
   177:                 real(DP), intent(out) :: xyr_RadSDwFlux   (0:imax-1, 1:jmax, 0:kmax)
   178:             
   179:             
   180:                 real(DP) :: SolarConst
   181:             
   182:                 real(DP) :: xy_InAngle    (0:imax-1, 1:jmax)
   183:                                           ! sec (入射角).
   184:                                           ! sec (angle of incidence)
   185:                 real(DP) :: DistFromStarScld
   186:                                            ! Distance between the central star and the planet
   187:                 real(DP) :: DiurnalMeanFactor
   188:             
   189:             
   190:                 integer  :: nbands1
   191:                 integer  :: nbands2
   192:             
   193:                 real(DP) :: UVVISFracSolarFlux
   194:                 real(DP) :: UVVISO3AbsCoef
   195:                 real(DP) :: UVVISRayScatCoef
   196:             
   197:                 real(DP) :: SolarFluxTOA
   198:             
   199:             
   200:             
   201:             !!$    real(DP) :: xyz_SSA       (0:imax-1, 1:jmax, 1:kmax)
   202:             !!$    real(DP) :: xyz_AF        (0:imax-1, 1:jmax, 1:kmax)
   203:             
   204:             
   205:                 real(DP), parameter :: RayScatSinScatAlb = 1.0d0 - 1.0d-10
   206:                 real(DP), parameter :: RayScatAsymFact   = 0.0d0
   207:             
   208:                 real(DP)            :: xyz_RayScatDelOptDep( 0:imax-1, 1:jmax, 1:kmax )
   209:             
   210:                 real(DP)            :: xyz_DelOptDepH2OVap(0:imax-1, 1:jmax, 1:kmax)
   211:             
   212:                 real(DP)            :: xyz_DelTotOptDep( 0:imax-1, 1:jmax, 1:kmax )
   213:                 real(DP)            :: xyr_TotOptDep   ( 0:imax-1, 1:jmax, 0:kmax )
   214:                 real(DP)            :: xyr_RadFlux     ( 0:imax-1, 1:jmax, 0:kmax )
   215:                 real(DP)            :: xyr_RadUwFlux   ( 0:imax-1, 1:jmax, 0:kmax )
   216:                 real(DP)            :: xyr_RadDwFlux   ( 0:imax-1, 1:jmax, 0:kmax )
   217:             
   218:                 real(DP) :: TotUVVISFracSolarFlux
   219:             
   220:             
   221:             
   222:                 integer  :: i
   223:                 integer  :: j
   224:                 integer  :: k
   225:                 integer  :: l
   226:                 integer  :: n
   227:             
   228:             
   229:                 ! 初期化確認
   230:                 ! Initialization check
   231:                 !
   232:                 if ( .not. rad_simple_SW_V2_0_inited ) then
   233:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   234:                 end if
   235:             
   236:             
   237:                 ! 計算時間計測開始
   238:                 ! Start measurement of computation time
   239:                 !
   240:                 call TimesetClockStart( module_name )
   241:             
   242:             
   243:                 ! 太陽放射フラックスの設定
   244:                 ! Set solar constant
   245:                 !
   246:                 call SetSolarConst( &
   247:                   & SolarConst      & ! (out)
   248:                   & )
   249:             
   250:                 ! 短波入射の計算
   251:                 ! Calculate short wave (insolation) incoming radiation
   252:                 !
   253:                 call RadShortIncome(                       &
   254:                   & xy_InAngle        = xy_InAngle,        & ! (out) optional
   255:                   & DistFromStarScld  = DistFromStarScld,  & ! (out) optional
   256:                   & DiurnalMeanFactor = DiurnalMeanFactor  &
   257:                   & )
   258:             
   259:             
   260:                 call RadCL1996NumBands(   &
   261:                   & nbands1, nbands2      & ! (out)
   262:                   & )
   263:             
   264:             
   265:                 ! Initialization
   266:                 !
   267: **W---->A       xyr_RadSUwFlux = 0.0_DP
   268: **W---- A       xyr_RadSDwFlux = 0.0_DP
   269:             
   270:             
   271:                 ! * 14286 to 57143 cm-1 (0.175 to 0.70 micron): 
   272:                 !   * Rayleigh scattering, 
   273:                 !
   274: +------>        do l = 1, nbands1
   275: |           
   276: |                 ! UV and Visible optical properties and solar flux
   277: |                 !
   278: |                 call RadCL1996UVVISParams(                                &
   279: |                   & l,                                                    & ! (in )
   280: |                   & UVVISFracSolarFlux, UVVISO3AbsCoef, UVVISRayScatCoef  & ! (out)
   281: |                   & )
   282: |           
   283: |                 ! Rayleigh scattering coefficient is multiplied by a ratio
   284: |                 UVVISRayScatCoef = UVVISRayScatCoef * RayleighScatCoefRatio
   285: |           
   286: |                 SolarFluxTOA = UVVISFracSolarFlux * SolarConst / DistFromStarScld**2 * DiurnalMeanFactor
   287: |           
   288: |           
   289: |                 ! Rayleigh scattering
   290: |                 !
   291: |                 if ( FlagRayleighScattering ) then
   292: |++V=== A           xyz_RayScatDelOptDep = UVVISRayScatCoef * xyz_DelAtmMass
   293: |                 else
   294: |W**===             xyz_RayScatDelOptDep = 0.0d0
   295: |                 end if
   296: |           
   297: |           
   298: |                 ! Total optical parameter
   299: |                 !
   300: |W**===           xyz_DelTotOptDep =            &
   301: |                   & + xyz_RayScatDelOptDep
   302: |                 !
   303: |W*==== A         xyr_TotOptDep(:,:,kmax) = 0.0d0
   304: |+----->          do k = kmax-1, 0, -1
   305: ||W*=== A           xyr_TotOptDep(:,:,k) = xyr_TotOptDep(:,:,k+1) + xyz_DelTotOptDep(:,:,k+1)
   306: |+-----           end do
   307: |                 !
   308: |           !!$      xyz_SSA = RayScatSinScatAlb
   309: |           !!$      do k = 1, kmax
   310: |           !!$        do j = 1, jmax
   311: |           !!$          do i = 0, imax-1
   312: |           !!$            if ( xyz_SSA(i,j,k) >= 1.0d0 ) then
   313: |           !!$              xyz_SSA(i,j,k) = 1.0d0 - 1.0d-10
   314: |           !!$            end if
   315: |           !!$          end do
   316: |           !!$        end do
   317: |           !!$      end do
   318: |           !!$      xyz_AF  = RayScatAsymFact
   319: |           !!$
   320: |           !!$      call RadRTETwoStreamAppSW(        &
   321: |           !!$        & xyz_SSA, xyz_AF,              & ! (in)
   322: |           !!$        & xyr_TotOptDep,                & ! (in)
   323: |           !!$        & xy_SurfAlbedo,                & ! (in)
   324: |           !!$        & SolarFluxTOA, xy_InAngle,     & ! (in)
   325: |           !!$        & xyr_RadUwFlux, xyr_RadDwFlux  & ! (out)
   326: |           !!$        & )
   327: |           
   328: |                 call RadRTETwoStreamAppHomogAtm(                         &
   329: |                   & xy_SurfAlbedo, SolarFluxTOA, xy_InAngle,             & ! (in )
   330: |                   & RayScatSinScatAlb, RayScatAsymFact, xyr_TotOptDep,   & ! (in )
   331: |                   & xyr_RadUwFlux, xyr_RadDwFlux                         & ! (out)
   332: |                   & )
   333: |           
   334: |           
   335: |**W--->A         xyr_RadSUwFlux = xyr_RadSUwFlux + xyr_RadUwFlux
   336: |**W--- A         xyr_RadSDwFlux = xyr_RadSDwFlux + xyr_RadDwFlux
   337: |           
   338: +------         end do
   339:             
   340:             
   341:                 ! * 1000 to 14286 cm-1 (0.70-10 micron): 
   342:                 !
   343:             
   344:                 SolarFluxTOA = SolarConst / DistFromStarScld**2 * DiurnalMeanFactor
   345:             
   346:                 TotUVVISFracSolarFlux = 0.0_DP
   347: +------>        do l = 1, nbands1
   348: |           
   349: |                 ! UV and Visible optical properties and solar flux
   350: |                 !
   351: |                 call RadCL1996UVVISParams(                                &
   352: |                   & l,                                                    & ! (in )
   353: |                   & UVVISFracSolarFlux, UVVISO3AbsCoef, UVVISRayScatCoef  & ! (out)
   354: |                   & )
   355: |           
   356: |                 TotUVVISFracSolarFlux = TotUVVISFracSolarFlux + UVVISFracSolarFlux
   357: +------         end do
   358:                 if ( TotUVVISFracSolarFlux > 1.0_DP ) then
   359:                   call MessageNotify( 'E', module_name, &
   360:                     & 'TotUVVISFracSolarFlux, %f, is greater than 1.', &
   361:                     & d = (/TotUVVISFracSolarFlux/) )
   362:                 end if
   363:             
   364:                 SolarFluxTOA = SolarFluxTOA * ( 1.0_DP - TotUVVISFracSolarFlux )
   365:             
   366:             
   367:                 n = 1
   368: W**==== A       xyz_DelOptDepH2OVap = a_AbsCoefH2OVap(n)                             &
   369:                   & * ( xyz_Press / a_RefPressH2OVap(n) )**a_PressScaleIndH2OVap(n)  &
   370:                   & * xyz_DelAtmMass * xyz_QH2OVap
   371:                 !
   372: W**==== A       xyr_TotOptDep = 0.0_DP
   373: +------>        do k = kmax, 1, -1
   374: |W*==== A         xyr_TotOptDep(:,:,k-1) = xyr_TotOptDep(:,:,k) + xyz_DelOptDepH2OVap(:,:,k)
   375: +------         end do
   376:             
   377:             
   378:             !!$    xyz_SSA = 1.0_DP - 1.0e-100_DP
   379:             !!$    xyz_AF  = 0.0_DP
   380:             !!$
   381:             !!$    call RadRTETwoStreamAppSW(        &
   382:             !!$      & xyz_SSA, xyz_AF,              & ! (in)
   383:             !!$      & xyr_TotOptDep,                & ! (in)
   384:             !!$      & xy_SurfAlbedo,                & ! (in)
   385:             !!$      & SolarFluxTOA, xy_InAngle,     & ! (in)
   386:             !!$      & xyr_RadUwFlux, xyr_RadDwFlux  & ! (out)
   387:             !!$      & )
   388:             
   389:                 call RadRTETwoStreamAppHomogAtm(                &
   390:                   & xy_SurfAlbedo, SolarFluxTOA, xy_InAngle,    & ! (in )
   391:                   & 1.0_DP - 1.0e-10_DP, 0.0_DP, xyr_TotOptDep, & ! (in )
   392:                   & xyr_RadUwFlux, xyr_RadDwFlux                & ! (out)
   393:                   & )
   394:             
   395: **W---->A       xyr_RadSUwFlux = xyr_RadSUwFlux + xyr_RadUwFlux
   396: **W---- A       xyr_RadSDwFlux = xyr_RadSDwFlux + xyr_RadDwFlux
   397:             
   398:             
   399:                 ! 計算時間計測一時停止
   400:                 ! Pause measurement of computation time
   401:                 !
   402:                 call TimesetClockStop( module_name )
   403:             
   404:             
   405:               end subroutine RadSimpleSWV20Flux
   406:             
   407:               !--------------------------------------------------------------------------------------
   408:             
   409:               subroutine RadSimpleSWV20Init
   410:             
   411:                 ! ファイル入出力補助
   412:                 ! File I/O support
   413:                 !
   414:                 use dc_iounit, only: FileOpen
   415:             
   416:                 ! NAMELIST ファイル入力に関するユーティリティ
   417:                 ! Utilities for NAMELIST file input
   418:                 !
   419:                 use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid
   420:             
   421:                 ! 太陽放射フラックスの設定
   422:                 ! Set solar constant
   423:                 !
   424:                 use set_solarconst, only : SetSolarConstInit
   425:             
   426:                 ! 短波入射 (太陽入射)
   427:                 ! Short wave (insolation) incoming
   428:                 !
   429:                 use rad_short_income, only : RadShortIncomeInit
   430:             
   431:                 !
   432:                 ! Solve radiative transfer equation in two stream approximation
   433:                 !
   434:                 use rad_rte_two_stream_app, only: RadRTETwoStreamAppInit
   435:             
   436:                 ! Chou and Lee (1996) による短波放射モデル
   437:                 ! Short wave radiation model described by Chou and Lee (1996)
   438:                 !
   439:                 use rad_CL1996, only : RadCL1996Init
   440:             
   441:             
   442:                 ! 宣言文 ; Declaration statements
   443:                 !
   444:             
   445:                 real(DP) :: WNBnds             (0:MaxNmlArySize)
   446:             
   447:                 real(DP) :: AbsCoefH2OVap      (1:MaxNmlArySize)
   448:                 real(DP) :: PressScaleIndH2OVap(1:MaxNmlArySize)
   449:                 real(DP) :: RefPressH2OVap     (1:MaxNmlArySize)
   450:             
   451:             
   452:                 integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号.
   453:                                           ! Unit number for NAMELIST file open
   454:                 integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT.
   455:                                           ! IOSTAT of NAMELIST read
   456:             
   457:                 integer:: n
   458:             
   459:                 ! NAMELIST 変数群
   460:                 ! NAMELIST group name
   461:                 !
   462:                 namelist /rad_simple_SW_V2_0_nml/ &
   463:                   & FlagRayleighScattering,       &
   464:                   & RayleighScatCoefRatio,        &
   465:             !!$      & nbmax, &
   466:                   & AbsCoefH2OVap, PressScaleIndH2OVap, RefPressH2OVap, &
   467:                   & DiffFact
   468:                       !
   469:                       ! デフォルト値については初期化手続 "rad_simple_SW_V2_0#RadSimpleSWV20Init"
   470:                       ! のソースコードを参照のこと.
   471:                       !
   472:                       ! Refer to source codes in the initialization procedure
   473:                       ! "rad_simple_SW_V2_6#RadSimpleSWEV20Init" for the default values.
   474:                       !
   475:             
   476:                 if ( rad_simple_SW_V2_0_inited ) return
   477:             
   478:             
   479:                 ! デフォルト値の設定
   480:                 ! Default values settings
   481:                 !
   482:                 FlagRayleighScattering = .true.
   483:                 RayleighScatCoefRatio  = 1.0_DP
   484:             
   485:                 nbmax = 1
   486: *======         WNBnds                 = -999.9_DP
   487:             
   488: V------>A       AbsCoefH2OVap          = -999.9_DP
   489: |       A       PressScaleIndH2OVap    = -999.9_DP
   490: V------ A       RefPressH2OVap         = -999.9_DP
   491:             
   492: *------>        AbsCoefH2OVap      (1:nbmax) = (/ 0.0d0  /)
   493: |               PressScaleIndH2OVap(1:nbmax) = (/ 0.0d0  /)
   494: *------         RefPressH2OVap     (1:nbmax) = (/ 1.0d5  /)
   495:             
   496:                 DiffFact        = 1.66_DP
   497:             
   498:             
   499:                 ! NAMELIST の読み込み
   500:                 ! NAMELIST is input
   501:                 !
   502:                 if ( trim(namelist_filename) /= '' ) then
   503:                   call FileOpen( unit_nml, &          ! (out)
   504:                     & namelist_filename, mode = 'r' ) ! (in)
   505:             
   506:                   rewind( unit_nml )
   507:                   read( unit_nml,                          & ! (in)
   508:                     & nml = rad_simple_SW_V2_0_nml,        & ! (out)
   509:                     & iostat = iostat_nml )                  ! (out)
   510:                   close( unit_nml )
   511:             
   512:                   call NmlutilMsg( iostat_nml, module_name ) ! (in)
   513:                 end if
   514:             
   515:             
   516: V------>A       a_AbsCoefH2OVap       = AbsCoefH2OVap
   517: |       A       a_PressScaleIndH2OVap = PressScaleIndH2OVap
   518: V------ A       a_RefPressH2OVap      = RefPressH2OVap
   519:             
   520:             
   521:                 ! Initialization of modules used in this module
   522:                 !
   523:             
   524:                 ! 太陽放射フラックスの設定
   525:                 ! Set solar constant
   526:                 !
   527:                 call SetSolarConstInit
   528:             
   529:                 ! 短波入射 (太陽入射)
   530:                 ! Short wave (insolation) incoming
   531:                 !
   532:                 call RadShortIncomeInit
   533:             
   534:                 !
   535:                 ! Solve radiative transfer equation in two stream approximation
   536:                 !
   537:                 call RadRTETwoStreamAppInit
   538:             
   539:                 ! Chou and Lee (1996) による短波放射モデル
   540:                 ! Short wave radiation model described by Chou and Lee (1996)
   541:                 !
   542:                 call RadCL1996Init
   543:             
   544:             
   545:                 ! 印字 ; Print
   546:                 !
   547:                 call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   548:                 call MessageNotify( 'M', module_name, 'FlagRayleighScattering = %b', l = (/ FlagRayleighScattering /) )
   549:                 call MessageNotify( 'M', module_name, 'RayleighScatCoefRatio  = %f', d = (/ RayleighScatCoefRatio /) )
   550:             
   551: +------>        do n = 1, nbmax
   552: |           !!$      call MessageNotify( 'M', module_name, '  %d : %f %f %f %f %f %f %f %f',       &
   553: |                 call MessageNotify( 'M', module_name, '  %d : %f %f %f %f %f',                &
   554: |                   & i = (/ n /),                                                              &
   555: |                   & d = (/ a_WNBnds(n-1)*1.0e-2, a_WNBnds(n)*1.0e-2,                          &
   556: |           !!$        &        a_AbsCoefDryCom(n), a_PressScaleIndDryCom(n), a_RefPressDryCom(n), &
   557: |                   &        a_AbsCoefH2OVap(n), a_PressScaleIndH2OVap(n), a_RefPressH2OVap(n) /) )
   558: +------         end do
   559:             
   560:                 call MessageNotify( 'M', module_name, 'DiffFact        = %f', d = (/ DiffFact /) )
   561:                 !
   562:                 call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   563:             
   564:             
   565:                 rad_simple_SW_V2_0_inited = .true.
   566:             
   567:               end subroutine RadSimpleSWV20Init
   568:             
   569:               !--------------------------------------------------------------------------------------
   570:             
   571:             end module rad_simple_SW_V2_0
