Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:45 2016
FILE NAME: rad_utils.f90
PROGRAM NAME: rad_utils
DIAGNOSTIC LIST

  LINE  LEVEL( NO.): DIAGNOSTIC MESSAGE

   198  opt  (1593): Loop nest collapsed into one loop.
   198  vec  (   1): Vectorized loop.
   198  vec  (  29): ADB is used for array.: xyz_dtempdtrads
   198  vec  (  29): ADB is used for array.: xyr_radsflux
   198  vec  (  29): ADB is used for array.: xyz_dtempdtradl
   198  vec  (  29): ADB is used for array.: xyr_press
   198  vec  (  29): ADB is used for array.: xyr_radlflux
   199  opt  (  11): Fused array assignments. :line 199 - 204
   299  vec  (   3): Unvectorized loop.
   299  vec  (  13): Overhead of loop division is too large.
   300  opt  (  11): Fused array assignments. :line 300 - 305
   300  opt  (1593): Loop nest collapsed into one loop.
   300  vec  (   4): Vectorized array expression.
   300  vec  (  29): ADB is used for array.: xyz_dtempdtrads
   300  vec  (  29): ADB is used for array.: xyr_radsflux
   300  vec  (  29): ADB is used for array.: xyz_dtempdtradl
   300  vec  (  29): ADB is used for array.: xyz_dens
   300  vec  (  29): ADB is used for array.: xyr_radlflux
   382  opt  (  11): Fused array assignments. :line 382 - 383
   382  opt  (1592): Outer loop unrolled inside inner loop.
   382  vec  (   4): Vectorized array expression.
   382  vec  (  29): ADB is used for array.: xyr_radsflux
   382  vec  (  29): ADB is used for array.: xr_radsflux
   382  vec  (  29): ADB is used for array.: xyr_radlflux
   382  vec  (  29): ADB is used for array.: xr_radlflux
   382  vec  (   4): Vectorized array expression.
   382  vec  (  29): ADB is used for array.: xyr_radsflux
   382  vec  (  29): ADB is used for array.: xr_radsflux
   382  vec  (  29): ADB is used for array.: xyr_radlflux
   382  vec  (  29): ADB is used for array.: xr_radlflux
   384  opt  (1592): Outer loop unrolled inside inner loop.
   384  vec  (   4): Vectorized array expression.
   384  vec  (  29): ADB is used for array.: xyz_dens
   384  vec  (  29): ADB is used for array.: xz_dens
   384  vec  (   4): Vectorized array expression.
   384  vec  (  29): ADB is used for array.: xyz_dens
   384  vec  (  29): ADB is used for array.: xz_dens
   391  opt  (  11): Fused array assignments. :line 391 - 392
   391  opt  (1592): Outer loop unrolled inside inner loop.
   391  vec  (   4): Vectorized array expression.
   391  vec  (  29): ADB is used for array.: xz_dtempdtrads
   391  vec  (  29): ADB is used for array.: xyz_dtempdtrads
   391  vec  (  29): ADB is used for array.: xz_dtempdtradl
   391  vec  (  29): ADB is used for array.: xyz_dtempdtradl
   391  vec  (   4): Vectorized array expression.
   391  vec  (  29): ADB is used for array.: xz_dtempdtrads
   391  vec  (  29): ADB is used for array.: xyz_dtempdtrads
   391  vec  (  29): ADB is used for array.: xz_dtempdtradl
   391  vec  (  29): ADB is used for array.: xyz_dtempdtradl
   503  opt  (  11): Fused array assignments. :line 503 - 504
   503  opt  (1592): Outer loop unrolled inside inner loop.
   503  vec  (   4): Vectorized array expression.
   503  vec  (  29): ADB is used for array.: xyr_radlflux
   503  vec  (  29): ADB is used for array.: xyr_radldwflux
   503  vec  (  29): ADB is used for array.: xyr_radluwflux
   503  vec  (  29): ADB is used for array.: xyr_radsflux
   503  vec  (  29): ADB is used for array.: xyr_radsdwflux
   503  vec  (  29): ADB is used for array.: xyr_radsuwflux
   503  vec  (   4): Vectorized array expression.
   503  vec  (  29): ADB is used for array.: xyr_radlflux
   503  vec  (  29): ADB is used for array.: xyr_radldwflux
   503  vec  (  29): ADB is used for array.: xyr_radluwflux
   503  vec  (  29): ADB is used for array.: xyr_radsflux
   503  vec  (  29): ADB is used for array.: xyr_radsdwflux
   503  vec  (  29): ADB is used for array.: xyr_radsuwflux
   505  opt  (1772): Loop nest fused with following nest(s).
   505  opt  (1593): Loop nest collapsed into one loop.
   505  vec  (   4): Vectorized array expression.
   505  vec  (  29): ADB is used for array.: xyra_delradldwflux
   505  vec  (  29): ADB is used for array.: xyra_delradluwflux
   524  vec  (   3): Unvectorized loop.
   524  vec  (  13): Overhead of loop division is too large.
   525  opt  (  11): Fused array assignments. :line 525 - 530
   525  opt  (1592): Outer loop unrolled inside inner loop.
   525  vec  (   4): Vectorized array expression.
   525  vec  (  29): ADB is used for array.: xyr_radldwfluxcor
   525  vec  (  29): ADB is used for array.: xyra_delradldwflux
   525  vec  (  29): ADB is used for array.: xyr_radldwflux
   525  vec  (  29): ADB is used for array.: xyr_radluwfluxcor
   525  vec  (  29): ADB is used for array.: xyz_dtempdt
   525  vec  (  29): ADB is used for array.: xyra_delradluwflux
   525  vec  (  29): ADB is used for array.: xy_dsurftempdt
   525  vec  (  29): ADB is used for array.: xyr_radluwflux
   525  vec  (   4): Vectorized array expression.
   525  vec  (  29): ADB is used for array.: xyr_radldwfluxcor
   525  vec  (  29): ADB is used for array.: xyra_delradldwflux
   525  vec  (  29): ADB is used for array.: xyr_radldwflux
   525  vec  (  29): ADB is used for array.: xyr_radluwfluxcor
   525  vec  (  29): ADB is used for array.: xyz_dtempdt
   525  vec  (  29): ADB is used for array.: xyra_delradluwflux
   525  vec  (  29): ADB is used for array.: xy_dsurftempdt
   525  vec  (  29): ADB is used for array.: xyr_radluwflux
   536  opt  (1593): Loop nest collapsed into one loop.
   536  vec  (   4): Vectorized array expression.
   536  vec  (  29): ADB is used for array.: xyr_radlfluxcor
   536  vec  (  29): ADB is used for array.: xyr_radldwfluxcor
   536  vec  (  29): ADB is used for array.: xyr_radluwfluxcor
   583  vec  (   3): Unvectorized loop.
   583  vec  (  13): Overhead of loop division is too large.
   584  opt  (  11): Fused array assignments. :line 584 - 589
   584  opt  (1592): Outer loop unrolled inside inner loop.
   584  vec  (   4): Vectorized array expression.
   584  vec  (  29): ADB is used for array.: xyr_radldwfluxcor
   584  vec  (  29): ADB is used for array.: xyra_delradldwflux
   584  vec  (  29): ADB is used for array.: xyr_radldwflux
   584  vec  (  29): ADB is used for array.: xyr_radluwfluxcor
   584  vec  (  29): ADB is used for array.: xyz_dtempdt
   584  vec  (  29): ADB is used for array.: xyra_delradluwflux
   584  vec  (  29): ADB is used for array.: xy_dsurftempdt
   584  vec  (  29): ADB is used for array.: xyr_radluwflux
   584  vec  (   4): Vectorized array expression.
   584  vec  (  29): ADB is used for array.: xyr_radldwfluxcor
   584  vec  (  29): ADB is used for array.: xyra_delradldwflux
   584  vec  (  29): ADB is used for array.: xyr_radldwflux
   584  vec  (  29): ADB is used for array.: xyr_radluwfluxcor
   584  vec  (  29): ADB is used for array.: xyz_dtempdt
   584  vec  (  29): ADB is used for array.: xyra_delradluwflux
   584  vec  (  29): ADB is used for array.: xy_dsurftempdt
   584  vec  (  29): ADB is used for array.: xyr_radluwflux
   595  opt  (1593): Loop nest collapsed into one loop.
   595  vec  (   4): Vectorized array expression.
   595  vec  (  29): ADB is used for array.: xyr_radlfluxcor
   595  vec  (  29): ADB is used for array.: xyr_radldwfluxcor
   595  vec  (  29): ADB is used for array.: xyr_radluwfluxcor
   824  warn (  82): Name "iostat_nml" is not used.
   824  warn (  82): Name "unit_nml" is not used.
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:45 2016
FILE NAME: rad_utils.f90
PROGRAM NAME: rad_utils
TRANSFORMATION LIST

  LINE                   FORTRAN STATEMENT

     1  != 放射関連ルーチン
     2  !
     3  != Routines for radiation calculation
     4  !
     5  ! Authors::   Yasuhiro MORIKAWA, Yukiko YAMADA, Satoshi NODA, Yoshiyuki O. TAKAHASHI
     6  ! Version::   $Id: rad_utils.f90,v 1.7 2012/10/08 12:48:45 yot Exp $
     7  ! Tag Name::  $Name:  $
     8  ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9  ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10  !
    11  
    12  module rad_utils
    13    !
    14    != 放射関連ルーチン
    15    !
    16    != Routines for radiation calculation
    17    !
    18    ! <b>Note that Japanese and English are described in parallel.</b>
    19    !
    20    !
    21    !
    22    !
    23    !
    24    !== Procedures List
    25    !
    26    ! RadDTempDt        :: 放射フラックスによる温度変化の計算
    27    ! RadFluxOutput     :: 放射フラックスの出力
    28    ! ------------            :: ------------
    29    ! RadDTempDt        :: Calculate temperature tendency with radiation flux
    30    ! RadFluxOutput     :: Output radiation fluxes
    31    !
    32    !== NAMELIST
    33    !
    34    ! NAMELIST#rad_utils_nml
    35    !
    36  
    37    ! モジュール引用 ; USE statements
    38    !
    39  
    40    ! 種別型パラメタ
    41    ! Kind type parameter
    42    !
    43    use dc_types, only: DP, &      ! 倍精度実数型. Double precision.
    44      &                 STRING, &  ! 文字列.       Strings.
    45      &                 TOKEN      ! キーワード.   Keywords.
    46  
    47    ! 物理・数学定数設定
    48    ! Physical and mathematical constants settings
    49    !
    50    use constants0, only: &
    51      & PI, &                 ! $ \pi $.
    52                              ! 円周率. Circular constant
    53      & StB
    54                              ! $ \sigma_{SB} $ .
    55                              ! ステファンボルツマン定数.
    56                              ! Stefan-Boltzmann constant
    57  
    58    ! 物理定数設定
    59    ! Physical constants settings
    60    !
    61    use constants, only: &
    62      & Grav, &
    63                              ! $ g $ [m s-2].
    64                              ! 重力加速度.
    65                              ! Gravitational acceleration
    66      & CpDry
    67                              ! $ C_p $ [J kg-1 K-1].
    68                              ! 乾燥大気の定圧比熱.
    69                              ! Specific heat of air at constant pressure
    70  
    71  
    72    ! 格子点設定
    73    ! Grid points settings
    74    !
    75    use gridset, only: imax, & ! 経度格子点数.
    76                               ! Number of grid points in longitude
    77      &                jmax, & ! 緯度格子点数.
    78                               ! Number of grid points in latitude
    79      &                kmax    ! 鉛直層数.
    80                               ! Number of vertical level
    81  
    82    ! メッセージ出力
    83    ! Message output
    84    !
    85    use dc_message, only: MessageNotify
    86  
    87    ! 宣言文 ; Declaration statements
    88    !
    89    implicit none
    90    private
    91  
    92    ! 公開手続き
    93    ! Public procedure
    94    !
    95    public :: RadDTempDt
    96    public :: RadDTempDtforNHM2DWrapper
    97    public :: RadFluxOutput
    98    public :: RadUtilsInit
    99  
   100  
   101    ! 公開変数
   102    ! Public variables
   103    !
   104    logical, save, public:: rad_utils_inited = .false.
   105                                ! 初期設定フラグ.
   106                                ! Initialization flag
   107  
   108  
   109    ! 非公開変数
   110    ! Private variables
   111    !
   112  
   113  
   114    character(*), parameter:: module_name = 'rad_utils'
   115                                ! モジュールの名称.
   116                                ! Module name
   117    character(*), parameter:: version = &
   118      & '$Name:  $' // &
   119      & '$Id: rad_utils.f90,v 1.7 2012/10/08 12:48:45 yot Exp $'
   120                                ! モジュールのバージョン
   121                                ! Module version
   122  
   123  contains
   124  
   125    !--------------------------------------------------------------------------------------
   126  
   127    subroutine RadDTempDt( &
   128      & xyr_RadLFlux, xyr_RadSFlux, xyr_Press, & ! (in)
   129      & xyz_DTempDtRadL, xyz_DTempDtRadS &       ! (out)
   130      & )
   131      !
   132      ! 放射による温度変化率を計算します.
   133      !
   134      ! Temperature tendency with radiation is calculated.
   135      !
   136  
   137      ! モジュール引用 ; USE statements
   138      !
   139  
   140      ! 時刻管理
   141      ! Time control
   142      !
   143      use timeset, only: &
   144        & TimeN, &              ! ステップ $ t $ の時刻. Time of step $ t $.
   145        & TimesetClockStart, TimesetClockStop
   146  
   147      ! ヒストリデータ出力
   148      ! History data output
   149      !
   150      use gtool_historyauto, only: HistoryAutoPut
   151  
   152  
   153      ! 宣言文 ; Declaration statements
   154      !
   155      implicit none
   156      real(DP), intent(in):: xyr_RadLFlux (0:imax-1, 1:jmax, 0:kmax)
   157                                ! 長波フラックス.
   158                                ! Longwave flux
   159      real(DP), intent(in):: xyr_RadSFlux (0:imax-1, 1:jmax, 0:kmax)
   160                                ! 短波 (日射) フラックス.
   161                                ! Shortwave (insolation) flux
   162      real(DP), intent(in):: xyr_Press    (0:imax-1, 1:jmax, 0:kmax)
   163                                ! $ \hat{p} $ . 気圧 (半整数レベル).
   164                                ! Air pressure (half level)
   165      real(DP), intent(out):: xyz_DTempDtRadL (0:imax-1, 1:jmax, 1:kmax)
   166                                ! 長波加熱率.
   167                                ! Temperature tendency with longwave
   168      real(DP), intent(out):: xyz_DTempDtRadS (0:imax-1, 1:jmax, 1:kmax)
   169                                ! 短波加熱率.
   170                                ! Temperature tendency with shortwave
   171  
   172      ! 作業変数
   173      ! Work variables
   174      !
   175      integer:: k               ! 鉛直方向に回る DO ループ用作業変数
   176                                ! Work variables for DO loop in vertical direction
   177  
   178      ! 実行文 ; Executable statement
   179      !
   180  
   181      ! 初期化確認
   182      ! Initialization check
   183      !
   184      if ( .not. rad_utils_inited ) then
   185        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   186      end if
   187  
   188  
   189      ! 計算時間計測開始
   190      ! Start measurement of computation time
   191      !
   192      call TimesetClockStart( module_name )
   193  
   194  
   195      ! 放射冷却率の演算
   196      ! Calculate radiation cooling rate
   197      !
   198      do k = 1, kmax
   199        xyz_DTempDtRadL(:,:,k) = &
   200          & (     xyr_RadLFlux(:,:,k-1) - xyr_RadLFlux(:,:,k) ) &
   201          &   / ( xyr_Press(:,:,k-1)    - xyr_Press(:,:,k) ) &
   202          &   / CpDry * Grav
   203  
   204        xyz_DTempDtRadS(:,:,k) = &
   205          & (     xyr_RadSFlux(:,:,k-1) - xyr_RadSFlux(:,:,k) ) &
   206          &   / ( xyr_Press(:,:,k-1)    - xyr_Press(:,:,k) ) &
   207          &   / CpDry * Grav
   208      end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do k = 1, kmax*jmax*imax                                          
     .           xyz_dtempdtradl(k-1,1,1) = (xyr_radlflux(k-1,1,0)-xyr_radlflux(
     .       1      k-1,1,1))/((xyr_press(k-1,1,0)-xyr_press(k-1,1,1))*cpdry)*  
     .       2      grav                                                        
     .           xyz_dtempdtrads(k-1,1,1) = (xyr_radsflux(k-1,1,0)-xyr_radsflux(
     .       1      k-1,1,1))/((xyr_press(k-1,1,0)-xyr_press(k-1,1,1))*cpdry)*  
     .       2      grav                                                        
     .        enddo                                                             
   209  
   210  
   211      ! ヒストリデータ出力
   212      ! History data output
   213      !
   214      call HistoryAutoPut( TimeN, 'DTempDtRadL' , xyz_DTempDtRadL )
   215      call HistoryAutoPut( TimeN, 'DTempDtRadS' , xyz_DTempDtRadS )
   216  
   217  
   218      ! 計算時間計測一時停止
   219      ! Pause measurement of computation time
   220      !
   221      call TimesetClockStop( module_name )
   222  
   223    end subroutine RadDTempDt
   224  
   225    !--------------------------------------------------------------------------------------
   226  
   227    subroutine RadDTempDtforNHM(                        &
   228      & xyr_RadLFlux, xyr_RadSFlux, r_Height, xyz_Dens, & ! (in)
   229      & xyz_DTempDtRadL, xyz_DTempDtRadS                & ! (out)
   230      & )
   231      !
   232      ! 非静力学系における放射による温度変化率を計算します.
   233      !
   234      ! Temperature tendency with radiation is calculated for non-hydrodynamic system.
   235      !
   236  
   237      ! モジュール引用 ; USE statements
   238      !
   239  
   240      ! 時刻管理
   241      ! Time control
   242      !
   243      use timeset, only: &
   244        & TimeN, &              ! ステップ $ t $ の時刻. Time of step $ t $.
   245        & TimesetClockStart, TimesetClockStop
   246  
   247      ! ヒストリデータ出力
   248      ! History data output
   249      !
   250      use gtool_historyauto, only: HistoryAutoPut
   251  
   252  
   253      ! 宣言文 ; Declaration statements
   254      !
   255      implicit none
   256      real(DP), intent(in):: xyr_RadLFlux (0:imax-1, 1:jmax, 0:kmax)
   257                                ! 長波フラックス.
   258                                ! Longwave flux
   259      real(DP), intent(in):: xyr_RadSFlux (0:imax-1, 1:jmax, 0:kmax)
   260                                ! 短波 (日射) フラックス.
   261                                ! Shortwave (insolation) flux
   262      real(DP), intent(in):: r_Height                       (0:kmax)
   263                                ! $ \hat{p} $ . 気圧 (半整数レベル).
   264                                ! Air pressure (half level)
   265      real(DP), intent(in):: xyz_Dens     (0:imax-1, 1:jmax, 1:kmax)
   266      real(DP), intent(out):: xyz_DTempDtRadL (0:imax-1, 1:jmax, 1:kmax)
   267                                ! 長波加熱率.
   268                                ! Temperature tendency with longwave
   269      real(DP), intent(out):: xyz_DTempDtRadS (0:imax-1, 1:jmax, 1:kmax)
   270                                ! 短波加熱率.
   271                                ! Temperature tendency with shortwave
   272  
   273      ! 作業変数
   274      ! Work variables
   275      !
   276      integer:: k               ! 鉛直方向に回る DO ループ用作業変数
   277                                ! Work variables for DO loop in vertical direction
   278  
   279      ! 実行文 ; Executable statement
   280      !
   281  
   282      ! 初期化確認
   283      ! Initialization check
   284      !
   285      if ( .not. rad_utils_inited ) then
   286        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   287      end if
   288  
   289  
   290      ! 計算時間計測開始
   291      ! Start measurement of computation time
   292      !
   293      call TimesetClockStart( module_name )
   294  
   295  
   296      ! 放射冷却率の演算
   297      ! Calculate radiation cooling rate
   298      !
   299      do k = 1, kmax
   300        xyz_DTempDtRadL(:,:,k) = &
     .        d1 = 1.D0/(r_height(k)-r_height(k-1))                             
     .        d2 = 1.D0/(r_height(k)-r_height(k-1))                             
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xyr_radlflux)                                              
     .        do t131 = 1, jmax*imax                                            
     .           xyz_dtempdtradl(t131-1,1,k) = -(xyr_radlflux(t131-1,1,k)-      
     .       1      xyr_radlflux(t131-1,1,k-1))*d1/(cpdry*xyz_dens(t131-1,1,k)) 
     .           xyz_dtempdtrads(t131-1,1,k) = -(xyr_radsflux(t131-1,1,k)-      
     .       1      xyr_radsflux(t131-1,1,k-1))*d2/(cpdry*xyz_dens(t131-1,1,k)) 
     .        enddo                                                             
   301          &   - ( xyr_RadLFlux(:,:,k) - xyr_RadLFlux(:,:,k-1) ) &
   302          &   / (   r_Height      (k) -   r_Height      (k-1) ) &
   303          &   / ( CpDry * xyz_Dens(:,:,k) )
   304  
   305        xyz_DTempDtRadS(:,:,k) = &
   306          &   - ( xyr_RadSFlux(:,:,k) - xyr_RadSFlux(:,:,k-1) ) &
   307          &   / (   r_Height      (k) -   r_Height      (k-1) ) &
   308          &   / ( CpDry * xyz_Dens(:,:,k) )
   309      end do
   310  
   311  
   312      ! ヒストリデータ出力
   313      ! History data output
   314      !
   315      call HistoryAutoPut( TimeN, 'DTempDtRadL' , xyz_DTempDtRadL )
   316      call HistoryAutoPut( TimeN, 'DTempDtRadS' , xyz_DTempDtRadS )
   317  
   318  
   319      ! 計算時間計測一時停止
   320      ! Pause measurement of computation time
   321      !
   322      call TimesetClockStop( module_name )
   323  
   324    end subroutine RadDTempDtforNHM
   325  
   326    !--------------------------------------------------------------------------------------
   327  
   328    subroutine RadDTempDtforNHM2DWrapper(             &
   329      & xr_RadLFlux, xr_RadSFlux, r_Height, xz_Dens,  & ! (in)
   330      & xz_DTempDtRadL, xz_DTempDtRadS                & ! (out)
   331      & )
   332      !
   333      ! 放射による温度変化率を計算します.
   334      !
   335      ! Temperature tendency with radiation is calculated.
   336      !
   337  
   338      ! モジュール引用 ; USE statements
   339      !
   340  
   341      ! 宣言文 ; Declaration statements
   342      !
   343      implicit none
   344      real(DP), intent(in):: xr_RadLFlux (0:imax-1, 0:kmax)
   345                                ! 長波フラックス.
   346                                ! Longwave flux
   347      real(DP), intent(in):: xr_RadSFlux (0:imax-1, 0:kmax)
   348                                ! 短波 (日射) フラックス.
   349                                ! Shortwave (insolation) flux
   350      real(DP), intent(in):: r_Height    (0:kmax)
   351                                ! $ \hat{p} $ . 気圧 (半整数レベル).
   352                                ! Air pressure (half level)
   353      real(DP), intent(in):: xz_Dens     (0:imax-1, 1:kmax)
   354      real(DP), intent(out):: xz_DTempDtRadL (0:imax-1, 1:kmax)
   355                                ! 長波加熱率.
   356                                ! Temperature tendency with longwave
   357      real(DP), intent(out):: xz_DTempDtRadS (0:imax-1, 1:kmax)
   358                                ! 短波加熱率.
   359                                ! Temperature tendency with shortwave
   360  
   361      ! 作業変数
   362      ! Work variables
   363      !
   364      real(DP) :: xyr_RadLFlux   (0:imax-1, 1:jmax, 0:kmax)
   365      real(DP) :: xyr_RadSFlux   (0:imax-1, 1:jmax, 0:kmax)
   366      real(DP) :: xyz_Dens       (0:imax-1, 1:jmax, 1:kmax)
   367      real(DP) :: xyz_DTempDtRadL(0:imax-1, 1:jmax, 1:kmax)
   368      real(DP) :: xyz_DTempDtRadS(0:imax-1, 1:jmax, 1:kmax)
   369  
   370  
   371      ! 実行文 ; Executable statement
   372      !
   373  
   374      ! 初期化確認
   375      ! Initialization check
   376      !
   377      if ( .not. rad_utils_inited ) then
   378        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   379      end if
   380  
   381  
   382      xyr_RadLFlux(:,1,:) = xr_RadLFlux(:,:)
     .        if (xyr_radlflux.DSC.U3 + 1 .gt. 0) then                          
     .           j1 = and(xyr_radlflux.DSC.U3 + 1,3)                            
     .  !cdir    nodep                                                          
     .           do t138 = 1, j1                                                
     .  !cdir       nodep                                                       
     .              do t140 = 1, xyr_radlflux.DSC.U1 + 1                        
     .                 xyr_radlflux(t140-1,1,t138-1)=xr_radlflux(t140-1,t138-1) 
     .                 xyr_radsflux(t140-1,1,t138-1)=xr_radsflux(t140-1,t138-1) 
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t138 = j1 + 1, xyr_radlflux.DSC.U3 + 1, 4                   
     .  !cdir       nodep                                                       
     .              do t140 = 1, xyr_radlflux.DSC.U1 + 1                        
     .                 xyr_radlflux(t140-1,1,t138-1)=xr_radlflux(t140-1,t138-1) 
     .                 xyr_radlflux(t140-1,1,t138) = xr_radlflux(t140-1,t138)   
     .                 xyr_radlflux(t140-1,1,t138+1)=xr_radlflux(t140-1,t138+1) 
     .                 xyr_radlflux(t140-1,1,t138+2)=xr_radlflux(t140-1,t138+2) 
     .                 xyr_radsflux(t140-1,1,t138-1)=xr_radsflux(t140-1,t138-1) 
     .                 xyr_radsflux(t140-1,1,t138) = xr_radsflux(t140-1,t138)   
     .                 xyr_radsflux(t140-1,1,t138+1)=xr_radsflux(t140-1,t138+1) 
     .                 xyr_radsflux(t140-1,1,t138+2)=xr_radsflux(t140-1,t138+2) 
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
   383      xyr_RadSFlux(:,1,:) = xr_RadSFlux(:,:)
   384      xyz_Dens    (:,1,:) = xz_Dens    (:,:)
     .        if (xyz_dens.DSC.U3 .gt. 0) then                                  
     .           j2 = and(xyz_dens.DSC.U3,3)                                    
     .  !cdir    nodep                                                          
     .           do t150 = 1, j2                                                
     .  !cdir       nodep                                                       
     .              do t152 = 1, xyz_dens.DSC.U1 + 1                            
     .                 xyz_dens(t152-1,1,t150) = xz_dens(t152-1,t150)           
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t150 = j2 + 1, xyz_dens.DSC.U3, 4                           
     .  !cdir       nodep                                                       
     .              do t152 = 1, xyz_dens.DSC.U1 + 1                            
     .                 xyz_dens(t152-1,1,t150) = xz_dens(t152-1,t150)           
     .                 xyz_dens(t152-1,1,t150+1) = xz_dens(t152-1,t150+1)       
     .                 xyz_dens(t152-1,1,t150+2) = xz_dens(t152-1,t150+2)       
     .                 xyz_dens(t152-1,1,t150+3) = xz_dens(t152-1,t150+3)       
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
   385  
   386      call RadDTempDtforNHM(                              &
   387        & xyr_RadLFlux, xyr_RadSFlux, r_Height, xyz_Dens, & ! (in)
   388        & xyz_DTempDtRadL, xyz_DTempDtRadS                & ! (out)
   389        & )
   390  
   391      xz_DTempDtRadL(:,:) = xyz_DTempDtRadL(:,1,:)
     .        if (kmax .gt. 0) then                                             
     .           j3 = and(kmax,3)                                               
     .  !cdir    nodep                                                          
     .           do t158 = 1, j3                                                
     .  !cdir       nodep                                                       
     .              do t160 = 1, imax                                           
     .                 xz_dtempdtradl(t160-1,t158) = xyz_dtempdtradl(t160-1,1,  
     .       1            t158)                                                 
     .                 xz_dtempdtrads(t160-1,t158) = xyz_dtempdtrads(t160-1,1,  
     .       1            t158)                                                 
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t158 = j3 + 1, kmax, 4                                      
     .  !cdir       nodep                                                       
     .              do t160 = 1, imax                                           
     .                 xz_dtempdtradl(t160-1,t158) = xyz_dtempdtradl(t160-1,1,  
     .       1            t158)                                                 
     .                 xz_dtempdtradl(t160-1,t158+1) = xyz_dtempdtradl(t160-1,1,
     .       1            t158+1)                                               
     .                 xz_dtempdtradl(t160-1,t158+2) = xyz_dtempdtradl(t160-1,1,
     .       1            t158+2)                                               
     .                 xz_dtempdtradl(t160-1,t158+3) = xyz_dtempdtradl(t160-1,1,
     .       1            t158+3)                                               
     .                 xz_dtempdtrads(t160-1,t158) = xyz_dtempdtrads(t160-1,1,  
     .       1            t158)                                                 
     .                 xz_dtempdtrads(t160-1,t158+1) = xyz_dtempdtrads(t160-1,1,
     .       1            t158+1)                                               
     .                 xz_dtempdtrads(t160-1,t158+2) = xyz_dtempdtrads(t160-1,1,
     .       1            t158+2)                                               
     .                 xz_dtempdtrads(t160-1,t158+3) = xyz_dtempdtrads(t160-1,1,
     .       1            t158+3)                                               
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
   392      xz_DTempDtRadS(:,:) = xyz_DTempDtRadS(:,1,:)
   393  
   394  
   395    end subroutine RadDTempDtforNHM2DWrapper
   396  
   397    !-------------------------------------------------------------------
   398  
   399    subroutine RadFluxOutput(                          &
   400      & xyr_RadSUwFlux, xyr_RadSDwFlux,                & ! (in)
   401      & xyr_RadLUwFlux, xyr_RadLDwFlux,                & ! (in)
   402      & xyra_DelRadLUwFlux, xyra_DelRadLDwFlux,        & ! (in)
   403      & xy_DSurfTempDt, xyz_DTempDt                    & ! (in)
   404      & )
   405      !
   406      ! 放射フラックス (xyr_RadSFlux, xyr_RadLFlux)
   407      ! について, その他の引数を用いて補正し, 出力を行う.
   408      !
   409      ! Radiation fluxes (xyr_RadSFlux, xyr_RadLFlux) are
   410      ! corrected by using other arguments, and the corrected values are output.
   411      !
   412  
   413      ! モジュール引用 ; USE statements
   414      !
   415  
   416      ! 時刻管理
   417      ! Time control
   418      !
   419      use timeset, only: &
   420        & DelTime, &            ! $ \Delta t $ [s]
   421        & TimeN, &              ! ステップ $ t $ の時刻. Time of step $ t $.
   422        & TimesetClockStart, TimesetClockStop
   423  
   424      ! ヒストリデータ出力
   425      ! History data output
   426      !
   427      use gtool_historyauto, only: HistoryAutoPut
   428  
   429      ! 宣言文 ; Declaration statements
   430      !
   431      implicit none
   432      real(DP), intent(in):: xyr_RadSUwFlux  (0:imax-1, 1:jmax, 0:kmax)
   433                                ! 短波 (日射) フラックス.
   434                                ! Upward shortwave (insolation) flux
   435      real(DP), intent(in):: xyr_RadSDwFlux  (0:imax-1, 1:jmax, 0:kmax)
   436                                ! 短波 (日射) フラックス.
   437                                ! Downward shortwave (insolation) flux
   438  
   439      real(DP), intent(in):: xyr_RadLUwFlux    (0:imax-1, 1:jmax, 0:kmax)
   440                                ! 長波フラックス.
   441                                ! Upward longwave flux
   442      real(DP), intent(in):: xyr_RadLDwFlux    (0:imax-1, 1:jmax, 0:kmax)
   443                                ! 長波フラックス.
   444                                ! Downward longwave flux
   445      real(DP), intent(in):: xyra_DelRadLUwFlux(0:imax-1, 1:jmax, 0:kmax, 0:1)
   446                                ! 長波地表温度変化.
   447                                !
   448      real(DP), intent(in):: xyra_DelRadLDwFlux(0:imax-1, 1:jmax, 0:kmax, 0:1)
   449                                ! 長波地表温度変化.
   450                                !
   451  
   452      real(DP), intent(in):: xy_DSurfTempDt  (0:imax-1, 1:jmax)
   453                                ! 地表面温度変化率.
   454                                ! Surface temperature tendency
   455      real(DP), intent(in):: xyz_DTempDt     (0:imax-1, 1:jmax, 1:kmax)
   456                                ! $ \DP{T}{t} $ . 温度変化 (K s-1)
   457                                ! Temperature tendency (K s-1)
   458  
   459      ! 出力のための作業変数
   460      ! Work variables for output
   461      !
   462      real(DP):: xyr_RadSFlux    (0:imax-1, 1:jmax, 0:kmax)
   463                                ! 短波 (日射) フラックス.
   464                                ! Shortwave (insolation) flux
   465      real(DP):: xyr_RadLFlux    (0:imax-1, 1:jmax, 0:kmax)
   466                                ! 長波フラックス.
   467                                ! Longwave flux
   468      real(DP):: xyra_DelRadLFlux(0:imax-1, 1:jmax, 0:kmax, 0:1)
   469                                ! 長波地表温度変化.
   470                                ! Surface temperature tendency with longwave
   471      real(DP):: xyr_RadLUwFluxCor(0:imax-1, 1:jmax, 0:kmax)
   472                                ! 補正された長波フラックス.
   473                                ! Corrected longwave flux
   474      real(DP):: xyr_RadLDwFluxCor(0:imax-1, 1:jmax, 0:kmax)
   475                                ! 補正された長波フラックス.
   476                                ! Corrected longwave flux
   477      real(DP):: xyr_RadLFluxCor  (0:imax-1, 1:jmax, 0:kmax)
   478                                ! 補正された長波フラックス.
   479                                ! Corrected longwave flux
   480  
   481      ! 作業変数
   482      ! Work variables
   483      !
   484      integer:: k               ! 鉛直方向に回る DO ループ用作業変数
   485                                ! Work variables for DO loop in vertical direction
   486      ! 実行文 ; Executable statement
   487      !
   488  
   489      ! 初期化確認
   490      ! Initialization check
   491      !
   492      if ( .not. rad_utils_inited ) then
   493        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   494      end if
   495  
   496  
   497      ! 計算時間計測開始
   498      ! Start measurement of computation time
   499      !
   500      call TimesetClockStart( module_name )
   501  
   502  
   503      xyr_RadSFlux     = xyr_RadSUwFlux     - xyr_RadSDwFlux
     .        if (xyr_radsuwflux.DSC.U2 .gt. 0) then                            
     .           j1 = and(xyr_radsuwflux.DSC.U2,3)                              
     .  !cdir    nodep                                                          
     .           do t461 = 1, j1                                                
     .  !cdir       nodep                                                       
     .              do t463 = 1, xyr_radsuwflux.DSC.U1 + 1                      
     .                 xyr_radsflux(t463-1,t461,t459) = xyr_radsuwflux(t463-1,  
     .       1            t461,t459) - xyr_radsdwflux(t463-1,t461,t459)         
     .                 xyr_radlflux(t463-1,t461,t459) = xyr_radluwflux(t463-1,  
     .       1            t461,t459) - xyr_radldwflux(t463-1,t461,t459)         
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t461 = j1 + 1, xyr_radsuwflux.DSC.U2, 4                     
     .  !cdir       nodep                                                       
     .              do t463 = 1, xyr_radsuwflux.DSC.U1 + 1                      
     .                 xyr_radsflux(t463-1,t461,t459) = xyr_radsuwflux(t463-1,  
     .       1            t461,t459) - xyr_radsdwflux(t463-1,t461,t459)         
     .                 xyr_radsflux(t463-1,t461+1,t459) = xyr_radsuwflux(t463-1,
     .       1            t461+1,t459) - xyr_radsdwflux(t463-1,t461+1,t459)     
     .                 xyr_radsflux(t463-1,t461+2,t459) = xyr_radsuwflux(t463-1,
     .       1            t461+2,t459) - xyr_radsdwflux(t463-1,t461+2,t459)     
     .                 xyr_radsflux(t463-1,t461+3,t459) = xyr_radsuwflux(t463-1,
     .       1            t461+3,t459) - xyr_radsdwflux(t463-1,t461+3,t459)     
     .                 xyr_radlflux(t463-1,t461,t459) = xyr_radluwflux(t463-1,  
     .       1            t461,t459) - xyr_radldwflux(t463-1,t461,t459)         
     .                 xyr_radlflux(t463-1,t461+1,t459) = xyr_radluwflux(t463-1,
     .       1            t461+1,t459) - xyr_radldwflux(t463-1,t461+1,t459)     
     .                 xyr_radlflux(t463-1,t461+2,t459) = xyr_radluwflux(t463-1,
     .       1            t461+2,t459) - xyr_radldwflux(t463-1,t461+2,t459)     
     .                 xyr_radlflux(t463-1,t461+3,t459) = xyr_radluwflux(t463-1,
     .       1            t461+3,t459) - xyr_radldwflux(t463-1,t461+3,t459)     
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
   504      xyr_RadLFlux     = xyr_RadLUwFlux     - xyr_RadLDwFlux
   505      xyra_DelRadLFlux = xyra_DelRadLUwFlux - xyra_DelRadLDwFlux
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t485 = 1, jmax*(kmax*imax + imax)                              
     .           xyra_delradlflux(t485-1,1,0,0) = xyra_delradluwflux(t485-1,1,0,
     .       1      0) - xyra_delradldwflux(t485-1,1,0,0)                       
     .        enddo                                                             
   506  
   507  
   508      ! 長波フラックスの補正 ( 地表フラックス分の補正 )
   509      ! Correct longwave flux ( amount of surface flux )
   510      !
   511      ! Lines commented out below will be deleted soon (yot, 2010/10/31).
   512  !!$    do k = 0, kmax
   513  !!$      xyr_RadLFluxCor (:,:,k) = &
   514  !!$        &     xyr_RadLFlux (:,:,k) &
   515  !!$        &   + xyra_DelRadLFlux(:,:,k,0) * xy_DSurfTempDt (:,:) * DelTime
   516  !!$    end do
   517  !!$    do k = 0, kmax
   518  !!$      xyr_RadLFluxCor(:,:,k) = &
   519  !!$        &   xyr_RadLFlux(:,:,k) &
   520  !!$        & + (   xy_DSurfTempDt     * xyra_DelRadLFlux(:,:,k,0)   &
   521  !!$        &     + xyz_DTempDt(:,:,1) * xyra_DelRadLFlux(:,:,k,1) ) &
   522  !!$        &   * DelTime
   523  !!$    end do
   524      do k = 0, kmax
   525        xyr_RadLUwFluxCor(:,:,k) =                                   &
     .        if (xyr_radluwflux.DSC.U2 .gt. 0) then                            
     .           j2 = and(xyr_radluwflux.DSC.U2,3)                              
     .  !cdir    nodep                                                          
     .           do t503 = 1, j2                                                
     .  !cdir       nodep                                                       
     .  !cdir       on_adb(xy_dsurftempdt,xyz_dtempdt)                          
     .              do t505 = 1, xyr_radluwflux.DSC.U1 + 1                      
     .                 xyr_radluwfluxcor(t505-1,t503,k) = xyr_radluwflux(t505-1,
     .       1            t503,k) + (xy_dsurftempdt(t505-1,t503)*               
     .       2            xyra_delradluwflux(t505-1,t503,k,0)+xyz_dtempdt(t505-1
     .       3            ,t503,1)*xyra_delradluwflux(t505-1,t503,k,1))*deltime 
     .                 xyr_radldwfluxcor(t505-1,t503,k) = xyr_radldwflux(t505-1,
     .       1            t503,k) + (xy_dsurftempdt(t505-1,t503)*               
     .       2            xyra_delradldwflux(t505-1,t503,k,0)+xyz_dtempdt(t505-1
     .       3            ,t503,1)*xyra_delradldwflux(t505-1,t503,k,1))*deltime 
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t503 = j2 + 1, xyr_radluwflux.DSC.U2, 4                     
     .  !cdir       nodep                                                       
     .  !cdir       on_adb(xy_dsurftempdt,xyz_dtempdt)                          
     .              do t505 = 1, xyr_radluwflux.DSC.U1 + 1                      
     .                 xyr_radluwfluxcor(t505-1,t503,k) = xyr_radluwflux(t505-1,
     .       1            t503,k) + (xy_dsurftempdt(t505-1,t503)*               
     .       2            xyra_delradluwflux(t505-1,t503,k,0)+xyz_dtempdt(t505-1
     .       3            ,t503,1)*xyra_delradluwflux(t505-1,t503,k,1))*deltime 
     .                 xyr_radluwfluxcor(t505-1,t503+1,k) = xyr_radluwflux(t505-
     .       1            1,t503+1,k) + (xy_dsurftempdt(t505-1,t503+1)*         
     .       2            xyra_delradluwflux(t505-1,t503+1,k,0)+xyz_dtempdt(t505
     .       3            -1,t503+1,1)*xyra_delradluwflux(t505-1,t503+1,k,1))*  
     .       4            deltime                                               
     .                 xyr_radluwfluxcor(t505-1,t503+2,k) = xyr_radluwflux(t505-
     .       1            1,t503+2,k) + (xy_dsurftempdt(t505-1,t503+2)*         
     .       2            xyra_delradluwflux(t505-1,t503+2,k,0)+xyz_dtempdt(t505
     .       3            -1,t503+2,1)*xyra_delradluwflux(t505-1,t503+2,k,1))*  
     .       4            deltime                                               
     .                 xyr_radluwfluxcor(t505-1,t503+3,k) = xyr_radluwflux(t505-
     .       1            1,t503+3,k) + (xy_dsurftempdt(t505-1,t503+3)*         
     .       2            xyra_delradluwflux(t505-1,t503+3,k,0)+xyz_dtempdt(t505
     .       3            -1,t503+3,1)*xyra_delradluwflux(t505-1,t503+3,k,1))*  
     .       4            deltime                                               
     .                 xyr_radldwfluxcor(t505-1,t503,k) = xyr_radldwflux(t505-1,
     .       1            t503,k) + (xy_dsurftempdt(t505-1,t503)*               
     .       2            xyra_delradldwflux(t505-1,t503,k,0)+xyz_dtempdt(t505-1
     .       3            ,t503,1)*xyra_delradldwflux(t505-1,t503,k,1))*deltime 
     .                 xyr_radldwfluxcor(t505-1,t503+1,k) = xyr_radldwflux(t505-
     .       1            1,t503+1,k) + (xy_dsurftempdt(t505-1,t503+1)*         
     .       2            xyra_delradldwflux(t505-1,t503+1,k,0)+xyz_dtempdt(t505
     .       3            -1,t503+1,1)*xyra_delradldwflux(t505-1,t503+1,k,1))*  
     .       4            deltime                                               
     .                 xyr_radldwfluxcor(t505-1,t503+2,k) = xyr_radldwflux(t505-
     .       1            1,t503+2,k) + (xy_dsurftempdt(t505-1,t503+2)*         
     .       2            xyra_delradldwflux(t505-1,t503+2,k,0)+xyz_dtempdt(t505
     .       3            -1,t503+2,1)*xyra_delradldwflux(t505-1,t503+2,k,1))*  
     .       4            deltime                                               
     .                 xyr_radldwfluxcor(t505-1,t503+3,k) = xyr_radldwflux(t505-
     .       1            1,t503+3,k) + (xy_dsurftempdt(t505-1,t503+3)*         
     .       2            xyra_delradldwflux(t505-1,t503+3,k,0)+xyz_dtempdt(t505
     .       3            -1,t503+3,1)*xyra_delradldwflux(t505-1,t503+3,k,1))*  
     .       4            deltime                                               
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
   526          &   xyr_RadLUwFlux(:,:,k)                                  &
   527          & + (   xy_DSurfTempDt     * xyra_DelRadLUwFlux(:,:,k,0)   &
   528          &     + xyz_DTempDt(:,:,1) * xyra_DelRadLUwFlux(:,:,k,1) ) &
   529          &   * DelTime
   530        xyr_RadLDwFluxCor(:,:,k) =                                   &
   531          &   xyr_RadLDwFlux(:,:,k)                                  &
   532          & + (   xy_DSurfTempDt     * xyra_DelRadLDwFlux(:,:,k,0)   &
   533          &     + xyz_DTempDt(:,:,1) * xyra_DelRadLDwFlux(:,:,k,1) ) &
   534          &   * DelTime
   535      end do
   536      xyr_RadLFluxCor = xyr_RadLUwFluxCor - xyr_RadLDwFluxCor
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t531 = 1, (xyr_radluwfluxcor.DSC.U3 + 1)*                      
     .       1   xyr_radluwfluxcor.DSC.U2*(xyr_radluwfluxcor.DSC.U1 + 1)        
     .           xyr_radlfluxcor(t531-1,1,0) = xyr_radluwfluxcor(t531-1,1,0) -  
     .       1      xyr_radldwfluxcor(t531-1,1,0)                               
     .        enddo                                                             
   537  
   538  
   539      ! ヒストリデータ出力
   540      ! History data output
   541      !
   542      call HistoryAutoPut( TimeN, 'OLR', xyr_RadLFluxCor(:,:,kmax) )
   543      call HistoryAutoPut( TimeN, 'SLR', xyr_RadLFluxCor(:,:,0)    )
   544      call HistoryAutoPut( TimeN, 'OSR', xyr_RadSFlux   (:,:,kmax) )
   545      call HistoryAutoPut( TimeN, 'SSR', xyr_RadSFlux   (:,:,0)    )
   546      call HistoryAutoPut( TimeN, 'ISR', xyr_RadSDwFlux (:,:,kmax) )
   547      call HistoryAutoPut( TimeN, 'RadLUWFLX', xyr_RadLUwFluxCor )
   548      call HistoryAutoPut( TimeN, 'RadLDWFLX', xyr_RadLDwFluxCor )
   549      call HistoryAutoPut( TimeN, 'RadSUWFLX', xyr_RadSUwFlux    )
   550      call HistoryAutoPut( TimeN, 'RadSDWFLX', xyr_RadSDwFlux    )
   551  
   552  
   553      ! ヒストリデータ出力
   554      ! History data output
   555      !
   556      call HistoryAutoPut( TimeN, 'OLRB', xyr_RadLFlux(:,:,kmax) )
   557      call HistoryAutoPut( TimeN, 'SLRB', xyr_RadLFlux(:,:,0)    )
   558      call HistoryAutoPut( TimeN, 'OSRB', xyr_RadSFlux(:,:,kmax) )
   559      call HistoryAutoPut( TimeN, 'SSRB', xyr_RadSFlux(:,:,0)    )
   560      call HistoryAutoPut( TimeN, 'ISRB', xyr_RadSDwFlux(:,:,kmax) )
   561      call HistoryAutoPut( TimeN, 'RadLUWFLXB', xyr_RadLUwFlux )
   562      call HistoryAutoPut( TimeN, 'RadLDWFLXB', xyr_RadLDwFlux )
   563      call HistoryAutoPut( TimeN, 'RadSUWFLXB', xyr_RadSUwFlux )
   564      call HistoryAutoPut( TimeN, 'RadSDWFLXB', xyr_RadSDwFlux )
   565  
   566  
   567      ! 長波フラックスの補正 ( 地表フラックス分の補正 )
   568      ! Correct longwave flux ( amount of surface flux )
   569      !
   570      ! Lines commented out below will be deleted soon (yot, 2010/10/31).
   571  !!$    do k = 0, kmax
   572  !!$      xyr_RadLFluxCor (:,:,k) = &
   573  !!$        &     xyr_RadLFlux (:,:,k) &
   574  !!$        &   + xyra_DelRadLFlux(:,:,k,0) * xy_DSurfTempDt (:,:) * 2.0d0 * DelTime
   575  !!$    end do
   576  !!$    do k = 0, kmax
   577  !!$      xyr_RadLFluxCor(:,:,k) = &
   578  !!$        &   xyr_RadLFlux(:,:,k) &
   579  !!$        & + (   xy_DSurfTempDt     * xyra_DelRadLFlux(:,:,k,0)   &
   580  !!$        &     + xyz_DTempDt(:,:,1) * xyra_DelRadLFlux(:,:,k,1) ) &
   581  !!$        &   * 2.0_DP * DelTime
   582  !!$    end do
   583      do k = 0, kmax
   584        xyr_RadLUwFluxCor(:,:,k) =                                   &
     .        if (xyr_radluwflux.DSC.U2 .gt. 0) then                            
     .           j3 = and(xyr_radluwflux.DSC.U2,3)                              
     .  !cdir    nodep                                                          
     .           do t546 = 1, j3                                                
     .  !cdir       nodep                                                       
     .  !cdir       on_adb(xy_dsurftempdt,xyz_dtempdt)                          
     .              do t548 = 1, xyr_radluwflux.DSC.U1 + 1                      
     .                 xyr_radluwfluxcor(t548-1,t546,k) = xyr_radluwflux(t548-1,
     .       1            t546,k) + (xy_dsurftempdt(t548-1,t546)*               
     .       2            xyra_delradluwflux(t548-1,t546,k,0)+xyz_dtempdt(t548-1
     .       3            ,t546,1)*xyra_delradluwflux(t548-1,t546,k,1))*        
     .       4            2.00000000000000e+000*deltime                         
     .                 xyr_radldwfluxcor(t548-1,t546,k) = xyr_radldwflux(t548-1,
     .       1            t546,k) + (xy_dsurftempdt(t548-1,t546)*               
     .       2            xyra_delradldwflux(t548-1,t546,k,0)+xyz_dtempdt(t548-1
     .       3            ,t546,1)*xyra_delradldwflux(t548-1,t546,k,1))*        
     .       4            2.00000000000000e+000*deltime                         
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t546 = j3 + 1, xyr_radluwflux.DSC.U2, 4                     
     .  !cdir       nodep                                                       
     .  !cdir       on_adb(xy_dsurftempdt,xyz_dtempdt)                          
     .              do t548 = 1, xyr_radluwflux.DSC.U1 + 1                      
     .                 xyr_radluwfluxcor(t548-1,t546,k) = xyr_radluwflux(t548-1,
     .       1            t546,k) + (xy_dsurftempdt(t548-1,t546)*               
     .       2            xyra_delradluwflux(t548-1,t546,k,0)+xyz_dtempdt(t548-1
     .       3            ,t546,1)*xyra_delradluwflux(t548-1,t546,k,1))*        
     .       4            2.00000000000000e+000*deltime                         
     .                 xyr_radluwfluxcor(t548-1,t546+1,k) = xyr_radluwflux(t548-
     .       1            1,t546+1,k) + (xy_dsurftempdt(t548-1,t546+1)*         
     .       2            xyra_delradluwflux(t548-1,t546+1,k,0)+xyz_dtempdt(t548
     .       3            -1,t546+1,1)*xyra_delradluwflux(t548-1,t546+1,k,1))*  
     .       4            2.00000000000000e+000*deltime                         
     .                 xyr_radluwfluxcor(t548-1,t546+2,k) = xyr_radluwflux(t548-
     .       1            1,t546+2,k) + (xy_dsurftempdt(t548-1,t546+2)*         
     .       2            xyra_delradluwflux(t548-1,t546+2,k,0)+xyz_dtempdt(t548
     .       3            -1,t546+2,1)*xyra_delradluwflux(t548-1,t546+2,k,1))*  
     .       4            2.00000000000000e+000*deltime                         
     .                 xyr_radluwfluxcor(t548-1,t546+3,k) = xyr_radluwflux(t548-
     .       1            1,t546+3,k) + (xy_dsurftempdt(t548-1,t546+3)*         
     .       2            xyra_delradluwflux(t548-1,t546+3,k,0)+xyz_dtempdt(t548
     .       3            -1,t546+3,1)*xyra_delradluwflux(t548-1,t546+3,k,1))*  
     .       4            2.00000000000000e+000*deltime                         
     .                 xyr_radldwfluxcor(t548-1,t546,k) = xyr_radldwflux(t548-1,
     .       1            t546,k) + (xy_dsurftempdt(t548-1,t546)*               
     .       2            xyra_delradldwflux(t548-1,t546,k,0)+xyz_dtempdt(t548-1
     .       3            ,t546,1)*xyra_delradldwflux(t548-1,t546,k,1))*        
     .       4            2.00000000000000e+000*deltime                         
     .                 xyr_radldwfluxcor(t548-1,t546+1,k) = xyr_radldwflux(t548-
     .       1            1,t546+1,k) + (xy_dsurftempdt(t548-1,t546+1)*         
     .       2            xyra_delradldwflux(t548-1,t546+1,k,0)+xyz_dtempdt(t548
     .       3            -1,t546+1,1)*xyra_delradldwflux(t548-1,t546+1,k,1))*  
     .       4            2.00000000000000e+000*deltime                         
     .                 xyr_radldwfluxcor(t548-1,t546+2,k) = xyr_radldwflux(t548-
     .       1            1,t546+2,k) + (xy_dsurftempdt(t548-1,t546+2)*         
     .       2            xyra_delradldwflux(t548-1,t546+2,k,0)+xyz_dtempdt(t548
     .       3            -1,t546+2,1)*xyra_delradldwflux(t548-1,t546+2,k,1))*  
     .       4            2.00000000000000e+000*deltime                         
     .                 xyr_radldwfluxcor(t548-1,t546+3,k) = xyr_radldwflux(t548-
     .       1            1,t546+3,k) + (xy_dsurftempdt(t548-1,t546+3)*         
     .       2            xyra_delradldwflux(t548-1,t546+3,k,0)+xyz_dtempdt(t548
     .       3            -1,t546+3,1)*xyra_delradldwflux(t548-1,t546+3,k,1))*  
     .       4            2.00000000000000e+000*deltime                         
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
   585          &   xyr_RadLUwFlux(:,:,k)                                  &
   586          & + (   xy_DSurfTempDt     * xyra_DelRadLUwFlux(:,:,k,0)   &
   587          &     + xyz_DTempDt(:,:,1) * xyra_DelRadLUwFlux(:,:,k,1) ) &
   588          &   * 2.0_DP * DelTime
   589        xyr_RadLDwFluxCor(:,:,k) =                                   &
   590          &   xyr_RadLDwFlux(:,:,k)                                  &
   591          & + (   xy_DSurfTempDt     * xyra_DelRadLDwFlux(:,:,k,0)   &
   592          &     + xyz_DTempDt(:,:,1) * xyra_DelRadLDwFlux(:,:,k,1) ) &
   593          &   * 2.0_DP * DelTime
   594      end do
   595      xyr_RadLFluxCor = xyr_RadLUwFluxCor - xyr_RadLDwFluxCor
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t574 = 1, (xyr_radluwfluxcor.DSC.U3 + 1)*                      
     .       1   xyr_radluwfluxcor.DSC.U2*(xyr_radluwfluxcor.DSC.U1 + 1)        
     .           xyr_radlfluxcor(t574-1,1,0) = xyr_radluwfluxcor(t574-1,1,0) -  
     .       1      xyr_radldwfluxcor(t574-1,1,0)                               
     .        enddo                                                             
   596  
   597  
   598      ! ヒストリデータ出力
   599      ! History data output
   600      !
   601      call HistoryAutoPut( TimeN, 'OLRA', xyr_RadLFluxCor(:,:,kmax) )
   602      call HistoryAutoPut( TimeN, 'SLRA', xyr_RadLFluxCor(:,:,0)    )
   603      call HistoryAutoPut( TimeN, 'OSRA', xyr_RadSFlux   (:,:,kmax) )
   604      call HistoryAutoPut( TimeN, 'SSRA', xyr_RadSFlux   (:,:,0)    )
   605      call HistoryAutoPut( TimeN, 'ISRA', xyr_RadSDwFlux (:,:,kmax) )
   606      call HistoryAutoPut( TimeN, 'RadLUWFLXA', xyr_RadLUwFluxCor )
   607      call HistoryAutoPut( TimeN, 'RadLDWFLXA', xyr_RadLDwFluxCor )
   608      call HistoryAutoPut( TimeN, 'RadSUWFLXA', xyr_RadSUwFlux    )
   609      call HistoryAutoPut( TimeN, 'RadSDWFLXA', xyr_RadSDwFlux    )
   610  
   611  
   612      ! 計算時間計測一時停止
   613      ! Pause measurement of computation time
   614      !
   615      call TimesetClockStop( module_name )
   616  
   617    end subroutine RadFluxOutput
   618  
   619    !-------------------------------------------------------------------
   620  
   621    subroutine RadUtilsInit
   622      !
   623      ! rad_utils モジュールの初期化を行います.
   624      ! NAMELIST#rad_utils_nml の読み込みはこの手続きで行われます.
   625      !
   626      ! "rad_utils" module is initialized.
   627      ! "NAMELIST#rad_utils_nml" is loaded in this procedure.
   628      !
   629  
   630      ! モジュール引用 ; USE statements
   631      !
   632  
   633      ! 文字列操作
   634      ! Character handling
   635      !
   636      use dc_string, only: toChar
   637  
   638      ! ファイル入出力補助
   639      ! File I/O support
   640      !
   641      use dc_iounit, only: FileOpen
   642  
   643      ! ヒストリデータ出力
   644      ! History data output
   645      !
   646      use gtool_historyauto, only: HistoryAutoAddVariable
   647  
   648      ! NAMELIST ファイル入力に関するユーティリティ
   649      ! Utilities for NAMELIST file input
   650      !
   651      use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid
   652  
   653      ! 宣言文 ; Declaration statements
   654      !
   655  
   656      integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号.
   657                                ! Unit number for NAMELIST file open
   658      integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT.
   659                                ! IOSTAT of NAMELIST read
   660  
   661  
   662      ! NAMELIST 変数群
   663      ! NAMELIST group name
   664      !
   665  !!$    namelist /rad_utils_nml/ &
   666  !!$      & DiffFact
   667  !!$      & DelTimeLongValue, DelTimeLongUnit, &
   668  !!$      & DelTimeShortValue, DelTimeShortUnit, &
   669  !!$!
   670  !!$      & LongBandNum, &
   671  !!$      & LongAbsorpCoefQVap, LongAbsorpCoefDryAir, &
   672  !!$      & LongBandWeight, LongPathLengthFact, &
   673  !!$!
   674  !!$      & ShortBandNum, &
   675  !!$      & ShortAbsorpCoefQVap, ShortAbsorpCoefDryAir, &
   676  !!$      & ShortBandWeight, ShortSecScat, &
   677  !!$      & ShortAtmosAlbedo, &
   678  !!$!
   679  !!$      & RstInputFile, RstOutputFile
   680            !
   681            ! デフォルト値については初期化手続 "rad_utils#RadInit"
   682            ! のソースコードを参照のこと.
   683            !
   684            ! Refer to source codes in the initialization procedure
   685            ! "rad_utils#RadInit" for the default values.
   686            !
   687  
   688      ! 実行文 ; Executable statement
   689      !
   690  
   691      if ( rad_utils_inited ) return
   692  
   693  
   694      ! デフォルト値の設定
   695      ! Default values settings
   696      !
   697  
   698      ! NAMELIST の読み込み
   699      ! NAMELIST is input
   700      !
   701  !!$    if ( trim(namelist_filename) /= '' ) then
   702  !!$      call FileOpen( unit_nml, &          ! (out)
   703  !!$        & namelist_filename, mode = 'r' ) ! (in)
   704  !!$
   705  !!$      rewind( unit_nml )
   706  !!$      read( unit_nml,                     & ! (in)
   707  !!$        & nml = rad_utils_nml,            & ! (out)
   708  !!$        & iostat = iostat_nml )             ! (out)
   709  !!$      close( unit_nml )
   710  !!$
   711  !!$      call NmlutilMsg( iostat_nml, module_name ) ! (in)
   712  !!$    end if
   713  
   714  
   715      ! ヒストリデータ出力のためのへの変数登録
   716      ! Register of variables for history data output
   717      !
   718      call HistoryAutoAddVariable( 'OLR', &
   719        & (/ 'lon ', 'lat ', 'time' /), &
   720        & 'outgoing longwave', 'W m-2' )
   721      call HistoryAutoAddVariable( 'SLR', &
   722        & (/ 'lon ', 'lat ', 'time' /), &
   723        & 'surface longwave', 'W m-2' )
   724      call HistoryAutoAddVariable( 'OSR', &
   725        & (/ 'lon ', 'lat ', 'time' /), &
   726        & 'outgoing shortwave', 'W m-2' )
   727      call HistoryAutoAddVariable( 'SSR', &
   728        & (/ 'lon ', 'lat ', 'time' /), &
   729        & 'surface shortwave', 'W m-2' )
   730  
   731      call HistoryAutoAddVariable( 'ISR' , &
   732        & (/ 'lon ', 'lat ', 'time'/),     &
   733        & 'incoming shortwave', 'W m-2' )
   734  
   735      call HistoryAutoAddVariable( 'RadLUWFLX', &
   736        & (/ 'lon ', 'lat ', 'sigm', 'time' /), &
   737        & 'upward longwave flux', 'W m-2' )
   738      call HistoryAutoAddVariable( 'RadLDWFLX', &
   739        & (/ 'lon ', 'lat ', 'sigm', 'time' /), &
   740        & 'downward longwave flux', 'W m-2' )
   741      call HistoryAutoAddVariable( 'RadSUWFLX', &
   742        & (/ 'lon ', 'lat ', 'sigm', 'time' /), &
   743        & 'upward shortwave flux', 'W m-2' )
   744      call HistoryAutoAddVariable( 'RadSDWFLX', &
   745        & (/ 'lon ', 'lat ', 'sigm', 'time' /), &
   746        & 'downward shortwave flux', 'W m-2' )
   747  
   748      call HistoryAutoAddVariable( 'OLRB', &
   749        & (/ 'lon ', 'lat ', 'time' /), &
   750        & 'outgoing longwave', 'W m-2' )
   751      call HistoryAutoAddVariable( 'SLRB', &
   752        & (/ 'lon ', 'lat ', 'time' /), &
   753        & 'surface longwave', 'W m-2' )
   754      call HistoryAutoAddVariable( 'OSRB', &
   755        & (/ 'lon ', 'lat ', 'time' /), &
   756        & 'outgoing shortwave', 'W m-2' )
   757      call HistoryAutoAddVariable( 'SSRB', &
   758        & (/ 'lon ', 'lat ', 'time' /), &
   759        & 'surface shortwave', 'W m-2' )
   760  
   761      call HistoryAutoAddVariable( 'ISRB' , &
   762        & (/ 'lon ', 'lat ', 'time'/),     &
   763        & 'incoming shortwave', 'W m-2' )
   764  
   765      call HistoryAutoAddVariable( 'RadLUWFLXB', &
   766        & (/ 'lon ', 'lat ', 'sigm', 'time' /), &
   767        & 'upward longwave flux', 'W m-2' )
   768      call HistoryAutoAddVariable( 'RadLDWFLXB', &
   769        & (/ 'lon ', 'lat ', 'sigm', 'time' /), &
   770        & 'downward longwave flux', 'W m-2' )
   771      call HistoryAutoAddVariable( 'RadSUWFLXB', &
   772        & (/ 'lon ', 'lat ', 'sigm', 'time' /), &
   773        & 'upward shortwave flux', 'W m-2' )
   774      call HistoryAutoAddVariable( 'RadSDWFLXB', &
   775        & (/ 'lon ', 'lat ', 'sigm', 'time' /), &
   776        & 'downward shortwave flux', 'W m-2' )
   777  
   778      call HistoryAutoAddVariable( 'OLRA', &
   779        & (/ 'lon ', 'lat ', 'time' /), &
   780        & 'outgoing longwave', 'W m-2' )
   781      call HistoryAutoAddVariable( 'SLRA', &
   782        & (/ 'lon ', 'lat ', 'time' /), &
   783        & 'surface longwave', 'W m-2' )
   784      call HistoryAutoAddVariable( 'OSRA', &
   785        & (/ 'lon ', 'lat ', 'time' /), &
   786        & 'outgoing shortwave', 'W m-2' )
   787      call HistoryAutoAddVariable( 'SSRA', &
   788        & (/ 'lon ', 'lat ', 'time' /), &
   789        & 'surface shortwave', 'W m-2' )
   790  
   791      call HistoryAutoAddVariable( 'ISRA' , &
   792        & (/ 'lon ', 'lat ', 'time'/),     &
   793        & 'incoming shortwave', 'W m-2' )
   794  
   795      call HistoryAutoAddVariable( 'RadLUWFLXA', &
   796        & (/ 'lon ', 'lat ', 'sigm', 'time' /), &
   797        & 'upward longwave flux', 'W m-2' )
   798      call HistoryAutoAddVariable( 'RadLDWFLXA', &
   799        & (/ 'lon ', 'lat ', 'sigm', 'time' /), &
   800        & 'downward longwave flux', 'W m-2' )
   801      call HistoryAutoAddVariable( 'RadSUWFLXA', &
   802        & (/ 'lon ', 'lat ', 'sigm', 'time' /), &
   803        & 'upward shortwave flux', 'W m-2' )
   804      call HistoryAutoAddVariable( 'RadSDWFLXA', &
   805        & (/ 'lon ', 'lat ', 'sigm', 'time' /), &
   806        & 'downward shortwave flux', 'W m-2' )
   807  
   808      call HistoryAutoAddVariable( 'DTempDtRadL', &
   809        & (/ 'lon ', 'lat ', 'sig ', 'time' /), &
   810        & 'long wave radiative heating rate', 'K s-1' )
   811      call HistoryAutoAddVariable( 'DTempDtRadS', &
   812        & (/ 'lon ', 'lat ', 'sig ', 'time' /), &
   813        & 'short wave radiative heating rate', 'K s-1' )
   814  
   815  
   816      ! 印字 ; Print
   817      !
   818      call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   819  !!$    call MessageNotify( 'M', module_name, 'DiffFact = %f', d = (/ DiffFact /) )
   820      call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   821  
   822      rad_utils_inited = .true.
   823  
   824    end subroutine RadUtilsInit
   825  
   826    !-------------------------------------------------------------------
   827  
   828  end module rad_utils
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:45 2016
FILE NAME: rad_utils.f90
PROGRAM NAME: rad_utils
FORMAT LIST

  LINE    LOOP      FORTRAN STATEMENT

     1:             != 放射関連ルーチン
     2:             !
     3:             != Routines for radiation calculation
     4:             !
     5:             ! Authors::   Yasuhiro MORIKAWA, Yukiko YAMADA, Satoshi NODA, Yoshiyuki O. TAKAHASHI
     6:             ! Version::   $Id: rad_utils.f90,v 1.7 2012/10/08 12:48:45 yot Exp $ 
     7:             ! Tag Name::  $Name:  $
     8:             ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9:             ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10:             !
    11:             
    12:             module rad_utils
    13:               !
    14:               != 放射関連ルーチン
    15:               !
    16:               != Routines for radiation calculation
    17:               !
    18:               ! <b>Note that Japanese and English are described in parallel.</b>
    19:               !
    20:               ! 
    21:               !
    22:               ! 
    23:               !
    24:               !== Procedures List
    25:               !
    26:               ! RadDTempDt        :: 放射フラックスによる温度変化の計算
    27:               ! RadFluxOutput     :: 放射フラックスの出力
    28:               ! ------------            :: ------------
    29:               ! RadDTempDt        :: Calculate temperature tendency with radiation flux
    30:               ! RadFluxOutput     :: Output radiation fluxes
    31:               !
    32:               !== NAMELIST
    33:               !
    34:               ! NAMELIST#rad_utils_nml
    35:               !
    36:             
    37:               ! モジュール引用 ; USE statements
    38:               !
    39:             
    40:               ! 種別型パラメタ
    41:               ! Kind type parameter
    42:               !
    43:               use dc_types, only: DP, &      ! 倍精度実数型. Double precision. 
    44:                 &                 STRING, &  ! 文字列.       Strings. 
    45:                 &                 TOKEN      ! キーワード.   Keywords. 
    46:             
    47:               ! 物理・数学定数設定
    48:               ! Physical and mathematical constants settings
    49:               !
    50:               use constants0, only: &
    51:                 & PI, &                 ! $ \pi $.
    52:                                         ! 円周率. Circular constant
    53:                 & StB
    54:                                         ! $ \sigma_{SB} $ .
    55:                                         ! ステファンボルツマン定数.
    56:                                         ! Stefan-Boltzmann constant
    57:             
    58:               ! 物理定数設定
    59:               ! Physical constants settings
    60:               !
    61:               use constants, only: &
    62:                 & Grav, &
    63:                                         ! $ g $ [m s-2]. 
    64:                                         ! 重力加速度. 
    65:                                         ! Gravitational acceleration
    66:                 & CpDry
    67:                                         ! $ C_p $ [J kg-1 K-1]. 
    68:                                         ! 乾燥大気の定圧比熱. 
    69:                                         ! Specific heat of air at constant pressure
    70:             
    71:             
    72:               ! 格子点設定
    73:               ! Grid points settings
    74:               !
    75:               use gridset, only: imax, & ! 経度格子点数. 
    76:                                          ! Number of grid points in longitude
    77:                 &                jmax, & ! 緯度格子点数. 
    78:                                          ! Number of grid points in latitude
    79:                 &                kmax    ! 鉛直層数. 
    80:                                          ! Number of vertical level
    81:             
    82:               ! メッセージ出力
    83:               ! Message output
    84:               !
    85:               use dc_message, only: MessageNotify
    86:             
    87:               ! 宣言文 ; Declaration statements
    88:               !
    89:               implicit none
    90:               private
    91:             
    92:               ! 公開手続き
    93:               ! Public procedure
    94:               !
    95:               public :: RadDTempDt
    96:               public :: RadDTempDtforNHM2DWrapper
    97:               public :: RadFluxOutput
    98:               public :: RadUtilsInit
    99:             
   100:             
   101:               ! 公開変数
   102:               ! Public variables
   103:               !
   104:               logical, save, public:: rad_utils_inited = .false.
   105:                                           ! 初期設定フラグ. 
   106:                                           ! Initialization flag
   107:             
   108:             
   109:               ! 非公開変数
   110:               ! Private variables
   111:               !
   112:             
   113:             
   114:               character(*), parameter:: module_name = 'rad_utils'
   115:                                           ! モジュールの名称. 
   116:                                           ! Module name
   117:               character(*), parameter:: version = &
   118:                 & '$Name:  $' // &
   119:                 & '$Id: rad_utils.f90,v 1.7 2012/10/08 12:48:45 yot Exp $'
   120:                                           ! モジュールのバージョン
   121:                                           ! Module version
   122:             
   123:             contains
   124:             
   125:               !--------------------------------------------------------------------------------------
   126:             
   127:               subroutine RadDTempDt( &
   128:                 & xyr_RadLFlux, xyr_RadSFlux, xyr_Press, & ! (in)
   129:                 & xyz_DTempDtRadL, xyz_DTempDtRadS &       ! (out)
   130:                 & )
   131:                 !
   132:                 ! 放射による温度変化率を計算します. 
   133:                 ! 
   134:                 ! Temperature tendency with radiation is calculated. 
   135:                 !
   136:             
   137:                 ! モジュール引用 ; USE statements
   138:                 !
   139:             
   140:                 ! 時刻管理
   141:                 ! Time control
   142:                 !
   143:                 use timeset, only: &
   144:                   & TimeN, &              ! ステップ $ t $ の時刻. Time of step $ t $. 
   145:                   & TimesetClockStart, TimesetClockStop
   146:             
   147:                 ! ヒストリデータ出力
   148:                 ! History data output
   149:                 !
   150:                 use gtool_historyauto, only: HistoryAutoPut
   151:             
   152:             
   153:                 ! 宣言文 ; Declaration statements
   154:                 !
   155:                 implicit none
   156:                 real(DP), intent(in):: xyr_RadLFlux (0:imax-1, 1:jmax, 0:kmax)
   157:                                           ! 長波フラックス. 
   158:                                           ! Longwave flux
   159:                 real(DP), intent(in):: xyr_RadSFlux (0:imax-1, 1:jmax, 0:kmax)
   160:                                           ! 短波 (日射) フラックス. 
   161:                                           ! Shortwave (insolation) flux
   162:                 real(DP), intent(in):: xyr_Press    (0:imax-1, 1:jmax, 0:kmax)
   163:                                           ! $ \hat{p} $ . 気圧 (半整数レベル). 
   164:                                           ! Air pressure (half level)
   165:                 real(DP), intent(out):: xyz_DTempDtRadL (0:imax-1, 1:jmax, 1:kmax)
   166:                                           ! 長波加熱率. 
   167:                                           ! Temperature tendency with longwave
   168:                 real(DP), intent(out):: xyz_DTempDtRadS (0:imax-1, 1:jmax, 1:kmax)
   169:                                           ! 短波加熱率. 
   170:                                           ! Temperature tendency with shortwave
   171:             
   172:                 ! 作業変数
   173:                 ! Work variables
   174:                 !
   175:                 integer:: k               ! 鉛直方向に回る DO ループ用作業変数
   176:                                           ! Work variables for DO loop in vertical direction
   177:             
   178:                 ! 実行文 ; Executable statement
   179:                 !
   180:             
   181:                 ! 初期化確認
   182:                 ! Initialization check
   183:                 !
   184:                 if ( .not. rad_utils_inited ) then
   185:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   186:                 end if
   187:             
   188:             
   189:                 ! 計算時間計測開始
   190:                 ! Start measurement of computation time
   191:                 !
   192:                 call TimesetClockStart( module_name )
   193:             
   194:             
   195:                 ! 放射冷却率の演算
   196:                 ! Calculate radiation cooling rate
   197:                 !
   198: W------>        do k = 1, kmax
   199: |**---->A         xyz_DTempDtRadL(:,:,k) = &
   200: |||                 & (     xyr_RadLFlux(:,:,k-1) - xyr_RadLFlux(:,:,k) ) &
   201: |||                 &   / ( xyr_Press(:,:,k-1)    - xyr_Press(:,:,k) ) &
   202: |||                 &   / CpDry * Grav
   203: |||         
   204: |**---- A         xyz_DTempDtRadS(:,:,k) = &
   205: |                   & (     xyr_RadSFlux(:,:,k-1) - xyr_RadSFlux(:,:,k) ) &
   206: |                   &   / ( xyr_Press(:,:,k-1)    - xyr_Press(:,:,k) ) &
   207: |                   &   / CpDry * Grav
   208: W------         end do
   209:             
   210:             
   211:                 ! ヒストリデータ出力
   212:                 ! History data output
   213:                 !
   214:                 call HistoryAutoPut( TimeN, 'DTempDtRadL' , xyz_DTempDtRadL )
   215:                 call HistoryAutoPut( TimeN, 'DTempDtRadS' , xyz_DTempDtRadS )
   216:             
   217:             
   218:                 ! 計算時間計測一時停止
   219:                 ! Pause measurement of computation time
   220:                 !
   221:                 call TimesetClockStop( module_name )
   222:             
   223:               end subroutine RadDTempDt
   224:             
   225:               !--------------------------------------------------------------------------------------
   226:             
   227:               subroutine RadDTempDtforNHM(                        &
   228:                 & xyr_RadLFlux, xyr_RadSFlux, r_Height, xyz_Dens, & ! (in)
   229:                 & xyz_DTempDtRadL, xyz_DTempDtRadS                & ! (out)
   230:                 & )
   231:                 !
   232:                 ! 非静力学系における放射による温度変化率を計算します. 
   233:                 ! 
   234:                 ! Temperature tendency with radiation is calculated for non-hydrodynamic system. 
   235:                 !
   236:             
   237:                 ! モジュール引用 ; USE statements
   238:                 !
   239:             
   240:                 ! 時刻管理
   241:                 ! Time control
   242:                 !
   243:                 use timeset, only: &
   244:                   & TimeN, &              ! ステップ $ t $ の時刻. Time of step $ t $. 
   245:                   & TimesetClockStart, TimesetClockStop
   246:             
   247:                 ! ヒストリデータ出力
   248:                 ! History data output
   249:                 !
   250:                 use gtool_historyauto, only: HistoryAutoPut
   251:             
   252:             
   253:                 ! 宣言文 ; Declaration statements
   254:                 !
   255:                 implicit none
   256:                 real(DP), intent(in):: xyr_RadLFlux (0:imax-1, 1:jmax, 0:kmax)
   257:                                           ! 長波フラックス. 
   258:                                           ! Longwave flux
   259:                 real(DP), intent(in):: xyr_RadSFlux (0:imax-1, 1:jmax, 0:kmax)
   260:                                           ! 短波 (日射) フラックス. 
   261:                                           ! Shortwave (insolation) flux
   262:                 real(DP), intent(in):: r_Height                       (0:kmax)
   263:                                           ! $ \hat{p} $ . 気圧 (半整数レベル). 
   264:                                           ! Air pressure (half level)
   265:                 real(DP), intent(in):: xyz_Dens     (0:imax-1, 1:jmax, 1:kmax)
   266:                 real(DP), intent(out):: xyz_DTempDtRadL (0:imax-1, 1:jmax, 1:kmax)
   267:                                           ! 長波加熱率. 
   268:                                           ! Temperature tendency with longwave
   269:                 real(DP), intent(out):: xyz_DTempDtRadS (0:imax-1, 1:jmax, 1:kmax)
   270:                                           ! 短波加熱率. 
   271:                                           ! Temperature tendency with shortwave
   272:             
   273:                 ! 作業変数
   274:                 ! Work variables
   275:                 !
   276:                 integer:: k               ! 鉛直方向に回る DO ループ用作業変数
   277:                                           ! Work variables for DO loop in vertical direction
   278:             
   279:                 ! 実行文 ; Executable statement
   280:                 !
   281:             
   282:                 ! 初期化確認
   283:                 ! Initialization check
   284:                 !
   285:                 if ( .not. rad_utils_inited ) then
   286:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   287:                 end if
   288:             
   289:             
   290:                 ! 計算時間計測開始
   291:                 ! Start measurement of computation time
   292:                 !
   293:                 call TimesetClockStart( module_name )
   294:             
   295:             
   296:                 ! 放射冷却率の演算
   297:                 ! Calculate radiation cooling rate
   298:                 !
   299: +------>        do k = 1, kmax
   300: |*W---->A         xyz_DTempDtRadL(:,:,k) = &
   301: |||                 &   - ( xyr_RadLFlux(:,:,k) - xyr_RadLFlux(:,:,k-1) ) &
   302: |||                 &   / (   r_Height      (k) -   r_Height      (k-1) ) &
   303: |||                 &   / ( CpDry * xyz_Dens(:,:,k) )
   304: |||         
   305: |*W---- A         xyz_DTempDtRadS(:,:,k) = &
   306: |                   &   - ( xyr_RadSFlux(:,:,k) - xyr_RadSFlux(:,:,k-1) ) &
   307: |                   &   / (   r_Height      (k) -   r_Height      (k-1) ) &
   308: |                   &   / ( CpDry * xyz_Dens(:,:,k) )
   309: +------         end do
   310:             
   311:             
   312:                 ! ヒストリデータ出力
   313:                 ! History data output
   314:                 !
   315:                 call HistoryAutoPut( TimeN, 'DTempDtRadL' , xyz_DTempDtRadL )
   316:                 call HistoryAutoPut( TimeN, 'DTempDtRadS' , xyz_DTempDtRadS )
   317:             
   318:             
   319:                 ! 計算時間計測一時停止
   320:                 ! Pause measurement of computation time
   321:                 !
   322:                 call TimesetClockStop( module_name )
   323:             
   324:               end subroutine RadDTempDtforNHM
   325:             
   326:               !--------------------------------------------------------------------------------------
   327:             
   328:               subroutine RadDTempDtforNHM2DWrapper(             &
   329:                 & xr_RadLFlux, xr_RadSFlux, r_Height, xz_Dens,  & ! (in)
   330:                 & xz_DTempDtRadL, xz_DTempDtRadS                & ! (out)
   331:                 & )
   332:                 !
   333:                 ! 放射による温度変化率を計算します. 
   334:                 ! 
   335:                 ! Temperature tendency with radiation is calculated. 
   336:                 !
   337:             
   338:                 ! モジュール引用 ; USE statements
   339:                 !
   340:             
   341:                 ! 宣言文 ; Declaration statements
   342:                 !
   343:                 implicit none
   344:                 real(DP), intent(in):: xr_RadLFlux (0:imax-1, 0:kmax)
   345:                                           ! 長波フラックス. 
   346:                                           ! Longwave flux
   347:                 real(DP), intent(in):: xr_RadSFlux (0:imax-1, 0:kmax)
   348:                                           ! 短波 (日射) フラックス. 
   349:                                           ! Shortwave (insolation) flux
   350:                 real(DP), intent(in):: r_Height    (0:kmax)
   351:                                           ! $ \hat{p} $ . 気圧 (半整数レベル). 
   352:                                           ! Air pressure (half level)
   353:                 real(DP), intent(in):: xz_Dens     (0:imax-1, 1:kmax)
   354:                 real(DP), intent(out):: xz_DTempDtRadL (0:imax-1, 1:kmax)
   355:                                           ! 長波加熱率. 
   356:                                           ! Temperature tendency with longwave
   357:                 real(DP), intent(out):: xz_DTempDtRadS (0:imax-1, 1:kmax)
   358:                                           ! 短波加熱率. 
   359:                                           ! Temperature tendency with shortwave
   360:             
   361:                 ! 作業変数
   362:                 ! Work variables
   363:                 !
   364:                 real(DP) :: xyr_RadLFlux   (0:imax-1, 1:jmax, 0:kmax)
   365:                 real(DP) :: xyr_RadSFlux   (0:imax-1, 1:jmax, 0:kmax)
   366:                 real(DP) :: xyz_Dens       (0:imax-1, 1:jmax, 1:kmax)
   367:                 real(DP) :: xyz_DTempDtRadL(0:imax-1, 1:jmax, 1:kmax)
   368:                 real(DP) :: xyz_DTempDtRadS(0:imax-1, 1:jmax, 1:kmax)
   369:             
   370:             
   371:                 ! 実行文 ; Executable statement
   372:                 !
   373:             
   374:                 ! 初期化確認
   375:                 ! Initialization check
   376:                 !
   377:                 if ( .not. rad_utils_inited ) then
   378:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   379:                 end if
   380:             
   381:             
   382: *V----->A       xyr_RadLFlux(:,1,:) = xr_RadLFlux(:,:)
   383: *V----- A       xyr_RadSFlux(:,1,:) = xr_RadSFlux(:,:)
   384: +V===== A       xyz_Dens    (:,1,:) = xz_Dens    (:,:)
   385:             
   386:                 call RadDTempDtforNHM(                              &
   387:                   & xyr_RadLFlux, xyr_RadSFlux, r_Height, xyz_Dens, & ! (in)
   388:                   & xyz_DTempDtRadL, xyz_DTempDtRadS                & ! (out)
   389:                   & )
   390:             
   391: *V----->A       xz_DTempDtRadL(:,:) = xyz_DTempDtRadL(:,1,:)
   392: *V----- A       xz_DTempDtRadS(:,:) = xyz_DTempDtRadS(:,1,:)
   393:             
   394:             
   395:               end subroutine RadDTempDtforNHM2DWrapper
   396:             
   397:               !-------------------------------------------------------------------
   398:             
   399:               subroutine RadFluxOutput(                          &
   400:                 & xyr_RadSUwFlux, xyr_RadSDwFlux,                & ! (in)
   401:                 & xyr_RadLUwFlux, xyr_RadLDwFlux,                & ! (in)
   402:                 & xyra_DelRadLUwFlux, xyra_DelRadLDwFlux,        & ! (in)
   403:                 & xy_DSurfTempDt, xyz_DTempDt                    & ! (in)
   404:                 & )
   405:                 !
   406:                 ! 放射フラックス (xyr_RadSFlux, xyr_RadLFlux) 
   407:                 ! について, その他の引数を用いて補正し, 出力を行う. 
   408:                 !
   409:                 ! Radiation fluxes (xyr_RadSFlux, xyr_RadLFlux) are
   410:                 ! corrected by using other arguments, and the corrected values are output.
   411:                 !
   412:             
   413:                 ! モジュール引用 ; USE statements
   414:                 !
   415:             
   416:                 ! 時刻管理
   417:                 ! Time control
   418:                 !
   419:                 use timeset, only: &
   420:                   & DelTime, &            ! $ \Delta t $ [s]
   421:                   & TimeN, &              ! ステップ $ t $ の時刻. Time of step $ t $. 
   422:                   & TimesetClockStart, TimesetClockStop
   423:             
   424:                 ! ヒストリデータ出力
   425:                 ! History data output
   426:                 !
   427:                 use gtool_historyauto, only: HistoryAutoPut
   428:             
   429:                 ! 宣言文 ; Declaration statements
   430:                 !
   431:                 implicit none
   432:                 real(DP), intent(in):: xyr_RadSUwFlux  (0:imax-1, 1:jmax, 0:kmax)
   433:                                           ! 短波 (日射) フラックス. 
   434:                                           ! Upward shortwave (insolation) flux
   435:                 real(DP), intent(in):: xyr_RadSDwFlux  (0:imax-1, 1:jmax, 0:kmax)
   436:                                           ! 短波 (日射) フラックス. 
   437:                                           ! Downward shortwave (insolation) flux
   438:             
   439:                 real(DP), intent(in):: xyr_RadLUwFlux    (0:imax-1, 1:jmax, 0:kmax)
   440:                                           ! 長波フラックス. 
   441:                                           ! Upward longwave flux
   442:                 real(DP), intent(in):: xyr_RadLDwFlux    (0:imax-1, 1:jmax, 0:kmax)
   443:                                           ! 長波フラックス. 
   444:                                           ! Downward longwave flux
   445:                 real(DP), intent(in):: xyra_DelRadLUwFlux(0:imax-1, 1:jmax, 0:kmax, 0:1)
   446:                                           ! 長波地表温度変化. 
   447:                                           ! 
   448:                 real(DP), intent(in):: xyra_DelRadLDwFlux(0:imax-1, 1:jmax, 0:kmax, 0:1)
   449:                                           ! 長波地表温度変化. 
   450:                                           ! 
   451:             
   452:                 real(DP), intent(in):: xy_DSurfTempDt  (0:imax-1, 1:jmax)
   453:                                           ! 地表面温度変化率. 
   454:                                           ! Surface temperature tendency
   455:                 real(DP), intent(in):: xyz_DTempDt     (0:imax-1, 1:jmax, 1:kmax)
   456:                                           ! $ \DP{T}{t} $ . 温度変化 (K s-1)
   457:                                           ! Temperature tendency (K s-1)
   458:             
   459:                 ! 出力のための作業変数
   460:                 ! Work variables for output
   461:                 !
   462:                 real(DP):: xyr_RadSFlux    (0:imax-1, 1:jmax, 0:kmax)
   463:                                           ! 短波 (日射) フラックス. 
   464:                                           ! Shortwave (insolation) flux
   465:                 real(DP):: xyr_RadLFlux    (0:imax-1, 1:jmax, 0:kmax)
   466:                                           ! 長波フラックス. 
   467:                                           ! Longwave flux
   468:                 real(DP):: xyra_DelRadLFlux(0:imax-1, 1:jmax, 0:kmax, 0:1)
   469:                                           ! 長波地表温度変化. 
   470:                                           ! Surface temperature tendency with longwave
   471:                 real(DP):: xyr_RadLUwFluxCor(0:imax-1, 1:jmax, 0:kmax)
   472:                                           ! 補正された長波フラックス. 
   473:                                           ! Corrected longwave flux
   474:                 real(DP):: xyr_RadLDwFluxCor(0:imax-1, 1:jmax, 0:kmax)
   475:                                           ! 補正された長波フラックス. 
   476:                                           ! Corrected longwave flux
   477:                 real(DP):: xyr_RadLFluxCor  (0:imax-1, 1:jmax, 0:kmax)
   478:                                           ! 補正された長波フラックス. 
   479:                                           ! Corrected longwave flux
   480:             
   481:                 ! 作業変数
   482:                 ! Work variables
   483:                 !
   484:                 integer:: k               ! 鉛直方向に回る DO ループ用作業変数
   485:                                           ! Work variables for DO loop in vertical direction
   486:                 ! 実行文 ; Executable statement
   487:                 !
   488:             
   489:                 ! 初期化確認
   490:                 ! Initialization check
   491:                 !
   492:                 if ( .not. rad_utils_inited ) then
   493:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   494:                 end if
   495:             
   496:             
   497:                 ! 計算時間計測開始
   498:                 ! Start measurement of computation time
   499:                 !
   500:                 call TimesetClockStart( module_name )
   501:             
   502:             
   503: **V---->A       xyr_RadSFlux     = xyr_RadSUwFlux     - xyr_RadSDwFlux
   504: **V---- A       xyr_RadLFlux     = xyr_RadLUwFlux     - xyr_RadLDwFlux
   505: W***=== A       xyra_DelRadLFlux = xyra_DelRadLUwFlux - xyra_DelRadLDwFlux
   506:             
   507:             
   508:                 ! 長波フラックスの補正 ( 地表フラックス分の補正 )
   509:                 ! Correct longwave flux ( amount of surface flux )
   510:                 !
   511:                 ! Lines commented out below will be deleted soon (yot, 2010/10/31).
   512:             !!$    do k = 0, kmax
   513:             !!$      xyr_RadLFluxCor (:,:,k) = &
   514:             !!$        &     xyr_RadLFlux (:,:,k) &
   515:             !!$        &   + xyra_DelRadLFlux(:,:,k,0) * xy_DSurfTempDt (:,:) * DelTime
   516:             !!$    end do
   517:             !!$    do k = 0, kmax
   518:             !!$      xyr_RadLFluxCor(:,:,k) = &
   519:             !!$        &   xyr_RadLFlux(:,:,k) &
   520:             !!$        & + (   xy_DSurfTempDt     * xyra_DelRadLFlux(:,:,k,0)   &
   521:             !!$        &     + xyz_DTempDt(:,:,1) * xyra_DelRadLFlux(:,:,k,1) ) &
   522:             !!$        &   * DelTime
   523:             !!$    end do
   524: +------>        do k = 0, kmax
   525: |*V---->A         xyr_RadLUwFluxCor(:,:,k) =                                   &
   526: |||                 &   xyr_RadLUwFlux(:,:,k)                                  &
   527: |||                 & + (   xy_DSurfTempDt     * xyra_DelRadLUwFlux(:,:,k,0)   &
   528: |||                 &     + xyz_DTempDt(:,:,1) * xyra_DelRadLUwFlux(:,:,k,1) ) &
   529: |||                 &   * DelTime
   530: |*V---- A         xyr_RadLDwFluxCor(:,:,k) =                                   &
   531: |                   &   xyr_RadLDwFlux(:,:,k)                                  &
   532: |                   & + (   xy_DSurfTempDt     * xyra_DelRadLDwFlux(:,:,k,0)   &
   533: |                   &     + xyz_DTempDt(:,:,1) * xyra_DelRadLDwFlux(:,:,k,1) ) &
   534: |                   &   * DelTime
   535: +------         end do
   536: W**==== A       xyr_RadLFluxCor = xyr_RadLUwFluxCor - xyr_RadLDwFluxCor
   537:             
   538:             
   539:                 ! ヒストリデータ出力
   540:                 ! History data output
   541:                 !
   542:                 call HistoryAutoPut( TimeN, 'OLR', xyr_RadLFluxCor(:,:,kmax) )
   543:                 call HistoryAutoPut( TimeN, 'SLR', xyr_RadLFluxCor(:,:,0)    )
   544:                 call HistoryAutoPut( TimeN, 'OSR', xyr_RadSFlux   (:,:,kmax) )
   545:                 call HistoryAutoPut( TimeN, 'SSR', xyr_RadSFlux   (:,:,0)    )
   546:                 call HistoryAutoPut( TimeN, 'ISR', xyr_RadSDwFlux (:,:,kmax) )
   547:                 call HistoryAutoPut( TimeN, 'RadLUWFLX', xyr_RadLUwFluxCor )
   548:                 call HistoryAutoPut( TimeN, 'RadLDWFLX', xyr_RadLDwFluxCor )
   549:                 call HistoryAutoPut( TimeN, 'RadSUWFLX', xyr_RadSUwFlux    )
   550:                 call HistoryAutoPut( TimeN, 'RadSDWFLX', xyr_RadSDwFlux    )
   551:             
   552:             
   553:                 ! ヒストリデータ出力
   554:                 ! History data output
   555:                 !
   556:                 call HistoryAutoPut( TimeN, 'OLRB', xyr_RadLFlux(:,:,kmax) )
   557:                 call HistoryAutoPut( TimeN, 'SLRB', xyr_RadLFlux(:,:,0)    )
   558:                 call HistoryAutoPut( TimeN, 'OSRB', xyr_RadSFlux(:,:,kmax) )
   559:                 call HistoryAutoPut( TimeN, 'SSRB', xyr_RadSFlux(:,:,0)    )
   560:                 call HistoryAutoPut( TimeN, 'ISRB', xyr_RadSDwFlux(:,:,kmax) )
   561:                 call HistoryAutoPut( TimeN, 'RadLUWFLXB', xyr_RadLUwFlux )
   562:                 call HistoryAutoPut( TimeN, 'RadLDWFLXB', xyr_RadLDwFlux )
   563:                 call HistoryAutoPut( TimeN, 'RadSUWFLXB', xyr_RadSUwFlux )
   564:                 call HistoryAutoPut( TimeN, 'RadSDWFLXB', xyr_RadSDwFlux )
   565:             
   566:             
   567:                 ! 長波フラックスの補正 ( 地表フラックス分の補正 )
   568:                 ! Correct longwave flux ( amount of surface flux )
   569:                 !
   570:                 ! Lines commented out below will be deleted soon (yot, 2010/10/31).
   571:             !!$    do k = 0, kmax
   572:             !!$      xyr_RadLFluxCor (:,:,k) = &
   573:             !!$        &     xyr_RadLFlux (:,:,k) &
   574:             !!$        &   + xyra_DelRadLFlux(:,:,k,0) * xy_DSurfTempDt (:,:) * 2.0d0 * DelTime
   575:             !!$    end do
   576:             !!$    do k = 0, kmax
   577:             !!$      xyr_RadLFluxCor(:,:,k) = &
   578:             !!$        &   xyr_RadLFlux(:,:,k) &
   579:             !!$        & + (   xy_DSurfTempDt     * xyra_DelRadLFlux(:,:,k,0)   &
   580:             !!$        &     + xyz_DTempDt(:,:,1) * xyra_DelRadLFlux(:,:,k,1) ) &
   581:             !!$        &   * 2.0_DP * DelTime
   582:             !!$    end do
   583: +------>        do k = 0, kmax
   584: |*V---->A         xyr_RadLUwFluxCor(:,:,k) =                                   &
   585: |||                 &   xyr_RadLUwFlux(:,:,k)                                  &
   586: |||                 & + (   xy_DSurfTempDt     * xyra_DelRadLUwFlux(:,:,k,0)   &
   587: |||                 &     + xyz_DTempDt(:,:,1) * xyra_DelRadLUwFlux(:,:,k,1) ) &
   588: |||                 &   * 2.0_DP * DelTime
   589: |*V---- A         xyr_RadLDwFluxCor(:,:,k) =                                   &
   590: |                   &   xyr_RadLDwFlux(:,:,k)                                  &
   591: |                   & + (   xy_DSurfTempDt     * xyra_DelRadLDwFlux(:,:,k,0)   &
   592: |                   &     + xyz_DTempDt(:,:,1) * xyra_DelRadLDwFlux(:,:,k,1) ) &
   593: |                   &   * 2.0_DP * DelTime
   594: +------         end do
   595: W**==== A       xyr_RadLFluxCor = xyr_RadLUwFluxCor - xyr_RadLDwFluxCor
   596:             
   597:             
   598:                 ! ヒストリデータ出力
   599:                 ! History data output
   600:                 !
   601:                 call HistoryAutoPut( TimeN, 'OLRA', xyr_RadLFluxCor(:,:,kmax) )
   602:                 call HistoryAutoPut( TimeN, 'SLRA', xyr_RadLFluxCor(:,:,0)    )
   603:                 call HistoryAutoPut( TimeN, 'OSRA', xyr_RadSFlux   (:,:,kmax) )
   604:                 call HistoryAutoPut( TimeN, 'SSRA', xyr_RadSFlux   (:,:,0)    )
   605:                 call HistoryAutoPut( TimeN, 'ISRA', xyr_RadSDwFlux (:,:,kmax) )
   606:                 call HistoryAutoPut( TimeN, 'RadLUWFLXA', xyr_RadLUwFluxCor )
   607:                 call HistoryAutoPut( TimeN, 'RadLDWFLXA', xyr_RadLDwFluxCor )
   608:                 call HistoryAutoPut( TimeN, 'RadSUWFLXA', xyr_RadSUwFlux    )
   609:                 call HistoryAutoPut( TimeN, 'RadSDWFLXA', xyr_RadSDwFlux    )
   610:             
   611:             
   612:                 ! 計算時間計測一時停止
   613:                 ! Pause measurement of computation time
   614:                 !
   615:                 call TimesetClockStop( module_name )
   616:             
   617:               end subroutine RadFluxOutput
   618:             
   619:               !-------------------------------------------------------------------
   620:             
   621:               subroutine RadUtilsInit
   622:                 !
   623:                 ! rad_utils モジュールの初期化を行います. 
   624:                 ! NAMELIST#rad_utils_nml の読み込みはこの手続きで行われます. 
   625:                 !
   626:                 ! "rad_utils" module is initialized. 
   627:                 ! "NAMELIST#rad_utils_nml" is loaded in this procedure. 
   628:                 !
   629:             
   630:                 ! モジュール引用 ; USE statements
   631:                 !
   632:             
   633:                 ! 文字列操作
   634:                 ! Character handling
   635:                 !
   636:                 use dc_string, only: toChar
   637:             
   638:                 ! ファイル入出力補助
   639:                 ! File I/O support
   640:                 !
   641:                 use dc_iounit, only: FileOpen
   642:             
   643:                 ! ヒストリデータ出力
   644:                 ! History data output
   645:                 !
   646:                 use gtool_historyauto, only: HistoryAutoAddVariable
   647:             
   648:                 ! NAMELIST ファイル入力に関するユーティリティ
   649:                 ! Utilities for NAMELIST file input
   650:                 !
   651:                 use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid
   652:             
   653:                 ! 宣言文 ; Declaration statements
   654:                 !
   655:             
   656:                 integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号. 
   657:                                           ! Unit number for NAMELIST file open
   658:                 integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT. 
   659:                                           ! IOSTAT of NAMELIST read
   660:             
   661:             
   662:                 ! NAMELIST 変数群
   663:                 ! NAMELIST group name
   664:                 !
   665:             !!$    namelist /rad_utils_nml/ &
   666:             !!$      & DiffFact
   667:             !!$      & DelTimeLongValue, DelTimeLongUnit, &
   668:             !!$      & DelTimeShortValue, DelTimeShortUnit, &
   669:             !!$!
   670:             !!$      & LongBandNum, &
   671:             !!$      & LongAbsorpCoefQVap, LongAbsorpCoefDryAir, &
   672:             !!$      & LongBandWeight, LongPathLengthFact, &
   673:             !!$!
   674:             !!$      & ShortBandNum, &
   675:             !!$      & ShortAbsorpCoefQVap, ShortAbsorpCoefDryAir, &
   676:             !!$      & ShortBandWeight, ShortSecScat, &
   677:             !!$      & ShortAtmosAlbedo, &
   678:             !!$!
   679:             !!$      & RstInputFile, RstOutputFile
   680:                       !
   681:                       ! デフォルト値については初期化手続 "rad_utils#RadInit" 
   682:                       ! のソースコードを参照のこと. 
   683:                       !
   684:                       ! Refer to source codes in the initialization procedure
   685:                       ! "rad_utils#RadInit" for the default values. 
   686:                       !
   687:             
   688:                 ! 実行文 ; Executable statement
   689:                 !
   690:             
   691:                 if ( rad_utils_inited ) return
   692:             
   693:             
   694:                 ! デフォルト値の設定
   695:                 ! Default values settings
   696:                 !
   697:             
   698:                 ! NAMELIST の読み込み
   699:                 ! NAMELIST is input
   700:                 !
   701:             !!$    if ( trim(namelist_filename) /= '' ) then
   702:             !!$      call FileOpen( unit_nml, &          ! (out)
   703:             !!$        & namelist_filename, mode = 'r' ) ! (in)
   704:             !!$
   705:             !!$      rewind( unit_nml )
   706:             !!$      read( unit_nml,                     & ! (in)
   707:             !!$        & nml = rad_utils_nml,            & ! (out)
   708:             !!$        & iostat = iostat_nml )             ! (out)
   709:             !!$      close( unit_nml )
   710:             !!$
   711:             !!$      call NmlutilMsg( iostat_nml, module_name ) ! (in)
   712:             !!$    end if
   713:             
   714:             
   715:                 ! ヒストリデータ出力のためのへの変数登録
   716:                 ! Register of variables for history data output
   717:                 !
   718:                 call HistoryAutoAddVariable( 'OLR', &
   719:                   & (/ 'lon ', 'lat ', 'time' /), &
   720:                   & 'outgoing longwave', 'W m-2' )
   721:                 call HistoryAutoAddVariable( 'SLR', &
   722:                   & (/ 'lon ', 'lat ', 'time' /), &
   723:                   & 'surface longwave', 'W m-2' )
   724:                 call HistoryAutoAddVariable( 'OSR', &
   725:                   & (/ 'lon ', 'lat ', 'time' /), &
   726:                   & 'outgoing shortwave', 'W m-2' )
   727:                 call HistoryAutoAddVariable( 'SSR', &
   728:                   & (/ 'lon ', 'lat ', 'time' /), &
   729:                   & 'surface shortwave', 'W m-2' )
   730:             
   731:                 call HistoryAutoAddVariable( 'ISR' , &
   732:                   & (/ 'lon ', 'lat ', 'time'/),     &
   733:                   & 'incoming shortwave', 'W m-2' )
   734:             
   735:                 call HistoryAutoAddVariable( 'RadLUWFLX', &
   736:                   & (/ 'lon ', 'lat ', 'sigm', 'time' /), &
   737:                   & 'upward longwave flux', 'W m-2' )
   738:                 call HistoryAutoAddVariable( 'RadLDWFLX', &
   739:                   & (/ 'lon ', 'lat ', 'sigm', 'time' /), &
   740:                   & 'downward longwave flux', 'W m-2' )
   741:                 call HistoryAutoAddVariable( 'RadSUWFLX', &
   742:                   & (/ 'lon ', 'lat ', 'sigm', 'time' /), &
   743:                   & 'upward shortwave flux', 'W m-2' )
   744:                 call HistoryAutoAddVariable( 'RadSDWFLX', &
   745:                   & (/ 'lon ', 'lat ', 'sigm', 'time' /), &
   746:                   & 'downward shortwave flux', 'W m-2' )
   747:             
   748:                 call HistoryAutoAddVariable( 'OLRB', &
   749:                   & (/ 'lon ', 'lat ', 'time' /), &
   750:                   & 'outgoing longwave', 'W m-2' )
   751:                 call HistoryAutoAddVariable( 'SLRB', &
   752:                   & (/ 'lon ', 'lat ', 'time' /), &
   753:                   & 'surface longwave', 'W m-2' )
   754:                 call HistoryAutoAddVariable( 'OSRB', &
   755:                   & (/ 'lon ', 'lat ', 'time' /), &
   756:                   & 'outgoing shortwave', 'W m-2' )
   757:                 call HistoryAutoAddVariable( 'SSRB', &
   758:                   & (/ 'lon ', 'lat ', 'time' /), &
   759:                   & 'surface shortwave', 'W m-2' )
   760:             
   761:                 call HistoryAutoAddVariable( 'ISRB' , &
   762:                   & (/ 'lon ', 'lat ', 'time'/),     &
   763:                   & 'incoming shortwave', 'W m-2' )
   764:             
   765:                 call HistoryAutoAddVariable( 'RadLUWFLXB', &
   766:                   & (/ 'lon ', 'lat ', 'sigm', 'time' /), &
   767:                   & 'upward longwave flux', 'W m-2' )
   768:                 call HistoryAutoAddVariable( 'RadLDWFLXB', &
   769:                   & (/ 'lon ', 'lat ', 'sigm', 'time' /), &
   770:                   & 'downward longwave flux', 'W m-2' )
   771:                 call HistoryAutoAddVariable( 'RadSUWFLXB', &
   772:                   & (/ 'lon ', 'lat ', 'sigm', 'time' /), &
   773:                   & 'upward shortwave flux', 'W m-2' )
   774:                 call HistoryAutoAddVariable( 'RadSDWFLXB', &
   775:                   & (/ 'lon ', 'lat ', 'sigm', 'time' /), &
   776:                   & 'downward shortwave flux', 'W m-2' )
   777:             
   778:                 call HistoryAutoAddVariable( 'OLRA', &
   779:                   & (/ 'lon ', 'lat ', 'time' /), &
   780:                   & 'outgoing longwave', 'W m-2' )
   781:                 call HistoryAutoAddVariable( 'SLRA', &
   782:                   & (/ 'lon ', 'lat ', 'time' /), &
   783:                   & 'surface longwave', 'W m-2' )
   784:                 call HistoryAutoAddVariable( 'OSRA', &
   785:                   & (/ 'lon ', 'lat ', 'time' /), &
   786:                   & 'outgoing shortwave', 'W m-2' )
   787:                 call HistoryAutoAddVariable( 'SSRA', &
   788:                   & (/ 'lon ', 'lat ', 'time' /), &
   789:                   & 'surface shortwave', 'W m-2' )
   790:             
   791:                 call HistoryAutoAddVariable( 'ISRA' , &
   792:                   & (/ 'lon ', 'lat ', 'time'/),     &
   793:                   & 'incoming shortwave', 'W m-2' )
   794:             
   795:                 call HistoryAutoAddVariable( 'RadLUWFLXA', &
   796:                   & (/ 'lon ', 'lat ', 'sigm', 'time' /), &
   797:                   & 'upward longwave flux', 'W m-2' )
   798:                 call HistoryAutoAddVariable( 'RadLDWFLXA', &
   799:                   & (/ 'lon ', 'lat ', 'sigm', 'time' /), &
   800:                   & 'downward longwave flux', 'W m-2' )
   801:                 call HistoryAutoAddVariable( 'RadSUWFLXA', &
   802:                   & (/ 'lon ', 'lat ', 'sigm', 'time' /), &
   803:                   & 'upward shortwave flux', 'W m-2' )
   804:                 call HistoryAutoAddVariable( 'RadSDWFLXA', &
   805:                   & (/ 'lon ', 'lat ', 'sigm', 'time' /), &
   806:                   & 'downward shortwave flux', 'W m-2' )
   807:             
   808:                 call HistoryAutoAddVariable( 'DTempDtRadL', &
   809:                   & (/ 'lon ', 'lat ', 'sig ', 'time' /), &
   810:                   & 'long wave radiative heating rate', 'K s-1' )
   811:                 call HistoryAutoAddVariable( 'DTempDtRadS', &
   812:                   & (/ 'lon ', 'lat ', 'sig ', 'time' /), &
   813:                   & 'short wave radiative heating rate', 'K s-1' )
   814:             
   815:             
   816:                 ! 印字 ; Print
   817:                 !
   818:                 call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   819:             !!$    call MessageNotify( 'M', module_name, 'DiffFact = %f', d = (/ DiffFact /) )
   820:                 call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   821:             
   822:                 rad_utils_inited = .true.
   823:             
   824:               end subroutine RadUtilsInit
   825:             
   826:               !-------------------------------------------------------------------
   827:             
   828:             end module rad_utils
