Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:59 2016
FILE NAME: set_Mars_dust.f90
PROGRAM NAME: set_mars_dust
DIAGNOSTIC LIST

  LINE  LEVEL( NO.): DIAGNOSTIC MESSAGE

   180  opt  (1593): Loop nest collapsed into one loop.
   180  vec  (   1): Vectorized loop.
   180  vec  (  29): ADB is used for array.: xyr_press
   180  vec  (  29): ADB is used for array.: xyz_qdust
   188  opt  (1593): Loop nest collapsed into one loop.
   188  vec  (   4): Vectorized array expression.
   188  vec  (  29): ADB is used for array.: xyr_dod067
   189  vec  (   3): Unvectorized loop.
   189  vec  (  13): Overhead of loop division is too large.
   190  opt  (1037): Feedback of array elements.
   190  opt  (1593): Loop nest collapsed into one loop.
   190  vec  (   4): Vectorized array expression.
   190  vec  (  29): ADB is used for array.: xyr_dod067
   297  opt  (  11): Fused array assignments. :line 297 - 300
   297  opt  (1592): Outer loop unrolled inside inner loop.
   297  vec  (   4): Vectorized array expression.
   297  vec  (  29): ADB is used for array.: xy_maxheightdust
   297  vec  (  29): ADB is used for array.: xy_dod067
   297  vec  (   4): Vectorized array expression.
   297  vec  (  29): ADB is used for array.: xy_maxheightdust
   297  vec  (  29): ADB is used for array.: xy_dod067
   308  opt  (1593): Loop nest collapsed into one loop.
   308  vec  (   4): Vectorized array expression.
   308  vec  (  29): ADB is used for array.: xy_dod067
   313  opt  (1592): Outer loop unrolled inside inner loop.
   313  vec  (   3): Unvectorized loop.
   313  vec  (  13): Overhead of loop division is too large.
   313  vec  (   3): Unvectorized loop.
   313  vec  (  13): Overhead of loop division is too large.
   314  vec  (   4): Vectorized array expression.
   314  vec  (  29): ADB is used for array.: d1
   314  vec  (   4): Vectorized array expression.
   314  vec  (  29): ADB is used for array.: xy_maxheightdust
   314  vec  (  29): ADB is used for array.: d1
   314  vec  (   4): Vectorized array expression.
   314  vec  (  29): ADB is used for array.: xy_maxheightdust
   314  vec  (  29): ADB is used for array.: d1
   326  opt  (1593): Loop nest collapsed into one loop.
   326  vec  (   4): Vectorized array expression.
   326  vec  (  29): ADB is used for array.: xy_dod067
   331  opt  (1592): Outer loop unrolled inside inner loop.
   331  vec  (   3): Unvectorized loop.
   331  vec  (  13): Overhead of loop division is too large.
   331  vec  (   3): Unvectorized loop.
   331  vec  (  13): Overhead of loop division is too large.
   332  vec  (   4): Vectorized array expression.
   332  vec  (  29): ADB is used for array.: d4
   332  vec  (   4): Vectorized array expression.
   332  vec  (  29): ADB is used for array.: xy_maxheightdust
   332  vec  (  29): ADB is used for array.: d4
   332  vec  (   4): Vectorized array expression.
   332  vec  (  29): ADB is used for array.: xy_maxheightdust
   332  vec  (  29): ADB is used for array.: d4
   365  vec  (   3): Unvectorized loop.
   365  vec  (  13): Overhead of loop division is too large.
   366  opt  (1593): Loop nest collapsed into one loop.
   366  vec  (   4): Vectorized array expression.
   366  vec  (  29): ADB is used for array.: xyz_mixrtdust
   366  vec  (  29): ADB is used for array.: xy_maxheightdust
   366  vec  (  29): ADB is used for array.: xyz_press
   371  opt  (1593): Loop nest collapsed into one loop.
   371  vec  (   4): Vectorized array expression.
   371  vec  (  29): ADB is used for array.: xyz_mixrtdust
   375  opt  (1593): Loop nest collapsed into one loop.
   375  vec  (   4): Vectorized array expression.
   375  vec  (  29): ADB is used for array.: xyr_dod067
   376  vec  (   3): Unvectorized loop.
   376  vec  (  13): Overhead of loop division is too large.
   377  opt  (1037): Feedback of array elements.
   377  opt  (1593): Loop nest collapsed into one loop.
   377  vec  (   4): Vectorized array expression.
   377  vec  (  29): ADB is used for array.: xyr_dod067
   377  vec  (  29): ADB is used for array.: xyr_press
   377  vec  (  29): ADB is used for array.: xyz_mixrtdust
   381  opt  (1593): Loop nest collapsed into one loop.
   381  vec  (   4): Vectorized array expression.
   381  vec  (  29): ADB is used for array.: xyr_dod067
   381  vec  (  29): ADB is used for array.: xyr_press
   381  vec  (  29): ADB is used for array.: xy_dod067
   382  vec  (   3): Unvectorized loop.
   382  vec  (  13): Overhead of loop division is too large.
   383  opt  (1593): Loop nest collapsed into one loop.
   383  vec  (   4): Vectorized array expression.
   383  vec  (  29): ADB is used for array.: xyr_dod067
   383  vec  (  29): ADB is used for array.: xy_dodfac
   514  vec  (   3): Unvectorized loop.
   514  vec  (  13): Overhead of loop division is too large.
   521  vec  (   4): Vectorized array expression.
   521  vec  (  29): ADB is used for array.: xy_dod
   529  vec  (   4): Vectorized array expression.
   529  vec  (  29): ADB is used for array.: xy_dod
   534  opt  (  11): Fused array assignments. :line 534 - 539
   534  vec  (   4): Vectorized array expression.
   534  vec  (  29): ADB is used for array.: xy_maxheight
   768  vec  (   1): Vectorized loop.
   768  vec  (  29): ADB is used for array.: xy_dod
   768  vec  (  29): ADB is used for array.: x_lon
   777  vec  (   4): Vectorized array expression.
   777  vec  (  29): ADB is used for array.: xy_dod
   781  opt  (1593): Loop nest collapsed into one loop.
   781  vec  (   4): Vectorized array expression.
   781  vec  (  29): ADB is used for array.: xy_dod
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:59 2016
FILE NAME: set_Mars_dust.f90
PROGRAM NAME: set_mars_dust
TRANSFORMATION LIST

  LINE                   FORTRAN STATEMENT

     1  !=
     2  !
     3  != Dust distribution is set
     4  !
     5  ! Authors::   Yoshiyuki O. Takahashi
     6  ! Version::   $Id: set_Mars_dust.f90,v 1.13 2013/09/21 14:40:52 yot Exp $
     7  ! Tag Name::  $Name:  $
     8  ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9  ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10  !
    11  module set_Mars_dust
    12    !
    13    !=
    14    !
    15    != Dust distribution is set
    16    !
    17    ! <b>Note that Japanese and English are described in parallel.</b>
    18    !
    19    !
    20    !
    21    !
    22    !
    23    !
    24    !== References
    25    !
    26    !  Lewis, S. R., Collins, M., Forget, F.,
    27    !    Mars climate database v3.0 detailed design document,
    28    !    Technical Note. Contract 11369/95/NL/JG. Work Package 7, ESA, 2001.
    29    !
    30    !== Procedures List
    31    !
    32  !!$  ! RadiationFluxDennouAGCM :: 放射フラックスの計算
    33  !!$  ! RadiationDTempDt        :: 放射フラックスによる温度変化の計算
    34  !!$  ! RadiationFluxOutput     :: 放射フラックスの出力
    35  !!$  ! RadiationFinalize       :: 終了処理 (モジュール内部の変数の割り付け解除)
    36  !!$  ! ------------            :: ------------
    37  !!$  ! RadiationFluxDennouAGCM :: Calculate radiation flux
    38  !!$  ! RadiationDTempDt        :: Calculate temperature tendency with radiation flux
    39  !!$  ! RadiationFluxOutput     :: Output radiation fluxes
    40  !!$  ! RadiationFinalize       :: Termination (deallocate variables in this module)
    41    !
    42    !== NAMELIST
    43    !
    44  !!$  ! NAMELIST#radiation_DennouAGCM_nml
    45    !
    46  
    47    ! USE statements
    48    !
    49  
    50    !
    51    ! Kind type parameter
    52    !
    53    use dc_types, only: DP, &      ! Double precision.
    54      &                 STRING, &  ! Strings.
    55      &                 TOKEN      ! Keywords.
    56  
    57    ! 格子点設定
    58    ! Grid points settings
    59    !
    60    use gridset, only: imax, & ! 経度格子点数.
    61                               ! Number of grid points in longitude
    62      &                jmax, & ! 緯度格子点数.
    63                               ! Number of grid points in latitude
    64      &                kmax    ! 鉛直層数.
    65                               ! Number of vertical level
    66  
    67    implicit none
    68  
    69    private
    70  
    71  
    72    ! 公開変数
    73    ! Public variables
    74    !
    75    logical, save, public:: set_Mars_dust_inited = .false.
    76                                ! 初期設定フラグ.
    77                                ! Initialization flag
    78  
    79    ! Private variables
    80    !
    81    real(DP), save :: DustExtEff
    82    real(DP), save :: REff
    83    real(DP), save :: RhoDust
    84  
    85  
    86    character(STRING), save :: DustScenario
    87    real(DP)         , save :: DOD067       ! Dust optical depth at 0.67 micron.
    88    real(DP)         , save :: DustVerDistCoef
    89  
    90    real(DP)         , save :: DustOptDepRefPress
    91    real(DP)         , save :: DustVerDistRefPress
    92  
    93    integer          , save      :: IDDustScenario
    94    integer          , parameter :: IDDustScenarioConst          = 1
    95    integer          , parameter :: IDDustScenarioVikingNoDS     = 2
    96    integer          , parameter :: IDDustScenarioViking         = 3
    97    integer          , parameter :: IDDustScenarioMGS            = 4
    98    integer          , parameter :: IDDustScenarioMGSDODFromFile = 5
    99  
   100    character(STRING), save      :: DODFileName
   101    character(STRING), save      :: DODVarName
   102  
   103    public :: SetMarsDustCalcDOD067
   104    public :: SetMarsDustSetDOD067
   105    public :: SetMarsDustInit
   106  
   107    character(*), parameter:: module_name = 'set_Mars_dust'
   108                                ! モジュールの名称.
   109                                ! Module name
   110    character(*), parameter:: version = &
   111      & '$Name:  $' // &
   112      & '$Id: set_Mars_dust.f90,v 1.13 2013/09/21 14:40:52 yot Exp $'
   113                                ! モジュールのバージョン
   114                                ! Module version
   115  
   116    !--------------------------------------------------------------------------------------
   117  
   118  contains
   119  
   120    !--------------------------------------------------------------------------------------
   121  
   122    subroutine SetMarsDustCalcDOD067( &
   123      & xyr_Press, xyz_QDust,         & ! (in)
   124      & xyr_DOD067                    & ! (out)
   125      & )
   126      !
   127      !
   128      !
   129      ! Calculate dust optical depth at 0.67 micron
   130      !
   131  
   132      ! モジュール引用 ; USE statements
   133      !
   134  
   135      ! メッセージ出力
   136      ! Message output
   137      !
   138      use dc_message, only: MessageNotify
   139  
   140      ! ヒストリデータ出力
   141      ! History data output
   142      !
   143      use gtool_historyauto, only: HistoryAutoPut
   144  
   145      ! 物理定数設定
   146      ! Physical constants settings
   147      !
   148      use constants, only: Grav
   149  
   150  
   151      ! 宣言文 ; Declaration statements
   152      !
   153  
   154      real(DP), intent(in ):: xyr_Press (0:imax-1, 1:jmax, 0:kmax)
   155                                ! Pressure
   156      real(DP), intent(in ):: xyz_QDust (0:imax-1, 1:jmax, 1:kmax)
   157                                ! Dust mixing ratio
   158      real(DP), intent(out):: xyr_DOD067(0:imax-1, 1:jmax, 0:kmax)
   159                                ! Optical depth
   160  
   161      ! 作業変数
   162      ! Work variables
   163      !
   164      real(DP)            :: xyz_DelDOD(0:imax-1, 1:jmax, 1:kmax)
   165  
   166      integer :: k             ! 鉛直方向に回る DO ループ用作業変数
   167                               ! Work variables for DO loop in vertical direction
   168  
   169      ! 実行文 ; Executable statement
   170      !
   171  
   172      ! 初期化
   173      ! Initialization
   174      !
   175      if ( .not. set_Mars_dust_inited ) then
   176        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   177      end if
   178  
   179  
   180      do k = 1, kmax
   181        xyz_DelDOD(:,:,k) =                                            &
   182          &   3.0_DP / 4.0_DP * DustExtEff / ( REff * RhoDust * Grav ) &
   183          & * xyz_QDust(:,:,k)                                         &
   184          & * ( xyr_Press(:,:,k-1) - xyr_Press(:,:,k) )
   185      end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do k = 1, kmax*jmax*imax                                          
     .           xyz_deldod(k-1,1,1) = 7.50000000000000e-001*dustexteff/(reff*  
     .       1      rhodust*grav)*xyz_qdust(k-1,1,1)*(xyr_press(k-1,1,0)-       
     .       2      xyr_press(k-1,1,1))                                         
     .        enddo                                                             
   186  
   187      k = kmax
   188      xyr_DOD067(:,:,k) = 0.0_DP
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t121 = 1, jmax*imax                                            
     .           xyr_dod067(t121-1,1,k) = 0.0000000000000000e+000               
     .        enddo                                                             
   189      do k = kmax-1, 0, -1
   190        xyr_DOD067(:,:,k) = xyr_DOD067(:,:,k+1) + xyz_DelDOD(:,:,k+1)
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t127 = 1, jmax*imax                                            
     .           xyr_dod067(t127-1,1,k) = xyr_dod067(t127-1,1,k+1) + xyz_deldod(
     .       1      t127-1,1,k+1)                                               
     .        enddo                                                             
   191      end do
   192  
   193  
   194      ! ヒストリデータ出力
   195      ! History data output
   196      !
   197  
   198  
   199    end subroutine SetMarsDustCalcDOD067
   200  
   201    !--------------------------------------------------------------------------------------
   202  
   203    subroutine SetMarsDustSetDOD067( &
   204      & Ls, xyr_Press, xyz_Press,    & ! (out) optional & ! (in)
   205      & xyr_DOD067                   & ! (out)
   206      & )
   207      !
   208      !
   209      !
   210      ! Set dust optical depth at 0.67 micron
   211      !
   212  
   213      ! モジュール引用 ; USE statements
   214      !
   215  
   216      ! メッセージ出力
   217      ! Message output
   218      !
   219      use dc_message, only: MessageNotify
   220  
   221      ! ヒストリデータ出力
   222      ! History data output
   223      !
   224      use gtool_historyauto, only: HistoryAutoPut
   225  
   226      ! 時刻管理
   227      ! Time control
   228      !
   229      use timeset, only: &
   230        & TimeN
   231  
   232      ! 物理・数学定数設定
   233      ! Physical and mathematical constants settings
   234      !
   235      use constants0, only: &
   236        & PI                    ! $ \pi $.
   237                                ! 円周率. Circular constant
   238  
   239      ! 物理定数設定
   240      ! Physical constants settings
   241      !
   242      use constants, only: Grav
   243  
   244      ! 座標データ設定
   245      ! Axes data settings
   246      !
   247      use axesset, only: &
   248        & y_Lat    ! $ \varphi $ [rad.] . 緯度. Latitude
   249  
   250      ! 時系列データの読み込み
   251      ! Reading time series
   252      !
   253      use read_time_series, only: SetValuesFromTimeSeriesWrapper
   254  
   255  
   256      ! 宣言文 ; Declaration statements
   257      !
   258  
   259      real(DP), intent(in ):: Ls
   260                                ! Ls
   261      real(DP), intent(in ):: xyr_Press    (0:imax-1, 1:jmax, 0:kmax)
   262                                ! Pressure
   263      real(DP), intent(in ):: xyz_Press    (0:imax-1, 1:jmax, 1:kmax)
   264                                ! Pressure
   265      real(DP), intent(out):: xyr_DOD067   (0:imax-1, 1:jmax, 0:kmax)
   266                                ! Optical depth
   267  
   268      ! 作業変数
   269      ! Work variables
   270      !
   271      real(DP)            :: DOD
   272      real(DP)            :: xy_DOD067       (0:imax-1, 1:jmax)
   273                                ! Dust optical depth at 0.67 micron
   274      real(DP)            :: xyz_MixRtDust   (0:imax-1, 1:jmax, 1:kmax)
   275      real(DP)            :: xy_DODFac       (0:imax-1, 1:jmax)
   276      real(DP)            :: xy_MaxHeightDust(0:imax-1, 1:jmax)
   277  
   278      real(DP)            :: MixRtDust0
   279  
   280      integer :: j
   281      integer :: k             ! 鉛直方向に回る DO ループ用作業変数
   282                               ! Work variables for DO loop in vertical direction
   283  
   284      ! 実行文 ; Executable statement
   285      !
   286  
   287      ! 初期化
   288      ! Initialization
   289      !
   290      if ( .not. set_Mars_dust_inited ) then
   291        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   292      end if
   293  
   294  
   295      select case ( IDDustScenario )
   296      case ( IDDustScenarioConst )
   297        xy_DOD067 = DOD067
     .        if (xy_dod067.DSC.U2 .gt. 0) then                                 
     .           j1 = and(xy_dod067.DSC.U2,3)                                   
     .  !cdir    nodep                                                          
     .           do t366 = 1, j1                                                
     .  !cdir       nodep                                                       
     .              do t368=1,xy_dod067.DSC.U1+2-min0(1,xy_dod067.DSC.U1+1)     
     .                 xy_dod067(t368-1,t366) = dod067                          
     .                 xy_maxheightdust(t368-1,t366) = 7.00000000000000e+004    
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t366 = j1 + 1, xy_dod067.DSC.U2, 4                          
     .  !cdir       nodep                                                       
     .              do t368=1,xy_dod067.DSC.U1+2-min0(1,xy_dod067.DSC.U1+1)     
     .                 xy_dod067(t368-1,t366) = dod067                          
     .                 xy_dod067(t368-1,t366+1) = dod067                        
     .                 xy_dod067(t368-1,t366+2) = dod067                        
     .                 xy_dod067(t368-1,t366+3) = dod067                        
     .                 xy_maxheightdust(t368-1,t366) = 7.00000000000000e+004    
     .                 xy_maxheightdust(t368-1,t366+1) = 7.00000000000000e+004  
     .                 xy_maxheightdust(t368-1,t366+2) = 7.00000000000000e+004  
     .                 xy_maxheightdust(t368-1,t366+3) = 7.00000000000000e+004  
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
     .        goto 10008                                                        
   298  
   299        ! Height of dust top
   300        xy_MaxHeightDust = 70.0d3
   301  
   302      case ( IDDustScenarioVikingNoDS )
   303  
   304        call SetMarsDustDODVikingNoDS( &
   305          & Ls, & ! (in)
   306          & DOD & ! (out)
   307          & )
   308        xy_DOD067 = DOD
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t357 = 1, xy_dod067.DSC.U2*xy_dod067.DSC.U1 + xy_dod067.DSC.U2 
     .           xy_dod067(t357-1,1) = dod                                      
     .        enddo                                                             
   309  
   310        ! Height of dust top
   311  !!$      xy_MaxHeightDust = 70.0d3
   312        !
   313        do j = 1, jmax
   314          xy_MaxHeightDust(:,j) =                                 &
   315            &   60.0d3                                            &
   316            & + 18.0d3 * sin( ( Ls - 158.0_DP ) * PI / 180.0_DP ) &
   317            & - 22.0d3 * sin( y_Lat(j) )**2
   318        end do
     .        allocate (d1(1:xy_maxheightdust.DSC.U1+1))                        
     .        d3 = (ls - 1.58000000000000e+002)/1.80000000000000e+002           
     .  !cdir nodep                                                             
     .  !cdir on_adb(d1)                                                        
     .        do t363 = 1, xy_maxheightdust.DSC.U1 + 1                          
     .           d1(t363) = dsin(3.14159265358979e+000*d3)                      
     .        enddo                                                             
     .        if (jmax .gt. 0) then                                             
     .           j2 = and(jmax,3)                                               
     .           do j = 1, j2                                                   
     .  !cdir       nodep                                                       
     .  !cdir       on_adb(d1)                                                  
     .              do t363 = 1, xy_maxheightdust.DSC.U1 + 1                    
     .                 xy_maxheightdust(t363-1,j) = 6.00000000000000e+004 +     
     .       1            1.80000000000000e+004*d1(t363) - 2.20000000000000e+004
     .       2            *dsin(y_lat(j))**2                                    
     .              enddo                                                       
     .           enddo                                                          
     .           do j = j2 + 1, jmax, 4                                         
     .  !cdir       nodep                                                       
     .  !cdir       on_adb(d1)                                                  
     .              do t363 = 1, xy_maxheightdust.DSC.U1 + 1                    
     .                 d2 = d1(t363)                                            
     .                 xy_maxheightdust(t363-1,j) = (6.00000000000000e+004 + (  
     .       1            1.80000000000000e+004*d2)) - 2.20000000000000e+004*   
     .       2            dsin(y_lat(j))**2                                     
     .                 xy_maxheightdust(t363-1,j+1) = (6.00000000000000e+004 + (
     .       1            1.80000000000000e+004*d2)) - 2.20000000000000e+004*   
     .       2            dsin(y_lat(j+1))**2                                   
     .                 xy_maxheightdust(t363-1,j+2) = (6.00000000000000e+004 + (
     .       1            1.80000000000000e+004*d2)) - 2.20000000000000e+004*   
     .       2            dsin(y_lat(j+2))**2                                   
     .                 xy_maxheightdust(t363-1,j+3) = (6.00000000000000e+004 + (
     .       1            1.80000000000000e+004*d2)) - 2.20000000000000e+004*   
     .       2            dsin(y_lat(j+3))**2                                   
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
     .        deallocate (d1)                                                   
     .        goto 10008                                                        
   319  
   320      case ( IDDustScenarioViking )
   321  
   322        call SetMarsDustDODViking( &
   323          & Ls, & ! (in)
   324          & DOD & ! (out)
   325          & )
   326        xy_DOD067 = DOD
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t348 = 1, xy_dod067.DSC.U2*xy_dod067.DSC.U1 + xy_dod067.DSC.U2 
     .           xy_dod067(t348-1,1) = dod                                      
     .        enddo                                                             
   327  
   328        ! Height of dust top
   329  !!$      xy_MaxHeightDust = 70.0d3
   330        !
   331        do j = 1, jmax
   332          xy_MaxHeightDust(:,j) =                                 &
   333            &   60.0d3                                            &
   334            & + 18.0d3 * sin( ( Ls - 158.0_DP ) * PI / 180.0_DP ) &
   335            & - 22.0d3 * sin( y_Lat(j) )**2
   336        end do
     .        allocate (d4(1:xy_maxheightdust.DSC.U1+1))                        
     .        d6 = (ls - 1.58000000000000e+002)/1.80000000000000e+002           
     .  !cdir nodep                                                             
     .  !cdir on_adb(d4)                                                        
     .        do t354 = 1, xy_maxheightdust.DSC.U1 + 1                          
     .           d4(t354) = dsin(3.14159265358979e+000*d6)                      
     .        enddo                                                             
     .        if (jmax .gt. 0) then                                             
     .           j3 = and(jmax,3)                                               
     .           do j = 1, j3                                                   
     .  !cdir       nodep                                                       
     .  !cdir       on_adb(d4)                                                  
     .              do t354 = 1, xy_maxheightdust.DSC.U1 + 1                    
     .                 xy_maxheightdust(t354-1,j) = 6.00000000000000e+004 +     
     .       1            1.80000000000000e+004*d4(t354) - 2.20000000000000e+004
     .       2            *dsin(y_lat(j))**2                                    
     .              enddo                                                       
     .           enddo                                                          
     .           do j = j3 + 1, jmax, 4                                         
     .  !cdir       nodep                                                       
     .  !cdir       on_adb(d4)                                                  
     .              do t354 = 1, xy_maxheightdust.DSC.U1 + 1                    
     .                 d5 = d4(t354)                                            
     .                 xy_maxheightdust(t354-1,j) = (6.00000000000000e+004 + (  
     .       1            1.80000000000000e+004*d5)) - 2.20000000000000e+004*   
     .       2            dsin(y_lat(j))**2                                     
     .                 xy_maxheightdust(t354-1,j+1) = (6.00000000000000e+004 + (
     .       1            1.80000000000000e+004*d5)) - 2.20000000000000e+004*   
     .       2            dsin(y_lat(j+1))**2                                   
     .                 xy_maxheightdust(t354-1,j+2) = (6.00000000000000e+004 + (
     .       1            1.80000000000000e+004*d5)) - 2.20000000000000e+004*   
     .       2            dsin(y_lat(j+2))**2                                   
     .                 xy_maxheightdust(t354-1,j+3) = (6.00000000000000e+004 + (
     .       1            1.80000000000000e+004*d5)) - 2.20000000000000e+004*   
     .       2            dsin(y_lat(j+3))**2                                   
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
     .        deallocate (d4)                                                   
     .        goto 10008                                                        
   337  
   338      case ( IDDustScenarioMGS )
   339  
   340        call SetMarsDustDODMGS(          &
   341          & Ls,                          &
   342          & xy_DOD067, xy_MaxHeightDust  &
   343          & )
   344  
   345      case ( IDDustScenarioMGSDODFromFile )
   346  
   347        call SetMarsDustDODMGS(          &
   348          & Ls,                          &
   349          & xy_DOD067, xy_MaxHeightDust  &
   350          & )
   351  
   352        call SetValuesFromTimeSeriesWrapper( &
   353          & 'DOD',                   &
   354          & DODFileName, DODVarName, &
   355          & xy_DOD067                &               ! (inout)
   356          & )
   357  
   358      case default
   359        call MessageNotify( 'E', module_name, 'DustScenario of %c is not supported.', c1 = trim( DustScenario ) )
   360      end select
   361  
   362  
   363      MixRtDust0      =   1.0_DP
   364  
   365      do k = 1, kmax
   366        xyz_MixRtDust(:,:,k) = MixRtDust0 &
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xy_maxheightdust)                                          
     .        do t284 = 1, jmax*imax                                            
     .           xyz_mixrtdust(t284-1,1,k) = mixrtdust0*dexp(dustverdistcoef*(  
     .       1      1.00000000000000e+000 - (dustverdistrefpress/xyz_press(t284-
     .       2      1,1,k))**(7.00000000000000e+004/xy_maxheightdust(t284-1,1)))
     .       3      )                                                           
     .        enddo                                                             
   367          & * exp( DustVerDistCoef        &
   368          &        * ( 1.0_DP - ( DustVerDistRefPress / xyz_Press(:,:,k) )**(70.0d3/xy_MaxHeightDust) ) &
   369          &      )
   370      end do
   371      xyz_MixRtDust = min( xyz_MixRtDust, MixRtDust0 )
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t294 = 1, xyz_mixrtdust.DSC.U3*(xyz_mixrtdust.DSC.U2*          
     .       1   xyz_mixrtdust.DSC.U1 + xyz_mixrtdust.DSC.U2)                   
     .           xyz_mixrtdust(t294-1,1,1) = min(xyz_mixrtdust(t294-1,1,1),     
     .       1      mixrtdust0)                                                 
     .        enddo                                                             
   372  
   373  
   374      k = kmax
   375      xyr_DOD067(:,:,k) = 0.0_DP
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t306 = 1, jmax*imax                                            
     .           xyr_dod067(t306-1,1,k) = 0.0000000000000000e+000               
     .        enddo                                                             
   376      do k = kmax-1, 0, -1
   377        xyr_DOD067(:,:,k) = xyr_DOD067(:,:,k+1) &
     .        d7 = 1.D0/grav                                                    
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t312 = 1, jmax*imax                                            
     .           xyr_dod067(t312-1,1,k) = xyr_dod067(t312-1,1,k+1) +            
     .       1      xyz_mixrtdust(t312-1,1,k+1)*(xyr_press(t312-1,1,k)-xyr_press
     .       2      (t312-1,1,k+1))*d7                                          
     .        enddo                                                             
   378          & + xyz_MixRtDust(:,:,k+1) * ( xyr_Press(:,:,k) - xyr_Press(:,:,k+1) ) / Grav
   379      end do
   380  
   381      xy_DODFac = xy_DOD067 * xyr_Press(:,:,0) / DustOptDepRefPress / xyr_DOD067(:,:,0)
     .        d8 = 1.D0/dustoptdeprefpress                                      
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t326 = 1, xy_dod067.DSC.U2*xy_dod067.DSC.U1 + xy_dod067.DSC.U2 
     .           xy_dodfac(t326-1,1) = xy_dod067(t326-1,1)*xyr_press(t326-1,1,0)
     .       1      *d8/xyr_dod067(t326-1,1,0)                                  
     .        enddo                                                             
   382      do k = 0, kmax
   383        xyr_DOD067(:,:,k) = xyr_DOD067(:,:,k) * xy_DODFac
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xy_dodfac)                                                 
     .        do t338 = 1, jmax*imax                                            
     .           xyr_dod067(t338-1,1,k) = xyr_dod067(t338-1,1,k)*xy_dodfac(t338-
     .       1      1,1)                                                        
     .        enddo                                                             
   384      end do
   385  
   386  
   387      ! ヒストリデータ出力
   388      ! History data output
   389      !
   390      call HistoryAutoPut( TimeN, 'DustPresc'    , xyz_MixRtDust    )
   391      call HistoryAutoPut( TimeN, 'DustMaxHeight', xy_MaxHeightDust )
   392  
   393  
   394    end subroutine SetMarsDustSetDOD067
   395  
   396    !--------------------------------------------------------------------------------------
   397  
   398    subroutine SetMarsDustDODViking( &
   399      & Ls, & ! (in)
   400      & DOD & ! (out)
   401      & )
   402  
   403      real(DP), intent(in ) :: Ls
   404      real(DP), intent(out) :: DOD
   405  
   406  
   407      !
   408      ! Local variables
   409      !
   410      real(DP) :: DODDS1
   411      real(DP) :: DODDS2
   412      real(DP) :: DSLs
   413      real(DP) :: MaxDOD
   414      real(DP) :: DSDTC
   415  
   416  
   417      call SetMarsDustDODVikingNoDS( &
   418        & Ls, & ! (in)
   419        & DOD & ! (out)
   420        & )
   421  
   422      ! Add two dust storms
   423      !
   424      DSLs   = 210.0_DP
   425      MaxDOD = 2.7_DP
   426      DSDTC  = 50.0_DP
   427      call SetMarsDustDSExp( &
   428        & Ls, DSLs, MaxDOD, DSDTC, & ! (in)
   429        & DODDS1                   & ! (out)
   430        & )
   431  
   432      DSLs   = 280.0_DP
   433      MaxDOD = 4.0_DP
   434      DSDTC  = 50.0_DP
   435      call SetMarsDustDSExp( &
   436        & Ls, DSLs, MaxDOD, DSDTC, & ! (in)
   437        & DODDS2                   & ! (out)
   438        & )
   439  
   440      DOD = max( DOD, DODDS1, DODDS2 )
   441  
   442  
   443    end subroutine SetMarsDustDODViking
   444  
   445    !--------------------------------------------------------------------------------------
   446  
   447    subroutine SetMarsDustDODVikingNoDS( &
   448      & Ls, & ! (in)
   449      & DOD & ! (out)
   450      & )
   451  
   452      ! 物理定数設定
   453      ! Physical constants settings
   454      !
   455      use constants0, only: PI
   456  
   457      real(DP), intent(in ) :: Ls
   458      real(DP), intent(out) :: DOD
   459  
   460  
   461      ! This expression is obtained from Lewis et al. [1999].
   462      !
   463      DOD = 0.7_DP + 0.3_DP * cos( ( Ls + 80.0_DP ) * PI / 180.0_DP )
   464  
   465  
   466    end subroutine SetMarsDustDODVikingNoDS
   467  
   468    !----------------------------------------------------------------------------
   469  
   470    subroutine SetMarsDustDODMGS( &
   471      & Ls,                       &
   472      & xy_DOD, xy_MaxHeight      &
   473      & )
   474  
   475      ! 物理定数設定
   476      ! Physical constants settings
   477      !
   478      use constants0, only: PI
   479  
   480      ! 座標データ設定
   481      ! Axes data settings
   482      !
   483      use axesset, only: &
   484        & y_Lat    ! $ \varphi $ [rad.] . 緯度. Latitude
   485  
   486      real(DP), intent(in ) :: Ls
   487      real(DP), intent(out) :: xy_DOD      (0:imax-1, 1:jmax)
   488      real(DP), intent(out) :: xy_MaxHeight(0:imax-1, 1:jmax)
   489  
   490  
   491      ! Local variables
   492  
   493      real(DP) :: DODEq
   494      real(DP) :: DODSouth
   495      real(DP) :: DODNorth
   496      real(DP) :: LsFactor
   497  
   498      integer  :: j
   499  
   500  
   501      DODEq    =                &
   502        &   0.2_DP              &
   503        & + ( 0.5_DP - 0.2_DP ) &
   504        &   * cos( ( Ls - 250.0_DP ) / 2.0_DP * PI / 180.0_DP )**14
   505      DODSouth =                &
   506        &   0.1_DP              &
   507        & + ( 0.5_DP - 0.1_DP ) &
   508        &   * cos( ( Ls - 250.0_DP ) / 2.0_DP * PI / 180.0_DP )**14
   509      DODNorth = 0.1_DP
   510  
   511  
   512      LsFactor = sin( ( Ls - 160.0_DP ) * PI / 180.0_DP )
   513  
   514      do j = 1, jmax
   515  
   516        if( y_Lat(j) > 0.0_DP ) then
   517          ! wrong
   518  !!$        xy_DOD(:,j) = DODNorth              &
   519  !!$          & + 0.5_DP * ( DODEq - DODNorth ) &
   520  !!$          &   * ( 1.0_DP + tanh( ( 45.0_DP * PI / 180.0_DP - y_Lat(j) ) / 10.0_DP ) )
   521          xy_DOD(:,j) = DODNorth              &
   522            & + 0.5_DP * ( DODEq - DODNorth ) &
   523            &   * ( 1.0_DP + tanh( ( 45.0_DP * PI / 180.0_DP - y_Lat(j) ) * 10.0_DP ) )
   524        else
   525          ! wrong
   526  !!$        xy_DOD(:,j) = DODSouth              &
   527  !!$          & + 0.5_DP * ( DODEq - DODSouth ) &
   528  !!$          &   * ( 1.0_DP + tanh( ( 45.0_DP * PI / 180.0_DP + y_Lat(j) ) / 10.0_DP ) )
   529          xy_DOD(:,j) = DODSouth              &
   530            & + 0.5_DP * ( DODEq - DODSouth ) &
   531            &   * ( 1.0_DP + tanh( ( 45.0_DP * PI / 180.0_DP + y_Lat(j) ) * 10.0_DP ) )
   532        end if
   533  
   534        xy_MaxHeight(:,j) =                                         &
     .  !cdir    nodep                                                          
     .        do t116 = 1, imax                                                 
     .           xy_maxheight1 = 6.00000000000000e+001 + (1.80000000000000e+001*
     .       1      lsfactor) - (3.20000000000000e+001 + (1.80000000000000e+001*
     .       2      lsfactor))*(dsin(y_lat(j)))**4 - 8.00000000000000e+000*     
     .       3      lsfactor*(dsin(y_lat(j)))**5                                
     .           xy_maxheight(t116-1,j) = xy_maxheight1*1.00000000000000e+003   
     .        enddo                                                             
   535          &   60.0_DP                                               &
   536          & + 18.0_DP * LsFactor                                    &
   537          & - ( 32.0_DP + 18.0_DP * LsFactor ) * sin( y_Lat(j) )**4 &
   538          & - 8.0_DP * LsFactor * sin( y_Lat(j) )**5
   539        xy_MaxHeight(:,j) = xy_MaxHeight(:,j) * 1.0d3
   540  
   541      end do
   542  
   543  
   544    end subroutine SetMarsDustDODMGS
   545  
   546    !----------------------------------------------------------------------------
   547  !!$
   548  !!$  subroutine SetMarsDustDODMGS( &
   549  !!$    & Ls, &
   550  !!$    & Lat, &
   551  !!$    & DOD  &
   552  !!$    & )
   553  !!$
   554  !!$    real(DP), intent(in ) :: Ls
   555  !!$    real(DP), intent(in ) :: Lat
   556  !!$    real(DP), intent(out) :: DOD
   557  !!$
   558  !!$
   559  !!$    ! Local variables
   560  !!$    ! lat2     : Temporary variable for latitude
   561  !!$    ! interc   : Intercept
   562  !!$    ! amp      :
   563  !!$    ! phase    : Phase (degree)
   564  !!$
   565  !!$    real(DP) :: lat2
   566  !!$    real(DP) :: interc
   567  !!$    real(DP) :: amp, phase
   568  !!$
   569  !!$
   570  !!$    if( lat .lt. -40.0d0 ) then
   571  !!$      lat2 = -40.0d0
   572  !!$    else if( lat .gt. 40.0d0 ) then
   573  !!$      lat2 = 40.0d0
   574  !!$    else
   575  !!$      lat2 = lat
   576  !!$    endif
   577  !!$
   578  !!$    if( lat2 .gt. 0.0d0 ) then
   579  !!$      interc = 0.16d0 - 1.8d-3 * lat2
   580  !!$    else
   581  !!$      interc = 0.16d0 + 1.3d-3 * lat2
   582  !!$    endif
   583  !!$    amp   = 0.0623d0 - 0.015d0 * atan( ( lat2 + 2.0d0 ) / 5.0d0 )
   584  !!$    phase = 258.0d0 + 1.8d-1 * lat2
   585  !!$    dod   = interc + amp * cos( ( ls - phase ) * d2r )
   586  !!$
   587  !!$
   588  !!$    ! Dust optical depth at 9 micron is converted to that at 0.67 micron.
   589  !!$
   590  !!$    dod = dod * 2.0d0
   591  !!$
   592  !!$
   593  !!$  end subroutine SetMarsDustDODMGS
   594  !!$
   595  !!$    !**************************************************************************
   596  !!$
   597  !!$    subroutine dodMGS_1yr( ls, lat, dod )
   598  !!$
   599  !!$      use mars_const, only : d2r
   600  !!$
   601  !!$      real(dp), intent(in ) :: ls
   602  !!$      real(dp), intent(in ) :: lat
   603  !!$      real(dp), intent(out) :: dod
   604  !!$
   605  !!$
   606  !!$      ! Local variables
   607  !!$
   608  !!$      real(dp) :: dodds
   609  !!$      real(dp) :: dsls, maxdod, dsdtc
   610  !!$
   611  !!$
   612  !!$      call dodMGS( ls, lat, dod )
   613  !!$
   614  !!$
   615  !!$      !*****Add dust storms
   616  !!$      !-----First year
   617  !!$      dsls   = 227.0d0
   618  !!$      maxdod = 0.475d0
   619  !!$      dsdtc  = 35.0d0
   620  !!$      call duststormexp( ls, dodds, dsls, maxdod, dsdtc )
   621  !!$      dodds  = dodds * exp( -( lat - ( -20.0d0 ) )**2 / ( 60.0d0 )**2 )
   622  !!$      dodds  = dodds * 2.0d0
   623  !!$      dod    = max( dod, dodds )
   624  !!$
   625  !!$      dsls   = 235.0d0
   626  !!$      maxdod = 0.5d0
   627  !!$      dsdtc  = 50.0d0
   628  !!$      call duststormexp( ls, dodds, dsls, maxdod, dsdtc )
   629  !!$      dodds  = dodds * exp( -( lat - ( -60.0d0 ) )**2 / ( 60.0d0 )**2 )
   630  !!$      dodds  = dodds * 2.0d0
   631  !!$      dod    = max( dod, dodds )
   632  !!$
   633  !!$      dsls   = 259.0d0
   634  !!$      maxdod = 0.4d0
   635  !!$      dsdtc  = 70.0d0
   636  !!$      call duststormexp( ls, dodds, dsls, maxdod, dsdtc )
   637  !!$      dodds  = dodds * exp( -( lat - ( -80.0d0 ) )**2 / ( 30.0d0 )**2 )
   638  !!$      dodds  = dodds * 2.0d0
   639  !!$      dod    = max( dod, dodds )
   640  !!$
   641  !!$      !-----Second year
   642  !!$!      dsls   = 360.0d0 + 190.0d0
   643  !!$!      maxdod = 1.7d0
   644  !!$!      dsdtc  = 40.0d0
   645  !!$!      call duststormexp( ls, dodds, dsls, maxdod, dsdtc )
   646  !!$!      dodds  = dodds * exp( -( lat - ( -20.0d0 ) )**2 / ( 60.0d0 )**2 )
   647  !!$!      if( abs( lat ) .gt. 60.0d0 ) dodds = 0.0d0
   648  !!$!      dod    = max( dod, dodds )
   649  !!$
   650  !!$
   651  !!$    end subroutine dodMGS_1yr
   652  !!$
   653  !!$    !**************************************************************************
   654  !!$
   655  !!$    subroutine duststormlin( ls, dod, ls0, x1, y1, x2, y2 )
   656  !!$
   657  !!$      real(dp), intent(in ) :: ls
   658  !!$      real(dp), intent(out) :: dod
   659  !!$      real(dp), intent(in ) :: ls0
   660  !!$      real(dp), intent(in ) :: x1, y1, x2, y2
   661  !!$
   662  !!$
   663  !!$      ! Local variables
   664  !!$      !
   665  !!$      real(dp) :: a, b
   666  !!$      real(dp) :: tmpls
   667  !!$
   668  !!$
   669  !!$      a = ( y2 - y1 ) / ( x2 - x1 )
   670  !!$      b = y1 - ( y2 - y1 ) / ( x2 - x1 ) * x1
   671  !!$
   672  !!$      if( ls .lt. ls0 ) then
   673  !!$         tmpls = ls + 360.0d0
   674  !!$      else
   675  !!$         tmpls = ls
   676  !!$      endif
   677  !!$
   678  !!$      dod = a * tmpls + b
   679  !!$
   680  !!$      dod = max( dod, 0.0d0 )
   681  !!$
   682  !!$
   683  !!$    end subroutine duststormlin
   684  
   685    !**************************************************************************
   686    ! dustsstormexp
   687    !**************************************************************************
   688    ! ls      : Areocentric solar longitude (degree)
   689    ! dod     : Derived dust optical depth at 0.67 micron
   690    ! dsls    : Areocentric solar longitude at the initiation of dust storm
   691    !         : (degree)
   692    ! maxdod  : Maximum value of dust optical depth at 0.67 micron
   693    ! dsdtc   : Decay time constant of dust storm in unit of areocentric
   694    !         : solar longitude (degree)
   695    !**************************************************************************
   696  
   697    subroutine SetMarsDustDSExp( &
   698      & Ls, DSLs, MaxDOD, DSDTC, & ! (in)
   699      & DOD                      & ! (out)
   700      & )
   701  
   702      real(DP), intent(in ) :: Ls
   703      real(DP), intent(in ) :: DSLs
   704      real(DP), intent(in ) :: MaxDOD
   705      real(DP), intent(in ) :: DSDTC
   706      real(DP), intent(out) :: DOD
   707  
   708  
   709      ! Local variables
   710      !
   711      real(DP) :: TMPLs
   712  
   713      if( Ls < DSLs ) then
   714        TMPLs = Ls + 360.0_DP
   715      else
   716        TMPLs = Ls
   717      endif
   718  
   719      DOD = MaxDod * exp( -( TMPLs - DSLs ) / DSDTC )
   720  
   721  
   722    end subroutine SetMarsDustDSExp
   723  
   724    !----------------------------------------------------------------------------
   725  
   726    subroutine SetMarsDustRegDSExp( &
   727      & Ls, DSLs, MaxDOD, DSDTC, & ! (in)
   728      & xy_DOD                   & ! (out)
   729      & )
   730  
   731      ! 物理・数学定数設定
   732      ! Physical and mathematical constants settings
   733      !
   734      use constants0, only: &
   735        & PI                    ! $ \pi $.
   736                                ! 円周率. Circular constant
   737  
   738      ! 座標データ設定
   739      ! Axes data settings
   740      !
   741      use axesset, only: &
   742        & x_Lon, & !
   743        & y_Lat    ! $ \varphi $ [rad.] . 緯度. Latitude
   744  
   745      real(DP), intent(in ) :: Ls
   746      real(DP), intent(in ) :: DSLs
   747      real(DP), intent(in ) :: MaxDOD
   748      real(DP), intent(in ) :: DSDTC
   749      real(DP), intent(out) :: xy_DOD(0:imax-1, 1:jmax)
   750  
   751  
   752      ! Local variables
   753      !
   754      real(DP) :: TMPLs
   755      integer  :: i
   756      integer  :: j
   757  
   758  
   759      if( Ls < DSLs ) then
   760        TMPLs = Ls + 360.0_DP
   761      else
   762        TMPLs = Ls
   763      end if
   764  
   765      do j = 1, jmax
   766        if ( ( -75.0_DP * PI / 180.0_DP <= y_Lat(j) ) .and. &
   767          &  ( y_Lat(j) <= -15.0_DP * PI / 180.0_DP ) ) then
   768          do i = 0, imax-1
   769            if ( ( 300.0_DP * PI / 180.0_DP <= x_Lon(i) ) .or. &
   770              &  ( x_Lon(i) <= 60.0_DP * PI / 180.0_DP  ) ) then
   771              xy_DOD(i,j) = 1.0_DP
   772            else
   773              xy_DOD(i,j) = 0.0_DP
   774            end if
   775          end do
     .  !cdir nodep                                                             
     .  !cdir on_adb(x_lon)                                                     
     .        do i = 1, imax                                                    
     .           if (5.23598775598298e+000.le.x_lon(i-1) .or. x_lon(i-1).le.    
     .       1      1.04719755119659e+000) then                                 
     .              xy_dod1 = 1.00000000000000e+000                             
     .           else                                                           
     .              xy_dod1 = 0.0000000000000000e+000                           
     .           endif                                                          
     .           xy_dod(i-1,j) = xy_dod1                                        
     .        enddo                                                             
     .        goto 10007                                                        
   776        else
   777          xy_DOD(:,j) = 0.0_DP
   778        end if
   779      end do
   780  
   781      xy_DOD = xy_DOD * MaxDOD * exp( -( TMPLs - DSLs ) / DSDTC )
     .  !cdir    nodep                                                          
     .  !cdir noassume                                                          
     .        do t97 = 1, jmax*imax                                             
     .           xy_dod(t97-1,1) = xy_dod(t97-1,1)*maxdod*dexp((-(tmpls - dsls)/
     .       1      dsdtc))                                                     
     .        enddo                                                             
   782  
   783  
   784    end subroutine SetMarsDustRegDSExp
   785  
   786  
   787      !**************************************************************************
   788  !!$
   789  !!$    subroutine mars_setdust_vdist( gph, gp, grho, dod610, qdust, ijs, ije )
   790  !!$
   791  !!$      use maparam   , only : im => imax, jm => jmax, km => kmax
   792  !!$      use maconst   , only : grav
   793  !!$      use mars_const, only : pi
   794  !!$
   795  !!$      real(dp)    , intent(in ) :: gph( im, jm, km+1 ), gp( im, jm, km ), &
   796  !!$           grho( im, jm, km )
   797  !!$      real(dp)    , intent(in ) :: dod610( im, jm )
   798  !!$      real(dp)    , intent(out) :: qdust ( im, jm, km )
   799  !!$      integer(i4b), intent(in ) :: ijs, ije
   800  !!$
   801  !!$
   802  !!$      !
   803  !!$      ! local variables
   804  !!$      !
   805  !!$      ! dod067   : Dust optical depth at 0.67 micron meter
   806  !!$      !          : This is a local variable.
   807  !!$      ! qdust0   : Constant for Use of Dust Mixing Ratio profile
   808  !!$      !          : profile is obtained from Conrath [1975]
   809  !!$      ! qdust1   : Constant for Use of Dust Mixing Ratio profile
   810  !!$
   811  !!$      real(dp) :: dod067( im, jm, km+1 )
   812  !!$      real(dp) :: qdust0, qdust1
   813  !!$
   814  !!$      ! refp       : reference pressure (refp is set to 610 Pa)
   815  !!$      ! p0         : reference pressure (p0 is set to 610 Pa)
   816  !!$      !
   817  !!$      real(dp)     :: refp = 610.0d0, p0 = 610.0d0
   818  !!$
   819  !!$      real(dp)     :: dodtmp
   820  !!$
   821  !!$      integer(i4b) :: ij, k
   822  !!$
   823  !!$
   824  !!$      qdust0=1.0d0
   825  !!$!      qdust1=0.007d0
   826  !!$!      qdust1=0.03d0
   827  !!$      qdust1 = dust_nu_coef
   828  !!$
   829  !!$      do k = 1, km
   830  !!$         do ij = ijs, ije
   831  !!$            qdust( ij, 1, k ) = qdust0 &
   832  !!$                 * exp( qdust1 * ( 1.0d0 - ( p0 / gp( ij, 1, k ) ) ) )
   833  !!$         end do
   834  !!$      end do
   835  !!$
   836  !!$      call calcdod067( gph, grho, qdust, dod067, ijs, ije )
   837  !!$
   838  !!$      do ij = ijs, ije
   839  !!$         dodtmp = dod067( ij, 1, km+1 ) * refp / gph( ij, 1, km+1 )
   840  !!$         qdust0 = 1.0d0
   841  !!$         qdust0 = qdust0 * dod610( ij, 1 ) / dodtmp
   842  !!$         do k = 1, km
   843  !!$            qdust( ij, 1, k ) = qdust( ij, 1, k ) * qdust0
   844  !!$         end do
   845  !!$         do k = 1, km+1
   846  !!$            dod067( ij, 1, k ) = dod067( ij, 1, k ) * qdust0
   847  !!$         end do
   848  !!$      end do
   849  !!$
   850  !!$
   851  !!$    end subroutine mars_setdust_vdist
   852  !!$
   853    !--------------------------------------------------------------------------------------
   854  
   855    subroutine SetMarsDustInit
   856  
   857      ! ファイル入出力補助
   858      ! File I/O support
   859      !
   860      use dc_iounit, only: FileOpen
   861  
   862      ! NAMELIST ファイル入力に関するユーティリティ
   863      ! Utilities for NAMELIST file input
   864      !
   865      use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid
   866  
   867      ! メッセージ出力
   868      ! Message output
   869      !
   870      use dc_message, only: MessageNotify
   871  
   872      ! ヒストリデータ出力
   873      ! History data output
   874      !
   875      use gtool_historyauto, only: HistoryAutoAddVariable
   876  
   877  
   878      ! 宣言文 ; Declaration statements
   879      !
   880  
   881      integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号.
   882                                ! Unit number for NAMELIST file open
   883      integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT.
   884                                ! IOSTAT of NAMELIST read
   885  
   886      ! NAMELIST 変数群
   887      ! NAMELIST group name
   888      !
   889      namelist /set_Mars_dust_nml/ &
   890        & DustExtEff,         &
   891        & REff,               &
   892        & RhoDust,            &
   893        & DustScenario,       &
   894        & DODFileName,        &
   895        & DODVarName,         &
   896        & DOD067,             &
   897        & DustVerDistCoef,    &
   898        & DustOptDepRefPress, &
   899        & DustVerDistRefPress
   900            !
   901            ! デフォルト値については初期化手続 "rad_Mars_V1#RadMarsV1Init"
   902            ! のソースコードを参照のこと.
   903            !
   904            ! Refer to source codes in the initialization procedure
   905            ! "rad_Mars_V1#RadMarsV1Init" for the default values.
   906            !
   907  
   908  
   909      ! デフォルト値の設定
   910      ! Default values settings
   911      !
   912  
   913      DustExtEff = 3.04_DP   ! Ockert-Bell et al. (1997)
   914      REff       = 1.85d-6   ! Ockert-Bell et al. (1997)
   915      RhoDust    = 2500.0_DP ! Pettengill and Ford (2000)
   916  
   917  
   918      DustScenario    = 'Const'
   919  
   920      DODFileName     = ''
   921      DODVarName      = ''
   922  
   923      DOD067          = 0.2_DP
   924  !!$    DustVerDistCoef = 0.01_DP
   925      DustVerDistCoef = 0.007_DP
   926  
   927  !!$    DustOptDepRefPress  = 610.0_DP
   928  !!$    DustVerDistRefPress = 610.0_DP
   929      DustOptDepRefPress  = 700.0_DP
   930      DustVerDistRefPress = 700.0_DP
   931  
   932      ! NAMELIST の読み込み
   933      ! NAMELIST is input
   934      !
   935      if ( trim(namelist_filename) /= '' ) then
   936        call FileOpen( unit_nml, &          ! (out)
   937          & namelist_filename, mode = 'r' ) ! (in)
   938  
   939        rewind( unit_nml )
   940        read( unit_nml,                     & ! (in)
   941          & nml = set_Mars_dust_nml,        & ! (out)
   942          & iostat = iostat_nml )             ! (out)
   943        close( unit_nml )
   944  
   945        call NmlutilMsg( iostat_nml, module_name ) ! (in)
   946      end if
   947  
   948  
   949      if ( DustScenario == 'Const' ) then
   950        IDDustScenario = IDDustScenarioConst
   951      else if ( DustScenario == 'VikingNoDS' ) then
   952        IDDustScenario = IDDustScenarioVikingNoDS
   953      else if ( DustScenario == 'Viking' ) then
   954        IDDustScenario = IDDustScenarioViking
   955      else if ( DustScenario == 'MGS' ) then
   956        IDDustScenario = IDDustScenarioMGS
   957      else if ( DustScenario == 'MGSDODFromFile' ) then
   958        IDDustScenario = IDDustScenarioMGSDODFromFile
   959      else
   960        call MessageNotify( 'E', module_name, 'DustScenario of %c is not supported.', c1 = trim( DustScenario ) )
   961      end if
   962  
   963  
   964  
   965      ! Initialization of modules used in this module
   966      !
   967  
   968  
   969      ! ヒストリデータ出力のためのへの変数登録
   970      ! Register of variables for history data output
   971      !
   972      call HistoryAutoAddVariable( 'DustPresc' , &
   973        & (/ 'lon ', 'lat ', 'sig ', 'time'/),   &
   974        & 'DustPresc', '1' )
   975  
   976      call HistoryAutoAddVariable( 'DustMaxHeight' , &
   977        & (/ 'lon ', 'lat ', 'time'/),               &
   978        & 'DustMaxHeight', 'm' )
   979  
   980  
   981  
   982      ! 印字 ; Print
   983      !
   984      call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   985      call MessageNotify( 'M', module_name, 'DustExtEff          = %f', d  = (/ DustExtEff /) )
   986      call MessageNotify( 'M', module_name, 'REff                = %f', d  = (/ REff /) )
   987      call MessageNotify( 'M', module_name, 'RhoDust             = %f', d  = (/ RhoDust /) )
   988      call MessageNotify( 'M', module_name, 'DustScenario        = %c', c1 = trim( DustScenario ) )
   989      call MessageNotify( 'M', module_name, 'DODFileName         = %c', c1 = trim( DODFileName ) )
   990      call MessageNotify( 'M', module_name, 'DODVarName          = %c', c1 = trim( DODVarName ) )
   991      call MessageNotify( 'M', module_name, 'DOD067              = %f', d  = (/ DOD067      /) )
   992      call MessageNotify( 'M', module_name, 'DustVerDistCoef     = %f', d  = (/ DustVerDistCoef /) )
   993      call MessageNotify( 'M', module_name, 'DustOptDepRefPress  = %f', d  = (/ DustOptDepRefPress /) )
   994      call MessageNotify( 'M', module_name, 'DustVerDistRefPress = %f', d  = (/ DustVerDistRefPress /) )
   995      call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   996  
   997      set_Mars_dust_inited = .true.
   998  
   999    end subroutine SetMarsDustInit
  1000  
  1001    !--------------------------------------------------------------------------------------
  1002  
  1003  end module set_Mars_dust
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:59 2016
FILE NAME: set_Mars_dust.f90
PROGRAM NAME: set_mars_dust
FORMAT LIST

  LINE    LOOP      FORTRAN STATEMENT

     1:             != 
     2:             !
     3:             != Dust distribution is set
     4:             !
     5:             ! Authors::   Yoshiyuki O. Takahashi
     6:             ! Version::   $Id: set_Mars_dust.f90,v 1.13 2013/09/21 14:40:52 yot Exp $
     7:             ! Tag Name::  $Name:  $
     8:             ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9:             ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10:             !
    11:             module set_Mars_dust
    12:               !
    13:               != 
    14:               !
    15:               != Dust distribution is set
    16:               !
    17:               ! <b>Note that Japanese and English are described in parallel.</b>
    18:               !
    19:               ! 
    20:               !
    21:               ! 
    22:               !
    23:               !
    24:               !== References
    25:               !
    26:               !  Lewis, S. R., Collins, M., Forget, F., 
    27:               !    Mars climate database v3.0 detailed design document, 
    28:               !    Technical Note. Contract 11369/95/NL/JG. Work Package 7, ESA, 2001.
    29:               !
    30:               !== Procedures List
    31:               !
    32:             !!$  ! RadiationFluxDennouAGCM :: 放射フラックスの計算
    33:             !!$  ! RadiationDTempDt        :: 放射フラックスによる温度変化の計算
    34:             !!$  ! RadiationFluxOutput     :: 放射フラックスの出力
    35:             !!$  ! RadiationFinalize       :: 終了処理 (モジュール内部の変数の割り付け解除)
    36:             !!$  ! ------------            :: ------------
    37:             !!$  ! RadiationFluxDennouAGCM :: Calculate radiation flux
    38:             !!$  ! RadiationDTempDt        :: Calculate temperature tendency with radiation flux
    39:             !!$  ! RadiationFluxOutput     :: Output radiation fluxes
    40:             !!$  ! RadiationFinalize       :: Termination (deallocate variables in this module)
    41:               !
    42:               !== NAMELIST
    43:               !
    44:             !!$  ! NAMELIST#radiation_DennouAGCM_nml
    45:               !
    46:             
    47:               ! USE statements
    48:               !
    49:             
    50:               !
    51:               ! Kind type parameter
    52:               !
    53:               use dc_types, only: DP, &      ! Double precision.
    54:                 &                 STRING, &  ! Strings.
    55:                 &                 TOKEN      ! Keywords.
    56:             
    57:               ! 格子点設定
    58:               ! Grid points settings
    59:               !
    60:               use gridset, only: imax, & ! 経度格子点数.
    61:                                          ! Number of grid points in longitude
    62:                 &                jmax, & ! 緯度格子点数.
    63:                                          ! Number of grid points in latitude
    64:                 &                kmax    ! 鉛直層数.
    65:                                          ! Number of vertical level
    66:             
    67:               implicit none
    68:             
    69:               private
    70:             
    71:             
    72:               ! 公開変数
    73:               ! Public variables
    74:               !
    75:               logical, save, public:: set_Mars_dust_inited = .false.
    76:                                           ! 初期設定フラグ.
    77:                                           ! Initialization flag
    78:             
    79:               ! Private variables
    80:               !
    81:               real(DP), save :: DustExtEff
    82:               real(DP), save :: REff
    83:               real(DP), save :: RhoDust
    84:             
    85:             
    86:               character(STRING), save :: DustScenario
    87:               real(DP)         , save :: DOD067       ! Dust optical depth at 0.67 micron.
    88:               real(DP)         , save :: DustVerDistCoef
    89:             
    90:               real(DP)         , save :: DustOptDepRefPress
    91:               real(DP)         , save :: DustVerDistRefPress
    92:             
    93:               integer          , save      :: IDDustScenario
    94:               integer          , parameter :: IDDustScenarioConst          = 1
    95:               integer          , parameter :: IDDustScenarioVikingNoDS     = 2
    96:               integer          , parameter :: IDDustScenarioViking         = 3
    97:               integer          , parameter :: IDDustScenarioMGS            = 4
    98:               integer          , parameter :: IDDustScenarioMGSDODFromFile = 5
    99:             
   100:               character(STRING), save      :: DODFileName
   101:               character(STRING), save      :: DODVarName
   102:             
   103:               public :: SetMarsDustCalcDOD067
   104:               public :: SetMarsDustSetDOD067
   105:               public :: SetMarsDustInit
   106:             
   107:               character(*), parameter:: module_name = 'set_Mars_dust'
   108:                                           ! モジュールの名称.
   109:                                           ! Module name
   110:               character(*), parameter:: version = &
   111:                 & '$Name:  $' // &
   112:                 & '$Id: set_Mars_dust.f90,v 1.13 2013/09/21 14:40:52 yot Exp $'
   113:                                           ! モジュールのバージョン
   114:                                           ! Module version
   115:             
   116:               !--------------------------------------------------------------------------------------
   117:             
   118:             contains
   119:             
   120:               !--------------------------------------------------------------------------------------
   121:             
   122:               subroutine SetMarsDustCalcDOD067( &
   123:                 & xyr_Press, xyz_QDust,         & ! (in)
   124:                 & xyr_DOD067                    & ! (out)
   125:                 & )
   126:                 !
   127:                 ! 
   128:                 !
   129:                 ! Calculate dust optical depth at 0.67 micron
   130:                 !
   131:             
   132:                 ! モジュール引用 ; USE statements
   133:                 !
   134:             
   135:                 ! メッセージ出力
   136:                 ! Message output
   137:                 !
   138:                 use dc_message, only: MessageNotify
   139:             
   140:                 ! ヒストリデータ出力
   141:                 ! History data output
   142:                 !
   143:                 use gtool_historyauto, only: HistoryAutoPut
   144:             
   145:                 ! 物理定数設定
   146:                 ! Physical constants settings
   147:                 !
   148:                 use constants, only: Grav
   149:             
   150:             
   151:                 ! 宣言文 ; Declaration statements
   152:                 !
   153:             
   154:                 real(DP), intent(in ):: xyr_Press (0:imax-1, 1:jmax, 0:kmax)
   155:                                           ! Pressure
   156:                 real(DP), intent(in ):: xyz_QDust (0:imax-1, 1:jmax, 1:kmax)
   157:                                           ! Dust mixing ratio
   158:                 real(DP), intent(out):: xyr_DOD067(0:imax-1, 1:jmax, 0:kmax)
   159:                                           ! Optical depth
   160:             
   161:                 ! 作業変数
   162:                 ! Work variables
   163:                 !
   164:                 real(DP)            :: xyz_DelDOD(0:imax-1, 1:jmax, 1:kmax)
   165:             
   166:                 integer :: k             ! 鉛直方向に回る DO ループ用作業変数
   167:                                          ! Work variables for DO loop in vertical direction
   168:             
   169:                 ! 実行文 ; Executable statement
   170:                 !
   171:             
   172:                 ! 初期化
   173:                 ! Initialization
   174:                 !
   175:                 if ( .not. set_Mars_dust_inited ) then
   176:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   177:                 end if
   178:             
   179:             
   180: W------>        do k = 1, kmax
   181: |**==== A         xyz_DelDOD(:,:,k) =                                            &
   182: |                   &   3.0_DP / 4.0_DP * DustExtEff / ( REff * RhoDust * Grav ) &
   183: |                   & * xyz_QDust(:,:,k)                                         &
   184: |                   & * ( xyr_Press(:,:,k-1) - xyr_Press(:,:,k) )
   185: W------         end do
   186:             
   187:                 k = kmax
   188: W*===== A       xyr_DOD067(:,:,k) = 0.0_DP
   189: +------>        do k = kmax-1, 0, -1
   190: |W*==== A         xyr_DOD067(:,:,k) = xyr_DOD067(:,:,k+1) + xyz_DelDOD(:,:,k+1)
   191: +------         end do
   192:             
   193:             
   194:                 ! ヒストリデータ出力
   195:                 ! History data output
   196:                 !
   197:             
   198:             
   199:               end subroutine SetMarsDustCalcDOD067
   200:             
   201:               !--------------------------------------------------------------------------------------
   202:             
   203:               subroutine SetMarsDustSetDOD067( &
   204:                 & Ls, xyr_Press, xyz_Press,    & ! (out) optional & ! (in)
   205:                 & xyr_DOD067                   & ! (out)
   206:                 & )
   207:                 !
   208:                 ! 
   209:                 !
   210:                 ! Set dust optical depth at 0.67 micron
   211:                 !
   212:             
   213:                 ! モジュール引用 ; USE statements
   214:                 !
   215:             
   216:                 ! メッセージ出力
   217:                 ! Message output
   218:                 !
   219:                 use dc_message, only: MessageNotify
   220:             
   221:                 ! ヒストリデータ出力
   222:                 ! History data output
   223:                 !
   224:                 use gtool_historyauto, only: HistoryAutoPut
   225:             
   226:                 ! 時刻管理
   227:                 ! Time control
   228:                 !
   229:                 use timeset, only: &
   230:                   & TimeN
   231:             
   232:                 ! 物理・数学定数設定
   233:                 ! Physical and mathematical constants settings
   234:                 !
   235:                 use constants0, only: &
   236:                   & PI                    ! $ \pi $.
   237:                                           ! 円周率. Circular constant
   238:             
   239:                 ! 物理定数設定
   240:                 ! Physical constants settings
   241:                 !
   242:                 use constants, only: Grav
   243:             
   244:                 ! 座標データ設定
   245:                 ! Axes data settings
   246:                 !
   247:                 use axesset, only: &
   248:                   & y_Lat    ! $ \varphi $ [rad.] . 緯度. Latitude
   249:             
   250:                 ! 時系列データの読み込み
   251:                 ! Reading time series
   252:                 !
   253:                 use read_time_series, only: SetValuesFromTimeSeriesWrapper
   254:             
   255:             
   256:                 ! 宣言文 ; Declaration statements
   257:                 !
   258:             
   259:                 real(DP), intent(in ):: Ls
   260:                                           ! Ls
   261:                 real(DP), intent(in ):: xyr_Press    (0:imax-1, 1:jmax, 0:kmax)
   262:                                           ! Pressure
   263:                 real(DP), intent(in ):: xyz_Press    (0:imax-1, 1:jmax, 1:kmax)
   264:                                           ! Pressure
   265:                 real(DP), intent(out):: xyr_DOD067   (0:imax-1, 1:jmax, 0:kmax)
   266:                                           ! Optical depth
   267:             
   268:                 ! 作業変数
   269:                 ! Work variables
   270:                 !
   271:                 real(DP)            :: DOD
   272:                 real(DP)            :: xy_DOD067       (0:imax-1, 1:jmax)
   273:                                           ! Dust optical depth at 0.67 micron
   274:                 real(DP)            :: xyz_MixRtDust   (0:imax-1, 1:jmax, 1:kmax)
   275:                 real(DP)            :: xy_DODFac       (0:imax-1, 1:jmax)
   276:                 real(DP)            :: xy_MaxHeightDust(0:imax-1, 1:jmax)
   277:             
   278:                 real(DP)            :: MixRtDust0
   279:             
   280:                 integer :: j
   281:                 integer :: k             ! 鉛直方向に回る DO ループ用作業変数
   282:                                          ! Work variables for DO loop in vertical direction
   283:             
   284:                 ! 実行文 ; Executable statement
   285:                 !
   286:             
   287:                 ! 初期化
   288:                 ! Initialization
   289:                 !
   290:                 if ( .not. set_Mars_dust_inited ) then
   291:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   292:                 end if
   293:             
   294:             
   295:                 select case ( IDDustScenario )
   296:                 case ( IDDustScenarioConst )
   297: *V----->A         xy_DOD067 = DOD067
   298: ||          
   299: ||                ! Height of dust top
   300: *V----- A         xy_MaxHeightDust = 70.0d3
   301:             
   302:                 case ( IDDustScenarioVikingNoDS )
   303:             
   304:                   call SetMarsDustDODVikingNoDS( &
   305:                     & Ls, & ! (in)
   306:                     & DOD & ! (out)
   307:                     & )
   308: W*===== A         xy_DOD067 = DOD
   309:             
   310:                   ! Height of dust top
   311:             !!$      xy_MaxHeightDust = 70.0d3
   312:                   !
   313: +------>A         do j = 1, jmax
   314: |V===== A           xy_MaxHeightDust(:,j) =                                 &
   315: |                     &   60.0d3                                            &
   316: |                     & + 18.0d3 * sin( ( Ls - 158.0_DP ) * PI / 180.0_DP ) &
   317: |                     & - 22.0d3 * sin( y_Lat(j) )**2
   318: +------           end do
   319:             
   320:                 case ( IDDustScenarioViking )
   321:             
   322:                   call SetMarsDustDODViking( &
   323:                     & Ls, & ! (in)
   324:                     & DOD & ! (out)
   325:                     & )
   326: W*===== A         xy_DOD067 = DOD
   327:             
   328:                   ! Height of dust top
   329:             !!$      xy_MaxHeightDust = 70.0d3
   330:                   !
   331: +------>A         do j = 1, jmax
   332: |V===== A           xy_MaxHeightDust(:,j) =                                 &
   333: |                     &   60.0d3                                            &
   334: |                     & + 18.0d3 * sin( ( Ls - 158.0_DP ) * PI / 180.0_DP ) &
   335: |                     & - 22.0d3 * sin( y_Lat(j) )**2
   336: +------           end do
   337:             
   338:                 case ( IDDustScenarioMGS )
   339:             
   340:                   call SetMarsDustDODMGS(          &
   341:                     & Ls,                          &
   342:                     & xy_DOD067, xy_MaxHeightDust  &
   343:                     & )
   344:             
   345:                 case ( IDDustScenarioMGSDODFromFile )
   346:             
   347:                   call SetMarsDustDODMGS(          &
   348:                     & Ls,                          &
   349:                     & xy_DOD067, xy_MaxHeightDust  &
   350:                     & )
   351:             
   352:                   call SetValuesFromTimeSeriesWrapper( &
   353:                     & 'DOD',                   &
   354:                     & DODFileName, DODVarName, &
   355:                     & xy_DOD067                &               ! (inout)
   356:                     & )
   357:             
   358:                 case default
   359:                   call MessageNotify( 'E', module_name, 'DustScenario of %c is not supported.', c1 = trim( DustScenario ) )
   360:                 end select
   361:             
   362:             
   363:                 MixRtDust0      =   1.0_DP
   364:             
   365: +------>        do k = 1, kmax
   366: |W*==== A         xyz_MixRtDust(:,:,k) = MixRtDust0 &
   367: |                   & * exp( DustVerDistCoef        &
   368: |                   &        * ( 1.0_DP - ( DustVerDistRefPress / xyz_Press(:,:,k) )**(70.0d3/xy_MaxHeightDust) ) &
   369: |                   &      )
   370: +------         end do
   371: W**==== A       xyz_MixRtDust = min( xyz_MixRtDust, MixRtDust0 )
   372:             
   373:             
   374:                 k = kmax
   375: W*===== A       xyr_DOD067(:,:,k) = 0.0_DP
   376: +------>        do k = kmax-1, 0, -1
   377: |W*==== A         xyr_DOD067(:,:,k) = xyr_DOD067(:,:,k+1) &
   378: |                   & + xyz_MixRtDust(:,:,k+1) * ( xyr_Press(:,:,k) - xyr_Press(:,:,k+1) ) / Grav
   379: +------         end do
   380:             
   381: W*===== A       xy_DODFac = xy_DOD067 * xyr_Press(:,:,0) / DustOptDepRefPress / xyr_DOD067(:,:,0)
   382: +------>        do k = 0, kmax
   383: |W*==== A         xyr_DOD067(:,:,k) = xyr_DOD067(:,:,k) * xy_DODFac
   384: +------         end do
   385:             
   386:             
   387:                 ! ヒストリデータ出力
   388:                 ! History data output
   389:                 !
   390:                 call HistoryAutoPut( TimeN, 'DustPresc'    , xyz_MixRtDust    )
   391:                 call HistoryAutoPut( TimeN, 'DustMaxHeight', xy_MaxHeightDust )
   392:             
   393:             
   394:               end subroutine SetMarsDustSetDOD067
   395:             
   396:               !--------------------------------------------------------------------------------------
   397:             
   398:               subroutine SetMarsDustDODViking( &
   399:                 & Ls, & ! (in)
   400:                 & DOD & ! (out)
   401:                 & )
   402:             
   403:                 real(DP), intent(in ) :: Ls
   404:                 real(DP), intent(out) :: DOD
   405:             
   406:             
   407:                 !
   408:                 ! Local variables
   409:                 !
   410:                 real(DP) :: DODDS1
   411:                 real(DP) :: DODDS2
   412:                 real(DP) :: DSLs
   413:                 real(DP) :: MaxDOD
   414:                 real(DP) :: DSDTC
   415:             
   416:             
   417:                 call SetMarsDustDODVikingNoDS( &
   418:                   & Ls, & ! (in)
   419:                   & DOD & ! (out)
   420:                   & )
   421:             
   422:                 ! Add two dust storms
   423:                 !
   424:                 DSLs   = 210.0_DP
   425:                 MaxDOD = 2.7_DP
   426:                 DSDTC  = 50.0_DP
   427:                 call SetMarsDustDSExp( &
   428:                   & Ls, DSLs, MaxDOD, DSDTC, & ! (in)
   429:                   & DODDS1                   & ! (out)
   430:                   & )
   431:             
   432:                 DSLs   = 280.0_DP
   433:                 MaxDOD = 4.0_DP
   434:                 DSDTC  = 50.0_DP
   435:                 call SetMarsDustDSExp( &
   436:                   & Ls, DSLs, MaxDOD, DSDTC, & ! (in)
   437:                   & DODDS2                   & ! (out)
   438:                   & )
   439:             
   440:                 DOD = max( DOD, DODDS1, DODDS2 )
   441:             
   442:             
   443:               end subroutine SetMarsDustDODViking
   444:             
   445:               !--------------------------------------------------------------------------------------
   446:             
   447:               subroutine SetMarsDustDODVikingNoDS( &
   448:                 & Ls, & ! (in)
   449:                 & DOD & ! (out)
   450:                 & )
   451:             
   452:                 ! 物理定数設定
   453:                 ! Physical constants settings
   454:                 !
   455:                 use constants0, only: PI
   456:             
   457:                 real(DP), intent(in ) :: Ls
   458:                 real(DP), intent(out) :: DOD
   459:             
   460:             
   461:                 ! This expression is obtained from Lewis et al. [1999].
   462:                 !
   463:                 DOD = 0.7_DP + 0.3_DP * cos( ( Ls + 80.0_DP ) * PI / 180.0_DP )
   464:             
   465:             
   466:               end subroutine SetMarsDustDODVikingNoDS
   467:             
   468:               !----------------------------------------------------------------------------
   469:             
   470:               subroutine SetMarsDustDODMGS( &
   471:                 & Ls,                       &
   472:                 & xy_DOD, xy_MaxHeight      &
   473:                 & )
   474:             
   475:                 ! 物理定数設定
   476:                 ! Physical constants settings
   477:                 !
   478:                 use constants0, only: PI
   479:             
   480:                 ! 座標データ設定
   481:                 ! Axes data settings
   482:                 !
   483:                 use axesset, only: &
   484:                   & y_Lat    ! $ \varphi $ [rad.] . 緯度. Latitude
   485:             
   486:                 real(DP), intent(in ) :: Ls
   487:                 real(DP), intent(out) :: xy_DOD      (0:imax-1, 1:jmax)
   488:                 real(DP), intent(out) :: xy_MaxHeight(0:imax-1, 1:jmax)
   489:             
   490:             
   491:                 ! Local variables
   492:             
   493:                 real(DP) :: DODEq
   494:                 real(DP) :: DODSouth
   495:                 real(DP) :: DODNorth
   496:                 real(DP) :: LsFactor
   497:             
   498:                 integer  :: j
   499:             
   500:             
   501:                 DODEq    =                &
   502:                   &   0.2_DP              &
   503:                   & + ( 0.5_DP - 0.2_DP ) &
   504:                   &   * cos( ( Ls - 250.0_DP ) / 2.0_DP * PI / 180.0_DP )**14
   505:                 DODSouth =                &
   506:                   &   0.1_DP              &
   507:                   & + ( 0.5_DP - 0.1_DP ) &
   508:                   &   * cos( ( Ls - 250.0_DP ) / 2.0_DP * PI / 180.0_DP )**14
   509:                 DODNorth = 0.1_DP
   510:             
   511:             
   512:                 LsFactor = sin( ( Ls - 160.0_DP ) * PI / 180.0_DP )
   513:             
   514: +------>        do j = 1, jmax
   515: |           
   516: |                 if( y_Lat(j) > 0.0_DP ) then
   517: |                   ! wrong
   518: |           !!$        xy_DOD(:,j) = DODNorth              &
   519: |           !!$          & + 0.5_DP * ( DODEq - DODNorth ) &
   520: |           !!$          &   * ( 1.0_DP + tanh( ( 45.0_DP * PI / 180.0_DP - y_Lat(j) ) / 10.0_DP ) )
   521: |V===== A           xy_DOD(:,j) = DODNorth              &
   522: |                     & + 0.5_DP * ( DODEq - DODNorth ) &
   523: |                     &   * ( 1.0_DP + tanh( ( 45.0_DP * PI / 180.0_DP - y_Lat(j) ) * 10.0_DP ) )
   524: |                 else
   525: |                   ! wrong
   526: |           !!$        xy_DOD(:,j) = DODSouth              &
   527: |           !!$          & + 0.5_DP * ( DODEq - DODSouth ) &
   528: |           !!$          &   * ( 1.0_DP + tanh( ( 45.0_DP * PI / 180.0_DP + y_Lat(j) ) / 10.0_DP ) )
   529: |V===== A           xy_DOD(:,j) = DODSouth              &
   530: |                     & + 0.5_DP * ( DODEq - DODSouth ) &
   531: |                     &   * ( 1.0_DP + tanh( ( 45.0_DP * PI / 180.0_DP + y_Lat(j) ) * 10.0_DP ) )
   532: |                 end if
   533: |           
   534: |V----->          xy_MaxHeight(:,j) =                                         &
   535: ||                  &   60.0_DP                                               &
   536: ||                  & + 18.0_DP * LsFactor                                    &
   537: ||                  & - ( 32.0_DP + 18.0_DP * LsFactor ) * sin( y_Lat(j) )**4 &
   538: ||                  & - 8.0_DP * LsFactor * sin( y_Lat(j) )**5
   539: |V----- A         xy_MaxHeight(:,j) = xy_MaxHeight(:,j) * 1.0d3
   540: |           
   541: +------         end do
   542:             
   543:             
   544:               end subroutine SetMarsDustDODMGS
   545:             
   546:               !----------------------------------------------------------------------------
   547:             !!$
   548:             !!$  subroutine SetMarsDustDODMGS( &
   549:             !!$    & Ls, &
   550:             !!$    & Lat, &
   551:             !!$    & DOD  &
   552:             !!$    & )
   553:             !!$
   554:             !!$    real(DP), intent(in ) :: Ls
   555:             !!$    real(DP), intent(in ) :: Lat
   556:             !!$    real(DP), intent(out) :: DOD
   557:             !!$
   558:             !!$
   559:             !!$    ! Local variables
   560:             !!$    ! lat2     : Temporary variable for latitude
   561:             !!$    ! interc   : Intercept
   562:             !!$    ! amp      :
   563:             !!$    ! phase    : Phase (degree)
   564:             !!$
   565:             !!$    real(DP) :: lat2
   566:             !!$    real(DP) :: interc
   567:             !!$    real(DP) :: amp, phase
   568:             !!$
   569:             !!$
   570:             !!$    if( lat .lt. -40.0d0 ) then
   571:             !!$      lat2 = -40.0d0
   572:             !!$    else if( lat .gt. 40.0d0 ) then
   573:             !!$      lat2 = 40.0d0
   574:             !!$    else
   575:             !!$      lat2 = lat
   576:             !!$    endif
   577:             !!$
   578:             !!$    if( lat2 .gt. 0.0d0 ) then
   579:             !!$      interc = 0.16d0 - 1.8d-3 * lat2
   580:             !!$    else
   581:             !!$      interc = 0.16d0 + 1.3d-3 * lat2
   582:             !!$    endif
   583:             !!$    amp   = 0.0623d0 - 0.015d0 * atan( ( lat2 + 2.0d0 ) / 5.0d0 )
   584:             !!$    phase = 258.0d0 + 1.8d-1 * lat2
   585:             !!$    dod   = interc + amp * cos( ( ls - phase ) * d2r )
   586:             !!$
   587:             !!$
   588:             !!$    ! Dust optical depth at 9 micron is converted to that at 0.67 micron.
   589:             !!$
   590:             !!$    dod = dod * 2.0d0
   591:             !!$
   592:             !!$
   593:             !!$  end subroutine SetMarsDustDODMGS
   594:             !!$
   595:             !!$    !**************************************************************************
   596:             !!$
   597:             !!$    subroutine dodMGS_1yr( ls, lat, dod )
   598:             !!$
   599:             !!$      use mars_const, only : d2r
   600:             !!$
   601:             !!$      real(dp), intent(in ) :: ls
   602:             !!$      real(dp), intent(in ) :: lat
   603:             !!$      real(dp), intent(out) :: dod
   604:             !!$
   605:             !!$
   606:             !!$      ! Local variables
   607:             !!$
   608:             !!$      real(dp) :: dodds
   609:             !!$      real(dp) :: dsls, maxdod, dsdtc
   610:             !!$
   611:             !!$
   612:             !!$      call dodMGS( ls, lat, dod )
   613:             !!$
   614:             !!$
   615:             !!$      !*****Add dust storms
   616:             !!$      !-----First year
   617:             !!$      dsls   = 227.0d0
   618:             !!$      maxdod = 0.475d0
   619:             !!$      dsdtc  = 35.0d0
   620:             !!$      call duststormexp( ls, dodds, dsls, maxdod, dsdtc )
   621:             !!$      dodds  = dodds * exp( -( lat - ( -20.0d0 ) )**2 / ( 60.0d0 )**2 )
   622:             !!$      dodds  = dodds * 2.0d0
   623:             !!$      dod    = max( dod, dodds )
   624:             !!$
   625:             !!$      dsls   = 235.0d0
   626:             !!$      maxdod = 0.5d0
   627:             !!$      dsdtc  = 50.0d0
   628:             !!$      call duststormexp( ls, dodds, dsls, maxdod, dsdtc )
   629:             !!$      dodds  = dodds * exp( -( lat - ( -60.0d0 ) )**2 / ( 60.0d0 )**2 )
   630:             !!$      dodds  = dodds * 2.0d0
   631:             !!$      dod    = max( dod, dodds )
   632:             !!$
   633:             !!$      dsls   = 259.0d0
   634:             !!$      maxdod = 0.4d0
   635:             !!$      dsdtc  = 70.0d0
   636:             !!$      call duststormexp( ls, dodds, dsls, maxdod, dsdtc )
   637:             !!$      dodds  = dodds * exp( -( lat - ( -80.0d0 ) )**2 / ( 30.0d0 )**2 )
   638:             !!$      dodds  = dodds * 2.0d0
   639:             !!$      dod    = max( dod, dodds )
   640:             !!$
   641:             !!$      !-----Second year
   642:             !!$!      dsls   = 360.0d0 + 190.0d0
   643:             !!$!      maxdod = 1.7d0
   644:             !!$!      dsdtc  = 40.0d0
   645:             !!$!      call duststormexp( ls, dodds, dsls, maxdod, dsdtc )
   646:             !!$!      dodds  = dodds * exp( -( lat - ( -20.0d0 ) )**2 / ( 60.0d0 )**2 )
   647:             !!$!      if( abs( lat ) .gt. 60.0d0 ) dodds = 0.0d0
   648:             !!$!      dod    = max( dod, dodds )
   649:             !!$
   650:             !!$
   651:             !!$    end subroutine dodMGS_1yr
   652:             !!$
   653:             !!$    !**************************************************************************
   654:             !!$
   655:             !!$    subroutine duststormlin( ls, dod, ls0, x1, y1, x2, y2 )
   656:             !!$
   657:             !!$      real(dp), intent(in ) :: ls
   658:             !!$      real(dp), intent(out) :: dod
   659:             !!$      real(dp), intent(in ) :: ls0
   660:             !!$      real(dp), intent(in ) :: x1, y1, x2, y2
   661:             !!$
   662:             !!$
   663:             !!$      ! Local variables
   664:             !!$      !
   665:             !!$      real(dp) :: a, b
   666:             !!$      real(dp) :: tmpls
   667:             !!$
   668:             !!$
   669:             !!$      a = ( y2 - y1 ) / ( x2 - x1 )
   670:             !!$      b = y1 - ( y2 - y1 ) / ( x2 - x1 ) * x1
   671:             !!$
   672:             !!$      if( ls .lt. ls0 ) then
   673:             !!$         tmpls = ls + 360.0d0
   674:             !!$      else
   675:             !!$         tmpls = ls
   676:             !!$      endif
   677:             !!$
   678:             !!$      dod = a * tmpls + b
   679:             !!$
   680:             !!$      dod = max( dod, 0.0d0 )
   681:             !!$
   682:             !!$
   683:             !!$    end subroutine duststormlin
   684:             
   685:               !**************************************************************************
   686:               ! dustsstormexp
   687:               !**************************************************************************
   688:               ! ls      : Areocentric solar longitude (degree)
   689:               ! dod     : Derived dust optical depth at 0.67 micron
   690:               ! dsls    : Areocentric solar longitude at the initiation of dust storm
   691:               !         : (degree)
   692:               ! maxdod  : Maximum value of dust optical depth at 0.67 micron
   693:               ! dsdtc   : Decay time constant of dust storm in unit of areocentric
   694:               !         : solar longitude (degree)
   695:               !**************************************************************************
   696:             
   697:               subroutine SetMarsDustDSExp( &
   698:                 & Ls, DSLs, MaxDOD, DSDTC, & ! (in)
   699:                 & DOD                      & ! (out)
   700:                 & )
   701:             
   702:                 real(DP), intent(in ) :: Ls
   703:                 real(DP), intent(in ) :: DSLs
   704:                 real(DP), intent(in ) :: MaxDOD
   705:                 real(DP), intent(in ) :: DSDTC
   706:                 real(DP), intent(out) :: DOD
   707:             
   708:             
   709:                 ! Local variables
   710:                 !
   711:                 real(DP) :: TMPLs
   712:             
   713:                 if( Ls < DSLs ) then
   714:                   TMPLs = Ls + 360.0_DP
   715:                 else
   716:                   TMPLs = Ls
   717:                 endif
   718:             
   719:                 DOD = MaxDod * exp( -( TMPLs - DSLs ) / DSDTC )
   720:             
   721:             
   722:               end subroutine SetMarsDustDSExp
   723:             
   724:               !----------------------------------------------------------------------------
   725:             
   726:               subroutine SetMarsDustRegDSExp( &
   727:                 & Ls, DSLs, MaxDOD, DSDTC, & ! (in)
   728:                 & xy_DOD                   & ! (out)
   729:                 & )
   730:             
   731:                 ! 物理・数学定数設定
   732:                 ! Physical and mathematical constants settings
   733:                 !
   734:                 use constants0, only: &
   735:                   & PI                    ! $ \pi $.
   736:                                           ! 円周率. Circular constant
   737:             
   738:                 ! 座標データ設定
   739:                 ! Axes data settings
   740:                 !
   741:                 use axesset, only: &
   742:                   & x_Lon, & !
   743:                   & y_Lat    ! $ \varphi $ [rad.] . 緯度. Latitude
   744:             
   745:                 real(DP), intent(in ) :: Ls
   746:                 real(DP), intent(in ) :: DSLs
   747:                 real(DP), intent(in ) :: MaxDOD
   748:                 real(DP), intent(in ) :: DSDTC
   749:                 real(DP), intent(out) :: xy_DOD(0:imax-1, 1:jmax)
   750:             
   751:             
   752:                 ! Local variables
   753:                 !
   754:                 real(DP) :: TMPLs
   755:                 integer  :: i
   756:                 integer  :: j
   757:             
   758:             
   759:                 if( Ls < DSLs ) then
   760:                   TMPLs = Ls + 360.0_DP
   761:                 else
   762:                   TMPLs = Ls
   763:                 end if
   764:             
   765: +------>        do j = 1, jmax
   766: |                 if ( ( -75.0_DP * PI / 180.0_DP <= y_Lat(j) ) .and. &
   767: |                   &  ( y_Lat(j) <= -15.0_DP * PI / 180.0_DP ) ) then
   768: |V----->            do i = 0, imax-1
   769: ||      A             if ( ( 300.0_DP * PI / 180.0_DP <= x_Lon(i) ) .or. &
   770: ||                      &  ( x_Lon(i) <= 60.0_DP * PI / 180.0_DP  ) ) then
   771: ||                      xy_DOD(i,j) = 1.0_DP
   772: ||                    else
   773: ||                      xy_DOD(i,j) = 0.0_DP
   774: ||                    end if
   775: |V----- A           end do
   776: |                 else
   777: |V===== A           xy_DOD(:,j) = 0.0_DP
   778: |                 end if
   779: +------         end do
   780:             
   781: W*===== A       xy_DOD = xy_DOD * MaxDOD * exp( -( TMPLs - DSLs ) / DSDTC )
   782:             
   783:             
   784:               end subroutine SetMarsDustRegDSExp
   785:             
   786:             
   787:                 !**************************************************************************
   788:             !!$
   789:             !!$    subroutine mars_setdust_vdist( gph, gp, grho, dod610, qdust, ijs, ije )
   790:             !!$
   791:             !!$      use maparam   , only : im => imax, jm => jmax, km => kmax
   792:             !!$      use maconst   , only : grav
   793:             !!$      use mars_const, only : pi
   794:             !!$
   795:             !!$      real(dp)    , intent(in ) :: gph( im, jm, km+1 ), gp( im, jm, km ), &
   796:             !!$           grho( im, jm, km )
   797:             !!$      real(dp)    , intent(in ) :: dod610( im, jm )
   798:             !!$      real(dp)    , intent(out) :: qdust ( im, jm, km )
   799:             !!$      integer(i4b), intent(in ) :: ijs, ije
   800:             !!$
   801:             !!$
   802:             !!$      !
   803:             !!$      ! local variables
   804:             !!$      !
   805:             !!$      ! dod067   : Dust optical depth at 0.67 micron meter
   806:             !!$      !          : This is a local variable.
   807:             !!$      ! qdust0   : Constant for Use of Dust Mixing Ratio profile
   808:             !!$      !          : profile is obtained from Conrath [1975]
   809:             !!$      ! qdust1   : Constant for Use of Dust Mixing Ratio profile
   810:             !!$
   811:             !!$      real(dp) :: dod067( im, jm, km+1 )
   812:             !!$      real(dp) :: qdust0, qdust1
   813:             !!$
   814:             !!$      ! refp       : reference pressure (refp is set to 610 Pa)
   815:             !!$      ! p0         : reference pressure (p0 is set to 610 Pa)
   816:             !!$      !
   817:             !!$      real(dp)     :: refp = 610.0d0, p0 = 610.0d0
   818:             !!$
   819:             !!$      real(dp)     :: dodtmp
   820:             !!$
   821:             !!$      integer(i4b) :: ij, k
   822:             !!$
   823:             !!$
   824:             !!$      qdust0=1.0d0
   825:             !!$!      qdust1=0.007d0
   826:             !!$!      qdust1=0.03d0
   827:             !!$      qdust1 = dust_nu_coef
   828:             !!$
   829:             !!$      do k = 1, km
   830:             !!$         do ij = ijs, ije
   831:             !!$            qdust( ij, 1, k ) = qdust0 &
   832:             !!$                 * exp( qdust1 * ( 1.0d0 - ( p0 / gp( ij, 1, k ) ) ) )
   833:             !!$         end do
   834:             !!$      end do
   835:             !!$
   836:             !!$      call calcdod067( gph, grho, qdust, dod067, ijs, ije )
   837:             !!$
   838:             !!$      do ij = ijs, ije
   839:             !!$         dodtmp = dod067( ij, 1, km+1 ) * refp / gph( ij, 1, km+1 )
   840:             !!$         qdust0 = 1.0d0
   841:             !!$         qdust0 = qdust0 * dod610( ij, 1 ) / dodtmp
   842:             !!$         do k = 1, km
   843:             !!$            qdust( ij, 1, k ) = qdust( ij, 1, k ) * qdust0
   844:             !!$         end do
   845:             !!$         do k = 1, km+1
   846:             !!$            dod067( ij, 1, k ) = dod067( ij, 1, k ) * qdust0
   847:             !!$         end do
   848:             !!$      end do
   849:             !!$
   850:             !!$
   851:             !!$    end subroutine mars_setdust_vdist
   852:             !!$
   853:               !--------------------------------------------------------------------------------------
   854:             
   855:               subroutine SetMarsDustInit
   856:             
   857:                 ! ファイル入出力補助
   858:                 ! File I/O support
   859:                 !
   860:                 use dc_iounit, only: FileOpen
   861:             
   862:                 ! NAMELIST ファイル入力に関するユーティリティ
   863:                 ! Utilities for NAMELIST file input
   864:                 !
   865:                 use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid
   866:             
   867:                 ! メッセージ出力
   868:                 ! Message output
   869:                 !
   870:                 use dc_message, only: MessageNotify
   871:             
   872:                 ! ヒストリデータ出力
   873:                 ! History data output
   874:                 !
   875:                 use gtool_historyauto, only: HistoryAutoAddVariable
   876:             
   877:             
   878:                 ! 宣言文 ; Declaration statements
   879:                 !
   880:             
   881:                 integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号.
   882:                                           ! Unit number for NAMELIST file open
   883:                 integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT.
   884:                                           ! IOSTAT of NAMELIST read
   885:             
   886:                 ! NAMELIST 変数群
   887:                 ! NAMELIST group name
   888:                 !
   889:                 namelist /set_Mars_dust_nml/ &
   890:                   & DustExtEff,         &
   891:                   & REff,               &
   892:                   & RhoDust,            &
   893:                   & DustScenario,       &
   894:                   & DODFileName,        &
   895:                   & DODVarName,         &
   896:                   & DOD067,             &
   897:                   & DustVerDistCoef,    &
   898:                   & DustOptDepRefPress, &
   899:                   & DustVerDistRefPress
   900:                       !
   901:                       ! デフォルト値については初期化手続 "rad_Mars_V1#RadMarsV1Init"
   902:                       ! のソースコードを参照のこと.
   903:                       !
   904:                       ! Refer to source codes in the initialization procedure
   905:                       ! "rad_Mars_V1#RadMarsV1Init" for the default values.
   906:                       !
   907:             
   908:             
   909:                 ! デフォルト値の設定
   910:                 ! Default values settings
   911:                 !
   912:             
   913:                 DustExtEff = 3.04_DP   ! Ockert-Bell et al. (1997)
   914:                 REff       = 1.85d-6   ! Ockert-Bell et al. (1997)
   915:                 RhoDust    = 2500.0_DP ! Pettengill and Ford (2000)
   916:             
   917:             
   918:                 DustScenario    = 'Const'
   919:             
   920:                 DODFileName     = ''
   921:                 DODVarName      = ''
   922:             
   923:                 DOD067          = 0.2_DP
   924:             !!$    DustVerDistCoef = 0.01_DP
   925:                 DustVerDistCoef = 0.007_DP
   926:             
   927:             !!$    DustOptDepRefPress  = 610.0_DP
   928:             !!$    DustVerDistRefPress = 610.0_DP
   929:                 DustOptDepRefPress  = 700.0_DP
   930:                 DustVerDistRefPress = 700.0_DP
   931:             
   932:                 ! NAMELIST の読み込み
   933:                 ! NAMELIST is input
   934:                 !
   935:                 if ( trim(namelist_filename) /= '' ) then
   936:                   call FileOpen( unit_nml, &          ! (out)
   937:                     & namelist_filename, mode = 'r' ) ! (in)
   938:             
   939:                   rewind( unit_nml )
   940:                   read( unit_nml,                     & ! (in)
   941:                     & nml = set_Mars_dust_nml,        & ! (out)
   942:                     & iostat = iostat_nml )             ! (out)
   943:                   close( unit_nml )
   944:             
   945:                   call NmlutilMsg( iostat_nml, module_name ) ! (in)
   946:                 end if
   947:             
   948:             
   949:                 if ( DustScenario == 'Const' ) then
   950:                   IDDustScenario = IDDustScenarioConst
   951:                 else if ( DustScenario == 'VikingNoDS' ) then
   952:                   IDDustScenario = IDDustScenarioVikingNoDS
   953:                 else if ( DustScenario == 'Viking' ) then
   954:                   IDDustScenario = IDDustScenarioViking
   955:                 else if ( DustScenario == 'MGS' ) then
   956:                   IDDustScenario = IDDustScenarioMGS
   957:                 else if ( DustScenario == 'MGSDODFromFile' ) then
   958:                   IDDustScenario = IDDustScenarioMGSDODFromFile
   959:                 else
   960:                   call MessageNotify( 'E', module_name, 'DustScenario of %c is not supported.', c1 = trim( DustScenario ) )
   961:                 end if
   962:             
   963:             
   964:             
   965:                 ! Initialization of modules used in this module
   966:                 !
   967:             
   968:             
   969:                 ! ヒストリデータ出力のためのへの変数登録
   970:                 ! Register of variables for history data output
   971:                 !
   972:                 call HistoryAutoAddVariable( 'DustPresc' , &
   973:                   & (/ 'lon ', 'lat ', 'sig ', 'time'/),   &
   974:                   & 'DustPresc', '1' )
   975:             
   976:                 call HistoryAutoAddVariable( 'DustMaxHeight' , &
   977:                   & (/ 'lon ', 'lat ', 'time'/),               &
   978:                   & 'DustMaxHeight', 'm' )
   979:             
   980:             
   981:             
   982:                 ! 印字 ; Print
   983:                 !
   984:                 call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   985:                 call MessageNotify( 'M', module_name, 'DustExtEff          = %f', d  = (/ DustExtEff /) )
   986:                 call MessageNotify( 'M', module_name, 'REff                = %f', d  = (/ REff /) )
   987:                 call MessageNotify( 'M', module_name, 'RhoDust             = %f', d  = (/ RhoDust /) )
   988:                 call MessageNotify( 'M', module_name, 'DustScenario        = %c', c1 = trim( DustScenario ) )
   989:                 call MessageNotify( 'M', module_name, 'DODFileName         = %c', c1 = trim( DODFileName ) )
   990:                 call MessageNotify( 'M', module_name, 'DODVarName          = %c', c1 = trim( DODVarName ) )
   991:                 call MessageNotify( 'M', module_name, 'DOD067              = %f', d  = (/ DOD067      /) )
   992:                 call MessageNotify( 'M', module_name, 'DustVerDistCoef     = %f', d  = (/ DustVerDistCoef /) )
   993:                 call MessageNotify( 'M', module_name, 'DustOptDepRefPress  = %f', d  = (/ DustOptDepRefPress /) )
   994:                 call MessageNotify( 'M', module_name, 'DustVerDistRefPress = %f', d  = (/ DustVerDistRefPress /) )
   995:                 call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   996:             
   997:                 set_Mars_dust_inited = .true.
   998:             
   999:               end subroutine SetMarsDustInit
  1000:             
  1001:               !--------------------------------------------------------------------------------------
  1002:             
  1003:             end module set_Mars_dust
