Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:50 2016
FILE NAME: set_gcmr.f90
PROGRAM NAME: set_gcmr
TRANSFORMATION LIST

  LINE                   FORTRAN STATEMENT

     1  != 全球一定混合比の設定
     2  !
     3  != Set globally constant mixing ratio
     4  !
     5  ! Authors::   Yoshiyuki O. Takahashi
     6  ! Version::   $Id: set_gcmr.f90,v 1.4 2015/01/29 12:06:43 yot Exp $
     7  ! Tag Name::  $Name:  $
     8  ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9  ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10  !
    11  
    12  module set_gcmr
    13    !
    14    != 全球一定混合比の設定
    15    !
    16    != Set globally constant mixing ratio
    17    !
    18    ! <b>Note that Japanese and English are described in parallel.</b>
    19    !
    20    ! 全球一定混合比.
    21    !
    22    ! Set globally constant mixing ratio.
    23    !
    24    !== References
    25    !
    26  !!$  !  Roewe, D., and K.-N. Liou, Influence of cirrus clouds on the infrared cooling
    27  !!$  !    rate in the troposphere and lower stratosphere, J. Appl. Met., 17, 92-106, 1978.
    28    !
    29    !== Procedures List
    30    !
    31  !!$  ! RadiationFluxDennouAGCM :: 放射フラックスの計算
    32  !!$  ! RadiationDTempDt        :: 放射フラックスによる温度変化の計算
    33  !!$  ! RadiationFluxOutput     :: 放射フラックスの出力
    34  !!$  ! RadiationFinalize       :: 終了処理 (モジュール内部の変数の割り付け解除)
    35  !!$  ! ------------            :: ------------
    36  !!$  ! RadiationFluxDennouAGCM :: Calculate radiation flux
    37  !!$  ! RadiationDTempDt        :: Calculate temperature tendency with radiation flux
    38  !!$  ! RadiationFluxOutput     :: Output radiation fluxes
    39  !!$  ! RadiationFinalize       :: Termination (deallocate variables in this module)
    40    !
    41    !== NAMELIST
    42    !
    43    ! NAMELIST#set_gcmr_nml
    44    !
    45  
    46    ! USE statements
    47    !
    48  
    49    !
    50    ! Kind type parameter
    51    !
    52    use dc_types, only: DP, &      ! Double precision.
    53      &                 STRING, &  ! Strings.
    54      &                 TOKEN      ! Keywords.
    55  
    56    ! メッセージ出力
    57    ! Message output
    58    !
    59    use dc_message, only: MessageNotify
    60  
    61  
    62    ! Declaration statements
    63    !
    64    implicit none
    65    private
    66  
    67    !
    68    ! Public procedure
    69    !
    70    public:: SetGCMR
    71    public:: SetGCMRInit
    72  
    73  
    74    character(*), parameter:: module_name = 'set_gcmr'
    75                                ! モジュールの名称.
    76                                ! Module name
    77    character(*), parameter:: version = &
    78      & '$Name:  $' // &
    79      & '$Id: set_gcmr.f90,v 1.4 2015/01/29 12:06:43 yot Exp $'
    80                                ! モジュールのバージョン
    81                                ! Module version
    82  
    83    real(DP), save         :: MRCO2
    84    character(STRING), save:: CO2File
    85    character(STRING), save:: CO2Name
    86    real(DP), save         :: MRN2O
    87    character(STRING), save:: N2OFile
    88    character(STRING), save:: N2OName
    89    real(DP), save         :: MRCH4
    90    character(STRING), save:: CH4File
    91    character(STRING), save:: CH4Name
    92  
    93    logical, save :: set_gcmr_inited = .false.
    94                                ! 初期設定フラグ.
    95                                ! Initialization flag
    96  
    97  contains
    98  
    99    !--------------------------------------------------------------------------------------
   100  
   101    subroutine SetGCMR( &
   102      & Spec,           & ! (in)
   103      & QGC             & ! (out)
   104      & )
   105  
   106  
   107      ! USE statements
   108      !
   109  
   110      ! ヒストリデータ出力
   111      ! History data output
   112      !
   113      use gtool_historyauto, only: HistoryAutoAddVariable, HistoryAutoPut
   114  
   115      ! 時刻管理
   116      ! Time control
   117      !
   118      use timeset, only: &
   119        & TimeN, &              ! ステップ $ t $ の時刻.
   120                                ! Time of step $ t $.
   121        & TimesetClockStart, TimesetClockStop
   122  
   123      ! 時系列データの読み込み
   124      ! Reading time series
   125      !
   126      use read_time_series, only: SetValuesFromTimeSeriesWrapper
   127  
   128  
   129      character(*), intent(in ):: Spec
   130      real(DP)    , intent(out):: QGC
   131  
   132  
   133      !
   134      ! Work variables
   135      !
   136  
   137  
   138      ! 初期化確認
   139      ! Initialization check
   140      !
   141      if ( .not. set_gcmr_inited ) then
   142        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   143      end if
   144  
   145  
   146      ! 計算時間計測開始
   147      ! Start measurement of computation time
   148      !
   149      call TimesetClockStart( module_name )
   150  
   151  
   152      if ( Spec == 'CO2' ) then
   153  
   154        if ( CO2File == '' ) then
   155          QGC = MRCO2
   156        else
   157          call SetValuesFromTimeSeriesWrapper( &
   158            & "CO2",            &
   159            & CO2File, CO2Name, &
   160            & QGC               &               ! (inout)
   161            & )
   162        end if
   163  
   164        call HistoryAutoPut( TimeN, "QCO2", QGC )
   165  
   166      else if ( Spec == 'N2O' ) then
   167  
   168        if ( N2OFile == '' ) then
   169          QGC = MRN2O
   170        else
   171          call SetValuesFromTimeSeriesWrapper( &
   172            & "N2O",            &
   173            & N2OFile, N2OName, &
   174            & QGC               &               ! (inout)
   175            & )
   176        end if
   177  
   178        call HistoryAutoPut( TimeN, "QN2O", QGC )
   179  
   180      else if ( Spec == 'CH4' ) then
   181  
   182        if ( CH4File == '' ) then
   183          QGC = MRCH4
   184        else
   185          call SetValuesFromTimeSeriesWrapper( &
   186            & "CH4",            &
   187            & CH4File, CH4Name, &
   188            & QGC               &               ! (inout)
   189            & )
   190        end if
   191  
   192        call HistoryAutoPut( TimeN, "QCH4", QGC )
   193  
   194      end if
   195  
   196  
   197      ! 計算時間計測一時停止
   198      ! Pause measurement of computation time
   199      !
   200      call TimesetClockStop( module_name )
   201  
   202  
   203    end subroutine SetGCMR
   204  
   205    !--------------------------------------------------------------------------------------
   206  
   207    subroutine SetGCMRInit
   208  
   209  
   210      ! ファイル入出力補助
   211      ! File I/O support
   212      !
   213      use dc_iounit, only: FileOpen
   214  
   215      ! ヒストリデータ出力
   216      ! History data output
   217      !
   218      use gtool_historyauto, only: HistoryAutoAddVariable
   219  
   220      ! NAMELIST ファイル入力に関するユーティリティ
   221      ! Utilities for NAMELIST file input
   222      !
   223      use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid
   224  
   225  
   226      !
   227      ! Work variables
   228      !
   229      integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号.
   230                                ! Unit number for NAMELIST file open
   231      integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT.
   232                                ! IOSTAT of NAMELIST read
   233  
   234      ! NAMELIST 変数群
   235      ! NAMELIST group name
   236      !
   237      namelist /set_gcmr_nml/ &
   238        & MRCO2,   &
   239        & CO2File, &
   240        & CO2Name, &
   241        & MRN2O,   &
   242        & N2OFile, &
   243        & N2OName, &
   244        & MRCH4,   &
   245        & CH4File, &
   246        & CH4Name
   247            !
   248            ! デフォルト値については初期化手続 "set_gcmr#SetGCMRInit"
   249            ! のソースコードを参照のこと.
   250            !
   251            ! Refer to source codes in the initialization procedure
   252            ! "set_gcmr#SetGCMRInit" for the default values.
   253            !
   254  
   255      if ( set_gcmr_inited ) return
   256  
   257  
   258      ! デフォルト値の設定
   259      ! Default values settings
   260      !
   261  
   262  !!$    MRCO2   = 382.0d-6     ! old default value
   263      MRCO2   =  369.0d-6 ! Value at 2000 in CMIP5 recommendation, PRE2005_MIDYR_CONC.DAT
   264      CO2File = ''
   265      CO2Name = ''
   266      MRN2O   =  316.0d-9 ! Value at 2000 in CMIP5 recommendation, PRE2005_MIDYR_CONC.DAT
   267      N2OFile = ''
   268      N2OName = ''
   269      MRCH4   = 1751.0d-9 ! Value at 2000 in CMIP5 recommendation, PRE2005_MIDYR_CONC.DAT
   270      CH4File = ''
   271      CH4Name = ''
   272  
   273  
   274      ! NAMELIST の読み込み
   275      ! NAMELIST is input
   276      !
   277      if ( trim(namelist_filename) /= '' ) then
   278        call FileOpen( unit_nml, &          ! (out)
   279          & namelist_filename, mode = 'r' ) ! (in)
   280  
   281        rewind( unit_nml )
   282        read( unit_nml,                     & ! (in)
   283          & nml = set_gcmr_nml,              & ! (out)
   284          & iostat = iostat_nml )             ! (out)
   285        close( unit_nml )
   286  
   287        call NmlutilMsg( iostat_nml, module_name ) ! (in)
   288      end if
   289  
   290  
   291      call HistoryAutoAddVariable( "QCO2",       & ! (in)
   292        & (/ 'time' /),                          & ! (in)
   293        & "carbon dioxide", '1' )                  ! (in)
   294      call HistoryAutoAddVariable( "QN2O",       & ! (in)
   295        & (/ 'time' /),                          & ! (in)
   296        & "nitrous oxide", '1' )                   ! (in)
   297      call HistoryAutoAddVariable( "QCH4",       & ! (in)
   298        & (/ 'time' /),                          & ! (in)
   299        & "methane", '1' )                         ! (in)
   300  
   301      ! 印字 ; Print
   302      !
   303      call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   304      call MessageNotify( 'M', module_name, '  MRCO2   = %f', d = (/ MRCO2 /) )
   305      call MessageNotify( 'M', module_name, '  CO2File = %c', c1 = trim( CO2File ) )
   306      call MessageNotify( 'M', module_name, '  CO2Name = %c', c1 = trim( CO2Name ) )
   307      call MessageNotify( 'M', module_name, '  MRN2O   = %f', d = (/ MRN2O /) )
   308      call MessageNotify( 'M', module_name, '  N2OFile = %c', c1 = trim( N2OFile ) )
   309      call MessageNotify( 'M', module_name, '  N2OName = %c', c1 = trim( N2OName ) )
   310      call MessageNotify( 'M', module_name, '  MRCH4   = %f', d = (/ MRCH4 /) )
   311      call MessageNotify( 'M', module_name, '  CH4File = %c', c1 = trim( CH4File ) )
   312      call MessageNotify( 'M', module_name, '  CH4Name = %c', c1 = trim( CH4Name ) )
   313      call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   314  
   315      set_gcmr_inited = .true.
   316  
   317    end subroutine SetGCMRInit
   318  
   319    !--------------------------------------------------------------------------------------
   320  
   321  end module set_gcmr
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:50 2016
FILE NAME: set_gcmr.f90
PROGRAM NAME: set_gcmr
FORMAT LIST

  LINE    LOOP      FORTRAN STATEMENT

     1:             != 全球一定混合比の設定
     2:             !
     3:             != Set globally constant mixing ratio
     4:             !
     5:             ! Authors::   Yoshiyuki O. Takahashi
     6:             ! Version::   $Id: set_gcmr.f90,v 1.4 2015/01/29 12:06:43 yot Exp $
     7:             ! Tag Name::  $Name:  $
     8:             ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9:             ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10:             !
    11:             
    12:             module set_gcmr
    13:               !
    14:               != 全球一定混合比の設定
    15:               !
    16:               != Set globally constant mixing ratio
    17:               !
    18:               ! <b>Note that Japanese and English are described in parallel.</b>
    19:               !
    20:               ! 全球一定混合比.
    21:               !
    22:               ! Set globally constant mixing ratio.
    23:               !
    24:               !== References
    25:               !
    26:             !!$  !  Roewe, D., and K.-N. Liou, Influence of cirrus clouds on the infrared cooling 
    27:             !!$  !    rate in the troposphere and lower stratosphere, J. Appl. Met., 17, 92-106, 1978.
    28:               !
    29:               !== Procedures List
    30:               !
    31:             !!$  ! RadiationFluxDennouAGCM :: 放射フラックスの計算
    32:             !!$  ! RadiationDTempDt        :: 放射フラックスによる温度変化の計算
    33:             !!$  ! RadiationFluxOutput     :: 放射フラックスの出力
    34:             !!$  ! RadiationFinalize       :: 終了処理 (モジュール内部の変数の割り付け解除)
    35:             !!$  ! ------------            :: ------------
    36:             !!$  ! RadiationFluxDennouAGCM :: Calculate radiation flux
    37:             !!$  ! RadiationDTempDt        :: Calculate temperature tendency with radiation flux
    38:             !!$  ! RadiationFluxOutput     :: Output radiation fluxes
    39:             !!$  ! RadiationFinalize       :: Termination (deallocate variables in this module)
    40:               !
    41:               !== NAMELIST
    42:               !
    43:               ! NAMELIST#set_gcmr_nml
    44:               !
    45:             
    46:               ! USE statements
    47:               !
    48:             
    49:               ! 
    50:               ! Kind type parameter
    51:               !
    52:               use dc_types, only: DP, &      ! Double precision.
    53:                 &                 STRING, &  ! Strings.
    54:                 &                 TOKEN      ! Keywords.
    55:             
    56:               ! メッセージ出力
    57:               ! Message output
    58:               !
    59:               use dc_message, only: MessageNotify
    60:             
    61:             
    62:               ! Declaration statements
    63:               !
    64:               implicit none
    65:               private
    66:             
    67:               ! 
    68:               ! Public procedure
    69:               !
    70:               public:: SetGCMR
    71:               public:: SetGCMRInit
    72:             
    73:             
    74:               character(*), parameter:: module_name = 'set_gcmr'
    75:                                           ! モジュールの名称.
    76:                                           ! Module name
    77:               character(*), parameter:: version = &
    78:                 & '$Name:  $' // &
    79:                 & '$Id: set_gcmr.f90,v 1.4 2015/01/29 12:06:43 yot Exp $'
    80:                                           ! モジュールのバージョン
    81:                                           ! Module version
    82:             
    83:               real(DP), save         :: MRCO2
    84:               character(STRING), save:: CO2File
    85:               character(STRING), save:: CO2Name
    86:               real(DP), save         :: MRN2O
    87:               character(STRING), save:: N2OFile
    88:               character(STRING), save:: N2OName
    89:               real(DP), save         :: MRCH4
    90:               character(STRING), save:: CH4File
    91:               character(STRING), save:: CH4Name
    92:             
    93:               logical, save :: set_gcmr_inited = .false.
    94:                                           ! 初期設定フラグ.
    95:                                           ! Initialization flag
    96:             
    97:             contains
    98:             
    99:               !--------------------------------------------------------------------------------------
   100:             
   101:               subroutine SetGCMR( &
   102:                 & Spec,           & ! (in)
   103:                 & QGC             & ! (out)
   104:                 & )
   105:             
   106:             
   107:                 ! USE statements
   108:                 !
   109:             
   110:                 ! ヒストリデータ出力
   111:                 ! History data output
   112:                 !
   113:                 use gtool_historyauto, only: HistoryAutoAddVariable, HistoryAutoPut
   114:             
   115:                 ! 時刻管理
   116:                 ! Time control
   117:                 !
   118:                 use timeset, only: &
   119:                   & TimeN, &              ! ステップ $ t $ の時刻.
   120:                                           ! Time of step $ t $.
   121:                   & TimesetClockStart, TimesetClockStop
   122:             
   123:                 ! 時系列データの読み込み
   124:                 ! Reading time series
   125:                 !
   126:                 use read_time_series, only: SetValuesFromTimeSeriesWrapper
   127:             
   128:             
   129:                 character(*), intent(in ):: Spec
   130:                 real(DP)    , intent(out):: QGC
   131:             
   132:             
   133:                 !
   134:                 ! Work variables
   135:                 !
   136:             
   137:             
   138:                 ! 初期化確認
   139:                 ! Initialization check
   140:                 !
   141:                 if ( .not. set_gcmr_inited ) then
   142:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   143:                 end if
   144:             
   145:             
   146:                 ! 計算時間計測開始
   147:                 ! Start measurement of computation time
   148:                 !
   149:                 call TimesetClockStart( module_name )
   150:             
   151:             
   152:                 if ( Spec == 'CO2' ) then
   153:             
   154:                   if ( CO2File == '' ) then
   155:                     QGC = MRCO2
   156:                   else
   157:                     call SetValuesFromTimeSeriesWrapper( &
   158:                       & "CO2",            &
   159:                       & CO2File, CO2Name, &
   160:                       & QGC               &               ! (inout)
   161:                       & )
   162:                   end if
   163:             
   164:                   call HistoryAutoPut( TimeN, "QCO2", QGC )
   165:             
   166:                 else if ( Spec == 'N2O' ) then
   167:             
   168:                   if ( N2OFile == '' ) then
   169:                     QGC = MRN2O
   170:                   else
   171:                     call SetValuesFromTimeSeriesWrapper( &
   172:                       & "N2O",            &
   173:                       & N2OFile, N2OName, &
   174:                       & QGC               &               ! (inout)
   175:                       & )
   176:                   end if
   177:             
   178:                   call HistoryAutoPut( TimeN, "QN2O", QGC )
   179:             
   180:                 else if ( Spec == 'CH4' ) then
   181:             
   182:                   if ( CH4File == '' ) then
   183:                     QGC = MRCH4
   184:                   else
   185:                     call SetValuesFromTimeSeriesWrapper( &
   186:                       & "CH4",            &
   187:                       & CH4File, CH4Name, &
   188:                       & QGC               &               ! (inout)
   189:                       & )
   190:                   end if
   191:             
   192:                   call HistoryAutoPut( TimeN, "QCH4", QGC )
   193:             
   194:                 end if
   195:             
   196:             
   197:                 ! 計算時間計測一時停止
   198:                 ! Pause measurement of computation time
   199:                 !
   200:                 call TimesetClockStop( module_name )
   201:             
   202:             
   203:               end subroutine SetGCMR
   204:             
   205:               !--------------------------------------------------------------------------------------
   206:             
   207:               subroutine SetGCMRInit
   208:             
   209:             
   210:                 ! ファイル入出力補助
   211:                 ! File I/O support
   212:                 !
   213:                 use dc_iounit, only: FileOpen
   214:             
   215:                 ! ヒストリデータ出力
   216:                 ! History data output
   217:                 !
   218:                 use gtool_historyauto, only: HistoryAutoAddVariable
   219:             
   220:                 ! NAMELIST ファイル入力に関するユーティリティ
   221:                 ! Utilities for NAMELIST file input
   222:                 !
   223:                 use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid
   224:             
   225:             
   226:                 !
   227:                 ! Work variables
   228:                 !
   229:                 integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号.
   230:                                           ! Unit number for NAMELIST file open
   231:                 integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT.
   232:                                           ! IOSTAT of NAMELIST read
   233:             
   234:                 ! NAMELIST 変数群
   235:                 ! NAMELIST group name
   236:                 !
   237:                 namelist /set_gcmr_nml/ &
   238:                   & MRCO2,   &
   239:                   & CO2File, &
   240:                   & CO2Name, &
   241:                   & MRN2O,   &
   242:                   & N2OFile, &
   243:                   & N2OName, &
   244:                   & MRCH4,   &
   245:                   & CH4File, &
   246:                   & CH4Name
   247:                       !
   248:                       ! デフォルト値については初期化手続 "set_gcmr#SetGCMRInit"
   249:                       ! のソースコードを参照のこと.
   250:                       !
   251:                       ! Refer to source codes in the initialization procedure
   252:                       ! "set_gcmr#SetGCMRInit" for the default values.
   253:                       !
   254:             
   255:                 if ( set_gcmr_inited ) return
   256:             
   257:             
   258:                 ! デフォルト値の設定
   259:                 ! Default values settings
   260:                 !
   261:             
   262:             !!$    MRCO2   = 382.0d-6     ! old default value
   263:                 MRCO2   =  369.0d-6 ! Value at 2000 in CMIP5 recommendation, PRE2005_MIDYR_CONC.DAT
   264:                 CO2File = ''
   265:                 CO2Name = ''
   266:                 MRN2O   =  316.0d-9 ! Value at 2000 in CMIP5 recommendation, PRE2005_MIDYR_CONC.DAT
   267:                 N2OFile = ''
   268:                 N2OName = ''
   269:                 MRCH4   = 1751.0d-9 ! Value at 2000 in CMIP5 recommendation, PRE2005_MIDYR_CONC.DAT
   270:                 CH4File = ''
   271:                 CH4Name = ''
   272:             
   273:             
   274:                 ! NAMELIST の読み込み
   275:                 ! NAMELIST is input
   276:                 !
   277:                 if ( trim(namelist_filename) /= '' ) then
   278:                   call FileOpen( unit_nml, &          ! (out)
   279:                     & namelist_filename, mode = 'r' ) ! (in)
   280:             
   281:                   rewind( unit_nml )
   282:                   read( unit_nml,                     & ! (in)
   283:                     & nml = set_gcmr_nml,              & ! (out)
   284:                     & iostat = iostat_nml )             ! (out)
   285:                   close( unit_nml )
   286:             
   287:                   call NmlutilMsg( iostat_nml, module_name ) ! (in)
   288:                 end if
   289:             
   290:             
   291:                 call HistoryAutoAddVariable( "QCO2",       & ! (in)
   292:                   & (/ 'time' /),                          & ! (in)
   293:                   & "carbon dioxide", '1' )                  ! (in)
   294:                 call HistoryAutoAddVariable( "QN2O",       & ! (in)
   295:                   & (/ 'time' /),                          & ! (in)
   296:                   & "nitrous oxide", '1' )                   ! (in)
   297:                 call HistoryAutoAddVariable( "QCH4",       & ! (in)
   298:                   & (/ 'time' /),                          & ! (in)
   299:                   & "methane", '1' )                         ! (in)
   300:             
   301:                 ! 印字 ; Print
   302:                 !
   303:                 call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   304:                 call MessageNotify( 'M', module_name, '  MRCO2   = %f', d = (/ MRCO2 /) )
   305:                 call MessageNotify( 'M', module_name, '  CO2File = %c', c1 = trim( CO2File ) )
   306:                 call MessageNotify( 'M', module_name, '  CO2Name = %c', c1 = trim( CO2Name ) )
   307:                 call MessageNotify( 'M', module_name, '  MRN2O   = %f', d = (/ MRN2O /) )
   308:                 call MessageNotify( 'M', module_name, '  N2OFile = %c', c1 = trim( N2OFile ) )
   309:                 call MessageNotify( 'M', module_name, '  N2OName = %c', c1 = trim( N2OName ) )
   310:                 call MessageNotify( 'M', module_name, '  MRCH4   = %f', d = (/ MRCH4 /) )
   311:                 call MessageNotify( 'M', module_name, '  CH4File = %c', c1 = trim( CH4File ) )
   312:                 call MessageNotify( 'M', module_name, '  CH4Name = %c', c1 = trim( CH4Name ) )
   313:                 call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   314:             
   315:                 set_gcmr_inited = .true.
   316:             
   317:               end subroutine SetGCMRInit
   318:             
   319:               !--------------------------------------------------------------------------------------
   320:             
   321:             end module set_gcmr
