Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:50 2016
FILE NAME: set_o3.f90
PROGRAM NAME: set_o3
DIAGNOSTIC LIST

  LINE  LEVEL( NO.): DIAGNOSTIC MESSAGE

   185  opt  (1592): Outer loop unrolled inside inner loop.
   185  vec  (   4): Vectorized array expression.
   185  vec  (  29): ADB is used for array.: xyz_qo3
   185  vec  (   4): Vectorized array expression.
   185  vec  (  29): ADB is used for array.: xyz_qo3
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:50 2016
FILE NAME: set_o3.f90
PROGRAM NAME: set_o3
TRANSFORMATION LIST

  LINE                   FORTRAN STATEMENT

     1  != O3 分布の設定
     2  !
     3  != Set O3 distribution
     4  !
     5  ! Authors::   Yoshiyuki O. Takahashi
     6  ! Version::   $Id: set_o3.f90,v 1.5 2013/03/01 14:14:16 yot Exp $
     7  ! Tag Name::  $Name:  $
     8  ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9  ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10  !
    11  
    12  module set_o3
    13    !
    14    != O3 分布の設定
    15    !
    16    != Set O3 distribution
    17    !
    18    ! <b>Note that Japanese and English are described in parallel.</b>
    19    !
    20    ! O3 分布.
    21    !
    22    ! Set O3 distribution.
    23    !
    24    !== References
    25    !
    26  !!$  !  Roewe, D., and K.-N. Liou, Influence of cirrus clouds on the infrared cooling
    27  !!$  !    rate in the troposphere and lower stratosphere, J. Appl. Met., 17, 92-106, 1978.
    28    !
    29    !== Procedures List
    30    !
    31  !!$  ! RadiationFluxDennouAGCM :: 放射フラックスの計算
    32  !!$  ! RadiationDTempDt        :: 放射フラックスによる温度変化の計算
    33  !!$  ! RadiationFluxOutput     :: 放射フラックスの出力
    34  !!$  ! RadiationFinalize       :: 終了処理 (モジュール内部の変数の割り付け解除)
    35  !!$  ! ------------            :: ------------
    36  !!$  ! RadiationFluxDennouAGCM :: Calculate radiation flux
    37  !!$  ! RadiationDTempDt        :: Calculate temperature tendency with radiation flux
    38  !!$  ! RadiationFluxOutput     :: Output radiation fluxes
    39  !!$  ! RadiationFinalize       :: Termination (deallocate variables in this module)
    40    !
    41    !== NAMELIST
    42    !
    43  !!$  ! NAMELIST#radiation_DennouAGCM_nml
    44    !
    45  
    46    ! USE statements
    47    !
    48  
    49    !
    50    ! Kind type parameter
    51    !
    52    use dc_types, only: DP, &      ! Double precision.
    53      &                 STRING, &  ! Strings.
    54      &                 TOKEN      ! Keywords.
    55  
    56    ! メッセージ出力
    57    ! Message output
    58    !
    59    use dc_message, only: MessageNotify
    60  
    61  
    62    ! Declaration statements
    63    !
    64    implicit none
    65    private
    66  
    67    !
    68    ! Public procedure
    69    !
    70    public:: SetO3
    71    public:: SetO3Init
    72  
    73  
    74    character(*), parameter:: module_name = 'set_o3'
    75                                ! モジュールの名称.
    76                                ! Module name
    77    character(*), parameter:: version = &
    78      & '$Name:  $' // &
    79      & '$Id: set_o3.f90,v 1.5 2013/03/01 14:14:16 yot Exp $'
    80                                ! モジュールのバージョン
    81                                ! Module version
    82  
    83    logical          , save:: FlagO3
    84    logical          , save:: Flag1D
    85  
    86    character(STRING), save:: O3File
    87  
    88    logical, save :: set_o3_inited = .false.
    89                                ! 初期設定フラグ.
    90                                ! Initialization flag
    91  
    92  contains
    93  
    94    !--------------------------------------------------------------------------------------
    95  
    96    subroutine SetO3( &
    97      & xyz_Press, & ! (in )
    98      & xyz_QO3    & ! (out)
    99      & )
   100  
   101  
   102      ! USE statements
   103      !
   104  
   105      !
   106      ! Grid points settings
   107      !
   108      use gridset, only: imax, & !
   109                                 ! Number of grid points in longitude
   110        &                jmax, & !
   111                                 ! Number of grid points in latitude
   112        &                kmax    !
   113                                 ! Number of vertical level
   114  
   115      ! ヒストリデータ出力
   116      ! History data output
   117      !
   118      use gtool_historyauto, only: HistoryAutoAddVariable, HistoryAutoPut
   119  
   120      ! 時刻管理
   121      ! Time control
   122      !
   123      use timeset, only: &
   124        & TimeN, &              ! ステップ $ t $ の時刻.
   125                                ! Time of step $ t $.
   126        & TimesetClockStart, TimesetClockStop
   127  
   128      ! 時系列データの読み込み
   129      ! Reading time series
   130      !
   131      use read_time_series, only: SetValuesFromTimeSeriesWrapper
   132  
   133      ! ファイルから 1 次元プロファイルを読んで設定する.
   134      ! read 1-D profile from a file and set it
   135      !
   136      use set_1d_profile, only : Set1DProfileO3
   137  
   138  
   139      real(DP), intent(in ):: xyz_Press(0:imax-1, 1:jmax, 1:kmax)
   140      real(DP), intent(out):: xyz_QO3  (0:imax-1, 1:jmax, 1:kmax)
   141  
   142  
   143      !
   144      ! Work variables
   145      !
   146  
   147  
   148      ! 初期化確認
   149      ! Initialization check
   150      !
   151      if ( .not. set_o3_inited ) then
   152        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   153      end if
   154  
   155  
   156      ! 計算時間計測開始
   157      ! Start measurement of computation time
   158      !
   159      call TimesetClockStart( module_name )
   160  
   161  
   162      if ( FlagO3 ) then
   163  
   164        if ( Flag1D ) then
   165  
   166          call Set1DProfileO3( &
   167            & xyz_Press,             & ! (in )
   168            & xyz_QO3                & ! (out)
   169            & )
   170  
   171        else
   172  
   173          call SetValuesFromTimeSeriesWrapper( &
   174            & "O3",                  & ! (in)
   175            & O3File, "O3",          & ! (in)
   176            & xyz_Press,             & ! (in)
   177            & xyz_QO3,               & ! (inout)
   178            & .true., .true., .true. & ! (in)
   179            & )
   180  
   181        end if
   182  
   183      else
   184  
   185        xyz_QO3 (:,:,:) = 0.0d0
     .        if (xyz_qo3.DSC.U2 .gt. 0) then                                   
     .           j1 = and(xyz_qo3.DSC.U2,3)                                     
     .  !cdir    nodep                                                          
     .           do t47 = 1, j1                                                 
     .  !cdir       nodep                                                       
     .              do t49 = 1, xyz_qo3.DSC.U1 + 1                              
     .                 xyz_qo3(t49-1,t47,t45+1) = 0.0000000000000000e+000       
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t47 = j1 + 1, xyz_qo3.DSC.U2, 4                             
     .  !cdir       nodep                                                       
     .              do t49 = 1, xyz_qo3.DSC.U1 + 1                              
     .                 xyz_qo3(t49-1,t47,t45+1) = 0.0000000000000000e+000       
     .                 xyz_qo3(t49-1,t47+1,t45+1) = 0.0000000000000000e+000     
     .                 xyz_qo3(t49-1,t47+2,t45+1) = 0.0000000000000000e+000     
     .                 xyz_qo3(t49-1,t47+3,t45+1) = 0.0000000000000000e+000     
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
   186  
   187      end if
   188  
   189      call HistoryAutoPut( TimeN, "QO3", xyz_QO3 )
   190  
   191  
   192      ! 計算時間計測一時停止
   193      ! Pause measurement of computation time
   194      !
   195      call TimesetClockStop( module_name )
   196  
   197  
   198    end subroutine SetO3
   199  
   200    !--------------------------------------------------------------------------------------
   201  
   202    subroutine SetO3Init
   203  
   204  
   205      ! ファイル入出力補助
   206      ! File I/O support
   207      !
   208      use dc_iounit, only: FileOpen
   209  
   210      ! ヒストリデータ出力
   211      ! History data output
   212      !
   213      use gtool_historyauto, only: HistoryAutoAddVariable
   214  
   215      ! NAMELIST ファイル入力に関するユーティリティ
   216      ! Utilities for NAMELIST file input
   217      !
   218      use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid
   219  
   220  
   221  
   222      integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号.
   223                                ! Unit number for NAMELIST file open
   224      integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT.
   225                                ! IOSTAT of NAMELIST read
   226  
   227      ! NAMELIST 変数群
   228      ! NAMELIST group name
   229      !
   230      namelist /set_O3_nml/ &
   231        & FlagO3,  &
   232        & Flag1D,  &
   233        & O3File
   234            !
   235            ! デフォルト値については初期化手続 "set_o3#SetO3Init"
   236            ! のソースコードを参照のこと.
   237            !
   238            ! Refer to source codes in the initialization procedure
   239            ! "set_o3#SetO3Init" for the default values.
   240            !
   241  
   242      if ( set_o3_inited ) return
   243  
   244  
   245      ! デフォルト値の設定
   246      ! Default values settings
   247      !
   248  
   249      FlagO3 = .true.
   250  
   251      Flag1D = .false.
   252  
   253      O3File = ""
   254  
   255  
   256      ! NAMELIST の読み込み
   257      ! NAMELIST is input
   258      !
   259      if ( trim(namelist_filename) /= '' ) then
   260        call FileOpen( unit_nml, &          ! (out)
   261          & namelist_filename, mode = 'r' ) ! (in)
   262  
   263        rewind( unit_nml )
   264        read( unit_nml,                     & ! (in)
   265          & nml = set_O3_nml,               & ! (out)
   266          & iostat = iostat_nml )             ! (out)
   267        close( unit_nml )
   268  
   269        call NmlutilMsg( iostat_nml, module_name ) ! (in)
   270      end if
   271  
   272  
   273      call HistoryAutoAddVariable( "QO3",        & ! (in)
   274        & (/ 'lon ', 'lat ', 'sig ', 'time' /),  & ! (in)
   275        & "ozone", 'kg kg-1' )                     ! (in)
   276  
   277      ! 印字 ; Print
   278      !
   279      call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   280      call MessageNotify( 'M', module_name, '  FlagO3 = %b', l = (/ FlagO3 /) )
   281      call MessageNotify( 'M', module_name, '  Flag1D = %b', l = (/ Flag1D /) )
   282      call MessageNotify( 'M', module_name, '  O3File = %c', c1 = trim( O3File ) )
   283      call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   284  
   285  
   286      set_o3_inited = .true.
   287  
   288    end subroutine SetO3Init
   289  
   290    !--------------------------------------------------------------------------------------
   291  
   292  end module set_o3
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:50 2016
FILE NAME: set_o3.f90
PROGRAM NAME: set_o3
FORMAT LIST

  LINE    LOOP      FORTRAN STATEMENT

     1:             != O3 分布の設定
     2:             !
     3:             != Set O3 distribution
     4:             !
     5:             ! Authors::   Yoshiyuki O. Takahashi
     6:             ! Version::   $Id: set_o3.f90,v 1.5 2013/03/01 14:14:16 yot Exp $
     7:             ! Tag Name::  $Name:  $
     8:             ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9:             ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10:             !
    11:             
    12:             module set_o3
    13:               !
    14:               != O3 分布の設定
    15:               !
    16:               != Set O3 distribution
    17:               !
    18:               ! <b>Note that Japanese and English are described in parallel.</b>
    19:               !
    20:               ! O3 分布.
    21:               !
    22:               ! Set O3 distribution. 
    23:               !
    24:               !== References
    25:               !
    26:             !!$  !  Roewe, D., and K.-N. Liou, Influence of cirrus clouds on the infrared cooling 
    27:             !!$  !    rate in the troposphere and lower stratosphere, J. Appl. Met., 17, 92-106, 1978.
    28:               !
    29:               !== Procedures List
    30:               !
    31:             !!$  ! RadiationFluxDennouAGCM :: 放射フラックスの計算
    32:             !!$  ! RadiationDTempDt        :: 放射フラックスによる温度変化の計算
    33:             !!$  ! RadiationFluxOutput     :: 放射フラックスの出力
    34:             !!$  ! RadiationFinalize       :: 終了処理 (モジュール内部の変数の割り付け解除)
    35:             !!$  ! ------------            :: ------------
    36:             !!$  ! RadiationFluxDennouAGCM :: Calculate radiation flux
    37:             !!$  ! RadiationDTempDt        :: Calculate temperature tendency with radiation flux
    38:             !!$  ! RadiationFluxOutput     :: Output radiation fluxes
    39:             !!$  ! RadiationFinalize       :: Termination (deallocate variables in this module)
    40:               !
    41:               !== NAMELIST
    42:               !
    43:             !!$  ! NAMELIST#radiation_DennouAGCM_nml
    44:               !
    45:             
    46:               ! USE statements
    47:               !
    48:             
    49:               ! 
    50:               ! Kind type parameter
    51:               !
    52:               use dc_types, only: DP, &      ! Double precision.
    53:                 &                 STRING, &  ! Strings.
    54:                 &                 TOKEN      ! Keywords.
    55:             
    56:               ! メッセージ出力
    57:               ! Message output
    58:               !
    59:               use dc_message, only: MessageNotify
    60:             
    61:             
    62:               ! Declaration statements
    63:               !
    64:               implicit none
    65:               private
    66:             
    67:               ! 
    68:               ! Public procedure
    69:               !
    70:               public:: SetO3
    71:               public:: SetO3Init
    72:             
    73:             
    74:               character(*), parameter:: module_name = 'set_o3'
    75:                                           ! モジュールの名称.
    76:                                           ! Module name
    77:               character(*), parameter:: version = &
    78:                 & '$Name:  $' // &
    79:                 & '$Id: set_o3.f90,v 1.5 2013/03/01 14:14:16 yot Exp $'
    80:                                           ! モジュールのバージョン
    81:                                           ! Module version
    82:             
    83:               logical          , save:: FlagO3
    84:               logical          , save:: Flag1D
    85:             
    86:               character(STRING), save:: O3File
    87:             
    88:               logical, save :: set_o3_inited = .false.
    89:                                           ! 初期設定フラグ.
    90:                                           ! Initialization flag
    91:             
    92:             contains
    93:             
    94:               !--------------------------------------------------------------------------------------
    95:             
    96:               subroutine SetO3( &
    97:                 & xyz_Press, & ! (in )
    98:                 & xyz_QO3    & ! (out)
    99:                 & )
   100:             
   101:             
   102:                 ! USE statements
   103:                 !
   104:             
   105:                 ! 
   106:                 ! Grid points settings
   107:                 !
   108:                 use gridset, only: imax, & ! 
   109:                                            ! Number of grid points in longitude
   110:                   &                jmax, & ! 
   111:                                            ! Number of grid points in latitude
   112:                   &                kmax    ! 
   113:                                            ! Number of vertical level
   114:             
   115:                 ! ヒストリデータ出力
   116:                 ! History data output
   117:                 !
   118:                 use gtool_historyauto, only: HistoryAutoAddVariable, HistoryAutoPut
   119:             
   120:                 ! 時刻管理
   121:                 ! Time control
   122:                 !
   123:                 use timeset, only: &
   124:                   & TimeN, &              ! ステップ $ t $ の時刻.
   125:                                           ! Time of step $ t $.
   126:                   & TimesetClockStart, TimesetClockStop
   127:             
   128:                 ! 時系列データの読み込み
   129:                 ! Reading time series
   130:                 !
   131:                 use read_time_series, only: SetValuesFromTimeSeriesWrapper
   132:             
   133:                 ! ファイルから 1 次元プロファイルを読んで設定する. 
   134:                 ! read 1-D profile from a file and set it 
   135:                 !
   136:                 use set_1d_profile, only : Set1DProfileO3
   137:             
   138:             
   139:                 real(DP), intent(in ):: xyz_Press(0:imax-1, 1:jmax, 1:kmax)
   140:                 real(DP), intent(out):: xyz_QO3  (0:imax-1, 1:jmax, 1:kmax)
   141:             
   142:             
   143:                 !
   144:                 ! Work variables
   145:                 !
   146:             
   147:             
   148:                 ! 初期化確認
   149:                 ! Initialization check
   150:                 !
   151:                 if ( .not. set_o3_inited ) then
   152:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   153:                 end if
   154:             
   155:             
   156:                 ! 計算時間計測開始
   157:                 ! Start measurement of computation time
   158:                 !
   159:                 call TimesetClockStart( module_name )
   160:             
   161:             
   162:                 if ( FlagO3 ) then
   163:             
   164:                   if ( Flag1D ) then
   165:             
   166:                     call Set1DProfileO3( &
   167:                       & xyz_Press,             & ! (in )
   168:                       & xyz_QO3                & ! (out)
   169:                       & )
   170:             
   171:                   else
   172:             
   173:                     call SetValuesFromTimeSeriesWrapper( &
   174:                       & "O3",                  & ! (in)
   175:                       & O3File, "O3",          & ! (in)
   176:                       & xyz_Press,             & ! (in)
   177:                       & xyz_QO3,               & ! (inout)
   178:                       & .true., .true., .true. & ! (in)
   179:                       & )
   180:             
   181:                   end if
   182:             
   183:                 else
   184:             
   185: ++V==== A         xyz_QO3 (:,:,:) = 0.0d0
   186:             
   187:                 end if
   188:             
   189:                 call HistoryAutoPut( TimeN, "QO3", xyz_QO3 )
   190:             
   191:             
   192:                 ! 計算時間計測一時停止
   193:                 ! Pause measurement of computation time
   194:                 !
   195:                 call TimesetClockStop( module_name )
   196:             
   197:             
   198:               end subroutine SetO3
   199:             
   200:               !--------------------------------------------------------------------------------------
   201:             
   202:               subroutine SetO3Init
   203:             
   204:             
   205:                 ! ファイル入出力補助
   206:                 ! File I/O support
   207:                 !
   208:                 use dc_iounit, only: FileOpen
   209:             
   210:                 ! ヒストリデータ出力
   211:                 ! History data output
   212:                 !
   213:                 use gtool_historyauto, only: HistoryAutoAddVariable
   214:             
   215:                 ! NAMELIST ファイル入力に関するユーティリティ
   216:                 ! Utilities for NAMELIST file input
   217:                 !
   218:                 use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid
   219:             
   220:             
   221:             
   222:                 integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号.
   223:                                           ! Unit number for NAMELIST file open
   224:                 integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT.
   225:                                           ! IOSTAT of NAMELIST read
   226:             
   227:                 ! NAMELIST 変数群
   228:                 ! NAMELIST group name
   229:                 !
   230:                 namelist /set_O3_nml/ &
   231:                   & FlagO3,  &
   232:                   & Flag1D,  &
   233:                   & O3File
   234:                       !
   235:                       ! デフォルト値については初期化手続 "set_o3#SetO3Init"
   236:                       ! のソースコードを参照のこと.
   237:                       !
   238:                       ! Refer to source codes in the initialization procedure
   239:                       ! "set_o3#SetO3Init" for the default values.
   240:                       !
   241:             
   242:                 if ( set_o3_inited ) return
   243:             
   244:             
   245:                 ! デフォルト値の設定
   246:                 ! Default values settings
   247:                 !
   248:             
   249:                 FlagO3 = .true.
   250:             
   251:                 Flag1D = .false.
   252:             
   253:                 O3File = ""
   254:             
   255:             
   256:                 ! NAMELIST の読み込み
   257:                 ! NAMELIST is input
   258:                 !
   259:                 if ( trim(namelist_filename) /= '' ) then
   260:                   call FileOpen( unit_nml, &          ! (out)
   261:                     & namelist_filename, mode = 'r' ) ! (in)
   262:             
   263:                   rewind( unit_nml )
   264:                   read( unit_nml,                     & ! (in)
   265:                     & nml = set_O3_nml,               & ! (out)
   266:                     & iostat = iostat_nml )             ! (out)
   267:                   close( unit_nml )
   268:             
   269:                   call NmlutilMsg( iostat_nml, module_name ) ! (in)
   270:                 end if
   271:             
   272:             
   273:                 call HistoryAutoAddVariable( "QO3",        & ! (in)
   274:                   & (/ 'lon ', 'lat ', 'sig ', 'time' /),  & ! (in)
   275:                   & "ozone", 'kg kg-1' )                     ! (in)
   276:             
   277:                 ! 印字 ; Print
   278:                 !
   279:                 call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   280:                 call MessageNotify( 'M', module_name, '  FlagO3 = %b', l = (/ FlagO3 /) )
   281:                 call MessageNotify( 'M', module_name, '  Flag1D = %b', l = (/ Flag1D /) )
   282:                 call MessageNotify( 'M', module_name, '  O3File = %c', c1 = trim( O3File ) )
   283:                 call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   284:             
   285:             
   286:                 set_o3_inited = .true.
   287:             
   288:               end subroutine SetO3Init
   289:             
   290:               !--------------------------------------------------------------------------------------
   291:             
   292:             end module set_o3
