Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:50 2016
FILE NAME: set_solarconst.f90
PROGRAM NAME: set_solarconst
TRANSFORMATION LIST

  LINE                   FORTRAN STATEMENT

     1  != 太陽放射フラックスの設定
     2  !
     3  != Set solar constant
     4  !
     5  ! Authors::   Yoshiyuki O. Takahashi
     6  ! Version::   $Id: set_solarconst.f90,v 1.2 2013/03/01 14:14:16 yot Exp $
     7  ! Tag Name::  $Name:  $
     8  ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9  ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10  !
    11  
    12  module set_solarconst
    13    !
    14    != 太陽放射フラックスの設定
    15    !
    16    != Set solar constant
    17    !
    18    ! <b>Note that Japanese and English are described in parallel.</b>
    19    !
    20    !
    21    !
    22    !
    23    !
    24    !== References
    25    !
    26  !!$  !  Roewe, D., and K.-N. Liou, Influence of cirrus clouds on the infrared cooling
    27  !!$  !    rate in the troposphere and lower stratosphere, J. Appl. Met., 17, 92-106, 1978.
    28    !
    29    !== Procedures List
    30    !
    31  !!$  ! RadiationFluxDennouAGCM :: 放射フラックスの計算
    32  !!$  ! RadiationDTempDt        :: 放射フラックスによる温度変化の計算
    33  !!$  ! RadiationFluxOutput     :: 放射フラックスの出力
    34  !!$  ! RadiationFinalize       :: 終了処理 (モジュール内部の変数の割り付け解除)
    35  !!$  ! ------------            :: ------------
    36  !!$  ! RadiationFluxDennouAGCM :: Calculate radiation flux
    37  !!$  ! RadiationDTempDt        :: Calculate temperature tendency with radiation flux
    38  !!$  ! RadiationFluxOutput     :: Output radiation fluxes
    39  !!$  ! RadiationFinalize       :: Termination (deallocate variables in this module)
    40    !
    41    !== NAMELIST
    42    !
    43    ! NAMELIST#set_solarconst_nml
    44    !
    45  
    46    ! USE statements
    47    !
    48  
    49    !
    50    ! Kind type parameter
    51    !
    52    use dc_types, only: DP, &      ! Double precision.
    53      &                 STRING, &  ! Strings.
    54      &                 TOKEN      ! Keywords.
    55  
    56    ! メッセージ出力
    57    ! Message output
    58    !
    59    use dc_message, only: MessageNotify
    60  
    61  
    62    ! Declaration statements
    63    !
    64    implicit none
    65    private
    66  
    67    !
    68    ! Public procedure
    69    !
    70    public:: SetSolarConst
    71    public:: SetSolarConstInit
    72  
    73  
    74    character(*), parameter:: module_name = 'set_solarconst'
    75                                ! モジュールの名称.
    76                                ! Module name
    77    character(*), parameter:: version = &
    78      & '$Name:  $' // &
    79      & '$Id: set_solarconst.f90,v 1.2 2013/03/01 14:14:16 yot Exp $'
    80                                ! モジュールのバージョン
    81                                ! Module version
    82  
    83    real(DP), save         :: SolarConst
    84  
    85    character(STRING), save:: SolarConstFile
    86    character(STRING), save:: SolarConstVarName
    87  
    88    logical, save :: set_solarconst_inited = .false.
    89                                ! 初期設定フラグ.
    90                                ! Initialization flag
    91  
    92  contains
    93  
    94    !--------------------------------------------------------------------------------------
    95  
    96    subroutine SetSolarConst( &
    97      & SolarFlux             & ! (out)
    98      & )
    99  
   100  
   101      ! USE statements
   102      !
   103  
   104      ! ヒストリデータ出力
   105      ! History data output
   106      !
   107      use gtool_historyauto, only: HistoryAutoAddVariable, HistoryAutoPut
   108  
   109      ! 時刻管理
   110      ! Time control
   111      !
   112      use timeset, only: &
   113        & TimeN, &              ! ステップ $ t $ の時刻.
   114                                ! Time of step $ t $.
   115        & TimesetClockStart, TimesetClockStop
   116  
   117      ! 時系列データの読み込み
   118      ! Reading time series
   119      !
   120      use read_time_series, only: SetValuesFromTimeSeriesWrapper
   121  
   122  
   123      real(DP), intent(out):: SolarFlux
   124  
   125  
   126      !
   127      ! Work variables
   128      !
   129  
   130  
   131      ! 初期化確認
   132      ! Initialization check
   133      !
   134      if ( .not. set_solarconst_inited ) then
   135        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   136      end if
   137  
   138  
   139      ! 計算時間計測開始
   140      ! Start measurement of computation time
   141      !
   142      call TimesetClockStart( module_name )
   143  
   144  
   145      if ( SolarConstFile == '' ) then
   146  
   147        SolarFlux = SolarConst
   148  
   149      else
   150  
   151        call SetValuesFromTimeSeriesWrapper(   &
   152          & "SolarConst",                      &
   153          & SolarConstFile, SolarConstVarName, &
   154          & SolarFlux                          & ! (inout)
   155          & )
   156  
   157      end if
   158  
   159  
   160      call HistoryAutoPut( TimeN, "SolarConst", SolarFlux )
   161  
   162  
   163      ! 計算時間計測一時停止
   164      ! Pause measurement of computation time
   165      !
   166      call TimesetClockStop( module_name )
   167  
   168  
   169    end subroutine SetSolarConst
   170  
   171    !--------------------------------------------------------------------------------------
   172  
   173    subroutine SetSolarConstInit
   174  
   175  
   176      ! ファイル入出力補助
   177      ! File I/O support
   178      !
   179      use dc_iounit, only: FileOpen
   180  
   181      ! ヒストリデータ出力
   182      ! History data output
   183      !
   184      use gtool_historyauto, only: HistoryAutoAddVariable
   185  
   186      ! NAMELIST ファイル入力に関するユーティリティ
   187      ! Utilities for NAMELIST file input
   188      !
   189      use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid
   190  
   191  
   192      !
   193      ! Work variables
   194      !
   195      integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号.
   196                                ! Unit number for NAMELIST file open
   197      integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT.
   198                                ! IOSTAT of NAMELIST read
   199  
   200      ! NAMELIST 変数群
   201      ! NAMELIST group name
   202      !
   203      namelist /set_solarconst_nml/ &
   204        & SolarConst,     &
   205        & SolarConstFile, &
   206        & SolarConstVarName
   207            !
   208            ! デフォルト値については初期化手続 "set_solarconst#SetSolarConstInit"
   209            ! のソースコードを参照のこと.
   210            !
   211            ! Refer to source codes in the initialization procedure
   212            ! "set_solarconst#SetSolarConstInit" for the default values.
   213            !
   214  
   215      if ( set_solarconst_inited ) return
   216  
   217  
   218      ! デフォルト値の設定
   219      ! Default values settings
   220      !
   221  
   222  !!$    SolarConst     = 1380.0_DP
   223      SolarConst        = 1366.0_DP
   224  
   225      SolarConstFile    = ''
   226      SolarConstVarName = "SolarConst"
   227  
   228  
   229      ! NAMELIST の読み込み
   230      ! NAMELIST is input
   231      !
   232      if ( trim(namelist_filename) /= '' ) then
   233        call FileOpen( unit_nml, &          ! (out)
   234          & namelist_filename, mode = 'r' ) ! (in)
   235  
   236        rewind( unit_nml )
   237        read( unit_nml,                     & ! (in)
   238          & nml = set_solarconst_nml,       & ! (out)
   239          & iostat = iostat_nml )             ! (out)
   240        close( unit_nml )
   241  
   242        call NmlutilMsg( iostat_nml, module_name ) ! (in)
   243      end if
   244  
   245  
   246      call HistoryAutoAddVariable( "SolarConst", & ! (in)
   247        & (/ 'time' /),                          & ! (in)
   248        & "solar constant", 'W m-2' )              ! (in)
   249  
   250      ! 印字 ; Print
   251      !
   252      call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   253      call MessageNotify( 'M', module_name, '  SolarConst        = %f', d = (/ SolarConst /) )
   254      call MessageNotify( 'M', module_name, '  SolarConstFile    = %c', c1 = trim( SolarConstFile ) )
   255      call MessageNotify( 'M', module_name, '  SolarConstVarName = %c', c1 = trim( SolarConstVarName ) )
   256      call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   257  
   258      set_solarconst_inited = .true.
   259  
   260    end subroutine SetSolarConstInit
   261  
   262    !--------------------------------------------------------------------------------------
   263  
   264  end module set_solarconst
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:50 2016
FILE NAME: set_solarconst.f90
PROGRAM NAME: set_solarconst
FORMAT LIST

  LINE    LOOP      FORTRAN STATEMENT

     1:             != 太陽放射フラックスの設定
     2:             !
     3:             != Set solar constant
     4:             !
     5:             ! Authors::   Yoshiyuki O. Takahashi
     6:             ! Version::   $Id: set_solarconst.f90,v 1.2 2013/03/01 14:14:16 yot Exp $
     7:             ! Tag Name::  $Name:  $
     8:             ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9:             ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10:             !
    11:             
    12:             module set_solarconst
    13:               !
    14:               != 太陽放射フラックスの設定
    15:               !
    16:               != Set solar constant
    17:               !
    18:               ! <b>Note that Japanese and English are described in parallel.</b>
    19:               !
    20:               ! 
    21:               !
    22:               ! 
    23:               !
    24:               !== References
    25:               !
    26:             !!$  !  Roewe, D., and K.-N. Liou, Influence of cirrus clouds on the infrared cooling 
    27:             !!$  !    rate in the troposphere and lower stratosphere, J. Appl. Met., 17, 92-106, 1978.
    28:               !
    29:               !== Procedures List
    30:               !
    31:             !!$  ! RadiationFluxDennouAGCM :: 放射フラックスの計算
    32:             !!$  ! RadiationDTempDt        :: 放射フラックスによる温度変化の計算
    33:             !!$  ! RadiationFluxOutput     :: 放射フラックスの出力
    34:             !!$  ! RadiationFinalize       :: 終了処理 (モジュール内部の変数の割り付け解除)
    35:             !!$  ! ------------            :: ------------
    36:             !!$  ! RadiationFluxDennouAGCM :: Calculate radiation flux
    37:             !!$  ! RadiationDTempDt        :: Calculate temperature tendency with radiation flux
    38:             !!$  ! RadiationFluxOutput     :: Output radiation fluxes
    39:             !!$  ! RadiationFinalize       :: Termination (deallocate variables in this module)
    40:               !
    41:               !== NAMELIST
    42:               !
    43:               ! NAMELIST#set_solarconst_nml
    44:               !
    45:             
    46:               ! USE statements
    47:               !
    48:             
    49:               ! 
    50:               ! Kind type parameter
    51:               !
    52:               use dc_types, only: DP, &      ! Double precision.
    53:                 &                 STRING, &  ! Strings.
    54:                 &                 TOKEN      ! Keywords.
    55:             
    56:               ! メッセージ出力
    57:               ! Message output
    58:               !
    59:               use dc_message, only: MessageNotify
    60:             
    61:             
    62:               ! Declaration statements
    63:               !
    64:               implicit none
    65:               private
    66:             
    67:               ! 
    68:               ! Public procedure
    69:               !
    70:               public:: SetSolarConst
    71:               public:: SetSolarConstInit
    72:             
    73:             
    74:               character(*), parameter:: module_name = 'set_solarconst'
    75:                                           ! モジュールの名称.
    76:                                           ! Module name
    77:               character(*), parameter:: version = &
    78:                 & '$Name:  $' // &
    79:                 & '$Id: set_solarconst.f90,v 1.2 2013/03/01 14:14:16 yot Exp $'
    80:                                           ! モジュールのバージョン
    81:                                           ! Module version
    82:             
    83:               real(DP), save         :: SolarConst
    84:             
    85:               character(STRING), save:: SolarConstFile
    86:               character(STRING), save:: SolarConstVarName
    87:             
    88:               logical, save :: set_solarconst_inited = .false.
    89:                                           ! 初期設定フラグ.
    90:                                           ! Initialization flag
    91:             
    92:             contains
    93:             
    94:               !--------------------------------------------------------------------------------------
    95:             
    96:               subroutine SetSolarConst( &
    97:                 & SolarFlux             & ! (out)
    98:                 & )
    99:             
   100:             
   101:                 ! USE statements
   102:                 !
   103:             
   104:                 ! ヒストリデータ出力
   105:                 ! History data output
   106:                 !
   107:                 use gtool_historyauto, only: HistoryAutoAddVariable, HistoryAutoPut
   108:             
   109:                 ! 時刻管理
   110:                 ! Time control
   111:                 !
   112:                 use timeset, only: &
   113:                   & TimeN, &              ! ステップ $ t $ の時刻.
   114:                                           ! Time of step $ t $.
   115:                   & TimesetClockStart, TimesetClockStop
   116:             
   117:                 ! 時系列データの読み込み
   118:                 ! Reading time series
   119:                 !
   120:                 use read_time_series, only: SetValuesFromTimeSeriesWrapper
   121:             
   122:             
   123:                 real(DP), intent(out):: SolarFlux
   124:             
   125:             
   126:                 !
   127:                 ! Work variables
   128:                 !
   129:             
   130:             
   131:                 ! 初期化確認
   132:                 ! Initialization check
   133:                 !
   134:                 if ( .not. set_solarconst_inited ) then
   135:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   136:                 end if
   137:             
   138:             
   139:                 ! 計算時間計測開始
   140:                 ! Start measurement of computation time
   141:                 !
   142:                 call TimesetClockStart( module_name )
   143:             
   144:             
   145:                 if ( SolarConstFile == '' ) then
   146:             
   147:                   SolarFlux = SolarConst
   148:             
   149:                 else
   150:             
   151:                   call SetValuesFromTimeSeriesWrapper(   &
   152:                     & "SolarConst",                      &
   153:                     & SolarConstFile, SolarConstVarName, &
   154:                     & SolarFlux                          & ! (inout)
   155:                     & )
   156:             
   157:                 end if
   158:             
   159:             
   160:                 call HistoryAutoPut( TimeN, "SolarConst", SolarFlux )
   161:             
   162:             
   163:                 ! 計算時間計測一時停止
   164:                 ! Pause measurement of computation time
   165:                 !
   166:                 call TimesetClockStop( module_name )
   167:             
   168:             
   169:               end subroutine SetSolarConst
   170:             
   171:               !--------------------------------------------------------------------------------------
   172:             
   173:               subroutine SetSolarConstInit
   174:             
   175:             
   176:                 ! ファイル入出力補助
   177:                 ! File I/O support
   178:                 !
   179:                 use dc_iounit, only: FileOpen
   180:             
   181:                 ! ヒストリデータ出力
   182:                 ! History data output
   183:                 !
   184:                 use gtool_historyauto, only: HistoryAutoAddVariable
   185:             
   186:                 ! NAMELIST ファイル入力に関するユーティリティ
   187:                 ! Utilities for NAMELIST file input
   188:                 !
   189:                 use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid
   190:             
   191:             
   192:                 !
   193:                 ! Work variables
   194:                 !
   195:                 integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号.
   196:                                           ! Unit number for NAMELIST file open
   197:                 integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT.
   198:                                           ! IOSTAT of NAMELIST read
   199:             
   200:                 ! NAMELIST 変数群
   201:                 ! NAMELIST group name
   202:                 !
   203:                 namelist /set_solarconst_nml/ &
   204:                   & SolarConst,     &
   205:                   & SolarConstFile, &
   206:                   & SolarConstVarName
   207:                       !
   208:                       ! デフォルト値については初期化手続 "set_solarconst#SetSolarConstInit"
   209:                       ! のソースコードを参照のこと.
   210:                       !
   211:                       ! Refer to source codes in the initialization procedure
   212:                       ! "set_solarconst#SetSolarConstInit" for the default values.
   213:                       !
   214:             
   215:                 if ( set_solarconst_inited ) return
   216:             
   217:             
   218:                 ! デフォルト値の設定
   219:                 ! Default values settings
   220:                 !
   221:             
   222:             !!$    SolarConst     = 1380.0_DP
   223:                 SolarConst        = 1366.0_DP
   224:             
   225:                 SolarConstFile    = ''
   226:                 SolarConstVarName = "SolarConst"
   227:             
   228:             
   229:                 ! NAMELIST の読み込み
   230:                 ! NAMELIST is input
   231:                 !
   232:                 if ( trim(namelist_filename) /= '' ) then
   233:                   call FileOpen( unit_nml, &          ! (out)
   234:                     & namelist_filename, mode = 'r' ) ! (in)
   235:             
   236:                   rewind( unit_nml )
   237:                   read( unit_nml,                     & ! (in)
   238:                     & nml = set_solarconst_nml,       & ! (out)
   239:                     & iostat = iostat_nml )             ! (out)
   240:                   close( unit_nml )
   241:             
   242:                   call NmlutilMsg( iostat_nml, module_name ) ! (in)
   243:                 end if
   244:             
   245:             
   246:                 call HistoryAutoAddVariable( "SolarConst", & ! (in)
   247:                   & (/ 'time' /),                          & ! (in)
   248:                   & "solar constant", 'W m-2' )              ! (in)
   249:             
   250:                 ! 印字 ; Print
   251:                 !
   252:                 call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   253:                 call MessageNotify( 'M', module_name, '  SolarConst        = %f', d = (/ SolarConst /) )
   254:                 call MessageNotify( 'M', module_name, '  SolarConstFile    = %c', c1 = trim( SolarConstFile ) )
   255:                 call MessageNotify( 'M', module_name, '  SolarConstVarName = %c', c1 = trim( SolarConstVarName ) )
   256:                 call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   257:             
   258:                 set_solarconst_inited = .true.
   259:             
   260:               end subroutine SetSolarConstInit
   261:             
   262:               !--------------------------------------------------------------------------------------
   263:             
   264:             end module set_solarconst
