Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:49 2016
FILE NAME: sort.f90
PROGRAM NAME: sort
DIAGNOSTIC LIST

  LINE  LEVEL( NO.): DIAGNOSTIC MESSAGE

    51  vec  (   3): Unvectorized loop.
    55  opt  (1017): Subroutine call prevents optimization.
    55  vec  (  10): Vectorization obstructive procedure reference.:sort_quick0
    93  vec  (   1): Vectorized loop.
    93  vec  (  29): ADB is used for array.: arr
    94  opt  (1084): Branch out of the loop inhibits optimization.
    94  vec  (  26): Macro operation Search.
   109  vec  (   3): Unvectorized loop.
   109  vec  (   8): Unvectorizable loop structure.
   116  vec  (   3): Unvectorized loop.
   116  vec  (   8): Unvectorizable loop structure.
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:49 2016
FILE NAME: sort.f90
PROGRAM NAME: sort
TRANSFORMATION LIST

  LINE                   FORTRAN STATEMENT

     1  !******************************************************************************
     2  !
     3  ! reference
     4  !
     5  ! http://www.ics.kagoshima-u.ac.jp/~fuchida/edu/algorithm/sort-algorithm/
     6  !
     7  ! Press et al., Numerical Recipes in C (Japanese version), 1993
     8  !
     9  !******************************************************************************
    10  
    11  module sort
    12  
    13    !
    14    ! Kind type parameter
    15    !
    16    use dc_types, only: DP,     &  ! Double precision.
    17      &                 STRING, &  ! Strings.
    18      &                 TOKEN      ! Keywords.
    19  
    20    implicit none
    21  
    22    private
    23  
    24    public :: SortQuick
    25  
    26    !--------------------------------------------------------------------------------------
    27  
    28  contains
    29  
    30    !--------------------------------------------------------------------------------------
    31  
    32    subroutine SortQuick( im, jm, km, arr, arr1, arr2 )
    33  
    34      integer , intent(in   )           :: im
    35      integer , intent(in   )           :: jm
    36      integer , intent(in   )           :: km
    37      real(DP), intent(inout)           :: arr ( im, jm, km )
    38      real(DP), intent(inout), optional :: arr1( im, jm, km )
    39      real(DP), intent(inout), optional :: arr2( im, jm, km )
    40  
    41  
    42      !
    43      ! local varialbes
    44      !
    45      integer :: i
    46      integer :: j
    47      integer :: ks, ke
    48  
    49  
    50      do j = 1, jm
    51        do i = 1, im
    52  
    53          ks = 1
    54          ke = km
    55          call sort_quick0( im, jm, km, i, j, ks, ke, arr, arr1, arr2 )
    56  
    57        end do
    58      end do
    59  
    60  
    61    end subroutine SortQuick
    62  
    63    !--------------------------------------------------------------------------------------
    64  
    65    recursive subroutine sort_quick0( im, jm, km, i, j, ks, ke, arr, arr1, arr2 )
    66  
    67      integer , intent(in   )           :: im
    68      integer , intent(in   )           :: jm
    69      integer , intent(in   )           :: km
    70      integer , intent(in   )           :: i
    71      integer , intent(in   )           :: j
    72      integer , intent(in   )           :: ks, ke
    73      real(DP), intent(inout)           :: arr ( im, jm, km )
    74      real(DP), intent(inout), optional :: arr1( im, jm, km )
    75      real(DP), intent(inout), optional :: arr2( im, jm, km )
    76  
    77  
    78      !
    79      ! local varialbes
    80      !
    81      real(DP) :: pivot
    82      integer  :: k1, k2, ks1, ke1, ks2, ke2
    83  
    84  !!$        logical      :: sw_find1, sw_find2
    85  
    86  
    87      if( ks == ke ) return
    88  
    89  
    90      !
    91      ! select pivot
    92      !
    93      do k1 = ks+1, ke
    94        if( arr( i, j, ks ) .ne. arr( i, j, k1 ) ) exit
    95      end do
    96      if( k1 > ke ) return
    97      if( arr( i, j, ks ) .ge. arr( i, j, k1 ) ) then
    98        pivot = arr( i, j, ks )
    99      else
   100        pivot = arr( i, j, k1 )
   101      end if
   102  
   103  
   104      k1 = ks
   105      k2 = ke
   106  
   107      do
   108  
   109        do
   110          if( arr( i, j, k1 ) >= pivot ) exit
   111          k1 = k1 + 1
   112          ! MEMO:
   113          ! I never fail to find a value greater than or equal to pivot.
   114  !!$              if( i1 .ge. ie ) exit
   115        end do
   116        do
   117          if( arr( i, j, k2 ) < pivot ) exit
   118          k2 = k2 - 1
   119          ! MEMO:
   120          ! I never fail to find a value less than or equal to pivot.
   121          ! This is due to a way to determine pivot.
   122          ! A value different from pivot MUST be included in array.
   123  !!$              if( i2 .le. is ) exit
   124        end do
   125  
   126        ! MEMO:
   127        ! The values i1 and i2 must not be the same.
   128        ! This is due to a way to determine pivot.
   129        ! A value different from pivot MUST be included in array.
   130  !!$           if( i1 .ge. i2 ) then
   131        if( k1 .gt. k2 ) then
   132  
   133          ! MEMO:
   134          ! The value arr( i1 ) must not be greater than or equal to pivot.
   135          ! This is due to a way to determine pivot.
   136          ! A value different from pivot MUST be included in array.
   137  !!$              if( arr( i1 ) .ge. pivot ) then
   138  !!$                 ie1 = i1 - 1
   139  !!$              else
   140  !!$                 ie1 = i1
   141  !!$              end if
   142  
   143          ke1 = k1 - 1
   144  
   145          exit
   146        end if
   147  
   148        call swap( im, jm, km, arr, i, j, k1, k2 )
   149        if( present( arr1 ) ) call swap( im, jm, km, arr1, i, j, k1, k2 )
   150        if( present( arr2 ) ) call swap( im, jm, km, arr2, i, j, k1, k2 )
   151  
   152  
   153      end do
   154  
   155  
   156      ks1 = ks
   157  !!$        ie1 = i1 - 1
   158      call sort_quick0( im, jm, km, i, j, ks1, ke1, arr, arr1, arr2 )
   159      ks2 = ke1 + 1
   160      ke2 = ke
   161      call sort_quick0( im, jm, km, i, j, ks2, ke2, arr, arr1, arr2 )
   162  
   163  
   164    end subroutine sort_quick0
   165  
   166    !--------------------------------------------------------------------------------------
   167  
   168    subroutine swap( im, jm, km, arr, i, j, k1, k2 )
   169  
   170      integer , intent(in   ) :: im
   171      integer , intent(in   ) :: jm
   172      integer , intent(in   ) :: km
   173      real(DP), intent(inout) :: arr( im, jm, km )
   174      integer , intent(in   ) :: i
   175      integer , intent(in   ) :: j
   176      integer , intent(in   ) :: k1, k2
   177  
   178  
   179      !
   180      ! local variables
   181      !
   182      real(DP) :: rarr
   183  
   184  
   185      rarr            = arr( i, j, k1 )
   186      arr( i, j, k1 ) = arr( i, j, k2 )
   187      arr( i, j, k2 ) = rarr
   188  
   189  
   190    end subroutine swap
   191  
   192    !--------------------------------------------------------------------------------------
   193  
   194  end module sort
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:49 2016
FILE NAME: sort.f90
PROGRAM NAME: sort
FORMAT LIST

  LINE    LOOP      FORTRAN STATEMENT

     1:             !******************************************************************************
     2:             !
     3:             ! reference
     4:             !
     5:             ! http://www.ics.kagoshima-u.ac.jp/~fuchida/edu/algorithm/sort-algorithm/
     6:             !
     7:             ! Press et al., Numerical Recipes in C (Japanese version), 1993
     8:             !
     9:             !******************************************************************************
    10:             
    11:             module sort
    12:             
    13:               !
    14:               ! Kind type parameter
    15:               !
    16:               use dc_types, only: DP,     &  ! Double precision.
    17:                 &                 STRING, &  ! Strings.
    18:                 &                 TOKEN      ! Keywords.
    19:             
    20:               implicit none
    21:             
    22:               private
    23:             
    24:               public :: SortQuick
    25:             
    26:               !--------------------------------------------------------------------------------------
    27:             
    28:             contains
    29:             
    30:               !--------------------------------------------------------------------------------------
    31:             
    32:               subroutine SortQuick( im, jm, km, arr, arr1, arr2 )
    33:             
    34:                 integer , intent(in   )           :: im
    35:                 integer , intent(in   )           :: jm
    36:                 integer , intent(in   )           :: km
    37:                 real(DP), intent(inout)           :: arr ( im, jm, km )
    38:                 real(DP), intent(inout), optional :: arr1( im, jm, km )
    39:                 real(DP), intent(inout), optional :: arr2( im, jm, km )
    40:             
    41:             
    42:                 !
    43:                 ! local varialbes
    44:                 !
    45:                 integer :: i
    46:                 integer :: j
    47:                 integer :: ks, ke
    48:             
    49:             
    50: +------>        do j = 1, jm
    51: |+----->          do i = 1, im
    52: ||          
    53: ||                  ks = 1
    54: ||                  ke = km
    55: ||                  call sort_quick0( im, jm, km, i, j, ks, ke, arr, arr1, arr2 )
    56: ||          
    57: |+-----           end do
    58: +------         end do
    59:             
    60:             
    61:               end subroutine SortQuick
    62:             
    63:               !--------------------------------------------------------------------------------------
    64:             
    65:               recursive subroutine sort_quick0( im, jm, km, i, j, ks, ke, arr, arr1, arr2 )
    66:             
    67:                 integer , intent(in   )           :: im
    68:                 integer , intent(in   )           :: jm
    69:                 integer , intent(in   )           :: km
    70:                 integer , intent(in   )           :: i
    71:                 integer , intent(in   )           :: j
    72:                 integer , intent(in   )           :: ks, ke
    73:                 real(DP), intent(inout)           :: arr ( im, jm, km )
    74:                 real(DP), intent(inout), optional :: arr1( im, jm, km )
    75:                 real(DP), intent(inout), optional :: arr2( im, jm, km )
    76:             
    77:             
    78:                 !
    79:                 ! local varialbes
    80:                 !
    81:                 real(DP) :: pivot
    82:                 integer  :: k1, k2, ks1, ke1, ks2, ke2
    83:             
    84:             !!$        logical      :: sw_find1, sw_find2
    85:             
    86:             
    87:                 if( ks == ke ) return
    88:             
    89:             
    90:                 !
    91:                 ! select pivot
    92:                 !
    93: V------>        do k1 = ks+1, ke
    94: |       A         if( arr( i, j, ks ) .ne. arr( i, j, k1 ) ) exit
    95: V------         end do
    96:                 if( k1 > ke ) return
    97:                 if( arr( i, j, ks ) .ge. arr( i, j, k1 ) ) then
    98:                   pivot = arr( i, j, ks )
    99:                 else
   100:                   pivot = arr( i, j, k1 )
   101:                 end if
   102:             
   103:             
   104:                 k1 = ks
   105:                 k2 = ke
   106:             
   107: +------>        do
   108: |           
   109: |+----->          do
   110: ||                  if( arr( i, j, k1 ) >= pivot ) exit
   111: ||                  k1 = k1 + 1
   112: ||                  ! MEMO:
   113: ||                  ! I never fail to find a value greater than or equal to pivot.
   114: ||          !!$              if( i1 .ge. ie ) exit
   115: |+-----           end do
   116: |+----->          do
   117: ||                  if( arr( i, j, k2 ) < pivot ) exit
   118: ||                  k2 = k2 - 1
   119: ||                  ! MEMO:
   120: ||                  ! I never fail to find a value less than or equal to pivot.
   121: ||                  ! This is due to a way to determine pivot.
   122: ||                  ! A value different from pivot MUST be included in array.
   123: ||          !!$              if( i2 .le. is ) exit
   124: |+-----           end do
   125: |           
   126: |                 ! MEMO:
   127: |                 ! The values i1 and i2 must not be the same. 
   128: |                 ! This is due to a way to determine pivot.
   129: |                 ! A value different from pivot MUST be included in array.
   130: |           !!$           if( i1 .ge. i2 ) then
   131: |                 if( k1 .gt. k2 ) then
   132: |           
   133: |                   ! MEMO:
   134: |                   ! The value arr( i1 ) must not be greater than or equal to pivot.
   135: |                   ! This is due to a way to determine pivot.
   136: |                   ! A value different from pivot MUST be included in array.
   137: |           !!$              if( arr( i1 ) .ge. pivot ) then
   138: |           !!$                 ie1 = i1 - 1
   139: |           !!$              else
   140: |           !!$                 ie1 = i1
   141: |           !!$              end if
   142: |           
   143: |                   ke1 = k1 - 1
   144: |           
   145: |                   exit
   146: |                 end if
   147: |           
   148: |                 call swap( im, jm, km, arr, i, j, k1, k2 )
   149: |                 if( present( arr1 ) ) call swap( im, jm, km, arr1, i, j, k1, k2 )
   150: |                 if( present( arr2 ) ) call swap( im, jm, km, arr2, i, j, k1, k2 )
   151: |           
   152: |           
   153: +------         end do
   154:             
   155:             
   156:                 ks1 = ks
   157:             !!$        ie1 = i1 - 1
   158:                 call sort_quick0( im, jm, km, i, j, ks1, ke1, arr, arr1, arr2 )
   159:                 ks2 = ke1 + 1
   160:                 ke2 = ke
   161:                 call sort_quick0( im, jm, km, i, j, ks2, ke2, arr, arr1, arr2 )
   162:             
   163:             
   164:               end subroutine sort_quick0
   165:             
   166:               !--------------------------------------------------------------------------------------
   167:             
   168:               subroutine swap( im, jm, km, arr, i, j, k1, k2 )
   169:             
   170:                 integer , intent(in   ) :: im
   171:                 integer , intent(in   ) :: jm
   172:                 integer , intent(in   ) :: km
   173:                 real(DP), intent(inout) :: arr( im, jm, km )
   174:                 integer , intent(in   ) :: i
   175:                 integer , intent(in   ) :: j
   176:                 integer , intent(in   ) :: k1, k2
   177:             
   178:             
   179:                 !
   180:                 ! local variables
   181:                 !
   182:                 real(DP) :: rarr
   183:             
   184:             
   185:                 rarr            = arr( i, j, k1 )
   186:                 arr( i, j, k1 ) = arr( i, j, k2 )
   187:                 arr( i, j, k2 ) = rarr
   188:             
   189:             
   190:               end subroutine swap
   191:             
   192:               !--------------------------------------------------------------------------------------
   193:             
   194:             end module sort
