Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:27 2016
FILE NAME: i.saturate.F90
PROGRAM NAME: saturate
DIAGNOSTIC LIST

  LINE  LEVEL( NO.): DIAGNOSTIC MESSAGE

   189  opt  (1592): Outer loop unrolled inside inner loop.
   189  vec  (   4): Vectorized array expression.
   189  vec  (  29): ADB is used for array.: xyz_watfrac
   189  vec  (  29): ADB is used for array.: xyz_temp
   189  vec  (   4): Vectorized array expression.
   189  vec  (  29): ADB is used for array.: xyz_watfrac
   189  vec  (  29): ADB is used for array.: xyz_temp
   193  opt  (1592): Outer loop unrolled inside inner loop.
   193  vec  (   4): Vectorized array expression.
   193  vec  (  29): ADB is used for array.: xyz_watfrac
   193  vec  (  29): ADB is used for array.: xyz_temp
   193  vec  (   4): Vectorized array expression.
   193  vec  (  29): ADB is used for array.: xyz_watfrac
   193  vec  (  29): ADB is used for array.: xyz_temp
   195  opt  (1592): Outer loop unrolled inside inner loop.
   195  vec  (   4): Vectorized array expression.
   195  vec  (  29): ADB is used for array.: xyz_watfrac
   195  vec  (  29): ADB is used for array.: xyz_temp
   195  vec  (   4): Vectorized array expression.
   195  vec  (  29): ADB is used for array.: xyz_watfrac
   195  vec  (  29): ADB is used for array.: xyz_temp
   197  opt  (1592): Outer loop unrolled inside inner loop.
   197  vec  (   4): Vectorized array expression.
   197  vec  (  29): ADB is used for array.: xyz_watfrac
   197  vec  (   4): Vectorized array expression.
   197  vec  (  29): ADB is used for array.: xyz_watfrac
   304  opt  (1592): Outer loop unrolled inside inner loop.
   304  vec  (   4): Vectorized array expression.
   304  vec  (  29): ADB is used for array.: xyz_qvapsatonsol
   304  vec  (  29): ADB is used for array.: xyz_qvapsatonliq
   304  vec  (  29): ADB is used for array.: xyz_watfrac
   304  vec  (   4): Vectorized array expression.
   304  vec  (  29): ADB is used for array.: xyz_qvapsatonsol
   304  vec  (  29): ADB is used for array.: xyz_qvapsatonliq
   304  vec  (  29): ADB is used for array.: xyz_watfrac
   362  opt  (1592): Outer loop unrolled inside inner loop.
   362  vec  (   4): Vectorized array expression.
   362  vec  (  29): ADB is used for array.: xyz_dqvapsatdtemponsol
   362  vec  (  29): ADB is used for array.: xyz_dqvapsatdtemponliq
   362  vec  (  29): ADB is used for array.: xyz_watfrac
   362  vec  (   4): Vectorized array expression.
   362  vec  (  29): ADB is used for array.: xyz_dqvapsatdtemponsol
   362  vec  (  29): ADB is used for array.: xyz_dqvapsatdtemponliq
   362  vec  (  29): ADB is used for array.: xyz_watfrac
   413  opt  (  11): Fused array assignments. :line 413 - 414
   413  opt  (1592): Outer loop unrolled inside inner loop.
   413  vec  (   4): Vectorized array expression.
   413  vec  (  29): ADB is used for array.: xyz_press
   413  vec  (  29): ADB is used for array.: xy_press
   413  vec  (  29): ADB is used for array.: xyz_temp
   413  vec  (  29): ADB is used for array.: xy_temp
   413  vec  (   4): Vectorized array expression.
   413  vec  (  29): ADB is used for array.: xyz_press
   413  vec  (  29): ADB is used for array.: xy_press
   413  vec  (  29): ADB is used for array.: xyz_temp
   413  vec  (  29): ADB is used for array.: xy_temp
   418  opt  (1592): Outer loop unrolled inside inner loop.
   418  vec  (   4): Vectorized array expression.
   418  vec  (  29): ADB is used for array.: xyz_qvapsat
   418  vec  (   4): Vectorized array expression.
   418  vec  (  29): ADB is used for array.: xyz_qvapsat
   465  opt  (  11): Fused array assignments. :line 465 - 466
   465  opt  (1592): Outer loop unrolled inside inner loop.
   465  vec  (   4): Vectorized array expression.
   465  vec  (  29): ADB is used for array.: xyz_qvapsat
   465  vec  (  29): ADB is used for array.: xy_qvapsat
   465  vec  (  29): ADB is used for array.: xyz_temp
   465  vec  (  29): ADB is used for array.: xy_temp
   465  vec  (   4): Vectorized array expression.
   465  vec  (  29): ADB is used for array.: xyz_qvapsat
   465  vec  (  29): ADB is used for array.: xy_qvapsat
   465  vec  (  29): ADB is used for array.: xyz_temp
   465  vec  (  29): ADB is used for array.: xy_temp
   470  opt  (1592): Outer loop unrolled inside inner loop.
   470  vec  (   4): Vectorized array expression.
   470  vec  (  29): ADB is used for array.: xyz_dqvapsatdtemp
   470  vec  (   4): Vectorized array expression.
   470  vec  (  29): ADB is used for array.: xyz_dqvapsatdtemp
   516  opt  (  11): Fused array assignments. :line 516 - 517
   516  vec  (   4): Vectorized array expression.
   516  vec  (  29): ADB is used for array.: xyz_press
   516  vec  (  29): ADB is used for array.: a_press
   516  vec  (  29): ADB is used for array.: xyz_temp
   516  vec  (  29): ADB is used for array.: a_temp
   521  vec  (   4): Vectorized array expression.
   521  vec  (  29): ADB is used for array.: xyz_qvapsat
   573  opt  (  11): Fused array assignments. :line 573 - 574
   573  vec  (   4): Vectorized array expression.
   573  vec  (  29): ADB is used for array.: xyz_qvapsat
   573  vec  (  29): ADB is used for array.: a_qvapsat
   573  vec  (  29): ADB is used for array.: xyz_temp
   573  vec  (  29): ADB is used for array.: a_temp
   578  vec  (   4): Vectorized array expression.
   578  vec  (  29): ADB is used for array.: xyz_dqvapsatdtemp
   624  opt  (  11): Fused array assignments. :line 624 - 625
   735  opt  (  11): Fused array assignments. :line 735 - 736
   735  opt  (1592): Outer loop unrolled inside inner loop.
   735  vec  (   4): Vectorized array expression.
   735  vec  (  29): ADB is used for array.: xyz_press
   735  vec  (  29): ADB is used for array.: xy_press
   735  vec  (  29): ADB is used for array.: xyz_temp
   735  vec  (  29): ADB is used for array.: xy_temp
   735  vec  (   4): Vectorized array expression.
   735  vec  (  29): ADB is used for array.: xyz_press
   735  vec  (  29): ADB is used for array.: xy_press
   735  vec  (  29): ADB is used for array.: xyz_temp
   735  vec  (  29): ADB is used for array.: xy_temp
   740  opt  (1592): Outer loop unrolled inside inner loop.
   740  vec  (   4): Vectorized array expression.
   740  vec  (  29): ADB is used for array.: xyz_qvapsat
   740  vec  (   4): Vectorized array expression.
   740  vec  (  29): ADB is used for array.: xyz_qvapsat
   787  opt  (  11): Fused array assignments. :line 787 - 788
   787  opt  (1592): Outer loop unrolled inside inner loop.
   787  vec  (   4): Vectorized array expression.
   787  vec  (  29): ADB is used for array.: xyz_qvapsat
   787  vec  (  29): ADB is used for array.: xy_qvapsat
   787  vec  (  29): ADB is used for array.: xyz_temp
   787  vec  (  29): ADB is used for array.: xy_temp
   787  vec  (   4): Vectorized array expression.
   787  vec  (  29): ADB is used for array.: xyz_qvapsat
   787  vec  (  29): ADB is used for array.: xy_qvapsat
   787  vec  (  29): ADB is used for array.: xyz_temp
   787  vec  (  29): ADB is used for array.: xy_temp
   792  opt  (1592): Outer loop unrolled inside inner loop.
   792  vec  (   4): Vectorized array expression.
   792  vec  (  29): ADB is used for array.: xyz_dqvapsatdtemp
   792  vec  (   4): Vectorized array expression.
   792  vec  (  29): ADB is used for array.: xyz_dqvapsatdtemp
   838  opt  (  11): Fused array assignments. :line 838 - 839
   838  vec  (   4): Vectorized array expression.
   838  vec  (  29): ADB is used for array.: xyz_press
   838  vec  (  29): ADB is used for array.: a_press
   838  vec  (  29): ADB is used for array.: xyz_temp
   838  vec  (  29): ADB is used for array.: a_temp
   843  vec  (   4): Vectorized array expression.
   843  vec  (  29): ADB is used for array.: xyz_qvapsat
   895  opt  (  11): Fused array assignments. :line 895 - 896
   895  vec  (   4): Vectorized array expression.
   895  vec  (  29): ADB is used for array.: xyz_qvapsat
   895  vec  (  29): ADB is used for array.: a_qvapsat
   895  vec  (  29): ADB is used for array.: xyz_temp
   895  vec  (  29): ADB is used for array.: a_temp
   900  vec  (   4): Vectorized array expression.
   900  vec  (  29): ADB is used for array.: xyz_dqvapsatdtemp
   946  opt  (  11): Fused array assignments. :line 946 - 947
  1057  opt  (  11): Fused array assignments. :line 1057 - 1058
  1057  opt  (1592): Outer loop unrolled inside inner loop.
  1057  vec  (   4): Vectorized array expression.
  1057  vec  (  29): ADB is used for array.: xyz_press
  1057  vec  (  29): ADB is used for array.: xy_press
  1057  vec  (  29): ADB is used for array.: xyz_temp
  1057  vec  (  29): ADB is used for array.: xy_temp
  1057  vec  (   4): Vectorized array expression.
  1057  vec  (  29): ADB is used for array.: xyz_press
  1057  vec  (  29): ADB is used for array.: xy_press
  1057  vec  (  29): ADB is used for array.: xyz_temp
  1057  vec  (  29): ADB is used for array.: xy_temp
  1062  opt  (1592): Outer loop unrolled inside inner loop.
  1062  vec  (   4): Vectorized array expression.
  1062  vec  (  29): ADB is used for array.: xyz_qvapsat
  1062  vec  (   4): Vectorized array expression.
  1062  vec  (  29): ADB is used for array.: xyz_qvapsat
  1109  opt  (  11): Fused array assignments. :line 1109 - 1110
  1109  opt  (1592): Outer loop unrolled inside inner loop.
  1109  vec  (   4): Vectorized array expression.
  1109  vec  (  29): ADB is used for array.: xyz_qvapsat
  1109  vec  (  29): ADB is used for array.: xy_qvapsat
  1109  vec  (  29): ADB is used for array.: xyz_temp
  1109  vec  (  29): ADB is used for array.: xy_temp
  1109  vec  (   4): Vectorized array expression.
  1109  vec  (  29): ADB is used for array.: xyz_qvapsat
  1109  vec  (  29): ADB is used for array.: xy_qvapsat
  1109  vec  (  29): ADB is used for array.: xyz_temp
  1109  vec  (  29): ADB is used for array.: xy_temp
  1114  opt  (1592): Outer loop unrolled inside inner loop.
  1114  vec  (   4): Vectorized array expression.
  1114  vec  (  29): ADB is used for array.: xyz_dqvapsatdtemp
  1114  vec  (   4): Vectorized array expression.
  1114  vec  (  29): ADB is used for array.: xyz_dqvapsatdtemp
  1160  opt  (  11): Fused array assignments. :line 1160 - 1161
  1160  vec  (   4): Vectorized array expression.
  1160  vec  (  29): ADB is used for array.: xyz_press
  1160  vec  (  29): ADB is used for array.: a_press
  1160  vec  (  29): ADB is used for array.: xyz_temp
  1160  vec  (  29): ADB is used for array.: a_temp
  1165  vec  (   4): Vectorized array expression.
  1165  vec  (  29): ADB is used for array.: xyz_qvapsat
  1217  opt  (  11): Fused array assignments. :line 1217 - 1218
  1217  vec  (   4): Vectorized array expression.
  1217  vec  (  29): ADB is used for array.: xyz_qvapsat
  1217  vec  (  29): ADB is used for array.: a_qvapsat
  1217  vec  (  29): ADB is used for array.: xyz_temp
  1217  vec  (  29): ADB is used for array.: a_temp
  1222  vec  (   4): Vectorized array expression.
  1222  vec  (  29): ADB is used for array.: xyz_dqvapsatdtemp
  1268  opt  (  11): Fused array assignments. :line 1268 - 1269
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:27 2016
FILE NAME: i.saturate.F90
PROGRAM NAME: saturate
TRANSFORMATION LIST

  LINE                   FORTRAN STATEMENT

     1  != 飽和比湿の算出
     2  !
     3  != Evaluate saturation specific humidity
     4  !
     5  ! Authors::   Yoshiyuki O. Takahashi
     6  ! Version::   $Id: saturate.F90,v 1.7 2015/01/29 12:07:16 yot Exp $
     7  ! Tag Name::  $Name:  $
     8  ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9  ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10  !
    11  
    12  module saturate
    13    !
    14    != 飽和比湿の算出
    15    !
    16    != Evaluate saturation specific humidity
    17    !
    18    ! <b>Note that Japanese and English are described in parallel.</b>
    19    !
    20    ! 飽和比湿および飽和比湿の温度微分の値を算出します.
    21    !
    22    ! Saturation specific humidity and temperature derivative of it are calculated.
    23    !
    24    ! 飽和比湿の計算にはデフォルトでは, Dennou AGCM で用いた式を用いる
    25    ! (saturate_DennouAGCM 参照).
    26    ! また, Config.mk の CPPFLAGS に -DLIB_SATURATE_NHA1992 を指定すると
    27    ! Nakajima et al. (1992) を用いる (saturate_tnha1992 参照).
    28    !
    29    ! By default, a formula used by Dennou AGCM is used for calculation of
    30    ! saturation specific humidity (See "saturate_DennouAGCM").
    31    ! If "-DLIB_SATURATE_NHA1992" is specified to "CPPFLAGS" in Config.mk,
    32    ! Nakajima et al. (1992) is used (See "saturate_nha1992").
    33    !
    34    !== References
    35    !
    36    !== Procedures List
    37    !
    38    ! CalcQVapSat            :: 飽和比湿の計算
    39    ! CalcDQVapSatDTemp      :: 飽和比湿の温度微分の計算
    40    ! ------------  :: ------------
    41    ! CalcQVapSat            :: Calculate saturation specific humidity
    42    ! CalcDQVapSatDTemp      :: Calculate temperature derivative of saturation specific humidity
    43    !
    44    !--
    45    !== NAMELIST
    46    !
    47    ! NAMELIST#saturate_nml
    48    !++
    49  
    50    ! モジュール引用 ; USE statements
    51    !
    52  
    53    ! 種別型パラメタ
    54    ! Kind type parameter
    55    !
    56    use dc_types, only: DP, &      ! 倍精度実数型. Double precision.
    57      &                 STRING     ! 文字列.       Strings.
    58  
    59    ! メッセージ出力
    60    ! Message output
    61    !
    62    use dc_message, only: MessageNotify
    63  
    64  
    65  
    66    ! Dennou AGCM の式を用いた飽和比湿の算出
    67    ! Evaluate saturation specific humidity with method used by Dennou AGCM
    68    !
    69    use saturate_DennouAGCM, only:                          &
    70  
    71      & xyz_CalcQVapSatOnLiq,       &
    72      & xyz_CalcDQVapSatDTempOnLiq, &
    73      & xyz_CalcQVapSatOnSol,       &
    74      & xyz_CalcDQVapSatDTempOnSol, &
    75      & SaturateInitCore => SaturateInit
    76  
    77  
    78    ! 宣言文 ; Declaration statements
    79    !
    80    implicit none
    81    private
    82  
    83    ! 公開手続き
    84    ! Public procedure
    85    !
    86    public:: SaturateWatFraction
    87  
    88    public:: xyz_CalcQVapSat
    89    public:: xyz_CalcDQVapSatDTemp
    90    public:: xy_CalcQVapSat
    91    public:: xy_CalcDQVapSatDTemp
    92    public:: a_CalcQVapSat
    93    public:: a_CalcDQVapSatDTemp
    94    public:: CalcQVapSat
    95    public:: CalcDQVapSatDTemp
    96  
    97    public:: xyz_CalcQVapSatOnLiq
    98    public:: xyz_CalcDQVapSatDTempOnLiq
    99    public:: xy_CalcQVapSatOnLiq
   100    public:: xy_CalcDQVapSatDTempOnLiq
   101    public:: a_CalcQVapSatOnLiq
   102    public:: a_CalcDQVapSatDTempOnLiq
   103    public:: CalcQVapSatOnLiq
   104    public:: CalcDQVapSatDTempOnLiq
   105  
   106    public:: xyz_CalcQVapSatOnSol
   107    public:: xyz_CalcDQVapSatDTempOnSol
   108    public:: xy_CalcQVapSatOnSol
   109    public:: xy_CalcDQVapSatDTempOnSol
   110    public:: a_CalcQVapSatOnSol
   111    public:: a_CalcDQVapSatDTempOnSol
   112    public:: CalcQVapSatOnSol
   113    public:: CalcDQVapSatDTempOnSol
   114  
   115    public:: SaturateInit
   116  
   117  
   118    ! 公開変数
   119    ! Public variables
   120    !
   121    logical, save, public:: saturate_inited = .false.
   122                                ! 初期設定フラグ.
   123                                ! Initialization flag
   124  
   125    ! 非公開変数
   126    ! Private variables
   127    !
   128    integer , save        :: IDWatIceFracMethod
   129    integer , parameter   :: IDWatIceFracMethodLin  = 1
   130    integer , parameter   :: IDWatIceFracMethodQuad = 2
   131    real(DP), save        :: TempWatLim
   132    real(DP), save        :: TempIceLim
   133  
   134  
   135    character(*), parameter:: saturate_scheme = &
   136  
   137      & 'Dennou AGCM'
   138  
   139    character(*), parameter:: module_name = 'saturate'
   140                                ! モジュールの名称.
   141                                ! Module name
   142  
   143    character(*), parameter:: version = &
   144      & '$Name:  $' // &
   145      & '$Id: saturate.F90,v 1.7 2015/01/29 12:07:16 yot Exp $'
   146                                ! モジュールのバージョン
   147                                ! Module version
   148  
   149    interface SaturateWatFraction
   150      module procedure &
   151        & SaturateWatFraction3D, &
   152        & SaturateWatFraction0D
   153    end interface SaturateWatFraction
   154  
   155    !--------------------------------------------------------------------------------------
   156  
   157  contains
   158  
   159    !--------------------------------------------------------------------------------------
   160  
   161    subroutine SaturateWatFraction3D( &
   162      & xyz_Temp,                     & ! (in )
   163      & xyz_WatFrac                   & ! (out)
   164      & )
   165  
   166      ! USE statements
   167      !
   168  
   169  !!$    real(DP), intent(in ) :: xyz_Temp   (0:imax-1, 1:jmax, 1:kmax)
   170  !!$    real(DP), intent(out) :: xyz_WatFrac(0:imax-1, 1:jmax, 1:kmax)
   171      real(DP), intent(in ) :: xyz_Temp   (:,:,:)
   172      real(DP), intent(out) :: xyz_WatFrac(:,:,:)
   173  
   174  
   175      ! 実行文 ; Executable statement
   176      !
   177  
   178      ! 初期化確認
   179      ! Initialization check
   180      !
   181      if ( .not. saturate_inited ) then
   182        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   183      end if
   184  
   185  
   186  !!$    if ( FlagSnow ) then
   187  
   188      if ( TempWatLim == TempIceLim ) then
   189        xyz_WatFrac = ( sign( 1.0_DP, xyz_Temp - TempWatLim ) + 1.0_DP ) / 2.0_DP
     .        if (1 + xyz_temp.DSC.U2 - min0(1,xyz_temp.DSC.U2) .gt. 0) then    
     .           j1 = and(1 + xyz_temp.DSC.U2 - min0(1,xyz_temp.DSC.U2),3)      
     .  !cdir    nodep                                                          
     .           do t122 = 1, j1                                                
     .              d1 = 1.D0/2.00000000000000e+000                             
     .  !cdir       nodep                                                       
     .              do t124 = 1, 1 + xyz_temp.DSC.U1 - min0(1,xyz_temp.DSC.U1)  
     .                 xyz_watfrac(t124,t122,t120+1) = (sign(                   
     .       1            1.00000000000000e+000,xyz_temp(t124,t122,t120+1)-     
     .       2            tempwatlim)+1.00000000000000e+000)*d1                 
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t122=j1+1,1+xyz_temp.DSC.U2-min0(1,xyz_temp.DSC.U2),4       
     .              d2 = 1.D0/2.00000000000000e+000                             
     .              d3 = 1.D0/2.00000000000000e+000                             
     .              d4 = 1.D0/2.00000000000000e+000                             
     .              d5 = 1.D0/2.00000000000000e+000                             
     .  !cdir       nodep                                                       
     .              do t124 = 1, 1 + xyz_temp.DSC.U1 - min0(1,xyz_temp.DSC.U1)  
     .                 xyz_watfrac(t124,t122,t120+1) = (sign(                   
     .       1            1.00000000000000e+000,xyz_temp(t124,t122,t120+1)-     
     .       2            tempwatlim)+1.00000000000000e+000)*d2                 
     .                 xyz_watfrac(t124,t122+1,t120+1) = (sign(                 
     .       1            1.00000000000000e+000,xyz_temp(t124,t122+1,t120+1)-   
     .       2            tempwatlim)+1.00000000000000e+000)*d3                 
     .                 xyz_watfrac(t124,t122+2,t120+1) = (sign(                 
     .       1            1.00000000000000e+000,xyz_temp(t124,t122+2,t120+1)-   
     .       2            tempwatlim)+1.00000000000000e+000)*d4                 
     .                 xyz_watfrac(t124,t122+3,t120+1) = (sign(                 
     .       1            1.00000000000000e+000,xyz_temp(t124,t122+3,t120+1)-   
     .       2            tempwatlim)+1.00000000000000e+000)*d5                 
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
   190      else
   191        select case ( IDWatIceFracMethod )
   192        case ( IDWatIceFracMethodLin  )
   193          xyz_WatFrac =   ( xyz_Temp - TempIceLim ) / ( TempWatLim - TempIceLim )
     .        if (1 + xyz_temp.DSC.U2 - min0(1,xyz_temp.DSC.U2) .gt. 0) then    
     .           j2 = and(1 + xyz_temp.DSC.U2 - min0(1,xyz_temp.DSC.U2),3)      
     .  !cdir    nodep                                                          
     .           do t110 = 1, j2                                                
     .              d6 = 1.D0/(tempwatlim - tempicelim)                         
     .  !cdir       nodep                                                       
     .              do t112 = 1, 1 + xyz_temp.DSC.U1 - min0(1,xyz_temp.DSC.U1)  
     .                 xyz_watfrac(t112,t110,t108+1) = (xyz_temp(t112,t110,t108+
     .       1            1)-tempicelim)*d6                                     
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t110=j2+1,1+xyz_temp.DSC.U2-min0(1,xyz_temp.DSC.U2),4       
     .              d7 = 1.D0/(tempwatlim - tempicelim)                         
     .              d8 = 1.D0/(tempwatlim - tempicelim)                         
     .              d9 = 1.D0/(tempwatlim - tempicelim)                         
     .              d10 = 1.D0/(tempwatlim - tempicelim)                        
     .  !cdir       nodep                                                       
     .              do t112 = 1, 1 + xyz_temp.DSC.U1 - min0(1,xyz_temp.DSC.U1)  
     .                 xyz_watfrac(t112,t110,t108+1) = (xyz_temp(t112,t110,t108+
     .       1            1)-tempicelim)*d7                                     
     .                 xyz_watfrac(t112,t110+1,t108+1) = (xyz_temp(t112,t110+1, 
     .       1            t108+1)-tempicelim)*d8                                
     .                 xyz_watfrac(t112,t110+2,t108+1) = (xyz_temp(t112,t110+2, 
     .       1            t108+1)-tempicelim)*d9                                
     .                 xyz_watfrac(t112,t110+3,t108+1) = (xyz_temp(t112,t110+3, 
     .       1            t108+1)-tempicelim)*d10                               
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
   194        case ( IDWatIceFracMethodQuad )
   195          xyz_WatFrac = ( max( xyz_Temp - TempIceLim, 0.0_DP ) / ( TempWatLim - TempIceLim ) )**2
     .        if (xyz_temp.DSC.U2 .gt. 0) then                                  
     .           j3 = and(xyz_temp.DSC.U2,3)                                    
     .  !cdir    nodep                                                          
     .           do t98 = 1, j3                                                 
     .              d11 = 1.D0/(tempwatlim - tempicelim)                        
     .  !cdir       nodep                                                       
     .              do t100 = 1, xyz_temp.DSC.U1                                
     .                 xyz_watfrac(t100,t98,t96+1) = (max(xyz_temp(t100,t98,t96+
     .       1            1)-tempicelim,0.0000000000000000e+000)*d11)**2        
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t98 = j3 + 1, xyz_temp.DSC.U2, 4                            
     .              d12 = 1.D0/(tempwatlim - tempicelim)                        
     .              d13 = 1.D0/(tempwatlim - tempicelim)                        
     .              d14 = 1.D0/(tempwatlim - tempicelim)                        
     .              d15 = 1.D0/(tempwatlim - tempicelim)                        
     .  !cdir       nodep                                                       
     .              do t100 = 1, xyz_temp.DSC.U1                                
     .                 xyz_watfrac(t100,t98,t96+1) = (max(xyz_temp(t100,t98,t96+
     .       1            1)-tempicelim,0.0000000000000000e+000)*d12)**2        
     .                 xyz_watfrac(t100,t98+1,t96+1) = (max(xyz_temp(t100,t98+1,
     .       1            t96+1)-tempicelim,0.0000000000000000e+000)*d13)**2    
     .                 xyz_watfrac(t100,t98+2,t96+1) = (max(xyz_temp(t100,t98+2,
     .       1            t96+1)-tempicelim,0.0000000000000000e+000)*d14)**2    
     .                 xyz_watfrac(t100,t98+3,t96+1) = (max(xyz_temp(t100,t98+3,
     .       1            t96+1)-tempicelim,0.0000000000000000e+000)*d15)**2    
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
   196        end select
   197        xyz_WatFrac = max( min( xyz_WatFrac, 1.0_DP ), 0.0_DP )
     .        if (xyz_watfrac.DSC.U2 .gt. 0) then                               
     .           j4 = and(xyz_watfrac.DSC.U2,3)                                 
     .  !cdir    nodep                                                          
     .           do t86 = 1, j4                                                 
     .  !cdir       nodep                                                       
     .              do t88 = 1, xyz_watfrac.DSC.U1                              
     .                 xyz_watfrac(t88,t86,t84+1) = max(min(xyz_watfrac(t88,t86,
     .       1            t84+1),1.00000000000000e+000),0.0000000000000000e+000)
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t86 = j4 + 1, xyz_watfrac.DSC.U2, 4                         
     .  !cdir       nodep                                                       
     .              do t88 = 1, xyz_watfrac.DSC.U1                              
     .                 xyz_watfrac(t88,t86,t84+1) = max(min(xyz_watfrac(t88,t86,
     .       1            t84+1),1.00000000000000e+000),0.0000000000000000e+000)
     .                 xyz_watfrac(t88,t86+1,t84+1) = max(min(xyz_watfrac(t88,  
     .       1            t86+1,t84+1),1.00000000000000e+000),                  
     .       2            0.0000000000000000e+000)                              
     .                 xyz_watfrac(t88,t86+2,t84+1) = max(min(xyz_watfrac(t88,  
     .       1            t86+2,t84+1),1.00000000000000e+000),                  
     .       2            0.0000000000000000e+000)                              
     .                 xyz_watfrac(t88,t86+3,t84+1) = max(min(xyz_watfrac(t88,  
     .       1            t86+3,t84+1),1.00000000000000e+000),                  
     .       2            0.0000000000000000e+000)                              
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
   198      end if
   199  
   200  !!$    else
   201  !!$
   202  !!$      xyz_WatFrac = 1.0_DP
   203  !!$
   204  !!$    end if
   205  
   206  
   207    end subroutine SaturateWatFraction3D
   208  
   209    !--------------------------------------------------------------------------------------
   210  
   211    subroutine SaturateWatFraction0D( &
   212      & Temp,                       & ! (in )
   213      & WatFrac                     & ! (out)
   214      & )
   215  
   216      ! USE statements
   217      !
   218  
   219      real(DP), intent(in ) :: Temp
   220      real(DP), intent(out) :: WatFrac
   221  
   222  
   223      real(DP) :: xyz_Temp   (1,1,1)
   224      real(DP) :: xyz_WatFrac(1,1,1)
   225  
   226      ! 実行文 ; Executable statement
   227      !
   228  
   229      ! 初期化確認
   230      ! Initialization check
   231      !
   232      if ( .not. saturate_inited ) then
   233        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   234      end if
   235  
   236  
   237      xyz_Temp = Temp
     .        xyz_temp(1,1,1) = temp                                            
   238      call SaturateWatFraction3D( &
   239        & xyz_Temp,               & ! (in )
   240        & xyz_WatFrac             & ! (out)
   241        & )
   242      WatFrac = xyz_WatFrac(1,1,1)
   243  
   244  
   245    end subroutine SaturateWatFraction0D
   246  
   247    !-------------------------------------------------------------------
   248    ! [Mixed phase]
   249    !-------------------------------------------------------------------
   250  
   251    function xyz_CalcQVapSat( xyz_Temp, xyz_Press ) result( xyz_QVapSat )
   252      !
   253      ! 温度 *Temp* と気圧 *Press* を用い,
   254      ! 飽和比湿 *QVapSat* を求めます.
   255      !
   256      ! Calculate saturation specific humidity *QVapSat* using
   257      ! temperature *Temp* and air pressure *Press*.
   258      !
   259  
   260      ! モジュール引用 ; USE statements
   261      !
   262  
   263  
   264      ! 宣言文 ; Declaration statements
   265      !
   266      implicit none
   267  
   268      real(DP), intent(in):: xyz_Temp (:,:,:)
   269                                ! $ T $ . 温度. Temperature
   270      real(DP), intent(in):: xyz_Press(:,:,:)
   271                                ! $ p $ . 気圧. Air pressure
   272  
   273      real(DP):: xyz_QVapSat(1:size(xyz_Temp,1), 1:size(xyz_Temp,2), 1:size(xyz_Temp,3))
   274                                ! $ q^{*} $ . 飽和比湿. Saturation specific humidity
   275  
   276      ! 作業変数
   277      ! Work variables
   278      !
   279      real(DP):: xyz_QVapSatOnLiq(1:size(xyz_Temp,1), 1:size(xyz_Temp,2), 1:size(xyz_Temp,3))
   280      real(DP):: xyz_QVapSatOnSol(1:size(xyz_Temp,1), 1:size(xyz_Temp,2), 1:size(xyz_Temp,3))
   281      real(DP):: xyz_WatFrac     (1:size(xyz_Temp,1), 1:size(xyz_Temp,2), 1:size(xyz_Temp,3))
   282  
   283  
   284      ! 実行文 ; Executable statement
   285      !
   286  
   287      ! 初期化確認
   288      ! Initialization check
   289      !
   290  
   291      if ( .not. saturate_inited ) then
   292        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   293      end if
   294  
   295  
   296      xyz_QVapSatOnLiq = xyz_CalcQVapSatOnLiq( xyz_Temp, xyz_Press )
   297      xyz_QVapSatOnSol = xyz_CalcQVapSatOnSol( xyz_Temp, xyz_Press )
   298  
   299      call SaturateWatFraction( &
   300        & xyz_Temp,             & ! (in )
   301        & xyz_WatFrac           & ! (out)
   302        & )
   303  
   304      xyz_QVapSat =                                     &
     .        if (xyz_watfrac.DSC.U2 .gt. 0) then                               
     .           j13 = and(xyz_watfrac.DSC.U2,3)                                
     .  !cdir    nodep                                                          
     .           do t146 = 1, j13                                               
     .  !cdir       nodep                                                       
     .              do t148 = 1, xyz_watfrac.DSC.U1                             
     .                 xyz_qvapsat(t148,t146,t144+1) = xyz_watfrac(t148,t146,   
     .       1            t144+1)*xyz_qvapsatonliq(t148,t146,t144+1) + (        
     .       2            1.00000000000000e+000 - xyz_watfrac(t148,t146,t144+1))
     .       3            *xyz_qvapsatonsol(t148,t146,t144+1)                   
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t146 = j13 + 1, xyz_watfrac.DSC.U2, 4                       
     .  !cdir       nodep                                                       
     .              do t148 = 1, xyz_watfrac.DSC.U1                             
     .                 xyz_qvapsat(t148,t146,t144+1) = xyz_watfrac(t148,t146,   
     .       1            t144+1)*xyz_qvapsatonliq(t148,t146,t144+1) + (        
     .       2            1.00000000000000e+000 - xyz_watfrac(t148,t146,t144+1))
     .       3            *xyz_qvapsatonsol(t148,t146,t144+1)                   
     .                 xyz_qvapsat(t148,t146+1,t144+1) = xyz_watfrac(t148,t146+1
     .       1            ,t144+1)*xyz_qvapsatonliq(t148,t146+1,t144+1) + (     
     .       2            1.00000000000000e+000 - xyz_watfrac(t148,t146+1,t144+1
     .       3            ))*xyz_qvapsatonsol(t148,t146+1,t144+1)               
     .                 xyz_qvapsat(t148,t146+2,t144+1) = xyz_watfrac(t148,t146+2
     .       1            ,t144+1)*xyz_qvapsatonliq(t148,t146+2,t144+1) + (     
     .       2            1.00000000000000e+000 - xyz_watfrac(t148,t146+2,t144+1
     .       3            ))*xyz_qvapsatonsol(t148,t146+2,t144+1)               
     .                 xyz_qvapsat(t148,t146+3,t144+1) = xyz_watfrac(t148,t146+3
     .       1            ,t144+1)*xyz_qvapsatonliq(t148,t146+3,t144+1) + (     
     .       2            1.00000000000000e+000 - xyz_watfrac(t148,t146+3,t144+1
     .       3            ))*xyz_qvapsatonsol(t148,t146+3,t144+1)               
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
   305        &   xyz_WatFrac              * xyz_QVapSatOnLiq &
   306        & + ( 1.0_DP - xyz_WatFrac ) * xyz_QVapSatOnSol
   307  
   308  
   309    end function xyz_CalcQVapSat
   310  
   311    !--------------------------------------------------------------------------------------
   312  
   313    function xyz_CalcDQVapSatDTemp( xyz_Temp, xyz_QVapSat ) result( xyz_DQVapSatDTemp )
   314      !
   315      ! 温度 *Temp* と飽和比湿 *QVapSat* を用い,
   316      ! 飽和比湿の温度微分 *DQVapSatDTemp* を求めます.
   317      !
   318      ! Calculate temperature derivative of saturation specific humidity
   319      ! *DQVapSatDTemp* using
   320      ! temperature *Temp* and saturation specific humidity *QVapSat*.
   321      !
   322  
   323      ! モジュール引用 ; USE statements
   324      !
   325  
   326      ! 宣言文 ; Declaration statements
   327      !
   328      implicit none
   329  
   330      real(DP), intent(in):: xyz_Temp   (:,:,:)
   331                                ! $ T $ . 温度. Temperature
   332      real(DP), intent(in):: xyz_QVapSat(:,:,:)
   333                                ! $ q^{*} $ . 飽和比湿. Saturation specific humidity
   334      real(DP):: xyz_DQVapSatDTemp(size(xyz_Temp,1), size(xyz_Temp,2), size(xyz_Temp,3))
   335                                ! $ \DP{q^{*}}{T} $ . 飽和比湿の温度微分.
   336                                ! Temperature derivative of saturation specific humidity.
   337  
   338      ! 作業変数
   339      ! Work variables
   340      !
   341      real(DP):: xyz_DQVapSatDTempOnLiq(size(xyz_Temp,1), size(xyz_Temp,2), size(xyz_Temp,3))
   342      real(DP):: xyz_DQVapSatDTempOnSol(size(xyz_Temp,1), size(xyz_Temp,2), size(xyz_Temp,3))
   343      real(DP):: xyz_WatFrac           (size(xyz_Temp,1), size(xyz_Temp,2), size(xyz_Temp,3))
   344  
   345  
   346      ! 実行文 ; Executable statement
   347      !
   348  
   349      if ( .not. saturate_inited ) then
   350        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   351      end if
   352  
   353  
   354      xyz_DQVapSatDTempOnLiq = xyz_CalcDQVapSatDTempOnLiq( xyz_Temp, xyz_QVapSat )
   355      xyz_DQVapSatDTempOnSol = xyz_CalcDQVapSatDTempOnSol( xyz_Temp, xyz_QVapSat )
   356  
   357      call SaturateWatFraction( &
   358        & xyz_Temp,             & ! (in )
   359        & xyz_WatFrac           & ! (out)
   360        & )
   361  
   362      xyz_DQVapSatDTemp =                                     &
     .        if (xyz_watfrac.DSC.U2 .gt. 0) then                               
     .           j13 = and(xyz_watfrac.DSC.U2,3)                                
     .  !cdir    nodep                                                          
     .           do t146 = 1, j13                                               
     .  !cdir       nodep                                                       
     .              do t148 = 1, xyz_watfrac.DSC.U1                             
     .                 xyz_dqvapsatdtemp(t148,t146,t144+1) = xyz_watfrac(t148,  
     .       1            t146,t144+1)*xyz_dqvapsatdtemponliq(t148,t146,t144+1) 
     .       2             + (1.00000000000000e+000 - xyz_watfrac(t148,t146,t144
     .       3            +1))*xyz_dqvapsatdtemponsol(t148,t146,t144+1)         
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t146 = j13 + 1, xyz_watfrac.DSC.U2, 4                       
     .  !cdir       nodep                                                       
     .              do t148 = 1, xyz_watfrac.DSC.U1                             
     .                 xyz_dqvapsatdtemp(t148,t146,t144+1) = xyz_watfrac(t148,  
     .       1            t146,t144+1)*xyz_dqvapsatdtemponliq(t148,t146,t144+1) 
     .       2             + (1.00000000000000e+000 - xyz_watfrac(t148,t146,t144
     .       3            +1))*xyz_dqvapsatdtemponsol(t148,t146,t144+1)         
     .                 xyz_dqvapsatdtemp(t148,t146+1,t144+1) = xyz_watfrac(t148,
     .       1            t146+1,t144+1)*xyz_dqvapsatdtemponliq(t148,t146+1,t144
     .       2            +1) + (1.00000000000000e+000 - xyz_watfrac(t148,t146+1
     .       3            ,t144+1))*xyz_dqvapsatdtemponsol(t148,t146+1,t144+1)  
     .                 xyz_dqvapsatdtemp(t148,t146+2,t144+1) = xyz_watfrac(t148,
     .       1            t146+2,t144+1)*xyz_dqvapsatdtemponliq(t148,t146+2,t144
     .       2            +1) + (1.00000000000000e+000 - xyz_watfrac(t148,t146+2
     .       3            ,t144+1))*xyz_dqvapsatdtemponsol(t148,t146+2,t144+1)  
     .                 xyz_dqvapsatdtemp(t148,t146+3,t144+1) = xyz_watfrac(t148,
     .       1            t146+3,t144+1)*xyz_dqvapsatdtemponliq(t148,t146+3,t144
     .       2            +1) + (1.00000000000000e+000 - xyz_watfrac(t148,t146+3
     .       3            ,t144+1))*xyz_dqvapsatdtemponsol(t148,t146+3,t144+1)  
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
   363        &   xyz_WatFrac              * xyz_DQVapSatDTempOnLiq &
   364        & + ( 1.0_DP - xyz_WatFrac ) * xyz_DQVapSatDTempOnSol
   365  
   366  
   367    end function xyz_CalcDQVapSatDTemp
   368  
   369    !-------------------------------------------------------------------
   370    ! [Mixed phase] Interfaces for 2D, 1D, and scalar variables
   371    !-------------------------------------------------------------------
   372  
   373    function xy_CalcQVapSat( xy_Temp, xy_Press ) result( xy_QVapSat )
   374      !
   375      ! 温度 *Temp* と気圧 *Press* を用い,
   376      ! 飽和比湿 *QVapSat* を求めます.
   377      !
   378      ! Calculate saturation specific humidity *QVapSat* using
   379      ! temperature *Temp* and air pressure *Press*.
   380      !
   381  
   382      ! モジュール引用 ; USE statements
   383      !
   384  
   385      ! 宣言文 ; Declaration statements
   386      !
   387      implicit none
   388  
   389      real(DP), intent(in):: xy_Temp (:,:)
   390                                ! $ T $ . 温度. Temperature
   391      real(DP), intent(in):: xy_Press(:,:)
   392                                ! $ p $ . 気圧. Air pressure
   393  
   394      real(DP):: xy_QVapSat(size(xy_Temp,1), size(xy_Temp,2))
   395                                ! $ q^{*} $ . 飽和比湿. Saturation specific humidity
   396  
   397      ! 作業変数
   398      ! Work variables
   399      !
   400      real(DP) :: xyz_Temp   (size(xy_Temp,1),size(xy_Temp,2),1)
   401      real(DP) :: xyz_Press  (size(xy_Temp,1),size(xy_Temp,2),1)
   402      real(DP) :: xyz_QVapSat(size(xy_Temp,1),size(xy_Temp,2),1)
   403  
   404  
   405      ! 実行文 ; Executable statement
   406      !
   407  
   408      if ( .not. saturate_inited ) then
   409        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   410      end if
   411  
   412  
   413      xyz_Temp (:,:,1) = xy_Temp
     .        if (xyz_temp.DSC.U2 .gt. 0) then                                  
     .           j9 = and(xyz_temp.DSC.U2,3)                                    
     .  !cdir    nodep                                                          
     .           do t99 = 1, j9                                                 
     .  !cdir       nodep                                                       
     .              do t101 = 1, xyz_temp.DSC.U1                                
     .                 xyz_temp(t101,t99,1) = xy_temp(t101,t99)                 
     .                 xyz_press(t101,t99,1) = xy_press(t101,t99)               
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t99 = j9 + 1, xyz_temp.DSC.U2, 4                            
     .  !cdir       nodep                                                       
     .              do t101 = 1, xyz_temp.DSC.U1                                
     .                 xyz_temp(t101,t99,1) = xy_temp(t101,t99)                 
     .                 xyz_temp(t101,t99+1,1) = xy_temp(t101,t99+1)             
     .                 xyz_temp(t101,t99+2,1) = xy_temp(t101,t99+2)             
     .                 xyz_temp(t101,t99+3,1) = xy_temp(t101,t99+3)             
     .                 xyz_press(t101,t99,1) = xy_press(t101,t99)               
     .                 xyz_press(t101,t99+1,1) = xy_press(t101,t99+1)           
     .                 xyz_press(t101,t99+2,1) = xy_press(t101,t99+2)           
     .                 xyz_press(t101,t99+3,1) = xy_press(t101,t99+3)           
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
   414      xyz_Press(:,:,1) = xy_Press
   415  
   416      xyz_QVapSat = xyz_CalcQVapSat( xyz_Temp, xyz_Press )
   417  
   418      xy_QVapSat = xyz_QVapSat(:,:,1)
     .        if (xy_qvapsat.DESCRIPT.RETVAL.DSC.U2 .gt. 0) then                
     .           j10 = and(xy_qvapsat.DESCRIPT.RETVAL.DSC.U2,3)                 
     .  !cdir    nodep                                                          
     .           do t111 = 1, j10                                               
     .  !cdir       nodep                                                       
     .              do t113 = 1, xy_qvapsat.DESCRIPT.RETVAL.DSC.U1              
     .                 xy_qvapsat(t113,t111) = xyz_qvapsat(t113,t111,1)         
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t111 = j10 + 1, xy_qvapsat.DESCRIPT.RETVAL.DSC.U2, 4        
     .  !cdir       nodep                                                       
     .              do t113 = 1, xy_qvapsat.DESCRIPT.RETVAL.DSC.U1              
     .                 xy_qvapsat(t113,t111) = xyz_qvapsat(t113,t111,1)         
     .                 xy_qvapsat(t113,t111+1) = xyz_qvapsat(t113,t111+1,1)     
     .                 xy_qvapsat(t113,t111+2) = xyz_qvapsat(t113,t111+2,1)     
     .                 xy_qvapsat(t113,t111+3) = xyz_qvapsat(t113,t111+3,1)     
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
   419  
   420  
   421    end function xy_CalcQVapSat
   422  
   423    !-------------------------------------------------------------------
   424  
   425    function xy_CalcDQVapSatDTemp( xy_Temp, xy_QVapSat ) result( xy_DQVapSatDTemp )
   426      !
   427      ! 温度 *Temp* と飽和比湿 *QVapSat* を用い,
   428      ! 飽和比湿の温度微分 *DQVapSatDTemp* を求めます.
   429      !
   430      ! Calculate temperature derivative of saturation specific humidity
   431      ! *DQVapSatDTemp* using
   432      ! temperature *Temp* and saturation specific humidity *QVapSat*.
   433      !
   434  
   435      ! モジュール引用 ; USE statements
   436      !
   437  
   438      ! 宣言文 ; Declaration statements
   439      !
   440      implicit none
   441  
   442      real(DP), intent(in):: xy_Temp   (:,:)
   443                                ! $ T $ . 温度. Temperature
   444      real(DP), intent(in):: xy_QVapSat(:,:)
   445                                ! $ q^{*} $ . 飽和比湿. Saturation specific humidity
   446      real(DP):: xy_DQVapSatDTemp(size(xy_Temp,1), size(xy_Temp,2))
   447                                ! $ \DP{q^{*}}{T} $ . 飽和比湿の温度微分.
   448                                ! Temperature derivative of saturation specific humidity.
   449  
   450      ! 作業変数
   451      ! Work variables
   452      !
   453      real(DP):: xyz_Temp         (size(xy_Temp,1), size(xy_Temp,2), 1)
   454      real(DP):: xyz_QVapSat      (size(xy_Temp,1), size(xy_Temp,2), 1)
   455      real(DP):: xyz_DQVapSatDTemp(size(xy_Temp,1), size(xy_Temp,2), 1)
   456  
   457      ! 実行文 ; Executable statement
   458      !
   459  
   460      if ( .not. saturate_inited ) then
   461        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   462      end if
   463  
   464  
   465      xyz_Temp   (:,:,1) = xy_Temp
     .        if (xyz_temp.DSC.U2 .gt. 0) then                                  
     .           j9 = and(xyz_temp.DSC.U2,3)                                    
     .  !cdir    nodep                                                          
     .           do t99 = 1, j9                                                 
     .  !cdir       nodep                                                       
     .              do t101 = 1, xyz_temp.DSC.U1                                
     .                 xyz_temp(t101,t99,1) = xy_temp(t101,t99)                 
     .                 xyz_qvapsat(t101,t99,1) = xy_qvapsat(t101,t99)           
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t99 = j9 + 1, xyz_temp.DSC.U2, 4                            
     .  !cdir       nodep                                                       
     .              do t101 = 1, xyz_temp.DSC.U1                                
     .                 xyz_temp(t101,t99,1) = xy_temp(t101,t99)                 
     .                 xyz_temp(t101,t99+1,1) = xy_temp(t101,t99+1)             
     .                 xyz_temp(t101,t99+2,1) = xy_temp(t101,t99+2)             
     .                 xyz_temp(t101,t99+3,1) = xy_temp(t101,t99+3)             
     .                 xyz_qvapsat(t101,t99,1) = xy_qvapsat(t101,t99)           
     .                 xyz_qvapsat(t101,t99+1,1) = xy_qvapsat(t101,t99+1)       
     .                 xyz_qvapsat(t101,t99+2,1) = xy_qvapsat(t101,t99+2)       
     .                 xyz_qvapsat(t101,t99+3,1) = xy_qvapsat(t101,t99+3)       
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
   466      xyz_QVapSat(:,:,1) = xy_QVapSat
   467  
   468      xyz_DQVapSatDTemp = xyz_CalcDQVapSatDTemp( xyz_Temp, xyz_QVapSat )
   469  
   470      xy_DQVapSatDTemp = xyz_DQVapSatDTemp(:,:,1)
     .        if (xy_dqvapsatdtemp.DESCRIPT.RETVAL.DSC.U2 .gt. 0) then          
     .           j10 = and(xy_dqvapsatdtemp.DESCRIPT.RETVAL.DSC.U2,3)           
     .  !cdir    nodep                                                          
     .           do t111 = 1, j10                                               
     .  !cdir       nodep                                                       
     .              do t113 = 1, xy_dqvapsatdtemp.DESCRIPT.RETVAL.DSC.U1        
     .                 xy_dqvapsatdtemp(t113,t111) = xyz_dqvapsatdtemp(t113,t111
     .       1            ,1)                                                   
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t111 = j10 + 1, xy_dqvapsatdtemp.DESCRIPT.RETVAL.DSC.U2, 4  
     .  !cdir       nodep                                                       
     .              do t113 = 1, xy_dqvapsatdtemp.DESCRIPT.RETVAL.DSC.U1        
     .                 xy_dqvapsatdtemp(t113,t111) = xyz_dqvapsatdtemp(t113,t111
     .       1            ,1)                                                   
     .                 xy_dqvapsatdtemp(t113,t111+1) = xyz_dqvapsatdtemp(t113,  
     .       1            t111+1,1)                                             
     .                 xy_dqvapsatdtemp(t113,t111+2) = xyz_dqvapsatdtemp(t113,  
     .       1            t111+2,1)                                             
     .                 xy_dqvapsatdtemp(t113,t111+3) = xyz_dqvapsatdtemp(t113,  
     .       1            t111+3,1)                                             
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
   471  
   472  
   473    end function xy_CalcDQVapSatDTemp
   474  
   475    !--------------------------------------------------------------------------------------
   476  
   477    function a_CalcQVapSat( a_Temp, a_Press ) result( a_QVapSat )
   478      !
   479      ! 温度 *Temp* と気圧 *Press* を用い,
   480      ! 飽和比湿 *QVapSat* を求めます.
   481      !
   482      ! Calculate saturation specific humidity *QVapSat* using
   483      ! temperature *Temp* and air pressure *Press*.
   484      !
   485  
   486      ! モジュール引用 ; USE statements
   487      !
   488  
   489      ! 宣言文 ; Declaration statements
   490      !
   491      implicit none
   492  
   493      real(DP), intent(in):: a_Temp (:)
   494                                ! $ T $ . 温度. Temperature
   495      real(DP), intent(in):: a_Press(:)
   496                                ! $ p $ . 気圧. Air pressure
   497  
   498      real(DP):: a_QVapSat(size(a_Temp,1))
   499                                ! $ q^{*} $ . 飽和比湿. Saturation specific humidity
   500  
   501      ! 作業変数
   502      ! Work variables
   503      !
   504      real(DP):: xyz_Temp   (size(a_Temp,1), 1, 1)
   505                                ! $ T $ . 温度. Temperature
   506      real(DP):: xyz_Press  (size(a_Temp,1), 1, 1)
   507                                ! $ p $ . 気圧. Air pressure
   508      real(DP):: xyz_QVapSat(size(a_Temp,1), 1, 1)
   509                                ! $ q^{*} $ . 飽和比湿. Saturation specific humidity
   510  
   511      if ( .not. saturate_inited ) then
   512        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   513      end if
   514  
   515  
   516      xyz_Temp (:,1,1) = a_Temp
   517      xyz_Press(:,1,1) = a_Press
   518  
   519      xyz_QVapSat = xyz_CalcQVapSat( xyz_Temp, xyz_Press )
   520  
   521      a_QVapSat = xyz_QVapSat(:,1,1)
   522  
   523  
   524    end function a_CalcQVapSat
   525  
   526    !--------------------------------------------------------------------------------------
   527  
   528    function a_CalcDQVapSatDTemp( a_Temp, a_QVapSat ) result( a_DQVapSatDTemp )
   529      !
   530      ! 温度 *Temp* と飽和比湿 *QVapSat* を用い,
   531      ! 飽和比湿の温度微分 *DQVapSatDTemp* を求めます.
   532      !
   533      ! Calculate temperature derivative of saturation specific humidity
   534      ! *DQVapSatDTemp* using
   535      ! temperature *Temp* and saturation specific humidity *QVapSat*.
   536      !
   537  
   538      ! モジュール引用 ; USE statements
   539      !
   540  
   541      ! 宣言文 ; Declaration statements
   542      !
   543      implicit none
   544  
   545      real(DP), intent(in):: a_Temp   (:)
   546                                ! $ T $ . 温度. Temperature
   547      real(DP), intent(in):: a_QVapSat(:)
   548                                ! $ q^{*} $ . 飽和比湿. Saturation specific humidity
   549      real(DP):: a_DQVapSatDTemp(size(a_Temp,1))
   550                                ! $ \DP{q^{*}}{T} $ . 飽和比湿の温度微分.
   551                                ! Temperature derivative of saturation specific humidity.
   552  
   553      ! 作業変数
   554      ! Work variables
   555      !
   556      real(DP):: xyz_Temp   (size(a_Temp,1), 1:1, 1:1)
   557                                ! $ T $ . 温度. Temperature
   558      real(DP):: xyz_QVapSat(size(a_Temp,1), 1:1, 1:1)
   559                                ! $ q^{*} $ . 飽和比湿. Saturation specific humidity
   560      real(DP):: xyz_DQVapSatDTemp(size(a_Temp,1), 1:1, 1:1)
   561                                ! $ \DP{q^{*}}{T} $ . 飽和比湿の温度微分.
   562                                ! Temperature derivative of saturation specific humidity.
   563  
   564  
   565      ! 実行文 ; Executable statement
   566      !
   567  
   568      if ( .not. saturate_inited ) then
   569        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   570      end if
   571  
   572  
   573      xyz_Temp   (:,1,1) = a_Temp
   574      xyz_QVapSat(:,1,1) = a_QVapSat
   575  
   576      xyz_DQVapSatDTemp = xyz_CalcDQVapSatDTemp( xyz_Temp, xyz_QVapSat )
   577  
   578      a_DQVapSatDTemp = xyz_DQVapSatDTemp(:,1,1)
   579  
   580  
   581    end function a_CalcDQVapSatDTemp
   582  
   583    !--------------------------------------------------------------------------------------
   584  
   585    function CalcQVapSat( Temp, Press ) result( QVapSat )
   586      !
   587      ! 温度 *Temp* と気圧 *Press* を用い,
   588      ! 飽和比湿 *QVapSat* を求めます.
   589      !
   590      ! Calculate saturation specific humidity *QVapSat* using
   591      ! temperature *Temp* and air pressure *Press*.
   592      !
   593  
   594      ! モジュール引用 ; USE statements
   595      !
   596  
   597      ! 宣言文 ; Declaration statements
   598      !
   599      implicit none
   600  
   601      real(DP), intent(in):: Temp
   602                                ! $ T $ . 温度. Temperature
   603      real(DP), intent(in):: Press
   604                                ! $ p $ . 気圧. Air pressure
   605  
   606      real(DP):: QVapSat
   607                                ! $ q^{*} $ . 飽和比湿. Saturation specific humidity
   608  
   609      ! 作業変数
   610      ! Work variables
   611      !
   612      real(DP):: xyz_Temp   (1, 1, 1)
   613                                ! $ T $ . 温度. Temperature
   614      real(DP):: xyz_Press  (1, 1, 1)
   615                                ! $ p $ . 気圧. Air pressure
   616      real(DP):: xyz_QVapSat(1, 1, 1)
   617                                ! $ q^{*} $ . 飽和比湿. Saturation specific humidity
   618  
   619      if ( .not. saturate_inited ) then
   620        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   621      end if
   622  
   623  
   624      xyz_Temp (:,1,1) = Temp
     .        xyz_temp(1,1,1) = temp                                            
     .        xyz_press(1,1,1) = press                                          
   625      xyz_Press(:,1,1) = Press
   626  
   627      xyz_QVapSat = xyz_CalcQVapSat( xyz_Temp, xyz_Press )
   628  
   629      QVapSat = xyz_QVapSat(1,1,1)
   630  
   631  
   632    end function CalcQVapSat
   633  
   634    !--------------------------------------------------------------------------------------
   635  
   636    function CalcDQVapSatDTemp( Temp, QVapSat ) result( DQVapSatDTemp )
   637      !
   638      ! 温度 *Temp* と飽和比湿 *QVapSat* を用い,
   639      ! 飽和比湿の温度微分 *DQVapSatDTemp* を求めます.
   640      !
   641      ! Calculate temperature derivative of saturation specific humidity
   642      ! *DQVapSatDTemp* using
   643      ! temperature *Temp* and saturation specific humidity *QVapSat*.
   644      !
   645  
   646      ! モジュール引用 ; USE statements
   647      !
   648  
   649      ! 宣言文 ; Declaration statements
   650      !
   651      implicit none
   652  
   653      real(DP), intent(in):: Temp
   654                                ! $ T $ . 温度. Temperature
   655      real(DP), intent(in):: QVapSat
   656                                ! $ q^{*} $ . 飽和比湿. Saturation specific humidity
   657      real(DP):: DQVapSatDTemp
   658                                ! $ \DP{q^{*}}{T} $ . 飽和比湿の温度微分.
   659                                ! Temperature derivative of saturation specific humidity.
   660  
   661      ! 作業変数
   662      ! Work variables
   663      !
   664      real(DP):: xyz_Temp   (1:1, 1:1, 1:1)
   665                                ! $ T $ . 温度. Temperature
   666      real(DP):: xyz_QVapSat(1:1, 1:1, 1:1)
   667                                ! $ q^{*} $ . 飽和比湿. Saturation specific humidity
   668      real(DP):: xyz_DQVapSatDTemp(1:1, 1:1, 1:1)
   669                                ! $ \DP{q^{*}}{T} $ . 飽和比湿の温度微分.
   670                                ! Temperature derivative of saturation specific humidity.
   671  
   672  
   673      ! 実行文 ; Executable statement
   674      !
   675  
   676      if ( .not. saturate_inited ) then
   677        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   678      end if
   679  
   680  
   681      xyz_Temp   (1,1,1) = Temp
   682      xyz_QVapSat(1,1,1) = QVapSat
   683  
   684      xyz_DQVapSatDTemp = xyz_CalcDQVapSatDTemp( xyz_Temp, xyz_QVapSat )
   685  
   686      DQVapSatDTemp = xyz_DQVapSatDTemp(1,1,1)
   687  
   688  
   689    end function CalcDQVapSatDTemp
   690  
   691    !-------------------------------------------------------------------
   692    ! [On liquid] Interfaces for 2D, 1D, and scalar variables
   693    !-------------------------------------------------------------------
   694  
   695    function xy_CalcQVapSatOnLiq( xy_Temp, xy_Press ) result( xy_QVapSat )
   696      !
   697      ! 温度 *Temp* と気圧 *Press* を用い,
   698      ! 飽和比湿 *QVapSat* を求めます.
   699      !
   700      ! Calculate saturation specific humidity *QVapSat* using
   701      ! temperature *Temp* and air pressure *Press*.
   702      !
   703  
   704      ! モジュール引用 ; USE statements
   705      !
   706  
   707      ! 宣言文 ; Declaration statements
   708      !
   709      implicit none
   710  
   711      real(DP), intent(in):: xy_Temp (:,:)
   712                                ! $ T $ . 温度. Temperature
   713      real(DP), intent(in):: xy_Press(:,:)
   714                                ! $ p $ . 気圧. Air pressure
   715  
   716      real(DP):: xy_QVapSat(size(xy_Temp,1), size(xy_Temp,2))
   717                                ! $ q^{*} $ . 飽和比湿. Saturation specific humidity
   718  
   719      ! 作業変数
   720      ! Work variables
   721      !
   722      real(DP) :: xyz_Temp   (size(xy_Temp,1),size(xy_Temp,2),1)
   723      real(DP) :: xyz_Press  (size(xy_Temp,1),size(xy_Temp,2),1)
   724      real(DP) :: xyz_QVapSat(size(xy_Temp,1),size(xy_Temp,2),1)
   725  
   726  
   727      ! 実行文 ; Executable statement
   728      !
   729  
   730      if ( .not. saturate_inited ) then
   731        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   732      end if
   733  
   734  
   735      xyz_Temp (:,:,1) = xy_Temp
     .        if (xyz_temp.DSC.U2 .gt. 0) then                                  
     .           j9 = and(xyz_temp.DSC.U2,3)                                    
     .  !cdir    nodep                                                          
     .           do t99 = 1, j9                                                 
     .  !cdir       nodep                                                       
     .              do t101 = 1, xyz_temp.DSC.U1                                
     .                 xyz_temp(t101,t99,1) = xy_temp(t101,t99)                 
     .                 xyz_press(t101,t99,1) = xy_press(t101,t99)               
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t99 = j9 + 1, xyz_temp.DSC.U2, 4                            
     .  !cdir       nodep                                                       
     .              do t101 = 1, xyz_temp.DSC.U1                                
     .                 xyz_temp(t101,t99,1) = xy_temp(t101,t99)                 
     .                 xyz_temp(t101,t99+1,1) = xy_temp(t101,t99+1)             
     .                 xyz_temp(t101,t99+2,1) = xy_temp(t101,t99+2)             
     .                 xyz_temp(t101,t99+3,1) = xy_temp(t101,t99+3)             
     .                 xyz_press(t101,t99,1) = xy_press(t101,t99)               
     .                 xyz_press(t101,t99+1,1) = xy_press(t101,t99+1)           
     .                 xyz_press(t101,t99+2,1) = xy_press(t101,t99+2)           
     .                 xyz_press(t101,t99+3,1) = xy_press(t101,t99+3)           
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
   736      xyz_Press(:,:,1) = xy_Press
   737  
   738      xyz_QVapSat = xyz_CalcQVapSatOnLiq( xyz_Temp, xyz_Press )
   739  
   740      xy_QVapSat = xyz_QVapSat(:,:,1)
     .        if (xy_qvapsat.DESCRIPT.RETVAL.DSC.U2 .gt. 0) then                
     .           j10 = and(xy_qvapsat.DESCRIPT.RETVAL.DSC.U2,3)                 
     .  !cdir    nodep                                                          
     .           do t111 = 1, j10                                               
     .  !cdir       nodep                                                       
     .              do t113 = 1, xy_qvapsat.DESCRIPT.RETVAL.DSC.U1              
     .                 xy_qvapsat(t113,t111) = xyz_qvapsat(t113,t111,1)         
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t111 = j10 + 1, xy_qvapsat.DESCRIPT.RETVAL.DSC.U2, 4        
     .  !cdir       nodep                                                       
     .              do t113 = 1, xy_qvapsat.DESCRIPT.RETVAL.DSC.U1              
     .                 xy_qvapsat(t113,t111) = xyz_qvapsat(t113,t111,1)         
     .                 xy_qvapsat(t113,t111+1) = xyz_qvapsat(t113,t111+1,1)     
     .                 xy_qvapsat(t113,t111+2) = xyz_qvapsat(t113,t111+2,1)     
     .                 xy_qvapsat(t113,t111+3) = xyz_qvapsat(t113,t111+3,1)     
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
   741  
   742  
   743    end function xy_CalcQVapSatOnLiq
   744  
   745    !-------------------------------------------------------------------
   746  
   747    function xy_CalcDQVapSatDTempOnLiq( xy_Temp, xy_QVapSat ) result( xy_DQVapSatDTemp )
   748      !
   749      ! 温度 *Temp* と飽和比湿 *QVapSat* を用い,
   750      ! 飽和比湿の温度微分 *DQVapSatDTemp* を求めます.
   751      !
   752      ! Calculate temperature derivative of saturation specific humidity
   753      ! *DQVapSatDTemp* using
   754      ! temperature *Temp* and saturation specific humidity *QVapSat*.
   755      !
   756  
   757      ! モジュール引用 ; USE statements
   758      !
   759  
   760      ! 宣言文 ; Declaration statements
   761      !
   762      implicit none
   763  
   764      real(DP), intent(in):: xy_Temp   (:,:)
   765                                ! $ T $ . 温度. Temperature
   766      real(DP), intent(in):: xy_QVapSat(:,:)
   767                                ! $ q^{*} $ . 飽和比湿. Saturation specific humidity
   768      real(DP):: xy_DQVapSatDTemp(size(xy_Temp,1), size(xy_Temp,2))
   769                                ! $ \DP{q^{*}}{T} $ . 飽和比湿の温度微分.
   770                                ! Temperature derivative of saturation specific humidity.
   771  
   772      ! 作業変数
   773      ! Work variables
   774      !
   775      real(DP):: xyz_Temp         (size(xy_Temp,1), size(xy_Temp,2), 1)
   776      real(DP):: xyz_QVapSat      (size(xy_Temp,1), size(xy_Temp,2), 1)
   777      real(DP):: xyz_DQVapSatDTemp(size(xy_Temp,1), size(xy_Temp,2), 1)
   778  
   779      ! 実行文 ; Executable statement
   780      !
   781  
   782      if ( .not. saturate_inited ) then
   783        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   784      end if
   785  
   786  
   787      xyz_Temp   (:,:,1) = xy_Temp
     .        if (xyz_temp.DSC.U2 .gt. 0) then                                  
     .           j9 = and(xyz_temp.DSC.U2,3)                                    
     .  !cdir    nodep                                                          
     .           do t99 = 1, j9                                                 
     .  !cdir       nodep                                                       
     .              do t101 = 1, xyz_temp.DSC.U1                                
     .                 xyz_temp(t101,t99,1) = xy_temp(t101,t99)                 
     .                 xyz_qvapsat(t101,t99,1) = xy_qvapsat(t101,t99)           
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t99 = j9 + 1, xyz_temp.DSC.U2, 4                            
     .  !cdir       nodep                                                       
     .              do t101 = 1, xyz_temp.DSC.U1                                
     .                 xyz_temp(t101,t99,1) = xy_temp(t101,t99)                 
     .                 xyz_temp(t101,t99+1,1) = xy_temp(t101,t99+1)             
     .                 xyz_temp(t101,t99+2,1) = xy_temp(t101,t99+2)             
     .                 xyz_temp(t101,t99+3,1) = xy_temp(t101,t99+3)             
     .                 xyz_qvapsat(t101,t99,1) = xy_qvapsat(t101,t99)           
     .                 xyz_qvapsat(t101,t99+1,1) = xy_qvapsat(t101,t99+1)       
     .                 xyz_qvapsat(t101,t99+2,1) = xy_qvapsat(t101,t99+2)       
     .                 xyz_qvapsat(t101,t99+3,1) = xy_qvapsat(t101,t99+3)       
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
   788      xyz_QVapSat(:,:,1) = xy_QVapSat
   789  
   790      xyz_DQVapSatDTemp = xyz_CalcDQVapSatDTempOnLiq( xyz_Temp, xyz_QVapSat )
   791  
   792      xy_DQVapSatDTemp = xyz_DQVapSatDTemp(:,:,1)
     .        if (xy_dqvapsatdtemp.DESCRIPT.RETVAL.DSC.U2 .gt. 0) then          
     .           j10 = and(xy_dqvapsatdtemp.DESCRIPT.RETVAL.DSC.U2,3)           
     .  !cdir    nodep                                                          
     .           do t111 = 1, j10                                               
     .  !cdir       nodep                                                       
     .              do t113 = 1, xy_dqvapsatdtemp.DESCRIPT.RETVAL.DSC.U1        
     .                 xy_dqvapsatdtemp(t113,t111) = xyz_dqvapsatdtemp(t113,t111
     .       1            ,1)                                                   
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t111 = j10 + 1, xy_dqvapsatdtemp.DESCRIPT.RETVAL.DSC.U2, 4  
     .  !cdir       nodep                                                       
     .              do t113 = 1, xy_dqvapsatdtemp.DESCRIPT.RETVAL.DSC.U1        
     .                 xy_dqvapsatdtemp(t113,t111) = xyz_dqvapsatdtemp(t113,t111
     .       1            ,1)                                                   
     .                 xy_dqvapsatdtemp(t113,t111+1) = xyz_dqvapsatdtemp(t113,  
     .       1            t111+1,1)                                             
     .                 xy_dqvapsatdtemp(t113,t111+2) = xyz_dqvapsatdtemp(t113,  
     .       1            t111+2,1)                                             
     .                 xy_dqvapsatdtemp(t113,t111+3) = xyz_dqvapsatdtemp(t113,  
     .       1            t111+3,1)                                             
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
   793  
   794  
   795    end function xy_CalcDQVapSatDTempOnLiq
   796  
   797    !--------------------------------------------------------------------------------------
   798  
   799    function a_CalcQVapSatOnLiq( a_Temp, a_Press ) result( a_QVapSat )
   800      !
   801      ! 温度 *Temp* と気圧 *Press* を用い,
   802      ! 飽和比湿 *QVapSat* を求めます.
   803      !
   804      ! Calculate saturation specific humidity *QVapSat* using
   805      ! temperature *Temp* and air pressure *Press*.
   806      !
   807  
   808      ! モジュール引用 ; USE statements
   809      !
   810  
   811      ! 宣言文 ; Declaration statements
   812      !
   813      implicit none
   814  
   815      real(DP), intent(in):: a_Temp (:)
   816                                ! $ T $ . 温度. Temperature
   817      real(DP), intent(in):: a_Press(:)
   818                                ! $ p $ . 気圧. Air pressure
   819  
   820      real(DP):: a_QVapSat(size(a_Temp,1))
   821                                ! $ q^{*} $ . 飽和比湿. Saturation specific humidity
   822  
   823      ! 作業変数
   824      ! Work variables
   825      !
   826      real(DP):: xyz_Temp   (size(a_Temp,1), 1, 1)
   827                                ! $ T $ . 温度. Temperature
   828      real(DP):: xyz_Press  (size(a_Temp,1), 1, 1)
   829                                ! $ p $ . 気圧. Air pressure
   830      real(DP):: xyz_QVapSat(size(a_Temp,1), 1, 1)
   831                                ! $ q^{*} $ . 飽和比湿. Saturation specific humidity
   832  
   833      if ( .not. saturate_inited ) then
   834        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   835      end if
   836  
   837  
   838      xyz_Temp (:,1,1) = a_Temp
   839      xyz_Press(:,1,1) = a_Press
   840  
   841      xyz_QVapSat = xyz_CalcQVapSatOnLiq( xyz_Temp, xyz_Press )
   842  
   843      a_QVapSat = xyz_QVapSat(:,1,1)
   844  
   845  
   846    end function a_CalcQVapSatOnLiq
   847  
   848    !--------------------------------------------------------------------------------------
   849  
   850    function a_CalcDQVapSatDTempOnLiq( a_Temp, a_QVapSat ) result( a_DQVapSatDTemp )
   851      !
   852      ! 温度 *Temp* と飽和比湿 *QVapSat* を用い,
   853      ! 飽和比湿の温度微分 *DQVapSatDTemp* を求めます.
   854      !
   855      ! Calculate temperature derivative of saturation specific humidity
   856      ! *DQVapSatDTemp* using
   857      ! temperature *Temp* and saturation specific humidity *QVapSat*.
   858      !
   859  
   860      ! モジュール引用 ; USE statements
   861      !
   862  
   863      ! 宣言文 ; Declaration statements
   864      !
   865      implicit none
   866  
   867      real(DP), intent(in):: a_Temp   (:)
   868                                ! $ T $ . 温度. Temperature
   869      real(DP), intent(in):: a_QVapSat(:)
   870                                ! $ q^{*} $ . 飽和比湿. Saturation specific humidity
   871      real(DP):: a_DQVapSatDTemp(size(a_Temp,1))
   872                                ! $ \DP{q^{*}}{T} $ . 飽和比湿の温度微分.
   873                                ! Temperature derivative of saturation specific humidity.
   874  
   875      ! 作業変数
   876      ! Work variables
   877      !
   878      real(DP):: xyz_Temp   (size(a_Temp,1), 1:1, 1:1)
   879                                ! $ T $ . 温度. Temperature
   880      real(DP):: xyz_QVapSat(size(a_Temp,1), 1:1, 1:1)
   881                                ! $ q^{*} $ . 飽和比湿. Saturation specific humidity
   882      real(DP):: xyz_DQVapSatDTemp(size(a_Temp,1), 1:1, 1:1)
   883                                ! $ \DP{q^{*}}{T} $ . 飽和比湿の温度微分.
   884                                ! Temperature derivative of saturation specific humidity.
   885  
   886  
   887      ! 実行文 ; Executable statement
   888      !
   889  
   890      if ( .not. saturate_inited ) then
   891        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   892      end if
   893  
   894  
   895      xyz_Temp   (:,1,1) = a_Temp
   896      xyz_QVapSat(:,1,1) = a_QVapSat
   897  
   898      xyz_DQVapSatDTemp = xyz_CalcDQVapSatDTempOnLiq( xyz_Temp, xyz_QVapSat )
   899  
   900      a_DQVapSatDTemp = xyz_DQVapSatDTemp(:,1,1)
   901  
   902  
   903    end function a_CalcDQVapSatDTempOnLiq
   904  
   905    !--------------------------------------------------------------------------------------
   906  
   907    function CalcQVapSatOnLiq( Temp, Press ) result( QVapSat )
   908      !
   909      ! 温度 *Temp* と気圧 *Press* を用い,
   910      ! 飽和比湿 *QVapSat* を求めます.
   911      !
   912      ! Calculate saturation specific humidity *QVapSat* using
   913      ! temperature *Temp* and air pressure *Press*.
   914      !
   915  
   916      ! モジュール引用 ; USE statements
   917      !
   918  
   919      ! 宣言文 ; Declaration statements
   920      !
   921      implicit none
   922  
   923      real(DP), intent(in):: Temp
   924                                ! $ T $ . 温度. Temperature
   925      real(DP), intent(in):: Press
   926                                ! $ p $ . 気圧. Air pressure
   927  
   928      real(DP):: QVapSat
   929                                ! $ q^{*} $ . 飽和比湿. Saturation specific humidity
   930  
   931      ! 作業変数
   932      ! Work variables
   933      !
   934      real(DP):: xyz_Temp   (1, 1, 1)
   935                                ! $ T $ . 温度. Temperature
   936      real(DP):: xyz_Press  (1, 1, 1)
   937                                ! $ p $ . 気圧. Air pressure
   938      real(DP):: xyz_QVapSat(1, 1, 1)
   939                                ! $ q^{*} $ . 飽和比湿. Saturation specific humidity
   940  
   941      if ( .not. saturate_inited ) then
   942        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   943      end if
   944  
   945  
   946      xyz_Temp (:,1,1) = Temp
     .        xyz_temp(1,1,1) = temp                                            
     .        xyz_press(1,1,1) = press                                          
   947      xyz_Press(:,1,1) = Press
   948  
   949      xyz_QVapSat = xyz_CalcQVapSatOnLiq( xyz_Temp, xyz_Press )
   950  
   951      QVapSat = xyz_QVapSat(1,1,1)
   952  
   953  
   954    end function CalcQVapSatOnLiq
   955  
   956    !--------------------------------------------------------------------------------------
   957  
   958    function CalcDQVapSatDTempOnLiq( Temp, QVapSat ) result( DQVapSatDTemp )
   959      !
   960      ! 温度 *Temp* と飽和比湿 *QVapSat* を用い,
   961      ! 飽和比湿の温度微分 *DQVapSatDTemp* を求めます.
   962      !
   963      ! Calculate temperature derivative of saturation specific humidity
   964      ! *DQVapSatDTemp* using
   965      ! temperature *Temp* and saturation specific humidity *QVapSat*.
   966      !
   967  
   968      ! モジュール引用 ; USE statements
   969      !
   970  
   971      ! 宣言文 ; Declaration statements
   972      !
   973      implicit none
   974  
   975      real(DP), intent(in):: Temp
   976                                ! $ T $ . 温度. Temperature
   977      real(DP), intent(in):: QVapSat
   978                                ! $ q^{*} $ . 飽和比湿. Saturation specific humidity
   979      real(DP):: DQVapSatDTemp
   980                                ! $ \DP{q^{*}}{T} $ . 飽和比湿の温度微分.
   981                                ! Temperature derivative of saturation specific humidity.
   982  
   983      ! 作業変数
   984      ! Work variables
   985      !
   986      real(DP):: xyz_Temp   (1:1, 1:1, 1:1)
   987                                ! $ T $ . 温度. Temperature
   988      real(DP):: xyz_QVapSat(1:1, 1:1, 1:1)
   989                                ! $ q^{*} $ . 飽和比湿. Saturation specific humidity
   990      real(DP):: xyz_DQVapSatDTemp(1:1, 1:1, 1:1)
   991                                ! $ \DP{q^{*}}{T} $ . 飽和比湿の温度微分.
   992                                ! Temperature derivative of saturation specific humidity.
   993  
   994  
   995      ! 実行文 ; Executable statement
   996      !
   997  
   998      if ( .not. saturate_inited ) then
   999        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
  1000      end if
  1001  
  1002  
  1003      xyz_Temp   (1,1,1) = Temp
  1004      xyz_QVapSat(1,1,1) = QVapSat
  1005  
  1006      xyz_DQVapSatDTemp = xyz_CalcDQVapSatDTempOnLiq( xyz_Temp, xyz_QVapSat )
  1007  
  1008      DQVapSatDTemp = xyz_DQVapSatDTemp(1,1,1)
  1009  
  1010  
  1011    end function CalcDQVapSatDTempOnLiq
  1012  
  1013    !-------------------------------------------------------------------
  1014    ! [On ice] Interfaces for 2D, 1D, and scalar variables
  1015    !-------------------------------------------------------------------
  1016  
  1017    function xy_CalcQVapSatOnSol( xy_Temp, xy_Press ) result( xy_QVapSat )
  1018      !
  1019      ! 温度 *Temp* と気圧 *Press* を用い,
  1020      ! 飽和比湿 *QVapSat* を求めます.
  1021      !
  1022      ! Calculate saturation specific humidity *QVapSat* using
  1023      ! temperature *Temp* and air pressure *Press*.
  1024      !
  1025  
  1026      ! モジュール引用 ; USE statements
  1027      !
  1028  
  1029      ! 宣言文 ; Declaration statements
  1030      !
  1031      implicit none
  1032  
  1033      real(DP), intent(in):: xy_Temp (:,:)
  1034                                ! $ T $ . 温度. Temperature
  1035      real(DP), intent(in):: xy_Press(:,:)
  1036                                ! $ p $ . 気圧. Air pressure
  1037  
  1038      real(DP):: xy_QVapSat(size(xy_Temp,1), size(xy_Temp,2))
  1039                                ! $ q^{*} $ . 飽和比湿. Saturation specific humidity
  1040  
  1041      ! 作業変数
  1042      ! Work variables
  1043      !
  1044      real(DP) :: xyz_Temp   (size(xy_Temp,1),size(xy_Temp,2),1)
  1045      real(DP) :: xyz_Press  (size(xy_Temp,1),size(xy_Temp,2),1)
  1046      real(DP) :: xyz_QVapSat(size(xy_Temp,1),size(xy_Temp,2),1)
  1047  
  1048  
  1049      ! 実行文 ; Executable statement
  1050      !
  1051  
  1052      if ( .not. saturate_inited ) then
  1053        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
  1054      end if
  1055  
  1056  
  1057      xyz_Temp (:,:,1) = xy_Temp
     .        if (xyz_temp.DSC.U2 .gt. 0) then                                  
     .           j9 = and(xyz_temp.DSC.U2,3)                                    
     .  !cdir    nodep                                                          
     .           do t99 = 1, j9                                                 
     .  !cdir       nodep                                                       
     .              do t101 = 1, xyz_temp.DSC.U1                                
     .                 xyz_temp(t101,t99,1) = xy_temp(t101,t99)                 
     .                 xyz_press(t101,t99,1) = xy_press(t101,t99)               
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t99 = j9 + 1, xyz_temp.DSC.U2, 4                            
     .  !cdir       nodep                                                       
     .              do t101 = 1, xyz_temp.DSC.U1                                
     .                 xyz_temp(t101,t99,1) = xy_temp(t101,t99)                 
     .                 xyz_temp(t101,t99+1,1) = xy_temp(t101,t99+1)             
     .                 xyz_temp(t101,t99+2,1) = xy_temp(t101,t99+2)             
     .                 xyz_temp(t101,t99+3,1) = xy_temp(t101,t99+3)             
     .                 xyz_press(t101,t99,1) = xy_press(t101,t99)               
     .                 xyz_press(t101,t99+1,1) = xy_press(t101,t99+1)           
     .                 xyz_press(t101,t99+2,1) = xy_press(t101,t99+2)           
     .                 xyz_press(t101,t99+3,1) = xy_press(t101,t99+3)           
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
  1058      xyz_Press(:,:,1) = xy_Press
  1059  
  1060      xyz_QVapSat = xyz_CalcQVapSatOnSol( xyz_Temp, xyz_Press )
  1061  
  1062      xy_QVapSat = xyz_QVapSat(:,:,1)
     .        if (xy_qvapsat.DESCRIPT.RETVAL.DSC.U2 .gt. 0) then                
     .           j10 = and(xy_qvapsat.DESCRIPT.RETVAL.DSC.U2,3)                 
     .  !cdir    nodep                                                          
     .           do t111 = 1, j10                                               
     .  !cdir       nodep                                                       
     .              do t113 = 1, xy_qvapsat.DESCRIPT.RETVAL.DSC.U1              
     .                 xy_qvapsat(t113,t111) = xyz_qvapsat(t113,t111,1)         
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t111 = j10 + 1, xy_qvapsat.DESCRIPT.RETVAL.DSC.U2, 4        
     .  !cdir       nodep                                                       
     .              do t113 = 1, xy_qvapsat.DESCRIPT.RETVAL.DSC.U1              
     .                 xy_qvapsat(t113,t111) = xyz_qvapsat(t113,t111,1)         
     .                 xy_qvapsat(t113,t111+1) = xyz_qvapsat(t113,t111+1,1)     
     .                 xy_qvapsat(t113,t111+2) = xyz_qvapsat(t113,t111+2,1)     
     .                 xy_qvapsat(t113,t111+3) = xyz_qvapsat(t113,t111+3,1)     
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
  1063  
  1064  
  1065    end function xy_CalcQVapSatOnSol
  1066  
  1067    !-------------------------------------------------------------------
  1068  
  1069    function xy_CalcDQVapSatDTempOnSol( xy_Temp, xy_QVapSat ) result( xy_DQVapSatDTemp )
  1070      !
  1071      ! 温度 *Temp* と飽和比湿 *QVapSat* を用い,
  1072      ! 飽和比湿の温度微分 *DQVapSatDTemp* を求めます.
  1073      !
  1074      ! Calculate temperature derivative of saturation specific humidity
  1075      ! *DQVapSatDTemp* using
  1076      ! temperature *Temp* and saturation specific humidity *QVapSat*.
  1077      !
  1078  
  1079      ! モジュール引用 ; USE statements
  1080      !
  1081  
  1082      ! 宣言文 ; Declaration statements
  1083      !
  1084      implicit none
  1085  
  1086      real(DP), intent(in):: xy_Temp   (:,:)
  1087                                ! $ T $ . 温度. Temperature
  1088      real(DP), intent(in):: xy_QVapSat(:,:)
  1089                                ! $ q^{*} $ . 飽和比湿. Saturation specific humidity
  1090      real(DP):: xy_DQVapSatDTemp(size(xy_Temp,1), size(xy_Temp,2))
  1091                                ! $ \DP{q^{*}}{T} $ . 飽和比湿の温度微分.
  1092                                ! Temperature derivative of saturation specific humidity.
  1093  
  1094      ! 作業変数
  1095      ! Work variables
  1096      !
  1097      real(DP):: xyz_Temp         (size(xy_Temp,1), size(xy_Temp,2), 1)
  1098      real(DP):: xyz_QVapSat      (size(xy_Temp,1), size(xy_Temp,2), 1)
  1099      real(DP):: xyz_DQVapSatDTemp(size(xy_Temp,1), size(xy_Temp,2), 1)
  1100  
  1101      ! 実行文 ; Executable statement
  1102      !
  1103  
  1104      if ( .not. saturate_inited ) then
  1105        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
  1106      end if
  1107  
  1108  
  1109      xyz_Temp   (:,:,1) = xy_Temp
     .        if (xyz_temp.DSC.U2 .gt. 0) then                                  
     .           j9 = and(xyz_temp.DSC.U2,3)                                    
     .  !cdir    nodep                                                          
     .           do t99 = 1, j9                                                 
     .  !cdir       nodep                                                       
     .              do t101 = 1, xyz_temp.DSC.U1                                
     .                 xyz_temp(t101,t99,1) = xy_temp(t101,t99)                 
     .                 xyz_qvapsat(t101,t99,1) = xy_qvapsat(t101,t99)           
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t99 = j9 + 1, xyz_temp.DSC.U2, 4                            
     .  !cdir       nodep                                                       
     .              do t101 = 1, xyz_temp.DSC.U1                                
     .                 xyz_temp(t101,t99,1) = xy_temp(t101,t99)                 
     .                 xyz_temp(t101,t99+1,1) = xy_temp(t101,t99+1)             
     .                 xyz_temp(t101,t99+2,1) = xy_temp(t101,t99+2)             
     .                 xyz_temp(t101,t99+3,1) = xy_temp(t101,t99+3)             
     .                 xyz_qvapsat(t101,t99,1) = xy_qvapsat(t101,t99)           
     .                 xyz_qvapsat(t101,t99+1,1) = xy_qvapsat(t101,t99+1)       
     .                 xyz_qvapsat(t101,t99+2,1) = xy_qvapsat(t101,t99+2)       
     .                 xyz_qvapsat(t101,t99+3,1) = xy_qvapsat(t101,t99+3)       
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
  1110      xyz_QVapSat(:,:,1) = xy_QVapSat
  1111  
  1112      xyz_DQVapSatDTemp = xyz_CalcDQVapSatDTempOnSol( xyz_Temp, xyz_QVapSat )
  1113  
  1114      xy_DQVapSatDTemp = xyz_DQVapSatDTemp(:,:,1)
     .        if (xy_dqvapsatdtemp.DESCRIPT.RETVAL.DSC.U2 .gt. 0) then          
     .           j10 = and(xy_dqvapsatdtemp.DESCRIPT.RETVAL.DSC.U2,3)           
     .  !cdir    nodep                                                          
     .           do t111 = 1, j10                                               
     .  !cdir       nodep                                                       
     .              do t113 = 1, xy_dqvapsatdtemp.DESCRIPT.RETVAL.DSC.U1        
     .                 xy_dqvapsatdtemp(t113,t111) = xyz_dqvapsatdtemp(t113,t111
     .       1            ,1)                                                   
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t111 = j10 + 1, xy_dqvapsatdtemp.DESCRIPT.RETVAL.DSC.U2, 4  
     .  !cdir       nodep                                                       
     .              do t113 = 1, xy_dqvapsatdtemp.DESCRIPT.RETVAL.DSC.U1        
     .                 xy_dqvapsatdtemp(t113,t111) = xyz_dqvapsatdtemp(t113,t111
     .       1            ,1)                                                   
     .                 xy_dqvapsatdtemp(t113,t111+1) = xyz_dqvapsatdtemp(t113,  
     .       1            t111+1,1)                                             
     .                 xy_dqvapsatdtemp(t113,t111+2) = xyz_dqvapsatdtemp(t113,  
     .       1            t111+2,1)                                             
     .                 xy_dqvapsatdtemp(t113,t111+3) = xyz_dqvapsatdtemp(t113,  
     .       1            t111+3,1)                                             
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
  1115  
  1116  
  1117    end function xy_CalcDQVapSatDTempOnSol
  1118  
  1119    !--------------------------------------------------------------------------------------
  1120  
  1121    function a_CalcQVapSatOnSol( a_Temp, a_Press ) result( a_QVapSat )
  1122      !
  1123      ! 温度 *Temp* と気圧 *Press* を用い,
  1124      ! 飽和比湿 *QVapSat* を求めます.
  1125      !
  1126      ! Calculate saturation specific humidity *QVapSat* using
  1127      ! temperature *Temp* and air pressure *Press*.
  1128      !
  1129  
  1130      ! モジュール引用 ; USE statements
  1131      !
  1132  
  1133      ! 宣言文 ; Declaration statements
  1134      !
  1135      implicit none
  1136  
  1137      real(DP), intent(in):: a_Temp (:)
  1138                                ! $ T $ . 温度. Temperature
  1139      real(DP), intent(in):: a_Press(:)
  1140                                ! $ p $ . 気圧. Air pressure
  1141  
  1142      real(DP):: a_QVapSat(size(a_Temp,1))
  1143                                ! $ q^{*} $ . 飽和比湿. Saturation specific humidity
  1144  
  1145      ! 作業変数
  1146      ! Work variables
  1147      !
  1148      real(DP):: xyz_Temp   (size(a_Temp,1), 1, 1)
  1149                                ! $ T $ . 温度. Temperature
  1150      real(DP):: xyz_Press  (size(a_Temp,1), 1, 1)
  1151                                ! $ p $ . 気圧. Air pressure
  1152      real(DP):: xyz_QVapSat(size(a_Temp,1), 1, 1)
  1153                                ! $ q^{*} $ . 飽和比湿. Saturation specific humidity
  1154  
  1155      if ( .not. saturate_inited ) then
  1156        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
  1157      end if
  1158  
  1159  
  1160      xyz_Temp (:,1,1) = a_Temp
  1161      xyz_Press(:,1,1) = a_Press
  1162  
  1163      xyz_QVapSat = xyz_CalcQVapSatOnSol( xyz_Temp, xyz_Press )
  1164  
  1165      a_QVapSat = xyz_QVapSat(:,1,1)
  1166  
  1167  
  1168    end function a_CalcQVapSatOnSol
  1169  
  1170    !--------------------------------------------------------------------------------------
  1171  
  1172    function a_CalcDQVapSatDTempOnSol( a_Temp, a_QVapSat ) result( a_DQVapSatDTemp )
  1173      !
  1174      ! 温度 *Temp* と飽和比湿 *QVapSat* を用い,
  1175      ! 飽和比湿の温度微分 *DQVapSatDTemp* を求めます.
  1176      !
  1177      ! Calculate temperature derivative of saturation specific humidity
  1178      ! *DQVapSatDTemp* using
  1179      ! temperature *Temp* and saturation specific humidity *QVapSat*.
  1180      !
  1181  
  1182      ! モジュール引用 ; USE statements
  1183      !
  1184  
  1185      ! 宣言文 ; Declaration statements
  1186      !
  1187      implicit none
  1188  
  1189      real(DP), intent(in):: a_Temp   (:)
  1190                                ! $ T $ . 温度. Temperature
  1191      real(DP), intent(in):: a_QVapSat(:)
  1192                                ! $ q^{*} $ . 飽和比湿. Saturation specific humidity
  1193      real(DP):: a_DQVapSatDTemp(size(a_Temp,1))
  1194                                ! $ \DP{q^{*}}{T} $ . 飽和比湿の温度微分.
  1195                                ! Temperature derivative of saturation specific humidity.
  1196  
  1197      ! 作業変数
  1198      ! Work variables
  1199      !
  1200      real(DP):: xyz_Temp   (size(a_Temp,1), 1:1, 1:1)
  1201                                ! $ T $ . 温度. Temperature
  1202      real(DP):: xyz_QVapSat(size(a_Temp,1), 1:1, 1:1)
  1203                                ! $ q^{*} $ . 飽和比湿. Saturation specific humidity
  1204      real(DP):: xyz_DQVapSatDTemp(size(a_Temp,1), 1:1, 1:1)
  1205                                ! $ \DP{q^{*}}{T} $ . 飽和比湿の温度微分.
  1206                                ! Temperature derivative of saturation specific humidity.
  1207  
  1208  
  1209      ! 実行文 ; Executable statement
  1210      !
  1211  
  1212      if ( .not. saturate_inited ) then
  1213        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
  1214      end if
  1215  
  1216  
  1217      xyz_Temp   (:,1,1) = a_Temp
  1218      xyz_QVapSat(:,1,1) = a_QVapSat
  1219  
  1220      xyz_DQVapSatDTemp = xyz_CalcDQVapSatDTempOnSol( xyz_Temp, xyz_QVapSat )
  1221  
  1222      a_DQVapSatDTemp = xyz_DQVapSatDTemp(:,1,1)
  1223  
  1224  
  1225    end function a_CalcDQVapSatDTempOnSol
  1226  
  1227    !--------------------------------------------------------------------------------------
  1228  
  1229    function CalcQVapSatOnSol( Temp, Press ) result( QVapSat )
  1230      !
  1231      ! 温度 *Temp* と気圧 *Press* を用い,
  1232      ! 飽和比湿 *QVapSat* を求めます.
  1233      !
  1234      ! Calculate saturation specific humidity *QVapSat* using
  1235      ! temperature *Temp* and air pressure *Press*.
  1236      !
  1237  
  1238      ! モジュール引用 ; USE statements
  1239      !
  1240  
  1241      ! 宣言文 ; Declaration statements
  1242      !
  1243      implicit none
  1244  
  1245      real(DP), intent(in):: Temp
  1246                                ! $ T $ . 温度. Temperature
  1247      real(DP), intent(in):: Press
  1248                                ! $ p $ . 気圧. Air pressure
  1249  
  1250      real(DP):: QVapSat
  1251                                ! $ q^{*} $ . 飽和比湿. Saturation specific humidity
  1252  
  1253      ! 作業変数
  1254      ! Work variables
  1255      !
  1256      real(DP):: xyz_Temp   (1, 1, 1)
  1257                                ! $ T $ . 温度. Temperature
  1258      real(DP):: xyz_Press  (1, 1, 1)
  1259                                ! $ p $ . 気圧. Air pressure
  1260      real(DP):: xyz_QVapSat(1, 1, 1)
  1261                                ! $ q^{*} $ . 飽和比湿. Saturation specific humidity
  1262  
  1263      if ( .not. saturate_inited ) then
  1264        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
  1265      end if
  1266  
  1267  
  1268      xyz_Temp (:,1,1) = Temp
     .        xyz_temp(1,1,1) = temp                                            
     .        xyz_press(1,1,1) = press                                          
  1269      xyz_Press(:,1,1) = Press
  1270  
  1271      xyz_QVapSat = xyz_CalcQVapSatOnSol( xyz_Temp, xyz_Press )
  1272  
  1273      QVapSat = xyz_QVapSat(1,1,1)
  1274  
  1275  
  1276    end function CalcQVapSatOnSol
  1277  
  1278    !--------------------------------------------------------------------------------------
  1279  
  1280    function CalcDQVapSatDTempOnSol( Temp, QVapSat ) result( DQVapSatDTemp )
  1281      !
  1282      ! 温度 *Temp* と飽和比湿 *QVapSat* を用い,
  1283      ! 飽和比湿の温度微分 *DQVapSatDTemp* を求めます.
  1284      !
  1285      ! Calculate temperature derivative of saturation specific humidity
  1286      ! *DQVapSatDTemp* using
  1287      ! temperature *Temp* and saturation specific humidity *QVapSat*.
  1288      !
  1289  
  1290      ! モジュール引用 ; USE statements
  1291      !
  1292  
  1293      ! 宣言文 ; Declaration statements
  1294      !
  1295      implicit none
  1296  
  1297      real(DP), intent(in):: Temp
  1298                                ! $ T $ . 温度. Temperature
  1299      real(DP), intent(in):: QVapSat
  1300                                ! $ q^{*} $ . 飽和比湿. Saturation specific humidity
  1301      real(DP):: DQVapSatDTemp
  1302                                ! $ \DP{q^{*}}{T} $ . 飽和比湿の温度微分.
  1303                                ! Temperature derivative of saturation specific humidity.
  1304  
  1305      ! 作業変数
  1306      ! Work variables
  1307      !
  1308      real(DP):: xyz_Temp   (1:1, 1:1, 1:1)
  1309                                ! $ T $ . 温度. Temperature
  1310      real(DP):: xyz_QVapSat(1:1, 1:1, 1:1)
  1311                                ! $ q^{*} $ . 飽和比湿. Saturation specific humidity
  1312      real(DP):: xyz_DQVapSatDTemp(1:1, 1:1, 1:1)
  1313                                ! $ \DP{q^{*}}{T} $ . 飽和比湿の温度微分.
  1314                                ! Temperature derivative of saturation specific humidity.
  1315  
  1316  
  1317      ! 実行文 ; Executable statement
  1318      !
  1319  
  1320      if ( .not. saturate_inited ) then
  1321        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
  1322      end if
  1323  
  1324  
  1325      xyz_Temp   (1,1,1) = Temp
  1326      xyz_QVapSat(1,1,1) = QVapSat
  1327  
  1328      xyz_DQVapSatDTemp = xyz_CalcDQVapSatDTempOnSol( xyz_Temp, xyz_QVapSat )
  1329  
  1330      DQVapSatDTemp = xyz_DQVapSatDTemp(1,1,1)
  1331  
  1332  
  1333    end function CalcDQVapSatDTempOnSol
  1334  
  1335    !-------------------------------------------------------------------
  1336  
  1337    subroutine SaturateInit
  1338      !
  1339      ! saturate モジュールの初期化を行います.
  1340      !--
  1341      ! NAMELIST#saturate_nml の読み込みはこの手続きで行われます.
  1342      !++
  1343      !
  1344      ! "saturate" module is initialized.
  1345      !--
  1346      ! "NAMELIST#saturate_nml" is loaded in this procedure.
  1347      !++
  1348  
  1349      ! モジュール引用 ; USE statements
  1350      !
  1351  
  1352      ! NAMELIST ファイル入力に関するユーティリティ
  1353      ! Utilities for NAMELIST file input
  1354      !
  1355      use namelist_util, only: namelist_filename, NmlutilMsg
  1356  
  1357      ! ファイル入出力補助
  1358      ! File I/O support
  1359      !
  1360      use dc_iounit, only: FileOpen
  1361  
  1362      ! 種別型パラメタ
  1363      ! Kind type parameter
  1364      !
  1365      use dc_types, only: STDOUT ! 標準出力の装置番号. Unit number of standard output
  1366  
  1367      ! 文字列操作
  1368      ! Character handling
  1369      !
  1370      use dc_string, only: StoA
  1371  
  1372      ! ヒストリデータ出力
  1373      ! History data output
  1374      !
  1375      use gtool_historyauto, only: HistoryAutoAddVariable
  1376  
  1377      ! 雪, 氷の割合
  1378      ! snow/ice fraction
  1379      !
  1380      use snowice_frac, only : SnowIceFracInit
  1381  
  1382      ! 宣言文 ; Declaration statements
  1383      !
  1384      implicit none
  1385  
  1386      character(STRING) :: SaturateWatIceFracType
  1387  
  1388      integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号.
  1389                                ! Unit number for NAMELIST file open
  1390      integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT.
  1391                                ! IOSTAT of NAMELIST read
  1392  
  1393      ! NAMELIST 変数群
  1394      ! NAMELIST group name
  1395      !
  1396      namelist /saturate_nml/     &
  1397        & SaturateWatIceFracType, &
  1398        & TempWatLim,             &
  1399        & TempIceLim
  1400            !
  1401            ! デフォルト値については初期化手続 "saturate#SaturateInit"
  1402            ! のソースコードを参照のこと.
  1403            !
  1404            ! Refer to source codes in the initialization procedure
  1405            ! "saturate#SaturateInit" for the default values.
  1406            !
  1407  
  1408      ! 実行文 ; Executable statement
  1409      !
  1410  
  1411      if ( saturate_inited ) return
  1412  
  1413      ! デフォルト値の設定
  1414      ! Default values settings
  1415      !
  1416      SaturateWatIceFracType = 'Lin'
  1417  
  1418  !!$    TempWatLim          = 273.15_DP
  1419  !!$    TempIceLim          = 273.15_DP - 40.0_DP
  1420      TempWatLim          = 0.0_DP
  1421      TempIceLim          = 0.0_DP
  1422  
  1423  
  1424      ! NAMELIST の読み込み
  1425      ! NAMELIST is input
  1426      !
  1427      if ( trim(namelist_filename) /= '' ) then
  1428        call FileOpen( unit_nml, &          ! (out)
  1429          & namelist_filename, mode = 'r' ) ! (in)
  1430  
  1431        rewind( unit_nml )
  1432        read( unit_nml, &           ! (in)
  1433          & nml = saturate_nml, &  ! (out)
  1434          & iostat = iostat_nml )   ! (out)
  1435        close( unit_nml )
  1436  
  1437        call NmlutilMsg( iostat_nml, module_name ) ! (in)
  1438      end if
  1439  
  1440  
  1441      select case ( SaturateWatIceFracType )
  1442      case ( 'Lin' )
  1443        IDWatIceFracMethod = IDWatIceFracMethodLin
  1444      case ( 'Quad' )
  1445        IDWatIceFracMethod = IDWatIceFracMethodQuad
  1446      case default
  1447        call MessageNotify( 'E', module_name,         &
  1448          & 'SaturateWatIceFracType=<%c> is not supported.', &
  1449          & c1 = trim(SaturateWatIceFracType) )
  1450      end select
  1451  
  1452  
  1453      ! Initialization of modules used in this module
  1454      !
  1455  
  1456      call SaturateInitCore
  1457  
  1458      ! 雪, 氷の割合
  1459      ! snow/ice fraction
  1460      !
  1461      call SnowIceFracInit
  1462  
  1463  
  1464      ! 印字 ; Print
  1465      !
  1466      call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
  1467      call MessageNotify( 'M', module_name, 'Scheme of saturation = %c', &
  1468        & c1 = saturate_scheme )
  1469      call MessageNotify( 'M', module_name, 'SaturateWatIceFracType = %c', c1 = trim(SaturateWatIceFracType) )
  1470      call MessageNotify( 'M', module_name, 'TempWatLim             = %f', d = (/TempWatLim/) )
  1471      call MessageNotify( 'M', module_name, 'TempIceLim             = %f', d = (/TempIceLim/) )
  1472      call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
  1473  
  1474      saturate_inited = .true.
  1475  
  1476  
  1477    end subroutine SaturateInit
  1478  
  1479    !-------------------------------------------------------------------
  1480  
  1481  end module saturate
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:27 2016
FILE NAME: i.saturate.F90
PROGRAM NAME: saturate
FORMAT LIST

  LINE    LOOP      FORTRAN STATEMENT

     1:             != 飽和比湿の算出
     2:             !
     3:             != Evaluate saturation specific humidity
     4:             !
     5:             ! Authors::   Yoshiyuki O. Takahashi
     6:             ! Version::   $Id: saturate.F90,v 1.7 2015/01/29 12:07:16 yot Exp $
     7:             ! Tag Name::  $Name:  $
     8:             ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9:             ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10:             !
    11:             
    12:             module saturate
    13:               !
    14:               != 飽和比湿の算出
    15:               !
    16:               != Evaluate saturation specific humidity
    17:               !
    18:               ! <b>Note that Japanese and English are described in parallel.</b>
    19:               !
    20:               ! 飽和比湿および飽和比湿の温度微分の値を算出します. 
    21:               !
    22:               ! Saturation specific humidity and temperature derivative of it are calculated. 
    23:               !
    24:               ! 飽和比湿の計算にはデフォルトでは, Dennou AGCM で用いた式を用いる
    25:               ! (saturate_DennouAGCM 参照). 
    26:               ! また, Config.mk の CPPFLAGS に -DLIB_SATURATE_NHA1992 を指定すると
    27:               ! Nakajima et al. (1992) を用いる (saturate_tnha1992 参照). 
    28:               !
    29:               ! By default, a formula used by Dennou AGCM is used for calculation of 
    30:               ! saturation specific humidity (See "saturate_DennouAGCM"). 
    31:               ! If "-DLIB_SATURATE_NHA1992" is specified to "CPPFLAGS" in Config.mk, 
    32:               ! Nakajima et al. (1992) is used (See "saturate_nha1992"). 
    33:               !
    34:               !== References
    35:               !
    36:               !== Procedures List
    37:               !
    38:               ! CalcQVapSat            :: 飽和比湿の計算
    39:               ! CalcDQVapSatDTemp      :: 飽和比湿の温度微分の計算
    40:               ! ------------  :: ------------
    41:               ! CalcQVapSat            :: Calculate saturation specific humidity
    42:               ! CalcDQVapSatDTemp      :: Calculate temperature derivative of saturation specific humidity
    43:               !
    44:               !--
    45:               !== NAMELIST
    46:               !
    47:               ! NAMELIST#saturate_nml
    48:               !++
    49:             
    50:               ! モジュール引用 ; USE statements
    51:               !
    52:             
    53:               ! 種別型パラメタ
    54:               ! Kind type parameter
    55:               !
    56:               use dc_types, only: DP, &      ! 倍精度実数型. Double precision. 
    57:                 &                 STRING     ! 文字列.       Strings. 
    58:             
    59:               ! メッセージ出力
    60:               ! Message output
    61:               !
    62:               use dc_message, only: MessageNotify
    63:             
    64:             
    65:             
    66:               ! Dennou AGCM の式を用いた飽和比湿の算出
    67:               ! Evaluate saturation specific humidity with method used by Dennou AGCM
    68:               !
    69:               use saturate_DennouAGCM, only:                          &
    70:             
    71:                 & xyz_CalcQVapSatOnLiq,       &
    72:                 & xyz_CalcDQVapSatDTempOnLiq, &
    73:                 & xyz_CalcQVapSatOnSol,       &
    74:                 & xyz_CalcDQVapSatDTempOnSol, &
    75:                 & SaturateInitCore => SaturateInit
    76:             
    77:             
    78:               ! 宣言文 ; Declaration statements
    79:               !
    80:               implicit none
    81:               private
    82:             
    83:               ! 公開手続き
    84:               ! Public procedure
    85:               !
    86:               public:: SaturateWatFraction
    87:             
    88:               public:: xyz_CalcQVapSat
    89:               public:: xyz_CalcDQVapSatDTemp
    90:               public:: xy_CalcQVapSat
    91:               public:: xy_CalcDQVapSatDTemp
    92:               public:: a_CalcQVapSat
    93:               public:: a_CalcDQVapSatDTemp
    94:               public:: CalcQVapSat
    95:               public:: CalcDQVapSatDTemp
    96:             
    97:               public:: xyz_CalcQVapSatOnLiq
    98:               public:: xyz_CalcDQVapSatDTempOnLiq
    99:               public:: xy_CalcQVapSatOnLiq
   100:               public:: xy_CalcDQVapSatDTempOnLiq
   101:               public:: a_CalcQVapSatOnLiq
   102:               public:: a_CalcDQVapSatDTempOnLiq
   103:               public:: CalcQVapSatOnLiq
   104:               public:: CalcDQVapSatDTempOnLiq
   105:             
   106:               public:: xyz_CalcQVapSatOnSol
   107:               public:: xyz_CalcDQVapSatDTempOnSol
   108:               public:: xy_CalcQVapSatOnSol
   109:               public:: xy_CalcDQVapSatDTempOnSol
   110:               public:: a_CalcQVapSatOnSol
   111:               public:: a_CalcDQVapSatDTempOnSol
   112:               public:: CalcQVapSatOnSol
   113:               public:: CalcDQVapSatDTempOnSol
   114:             
   115:               public:: SaturateInit
   116:             
   117:             
   118:               ! 公開変数
   119:               ! Public variables
   120:               !
   121:               logical, save, public:: saturate_inited = .false.
   122:                                           ! 初期設定フラグ. 
   123:                                           ! Initialization flag
   124:             
   125:               ! 非公開変数
   126:               ! Private variables
   127:               !
   128:               integer , save        :: IDWatIceFracMethod
   129:               integer , parameter   :: IDWatIceFracMethodLin  = 1
   130:               integer , parameter   :: IDWatIceFracMethodQuad = 2
   131:               real(DP), save        :: TempWatLim
   132:               real(DP), save        :: TempIceLim
   133:             
   134:             
   135:               character(*), parameter:: saturate_scheme = &
   136:             
   137:                 & 'Dennou AGCM'
   138:             
   139:               character(*), parameter:: module_name = 'saturate'
   140:                                           ! モジュールの名称. 
   141:                                           ! Module name
   142:             
   143:               character(*), parameter:: version = &
   144:                 & '$Name:  $' // &
   145:                 & '$Id: saturate.F90,v 1.7 2015/01/29 12:07:16 yot Exp $'
   146:                                           ! モジュールのバージョン
   147:                                           ! Module version
   148:             
   149:               interface SaturateWatFraction
   150:                 module procedure &
   151:                   & SaturateWatFraction3D, &
   152:                   & SaturateWatFraction0D
   153:               end interface SaturateWatFraction
   154:             
   155:               !--------------------------------------------------------------------------------------
   156:             
   157:             contains
   158:             
   159:               !--------------------------------------------------------------------------------------
   160:             
   161:               subroutine SaturateWatFraction3D( &
   162:                 & xyz_Temp,                     & ! (in )
   163:                 & xyz_WatFrac                   & ! (out)
   164:                 & )
   165:             
   166:                 ! USE statements
   167:                 !
   168:             
   169:             !!$    real(DP), intent(in ) :: xyz_Temp   (0:imax-1, 1:jmax, 1:kmax)
   170:             !!$    real(DP), intent(out) :: xyz_WatFrac(0:imax-1, 1:jmax, 1:kmax)
   171:                 real(DP), intent(in ) :: xyz_Temp   (:,:,:)
   172:                 real(DP), intent(out) :: xyz_WatFrac(:,:,:)
   173:             
   174:             
   175:                 ! 実行文 ; Executable statement
   176:                 !
   177:             
   178:                 ! 初期化確認
   179:                 ! Initialization check
   180:                 !
   181:                 if ( .not. saturate_inited ) then
   182:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   183:                 end if
   184:             
   185:             
   186:             !!$    if ( FlagSnow ) then
   187:             
   188:                 if ( TempWatLim == TempIceLim ) then
   189: ++V==== A         xyz_WatFrac = ( sign( 1.0_DP, xyz_Temp - TempWatLim ) + 1.0_DP ) / 2.0_DP
   190:                 else
   191:                   select case ( IDWatIceFracMethod )
   192:                   case ( IDWatIceFracMethodLin  )
   193: ++V==== A           xyz_WatFrac =   ( xyz_Temp - TempIceLim ) / ( TempWatLim - TempIceLim )
   194:                   case ( IDWatIceFracMethodQuad )
   195: ++V==== A           xyz_WatFrac = ( max( xyz_Temp - TempIceLim, 0.0_DP ) / ( TempWatLim - TempIceLim ) )**2
   196:                   end select
   197: ++V==== A         xyz_WatFrac = max( min( xyz_WatFrac, 1.0_DP ), 0.0_DP )
   198:                 end if
   199:             
   200:             !!$    else
   201:             !!$
   202:             !!$      xyz_WatFrac = 1.0_DP
   203:             !!$
   204:             !!$    end if
   205:             
   206:             
   207:               end subroutine SaturateWatFraction3D
   208:             
   209:               !--------------------------------------------------------------------------------------
   210:             
   211:               subroutine SaturateWatFraction0D( &
   212:                 & Temp,                       & ! (in )
   213:                 & WatFrac                     & ! (out)
   214:                 & )
   215:             
   216:                 ! USE statements
   217:                 !
   218:             
   219:                 real(DP), intent(in ) :: Temp
   220:                 real(DP), intent(out) :: WatFrac
   221:             
   222:             
   223:                 real(DP) :: xyz_Temp   (1,1,1)
   224:                 real(DP) :: xyz_WatFrac(1,1,1)
   225:             
   226:                 ! 実行文 ; Executable statement
   227:                 !
   228:             
   229:                 ! 初期化確認
   230:                 ! Initialization check
   231:                 !
   232:                 if ( .not. saturate_inited ) then
   233:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   234:                 end if
   235:             
   236:             
   237: ***====         xyz_Temp = Temp
   238:                 call SaturateWatFraction3D( &
   239:                   & xyz_Temp,               & ! (in )
   240:                   & xyz_WatFrac             & ! (out)
   241:                   & )
   242:                 WatFrac = xyz_WatFrac(1,1,1)
   243:             
   244:             
   245:               end subroutine SaturateWatFraction0D
   246:             
   247:               !-------------------------------------------------------------------
   248:               ! [Mixed phase]
   249:               !-------------------------------------------------------------------
   250:             
   251:               function xyz_CalcQVapSat( xyz_Temp, xyz_Press ) result( xyz_QVapSat )
   252:                 !
   253:                 ! 温度 *Temp* と気圧 *Press* を用い, 
   254:                 ! 飽和比湿 *QVapSat* を求めます. 
   255:                 !
   256:                 ! Calculate saturation specific humidity *QVapSat* using
   257:                 ! temperature *Temp* and air pressure *Press*. 
   258:                 !
   259:             
   260:                 ! モジュール引用 ; USE statements
   261:                 !
   262:             
   263:             
   264:                 ! 宣言文 ; Declaration statements
   265:                 !
   266:                 implicit none
   267:             
   268:                 real(DP), intent(in):: xyz_Temp (:,:,:)
   269:                                           ! $ T $ . 温度. Temperature
   270:                 real(DP), intent(in):: xyz_Press(:,:,:)
   271:                                           ! $ p $ . 気圧. Air pressure
   272:             
   273:                 real(DP):: xyz_QVapSat(1:size(xyz_Temp,1), 1:size(xyz_Temp,2), 1:size(xyz_Temp,3))
   274:                                           ! $ q^{*} $ . 飽和比湿. Saturation specific humidity
   275:             
   276:                 ! 作業変数
   277:                 ! Work variables
   278:                 !
   279:                 real(DP):: xyz_QVapSatOnLiq(1:size(xyz_Temp,1), 1:size(xyz_Temp,2), 1:size(xyz_Temp,3))
   280:                 real(DP):: xyz_QVapSatOnSol(1:size(xyz_Temp,1), 1:size(xyz_Temp,2), 1:size(xyz_Temp,3))
   281:                 real(DP):: xyz_WatFrac     (1:size(xyz_Temp,1), 1:size(xyz_Temp,2), 1:size(xyz_Temp,3))
   282:             
   283:             
   284:                 ! 実行文 ; Executable statement
   285:                 !
   286:             
   287:                 ! 初期化確認
   288:                 ! Initialization check
   289:                 !
   290:             
   291:                 if ( .not. saturate_inited ) then
   292:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   293:                 end if
   294:             
   295:             
   296:                 xyz_QVapSatOnLiq = xyz_CalcQVapSatOnLiq( xyz_Temp, xyz_Press )
   297:                 xyz_QVapSatOnSol = xyz_CalcQVapSatOnSol( xyz_Temp, xyz_Press )
   298:             
   299:                 call SaturateWatFraction( &
   300:                   & xyz_Temp,             & ! (in )
   301:                   & xyz_WatFrac           & ! (out)
   302:                   & )
   303:             
   304: ++V==== A       xyz_QVapSat =                                     &
   305:                   &   xyz_WatFrac              * xyz_QVapSatOnLiq &
   306:                   & + ( 1.0_DP - xyz_WatFrac ) * xyz_QVapSatOnSol
   307:             
   308:             
   309:               end function xyz_CalcQVapSat
   310:             
   311:               !--------------------------------------------------------------------------------------
   312:             
   313:               function xyz_CalcDQVapSatDTemp( xyz_Temp, xyz_QVapSat ) result( xyz_DQVapSatDTemp )
   314:                 !
   315:                 ! 温度 *Temp* と飽和比湿 *QVapSat* を用い, 
   316:                 ! 飽和比湿の温度微分 *DQVapSatDTemp* を求めます. 
   317:                 !
   318:                 ! Calculate temperature derivative of saturation specific humidity 
   319:                 ! *DQVapSatDTemp* using
   320:                 ! temperature *Temp* and saturation specific humidity *QVapSat*. 
   321:                 !
   322:             
   323:                 ! モジュール引用 ; USE statements
   324:                 !
   325:             
   326:                 ! 宣言文 ; Declaration statements
   327:                 !
   328:                 implicit none
   329:             
   330:                 real(DP), intent(in):: xyz_Temp   (:,:,:)
   331:                                           ! $ T $ . 温度. Temperature
   332:                 real(DP), intent(in):: xyz_QVapSat(:,:,:)
   333:                                           ! $ q^{*} $ . 飽和比湿. Saturation specific humidity
   334:                 real(DP):: xyz_DQVapSatDTemp(size(xyz_Temp,1), size(xyz_Temp,2), size(xyz_Temp,3))
   335:                                           ! $ \DP{q^{*}}{T} $ . 飽和比湿の温度微分. 
   336:                                           ! Temperature derivative of saturation specific humidity. 
   337:             
   338:                 ! 作業変数
   339:                 ! Work variables
   340:                 !
   341:                 real(DP):: xyz_DQVapSatDTempOnLiq(size(xyz_Temp,1), size(xyz_Temp,2), size(xyz_Temp,3))
   342:                 real(DP):: xyz_DQVapSatDTempOnSol(size(xyz_Temp,1), size(xyz_Temp,2), size(xyz_Temp,3))
   343:                 real(DP):: xyz_WatFrac           (size(xyz_Temp,1), size(xyz_Temp,2), size(xyz_Temp,3))
   344:             
   345:             
   346:                 ! 実行文 ; Executable statement
   347:                 !
   348:             
   349:                 if ( .not. saturate_inited ) then
   350:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   351:                 end if
   352:             
   353:             
   354:                 xyz_DQVapSatDTempOnLiq = xyz_CalcDQVapSatDTempOnLiq( xyz_Temp, xyz_QVapSat )
   355:                 xyz_DQVapSatDTempOnSol = xyz_CalcDQVapSatDTempOnSol( xyz_Temp, xyz_QVapSat )
   356:             
   357:                 call SaturateWatFraction( &
   358:                   & xyz_Temp,             & ! (in )
   359:                   & xyz_WatFrac           & ! (out)
   360:                   & )
   361:             
   362: ++V==== A       xyz_DQVapSatDTemp =                                     &
   363:                   &   xyz_WatFrac              * xyz_DQVapSatDTempOnLiq &
   364:                   & + ( 1.0_DP - xyz_WatFrac ) * xyz_DQVapSatDTempOnSol
   365:             
   366:             
   367:               end function xyz_CalcDQVapSatDTemp
   368:             
   369:               !-------------------------------------------------------------------
   370:               ! [Mixed phase] Interfaces for 2D, 1D, and scalar variables
   371:               !-------------------------------------------------------------------
   372:             
   373:               function xy_CalcQVapSat( xy_Temp, xy_Press ) result( xy_QVapSat )
   374:                 !
   375:                 ! 温度 *Temp* と気圧 *Press* を用い, 
   376:                 ! 飽和比湿 *QVapSat* を求めます. 
   377:                 !
   378:                 ! Calculate saturation specific humidity *QVapSat* using
   379:                 ! temperature *Temp* and air pressure *Press*. 
   380:                 !
   381:             
   382:                 ! モジュール引用 ; USE statements
   383:                 !
   384:             
   385:                 ! 宣言文 ; Declaration statements
   386:                 !
   387:                 implicit none
   388:             
   389:                 real(DP), intent(in):: xy_Temp (:,:)
   390:                                           ! $ T $ . 温度. Temperature
   391:                 real(DP), intent(in):: xy_Press(:,:)
   392:                                           ! $ p $ . 気圧. Air pressure
   393:             
   394:                 real(DP):: xy_QVapSat(size(xy_Temp,1), size(xy_Temp,2))
   395:                                           ! $ q^{*} $ . 飽和比湿. Saturation specific humidity
   396:             
   397:                 ! 作業変数
   398:                 ! Work variables
   399:                 !
   400:                 real(DP) :: xyz_Temp   (size(xy_Temp,1),size(xy_Temp,2),1)
   401:                 real(DP) :: xyz_Press  (size(xy_Temp,1),size(xy_Temp,2),1)
   402:                 real(DP) :: xyz_QVapSat(size(xy_Temp,1),size(xy_Temp,2),1)
   403:             
   404:             
   405:                 ! 実行文 ; Executable statement
   406:                 !
   407:             
   408:                 if ( .not. saturate_inited ) then
   409:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   410:                 end if
   411:             
   412:             
   413: *V----->A       xyz_Temp (:,:,1) = xy_Temp
   414: *V----- A       xyz_Press(:,:,1) = xy_Press
   415:             
   416:                 xyz_QVapSat = xyz_CalcQVapSat( xyz_Temp, xyz_Press )
   417:             
   418: +V===== A       xy_QVapSat = xyz_QVapSat(:,:,1)
   419:             
   420:             
   421:               end function xy_CalcQVapSat
   422:             
   423:               !-------------------------------------------------------------------
   424:             
   425:               function xy_CalcDQVapSatDTemp( xy_Temp, xy_QVapSat ) result( xy_DQVapSatDTemp )
   426:                 !
   427:                 ! 温度 *Temp* と飽和比湿 *QVapSat* を用い, 
   428:                 ! 飽和比湿の温度微分 *DQVapSatDTemp* を求めます. 
   429:                 !
   430:                 ! Calculate temperature derivative of saturation specific humidity 
   431:                 ! *DQVapSatDTemp* using
   432:                 ! temperature *Temp* and saturation specific humidity *QVapSat*. 
   433:                 !
   434:             
   435:                 ! モジュール引用 ; USE statements
   436:                 !
   437:             
   438:                 ! 宣言文 ; Declaration statements
   439:                 !
   440:                 implicit none
   441:             
   442:                 real(DP), intent(in):: xy_Temp   (:,:)
   443:                                           ! $ T $ . 温度. Temperature
   444:                 real(DP), intent(in):: xy_QVapSat(:,:)
   445:                                           ! $ q^{*} $ . 飽和比湿. Saturation specific humidity
   446:                 real(DP):: xy_DQVapSatDTemp(size(xy_Temp,1), size(xy_Temp,2))
   447:                                           ! $ \DP{q^{*}}{T} $ . 飽和比湿の温度微分. 
   448:                                           ! Temperature derivative of saturation specific humidity. 
   449:             
   450:                 ! 作業変数
   451:                 ! Work variables
   452:                 !
   453:                 real(DP):: xyz_Temp         (size(xy_Temp,1), size(xy_Temp,2), 1)
   454:                 real(DP):: xyz_QVapSat      (size(xy_Temp,1), size(xy_Temp,2), 1)
   455:                 real(DP):: xyz_DQVapSatDTemp(size(xy_Temp,1), size(xy_Temp,2), 1)
   456:             
   457:                 ! 実行文 ; Executable statement
   458:                 !
   459:             
   460:                 if ( .not. saturate_inited ) then
   461:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   462:                 end if
   463:             
   464:             
   465: *V----->A       xyz_Temp   (:,:,1) = xy_Temp
   466: *V----- A       xyz_QVapSat(:,:,1) = xy_QVapSat
   467:             
   468:                 xyz_DQVapSatDTemp = xyz_CalcDQVapSatDTemp( xyz_Temp, xyz_QVapSat )
   469:             
   470: +V===== A       xy_DQVapSatDTemp = xyz_DQVapSatDTemp(:,:,1)
   471:             
   472:             
   473:               end function xy_CalcDQVapSatDTemp
   474:             
   475:               !--------------------------------------------------------------------------------------
   476:             
   477:               function a_CalcQVapSat( a_Temp, a_Press ) result( a_QVapSat )
   478:                 !
   479:                 ! 温度 *Temp* と気圧 *Press* を用い, 
   480:                 ! 飽和比湿 *QVapSat* を求めます. 
   481:                 !
   482:                 ! Calculate saturation specific humidity *QVapSat* using
   483:                 ! temperature *Temp* and air pressure *Press*. 
   484:                 !
   485:             
   486:                 ! モジュール引用 ; USE statements
   487:                 !
   488:             
   489:                 ! 宣言文 ; Declaration statements
   490:                 !
   491:                 implicit none
   492:             
   493:                 real(DP), intent(in):: a_Temp (:)
   494:                                           ! $ T $ . 温度. Temperature
   495:                 real(DP), intent(in):: a_Press(:)
   496:                                           ! $ p $ . 気圧. Air pressure
   497:             
   498:                 real(DP):: a_QVapSat(size(a_Temp,1))
   499:                                           ! $ q^{*} $ . 飽和比湿. Saturation specific humidity
   500:             
   501:                 ! 作業変数
   502:                 ! Work variables
   503:                 !
   504:                 real(DP):: xyz_Temp   (size(a_Temp,1), 1, 1)
   505:                                           ! $ T $ . 温度. Temperature
   506:                 real(DP):: xyz_Press  (size(a_Temp,1), 1, 1)
   507:                                           ! $ p $ . 気圧. Air pressure
   508:                 real(DP):: xyz_QVapSat(size(a_Temp,1), 1, 1)
   509:                                           ! $ q^{*} $ . 飽和比湿. Saturation specific humidity
   510:             
   511:                 if ( .not. saturate_inited ) then
   512:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   513:                 end if
   514:             
   515:             
   516: V------>A       xyz_Temp (:,1,1) = a_Temp
   517: V------ A       xyz_Press(:,1,1) = a_Press
   518:             
   519:                 xyz_QVapSat = xyz_CalcQVapSat( xyz_Temp, xyz_Press )
   520:             
   521: V====== A       a_QVapSat = xyz_QVapSat(:,1,1)
   522:             
   523:             
   524:               end function a_CalcQVapSat
   525:             
   526:               !--------------------------------------------------------------------------------------
   527:             
   528:               function a_CalcDQVapSatDTemp( a_Temp, a_QVapSat ) result( a_DQVapSatDTemp )
   529:                 !
   530:                 ! 温度 *Temp* と飽和比湿 *QVapSat* を用い, 
   531:                 ! 飽和比湿の温度微分 *DQVapSatDTemp* を求めます. 
   532:                 !
   533:                 ! Calculate temperature derivative of saturation specific humidity 
   534:                 ! *DQVapSatDTemp* using
   535:                 ! temperature *Temp* and saturation specific humidity *QVapSat*. 
   536:                 !
   537:             
   538:                 ! モジュール引用 ; USE statements
   539:                 !
   540:             
   541:                 ! 宣言文 ; Declaration statements
   542:                 !
   543:                 implicit none
   544:             
   545:                 real(DP), intent(in):: a_Temp   (:)
   546:                                           ! $ T $ . 温度. Temperature
   547:                 real(DP), intent(in):: a_QVapSat(:)
   548:                                           ! $ q^{*} $ . 飽和比湿. Saturation specific humidity
   549:                 real(DP):: a_DQVapSatDTemp(size(a_Temp,1))
   550:                                           ! $ \DP{q^{*}}{T} $ . 飽和比湿の温度微分. 
   551:                                           ! Temperature derivative of saturation specific humidity. 
   552:             
   553:                 ! 作業変数
   554:                 ! Work variables
   555:                 !
   556:                 real(DP):: xyz_Temp   (size(a_Temp,1), 1:1, 1:1)
   557:                                           ! $ T $ . 温度. Temperature
   558:                 real(DP):: xyz_QVapSat(size(a_Temp,1), 1:1, 1:1)
   559:                                           ! $ q^{*} $ . 飽和比湿. Saturation specific humidity
   560:                 real(DP):: xyz_DQVapSatDTemp(size(a_Temp,1), 1:1, 1:1)
   561:                                           ! $ \DP{q^{*}}{T} $ . 飽和比湿の温度微分. 
   562:                                           ! Temperature derivative of saturation specific humidity. 
   563:             
   564:             
   565:                 ! 実行文 ; Executable statement
   566:                 !
   567:             
   568:                 if ( .not. saturate_inited ) then
   569:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   570:                 end if
   571:             
   572:             
   573: V------>A       xyz_Temp   (:,1,1) = a_Temp
   574: V------ A       xyz_QVapSat(:,1,1) = a_QVapSat
   575:             
   576:                 xyz_DQVapSatDTemp = xyz_CalcDQVapSatDTemp( xyz_Temp, xyz_QVapSat )
   577:             
   578: V====== A       a_DQVapSatDTemp = xyz_DQVapSatDTemp(:,1,1)
   579:             
   580:             
   581:               end function a_CalcDQVapSatDTemp
   582:             
   583:               !--------------------------------------------------------------------------------------
   584:             
   585:               function CalcQVapSat( Temp, Press ) result( QVapSat )
   586:                 !
   587:                 ! 温度 *Temp* と気圧 *Press* を用い, 
   588:                 ! 飽和比湿 *QVapSat* を求めます. 
   589:                 !
   590:                 ! Calculate saturation specific humidity *QVapSat* using
   591:                 ! temperature *Temp* and air pressure *Press*. 
   592:                 !
   593:             
   594:                 ! モジュール引用 ; USE statements
   595:                 !
   596:             
   597:                 ! 宣言文 ; Declaration statements
   598:                 !
   599:                 implicit none
   600:             
   601:                 real(DP), intent(in):: Temp
   602:                                           ! $ T $ . 温度. Temperature
   603:                 real(DP), intent(in):: Press
   604:                                           ! $ p $ . 気圧. Air pressure
   605:             
   606:                 real(DP):: QVapSat
   607:                                           ! $ q^{*} $ . 飽和比湿. Saturation specific humidity
   608:             
   609:                 ! 作業変数
   610:                 ! Work variables
   611:                 !
   612:                 real(DP):: xyz_Temp   (1, 1, 1)
   613:                                           ! $ T $ . 温度. Temperature
   614:                 real(DP):: xyz_Press  (1, 1, 1)
   615:                                           ! $ p $ . 気圧. Air pressure
   616:                 real(DP):: xyz_QVapSat(1, 1, 1)
   617:                                           ! $ q^{*} $ . 飽和比湿. Saturation specific humidity
   618:             
   619:                 if ( .not. saturate_inited ) then
   620:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   621:                 end if
   622:             
   623:             
   624: *------>        xyz_Temp (:,1,1) = Temp
   625: *------         xyz_Press(:,1,1) = Press
   626:             
   627:                 xyz_QVapSat = xyz_CalcQVapSat( xyz_Temp, xyz_Press )
   628:             
   629:                 QVapSat = xyz_QVapSat(1,1,1)
   630:             
   631:             
   632:               end function CalcQVapSat
   633:             
   634:               !--------------------------------------------------------------------------------------
   635:             
   636:               function CalcDQVapSatDTemp( Temp, QVapSat ) result( DQVapSatDTemp )
   637:                 !
   638:                 ! 温度 *Temp* と飽和比湿 *QVapSat* を用い, 
   639:                 ! 飽和比湿の温度微分 *DQVapSatDTemp* を求めます. 
   640:                 !
   641:                 ! Calculate temperature derivative of saturation specific humidity 
   642:                 ! *DQVapSatDTemp* using
   643:                 ! temperature *Temp* and saturation specific humidity *QVapSat*. 
   644:                 !
   645:             
   646:                 ! モジュール引用 ; USE statements
   647:                 !
   648:             
   649:                 ! 宣言文 ; Declaration statements
   650:                 !
   651:                 implicit none
   652:             
   653:                 real(DP), intent(in):: Temp
   654:                                           ! $ T $ . 温度. Temperature
   655:                 real(DP), intent(in):: QVapSat
   656:                                           ! $ q^{*} $ . 飽和比湿. Saturation specific humidity
   657:                 real(DP):: DQVapSatDTemp
   658:                                           ! $ \DP{q^{*}}{T} $ . 飽和比湿の温度微分. 
   659:                                           ! Temperature derivative of saturation specific humidity. 
   660:             
   661:                 ! 作業変数
   662:                 ! Work variables
   663:                 !
   664:                 real(DP):: xyz_Temp   (1:1, 1:1, 1:1)
   665:                                           ! $ T $ . 温度. Temperature
   666:                 real(DP):: xyz_QVapSat(1:1, 1:1, 1:1)
   667:                                           ! $ q^{*} $ . 飽和比湿. Saturation specific humidity
   668:                 real(DP):: xyz_DQVapSatDTemp(1:1, 1:1, 1:1)
   669:                                           ! $ \DP{q^{*}}{T} $ . 飽和比湿の温度微分. 
   670:                                           ! Temperature derivative of saturation specific humidity. 
   671:             
   672:             
   673:                 ! 実行文 ; Executable statement
   674:                 !
   675:             
   676:                 if ( .not. saturate_inited ) then
   677:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   678:                 end if
   679:             
   680:             
   681:                 xyz_Temp   (1,1,1) = Temp
   682:                 xyz_QVapSat(1,1,1) = QVapSat
   683:             
   684:                 xyz_DQVapSatDTemp = xyz_CalcDQVapSatDTemp( xyz_Temp, xyz_QVapSat )
   685:             
   686:                 DQVapSatDTemp = xyz_DQVapSatDTemp(1,1,1)
   687:             
   688:             
   689:               end function CalcDQVapSatDTemp
   690:             
   691:               !-------------------------------------------------------------------
   692:               ! [On liquid] Interfaces for 2D, 1D, and scalar variables
   693:               !-------------------------------------------------------------------
   694:             
   695:               function xy_CalcQVapSatOnLiq( xy_Temp, xy_Press ) result( xy_QVapSat )
   696:                 !
   697:                 ! 温度 *Temp* と気圧 *Press* を用い, 
   698:                 ! 飽和比湿 *QVapSat* を求めます. 
   699:                 !
   700:                 ! Calculate saturation specific humidity *QVapSat* using
   701:                 ! temperature *Temp* and air pressure *Press*. 
   702:                 !
   703:             
   704:                 ! モジュール引用 ; USE statements
   705:                 !
   706:             
   707:                 ! 宣言文 ; Declaration statements
   708:                 !
   709:                 implicit none
   710:             
   711:                 real(DP), intent(in):: xy_Temp (:,:)
   712:                                           ! $ T $ . 温度. Temperature
   713:                 real(DP), intent(in):: xy_Press(:,:)
   714:                                           ! $ p $ . 気圧. Air pressure
   715:             
   716:                 real(DP):: xy_QVapSat(size(xy_Temp,1), size(xy_Temp,2))
   717:                                           ! $ q^{*} $ . 飽和比湿. Saturation specific humidity
   718:             
   719:                 ! 作業変数
   720:                 ! Work variables
   721:                 !
   722:                 real(DP) :: xyz_Temp   (size(xy_Temp,1),size(xy_Temp,2),1)
   723:                 real(DP) :: xyz_Press  (size(xy_Temp,1),size(xy_Temp,2),1)
   724:                 real(DP) :: xyz_QVapSat(size(xy_Temp,1),size(xy_Temp,2),1)
   725:             
   726:             
   727:                 ! 実行文 ; Executable statement
   728:                 !
   729:             
   730:                 if ( .not. saturate_inited ) then
   731:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   732:                 end if
   733:             
   734:             
   735: *V----->A       xyz_Temp (:,:,1) = xy_Temp
   736: *V----- A       xyz_Press(:,:,1) = xy_Press
   737:             
   738:                 xyz_QVapSat = xyz_CalcQVapSatOnLiq( xyz_Temp, xyz_Press )
   739:             
   740: +V===== A       xy_QVapSat = xyz_QVapSat(:,:,1)
   741:             
   742:             
   743:               end function xy_CalcQVapSatOnLiq
   744:             
   745:               !-------------------------------------------------------------------
   746:             
   747:               function xy_CalcDQVapSatDTempOnLiq( xy_Temp, xy_QVapSat ) result( xy_DQVapSatDTemp )
   748:                 !
   749:                 ! 温度 *Temp* と飽和比湿 *QVapSat* を用い, 
   750:                 ! 飽和比湿の温度微分 *DQVapSatDTemp* を求めます. 
   751:                 !
   752:                 ! Calculate temperature derivative of saturation specific humidity 
   753:                 ! *DQVapSatDTemp* using
   754:                 ! temperature *Temp* and saturation specific humidity *QVapSat*. 
   755:                 !
   756:             
   757:                 ! モジュール引用 ; USE statements
   758:                 !
   759:             
   760:                 ! 宣言文 ; Declaration statements
   761:                 !
   762:                 implicit none
   763:             
   764:                 real(DP), intent(in):: xy_Temp   (:,:)
   765:                                           ! $ T $ . 温度. Temperature
   766:                 real(DP), intent(in):: xy_QVapSat(:,:)
   767:                                           ! $ q^{*} $ . 飽和比湿. Saturation specific humidity
   768:                 real(DP):: xy_DQVapSatDTemp(size(xy_Temp,1), size(xy_Temp,2))
   769:                                           ! $ \DP{q^{*}}{T} $ . 飽和比湿の温度微分. 
   770:                                           ! Temperature derivative of saturation specific humidity. 
   771:             
   772:                 ! 作業変数
   773:                 ! Work variables
   774:                 !
   775:                 real(DP):: xyz_Temp         (size(xy_Temp,1), size(xy_Temp,2), 1)
   776:                 real(DP):: xyz_QVapSat      (size(xy_Temp,1), size(xy_Temp,2), 1)
   777:                 real(DP):: xyz_DQVapSatDTemp(size(xy_Temp,1), size(xy_Temp,2), 1)
   778:             
   779:                 ! 実行文 ; Executable statement
   780:                 !
   781:             
   782:                 if ( .not. saturate_inited ) then
   783:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   784:                 end if
   785:             
   786:             
   787: *V----->A       xyz_Temp   (:,:,1) = xy_Temp
   788: *V----- A       xyz_QVapSat(:,:,1) = xy_QVapSat
   789:             
   790:                 xyz_DQVapSatDTemp = xyz_CalcDQVapSatDTempOnLiq( xyz_Temp, xyz_QVapSat )
   791:             
   792: +V===== A       xy_DQVapSatDTemp = xyz_DQVapSatDTemp(:,:,1)
   793:             
   794:             
   795:               end function xy_CalcDQVapSatDTempOnLiq
   796:             
   797:               !--------------------------------------------------------------------------------------
   798:             
   799:               function a_CalcQVapSatOnLiq( a_Temp, a_Press ) result( a_QVapSat )
   800:                 !
   801:                 ! 温度 *Temp* と気圧 *Press* を用い, 
   802:                 ! 飽和比湿 *QVapSat* を求めます. 
   803:                 !
   804:                 ! Calculate saturation specific humidity *QVapSat* using
   805:                 ! temperature *Temp* and air pressure *Press*. 
   806:                 !
   807:             
   808:                 ! モジュール引用 ; USE statements
   809:                 !
   810:             
   811:                 ! 宣言文 ; Declaration statements
   812:                 !
   813:                 implicit none
   814:             
   815:                 real(DP), intent(in):: a_Temp (:)
   816:                                           ! $ T $ . 温度. Temperature
   817:                 real(DP), intent(in):: a_Press(:)
   818:                                           ! $ p $ . 気圧. Air pressure
   819:             
   820:                 real(DP):: a_QVapSat(size(a_Temp,1))
   821:                                           ! $ q^{*} $ . 飽和比湿. Saturation specific humidity
   822:             
   823:                 ! 作業変数
   824:                 ! Work variables
   825:                 !
   826:                 real(DP):: xyz_Temp   (size(a_Temp,1), 1, 1)
   827:                                           ! $ T $ . 温度. Temperature
   828:                 real(DP):: xyz_Press  (size(a_Temp,1), 1, 1)
   829:                                           ! $ p $ . 気圧. Air pressure
   830:                 real(DP):: xyz_QVapSat(size(a_Temp,1), 1, 1)
   831:                                           ! $ q^{*} $ . 飽和比湿. Saturation specific humidity
   832:             
   833:                 if ( .not. saturate_inited ) then
   834:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   835:                 end if
   836:             
   837:             
   838: V------>A       xyz_Temp (:,1,1) = a_Temp
   839: V------ A       xyz_Press(:,1,1) = a_Press
   840:             
   841:                 xyz_QVapSat = xyz_CalcQVapSatOnLiq( xyz_Temp, xyz_Press )
   842:             
   843: V====== A       a_QVapSat = xyz_QVapSat(:,1,1)
   844:             
   845:             
   846:               end function a_CalcQVapSatOnLiq
   847:             
   848:               !--------------------------------------------------------------------------------------
   849:             
   850:               function a_CalcDQVapSatDTempOnLiq( a_Temp, a_QVapSat ) result( a_DQVapSatDTemp )
   851:                 !
   852:                 ! 温度 *Temp* と飽和比湿 *QVapSat* を用い, 
   853:                 ! 飽和比湿の温度微分 *DQVapSatDTemp* を求めます. 
   854:                 !
   855:                 ! Calculate temperature derivative of saturation specific humidity 
   856:                 ! *DQVapSatDTemp* using
   857:                 ! temperature *Temp* and saturation specific humidity *QVapSat*. 
   858:                 !
   859:             
   860:                 ! モジュール引用 ; USE statements
   861:                 !
   862:             
   863:                 ! 宣言文 ; Declaration statements
   864:                 !
   865:                 implicit none
   866:             
   867:                 real(DP), intent(in):: a_Temp   (:)
   868:                                           ! $ T $ . 温度. Temperature
   869:                 real(DP), intent(in):: a_QVapSat(:)
   870:                                           ! $ q^{*} $ . 飽和比湿. Saturation specific humidity
   871:                 real(DP):: a_DQVapSatDTemp(size(a_Temp,1))
   872:                                           ! $ \DP{q^{*}}{T} $ . 飽和比湿の温度微分. 
   873:                                           ! Temperature derivative of saturation specific humidity. 
   874:             
   875:                 ! 作業変数
   876:                 ! Work variables
   877:                 !
   878:                 real(DP):: xyz_Temp   (size(a_Temp,1), 1:1, 1:1)
   879:                                           ! $ T $ . 温度. Temperature
   880:                 real(DP):: xyz_QVapSat(size(a_Temp,1), 1:1, 1:1)
   881:                                           ! $ q^{*} $ . 飽和比湿. Saturation specific humidity
   882:                 real(DP):: xyz_DQVapSatDTemp(size(a_Temp,1), 1:1, 1:1)
   883:                                           ! $ \DP{q^{*}}{T} $ . 飽和比湿の温度微分. 
   884:                                           ! Temperature derivative of saturation specific humidity. 
   885:             
   886:             
   887:                 ! 実行文 ; Executable statement
   888:                 !
   889:             
   890:                 if ( .not. saturate_inited ) then
   891:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   892:                 end if
   893:             
   894:             
   895: V------>A       xyz_Temp   (:,1,1) = a_Temp
   896: V------ A       xyz_QVapSat(:,1,1) = a_QVapSat
   897:             
   898:                 xyz_DQVapSatDTemp = xyz_CalcDQVapSatDTempOnLiq( xyz_Temp, xyz_QVapSat )
   899:             
   900: V====== A       a_DQVapSatDTemp = xyz_DQVapSatDTemp(:,1,1)
   901:             
   902:             
   903:               end function a_CalcDQVapSatDTempOnLiq
   904:             
   905:               !--------------------------------------------------------------------------------------
   906:             
   907:               function CalcQVapSatOnLiq( Temp, Press ) result( QVapSat )
   908:                 !
   909:                 ! 温度 *Temp* と気圧 *Press* を用い, 
   910:                 ! 飽和比湿 *QVapSat* を求めます. 
   911:                 !
   912:                 ! Calculate saturation specific humidity *QVapSat* using
   913:                 ! temperature *Temp* and air pressure *Press*. 
   914:                 !
   915:             
   916:                 ! モジュール引用 ; USE statements
   917:                 !
   918:             
   919:                 ! 宣言文 ; Declaration statements
   920:                 !
   921:                 implicit none
   922:             
   923:                 real(DP), intent(in):: Temp
   924:                                           ! $ T $ . 温度. Temperature
   925:                 real(DP), intent(in):: Press
   926:                                           ! $ p $ . 気圧. Air pressure
   927:             
   928:                 real(DP):: QVapSat
   929:                                           ! $ q^{*} $ . 飽和比湿. Saturation specific humidity
   930:             
   931:                 ! 作業変数
   932:                 ! Work variables
   933:                 !
   934:                 real(DP):: xyz_Temp   (1, 1, 1)
   935:                                           ! $ T $ . 温度. Temperature
   936:                 real(DP):: xyz_Press  (1, 1, 1)
   937:                                           ! $ p $ . 気圧. Air pressure
   938:                 real(DP):: xyz_QVapSat(1, 1, 1)
   939:                                           ! $ q^{*} $ . 飽和比湿. Saturation specific humidity
   940:             
   941:                 if ( .not. saturate_inited ) then
   942:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   943:                 end if
   944:             
   945:             
   946: *------>        xyz_Temp (:,1,1) = Temp
   947: *------         xyz_Press(:,1,1) = Press
   948:             
   949:                 xyz_QVapSat = xyz_CalcQVapSatOnLiq( xyz_Temp, xyz_Press )
   950:             
   951:                 QVapSat = xyz_QVapSat(1,1,1)
   952:             
   953:             
   954:               end function CalcQVapSatOnLiq
   955:             
   956:               !--------------------------------------------------------------------------------------
   957:             
   958:               function CalcDQVapSatDTempOnLiq( Temp, QVapSat ) result( DQVapSatDTemp )
   959:                 !
   960:                 ! 温度 *Temp* と飽和比湿 *QVapSat* を用い, 
   961:                 ! 飽和比湿の温度微分 *DQVapSatDTemp* を求めます. 
   962:                 !
   963:                 ! Calculate temperature derivative of saturation specific humidity 
   964:                 ! *DQVapSatDTemp* using
   965:                 ! temperature *Temp* and saturation specific humidity *QVapSat*. 
   966:                 !
   967:             
   968:                 ! モジュール引用 ; USE statements
   969:                 !
   970:             
   971:                 ! 宣言文 ; Declaration statements
   972:                 !
   973:                 implicit none
   974:             
   975:                 real(DP), intent(in):: Temp
   976:                                           ! $ T $ . 温度. Temperature
   977:                 real(DP), intent(in):: QVapSat
   978:                                           ! $ q^{*} $ . 飽和比湿. Saturation specific humidity
   979:                 real(DP):: DQVapSatDTemp
   980:                                           ! $ \DP{q^{*}}{T} $ . 飽和比湿の温度微分. 
   981:                                           ! Temperature derivative of saturation specific humidity. 
   982:             
   983:                 ! 作業変数
   984:                 ! Work variables
   985:                 !
   986:                 real(DP):: xyz_Temp   (1:1, 1:1, 1:1)
   987:                                           ! $ T $ . 温度. Temperature
   988:                 real(DP):: xyz_QVapSat(1:1, 1:1, 1:1)
   989:                                           ! $ q^{*} $ . 飽和比湿. Saturation specific humidity
   990:                 real(DP):: xyz_DQVapSatDTemp(1:1, 1:1, 1:1)
   991:                                           ! $ \DP{q^{*}}{T} $ . 飽和比湿の温度微分. 
   992:                                           ! Temperature derivative of saturation specific humidity. 
   993:             
   994:             
   995:                 ! 実行文 ; Executable statement
   996:                 !
   997:             
   998:                 if ( .not. saturate_inited ) then
   999:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
  1000:                 end if
  1001:             
  1002:             
  1003:                 xyz_Temp   (1,1,1) = Temp
  1004:                 xyz_QVapSat(1,1,1) = QVapSat
  1005:             
  1006:                 xyz_DQVapSatDTemp = xyz_CalcDQVapSatDTempOnLiq( xyz_Temp, xyz_QVapSat )
  1007:             
  1008:                 DQVapSatDTemp = xyz_DQVapSatDTemp(1,1,1)
  1009:             
  1010:             
  1011:               end function CalcDQVapSatDTempOnLiq
  1012:             
  1013:               !-------------------------------------------------------------------
  1014:               ! [On ice] Interfaces for 2D, 1D, and scalar variables
  1015:               !-------------------------------------------------------------------
  1016:             
  1017:               function xy_CalcQVapSatOnSol( xy_Temp, xy_Press ) result( xy_QVapSat )
  1018:                 !
  1019:                 ! 温度 *Temp* と気圧 *Press* を用い, 
  1020:                 ! 飽和比湿 *QVapSat* を求めます. 
  1021:                 !
  1022:                 ! Calculate saturation specific humidity *QVapSat* using
  1023:                 ! temperature *Temp* and air pressure *Press*. 
  1024:                 !
  1025:             
  1026:                 ! モジュール引用 ; USE statements
  1027:                 !
  1028:             
  1029:                 ! 宣言文 ; Declaration statements
  1030:                 !
  1031:                 implicit none
  1032:             
  1033:                 real(DP), intent(in):: xy_Temp (:,:)
  1034:                                           ! $ T $ . 温度. Temperature
  1035:                 real(DP), intent(in):: xy_Press(:,:)
  1036:                                           ! $ p $ . 気圧. Air pressure
  1037:             
  1038:                 real(DP):: xy_QVapSat(size(xy_Temp,1), size(xy_Temp,2))
  1039:                                           ! $ q^{*} $ . 飽和比湿. Saturation specific humidity
  1040:             
  1041:                 ! 作業変数
  1042:                 ! Work variables
  1043:                 !
  1044:                 real(DP) :: xyz_Temp   (size(xy_Temp,1),size(xy_Temp,2),1)
  1045:                 real(DP) :: xyz_Press  (size(xy_Temp,1),size(xy_Temp,2),1)
  1046:                 real(DP) :: xyz_QVapSat(size(xy_Temp,1),size(xy_Temp,2),1)
  1047:             
  1048:             
  1049:                 ! 実行文 ; Executable statement
  1050:                 !
  1051:             
  1052:                 if ( .not. saturate_inited ) then
  1053:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
  1054:                 end if
  1055:             
  1056:             
  1057: *V----->A       xyz_Temp (:,:,1) = xy_Temp
  1058: *V----- A       xyz_Press(:,:,1) = xy_Press
  1059:             
  1060:                 xyz_QVapSat = xyz_CalcQVapSatOnSol( xyz_Temp, xyz_Press )
  1061:             
  1062: +V===== A       xy_QVapSat = xyz_QVapSat(:,:,1)
  1063:             
  1064:             
  1065:               end function xy_CalcQVapSatOnSol
  1066:             
  1067:               !-------------------------------------------------------------------
  1068:             
  1069:               function xy_CalcDQVapSatDTempOnSol( xy_Temp, xy_QVapSat ) result( xy_DQVapSatDTemp )
  1070:                 !
  1071:                 ! 温度 *Temp* と飽和比湿 *QVapSat* を用い, 
  1072:                 ! 飽和比湿の温度微分 *DQVapSatDTemp* を求めます. 
  1073:                 !
  1074:                 ! Calculate temperature derivative of saturation specific humidity 
  1075:                 ! *DQVapSatDTemp* using
  1076:                 ! temperature *Temp* and saturation specific humidity *QVapSat*. 
  1077:                 !
  1078:             
  1079:                 ! モジュール引用 ; USE statements
  1080:                 !
  1081:             
  1082:                 ! 宣言文 ; Declaration statements
  1083:                 !
  1084:                 implicit none
  1085:             
  1086:                 real(DP), intent(in):: xy_Temp   (:,:)
  1087:                                           ! $ T $ . 温度. Temperature
  1088:                 real(DP), intent(in):: xy_QVapSat(:,:)
  1089:                                           ! $ q^{*} $ . 飽和比湿. Saturation specific humidity
  1090:                 real(DP):: xy_DQVapSatDTemp(size(xy_Temp,1), size(xy_Temp,2))
  1091:                                           ! $ \DP{q^{*}}{T} $ . 飽和比湿の温度微分. 
  1092:                                           ! Temperature derivative of saturation specific humidity. 
  1093:             
  1094:                 ! 作業変数
  1095:                 ! Work variables
  1096:                 !
  1097:                 real(DP):: xyz_Temp         (size(xy_Temp,1), size(xy_Temp,2), 1)
  1098:                 real(DP):: xyz_QVapSat      (size(xy_Temp,1), size(xy_Temp,2), 1)
  1099:                 real(DP):: xyz_DQVapSatDTemp(size(xy_Temp,1), size(xy_Temp,2), 1)
  1100:             
  1101:                 ! 実行文 ; Executable statement
  1102:                 !
  1103:             
  1104:                 if ( .not. saturate_inited ) then
  1105:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
  1106:                 end if
  1107:             
  1108:             
  1109: *V----->A       xyz_Temp   (:,:,1) = xy_Temp
  1110: *V----- A       xyz_QVapSat(:,:,1) = xy_QVapSat
  1111:             
  1112:                 xyz_DQVapSatDTemp = xyz_CalcDQVapSatDTempOnSol( xyz_Temp, xyz_QVapSat )
  1113:             
  1114: +V===== A       xy_DQVapSatDTemp = xyz_DQVapSatDTemp(:,:,1)
  1115:             
  1116:             
  1117:               end function xy_CalcDQVapSatDTempOnSol
  1118:             
  1119:               !--------------------------------------------------------------------------------------
  1120:             
  1121:               function a_CalcQVapSatOnSol( a_Temp, a_Press ) result( a_QVapSat )
  1122:                 !
  1123:                 ! 温度 *Temp* と気圧 *Press* を用い, 
  1124:                 ! 飽和比湿 *QVapSat* を求めます. 
  1125:                 !
  1126:                 ! Calculate saturation specific humidity *QVapSat* using
  1127:                 ! temperature *Temp* and air pressure *Press*. 
  1128:                 !
  1129:             
  1130:                 ! モジュール引用 ; USE statements
  1131:                 !
  1132:             
  1133:                 ! 宣言文 ; Declaration statements
  1134:                 !
  1135:                 implicit none
  1136:             
  1137:                 real(DP), intent(in):: a_Temp (:)
  1138:                                           ! $ T $ . 温度. Temperature
  1139:                 real(DP), intent(in):: a_Press(:)
  1140:                                           ! $ p $ . 気圧. Air pressure
  1141:             
  1142:                 real(DP):: a_QVapSat(size(a_Temp,1))
  1143:                                           ! $ q^{*} $ . 飽和比湿. Saturation specific humidity
  1144:             
  1145:                 ! 作業変数
  1146:                 ! Work variables
  1147:                 !
  1148:                 real(DP):: xyz_Temp   (size(a_Temp,1), 1, 1)
  1149:                                           ! $ T $ . 温度. Temperature
  1150:                 real(DP):: xyz_Press  (size(a_Temp,1), 1, 1)
  1151:                                           ! $ p $ . 気圧. Air pressure
  1152:                 real(DP):: xyz_QVapSat(size(a_Temp,1), 1, 1)
  1153:                                           ! $ q^{*} $ . 飽和比湿. Saturation specific humidity
  1154:             
  1155:                 if ( .not. saturate_inited ) then
  1156:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
  1157:                 end if
  1158:             
  1159:             
  1160: V------>A       xyz_Temp (:,1,1) = a_Temp
  1161: V------ A       xyz_Press(:,1,1) = a_Press
  1162:             
  1163:                 xyz_QVapSat = xyz_CalcQVapSatOnSol( xyz_Temp, xyz_Press )
  1164:             
  1165: V====== A       a_QVapSat = xyz_QVapSat(:,1,1)
  1166:             
  1167:             
  1168:               end function a_CalcQVapSatOnSol
  1169:             
  1170:               !--------------------------------------------------------------------------------------
  1171:             
  1172:               function a_CalcDQVapSatDTempOnSol( a_Temp, a_QVapSat ) result( a_DQVapSatDTemp )
  1173:                 !
  1174:                 ! 温度 *Temp* と飽和比湿 *QVapSat* を用い, 
  1175:                 ! 飽和比湿の温度微分 *DQVapSatDTemp* を求めます. 
  1176:                 !
  1177:                 ! Calculate temperature derivative of saturation specific humidity 
  1178:                 ! *DQVapSatDTemp* using
  1179:                 ! temperature *Temp* and saturation specific humidity *QVapSat*. 
  1180:                 !
  1181:             
  1182:                 ! モジュール引用 ; USE statements
  1183:                 !
  1184:             
  1185:                 ! 宣言文 ; Declaration statements
  1186:                 !
  1187:                 implicit none
  1188:             
  1189:                 real(DP), intent(in):: a_Temp   (:)
  1190:                                           ! $ T $ . 温度. Temperature
  1191:                 real(DP), intent(in):: a_QVapSat(:)
  1192:                                           ! $ q^{*} $ . 飽和比湿. Saturation specific humidity
  1193:                 real(DP):: a_DQVapSatDTemp(size(a_Temp,1))
  1194:                                           ! $ \DP{q^{*}}{T} $ . 飽和比湿の温度微分. 
  1195:                                           ! Temperature derivative of saturation specific humidity. 
  1196:             
  1197:                 ! 作業変数
  1198:                 ! Work variables
  1199:                 !
  1200:                 real(DP):: xyz_Temp   (size(a_Temp,1), 1:1, 1:1)
  1201:                                           ! $ T $ . 温度. Temperature
  1202:                 real(DP):: xyz_QVapSat(size(a_Temp,1), 1:1, 1:1)
  1203:                                           ! $ q^{*} $ . 飽和比湿. Saturation specific humidity
  1204:                 real(DP):: xyz_DQVapSatDTemp(size(a_Temp,1), 1:1, 1:1)
  1205:                                           ! $ \DP{q^{*}}{T} $ . 飽和比湿の温度微分. 
  1206:                                           ! Temperature derivative of saturation specific humidity. 
  1207:             
  1208:             
  1209:                 ! 実行文 ; Executable statement
  1210:                 !
  1211:             
  1212:                 if ( .not. saturate_inited ) then
  1213:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
  1214:                 end if
  1215:             
  1216:             
  1217: V------>A       xyz_Temp   (:,1,1) = a_Temp
  1218: V------ A       xyz_QVapSat(:,1,1) = a_QVapSat
  1219:             
  1220:                 xyz_DQVapSatDTemp = xyz_CalcDQVapSatDTempOnSol( xyz_Temp, xyz_QVapSat )
  1221:             
  1222: V====== A       a_DQVapSatDTemp = xyz_DQVapSatDTemp(:,1,1)
  1223:             
  1224:             
  1225:               end function a_CalcDQVapSatDTempOnSol
  1226:             
  1227:               !--------------------------------------------------------------------------------------
  1228:             
  1229:               function CalcQVapSatOnSol( Temp, Press ) result( QVapSat )
  1230:                 !
  1231:                 ! 温度 *Temp* と気圧 *Press* を用い, 
  1232:                 ! 飽和比湿 *QVapSat* を求めます. 
  1233:                 !
  1234:                 ! Calculate saturation specific humidity *QVapSat* using
  1235:                 ! temperature *Temp* and air pressure *Press*. 
  1236:                 !
  1237:             
  1238:                 ! モジュール引用 ; USE statements
  1239:                 !
  1240:             
  1241:                 ! 宣言文 ; Declaration statements
  1242:                 !
  1243:                 implicit none
  1244:             
  1245:                 real(DP), intent(in):: Temp
  1246:                                           ! $ T $ . 温度. Temperature
  1247:                 real(DP), intent(in):: Press
  1248:                                           ! $ p $ . 気圧. Air pressure
  1249:             
  1250:                 real(DP):: QVapSat
  1251:                                           ! $ q^{*} $ . 飽和比湿. Saturation specific humidity
  1252:             
  1253:                 ! 作業変数
  1254:                 ! Work variables
  1255:                 !
  1256:                 real(DP):: xyz_Temp   (1, 1, 1)
  1257:                                           ! $ T $ . 温度. Temperature
  1258:                 real(DP):: xyz_Press  (1, 1, 1)
  1259:                                           ! $ p $ . 気圧. Air pressure
  1260:                 real(DP):: xyz_QVapSat(1, 1, 1)
  1261:                                           ! $ q^{*} $ . 飽和比湿. Saturation specific humidity
  1262:             
  1263:                 if ( .not. saturate_inited ) then
  1264:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
  1265:                 end if
  1266:             
  1267:             
  1268: *------>        xyz_Temp (:,1,1) = Temp
  1269: *------         xyz_Press(:,1,1) = Press
  1270:             
  1271:                 xyz_QVapSat = xyz_CalcQVapSatOnSol( xyz_Temp, xyz_Press )
  1272:             
  1273:                 QVapSat = xyz_QVapSat(1,1,1)
  1274:             
  1275:             
  1276:               end function CalcQVapSatOnSol
  1277:             
  1278:               !--------------------------------------------------------------------------------------
  1279:             
  1280:               function CalcDQVapSatDTempOnSol( Temp, QVapSat ) result( DQVapSatDTemp )
  1281:                 !
  1282:                 ! 温度 *Temp* と飽和比湿 *QVapSat* を用い, 
  1283:                 ! 飽和比湿の温度微分 *DQVapSatDTemp* を求めます. 
  1284:                 !
  1285:                 ! Calculate temperature derivative of saturation specific humidity 
  1286:                 ! *DQVapSatDTemp* using
  1287:                 ! temperature *Temp* and saturation specific humidity *QVapSat*. 
  1288:                 !
  1289:             
  1290:                 ! モジュール引用 ; USE statements
  1291:                 !
  1292:             
  1293:                 ! 宣言文 ; Declaration statements
  1294:                 !
  1295:                 implicit none
  1296:             
  1297:                 real(DP), intent(in):: Temp
  1298:                                           ! $ T $ . 温度. Temperature
  1299:                 real(DP), intent(in):: QVapSat
  1300:                                           ! $ q^{*} $ . 飽和比湿. Saturation specific humidity
  1301:                 real(DP):: DQVapSatDTemp
  1302:                                           ! $ \DP{q^{*}}{T} $ . 飽和比湿の温度微分. 
  1303:                                           ! Temperature derivative of saturation specific humidity. 
  1304:             
  1305:                 ! 作業変数
  1306:                 ! Work variables
  1307:                 !
  1308:                 real(DP):: xyz_Temp   (1:1, 1:1, 1:1)
  1309:                                           ! $ T $ . 温度. Temperature
  1310:                 real(DP):: xyz_QVapSat(1:1, 1:1, 1:1)
  1311:                                           ! $ q^{*} $ . 飽和比湿. Saturation specific humidity
  1312:                 real(DP):: xyz_DQVapSatDTemp(1:1, 1:1, 1:1)
  1313:                                           ! $ \DP{q^{*}}{T} $ . 飽和比湿の温度微分. 
  1314:                                           ! Temperature derivative of saturation specific humidity. 
  1315:             
  1316:             
  1317:                 ! 実行文 ; Executable statement
  1318:                 !
  1319:             
  1320:                 if ( .not. saturate_inited ) then
  1321:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
  1322:                 end if
  1323:             
  1324:             
  1325:                 xyz_Temp   (1,1,1) = Temp
  1326:                 xyz_QVapSat(1,1,1) = QVapSat
  1327:             
  1328:                 xyz_DQVapSatDTemp = xyz_CalcDQVapSatDTempOnSol( xyz_Temp, xyz_QVapSat )
  1329:             
  1330:                 DQVapSatDTemp = xyz_DQVapSatDTemp(1,1,1)
  1331:             
  1332:             
  1333:               end function CalcDQVapSatDTempOnSol
  1334:             
  1335:               !-------------------------------------------------------------------
  1336:             
  1337:               subroutine SaturateInit
  1338:                 !
  1339:                 ! saturate モジュールの初期化を行います. 
  1340:                 !--
  1341:                 ! NAMELIST#saturate_nml の読み込みはこの手続きで行われます. 
  1342:                 !++
  1343:                 !
  1344:                 ! "saturate" module is initialized. 
  1345:                 !--
  1346:                 ! "NAMELIST#saturate_nml" is loaded in this procedure. 
  1347:                 !++
  1348:             
  1349:                 ! モジュール引用 ; USE statements
  1350:                 !
  1351:             
  1352:                 ! NAMELIST ファイル入力に関するユーティリティ
  1353:                 ! Utilities for NAMELIST file input
  1354:                 !
  1355:                 use namelist_util, only: namelist_filename, NmlutilMsg
  1356:             
  1357:                 ! ファイル入出力補助
  1358:                 ! File I/O support
  1359:                 !
  1360:                 use dc_iounit, only: FileOpen
  1361:             
  1362:                 ! 種別型パラメタ
  1363:                 ! Kind type parameter
  1364:                 !
  1365:                 use dc_types, only: STDOUT ! 標準出力の装置番号. Unit number of standard output
  1366:             
  1367:                 ! 文字列操作
  1368:                 ! Character handling
  1369:                 !
  1370:                 use dc_string, only: StoA
  1371:             
  1372:                 ! ヒストリデータ出力
  1373:                 ! History data output
  1374:                 !
  1375:                 use gtool_historyauto, only: HistoryAutoAddVariable
  1376:             
  1377:                 ! 雪, 氷の割合
  1378:                 ! snow/ice fraction
  1379:                 !
  1380:                 use snowice_frac, only : SnowIceFracInit
  1381:             
  1382:                 ! 宣言文 ; Declaration statements
  1383:                 !
  1384:                 implicit none
  1385:             
  1386:                 character(STRING) :: SaturateWatIceFracType
  1387:             
  1388:                 integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号. 
  1389:                                           ! Unit number for NAMELIST file open
  1390:                 integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT. 
  1391:                                           ! IOSTAT of NAMELIST read
  1392:             
  1393:                 ! NAMELIST 変数群
  1394:                 ! NAMELIST group name
  1395:                 !
  1396:                 namelist /saturate_nml/     &
  1397:                   & SaturateWatIceFracType, &
  1398:                   & TempWatLim,             &
  1399:                   & TempIceLim
  1400:                       !
  1401:                       ! デフォルト値については初期化手続 "saturate#SaturateInit" 
  1402:                       ! のソースコードを参照のこと. 
  1403:                       !
  1404:                       ! Refer to source codes in the initialization procedure
  1405:                       ! "saturate#SaturateInit" for the default values. 
  1406:                       !
  1407:             
  1408:                 ! 実行文 ; Executable statement
  1409:                 !
  1410:             
  1411:                 if ( saturate_inited ) return
  1412:             
  1413:                 ! デフォルト値の設定
  1414:                 ! Default values settings
  1415:                 !
  1416:                 SaturateWatIceFracType = 'Lin'
  1417:             
  1418:             !!$    TempWatLim          = 273.15_DP
  1419:             !!$    TempIceLim          = 273.15_DP - 40.0_DP
  1420:                 TempWatLim          = 0.0_DP
  1421:                 TempIceLim          = 0.0_DP
  1422:             
  1423:             
  1424:                 ! NAMELIST の読み込み
  1425:                 ! NAMELIST is input
  1426:                 !
  1427:                 if ( trim(namelist_filename) /= '' ) then
  1428:                   call FileOpen( unit_nml, &          ! (out)
  1429:                     & namelist_filename, mode = 'r' ) ! (in)
  1430:             
  1431:                   rewind( unit_nml )
  1432:                   read( unit_nml, &           ! (in)
  1433:                     & nml = saturate_nml, &  ! (out)
  1434:                     & iostat = iostat_nml )   ! (out)
  1435:                   close( unit_nml )
  1436:             
  1437:                   call NmlutilMsg( iostat_nml, module_name ) ! (in)
  1438:                 end if
  1439:             
  1440:             
  1441:                 select case ( SaturateWatIceFracType )
  1442:                 case ( 'Lin' )
  1443:                   IDWatIceFracMethod = IDWatIceFracMethodLin
  1444:                 case ( 'Quad' )
  1445:                   IDWatIceFracMethod = IDWatIceFracMethodQuad
  1446:                 case default
  1447:                   call MessageNotify( 'E', module_name,         &
  1448:                     & 'SaturateWatIceFracType=<%c> is not supported.', &
  1449:                     & c1 = trim(SaturateWatIceFracType) )
  1450:                 end select
  1451:             
  1452:             
  1453:                 ! Initialization of modules used in this module
  1454:                 !
  1455:             
  1456:                 call SaturateInitCore
  1457:             
  1458:                 ! 雪, 氷の割合
  1459:                 ! snow/ice fraction
  1460:                 !
  1461:                 call SnowIceFracInit
  1462:             
  1463:             
  1464:                 ! 印字 ; Print
  1465:                 !
  1466:                 call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
  1467:                 call MessageNotify( 'M', module_name, 'Scheme of saturation = %c', &
  1468:                   & c1 = saturate_scheme )
  1469:                 call MessageNotify( 'M', module_name, 'SaturateWatIceFracType = %c', c1 = trim(SaturateWatIceFracType) )
  1470:                 call MessageNotify( 'M', module_name, 'TempWatLim             = %f', d = (/TempWatLim/) )
  1471:                 call MessageNotify( 'M', module_name, 'TempIceLim             = %f', d = (/TempIceLim/) )
  1472:                 call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
  1473:             
  1474:                 saturate_inited = .true.
  1475:             
  1476:             
  1477:               end subroutine SaturateInit
  1478:             
  1479:               !-------------------------------------------------------------------
  1480:             
  1481:             end module saturate
