Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:29 2016
FILE NAME: major_comp_phase_change.f90
PROGRAM NAME: major_comp_phase_change
DIAGNOSTIC LIST

  LINE  LEVEL( NO.): DIAGNOSTIC MESSAGE

   238  vec  (   1): Vectorized loop.
   238  vec  (  29): ADB is used for array.: xyr_press
   252  opt  (1593): Loop nest collapsed into one loop.
   252  vec  (   4): Vectorized array expression.
   252  vec  (  29): ADB is used for array.: xyz_temp
   261  vec  (   3): Unvectorized loop.
   261  vec  (  13): Overhead of loop division is too large.
   262  opt  (1593): Loop nest collapsed into one loop.
   262  vec  (   4): Vectorized array expression.
   267  opt  (1592): Outer loop unrolled inside inner loop.
   268  vec  (   1): Vectorized loop.
   268  vec  (  29): ADB is used for array.: xyz_temp
   268  vec  (  29): ADB is used for array.: xyz_tempcond
   268  vec  (   1): Vectorized loop.
   268  vec  (  29): ADB is used for array.: xyz_temp
   268  vec  (  29): ADB is used for array.: xyz_tempcond
   281  opt  (1593): Loop nest collapsed into one loop.
   281  vec  (   4): Vectorized array expression.
   283  opt  (1019): Feedback of scalar value from one loop pass to another.
   283  opt  (1593): Loop nest collapsed into one loop.
   283  vec  (   4): Vectorized array expression.
   283  vec  (  29): ADB is used for array.: xy_fallingice
   285  vec  (   1): Vectorized loop.
   285  vec  (  29): ADB is used for array.: xyz_temp
   285  vec  (  29): ADB is used for array.: xyz_tempcond
   285  vec  (  29): ADB is used for array.: xy_fallingice
   285  vec  (  29): ADB is used for array.: xyz_height
   317  opt  (1593): Loop nest collapsed into one loop.
   317  vec  (   4): Vectorized array expression.
   317  vec  (  29): ADB is used for array.: xy_fallingice
   320  vec  (   1): Vectorized loop.
   320  vec  (  29): ADB is used for array.: xyz_temp
   320  vec  (  29): ADB is used for array.: xyz_tempcond
   320  vec  (  29): ADB is used for array.: xy_fallingice
   320  vec  (  29): ADB is used for array.: xyz_height
   369  opt  (1593): Loop nest collapsed into one loop.
   369  vec  (   4): Vectorized array expression.
   369  vec  (  29): ADB is used for array.: xyz_dtempdt
   369  vec  (  29): ADB is used for array.: xyz_temp
   375  opt  (1593): Loop nest collapsed into one loop.
   375  vec  (   4): Vectorized array expression.
   376  vec  (   3): Unvectorized loop.
   376  vec  (  13): Overhead of loop division is too large.
   377  opt  (1593): Loop nest collapsed into one loop.
   377  vec  (   4): Vectorized array expression.
   377  vec  (  29): ADB is used for array.: xy_dsurfmajcompicedt
   379  opt  (  11): Fused array assignments. :line 379 - 388
   379  opt  (1593): Loop nest collapsed into one loop.
   379  vec  (   4): Vectorized array expression.
   379  vec  (  29): ADB is used for array.: xy_ps
   379  vec  (  29): ADB is used for array.: xy_surfmajcompice
   379  vec  (  29): ADB is used for array.: xy_dsurfmajcompicedt
   402  warn (  81): Name "xy_surftempcond" is referenced but not defined.
   522  opt  (1593): Loop nest collapsed into one loop.
   522  vec  (   1): Vectorized loop.
   522  vec  (  29): ADB is used for array.: xyr_press
   537  opt  (1593): Loop nest collapsed into one loop.
   537  vec  (   4): Vectorized array expression.
   537  vec  (  29): ADB is used for array.: xyz_temp
   546  opt  (1593): Loop nest collapsed into one loop.
   546  vec  (   1): Vectorized loop.
   546  vec  (  29): ADB is used for array.: xyz_temp
   546  vec  (  29): ADB is used for array.: xyz_tempcond
   559  opt  (1593): Loop nest collapsed into one loop.
   559  vec  (   4): Vectorized array expression.
   559  vec  (  29): ADB is used for array.: xyz_dtempdt
   559  vec  (  29): ADB is used for array.: xyz_temp
   565  opt  (1593): Loop nest collapsed into one loop.
   565  vec  (   4): Vectorized array expression.
   566  vec  (   3): Unvectorized loop.
   566  vec  (  13): Overhead of loop division is too large.
   567  opt  (1593): Loop nest collapsed into one loop.
   567  vec  (   4): Vectorized array expression.
   567  vec  (  29): ADB is used for array.: xy_dsurfmajcompicedt
   567  vec  (  29): ADB is used for array.: xyr_press
   567  vec  (  29): ADB is used for array.: xyz_dtempdt
   572  opt  (  11): Fused array assignments. :line 572 - 578
   572  opt  (1593): Loop nest collapsed into one loop.
   572  vec  (   4): Vectorized array expression.
   572  vec  (  29): ADB is used for array.: xy_ps
   572  vec  (  29): ADB is used for array.: xy_surfmajcompice
   572  vec  (  29): ADB is used for array.: xy_dsurfmajcompicedt
   757  opt  (1593): Loop nest collapsed into one loop.
   757  vec  (   1): Vectorized loop.
   757  vec  (  29): ADB is used for array.: xyr_press
   771  opt  (1593): Loop nest collapsed into one loop.
   771  vec  (   4): Vectorized array expression.
   771  vec  (  29): ADB is used for array.: xyz_temp
   772  opt  (1593): Loop nest collapsed into one loop.
   772  vec  (   4): Vectorized array expression.
   772  vec  (  29): ADB is used for array.: xyzf_qmixb
   772  vec  (  29): ADB is used for array.: xyzf_qmix
   781  opt  (1593): Loop nest collapsed into one loop.
   781  vec  (   1): Vectorized loop.
   781  vec  (  29): ADB is used for array.: xyz_temp
   781  vec  (  29): ADB is used for array.: xyz_tempcond
   794  opt  (1593): Loop nest collapsed into one loop.
   794  vec  (   4): Vectorized array expression.
   794  vec  (  29): ADB is used for array.: xyz_dtempdt
   794  vec  (  29): ADB is used for array.: xyz_temp
   797  opt  (1593): Loop nest collapsed into one loop.
   797  vec  (   4): Vectorized array expression.
   797  vec  (  29): ADB is used for array.: xyr_dpressdt
   798  vec  (   3): Unvectorized loop.
   798  vec  (  13): Overhead of loop division is too large.
   799  opt  (  11): Fused array assignments. :line 799 - 803
   799  opt  (1593): Loop nest collapsed into one loop.
   799  vec  (   4): Vectorized array expression.
   799  vec  (  29): ADB is used for array.: xyr_dpressdt
   799  vec  (  29): ADB is used for array.: xyr_press
   799  vec  (  29): ADB is used for array.: xyz_dtempdt
   803  opt  (1037): Feedback of array elements.
   807  opt  (  11): Fused array assignments. :line 807 - 808
   807  opt  (1593): Loop nest collapsed into one loop.
   807  vec  (   4): Vectorized array expression.
   807  vec  (  29): ADB is used for array.: xyr_dpressdt
   814  vec  (   3): Unvectorized loop.
   814  vec  (  13): Overhead of loop division is too large.
   816  opt  (1593): Loop nest collapsed into one loop.
   816  vec  (   4): Vectorized array expression.
   816  vec  (  29): ADB is used for array.: xyza_array
   816  vec  (  29): ADB is used for array.: xyzf_qmix
   831  opt  (1593): Loop nest collapsed into one loop.
   831  vec  (   1): Vectorized loop.
   831  vec  (  29): ADB is used for array.: xyra_massflow
   838  opt  (  11): Fused array assignments. :line 838 - 839
   838  opt  (1593): Loop nest collapsed into one loop.
   838  vec  (   4): Vectorized array expression.
   838  vec  (  29): ADB is used for array.: xy_psa
   838  vec  (  29): ADB is used for array.: xy_psb
   838  vec  (  29): ADB is used for array.: xy_ps
   845  opt  (  11): Fused array assignments. :line 845 - 846
   845  opt  (1593): Loop nest collapsed into one loop.
   845  vec  (   4): Vectorized array expression.
   845  vec  (  29): ADB is used for array.: xyz_qh2ovaptmp
   845  vec  (  29): ADB is used for array.: xyz_temptmp
   855  opt  (1593): Loop nest collapsed into one loop.
   855  vec  (   1): Vectorized loop.
   855  vec  (  29): ADB is used for array.: xyz_delatmmassa
   855  vec  (  29): ADB is used for array.: xyr_pressa
   855  vec  (  29): ADB is used for array.: xyz_delatmmassb
   855  vec  (  29): ADB is used for array.: xyr_pressb
   856  opt  (  11): Fused array assignments. :line 856 - 857
   861  opt  (1593): Loop nest collapsed into one loop.
   861  vec  (   1): Vectorized loop.
   861  vec  (  29): ADB is used for array.: xyzf_qmix
   861  vec  (  29): ADB is used for array.: xyz_delatmmassa
   861  vec  (  29): ADB is used for array.: xyz_delatmmassb
   871  opt  (  11): Fused array assignments. :line 871 - 873
   871  opt  (1593): Loop nest collapsed into one loop.
   871  vec  (   4): Vectorized array expression.
   871  vec  (  29): ADB is used for array.: xy_ps
   871  vec  (  29): ADB is used for array.: xy_psa
   871  vec  (  29): ADB is used for array.: xy_surfmajcompice
  1081  opt  (1593): Loop nest collapsed into one loop.
  1081  vec  (   1): Vectorized loop.
  1081  vec  (  29): ADB is used for array.: xyr_press
  1095  opt  (1593): Loop nest collapsed into one loop.
  1095  vec  (   4): Vectorized array expression.
  1095  vec  (  29): ADB is used for array.: xyz_temp
  1096  opt  (1593): Loop nest collapsed into one loop.
  1096  vec  (   4): Vectorized array expression.
  1096  vec  (  29): ADB is used for array.: xyzf_qmixb
  1096  vec  (  29): ADB is used for array.: xyzf_qmix
  1105  opt  (1593): Loop nest collapsed into one loop.
  1105  vec  (   1): Vectorized loop.
  1105  vec  (  29): ADB is used for array.: xyr_press
  1109  opt  (1593): Loop nest collapsed into one loop.
  1109  vec  (   4): Vectorized array expression.
  1110  vec  (   3): Unvectorized loop.
  1110  vec  (  13): Overhead of loop division is too large.
  1119  opt  (  11): Fused array assignments. :line 1119 - 1125
  1119  opt  (1593): Loop nest collapsed into one loop.
  1119  vec  (   4): Vectorized array expression.
  1119  vec  (  29): ADB is used for array.: xyr_atmmassfallflux
  1119  vec  (  29): ADB is used for array.: xyz_temp
  1119  vec  (  29): ADB is used for array.: xyz_tempcond
  1125  opt  (1037): Feedback of array elements.
  1129  opt  (1593): Loop nest collapsed into one loop.
  1129  vec  (   4): Vectorized array expression.
  1129  vec  (  29): ADB is used for array.: xyr_dpressdt
  1129  vec  (  29): ADB is used for array.: xyr_atmmassfallflux
  1132  opt  (  11): Fused array assignments. :line 1132 - 1133
  1132  opt  (1593): Loop nest collapsed into one loop.
  1132  vec  (   4): Vectorized array expression.
  1132  vec  (  29): ADB is used for array.: xyr_dpressdt
  1143  vec  (   3): Unvectorized loop.
  1143  vec  (  13): Overhead of loop division is too large.
  1145  opt  (1593): Loop nest collapsed into one loop.
  1145  vec  (   4): Vectorized array expression.
  1145  vec  (  29): ADB is used for array.: xyza_array
  1145  vec  (  29): ADB is used for array.: xyzf_qmix
  1155  opt  (1593): Loop nest collapsed into one loop.
  1155  vec  (   4): Vectorized array expression.
  1155  vec  (  29): ADB is used for array.: xyza_array
  1155  vec  (  29): ADB is used for array.: xyz_u
  1158  opt  (1593): Loop nest collapsed into one loop.
  1158  vec  (   4): Vectorized array expression.
  1158  vec  (  29): ADB is used for array.: xyza_array
  1158  vec  (  29): ADB is used for array.: xyz_v
  1169  opt  (1593): Loop nest collapsed into one loop.
  1169  vec  (   1): Vectorized loop.
  1169  vec  (  29): ADB is used for array.: xyra_massflow
  1175  opt  (1593): Loop nest collapsed into one loop.
  1175  vec  (   4): Vectorized array expression.
  1175  vec  (  29): ADB is used for array.: xyra_massflow
  1177  opt  (1593): Loop nest collapsed into one loop.
  1177  vec  (   4): Vectorized array expression.
  1177  vec  (  29): ADB is used for array.: xyra_massflow
  1183  opt  (  11): Fused array assignments. :line 1183 - 1184
  1183  opt  (1593): Loop nest collapsed into one loop.
  1183  vec  (   4): Vectorized array expression.
  1183  vec  (  29): ADB is used for array.: xy_psa
  1183  vec  (  29): ADB is used for array.: xy_psb
  1183  vec  (  29): ADB is used for array.: xy_ps
  1190  opt  (  11): Fused array assignments. :line 1190 - 1191
  1190  opt  (1593): Loop nest collapsed into one loop.
  1190  vec  (   4): Vectorized array expression.
  1190  vec  (  29): ADB is used for array.: xyz_qh2ovaptmp
  1190  vec  (  29): ADB is used for array.: xyz_temptmp
  1200  opt  (1593): Loop nest collapsed into one loop.
  1200  vec  (   1): Vectorized loop.
  1200  vec  (  29): ADB is used for array.: xyz_delatmmassa
  1200  vec  (  29): ADB is used for array.: xyr_pressa
  1200  vec  (  29): ADB is used for array.: xyz_delatmmassb
  1200  vec  (  29): ADB is used for array.: xyr_pressb
  1201  opt  (  11): Fused array assignments. :line 1201 - 1202
  1206  opt  (1593): Loop nest collapsed into one loop.
  1206  vec  (   1): Vectorized loop.
  1206  vec  (  29): ADB is used for array.: xyzf_qmix
  1206  vec  (  29): ADB is used for array.: xyz_delatmmassa
  1206  vec  (  29): ADB is used for array.: xyz_delatmmassb
  1214  opt  (1593): Loop nest collapsed into one loop.
  1214  vec  (   1): Vectorized loop.
  1214  vec  (  29): ADB is used for array.: xyz_v
  1214  vec  (  29): ADB is used for array.: xyz_u
  1214  vec  (  29): ADB is used for array.: xyz_delatmmassa
  1214  vec  (  29): ADB is used for array.: xyz_delatmmassb
  1216  opt  (  11): Fused array assignments. :line 1216 - 1221
  1230  opt  (  11): Fused array assignments. :line 1230 - 1232
  1230  opt  (1593): Loop nest collapsed into one loop.
  1230  vec  (   4): Vectorized array expression.
  1230  vec  (  29): ADB is used for array.: xy_ps
  1230  vec  (  29): ADB is used for array.: xy_psa
  1230  vec  (  29): ADB is used for array.: xy_surfmajcompice
  1265  warn (  82): Name "xy_dtempdtsubl" is not used.
  1265  warn (  81): Name "xyz_dtempdt" is referenced but not defined.
  1398  opt  (  11): Fused array assignments. :line 1398 - 1399
  1398  opt  (1593): Loop nest collapsed into one loop.
  1398  vec  (   4): Vectorized array expression.
  1398  vec  (  29): ADB is used for array.: xy_psa
  1398  vec  (  29): ADB is used for array.: xy_dpsdt
  1398  vec  (  29): ADB is used for array.: xy_psb
  1398  vec  (  29): ADB is used for array.: xy_ps
  1401  opt  (1593): Loop nest collapsed into one loop.
  1401  vec  (   4): Vectorized array expression.
  1401  vec  (  29): ADB is used for array.: xyzf_qmixb
  1401  vec  (  29): ADB is used for array.: xyzf_qmix
  1403  opt  (  11): Fused array assignments. :line 1403 - 1404
  1403  opt  (1593): Loop nest collapsed into one loop.
  1403  vec  (   4): Vectorized array expression.
  1403  vec  (  29): ADB is used for array.: xyz_qh2ovaptmp
  1403  vec  (  29): ADB is used for array.: xyz_temptmp
  1420  opt  (1593): Loop nest collapsed into one loop.
  1420  vec  (   4): Vectorized array expression.
  1420  vec  (  29): ADB is used for array.: xyr_dpressdt
  1420  vec  (  29): ADB is used for array.: xyr_pressb
  1420  vec  (  29): ADB is used for array.: xyr_pressa
  1429  vec  (   3): Unvectorized loop.
  1429  vec  (  13): Overhead of loop division is too large.
  1431  opt  (1593): Loop nest collapsed into one loop.
  1431  vec  (   4): Vectorized array expression.
  1431  vec  (  29): ADB is used for array.: xyza_array
  1431  vec  (  29): ADB is used for array.: xyzf_qmix
  1441  opt  (1593): Loop nest collapsed into one loop.
  1441  vec  (   4): Vectorized array expression.
  1441  vec  (  29): ADB is used for array.: xyza_array
  1441  vec  (  29): ADB is used for array.: xyz_u
  1444  opt  (1593): Loop nest collapsed into one loop.
  1444  vec  (   4): Vectorized array expression.
  1444  vec  (  29): ADB is used for array.: xyza_array
  1444  vec  (  29): ADB is used for array.: xyz_v
  1455  opt  (1593): Loop nest collapsed into one loop.
  1455  vec  (   1): Vectorized loop.
  1455  vec  (  29): ADB is used for array.: xyra_massflow
  1461  opt  (1593): Loop nest collapsed into one loop.
  1461  vec  (   4): Vectorized array expression.
  1461  vec  (  29): ADB is used for array.: xyra_massflow
  1463  opt  (1593): Loop nest collapsed into one loop.
  1463  vec  (   4): Vectorized array expression.
  1463  vec  (  29): ADB is used for array.: xyra_massflow
  1469  opt  (1593): Loop nest collapsed into one loop.
  1469  vec  (   1): Vectorized loop.
  1469  vec  (  29): ADB is used for array.: xyz_delatmmassa
  1469  vec  (  29): ADB is used for array.: xyr_pressa
  1469  vec  (  29): ADB is used for array.: xyz_delatmmassb
  1469  vec  (  29): ADB is used for array.: xyr_pressb
  1470  opt  (  11): Fused array assignments. :line 1470 - 1471
  1475  opt  (1593): Loop nest collapsed into one loop.
  1475  vec  (   1): Vectorized loop.
  1475  vec  (  29): ADB is used for array.: xyzf_qmix
  1475  vec  (  29): ADB is used for array.: xyz_delatmmassa
  1475  vec  (  29): ADB is used for array.: xyz_delatmmassb
  1483  opt  (1593): Loop nest collapsed into one loop.
  1483  vec  (   1): Vectorized loop.
  1483  vec  (  29): ADB is used for array.: xyz_v
  1483  vec  (  29): ADB is used for array.: xyz_u
  1483  vec  (  29): ADB is used for array.: xyz_delatmmassa
  1483  vec  (  29): ADB is used for array.: xyz_delatmmassb
  1485  opt  (  11): Fused array assignments. :line 1485 - 1490
  1498  opt  (  11): Fused array assignments. :line 1498 - 1500
  1498  opt  (1593): Loop nest collapsed into one loop.
  1498  vec  (   4): Vectorized array expression.
  1498  vec  (  29): ADB is used for array.: xy_ps
  1498  vec  (  29): ADB is used for array.: xy_psa
  1498  vec  (  29): ADB is used for array.: xy_surfmajcompice
  1498  vec  (  29): ADB is used for array.: xy_dsurfmajcompicedt
  1530  warn (  82): Name "i" is not used.
  1530  warn (  82): Name "j" is not used.
  1605  opt  (1593): Loop nest collapsed into one loop.
  1605  vec  (   4): Vectorized array expression.
  1605  vec  (  29): ADB is used for array.: xyr_dpressdt
  1605  vec  (  29): ADB is used for array.: xyr_press
  1610  vec  (   3): Unvectorized loop.
  1612  opt  (1017): Subroutine call prevents optimization.
  1612  vec  (  10): Vectorization obstructive procedure reference.:messagenotifyc
  1619  opt  (1593): Loop nest collapsed into one loop.
  1619  vec  (   4): Vectorized array expression.
  1619  vec  (  29): ADB is used for array.: xyra_massflow
  1628  opt  (1037): Feedback of array elements.
  1630  vec  (   1): Vectorized loop.
  1630  vec  (  29): ADB is used for array.: xyra_massflow
  1630  vec  (  29): ADB is used for array.: xyza_array
  1631  opt  (1019): Feedback of scalar value from one loop pass to another.
  1636  vec  (   1): Vectorized loop.
  1636  vec  (  29): ADB is used for array.: xyra_massflow
  1636  vec  (  29): ADB is used for array.: xyza_array
  1637  opt  (1019): Feedback of scalar value from one loop pass to another.
  1639  opt  (1084): Branch out of the loop inhibits optimization.
  1647  opt  (1037): Feedback of array elements.
  1649  vec  (   1): Vectorized loop.
  1649  vec  (  29): ADB is used for array.: xyra_massflow
  1649  vec  (  29): ADB is used for array.: xyza_array
  1650  opt  (1019): Feedback of scalar value from one loop pass to another.
  1655  vec  (   1): Vectorized loop.
  1655  vec  (  29): ADB is used for array.: xyra_massflow
  1655  vec  (  29): ADB is used for array.: xyza_array
  1656  opt  (1019): Feedback of scalar value from one loop pass to another.
  1658  opt  (1084): Branch out of the loop inhibits optimization.
  1677  vec  (   1): Vectorized loop.
  1677  vec  (  29): ADB is used for array.: xyra_massflow
  1677  vec  (  29): ADB is used for array.: a_flagsurfacesink
  1738  opt  (  11): Fused array assignments. :line 1738 - 1739
  1738  opt  (1593): Loop nest collapsed into one loop.
  1738  vec  (   4): Vectorized array expression.
  1741  vec  (   3): Unvectorized loop.
  1741  vec  (  13): Overhead of loop division is too large.
  1742  opt  (  11): Fused array assignments. :line 1742 - 1744
  1742  opt  (1593): Loop nest collapsed into one loop.
  1742  vec  (   4): Vectorized array expression.
  1742  vec  (  29): ADB is used for array.: xyf_suma
  1742  vec  (  29): ADB is used for array.: xyzf_qmixa
  1742  vec  (  29): ADB is used for array.: xyz_delatmmassa
  1742  vec  (  29): ADB is used for array.: xyf_sumb
  1742  vec  (  29): ADB is used for array.: xyzf_qmixb
  1742  vec  (  29): ADB is used for array.: xyz_delatmmassb
  1751  vec  (   3): Unvectorized loop.
  1760  opt  (1017): Subroutine call prevents optimization.
  1760  vec  (  10): Vectorization obstructive procedure reference.:messagenotifyc
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:29 2016
FILE NAME: major_comp_phase_change.f90
PROGRAM NAME: major_comp_phase_change
TRANSFORMATION LIST

  LINE                   FORTRAN STATEMENT

     1  != 主成分相変化
     2  !
     3  != Phase change of atmospheric major component
     4  !
     5  ! Authors::   Yoshiyuki O. Takahashi
     6  ! Version::   $Id: major_comp_phase_change.f90,v 1.3 2014/05/07 09:39:21 murashin Exp $
     7  ! Tag Name::  $Name:  $
     8  ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9  ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10  !
    11  
    12  module major_comp_phase_change
    13    !
    14    != 主成分相変化
    15    !
    16    != Phase change of atmospheric major component
    17    !
    18    ! <b>Note that Japanese and English are described in parallel.</b>
    19    !
    20    !== Procedures List
    21    !
    22  !!$  ! DryConvAdjust :: 乾燥対流調節
    23  !!$  ! ------------  :: ------------
    24  !!$  ! DryConvAdjust :: Dry convective adjustment
    25    !
    26    !== NAMELIST
    27    !
    28    ! NAMELIST#major_comp_phase_change_nml
    29    !
    30  
    31    ! モジュール引用 ; USE statements
    32    !
    33  
    34    ! 格子点設定
    35    ! Grid points settings
    36    !
    37    use gridset, only: imax, & ! 経度格子点数.
    38                               ! Number of grid points in longitude
    39      &                jmax, & ! 緯度格子点数.
    40                               ! Number of grid points in latitude
    41      &                kmax    ! 鉛直層数.
    42                               ! Number of vertical level
    43  
    44    ! 種別型パラメタ
    45    ! Kind type parameter
    46    !
    47    use dc_types, only: DP, &      ! 倍精度実数型. Double precision.
    48      &                 STRING     ! 文字列.       Strings.
    49  
    50    ! NAMELIST ファイル入力に関するユーティリティ
    51    ! Utilities for NAMELIST file input
    52    !
    53    use namelist_util, only: MaxNmlArySize
    54                                ! NAMELIST から読み込む配列の最大サイズ.
    55                                ! Maximum size of arrays loaded from NAMELIST
    56  
    57    ! メッセージ出力
    58    ! Message output
    59    !
    60    use dc_message, only: MessageNotify
    61  
    62    ! 宣言文 ; Declaration statements
    63    !
    64    implicit none
    65    private
    66  
    67  
    68    ! 公開手続き
    69    ! Public procedure
    70    !
    71    public :: MajorCompPhaseChangeInAtm
    72    public :: MajorCompPhaseChangeOnGround
    73    public :: MajorCompPhaseChangeInit
    74  
    75  
    76    ! 公開変数
    77    ! Public variables
    78    !
    79    logical, save, public:: major_comp_phase_change_inited = .false.
    80                                ! 初期設定フラグ.
    81                                ! Initialization flag
    82  
    83    ! 非公開変数
    84    ! Private variables
    85    !
    86    logical, save :: FlagMajCompPhaseChange
    87    logical, save :: FlagModMom
    88  
    89  
    90    character(*), parameter:: module_name = 'major_comp_phase_change'
    91                                ! モジュールの名称.
    92                                ! Module name
    93    character(*), parameter:: version = &
    94      & '$Name:  $' // &
    95      & '$Id: major_comp_phase_change.f90,v 1.3 2014/05/07 09:39:21 murashin Exp $'
    96                                ! モジュールのバージョン
    97                                ! Module version
    98  
    99  
   100  contains
   101  
   102    !-------------------------------------------------------------------
   103  
   104    subroutine MajorCompPhaseChangeInAtmTest(  &
   105      & xyr_Press, xyz_Press, xyz_Height,      &  ! (in)
   106      & xy_Ps, xyz_Temp, xy_SurfMajCompIce     &  ! (inout)
   107      & )
   108      !
   109      ! CO2 相変化
   110      !
   111      ! CO2 phase change
   112      !
   113  
   114      ! モジュール引用 ; USE statements
   115      !
   116  
   117      ! 時刻管理
   118      ! Time control
   119      !
   120      use timeset, only: &
   121        & DelTime, &            ! $ \Delta t $
   122        & TimeN, &              ! ステップ $ t $ の時刻. Time of step $ t $.
   123        & TimesetClockStart, TimesetClockStop
   124  
   125      ! ヒストリデータ出力
   126      ! History data output
   127      !
   128      use gtool_historyauto, only: HistoryAutoPut
   129  
   130      ! 物理定数設定
   131      ! Physical constants settings
   132      !
   133      use constants, only: &
   134        & Grav, &               ! $ g $ [m s-2].
   135                                ! 重力加速度.
   136                                ! Gravitational acceleration
   137        & CpDry
   138                                ! $ C_p $ [J kg-1 K-1].
   139                                ! 乾燥大気の定圧比熱.
   140                                ! Specific heat of air at constant pressure
   141  
   142      ! 主成分相変化
   143      ! Phase change of atmospheric major component
   144      !
   145      use saturate_major_comp, only :     &
   146        & SaturateMajorCompCondTemp,      &
   147        & SaturateMajorCompInqLatentHeat
   148  
   149  
   150      ! 宣言文 ; Declaration statements
   151      !
   152      implicit none
   153  
   154      real(DP), intent(in   ):: xyr_Press (0:imax-1, 1:jmax, 0:kmax)
   155                                ! $ \hat{p} $ . 気圧 (半整数レベル).
   156                                ! Air pressure (half level)
   157      real(DP), intent(in   ):: xyz_Press (0:imax-1, 1:jmax, 1:kmax)
   158                                ! $ p $ . 気圧 (整数レベル).
   159                                ! Air pressure (full level)
   160      real(DP), intent(in   ):: xyz_Height(0:imax-1, 1:jmax, 1:kmax)
   161                                !
   162                                !
   163      real(DP), intent(inout):: xy_Ps            (0:imax-1, 1:jmax)
   164                                ! $ T $ .     温度. Temperature
   165      real(DP), intent(inout):: xyz_Temp         (0:imax-1, 1:jmax, 1:kmax)
   166                                ! $ T $ .     温度. Temperature
   167      real(DP), intent(inout):: xy_SurfMajCompIce(0:imax-1, 1:jmax)
   168                                !
   169                                ! Surface major component ice amount
   170  
   171      ! 作業変数
   172      ! Work variables
   173      !
   174      real(DP):: xyz_TempB           (0:imax-1, 1:jmax, 1:kmax)
   175                                ! 調節前の温度.
   176                                ! Temperature before adjustment
   177      real(DP):: xyz_DelAtmMass      (0:imax-1, 1:jmax, 1:kmax)
   178                                !
   179                                ! Atmospheric mass in a layer
   180      real(DP):: xy_FallingIce       (0:imax-1, 1:jmax)
   181                                !
   182                                !
   183      real(DP):: xyz_DelMajCompIce   (0:imax-1, 1:jmax, 1:kmax)
   184                                !
   185                                !
   186      real(DP):: xy_DelSurfMajCompIce(0:imax-1, 1:jmax)
   187                                !
   188                                !
   189      real(DP):: xyz_DTempDt         (0:imax-1, 1:jmax, 1:kmax)
   190                                ! 温度変化率.
   191                                ! Temperature tendency
   192      real(DP):: xy_DSurfMajCompIceDt(0:imax-1, 1:jmax)
   193                                !
   194                                ! Surface major component ice tendency
   195  
   196      real(DP):: xyz_TempCond   (0:imax-1, 1:jmax, 1:kmax)
   197      real(DP):: xy_SurfTempCond(0:imax-1, 1:jmax)
   198      real(DP):: SpecHeatCO2Ice
   199  
   200      real(DP):: LatentHeatMajCompSubl
   201  
   202      integer:: i               ! 経度方向に回る DO ループ用作業変数
   203                                ! Work variables for DO loop in longitude
   204      integer:: j               ! 緯度方向に回る DO ループ用作業変数
   205                                ! Work variables for DO loop in latitude
   206      integer:: k               ! 鉛直方向に回る DO ループ用作業変数
   207                                ! Work variables for DO loop in vertical direction
   208  
   209      logical :: FlagCheckPs
   210  
   211  
   212      ! 実行文 ; Executable statement
   213      !
   214  
   215      ! 初期化
   216      ! Initialization
   217      !
   218      if ( .not. major_comp_phase_change_inited ) then
   219        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   220      end if
   221  
   222  
   223      if ( .not. FlagMajCompPhaseChange ) return
   224  
   225  
   226      ! 計算時間計測開始
   227      ! Start measurement of computation time
   228      !
   229      call TimesetClockStart( module_name )
   230  
   231  
   232      ! Set latent heat
   233      LatentHeatMajCompSubl = SaturateMajorCompInqLatentHeat()
   234  
   235  
   236      FlagCheckPs = .false.
   237      do j = 1, jmax
   238        do i = 0, imax-1
   239          if ( xyr_Press(i,j,0) > 1.0e4_DP ) then
   240            FlagCheckPs = .true.
   241          end if
   242        end do
   243      end do
   244      if ( FlagCheckPs ) then
   245        call MessageNotify( 'W', module_name, 'Surface pressure is greater than 10000 Pa.' )
   246      end if
   247  
   248  
   249      ! 調節前 "Temp" の保存
   250      ! Store "Temp" before adjustment
   251      !
   252      xyz_TempB    = xyz_Temp
     .  !cdir    nodep                                                          
     .  !cdir noassume                                                          
     .        do t673 = 1, xyz_tempb.DSC.U3*(xyz_tempb.DSC.U2*xyz_tempb.DSC.U1  
     .       1    + xyz_tempb.DSC.U2)                                           
     .           xyz_tempb(t673-1,1,1) = xyz_temp(t673-1,1,1)                   
     .        enddo                                                             
   253  
   254  
   255      call SaturateMajorCompCondTemp(  &
   256        & xyz_Press,                   & ! (in)
   257        & xyz_TempCond                 & ! (inout)
   258        & )
   259  
   260  
   261      do k = 1, kmax
   262        xyz_DelAtmMass(:,:,k) = ( xyr_Press(i,j,k-1) - xyr_Press(i,j,k) ) / Grav
     .        d1 = 1.D0/grav                                                    
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t685 = 1, xyz_delatmmass.DSC.U2*xyz_delatmmass.DSC.U1 +        
     .       1   xyz_delatmmass.DSC.U2                                          
     .           xyz_delatmmass(t685-1,1,k) = (xyr_press(i,j,k-1)-xyr_press(i,j,
     .       1      k))*d1                                                      
     .        enddo                                                             
   263      end do
   264  
   265  
   266      k = kmax
   267      do j = 1, jmax
   268        do i = 0, imax-1
   269          if ( xyz_Temp(i,j,k) < xyz_TempCond(i,j,k) ) then
   270            xyz_DelMajCompIce(i,j,k) =                                 &
   271              &   CpDry * ( xyz_TempCond(i,j,k) - xyz_Temp(i,j,k) )    &
   272              &   * xyz_DelAtmMass(i,j,k)                              &
   273              &   / LatentHeatMajCompSubl
   274            xyz_Temp(i,j,k) = xyz_TempCond(i,j,k)
   275          else
   276            xyz_DelMajCompIce(i,j,k) = 0.0_DP
   277          end if
   278        end do
   279      end do
     .        j1 = and(jmax,3)                                                  
     .        i = 0                                                             
     .        if (jmax .gt. 0) then                                             
     .           if (imax .gt. 0) then                                          
     .              do j = 1, j1                                                
     .  !cdir          nodep                                                    
     .                 do i = 1, imax                                           
     .                    if (xyz_temp(i-1,j,k) .lt. xyz_tempcond(i-1,j,k)) then
     .                       xyz_delmajcompice2 = cpdry*(xyz_tempcond(i-1,j,k)- 
     .       1                  xyz_temp(i-1,j,k))*xyz_delatmmass(i-1,j,k)/     
     .       2                  latentheatmajcompsubl                           
     .                       xyz_temp(i-1,j,k) = xyz_tempcond(i-1,j,k)          
     .                    else                                                  
     .                       xyz_delmajcompice2 = 0.0000000000000000e+000       
     .                    endif                                                 
     .                    xyz_delmajcompice(i-1,j,k) = xyz_delmajcompice2       
     .                 enddo                                                    
     .              enddo                                                       
     .           endif                                                          
     .        endif                                                             
     .        i = 0                                                             
     .        if (jmax .gt. 0) then                                             
     .           if (imax .gt. 0) then                                          
     .              do j = j1 + 1, jmax, 4                                      
     .  !cdir          nodep                                                    
     .                 do i = 1, imax                                           
     .                    if (xyz_temp(i-1,j,k) .lt. xyz_tempcond(i-1,j,k)) then
     .                       xyz_delmajcompice3 = cpdry*(xyz_tempcond(i-1,j,k)- 
     .       1                  xyz_temp(i-1,j,k))*xyz_delatmmass(i-1,j,k)/     
     .       2                  latentheatmajcompsubl                           
     .                       xyz_temp(i-1,j,k) = xyz_tempcond(i-1,j,k)          
     .                    else                                                  
     .                       xyz_delmajcompice3 = 0.0000000000000000e+000       
     .                    endif                                                 
     .                    xyz_delmajcompice(i-1,j,k) = xyz_delmajcompice3       
     .                    if (xyz_temp(i-1,j+1,k) .lt. xyz_tempcond(i-1,j+1,k)) 
     .       1               then                                               
     .                       xyz_delmajcompice4 = cpdry*(xyz_tempcond(i-1,j+1,k)
     .       1                  -xyz_temp(i-1,j+1,k))*xyz_delatmmass(i-1,j+1,k)/
     .       2                  latentheatmajcompsubl                           
     .                       xyz_temp(i-1,j+1,k) = xyz_tempcond(i-1,j+1,k)      
     .                    else                                                  
     .                       xyz_delmajcompice4 = 0.0000000000000000e+000       
     .                    endif                                                 
     .                    xyz_delmajcompice(i-1,j+1,k) = xyz_delmajcompice4     
     .                    if (xyz_temp(i-1,j+2,k) .lt. xyz_tempcond(i-1,j+2,k)) 
     .       1               then                                               
     .                       xyz_delmajcompice5 = cpdry*(xyz_tempcond(i-1,j+2,k)
     .       1                  -xyz_temp(i-1,j+2,k))*xyz_delatmmass(i-1,j+2,k)/
     .       2                  latentheatmajcompsubl                           
     .                       xyz_temp(i-1,j+2,k) = xyz_tempcond(i-1,j+2,k)      
     .                    else                                                  
     .                       xyz_delmajcompice5 = 0.0000000000000000e+000       
     .                    endif                                                 
     .                    xyz_delmajcompice(i-1,j+2,k) = xyz_delmajcompice5     
     .                    if (xyz_temp(i-1,j+3,k) .lt. xyz_tempcond(i-1,j+3,k)) 
     .       1               then                                               
     .                       xyz_delmajcompice6 = cpdry*(xyz_tempcond(i-1,j+3,k)
     .       1                  -xyz_temp(i-1,j+3,k))*xyz_delatmmass(i-1,j+3,k)/
     .       2                  latentheatmajcompsubl                           
     .                       xyz_temp(i-1,j+3,k) = xyz_tempcond(i-1,j+3,k)      
     .                    else                                                  
     .                       xyz_delmajcompice6 = 0.0000000000000000e+000       
     .                    endif                                                 
     .                    xyz_delmajcompice(i-1,j+3,k) = xyz_delmajcompice6     
     .                 enddo                                                    
     .              enddo                                                       
     .              i = imax                                                    
     .           endif                                                          
     .        endif                                                             
   280      !
   281      xy_FallingIce = 0.0_DP
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t691 = 1, xy_fallingice.DSC.U2*xy_fallingice.DSC.U1 +          
     .       1   xy_fallingice.DSC.U2                                           
     .           xy_fallingice(t691-1,1) = 0.0000000000000000e+000              
     .        enddo                                                             
   282      do k = kmax-1, 1, -1
   283        xy_FallingIce = xy_FallingIce + xyz_DelMajCompIce(:,:,k+1)
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xy_fallingice)                                             
     .        do t697 = 1, xy_fallingice.DSC.U2*xy_fallingice.DSC.U1 +          
     .       1   xy_fallingice.DSC.U2                                           
     .           xy_fallingice(t697-1,1) = xy_fallingice(t697-1,1) +            
     .       1      xyz_delmajcompice(t697-1,1,k+1)                             
     .        enddo                                                             
   284        do j = 1, jmax
   285          do i = 0, imax-1
   286            SpecHeatCO2Ice = 349.0_DP + 4.8_DP * xyz_TempCond(i,j,k)
   287            !                                            Forget et al. (1998)
   288            xyz_DelMajCompIce(i,j,k) =                                     &
   289              &   CpDry * ( xyz_TempCond(i,j,k) - xyz_Temp(i,j,k) )        &
   290              &   * xyz_DelAtmMass(i,j,k)                                  &
   291              &   / LatentHeatMajCompSubl                                  &
   292              & - (   Grav * ( xyz_Height(i,j,k+1) - xyz_Height(i,j,k) )   &
   293              &     + SpecHeatCO2Ice                                       &
   294              &       * ( xyz_TempCond(i,j,k+1) - xyz_TempCond(i,j,k) ) )  &
   295              &   / LatentHeatMajCompSubl                                  &
   296              &   * xy_FallingIce(i,j)
   297            if ( ( xy_FallingIce(i,j) + xyz_DelMajCompIce(i,j,k) ) >= 0.0_DP ) then
   298              xyz_Temp(i,j,k) = xyz_TempCond(i,j,k)
   299            else
   300              xyz_DelMajCompIce(i,j,k) = - xy_FallingIce(i,j)
   301              xyz_Temp(i,j,k) = xyz_Temp(i,j,k)                                &
   302                & + ( - LatentHeatMajCompSubl                                  &
   303                &     + Grav * ( xyz_Height(i,j,k+1) - xyz_Height(i,j,k) )     &
   304                &     + SpecHeatCO2Ice                                         &
   305                &         * ( xyz_TempCond(i,j,k+1) - xyz_TempCond(i,j,k) ) )  &
   306                &     / ( CpDry * xyz_DelAtmMass(i,j,k) )                      &
   307                &     * xy_FallingIce(i,j)
   308            end if
   309          end do
     .        i = 0                                                             
     .        if (imax .gt. 0) then                                             
     .           d8 = 1.D0/latentheatmajcompsubl                                
     .           d9 = 1.D0/latentheatmajcompsubl                                
     .  !cdir    nodep                                                          
     .  !cdir    on_adb(xy_fallingice)                                          
     .           do i = 1, imax                                                 
     .              specheatco2ice = 3.49000000000000e+002 +                    
     .       1         4.79999999999999e+000*xyz_tempcond(i-1,j,k)              
     .              xyz_delmajcompice1 = cpdry*(xyz_tempcond(i-1,j,k)-xyz_temp(i
     .       1         -1,j,k))*xyz_delatmmass(i-1,j,k)*d8 - ((grav*(xyz_height(
     .       2         i-1,j,k+1)-xyz_height(i-1,j,k)))+(specheatco2ice*(       
     .       3         xyz_tempcond(i-1,j,k+1)-xyz_tempcond(i-1,j,k))))*d9*     
     .       4         xy_fallingice(i-1,j)                                     
     .              if (xy_fallingice(i-1,j) + xyz_delmajcompice1 .ge.          
     .       1         0.0000000000000000e+000) then                            
     .                 xyz_temp10 = xyz_tempcond(i-1,j,k)                       
     .              else                                                        
     .                 xyz_delmajcompice1 = -xy_fallingice(i-1,j)               
     .                 xyz_temp10 = xyz_temp(i-1,j,k) + ((grav*(xyz_height(i-1,j
     .       1            ,k+1)-xyz_height(i-1,j,k)))-latentheatmajcompsubl+(   
     .       2            specheatco2ice*(xyz_tempcond(i-1,j,k+1)-xyz_tempcond(i
     .       3            -1,j,k))))/(cpdry*xyz_delatmmass(i-1,j,k))*           
     .       4            xy_fallingice(i-1,j)                                  
     .              endif                                                       
     .              xyz_temp(i-1,j,k) = xyz_temp10                              
     .              xyz_delmajcompice(i-1,j,k) = xyz_delmajcompice1             
     .           enddo                                                          
     .           i = imax                                                       
     .        endif                                                             
   310        end do
   311      end do
   312  
   313  
   314      ! Ice falling on the surface
   315      !   This may result in supersaturation in the lowest level.
   316      !
   317      xy_FallingIce = xy_FallingIce + xyz_DelMajCompIce(:,:,1)
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xy_fallingice)                                             
     .        do t707 = 1, xy_fallingice.DSC.U2*xy_fallingice.DSC.U1 +          
     .       1   xy_fallingice.DSC.U2                                           
     .           xy_fallingice(t707-1,1) = xy_fallingice(t707-1,1) +            
     .       1      xyz_delmajcompice(t707-1,1,1)                               
     .        enddo                                                             
   318      k = 1
   319      do j = 1, jmax
   320        do i = 0, imax-1
   321          xy_DelSurfMajCompIce(i,j) =                                    &
   322            & - (   Grav * ( xyz_Height(i,j,1) - 0.0_DP ) )              &
   323            &   / LatentHeatMajCompSubl                                  &
   324            &   * xy_FallingIce(i,j)
   325  
   326  
   327  
   328            SpecHeatCO2Ice = 349.0_DP + 4.8_DP * xy_SurfTempCond(i,j)
   329            !                                            Forget et al. (1998)
   330            xy_DelSurfMajCompIce(i,j) =                                    &
   331  !!$            &   CpDry * ( xyz_TempCond(i,j,k) - xyz_Temp(i,j,k) )        &
   332  !!$            &   * xyz_DelAtmMass(i,j,k)                                  &
   333  !!$            &   / LatentHeatMajCompSubl                                  &
   334              & - (   Grav * ( xyz_Height(i,j,1) - 0.0_DP )                &
   335              &     + SpecHeatCO2Ice                                       &
   336              &       * ( xyz_TempCond(i,j,1) - xy_SurfTempCond(i,j) ) )   &
   337              &   / LatentHeatMajCompSubl                                  &
   338              &   * xy_FallingIce(i,j)
   339  
   340  
   341          if ( ( xy_FallingIce(i,j) + xy_DelSurfMajCompIce(i,j) ) >= 0.0_DP ) then
   342            ! Part of ice sublimes.
   343            ! NOTE: In this case, temperature in the lowest layer should be
   344            ! condensation temperature. So, actually, the set of temperature is
   345            ! meaningless.
   346            xyz_Temp(i,j,k) = xyz_TempCond(i,j,k)
   347          else
   348            ! All falling ice sublimes.
   349            ! NOTE: The formulation below is different from that by Forget et al.
   350            ! (1998). The latent heat and heat by potential energy release and
   351            ! heating ice is distributed in the lowest layer in this model, not
   352            ! to the soil.
   353            xy_DelSurfMajCompIce(i,j) = - xy_FallingIce(i,j)
   354            xyz_Temp(i,j,k) = xyz_Temp(i,j,k)                                &
   355              & + ( - LatentHeatMajCompSubl                                  &
   356              &     + Grav * ( xyz_Height(i,j,1) - 0.0_DP )                  &
   357              &     + SpecHeatCO2Ice                                         &
   358              &         * ( xyz_TempCond(i,j,1) - xy_SurfTempCond(i,j) ) )   &
   359              &     / ( CpDry * xyz_DelAtmMass(i,j,k) )                      &
   360              &     * xy_FallingIce(i,j)
   361         end if
   362         end do
     .        i = 0                                                             
     .        if (imax .gt. 0) then                                             
     .           d12 = 1.D0/latentheatmajcompsubl                               
     .           d13 = 1.D0/latentheatmajcompsubl                               
     .  !cdir    nodep                                                          
     .  !cdir    on_adb(xy_fallingice)                                          
     .           do i = 1, imax                                                 
     .              xy_delsurfmajcompice1 = -(grav*(xyz_height(i-1,j,1)-        
     .       1         0.0000000000000000e+000))*d12*xy_fallingice(i-1,j)       
     .              specheatco2ice = 3.49000000000000e+002 +                    
     .       1         4.79999999999999e+000*xy_surftempcond(i-1,j)             
     .              xy_delsurfmajcompice1 = -((grav*(xyz_height(i-1,j,1)-       
     .       1         0.0000000000000000e+000))+(specheatco2ice*(xyz_tempcond(i
     .       2         -1,j,1)-xy_surftempcond(i-1,j))))*d13*xy_fallingice(i-1,j
     .       3         )                                                        
     .              if (xy_fallingice(i-1,j) + xy_delsurfmajcompice1 .ge.       
     .       1         0.0000000000000000e+000) then                            
     .                 xyz_temp14 = xyz_tempcond(i-1,j,1)                       
     .              else                                                        
     .                 xy_delsurfmajcompice1 = -xy_fallingice(i-1,j)            
     .                 xyz_temp14 = xyz_temp(i-1,j,1) + ((grav*(xyz_height(i-1,j
     .       1            ,1)-0.0000000000000000e+000))-latentheatmajcompsubl+( 
     .       2            specheatco2ice*(xyz_tempcond(i-1,j,1)-xy_surftempcond(
     .       3            i-1,j))))/(cpdry*xyz_delatmmass(i-1,j,1))*            
     .       4            xy_fallingice(i-1,j)                                  
     .              endif                                                       
     .              xyz_temp(i-1,j,1) = xyz_temp14                              
     .              xy_delsurfmajcompice(i-1,j) = xy_delsurfmajcompice1         
     .           enddo                                                          
     .           i = imax                                                       
     .        endif                                                             
   363      end do
   364  
   365  
   366      ! 温度変化率
   367      ! Calculate temperature tendency
   368      !
   369      xyz_DTempDt = ( xyz_Temp - xyz_TempB ) / ( 2.0_DP * DelTime )
     .        d15 = 1.D0/(2.00000000000000e+000*deltime)                        
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t717 = 1, kmax*jmax*imax                                       
     .           xyz_dtempdt(t717-1,1,1) = (xyz_temp(t717-1,1,1)-xyz_tempb(t717-
     .       1      1,1,1))*d15                                                 
     .        enddo                                                             
   370  
   371  
   372      !
   373      ! Surface major component ice adjustment
   374      !
   375      xy_DSurfMajCompIceDt = 0.0_DP
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t732 = 1, xy_dsurfmajcompicedt.DSC.U2*                         
     .       1   xy_dsurfmajcompicedt.DSC.U1 + xy_dsurfmajcompicedt.DSC.U2      
     .           xy_dsurfmajcompicedt(t732-1,1) = 0.0000000000000000e+000       
     .        enddo                                                             
   376      do k = kmax, 1, -1
   377        xy_DSurfMajCompIceDt = xy_DSurfMajCompIceDt + xyz_DelMajCompIce(:,:,k)
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xy_dsurfmajcompicedt)                                      
     .        do t738 = 1, xy_dsurfmajcompicedt.DSC.U2*                         
     .       1   xy_dsurfmajcompicedt.DSC.U1 + xy_dsurfmajcompicedt.DSC.U2      
     .           xy_dsurfmajcompicedt(t738-1,1) = xy_dsurfmajcompicedt(t738-1,1)
     .       1       + xyz_delmajcompice(t738-1,1,k)                            
     .        enddo                                                             
   378      end do
   379      xy_DSurfMajCompIceDt = xy_DSurfMajCompIceDt + xy_DelSurfMajCompIce(i,j)
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xy_dsurfmajcompicedt)                                      
     .        do t748 = 1, xy_dsurfmajcompicedt.DSC.U2*                         
     .       1   xy_dsurfmajcompicedt.DSC.U1 + xy_dsurfmajcompicedt.DSC.U2      
     .           xy_dsurfmajcompicedt(t748-1,1) = xy_dsurfmajcompicedt(t748-1,1)
     .       1       + xy_delsurfmajcompice(i,j)                                
     .           xy_surfmajcompice(t748-1,1) = xy_surfmajcompice(t748-1,1) +    
     .       1      xy_dsurfmajcompicedt(t748-1,1)*(2.00000000000000e+000*      
     .       2      deltime)                                                    
     .           xy_ps(t748-1,1) = xy_ps(t748-1,1) - xy_dsurfmajcompicedt(t748-1
     .       1      ,1)*grav*(2.00000000000000e+000*deltime)                    
     .        enddo                                                             
   380      !
   381      xy_SurfMajCompIce = xy_SurfMajCompIce &
   382        & + xy_DSurfMajCompIceDt * ( 2.0_DP * DelTime )
   383  
   384  
   385      !
   386      ! Surface pressure adjustment
   387      !
   388      xy_Ps = xy_Ps - xy_DSurfMajCompIceDt * Grav * ( 2.0_DP * DelTime )
   389  
   390  
   391      ! ヒストリデータ出力
   392      ! History data output
   393      !
   394      call HistoryAutoPut( TimeN, 'DTempDtMajCompPhaseChange', xyz_DTempDt )
   395  
   396  
   397      ! 計算時間計測一時停止
   398      ! Pause measurement of computation time
   399      !
   400      call TimesetClockStop( module_name )
   401  
   402    end subroutine MajorCompPhaseChangeInAtmTest
   403  
   404    !--------------------------------------------------------------------------------------
   405  
   406    subroutine MajorCompPhaseChangeInAtmBK(   &
   407      & xyr_Press, xyz_Press,               &  ! (in)
   408      & xy_Ps, xyz_Temp, xy_SurfMajCompIce  &  ! (inout)
   409      & )
   410      !
   411      ! CO2 相変化
   412      !
   413      ! CO2 phase change
   414      !
   415  
   416      ! モジュール引用 ; USE statements
   417      !
   418  
   419      ! 時刻管理
   420      ! Time control
   421      !
   422      use timeset, only: &
   423        & DelTime, &            ! $ \Delta t $
   424        & TimeN, &              ! ステップ $ t $ の時刻. Time of step $ t $.
   425        & TimesetClockStart, TimesetClockStop
   426  
   427      ! ヒストリデータ出力
   428      ! History data output
   429      !
   430      use gtool_historyauto, only: HistoryAutoPut
   431  
   432      ! 物理定数設定
   433      ! Physical constants settings
   434      !
   435      use constants, only: &
   436        & Grav, &               ! $ g $ [m s-2].
   437                                ! 重力加速度.
   438                                ! Gravitational acceleration
   439        & CpDry
   440                                ! $ C_p $ [J kg-1 K-1].
   441                                ! 乾燥大気の定圧比熱.
   442                                ! Specific heat of air at constant pressure
   443  
   444      ! 主成分相変化
   445      ! Phase change of atmospheric major component
   446      !
   447      use saturate_major_comp, only :    &
   448        & SaturateMajorCompCondTemp,     &
   449        & SaturateMajorCompInqLatentHeat
   450  
   451  
   452      ! 宣言文 ; Declaration statements
   453      !
   454      implicit none
   455  
   456      real(DP), intent(in   ):: xyr_Press (0:imax-1, 1:jmax, 0:kmax)
   457                                ! $ \hat{p} $ . 気圧 (半整数レベル).
   458                                ! Air pressure (half level)
   459      real(DP), intent(in   ):: xyz_Press (0:imax-1, 1:jmax, 1:kmax)
   460                                ! $ p $ . 気圧 (整数レベル).
   461                                ! Air pressure (full level)
   462      real(DP), intent(inout):: xy_Ps            (0:imax-1, 1:jmax)
   463                                ! $ T $ .     温度. Temperature
   464      real(DP), intent(inout):: xyz_Temp         (0:imax-1, 1:jmax, 1:kmax)
   465                                ! $ T $ .     温度. Temperature
   466      real(DP), intent(inout):: xy_SurfMajCompIce(0:imax-1, 1:jmax)
   467                                !
   468                                ! Surface major component ice amount
   469  
   470      ! 作業変数
   471      ! Work variables
   472      !
   473      real(DP):: xyz_TempB           (0:imax-1, 1:jmax, 1:kmax)
   474                                ! 調節前の温度.
   475                                ! Temperature before adjustment
   476      real(DP):: xyz_DTempDt         (0:imax-1, 1:jmax, 1:kmax)
   477                                ! 温度変化率.
   478                                ! Temperature tendency
   479      real(DP):: xy_DSurfMajCompIceDt(0:imax-1, 1:jmax)
   480                                !
   481                                ! Surface major component ice tendency
   482  
   483      real(DP):: xyz_TempCond   (0:imax-1, 1:jmax, 1:kmax)
   484  
   485      real(DP):: LatentHeatMajCompSubl
   486  
   487      integer:: i               ! 経度方向に回る DO ループ用作業変数
   488                                ! Work variables for DO loop in longitude
   489      integer:: j               ! 緯度方向に回る DO ループ用作業変数
   490                                ! Work variables for DO loop in latitude
   491      integer:: k               ! 鉛直方向に回る DO ループ用作業変数
   492                                ! Work variables for DO loop in vertical direction
   493  
   494      logical :: FlagCheckPs
   495  
   496  
   497      ! 実行文 ; Executable statement
   498      !
   499  
   500      ! 初期化
   501      ! Initialization
   502      !
   503      if ( .not. major_comp_phase_change_inited ) then
   504        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   505      end if
   506  
   507  
   508      if ( .not. FlagMajCompPhaseChange ) return
   509  
   510  
   511      ! 計算時間計測開始
   512      ! Start measurement of computation time
   513      !
   514      call TimesetClockStart( module_name )
   515  
   516  
   517      ! Set latent heat
   518      LatentHeatMajCompSubl = SaturateMajorCompInqLatentHeat()
   519  
   520  
   521      FlagCheckPs = .false.
   522      do j = 1, jmax
   523        do i = 0, imax-1
   524          if ( xyr_Press(i,j,0) > 1.0e4_DP ) then
   525            FlagCheckPs = .true.
   526          end if
   527        end do
   528      end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do j = 1, jmax*imax                                               
     .           if (xyr_press(j-1,1,0) .gt. 1.00000000000000e+004) then        
     .              flagcheckps = 1                                             
     .           endif                                                          
     .        enddo                                                             
   529      if ( FlagCheckPs ) then
   530        call MessageNotify( 'W', module_name, 'Surface pressure is greater than 10000 Pa.' )
   531      end if
   532  
   533  
   534      ! 調節前 "Temp" の保存
   535      ! Store "Temp" before adjustment
   536      !
   537      xyz_TempB    = xyz_Temp
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t271 = 1, xyz_tempb.DSC.U3*(xyz_tempb.DSC.U2*xyz_tempb.DSC.U1  
     .       1    + xyz_tempb.DSC.U2)                                           
     .           xyz_tempb(t271-1,1,1) = xyz_temp(t271-1,1,1)                   
     .        enddo                                                             
   538  
   539  
   540      call SaturateMajorCompCondTemp( &
   541        & xyz_Press,                  & ! (in)
   542        & xyz_TempCond                & ! (inout)
   543        & )
   544  
   545  
   546      do k = 1, kmax
   547        do j = 1, jmax
   548          do i = 0, imax-1
   549            if ( xyz_Temp(i,j,k) < xyz_TempCond(i,j,k) ) then
   550              xyz_Temp(i,j,k) = xyz_TempCond(i,j,k)
   551            end if
   552          end do
   553        end do
   554      end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do k = 1, kmax*jmax*imax                                          
     .           if (xyz_temp(k-1,1,1) .lt. xyz_tempcond(k-1,1,1)) then         
     .              xyz_temp(k-1,1,1) = xyz_tempcond(k-1,1,1)                   
     .           endif                                                          
     .        enddo                                                             
   555  
   556      ! 温度変化率
   557      ! Calculate temperature tendency
   558      !
   559      xyz_DTempDt = ( xyz_Temp - xyz_TempB ) / ( 2.0_DP * DelTime )
     .        d1 = 1.D0/(2.00000000000000e+000*deltime)                         
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t283 = 1, kmax*jmax*imax                                       
     .           xyz_dtempdt(t283-1,1,1) = (xyz_temp(t283-1,1,1)-xyz_tempb(t283-
     .       1      1,1,1))*d1                                                  
     .        enddo                                                             
   560  
   561  
   562      !
   563      ! Surface major component ice adjustment
   564      !
   565      xy_DSurfMajCompIceDt = 0.0_DP
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t298 = 1, xy_dsurfmajcompicedt.DSC.U2*                         
     .       1   xy_dsurfmajcompicedt.DSC.U1 + xy_dsurfmajcompicedt.DSC.U2      
     .           xy_dsurfmajcompicedt(t298-1,1) = 0.0000000000000000e+000       
     .        enddo                                                             
   566      do k = kmax, 1, -1
   567        xy_DSurfMajCompIceDt = xy_DSurfMajCompIceDt                    &
     .        d2 = 1.D0/grav                                                    
     .        d3 = d2/latentheatmajcompsubl                                     
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xy_dsurfmajcompicedt,xyr_press)                            
     .        do t304 = 1, xy_dsurfmajcompicedt.DSC.U2*                         
     .       1   xy_dsurfmajcompicedt.DSC.U1 + xy_dsurfmajcompicedt.DSC.U2      
     .           xy_dsurfmajcompicedt(t304-1,1) = xy_dsurfmajcompicedt(t304-1,1)
     .       1       + cpdry*xyz_dtempdt(t304-1,1,k)*(xyr_press(t304-1,1,k-1)-  
     .       2      xyr_press(t304-1,1,k))*d3                                   
     .        enddo                                                             
   568          & + CpDry * xyz_DTempDt(:,:,k)                               &
   569          &   * ( xyr_Press(:,:,k-1) - xyr_Press(:,:,k) ) / Grav       &
   570          &   / LatentHeatMajCompSubl
   571      end do
   572      xy_SurfMajCompIce = xy_SurfMajCompIce + xy_DSurfMajCompIceDt * ( 2.0_DP * DelTime )
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xy_dsurfmajcompicedt)                                      
     .        do t318 = 1, jmax*imax                                            
     .           xy_surfmajcompice(t318-1,1) = xy_surfmajcompice(t318-1,1) +    
     .       1      xy_dsurfmajcompicedt(t318-1,1)*(2.00000000000000e+000*      
     .       2      deltime)                                                    
     .           xy_ps(t318-1,1) = xy_ps(t318-1,1) - xy_dsurfmajcompicedt(t318-1
     .       1      ,1)*grav*(2.00000000000000e+000*deltime)                    
     .        enddo                                                             
   573  
   574  
   575      !
   576      ! Surface pressure adjustment
   577      !
   578      xy_Ps = xy_Ps - xy_DSurfMajCompIceDt * Grav * ( 2.0_DP * DelTime )
   579  
   580  
   581      ! ヒストリデータ出力
   582      ! History data output
   583      !
   584      call HistoryAutoPut( TimeN, 'DTempDtMajCompPhaseChange', xyz_DTempDt )
   585  
   586  
   587      ! 計算時間計測一時停止
   588      ! Pause measurement of computation time
   589      !
   590      call TimesetClockStop( module_name )
   591  
   592    end subroutine MajorCompPhaseChangeInAtmBK
   593  
   594    !--------------------------------------------------------------------------------------
   595  
   596    subroutine MajorCompPhaseChangeInAtmBK2(              &
   597      & xyr_Press, xyz_Press,                          & ! (in)
   598      & xy_Ps, xyz_Temp, xyzf_QMix, xy_SurfMajCompIce  & ! (inout)
   599      & )
   600      !
   601      ! CO2 相変化
   602      !
   603      ! CO2 phase change
   604      !
   605  
   606      ! モジュール引用 ; USE statements
   607      !
   608  
   609      ! 時刻管理
   610      ! Time control
   611      !
   612      use timeset, only: &
   613        & DelTime, &            ! $ \Delta t $
   614        & TimeN, &              ! ステップ $ t $ の時刻. Time of step $ t $.
   615        & TimesetClockStart, TimesetClockStop
   616  
   617      ! ヒストリデータ出力
   618      ! History data output
   619      !
   620      use gtool_historyauto, only: HistoryAutoPut
   621  
   622      ! 組成に関わる配列の設定
   623      ! Settings of array for atmospheric composition
   624      !
   625      use composition, only : &
   626        & ncmax, &
   627        & IndexTKE
   628  
   629      ! 物理定数設定
   630      ! Physical constants settings
   631      !
   632      use constants, only: &
   633        & Grav, &               ! $ g $ [m s-2].
   634                                ! 重力加速度.
   635                                ! Gravitational acceleration
   636        & CpDry
   637                                ! $ C_p $ [J kg-1 K-1].
   638                                ! 乾燥大気の定圧比熱.
   639                                ! Specific heat of air at constant pressure
   640  
   641      ! 温度の半整数σレベルの補間, 気圧と高度の算出
   642      ! Interpolate temperature on half sigma level,
   643      ! and calculate pressure and height
   644      !
   645      use auxiliary, only: AuxVars
   646  
   647      ! 主成分相変化
   648      ! Phase change of atmospheric major component
   649      !
   650      use saturate_major_comp, only :    &
   651        & SaturateMajorCompCondTemp,     &
   652        & SaturateMajorCompInqLatentHeat
   653  
   654      ! 質量の補正
   655      ! Mass fixer
   656      !
   657      use mass_fixer, only: MassFixerColumn
   658  
   659      ! 宣言文 ; Declaration statements
   660      !
   661      implicit none
   662  
   663      real(DP), intent(in   ):: xyr_Press (0:imax-1, 1:jmax, 0:kmax)
   664                                ! $ \hat{p} $ . 気圧 (半整数レベル).
   665                                ! Air pressure (half level)
   666      real(DP), intent(in   ):: xyz_Press (0:imax-1, 1:jmax, 1:kmax)
   667                                ! $ p $ . 気圧 (整数レベル).
   668                                ! Air pressure (full level)
   669      real(DP), intent(inout):: xy_Ps            (0:imax-1, 1:jmax)
   670                                ! $ T $ .     温度. Temperature
   671      real(DP), intent(inout):: xyz_Temp         (0:imax-1, 1:jmax, 1:kmax)
   672                                ! $ T $ .     温度. Temperature
   673      real(DP), intent(inout):: xyzf_QMix        (0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
   674      real(DP), intent(inout):: xy_SurfMajCompIce(0:imax-1, 1:jmax)
   675                                !
   676                                ! Surface major component ice amount
   677  
   678      ! 作業変数
   679      ! Work variables
   680      !
   681      real(DP):: LatentHeatMajCompSubl
   682  
   683      real(DP):: xy_PsB              (0:imax-1, 1:jmax)
   684      real(DP):: xy_PsA              (0:imax-1, 1:jmax)
   685      real(DP):: xyr_PressB          (0:imax-1, 1:jmax, 0:kmax)
   686      real(DP):: xyr_PressA          (0:imax-1, 1:jmax, 0:kmax)
   687  
   688      real(DP):: xyz_TempB           (0:imax-1, 1:jmax, 1:kmax)
   689                                ! 調節前の温度.
   690                                ! Temperature before adjustment
   691      real(DP):: xyzf_QMixB          (0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
   692  
   693  
   694      real(DP):: xyz_TempTmp         (0:imax-1, 1:jmax, 1:kmax)
   695      real(DP):: xyz_QH2OVapTmp      (0:imax-1, 1:jmax, 1:kmax)
   696  
   697      real(DP):: xyz_DTempDt         (0:imax-1, 1:jmax, 1:kmax)
   698                                ! 温度変化率.
   699                                ! Temperature tendency
   700      real(DP):: xy_DSurfMajCompIceDt(0:imax-1, 1:jmax)
   701                                !
   702                                ! Surface major component ice tendency
   703      real(DP):: xy_DPsDt            (0:imax-1, 1:jmax)
   704  
   705      real(DP):: xy_DSurfMajCompIceDtOneLayer(0:imax-1, 1:jmax)
   706      real(DP):: xyr_DPressDt                (0:imax-1, 1:jmax, 0:kmax)
   707  
   708      real(DP):: xyz_TempCond   (0:imax-1, 1:jmax, 1:kmax)
   709  
   710      integer :: mmax
   711      real(DP):: xyza_Array       (0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
   712      logical :: a_FlagSurfaceSink(1:ncmax)
   713      real(DP):: xyra_MassFlow    (0:imax-1, 1:jmax, 0:kmax, 1:ncmax)
   714  
   715      real(DP):: xyrf_MassFlow    (0:imax-1, 1:jmax, 0:kmax, 1:ncmax)
   716  
   717      real(DP):: xyz_DelAtmMassB   (0:imax-1, 1:jmax, 1:kmax)
   718      real(DP):: xyz_DelAtmMassA   (0:imax-1, 1:jmax, 1:kmax)
   719  
   720      integer:: i               ! 経度方向に回る DO ループ用作業変数
   721                                ! Work variables for DO loop in longitude
   722      integer:: j               ! 緯度方向に回る DO ループ用作業変数
   723                                ! Work variables for DO loop in latitude
   724      integer:: k               ! 鉛直方向に回る DO ループ用作業変数
   725                                ! Work variables for DO loop in vertical direction
   726      integer:: m
   727      integer:: n
   728  
   729      logical :: FlagCheckPs
   730  
   731  
   732      ! 実行文 ; Executable statement
   733      !
   734  
   735      ! 初期化
   736      ! Initialization
   737      !
   738      if ( .not. major_comp_phase_change_inited ) then
   739        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   740      end if
   741  
   742  
   743      if ( .not. FlagMajCompPhaseChange ) return
   744  
   745  
   746      ! 計算時間計測開始
   747      ! Start measurement of computation time
   748      !
   749      call TimesetClockStart( module_name )
   750  
   751  
   752      ! Set latent heat
   753      LatentHeatMajCompSubl = SaturateMajorCompInqLatentHeat()
   754  
   755  
   756      FlagCheckPs = .false.
   757      do j = 1, jmax
   758        do i = 0, imax-1
   759          if ( xyr_Press(i,j,0) > 1.0e4_DP ) then
   760            FlagCheckPs = .true.
   761          end if
   762        end do
   763      end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do j = 1, jmax*imax                                               
     .           if (xyr_press(j-1,1,0) .gt. 1.00000000000000e+004) then        
     .              flagcheckps = 1                                             
     .           endif                                                          
     .        enddo                                                             
   764      if ( FlagCheckPs ) then
   765        call MessageNotify( 'W', module_name, 'Surface pressure is greater than 10000 Pa.' )
   766      end if
   767  
   768  
   769      ! Store variables
   770      !
   771      xyz_TempB  = xyz_Temp
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t655 = 1, xyz_tempb.DSC.U3*(xyz_tempb.DSC.U2*xyz_tempb.DSC.U1  
     .       1    + xyz_tempb.DSC.U2)                                           
     .           xyz_tempb(t655-1,1,1) = xyz_temp(t655-1,1,1)                   
     .        enddo                                                             
   772      xyzf_QMixB = xyzf_QMix
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t667 = 1, xyzf_qmixb.DSC.U4*xyzf_qmixb.DSC.U3*xyzf_qmixb.DSC.U2
     .       1   *(xyzf_qmixb.DSC.U1 + 1)                                       
     .           xyzf_qmixb(t667-1,1,1,1) = xyzf_qmix(t667-1,1,1,1)             
     .        enddo                                                             
   773  
   774  
   775      call SaturateMajorCompCondTemp( &
   776        & xyz_Press,                  & ! (in)
   777        & xyz_TempCond                & ! (inout)
   778        & )
   779  
   780  
   781      do k = 1, kmax
   782        do j = 1, jmax
   783          do i = 0, imax-1
   784            if ( xyz_Temp(i,j,k) < xyz_TempCond(i,j,k) ) then
   785              xyz_Temp(i,j,k) = xyz_TempCond(i,j,k)
   786            end if
   787          end do
   788        end do
   789      end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do k = 1, kmax*jmax*imax                                          
     .           if (xyz_temp(k-1,1,1) .lt. xyz_tempcond(k-1,1,1)) then         
     .              xyz_temp(k-1,1,1) = xyz_tempcond(k-1,1,1)                   
     .           endif                                                          
     .        enddo                                                             
   790  
   791      ! 温度変化率
   792      ! Calculate temperature tendency
   793      !
   794      xyz_DTempDt = ( xyz_Temp - xyz_TempB ) / ( 2.0_DP * DelTime )
     .        d1 = 1.D0/(2.00000000000000e+000*deltime)                         
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t683 = 1, kmax*jmax*imax                                       
     .           xyz_dtempdt(t683-1,1,1) = (xyz_temp(t683-1,1,1)-xyz_tempb(t683-
     .       1      1,1,1))*d1                                                  
     .        enddo                                                             
   795  
   796  
   797      xyr_DPressDt(:,:,kmax) = 0.0_DP
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t698 = 1, xyr_dpressdt.DSC.U2*xyr_dpressdt.DSC.U1 +            
     .       1   xyr_dpressdt.DSC.U2                                            
     .           xyr_dpressdt(t698-1,1,kmax) = 0.0000000000000000e+000          
     .        enddo                                                             
   798      do k = kmax, 1, -1
   799        xy_DSurfMajCompIceDtOneLayer =                                 &
     .        d3 = 1.D0/grav                                                    
     .        d4 = d3/latentheatmajcompsubl                                     
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xyr_press,xy_dsurfmajcompicedtonelayer)                    
     .        do t704 = 1, xyz_dtempdt.DSC.U2*xyz_dtempdt.DSC.U1 +              
     .       1   xyz_dtempdt.DSC.U2                                             
     .           xy_dsurfmajcompicedtonelayer1 = cpdry*xyz_dtempdt(t704-1,1,k)*(
     .       1      xyr_press(t704-1,1,k-1)-xyr_press(t704-1,1,k))*d4           
     .           xyr_dpressdt(t704-1,1,k-1) = xyr_dpressdt(t704-1,1,k) -        
     .       1      xy_dsurfmajcompicedtonelayer1*grav                          
     .        enddo                                                             
   800          &   CpDry * xyz_DTempDt(:,:,k)                               &
   801          &   * ( xyr_Press(:,:,k-1) - xyr_Press(:,:,k) ) / Grav       &
   802          &   / LatentHeatMajCompSubl
   803        xyr_DPressDt(:,:,k-1) = xyr_DPressDt(:,:,k) &
   804          & - xy_DSurfMajCompIceDtOneLayer * Grav
   805      end do
   806  
   807      xy_DPsDt             = xyr_DPressDt(:,:,0)
     .        d5 = 1.D0/grav                                                    
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t722 = 1, xy_dpsdt.DSC.U2*xy_dpsdt.DSC.U1 + xy_dpsdt.DSC.U2    
     .           xy_dpsdt(t722-1,1) = xyr_dpressdt(t722-1,1,0)                  
     .           xy_dsurfmajcompicedt(t722-1,1) = -xy_dpsdt(t722-1,1)*d5        
     .        enddo                                                             
   808      xy_DSurfMajCompIceDt = - xy_DPsDt / Grav
   809  
   810  
   811  
   812      ! packing
   813      mmax = ncmax
   814      do m = 1, mmax
   815        n = m
   816        xyza_Array(:,:,:,m) = xyzf_QMix(:,:,:,n)
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t734 = 1, xyza_array.DSC.U3*(xyza_array.DSC.U2*                
     .       1   xyza_array.DSC.U1 + xyza_array.DSC.U2)                         
     .           xyza_array(t734-1,1,1,m) = xyzf_qmix(t734-1,1,1,n)             
     .        enddo                                                             
   817        if ( n == IndexTKE ) then
   818          a_FlagSurfaceSink(m) = .true.
   819        else
   820          a_FlagSurfaceSink(m) = .false.
   821        end if
   822      end do
   823  
   824      call MajorCompPhaseChangeCalcFlow( &
   825        & xyr_Press, xyr_DPressDt,               & ! (in)
   826        & mmax, a_FlagSurfaceSink, xyza_Array,   & ! (in)
   827        & xyra_MassFlow                          & ! (out)
   828        & )
   829  
   830      ! unpacking
   831      do m = 1, mmax
   832        xyrf_MassFlow(:,:,:,m) = xyra_MassFlow(:,:,:,m)
   833      end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do m = 1, mmax*(xyrf_massflow.DSC.U3 + 1)*xyrf_massflow.DSC.U2*(  
     .       1   xyrf_massflow.DSC.U1 + 1)                                      
     .           xyrf_massflow(m-1,1,0,1) = xyra_massflow(m-1,1,0,1)            
     .        enddo                                                             
   834  
   835  
   836      ! Adjustment
   837      !   preparation
   838      xy_PsB = xy_Ps
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t758 = 1, xy_psb.DSC.U2*xy_psb.DSC.U1 + xy_psb.DSC.U2          
     .           xy_psb(t758-1,1) = xy_ps(t758-1,1)                             
     .           xy_psa(t758-1,1) = xy_psb(t758-1,1) + xy_dpsdt(t758-1,1)*      
     .       1      2.00000000000000e+000*deltime                               
     .        enddo                                                             
   839      xy_PsA = xy_PsB + xy_DPsDt * ( 2.0_DP * DelTime )
   840  
   841      ! 温度の半整数σレベルの補間, 気圧と高度の算出
   842      ! Interpolate temperature on half sigma level,
   843      ! and calculate pressure and height
   844      !
   845      xyz_TempTmp    = 300.0_DP
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t772 = 1, xyz_temptmp.DSC.U3*(xyz_temptmp.DSC.U2*              
     .       1   xyz_temptmp.DSC.U1 + xyz_temptmp.DSC.U2)                       
     .           xyz_temptmp(t772-1,1,1) = 3.00000000000000e+002                
     .           xyz_qh2ovaptmp(t772-1,1,1) = 0.0000000000000000e+000           
     .        enddo                                                             
   846      xyz_QH2OVapTmp =   0.0_DP
   847      call AuxVars( &
   848        & xy_PsB, xyz_TempTmp, xyz_QH2OVapTmp,    & ! (in )
   849        & xyr_Press = xyr_PressB                  & ! (out) optional
   850        & )
   851      call AuxVars( &
   852        & xy_PsA, xyz_TempTmp, xyz_QH2OVapTmp,    & ! (in )
   853        & xyr_Press = xyr_PressA                  & ! (out) optional
   854        & )
   855      do k = 1, kmax
   856        xyz_DelAtmMassB(:,:,k) = ( xyr_PressB(:,:,k-1) - xyr_PressB(:,:,k) ) / Grav
   857        xyz_DelAtmMassA(:,:,k) = ( xyr_PressA(:,:,k-1) - xyr_PressA(:,:,k) ) / Grav
   858      end do
     .        d6 = 1.D0/grav                                                    
     .        d7 = 1.D0/grav                                                    
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do k = 1, kmax*(xyr_pressb.DSC.U2*xyr_pressb.DSC.U1 +             
     .       1   xyr_pressb.DSC.U2)                                             
     .           xyz_delatmmassb(k-1,1,1) = (xyr_pressb(k-1,1,0)-xyr_pressb(k-1,
     .       1      1,1))*d6                                                    
     .           xyz_delatmmassa(k-1,1,1) = (xyr_pressa(k-1,1,0)-xyr_pressa(k-1,
     .       1      1,1))*d7                                                    
     .        enddo                                                             
   859      !   Atmospheric composition
   860      do n = 1, ncmax
   861        do k = 1, kmax
   862          xyzf_QMix(:,:,k,n) =                                              &
   863            &   (   xyz_DelAtmMassB(:,:,k) * xyzf_QMix(:,:,k,n)             &
   864            &     - ( xyrf_MassFlow(:,:,k,n) - xyrf_MassFlow(:,:,k-1,n) ) ) &
   865            & / xyz_DelAtmMassA(:,:,k)
   866        end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xyz_delatmmassb,xyz_delatmmassa)                           
     .        do k = 1, kmax*(xyz_delatmmassb.DSC.U2*xyz_delatmmassb.DSC.U1 +   
     .       1   xyz_delatmmassb.DSC.U2)                                        
     .           xyzf_qmix(k-1,1,1,n) = (xyz_delatmmassb(k-1,1,1)*xyzf_qmix(k-1,
     .       1      1,1,n)-(xyrf_massflow(k-1,1,1,n)-xyrf_massflow(k-1,1,0,n)))/
     .       2      xyz_delatmmassa(k-1,1,1)                                    
     .        enddo                                                             
   867      end do
   868  
   869  
   870      ! Surface major component ice adjustment
   871      xy_SurfMajCompIce = xy_SurfMajCompIce + xy_DSurfMajCompIceDt * ( 2.0_DP * DelTime )
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t816 = 1, jmax*imax                                            
     .           xy_surfmajcompice(t816-1,1) = xy_surfmajcompice(t816-1,1) +    
     .       1      xy_dsurfmajcompicedt(t816-1,1)*2.00000000000000e+000*deltime
     .           xy_ps(t816-1,1) = xy_psa(t816-1,1)                             
     .        enddo                                                             
   872      ! Surface pressure adjustment
   873      xy_Ps = xy_PsA
   874  
   875  
   876      call AuxVars( &
   877        & xy_PsA, xyz_TempTmp, xyz_QH2OVapTmp,    & ! (in )
   878        & xyr_Press = xyr_PressA                  & ! (out) optional
   879        & )
   880      ! 成分の質量の補正
   881      ! Fix masses of constituents
   882      !
   883      call MassFixerColumn( &
   884        & xyr_PressA, & ! (in)
   885        & xyzf_QMix   & ! (inout)
   886        & )
   887  
   888      ! Check
   889      call MajorCompPhaseChangeConsChk( &
   890        & a_FlagSurfaceSink,            & ! (in)
   891        & xyz_DelAtmMassB, xyzf_QMixB,  & ! (in)
   892        & xyz_DelAtmMassA, xyzf_QMix    & ! (in)
   893        & )
   894  
   895      ! ヒストリデータ出力
   896      ! History data output
   897      !
   898      call HistoryAutoPut( TimeN, 'DTempDtMajCompPhaseChange', xyz_DTempDt )
   899  
   900  
   901      ! 計算時間計測一時停止
   902      ! Pause measurement of computation time
   903      !
   904      call TimesetClockStop( module_name )
   905  
   906    end subroutine MajorCompPhaseChangeInAtmBK2
   907  
   908    !--------------------------------------------------------------------------------------
   909  
   910    subroutine MajorCompPhaseChangeInAtm(              &
   911      & xyr_Press, xyz_Press,                          & ! (in)
   912      & xy_Ps, xyz_Temp, xyzf_QMix, xyz_U, xyz_V,      & ! (inout)
   913      & xy_SurfMajCompIce                              & ! (inout)
   914      & )
   915      !
   916      ! CO2 相変化
   917      !
   918      ! CO2 phase change
   919      !
   920  
   921      ! モジュール引用 ; USE statements
   922      !
   923  
   924      ! 時刻管理
   925      ! Time control
   926      !
   927      use timeset, only: &
   928        & DelTime, &            ! $ \Delta t $
   929        & TimeN, &              ! ステップ $ t $ の時刻. Time of step $ t $.
   930        & TimesetClockStart, TimesetClockStop
   931  
   932      ! ヒストリデータ出力
   933      ! History data output
   934      !
   935      use gtool_historyauto, only: HistoryAutoPut
   936  
   937      ! 組成に関わる配列の設定
   938      ! Settings of array for atmospheric composition
   939      !
   940      use composition, only : &
   941        & ncmax, &
   942        & IndexTKE
   943  
   944      ! 物理定数設定
   945      ! Physical constants settings
   946      !
   947      use constants, only: &
   948        & Grav, &               ! $ g $ [m s-2].
   949                                ! 重力加速度.
   950                                ! Gravitational acceleration
   951        & CpDry
   952                                ! $ C_p $ [J kg-1 K-1].
   953                                ! 乾燥大気の定圧比熱.
   954                                ! Specific heat of air at constant pressure
   955  
   956      ! 温度の半整数σレベルの補間, 気圧と高度の算出
   957      ! Interpolate temperature on half sigma level,
   958      ! and calculate pressure and height
   959      !
   960      use auxiliary, only: AuxVars
   961  
   962      ! 主成分相変化
   963      ! Phase change of atmospheric major component
   964      !
   965      use saturate_major_comp, only :    &
   966        & SaturateMajorCompCondTemp,     &
   967        & SaturateMajorCompInqLatentHeat
   968  
   969      ! 質量の補正
   970      ! Mass fixer
   971      !
   972      use mass_fixer, only: MassFixerColumn
   973  
   974      ! 宣言文 ; Declaration statements
   975      !
   976      implicit none
   977  
   978      real(DP), intent(in   ):: xyr_Press (0:imax-1, 1:jmax, 0:kmax)
   979                                ! $ \hat{p} $ . 気圧 (半整数レベル).
   980                                ! Air pressure (half level)
   981      real(DP), intent(in   ):: xyz_Press (0:imax-1, 1:jmax, 1:kmax)
   982                                ! $ p $ . 気圧 (整数レベル).
   983                                ! Air pressure (full level)
   984      real(DP), intent(inout):: xy_Ps            (0:imax-1, 1:jmax)
   985                                ! $ T $ .     温度. Temperature
   986      real(DP), intent(inout):: xyz_Temp         (0:imax-1, 1:jmax, 1:kmax)
   987                                ! $ T $ .     温度. Temperature
   988      real(DP), intent(inout):: xyzf_QMix        (0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
   989      real(DP), intent(inout):: xyz_U            (0:imax-1, 1:jmax, 1:kmax)
   990      real(DP), intent(inout):: xyz_V            (0:imax-1, 1:jmax, 1:kmax)
   991      real(DP), intent(inout):: xy_SurfMajCompIce(0:imax-1, 1:jmax)
   992                                !
   993                                ! Surface major component ice amount
   994  
   995      ! 作業変数
   996      ! Work variables
   997      !
   998      real(DP):: LatentHeatMajCompSubl
   999  
  1000      real(DP):: xy_PsB              (0:imax-1, 1:jmax)
  1001      real(DP):: xy_PsA              (0:imax-1, 1:jmax)
  1002      real(DP):: xyr_PressB          (0:imax-1, 1:jmax, 0:kmax)
  1003      real(DP):: xyr_PressA          (0:imax-1, 1:jmax, 0:kmax)
  1004  
  1005      real(DP):: xyz_TempB           (0:imax-1, 1:jmax, 1:kmax)
  1006                                ! 調節前の温度.
  1007                                ! Temperature before adjustment
  1008      real(DP):: xyzf_QMixB          (0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
  1009  
  1010      real(DP):: xyz_DelAtmMass      (0:imax-1, 1:jmax, 1:kmax)
  1011      real(DP):: xy_TempTmp          (0:imax-1, 1:jmax)
  1012      real(DP):: xy_DTempDtSubl      (0:imax-1, 1:jmax)
  1013      real(DP):: xy_DTempDtCond      (0:imax-1, 1:jmax)
  1014      real(DP):: xyr_AtmMassFallFlux (0:imax-1, 1:jmax, 0:kmax)
  1015  
  1016      real(DP):: xyz_TempTmp         (0:imax-1, 1:jmax, 1:kmax)
  1017      real(DP):: xyz_QH2OVapTmp      (0:imax-1, 1:jmax, 1:kmax)
  1018  
  1019      real(DP):: xyz_DTempDt         (0:imax-1, 1:jmax, 1:kmax)
  1020                                ! 温度変化率.
  1021                                ! Temperature tendency
  1022      real(DP):: xy_DSurfMajCompIceDt(0:imax-1, 1:jmax)
  1023                                !
  1024                                ! Surface major component ice tendency
  1025      real(DP):: xy_DPsDt            (0:imax-1, 1:jmax)
  1026  
  1027      real(DP):: xy_DSurfMajCompIceDtOneLayer(0:imax-1, 1:jmax)
  1028      real(DP):: xyr_DPressDt                (0:imax-1, 1:jmax, 0:kmax)
  1029  
  1030      real(DP):: xyz_TempCond   (0:imax-1, 1:jmax, 1:kmax)
  1031  
  1032      integer :: mmax
  1033      real(DP):: xyza_Array       (0:imax-1, 1:jmax, 1:kmax, 1:ncmax+1+1)
  1034      logical :: a_FlagSurfaceSink                          (1:ncmax+1+1)
  1035      real(DP):: xyra_MassFlow    (0:imax-1, 1:jmax, 0:kmax, 1:ncmax+1+1)
  1036  
  1037      real(DP):: xyrf_MassFlow    (0:imax-1, 1:jmax, 0:kmax, 1:ncmax)
  1038      real(DP):: xyr_MomXFlow     (0:imax-1, 1:jmax, 0:kmax)
  1039      real(DP):: xyr_MomYFlow     (0:imax-1, 1:jmax, 0:kmax)
  1040  
  1041      real(DP):: xyz_DelAtmMassB   (0:imax-1, 1:jmax, 1:kmax)
  1042      real(DP):: xyz_DelAtmMassA   (0:imax-1, 1:jmax, 1:kmax)
  1043  
  1044      integer:: i               ! 経度方向に回る DO ループ用作業変数
  1045                                ! Work variables for DO loop in longitude
  1046      integer:: j               ! 緯度方向に回る DO ループ用作業変数
  1047                                ! Work variables for DO loop in latitude
  1048      integer:: k               ! 鉛直方向に回る DO ループ用作業変数
  1049                                ! Work variables for DO loop in vertical direction
  1050      integer:: m
  1051      integer:: n
  1052  
  1053      logical :: FlagCheckPs
  1054  
  1055  
  1056      ! 実行文 ; Executable statement
  1057      !
  1058  
  1059      ! 初期化
  1060      ! Initialization
  1061      !
  1062      if ( .not. major_comp_phase_change_inited ) then
  1063        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
  1064      end if
  1065  
  1066  
  1067      if ( .not. FlagMajCompPhaseChange ) return
  1068  
  1069  
  1070      ! 計算時間計測開始
  1071      ! Start measurement of computation time
  1072      !
  1073      call TimesetClockStart( module_name )
  1074  
  1075  
  1076      ! Set latent heat
  1077      LatentHeatMajCompSubl = SaturateMajorCompInqLatentHeat()
  1078  
  1079  
  1080      FlagCheckPs = .false.
  1081      do j = 1, jmax
  1082        do i = 0, imax-1
  1083          if ( xyr_Press(i,j,0) > 1.0e4_DP ) then
  1084            FlagCheckPs = .true.
  1085          end if
  1086        end do
  1087      end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do j = 1, jmax*imax                                               
     .           if (xyr_press(j-1,1,0) .gt. 1.00000000000000e+004) then        
     .              flagcheckps = 1                                             
     .           endif                                                          
     .        enddo                                                             
  1088      if ( FlagCheckPs ) then
  1089        call MessageNotify( 'W', module_name, 'Surface pressure is greater than 10000 Pa.' )
  1090      end if
  1091  
  1092  
  1093      ! Store variables
  1094      !
  1095      xyz_TempB  = xyz_Temp
  1096      xyzf_QMixB = xyzf_QMix
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t860 = 1, xyzf_qmixb.DSC.U4*xyzf_qmixb.DSC.U3*xyzf_qmixb.DSC.U2
     .       1   *(xyzf_qmixb.DSC.U1 + 1)                                       
     .           xyzf_qmixb(t860-1,1,1,1) = xyzf_qmix(t860-1,1,1,1)             
     .        enddo                                                             
  1097  
  1098  
  1099      call SaturateMajorCompCondTemp( &
  1100        & xyz_Press,                  & ! (in)
  1101        & xyz_TempCond                & ! (inout)
  1102        & )
  1103  
  1104  
  1105      do k = 1, kmax
  1106        xyz_DelAtmMass(:,:,k) = ( xyr_Press(:,:,k-1) - xyr_Press(:,:,k) ) / Grav
  1107      end do
     .        d1 = 1.D0/grav                                                    
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do k = 1, kmax*jmax*imax                                          
     .           xyz_delatmmass(k-1,1,1) = (xyr_press(k-1,1,0)-xyr_press(k-1,1,1
     .       1      ))*d1                                                       
     .        enddo                                                             
  1108  
  1109      xyr_AtmMassFallFlux(:,:,kmax) = 0.0_DP
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t886 = 1, xyr_atmmassfallflux.DSC.U2*xyr_atmmassfallflux.DSC.U1
     .       1    + xyr_atmmassfallflux.DSC.U2                                  
     .           xyr_atmmassfallflux(t886-1,1,kmax) = 0.0000000000000000e+000   
     .        enddo                                                             
  1110      do k = kmax, 1, -1
  1111        ! sublimation of falling condensate
  1112  !!$      xy_DTempDtSubl = &
  1113  !!$        & - LatentHeatMajCompSubl * xyr_AtmMassFallFlux(:,:,k) &
  1114  !!$        &   / ( CpDry * xyz_DelAtmMass(:,:,k) )
  1115  !!$      xyz_Temp(:,:,k) = xyz_Temp(:,:,k) + xy_DTempDtSubl * ( 2.0_DP * DelTime )
  1116  !!$      xyr_AtmMassFallFlux(:,:,k) = 0.0_DP
  1117  
  1118        ! condensation
  1119        xy_TempTmp = xyz_Temp(:,:,k)
     .        d5 = 1.D0/(2.00000000000000e+000*deltime)                         
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xy_temptmp,xy_dtempdtcond,xy_dsurfmajcompicedtonelayer,xyr_
     .       1   atmmassfallflux)                                               
     .        do t892 = 1, xy_temptmp.DSC.U2*xy_temptmp.DSC.U1 +                
     .       1   xy_temptmp.DSC.U2                                              
     .           xy_temptmp1 = xyz_temp(t892-1,1,k)                             
     .           xyz_temp(t892-1,1,k) = max(xyz_tempcond(t892-1,1,k),xyz_temp(  
     .       1      t892-1,1,k))                                                
     .           xy_dtempdtcond1 = (xyz_temp(t892-1,1,k)-xy_temptmp1)*d5        
     .           d6 = xy_dtempdtcond1/latentheatmajcompsubl                     
     .           xy_dsurfmajcompicedtonelayer1 = cpdry*xyz_delatmmass(t892-1,1,k
     .       1      )*d6                                                        
     .           xyr_atmmassfallflux(t892-1,1,k-1) = xyr_atmmassfallflux(t892-1,
     .       1      1,k) + xy_dsurfmajcompicedtonelayer1                        
     .        enddo                                                             
  1120        xyz_Temp(:,:,k) = max( xyz_TempCond(:,:,k), xyz_Temp(:,:,k) )
  1121        xy_DTempDtCond = ( xyz_Temp(:,:,k) - xy_TempTmp ) / ( 2.0_DP * DelTime )
  1122        xy_DSurfMajCompIceDtOneLayer =                           &
  1123          &   CpDry * xyz_DelAtmMass(:,:,k) * xy_DTempDtCond     &
  1124          &   / LatentHeatMajCompSubl
  1125        xyr_AtmMassFallFlux(:,:,k-1) = xyr_AtmMassFallFlux(:,:,k) &
  1126          & + xy_DSurfMajCompIceDtOneLayer
  1127      end do
  1128  
  1129      xyr_DPressDt = - xyr_AtmMassFallFlux * Grav
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xyr_atmmassfallflux)                                       
     .        do t924 = 1, (xyr_atmmassfallflux.DSC.U3 + 1)*                    
     .       1   xyr_atmmassfallflux.DSC.U2*(xyr_atmmassfallflux.DSC.U1 + 1)    
     .           xyr_dpressdt(t924-1,1,0) = -xyr_atmmassfallflux(t924-1,1,0)*   
     .       1      grav                                                        
     .        enddo                                                             
  1130  
  1131  
  1132      xy_DPsDt             = xyr_DPressDt(:,:,0)
     .        d7 = 1.D0/grav                                                    
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t936 = 1, xy_dpsdt.DSC.U2*xy_dpsdt.DSC.U1 + xy_dpsdt.DSC.U2    
     .           xy_dpsdt(t936-1,1) = xyr_dpressdt(t936-1,1,0)                  
     .           xy_dsurfmajcompicedt(t936-1,1) = -xy_dpsdt(t936-1,1)*d7        
     .        enddo                                                             
  1133      xy_DSurfMajCompIceDt = - xy_DPsDt / Grav
  1134  
  1135  
  1136  
  1137      ! packing
  1138      if ( FlagModMom ) then
  1139        mmax = ncmax + 1 + 1
  1140      else
  1141        mmax = ncmax
  1142      end if
  1143      do m = 1, ncmax
  1144        n = m
  1145        xyza_Array(:,:,:,m) = xyzf_QMix(:,:,:,n)
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t948 = 1, xyza_array.DSC.U3*(xyza_array.DSC.U2*                
     .       1   xyza_array.DSC.U1 + xyza_array.DSC.U2)                         
     .           xyza_array(t948-1,1,1,m) = xyzf_qmix(t948-1,1,1,n)             
     .        enddo                                                             
  1146        if ( n == IndexTKE ) then
  1147          a_FlagSurfaceSink(m) = .true.
  1148        else
  1149          a_FlagSurfaceSink(m) = .false.
  1150        end if
  1151      end do
  1152      if ( FlagModMom ) then
  1153        m = ncmax
  1154        m = m + 1
  1155        xyza_Array(:,:,:,m) = xyz_U
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1096 = 1, xyza_array.DSC.U3*(xyza_array.DSC.U2*               
     .       1   xyza_array.DSC.U1 + xyza_array.DSC.U2)                         
     .           xyza_array(t1096-1,1,1,m) = xyz_u(t1096-1,1,1)                 
     .        enddo                                                             
  1156        a_FlagSurfaceSink(m) = .true.
  1157        m = m + 1
  1158        xyza_Array(:,:,:,m) = xyz_V
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1108 = 1, xyza_array.DSC.U3*(xyza_array.DSC.U2*               
     .       1   xyza_array.DSC.U1 + xyza_array.DSC.U2)                         
     .           xyza_array(t1108-1,1,1,m) = xyz_v(t1108-1,1,1)                 
     .        enddo                                                             
  1159        a_FlagSurfaceSink(m) = .true.
  1160      end if
  1161  
  1162      call MajorCompPhaseChangeCalcFlow( &
  1163        & xyr_Press, xyr_DPressDt,                                     & ! (in)
  1164        & mmax, a_FlagSurfaceSink(1:mmax), xyza_Array(:,:,:,1:mmax),   & ! (in)
  1165        & xyra_MassFlow(:,:,:,1:mmax)                                  & ! (out)
  1166        & )
  1167  
  1168      ! unpacking
  1169      do m = 1, ncmax
  1170        xyrf_MassFlow(:,:,:,m) = xyra_MassFlow(:,:,:,m)
  1171      end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do m = 1, ncmax*(xyrf_massflow.DSC.U3 + 1)*xyrf_massflow.DSC.U2*( 
     .       1   xyrf_massflow.DSC.U1 + 1)                                      
     .           xyrf_massflow(m-1,1,0,1) = xyra_massflow(m-1,1,0,1)            
     .        enddo                                                             
  1172      if ( FlagModMom ) then
  1173        m = ncmax
  1174        m = m + 1
  1175        xyr_MomXFlow = xyra_MassFlow(:,:,:,m)
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1072 = 1, (xyr_momxflow.DSC.U3 + 1)*xyr_momxflow.DSC.U2*(     
     .       1   xyr_momxflow.DSC.U1 + 1)                                       
     .           xyr_momxflow(t1072-1,1,0) = xyra_massflow(t1072-1,1,0,m)       
     .        enddo                                                             
  1176        m = m + 1
  1177        xyr_MomYFlow = xyra_MassFlow(:,:,:,m)
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1084 = 1, (xyr_momyflow.DSC.U3 + 1)*xyr_momyflow.DSC.U2*(     
     .       1   xyr_momyflow.DSC.U1 + 1)                                       
     .           xyr_momyflow(t1084-1,1,0) = xyra_massflow(t1084-1,1,0,m)       
     .        enddo                                                             
  1178      end if
  1179  
  1180  
  1181      ! Adjustment
  1182      !   preparation
  1183      xy_PsB = xy_Ps
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t972 = 1, xy_psb.DSC.U2*xy_psb.DSC.U1 + xy_psb.DSC.U2          
     .           xy_psb(t972-1,1) = xy_ps(t972-1,1)                             
     .           xy_psa(t972-1,1) = xy_psb(t972-1,1) + xy_dpsdt(t972-1,1)*      
     .       1      2.00000000000000e+000*deltime                               
     .        enddo                                                             
  1184      xy_PsA = xy_PsB + xy_DPsDt * ( 2.0_DP * DelTime )
  1185  
  1186      ! 温度の半整数σレベルの補間, 気圧と高度の算出
  1187      ! Interpolate temperature on half sigma level,
  1188      ! and calculate pressure and height
  1189      !
  1190      xyz_TempTmp    = 300.0_DP
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t986 = 1, xyz_temptmp.DSC.U3*(xyz_temptmp.DSC.U2*              
     .       1   xyz_temptmp.DSC.U1 + xyz_temptmp.DSC.U2)                       
     .           xyz_temptmp(t986-1,1,1) = 3.00000000000000e+002                
     .           xyz_qh2ovaptmp(t986-1,1,1) = 0.0000000000000000e+000           
     .        enddo                                                             
  1191      xyz_QH2OVapTmp =   0.0_DP
  1192      call AuxVars( &
  1193        & xy_PsB, xyz_TempTmp, xyz_QH2OVapTmp,    & ! (in )
  1194        & xyr_Press = xyr_PressB                  & ! (out) optional
  1195        & )
  1196      call AuxVars( &
  1197        & xy_PsA, xyz_TempTmp, xyz_QH2OVapTmp,    & ! (in )
  1198        & xyr_Press = xyr_PressA                  & ! (out) optional
  1199        & )
  1200      do k = 1, kmax
  1201        xyz_DelAtmMassB(:,:,k) = ( xyr_PressB(:,:,k-1) - xyr_PressB(:,:,k) ) / Grav
  1202        xyz_DelAtmMassA(:,:,k) = ( xyr_PressA(:,:,k-1) - xyr_PressA(:,:,k) ) / Grav
  1203      end do
     .        d8 = 1.D0/grav                                                    
     .        d9 = 1.D0/grav                                                    
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do k = 1, kmax*(xyr_pressb.DSC.U2*xyr_pressb.DSC.U1 +             
     .       1   xyr_pressb.DSC.U2)                                             
     .           xyz_delatmmassb(k-1,1,1) = (xyr_pressb(k-1,1,0)-xyr_pressb(k-1,
     .       1      1,1))*d8                                                    
     .           xyz_delatmmassa(k-1,1,1) = (xyr_pressa(k-1,1,0)-xyr_pressa(k-1,
     .       1      1,1))*d9                                                    
     .        enddo                                                             
  1204      !   Atmospheric composition
  1205      do n = 1, ncmax
  1206        do k = 1, kmax
  1207          xyzf_QMix(:,:,k,n) =                                              &
  1208            &   (   xyz_DelAtmMassB(:,:,k) * xyzf_QMix(:,:,k,n)             &
  1209            &     - ( xyrf_MassFlow(:,:,k,n) - xyrf_MassFlow(:,:,k-1,n) ) ) &
  1210            & / xyz_DelAtmMassA(:,:,k)
  1211        end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xyz_delatmmassb,xyz_delatmmassa)                           
     .        do k = 1, kmax*(xyz_delatmmassb.DSC.U2*xyz_delatmmassb.DSC.U1 +   
     .       1   xyz_delatmmassb.DSC.U2)                                        
     .           xyzf_qmix(k-1,1,1,n) = (xyz_delatmmassb(k-1,1,1)*xyzf_qmix(k-1,
     .       1      1,1,n)-(xyrf_massflow(k-1,1,1,n)-xyrf_massflow(k-1,1,0,n)))/
     .       2      xyz_delatmmassa(k-1,1,1)                                    
     .        enddo                                                             
  1212      end do
  1213      if ( FlagModMom ) then
  1214        do k = 1, kmax
  1215          ! Zonal wind
  1216          xyz_U(:,:,k) =                                              &
  1217            &   (   xyz_DelAtmMassB(:,:,k) * xyz_U(:,:,k)             &
  1218            &     - ( xyr_MomXFlow(:,:,k) - xyr_MomXFlow(:,:,k-1) ) ) &
  1219            & / xyz_DelAtmMassA(:,:,k)
  1220          ! Meridional wind
  1221          xyz_V(:,:,k) =                                              &
  1222            &   (   xyz_DelAtmMassB(:,:,k) * xyz_V(:,:,k)             &
  1223            &     - ( xyr_MomYFlow(:,:,k) - xyr_MomYFlow(:,:,k-1) ) ) &
  1224            & / xyz_DelAtmMassA(:,:,k)
  1225        end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xyz_delatmmassb,xyz_delatmmassa)                           
     .        do k = 1, kmax*(xyz_delatmmassb.DSC.U2*xyz_delatmmassb.DSC.U1 +   
     .       1   xyz_delatmmassb.DSC.U2)                                        
     .           xyz_u(k-1,1,1) = (xyz_delatmmassb(k-1,1,1)*xyz_u(k-1,1,1)-(    
     .       1      xyr_momxflow(k-1,1,1)-xyr_momxflow(k-1,1,0)))/              
     .       2      xyz_delatmmassa(k-1,1,1)                                    
     .           xyz_v(k-1,1,1) = (xyz_delatmmassb(k-1,1,1)*xyz_v(k-1,1,1)-(    
     .       1      xyr_momyflow(k-1,1,1)-xyr_momyflow(k-1,1,0)))/              
     .       2      xyz_delatmmassa(k-1,1,1)                                    
     .        enddo                                                             
  1226      end if
  1227  
  1228  
  1229      ! Surface major component ice adjustment
  1230      xy_SurfMajCompIce = xy_SurfMajCompIce + xy_DSurfMajCompIceDt * ( 2.0_DP * DelTime )
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t1030 = 1, jmax*imax                                           
     .           xy_surfmajcompice(t1030-1,1) = xy_surfmajcompice(t1030-1,1) +  
     .       1      xy_dsurfmajcompicedt(t1030-1,1)*2.00000000000000e+000*      
     .       2      deltime                                                     
     .           xy_ps(t1030-1,1) = xy_psa(t1030-1,1)                           
     .        enddo                                                             
  1231      ! Surface pressure adjustment
  1232      xy_Ps = xy_PsA
  1233  
  1234  
  1235      call AuxVars( &
  1236        & xy_PsA, xyz_TempTmp, xyz_QH2OVapTmp,    & ! (in )
  1237        & xyr_Press = xyr_PressA                  & ! (out) optional
  1238        & )
  1239      ! 成分の質量の補正
  1240      ! Fix masses of constituents
  1241      !
  1242      call MassFixerColumn( &
  1243        & xyr_PressA, & ! (in)
  1244        & xyzf_QMix   & ! (inout)
  1245        & )
  1246  
  1247      ! Check
  1248      call MajorCompPhaseChangeConsChk( &
  1249        & a_FlagSurfaceSink,            & ! (in)
  1250        & xyz_DelAtmMassB, xyzf_QMixB,  & ! (in)
  1251        & xyz_DelAtmMassA, xyzf_QMix    & ! (in)
  1252        & )
  1253  
  1254      ! ヒストリデータ出力
  1255      ! History data output
  1256      !
  1257      call HistoryAutoPut( TimeN, 'DTempDtMajCompPhaseChange', xyz_DTempDt )
  1258  
  1259  
  1260      ! 計算時間計測一時停止
  1261      ! Pause measurement of computation time
  1262      !
  1263      call TimesetClockStop( module_name )
  1264  
  1265    end subroutine MajorCompPhaseChangeInAtm
  1266  
  1267    !--------------------------------------------------------------------------------------
  1268  
  1269    subroutine MajorCompPhaseChangeOnGround( &
  1270      & xy_DPsDt, xy_DSurfMajCompIceDt,      & ! (in)
  1271      & xy_Ps, xyzf_QMix, xyz_U, xyz_V,      & ! (inout)
  1272      & xy_SurfMajCompIce                    & ! (inout)
  1273      & )
  1274      !
  1275      ! CO2 相変化
  1276      !
  1277      ! CO2 phase change
  1278      !
  1279  
  1280      ! モジュール引用 ; USE statements
  1281      !
  1282  
  1283      ! 時刻管理
  1284      ! Time control
  1285      !
  1286      use timeset, only: &
  1287        & DelTime, &            ! $ \Delta t $
  1288        & TimeN, &              ! ステップ $ t $ の時刻. Time of step $ t $.
  1289        & TimesetClockStart, TimesetClockStop
  1290  
  1291      ! ヒストリデータ出力
  1292      ! History data output
  1293      !
  1294      use gtool_historyauto, only: HistoryAutoPut
  1295  
  1296      ! 組成に関わる配列の設定
  1297      ! Settings of array for atmospheric composition
  1298      !
  1299      use composition, only : &
  1300        & ncmax, &
  1301        & IndexTKE
  1302  
  1303      ! 物理定数設定
  1304      ! Physical constants settings
  1305      !
  1306      use constants, only: &
  1307        & Grav, &               ! $ g $ [m s-2].
  1308                                ! 重力加速度.
  1309                                ! Gravitational acceleration
  1310        & CpDry
  1311                                ! $ C_p $ [J kg-1 K-1].
  1312                                ! 乾燥大気の定圧比熱.
  1313                                ! Specific heat of air at constant pressure
  1314  
  1315      ! 温度の半整数σレベルの補間, 気圧と高度の算出
  1316      ! Interpolate temperature on half sigma level,
  1317      ! and calculate pressure and height
  1318      !
  1319      use auxiliary, only: AuxVars
  1320  
  1321      ! 質量の補正
  1322      ! Mass fixer
  1323      !
  1324      use mass_fixer, only: MassFixerColumn
  1325  
  1326  
  1327      ! 宣言文 ; Declaration statements
  1328      !
  1329      implicit none
  1330  
  1331      real(DP), intent(in   ):: xy_DPsDt            (0:imax-1, 1:jmax)
  1332      real(DP), intent(in   ):: xy_DSurfMajCompIceDt(0:imax-1, 1:jmax)
  1333      real(DP), intent(inout):: xy_Ps            (0:imax-1, 1:jmax)
  1334      real(DP), intent(inout):: xyzf_QMix        (0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
  1335      real(DP), intent(inout):: xyz_U            (0:imax-1, 1:jmax, 1:kmax)
  1336      real(DP), intent(inout):: xyz_V            (0:imax-1, 1:jmax, 1:kmax)
  1337      real(DP), intent(inout):: xy_SurfMajCompIce   (0:imax-1, 1:jmax)
  1338                                !
  1339                                ! Surface major component ice amount
  1340  
  1341      ! 作業変数
  1342      ! Work variables
  1343      !
  1344      real(DP):: xy_PsB              (0:imax-1, 1:jmax)
  1345      real(DP):: xy_PsA              (0:imax-1, 1:jmax)
  1346      real(DP):: xyr_PressB          (0:imax-1, 1:jmax, 0:kmax)
  1347      real(DP):: xyr_PressA          (0:imax-1, 1:jmax, 0:kmax)
  1348  
  1349      real(DP):: xyzf_QMixB          (0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
  1350  
  1351      real(DP):: xyz_TempTmp         (0:imax-1, 1:jmax, 1:kmax)
  1352      real(DP):: xyz_QH2OVapTmp      (0:imax-1, 1:jmax, 1:kmax)
  1353  
  1354      real(DP):: xyr_DPressDt        (0:imax-1, 1:jmax, 0:kmax)
  1355  
  1356      integer :: mmax
  1357      real(DP):: xyza_Array       (0:imax-1, 1:jmax, 1:kmax, 1:ncmax+1+1)
  1358      logical :: a_FlagSurfaceSink                          (1:ncmax+1+1)
  1359      real(DP):: xyra_MassFlow    (0:imax-1, 1:jmax, 0:kmax, 1:ncmax+1+1)
  1360  
  1361      real(DP):: xyrf_MassFlow    (0:imax-1, 1:jmax, 0:kmax, 1:ncmax)
  1362      real(DP):: xyr_MomXFlow     (0:imax-1, 1:jmax, 0:kmax)
  1363      real(DP):: xyr_MomYFlow     (0:imax-1, 1:jmax, 0:kmax)
  1364  
  1365      real(DP):: xyz_DelAtmMassB   (0:imax-1, 1:jmax, 1:kmax)
  1366      real(DP):: xyz_DelAtmMassA   (0:imax-1, 1:jmax, 1:kmax)
  1367  
  1368      integer:: i               ! 経度方向に回る DO ループ用作業変数
  1369                                ! Work variables for DO loop in longitude
  1370      integer:: j               ! 緯度方向に回る DO ループ用作業変数
  1371                                ! Work variables for DO loop in latitude
  1372      integer:: k               ! 鉛直方向に回る DO ループ用作業変数
  1373                                ! Work variables for DO loop in vertical direction
  1374      integer:: m
  1375      integer:: n
  1376  
  1377  
  1378      ! 実行文 ; Executable statement
  1379      !
  1380  
  1381      ! 初期化
  1382      ! Initialization
  1383      !
  1384      if ( .not. major_comp_phase_change_inited ) then
  1385        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
  1386      end if
  1387  
  1388  
  1389      if ( .not. FlagMajCompPhaseChange ) return
  1390  
  1391  
  1392      ! 計算時間計測開始
  1393      ! Start measurement of computation time
  1394      !
  1395      call TimesetClockStart( module_name )
  1396  
  1397  
  1398      xy_PsB = xy_Ps
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t573 = 1, xy_psb.DSC.U2*xy_psb.DSC.U1 + xy_psb.DSC.U2          
     .           xy_psb(t573-1,1) = xy_ps(t573-1,1)                             
     .           xy_psa(t573-1,1) = xy_psb(t573-1,1) + xy_dpsdt(t573-1,1)*      
     .       1      2.00000000000000e+000*deltime                               
     .        enddo                                                             
  1399      xy_PsA = xy_PsB + xy_DPsDt * ( 2.0_DP * DelTime )
  1400  
  1401      xyzf_QMixB = xyzf_QMix
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t587 = 1, xyzf_qmixb.DSC.U4*xyzf_qmixb.DSC.U3*xyzf_qmixb.DSC.U2
     .       1   *(xyzf_qmixb.DSC.U1 + 1)                                       
     .           xyzf_qmixb(t587-1,1,1,1) = xyzf_qmix(t587-1,1,1,1)             
     .        enddo                                                             
  1402  
  1403      xyz_TempTmp    = 300.0_DP
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t603 = 1, xyz_temptmp.DSC.U3*(xyz_temptmp.DSC.U2*              
     .       1   xyz_temptmp.DSC.U1 + xyz_temptmp.DSC.U2)                       
     .           xyz_temptmp(t603-1,1,1) = 3.00000000000000e+002                
     .           xyz_qh2ovaptmp(t603-1,1,1) = 0.0000000000000000e+000           
     .        enddo                                                             
  1404      xyz_QH2OVapTmp =   0.0_DP
  1405  
  1406      ! 温度の半整数σレベルの補間, 気圧と高度の算出
  1407      ! Interpolate temperature on half sigma level,
  1408      ! and calculate pressure and height
  1409      !
  1410      call AuxVars( &
  1411        & xy_PsB, xyz_TempTmp, xyz_QH2OVapTmp,    & ! (in )
  1412        & xyr_Press = xyr_PressB                  & ! (out) optional
  1413        & )
  1414      call AuxVars( &
  1415        & xy_PsA, xyz_TempTmp, xyz_QH2OVapTmp,    & ! (in )
  1416        & xyr_Press = xyr_PressA                  & ! (out) optional
  1417        & )
  1418  
  1419  
  1420      xyr_DPressDt = ( xyr_PressA - xyr_PressB ) / ( 2.0_DP * Deltime )
     .        d1 = 1.D0/(2.00000000000000e+000*deltime)                         
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t615 = 1, (xyr_pressa.DSC.U3 + 1)*xyr_pressa.DSC.U2*(          
     .       1   xyr_pressa.DSC.U1 + 1)                                         
     .           xyr_dpressdt(t615-1,1,0) = (xyr_pressa(t615-1,1,0)-xyr_pressb( 
     .       1      t615-1,1,0))*d1                                             
     .        enddo                                                             
  1421  
  1422  
  1423      ! packing
  1424      if ( FlagModMom ) then
  1425        mmax = ncmax + 1 + 1
  1426      else
  1427        mmax = ncmax
  1428      end if
  1429      do m = 1, ncmax
  1430        n = m
  1431        xyza_Array(:,:,:,m) = xyzf_QMix(:,:,:,n)
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t630 = 1, xyza_array.DSC.U3*(xyza_array.DSC.U2*                
     .       1   xyza_array.DSC.U1 + xyza_array.DSC.U2)                         
     .           xyza_array(t630-1,1,1,m) = xyzf_qmix(t630-1,1,1,n)             
     .        enddo                                                             
  1432        if ( n == IndexTKE ) then
  1433          a_FlagSurfaceSink(m) = .true.
  1434        else
  1435          a_FlagSurfaceSink(m) = .false.
  1436        end if
  1437      end do
  1438      if ( FlagModMom ) then
  1439        m = ncmax
  1440        m = m + 1
  1441        xyza_Array(:,:,:,m) = xyz_U
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t752 = 1, xyza_array.DSC.U3*(xyza_array.DSC.U2*                
     .       1   xyza_array.DSC.U1 + xyza_array.DSC.U2)                         
     .           xyza_array(t752-1,1,1,m) = xyz_u(t752-1,1,1)                   
     .        enddo                                                             
  1442        a_FlagSurfaceSink(m) = .true.
  1443        m = m + 1
  1444        xyza_Array(:,:,:,m) = xyz_V
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t764 = 1, xyza_array.DSC.U3*(xyza_array.DSC.U2*                
     .       1   xyza_array.DSC.U1 + xyza_array.DSC.U2)                         
     .           xyza_array(t764-1,1,1,m) = xyz_v(t764-1,1,1)                   
     .        enddo                                                             
  1445        a_FlagSurfaceSink(m) = .true.
  1446      end if
  1447  
  1448      call MajorCompPhaseChangeCalcFlow( &
  1449        & xyr_PressB, xyr_DPressDt,                                    & ! (in)
  1450        & mmax, a_FlagSurfaceSink(1:mmax), xyza_Array(:,:,:,1:mmax),   & ! (in)
  1451        & xyra_MassFlow(:,:,:,1:mmax)                                  & ! (out)
  1452        & )
  1453  
  1454      ! unpacking
  1455      do m = 1, ncmax
  1456        xyrf_MassFlow(:,:,:,m) = xyra_MassFlow(:,:,:,m)
  1457      end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do m = 1, ncmax*(xyrf_massflow.DSC.U3 + 1)*xyrf_massflow.DSC.U2*( 
     .       1   xyrf_massflow.DSC.U1 + 1)                                      
     .           xyrf_massflow(m-1,1,0,1) = xyra_massflow(m-1,1,0,1)            
     .        enddo                                                             
  1458      if ( FlagModMom ) then
  1459        m = ncmax
  1460        m = m + 1
  1461        xyr_MomXFlow = xyra_MassFlow(:,:,:,m)
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t728 = 1, (xyr_momxflow.DSC.U3 + 1)*xyr_momxflow.DSC.U2*(      
     .       1   xyr_momxflow.DSC.U1 + 1)                                       
     .           xyr_momxflow(t728-1,1,0) = xyra_massflow(t728-1,1,0,m)         
     .        enddo                                                             
  1462        m = m + 1
  1463        xyr_MomYFlow = xyra_MassFlow(:,:,:,m)
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t740 = 1, (xyr_momyflow.DSC.U3 + 1)*xyr_momyflow.DSC.U2*(      
     .       1   xyr_momyflow.DSC.U1 + 1)                                       
     .           xyr_momyflow(t740-1,1,0) = xyra_massflow(t740-1,1,0,m)         
     .        enddo                                                             
  1464      end if
  1465  
  1466  
  1467      ! Adjustment
  1468      !   preparation
  1469      do k = 1, kmax
  1470        xyz_DelAtmMassB(:,:,k) = ( xyr_PressB(:,:,k-1) - xyr_PressB(:,:,k) ) / Grav
  1471        xyz_DelAtmMassA(:,:,k) = ( xyr_PressA(:,:,k-1) - xyr_PressA(:,:,k) ) / Grav
  1472      end do
     .        d2 = 1.D0/grav                                                    
     .        d3 = 1.D0/grav                                                    
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do k = 1, kmax*(xyr_pressb.DSC.U2*xyr_pressb.DSC.U1 +             
     .       1   xyr_pressb.DSC.U2)                                             
     .           xyz_delatmmassb(k-1,1,1) = (xyr_pressb(k-1,1,0)-xyr_pressb(k-1,
     .       1      1,1))*d2                                                    
     .           xyz_delatmmassa(k-1,1,1) = (xyr_pressa(k-1,1,0)-xyr_pressa(k-1,
     .       1      1,1))*d3                                                    
     .        enddo                                                             
  1473      !   Atmospheric composition
  1474      do n = 1, ncmax
  1475        do k = 1, kmax
  1476          xyzf_QMix(:,:,k,n) =                                              &
  1477            &   (   xyz_DelAtmMassB(:,:,k) * xyzf_QMix(:,:,k,n)             &
  1478            &     - ( xyrf_MassFlow(:,:,k,n) - xyrf_MassFlow(:,:,k-1,n) ) ) &
  1479            & / xyz_DelAtmMassA(:,:,k)
  1480        end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xyz_delatmmassb,xyz_delatmmassa)                           
     .        do k = 1, kmax*(xyz_delatmmassb.DSC.U2*xyz_delatmmassb.DSC.U1 +   
     .       1   xyz_delatmmassb.DSC.U2)                                        
     .           xyzf_qmix(k-1,1,1,n) = (xyz_delatmmassb(k-1,1,1)*xyzf_qmix(k-1,
     .       1      1,1,n)-(xyrf_massflow(k-1,1,1,n)-xyrf_massflow(k-1,1,0,n)))/
     .       2      xyz_delatmmassa(k-1,1,1)                                    
     .        enddo                                                             
  1481      end do
  1482      if ( FlagModMom ) then
  1483        do k = 1, kmax
  1484          ! Zonal wind
  1485          xyz_U(:,:,k) =                                              &
  1486            &   (   xyz_DelAtmMassB(:,:,k) * xyz_U(:,:,k)             &
  1487            &     - ( xyr_MomXFlow(:,:,k) - xyr_MomXFlow(:,:,k-1) ) ) &
  1488            & / xyz_DelAtmMassA(:,:,k)
  1489          ! Meridional wind
  1490          xyz_V(:,:,k) =                                              &
  1491            &   (   xyz_DelAtmMassB(:,:,k) * xyz_V(:,:,k)             &
  1492            &     - ( xyr_MomYFlow(:,:,k) - xyr_MomYFlow(:,:,k-1) ) ) &
  1493            & / xyz_DelAtmMassA(:,:,k)
  1494        end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xyz_delatmmassb,xyz_delatmmassa)                           
     .        do k = 1, kmax*(xyz_delatmmassb.DSC.U2*xyz_delatmmassb.DSC.U1 +   
     .       1   xyz_delatmmassb.DSC.U2)                                        
     .           xyz_u(k-1,1,1) = (xyz_delatmmassb(k-1,1,1)*xyz_u(k-1,1,1)-(    
     .       1      xyr_momxflow(k-1,1,1)-xyr_momxflow(k-1,1,0)))/              
     .       2      xyz_delatmmassa(k-1,1,1)                                    
     .           xyz_v(k-1,1,1) = (xyz_delatmmassb(k-1,1,1)*xyz_v(k-1,1,1)-(    
     .       1      xyr_momyflow(k-1,1,1)-xyr_momyflow(k-1,1,0)))/              
     .       2      xyz_delatmmassa(k-1,1,1)                                    
     .        enddo                                                             
  1495      end if
  1496  
  1497      !   Surface major component ice
  1498      xy_SurfMajCompIce = xy_SurfMajCompIce + xy_DSurfMajCompIceDt * ( 2.0_DP * DelTime )
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t686 = 1, jmax*imax                                            
     .           xy_surfmajcompice(t686-1,1) = xy_surfmajcompice(t686-1,1) +    
     .       1      xy_dsurfmajcompicedt(t686-1,1)*2.00000000000000e+000*deltime
     .           xy_ps(t686-1,1) = xy_psa(t686-1,1)                             
     .        enddo                                                             
  1499      !   Surface pressure
  1500      xy_Ps = xy_PsA
  1501  
  1502  
  1503      call AuxVars( &
  1504        & xy_PsA, xyz_TempTmp, xyz_QH2OVapTmp,    & ! (in )
  1505        & xyr_Press = xyr_PressA                  & ! (out) optional
  1506        & )
  1507      ! 成分の質量の補正
  1508      ! Fix masses of constituents
  1509      !
  1510      call MassFixerColumn( &
  1511        & xyr_PressA, & ! (in)
  1512        & xyzf_QMix   & ! (inout)
  1513        & )
  1514  
  1515  
  1516      ! Check
  1517      call MajorCompPhaseChangeConsChk( &
  1518        & a_FlagSurfaceSink,            & ! (in)
  1519        & xyz_DelAtmMassB, xyzf_QMixB,  & ! (in)
  1520        & xyz_DelAtmMassA, xyzf_QMix    & ! (in)
  1521        & )
  1522  
  1523  
  1524      ! 計算時間計測一時停止
  1525      ! Pause measurement of computation time
  1526      !
  1527      call TimesetClockStop( module_name )
  1528  
  1529  
  1530    end subroutine MajorCompPhaseChangeOnGround
  1531  
  1532    !--------------------------------------------------------------------------------------
  1533  
  1534    subroutine MajorCompPhaseChangeCalcFlow( &
  1535      & xyr_Press, xyr_DPressDt,             & ! (in)
  1536      & mmax, a_FlagSurfaceSink, xyza_Array, & ! (in)
  1537      & xyra_MassFlow                        & ! (out)
  1538      & )
  1539      !
  1540      ! CO2 相変化
  1541      !
  1542      ! CO2 phase change
  1543      !
  1544  
  1545      ! モジュール引用 ; USE statements
  1546      !
  1547  
  1548      ! 時刻管理
  1549      ! Time control
  1550      !
  1551      use timeset, only: &
  1552        & DelTime               ! $ \Delta t $
  1553  
  1554      ! 物理定数設定
  1555      ! Physical constants settings
  1556      !
  1557      use constants, only: &
  1558        & Grav                  ! $ g $ [m s-2].
  1559                                ! 重力加速度.
  1560                                ! Gravitational acceleration
  1561  
  1562      ! 宣言文 ; Declaration statements
  1563      !
  1564      implicit none
  1565  
  1566      real(DP), intent(in ):: xyr_Press    (0:imax-1, 1:jmax, 0:kmax)
  1567                                ! pressure
  1568      real(DP), intent(in ):: xyr_DPressDt (0:imax-1, 1:jmax, 0:kmax)
  1569      integer , intent(in ):: mmax
  1570      logical , intent(in ):: a_FlagSurfaceSink(1:mmax)
  1571      real(DP), intent(in ):: xyza_Array   (0:imax-1, 1:jmax, 1:kmax, 1:mmax)
  1572      real(DP), intent(out):: xyra_MassFlow(0:imax-1, 1:jmax, 0:kmax, 1:mmax)
  1573  
  1574      ! 作業変数
  1575      ! Work variables
  1576      !
  1577      real(DP):: xyr_DPPress  (0:imax-1, 1:jmax, 0:kmax)
  1578                                ! pressure at departure point
  1579      real(DP):: DelAtmMass
  1580      integer:: i               ! 経度方向に回る DO ループ用作業変数
  1581                                ! Work variables for DO loop in longitude
  1582      integer:: j               ! 緯度方向に回る DO ループ用作業変数
  1583                                ! Work variables for DO loop in latitude
  1584      integer:: k               ! 鉛直方向に回る DO ループ用作業変数
  1585                                ! Work variables for DO loop in vertical direction
  1586      integer:: k2              ! 鉛直方向に回る DO ループ用作業変数
  1587                                ! Work variables for DO loop in vertical direction
  1588      integer:: m
  1589  
  1590  
  1591      ! 実行文 ; Executable statement
  1592      !
  1593  
  1594      ! 初期化
  1595      ! Initialization
  1596      !
  1597      if ( .not. major_comp_phase_change_inited ) then
  1598        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
  1599      end if
  1600  
  1601  
  1602      if ( .not. FlagMajCompPhaseChange ) return
  1603  
  1604  
  1605      xyr_DPPress = xyr_Press + xyr_DPressDt * ( 2.0_DP * DelTime )
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t452 = 1, jmax*(kmax*imax + imax)                              
     .           xyr_dppress(t452-1,1,0) = xyr_press(t452-1,1,0) + xyr_dpressdt(
     .       1      t452-1,1,0)*2.00000000000000e+000*deltime                   
     .        enddo                                                             
  1606  
  1607      ! check
  1608      do k = 1, kmax
  1609        do j = 1, jmax
  1610          do i = 0, imax-1
  1611            if ( xyr_DPPress(i,j,k-1) < xyr_DPPress(i,j,k) ) then
  1612              call MessageNotify( 'E', module_name, 'Order of departure points are inappropriate, P(k=%d)=%f < P(k=%d)=%f.', &
  1613                & i = (/ k-1, k /), d = (/ xyr_DPPress(i,j,k-1), xyr_DPPress(i,j,k) /) )
  1614            end if
  1615          end do
  1616        end do
  1617      end do
  1618  
  1619      xyra_MassFlow = 0.0_DP
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t467 = 1, mmax*(kmax + 1)*jmax*imax                            
     .           xyra_massflow(t467-1,1,0,1) = 0.0000000000000000e+000          
     .        enddo                                                             
  1620      do k = 0, kmax-1
  1621        do j = 1, jmax
  1622          do i = 0, imax-1
  1623  
  1624  !!$          if ( xyr_DPressDt(i,j,k) >= 0.0_DP ) then
  1625            if ( xyr_DPPress(i,j,k) > xyr_Press(i,j,k) ) then
  1626  
  1627              sum_upward_mass_transport : do k2 = k, 1, -1
  1628                if ( xyr_DPPress(i,j,k) > xyr_Press(i,j,k2-1) ) then
  1629                  DelAtmMass = ( xyr_Press(i,j,k2-1) - xyr_Press(i,j,k2) ) / Grav
  1630                  do m = 1, mmax
     .  !cdir nodep                                                             
     .  !cdir on_adb(xyra_massflow)                                             
     .        do m = 1, mmax                                                    
  1631                    xyra_MassFlow(i,j,k,m) = xyra_MassFlow(i,j,k,m) &
  1632                      & + xyza_Array(i,j,k2,m) * DelAtmMass
  1633                  end do
  1634                else
  1635                  DelAtmMass = ( xyr_DPPress(i,j,k) - xyr_Press(i,j,k2) ) / Grav
  1636                  do m = 1, mmax
     .  !cdir    nodep                                                          
     .  !cdir on_adb(xyra_massflow)                                             
     .        do m = 1, mmax                                                    
  1637                    xyra_MassFlow(i,j,k,m) = xyra_MassFlow(i,j,k,m) &
  1638                      & + xyza_Array(i,j,k2,m) * DelAtmMass
  1639                  end do
  1640                  exit sum_upward_mass_transport
  1641                end if
  1642              end do sum_upward_mass_transport
  1643  
  1644            else
  1645  
  1646              sum_downward_mass_transport : do k2 = k+1, kmax
  1647                if ( xyr_DPPress(i,j,k) < xyr_Press(i,j,k2  ) ) then
  1648                  DelAtmMass = ( xyr_Press(i,j,k2-1) - xyr_Press(i,j,k2) ) / Grav
  1649                  do m = 1, mmax
     .  !cdir    nodep                                                          
     .  !cdir on_adb(xyra_massflow)                                             
     .        do m = 1, mmax                                                    
  1650                    xyra_MassFlow(i,j,k,m) = xyra_MassFlow(i,j,k,m) &
  1651                      & - xyza_Array(i,j,k2,m) * DelAtmMass
  1652                  end do
  1653                else
  1654                  DelAtmMass = ( xyr_Press(i,j,k2-1) - xyr_DPPress(i,j,k) ) / Grav
  1655                  do m = 1, mmax
     .  !cdir    nodep                                                          
     .  !cdir on_adb(xyra_massflow)                                             
     .        do m = 1, mmax                                                    
  1656                    xyra_MassFlow(i,j,k,m) = xyra_MassFlow(i,j,k,m) &
  1657                      & - xyza_Array(i,j,k2,m) * DelAtmMass
  1658                  end do
  1659                  exit sum_downward_mass_transport
  1660                end if
  1661              end do sum_downward_mass_transport
  1662  
  1663            end if
  1664  
  1665          end do
  1666        end do
  1667  
  1668      end do
  1669  
  1670  
  1671      do k = 0, 0
  1672        do j = 1, jmax
  1673          do i = 0, imax-1
  1674  
  1675            ! not surface sink
  1676            if ( xyr_DPressDt(i,j,k) <= 0.0_DP ) then
  1677              do m = 1, mmax
  1678                if ( .not. a_FlagSurfaceSink(m) ) then
  1679                  xyra_MassFlow(i,j,k,m) = 0.0_DP
  1680                end if
  1681              end do
  1682            end if
  1683  
  1684          end do
  1685        end do
  1686  
  1687      end do
     .           do j = 1, jmax                                                 
     .           do i = 0, imax - 1                                             
     .              if (xyr_dpressdt(i,j,0) .gt. 0.0000000000000000e+000) goto  
     .       1         31051                                                    
     .  !cdir       nodep                                                       
     .  !cdir       on_adb(a_flagsurfacesink)                                   
     .              do m = 1, mmax                                              
     .                 if (a_flagsurfacesink(m) .eq. 0) then                    
     .                    xyra_massflow(i,j,0,m) = 0.0000000000000000e+000      
     .                 endif                                                    
     .              enddo                                                       
     .  31051       continue                                                    
     .           enddo                                                          
     .        enddo                                                             
  1688  
  1689  
  1690  
  1691    end subroutine MajorCompPhaseChangeCalcFlow
  1692  
  1693    !--------------------------------------------------------------------------------------
  1694  
  1695    subroutine MajorCompPhaseChangeConsChk( &
  1696      & a_FlagSurfaceSink,                  & ! (in)
  1697      & xyz_DelAtmMassB, xyzf_QMixB,        & ! (in)
  1698      & xyz_DelAtmMassA, xyzf_QMixA         & ! (in)
  1699      & )
  1700  
  1701      ! 組成に関わる配列の設定
  1702      ! Settings of array for atmospheric composition
  1703      !
  1704      use composition, only : ncmax
  1705  
  1706      ! 物理定数設定
  1707      ! Physical constants settings
  1708      !
  1709      use constants, only: &
  1710        & Grav, &
  1711                                ! $ g $ [m s-2].
  1712                                ! 重力加速度.
  1713                                ! Gravitational acceleration
  1714        & CpDry
  1715                                ! $ C_p $ [J kg-1 K-1].
  1716                                ! 乾燥大気の定圧比熱.
  1717                                ! Specific heat of air at constant pressure
  1718  
  1719      logical , intent(in) :: a_FlagSurfaceSink(1:ncmax)
  1720      real(DP), intent(in) :: xyz_DelAtmMassB(0:imax-1, 1:jmax, 1:kmax)
  1721      real(DP), intent(in) :: xyzf_QMixB     (0:imax-1, 1:jmax, 1:kmax, ncmax)
  1722      real(DP), intent(in) :: xyz_DelAtmMassA(0:imax-1, 1:jmax, 1:kmax)
  1723      real(DP), intent(in) :: xyzf_QMixA     (0:imax-1, 1:jmax, 1:kmax, ncmax)
  1724  
  1725      ! Local variables
  1726      !
  1727      real(DP) :: ValB
  1728      real(DP) :: ValA
  1729      real(DP) :: xyf_SumB(0:imax-1, 1:jmax, 1:ncmax)
  1730      real(DP) :: xyf_SumA(0:imax-1, 1:jmax, 1:ncmax)
  1731      real(DP) :: Ratio
  1732      integer  :: i
  1733      integer  :: j
  1734      integer  :: k
  1735      integer  :: n
  1736  
  1737  
  1738      xyf_SumB = 0.0_DP
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t209 = 1, xyf_sumb.DSC.U3*(xyf_sumb.DSC.U2*xyf_sumb.DSC.U1 +   
     .       1   xyf_sumb.DSC.U2)                                               
     .           xyf_sumb(t209-1,1,1) = 0.0000000000000000e+000                 
     .           xyf_suma(t209-1,1,1) = 0.0000000000000000e+000                 
     .        enddo                                                             
  1739      xyf_SumA = 0.0_DP
  1740      do n = 1, ncmax
  1741        do k = kmax, 1, -1
  1742          xyf_SumB(:,:,n) = xyf_SumB(:,:,n) &
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .  !cdir on_adb(xyf_sumb,xyz_delatmmassb,xyf_suma,xyz_delatmmassa)         
     .        do t221 = 1, xyf_sumb.DSC.U2*xyf_sumb.DSC.U1 + xyf_sumb.DSC.U2    
     .           xyf_sumb(t221-1,1,n) = xyf_sumb(t221-1,1,n) + xyz_delatmmassb( 
     .       1      t221-1,1,k)*xyzf_qmixb(t221-1,1,k,n)                        
     .           xyf_suma(t221-1,1,n) = xyf_suma(t221-1,1,n) + xyz_delatmmassa( 
     .       1      t221-1,1,k)*xyzf_qmixa(t221-1,1,k,n)                        
     .        enddo                                                             
  1743            & + xyz_DelAtmMassB(:,:,k) * xyzf_QMixB(:,:,k,n)
  1744          xyf_SumA(:,:,n) = xyf_SumA(:,:,n) &
  1745            & + xyz_DelAtmMassA(:,:,k) * xyzf_QMixA(:,:,k,n)
  1746        end do
  1747      end do
  1748      do n = 1, ncmax
  1749        if ( .not. a_FlagSurfaceSink(n) ) then
  1750          do j = 1, jmax
  1751            do i = 0, imax-1
  1752              ValB = xyf_SumB(i,j,n)
  1753              ValA = xyf_SumA(i,j,n)
  1754  
  1755              Ratio = ( ValA - ValB ) / ( ValA + 1.0d-100 )
  1756              if ( abs( Ratio ) > 1.0d-10 ) then
  1757                if ( ( ValB < 0.0_DP ) .and. ( abs( ValB ) < 1.0e-20_DP ) ) then
  1758                  ! Do nothing
  1759                else
  1760                  call MessageNotify( 'M', module_name, 'Mass No. %d is not conserved, %f.', i = (/ n /), d = (/ Ratio /) )
  1761                end if
  1762              end if
  1763            end do
  1764          end do
  1765        end if
  1766      end do
  1767  
  1768  
  1769    end subroutine MajorCompPhaseChangeConsChk
  1770  
  1771  !!$  subroutine MajorCompPhaseChangeLimitTemp( &
  1772  !!$    & xyr_Press, xyz_Press,  &  ! (in)
  1773  !!$    & xy_SurfTemp, xyz_Temp  &  ! (inout)
  1774  !!$    & )
  1775  !!$    !
  1776  !!$    ! CO2 相変化
  1777  !!$    !
  1778  !!$    ! CO2 phase change
  1779  !!$    !
  1780  !!$
  1781  !!$    ! モジュール引用 ; USE statements
  1782  !!$    !
  1783  !!$
  1784  !!$    ! 時刻管理
  1785  !!$    ! Time control
  1786  !!$    !
  1787  !!$    use timeset, only: &
  1788  !!$      & DelTime, &            ! $ \Delta t $
  1789  !!$      & TimeN, &              ! ステップ $ t $ の時刻. Time of step $ t $.
  1790  !!$      & TimesetClockStart, TimesetClockStop
  1791  !!$
  1792  !!$    ! ヒストリデータ出力
  1793  !!$    ! History data output
  1794  !!$    !
  1795  !!$    use gtool_historyauto, only: HistoryAutoPut
  1796  !!$
  1797  !!$
  1798  !!$    ! 宣言文 ; Declaration statements
  1799  !!$    !
  1800  !!$    implicit none
  1801  !!$
  1802  !!$    real(DP), intent(in   ):: xyr_Press (0:imax-1, 1:jmax, 0:kmax)
  1803  !!$                              ! $ \hat{p} $ . 気圧 (半整数レベル).
  1804  !!$                              ! Air pressure (half level)
  1805  !!$    real(DP), intent(in   ):: xyz_Press (0:imax-1, 1:jmax, 1:kmax)
  1806  !!$                              ! $ p $ . 気圧 (整数レベル).
  1807  !!$                              ! Air pressure (full level)
  1808  !!$    real(DP), intent(inout):: xy_SurfTemp(0:imax-1, 1:jmax)
  1809  !!$                              ! $ T_s $ .   惑星表面温度. Surface temperature
  1810  !!$    real(DP), intent(inout):: xyz_Temp   (0:imax-1, 1:jmax, 1:kmax)
  1811  !!$                              ! $ T $ .     温度. Temperature
  1812  !!$
  1813  !!$    ! 作業変数
  1814  !!$    ! Work variables
  1815  !!$    !
  1816  !!$    real(DP):: xy_SurfTempB  (0:imax-1, 1:jmax)
  1817  !!$                              ! 調節前の惑星表面温度.
  1818  !!$                              ! Surface temperature before adjustment
  1819  !!$    real(DP):: xyz_TempB     (0:imax-1, 1:jmax, 1:kmax)
  1820  !!$                              ! 調節前の温度.
  1821  !!$                              ! Temperature before adjustment
  1822  !!$    real(DP):: xy_DSurfTempDt(0:imax-1, 1:jmax)
  1823  !!$                              ! 惑星表面温度変化率.
  1824  !!$                              ! Surface temperature tendency
  1825  !!$    real(DP):: xyz_DTempDt   (0:imax-1, 1:jmax, 1:kmax)
  1826  !!$                              ! 温度変化率.
  1827  !!$                              ! Temperature tendency
  1828  !!$
  1829  !!$    real(DP):: xy_SurfTempCond(0:imax-1, 1:jmax)
  1830  !!$    real(DP):: xyz_TempCond   (0:imax-1, 1:jmax, 1:kmax)
  1831  !!$
  1832  !!$    integer:: i               ! 経度方向に回る DO ループ用作業変数
  1833  !!$                              ! Work variables for DO loop in longitude
  1834  !!$    integer:: j               ! 緯度方向に回る DO ループ用作業変数
  1835  !!$                              ! Work variables for DO loop in latitude
  1836  !!$    integer:: k               ! 鉛直方向に回る DO ループ用作業変数
  1837  !!$                              ! Work variables for DO loop in vertical direction
  1838  !!$
  1839  !!$    logical :: FlagCheckPs
  1840  !!$
  1841  !!$
  1842  !!$    ! 実行文 ; Executable statement
  1843  !!$    !
  1844  !!$
  1845  !!$    ! 計算時間計測開始
  1846  !!$    ! Start measurement of computation time
  1847  !!$    !
  1848  !!$    call TimesetClockStart( module_name )
  1849  !!$
  1850  !!$    ! 初期化
  1851  !!$    ! Initialization
  1852  !!$    !
  1853  !!$    if ( .not. major_comp_phase_change_inited ) call MajorCompPhaseChangeInit
  1854  !!$
  1855  !!$    if ( .not. FlagUse ) return
  1856  !!$
  1857  !!$
  1858  !!$    FlagCheckPs = .false.
  1859  !!$    do j = 1, jmax
  1860  !!$      do i = 0, imax-1
  1861  !!$        if ( xyr_Press(i,j,0) > 1.0d4 ) then
  1862  !!$          FlagCheckPs = .true.
  1863  !!$        end if
  1864  !!$      end do
  1865  !!$    end do
  1866  !!$    if ( FlagCheckPs ) then
  1867  !!$      call MessageNotify( 'W', module_name, 'Surface pressure is greater than 10000 Pa.' )
  1868  !!$    end if
  1869  !!$
  1870  !!$
  1871  !!$    ! 調節前 "Temp" の保存
  1872  !!$    ! Store "Temp" before adjustment
  1873  !!$    !
  1874  !!$    xy_SurfTempB = xy_SurfTemp
  1875  !!$    xyz_TempB    = xyz_Temp
  1876  !!$
  1877  !!$
  1878  !!$    do j = 1, jmax
  1879  !!$      do i = 0, imax-1
  1880  !!$        xy_SurfTempCond(i,j) = &
  1881  !!$          & 149.2d0 + 6.48d0 * log( 0.135d0 * xyr_Press(i,j,0) * 1.0d-2 )
  1882  !!$      end do
  1883  !!$    end do
  1884  !!$    do k = 1, kmax
  1885  !!$      do j = 1, jmax
  1886  !!$        do i = 0, imax-1
  1887  !!$          xyz_TempCond(i,j,k) = &
  1888  !!$            & 149.2d0 + 6.48d0 * log( 0.135d0 * xyz_Press(i,j,k) * 1.0d-2 )
  1889  !!$        end do
  1890  !!$      end do
  1891  !!$    end do
  1892  !!$
  1893  !!$    do j = 1, jmax
  1894  !!$      do i = 0, imax-1
  1895  !!$        if ( xy_SurfTemp(i,j) < xy_SurfTempCond(i,j) ) then
  1896  !!$          xy_SurfTemp(i,j) = xy_SurfTempCond(i,j)
  1897  !!$        end if
  1898  !!$      end do
  1899  !!$    end do
  1900  !!$    do k = 1, kmax
  1901  !!$      do j = 1, jmax
  1902  !!$        do i = 0, imax-1
  1903  !!$          if ( xyz_Temp(i,j,k) < xyz_TempCond(i,j,k) ) then
  1904  !!$            xyz_Temp(i,j,k) = xyz_TempCond(i,j,k)
  1905  !!$          end if
  1906  !!$        end do
  1907  !!$      end do
  1908  !!$    end do
  1909  !!$
  1910  !!$
  1911  !!$    ! 温度変化率
  1912  !!$    ! Calculate temperature tendency
  1913  !!$    !
  1914  !!$    xy_DSurfTempDt = ( xy_SurfTemp - xy_SurfTempB ) / ( 2.0_DP * DelTime )
  1915  !!$    xyz_DTempDt    = ( xyz_Temp    - xyz_TempB    ) / ( 2.0_DP * DelTime )
  1916  !!$
  1917  !!$
  1918  !!$    ! ヒストリデータ出力
  1919  !!$    ! History data output
  1920  !!$    !
  1921  !!$    call HistoryAutoPut( TimeN, 'DSurfTempDtCO2PhaseChange', xy_DSurfTempDt )
  1922  !!$    call HistoryAutoPut( TimeN, 'DTempDtCO2PhaseChange'    , xyz_DTempDt    )
  1923  !!$
  1924  !!$
  1925  !!$    ! 計算時間計測一時停止
  1926  !!$    ! Pause measurement of computation time
  1927  !!$    !
  1928  !!$    call TimesetClockStop( module_name )
  1929  !!$
  1930  !!$  end subroutine MajorCompPhaseChangeLimitTemp
  1931  
  1932    !--------------------------------------------------------------------------------------
  1933  
  1934    subroutine MajorCompPhaseChangeInit(             &
  1935      & ArgFlagMajCompPhaseChange, CondMajCompName   & ! (in)
  1936      & )
  1937      !
  1938      ! major_comp_phase_change モジュールの初期化を行います.
  1939      ! NAMELIST#major_comp_phase_change_nml の読み込みはこの手続きで行われます.
  1940      !
  1941      ! "major_comp_phase_change" module is initialized.
  1942      ! "NAMELIST#major_comp_phase_change_nml" is loaded in this procedure.
  1943      !
  1944  
  1945      ! モジュール引用 ; USE statements
  1946      !
  1947  
  1948      ! NAMELIST ファイル入力に関するユーティリティ
  1949      ! Utilities for NAMELIST file input
  1950      !
  1951      use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid
  1952  
  1953      ! ファイル入出力補助
  1954      ! File I/O support
  1955      !
  1956      use dc_iounit, only: FileOpen
  1957  
  1958      ! 種別型パラメタ
  1959      ! Kind type parameter
  1960      !
  1961      use dc_types, only: STDOUT ! 標準出力の装置番号. Unit number of standard output
  1962  
  1963      ! 文字列操作
  1964      ! Character handling
  1965      !
  1966      use dc_string, only: StoA
  1967  
  1968      ! ヒストリデータ出力
  1969      ! History data output
  1970      !
  1971      use gtool_historyauto, only: HistoryAutoAddVariable
  1972  
  1973      ! 補助的な変数を計算するサブルーチン・関数群
  1974      ! Subroutines and functions for calculating auxiliary variables
  1975      !
  1976      use auxiliary, only : AuxVarsInit
  1977  
  1978      ! 主成分相変化
  1979      ! Phase change of atmospheric major component
  1980      !
  1981      use saturate_major_comp, only : &
  1982        & SaturateMajorCompInit
  1983  
  1984      ! 質量の補正
  1985      ! Mass fixer
  1986      !
  1987      use mass_fixer, only : MassFixerInit
  1988  
  1989  
  1990      ! 宣言文 ; Declaration statements
  1991      !
  1992      implicit none
  1993  
  1994      logical     , intent(in) :: ArgFlagMajCompPhaseChange
  1995      character(*), intent(in) :: CondMajCompName
  1996  
  1997  
  1998      integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号.
  1999                                ! Unit number for NAMELIST file open
  2000      integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT.
  2001                                ! IOSTAT of NAMELIST read
  2002  
  2003      ! NAMELIST 変数群
  2004      ! NAMELIST group name
  2005      !
  2006      namelist /major_comp_phase_change_nml/ &
  2007        & FlagModMom
  2008  
  2009            ! デフォルト値については初期化手続 "major_comp_phase_change#MajorCompPhaseChangeInit"
  2010            ! のソースコードを参照のこと.
  2011            !
  2012            ! Refer to source codes in the initialization procedure
  2013            ! "major_comp_phase_change#MajorCompPhaseChangeInit" for the default values.
  2014            !
  2015  
  2016      ! 実行文 ; Executable statement
  2017      !
  2018  
  2019      if ( major_comp_phase_change_inited ) return
  2020  
  2021  
  2022      FlagMajCompPhaseChange = ArgFlagMajCompPhaseChange
  2023  
  2024  
  2025      ! デフォルト値の設定
  2026      ! Default values settings
  2027      !
  2028      FlagModMom = .false.
  2029  
  2030  
  2031      ! NAMELIST の読み込み
  2032      ! NAMELIST is input
  2033      !
  2034      if ( trim(namelist_filename) /= '' ) then
  2035        call FileOpen( unit_nml, &          ! (out)
  2036          & namelist_filename, mode = 'r' ) ! (in)
  2037  
  2038        rewind( unit_nml )
  2039        read( unit_nml,                        &  ! (in)
  2040          & nml = major_comp_phase_change_nml, &  ! (out)
  2041          & iostat = iostat_nml )                 ! (out)
  2042        close( unit_nml )
  2043  
  2044        call NmlutilMsg( iostat_nml, module_name ) ! (in)
  2045  !      if ( iostat_nml == 0 ) write( STDOUT, nml = cumulus_adjust_nml )
  2046      end if
  2047  
  2048  
  2049      if ( FlagMajCompPhaseChange ) then
  2050        ! 主成分相変化
  2051        ! Phase change of atmospheric major component
  2052        !
  2053        call SaturateMajorCompInit(  &
  2054          & CondMajCompName          & ! (in)
  2055          & )
  2056      end if
  2057  
  2058      ! 補助的な変数を計算するサブルーチン・関数群
  2059      ! Subroutines and functions for calculating auxiliary variables
  2060      !
  2061      call AuxVarsInit
  2062  
  2063      ! 質量の補正
  2064      ! Mass fixer
  2065      !
  2066      call MassFixerInit
  2067  
  2068  
  2069      ! ヒストリデータ出力のためのへの変数登録
  2070      ! Register of variables for history data output
  2071      !
  2072      call HistoryAutoAddVariable( 'DSurfTempDtMajCompPhaseChange', &
  2073        & (/ 'lon ', 'lat ', 'time' /),                             &
  2074        & 'heating by major component phase change', 'K s-1' )
  2075      call HistoryAutoAddVariable( 'DTempDtMajCompPhaseChange',     &
  2076        & (/ 'lon ', 'lat ', 'sig ', 'time' /),                 &
  2077        & 'heating by major component phase change', 'K s-1' )
  2078  
  2079      ! 印字 ; Print
  2080      !
  2081      call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
  2082      call MessageNotify( 'M', module_name, '  FlagModMom = %b', l = (/ FlagModMom /) )
  2083      call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
  2084  
  2085      major_comp_phase_change_inited = .true.
  2086  
  2087    end subroutine MajorCompPhaseChangeInit
  2088  
  2089    !-------------------------------------------------------------------
  2090  
  2091  end module major_comp_phase_change
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:29 2016
FILE NAME: major_comp_phase_change.f90
PROGRAM NAME: major_comp_phase_change
FORMAT LIST

  LINE    LOOP      FORTRAN STATEMENT

     1:             != 主成分相変化
     2:             !
     3:             != Phase change of atmospheric major component
     4:             !
     5:             ! Authors::   Yoshiyuki O. Takahashi
     6:             ! Version::   $Id: major_comp_phase_change.f90,v 1.3 2014/05/07 09:39:21 murashin Exp $ 
     7:             ! Tag Name::  $Name:  $
     8:             ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9:             ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10:             !
    11:             
    12:             module major_comp_phase_change
    13:               !
    14:               != 主成分相変化
    15:               !
    16:               != Phase change of atmospheric major component
    17:               !
    18:               ! <b>Note that Japanese and English are described in parallel.</b>
    19:               !
    20:               !== Procedures List
    21:               ! 
    22:             !!$  ! DryConvAdjust :: 乾燥対流調節
    23:             !!$  ! ------------  :: ------------
    24:             !!$  ! DryConvAdjust :: Dry convective adjustment
    25:               !
    26:               !== NAMELIST
    27:               !
    28:               ! NAMELIST#major_comp_phase_change_nml
    29:               !
    30:             
    31:               ! モジュール引用 ; USE statements
    32:               !
    33:             
    34:               ! 格子点設定
    35:               ! Grid points settings
    36:               !
    37:               use gridset, only: imax, & ! 経度格子点数. 
    38:                                          ! Number of grid points in longitude
    39:                 &                jmax, & ! 緯度格子点数. 
    40:                                          ! Number of grid points in latitude
    41:                 &                kmax    ! 鉛直層数. 
    42:                                          ! Number of vertical level
    43:             
    44:               ! 種別型パラメタ
    45:               ! Kind type parameter
    46:               !
    47:               use dc_types, only: DP, &      ! 倍精度実数型. Double precision. 
    48:                 &                 STRING     ! 文字列.       Strings. 
    49:             
    50:               ! NAMELIST ファイル入力に関するユーティリティ
    51:               ! Utilities for NAMELIST file input
    52:               !
    53:               use namelist_util, only: MaxNmlArySize
    54:                                           ! NAMELIST から読み込む配列の最大サイズ. 
    55:                                           ! Maximum size of arrays loaded from NAMELIST
    56:             
    57:               ! メッセージ出力
    58:               ! Message output
    59:               !
    60:               use dc_message, only: MessageNotify
    61:             
    62:               ! 宣言文 ; Declaration statements
    63:               !
    64:               implicit none
    65:               private
    66:             
    67:             
    68:               ! 公開手続き
    69:               ! Public procedure
    70:               !
    71:               public :: MajorCompPhaseChangeInAtm
    72:               public :: MajorCompPhaseChangeOnGround
    73:               public :: MajorCompPhaseChangeInit
    74:             
    75:             
    76:               ! 公開変数
    77:               ! Public variables
    78:               !
    79:               logical, save, public:: major_comp_phase_change_inited = .false.
    80:                                           ! 初期設定フラグ. 
    81:                                           ! Initialization flag
    82:             
    83:               ! 非公開変数
    84:               ! Private variables
    85:               !
    86:               logical, save :: FlagMajCompPhaseChange
    87:               logical, save :: FlagModMom
    88:             
    89:             
    90:               character(*), parameter:: module_name = 'major_comp_phase_change'
    91:                                           ! モジュールの名称. 
    92:                                           ! Module name
    93:               character(*), parameter:: version = &
    94:                 & '$Name:  $' // &
    95:                 & '$Id: major_comp_phase_change.f90,v 1.3 2014/05/07 09:39:21 murashin Exp $'
    96:                                           ! モジュールのバージョン
    97:                                           ! Module version
    98:             
    99:             
   100:             contains
   101:             
   102:               !-------------------------------------------------------------------
   103:             
   104:               subroutine MajorCompPhaseChangeInAtmTest(  &
   105:                 & xyr_Press, xyz_Press, xyz_Height,      &  ! (in)
   106:                 & xy_Ps, xyz_Temp, xy_SurfMajCompIce     &  ! (inout)
   107:                 & )
   108:                 !
   109:                 ! CO2 相変化
   110:                 !
   111:                 ! CO2 phase change
   112:                 !
   113:             
   114:                 ! モジュール引用 ; USE statements
   115:                 !
   116:             
   117:                 ! 時刻管理
   118:                 ! Time control
   119:                 !
   120:                 use timeset, only: &
   121:                   & DelTime, &            ! $ \Delta t $
   122:                   & TimeN, &              ! ステップ $ t $ の時刻. Time of step $ t $. 
   123:                   & TimesetClockStart, TimesetClockStop
   124:             
   125:                 ! ヒストリデータ出力
   126:                 ! History data output
   127:                 !
   128:                 use gtool_historyauto, only: HistoryAutoPut
   129:             
   130:                 ! 物理定数設定
   131:                 ! Physical constants settings
   132:                 !
   133:                 use constants, only: &
   134:                   & Grav, &               ! $ g $ [m s-2].
   135:                                           ! 重力加速度.
   136:                                           ! Gravitational acceleration
   137:                   & CpDry
   138:                                           ! $ C_p $ [J kg-1 K-1].
   139:                                           ! 乾燥大気の定圧比熱.
   140:                                           ! Specific heat of air at constant pressure
   141:             
   142:                 ! 主成分相変化
   143:                 ! Phase change of atmospheric major component
   144:                 !
   145:                 use saturate_major_comp, only :     &
   146:                   & SaturateMajorCompCondTemp,      &
   147:                   & SaturateMajorCompInqLatentHeat
   148:             
   149:             
   150:                 ! 宣言文 ; Declaration statements
   151:                 !
   152:                 implicit none
   153:             
   154:                 real(DP), intent(in   ):: xyr_Press (0:imax-1, 1:jmax, 0:kmax)
   155:                                           ! $ \hat{p} $ . 気圧 (半整数レベル). 
   156:                                           ! Air pressure (half level)
   157:                 real(DP), intent(in   ):: xyz_Press (0:imax-1, 1:jmax, 1:kmax)
   158:                                           ! $ p $ . 気圧 (整数レベル). 
   159:                                           ! Air pressure (full level)
   160:                 real(DP), intent(in   ):: xyz_Height(0:imax-1, 1:jmax, 1:kmax)
   161:                                           ! 
   162:                                           ! 
   163:                 real(DP), intent(inout):: xy_Ps            (0:imax-1, 1:jmax)
   164:                                           ! $ T $ .     温度. Temperature
   165:                 real(DP), intent(inout):: xyz_Temp         (0:imax-1, 1:jmax, 1:kmax)
   166:                                           ! $ T $ .     温度. Temperature
   167:                 real(DP), intent(inout):: xy_SurfMajCompIce(0:imax-1, 1:jmax)
   168:                                           !
   169:                                           ! Surface major component ice amount
   170:             
   171:                 ! 作業変数
   172:                 ! Work variables
   173:                 !
   174:                 real(DP):: xyz_TempB           (0:imax-1, 1:jmax, 1:kmax)
   175:                                           ! 調節前の温度. 
   176:                                           ! Temperature before adjustment
   177:                 real(DP):: xyz_DelAtmMass      (0:imax-1, 1:jmax, 1:kmax)
   178:                                           !
   179:                                           ! Atmospheric mass in a layer
   180:                 real(DP):: xy_FallingIce       (0:imax-1, 1:jmax)
   181:                                           !
   182:                                           !
   183:                 real(DP):: xyz_DelMajCompIce   (0:imax-1, 1:jmax, 1:kmax)
   184:                                           !
   185:                                           !
   186:                 real(DP):: xy_DelSurfMajCompIce(0:imax-1, 1:jmax)
   187:                                           !
   188:                                           !
   189:                 real(DP):: xyz_DTempDt         (0:imax-1, 1:jmax, 1:kmax)
   190:                                           ! 温度変化率. 
   191:                                           ! Temperature tendency
   192:                 real(DP):: xy_DSurfMajCompIceDt(0:imax-1, 1:jmax)
   193:                                           ! 
   194:                                           ! Surface major component ice tendency
   195:             
   196:                 real(DP):: xyz_TempCond   (0:imax-1, 1:jmax, 1:kmax)
   197:                 real(DP):: xy_SurfTempCond(0:imax-1, 1:jmax)
   198:                 real(DP):: SpecHeatCO2Ice
   199:             
   200:                 real(DP):: LatentHeatMajCompSubl
   201:             
   202:                 integer:: i               ! 経度方向に回る DO ループ用作業変数
   203:                                           ! Work variables for DO loop in longitude
   204:                 integer:: j               ! 緯度方向に回る DO ループ用作業変数
   205:                                           ! Work variables for DO loop in latitude
   206:                 integer:: k               ! 鉛直方向に回る DO ループ用作業変数
   207:                                           ! Work variables for DO loop in vertical direction
   208:             
   209:                 logical :: FlagCheckPs
   210:             
   211:             
   212:                 ! 実行文 ; Executable statement
   213:                 !
   214:             
   215:                 ! 初期化
   216:                 ! Initialization
   217:                 !
   218:                 if ( .not. major_comp_phase_change_inited ) then
   219:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   220:                 end if
   221:             
   222:             
   223:                 if ( .not. FlagMajCompPhaseChange ) return
   224:             
   225:             
   226:                 ! 計算時間計測開始
   227:                 ! Start measurement of computation time
   228:                 !
   229:                 call TimesetClockStart( module_name )
   230:             
   231:             
   232:                 ! Set latent heat
   233:                 LatentHeatMajCompSubl = SaturateMajorCompInqLatentHeat()
   234:             
   235:             
   236:                 FlagCheckPs = .false.
   237: +------>        do j = 1, jmax
   238: |V----->          do i = 0, imax-1
   239: ||      A           if ( xyr_Press(i,j,0) > 1.0e4_DP ) then
   240: ||                    FlagCheckPs = .true.
   241: ||                  end if
   242: |V-----           end do
   243: +------         end do
   244:                 if ( FlagCheckPs ) then
   245:                   call MessageNotify( 'W', module_name, 'Surface pressure is greater than 10000 Pa.' )
   246:                 end if
   247:             
   248:             
   249:                 ! 調節前 "Temp" の保存
   250:                 ! Store "Temp" before adjustment
   251:                 !
   252: W**==== A       xyz_TempB    = xyz_Temp
   253:             
   254:             
   255:                 call SaturateMajorCompCondTemp(  &
   256:                   & xyz_Press,                   & ! (in)
   257:                   & xyz_TempCond                 & ! (inout)
   258:                   & )
   259:             
   260:             
   261: +------>        do k = 1, kmax
   262: |W*====           xyz_DelAtmMass(:,:,k) = ( xyr_Press(i,j,k-1) - xyr_Press(i,j,k) ) / Grav
   263: +------         end do
   264:             
   265:             
   266:                 k = kmax
   267: +------>        do j = 1, jmax
   268: |V----->          do i = 0, imax-1
   269: ||      A           if ( xyz_Temp(i,j,k) < xyz_TempCond(i,j,k) ) then
   270: ||      A             xyz_DelMajCompIce(i,j,k) =                                 &
   271: ||                      &   CpDry * ( xyz_TempCond(i,j,k) - xyz_Temp(i,j,k) )    &
   272: ||                      &   * xyz_DelAtmMass(i,j,k)                              &
   273: ||                      &   / LatentHeatMajCompSubl
   274: ||      A             xyz_Temp(i,j,k) = xyz_TempCond(i,j,k)
   275: ||                  else
   276: ||                    xyz_DelMajCompIce(i,j,k) = 0.0_DP
   277: ||                  end if
   278: |V----- A         end do
   279: +------         end do
   280:                 !
   281: W*=====         xy_FallingIce = 0.0_DP
   282: +------>        do k = kmax-1, 1, -1
   283: |W*==== A         xy_FallingIce = xy_FallingIce + xyz_DelMajCompIce(:,:,k+1)
   284: |+----->          do j = 1, jmax
   285: ||V---->            do i = 0, imax-1
   286: |||     A             SpecHeatCO2Ice = 349.0_DP + 4.8_DP * xyz_TempCond(i,j,k)
   287: |||                   !                                            Forget et al. (1998)
   288: |||     A             xyz_DelMajCompIce(i,j,k) =                                     &
   289: |||                     &   CpDry * ( xyz_TempCond(i,j,k) - xyz_Temp(i,j,k) )        &
   290: |||                     &   * xyz_DelAtmMass(i,j,k)                                  &
   291: |||                     &   / LatentHeatMajCompSubl                                  &
   292: |||                     & - (   Grav * ( xyz_Height(i,j,k+1) - xyz_Height(i,j,k) )   &
   293: |||                     &     + SpecHeatCO2Ice                                       &
   294: |||                     &       * ( xyz_TempCond(i,j,k+1) - xyz_TempCond(i,j,k) ) )  &
   295: |||                     &   / LatentHeatMajCompSubl                                  &
   296: |||                     &   * xy_FallingIce(i,j)
   297: |||                   if ( ( xy_FallingIce(i,j) + xyz_DelMajCompIce(i,j,k) ) >= 0.0_DP ) then
   298: |||     A               xyz_Temp(i,j,k) = xyz_TempCond(i,j,k)
   299: |||                   else
   300: |||                     xyz_DelMajCompIce(i,j,k) = - xy_FallingIce(i,j)
   301: |||                     xyz_Temp(i,j,k) = xyz_Temp(i,j,k)                                &
   302: |||                       & + ( - LatentHeatMajCompSubl                                  &
   303: |||                       &     + Grav * ( xyz_Height(i,j,k+1) - xyz_Height(i,j,k) )     &
   304: |||                       &     + SpecHeatCO2Ice                                         &
   305: |||                       &         * ( xyz_TempCond(i,j,k+1) - xyz_TempCond(i,j,k) ) )  &
   306: |||                       &     / ( CpDry * xyz_DelAtmMass(i,j,k) )                      &
   307: |||                       &     * xy_FallingIce(i,j)
   308: |||                   end if
   309: ||V---- A           end do
   310: |+-----           end do
   311: +------         end do
   312:             
   313:             
   314:                 ! Ice falling on the surface
   315:                 !   This may result in supersaturation in the lowest level.
   316:                 !
   317: W*===== A       xy_FallingIce = xy_FallingIce + xyz_DelMajCompIce(:,:,1)
   318:                 k = 1
   319: +------>        do j = 1, jmax
   320: |V----->          do i = 0, imax-1
   321: ||      A           xy_DelSurfMajCompIce(i,j) =                                    &
   322: ||                    & - (   Grav * ( xyz_Height(i,j,1) - 0.0_DP ) )              &
   323: ||                    &   / LatentHeatMajCompSubl                                  &
   324: ||                    &   * xy_FallingIce(i,j)
   325: ||          
   326: ||          
   327: ||          
   328: ||                    SpecHeatCO2Ice = 349.0_DP + 4.8_DP * xy_SurfTempCond(i,j)
   329: ||                    !                                            Forget et al. (1998)
   330: ||      A             xy_DelSurfMajCompIce(i,j) =                                    &
   331: ||          !!$            &   CpDry * ( xyz_TempCond(i,j,k) - xyz_Temp(i,j,k) )        &
   332: ||          !!$            &   * xyz_DelAtmMass(i,j,k)                                  &
   333: ||          !!$            &   / LatentHeatMajCompSubl                                  &
   334: ||                      & - (   Grav * ( xyz_Height(i,j,1) - 0.0_DP )                &
   335: ||                      &     + SpecHeatCO2Ice                                       &
   336: ||                      &       * ( xyz_TempCond(i,j,1) - xy_SurfTempCond(i,j) ) )   &
   337: ||                      &   / LatentHeatMajCompSubl                                  &
   338: ||                      &   * xy_FallingIce(i,j)
   339: ||          
   340: ||          
   341: ||                  if ( ( xy_FallingIce(i,j) + xy_DelSurfMajCompIce(i,j) ) >= 0.0_DP ) then
   342: ||                    ! Part of ice sublimes.
   343: ||                    ! NOTE: In this case, temperature in the lowest layer should be 
   344: ||                    ! condensation temperature. So, actually, the set of temperature is 
   345: ||                    ! meaningless.
   346: ||      A             xyz_Temp(i,j,k) = xyz_TempCond(i,j,k)
   347: ||                  else
   348: ||                    ! All falling ice sublimes.
   349: ||                    ! NOTE: The formulation below is different from that by Forget et al.
   350: ||                    ! (1998). The latent heat and heat by potential energy release and 
   351: ||                    ! heating ice is distributed in the lowest layer in this model, not
   352: ||                    ! to the soil.
   353: ||                    xy_DelSurfMajCompIce(i,j) = - xy_FallingIce(i,j)
   354: ||      A             xyz_Temp(i,j,k) = xyz_Temp(i,j,k)                                &
   355: ||                      & + ( - LatentHeatMajCompSubl                                  &
   356: ||                      &     + Grav * ( xyz_Height(i,j,1) - 0.0_DP )                  &
   357: ||                      &     + SpecHeatCO2Ice                                         &
   358: ||                      &         * ( xyz_TempCond(i,j,1) - xy_SurfTempCond(i,j) ) )   &
   359: ||                      &     / ( CpDry * xyz_DelAtmMass(i,j,k) )                      &
   360: ||                      &     * xy_FallingIce(i,j)
   361: ||                 end if
   362: |V----- A          end do
   363: +------         end do
   364:             
   365:             
   366:                 ! 温度変化率
   367:                 ! Calculate temperature tendency
   368:                 !
   369: W**==== A       xyz_DTempDt = ( xyz_Temp - xyz_TempB ) / ( 2.0_DP * DelTime )
   370:             
   371:             
   372:                 !
   373:                 ! Surface major component ice adjustment
   374:                 !
   375: W*=====         xy_DSurfMajCompIceDt = 0.0_DP
   376: +------>        do k = kmax, 1, -1
   377: |W*==== A         xy_DSurfMajCompIceDt = xy_DSurfMajCompIceDt + xyz_DelMajCompIce(:,:,k)
   378: +------         end do
   379: *W----->A       xy_DSurfMajCompIceDt = xy_DSurfMajCompIceDt + xy_DelSurfMajCompIce(i,j)
   380: ||              !
   381: ||      A       xy_SurfMajCompIce = xy_SurfMajCompIce &
   382: ||                & + xy_DSurfMajCompIceDt * ( 2.0_DP * DelTime )
   383: ||          
   384: ||          
   385: ||              !
   386: ||              ! Surface pressure adjustment
   387: ||              !
   388: *W----- A       xy_Ps = xy_Ps - xy_DSurfMajCompIceDt * Grav * ( 2.0_DP * DelTime )
   389:             
   390:             
   391:                 ! ヒストリデータ出力
   392:                 ! History data output
   393:                 !
   394:                 call HistoryAutoPut( TimeN, 'DTempDtMajCompPhaseChange', xyz_DTempDt )
   395:             
   396:             
   397:                 ! 計算時間計測一時停止
   398:                 ! Pause measurement of computation time
   399:                 !
   400:                 call TimesetClockStop( module_name )
   401:             
   402:               end subroutine MajorCompPhaseChangeInAtmTest
   403:             
   404:               !--------------------------------------------------------------------------------------
   405:             
   406:               subroutine MajorCompPhaseChangeInAtmBK(   &
   407:                 & xyr_Press, xyz_Press,               &  ! (in)
   408:                 & xy_Ps, xyz_Temp, xy_SurfMajCompIce  &  ! (inout)
   409:                 & )
   410:                 !
   411:                 ! CO2 相変化
   412:                 !
   413:                 ! CO2 phase change
   414:                 !
   415:             
   416:                 ! モジュール引用 ; USE statements
   417:                 !
   418:             
   419:                 ! 時刻管理
   420:                 ! Time control
   421:                 !
   422:                 use timeset, only: &
   423:                   & DelTime, &            ! $ \Delta t $
   424:                   & TimeN, &              ! ステップ $ t $ の時刻. Time of step $ t $. 
   425:                   & TimesetClockStart, TimesetClockStop
   426:             
   427:                 ! ヒストリデータ出力
   428:                 ! History data output
   429:                 !
   430:                 use gtool_historyauto, only: HistoryAutoPut
   431:             
   432:                 ! 物理定数設定
   433:                 ! Physical constants settings
   434:                 !
   435:                 use constants, only: &
   436:                   & Grav, &               ! $ g $ [m s-2].
   437:                                           ! 重力加速度.
   438:                                           ! Gravitational acceleration
   439:                   & CpDry
   440:                                           ! $ C_p $ [J kg-1 K-1].
   441:                                           ! 乾燥大気の定圧比熱.
   442:                                           ! Specific heat of air at constant pressure
   443:             
   444:                 ! 主成分相変化
   445:                 ! Phase change of atmospheric major component
   446:                 !
   447:                 use saturate_major_comp, only :    &
   448:                   & SaturateMajorCompCondTemp,     &
   449:                   & SaturateMajorCompInqLatentHeat
   450:             
   451:             
   452:                 ! 宣言文 ; Declaration statements
   453:                 !
   454:                 implicit none
   455:             
   456:                 real(DP), intent(in   ):: xyr_Press (0:imax-1, 1:jmax, 0:kmax)
   457:                                           ! $ \hat{p} $ . 気圧 (半整数レベル). 
   458:                                           ! Air pressure (half level)
   459:                 real(DP), intent(in   ):: xyz_Press (0:imax-1, 1:jmax, 1:kmax)
   460:                                           ! $ p $ . 気圧 (整数レベル). 
   461:                                           ! Air pressure (full level)
   462:                 real(DP), intent(inout):: xy_Ps            (0:imax-1, 1:jmax)
   463:                                           ! $ T $ .     温度. Temperature
   464:                 real(DP), intent(inout):: xyz_Temp         (0:imax-1, 1:jmax, 1:kmax)
   465:                                           ! $ T $ .     温度. Temperature
   466:                 real(DP), intent(inout):: xy_SurfMajCompIce(0:imax-1, 1:jmax)
   467:                                           !
   468:                                           ! Surface major component ice amount
   469:             
   470:                 ! 作業変数
   471:                 ! Work variables
   472:                 !
   473:                 real(DP):: xyz_TempB           (0:imax-1, 1:jmax, 1:kmax)
   474:                                           ! 調節前の温度. 
   475:                                           ! Temperature before adjustment
   476:                 real(DP):: xyz_DTempDt         (0:imax-1, 1:jmax, 1:kmax)
   477:                                           ! 温度変化率. 
   478:                                           ! Temperature tendency
   479:                 real(DP):: xy_DSurfMajCompIceDt(0:imax-1, 1:jmax)
   480:                                           ! 
   481:                                           ! Surface major component ice tendency
   482:             
   483:                 real(DP):: xyz_TempCond   (0:imax-1, 1:jmax, 1:kmax)
   484:             
   485:                 real(DP):: LatentHeatMajCompSubl
   486:             
   487:                 integer:: i               ! 経度方向に回る DO ループ用作業変数
   488:                                           ! Work variables for DO loop in longitude
   489:                 integer:: j               ! 緯度方向に回る DO ループ用作業変数
   490:                                           ! Work variables for DO loop in latitude
   491:                 integer:: k               ! 鉛直方向に回る DO ループ用作業変数
   492:                                           ! Work variables for DO loop in vertical direction
   493:             
   494:                 logical :: FlagCheckPs
   495:             
   496:             
   497:                 ! 実行文 ; Executable statement
   498:                 !
   499:             
   500:                 ! 初期化
   501:                 ! Initialization
   502:                 !
   503:                 if ( .not. major_comp_phase_change_inited ) then
   504:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   505:                 end if
   506:             
   507:             
   508:                 if ( .not. FlagMajCompPhaseChange ) return
   509:             
   510:             
   511:                 ! 計算時間計測開始
   512:                 ! Start measurement of computation time
   513:                 !
   514:                 call TimesetClockStart( module_name )
   515:             
   516:             
   517:                 ! Set latent heat
   518:                 LatentHeatMajCompSubl = SaturateMajorCompInqLatentHeat()
   519:             
   520:             
   521:                 FlagCheckPs = .false.
   522: W------>        do j = 1, jmax
   523: |*----->          do i = 0, imax-1
   524: ||      A           if ( xyr_Press(i,j,0) > 1.0e4_DP ) then
   525: ||                    FlagCheckPs = .true.
   526: ||                  end if
   527: |*-----           end do
   528: W------         end do
   529:                 if ( FlagCheckPs ) then
   530:                   call MessageNotify( 'W', module_name, 'Surface pressure is greater than 10000 Pa.' )
   531:                 end if
   532:             
   533:             
   534:                 ! 調節前 "Temp" の保存
   535:                 ! Store "Temp" before adjustment
   536:                 !
   537: W**==== A       xyz_TempB    = xyz_Temp
   538:             
   539:             
   540:                 call SaturateMajorCompCondTemp( &
   541:                   & xyz_Press,                  & ! (in)
   542:                   & xyz_TempCond                & ! (inout)
   543:                   & )
   544:             
   545:             
   546: W------>        do k = 1, kmax
   547: |*----->          do j = 1, jmax
   548: ||*---->            do i = 0, imax-1
   549: |||     A             if ( xyz_Temp(i,j,k) < xyz_TempCond(i,j,k) ) then
   550: |||     A               xyz_Temp(i,j,k) = xyz_TempCond(i,j,k)
   551: |||                   end if
   552: ||*----             end do
   553: |*-----           end do
   554: W------         end do
   555:             
   556:                 ! 温度変化率
   557:                 ! Calculate temperature tendency
   558:                 !
   559: W**==== A       xyz_DTempDt = ( xyz_Temp - xyz_TempB ) / ( 2.0_DP * DelTime )
   560:             
   561:             
   562:                 !
   563:                 ! Surface major component ice adjustment
   564:                 !
   565: W*=====         xy_DSurfMajCompIceDt = 0.0_DP
   566: +------>        do k = kmax, 1, -1
   567: |W*==== A         xy_DSurfMajCompIceDt = xy_DSurfMajCompIceDt                    &
   568: |                   & + CpDry * xyz_DTempDt(:,:,k)                               &
   569: |                   &   * ( xyr_Press(:,:,k-1) - xyr_Press(:,:,k) ) / Grav       &
   570: |                   &   / LatentHeatMajCompSubl
   571: +------         end do
   572: *W----->A       xy_SurfMajCompIce = xy_SurfMajCompIce + xy_DSurfMajCompIceDt * ( 2.0_DP * DelTime )
   573: ||          
   574: ||          
   575: ||              !
   576: ||              ! Surface pressure adjustment
   577: ||              !
   578: *W----- A       xy_Ps = xy_Ps - xy_DSurfMajCompIceDt * Grav * ( 2.0_DP * DelTime )
   579:             
   580:             
   581:                 ! ヒストリデータ出力
   582:                 ! History data output
   583:                 !
   584:                 call HistoryAutoPut( TimeN, 'DTempDtMajCompPhaseChange', xyz_DTempDt )
   585:             
   586:             
   587:                 ! 計算時間計測一時停止
   588:                 ! Pause measurement of computation time
   589:                 !
   590:                 call TimesetClockStop( module_name )
   591:             
   592:               end subroutine MajorCompPhaseChangeInAtmBK
   593:             
   594:               !--------------------------------------------------------------------------------------
   595:             
   596:               subroutine MajorCompPhaseChangeInAtmBK2(              &
   597:                 & xyr_Press, xyz_Press,                          & ! (in)
   598:                 & xy_Ps, xyz_Temp, xyzf_QMix, xy_SurfMajCompIce  & ! (inout)
   599:                 & )
   600:                 !
   601:                 ! CO2 相変化
   602:                 !
   603:                 ! CO2 phase change
   604:                 !
   605:             
   606:                 ! モジュール引用 ; USE statements
   607:                 !
   608:             
   609:                 ! 時刻管理
   610:                 ! Time control
   611:                 !
   612:                 use timeset, only: &
   613:                   & DelTime, &            ! $ \Delta t $
   614:                   & TimeN, &              ! ステップ $ t $ の時刻. Time of step $ t $. 
   615:                   & TimesetClockStart, TimesetClockStop
   616:             
   617:                 ! ヒストリデータ出力
   618:                 ! History data output
   619:                 !
   620:                 use gtool_historyauto, only: HistoryAutoPut
   621:             
   622:                 ! 組成に関わる配列の設定
   623:                 ! Settings of array for atmospheric composition
   624:                 !
   625:                 use composition, only : &
   626:                   & ncmax, &
   627:                   & IndexTKE
   628:             
   629:                 ! 物理定数設定
   630:                 ! Physical constants settings
   631:                 !
   632:                 use constants, only: &
   633:                   & Grav, &               ! $ g $ [m s-2].
   634:                                           ! 重力加速度.
   635:                                           ! Gravitational acceleration
   636:                   & CpDry
   637:                                           ! $ C_p $ [J kg-1 K-1].
   638:                                           ! 乾燥大気の定圧比熱.
   639:                                           ! Specific heat of air at constant pressure
   640:             
   641:                 ! 温度の半整数σレベルの補間, 気圧と高度の算出
   642:                 ! Interpolate temperature on half sigma level, 
   643:                 ! and calculate pressure and height
   644:                 !
   645:                 use auxiliary, only: AuxVars
   646:             
   647:                 ! 主成分相変化
   648:                 ! Phase change of atmospheric major component
   649:                 !
   650:                 use saturate_major_comp, only :    &
   651:                   & SaturateMajorCompCondTemp,     &
   652:                   & SaturateMajorCompInqLatentHeat
   653:             
   654:                 ! 質量の補正
   655:                 ! Mass fixer
   656:                 !
   657:                 use mass_fixer, only: MassFixerColumn
   658:             
   659:                 ! 宣言文 ; Declaration statements
   660:                 !
   661:                 implicit none
   662:             
   663:                 real(DP), intent(in   ):: xyr_Press (0:imax-1, 1:jmax, 0:kmax)
   664:                                           ! $ \hat{p} $ . 気圧 (半整数レベル). 
   665:                                           ! Air pressure (half level)
   666:                 real(DP), intent(in   ):: xyz_Press (0:imax-1, 1:jmax, 1:kmax)
   667:                                           ! $ p $ . 気圧 (整数レベル). 
   668:                                           ! Air pressure (full level)
   669:                 real(DP), intent(inout):: xy_Ps            (0:imax-1, 1:jmax)
   670:                                           ! $ T $ .     温度. Temperature
   671:                 real(DP), intent(inout):: xyz_Temp         (0:imax-1, 1:jmax, 1:kmax)
   672:                                           ! $ T $ .     温度. Temperature
   673:                 real(DP), intent(inout):: xyzf_QMix        (0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
   674:                 real(DP), intent(inout):: xy_SurfMajCompIce(0:imax-1, 1:jmax)
   675:                                           !
   676:                                           ! Surface major component ice amount
   677:             
   678:                 ! 作業変数
   679:                 ! Work variables
   680:                 !
   681:                 real(DP):: LatentHeatMajCompSubl
   682:             
   683:                 real(DP):: xy_PsB              (0:imax-1, 1:jmax)
   684:                 real(DP):: xy_PsA              (0:imax-1, 1:jmax)
   685:                 real(DP):: xyr_PressB          (0:imax-1, 1:jmax, 0:kmax)
   686:                 real(DP):: xyr_PressA          (0:imax-1, 1:jmax, 0:kmax)
   687:             
   688:                 real(DP):: xyz_TempB           (0:imax-1, 1:jmax, 1:kmax)
   689:                                           ! 調節前の温度. 
   690:                                           ! Temperature before adjustment
   691:                 real(DP):: xyzf_QMixB          (0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
   692:             
   693:             
   694:                 real(DP):: xyz_TempTmp         (0:imax-1, 1:jmax, 1:kmax)
   695:                 real(DP):: xyz_QH2OVapTmp      (0:imax-1, 1:jmax, 1:kmax)
   696:             
   697:                 real(DP):: xyz_DTempDt         (0:imax-1, 1:jmax, 1:kmax)
   698:                                           ! 温度変化率. 
   699:                                           ! Temperature tendency
   700:                 real(DP):: xy_DSurfMajCompIceDt(0:imax-1, 1:jmax)
   701:                                           ! 
   702:                                           ! Surface major component ice tendency
   703:                 real(DP):: xy_DPsDt            (0:imax-1, 1:jmax)
   704:             
   705:                 real(DP):: xy_DSurfMajCompIceDtOneLayer(0:imax-1, 1:jmax)
   706:                 real(DP):: xyr_DPressDt                (0:imax-1, 1:jmax, 0:kmax)
   707:             
   708:                 real(DP):: xyz_TempCond   (0:imax-1, 1:jmax, 1:kmax)
   709:             
   710:                 integer :: mmax
   711:                 real(DP):: xyza_Array       (0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
   712:                 logical :: a_FlagSurfaceSink(1:ncmax)
   713:                 real(DP):: xyra_MassFlow    (0:imax-1, 1:jmax, 0:kmax, 1:ncmax)
   714:             
   715:                 real(DP):: xyrf_MassFlow    (0:imax-1, 1:jmax, 0:kmax, 1:ncmax)
   716:             
   717:                 real(DP):: xyz_DelAtmMassB   (0:imax-1, 1:jmax, 1:kmax)
   718:                 real(DP):: xyz_DelAtmMassA   (0:imax-1, 1:jmax, 1:kmax)
   719:             
   720:                 integer:: i               ! 経度方向に回る DO ループ用作業変数
   721:                                           ! Work variables for DO loop in longitude
   722:                 integer:: j               ! 緯度方向に回る DO ループ用作業変数
   723:                                           ! Work variables for DO loop in latitude
   724:                 integer:: k               ! 鉛直方向に回る DO ループ用作業変数
   725:                                           ! Work variables for DO loop in vertical direction
   726:                 integer:: m
   727:                 integer:: n
   728:             
   729:                 logical :: FlagCheckPs
   730:             
   731:             
   732:                 ! 実行文 ; Executable statement
   733:                 !
   734:             
   735:                 ! 初期化
   736:                 ! Initialization
   737:                 !
   738:                 if ( .not. major_comp_phase_change_inited ) then
   739:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   740:                 end if
   741:             
   742:             
   743:                 if ( .not. FlagMajCompPhaseChange ) return
   744:             
   745:             
   746:                 ! 計算時間計測開始
   747:                 ! Start measurement of computation time
   748:                 !
   749:                 call TimesetClockStart( module_name )
   750:             
   751:             
   752:                 ! Set latent heat
   753:                 LatentHeatMajCompSubl = SaturateMajorCompInqLatentHeat()
   754:             
   755:             
   756:                 FlagCheckPs = .false.
   757: W------>        do j = 1, jmax
   758: |*----->          do i = 0, imax-1
   759: ||      A           if ( xyr_Press(i,j,0) > 1.0e4_DP ) then
   760: ||                    FlagCheckPs = .true.
   761: ||                  end if
   762: |*-----           end do
   763: W------         end do
   764:                 if ( FlagCheckPs ) then
   765:                   call MessageNotify( 'W', module_name, 'Surface pressure is greater than 10000 Pa.' )
   766:                 end if
   767:             
   768:             
   769:                 ! Store variables
   770:                 !
   771: W**==== A       xyz_TempB  = xyz_Temp
   772: W***=== A       xyzf_QMixB = xyzf_QMix
   773:             
   774:             
   775:                 call SaturateMajorCompCondTemp( &
   776:                   & xyz_Press,                  & ! (in)
   777:                   & xyz_TempCond                & ! (inout)
   778:                   & )
   779:             
   780:             
   781: W------>        do k = 1, kmax
   782: |*----->          do j = 1, jmax
   783: ||*---->            do i = 0, imax-1
   784: |||     A             if ( xyz_Temp(i,j,k) < xyz_TempCond(i,j,k) ) then
   785: |||     A               xyz_Temp(i,j,k) = xyz_TempCond(i,j,k)
   786: |||                   end if
   787: ||*----             end do
   788: |*-----           end do
   789: W------         end do
   790:             
   791:                 ! 温度変化率
   792:                 ! Calculate temperature tendency
   793:                 !
   794: W**==== A       xyz_DTempDt = ( xyz_Temp - xyz_TempB ) / ( 2.0_DP * DelTime )
   795:             
   796:             
   797: W*===== A       xyr_DPressDt(:,:,kmax) = 0.0_DP
   798: +------>        do k = kmax, 1, -1
   799: |*W---->A         xy_DSurfMajCompIceDtOneLayer =                                 &
   800: |||                 &   CpDry * xyz_DTempDt(:,:,k)                               &
   801: |||                 &   * ( xyr_Press(:,:,k-1) - xyr_Press(:,:,k) ) / Grav       &
   802: |||                 &   / LatentHeatMajCompSubl
   803: |*W---- A         xyr_DPressDt(:,:,k-1) = xyr_DPressDt(:,:,k) &
   804: |                   & - xy_DSurfMajCompIceDtOneLayer * Grav
   805: +------         end do
   806:             
   807: *W----->A       xy_DPsDt             = xyr_DPressDt(:,:,0)
   808: *W-----         xy_DSurfMajCompIceDt = - xy_DPsDt / Grav
   809:             
   810:             
   811:             
   812:                 ! packing
   813:                 mmax = ncmax
   814: +------>        do m = 1, mmax
   815: |                 n = m
   816: |W**=== A         xyza_Array(:,:,:,m) = xyzf_QMix(:,:,:,n)
   817: |                 if ( n == IndexTKE ) then
   818: |                   a_FlagSurfaceSink(m) = .true.
   819: |                 else
   820: |                   a_FlagSurfaceSink(m) = .false.
   821: |                 end if
   822: +------         end do
   823:             
   824:                 call MajorCompPhaseChangeCalcFlow( &
   825:                   & xyr_Press, xyr_DPressDt,               & ! (in)
   826:                   & mmax, a_FlagSurfaceSink, xyza_Array,   & ! (in)
   827:                   & xyra_MassFlow                          & ! (out)
   828:                   & )
   829:             
   830:                 ! unpacking
   831: W------>        do m = 1, mmax
   832: |***=== A         xyrf_MassFlow(:,:,:,m) = xyra_MassFlow(:,:,:,m)
   833: W------         end do
   834:             
   835:             
   836:                 ! Adjustment
   837:                 !   preparation
   838: *W----->A       xy_PsB = xy_Ps
   839: *W----- A       xy_PsA = xy_PsB + xy_DPsDt * ( 2.0_DP * DelTime )
   840:             
   841:                 ! 温度の半整数σレベルの補間, 気圧と高度の算出
   842:                 ! Interpolate temperature on half sigma level, 
   843:                 ! and calculate pressure and height
   844:                 !
   845: **W---->A       xyz_TempTmp    = 300.0_DP
   846: **W---- A       xyz_QH2OVapTmp =   0.0_DP
   847:                 call AuxVars( &
   848:                   & xy_PsB, xyz_TempTmp, xyz_QH2OVapTmp,    & ! (in )
   849:                   & xyr_Press = xyr_PressB                  & ! (out) optional
   850:                   & )
   851:                 call AuxVars( &
   852:                   & xy_PsA, xyz_TempTmp, xyz_QH2OVapTmp,    & ! (in )
   853:                   & xyr_Press = xyr_PressA                  & ! (out) optional
   854:                   & )
   855: W------>        do k = 1, kmax
   856: |**---->A         xyz_DelAtmMassB(:,:,k) = ( xyr_PressB(:,:,k-1) - xyr_PressB(:,:,k) ) / Grav
   857: |**---- A         xyz_DelAtmMassA(:,:,k) = ( xyr_PressA(:,:,k-1) - xyr_PressA(:,:,k) ) / Grav
   858: W------         end do
   859:                 !   Atmospheric composition
   860: +------>        do n = 1, ncmax
   861: |W----->          do k = 1, kmax
   862: ||**=== A           xyzf_QMix(:,:,k,n) =                                              &
   863: ||                    &   (   xyz_DelAtmMassB(:,:,k) * xyzf_QMix(:,:,k,n)             &
   864: ||                    &     - ( xyrf_MassFlow(:,:,k,n) - xyrf_MassFlow(:,:,k-1,n) ) ) &
   865: ||                    & / xyz_DelAtmMassA(:,:,k)
   866: |W-----           end do
   867: +------         end do
   868:             
   869:             
   870:                 ! Surface major component ice adjustment
   871: *W----->A       xy_SurfMajCompIce = xy_SurfMajCompIce + xy_DSurfMajCompIceDt * ( 2.0_DP * DelTime )
   872: ||              ! Surface pressure adjustment
   873: *W----- A       xy_Ps = xy_PsA
   874:             
   875:             
   876:                 call AuxVars( &
   877:                   & xy_PsA, xyz_TempTmp, xyz_QH2OVapTmp,    & ! (in )
   878:                   & xyr_Press = xyr_PressA                  & ! (out) optional
   879:                   & )
   880:                 ! 成分の質量の補正
   881:                 ! Fix masses of constituents
   882:                 !
   883:                 call MassFixerColumn( &
   884:                   & xyr_PressA, & ! (in)
   885:                   & xyzf_QMix   & ! (inout)
   886:                   & )
   887:             
   888:                 ! Check
   889:                 call MajorCompPhaseChangeConsChk( &
   890:                   & a_FlagSurfaceSink,            & ! (in)
   891:                   & xyz_DelAtmMassB, xyzf_QMixB,  & ! (in)
   892:                   & xyz_DelAtmMassA, xyzf_QMix    & ! (in)
   893:                   & )
   894:             
   895:                 ! ヒストリデータ出力
   896:                 ! History data output
   897:                 !
   898:                 call HistoryAutoPut( TimeN, 'DTempDtMajCompPhaseChange', xyz_DTempDt )
   899:             
   900:             
   901:                 ! 計算時間計測一時停止
   902:                 ! Pause measurement of computation time
   903:                 !
   904:                 call TimesetClockStop( module_name )
   905:             
   906:               end subroutine MajorCompPhaseChangeInAtmBK2
   907:             
   908:               !--------------------------------------------------------------------------------------
   909:             
   910:               subroutine MajorCompPhaseChangeInAtm(              &
   911:                 & xyr_Press, xyz_Press,                          & ! (in)
   912:                 & xy_Ps, xyz_Temp, xyzf_QMix, xyz_U, xyz_V,      & ! (inout)
   913:                 & xy_SurfMajCompIce                              & ! (inout)
   914:                 & )
   915:                 !
   916:                 ! CO2 相変化
   917:                 !
   918:                 ! CO2 phase change
   919:                 !
   920:             
   921:                 ! モジュール引用 ; USE statements
   922:                 !
   923:             
   924:                 ! 時刻管理
   925:                 ! Time control
   926:                 !
   927:                 use timeset, only: &
   928:                   & DelTime, &            ! $ \Delta t $
   929:                   & TimeN, &              ! ステップ $ t $ の時刻. Time of step $ t $. 
   930:                   & TimesetClockStart, TimesetClockStop
   931:             
   932:                 ! ヒストリデータ出力
   933:                 ! History data output
   934:                 !
   935:                 use gtool_historyauto, only: HistoryAutoPut
   936:             
   937:                 ! 組成に関わる配列の設定
   938:                 ! Settings of array for atmospheric composition
   939:                 !
   940:                 use composition, only : &
   941:                   & ncmax, &
   942:                   & IndexTKE
   943:             
   944:                 ! 物理定数設定
   945:                 ! Physical constants settings
   946:                 !
   947:                 use constants, only: &
   948:                   & Grav, &               ! $ g $ [m s-2].
   949:                                           ! 重力加速度.
   950:                                           ! Gravitational acceleration
   951:                   & CpDry
   952:                                           ! $ C_p $ [J kg-1 K-1].
   953:                                           ! 乾燥大気の定圧比熱.
   954:                                           ! Specific heat of air at constant pressure
   955:             
   956:                 ! 温度の半整数σレベルの補間, 気圧と高度の算出
   957:                 ! Interpolate temperature on half sigma level, 
   958:                 ! and calculate pressure and height
   959:                 !
   960:                 use auxiliary, only: AuxVars
   961:             
   962:                 ! 主成分相変化
   963:                 ! Phase change of atmospheric major component
   964:                 !
   965:                 use saturate_major_comp, only :    &
   966:                   & SaturateMajorCompCondTemp,     &
   967:                   & SaturateMajorCompInqLatentHeat
   968:             
   969:                 ! 質量の補正
   970:                 ! Mass fixer
   971:                 !
   972:                 use mass_fixer, only: MassFixerColumn
   973:             
   974:                 ! 宣言文 ; Declaration statements
   975:                 !
   976:                 implicit none
   977:             
   978:                 real(DP), intent(in   ):: xyr_Press (0:imax-1, 1:jmax, 0:kmax)
   979:                                           ! $ \hat{p} $ . 気圧 (半整数レベル). 
   980:                                           ! Air pressure (half level)
   981:                 real(DP), intent(in   ):: xyz_Press (0:imax-1, 1:jmax, 1:kmax)
   982:                                           ! $ p $ . 気圧 (整数レベル). 
   983:                                           ! Air pressure (full level)
   984:                 real(DP), intent(inout):: xy_Ps            (0:imax-1, 1:jmax)
   985:                                           ! $ T $ .     温度. Temperature
   986:                 real(DP), intent(inout):: xyz_Temp         (0:imax-1, 1:jmax, 1:kmax)
   987:                                           ! $ T $ .     温度. Temperature
   988:                 real(DP), intent(inout):: xyzf_QMix        (0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
   989:                 real(DP), intent(inout):: xyz_U            (0:imax-1, 1:jmax, 1:kmax)
   990:                 real(DP), intent(inout):: xyz_V            (0:imax-1, 1:jmax, 1:kmax)
   991:                 real(DP), intent(inout):: xy_SurfMajCompIce(0:imax-1, 1:jmax)
   992:                                           !
   993:                                           ! Surface major component ice amount
   994:             
   995:                 ! 作業変数
   996:                 ! Work variables
   997:                 !
   998:                 real(DP):: LatentHeatMajCompSubl
   999:             
  1000:                 real(DP):: xy_PsB              (0:imax-1, 1:jmax)
  1001:                 real(DP):: xy_PsA              (0:imax-1, 1:jmax)
  1002:                 real(DP):: xyr_PressB          (0:imax-1, 1:jmax, 0:kmax)
  1003:                 real(DP):: xyr_PressA          (0:imax-1, 1:jmax, 0:kmax)
  1004:             
  1005:                 real(DP):: xyz_TempB           (0:imax-1, 1:jmax, 1:kmax)
  1006:                                           ! 調節前の温度. 
  1007:                                           ! Temperature before adjustment
  1008:                 real(DP):: xyzf_QMixB          (0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
  1009:             
  1010:                 real(DP):: xyz_DelAtmMass      (0:imax-1, 1:jmax, 1:kmax)
  1011:                 real(DP):: xy_TempTmp          (0:imax-1, 1:jmax)
  1012:                 real(DP):: xy_DTempDtSubl      (0:imax-1, 1:jmax)
  1013:                 real(DP):: xy_DTempDtCond      (0:imax-1, 1:jmax)
  1014:                 real(DP):: xyr_AtmMassFallFlux (0:imax-1, 1:jmax, 0:kmax)
  1015:             
  1016:                 real(DP):: xyz_TempTmp         (0:imax-1, 1:jmax, 1:kmax)
  1017:                 real(DP):: xyz_QH2OVapTmp      (0:imax-1, 1:jmax, 1:kmax)
  1018:             
  1019:                 real(DP):: xyz_DTempDt         (0:imax-1, 1:jmax, 1:kmax)
  1020:                                           ! 温度変化率. 
  1021:                                           ! Temperature tendency
  1022:                 real(DP):: xy_DSurfMajCompIceDt(0:imax-1, 1:jmax)
  1023:                                           ! 
  1024:                                           ! Surface major component ice tendency
  1025:                 real(DP):: xy_DPsDt            (0:imax-1, 1:jmax)
  1026:             
  1027:                 real(DP):: xy_DSurfMajCompIceDtOneLayer(0:imax-1, 1:jmax)
  1028:                 real(DP):: xyr_DPressDt                (0:imax-1, 1:jmax, 0:kmax)
  1029:             
  1030:                 real(DP):: xyz_TempCond   (0:imax-1, 1:jmax, 1:kmax)
  1031:             
  1032:                 integer :: mmax
  1033:                 real(DP):: xyza_Array       (0:imax-1, 1:jmax, 1:kmax, 1:ncmax+1+1)
  1034:                 logical :: a_FlagSurfaceSink                          (1:ncmax+1+1)
  1035:                 real(DP):: xyra_MassFlow    (0:imax-1, 1:jmax, 0:kmax, 1:ncmax+1+1)
  1036:             
  1037:                 real(DP):: xyrf_MassFlow    (0:imax-1, 1:jmax, 0:kmax, 1:ncmax)
  1038:                 real(DP):: xyr_MomXFlow     (0:imax-1, 1:jmax, 0:kmax)
  1039:                 real(DP):: xyr_MomYFlow     (0:imax-1, 1:jmax, 0:kmax)
  1040:             
  1041:                 real(DP):: xyz_DelAtmMassB   (0:imax-1, 1:jmax, 1:kmax)
  1042:                 real(DP):: xyz_DelAtmMassA   (0:imax-1, 1:jmax, 1:kmax)
  1043:             
  1044:                 integer:: i               ! 経度方向に回る DO ループ用作業変数
  1045:                                           ! Work variables for DO loop in longitude
  1046:                 integer:: j               ! 緯度方向に回る DO ループ用作業変数
  1047:                                           ! Work variables for DO loop in latitude
  1048:                 integer:: k               ! 鉛直方向に回る DO ループ用作業変数
  1049:                                           ! Work variables for DO loop in vertical direction
  1050:                 integer:: m
  1051:                 integer:: n
  1052:             
  1053:                 logical :: FlagCheckPs
  1054:             
  1055:             
  1056:                 ! 実行文 ; Executable statement
  1057:                 !
  1058:             
  1059:                 ! 初期化
  1060:                 ! Initialization
  1061:                 !
  1062:                 if ( .not. major_comp_phase_change_inited ) then
  1063:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
  1064:                 end if
  1065:             
  1066:             
  1067:                 if ( .not. FlagMajCompPhaseChange ) return
  1068:             
  1069:             
  1070:                 ! 計算時間計測開始
  1071:                 ! Start measurement of computation time
  1072:                 !
  1073:                 call TimesetClockStart( module_name )
  1074:             
  1075:             
  1076:                 ! Set latent heat
  1077:                 LatentHeatMajCompSubl = SaturateMajorCompInqLatentHeat()
  1078:             
  1079:             
  1080:                 FlagCheckPs = .false.
  1081: W------>        do j = 1, jmax
  1082: |*----->          do i = 0, imax-1
  1083: ||      A           if ( xyr_Press(i,j,0) > 1.0e4_DP ) then
  1084: ||                    FlagCheckPs = .true.
  1085: ||                  end if
  1086: |*-----           end do
  1087: W------         end do
  1088:                 if ( FlagCheckPs ) then
  1089:                   call MessageNotify( 'W', module_name, 'Surface pressure is greater than 10000 Pa.' )
  1090:                 end if
  1091:             
  1092:             
  1093:                 ! Store variables
  1094:                 !
  1095: ++V==== A       xyz_TempB  = xyz_Temp
  1096: W***=== A       xyzf_QMixB = xyzf_QMix
  1097:             
  1098:             
  1099:                 call SaturateMajorCompCondTemp( &
  1100:                   & xyz_Press,                  & ! (in)
  1101:                   & xyz_TempCond                & ! (inout)
  1102:                   & )
  1103:             
  1104:             
  1105: W------>        do k = 1, kmax
  1106: |**==== A         xyz_DelAtmMass(:,:,k) = ( xyr_Press(:,:,k-1) - xyr_Press(:,:,k) ) / Grav
  1107: W------         end do
  1108:             
  1109: W*=====         xyr_AtmMassFallFlux(:,:,kmax) = 0.0_DP
  1110: +------>        do k = kmax, 1, -1
  1111: |                 ! sublimation of falling condensate
  1112: |           !!$      xy_DTempDtSubl = &
  1113: |           !!$        & - LatentHeatMajCompSubl * xyr_AtmMassFallFlux(:,:,k) &
  1114: |           !!$        &   / ( CpDry * xyz_DelAtmMass(:,:,k) )
  1115: |           !!$      xyz_Temp(:,:,k) = xyz_Temp(:,:,k) + xy_DTempDtSubl * ( 2.0_DP * DelTime )
  1116: |           !!$      xyr_AtmMassFallFlux(:,:,k) = 0.0_DP
  1117: |           
  1118: |                 ! condensation
  1119: |*W---->A         xy_TempTmp = xyz_Temp(:,:,k)
  1120: |||     A         xyz_Temp(:,:,k) = max( xyz_TempCond(:,:,k), xyz_Temp(:,:,k) )
  1121: |||               xy_DTempDtCond = ( xyz_Temp(:,:,k) - xy_TempTmp ) / ( 2.0_DP * DelTime )
  1122: |||               xy_DSurfMajCompIceDtOneLayer =                           &
  1123: |||                 &   CpDry * xyz_DelAtmMass(:,:,k) * xy_DTempDtCond     &
  1124: |||                 &   / LatentHeatMajCompSubl
  1125: |*W---- A         xyr_AtmMassFallFlux(:,:,k-1) = xyr_AtmMassFallFlux(:,:,k) &
  1126: |                   & + xy_DSurfMajCompIceDtOneLayer
  1127: +------         end do
  1128:             
  1129: W**==== A       xyr_DPressDt = - xyr_AtmMassFallFlux * Grav
  1130:             
  1131:             
  1132: *W----->A       xy_DPsDt             = xyr_DPressDt(:,:,0)
  1133: *W-----         xy_DSurfMajCompIceDt = - xy_DPsDt / Grav
  1134:             
  1135:             
  1136:             
  1137:                 ! packing
  1138:                 if ( FlagModMom ) then
  1139:                   mmax = ncmax + 1 + 1
  1140:                 else
  1141:                   mmax = ncmax
  1142:                 end if
  1143: +------>        do m = 1, ncmax
  1144: |                 n = m
  1145: |W**=== A         xyza_Array(:,:,:,m) = xyzf_QMix(:,:,:,n)
  1146: |                 if ( n == IndexTKE ) then
  1147: |                   a_FlagSurfaceSink(m) = .true.
  1148: |                 else
  1149: |                   a_FlagSurfaceSink(m) = .false.
  1150: |                 end if
  1151: +------         end do
  1152:                 if ( FlagModMom ) then
  1153:                   m = ncmax
  1154:                   m = m + 1
  1155: W**==== A         xyza_Array(:,:,:,m) = xyz_U
  1156:                   a_FlagSurfaceSink(m) = .true.
  1157:                   m = m + 1
  1158: W**==== A         xyza_Array(:,:,:,m) = xyz_V
  1159:                   a_FlagSurfaceSink(m) = .true.
  1160:                 end if
  1161:             
  1162:                 call MajorCompPhaseChangeCalcFlow( &
  1163:                   & xyr_Press, xyr_DPressDt,                                     & ! (in)
  1164:                   & mmax, a_FlagSurfaceSink(1:mmax), xyza_Array(:,:,:,1:mmax),   & ! (in)
  1165:                   & xyra_MassFlow(:,:,:,1:mmax)                                  & ! (out)
  1166:                   & )
  1167:             
  1168:                 ! unpacking
  1169: W------>        do m = 1, ncmax
  1170: |***=== A         xyrf_MassFlow(:,:,:,m) = xyra_MassFlow(:,:,:,m)
  1171: W------         end do
  1172:                 if ( FlagModMom ) then
  1173:                   m = ncmax
  1174:                   m = m + 1
  1175: W**==== A         xyr_MomXFlow = xyra_MassFlow(:,:,:,m)
  1176:                   m = m + 1
  1177: W**==== A         xyr_MomYFlow = xyra_MassFlow(:,:,:,m)
  1178:                 end if
  1179:             
  1180:             
  1181:                 ! Adjustment
  1182:                 !   preparation
  1183: *W----->A       xy_PsB = xy_Ps
  1184: *W----- A       xy_PsA = xy_PsB + xy_DPsDt * ( 2.0_DP * DelTime )
  1185:             
  1186:                 ! 温度の半整数σレベルの補間, 気圧と高度の算出
  1187:                 ! Interpolate temperature on half sigma level, 
  1188:                 ! and calculate pressure and height
  1189:                 !
  1190: **W---->A       xyz_TempTmp    = 300.0_DP
  1191: **W---- A       xyz_QH2OVapTmp =   0.0_DP
  1192:                 call AuxVars( &
  1193:                   & xy_PsB, xyz_TempTmp, xyz_QH2OVapTmp,    & ! (in )
  1194:                   & xyr_Press = xyr_PressB                  & ! (out) optional
  1195:                   & )
  1196:                 call AuxVars( &
  1197:                   & xy_PsA, xyz_TempTmp, xyz_QH2OVapTmp,    & ! (in )
  1198:                   & xyr_Press = xyr_PressA                  & ! (out) optional
  1199:                   & )
  1200: W------>        do k = 1, kmax
  1201: |**---->A         xyz_DelAtmMassB(:,:,k) = ( xyr_PressB(:,:,k-1) - xyr_PressB(:,:,k) ) / Grav
  1202: |**---- A         xyz_DelAtmMassA(:,:,k) = ( xyr_PressA(:,:,k-1) - xyr_PressA(:,:,k) ) / Grav
  1203: W------         end do
  1204:                 !   Atmospheric composition
  1205: +------>        do n = 1, ncmax
  1206: |W----->          do k = 1, kmax
  1207: ||**=== A           xyzf_QMix(:,:,k,n) =                                              &
  1208: ||                    &   (   xyz_DelAtmMassB(:,:,k) * xyzf_QMix(:,:,k,n)             &
  1209: ||                    &     - ( xyrf_MassFlow(:,:,k,n) - xyrf_MassFlow(:,:,k-1,n) ) ) &
  1210: ||                    & / xyz_DelAtmMassA(:,:,k)
  1211: |W-----           end do
  1212: +------         end do
  1213:                 if ( FlagModMom ) then
  1214: W------>          do k = 1, kmax
  1215: |                   ! Zonal wind
  1216: |**---->A           xyz_U(:,:,k) =                                              &
  1217: |||                   &   (   xyz_DelAtmMassB(:,:,k) * xyz_U(:,:,k)             &
  1218: |||                   &     - ( xyr_MomXFlow(:,:,k) - xyr_MomXFlow(:,:,k-1) ) ) &
  1219: |||                   & / xyz_DelAtmMassA(:,:,k)
  1220: |||                 ! Meridional wind
  1221: |**---- A           xyz_V(:,:,k) =                                              &
  1222: |                     &   (   xyz_DelAtmMassB(:,:,k) * xyz_V(:,:,k)             &
  1223: |                     &     - ( xyr_MomYFlow(:,:,k) - xyr_MomYFlow(:,:,k-1) ) ) &
  1224: |                     & / xyz_DelAtmMassA(:,:,k)
  1225: W------           end do
  1226:                 end if
  1227:             
  1228:             
  1229:                 ! Surface major component ice adjustment
  1230: *W----->A       xy_SurfMajCompIce = xy_SurfMajCompIce + xy_DSurfMajCompIceDt * ( 2.0_DP * DelTime )
  1231: ||              ! Surface pressure adjustment
  1232: *W----- A       xy_Ps = xy_PsA
  1233:             
  1234:             
  1235:                 call AuxVars( &
  1236:                   & xy_PsA, xyz_TempTmp, xyz_QH2OVapTmp,    & ! (in )
  1237:                   & xyr_Press = xyr_PressA                  & ! (out) optional
  1238:                   & )
  1239:                 ! 成分の質量の補正
  1240:                 ! Fix masses of constituents
  1241:                 !
  1242:                 call MassFixerColumn( &
  1243:                   & xyr_PressA, & ! (in)
  1244:                   & xyzf_QMix   & ! (inout)
  1245:                   & )
  1246:             
  1247:                 ! Check
  1248:                 call MajorCompPhaseChangeConsChk( &
  1249:                   & a_FlagSurfaceSink,            & ! (in)
  1250:                   & xyz_DelAtmMassB, xyzf_QMixB,  & ! (in)
  1251:                   & xyz_DelAtmMassA, xyzf_QMix    & ! (in)
  1252:                   & )
  1253:             
  1254:                 ! ヒストリデータ出力
  1255:                 ! History data output
  1256:                 !
  1257:                 call HistoryAutoPut( TimeN, 'DTempDtMajCompPhaseChange', xyz_DTempDt )
  1258:             
  1259:             
  1260:                 ! 計算時間計測一時停止
  1261:                 ! Pause measurement of computation time
  1262:                 !
  1263:                 call TimesetClockStop( module_name )
  1264:             
  1265:               end subroutine MajorCompPhaseChangeInAtm
  1266:             
  1267:               !--------------------------------------------------------------------------------------
  1268:             
  1269:               subroutine MajorCompPhaseChangeOnGround( &
  1270:                 & xy_DPsDt, xy_DSurfMajCompIceDt,      & ! (in)
  1271:                 & xy_Ps, xyzf_QMix, xyz_U, xyz_V,      & ! (inout)
  1272:                 & xy_SurfMajCompIce                    & ! (inout)
  1273:                 & )
  1274:                 !
  1275:                 ! CO2 相変化
  1276:                 !
  1277:                 ! CO2 phase change
  1278:                 !
  1279:             
  1280:                 ! モジュール引用 ; USE statements
  1281:                 !
  1282:             
  1283:                 ! 時刻管理
  1284:                 ! Time control
  1285:                 !
  1286:                 use timeset, only: &
  1287:                   & DelTime, &            ! $ \Delta t $
  1288:                   & TimeN, &              ! ステップ $ t $ の時刻. Time of step $ t $. 
  1289:                   & TimesetClockStart, TimesetClockStop
  1290:             
  1291:                 ! ヒストリデータ出力
  1292:                 ! History data output
  1293:                 !
  1294:                 use gtool_historyauto, only: HistoryAutoPut
  1295:             
  1296:                 ! 組成に関わる配列の設定
  1297:                 ! Settings of array for atmospheric composition
  1298:                 !
  1299:                 use composition, only : &
  1300:                   & ncmax, &
  1301:                   & IndexTKE
  1302:             
  1303:                 ! 物理定数設定
  1304:                 ! Physical constants settings
  1305:                 !
  1306:                 use constants, only: &
  1307:                   & Grav, &               ! $ g $ [m s-2].
  1308:                                           ! 重力加速度.
  1309:                                           ! Gravitational acceleration
  1310:                   & CpDry
  1311:                                           ! $ C_p $ [J kg-1 K-1].
  1312:                                           ! 乾燥大気の定圧比熱.
  1313:                                           ! Specific heat of air at constant pressure
  1314:             
  1315:                 ! 温度の半整数σレベルの補間, 気圧と高度の算出
  1316:                 ! Interpolate temperature on half sigma level, 
  1317:                 ! and calculate pressure and height
  1318:                 !
  1319:                 use auxiliary, only: AuxVars
  1320:             
  1321:                 ! 質量の補正
  1322:                 ! Mass fixer
  1323:                 !
  1324:                 use mass_fixer, only: MassFixerColumn
  1325:             
  1326:             
  1327:                 ! 宣言文 ; Declaration statements
  1328:                 !
  1329:                 implicit none
  1330:             
  1331:                 real(DP), intent(in   ):: xy_DPsDt            (0:imax-1, 1:jmax)
  1332:                 real(DP), intent(in   ):: xy_DSurfMajCompIceDt(0:imax-1, 1:jmax)
  1333:                 real(DP), intent(inout):: xy_Ps            (0:imax-1, 1:jmax)
  1334:                 real(DP), intent(inout):: xyzf_QMix        (0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
  1335:                 real(DP), intent(inout):: xyz_U            (0:imax-1, 1:jmax, 1:kmax)
  1336:                 real(DP), intent(inout):: xyz_V            (0:imax-1, 1:jmax, 1:kmax)
  1337:                 real(DP), intent(inout):: xy_SurfMajCompIce   (0:imax-1, 1:jmax)
  1338:                                           !
  1339:                                           ! Surface major component ice amount
  1340:             
  1341:                 ! 作業変数
  1342:                 ! Work variables
  1343:                 !
  1344:                 real(DP):: xy_PsB              (0:imax-1, 1:jmax)
  1345:                 real(DP):: xy_PsA              (0:imax-1, 1:jmax)
  1346:                 real(DP):: xyr_PressB          (0:imax-1, 1:jmax, 0:kmax)
  1347:                 real(DP):: xyr_PressA          (0:imax-1, 1:jmax, 0:kmax)
  1348:             
  1349:                 real(DP):: xyzf_QMixB          (0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
  1350:             
  1351:                 real(DP):: xyz_TempTmp         (0:imax-1, 1:jmax, 1:kmax)
  1352:                 real(DP):: xyz_QH2OVapTmp      (0:imax-1, 1:jmax, 1:kmax)
  1353:             
  1354:                 real(DP):: xyr_DPressDt        (0:imax-1, 1:jmax, 0:kmax)
  1355:             
  1356:                 integer :: mmax
  1357:                 real(DP):: xyza_Array       (0:imax-1, 1:jmax, 1:kmax, 1:ncmax+1+1)
  1358:                 logical :: a_FlagSurfaceSink                          (1:ncmax+1+1)
  1359:                 real(DP):: xyra_MassFlow    (0:imax-1, 1:jmax, 0:kmax, 1:ncmax+1+1)
  1360:             
  1361:                 real(DP):: xyrf_MassFlow    (0:imax-1, 1:jmax, 0:kmax, 1:ncmax)
  1362:                 real(DP):: xyr_MomXFlow     (0:imax-1, 1:jmax, 0:kmax)
  1363:                 real(DP):: xyr_MomYFlow     (0:imax-1, 1:jmax, 0:kmax)
  1364:             
  1365:                 real(DP):: xyz_DelAtmMassB   (0:imax-1, 1:jmax, 1:kmax)
  1366:                 real(DP):: xyz_DelAtmMassA   (0:imax-1, 1:jmax, 1:kmax)
  1367:             
  1368:                 integer:: i               ! 経度方向に回る DO ループ用作業変数
  1369:                                           ! Work variables for DO loop in longitude
  1370:                 integer:: j               ! 緯度方向に回る DO ループ用作業変数
  1371:                                           ! Work variables for DO loop in latitude
  1372:                 integer:: k               ! 鉛直方向に回る DO ループ用作業変数
  1373:                                           ! Work variables for DO loop in vertical direction
  1374:                 integer:: m
  1375:                 integer:: n
  1376:             
  1377:             
  1378:                 ! 実行文 ; Executable statement
  1379:                 !
  1380:             
  1381:                 ! 初期化
  1382:                 ! Initialization
  1383:                 !
  1384:                 if ( .not. major_comp_phase_change_inited ) then
  1385:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
  1386:                 end if
  1387:             
  1388:             
  1389:                 if ( .not. FlagMajCompPhaseChange ) return
  1390:             
  1391:             
  1392:                 ! 計算時間計測開始
  1393:                 ! Start measurement of computation time
  1394:                 !
  1395:                 call TimesetClockStart( module_name )
  1396:             
  1397:             
  1398: *W----->A       xy_PsB = xy_Ps
  1399: *W----- A       xy_PsA = xy_PsB + xy_DPsDt * ( 2.0_DP * DelTime )
  1400:             
  1401: W***=== A       xyzf_QMixB = xyzf_QMix
  1402:             
  1403: **W---->A       xyz_TempTmp    = 300.0_DP
  1404: **W---- A       xyz_QH2OVapTmp =   0.0_DP
  1405:             
  1406:                 ! 温度の半整数σレベルの補間, 気圧と高度の算出
  1407:                 ! Interpolate temperature on half sigma level, 
  1408:                 ! and calculate pressure and height
  1409:                 !
  1410:                 call AuxVars( &
  1411:                   & xy_PsB, xyz_TempTmp, xyz_QH2OVapTmp,    & ! (in )
  1412:                   & xyr_Press = xyr_PressB                  & ! (out) optional
  1413:                   & )
  1414:                 call AuxVars( &
  1415:                   & xy_PsA, xyz_TempTmp, xyz_QH2OVapTmp,    & ! (in )
  1416:                   & xyr_Press = xyr_PressA                  & ! (out) optional
  1417:                   & )
  1418:             
  1419:             
  1420: W**==== A       xyr_DPressDt = ( xyr_PressA - xyr_PressB ) / ( 2.0_DP * Deltime )
  1421:             
  1422:             
  1423:                 ! packing
  1424:                 if ( FlagModMom ) then
  1425:                   mmax = ncmax + 1 + 1
  1426:                 else
  1427:                   mmax = ncmax
  1428:                 end if
  1429: +------>        do m = 1, ncmax
  1430: |                 n = m
  1431: |W**=== A         xyza_Array(:,:,:,m) = xyzf_QMix(:,:,:,n)
  1432: |                 if ( n == IndexTKE ) then
  1433: |                   a_FlagSurfaceSink(m) = .true.
  1434: |                 else
  1435: |                   a_FlagSurfaceSink(m) = .false.
  1436: |                 end if
  1437: +------         end do
  1438:                 if ( FlagModMom ) then
  1439:                   m = ncmax
  1440:                   m = m + 1
  1441: W**==== A         xyza_Array(:,:,:,m) = xyz_U
  1442:                   a_FlagSurfaceSink(m) = .true.
  1443:                   m = m + 1
  1444: W**==== A         xyza_Array(:,:,:,m) = xyz_V
  1445:                   a_FlagSurfaceSink(m) = .true.
  1446:                 end if
  1447:             
  1448:                 call MajorCompPhaseChangeCalcFlow( &
  1449:                   & xyr_PressB, xyr_DPressDt,                                    & ! (in)
  1450:                   & mmax, a_FlagSurfaceSink(1:mmax), xyza_Array(:,:,:,1:mmax),   & ! (in)
  1451:                   & xyra_MassFlow(:,:,:,1:mmax)                                  & ! (out)
  1452:                   & )
  1453:             
  1454:                 ! unpacking
  1455: W------>        do m = 1, ncmax
  1456: |***=== A         xyrf_MassFlow(:,:,:,m) = xyra_MassFlow(:,:,:,m)
  1457: W------         end do
  1458:                 if ( FlagModMom ) then
  1459:                   m = ncmax
  1460:                   m = m + 1
  1461: W**==== A         xyr_MomXFlow = xyra_MassFlow(:,:,:,m)
  1462:                   m = m + 1
  1463: W**==== A         xyr_MomYFlow = xyra_MassFlow(:,:,:,m)
  1464:                 end if
  1465:             
  1466:             
  1467:                 ! Adjustment
  1468:                 !   preparation
  1469: W------>        do k = 1, kmax
  1470: |**---->A         xyz_DelAtmMassB(:,:,k) = ( xyr_PressB(:,:,k-1) - xyr_PressB(:,:,k) ) / Grav
  1471: |**---- A         xyz_DelAtmMassA(:,:,k) = ( xyr_PressA(:,:,k-1) - xyr_PressA(:,:,k) ) / Grav
  1472: W------         end do
  1473:                 !   Atmospheric composition
  1474: +------>        do n = 1, ncmax
  1475: |W----->          do k = 1, kmax
  1476: ||**=== A           xyzf_QMix(:,:,k,n) =                                              &
  1477: ||                    &   (   xyz_DelAtmMassB(:,:,k) * xyzf_QMix(:,:,k,n)             &
  1478: ||                    &     - ( xyrf_MassFlow(:,:,k,n) - xyrf_MassFlow(:,:,k-1,n) ) ) &
  1479: ||                    & / xyz_DelAtmMassA(:,:,k)
  1480: |W-----           end do
  1481: +------         end do
  1482:                 if ( FlagModMom ) then
  1483: W------>          do k = 1, kmax
  1484: |                   ! Zonal wind
  1485: |**---->A           xyz_U(:,:,k) =                                              &
  1486: |||                   &   (   xyz_DelAtmMassB(:,:,k) * xyz_U(:,:,k)             &
  1487: |||                   &     - ( xyr_MomXFlow(:,:,k) - xyr_MomXFlow(:,:,k-1) ) ) &
  1488: |||                   & / xyz_DelAtmMassA(:,:,k)
  1489: |||                 ! Meridional wind
  1490: |**---- A           xyz_V(:,:,k) =                                              &
  1491: |                     &   (   xyz_DelAtmMassB(:,:,k) * xyz_V(:,:,k)             &
  1492: |                     &     - ( xyr_MomYFlow(:,:,k) - xyr_MomYFlow(:,:,k-1) ) ) &
  1493: |                     & / xyz_DelAtmMassA(:,:,k)
  1494: W------           end do
  1495:                 end if
  1496:             
  1497:                 !   Surface major component ice
  1498: *W----->A       xy_SurfMajCompIce = xy_SurfMajCompIce + xy_DSurfMajCompIceDt * ( 2.0_DP * DelTime )
  1499: ||              !   Surface pressure
  1500: *W----- A       xy_Ps = xy_PsA
  1501:             
  1502:             
  1503:                 call AuxVars( &
  1504:                   & xy_PsA, xyz_TempTmp, xyz_QH2OVapTmp,    & ! (in )
  1505:                   & xyr_Press = xyr_PressA                  & ! (out) optional
  1506:                   & )
  1507:                 ! 成分の質量の補正
  1508:                 ! Fix masses of constituents
  1509:                 !
  1510:                 call MassFixerColumn( &
  1511:                   & xyr_PressA, & ! (in)
  1512:                   & xyzf_QMix   & ! (inout)
  1513:                   & )
  1514:             
  1515:             
  1516:                 ! Check
  1517:                 call MajorCompPhaseChangeConsChk( &
  1518:                   & a_FlagSurfaceSink,            & ! (in)
  1519:                   & xyz_DelAtmMassB, xyzf_QMixB,  & ! (in)
  1520:                   & xyz_DelAtmMassA, xyzf_QMix    & ! (in)
  1521:                   & )
  1522:             
  1523:             
  1524:                 ! 計算時間計測一時停止
  1525:                 ! Pause measurement of computation time
  1526:                 !
  1527:                 call TimesetClockStop( module_name )
  1528:             
  1529:             
  1530:               end subroutine MajorCompPhaseChangeOnGround
  1531:             
  1532:               !--------------------------------------------------------------------------------------
  1533:             
  1534:               subroutine MajorCompPhaseChangeCalcFlow( &
  1535:                 & xyr_Press, xyr_DPressDt,             & ! (in)
  1536:                 & mmax, a_FlagSurfaceSink, xyza_Array, & ! (in)
  1537:                 & xyra_MassFlow                        & ! (out)
  1538:                 & )
  1539:                 !
  1540:                 ! CO2 相変化
  1541:                 !
  1542:                 ! CO2 phase change
  1543:                 !
  1544:             
  1545:                 ! モジュール引用 ; USE statements
  1546:                 !
  1547:             
  1548:                 ! 時刻管理
  1549:                 ! Time control
  1550:                 !
  1551:                 use timeset, only: &
  1552:                   & DelTime               ! $ \Delta t $
  1553:             
  1554:                 ! 物理定数設定
  1555:                 ! Physical constants settings
  1556:                 !
  1557:                 use constants, only: &
  1558:                   & Grav                  ! $ g $ [m s-2].
  1559:                                           ! 重力加速度.
  1560:                                           ! Gravitational acceleration
  1561:             
  1562:                 ! 宣言文 ; Declaration statements
  1563:                 !
  1564:                 implicit none
  1565:             
  1566:                 real(DP), intent(in ):: xyr_Press    (0:imax-1, 1:jmax, 0:kmax)
  1567:                                           ! pressure
  1568:                 real(DP), intent(in ):: xyr_DPressDt (0:imax-1, 1:jmax, 0:kmax)
  1569:                 integer , intent(in ):: mmax
  1570:                 logical , intent(in ):: a_FlagSurfaceSink(1:mmax)
  1571:                 real(DP), intent(in ):: xyza_Array   (0:imax-1, 1:jmax, 1:kmax, 1:mmax)
  1572:                 real(DP), intent(out):: xyra_MassFlow(0:imax-1, 1:jmax, 0:kmax, 1:mmax)
  1573:             
  1574:                 ! 作業変数
  1575:                 ! Work variables
  1576:                 !
  1577:                 real(DP):: xyr_DPPress  (0:imax-1, 1:jmax, 0:kmax)
  1578:                                           ! pressure at departure point
  1579:                 real(DP):: DelAtmMass
  1580:                 integer:: i               ! 経度方向に回る DO ループ用作業変数
  1581:                                           ! Work variables for DO loop in longitude
  1582:                 integer:: j               ! 緯度方向に回る DO ループ用作業変数
  1583:                                           ! Work variables for DO loop in latitude
  1584:                 integer:: k               ! 鉛直方向に回る DO ループ用作業変数
  1585:                                           ! Work variables for DO loop in vertical direction
  1586:                 integer:: k2              ! 鉛直方向に回る DO ループ用作業変数
  1587:                                           ! Work variables for DO loop in vertical direction
  1588:                 integer:: m
  1589:             
  1590:             
  1591:                 ! 実行文 ; Executable statement
  1592:                 !
  1593:             
  1594:                 ! 初期化
  1595:                 ! Initialization
  1596:                 !
  1597:                 if ( .not. major_comp_phase_change_inited ) then
  1598:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
  1599:                 end if
  1600:             
  1601:             
  1602:                 if ( .not. FlagMajCompPhaseChange ) return
  1603:             
  1604:             
  1605: W**==== A       xyr_DPPress = xyr_Press + xyr_DPressDt * ( 2.0_DP * DelTime )
  1606:             
  1607:                 ! check
  1608: +------>        do k = 1, kmax
  1609: |+----->          do j = 1, jmax
  1610: ||+---->            do i = 0, imax-1
  1611: |||                   if ( xyr_DPPress(i,j,k-1) < xyr_DPPress(i,j,k) ) then
  1612: |||                     call MessageNotify( 'E', module_name, 'Order of departure points are inappropriate, P(k=%d)=%f < P(k=%d)=%f.', &
  1613: |||                       & i = (/ k-1, k /), d = (/ xyr_DPPress(i,j,k-1), xyr_DPPress(i,j,k) /) )
  1614: |||                   end if
  1615: ||+----             end do
  1616: |+-----           end do
  1617: +------         end do
  1618:             
  1619: W***=== A       xyra_MassFlow = 0.0_DP
  1620: +------>        do k = 0, kmax-1
  1621: |+----->          do j = 1, jmax
  1622: ||+---->            do i = 0, imax-1
  1623: |||         
  1624: |||         !!$          if ( xyr_DPressDt(i,j,k) >= 0.0_DP ) then
  1625: |||                   if ( xyr_DPPress(i,j,k) > xyr_Press(i,j,k) ) then
  1626: |||         
  1627: |||+--->                sum_upward_mass_transport : do k2 = k, 1, -1
  1628: ||||                      if ( xyr_DPPress(i,j,k) > xyr_Press(i,j,k2-1) ) then
  1629: ||||                        DelAtmMass = ( xyr_Press(i,j,k2-1) - xyr_Press(i,j,k2) ) / Grav
  1630: ||||V-->                    do m = 1, mmax
  1631: |||||   A                     xyra_MassFlow(i,j,k,m) = xyra_MassFlow(i,j,k,m) &
  1632: |||||                           & + xyza_Array(i,j,k2,m) * DelAtmMass
  1633: ||||V--                     end do
  1634: ||||                      else
  1635: ||||                        DelAtmMass = ( xyr_DPPress(i,j,k) - xyr_Press(i,j,k2) ) / Grav
  1636: ||||V-->                    do m = 1, mmax
  1637: |||||   A                     xyra_MassFlow(i,j,k,m) = xyra_MassFlow(i,j,k,m) &
  1638: |||||                           & + xyza_Array(i,j,k2,m) * DelAtmMass
  1639: ||||V--                     end do
  1640: ||||                        exit sum_upward_mass_transport
  1641: ||||                      end if
  1642: |||+---                 end do sum_upward_mass_transport
  1643: |||         
  1644: |||                   else
  1645: |||         
  1646: |||+--->                sum_downward_mass_transport : do k2 = k+1, kmax
  1647: ||||                      if ( xyr_DPPress(i,j,k) < xyr_Press(i,j,k2  ) ) then
  1648: ||||                        DelAtmMass = ( xyr_Press(i,j,k2-1) - xyr_Press(i,j,k2) ) / Grav
  1649: ||||V-->                    do m = 1, mmax
  1650: |||||   A                     xyra_MassFlow(i,j,k,m) = xyra_MassFlow(i,j,k,m) &
  1651: |||||                           & - xyza_Array(i,j,k2,m) * DelAtmMass
  1652: ||||V--                     end do
  1653: ||||                      else
  1654: ||||                        DelAtmMass = ( xyr_Press(i,j,k2-1) - xyr_DPPress(i,j,k) ) / Grav
  1655: ||||V-->                    do m = 1, mmax
  1656: |||||   A                     xyra_MassFlow(i,j,k,m) = xyra_MassFlow(i,j,k,m) &
  1657: |||||                           & - xyza_Array(i,j,k2,m) * DelAtmMass
  1658: ||||V--                     end do
  1659: ||||                        exit sum_downward_mass_transport
  1660: ||||                      end if
  1661: |||+---                 end do sum_downward_mass_transport
  1662: |||         
  1663: |||                   end if
  1664: |||         
  1665: ||+----             end do
  1666: |+-----           end do
  1667: |           
  1668: +------         end do
  1669:             
  1670:             
  1671: *------>        do k = 0, 0
  1672: |+----->          do j = 1, jmax
  1673: ||+---->            do i = 0, imax-1
  1674: |||         
  1675: |||                   ! not surface sink
  1676: |||                   if ( xyr_DPressDt(i,j,k) <= 0.0_DP ) then
  1677: |||V--->                do m = 1, mmax
  1678: ||||    A                 if ( .not. a_FlagSurfaceSink(m) ) then
  1679: ||||    A                   xyra_MassFlow(i,j,k,m) = 0.0_DP
  1680: ||||                      end if
  1681: |||V---                 end do
  1682: |||                   end if
  1683: |||         
  1684: ||+----             end do
  1685: |+-----           end do
  1686: |           
  1687: *------         end do
  1688:             
  1689:             
  1690:             
  1691:               end subroutine MajorCompPhaseChangeCalcFlow
  1692:             
  1693:               !--------------------------------------------------------------------------------------
  1694:             
  1695:               subroutine MajorCompPhaseChangeConsChk( &
  1696:                 & a_FlagSurfaceSink,                  & ! (in)
  1697:                 & xyz_DelAtmMassB, xyzf_QMixB,        & ! (in)
  1698:                 & xyz_DelAtmMassA, xyzf_QMixA         & ! (in)
  1699:                 & )
  1700:             
  1701:                 ! 組成に関わる配列の設定
  1702:                 ! Settings of array for atmospheric composition
  1703:                 !
  1704:                 use composition, only : ncmax
  1705:             
  1706:                 ! 物理定数設定
  1707:                 ! Physical constants settings
  1708:                 !
  1709:                 use constants, only: &
  1710:                   & Grav, &
  1711:                                           ! $ g $ [m s-2].
  1712:                                           ! 重力加速度.
  1713:                                           ! Gravitational acceleration
  1714:                   & CpDry
  1715:                                           ! $ C_p $ [J kg-1 K-1].
  1716:                                           ! 乾燥大気の定圧比熱.
  1717:                                           ! Specific heat of air at constant pressure
  1718:             
  1719:                 logical , intent(in) :: a_FlagSurfaceSink(1:ncmax)
  1720:                 real(DP), intent(in) :: xyz_DelAtmMassB(0:imax-1, 1:jmax, 1:kmax)
  1721:                 real(DP), intent(in) :: xyzf_QMixB     (0:imax-1, 1:jmax, 1:kmax, ncmax)
  1722:                 real(DP), intent(in) :: xyz_DelAtmMassA(0:imax-1, 1:jmax, 1:kmax)
  1723:                 real(DP), intent(in) :: xyzf_QMixA     (0:imax-1, 1:jmax, 1:kmax, ncmax)
  1724:             
  1725:                 ! Local variables
  1726:                 !
  1727:                 real(DP) :: ValB
  1728:                 real(DP) :: ValA
  1729:                 real(DP) :: xyf_SumB(0:imax-1, 1:jmax, 1:ncmax)
  1730:                 real(DP) :: xyf_SumA(0:imax-1, 1:jmax, 1:ncmax)
  1731:                 real(DP) :: Ratio
  1732:                 integer  :: i
  1733:                 integer  :: j
  1734:                 integer  :: k
  1735:                 integer  :: n
  1736:             
  1737:             
  1738: **W---->        xyf_SumB = 0.0_DP
  1739: **W----         xyf_SumA = 0.0_DP
  1740: +------>        do n = 1, ncmax
  1741: |+----->          do k = kmax, 1, -1
  1742: ||*W--->A           xyf_SumB(:,:,n) = xyf_SumB(:,:,n) &
  1743: ||||                  & + xyz_DelAtmMassB(:,:,k) * xyzf_QMixB(:,:,k,n)
  1744: ||*W--- A           xyf_SumA(:,:,n) = xyf_SumA(:,:,n) &
  1745: ||                    & + xyz_DelAtmMassA(:,:,k) * xyzf_QMixA(:,:,k,n)
  1746: |+-----           end do
  1747: +------         end do
  1748: +------>        do n = 1, ncmax
  1749: |                 if ( .not. a_FlagSurfaceSink(n) ) then
  1750: |+----->            do j = 1, jmax
  1751: ||+---->              do i = 0, imax-1
  1752: |||                     ValB = xyf_SumB(i,j,n)
  1753: |||                     ValA = xyf_SumA(i,j,n)
  1754: |||         
  1755: |||                     Ratio = ( ValA - ValB ) / ( ValA + 1.0d-100 )
  1756: |||                     if ( abs( Ratio ) > 1.0d-10 ) then
  1757: |||                       if ( ( ValB < 0.0_DP ) .and. ( abs( ValB ) < 1.0e-20_DP ) ) then
  1758: |||                         ! Do nothing
  1759: |||                       else
  1760: |||                         call MessageNotify( 'M', module_name, 'Mass No. %d is not conserved, %f.', i = (/ n /), d = (/ Ratio /) )
  1761: |||                       end if
  1762: |||                     end if
  1763: ||+----               end do
  1764: |+-----             end do
  1765: |                 end if
  1766: +------         end do
  1767:             
  1768:             
  1769:               end subroutine MajorCompPhaseChangeConsChk
  1770:             
  1771:             !!$  subroutine MajorCompPhaseChangeLimitTemp( &
  1772:             !!$    & xyr_Press, xyz_Press,  &  ! (in)
  1773:             !!$    & xy_SurfTemp, xyz_Temp  &  ! (inout)
  1774:             !!$    & )
  1775:             !!$    !
  1776:             !!$    ! CO2 相変化
  1777:             !!$    !
  1778:             !!$    ! CO2 phase change
  1779:             !!$    !
  1780:             !!$
  1781:             !!$    ! モジュール引用 ; USE statements
  1782:             !!$    !
  1783:             !!$
  1784:             !!$    ! 時刻管理
  1785:             !!$    ! Time control
  1786:             !!$    !
  1787:             !!$    use timeset, only: &
  1788:             !!$      & DelTime, &            ! $ \Delta t $
  1789:             !!$      & TimeN, &              ! ステップ $ t $ の時刻. Time of step $ t $. 
  1790:             !!$      & TimesetClockStart, TimesetClockStop
  1791:             !!$
  1792:             !!$    ! ヒストリデータ出力
  1793:             !!$    ! History data output
  1794:             !!$    !
  1795:             !!$    use gtool_historyauto, only: HistoryAutoPut
  1796:             !!$
  1797:             !!$
  1798:             !!$    ! 宣言文 ; Declaration statements
  1799:             !!$    !
  1800:             !!$    implicit none
  1801:             !!$
  1802:             !!$    real(DP), intent(in   ):: xyr_Press (0:imax-1, 1:jmax, 0:kmax)
  1803:             !!$                              ! $ \hat{p} $ . 気圧 (半整数レベル). 
  1804:             !!$                              ! Air pressure (half level)
  1805:             !!$    real(DP), intent(in   ):: xyz_Press (0:imax-1, 1:jmax, 1:kmax)
  1806:             !!$                              ! $ p $ . 気圧 (整数レベル). 
  1807:             !!$                              ! Air pressure (full level)
  1808:             !!$    real(DP), intent(inout):: xy_SurfTemp(0:imax-1, 1:jmax)
  1809:             !!$                              ! $ T_s $ .   惑星表面温度. Surface temperature
  1810:             !!$    real(DP), intent(inout):: xyz_Temp   (0:imax-1, 1:jmax, 1:kmax)
  1811:             !!$                              ! $ T $ .     温度. Temperature
  1812:             !!$
  1813:             !!$    ! 作業変数
  1814:             !!$    ! Work variables
  1815:             !!$    !
  1816:             !!$    real(DP):: xy_SurfTempB  (0:imax-1, 1:jmax)
  1817:             !!$                              ! 調節前の惑星表面温度. 
  1818:             !!$                              ! Surface temperature before adjustment
  1819:             !!$    real(DP):: xyz_TempB     (0:imax-1, 1:jmax, 1:kmax)
  1820:             !!$                              ! 調節前の温度. 
  1821:             !!$                              ! Temperature before adjustment
  1822:             !!$    real(DP):: xy_DSurfTempDt(0:imax-1, 1:jmax)
  1823:             !!$                              ! 惑星表面温度変化率. 
  1824:             !!$                              ! Surface temperature tendency
  1825:             !!$    real(DP):: xyz_DTempDt   (0:imax-1, 1:jmax, 1:kmax)
  1826:             !!$                              ! 温度変化率. 
  1827:             !!$                              ! Temperature tendency
  1828:             !!$
  1829:             !!$    real(DP):: xy_SurfTempCond(0:imax-1, 1:jmax)
  1830:             !!$    real(DP):: xyz_TempCond   (0:imax-1, 1:jmax, 1:kmax)
  1831:             !!$
  1832:             !!$    integer:: i               ! 経度方向に回る DO ループ用作業変数
  1833:             !!$                              ! Work variables for DO loop in longitude
  1834:             !!$    integer:: j               ! 緯度方向に回る DO ループ用作業変数
  1835:             !!$                              ! Work variables for DO loop in latitude
  1836:             !!$    integer:: k               ! 鉛直方向に回る DO ループ用作業変数
  1837:             !!$                              ! Work variables for DO loop in vertical direction
  1838:             !!$
  1839:             !!$    logical :: FlagCheckPs
  1840:             !!$
  1841:             !!$
  1842:             !!$    ! 実行文 ; Executable statement
  1843:             !!$    !
  1844:             !!$
  1845:             !!$    ! 計算時間計測開始
  1846:             !!$    ! Start measurement of computation time
  1847:             !!$    !
  1848:             !!$    call TimesetClockStart( module_name )
  1849:             !!$
  1850:             !!$    ! 初期化
  1851:             !!$    ! Initialization
  1852:             !!$    !
  1853:             !!$    if ( .not. major_comp_phase_change_inited ) call MajorCompPhaseChangeInit
  1854:             !!$
  1855:             !!$    if ( .not. FlagUse ) return
  1856:             !!$
  1857:             !!$
  1858:             !!$    FlagCheckPs = .false.
  1859:             !!$    do j = 1, jmax
  1860:             !!$      do i = 0, imax-1
  1861:             !!$        if ( xyr_Press(i,j,0) > 1.0d4 ) then
  1862:             !!$          FlagCheckPs = .true.
  1863:             !!$        end if
  1864:             !!$      end do
  1865:             !!$    end do
  1866:             !!$    if ( FlagCheckPs ) then
  1867:             !!$      call MessageNotify( 'W', module_name, 'Surface pressure is greater than 10000 Pa.' )
  1868:             !!$    end if
  1869:             !!$
  1870:             !!$
  1871:             !!$    ! 調節前 "Temp" の保存
  1872:             !!$    ! Store "Temp" before adjustment
  1873:             !!$    !
  1874:             !!$    xy_SurfTempB = xy_SurfTemp
  1875:             !!$    xyz_TempB    = xyz_Temp
  1876:             !!$
  1877:             !!$
  1878:             !!$    do j = 1, jmax
  1879:             !!$      do i = 0, imax-1
  1880:             !!$        xy_SurfTempCond(i,j) = &
  1881:             !!$          & 149.2d0 + 6.48d0 * log( 0.135d0 * xyr_Press(i,j,0) * 1.0d-2 )
  1882:             !!$      end do
  1883:             !!$    end do
  1884:             !!$    do k = 1, kmax
  1885:             !!$      do j = 1, jmax
  1886:             !!$        do i = 0, imax-1
  1887:             !!$          xyz_TempCond(i,j,k) = &
  1888:             !!$            & 149.2d0 + 6.48d0 * log( 0.135d0 * xyz_Press(i,j,k) * 1.0d-2 )
  1889:             !!$        end do
  1890:             !!$      end do
  1891:             !!$    end do
  1892:             !!$
  1893:             !!$    do j = 1, jmax
  1894:             !!$      do i = 0, imax-1
  1895:             !!$        if ( xy_SurfTemp(i,j) < xy_SurfTempCond(i,j) ) then
  1896:             !!$          xy_SurfTemp(i,j) = xy_SurfTempCond(i,j)
  1897:             !!$        end if
  1898:             !!$      end do
  1899:             !!$    end do
  1900:             !!$    do k = 1, kmax
  1901:             !!$      do j = 1, jmax
  1902:             !!$        do i = 0, imax-1
  1903:             !!$          if ( xyz_Temp(i,j,k) < xyz_TempCond(i,j,k) ) then
  1904:             !!$            xyz_Temp(i,j,k) = xyz_TempCond(i,j,k)
  1905:             !!$          end if
  1906:             !!$        end do
  1907:             !!$      end do
  1908:             !!$    end do
  1909:             !!$
  1910:             !!$
  1911:             !!$    ! 温度変化率
  1912:             !!$    ! Calculate temperature tendency
  1913:             !!$    !
  1914:             !!$    xy_DSurfTempDt = ( xy_SurfTemp - xy_SurfTempB ) / ( 2.0_DP * DelTime )
  1915:             !!$    xyz_DTempDt    = ( xyz_Temp    - xyz_TempB    ) / ( 2.0_DP * DelTime )
  1916:             !!$
  1917:             !!$
  1918:             !!$    ! ヒストリデータ出力
  1919:             !!$    ! History data output
  1920:             !!$    !
  1921:             !!$    call HistoryAutoPut( TimeN, 'DSurfTempDtCO2PhaseChange', xy_DSurfTempDt )
  1922:             !!$    call HistoryAutoPut( TimeN, 'DTempDtCO2PhaseChange'    , xyz_DTempDt    )
  1923:             !!$
  1924:             !!$
  1925:             !!$    ! 計算時間計測一時停止
  1926:             !!$    ! Pause measurement of computation time
  1927:             !!$    !
  1928:             !!$    call TimesetClockStop( module_name )
  1929:             !!$
  1930:             !!$  end subroutine MajorCompPhaseChangeLimitTemp
  1931:             
  1932:               !--------------------------------------------------------------------------------------
  1933:             
  1934:               subroutine MajorCompPhaseChangeInit(             &
  1935:                 & ArgFlagMajCompPhaseChange, CondMajCompName   & ! (in)
  1936:                 & )
  1937:                 !
  1938:                 ! major_comp_phase_change モジュールの初期化を行います. 
  1939:                 ! NAMELIST#major_comp_phase_change_nml の読み込みはこの手続きで行われます. 
  1940:                 !
  1941:                 ! "major_comp_phase_change" module is initialized. 
  1942:                 ! "NAMELIST#major_comp_phase_change_nml" is loaded in this procedure. 
  1943:                 !
  1944:             
  1945:                 ! モジュール引用 ; USE statements
  1946:                 !
  1947:             
  1948:                 ! NAMELIST ファイル入力に関するユーティリティ
  1949:                 ! Utilities for NAMELIST file input
  1950:                 !
  1951:                 use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid
  1952:             
  1953:                 ! ファイル入出力補助
  1954:                 ! File I/O support
  1955:                 !
  1956:                 use dc_iounit, only: FileOpen
  1957:             
  1958:                 ! 種別型パラメタ
  1959:                 ! Kind type parameter
  1960:                 !
  1961:                 use dc_types, only: STDOUT ! 標準出力の装置番号. Unit number of standard output
  1962:             
  1963:                 ! 文字列操作
  1964:                 ! Character handling
  1965:                 !
  1966:                 use dc_string, only: StoA
  1967:             
  1968:                 ! ヒストリデータ出力
  1969:                 ! History data output
  1970:                 !
  1971:                 use gtool_historyauto, only: HistoryAutoAddVariable
  1972:             
  1973:                 ! 補助的な変数を計算するサブルーチン・関数群
  1974:                 ! Subroutines and functions for calculating auxiliary variables
  1975:                 !
  1976:                 use auxiliary, only : AuxVarsInit
  1977:             
  1978:                 ! 主成分相変化
  1979:                 ! Phase change of atmospheric major component
  1980:                 !
  1981:                 use saturate_major_comp, only : &
  1982:                   & SaturateMajorCompInit
  1983:             
  1984:                 ! 質量の補正
  1985:                 ! Mass fixer
  1986:                 !
  1987:                 use mass_fixer, only : MassFixerInit
  1988:             
  1989:             
  1990:                 ! 宣言文 ; Declaration statements
  1991:                 !
  1992:                 implicit none
  1993:             
  1994:                 logical     , intent(in) :: ArgFlagMajCompPhaseChange
  1995:                 character(*), intent(in) :: CondMajCompName
  1996:             
  1997:             
  1998:                 integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号. 
  1999:                                           ! Unit number for NAMELIST file open
  2000:                 integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT. 
  2001:                                           ! IOSTAT of NAMELIST read
  2002:             
  2003:                 ! NAMELIST 変数群
  2004:                 ! NAMELIST group name
  2005:                 !
  2006:                 namelist /major_comp_phase_change_nml/ &
  2007:                   & FlagModMom
  2008:             
  2009:                       ! デフォルト値については初期化手続 "major_comp_phase_change#MajorCompPhaseChangeInit" 
  2010:                       ! のソースコードを参照のこと. 
  2011:                       !
  2012:                       ! Refer to source codes in the initialization procedure
  2013:                       ! "major_comp_phase_change#MajorCompPhaseChangeInit" for the default values. 
  2014:                       !
  2015:             
  2016:                 ! 実行文 ; Executable statement
  2017:                 !
  2018:             
  2019:                 if ( major_comp_phase_change_inited ) return
  2020:             
  2021:             
  2022:                 FlagMajCompPhaseChange = ArgFlagMajCompPhaseChange
  2023:             
  2024:             
  2025:                 ! デフォルト値の設定
  2026:                 ! Default values settings
  2027:                 !
  2028:                 FlagModMom = .false.
  2029:             
  2030:             
  2031:                 ! NAMELIST の読み込み
  2032:                 ! NAMELIST is input
  2033:                 !
  2034:                 if ( trim(namelist_filename) /= '' ) then
  2035:                   call FileOpen( unit_nml, &          ! (out)
  2036:                     & namelist_filename, mode = 'r' ) ! (in)
  2037:             
  2038:                   rewind( unit_nml )
  2039:                   read( unit_nml,                        &  ! (in)
  2040:                     & nml = major_comp_phase_change_nml, &  ! (out)
  2041:                     & iostat = iostat_nml )                 ! (out)
  2042:                   close( unit_nml )
  2043:             
  2044:                   call NmlutilMsg( iostat_nml, module_name ) ! (in)
  2045:             !      if ( iostat_nml == 0 ) write( STDOUT, nml = cumulus_adjust_nml )
  2046:                 end if
  2047:             
  2048:             
  2049:                 if ( FlagMajCompPhaseChange ) then
  2050:                   ! 主成分相変化
  2051:                   ! Phase change of atmospheric major component
  2052:                   !
  2053:                   call SaturateMajorCompInit(  &
  2054:                     & CondMajCompName          & ! (in)
  2055:                     & )
  2056:                 end if
  2057:             
  2058:                 ! 補助的な変数を計算するサブルーチン・関数群
  2059:                 ! Subroutines and functions for calculating auxiliary variables
  2060:                 !
  2061:                 call AuxVarsInit
  2062:             
  2063:                 ! 質量の補正
  2064:                 ! Mass fixer
  2065:                 !
  2066:                 call MassFixerInit
  2067:             
  2068:             
  2069:                 ! ヒストリデータ出力のためのへの変数登録
  2070:                 ! Register of variables for history data output
  2071:                 !
  2072:                 call HistoryAutoAddVariable( 'DSurfTempDtMajCompPhaseChange', &
  2073:                   & (/ 'lon ', 'lat ', 'time' /),                             &
  2074:                   & 'heating by major component phase change', 'K s-1' )
  2075:                 call HistoryAutoAddVariable( 'DTempDtMajCompPhaseChange',     &
  2076:                   & (/ 'lon ', 'lat ', 'sig ', 'time' /),                 &
  2077:                   & 'heating by major component phase change', 'K s-1' )
  2078:             
  2079:                 ! 印字 ; Print
  2080:                 !
  2081:                 call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
  2082:                 call MessageNotify( 'M', module_name, '  FlagModMom = %b', l = (/ FlagModMom /) )
  2083:                 call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
  2084:             
  2085:                 major_comp_phase_change_inited = .true.
  2086:             
  2087:               end subroutine MajorCompPhaseChangeInit
  2088:             
  2089:               !-------------------------------------------------------------------
  2090:             
  2091:             end module major_comp_phase_change
