Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:26 2016
FILE NAME: saturate_DennouAGCM.f90
PROGRAM NAME: saturate_dennouagcm
DIAGNOSTIC LIST

  LINE  LEVEL( NO.): DIAGNOSTIC MESSAGE

   169  opt  (1592): Outer loop unrolled inside inner loop.
   169  vec  (   4): Vectorized array expression.
   169  vec  (  29): ADB is used for array.: xyz_press
   169  vec  (  29): ADB is used for array.: xyz_temp
   169  vec  (   4): Vectorized array expression.
   169  vec  (  29): ADB is used for array.: xyz_press
   169  vec  (  29): ADB is used for array.: xyz_temp
   241  opt  (1592): Outer loop unrolled inside inner loop.
   241  vec  (   4): Vectorized array expression.
   241  vec  (  29): ADB is used for array.: xyz_temp
   241  vec  (  29): ADB is used for array.: xyz_qvapsat
   241  vec  (   4): Vectorized array expression.
   241  vec  (  29): ADB is used for array.: xyz_temp
   241  vec  (  29): ADB is used for array.: xyz_qvapsat
   314  opt  (1592): Outer loop unrolled inside inner loop.
   314  vec  (   4): Vectorized array expression.
   314  vec  (  29): ADB is used for array.: xyz_press
   314  vec  (  29): ADB is used for array.: xyz_temp
   314  vec  (   4): Vectorized array expression.
   314  vec  (  29): ADB is used for array.: xyz_press
   314  vec  (  29): ADB is used for array.: xyz_temp
   386  opt  (1592): Outer loop unrolled inside inner loop.
   386  vec  (   4): Vectorized array expression.
   386  vec  (  29): ADB is used for array.: xyz_temp
   386  vec  (  29): ADB is used for array.: xyz_qvapsat
   386  vec  (   4): Vectorized array expression.
   386  vec  (  29): ADB is used for array.: xyz_temp
   386  vec  (  29): ADB is used for array.: xyz_qvapsat
   490  warn (  82): Name "iostat_nml" is not used.
   490  warn (  82): Name "unit_nml" is not used.
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:26 2016
FILE NAME: saturate_DennouAGCM.f90
PROGRAM NAME: saturate_dennouagcm
TRANSFORMATION LIST

  LINE                   FORTRAN STATEMENT

     1  != Dennou AGCM の式を用いた飽和比湿の算出
     2  !
     3  != Evaluate saturation specific humidity with method used by Dennou AGCM
     4  !
     5  ! Authors::   Yasuhiro MORIKAWA, Yoshiyuki O. Takahashi
     6  ! Version::   $Id: saturate_DennouAGCM.f90,v 1.6 2015/01/29 12:07:16 yot Exp $
     7  ! Tag Name::  $Name:  $
     8  ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9  ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10  !
    11  
    12  module saturate_DennouAGCM
    13    !
    14    != Dennou AGCM の式を用いた飽和比湿の算出
    15    !
    16    != Evaluate saturation specific humidity with method used by Dennou AGCM
    17    !
    18    ! <b>Note that Japanese and English are described in parallel.</b>
    19    !
    20    ! Dennou AGCM で用いられていた式を用いて飽和蒸気圧を計算します.
    21    ! この式は, 元々 沼口 (1992) に依っています.
    22    !
    23    ! Saturation specific humidity and temperature derivative of it
    24    ! are calculated with a formula used in Dennou AGCM.
    25    ! This formula is originaly obtained from Numaguti (1992).
    26    !
    27    !== References
    28    !
    29    ! * Numaguti, 1992:
    30    !   <title in Japanese>,
    31    !   Doctor thesis, University of Tokyo.
    32    !
    33    !== Procedures List
    34    !
    35    ! CalcQVapSat            :: 飽和比湿の計算
    36    ! CalcDQVapSatDTemp      :: 飽和比湿の温度微分の計算
    37    ! ------------  :: ------------
    38    ! CalcQVapSat            :: Calculate saturation specific humidity
    39    ! CalcDQVapSatDTemp      :: Calculate temperature derivative of saturation specific humidity
    40    !
    41    !--
    42    !== NAMELIST
    43    !
    44    ! NAMELIST#saturate_t1930_nml
    45    !++
    46  
    47    ! モジュール引用 ; USE statements
    48    !
    49  
    50    ! 種別型パラメタ
    51    ! Kind type parameter
    52    !
    53    use dc_types, only: DP, &      ! 倍精度実数型. Double precision.
    54      &                 STRING     ! 文字列.       Strings.
    55  
    56    ! メッセージ出力
    57    ! Message output
    58    !
    59    use dc_message, only: MessageNotify
    60  
    61    ! 宣言文 ; Declaration statements
    62    !
    63    implicit none
    64    private
    65  
    66  
    67    ! 公開手続き
    68    ! Public procedure
    69    !
    70    public:: xyz_CalcQVapSatOnLiq
    71    public:: xyz_CalcDQVapSatDTempOnLiq
    72    public:: xyz_CalcQVapSatOnSol
    73    public:: xyz_CalcDQVapSatDTempOnSol
    74    public:: SaturateInit
    75  
    76    ! 公開変数
    77    ! Public variables
    78    !
    79    logical, save, public:: saturate_DennouAGCM_inited = .false.
    80                                ! 初期設定フラグ.
    81                                ! Initialization flag
    82  
    83    ! 非公開変数
    84    ! Private variables
    85    !
    86    real(DP), parameter:: Es0 = 611.0_DP
    87                                ! 0 ℃の飽和蒸気圧 [Pa].
    88                                ! Saturation water vapor pressure at 0 deg C [Pa]
    89  
    90    character(*), parameter:: module_name = 'saturate_DennouAGCM'
    91                                ! モジュールの名称.
    92                                ! Module name
    93    character(*), parameter:: version = &
    94      & '$Name:  $' // &
    95      & '$Id: saturate_DennouAGCM.f90,v 1.6 2015/01/29 12:07:16 yot Exp $'
    96                                ! モジュールのバージョン
    97                                ! Module version
    98  
    99  contains
   100  
   101    !--------------------------------------------------------------------------------------
   102  
   103    function xyz_CalcQVapSatOnLiq( xyz_Temp, xyz_Press ) result( xyz_QVapSat )
   104      !
   105      ! 温度 *Temp* と気圧 *Press* を用い,
   106      ! 飽和比湿 *QVapSat* を求めます.
   107      !
   108      ! Calculate saturation specific humidity *QVapSat* using
   109      ! temperature *Temp* and air pressure *Press*.
   110      !
   111  
   112      ! モジュール引用 ; USE statements
   113      !
   114  
   115      ! 物理定数設定
   116      ! Physical constants settings
   117      !
   118      use constants, only: &
   119        & GasRWet, &
   120                                ! $ R_v $ [J kg-1 K-1].
   121                                ! 凝結成分の気体定数.
   122                                ! Gas constant of condensible elements
   123        & LatentHeat, &
   124                                ! $ L $ [J kg-1] .
   125                                ! 凝結の潜熱.
   126                                ! Latent heat of condensation
   127        & LatentHeatFusion, &
   128                                ! $ L $ [J kg-1] .
   129                                ! 融解の潜熱.
   130                                ! Latent heat of fusion
   131        & EpsV                  ! $ \epsilon_v $ .
   132                                ! 水蒸気分子量比.
   133                                ! Molecular weight of water vapor
   134  
   135      ! 宣言文 ; Declaration statements
   136      !
   137      implicit none
   138  
   139      real(DP), intent(in):: xyz_Temp (:,:,:)
   140                                ! $ T $ . 温度. Temperature
   141      real(DP), intent(in):: xyz_Press(:,:,:)
   142                                ! $ p $ . 気圧. Air pressure
   143  
   144      real(DP):: xyz_QVapSat(1:size(xyz_Temp,1), 1:size(xyz_Temp,2), 1:size(xyz_Temp,3))
   145                                ! $ q^{*} $ . 飽和比湿. Saturation specific humidity
   146  
   147      ! 作業変数
   148      ! Work variables
   149      !
   150      real(DP):: LatentHeatLocal
   151                                !
   152                                ! Latent heat used in this routine
   153  
   154  
   155      ! 実行文 ; Executable statement
   156      !
   157  
   158      ! 初期化確認
   159      ! Initialization check
   160      !
   161  
   162      if ( .not. saturate_DennouAGCM_inited ) then
   163        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   164      end if
   165  
   166      ! Set a value for latent heat
   167      LatentHeatLocal = LatentHeat
   168  
   169      xyz_QVapSat = &
     .        if (xyz_temp.DSC.U2 .gt. 0) then                                  
     .           j4 = and(xyz_temp.DSC.U2,3)                                    
     .  !cdir    nodep                                                          
     .           do t65 = 1, j4                                                 
     .  !cdir       nodep                                                       
     .              do t67 = 1, xyz_temp.DSC.U1                                 
     .                 xyz_qvapsat(t67,t65,t63+1) = epsv*6.11000000000000e+002* 
     .       1            dexp(latentheatlocal/gasrwet*(3.66300366300366e-003 - 
     .       2            1.00000000000000e+000/xyz_temp(t67,t65,t63+1)))/      
     .       3            xyz_press(t67,t65,t63+1)                              
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t65 = j4 + 1, xyz_temp.DSC.U2, 4                            
     .  !cdir       nodep                                                       
     .              do t67 = 1, xyz_temp.DSC.U1                                 
     .                 xyz_qvapsat(t67,t65,t63+1) = (epsv*6.11000000000000e+002)
     .       1            *dexp((latentheatlocal/gasrwet)*(3.66300366300366e-003
     .       2             - 1.00000000000000e+000/xyz_temp(t67,t65,t63+1)))/   
     .       3            xyz_press(t67,t65,t63+1)                              
     .                 xyz_qvapsat(t67,t65+1,t63+1) = (epsv*                    
     .       1            6.11000000000000e+002)*dexp((latentheatlocal/gasrwet)*
     .       2            (3.66300366300366e-003 - 1.00000000000000e+000/       
     .       3            xyz_temp(t67,t65+1,t63+1)))/xyz_press(t67,t65+1,t63+1)
     .                 xyz_qvapsat(t67,t65+2,t63+1) = (epsv*                    
     .       1            6.11000000000000e+002)*dexp((latentheatlocal/gasrwet)*
     .       2            (3.66300366300366e-003 - 1.00000000000000e+000/       
     .       3            xyz_temp(t67,t65+2,t63+1)))/xyz_press(t67,t65+2,t63+1)
     .                 xyz_qvapsat(t67,t65+3,t63+1) = (epsv*                    
     .       1            6.11000000000000e+002)*dexp((latentheatlocal/gasrwet)*
     .       2            (3.66300366300366e-003 - 1.00000000000000e+000/       
     .       3            xyz_temp(t67,t65+3,t63+1)))/xyz_press(t67,t65+3,t63+1)
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
   170        & EpsV * Es0 * exp( LatentHeatLocal / GasRWet * ( 1.0_DP/273.0_DP - 1.0_DP/xyz_Temp ) ) &
   171        & / xyz_Press
   172  
   173  
   174    end function xyz_CalcQVapSatOnLiq
   175  
   176    !--------------------------------------------------------------------------------------
   177  
   178    function xyz_CalcDQVapSatDTempOnLiq( xyz_Temp, xyz_QVapSat ) result( xyz_DQVapSatDTemp )
   179      !
   180      ! 温度 *Temp* と飽和比湿 *QVapSat* を用い,
   181      ! 飽和比湿の温度微分 *DQVapSatDTemp* を求めます.
   182      !
   183      ! Calculate temperature derivative of saturation specific humidity
   184      ! *DQVapSatDTemp* using
   185      ! temperature *Temp* and saturation specific humidity *QVapSat*.
   186      !
   187  
   188      ! モジュール引用 ; USE statements
   189      !
   190  
   191      ! 物理定数設定
   192      ! Physical constants settings
   193      !
   194      use constants, only: &
   195        & GasRWet, &
   196                                ! $ R_v $ [J kg-1 K-1].
   197                                ! 凝結成分の気体定数.
   198                                ! Gas constant of condensible elements
   199        & LatentHeat, &
   200                                ! $ L $ [J kg-1] .
   201                                ! 凝結の潜熱.
   202                                ! Latent heat of condensation
   203        & LatentHeatFusion, &
   204                                ! $ L $ [J kg-1] .
   205                                ! 融解の潜熱.
   206                                ! Latent heat of fusion
   207        & EpsV                  ! $ \epsilon_v $ .
   208                                ! 水蒸気分子量比.
   209                                ! Molecular weight of water vapor
   210  
   211      ! 宣言文 ; Declaration statements
   212      !
   213      implicit none
   214  
   215      real(DP), intent(in):: xyz_Temp   (:,:,:)
   216                                ! $ T $ . 温度. Temperature
   217      real(DP), intent(in):: xyz_QVapSat(:,:,:)
   218                                ! $ q^{*} $ . 飽和比湿. Saturation specific humidity
   219      real(DP):: xyz_DQVapSatDTemp(size(xyz_Temp,1), size(xyz_Temp,2), size(xyz_Temp,3))
   220                                ! $ \DP{q^{*}}{T} $ . 飽和比湿の温度微分.
   221                                ! Temperature derivative of saturation specific humidity.
   222  
   223      ! 作業変数
   224      ! Work variables
   225      !
   226      real(DP):: LatentHeatLocal
   227                                !
   228                                ! Latent heat used in this routine
   229  
   230  
   231      ! 実行文 ; Executable statement
   232      !
   233  
   234      if ( .not. saturate_DennouAGCM_inited ) then
   235        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   236      end if
   237  
   238      ! Set a value for latent heat
   239      LatentHeatLocal = LatentHeat
   240  
   241      xyz_DQVapSatDTemp = LatentHeatLocal * xyz_QVapSat / ( GasRWet * xyz_Temp**2 )
     .        if (xyz_qvapsat.DSC.U2 .gt. 0) then                               
     .           j4 = and(xyz_qvapsat.DSC.U2,3)                                 
     .  !cdir    nodep                                                          
     .           do t62 = 1, j4                                                 
     .  !cdir       nodep                                                       
     .              do t64 = 1, xyz_qvapsat.DSC.U1                              
     .                 xyz_dqvapsatdtemp(t64,t62,t60+1) = latentheatlocal*      
     .       1            xyz_qvapsat(t64,t62,t60+1)/(gasrwet*xyz_temp(t64,t62, 
     .       2            t60+1)**2)                                            
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t62 = j4 + 1, xyz_qvapsat.DSC.U2, 4                         
     .  !cdir       nodep                                                       
     .              do t64 = 1, xyz_qvapsat.DSC.U1                              
     .                 xyz_dqvapsatdtemp(t64,t62,t60+1) = latentheatlocal*      
     .       1            xyz_qvapsat(t64,t62,t60+1)/(gasrwet*xyz_temp(t64,t62, 
     .       2            t60+1)**2)                                            
     .                 xyz_dqvapsatdtemp(t64,t62+1,t60+1) = latentheatlocal*    
     .       1            xyz_qvapsat(t64,t62+1,t60+1)/(gasrwet*xyz_temp(t64,t62
     .       2            +1,t60+1)**2)                                         
     .                 xyz_dqvapsatdtemp(t64,t62+2,t60+1) = latentheatlocal*    
     .       1            xyz_qvapsat(t64,t62+2,t60+1)/(gasrwet*xyz_temp(t64,t62
     .       2            +2,t60+1)**2)                                         
     .                 xyz_dqvapsatdtemp(t64,t62+3,t60+1) = latentheatlocal*    
     .       1            xyz_qvapsat(t64,t62+3,t60+1)/(gasrwet*xyz_temp(t64,t62
     .       2            +3,t60+1)**2)                                         
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
   242  
   243  
   244    end function xyz_CalcDQVapSatDTempOnLiq
   245  
   246    !--------------------------------------------------------------------------------------
   247  
   248    function xyz_CalcQVapSatOnSol( xyz_Temp, xyz_Press ) result( xyz_QVapSat )
   249      !
   250      ! 温度 *Temp* と気圧 *Press* を用い,
   251      ! 飽和比湿 *QVapSat* を求めます.
   252      !
   253      ! Calculate saturation specific humidity *QVapSat* using
   254      ! temperature *Temp* and air pressure *Press*.
   255      !
   256  
   257      ! モジュール引用 ; USE statements
   258      !
   259  
   260      ! 物理定数設定
   261      ! Physical constants settings
   262      !
   263      use constants, only: &
   264        & GasRWet, &
   265                                ! $ R_v $ [J kg-1 K-1].
   266                                ! 凝結成分の気体定数.
   267                                ! Gas constant of condensible elements
   268        & LatentHeat, &
   269                                ! $ L $ [J kg-1] .
   270                                ! 凝結の潜熱.
   271                                ! Latent heat of condensation
   272        & LatentHeatFusion, &
   273                                ! $ L $ [J kg-1] .
   274                                ! 融解の潜熱.
   275                                ! Latent heat of fusion
   276        & EpsV                  ! $ \epsilon_v $ .
   277                                ! 水蒸気分子量比.
   278                                ! Molecular weight of water vapor
   279  
   280      ! 宣言文 ; Declaration statements
   281      !
   282      implicit none
   283  
   284      real(DP), intent(in):: xyz_Temp (:,:,:)
   285                                ! $ T $ . 温度. Temperature
   286      real(DP), intent(in):: xyz_Press(:,:,:)
   287                                ! $ p $ . 気圧. Air pressure
   288  
   289      real(DP):: xyz_QVapSat(1:size(xyz_Temp,1), 1:size(xyz_Temp,2), 1:size(xyz_Temp,3))
   290                                ! $ q^{*} $ . 飽和比湿. Saturation specific humidity
   291  
   292      ! 作業変数
   293      ! Work variables
   294      !
   295      real(DP):: LatentHeatLocal
   296                                !
   297                                ! Latent heat used in this routine
   298  
   299  
   300      ! 実行文 ; Executable statement
   301      !
   302  
   303      ! 初期化確認
   304      ! Initialization check
   305      !
   306  
   307      if ( .not. saturate_DennouAGCM_inited ) then
   308        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   309      end if
   310  
   311      ! Set a value for latent heat
   312      LatentHeatLocal = LatentHeat + LatentHeatFusion
   313  
   314      xyz_QVapSat = &
     .        if (xyz_temp.DSC.U2 .gt. 0) then                                  
     .           j4 = and(xyz_temp.DSC.U2,3)                                    
     .  !cdir    nodep                                                          
     .           do t67 = 1, j4                                                 
     .  !cdir       nodep                                                       
     .              do t69 = 1, xyz_temp.DSC.U1                                 
     .                 xyz_qvapsat(t69,t67,t65+1) = epsv*6.11000000000000e+002* 
     .       1            dexp(latentheatlocal/gasrwet*(3.66300367750227e-003 - 
     .       2            1.00000000000000e+000/xyz_temp(t69,t67,t65+1)))/      
     .       3            xyz_press(t69,t67,t65+1)                              
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t67 = j4 + 1, xyz_temp.DSC.U2, 4                            
     .  !cdir       nodep                                                       
     .              do t69 = 1, xyz_temp.DSC.U1                                 
     .                 xyz_qvapsat(t69,t67,t65+1) = (epsv*6.11000000000000e+002)
     .       1            *dexp((latentheatlocal/gasrwet)*(3.66300367750227e-003
     .       2             - 1.00000000000000e+000/xyz_temp(t69,t67,t65+1)))/   
     .       3            xyz_press(t69,t67,t65+1)                              
     .                 xyz_qvapsat(t69,t67+1,t65+1) = (epsv*                    
     .       1            6.11000000000000e+002)*dexp((latentheatlocal/gasrwet)*
     .       2            (3.66300367750227e-003 - 1.00000000000000e+000/       
     .       3            xyz_temp(t69,t67+1,t65+1)))/xyz_press(t69,t67+1,t65+1)
     .                 xyz_qvapsat(t69,t67+2,t65+1) = (epsv*                    
     .       1            6.11000000000000e+002)*dexp((latentheatlocal/gasrwet)*
     .       2            (3.66300367750227e-003 - 1.00000000000000e+000/       
     .       3            xyz_temp(t69,t67+2,t65+1)))/xyz_press(t69,t67+2,t65+1)
     .                 xyz_qvapsat(t69,t67+3,t65+1) = (epsv*                    
     .       1            6.11000000000000e+002)*dexp((latentheatlocal/gasrwet)*
     .       2            (3.66300367750227e-003 - 1.00000000000000e+000/       
     .       3            xyz_temp(t69,t67+3,t65+1)))/xyz_press(t69,t67+3,t65+1)
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
   315        & EpsV * Es0 * exp( LatentHeatLocal / GasRWet * ( 1./273. - 1./xyz_Temp ) ) &
   316        & / xyz_Press
   317  
   318  
   319    end function xyz_CalcQVapSatOnSol
   320  
   321    !--------------------------------------------------------------------------------------
   322  
   323    function xyz_CalcDQVapSatDTempOnSol( xyz_Temp, xyz_QVapSat ) result( xyz_DQVapSatDTemp )
   324      !
   325      ! 温度 *Temp* と飽和比湿 *QVapSat* を用い,
   326      ! 飽和比湿の温度微分 *DQVapSatDTemp* を求めます.
   327      !
   328      ! Calculate temperature derivative of saturation specific humidity
   329      ! *DQVapSatDTemp* using
   330      ! temperature *Temp* and saturation specific humidity *QVapSat*.
   331      !
   332  
   333      ! モジュール引用 ; USE statements
   334      !
   335  
   336      ! 物理定数設定
   337      ! Physical constants settings
   338      !
   339      use constants, only: &
   340        & GasRWet, &
   341                                ! $ R_v $ [J kg-1 K-1].
   342                                ! 凝結成分の気体定数.
   343                                ! Gas constant of condensible elements
   344        & LatentHeat, &
   345                                ! $ L $ [J kg-1] .
   346                                ! 凝結の潜熱.
   347                                ! Latent heat of condensation
   348        & LatentHeatFusion, &
   349                                ! $ L $ [J kg-1] .
   350                                ! 融解の潜熱.
   351                                ! Latent heat of fusion
   352        & EpsV                  ! $ \epsilon_v $ .
   353                                ! 水蒸気分子量比.
   354                                ! Molecular weight of water vapor
   355  
   356      ! 宣言文 ; Declaration statements
   357      !
   358      implicit none
   359  
   360      real(DP), intent(in):: xyz_Temp   (:,:,:)
   361                                ! $ T $ . 温度. Temperature
   362      real(DP), intent(in):: xyz_QVapSat(:,:,:)
   363                                ! $ q^{*} $ . 飽和比湿. Saturation specific humidity
   364      real(DP):: xyz_DQVapSatDTemp(size(xyz_Temp,1), size(xyz_Temp,2), size(xyz_Temp,3))
   365                                ! $ \DP{q^{*}}{T} $ . 飽和比湿の温度微分.
   366                                ! Temperature derivative of saturation specific humidity.
   367  
   368      ! 作業変数
   369      ! Work variables
   370      !
   371      real(DP):: LatentHeatLocal
   372                                !
   373                                ! Latent heat used in this routine
   374  
   375  
   376      ! 実行文 ; Executable statement
   377      !
   378  
   379      if ( .not. saturate_DennouAGCM_inited ) then
   380        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   381      end if
   382  
   383      ! Set a value for latent heat
   384      LatentHeatLocal = LatentHeat + LatentHeatFusion
   385  
   386      xyz_DQVapSatDTemp = LatentHeatLocal * xyz_QVapSat / ( GasRWet * xyz_Temp**2 )
     .        if (xyz_qvapsat.DSC.U2 .gt. 0) then                               
     .           j4 = and(xyz_qvapsat.DSC.U2,3)                                 
     .  !cdir    nodep                                                          
     .           do t64 = 1, j4                                                 
     .  !cdir       nodep                                                       
     .              do t66 = 1, xyz_qvapsat.DSC.U1                              
     .                 xyz_dqvapsatdtemp(t66,t64,t62+1) = latentheatlocal*      
     .       1            xyz_qvapsat(t66,t64,t62+1)/(gasrwet*xyz_temp(t66,t64, 
     .       2            t62+1)**2)                                            
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t64 = j4 + 1, xyz_qvapsat.DSC.U2, 4                         
     .  !cdir       nodep                                                       
     .              do t66 = 1, xyz_qvapsat.DSC.U1                              
     .                 xyz_dqvapsatdtemp(t66,t64,t62+1) = latentheatlocal*      
     .       1            xyz_qvapsat(t66,t64,t62+1)/(gasrwet*xyz_temp(t66,t64, 
     .       2            t62+1)**2)                                            
     .                 xyz_dqvapsatdtemp(t66,t64+1,t62+1) = latentheatlocal*    
     .       1            xyz_qvapsat(t66,t64+1,t62+1)/(gasrwet*xyz_temp(t66,t64
     .       2            +1,t62+1)**2)                                         
     .                 xyz_dqvapsatdtemp(t66,t64+2,t62+1) = latentheatlocal*    
     .       1            xyz_qvapsat(t66,t64+2,t62+1)/(gasrwet*xyz_temp(t66,t64
     .       2            +2,t62+1)**2)                                         
     .                 xyz_dqvapsatdtemp(t66,t64+3,t62+1) = latentheatlocal*    
     .       1            xyz_qvapsat(t66,t64+3,t62+1)/(gasrwet*xyz_temp(t66,t64
     .       2            +3,t62+1)**2)                                         
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
   387  
   388  
   389    end function xyz_CalcDQVapSatDTempOnSol
   390  
   391    !--------------------------------------------------------------------------------------
   392  
   393    subroutine SaturateInit
   394      !
   395      ! saturate_DennouAGCM モジュールの初期化を行います.
   396      !--
   397      ! NAMELIST#saturate_DennouAGCM_nml の読み込みはこの手続きで行われます.
   398      !++
   399      !
   400      ! "saturate_DennouAGCM" module is initialized.
   401      !--
   402      ! "NAMELIST#saturate_DennouAGCM_nml" is loaded in this procedure.
   403      !++
   404  
   405      ! モジュール引用 ; USE statements
   406      !
   407  
   408      ! NAMELIST ファイル入力に関するユーティリティ
   409      ! Utilities for NAMELIST file input
   410      !
   411      use namelist_util, only: namelist_filename, NmlutilMsg
   412  
   413      ! ファイル入出力補助
   414      ! File I/O support
   415      !
   416      use dc_iounit, only: FileOpen
   417  
   418      ! 種別型パラメタ
   419      ! Kind type parameter
   420      !
   421      use dc_types, only: STDOUT ! 標準出力の装置番号. Unit number of standard output
   422  
   423      ! 文字列操作
   424      ! Character handling
   425      !
   426      use dc_string, only: StoA
   427  
   428      ! ヒストリデータ出力
   429      ! History data output
   430      !
   431      use gtool_historyauto, only: HistoryAutoAddVariable
   432  
   433      ! 宣言文 ; Declaration statements
   434      !
   435      implicit none
   436  
   437      integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号.
   438                                ! Unit number for NAMELIST file open
   439      integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT.
   440                                ! IOSTAT of NAMELIST read
   441  
   442      ! NAMELIST 変数群
   443      ! NAMELIST group name
   444      !
   445  !!$    namelist /saturate_DennouAGCM_nml/ &
   446  !!$      & FlagSublimation
   447            !
   448            ! デフォルト値については初期化手続 "saturate_DennouAGCM#SaturateInit"
   449            ! のソースコードを参照のこと.
   450            !
   451            ! Refer to source codes in the initialization procedure
   452            ! "saturate_DennouAGCM#SaturateInit" for the default values.
   453            !
   454  
   455      ! 実行文 ; Executable statement
   456      !
   457  
   458      if ( saturate_DennouAGCM_inited ) return
   459  
   460  
   461      ! デフォルト値の設定
   462      ! Default values settings
   463      !
   464  
   465  
   466      ! NAMELIST の読み込み
   467      ! NAMELIST is input
   468      !
   469  !!$    if ( trim(namelist_filename) /= '' ) then
   470  !!$      call FileOpen( unit_nml, &          ! (out)
   471  !!$        & namelist_filename, mode = 'r' ) ! (in)
   472  !!$
   473  !!$      rewind( unit_nml )
   474  !!$      read( unit_nml, &           ! (in)
   475  !!$        & nml = saturate_DennouAGCM_nml, &  ! (out)
   476  !!$        & iostat = iostat_nml )   ! (out)
   477  !!$      close( unit_nml )
   478  !!$
   479  !!$      call NmlutilMsg( iostat_nml, module_name ) ! (in)
   480  !!$    end if
   481  
   482      ! 印字 ; Print
   483      !
   484      call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   485  !!$    call MessageNotify( 'M', module_name, '  FlagSublimation = %b', l = (/ FlagSublimation /) )
   486      call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   487  
   488      saturate_DennouAGCM_inited = .true.
   489  
   490    end subroutine SaturateInit
   491  
   492    !--------------------------------------------------------------------------------------
   493  
   494  end module saturate_DennouAGCM
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:26 2016
FILE NAME: saturate_DennouAGCM.f90
PROGRAM NAME: saturate_dennouagcm
FORMAT LIST

  LINE    LOOP      FORTRAN STATEMENT

     1:             != Dennou AGCM の式を用いた飽和比湿の算出
     2:             !
     3:             != Evaluate saturation specific humidity with method used by Dennou AGCM
     4:             !
     5:             ! Authors::   Yasuhiro MORIKAWA, Yoshiyuki O. Takahashi
     6:             ! Version::   $Id: saturate_DennouAGCM.f90,v 1.6 2015/01/29 12:07:16 yot Exp $
     7:             ! Tag Name::  $Name:  $
     8:             ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9:             ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10:             !
    11:             
    12:             module saturate_DennouAGCM
    13:               !
    14:               != Dennou AGCM の式を用いた飽和比湿の算出
    15:               !
    16:               != Evaluate saturation specific humidity with method used by Dennou AGCM
    17:               !
    18:               ! <b>Note that Japanese and English are described in parallel.</b>
    19:               !
    20:               ! Dennou AGCM で用いられていた式を用いて飽和蒸気圧を計算します. 
    21:               ! この式は, 元々 沼口 (1992) に依っています.
    22:               !
    23:               ! Saturation specific humidity and temperature derivative of it 
    24:               ! are calculated with a formula used in Dennou AGCM. 
    25:               ! This formula is originaly obtained from Numaguti (1992).
    26:               !
    27:               !== References
    28:               !
    29:               ! * Numaguti, 1992: 
    30:               !   <title in Japanese>, 
    31:               !   Doctor thesis, University of Tokyo.
    32:               !
    33:               !== Procedures List
    34:               !
    35:               ! CalcQVapSat            :: 飽和比湿の計算
    36:               ! CalcDQVapSatDTemp      :: 飽和比湿の温度微分の計算
    37:               ! ------------  :: ------------
    38:               ! CalcQVapSat            :: Calculate saturation specific humidity
    39:               ! CalcDQVapSatDTemp      :: Calculate temperature derivative of saturation specific humidity
    40:               !
    41:               !--
    42:               !== NAMELIST
    43:               !
    44:               ! NAMELIST#saturate_t1930_nml
    45:               !++
    46:             
    47:               ! モジュール引用 ; USE statements
    48:               !
    49:             
    50:               ! 種別型パラメタ
    51:               ! Kind type parameter
    52:               !
    53:               use dc_types, only: DP, &      ! 倍精度実数型. Double precision. 
    54:                 &                 STRING     ! 文字列.       Strings. 
    55:             
    56:               ! メッセージ出力
    57:               ! Message output
    58:               !
    59:               use dc_message, only: MessageNotify
    60:             
    61:               ! 宣言文 ; Declaration statements
    62:               !
    63:               implicit none
    64:               private
    65:             
    66:             
    67:               ! 公開手続き
    68:               ! Public procedure
    69:               !
    70:               public:: xyz_CalcQVapSatOnLiq
    71:               public:: xyz_CalcDQVapSatDTempOnLiq
    72:               public:: xyz_CalcQVapSatOnSol
    73:               public:: xyz_CalcDQVapSatDTempOnSol
    74:               public:: SaturateInit
    75:             
    76:               ! 公開変数
    77:               ! Public variables
    78:               !
    79:               logical, save, public:: saturate_DennouAGCM_inited = .false.
    80:                                           ! 初期設定フラグ. 
    81:                                           ! Initialization flag
    82:             
    83:               ! 非公開変数
    84:               ! Private variables
    85:               !
    86:               real(DP), parameter:: Es0 = 611.0_DP
    87:                                           ! 0 ℃の飽和蒸気圧 [Pa]. 
    88:                                           ! Saturation water vapor pressure at 0 deg C [Pa]
    89:             
    90:               character(*), parameter:: module_name = 'saturate_DennouAGCM'
    91:                                           ! モジュールの名称. 
    92:                                           ! Module name
    93:               character(*), parameter:: version = &
    94:                 & '$Name:  $' // &
    95:                 & '$Id: saturate_DennouAGCM.f90,v 1.6 2015/01/29 12:07:16 yot Exp $'
    96:                                           ! モジュールのバージョン
    97:                                           ! Module version
    98:             
    99:             contains
   100:             
   101:               !--------------------------------------------------------------------------------------
   102:             
   103:               function xyz_CalcQVapSatOnLiq( xyz_Temp, xyz_Press ) result( xyz_QVapSat )
   104:                 !
   105:                 ! 温度 *Temp* と気圧 *Press* を用い, 
   106:                 ! 飽和比湿 *QVapSat* を求めます. 
   107:                 !
   108:                 ! Calculate saturation specific humidity *QVapSat* using
   109:                 ! temperature *Temp* and air pressure *Press*. 
   110:                 !
   111:             
   112:                 ! モジュール引用 ; USE statements
   113:                 !
   114:             
   115:                 ! 物理定数設定
   116:                 ! Physical constants settings
   117:                 !
   118:                 use constants, only: &
   119:                   & GasRWet, &
   120:                                           ! $ R_v $ [J kg-1 K-1]. 
   121:                                           ! 凝結成分の気体定数. 
   122:                                           ! Gas constant of condensible elements
   123:                   & LatentHeat, &
   124:                                           ! $ L $ [J kg-1] . 
   125:                                           ! 凝結の潜熱. 
   126:                                           ! Latent heat of condensation
   127:                   & LatentHeatFusion, &
   128:                                           ! $ L $ [J kg-1] .
   129:                                           ! 融解の潜熱.
   130:                                           ! Latent heat of fusion
   131:                   & EpsV                  ! $ \epsilon_v $ . 
   132:                                           ! 水蒸気分子量比. 
   133:                                           ! Molecular weight of water vapor
   134:             
   135:                 ! 宣言文 ; Declaration statements
   136:                 !
   137:                 implicit none
   138:             
   139:                 real(DP), intent(in):: xyz_Temp (:,:,:)
   140:                                           ! $ T $ . 温度. Temperature
   141:                 real(DP), intent(in):: xyz_Press(:,:,:)
   142:                                           ! $ p $ . 気圧. Air pressure
   143:             
   144:                 real(DP):: xyz_QVapSat(1:size(xyz_Temp,1), 1:size(xyz_Temp,2), 1:size(xyz_Temp,3))
   145:                                           ! $ q^{*} $ . 飽和比湿. Saturation specific humidity
   146:             
   147:                 ! 作業変数
   148:                 ! Work variables
   149:                 !
   150:                 real(DP):: LatentHeatLocal
   151:                                           !
   152:                                           ! Latent heat used in this routine
   153:             
   154:             
   155:                 ! 実行文 ; Executable statement
   156:                 !
   157:             
   158:                 ! 初期化確認
   159:                 ! Initialization check
   160:                 !
   161:             
   162:                 if ( .not. saturate_DennouAGCM_inited ) then
   163:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   164:                 end if
   165:             
   166:                 ! Set a value for latent heat
   167:                 LatentHeatLocal = LatentHeat
   168:             
   169: ++V==== A       xyz_QVapSat = &
   170:                   & EpsV * Es0 * exp( LatentHeatLocal / GasRWet * ( 1.0_DP/273.0_DP - 1.0_DP/xyz_Temp ) ) &
   171:                   & / xyz_Press
   172:             
   173:             
   174:               end function xyz_CalcQVapSatOnLiq
   175:             
   176:               !--------------------------------------------------------------------------------------
   177:             
   178:               function xyz_CalcDQVapSatDTempOnLiq( xyz_Temp, xyz_QVapSat ) result( xyz_DQVapSatDTemp )
   179:                 !
   180:                 ! 温度 *Temp* と飽和比湿 *QVapSat* を用い, 
   181:                 ! 飽和比湿の温度微分 *DQVapSatDTemp* を求めます. 
   182:                 !
   183:                 ! Calculate temperature derivative of saturation specific humidity 
   184:                 ! *DQVapSatDTemp* using
   185:                 ! temperature *Temp* and saturation specific humidity *QVapSat*. 
   186:                 !
   187:             
   188:                 ! モジュール引用 ; USE statements
   189:                 !
   190:             
   191:                 ! 物理定数設定
   192:                 ! Physical constants settings
   193:                 !
   194:                 use constants, only: &
   195:                   & GasRWet, &
   196:                                           ! $ R_v $ [J kg-1 K-1]. 
   197:                                           ! 凝結成分の気体定数. 
   198:                                           ! Gas constant of condensible elements
   199:                   & LatentHeat, &
   200:                                           ! $ L $ [J kg-1] . 
   201:                                           ! 凝結の潜熱. 
   202:                                           ! Latent heat of condensation
   203:                   & LatentHeatFusion, &
   204:                                           ! $ L $ [J kg-1] .
   205:                                           ! 融解の潜熱.
   206:                                           ! Latent heat of fusion
   207:                   & EpsV                  ! $ \epsilon_v $ . 
   208:                                           ! 水蒸気分子量比. 
   209:                                           ! Molecular weight of water vapor
   210:             
   211:                 ! 宣言文 ; Declaration statements
   212:                 !
   213:                 implicit none
   214:             
   215:                 real(DP), intent(in):: xyz_Temp   (:,:,:)
   216:                                           ! $ T $ . 温度. Temperature
   217:                 real(DP), intent(in):: xyz_QVapSat(:,:,:)
   218:                                           ! $ q^{*} $ . 飽和比湿. Saturation specific humidity
   219:                 real(DP):: xyz_DQVapSatDTemp(size(xyz_Temp,1), size(xyz_Temp,2), size(xyz_Temp,3))
   220:                                           ! $ \DP{q^{*}}{T} $ . 飽和比湿の温度微分. 
   221:                                           ! Temperature derivative of saturation specific humidity. 
   222:             
   223:                 ! 作業変数
   224:                 ! Work variables
   225:                 !
   226:                 real(DP):: LatentHeatLocal
   227:                                           !
   228:                                           ! Latent heat used in this routine
   229:             
   230:             
   231:                 ! 実行文 ; Executable statement
   232:                 !
   233:             
   234:                 if ( .not. saturate_DennouAGCM_inited ) then
   235:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   236:                 end if
   237:             
   238:                 ! Set a value for latent heat
   239:                 LatentHeatLocal = LatentHeat
   240:             
   241: ++V==== A       xyz_DQVapSatDTemp = LatentHeatLocal * xyz_QVapSat / ( GasRWet * xyz_Temp**2 )
   242:             
   243:             
   244:               end function xyz_CalcDQVapSatDTempOnLiq
   245:             
   246:               !--------------------------------------------------------------------------------------
   247:             
   248:               function xyz_CalcQVapSatOnSol( xyz_Temp, xyz_Press ) result( xyz_QVapSat )
   249:                 !
   250:                 ! 温度 *Temp* と気圧 *Press* を用い, 
   251:                 ! 飽和比湿 *QVapSat* を求めます. 
   252:                 !
   253:                 ! Calculate saturation specific humidity *QVapSat* using
   254:                 ! temperature *Temp* and air pressure *Press*. 
   255:                 !
   256:             
   257:                 ! モジュール引用 ; USE statements
   258:                 !
   259:             
   260:                 ! 物理定数設定
   261:                 ! Physical constants settings
   262:                 !
   263:                 use constants, only: &
   264:                   & GasRWet, &
   265:                                           ! $ R_v $ [J kg-1 K-1]. 
   266:                                           ! 凝結成分の気体定数. 
   267:                                           ! Gas constant of condensible elements
   268:                   & LatentHeat, &
   269:                                           ! $ L $ [J kg-1] . 
   270:                                           ! 凝結の潜熱. 
   271:                                           ! Latent heat of condensation
   272:                   & LatentHeatFusion, &
   273:                                           ! $ L $ [J kg-1] .
   274:                                           ! 融解の潜熱.
   275:                                           ! Latent heat of fusion
   276:                   & EpsV                  ! $ \epsilon_v $ . 
   277:                                           ! 水蒸気分子量比. 
   278:                                           ! Molecular weight of water vapor
   279:             
   280:                 ! 宣言文 ; Declaration statements
   281:                 !
   282:                 implicit none
   283:             
   284:                 real(DP), intent(in):: xyz_Temp (:,:,:)
   285:                                           ! $ T $ . 温度. Temperature
   286:                 real(DP), intent(in):: xyz_Press(:,:,:)
   287:                                           ! $ p $ . 気圧. Air pressure
   288:             
   289:                 real(DP):: xyz_QVapSat(1:size(xyz_Temp,1), 1:size(xyz_Temp,2), 1:size(xyz_Temp,3))
   290:                                           ! $ q^{*} $ . 飽和比湿. Saturation specific humidity
   291:             
   292:                 ! 作業変数
   293:                 ! Work variables
   294:                 !
   295:                 real(DP):: LatentHeatLocal
   296:                                           !
   297:                                           ! Latent heat used in this routine
   298:             
   299:             
   300:                 ! 実行文 ; Executable statement
   301:                 !
   302:             
   303:                 ! 初期化確認
   304:                 ! Initialization check
   305:                 !
   306:             
   307:                 if ( .not. saturate_DennouAGCM_inited ) then
   308:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   309:                 end if
   310:             
   311:                 ! Set a value for latent heat
   312:                 LatentHeatLocal = LatentHeat + LatentHeatFusion
   313:             
   314: ++V==== A       xyz_QVapSat = &
   315:                   & EpsV * Es0 * exp( LatentHeatLocal / GasRWet * ( 1./273. - 1./xyz_Temp ) ) &
   316:                   & / xyz_Press
   317:             
   318:             
   319:               end function xyz_CalcQVapSatOnSol
   320:             
   321:               !--------------------------------------------------------------------------------------
   322:             
   323:               function xyz_CalcDQVapSatDTempOnSol( xyz_Temp, xyz_QVapSat ) result( xyz_DQVapSatDTemp )
   324:                 !
   325:                 ! 温度 *Temp* と飽和比湿 *QVapSat* を用い, 
   326:                 ! 飽和比湿の温度微分 *DQVapSatDTemp* を求めます. 
   327:                 !
   328:                 ! Calculate temperature derivative of saturation specific humidity 
   329:                 ! *DQVapSatDTemp* using
   330:                 ! temperature *Temp* and saturation specific humidity *QVapSat*. 
   331:                 !
   332:             
   333:                 ! モジュール引用 ; USE statements
   334:                 !
   335:             
   336:                 ! 物理定数設定
   337:                 ! Physical constants settings
   338:                 !
   339:                 use constants, only: &
   340:                   & GasRWet, &
   341:                                           ! $ R_v $ [J kg-1 K-1]. 
   342:                                           ! 凝結成分の気体定数. 
   343:                                           ! Gas constant of condensible elements
   344:                   & LatentHeat, &
   345:                                           ! $ L $ [J kg-1] . 
   346:                                           ! 凝結の潜熱. 
   347:                                           ! Latent heat of condensation
   348:                   & LatentHeatFusion, &
   349:                                           ! $ L $ [J kg-1] .
   350:                                           ! 融解の潜熱.
   351:                                           ! Latent heat of fusion
   352:                   & EpsV                  ! $ \epsilon_v $ . 
   353:                                           ! 水蒸気分子量比. 
   354:                                           ! Molecular weight of water vapor
   355:             
   356:                 ! 宣言文 ; Declaration statements
   357:                 !
   358:                 implicit none
   359:             
   360:                 real(DP), intent(in):: xyz_Temp   (:,:,:)
   361:                                           ! $ T $ . 温度. Temperature
   362:                 real(DP), intent(in):: xyz_QVapSat(:,:,:)
   363:                                           ! $ q^{*} $ . 飽和比湿. Saturation specific humidity
   364:                 real(DP):: xyz_DQVapSatDTemp(size(xyz_Temp,1), size(xyz_Temp,2), size(xyz_Temp,3))
   365:                                           ! $ \DP{q^{*}}{T} $ . 飽和比湿の温度微分. 
   366:                                           ! Temperature derivative of saturation specific humidity. 
   367:             
   368:                 ! 作業変数
   369:                 ! Work variables
   370:                 !
   371:                 real(DP):: LatentHeatLocal
   372:                                           !
   373:                                           ! Latent heat used in this routine
   374:             
   375:             
   376:                 ! 実行文 ; Executable statement
   377:                 !
   378:             
   379:                 if ( .not. saturate_DennouAGCM_inited ) then
   380:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   381:                 end if
   382:             
   383:                 ! Set a value for latent heat
   384:                 LatentHeatLocal = LatentHeat + LatentHeatFusion
   385:             
   386: ++V==== A       xyz_DQVapSatDTemp = LatentHeatLocal * xyz_QVapSat / ( GasRWet * xyz_Temp**2 )
   387:             
   388:             
   389:               end function xyz_CalcDQVapSatDTempOnSol
   390:             
   391:               !--------------------------------------------------------------------------------------
   392:             
   393:               subroutine SaturateInit
   394:                 !
   395:                 ! saturate_DennouAGCM モジュールの初期化を行います. 
   396:                 !--
   397:                 ! NAMELIST#saturate_DennouAGCM_nml の読み込みはこの手続きで行われます. 
   398:                 !++
   399:                 !
   400:                 ! "saturate_DennouAGCM" module is initialized. 
   401:                 !--
   402:                 ! "NAMELIST#saturate_DennouAGCM_nml" is loaded in this procedure. 
   403:                 !++
   404:             
   405:                 ! モジュール引用 ; USE statements
   406:                 !
   407:             
   408:                 ! NAMELIST ファイル入力に関するユーティリティ
   409:                 ! Utilities for NAMELIST file input
   410:                 !
   411:                 use namelist_util, only: namelist_filename, NmlutilMsg
   412:             
   413:                 ! ファイル入出力補助
   414:                 ! File I/O support
   415:                 !
   416:                 use dc_iounit, only: FileOpen
   417:             
   418:                 ! 種別型パラメタ
   419:                 ! Kind type parameter
   420:                 !
   421:                 use dc_types, only: STDOUT ! 標準出力の装置番号. Unit number of standard output
   422:             
   423:                 ! 文字列操作
   424:                 ! Character handling
   425:                 !
   426:                 use dc_string, only: StoA
   427:             
   428:                 ! ヒストリデータ出力
   429:                 ! History data output
   430:                 !
   431:                 use gtool_historyauto, only: HistoryAutoAddVariable
   432:             
   433:                 ! 宣言文 ; Declaration statements
   434:                 !
   435:                 implicit none
   436:             
   437:                 integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号. 
   438:                                           ! Unit number for NAMELIST file open
   439:                 integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT. 
   440:                                           ! IOSTAT of NAMELIST read
   441:             
   442:                 ! NAMELIST 変数群
   443:                 ! NAMELIST group name
   444:                 !
   445:             !!$    namelist /saturate_DennouAGCM_nml/ &
   446:             !!$      & FlagSublimation
   447:                       !
   448:                       ! デフォルト値については初期化手続 "saturate_DennouAGCM#SaturateInit" 
   449:                       ! のソースコードを参照のこと. 
   450:                       !
   451:                       ! Refer to source codes in the initialization procedure
   452:                       ! "saturate_DennouAGCM#SaturateInit" for the default values. 
   453:                       !
   454:             
   455:                 ! 実行文 ; Executable statement
   456:                 !
   457:             
   458:                 if ( saturate_DennouAGCM_inited ) return
   459:             
   460:             
   461:                 ! デフォルト値の設定
   462:                 ! Default values settings
   463:                 !
   464:             
   465:             
   466:                 ! NAMELIST の読み込み
   467:                 ! NAMELIST is input
   468:                 !
   469:             !!$    if ( trim(namelist_filename) /= '' ) then
   470:             !!$      call FileOpen( unit_nml, &          ! (out)
   471:             !!$        & namelist_filename, mode = 'r' ) ! (in)
   472:             !!$
   473:             !!$      rewind( unit_nml )
   474:             !!$      read( unit_nml, &           ! (in)
   475:             !!$        & nml = saturate_DennouAGCM_nml, &  ! (out)
   476:             !!$        & iostat = iostat_nml )   ! (out)
   477:             !!$      close( unit_nml )
   478:             !!$
   479:             !!$      call NmlutilMsg( iostat_nml, module_name ) ! (in)
   480:             !!$    end if
   481:             
   482:                 ! 印字 ; Print
   483:                 !
   484:                 call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   485:             !!$    call MessageNotify( 'M', module_name, '  FlagSublimation = %b', l = (/ FlagSublimation /) )
   486:                 call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   487:             
   488:                 saturate_DennouAGCM_inited = .true.
   489:             
   490:               end subroutine SaturateInit
   491:             
   492:               !--------------------------------------------------------------------------------------
   493:             
   494:             end module saturate_DennouAGCM
