Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:27 2016
FILE NAME: saturate_co2_p81.f90
PROGRAM NAME: saturate_co2_p81
DIAGNOSTIC LIST

  LINE  LEVEL( NO.): DIAGNOSTIC MESSAGE

   142  opt  (1592): Outer loop unrolled inside inner loop.
   142  vec  (   4): Vectorized array expression.
   142  vec  (  29): ADB is used for array.: xyz_press
   142  vec  (   4): Vectorized array expression.
   142  vec  (  29): ADB is used for array.: xyz_press
   188  opt  (1592): Outer loop unrolled inside inner loop.
   188  vec  (   4): Vectorized array expression.
   188  vec  (  29): ADB is used for array.: xyz_temp
   188  vec  (   4): Vectorized array expression.
   188  vec  (  29): ADB is used for array.: xyz_temp
   234  opt  (1592): Outer loop unrolled inside inner loop.
   234  vec  (   4): Vectorized array expression.
   234  vec  (   4): Vectorized array expression.
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:27 2016
FILE NAME: saturate_co2_p81.f90
PROGRAM NAME: saturate_co2_p81
TRANSFORMATION LIST

  LINE                   FORTRAN STATEMENT

     1  !=
     2  !
     3  != CO2 condensation temperature (Pollack et al., 1981)
     4  !
     5  ! Authors::   Yoshiyuki O. Takahashi
     6  ! Version::   $Id: saturate_co2_p81.f90,v 1.2 2014/05/07 09:39:21 murashin Exp $
     7  ! Tag Name::  $Name:  $
     8  ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9  ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10  !
    11  
    12  module saturate_co2_p81
    13    !
    14    !=
    15    !
    16    != CO2 condensation temperature (Pollack et al., 1981)
    17    !
    18    ! <b>Note that Japanese and English are described in parallel.</b>
    19    !
    20    !== References
    21    !
    22    ! * Pollack, J. B., C. B. Leovy, P. W. Greiman, and Y. Mintz, 1981:
    23    !   A Martian general circulation experiment with large topography,
    24    !   <i>J. Atmos. Sci.</i>, <b>38</b>, 3--29.
    25    !
    26    !== Procedures List
    27    !
    28  !!$  ! DryConvAdjust :: 乾燥対流調節
    29  !!$  ! ------------  :: ------------
    30  !!$  ! DryConvAdjust :: Dry convective adjustment
    31    !
    32    !== NAMELIST
    33    !
    34    ! NAMELIST#major_comp_saturate_nml
    35    !
    36  
    37    ! モジュール引用 ; USE statements
    38    !
    39  
    40    ! 種別型パラメタ
    41    ! Kind type parameter
    42    !
    43    use dc_types, only: DP, &      ! 倍精度実数型. Double precision.
    44      &                 STRING     ! 文字列.       Strings.
    45  
    46    ! NAMELIST ファイル入力に関するユーティリティ
    47    ! Utilities for NAMELIST file input
    48    !
    49    use namelist_util, only: MaxNmlArySize
    50                                ! NAMELIST から読み込む配列の最大サイズ.
    51                                ! Maximum size of arrays loaded from NAMELIST
    52  
    53    ! メッセージ出力
    54    ! Message output
    55    !
    56    use dc_message, only: MessageNotify
    57  
    58    ! 宣言文 ; Declaration statements
    59    !
    60    implicit none
    61    private
    62  
    63  
    64    ! 公開手続き
    65    ! Public procedure
    66    !
    67    public :: xyz_SaturateCO2P81TempCond
    68    public :: xyz_SaturateCO2P81PressSat
    69    public :: xyz_SaturateCO2P81DPressSatDT
    70    public :: SaturateCO2P81Init
    71  
    72  
    73    ! 公開変数
    74    ! Public variables
    75    !
    76    logical, save, public:: saturate_co2_p81_inited = .false.
    77                                ! 初期設定フラグ.
    78                                ! Initialization flag
    79  
    80    ! 非公開変数
    81    ! Private variables
    82    !
    83    real(DP), parameter :: ConstTemp0 = 149.2_DP
    84    real(DP), parameter :: ConstAlpha = 6.48_DP
    85    real(DP), parameter :: ConstBeta  = 0.135e-2_DP
    86  
    87  
    88    character(*), parameter:: module_name = 'saturate_co2_p81'
    89                                ! モジュールの名称.
    90                                ! Module name
    91    character(*), parameter:: version = &
    92      & '$Name:  $' // &
    93      & '$Id: saturate_co2_p81.f90,v 1.2 2014/05/07 09:39:21 murashin Exp $'
    94                                ! モジュールのバージョン
    95                                ! Module version
    96  
    97  
    98  contains
    99  
   100    !--------------------------------------------------------------------------------------
   101  
   102    function xyz_SaturateCO2P81TempCond( xyz_Press ) result( xyz_TempCond )
   103      !
   104      ! CO2 相変化
   105      !
   106      ! CO2 phase change
   107      !
   108  
   109      ! モジュール引用 ; USE statements
   110      !
   111  
   112  
   113      ! 宣言文 ; Declaration statements
   114      !
   115      implicit none
   116  
   117      real(DP), intent(in ):: xyz_Press   (:,:,:)
   118                                ! $ p $ . 気圧 (整数レベル).
   119                                ! Air pressure (full level)
   120      real(DP) :: xyz_TempCond(size(xyz_Press,1), size(xyz_Press,2), size(xyz_Press,3))
   121                                !
   122                                ! Condensation temperature
   123  
   124      ! 作業変数
   125      ! Work variables
   126      !
   127  
   128      ! 実行文 ; Executable statement
   129      !
   130  
   131  
   132      ! 初期化
   133      ! Initialization
   134      !
   135      if ( .not. saturate_co2_p81_inited ) then
   136        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   137      end if
   138  
   139      ! CO2 condensation temperature (Pollack et al., 1981)
   140  
   141  !!$    xyz_TempCond = 149.2_DP + 6.48_DP * log( 0.135_DP * xyz_Press * 1.0e-2_DP )
   142      xyz_TempCond = ConstTemp0 + ConstAlpha * log( ConstBeta * xyz_Press )
     .        if (xyz_press.DSC.U2 .gt. 0) then                                 
     .           j4 = and(xyz_press.DSC.U2,3)                                   
     .  !cdir    nodep                                                          
     .           do t49 = 1, j4                                                 
     .  !cdir       nodep                                                       
     .              do t51 = 1, xyz_press.DSC.U1                                
     .                 xyz_tempcond(t51,t49,t47+1) = 1.49199999999999e+002 +    
     .       1            6.48000000000000e+000*dlog(1.35000000000000e-003*     
     .       2            xyz_press(t51,t49,t47+1))                             
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t49 = j4 + 1, xyz_press.DSC.U2, 4                           
     .  !cdir       nodep                                                       
     .              do t51 = 1, xyz_press.DSC.U1                                
     .                 xyz_tempcond(t51,t49,t47+1) = 1.49199999999999e+002 +    
     .       1            6.48000000000000e+000*dlog(1.35000000000000e-003*     
     .       2            xyz_press(t51,t49,t47+1))                             
     .                 xyz_tempcond(t51,t49+1,t47+1) = 1.49199999999999e+002 +  
     .       1            6.48000000000000e+000*dlog(1.35000000000000e-003*     
     .       2            xyz_press(t51,t49+1,t47+1))                           
     .                 xyz_tempcond(t51,t49+2,t47+1) = 1.49199999999999e+002 +  
     .       1            6.48000000000000e+000*dlog(1.35000000000000e-003*     
     .       2            xyz_press(t51,t49+2,t47+1))                           
     .                 xyz_tempcond(t51,t49+3,t47+1) = 1.49199999999999e+002 +  
     .       1            6.48000000000000e+000*dlog(1.35000000000000e-003*     
     .       2            xyz_press(t51,t49+3,t47+1))                           
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
   143  
   144  
   145    end function xyz_SaturateCO2P81TempCond
   146  
   147    !--------------------------------------------------------------------------------------
   148  
   149    function xyz_SaturateCO2P81PressSat( xyz_Temp ) result( xyz_Press )
   150      !
   151      ! CO2 相変化
   152      !
   153      ! CO2 phase change
   154      !
   155  
   156      ! モジュール引用 ; USE statements
   157      !
   158  
   159  
   160      ! 宣言文 ; Declaration statements
   161      !
   162      implicit none
   163  
   164      real(DP), intent(in ):: xyz_Temp (:,:,:)
   165                                ! $ T $ .
   166                                ! Air temperature
   167      real(DP) :: xyz_Press(size(xyz_Temp,1), size(xyz_Temp,2), size(xyz_Temp,3))
   168                                !
   169                                ! Saturation pressure
   170  
   171      ! 作業変数
   172      ! Work variables
   173      !
   174  
   175      ! 実行文 ; Executable statement
   176      !
   177  
   178  
   179      ! 初期化
   180      ! Initialization
   181      !
   182      if ( .not. saturate_co2_p81_inited ) then
   183        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   184      end if
   185  
   186      ! CO2 condensation temperature (Pollack et al., 1981)
   187  
   188      xyz_Press = 1.0_DP / ConstBeta * exp( ( xyz_Temp - ConstTemp0 ) / ConstAlpha )
     .        if (xyz_temp.DSC.U2 .gt. 0) then                                  
     .           j4 = and(xyz_temp.DSC.U2,3)                                    
     .  !cdir    nodep                                                          
     .           do t49 = 1, j4                                                 
     .              d1 = 1.D0/6.48000000000000e+000                             
     .  !cdir       nodep                                                       
     .              do t51 = 1, xyz_temp.DSC.U1                                 
     .                 xyz_press(t51,t49,t47+1) = 7.40740740740740e+002*dexp((  
     .       1            xyz_temp(t51,t49,t47+1)-1.49199999999999e+002)*d1)    
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t49 = j4 + 1, xyz_temp.DSC.U2, 4                            
     .              d2 = 1.D0/6.48000000000000e+000                             
     .              d3 = 1.D0/6.48000000000000e+000                             
     .              d4 = 1.D0/6.48000000000000e+000                             
     .              d5 = 1.D0/6.48000000000000e+000                             
     .  !cdir       nodep                                                       
     .              do t51 = 1, xyz_temp.DSC.U1                                 
     .                 xyz_press(t51,t49,t47+1) = 7.40740740740740e+002*dexp((  
     .       1            xyz_temp(t51,t49,t47+1)-1.49199999999999e+002)*d2)    
     .                 xyz_press(t51,t49+1,t47+1) = 7.40740740740740e+002*dexp((
     .       1            xyz_temp(t51,t49+1,t47+1)-1.49199999999999e+002)*d3)  
     .                 xyz_press(t51,t49+2,t47+1) = 7.40740740740740e+002*dexp((
     .       1            xyz_temp(t51,t49+2,t47+1)-1.49199999999999e+002)*d4)  
     .                 xyz_press(t51,t49+3,t47+1) = 7.40740740740740e+002*dexp((
     .       1            xyz_temp(t51,t49+3,t47+1)-1.49199999999999e+002)*d5)  
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
   189  
   190  
   191    end function xyz_SaturateCO2P81PressSat
   192  
   193    !--------------------------------------------------------------------------------------
   194  
   195    function xyz_SaturateCO2P81DPressSatDT( xyz_Temp ) result( xyz_DPressSatDT )
   196      !
   197      ! CO2 相変化
   198      !
   199      ! CO2 phase change
   200      !
   201  
   202      ! モジュール引用 ; USE statements
   203      !
   204  
   205  
   206      ! 宣言文 ; Declaration statements
   207      !
   208      implicit none
   209  
   210      real(DP), intent(in ):: xyz_Temp (:,:,:)
   211                                ! $ T $ .
   212                                ! Air temperature
   213      real(DP) :: xyz_DPressSatDT(size(xyz_Temp,1), size(xyz_Temp,2), size(xyz_Temp,3))
   214                                !
   215                                ! Derivative of Condensation temperature with temperature
   216  
   217      ! 作業変数
   218      ! Work variables
   219      !
   220  
   221      ! 実行文 ; Executable statement
   222      !
   223  
   224  
   225      ! 初期化
   226      ! Initialization
   227      !
   228      if ( .not. saturate_co2_p81_inited ) then
   229        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   230      end if
   231  
   232      ! CO2 condensation temperature (Pollack et al., 1981)
   233  
   234      xyz_DPressSatDT = xyz_SaturateCO2P81PressSat( xyz_Temp ) / ConstAlpha
     .        if (%00006b.DSC.U2 .gt. 0) then                                   
     .           j4 = and(%00006b.DSC.U2,3)                                     
     .  !cdir    nodep                                                          
     .           do t58 = 1, j4                                                 
     .              d1 = 1.D0/6.48000000000000e+000                             
     .  !cdir       nodep                                                       
     .              do t60 = 1, %00006b.DSC.U1                                  
     .                 xyz_dpresssatdt(t60,t58,t56+1) = %00006b(t60,t58,t56+1)* 
     .       1            d1                                                    
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t58 = j4 + 1, %00006b.DSC.U2, 4                             
     .              d2 = 1.D0/6.48000000000000e+000                             
     .              d3 = 1.D0/6.48000000000000e+000                             
     .              d4 = 1.D0/6.48000000000000e+000                             
     .              d5 = 1.D0/6.48000000000000e+000                             
     .  !cdir       nodep                                                       
     .              do t60 = 1, %00006b.DSC.U1                                  
     .                 xyz_dpresssatdt(t60,t58,t56+1) = %00006b(t60,t58,t56+1)* 
     .       1            d2                                                    
     .                 xyz_dpresssatdt(t60,t58+1,t56+1) = %00006b(t60,t58+1,t56+
     .       1            1)*d3                                                 
     .                 xyz_dpresssatdt(t60,t58+2,t56+1) = %00006b(t60,t58+2,t56+
     .       1            1)*d4                                                 
     .                 xyz_dpresssatdt(t60,t58+3,t56+1) = %00006b(t60,t58+3,t56+
     .       1            1)*d5                                                 
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
   235  
   236  
   237    end function xyz_SaturateCO2P81DPressSatDT
   238  
   239    !--------------------------------------------------------------------------------------
   240  
   241    subroutine SaturateCO2P81Init
   242      !
   243      ! saturate_co2_p81 モジュールの初期化を行います.
   244      ! NAMELIST#saturate_co2_p81_nml の読み込みはこの手続きで行われます.
   245      !
   246      ! "saturate_co2_p81" module is initialized.
   247      ! "NAMELIST#saturate_co2_p81_nml" is loaded in this procedure.
   248      !
   249  
   250      ! モジュール引用 ; USE statements
   251      !
   252  
   253  !!$    ! NAMELIST ファイル入力に関するユーティリティ
   254  !!$    ! Utilities for NAMELIST file input
   255  !!$    !
   256  !!$    use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid
   257  !!$
   258  !!$    ! ファイル入出力補助
   259  !!$    ! File I/O support
   260  !!$    !
   261  !!$    use dc_iounit, only: FileOpen
   262  !!$
   263  !!$    ! 種別型パラメタ
   264  !!$    ! Kind type parameter
   265  !!$    !
   266  !!$    use dc_types, only: STDOUT ! 標準出力の装置番号. Unit number of standard output
   267  
   268      ! 文字列操作
   269      ! Character handling
   270      !
   271      use dc_string, only: StoA
   272  
   273  
   274      ! 宣言文 ; Declaration statements
   275      !
   276      implicit none
   277  
   278  
   279  !!$    integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号.
   280  !!$                              ! Unit number for NAMELIST file open
   281  !!$    integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT.
   282  !!$                              ! IOSTAT of NAMELIST read
   283  
   284      ! NAMELIST 変数群
   285      ! NAMELIST group name
   286      !
   287  !!$    namelist /major_comp_saturate_nml/ &
   288  !!$      & FlagUse
   289  
   290            ! デフォルト値については初期化手続 "major_comp_saturate#MajorCompSaturateInit"
   291            ! のソースコードを参照のこと.
   292            !
   293            ! Refer to source codes in the initialization procedure
   294            ! "major_comp_saturate#MajorCompSaturateInit" for the default values.
   295            !
   296  
   297      ! 実行文 ; Executable statement
   298      !
   299  
   300      if ( saturate_co2_p81_inited ) return
   301  
   302  
   303      ! デフォルト値の設定
   304      ! Default values settings
   305      !
   306  
   307  
   308      ! NAMELIST の読み込み
   309      ! NAMELIST is input
   310      !
   311  !!$    if ( trim(namelist_filename) /= '' ) then
   312  !!$      call FileOpen( unit_nml, &          ! (out)
   313  !!$        & namelist_filename, mode = 'r' ) ! (in)
   314  !!$
   315  !!$      rewind( unit_nml )
   316  !!$      read( unit_nml,                    &  ! (in)
   317  !!$        & nml = major_comp_saturate_nml, &  ! (out)
   318  !!$        & iostat = iostat_nml )             ! (out)
   319  !!$      close( unit_nml )
   320  !!$
   321  !!$      call NmlutilMsg( iostat_nml, module_name ) ! (in)
   322  !!$!      if ( iostat_nml == 0 ) write( STDOUT, nml = cumulus_adjust_nml )
   323  !!$    end if
   324  
   325  
   326      ! 印字 ; Print
   327      !
   328      call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   329      call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   330  
   331  
   332      saturate_co2_p81_inited = .true.
   333  
   334    end subroutine SaturateCO2P81Init
   335  
   336    !-------------------------------------------------------------------
   337  
   338  end module saturate_co2_p81
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:27 2016
FILE NAME: saturate_co2_p81.f90
PROGRAM NAME: saturate_co2_p81
FORMAT LIST

  LINE    LOOP      FORTRAN STATEMENT

     1:             != 
     2:             !
     3:             != CO2 condensation temperature (Pollack et al., 1981)
     4:             !
     5:             ! Authors::   Yoshiyuki O. Takahashi
     6:             ! Version::   $Id: saturate_co2_p81.f90,v 1.2 2014/05/07 09:39:21 murashin Exp $ 
     7:             ! Tag Name::  $Name:  $
     8:             ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9:             ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10:             !
    11:             
    12:             module saturate_co2_p81
    13:               !
    14:               != 
    15:               !
    16:               != CO2 condensation temperature (Pollack et al., 1981)
    17:               !
    18:               ! <b>Note that Japanese and English are described in parallel.</b>
    19:               !
    20:               !== References
    21:               !
    22:               ! * Pollack, J. B., C. B. Leovy, P. W. Greiman, and Y. Mintz, 1981:
    23:               !   A Martian general circulation experiment with large topography, 
    24:               !   <i>J. Atmos. Sci.</i>, <b>38</b>, 3--29.
    25:               !
    26:               !== Procedures List
    27:               ! 
    28:             !!$  ! DryConvAdjust :: 乾燥対流調節
    29:             !!$  ! ------------  :: ------------
    30:             !!$  ! DryConvAdjust :: Dry convective adjustment
    31:               !
    32:               !== NAMELIST
    33:               !
    34:               ! NAMELIST#major_comp_saturate_nml
    35:               !
    36:             
    37:               ! モジュール引用 ; USE statements
    38:               !
    39:             
    40:               ! 種別型パラメタ
    41:               ! Kind type parameter
    42:               !
    43:               use dc_types, only: DP, &      ! 倍精度実数型. Double precision. 
    44:                 &                 STRING     ! 文字列.       Strings. 
    45:             
    46:               ! NAMELIST ファイル入力に関するユーティリティ
    47:               ! Utilities for NAMELIST file input
    48:               !
    49:               use namelist_util, only: MaxNmlArySize
    50:                                           ! NAMELIST から読み込む配列の最大サイズ. 
    51:                                           ! Maximum size of arrays loaded from NAMELIST
    52:             
    53:               ! メッセージ出力
    54:               ! Message output
    55:               !
    56:               use dc_message, only: MessageNotify
    57:             
    58:               ! 宣言文 ; Declaration statements
    59:               !
    60:               implicit none
    61:               private
    62:             
    63:             
    64:               ! 公開手続き
    65:               ! Public procedure
    66:               !
    67:               public :: xyz_SaturateCO2P81TempCond
    68:               public :: xyz_SaturateCO2P81PressSat
    69:               public :: xyz_SaturateCO2P81DPressSatDT
    70:               public :: SaturateCO2P81Init
    71:             
    72:             
    73:               ! 公開変数
    74:               ! Public variables
    75:               !
    76:               logical, save, public:: saturate_co2_p81_inited = .false.
    77:                                           ! 初期設定フラグ. 
    78:                                           ! Initialization flag
    79:             
    80:               ! 非公開変数
    81:               ! Private variables
    82:               !
    83:               real(DP), parameter :: ConstTemp0 = 149.2_DP
    84:               real(DP), parameter :: ConstAlpha = 6.48_DP
    85:               real(DP), parameter :: ConstBeta  = 0.135e-2_DP
    86:             
    87:             
    88:               character(*), parameter:: module_name = 'saturate_co2_p81'
    89:                                           ! モジュールの名称. 
    90:                                           ! Module name
    91:               character(*), parameter:: version = &
    92:                 & '$Name:  $' // &
    93:                 & '$Id: saturate_co2_p81.f90,v 1.2 2014/05/07 09:39:21 murashin Exp $'
    94:                                           ! モジュールのバージョン
    95:                                           ! Module version
    96:             
    97:             
    98:             contains
    99:             
   100:               !--------------------------------------------------------------------------------------
   101:             
   102:               function xyz_SaturateCO2P81TempCond( xyz_Press ) result( xyz_TempCond )
   103:                 !
   104:                 ! CO2 相変化
   105:                 !
   106:                 ! CO2 phase change
   107:                 !
   108:             
   109:                 ! モジュール引用 ; USE statements
   110:                 !
   111:             
   112:             
   113:                 ! 宣言文 ; Declaration statements
   114:                 !
   115:                 implicit none
   116:             
   117:                 real(DP), intent(in ):: xyz_Press   (:,:,:)
   118:                                           ! $ p $ . 気圧 (整数レベル). 
   119:                                           ! Air pressure (full level)
   120:                 real(DP) :: xyz_TempCond(size(xyz_Press,1), size(xyz_Press,2), size(xyz_Press,3))
   121:                                           !
   122:                                           ! Condensation temperature
   123:             
   124:                 ! 作業変数
   125:                 ! Work variables
   126:                 !
   127:             
   128:                 ! 実行文 ; Executable statement
   129:                 !
   130:             
   131:             
   132:                 ! 初期化
   133:                 ! Initialization
   134:                 !
   135:                 if ( .not. saturate_co2_p81_inited ) then
   136:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   137:                 end if
   138:             
   139:                 ! CO2 condensation temperature (Pollack et al., 1981)
   140:             
   141:             !!$    xyz_TempCond = 149.2_DP + 6.48_DP * log( 0.135_DP * xyz_Press * 1.0e-2_DP )
   142: ++V==== A       xyz_TempCond = ConstTemp0 + ConstAlpha * log( ConstBeta * xyz_Press )
   143:             
   144:             
   145:               end function xyz_SaturateCO2P81TempCond
   146:             
   147:               !--------------------------------------------------------------------------------------
   148:             
   149:               function xyz_SaturateCO2P81PressSat( xyz_Temp ) result( xyz_Press )
   150:                 !
   151:                 ! CO2 相変化
   152:                 !
   153:                 ! CO2 phase change
   154:                 !
   155:             
   156:                 ! モジュール引用 ; USE statements
   157:                 !
   158:             
   159:             
   160:                 ! 宣言文 ; Declaration statements
   161:                 !
   162:                 implicit none
   163:             
   164:                 real(DP), intent(in ):: xyz_Temp (:,:,:)
   165:                                           ! $ T $ . 
   166:                                           ! Air temperature
   167:                 real(DP) :: xyz_Press(size(xyz_Temp,1), size(xyz_Temp,2), size(xyz_Temp,3))
   168:                                           !
   169:                                           ! Saturation pressure
   170:             
   171:                 ! 作業変数
   172:                 ! Work variables
   173:                 !
   174:             
   175:                 ! 実行文 ; Executable statement
   176:                 !
   177:             
   178:             
   179:                 ! 初期化
   180:                 ! Initialization
   181:                 !
   182:                 if ( .not. saturate_co2_p81_inited ) then
   183:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   184:                 end if
   185:             
   186:                 ! CO2 condensation temperature (Pollack et al., 1981)
   187:             
   188: ++V==== A       xyz_Press = 1.0_DP / ConstBeta * exp( ( xyz_Temp - ConstTemp0 ) / ConstAlpha )
   189:             
   190:             
   191:               end function xyz_SaturateCO2P81PressSat
   192:             
   193:               !--------------------------------------------------------------------------------------
   194:             
   195:               function xyz_SaturateCO2P81DPressSatDT( xyz_Temp ) result( xyz_DPressSatDT )
   196:                 !
   197:                 ! CO2 相変化
   198:                 !
   199:                 ! CO2 phase change
   200:                 !
   201:             
   202:                 ! モジュール引用 ; USE statements
   203:                 !
   204:             
   205:             
   206:                 ! 宣言文 ; Declaration statements
   207:                 !
   208:                 implicit none
   209:             
   210:                 real(DP), intent(in ):: xyz_Temp (:,:,:)
   211:                                           ! $ T $ . 
   212:                                           ! Air temperature
   213:                 real(DP) :: xyz_DPressSatDT(size(xyz_Temp,1), size(xyz_Temp,2), size(xyz_Temp,3))
   214:                                           !
   215:                                           ! Derivative of Condensation temperature with temperature
   216:             
   217:                 ! 作業変数
   218:                 ! Work variables
   219:                 !
   220:             
   221:                 ! 実行文 ; Executable statement
   222:                 !
   223:             
   224:             
   225:                 ! 初期化
   226:                 ! Initialization
   227:                 !
   228:                 if ( .not. saturate_co2_p81_inited ) then
   229:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   230:                 end if
   231:             
   232:                 ! CO2 condensation temperature (Pollack et al., 1981)
   233:             
   234: ++V====         xyz_DPressSatDT = xyz_SaturateCO2P81PressSat( xyz_Temp ) / ConstAlpha
   235:             
   236:             
   237:               end function xyz_SaturateCO2P81DPressSatDT
   238:             
   239:               !--------------------------------------------------------------------------------------
   240:             
   241:               subroutine SaturateCO2P81Init
   242:                 !
   243:                 ! saturate_co2_p81 モジュールの初期化を行います. 
   244:                 ! NAMELIST#saturate_co2_p81_nml の読み込みはこの手続きで行われます. 
   245:                 !
   246:                 ! "saturate_co2_p81" module is initialized. 
   247:                 ! "NAMELIST#saturate_co2_p81_nml" is loaded in this procedure. 
   248:                 !
   249:             
   250:                 ! モジュール引用 ; USE statements
   251:                 !
   252:             
   253:             !!$    ! NAMELIST ファイル入力に関するユーティリティ
   254:             !!$    ! Utilities for NAMELIST file input
   255:             !!$    !
   256:             !!$    use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid
   257:             !!$
   258:             !!$    ! ファイル入出力補助
   259:             !!$    ! File I/O support
   260:             !!$    !
   261:             !!$    use dc_iounit, only: FileOpen
   262:             !!$
   263:             !!$    ! 種別型パラメタ
   264:             !!$    ! Kind type parameter
   265:             !!$    !
   266:             !!$    use dc_types, only: STDOUT ! 標準出力の装置番号. Unit number of standard output
   267:             
   268:                 ! 文字列操作
   269:                 ! Character handling
   270:                 !
   271:                 use dc_string, only: StoA
   272:             
   273:             
   274:                 ! 宣言文 ; Declaration statements
   275:                 !
   276:                 implicit none
   277:             
   278:             
   279:             !!$    integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号. 
   280:             !!$                              ! Unit number for NAMELIST file open
   281:             !!$    integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT. 
   282:             !!$                              ! IOSTAT of NAMELIST read
   283:             
   284:                 ! NAMELIST 変数群
   285:                 ! NAMELIST group name
   286:                 !
   287:             !!$    namelist /major_comp_saturate_nml/ &
   288:             !!$      & FlagUse
   289:             
   290:                       ! デフォルト値については初期化手続 "major_comp_saturate#MajorCompSaturateInit" 
   291:                       ! のソースコードを参照のこと. 
   292:                       !
   293:                       ! Refer to source codes in the initialization procedure
   294:                       ! "major_comp_saturate#MajorCompSaturateInit" for the default values. 
   295:                       !
   296:             
   297:                 ! 実行文 ; Executable statement
   298:                 !
   299:             
   300:                 if ( saturate_co2_p81_inited ) return
   301:             
   302:             
   303:                 ! デフォルト値の設定
   304:                 ! Default values settings
   305:                 !
   306:             
   307:             
   308:                 ! NAMELIST の読み込み
   309:                 ! NAMELIST is input
   310:                 !
   311:             !!$    if ( trim(namelist_filename) /= '' ) then
   312:             !!$      call FileOpen( unit_nml, &          ! (out)
   313:             !!$        & namelist_filename, mode = 'r' ) ! (in)
   314:             !!$
   315:             !!$      rewind( unit_nml )
   316:             !!$      read( unit_nml,                    &  ! (in)
   317:             !!$        & nml = major_comp_saturate_nml, &  ! (out)
   318:             !!$        & iostat = iostat_nml )             ! (out)
   319:             !!$      close( unit_nml )
   320:             !!$
   321:             !!$      call NmlutilMsg( iostat_nml, module_name ) ! (in)
   322:             !!$!      if ( iostat_nml == 0 ) write( STDOUT, nml = cumulus_adjust_nml )
   323:             !!$    end if
   324:             
   325:             
   326:                 ! 印字 ; Print
   327:                 !
   328:                 call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   329:                 call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   330:             
   331:             
   332:                 saturate_co2_p81_inited = .true.
   333:             
   334:               end subroutine SaturateCO2P81Init
   335:             
   336:               !-------------------------------------------------------------------
   337:             
   338:             end module saturate_co2_p81
