Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:28 2016
FILE NAME: saturate_major_comp.f90
PROGRAM NAME: saturate_major_comp
DIAGNOSTIC LIST

  LINE  LEVEL( NO.): DIAGNOSTIC MESSAGE

   174  opt  (1592): Outer loop unrolled inside inner loop.
   174  vec  (   4): Vectorized array expression.
   174  vec  (  29): ADB is used for array.: xyz_tempcond
   174  vec  (   4): Vectorized array expression.
   174  vec  (  29): ADB is used for array.: xyz_tempcond
   226  opt  (1592): Outer loop unrolled inside inner loop.
   226  vec  (   4): Vectorized array expression.
   226  vec  (  29): ADB is used for array.: xyz_press
   226  vec  (  29): ADB is used for array.: xy_press
   226  vec  (   4): Vectorized array expression.
   226  vec  (  29): ADB is used for array.: xyz_press
   226  vec  (  29): ADB is used for array.: xy_press
   233  opt  (1592): Outer loop unrolled inside inner loop.
   233  vec  (   4): Vectorized array expression.
   233  vec  (  29): ADB is used for array.: xy_tempcond
   233  vec  (  29): ADB is used for array.: xyz_tempcond
   233  vec  (   4): Vectorized array expression.
   233  vec  (  29): ADB is used for array.: xy_tempcond
   233  vec  (  29): ADB is used for array.: xyz_tempcond
   289  opt  (1592): Outer loop unrolled inside inner loop.
   289  vec  (   4): Vectorized array expression.
   289  vec  (  29): ADB is used for array.: xyz_press
   289  vec  (   4): Vectorized array expression.
   289  vec  (  29): ADB is used for array.: xyz_press
   341  opt  (1592): Outer loop unrolled inside inner loop.
   341  vec  (   4): Vectorized array expression.
   341  vec  (  29): ADB is used for array.: xyz_temp
   341  vec  (  29): ADB is used for array.: xy_temp
   341  vec  (   4): Vectorized array expression.
   341  vec  (  29): ADB is used for array.: xyz_temp
   341  vec  (  29): ADB is used for array.: xy_temp
   348  opt  (1592): Outer loop unrolled inside inner loop.
   348  vec  (   4): Vectorized array expression.
   348  vec  (  29): ADB is used for array.: xy_press
   348  vec  (  29): ADB is used for array.: xyz_press
   348  vec  (   4): Vectorized array expression.
   348  vec  (  29): ADB is used for array.: xy_press
   348  vec  (  29): ADB is used for array.: xyz_press
   404  opt  (1592): Outer loop unrolled inside inner loop.
   404  vec  (   4): Vectorized array expression.
   404  vec  (  29): ADB is used for array.: xyz_dpresssatdt
   404  vec  (   4): Vectorized array expression.
   404  vec  (  29): ADB is used for array.: xyz_dpresssatdt
   456  opt  (1592): Outer loop unrolled inside inner loop.
   456  vec  (   4): Vectorized array expression.
   456  vec  (  29): ADB is used for array.: xyz_temp
   456  vec  (  29): ADB is used for array.: xy_temp
   456  vec  (   4): Vectorized array expression.
   456  vec  (  29): ADB is used for array.: xyz_temp
   456  vec  (  29): ADB is used for array.: xy_temp
   463  opt  (1592): Outer loop unrolled inside inner loop.
   463  vec  (   4): Vectorized array expression.
   463  vec  (  29): ADB is used for array.: xy_dpresssatdt
   463  vec  (  29): ADB is used for array.: xyz_dpresssatdt
   463  vec  (   4): Vectorized array expression.
   463  vec  (  29): ADB is used for array.: xy_dpresssatdt
   463  vec  (  29): ADB is used for array.: xyz_dpresssatdt
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:28 2016
FILE NAME: saturate_major_comp.f90
PROGRAM NAME: saturate_major_comp
TRANSFORMATION LIST

  LINE                   FORTRAN STATEMENT

     1  != 主成分相変化
     2  !
     3  != Phase change of atmospheric major component
     4  !
     5  ! Authors::   Yoshiyuki O. Takahashi
     6  ! Version::   $Id: saturate_major_comp.f90,v 1.1 2013/09/30 02:55:27 yot Exp $
     7  ! Tag Name::  $Name:  $
     8  ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9  ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10  !
    11  
    12  module saturate_major_comp
    13    !
    14    != 主成分相変化
    15    !
    16    != Phase change of atmospheric major component
    17    !
    18    ! <b>Note that Japanese and English are described in parallel.</b>
    19    !
    20    !== References
    21    !
    22    ! * Pollack, J. B., C. B. Leovy, P. W. Greiman, and Y. Mintz, 1981:
    23    !   A Martian general circulation experiment with large topography,
    24    !   <i>J. Atmos. Sci.</i>, <b>38</b>, 3--29.
    25    !
    26    !== Procedures List
    27    !
    28  !!$  ! DryConvAdjust :: 乾燥対流調節
    29  !!$  ! ------------  :: ------------
    30  !!$  ! DryConvAdjust :: Dry convective adjustment
    31    !
    32    !== NAMELIST
    33    !
    34    ! NAMELIST#saturate_major_comp_nml
    35    !
    36  
    37    ! モジュール引用 ; USE statements
    38    !
    39  
    40    ! 種別型パラメタ
    41    ! Kind type parameter
    42    !
    43    use dc_types, only: DP, &      ! 倍精度実数型. Double precision.
    44      &                 STRING     ! 文字列.       Strings.
    45  
    46    ! NAMELIST ファイル入力に関するユーティリティ
    47    ! Utilities for NAMELIST file input
    48    !
    49    use namelist_util, only: MaxNmlArySize
    50                                ! NAMELIST から読み込む配列の最大サイズ.
    51                                ! Maximum size of arrays loaded from NAMELIST
    52  
    53    ! メッセージ出力
    54    ! Message output
    55    !
    56    use dc_message, only: MessageNotify
    57  
    58    ! 宣言文 ; Declaration statements
    59    !
    60    implicit none
    61    private
    62  
    63  
    64    integer, save      :: IndexSpc
    65    integer, parameter :: IndexSpcCO2     = 1
    66  
    67  
    68    real(DP), parameter :: LatentHeatCO2Subl = 5.9d5
    69                                ! Latent heat of CO2 (J kg^{-1})
    70                                ! This value is obtained from Pollack et al.
    71                                ! (1981) and Forget et al. (1998).
    72  
    73    ! 公開手続き
    74    ! Public procedure
    75    !
    76    public :: SaturateMajorCompCondTemp
    77    public :: SaturateMajorCompPressSat
    78    public :: SaturateMajorCompDPressSatDT
    79    public :: SaturateMajorCompInqLatentHeat
    80    public :: SaturateMajorCompInit
    81  
    82    ! 公開変数
    83    ! Public variables
    84    !
    85    logical, save, public:: saturate_major_comp_inited = .false.
    86                                ! 初期設定フラグ.
    87                                ! Initialization flag
    88  
    89    ! 非公開変数
    90    ! Private variables
    91    !
    92    character(*), parameter:: module_name = 'saturate_major_comp'
    93                                ! モジュールの名称.
    94                                ! Module name
    95    character(*), parameter:: version = &
    96      & '$Name:  $' // &
    97      & '$Id: saturate_major_comp.f90,v 1.1 2013/09/30 02:55:27 yot Exp $'
    98                                ! モジュールのバージョン
    99                                ! Module version
   100  
   101  
   102    interface SaturateMajorCompCondTemp
   103      module procedure &
   104        SaturateMajorCompCondTemp3D, &
   105        SaturateMajorCompCondTemp2D
   106    end interface
   107  
   108    interface SaturateMajorCompPressSat
   109      module procedure &
   110        SaturateMajorCompPressSat3D, &
   111        SaturateMajorCompPressSat2D
   112    end interface
   113  
   114    interface SaturateMajorCompDPressSatDT
   115      module procedure &
   116        SaturateMajorCompDPressSatDT3D, &
   117        SaturateMajorCompDPressSatDT2D
   118    end interface
   119  
   120  contains
   121  
   122    !--------------------------------------------------------------------------------------
   123  
   124    subroutine SaturateMajorCompCondTemp3D(  &
   125      & xyz_Press,                           &  ! (in)
   126      & xyz_TempCond                         &  ! (out)
   127      & )
   128      !
   129      ! 主成分相変化
   130      !
   131      ! Major component phase change
   132      !
   133  
   134      ! モジュール引用 ; USE statements
   135      !
   136  
   137      !=
   138      != CO2 condensation temperature (Pollack et al., 1981)
   139      !
   140      use saturate_co2_p81, only : xyz_SaturateCO2P81TempCond
   141  
   142  
   143      ! 宣言文 ; Declaration statements
   144      !
   145      implicit none
   146  
   147      real(DP), intent(in ):: xyz_Press   (:,:,:)
   148                                ! $ p $ . 気圧 (整数レベル).
   149                                ! Air pressure (full level)
   150      real(DP), intent(out):: xyz_TempCond(:,:,:)
   151                                !
   152                                ! Condensation temperature
   153  
   154      ! 作業変数
   155      ! Work variables
   156      !
   157  
   158      ! 実行文 ; Executable statement
   159      !
   160  
   161  
   162      ! 初期化
   163      ! Initialization
   164      !
   165      if ( .not. saturate_major_comp_inited ) then
   166        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   167      end if
   168  
   169  
   170      select case ( IndexSpc )
   171      case ( IndexSpcCO2 )
   172        ! CO2 condensation temperature
   173  
   174        xyz_TempCond = xyz_SaturateCO2P81TempCond( xyz_Press )
     .        if (xyz_tempcond.DSC.U2 .gt. 0) then                              
     .           j1 = and(xyz_tempcond.DSC.U2,3)                                
     .  !cdir    nodep                                                          
     .           do t49 = 1, j1                                                 
     .  !cdir       nodep                                                       
     .              do t51 = 1, xyz_tempcond.DSC.U1                             
     .                 xyz_tempcond(t51,t49,t47+1) = %0000af(t51,t49,t47+1)     
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t49 = j1 + 1, xyz_tempcond.DSC.U2, 4                        
     .  !cdir       nodep                                                       
     .              do t51 = 1, xyz_tempcond.DSC.U1                             
     .                 xyz_tempcond(t51,t49,t47+1) = %0000af(t51,t49,t47+1)     
     .                 xyz_tempcond(t51,t49+1,t47+1) = %0000af(t51,t49+1,t47+1) 
     .                 xyz_tempcond(t51,t49+2,t47+1) = %0000af(t51,t49+2,t47+1) 
     .                 xyz_tempcond(t51,t49+3,t47+1) = %0000af(t51,t49+3,t47+1) 
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
   175  
   176      end select
   177  
   178  
   179    end subroutine SaturateMajorCompCondTemp3D
   180  
   181    !--------------------------------------------------------------------------------------
   182  
   183    subroutine SaturateMajorCompCondTemp2D(  &
   184      & xy_Press,                            &  ! (in)
   185      & xy_TempCond                          &  ! (out)
   186      & )
   187      !
   188      ! 主成分相変化
   189      !
   190      ! Major component phase change
   191      !
   192  
   193      ! モジュール引用 ; USE statements
   194      !
   195  
   196  
   197      ! 宣言文 ; Declaration statements
   198      !
   199      implicit none
   200  
   201      real(DP), intent(in ):: xy_Press   (:,:)
   202                                ! $ p $ . 気圧 (整数レベル).
   203                                ! Air pressure (full level)
   204      real(DP), intent(out):: xy_TempCond(:,:)
   205                                !
   206                                ! Condensation temperature
   207  
   208      ! 作業変数
   209      ! Work variables
   210      !
   211      real(DP) :: xyz_Press   (size(xy_Press   ,1),size(xy_Press   ,2),1)
   212      real(DP) :: xyz_TempCond(size(xy_TempCond,1),size(xy_TempCond,2),1)
   213  
   214  
   215      ! 実行文 ; Executable statement
   216      !
   217  
   218  
   219      ! 初期化
   220      ! Initialization
   221      !
   222      if ( .not. saturate_major_comp_inited ) then
   223        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   224      end if
   225  
   226      xyz_Press(:,:,1) = xy_Press
     .        if (xyz_press.DSC.U2 .gt. 0) then                                 
     .           j5 = and(xyz_press.DSC.U2,3)                                   
     .  !cdir    nodep                                                          
     .           do t57 = 1, j5                                                 
     .  !cdir       nodep                                                       
     .              do t59 = 1, xyz_press.DSC.U1                                
     .                 xyz_press(t59,t57,1) = xy_press(t59,t57)                 
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t57 = j5 + 1, xyz_press.DSC.U2, 4                           
     .  !cdir       nodep                                                       
     .              do t59 = 1, xyz_press.DSC.U1                                
     .                 xyz_press(t59,t57,1) = xy_press(t59,t57)                 
     .                 xyz_press(t59,t57+1,1) = xy_press(t59,t57+1)             
     .                 xyz_press(t59,t57+2,1) = xy_press(t59,t57+2)             
     .                 xyz_press(t59,t57+3,1) = xy_press(t59,t57+3)             
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
   227  
   228      call SaturateMajorCompCondTemp3D(  &
   229        & xyz_Press,                     &  ! (in)
   230        & xyz_TempCond                   &  ! (out)
   231        & )
   232  
   233      xy_TempCond = xyz_TempCond(:,:,1)
     .        if (xy_tempcond.DSC.U2 .gt. 0) then                               
     .           j6 = and(xy_tempcond.DSC.U2,3)                                 
     .  !cdir    nodep                                                          
     .           do t65 = 1, j6                                                 
     .  !cdir       nodep                                                       
     .              do t67 = 1, xy_tempcond.DSC.U1                              
     .                 xy_tempcond(t67,t65) = xyz_tempcond(t67,t65,1)           
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t65 = j6 + 1, xy_tempcond.DSC.U2, 4                         
     .  !cdir       nodep                                                       
     .              do t67 = 1, xy_tempcond.DSC.U1                              
     .                 xy_tempcond(t67,t65) = xyz_tempcond(t67,t65,1)           
     .                 xy_tempcond(t67,t65+1) = xyz_tempcond(t67,t65+1,1)       
     .                 xy_tempcond(t67,t65+2) = xyz_tempcond(t67,t65+2,1)       
     .                 xy_tempcond(t67,t65+3) = xyz_tempcond(t67,t65+3,1)       
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
   234  
   235  
   236    end subroutine SaturateMajorCompCondTemp2D
   237  
   238    !--------------------------------------------------------------------------------------
   239  
   240    subroutine SaturateMajorCompPressSat3D(  &
   241      & xyz_Temp,                            &  ! (in)
   242      & xyz_Press                            &  ! (out)
   243      & )
   244      !
   245      ! 主成分相変化
   246      !
   247      ! Major component phase change
   248      !
   249  
   250      ! モジュール引用 ; USE statements
   251      !
   252  
   253      !=
   254      != CO2 condensation temperature (Pollack et al., 1981)
   255      !
   256      use saturate_co2_p81, only : xyz_SaturateCO2P81PressSat
   257  
   258      ! 宣言文 ; Declaration statements
   259      !
   260      implicit none
   261  
   262      real(DP), intent(in ):: xyz_Temp (:,:,:)
   263                                !
   264                                ! Condensation temperature
   265      real(DP), intent(out):: xyz_Press(:,:,:)
   266                                ! $ p $ . 気圧 (整数レベル).
   267                                ! Air pressure (full level)
   268  
   269      ! 作業変数
   270      ! Work variables
   271      !
   272  
   273      ! 実行文 ; Executable statement
   274      !
   275  
   276  
   277      ! 初期化
   278      ! Initialization
   279      !
   280      if ( .not. saturate_major_comp_inited ) then
   281        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   282      end if
   283  
   284  
   285      select case ( IndexSpc )
   286      case ( IndexSpcCO2 )
   287        ! CO2 condensation temperature
   288  
   289        xyz_Press = xyz_SaturateCO2P81PressSat( xyz_Temp )
     .        if (xyz_press.DSC.U2 .gt. 0) then                                 
     .           j1 = and(xyz_press.DSC.U2,3)                                   
     .  !cdir    nodep                                                          
     .           do t49 = 1, j1                                                 
     .  !cdir       nodep                                                       
     .              do t51 = 1, xyz_press.DSC.U1                                
     .                 xyz_press(t51,t49,t47+1) = %0000cb(t51,t49,t47+1)        
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t49 = j1 + 1, xyz_press.DSC.U2, 4                           
     .  !cdir       nodep                                                       
     .              do t51 = 1, xyz_press.DSC.U1                                
     .                 xyz_press(t51,t49,t47+1) = %0000cb(t51,t49,t47+1)        
     .                 xyz_press(t51,t49+1,t47+1) = %0000cb(t51,t49+1,t47+1)    
     .                 xyz_press(t51,t49+2,t47+1) = %0000cb(t51,t49+2,t47+1)    
     .                 xyz_press(t51,t49+3,t47+1) = %0000cb(t51,t49+3,t47+1)    
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
   290  
   291      end select
   292  
   293  
   294    end subroutine SaturateMajorCompPressSat3D
   295  
   296    !--------------------------------------------------------------------------------------
   297  
   298    subroutine SaturateMajorCompPressSat2D( &
   299      & xy_Temp,                            &  ! (in)
   300      & xy_Press                            &  ! (out)
   301      & )
   302      !
   303      ! 主成分相変化
   304      !
   305      ! Major component phase change
   306      !
   307  
   308      ! モジュール引用 ; USE statements
   309      !
   310  
   311  
   312      ! 宣言文 ; Declaration statements
   313      !
   314      implicit none
   315  
   316      real(DP), intent(in ):: xy_Temp (:,:)
   317                                !
   318                                ! Condensation temperature
   319      real(DP), intent(out):: xy_Press(:,:)
   320                                ! $ p $ . 気圧 (整数レベル).
   321                                ! Air pressure (full level)
   322  
   323      ! 作業変数
   324      ! Work variables
   325      !
   326      real(DP) :: xyz_Temp (size(xy_Temp ,1),size(xy_Temp ,2),1)
   327      real(DP) :: xyz_Press(size(xy_Press,1),size(xy_Press,2),1)
   328  
   329  
   330      ! 実行文 ; Executable statement
   331      !
   332  
   333  
   334      ! 初期化
   335      ! Initialization
   336      !
   337      if ( .not. saturate_major_comp_inited ) then
   338        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   339      end if
   340  
   341      xyz_Temp(:,:,1) = xy_Temp
     .        if (xyz_temp.DSC.U2 .gt. 0) then                                  
     .           j5 = and(xyz_temp.DSC.U2,3)                                    
     .  !cdir    nodep                                                          
     .           do t57 = 1, j5                                                 
     .  !cdir       nodep                                                       
     .              do t59 = 1, xyz_temp.DSC.U1                                 
     .                 xyz_temp(t59,t57,1) = xy_temp(t59,t57)                   
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t57 = j5 + 1, xyz_temp.DSC.U2, 4                            
     .  !cdir       nodep                                                       
     .              do t59 = 1, xyz_temp.DSC.U1                                 
     .                 xyz_temp(t59,t57,1) = xy_temp(t59,t57)                   
     .                 xyz_temp(t59,t57+1,1) = xy_temp(t59,t57+1)               
     .                 xyz_temp(t59,t57+2,1) = xy_temp(t59,t57+2)               
     .                 xyz_temp(t59,t57+3,1) = xy_temp(t59,t57+3)               
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
   342  
   343      call SaturateMajorCompPressSat3D( &
   344        & xyz_Temp,                     &  ! (in)
   345        & xyz_Press                     &  ! (out)
   346        & )
   347  
   348      xy_Press = xyz_Press(:,:,1)
     .        if (xy_press.DSC.U2 .gt. 0) then                                  
     .           j6 = and(xy_press.DSC.U2,3)                                    
     .  !cdir    nodep                                                          
     .           do t65 = 1, j6                                                 
     .  !cdir       nodep                                                       
     .              do t67 = 1, xy_press.DSC.U1                                 
     .                 xy_press(t67,t65) = xyz_press(t67,t65,1)                 
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t65 = j6 + 1, xy_press.DSC.U2, 4                            
     .  !cdir       nodep                                                       
     .              do t67 = 1, xy_press.DSC.U1                                 
     .                 xy_press(t67,t65) = xyz_press(t67,t65,1)                 
     .                 xy_press(t67,t65+1) = xyz_press(t67,t65+1,1)             
     .                 xy_press(t67,t65+2) = xyz_press(t67,t65+2,1)             
     .                 xy_press(t67,t65+3) = xyz_press(t67,t65+3,1)             
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
   349  
   350  
   351    end subroutine SaturateMajorCompPressSat2D
   352  
   353    !--------------------------------------------------------------------------------------
   354  
   355    subroutine SaturateMajorCompDPressSatDT3D(  &
   356      & xyz_Temp,                                   &  ! (in)
   357      & xyz_DPressSatDT                             &  ! (out)
   358      & )
   359      !
   360      ! 主成分相変化
   361      !
   362      ! Major component phase change
   363      !
   364  
   365      ! モジュール引用 ; USE statements
   366      !
   367  
   368      !=
   369      != CO2 condensation temperature (Pollack et al., 1981)
   370      !
   371      use saturate_co2_p81, only : xyz_SaturateCO2P81DPressSatDT
   372  
   373      ! 宣言文 ; Declaration statements
   374      !
   375      implicit none
   376  
   377      real(DP), intent(in ):: xyz_Temp (:,:,:)
   378                                !
   379                                ! Condensation temperature
   380      real(DP), intent(out):: xyz_DPressSatDT(:,:,:)
   381                                ! $ p $ . 気圧 (整数レベル).
   382                                ! Air pressure (full level)
   383  
   384      ! 作業変数
   385      ! Work variables
   386      !
   387  
   388      ! 実行文 ; Executable statement
   389      !
   390  
   391  
   392      ! 初期化
   393      ! Initialization
   394      !
   395      if ( .not. saturate_major_comp_inited ) then
   396        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   397      end if
   398  
   399  
   400      select case ( IndexSpc )
   401      case ( IndexSpcCO2 )
   402        ! CO2 condensation temperature
   403  
   404        xyz_DPressSatDT = xyz_SaturateCO2P81DPressSatDT( xyz_Temp )
     .        if (xyz_dpresssatdt.DSC.U2 .gt. 0) then                           
     .           j1 = and(xyz_dpresssatdt.DSC.U2,3)                             
     .  !cdir    nodep                                                          
     .           do t49 = 1, j1                                                 
     .  !cdir       nodep                                                       
     .              do t51 = 1, xyz_dpresssatdt.DSC.U1                          
     .                 xyz_dpresssatdt(t51,t49,t47+1) = %0000e7(t51,t49,t47+1)  
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t49 = j1 + 1, xyz_dpresssatdt.DSC.U2, 4                     
     .  !cdir       nodep                                                       
     .              do t51 = 1, xyz_dpresssatdt.DSC.U1                          
     .                 xyz_dpresssatdt(t51,t49,t47+1) = %0000e7(t51,t49,t47+1)  
     .                 xyz_dpresssatdt(t51,t49+1,t47+1) = %0000e7(t51,t49+1,t47+
     .       1            1)                                                    
     .                 xyz_dpresssatdt(t51,t49+2,t47+1) = %0000e7(t51,t49+2,t47+
     .       1            1)                                                    
     .                 xyz_dpresssatdt(t51,t49+3,t47+1) = %0000e7(t51,t49+3,t47+
     .       1            1)                                                    
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
   405  
   406      end select
   407  
   408  
   409    end subroutine SaturateMajorCompDPressSatDT3D
   410  
   411    !--------------------------------------------------------------------------------------
   412  
   413    subroutine SaturateMajorCompDPressSatDT2D( &
   414      & xy_Temp,                               &  ! (in)
   415      & xy_DPressSatDT                         &  ! (out)
   416      & )
   417      !
   418      ! 主成分相変化
   419      !
   420      ! Major component phase change
   421      !
   422  
   423      ! モジュール引用 ; USE statements
   424      !
   425  
   426  
   427      ! 宣言文 ; Declaration statements
   428      !
   429      implicit none
   430  
   431      real(DP), intent(in ):: xy_Temp (:,:)
   432                                !
   433                                ! Condensation temperature
   434      real(DP), intent(out):: xy_DPressSatDT(:,:)
   435                                ! $ p $ . 気圧 (整数レベル).
   436                                ! Air pressure (full level)
   437  
   438      ! 作業変数
   439      ! Work variables
   440      !
   441      real(DP) :: xyz_Temp       (size(xy_Temp       ,1),size(xy_Temp       ,2),1)
   442      real(DP) :: xyz_DPressSatDT(size(xy_DPressSatDT,1),size(xy_DPressSatDT,2),1)
   443  
   444  
   445      ! 実行文 ; Executable statement
   446      !
   447  
   448  
   449      ! 初期化
   450      ! Initialization
   451      !
   452      if ( .not. saturate_major_comp_inited ) then
   453        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   454      end if
   455  
   456      xyz_Temp(:,:,1) = xy_Temp
     .        if (xyz_temp.DSC.U2 .gt. 0) then                                  
     .           j5 = and(xyz_temp.DSC.U2,3)                                    
     .  !cdir    nodep                                                          
     .           do t57 = 1, j5                                                 
     .  !cdir       nodep                                                       
     .              do t59 = 1, xyz_temp.DSC.U1                                 
     .                 xyz_temp(t59,t57,1) = xy_temp(t59,t57)                   
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t57 = j5 + 1, xyz_temp.DSC.U2, 4                            
     .  !cdir       nodep                                                       
     .              do t59 = 1, xyz_temp.DSC.U1                                 
     .                 xyz_temp(t59,t57,1) = xy_temp(t59,t57)                   
     .                 xyz_temp(t59,t57+1,1) = xy_temp(t59,t57+1)               
     .                 xyz_temp(t59,t57+2,1) = xy_temp(t59,t57+2)               
     .                 xyz_temp(t59,t57+3,1) = xy_temp(t59,t57+3)               
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
   457  
   458      call SaturateMajorCompDPressSatDT3D( &
   459        & xyz_Temp,                        &  ! (in)
   460        & xyz_DPressSatDT                  &  ! (out)
   461        & )
   462  
   463      xy_DPressSatDT = xyz_DPressSatDT(:,:,1)
     .        if (xy_dpresssatdt.DSC.U2 .gt. 0) then                            
     .           j6 = and(xy_dpresssatdt.DSC.U2,3)                              
     .  !cdir    nodep                                                          
     .           do t65 = 1, j6                                                 
     .  !cdir       nodep                                                       
     .              do t67 = 1, xy_dpresssatdt.DSC.U1                           
     .                 xy_dpresssatdt(t67,t65) = xyz_dpresssatdt(t67,t65,1)     
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t65 = j6 + 1, xy_dpresssatdt.DSC.U2, 4                      
     .  !cdir       nodep                                                       
     .              do t67 = 1, xy_dpresssatdt.DSC.U1                           
     .                 xy_dpresssatdt(t67,t65) = xyz_dpresssatdt(t67,t65,1)     
     .                 xy_dpresssatdt(t67,t65+1) = xyz_dpresssatdt(t67,t65+1,1) 
     .                 xy_dpresssatdt(t67,t65+2) = xyz_dpresssatdt(t67,t65+2,1) 
     .                 xy_dpresssatdt(t67,t65+3) = xyz_dpresssatdt(t67,t65+3,1) 
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
   464  
   465  
   466    end subroutine SaturateMajorCompDPressSatDT2D
   467  
   468    !--------------------------------------------------------------------------------------
   469  
   470    function SaturateMajorCompInqLatentHeat( ) result( LatentHeat )
   471      !
   472      ! 主成分の潜熱を返しします.
   473      !
   474      ! Inquiry of latent heat of major component
   475      !
   476  
   477      ! モジュール引用 ; USE statements
   478      !
   479  
   480      ! メッセージ出力
   481      ! Message output
   482      !
   483      use dc_message, only: MessageNotify
   484  
   485      ! 宣言文 ; Declaration statements
   486      !
   487      implicit none
   488  
   489      real(DP) :: LatentHeat
   490  
   491  
   492      ! 実行文 ; Executable statement
   493      !
   494  
   495      ! 初期化
   496      ! Initialization
   497      !
   498      if ( .not. saturate_major_comp_inited ) then
   499        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   500      end if
   501  
   502  
   503      ! Set latent heat
   504      select case ( IndexSpc )
   505      case ( IndexSpcCO2  )
   506        LatentHeat = LatentHeatCO2Subl
   507      case default
   508        call MessageNotify( 'E', module_name, 'This specice is not supported.' )
   509      end select
   510  
   511  
   512    end function SaturateMajorCompInqLatentHeat
   513  
   514    !--------------------------------------------------------------------------------------
   515  
   516    subroutine SaturateMajorCompInit(  &
   517      & CondMajCompName                & ! (in)
   518      & )
   519      !
   520      ! saturate_major_comp モジュールの初期化を行います.
   521      ! NAMELIST#saturate_major_comp_nml の読み込みはこの手続きで行われます.
   522      !
   523      ! "saturate_major_comp" module is initialized.
   524      ! "NAMELIST#saturate_major_comp_nml" is loaded in this procedure.
   525      !
   526  
   527      ! モジュール引用 ; USE statements
   528      !
   529  
   530  !!$    ! NAMELIST ファイル入力に関するユーティリティ
   531  !!$    ! Utilities for NAMELIST file input
   532  !!$    !
   533  !!$    use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid
   534  !!$
   535  !!$    ! ファイル入出力補助
   536  !!$    ! File I/O support
   537  !!$    !
   538  !!$    use dc_iounit, only: FileOpen
   539  !!$
   540  !!$    ! 種別型パラメタ
   541  !!$    ! Kind type parameter
   542  !!$    !
   543  !!$    use dc_types, only: STDOUT ! 標準出力の装置番号. Unit number of standard output
   544  
   545      ! 文字列操作
   546      ! Character handling
   547      !
   548      use dc_string, only: StoA
   549  
   550      !=
   551      != CO2 condensation temperature (Pollack et al., 1981)
   552      !
   553      use saturate_co2_p81, only : SaturateCO2P81Init
   554  
   555  
   556      ! 宣言文 ; Declaration statements
   557      !
   558      implicit none
   559  
   560      character(*), intent(in) :: CondMajCompName
   561                                          ! Condensable major component
   562  
   563  
   564  !!$    integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号.
   565  !!$                              ! Unit number for NAMELIST file open
   566  !!$    integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT.
   567  !!$                              ! IOSTAT of NAMELIST read
   568  
   569      ! NAMELIST 変数群
   570      ! NAMELIST group name
   571      !
   572  !!$    namelist /saturate_major_comp_nml/ &
   573  !!$      & FlagUse
   574  
   575            ! デフォルト値については初期化手続 "saturate_major_comp#MajorCompSaturateInit"
   576            ! のソースコードを参照のこと.
   577            !
   578            ! Refer to source codes in the initialization procedure
   579            ! "saturate_major_comp#MajorCompSaturateInit" for the default values.
   580            !
   581  
   582      ! 実行文 ; Executable statement
   583      !
   584  
   585      if ( saturate_major_comp_inited ) return
   586  
   587  
   588      ! デフォルト値の設定
   589      ! Default values settings
   590      !
   591  
   592  
   593      ! NAMELIST の読み込み
   594      ! NAMELIST is input
   595      !
   596  !!$    if ( trim(namelist_filename) /= '' ) then
   597  !!$      call FileOpen( unit_nml, &          ! (out)
   598  !!$        & namelist_filename, mode = 'r' ) ! (in)
   599  !!$
   600  !!$      rewind( unit_nml )
   601  !!$      read( unit_nml,                    &  ! (in)
   602  !!$        & nml = saturate_major_comp_nml, &  ! (out)
   603  !!$        & iostat = iostat_nml )             ! (out)
   604  !!$      close( unit_nml )
   605  !!$
   606  !!$      call NmlutilMsg( iostat_nml, module_name ) ! (in)
   607  !!$!      if ( iostat_nml == 0 ) write( STDOUT, nml = cumulus_adjust_nml )
   608  !!$    end if
   609  
   610  
   611      ! Set index
   612      select case ( CondMajCompName )
   613      case ( 'CO2' )
   614        IndexSpc = IndexSpcCO2
   615      case default
   616        call MessageNotify( 'E', module_name, 'This specice is not supported.' )
   617      end select
   618  
   619  
   620      ! Initialization of modules called in this module
   621      !
   622  
   623      !=
   624      != CO2 condensation temperature (Pollack et al., 1981)
   625      !
   626      call SaturateCO2P81Init
   627  
   628  
   629      ! 印字 ; Print
   630      !
   631      call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   632      call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   633  
   634  
   635      saturate_major_comp_inited = .true.
   636  
   637    end subroutine SaturateMajorCompInit
   638  
   639    !-------------------------------------------------------------------
   640  
   641  end module saturate_major_comp
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:28 2016
FILE NAME: saturate_major_comp.f90
PROGRAM NAME: saturate_major_comp
FORMAT LIST

  LINE    LOOP      FORTRAN STATEMENT

     1:             != 主成分相変化
     2:             !
     3:             != Phase change of atmospheric major component
     4:             !
     5:             ! Authors::   Yoshiyuki O. Takahashi
     6:             ! Version::   $Id: saturate_major_comp.f90,v 1.1 2013/09/30 02:55:27 yot Exp $ 
     7:             ! Tag Name::  $Name:  $
     8:             ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9:             ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10:             !
    11:             
    12:             module saturate_major_comp
    13:               !
    14:               != 主成分相変化
    15:               !
    16:               != Phase change of atmospheric major component
    17:               !
    18:               ! <b>Note that Japanese and English are described in parallel.</b>
    19:               !
    20:               !== References
    21:               !
    22:               ! * Pollack, J. B., C. B. Leovy, P. W. Greiman, and Y. Mintz, 1981:
    23:               !   A Martian general circulation experiment with large topography, 
    24:               !   <i>J. Atmos. Sci.</i>, <b>38</b>, 3--29.
    25:               !
    26:               !== Procedures List
    27:               ! 
    28:             !!$  ! DryConvAdjust :: 乾燥対流調節
    29:             !!$  ! ------------  :: ------------
    30:             !!$  ! DryConvAdjust :: Dry convective adjustment
    31:               !
    32:               !== NAMELIST
    33:               !
    34:               ! NAMELIST#saturate_major_comp_nml
    35:               !
    36:             
    37:               ! モジュール引用 ; USE statements
    38:               !
    39:             
    40:               ! 種別型パラメタ
    41:               ! Kind type parameter
    42:               !
    43:               use dc_types, only: DP, &      ! 倍精度実数型. Double precision. 
    44:                 &                 STRING     ! 文字列.       Strings. 
    45:             
    46:               ! NAMELIST ファイル入力に関するユーティリティ
    47:               ! Utilities for NAMELIST file input
    48:               !
    49:               use namelist_util, only: MaxNmlArySize
    50:                                           ! NAMELIST から読み込む配列の最大サイズ. 
    51:                                           ! Maximum size of arrays loaded from NAMELIST
    52:             
    53:               ! メッセージ出力
    54:               ! Message output
    55:               !
    56:               use dc_message, only: MessageNotify
    57:             
    58:               ! 宣言文 ; Declaration statements
    59:               !
    60:               implicit none
    61:               private
    62:             
    63:             
    64:               integer, save      :: IndexSpc
    65:               integer, parameter :: IndexSpcCO2     = 1
    66:             
    67:             
    68:               real(DP), parameter :: LatentHeatCO2Subl = 5.9d5
    69:                                           ! Latent heat of CO2 (J kg^{-1})
    70:                                           ! This value is obtained from Pollack et al. 
    71:                                           ! (1981) and Forget et al. (1998).
    72:             
    73:               ! 公開手続き
    74:               ! Public procedure
    75:               !
    76:               public :: SaturateMajorCompCondTemp
    77:               public :: SaturateMajorCompPressSat
    78:               public :: SaturateMajorCompDPressSatDT
    79:               public :: SaturateMajorCompInqLatentHeat
    80:               public :: SaturateMajorCompInit
    81:             
    82:               ! 公開変数
    83:               ! Public variables
    84:               !
    85:               logical, save, public:: saturate_major_comp_inited = .false.
    86:                                           ! 初期設定フラグ. 
    87:                                           ! Initialization flag
    88:             
    89:               ! 非公開変数
    90:               ! Private variables
    91:               !
    92:               character(*), parameter:: module_name = 'saturate_major_comp'
    93:                                           ! モジュールの名称. 
    94:                                           ! Module name
    95:               character(*), parameter:: version = &
    96:                 & '$Name:  $' // &
    97:                 & '$Id: saturate_major_comp.f90,v 1.1 2013/09/30 02:55:27 yot Exp $'
    98:                                           ! モジュールのバージョン
    99:                                           ! Module version
   100:             
   101:             
   102:               interface SaturateMajorCompCondTemp
   103:                 module procedure &
   104:                   SaturateMajorCompCondTemp3D, &
   105:                   SaturateMajorCompCondTemp2D
   106:               end interface
   107:             
   108:               interface SaturateMajorCompPressSat
   109:                 module procedure &
   110:                   SaturateMajorCompPressSat3D, &
   111:                   SaturateMajorCompPressSat2D
   112:               end interface
   113:             
   114:               interface SaturateMajorCompDPressSatDT
   115:                 module procedure &
   116:                   SaturateMajorCompDPressSatDT3D, &
   117:                   SaturateMajorCompDPressSatDT2D
   118:               end interface
   119:             
   120:             contains
   121:             
   122:               !--------------------------------------------------------------------------------------
   123:             
   124:               subroutine SaturateMajorCompCondTemp3D(  &
   125:                 & xyz_Press,                           &  ! (in)
   126:                 & xyz_TempCond                         &  ! (out)
   127:                 & )
   128:                 !
   129:                 ! 主成分相変化
   130:                 !
   131:                 ! Major component phase change
   132:                 !
   133:             
   134:                 ! モジュール引用 ; USE statements
   135:                 !
   136:             
   137:                 != 
   138:                 != CO2 condensation temperature (Pollack et al., 1981)
   139:                 !
   140:                 use saturate_co2_p81, only : xyz_SaturateCO2P81TempCond
   141:             
   142:             
   143:                 ! 宣言文 ; Declaration statements
   144:                 !
   145:                 implicit none
   146:             
   147:                 real(DP), intent(in ):: xyz_Press   (:,:,:)
   148:                                           ! $ p $ . 気圧 (整数レベル). 
   149:                                           ! Air pressure (full level)
   150:                 real(DP), intent(out):: xyz_TempCond(:,:,:)
   151:                                           !
   152:                                           ! Condensation temperature
   153:             
   154:                 ! 作業変数
   155:                 ! Work variables
   156:                 !
   157:             
   158:                 ! 実行文 ; Executable statement
   159:                 !
   160:             
   161:             
   162:                 ! 初期化
   163:                 ! Initialization
   164:                 !
   165:                 if ( .not. saturate_major_comp_inited ) then
   166:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   167:                 end if
   168:             
   169:             
   170:                 select case ( IndexSpc )
   171:                 case ( IndexSpcCO2 )
   172:                   ! CO2 condensation temperature
   173:             
   174: ++V==== A         xyz_TempCond = xyz_SaturateCO2P81TempCond( xyz_Press )
   175:             
   176:                 end select
   177:             
   178:             
   179:               end subroutine SaturateMajorCompCondTemp3D
   180:             
   181:               !--------------------------------------------------------------------------------------
   182:             
   183:               subroutine SaturateMajorCompCondTemp2D(  &
   184:                 & xy_Press,                            &  ! (in)
   185:                 & xy_TempCond                          &  ! (out)
   186:                 & )
   187:                 !
   188:                 ! 主成分相変化
   189:                 !
   190:                 ! Major component phase change
   191:                 !
   192:             
   193:                 ! モジュール引用 ; USE statements
   194:                 !
   195:             
   196:             
   197:                 ! 宣言文 ; Declaration statements
   198:                 !
   199:                 implicit none
   200:             
   201:                 real(DP), intent(in ):: xy_Press   (:,:)
   202:                                           ! $ p $ . 気圧 (整数レベル). 
   203:                                           ! Air pressure (full level)
   204:                 real(DP), intent(out):: xy_TempCond(:,:)
   205:                                           !
   206:                                           ! Condensation temperature
   207:             
   208:                 ! 作業変数
   209:                 ! Work variables
   210:                 !
   211:                 real(DP) :: xyz_Press   (size(xy_Press   ,1),size(xy_Press   ,2),1)
   212:                 real(DP) :: xyz_TempCond(size(xy_TempCond,1),size(xy_TempCond,2),1)
   213:             
   214:             
   215:                 ! 実行文 ; Executable statement
   216:                 !
   217:             
   218:             
   219:                 ! 初期化
   220:                 ! Initialization
   221:                 !
   222:                 if ( .not. saturate_major_comp_inited ) then
   223:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   224:                 end if
   225:             
   226: +V===== A       xyz_Press(:,:,1) = xy_Press
   227:             
   228:                 call SaturateMajorCompCondTemp3D(  &
   229:                   & xyz_Press,                     &  ! (in)
   230:                   & xyz_TempCond                   &  ! (out)
   231:                   & )
   232:             
   233: +V===== A       xy_TempCond = xyz_TempCond(:,:,1)
   234:             
   235:             
   236:               end subroutine SaturateMajorCompCondTemp2D
   237:             
   238:               !--------------------------------------------------------------------------------------
   239:             
   240:               subroutine SaturateMajorCompPressSat3D(  &
   241:                 & xyz_Temp,                            &  ! (in)
   242:                 & xyz_Press                            &  ! (out)
   243:                 & )
   244:                 !
   245:                 ! 主成分相変化
   246:                 !
   247:                 ! Major component phase change
   248:                 !
   249:             
   250:                 ! モジュール引用 ; USE statements
   251:                 !
   252:             
   253:                 != 
   254:                 != CO2 condensation temperature (Pollack et al., 1981)
   255:                 !
   256:                 use saturate_co2_p81, only : xyz_SaturateCO2P81PressSat
   257:             
   258:                 ! 宣言文 ; Declaration statements
   259:                 !
   260:                 implicit none
   261:             
   262:                 real(DP), intent(in ):: xyz_Temp (:,:,:)
   263:                                           !
   264:                                           ! Condensation temperature
   265:                 real(DP), intent(out):: xyz_Press(:,:,:)
   266:                                           ! $ p $ . 気圧 (整数レベル). 
   267:                                           ! Air pressure (full level)
   268:             
   269:                 ! 作業変数
   270:                 ! Work variables
   271:                 !
   272:             
   273:                 ! 実行文 ; Executable statement
   274:                 !
   275:             
   276:             
   277:                 ! 初期化
   278:                 ! Initialization
   279:                 !
   280:                 if ( .not. saturate_major_comp_inited ) then
   281:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   282:                 end if
   283:             
   284:             
   285:                 select case ( IndexSpc )
   286:                 case ( IndexSpcCO2 )
   287:                   ! CO2 condensation temperature
   288:             
   289: ++V==== A         xyz_Press = xyz_SaturateCO2P81PressSat( xyz_Temp )
   290:             
   291:                 end select
   292:             
   293:             
   294:               end subroutine SaturateMajorCompPressSat3D
   295:             
   296:               !--------------------------------------------------------------------------------------
   297:             
   298:               subroutine SaturateMajorCompPressSat2D( &
   299:                 & xy_Temp,                            &  ! (in)
   300:                 & xy_Press                            &  ! (out)
   301:                 & )
   302:                 !
   303:                 ! 主成分相変化
   304:                 !
   305:                 ! Major component phase change
   306:                 !
   307:             
   308:                 ! モジュール引用 ; USE statements
   309:                 !
   310:             
   311:             
   312:                 ! 宣言文 ; Declaration statements
   313:                 !
   314:                 implicit none
   315:             
   316:                 real(DP), intent(in ):: xy_Temp (:,:)
   317:                                           !
   318:                                           ! Condensation temperature
   319:                 real(DP), intent(out):: xy_Press(:,:)
   320:                                           ! $ p $ . 気圧 (整数レベル). 
   321:                                           ! Air pressure (full level)
   322:             
   323:                 ! 作業変数
   324:                 ! Work variables
   325:                 !
   326:                 real(DP) :: xyz_Temp (size(xy_Temp ,1),size(xy_Temp ,2),1)
   327:                 real(DP) :: xyz_Press(size(xy_Press,1),size(xy_Press,2),1)
   328:             
   329:             
   330:                 ! 実行文 ; Executable statement
   331:                 !
   332:             
   333:             
   334:                 ! 初期化
   335:                 ! Initialization
   336:                 !
   337:                 if ( .not. saturate_major_comp_inited ) then
   338:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   339:                 end if
   340:             
   341: +V===== A       xyz_Temp(:,:,1) = xy_Temp
   342:             
   343:                 call SaturateMajorCompPressSat3D( &
   344:                   & xyz_Temp,                     &  ! (in)
   345:                   & xyz_Press                     &  ! (out)
   346:                   & )
   347:             
   348: +V===== A       xy_Press = xyz_Press(:,:,1)
   349:             
   350:             
   351:               end subroutine SaturateMajorCompPressSat2D
   352:             
   353:               !--------------------------------------------------------------------------------------
   354:             
   355:               subroutine SaturateMajorCompDPressSatDT3D(  &
   356:                 & xyz_Temp,                                   &  ! (in)
   357:                 & xyz_DPressSatDT                             &  ! (out)
   358:                 & )
   359:                 !
   360:                 ! 主成分相変化
   361:                 !
   362:                 ! Major component phase change
   363:                 !
   364:             
   365:                 ! モジュール引用 ; USE statements
   366:                 !
   367:             
   368:                 != 
   369:                 != CO2 condensation temperature (Pollack et al., 1981)
   370:                 !
   371:                 use saturate_co2_p81, only : xyz_SaturateCO2P81DPressSatDT
   372:             
   373:                 ! 宣言文 ; Declaration statements
   374:                 !
   375:                 implicit none
   376:             
   377:                 real(DP), intent(in ):: xyz_Temp (:,:,:)
   378:                                           !
   379:                                           ! Condensation temperature
   380:                 real(DP), intent(out):: xyz_DPressSatDT(:,:,:)
   381:                                           ! $ p $ . 気圧 (整数レベル). 
   382:                                           ! Air pressure (full level)
   383:             
   384:                 ! 作業変数
   385:                 ! Work variables
   386:                 !
   387:             
   388:                 ! 実行文 ; Executable statement
   389:                 !
   390:             
   391:             
   392:                 ! 初期化
   393:                 ! Initialization
   394:                 !
   395:                 if ( .not. saturate_major_comp_inited ) then
   396:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   397:                 end if
   398:             
   399:             
   400:                 select case ( IndexSpc )
   401:                 case ( IndexSpcCO2 )
   402:                   ! CO2 condensation temperature
   403:             
   404: ++V==== A         xyz_DPressSatDT = xyz_SaturateCO2P81DPressSatDT( xyz_Temp )
   405:             
   406:                 end select
   407:             
   408:             
   409:               end subroutine SaturateMajorCompDPressSatDT3D
   410:             
   411:               !--------------------------------------------------------------------------------------
   412:             
   413:               subroutine SaturateMajorCompDPressSatDT2D( &
   414:                 & xy_Temp,                               &  ! (in)
   415:                 & xy_DPressSatDT                         &  ! (out)
   416:                 & )
   417:                 !
   418:                 ! 主成分相変化
   419:                 !
   420:                 ! Major component phase change
   421:                 !
   422:             
   423:                 ! モジュール引用 ; USE statements
   424:                 !
   425:             
   426:             
   427:                 ! 宣言文 ; Declaration statements
   428:                 !
   429:                 implicit none
   430:             
   431:                 real(DP), intent(in ):: xy_Temp (:,:)
   432:                                           !
   433:                                           ! Condensation temperature
   434:                 real(DP), intent(out):: xy_DPressSatDT(:,:)
   435:                                           ! $ p $ . 気圧 (整数レベル). 
   436:                                           ! Air pressure (full level)
   437:             
   438:                 ! 作業変数
   439:                 ! Work variables
   440:                 !
   441:                 real(DP) :: xyz_Temp       (size(xy_Temp       ,1),size(xy_Temp       ,2),1)
   442:                 real(DP) :: xyz_DPressSatDT(size(xy_DPressSatDT,1),size(xy_DPressSatDT,2),1)
   443:             
   444:             
   445:                 ! 実行文 ; Executable statement
   446:                 !
   447:             
   448:             
   449:                 ! 初期化
   450:                 ! Initialization
   451:                 !
   452:                 if ( .not. saturate_major_comp_inited ) then
   453:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   454:                 end if
   455:             
   456: +V===== A       xyz_Temp(:,:,1) = xy_Temp
   457:             
   458:                 call SaturateMajorCompDPressSatDT3D( &
   459:                   & xyz_Temp,                        &  ! (in)
   460:                   & xyz_DPressSatDT                  &  ! (out)
   461:                   & )
   462:             
   463: +V===== A       xy_DPressSatDT = xyz_DPressSatDT(:,:,1)
   464:             
   465:             
   466:               end subroutine SaturateMajorCompDPressSatDT2D
   467:             
   468:               !--------------------------------------------------------------------------------------
   469:             
   470:               function SaturateMajorCompInqLatentHeat( ) result( LatentHeat )
   471:                 !
   472:                 ! 主成分の潜熱を返しします. 
   473:                 !
   474:                 ! Inquiry of latent heat of major component
   475:                 !
   476:             
   477:                 ! モジュール引用 ; USE statements
   478:                 !
   479:             
   480:                 ! メッセージ出力
   481:                 ! Message output
   482:                 !
   483:                 use dc_message, only: MessageNotify
   484:             
   485:                 ! 宣言文 ; Declaration statements
   486:                 !
   487:                 implicit none
   488:             
   489:                 real(DP) :: LatentHeat
   490:             
   491:             
   492:                 ! 実行文 ; Executable statement
   493:                 !
   494:             
   495:                 ! 初期化
   496:                 ! Initialization
   497:                 !
   498:                 if ( .not. saturate_major_comp_inited ) then
   499:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   500:                 end if
   501:             
   502:             
   503:                 ! Set latent heat
   504:                 select case ( IndexSpc )
   505:                 case ( IndexSpcCO2  )
   506:                   LatentHeat = LatentHeatCO2Subl
   507:                 case default
   508:                   call MessageNotify( 'E', module_name, 'This specice is not supported.' )
   509:                 end select
   510:             
   511:             
   512:               end function SaturateMajorCompInqLatentHeat
   513:             
   514:               !--------------------------------------------------------------------------------------
   515:             
   516:               subroutine SaturateMajorCompInit(  &
   517:                 & CondMajCompName                & ! (in)
   518:                 & )
   519:                 !
   520:                 ! saturate_major_comp モジュールの初期化を行います. 
   521:                 ! NAMELIST#saturate_major_comp_nml の読み込みはこの手続きで行われます. 
   522:                 !
   523:                 ! "saturate_major_comp" module is initialized. 
   524:                 ! "NAMELIST#saturate_major_comp_nml" is loaded in this procedure. 
   525:                 !
   526:             
   527:                 ! モジュール引用 ; USE statements
   528:                 !
   529:             
   530:             !!$    ! NAMELIST ファイル入力に関するユーティリティ
   531:             !!$    ! Utilities for NAMELIST file input
   532:             !!$    !
   533:             !!$    use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid
   534:             !!$
   535:             !!$    ! ファイル入出力補助
   536:             !!$    ! File I/O support
   537:             !!$    !
   538:             !!$    use dc_iounit, only: FileOpen
   539:             !!$
   540:             !!$    ! 種別型パラメタ
   541:             !!$    ! Kind type parameter
   542:             !!$    !
   543:             !!$    use dc_types, only: STDOUT ! 標準出力の装置番号. Unit number of standard output
   544:             
   545:                 ! 文字列操作
   546:                 ! Character handling
   547:                 !
   548:                 use dc_string, only: StoA
   549:             
   550:                 != 
   551:                 != CO2 condensation temperature (Pollack et al., 1981)
   552:                 !
   553:                 use saturate_co2_p81, only : SaturateCO2P81Init
   554:             
   555:             
   556:                 ! 宣言文 ; Declaration statements
   557:                 !
   558:                 implicit none
   559:             
   560:                 character(*), intent(in) :: CondMajCompName
   561:                                                     ! Condensable major component
   562:             
   563:             
   564:             !!$    integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号. 
   565:             !!$                              ! Unit number for NAMELIST file open
   566:             !!$    integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT. 
   567:             !!$                              ! IOSTAT of NAMELIST read
   568:             
   569:                 ! NAMELIST 変数群
   570:                 ! NAMELIST group name
   571:                 !
   572:             !!$    namelist /saturate_major_comp_nml/ &
   573:             !!$      & FlagUse
   574:             
   575:                       ! デフォルト値については初期化手続 "saturate_major_comp#MajorCompSaturateInit" 
   576:                       ! のソースコードを参照のこと. 
   577:                       !
   578:                       ! Refer to source codes in the initialization procedure
   579:                       ! "saturate_major_comp#MajorCompSaturateInit" for the default values. 
   580:                       !
   581:             
   582:                 ! 実行文 ; Executable statement
   583:                 !
   584:             
   585:                 if ( saturate_major_comp_inited ) return
   586:             
   587:             
   588:                 ! デフォルト値の設定
   589:                 ! Default values settings
   590:                 !
   591:             
   592:             
   593:                 ! NAMELIST の読み込み
   594:                 ! NAMELIST is input
   595:                 !
   596:             !!$    if ( trim(namelist_filename) /= '' ) then
   597:             !!$      call FileOpen( unit_nml, &          ! (out)
   598:             !!$        & namelist_filename, mode = 'r' ) ! (in)
   599:             !!$
   600:             !!$      rewind( unit_nml )
   601:             !!$      read( unit_nml,                    &  ! (in)
   602:             !!$        & nml = saturate_major_comp_nml, &  ! (out)
   603:             !!$        & iostat = iostat_nml )             ! (out)
   604:             !!$      close( unit_nml )
   605:             !!$
   606:             !!$      call NmlutilMsg( iostat_nml, module_name ) ! (in)
   607:             !!$!      if ( iostat_nml == 0 ) write( STDOUT, nml = cumulus_adjust_nml )
   608:             !!$    end if
   609:             
   610:             
   611:                 ! Set index
   612:                 select case ( CondMajCompName )
   613:                 case ( 'CO2' )
   614:                   IndexSpc = IndexSpcCO2
   615:                 case default
   616:                   call MessageNotify( 'E', module_name, 'This specice is not supported.' )
   617:                 end select
   618:             
   619:             
   620:                 ! Initialization of modules called in this module
   621:                 !
   622:             
   623:                 != 
   624:                 != CO2 condensation temperature (Pollack et al., 1981)
   625:                 !
   626:                 call SaturateCO2P81Init
   627:             
   628:             
   629:                 ! 印字 ; Print
   630:                 !
   631:                 call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   632:                 call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   633:             
   634:             
   635:                 saturate_major_comp_inited = .true.
   636:             
   637:               end subroutine SaturateMajorCompInit
   638:             
   639:               !-------------------------------------------------------------------
   640:             
   641:             end module saturate_major_comp
