Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:26 2016
FILE NAME: saturate_nha1992.f90
PROGRAM NAME: saturate_nha1992
DIAGNOSTIC LIST

  LINE  LEVEL( NO.): DIAGNOSTIC MESSAGE

   201  opt  (1592): Outer loop unrolled inside inner loop.
   201  vec  (   4): Vectorized array expression.
   201  vec  (  29): ADB is used for array.: xyz_temp
   201  vec  (  29): ADB is used for array.: xyz_press
   201  vec  (   4): Vectorized array expression.
   201  vec  (  29): ADB is used for array.: xyz_temp
   201  vec  (  29): ADB is used for array.: xyz_press
   254  opt  (1592): Outer loop unrolled inside inner loop.
   254  vec  (   4): Vectorized array expression.
   254  vec  (  29): ADB is used for array.: xyz_temp
   254  vec  (  29): ADB is used for array.: xyz_qvapsat
   254  vec  (   4): Vectorized array expression.
   254  vec  (  29): ADB is used for array.: xyz_temp
   254  vec  (  29): ADB is used for array.: xyz_qvapsat
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:26 2016
FILE NAME: saturate_nha1992.f90
PROGRAM NAME: saturate_nha1992
TRANSFORMATION LIST

  LINE                   FORTRAN STATEMENT

     1  != Nakajima et al. (1992) を用いた飽和比湿の算出
     2  !
     3  != Evaluate saturation specific humidity with Nakajima et al. (1992)
     4  !
     5  ! Authors::   Masaki ISHIWATARI, Yasuhiro MORIKAWA, Y. O. Takahashi
     6  ! Version::   $Id: saturate_nha1992.f90,v 1.9 2015/01/29 12:07:16 yot Exp $
     7  ! Tag Name::  $Name:  $
     8  ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9  ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10  !
    11  
    12  module saturate_nha1992
    13    !
    14    != Nakajima et al. (1992) を用いた飽和比湿の算出
    15    !
    16    != Evaluate saturation specific humidity with Nakajima et al. (1992)
    17    !
    18    ! <b>Note that Japanese and English are described in parallel.</b>
    19    !
    20    ! Nakajima et al. (1992) で用いられた飽和蒸気圧 $ p^{*} $ に関する以下の式
    21    ! を用い, 飽和比湿および飽和比湿の温度微分の値を算出します.
    22    !
    23    ! Saturation specific humidity and temperature derivative of it
    24    ! are calculated with a folloing formula for saturation watar vapor pressure
    25    ! $ p^{*} $ in Nakajima et al. (1992).
    26    !
    27    ! \[
    28    !    p^{*} (T) = p_0^{*} \exp \left( - \frac{l}{RT} \right).
    29    ! \]
    30    !
    31    ! ここで, $ T $ は温度, $ R $ は普遍気体定数です.
    32    ! $ R $ および潜熱 $ l $ ,
    33    ! 水蒸気飽和曲線の定数 $ p_0^{*} $ は以下のように与えられます.
    34    !
    35    ! where $ T $ is temperature, $ R $ is the gas constant.
    36    ! $ R $ and latent heat $ l $ ,
    37    ! constant for the water vapor saturation curve $ p_0^{*} $ are as follows.
    38    !
    39    ! * $ R = 8.314 $ [J mol-1 K-1]
    40    ! * $ l = 43655 $ [J mol-1]
    41    ! * $ p_0^{*} = 1.4 \times 10^{11} $ [Pa]
    42    !
    43    ! 飽和水蒸気圧から飽和比湿 $ q^{*} $ を求める際には, 以下の式を用います.
    44    !
    45    ! Saturation specific humidity $ q^{*} $ is calculated from
    46    ! saturation watar vapor pressure as follows.
    47    !
    48    ! \[
    49    !    q^{*} (T, p) = \varepsilon \frac{p^{*} (T)}{p}
    50    ! \]
    51    !
    52    ! ここで $ \varepsilon $ は凝結成分と大気の分子量比,
    53    ! $ p $ は気圧です.
    54    !
    55    ! where $ \varepsilon $ is molecular weight ratio of water vapor to air,
    56    ! $ p $ is air pressure.
    57    !
    58    ! 従って, 飽和比湿, 飽和比湿の温度変化を求める式は以下のように
    59    ! なります.
    60    !
    61    ! Therefore, saturation specific humidity and temperature derivative of it
    62    ! are calculated as follows.
    63    !
    64    ! \[
    65    !    q^{*} (T, p) = \varepsilon \frac{p_0^{*}}{p} \exp \left( - \frac{l}{RT} \right), \] \[
    66    !    \DP{q^{*} (T, p)}{T} = \varepsilon \frac{p_0^{*}}{p} \frac{l}{RT^2} \exp \left( - \frac{l}{RT} \right)
    67    !    = q^{*} \frac{l}{RT^2}
    68    ! \]
    69    !
    70    !== References
    71    !
    72    ! * Nakajima, S., Hayashi, Y.-Y., Abe, Y., 1992:
    73    !   A study on the "runaway greenhouse effect" with a
    74    !   one dimensional radiative convective equilibrium model.
    75    !   <i>J. Atmos. Sci.</i>, <b>49</b>, 2256--2266.
    76    !
    77    !== Procedures List
    78    !
    79    ! CalcQVapSat            :: 飽和比湿の計算
    80    ! CalcDQVapSatDTemp      :: 飽和比湿の温度微分の計算
    81    ! ------------  :: ------------
    82    ! CalcQVapSat            :: Calculate saturation specific humidity
    83    ! CalcDQVapSatDTemp      :: Calculate temperature derivative of saturation specific humidity
    84    !
    85    !--
    86    !== NAMELIST
    87    !
    88    ! NAMELIST#saturate_nha1992_nml
    89    !++
    90  
    91    ! モジュール引用 ; USE statements
    92    !
    93  
    94    ! 種別型パラメタ
    95    ! Kind type parameter
    96    !
    97    use dc_types, only: DP, &      ! 倍精度実数型. Double precision.
    98      &                 STRING     ! 文字列.       Strings.
    99  
   100    ! メッセージ出力
   101    ! Message output
   102    !
   103    use dc_message, only: MessageNotify
   104  
   105    ! 宣言文 ; Declaration statements
   106    !
   107    implicit none
   108    private
   109  
   110    ! 公開手続き
   111    ! Public procedure
   112    !
   113    public:: xyz_CalcQVapSatOnLiq
   114    public:: xyz_CalcDQVapSatDTempOnLiq
   115    public:: xyz_CalcQVapSatOnSol
   116    public:: xyz_CalcDQVapSatDTempOnSol
   117    public:: SaturateInit
   118  
   119    ! 公開変数
   120    ! Public variables
   121    !
   122    logical, save, public:: saturate_nha1992_inited = .false.
   123                                ! 初期設定フラグ.
   124                                ! Initialization flag
   125  
   126    ! 非公開変数
   127    ! Private variables
   128    !
   129    real(DP), parameter:: LatHeat = 43655_DP
   130                                ! $ l $ [J mol-1].
   131                                ! 水の凝結の潜熱. Latent heat of condensation of water vapor
   132    real(DP), parameter:: P0 = 1.4e+11_DP
   133                                ! $ p_0^{*} $ [Pa].
   134                                ! 水蒸気飽和曲線の定数. constant for water vapor saturation curve
   135  
   136    character(*), parameter:: module_name = 'saturate_nha1992'
   137                                ! モジュールの名称.
   138                                ! Module name
   139    character(*), parameter:: version = &
   140      & '$Name:  $' // &
   141      & '$Id: saturate_nha1992.f90,v 1.9 2015/01/29 12:07:16 yot Exp $'
   142                                ! モジュールのバージョン
   143                                ! Module version
   144  
   145  contains
   146  
   147    !--------------------------------------------------------------------------------------
   148  
   149    function xyz_CalcQVapSatOnLiq( xyz_Temp, xyz_Press ) result( xyz_QVapSat )
   150      !
   151      ! 温度 *Temp* と気圧 *Press* を用い,
   152      ! 飽和比湿 *QVapSat* を求めます.
   153      !
   154      ! Calculate saturation specific humidity *QVapSat* using
   155      ! temperature *Temp* and air pressure *Press*.
   156      !
   157  
   158      ! モジュール引用 ; USE statements
   159      !
   160  
   161      ! 物理・数学定数設定
   162      ! Physical and mathematical constants settings
   163      !
   164      use constants0, only: &
   165        & GasRUniv              ! $ R^{*} $ [J K-1 mol-1].
   166                                ! 普遍気体定数.  Universal gas constant
   167  
   168      ! 物理定数設定
   169      ! Physical constants settings
   170      !
   171      use constants, only: &
   172        & EpsV                  ! $ \epsilon_v $ .
   173                                ! 水蒸気分子量比.
   174                                ! Molecular weight of water vapor
   175  
   176      ! 宣言文 ; Declaration statements
   177      !
   178      implicit none
   179  
   180      real(DP), intent(in):: xyz_Temp (:,:,:)
   181                                ! $ T $ . 温度. Temperature
   182      real(DP), intent(in):: xyz_Press(:,:,:)
   183                                ! $ p $ . 気圧. Air pressure
   184      real(DP):: xyz_QVapSat(size(xyz_Temp,1), size(xyz_Temp,2), size(xyz_Temp,3))
   185                                ! $ q^{*} $ . 飽和比湿. Saturation specific humidity
   186  
   187      ! 作業変数
   188      ! Work variables
   189      !
   190  
   191      ! 実行文 ; Executable statement
   192      !
   193  
   194      if ( .not. saturate_nha1992_inited ) then
   195        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   196      end if
   197  
   198      ! 飽和比湿の計算
   199      ! Calculate saturation specific humidity
   200      !
   201      xyz_QVapSat = EpsV * ( P0 / xyz_Press ) * exp ( - LatHeat / ( GasRUniv * xyz_Temp ) )
     .        if (xyz_press.DSC.U2 .gt. 0) then                                 
     .           j4 = and(xyz_press.DSC.U2,3)                                   
     .  !cdir    nodep                                                          
     .           do t63 = 1, j4                                                 
     .  !cdir       nodep                                                       
     .              do t65 = 1, xyz_press.DSC.U1                                
     .                 xyz_qvapsat(t65,t63,t61+1) = epsv*(1.40000000000000e+011/
     .       1            xyz_press(t65,t63,t61+1))*dexp((-4.36550000000000e+004
     .       2            /(8.31446210000000e+000*xyz_temp(t65,t63,t61+1))))    
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t63 = j4 + 1, xyz_press.DSC.U2, 4                           
     .  !cdir       nodep                                                       
     .              do t65 = 1, xyz_press.DSC.U1                                
     .                 xyz_qvapsat(t65,t63,t61+1) = epsv*(1.40000000000000e+011/
     .       1            xyz_press(t65,t63,t61+1))*dexp((-4.36550000000000e+004
     .       2            /(8.31446210000000e+000*xyz_temp(t65,t63,t61+1))))    
     .                 xyz_qvapsat(t65,t63+1,t61+1) = epsv*(                    
     .       1            1.40000000000000e+011/xyz_press(t65,t63+1,t61+1))*dexp
     .       2            ((-4.36550000000000e+004/(8.31446210000000e+000*      
     .       3            xyz_temp(t65,t63+1,t61+1))))                          
     .                 xyz_qvapsat(t65,t63+2,t61+1) = epsv*(                    
     .       1            1.40000000000000e+011/xyz_press(t65,t63+2,t61+1))*dexp
     .       2            ((-4.36550000000000e+004/(8.31446210000000e+000*      
     .       3            xyz_temp(t65,t63+2,t61+1))))                          
     .                 xyz_qvapsat(t65,t63+3,t61+1) = epsv*(                    
     .       1            1.40000000000000e+011/xyz_press(t65,t63+3,t61+1))*dexp
     .       2            ((-4.36550000000000e+004/(8.31446210000000e+000*      
     .       3            xyz_temp(t65,t63+3,t61+1))))                          
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
   202  
   203  
   204    end function xyz_CalcQVapSatOnLiq
   205  
   206    !--------------------------------------------------------------------------------------
   207  
   208    function xyz_CalcDQVapSatDTempOnLiq( xyz_Temp, xyz_QVapSat ) result( xyz_DQVapSatDTemp )
   209      !
   210      ! 温度 *Temp* と飽和比湿 *QVapSat* を用い,
   211      ! 飽和比湿の温度微分 *DQVapSatDTemp* を求めます.
   212      !
   213      ! Calculate temperature derivative of saturation specific humidity
   214      ! *DQVapSatDTemp* using
   215      ! temperature *Temp* and saturation specific humidity *QVapSat*.
   216      !
   217  
   218      ! モジュール引用 ; USE statements
   219      !
   220  
   221      ! 物理・数学定数設定
   222      ! Physical and mathematical constants settings
   223      !
   224      use constants0, only: &
   225        & GasRUniv              ! $ R^{*} $ [J K-1 mol-1].
   226                                ! 普遍気体定数.  Universal gas constant
   227  
   228      ! 宣言文 ; Declaration statements
   229      !
   230      implicit none
   231  
   232      real(DP), intent(in):: xyz_Temp   (:,:,:)
   233                                ! $ T $ . 温度. Temperature
   234      real(DP), intent(in):: xyz_QVapSat(:,:,:)
   235                                ! $ q^{*} $ . 飽和比湿. Saturation specific humidity
   236      real(DP):: xyz_DQVapSatDTemp(size(xyz_Temp,1), size(xyz_Temp,2), size(xyz_Temp,3))
   237                                ! $ \DP{q^{*}}{T} $ . 飽和比湿の温度微分.
   238                                ! Temperature derivative of saturation specific humidity.
   239  
   240      ! 作業変数
   241      ! Work variables
   242      !
   243  
   244      ! 実行文 ; Executable statement
   245      !
   246  
   247      if ( .not. saturate_nha1992_inited ) then
   248        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   249      end if
   250  
   251      ! 飽和比湿の温度微分の計算
   252      ! Calculate temperature derivative of saturation specific humidity
   253      !
   254      xyz_DQVapSatDTemp = xyz_QVapSat * LatHeat / ( GasRUniv * xyz_Temp**2 )
     .        if (xyz_qvapsat.DSC.U2 .gt. 0) then                               
     .           j4 = and(xyz_qvapsat.DSC.U2,3)                                 
     .  !cdir    nodep                                                          
     .           do t59 = 1, j4                                                 
     .  !cdir       nodep                                                       
     .              do t61 = 1, xyz_qvapsat.DSC.U1                              
     .                 xyz_dqvapsatdtemp(t61,t59,t57+1) = xyz_qvapsat(t61,t59,  
     .       1            t57+1)*4.36550000000000e+004/(8.31446210000000e+000*  
     .       2            xyz_temp(t61,t59,t57+1)**2)                           
     .              enddo                                                       
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do t59 = j4 + 1, xyz_qvapsat.DSC.U2, 4                         
     .  !cdir       nodep                                                       
     .              do t61 = 1, xyz_qvapsat.DSC.U1                              
     .                 xyz_dqvapsatdtemp(t61,t59,t57+1) = xyz_qvapsat(t61,t59,  
     .       1            t57+1)*4.36550000000000e+004/(8.31446210000000e+000*  
     .       2            xyz_temp(t61,t59,t57+1)**2)                           
     .                 xyz_dqvapsatdtemp(t61,t59+1,t57+1) = xyz_qvapsat(t61,t59+
     .       1            1,t57+1)*4.36550000000000e+004/(8.31446210000000e+000*
     .       2            xyz_temp(t61,t59+1,t57+1)**2)                         
     .                 xyz_dqvapsatdtemp(t61,t59+2,t57+1) = xyz_qvapsat(t61,t59+
     .       1            2,t57+1)*4.36550000000000e+004/(8.31446210000000e+000*
     .       2            xyz_temp(t61,t59+2,t57+1)**2)                         
     .                 xyz_dqvapsatdtemp(t61,t59+3,t57+1) = xyz_qvapsat(t61,t59+
     .       1            3,t57+1)*4.36550000000000e+004/(8.31446210000000e+000*
     .       2            xyz_temp(t61,t59+3,t57+1)**2)                         
     .              enddo                                                       
     .           enddo                                                          
     .        endif                                                             
   255  
   256  
   257    end function xyz_CalcDQVapSatDTempOnLiq
   258  
   259    !--------------------------------------------------------------------------------------
   260  
   261    function xyz_CalcQVapSatOnSol( xyz_Temp, xyz_Press ) result( xyz_QVapSat )
   262      !
   263      ! 温度 *Temp* と気圧 *Press* を用い,
   264      ! 飽和比湿 *QVapSat* を求めます.
   265      !
   266      ! Calculate saturation specific humidity *QVapSat* using
   267      ! temperature *Temp* and air pressure *Press*.
   268      !
   269  
   270      ! モジュール引用 ; USE statements
   271      !
   272  
   273      ! 宣言文 ; Declaration statements
   274      !
   275      implicit none
   276  
   277      real(DP), intent(in):: xyz_Temp (:,:,:)
   278                                ! $ T $ . 温度. Temperature
   279      real(DP), intent(in):: xyz_Press(:,:,:)
   280                                ! $ p $ . 気圧. Air pressure
   281      real(DP):: xyz_QVapSat(size(xyz_Temp,1), size(xyz_Temp,2), size(xyz_Temp,3))
   282                                ! $ q^{*} $ . 飽和比湿. Saturation specific humidity
   283  
   284      ! 作業変数
   285      ! Work variables
   286      !
   287  
   288      ! 実行文 ; Executable statement
   289      !
   290  
   291      if ( .not. saturate_nha1992_inited ) then
   292        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   293      end if
   294  
   295      ! 飽和比湿の計算
   296      ! Calculate saturation specific humidity
   297      !
   298      xyz_QVapSat = xyz_CalcQVapSatOnLiq( xyz_Temp, xyz_Press )
   299  
   300  
   301    end function xyz_CalcQVapSatOnSol
   302  
   303    !--------------------------------------------------------------------------------------
   304  
   305    function xyz_CalcDQVapSatDTempOnSol( xyz_Temp, xyz_QVapSat ) result( xyz_DQVapSatDTemp )
   306      !
   307      ! 温度 *Temp* と飽和比湿 *QVapSat* を用い,
   308      ! 飽和比湿の温度微分 *DQVapSatDTemp* を求めます.
   309      !
   310      ! Calculate temperature derivative of saturation specific humidity
   311      ! *DQVapSatDTemp* using
   312      ! temperature *Temp* and saturation specific humidity *QVapSat*.
   313      !
   314  
   315      ! モジュール引用 ; USE statements
   316      !
   317  
   318      ! 宣言文 ; Declaration statements
   319      !
   320      implicit none
   321  
   322      real(DP), intent(in):: xyz_Temp   (:,:,:)
   323                                ! $ T $ . 温度. Temperature
   324      real(DP), intent(in):: xyz_QVapSat(:,:,:)
   325                                ! $ q^{*} $ . 飽和比湿. Saturation specific humidity
   326      real(DP):: xyz_DQVapSatDTemp(size(xyz_Temp,1), size(xyz_Temp,2), size(xyz_Temp,3))
   327                                ! $ \DP{q^{*}}{T} $ . 飽和比湿の温度微分.
   328                                ! Temperature derivative of saturation specific humidity.
   329  
   330      ! 作業変数
   331      ! Work variables
   332      !
   333  
   334      ! 実行文 ; Executable statement
   335      !
   336  
   337      if ( .not. saturate_nha1992_inited ) then
   338        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   339      end if
   340  
   341      ! 飽和比湿の温度微分の計算
   342      ! Calculate temperature derivative of saturation specific humidity
   343      !
   344      xyz_DQVapSatDTemp = xyz_CalcDQVapSatDTempOnLiq( xyz_Temp, xyz_QVapSat )
   345  
   346  
   347    end function xyz_CalcDQVapSatDTempOnSol
   348  
   349    !--------------------------------------------------------------------------------------
   350  
   351    subroutine SaturateInit
   352      !
   353      ! saturate_nha1992 モジュールの初期化を行います.
   354      !--
   355      ! NAMELIST#saturate_nha1992_nml の読み込みはこの手続きで行われます.
   356      !++
   357      !
   358      ! "saturate_nha1992" module is initialized.
   359      !--
   360      ! "NAMELIST#saturate_nha1992_nml" is loaded in this procedure.
   361      !++
   362  
   363      ! モジュール引用 ; USE statements
   364      !
   365  
   366      ! NAMELIST ファイル入力に関するユーティリティ
   367      ! Utilities for NAMELIST file input
   368      !
   369      use namelist_util, only: namelist_filename, NmlutilMsg
   370  
   371      ! ファイル入出力補助
   372      ! File I/O support
   373      !
   374      use dc_iounit, only: FileOpen
   375  
   376      ! 種別型パラメタ
   377      ! Kind type parameter
   378      !
   379      use dc_types, only: STDOUT ! 標準出力の装置番号. Unit number of standard output
   380  
   381      ! 文字列操作
   382      ! Character handling
   383      !
   384      use dc_string, only: StoA
   385  
   386      ! ヒストリデータ出力
   387      ! History data output
   388      !
   389      use gtool_historyauto, only: HistoryAutoAddVariable
   390  
   391      ! 宣言文 ; Declaration statements
   392      !
   393      implicit none
   394  
   395  !!$    integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号.
   396  !!$                              ! Unit number for NAMELIST file open
   397  !!$    integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT.
   398  !!$                              ! IOSTAT of NAMELIST read
   399  
   400      ! NAMELIST 変数群
   401      ! NAMELIST group name
   402      !
   403  !!$    namelist /saturate_nha1992_nml/
   404            !
   405            ! デフォルト値については初期化手続 "saturate_nha1992#SaturateInit"
   406            ! のソースコードを参照のこと.
   407            !
   408            ! Refer to source codes in the initialization procedure
   409            ! "saturate_nha1992#SaturateInit" for the default values.
   410            !
   411  
   412      ! 実行文 ; Executable statement
   413      !
   414  
   415      if ( saturate_nha1992_inited ) return
   416  
   417  
   418      ! デフォルト値の設定
   419      ! Default values settings
   420      !
   421  
   422  
   423  !!$    ! NAMELIST の読み込み
   424  !!$    ! NAMELIST is input
   425  !!$    !
   426  !!$    if ( trim(namelist_filename) /= '' ) then
   427  !!$      call FileOpen( unit_nml, &          ! (out)
   428  !!$        & namelist_filename, mode = 'r' ) ! (in)
   429  !!$
   430  !!$      rewind( unit_nml )
   431  !!$      read( unit_nml, &           ! (in)
   432  !!$        & nml = saturate_nha1992_nml, &  ! (out)
   433  !!$        & iostat = iostat_nml )   ! (out)
   434  !!$      close( unit_nml )
   435  !!$
   436  !!$      call NmlutilMsg( iostat_nml, module_name ) ! (in)
   437  !!$    end if
   438  
   439      ! 印字 ; Print
   440      !
   441      call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   442      call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   443  
   444      saturate_nha1992_inited = .true.
   445  
   446    end subroutine SaturateInit
   447  
   448    !--------------------------------------------------------------------------------------
   449  
   450  end module saturate_nha1992
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:26 2016
FILE NAME: saturate_nha1992.f90
PROGRAM NAME: saturate_nha1992
FORMAT LIST

  LINE    LOOP      FORTRAN STATEMENT

     1:             != Nakajima et al. (1992) を用いた飽和比湿の算出
     2:             !
     3:             != Evaluate saturation specific humidity with Nakajima et al. (1992)
     4:             !
     5:             ! Authors::   Masaki ISHIWATARI, Yasuhiro MORIKAWA, Y. O. Takahashi
     6:             ! Version::   $Id: saturate_nha1992.f90,v 1.9 2015/01/29 12:07:16 yot Exp $
     7:             ! Tag Name::  $Name:  $
     8:             ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9:             ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10:             !
    11:             
    12:             module saturate_nha1992
    13:               !
    14:               != Nakajima et al. (1992) を用いた飽和比湿の算出
    15:               !
    16:               != Evaluate saturation specific humidity with Nakajima et al. (1992)
    17:               !
    18:               ! <b>Note that Japanese and English are described in parallel.</b>
    19:               !
    20:               ! Nakajima et al. (1992) で用いられた飽和蒸気圧 $ p^{*} $ に関する以下の式
    21:               ! を用い, 飽和比湿および飽和比湿の温度微分の値を算出します. 
    22:               !
    23:               ! Saturation specific humidity and temperature derivative of it 
    24:               ! are calculated with a folloing formula for saturation watar vapor pressure 
    25:               ! $ p^{*} $ in Nakajima et al. (1992). 
    26:               ! 
    27:               ! \[
    28:               !    p^{*} (T) = p_0^{*} \exp \left( - \frac{l}{RT} \right). 
    29:               ! \]
    30:               !
    31:               ! ここで, $ T $ は温度, $ R $ は普遍気体定数です. 
    32:               ! $ R $ および潜熱 $ l $ , 
    33:               ! 水蒸気飽和曲線の定数 $ p_0^{*} $ は以下のように与えられます. 
    34:               !
    35:               ! where $ T $ is temperature, $ R $ is the gas constant. 
    36:               ! $ R $ and latent heat $ l $ , 
    37:               ! constant for the water vapor saturation curve $ p_0^{*} $ are as follows.
    38:               ! 
    39:               ! * $ R = 8.314 $ [J mol-1 K-1]
    40:               ! * $ l = 43655 $ [J mol-1]
    41:               ! * $ p_0^{*} = 1.4 \times 10^{11} $ [Pa]
    42:               !
    43:               ! 飽和水蒸気圧から飽和比湿 $ q^{*} $ を求める際には, 以下の式を用います. 
    44:               !
    45:               ! Saturation specific humidity $ q^{*} $ is calculated from 
    46:               ! saturation watar vapor pressure as follows.
    47:               !
    48:               ! \[
    49:               !    q^{*} (T, p) = \varepsilon \frac{p^{*} (T)}{p}
    50:               ! \]
    51:               !
    52:               ! ここで $ \varepsilon $ は凝結成分と大気の分子量比, 
    53:               ! $ p $ は気圧です. 
    54:               !
    55:               ! where $ \varepsilon $ is molecular weight ratio of water vapor to air, 
    56:               ! $ p $ is air pressure. 
    57:               ! 
    58:               ! 従って, 飽和比湿, 飽和比湿の温度変化を求める式は以下のように
    59:               ! なります. 
    60:               !
    61:               ! Therefore, saturation specific humidity and temperature derivative of it 
    62:               ! are calculated as follows. 
    63:               !
    64:               ! \[
    65:               !    q^{*} (T, p) = \varepsilon \frac{p_0^{*}}{p} \exp \left( - \frac{l}{RT} \right), \] \[
    66:               !    \DP{q^{*} (T, p)}{T} = \varepsilon \frac{p_0^{*}}{p} \frac{l}{RT^2} \exp \left( - \frac{l}{RT} \right) 
    67:               !    = q^{*} \frac{l}{RT^2}
    68:               ! \]
    69:               !
    70:               !== References
    71:               !
    72:               ! * Nakajima, S., Hayashi, Y.-Y., Abe, Y., 1992: 
    73:               !   A study on the "runaway greenhouse effect" with a 
    74:               !   one dimensional radiative convective equilibrium model. 
    75:               !   <i>J. Atmos. Sci.</i>, <b>49</b>, 2256--2266.
    76:               !
    77:               !== Procedures List
    78:               !
    79:               ! CalcQVapSat            :: 飽和比湿の計算
    80:               ! CalcDQVapSatDTemp      :: 飽和比湿の温度微分の計算
    81:               ! ------------  :: ------------
    82:               ! CalcQVapSat            :: Calculate saturation specific humidity
    83:               ! CalcDQVapSatDTemp      :: Calculate temperature derivative of saturation specific humidity
    84:               !
    85:               !--
    86:               !== NAMELIST
    87:               !
    88:               ! NAMELIST#saturate_nha1992_nml
    89:               !++
    90:             
    91:               ! モジュール引用 ; USE statements
    92:               !
    93:             
    94:               ! 種別型パラメタ
    95:               ! Kind type parameter
    96:               !
    97:               use dc_types, only: DP, &      ! 倍精度実数型. Double precision. 
    98:                 &                 STRING     ! 文字列.       Strings. 
    99:             
   100:               ! メッセージ出力
   101:               ! Message output
   102:               !
   103:               use dc_message, only: MessageNotify
   104:             
   105:               ! 宣言文 ; Declaration statements
   106:               !
   107:               implicit none
   108:               private
   109:             
   110:               ! 公開手続き
   111:               ! Public procedure
   112:               !
   113:               public:: xyz_CalcQVapSatOnLiq
   114:               public:: xyz_CalcDQVapSatDTempOnLiq
   115:               public:: xyz_CalcQVapSatOnSol
   116:               public:: xyz_CalcDQVapSatDTempOnSol
   117:               public:: SaturateInit
   118:             
   119:               ! 公開変数
   120:               ! Public variables
   121:               !
   122:               logical, save, public:: saturate_nha1992_inited = .false.
   123:                                           ! 初期設定フラグ. 
   124:                                           ! Initialization flag
   125:             
   126:               ! 非公開変数
   127:               ! Private variables
   128:               !
   129:               real(DP), parameter:: LatHeat = 43655_DP
   130:                                           ! $ l $ [J mol-1].
   131:                                           ! 水の凝結の潜熱. Latent heat of condensation of water vapor
   132:               real(DP), parameter:: P0 = 1.4e+11_DP
   133:                                           ! $ p_0^{*} $ [Pa].
   134:                                           ! 水蒸気飽和曲線の定数. constant for water vapor saturation curve
   135:             
   136:               character(*), parameter:: module_name = 'saturate_nha1992'
   137:                                           ! モジュールの名称. 
   138:                                           ! Module name
   139:               character(*), parameter:: version = &
   140:                 & '$Name:  $' // &
   141:                 & '$Id: saturate_nha1992.f90,v 1.9 2015/01/29 12:07:16 yot Exp $'
   142:                                           ! モジュールのバージョン
   143:                                           ! Module version
   144:             
   145:             contains
   146:             
   147:               !--------------------------------------------------------------------------------------
   148:             
   149:               function xyz_CalcQVapSatOnLiq( xyz_Temp, xyz_Press ) result( xyz_QVapSat )
   150:                 !
   151:                 ! 温度 *Temp* と気圧 *Press* を用い, 
   152:                 ! 飽和比湿 *QVapSat* を求めます. 
   153:                 !
   154:                 ! Calculate saturation specific humidity *QVapSat* using
   155:                 ! temperature *Temp* and air pressure *Press*. 
   156:                 !
   157:             
   158:                 ! モジュール引用 ; USE statements
   159:                 !
   160:             
   161:                 ! 物理・数学定数設定
   162:                 ! Physical and mathematical constants settings
   163:                 !
   164:                 use constants0, only: &
   165:                   & GasRUniv              ! $ R^{*} $ [J K-1 mol-1].
   166:                                           ! 普遍気体定数.  Universal gas constant
   167:             
   168:                 ! 物理定数設定
   169:                 ! Physical constants settings
   170:                 !
   171:                 use constants, only: &
   172:                   & EpsV                  ! $ \epsilon_v $ . 
   173:                                           ! 水蒸気分子量比. 
   174:                                           ! Molecular weight of water vapor
   175:             
   176:                 ! 宣言文 ; Declaration statements
   177:                 !
   178:                 implicit none
   179:             
   180:                 real(DP), intent(in):: xyz_Temp (:,:,:)
   181:                                           ! $ T $ . 温度. Temperature
   182:                 real(DP), intent(in):: xyz_Press(:,:,:)
   183:                                           ! $ p $ . 気圧. Air pressure
   184:                 real(DP):: xyz_QVapSat(size(xyz_Temp,1), size(xyz_Temp,2), size(xyz_Temp,3))
   185:                                           ! $ q^{*} $ . 飽和比湿. Saturation specific humidity
   186:             
   187:                 ! 作業変数
   188:                 ! Work variables
   189:                 !
   190:             
   191:                 ! 実行文 ; Executable statement
   192:                 !
   193:             
   194:                 if ( .not. saturate_nha1992_inited ) then
   195:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   196:                 end if
   197:             
   198:                 ! 飽和比湿の計算
   199:                 ! Calculate saturation specific humidity
   200:                 !
   201: ++V==== A       xyz_QVapSat = EpsV * ( P0 / xyz_Press ) * exp ( - LatHeat / ( GasRUniv * xyz_Temp ) )
   202:             
   203:             
   204:               end function xyz_CalcQVapSatOnLiq
   205:             
   206:               !--------------------------------------------------------------------------------------
   207:             
   208:               function xyz_CalcDQVapSatDTempOnLiq( xyz_Temp, xyz_QVapSat ) result( xyz_DQVapSatDTemp )
   209:                 !
   210:                 ! 温度 *Temp* と飽和比湿 *QVapSat* を用い, 
   211:                 ! 飽和比湿の温度微分 *DQVapSatDTemp* を求めます. 
   212:                 !
   213:                 ! Calculate temperature derivative of saturation specific humidity 
   214:                 ! *DQVapSatDTemp* using
   215:                 ! temperature *Temp* and saturation specific humidity *QVapSat*. 
   216:                 !
   217:             
   218:                 ! モジュール引用 ; USE statements
   219:                 !
   220:             
   221:                 ! 物理・数学定数設定
   222:                 ! Physical and mathematical constants settings
   223:                 !
   224:                 use constants0, only: &
   225:                   & GasRUniv              ! $ R^{*} $ [J K-1 mol-1].
   226:                                           ! 普遍気体定数.  Universal gas constant
   227:             
   228:                 ! 宣言文 ; Declaration statements
   229:                 !
   230:                 implicit none
   231:             
   232:                 real(DP), intent(in):: xyz_Temp   (:,:,:)
   233:                                           ! $ T $ . 温度. Temperature
   234:                 real(DP), intent(in):: xyz_QVapSat(:,:,:)
   235:                                           ! $ q^{*} $ . 飽和比湿. Saturation specific humidity
   236:                 real(DP):: xyz_DQVapSatDTemp(size(xyz_Temp,1), size(xyz_Temp,2), size(xyz_Temp,3))
   237:                                           ! $ \DP{q^{*}}{T} $ . 飽和比湿の温度微分. 
   238:                                           ! Temperature derivative of saturation specific humidity. 
   239:             
   240:                 ! 作業変数
   241:                 ! Work variables
   242:                 !
   243:             
   244:                 ! 実行文 ; Executable statement
   245:                 !
   246:             
   247:                 if ( .not. saturate_nha1992_inited ) then
   248:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   249:                 end if
   250:             
   251:                 ! 飽和比湿の温度微分の計算
   252:                 ! Calculate temperature derivative of saturation specific humidity
   253:                 !
   254: ++V==== A       xyz_DQVapSatDTemp = xyz_QVapSat * LatHeat / ( GasRUniv * xyz_Temp**2 )
   255:             
   256:             
   257:               end function xyz_CalcDQVapSatDTempOnLiq
   258:             
   259:               !--------------------------------------------------------------------------------------
   260:             
   261:               function xyz_CalcQVapSatOnSol( xyz_Temp, xyz_Press ) result( xyz_QVapSat )
   262:                 !
   263:                 ! 温度 *Temp* と気圧 *Press* を用い, 
   264:                 ! 飽和比湿 *QVapSat* を求めます. 
   265:                 !
   266:                 ! Calculate saturation specific humidity *QVapSat* using
   267:                 ! temperature *Temp* and air pressure *Press*. 
   268:                 !
   269:             
   270:                 ! モジュール引用 ; USE statements
   271:                 !
   272:             
   273:                 ! 宣言文 ; Declaration statements
   274:                 !
   275:                 implicit none
   276:             
   277:                 real(DP), intent(in):: xyz_Temp (:,:,:)
   278:                                           ! $ T $ . 温度. Temperature
   279:                 real(DP), intent(in):: xyz_Press(:,:,:)
   280:                                           ! $ p $ . 気圧. Air pressure
   281:                 real(DP):: xyz_QVapSat(size(xyz_Temp,1), size(xyz_Temp,2), size(xyz_Temp,3))
   282:                                           ! $ q^{*} $ . 飽和比湿. Saturation specific humidity
   283:             
   284:                 ! 作業変数
   285:                 ! Work variables
   286:                 !
   287:             
   288:                 ! 実行文 ; Executable statement
   289:                 !
   290:             
   291:                 if ( .not. saturate_nha1992_inited ) then
   292:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   293:                 end if
   294:             
   295:                 ! 飽和比湿の計算
   296:                 ! Calculate saturation specific humidity
   297:                 !
   298:                 xyz_QVapSat = xyz_CalcQVapSatOnLiq( xyz_Temp, xyz_Press )
   299:             
   300:             
   301:               end function xyz_CalcQVapSatOnSol
   302:             
   303:               !--------------------------------------------------------------------------------------
   304:             
   305:               function xyz_CalcDQVapSatDTempOnSol( xyz_Temp, xyz_QVapSat ) result( xyz_DQVapSatDTemp )
   306:                 !
   307:                 ! 温度 *Temp* と飽和比湿 *QVapSat* を用い, 
   308:                 ! 飽和比湿の温度微分 *DQVapSatDTemp* を求めます. 
   309:                 !
   310:                 ! Calculate temperature derivative of saturation specific humidity 
   311:                 ! *DQVapSatDTemp* using
   312:                 ! temperature *Temp* and saturation specific humidity *QVapSat*. 
   313:                 !
   314:             
   315:                 ! モジュール引用 ; USE statements
   316:                 !
   317:             
   318:                 ! 宣言文 ; Declaration statements
   319:                 !
   320:                 implicit none
   321:             
   322:                 real(DP), intent(in):: xyz_Temp   (:,:,:)
   323:                                           ! $ T $ . 温度. Temperature
   324:                 real(DP), intent(in):: xyz_QVapSat(:,:,:)
   325:                                           ! $ q^{*} $ . 飽和比湿. Saturation specific humidity
   326:                 real(DP):: xyz_DQVapSatDTemp(size(xyz_Temp,1), size(xyz_Temp,2), size(xyz_Temp,3))
   327:                                           ! $ \DP{q^{*}}{T} $ . 飽和比湿の温度微分. 
   328:                                           ! Temperature derivative of saturation specific humidity. 
   329:             
   330:                 ! 作業変数
   331:                 ! Work variables
   332:                 !
   333:             
   334:                 ! 実行文 ; Executable statement
   335:                 !
   336:             
   337:                 if ( .not. saturate_nha1992_inited ) then
   338:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   339:                 end if
   340:             
   341:                 ! 飽和比湿の温度微分の計算
   342:                 ! Calculate temperature derivative of saturation specific humidity
   343:                 !
   344:                 xyz_DQVapSatDTemp = xyz_CalcDQVapSatDTempOnLiq( xyz_Temp, xyz_QVapSat )
   345:             
   346:             
   347:               end function xyz_CalcDQVapSatDTempOnSol
   348:             
   349:               !--------------------------------------------------------------------------------------
   350:             
   351:               subroutine SaturateInit
   352:                 !
   353:                 ! saturate_nha1992 モジュールの初期化を行います. 
   354:                 !--
   355:                 ! NAMELIST#saturate_nha1992_nml の読み込みはこの手続きで行われます. 
   356:                 !++
   357:                 !
   358:                 ! "saturate_nha1992" module is initialized. 
   359:                 !--
   360:                 ! "NAMELIST#saturate_nha1992_nml" is loaded in this procedure. 
   361:                 !++
   362:             
   363:                 ! モジュール引用 ; USE statements
   364:                 !
   365:             
   366:                 ! NAMELIST ファイル入力に関するユーティリティ
   367:                 ! Utilities for NAMELIST file input
   368:                 !
   369:                 use namelist_util, only: namelist_filename, NmlutilMsg
   370:             
   371:                 ! ファイル入出力補助
   372:                 ! File I/O support
   373:                 !
   374:                 use dc_iounit, only: FileOpen
   375:             
   376:                 ! 種別型パラメタ
   377:                 ! Kind type parameter
   378:                 !
   379:                 use dc_types, only: STDOUT ! 標準出力の装置番号. Unit number of standard output
   380:             
   381:                 ! 文字列操作
   382:                 ! Character handling
   383:                 !
   384:                 use dc_string, only: StoA
   385:             
   386:                 ! ヒストリデータ出力
   387:                 ! History data output
   388:                 !
   389:                 use gtool_historyauto, only: HistoryAutoAddVariable
   390:             
   391:                 ! 宣言文 ; Declaration statements
   392:                 !
   393:                 implicit none
   394:             
   395:             !!$    integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号. 
   396:             !!$                              ! Unit number for NAMELIST file open
   397:             !!$    integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT. 
   398:             !!$                              ! IOSTAT of NAMELIST read
   399:             
   400:                 ! NAMELIST 変数群
   401:                 ! NAMELIST group name
   402:                 !
   403:             !!$    namelist /saturate_nha1992_nml/ 
   404:                       !
   405:                       ! デフォルト値については初期化手続 "saturate_nha1992#SaturateInit" 
   406:                       ! のソースコードを参照のこと. 
   407:                       !
   408:                       ! Refer to source codes in the initialization procedure
   409:                       ! "saturate_nha1992#SaturateInit" for the default values. 
   410:                       !
   411:             
   412:                 ! 実行文 ; Executable statement
   413:                 !
   414:             
   415:                 if ( saturate_nha1992_inited ) return
   416:             
   417:             
   418:                 ! デフォルト値の設定
   419:                 ! Default values settings
   420:                 !
   421:             
   422:             
   423:             !!$    ! NAMELIST の読み込み
   424:             !!$    ! NAMELIST is input
   425:             !!$    !
   426:             !!$    if ( trim(namelist_filename) /= '' ) then
   427:             !!$      call FileOpen( unit_nml, &          ! (out)
   428:             !!$        & namelist_filename, mode = 'r' ) ! (in)
   429:             !!$
   430:             !!$      rewind( unit_nml )
   431:             !!$      read( unit_nml, &           ! (in)
   432:             !!$        & nml = saturate_nha1992_nml, &  ! (out)
   433:             !!$        & iostat = iostat_nml )   ! (out)
   434:             !!$      close( unit_nml )
   435:             !!$
   436:             !!$      call NmlutilMsg( iostat_nml, module_name ) ! (in)
   437:             !!$    end if
   438:             
   439:                 ! 印字 ; Print
   440:                 !
   441:                 call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   442:                 call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   443:             
   444:                 saturate_nha1992_inited = .true.
   445:             
   446:               end subroutine SaturateInit
   447:             
   448:               !--------------------------------------------------------------------------------------
   449:             
   450:             end module saturate_nha1992
