Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:26 2016
FILE NAME: snowice_frac.f90
PROGRAM NAME: snowice_frac
DIAGNOSTIC LIST

  LINE  LEVEL( NO.): DIAGNOSTIC MESSAGE

   139  opt  (1593): Loop nest collapsed into one loop.
   139  vec  (   1): Vectorized loop.
   139  vec  (  29): ADB is used for array.: xy_snowfrac
   139  vec  (  29): ADB is used for array.: xy_surfsnow
   157  opt  (1593): Loop nest collapsed into one loop.
   157  vec  (   4): Vectorized array expression.
   157  vec  (  29): ADB is used for array.: xy_snowfrac
   209  opt  (1593): Loop nest collapsed into one loop.
   209  vec  (   1): Vectorized loop.
   209  vec  (  29): ADB is used for array.: xy_snowfrac
   209  vec  (  29): ADB is used for array.: xy_surfsnow
   224  opt  (1593): Loop nest collapsed into one loop.
   224  vec  (   4): Vectorized array expression.
   224  vec  (  29): ADB is used for array.: xy_snowfrac
   276  opt  (1593): Loop nest collapsed into one loop.
   276  vec  (   1): Vectorized loop.
   276  vec  (  29): ADB is used for array.: xy_seaicefrac
   276  vec  (  29): ADB is used for array.: xy_seaiceconc
   342  opt  (1593): Loop nest collapsed into one loop.
   342  vec  (   1): Vectorized loop.
   342  vec  (  29): ADB is used for array.: xy_majcompicefrac
   342  vec  (  29): ADB is used for array.: xy_surfmajcompice
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:26 2016
FILE NAME: snowice_frac.f90
PROGRAM NAME: snowice_frac
TRANSFORMATION LIST

  LINE                   FORTRAN STATEMENT

     1  != 雪, 氷の割合
     2  !
     3  != snow/ice fraction
     4  !
     5  ! Authors::   Yoshiyuki O. Takahashi
     6  ! Version::   $Id: snowice_frac.f90,v 1.1 2015/01/29 12:12:21 yot Exp $
     7  ! Tag Name::  $Name:  $
     8  ! Copyright:: Copyright (C) GFD Dennou Club, 2008-2009. All rights reserved.
     9  ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10  !
    11  
    12  module snowice_frac
    13  
    14    ! モジュール引用 ; USE statements
    15    !
    16  
    17    ! 種別型パラメタ
    18    ! Kind type parameter
    19    !
    20    use dc_types, only: DP, &      ! 倍精度実数型. Double precision.
    21      &                 STRING     ! 文字列.       Strings.
    22  
    23    ! メッセージ出力
    24    ! Message output
    25    !
    26    use dc_message, only: MessageNotify
    27  
    28    ! 格子点設定
    29    ! Grid points settings
    30  
    31    ! 宣言文 ; Declaration statements
    32    !
    33    implicit none
    34    private
    35  
    36    ! 公開手続き
    37    ! Public procedure
    38    !
    39    public :: SeaIceAboveThreshold
    40    public :: CalcSnowFrac
    41    public :: CalcSfcLiqSolFrac
    42    public :: CalcSeaIceFrac
    43    public :: CalcMajCompIceFrac
    44    public :: SnowIceFracInit
    45  
    46    ! 公開変数
    47    ! Public variables
    48    !
    49  
    50    ! 非公開変数
    51    ! Private variables
    52    !
    53    real(DP), save :: NOrd
    54  
    55    logical, save :: snowice_frac_inited = .false.
    56                                ! 初期設定フラグ.
    57                                ! Initialization flag
    58  
    59    character(*), parameter:: module_name = 'snowice_frac'
    60                                ! モジュールの名称.
    61                                ! Module name
    62    character(*), parameter:: version = &
    63      & '$Name:  $' // &
    64      & '$Id: snowice_frac.f90,v 1.1 2015/01/29 12:12:21 yot Exp $'
    65                                ! モジュールのバージョン
    66                                ! Module version
    67  
    68  contains
    69  
    70    !--------------------------------------------------------------------------------------
    71  
    72    function SeaIceAboveThreshold( SeaIceConc ) result( FlagExist )
    73  
    74      ! 雪と海氷の定数の設定
    75      ! Setting constants of snow and sea ice
    76      !
    77      use constants_snowseaice, only: &
    78        & SeaIceThreshold
    79  
    80      real(DP), intent(in) :: SeaIceConc
    81  
    82      logical :: FlagExist
    83  
    84  
    85      if ( SeaIceConc > SeaIceThreshold ) then
    86        FlagExist = .true.
    87      else
    88        FlagExist = .false.
    89      end if
    90  
    91    end function SeaIceAboveThreshold
    92  
    93    !--------------------------------------------------------------------------------------
    94  
    95    subroutine CalcSnowFrac(       &
    96  !!$    & xy_FlagLand, xy_SurfSnow,  & ! (in )
    97      & xy_SurfSnow,               & ! (in )
    98      & xy_SnowFrac                & ! (out)
    99      & )
   100  
   101      ! 格子点設定
   102      ! Grid points settings
   103      !
   104      use gridset, only: imax, & ! 経度格子点数.
   105                                 ! Number of grid points in longitude
   106        &                jmax, & ! 緯度格子点数.
   107                                 ! Number of grid points in latitude
   108        &                kmax    ! 鉛直層数.
   109                                 ! Number of vertical level
   110  
   111      ! 雪と海氷の定数の設定
   112      ! Setting constants of snow and sea ice
   113      !
   114      use constants_snowseaice, only:            &
   115        & SnowThresholdForAlbedo
   116  
   117  !!$    logical , intent(in ) :: xy_FlagLand( 0:imax-1, 1:jmax )
   118      real(DP), intent(in ) :: xy_SurfSnow( 0:imax-1, 1:jmax )
   119      real(DP), intent(out) :: xy_SnowFrac( 0:imax-1, 1:jmax )
   120  
   121  
   122      ! 作業変数
   123      ! Work variables
   124      !
   125      integer:: i               ! 経度方向に回る DO ループ用作業変数
   126                                ! Work variables for DO loop in longitude
   127      integer:: j               ! 緯度方向に回る DO ループ用作業変数
   128                                ! Work variables for DO loop in latitude
   129  
   130      ! 初期化確認
   131      ! Initialization check
   132      !
   133      if ( .not. snowice_frac_inited ) then
   134        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   135      end if
   136  
   137  
   138      if ( SnowThresholdForAlbedo > 0.0_DP ) then
   139        do j = 1, jmax
   140          do i = 0, imax-1
   141  
   142            xy_SnowFrac(i,j) = &
   143              & ( ( xy_SurfSnow(i,j) - 0.0_DP ) / ( SnowThresholdForAlbedo - 0.0_DP ) )**NOrd
   144            xy_SnowFrac(i,j) = max( min( xy_SnowFrac(i,j), 1.0_DP ), 0.0_DP )
   145  
   146  !!$        if ( xy_FlagLand(i,j) ) then
   147  !!$          xy_SnowFrac(i,j) = &
   148  !!$            & ( ( xy_SurfSnow(i,j) - 0.0_DP ) / ( SnowThresholdForAlbedo - 0.0_DP ) )**NOrd
   149  !!$          xy_SnowFrac(i,j) = max( min( xy_SnowFrac(i,j), 1.0_DP ), 0.0_DP )
   150  !!$        else
   151  !!$          xy_SnowFrac(i,j) = 0.0_DP
   152  !!$        end if
   153  
   154          end do
   155        end do
     .        d2 = 1.D0/(snowthresholdforalbedo - 0.0000000000000000e+000)      
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do j = 1, jmax*imax                                               
     .           xy_snowfrac1 = ((xy_surfsnow(j-1,1)-0.0000000000000000e+000)*d2
     .       1      )**nord                                                     
     .           xy_snowfrac(j-1,1) = max(min(xy_snowfrac1,1.00000000000000e+000
     .       1      ),0.0000000000000000e+000)                                  
     .        enddo                                                             
     .        goto 10008                                                        
   156      else
   157        xy_SnowFrac = 1.0_DP
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t67 = 1, jmax*imax                                             
     .           xy_snowfrac(t67-1,1) = 1.00000000000000e+000                   
     .        enddo                                                             
   158      end if
   159  
   160  
   161    end subroutine CalcSnowFrac
   162  
   163    !--------------------------------------------------------------------------------------
   164  
   165    subroutine CalcSfcLiqSolFrac(       &
   166  !!$    & xy_FlagLand, xy_SurfSnow,  & ! (in )
   167      & xy_SurfSnow,               & ! (in )
   168      & xy_SnowFrac                & ! (out)
   169      & )
   170  
   171      ! 格子点設定
   172      ! Grid points settings
   173      !
   174      use gridset, only: imax, & ! 経度格子点数.
   175                                 ! Number of grid points in longitude
   176        &                jmax, & ! 緯度格子点数.
   177                                 ! Number of grid points in latitude
   178        &                kmax    ! 鉛直層数.
   179                                 ! Number of vertical level
   180  
   181      ! 雪と海氷の定数の設定
   182      ! Setting constants of snow and sea ice
   183      !
   184      use constants_snowseaice, only:            &
   185        & SnowThresholdForFlux
   186  
   187  !!$    logical , intent(in ) :: xy_FlagLand( 0:imax-1, 1:jmax )
   188      real(DP), intent(in ) :: xy_SurfSnow( 0:imax-1, 1:jmax )
   189      real(DP), intent(out) :: xy_SnowFrac( 0:imax-1, 1:jmax )
   190  
   191  
   192      ! 作業変数
   193      ! Work variables
   194      !
   195      integer:: i               ! 経度方向に回る DO ループ用作業変数
   196                                ! Work variables for DO loop in longitude
   197      integer:: j               ! 緯度方向に回る DO ループ用作業変数
   198                                ! Work variables for DO loop in latitude
   199  
   200      ! 初期化確認
   201      ! Initialization check
   202      !
   203      if ( .not. snowice_frac_inited ) then
   204        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   205      end if
   206  
   207  
   208      if ( SnowThresholdForFlux > 0.0_DP ) then
   209        do j = 1, jmax
   210          do i = 0, imax-1
   211  
   212  !!$        if ( xy_FlagLand(i,j) ) then
   213            xy_SnowFrac(i,j) = &
   214              & ( ( xy_SurfSnow(i,j) - 0.0_DP ) / ( SnowThresholdForFlux - 0.0_DP ) )**NOrd
   215            xy_SnowFrac(i,j) = max( min( xy_SnowFrac(i,j), 1.0_DP ), 0.0_DP )
   216  !!$        else
   217  !!$          xy_SnowFrac(i,j) = 0.0_DP
   218  !!$        end if
   219  
   220          end do
   221        end do
     .        d2 = 1.D0/(snowthresholdforflux - 0.0000000000000000e+000)        
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do j = 1, jmax*imax                                               
     .           xy_snowfrac1 = ((xy_surfsnow(j-1,1)-0.0000000000000000e+000)*d2
     .       1      )**nord                                                     
     .           xy_snowfrac(j-1,1) = max(min(xy_snowfrac1,1.00000000000000e+000
     .       1      ),0.0000000000000000e+000)                                  
     .        enddo                                                             
     .        goto 10008                                                        
   222  
   223      else
   224        xy_SnowFrac = 1.0_DP
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do t67 = 1, jmax*imax                                             
     .           xy_snowfrac(t67-1,1) = 1.00000000000000e+000                   
     .        enddo                                                             
   225      end if
   226  
   227  
   228    end subroutine CalcSfcLiqSolFrac
   229  
   230    !--------------------------------------------------------------------------------------
   231  
   232    subroutine CalcSeaIceFrac(       &
   233  !!$    & xy_FlagOcean, xy_SeaIceConc, & ! (in )
   234      & xy_SeaIceConc,               & ! (in )
   235      & xy_SeaIceFrac                & ! (out)
   236      & )
   237  
   238      ! 格子点設定
   239      ! Grid points settings
   240      !
   241      use gridset, only: imax, & ! 経度格子点数.
   242                                 ! Number of grid points in longitude
   243        &                jmax, & ! 緯度格子点数.
   244                                 ! Number of grid points in latitude
   245        &                kmax    ! 鉛直層数.
   246                                 ! Number of vertical level
   247  
   248      ! 雪と海氷の定数の設定
   249      ! Setting constants of snow and sea ice
   250      !
   251      use constants_snowseaice, only:  &
   252        & SeaIceThreshold
   253  
   254  
   255  !!$    logical , intent(in ) :: xy_FlagOcean ( 0:imax-1, 1:jmax )
   256      real(DP), intent(in ) :: xy_SeaIceConc( 0:imax-1, 1:jmax )
   257      real(DP), intent(out) :: xy_SeaIceFrac( 0:imax-1, 1:jmax )
   258  
   259  
   260      ! 作業変数
   261      ! Work variables
   262      !
   263      integer:: i               ! 経度方向に回る DO ループ用作業変数
   264                                ! Work variables for DO loop in longitude
   265      integer:: j               ! 緯度方向に回る DO ループ用作業変数
   266                                ! Work variables for DO loop in latitude
   267  
   268      ! 初期化確認
   269      ! Initialization check
   270      !
   271      if ( .not. snowice_frac_inited ) then
   272        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   273      end if
   274  
   275  
   276      do j = 1, jmax
   277        do i = 0, imax-1
   278  
   279  !!$        if ( ( xy_FlagOcean(i,j) ) .and. &
   280  !!$          &  ( xy_SeaIceConc(i,j) > SeaIceThreshold ) ) then
   281          if ( xy_SeaIceConc(i,j) > SeaIceThreshold ) then
   282            xy_SeaIceFrac(i,j) = 1.0_DP
   283          else
   284            xy_SeaIceFrac(i,j) = 0.0_DP
   285          end if
   286  
   287        end do
   288      end do
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do j = 1, jmax*imax                                               
     .           if (xy_seaiceconc(j-1,1) .gt. seaicethreshold) then            
     .              xy_seaicefrac1 = 1.00000000000000e+000                      
     .           else                                                           
     .              xy_seaicefrac1 = 0.0000000000000000e+000                    
     .           endif                                                          
     .           xy_seaicefrac(j-1,1) = xy_seaicefrac1                          
     .        enddo                                                             
   289  
   290  
   291    end subroutine CalcSeaIceFrac
   292  
   293    !--------------------------------------------------------------------------------------
   294  
   295    subroutine CalcMajCompIceFrac(      &
   296  !!$    & xy_FlagLand, xy_SurfMajCompIce, & ! (in )
   297      & xy_SurfMajCompIce,              & ! (in )
   298      & xy_MajCompIceFrac               & ! (out)
   299      )
   300  
   301      ! 格子点設定
   302      ! Grid points settings
   303      !
   304      use gridset, only: imax, & ! 経度格子点数.
   305                                 ! Number of grid points in longitude
   306        &                jmax, & ! 緯度格子点数.
   307                                 ! Number of grid points in latitude
   308        &                kmax    ! 鉛直層数.
   309                                 ! Number of vertical level
   310  
   311      ! 雪と海氷の定数の設定
   312      ! Setting constants of snow and sea ice
   313      !
   314      use constants_snowseaice, only:            &
   315        & CO2IceThreshold
   316  
   317  
   318  !!$    logical , intent(in ) :: xy_FlagLand      ( 0:imax-1, 1:jmax )
   319      real(DP), intent(in ) :: xy_SurfMajCompIce( 0:imax-1, 1:jmax )
   320      real(DP), intent(out) :: xy_MajCompIceFrac( 0:imax-1, 1:jmax )
   321  
   322  
   323      ! 作業変数
   324      ! Work variables
   325      !
   326      real(DP):: MajCompIceThreshold
   327      integer:: i               ! 経度方向に回る DO ループ用作業変数
   328                                ! Work variables for DO loop in longitude
   329      integer:: j               ! 緯度方向に回る DO ループ用作業変数
   330                                ! Work variables for DO loop in latitude
   331  
   332      ! 初期化確認
   333      ! Initialization check
   334      !
   335      if ( .not. snowice_frac_inited ) then
   336        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   337      end if
   338  
   339  
   340  
   341      MajCompIceThreshold = CO2IceThreshold
   342      do j = 1, jmax
   343        do i = 0, imax-1
   344  
   345  !!$        if ( xy_FlagLand(i,j) ) then
   346            xy_MajCompIceFrac(i,j) =                  &
   347              &   ( xy_SurfMajCompIce(i,j) - 0.0_DP ) &
   348              & / ( MajCompIceThreshold    - 0.0_DP )
   349            xy_MajCompIceFrac(i,j) = max( min( xy_MajCompIceFrac(i,j), 1.0_DP ), 0.0_DP )
   350  !!$        else
   351  !!$          xy_MajCompIceFrac(i,j) = 0.0_DP
   352  !!$        end if
   353  
   354        end do
   355      end do
     .        d2 = 1.D0/(majcompicethreshold - 0.0000000000000000e+000)         
     .  !cdir nodep                                                             
     .  !cdir noassume                                                          
     .        do j = 1, jmax*imax                                               
     .           xy_majcompicefrac1 = (xy_surfmajcompice(j-1,1)-                
     .       1      0.0000000000000000e+000)*d2                                 
     .           xy_majcompicefrac(j-1,1) = max(min(xy_majcompicefrac1,         
     .       1      1.00000000000000e+000),0.0000000000000000e+000)             
     .        enddo                                                             
   356  
   357  
   358    end subroutine CalcMajCompIceFrac
   359  
   360    !--------------------------------------------------------------------------------------
   361  
   362    subroutine SnowIceFracInit
   363  
   364      ! モジュール引用 ; USE statements
   365      !
   366  
   367      ! 種別型パラメタ
   368      ! Kind type parameter
   369      !
   370      use dc_types, only: STDOUT ! 標準出力の装置番号. Unit number of standard output
   371  
   372      ! ファイル入出力補助
   373      ! File I/O support
   374      !
   375      use dc_iounit, only: FileOpen
   376  
   377      ! NAMELIST ファイル入力に関するユーティリティ
   378      ! Utilities for NAMELIST file input
   379      !
   380      use namelist_util, only: namelist_filename, NmlutilMsg
   381  
   382  
   383      ! 作業変数
   384      ! Work variables
   385      !
   386      integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号.
   387                                ! Unit number for NAMELIST file open
   388      integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT.
   389                                ! IOSTAT of NAMELIST read
   390  
   391  
   392      ! NAMELIST 変数群
   393      ! NAMELIST group name
   394      !
   395      namelist /snowice_frac_nml/ &
   396        & NOrd
   397  
   398      ! 実行文 ; Executable statement
   399      !
   400  
   401  
   402      if ( snowice_frac_inited ) return
   403  
   404  
   405      ! デフォルト値の設定
   406      ! Default values settings
   407      !
   408      NOrd = 2.0_DP
   409  
   410  
   411      ! NAMELIST の読み込み
   412      ! NAMELIST is input
   413      !
   414      if ( trim(namelist_filename) /= '' ) then
   415        call FileOpen( unit_nml, &          ! (out)
   416          & namelist_filename, mode = 'r' ) ! (in)
   417  
   418        rewind( unit_nml )
   419        read( unit_nml,                  &  ! (in)
   420          & nml = snowice_frac_nml,      &  ! (out)
   421          & iostat = iostat_nml          &  ! (out)
   422          & )
   423        close( unit_nml )
   424  
   425        call NmlutilMsg( iostat_nml, module_name ) ! (in)
   426        if ( iostat_nml == 0 ) write( STDOUT, nml = snowice_frac_nml )
   427      end if
   428  
   429      ! 印字 ; Print
   430      !
   431      call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   432      call MessageNotify( 'M', module_name, 'NOrd = %f', d = (/NOrd/) )
   433      call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   434  
   435  
   436      snowice_frac_inited = .true.
   437  
   438    end subroutine SnowIceFracInit
   439  
   440    !--------------------------------------------------------------------------------------
   441  
   442  end module snowice_frac
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:26 2016
FILE NAME: snowice_frac.f90
PROGRAM NAME: snowice_frac
FORMAT LIST

  LINE    LOOP      FORTRAN STATEMENT

     1:             != 雪, 氷の割合
     2:             !
     3:             != snow/ice fraction
     4:             !
     5:             ! Authors::   Yoshiyuki O. Takahashi
     6:             ! Version::   $Id: snowice_frac.f90,v 1.1 2015/01/29 12:12:21 yot Exp $
     7:             ! Tag Name::  $Name:  $
     8:             ! Copyright:: Copyright (C) GFD Dennou Club, 2008-2009. All rights reserved.
     9:             ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10:             !
    11:             
    12:             module snowice_frac
    13:             
    14:               ! モジュール引用 ; USE statements
    15:               !
    16:             
    17:               ! 種別型パラメタ
    18:               ! Kind type parameter
    19:               !
    20:               use dc_types, only: DP, &      ! 倍精度実数型. Double precision.
    21:                 &                 STRING     ! 文字列.       Strings.
    22:             
    23:               ! メッセージ出力
    24:               ! Message output
    25:               !
    26:               use dc_message, only: MessageNotify
    27:             
    28:               ! 格子点設定
    29:               ! Grid points settings
    30:             
    31:               ! 宣言文 ; Declaration statements
    32:               !
    33:               implicit none
    34:               private
    35:             
    36:               ! 公開手続き
    37:               ! Public procedure
    38:               !
    39:               public :: SeaIceAboveThreshold
    40:               public :: CalcSnowFrac
    41:               public :: CalcSfcLiqSolFrac
    42:               public :: CalcSeaIceFrac
    43:               public :: CalcMajCompIceFrac
    44:               public :: SnowIceFracInit
    45:             
    46:               ! 公開変数
    47:               ! Public variables
    48:               !
    49:             
    50:               ! 非公開変数
    51:               ! Private variables
    52:               !
    53:               real(DP), save :: NOrd
    54:             
    55:               logical, save :: snowice_frac_inited = .false.
    56:                                           ! 初期設定フラグ.
    57:                                           ! Initialization flag
    58:             
    59:               character(*), parameter:: module_name = 'snowice_frac'
    60:                                           ! モジュールの名称.
    61:                                           ! Module name
    62:               character(*), parameter:: version = &
    63:                 & '$Name:  $' // &
    64:                 & '$Id: snowice_frac.f90,v 1.1 2015/01/29 12:12:21 yot Exp $'
    65:                                           ! モジュールのバージョン
    66:                                           ! Module version
    67:             
    68:             contains
    69:             
    70:               !--------------------------------------------------------------------------------------
    71:             
    72:               function SeaIceAboveThreshold( SeaIceConc ) result( FlagExist )
    73:             
    74:                 ! 雪と海氷の定数の設定
    75:                 ! Setting constants of snow and sea ice
    76:                 !
    77:                 use constants_snowseaice, only: &
    78:                   & SeaIceThreshold
    79:             
    80:                 real(DP), intent(in) :: SeaIceConc
    81:             
    82:                 logical :: FlagExist
    83:             
    84:             
    85:                 if ( SeaIceConc > SeaIceThreshold ) then
    86:                   FlagExist = .true.
    87:                 else
    88:                   FlagExist = .false.
    89:                 end if
    90:             
    91:               end function SeaIceAboveThreshold
    92:             
    93:               !--------------------------------------------------------------------------------------
    94:             
    95:               subroutine CalcSnowFrac(       &
    96:             !!$    & xy_FlagLand, xy_SurfSnow,  & ! (in )
    97:                 & xy_SurfSnow,               & ! (in )
    98:                 & xy_SnowFrac                & ! (out)
    99:                 & )
   100:             
   101:                 ! 格子点設定
   102:                 ! Grid points settings
   103:                 !
   104:                 use gridset, only: imax, & ! 経度格子点数.
   105:                                            ! Number of grid points in longitude
   106:                   &                jmax, & ! 緯度格子点数.
   107:                                            ! Number of grid points in latitude
   108:                   &                kmax    ! 鉛直層数.
   109:                                            ! Number of vertical level
   110:             
   111:                 ! 雪と海氷の定数の設定
   112:                 ! Setting constants of snow and sea ice
   113:                 !
   114:                 use constants_snowseaice, only:            &
   115:                   & SnowThresholdForAlbedo
   116:             
   117:             !!$    logical , intent(in ) :: xy_FlagLand( 0:imax-1, 1:jmax )
   118:                 real(DP), intent(in ) :: xy_SurfSnow( 0:imax-1, 1:jmax )
   119:                 real(DP), intent(out) :: xy_SnowFrac( 0:imax-1, 1:jmax )
   120:             
   121:             
   122:                 ! 作業変数
   123:                 ! Work variables
   124:                 !
   125:                 integer:: i               ! 経度方向に回る DO ループ用作業変数
   126:                                           ! Work variables for DO loop in longitude
   127:                 integer:: j               ! 緯度方向に回る DO ループ用作業変数
   128:                                           ! Work variables for DO loop in latitude
   129:             
   130:                 ! 初期化確認
   131:                 ! Initialization check
   132:                 !
   133:                 if ( .not. snowice_frac_inited ) then
   134:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   135:                 end if
   136:             
   137:             
   138:                 if ( SnowThresholdForAlbedo > 0.0_DP ) then
   139: W------>          do j = 1, jmax
   140: |*----->            do i = 0, imax-1
   141: ||          
   142: ||      A             xy_SnowFrac(i,j) = &
   143: ||                      & ( ( xy_SurfSnow(i,j) - 0.0_DP ) / ( SnowThresholdForAlbedo - 0.0_DP ) )**NOrd
   144: ||      A             xy_SnowFrac(i,j) = max( min( xy_SnowFrac(i,j), 1.0_DP ), 0.0_DP )
   145: ||          
   146: ||          !!$        if ( xy_FlagLand(i,j) ) then
   147: ||          !!$          xy_SnowFrac(i,j) = &
   148: ||          !!$            & ( ( xy_SurfSnow(i,j) - 0.0_DP ) / ( SnowThresholdForAlbedo - 0.0_DP ) )**NOrd
   149: ||          !!$          xy_SnowFrac(i,j) = max( min( xy_SnowFrac(i,j), 1.0_DP ), 0.0_DP )
   150: ||          !!$        else
   151: ||          !!$          xy_SnowFrac(i,j) = 0.0_DP
   152: ||          !!$        end if
   153: ||          
   154: |*-----             end do
   155: W------           end do
   156:                 else
   157: W*===== A         xy_SnowFrac = 1.0_DP
   158:                 end if
   159:             
   160:             
   161:               end subroutine CalcSnowFrac
   162:             
   163:               !--------------------------------------------------------------------------------------
   164:             
   165:               subroutine CalcSfcLiqSolFrac(       &
   166:             !!$    & xy_FlagLand, xy_SurfSnow,  & ! (in )
   167:                 & xy_SurfSnow,               & ! (in )
   168:                 & xy_SnowFrac                & ! (out)
   169:                 & )
   170:             
   171:                 ! 格子点設定
   172:                 ! Grid points settings
   173:                 !
   174:                 use gridset, only: imax, & ! 経度格子点数.
   175:                                            ! Number of grid points in longitude
   176:                   &                jmax, & ! 緯度格子点数.
   177:                                            ! Number of grid points in latitude
   178:                   &                kmax    ! 鉛直層数.
   179:                                            ! Number of vertical level
   180:             
   181:                 ! 雪と海氷の定数の設定
   182:                 ! Setting constants of snow and sea ice
   183:                 !
   184:                 use constants_snowseaice, only:            &
   185:                   & SnowThresholdForFlux
   186:             
   187:             !!$    logical , intent(in ) :: xy_FlagLand( 0:imax-1, 1:jmax )
   188:                 real(DP), intent(in ) :: xy_SurfSnow( 0:imax-1, 1:jmax )
   189:                 real(DP), intent(out) :: xy_SnowFrac( 0:imax-1, 1:jmax )
   190:             
   191:             
   192:                 ! 作業変数
   193:                 ! Work variables
   194:                 !
   195:                 integer:: i               ! 経度方向に回る DO ループ用作業変数
   196:                                           ! Work variables for DO loop in longitude
   197:                 integer:: j               ! 緯度方向に回る DO ループ用作業変数
   198:                                           ! Work variables for DO loop in latitude
   199:             
   200:                 ! 初期化確認
   201:                 ! Initialization check
   202:                 !
   203:                 if ( .not. snowice_frac_inited ) then
   204:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   205:                 end if
   206:             
   207:             
   208:                 if ( SnowThresholdForFlux > 0.0_DP ) then
   209: W------>          do j = 1, jmax
   210: |*----->            do i = 0, imax-1
   211: ||          
   212: ||          !!$        if ( xy_FlagLand(i,j) ) then
   213: ||      A             xy_SnowFrac(i,j) = &
   214: ||                      & ( ( xy_SurfSnow(i,j) - 0.0_DP ) / ( SnowThresholdForFlux - 0.0_DP ) )**NOrd
   215: ||      A             xy_SnowFrac(i,j) = max( min( xy_SnowFrac(i,j), 1.0_DP ), 0.0_DP )
   216: ||          !!$        else
   217: ||          !!$          xy_SnowFrac(i,j) = 0.0_DP
   218: ||          !!$        end if
   219: ||          
   220: |*-----             end do
   221: W------           end do
   222:             
   223:                 else
   224: W*===== A         xy_SnowFrac = 1.0_DP
   225:                 end if
   226:             
   227:             
   228:               end subroutine CalcSfcLiqSolFrac
   229:             
   230:               !--------------------------------------------------------------------------------------
   231:             
   232:               subroutine CalcSeaIceFrac(       &
   233:             !!$    & xy_FlagOcean, xy_SeaIceConc, & ! (in )
   234:                 & xy_SeaIceConc,               & ! (in )
   235:                 & xy_SeaIceFrac                & ! (out)
   236:                 & )
   237:             
   238:                 ! 格子点設定
   239:                 ! Grid points settings
   240:                 !
   241:                 use gridset, only: imax, & ! 経度格子点数.
   242:                                            ! Number of grid points in longitude
   243:                   &                jmax, & ! 緯度格子点数.
   244:                                            ! Number of grid points in latitude
   245:                   &                kmax    ! 鉛直層数.
   246:                                            ! Number of vertical level
   247:             
   248:                 ! 雪と海氷の定数の設定
   249:                 ! Setting constants of snow and sea ice
   250:                 !
   251:                 use constants_snowseaice, only:  &
   252:                   & SeaIceThreshold
   253:             
   254:             
   255:             !!$    logical , intent(in ) :: xy_FlagOcean ( 0:imax-1, 1:jmax )
   256:                 real(DP), intent(in ) :: xy_SeaIceConc( 0:imax-1, 1:jmax )
   257:                 real(DP), intent(out) :: xy_SeaIceFrac( 0:imax-1, 1:jmax )
   258:             
   259:             
   260:                 ! 作業変数
   261:                 ! Work variables
   262:                 !
   263:                 integer:: i               ! 経度方向に回る DO ループ用作業変数
   264:                                           ! Work variables for DO loop in longitude
   265:                 integer:: j               ! 緯度方向に回る DO ループ用作業変数
   266:                                           ! Work variables for DO loop in latitude
   267:             
   268:                 ! 初期化確認
   269:                 ! Initialization check
   270:                 !
   271:                 if ( .not. snowice_frac_inited ) then
   272:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   273:                 end if
   274:             
   275:             
   276: W------>        do j = 1, jmax
   277: |*----->          do i = 0, imax-1
   278: ||          
   279: ||          !!$        if ( ( xy_FlagOcean(i,j) ) .and. &
   280: ||          !!$          &  ( xy_SeaIceConc(i,j) > SeaIceThreshold ) ) then
   281: ||      A           if ( xy_SeaIceConc(i,j) > SeaIceThreshold ) then
   282: ||                    xy_SeaIceFrac(i,j) = 1.0_DP
   283: ||                  else
   284: ||                    xy_SeaIceFrac(i,j) = 0.0_DP
   285: ||                  end if
   286: ||          
   287: |*----- A         end do
   288: W------         end do
   289:             
   290:             
   291:               end subroutine CalcSeaIceFrac
   292:             
   293:               !--------------------------------------------------------------------------------------
   294:             
   295:               subroutine CalcMajCompIceFrac(      &
   296:             !!$    & xy_FlagLand, xy_SurfMajCompIce, & ! (in )
   297:                 & xy_SurfMajCompIce,              & ! (in )
   298:                 & xy_MajCompIceFrac               & ! (out)
   299:                 )
   300:             
   301:                 ! 格子点設定
   302:                 ! Grid points settings
   303:                 !
   304:                 use gridset, only: imax, & ! 経度格子点数.
   305:                                            ! Number of grid points in longitude
   306:                   &                jmax, & ! 緯度格子点数.
   307:                                            ! Number of grid points in latitude
   308:                   &                kmax    ! 鉛直層数.
   309:                                            ! Number of vertical level
   310:             
   311:                 ! 雪と海氷の定数の設定
   312:                 ! Setting constants of snow and sea ice
   313:                 !
   314:                 use constants_snowseaice, only:            &
   315:                   & CO2IceThreshold
   316:             
   317:             
   318:             !!$    logical , intent(in ) :: xy_FlagLand      ( 0:imax-1, 1:jmax )
   319:                 real(DP), intent(in ) :: xy_SurfMajCompIce( 0:imax-1, 1:jmax )
   320:                 real(DP), intent(out) :: xy_MajCompIceFrac( 0:imax-1, 1:jmax )
   321:             
   322:             
   323:                 ! 作業変数
   324:                 ! Work variables
   325:                 !
   326:                 real(DP):: MajCompIceThreshold
   327:                 integer:: i               ! 経度方向に回る DO ループ用作業変数
   328:                                           ! Work variables for DO loop in longitude
   329:                 integer:: j               ! 緯度方向に回る DO ループ用作業変数
   330:                                           ! Work variables for DO loop in latitude
   331:             
   332:                 ! 初期化確認
   333:                 ! Initialization check
   334:                 !
   335:                 if ( .not. snowice_frac_inited ) then
   336:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   337:                 end if
   338:             
   339:             
   340:             
   341:                 MajCompIceThreshold = CO2IceThreshold
   342: W------>        do j = 1, jmax
   343: |*----->          do i = 0, imax-1
   344: ||          
   345: ||          !!$        if ( xy_FlagLand(i,j) ) then
   346: ||      A             xy_MajCompIceFrac(i,j) =                  &
   347: ||                      &   ( xy_SurfMajCompIce(i,j) - 0.0_DP ) &
   348: ||                      & / ( MajCompIceThreshold    - 0.0_DP )
   349: ||      A             xy_MajCompIceFrac(i,j) = max( min( xy_MajCompIceFrac(i,j), 1.0_DP ), 0.0_DP )
   350: ||          !!$        else
   351: ||          !!$          xy_MajCompIceFrac(i,j) = 0.0_DP
   352: ||          !!$        end if
   353: ||          
   354: |*-----           end do
   355: W------         end do
   356:             
   357:             
   358:               end subroutine CalcMajCompIceFrac
   359:             
   360:               !--------------------------------------------------------------------------------------
   361:             
   362:               subroutine SnowIceFracInit
   363:             
   364:                 ! モジュール引用 ; USE statements
   365:                 !
   366:             
   367:                 ! 種別型パラメタ
   368:                 ! Kind type parameter
   369:                 !
   370:                 use dc_types, only: STDOUT ! 標準出力の装置番号. Unit number of standard output
   371:             
   372:                 ! ファイル入出力補助
   373:                 ! File I/O support
   374:                 !
   375:                 use dc_iounit, only: FileOpen
   376:             
   377:                 ! NAMELIST ファイル入力に関するユーティリティ
   378:                 ! Utilities for NAMELIST file input
   379:                 !
   380:                 use namelist_util, only: namelist_filename, NmlutilMsg
   381:             
   382:             
   383:                 ! 作業変数
   384:                 ! Work variables
   385:                 !
   386:                 integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号.
   387:                                           ! Unit number for NAMELIST file open
   388:                 integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT.
   389:                                           ! IOSTAT of NAMELIST read
   390:             
   391:             
   392:                 ! NAMELIST 変数群
   393:                 ! NAMELIST group name
   394:                 !
   395:                 namelist /snowice_frac_nml/ &
   396:                   & NOrd
   397:             
   398:                 ! 実行文 ; Executable statement
   399:                 !
   400:             
   401:             
   402:                 if ( snowice_frac_inited ) return
   403:             
   404:             
   405:                 ! デフォルト値の設定
   406:                 ! Default values settings
   407:                 !
   408:                 NOrd = 2.0_DP
   409:             
   410:             
   411:                 ! NAMELIST の読み込み
   412:                 ! NAMELIST is input
   413:                 !
   414:                 if ( trim(namelist_filename) /= '' ) then
   415:                   call FileOpen( unit_nml, &          ! (out)
   416:                     & namelist_filename, mode = 'r' ) ! (in)
   417:             
   418:                   rewind( unit_nml )
   419:                   read( unit_nml,                  &  ! (in)
   420:                     & nml = snowice_frac_nml,      &  ! (out)
   421:                     & iostat = iostat_nml          &  ! (out)
   422:                     & )
   423:                   close( unit_nml )
   424:             
   425:                   call NmlutilMsg( iostat_nml, module_name ) ! (in)
   426:                   if ( iostat_nml == 0 ) write( STDOUT, nml = snowice_frac_nml )
   427:                 end if
   428:             
   429:                 ! 印字 ; Print
   430:                 !
   431:                 call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   432:                 call MessageNotify( 'M', module_name, 'NOrd = %f', d = (/NOrd/) )
   433:                 call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   434:             
   435:             
   436:                 snowice_frac_inited = .true.
   437:             
   438:               end subroutine SnowIceFracInit
   439:             
   440:               !--------------------------------------------------------------------------------------
   441:             
   442:             end module snowice_frac
