Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:22 2016
FILE NAME: composition.f90
PROGRAM NAME: composition
DIAGNOSTIC LIST

  LINE  LEVEL( NO.): DIAGNOSTIC MESSAGE

   158  vec  (   3): Unvectorized loop.
   159  opt  (1017): Subroutine call prevents optimization.
   159  vec  (   9): Vectorization obstructive statement.
   392  vec  (   3): Unvectorized loop.
   392  vec  (  13): Overhead of loop division is too large.
   393  opt  (1017): Subroutine call prevents optimization.
   393  vec  (  18): Unvectorizable data type.
   394  vec  (  18): Unvectorizable data type.
   397  opt  (  11): Fused array assignments. :line 397 - 401
   397  vec  (   4): Vectorized array expression.
   397  vec  (  29): ADB is used for array.: flagvdiff
   397  vec  (  29): ADB is used for array.: flagadv
   397  vec  (  29): ADB is used for array.: flagmassfix
   443  vec  (   3): Unvectorized loop.
   443  vec  (  13): Overhead of loop division is too large.
   444  vec  (  18): Unvectorizable data type.
   445  opt  (1017): Subroutine call prevents optimization.
   445  vec  (  17): Unvectorizable statement.
   447  vec  (  18): Unvectorizable data type.
   449  vec  (  18): Unvectorizable data type.
   450  vec  (  18): Unvectorizable data type.
   452  vec  (  18): Unvectorizable data type.
   454  vec  (  22): Dependency unknown. Unvectorizable dependency is assumed.:n
   457  vec  (   1): Vectorized loop.
   457  vec  (  24): Iteration count is assumed. Iteration count=256
   457  vec  (  29): ADB is used for array.: a_flagmassfix
   457  vec  (  29): ADB is used for array.: flagmassfix
   462  vec  (   1): Vectorized loop.
   462  vec  (  24): Iteration count is assumed. Iteration count=256
   462  vec  (  29): ADB is used for array.: a_flagadv
   462  vec  (  29): ADB is used for array.: flagadv
   467  vec  (   1): Vectorized loop.
   467  vec  (  24): Iteration count is assumed. Iteration count=256
   467  vec  (  29): ADB is used for array.: a_flagvdiff
   467  vec  (  29): ADB is used for array.: flagvdiff
   472  vec  (   3): Unvectorized loop.
   473  vec  (  18): Unvectorizable data type.
   474  opt  (1084): Branch out of the loop inhibits optimization.
   490  vec  (   3): Unvectorized loop.
   491  vec  (  18): Unvectorizable data type.
   492  opt  (1084): Branch out of the loop inhibits optimization.
   497  vec  (   3): Unvectorized loop.
   498  vec  (  18): Unvectorizable data type.
   499  opt  (1084): Branch out of the loop inhibits optimization.
   504  vec  (   3): Unvectorized loop.
   505  vec  (  18): Unvectorizable data type.
   506  opt  (1084): Branch out of the loop inhibits optimization.
   515  vec  (   3): Unvectorized loop.
   516  opt  (1017): Subroutine call prevents optimization.
   516  vec  (   9): Vectorization obstructive statement.
   516  vec  (  10): Vectorization obstructive procedure reference.:messagenotifyc
   518  vec  (   3): Unvectorized loop.
   519  opt  (1017): Subroutine call prevents optimization.
   519  vec  (   9): Vectorization obstructive statement.
   519  vec  (  10): Vectorization obstructive procedure reference.:messagenotifyc
   521  vec  (   3): Unvectorized loop.
   522  opt  (1017): Subroutine call prevents optimization.
   522  vec  (  10): Vectorization obstructive procedure reference.:messagenotifyc
   524  vec  (   3): Unvectorized loop.
   525  opt  (1017): Subroutine call prevents optimization.
   525  vec  (  10): Vectorization obstructive procedure reference.:messagenotifyc
   527  vec  (   3): Unvectorized loop.
   528  opt  (1017): Subroutine call prevents optimization.
   528  vec  (  10): Vectorization obstructive procedure reference.:messagenotifyc
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:22 2016
FILE NAME: composition.f90
PROGRAM NAME: composition
TRANSFORMATION LIST

  LINE                   FORTRAN STATEMENT

     1  != 組成に関わる配列の設定
     2  !
     3  != Settings of array for atmospheric composition
     4  !
     5  ! Authors::   Yoshiyuki O. Takahashi
     6  ! Version::   $Id: composition.f90,v 1.6 2012/09/08 15:25:53 yot Exp $
     7  ! Tag Name::  $Name:  $
     8  ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9  ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10  !
    11  
    12  module composition
    13    !
    14    != 組成に関わる配列の設定
    15    !
    16    != Settings of array for atmospheric composition
    17    !
    18    ! <b>Note that Japanese and English are described in parallel.</b>
    19    !
    20    ! 組成に関わる配列の設定
    21    !
    22    ! Settings of array for atmospheric composition
    23    !
    24    !== Variables List
    25    !
    26    ! ncmax        :: 微量成分の数
    27    ! ------------ :: ------------
    28    ! ncmax        :: Number of minor comstituents
    29    !
    30    !== Procedures List
    31    !
    32    ! CompositionInit :: 組成に関わる配列の設定
    33    ! --------------  :: ------------
    34    ! CompositionInit :: Settings of parameters for array for composition
    35    !
    36    !
    37    !== NAMELIST
    38    !
    39    ! NAMELIST#composition_nml
    40    !
    41  
    42    ! モジュール引用 ; USE statements
    43    !
    44  
    45    ! 種別型パラメタ
    46    ! Kind type parameter
    47    !
    48    use dc_types, only: DP,     & ! 倍精度実数型. Double precision.
    49                        STRING    ! 文字列. Strings.
    50  
    51    ! 宣言文 ; Declaration statements
    52    !
    53    implicit none
    54    private
    55  
    56    ! 公開手続き
    57    ! Public procedure
    58    !
    59    public :: CompositionInqIndex
    60    public :: CompositionInqFlagMassFix
    61    public :: CompositionInqFlagAdv
    62    public :: CompositionInqFlagVDiff
    63    public :: CompositionInit
    64  
    65    ! 公開変数
    66    ! Public variables
    67    !
    68    logical          , save, public             :: composition_inited = .false.
    69                                ! 初期設定フラグ.
    70                                ! Initialization flag
    71  
    72    integer          , save, public             :: ncmax
    73                                ! 成分の数
    74                                ! Number of composition
    75    character(STRING), save, public, allocatable:: a_QMixName(:)
    76                                ! 成分の変数名
    77                                ! Name of variables for composition
    78    character(STRING), save, public, allocatable:: a_QMixLongName(:)
    79                                ! 成分の長い変数名
    80                                ! Long name of variables for composition
    81    logical          , save,         allocatable:: a_FlagMassFix(:)
    82                                ! 質量保存補正のフラグ
    83                                ! Flag for mass fix
    84    logical          , save,         allocatable:: a_FlagAdv(:)
    85                                ! 成分の移流計算のフラグ
    86                                ! Flag for advection calculation
    87    logical          , save,         allocatable:: a_FlagVDiff(:)
    88                                ! 鉛直混合の移流計算のフラグ
    89                                ! Flag for vertical diffusion
    90  
    91    character(STRING), parameter                :: NameH2OVap = "QH2OVap"
    92    character(STRING), parameter                :: NameH2OLiq = "QH2OLiq"
    93    character(STRING), parameter                :: NameH2OSol = "QH2OSol"
    94    character(STRING), parameter                :: NameTKE    = "TKE"
    95  
    96    integer          , save, public             :: IndexH2OVap
    97                                ! 水蒸気のインデックス
    98                                ! Index for water vapor
    99    integer          , save, public             :: IndexH2OLiq
   100    integer          , save, public             :: IndexH2OSol
   101    integer          , save, public             :: IndexTKE
   102  
   103    ! 非公開変数
   104    ! Private variables
   105    !
   106    character(*), parameter:: module_name = 'composition'
   107                                ! モジュールの名称.
   108                                ! Module name
   109    character(*), parameter:: version = &
   110      & '$Name:  $' // &
   111      & '$Id: composition.f90,v 1.6 2012/09/08 15:25:53 yot Exp $'
   112                                ! モジュールのバージョン
   113                                ! Module version
   114  
   115  contains
   116  
   117    !-------------------------------------------------------------------
   118  
   119    function CompositionInqIndex( Name ) result( Index )
   120      !
   121      ! Name で与えられた名前の成分のインデクスを返しします.
   122      !
   123      ! Inquiry of index of constituent
   124      !
   125  
   126      ! モジュール引用 ; USE statements
   127      !
   128  
   129      ! メッセージ出力
   130      ! Message output
   131      !
   132      use dc_message, only: MessageNotify
   133  
   134      ! 宣言文 ; Declaration statements
   135      !
   136      implicit none
   137  
   138      character(len=*), intent(in ) :: Name
   139  
   140      integer:: Index
   141  
   142      integer:: n               ! 組成方向に回る DO ループ用作業変数
   143                                ! Work variables for DO loop in dimension of constituents
   144  
   145      ! 実行文 ; Executable statement
   146      !
   147  
   148      ! 初期化
   149      ! Initialization
   150      !
   151      if ( .not. composition_inited ) then
   152        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   153      end if
   154  
   155  
   156      Index = -1
   157  
   158      do n = 1, ncmax
   159        if ( a_QMixName(n) == trim( Name ) ) then
   160          Index = n
   161          exit
   162        end if
   163      end do
   164  
   165  !!$    if ( Index == -1 ) then
   166  !!$      call MessageNotify( 'E', module_name, &
   167  !!$        & 'Cannot find %c in a list of constituents.', c1 = trim( Name ) )
   168  !!$    end if
   169  
   170  
   171    end function CompositionInqIndex
   172  
   173    !-------------------------------------------------------------------
   174  
   175    function CompositionInqFlagMassFix( Index ) result( FlagMassFix )
   176      !
   177      ! Name で与えられた名前の成分の移流フラグを返しします.
   178      !
   179      ! Inquiry of flag for advection of constituent
   180      !
   181  
   182      ! モジュール引用 ; USE statements
   183      !
   184  
   185      ! メッセージ出力
   186      ! Message output
   187      !
   188      use dc_message, only: MessageNotify
   189  
   190      ! 宣言文 ; Declaration statements
   191      !
   192      implicit none
   193  
   194      integer, intent(in ) :: Index
   195  
   196      logical :: FlagMassFix
   197  
   198  
   199      ! 実行文 ; Executable statement
   200      !
   201  
   202      ! 初期化
   203      ! Initialization
   204      !
   205      if ( .not. composition_inited ) then
   206        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   207      end if
   208  
   209  
   210      if ( ( Index < 1 ) .or. ( Index > ncmax ) ) then
   211        call MessageNotify( 'E', module_name, &
   212          & 'Index is inappropriate, Index = %d', i = (/ Index /) )
   213      end if
   214  
   215      FlagMassFix = a_FlagMassFix( Index )
   216  
   217  
   218    end function CompositionInqFlagMassFix
   219  
   220    !-------------------------------------------------------------------
   221  
   222    function CompositionInqFlagAdv( Index ) result( FlagAdv )
   223      !
   224      ! Name で与えられた名前の成分の移流フラグを返します.
   225      !
   226      ! Inquiry of flag for advection of constituent
   227      !
   228  
   229      ! モジュール引用 ; USE statements
   230      !
   231  
   232      ! メッセージ出力
   233      ! Message output
   234      !
   235      use dc_message, only: MessageNotify
   236  
   237      ! 宣言文 ; Declaration statements
   238      !
   239      implicit none
   240  
   241      integer, intent(in ) :: Index
   242  
   243      logical :: FlagAdv
   244  
   245  
   246      ! 実行文 ; Executable statement
   247      !
   248  
   249      ! 初期化
   250      ! Initialization
   251      !
   252      if ( .not. composition_inited ) then
   253        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   254      end if
   255  
   256  
   257      if ( ( Index < 1 ) .or. ( Index > ncmax ) ) then
   258        call MessageNotify( 'E', module_name, &
   259          & 'Index is inappropriate, Index = %d', i = (/ Index /) )
   260      end if
   261  
   262      FlagAdv = a_FlagAdv( Index )
   263  
   264  
   265    end function CompositionInqFlagAdv
   266  
   267    !-------------------------------------------------------------------
   268  
   269    function CompositionInqFlagVDiff( Index ) result( FlagVDiff )
   270      !
   271      ! Name で与えられた名前の成分の移流フラグを返しします.
   272      !
   273      ! Inquiry of flag for advection of constituent
   274      !
   275  
   276      ! モジュール引用 ; USE statements
   277      !
   278  
   279      ! メッセージ出力
   280      ! Message output
   281      !
   282      use dc_message, only: MessageNotify
   283  
   284      ! 宣言文 ; Declaration statements
   285      !
   286      implicit none
   287  
   288      integer, intent(in ) :: Index
   289  
   290      logical :: FlagVDiff
   291  
   292  
   293      ! 実行文 ; Executable statement
   294      !
   295  
   296      ! 初期化
   297      ! Initialization
   298      !
   299      if ( .not. composition_inited ) then
   300        call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   301      end if
   302  
   303  
   304      if ( ( Index < 1 ) .or. ( Index > ncmax ) ) then
   305        call MessageNotify( 'E', module_name, &
   306          & 'Index is inappropriate, Index = %d', i = (/ Index /) )
   307      end if
   308  
   309      FlagVDiff = a_FlagVDiff( Index )
   310  
   311  
   312    end function CompositionInqFlagVDiff
   313  
   314    !-------------------------------------------------------------------
   315  
   316    subroutine CompositionInit
   317      !
   318      ! composition モジュールの初期化を行います.
   319      ! NAMELIST#composition_nml の読み込みはこの手続きで行われます.
   320      !
   321      ! "composition" module is initialized.
   322      ! NAMELIST#composition_nml is loaded in this procedure.
   323      !
   324  
   325      ! モジュール引用 ; USE statements
   326      !
   327  
   328      ! NAMELIST ファイル入力に関するユーティリティ
   329      ! Utilities for NAMELIST file input
   330      !
   331      use namelist_util, only: namelist_filename, NmlutilMsg, MaxNmlArySize
   332  
   333      ! ファイル入出力補助
   334      ! File I/O support
   335      !
   336      use dc_iounit, only: FileOpen
   337  
   338      ! 種別型パラメタ
   339      ! Kind type parameter
   340      !
   341      use dc_types, only: STDOUT ! 標準出力の装置番号. Unit number of standard output
   342  
   343      ! メッセージ出力
   344      ! Message output
   345      !
   346      use dc_message, only: MessageNotify
   347  
   348      ! 宣言文 ; Declaration statements
   349      !
   350      implicit none
   351  
   352      integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号.
   353                                ! Unit number for NAMELIST file open
   354      integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT.
   355                                ! IOSTAT of NAMELIST read
   356  
   357      character(len=STRING) :: Names      (1:MaxNmlArySize)
   358      character(len=STRING) :: LongNames  (1:MaxNmlArySize)
   359      logical               :: FlagMassFix(1:MaxNmlArySize)
   360      logical               :: FlagAdv    (1:MaxNmlArySize)
   361      logical               :: FlagVDiff  (1:MaxNmlArySize)
   362  
   363      integer:: n               ! 組成方向に回る DO ループ用作業変数
   364                                ! Work variables for DO loop in dimension of constituents
   365  
   366      ! NAMELIST 変数群
   367      ! NAMELIST group name
   368      !
   369      namelist /composition_nml/ &
   370        & ncmax, Names, LongNames, FlagMassFix, FlagAdv, FlagVDiff
   371            !
   372            ! デフォルト値については初期化手続 "composition#CompositionInit"
   373            ! のソースコードを参照のこと.
   374            !
   375            ! Refer to source codes in the initialization procedure
   376            ! "composition#CompositionInit" for the default values.
   377            !
   378  
   379      ! 実行文 ; Executable statement
   380      !
   381  
   382      if ( composition_inited ) return
   383  !!$    call InitCheck
   384  
   385      ! デフォルト値の設定
   386      ! Default values settings
   387      !
   388      ncmax        = 1
   389  
   390      Names    (1) = NameH2OVap
   391      LongNames(1) = 'specific humidity'
   392      do n = 2, MaxNmlArySize
   393        Names    (n) = ''
   394        LongNames(n) = ''
   395      end do
   396  
   397      FlagMassFix = .true.
     .  !cdir nodep                                                             
     .  !cdir on_adb(flagmassfix,flagadv,flagvdiff)                             
     .        do t496 = 0, 255                                                  
   398  
   399      FlagAdv     = .true.
   400  
   401      FlagVDiff   = .true.
   402  
   403  
   404      ! NAMELIST の読み込み
   405      ! NAMELIST is input
   406      !
   407      if ( trim(namelist_filename) /= '' ) then
   408        call FileOpen( unit_nml, &          ! (out)
   409          & namelist_filename, mode = 'r' ) ! (in)
   410  
   411        rewind( unit_nml )
   412        read( unit_nml,            & ! (in)
   413          & nml = composition_nml, & ! (out)
   414          & iostat = iostat_nml    & ! (out)
   415          & )
   416        close( unit_nml )
   417  
   418        call NmlutilMsg( iostat_nml, module_name ) ! (in)
   419        if ( iostat_nml == 0 ) write( STDOUT, nml = composition_nml )
   420      end if
   421  
   422      ! 配列サイズのチェック
   423      ! Check number of array size
   424      !
   425      if ( ncmax < 1 ) then
   426        call MessageNotify( 'E', module_name, &
   427          & 'number of composition has to be greater than 0. ' // &
   428          & 'ncmax=%d' , &
   429          & i = (/ ncmax /) )
   430      end if
   431  
   432  
   433      ! Set variable name of constituents for ouptut
   434      !
   435      allocate( a_QMixName    ( ncmax ) )
   436      allocate( a_QMixLongName( ncmax ) )
   437      if ( ncmax > 99 ) then
   438        call MessageNotify( 'E', module_name, &
   439          & 'number of composition greater than 99 is inappropriate for current version. ' // &
   440          & 'ncmax=%d' , &
   441          & i = (/ ncmax /) )
   442      end if
   443      do n = 1, ncmax
   444        if ( Names(n) == '' ) then
   445          write( a_QMixName(n), '(a,i3.3)' ) "QMix", n
   446        else
   447          a_QMixName(n) = Names(n)
   448        end if
   449        if ( LongNames(n) == '' ) then
   450          a_QMixLongName(n) = a_QMixName(n)
   451        else
   452          a_QMixLongName(n) = LongNames(n)
   453        end if
   454      end do
   455  
   456      allocate( a_FlagMassFix( ncmax ) )
   457      do n = 1, ncmax
     .  !cdir    nodep                                                          
     .  !cdir on_adb(flagmassfix)                                               
     .        do n = 1, ncmax                                                   
   458        a_FlagMassFix( n ) = FlagMassFix(n)
   459      end do
   460  
   461      allocate( a_FlagAdv( ncmax ) )
   462      do n = 1, ncmax
     .  !cdir    nodep                                                          
     .  !cdir on_adb(flagadv)                                                   
     .        do n = 1, ncmax                                                   
   463        a_FlagAdv( n ) = FlagAdv(n)
   464      end do
   465  
   466      allocate( a_FlagVDiff( ncmax ) )
   467      do n = 1, ncmax
     .  !cdir    nodep                                                          
     .  !cdir on_adb(flagvdiff)                                                 
     .        do n = 1, ncmax                                                   
   468        a_FlagVDiff( n ) = FlagVDiff(n)
   469      end do
   470  
   471      IndexH2OVap = -1
   472      do n = 1, ncmax
   473        if ( a_QMixName(n) == NameH2OVap ) then
   474          IndexH2OVap = n
   475          exit
   476        end if
   477      end do
   478      !
   479      ! 水蒸気のインデックスのチェック
   480      ! Check index for water vapor
   481      !
   482      if ( ( IndexH2OVap < 1 ) .or. ( IndexH2OVap > ncmax ) ) then
   483        call MessageNotify( 'E', module_name, &
   484          & 'IndexH2OVap has to be greater than or equal to 1 and less than or equal to ncmax. ' // &
   485          & 'IndexH2OVap=%d' , &
   486          & i = (/ IndexH2OVap /) )
   487      end if
   488  
   489      IndexH2OLiq = -1
   490      do n = 1, ncmax
   491        if ( a_QMixName(n) == NameH2OLiq ) then
   492          IndexH2OLiq = n
   493          exit
   494        end if
   495      end do
   496      IndexH2OSol = -1
   497      do n = 1, ncmax
   498        if ( a_QMixName(n) == NameH2OSol ) then
   499          IndexH2OSol = n
   500          exit
   501        end if
   502      end do
   503      IndexTKE = -1
   504      do n = 1, ncmax
   505        if ( a_QMixName(n) == NameTKE ) then
   506          IndexTKE = n
   507          exit
   508        end if
   509      end do
   510  
   511      ! 印字 ; Print
   512      !
   513      call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   514      call MessageNotify( 'M', module_name, '    ncmax              = %d', i = (/ ncmax /) )
   515      do n = 1, ncmax
   516        call MessageNotify( 'M', module_name, '    QMixName(%d)     = %c', i = (/ n /), c1 = trim(a_QMixName(n)) )
   517      end do
   518      do n = 1, ncmax
   519        call MessageNotify( 'M', module_name, '    QMixLongName(%d) = %c', i = (/ n /), c1 = trim(a_QMixLongName(n)) )
   520      end do
   521      do n = 1, ncmax
   522        call MessageNotify( 'M', module_name, '    FlagMassFix(%d)  = %b', i = (/ n /), l = (/ a_FlagMassFix(n) /) )
   523      end do
   524      do n = 1, ncmax
   525        call MessageNotify( 'M', module_name, '    FlagAdv(%d)      = %b', i = (/ n /), l = (/ a_FlagAdv(n) /) )
   526      end do
   527      do n = 1, ncmax
   528        call MessageNotify( 'M', module_name, '    FlagVDiff(%d)    = %b', i = (/ n /), l = (/ a_FlagVDiff(n) /) )
   529      end do
   530      call MessageNotify( 'M', module_name, '    IndexH2OVap        = %d', i = (/ IndexH2OVap /) )
   531      call MessageNotify( 'M', module_name, '    IndexH2OLiq        = %d', i = (/ IndexH2OLiq /) )
   532      call MessageNotify( 'M', module_name, '    IndexH2OSol        = %d', i = (/ IndexH2OSol /) )
   533      call MessageNotify( 'M', module_name, '    IndexTKE           = %d', i = (/ IndexTKE    /) )
   534      call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   535  
   536      composition_inited = .true.
   537    end subroutine CompositionInit
   538  
   539    !-------------------------------------------------------------------
   540  
   541  !!$  subroutine InitCheck
   542  !!$    !
   543  !!$    ! 依存モジュールの初期化チェック
   544  !!$    !
   545  !!$    ! Check initialization of dependency modules
   546  !!$
   547  !!$    ! モジュール引用 ; USE statements
   548  !!$    !
   549  !!$
   550  !!$    ! NAMELIST ファイル入力に関するユーティリティ
   551  !!$    ! Utilities for NAMELIST file input
   552  !!$    !
   553  !!$    use namelist_util, only: namelist_util_inited
   554  !!$
   555  !!$    ! メッセージ出力
   556  !!$    ! Message output
   557  !!$    !
   558  !!$    use dc_message, only: MessageNotify
   559  !!$
   560  !!$    ! 実行文 ; Executable statement
   561  !!$    !
   562  !!$
   563  !!$    if ( .not. namelist_util_inited ) &
   564  !!$      & call MessageNotify( 'E', module_name, '"namelist_util" module is not initialized.' )
   565  !!$
   566  !!$  end subroutine InitCheck
   567  
   568  end module composition
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:22 2016
FILE NAME: composition.f90
PROGRAM NAME: composition
FORMAT LIST

  LINE    LOOP      FORTRAN STATEMENT

     1:             != 組成に関わる配列の設定
     2:             !
     3:             != Settings of array for atmospheric composition
     4:             !
     5:             ! Authors::   Yoshiyuki O. Takahashi
     6:             ! Version::   $Id: composition.f90,v 1.6 2012/09/08 15:25:53 yot Exp $ 
     7:             ! Tag Name::  $Name:  $
     8:             ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9:             ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10:             !
    11:             
    12:             module composition
    13:               !
    14:               != 組成に関わる配列の設定
    15:               !
    16:               != Settings of array for atmospheric composition
    17:               !
    18:               ! <b>Note that Japanese and English are described in parallel.</b>
    19:               !
    20:               ! 組成に関わる配列の設定
    21:               !
    22:               ! Settings of array for atmospheric composition
    23:               !
    24:               !== Variables List
    25:               !
    26:               ! ncmax        :: 微量成分の数
    27:               ! ------------ :: ------------
    28:               ! ncmax        :: Number of minor comstituents
    29:               !
    30:               !== Procedures List
    31:               !
    32:               ! CompositionInit :: 組成に関わる配列の設定
    33:               ! --------------  :: ------------
    34:               ! CompositionInit :: Settings of parameters for array for composition
    35:               !
    36:               !
    37:               !== NAMELIST
    38:               !
    39:               ! NAMELIST#composition_nml
    40:               !
    41:             
    42:               ! モジュール引用 ; USE statements
    43:               !
    44:             
    45:               ! 種別型パラメタ
    46:               ! Kind type parameter
    47:               !
    48:               use dc_types, only: DP,     & ! 倍精度実数型. Double precision. 
    49:                                   STRING    ! 文字列. Strings.
    50:             
    51:               ! 宣言文 ; Declaration statements
    52:               !
    53:               implicit none
    54:               private
    55:             
    56:               ! 公開手続き
    57:               ! Public procedure
    58:               !
    59:               public :: CompositionInqIndex
    60:               public :: CompositionInqFlagMassFix
    61:               public :: CompositionInqFlagAdv
    62:               public :: CompositionInqFlagVDiff
    63:               public :: CompositionInit
    64:             
    65:               ! 公開変数
    66:               ! Public variables
    67:               !
    68:               logical          , save, public             :: composition_inited = .false.
    69:                                           ! 初期設定フラグ. 
    70:                                           ! Initialization flag
    71:             
    72:               integer          , save, public             :: ncmax
    73:                                           ! 成分の数
    74:                                           ! Number of composition
    75:               character(STRING), save, public, allocatable:: a_QMixName(:)
    76:                                           ! 成分の変数名
    77:                                           ! Name of variables for composition
    78:               character(STRING), save, public, allocatable:: a_QMixLongName(:)
    79:                                           ! 成分の長い変数名
    80:                                           ! Long name of variables for composition
    81:               logical          , save,         allocatable:: a_FlagMassFix(:)
    82:                                           ! 質量保存補正のフラグ
    83:                                           ! Flag for mass fix
    84:               logical          , save,         allocatable:: a_FlagAdv(:)
    85:                                           ! 成分の移流計算のフラグ
    86:                                           ! Flag for advection calculation
    87:               logical          , save,         allocatable:: a_FlagVDiff(:)
    88:                                           ! 鉛直混合の移流計算のフラグ
    89:                                           ! Flag for vertical diffusion
    90:             
    91:               character(STRING), parameter                :: NameH2OVap = "QH2OVap"
    92:               character(STRING), parameter                :: NameH2OLiq = "QH2OLiq"
    93:               character(STRING), parameter                :: NameH2OSol = "QH2OSol"
    94:               character(STRING), parameter                :: NameTKE    = "TKE"
    95:             
    96:               integer          , save, public             :: IndexH2OVap
    97:                                           ! 水蒸気のインデックス
    98:                                           ! Index for water vapor
    99:               integer          , save, public             :: IndexH2OLiq
   100:               integer          , save, public             :: IndexH2OSol
   101:               integer          , save, public             :: IndexTKE
   102:             
   103:               ! 非公開変数
   104:               ! Private variables
   105:               !
   106:               character(*), parameter:: module_name = 'composition'
   107:                                           ! モジュールの名称. 
   108:                                           ! Module name
   109:               character(*), parameter:: version = &
   110:                 & '$Name:  $' // &
   111:                 & '$Id: composition.f90,v 1.6 2012/09/08 15:25:53 yot Exp $'
   112:                                           ! モジュールのバージョン
   113:                                           ! Module version
   114:             
   115:             contains
   116:             
   117:               !-------------------------------------------------------------------
   118:             
   119:               function CompositionInqIndex( Name ) result( Index )
   120:                 !
   121:                 ! Name で与えられた名前の成分のインデクスを返しします. 
   122:                 !
   123:                 ! Inquiry of index of constituent
   124:                 !
   125:             
   126:                 ! モジュール引用 ; USE statements
   127:                 !
   128:             
   129:                 ! メッセージ出力
   130:                 ! Message output
   131:                 !
   132:                 use dc_message, only: MessageNotify
   133:             
   134:                 ! 宣言文 ; Declaration statements
   135:                 !
   136:                 implicit none
   137:             
   138:                 character(len=*), intent(in ) :: Name
   139:             
   140:                 integer:: Index
   141:             
   142:                 integer:: n               ! 組成方向に回る DO ループ用作業変数
   143:                                           ! Work variables for DO loop in dimension of constituents
   144:             
   145:                 ! 実行文 ; Executable statement
   146:                 !
   147:             
   148:                 ! 初期化
   149:                 ! Initialization
   150:                 !
   151:                 if ( .not. composition_inited ) then
   152:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   153:                 end if
   154:             
   155:             
   156:                 Index = -1
   157:             
   158: +------>        do n = 1, ncmax
   159: |                 if ( a_QMixName(n) == trim( Name ) ) then
   160: |                   Index = n
   161: |                   exit
   162: |                 end if
   163: +------         end do
   164:             
   165:             !!$    if ( Index == -1 ) then
   166:             !!$      call MessageNotify( 'E', module_name, &
   167:             !!$        & 'Cannot find %c in a list of constituents.', c1 = trim( Name ) )
   168:             !!$    end if
   169:             
   170:             
   171:               end function CompositionInqIndex
   172:             
   173:               !-------------------------------------------------------------------
   174:             
   175:               function CompositionInqFlagMassFix( Index ) result( FlagMassFix )
   176:                 !
   177:                 ! Name で与えられた名前の成分の移流フラグを返しします.
   178:                 !
   179:                 ! Inquiry of flag for advection of constituent
   180:                 !
   181:             
   182:                 ! モジュール引用 ; USE statements
   183:                 !
   184:             
   185:                 ! メッセージ出力
   186:                 ! Message output
   187:                 !
   188:                 use dc_message, only: MessageNotify
   189:             
   190:                 ! 宣言文 ; Declaration statements
   191:                 !
   192:                 implicit none
   193:             
   194:                 integer, intent(in ) :: Index
   195:             
   196:                 logical :: FlagMassFix
   197:             
   198:             
   199:                 ! 実行文 ; Executable statement
   200:                 !
   201:             
   202:                 ! 初期化
   203:                 ! Initialization
   204:                 !
   205:                 if ( .not. composition_inited ) then
   206:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   207:                 end if
   208:             
   209:             
   210:                 if ( ( Index < 1 ) .or. ( Index > ncmax ) ) then
   211:                   call MessageNotify( 'E', module_name, &
   212:                     & 'Index is inappropriate, Index = %d', i = (/ Index /) )
   213:                 end if
   214:             
   215:                 FlagMassFix = a_FlagMassFix( Index )
   216:             
   217:             
   218:               end function CompositionInqFlagMassFix
   219:             
   220:               !-------------------------------------------------------------------
   221:             
   222:               function CompositionInqFlagAdv( Index ) result( FlagAdv )
   223:                 !
   224:                 ! Name で与えられた名前の成分の移流フラグを返します. 
   225:                 !
   226:                 ! Inquiry of flag for advection of constituent
   227:                 !
   228:             
   229:                 ! モジュール引用 ; USE statements
   230:                 !
   231:             
   232:                 ! メッセージ出力
   233:                 ! Message output
   234:                 !
   235:                 use dc_message, only: MessageNotify
   236:             
   237:                 ! 宣言文 ; Declaration statements
   238:                 !
   239:                 implicit none
   240:             
   241:                 integer, intent(in ) :: Index
   242:             
   243:                 logical :: FlagAdv
   244:             
   245:             
   246:                 ! 実行文 ; Executable statement
   247:                 !
   248:             
   249:                 ! 初期化
   250:                 ! Initialization
   251:                 !
   252:                 if ( .not. composition_inited ) then
   253:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   254:                 end if
   255:             
   256:             
   257:                 if ( ( Index < 1 ) .or. ( Index > ncmax ) ) then
   258:                   call MessageNotify( 'E', module_name, &
   259:                     & 'Index is inappropriate, Index = %d', i = (/ Index /) )
   260:                 end if
   261:             
   262:                 FlagAdv = a_FlagAdv( Index )
   263:             
   264:             
   265:               end function CompositionInqFlagAdv
   266:             
   267:               !-------------------------------------------------------------------
   268:             
   269:               function CompositionInqFlagVDiff( Index ) result( FlagVDiff )
   270:                 !
   271:                 ! Name で与えられた名前の成分の移流フラグを返しします.
   272:                 !
   273:                 ! Inquiry of flag for advection of constituent
   274:                 !
   275:             
   276:                 ! モジュール引用 ; USE statements
   277:                 !
   278:             
   279:                 ! メッセージ出力
   280:                 ! Message output
   281:                 !
   282:                 use dc_message, only: MessageNotify
   283:             
   284:                 ! 宣言文 ; Declaration statements
   285:                 !
   286:                 implicit none
   287:             
   288:                 integer, intent(in ) :: Index
   289:             
   290:                 logical :: FlagVDiff
   291:             
   292:             
   293:                 ! 実行文 ; Executable statement
   294:                 !
   295:             
   296:                 ! 初期化
   297:                 ! Initialization
   298:                 !
   299:                 if ( .not. composition_inited ) then
   300:                   call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
   301:                 end if
   302:             
   303:             
   304:                 if ( ( Index < 1 ) .or. ( Index > ncmax ) ) then
   305:                   call MessageNotify( 'E', module_name, &
   306:                     & 'Index is inappropriate, Index = %d', i = (/ Index /) )
   307:                 end if
   308:             
   309:                 FlagVDiff = a_FlagVDiff( Index )
   310:             
   311:             
   312:               end function CompositionInqFlagVDiff
   313:             
   314:               !-------------------------------------------------------------------
   315:             
   316:               subroutine CompositionInit
   317:                 !
   318:                 ! composition モジュールの初期化を行います. 
   319:                 ! NAMELIST#composition_nml の読み込みはこの手続きで行われます. 
   320:                 !
   321:                 ! "composition" module is initialized. 
   322:                 ! NAMELIST#composition_nml is loaded in this procedure. 
   323:                 !
   324:             
   325:                 ! モジュール引用 ; USE statements
   326:                 !
   327:             
   328:                 ! NAMELIST ファイル入力に関するユーティリティ
   329:                 ! Utilities for NAMELIST file input
   330:                 !
   331:                 use namelist_util, only: namelist_filename, NmlutilMsg, MaxNmlArySize
   332:             
   333:                 ! ファイル入出力補助
   334:                 ! File I/O support
   335:                 !
   336:                 use dc_iounit, only: FileOpen
   337:             
   338:                 ! 種別型パラメタ
   339:                 ! Kind type parameter
   340:                 !
   341:                 use dc_types, only: STDOUT ! 標準出力の装置番号. Unit number of standard output
   342:             
   343:                 ! メッセージ出力
   344:                 ! Message output
   345:                 !
   346:                 use dc_message, only: MessageNotify
   347:             
   348:                 ! 宣言文 ; Declaration statements
   349:                 !
   350:                 implicit none
   351:             
   352:                 integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号. 
   353:                                           ! Unit number for NAMELIST file open
   354:                 integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT. 
   355:                                           ! IOSTAT of NAMELIST read
   356:             
   357:                 character(len=STRING) :: Names      (1:MaxNmlArySize)
   358:                 character(len=STRING) :: LongNames  (1:MaxNmlArySize)
   359:                 logical               :: FlagMassFix(1:MaxNmlArySize)
   360:                 logical               :: FlagAdv    (1:MaxNmlArySize)
   361:                 logical               :: FlagVDiff  (1:MaxNmlArySize)
   362:             
   363:                 integer:: n               ! 組成方向に回る DO ループ用作業変数
   364:                                           ! Work variables for DO loop in dimension of constituents
   365:             
   366:                 ! NAMELIST 変数群
   367:                 ! NAMELIST group name
   368:                 !
   369:                 namelist /composition_nml/ &
   370:                   & ncmax, Names, LongNames, FlagMassFix, FlagAdv, FlagVDiff
   371:                       !
   372:                       ! デフォルト値については初期化手続 "composition#CompositionInit" 
   373:                       ! のソースコードを参照のこと. 
   374:                       !
   375:                       ! Refer to source codes in the initialization procedure
   376:                       ! "composition#CompositionInit" for the default values. 
   377:                       !
   378:             
   379:                 ! 実行文 ; Executable statement
   380:                 !
   381:             
   382:                 if ( composition_inited ) return
   383:             !!$    call InitCheck
   384:             
   385:                 ! デフォルト値の設定
   386:                 ! Default values settings
   387:                 !
   388:                 ncmax        = 1
   389:             
   390:                 Names    (1) = NameH2OVap
   391:                 LongNames(1) = 'specific humidity'
   392: +------>        do n = 2, MaxNmlArySize
   393: |                 Names    (n) = ''
   394: |                 LongNames(n) = ''
   395: +------         end do
   396:             
   397: V------>A       FlagMassFix = .true.
   398: |           
   399: |       A       FlagAdv     = .true.
   400: |           
   401: V------ A       FlagVDiff   = .true.
   402:             
   403:             
   404:                 ! NAMELIST の読み込み
   405:                 ! NAMELIST is input
   406:                 !
   407:                 if ( trim(namelist_filename) /= '' ) then
   408:                   call FileOpen( unit_nml, &          ! (out)
   409:                     & namelist_filename, mode = 'r' ) ! (in)
   410:             
   411:                   rewind( unit_nml )
   412:                   read( unit_nml,            & ! (in)
   413:                     & nml = composition_nml, & ! (out)
   414:                     & iostat = iostat_nml    & ! (out)
   415:                     & )
   416:                   close( unit_nml )
   417:             
   418:                   call NmlutilMsg( iostat_nml, module_name ) ! (in)
   419:                   if ( iostat_nml == 0 ) write( STDOUT, nml = composition_nml )
   420:                 end if
   421:             
   422:                 ! 配列サイズのチェック
   423:                 ! Check number of array size
   424:                 !
   425:                 if ( ncmax < 1 ) then
   426:                   call MessageNotify( 'E', module_name, &
   427:                     & 'number of composition has to be greater than 0. ' // &
   428:                     & 'ncmax=%d' , &
   429:                     & i = (/ ncmax /) )
   430:                 end if
   431:             
   432:             
   433:                 ! Set variable name of constituents for ouptut
   434:                 !
   435:                 allocate( a_QMixName    ( ncmax ) )
   436:                 allocate( a_QMixLongName( ncmax ) )
   437:                 if ( ncmax > 99 ) then
   438:                   call MessageNotify( 'E', module_name, &
   439:                     & 'number of composition greater than 99 is inappropriate for current version. ' // &
   440:                     & 'ncmax=%d' , &
   441:                     & i = (/ ncmax /) )
   442:                 end if
   443: +------>        do n = 1, ncmax
   444: |                 if ( Names(n) == '' ) then
   445: |                   write( a_QMixName(n), '(a,i3.3)' ) "QMix", n
   446: |                 else
   447: |                   a_QMixName(n) = Names(n)
   448: |                 end if
   449: |                 if ( LongNames(n) == '' ) then
   450: |                   a_QMixLongName(n) = a_QMixName(n)
   451: |                 else
   452: |                   a_QMixLongName(n) = LongNames(n)
   453: |                 end if
   454: +------         end do
   455:             
   456:                 allocate( a_FlagMassFix( ncmax ) )
   457: V------>        do n = 1, ncmax
   458: |       A         a_FlagMassFix( n ) = FlagMassFix(n)
   459: V------         end do
   460:             
   461:                 allocate( a_FlagAdv( ncmax ) )
   462: V------>        do n = 1, ncmax
   463: |       A         a_FlagAdv( n ) = FlagAdv(n)
   464: V------         end do
   465:             
   466:                 allocate( a_FlagVDiff( ncmax ) )
   467: V------>        do n = 1, ncmax
   468: |       A         a_FlagVDiff( n ) = FlagVDiff(n)
   469: V------         end do
   470:             
   471:                 IndexH2OVap = -1
   472: +------>        do n = 1, ncmax
   473: |                 if ( a_QMixName(n) == NameH2OVap ) then
   474: |                   IndexH2OVap = n
   475: |                   exit
   476: |                 end if
   477: +------         end do
   478:                 !
   479:                 ! 水蒸気のインデックスのチェック
   480:                 ! Check index for water vapor
   481:                 !
   482:                 if ( ( IndexH2OVap < 1 ) .or. ( IndexH2OVap > ncmax ) ) then
   483:                   call MessageNotify( 'E', module_name, &
   484:                     & 'IndexH2OVap has to be greater than or equal to 1 and less than or equal to ncmax. ' // &
   485:                     & 'IndexH2OVap=%d' , &
   486:                     & i = (/ IndexH2OVap /) )
   487:                 end if
   488:             
   489:                 IndexH2OLiq = -1
   490: +------>        do n = 1, ncmax
   491: |                 if ( a_QMixName(n) == NameH2OLiq ) then
   492: |                   IndexH2OLiq = n
   493: |                   exit
   494: |                 end if
   495: +------         end do
   496:                 IndexH2OSol = -1
   497: +------>        do n = 1, ncmax
   498: |                 if ( a_QMixName(n) == NameH2OSol ) then
   499: |                   IndexH2OSol = n
   500: |                   exit
   501: |                 end if
   502: +------         end do
   503:                 IndexTKE = -1
   504: +------>        do n = 1, ncmax
   505: |                 if ( a_QMixName(n) == NameTKE ) then
   506: |                   IndexTKE = n
   507: |                   exit
   508: |                 end if
   509: +------         end do
   510:             
   511:                 ! 印字 ; Print
   512:                 !
   513:                 call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   514:                 call MessageNotify( 'M', module_name, '    ncmax              = %d', i = (/ ncmax /) )
   515: +------>        do n = 1, ncmax
   516: |                 call MessageNotify( 'M', module_name, '    QMixName(%d)     = %c', i = (/ n /), c1 = trim(a_QMixName(n)) )
   517: +------         end do
   518: +------>        do n = 1, ncmax
   519: |                 call MessageNotify( 'M', module_name, '    QMixLongName(%d) = %c', i = (/ n /), c1 = trim(a_QMixLongName(n)) )
   520: +------         end do
   521: +------>        do n = 1, ncmax
   522: |                 call MessageNotify( 'M', module_name, '    FlagMassFix(%d)  = %b', i = (/ n /), l = (/ a_FlagMassFix(n) /) )
   523: +------         end do
   524: +------>        do n = 1, ncmax
   525: |                 call MessageNotify( 'M', module_name, '    FlagAdv(%d)      = %b', i = (/ n /), l = (/ a_FlagAdv(n) /) )
   526: +------         end do
   527: +------>        do n = 1, ncmax
   528: |                 call MessageNotify( 'M', module_name, '    FlagVDiff(%d)    = %b', i = (/ n /), l = (/ a_FlagVDiff(n) /) )
   529: +------         end do
   530:                 call MessageNotify( 'M', module_name, '    IndexH2OVap        = %d', i = (/ IndexH2OVap /) )
   531:                 call MessageNotify( 'M', module_name, '    IndexH2OLiq        = %d', i = (/ IndexH2OLiq /) )
   532:                 call MessageNotify( 'M', module_name, '    IndexH2OSol        = %d', i = (/ IndexH2OSol /) )
   533:                 call MessageNotify( 'M', module_name, '    IndexTKE           = %d', i = (/ IndexTKE    /) )
   534:                 call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   535:             
   536:                 composition_inited = .true.
   537:               end subroutine CompositionInit
   538:             
   539:               !-------------------------------------------------------------------
   540:             
   541:             !!$  subroutine InitCheck
   542:             !!$    !
   543:             !!$    ! 依存モジュールの初期化チェック
   544:             !!$    !
   545:             !!$    ! Check initialization of dependency modules
   546:             !!$
   547:             !!$    ! モジュール引用 ; USE statements
   548:             !!$    !
   549:             !!$
   550:             !!$    ! NAMELIST ファイル入力に関するユーティリティ
   551:             !!$    ! Utilities for NAMELIST file input
   552:             !!$    !
   553:             !!$    use namelist_util, only: namelist_util_inited
   554:             !!$
   555:             !!$    ! メッセージ出力
   556:             !!$    ! Message output
   557:             !!$    !
   558:             !!$    use dc_message, only: MessageNotify
   559:             !!$
   560:             !!$    ! 実行文 ; Executable statement
   561:             !!$    !
   562:             !!$
   563:             !!$    if ( .not. namelist_util_inited ) &
   564:             !!$      & call MessageNotify( 'E', module_name, '"namelist_util" module is not initialized.' )
   565:             !!$
   566:             !!$  end subroutine InitCheck
   567:             
   568:             end module composition
