Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:22 2016
FILE NAME: constants.f90
PROGRAM NAME: constants
TRANSFORMATION LIST

  LINE                   FORTRAN STATEMENT

     1  != 物理定数設定
     2  !
     3  != Physical constants settings
     4  !
     5  ! Authors::   Yasuhiro MORIKAWA
     6  ! Version::   $Id: constants.f90,v 1.11 2014/05/07 09:39:21 murashin Exp $
     7  ! Tag Name::  $Name:  $
     8  ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9  ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10  !
    11  
    12  module constants
    13    !
    14    != 物理定数設定
    15    !
    16    != Physical constants settings
    17    !
    18    ! <b>Note that Japanese and English are described in parallel.</b>
    19    !
    20    ! 物理定数の設定および保管を行います.
    21    ! デフォルト値は地球大気を想定した値が設定されています.
    22    ! これらの値は NAMELIST 変数群 constants_nml によって変更することが
    23    ! 可能です.
    24    !
    25    ! Physical constants are set and stored.
    26    ! By default, values on atmosphere of earth are set.
    27    ! These values can be changed by NAMELIST group name
    28    ! "constants_nml".
    29    !
    30    !== References
    31    !
    32    ! WMO technical regulations, No. 49, Vol. I General Meteorological
    33    ! Standards and Recommended Practices,
    34    ! http://www.wmo.int/pages/prog/www/WIS/Publications/49%20%28Technical%20Regulations%29/49%20-%20Volume%20I/49_I_E.pdf#page=61
    35    !
    36    !== Procedures List
    37    !
    38    ! ConstantsInit :: 物理定数の設定
    39    ! ------------  :: ------------
    40    ! ConstantsInit :: Settings of physical constants
    41    !
    42    !== NAMELIST
    43    !
    44    ! NAMELIST#constants_nml
    45    !
    46  
    47  
    48    ! モジュール引用 ; USE statements
    49    !
    50  
    51    ! 種別型パラメタ
    52    ! Kind type parameter
    53    !
    54    use dc_types, only: DP     ! 倍精度実数型. Double precision.
    55  
    56    ! 宣言文 ; Declaration statements
    57    !
    58    implicit none
    59    private
    60  
    61    ! 公開手続き
    62    ! Public procedure
    63    !
    64    public:: ConstantsInit
    65  
    66    ! 公開変数
    67    ! Public variables
    68    !
    69    logical, save :: constants_inited = .false.
    70                                ! 初期設定フラグ.
    71                                ! Initialization flag
    72  
    73    real(DP), save, public:: RPlanet
    74                                ! $ a $ [m].
    75                                ! 惑星半径.
    76                                ! Radius of planet
    77    real(DP), save, public:: Omega
    78                                ! $ \Omega $ [s-1].
    79                                ! 回転角速度.
    80                                ! Angular velocity
    81    real(DP), save, public:: Grav
    82                                ! $ g $ [m s-2].
    83                                ! 重力加速度.
    84                                ! Gravitational acceleration
    85    real(DP), save, public:: MolWtDry
    86                                ! $ M $ [kg mol-1].
    87                                ! 乾燥大気の平均分子量.
    88                                ! Mean molecular weight of dry air
    89    real(DP), save, public:: CpDry
    90                                ! $ C_p $ [J kg-1 K-1].
    91                                ! 乾燥大気の定圧比熱.
    92                                ! Specific heat of air at constant pressure
    93    real(DP), save, public:: MolWtWet
    94                                ! $ M_v $ [kg mol-1].
    95                                ! 凝結成分の平均分子量.
    96                                ! Mean molecular weight of condensible elements
    97    real(DP), save, public:: CpWet
    98                                ! $ C_v $ [J kg-1 K-1] .
    99                                ! 凝結成分の定圧比熱.
   100                                ! Specific heat of condensible elements at constant pressure
   101    real(DP), save, public:: LatentHeat
   102                                ! $ L $ [J kg-1] .
   103                                ! 凝結の潜熱.
   104                                ! Latent heat of condensation
   105    real(DP), save, public:: LatentHeatFusion
   106                                ! $ L $ [J kg-1] .
   107                                ! 融解の潜熱.
   108                                ! Latent heat of fusion
   109  
   110    real(DP), save, public:: GasRDry
   111                                ! $ R $ [J kg-1 K-1].
   112                                ! 乾燥大気の気体定数.
   113                                ! Gas constant of air
   114    real(DP), save, public:: GasRWet
   115                                ! $ R_v $ [J kg-1 K-1].
   116                                ! 凝結成分の気体定数.
   117                                ! Gas constant of condensible elements
   118    ! EpsV will be removed.
   119    real(DP), save, public:: EpsV
   120                                ! $ \epsilon_v $ .
   121                                ! 水蒸気分子量比.
   122                                ! Molecular weight of water vapor
   123  
   124    real(DP), parameter, public:: FKarm = 0.4_DP
   125                                ! $ k $ .
   126                                ! カルマン定数.
   127                                ! Karman constant
   128  
   129    real(DP), save, public:: SOMass
   130                                ! Slab ocean mass (kg m-2)
   131  
   132  
   133    ! 非公開変数
   134    ! Private variables
   135    !
   136  
   137    character(*), parameter:: module_name = 'constants'
   138                                ! モジュールの名称.
   139                                ! Module name
   140    character(*), parameter:: version = &
   141      & '$Name:  $' // &
   142      & '$Id: constants.f90,v 1.11 2014/05/07 09:39:21 murashin Exp $'
   143                                ! モジュールのバージョン
   144                                ! Module version
   145  
   146  contains
   147  
   148    !--------------------------------------------------------------------------------------
   149  
   150    subroutine ConstantsInit
   151      !
   152      ! constants モジュールの初期化を行います.
   153      ! NAMELIST#constants_nml の読み込みはこの手続きで行われます.
   154      !
   155      ! "constants" module is initialized.
   156      ! NAMELIST#constants_nml is loaded in this procedure.
   157      !
   158  
   159      ! モジュール引用 ; USE statements
   160      !
   161  
   162      ! NAMELIST ファイル入力に関するユーティリティ
   163      ! Utilities for NAMELIST file input
   164      !
   165      use namelist_util, only: namelist_filename, NmlutilMsg
   166  
   167      ! ファイル入出力補助
   168      ! File I/O support
   169      !
   170      use dc_iounit, only: FileOpen
   171  
   172      ! 種別型パラメタ
   173      ! Kind type parameter
   174      !
   175      use dc_types, only: STDOUT ! 標準出力の装置番号. Unit number of standard output
   176  
   177      ! メッセージ出力
   178      ! Message output
   179      !
   180      use dc_message, only: MessageNotify
   181  
   182      ! 物理・数学定数設定
   183      ! Physical and mathematical constants settings
   184      !
   185      use constants0, only: &
   186        & PI,               &
   187        & GasRUniv
   188  
   189      ! 宣言文 ; Declaration statements
   190      !
   191      implicit none
   192  
   193      integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号.
   194                                ! Unit number for NAMELIST file open
   195      integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT.
   196                                ! IOSTAT of NAMELIST read
   197  
   198      ! NAMELIST 変数群
   199      ! NAMELIST group name
   200      !
   201      namelist /constants_nml/ &
   202        & RPlanet, Omega, Grav, &
   203        & MolWtDry, CpDry, &
   204        & MolWtWet, CpWet, &
   205        & LatentHeat, LatentHeatFusion, &
   206        & SOMass
   207            !
   208            ! デフォルト値については初期化手続 "constants#ConstantsInit"
   209            ! のソースコードを参照のこと.
   210            !
   211            ! Refer to source codes in the initialization procedure
   212            ! "constants#ConstantsInit" for the default values.
   213            !
   214  
   215      ! 実行文 ; Executable statement
   216      !
   217  
   218      if ( constants_inited ) return
   219  
   220      ! デフォルト値の設定
   221      ! Default values settings
   222      !
   223      RPlanet          = 6.371e6_DP
   224      Omega            = 2.0_DP * PI / ( 60.0_DP * 60.0_DP * 23.9345_DP )
   225  
   226  !    Grav             = 9.8_DP    ! old value
   227      Grav             = 9.80665_DP
   228                         ! standard acceleration of gravity (m s-2)
   229                         ! WMO technical regulations (see above)
   230  
   231      CpDry            = 1004.6_DP
   232  
   233  !    MolWtDry         = 28.964e-3_DP    ! old value
   234      MolWtDry         = 28.9644e-3_DP
   235                         ! WMO technical regulations (see above)
   236  
   237      CpWet            = 1810.0_DP
   238  
   239  !    MolWtWet         = 18.01528e-3_DP    ! old value
   240      MolWtWet         = 18.0153e-3_DP
   241                         ! WMO technical regulations (see above)
   242  
   243      LatentHeat       = 2.5e6_DP
   244      LatentHeatFusion = 334.0e3_DP
   245  
   246      SOMass = 1.0e3_DP * 60.0_DP
   247                         ! 1.0d3 (kg m-3) * 60.0d0 (m)
   248  
   249  
   250      ! NAMELIST からの入力
   251      ! Input from NAMELIST
   252      !
   253      if ( trim(namelist_filename) /= '' ) then
   254        call FileOpen( unit_nml, &          ! (out)
   255          & namelist_filename, mode = 'r' ) ! (in)
   256  
   257        rewind( unit_nml )
   258        read( unit_nml, &           ! (in)
   259          & nml = constants_nml, &  ! (out)
   260          & iostat = iostat_nml )   ! (out)
   261        close( unit_nml )
   262  
   263        call NmlutilMsg( iostat_nml, module_name ) ! (in)
   264        if ( iostat_nml == 0 ) write( STDOUT, nml = constants_nml )
   265      end if
   266  
   267      GasRDry          = GasRUniv / MolWtDry
   268      GasRWet          = GasRUniv / MolWtWet
   269      EpsV             = MolWtWet / MolWtDry
   270  
   271  
   272      ! 印字 ; Print
   273      !
   274      call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   275      call MessageNotify( 'M', module_name, '  RPlanet          = %f', d = (/ RPlanet          /) )
   276      call MessageNotify( 'M', module_name, '  Omega            = %f', d = (/ Omega            /) )
   277      call MessageNotify( 'M', module_name, '  Grav             = %f', d = (/ Grav             /) )
   278  
   279      call MessageNotify( 'M', module_name, '  CpDry            = %f', d = (/ CpDry            /) )
   280      call MessageNotify( 'M', module_name, '  MolWtDry         = %f', d = (/ MolWtDry         /) )
   281  
   282      call MessageNotify( 'M', module_name, '  CpWet            = %f', d = (/ CpWet            /) )
   283      call MessageNotify( 'M', module_name, '  MolWtWet         = %f', d = (/ MolWtWet         /) )
   284      call MessageNotify( 'M', module_name, '  LatentHeat       = %f', d = (/ LatentHeat       /) )
   285      call MessageNotify( 'M', module_name, '  LatentHeatFusion = %f', d = (/ LatentHeatFusion /) )
   286  
   287      call MessageNotify( 'M', module_name, '  GasRDry          = %f', d = (/ GasRDry          /) )
   288      call MessageNotify( 'M', module_name, '  GasRWet          = %f', d = (/ GasRWet          /) )
   289      call MessageNotify( 'M', module_name, '  EpsV             = %f', d = (/ EpsV             /) )
   290      call MessageNotify( 'M', module_name, '  FKarm            = %f', d = (/ FKarm            /) )
   291      call MessageNotify( 'M', module_name, '  SOMass           = %f', d = (/ SOMass           /) )
   292      call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   293  
   294      constants_inited = .true.
   295  
   296    end subroutine ConstantsInit
   297  
   298    !--------------------------------------------------------------------------------------
   299  
   300  end module constants
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:22 2016
FILE NAME: constants.f90
PROGRAM NAME: constants
FORMAT LIST

  LINE    LOOP      FORTRAN STATEMENT

     1:             != 物理定数設定
     2:             !
     3:             != Physical constants settings
     4:             !
     5:             ! Authors::   Yasuhiro MORIKAWA
     6:             ! Version::   $Id: constants.f90,v 1.11 2014/05/07 09:39:21 murashin Exp $ 
     7:             ! Tag Name::  $Name:  $
     8:             ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9:             ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10:             !
    11:             
    12:             module constants
    13:               !
    14:               != 物理定数設定
    15:               !
    16:               != Physical constants settings
    17:               !
    18:               ! <b>Note that Japanese and English are described in parallel.</b>
    19:               !
    20:               ! 物理定数の設定および保管を行います. 
    21:               ! デフォルト値は地球大気を想定した値が設定されています. 
    22:               ! これらの値は NAMELIST 変数群 constants_nml によって変更することが
    23:               ! 可能です. 
    24:               !
    25:               ! Physical constants are set and stored. 
    26:               ! By default, values on atmosphere of earth are set. 
    27:               ! These values can be changed by NAMELIST group name 
    28:               ! "constants_nml". 
    29:               !
    30:               !== References
    31:               !
    32:               ! WMO technical regulations, No. 49, Vol. I General Meteorological 
    33:               ! Standards and Recommended Practices, 
    34:               ! http://www.wmo.int/pages/prog/www/WIS/Publications/49%20%28Technical%20Regulations%29/49%20-%20Volume%20I/49_I_E.pdf#page=61
    35:               !
    36:               !== Procedures List
    37:               !
    38:               ! ConstantsInit :: 物理定数の設定
    39:               ! ------------  :: ------------
    40:               ! ConstantsInit :: Settings of physical constants
    41:               !
    42:               !== NAMELIST
    43:               !
    44:               ! NAMELIST#constants_nml
    45:               !
    46:             
    47:             
    48:               ! モジュール引用 ; USE statements
    49:               !
    50:             
    51:               ! 種別型パラメタ
    52:               ! Kind type parameter
    53:               !
    54:               use dc_types, only: DP     ! 倍精度実数型. Double precision. 
    55:             
    56:               ! 宣言文 ; Declaration statements
    57:               !
    58:               implicit none
    59:               private
    60:             
    61:               ! 公開手続き
    62:               ! Public procedure
    63:               !
    64:               public:: ConstantsInit
    65:             
    66:               ! 公開変数
    67:               ! Public variables
    68:               !
    69:               logical, save :: constants_inited = .false.
    70:                                           ! 初期設定フラグ. 
    71:                                           ! Initialization flag
    72:             
    73:               real(DP), save, public:: RPlanet
    74:                                           ! $ a $ [m]. 
    75:                                           ! 惑星半径. 
    76:                                           ! Radius of planet
    77:               real(DP), save, public:: Omega
    78:                                           ! $ \Omega $ [s-1]. 
    79:                                           ! 回転角速度. 
    80:                                           ! Angular velocity
    81:               real(DP), save, public:: Grav
    82:                                           ! $ g $ [m s-2]. 
    83:                                           ! 重力加速度. 
    84:                                           ! Gravitational acceleration
    85:               real(DP), save, public:: MolWtDry
    86:                                           ! $ M $ [kg mol-1]. 
    87:                                           ! 乾燥大気の平均分子量. 
    88:                                           ! Mean molecular weight of dry air
    89:               real(DP), save, public:: CpDry
    90:                                           ! $ C_p $ [J kg-1 K-1]. 
    91:                                           ! 乾燥大気の定圧比熱. 
    92:                                           ! Specific heat of air at constant pressure
    93:               real(DP), save, public:: MolWtWet
    94:                                           ! $ M_v $ [kg mol-1]. 
    95:                                           ! 凝結成分の平均分子量. 
    96:                                           ! Mean molecular weight of condensible elements
    97:               real(DP), save, public:: CpWet
    98:                                           ! $ C_v $ [J kg-1 K-1] . 
    99:                                           ! 凝結成分の定圧比熱. 
   100:                                           ! Specific heat of condensible elements at constant pressure
   101:               real(DP), save, public:: LatentHeat
   102:                                           ! $ L $ [J kg-1] . 
   103:                                           ! 凝結の潜熱. 
   104:                                           ! Latent heat of condensation
   105:               real(DP), save, public:: LatentHeatFusion
   106:                                           ! $ L $ [J kg-1] . 
   107:                                           ! 融解の潜熱. 
   108:                                           ! Latent heat of fusion
   109:             
   110:               real(DP), save, public:: GasRDry
   111:                                           ! $ R $ [J kg-1 K-1]. 
   112:                                           ! 乾燥大気の気体定数. 
   113:                                           ! Gas constant of air
   114:               real(DP), save, public:: GasRWet
   115:                                           ! $ R_v $ [J kg-1 K-1]. 
   116:                                           ! 凝結成分の気体定数. 
   117:                                           ! Gas constant of condensible elements
   118:               ! EpsV will be removed. 
   119:               real(DP), save, public:: EpsV
   120:                                           ! $ \epsilon_v $ . 
   121:                                           ! 水蒸気分子量比. 
   122:                                           ! Molecular weight of water vapor
   123:             
   124:               real(DP), parameter, public:: FKarm = 0.4_DP
   125:                                           ! $ k $ .
   126:                                           ! カルマン定数. 
   127:                                           ! Karman constant
   128:             
   129:               real(DP), save, public:: SOMass
   130:                                           ! Slab ocean mass (kg m-2)
   131:             
   132:             
   133:               ! 非公開変数
   134:               ! Private variables
   135:               !
   136:             
   137:               character(*), parameter:: module_name = 'constants'
   138:                                           ! モジュールの名称. 
   139:                                           ! Module name
   140:               character(*), parameter:: version = &
   141:                 & '$Name:  $' // &
   142:                 & '$Id: constants.f90,v 1.11 2014/05/07 09:39:21 murashin Exp $'
   143:                                           ! モジュールのバージョン
   144:                                           ! Module version
   145:             
   146:             contains
   147:             
   148:               !--------------------------------------------------------------------------------------
   149:             
   150:               subroutine ConstantsInit
   151:                 !
   152:                 ! constants モジュールの初期化を行います. 
   153:                 ! NAMELIST#constants_nml の読み込みはこの手続きで行われます. 
   154:                 !
   155:                 ! "constants" module is initialized. 
   156:                 ! NAMELIST#constants_nml is loaded in this procedure. 
   157:                 !
   158:             
   159:                 ! モジュール引用 ; USE statements
   160:                 !
   161:             
   162:                 ! NAMELIST ファイル入力に関するユーティリティ
   163:                 ! Utilities for NAMELIST file input
   164:                 !
   165:                 use namelist_util, only: namelist_filename, NmlutilMsg
   166:             
   167:                 ! ファイル入出力補助
   168:                 ! File I/O support
   169:                 !
   170:                 use dc_iounit, only: FileOpen
   171:             
   172:                 ! 種別型パラメタ
   173:                 ! Kind type parameter
   174:                 !
   175:                 use dc_types, only: STDOUT ! 標準出力の装置番号. Unit number of standard output
   176:             
   177:                 ! メッセージ出力
   178:                 ! Message output
   179:                 !
   180:                 use dc_message, only: MessageNotify
   181:             
   182:                 ! 物理・数学定数設定
   183:                 ! Physical and mathematical constants settings
   184:                 !
   185:                 use constants0, only: &
   186:                   & PI,               &
   187:                   & GasRUniv
   188:             
   189:                 ! 宣言文 ; Declaration statements
   190:                 !
   191:                 implicit none
   192:             
   193:                 integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号. 
   194:                                           ! Unit number for NAMELIST file open
   195:                 integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT. 
   196:                                           ! IOSTAT of NAMELIST read
   197:             
   198:                 ! NAMELIST 変数群
   199:                 ! NAMELIST group name
   200:                 !
   201:                 namelist /constants_nml/ &
   202:                   & RPlanet, Omega, Grav, &
   203:                   & MolWtDry, CpDry, &
   204:                   & MolWtWet, CpWet, &
   205:                   & LatentHeat, LatentHeatFusion, &
   206:                   & SOMass
   207:                       !
   208:                       ! デフォルト値については初期化手続 "constants#ConstantsInit" 
   209:                       ! のソースコードを参照のこと. 
   210:                       !
   211:                       ! Refer to source codes in the initialization procedure
   212:                       ! "constants#ConstantsInit" for the default values. 
   213:                       !
   214:             
   215:                 ! 実行文 ; Executable statement
   216:                 !
   217:             
   218:                 if ( constants_inited ) return
   219:             
   220:                 ! デフォルト値の設定
   221:                 ! Default values settings
   222:                 !
   223:                 RPlanet          = 6.371e6_DP
   224:                 Omega            = 2.0_DP * PI / ( 60.0_DP * 60.0_DP * 23.9345_DP )
   225:             
   226:             !    Grav             = 9.8_DP    ! old value
   227:                 Grav             = 9.80665_DP
   228:                                    ! standard acceleration of gravity (m s-2)
   229:                                    ! WMO technical regulations (see above)
   230:             
   231:                 CpDry            = 1004.6_DP
   232:             
   233:             !    MolWtDry         = 28.964e-3_DP    ! old value
   234:                 MolWtDry         = 28.9644e-3_DP
   235:                                    ! WMO technical regulations (see above)
   236:             
   237:                 CpWet            = 1810.0_DP
   238:             
   239:             !    MolWtWet         = 18.01528e-3_DP    ! old value
   240:                 MolWtWet         = 18.0153e-3_DP
   241:                                    ! WMO technical regulations (see above)
   242:             
   243:                 LatentHeat       = 2.5e6_DP 
   244:                 LatentHeatFusion = 334.0e3_DP
   245:             
   246:                 SOMass = 1.0e3_DP * 60.0_DP
   247:                                    ! 1.0d3 (kg m-3) * 60.0d0 (m)
   248:             
   249:             
   250:                 ! NAMELIST からの入力
   251:                 ! Input from NAMELIST
   252:                 !
   253:                 if ( trim(namelist_filename) /= '' ) then
   254:                   call FileOpen( unit_nml, &          ! (out)
   255:                     & namelist_filename, mode = 'r' ) ! (in)
   256:             
   257:                   rewind( unit_nml )
   258:                   read( unit_nml, &           ! (in)
   259:                     & nml = constants_nml, &  ! (out)
   260:                     & iostat = iostat_nml )   ! (out)
   261:                   close( unit_nml )
   262:             
   263:                   call NmlutilMsg( iostat_nml, module_name ) ! (in)
   264:                   if ( iostat_nml == 0 ) write( STDOUT, nml = constants_nml )
   265:                 end if
   266:             
   267:                 GasRDry          = GasRUniv / MolWtDry
   268:                 GasRWet          = GasRUniv / MolWtWet
   269:                 EpsV             = MolWtWet / MolWtDry
   270:             
   271:             
   272:                 ! 印字 ; Print
   273:                 !
   274:                 call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   275:                 call MessageNotify( 'M', module_name, '  RPlanet          = %f', d = (/ RPlanet          /) )
   276:                 call MessageNotify( 'M', module_name, '  Omega            = %f', d = (/ Omega            /) )
   277:                 call MessageNotify( 'M', module_name, '  Grav             = %f', d = (/ Grav             /) )
   278:             
   279:                 call MessageNotify( 'M', module_name, '  CpDry            = %f', d = (/ CpDry            /) )
   280:                 call MessageNotify( 'M', module_name, '  MolWtDry         = %f', d = (/ MolWtDry         /) )
   281:             
   282:                 call MessageNotify( 'M', module_name, '  CpWet            = %f', d = (/ CpWet            /) )
   283:                 call MessageNotify( 'M', module_name, '  MolWtWet         = %f', d = (/ MolWtWet         /) )
   284:                 call MessageNotify( 'M', module_name, '  LatentHeat       = %f', d = (/ LatentHeat       /) )
   285:                 call MessageNotify( 'M', module_name, '  LatentHeatFusion = %f', d = (/ LatentHeatFusion /) )
   286:             
   287:                 call MessageNotify( 'M', module_name, '  GasRDry          = %f', d = (/ GasRDry          /) )
   288:                 call MessageNotify( 'M', module_name, '  GasRWet          = %f', d = (/ GasRWet          /) )
   289:                 call MessageNotify( 'M', module_name, '  EpsV             = %f', d = (/ EpsV             /) )
   290:                 call MessageNotify( 'M', module_name, '  FKarm            = %f', d = (/ FKarm            /) )
   291:                 call MessageNotify( 'M', module_name, '  SOMass           = %f', d = (/ SOMass           /) )
   292:                 call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   293:             
   294:                 constants_inited = .true.
   295:             
   296:               end subroutine ConstantsInit
   297:             
   298:               !--------------------------------------------------------------------------------------
   299:             
   300:             end module constants
