Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:21 2016
FILE NAME: constants0.f90
PROGRAM NAME: constants0
TRANSFORMATION LIST

  LINE                   FORTRAN STATEMENT

     1  != 物理・数学定数設定
     2  !
     3  != Physical and mathematical constants settings
     4  !
     5  ! Authors::   Yasuhiro MORIKAWA, Yoshiyuki O. Takahashi
     6  ! Version::   $Id: constants0.f90,v 1.3 2013/06/12 08:57:12 yot Exp $
     7  ! Tag Name::  $Name:  $
     8  ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9  ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10  !
    11  
    12  module constants0
    13    !
    14    != 物理・数学定数設定
    15    !
    16    != Physical and mathematical constants settings
    17    !
    18    ! <b>Note that Japanese and English are described in parallel.</b>
    19    !
    20    ! 物理・数学定数の設定および保管を行います.
    21    ! デフォルト値は地球大気を想定した値が設定されています.
    22    !
    23    ! Physical and mathematical constants are set and stored.
    24    ! By default, values on atmosphere of earth are set.
    25    !
    26    !== References
    27    !
    28    ! Mohr, P. J., B. N. Taylor, and D. B. Newell,
    29    !   CODATA recommended values of the fundamental physical constants: 2010,
    30    !   Rev. Mod. Phys., 84, 1527, 2012.
    31    !   See also http://physics.nist.gov/cuu/Constants/index.html.
    32    !
    33    !== Procedures List
    34    !
    35    ! Constants0Init :: 物理定数の設定
    36    ! ------------  :: ------------
    37    ! Constants0Init :: Settings of physical constants
    38    !
    39    !== NAMELIST
    40    !
    41    ! N/A
    42    !
    43  
    44  
    45    ! モジュール引用 ; USE statements
    46    !
    47  
    48    ! 種別型パラメタ
    49    ! Kind type parameter
    50    !
    51    use dc_types, only: DP     ! 倍精度実数型. Double precision.
    52  
    53    ! 宣言文 ; Declaration statements
    54    !
    55    implicit none
    56    private
    57  
    58    ! 公開手続き
    59    ! Public procedure
    60    !
    61    public:: Constants0Init
    62  
    63    ! 公開変数
    64    ! Public variables
    65    !
    66    logical, save, public:: constants0_inited = .false.
    67                                ! 初期設定フラグ.
    68                                ! Initialization flag
    69  
    70    real(DP), parameter, public:: PI = 3.1415926535897932_DP
    71                                ! $ \pi $ .
    72                                ! 円周率.  Circular constant
    73    real(DP), parameter, public:: GasRUniv = 8.3144621_DP
    74                                ! $ R^{*} $ [J K-1 mol-1].
    75                                ! 普遍気体定数.  Universal gas constant
    76                                ! (Mohr et al., 2012; CODATA 2010)
    77    real(DP), parameter, public:: Boltz = 1.3806488e-23_DP
    78                                ! $ k $ [J K-1].
    79                                ! ボルツマン定数.  Boltzmann constant
    80                                ! (Mohr et al., 2012; CODATA 2010)
    81    real(DP), parameter, public:: StB = 5.670373e-8_DP
    82                                ! $ \sigma_{SB} $ .
    83                                ! ステファンボルツマン定数.
    84                                ! Stefan-Boltzmann constant
    85                                ! (Mohr et al., 2012; CODATA 2010)
    86    real(DP), parameter, public:: WaterHeatCap = 4.187e3_DP
    87                                !
    88                                !
    89                                ! Water heat capacity (J K-1 kg-1)
    90  
    91  
    92    ! 非公開変数
    93    ! Private variables
    94    !
    95  
    96    character(*), parameter:: module_name = 'constants0'
    97                                ! モジュールの名称.
    98                                ! Module name
    99    character(*), parameter:: version = &
   100      & '$Name:  $' // &
   101      & '$Id: constants0.f90,v 1.3 2013/06/12 08:57:12 yot Exp $'
   102                                ! モジュールのバージョン
   103                                ! Module version
   104  
   105  contains
   106  
   107    !--------------------------------------------------------------------------------------
   108  
   109    subroutine Constants0Init
   110      !
   111      ! constants0 モジュールの初期化を行います.
   112      !
   113      ! "constants0" module is initialized.
   114      !
   115  
   116      ! モジュール引用 ; USE statements
   117      !
   118  
   119      ! メッセージ出力
   120      ! Message output
   121      !
   122      use dc_message, only: MessageNotify
   123  
   124      ! 宣言文 ; Declaration statements
   125      !
   126      implicit none
   127  
   128      ! 実行文 ; Executable statement
   129      !
   130  
   131      if ( constants0_inited ) return
   132  
   133  
   134      ! 印字 ; Print
   135      !
   136      call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   137      call MessageNotify( 'M', module_name, '  PI               = %f', d = (/ PI               /) )
   138      call MessageNotify( 'M', module_name, '  GasRUniv         = %f', d = (/ GasRUniv         /) )
   139      call MessageNotify( 'M', module_name, '  Boltz            = %f', d = (/ Boltz            /) )
   140      call MessageNotify( 'M', module_name, '  StB              = %f', d = (/ StB              /) )
   141      call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   142  
   143      constants0_inited = .true.
   144  
   145    end subroutine Constants0Init
   146  
   147    !--------------------------------------------------------------------------------------
   148  
   149  end module constants0
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:21 2016
FILE NAME: constants0.f90
PROGRAM NAME: constants0
FORMAT LIST

  LINE    LOOP      FORTRAN STATEMENT

     1:             != 物理・数学定数設定
     2:             !
     3:             != Physical and mathematical constants settings
     4:             !
     5:             ! Authors::   Yasuhiro MORIKAWA, Yoshiyuki O. Takahashi
     6:             ! Version::   $Id: constants0.f90,v 1.3 2013/06/12 08:57:12 yot Exp $ 
     7:             ! Tag Name::  $Name:  $
     8:             ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9:             ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10:             !
    11:             
    12:             module constants0
    13:               !
    14:               != 物理・数学定数設定
    15:               !
    16:               != Physical and mathematical constants settings
    17:               !
    18:               ! <b>Note that Japanese and English are described in parallel.</b>
    19:               !
    20:               ! 物理・数学定数の設定および保管を行います. 
    21:               ! デフォルト値は地球大気を想定した値が設定されています. 
    22:               !
    23:               ! Physical and mathematical constants are set and stored. 
    24:               ! By default, values on atmosphere of earth are set. 
    25:               !
    26:               !== References
    27:               !
    28:               ! Mohr, P. J., B. N. Taylor, and D. B. Newell, 
    29:               !   CODATA recommended values of the fundamental physical constants: 2010, 
    30:               !   Rev. Mod. Phys., 84, 1527, 2012.
    31:               !   See also http://physics.nist.gov/cuu/Constants/index.html.
    32:               !
    33:               !== Procedures List
    34:               !
    35:               ! Constants0Init :: 物理定数の設定
    36:               ! ------------  :: ------------
    37:               ! Constants0Init :: Settings of physical constants
    38:               !
    39:               !== NAMELIST
    40:               !
    41:               ! N/A
    42:               !
    43:             
    44:             
    45:               ! モジュール引用 ; USE statements
    46:               !
    47:             
    48:               ! 種別型パラメタ
    49:               ! Kind type parameter
    50:               !
    51:               use dc_types, only: DP     ! 倍精度実数型. Double precision. 
    52:             
    53:               ! 宣言文 ; Declaration statements
    54:               !
    55:               implicit none
    56:               private
    57:             
    58:               ! 公開手続き
    59:               ! Public procedure
    60:               !
    61:               public:: Constants0Init
    62:             
    63:               ! 公開変数
    64:               ! Public variables
    65:               !
    66:               logical, save, public:: constants0_inited = .false.
    67:                                           ! 初期設定フラグ. 
    68:                                           ! Initialization flag
    69:             
    70:               real(DP), parameter, public:: PI = 3.1415926535897932_DP
    71:                                           ! $ \pi $ .
    72:                                           ! 円周率.  Circular constant
    73:               real(DP), parameter, public:: GasRUniv = 8.3144621_DP
    74:                                           ! $ R^{*} $ [J K-1 mol-1].
    75:                                           ! 普遍気体定数.  Universal gas constant
    76:                                           ! (Mohr et al., 2012; CODATA 2010)
    77:               real(DP), parameter, public:: Boltz = 1.3806488e-23_DP
    78:                                           ! $ k $ [J K-1].
    79:                                           ! ボルツマン定数.  Boltzmann constant
    80:                                           ! (Mohr et al., 2012; CODATA 2010)
    81:               real(DP), parameter, public:: StB = 5.670373e-8_DP
    82:                                           ! $ \sigma_{SB} $ . 
    83:                                           ! ステファンボルツマン定数. 
    84:                                           ! Stefan-Boltzmann constant
    85:                                           ! (Mohr et al., 2012; CODATA 2010)
    86:               real(DP), parameter, public:: WaterHeatCap = 4.187e3_DP
    87:                                           !
    88:                                           !
    89:                                           ! Water heat capacity (J K-1 kg-1)
    90:             
    91:             
    92:               ! 非公開変数
    93:               ! Private variables
    94:               !
    95:             
    96:               character(*), parameter:: module_name = 'constants0'
    97:                                           ! モジュールの名称. 
    98:                                           ! Module name
    99:               character(*), parameter:: version = &
   100:                 & '$Name:  $' // &
   101:                 & '$Id: constants0.f90,v 1.3 2013/06/12 08:57:12 yot Exp $'
   102:                                           ! モジュールのバージョン
   103:                                           ! Module version
   104:             
   105:             contains
   106:             
   107:               !--------------------------------------------------------------------------------------
   108:             
   109:               subroutine Constants0Init
   110:                 !
   111:                 ! constants0 モジュールの初期化を行います. 
   112:                 !
   113:                 ! "constants0" module is initialized. 
   114:                 !
   115:             
   116:                 ! モジュール引用 ; USE statements
   117:                 !
   118:             
   119:                 ! メッセージ出力
   120:                 ! Message output
   121:                 !
   122:                 use dc_message, only: MessageNotify
   123:             
   124:                 ! 宣言文 ; Declaration statements
   125:                 !
   126:                 implicit none
   127:             
   128:                 ! 実行文 ; Executable statement
   129:                 !
   130:             
   131:                 if ( constants0_inited ) return
   132:             
   133:             
   134:                 ! 印字 ; Print
   135:                 !
   136:                 call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   137:                 call MessageNotify( 'M', module_name, '  PI               = %f', d = (/ PI               /) )
   138:                 call MessageNotify( 'M', module_name, '  GasRUniv         = %f', d = (/ GasRUniv         /) )
   139:                 call MessageNotify( 'M', module_name, '  Boltz            = %f', d = (/ Boltz            /) )
   140:                 call MessageNotify( 'M', module_name, '  StB              = %f', d = (/ StB              /) )
   141:                 call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   142:             
   143:                 constants0_inited = .true.
   144:             
   145:               end subroutine Constants0Init
   146:             
   147:               !--------------------------------------------------------------------------------------
   148:             
   149:             end module constants0
