Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:22 2016
FILE NAME: constants_snowseaice.f90
PROGRAM NAME: constants_snowseaice
TRANSFORMATION LIST

  LINE                   FORTRAN STATEMENT

     1  != 雪と海氷の定数の設定
     2  !
     3  != Setting constants of snow and sea ice
     4  !
     5  ! Authors::   Yoshiyuki O. Takahashi
     6  ! Version::   $Id: constants_snowseaice.f90,v 1.5 2015/01/29 12:07:29 yot Exp $
     7  ! Tag Name::  $Name:  $
     8  ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9  ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10  !
    11  
    12  module constants_snowseaice
    13    !
    14    != 雪と海氷の定数の設定
    15    !
    16    != Setting constants of snow and sea ice
    17    !
    18    ! <b>Note that Japanese and English are described in parallel.</b>
    19    !
    20    ! 雪と海氷の定数の設定および保管を行います.
    21    ! これらの値は NAMELIST 変数群 constants_snowseaice_nml によって変更することが
    22    ! 可能です.
    23    !
    24    ! Constants of snow and sea ice are set and stored.
    25    ! These values can be changed by NAMELIST group name
    26    ! "constants_snowseaice_nml".
    27    !
    28    !== Procedures List
    29    !
    30    ! ConstantsSnowSeaIceInit :: 物理定数の設定
    31    ! ------------  :: ------------
    32    ! ConstantsSnowSeaIceInit :: Settings of constants of snow and sea ice
    33    !
    34    !== NAMELIST
    35    !
    36    ! NAMELIST#constants_snowseaice_nml
    37    !
    38  
    39  
    40    ! モジュール引用 ; USE statements
    41    !
    42  
    43    ! 種別型パラメタ
    44    ! Kind type parameter
    45    !
    46    use dc_types, only: DP     ! 倍精度実数型. Double precision.
    47  
    48    ! 宣言文 ; Declaration statements
    49    !
    50    implicit none
    51    private
    52  
    53    ! 公開手続き
    54    ! Public procedure
    55    !
    56    public:: ConstantsSnowSeaIceInit
    57  
    58    ! 公開変数
    59    ! Public variables
    60    !
    61    logical, save :: constants_snowseaice_inited = .false.
    62                                ! 初期設定フラグ.
    63                                ! Initialization flag
    64  
    65  
    66    real(DP), public, save:: SnowThresholdForFlux
    67    real(DP), public, save:: SnowThresholdForAlbedo
    68    real(DP), public, save:: SnowAlbedo
    69    real(DP), public, save:: SnowThermCondCoef
    70                             ! Thermal conductivity of snow (W m-1 K-1)
    71    real(DP), public, save:: SnowHeatCap
    72                             ! Snow heat capacity snow per unit mass (J kg-1 K-1)
    73    real(DP), public, save:: SnowVolHeatCap
    74                             ! Volumetric heat capacity of snow (J m-3 K-1)
    75    real(DP), public, save:: SnowDens
    76                             ! Density of snow (kg m-3)
    77    real(DP), public, save:: SnowMaxThermDepth
    78                             ! Maximum thermal depth of snow (m)
    79    real(DP), public, save:: TempCondWater
    80                          ! <Japanese>
    81                          ! Condensation temperature of water
    82  
    83    real(DP), public, save:: SeaIceHeatCap
    84                             ! Sea ice heat capacity per unit mass (J kg-1 K-1)
    85    real(DP), public, save:: SeaIceVolHeatCap
    86                             ! Volumetric heat capacity of sea ice (J m-3 K-1)
    87    real(DP), public, save:: SeaIceDen
    88                             ! Density of sea ice (kg m-3)
    89    real(DP), public, save:: SeaIceThermCondCoef
    90                             ! Thermal conductivity of sea ice (W m-1 K-1)
    91    real(DP), public, save:: SOSeaIceThresholdMass
    92                             ! Threshold for sea ice mass on slab ocean (kg m-2)
    93  
    94    real(DP), public, save:: SeaIceThreshold  ! to be changed
    95    real(DP), public, save:: SeaIceThickness
    96    real(DP), public, save:: TempBelowSeaIce
    97  
    98    real(DP), public, save:: SeaIceAlbedo
    99  
   100  
   101    real(DP), public, save:: CO2IceThreshold
   102    real(DP), public, save:: CO2IceAlbedoS
   103    real(DP), public, save:: CO2IceAlbedoN
   104    real(DP), public, save:: CO2IceEmisS
   105    real(DP), public, save:: CO2IceEmisN
   106  
   107  
   108    real(DP), public, save:: LatentHeatFusionBelowSeaIce
   109                                ! Latant heat for fusion below sea ice
   110  
   111  
   112    ! 非公開変数
   113    ! Private variables
   114    !
   115  
   116    character(*), parameter:: module_name = 'constants_snowseaice'
   117                                ! モジュールの名称.
   118                                ! Module name
   119    character(*), parameter:: version = &
   120      & '$Name:  $' // &
   121      & '$Id: constants_snowseaice.f90,v 1.5 2015/01/29 12:07:29 yot Exp $'
   122                                ! モジュールのバージョン
   123                                ! Module version
   124  
   125  contains
   126  
   127    !--------------------------------------------------------------------------------------
   128  
   129    subroutine ConstantsSnowSeaIceInit
   130      !
   131      ! constants_snowseaice モジュールの初期化を行います.
   132      ! NAMELIST#constants_snowseaice_nml の読み込みはこの手続きで行われます.
   133      !
   134      ! "constants_snowseaice" module is initialized.
   135      ! NAMELIST#constants_snowseaice_nml is loaded in this procedure.
   136      !
   137  
   138      ! モジュール引用 ; USE statements
   139      !
   140  
   141      ! NAMELIST ファイル入力に関するユーティリティ
   142      ! Utilities for NAMELIST file input
   143      !
   144      use namelist_util, only: namelist_filename, NmlutilMsg
   145  
   146      ! ファイル入出力補助
   147      ! File I/O support
   148      !
   149      use dc_iounit, only: FileOpen
   150  
   151      ! 種別型パラメタ
   152      ! Kind type parameter
   153      !
   154      use dc_types, only: STDOUT ! 標準出力の装置番号. Unit number of standard output
   155  
   156      ! メッセージ出力
   157      ! Message output
   158      !
   159      use dc_message, only: MessageNotify
   160  
   161      ! 物理・数学定数設定
   162      ! Physical and mathematical constants settings
   163      !
   164      use constants0, only: &
   165        & WaterHeatCap
   166                                 ! Water heat capacity (J K-1 kg-1)
   167  
   168      ! 物理定数設定
   169      ! Physical constants settings
   170      !
   171      use constants, only: &
   172        & LatentHeatFusion
   173                                ! $ L $ [J kg-1] .
   174                                ! 融解の潜熱.
   175                                ! Latent heat of fusion
   176  
   177  
   178      ! 宣言文 ; Declaration statements
   179      !
   180      implicit none
   181  
   182      integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号.
   183                                ! Unit number for NAMELIST file open
   184      integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT.
   185                                ! IOSTAT of NAMELIST read
   186  
   187      ! NAMELIST 変数群
   188      ! NAMELIST group name
   189      !
   190      namelist /constants_snowseaice_nml/ &
   191        & SnowThresholdForAlbedo, &
   192        & SnowThresholdForFlux  , &
   193        & SnowAlbedo         , &
   194        & SnowThermCondCoef  , &
   195        & SnowVolHeatCap     , &
   196        & SnowDens           , &
   197        & SnowMaxThermDepth  , &
   198        & TempCondWater      , &
   199        & SeaIceVolHeatCap   , &
   200        & SeaIceDen          , &
   201        & SeaIceThermCondCoef, &
   202        & SOSeaIceThresholdMass, &
   203        & SeaIceThreshold    , &
   204        & SeaIceThickness    , &
   205        & TempBelowSeaIce    , &
   206        & SeaIceAlbedo       , &
   207        & CO2IceAlbedoS      , &
   208        & CO2IceAlbedoN      , &
   209        & CO2IceEmisS        , &
   210        & CO2IceEmisN
   211  
   212            !
   213            ! デフォルト値については初期化手続 "constants#ConstantsInit"
   214            ! のソースコードを参照のこと.
   215            !
   216            ! Refer to source codes in the initialization procedure
   217            ! "constants#ConstantsInit" for the default values.
   218            !
   219  
   220      ! 実行文 ; Executable statement
   221      !
   222  
   223      if ( constants_snowseaice_inited ) return
   224  
   225  
   226      ! デフォルト値の設定
   227      ! Default values settings
   228      !
   229  
   230      SnowThresholdForAlbedo = 0.1_DP * 1.0e3_DP * 0.01e0_DP
   231                          ! 1 cm snow depth
   232                          ! 0.1 * 1000 (kg m-3; water density) x 1 cm
   233                          ! This value is selected arbitrarily.
   234  !!$    SnowAlbedo         = 0.7d0
   235      SnowAlbedo         = 0.75_DP
   236                          ! This value is selected arbitrarily.
   237  
   238      SnowThresholdForFlux   = SnowThresholdForAlbedo
   239  
   240      ! MEMO for snow properties by Hillet
   241      !* snow (f=0.95) : k = 0.15e-3, C = 0.05
   242      !* snow (f=0.8 ) : k = 0.32e-3, C = 0.2
   243      !* snow (f=0.5 ) : k = 1.7e-3 , C = 0.5
   244      !f: porosity
   245      !k [cal/(cm s K)] conductivity
   246      !C [cal/(cm s K)] heat capacity
   247  
   248      SnowThermCondCoef = 0.32e-3_DP * 4.219e2_DP
   249                                ! Thermal conductivity of snow (W m-1 K-1)
   250  !!$    SnowVolHeatCap     = 0.2_DP * 4.219e2_DP
   251      SnowVolHeatCap    = 2.0e6_DP * 200.0_DP / 1000.0_DP
   252                          ! This value is roughly based on ECMWF IFS value.
   253                          ! p.121, IFSPart4.pdf
   254                          ! Volumetric heat capacity of snow (J m-3 K-1)
   255  
   256      SnowDens          = 200.0_DP
   257                          ! This value is selected arbitrarily.
   258                          ! Density of snow (kg m-3)
   259  
   260      SnowHeatCap       = SnowVolHeatCap / SnowDens
   261                          ! Snow heat capacity per unit mass (J kg-1 K-1)
   262  
   263  !!$    SnowMaxThermDepth = 1.0_DP
   264      SnowMaxThermDepth = 0.0_DP
   265                          ! This value is based on ECMWF IFS value.
   266                          ! p.121, IFSPart4.pdf
   267                                ! Maximum thermal depth of snow (m)
   268  
   269  
   270      TempCondWater      = 273.15_DP
   271                          ! <Japanese>
   272                          ! Condensation temperature of water
   273  
   274  !!$    ! https://www.myroms.org/wiki/index.php/Sea-Ice_Model
   275  !!$    SeaIceDens         = 900.0d0   ! no reliable reference
   276  !!$    SeaIceSpecHeat     = 2093.0d0  ! no reliable reference
   277  !!$    SeaIceHeatDiffCoef = 2.04d0 / ( SeaIceDens * SeaIceSpecHeat )  ! 2.04d0 (W (m K)-1),  no reliable reference
   278  
   279  !!$    SeaIceDens         = 0.92d3
   280  !!$    ! kg m-3
   281  !!$    SeaIceHeatDiffCoef = 2.04d0 / ( SeaIceDens * SeaIceSpecHeat )
   282  !!$    ! 2.04d0 (W (m K)-1),  no reliable reference
   283  !!$    SeaIceSpecHeat     = 1.9d6 / SeaIceDens
   284  !!$    ! no reliable reference
   285  
   286      SeaIceVolHeatCap    = 1.9e6_DP
   287      ! J m-3 K-1
   288      ! Value of ice in Table 12.1 by Hillel (2004).
   289      SeaIceDen           = 0.92e3_DP
   290      ! kg m-3
   291      ! Value of ice in Table 12.1 by Hillel (2004).
   292      SeaIceHeatCap       = SeaIceVolHeatCap / SeaIceDen
   293      ! J m-3 K-1
   294      SeaIceThermCondCoef = 2.2_DP
   295      ! W m-1 K-1
   296      ! Value of ice in Table 12.2 by Hillel (2004).
   297  
   298      ! Reference
   299      !
   300      ! Hillet, D.,
   301      !   Introduction to Environmental Soil Physics,
   302      !   Elsevier Academic Press, pp494, 2004.
   303  
   304      SOSeaIceThresholdMass = 1.0e-3_DP * SeaIceDen
   305                                             ! (kg m-2) = 1 (mm) x SeaIceDen (kg m-3)
   306                                             ! arbitrarily set
   307  
   308      SeaIceThreshold    = 0.5_DP            ! arbitrarily set, no reliable reference
   309      SeaIceThickness    = 2.0_DP            ! arbitrarily set, no reliable reference
   310      TempBelowSeaIce    = 273.15_DP - 2.0_DP ! arbitrarily set, no reliable reference
   311  
   312  !!$    SeaIceAlbedo       = 0.5_DP            ! arbitrarily set, no reliable reference
   313      SeaIceAlbedo       = 0.75_DP           ! arbitrarily set, no reliable reference
   314  
   315  
   316      CO2IceThreshold = 1.0_DP         ! No reference
   317      CO2IceAlbedoS   = 0.75_DP        ! No reference
   318      CO2IceAlbedoN   = 0.75_DP        ! No reference
   319      CO2IceEmisS     = 1.0_DP         ! No reference
   320      CO2IceEmisN     = 1.0_DP         ! No reference
   321  
   322  
   323      ! NAMELIST からの入力
   324      ! Input from NAMELIST
   325      !
   326      if ( trim(namelist_filename) /= '' ) then
   327        call FileOpen( unit_nml, &          ! (out)
   328          & namelist_filename, mode = 'r' ) ! (in)
   329  
   330        rewind( unit_nml )
   331        read( unit_nml,                     &  ! (in)
   332          & nml = constants_snowseaice_nml, &  ! (out)
   333          & iostat = iostat_nml            )   ! (out)
   334        close( unit_nml )
   335  
   336        call NmlutilMsg( iostat_nml, module_name ) ! (in)
   337        if ( iostat_nml == 0 ) write( STDOUT, nml = constants_snowseaice_nml )
   338      end if
   339  
   340  
   341  
   342      ! Latent heat for fusion below sea ice
   343      !
   344      LatentHeatFusionBelowSeaIce = &
   345        &   LatentHeatFusion &
   346        & + ( WaterHeatCap - SeaIceHeatCap ) * ( TempBelowSeaIce - TempCondWater )
   347  
   348  
   349      ! 印字 ; Print
   350      !
   351      call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   352      call MessageNotify( 'M', module_name, '  SnowThresholdForAlbedo = %f', d = (/ SnowThresholdForAlbedo /) )
   353      call MessageNotify( 'M', module_name, '  SnowAlbedo             = %f', d = (/ SnowAlbedo          /) )
   354      call MessageNotify( 'M', module_name, '  SnowThresholdForFlux   = %f', d = (/ SnowThresholdForFlux /) )
   355      call MessageNotify( 'M', module_name, '  SnowThermCondCoef   = %f', d = (/ SnowThermCondCoef   /) )
   356      call MessageNotify( 'M', module_name, '  SnowVolHeatCap      = %f', d = (/ SnowVolHeatCap      /) )
   357      call MessageNotify( 'M', module_name, '  SnowDens            = %f', d = (/ SnowDens            /) )
   358      call MessageNotify( 'M', module_name, '  SnowMaxThermDepth   = %f', d = (/ SnowMaxThermDepth   /) )
   359      call MessageNotify( 'M', module_name, '  TempCondWater       = %f', d = (/ TempCondWater       /) )
   360      call MessageNotify( 'M', module_name, '  SeaIceThreshold     = %f', d = (/ SeaIceThreshold     /) )
   361      call MessageNotify( 'M', module_name, '  SeaIceVolHeatCap    = %f', d = (/ SeaIceVolHeatCap    /) )
   362      call MessageNotify( 'M', module_name, '  SeaIceDen           = %f', d = (/ SeaIceDen           /) )
   363      call MessageNotify( 'M', module_name, '  SeaIceThermCondCoef = %f', d = (/ SeaIceThermCondCoef /) )
   364      call MessageNotify( 'M', module_name, '  SOSeaIceThresholdMass = %f', d = (/ SOSeaIceThresholdMass /) )
   365  
   366  !!$    call MessageNotify( 'M', module_name, '  SeaIceDens         = %f', d = (/ SeaIceDens         /) )
   367  !!$    call MessageNotify( 'M', module_name, '  SeaIceSpecHeat     = %f', d = (/ SeaIceSpecHeat     /) )
   368  !!$    call MessageNotify( 'M', module_name, '  SeaIceHeatDiffCoef = %f', d = (/ SeaIceHeatDiffCoef /) )
   369  
   370      call MessageNotify( 'M', module_name, '  SeaIceThickness     = %f', d = (/ SeaIceThickness     /) )
   371      call MessageNotify( 'M', module_name, '  TempBelowSeaIce     = %f', d = (/ TempBelowSeaIce     /) )
   372      call MessageNotify( 'M', module_name, '  SeaIceAlbedo        = %f', d = (/ SeaIceAlbedo        /) )
   373      call MessageNotify( 'M', module_name, '  CO2IceAlbedoS       = %f', d = (/ CO2IceAlbedoS       /) )
   374      call MessageNotify( 'M', module_name, '  CO2IceAlbedoN       = %f', d = (/ CO2IceAlbedoN       /) )
   375      call MessageNotify( 'M', module_name, '  CO2IceEmisS         = %f', d = (/ CO2IceEmisS       /) )
   376      call MessageNotify( 'M', module_name, '  CO2IceEmisN         = %f', d = (/ CO2IceEmisN       /) )
   377      call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   378  
   379      constants_snowseaice_inited = .true.
   380  
   381    end subroutine ConstantsSnowSeaIceInit
   382  
   383    !--------------------------------------------------------------------------------------
   384  
   385  end module constants_snowseaice
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:22 2016
FILE NAME: constants_snowseaice.f90
PROGRAM NAME: constants_snowseaice
FORMAT LIST

  LINE    LOOP      FORTRAN STATEMENT

     1:             != 雪と海氷の定数の設定
     2:             !
     3:             != Setting constants of snow and sea ice
     4:             !
     5:             ! Authors::   Yoshiyuki O. Takahashi
     6:             ! Version::   $Id: constants_snowseaice.f90,v 1.5 2015/01/29 12:07:29 yot Exp $ 
     7:             ! Tag Name::  $Name:  $
     8:             ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9:             ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10:             !
    11:             
    12:             module constants_snowseaice
    13:               !
    14:               != 雪と海氷の定数の設定
    15:               !
    16:               != Setting constants of snow and sea ice
    17:               !
    18:               ! <b>Note that Japanese and English are described in parallel.</b>
    19:               !
    20:               ! 雪と海氷の定数の設定および保管を行います. 
    21:               ! これらの値は NAMELIST 変数群 constants_snowseaice_nml によって変更することが
    22:               ! 可能です. 
    23:               !
    24:               ! Constants of snow and sea ice are set and stored. 
    25:               ! These values can be changed by NAMELIST group name 
    26:               ! "constants_snowseaice_nml". 
    27:               !
    28:               !== Procedures List
    29:               !
    30:               ! ConstantsSnowSeaIceInit :: 物理定数の設定
    31:               ! ------------  :: ------------
    32:               ! ConstantsSnowSeaIceInit :: Settings of constants of snow and sea ice
    33:               !
    34:               !== NAMELIST
    35:               !
    36:               ! NAMELIST#constants_snowseaice_nml
    37:               !
    38:             
    39:             
    40:               ! モジュール引用 ; USE statements
    41:               !
    42:             
    43:               ! 種別型パラメタ
    44:               ! Kind type parameter
    45:               !
    46:               use dc_types, only: DP     ! 倍精度実数型. Double precision. 
    47:             
    48:               ! 宣言文 ; Declaration statements
    49:               !
    50:               implicit none
    51:               private
    52:             
    53:               ! 公開手続き
    54:               ! Public procedure
    55:               !
    56:               public:: ConstantsSnowSeaIceInit
    57:             
    58:               ! 公開変数
    59:               ! Public variables
    60:               !
    61:               logical, save :: constants_snowseaice_inited = .false.
    62:                                           ! 初期設定フラグ. 
    63:                                           ! Initialization flag
    64:             
    65:             
    66:               real(DP), public, save:: SnowThresholdForFlux
    67:               real(DP), public, save:: SnowThresholdForAlbedo
    68:               real(DP), public, save:: SnowAlbedo
    69:               real(DP), public, save:: SnowThermCondCoef
    70:                                        ! Thermal conductivity of snow (W m-1 K-1)
    71:               real(DP), public, save:: SnowHeatCap
    72:                                        ! Snow heat capacity snow per unit mass (J kg-1 K-1)
    73:               real(DP), public, save:: SnowVolHeatCap
    74:                                        ! Volumetric heat capacity of snow (J m-3 K-1)
    75:               real(DP), public, save:: SnowDens
    76:                                        ! Density of snow (kg m-3)
    77:               real(DP), public, save:: SnowMaxThermDepth
    78:                                        ! Maximum thermal depth of snow (m)
    79:               real(DP), public, save:: TempCondWater
    80:                                     ! <Japanese>
    81:                                     ! Condensation temperature of water
    82:             
    83:               real(DP), public, save:: SeaIceHeatCap
    84:                                        ! Sea ice heat capacity per unit mass (J kg-1 K-1)
    85:               real(DP), public, save:: SeaIceVolHeatCap
    86:                                        ! Volumetric heat capacity of sea ice (J m-3 K-1)
    87:               real(DP), public, save:: SeaIceDen
    88:                                        ! Density of sea ice (kg m-3)
    89:               real(DP), public, save:: SeaIceThermCondCoef
    90:                                        ! Thermal conductivity of sea ice (W m-1 K-1)
    91:               real(DP), public, save:: SOSeaIceThresholdMass
    92:                                        ! Threshold for sea ice mass on slab ocean (kg m-2)
    93:             
    94:               real(DP), public, save:: SeaIceThreshold  ! to be changed
    95:               real(DP), public, save:: SeaIceThickness
    96:               real(DP), public, save:: TempBelowSeaIce
    97:             
    98:               real(DP), public, save:: SeaIceAlbedo
    99:             
   100:             
   101:               real(DP), public, save:: CO2IceThreshold
   102:               real(DP), public, save:: CO2IceAlbedoS
   103:               real(DP), public, save:: CO2IceAlbedoN
   104:               real(DP), public, save:: CO2IceEmisS
   105:               real(DP), public, save:: CO2IceEmisN
   106:             
   107:             
   108:               real(DP), public, save:: LatentHeatFusionBelowSeaIce
   109:                                           ! Latant heat for fusion below sea ice
   110:             
   111:             
   112:               ! 非公開変数
   113:               ! Private variables
   114:               !
   115:             
   116:               character(*), parameter:: module_name = 'constants_snowseaice'
   117:                                           ! モジュールの名称. 
   118:                                           ! Module name
   119:               character(*), parameter:: version = &
   120:                 & '$Name:  $' // &
   121:                 & '$Id: constants_snowseaice.f90,v 1.5 2015/01/29 12:07:29 yot Exp $'
   122:                                           ! モジュールのバージョン
   123:                                           ! Module version
   124:             
   125:             contains
   126:             
   127:               !--------------------------------------------------------------------------------------
   128:             
   129:               subroutine ConstantsSnowSeaIceInit
   130:                 !
   131:                 ! constants_snowseaice モジュールの初期化を行います. 
   132:                 ! NAMELIST#constants_snowseaice_nml の読み込みはこの手続きで行われます. 
   133:                 !
   134:                 ! "constants_snowseaice" module is initialized. 
   135:                 ! NAMELIST#constants_snowseaice_nml is loaded in this procedure. 
   136:                 !
   137:             
   138:                 ! モジュール引用 ; USE statements
   139:                 !
   140:             
   141:                 ! NAMELIST ファイル入力に関するユーティリティ
   142:                 ! Utilities for NAMELIST file input
   143:                 !
   144:                 use namelist_util, only: namelist_filename, NmlutilMsg
   145:             
   146:                 ! ファイル入出力補助
   147:                 ! File I/O support
   148:                 !
   149:                 use dc_iounit, only: FileOpen
   150:             
   151:                 ! 種別型パラメタ
   152:                 ! Kind type parameter
   153:                 !
   154:                 use dc_types, only: STDOUT ! 標準出力の装置番号. Unit number of standard output
   155:             
   156:                 ! メッセージ出力
   157:                 ! Message output
   158:                 !
   159:                 use dc_message, only: MessageNotify
   160:             
   161:                 ! 物理・数学定数設定
   162:                 ! Physical and mathematical constants settings
   163:                 !
   164:                 use constants0, only: &
   165:                   & WaterHeatCap
   166:                                            ! Water heat capacity (J K-1 kg-1)
   167:             
   168:                 ! 物理定数設定
   169:                 ! Physical constants settings
   170:                 !
   171:                 use constants, only: &
   172:                   & LatentHeatFusion
   173:                                           ! $ L $ [J kg-1] . 
   174:                                           ! 融解の潜熱. 
   175:                                           ! Latent heat of fusion
   176:             
   177:             
   178:                 ! 宣言文 ; Declaration statements
   179:                 !
   180:                 implicit none
   181:             
   182:                 integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号. 
   183:                                           ! Unit number for NAMELIST file open
   184:                 integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT. 
   185:                                           ! IOSTAT of NAMELIST read
   186:             
   187:                 ! NAMELIST 変数群
   188:                 ! NAMELIST group name
   189:                 !
   190:                 namelist /constants_snowseaice_nml/ &
   191:                   & SnowThresholdForAlbedo, &
   192:                   & SnowThresholdForFlux  , &
   193:                   & SnowAlbedo         , &
   194:                   & SnowThermCondCoef  , &
   195:                   & SnowVolHeatCap     , &
   196:                   & SnowDens           , &
   197:                   & SnowMaxThermDepth  , &
   198:                   & TempCondWater      , &
   199:                   & SeaIceVolHeatCap   , &
   200:                   & SeaIceDen          , &
   201:                   & SeaIceThermCondCoef, &
   202:                   & SOSeaIceThresholdMass, &
   203:                   & SeaIceThreshold    , &
   204:                   & SeaIceThickness    , &
   205:                   & TempBelowSeaIce    , &
   206:                   & SeaIceAlbedo       , &
   207:                   & CO2IceAlbedoS      , &
   208:                   & CO2IceAlbedoN      , &
   209:                   & CO2IceEmisS        , &
   210:                   & CO2IceEmisN
   211:             
   212:                       !
   213:                       ! デフォルト値については初期化手続 "constants#ConstantsInit" 
   214:                       ! のソースコードを参照のこと. 
   215:                       !
   216:                       ! Refer to source codes in the initialization procedure
   217:                       ! "constants#ConstantsInit" for the default values. 
   218:                       !
   219:             
   220:                 ! 実行文 ; Executable statement
   221:                 !
   222:             
   223:                 if ( constants_snowseaice_inited ) return
   224:             
   225:             
   226:                 ! デフォルト値の設定
   227:                 ! Default values settings
   228:                 !
   229:             
   230:                 SnowThresholdForAlbedo = 0.1_DP * 1.0e3_DP * 0.01e0_DP
   231:                                     ! 1 cm snow depth
   232:                                     ! 0.1 * 1000 (kg m-3; water density) x 1 cm
   233:                                     ! This value is selected arbitrarily. 
   234:             !!$    SnowAlbedo         = 0.7d0
   235:                 SnowAlbedo         = 0.75_DP
   236:                                     ! This value is selected arbitrarily. 
   237:             
   238:                 SnowThresholdForFlux   = SnowThresholdForAlbedo
   239:             
   240:                 ! MEMO for snow properties by Hillet
   241:                 !* snow (f=0.95) : k = 0.15e-3, C = 0.05
   242:                 !* snow (f=0.8 ) : k = 0.32e-3, C = 0.2
   243:                 !* snow (f=0.5 ) : k = 1.7e-3 , C = 0.5
   244:                 !f: porosity
   245:                 !k [cal/(cm s K)] conductivity
   246:                 !C [cal/(cm s K)] heat capacity
   247:             
   248:                 SnowThermCondCoef = 0.32e-3_DP * 4.219e2_DP
   249:                                           ! Thermal conductivity of snow (W m-1 K-1)
   250:             !!$    SnowVolHeatCap     = 0.2_DP * 4.219e2_DP
   251:                 SnowVolHeatCap    = 2.0e6_DP * 200.0_DP / 1000.0_DP
   252:                                     ! This value is roughly based on ECMWF IFS value.
   253:                                     ! p.121, IFSPart4.pdf
   254:                                     ! Volumetric heat capacity of snow (J m-3 K-1)
   255:             
   256:                 SnowDens          = 200.0_DP
   257:                                     ! This value is selected arbitrarily. 
   258:                                     ! Density of snow (kg m-3)
   259:             
   260:                 SnowHeatCap       = SnowVolHeatCap / SnowDens
   261:                                     ! Snow heat capacity per unit mass (J kg-1 K-1)
   262:             
   263:             !!$    SnowMaxThermDepth = 1.0_DP
   264:                 SnowMaxThermDepth = 0.0_DP
   265:                                     ! This value is based on ECMWF IFS value.
   266:                                     ! p.121, IFSPart4.pdf
   267:                                           ! Maximum thermal depth of snow (m)
   268:             
   269:             
   270:                 TempCondWater      = 273.15_DP
   271:                                     ! <Japanese>
   272:                                     ! Condensation temperature of water
   273:             
   274:             !!$    ! https://www.myroms.org/wiki/index.php/Sea-Ice_Model
   275:             !!$    SeaIceDens         = 900.0d0   ! no reliable reference
   276:             !!$    SeaIceSpecHeat     = 2093.0d0  ! no reliable reference
   277:             !!$    SeaIceHeatDiffCoef = 2.04d0 / ( SeaIceDens * SeaIceSpecHeat )  ! 2.04d0 (W (m K)-1),  no reliable reference
   278:             
   279:             !!$    SeaIceDens         = 0.92d3
   280:             !!$    ! kg m-3
   281:             !!$    SeaIceHeatDiffCoef = 2.04d0 / ( SeaIceDens * SeaIceSpecHeat )
   282:             !!$    ! 2.04d0 (W (m K)-1),  no reliable reference
   283:             !!$    SeaIceSpecHeat     = 1.9d6 / SeaIceDens
   284:             !!$    ! no reliable reference
   285:             
   286:                 SeaIceVolHeatCap    = 1.9e6_DP
   287:                 ! J m-3 K-1
   288:                 ! Value of ice in Table 12.1 by Hillel (2004). 
   289:                 SeaIceDen           = 0.92e3_DP
   290:                 ! kg m-3
   291:                 ! Value of ice in Table 12.1 by Hillel (2004). 
   292:                 SeaIceHeatCap       = SeaIceVolHeatCap / SeaIceDen
   293:                 ! J m-3 K-1
   294:                 SeaIceThermCondCoef = 2.2_DP
   295:                 ! W m-1 K-1
   296:                 ! Value of ice in Table 12.2 by Hillel (2004). 
   297:             
   298:                 ! Reference
   299:                 !
   300:                 ! Hillet, D., 
   301:                 !   Introduction to Environmental Soil Physics, 
   302:                 !   Elsevier Academic Press, pp494, 2004.
   303:             
   304:                 SOSeaIceThresholdMass = 1.0e-3_DP * SeaIceDen
   305:                                                        ! (kg m-2) = 1 (mm) x SeaIceDen (kg m-3)
   306:                                                        ! arbitrarily set
   307:             
   308:                 SeaIceThreshold    = 0.5_DP            ! arbitrarily set, no reliable reference
   309:                 SeaIceThickness    = 2.0_DP            ! arbitrarily set, no reliable reference
   310:                 TempBelowSeaIce    = 273.15_DP - 2.0_DP ! arbitrarily set, no reliable reference
   311:             
   312:             !!$    SeaIceAlbedo       = 0.5_DP            ! arbitrarily set, no reliable reference
   313:                 SeaIceAlbedo       = 0.75_DP           ! arbitrarily set, no reliable reference
   314:             
   315:             
   316:                 CO2IceThreshold = 1.0_DP         ! No reference
   317:                 CO2IceAlbedoS   = 0.75_DP        ! No reference
   318:                 CO2IceAlbedoN   = 0.75_DP        ! No reference
   319:                 CO2IceEmisS     = 1.0_DP         ! No reference
   320:                 CO2IceEmisN     = 1.0_DP         ! No reference
   321:             
   322:             
   323:                 ! NAMELIST からの入力
   324:                 ! Input from NAMELIST
   325:                 !
   326:                 if ( trim(namelist_filename) /= '' ) then
   327:                   call FileOpen( unit_nml, &          ! (out)
   328:                     & namelist_filename, mode = 'r' ) ! (in)
   329:             
   330:                   rewind( unit_nml )
   331:                   read( unit_nml,                     &  ! (in)
   332:                     & nml = constants_snowseaice_nml, &  ! (out)
   333:                     & iostat = iostat_nml            )   ! (out)
   334:                   close( unit_nml )
   335:             
   336:                   call NmlutilMsg( iostat_nml, module_name ) ! (in)
   337:                   if ( iostat_nml == 0 ) write( STDOUT, nml = constants_snowseaice_nml )
   338:                 end if
   339:             
   340:             
   341:             
   342:                 ! Latent heat for fusion below sea ice
   343:                 !
   344:                 LatentHeatFusionBelowSeaIce = &
   345:                   &   LatentHeatFusion &
   346:                   & + ( WaterHeatCap - SeaIceHeatCap ) * ( TempBelowSeaIce - TempCondWater )
   347:             
   348:             
   349:                 ! 印字 ; Print
   350:                 !
   351:                 call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   352:                 call MessageNotify( 'M', module_name, '  SnowThresholdForAlbedo = %f', d = (/ SnowThresholdForAlbedo /) )
   353:                 call MessageNotify( 'M', module_name, '  SnowAlbedo             = %f', d = (/ SnowAlbedo          /) )
   354:                 call MessageNotify( 'M', module_name, '  SnowThresholdForFlux   = %f', d = (/ SnowThresholdForFlux /) )
   355:                 call MessageNotify( 'M', module_name, '  SnowThermCondCoef   = %f', d = (/ SnowThermCondCoef   /) )
   356:                 call MessageNotify( 'M', module_name, '  SnowVolHeatCap      = %f', d = (/ SnowVolHeatCap      /) )
   357:                 call MessageNotify( 'M', module_name, '  SnowDens            = %f', d = (/ SnowDens            /) )
   358:                 call MessageNotify( 'M', module_name, '  SnowMaxThermDepth   = %f', d = (/ SnowMaxThermDepth   /) )
   359:                 call MessageNotify( 'M', module_name, '  TempCondWater       = %f', d = (/ TempCondWater       /) )
   360:                 call MessageNotify( 'M', module_name, '  SeaIceThreshold     = %f', d = (/ SeaIceThreshold     /) )
   361:                 call MessageNotify( 'M', module_name, '  SeaIceVolHeatCap    = %f', d = (/ SeaIceVolHeatCap    /) )
   362:                 call MessageNotify( 'M', module_name, '  SeaIceDen           = %f', d = (/ SeaIceDen           /) )
   363:                 call MessageNotify( 'M', module_name, '  SeaIceThermCondCoef = %f', d = (/ SeaIceThermCondCoef /) )
   364:                 call MessageNotify( 'M', module_name, '  SOSeaIceThresholdMass = %f', d = (/ SOSeaIceThresholdMass /) )
   365:             
   366:             !!$    call MessageNotify( 'M', module_name, '  SeaIceDens         = %f', d = (/ SeaIceDens         /) )
   367:             !!$    call MessageNotify( 'M', module_name, '  SeaIceSpecHeat     = %f', d = (/ SeaIceSpecHeat     /) )
   368:             !!$    call MessageNotify( 'M', module_name, '  SeaIceHeatDiffCoef = %f', d = (/ SeaIceHeatDiffCoef /) )
   369:             
   370:                 call MessageNotify( 'M', module_name, '  SeaIceThickness     = %f', d = (/ SeaIceThickness     /) )
   371:                 call MessageNotify( 'M', module_name, '  TempBelowSeaIce     = %f', d = (/ TempBelowSeaIce     /) )
   372:                 call MessageNotify( 'M', module_name, '  SeaIceAlbedo        = %f', d = (/ SeaIceAlbedo        /) )
   373:                 call MessageNotify( 'M', module_name, '  CO2IceAlbedoS       = %f', d = (/ CO2IceAlbedoS       /) )
   374:                 call MessageNotify( 'M', module_name, '  CO2IceAlbedoN       = %f', d = (/ CO2IceAlbedoN       /) )
   375:                 call MessageNotify( 'M', module_name, '  CO2IceEmisS         = %f', d = (/ CO2IceEmisS       /) )
   376:                 call MessageNotify( 'M', module_name, '  CO2IceEmisN         = %f', d = (/ CO2IceEmisN       /) )
   377:                 call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   378:             
   379:                 constants_snowseaice_inited = .true.
   380:             
   381:               end subroutine ConstantsSnowSeaIceInit
   382:             
   383:               !--------------------------------------------------------------------------------------
   384:             
   385:             end module constants_snowseaice
