Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:21 2016
FILE NAME: fileset.f90
PROGRAM NAME: fileset
TRANSFORMATION LIST

  LINE                   FORTRAN STATEMENT

     1  != 出力ファイルの基本情報管理
     2  != Management basic information for output files
     3  !
     4  ! Authors::   Yasuhiro MORIKAWA
     5  ! Version::   $Id: fileset.f90,v 1.3 2009/03/03 15:57:35 morikawa Exp $
     6  ! Tag Name::  $Name:  $
     7  ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     8  ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
     9  !
    10  
    11  module fileset
    12    !
    13    != 出力ファイルの基本情報管理
    14    !
    15    != Management basic information for output files
    16    !
    17    ! <b>Note that Japanese and English are described in parallel.</b>
    18    !
    19    !== Variables List
    20    !
    21    ! FileTitle        :: 出力データファイルの表題
    22    ! FileSource       :: データファイル作成の手段
    23    ! FileInstitution  :: データファイルを最終的に変更した組織/個人
    24    ! ------------     :: ------------
    25    ! FileTitle        :: Title of output data files
    26    ! FileSource       :: Source of data file
    27    ! FileInstitution  :: Institution or person that changes data files for the last time
    28    !
    29    !
    30    !== Procedures List
    31    !
    32    ! FilesetInit   :: fileset モジュールの初期化
    33    ! ------------  :: ------------
    34    ! FilesetInit   :: Initialize "fileset" module
    35    !
    36    !
    37    !== NAMELIST
    38    !
    39    ! NAMELIST#fileset_nml
    40    !
    41  
    42    ! モジュール引用 ; USE statements
    43    !
    44  
    45    ! 種別型パラメタ
    46    ! Kind type parameter
    47    !
    48    use dc_types, only: STRING ! 文字列.       Strings.
    49  
    50    ! 宣言文 ; Declaration statements
    51    !
    52    implicit none
    53    private
    54  
    55    ! 公開手続き
    56    ! Public procedure
    57    !
    58    public:: FilesetInit
    59  
    60    ! 公開変数
    61    ! Public variables
    62    !
    63    logical, save, public:: fileset_inited = .false.
    64                                ! 初期設定フラグ.
    65                                ! Initialization flag
    66  
    67    character(STRING), save, public:: FileTitle
    68                                ! 出力データファイルの表題.
    69                                ! Title of output data files
    70    character(STRING), save, public:: FileSource
    71                                ! データファイル作成の手段.
    72                                ! Source of data file
    73    character(STRING), save, public:: FileInstitution
    74                                ! データファイルを最終的に変更した組織/個人.
    75                                ! Institution or person that changes data files for the last time
    76  
    77  
    78    ! 非公開変数
    79    ! Private variables
    80    !
    81  
    82    character(*), parameter:: module_name = 'fileset'
    83                                ! モジュールの名称.
    84                                ! Module name
    85    character(*), parameter:: version = &
    86      & '$Name:  $' // &
    87      & '$Id: fileset.f90,v 1.3 2009/03/03 15:57:35 morikawa Exp $'
    88                                ! モジュールのバージョン
    89                                ! Module version
    90  
    91    ! INTERFACE 文 ; INTERFACE statements
    92    !
    93    interface FilesetInit
    94      module procedure FilesetInit
    95    end interface
    96  
    97  contains
    98  
    99    subroutine FilesetInit
   100      !
   101      ! fileset モジュールの初期化を行います.
   102      ! NAMELIST#fileset_nml の読み込みはこの手続きで行われます.
   103      !
   104      ! "fileset" module is initialized.
   105      ! NAMELIST#fileset_nml is loaded in this procedure.
   106      !
   107  
   108      ! モジュール引用 ; USE statements
   109      !
   110  
   111      ! NAMELIST ファイル入力に関するユーティリティ
   112      ! Utilities for NAMELIST file input
   113      !
   114      use namelist_util, only: namelist_filename, NmlutilMsg
   115  
   116      ! ファイル入出力補助
   117      ! File I/O support
   118      !
   119      use dc_iounit, only: FileOpen
   120  
   121      ! 種別型パラメタ
   122      ! Kind type parameter
   123      !
   124      use dc_types, only: STDOUT ! 標準出力の装置番号. Unit number of standard output
   125  
   126      ! メッセージ出力
   127      ! Message output
   128      !
   129      use dc_message, only: MessageNotify
   130  
   131      ! 宣言文 ; Declaration statements
   132      !
   133      implicit none
   134      integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号.
   135                                ! Unit number for NAMELIST file open
   136      integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT.
   137                                ! IOSTAT of NAMELIST read
   138  
   139      ! NAMELIST 変数群
   140      ! NAMELIST group name
   141      !
   142      namelist /fileset_nml/ &
   143        & FileTitle, FileSource, FileInstitution
   144            !
   145            ! デフォルト値については初期化手続 "fileset#FilesetInit"
   146            ! のソースコードを参照のこと.
   147            !
   148            ! Refer to source codes in the initialization procedure
   149            ! "fileset#FilesetInit" for the default values.
   150            !
   151  
   152      ! 実行文 ; Executable statement
   153      !
   154  
   155      if ( fileset_inited ) return
   156      call InitCheck
   157  
   158      ! デフォルト値の設定
   159      ! Default values settings
   160      !
   161      FileTitle  = 'dcpam5 test run'
   162      FileSource = 'dcpam5 $Name:  $ (http://www.gfd-dennou.org/library/dcpam)'
   163      FileInstitution = 'GFD Dennou Club (http://www.gfd-dennou.org)'
   164  
   165      ! NAMELIST の読み込み
   166      ! NAMELIST is input
   167      !
   168      if ( trim(namelist_filename) /= '' ) then
   169        call FileOpen( unit_nml, &          ! (out)
   170          & namelist_filename, mode = 'r' ) ! (in)
   171  
   172        rewind( unit_nml )
   173        read( unit_nml, &         ! (in)
   174          & nml = fileset_nml, &  ! (out)
   175          & iostat = iostat_nml ) ! (out)
   176        close( unit_nml )
   177  
   178        call NmlutilMsg( iostat_nml, module_name ) ! (in)
   179        if ( iostat_nml == 0 ) write( STDOUT, nml = fileset_nml )
   180      end if
   181  
   182      ! 印字 ; Print
   183      !
   184      call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   185      call MessageNotify( 'M', module_name, '  FileTitle       = %c', c1 = trim(FileTitle) )
   186      call MessageNotify( 'M', module_name, '  FileSource      = %c', c1 = trim(FileSource) )
   187      call MessageNotify( 'M', module_name, '  FileInstitution = %c', c1 = trim(FileInstitution) )
   188      call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   189  
   190      fileset_inited = .true.
   191    end subroutine FilesetInit
   192  
   193    subroutine InitCheck
   194      !
   195      ! 依存モジュールの初期化チェック
   196      !
   197      ! Check initialization of dependency modules
   198  
   199      ! モジュール引用 ; USE statements
   200      !
   201  
   202      ! NAMELIST ファイル入力に関するユーティリティ
   203      ! Utilities for NAMELIST file input
   204      !
   205      use namelist_util, only: namelist_util_inited
   206  
   207      ! メッセージ出力
   208      ! Message output
   209      !
   210      use dc_message, only: MessageNotify
   211  
   212      ! 実行文 ; Executable statement
   213      !
   214  
   215      if ( .not. namelist_util_inited ) &
   216        & call MessageNotify( 'E', module_name, '"namelist_util" module is not initialized.' )
   217  
   218    end subroutine InitCheck
   219  
   220  end module fileset
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:21 2016
FILE NAME: fileset.f90
PROGRAM NAME: fileset
FORMAT LIST

  LINE    LOOP      FORTRAN STATEMENT

     1:             != 出力ファイルの基本情報管理
     2:             != Management basic information for output files
     3:             ! 
     4:             ! Authors::   Yasuhiro MORIKAWA
     5:             ! Version::   $Id: fileset.f90,v 1.3 2009/03/03 15:57:35 morikawa Exp $ 
     6:             ! Tag Name::  $Name:  $
     7:             ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     8:             ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
     9:             !
    10:             
    11:             module fileset
    12:               !
    13:               != 出力ファイルの基本情報管理
    14:               !
    15:               != Management basic information for output files
    16:               !
    17:               ! <b>Note that Japanese and English are described in parallel.</b>
    18:               !
    19:               !== Variables List
    20:               !
    21:               ! FileTitle        :: 出力データファイルの表題
    22:               ! FileSource       :: データファイル作成の手段
    23:               ! FileInstitution  :: データファイルを最終的に変更した組織/個人
    24:               ! ------------     :: ------------
    25:               ! FileTitle        :: Title of output data files
    26:               ! FileSource       :: Source of data file
    27:               ! FileInstitution  :: Institution or person that changes data files for the last time
    28:               !
    29:               !
    30:               !== Procedures List
    31:               !
    32:               ! FilesetInit   :: fileset モジュールの初期化
    33:               ! ------------  :: ------------
    34:               ! FilesetInit   :: Initialize "fileset" module
    35:               !
    36:               !
    37:               !== NAMELIST
    38:               !
    39:               ! NAMELIST#fileset_nml
    40:               !
    41:             
    42:               ! モジュール引用 ; USE statements
    43:               !
    44:             
    45:               ! 種別型パラメタ
    46:               ! Kind type parameter
    47:               !
    48:               use dc_types, only: STRING ! 文字列.       Strings. 
    49:             
    50:               ! 宣言文 ; Declaration statements
    51:               !
    52:               implicit none
    53:               private
    54:             
    55:               ! 公開手続き
    56:               ! Public procedure
    57:               !
    58:               public:: FilesetInit
    59:             
    60:               ! 公開変数
    61:               ! Public variables
    62:               !
    63:               logical, save, public:: fileset_inited = .false.
    64:                                           ! 初期設定フラグ. 
    65:                                           ! Initialization flag
    66:             
    67:               character(STRING), save, public:: FileTitle
    68:                                           ! 出力データファイルの表題.
    69:                                           ! Title of output data files
    70:               character(STRING), save, public:: FileSource
    71:                                           ! データファイル作成の手段. 
    72:                                           ! Source of data file
    73:               character(STRING), save, public:: FileInstitution
    74:                                           ! データファイルを最終的に変更した組織/個人. 
    75:                                           ! Institution or person that changes data files for the last time
    76:             
    77:             
    78:               ! 非公開変数
    79:               ! Private variables
    80:               !
    81:             
    82:               character(*), parameter:: module_name = 'fileset'
    83:                                           ! モジュールの名称. 
    84:                                           ! Module name
    85:               character(*), parameter:: version = &
    86:                 & '$Name:  $' // &
    87:                 & '$Id: fileset.f90,v 1.3 2009/03/03 15:57:35 morikawa Exp $'
    88:                                           ! モジュールのバージョン
    89:                                           ! Module version
    90:             
    91:               ! INTERFACE 文 ; INTERFACE statements
    92:               !
    93:               interface FilesetInit
    94:                 module procedure FilesetInit
    95:               end interface
    96:             
    97:             contains
    98:             
    99:               subroutine FilesetInit
   100:                 !
   101:                 ! fileset モジュールの初期化を行います. 
   102:                 ! NAMELIST#fileset_nml の読み込みはこの手続きで行われます. 
   103:                 !
   104:                 ! "fileset" module is initialized. 
   105:                 ! NAMELIST#fileset_nml is loaded in this procedure. 
   106:                 !
   107:             
   108:                 ! モジュール引用 ; USE statements
   109:                 !
   110:             
   111:                 ! NAMELIST ファイル入力に関するユーティリティ
   112:                 ! Utilities for NAMELIST file input
   113:                 !
   114:                 use namelist_util, only: namelist_filename, NmlutilMsg
   115:             
   116:                 ! ファイル入出力補助
   117:                 ! File I/O support
   118:                 !
   119:                 use dc_iounit, only: FileOpen
   120:             
   121:                 ! 種別型パラメタ
   122:                 ! Kind type parameter
   123:                 !
   124:                 use dc_types, only: STDOUT ! 標準出力の装置番号. Unit number of standard output
   125:             
   126:                 ! メッセージ出力
   127:                 ! Message output
   128:                 !
   129:                 use dc_message, only: MessageNotify
   130:             
   131:                 ! 宣言文 ; Declaration statements
   132:                 !
   133:                 implicit none
   134:                 integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号. 
   135:                                           ! Unit number for NAMELIST file open
   136:                 integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT. 
   137:                                           ! IOSTAT of NAMELIST read
   138:             
   139:                 ! NAMELIST 変数群
   140:                 ! NAMELIST group name
   141:                 !
   142:                 namelist /fileset_nml/ &
   143:                   & FileTitle, FileSource, FileInstitution
   144:                       !
   145:                       ! デフォルト値については初期化手続 "fileset#FilesetInit" 
   146:                       ! のソースコードを参照のこと. 
   147:                       !
   148:                       ! Refer to source codes in the initialization procedure
   149:                       ! "fileset#FilesetInit" for the default values. 
   150:                       !
   151:             
   152:                 ! 実行文 ; Executable statement
   153:                 !
   154:             
   155:                 if ( fileset_inited ) return
   156:                 call InitCheck
   157:             
   158:                 ! デフォルト値の設定
   159:                 ! Default values settings
   160:                 !
   161:                 FileTitle  = 'dcpam5 test run'
   162:                 FileSource = 'dcpam5 $Name:  $ (http://www.gfd-dennou.org/library/dcpam)'
   163:                 FileInstitution = 'GFD Dennou Club (http://www.gfd-dennou.org)'
   164:             
   165:                 ! NAMELIST の読み込み
   166:                 ! NAMELIST is input
   167:                 !
   168:                 if ( trim(namelist_filename) /= '' ) then
   169:                   call FileOpen( unit_nml, &          ! (out)
   170:                     & namelist_filename, mode = 'r' ) ! (in)
   171:             
   172:                   rewind( unit_nml )
   173:                   read( unit_nml, &         ! (in)
   174:                     & nml = fileset_nml, &  ! (out)
   175:                     & iostat = iostat_nml ) ! (out)
   176:                   close( unit_nml )
   177:             
   178:                   call NmlutilMsg( iostat_nml, module_name ) ! (in)
   179:                   if ( iostat_nml == 0 ) write( STDOUT, nml = fileset_nml )
   180:                 end if
   181:             
   182:                 ! 印字 ; Print
   183:                 !
   184:                 call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   185:                 call MessageNotify( 'M', module_name, '  FileTitle       = %c', c1 = trim(FileTitle) )
   186:                 call MessageNotify( 'M', module_name, '  FileSource      = %c', c1 = trim(FileSource) )
   187:                 call MessageNotify( 'M', module_name, '  FileInstitution = %c', c1 = trim(FileInstitution) )
   188:                 call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   189:             
   190:                 fileset_inited = .true.
   191:               end subroutine FilesetInit
   192:             
   193:               subroutine InitCheck
   194:                 !
   195:                 ! 依存モジュールの初期化チェック
   196:                 !
   197:                 ! Check initialization of dependency modules
   198:             
   199:                 ! モジュール引用 ; USE statements
   200:                 !
   201:             
   202:                 ! NAMELIST ファイル入力に関するユーティリティ
   203:                 ! Utilities for NAMELIST file input
   204:                 !
   205:                 use namelist_util, only: namelist_util_inited
   206:             
   207:                 ! メッセージ出力
   208:                 ! Message output
   209:                 !
   210:                 use dc_message, only: MessageNotify
   211:             
   212:                 ! 実行文 ; Executable statement
   213:                 !
   214:             
   215:                 if ( .not. namelist_util_inited ) &
   216:                   & call MessageNotify( 'E', module_name, '"namelist_util" module is not initialized.' )
   217:             
   218:               end subroutine InitCheck
   219:             
   220:             end module fileset
