!= 出力ファイルの基本情報管理
!= Management basic information for output files
! 
! Authors::   Yasuhiro MORIKAWA
! Version::   $Id: fileset.f90,v 1.3 2009/03/03 15:57:35 morikawa Exp $ 
! Tag Name::  $Name:  $
! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

module fileset
  !
  != 出力ファイルの基本情報管理
  !
  != Management basic information for output files
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  !== Variables List
  !
  ! FileTitle        :: 出力データファイルの表題
  ! FileSource       :: データファイル作成の手段
  ! FileInstitution  :: データファイルを最終的に変更した組織/個人
  ! ------------     :: ------------
  ! FileTitle        :: Title of output data files
  ! FileSource       :: Source of data file
  ! FileInstitution  :: Institution or person that changes data files for the last time
  !
  !
  !== Procedures List
  !
  ! FilesetInit   :: fileset モジュールの初期化
  ! ------------  :: ------------
  ! FilesetInit   :: Initialize "fileset" module
  !
  !
  !== NAMELIST
  !
  ! NAMELIST#fileset_nml
  !

  ! モジュール引用 ; USE statements
  !

  ! 種別型パラメタ
  ! Kind type parameter
  !
  use dc_types, only: STRING ! 文字列.       Strings. 

  ! 宣言文 ; Declaration statements
  !
  implicit none
  private

  ! 公開手続き
  ! Public procedure
  !
  public:: FilesetInit

  ! 公開変数
  ! Public variables
  !
  logical, save, public:: fileset_inited = .false.
                              ! 初期設定フラグ. 
                              ! Initialization flag

  character(STRING), save, public:: FileTitle
                              ! 出力データファイルの表題.
                              ! Title of output data files
  character(STRING), save, public:: FileSource
                              ! データファイル作成の手段. 
                              ! Source of data file
  character(STRING), save, public:: FileInstitution
                              ! データファイルを最終的に変更した組織/個人. 
                              ! Institution or person that changes data files for the last time


  ! 非公開変数
  ! Private variables
  !

  character(*), parameter:: module_name = 'fileset'
                              ! モジュールの名称. 
                              ! Module name
  character(*), parameter:: version = &
    & '$Name:  $' // &
    & '$Id: fileset.f90,v 1.3 2009/03/03 15:57:35 morikawa Exp $'
                              ! モジュールのバージョン
                              ! Module version

  ! INTERFACE 文 ; INTERFACE statements
  !
  interface FilesetInit
    module procedure FilesetInit
  end interface

contains

  subroutine FilesetInit
    !
    ! fileset モジュールの初期化を行います. 
    ! NAMELIST#fileset_nml の読み込みはこの手続きで行われます. 
    !
    ! "fileset" module is initialized. 
    ! NAMELIST#fileset_nml is loaded in this procedure. 
    !

    ! モジュール引用 ; USE statements
    !

    ! NAMELIST ファイル入力に関するユーティリティ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: namelist_filename, NmlutilMsg

    ! ファイル入出力補助
    ! File I/O support
    !
    use dc_iounit, only: FileOpen

    ! 種別型パラメタ
    ! Kind type parameter
    !
    use dc_types, only: STDOUT ! 標準出力の装置番号. Unit number of standard output

    ! メッセージ出力
    ! Message output
    !
    use dc_message, only: MessageNotify

    ! 宣言文 ; Declaration statements
    !
    implicit none
    integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号. 
                              ! Unit number for NAMELIST file open
    integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT. 
                              ! IOSTAT of NAMELIST read

    ! NAMELIST 変数群
    ! NAMELIST group name
    !
    namelist /fileset_nml/ &
      & FileTitle, FileSource, FileInstitution
          !
          ! デフォルト値については初期化手続 "fileset#FilesetInit" 
          ! のソースコードを参照のこと. 
          !
          ! Refer to source codes in the initialization procedure
          ! "fileset#FilesetInit" for the default values. 
          !

    ! 実行文 ; Executable statement
    !

    if ( fileset_inited ) return
    call InitCheck

    ! デフォルト値の設定
    ! Default values settings
    !
    FileTitle  = 'dcpam5 test run'
    FileSource = 'dcpam5 $Name:  $ (http://www.gfd-dennou.org/library/dcpam)'
    FileInstitution = 'GFD Dennou Club (http://www.gfd-dennou.org)'

    ! NAMELIST の読み込み
    ! NAMELIST is input
    !
    if ( trim(namelist_filename) /= '' ) then
      call FileOpen( unit_nml, &          ! (out)
        & namelist_filename, mode = 'r' ) ! (in)

      rewind( unit_nml )
      read( unit_nml, &         ! (in)
        & nml = fileset_nml, &  ! (out)
        & iostat = iostat_nml ) ! (out)
      close( unit_nml )

      call NmlutilMsg( iostat_nml, module_name ) ! (in)
      if ( iostat_nml == 0 ) write( STDOUT, nml = fileset_nml )
    end if

    ! 印字 ; Print
    !
    call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
    call MessageNotify( 'M', module_name, '  FileTitle       = %c', c1 = trim(FileTitle) )
    call MessageNotify( 'M', module_name, '  FileSource      = %c', c1 = trim(FileSource) )
    call MessageNotify( 'M', module_name, '  FileInstitution = %c', c1 = trim(FileInstitution) )
    call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )

    fileset_inited = .true.
  end subroutine FilesetInit

  subroutine InitCheck
    !
    ! 依存モジュールの初期化チェック
    !
    ! Check initialization of dependency modules

    ! モジュール引用 ; USE statements
    !

    ! NAMELIST ファイル入力に関するユーティリティ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: namelist_util_inited

    ! メッセージ出力
    ! Message output
    !
    use dc_message, only: MessageNotify

    ! 実行文 ; Executable statement
    !

    if ( .not. namelist_util_inited ) &
      & call MessageNotify( 'E', module_name, '"namelist_util" module is not initialized.' )

  end subroutine InitCheck

end module fileset
