Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:22 2016
FILE NAME: i.axesset.F90
PROGRAM NAME: axesset
DIAGNOSTIC LIST

  LINE  LEVEL( NO.): DIAGNOSTIC MESSAGE

   429  opt  (  11): Fused array assignments. :line 429 - 439
   429  vec  (   4): Vectorized array expression.
   429  vec  (  29): ADB is used for array.: sidepth
   429  vec  (  29): ADB is used for array.: depth
   429  vec  (  29): ADB is used for array.: sigma
   473  opt  (1084): Branch out of the loop inhibits optimization.
   473  vec  (   4): Vectorized array expression.
   473  vec  (  29): ADB is used for array.: sigma
   473  vec  (   4): Vectorized array expression.
   473  vec  (  26): Macro operation Search.
   493  vec  (   3): Unvectorized loop.
   495  opt  (1017): Subroutine call prevents optimization.
   495  vec  (  10): Vectorization obstructive procedure reference.:messagenotifyc
   497  vec  (  10): Vectorization obstructive procedure reference.:messagenotifyc
   504  vec  (   4): Vectorized array expression.
   504  vec  (  24): Iteration count is assumed. Iteration count=256
   504  vec  (  29): ADB is used for array.: r_sigma
   504  vec  (  29): ADB is used for array.: sigma
   509  vec  (   1): Vectorized loop.
   509  vec  (  29): ADB is used for array.: z_sigma
   509  vec  (  29): ADB is used for array.: z_delsigma
   509  vec  (  29): ADB is used for array.: r_sigma
   531  vec  (   1): Vectorized loop.
   531  vec  (  29): ADB is used for array.: r_delsigma
   531  vec  (  29): ADB is used for array.: z_sigma
   539  opt  (1084): Branch out of the loop inhibits optimization.
   539  vec  (   4): Vectorized array expression.
   539  vec  (  29): ADB is used for array.: depth
   539  vec  (   4): Vectorized array expression.
   539  vec  (  26): Macro operation Search.
   540  vec  (   4): Vectorized array expression.
   540  vec  (  24): Iteration count is assumed. Iteration count=256
   540  vec  (  29): ADB is used for array.: depth
   549  opt  (1084): Branch out of the loop inhibits optimization.
   549  vec  (   4): Vectorized array expression.
   549  vec  (  24): Iteration count is assumed. Iteration count=255
   549  vec  (  29): ADB is used for array.: depth
   549  vec  (   4): Vectorized array expression.
   549  vec  (  26): Macro operation Search.
   550  vec  (   3): Unvectorized loop.
   551  opt  (1017): Subroutine call prevents optimization.
   551  vec  (  10): Vectorization obstructive procedure reference.:messagenotifyc
   557  vec  (   3): Unvectorized loop.
   559  opt  (1017): Subroutine call prevents optimization.
   559  vec  (  10): Vectorization obstructive procedure reference.:messagenotifyc
   561  vec  (  10): Vectorization obstructive procedure reference.:messagenotifyc
   565  vec  (   4): Vectorized array expression.
   565  vec  (  24): Iteration count is assumed. Iteration count=256
   565  vec  (  29): ADB is used for array.: r_ssdepth
   565  vec  (  29): ADB is used for array.: depth
   567  vec  (   3): Unvectorized loop.
   568  opt  (1017): Subroutine call prevents optimization.
   568  vec  (  10): Vectorization obstructive procedure reference.:messagenotifyc
   575  vec  (   1): Vectorized loop.
   575  vec  (  29): ADB is used for array.: z_ssdepth
   575  vec  (  29): ADB is used for array.: r_ssdepth
   583  opt  (1084): Branch out of the loop inhibits optimization.
   583  vec  (   4): Vectorized array expression.
   583  vec  (  29): ADB is used for array.: sidepth
   583  vec  (   4): Vectorized array expression.
   583  vec  (  26): Macro operation Search.
   584  vec  (   4): Vectorized array expression.
   584  vec  (  24): Iteration count is assumed. Iteration count=256
   584  vec  (  29): ADB is used for array.: sidepth
   593  opt  (1084): Branch out of the loop inhibits optimization.
   593  vec  (   4): Vectorized array expression.
   593  vec  (  24): Iteration count is assumed. Iteration count=255
   593  vec  (  29): ADB is used for array.: sidepth
   593  vec  (   4): Vectorized array expression.
   593  vec  (  26): Macro operation Search.
   594  vec  (   3): Unvectorized loop.
   595  opt  (1017): Subroutine call prevents optimization.
   595  vec  (  10): Vectorization obstructive procedure reference.:messagenotifyc
   601  vec  (   3): Unvectorized loop.
   603  opt  (1017): Subroutine call prevents optimization.
   603  vec  (  10): Vectorization obstructive procedure reference.:messagenotifyc
   605  vec  (  10): Vectorization obstructive procedure reference.:messagenotifyc
   609  vec  (   4): Vectorized array expression.
   609  vec  (  24): Iteration count is assumed. Iteration count=256
   609  vec  (  29): ADB is used for array.: r_sidepth
   609  vec  (  29): ADB is used for array.: sidepth
   611  vec  (   3): Unvectorized loop.
   612  opt  (1017): Subroutine call prevents optimization.
   612  vec  (  10): Vectorization obstructive procedure reference.:messagenotifyc
   619  vec  (   1): Vectorized loop.
   619  vec  (  29): ADB is used for array.: z_sidepth
   619  vec  (  29): ADB is used for array.: r_sidepth
   634  vec  (   4): Vectorized array expression.
   634  vec  (  29): ADB is used for array.: x_lon
   635  vec  (   4): Vectorized array expression.
   635  vec  (  29): ADB is used for array.: x_lon_weight
   636  vec  (   4): Vectorized array expression.
   636  vec  (  29): ADB is used for array.: y_lat
   637  vec  (   4): Vectorized array expression.
   637  vec  (  29): ADB is used for array.: y_lat_weight
   649  vec  (   4): Vectorized array expression.
   649  vec  (  29): ADB is used for array.: x_lon
   649  vec  (  29): ADB is used for array.: spml_x_lon
   650  vec  (   4): Vectorized array expression.
   650  vec  (  29): ADB is used for array.: x_lon_weight
   650  vec  (  29): ADB is used for array.: spml_x_lon_weight
   651  vec  (   4): Vectorized array expression.
   651  vec  (  29): ADB is used for array.: y_lat
   651  vec  (  29): ADB is used for array.: spml_y_lat
   652  vec  (   4): Vectorized array expression.
   652  vec  (  29): ADB is used for array.: y_lat_weight
   652  vec  (  29): ADB is used for array.: spml_y_lat_weight
   670  vec  (   1): Vectorized loop.
   670  vec  (  29): ADB is used for array.: w_number
   695  vec  (   4): Vectorized array expression.
   695  vec  (  29): ADB is used for array.: x_lon
   699  vec  (   4): Vectorized array expression.
   699  vec  (  29): ADB is used for array.: y_lat
   794  vec  (   4): Vectorized array expression.
   794  vec  (  29): ADB is used for array.: ary
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:22 2016
FILE NAME: i.axesset.F90
PROGRAM NAME: axesset
TRANSFORMATION LIST

  LINE                   FORTRAN STATEMENT

     1  != 座標データ設定
     2  !
     3  != Axes data settings
     4  !
     5  ! Authors::   Yoshiyuki O. Takahashi, Yasuhiro MORIKAWA
     6  ! Version::   $Id: axesset.F90,v 1.20 2014/05/07 09:39:21 murashin Exp $
     7  ! Tag Name::  $Name:  $
     8  ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9  ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10  !
    11  
    12  module axesset
    13    !
    14    != 座標データ設定
    15    !
    16    != Axes data settings
    17    !
    18    ! <b>Note that Japanese and English are described in parallel.</b>
    19    !
    20    ! 座標データの設定および保管を行います.
    21    !
    22    ! 緯度 $ \varphi $ および経度 $ \lambda $ の格子点は,
    23    ! gridset モジュールで設定される格子点数から,
    24    ! {SPMODEL ライブラリ}[http://www.gfd-dennou.org/library/spmodel]
    25    ! を用いて決定されます.
    26    ! 緯度の格子点の位置はガウス緯度,
    27    ! 経度の格子点の位置は等間隔にとることになります.
    28    !
    29    ! 鉛直σの格子点は, 半整数レベル (各層の端) について
    30    ! NAMELIST#Sigma に指定します.
    31    ! 整数レベル (各層の中心点) は, 半整数レベルと constants
    32    ! モジュールで設定される乾燥大気の定圧比熱 $ C_p $ および
    33    ! 乾燥大気の気体定数 $ R $ を用いて決定します.
    34    ! 鉛直σの格子点については, sigma_data モジュールで用意されている
    35    ! ものを使用することも可能です.
    36    !
    37    ! Axes data is set and stored.
    38    !
    39    ! Grid points of latitude $ \varphi $ and longitude $ \lambda $ are
    40    ! determined
    41    ! with number of grid points configured in "gridset" module
    42    ! by {SPMODEL Library}[http://www.gfd-dennou.org/library/spmodel/index.htm.en]
    43    ! Grid points of latitude becomes Gaussian latitude,
    44    ! and grid points of latitude becomes equally spaced.
    45    !
    46    !== Variables List
    47    !
    48    ! x_Lon               :: 経度座標
    49    ! x_Lon_Weight        :: 経度座標重み
    50    ! DeltaLon            :: 経度格子点間隔
    51    ! InvDeltaLon         :: 経度格子点間隔の逆数
    52    ! y_Lat               :: 緯度座標
    53    ! y_Lat_Weight        :: 緯度座標重み
    54    ! z_Sigma             :: $ \sigma $ レベル (整数)
    55    ! r_Sigma             :: $ \sigma $ レベル (半整数)
    56    ! z_DelSigma          :: $ \Delta \sigma $ (整数)
    57    ! r_DelSigma          :: $ \Delta \sigma $ (半整数)
    58    ! w_Number            :: スペクトルデータの添字番号
    59    ! spml_inited         :: SPML ライブラリの初期設定フラグ
    60    ! ------------        :: ------------
    61    ! x_Lon               :: Longitude
    62    ! x_Lon_Weight        :: Weight of longitude
    63    ! DeltaLon            :: Interval of longitude grids
    64    ! InvDeltaLon         :: Inverse of DeltaLon
    65    ! y_Lat               :: Latitude
    66    ! y_Lat_Weight        :: Weight of latitude
    67    ! z_Sigma             :: Full $ \sigma $ level
    68    ! r_Sigma             :: Half $ \sigma $ level
    69    ! z_DelSigma          :: $ \Delta \sigma $ (Full)
    70    ! r_DelSigma          :: $ \Delta \sigma $ (Half)
    71    ! w_Number            :: Subscript of spectral data
    72    ! spml_inited         :: Initialization flag of SPML library
    73    !
    74    !== Procedures List
    75    !
    76    ! AxessetInit     :: 座標データの設定
    77    ! AxessetFinalize :: 終了処理 (モジュール内部の変数の割り付け解除)
    78    ! ------------    :: ------------
    79    ! AxessetInit     :: Settings of axes data
    80    ! AxessetFinalize :: Termination (deallocate variables in this module)
    81    !
    82  
    83    ! モジュール引用 ; USE statements
    84    !
    85  
    86    ! 格子点設定
    87    ! Grid points settings
    88    !
    89    use gridset, only: &
    90      &                nmax       , & ! 最大全波数.
    91                                      ! Maximum truncated wavenumber
    92      &                lmax       , & ! スペクトルデータの配列サイズ
    93                                      ! Size of array for spectral data
    94      &                imax       , & ! 経度格子点数.
    95                                      ! Number of grid points in longitude
    96      &                jmax_global, & ! 緯度格子点数 (全球).
    97                                      ! Number of grid points in latitude on whole globe
    98      &                jmax       , & ! 緯度格子点数.
    99                                      ! Number of grid points in latitude
   100      &                kmax       , & ! 鉛直層数.
   101                                      ! Number of vertical level
   102      &                kslmax     , & ! 地下の鉛直層数.
   103                                      ! Number of subsurface vertical level
   104      &                ksimax         ! 海氷の鉛直層数.
   105                                      ! Number of sea ice vertical level
   106  
   107    ! 種別型パラメタ
   108    ! Kind type parameter
   109    !
   110    use dc_types, only: DP,     & ! 倍精度実数型. Double precision.
   111                        STRING    ! 文字列. Strings.
   112  
   113    ! NAMELIST ファイル入力に関するユーティリティ
   114    ! Utilities for NAMELIST file input
   115    !
   116    use namelist_util, only: MaxNmlArySize
   117                                ! NAMELIST から読み込む配列の最大サイズ.
   118                                ! Maximum size of arrays loaded from NAMELIST
   119  
   120    ! 宣言文 ; Declaration statements
   121    !
   122    implicit none
   123    private
   124  
   125    ! 公開手続き
   126    ! Public procedure
   127    !
   128    public:: AxessetInit, AxessetFinalize
   129  
   130    ! 公開変数
   131    ! Public variables
   132    !
   133    logical, save, public:: axesset_inited = .false.
   134                                ! 初期設定フラグ.
   135                                ! Initialization flag
   136  
   137    real(DP), allocatable, save, public:: x_Lon (:)
   138                                ! $ \lambda $ [rad.] . 経度. Longitude
   139    real(DP), allocatable, save, public:: x_Lon_Weight (:)
   140                                ! $ \Delta \lambda $ [rad.] .
   141                                ! 経度座標重み.
   142                                ! Weight of longitude
   143    real(DP), allocatable, save, public:: y_Lat (:)
   144                                ! $ \varphi $ [rad.] . 緯度. Latitude
   145    real(DP), allocatable, save, public:: y_Lat_Weight (:)
   146                                ! $ \Delta \varphi $ [rad.] .
   147                                ! 緯度座標重み.
   148                                ! Weight of latitude
   149    real(DP), allocatable, save, public:: z_Sigma (:)
   150                                ! $ \sigma $ レベル (整数).
   151                                ! Full $ \sigma $ level
   152    real(DP), allocatable, save, public:: r_Sigma (:)
   153                                ! $ \sigma $ レベル (半整数).
   154                                ! Half $ \sigma $ level
   155    real(DP), allocatable, save, public:: z_DelSigma (:)
   156                                ! $ \Delta \sigma $ (整数).
   157                                ! $ \Delta \sigma $ (Full)
   158    real(DP), allocatable, save, public:: r_DelSigma (:)
   159                                ! $ \Delta \sigma $ (半整数).
   160                                ! $ \Delta \sigma $ (half)
   161    integer, allocatable, save, public:: w_Number (:)
   162                                ! スペクトルデータの添字番号.
   163                                ! Subscript of spectral data
   164    real(DP), allocatable, save, public:: z_SSDepth(:)
   165                                ! 地下の格子点の深さ
   166                                ! subsurface grid at midpoint of layer
   167    real(DP), allocatable, save, public:: r_SSDepth(:)
   168                                ! 地下の層の境界面の深さ
   169                                ! subsurface grid on interface of layer
   170    real(DP), allocatable, save, public:: z_SIDepth(:)
   171                                ! 海氷の格子点の深さ
   172                                ! sea ice grid at midpoint of layer
   173    real(DP), allocatable, save, public:: r_SIDepth(:)
   174                                ! 海氷の層の境界面の深さ
   175                                ! sea ice grid on interface of layer
   176    real(DP), save, public:: DeltaLon
   177                                ! 経度格子点間隔.
   178                                ! grid interval in longitude
   179    real(DP), save, public:: InvDeltaLon
   180                                ! 経度格子点間隔の逆数.
   181                                ! Inverse of the grid interval in longitude
   182  
   183  
   184    logical, save, public:: spml_inited = .false.
   185                                ! SPML ライブラリの初期設定フラグ.
   186                                ! Initialization flag of SPML library
   187  
   188    character(STRING), parameter, public :: AxnameX   = 'lon'
   189                                ! axis name for x
   190    character(STRING), parameter, public :: AxnameY   = 'lat'
   191                                ! axis name for y
   192    character(STRING), parameter, public :: AxnameZ   = 'sig'
   193                                ! axis name for z
   194    character(STRING), parameter, public :: AxnameR   = 'sigm'
   195                                ! axis name for r
   196    character(STRING), parameter, public :: AxnameSSZ = 'ssz'
   197                                ! axis name for z (subsurface)
   198    character(STRING), parameter, public :: AxnameSSR = 'sszi'
   199                                ! axis name for r (subsurface)
   200    character(STRING), parameter, public :: AxnameSIZ = 'siz'
   201                                ! axis name for z (sea ice)
   202    character(STRING), parameter, public :: AxnameSIR = 'sizi'
   203                                ! axis name for r (sea ice)
   204    character(STRING), parameter, public :: AxnameWN  = 'wn'
   205                                ! axis name for wavenumber
   206    character(STRING), parameter, public :: AxnameT   = 'time'
   207                                ! axis name for t
   208  
   209  
   210    ! 非公開変数
   211    ! Private variables
   212    !
   213    real(DP), save:: Sigma (1:MaxNmlArySize)
   214                                ! $ \sigma $ レベル (半整数).
   215                                ! Half $ \sigma $ level
   216    real(DP), save:: Depth(1:MaxNmlArySize)
   217                                ! 入力用配列, 地下の鉛直層境界
   218                                ! array for input, layer interface of subsurface
   219                                ! vertical layer
   220    real(DP), save:: SIDepth(1:MaxNmlArySize)
   221                                ! 入力用配列, 海氷の鉛直層境界
   222                                ! array for input, layer interface of sea ice
   223                                ! vertical layer
   224  
   225    character(*), parameter:: module_name = 'axesset'
   226                                ! モジュールの名称.
   227                                ! Module name
   228    character(*), parameter:: version = &
   229      & '$Name:  $' // &
   230      & '$Id: axesset.F90,v 1.20 2014/05/07 09:39:21 murashin Exp $'
   231                                ! モジュールのバージョン
   232                                ! Module version
   233  
   234  contains
   235  
   236    !--------------------------------------------------------------------------------------
   237  
   238    subroutine AxessetInit
   239      !
   240      ! axesset モジュールの初期化を行います.
   241      ! NAMELIST#axesset_nml の読み込みはこの手続きで行われます.
   242      !
   243      ! "axesset" module is initialized.
   244      ! NAMELIST#axesset_nml is loaded in this procedure.
   245      !
   246  
   247      ! モジュール引用 ; USE statements
   248      !
   249  
   250      ! 物理・数学定数設定
   251      ! Physical and mathematical constants settings
   252      !
   253      use constants0, only: PI      ! $ \pi $ .
   254                                    ! 円周率.  Circular constant
   255  
   256      ! 物理定数設定
   257      ! Physical constants settings
   258      !
   259      use constants, only: &
   260        &                  CpDry, & ! $ C_p $ [J kg-1 K-1].
   261                                    ! 乾燥大気の定圧比熱.
   262                                    ! Specific heat of air at constant pressure
   263        &                  GasRDry  ! $ R $ [J kg-1 K-1].
   264                                    ! 乾燥大気の気体定数.
   265                                    ! Gas constant of air
   266  
   267      ! 格子点数・最大波数設定
   268      ! Number of grid points and maximum truncated wavenumber settings
   269      !
   270      use gridset, only: GridsetCheckNumberOfLatGrid
   271  
   272      ! SPMODEL ライブラリ, 球面上の問題を球面調和函数変換により解く(多層対応)
   273      ! SPMODEL library, problems on sphere are solved with spherical harmonics
   274      ! (multi layer is supported)
   275      !
   276  
   277  
   278      use wa_mpi_module, only: wa_mpi_Initial, &
   279        & spml_x_Lon        => x_Lon, &
   280                                ! $ \lambda $ [rad.] . 経度. Longitude
   281        & spml_x_Lon_Weight => x_Lon_Weight, &
   282                                ! $ \Delta \lambda $ [rad.] .
   283                                ! 経度座標重み.
   284                                ! Weight of longitude
   285        & spml_y_Lat        => v_Lat, &
   286                                ! $ \varphi $ [rad.] . 緯度. Latitude
   287        & spml_y_Lat_Weight => v_Lat_Weight, &
   288                                ! $ \Delta \varphi $ [rad.] .
   289                                ! 緯度座標重み.
   290                                ! Weight of latitude
   291        & spml_jc => jc
   292  
   293  
   294  
   295      ! 鉛直σレベルデータ準備
   296      ! Prepare vertical sigma level data
   297      !
   298      use sigma_data, only: SigmaDataGetHalf
   299  
   300      ! NAMELIST ファイル入力に関するユーティリティ
   301      ! Utilities for NAMELIST file input
   302      !
   303      use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid
   304  
   305      ! ファイル入出力補助
   306      ! File I/O support
   307      !
   308      use dc_iounit, only: FileOpen
   309  
   310      ! 種別型パラメタ
   311      ! Kind type parameter
   312      !
   313      use dc_types, only: &
   314        &                 STDOUT, &  ! 標準出力の装置番号. Unit number of standard output
   315        &                 TOKEN      ! キーワード.   Keywords.
   316  
   317      ! メッセージ出力
   318      ! Message output
   319      !
   320      use dc_message, only: MessageNotify
   321  
   322      ! 文字列操作
   323      ! Character handling
   324      !
   325      use dc_string, only: CPrintf
   326  
   327      ! OpenMP
   328      !
   329      !$ use omp_lib
   330  
   331  
   332      ! 宣言文 ; Declaration statements
   333      !
   334      implicit none
   335  
   336      ! 作業変数
   337      ! Work variables
   338      !
   339      logical:: flag_generate_sigma
   340                                ! 鉛直層数の内部生成のためのフラグ
   341                                ! Flag for generation of sigma levels internally
   342      integer:: i               ! スペクトルの添字番号で回る DO ループ用作業変数
   343                                ! Work variables for DO loop in subscript of spectral data
   344      integer:: k               ! 鉛直方向に回る DO ループ用作業変数
   345                                ! Work variables for DO loop in vertical direction
   346      real(DP):: Kappa          ! $ \kappa = R / C_p $ .
   347                                ! 乾燥大気における, 気体定数の定圧比熱に対する比.
   348                                ! Ratio of gas constant to specific heat in dry air
   349  
   350      real(DP):: LonInDeg       ! Longitude in unit of degree of a grid point in 1D mode
   351      real(DP):: LatInDeg       ! Latitude in unit of degree of a grid point in 1D mode
   352  
   353      integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号.
   354                                ! Unit number for NAMELIST file open
   355      integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT.
   356                                ! IOSTAT of NAMELIST read
   357  
   358      integer:: OMPNumThreads
   359                                ! OpenMP での最大スレッド数.
   360                                ! openmp_threads に 1 より大きな値を指定すれば
   361                                ! ISPACK[http://www.gfd-dennou.org/library/ispack/]
   362                                ! の球面調和函数変換 OpenMP 並列計算
   363                                ! ルーチンが用いられる. 並列計算を実行するには,
   364                                ! 実行時に環境変数 OMP_NUM_THREADS
   365                                ! を OMPNumThreads 以下の数字に設定する
   366                                ! 等のシステムに応じた準備が必要となる.
   367                                !
   368                                ! OMPNumThreads に 1 より大きな値を
   369                                ! 指定しなければ並列計算ルーチンは呼ばれない.
   370  
   371      character(TOKEN):: rank_str
   372                                ! ランク数. Rank number
   373      integer:: myrank_mpi      ! 総プロセス数. Number of total processes
   374      integer:: nprocs_mpi      ! 自身のプロセス. Number of my process
   375      integer:: ra              ! MPI のランク数方向に回る DO ループ用作業変数
   376                                ! Work variables for DO loop in rank number of MPI direction
   377  
   378      ! NAMELIST 変数群
   379      ! NAMELIST group name
   380      !
   381      namelist /axesset_nml/ &
   382        & Sigma, Depth, SIDepth, flag_generate_sigma, &
   383        & LonInDeg, LatInDeg
   384            !
   385            ! デフォルト値については初期化手続 "axesset#AxessetInit"
   386            ! のソースコードを参照のこと.
   387            !
   388            ! Refer to source codes in the initialization procedure
   389            ! "axesset#AxessetInit" for the default values.
   390            !
   391  
   392      ! 実行文 ; Executable statement
   393      !
   394  
   395      if ( axesset_inited ) return
   396  
   397  
   398      !
   399      ! Set number of OpenMP threads
   400      !
   401      OMPNumThreads = 1
   402      !$ OMPNumThreads = omp_get_max_threads()
   403  
   404  
   405      ! 割り付け
   406      ! Allocation
   407      !
   408      allocate( z_Sigma      (1:kmax)   )
   409      allocate( r_Sigma      (0:kmax)   )
   410      allocate( z_DelSigma   (1:kmax)   )
   411      allocate( r_DelSigma   (0:kmax)   )
   412      allocate( w_Number     (1:lmax)   )
   413  
   414      allocate( r_SSDepth( 0:kslmax ) )
   415      allocate( z_SSDepth( 1:kslmax ) )
   416  
   417      allocate( r_SIDepth( 0:ksimax ) )
   418  !!!! Modified by M.Ishiwatari (2016-12-10)
   419  !!!!    allocate( z_SIDepth( 1:ksimax ) )
   420      allocate( z_SIDepth( 0:ksimax ) )
   421  
   422      ! デフォルト値の設定
   423      ! Default values settings
   424      !
   425  
   426      ! Sigma (半整数レベルσ) の初期値 (無効な値) の設定
   427      ! Setting of initial value (invalid value) of "Sigma" (half level sigma)
   428      !
   429      Sigma = -999.0d0
     .  !cdir nodep                                                             
     .  !cdir on_adb(sigma,depth,sidepth)                                       
     .        do t1109 = 0, 255                                                 
   430  
   431      ! 地下の層の境界面深さの初期値 (無効な値) の設定
   432      ! Setting of initial value (invalid value) of depth of subsurface layer interface
   433      !
   434      Depth = -999.0d0
   435  
   436      ! 海氷の層の境界面深さの初期値 (無効な値) の設定
   437      ! Setting of initial value (invalid value) of depth of sea ice layer interface
   438      !
   439      SIDepth = -999.0d0
   440  
   441      ! 鉛直層数の内部生成のためのフラグの設定
   442      ! Setting of flag for generation of sigma levels internally
   443      !
   444      flag_generate_sigma = .false.
   445  
   446      ! Longitude in unit of degree of a grid point in 1D mode
   447      !
   448      LonInDeg = 0.0_DP
   449  
   450      ! Latitude in unit of degree of a grid point in 1D mode
   451      !
   452      LatInDeg  = 0.0_DP
   453  
   454      ! NAMELIST の読み込み
   455      ! NAMELIST is input
   456      !
   457      if ( trim(namelist_filename) /= '' ) then
   458        call FileOpen( unit_nml, &          ! (out)
   459          & namelist_filename, mode = 'r' ) ! (in)
   460  
   461        rewind( unit_nml )
   462        read( unit_nml, &         ! (in)
   463          & nml = axesset_nml, &  ! (out)
   464          & iostat = iostat_nml ) ! (out)
   465        close( unit_nml )
   466  
   467        call NmlutilMsg( iostat_nml, module_name ) ! (in)
   468      end if
   469  
   470      ! Sigma (半整数レベルσ) の自動設定
   471      ! Automation setting of "Sigma" (half level sigma)
   472      !
   473      if ( all( Sigma == -999.0d0 ) ) then
     .  !cdir    nodep                                                          
     .  !cdir on_adb(sigma)                                                     
     .        do t1114 = 0, 255                                                 
   474        if ( flag_generate_sigma ) then
   475          call SigmaDataGetHalf( Sigma(1:kmax+1) ) ! (out)
   476        else
   477          call MessageNotify( 'E', module_name, &
   478            & '  Sigma levels have to be specified if flag_generate_sigma is not true.' )
   479        end if
   480      end if
   481  
   482      ! Sigma (半整数レベルσ) チェック
   483      ! Check "Sigma" (half level sigma)
   484      !
   485      if ( Sigma(1) /= 1.0_DP ) then
   486        call MessageNotify( 'E', module_name, '  Sigma(1) is not 1, but is %f', &
   487          & d = (/ Sigma(1) /) )
   488      end if
   489      if ( Sigma(kmax+1) /= 0.0_DP ) then
   490        call MessageNotify( 'E', module_name, '  Sigma(kmax+1) is not 0, but is %f', &
   491          & d = (/ Sigma(kmax+1) /) )
   492      end if
   493      do k = 1, kmax
   494        if ( Sigma(k+1) > Sigma(k) ) then
   495          call MessageNotify( 'M', module_name, '  Sigma(%d) = %f > Sigma(%d) = %f', &
   496              & i = (/ k+1, k /), d = (/ Sigma(k+1), Sigma(k) /) )
   497          call MessageNotify( 'E', module_name, '  Value of Sigma has to decrease with index.' )
   498        end if
   499      end do
   500  
   501      ! r_Sigma (半整数レベルσ) 設定
   502      ! Setting of "r_Sigma" (half level sigma)
   503      !
   504      r_Sigma(0:kmax) = Sigma(1:kmax+1)
     .  !cdir    nodep                                                          
     .  !cdir on_adb(sigma,r_sigma)                                             
     .        do t1118 = 0, kmax                                                
   505  
   506      ! z_DelSigma (整数レベル $ \Delta \sigma $ ) 設定
   507      ! Setting of "z_DelSigma" (full level $ \Delta \sigma $ )
   508      !
   509      do k = 1, kmax
   510        z_DelSigma(k) = r_Sigma(k-1) - r_Sigma(k)
   511      enddo
   512  
   513      ! z_Sigma (整数レベルσ) 設定
   514      ! Setting of "z_Sigma" (full level sigma)
   515      !
   516      Kappa = GasRDry / CpDry
   517      do k = 1, kmax
   518        z_Sigma(k) = &
   519          & ( &
   520          &   (   r_Sigma(k-1) ** ( 1.0_DP + Kappa ) &
   521          &     - r_Sigma(k)   ** ( 1.0_DP + Kappa ) &
   522          &   ) / ( z_DelSigma(k) * ( 1.0_DP + Kappa ) ) &
   523          & ) ** ( 1.0_DP / Kappa )
   524      enddo
     .           kappa = gasrdry/cpdry                                          
     .  !cdir nodep                                                             
     .  !cdir on_adb(r_sigma)                                                   
     .        do k = 1, kmax                                                    
     .           z_delsigma(k) = r_sigma(k-1) - r_sigma(k)                      
     .           z_sigma(k) = ((r_sigma(k-1)**(1.00000000000000e+000+kappa)-    
     .       1      r_sigma(k)**(1.00000000000000e+000+kappa))/(z_delsigma(k)*( 
     .       2      1.00000000000000e+000+kappa)))**(1.00000000000000e+000/kappa
     .       3      )                                                           
     .        enddo                                                             
   525  
   526      ! r_DelSigma (半整数レベル $ \Delta \sigma $ ) 設定
   527      ! Setting of "r_DelSigma" (half level $ \Delta \sigma $ )
   528      !
   529      r_DelSigma(0)    = r_Sigma(0)    - z_Sigma(1)
   530      r_DelSigma(kmax) = z_Sigma(kmax) - r_Sigma(kmax)
   531      do k = 1, kmax - 1
   532        r_DelSigma(k) = z_Sigma(k) - z_Sigma(k+1)
   533      end do
   534  
   535  
   536      ! 地下の層の境界面深さのチェック
   537      ! Check depth of subsurface layer interface
   538      !
   539      if ( all( Depth == -999.0d0 ) ) then
     .  !cdir    nodep                                                          
     .  !cdir on_adb(depth)                                                     
     .        do t1122 = 0, 255                                                 
   540        Depth(0+1:kslmax+1 ) = 0.0_DP
     .  !cdir    nodep                                                          
     .  !cdir on_adb(depth)                                                     
     .        do t1185 = 0, kslmax                                              
   541        call MessageNotify( 'W', module_name, 'Depth is not found in namelist file.' )
   542      end if
   543      !
   544      if ( Depth(0+1) /= 0.0_DP ) then
   545        call MessageNotify( 'E', module_name, '  Depth(0) is not zero, but is %f', &
   546          & d = (/ Depth(0+1) /) )
   547      end if
   548      if ( kslmax >= 1 ) then
   549        if ( all( Depth(1+1:kslmax+1) >= 0.0_DP ) ) then
     .  !cdir    nodep                                                          
     .  !cdir on_adb(depth)                                                     
     .        do t1181 = 0, kslmax - 1                                          
   550          do k = 0, kslmax
   551            call MessageNotify( 'M', module_name, '  Depth(%d) = %f', &
   552              & i = (/ k /), d = (/ Depth(k+1) /) )
   553          end do
   554          call MessageNotify( 'E', module_name, '  Depth has to be zero or negative.' )
   555        end if
   556      end if
   557      do k = 0, kslmax-1
   558        if ( Depth(k+1+1) > Depth(k+1) ) then
   559          call MessageNotify( 'M', module_name, '  Depth(%d) = %f > Depth(%d) = %f', &
   560              & i = (/ k+1, k /), d = (/ Depth(k+1+1), Depth(k+1) /) )
   561          call MessageNotify( 'E', module_name, '  Value of Depth has to decrease with index.' )
   562        end if
   563      end do
   564  
   565      r_SSDepth(0:kslmax) = Depth(1:kslmax+1)
     .  !cdir    nodep                                                          
     .  !cdir on_adb(depth,r_ssdepth)                                           
     .        do t1126 = 0, kslmax                                              
   566  
   567      do k = 0, kslmax
   568        call MessageNotify( 'M', module_name, '  r_SSDepth(%d) = %f', &
   569          i = (/ k /), d = (/ r_SSDepth(k) /) )
   570      end do
   571  
   572      ! 地下の鉛直層の中心点の設定
   573      ! Set midpoint of subsurface grid
   574      !
   575      do k = 1, kslmax
   576        z_SSDepth( k ) = ( r_SSDepth( k-1 ) + r_SSDepth( k ) ) / 2.0d0
   577      end do
     .           d1 = 1.D0/2.00000000000000e+000                                
     .  !cdir nodep                                                             
     .  !cdir on_adb(r_ssdepth)                                                 
     .        do k = 1, kslmax                                                  
     .           z_ssdepth(k) = (r_ssdepth(k-1)+r_ssdepth(k))*d1                
     .        enddo                                                             
   578  
   579  
   580      ! 海氷の層の境界面深さのチェック
   581      ! Check depth of sea ice layer interface
   582      !
   583      if ( all( SIDepth == -999.0d0 ) ) then
     .  !cdir nodep                                                             
     .  !cdir on_adb(sidepth)                                                   
     .        do t1130 = 0, 255                                                 
   584        SIDepth(0+1:ksimax+1 ) = 0.0_DP
     .  !cdir    nodep                                                          
     .  !cdir on_adb(sidepth)                                                   
     .        do t1178 = 0, ksimax                                              
   585        call MessageNotify( 'W', module_name, 'SIDepth is not found in namelist file.' )
   586      end if
   587      !
   588      if ( SIDepth(0+1) /= 0.0_DP ) then
   589        call MessageNotify( 'E', module_name, '  SIDepth(0) is not zero, but is %f', &
   590          & d = (/ SIDepth(0+1) /) )
   591      end if
   592      if ( ksimax >= 1 ) then
   593        if ( all( SIDepth(1+1:ksimax+1) >= 0.0_DP ) ) then
     .  !cdir    nodep                                                          
     .  !cdir on_adb(sidepth)                                                   
     .        do t1174 = 0, ksimax - 1                                          
   594          do k = 0, ksimax
   595            call MessageNotify( 'M', module_name, '  SIDepth(%d) = %f', &
   596              & i = (/ k /), d = (/ SIDepth(k+1) /) )
   597          end do
   598          call MessageNotify( 'E', module_name, '  SIDepth has to be zero or negative.' )
   599        end if
   600      end if
   601      do k = 0, ksimax-1
   602        if ( SIDepth(k+1+1) > SIDepth(k+1) ) then
   603          call MessageNotify( 'M', module_name, '  SIDepth(%d) = %f > SIDepth(%d) = %f', &
   604              & i = (/ k+1, k /), d = (/ SIDepth(k+1+1), SIDepth(k+1) /) )
   605          call MessageNotify( 'E', module_name, '  Value of SIDepth has to decrease with index.' )
   606        end if
   607      end do
   608  
   609      r_SIDepth(0:ksimax) = SIDepth(1:ksimax+1)
     .  !cdir    nodep                                                          
     .  !cdir on_adb(sidepth,r_sidepth)                                         
     .        do t1134 = 0, ksimax                                              
   610  
   611      do k = 0, ksimax
   612        call MessageNotify( 'M', module_name, '  r_SIDepth(%d) = %f', &
   613          i = (/ k /), d = (/ r_SIDepth(k) /) )
   614      end do
   615  
   616      ! 地下の鉛直層の中心点の設定
   617      ! Set midpoint of subsurface grid
   618      !
   619      do k = 1, ksimax
   620        z_SIDepth( k ) = ( r_SIDepth( k-1 ) + r_SIDepth( k ) ) / 2.0d0
   621      end do
     .           d2 = 1.D0/2.00000000000000e+000                                
     .  !cdir nodep                                                             
     .  !cdir on_adb(r_sidepth)                                                 
     .        do k = 1, ksimax                                                  
     .           z_sidepth(k) = (r_sidepth(k-1)+r_sidepth(k))*d2                
     .        enddo                                                             
   622  
   623  
   624      ! 緯度経度の設定
   625      ! Settings of longitude and latitude
   626      !
   627      allocate( x_Lon        (0:imax-1) )
   628      allocate( x_Lon_Weight (0:imax-1) )
   629      allocate( y_Lat        (1:jmax)   )
   630      allocate( y_Lat_Weight (1:jmax)   )
   631  
   632      if ( ( imax == 1 ) .and. ( jmax == 1 ) ) then
   633  
   634        x_Lon          = LonInDeg * PI / 180.0_DP
     .        d3 = lonindeg/1.80000000000000e+002                               
     .  !cdir nodep                                                             
     .        do t1162 = 1, x_lon.DSC.U1 + 1 - x_lon.DSC.L1                     
     .           x_lon(t11+t1162-1) = 3.14159265358979e+000*d3                  
     .        enddo                                                             
   635        x_Lon_Weight   = 1.0_DP
   636        y_Lat          = LatInDeg * PI / 180.0_DP
     .           d4 = latindeg/1.80000000000000e+002                            
     .  !cdir nodep                                                             
     .        do t1168 = 1, y_lat.DSC.U1 + 1 - y_lat.DSC.L1                     
     .           y_lat(t64+t1168-1) = 3.14159265358979e+000*d4                  
     .        enddo                                                             
   637        y_Lat_Weight   = 1.0_DP
   638  
   639      else
   640        if ( .not. spml_inited ) then
   641  
   642          call wa_mpi_Initial( nmax, imax, jmax_global, kmax, OMPNumThreads ) ! (in)
   643          ! Check number of latitudinal grid on each process
   644          call GridsetCheckNumberOfLatGrid( spml_jc )
   645  
   646          spml_inited = .true.
   647        end if
   648  
   649        x_Lon          = spml_x_Lon
   650        x_Lon_Weight   = spml_x_Lon_Weight
   651        y_Lat          = spml_y_Lat
   652        y_Lat_Weight   = spml_y_Lat_Weight
   653      end if
   654  
   655      if ( imax /= 1  ) then
   656        ! DeltaLon, InvDeltaLonの計算
   657        ! Caluculate DeltaLon and InvDeltaLon
   658        DeltaLon = x_Lon(1) - x_Lon(0)
   659        InvDeltaLon = 1.0_DP/DeltaLon
   660      else
   661        DeltaLon = 0.0_DP
   662        InvDeltaLon = 0.0_DP ! not used
   663      endif
   664  
   665  
   666  
   667      ! スペクトルデータの添字番号の設定
   668      ! Settings of subscript of spectral data
   669      !
   670      do i = 1, size(w_Number)
   671        w_Number(i) = i
   672      end do
   673  
   674      ! ランクに関する情報の取得
   675      ! Get information about rank
   676      !
   677      myrank_mpi = -1
   678      nprocs_mpi = 1
   679      rank_str = ''
   680  
   681  
   682      ! 印字 ; Print
   683      !
   684      call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   685  
   686  
   687      call MessageNotify( 'M', module_name, 'SJPACK : %c', c1 = 'not used.' )
   688  
   689  
   690      call MessageNotify( 'M', module_name, 'OMPNumThreads = %d', i = (/OMPNumThreads/) )
   691  
   692      do ra = 0, nprocs_mpi - 1
   693  
   694        call MessageNotify( 'M', module_name, 'Axes:%c', c1 = trim(rank_str), rank_mpi = -1 )
   695        call MessageNotify( 'M', module_name, '  x_Lon(%d:%d) [deg.] = %*f', &
   696          & i = (/ 0, imax - 1/), &
   697          & d = format_print(x_Lon / PI * 180.0_DP, imax), &
   698          & n =(/ imax /), rank_mpi = -1 )
   699        call MessageNotify( 'M', module_name, '  y_Lat(%d:%d) [deg.] = %*f', &
   700          & i = (/ 1, jmax/), &
   701          & d = format_print(y_Lat / PI * 180.0_DP, jmax), &
   702          & n =(/ jmax /), rank_mpi = -1 )
   703        call MessageNotify( 'M', module_name, '  z_Sigma(%d:%d) = %*f', &
   704          & i = (/ 1, kmax /), &
   705          & d = format_print(z_Sigma, kmax), n =(/ kmax /), rank_mpi = -1 )
   706        call MessageNotify( 'M', module_name, '  r_Sigma(%d:%d) = %*f', &
   707          & i = (/ 0, kmax /), &
   708          & d = format_print(r_Sigma, kmax+1), n =(/ kmax+1 /), rank_mpi = -1 )
   709        call MessageNotify( 'M', module_name, '  w_Number(%d:%d) = %d .. %d', &
   710          & i = (/ 1, size(w_Number), 1, size(w_Number) /), rank_mpi = -1 )
   711    !
   712        call MessageNotify( 'M', module_name, 'Weight:' )
   713        call MessageNotify( 'M', module_name, '  x_Lon_Weight(%d:%d) = %*f', &
   714          & i = (/ 0, imax - 1/), &
   715          & d = format_print(x_Lon_Weight, imax), n =(/ imax /), rank_mpi = -1 )
   716        call MessageNotify( 'M', module_name, '  y_Lat_Weight(%d:%d) = %*f', &
   717          & i = (/ 1, jmax/), &
   718          & d = format_print(y_Lat_Weight, jmax), n =(/ jmax /), rank_mpi = -1 )
   719        call MessageNotify( 'M', module_name, '  z_DelSigma(%d:%d) = %*f', &
   720          & i = (/ 1, kmax /), &
   721          & d = format_print(z_DelSigma, kmax), n =(/ kmax /), rank_mpi = -1 )
   722        call MessageNotify( 'M', module_name, '' )
   723      end do
     .           call f_null (%0000e7)                                          
     .        call fy_chtrim (%0000e7, %0000e6, rank_str, 32)                   
     .        call messagenotifyc ('M', module_name, 'Axes:%c', 1, 1, 1, 1, 1,  
     .       1   %0000e7, 1, 1, 1, -1, 1, 7, 7, %0000e6, 0, 0, 0)               
     .        deallocate (%0000e7)                                              
     .        %IG28(1) = 0                                                      
     .        %IG28(2) = imax - 1                                               
     .        t11 = x_lon.DSC.L1                                                
     .        %IG29.DSC.U1 = x_lon.DSC.U1 - t11 + 1                             
     .        allocate (%IG29(1:x_lon.DSC.U1-t11+1))                            
     .        d5 = 1.D0/3.14159265358979e+000                                   
     .  !cdir nodep                                                             
     .        do t1154 = 1, x_lon.DSC.U1 + 1 - x_lon.DSC.L1                     
     .           %IG29(t1154) = x_lon(t11+t1154-1)*d5*1.80000000000000e+002     
     .        enddo                                                             
     .        call f_null (%0000ea)                                             
     .        call format_print (%0000ea, %IG29, imax)                          
     .        %IG32(1) = imax                                                   
     .        call messagenotifyc ('M', module_name,                            
     .       1   '  x_Lon(%d:%d) [deg.] = %*f', %IG28, 1, %0000ea, 1, %IG32, 1, 
     .       2   1, 1, 1, -1, 1, 7, 27, 0, 0, 0, 0)                             
     .        deallocate (%0000ea)                                              
     .        deallocate (%IG29)                                                
     .        %IG33(1) = 1                                                      
     .        %IG33(2) = jmax                                                   
     .        t64 = y_lat.DSC.L1                                                
     .        %IG34.DSC.U1 = y_lat.DSC.U1 - t64 + 1                             
     .        allocate (%IG34(1:y_lat.DSC.U1-t64+1))                            
     .        d6 = 1.D0/3.14159265358979e+000                                   
     .  !cdir nodep                                                             
     .        do t1158 = 1, y_lat.DSC.U1 + 1 - y_lat.DSC.L1                     
     .           %IG34(t1158) = y_lat(t64+t1158-1)*d6*1.80000000000000e+002     
     .        enddo                                                             
     .        call f_null (%0000ee)                                             
     .        call format_print (%0000ee, %IG34, jmax)                          
     .        %IG37(1) = jmax                                                   
     .        call messagenotifyc ('M', module_name,                            
     .       1   '  y_Lat(%d:%d) [deg.] = %*f', %IG33, 1, %0000ee, 1, %IG37, 1, 
     .       2   1, 1, 1, -1, 1, 7, 27, 0, 0, 0, 0)                             
     .        deallocate (%0000ee)                                              
     .        deallocate (%IG34)                                                
     .        %IG38(1) = 1                                                      
     .        %IG38(2) = kmax                                                   
     .        call f_null (%0000f2)                                             
     .        call format_print (%0000f2, z_sigma, kmax)                        
     .        %IG39(1) = kmax                                                   
     .        call messagenotifyc ('M', module_name, '  z_Sigma(%d:%d) = %*f',  
     .       1   %IG38, 1, %0000f2, 1, %IG39, 1, 1, 1, 1, -1, 1, 7, 22, 0, 0, 0 
     .       2   , 0)                                                           
     .        deallocate (%0000f2)                                              
     .        %IG40(1) = 0                                                      
     .        %IG40(2) = kmax                                                   
     .        call f_null (%0000f6)                                             
     .        call format_print (%0000f6, r_sigma, kmax + 1)                    
     .        %IG42(1) = kmax + 1                                               
     .        call messagenotifyc ('M', module_name, '  r_Sigma(%d:%d) = %*f',  
     .       1   %IG40, 1, %0000f6, 1, %IG42, 1, 1, 1, 1, -1, 1, 7, 22, 0, 0, 0 
     .       2   , 0)                                                           
     .        deallocate (%0000f6)                                              
     .        %IG43(1) = 1                                                      
     .        %IG43(2) = size(w_number,1)                                       
     .        %IG43(3) = 1                                                      
     .        %IG43(4) = size(w_number,1)                                       
     .        call messagenotifyc ('M', module_name,                            
     .       1   '  w_Number(%d:%d) = %d .. %d', %IG43, 1, 1, 1, 1, 1, 1, 1, 1, 
     .       2   -1, 1, 7, 28, 0, 0, 0, 0)                                      
     .        call messagenotifyc ('M', module_name, 'Weight:', 1, 1, 1, 1, 1, 1
     .       1   , 1, 1, 1, 1, 1, 7, 7, 0, 0, 0, 0)                             
     .        %IG44(1) = 0                                                      
     .        %IG44(2) = imax - 1                                               
     .        call f_null (%0000fe)                                             
     .        call format_print (%0000fe, x_lon_weight, imax)                   
     .        %IG45(1) = imax                                                   
     .        call messagenotifyc ('M', module_name,                            
     .       1   '  x_Lon_Weight(%d:%d) = %*f', %IG44, 1, %0000fe, 1, %IG45, 1, 
     .       2   1, 1, 1, -1, 1, 7, 27, 0, 0, 0, 0)                             
     .        deallocate (%0000fe)                                              
     .        %IG46(1) = 1                                                      
     .        %IG46(2) = jmax                                                   
     .        call f_null (%000102)                                             
     .        call format_print (%000102, y_lat_weight, jmax)                   
     .        %IG47(1) = jmax                                                   
     .        call messagenotifyc ('M', module_name,                            
     .       1   '  y_Lat_Weight(%d:%d) = %*f', %IG46, 1, %000102, 1, %IG47, 1, 
     .       2   1, 1, 1, -1, 1, 7, 27, 0, 0, 0, 0)                             
     .        deallocate (%000102)                                              
     .        %IG48(1) = 1                                                      
     .        %IG48(2) = kmax                                                   
     .        call f_null (%000106)                                             
     .        call format_print (%000106, z_delsigma, kmax)                     
     .        %IG49(1) = kmax                                                   
     .        call messagenotifyc ('M', module_name, '  z_DelSigma(%d:%d) = %*f'
     .       1   , %IG48, 1, %000106, 1, %IG49, 1, 1, 1, 1, -1, 1, 7, 25, 0, 0, 
     .       2   0, 0)                                                          
     .        deallocate (%000106)                                              
     .        call messagenotifyc ('M', module_name, '', 1, 1, 1, 1, 1, 1, 1, 1 
     .       1   , 1, 1, 1, 7, 0, 0, 0, 0, 0)                                   
   724  
   725      call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version), rank_mpi = -1 )
   726  
   727      axesset_inited = .true.
   728  
   729    end subroutine AxessetInit
   730  
   731    !--------------------------------------------------------------------------------------
   732  
   733    subroutine AxessetFinalize
   734      !
   735      ! モジュール内部の変数の割り付け解除を行います.
   736      !
   737      ! Deallocate variables in this module.
   738      !
   739  
   740      ! モジュール引用 ; USE statements
   741      !
   742  
   743      ! 宣言文 ; Declaration statements
   744      !
   745      implicit none
   746  
   747      ! 実行文 ; Executable statement
   748      !
   749  
   750      if ( .not. axesset_inited ) return
   751  
   752      ! 割り付け解除
   753      ! Deallocation
   754      !
   755      if ( allocated( z_Sigma    ) ) deallocate( z_Sigma    )
   756      if ( allocated( r_Sigma    ) ) deallocate( r_Sigma    )
   757      if ( allocated( z_DelSigma ) ) deallocate( z_DelSigma )
   758      if ( allocated( r_DelSigma ) ) deallocate( r_DelSigma )
   759      if ( allocated( w_Number   ) ) deallocate( w_Number   )
   760  
   761      if ( allocated( r_SSDepth ) ) deallocate( r_SSDepth )
   762      if ( allocated( z_SSDepth ) ) deallocate( z_SSDepth )
   763  
   764      if ( allocated( r_SIDepth ) ) deallocate( r_SIDepth )
   765      if ( allocated( z_SIDepth ) ) deallocate( z_SIDepth )
   766  
   767      if ( allocated( x_Lon        ) ) deallocate( x_Lon        )
   768      if ( allocated( x_Lon_Weight ) ) deallocate( x_Lon_Weight )
   769      if ( allocated( y_Lat        ) ) deallocate( y_Lat        )
   770      if ( allocated( y_Lat_Weight ) ) deallocate( y_Lat_Weight )
   771  
   772      axesset_inited = .false.
   773  
   774    end subroutine AxessetFinalize
   775  
   776    !--------------------------------------------------------------------------------------
   777  
   778    function format_print( ary, size ) result(result)
   779      !
   780      ! 標準出力して見やすいように適当に有効数字の桁を落として返す.
   781      !
   782      ! Effective digit is reduced for output to standard output and returned.
   783      !
   784  
   785      ! 宣言文 ; Declaration statements
   786      !
   787      implicit none
   788      integer, intent(in):: size
   789      real(DP), intent(in):: ary(size)
   790      real(DP):: result(size)
   791  
   792      ! 実行文 ; Executable statement
   793      !
   794      result(1:size) = int( ary(1:size) * 1000.0_DP ) / 1000.0_DP
     .        d1 = 1.D0/1.00000000000000e+003                                   
     .  !cdir nodep                                                             
     .        do t26 = 1, size                                                  
     .           result(t26) = dfloat(ifix(ary(t26)*1.00000000000000e+003))*d1  
     .        enddo                                                             
   795  
   796    end function format_print
   797  
   798    !--------------------------------------------------------------------------------------
   799  
   800  end module axesset
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:22 2016
FILE NAME: i.axesset.F90
PROGRAM NAME: axesset
FORMAT LIST

  LINE    LOOP      FORTRAN STATEMENT

     1:             != 座標データ設定
     2:             !
     3:             != Axes data settings
     4:             !
     5:             ! Authors::   Yoshiyuki O. Takahashi, Yasuhiro MORIKAWA
     6:             ! Version::   $Id: axesset.F90,v 1.20 2014/05/07 09:39:21 murashin Exp $ 
     7:             ! Tag Name::  $Name:  $
     8:             ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9:             ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10:             !
    11:             
    12:             module axesset
    13:               !
    14:               != 座標データ設定
    15:               !
    16:               != Axes data settings
    17:               !
    18:               ! <b>Note that Japanese and English are described in parallel.</b>
    19:               !
    20:               ! 座標データの設定および保管を行います. 
    21:               ! 
    22:               ! 緯度 $ \varphi $ および経度 $ \lambda $ の格子点は, 
    23:               ! gridset モジュールで設定される格子点数から, 
    24:               ! {SPMODEL ライブラリ}[http://www.gfd-dennou.org/library/spmodel]
    25:               ! を用いて決定されます. 
    26:               ! 緯度の格子点の位置はガウス緯度, 
    27:               ! 経度の格子点の位置は等間隔にとることになります. 
    28:               ! 
    29:               ! 鉛直σの格子点は, 半整数レベル (各層の端) について 
    30:               ! NAMELIST#Sigma に指定します. 
    31:               ! 整数レベル (各層の中心点) は, 半整数レベルと constants 
    32:               ! モジュールで設定される乾燥大気の定圧比熱 $ C_p $ および
    33:               ! 乾燥大気の気体定数 $ R $ を用いて決定します. 
    34:               ! 鉛直σの格子点については, sigma_data モジュールで用意されている
    35:               ! ものを使用することも可能です. 
    36:               !
    37:               ! Axes data is set and stored. 
    38:               !
    39:               ! Grid points of latitude $ \varphi $ and longitude $ \lambda $ are
    40:               ! determined 
    41:               ! with number of grid points configured in "gridset" module
    42:               ! by {SPMODEL Library}[http://www.gfd-dennou.org/library/spmodel/index.htm.en]
    43:               ! Grid points of latitude becomes Gaussian latitude, 
    44:               ! and grid points of latitude becomes equally spaced. 
    45:               !
    46:               !== Variables List
    47:               !
    48:               ! x_Lon               :: 経度座標
    49:               ! x_Lon_Weight        :: 経度座標重み
    50:               ! DeltaLon            :: 経度格子点間隔
    51:               ! InvDeltaLon         :: 経度格子点間隔の逆数
    52:               ! y_Lat               :: 緯度座標
    53:               ! y_Lat_Weight        :: 緯度座標重み
    54:               ! z_Sigma             :: $ \sigma $ レベル (整数)
    55:               ! r_Sigma             :: $ \sigma $ レベル (半整数)
    56:               ! z_DelSigma          :: $ \Delta \sigma $ (整数)
    57:               ! r_DelSigma          :: $ \Delta \sigma $ (半整数)
    58:               ! w_Number            :: スペクトルデータの添字番号
    59:               ! spml_inited         :: SPML ライブラリの初期設定フラグ
    60:               ! ------------        :: ------------
    61:               ! x_Lon               :: Longitude
    62:               ! x_Lon_Weight        :: Weight of longitude
    63:               ! DeltaLon            :: Interval of longitude grids
    64:               ! InvDeltaLon         :: Inverse of DeltaLon
    65:               ! y_Lat               :: Latitude
    66:               ! y_Lat_Weight        :: Weight of latitude
    67:               ! z_Sigma             :: Full $ \sigma $ level
    68:               ! r_Sigma             :: Half $ \sigma $ level
    69:               ! z_DelSigma          :: $ \Delta \sigma $ (Full)
    70:               ! r_DelSigma          :: $ \Delta \sigma $ (Half)
    71:               ! w_Number            :: Subscript of spectral data
    72:               ! spml_inited         :: Initialization flag of SPML library
    73:               !
    74:               !== Procedures List
    75:               !
    76:               ! AxessetInit     :: 座標データの設定
    77:               ! AxessetFinalize :: 終了処理 (モジュール内部の変数の割り付け解除)
    78:               ! ------------    :: ------------
    79:               ! AxessetInit     :: Settings of axes data
    80:               ! AxessetFinalize :: Termination (deallocate variables in this module)
    81:               !
    82:             
    83:               ! モジュール引用 ; USE statements
    84:               !
    85:             
    86:               ! 格子点設定
    87:               ! Grid points settings
    88:               !
    89:               use gridset, only: &
    90:                 &                nmax       , & ! 最大全波数. 
    91:                                                 ! Maximum truncated wavenumber
    92:                 &                lmax       , & ! スペクトルデータの配列サイズ
    93:                                                 ! Size of array for spectral data
    94:                 &                imax       , & ! 経度格子点数. 
    95:                                                 ! Number of grid points in longitude
    96:                 &                jmax_global, & ! 緯度格子点数 (全球). 
    97:                                                 ! Number of grid points in latitude on whole globe
    98:                 &                jmax       , & ! 緯度格子点数. 
    99:                                                 ! Number of grid points in latitude
   100:                 &                kmax       , & ! 鉛直層数. 
   101:                                                 ! Number of vertical level
   102:                 &                kslmax     , & ! 地下の鉛直層数.
   103:                                                 ! Number of subsurface vertical level
   104:                 &                ksimax         ! 海氷の鉛直層数.
   105:                                                 ! Number of sea ice vertical level
   106:             
   107:               ! 種別型パラメタ
   108:               ! Kind type parameter
   109:               !
   110:               use dc_types, only: DP,     & ! 倍精度実数型. Double precision. 
   111:                                   STRING    ! 文字列. Strings.
   112:             
   113:               ! NAMELIST ファイル入力に関するユーティリティ
   114:               ! Utilities for NAMELIST file input
   115:               !
   116:               use namelist_util, only: MaxNmlArySize
   117:                                           ! NAMELIST から読み込む配列の最大サイズ. 
   118:                                           ! Maximum size of arrays loaded from NAMELIST
   119:             
   120:               ! 宣言文 ; Declaration statements
   121:               !
   122:               implicit none
   123:               private
   124:             
   125:               ! 公開手続き
   126:               ! Public procedure
   127:               !
   128:               public:: AxessetInit, AxessetFinalize
   129:             
   130:               ! 公開変数
   131:               ! Public variables
   132:               !
   133:               logical, save, public:: axesset_inited = .false.
   134:                                           ! 初期設定フラグ. 
   135:                                           ! Initialization flag
   136:             
   137:               real(DP), allocatable, save, public:: x_Lon (:)
   138:                                           ! $ \lambda $ [rad.] . 経度. Longitude
   139:               real(DP), allocatable, save, public:: x_Lon_Weight (:)
   140:                                           ! $ \Delta \lambda $ [rad.] . 
   141:                                           ! 経度座標重み. 
   142:                                           ! Weight of longitude
   143:               real(DP), allocatable, save, public:: y_Lat (:)
   144:                                           ! $ \varphi $ [rad.] . 緯度. Latitude
   145:               real(DP), allocatable, save, public:: y_Lat_Weight (:)
   146:                                           ! $ \Delta \varphi $ [rad.] . 
   147:                                           ! 緯度座標重み. 
   148:                                           ! Weight of latitude
   149:               real(DP), allocatable, save, public:: z_Sigma (:)
   150:                                           ! $ \sigma $ レベル (整数). 
   151:                                           ! Full $ \sigma $ level
   152:               real(DP), allocatable, save, public:: r_Sigma (:)
   153:                                           ! $ \sigma $ レベル (半整数). 
   154:                                           ! Half $ \sigma $ level
   155:               real(DP), allocatable, save, public:: z_DelSigma (:)
   156:                                           ! $ \Delta \sigma $ (整数). 
   157:                                           ! $ \Delta \sigma $ (Full)
   158:               real(DP), allocatable, save, public:: r_DelSigma (:)
   159:                                           ! $ \Delta \sigma $ (半整数). 
   160:                                           ! $ \Delta \sigma $ (half)
   161:               integer, allocatable, save, public:: w_Number (:)
   162:                                           ! スペクトルデータの添字番号. 
   163:                                           ! Subscript of spectral data
   164:               real(DP), allocatable, save, public:: z_SSDepth(:)
   165:                                           ! 地下の格子点の深さ
   166:                                           ! subsurface grid at midpoint of layer
   167:               real(DP), allocatable, save, public:: r_SSDepth(:)
   168:                                           ! 地下の層の境界面の深さ
   169:                                           ! subsurface grid on interface of layer
   170:               real(DP), allocatable, save, public:: z_SIDepth(:)
   171:                                           ! 海氷の格子点の深さ
   172:                                           ! sea ice grid at midpoint of layer
   173:               real(DP), allocatable, save, public:: r_SIDepth(:)
   174:                                           ! 海氷の層の境界面の深さ
   175:                                           ! sea ice grid on interface of layer
   176:               real(DP), save, public:: DeltaLon
   177:                                           ! 経度格子点間隔. 
   178:                                           ! grid interval in longitude
   179:               real(DP), save, public:: InvDeltaLon
   180:                                           ! 経度格子点間隔の逆数. 
   181:                                           ! Inverse of the grid interval in longitude
   182:             
   183:             
   184:               logical, save, public:: spml_inited = .false.
   185:                                           ! SPML ライブラリの初期設定フラグ. 
   186:                                           ! Initialization flag of SPML library
   187:             
   188:               character(STRING), parameter, public :: AxnameX   = 'lon'
   189:                                           ! axis name for x
   190:               character(STRING), parameter, public :: AxnameY   = 'lat'
   191:                                           ! axis name for y
   192:               character(STRING), parameter, public :: AxnameZ   = 'sig'
   193:                                           ! axis name for z
   194:               character(STRING), parameter, public :: AxnameR   = 'sigm'
   195:                                           ! axis name for r
   196:               character(STRING), parameter, public :: AxnameSSZ = 'ssz'
   197:                                           ! axis name for z (subsurface)
   198:               character(STRING), parameter, public :: AxnameSSR = 'sszi'
   199:                                           ! axis name for r (subsurface)
   200:               character(STRING), parameter, public :: AxnameSIZ = 'siz'
   201:                                           ! axis name for z (sea ice)
   202:               character(STRING), parameter, public :: AxnameSIR = 'sizi'
   203:                                           ! axis name for r (sea ice)
   204:               character(STRING), parameter, public :: AxnameWN  = 'wn'
   205:                                           ! axis name for wavenumber
   206:               character(STRING), parameter, public :: AxnameT   = 'time'
   207:                                           ! axis name for t
   208:             
   209:             
   210:               ! 非公開変数
   211:               ! Private variables
   212:               !
   213:               real(DP), save:: Sigma (1:MaxNmlArySize)
   214:                                           ! $ \sigma $ レベル (半整数). 
   215:                                           ! Half $ \sigma $ level
   216:               real(DP), save:: Depth(1:MaxNmlArySize)
   217:                                           ! 入力用配列, 地下の鉛直層境界
   218:                                           ! array for input, layer interface of subsurface 
   219:                                           ! vertical layer
   220:               real(DP), save:: SIDepth(1:MaxNmlArySize)
   221:                                           ! 入力用配列, 海氷の鉛直層境界
   222:                                           ! array for input, layer interface of sea ice 
   223:                                           ! vertical layer
   224:             
   225:               character(*), parameter:: module_name = 'axesset'
   226:                                           ! モジュールの名称. 
   227:                                           ! Module name
   228:               character(*), parameter:: version = &
   229:                 & '$Name:  $' // &
   230:                 & '$Id: axesset.F90,v 1.20 2014/05/07 09:39:21 murashin Exp $'
   231:                                           ! モジュールのバージョン
   232:                                           ! Module version
   233:             
   234:             contains
   235:             
   236:               !--------------------------------------------------------------------------------------
   237:             
   238:               subroutine AxessetInit
   239:                 !
   240:                 ! axesset モジュールの初期化を行います. 
   241:                 ! NAMELIST#axesset_nml の読み込みはこの手続きで行われます. 
   242:                 !
   243:                 ! "axesset" module is initialized. 
   244:                 ! NAMELIST#axesset_nml is loaded in this procedure. 
   245:                 !
   246:             
   247:                 ! モジュール引用 ; USE statements
   248:                 !
   249:             
   250:                 ! 物理・数学定数設定
   251:                 ! Physical and mathematical constants settings
   252:                 !
   253:                 use constants0, only: PI      ! $ \pi $ .
   254:                                               ! 円周率.  Circular constant
   255:             
   256:                 ! 物理定数設定
   257:                 ! Physical constants settings
   258:                 !
   259:                 use constants, only: &
   260:                   &                  CpDry, & ! $ C_p $ [J kg-1 K-1]. 
   261:                                               ! 乾燥大気の定圧比熱. 
   262:                                               ! Specific heat of air at constant pressure
   263:                   &                  GasRDry  ! $ R $ [J kg-1 K-1]. 
   264:                                               ! 乾燥大気の気体定数. 
   265:                                               ! Gas constant of air
   266:             
   267:                 ! 格子点数・最大波数設定
   268:                 ! Number of grid points and maximum truncated wavenumber settings
   269:                 !
   270:                 use gridset, only: GridsetCheckNumberOfLatGrid
   271:             
   272:                 ! SPMODEL ライブラリ, 球面上の問題を球面調和函数変換により解く(多層対応) 
   273:                 ! SPMODEL library, problems on sphere are solved with spherical harmonics 
   274:                 ! (multi layer is supported)
   275:                 !
   276:             
   277:             
   278:                 use wa_mpi_module, only: wa_mpi_Initial, &
   279:                   & spml_x_Lon        => x_Lon, & 
   280:                                           ! $ \lambda $ [rad.] . 経度. Longitude
   281:                   & spml_x_Lon_Weight => x_Lon_Weight, &
   282:                                           ! $ \Delta \lambda $ [rad.] . 
   283:                                           ! 経度座標重み. 
   284:                                           ! Weight of longitude
   285:                   & spml_y_Lat        => v_Lat, &
   286:                                           ! $ \varphi $ [rad.] . 緯度. Latitude
   287:                   & spml_y_Lat_Weight => v_Lat_Weight, &
   288:                                           ! $ \Delta \varphi $ [rad.] . 
   289:                                           ! 緯度座標重み. 
   290:                                           ! Weight of latitude
   291:                   & spml_jc => jc
   292:             
   293:             
   294:             
   295:                 ! 鉛直σレベルデータ準備
   296:                 ! Prepare vertical sigma level data
   297:                 !
   298:                 use sigma_data, only: SigmaDataGetHalf
   299:             
   300:                 ! NAMELIST ファイル入力に関するユーティリティ
   301:                 ! Utilities for NAMELIST file input
   302:                 !
   303:                 use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid
   304:             
   305:                 ! ファイル入出力補助
   306:                 ! File I/O support
   307:                 !
   308:                 use dc_iounit, only: FileOpen
   309:             
   310:                 ! 種別型パラメタ
   311:                 ! Kind type parameter
   312:                 !
   313:                 use dc_types, only: &
   314:                   &                 STDOUT, &  ! 標準出力の装置番号. Unit number of standard output
   315:                   &                 TOKEN      ! キーワード.   Keywords. 
   316:             
   317:                 ! メッセージ出力
   318:                 ! Message output
   319:                 !
   320:                 use dc_message, only: MessageNotify
   321:             
   322:                 ! 文字列操作
   323:                 ! Character handling
   324:                 !
   325:                 use dc_string, only: CPrintf
   326:             
   327:                 ! OpenMP
   328:                 !
   329:                 !$ use omp_lib
   330:             
   331:             
   332:                 ! 宣言文 ; Declaration statements
   333:                 !
   334:                 implicit none
   335:             
   336:                 ! 作業変数
   337:                 ! Work variables
   338:                 !
   339:                 logical:: flag_generate_sigma
   340:                                           ! 鉛直層数の内部生成のためのフラグ
   341:                                           ! Flag for generation of sigma levels internally
   342:                 integer:: i               ! スペクトルの添字番号で回る DO ループ用作業変数
   343:                                           ! Work variables for DO loop in subscript of spectral data
   344:                 integer:: k               ! 鉛直方向に回る DO ループ用作業変数
   345:                                           ! Work variables for DO loop in vertical direction
   346:                 real(DP):: Kappa          ! $ \kappa = R / C_p $ .
   347:                                           ! 乾燥大気における, 気体定数の定圧比熱に対する比.
   348:                                           ! Ratio of gas constant to specific heat in dry air
   349:             
   350:                 real(DP):: LonInDeg       ! Longitude in unit of degree of a grid point in 1D mode
   351:                 real(DP):: LatInDeg       ! Latitude in unit of degree of a grid point in 1D mode
   352:             
   353:                 integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号. 
   354:                                           ! Unit number for NAMELIST file open
   355:                 integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT. 
   356:                                           ! IOSTAT of NAMELIST read
   357:             
   358:                 integer:: OMPNumThreads
   359:                                           ! OpenMP での最大スレッド数.
   360:                                           ! openmp_threads に 1 より大きな値を指定すれば 
   361:                                           ! ISPACK[http://www.gfd-dennou.org/library/ispack/] 
   362:                                           ! の球面調和函数変換 OpenMP 並列計算
   363:                                           ! ルーチンが用いられる. 並列計算を実行するには,
   364:                                           ! 実行時に環境変数 OMP_NUM_THREADS 
   365:                                           ! を OMPNumThreads 以下の数字に設定する
   366:                                           ! 等のシステムに応じた準備が必要となる.
   367:                                           !
   368:                                           ! OMPNumThreads に 1 より大きな値を
   369:                                           ! 指定しなければ並列計算ルーチンは呼ばれない.
   370:             
   371:                 character(TOKEN):: rank_str
   372:                                           ! ランク数. Rank number
   373:                 integer:: myrank_mpi      ! 総プロセス数. Number of total processes
   374:                 integer:: nprocs_mpi      ! 自身のプロセス. Number of my process
   375:                 integer:: ra              ! MPI のランク数方向に回る DO ループ用作業変数
   376:                                           ! Work variables for DO loop in rank number of MPI direction
   377:             
   378:                 ! NAMELIST 変数群
   379:                 ! NAMELIST group name
   380:                 !
   381:                 namelist /axesset_nml/ &
   382:                   & Sigma, Depth, SIDepth, flag_generate_sigma, &
   383:                   & LonInDeg, LatInDeg
   384:                       !
   385:                       ! デフォルト値については初期化手続 "axesset#AxessetInit" 
   386:                       ! のソースコードを参照のこと. 
   387:                       !
   388:                       ! Refer to source codes in the initialization procedure
   389:                       ! "axesset#AxessetInit" for the default values. 
   390:                       !
   391:             
   392:                 ! 実行文 ; Executable statement
   393:                 !
   394:             
   395:                 if ( axesset_inited ) return
   396:             
   397:             
   398:                 !
   399:                 ! Set number of OpenMP threads
   400:                 !
   401:                 OMPNumThreads = 1
   402:                 !$ OMPNumThreads = omp_get_max_threads()
   403:             
   404:             
   405:                 ! 割り付け
   406:                 ! Allocation
   407:                 !
   408:                 allocate( z_Sigma      (1:kmax)   )
   409:                 allocate( r_Sigma      (0:kmax)   )
   410:                 allocate( z_DelSigma   (1:kmax)   )
   411:                 allocate( r_DelSigma   (0:kmax)   )
   412:                 allocate( w_Number     (1:lmax)   )
   413:             
   414:                 allocate( r_SSDepth( 0:kslmax ) )
   415:                 allocate( z_SSDepth( 1:kslmax ) )
   416:             
   417:                 allocate( r_SIDepth( 0:ksimax ) )
   418:             !!!! Modified by M.Ishiwatari (2016-12-10)
   419:             !!!!    allocate( z_SIDepth( 1:ksimax ) )
   420:                 allocate( z_SIDepth( 0:ksimax ) )
   421:             
   422:                 ! デフォルト値の設定
   423:                 ! Default values settings
   424:                 !
   425:             
   426:                 ! Sigma (半整数レベルσ) の初期値 (無効な値) の設定
   427:                 ! Setting of initial value (invalid value) of "Sigma" (half level sigma)
   428:                 !
   429: V------>A       Sigma = -999.0d0
   430: |           
   431: |               ! 地下の層の境界面深さの初期値 (無効な値) の設定
   432: |               ! Setting of initial value (invalid value) of depth of subsurface layer interface
   433: |               !
   434: |       A       Depth = -999.0d0
   435: |           
   436: |               ! 海氷の層の境界面深さの初期値 (無効な値) の設定
   437: |               ! Setting of initial value (invalid value) of depth of sea ice layer interface
   438: |               !
   439: V------ A       SIDepth = -999.0d0
   440:             
   441:                 ! 鉛直層数の内部生成のためのフラグの設定
   442:                 ! Setting of flag for generation of sigma levels internally
   443:                 !
   444:                 flag_generate_sigma = .false.
   445:             
   446:                 ! Longitude in unit of degree of a grid point in 1D mode
   447:                 !
   448:                 LonInDeg = 0.0_DP
   449:             
   450:                 ! Latitude in unit of degree of a grid point in 1D mode
   451:                 !
   452:                 LatInDeg  = 0.0_DP
   453:             
   454:                 ! NAMELIST の読み込み
   455:                 ! NAMELIST is input
   456:                 !
   457:                 if ( trim(namelist_filename) /= '' ) then
   458:                   call FileOpen( unit_nml, &          ! (out)
   459:                     & namelist_filename, mode = 'r' ) ! (in)
   460:             
   461:                   rewind( unit_nml )
   462:                   read( unit_nml, &         ! (in)
   463:                     & nml = axesset_nml, &  ! (out)
   464:                     & iostat = iostat_nml ) ! (out)
   465:                   close( unit_nml )
   466:             
   467:                   call NmlutilMsg( iostat_nml, module_name ) ! (in)
   468:                 end if
   469:             
   470:                 ! Sigma (半整数レベルσ) の自動設定
   471:                 ! Automation setting of "Sigma" (half level sigma)
   472:                 !
   473: V====== A       if ( all( Sigma == -999.0d0 ) ) then
   474:                   if ( flag_generate_sigma ) then
   475:                     call SigmaDataGetHalf( Sigma(1:kmax+1) ) ! (out)
   476:                   else
   477:                     call MessageNotify( 'E', module_name, &
   478:                       & '  Sigma levels have to be specified if flag_generate_sigma is not true.' )
   479:                   end if
   480:                 end if
   481:             
   482:                 ! Sigma (半整数レベルσ) チェック
   483:                 ! Check "Sigma" (half level sigma)
   484:                 !
   485:                 if ( Sigma(1) /= 1.0_DP ) then
   486:                   call MessageNotify( 'E', module_name, '  Sigma(1) is not 1, but is %f', &
   487:                     & d = (/ Sigma(1) /) )
   488:                 end if
   489:                 if ( Sigma(kmax+1) /= 0.0_DP ) then
   490:                   call MessageNotify( 'E', module_name, '  Sigma(kmax+1) is not 0, but is %f', &
   491:                     & d = (/ Sigma(kmax+1) /) )
   492:                 end if
   493: +------>        do k = 1, kmax
   494: |                 if ( Sigma(k+1) > Sigma(k) ) then
   495: |                   call MessageNotify( 'M', module_name, '  Sigma(%d) = %f > Sigma(%d) = %f', &
   496: |                       & i = (/ k+1, k /), d = (/ Sigma(k+1), Sigma(k) /) )
   497: |                   call MessageNotify( 'E', module_name, '  Value of Sigma has to decrease with index.' )
   498: |                 end if
   499: +------         end do
   500:             
   501:                 ! r_Sigma (半整数レベルσ) 設定
   502:                 ! Setting of "r_Sigma" (half level sigma)
   503:                 !
   504: V====== A       r_Sigma(0:kmax) = Sigma(1:kmax+1)
   505:             
   506:                 ! z_DelSigma (整数レベル $ \Delta \sigma $ ) 設定
   507:                 ! Setting of "z_DelSigma" (full level $ \Delta \sigma $ )
   508:                 !
   509: V------>        do k = 1, kmax
   510: |       A         z_DelSigma(k) = r_Sigma(k-1) - r_Sigma(k)
   511: |               enddo
   512: |           
   513: |               ! z_Sigma (整数レベルσ) 設定
   514: |               ! Setting of "z_Sigma" (full level sigma)
   515: |               !
   516: |               Kappa = GasRDry / CpDry
   517: |               do k = 1, kmax
   518: |                 z_Sigma(k) = &
   519: |                   & ( &
   520: |                   &   (   r_Sigma(k-1) ** ( 1.0_DP + Kappa ) &
   521: |                   &     - r_Sigma(k)   ** ( 1.0_DP + Kappa ) &
   522: |                   &   ) / ( z_DelSigma(k) * ( 1.0_DP + Kappa ) ) &
   523: |                   & ) ** ( 1.0_DP / Kappa )
   524: V------         enddo
   525:             
   526:                 ! r_DelSigma (半整数レベル $ \Delta \sigma $ ) 設定
   527:                 ! Setting of "r_DelSigma" (half level $ \Delta \sigma $ )
   528:                 !
   529:                 r_DelSigma(0)    = r_Sigma(0)    - z_Sigma(1)
   530:                 r_DelSigma(kmax) = z_Sigma(kmax) - r_Sigma(kmax)
   531: V------>        do k = 1, kmax - 1
   532: |       A         r_DelSigma(k) = z_Sigma(k) - z_Sigma(k+1)
   533: V------         end do
   534:             
   535:             
   536:                 ! 地下の層の境界面深さのチェック
   537:                 ! Check depth of subsurface layer interface
   538:                 !
   539: V====== A       if ( all( Depth == -999.0d0 ) ) then
   540: V====== A         Depth(0+1:kslmax+1 ) = 0.0_DP
   541:                   call MessageNotify( 'W', module_name, 'Depth is not found in namelist file.' )
   542:                 end if
   543:                 !
   544:                 if ( Depth(0+1) /= 0.0_DP ) then
   545:                   call MessageNotify( 'E', module_name, '  Depth(0) is not zero, but is %f', &
   546:                     & d = (/ Depth(0+1) /) )
   547:                 end if
   548:                 if ( kslmax >= 1 ) then
   549: V====== A         if ( all( Depth(1+1:kslmax+1) >= 0.0_DP ) ) then
   550: +------>            do k = 0, kslmax
   551: |                     call MessageNotify( 'M', module_name, '  Depth(%d) = %f', &
   552: |                       & i = (/ k /), d = (/ Depth(k+1) /) )
   553: +------             end do
   554:                     call MessageNotify( 'E', module_name, '  Depth has to be zero or negative.' )
   555:                   end if
   556:                 end if
   557: +------>        do k = 0, kslmax-1
   558: |                 if ( Depth(k+1+1) > Depth(k+1) ) then
   559: |                   call MessageNotify( 'M', module_name, '  Depth(%d) = %f > Depth(%d) = %f', &
   560: |                       & i = (/ k+1, k /), d = (/ Depth(k+1+1), Depth(k+1) /) )
   561: |                   call MessageNotify( 'E', module_name, '  Value of Depth has to decrease with index.' )
   562: |                 end if
   563: +------         end do
   564:             
   565: V====== A       r_SSDepth(0:kslmax) = Depth(1:kslmax+1)
   566:             
   567: +------>        do k = 0, kslmax
   568: |                 call MessageNotify( 'M', module_name, '  r_SSDepth(%d) = %f', &
   569: |                   i = (/ k /), d = (/ r_SSDepth(k) /) )
   570: +------         end do
   571:             
   572:                 ! 地下の鉛直層の中心点の設定
   573:                 ! Set midpoint of subsurface grid
   574:                 !
   575: V------>        do k = 1, kslmax
   576: |       A         z_SSDepth( k ) = ( r_SSDepth( k-1 ) + r_SSDepth( k ) ) / 2.0d0
   577: V------         end do
   578:             
   579:             
   580:                 ! 海氷の層の境界面深さのチェック
   581:                 ! Check depth of sea ice layer interface
   582:                 !
   583: V====== A       if ( all( SIDepth == -999.0d0 ) ) then
   584: V====== A         SIDepth(0+1:ksimax+1 ) = 0.0_DP
   585:                   call MessageNotify( 'W', module_name, 'SIDepth is not found in namelist file.' )
   586:                 end if
   587:                 !
   588:                 if ( SIDepth(0+1) /= 0.0_DP ) then
   589:                   call MessageNotify( 'E', module_name, '  SIDepth(0) is not zero, but is %f', &
   590:                     & d = (/ SIDepth(0+1) /) )
   591:                 end if
   592:                 if ( ksimax >= 1 ) then
   593: V====== A         if ( all( SIDepth(1+1:ksimax+1) >= 0.0_DP ) ) then
   594: +------>            do k = 0, ksimax
   595: |                     call MessageNotify( 'M', module_name, '  SIDepth(%d) = %f', &
   596: |                       & i = (/ k /), d = (/ SIDepth(k+1) /) )
   597: +------             end do
   598:                     call MessageNotify( 'E', module_name, '  SIDepth has to be zero or negative.' )
   599:                   end if
   600:                 end if
   601: +------>        do k = 0, ksimax-1
   602: |                 if ( SIDepth(k+1+1) > SIDepth(k+1) ) then
   603: |                   call MessageNotify( 'M', module_name, '  SIDepth(%d) = %f > SIDepth(%d) = %f', &
   604: |                       & i = (/ k+1, k /), d = (/ SIDepth(k+1+1), SIDepth(k+1) /) )
   605: |                   call MessageNotify( 'E', module_name, '  Value of SIDepth has to decrease with index.' )
   606: |                 end if
   607: +------         end do
   608:             
   609: V====== A       r_SIDepth(0:ksimax) = SIDepth(1:ksimax+1)
   610:             
   611: +------>        do k = 0, ksimax
   612: |                 call MessageNotify( 'M', module_name, '  r_SIDepth(%d) = %f', &
   613: |                   i = (/ k /), d = (/ r_SIDepth(k) /) )
   614: +------         end do
   615:             
   616:                 ! 地下の鉛直層の中心点の設定
   617:                 ! Set midpoint of subsurface grid
   618:                 !
   619: V------>        do k = 1, ksimax
   620: |       A         z_SIDepth( k ) = ( r_SIDepth( k-1 ) + r_SIDepth( k ) ) / 2.0d0
   621: V------         end do
   622:             
   623:             
   624:                 ! 緯度経度の設定
   625:                 ! Settings of longitude and latitude
   626:                 !
   627:                 allocate( x_Lon        (0:imax-1) )
   628:                 allocate( x_Lon_Weight (0:imax-1) )
   629:                 allocate( y_Lat        (1:jmax)   )
   630:                 allocate( y_Lat_Weight (1:jmax)   )
   631:             
   632:                 if ( ( imax == 1 ) .and. ( jmax == 1 ) ) then
   633:             
   634: V====== A         x_Lon          = LonInDeg * PI / 180.0_DP
   635: V====== A         x_Lon_Weight   = 1.0_DP
   636: V====== A         y_Lat          = LatInDeg * PI / 180.0_DP
   637: V====== A         y_Lat_Weight   = 1.0_DP
   638:             
   639:                 else
   640:                   if ( .not. spml_inited ) then
   641:             
   642:                     call wa_mpi_Initial( nmax, imax, jmax_global, kmax, OMPNumThreads ) ! (in)
   643:                     ! Check number of latitudinal grid on each process
   644:                     call GridsetCheckNumberOfLatGrid( spml_jc )
   645:             
   646:                     spml_inited = .true.
   647:                   end if
   648:             
   649: V====== A         x_Lon          = spml_x_Lon
   650: V====== A         x_Lon_Weight   = spml_x_Lon_Weight
   651: V====== A         y_Lat          = spml_y_Lat
   652: V====== A         y_Lat_Weight   = spml_y_Lat_Weight
   653:                 end if
   654:             
   655:                 if ( imax /= 1  ) then
   656:                   ! DeltaLon, InvDeltaLonの計算
   657:                   ! Caluculate DeltaLon and InvDeltaLon
   658:                   DeltaLon = x_Lon(1) - x_Lon(0)
   659:                   InvDeltaLon = 1.0_DP/DeltaLon
   660:                 else
   661:                   DeltaLon = 0.0_DP
   662:                   InvDeltaLon = 0.0_DP ! not used
   663:                 endif
   664:             
   665:             
   666:             
   667:                 ! スペクトルデータの添字番号の設定
   668:                 ! Settings of subscript of spectral data
   669:                 !
   670: V------>        do i = 1, size(w_Number)
   671: |       A         w_Number(i) = i
   672: V------         end do
   673:             
   674:                 ! ランクに関する情報の取得
   675:                 ! Get information about rank
   676:                 !
   677:                 myrank_mpi = -1
   678:                 nprocs_mpi = 1
   679:                 rank_str = ''
   680:             
   681:             
   682:                 ! 印字 ; Print
   683:                 !
   684:                 call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   685:             
   686:             
   687:                 call MessageNotify( 'M', module_name, 'SJPACK : %c', c1 = 'not used.' )
   688:             
   689:             
   690:                 call MessageNotify( 'M', module_name, 'OMPNumThreads = %d', i = (/OMPNumThreads/) )
   691:             
   692: *------>        do ra = 0, nprocs_mpi - 1
   693: |           
   694: |                 call MessageNotify( 'M', module_name, 'Axes:%c', c1 = trim(rank_str), rank_mpi = -1 )
   695: |V===== A         call MessageNotify( 'M', module_name, '  x_Lon(%d:%d) [deg.] = %*f', &
   696: |                   & i = (/ 0, imax - 1/), &
   697: |                   & d = format_print(x_Lon / PI * 180.0_DP, imax), &
   698: |                   & n =(/ imax /), rank_mpi = -1 )
   699: |V===== A         call MessageNotify( 'M', module_name, '  y_Lat(%d:%d) [deg.] = %*f', &
   700: |                   & i = (/ 1, jmax/), &
   701: |                   & d = format_print(y_Lat / PI * 180.0_DP, jmax), &
   702: |                   & n =(/ jmax /), rank_mpi = -1 )
   703: |                 call MessageNotify( 'M', module_name, '  z_Sigma(%d:%d) = %*f', &
   704: |                   & i = (/ 1, kmax /), &
   705: |                   & d = format_print(z_Sigma, kmax), n =(/ kmax /), rank_mpi = -1 )
   706: |                 call MessageNotify( 'M', module_name, '  r_Sigma(%d:%d) = %*f', &
   707: |                   & i = (/ 0, kmax /), &
   708: |                   & d = format_print(r_Sigma, kmax+1), n =(/ kmax+1 /), rank_mpi = -1 )
   709: |                 call MessageNotify( 'M', module_name, '  w_Number(%d:%d) = %d .. %d', &
   710: |                   & i = (/ 1, size(w_Number), 1, size(w_Number) /), rank_mpi = -1 )
   711: |             !
   712: |                 call MessageNotify( 'M', module_name, 'Weight:' )
   713: |                 call MessageNotify( 'M', module_name, '  x_Lon_Weight(%d:%d) = %*f', &
   714: |                   & i = (/ 0, imax - 1/), &
   715: |                   & d = format_print(x_Lon_Weight, imax), n =(/ imax /), rank_mpi = -1 )
   716: |                 call MessageNotify( 'M', module_name, '  y_Lat_Weight(%d:%d) = %*f', &
   717: |                   & i = (/ 1, jmax/), &
   718: |                   & d = format_print(y_Lat_Weight, jmax), n =(/ jmax /), rank_mpi = -1 )
   719: |                 call MessageNotify( 'M', module_name, '  z_DelSigma(%d:%d) = %*f', &
   720: |                   & i = (/ 1, kmax /), &
   721: |                   & d = format_print(z_DelSigma, kmax), n =(/ kmax /), rank_mpi = -1 )
   722: |                 call MessageNotify( 'M', module_name, '' )
   723: *------         end do
   724:             
   725:                 call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version), rank_mpi = -1 )
   726:             
   727:                 axesset_inited = .true.
   728:             
   729:               end subroutine AxessetInit
   730:             
   731:               !--------------------------------------------------------------------------------------
   732:             
   733:               subroutine AxessetFinalize
   734:                 !
   735:                 ! モジュール内部の変数の割り付け解除を行います. 
   736:                 !
   737:                 ! Deallocate variables in this module. 
   738:                 !
   739:             
   740:                 ! モジュール引用 ; USE statements
   741:                 !
   742:             
   743:                 ! 宣言文 ; Declaration statements
   744:                 !
   745:                 implicit none
   746:             
   747:                 ! 実行文 ; Executable statement
   748:                 !
   749:             
   750:                 if ( .not. axesset_inited ) return
   751:             
   752:                 ! 割り付け解除
   753:                 ! Deallocation
   754:                 !
   755:                 if ( allocated( z_Sigma    ) ) deallocate( z_Sigma    )
   756:                 if ( allocated( r_Sigma    ) ) deallocate( r_Sigma    )
   757:                 if ( allocated( z_DelSigma ) ) deallocate( z_DelSigma )
   758:                 if ( allocated( r_DelSigma ) ) deallocate( r_DelSigma )
   759:                 if ( allocated( w_Number   ) ) deallocate( w_Number   )
   760:             
   761:                 if ( allocated( r_SSDepth ) ) deallocate( r_SSDepth )
   762:                 if ( allocated( z_SSDepth ) ) deallocate( z_SSDepth )
   763:             
   764:                 if ( allocated( r_SIDepth ) ) deallocate( r_SIDepth )
   765:                 if ( allocated( z_SIDepth ) ) deallocate( z_SIDepth )
   766:             
   767:                 if ( allocated( x_Lon        ) ) deallocate( x_Lon        )
   768:                 if ( allocated( x_Lon_Weight ) ) deallocate( x_Lon_Weight )
   769:                 if ( allocated( y_Lat        ) ) deallocate( y_Lat        )
   770:                 if ( allocated( y_Lat_Weight ) ) deallocate( y_Lat_Weight )
   771:             
   772:                 axesset_inited = .false.
   773:             
   774:               end subroutine AxessetFinalize
   775:             
   776:               !--------------------------------------------------------------------------------------
   777:             
   778:               function format_print( ary, size ) result(result)
   779:                 !
   780:                 ! 標準出力して見やすいように適当に有効数字の桁を落として返す. 
   781:                 !
   782:                 ! Effective digit is reduced for output to standard output and returned. 
   783:                 !
   784:             
   785:                 ! 宣言文 ; Declaration statements
   786:                 !
   787:                 implicit none
   788:                 integer, intent(in):: size
   789:                 real(DP), intent(in):: ary(size)
   790:                 real(DP):: result(size)
   791:             
   792:                 ! 実行文 ; Executable statement
   793:                 !
   794: V====== A       result(1:size) = int( ary(1:size) * 1000.0_DP ) / 1000.0_DP
   795:             
   796:               end function format_print
   797:             
   798:               !--------------------------------------------------------------------------------------
   799:             
   800:             end module axesset
