Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:21 2016
FILE NAME: i.gridset.F90
PROGRAM NAME: gridset
DIAGNOSTIC LIST

  LINE  LEVEL( NO.): DIAGNOSTIC MESSAGE

   316  vec  (   4): Vectorized array expression.
   316  vec  (  29): ADB is used for array.: a_jmax
   328  vec  (   1): Vectorized loop.
   328  vec  (  29): ADB is used for array.: a_jmax
   418  vec  (   3): Unvectorized loop.
   420  opt  (1017): Subroutine call prevents optimization.
   420  vec  (  10): Vectorization obstructive procedure reference.:mpiwrapperisend_dble_1d
   421  vec  (  10): Vectorization obstructive procedure reference.:mpiwrapperirecv_dble_1d
   424  vec  (   3): Unvectorized loop.
   426  opt  (1017): Subroutine call prevents optimization.
   426  vec  (  10): Vectorization obstructive procedure reference.:mpiwrapperwait
   427  vec  (  10): Vectorization obstructive procedure reference.:mpiwrapperwait
   431  vec  (   1): Vectorized loop.
   431  vec  (  29): ADB is used for array.: a_jmax_tmp
   431  vec  (  29): ADB is used for array.: aa_recvbuf
   431  vec  (   1): Vectorized loop.
   431  vec  (  29): ADB is used for array.: a_jmax_tmp
   431  vec  (  29): ADB is used for array.: aa_recvbuf
   431  vec  (   1): Vectorized loop.
   431  vec  (  29): ADB is used for array.: a_jmax_tmp
   431  vec  (  29): ADB is used for array.: aa_recvbuf
   440  vec  (   3): Unvectorized loop.
   442  opt  (1017): Subroutine call prevents optimization.
   442  vec  (  10): Vectorization obstructive procedure reference.:messagenotifyc
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:21 2016
FILE NAME: i.gridset.F90
PROGRAM NAME: gridset
TRANSFORMATION LIST

  LINE                   FORTRAN STATEMENT

     1  != 格子点数・最大波数設定
     2  !
     3  != Number of grid points and maximum truncated wavenumber settings
     4  !
     5  ! Authors::   Yoshiyuki O. Takahashi, Yasuhiro MORIKAWA, Satoshi NODA
     6  ! Version::   $Id: gridset.F90,v 1.4 2012/02/01 12:03:32 yot Exp $
     7  ! Tag Name::  $Name:  $
     8  ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9  ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10  !
    11  
    12  module gridset
    13    !
    14    != 格子点数・最大波数設定
    15    !
    16    != Number of grid points and maximum truncated wavenumber settings
    17    !
    18    ! <b>Note that Japanese and English are described in parallel.</b>
    19    !
    20    ! 格子点数の設定および保管を行います.
    21    ! スペクトル法を用いることを前提にしており,
    22    ! 最大波数の設定と保管も行います.
    23    !
    24    ! Number of grid points is set and stored.
    25    ! Maximum truncated wavenumber is set and stored too,
    26    ! because spectral method is expected to be used.
    27    !
    28    !== Variables List
    29    !
    30    ! nmax         :: 最大全波数
    31    ! lmax         :: スペクトルデータの配列サイズ
    32    ! imax         :: 経度格子点数
    33    ! jmax_global  :: 緯度格子点数 (全球)
    34    ! jmax         :: 緯度格子点数
    35    ! kmax         :: 鉛直層数
    36    ! kslmax       :: 地下鉛直層数
    37    ! ksimax       :: 海氷鉛直層数最大値
    38    ! ------------ :: ------------
    39    ! nmax         :: Maximum truncated wavenumber
    40    ! lmax         :: Size of array for spectral data
    41    ! imax         :: Number of grid points in longitude
    42    ! jmax_global  :: Number of grid points in latitude on whole globe
    43    ! jmax         :: Number of grid points in latitude
    44    ! kmax         :: Number of vertical level
    45    ! kslmax       :: Number of subsurface vertical level
    46    ! ksimax       :: Maximum number of sea ice vertical level
    47    !
    48    !== Procedures List
    49    !
    50    ! GridsetInit   :: 格子点数と最大波数の設定
    51    ! ------------  :: ------------
    52    ! GridsetInit   :: Settings of number of grid points and maximum truncated wavenumber
    53    !
    54    !
    55    !== NAMELIST
    56    !
    57    ! NAMELIST#gridset_nml
    58    !
    59  
    60    ! モジュール引用 ; USE statements
    61    !
    62  
    63    ! 種別型パラメタ
    64    ! Kind type parameter
    65    !
    66    use dc_types, only: DP     ! 倍精度実数型. Double precision.
    67  
    68    ! 宣言文 ; Declaration statements
    69    !
    70    implicit none
    71    private
    72  
    73    ! 公開手続き
    74    ! Public procedure
    75    !
    76    public :: GridsetInit
    77    public :: GridsetCheckNumberOfLatGrid
    78  
    79  
    80    ! 公開変数
    81    ! Public variables
    82    !
    83    logical, save, public:: gridset_inited = .false.
    84                                ! 初期設定フラグ.
    85                                ! Initialization flag
    86    integer, save, public:: nmax
    87                                ! 最大全波数.
    88                                ! Maximum truncated wavenumber
    89    integer, save, public:: lmax
    90                                ! スペクトルデータの配列サイズ
    91                                ! Size of array for spectral data
    92    integer, save, public:: imax
    93                                ! 経度格子点数.
    94                                ! Number of grid points in longitude
    95    integer, save, public:: jmax_global
    96                                ! 緯度格子点数 (全球).
    97                                ! Number of grid points in latitude on whole globe
    98    integer, save, public:: jmax
    99                                ! 緯度格子点数.
   100                                ! Number of grid points in latitude
   101    integer, save, public:: kmax
   102                                ! 鉛直層数.
   103                                ! Number of vertical level
   104    integer, save, public:: kslmax
   105                                ! 地下の鉛直層数.
   106                                ! Number of subsurface vertical level
   107    integer, save, public:: ksimax
   108                                ! 海氷の最大鉛直層数.
   109                                ! Maximum number of sea ice vertical level
   110  
   111    integer, save, allocatable, public :: a_jmax(:)
   112                                ! 各プロセスの緯度格子点数.
   113                                ! Number of grid points in latitude of each process
   114    integer, save             , public :: jmax_max
   115                                ! 各プロセスの緯度格子点数の最大値.
   116                                ! Maximum number of grid points in latitude of all processes
   117  
   118  
   119    ! 非公開変数
   120    ! Private variables
   121    !
   122  
   123    character(*), parameter:: module_name = 'gridset'
   124                                ! モジュールの名称.
   125                                ! Module name
   126    character(*), parameter:: version = &
   127      & '$Name:  $' // &
   128      & '$Id: gridset.F90,v 1.4 2012/02/01 12:03:32 yot Exp $'
   129                                ! モジュールのバージョン
   130                                ! Module version
   131  
   132  contains
   133  
   134    subroutine GridsetInit
   135      !
   136      ! gridset モジュールの初期化を行います.
   137      ! NAMELIST#gridset_nml の読み込みはこの手続きで行われます.
   138      !
   139      ! "gridset" module is initialized.
   140      ! NAMELIST#gridset_nml is loaded in this procedure.
   141      !
   142  
   143      ! モジュール引用 ; USE statements
   144      !
   145  
   146      ! NAMELIST ファイル入力に関するユーティリティ
   147      ! Utilities for NAMELIST file input
   148      !
   149      use namelist_util, only: namelist_filename, NmlutilMsg
   150  
   151      ! ファイル入出力補助
   152      ! File I/O support
   153      !
   154      use dc_iounit, only: FileOpen
   155  
   156      ! 種別型パラメタ
   157      ! Kind type parameter
   158      !
   159      use dc_types, only: STDOUT ! 標準出力の装置番号. Unit number of standard output
   160  
   161      ! メッセージ出力
   162      ! Message output
   163      !
   164      use dc_message, only: MessageNotify
   165  
   166      ! 宣言文 ; Declaration statements
   167      !
   168      implicit none
   169      integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号.
   170                                ! Unit number for NAMELIST file open
   171      integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT.
   172                                ! IOSTAT of NAMELIST read
   173  
   174      ! NAMELIST 変数群
   175      ! NAMELIST group name
   176      !
   177      namelist /gridset_nml/ nmax, imax, jmax, kmax, kslmax, ksimax
   178            !
   179            ! デフォルト値については初期化手続 "gridset#GridsetInit"
   180            ! のソースコードを参照のこと.
   181            !
   182            ! Refer to source codes in the initialization procedure
   183            ! "gridset#GridsetInit" for the default values.
   184            !
   185  
   186      ! 実行文 ; Executable statement
   187      !
   188  
   189      if ( gridset_inited ) return
   190      call InitCheck
   191  
   192      ! デフォルト値の設定
   193      ! Default values settings
   194      !
   195  
   196      imax        = 32
   197  
   198      jmax        = imax / 2
   199      kmax        = 5
   200      nmax        = ( imax - 1 ) / 3
   201  
   202      kslmax      = 0
   203  
   204      ksimax      = 0
   205  
   206      ! NAMELIST の読み込み
   207      ! NAMELIST is input
   208      !
   209      if ( trim(namelist_filename) /= '' ) then
   210        call FileOpen( unit_nml, &          ! (out)
   211          & namelist_filename, mode = 'r' ) ! (in)
   212  
   213        rewind( unit_nml )
   214        read( unit_nml, &         ! (in)
   215          & nml = gridset_nml, &  ! (out)
   216          & iostat = iostat_nml ) ! (out)
   217        close( unit_nml )
   218  
   219        call NmlutilMsg( iostat_nml, module_name ) ! (in)
   220        if ( iostat_nml == 0 ) write( STDOUT, nml = gridset_nml )
   221      end if
   222  
   223      ! Check of array size
   224      !
   225  
   226  
   227      if ( imax /= 1 ) then
   228        if ( jmax /= imax / 2 ) then
   229          call MessageNotify( 'E', module_name, &
   230            & 'Number of grid points in latitudinal direction has to be equal to ' &
   231            & // 'number of grid points in longitudinal direction divided by 2.' )
   232        end if
   233      end if
   234  
   235      ! Set number of grid points in latitudinal direction
   236      !
   237      jmax_global = jmax
   238      !
   239      ! Calculate and save jmax in all processes
   240      !   If jmax is 1, the model runs as 1D model. In that case, jmax need not
   241      !   be calculated.
   242      ! Even if jmax has a value, it is overwritten.
   243      !
   244      call GridsetCalcjmax
   245  
   246  
   247      ! Set size of array for spectral data
   248      !
   249  
   250      lmax = (nmax+1)**2
   251  
   252  
   253  
   254      ! 格子点数のチェック
   255      ! Check number of grid points
   256      !
   257      if ( nmax < 1 .or. imax < 1 .or. jmax_global < 1 .or. jmax < 1 .or. kmax < 1 ) then
   258        call MessageNotify( 'E', module_name, &
   259          & 'number of grid points and maximum truncated wavenumber must be more than 0. ' // &
   260          & 'nmax=%d, imax=%d, jmax_global=%d, jmax=%d, kmax=%d' , &
   261          & i = (/ nmax, imax, jmax_global, jmax, kmax /) )
   262      end if
   263  
   264      ! 印字 ; Print
   265      !
   266      call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   267      call MessageNotify( 'M', module_name, '    nmax        = %d', i = (/   nmax  /) )
   268      call MessageNotify( 'M', module_name, '    imax        = %d', i = (/   imax  /) )
   269      call MessageNotify( 'M', module_name, '    jmax_global = %d', i = (/   jmax_global /) )
   270      call MessageNotify( 'M', module_name, '    jmax        = %d', i = (/   jmax  /) )
   271      call MessageNotify( 'M', module_name, '    kmax        = %d', i = (/   kmax  /) )
   272      call MessageNotify( 'M', module_name, '  kslmax        = %d', i = (/ kslmax  /) )
   273      call MessageNotify( 'M', module_name, '  ksimax        = %d', i = (/ ksimax  /) )
   274      call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   275  
   276      gridset_inited = .true.
   277    end subroutine GridsetInit
   278  
   279    !-------------------------------------------------------------------
   280  
   281    subroutine GridsetCalcjmax
   282      !
   283      ! jmax を計算.
   284      !
   285      ! Calculate jmax
   286      !
   287  
   288      ! モジュール引用 ; USE statements
   289      !
   290  
   291      ! メッセージ出力
   292      ! Message output
   293      !
   294      use dc_message, only: MessageNotify
   295  
   296      ! MPI
   297      !
   298      use mpi_wrapper, only: nprocs, myrank
   299  
   300      ! 宣言文 ; Declaration statements
   301      !
   302      implicit none
   303  
   304  
   305      ! Local variables
   306      !
   307      integer            :: jh, jph, js, je, jch, jc
   308      integer            :: n
   309  
   310  
   311      allocate( a_jmax(0:nprocs-1) )
   312  
   313      if ( ( imax == 1 ) .and. ( jmax == 1 ) ) then
   314  
   315        jmax_max = 1
   316        a_jmax   = 1
   317  
   318      else
   319  
   320        ! Following calculation is a copy of that in a subroutine SNMINI in snmini.f
   321        ! included in ISPACK.
   322  
   323        jh = jmax_global / 2
   324        jph = ( jh - 1 ) / nprocs + 1
   325  
   326        jmax_max = jph * 2
   327  
   328        do n = 0, nprocs-1
   329  
   330          js = jph * n + 1
   331          je = min( jph * ( n + 1 ), jh )
   332          if ( je >= js ) THEN
   333            jch = je - js + 1
   334            jc  = jch * 2
   335          else
   336            jc = 0
   337            js = 1
   338            je = 1
   339          end if
   340  
   341          a_jmax(n) = jc
   342  
   343        end do
   344  
   345        if ( jmax /= a_jmax( myrank ) ) then
   346          call MessageNotify( 'M', module_name, &
   347            & 'jmax = %d, a_jmax(myrank) = %d.', i = (/ jmax, a_jmax( myrank ) /) )
   348          call MessageNotify( 'M', module_name, &
   349            & 'jmax is overwritten, and is %d.', i = (/ a_jmax( myrank ) /) )
   350        end if
   351        jmax = a_jmax( myrank )
   352  
   353      end if
   354  
   355    end subroutine GridsetCalcjmax
   356  
   357    !-------------------------------------------------------------------
   358  
   359    subroutine GridsetCheckNumberOfLatGrid( jc )
   360      !
   361      ! それぞれのプロセスが担当する緯度格子点数を確認.
   362      !
   363      ! Check number of latitudinal grids on each process.
   364      !
   365  
   366      ! モジュール引用 ; USE statements
   367      !
   368  
   369      ! メッセージ出力
   370      ! Message output
   371      !
   372      use dc_message, only: MessageNotify
   373  
   374      ! MPI
   375      !
   376      use mpi_wrapper, only: nprocs, myrank, &
   377        & MPIWrapperISend, &
   378        & MPIWrapperIRecv, &
   379        & MPIWrapperWait
   380  
   381  
   382      ! 宣言文 ; Declaration statements
   383      !
   384      implicit none
   385  
   386      integer, intent(in ) :: jc
   387  
   388      ! Local variable
   389      !
   390      integer , allocatable :: a_jmax_tmp(:)
   391      real(DP)              :: a_SendBuf (1)
   392      real(DP), allocatable :: aa_RecvBuf(:,:)
   393      integer , allocatable :: a_iReqSend(:)
   394      integer , allocatable :: a_iReqRecv(:)
   395      integer               :: n
   396  
   397      ! 実行文 ; Executable statement
   398      !
   399  
   400  
   401      if ( jmax /= jc ) then
   402        call MessageNotify( 'E', module_name,                                                    &
   403          & 'Saved jmax at myrank=%d is %d, but is not same as one calculated by spml, %d.', &
   404          & i = (/myrank, jmax, jc/) )
   405      end if
   406  
   407  
   408  
   409      allocate( a_jmax_tmp(0:nprocs-1) )
   410      allocate( aa_RecvBuf(1,0:nprocs-1) )
   411      allocate( a_iReqSend(0:nprocs-1) )
   412      allocate( a_iReqRecv(0:nprocs-1) )
   413  
   414      a_SendBuf(1) = jc
   415  
   416      ! jmax is sent to all nodes, and received by all nodes.
   417  
   418      do n = 0, nprocs-1
   419        if ( n == myrank ) cycle
   420        call MPIWrapperISend( n, 1, a_SendBuf      , a_iReqSend(n) )
   421        call MPIWrapperIRecv( n, 1, aa_RecvBuf(:,n), a_iReqRecv(n) )
   422      end do
   423  
   424      do n = 0, nprocs-1
   425        if ( n == myrank ) cycle
   426        call MPIWrapperWait( a_iReqSend(n) )
   427        call MPIWrapperWait( a_iReqRecv(n) )
   428      end do
   429  
   430  
   431      do n = 0, nprocs-1
   432        if ( n == myrank ) then
   433          a_jmax_tmp(n) = jc
   434        else
   435          a_jmax_tmp(n) = aa_RecvBuf(1,n)
   436        end if
   437      end do
     .        if (myrank.ge.0 .and. myrank.le.nprocs-1) then                    
     .           a_jmax_tmp(myrank) = jc                                        
     .        endif                                                             
     .        if (myrank.ge.0 .and. myrank.le.nprocs-1) then                    
     .  !cdir    nodep                                                          
     .           do n = 1, myrank                                               
     .              a_jmax_tmp(n-1) = ifix(aa_recvbuf(1,n-1))                   
     .           enddo                                                          
     .  !cdir    nodep                                                          
     .           do n = 1, nprocs - 1 - myrank                                  
     .              a_jmax_tmp(myrank+n) = ifix(aa_recvbuf(1,myrank+n))         
     .           enddo                                                          
     .        else                                                              
     .  !cdir    nodep                                                          
     .           do n = 1, nprocs                                               
     .              a_jmax_tmp(n-1) = ifix(aa_recvbuf(1,n-1))                   
     .           enddo                                                          
     .        endif                                                             
   438  
   439      ! Check number of latitudinal grid in each process.
   440      do n = 0, nprocs-1
   441        if ( a_jmax(n) /= a_jmax_tmp(n) ) then
   442          call MessageNotify( 'E', module_name,                               &
   443            & 'jmax in proc=%d is %d, but is not the same as saved one, %d.', &
   444            & i = (/n, a_jmax_tmp(n), a_jmax(n)/) )
   445        end if
   446      end do
   447  
   448  
   449      deallocate( aa_RecvBuf )
   450      deallocate( a_iReqSend )
   451      deallocate( a_iReqRecv )
   452      deallocate( a_jmax_tmp )
   453  
   454  
   455  
   456    end subroutine GridsetCheckNumberOfLatGrid
   457  
   458    !-------------------------------------------------------------------
   459  
   460    subroutine InitCheck
   461      !
   462      ! 依存モジュールの初期化チェック
   463      !
   464      ! Check initialization of dependency modules
   465  
   466      ! モジュール引用 ; USE statements
   467      !
   468  
   469      ! NAMELIST ファイル入力に関するユーティリティ
   470      ! Utilities for NAMELIST file input
   471      !
   472      use namelist_util, only: namelist_util_inited
   473  
   474      ! メッセージ出力
   475      ! Message output
   476      !
   477      use dc_message, only: MessageNotify
   478  
   479      ! 実行文 ; Executable statement
   480      !
   481  
   482      if ( .not. namelist_util_inited ) &
   483        & call MessageNotify( 'E', module_name, '"namelist_util" module is not initialized.' )
   484  
   485    end subroutine InitCheck
   486  
   487  end module gridset
Linux  R2.6.32-504.16.2.el6.x86_64 FORTRAN90/SX         Rev.501        Sat Dec 10 22:38:21 2016
FILE NAME: i.gridset.F90
PROGRAM NAME: gridset
FORMAT LIST

  LINE    LOOP      FORTRAN STATEMENT

     1:             != 格子点数・最大波数設定
     2:             !
     3:             != Number of grid points and maximum truncated wavenumber settings
     4:             !
     5:             ! Authors::   Yoshiyuki O. Takahashi, Yasuhiro MORIKAWA, Satoshi NODA
     6:             ! Version::   $Id: gridset.F90,v 1.4 2012/02/01 12:03:32 yot Exp $ 
     7:             ! Tag Name::  $Name:  $
     8:             ! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
     9:             ! License::   See COPYRIGHT[link:../../../COPYRIGHT]
    10:             !
    11:             
    12:             module gridset
    13:               !
    14:               != 格子点数・最大波数設定
    15:               !
    16:               != Number of grid points and maximum truncated wavenumber settings
    17:               !
    18:               ! <b>Note that Japanese and English are described in parallel.</b>
    19:               !
    20:               ! 格子点数の設定および保管を行います. 
    21:               ! スペクトル法を用いることを前提にしており, 
    22:               ! 最大波数の設定と保管も行います. 
    23:               !
    24:               ! Number of grid points is set and stored. 
    25:               ! Maximum truncated wavenumber is set and stored too, 
    26:               ! because spectral method is expected to be used. 
    27:               !
    28:               !== Variables List
    29:               !
    30:               ! nmax         :: 最大全波数
    31:               ! lmax         :: スペクトルデータの配列サイズ
    32:               ! imax         :: 経度格子点数
    33:               ! jmax_global  :: 緯度格子点数 (全球)
    34:               ! jmax         :: 緯度格子点数
    35:               ! kmax         :: 鉛直層数
    36:               ! kslmax       :: 地下鉛直層数
    37:               ! ksimax       :: 海氷鉛直層数最大値
    38:               ! ------------ :: ------------
    39:               ! nmax         :: Maximum truncated wavenumber
    40:               ! lmax         :: Size of array for spectral data
    41:               ! imax         :: Number of grid points in longitude
    42:               ! jmax_global  :: Number of grid points in latitude on whole globe
    43:               ! jmax         :: Number of grid points in latitude
    44:               ! kmax         :: Number of vertical level
    45:               ! kslmax       :: Number of subsurface vertical level
    46:               ! ksimax       :: Maximum number of sea ice vertical level
    47:               !
    48:               !== Procedures List
    49:               !
    50:               ! GridsetInit   :: 格子点数と最大波数の設定
    51:               ! ------------  :: ------------
    52:               ! GridsetInit   :: Settings of number of grid points and maximum truncated wavenumber
    53:               !
    54:               !
    55:               !== NAMELIST
    56:               !
    57:               ! NAMELIST#gridset_nml
    58:               !
    59:             
    60:               ! モジュール引用 ; USE statements
    61:               !
    62:             
    63:               ! 種別型パラメタ
    64:               ! Kind type parameter
    65:               !
    66:               use dc_types, only: DP     ! 倍精度実数型. Double precision. 
    67:             
    68:               ! 宣言文 ; Declaration statements
    69:               !
    70:               implicit none
    71:               private
    72:             
    73:               ! 公開手続き
    74:               ! Public procedure
    75:               !
    76:               public :: GridsetInit
    77:               public :: GridsetCheckNumberOfLatGrid
    78:             
    79:             
    80:               ! 公開変数
    81:               ! Public variables
    82:               !
    83:               logical, save, public:: gridset_inited = .false.
    84:                                           ! 初期設定フラグ. 
    85:                                           ! Initialization flag
    86:               integer, save, public:: nmax
    87:                                           ! 最大全波数. 
    88:                                           ! Maximum truncated wavenumber
    89:               integer, save, public:: lmax
    90:                                           ! スペクトルデータの配列サイズ
    91:                                           ! Size of array for spectral data
    92:               integer, save, public:: imax
    93:                                           ! 経度格子点数. 
    94:                                           ! Number of grid points in longitude
    95:               integer, save, public:: jmax_global
    96:                                           ! 緯度格子点数 (全球). 
    97:                                           ! Number of grid points in latitude on whole globe
    98:               integer, save, public:: jmax
    99:                                           ! 緯度格子点数. 
   100:                                           ! Number of grid points in latitude
   101:               integer, save, public:: kmax
   102:                                           ! 鉛直層数. 
   103:                                           ! Number of vertical level
   104:               integer, save, public:: kslmax
   105:                                           ! 地下の鉛直層数. 
   106:                                           ! Number of subsurface vertical level
   107:               integer, save, public:: ksimax
   108:                                           ! 海氷の最大鉛直層数. 
   109:                                           ! Maximum number of sea ice vertical level
   110:             
   111:               integer, save, allocatable, public :: a_jmax(:)
   112:                                           ! 各プロセスの緯度格子点数. 
   113:                                           ! Number of grid points in latitude of each process
   114:               integer, save             , public :: jmax_max
   115:                                           ! 各プロセスの緯度格子点数の最大値. 
   116:                                           ! Maximum number of grid points in latitude of all processes
   117:             
   118:             
   119:               ! 非公開変数
   120:               ! Private variables
   121:               !
   122:             
   123:               character(*), parameter:: module_name = 'gridset'
   124:                                           ! モジュールの名称. 
   125:                                           ! Module name
   126:               character(*), parameter:: version = &
   127:                 & '$Name:  $' // &
   128:                 & '$Id: gridset.F90,v 1.4 2012/02/01 12:03:32 yot Exp $'
   129:                                           ! モジュールのバージョン
   130:                                           ! Module version
   131:             
   132:             contains
   133:             
   134:               subroutine GridsetInit
   135:                 !
   136:                 ! gridset モジュールの初期化を行います. 
   137:                 ! NAMELIST#gridset_nml の読み込みはこの手続きで行われます. 
   138:                 !
   139:                 ! "gridset" module is initialized. 
   140:                 ! NAMELIST#gridset_nml is loaded in this procedure. 
   141:                 !
   142:             
   143:                 ! モジュール引用 ; USE statements
   144:                 !
   145:             
   146:                 ! NAMELIST ファイル入力に関するユーティリティ
   147:                 ! Utilities for NAMELIST file input
   148:                 !
   149:                 use namelist_util, only: namelist_filename, NmlutilMsg
   150:             
   151:                 ! ファイル入出力補助
   152:                 ! File I/O support
   153:                 !
   154:                 use dc_iounit, only: FileOpen
   155:             
   156:                 ! 種別型パラメタ
   157:                 ! Kind type parameter
   158:                 !
   159:                 use dc_types, only: STDOUT ! 標準出力の装置番号. Unit number of standard output
   160:             
   161:                 ! メッセージ出力
   162:                 ! Message output
   163:                 !
   164:                 use dc_message, only: MessageNotify
   165:             
   166:                 ! 宣言文 ; Declaration statements
   167:                 !
   168:                 implicit none
   169:                 integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号. 
   170:                                           ! Unit number for NAMELIST file open
   171:                 integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT. 
   172:                                           ! IOSTAT of NAMELIST read
   173:             
   174:                 ! NAMELIST 変数群
   175:                 ! NAMELIST group name
   176:                 !
   177:                 namelist /gridset_nml/ nmax, imax, jmax, kmax, kslmax, ksimax
   178:                       !
   179:                       ! デフォルト値については初期化手続 "gridset#GridsetInit" 
   180:                       ! のソースコードを参照のこと. 
   181:                       !
   182:                       ! Refer to source codes in the initialization procedure
   183:                       ! "gridset#GridsetInit" for the default values. 
   184:                       !
   185:             
   186:                 ! 実行文 ; Executable statement
   187:                 !
   188:             
   189:                 if ( gridset_inited ) return
   190:                 call InitCheck
   191:             
   192:                 ! デフォルト値の設定
   193:                 ! Default values settings
   194:                 !
   195:             
   196:                 imax        = 32
   197:             
   198:                 jmax        = imax / 2
   199:                 kmax        = 5
   200:                 nmax        = ( imax - 1 ) / 3
   201:             
   202:                 kslmax      = 0
   203:             
   204:                 ksimax      = 0
   205:             
   206:                 ! NAMELIST の読み込み
   207:                 ! NAMELIST is input
   208:                 !
   209:                 if ( trim(namelist_filename) /= '' ) then
   210:                   call FileOpen( unit_nml, &          ! (out)
   211:                     & namelist_filename, mode = 'r' ) ! (in)
   212:             
   213:                   rewind( unit_nml )
   214:                   read( unit_nml, &         ! (in)
   215:                     & nml = gridset_nml, &  ! (out)
   216:                     & iostat = iostat_nml ) ! (out)
   217:                   close( unit_nml )
   218:             
   219:                   call NmlutilMsg( iostat_nml, module_name ) ! (in)
   220:                   if ( iostat_nml == 0 ) write( STDOUT, nml = gridset_nml )
   221:                 end if
   222:             
   223:                 ! Check of array size
   224:                 !
   225:             
   226:             
   227:                 if ( imax /= 1 ) then
   228:                   if ( jmax /= imax / 2 ) then
   229:                     call MessageNotify( 'E', module_name, &
   230:                       & 'Number of grid points in latitudinal direction has to be equal to ' &
   231:                       & // 'number of grid points in longitudinal direction divided by 2.' )
   232:                   end if
   233:                 end if
   234:             
   235:                 ! Set number of grid points in latitudinal direction
   236:                 !
   237:                 jmax_global = jmax
   238:                 !
   239:                 ! Calculate and save jmax in all processes
   240:                 !   If jmax is 1, the model runs as 1D model. In that case, jmax need not 
   241:                 !   be calculated. 
   242:                 ! Even if jmax has a value, it is overwritten. 
   243:                 !
   244:                 call GridsetCalcjmax
   245:             
   246:             
   247:                 ! Set size of array for spectral data
   248:                 !
   249:             
   250:                 lmax = (nmax+1)**2
   251:             
   252:             
   253:             
   254:                 ! 格子点数のチェック
   255:                 ! Check number of grid points
   256:                 !
   257:                 if ( nmax < 1 .or. imax < 1 .or. jmax_global < 1 .or. jmax < 1 .or. kmax < 1 ) then
   258:                   call MessageNotify( 'E', module_name, &
   259:                     & 'number of grid points and maximum truncated wavenumber must be more than 0. ' // &
   260:                     & 'nmax=%d, imax=%d, jmax_global=%d, jmax=%d, kmax=%d' , &
   261:                     & i = (/ nmax, imax, jmax_global, jmax, kmax /) )
   262:                 end if
   263:             
   264:                 ! 印字 ; Print
   265:                 !
   266:                 call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
   267:                 call MessageNotify( 'M', module_name, '    nmax        = %d', i = (/   nmax  /) )
   268:                 call MessageNotify( 'M', module_name, '    imax        = %d', i = (/   imax  /) )
   269:                 call MessageNotify( 'M', module_name, '    jmax_global = %d', i = (/   jmax_global /) )
   270:                 call MessageNotify( 'M', module_name, '    jmax        = %d', i = (/   jmax  /) )
   271:                 call MessageNotify( 'M', module_name, '    kmax        = %d', i = (/   kmax  /) )
   272:                 call MessageNotify( 'M', module_name, '  kslmax        = %d', i = (/ kslmax  /) )
   273:                 call MessageNotify( 'M', module_name, '  ksimax        = %d', i = (/ ksimax  /) )
   274:                 call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )
   275:             
   276:                 gridset_inited = .true.
   277:               end subroutine GridsetInit
   278:             
   279:               !-------------------------------------------------------------------
   280:             
   281:               subroutine GridsetCalcjmax
   282:                 !
   283:                 ! jmax を計算.
   284:                 !
   285:                 ! Calculate jmax
   286:                 !
   287:             
   288:                 ! モジュール引用 ; USE statements
   289:                 !
   290:             
   291:                 ! メッセージ出力
   292:                 ! Message output
   293:                 !
   294:                 use dc_message, only: MessageNotify
   295:             
   296:                 ! MPI
   297:                 !
   298:                 use mpi_wrapper, only: nprocs, myrank
   299:             
   300:                 ! 宣言文 ; Declaration statements
   301:                 !
   302:                 implicit none
   303:             
   304:             
   305:                 ! Local variables
   306:                 !
   307:                 integer            :: jh, jph, js, je, jch, jc
   308:                 integer            :: n
   309:             
   310:             
   311:                 allocate( a_jmax(0:nprocs-1) )
   312:             
   313:                 if ( ( imax == 1 ) .and. ( jmax == 1 ) ) then
   314:             
   315:                   jmax_max = 1
   316: V====== A         a_jmax   = 1
   317:             
   318:                 else
   319:             
   320:                   ! Following calculation is a copy of that in a subroutine SNMINI in snmini.f 
   321:                   ! included in ISPACK.
   322:             
   323:                   jh = jmax_global / 2
   324:                   jph = ( jh - 1 ) / nprocs + 1
   325:             
   326:                   jmax_max = jph * 2
   327:             
   328: V------>          do n = 0, nprocs-1
   329: |           
   330: |                   js = jph * n + 1
   331: |                   je = min( jph * ( n + 1 ), jh )
   332: |                   if ( je >= js ) THEN
   333: |                     jch = je - js + 1
   334: |                     jc  = jch * 2
   335: |                   else
   336: |                     jc = 0
   337: |                     js = 1
   338: |                     je = 1
   339: |                   end if
   340: |           
   341: |       A           a_jmax(n) = jc
   342: |           
   343: V------           end do
   344:             
   345:                   if ( jmax /= a_jmax( myrank ) ) then
   346:                     call MessageNotify( 'M', module_name, &
   347:                       & 'jmax = %d, a_jmax(myrank) = %d.', i = (/ jmax, a_jmax( myrank ) /) )
   348:                     call MessageNotify( 'M', module_name, &
   349:                       & 'jmax is overwritten, and is %d.', i = (/ a_jmax( myrank ) /) )
   350:                   end if
   351:                   jmax = a_jmax( myrank )
   352:             
   353:                 end if
   354:             
   355:               end subroutine GridsetCalcjmax
   356:             
   357:               !-------------------------------------------------------------------
   358:             
   359:               subroutine GridsetCheckNumberOfLatGrid( jc )
   360:                 !
   361:                 ! それぞれのプロセスが担当する緯度格子点数を確認.
   362:                 !
   363:                 ! Check number of latitudinal grids on each process.
   364:                 !
   365:             
   366:                 ! モジュール引用 ; USE statements
   367:                 !
   368:             
   369:                 ! メッセージ出力
   370:                 ! Message output
   371:                 !
   372:                 use dc_message, only: MessageNotify
   373:             
   374:                 ! MPI
   375:                 !
   376:                 use mpi_wrapper, only: nprocs, myrank, &
   377:                   & MPIWrapperISend, &
   378:                   & MPIWrapperIRecv, &
   379:                   & MPIWrapperWait
   380:             
   381:             
   382:                 ! 宣言文 ; Declaration statements
   383:                 !
   384:                 implicit none
   385:             
   386:                 integer, intent(in ) :: jc
   387:             
   388:                 ! Local variable
   389:                 !
   390:                 integer , allocatable :: a_jmax_tmp(:)
   391:                 real(DP)              :: a_SendBuf (1)
   392:                 real(DP), allocatable :: aa_RecvBuf(:,:)
   393:                 integer , allocatable :: a_iReqSend(:)
   394:                 integer , allocatable :: a_iReqRecv(:)
   395:                 integer               :: n
   396:             
   397:                 ! 実行文 ; Executable statement
   398:                 !
   399:             
   400:             
   401:                 if ( jmax /= jc ) then
   402:                   call MessageNotify( 'E', module_name,                                                    &
   403:                     & 'Saved jmax at myrank=%d is %d, but is not same as one calculated by spml, %d.', &
   404:                     & i = (/myrank, jmax, jc/) )
   405:                 end if
   406:             
   407:             
   408:             
   409:                 allocate( a_jmax_tmp(0:nprocs-1) )
   410:                 allocate( aa_RecvBuf(1,0:nprocs-1) )
   411:                 allocate( a_iReqSend(0:nprocs-1) )
   412:                 allocate( a_iReqRecv(0:nprocs-1) )
   413:             
   414:                 a_SendBuf(1) = jc
   415:             
   416:                 ! jmax is sent to all nodes, and received by all nodes.
   417:             
   418: +------>        do n = 0, nprocs-1
   419: |                 if ( n == myrank ) cycle
   420: |                 call MPIWrapperISend( n, 1, a_SendBuf      , a_iReqSend(n) )
   421: |                 call MPIWrapperIRecv( n, 1, aa_RecvBuf(:,n), a_iReqRecv(n) )
   422: +------         end do
   423:             
   424: +------>        do n = 0, nprocs-1
   425: |                 if ( n == myrank ) cycle
   426: |                 call MPIWrapperWait( a_iReqSend(n) )
   427: |                 call MPIWrapperWait( a_iReqRecv(n) )
   428: +------         end do
   429:             
   430:             
   431: V------>        do n = 0, nprocs-1
   432: |                 if ( n == myrank ) then
   433: |                   a_jmax_tmp(n) = jc
   434: |                 else
   435: |       A           a_jmax_tmp(n) = aa_RecvBuf(1,n)
   436: |                 end if
   437: V------         end do
   438:             
   439:                 ! Check number of latitudinal grid in each process.
   440: +------>        do n = 0, nprocs-1
   441: |                 if ( a_jmax(n) /= a_jmax_tmp(n) ) then
   442: |                   call MessageNotify( 'E', module_name,                               &
   443: |                     & 'jmax in proc=%d is %d, but is not the same as saved one, %d.', &
   444: |                     & i = (/n, a_jmax_tmp(n), a_jmax(n)/) )
   445: |                 end if
   446: +------         end do
   447:             
   448:             
   449:                 deallocate( aa_RecvBuf )
   450:                 deallocate( a_iReqSend )
   451:                 deallocate( a_iReqRecv )
   452:                 deallocate( a_jmax_tmp )
   453:             
   454:             
   455:             
   456:               end subroutine GridsetCheckNumberOfLatGrid
   457:             
   458:               !-------------------------------------------------------------------
   459:             
   460:               subroutine InitCheck
   461:                 !
   462:                 ! 依存モジュールの初期化チェック
   463:                 !
   464:                 ! Check initialization of dependency modules
   465:             
   466:                 ! モジュール引用 ; USE statements
   467:                 !
   468:             
   469:                 ! NAMELIST ファイル入力に関するユーティリティ
   470:                 ! Utilities for NAMELIST file input
   471:                 !
   472:                 use namelist_util, only: namelist_util_inited
   473:             
   474:                 ! メッセージ出力
   475:                 ! Message output
   476:                 !
   477:                 use dc_message, only: MessageNotify
   478:             
   479:                 ! 実行文 ; Executable statement
   480:                 !
   481:             
   482:                 if ( .not. namelist_util_inited ) &
   483:                   & call MessageNotify( 'E', module_name, '"namelist_util" module is not initialized.' )
   484:             
   485:               end subroutine InitCheck
   486:             
   487:             end module gridset
